## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Af_ZA v1.1.2;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Af_ZA::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Af_ZA> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package.
The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
ISO8859-1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hyphenation file for Afrikaans
% Copyright (C) 2005  Friedel Wolff
% 
% This library is free software; you can redistribute it and/or
% modify it under the terms of the GNU Lesser General Public
% License as published by the Free Software Foundation; either
% version 2.1 of the License, or (at your option) any later version.
% 
% This library is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% Lesser General Public License for more details.
% 
% You should have received a copy of the GNU Lesser General Public
% License along with this library; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Woordafkapping in Afrikaans
% 
% Kopiereg Friedel Wolff (2005), lisensie: LGPL
%
% Geen waarborg van enige aard nie.
% 
% Weergawe vir altlinuxHyph
% Gebasseer op die WAT, HAT, en reëls van die AWS en 
%         "40 000 woorde" deur GC Bresler
%
% 
%
%
% Uitleg
% ======
% 0.  Notas
% 1.  Algemene voorvoegsels
% 1.  Algemene agtervoegsels
% 2.  Verkleiningsvorme
% 3.  Alle herhalings van konsonante langs mekaar (gg, kk, ens.)
% 4.  Deeltekens
% 5.  Kapies
% 6.  Konsonantkombinasies met b-z (vokale uitgesluit, hoofsaaklik geslote 
%     lettergrepe)
% 7.  Vokaalkombinasies, diftonge, ens.
% 8.  Oop lettergrepe
% 9.  Geslote lettergrepe
% 10. Vaste vorme
% 11. Uitsonderings
% 11. Kombinasies met "ig"
% 12. Kombinasies met "ing"
% 13. Trappe van vergelyking verbuigings
% 14. Grootskaalse konsonantopeenhoping
% 15. Waaghalsige pogings tot samestellings en verbindingsklanke
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 0.  Notas
% =========
% Dit is belangrik dat daar nie te min karakters van 'n woord alleen op 'n reël
% toegelaat word nie. Die verstekwaardes van 3 is waarskynlik goed genoeg dat 
% daar nie foute sal wees nie. Kleiner waardes is riskant, en is moontlik ook 
% sleg uit 'n oogpunt van leesbaarheid. Twee karakters behoort egter nie veel 
% probleme te gee nie. Op enkele plekke is daar selfs reëls vir die afkap na
% die eerste letter van 'n woord. In Afrikaans sal dít waarskynlik nie lekker
% lees nie.
%
% Hier is moontlik heelwat foute. Die volgende gee veral probleme:
%  * samestellings, en veral samestellings met verbindings-s. Hierdie is 'n 
%    groot probleem aangesien woordgrense juis die ideale plek is om af te kap.
%    Die afkap rondom woordgrense by samestellings kan lees bemoeilik. 
%  * leenwoorde
%  * vreemde name en plekke
%  * klanke wat soms een klank is en soms nie, soos sj, gh, tj
%  * verkleiningsvorme, wat in elkgeval maar "bie-tjie" vreemd is
%  * deeltekens maak dinge maklik, maar as ons breek voor hulle, moet die 
%    deelteken verval - nie moontlik nie. Die nuwe AWS maak wel voorsiening vir
%    die behoud van die deelteken, maar ideaalgesproke moet ons dit kan 
%    verwyder, veral in gevalle waar die deelteken slegs vir leesbaarheid 
%    gebruik is.
%  * oop lettergrepe, veral aangesien woorde wat op geslote lettergrepe eindig
%    saamgevoeg kan word met woorde wat op vokale begin
%  * sekere breuke, alhowel hulle korrek is, bemoeilik lees. 
%    Kyk bv. na "vere-".
%  * die interaksie van reëls op mekaar is moeilik om mee tret te hou.
% 
% Plekke waar daar iets staan soos "200 gevalle" is 'n rowwe aanduiding van die
% aantal gevalle in die woordelys waar 'n sekere reël voorkom. Neem dit met 'n 
% knippie sout, aangesien die interaksie van verskillende reëls meestal nie in 
% ag geneem is nie (maar soms wel). Die woordelys is ook 'n bewegende teiken.
% 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Algemene voorvoegsels en dergelike dinge
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
.af1
%GC Bresler se afkappingswoordeboek gee Af-ri-ka, maar A-fri-kaans. 
%Weens die ooglopende inkonsekwentheid, ignoreer ek dit voorlopig.
%Dit sal waarskynlik in elkgeval lees bemoeilik met óf A- óf Af- alleen aan 
% die einde van 'n reël.
%f2ri1ka
f2ri1ca
f2ri1ka
.af2o1r


.ag1te
.agter1uit

.an1ti1

.be1
.be2d1l
.be2d1s
be4e
be2l.
be1la
be1le
be1li
be1lo
be1lu
%sien ook berg by rg
be2ld
be2n1de
be2n1s
%sien ook e2s3te. onder. (Vir woorde soos beste, neste, ens)
.as1be2s3
.as1b
be2r
be3ra
be3re
be3ri
be3ro
be3ru
be3ry
be2s1g

.er1
.er2e1
.er2i1
.er2o1
.er2u1
.er2f11
%erts
.er2ts1
.er2t1s2e

.per1
.pe1r2a
.pe1r2e
.pe1r2i
.pe1r2o
.pe1r2u
.per2s
%sien persoon by vaste vorme

1ties.
1tie1se.

%%%%%%%%%%%%%%%%%
%ver 
%%%%%%%%%%%%%%%%%
ve2r1
ve2r1a2
%klomp gevalle wat heel deurmekaar is: vergelyk bv.  verebed vs. veredel
%verder kan ons ook nie ná vere breek nie, omdat vere-del lees baie bemoeilik,
%al is dit 'n geldige sillabegrens
ve2r2e4
%sien ook ere by oop lettergrepe
%veree- werk wel:
ve2r3ee
%motiverend
ve3r4end
%hanteer 'n paar belangrike gevalle:
%verenig, vereniging, ens:
%eintlik kan ons ve2r3e3ni gebruik, maar wil nie vere-niging hê nie.
ve2r3e4ni
%vereffen
ve2r3effen
%vererger
ve2r3er
%vereiste
ve2r3eis
%vereuropees (vereu breek noodwendig na die r anders was koppelteken nodig)
ve2r3eu
%-vere werk wel (bv. hoendervere):
ve5r4e.

%sien ook rf elders vir verf

%eri werk selde as ver-...
ve3r2i
%wel 'n paar uitsonderings
ve4r3inne
ve4r3itali1aans
%verifikasie
%ve3r2i1f
%vering
%ve3r2ing
%veritas
%ve3r2i1tas
ve2r1ont3
ve4r3uit

%her
he2r1
he2r2a
he2r2e
%inherent
he3rent.
%inherente
he3ren1te.
he3ren1tes.
%herfs
her4fs1
he1r2ing
%heringestel
.he4r5ing
he1r2o
he2r3ont1
he2r1uit1

.i1m2a
.i1m2i
.im1

.in3
.i1n4er1
.i1n4i1
.in4k3b 
.in4k3p
.in4k3s
.in4k3t
.in4k3v
.in4s3gelyk

.on1
.o1n2ik
.o2n1in1ge
n4s.
1on2t1
% .ont gevolg deur [aeiouy] is moeilik. Ons los dit vir eers
on3t2a
on4t3aar
on2t2e
.on2t3eer
.on2t3ei
.on2t3e2r
on2t2i
on2t2o
.on3t2o
on2t2u
on3t2uu
on2t2y

3on2t1d
3on2t1l
o4on2t1l
3on2t1ru
3on2t1st
3on2t1t
%kanontoring:
on1t2o1ring
3on2t1pl
3on2t1w

4s1ont1
5s2on3ta

b2ont
bon1te
d2ont
don1te
f2on3tein
fron1te
k2ont
kon1te
%2k3ont1w
%^onnodig weens streek by vaste vorme
a2k3ont1
l2ont
lon1te
kl4ont
klon1te
a2l3ont1
e2l3ont1
i2l3ont1
o2l3ont1
u2l3ont1
m2ont
mon1te
o2on1te
p2ont
r2ont
fr4ont
t2ont
ton1te

%sien kontant, kontinent, kontrak, kontak, kontrole, kontras, kontoer, kontrei by vaste vorme

on2t3h
n4t.

%TODO: eerste 1 onnodig?
1ge1
ge2e
ge2i
ge2i1ger1
ge2l
ge3la
ge3le
ge3li
ge3lo
ge3lu
ge3ly
ge2n
ge3na
ge3ne
ge3ni
ge3no
ge3nu
ge2m
ge3ma
ge3me
ge3mi
ge3mo
ge3mu
ge3my

ge2nt

%ge2r1m
%ge2r2d
%bur1ge2r
ge2r
ge3r2a
ge3r2e
ge3r2i
ge3r2o
ge3r2u
ge3r2y
%TODO: kyk met meer samelstellings later
win1ge2r2d1
win1ge
ge2r3de
ge2r2s
ge2s1pe.

.na1ge1

mis1
mi1s2a
mi1s2e
mi1s2i
mi1s2o
%TODO: u,y?
.om1
.om2a
.om2e
.om2i
%TODO: nog?
hie2r3
%.uit
.ui2t1
.ui2t1een
.ui3t2en1h
.ui3t2er


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Algemene agtervoegsels en dergelike dinge
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
baar3de
baar4d
3baar3
1ba1re
by1
by2n
by3n2a
by3n2e
by3n2i
%.by1
%.by1te
.by2t1s
by2s1ter
3dom.
1liet
%1v2liet
1lik
b2lik
1li1ke
p2li1ka
3lik3he
5he3de
3heid1
hei1d2e
hei1d2i
%TODO: dalk ooroptimisties
heid2s1
heid5s4er1ti1
%3in.
3loos.
1lo1se.
1naar
s2naar
3ryk.
3ry1ke.
3ry1ker.
3ry1kes.
n5k6ryk

%vroulike vorme:
%1ster.

1têr

.toe1
.toe2n1
.toe3n2a
.toe3n2e
.toe2ts1

.toe2r1
.toe3r2a
.toe3r2e
.toe3r2i
.toe3r2o
.toe4r3ou
.toe3r2u
.toe3r2y

1mal
s2mal

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Verkleiningsvorme
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Gewone vorme met -tjie is in party gevalle selfs vir 'n mens onmoontlik sonder
%konteks, byvoorbeeld houtjie.

%Sien ook n1ki by verbindings met n
%Sien ook d1j by verbindings met d
'5t2ji
m3pie.

%ltjie
%lt word by l gedoen

%ntjie
aa2n1tji
ant1ji
jan1t2ji
man1t2ji
een1tji
ein1tji
eon1tji
eun1tji
iënt1ji
%probleem: elektrisiëntjie, optisiëntjie
oen1tji
oon1tji
uen1tji
uin1tji
yn1tji

%rtjie
ar1tjie
kaar1t2ji
vaar1t2ji
smar1t2ji
har1t2ji
kwar2t1ji
eer1tji
eur1tji
be4ur2t1ji
be4u
koor1tji
oer1tji
oir1tji
uer1tji
uur1tji
buur2t1ji

aat3ji
ai1tji
ei1tji
eu1tji
ia1tji
fia2t1ji
fi1a
lia2t1ji
li1a
io1tji
atriot1ji
nge1tjie
oa1tji
oet1ji
oot3ji
ue1tji
due2t1ji
nue2t1ji
uit1ji
.ui3t2ji
bui1t2ji
%klein buit?
krui1t2ji
trui1t2ji
uut1jie
%1t1jie

%oorweeg
%eo1tjie


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Alle herhalings van konsonante langs mekaar
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
4b5b4
4c5c4
4d3d4
%eisteddfod en verbindings daarmee:
ei5s2te4d4d5
eis1te
ei1s2tee
4f3f2
%Graaf-Reinet
4f4f.
4f4f3d
4f4f3m
4f4fs
4f4f3w
4g5g4
4ghg4
4k5k4
%bietjie uitsonderings met Engelse plekname
4l3l4a
4l4l1c
4l4l1d
4l3l4e
4l4l1g
4l3l4i
4l4l1p
4l3l4o
4l4l1r
4l4ls
4l3l4u
4l4l1v
4l3l4y
4m5m4
4n3n4
4n4n.
4n4n5l
4n4n5h
4n4n5r
4n4ns
4n4n5v
4n4n5w
4p5p4
4r5r4
4s5s4
4t5t4
%TODO:watt en verbindings
%wa4t6t4s
%wa4t6t.
4w5w4
4z3z2
%jazz en verbindings daarmee
jaz4z3

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Deeltekens dui begin van lettergreep aan
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Deeltekens maak dinge maklik, maar as ons breek voor 'n deelteken, moet die 
% deelteken verval - nie moontlik sover ek weet nie.
5ä
5ë
5ï
5ö
5ü

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Kappies gewoonlik aan einde van (oop) lettergreep
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ê1
ê3e
ê4r
ê5re
û3e
%ô1
ô3e



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= b =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2b1d2
2b1f2
2b1g2
2b1h2
2b1j2
2b1k2
%1215 gevalle:
1b2l2
%Grobler
ro2b3ler
%Kibler
i2b3ler
2b1m2
2b1n2
2b1p2
1b2r
su2b3
su3b4iet
su3b4li
gesu3b4iet
gesu3b4li
b2s.
b1s 
%probleme met enkele samestellings
%habsburger
b2s1b
b2s1d
%b2s1g
b1t
b1v
b1w

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= c =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c2h
1c2hr
1ch2a
1ch2e
è2che
1ch2é
1ch2i
1ch4o
1ch2u
1ch2y
c2i
c2l
c2k
c2r
c1t
1c2e
%worcestersous
4o4r4c4e4s1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= d =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2d1b2
2d1c2
2d1f2
2d1g2
%plekname soos Allanridge
rid4ge
2d1h
2d1j2
.d2j
%enkele belangrike eiename gee probleme
abi1d2jan
i1li1man1d2ja1ro
mo1d2ja1d2ji
2d1k2
2d1l2
2d1m2
2d1n2
2d1p2
%ds gevolg deur [aeiou] is moeilik weens verbindings-s
%verbindings met s (sien onder) gaan vir 'n klompie sorg
d1saa
%d2s2a
%d2s2e
d1se.
%d2s2i
%d2s2o
%d2s2u
d1sy
d2s1ywer
d2s1ys1ter
2d1t2
2d2t3p
2d1v2

2d1w2
3d2waal
3d2waas
3d2weil
3d2werg1
3d2wer1g2i
3d2welm
3d2wing
3d2wong
2d1wu
r3d2wyn

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= f =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
f1b
2f2d.
f1d
f1g
f1h
f1j
f1k
%fl lyk problematies met woorde soos flerk, flos
f1m
f1n
f2n2ui2k
2f1p2
%f1r sal moontlik probleme gee met woorde soos front, frekwensie, fragment, ens
f1ro
f1rok1k
1f2r4ok1ki
%probleem: kry nie halfrokkie nie
1f2r4ont
%.f2r2ont
%1f2r2ont.
%f2r2on1ta
%f2r2on1te
f2s1f
%Dalk probleem met verbindings met ^sf
f1t
f2t.
delf2t
f2talaat
f1v
f1w


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= g =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
g3b
g1da
g1de
g1di
g1do
g1dr
g1du
g1dy
g2d1h
g1f

%voor h word byna altyd gebreek. Heelwat probleme, maar soveel voordele as ons 
%dit wel hanteer.
g1h
%woorde soos gholf
.g4h 
%'n hele paar probleme met samestellings met .gh-woorde. Hanteer 'n paar:
% ghitaar, ghetto, gholf, ghries, ghwano, ghwar (apart hier t.w.v. 
% samestellings)
g4hi1ta
g4het1to
g4holf
g4hong
g4hries
g4hwa1no
g4hwar
%ook sorghum:
sor1g4hum
%dagha: (nie dagga nie, bouklei)
da1g4ha
g4hai
%Sou miskien voor ghie kon breek, maar gevolge vir samestellings?
g4hie

2g3j2
2g3k2
2g1lê1
g1lu
g2lun
g2luu
2g3m2
2g3n2
%probleem: gegnostiseer
2g3p2
%n2g1r
2g3t2
%digtheid:
g4th
g4t.
g1w
g1z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= h =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%TODO: kyk, was 3h6
1h4
%gh word by g hanteer
c2h
%whisky word by w hanteer

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= j =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%sien verkleiningsvorme en kombinasies met t

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= k =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2k3b2
2k3d2
2k3f2
2k1g2
2k1h2
2k1j2

%TODO:TODO:kla, lkl
1kle
2k1leer.
2k1leer1d
2k1leer1l
2k1lei1er
ba3k2lei1e
ba1kle
2k1len
2k1leun
2k1le1we1ri
1kle1we
e1k2li
2k3lig
2k3lik
1klo
2k1lo1ka
2k1loop
si3k2loop
si1klo
2k1lo1per
1klo1pe
2k1loos
3k2loos1t
2k1lo1r
3k2lo1ra
2k1los
l3k2los
s3k2los
t3k2los
1klu
2k1lui.
2k1luid
2k1lui1e
2k1lus
3si3k2lus
oo2k1l
n2k1lug
n1klu
u2k1lug
u1klu
3k2lu1si
%probleem: stiklug? lyklug?

2k1m2
2k1p2
k1sa
k2s1aan
k1se
k2s1een
%sien ook eksamen by vaste vorme
k2s1er1v
%ksi: 980 gevalle. riskant, weens verbindings-s
k1si
k2s1in1k
k2s1in1s
k1so
k2s1om1d
k2s1om1g
k2s1om1s
k2s1on
k3s2on.
k3s2on1b
k3s2o1no
k2s1oond
k2s1oor
k3s2oort
k4s3oor1tr
k2s1op1
k3s2op.
%probleem: volksowerstes
2k4t.
2k4t3v
%kyk na t se moontlikhede?
2k4t3l
%volmaaktheid
2k4t3h
2k3t2
2k1v2

luk1w
k1wag1t
1kwo
2k1w2oe
2k1w2or
3k2w2o1ru
k1wu
%TODO:kwy
k1wys

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= l =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

l1b
l1c
l2d.
l1da
l2d1aan1b
l2d1af1
l3de
l1di
l2d1in
l3d2in.
l3d2ing
l3d2i1na
l3d2in1n
l1do
l2d1of
l2d1oor1d
l2d1oor1l
l2d1oor1s
l1du
l2d1uit1
l1dy
l2d1ys
%sien geld by vaste vorme t.w.v. geldeenheid
%TODO: lf[aeiouy] ?
.hal2f1
.hal2f1e2
.hal3f2i
.hal2f1u2
sel2f3

l1fa
l1fe
l3f4ees
l2f1eeu1
l2f1erts
l1fi
l1fo
sel3f6oon
sel3f6one
l2f1oond
l2f1o2p1o
l1fu
l2f1uu
l1fy

l1ga
l2g3b
l1ge
l1gê
2l1gi
l1go
l2g1or1de.
l2g1or1des
l1gor1d
l1gr
2l3h2
2l3j2
2l4k.
l2k3t
%l1k[aeiou] kan probleme skep met samestellings, maar is dalk meer werd as wat dit probleme sal skep. 
2l1ka
2l1ke
2l1ki
2l1ko
2l1ku
2l1ky
%l2m.
%l2m2s.
l1ma
l2m1af1
l1me
l1mi
l1mo
l2m1op
l3m2ops
l1mu
l1my
%TODO: sit film by vaste vorme
%film, dwelm, palm, kalm, skelm, helm, walm, weergalm, salm kan dalk probleme 
%gee
2l1n

%TODO: gaan na:
l1p
ulp1b
ulp1d
ul1pe
%probleem: eerstehulpeksamen
ulp1f
ulp1g
ulp1h
ul1pi
ulp1j
ulp1k
ulp1l
ul1p2la
ulp1m
ulp1n
ulp1p
ulp1r
ulp1s
wulp2s1
wulp3s2e
wulp3s2te
ulp1t
%bv. nulpunt:
ul1pu
ulp1v
ulp1w
ulp1z

l1r
2l1t 
2l2t1s
%probleem met alt... 
%TODO:kyk na t se moontlikhede soos by kt
.al2t1
.al3t2a
.al3t2e
.al3t2i
.al3t2y

fal2t
fal3teer
l2t.

l1v
l1w

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= m =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m1b
m1c
m2d.
m1d
m2d1h
m1f
nim2f
triom2f
lim2f
m1g
m1h
m1j
m1k
m1l
m1n
aam1p
m1pa
m1pe
m1pi
m1pl
m1po
m1pr
m2p1rok
m1pu
m1py
m1r
%TODO: ms
m1sa
m2s1ak1t
m2s1ap1p
m1se
%bileamsesel:
m2s1e2s
m1si
m1so
m2s1oe
m2s1om
m2s1op
m2s1or
m1sta
m1ste
m1sti
m2s3tig
m1sto
m1stu
m1su
m1t
m1v
m1w
%m1y behoort te werk - daar is min samestellings waarvan die tweede
%deel op y sal begin. 
%m1z vir leenwoorde uit Zoeloe?


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= n =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n1b
%Moontlik probleme met leenwoorde
n1c
%Rennaissance:
san2c
n4d.
%n1d
n1da
n2d1aan1
n3d2aan.
n1de
n1dê
n1di
%probleem: bando... brando... lando...
n1do
on4d1om
on5d2o1me
on1do
n2d1ont
n2d1op1b
n2d1op1n
n2d1op1l
n3d2op1lu
n2d1op1p
n2d1op1s
n1du
n1dy
%n2db
%n2dd
%n2ds
%nd gevolg deur [
%ndr is moeilik
%n2d2r
n1dra
%probleem:  ...d-rank, landras
nd1rat
nd1rand
nd1re
n1d2rea
n1d2rew
%probleem: aandrentel
n1dri
n2d1riem
n2d1rigt
%TODO: ndro - bietjie moeilik
n1dru
n2d1rug
n2d1ruit
n1dry
n2d1ry.
n2d1ryk
n2d1rym
%n2dv
n1f

n1ga
n2g1aa
n3g2aan
man5g4a4a4n1
man1ga
n4g3aanb
n4g3aand
n4g3aan1h
n4g3aan1v
n4g3aan1w
n2g1af
on3g2aar
%todo: laaste 1?
n1ge1
n1gi
n1go
n2g1oef
tin2g1o
n2g1on
n2g1oo
n3g2ooi
n2g1ou
ng1se
n1gu
n2g1uit
aan5g4
een5g4
.in5g4aan
oon5g4
%sien belasting, ketting, rigting, vesting by vaste vorme
%TODO: Bangladesj
n1gl
n2g1lik
an2g1l
an3g2li
an3g2lo
in2g1l
in2g2las
.in1g2l
jon2g1l
ton2g1l

n1h
n1j
n1ka
n2k1aan1va
n1ke
%TODO: dalk te spesifiek:
n2k1e2f1f
n2k1eien
n2k1ele
n2k1eks3
n1ki
n2k1in1h
n2k1in1s
%TODO: toets meer
n1kli
n2k1lied
n2k1lik
nk1s
nk2s1h
nk2s1om1
%0 gevalle:
%een1k
oen1k
n1l
n1m
n1p
n1r
%ns is moeilik weens verbindings met woorde wat op ns eindig (wins, mens, 
%diens, kuns, ens :-)
%ensi: 660 gevalle
n1sa
n2s1amp
n2s1aap
%probleme: TODO: dansakademie, eenkansassessering, kunsaspirasies, mensaap
n1se
n2s1eie
n2s1er1va1r
n1ser1v
%probleem: lewenseise
n1si
n2s1in1r
n1so
n2s1oog1
n2s1oord
n2s1oor1g
n2s1oor.
n2s1op1
%probleem: sampioensop
n1su
n2s1uit1
n2s1ui1t2i
n1sy
%n1t kan problematies wees met verbindings met kant, punt, plant, bont, ens.
n1ta
n2t1aar
n3t2aar.
n3t2aar1v
n2t1as1s
n1te
n2t1een1h
n1ti
n2t1in1n
n2t1in1s
n1to
n2t1ont1
n2t1ope
n2t1op1n
n2t1op1p
n2t1op1r
n2t1op1s
%probleem: eentoppig, plantolie
n1tru
n2t1rub
nt1sa
nt1se
nt1si
nt1so
nt1su
nt1sy
n1ta
n4t3aan1v
n3t2aan
n1tu
n2t1uit1
n3t2ui1t2i
n1ty
%probleem:enkeles werk nie
n1v
n1w
n1z

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= p =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2p1b2
2p1c2
2p1d2
2p1f2
2p1g2
%p1h gee probleme met vreemde name soos Alphenpark, Boiphatong en Gopher
2p1h2
2p1j2
2p1k2
%TODO: pl
1pla
2p1lam
3p2la1mu
%TODO:
2p2land
%probleem: beplande ens. vs kaapland
2p1lap
%1plaa
%probleem suiplap, suiplam, kaplat, koplamp
2p1m2
2p1n2
p2neu1ma1
p2neu1mo1
p1sel
2p1t2
p2t3heid
%pterodaktiel, ptomaïen
.p2t
2p1v2
2p1w2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= r =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2r3b2
2r3c2
%r1d lyk goed, maar verbindings met aard- an andere sal probleme gee
%ignoreer eers party gevalle wat voorafgegaan word met aa of oo
r1da
aar2da
2r1de
aar2de
2r1di
%dalk onnodig:
%aar2di
2r1do
aar2do
2r2du
aar2du
r1dr
2r1dy
2r1f2
%erf, kerf, verf, werf, nerf, amorf, durf, turf
2r2f.
e2r2f
oe2r3f
ë2r2f
ve2r2f1
ve4r5f4erm
ve4r5f4ilm
ve4r5f4lou
ve4r5f4rom
ve4r5f4oe
ve4r5f4om
ve4r5f4raai
ve4r5f4rans
ve4r5f4ris
ve4r5f4yn
wer4f
dur4f
kor4f
mur4f
skur4f
tur4f

2r1g2
2r2g3lu
2r2g.
ar2g1l
ar2g1w
ar1g
r2g1d
r2g2d.
bo2r2g
bor3ge
so2r2g
sor3ge
%sluit 'n paar korrektes uit, maar voorkom sommige verkeerdes:
%berg, burg, murg, wurg
be2r2g1
be2r3g2e
be2r4g3eng
bu2r2g
bur3ge
mu2r2g
mur3gie
wu2r2g
2r1h2
r4ho1desi
2r1j2

r1ka
r2k1aan1b
r2k1aan1d
r2k1aan1w
r2k1adre
r1ke
r2k1er1va1r
r1ker1v
r1ki
r2k1in1l
r2k1in1s
r3k2in1so
r1kli
r2k1lid
r2k1lied
r2k1lik.
r2k1li1ke
r2k1li2k1h
r1klik
%probleem: handwerklinne
r1ko
%r2k1ont1l
ar2k1oor
ar3k2oord
ar1ko
r2k1op1d
r2k1op1na
r2k1op1er1
r1kop1p
r2k1op1s
r1ku
r2k1uit1
%sien werk by vaste vorme
r1ky
r2k1y2w


2r1l
paar2l
ier1m
r1ma
r2m1aan1h
r2m1af1d
r2m1af1s
r1me
r2m1en1gel
r1mi
r1mo
r2m1ont1
r3m2ont.
r3m2on1t2a
r1mu
r1my
r2n.
2r1n2
%barnsteen, ernstig, ens.
2r2n3s2t2
t2oor2n
ker2n
ker3ny
lan1ter2n
lan1te
lu1ser2n
%werk redelik TODO:kyk weer
r1p
2r1pr
dor2p
dor3pe
or1p
or2ps
or2p1sie
r2p1s
r2p2s1h
r2p2s1v
r3p2si1g
r4p3si2g.

r1sa
r2s1aar1
r2s1af1
r2s1ad1v
r2s1ak1t
%sien amp by vaste vorme
%ander reël êrens sorg vir rsaan
%probleem: garsaar?
r1si
r2s1in1du
r2s1in1m
r2s1in1ko
%TODO: rso
2r1su
r1sy
r1ta
r2t1aan1d
r2t1aan1v
2r1t2e
2r2t3eend
2r2t3eeu
2r1t2i
%rv word ook by v gedek
2r1v2
2r1w2

2r2z.
2r1z2

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= s =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Baie van hierdies het is verbindings met 'n verbindings-s
s3b
.s4c
s4ch
2s1d
s2d3h
s4d.
2s1f
%TODO: besluit waar om te breek:
s2feer
s2fer
2s3g2
%s1h werk goed vir alles wat werklik Afrikaans is. Leenwoorde gee probleme.
s1h
.s2h
s2h.
%s1j sou kon werk, maar die sj-klank word gereëld vir oorgeklankte woorde 
%gebruik waar dit nie gesky kan word nie
s1ju
%XXX:HAT en Bressler gee bro-sju-re  -  ek stem nie saam nie
%f1s2k en ander met sk sou miskien kon werk, maar samestellings gee probleme
1slaa
2s2laag
is1m
s1pu
1s2pu.
1s2pul
1s2puis
1s2puit
1s2puug
2s1r
%ste: 1000 gevalle
s1te
%sv word by v gedek
s1w
1s2waai
1s2wael
1s2war2t1
1s2war3t2e
1s2war4t3ee
1s2war3t2i
1s2wam
1s2weef
2s3weef1sel
1s2weet
1s2weis
1s2wem
1s2wel
2s3wel1syn
1s2wenk
1s2werf
1s2werm
1s2we1we
%probleem ...wewer
1s2woeg
1s2wik
1s2wyg



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Konsonantkombinasies met -= t =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
2t1b
t1c
t2ch.
2t3d
2t1f
2t1g
r4t1g
2t1h
%heelwat Engelse en Zoeloe-name bly in gedrang
%Blackheath, ens:
eat2h
t2h.
%TODO: meeste van hierdies is gebasseer op GC Bresler
%Dit is maar bietjie vreemd
%Bethlehem
e2t2h1le
et1h
.et2h
be1t2h
be2t3hal
be2t3hel
%Athene:
a1t2hen
%Enkele name
m3t2h
3t2ha.
3t2he.
3t2hi.
3t2ho.
3t2hu.
3t2hy.

%TODO: effek op verkleiningsvorme?
t1j
%verkleiningsvorme:
t2ji
%tjek, tjello, tjiriktik
t2je
1tjek
%TODO: nodig?
uit3j
2t1k2
2t1l2
2t3m2
2t1n2
2t1p2
2t1v2
.t2wak
2t1wa
t1wi
t2win
t3wind
t2wis
1uit1wis
2t1wo
t1wy
t2wy1fel
%laat vaar soetwyn, ens ter wille van twyn
%TODO: beter?
t2wyn

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kombinasies met -= v =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
3v4

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kombinasies met -= w =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%meeste van hierdies is waarskynlik net nuttig vir verbindings met plekname
%Hillbrowgebou, ens. asook vreemde plekname self. (New-lands, Willow-more, ens)
w1b
w1c
w1d
w1f
w1g
w1h
1w2his1ky
w1j
%Name soos -hawk:
%wk
w1l
%-town, township, ens.
w2n
w1p
%ontwrig, gewrig, ens.
1wri
%Blairgowrie, Meadowridge
o2w1r
%Ook nuttig vir verafrikaansde name vanaf Russies
w1s
touw2s1ri1vier
louw2s1burg
w1t

%w4a
%w4e
%w4i
%w4o
%w4u
%w4y


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Kombinasies met -= z =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
1z2
hert2z


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Vokaalkombinasies, diftonge, ens.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Gevalle soos ie, ei en oe word feitlik altyd vasgeskryf. By samestellings 
%sal koppeltekens noodwendig altyd gebruik moet word.
%Sommige van die wat wel afgekap word, bemoeilik dalk lees. bv kre-atief

a4a4
a3e
a4i
a3o
a2u

e1a
e4e
e4i
e3o
e4o1g
e5o2g1g
e2u

i3a
i2e
i3i
i3o
i4o1g
i3u

o3a
o4e
o4i
o4o2
%sien karoo by vaste vorme
o4u

u3a
u3e
u2i
u3o
u4u4

a4a4i
a4i3e
a4i2d
a4i3de
a4i3du
a4i3do
au1e

ei1e
%ganseier
s3ei2er.
s3ei2ers.

e4e4u
e4e4u3i
e4e4u2s
e4e4u3se

e3ui
i4e4uing

i3ee
i1eu
i2e3ui
i2eu.
ni2eu
ki2eu
%net samestellings met uur
i2e3uu


o4e4i1
o4e4i1s2
oei2d.
%TODO: ???
boei4ng
oi3e
o4o4i1
mooi2s.
%turkoois:
kooi2s
ooi2t.
ou3i

u2i3e


y1aa
y1er
y1ee
%yo: 
y1o
%Baie probleme met Zoeloe- en ander leenname
%Hanteer 'n paar hier:
ny2o
a1y2o
y1u
ny2u


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Oop lettergrepe
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 'n Hele paar van hierdies is gewaagd a.g.v samestellings. Ons kyk maar.
% Meeste is in die vorm van [:vokaal:][:konsonant:][:vokaal:] met stelle 
% uitsonderings
% Hierdie word gesorteer volgens die konsonant
% Die volgende bash-skrip genereer 'n geraamte wat gebruik kan word.
% Dit maak die aanname dat alle lettergrepe oop is. 
% (Die voorbeeld is vir [:vokaal:]t[:vokaal:]
% for i in a e i o u y ; do for j in a e i o u y; do echo -e %$"$i"t"$j":  gevalle\\n%"$i"1t"$j"; done; echo ; done

% sub word by b hanteer

ie1b

%aba: 350 gevalle
a1ba
%abe: 490 gevalle
a1be
%abi: 210 gevalle
a1bi
%abo: 225 gevalle
a1bo
%abu: 40 gevalle
a1bu
%aby: 20 gevalle
a1by

%eba: 400 gevalle
e1ba
%ebe: 740 gevalle
e1be
%ebi: 290 gevalle (meeste daarvan is -gebied)
e1bi
%ebo: 830 gevalle
e1bo
e2b1ont1
e3b2ont.
%ebu: 125 gevalle
e1bu
%eby: 35 gevalle
e1by


%iba: 165 gevalle
i1ba
%ibe: 180 gevalle
i1be
%ibi: 100 gevalle
i1bi
%ibo: 130 gevalle
i1bo
%ibu: 60 gevalle
i1bu
%iby: < 5 gevalle
i1by

%oba: 60 gevalle
o1ba
ô1ba
%obe: 90 gevalle
o1be
%obi: 125 gevalle
o1bi
%obo: 75 gevalle
o1bo
%obu: 30 gevalle
o1bu
%oby: 15 gevalle
o1by

u1ba
% skubagtig:
u2bagt
%ube: 170 gevalle
u1be
%ubi: +- 30 gevalle
u1bi
%ubo: 35 gevalle
u1bo
%ubu: 30 gevalle
u1bu
%uby: < 5 gevalle
u1by

%yba: 50 gevalle
y1ba
%ybe: 130 gevalle
y1be
%ybi: < 5 gevalle (miskien meer met samestellings, by- ens.)
y1bi
%ybo: 25 gevalle (+samestellings)
y1bo
%ybu: 5 gevalle
y1bu
%yby: < 5 gevalle (-byeenkoms)
y1by


%TODO: alles met c moet nagegaan word
%aca: gevalle
%a1ca
%probleem: macadam
%ace: gevalle
a1ce
%aci: gevalle
a1ci
%aco: gevalle
a1co
%acu: gevalle
a1cu
%acy: gevalle
%a1cy

%eca: gevalle
e1ca
%ece: gevalle
e1ce
%eci: gevalle
e1ci
%eco: gevalle
e1co
%ecu: gevalle
e1cu
%ecy: gevalle
e1cy

%ica: gevalle
i1ca
%ice: gevalle
i1ce
%ici: gevalle
i1ci
%ico: gevalle
i1co
%icu: gevalle
i1cu
%icy: gevalle
%i1cy

%oca: gevalle
o1ca
%oce: gevalle
o1ce
%oci: gevalle
o1ci
%oco: gevalle
o1co
%ocu: gevalle
o1cu
%ocy: gevalle
%o1cy

%uca: gevalle
u1ca
%uce: gevalle
u1ce
%uci: gevalle
u1ci
%uco: gevalle
u1co
%ucu: gevalle
u1cu
%ucy: gevalle
%u1cy

%yca: gevalle
%y1ca
%yce: gevalle
%y1ce
%yci: gevalle
%y1ci
%yco: gevalle
y1co
%ycu: gevalle
%y1cu
%ycy: gevalle
%y1cy


%ada: 100 gevalle
a1da
aa2d1a
a2d1aa
%Ramadaan:
a1ma3d2aa

%ade: 1000 gevalle
a1de
%Ter wille van samestellings (verloor nie nuttige gevalle nie)
%soos saadeter
aa2d1e2
%adi: 600 gevalle
a1di
aa2d1i
%ado: 135 gevalle
a1do
aa2d1o
%adu: 100 gevalle
a1du
aa2d1u
a2d1uit1
%ady: 35 gevalle
a1dy

%eda: klomp reeds gedek met be- en ge-
%Probleem: Alicedale
e1da
%T.w.v. wreedaard, eedaflegging, ens.  'n Paar goeies bly in die slag:
ee2d1af
ee2d1aar
ee1da
%sien ook bloed by vaste vorme.
%ede: 2800 gevalle
%hierdie lyk te goed om waar te wees. Miskien probleme met samestellings, 
%maar ek dink amper nie so nie.
e1de
%edi: 1500 gevalle
e1di 
%sien ook bloed by vaste vorme, miskien
%edo: 400 gevalle
e1do
%sien bloed, spoed, ens. by vaste vorme
%edu: 260 gevalle
e1du
e2d1uit1n
%edy: kool dalk nie die sous werd nie

%ida:110 gevalle
i1da
%ide: 990 gevalle
i1de
%t.w.v. plekname soos Morningside:
si2de.
si1de
%okside:
k1si3de
%idi: 590 gevalle
i1di
%ido: 45 gevalle
i1do
%suidoos, huidopening:
ui2d1o
%idu: 65 gevalle
i1du
i2d1uit1
%sien bid by vaste vorme

%oda: 50 gevalle
o1da
%doodarm, potloodaantekening:
oo2d1a
%ode: 770 gevalle
o1de
%broodeters, doodeenvoudig
oo2d1e
roo3d2e
%net vir ingeval dit nie kassensitief is nie:
broo4d3e
%odi: 295 gevalle
o1di
%odo: 65 gevalle
o1do
%noodoproep
oo2d1o
%sien karoo by vaste vorme
%odu: 350 gevalle
o1du
o2d1uit1

%ud - sien ook goud- by vaste vorme
%uda: 70 gevalle
u1da
%ude: 500 gevalle
u1de
%udi: 500 gevalle
u1di
%udo: 30 gevalle
u1do
%udu: baie min gevalle, hoofsaaklik Zoeloename
u1du
u2d1uit1

%yda: 25 gevalle
y1da
%yde: 240 gevalle
y1de
%ydi: 200 gevalle
y1di
%ydo: 10 gevalle
y1do
y2d1oog
%sien tyd by vaste vorme
%res het geen gevalle (_dy) in woordelys nie
%ydu: geen gevalle
%sien wel wyd by vaste vorme



%afa: 40 gevalle
a1fa
a2f1aard
%afe: 375 gevalle
a1fe
aa2f1e2
%afi: 305 gevalle
a1fi
%afo: 80 gevalle
a1fo
aa2f1o2
a2f1oor1
a2f1oef
a3f2oe1fel
%afu: gevalle
a1fu
a2f1uu
%afy: gevalle
a1fy

%efa: 130 gevalle
e1fa
%moontlik: ('n sekere tipe paling?)
%bee2f1aal 
oe2f1a
toe3f2a
%efe: 235 gevalle
e1fe
%sien oefen elders
%efi: 145 gevalle
e1fi
ee2f1i
%efo: 220 gevalle
e1fo
e2f1ont1
e3f2on1t2ei
%probleem: lee-f-ontwerpe
%efu: 15 gevalle (meeste met ge... in elkgeval)
e1fu
e2f1uit1
%efy: 5 gevalle (ook gehanteer met "yster")
ef1y

%ifa: 90 gevalle
i1fa
i2f1aa
i3f2aal
i3f2aat
%^^ Dalk eerder net i2f1aan1 as hierdie drie
gi2f1a
ui2f1a
%Miskien bietjie waaghalsig:
i2f1ar
%ife: gevalle
i1fe
i2f1eend
i2f1ei
%ifi: 355 gevalle
i1fi
skri2f1i
%ifo: 65 gevalle
i1fo
%ifu: 20 gevalle
i1fu
i2f1uit1
%ify: 0 gevalle
%i1fy

%ofa: 70 gevalle
o1fa
oo2f1a
ho2f1a
ho2f1aan1
%pofadder
o2f1ad
%ofe: 105 gevalle
o1fe
oo2f1e2
%ofi: 225 gevalle
o1fi
oo2f1i2
o2f1in1
%ofo: 120 gevalle
o1fo
o2f1ooi
oo2f1o
%ofu: 7 gevalle
o1fu
o2f1ui
%ofy: < 5 gevalle
o1fy

%ufa: < 5 gevalle
u1fa
%ufe: 10 gevalle
u1fe
%ufi: < 5 gevalle
u1fi
%ufo: 15 gevalle
u1fo
%ufu: < 5 gevalle
u1fu
%ufy: 0 gevalle
%u1fy

%yfa: 20 gevalle
yf1a
%Mayfair
ay1f2a
%syfabri...
sy1f2a
%yfe: 160 gevalle
y1fe
y2f1ei
3s2y1fe
%sien heids elders
%yfi: 75 gevalle
y1fi
%yfo: 8 gevalle
%TODO:
%y1fo 
y2f1oes
y2f1olie
y2f1or
%yfu: 1 geval (vyfuur)
yf1u
%yfy: < 5 gevalle
yf1y




e1pa
ee2pa
%Sien ook -agtig by vaste vorme

%aga: 225 gevalle
a1ga
aa2g1a2
a2g1aan
a3g2aan.
a2g1aar
a2g1are
1a2gaat1
a2g1af
%probleem: jagarend, nagadder, oordragakte, slagaderlik, smaragakedis, 
%	suffragaanbiskop
%age: 335 gevalle
a1ge
a2g1een
1a2gent
%Ter wille an woorde van Franse herkoms wat nie gebreek moet word nie
a2ge.
sa3ge.
ha3ge.
%probleem: vragagent, 
%agi: 230 gevalle
a1gi
a2g1in1s
%ago: 180 gevalle
a1go
aa2g1o2
a2g1ont1
a2g1oor
a2g1o2p
sa3g2o3
a2g1ogg
a2g1oud
%probleem: dragon...
%agu: 55 gevalle
a1gu
aa2g1u
a2g1ui
a2g1uu
%agy: <5 gevalle
a2g1y

%ega: 165 gevalle
e1ga
e2g1aand.
%ege: 1145 gevalle
e1ge
lee2g1e2
e2g1eie
%sien ook 1ge1 elders
%egi: 590 gevalle
e1gi
e5g2if
ee2g1in
%sien weeg by vaste vorme
%ego: 240 gevalle
e1go
ee2g1o
e2g1on1g
e2g1oor1
e2g1op1
%probleem: spoorwegorder
%egu: 110 gevalle
e1gu
e2g1uit1
%egy: <5 gevalle
eg1y

%iga: 150 gevalle
i1ga
i2g3aan1
i2g1aard
.si3g2aar3
.si1ga
%ige: 1440 gevalle
i1ge
%sien ook 1ge1 elders
%igi: 600 gevalle
i1gi
%sien ook lig by vaste vorme, asook:
.li2g1i
%igo: 150 gevalle
i1go
ui2g1o2
ig2oon
i2g1ont1
i2g1op1t
%igu: 90 gevalle
i1gu
%igy: <5 gevalle
ig1y

%oga: 100 gevalle
o1ga
oo2g1a2
%oge: 210 gevalle
o1ge
oo2g1e2
o2g1eens.
%ogi: 695 gevalle
o1gi
oo2g1i2
%ogo: 75 gevalle
o1go
oo2g1o2
%ogu: 15 gevalle
o1gu
oo2g1u
%ogy: 0 gevalle
%o1gy

%uga: 45 gevalle
u1ga
u2g1aan
u2g1aar
u2g1aas
u2g1ad
u2g1af
%uge: 90 gevalle
u1ge
%sien ook 1ge1 elders
%ugi: <5 gevalle
u1gi
eu2gi
%ugo: 20 gevalle
ug1o2
ou1g2o
eu1g2o
%ugu: 35 gevalle
u1gu
%ugy: 0 gevalle
%u1gy

%yga: 18 gevalle
y1ga
%yge: gevalle
y1ge
%sien 1ge1 elders
%ygi: 35 gevalle
y1gi
%ygo: <5 gevalle
y1go
%ygu: 0 gevalle
%y1gu
%ygy: 0 gevalle
%y1gy

a1j
e1j
i1j
o1j
u1j
y1j

%sien ook vak, vlak by vaste vorme
%aka: 290 gevalle
a1ka
aa2k1a
a2k1aan
a2k3ad1v
%ake: 1065 gevalle
a1ke
aa2k1e
%aki: 130 gevalle meeste ook hanteer by -ing
a1ki
%ako: 200 gevalle
a1ko
aa2k1o
a2k1oes.
a2k1oes1te.
a2k1oond
%probleem dakoorhang, tabakorganisasie
%aku: 95 gevalle
a1ku
a2k1uit1
%aky: gevalle
a1ky

%eka: 780 gevalle
e1ka
e2k1aan1
e3k2aan.
e3k2aans
%sien steek, streek by vaste vorme
%eke: 2550 gevalle
e1ke
e2k1eend
e1ker1v
e2k1er1va
oe2k1ei
oe1ke
%eki: 195 gevalle
e1ki
%eko: 1110 gevalle
e1ko
%eku: gevalle
e1ku
e2k1uit1
e2k1uur.
%sien sekuur by uitsonderings
%eky: 49 gevalle meeste reeds hanteer
e1ky
ee2k1y

%ika: 920 gevalle
i1ka
ui2k1a2
i2k1aan1j
%ike: 1475 gevalle
i1ke
%iki: 95 gevalle
i1ki
%iko: 215 gevalle
i1ko
i2k1oop1m
%iku: gevalle
i1ku
i2k1uit1
%iky: 0 gevalle
%i1ky

%oka: gevalle
o1ka
o2k1aan1
o2k1aart1
oo2k1a2
oo3k2a.
%oke: 205 gevalle
o1ke
oo2k1e
%oki: gevalle
o1ki
%stokinsek
o2k1in1s
%TODO: geen gevalle:
oo2k1i
%oko: 220 gevalle
o1ko
o2k1ou
oo2k1o
o2k1oo
%probleem: uitklokonderrok
%oku: 130 gevalle
o1ku
oo2k1u
%TODO: geen gevalle:
o2k1uit1
%oky: enkele gevalle
o1ky

%sien reuk by vaste vorme
%uka: 70 gevalle klomp plekname
u1ka
%uke: 125 gevalle
u1ke
%produketiket:
u2k1eti
%uki: 10 gevalle
u1ki
u2k1in
u3k2ing
%uko: gevalle
u1ko
u2k1ont1
ou3k2o
u2k1op1h
%uku: 70 gevalle
u1ku
%uky: 0 gevalle
%u1ky

%yka: 30 gevalle
y1ka
y2k1aard
%yke: 290 gevalle
y1ke
%yki: gevalle
y1ki
y2k1in
y3k2ing
%yko: 50 gevalle
y1ko
ly2k1o
%probleem: glykontak
%yku: 20 gevalle - meeste reeds hanteer
y1ku
%yky: meeste reeds hanteer a.g.v. yster. Res onduidelik
%y1ky


aa2l1
aa2l2s
aal3sa
aal3se
aal3si
aal3so
aal3su
aal3sy
twaal4f1
%aa2l2sb
%sien s1d elders
%aa2l2s1d
aa2l2s1g
%aa2l2sl
aa2l3spr
%aa2l2s1v
%aa2l2sw
%TODO: verwyder aal_-vorme onder. Hoekom?
%ala: 440 gevalle
a1la
aa2l1a2
%ale: 1250 gevalle
a1le
aa2l1e2
%ali: 1730 gevalle
a1li
aa2l1i2
%alo: 265 gevalle
a1lo
a1lô
aa2l1o2
%alu: 105 gevalle
a1lu
aa2l1u2
%sien unie by vaste vorme
%aly: gevalle
a1ly
aa2l1y2
%sien yster by vaste vorme


%ela: 1520 gevalle
e1la
ee2l1a
e2l1aan
e3l2aan.
e3l2aans.
e2l1ad1m
e2l1ad1v
e2l1af
%probleem: edelagbare
%sien alleen, etiel by vaste vorme
%ele: 2450 gevalle
e1le
e3lê1
tee2l1eend
vee2l1eis
%TODO:onnodig:?
we1le
we2l1ee
te1le3
tele4e
tele4k2s1
tele4k3s2e
tele4rs
tele4nd
%eli: gevalle
e1li
e2l1i2tem
e1li1te
%uitsonderings vir samestellings: %TODO:herhaal vir ander vokale?
e2l1inb
e2l1ind
e2l1inh
e2l1inl
e2l1inr
e2l1ins
%twv suiwelinvoer
e2l1in1v
%elo: 850 gevalle
e1lo
ee2l1o
ee3l2ood
ee3l2oon
ee3l2one
ee3l2oot
ee2l3open
ee3l2oper
%TODO:gevalle wat dubbelsinnig kan wees:
ee2l2oop
ee2l2ooi
%sien koel, enkel, stoel, vel tafel, handel, dadel, heuwel, amandel, by vaste vorme - nee wat
%sien oes by vaste vorme
e2l1oor
e2l1op
e3l2o1pe
e3l2o1pi
%elu: 325 gevalle
e1lu
e2l1uu
e3l2uuks
%TODO:kompleks:
ee2l2u
%ely: 385 gevalle
e1ly

%ila: 225 gevalle
i1la
ui2l1aa
%ile: 370 gevalle
i1le
%TODO: dalk iets soos ui2l1ei? niks in woordelys nie
%ili: 850 gevalle
i1li
%ilo: 160 gevalle
i1lo
%sien olie, oog by vaste vorme
%ilu: 20 gevalle
i1lu
%ily: 7 gevalle
i1ly

%ola: 255 gevalle
o1la
oo2l1a
%sien petrol, katrol, wol by vaste vorme
%ole: 520 gevalle
o1le
o1lê
oo2l1e
vo1le
vo2l1ei
%oli: 1000 gevalle
o1li
oo2l1i
%polisie, politiek, polis
1po1li
%sien ook monopolie by vaste vorme
so1li
%olo: 970 gevalle
o1lo
oo2l1o
vo2l1o
kar1bo2l1op1
%olu: 130 gevalle
o1lu
oo2l1u
.vo2l1uit
.vo1lu1m
.vo1l2uut
%oly: 60 gevalle
o1ly

%ula: 310 gevalle
u1la
%ule: 435 gevalle
u1le
u1lê
jou2le
%uli: 155 gevalle
u1li
%ulo: gevalle
u1lo
%sien ont elders
%ulu: hoofsaaklik Zoeloeplekname
u1lu
%uly: 8 gevalle
u1ly

%yla: 25 gevalle
y1la
%yle: 55 gevalle
y1le
%yli: 30 gevalle
y1li
%ylo: 25 gevalle
y1lo
%ylu: 1 geval
y1lu
%yly: 13 gevalle
y1ly


%ama: 550 gevalle
a1ma
aa2m1a
%ame: 1550 gevalle
a1me
aa2m1e
%ami: 425 gevalle
a1mi
aa2m1i
%amo: 130 gevalle
a1mo
aa2m1o
%miskien: a2moo dalk eerder koppelteken
%sien ook oorlog, program by vaste vorme

%amu: 45 gevalle
a1mu
aa2m1u
%amy: < 5 gevalle gevalle
a1my

%ema: 900 gevalle
e1ma
%enkele probleme met eema (dinge soos probleemarea, opneemapparaat)
%ter wille van samestellings:
e2m1afd
e2m1afr
e2m1afs
%eme: 1230 gevalle
e1me
%enkele probleme met eeme
%4 aan einde ter wille van leesbaarheid
ee2m1e4
%emi: 670 gevalle
e1mi
%emo: 600 gevalle
e1mo
e1mô
%emu: 65 gevalle
e1mu
%emy: 10 gevalle
e1my

%ima: 230 gevalle
i1ma
%sien ook agtig elders
%ime: 355 gevalle
i1me
i1mê
%imi: gevalle
i1mi
%probleem: kleiminspekteur
%imo: 95 gevalle
i1mo
i2m1op
%sien ook oorlog by vaste vorme
%imu: 90 gevalle
i1mu
%imy: < 5 gevalle, Amanzi-myama seker eintlik verkeerd in Afrikaans eerder m-y
i1my

%oma: 380 gevalle
o1ma
oo2m1a
blo2m3a2
bo1ma
bo2m1aan
%ome: 980 gevalle
o1me
oo2m1e
%omi: 445 gevalle
o1mi
oo2m1i
%omo: 240 gevalle
o1mo
oo2m1o
o2m1ont1
%omu: 10 gevalle
o1mu
oo2m1u
%omy: 15 gevalle
o1my
oo2m1y

%uma: 160 gevalle
u1ma
iu2m1a2
%ume: 285 gevalle
u1me
iu2m1e2
%umi: 80 gevalle
u1mi
iu2m1i2
%umo: 45 gevalle
u1mo
iu2m1o2
%umu: 40 gevalle
u1mu
iu2m1u2
%umy: 0 gevalle
%u1my
iu2m1y2


%yma: 20 gevalle
y1ma
y2m1af1
y2m1ag1tig
%TODO: oorweeg weer met weer woorde
%yme: 90 gevalle
y1me
%ymi: 10 gevalle
y1mi
%ymo: 20 gevalle
y1mo
y2m1op
%ymu: < 5 gevalle
y1mu
y2m1ui
%ymy: 0 gevalle
%y1my


%ana: 600 gevalle
a1na
aa2n1a2
a2n1aan
%HAT en Bresler verskil tov vanaand
%a2n1alleen
%manalleen - dalk eerder in elkgeval met 'n koppelteken?
%ane: 885 gevalle
a1ne
aa2n1e2
aa2n1een1
%ani: 830 gevalle
a1ni
aa2n1i2
%sien ook in by vaste vorme
%ano: 255 gevalle
a1no
aa4n3o2
a2n1oor1
a2n1op
a3n2op1sie
a3n2o1p2l
a3n2o1p2r
%spanooi? nooi, ooi?
%anu: 60 gevalle
a1nu
aa2n1u
a2n1ui
%any: 65 gevalle - baie Zoeloe-plekname
an1y
1a2n2ys
aa2n1y

%ena: 1000 gevalle
e1na
ee4n3a2
e2n1aan
e3n2aand
%ene: 1350 gevalle
e1ne
ee2n1e2
%Eiename:
ee3n2e2n.
e2n1een.
e2n1eens.
e3n2eem
e2n1een1h
%eni: 1580 gevalle
e1ni
%TODO:later dalk meer probleme. Vir nou slegs:
ee2n1in
e2n1in1
%eno: 625 gevalle
e1no
ee2n1o
e2n1oor1een1
%probleem: honderdtreenommer
%paar probleme met enou
%enu: 240 gevalle
e1nu
ee2n1u
e2n1uu
e2n1ui
%eny: 55 gevalle
e1ny
ee2n1y

%sien bruin, tuin by vaste vorme
%ina: 560 gevalle
i1na
i2n1aan
%ine: 1450 gevalle
i1ne
i1nê
i2n1eend
%ini: 740 gevalle
i1ni
%Sien wel die uitsondering t.w.v. (nin) breininfeksie elders (vaste vorme?)
%ino: 210 gevalle
i1no
ui2n1o
%inu: 70 gevalle
i1nu
%iny: slegs Zoeloe-plekname (miskien ook samestellings)
i2n1y

%sien ook .on elders
%ona: 565 gevalle
o1na
oo2n1a2
o2n1aan5
o2n1aar
%one: 1045 gevalle
o1ne
o1nê
oo2n1e2
%oni: 1025 gevalle
o1ni
%ono: 500 gevalle
o1no
oo2n1o
o2n1op
.o2n1op1
.o2n1o2p2e
%sien olie, monopolie by vaste vorme
%onu: 110 gevalle
o1nu
oo2n1u
o2n1uit1
%ony: 25 gevalle heelwat Zoeloe-plekname
o1ny
o2n1ya
o2n1ye

%una: 60 gevalle
u1na
%probleem: steunarms
u2n1arm
%une: 80 gevalle
u1ne
%uni: 385 gevalle
u1ni
%sien unie, uniform by vaste vorme
%uno: 14 gevalle
u1no
%unu: enkele gevalle
u1nu
%uny: enkele gevalle
u1ny
u2n1ya
u2n1ye
u2n1yu

%sien by by voorvoegsels
%yna: 40 gevalle
yn1a
y2n1aar
%y2n1aa
y1n2aaf
%yne: 315 gevalle
y1ne
y2n1ee
%yni: 70 gevalle: word reeds deur -ig en -ing hanteer
%sien ook myn by vaste vorme
%yno: 30 gevalle
yn1o2
y1n2ooi
y1n2om1m
%ynu: 5 gevalle
yn1u
%yny: 0 gevalle
%y1ny


pu1b


%apa: 175 gevalle
a1pa
aa2p1a
a2p1aan1
a2p1arm
%probleem: trapas
%ape: 510 gevalle
a1pe
%api: 410 gevalle
a1pi
%apo: 150 gevalle
a1po
aa2p1o
%apu: 40 gevalle
a1pu
aa2p1u
%apy: 30 gevalle
a1py

%epa: 475 gevalle
e1pa
e2p1aan1
e3p2aan.
%probleem: sleepanker
%epe: 800 gevalle
e1pe
%epi: 335 gevalle
e1pi
ee2p1op1l
%epo: 280 gevalle
e1po
ee1po
ee2p1on
ee2p1oef
e2p1ont1
%probleem: leepoog/leepoë
%epu: 95 gevalle
e1pu
%epy: 25 gevalle
e1py

%ipa: 90 gevalle
i1pa
%ipe: 310 gevalle
i1pe
%ipi: 70 gevalle
i1pi
%ipo: 135 gevalle
i1po
i2p1ont1
%ipu: 35 gevalle
i1pu
%TODO:kyk met meer woorde
i2p1ui
%ipy: 9 gevalle
i1py

oo2p1
%Verbindings-s maak die volgende nodig
oo2p2s2
%opa: 160 gevalle
o1pa
oo2p1a2
o2p1aan1
o2p1amp1
%probleem: Witkopaasvoël
%ope: 880 gevalle
o1pe
o2p1een
o2p1eet
o2p1ein
o2p1eis
%sien koper,opera by vaste vorme
%opi: 320 gevalle
o1pi
%opo: 180 gevalle
o1po
o2p1ont1
o2p1op
%opu: 40 gevalle
o1pu
o2p1ui
%opy: 5 gevalle
o1py

%upa: 35 gevalle
u1pa
%upe: 110 gevalle
u1pe
%upi: 25 gevalle
u1pi
%upo: 10 gevalle
u1po
u2p1on1
%upu: 10 gevalle
u1pu
%upy: < 5 gevalle
u1py

%ypa: 30 gevalle
y1pa
%ype: 120 gevalle
y1pe
%ypi: 35 gevalle
y1pi
%ypo: 15 gevalle
y1po
y2p1ont1
y2p1or
y3p2or1tret
%ypu: <5 gevalle
y1pu
%ypy: 0 gevalle
%y1py


%ara: 630 gevalle
a1ra
aa2r1a
%are: 1350 gevalle
a1re
aa2r1e
%ari: 1450 gevalle
a1ri
aa2r1i
%aro: 250 gevalle
a1ro
aa2r1o
sta2r1oog
%sien ook oog by vaste vorme
%aru: 20 gevalle
a1ru
aa2r1u
%ary: 85 gevalle
a1ry
%geen gevalle, net vir ingeval:
aa2r1y


%era: +- 1500 gevalle
e1ra
%sien aand by vaste vorme
%marmeragtig
e2rag
%TODO:dalk tog eer-a in sekere gevalle?
ee2r1a2
ee3r2aad
see3ra
%200 gevalle (verantwoordelikheid, ens): sien "ver" elders
%sien ook vinger, water, en agtig(e) by vaste vorme
%ere: 2800 gevalle
e1re
%eere blyk ook gedek te wees met samestellings soos seereis.
%sien ook leer en weer by vaste vorme
%paar probleme soos bv agtereenvolgende:
%ereen lyk soos 'n redelike maatreel
e2r1een
%^ slegs verouderde "-reent" (reën) gee dan probleem
%eri: 4700 gevalle
e1ri
oe4r1in1f
oe4r1in1na
oe1rin1n
oe1ri
%enkele probleme moontlik, bv. graveerinstrument, voerinname.
%sien ook "ver-" elders vir "verering" (vere-ring is ongewensd)
%ero: 1050 gevalle
e1ro
ee2r1o
e2r1ont1
ë1ro1
e2r3o2p1
e3r4o3p2a
e3r4o3p2i
ë2r1op
%probleem: ysteroksied, wateropname, wederopstanding
%kom voor by baie samestellings, verloor 120 gevalle:
te2r2o
%sien ook "ver" elders vir groot pret
%eru: 550 gevalle
e1ru
ee2r1u
zee3r2ust
e2r1ui2t1
e2r1ui3t2e
e3r2ui3t2er
%e3r2uit.
%e3r2ui1t2e
%hie2r1uit
%interuniversiteits...
e2r1u2ni
%ery: 1230
e1ry
%skakel maar paar uit vir gevalle soos gletserys vs mielierys
e2rys.
%sien ook ver elders en yster by vaste vorme

%ira: 155 gevalle
i1ra
%ire: 135 gevalle
i1re
ai2re
aai3re
%iri: 150 gevalle
i1ri
%iro: 95 gevalle
i1ro
%iru: 50 gevalle
i1ru
%iry: < 5 gevalle
i1ry

%or - sien oor by vaste vorme
%ora: 335 gevalle
o1ra
%ore: 600 gevalle
o1re
ô1re
oo2r1e2
o2r1een
o3r2een.
oo4r3een.
%ori: 1200 gevalle
o1ri
%oro: 95 gevalle
o1ro
%sien oor by vaste vorme
%oru: 20 gevalle
o1ru
o2r1ui2t1
%ory: 7 gevalle
o1ry

%ura: gevalle
u1ra
%eur is meestal by samestellings (kleurafdruk). By die ander gevalle verskil my 
%bronne (TODO). neuralgie, neurastenie
eu2r1a
%tydelike maatreëls:
neu2r2a
%gee probleme met mine
%mi1neu2r3a
%ure: 600 gevalle
u1re
uu2r1e
%uri: 600 gevalle
u1ri
%uro: 140 gevalle
u1ro
uu2r1o
%uru: 20 gevaalle
u1ru
%ury: 22 gevalle
u1ry
%plekname soos Westbury (volgens GC Bresler)
u2r1y.

%yra: < 5 gevalle, maar goed vir samestellings
y1ra
%yre: 2 gevalle (samestellings)
y1re
%yri: enkdele gevalle by samestellings
y1ri
%yro: 14 gevalle +woorde soos by- en sy-
y1ro
%yru: 7 gevalle
y1ru
%yry: < 5 gevalle
y1ry


%asa: 120 gevalle
a1sa
aa2s1a
%sien ook saan elders
%sien ook gas by vaste vorme
%ase: 550 gevalle
a1se
aa2s1e
ra2s3ei4e
%asi: 2770 gevalle
a1si
aa2s1i
%aso: 65 gevalle
a1so
aa2s1o
a2s1oo
ga2s1on4t1
ta2s1orgaan
%sien pasop by vaste vorme
%asu: 60 gevalle
a1su
gra2s1u
%asy: 40 gevalle
a1sy
va2s1ys
%sien asyn by vaste vorme

%esa: 370 gevalle
e1sa
oe2s1aan1
oe1sa
%sien geestes, oes by vaste vorme
%TODO: te kompleks op die oomblik. Ignoreer maar almal:
ee2s2a
%Sien ook saan elders
%ese: 2800 gevalle (meeste aan einde van die woord, soos akademiese)
e1se
e1sê
%esi: 1320 gevalle
e1si
%sien ook oes by vaste vorme
%eso: 555 gevalle
e1so
fee2s1o
lee2s1o
vre1de4s5o
vre1de
%sien alles, geestes, oes by vaste vorme
%esu: 180 gevalle
e1su
.se2s3u
%esy: 45 gevalle
e1sy
%sien yster, ywer by vaste vorme

%isa: 415 gevalle
i1sa
par1ti5saan
%sien ook saan elders
%kennisabsorbsie, tennisarm:
nni2s1a
%huisadres, witkruisarend:
%TODO:dink oor 2 aan einde
ui2s1a2
%sien ervaring, reis, salaris, vis, vleis by vaste vorme
%sien "agtig" elders
%ise: 1700 gevalle
i1se
%sien ook vis by vaste vorme
%isi: 1200 gevalle 
i1si
%probleem huisindustrie
%iso: 290 gevalle
i1so
ui2s1o2
%verbindings met salaris, inventaris
a1ri4s3o
%verbindings met betekenis, geskiedenis, gevangenis:
e1ni2s3o
%sien kennis, tuis, vis by vaste vorme
%isu: 20 gevalle
i1su
ari2s1u
%sien kennis, reis, vleis by vaste vorme
%isy: 45 gevalle
i1sy
%sien yster by vaste vorme

%osa: 110 gevalle
o1sa
ô1sa
oo2s1a
o2s1aa
%sien sart by geslote lettergrepe
%ose: 880 gevalle
o1se
%sien ook eiland by vaste vorme
%osi: 515 gevalle
o1si
%oso: 100 gevalle
o1so
oo2s1o
%sien oog, oorlog, oordeel by vaste vorme
%osu: 5 gevalle
o1su
%sien bos, pos by vaste vorme
%osy: 45 gevalle
o1sy

%usa: 75 gevalle
u1sa
%neusarts
eu2s1a
%use: 460 gevalle
u1se
%usi: 460 gevalle
u1si
%uso: 40 gevalle
us1o
bou1s2om
u1s2or
%usu: 25 gevalle
us1u
ou1s2u
%usy: 19 gevalle
u1sy

%ysa: 30 gevalle
y1sa
%sien grys, lys, onderwys, prys by vaste vorme
%yse: 510 gevalle
y1se
y2s1ee
%ysi: 170 gevalle
y1si
%yso: 25 gevalle
ys1o
%sien onderwys, prys by vaste vorme (wat dieselfde doen)
%ysu: 2 gevalle
y1su
%ysy: 2 gevalle
y1sy




%ata: 430 gevalle
%a1ta
a1ta
aa2t1a
%a2taa
a3taaf
a3taal
a3t2aan
a4t3aand
a2t1aar
spa2t1a2re
%ate: 2050 gevalle
a1te
aa2t1e
%ati: 1130 gevalle
a1ti
aa2t1i
%ato: 700 gevalle
%a1to
a1to
aa2t1o
%atu: 430 gevalle
a1tu
aa2tu
%aty: 40 gevalle
a1ty

%eta: 490 gevalle
e1ta
%bietjie moeilik
ee2ta
e2taa
e3taal
%vetagtig, ens.
e2tagt
%ete: 1865 gevalle
e1te
%eti: gevalle
e1ti
ee2t1i
%eto: 490 gevalle
e1to
e2t1oo
e3t2oon
be3t2o
be3t2oo
ge3t2o
ge3t2oo
%etu: 115 gevalle
e1tu
ie2t1u
ui4e3t2u
%ety: 85 gevalle
%e1ty

%Vir al hierdies, sien uit by vaste vorme
%ita: 480 gevalle
i1ta
%ite: 1840 gevalle
i1te
i1tê
3i2tem.
3i2tems.
%as teenvoeter vir gemors wat deur uit veroorsaak word
ui1te
%iti: 590 gevalle
i1ti
%ito: 195 gevalle
i1to
.wi2t1o
%itu: 245 gevalle
i1tu
%ity: 25 gevalle
i1ty

%ota: 195 gevalle
o1ta
oo2t1a
o2t1ag1t
%sien karoo elders
%probleme: boikotaksie
%ote: 700 gevalle
o1te
oo2t1e
%oti: 365 gevalle
o1ti
oo2t1i
%oto: 550 gevalle
o1to
oo2t1o
%otu: 35 gevalle
o1tu
oo2t1u
%oty: 2 gevalle (plekname)
o1ty

%TODO: oorweeg uu2t1a, ens.
%uta: 110 gevalle
u1ta
%paar probleme: ..outa..
ou2ta
%ute: 470 gevalle
u1te
%uti: 105 gevalle
u1ti
%uto: 160 gevalle
u1to
ou1to
ou2t1op1l
u2t1oond
u2t1ont1
%probleem: soutoplossing, stutorganisasie
%utu: 30 gevalle
u1tu
%uty: 10 gevalle
u1ty

%moontlik probleme met samestellings met ontbyt, ens.
%yta: 20 gevalle
y1ta
%probleem: bytalkalie
%yte: 70 gevalle
y1te
%yti: 20 gevalle
y1ti
%yto: 12 gevalle
y1to
%ytu: 15 gevalle
y1tu
%yty: 4 gevalle
y1ty

a1wa
a1we
a1wi
a1wo
a1wu
a1wy

e1wa
e1we
e1wi
e1wo
e1wu
e1wy

i1wa
i1we
i1wi
i1wo
i1wu
i1wy

o1wa
o1we
o1wi
o1wo
o1wu
o1wy

u1wa
u1we
u1wi
u1wo
u1wu
u1wy

y1wa
y1we
y1wi
y1wo
y1wu
y1wy

%TODO:x
a1xi
ex1a
ex1i
u1xa

%Oop lettergrepe in ander forme:
%Hierdie afdeling is gebasseer op die 2002-AWS se afdeling wat handel oor
%patrone in die vorm [:vokaal:][:konsonant:][lr][:vokaal:]

%1b2r is by b

a1dr
aa2d1r
a2d1roet
a2d1rol

e1dr
e2d1ramp
e2d1ren
e2d1rep
e2d1roep
e2d1rooi

i1dr
i2d1rig
i2d1rooi
i2d1rug

o1dr
oo2d1r
oo2d3rin

%geen gevalle van udr of ydr nie

%a1fr

1gra1fi

%kl: kyk egter mooi vir samestellings
%for i in a e i o u y; do for j in a e i o u y ; do echo "$i"1kl"$j"; done; done
%bv:
%e1kli
%ee2k1li

a1tr
%probleem:gatry, katrug, natreën, natreent, natril?, patatranke, 
%Platrand, platriem, platring, platry, skatryk, Witgatruiter
%uitsonderings t.w.v. hierdie probleme:
a2t1ran1d
a2t1ran1k
a2t1ree
a2t1reë
a2t1reg.
a2t1riem.
a2t1ring.
a2t1rug.
a2t1rui1ter.
a2t1ry

e1tr
%probleem: voetrus, Dwergrietreier, eetreëls, granietrots, hetreël?
%internetrekening, internetrubriek, krieketraad, meetroede
%netrimpel.., netruimte, oetroos?, ...traam, ...trame, rietrot[te], ..tring[e]
%soetriet, soetrissie, sowjetrepubliek, -regering
%stoetramme, vetrol
%uitsonderings t.w.v. hierdie probleme:
e2t1rus.
%probleem: Petrus
e2t1reier.
%e2t1rots.
%probleem: met nasietrots, ens.
e2t1reël
e2t1re1ke
e2t1ruim
e2t1ru1br
e2t1raad
e2t1roed
e2t1rim
e2t1raam
e2t1ram
e2t1rot1.
e2t1rot1t
e2t1ring
e2t1rol.
e2t1riet
e2t1ris1s
e2t1re1pu
e2t1re1ge

%1gr, 1fr, 1pr


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Geslote lettergrepe
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

2d1af
3d2a1f2a
3d2a1f2é

een1k

2f1af1
3f2a1f2a
3f2a1f2i

nan1si
an1se

2r1af1d
2r1af1g
2r1af1h
2r1af1l
2r1af1s
3r2af2s.
2r1af1t
2r1af1v
2r1af1w

%TODO:oorweeg
2r1inf

cr2af
dr2af
gr2af
gi3r2af
gi1ra
%sien ook straf by vaste vorme

%oefen
.oe1fen1
.oe2fe1n2a
.oe2fe1n2e
.oe2fe1n2i
1oe2fen1
1oe2fe1n2a
1oe2fe1n2e
1oe2fe1n2i
4e3fee
3d2oe3fees
2d1oe2fe
4e1oe2fe
2k1oe2fe
2l1oe2fe
2m1oe2fe
2n1oe2fe
2t1oe2fe

%p1se

%sake: groepseenheid, soneklips, skeepseienaar, beroepseis, dorpserf

%sart
2s1art

%verpleegster, ens.
eeg1ste


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Vaste vorme
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hier is klomp woorde en groter patrone wat heelwat voorkom en wat aansienlik 
% help met korrektheid en om meer gevalle te hanteer. 

%aan en aand
.aan1
.aan2d1
.aan5d2a
.aan3d2r
.aan3d2e
.aan4d3ete
.aan3d2i
.aan3d2o
.aan4d1of
.aan4d1oud
.aan3d2u
2r1aand
%sien ook graan

%admin
1ad1min
ad1m
2g1ad1min
2n1ad1min
2r1ad1min
2s1ad1min

%adviseur, advies, advokaat
2s1ad1vi
2s1ad1vo

%afrig
1af1rig
2k1af1rig
2t1af1rig

%afstand
3af1stand
4g3af1stand
4l3af1stand
4k3af1stand
4n3af1stand
4p3af1stand
4s3af1stand

%aksie
2s1ak1sie
2n1s2ak1sie
2r1s2ak1sie
%probleem: Saksies

%alarm
1a2larm
%TODO: werk nie
2d1a2larm
2g1a2larm

%alleen
5al1leen1
al1l
2g1alleen
%werk nie: stoksielsaligalleen
2k1alleen
2l1alleen
2n1alleen
2r1alleen
gal1l
lal1l
kal1l
nal1l
ral1l

%alles
%al1le4s5
%al1le5s6ins

%amp
2s1amp

%area
1a2rea.
1a2reas.
2f1a2rea
2m1a2rea
2n1a2rea
2p1a2rea
2t1a2rea

%arm
2s1arm
%probleem: kasarm

%asyn
3a2syn
%magasyn
g4a1syn

%bees
1bees1

%bid: 100 gevalle betrokke
1bid1
bi1d2e
bi1d2i
li1bi1d2o

%bos
bos1
bo1s2e
bo2s2c2h

%bruin
brui2n1
brui2n2d
brui3n2e
brui4n3eend
brui3n2ing

%deur
1deur1
deu1r2e
deu2r3ee
deur2s1b
deur2s1v
%sien ook europa

%brein: 45 gevalle
brei2n1
brei3n2e
brei3n2aald

%dier (eerste twee dalk eerder net aan begin van woord?
%probleem: kunsstudierigting
3die2r3
3die3r4e1
3die3r4a1sie
%l1dier
%r1dier

%eienaar
%1eien
%1eie2nd
%o2ei1e
n2t1eie
n2t1eie1ning
2s1eie

%eiland
%??????1eiland
2d1eiland
2g1eiland
2l1eiland
2n1eiland
2r1eiland
2s1eiland
%sien ook vlei
w2eiland

%eksamen
2l1ek3s2am
lek1sa
2s1ek1sa

%ervaring
5er1varing
we1d6er1varing
we1der1v
we1de
er1v

%etiel, metiel
e1tie2l3

%europa, euro, neuro
e4u1r4o1p
eu1ro

%film
film1
fil1m2i
fil1m2o
fil2m3op

%gas
.ga4s1

%geestes
gee2s1te2s1
gees1te3s1panning

%geld
ge4l4d3
men1ge4l5d4
ge4l5d4e
ge4l6d5ee
ge4l5d4i
ge4l6d5ins

%gimnastiek, plastiek
%stie2k1o

%goed
1goed

%goud
1goud1
gou1d2a
%probleem: dagoud

%graan %TODO: dalk onnodig?
1g2r2aa2n1

%groep
1groep
1groep1l

%grond
1gron2d1
1gron3d2e.
1gron3d2ing
1gron3d2ig
2g1rond1te.
%probleem grondagtig werk nie

%grys
.grys1
.gry1s2e

%hand
1han2d3o
%Twee Zoeloename bly in die slag

%hoof
hoo2f3

%hout
%dit wil voorkom asof verbindings s nie 'n rol speel
1hou2t1
1hou3t2e
1hou3t2ing
%sien ook verkleiningsvorme
%kan verwar word met hou, veral by houtjie, uithoutoets, ophoutyd

%illustrasie, illusie
1illu
il1l
2g1illu
gil1l
2k1illu
kil1l
2n1illu
nil1l
2s1illu
sil1l

%industrie
3in1dus
2d3in1dus
2n3in1dus
2g3in1dus
2k3in1dus
2s3in1dus
2l3in1dus
2r3in1dus

%kaap, skaap
kaa2p3
kaa2p4s.
kaa2p4s1h

%kantoor
1kan1toor
1kan1to1re
1kan1to

%karoo
ka3r2oo3
ka3r2oo3f2
ka3r2oo3l2
ka3r2oo3m2
ka3r2oo3r2

%kas
s1kas

%kennis
ken3ni4s3
ken1n

%kleur
1kleu2r1
1kleu3r2e
1kleu4r3eg
1kleu4r3ef1fek
1kleu3r2ig
1kleu2r1in1
1kleu3r2in2g

%klier
1klier

%klub
klu4b
klu4b3l

%kontant, kontinent, kontrak, kontak, kontrole, kontras, kontoer, kontrei
%probleem: [bg]eskonke
s1kon
s2kon.
1s2ko2n1de
1s2ko1ne
1s2ko1ning
2s3ko1nin1gin
1k2on1t2ant
1k2on1t2i1
1k2on1t2i2n1g
1k2on1t2rak
1k2on1t2ak
1k2on1ta
1k2on1t2ro1le
1k2on1t2ra
1k2on1t2oer
1k2on1trei

%kring
2r3krin
2s3krin

%krul
1k2ru4l1

1land
lan1de
lan2d1eng1te

%laag
l4aag.
%laai
1l4aai1
b2laai
s2laai
%laan
l4aan.

%lê
1lê1

%leer, weleer
1l2ee2r1
k2l2ee2r1t
we2l3eer
%probleem: kontempleer

%leër en ander (soos bekleër
le2ër1
leë2r1o2
leër2s.
le2ë1r2i
%TODO: 
%s1le2ër1

%bloed, vloed, gloed, :
loe2d1
1bloe2d1
%vloed se voorafgeval word by v hanteer
1gloe2d1
loe3d2e
loe3d2i
loe4d3eie

%lys
ly2s1
ly1s2ie

%maal
s1maal3
ge3s2maal

%maat, maatstaf
1maat
1maat1staf
1maat1staw

%man, mandaat, manipulasie, Tasmanië
2s1man

%mas, masker, masjien
1ma1sjien
s1mas

%mengsel
%1meng1sel

%mens
3m4ens1
3m4en1s2e
3m4en1s2i

%musiek
1m2u1sie2k1
1m2u1si

%myn
.my2n3
.my3n4e
.my4n5ei
.my4n5ent

%neo, neon
.ne2o1
.ne3o2n1

%nin/in inhoud
%sien ook sin, afdeling met -ing
n1in
%n2ing
n2i1ne
1n2in1k
2n3in2k.
n2in2klik

.wa2n3in3
2s1in1houd

%olie, monopolie
%TODO: meervoude van olie$-woorde kort in woordelys
3o4lie.
b4o5lie.
4d3o4lie.
n4g3o4lie.
4k3o4lie.
4k3o4lies.
%TODO: breuk voor die k is moontlik nuttig
k2o3li
4l3o4lie.
4m3o4lie.
mo1li
4p3o4lie.
mo1no5p4o5li
1mo1no1
1mo1no2f1t
1mo1no2k1s
1mo3n2o1p
4r3o4lie.
4s3o4lie.
4t3o4lie.
to1li

%onder
on1der1
4g1on1der1
.dra5g2on1der
4l1on1der1
4m1on1der1
5m2on1de1r2ing
4n1on1der1
4t1on1der1

%onderwerp, onderwys
1onder1werp
1onder1wy2s3
1onder1wy3s4e
2s1on1der1w
son1de
son1der1s

%opera,operasie
3o2pe1ra
4l3o2pe1ra
lo1pe
4p3o2pe1ra
po1pe
4r3o2pe1ra
ro1pe
4s3o2pe1ra
so1pe
4k3o2pe1ra
ko1pe

%T.w.v. koper...
.ko1pe2r1
.ko1pe2r3a

%oplei...
1op1lei
2m1op1lei
2r1op1lei

%optog, optrede, 
2s1op1tog
2s1op1tr

1pad1
pa1d2e

%katrol, patrol..., petrol
a1tro2l1
aa2t1ro2l1
pe3t2ro2l1
pe3t2ro1l2e
pe3t2ro1l2o

%party
1par1ty1

%persoon
1per3soon

%pote, potensiaal
2s1po1te

%program
3pro1gram
3pro1gra4m1o

%prys
pry2s1
pry3s2e

%rand
2d1rand.
2s1rand.

%reg
1reg.
2d1reg.
2t1reg.

%stad
3stad.
%stof, stowwe
1s2t2o2f1
1s2t2o2w1w
%teen, steen
1teen3
teen4d.
1s2teen3
1teen4s1w
%sien ook .uit
%ui2t1een (uiteen)
sl4uit
1fl4ui2t1
1fl4ui3t2e
1fl4ui4t3eend
1fl4ui3t2is
kl4uit

%oes
.oe2s1
%oes, oeste
e2l3oes
e2l3oes
2s3oes.
2s3oes1te.
2n3oes.
1k4n4oes.
2n3oes1te.
%Zoeloes
oe5l4oe
oe2l1oon
%^Sien %elo

%ongeluk
d3on1ge
d4on1ge.
g3on1ge
n3on1ge
ka1n4on1ge
ka1no
p3on1ge
o4r3on1ge
s3on1ge
s4on1ge.

%oog
1oog.
b2oog.
1dr2oog
h2oog.
2k3oog.
1l2oog.
pui2l3oog.
2p1oog.
%sien gepoog by uitsonderings
ge3s4oog.
be1t2oog.
siel3t2oog.
ver3t2oog.

%ooi
2p1ooi.

%oordeel, voordeel
3oor1d2eel
%sien ook "voor" onder
%oorlog, oorloë
3oorlog1
3oorlog2s
3oorloë1
%TODO: skep probleme: miskien later. Reëls in die vorm r1oor1 sal dalk help. 
%2m3oorlog1
%2m3oorlog2s
%2r3oorlog1
%2r3oorlog2s
%2s3oorlog1
%2s3oorlog2s

%oor, voort-, koors
oo2r1
p4oo2r2t
k4oor2s
koor3sang
%die volgende stem presies ooreen met woord elders
oo2r2d1
oo2r3d2a
oo2r4d3arm
oo2r3d2e
oo2r3d2ig
oo2r3d2in
oo2r3d2ing
oo2r3d2is1
oo2r3d2r
%oo2r3d2ri
%TODO: noord? kassensitief?
noo2r2d1
noo2r4d3a2
noo2r3d2e
noo2r4d3eu
noo2rd1i
noo2r2d3w
noo2r2t
noo2r3t1e
noo2r3t1i

on1oor1k
on1oor1s
on1oor1t

v4oo2r1
v4oo2r2t1
v4oo2r3t2r
v4oo2r4t3reis
v4oo2r4t3rol
v4oo2r4t3ruk
voo4r5d4ra
v4oor3t2a
v4oor3t2e
v4oor3t2o
v4oor3t2ref
v4oor4t1s
v4oor4t2s.
voor3t2u
voor3t2yd
%TODO: moet nog 'n paar voort-gevalle hanteer
%sien ook woord

%pasop
pa2s1op

%probleem
1pro1bleem

%pos
.po2s1a
.po2s1o
.po2s1u

%reis
1rei2s1a
1rei1s2e
1rei2s3er4v
1rei1si
1rei2s1in1
1rei3s2in2g
1rei2s1o
1rei2s1u

%reuk
.reu2k1
.reu3k2e
.reu3k2i

%ruspe
3rus1pe

%saam
1s2aa2m1

%salaris
1sa1la1ri4s3

%salon (t.w.v. heids... elders)
3s4a1lo

%sê
1sê1

%see
.see3
.see3m4
%.see4p1k
.see4p1
.see5p2o1lis
.see5p2os
.see5p2unt
.see4r1
.see5r2a
.see5r2e
.see6r3ee
.see5r2o
.see6r3oog

%sentrale, sentrum
1sen1tra
1sen1trum

%siek, siel
1siek
1siel

%siening
3s4ie1ning

%sin
%sien ook nin, inhoud
%3s4in.
1s2ins.
.s2ins1
.sin1s2a
.sin1s2pee
.sin1s2peli
.sin1s2t
2s1ins
3s2in1sel
ge1s2ins

%situasie
3s4i1tu1a1sie
si1tu

%skap, kapitaal
1sk2ap
2s3ka1pi1taal1

%skool
3s4kool1
3s4kool2s.

%skroef
3s4kroe2f1
3s4kroe3f2ie

%soldaat
3sol1da

%speel
3s4peel1

%speld
3s4peld

%spoed: 90 gevalle
spoe2d1
spoe3d2e.
%poeding! :-)
5poe5d4ing

%spr - (oor-?) optimistiewe aanname  %TODO
s1p2r
%as teenvoeter vir verkeerdelik-optimistiese aannames oor verbindings -s
1s2praak
1s2pra1ke
1s2pra1ki
1s2pran1kel
s2pre
be5s2pre
1s4preeu
s2prei
%TODO: moeilik: preek of spreek?
%1s4preek
%1s4pre1ke
1s4preuk
1s4priet
1s4p2ring
1s4p2rink
1s4p2roei
1s4p2roet
1s4p2ro1ke
1s4p2ro1kie
1s4p2rong
%oorweeg weer: pronk?
%1s4p2ronk
1s4p2ruit

%pos, posisie
s1pos
s1pos1te

%spier
1spier
%'n Spiering is 'n soort vis. Samestelling met piering dalk probleem

%staat
3s4taat1
1s4taat2s
1s4taat3se.
1s4taat2s1in1
1s4taat2s1l
1s4taat2s1m
1s4taat2s1n
1s4taat2s1p
1s4taat2s1w

%standaard
5s4tan1d4aard1
5s4tan1d4aar1d2e
%steen - sien teen
%5s4teen1
1s2tee2k1
%TODO:stelling kan verwar word met telling
3s4tel1ling
3s4tel1la
3s4tel1le
3s4tel1lê
3s4tel1li
toet4s5tel1ling
volk4s5tel1ling
%stelsel
5s4tel3sel
%stert
stert1
ster1t2aal
ster1t2a1le
ster1t2ra1li
2g1stert1
2l1stert1
2n1stert1
2p1stert1
2r1stert1
2t1stert1
ster1t2y
%stilstand
1s2til1stand
%stoel
3s2toel
4s3toe1la
%storm
5s4torm
%straal
3s4traa2l1
3s4traa2l2s1g
%straat
3s4traa4t1
3s4traa4t2s
.ka4s5traa4t
%straf
3s4tr2af1
3s4tr2a1f2yn
%stral: TODO: dalk probleem met samestellings met tralie?
3s4tral
3s4tram
%strand
3s4tran4d1
3s4tran5de
%stras (demonstrasie administrasie, registrasie)
i1stree
i1stras
n1stras
n1stree
%strategie
%5s4tra1te1gie
5s4tra1t
%was stra1te
%Met 5s4tra1t word baie meer gevalle hanteer. 
%"illustrator" verskil nou van HAT en Bresler - TODO
%strawwe
3s4traw1w
%strede (bestrede, gestrede, omstrede)
3s4tre1de
%streef
3s4treef1
%streek
3s4tree4k1
3s4tree4k2s
3s4tre3k2e
%streel
3s4treel1
%streep
3s4tree4p1
3s4tre3p2ie
3s4tre3p2e
%strel
3s4trel
%TODO: strem probleem: trem
%streng
3s4tren
%stres
3s4tres1
%TODO: moontlik probleme met samestellings met trust en ander st$
%strepe, strepies, ens.
3s4trep
%strewe
3s4trew
%stribbel
3s4trib1b
%strik
3s4trik
%string
3s4t2rin
%strokie
3s4tro1ki
%strompel, strome, trommel, 
3s4trom
4s5trom.
4s5trom1m
4s5trom1pet
3s4trom1p
%strooi
3s4trooi
%strook
3s4trook1
%stroom
3s4troom1
%stroop
3s4troop1
%struif, struik
3s4trui
4s5trui.
4s5truie
%struktuur
3s4truk1tuu4r1
3s4truk1tu
%struweling
3s4tru1w
%stry
3s4try
%stryd
3s4tryd
%stryk
3s4t4ryk
%stoornis
3s4t2oor1nis
%styl
3s4ty2l1
3s4ty3l2e
3s4ty3l2i

%super
.su1pe2r1
.su1pe3r2i

%sweer, swering
1s2weer1
aar2s3weer1
ie2s3weer1
rf2s3weer1
ng2s3weer1
ng2s3w
i2s3weer1
i2s1we
oor2s3weer1
oor2s3we
u2s3weer1
%probleem: oorsweer
1s2weri
bor2s3weri
bor2s1w
ie2s3weri
oe2s3weri

%trein
1trei2n1
1trei3n2e
1trei3n2i
on4t3rein

%toestand
1toe1stand

%toestel
1toe1stel

%toets
2ë1toets
2h1toets
2r3toets
2s3toets
%TODO:moontlik probleem met stoet...

%transaksie, transatlanties
1tran1sa
1tran2s1at

1tuig.

%tuin
1t2ui2n1
1t2ui3n2e
1t2ui3n2i
1t2ui4n3in
1t2ui5n4ing

.tui4s3

twee3
.twee5
tweeb2
tweed2
.tweeg2
tweek2
tweel2
tweem2
.tween2
tweep2
.tweer2
twees2
.tweet2
tweew2

%weelde:
t1wee4l1d
%sien ook weef, weeg, weer

1tyd1
tyd2s
tyd3skrif
ty1d2e
ty1d2i

%uit, suite
%sien ook .uit elders
%ui1te by ite
ui2t1ee
2s1uit
1s2ui1te

%unie
3u2nie
j4u3nie
2k1u2nie
2l1u2niea
3l2u3niet
2s1u2nie
2t1u2nie
se2u2nie
%probleem: aluniet

%uniform
3u2ni1form
4s3u2ni1form

%vak: 250 gevalle
.va2k1
.va3k2an1
.va3k2er
.va3k2ie
.va3k2u
.va4k3uit
.va4k3unie

%vinger GC Bresler
%vi4n4g3er1
%nee, eerder
1vin3ge4r3
%Meervoud is verkeerd, maar dit lyk asof meer goed gedoen word, met bv.
% vingerswaaiend, vingersetting, ens.
%TODO: oorweeg weer met meer woorde

%vis, visarend
vi2s3arend
%visetend, vister
vi2s3ete
vi1seur
%visolie
vi2s1o4lie

%vlak
.vla2k1
.vla3k2oe

%vlei
vl4ei

%vleis
1v4l4e4i4s
1v4l4e4i4s1a
1v4l4e4i4s1e
1v4l4e4i5s2e.
1v4l4e4i4s1in
1v4l4e4i4s1o
1v4l4e4i4s1u

1voël

%volstruis
vol1struis1
vol1strui1s2i
%sien ook strui by vaste vorme

%vors
vor4s1
vor5s2e
vor5s2i

%waardig
3w4aar1dig
3w4aar1de

%water
3wa1te2r3
3wa1te3r4ig
.k4water
%adekwaat
a1de1k4wa

%weef
1wee4f
1wee5fonds
%sweef
s2wee4f

%weeg
wee4g1

%weer
1weer1
1weer2s1om1
1weer2s3v
1weer2s3w
%sien ook sweer, twee 

%werk
1werk
wer2k1l
%probleem: hawerklap
wer3k2lank
wer3k2leur
.wer2k1r
.wer2k1w
wer1ko
wer2k1op1
wer2k1om1g
wer2k1om1s
%wer3k2om.
wer2k1on1
wer2k1ont1
wer2k1uur
wer2k1ure

%wêreld: 225 gevalle
1wê1rel4d1

%wet
1wet
%as teenvoeter vir dw reël (elders)
d3wet
k2wets
k2wet1ter
s2wel
s1wet
s2wets
s3wets1ont
s3wet.
s3wet1te.
s2wol

%winkel
3win1ke2l3
winkel4e
winke3l4ie

%winter
1win1te2r1
winter2s2
win1te

%wol
%TODO: beter? Is woordelys se woorde reg gespel?
1wo2l
1wo2l1a
1wo2l1d
1wo2l1g
1wo2l1i
1wo2l1m
1wo2l1o
1wo2l1p
1wo2l1s
re1wo3l2u
re1wo
2k1wol

%woord
3w4oo
4k3w4oo
%die volgende stem presies ooreen met oord elders
woo2r2d1
woo2r3d2a
woo2r4d3arm
woo2r3d2e
woo2r3d2ig
woo2r3d2in
woo2r3d2ing
woo2r3d2is1
woo2r4d3r

wyd1
wy1d2e
wy1di

%TODO:oorweeg weer:
3wy1se
3wy1ses

%yster (voorafgegaan deur [defgkmnpstu]) : 72 gevalle
yste2r1
yste2r2e
yste2r2ing
2d3ys2ter
2e3ys2ter
2f3ys2ter
2g3ys2ter
2k3ys2ter
2m3ys2ter
2n3ys2ter
2p3ys2ter
2s3ys2ter
2t3ys2ter
2u3ys2ter
ystert2


%ywer
e3y2wer
s3y2wer


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Uitsonderings
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Hierdie afdeling definieer uitsonderings waar lettergrepe miskien selfs korrek is,
%maar waar dit lees kan bemoeilik
a2me1ri1ka
a1me1ri

%beste-ding?
.bene6
.di2a1
.di2o1
.ina4
.ine4
%TODO: oorweeg mooi
i4o1na
i4o1ne
i4o1ni
i4o1no
i4o1nu
ge3p2oog
ge1po
%.ona4
.one4
%te4
5vil4le.
vil1l
%TODO:
ri4d4g4

.se3k2uur.
.se1ku


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Kombinasies met -= ig =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i1ge.
i1ger.
i1ges.
3aard.
aard1w
3aards.
2k3aard.
2k3aards.
2s3aard.
2s3aar1de.
2s3aards.
3aar3dig
4n3aar3dig
b4aard.
v4aard

%agtig, agtige
%TODO: hierdie eerste twee was gemerk met einde van woord merkers. Dalk?
3ag3tig.
ag1t
3ag3tig1heid
3ag3ti1ge
3ag3tigs.
3ag3tig1ste

2bag1tig
bag1t
2dag1tig
dag1t
n4d4ag1tig
2fag1tig
2gag1tig
2kag1tig
kag1t
4l1ag1tig
lag1t
sl4ag1tig
slag1t
2m4ag1tig
mag1t
%probleem: allamagtige, balsemagtige, skimagtige
%miskien kan 2 voor 2m4ag1tig dalk weggelaat word en negatiewe gevalle apart hanteer
%om-agtig, [bg]e-magtig, im-agtig, um-agtig blykbaar altyd waar
%be3m4agtig
%ge3m4agtig
i2m5agtig
o2m5agtig
u2m5agtig

2nagtig
nag1t
4pagtig
pag1t
2ragtig
rag1t
1d4r4agtig
drag1t
1k4r4agtig
krag1t
1pr4agtig
prag1t
1wr4agtig
wrag1t
4s3agtig
sag1t
.t4agtig
2t1agtig
%TODO: oorweeg reëls soos 2t1ag1tig, vir woorde soos vetagtig


.bi1g
1big
1bi1ge

1dig.
1di1ge
1di2g1ste.

1kund
1kuns
1bund

1tig.
1ti1ge
1ti2g1ste.

1jig1

1kig
1ki1ge
s2ki2g

%lig
1lig1
li1g2a
li1g2e
li1g2o
li2g3om
p2lig
%pligsbesef:
plig2s
ig2s.
%heiligskennis:
ilig2s

1mig
1mi1ge
1mi2g1ste.

1nig
1ni1ge
1ni2g1een
1ni1gi

r2ig.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Kombinasies met -= ing =-
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%sien ook in by vaste vorme
%dink nog daaroor 2 was 4
1d2ing
1f2ing
%5n4ging
3g4ing
%5n4gi3nge
%1g4i3nge

1h2in2g
j2in2g
1k2in2g
1l2in2g
%slinger
1s4lin1ger
s1l2ing
3m2ing
%TODO: oorweeg mooi: probleem: ondernemingskapitaal 
3m2ings1
1n2in2g
ko1nin3gin
ko1ni
3p2i2n2g
1ring
b2ring
d2ring
k2ring
1s2ing
1t2ing
1wi2ng
y1ing
%sien ook spring elders

%samestellingsgrense bv. kleingeld
ein1g
o1ing
%samestellingsgrense bv. tuingraf
tuin1g
%vernieu-ing
i4e4u3in2g
lin3guis

%din4g1e
%samestellings
3i4n5genieur
%ri3n4ge
%vi3n4ge
%wi3n4ge
%ook wingerd


%i3n4ge.
in3ge1

%belasting, ketting, rigting, vesting
be1las1tin4g3
be1las1tin4g4s
%ge1rin2g
%ketting
1ket1tin4g
1ket1tin4g1a
1ket1tin4g1e
1ket1tin4g1r
ket1t
1lin2g
1lin2g1a
1lin3ge
1lin2g1in
1lin2g1r
%koring
ko1rin4g
rig1tin4g
rig1t
ves1tin4g

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Trappe van vergelyking en verbuigings
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Sommige vroulike vorme is ook hier
4d3ste.
4d3stes.
es1te.
e2s3tes.
e2s3ter.
e2s3ters.
%probleem:môrester, sewester
%e3s4terf
%e3s4terk
%e3s4tert
%e3s4ter1w
%oe4s5tert
4f3ste.
4f3ster
4f3stes.
4g3ste.
4g3ster
4g3sters
%terapie, terme, termyn, terrein, tert  TODO: dalk nog?
4g4s1te1ra
4g4s1ter1m
4g4s1ter2m.
4g4s1ter1rei
4g3ster1r
4g3stes.
4k3ste.
4k3ster
4k4s1te1ra
4k3sters
4k3stes.
4l3ste.
4l3ster
4l3sters
4l3stes.
4m3ste.
4m3ster
4m3sters
4m3stes.
4n3ste.
4n3stes.
4n3ster
4n3sters
4n4s1te1ra
%monsteragtig:
4n5s2te2r1ag
%TODO: dalk eerder mons-ter in elkgeval?
4n3ster1m
4n3ster2m.
4n3ster1rei
4n3ster1r
4p3ste.
4p3ster
4p4s1ter1m
4p3stes.
4r3ste
4r4s1tee.
4r4s1teer
4r4s1teg
4r4s3te1hui
4r3ste1hu
4r4s1te1ken
4r3s2te1ke
4r4s1tem1po
4r4s1tend
%4r4s1tenin
%probleem: verstening vs kerstening
4r4s1tens
%probleem: barsten vs kersten, perstellegram
%asdf
4r3ster
4r3stes.
4t3ste.
4t3stes.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Grootskaalse konsonantopeenhoping
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%hierdies kan moontlik met party samestellings help
d2s1k2l
%f2s1g2r
g2s1t2r
ng2str
%sien ook stryk by vaste vorme
ng1dr
n2s1k2l
n2g2s1k2l
%sien spr by vaste vorme

2s1k2l2
%skelorse
1s2k2l2e1ro1


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Waaghalsige pogings tot samestellings en verbindingsklanke 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ps1m
%saan
2s3aan
me3s4aan
se3s4aan
mo3s4aan
s1lie
%TODO:oorweeg
%1s2lier

.eks1
.ek1s2a
.ek1s2e
.ek1s2i
.ek1s2o
.ek1s2u
.ek1s2y
ëks1
ëk1s2a
ëk1s2e
ëk1s2i
ëk1s2o
ëk1s2u
ëk1s2y
%probleem: ekstase


%vanaf die 2002-AWS. Samestellings en uitsonderings maak dit egter meer 
%kompleks
s1tr
b1s2tr
%probleem: jobstrane, jobstroos
s2trak
s2trek
s2trem
s2trib
s2triem
s2trop
s2trok
s2tronk

%TODO: kyk in nuwe HAT of iets. Volgens AWS sal voor of na die s aanvaarbaar 
%wees, maar miskien is hierdie beter.
1s2t2ro1fa
1s2t2ro1fe.
1s2t2ro1fes
1s2t2ro1fies
stro1fe
s1tro1fie


