## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

## no critic qw(ProhibitLongLines)
# $Id: P800Picture.pm 50 2009-01-31 09:22:52Z roland $
# $Revision: 50 $
# $HeadURL: svn+ssh://ipenburg.xs4all.nl/srv/svnroot/debbie/trunk/Date-Extract-P800Picture/lib/Date/Extract/P800Picture.pm$
# $Date: 2009-01-31 10:22:52 +0100 (Sat, 31 Jan 2009) $
## use critic

package TeX::Hyphen::Pattern::Pl_PL;
use strict;
use warnings;
use 5.006000;
use utf8;

our $VERSION = '0.03';

my $pattern_file = q{};
while (<DATA>) {
	 $pattern_file .= $_;
}

use Class::Meta::Express qw(class ctor has meta method);

class {

    ctor 'new';

    method data => sub {
		$pattern_file;
	};

    method version => sub {
		$VERSION;
	};

};

1;
## no critic qw(RequirePodAtEnd RequireASCII)
=encoding utf8

=head1 C<Pl_PL> hyphenation pattern class

=head1 Copyright

The data for this library is copied from the OpenOffice.org project and
modified to be used as a Perl module by Roland van Ipenburg.

L<http://svn.services.openoffice.org/ooo/trunk/dictionaries/pl_PL/>

	Hyphenation dictionary
	----------------------

	Language: Polish (pl PL).
	Origin:   Based on the TeX hyphenation patterns plhyph.tex,
	version 3.0a, Wednesday, May 17th, 1995

	The first version of the patterns was developed
	by Hanna Ko³odziejska (1987).

	The adaptation to the LeX format (see below) and extensive modification
	were done by Bogus³aw Jackowski & Marek Ryæko (1987--1989).

	The hyphenation rules were further improved and adapted to the
	TeX 3.x requirements by Hanna Ko³odziejska (1991).

	Lone-standing version (3.0a) of patterns was prepared (under pressure
	from LaTeX users) by Bogus³aw Jackowski and Marek Ryæko, following
	Mariusz Olko's suggestions, 1995.

	The LeX format mentioned above was the first version of the adaptation
	of TeX to the Polish language. The next version is called MeX.

	The original macro file plhyph.tex belongs to the public domain
	under the conditions specified by the author of TeX:

	   ``Macro files like PLAIN.TEX should not be changed in any way,
		 except with respect to preloaded fonts,
		 unless the changes are authorized by the authors of the macros.''

											   Donald E. Knuth 

	Current license:  GNU LGPL license.
	Author:  conversion and corrects author is
			  Artur Polaczyñski <artiip@gmail.com>

	HYPH pl PL hyph_pl_PL

=cut

__DATA__
ISO8859-2
.a1
.a2b1s
.a2b2s3t
.a2d3
.a1d4a1
.ad4e1
.ad4i1
.ad4o1
.ad4u1
.ad4y1
.ad5a2p1t
.ad5i2u1
.ad5op
.ad5or
.ae2
.ae3ro1
.a1eroa2
.ae1roe2
.aeroi2
.aero1o2
.aerou2
.a2n1t
.anty1
.a1ntya2
.antye2
.antyi2
.antyo2
.antyu2
.a2r1c
.arcy1
.arcy3b2
.arcy3b1z2
.arcy3k2
.arcy3ł2
.arcy3m2
.a1rcya2
.arcye2
.arcyi2
.arcyo2
.arcyu2
.a2u1
.au3g2
.au3k2
.au3t2
.auto1
.auto3c4h2
.a1utoa2
.autoe2
.autoi2
.auto1o2
.a1utotra1
.autotra2n2s3
.au1tou2
.b8
.4b3b8
.2b1c8
.2b1ć8
.2b1d8
.be1
.be2z3
.beza1
.be3z4an
.be1ze1
.be3z4ec
.bezi1
.be3z4ik
.be2z1c
.bezc4h2
.bezm2
.bezo2
.bezo2b1j
.bezw2
.be4z3z
.bezzw2
.2b1f8
.2b1g8
.bh8
.bj8
.2b1k8
.bl8
.bł8
.2b1m8
.2b1n8
.2b1ń8
.2b1p8
.br8
.br4z8
.2b1s8
.2b1ś8
.2b1t8
.bv8
.bw8
.bx8
.2b1z8
.2b1ź8
.2b1ż8
.c8
.ca1
.cało1
.cało3k2
.cało3ś2
.2c1b8
.4c3c8
.2c1ć8
.2c1d8
.2c1f8
.2c1g8
.c4h8
.c2h2r
.chr4z8
.ci1
.ci2e1
.cie2n1k
.cienko1
.cienko3w2
.ciepło1
.ciepło3kr2
.cj8
.2c1k8
.2c1l8
.cł8
.2c1m8
.2c1n8
.2c1ń8
.2c1p8
.cr8
.2c1s8
.2c1ś8
.2c1t8
.cv8
.cw8
.cx8
.c4z8
.cza1
.cza2r1n
.czarno1
.czarno3k2
.2c2z1k8
.2c2z1t
.czte1
.czte1re1
.cztere2c4h3
.cztere2c2h1s
.czte1re1chse1
.czterechse2t3
.cztero1
.cztero3ś2
.czwó1
.czwó2r3
.czwó3r4a1
.czwó3r4ą1
.czwó3r4e1
.czwó3r4ę1
.czwó3r4o1
.2c1ź8
.2c1ż8
.ć8
.2ć1b8
.2ć1c8
.4ć3ć8
.2ć1d8
.2ć1f8
.2ć1g8
.ćh8
.ćj8
.2ć1k8
.ćl8
.ćł8
.2ć1m8
.2ć1n8
.2ć1ń8
.2ć1p8
.ćr8
.2ć1s8
.2ć1ś8
.2ć1t8
.ćv8
.ćw8
.ćwi1
.ćwi2e1
.ćwie2r2ć3
.ćx8
.2ć1z8
.2ć1ź8
.2ć1ż8
.d8
.da1
.dale1
.daleko1
.daleko3w2
.2d1b8
.2d1c8
.2d1ć8
.4d3d8
.de1
.de2z3
.deza2
.dezabi1
.de3z4a3bil
.de3z4a3wu1
.de1ze1
.de3z4el
.de3z4er
.de3z4y1
.dezo2
.2d1f8
.2d1g8
.dh8
.dj8
.2d1k8
.dl8
.dł8
.dłu1
.długo1
.długo3tr2
.długo3w2
.2d1m8
.2d1n8
.2d1ń8
.do1
.do3b2
.do3c2
.do3ć2
.do3d2
.do3f2
.do3g2
.do3h2
.do3k2
.do3l2
.do3ł2
.do3m2
.do3p2
.do3r2
.do3s2
.do3ś2
.do3t2
.do3w2
.do3z2
.do3ź2
.do3ż2
.do4k3t
.do4l3n
.do4ł3k
.do4m3k
.do4r3s
.do4w3c
.do5m4k2n
.dobr2
.dobr4z2
.doc4h2
.doc4z2
.dod4z2
.dod4ź2
.dod4ż2
.dogr4z2
.do2p1c
.dopc4h2
.dopr4z2
.dor4z2
.do2r1ż2
.dosc4h2
.dosm2
.dos4z2
.do2t1k2
.dotr2
.2d1p8
.dr8
.dro1
.dro1go1
.drogo3w2
.dr4z8
.2d1s8
.2d1ś8
.2d1t8
.dv8
.dw8
.dwó1
.dwó2j3
.dwó3j4a1
.dwó3j4ą1
.dwó3j4e1
.dwó3j4ę1
.dwó3j4o1
.dx8
.dy1
.dy2s3
.dy2z3
.dy3s4e1
.dy3s4o1
.dy3s4ta1
.dy3s4y1
.dy3s4z
.dy3z4e1
.dyzu2
.d4z8
.dzi1
.dzi2e1
.dzi1esi1
.dziesi2ę1
.dzi1esi1ęci1
.dziesięci2o1
.dziesięcio3ś2
.dzi1ewi1
.dziewi2ę1
.dziewię2ć3
.dzi1ewi1ęci1
.dziewięci2o1
.dziewięcio3ś2
.dziewię2ć1s
.dzie1więćse1
.dziewięćse2t3
.d4ź8
.d4ż8
.e1
.e2k2s3
.e1me1
.emes4z
.e1me1sze1
.e2m3e2s5ze2t
.e1se1
.e2s1e2s1ma1
.e2s1ha1
.e2s1t
.ego1
.egoa2
.e1goe2
.egoi2
.ego1o2
.egou2
.eks4y1
.e1le1
.ele2k1t
.elektro1
.elektroa2
.e1le1ktroe2
.elektroi2
.elektro1o2
.elektrou2
.f8
.fb8
.2f1c8
.fć8
.fd8
.4f3f8
.fg8
.fh8
.fj8
.2f1k8
.fl8
.fł8
.2f1m8
.2f1n8
.fń8
.fp8
.fr8
.fs8
.fś8
.ft8
.fv8
.fw8
.fx8
.fz8
.fź8
.fż8
.g8
.2g1b8
.2g1c8
.2g1ć8
.2g1d8
.ge1
.ge2o3
.2g1f8
.4g3g8
.gh8
.gj8
.2g1k8
.gl8
.gł8
.2g1m8
.gn8
.2g1ń8
.go1
.go2u3
.2g1p8
.gr8
.gru1
.grubo1
.grubo3w2
.gr4z8
.2g1s8
.2g1ś8
.2g1t8
.gv8
.gw8
.gx8
.2g1z8
.2g1ź8
.2g1ż8
.h8
.2h1b8
.2h1c8
.2h1ć8
.2h1d8
.2h1f8
.2h1g8
.4h3h8
.hi1
.hipe1
.hipe2r3
.hipe3r4o1
.hipera2
.hipe1re2
.2h1j8
.2h1k8
.2h1l8
.2h1ł8
.2h1m8
.2h1n8
.2h1ń8
.2h1p8
.2h1r8
.2h1s8
.2h1ś8
.2h1t8
.hv8
.2h1w8
.hx8
.2h1z8
.2h1ź8
.2h1ż8
.i1
.i2n3
.i2s3l
.i1ni1
.i3n4ic
.i3n4o1
.i3n4u1
.i4n5o2k
.i2n1f
.infla1
.in4f3lan
.ino3w2
.izo1
.izoa2
.izoe2
.i1zoi2
.izo1o2
.izou2
.j8
.ja1
.jadło1
.jadło3w2
.2j1b8
.2j1c8
.2j1ć8
.2j1d8
.2j1f8
.2j1g8
.2j1h8
.4j3j8
.2j1k8
.2j1l8
.2j1ł8
.2j1m8
.2j1n8
.2j1ń8
.2j1p8
.2j1r8
.2j1s8
.2j1ś8
.2j1t8
.jv8
.2j1w8
.jx8
.2j1z8
.2j1ź8
.2j1ż8
.k8
.2k1b8
.2k1c8
.2k1ć8
.2k1d8
.2k1f8
.2k1g8
.kh8
.ki1
.ki2l1k
.kilku1
.kilkuse1
.kilkuse2t3
.kilkuseto2
.kj8
.4k3k8
.kl8
.kł8
.2k1m8
.2k1n8
.2k1ń8
.ko1
.ko1ło1
.koło3w2
.ko2n1t
.kon2t2r3
.kon3tr4a1
.kon3tr4e1
.ko1ntro2
.kon3tr4o3l
.kon3tr4o3w
.kon3tr4y1
.kon4tr5a2gi1
.kon4tr5a2se1
.kon4tr5a2sy1
.kon4tr5a2ta1
.kon4tr5a2d1m
.kon4tr5a2k1c
.kon4tr5a2l1t
.kon4tr5a2r1g
.kontru2
.2k1p8
.kr8
.kro1
.kro2ć3
.kró1
.kró2t1k
.krótko1
.krótko3tr2
.krótko3w2
.kr4z8
.2k1s8
.2k1ś8
.2k1t8
.kv8
.kw8
.kx8
.2k1z8
.2k1ź8
.2k1ż8
.l8
.2l1b8
.2l1c8
.2l1ć8
.2l1d8
.2l1f8
.2l1g8
.2l1h8
.2l1j8
.2l1k8
.4l3l8
.2l1ł8
.2l1m8
.2l1n8
.2l1ń8
.2l1p8
.2l1r8
.2l1s8
.2l1ś8
.2l1t8
.lu1
.ludo1
.ludo3w2
.lv8
.2l1w8
.lx8
.2l1z8
.2l1ź8
.2l1ż8
.ł8
.2ł1b8
.2ł1c8
.2ł1ć8
.2ł1d8
.2ł1f8
.2ł1g8
.2ł1h8
.2ł1j8
.2ł1k8
.2ł1l8
.4ł3ł8
.2ł1m8
.2ł1n8
.2ł1ń8
.2ł1p8
.2ł1r8
.2ł1s8
.2ł1ś8
.2ł1t8
.łv8
.2ł1w8
.łx8
.2ł1z8
.2ł1ź8
.2ł1ż8
.m8
.2m1b8
.2m1c8
.2m1ć8
.2m1d8
.2m1f8
.2m1g8
.2m1h8
.mi1
.mi1li1
.mili2a1
.mili3a2m1p
.2m1j8
.2m1k8
.2m1l8
.2m1ł8
.4m3m8
.2m1n8
.2m1ń8
.mo1
.mo2ż1n
.mo1żno1
.możno3w2
.2m1p8
.2m1r8
.2m1s8
.2m1ś8
.2m1t8
.mv8
.2m1w8
.mx8
.2m1z8
.2m1ź8
.2m1ż8
.n8
.na1
.na2d2
.na2j
.na3b2
.na3c2
.na3ć2
.nad3i2
.na3d4ir
.nad3ł2
.nadłu1
.na3d4łub
.na2d3m2
.nadmu1
.na3d4muc4h
.nad3r2
.na3d4r2w
.nadre1
.nadre2p1c
.na3d4repc4z
.na3d4re2p1t
.nadrę1
.na3d4ręc4z
.nadru1
.na3d4ruk
.na3d4r4z
.nad3w2
.nadwo1
.na3d4wo2r1n
.na1da1
.na3daj
.na3dą1
.na3de1
.na3dę1
.na3do1
.na3dy1
.nad4z2
.na3dzi1
.na3d4ź2
.na3f2
.na3g2
.na3h2
.na1ja1
.na3ja2z1d
.na3ją1
.na3je1
.na3ję1
.na3k2
.na3l2
.na3ł2
.na3m2
.na3p2
.na3r2
.na3s2
.na3ś2
.na3t2
.na3u2
.na3w2
.na3z2
.na3ź2
.na3ż2
.na4d3o2b2ł
.nado1bo1
.nadobo2j1c
.na4d3o2bojc4z
.na4d3o2bowi1
.nado1bro1
.na4d3o2brot
.na4d3o2dr4z
.nadoki1
.nadoki2e1
.na4d3o2kien
.nado2l1b
.na4d3olbr4z
.na4d5rzą1
.nadrze1
.na4d5rzec4z
.na4d5rzę1
.na4d5rzy1
.nadzi2e1
.na4d5ziem
.na4f3c
.na4f3t
.na4j3e2f
.na4j3e2g
.na4j3e2k2s
.na4j3e2ko1
.na4j3e2n
.na4j3e2r
.na4j3e2s
.na4j3e2w
.na4j3e2m1f
.na4j3e2u1
.na4r3c
.na4r3d
.na4r3k
.na4r3r
.na4r3t
.nabr4z2
.nac4h2
.nac4z2
.na2d3b2
.na2d3c2
.na2d3ć2
.na4d3d2
.nade3t2
.na1deta1
.nad3e2tat
.na2d3f2
.na2d3g2
.nad3h2
.nad3j2
.na2d3k2
.nad3l2
.na2d3n2
.na2d3p2
.na2d3s2
.na2d3ś2
.na2d3t2
.nad3u2
.na2dz1m
.nadzmy1
.nad5z2mys
.nad5zo1
.nad5zó1
.nadzwy1
.nad5zwyc4z
.nad5ż2
.nadc4h2
.nadc4z2
.nadd4ź2
.nade3b2
.nade3c2
.nade3ć2
.nade3d2
.nade3f2
.nade3g2
.nade3h2
.nade3k2
.nade3l2
.nade3ł2
.nade3m2
.nade3p2
.nade3r2
.nade3s2
.nade3ś2
.nade3w2
.nade3z2
.nade3ź2
.nade3ż2
.nade4p3c
.nade4p3n
.nade4p3t
.nadec4h2
.nadec4z2
.naded4z2
.naded4ź2
.naded4ż2
.nader4z2
.nade2r1ż2
.nades4z2
.nads4z2
.nadśro1
.nadśrod4z
.nadśrodzi1
.nadśrodzi2e1
.nadśrod5ziem
.nadtr2
.nagr4z2
.naj3a2k1t
.naj3a2u1
.na2j3b2
.na2j3c2
.na2j3ć2
.na2j3d2
.na2j3f2
.na2j3g2
.na2j3h2
.naj3i2
.na2j3k2
.na2j3l2
.na2j3ł2
.na2j3m2
.naj3o2
.naj3o2b2
.naj3o2c2
.naj3o2ć2
.naj3o2d2
.naj3o2f2
.naj3o2g2
.naj3o2h2
.naj3o2k2
.naj3o2l2
.naj3o2ł2
.naj3o2m2
.naj3o2p2
.naj3o2r2
.naj3o2s2
.naj3o2ś2
.naj3o2t2
.naj3o2w2
.naj3o2z2
.naj3o2ź2
.naj3o2ż2
.na2j3p2
.na2j3r2
.najro1
.naj3ro2z3
.na2j3s2
.na2j3ś2
.na2j3t2
.naj3u2
.na2j3w2
.na2j3z2
.na2j3ź2
.na2j3ż2
.najbe1
.najbe2z3
.najbezw2
.najc4h2
.najc4z2
.najdo1
.najdo3b2
.najdo3c2
.najdo3ć2
.najdo3d2
.najdo3f2
.najdo3g2
.najdo3h2
.najdo3k2
.najdo3l2
.najdo3ł2
.najdo3m2
.najdo3p2
.najdo3r2
.najdo3s2
.najdo3ś2
.najdo3t2
.najdo3w2
.najdo3z2
.najdo3ź2
.najdo3ż2
.najdoc4h2
.najdoc4z2
.najdod4z2
.najdod4ź2
.najdod4ż2
.najdor4z2
.najdos4z2
.najdo2t1k2
.najd4z2
.najd4ź2
.najd4ż2
.najkr2
.najo2b3c2
.najo2b3ć2
.najo2b3d2
.najo2b3f2
.najo2b3g2
.najob3h2
.najob3j2
.najo2b3k2
.najob3l2
.najob3ł2
.najo2b3m2
.najo2b3n2
.najo2b3p2
.najo2b3s2
.najo2b3ś2
.najo2b3t2
.najob3w2
.najo2b3ź2
.najo2b3ż2
.najobc4h2
.najobc4z2
.najobd4z2
.najobd4ź2
.najobd4ż2
.najobr4z2
.najobs4z2
.najoc4h2
.najoc4z2
.najo2d3c2
.najo2d3ć2
.najo4d3d2
.najo2d3f2
.najo2d3g2
.najod3h2
.najod3j2
.najo2d3k2
.najod3l2
.najo2d3m2
.najo2d3n2
.najo2d3p2
.najo2d3s2
.najo2d3ś2
.najo2d3t2
.najod3w2
.najod5ż2
.najodc4h2
.najodc4z2
.najodd4z2
.najodd4ź2
.najodd4ż2
.najods4z2
.najod4z2
.najod4ź2
.najor4z2
.najos4z2
.najro3z4u1
.najr4z2
.najsm2
.najs4z2
.naj2t1k2
.naj2t1r2
.najuc4z2
.najzw2
.nakr2
.napo1
.napo2d2
.napo3b2
.napo3c2
.napo3ć2
.napo3f2
.napo3g2
.napo3h2
.napo3k2
.napo3l2
.napo3ł2
.napo3m2
.napo3p2
.napo3r2
.napo3s2
.napo3ś2
.napo3t2
.napo3w2
.napo3z2
.napo3ź2
.napo3ż2
.napo4m3p
.napoc4h2
.napoc4z2
.napo4d3d
.napod4ź2
.napod4ż2
.napo2m1k2
.napor4z2
.napos4z2
.napr4z2
.naro1
.naro2z3
.nar4z2
.na2r1ż2
.nasm2
.nas4z2
.na2t1c
.natc4h2
.na2t1k2
.naz3m2
.nazw2
.2n1b8
.2n1c8
.2n1ć8
.2n1d8
.ne1
.ne2o3
.2n1f8
.2n1g8
.2n1h8
.ni1
.ni2e1
.nie3b2
.nie3c2
.nie3ć2
.nie3d2
.nie3f2
.nie3g2
.nie3h2
.nie3k2
.nie3l2
.nie3ł2
.nie3m2
.nie3p2
.nie3r2
.nie3s2
.nie3ś2
.nie3t2
.nie3u2
.nie3w2
.nie3z2
.nie3ź2
.nie3ż2
.nie4c3c
.nie4c3k
.nie4d4ź3
.nie4m3c
.nie4m3k
.niec4h2
.niec4z2
.niedo1
.niedo3b2
.niedo3c2
.niedo3ć2
.niedo3d2
.niedo3f2
.niedo3g2
.niedo3h2
.niedo3k2
.niedo3l2
.niedo3ł2
.niedo3m2
.niedo3p2
.niedo3r2
.niedo3s2
.niedo3ś2
.niedo3t2
.niedo3w2
.niedo3z2
.niedo3ź2
.niedo3ż2
.niedobr4z2
.niedoc4h2
.niedoc4z2
.niedod4z2
.niedod4ź2
.niedod4ż2
.niedokr2
.niedo2m1k2
.niedo2p1c
.niedopc4h2
.niedor4z2
.niedos4z2
.niedo2t1k2
.nied4z2
.nied4ż2
.nieo2
.nieob2
.nieo2b3c2
.nieo2b3ć2
.nieo2b3d2
.nieo2b3f2
.nieo2b3g2
.nieob3h2
.nieob3j2
.nieo2b3k2
.nieo2b3m2
.nieo2b3p2
.nieo2b3s2
.nieo2b3ś2
.nieob3w2
.nieo2b3ź2
.nieo2b3ż2
.nieobc4h2
.nieobc4z2
.nieobd4z2
.nieobd4ź2
.nieobd4ż2
.nieobs4z2
.nieoc2
.nieoc4h2
.nieoc4z2
.nieoć2
.nieod2
.nieo2d3c2
.nieo2d3ć2
.nieo4d3d2
.nieo2d3f2
.nieo2d3g2
.nieod3h2
.nieod3j2
.nieo2d3k2
.nieod3l2
.nieod3ł2
.nieo2d3n2
.nieo2d3p2
.nieo2d3s2
.nieo2d3ś2
.nieo2d3t2
.nieodw2
.nieod3w1r
.nieod5ż2
.nieodc4h2
.nieodc4z2
.nieodd4z2
.nieodd4ź2
.nieodd4ż2
.nieods4z2
.nieod4z2
.nieod4ź2
.nieof2
.nieog2
.nieoh2
.nieok2
.nieol2
.nieoł2
.nieom2
.nieop2
.nieor2
.nieor4z2
.nieos2
.nieos4z2
.nieoś2
.nieot2
.nieow2
.nieoz2
.nieoź2
.nieoż2
.niepo1
.niepo2d2
.niepo3b2
.niepo3c2
.niepo3ć2
.niepod3ł2
.niepo3d4łu1
.niepo2d3m2
.niepodmu1
.niepo3d4muc4h
.niepod3r2
.niepodra1
.niepo3d4rap
.niepo3d4raż
.nie1podre1
.niepodre2p1c
.niepo3d4repc4z
.niepo3d4re2p1t
.niepodrę1
.niepo3d4ręc4z
.niepod3w2
.niepodwa1
.niepo3d4waj
.niepo1dwo1
.niepo3d4woj
.niepo3do1
.niepo3du1
.niepo3d4z2
.niepo3d4ź2
.niepo3f2
.niepo3g2
.niepo3h2
.niepo3k2
.niepo3l2
.niepo3ł2
.niepo3m2
.niepo3p2
.niepo3r2
.niepo3s2
.niepo3ś2
.niepo3t2
.niepo3w2
.niepo3z2
.niepo3ź2
.niepo3ż2
.niepodoc4h
.niepo1do1cho1
.niepo4d3o2choc
.niepo4d3o2str4z
.niepoc4h2
.niepoc4z2
.niepo2d3b2
.niepo2d3c2
.niepo2d3ć2
.niepo4d3d2
.niepo2d3f2
.niepo2d3g2
.niepod3h2
.niepod3j2
.niepo2d3k2
.niepod3l2
.niepo2d3n2
.niepo2d3p2
.niepo2d3s2
.niepo2d3ś2
.niepo2d3t2
.niepod5ż
.niepodc4h2
.niepodc4z2
.niepodd4ź2
.niepodd4ż2
.niepodsm2
.niepods4z2
.niepor4z2
.nieposm2
.niepos4z2
.niepr4z
.nie1prze1
.nieprze2d2
.nieprze3b2
.niepr4ze3br4z2
.nieprze3c2
.nieprze3ć2
.nieprzed3ł2
.nieprzedłu1
.nieprze3d4łuż
.nieprze2d3m2
.nieprzedmu1
.nieprze3d4muc4h
.nieprzed3r2
.nieprzedra1
.nieprzedra1ma1
.nieprze3d4ramat
.nieprzedru1
.nieprze3d4ruk
.nieprzedry1
.nieprze3d4ryl
.niepr4ze3d4r4z2
.nieprzed3u2
.nieprze3d4um
.nieprze3dy1
.nieprze3d4z2
.nieprze3d4ź2
.nie1prze1e2
.nieprze3e2k2s3
.nieprze3f2
.nieprze3g2
.nieprze3h2
.nieprze3k2
.nieprze3l2
.nieprze3ł2
.nieprze3m2
.nieprze3n2
.nieprze3p2
.nieprze3r2
.nieprze3s2
.nieprze3ś2
.nieprze3t2
.nieprze3w2
.nieprze3z2
.nieprze3ź2
.nieprze3ż2
.nieprzedłuży1
.nieprze4d5łużyc
.nieprze4d5z2a1
.nieprze4d5z1g2
.ni1eprzedzi1
.nieprze4d5zim
.nieprze4d5zj
.nieprze4d5z1l
.nieprze4d5z2w2r
.nieprzedzwo1
.nieprze4d5zwoj
.nieprze4d5ż2
.nieprzec4h2
.nieprzec4z2
.nieprze2d3c2
.nieprze2d3ć2
.nieprze4d3d2
.nieprze2d3f2
.nieprze2d3g2
.nieprzed3h2
.ni1eprzed3i2
.nieprzed3j2
.nieprze2d3k2
.nieprzed3l2
.nieprze2d3n2
.nieprze2d3p2
.nieprze2d3s2
.nieprzed3s4z2
.nieprze2d3ś2
.nieprze2d3t2
.nieprzed3w2
.nieprzedc4h2
.nieprzedc4z2
.nieprzedd4z2
.nieprzedd4ź2
.nieprzedd4ż2
.niepr4zegr4z2
.nieprzekl2
.nieprzekr2
.nieprze2ł1k2
.nieprze2p1c
.nieprzepc4h2
.niepr4zer4z2
.nieprze2r1ż2
.nieprzesc4h2
.nieprzesm2
.nieprzes4z2
.nieprze2t1k2
.nieprzetr2
.niero1
.niero2z3
.nie1ro3z4e1
.niero3z4u1
.nierozbr4z2
.nieroze3r2
.nierozm2
.niero2z1ś2
.niero2z1t
.nieroztr2
.nier4z2
.niesu1
.niesu2b3
.ni1esubi1
.ni2e1su3b4i2e1
.nies4z2
.nie2t1k2
.nietr2
.nieuc4z2
.nieuw2
.niewy1
.niewy3b2
.niewy3c2
.niewy3ć2
.niewy3d2
.niewy3f2
.niewy3g2
.niewy3h2
.niewy3k2
.niewy3l2
.niewy3ł2
.niewy3m2
.niewy3p2
.niewy3r2
.niewy3s2
.niewy3ś2
.niewy3t2
.niewy3w2
.niewy3z2
.niewy3ź2
.niewy3ż2
.niewybr4z2
.niewyc4h2
.niewyc4z2
.niewyd4z2
.niewyd4ź2
.niewyd4ż2
.niewyr4z2
.niewys4z2
.niewy2t1k2
.niewytr2
.niezw2
.2n1j8
.2n1k8
.2n1l8
.2n1ł8
.2n1m8
.4n3n8
.2n1ń8
.2n1p8
.2n1r8
.2n1s8
.2n1ś8
.2n1t8
.nv8
.2n1w8
.nx8
.2n1z8
.2n1ź8
.2n1ż8
.ń8
.2ń1b8
.2ń1c8
.2ń1ć8
.2ń1d8
.2ń1f8
.2ń1g8
.2ń1h8
.2ń1j8
.2ń1k8
.2ń1l8
.2ń1ł8
.2ń1m8
.2ń1n8
.2ń1ń8
.2ń1p8
.2ń1r8
.2ń1s8
.2ń1ś8
.2ń1t8
.ńv8
.2ń1w8
.ńx8
.2ń1z8
.2ń1ź8
.2ń1ż8
.o1
.o2b2
.o2d2
.ot2
.o2t1c
.otc4h
.o2t3c2h2ł
.ob3l2
.oblu1
.o3b4luzg
.ob3ł2
.o3b4łą1
.o3b4łę1
.o1bło1
.o3b4łoc
.ob3r
.obra1
.o3b4rać
.o3b4raso1
.o1bro1
.o3b4ron
.o3b4roń
.obry1
.o3b4ryz
.o3b4ryź
.o3b4r4z2
.o3be1
.o3bi1
.od3i2
.o3d4i2u1
.od3r2
.odra1
.o3d4rap
.odrę1
.o3d4ręt
.o1dro1
.odrobi1
.o3d4robin
.odru1
.o3d4rut
.od2r1w
.o3d4rwi1
.odr4z2
.odrze1
.o3d4rzeć
.o3d4rz2w
.od5z2
.odzi1
.o3d6zi2a1
.o3d6zi2e1
.o3de1
.o2l1ś
.o3l2śn
.o4b5łoc4z
.o4b5rzą1
.obrze1
.o4b5rzez
.obrzę1
.o4b5rzęd
.obrzu1
.o4b5rzuc
.o4b5rzut
.obrzy1
.o4b5rzyn
.o4d7ziar
.o4d7ziem
.oa2
.oa3z
.o2b3c2
.o2b3ć2
.o2b3d2
.o2b3f2
.o2b3g2
.ob3h2
.ob3j2
.o2b3k2
.o2b3m2
.o2b3n2
.o1bo1
.ob3o2str4z
.o2b3p2
.o2b3s2
.o2b3ś2
.o2b3t2
.obu1
.ob3u2m2
.ob3w2
.o2b3ź2
.o2b3ż2
.obc4h2
.obc4z2
.obd4z2
.obd4ź2
.obd4ż2
.obe3b2
.obe3c2
.obe3ć2
.obe3d2
.obe3f2
.obe3g2
.obe3h2
.obe3k2
.obe3l2
.obe3ł2
.obe3m2
.obe3p2
.obe3r2
.obe3r3t
.obe3s2
.obe3ś2
.obe3t2
.obe3w2
.obe3z2
.obe3ź2
.obe3ż2
.obe4c3n
.obe4z3w
.obec4h2
.obec4z2
.obed4z2
.obed4ź2
.obed4ż2
.obe2r3m
.ober4z2
.obe2r1ż2
.obesc4h2
.obes4z2
.obe2t1k2
.obi3b2
.obs4z2
.oc2
.oc4h2
.oc2h2r
.ochr4z2
.oc4z2
.oć2
.oda1
.od3a2u1
.o2d3b2
.o2d3c2
.o2d3ć2
.o4d3d2
.o2d3f2
.o2d3g2
.od3h2
.o1d3i2zo1
.od3j2
.o2d3k2
.od3l2
.o2d3m2
.o2d3n2
.o1do1
.od3o2s
.o2d3p2
.o2d3s2
.o2d3ś2
.o2d3t2
.odu1
.od3u2c4z
.od3u2m2
.od3w2
.od5ż2
.odbe1
.odbe2z3
.odc4h2
.odc4z2
.odd4z2
.odd4ź2
.odd4ż2
.ode3b2
.ode3c2
.ode3ć2
.ode3d2
.ode3f2
.ode3g2
.ode3h2
.ode3k2
.ode3l2
.ode3ł2
.ode3m2
.ode3m1k2
.ode3p2
.ode3r2
.ode3s2
.ode3ś2
.ode3t2
.ode3w2
.ode3z2
.ode3ź2
.ode3ż2
.odec4h2
.odec4z2
.oded4z2
.oded4ź2
.oded4ż2
.ode2p1c
.odepc4h2
.oder4z2
.ode2r1ż2
.odes4z2
.ode2t1c
.odetc4h2
.ode2t1k2
.odkr4z2
.ods4z2
.od4ź2
.of2
.og2
.ogni1
.o1gni2o1
.ognio3tr2
.ogó1
.ogó2l1n
.o1gólno1
.ogólno3k2
.oh2
.ok2
.oka1
.oka3m2
.okr2
.ole1
.o1le2o3
.om2
.op2
.o2p1c
.opc4h2
.o2r1t
.or2tę1
.or4z2
.o2r2ż2
.os2
.osi1
.osi2e1
.osie2m3
.osie2m1s
.osie1mse1
.osiemse2t3
.os4z2
.oś2
.ośmi1
.o1śmi2o1
.ośmio3ś2
.ow2
.oz2
.oź2
.oż2
.p8
.2p1b8
.2p1c8
.pc4h8
.2p1ć8
.2p1d8
.pe1
.pe2r3
.pe3c2k
.pe3r4e1
.pe3r4i1
.pe3r4o1
.pe3r4u1
.pe3r4y1
.pe4r5i2n
.pe1e2
.pe1e1se1
.pee2se2l
.pe2ł1n
.pełno1
.pełno3kr2
.pe1pe1
.pe1pe1e2
.pepee2r
.pepee2s
.pe1ze1
.peze2t1p
.pe1ze1tpe1
.pe1ze1tpe1e2
.peze2t1pee2r
.2p1f8
.2p1g8
.ph8
.pi1
.pi2e1
.pie2r1w
.pierwo1
.pierwo3w2
.pi2ę1
.pię2ć3
.pi1ęci1
.pięci2o1
.pięcio3ś2
.pię2ć1s
.pięćse1
.pięćse2t3
.pi2o1
.pio1no1
.piono3w2
.pj8
.2p1k8
.pl8
.pł8
.pła1
.płasko1
.płasko3w2
.2p1m8
.2p1n8
.2p1ń8
.po1
.po2d2
.po3b2
.po3c2
.po3ć2
.pod3ł2
.po3d4łu1
.po2d3m2
.podmu1
.po3d4muc4h
.po2d3n2
.podna1
.po3d4naw
.pod3r2
.pod2r1w
.po3d4r2wi1
.podra1
.po3d4rap
.po3d4raż
.podre1
.podre2p1c
.po3d4repc4z
.po3d4re2p1t
.podrę1
.po3d4ręc4z
.po3d4rętw
.po1dro1
.po3d4roba1
.po3d4ro1bo1
.po3d4robó1
.po3d4roby1
.po3d4roc4z
.po3d4roż
.podró1
.po3d4róż
.podru1
.po3d4ruzg
.podry1
.po3d4ryg
.podr4z
.po3d4rze1
.pod3w2
.podwa1
.po3d4waj
.po1dwo1
.po3d4woi2
.po3d4woj
.po3d4wor4z
.podwó1
.po3d4wó2j1n
.po3d4wór
.po3da1
.po3dą1
.po3de1
.po3dej
.po3dę1
.podi1
.po3di2u1
.po3do1
.po3du1
.po3dy1
.po3d4z2
.po3d4ź2
.poe2
.po3e2k2s3
.po3f2
.po3g2
.po3h2
.po3k2
.po3l2
.po3ł2
.po3m2
.po3p2
.po3r2
.po3r1ż
.po3s2
.po3ś2
.po3t2
.po3w2
.po3z2
.po3ź2
.po3ż2
.poc4z2
.po4c2z3d
.po4c2z3t
.pode3k2
.po4d3e4k2s3
.podobi1
.podobi2a1
.po4d3o2biad
.po1do1bo1
.podobo2j1c
.po4d3o2bojc4z
.podobó1
.po4d3o2bóz
.podobra1
.po4d3o2braz
.podoc4h
.po1do1cho1
.po4d3o2choc
.po4d3o2d1m
.po4d3o2f
.po4d3o2g
.podoki1
.podoki2e1
.po4d3o2kien
.po4d3o2k1n
.podokre1
.po4d3o2kres
.podokrę1
.po4d3o2kręg
.podopi1
.podopi2e1
.po4d3o2piec4z
.podory1
.po4d3o2ryw
.podosi1
.podosi1ni1
.podosini2a1
.po4d3o2siniak
.po4d3o2str4z
.podo2b1s
.po4d3obs4z
.po4d3o4d3d
.podo2l1b
.po4d3olbr4z
.podó1
.po4d3ów
.po4d3u2c4z
.po4d3u2d4z
.po4d3u2pa1
.podura1
.po4d3u2ral
.po4d3u2sta1
.podus4z
.podu2s2z1c
.po4d3u2szc4z
.po4d5rę2cz1n
.podza1
.po4d5zakr
.po4d5zam
.po4d5zast
.po2dz1b
.po4d5zbi1
.po4d5ze1
.podzi1
.podzi2e1
.podzie1le1
.podzi1eleni1
.po4d5zieleni2ą1
.po4d5zielenic
.po4d5zielenić
.podzi2e1le1ni2e1
.po4d5zielenien
.po4d5zieleni2ę1
.po4d5zielenil
.po4d5zielenił
.po4d5zielenim
.po4d5zieleni2o1
.po4d5zielenis
.po4d5ziem
.po1dzi2o1
.po4d5ziom
.po4d5z2w2r
.po4l3s
.po4m3p
.po4ń3c
.po4r3c
.po4r3f
.po4r3n
.po4r3t
.po4s2t3d
.po4s2t3f
.po4s2t3g
.po4st3h
.po4st3i2
.po4s2t3k
.po4st3l
.po4s2t3m
.po4s2t3p
.po1stro1
.po4st3rom
.po4s2t3s
.poduszczy1
.po5d4uszczyn
.po5r4tę1
.pobr2
.pobr4z2
.poc4h2
.poc2h2r
.pochr4z2
.pod3a2l1p
.po2d3b2
.po2d3c2
.po2d3ć2
.po4d3d2
.po2d3f2
.po2d3g2
.pod3h2
.pod3i2n
.pod3j2
.po2d3k2
.pod3l2
.po2d3p2
.po2d3s2
.po2d3ś2
.podśró1
.pod3śró2d5
.po2d3t2
.pod5ż2
.podc4h2
.podc4z2
.podd4ź2
.podd4ż2
.pode3b2
.pode3c2
.pode3ć2
.pode3d2
.pode3f2
.pode3g2
.pode3h2
.pode3l2
.pode3ł2
.pode3m2
.pode3p2
.pode3r2
.pode3s2
.pode3ś2
.pode3t2
.pode3t1k2
.pode3w2
.pode3z2
.pode3ź2
.pode3ż2
.podec4h2
.podec4z2
.poded4z2
.poded4ź2
.poded4ż2
.pode2p1c
.podepc4h2
.poder4z2
.pode2r1ż2
.podesc4h2
.podes4z2
.podro2z3
.podsm2
.pods4z2
.pogr4z2
.pokl2
.pokr2
.po2ł1k2
.pom4p1k
.po2m1k2
.pona1
.pona2d2
.pona3b2
.pona3c2
.pona3c4z2
.pona3ć2
.po1na3do1
.pona3d4ź2
.pona3f2
.pona3g2
.pona3h2
.pona3k2
.pona3l2
.pona3ł2
.pona3m2
.pona3p2
.pona3r2
.pona3s2
.pona3ś2
.pona3t2
.pona3w2
.pona3z2
.pona3ź2
.pona3ż2
.pona4f3t
.ponabr4z2
.ponac4h2
.pona2d3c2
.ponad3c4h2
.ponad3c4z2
.pona2d3ć2
.pona4d3d
.ponad3d4ź2
.pona2d3f2
.pona2d3g2
.ponad3h2
.ponad3j2
.pona2d3k2
.ponad3l2
.pona2d3p2
.pona2d3s2
.pona2d3ś2
.pona2d3t2
.ponad4z2
.ponar4z2
.ponasm2
.ponas4z2
.ponaz3m2
.ponazw2
.poni1
.poni2e1
.ponie3k2
.ponie3w2
.po2p1c
.popc4h2
.po1po1
.popo3w2
.popr4z2
.por4t1w
.por4t1f
.por4t1m
.po1ro1
.poro2z3
.poro3z4u1
.por4z2
.posc4h2
.posm2
.pos4z2
.po2t1k2
.potr2
.poz4m2
.poza1
.poza3u2
.pozw2
.pó1
.pó2ł3
.pó3ł4ą1
.półe1
.pó3ł4ec4z
.pó3ł4ę1
.pó3ł4y1
.pó2ł1k2
.półkr2
.pó2ł1m2
.póło2
.półob3r
.póło2m2d
.pó2ł1p
.półpr4z
.półprzy1
.półprzy3m2k
.4p3p8
.pr8
.pra1
.pra3s2
.pra2w1n
.pra3w2nu1
.pra3w2z
.pra1pra1
.prapra2w1n
.prapra3w2nu1
.pre1
.predy1
.predy2s3po1
.pr4z8
.prze1
.prze2d2
.prze3b2
.prze3c2
.prze3ć2
.przed3ł2
.przedłu1
.prze3d4łuż
.prze2d3m2
.przedmu1
.prze3d4muc4h
.przed3o2
.prze3d4o3br
.prze3d4o3st
.prze3d4o3zo1
.przed3r2
.przedra1
.przedra1ma1
.prze3d4ramat
.przedru1
.prze3d4ruk
.przedry1
.prze3d4ryl
.pr4ze3d4r4z2
.przed3u2
.prze3d4um
.prze3dą1
.prze3dę1
.prze3dy1
.prze3d4z2
.prze3d4ź2
.prze1e2
.prze3e2k2s3
.prze3f2
.prze3g2
.prze3h2
.prze3k2
.prze3l2
.prze3ł2
.prze3m2
.prze3n2
.prze3p2
.prze3r2
.prze3s2
.prze3ś2
.prze3t2
.prze3u2
.prze3w2
.prze3z2
.prze3ź2
.prze3ż2
.przedłuży1
.prze4d5łużyc
.przedosta1
.prze4d5o4stat
.prze4d5za1
.prze4d5z1g2
.przedzi1
.prze4d5zim
.prze4d5zj
.prze4d5z1l
.prze4d5z2w2r
.przedzwo1
.prze4d5zwoj
.prze4d5ż2
.przebr2
.pr4zebr4z2
.przec4h2
.przec2h2r
.pr4zechr4z2
.przeci1
.przeci2w3
.przeci1wi1
.prze1ci3w4i2e1
.przeciwa2
.przeci4w3w2
.przec4z2
.przeda1
.przedago1
.przed3a2gon
.przed3a2k1c
.przed3a2l1p
.prze2d3b2
.prze2d3c2
.prze2d3ć2
.prze4d3d2
.prze1de1
.przed3e2g1z
.prze1de1me1
.przed3e2mer
.prze2d3f2
.prze2d3g2
.przed3h2
.przed3i2
.przed3j2
.prze2d3k2
.przed3l2
.prze2d3n2
.prze2d3p2
.prze2d3s2
.przedsi1
.przedsi2ę1
.przed3się3w2
.przed3s4z2
.prze2d3ś2
.prze2d3t2
.przed3w2
.przedc4h2
.przedc4z2
.przedd4z2
.przedd4ź2
.przedd4ż2
.pr4zedgr4z2
.przedy2s3ku1
.pr4zegr4z2
.przekl2
.przekr2
.prze2ł1k2
.prze2m1k2
.prze2p1c
.przepc4h2
.pr4zer4z2
.prze2r1ż2
.przesc4h2
.przesm2
.przes4z2
.prze2t1k2
.przetr2
.przetra1
.przetra2n2s3
.przy1
.przy3b2
.przy3c2
.przy3ć2
.przy3d2
.przy3f2
.przy3g2
.przy3h2
.przy3k2
.przy3l2
.przy3ł2
.przy3m2
.przy3p2
.przy3r2
.przy3s2
.przy3ś2
.przy3t2
.przy3w2
.przy3z2
.przy3ź2
.przy3ż2
.przybr2
.przyc4h2
.przyc4z2
.przyd4z2
.przyd4ź2
.przyd4ż2
.pr4zygr4z2
.przy2m1k2
.przyo2
.przyoz2
.przy2p1c
.przypc4h2
.pr4zyr4z2
.przy2r1ż2
.przysc4h2
.przys4z2
.przy2t1k2
.2p1s8
.2p1ś8
.2p1t8
.pv8
.pw8
.px8
.2p1z8
.2p1ź8
.2p1ż8
.r8
.2r1b8
.2r1c8
.2r1ć8
.2r1d8
.re1
.retra1
.retra2n2s3
.2r1f8
.2r1g8
.2r1h8
.2r1j8
.2r1k8
.2r1l8
.2r1ł8
.2r1m8
.2r1n8
.2r1ń8
.ro1
.ro2z3
.ro3z4a1
.ro3z4e1
.ro3z4e3b2
.ro3z4e3c2
.ro3z4e3ć2
.ro3z4e3d2
.ro3z4e3f2
.ro3z4e3g2
.ro3z4e3h2
.ro3z4e3k2
.ro3z4e3l2
.ro3z4e3ł2
.ro3z4e3m2
.ro3z4e3p2
.ro3z4e3r2
.ro3z4e3s2
.ro3z4e3ś2
.ro3z4e3t2
.ro3z4e3w2
.ro3z4e3z2
.ro3z4e3ź2
.ro3z4e3ż2
.ro3z4ej
.ro3z4u1
.ro4z5a2gi1
.rozani1
.ro4z5a2ni2e1
.ro4z5e2mo1
.ro4z5e4g3z
.ro4z5e4n3t
.rozbr4z2
.ro2z1d2
.rozec4h2
.rozec4z2
.rozed4z2
.rozed4ź2
.rozed4ż2
.roze2p1c
.rozepc4h2
.rozer4z2
.roze2r1ż2
.rozesc4h2
.rozes4z2
.rozi2
.rozm2
.ro1zo2
.ro2z1p
.ro1zpo1
.rozpo3w2
.ro2z1ś2
.ro2z1t2
.roztr2
.rozw2
.2r1p8
.4r3r8
.2r1s8
.2r1ś8
.2r1t8
.rv8
.2r1w8
.rx8
.r4z8
.2r1ź8
.2r1ż8
.s8
.sa1
.samo1
.samo3c4h2
.samo3k2
.samo3p2
.samo3w2
.samo1ro1
.samoro2z3
.2s1b8
.sc8
.sc4h8
.sć8
.2s1d8
.2s1f8
.2s1g8
.sh8
.si1
.si2e1
.sie1de1
.siede2m3
.siede2m1s
.sie1de1mse1
.siedemse2t3
.sie2d1m
.si1edmi1
.siedmi2o1
.siedmio3ś2
.sj8
.sk8
.ską1
.skąd4ż
.ską2d5że1
.skl8
.skr8
.sl8
.sł8
.sm8
.sn8
.sń8
.so1
.so1bo1
.sobo3w2
.sp8
.spo1
.spo2d2
.spo3b2
.spo3c2
.spo3ć2
.spo3d4z2
.spo3f2
.spo3g2
.spo3h2
.spo3k2
.spo3l2
.spo3ł2
.spo3m2
.spo3p2
.spo3r2
.spo3s2
.spo3ś2
.spo3t2
.spo3w2
.spo3z2
.spo3ź2
.spo3ż2
.spo4r3n
.spo4r3t
.spoc4h2
.spoc4z2
.spo4d3d
.spod4ź2
.spod4ż2
.spor4z2
.spos4z2
.spó1
.spó2ł3
.sr8
.2s1s8
.sś8
.st8
.ste1
.ste1re1
.stere2o3
.stereoa2
.ste1re1oe2
.stereoi2
.stereo1o2
.stereou2
.su1
.su2b3
.subi1
.su3b4i2e1
.subo1
.su3b4o2t1n
.supe1
.supe2r3
.supera1
.supe3r4at
.superi1
.supe3r4i2o1
.supe4r5a2tr
.super4z
.supe2r5z2b
.supe1re2
.supero1
.superodr4z
.su1perodrzu1
.supero2d1rzut
.sv8
.sw8
.sx8
.s4z8
.sze1
.sze2s3
.sze4ś2ć3
.sześ1c
.sze1ś2ci1
.sześci2o1
.sześcio3ś2
.sześ2ć1s
.sze1śćse1
.sześćse2t3
.2s1ź8
.2s1ż8
.ś8
.2ś1b8
.ś1c8
.ść8
.2ś1d8
.2ś1f8
.2ś1g8
.śh8
.śj8
.2ś1k8
.śl8
.śł8
.śm8
.śn8
.śń8
.2ś1p8
.śr8
.śró1
.śró2d5
.śródr2
.2ś1s8
.2ś1ś8
.2ś1t8
.śv8
.św8
.świ1
.świ2a1
.światło1
.światło3w2
.śx8
.2ś1z8
.2ś1ź8
.2ś1ż8
.t8
.ta1
.ta2o3
.tar4z
.ta1rza1
.ta2r7zan
.2t1b8
.2t1c8
.tc4h8
.2t1ć8
.2t1d8
.te1
.te2o3
.2t1f8
.2t1g8
.th8
.tj8
.2t1k8
.tl8
.tł8
.2t1m8
.2t1n8
.2t1ń8
.to1
.toa3
.2t1p8
.tr8
.tra1
.tra2n2s3
.tran3s4e1
.transi1
.tran3s4i2e1
.tran3s4y1
.tran3s4z
.tran4s5e2u1
.tra1nsa2
.transo2
.tró1
.tró2j3
.tró3j4ą1
.tróje1
.tró3j4ec4z
.tró3j4ę1
.tr4z8
.trze1
.trze2c4h3
.trze2c2h1s
.trze1chse1
.trzechse2t3
.2t1s8
.2t1ś8
.4t3t8
.tv8
.tw8
.tx8
.ty1
.tysi1
.tysi2ą1
.tysią2c3
.tysią3c4a1
.tysią3c4e1
.tysią3c4z
.tysią4c5zł
.2t1z8
.2t1ź8
.2t1ż8
.u1
.u3b2
.u3c2
.u3d2
.u3f2
.u3g2
.u3h2
.u3k2
.u3l2
.u3ł2
.u3m2
.u3n2
.u3p2
.u3r2
.u3s2
.u3t2
.u3w2
.u3z2
.u3ź2
.u3ż2
.u4d3k
.u4f3n
.ukle1
.u4k3lej
.u4l3s
.u4l3t
.u2m1b
.u4m3br
.u4n3c
.u4n3d
.u4p3p
.u4p3p2s
.u4r3s
.u4s2t3n
.u4s2t1c
.u4s2t1k
.u4z3be1
.ube1
.ube2z3
.ubezw2
.ubr2
.uc4h2
.uc4z2
.uć2
.ud4z2
.ud4ź2
.ud4ż2
.ukr2
.u2m1k2
.u2p1c
.upc4h2
.upo1
.upo2d2
.upo3b2
.upo3c2
.upo3ć2
.upo3da1
.upo3f2
.upo3g2
.upo3h2
.upo3k2
.upo3l2
.upo3ł2
.upo3m2
.upo3p2
.upo3r2
.upo3s2
.upo3ś2
.upo3t2
.upo3w2
.upo3z2
.upo3ź2
.upo3ż2
.upoc4h2
.upoc4z2
.upo4d3d
.upod4ź2
.upod4ż2
.upor4z2
.upos4z2
.uro1
.uro2z3
.ur4z2
.u2r1ż2
.usc4h2
.us4z2
.uś2
.u2t1k2
.utr2
.uze1
.uze3w2
.v8
.vb8
.vc8
.vć8
.vd8
.vf8
.vg8
.vh8
.vj8
.vk8
.vl8
.vł8
.vm8
.vn8
.vń8
.vp8
.vr8
.vs8
.vś8
.vt8
.vv8
.vw8
.vx8
.vz8
.vź8
.vż8
.w8
.2w1b8
.2w1c8
.2w1ć8
.2w1d8
.we1
.we3b2
.we3c2
.we3ć2
.we3d2
.we3f2
.we3g2
.we3h2
.we3k2
.we3l2
.we3ł2
.we3m2
.we3n2
.we3p2
.we3r2
.we3s2
.we3ś2
.we3t2
.we3w2
.we3z2
.we3ż2
.we4k3t
.we4l3w
.we4ł3n
.we4n3d
.we4n3t
.we4r3b
.we4r3d
.we4r3n
.we4r3s
.we4r3t
.we4s3pr4z
.wes2t1c
.we4s3tc4h2
.we4z3br
.we4z3gł
.wec4h2
.wec4z2
.wed4z2
.wed4ź2
.wed4ż2
.we2m1k2
.we2p1c
.wepc4h2
.wer4z2
.wes4z2
.we2t1k2
.we2w1n
.wewną1
.wewną2tr4z3
.2w1f8
.2w1g8
.wh8
.wi1
.wi2e1
.wielo1
.wielo3d2
.wielo3k2
.wielo3ś2
.wielu1
.wie1luse1
.wieluse2t3
.wi2l1c
.wilc4z
.wilczo1
.wilczo3m2
.2w1j8
.2w1k8
.2w1l8
.2w1ł8
.2w1m8
.2w1n8
.wni1
.wni2e1
.wniebo1
.wniebo3w2
.2w1ń8
.wo1
.wo1do1
.wodo3w2
.2w1p8
.2w1r8
.2w1s8
.wspó1
.wspó2ł3
.współi2
.współo1
.współo2b3w
.współu2
.wspó2ł1w2
.ws4z
.wsze1
.wsze2c4h3
.wszecho2
.wszec2h2w2
.2w1ś8
.2w1t8
.wv8
.4w3w8
.wx8
.wy1
.wy3b2
.wy3c2
.wy3ć2
.wy3d2
.wy3f2
.wy3g2
.wy3h2
.wy3k2
.wy3l2
.wy3ł2
.wy3m2
.wyo2
.wy3o2d3r
.wy3p2
.wy3r2
.wy3s2
.wy3ś2
.wy3t2
.wy3w2
.wy3z2
.wy3ź2
.wy3ż2
.wyc4z2
.wy4cz3ha1
.wy2ż1s
.wy4ż3s4z
.wybr2
.wybr4z2
.wyc4h2
.wydr2
.wyd4z2
.wyd4ź2
.wyd4ż2
.wye2
.wye2k2s3
.wygr4z2
.wyi2
.wyi2zo1
.wykl2
.wykr2
.wykr4z2
.wy2m1k2
.wy2p1c
.wypc4h2
.wypr4z2
.wyr4z2
.wy2r1ż2
.wysc4h2
.wysm2
.wys4z2
.wy2t1c
.wytc4h2
.wy2t1k2
.wytr2
.2w1z8
.2w1ź8
.2w1ż8
.x8
.xb8
.xc8
.xć8
.xd8
.xf8
.xg8
.xh8
.xj8
.xk8
.xl8
.xł8
.xm8
.xn8
.xń8
.xp8
.xr8
.xs8
.xś8
.xt8
.xv8
.xw8
.xx8
.xz8
.xź8
.xż8
.z8
.za1
.za3b2
.za3c2
.za3ć2
.za3d2
.za3f2
.za3g2
.za3h2
.za3k2
.za3l2
.za3ł2
.za3m2
.zao2
.za3o2b3r
.za3o2b3s
.za3p2
.za3r2
.za3s2
.za3ś2
.za3t2
.za3u2
.za3w2
.za3z2
.za3ź2
.za3ż2
.za4k3t
.za4l3g
.za4l3k
.za4l3t
.za4m3k
.za2r1c
.za4r3c4h
.za4uto1
.za5m4k2n
.zabr2
.zabr4z2
.zac4h2
.zac4z2
.zado1
.zado2ść3
.zadośću4
.zadr2
.zady1
.zady2s3po1
.zad4z2
.zad4ź2
.zad4ż2
.zagr4z2
.zai2
.zai2n3
.zai2zo1
.zai1ni1
.zain4ic
.zakl2
.zakr2
.zakr4z2
.zani1
.zani2e1
.zanie3d2
.zar4z2
.za2r1ż2
.zasc4h2
.zasm2
.zas4z2
.za2t1k2
.zatr2
.zb8
.2z1c8
.2z1ć8
.2z1d8
.zde1
.zde2z3
.zdeza1
.zde3z4awu1
.zde1ze1
.zde3z4el
.zde3z4er
.zde3z4y1
.zdy1
.zdysko1
.zdy2s3ko2n1t
.zdyskre1
.zdy2s3kred
.zdyskwa1
.zdy2s3kwal
.ze1
.ze3b2
.ze3c2
.ze3ć2
.ze3d2
.ze3f2
.ze3g2
.ze3h2
.ze3k2
.ze3l2
.ze3ł2
.ze3m2
.ze3p2
.ze3r2
.ze3s2
.ze3ś2
.ze3t2
.ze3t1k2
.ze3w2
.ze3z2
.ze3ź2
.ze3ż2
.ze4r3k
.ze1te1
.ze1te1me1
.ze4t3e2m1e2s
.ze1te1se1
.ze4t3e2s1e2l
.ze4t3e2m1p
.zetha1
.ze4t3hap
.zec4h2
.zec4z2
.zed4z2
.zed4ź2
.zed4ż2
.zekl2
.ze2p1c
.zepc4h2
.zer4z2
.ze2r1ż2
.zesc4h2
.zesm4
.zes4z2
.2z1f8
.zg8
.zh8
.zi1
.zi2m1n
.zimno1
.zimno3kr2
.zj8
.2z1k8
.zl8
.zł8
.zło1
.zło3w2
.zm8
.zma1
.zma2r1t
.zmartwy1
.zmartwy2c4h3
.zmartwyc2h2w2
.zn8
.zni1
.zni2e1
.znie3b2
.znie3c2
.znie3ć2
.znie3d2
.znie3f2
.znie3g2
.znie3h2
.znie3k2
.znie3l2
.znie3ł2
.znie3m2
.znie3n2
.znie3ń2
.znie3p2
.znie3r2
.znie3s2
.znie3ś2
.znie3t2
.znie3w2
.znie3z2
.znie3ź2
.znie3ż2
.znie4d4ź3
.znie4m3c
.zniec4h2
.zniec4z2
.znied4z2
.znied4ż2
.znier4z2
.znies4z2
.zń8
.zo1
.zo2o3
.2z1p8
.zr8
.zro1
.zro2z3
.zro3z4u1
.2z1s8
.2z1ś8
.2z1t8
.zv8
.zw8
.zx8
.4z3z8
.zź8
.zż8
.ź8
.2ź1b8
.2ź1c8
.2ź1ć8
.2ź1d8
.ź2d4ź8
.2ź1f8
.2ź1g8
.źh8
.źj8
.2ź1k8
.2ź1l8
.źł8
.2ź1m8
.2ź1n8
.źń8
.2ź1p8
.źr8
.2ź1s8
.2ź1ś8
.2ź1t8
.źv8
.2ź1w8
.źx8
.2ź1z8
.4ź3ź8
.2ź1ż8
.ż8
.2ż1b8
.2ż1c8
.2ż1ć8
.2ż1d8
.2ż1f8
.2ż1g8
.żh8
.2ż1j8
.2ż1k8
.2ż1l8
.2ż1ł8
.2ż1m8
.2ż1n8
.2ż1ń8
.2ż1p8
.2ż1r8
.2ż1s8
.2ż1ś8
.2ż1t8
.żv8
.2ż1w8
.żx8
.2ż1z8
.2ż1ź8
.4ż3ż8
ś1c
1ś2ci1
2b1c
2b1ć
2b1d
2b1f
2b1g
2b1k
2b1m
2b1n
2b1ń
2b1p
2b1s
2b1ś
2b1t
2b1z
2b1ź
2b1ż
2b2ł1k
2b2r1n
2c1b
2c1ć
2c1d
2c1f
2c1g
2c1k
2c1l
2c1m
2c1n
2c1ń
2c1p
2c1s
2c1ś
2c1t
2c1ź
2c1ż
c4h
2c2h1b
2c2h1c
2c2h1ć
2c2h1d
2c2h1f
2c2h1g
2c2h1k
2c2h1m
2c2h1n
2c2h1ń
2c2h1p
2c2h1s
2c2h1ś
2c2h1t
2c2h1z
2c2h1ź
2c2h1ż
c4z
2cz1b
2c2z1c
2c2z1ć
2c2z1d
2c2z1f
2cz1g
2c2z1k
2cz1l
2cz1m
2cz1n
2cz1ń
2c2z1p
2c2z1s
2c2z1ś
2c2z1t
2c4z3z
2cz1ź
2cz1ż
2ć1b
2ć1c
2ć1d
2ć1f
2ć1g
2ć1k
2ć1m
2ć1n
2ć1ń
2ć1p
2ć1s
2ć1ś
2ć1t
2ć1z
2ć1ź
2ć1ż
2d1b
2d1c
2d1ć
2d1f
2d1g
2d1k
2d1m
2d1n
2d1ń
2d1p
2d1s
2d1ś
2d1t
2d2ł1b
d2ł1s
2dłs4z
2d2r1n
d4z
2dz1b
2d2z1c
2d2z1ć
2d2z1d
2d2z1f
2dz1g
2d2z1k
2dz1l
2dz1m
2dz1n
2dz1ń
2d2z1p
2d2z1s
2d2z1ś
2d2z1t
2d4z3z
2dz1ź
2dz1ż
d4ź
2d2ź1b
2d2ź1c
2d2ź1ć
2d2ź1d
2d2ź1f
2d2ź1g
2d2ź1k
2d2ź1m
2d2ź1n
2dź1ń
2d2ź1p
2d2ź1s
2d2ź1ś
2d2ź1t
2d2ź1z
2d4ź3ź
2d2ź1ż
d4ż
2d2ż1b
2d2ż1c
2d2ż1ć
2d2ż1d
2d2ż1f
2d2ż1g
2d2ż1k
2d2ż1m
2d2ż1n
2d2ż1ń
2d2ż1p
2d2ż1s
2d2ż1ś
2d2ż1t
2d2ż1z
2d2ż1ź
2d4ż3ż
2f1c
2f1k
2f1m
2f1n
2g1b
2g1c
2g1ć
2g1d
2g1f
2g1k
2g1m
2g1ń
2g1p
2g1s
2g1ś
2g1t
2g1z
2g1ź
2g1ż
2g2ł1b
2h1b
2h1c
2h1ć
2h1d
2h1f
2h1g
2h1j
2h1k
2h1l
2h1ł
2h1m
2h1n
2h1ń
2h1p
2h1r
2h1s
2h1ś
2h1t
2h1w
2h1z
2h1ź
2h1ż
2j1b
2j1c
2j1ć
2j1d
2j1f
2j1g
2j1h
2j1k
2j1l
2j1ł
2j1m
2j1n
2j1ń
2j1p
2j1r
2j1s
2j1ś
2j1t
2j1w
2j1z
2j1ź
2j1ż
2k1b
2k1c
2k1ć
2k1d
2k1f
2k1g
2k1m
2k1n
2k1ń
2k1p
2k1s
2k1s4z
2k1ś
2k1t
2k1z
2k1ź
2k1ż
2k2ł1b
2l1b
2l1c
2l1ć
2l1d
2l1f
2l1g
2l1h
2l1j
2l1k
2l1ł
2l1m
2l1n
2l1ń
2l1p
2l1r
2l1s
2l1ś
2l1t
2l1w
2l1z
2l1ź
2l1ż
2ł1b
2ł1c
2ł1ć
2ł1d
2ł1f
2ł1g
2ł1h
2ł1j
2ł1k
2ł1l
2ł1m
2ł1n
2ł1ń
2ł1p
2ł1r
2ł1s
2ł1ś
2ł1t
2ł1w
2ł1z
2ł1ź
2ł1ż
2m1b
2m1c
2m1ć
2m1d
2m1f
2m1g
2m1h
2m1j
2m1k
2m1l
2m1ł
2m1n
2m1ń
2m1p
2m1r
2m1s
2m1ś
2m1t
2m1w
2m1z
2m1ź
2m1ż
2n1b
2n1c
2n1ć
2n1d
2n1f
2n1g
2n1h
2n1j
2n1k
2n1l
2n1ł
2n1m
2n1ń
2n1p
2n1r
2n1s
2n1ś
2n1t
2n1w
2n1z
2n1ź
2n1ż
2n2t1n
2ń1b
2ń1c
2ń1ć
2ń1d
2ń1f
2ń1g
2ń1h
2ń1j
2ń1k
2ń1l
2ń1ł
2ń1m
2ń1n
2ń1ń
2ń1p
2ń1r
2ń1s
2ń1ś
2ń1t
2ń1w
2ń1z
2ń1ź
2ń1ż
2p1b
2p1c
2p1ć
2p1d
2p1f
2p1g
2p1k
2p1m
2p1n
2p1ń
2p1s
2p1s4z
2p1ś
2p1t
2p1z
2p1ź
2p1ż
2p2l1n
2r1b
2r1c
2r1ć
2r1d
2r1f
2r1g
2r1h
2r1j
2r1k
2r1l
2r1ł
2r1m
2r1n
2r1ń
2r1p
2r1s
2r1ś
2r1t
2r1w
2r1ź
2r1ż
r4z
2rz1b
2r2z1c
2r2z1ć
2r2z1d
2r2z1f
2rz1g
2rz1h
2rz1j
2r2z1k
2rz1l
2rz1ł
2rz1m
2rz1n
2rz1ń
2r2z1p
2rz1r
2r2z1s
2r2z1ś
2r2z1t
2rz1w
2rz1ź
2rz1ż
2s1b
2s1d
2s1f
2s1g
2s1s
2s1ź
2s1ż
2s2ł1b
2s2n1k
2s2t1k
2s2t1n
s2t1s
2sts4z
s4z
2s2z1c
2s2z1ć
2s2z1f
2s2z1k
2sz1l
2sz1m
2sz1n
2s2z1p
2s2z1s
2s2z1ś
2s2z1t
2sz1w
2s4z3z
2sz2l1n
2ś1b
2ś1d
2ś1f
2ś1g
2ś1k
2ś1p
2ś1s
2ś1ś
2ś1t
2ś1z
2ś1ź
2ś1ż
2ś2ć1c
2ś2l1m
2ś2l1n
2t1b
2t1c
2t1ć
2t1d
2t1f
2t1g
2t1k
2t1m
2t1n
2t1ń
2t1p
2t1s
2t1ś
2t1z
2t1ź
2t1ż
2t2l1n
2t2r1k
tr4z
2t2rz1n
2w1b
2w1c
2w1ć
2w1d
2w1f
2w1g
2w1j
2w1k
2w1l
2w1ł
2w1m
2w1n
2w1ń
2w1p
2w1r
2w1s
2w1ś
2w1t
2w1z
2w1ź
2w1ż
2z1c
2z1ć
2z1d
2z1f
2z1k
2z1p
2z1s
2z1ś
2z1t
2z2d1k
2z2d1n
2ź1b
2ź1c
2ź1ć
2ź1d
2ź1f
2ź1g
2ź1k
2ź1l
2ź1m
2ź1n
2ź1p
2ź1s
2ź1ś
2ź1t
2ź1w
2ź1z
2ź1ż
2ż1b
2ż1c
2ż1ć
2ż1d
2ż1f
2ż1g
2ż1j
2ż1k
2ż1l
2ż1ł
2ż1m
2ż1n
2ż1ń
2ż1p
2ż1r
2ż1s
2ż1ś
2ż1t
2ż1w
2ż1z
2ż1ź
dni1
dni2o1
3d2niow
3k2s2z2t
3m2k2n
mne1
3m2nest
3m2nezj
3m2s2k2n
pne1
3p2ne2u1
wc4z
wcza1
3w2czas
wła1
3w2ład
wło1
3w2łos
4b3b
4c3c
4ć3ć
4d3d
4f3f
4g3g
4h3h
4j3j
4k3k
4l3l
4ł3ł
4m3m
4n3n
4p3p
4r3r
4t3t
4w3w
4z3z
4ź3ź
4ż3ż
8b.
8b8b.
8b8c.
8b8ć.
8b8d.
8b8f.
8b8g.
8b8h.
8b8j.
8b8k.
8b8l.
8b8ł.
8b8m.
8b8n.
8b8ń.
8b8p.
8b8r.
br4z
8b8r8z.
8b8s.
8b8ś.
8b8t.
8b8v.
8b8w.
8b8x.
8b8z.
8b8ź.
8b8ż.
8c.
8c8b.
8c8c.
8c8ć.
8c8d.
8c8f.
8c8g.
8c8h.
c2h2ł
8c8h8ł.
c2h2r
chr4z
8ch8r8z.
c2h2w
8c8h8w.
8c8j.
8c8k.
8c8l.
8c8ł.
8c8m.
8c8n.
8c8ń.
8c8p.
8c8r.
8c8s.
8c8ś.
8c8t.
8c8v.
8c8w.
8c8x.
8c8z.
8c8z8t.
8c8ź.
8c8ż.
8ć.
8ć8b.
8ć8c.
8ć8ć.
8ć8d.
8ć8f.
8ć8g.
8ć8h.
8ć8j.
8ć8k.
8ć8l.
8ć8ł.
8ć8m.
8ć8n.
8ć8ń.
8ć8p.
8ć8r.
8ć8s.
8ć8ś.
8ć8t.
8ć8v.
8ć8w.
8ć8x.
8ć8z.
8ć8ź.
8ć8ż.
8d.
8d8b.
8d8c.
8d8ć.
8d8d.
8d8f.
8d8g.
8d8h.
8d8j.
8d8k.
8d8l.
8d8ł.
8d8m.
8d8n.
8d8ń.
8d8p.
8d8r.
dr4z
8d8r8z.
8d8s.
8d8ś.
8d8t.
8d8v.
8d8w.
8d8x.
8d8z.
8d8ź.
8d8ż.
8f.
8f8b.
8f8c.
8f8ć.
8f8d.
8f8f.
8f8g.
8f8h.
8f8j.
8f8k.
8f8l.
8f8ł.
8f8m.
8f8n.
8f8ń.
8f8p.
8f8r.
8f8s.
8f8ś.
8f8t.
8f8v.
8f8w.
8f8x.
8f8z.
8f8ź.
8f8ż.
8g.
8g8b.
8g8c.
8g8ć.
8g8d.
8g8f.
8g8g.
8g8h.
8g8j.
8g8k.
8g8l.
8g8ł.
8g8m.
8g8n.
8g8ń.
8g8p.
8g8r.
8g8s.
8g8ś.
8g8t.
8g8v.
8g8w.
8g8x.
8g8z.
8g8ź.
8g8ż.
8h.
8h8b.
8h8c.
8h8ć.
8h8d.
8h8f.
8h8g.
8h8h.
8h8j.
8h8k.
8h8l.
8h8ł.
8h8m.
8h8n.
8h8ń.
8h8p.
8h8r.
8h8s.
8h8ś.
8h8t.
8h8v.
8h8w.
8h8x.
8h8z.
8h8ź.
8h8ż.
8j.
8j8b.
8j8c.
8j8ć.
8j8d.
8j8f.
8j8g.
8j8h.
8j8j.
8j8k.
8j8l.
8j8ł.
8j8m.
8j8n.
8j8ń.
8j8p.
8j8r.
8j8s.
8j8ś.
8j8t.
8j8v.
8j8w.
8j8x.
8j8z.
8j8ź.
8j8ż.
8k.
8k8b.
8k8c.
8k8ć.
8k8d.
8k8f.
8k8g.
8k8h.
8k8j.
8k8k.
8k8l.
8k8ł.
8k8m.
8k8n.
8k8ń.
8k8p.
8k8r.
8k8s.
8k8s8t.
8k8ś.
8k8t.
8k8v.
8k8w.
8k8x.
8k8z.
8k8ź.
8k8ż.
8l.
8l8b.
8l8c.
8l8ć.
8l8d.
8l8f.
8l8g.
8l8h.
8l8j.
8l8k.
8l8l.
8l8ł.
8l8m.
8l8n.
8l8ń.
8l8p.
8l8r.
8l8s.
8l8ś.
8l8t.
8l8v.
8l8w.
8l8x.
8l8z.
8l8ź.
8l8ż.
8ł.
8ł8b.
8ł8c.
8ł8ć.
8ł8d.
8ł8f.
8ł8g.
8ł8h.
8ł8j.
8ł8k.
8ł8l.
8ł8ł.
8ł8m.
8ł8n.
8ł8ń.
8ł8p.
8ł8r.
8ł8s.
8ł8ś.
8ł8t.
8ł8v.
8ł8w.
8ł8x.
8ł8z.
8ł8ź.
8ł8ż.
8m.
8m8b.
8m8c.
8m8ć.
8m8d.
8m8f.
8m8g.
8m8h.
8m8j.
8m8k.
8m8l.
8m8ł.
8m8m.
8m8n.
8m8ń.
8m8p.
8m8r.
8m8s.
8m8s8t.
8m8ś.
8m8t.
8m8v.
8m8w.
8m8x.
8m8z.
8m8ź.
8m8ż.
8n.
8n8b.
8n8c.
8n8ć.
8n8d.
8n8f.
8n8g.
8n8h.
8n8j.
8n8k.
8n8l.
8n8ł.
8n8m.
8n8n.
8n8ń.
8n8p.
8n8r.
8n8s.
8n8ś.
8n8t.
8n8v.
8n8w.
8n8x.
8n8z.
8n8ź.
8n8ż.
8ń.
8ń8b.
8ń8c.
8ń8ć.
8ń8d.
8ń8f.
8ń8g.
8ń8h.
8ń8j.
8ń8k.
8ń8l.
8ń8ł.
8ń8m.
8ń8n.
8ń8ń.
8ń8p.
8ń8r.
8ń8s.
8ń8ś.
8ń8t.
8ń8v.
8ń8w.
8ń8x.
8ń8z.
8ń8ź.
8ń8ż.
8p.
8p8b.
8p8c.
8p8ć.
8p8d.
8p8f.
8p8g.
8p8h.
8p8j.
8p8k.
8p8l.
8p8ł.
8p8m.
8p8n.
8p8ń.
8p8p.
8p8r.
pr4z
8p8r8z.
8p8s.
8p8ś.
8p8t.
8p8v.
8p8w.
8p8x.
8p8z.
8p8ź.
8p8ż.
8r.
8r8b.
8r8c.
8r8ć.
8r8d.
8r8f.
8r8g.
8r8h.
8r8j.
8r8k.
8r8l.
8r8ł.
8r8m.
8r8n.
8r8ń.
8r8p.
8r8r.
8r8s.
rs4z
8r8s8z.
8r8ś.
8r8t.
8r8v.
8r8w.
8r8x.
8r8z.
8r8z8ł.
8r8ź.
8r8ż.
8s.
8s8b.
8s8c.
sc4h
8s8c8h.
8s8ć.
8s8d.
8s8f.
8s8g.
8s8h.
8s8j.
8s8k.
skr4z
8sk8r8z.
8s8l.
8s8ł.
8s8m.
8s8n.
8s8ń.
8s8p.
8s8r.
8s8s.
8s8ś.
8s8t.
8s8t8r.
str4z
8s8t8r8z.
8s8t8w.
8s8v.
8s8w.
8s8x.
8s8z.
szc4z
8sz8c8z.
sz2cz1b
8szc8z8b.
8s8z8k.
8s8z8n.
8s8z8t.
8sz8t8r.
8s8ź.
8s8ż.
8ś.
8ś8b.
8ś8c.
8ś8ć.
8ś8d.
8ś8f.
8ś8g.
8ś8h.
8ś8j.
8ś8k.
8ś8l.
8ś8ł.
8ś8m.
8ś8n.
8ś8ń.
8ś8p.
8ś8r.
8ś8s.
8ś8ś.
8ś8t.
8ś8v.
8ś8w.
8ś8x.
8ś8z.
8ś8ź.
8ś8ż.
8t.
8t8b.
8t8c.
8t8ć.
8t8d.
8t8f.
8t8g.
8t8h.
8t8j.
8t8k.
8t8l.
8t8ł.
8t8m.
8t8n.
8t8ń.
8t8p.
8t8r.
8t8r8z.
8t8s.
8t8ś.
8t8t.
8t8v.
8t8w.
8t8x.
8t8z.
8t8ź.
8t8ż.
8v.
8v8b.
8v8c.
8v8ć.
8v8d.
8v8f.
8v8g.
8v8h.
8v8j.
8v8k.
8v8l.
8v8ł.
8v8m.
8v8n.
8v8ń.
8v8p.
8v8r.
8v8s.
8v8ś.
8v8t.
8v8v.
8v8w.
8v8x.
8v8z.
8v8ź.
8v8ż.
8w.
8w8b.
8w8c.
8w8ć.
8w8d.
8w8f.
8w8g.
8w8h.
8w8j.
8w8k.
8w8l.
8w8ł.
8w8m.
8w8n.
8w8ń.
8w8p.
8w8r.
8w8s.
8w8ś.
8w8t.
8w8v.
8w8w.
8w8x.
8w8z.
8w8ź.
8w8ż.
8x.
8x8b.
8x8c.
8x8ć.
8x8d.
8x8f.
8x8g.
8x8h.
8x8j.
8x8k.
8x8l.
8x8ł.
8x8m.
8x8n.
8x8ń.
8x8p.
8x8r.
8x8s.
8x8ś.
8x8t.
8x8v.
8x8w.
8x8x.
8x8z.
8x8ź.
8x8ż.
8z.
8z8b.
8z8c.
8z8ć.
8z8d.
8z8d8r.
zdr4z
8z8d8r8z.
8z8f.
8z8g.
8z8h.
8z8j.
8z8k.
8z8l.
8z8ł.
8z8m.
8z8n.
8z8ń.
8z8p.
8z8r.
8z8s.
8z8ś.
8z8t.
8z8v.
8z8w.
8z8x.
8z8z.
8z8ź.
8z8ż.
8ź.
8ź8b.
8ź8c.
8ź8ć.
8ź8d.
8ź8f.
8ź8g.
8ź8h.
8ź8j.
8ź8k.
8ź8l.
8ź8ł.
8ź8m.
8ź8n.
8ź8ń.
8ź8p.
8ź8r.
8ź8s.
8ź8ś.
8ź8t.
8ź8v.
8ź8w.
8ź8x.
8ź8z.
8ź8ź.
8ź8ż.
8ż.
8ż8b.
8ż8c.
8ż8ć.
8ż8d.
8ż8f.
8ż8g.
8ż8h.
8ż8j.
8ż8k.
8ż8l.
8ż8ł.
8ż8m.
8ż8n.
8ż8ń.
8ż8p.
8ż8r.
8ż8s.
8ż8ś.
8ż8t.
8ż8v.
8ż8w.
8ż8x.
8ż8z.
8ż8ź.
8ż8ż.
a1
a2u1
a2y1
a1a2
ae2
ai2
ao2
ą1
be1
be1e2
be2eth
be2f3s4z2
be1khe1
be2k1he2n1d
bi1
bino1
bi2n3o2ku1
bis4z
bi2s2z1k
biszko1
bi2sz3kop
bizne1
bi2z3nes
bi2z3ne2s3m
bi2r1m
bi1rmi1
birmi2n1g
birmingha1
birmin2g1ham
blo1
blokha1
blokha2u1
blo2k1hauz
bo1
bo2s3ma1
b2r2d
bro1
broa2
broa1dwa1
bro2a2d3wa2y1
bu1
bus4z
bu2sz1m
bu2sz3me1
bu2k1s
bu2k1s4z
buk2s2z1p
bukszpa1
buk2sz3pan
busi1
busine1
busine2s2s
busine2ss3m
ca1
ca2l1d
caldwe1
cal2d1we4l3l
c2h2j
c2h2l
chu1
chus1t
cu1
cur4z
curzo1
cu2r7zon
de1
de2u1
deu2t1s
deutsc4h
deutsc2h2l
deutschla1
deut4sch3la2n1d
d2rz2w
du1
dus4z
du2s2z1p
duszpa1
du2sz3past
d2ż2j
d2ż2l
d2ż2ł
d2ż2r
d2ż2w
dże1
dże4z3b
dże4z3m
e1
er4z
erza1
e2r5zac
e2u1
e2y1
e3u2s4z
ea2
e1e2
ei2
eo2
ę1
fi1
fisha1
fi2s3ha2r1m
fis4z
fi1szbi1
fi2sz3bin
fo1
fo2k1s
fo2k2s3t
for4z
forza1
fo2r5zac
fo2l1k
fo1lklo1
fol2k1lor
fo2s1f
fosfa1
fo1sfazo1
fos2f1a2zot
ga1
ga2d1g
gadge1
ga3d2get
gado1
gado2p1t
ga1do3p2ta1
go1
go2l1f
gol2f3s
golfs4z2
gra1
gra2n1d
grandi1
gran2d1ilo1
gro1
gro4t3r
hi1
his4z
hi2s2z3p
hu1
huc4z
hu2cz1w
huxle1
hu2x3le2y1
i1
i2a1
i2ą1
i2e1
i2ę1
i2i1
i2o1
i2ó1
i2u1
i2y1
i4n3n
in2n1s
inn2s1b
innsbru1
in4nsbru2c1k
i2n1s
in2s1b
insbru1
in4sbruc
j2t1ł
j2t1r
ja1
ja4z3z
ja4z4z3b
ja4z4z3m
ka1
ka2r1l
kar2l1s
karlskro1
karl2s1kron
karlsru1
karl2s1ruhe1
ki1
ki2r1c
kirc4h
kirc4h3h
kirchho1
kir2chho4f3f
ko1
ko2n1g
kongre1
kongre2s3m
le1
led1w
lu1
luftwa1
luftwa4f3f
lu2ft3waffe1
lu2k1s
luk2s1f
luksfe1
lu2ks1fer
ly1
ly2o2
ma1
mar4z
ma2r5z1l
ma2r5z1ł
ma2r5z1n
mi1
mis4z
mi2sz1m
miszma1
mi2s4z1mas4z
mi2e1
mier4z
mi1e2r5zi1
mie2r5z1ł
mo1
mo2n1t
montre1
montrea2
mon2t3real
moza1
mozai2
moza2i3k
mu1
mur4z
murza1
murzasi1
murzasic4h
mu2r7zasic2h3l
na1
na2ł1k
nałko1
na4ł3ko2w1s
na4r3v
o1
o2y1
oa2
oc4h
o2c2h1m
ochmi1
och3mistr4z
oe2
o4f3f
offse1
of2f3set
oi2
o1o2
ou2
ó1
ó2w1c
ó4w3c4z
pa1
pa1na1
paname1
pa2n3a2mer
pa1sca1
pa2s3cal
pa2s3c4h
po1
po2d1n
podni1
podni2e1
po3d4niepr4z
po2m1n
po3m2ną1
po3m2nę1
po3m2ni1
po2r1t
por2t1s
po1rtsmo1
portsmou2
po4rt2s3mo2uth
portla1
po4rt3la2n1d
poli1
poli2e1
poli3e2t
poli2u1
poli3u2re1
połu1
połu2d1n
połu3d2ni1
po2w1s
pows4z
powsze1
powsze2d1n
powsze3d2ni1
p2r1c
prc4h
prcha1
pr2chal
pre1
pres4z
pre2s2z1p
pre2sz3pa1
ro1
roe2
roe2n1t
roen2t1g
roe1ntge1
ro2e3nt2gen
ro1kro1
ro2k3roc4z
ro1sto1
ro2s3to3c2k
se1
se2t3le1
sko1
skor4z
sko1rzo1
skorzone1
sko2r5zoner
s2m2r
so1
sowi1
sowi3z2
sy1
syno1
sy2n3o2p1t
syste1
sy2s1tem
sza1
s4zas4z
sza2sz1ły1
sze1
szezlo1
sze2z1lo2n1g
sze4ść
szto1
szto1kho1
szto2k1ho2l1m
szy1
szy2n1k
szynkwa1
szyn2k1was
to1
to2y1
to1yo2
to3y2o3t
tu1
tu2r1b
turbo1
turbo1o2
turboodr4z
tu1rboodrzu1
turboo2d3rzut
ty1
tygo1
tygo2d1n
tygo3d2ni1
u1
u2y1
ua2
ue2
ui2
uo2
u1u2
vo1
vo2l1k
vo2l2k2s3
we1
we1e2
we1e1ke1
we2e2k1e2n1d
we4s2t3f
we4s2t3m
y1
ya2
ye2
yi2
yo2
yu2
ze1
ze4p3p
ź2d4ź
.by1
.byna1
.byna2j1m
.bynaj2m1n
.bynajmni1
.bynajmni2e1
.by9naj9m8nie8j.
.bezac4h
.be9z8a8c8h.
.bezami1
.be9z8ami.
.gd4z
.gdzi1
.gdzi2e1
.gdzi1eni1
.gdzi2e1ni2e1
.2g1dzienie2g1d
.gd4zieniegd4z
.gdzi1eni1egdzi1
.gdzi2e1ni2e1gdzi2e1
.gdzienie9g8dzie.
.ina1
.inac4z
.inacze1
.in8a9cze8j.
.n8a9da8l.
.ni2g1d
.nigdy1
.n8i9gdy.
.nigd4z
.ni1gdzi1
.nigdzi2e1
.n8i9gdzie.
.nie2c2h1ż
.nie1chże1
.nie8ch9że.
.nie2c2h1b
.niechby1
.nie8ch9by.
.o2w1s
.ows4z
.owsze1
.ow9sze8m.
.póła1
.półac4h
.pó9ł8a8c8h.
.półami1
.pó9ł8ami.
.pó9ł8e8k.
.przyna1
.przyna2j1m
.przynaj2m1n
.przynajmni1
.przynajmni2e1
.przy9naj9m8nie8j.
.skądi1
.ską1diną1
.skąd9i8ną8d.
.trója1
.trójac4h
.tró9j8a8c8h.
.trójami1
.tró9j8ami.
.tró9j8e8k.
.podó2w1c
.podó4w3c4z
.podówcza1
.podó3w2czas
.po8d9ó8w9cza8s.

