# WARNING: This file is autogenerated from following files:
#
#            lib/HTTP/WebTest.pm.in
#            lib/HTTP/WebTest/Plugin/Apache.pm
#            lib/HTTP/WebTest/Plugin/ContentSizeTest.pm
#            lib/HTTP/WebTest/Plugin/Cookies.pm
#            lib/HTTP/WebTest/Plugin/DefaultReport.pm
#            lib/HTTP/WebTest/Plugin/Loader.pm
#            lib/HTTP/WebTest/Plugin/ResponseTimeTest.pm
#            lib/HTTP/WebTest/Plugin/SetRequest.pm
#            lib/HTTP/WebTest/Plugin/StatusTest.pm
#            lib/HTTP/WebTest/Plugin/TextMatchTest.pm
#            lib/HTTP/WebTest/ReportPlugin.pm
#
# Do not modify this file but edit those files. All changes in this
# file will be lost.


# This is a -*-perl-*- source file


package HTTP::WebTest;

$VERSION = '1.99_02';

# actual content of HTTP::WebTest package is in HTTP::WebTest::API
require HTTP::WebTest::API;

=head1 NAME

HTTP::WebTest - Test remote URLs or local web files

=head1 SYNOPSIS

All HTTP::WebTest API cannot be summarized here. Only basic usage.

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;

    $webtest->run_wtscript('script.wt');
    $webtest->run_tests($tests);

See below for all API.

=head1 DESCRIPTION

=head2 Introduction

This module runs tests on remote URLs or local web files containing
Perl/JSP/HTML/JavaScript/etc. and generates a detailed test
report. This module has plugin based architecture. Plugins can define
test types and provide various report capabilities. This module comes
with a set of default plugins but can be easily extended with third
party plugins.

The test specifications can be read from a parameter file (wtscript)
or input as method arguments. If you are testing a local file, Apache
is started on a private/dynamic port with a configuration file in a
temporary directory. The module can display the test results via
report plugin(s). Default report plugin can output them on the
terminal, directs them to a file or scalar variable and/or email them.

Data flow for C<HTTP::WebTest> using a remote URL:

          --------------              -------------
          |            |              |           |
          | Input      |------------->|  WebTest  |
          | parameters |              |           |
          |            |              -------------
          --------------                  |   ^
                                          |   |
                                          V   |
          -------------               ------------
          |           |    request    |          |
          | Remote    |<--------------|   HTTP   |
          | webserver |-------------->|   user   |
          |           |    response   |   agent  |
          -------------               |          |
                                      ------------

Data flow diagram for C<HTTP::WebTest> using a local web file:

          --------------           ---------------------
          |            |           |                   |
          | Input      |           |  Web page code    |
          | parameters |           |  (Perl/HTML/etc.) |
          |            |           |                   |
          --------------           ---------------------
                |                            |
                |  ---------------------------
                |  |
                V  V              ------------------------
          -------------           |                      |
          |           |---------->| Temporary Apache     |
          |  WebTest  |           | directories (htdocs, |
          |           |<----------| conf, logs)          |
          -------------           |                      |
              |  ^                ------------------------
              |  |                        |    ^
              V  |                        V    |
          ------------             ----------------------
          |          |   request   |                    |
          |   HTTP   |------------>| Temporary local    |
          |   user   |             | instance of Apache |
          |   agent  |<------------|                    |
          |          |   response  ----------------------
          ------------

=head2 Getting Started

This document is good starting point. It describes:

=over 4

=item *

How tests can be specificated. See section L<TEST SPECIFICATION|TEST
SPECIFICATION>.

=item *

All test parameters supported by core C<HTTP::WebTest>
plugins. See section L<TEST PARAMETERS|TEST PARAMETERS>.

=back

Other useful documentation is:

=over 4

=item *

L<perldoc HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook> - examples
of wtscript files and examples of C<HTTP::WebTest> API usage.

=item *

L<perldoc HTTP::WebTest::API|HTTP::WebTest::API> - full documentaion
on HTTP::WebTest::API.

=item *

L<perldoc HTTP::WebTest::Plugins|HTTP::WebTest::Plugins> - for
developers of C<HTTP::WebTest> plugins.

=back

=head1 TEST SPECIFICATION

The test specifications can be read from a parameter file (wtscript)
or input in form of array of hashes.

=head2 Wtscript

C<HTTP::WebTest> can read test specification from file
in format called as C<wtscript>. Tests defined by wtscript file can be
run either using Perl API of C<HTTP::WebTest>

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_wtscript('script.wt');

or by using program L<wt|wt> supplied with this module.

=head3 File format

The following is ignored in wtscript file:

=over 4

=item *

lines consisting of nothing but white space (blanks or tabs)

=item *

lines beginning with a number sign (C<#>)

=item *

lines beginning with white space (blanks or tabs) followed by a number
sign

=back

The order of the parameters in the parameter file is arbitrary,
with the following exceptions:

=over 4

=item *

Test block parameters MUST occur between a test_name parameter
and an end_test directive.

=item *

Global parameters must NOT occur between a test_name parameter
and an end_test directive. (This requirement does not apply to
parameters that are both global and test block parameters.)

=back

Parameters are either scalar (single-valued) or lists (single or
multi-valued).

You can specify scalar parameters using forms such as:

    name = value
    name =
           value
    name = 'value'

You can specify list parameters using forms such as:

    name = ( first value
             second value )
    name = ( first value => second value
             third value => fourth value
           )
    name = ( first value => second value )
    name = (
             'first value'
             'second value' )
    name = (
             first value
             second value
             third value => 'fourth value'
           )
    name =
           ( first value
             'second value' )
    name = (
             'first value'
             'second value'
           )

(The equals sign must be followed by a space, tab or newline; all
other spaces are optional.)

PARAMETER VALUES BEGINNING AND ENDING WITH A SINGLE QUOTE WILL HAVE
THE SINGLE QUOTES REMOVED. For example, 'foobar' is parsed as a value
of foobar and ''foobar'' is parsed as a value of 'foobar'. To specify
a null (placeholder) value, use ''.

You MUST enclose the parameter value in single quotes if you want
to specify:

=over 4

=item *

a value beginning with a left parenthesis

=item *

a value ending with a right parenthesis

=item *

a value beginning with leading white space (blanks or tabs)

=item *

a value ending with trailing white space (blanks or tabs)

=item *

a value beginning and ending with single quotes

=back

=head3 Examples of wtscript files

The parameters below specify tests of a local file and a remote URL.
The tests specified by the C<text_forbid> parameter apply to both the
"RayCosoft home page" and the "Yahoo home page" tests. Hence, if
either returned page contains one of the case-insensitive strings in
text_forbid, the test fails. If any test fails or the fetch of the URL
fails, an e-mail will be sent to tester@unixscripts.com.


    apache_exec = /usr/sbin/apache
    ignore_case = yes
    mail = errors
    mail_addresses = ( tester@unixscripts.com )
    mail_server = mailhost.unixscripts.com
    text_forbid = ( Premature end of script headers
                    an error occurred while processing this directive
                  )

    test_name = 'RayCosoft home page (static)'
        file_path = ( raycosoft_home.html => . )
        text_require = (
            <a href="/dept/peopledev/new_employee/"><font color="#0033cc">
            <a href="https://www.raycosoft.com/"><font color=
                       )
    end_test

    test_name = Yahoo home page
        url = www.yahoo.com
        text_require = ( <a href=r/qt>Quotations</a>...<br> )
        min_bytes = 13000
        max_bytes = 99000
        min_rtime = 0.010
        max_rtime = 30.0
    end_test

The parameters below specify a test of a local file containing Perl
code using the L<Apache::ASP|Apache::ASP> module. The C<includes.htm>
file requires five include files and two Perl modules, which are
copied using the C<include_file_path> parameter.

    apache_exec = /usr/sbin/apache
    ignore_case = yes
    include_file_path = ( footer.inc => htdocs/apps/myapp/inc
                          header.inc => htdocs/apps/myapp/inc
                          head.inc   => htdocs/apps/myapp/inc
                          go.script  => htdocs/shared/includes
                          go.include => htdocs/shared/includes
                          ../utils/DBconn.pm  => lib/perl/utils
                          ../utils/Window.pm  => lib/perl/utils
                        )

    test_name = includes.htm
        file_path = ( includes.htm => apps/myapp )
        min_bytes = 33000
        max_bytes = 35000
        text_require = ( input type=hidden name=control value= )
        text_forbid  = ( Premature end of script headers
                         an error occurred while processing this directive
                       )
    end_test

=head2 Array of Hashes

If you are using Perl API of C<HTTP::WebTest> then test sequence can
be defined in form of array of hashes.

Each hash in array defines tests for one URL. Keys in hashes are test
parameter names and values in hashes are values of test
parameters. Also there can be defined global test parameters in form
of hash for each test sequence.

Tests can be run as

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_tests(
                        [ # test 1
                          { param1 => value1,
                            param2 => value2 },
                          # test 2
                          { param1 => value1,
                            param2 => value2 },
                        ],
                        { global_param1 => value1,
                          global_param2 => value2 }
                       );

=head3 Example

This Perl script tests Yahoo home page and sends full test report to
C<tester@unixscripts.com>.

    use HTTP::WebTest;

    my $tests = [
                 { name         => 'Yahoo home page',
                   url          => 'http://www.yahoo.com',
                   text_require => [ '<a href=r/qt>Quotations</a>...<br>' ],
                   min_bytes    => 13000,
                   max_bytes    => 99000,
                 }
                ];
    my $options = { mail_server    => 'mailhost.unixscripts.com',
                    mail_addresses => [ 'tester@unixscripts.com' ],
                    mail           => 'all',
                    ignore_case    => 'yes',
                  };

    $webtest->run_tests($tests, $options);

=head1 TEST PARAMETERS

=head2 accept_cookies

Option to accept cookies from the web server.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 apache_dir

Absolute or relative path name of directory containing
Apache files. See the
L<APACHE DIRECTORY AND FILES|/"APACHE DIRECTORY AND FILES"> section.
This parameter is ignored unless the C<file_path> parameter is specified.

=head3 Default Value

C</usr/local/etc/http-webtest>

=head2 apache_exec

Absolute or relative path name of Apache executable. This command can
be in your C<$PATH>. This parameter is ignored unless the C<file_path>
parameter is specified.

=head3 Default Value

C</usr/sbin/apache>

=head2 apache_loglevel

Apache logging level. If you use a level less than C<warn> (i.e.,
C<debug>, C<info>, or C<notice>), the program may generate irrelevant
errors. This parameter is ignored unless the C<file_path> parameter is
specified. See also the C<ignore_error_log> parameter.

=head3 Allowed Values

C<debug>, C<info>, C<notice>, C<warn>, C<error>, C<crit>, C<alert>,
C<emerg>

=head3 Default Value

C<warn>

=head2 apache_max_wait

Maximum number of seconds to wait for Apache to start. This parameter
is ignored unless the C<file_path> parameter is specified.

=head3 Default Value

C<60>

=head2 apache_options

Additional Apache command line options. Many of the options cause
Apache to exit immediately after starting, so the web page tests will
not run. This parameter is ignored unless the C<file_path> parameter is
specified.

=head2 auth

A list of userid/password pairs to be used for web page access
authorization.

=head2 cookie

Synonym to C<cookies>.

=head2 cookies

Specifies a cookie(s) to send to the web server.

Each cookie is specified by following list:

    ( version
      name
      value
      path
      domain
      port
      path_spec
      secure
      maxage
      discard
      name1
      value1
      name2
      value2
      ...
    )


Any element not marked below as REQUIRED may be defaulted by
specifying a null value or ''.

=over 4

=item * version (REQUIRED)

Version number of cookie spec to use, usually 0.

=item * name (REQUIRED)

Name of cookie. Cannot begin with a $ character.

=item * value (REQUIRED)

Value of cookie.

=item * path (REQUIRED)

URL path name for which this cookie applies. Must begin with a /
character.  See also path_spec.

=item * domain (REQUIRED)

Domain for which cookie is valid. (REQUIRED). Should begin with a
period.  Must either contain two periods or be equal to C<.local>.

=item * port

List of allowed port numbers that the cookie may be returned to.  If
not specified, cookie can be returned to any port.  Must be specified
using the format C<N> or C<N, N, ..., N> where N is one or more
digits.

=item * path_spec

Ignored if version is less than 1.  Option to ignore the value of
path.  Default value is 0.

=over 4

=item * 1

Use the value of path.

=item * 0

Ignore the specified value of path.

=back

=item * secure

Option to require secure protocols for cookie transmission.  Default
value is 0.

=over 4

=item * 1

Use only secure protocols to transmit this cookie.

=item * 0

Secure protocols are not required for transmission.

=back

=item * maxage

Number of seconds until cookie expires.

=item * discard

Option to discard cookie when the program finishes.  Default 0. (The
cookie will be discarded regardless of the value of this element.)

=over 4

=item * 1

Discard cookie when the program finishes.

=item * 0

Don't discard cookie.

=back

=item * name/value

Zero, one or several name/value pairs may be specified. The name
parameters are words such as Comment or CommentURL and the value
parameters are strings that may contain embedded blanks.

=back

See RFC 2965 for details (ftp://ftp.isi.edu/in-notes/rfc2965.txt).

=head3 Usage in wtscript files

You may specify multiple cookies within each test block by specifying
multiple instances of the C<cookies> parameter.

=head3 Usage in Perl scripts

Use arrayref of arrayrefs containing cookies to pass with the HTTP
request.

Each array must have at least 5 elements; if the number of elements is
over 10 it must have an even number of elements.



=head2 error_log

The pathname of a local web server error log. The module counts the
number of lines in the error log before and after each request. If the
number of lines increases, an error is counted and the additional
lines are listed in the report. This argument should be used only when
the local web server is running in single-process mode. Otherwise,
requests generated by other processes/users may add lines to the error
log that are not related to the requests generated by this module. See
also parameter C<ignore_error_log>.

=head2 fh_out

A filehandle (or anything else that supports C<print>) to use for test
report output. This parameter make sense only in Perl scripts.

=head2 file_path

Two-element list. First element is the file to test, either an
absolute or a relative pathname. Second element is the subdirectory
pathname, relative to the Apache htdocs directory, to copy the file
to. The copied file will have the same basename as the first element
and the relative pathname of the second element. To copy the file
directly to the htdocs directory, use a pathname of C<.> or C<./.>.

=head2 ignore_case

Option to do case-insensitive string matching for C<text_forbid>,
C<text_require>, C<regex_forbid> and C<regex_require> test parameters.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 ignore_error_log

Option to ignore any errors found in the Apache error log. The default
behavior is to flag an error if the fetch causes any errors to be
added to the error log and echo the errors to the program output. This
check is available only if C<error_log> parameter is specified. See also
the C<apache_loglevel> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 include_file_path

List with an even number of elements. Odd-numbered elements are files
to copy to the the temporary Apache directory before running the
tests. These files can be specified using either an absolute or a
relative pathname. Even-numbered elements are the subdirectory
pathname, relative to the Apache ServerRoot directory, to copy the
corresponding file to. The copied file will have the same basename as
the odd-numbered element and the relative pathname of the
corresponding even-numbered element.  To copy the file directly to the
ServerRoot directory, use a pathname of C<.> or C<./.>.



=head2 mail

Option to e-mail output to one or more addresses specified by
C<mail_addresses> test parameter.

=over 4

=item * all

Send e-mail containing test results.

=item * errors

Send e-mail only if one or more tests fails.

=item * no

Do not send e-mail.

=head3 Default value

C<no>

=back

=head2 mail_addresses

A list of e-mail addresses where report will be send (if sending
report is enabled with C<mail> test parameter).

=head2 mail_from

Sets From: header for report e-mails.

=head3 Default Value

Name of user under which test script runs.



=head2 mail_server

Fully-qualified name of of the mail server (e.g., mailhost.mycompany.com).

=head3 Default value

C<localhost>

=head2 max_bytes

Maximum number of bytes expected in returned page.

=head3 Allowed Values

Any integer greater that zero and greater than C<min_bytes> (if
C<min_bytes> is specified).



=head2 max_rtime

Maximum web server response time (seconds) expected.

=head3 Allowed values

Any number greater that zero and greater than C<min_rtime> (if
C<min_rtime> is specified).



=head2 method

HTTP request method.

=head3 Allowed values

C<GET>, C<PUT>

=head3 Default value

C<GET>

=head2 min_bytes

Minimum number of bytes expected in returned page.

=head3 Allowed Values

Any integer less than C<max_bytes> (if C<max_bytes> is specified).

=head2 min_rtime

Minimum web server response time (seconds) expected.

=head3 Allowed values

Any number less than C<max_rtime> (if C<max_rtime> is specified).

=head2 output_ref

A reference on scalar which accumulates text of test report.
This parameter make sense only in Perl scripts.

=head2 params

A list of name/value pairs to be passed as parameters to the
URL. (This element is used to test pages that process input from
forms.) Unless the method key is set to C<POST>, these pairs are
URI-escaped and appended to the requested URL.

=head2 pauth

A list of userid/password pairs to be used for proxy server access
authorization.



=head2 plugins

A list of module names. Loads these modules and registers them as
L<HTTP::WebTest|HTTP::WebTest> plugins. If name of plugin starts with
C<::> prepends it with C<HTTP::WebTest::Plugin>. So

    plugins = ( ::ValidateHTML )

is equal to

    plugins = ( HTTP::WebTest::Plugin::ValidateHTML )



=head2 proxies

A list of service name/proxy URL pairs that specify proxy servers to
use for requests.

For example (C<wtscript> usage):

    proxies = ( http => http://http_proxy.mycompany.com
                ftp  => http://ftp_proxy.mycompany.com )

=head2 regex_forbid

List of regular expressions that are URI forbidden to exist in the
returned page.

=head2 regex_require

List of regular expressions that are URI required to exist in the
returned page.

=head2 send_cookies

Option to send cookies to web server. This applies to cookies received
from the web server or cookies specified using the C<cookies> test
parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 show_cookie

Option to display any cookies sent or received.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 show_html

Include content of HTTP response in the test report.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 terse

Option to display shorter test report.

=over 4

=item * summary

Only a one-line summary for each URL

=item * failed_only

Only tests that failed and the summary

=item * no

Show all tests and the summary

=head3 Default value

C<no>

=back



=head2 test_name

Name associated with this url in the test report and error messages.

=head2 text_forbid

List of text strings that are forbidden to use exist in the returned
page.

=head2 text_require

List of text strings that are required to use exist in the returned
page.

=head2 url

URL to test. If schema is omitted then HTTP is implied.

=for pod_merge TEST PARAMETERS

Content of this section should be autogenerated from POD docs in plugin
modules.

=head1 RESTRICTIONS / BUGS

This module have been tested only on Unix (e.g., Solaris, Linux, AIX,
etc.) but it should work on Win32 systems.

Local file tests don't work on Win32 systems.

The module's HTTP requests time out after 3 minutes (the default value
for L<LWP::UserAgent|LWP::UserAgent>). If the file_path parameter is
specified, Apache must be installed.

=head1 AUTHOR

Richard Anderson <Richard.Anderson@unixscripts.com> have wrote
C<HTTP::WebTest 1.xx>.

Ilya Martynov <ilya@martynov.org> made rewrite of C<HTTP::WebTest>. He
is maintaining C<HTTP::WebTest> now. Please email him bug reports,
suggestions, questions, etc.

=head1 COPYRIGHT

Copyright (c) 2000-2001 Richard Anderson. All rights reserved.

Copyright (c) 2001,2002 Ilya Martynov. All rights reserved.

This module is free software.  It may be used, redistributed and/or
modified under the terms of the Perl Artistic License.

=head1 SEE ALSO

L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>

L<HTTP::WebTest::API|HTTP::WebTest::API>

L<HTTP::WebTest::Plugins|HTTP::WebTest::Plugins>

L<wt|wt>

=cut

1;
