use v6.c;
use Test;      # a Standard module included with Rakudo 
use lib 'lib';

use Mathx::Stat::DistributionPopulation;
use Mathx::Stat::Covariance;
use Mathx::Stat::Correlation;
use Mathx::Stat::CorrelationDimension;
use Mathx::Stat::Probability;

my $num-tests = 8;

plan $num-tests;
 
# .... tests 
#  

my $pp = 0.1;
my $pop = Mathx::Stat::DistributionPopulation.new;

my @plist;
my @indices;

loop (my $i = $pp, my $j = 0; $i <= 1.0; $i+=0.1, $j++) {
	$pop.add($i);
	push(@plist, $i);
	push(@indices, $j);
}

ok $pop.Expectance, 0.55;

ok $pop.Variance, $pop.Variance;

my $cov = Mathx::Stat::Covariance.new;
my $corr = Mathx::Stat::Correlation.new;

ok $cov.Covariance($pop,$pop), $cov.Covariance($pop,$pop);

ok $corr.Correlation($pop,$pop), $corr.Correlation($pop,$pop);

my $p = Mathx::Stat::Probability.new(xpop => @plist);

ok $p.Bayes(@indices, @plist, 1), $p.Bayes(@indices, @plist, 1);

ok $p.Bayes(@indices, @plist, 0), $p.Bayes(@indices, @plist, 0);

ok $p.CalculatedCondP(3,0), $p.CalculatedCondP(3,0);

ok $p.CalculatedCondP(7,4), $p.CalculatedCondP(7,4);

done-testing;  # optional with 'plan' 
