unit module Bayes::Learn;
use Mathx::Stat;
 
class Bayes::Learn::Strategy is Mathx::Stat::DistributionPopulation {

	has @.strategypopulation;

	method BUILD(@lossfuncs) {
		.population = @lossfuncs; ### LossFunction instances
		.strategypopulation = new Population();
	}

	method addStrategy($s) {
		.strategypopulation.add($s);
	}
	
	method minimax(@condps) { ### This is a minimax value, 
				  ### to be used in the infimum, for minimum 
				  ### probability of strategies

		my $sup = 0.0.	

		for .population -> $f {
			my $loss = $f.BayesianLoss(@condps);
			if ($loss > $sup) {
				$sup = $loss;
			}		
		}

		return $sup;
	}

	method randomstrategyminimax(@condps) { ### This has to be run several
						### times with infimum of this
						### function to have a smallest
						### probability
		my $sup = 0.0.	

		loop (my $i = 0; $i < 0..^.strategypopulation.population.length.rand)
		 {
			my $loss = self.minimax(@condps);
			if ($loss > $sup) {
				$sup = $loss;
			}		
		}
		
		return $sup;
	}

}
