#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More 0.82;

eval 'use Map::Tube::London';
plan skip_all => 'Map::Tube::London required for this test' if $@;

plan tests => 39;

my $tube = Map::Tube::London->new();
my $ret;

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations' );
ok($ret, 'Finding Baker Street exactly');
is($ret->name(), 'Baker Street', 'Finding Baker exactly') if $ret;

$ret = $tube->fuzzy_find( 'Baker',        objects => 'stations' );
is($ret, undef, 'Finding Baker exactly should fail');

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations', method => 'start' );
ok($ret, 'Finding Baker Street at start');
is($ret->name(), 'Baker Street', 'Finding Baker at start') if $ret;

$ret = $tube->fuzzy_find( 'Baker',        objects => 'stations', method => 'start' );
ok($ret, 'Finding Baker at start');
is($ret->name(), 'Baker Street', 'Finding Baker at start') if $ret;

$ret = $tube->fuzzy_find( 'Bakerx',       objects => 'stations', method => 'start' );
is($ret, undef, 'Finding Bakerx at start should fail');

$ret = $tube->fuzzy_find( 'ker',          objects => 'stations', method => 'start' );
is($ret, undef, 'Finding ker at start should fail');

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations', method => 'in' );
ok($ret, 'Finding Baker Street somewhere');
is($ret->name(), 'Baker Street', 'Finding Baker somewhere');

$ret = $tube->fuzzy_find( 'Baker',        objects => 'stations', method => 'in' );
ok($ret, 'Finding Baker somewhere');
is($ret->name(), 'Baker Street', 'Finding Baker somewhere');

$ret = $tube->fuzzy_find( 'ker',          objects => 'stations', method => 'in' );
ok($ret, 'Finding ker somewhere');
is($ret->name(), 'Baker Street', 'Finding ker somewhere');

$ret = $tube->fuzzy_find( 'xer',          objects => 'stations', method => 'in' );
is($ret, undef, 'Finding xer somewhere should fail');

$ret = $tube->fuzzy_find( '[kx]er',       objects => 'stations', method => 're' );
ok($ret, 'Finding regex [kx]er');
is($ret->name(), 'Baker Street', 'Finding regex [kx]er');

$ret = $tube->fuzzy_find( '[tx]er',       objects => 'stations', method => 're' );
ok($ret, 'Finding regex [tx]er');
is($ret->name(), 'Bayswater', 'Finding regex [tx]er');

$ret = $tube->fuzzy_find( '[ktx]er',      objects => 'stations', method => 're' );
ok($ret, 'Finding regex [ktx]er');
is($ret->name(), 'Baker Street', 'Finding regex [ktx]er');

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations', method => 'levenshtein' );
ok($ret, 'Finding Baker Street fuzzy');
is($ret->name(), 'Baker Street', 'Finding Baker Street fuzzy');

$ret = $tube->fuzzy_find( 'Baker',        objects => 'stations', method => 'levenshtein' );
ok($ret, 'Finding Baker fuzzy');
is($ret->name(), 'Bank', 'Finding Baker fuzzy');

$ret = $tube->fuzzy_find( 'Paisvatr',     objects => 'stations', method => 'levenshtein' );
ok($ret, 'Finding Paisvatr fuzzy');
is($ret->name(), 'Bayswater', 'Finding Paisvatr fuzzy');

$ret = $tube->fuzzy_find( 'Beisvtr',      objects => 'stations', method => 'levenshtein', maxdist => 6 );
ok($ret, 'Finding Beisvtr fuzzy with distance 6');
is($ret->name(), 'Bayswater', 'Finding Beisvtr fuzzy at max distance 6');

$ret = $tube->fuzzy_find( 'Beisvtr',      objects => 'stations', method => 'levenshtein' );
is($ret, undef, 'Finding Beisvtr fuzzy at standard max distance should fail');

$ret = $tube->fuzzy_find( 'Beisvtr',      objects => 'stations', method => 'levenshtein', maxdist => 4 );
is($ret, undef, 'Finding Beisvtr fuzzy at max distance 4 should fail');

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations', method => 'soundex' );
is( $ret->name(), 'Baker Street', 'Finding Baker Street based on soundex' );

$ret = $tube->fuzzy_find( 'Bkrs', objects => 'stations', method => 'soundex' );
is( $ret->name(), 'Baker Street', 'Finding Bkrs based on soundex' );

$ret = $tube->fuzzy_find( 'Bxqxq', objects => 'stations', method => 'soundex' );
is( $ret->name(), 'Bushey', 'Finding Bxqxq based on soundex' );

$ret = $tube->fuzzy_find( 'Pxqxq', objects => 'stations', method => 'soundex' );
is( $ret, undef, 'Finding Pxqxq based on soundex should fail' );

$ret = $tube->fuzzy_find( 'Baker Street', objects => 'stations', method => 'metaphone' );
is( $ret->name(), 'Baker Street', 'Finding Baker Street based on metaphone' );

$ret = $tube->fuzzy_find( 'Bkrstrt', objects => 'stations', method => 'metaphone' );
is( $ret->name(), 'Baker Street', 'Finding Bkrstrt based on metaphone' );

$ret = $tube->fuzzy_find( 'Bxqxq', objects => 'stations', method => 'metaphone' );
is( $ret, undef, 'Finding Bxqxq based on metaphone' );

