package Text::Xslate::PP::Compiler;

use Any::Moose;
use Any::Moose '::Util::TypeConstraints';
use Text::Xslate::Util qw(
    value_to_literal
);


extends qw(Text::Xslate::Compiler);

use Text::Xslate::PP::Compiler::CodeGenerator;
use Data::Dumper ();

sub as_assembly { # it makes a pp::booster code.
    my($self, $asm ) = @_;
    my $asm_dump = Data::Dumper::Dumper $asm;

    $asm_dump =~ s/^\$VAR1 = /        /;
    $asm_dump =~ s/;/,/;

    my $perlcode = Text::Xslate::PP::Compiler::CodeGenerator->new()->opcode_to_perlcode_string( $asm );

    "# below liens are generated by Compiler::PPBooster.\n"
    . "ppbooster\n"
    . "[\n"
    . $asm_dump
    . $perlcode
    . "\n]";
}

no Any::Moose;
no Any::Moose '::Util::TypeConstraints';

__PACKAGE__->meta->make_immutable;

__END__

=head1 NAME

Text::Xslate::PP::Compiler - The Xslate compiler for PP::Booster

=head1 DESCRIPTION

This is the Xslate compiler to generate the intermediate code from the
abstract syntax tree that parsers build from templates.

=head1 SEE ALSO

L<Text::Xslate>

L<Text::Xslate::Parser>

L<Text::Xslate::PP>

L<Text::Xslate::PP::Booster>

=cut
