#!/usr/local/bin/perl -w

# $Id: makefont.pl,v 1.2 1995/09/14 12:28:30 aas Exp $
#
# Author: Gisle Aas

@FONTS = qw(Courier
	    Courier-Bold
	    Courier-Oblique
	    Courier-BoldOblique

	    Helvetica
	    Helvetica-Bold
	    Helvetica-Oblique
	    Helvetica-BoldOblique
  
	    Times-Roman
	    Times-Bold
	    Times-Italic
	    Times-BoldItalic
	   );
@FONTS = @ARGV if @ARGV;
	  
require HTML::FormatPS;
require Font::AFM;

$0 =~ s,.*/,,;

for $font (@FONTS) {
    eval {
	$afm = new Font::AFM $font;
    };
    if ($@) {
	print $@;
	next;
    }
    @wx = $afm->latin1_wx_table;
    
    ($fontmod = $font) =~ s/-//g;

    open(FONTDEF, ">$fontmod.pm") or die "Can't open $fontmod.pm: $!";
    select FONTDEF;
    print "# Font metrics for $font\n#\n";
    print "# DO NOT EDIT!!!\n";
    print "#\n";
    print "# This file was auto-generated by $0 based on the AFM file for the font.\n";
    print "#\n# ", $afm->Notice, "\n";
    print "\n";
    print "package Font::$fontmod;\n";
    
    print "\n# Character width table (iso-8859-1)\n";
    print "\@wx = (\n";
    $i = 0;
    for (@wx) {
	printf " %.3g,", $_ / 1000;
	unless (++$i % 8) {
	    print "\n";
	}
    }
    print ");\n";

    $upos   = $afm->UnderlinePosition;
    $uthick = $afm->UnderlineThickness;
    if ($upos && $uthick) {
	print "\n";
	printf "\$UnderlinePosition  = %.3g;\n", $upos/1000;
	printf "\$UnderlineThickness = %.3g;\n", $uthick/1000;
    }

    print "\n1;\n";
}

