# NAME

Import::Into::As - Wrapper around Import::Into that lets you rename subs.

# DESCRIPTION

This wrapper provides a new function `import::into::as` which works just like
`import::into()`, except that you can rename the subs being exported around.

This is a wrapper around [Import::Into](https://metacpan.org/pod/Import::Into), which is an awesome tool that lets
you import any module into any other module. The problem is that not all
modules you are importing from have the ability to rename exports. This is not
a problem if you are exporting from modules that use [Sub::Exporter](https://metacpan.org/pod/Sub::Exporter) or
[Exporter::Declare](https://metacpan.org/pod/Exporter::Declare), but it is a problem if you want to rename a sub exported
from [Exporter](https://metacpan.org/pod/Exporter).

**Note:** If you are exporting from modules that allow you to rename the exports
in their own syntax then you should use that. This module will be slower than
using the exporters rename syntax when available.

# SYNOPSYS

    use Import::Into::As;

    # Export 'foo' and 'baz' from Some::Exporter into Destination::Package.
    # Rename 'foo' to 'bar' in the process.
    Some::Exporter->import_into_as('Destination::Package', {foo => bar}, qw/foo baz/);

# METHODS

## $package->import::into::as($target, \\%renames, @arguments);

- $package

    Package to export from.

- $target

    This can be a target package, a call level, or a hashref, see
    ["METHODS" in Import::Into](https://metacpan.org/pod/Import::Into#METHODS) for an expanded explanation of `$target`.

- \\%renames

    This must be a hashref where the keys are the names of a subs exported by the
    package, and the values are the new names you want them to have.

        { 'export_name' => 'new_name', ... }

- \\@arguments

    Import arguments for the package.

# LIMITATIONS

- Only subs can be renamed (this may change in the future)

    It would not be difficult to add renaming support for other types, but there
    has not been any need yet.

# SOURCE

The source code repository for Import-Into-As can be found at
`http://github.com/exodist/Import-Into-As`.

# MAINTAINERS

- Chad Granum &lt;exodist@cpan.org>

# AUTHORS

- Chad Granum &lt;exodist@cpan.org>

# COPYRIGHT

Copyright 2015 Chad Granum &lt;exodist7@gmail.com>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See `http://dev.perl.org/licenses/`
