#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::APP12',
    'Image::ExifTool::BMP::Main',
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::LensInfo1D',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::Panorama',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonCustom::FunctionsD30',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Composite',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::Extra',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Type6',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::MIFF::Main',
    'Image::ExifTool::MNG::Background',
    'Image::ExifTool::MNG::BasisObject',
    'Image::ExifTool::MNG::ClipObjects',
    'Image::ExifTool::MNG::CloneObject',
    'Image::ExifTool::MNG::DefineObject',
    'Image::ExifTool::MNG::DeltaPNGHeader',
    'Image::ExifTool::MNG::ExportImage',
    'Image::ExifTool::MNG::FramePriority',
    'Image::ExifTool::MNG::JNGHeader',
    'Image::ExifTool::MNG::Loop',
    'Image::ExifTool::MNG::MNGHeader',
    'Image::ExifTool::MNG::MagnifyObject',
    'Image::ExifTool::MNG::Main',
    'Image::ExifTool::MNG::MoveObjects',
    'Image::ExifTool::MNG::PasteImage',
    'Image::ExifTool::MNG::PromoteParent',
    'Image::ExifTool::MNG::ShowObjects',
    'Image::ExifTool::MNG::TerminationAction',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalance0100',
    'Image::ExifTool::Nikon::ColorBalance0102',
    'Image::ExifTool::Nikon::ColorBalance0103',
    'Image::ExifTool::Nikon::LensData00',
    'Image::ExifTool::Nikon::LensData01',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::RawDevelopment',
    'Image::ExifTool::PDF::AdobePhotoshop',
    'Image::ExifTool::PDF::ColorSpace',
    'Image::ExifTool::PDF::DefaultRGB',
    'Image::ExifTool::PDF::ICCBased',
    'Image::ExifTool::PDF::ImageResources',
    'Image::ExifTool::PDF::Info',
    'Image::ExifTool::PDF::Kids',
    'Image::ExifTool::PDF::Main',
    'Image::ExifTool::PDF::Metadata',
    'Image::ExifTool::PDF::Pages',
    'Image::ExifTool::PDF::PieceInfo',
    'Image::ExifTool::PDF::Private',
    'Image::ExifTool::PDF::Resources',
    'Image::ExifTool::PDF::Root',
    'Image::ExifTool::PNG::ImageHeader',
    'Image::ExifTool::PNG::Main',
    'Image::ExifTool::PNG::PhysicalPixel',
    'Image::ExifTool::PNG::PrimaryChromaticities',
    'Image::ExifTool::PNG::TextualData',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PostScript::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::Text',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
);

my %tagLookup = (
    'actionadvised' => { 40 => 0x2a },
    'addoriginaldecisiondata' => { 16 => 0x11 },
    'adjustmentmode' => { 125 => 0x15 },
    'adobephotoshop' => { 106 => 'AdobePhotoshop' },
    'advisory' => { 128 => 'Advisory' },
    'aebbracketvalue' => { 12 => 0x11 },
    'aebsequence' => { 14 => 0x9, 15 => 0x9, 16 => 0x8, 17 => 0x7 },
    'afaperture' => { 85 => 0x5 },
    'afareas' => { 90 => 0x304 },
    'afassist' => { 14 => 0x5, 17 => 0x5 },
    'afassistbeam' => { 16 => 0x4 },
    'afmode' => { 125 => 0x5 },
    'afpoint' => { 2 => 0x13, 86 => 0x88 },
    'afpointactivationarea' => { 15 => 0x11 },
    'afpointillumination' => { 15 => 0xa },
    'afpointregistration' => { 14 => 0x7 },
    'afpointselection' => { 15 => 0xb },
    'afpointselectionmethod' => { 16 => 0xc },
    'afpointspotmetering' => { 15 => 0xd },
    'afpointsused' => { 10 => 0x16 },
    'afsearch' => { 90 => 0x303 },
    'aiservotrackingsensitivity' => { 15 => 0x14 },
    'aliaslayermetadata' => { 29 => 0xc660 },
    'alphabitdepth' => { 69 => 0xc },
    'alphachannelsnames' => { 118 => 0x3ee },
    'alphacompression' => { 69 => 0xd },
    'alphafilter' => { 69 => 0xe },
    'alphaidentifiers' => { 118 => 0x41d },
    'alphainterlace' => { 69 => 0xf },
    'alphasample' => { 62 => 0x19 },
    'analogbalance' => { 29 => 0xc627 },
    'analogzoom' => { 55 => 0x1e },
    'annotations' => { 29 => 0xc44f },
    'antialiasstrength' => { 29 => 0xc632 },
    'aperture' => { 28 => 'Aperture' },
    'aperturevalue' => { 29 => 0x9202, 128 => 'ApertureValue' },
    'app1_profile' => { 60 => 'profile-APP1', 114 => 'Raw profile type APP1' },
    'applicationnotes' => { 29 => 0x2bc },
    'applicationrecordversion' => { 40 => 0x0 },
    'armidentifier' => { 41 => 0x78 },
    'armversion' => { 41 => 0x7a },
    'artist' => { 29 => 0x13b, 128 => 'Artist' },
    'asshotneutral' => { 29 => 0xc628 },
    'asshotwhitexy' => { 29 => 0xc629 },
    'assistbuttonfunction' => { 14 => 0xd },
    'association' => { 50 => 'asoc' },
    'atob0' => { 37 => 'A2B0' },
    'atob1' => { 37 => 'A2B1' },
    'atob2' => { 37 => 'A2B2' },
    'audio' => { 115 => 0x20 },
    'audioduration' => { 40 => 0x99 },
    'audiooutcue' => { 40 => 0x9a },
    'audiosamplingrate' => { 40 => 0x97 },
    'audiosamplingresolution' => { 40 => 0x98 },
    'audiotype' => { 40 => 0x96 },
    'author' => { 101 => 'Author', 114 => 'Author', 119 => 'Author', 128 => 'Author' },
    'authorsposition' => { 128 => 'AuthorsPosition' },
    'autoafpoint' => { 116 => 0xf },
    'autobracket' => { 125 => 0x19 },
    'autobracketing' => { 31 => 0x1100 },
    'autoexposurebracketing' => { 12 => 0x10 },
    'autofocus' => { 92 => 0x209 },
    'autorotate' => { 12 => 0x1b },
    'auxiliarylens' => { 86 => 0x82 },
    'avvalue' => { 18 => 0x2 },
    'background' => { 73 => 'BACK' },
    'backgroundcolor' => { 60 => 'background-color', 61 => 0x0, 111 => 'bKGD', 118 => 0x3f2 },
    'backgroundcolorindicator' => { 29 => 0x84e8 },
    'backgroundcolorvalue' => { 29 => 0x84ea },
    'backgroundimageid' => { 61 => 0x7 },
    'backgroundtiling' => { 61 => 0x9 },
    'badfaxlines' => { 29 => 0x146 },
    'baseiso' => { 22 => 0x101c },
    'baselineexposure' => { 29 => 0xc62a },
    'baselinenoise' => { 29 => 0xc62b },
    'baselinesharpness' => { 29 => 0xc62c },
    'baseurl' => { 128 => 'BaseURL' },
    'basisobject' => { 73 => 'BASI' },
    'batterylevel' => { 29 => 0x828f },
    'bayergreensplit' => { 29 => 0xc62d },
    'bestqualityscale' => { 29 => 0xc65c },
    'bestshotmode' => { 27 => 0x3007 },
    'binaryfilter' => { 50 => 'bfil' },
    'bitdepth' => { 1 => 0xe, 62 => 0x8, 69 => 0x9, 110 => 0x8 },
    'bitspercomponent' => { 43 => 0x87, 49 => 0xa, 50 => 'bpcc' },
    'bitsperextendedrunlength' => { 29 => 0x84e5 },
    'bitsperrunlength' => { 29 => 0x84e4 },
    'bitspersample' => { 29 => 0x102, 128 => 'BitsPerSample' },
    'blacklevel' => { 29 => 0xc61a, 94 => 0x1012 },
    'blackleveldeltah' => { 29 => 0xc61b },
    'blackleveldeltav' => { 29 => 0xc61c },
    'blacklevelrepeatdim' => { 29 => 0xc619 },
    'blackpoint' => { 116 => 0x200 },
    'blocklocation' => { 66 => 0xc },
    'blocksize' => { 66 => 0x4 },
    'bluebalance' => { 81 => 0x1, 82 => 0x1, 83 => 0x1, 94 => 0x1018, 116 => 0x1b },
    'bluebalanceauto' => { 13 => 0x1 },
    'bluebalanceb&w' => { 13 => 0xf },
    'bluebalancecloudy' => { 13 => 0x5 },
    'bluebalancecustom' => { 13 => 0xd },
    'bluebalancedaylight' => { 13 => 0x3 },
    'bluebalanceflash' => { 13 => 0xb },
    'bluebalancefluorescent' => { 13 => 0x9 },
    'bluebalanceshade' => { 13 => 0x11 },
    'bluebalancetungsten' => { 13 => 0x7 },
    'bluegain' => { 123 => 'Bg' },
    'bluehue' => { 128 => 'BlueHue' },
    'bluematrixcolumn' => { 37 => 'bXYZ' },
    'blueprimary' => { 60 => 'blue-primary' },
    'bluesample' => { 62 => 0x15 },
    'bluesaturation' => { 128 => 'BlueSaturation' },
    'bluetrc' => { 37 => 'bTRC' },
    'bluex' => { 113 => 0x6 },
    'bluey' => { 113 => 0x7 },
    'blurwarning' => { 31 => 0x1300 },
    'bodyfirmwareversion' => { 91 => 0x104 },
    'bordercolor' => { 60 => 'border-color' },
    'borderid' => { 51 => 0x2 },
    'borderinformation' => { 118 => 0x3f1 },
    'borderlocation' => { 51 => 0x3 },
    'bordername' => { 51 => 0x1 },
    'bordersversion' => { 51 => 0x0 },
    'bordertype' => { 51 => 0x4 },
    'bottommag' => { 72 => 0xf },
    'boundaryorigin' => { 75 => 0x18 },
    'bracket' => { 94 => 0x1006 },
    'bracketstep' => { 79 => 0xe },
    'brightness' => { 29 => 0xfe53, 79 => 0x2c, 128 => 'Brightness' },
    'brightnessvalue' => { 29 => 0x9203, 128 => 'BrightnessValue' },
    'btoa0' => { 37 => 'B2A0' },
    'btoa1' => { 37 => 'B2A1' },
    'btoa2' => { 37 => 'B2A2' },
    'bulbduration' => { 12 => 0x18 },
    'burstmode' => { 52 => 0xa },
    'burstmode2' => { 52 => 0x18 },
    'bw_halftoninginfo' => { 118 => 0x3f4 },
    'bw_transferfunc' => { 118 => 0x3f7 },
    'bwfilter' => { 79 => 0x2a },
    'bwmode' => { 94 => 0x203 },
    'by-line' => { 40 => 0x50 },
    'by-linetitle' => { 40 => 0x55 },
    'calibrationdatetime' => { 37 => 'calt' },
    'calibrationilluminant1' => { 29 => 0xc65a },
    'calibrationilluminant2' => { 29 => 0xc65b },
    'cameracalibration1' => { 29 => 0xc623 },
    'cameracalibration2' => { 29 => 0xc624 },
    'cameraid' => { 94 => 0x209, 124 => 0x209 },
    'cameraiso' => { 2 => 0x10 },
    'cameraobject' => { 22 => 0x2807 },
    'cameraowner' => { 29 => 0xc353 },
    'camerasettings' => { 94 => 0x2020 },
    'camerasettingsversion' => { 90 => 0x0 },
    'cameraspecification' => { 22 => 0x3004 },
    'canoncamerasettings' => { 8 => 0x1, 22 => 0x102d },
    'canoncolorinfo' => { 8 => 0xa0 },
    'canoncolorinfo1' => { 22 => 0x32 },
    'canoncolorinfo2' => { 22 => 0x102c },
    'canoncolorinfod30' => { 8 => 0xa },
    'canoncustomfunctions10d' => { 8 => 0xf, 22 => 0x1033 },
    'canoncustomfunctions1d' => { 8 => 0x90 },
    'canoncustomfunctions20d' => { 8 => 0xf, 22 => 0x1033 },
    'canoncustomfunctionsd30' => { 8 => 0xf, 22 => 0x1033 },
    'canonexposuremode' => { 2 => 0x14 },
    'canonfiledescription' => { 22 => 0x805 },
    'canonfileinfo' => { 8 => 0x93 },
    'canonfilelength' => { 8 => 0xe },
    'canonfirmwareversion' => { 8 => 0x7, 22 => 0x80b },
    'canonflashinfo' => { 8 => 0x3 },
    'canonflashmode' => { 2 => 0x4 },
    'canonfocallength' => { 8 => 0x2, 22 => 0x1029 },
    'canonimageheight' => { 10 => 0x3 },
    'canonimageheightasshot' => { 10 => 0x5 },
    'canonimagesize' => { 2 => 0xa },
    'canonimagetype' => { 8 => 0x6, 22 => 0x815 },
    'canonimagewidth' => { 10 => 0x2 },
    'canonimagewidthasshot' => { 10 => 0x4 },
    'canonlensinfo1d' => { 8 => 0xd },
    'canonpanorama' => { 8 => 0x5 },
    'canonpictureinfo' => { 8 => 0x12, 22 => 0x1038 },
    'canonrawmakemodel' => { 22 => 0x80a },
    'canonshotinfo' => { 8 => 0x4, 22 => 0x102a },
    'caption-abstract' => { 40 => 0x78 },
    'captionwriter' => { 128 => 'CaptionWriter' },
    'captureconditionspar' => { 29 => 0xc352 },
    'capturedevicefid' => { 29 => 0xc357 },
    'captureresolution' => { 50 => 'resc' },
    'capturexresolution' => { 47 => 0x4 },
    'capturexresolutionunit' => { 47 => 0x9 },
    'captureyresolution' => { 47 => 0x0 },
    'captureyresolutionunit' => { 47 => 0x8 },
    'casioimagesize' => { 27 => 0x9 },
    'category' => { 40 => 0xf, 128 => 'Category' },
    'ccdisosensitivity' => { 27 => 0x3014 },
    'ccdsensitivity' => { 26 => 0x14, 87 => 0x6 },
    'celllength' => { 29 => 0x109 },
    'cellwidth' => { 29 => 0x108 },
    'certificate' => { 128 => 'Certificate' },
    'cfalayout' => { 29 => 0xc617 },
    'cfapattern' => { 28 => 'CFAPattern', 29 => 0xa302, 128 => 'CFAPattern' },
    'cfapattern2' => { 29 => 0x828e },
    'cfapatterncolumns' => { 128 => 'CFAPatternColumns' },
    'cfapatternrows' => { 128 => 'CFAPatternRows' },
    'cfapatternvalues' => { 128 => 'CFAPatternValues' },
    'cfaplanecolor' => { 29 => 0xc616 },
    'cfarepeatpatterndim' => { 29 => 0x828d },
    'chartarget' => { 37 => 'targ' },
    'chromablurradius' => { 29 => 0xc631 },
    'chromaticaberrationb' => { 128 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 128 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 37 => 'chad' },
    'chromaticity' => { 37 => 'chrm' },
    'chromaticitychannel1' => { 34 => 0xc },
    'chromaticitychannel2' => { 34 => 0x14 },
    'chromaticitychannel3' => { 34 => 0x1c },
    'chromaticitychannel4' => { 34 => 0x24 },
    'chromaticitychannels' => { 34 => 0x8 },
    'chromaticitycolorant' => { 34 => 0xa },
    'circleofconfusion' => { 28 => 'CircleOfConfusion' },
    'city' => { 40 => 0x5a, 128 => 'City' },
    'class' => { 60 => 'class' },
    'classifystate' => { 40 => 0xe1 },
    'cleanfaxdata' => { 29 => 0x147 },
    'clipboundary' => { 63 => 0x5 },
    'clipobjects' => { 73 => 'CLIP' },
    'clippath' => { 29 => 0x157 },
    'clippingboundary' => { 65 => 0xc },
    'clippingpathname' => { 118 => 0xbb7 },
    'cloneid' => { 64 => 0x2 },
    'cloneobject' => { 73 => 'CLON' },
    'clonetype' => { 64 => 0x4 },
    'cmmflags' => { 36 => 0x2c },
    'codedcharacterset' => { 41 => 0x5a },
    'codestreamheader' => { 50 => 'jpch' },
    'codestreamregistration' => { 50 => 'creg' },
    'codingmethods' => { 29 => 0x193 },
    'coloradjustment' => { 125 => 0x14 },
    'coloradjustmentmode' => { 124 => 0x210 },
    'colorant1coordinates' => { 35 => 0x2c },
    'colorant1name' => { 35 => 0xc },
    'colorant2coordinates' => { 35 => 0x52 },
    'colorant2name' => { 35 => 0x32 },
    'colorant3coordinates' => { 35 => 0x78 },
    'colorant3name' => { 35 => 0x58 },
    'colorantcount' => { 35 => 0x8 },
    'colorantorder' => { 37 => 'clro' },
    'coloranttable' => { 37 => 'clrt' },
    'colorbalance0100' => { 86 => 0x97 },
    'colorbalance0102' => { 86 => 0x97 },
    'colorbalance0103' => { 86 => 0x97 },
    'colorbalance1' => { 86 => 0xc },
    'colorbalanceblue' => { 79 => 0x1e },
    'colorbalancegreen' => { 79 => 0x1d },
    'colorbalancered' => { 79 => 0x1c },
    'colorbalanceunknown' => { 86 => 0x97 },
    'colorbitdepth' => { 21 => 0x5 },
    'colorbw' => { 21 => 0x6 },
    'colorcalibrationmatrix' => { 43 => 0x46 },
    'colorcharacterization' => { 29 => 0x84ed },
    'colorcontrol' => { 94 => 0x102b },
    'coloreffect' => { 115 => 0x28 },
    'colorfilter' => { 79 => 0x29 },
    'colorgroup' => { 50 => 'cgrp' },
    'colorhalftoninginfo' => { 118 => 0x3f5 },
    'colorhue' => { 86 => 0x8d },
    'colormap' => { 29 => 0x140 },
    'colormatrix' => { 4 => 0xa, 93 => 0x200, 94 => 0x1011 },
    'colormatrix1' => { 29 => 0xc621 },
    'colormatrix2' => { 29 => 0xc622 },
    'colormode' => { 27 => 0x3015, 52 => 0x66, 79 => 0x28, 80 => 0x101, 86 => 0x3, 87 => 0x4, 94 => 0x101 },
    'colornoisereduction' => { 128 => 'ColorNoiseReduction' },
    'colorpalette' => { 43 => 0x55 },
    'colorprofile' => { 79 => 0x33 },
    'colorrepresentation' => { 43 => 0x3c },
    'colorresponseunit' => { 29 => 0x12c },
    'colors' => { 60 => 'colors' },
    'colorsamplersresource' => { 118 => 0x40e },
    'colorsequence' => { 29 => 0x84e1, 43 => 0x41 },
    'colorspace' => { 22 => 0x10b4, 29 => 0xa001, 60 => 'colorspace', 90 => 0x507, 108 => 'ColorSpace', 125 => 0xb, 128 => 'ColorSpace' },
    'colorspacedata' => { 36 => 0x10 },
    'colorspecification' => { 50 => 'colr' },
    'colortable' => { 29 => 0x84e6 },
    'colortemperature' => { 3 => 0x9, 4 => 0x9, 8 => 0xae, 22 => 0x10ae },
    'colortone' => { 2 => 0x2a },
    'colortransferfuncs' => { 118 => 0x3f8 },
    'colortype' => { 62 => 0x9, 69 => 0x8, 110 => 0x9 },
    'comment' => { 30 => 'Comment', 114 => 'Comment' },
    'componentbitdepth' => { 21 => 0x4 },
    'componentdefinition' => { 50 => 'cdef' },
    'componentmapping' => { 50 => 'cmap' },
    'componentsconfiguration' => { 29 => 0x9101, 128 => 'ComponentsConfiguration' },
    'componentversion' => { 22 => 0x80c },
    'compositinglayerheader' => { 50 => 'jplh' },
    'composition' => { 50 => 'comp' },
    'compositionmode' => { 75 => 0xd },
    'compositionoptions' => { 50 => 'copt' },
    'compressedbitsperpixel' => { 29 => 0x9102, 128 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 80 => 0x40, 94 => 0x40 },
    'compressedtext' => { 111 => 'zTXt' },
    'compression' => { 1 => 0x10, 29 => 0x103, 49 => 0xb, 60 => 'compression', 62 => 0xa, 69 => 0xa, 89 => 0x103, 110 => 0xa, 128 => 'Compression' },
    'compressionfactor' => { 90 => 0x50d },
    'compressionratio' => { 94 => 0x1034 },
    'concreteflag' => { 64 => 0x6, 65 => 0x3 },
    'conditionalfec' => { 28 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 45 => 0xa },
    'consecutivebadfaxlines' => { 29 => 0x148 },
    'contact' => { 40 => 0x76 },
    'contentlocationcode' => { 40 => 0x1a },
    'contentlocationname' => { 40 => 0x1b },
    'contiguouscodestream' => { 50 => 'jp2c' },
    'continuousdrive' => { 2 => 0x5 },
    'contrast' => { 2 => 0xd, 26 => 0xc, 27 => 0x20, 29 => [0xa408,0xfe54], 31 => 0x1004, 79 => 0x20, 94 => 0x1029, 115 => 0x2c, 116 => 0x20, 125 => 0xd, 128 => 'Contrast' },
    'contrastsetting' => { 90 => 0x505 },
    'contributor' => { 128 => 'Contributor' },
    'converter' => { 29 => 0xfe4d, 87 => 0xb },
    'copyright' => { 29 => 0x8298, 37 => 'cprt', 114 => 'Copyright', 128 => 'Copyright' },
    'copyrightflag' => { 118 => 0x40a },
    'copyrightnotice' => { 40 => 0x74 },
    'coringfilter' => { 94 => 0x102d },
    'country' => { 128 => 'Country' },
    'country-primarylocationcode' => { 40 => 0x64 },
    'country-primarylocationname' => { 40 => 0x65 },
    'countrycode' => { 128 => 'CountryCode' },
    'coverage' => { 128 => 'Coverage' },
    'crdinfo' => { 37 => 'crdi' },
    'createdate' => { 29 => 0x9004, 101 => 'CreationDate', 119 => 'CreationDate', 128 => 'CreateDate' },
    'creationdate' => { 128 => 'CreationDate' },
    'creationtime' => { 114 => 'Creation Time' },
    'creator' => { 101 => 'Creator', 119 => 'Creator', 128 => 'Creator' },
    'creatorcontactinfo' => { 128 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 128 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 128 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 128 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 128 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 128 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 128 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 128 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 128 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 128 => 'CreatorTool' },
    'credit' => { 40 => 0x6e, 128 => 'Credit' },
    'cross-reference' => { 50 => 'cref' },
    'customrendered' => { 29 => 0xa401, 128 => 'CustomRendered' },
    'customsaturation' => { 90 => 0x503 },
    'datacompressionmethod' => { 43 => 0x6e },
    'datadump' => { 86 => 0x10, 94 => 0xf00, 115 => 0x21, 116 => 0x3fe, 124 => 0xf00 },
    'datadump2' => { 94 => 0xf01 },
    'dataimprint' => { 79 => 0x34 },
    'datareference' => { 50 => 'dtbl' },
    'datatype' => { 29 => 0x80e4 },
    'date' => { 52 => 0x10, 55 => 0xc, 116 => 0x6, 128 => 'Date' },
    'datecreated' => { 40 => 0x37, 128 => 'DateCreated' },
    'datesent' => { 41 => 0x46 },
    'datetime' => { 128 => 'DateTime' },
    'datetimecreated' => { 28 => 'DateTimeCreated' },
    'datetimedigitized' => { 128 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 25 => 0x0, 28 => 'DateTimeOriginal', 29 => 0x9003, 128 => 'DateTimeOriginal' },
    'datetimestamp' => { 52 => 0x64 },
    'dealeridnumber' => { 29 => 0xc356 },
    'decode' => { 29 => 0x1b1 },
    'decodertable' => { 22 => 0x1835 },
    'decposition' => { 79 => 0x32 },
    'defaultcroporigin' => { 29 => 0xc61f },
    'defaultcropsize' => { 29 => 0xc620 },
    'defaultimagecolor' => { 29 => 0x1b2 },
    'defaultrgb' => { 97 => 'DefaultRGB' },
    'defaultscale' => { 29 => 0xc61e },
    'defineobject' => { 73 => 'DEFI' },
    'delay' => { 60 => 'delay', 78 => 0x2 },
    'deltapngheader' => { 73 => 'DHDR' },
    'deltatype' => { 63 => 0x4, 66 => 0x3, 68 => 0x0, 74 => 0x4 },
    'deltaxy' => { 64 => 0x8, 74 => 0x5 },
    'depth' => { 60 => 'depth' },
    'derivedfrom' => { 128 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 128 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 128 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 128 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 128 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 128 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 128 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 128 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 128 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 128 => 'DerivedFromVersionID' },
    'description' => { 114 => 'Description', 128 => 'Description' },
    'desiredreproductions' => { 50 => 'drep' },
    'destination' => { 41 => 0x5 },
    'destinationcity' => { 116 => 0x24 },
    'destinationcitycode' => { 116 => 0x1001 },
    'destinationdst' => { 116 => 0x26 },
    'destinationid' => { 75 => 0x0 },
    'deviceattributes' => { 36 => 0x38 },
    'devicemanufacturer' => { 36 => 0x30 },
    'devicemfgdesc' => { 37 => 'dmnd' },
    'devicemodel' => { 36 => 0x34 },
    'devicemodeldesc' => { 37 => 'dmdd' },
    'devicesettingdescription' => { 29 => 0xa40b, 128 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 128 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 128 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 128 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 37 => 'devs' },
    'digitalcreationdate' => { 40 => 0x3e },
    'digitalcreationtime' => { 40 => 0x3f },
    'digitaleffectsname' => { 53 => 0x1 },
    'digitaleffectstype' => { 53 => 0x2 },
    'digitaleffectsversion' => { 53 => 0x0 },
    'digitalsignature' => { 50 => 'chck' },
    'digitalzoom' => { 2 => 0xc, 26 => 0xa, 52 => 0x68, 57 => 0x22, 58 => 0x1e, 79 => 0xc, 86 => 0x86, 87 => 0xa, 94 => 0x204, 116 => 0x1e, 124 => 0x204 },
    'digitalzoomon' => { 124 => 0x21b },
    'digitalzoomratio' => { 29 => 0xa404, 128 => 'DigitalZoomRatio' },
    'directory' => { 30 => 'Directory' },
    'discardobjects' => { 73 => 'DISC' },
    'disclaimer' => { 114 => 'Disclaimer' },
    'displayinfo' => { 118 => 0x3ef },
    'displayresolution' => { 50 => 'resd' },
    'displayxresolution' => { 48 => 0x4 },
    'displayxresolutionunit' => { 48 => 0x9 },
    'displayyresolution' => { 48 => 0x0 },
    'displayyresolutionunit' => { 48 => 0x8 },
    'dispose' => { 60 => 'dispose' },
    'distance1' => { 52 => 0x28 },
    'distance2' => { 52 => 0x2c },
    'distance3' => { 52 => 0x30 },
    'distance4' => { 52 => 0x34 },
    'distortioncorrection' => { 90 => 0x50b },
    'dngbackwardversion' => { 29 => 0xc613 },
    'dngcameraserialnumber' => { 29 => 0xc62f },
    'dnglensinfo' => { 29 => 0xc630 },
    'dngprivatedata' => { 29 => 0xc634 },
    'dngversion' => { 29 => 0xc612 },
    'documenthistory' => { 40 => 0xe7 },
    'documentid' => { 128 => 'DocumentID' },
    'documentname' => { 29 => 0x10d },
    'documentnotes' => { 40 => 0xe6 },
    'dof' => { 28 => 'DOF' },
    'donotshow' => { 64 => 0x5, 65 => 0x2 },
    'dotrange' => { 29 => 0x150 },
    'drivemode' => { 28 => 'DriveMode', 79 => 0x6, 125 => 0x3 },
    'dropbykeyword' => { 73 => 'DBYK' },
    'dropchunks' => { 73 => 'DROP' },
    'duotonehalftoninginfo' => { 118 => 0x3f6 },
    'duotoneimageinfo' => { 118 => 0x3fa },
    'duotonetransferfuncs' => { 118 => 0x3f9 },
    'easymode' => { 2 => 0xb },
    'editorialupdate' => { 40 => 0x8 },
    'editstatus' => { 40 => 0x7 },
    'edittagarray' => { 29 => 0xc366 },
    'effectivebw' => { 118 => 0x3fb },
    'effectivemaxaperture' => { 85 => 0x12 },
    'effectsvisible' => { 118 => 0x412 },
    'encryption' => { 30 => 'Encryption' },
    'endpoints' => { 43 => 0x7d },
    'enhancement' => { 27 => 0x3016 },
    'envelopenumber' => { 29 => 0xc358, 41 => 0x28 },
    'envelopepriority' => { 41 => 0x3c },
    'enveloperecordversion' => { 41 => 0x0 },
    'epsonimageheight' => { 94 => 0x20c },
    'epsonimagewidth' => { 94 => 0x20b },
    'epsonsoftware' => { 94 => 0x20d },
    'epsoptions' => { 118 => 0x3fd },
    'equipment' => { 94 => 0x2010 },
    'equipmentversion' => { 91 => 0x0 },
    'error' => { 30 => 'Error' },
    'ettlii' => { 16 => 0xd },
    'excursiontolerance' => { 43 => 0x82 },
    'exif' => { 30 => 'EXIF' },
    'exif_profile' => { 60 => 'profile-exif', 114 => 'Raw profile type exif' },
    'exifcamerainfo' => { 40 => 0xe8 },
    'exifimageheight' => { 128 => 'PixelYDimension' },
    'exifimagelength' => { 29 => 0xa003 },
    'exifimagewidth' => { 29 => 0xa002, 128 => 'PixelXDimension' },
    'exifinformation' => { 22 => 0x300b },
    'exifoffset' => { 29 => 0x8769 },
    'exiftoolversion' => { 30 => 'ExifToolVersion' },
    'exifversion' => { 29 => 0x9000, 128 => 'ExifVersion' },
    'expirationdate' => { 40 => 0x25 },
    'expirationtime' => { 40 => 0x26 },
    'exportimage' => { 73 => 'eXPi' },
    'exposure' => { 29 => 0xfe51, 128 => 'Exposure' },
    'exposurebracketvalue' => { 86 => 0x19 },
    'exposurecompensation' => { 12 => 0x6, 18 => 0x0, 29 => 0x9204, 52 => 0x24, 79 => 0xd, 116 => 0x16, 125 => 0xc, 128 => 'ExposureBiasValue' },
    'exposuredifference' => { 86 => 0xe },
    'exposureindex' => { 29 => [0x9215,0xa215], 128 => 'ExposureIndex' },
    'exposureinfo' => { 22 => 0x1818 },
    'exposurelevelincrements' => { 14 => 0x6, 15 => 0x6, 16 => 0x5, 17 => 0x4 },
    'exposuremode' => { 29 => 0xa402, 79 => 0x1, 90 => 0x200, 125 => 0x8, 128 => 'ExposureMode' },
    'exposureprogram' => { 29 => 0x8822, 128 => 'ExposureProgram' },
    'exposuretime' => { 7 => 0x4, 12 => 0x16, 29 => 0x829a, 52 => 0x20, 55 => 0x38, 57 => 0x14, 58 => 0x10, 116 => 0x12, 128 => 'ExposureTime' },
    'exposurewarning' => { 31 => 0x1302 },
    'extender' => { 91 => 0x301 },
    'extenderfirmwareversion' => { 91 => 0x304 },
    'extenderserialnumber' => { 91 => 0x302 },
    'externalflash' => { 92 => 0x1201 },
    'extrasamples' => { 29 => 0x152 },
    'faxprofile' => { 29 => 0x192 },
    'faxrecvparams' => { 29 => 0x885c },
    'faxrecvtime' => { 29 => 0x885e },
    'faxsubaddress' => { 29 => 0x885d },
    'fileformat' => { 20 => 0x0, 41 => 0x14 },
    'filemodifydate' => { 30 => 'FileModifyDate' },
    'filename' => { 30 => 'FileName' },
    'filenumber' => { 5 => 0x1, 8 => 0x8, 22 => 0x1817 },
    'filenumbermemory' => { 79 => 0x1a },
    'filesize' => { 30 => 'FileSize' },
    'filesource' => { 29 => 0xa300, 128 => 'FileSource' },
    'filesystemversion' => { 86 => 0x1 },
    'filetype' => { 30 => 'FileType', 50 => 'ftyp' },
    'fileversion' => { 41 => 0x16 },
    'fillflashautoreduction' => { 14 => 0xe, 15 => 0xe, 17 => 0xa },
    'fillmethod' => { 76 => 0x2 },
    'fillorder' => { 29 => 0x10a },
    'filmcategory' => { 29 => 0xc35a },
    'filmgencode' => { 29 => 0xc35b },
    'filmproductcode' => { 29 => 0xc350 },
    'filmsize' => { 29 => 0xc35d },
    'filter' => { 27 => 0x3017, 62 => 0xb, 110 => 0xb },
    'finderdisplayduringexposure' => { 15 => 0x1 },
    'firmware' => { 125 => 0x17 },
    'firmwareversion' => { 94 => 0x207, 115 => 0x2 },
    'firmwareversion2' => { 91 => 0x100 },
    'firstobject' => { 63 => 0x0, 74 => 0x0, 77 => 0x0 },
    'firstobjectid' => { 72 => 0x0 },
    'fixtureidentifier' => { 40 => 0x16 },
    'flash' => { 29 => 0x9209, 58 => 0x22, 128 => 'Flash' },
    'flashactivity' => { 2 => 0x1c },
    'flashbias' => { 94 => 0x1023, 115 => 0x24 },
    'flashbits' => { 2 => 0x1d },
    'flashdevice' => { 94 => 0x1005 },
    'flashdistance' => { 27 => 0x2034 },
    'flashenergy' => { 29 => [0x920b,0xa20b], 128 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 86 => 0x18 },
    'flashexposurecomp' => { 12 => 0xf, 79 => 0x23, 86 => 0x12 },
    'flashexposurecompensation' => { 90 => 0x401 },
    'flashfired' => { 52 => 0x5d, 79 => 0x14, 128 => 'FlashFired' },
    'flashfiring' => { 16 => 0x6 },
    'flashfirmwareversion' => { 91 => 0x1004 },
    'flashfunction' => { 128 => 'FlashFunction' },
    'flashguidenumber' => { 19 => 0x0 },
    'flashinfo' => { 22 => 0x1813 },
    'flashintensity' => { 26 => 0x5 },
    'flashmode' => { 26 => 0x4, 52 => 0x5c, 57 => 0x27, 79 => 0x2, 86 => 0x87, 90 => 0x400, 94 => 0x1004, 116 => 0xc, 124 => 0x225, 128 => 'FlashMode' },
    'flashmodel' => { 91 => 0x1001 },
    'flashon' => { 28 => 'FlashOn' },
    'flashpixversion' => { 29 => 0xa000, 128 => 'FlashpixVersion' },
    'flashredeyemode' => { 128 => 'FlashRedEyeMode' },
    'flashreturn' => { 128 => 'FlashReturn' },
    'flashserialnumber' => { 91 => 0x1003 },
    'flashsetting' => { 86 => 0x8 },
    'flashstrength' => { 31 => 0x1011 },
    'flashsyncspeedav' => { 14 => 0x3, 16 => 0x2, 17 => 0x6 },
    'flashthreshold' => { 19 => 0x1 },
    'flashtype' => { 28 => 'FlashType', 86 => 0x9, 91 => 0x1000 },
    'flickerreduce' => { 124 => 0x218 },
    'fnumber' => { 12 => 0x15, 29 => 0x829d, 52 => 0x1e, 55 => 0x3c, 57 => 0x1c, 58 => 0x18, 116 => 0x13, 128 => 'FNumber' },
    'focallength' => { 6 => 0x1, 7 => 0xa, 27 => 0x1d, 29 => 0x920a, 79 => 0x12, 85 => 0xa, 116 => 0x1d, 128 => 'FocalLength' },
    'focallength35efl' => { 28 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 29 => 0xa405, 128 => 'FocalLengthIn35mmFilm' },
    'focalplanediagonal' => { 91 => 0x103, 94 => 0x205 },
    'focalplaneresolutionunit' => { 29 => [0x9210,0xa210], 128 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 29 => [0x920e,0xa20e], 128 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 6 => 0x2 },
    'focalplaneyresolution' => { 29 => [0x920f,0xa20f], 128 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 6 => 0x3 },
    'focaltype' => { 6 => 0x0, 7 => 0x2d },
    'focalunits' => { 2 => 0x19 },
    'focus' => { 87 => 0x8 },
    'focusarea' => { 79 => 0x31 },
    'focuscontinuous' => { 2 => 0x20 },
    'focusdistance' => { 79 => 0x13, 85 => 0x9, 92 => 0x305, 94 => 0x100c },
    'focusdistancelower' => { 12 => 0x14 },
    'focusdistanceupper' => { 12 => 0x13 },
    'focusinfo' => { 94 => 0x2050 },
    'focusinfoversion' => { 92 => 0x0 },
    'focusingscreen' => { 15 => 0x0 },
    'focusmode' => { 2 => 0x7, 26 => 0x3, 27 => [0x3003,0xd], 31 => 0x1021, 52 => 0x38, 79 => 0x30, 86 => 0x7, 90 => 0x301, 94 => 0x100b, 115 => 0x7, 116 => 0xd },
    'focusposition' => { 85 => 0x8, 116 => 0x10 },
    'focusprocess' => { 90 => 0x302 },
    'focussetting' => { 125 => 0x6 },
    'focustype' => { 2 => 0x12 },
    'focuswarning' => { 31 => 0x1301 },
    'foldername' => { 79 => 0x27 },
    'for' => { 119 => 'For' },
    'format' => { 128 => 'Format' },
    'fractalparameters' => { 111 => 'fRAc' },
    'fragmentlist' => { 50 => 'flst' },
    'fragmenttable' => { 50 => 'ftbl' },
    'frame' => { 73 => 'FRAM' },
    'framenumber' => { 29 => 0xc359, 116 => 0x29 },
    'framepriority' => { 73 => 'fPRI' },
    'free' => { 50 => 'free' },
    'freebytecounts' => { 29 => 0x121 },
    'freebytes' => { 22 => 0x1 },
    'freeoffsets' => { 29 => 0x120 },
    'fujiflashmode' => { 31 => 0x1010 },
    'gaincontrol' => { 29 => 0xa407, 128 => 'GainControl' },
    'gamma' => { 29 => 0xa500, 60 => 'gamma', 111 => 'gAMA' },
    'gammacompensatedvalue' => { 43 => 0x91 },
    'gamut' => { 37 => 'gamt' },
    'gdalmetadata' => { 29 => 0xa480 },
    'gdalnodata' => { 29 => 0xa481 },
    'geogangularunits' => { 33 => 0x806 },
    'geogangularunitsize' => { 33 => 0x807 },
    'geogazimuthunits' => { 33 => 0x80c },
    'geogcitation' => { 33 => 0x801 },
    'geogellipsoid' => { 33 => 0x808 },
    'geoggeodeticdatum' => { 33 => 0x802 },
    'geoginvflattening' => { 33 => 0x80b },
    'geoglinearunits' => { 33 => 0x804 },
    'geoglinearunitsize' => { 33 => 0x805 },
    'geogprimemeridian' => { 33 => 0x803 },
    'geogprimemeridianlong' => { 33 => 0x80d },
    'geographictype' => { 33 => 0x800 },
    'geogsemimajoraxis' => { 33 => 0x809 },
    'geogsemiminoraxis' => { 33 => 0x80a },
    'geotiffasciiparams' => { 29 => 0x87b1 },
    'geotiffdirectory' => { 29 => 0x87af },
    'geotiffdoubleparams' => { 29 => 0x87b0 },
    'geotiffversion' => { 33 => 0x1 },
    'gifapplicationextension' => { 111 => 'gIFx' },
    'gifgraphiccontrolextension' => { 111 => 'gIFg' },
    'gifplaintextextension' => { 111 => 'gIFt' },
    'globalaltitude' => { 118 => 0x419 },
    'globalangle' => { 118 => 0x40d },
    'globalparametersifd' => { 29 => 0x190 },
    'globalpixelsize' => { 73 => 'pHYg' },
    'gpsaltitude' => { 32 => 0x6, 128 => 'GPSAltitude' },
    'gpsaltituderef' => { 32 => 0x5, 128 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 32 => 0x1c, 128 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 32 => 0x1d },
    'gpsdatetime' => { 28 => 'GPSDateTime' },
    'gpsdestbearing' => { 32 => 0x18, 128 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 32 => 0x17, 128 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 32 => 0x1a, 128 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 32 => 0x19, 128 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 32 => 0x14, 128 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 32 => 0x13 },
    'gpsdestlongitude' => { 32 => 0x16, 128 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 32 => 0x15 },
    'gpsdifferential' => { 32 => 0x1e, 128 => 'GPSDifferential' },
    'gpsdop' => { 32 => 0xb },
    'gpsimgdirection' => { 32 => 0x11, 128 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 32 => 0x10, 128 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 29 => 0x8825 },
    'gpslatitude' => { 32 => 0x2, 128 => 'GPSLatitude' },
    'gpslatituderef' => { 32 => 0x1 },
    'gpslongitude' => { 32 => 0x4, 128 => 'GPSLongitude' },
    'gpslongituderef' => { 32 => 0x3 },
    'gpsmapdatum' => { 32 => 0x12, 128 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 32 => 0xa },
    'gpsprocessingmethod' => { 32 => 0x1b, 128 => 'GPSProcessingMethod' },
    'gpssatellites' => { 32 => 0x8, 128 => 'GPSSatellites' },
    'gpsspeed' => { 32 => 0xd, 128 => 'GPSSpeed' },
    'gpsspeedref' => { 32 => 0xc, 128 => 'GPSSpeedRef' },
    'gpsstatus' => { 32 => 0x9, 128 => 'GPSStatus' },
    'gpstimestamp' => { 32 => 0x7, 128 => 'GPSTimeStamp' },
    'gpstrack' => { 32 => 0xf, 128 => 'GPSTrack' },
    'gpstrackref' => { 32 => 0xe, 128 => 'GPSTrackRef' },
    'gpsversionid' => { 32 => 0x0, 128 => 'GPSVersionID' },
    'gradation' => { 90 => 0x50f },
    'graphicstechnologystandardoutput' => { 50 => 'gtso' },
    'grayresponsecurve' => { 29 => 0x123 },
    'grayresponseunit' => { 29 => 0x122 },
    'graytrc' => { 37 => 'kTRC' },
    'greengain' => { 123 => 'Gg' },
    'greenhue' => { 128 => 'GreenHue' },
    'greenmatrixcolumn' => { 37 => 'gXYZ' },
    'greenprimary' => { 60 => 'green-primary' },
    'greensample' => { 62 => 0x11 },
    'greensaturation' => { 128 => 'GreenSaturation' },
    'greentrc' => { 37 => 'gTRC' },
    'greenx' => { 113 => 0x4 },
    'greeny' => { 113 => 0x5 },
    'gridguidesinfo' => { 118 => 0x408 },
    'gtcitation' => { 33 => 0x402 },
    'gtmodeltype' => { 33 => 0x400 },
    'gtrastertype' => { 33 => 0x401 },
    'halftonehints' => { 29 => 0x141 },
    'hcusage' => { 29 => 0x84ee },
    'headline' => { 40 => 0x69, 128 => 'Headline' },
    'highlight' => { 125 => 0xf },
    'history' => { 128 => 'History' },
    'historyaction' => { 128 => 'HistoryAction' },
    'historyinstanceid' => { 128 => 'HistoryInstanceID' },
    'historyparameters' => { 128 => 'HistoryParameters' },
    'historysoftwareagent' => { 128 => 'HistorySoftwareAgent' },
    'historywhen' => { 128 => 'HistoryWhen' },
    'hometowncity' => { 116 => 0x23 },
    'hometowncitycode' => { 116 => 0x1000 },
    'hometowndst' => { 116 => 0x25 },
    'hostcomputer' => { 29 => 0x13c },
    'hueadjustment' => { 86 => 0x92 },
    'hyperfocaldistance' => { 28 => 'HyperfocalDistance' },
    'icc_profile' => { 29 => 0x8773, 60 => 'profile-icc', 111 => 'iCCP', 114 => 'Raw profile type icc', 118 => 0x40f, 119 => 'BeginICCProfile' },
    'icc_untagged' => { 118 => 0x411 },
    'iccbased' => { 98 => 'ICCBased' },
    'iccprofile' => { 43 => 0x42 },
    'id' => { 60 => 'id' },
    'identifier' => { 128 => 'Identifier' },
    'idsbasevalue' => { 118 => 0x414 },
    'ifd0_offset' => { 88 => 0x1 },
    'imageadjustment' => { 86 => 0x80, 87 => 0x5 },
    'imageboundary' => { 86 => 0x16 },
    'imagecolorindicator' => { 29 => 0x84e7 },
    'imagecolorvalue' => { 29 => 0x84e9 },
    'imagedepth' => { 29 => 0x80e5 },
    'imagedescription' => { 22 => 0x2804, 29 => 0x10e, 128 => 'ImageDescription' },
    'imageformat' => { 22 => 0x1803 },
    'imageheader' => { 50 => 'ihdr', 111 => 'IHDR' },
    'imageheight' => { 1 => 0x8, 21 => 0x1, 29 => 0x101, 30 => 'ImageHeight', 49 => 0x0, 60 => 'rows', 62 => 0x4, 69 => 0x4, 71 => 0x1, 110 => 0x4, 128 => 'ImageLength' },
    'imagehistory' => { 29 => [0x9213,0xa213] },
    'imageid' => { 29 => 0x800d },
    'imageinfo' => { 22 => 0x1810 },
    'imagelayer' => { 29 => 0x87ac },
    'imagelength' => { 1 => 0x14 },
    'imagenumber' => { 29 => [0x9211,0xa211] },
    'imageoffset' => { 111 => 'oFFs' },
    'imageoptimization' => { 86 => 0xa9 },
    'imageorientation' => { 40 => 0x83 },
    'imageprintstatus' => { 29 => 0xc46e },
    'imageprocessing' => { 94 => 0x2040 },
    'imageprocessingversion' => { 93 => 0x0 },
    'imageprops' => { 22 => 0x300a },
    'imagequality' => { 115 => 0x1 },
    'imagequality2' => { 90 => 0x603 },
    'imageresources' => { 107 => 'ImageResources' },
    'imagerotated' => { 57 => 0x2a },
    'imagerotationstatus' => { 29 => 0xc363 },
    'imagesize' => { 28 => 'ImageSize' },
    'imagesourcedata' => { 29 => 0x935c },
    'imagesourceek' => { 29 => 0xc351 },
    'imagestabilization' => { 80 => 0x18 },
    'imagestabilizer' => { 115 => 0x1a },
    'imagetype' => { 40 => 0x82, 66 => 0x2 },
    'imageuniqueid' => { 29 => 0xa420, 128 => 'ImageUniqueID' },
    'imagewidth' => { 1 => 0x4, 21 => 0x0, 29 => 0x100, 30 => 'ImageWidth', 49 => 0x4, 60 => 'columns', 62 => 0x0, 69 => 0x0, 71 => 0x0, 110 => 0x0, 128 => 'ImageWidth' },
    'indexed' => { 29 => 0x15a },
    'indexedcolourtablecount' => { 118 => 0x416 },
    'info' => { 103 => 'Info' },
    'inknames' => { 29 => 0x14d },
    'inkset' => { 29 => 0x14c },
    'instructions' => { 128 => 'Instructions' },
    'instructionset' => { 50 => 'inst' },
    'intellectualgenre' => { 128 => 'IntellectualGenre' },
    'intellectualproperty' => { 50 => 'jp2i' },
    'interchangecolorspace' => { 43 => 0x40 },
    'intergraphflagregisters' => { 29 => 0x847f },
    'intergraphmatrix' => { 29 => 0x8480 },
    'intergraphpacketdata' => { 29 => 0x8474 },
    'interlace' => { 29 => 0x8829, 62 => 0xc, 69 => 0xb, 110 => 0xc },
    'internalflash' => { 79 => 0x2b, 92 => 0x1208 },
    'internationaltext' => { 111 => 'iTXt' },
    'interopindex' => { 29 => 0x1 },
    'interopoffset' => { 29 => 0xa005 },
    'interopversion' => { 29 => 0x2 },
    'intervallength' => { 79 => 0x10 },
    'intervalmode' => { 79 => 0x26 },
    'intervalnumber' => { 79 => 0x11 },
    'iptc-naa' => { 29 => 0x83bb },
    'iptc-naa2' => { 29 => 0x8568 },
    'iptc_profile' => { 60 => 'profile-iptc', 114 => 'Raw profile type iptc' },
    'iptcapplication' => { 42 => 0x2 },
    'iptcbitspersample' => { 43 => 0x56 },
    'iptcdata' => { 118 => 0x404 },
    'iptcenvelope' => { 42 => 0x1 },
    'iptcimageheight' => { 43 => 0x1e },
    'iptcimagerotation' => { 43 => 0x66 },
    'iptcimagewidth' => { 43 => 0x14 },
    'iptcnewsphoto' => { 42 => 0x3 },
    'iptcobjectdata' => { 42 => 0x8 },
    'iptcpicturenumber' => { 43 => 0xa },
    'iptcpixelheight' => { 43 => 0x32 },
    'iptcpixelwidth' => { 43 => 0x28 },
    'iptcpostobjectdata' => { 42 => 0x9 },
    'iptcpreobjectdata' => { 42 => 0x7 },
    'iso' => { 12 => 0x2, 27 => 0x14, 29 => 0x8827, 52 => 0x60, 55 => 0x4e, 57 => 0x1e, 58 => 0x1a, 86 => 0x2, 116 => 0x14, 128 => 'ISOSpeedRatings' },
    'isoexpansion' => { 16 => 0x7 },
    'isoselection' => { 86 => 0xf },
    'isosetting' => { 52 => 0x5e, 58 => 0x14, 79 => 0x24, 86 => 0x13 },
    'isospeedexpansion' => { 15 => 0x3 },
    'it8header' => { 29 => 0x84e2 },
    'iterationcount' => { 70 => 0x1 },
    'iterationendaction' => { 78 => 0x1 },
    'iterationmax' => { 78 => 0x6 },
    'iterationminmax' => { 70 => 0x6 },
    'iterations' => { 60 => 'iterations' },
    'ixusafpoint' => { 12 => 0xe },
    'jngheader' => { 73 => 'JHDR' },
    'jobid' => { 40 => 0xb8 },
    'jobref' => { 128 => 'JobRef' },
    'jobrefid' => { 128 => 'JobRefId' },
    'jobrefname' => { 128 => 'JobRefName' },
    'jobrefurl' => { 128 => 'JobRefUrl' },
    'jp2header' => { 50 => 'jp2h' },
    'jp2signature' => { 50 => ["jP\x1a\x1a",'jP  '] },
    'jpeg_quality' => { 118 => 0x406 },
    'jpegactables' => { 29 => 0x209 },
    'jpegdctables' => { 29 => 0x208 },
    'jpeglosslesspredictors' => { 29 => 0x205 },
    'jpegpointtransforms' => { 29 => 0x206 },
    'jpegproc' => { 29 => 0x200 },
    'jpegqtables' => { 29 => 0x207 },
    'jpegrestartinterval' => { 29 => 0x203 },
    'jpegtables' => { 29 => 0x15b },
    'jpgfromraw' => { 22 => 0x2007, 28 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 29 => 0x202 },
    'jpgfromrawstart' => { 29 => 0x201 },
    'jumptoxpep' => { 118 => 0x41c },
    'keywords' => { 40 => 0x19, 101 => 'Keywords', 119 => 'Keywords', 128 => 'Keywords' },
    'kids' => { 105 => 'Kids' },
    'kodakbordersifd' => { 29 => 0xc36f },
    'kodakeffectsifd' => { 29 => 0xc36e },
    'kodakimageheight' => { 52 => 0xe, 54 => 0x70 },
    'kodakimagewidth' => { 52 => 0xc, 54 => 0x6c },
    'kodakmaker' => { 54 => 0x8 },
    'kodakmodel' => { 52 => 0x0, 54 => 0x28 },
    'label' => { 50 => 'lbl ', 60 => 'label' },
    'language' => { 128 => 'Language' },
    'languageidentifier' => { 40 => 0x87 },
    'lastfilenumber' => { 79 => 0x1b },
    'lastobject' => { 63 => 0x2, 74 => 0x2, 77 => 0x2 },
    'lastobjectid' => { 72 => 0x2 },
    'lasturl' => { 128 => 'LastURL' },
    'layersgroupinfo' => { 118 => 0x402 },
    'layerstateinfo' => { 118 => 0x400 },
    'lcdpanels' => { 15 => 0x8 },
    'leftmag' => { 72 => 0x9 },
    'lens' => { 28 => 'Lens', 29 => 0xfdea, 86 => 0x84, 125 => 0xa, 128 => 'Lens' },
    'lens35efl' => { 28 => 'Lens35efl' },
    'lensafstopbutton' => { 14 => 0x11, 15 => 0x13, 16 => 0x10, 17 => 0x9 },
    'lensdata0100' => { 86 => 0x98 },
    'lensdata0101' => { 86 => 0x98 },
    'lensdata0201' => { 86 => 0x98 },
    'lensdataunknown' => { 86 => 0x98 },
    'lensdataversion' => { 84 => 0x0, 85 => 0x0 },
    'lensfirmwareversion' => { 91 => 0x204 },
    'lensfstops' => { 84 => 0x7, 85 => 0xc, 86 => 0x8b },
    'lensid' => { 80 => 0x10c, 84 => 0x6, 85 => 0xb },
    'lensserialnumber' => { 91 => 0x202 },
    'lensspec' => { 28 => 'LensSpec' },
    'lenstype' => { 2 => 0x16, 7 => 0xd, 86 => 0x83, 91 => 0x201, 116 => 0x3f },
    'lightsource' => { 29 => 0x9208, 86 => 0x90, 128 => 'LightSource' },
    'lightsourcespecial' => { 124 => 0x21d },
    'linearizationtable' => { 29 => 0xc618 },
    'linearresponselimit' => { 29 => 0xc62e },
    'localcaption' => { 40 => 0x79 },
    'localdeltatype' => { 64 => 0x7 },
    'localizedcameramodel' => { 29 => 0xc615 },
    'location' => { 128 => 'Location' },
    'longexposurenoisereduction' => { 16 => 0x1, 17 => 0x1 },
    'longfocal' => { 2 => 0x17, 7 => 0x14 },
    'lookuptable' => { 43 => 0x50 },
    'loop' => { 73 => 'LOOP' },
    'luminance' => { 37 => 'lumi' },
    'luminancesmoothing' => { 128 => 'LuminanceSmoothing' },
    'macintoshprintinfo' => { 118 => 0x3e9 },
    'macro' => { 31 => 0x1020, 57 => 0x2b, 94 => 0x202, 124 => 0x202 },
    'macrofocus' => { 94 => 0x100e },
    'macromode' => { 2 => 0x1, 79 => 0xb, 90 => 0x300, 115 => 0x1c },
    'magnification' => { 29 => 0xc367 },
    'magnifyobject' => { 73 => 'MAGN' },
    'make' => { 23 => 0x0, 29 => 0x10f, 128 => 'Make' },
    'makeandmodel' => { 37 => 'mmod' },
    'makernote' => { 128 => 'MakerNote' },
    'makernotecanon' => { 29 => 0x927c },
    'makernotecasio' => { 29 => 0x927c },
    'makernotecasio2' => { 29 => 0x927c },
    'makernotefujifilm' => { 29 => 0x927c },
    'makernotekodak1a' => { 29 => 0x927c },
    'makernotekodak1b' => { 29 => 0x927c },
    'makernotekodak2' => { 29 => 0x927c },
    'makernotekodak3' => { 29 => 0x927c },
    'makernotekodak4' => { 29 => 0x927c },
    'makernotekodak5' => { 29 => 0x927c },
    'makernotekodak6a' => { 29 => 0x927c },
    'makernotekodak6b' => { 29 => 0x927c },
    'makernotekodakunknown' => { 29 => 0x927c },
    'makernotekyocera' => { 29 => 0x927c },
    'makernoteleica' => { 29 => 0x927c },
    'makernoteminolta' => { 29 => 0x927c },
    'makernotenikon' => { 29 => 0x927c },
    'makernotenikon2' => { 29 => 0x927c },
    'makernotenikon3' => { 29 => 0x927c },
    'makernoteoffset' => { 124 => 0xff },
    'makernoteolympus' => { 29 => 0x927c },
    'makernotepanasonic' => { 29 => 0x927c },
    'makernotepentax' => { 29 => 0x927c },
    'makernotericoh' => { 29 => 0x927c },
    'makernotericohtext' => { 29 => 0x927c },
    'makernotesafety' => { 29 => 0xc635 },
    'makernotesanyo' => { 29 => 0x927c },
    'makernotesigma' => { 29 => 0x927c },
    'makernotesony' => { 29 => 0x927c },
    'makernotetype' => { 121 => 0x1 },
    'makernoteunknown' => { 29 => 0x927c },
    'makernoteversion' => { 80 => 0x0, 94 => 0x0, 121 => 0x2 },
    'managedfrom' => { 128 => 'ManagedFrom' },
    'managedfromdocumentid' => { 128 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 128 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 128 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 128 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 128 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 128 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 128 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 128 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 128 => 'ManagedFromVersionID' },
    'manager' => { 128 => 'Manager' },
    'managervariant' => { 128 => 'ManagerVariant' },
    'manageto' => { 128 => 'ManageTo' },
    'manageui' => { 128 => 'ManageUI' },
    'mandatorybackground' => { 61 => 0x6 },
    'manualfocusdistance' => { 86 => 0x85, 124 => 0x223 },
    'manualtv' => { 15 => 0x5 },
    'marked' => { 128 => 'Marked' },
    'masterdocumentid' => { 40 => 0xb9 },
    'mattcolor' => { 60 => 'matt-color' },
    'matte' => { 60 => 'matte' },
    'matteing' => { 29 => 0x80e3 },
    'maxaperture' => { 2 => 0x1a, 79 => 0x17 },
    'maxapertureatmaxfocal' => { 84 => 0xb, 85 => 0x10, 91 => 0x206 },
    'maxapertureatminfocal' => { 84 => 0xa, 85 => 0xf },
    'maxaperturevalue' => { 29 => 0x9205, 128 => 'MaxApertureValue' },
    'maxfocallength' => { 84 => 0x9, 85 => 0xe, 91 => 0x208 },
    'maximumdensityrange' => { 43 => 0x8c },
    'maximumobjectsize' => { 46 => 0x5f },
    'maxsamplevalue' => { 29 => 0x119 },
    'maxsubfilesize' => { 46 => 0x14 },
    'mcuversion' => { 84 => 0xc, 85 => 0x11 },
    'measuredev' => { 22 => 0x1814 },
    'measuredinfo' => { 22 => 0x3003 },
    'measurement' => { 37 => 'meas' },
    'measurementbacking' => { 38 => 0xc },
    'measurementflare' => { 38 => 0x1c },
    'measurementgeometry' => { 38 => 0x18 },
    'measurementilluminant' => { 38 => 0x20 },
    'measurementobserver' => { 38 => 0x8 },
    'mediablackpoint' => { 37 => 'bkpt' },
    'mediadata' => { 50 => 'mdat' },
    'mediawhitepoint' => { 37 => 'wtpt' },
    'menubuttondisplayposition' => { 14 => 0xb, 16 => 0xa },
    'menubuttonreturn' => { 17 => 0xb },
    'metadata' => { 102 => 'Metadata', 109 => 'Metadata' },
    'metadatadate' => { 128 => 'MetadataDate' },
    'metadatanumber' => { 29 => 0xc365 },
    'meteringmode' => { 2 => 0x11, 29 => 0x9207, 52 => 0x1c, 79 => 0x7, 90 => 0x202, 116 => 0x17, 125 => 0x9, 128 => 'MeteringMode' },
    'mimetype' => { 30 => 'MimeType' },
    'minfocallength' => { 84 => 0x8, 85 => 0xd, 91 => 0x207 },
    'minoltaaperture' => { 79 => 0xa },
    'minoltacamerasettings' => { 80 => 0x3, 94 => 0x3 },
    'minoltacamerasettings2' => { 80 => 0xf00 },
    'minoltacamerasettingsold' => { 80 => 0x1, 94 => 0x1 },
    'minoltadate' => { 79 => 0x15 },
    'minoltaimagesize' => { 79 => 0x4, 80 => 0x103 },
    'minoltaiso' => { 79 => 0x8 },
    'minoltamodel' => { 79 => 0x25 },
    'minoltaquality' => { 79 => 0x5, 80 => [0x102,0x103], 94 => [0x102,0x103] },
    'minoltashutterspeed' => { 79 => 0x9 },
    'minoltatime' => { 79 => 0x16 },
    'minsamplevalue' => { 29 => 0x118 },
    'mirrorlockup' => { 14 => 0xc, 15 => 0xc, 16 => 0xb, 17 => 0x3 },
    'mngheader' => { 73 => 'MHDR' },
    'moddate' => { 128 => 'ModDate' },
    'model' => { 23 => 0x6, 29 => 0x110, 128 => 'Model' },
    'model2' => { 29 => 0x827d },
    'modelandversion' => { 29 => 0xc35c },
    'modeltiepoint' => { 29 => 0x8482 },
    'modeltransform' => { 29 => 0x85d8 },
    'modenumber' => { 29 => 0x195 },
    'modifiedsaturation' => { 90 => 0x504 },
    'modifydate' => { 29 => 0x132, 101 => 'ModDate', 111 => 'tIME', 119 => 'ModDate', 128 => 'ModifyDate' },
    'moirefilter' => { 29 => 0xfe58 },
    'montage' => { 60 => 'montage' },
    'moveobjects' => { 73 => 'MOVE' },
    'mpeg7binary' => { 50 => 'mp7b' },
    'namedcolor' => { 37 => 'ncol' },
    'namedcolor2' => { 37 => 'ncl2' },
    'nativedisplayinfo' => { 37 => 'ndin' },
    'nativeresolutionunit' => { 29 => 0xc37a },
    'nativexresolution' => { 29 => 0xc36c },
    'nativeyresolution' => { 29 => 0xc36d },
    'nefcurve1' => { 86 => 0x8c },
    'nefcurve2' => { 86 => 0x96 },
    'nefthumbnailsize' => { 86 => 0x99 },
    'nestlevel' => { 70 => 0x0 },
    'newbitdepth' => { 76 => 0x1 },
    'newcolortype' => { 76 => 0x0 },
    'newsphotoversion' => { 43 => 0x0 },
    'nickname' => { 128 => 'Nickname' },
    'nikoncaptureoffsets' => { 86 => 0xe0e },
    'nikonpreview' => { 86 => 0x11 },
    'noise' => { 29 => [0x920d,0xa20d] },
    'noisefilter2' => { 93 => 0x1010 },
    'noisereduction' => { 86 => 0x95, 90 => 0x50a, 115 => 0x2d },
    'nominalframecount' => { 71 => 0x4 },
    'nominallayercount' => { 71 => 0x3 },
    'nominalplaytime' => { 71 => 0x5 },
    'nullrecord' => { 22 => 0x0 },
    'numberlist' => { 50 => 'nlst' },
    'numberofcomponents' => { 49 => 0x8 },
    'numberofinks' => { 29 => 0x14e },
    'numcolors' => { 1 => 0x20 },
    'numimportantcolors' => { 1 => 0x24 },
    'numindexentries' => { 43 => 0x54 },
    'objectattributereference' => { 40 => 0x4 },
    'objectcycle' => { 40 => 0x4b },
    'objectdistance' => { 26 => 0x6, 27 => 0x2022 },
    'objectid' => { 65 => 0x0, 66 => 0x0 },
    'objectname' => { 40 => 0x5 },
    'objectpreviewdata' => { 40 => 0xca },
    'objectpreviewfileformat' => { 40 => 0xc8 },
    'objectpreviewfileversion' => { 40 => 0xc9 },
    'objectsizeannounced' => { 46 => 0x5a },
    'objecttypereference' => { 40 => 0x3 },
    'obsoletephotoshoptag1' => { 118 => 0x3fc },
    'obsoletephotoshoptag2' => { 118 => 0x3ff },
    'obsoletephotoshoptag3' => { 118 => 0x403 },
    'oceapplicationselector' => { 29 => 0xc428 },
    'oceidnumber' => { 29 => 0xc429 },
    'oceimagelogic' => { 29 => 0xc42a },
    'ocescanjobdesc' => { 29 => 0xc427 },
    'oecfcolumns' => { 128 => 'OECFColumns' },
    'oecfnames' => { 128 => 'OECFNames' },
    'oecfrows' => { 128 => 'OECFRows' },
    'oecfvalues' => { 128 => 'OECFValues' },
    'offsetorigin' => { 75 => 0xf },
    'offsetxy' => { 75 => 0x10 },
    'oldsubfiletype' => { 29 => 0xff },
    'olympusimageheight' => { 94 => 0x102f },
    'olympusimageheight2' => { 93 => 0x615 },
    'olympusimagewidth' => { 94 => 0x102e },
    'olympusimagewidth2' => { 93 => 0x614 },
    'onetouchwb' => { 94 => 0x302 },
    'opacity' => { 50 => 'opct' },
    'opiproxy' => { 29 => 0x15f },
    'opticalzoom' => { 57 => 0x20, 58 => 0x1c },
    'opticalzoomon' => { 124 => 0x219 },
    'opto-electricconvfactor' => { 29 => 0x8828, 128 => 'OECF' },
    'orderingrestrictions' => { 73 => 'ORDR' },
    'orientation' => { 29 => 0x112, 75 => 0xe, 128 => 'Orientation' },
    'originalfilename' => { 22 => 0x816, 56 => 0x20 },
    'originaltransmissionreference' => { 40 => 0x67 },
    'originatingprogram' => { 40 => 0x41 },
    'otherimagelength' => { 29 => 0x202 },
    'otherimagestart' => { 29 => 0x201 },
    'outputresponse' => { 37 => 'resp' },
    'owner' => { 128 => 'Owner' },
    'ownerid' => { 40 => 0xbc },
    'ownername' => { 8 => 0x9, 22 => 0x810, 29 => 0xfde8 },
    'packets' => { 60 => 'packets' },
    'page' => { 60 => 'page' },
    'pagecount' => { 105 => 'Count' },
    'pagename' => { 29 => 0x11d },
    'pagenumber' => { 29 => 0x129 },
    'pages' => { 109 => 'Pages' },
    'palette' => { 50 => 'pclr', 111 => 'PLTE' },
    'palettehistogram' => { 111 => 'hIST' },
    'panoramadirection' => { 9 => 0x5 },
    'panoramaframe' => { 9 => 0x2 },
    'panoramamode' => { 52 => 0x3c },
    'partialpalette' => { 73 => 'PPLT' },
    'pastclippingboundary' => { 75 => 0x19 },
    'pasteimage' => { 73 => 'PAST' },
    'pcscitation' => { 33 => 0xc01 },
    'pdfversion' => { 128 => 'PDFVersion' },
    'pentaximagesize' => { 116 => 0x9 },
    'pentaxmode' => { 116 => 0x1 },
    'photometricinterpretation' => { 29 => 0x106, 128 => 'PhotometricInterpretation' },
    'photoshop2colortable' => { 118 => 0x3eb },
    'photoshop2info' => { 118 => 0x3e8 },
    'photoshopdata' => { 119 => 'BeginPhotoshop' },
    'photoshopformat' => { 117 => 0x1 },
    'photoshopquality' => { 117 => 0x0 },
    'photoshopsettings' => { 29 => 0x8649 },
    'photoshopthumbnail' => { 118 => 0x40c },
    'physicalpixel' => { 111 => 'pHYs' },
    'pictinfo' => { 124 => 0x208 },
    'pictureinfo' => { 94 => 0x208 },
    'picturemode' => { 31 => 0x1031, 116 => 0xb },
    'pieceinfo' => { 102 => 'PieceInfo' },
    'pixelaspectratio' => { 21 => 0x2 },
    'pixelcalibration' => { 111 => 'pCAL' },
    'pixelintensityrange' => { 29 => 0x84eb },
    'pixelscale' => { 29 => 0x830e },
    'pixelspermeterx' => { 1 => 0x18 },
    'pixelspermetery' => { 1 => 0x1c },
    'pixelsperunitx' => { 112 => 0x0 },
    'pixelsperunity' => { 112 => 0x4 },
    'pixelunits' => { 112 => 0x8 },
    'planarconfiguration' => { 29 => 0x11c, 128 => 'PlanarConfiguration' },
    'planes' => { 1 => 0xc },
    'pngwarning' => { 114 => 'Warning' },
    'postscript2crd0' => { 37 => 'psd0' },
    'postscript2crd1' => { 37 => 'psd1' },
    'postscript2crd2' => { 37 => 'psd2' },
    'postscript2csa' => { 37 => 'ps2s' },
    'precaptureframes' => { 94 => 0x300 },
    'predictor' => { 29 => 0x13d },
    'preview0' => { 37 => 'pre0' },
    'preview1' => { 37 => 'pre1' },
    'preview2' => { 37 => 'pre2' },
    'previewfocalplanexresolution' => { 11 => 0x6 },
    'previewfocalplaneyresolution' => { 11 => 0x8 },
    'previewifd_offset' => { 88 => 0x2 },
    'previewimage' => { 27 => 0x2000, 28 => 'PreviewImage', 29 => 0x927c, 80 => 0x81 },
    'previewimagedata' => { 94 => 0x81 },
    'previewimageheight' => { 11 => 0x4 },
    'previewimageinfo' => { 8 => 0xb6 },
    'previewimagelength' => { 11 => 0x2, 27 => 0x3, 29 => [0x117,0x202], 80 => 0x89, 89 => 0x202, 90 => 0x102, 94 => [0x89,0x1037], 116 => 0x3 },
    'previewimagesize' => { 27 => 0x2, 28 => 'PreviewImageSize', 116 => 0x2 },
    'previewimagestart' => { 11 => 0x5, 27 => 0x4, 29 => [0x111,0x201], 80 => 0x88, 89 => 0x201, 90 => 0x101, 94 => [0x88,0x1036], 116 => 0x4 },
    'previewimagevalid' => { 90 => 0x100, 94 => 0x1035 },
    'previewimagewidth' => { 11 => 0x3 },
    'primarychromaticities' => { 29 => 0x13f, 111 => 'cHRM', 128 => 'PrimaryChromaticities' },
    'primaryplatform' => { 36 => 0x28 },
    'printflags' => { 118 => 0x3f3 },
    'printflagsinfo' => { 118 => 0x2710 },
    'printim' => { 27 => 0xe00, 29 => 0xc4a5, 80 => 0xe00, 86 => 0xe00, 94 => 0xe00, 115 => 0xe00, 116 => 0xe00, 121 => 0xe00, 124 => 0xe00, 126 => 0xe00, 127 => 0xe00 },
    'printquality' => { 29 => 0xc46c },
    'priority' => { 68 => 0x2 },
    'private' => { 96 => 'Private' },
    'processgeotiff' => { 28 => 'ProcessGeoTiff' },
    'producer' => { 101 => 'Producer', 128 => 'Producer' },
    'productid' => { 41 => 0x32 },
    'profile' => { 50 => 'prfl' },
    'profileclass' => { 36 => 0xc },
    'profilecmmtype' => { 36 => 0x4 },
    'profileconnectionspace' => { 36 => [0x14,0x44] },
    'profilecreator' => { 36 => 0x50 },
    'profiledatetime' => { 36 => 0x18 },
    'profiledescription' => { 37 => 'desc' },
    'profiledescriptionml' => { 37 => 'dscm' },
    'profilefilesignature' => { 36 => 0x24 },
    'profileheader' => { 37 => 'Header' },
    'profileid' => { 36 => 0x54 },
    'profilesequencedesc' => { 37 => 'pseq' },
    'profiletype' => { 29 => 0x191 },
    'profileversion' => { 36 => 0x8 },
    'programversion' => { 40 => 0x46 },
    'progressivescans' => { 117 => 0x2 },
    'projazimuthangle' => { 33 => 0xc16 },
    'projcentereasting' => { 33 => 0xc12 },
    'projcenterlat' => { 33 => 0xc11 },
    'projcenterlong' => { 33 => 0xc10 },
    'projcenternorthing' => { 33 => 0xc13 },
    'projcoordtrans' => { 33 => 0xc03 },
    'projectedcstype' => { 33 => 0xc00 },
    'projection' => { 33 => 0xc02 },
    'projfalseeasting' => { 33 => 0xc0a },
    'projfalsenorthing' => { 33 => 0xc0b },
    'projfalseorigineasting' => { 33 => 0xc0e },
    'projfalseoriginlat' => { 33 => 0xc0d },
    'projfalseoriginlong' => { 33 => 0xc0c },
    'projfalseoriginnorthing' => { 33 => 0xc0f },
    'projlinearunits' => { 33 => 0xc04 },
    'projlinearunitsize' => { 33 => 0xc05 },
    'projnatoriginlat' => { 33 => 0xc09 },
    'projnatoriginlong' => { 33 => 0xc08 },
    'projrectifiedgridangle' => { 33 => 0xc18 },
    'projscaleatcenter' => { 33 => 0xc15 },
    'projscaleatnatorigin' => { 33 => 0xc14 },
    'projstdparallel1' => { 33 => 0xc06 },
    'projstdparallel2' => { 33 => 0xc07 },
    'projstraightvertpolelong' => { 33 => 0xc17 },
    'promoteparent' => { 73 => 'PROM' },
    'province-state' => { 40 => 0x5f },
    'ps2crdvmsize' => { 37 => 'psvm' },
    'ps2renteringintent' => { 37 => 'ps2i' },
    'pstringcaption' => { 118 => 0x3f0 },
    'publisher' => { 128 => 'Publisher' },
    'quality' => { 2 => 0x3, 26 => 0x2, 27 => 0x3002, 31 => 0x1000, 52 => 0x9, 86 => 0x4, 87 => 0x3, 94 => 0x201, 116 => 0x8, 125 => 0x16 },
    'qualitymode' => { 27 => 0x8 },
    'quantizationmethod' => { 43 => 0x78 },
    'quickmaskinfo' => { 118 => 0x3fe },
    'quickshot' => { 124 => 0x213 },
    'rasterizedcaption' => { 40 => 0x7d },
    'rasterpadding' => { 29 => 0x84e3 },
    'rawandjpgrecording' => { 14 => 0x8 },
    'rawdata' => { 22 => 0x2005 },
    'rawdevcolorspace' => { 95 => 0x108 },
    'rawdevcontrastvalue' => { 95 => 0x106 },
    'rawdeveditstatus' => { 95 => 0x10b },
    'rawdevelopment' => { 94 => 0x2030 },
    'rawdevengine' => { 95 => 0x109 },
    'rawdevexposurebiasvalue' => { 95 => 0x100 },
    'rawdevgraypoint' => { 95 => 0x103 },
    'rawdevmemorycoloremphasis' => { 95 => 0x105 },
    'rawdevnoisereduction' => { 95 => 0x10a },
    'rawdevsaturationemphasis' => { 95 => 0x104 },
    'rawdevsettings' => { 95 => 0x10c },
    'rawdevsharpnessvalue' => { 95 => 0x107 },
    'rawdevversion' => { 95 => 0x0 },
    'rawdevwbfineadjustment' => { 95 => 0x102 },
    'rawdevwhitebalancevalue' => { 95 => 0x101 },
    'rawfile' => { 29 => 0xfe4c },
    'rawfilename' => { 128 => 'RawFileName' },
    'rawimagemode' => { 118 => 0x405 },
    'rawimagesize' => { 116 => 0x39 },
    'readerrequirements' => { 50 => 'rreq' },
    'recordid' => { 22 => 0x1804 },
    'recordingmode' => { 26 => 0x1 },
    'recordmode' => { 27 => 0x3000 },
    'recordshutterrelease' => { 124 => 0x217 },
    'redbalance' => { 81 => 0x0, 82 => 0x0, 83 => 0x0, 94 => 0x1017, 116 => 0x1c },
    'redbalanceauto' => { 13 => 0x0 },
    'redbalanceb&w' => { 13 => 0xe },
    'redbalancecloudy' => { 13 => 0x4 },
    'redbalancecustom' => { 13 => 0xc },
    'redbalancedaylight' => { 13 => 0x2 },
    'redbalanceflash' => { 13 => 0xa },
    'redbalancefluorescent' => { 13 => 0x8 },
    'redbalanceshade' => { 13 => 0x10 },
    'redbalancetungsten' => { 13 => 0x6 },
    'redbluebias' => { 93 => 0x100 },
    'redeyereduction' => { 28 => 'RedEyeReduction' },
    'redgain' => { 123 => 'Rg' },
    'redhue' => { 128 => 'RedHue' },
    'redmatrixcolumn' => { 37 => 'rXYZ' },
    'redprimary' => { 60 => 'red-primary' },
    'redsample' => { 62 => 0xd },
    'redsaturation' => { 128 => 'RedSaturation' },
    'redtrc' => { 37 => 'rTRC' },
    'reductionmatrix1' => { 29 => 0xc625 },
    'reductionmatrix2' => { 29 => 0xc626 },
    'redx' => { 113 => 0x2 },
    'redy' => { 113 => 0x3 },
    'referenceblackwhite' => { 29 => 0x214, 128 => 'ReferenceBlackWhite' },
    'referencedate' => { 40 => 0x2f },
    'referencenumber' => { 40 => 0x32 },
    'referenceservice' => { 40 => 0x2d },
    'relatedimagefileformat' => { 29 => 0x1000 },
    'relatedimagelength' => { 29 => 0x1002 },
    'relatedimagewidth' => { 29 => 0x1001 },
    'relatedsoundfile' => { 29 => 0xa004, 128 => 'RelatedSoundFile' },
    'relation' => { 128 => 'Relation' },
    'releasedate' => { 40 => 0x1e },
    'releasesetting' => { 22 => 0x1016 },
    'releasetime' => { 40 => 0x23 },
    'renderingintent' => { 36 => 0x40, 60 => 'rendering-intent' },
    'renditionclass' => { 128 => 'RenditionClass' },
    'renditionof' => { 128 => 'RenditionOf' },
    'renditionofdocumentid' => { 128 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 128 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 128 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 128 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 128 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 128 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 128 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 128 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 128 => 'RenditionOfVersionID' },
    'renditionparams' => { 128 => 'RenditionParams' },
    'resaved' => { 124 => 0x21e },
    'resolution' => { 50 => 'res ', 60 => 'resolution' },
    'resolutioninfo' => { 118 => 0x3ed },
    'resolutionmode' => { 125 => 0x4 },
    'resolutionunit' => { 29 => 0x128, 89 => 0x128, 128 => 'ResolutionUnit' },
    'resources' => { 102 => 'Resources' },
    'resourcesneeded' => { 73 => 'nEED' },
    'revision' => { 123 => ['Rev','Rv'] },
    'ricohdatetime1' => { 122 => 0x4 },
    'ricohdatetime2' => { 122 => 0x5 },
    'ricohrr1subdir' => { 121 => 0x2001 },
    'ricohsubdir' => { 121 => 0x2001 },
    'rightmag' => { 72 => 0xb },
    'rights' => { 128 => 'Rights' },
    'roidescription' => { 50 => 'roid' },
    'rollguidelements' => { 29 => 0xc364 },
    'romoperationmode' => { 22 => 0x80d },
    'root' => { 103 => 'Root' },
    'rotation' => { 21 => 0x3 },
    'rowsperstrip' => { 29 => 0x116 },
    'safetyshiftinavortv' => { 14 => 0x10, 15 => 0x10, 16 => 0xf },
    'sampleformat' => { 29 => 0x153 },
    'samplesperpixel' => { 29 => 0x115, 128 => 'SamplesPerPixel' },
    'samplestructure' => { 43 => 0x5a },
    'sanyoquality' => { 124 => 0x201 },
    'sanyothumbnail' => { 124 => 0x100 },
    'saturation' => { 2 => 0xe, 26 => 0xd, 27 => 0x1f, 29 => [0xa409,0xfe55], 31 => 0x1003, 79 => 0x1f, 86 => [0x94,0xaa], 116 => 0x1f, 125 => 0x10, 128 => 'Saturation' },
    'saveid' => { 128 => 'SaveID' },
    'saveobjects' => { 73 => 'SAVE' },
    'sba_rgbshifts' => { 29 => 0xc35e },
    'sbaexposurerecord' => { 29 => 0xc361 },
    'sbainputimagebitdepth' => { 29 => 0xc360 },
    'sbainputimagecolorspace' => { 29 => 0xc35f },
    'scalefactor35efl' => { 28 => 'ScaleFactor35efl' },
    'scanningdirection' => { 43 => 0x64 },
    'scene' => { 60 => 'scene', 128 => 'Scene' },
    'scenecapturetype' => { 29 => 0xa406, 128 => 'SceneCaptureType' },
    'scenemode' => { 86 => 0x8f, 90 => 0x509 },
    'sceneselect' => { 124 => 0x21f },
    'scenetype' => { 29 => 0xa301, 128 => 'SceneType' },
    'screening' => { 37 => 'scrn' },
    'screeningdesc' => { 37 => 'scrd' },
    'securityclassification' => { 29 => [0x9212,0xa212] },
    'seekpoint' => { 73 => 'SEEK' },
    'self-timer' => { 2 => 0x2 },
    'self-timer2' => { 12 => 0x1d },
    'selftimer' => { 27 => 0x3001, 124 => 0x214 },
    'selftimermode' => { 29 => 0x882b },
    'selftimertime' => { 22 => 0x1806 },
    'sensingmethod' => { 29 => [0x9217,0xa217], 128 => 'SensingMethod' },
    'sensorbottomborder' => { 24 => 0x8 },
    'sensorcleaning' => { 17 => 0xd },
    'sensorheight' => { 24 => 0x2 },
    'sensorinfo' => { 22 => 0x1031 },
    'sensorleftborder' => { 24 => 0x5 },
    'sensorpixelsize' => { 86 => 0x9a },
    'sensorrightborder' => { 24 => 0x7 },
    'sensortopborder' => { 24 => 0x6 },
    'sensorwidth' => { 24 => 0x1 },
    'sequence' => { 90 => 0x600 },
    'sequencenumber' => { 12 => 0x9, 52 => 0x1d },
    'sequenceshotinterval' => { 124 => 0x224 },
    'sequentialshot' => { 124 => 0x20e },
    'serialnumber' => { 8 => 0xc, 22 => 0x180b, 29 => [0xc354,0xfde9], 86 => [0xa0,0x1d], 91 => 0x101, 94 => 0x101a, 115 => 0x25, 125 => 0x2, 128 => 'SerialNumber' },
    'serviceidentifier' => { 41 => 0x1e },
    'setbuttonfunction' => { 14 => 0x1, 17 => 0xc },
    'setfunctionwhenshooting' => { 16 => 0x0 },
    'shadingcompensation' => { 90 => 0x50c },
    'shadingcompensation2' => { 93 => 0x1012 },
    'shadow' => { 125 => 0xe },
    'shadows' => { 29 => 0xfe52, 128 => 'Shadows' },
    'shadowscale' => { 29 => 0xc633 },
    'shadowtint' => { 128 => 'ShadowTint' },
    'sharpness' => { 2 => 0xf, 26 => 0xb, 27 => 0x21, 29 => [0xa40a,0xfe56], 31 => 0x1001, 52 => 0x6b, 55 => 0x37, 79 => 0x21, 86 => 0x6, 116 => 0x21, 125 => 0x11, 128 => 'Sharpness' },
    'sharpnessfactor' => { 94 => [0x100f,0x102a] },
    'sharpnesssetting' => { 90 => 0x506 },
    'shootingmode' => { 28 => 'ShootingMode', 86 => 0x89, 115 => 0x1f },
    'shootingrecord' => { 22 => 0x3002 },
    'shortdocumentid' => { 40 => 0xba },
    'shortfocal' => { 2 => 0x18, 7 => 0x12 },
    'showmode' => { 77 => 0x4 },
    'showobjects' => { 73 => 'SHOW' },
    'shutter-aelock' => { 14 => 0x4, 16 => 0x3, 17 => 0x2 },
    'shutteraelbutton' => { 15 => 0x4 },
    'shuttercount' => { 5 => 0x1, 86 => 0xa7 },
    'shuttercurtainhack' => { 28 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 14 => 0xf, 15 => 0xf, 16 => 0xe, 17 => 0x8 },
    'shuttermode' => { 52 => 0x1b },
    'shutterreleasemethod' => { 22 => 0x1010 },
    'shutterreleasenocfcard' => { 14 => 0x2, 15 => 0x2, 17 => 0xf },
    'shutterreleasetiming' => { 22 => 0x1011 },
    'shutterspeed' => { 28 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 29 => 0x9201, 128 => 'ShutterSpeedValue' },
    'signalnumber' => { 70 => 0xe },
    'signature' => { 60 => 'signature' },
    'significantbits' => { 111 => 'sBIT' },
    'similarityindex' => { 40 => 0xe4 },
    'simplicityprofile' => { 71 => 0x6 },
    'site' => { 29 => 0x84e0 },
    'sizemode' => { 46 => 0xa },
    'slices' => { 118 => 0x41a },
    'slowsync' => { 31 => 0x1030 },
    'smaxsamplevalue' => { 29 => 0x155 },
    'sminsamplevalue' => { 29 => 0x154 },
    'smoothingparameter1' => { 93 => 0x300 },
    'smoothingparameter2' => { 93 => 0x310 },
    'smoothingthreshold2' => { 93 => 0x610 },
    'smoothingthresholds' => { 93 => 0x600 },
    'smoothness' => { 29 => 0xfe57 },
    'snapshotid' => { 67 => 0x0 },
    'snapshotname' => { 67 => 0x2 },
    'software' => { 29 => 0x131, 114 => 'Software', 125 => 0x18, 128 => 'Software' },
    'softwareversion' => { 124 => 0x207 },
    'source' => { 40 => 0x73, 114 => 'Source', 128 => 'Source' },
    'sourceid' => { 64 => 0x0, 75 => 0xb },
    'sourceimagedirectory' => { 29 => 0xc418 },
    'sourceimagefilename' => { 29 => 0xc419 },
    'sourceimagevolumename' => { 29 => 0xc41a },
    'spatialfrequencyresponse' => { 29 => [0x920c,0xa20c], 128 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 128 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 128 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 128 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 128 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 40 => 0x28 },
    'specialmode' => { 94 => 0x200, 124 => 0x200 },
    'spectralsensitivity' => { 29 => 0x8824, 128 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 79 => 0x2d },
    'spotfocuspointy' => { 79 => 0x2e },
    'spothalftone' => { 118 => 0x413 },
    'spotmode' => { 115 => 0xf },
    'srgbrendering' => { 111 => 'sRGB' },
    'state' => { 128 => 'State' },
    'stonits' => { 29 => 0x923f },
    'stream' => { 99 => 'stream', 100 => 'stream' },
    'stripbytecounts' => { 29 => 0x117 },
    'stripoffsets' => { 29 => 0x111 },
    'striprowcounts' => { 29 => 0x22f },
    'sub-location' => { 40 => 0x5c },
    'subfile' => { 44 => 0xa },
    'subfiletype' => { 29 => 0xfe },
    'subifd' => { 29 => 0x14a },
    'subifd_offset' => { 88 => 0x3 },
    'subject' => { 101 => 'Subject', 119 => 'Subject', 128 => 'Subject' },
    'subjectarea' => { 128 => 'SubjectArea' },
    'subjectcode' => { 128 => 'SubjectCode' },
    'subjectdistance' => { 29 => 0x9206, 52 => 0x3e, 128 => 'SubjectDistance' },
    'subjectdistancerange' => { 29 => 0xa40c, 128 => 'SubjectDistanceRange' },
    'subjectlocation' => { 29 => [0x9214,0xa214], 128 => 'SubjectLocation' },
    'subjectprogram' => { 79 => 0x22 },
    'subjectreference' => { 40 => 0xc },
    'subsecdatetimeoriginal' => { 28 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 29 => 0x9290 },
    'subsectimedigitized' => { 29 => 0x9292 },
    'subsectimeoriginal' => { 29 => 0x9291 },
    'suggestedpalette' => { 111 => 'sPLT' },
    'superimposeddisplay' => { 14 => 0xa, 16 => 0x9, 17 => 0xe },
    'supplementalcategories' => { 40 => 0x14, 128 => 'SupplementalCategories' },
    'supplementaltype' => { 43 => 0x37 },
    'switchtoregisteredafpoint' => { 15 => 0x12 },
    't4options' => { 29 => 0x124 },
    't6options' => { 29 => 0x125 },
    'targetaperture' => { 12 => 0x4 },
    'targetcompressionratio' => { 20 => 0x1 },
    'targetdeltatype' => { 75 => 0x2 },
    'targetdistancesetting' => { 22 => 0x1807 },
    'targetexposuretime' => { 12 => 0x5 },
    'targetimagetype' => { 22 => 0x100a },
    'targetprinter' => { 29 => 0x151 },
    'targetxy' => { 75 => 0x3 },
    'technology' => { 37 => 'tech' },
    'terminationaction' => { 73 => 'TERM', 78 => 0x0 },
    'terminationcondition' => { 70 => 0x5 },
    'textualdata' => { 111 => 'tEXt' },
    'thresholding' => { 29 => 0x107 },
    'thumbnailfilename' => { 22 => 0x817 },
    'thumbnailimage' => { 22 => 0x2008, 28 => 'ThumbnailImage', 94 => 0x100 },
    'thumbnaillength' => { 29 => 0x202 },
    'thumbnailoffset' => { 29 => 0x201 },
    'thumbnailresource' => { 118 => 0x409 },
    'thumbnails' => { 128 => 'Thumbnails' },
    'thumbnailsformat' => { 128 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 128 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 128 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 128 => 'ThumbnailsWidth' },
    'tickspersecond' => { 71 => 0x2 },
    'tiff-epstandardid' => { 29 => [0x9216,0xa216] },
    'tiffthumbnail' => { 118 => 0x422 },
    'tilebytecounts' => { 29 => 0x145 },
    'tiledepth' => { 29 => 0x80e6 },
    'tilelength' => { 29 => 0x143 },
    'tileoffsets' => { 29 => 0x144 },
    'tilewidth' => { 29 => 0x142 },
    'time' => { 52 => 0x14, 55 => 0x10, 116 => 0x7 },
    'timecreated' => { 40 => 0x3c },
    'timesent' => { 41 => 0x50 },
    'timestamp' => { 22 => 0x180e },
    'timezone' => { 27 => 0x3006 },
    'timezonecode' => { 25 => 0x1 },
    'timezoneinfo' => { 25 => 0x2 },
    'timezoneoffset' => { 29 => 0x882a },
    'title' => { 101 => 'Title', 114 => 'Title', 119 => 'Title', 128 => 'Title' },
    'tonecomp' => { 86 => 0x81 },
    'tonecurve' => { 116 => 0x402 },
    'tonecurves' => { 116 => 0x403 },
    'topmag' => { 72 => 0xd },
    'totalzoom' => { 52 => 0x62 },
    'transferfunction' => { 29 => 0x12d, 128 => 'TransferFunction' },
    'transferrange' => { 29 => 0x156 },
    'transmissionreference' => { 128 => 'TransmissionReference' },
    'transparency' => { 111 => 'tRNS' },
    'transparencyindicator' => { 29 => 0x84ec },
    'transparentindex' => { 118 => 0x417 },
    'trapped' => { 101 => 'Trapped' },
    'tvvalue' => { 18 => 0x1 },
    'type' => { 128 => 'Type' },
    'ucrbg' => { 37 => 'bfd ' },
    'unicodealphanames' => { 118 => 0x415 },
    'uniquecameramodel' => { 29 => 0xc614 },
    'uniquedocumentid' => { 40 => 0xbb },
    'uniqueobjectname' => { 41 => 0x64 },
    'units' => { 60 => 'units' },
    'urgency' => { 40 => 0xa, 128 => 'Urgency' },
    'url' => { 50 => 'url ', 118 => 0x40b },
    'url_list' => { 118 => 0x41e },
    'usageterms' => { 128 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 29 => 0xc362 },
    'usercomment' => { 22 => 0x805, 29 => 0x9286, 128 => 'UserComment' },
    'userselectgrouptitle' => { 29 => 0xc355 },
    'usmlenselectronicmf' => { 15 => 0x7 },
    'uuid-geojp2' => { 50 => 'uuid' },
    'uuid-unknown' => { 50 => 'uuid' },
    'uuid-xmp' => { 50 => 'uuid' },
    'uuidinfo' => { 50 => 'uinf' },
    'uuidlist' => { 50 => 'ulst' },
    'validbits' => { 93 => 0x611, 94 => 0x102c },
    'variousmodes' => { 52 => 0x26 },
    'variousmodes2' => { 52 => 0x3a },
    'variprogram' => { 86 => 0xab },
    'version' => { 31 => 0x0, 128 => 'Version' },
    'versionid' => { 128 => 'VersionID' },
    'versioninfo' => { 118 => 0x421 },
    'versions' => { 128 => 'Versions' },
    'versionscomments' => { 128 => 'VersionsComments' },
    'versionsevent' => { 128 => 'VersionsEvent' },
    'versionseventaction' => { 128 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 128 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 128 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 128 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 128 => 'VersionsEventWhen' },
    'versionsmodifier' => { 128 => 'VersionsModifier' },
    'versionsmodifydate' => { 128 => 'VersionsModifyDate' },
    'versionsversion' => { 128 => 'VersionsVersion' },
    'versionyear' => { 29 => 0x194 },
    'verticalcitation' => { 33 => 0x1001 },
    'verticalcstype' => { 33 => 0x1000 },
    'verticaldatum' => { 33 => 0x1002 },
    'verticalunits' => { 33 => 0x1003 },
    'videocardgamma' => { 37 => 'vcgt' },
    'viewable' => { 62 => 0x1a },
    'viewingconddesc' => { 37 => 'vued' },
    'viewingcondilluminant' => { 39 => 0x8 },
    'viewingcondilluminanttype' => { 39 => 0x20 },
    'viewingconditions' => { 37 => 'view' },
    'viewingcondsurround' => { 39 => 0x14 },
    'vignetteamount' => { 128 => 'VignetteAmount' },
    'vignettemidpoint' => { 128 => 'VignetteMidpoint' },
    'voicememo' => { 124 => 0x216 },
    'wangannotation' => { 29 => 0x80a4 },
    'warning' => { 30 => 'Warning' },
    'watermark' => { 118 => 0x410 },
    'watermarktype' => { 51 => 0x8 },
    'webstatement' => { 128 => 'WebStatement' },
    'whitebalance' => { 12 => 0x7, 26 => 0x7, 27 => [0x19,0x2012], 29 => [0xa403,0xfe4e], 31 => 0x1002, 52 => 0x40, 57 => 0x1a, 79 => 0x3, 86 => 0x5, 87 => 0x7, 94 => 0x1015, 115 => 0x3, 116 => 0x19, 125 => 0x7, 128 => 'WhiteBalance' },
    'whitebalancebias' => { 27 => 0x2011, 115 => 0x23 },
    'whitebalancebracket' => { 90 => 0x502 },
    'whitebalancefinetune' => { 86 => 0xb },
    'whitebalancemode' => { 116 => 0x1a },
    'whitebalancetable' => { 8 => 0xa9, 22 => 0x10a9 },
    'whitebalancetemperature' => { 90 => 0x501 },
    'whitelevel' => { 29 => 0xc61d },
    'whitepoint' => { 29 => 0x13e, 60 => 'white-point', 116 => 0x201, 128 => 'WhitePoint' },
    'whitepointx' => { 113 => 0x0 },
    'whitepointy' => { 113 => 0x1 },
    'widefocuszone' => { 79 => 0x2f },
    'widerange' => { 124 => 0x20f },
    'workflowurl' => { 118 => 0x41b },
    'workingpath' => { 118 => 0x401 },
    'worldtimelocation' => { 116 => 0x22 },
    'writer-editor' => { 40 => 0x7a },
    'x3filllight' => { 125 => 0x12 },
    'xclippathunits' => { 29 => 0x158 },
    'xmag' => { 72 => 0x5 },
    'xmethod' => { 72 => 0x4 },
    'xml' => { 50 => 'xml ' },
    'xmldata' => { 118 => 0x3ea },
    'xmp' => { 30 => 'XMP', 104 => 'XML_stream', 111 => 'tXMP', 118 => 0x424, 119 => 'begin_xml_packet' },
    'xmp_profile' => { 60 => 'profile-xmp', 114 => 'Raw profile type xmp' },
    'xpauthor' => { 29 => 0x9c9d },
    'xpcomment' => { 29 => 0x9c9c },
    'xpkeywords' => { 29 => 0x9c9e },
    'xposition' => { 29 => 0x11e },
    'xpsubject' => { 29 => 0x9c9f },
    'xptitle' => { 29 => 0x9c9b },
    'xresolution' => { 29 => 0x11a, 89 => 0x11a, 128 => 'XResolution' },
    'xylocation' => { 65 => 0x4 },
    'ycbcrcoefficients' => { 29 => 0x211, 128 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 29 => 0x213, 89 => 0x213 },
    'ycbcrsubsampling' => { 29 => 0x212, 128 => 'YCbCrSubSampling' },
    'yclippathunits' => { 29 => 0x159 },
    'ymag' => { 72 => 0x7 },
    'ymethod' => { 72 => 0x11 },
    'yposition' => { 29 => 0x11f },
    'yresolution' => { 29 => 0x11b, 89 => 0x11b, 128 => 'YResolution' },
    'zoom' => { 94 => 0x100d },
    'zoomedresolution' => { 2 => 0x24 },
    'zoomedresolutionbase' => { 2 => 0x25 },
    'zoomposition' => { 92 => 0x300 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
