#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonCustom::FunctionsD30',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Type6',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalanceD100',
    'Image::ExifTool::Nikon::ColorBalanceD2H',
    'Image::ExifTool::Nikon::ColorBalanceD70',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::RawDevelopment',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::Text',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 34 => 0x2a },
    'addoriginaldecisiondata' => { 12 => 0x11 },
    'adjustmentmode' => { 78 => 0x15 },
    'advisory' => { 81 => 'Advisory' },
    'aebbracketvalue' => { 8 => 0x11 },
    'aebsequence' => { 10 => 0x9, 11 => 0x9, 12 => 0x8, 13 => 0x7 },
    'afareas' => { 63 => 0x304 },
    'afassist' => { 10 => 0x5, 13 => 0x5 },
    'afassistbeam' => { 12 => 0x4 },
    'afmode' => { 78 => 0x5 },
    'afpoint' => { 0 => 0x13, 59 => 0x88 },
    'afpointactivationarea' => { 11 => 0x11 },
    'afpointillumination' => { 11 => 0xa },
    'afpointregistration' => { 10 => 0x7 },
    'afpointselection' => { 11 => 0xb },
    'afpointselectionmethod' => { 12 => 0xc },
    'afpointspotmetering' => { 11 => 0xd },
    'afpointsused' => { 6 => 0x16 },
    'afsearch' => { 63 => 0x303 },
    'aiservotrackingsensitivity' => { 11 => 0x14 },
    'aliaslayermetadata' => { 24 => 0xc660 },
    'alphachannelsnames' => { 72 => 0x3ee },
    'analogbalance' => { 24 => 0xc627 },
    'analogzoom' => { 49 => 0x1e },
    'annotations' => { 24 => 0xc44f },
    'antialiasstrength' => { 24 => 0xc632 },
    'aperture' => { 82 => 'Aperture' },
    'aperturevalue' => { 24 => 0x9202, 81 => 'ApertureValue' },
    'applicationnotes' => { 24 => 0x2bc },
    'applicationrecordversion' => { 34 => 0x0 },
    'armidentifier' => { 35 => 0x78 },
    'armversion' => { 35 => 0x7a },
    'artist' => { 24 => 0x13b, 81 => 'Artist' },
    'asshotneutral' => { 24 => 0xc628 },
    'asshotwhitexy' => { 24 => 0xc629 },
    'assistbuttonfunction' => { 10 => 0xd },
    'association' => { 44 => 'asoc' },
    'atob0' => { 31 => 'A2B0' },
    'atob1' => { 31 => 'A2B1' },
    'atob2' => { 31 => 'A2B2' },
    'audio' => { 69 => 0x20 },
    'audioduration' => { 34 => 0x99 },
    'audiooutcue' => { 34 => 0x9a },
    'audiosamplingrate' => { 34 => 0x97 },
    'audiosamplingresolution' => { 34 => 0x98 },
    'audiotype' => { 34 => 0x96 },
    'author' => { 81 => 'Author' },
    'authorsposition' => { 81 => 'AuthorsPosition' },
    'autobracket' => { 78 => 0x19 },
    'autobracketing' => { 25 => 0x1100 },
    'autoexposurebracketing' => { 8 => 0x10 },
    'autofocus?' => { 65 => 0x209 },
    'autorotate' => { 8 => 0x1b },
    'auxiliarylens' => { 59 => 0x82 },
    'avvalue' => { 14 => 0x2 },
    'backgroundcolorindicator' => { 24 => 0x84e8 },
    'backgroundcolorvalue' => { 24 => 0x84ea },
    'badfaxlines' => { 24 => 0x146 },
    'baseiso' => { 18 => 0x101c },
    'baselineexposure' => { 24 => 0xc62a },
    'baselinenoise' => { 24 => 0xc62b },
    'baselinesharpness' => { 24 => 0xc62c },
    'baseurl' => { 81 => 'BaseURL' },
    'batterylevel' => { 24 => 0x828f },
    'bayergreensplit' => { 24 => 0xc62d },
    'bestqualityscale' => { 24 => 0xc65c },
    'bestshotmode' => { 23 => 0x3007 },
    'binaryfilter' => { 44 => 'bfil' },
    'bitspercomponent' => { 37 => 0x87, 43 => 0xa, 44 => 'bpcc' },
    'bitsperextendedrunlength' => { 24 => 0x84e5 },
    'bitsperrunlength' => { 24 => 0x84e4 },
    'bitspersample' => { 24 => 0x102, 81 => 'BitsPerSample' },
    'blacklevel' => { 24 => 0xc61a, 67 => 0x1012 },
    'blackleveldeltah' => { 24 => 0xc61b },
    'blackleveldeltav' => { 24 => 0xc61c },
    'blacklevelrepeatdim' => { 24 => 0xc619 },
    'blackpoint' => { 70 => 0x200 },
    'bluebalance' => { 56 => 0x1, 57 => 0x1, 58 => 0x1, 67 => 0x1018 },
    'bluebalanceauto' => { 9 => 0x1 },
    'bluebalanceb&w' => { 9 => 0xf },
    'bluebalancecloudy' => { 9 => 0x5 },
    'bluebalancecustom' => { 9 => 0xd },
    'bluebalancedaylight' => { 9 => 0x3 },
    'bluebalanceflash' => { 9 => 0xb },
    'bluebalancefluorescent' => { 9 => 0x9 },
    'bluebalanceshade' => { 9 => 0x11 },
    'bluebalancetungsten' => { 9 => 0x7 },
    'bluegain' => { 76 => 'Bg' },
    'bluehue' => { 81 => 'BlueHue' },
    'bluematrixcolumn' => { 31 => 'bXYZ' },
    'bluesaturation' => { 81 => 'BlueSaturation' },
    'bluetrc' => { 31 => 'bTRC' },
    'blurwarning' => { 25 => 0x1300 },
    'bodyfirmwareversion' => { 64 => 0x104 },
    'borderid' => { 45 => 0x2 },
    'borderlocation' => { 45 => 0x3 },
    'bordername' => { 45 => 0x1 },
    'bordersversion' => { 45 => 0x0 },
    'bordertype' => { 45 => 0x4 },
    'bracket' => { 67 => 0x1006 },
    'bracketstep' => { 54 => 0xe },
    'brightness' => { 24 => 0xfe53, 54 => 0x2c, 81 => 'Brightness' },
    'brightnessvalue' => { 24 => 0x9203, 81 => 'BrightnessValue' },
    'btoa0' => { 31 => 'B2A0' },
    'btoa1' => { 31 => 'B2A1' },
    'btoa2' => { 31 => 'B2A2' },
    'bulbduration' => { 8 => 0x18 },
    'burstmode' => { 46 => 0xa },
    'burstmode2?' => { 46 => 0x18 },
    'bwfilter' => { 54 => 0x2a },
    'bwmode' => { 67 => 0x203 },
    'by-line' => { 34 => 0x50 },
    'by-linetitle' => { 34 => 0x55 },
    'calibrationdatetime' => { 31 => 'calt' },
    'calibrationilluminant1' => { 24 => 0xc65a },
    'calibrationilluminant2' => { 24 => 0xc65b },
    'cameracalibration1' => { 24 => 0xc623 },
    'cameracalibration2' => { 24 => 0xc624 },
    'cameraid' => { 67 => 0x209, 77 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'cameraobject' => { 18 => 0x2807 },
    'cameraowner' => { 24 => 0xc353 },
    'camerasettings' => { 67 => 0x2020 },
    'camerasettingsversion' => { 63 => 0x0 },
    'cameraspecification' => { 18 => 0x3004 },
    'canoncamerasettings' => { 5 => 0x1, 18 => 0x102d },
    'canoncolorinfo' => { 5 => 0xa0 },
    'canoncolorinfo1' => { 18 => 0x32 },
    'canoncolorinfo2' => { 18 => 0x102c },
    'canoncolorinfod30' => { 5 => 0xa },
    'canoncustomfunctions10d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctions1d' => { 5 => 0x90 },
    'canoncustomfunctions20d' => { 5 => 0xf, 18 => 0x1033 },
    'canoncustomfunctionsd30' => { 5 => 0xf, 18 => 0x1033 },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 18 => 0x805 },
    'canonfileinfo' => { 5 => 0x93 },
    'canonfilelength' => { 5 => 0xe },
    'canonfirmwareversion' => { 5 => 0x7, 18 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonfocallength' => { 5 => 0x2, 18 => 0x1029 },
    'canonimageheight' => { 6 => 0x3 },
    'canonimageheightasshot' => { 6 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 5 => 0x6, 18 => 0x815 },
    'canonimagewidth' => { 6 => 0x2 },
    'canonimagewidthasshot' => { 6 => 0x4 },
    'canonpictureinfo' => { 5 => 0x12, 18 => 0x1038 },
    'canonrawmakemodel' => { 18 => 0x80a },
    'canonshotinfo' => { 5 => 0x4, 18 => 0x102a },
    'caption-abstract' => { 34 => 0x78 },
    'captionwriter' => { 81 => 'CaptionWriter' },
    'captureconditionspar' => { 24 => 0xc352 },
    'capturedevicefid' => { 24 => 0xc357 },
    'captureresolution' => { 44 => 'resc' },
    'capturexresolution' => { 41 => 0x4 },
    'capturexresolutionunit' => { 41 => 0x9 },
    'captureyresolution' => { 41 => 0x0 },
    'captureyresolutionunit' => { 41 => 0x8 },
    'casioimagesize' => { 23 => 0x9 },
    'category' => { 34 => 0xf, 81 => 'Category' },
    'ccdisosensitivity' => { 23 => 0x3014 },
    'ccdsensitivity' => { 22 => 0x14, 60 => 0x6 },
    'celllength' => { 24 => 0x109 },
    'cellwidth' => { 24 => 0x108 },
    'certificate' => { 81 => 'Certificate' },
    'cfalayout' => { 24 => 0xc617 },
    'cfapattern' => { 24 => 0xa302, 81 => 'CFAPattern' },
    'cfapattern2' => { 24 => 0x828e },
    'cfapatterncolumns' => { 81 => 'CFAPatternColumns' },
    'cfapatternrows' => { 81 => 'CFAPatternRows' },
    'cfapatternvalues' => { 81 => 'CFAPatternValues' },
    'cfaplanecolor' => { 24 => 0xc616 },
    'cfarepeatpatterndim' => { 24 => 0x828d },
    'chartarget' => { 31 => 'targ' },
    'chromablurradius' => { 24 => 0xc631 },
    'chromaticaberrationb' => { 81 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 81 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 31 => 'chad' },
    'chromaticity' => { 31 => 'chrm' },
    'chromaticitychannel1' => { 28 => 0xc },
    'chromaticitychannel2' => { 28 => 0x14 },
    'chromaticitychannel3' => { 28 => 0x1c },
    'chromaticitychannel4' => { 28 => 0x24 },
    'chromaticitychannels' => { 28 => 0x8 },
    'chromaticitycolorant' => { 28 => 0xa },
    'city' => { 34 => 0x5a, 81 => 'City' },
    'cleanfaxdata' => { 24 => 0x147 },
    'clippath' => { 24 => 0x157 },
    'cmmflags' => { 30 => 0x2c },
    'codedcharacterset' => { 35 => 0x5a },
    'codestreamheader' => { 44 => 'jpch' },
    'codestreamregistration' => { 44 => 'creg' },
    'codingmethods' => { 24 => 0x193 },
    'coloradjustment' => { 78 => 0x14 },
    'coloradjustmentmode' => { 77 => 0x210 },
    'colorant1coordinates' => { 29 => 0x2c },
    'colorant1name' => { 29 => 0xc },
    'colorant2coordinates' => { 29 => 0x52 },
    'colorant2name' => { 29 => 0x32 },
    'colorant3coordinates' => { 29 => 0x78 },
    'colorant3name' => { 29 => 0x58 },
    'colorantcount' => { 29 => 0x8 },
    'colorantorder' => { 31 => 'clro' },
    'coloranttable' => { 31 => 'clrt' },
    'colorbalance1' => { 59 => 0xc },
    'colorbalanceblue' => { 54 => 0x1e },
    'colorbalanced100' => { 59 => 0x97 },
    'colorbalanced2h' => { 59 => 0x97 },
    'colorbalanced70' => { 59 => 0x97 },
    'colorbalancegreen' => { 54 => 0x1d },
    'colorbalancered' => { 54 => 0x1c },
    'colorbalanceunknown' => { 59 => 0x97 },
    'colorbitdepth' => { 17 => 0x5 },
    'colorbw' => { 17 => 0x6 },
    'colorcalibrationmatrix' => { 37 => 0x46 },
    'colorcharacterization' => { 24 => 0x84ed },
    'colorcontrol' => { 67 => 0x102b },
    'coloreffect' => { 69 => 0x28 },
    'colorfilter' => { 54 => 0x29 },
    'colorgroup' => { 44 => 'cgrp' },
    'colorhue' => { 59 => 0x8d },
    'colormap' => { 24 => 0x140 },
    'colormatrix' => { 2 => 0xa, 66 => 0x200, 67 => 0x1011 },
    'colormatrix1' => { 24 => 0xc621 },
    'colormatrix2' => { 24 => 0xc622 },
    'colormode' => { 23 => 0x3015, 46 => 0x66, 54 => 0x28, 55 => 0x101, 59 => 0x3, 60 => 0x4, 67 => 0x101 },
    'colornoisereduction' => { 81 => 'ColorNoiseReduction' },
    'colorpalette' => { 37 => 0x55 },
    'colorrepresentation' => { 37 => 0x3c },
    'colorresponseunit' => { 24 => 0x12c },
    'colorsequence' => { 24 => 0x84e1, 37 => 0x41 },
    'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 63 => 0x507, 78 => 0xb, 81 => 'ColorSpace' },
    'colorspacedata' => { 30 => 0x10 },
    'colorspecification' => { 44 => 'colr' },
    'colortable' => { 24 => 0x84e6 },
    'colortemperature' => { 1 => 0x9, 2 => 0x9, 5 => 0xae, 18 => 0x10ae },
    'colortone' => { 0 => 0x2a },
    'comment' => { 83 => 'Comment' },
    'componentbitdepth' => { 17 => 0x4 },
    'componentdefinition' => { 44 => 'cdef' },
    'componentmapping' => { 44 => 'cmap' },
    'componentsconfiguration' => { 24 => 0x9101, 81 => 'ComponentsConfiguration' },
    'componentversion' => { 18 => 0x80c },
    'compositinglayerheader' => { 44 => 'jplh' },
    'composition' => { 44 => 'comp' },
    'compositionoptions' => { 44 => 'copt' },
    'compressedbitsperpixel' => { 24 => 0x9102, 81 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 55 => 0x40, 67 => 0x40 },
    'compression' => { 24 => 0x103, 43 => 0xb, 62 => 0x103, 81 => 'Compression' },
    'compressionfactor' => { 63 => 0x50d },
    'compressionratio' => { 67 => 0x1034 },
    'conditionalfec' => { 82 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 39 => 0xa },
    'consecutivebadfaxlines' => { 24 => 0x148 },
    'contact' => { 34 => 0x76 },
    'contentlocationcode' => { 34 => 0x1a },
    'contentlocationname' => { 34 => 0x1b },
    'contiguouscodestream' => { 44 => 'jp2c' },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 22 => 0xc, 23 => 0x20, 24 => [0xa408,0xfe54], 25 => 0x1004, 54 => 0x20, 67 => 0x1029, 69 => 0x2c, 70 => 0x20, 78 => 0xd, 81 => 'Contrast' },
    'contrastsetting' => { 63 => 0x505 },
    'contributor' => { 81 => 'Contributor' },
    'converter' => { 24 => 0xfe4d, 60 => 0xb },
    'copyright' => { 24 => 0x8298, 31 => 'cprt', 81 => 'Copyright' },
    'copyrightnotice' => { 34 => 0x74 },
    'coringfilter' => { 67 => 0x102d },
    'country' => { 81 => 'Country' },
    'country-primarylocationcode' => { 34 => 0x64 },
    'country-primarylocationname' => { 34 => 0x65 },
    'countrycode' => { 81 => 'CountryCode' },
    'coverage' => { 81 => 'Coverage' },
    'crdinfo' => { 31 => 'crdi' },
    'createdate' => { 24 => 0x9004, 81 => 'CreateDate' },
    'creationdate' => { 81 => 'CreationDate' },
    'creator' => { 81 => 'Creator' },
    'creatorcontactinfo' => { 81 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 81 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 81 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 81 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 81 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 81 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 81 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 81 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 81 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 81 => 'CreatorTool' },
    'credit' => { 34 => 0x6e, 81 => 'Credit' },
    'cross-reference' => { 44 => 'cref' },
    'customrendered' => { 24 => 0xa401, 81 => 'CustomRendered' },
    'customsaturation' => { 63 => 0x503 },
    'datacompressionmethod' => { 37 => 0x6e },
    'datadump' => { 59 => 0x10, 67 => 0xf00, 69 => 0x21, 77 => 0xf00 },
    'datadump2' => { 67 => 0xf01 },
    'datareference' => { 44 => 'dtbl' },
    'datatype' => { 24 => 0x80e4 },
    'date' => { 46 => 0x10, 49 => 0xc, 70 => 0x6, 81 => 'Date' },
    'datecreated' => { 34 => 0x37, 81 => 'DateCreated' },
    'datesent' => { 35 => 0x46 },
    'datetime' => { 81 => 'DateTime' },
    'datetimecreated' => { 82 => 'DateTimeCreated' },
    'datetimedigitized' => { 81 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 21 => 0x0, 24 => 0x9003, 81 => 'DateTimeOriginal', 82 => 'DateTimeOriginal' },
    'datetimestamp' => { 46 => 0x64 },
    'dealeridnumber' => { 24 => 0xc356 },
    'decode' => { 24 => 0x1b1 },
    'decodertable' => { 18 => 0x1835 },
    'decposition' => { 54 => 0x32 },
    'defaultcroporigin' => { 24 => 0xc61f },
    'defaultcropsize' => { 24 => 0xc620 },
    'defaultimagecolor' => { 24 => 0x1b2 },
    'defaultscale' => { 24 => 0xc61e },
    'derivedfrom' => { 81 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 81 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 81 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 81 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 81 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 81 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 81 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 81 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 81 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 81 => 'DerivedFromVersionID' },
    'description' => { 81 => 'Description' },
    'desiredreproductions' => { 44 => 'drep' },
    'destination' => { 35 => 0x5 },
    'deviceattributes' => { 30 => 0x38 },
    'devicemanufacturer' => { 30 => 0x30 },
    'devicemfgdesc' => { 31 => 'dmnd' },
    'devicemodel' => { 30 => 0x34 },
    'devicemodeldesc' => { 31 => 'dmdd' },
    'devicesettingdescription' => { 24 => 0xa40b, 81 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 81 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 81 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 81 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 31 => 'devs' },
    'digitalcreationdate' => { 34 => 0x3e },
    'digitalcreationtime' => { 34 => 0x3f },
    'digitaleffectsname' => { 47 => 0x1 },
    'digitaleffectstype' => { 47 => 0x2 },
    'digitaleffectsversion' => { 47 => 0x0 },
    'digitalsignature' => { 44 => 'chck' },
    'digitalzoom' => { 0 => 0xc, 22 => 0xa, 46 => 0x68, 51 => 0x22, 52 => 0x1e, 54 => 0xc, 59 => 0x86, 60 => 0xa, 67 => 0x204, 70 => 0x1e, 77 => 0x204 },
    'digitalzoomon' => { 77 => 0x21b },
    'digitalzoomratio' => { 24 => 0xa404, 81 => 'DigitalZoomRatio' },
    'directory' => { 83 => 'Directory' },
    'displayresolution' => { 44 => 'resd' },
    'displayxresolution' => { 42 => 0x4 },
    'displayxresolutionunit' => { 42 => 0x9 },
    'displayyresolution' => { 42 => 0x0 },
    'displayyresolutionunit' => { 42 => 0x8 },
    'distance1?' => { 46 => 0x28 },
    'distance2?' => { 46 => 0x2c },
    'distance3?' => { 46 => 0x30 },
    'distance4?' => { 46 => 0x34 },
    'distortioncorrection' => { 63 => 0x50b },
    'dngbackwardversion' => { 24 => 0xc613 },
    'dngcameraserialnumber' => { 24 => 0xc62f },
    'dnglensinfo' => { 24 => 0xc630 },
    'dngprivatedata' => { 24 => 0xc634 },
    'dngversion' => { 24 => 0xc612 },
    'documentid' => { 81 => 'DocumentID' },
    'documentname' => { 24 => 0x10d },
    'dotrange' => { 24 => 0x150 },
    'drivemode' => { 54 => 0x6, 78 => 0x3, 82 => 'DriveMode' },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 34 => 0x8 },
    'editstatus' => { 34 => 0x7 },
    'edittagarray' => { 24 => 0xc366 },
    'endpoints' => { 37 => 0x7d },
    'enhancement' => { 23 => 0x3016 },
    'envelopenumber' => { 24 => 0xc358, 35 => 0x28 },
    'envelopepriority' => { 35 => 0x3c },
    'enveloperecordversion' => { 35 => 0x0 },
    'epsonimageheight' => { 67 => 0x20c },
    'epsonimagewidth' => { 67 => 0x20b },
    'epsonsoftware' => { 67 => 0x20d },
    'equipment' => { 67 => 0x2010 },
    'equipmentversion' => { 64 => 0x0 },
    'error' => { 83 => 'Error' },
    'ettlii' => { 12 => 0xd },
    'excursiontolerance' => { 37 => 0x82 },
    'exifdata' => { 83 => 'ExifData' },
    'exifimageheight' => { 81 => 'PixelYDimension' },
    'exifimagelength' => { 24 => 0xa003 },
    'exifimagewidth' => { 24 => 0xa002, 81 => 'PixelXDimension' },
    'exifinformation' => { 18 => 0x300b },
    'exifoffset' => { 24 => 0x8769 },
    'exiftoolversion' => { 83 => 'ExifToolVersion' },
    'exifversion' => { 24 => 0x9000, 81 => 'ExifVersion' },
    'expirationdate' => { 34 => 0x25 },
    'expirationtime' => { 34 => 0x26 },
    'exposure' => { 24 => 0xfe51, 81 => 'Exposure' },
    'exposurebracketvalue' => { 59 => 0x19 },
    'exposurecompensation' => { 8 => 0x6, 14 => 0x0, 24 => 0x9204, 46 => 0x24, 54 => 0xd, 78 => 0xc, 81 => 'ExposureBiasValue' },
    'exposureindex' => { 24 => [0x9215,0xa215], 81 => 'ExposureIndex' },
    'exposureinfo' => { 18 => 0x1818 },
    'exposurelevelincrements' => { 10 => 0x6, 11 => 0x6, 12 => 0x5, 13 => 0x4 },
    'exposuremode' => { 24 => 0xa402, 54 => 0x1, 63 => 0x200, 78 => 0x8, 81 => 'ExposureMode' },
    'exposureprogram' => { 24 => 0x8822, 81 => 'ExposureProgram' },
    'exposuretime' => { 8 => 0x16, 24 => 0x829a, 46 => 0x20, 49 => 0x38, 51 => 0x14, 52 => 0x10, 81 => 'ExposureTime' },
    'exposurewarning' => { 25 => 0x1302 },
    'extender' => { 64 => 0x301 },
    'extenderfirmwareversion' => { 64 => 0x304 },
    'extenderserialnumber' => { 64 => 0x302 },
    'externalflash' => { 65 => 0x1201 },
    'extrasamples' => { 24 => 0x152 },
    'faxprofile' => { 24 => 0x192 },
    'faxrecvparams' => { 24 => 0x885c },
    'faxrecvtime' => { 24 => 0x885e },
    'faxsubaddress' => { 24 => 0x885d },
    'fileformat' => { 16 => 0x0, 35 => 0x14 },
    'filename' => { 83 => 'FileName' },
    'filenumber' => { 3 => 0x1, 5 => 0x8, 18 => 0x1817 },
    'filenumbermemory' => { 54 => 0x1a },
    'filesize' => { 83 => 'FileSize' },
    'filesource' => { 24 => 0xa300, 81 => 'FileSource' },
    'filesystemversion' => { 59 => 0x1 },
    'filetype' => { 44 => 'ftyp', 83 => 'FileType' },
    'fileversion' => { 35 => 0x16 },
    'fillflashautoreduction' => { 10 => 0xe, 11 => 0xe, 13 => 0xa },
    'fillorder' => { 24 => 0x10a },
    'filmcategory' => { 24 => 0xc35a },
    'filmgencode' => { 24 => 0xc35b },
    'filmproductcode' => { 24 => 0xc350 },
    'filmsize' => { 24 => 0xc35d },
    'filter' => { 23 => 0x3017 },
    'finderdisplayduringexposure' => { 11 => 0x1 },
    'firmware' => { 78 => 0x17 },
    'firmwareversion' => { 67 => 0x207, 69 => 0x2 },
    'firmwareversion2' => { 64 => 0x100 },
    'fixtureidentifier' => { 34 => 0x16 },
    'flash' => { 24 => 0x9209, 52 => 0x22, 81 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 67 => 0x1023, 69 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdevice' => { 67 => 0x1005 },
    'flashdistance' => { 23 => 0x2034 },
    'flashenergy' => { 24 => [0x920b,0xa20b], 81 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 59 => 0x18 },
    'flashexposurecomp' => { 8 => 0xf, 54 => 0x23, 59 => 0x12 },
    'flashexposurecompensation' => { 63 => 0x401 },
    'flashfired' => { 46 => 0x5d, 54 => 0x14, 81 => 'FlashFired' },
    'flashfiring' => { 12 => 0x6 },
    'flashfirmwareversion' => { 64 => 0x1004 },
    'flashfunction' => { 81 => 'FlashFunction' },
    'flashguidenumber' => { 15 => 0x0 },
    'flashinfo' => { 18 => 0x1813 },
    'flashintensity' => { 22 => 0x5 },
    'flashmode' => { 22 => 0x4, 46 => 0x5c, 51 => 0x27, 54 => 0x2, 59 => 0x87, 63 => 0x400, 67 => 0x1004, 77 => 0x225, 81 => 'FlashMode' },
    'flashmodel' => { 64 => 0x1001 },
    'flashon' => { 82 => 'FlashOn' },
    'flashpixversion' => { 24 => 0xa000, 81 => 'FlashpixVersion' },
    'flashredeyemode' => { 81 => 'FlashRedEyeMode' },
    'flashreturn' => { 81 => 'FlashReturn' },
    'flashserialnumber' => { 64 => 0x1003 },
    'flashsetting' => { 59 => 0x8 },
    'flashstrength' => { 25 => 0x1011 },
    'flashsyncspeedav' => { 10 => 0x3, 12 => 0x2, 13 => 0x6 },
    'flashthreshold' => { 15 => 0x1 },
    'flashtype' => { 59 => 0x9, 64 => 0x1000, 82 => 'FlashType' },
    'flickerreduce' => { 77 => 0x218 },
    'fnumber' => { 8 => 0x15, 24 => 0x829d, 46 => 0x1e, 49 => 0x3c, 51 => 0x1c, 52 => 0x18, 81 => 'FNumber' },
    'focallength' => { 4 => 0x1, 23 => 0x1d, 24 => 0x920a, 54 => 0x12, 70 => 0x1d, 81 => 'FocalLength' },
    'focallength35efl' => { 82 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 24 => 0xa405, 81 => 'FocalLengthIn35mmFilm' },
    'focalplanediagonal' => { 64 => 0x103, 67 => 0x205 },
    'focalplaneresolutionunit' => { 24 => [0x9210,0xa210], 81 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 24 => [0x920e,0xa20e], 81 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 4 => 0x2 },
    'focalplaneyresolution' => { 24 => [0x920f,0xa20f], 81 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 4 => 0x3 },
    'focalunits' => { 0 => 0x19 },
    'focus' => { 60 => 0x8 },
    'focusarea' => { 54 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 54 => 0x13, 65 => 0x305, 67 => 0x100c },
    'focusdistancelower' => { 8 => 0x14 },
    'focusdistanceupper' => { 8 => 0x13 },
    'focusinfo' => { 67 => 0x2050 },
    'focusinfoversion' => { 65 => 0x0 },
    'focusingscreen' => { 11 => 0x0 },
    'focusmode' => { 0 => 0x7, 22 => 0x3, 23 => [0x3003,0xd], 25 => 0x1021, 46 => 0x38, 54 => 0x30, 59 => 0x7, 63 => 0x301, 67 => 0x100b, 69 => 0x7, 70 => 0xd },
    'focusprocess' => { 63 => 0x302 },
    'focussetting' => { 78 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 25 => 0x1301 },
    'foldername' => { 54 => 0x27 },
    'format' => { 81 => 'Format' },
    'fragmentlist' => { 44 => 'flst' },
    'fragmenttable' => { 44 => 'ftbl' },
    'framenumber' => { 24 => 0xc359, 70 => 0x29 },
    'free' => { 44 => 'free' },
    'freebytecounts' => { 24 => 0x121 },
    'freebytes' => { 18 => 0x1 },
    'freeoffsets' => { 24 => 0x120 },
    'fujiflashmode' => { 25 => 0x1010 },
    'gaincontrol' => { 24 => 0xa407, 81 => 'GainControl' },
    'gammacompensatedvalue' => { 37 => 0x91 },
    'gamut' => { 31 => 'gamt' },
    'gdalmetadata' => { 24 => 0xa480 },
    'gdalnodata' => { 24 => 0xa481 },
    'geogangularunits' => { 27 => 0x806 },
    'geogangularunitsize' => { 27 => 0x807 },
    'geogazimuthunits' => { 27 => 0x80c },
    'geogcitation' => { 27 => 0x801 },
    'geogellipsoid' => { 27 => 0x808 },
    'geoggeodeticdatum' => { 27 => 0x802 },
    'geoginvflattening' => { 27 => 0x80b },
    'geoglinearunits' => { 27 => 0x804 },
    'geoglinearunitsize' => { 27 => 0x805 },
    'geogprimemeridian' => { 27 => 0x803 },
    'geogprimemeridianlong' => { 27 => 0x80d },
    'geographictype' => { 27 => 0x800 },
    'geogsemimajoraxis' => { 27 => 0x809 },
    'geogsemiminoraxis' => { 27 => 0x80a },
    'geotiffasciiparams' => { 24 => 0x87b1 },
    'geotiffdirectory' => { 24 => 0x87af },
    'geotiffdoubleparams' => { 24 => 0x87b0 },
    'geotiffversion' => { 27 => 0x1 },
    'globalparametersifd' => { 24 => 0x190 },
    'gpsaltitude' => { 26 => 0x6, 81 => 'GPSAltitude' },
    'gpsaltituderef' => { 26 => 0x5, 81 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 26 => 0x1c, 81 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 26 => 0x1d },
    'gpsdatetime' => { 82 => 'GPSDateTime' },
    'gpsdestbearing' => { 26 => 0x18, 81 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 26 => 0x17, 81 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 26 => 0x1a, 81 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 26 => 0x19, 81 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 26 => 0x14, 81 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 26 => 0x13 },
    'gpsdestlongitude' => { 26 => 0x16, 81 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 26 => 0x15 },
    'gpsdifferential' => { 26 => 0x1e, 81 => 'GPSDifferential' },
    'gpsdop' => { 26 => 0xb },
    'gpsimgdirection' => { 26 => 0x11, 81 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 26 => 0x10, 81 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 24 => 0x8825 },
    'gpslatitude' => { 26 => 0x2, 81 => 'GPSLatitude' },
    'gpslatituderef' => { 26 => 0x1 },
    'gpslongitude' => { 26 => 0x4, 81 => 'GPSLongitude' },
    'gpslongituderef' => { 26 => 0x3 },
    'gpsmapdatum' => { 26 => 0x12, 81 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 26 => 0xa },
    'gpsprocessingmethod' => { 26 => 0x1b, 81 => 'GPSProcessingMethod' },
    'gpssatellites' => { 26 => 0x8, 81 => 'GPSSatellites' },
    'gpsspeed' => { 26 => 0xd, 81 => 'GPSSpeed' },
    'gpsspeedref' => { 26 => 0xc, 81 => 'GPSSpeedRef' },
    'gpsstatus' => { 26 => 0x9, 81 => 'GPSStatus' },
    'gpstimestamp' => { 26 => 0x7, 81 => 'GPSTimeStamp' },
    'gpstrack' => { 26 => 0xf, 81 => 'GPSTrack' },
    'gpstrackref' => { 26 => 0xe, 81 => 'GPSTrackRef' },
    'gpsversionid' => { 26 => 0x0, 81 => 'GPSVersionID' },
    'gradation' => { 63 => 0x50f },
    'graphicstechnologystandardoutput' => { 44 => 'gtso' },
    'grayresponsecurve' => { 24 => 0x123 },
    'grayresponseunit' => { 24 => 0x122 },
    'graytrc' => { 31 => 'kTRC' },
    'greengain' => { 76 => 'Gg' },
    'greenhue' => { 81 => 'GreenHue' },
    'greenmatrixcolumn' => { 31 => 'gXYZ' },
    'greensaturation' => { 81 => 'GreenSaturation' },
    'greentrc' => { 31 => 'gTRC' },
    'gtcitation' => { 27 => 0x402 },
    'gtmodeltype' => { 27 => 0x400 },
    'gtrastertype' => { 27 => 0x401 },
    'halftonehints' => { 24 => 0x141 },
    'hcusage' => { 24 => 0x84ee },
    'headline' => { 34 => 0x69, 81 => 'Headline' },
    'highlight' => { 78 => 0xf },
    'history' => { 81 => 'History' },
    'historyaction' => { 81 => 'HistoryAction' },
    'historyinstanceid' => { 81 => 'HistoryInstanceID' },
    'historyparameters' => { 81 => 'HistoryParameters' },
    'historysoftwareagent' => { 81 => 'HistorySoftwareAgent' },
    'historywhen' => { 81 => 'HistoryWhen' },
    'hostcomputer' => { 24 => 0x13c },
    'hueadjustment' => { 59 => 0x92 },
    'icc_profile' => { 24 => 0x8773 },
    'iccprofile' => { 37 => 0x42 },
    'identifier' => { 81 => 'Identifier' },
    'ifd0_offset' => { 61 => 0x1 },
    'imageadjustment' => { 59 => 0x80, 60 => 0x5 },
    'imageboundary' => { 59 => 0x16 },
    'imagecolorindicator' => { 24 => 0x84e7 },
    'imagecolorvalue' => { 24 => 0x84e9 },
    'imagedepth' => { 24 => 0x80e5 },
    'imagedescription' => { 18 => 0x2804, 24 => 0x10e, 81 => 'ImageDescription' },
    'imageformat' => { 18 => 0x1803 },
    'imageheader' => { 44 => 'ihdr' },
    'imageheight' => { 17 => 0x1, 24 => 0x101, 43 => 0x0, 81 => 'ImageLength', 83 => 'ImageHeight' },
    'imagehistory' => { 24 => [0x9213,0xa213] },
    'imageid' => { 24 => 0x800d },
    'imageinfo' => { 18 => 0x1810 },
    'imagelayer' => { 24 => 0x87ac },
    'imagenumber' => { 24 => [0x9211,0xa211] },
    'imageoptimization' => { 59 => 0xa9 },
    'imageorientation' => { 34 => 0x83 },
    'imageprintstatus' => { 24 => 0xc46e },
    'imageprocessing' => { 67 => 0x2040 },
    'imageprocessingversion' => { 66 => 0x0 },
    'imageprops' => { 18 => 0x300a },
    'imagequality' => { 69 => 0x1 },
    'imagequality2' => { 63 => 0x603 },
    'imagerotated' => { 51 => 0x2a },
    'imagerotationstatus' => { 24 => 0xc363 },
    'imagesize' => { 82 => 'ImageSize' },
    'imagesourcedata' => { 24 => 0x935c },
    'imagesourceek' => { 24 => 0xc351 },
    'imagestabilization' => { 55 => 0x18 },
    'imagestabilizer' => { 69 => 0x1a },
    'imagetype' => { 34 => 0x82 },
    'imageuniqueid' => { 24 => 0xa420, 81 => 'ImageUniqueID' },
    'imagewidth' => { 17 => 0x0, 24 => 0x100, 43 => 0x4, 81 => 'ImageWidth', 83 => 'ImageWidth' },
    'indexed' => { 24 => 0x15a },
    'inknames' => { 24 => 0x14d },
    'inkset' => { 24 => 0x14c },
    'instructions' => { 81 => 'Instructions' },
    'instructionset' => { 44 => 'inst' },
    'intellectualgenre' => { 81 => 'IntellectualGenre' },
    'intellectualproperty' => { 44 => 'jp2i' },
    'interchangecolorspace' => { 37 => 0x40 },
    'intergraphflagregisters' => { 24 => 0x847f },
    'intergraphmatrix' => { 24 => 0x8480 },
    'intergraphpacketdata' => { 24 => 0x8474 },
    'interlace' => { 24 => 0x8829 },
    'internalflash' => { 54 => 0x2b, 65 => 0x1208 },
    'interopindex' => { 24 => 0x1 },
    'interopoffset' => { 24 => 0xa005 },
    'interopversion' => { 24 => 0x2 },
    'intervallength' => { 54 => 0x10 },
    'intervalmode' => { 54 => 0x26 },
    'intervalnumber' => { 54 => 0x11 },
    'iptc-naa' => { 24 => 0x83bb },
    'iptc-naa2' => { 24 => 0x8568 },
    'iptcapplication' => { 36 => 0x2 },
    'iptcbitspersample' => { 37 => 0x56 },
    'iptcdata' => { 72 => 0x404 },
    'iptcenvelope' => { 36 => 0x1 },
    'iptcimageheight' => { 37 => 0x1e },
    'iptcimagerotation' => { 37 => 0x66 },
    'iptcimagewidth' => { 37 => 0x14 },
    'iptcnewsphoto' => { 36 => 0x3 },
    'iptcobjectdata' => { 36 => 0x8 },
    'iptcpicturenumber' => { 37 => 0xa },
    'iptcpixelheight' => { 37 => 0x32 },
    'iptcpixelwidth' => { 37 => 0x28 },
    'iptcpostobjectdata' => { 36 => 0x9 },
    'iptcpreobjectdata' => { 36 => 0x7 },
    'iso' => { 8 => 0x2, 23 => 0x14, 24 => 0x8827, 46 => 0x60, 49 => 0x4e, 51 => 0x1e, 52 => 0x1a, 59 => 0x2, 70 => 0x14, 81 => 'ISOSpeedRatings' },
    'isoexpansion' => { 12 => 0x7 },
    'isoselection' => { 59 => 0xf },
    'isosetting' => { 46 => 0x5e, 54 => 0x24, 59 => 0x13 },
    'isosetting?' => { 52 => 0x14 },
    'isospeedexpansion' => { 11 => 0x3 },
    'it8header' => { 24 => 0x84e2 },
    'ixusafpoint' => { 8 => 0xe },
    'jobref' => { 81 => 'JobRef' },
    'jobrefid' => { 81 => 'JobRefId' },
    'jobrefname' => { 81 => 'JobRefName' },
    'jobrefurl' => { 81 => 'JobRefUrl' },
    'jp2header' => { 44 => 'jp2h' },
    'jp2signature' => { 44 => ['jP','jP  '] },
    'jpeg_quality' => { 72 => 0x406 },
    'jpegactables' => { 24 => 0x209 },
    'jpegdctables' => { 24 => 0x208 },
    'jpeglosslesspredictors' => { 24 => 0x205 },
    'jpegpointtransforms' => { 24 => 0x206 },
    'jpegproc' => { 24 => 0x200 },
    'jpegqtables' => { 24 => 0x207 },
    'jpegrestartinterval' => { 24 => 0x203 },
    'jpegtables' => { 24 => 0x15b },
    'jpgfromraw' => { 18 => 0x2007, 82 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 24 => 0x202 },
    'jpgfromrawstart' => { 24 => 0x201 },
    'keywords' => { 34 => 0x19, 81 => 'Keywords' },
    'kodakbordersifd' => { 24 => 0xc36f },
    'kodakeffectsifd' => { 24 => 0xc36e },
    'kodakimageheight' => { 46 => 0xe, 48 => 0x70 },
    'kodakimagewidth' => { 46 => 0xc, 48 => 0x6c },
    'kodakmaker' => { 48 => 0x8 },
    'kodakmodel' => { 46 => 0x0, 48 => 0x28 },
    'label' => { 44 => 'lbl ' },
    'language' => { 81 => 'Language' },
    'languageidentifier' => { 34 => 0x87 },
    'lastfilenumber' => { 54 => 0x1b },
    'lasturl' => { 81 => 'LastURL' },
    'lcdpanels' => { 11 => 0x8 },
    'lens' => { 24 => 0xfdea, 59 => 0x84, 64 => 0x201, 78 => 0xa, 81 => 'Lens', 82 => 'Lens' },
    'lens35efl' => { 82 => 'Lens35efl' },
    'lensafstopbutton' => { 10 => 0x11, 11 => 0x13, 12 => 0x10, 13 => 0x9 },
    'lensfirmwareversion' => { 64 => 0x204 },
    'lensfstops' => { 59 => 0x8b },
    'lensserialnumber' => { 64 => 0x202 },
    'lensspec' => { 82 => 'LensSpec' },
    'lenstype' => { 0 => 0x16, 59 => 0x83, 70 => 0x3f },
    'lightsource' => { 24 => 0x9208, 59 => 0x90, 81 => 'LightSource' },
    'lightsourcespecial' => { 77 => 0x21d },
    'linearizationtable' => { 24 => 0xc618 },
    'linearresponselimit' => { 24 => 0xc62e },
    'localizedcameramodel' => { 24 => 0xc615 },
    'location' => { 81 => 'Location' },
    'longexposurenoisereduction' => { 12 => 0x1, 13 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'lookuptable' => { 37 => 0x50 },
    'luminance' => { 31 => 'lumi' },
    'luminancesmoothing' => { 81 => 'LuminanceSmoothing' },
    'macro' => { 25 => 0x1020, 51 => 0x2b, 67 => 0x202, 77 => 0x202 },
    'macrofocus' => { 67 => 0x100e },
    'macromode' => { 0 => 0x1, 54 => 0xb, 63 => 0x300, 69 => 0x1c },
    'magnification' => { 24 => 0xc367 },
    'make' => { 19 => 0x0, 24 => 0x10f, 81 => 'Make' },
    'makeandmodel' => { 31 => 'mmod' },
    'makernote' => { 81 => 'MakerNote' },
    'makernotecanon' => { 24 => 0x927c },
    'makernotecasio' => { 24 => 0x927c },
    'makernotecasio2' => { 24 => 0x927c },
    'makernotecasioex-z3' => { 24 => 0x927c },
    'makernotefujifilm' => { 24 => 0x927c },
    'makernotekodak1a' => { 24 => 0x927c },
    'makernotekodak1b' => { 24 => 0x927c },
    'makernotekodak2' => { 24 => 0x927c },
    'makernotekodak3' => { 24 => 0x927c },
    'makernotekodak4' => { 24 => 0x927c },
    'makernotekodak5' => { 24 => 0x927c },
    'makernotekodak6a' => { 24 => 0x927c },
    'makernotekodak6b' => { 24 => 0x927c },
    'makernotekodakunknown' => { 24 => 0x927c },
    'makernoteleica' => { 24 => 0x927c },
    'makernoteminolta' => { 24 => 0x927c },
    'makernotenikon' => { 24 => 0x927c },
    'makernotenikon2' => { 24 => 0x927c },
    'makernotenikon3' => { 24 => 0x927c },
    'makernoteoffset' => { 77 => 0xff },
    'makernoteolympus' => { 24 => 0x927c },
    'makernotepanasonic' => { 24 => 0x927c },
    'makernotepentax' => { 24 => 0x927c },
    'makernotericoh' => { 24 => 0x927c },
    'makernotericohtext' => { 24 => 0x927c },
    'makernotesafety' => { 24 => 0xc635 },
    'makernotesanyo' => { 24 => 0x927c },
    'makernotesigma' => { 24 => 0x927c },
    'makernotesony' => { 24 => 0x927c },
    'makernotetype' => { 74 => 0x1 },
    'makernoteunknown' => { 24 => 0x927c },
    'makernoteversion' => { 55 => 0x0, 67 => 0x0, 74 => 0x2 },
    'managedfrom' => { 81 => 'ManagedFrom' },
    'managedfromdocumentid' => { 81 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 81 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 81 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 81 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 81 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 81 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 81 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 81 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 81 => 'ManagedFromVersionID' },
    'manager' => { 81 => 'Manager' },
    'managervariant' => { 81 => 'ManagerVariant' },
    'manageto' => { 81 => 'ManageTo' },
    'manageui' => { 81 => 'ManageUI' },
    'manualfocusdistance' => { 59 => 0x85, 77 => 0x223 },
    'manualtv' => { 11 => 0x5 },
    'marked' => { 81 => 'Marked' },
    'matteing' => { 24 => 0x80e3 },
    'maxaperture' => { 54 => 0x17 },
    'maxapertureatmaxfocal' => { 64 => 0x206 },
    'maxaperturevalue' => { 24 => 0x9205, 81 => 'MaxApertureValue' },
    'maxfocallength' => { 64 => 0x208 },
    'maximumdensityrange' => { 37 => 0x8c },
    'maximumobjectsize' => { 40 => 0x5f },
    'maxsamplevalue' => { 24 => 0x119 },
    'maxsubfilesize' => { 40 => 0x14 },
    'measuredev' => { 18 => 0x1814 },
    'measuredinfo' => { 18 => 0x3003 },
    'measurement' => { 31 => 'meas' },
    'measurementbacking' => { 32 => 0xc },
    'measurementflare' => { 32 => 0x1c },
    'measurementgeometry' => { 32 => 0x18 },
    'measurementilluminant' => { 32 => 0x20 },
    'measurementobserver' => { 32 => 0x8 },
    'mediablackpoint' => { 31 => 'bkpt' },
    'mediadata' => { 44 => 'mdat' },
    'mediawhitepoint' => { 31 => 'wtpt' },
    'menubuttondisplayposition' => { 10 => 0xb, 12 => 0xa },
    'menubuttonreturn' => { 13 => 0xb },
    'metadatadate' => { 81 => 'MetadataDate' },
    'metadatanumber' => { 24 => 0xc365 },
    'meteringmode' => { 0 => 0x11, 24 => 0x9207, 46 => 0x1c, 54 => 0x7, 63 => 0x202, 70 => 0x17, 78 => 0x9, 81 => 'MeteringMode' },
    'minfocallength' => { 64 => 0x207 },
    'minoltaaperture' => { 54 => 0xa },
    'minoltacamerasettings' => { 55 => 0x3, 67 => 0x3 },
    'minoltacamerasettings2' => { 55 => 0xf00 },
    'minoltacamerasettingsold' => { 55 => 0x1, 67 => 0x1 },
    'minoltadate' => { 54 => 0x15 },
    'minoltaimagesize' => { 54 => 0x4 },
    'minoltaiso' => { 54 => 0x8 },
    'minoltamodel' => { 54 => 0x25 },
    'minoltaquality' => { 54 => 0x5, 55 => [0x102,0x103], 67 => [0x102,0x103] },
    'minoltashutterspeed' => { 54 => 0x9 },
    'minoltatime' => { 54 => 0x16 },
    'minsamplevalue' => { 24 => 0x118 },
    'mirrorlockup' => { 10 => 0xc, 11 => 0xc, 12 => 0xb, 13 => 0x3 },
    'moddate' => { 81 => 'ModDate' },
    'model' => { 19 => 0x6, 24 => 0x110, 81 => 'Model' },
    'model2' => { 24 => 0x827d },
    'modelandversion' => { 24 => 0xc35c },
    'modeltiepoint' => { 24 => 0x8482 },
    'modeltransform' => { 24 => 0x85d8 },
    'modenumber' => { 24 => 0x195 },
    'modifiedsaturation' => { 63 => 0x504 },
    'modifydate' => { 24 => 0x132, 81 => 'ModifyDate' },
    'moirefilter' => { 24 => 0xfe58 },
    'mpeg7binary' => { 44 => 'mp7b' },
    'namedcolor' => { 31 => 'ncol' },
    'namedcolor2' => { 31 => 'ncl2' },
    'nativedisplayinfo' => { 31 => 'ndin' },
    'nativeresolutionunit' => { 24 => 0xc37a },
    'nativexresolution' => { 24 => 0xc36c },
    'nativeyresolution' => { 24 => 0xc36d },
    'nefcurve1' => { 59 => 0x8c },
    'nefcurve2' => { 59 => 0x96 },
    'nefthumbnailsize' => { 59 => 0x99 },
    'newsphotoversion' => { 37 => 0x0 },
    'nickname' => { 81 => 'Nickname' },
    'nikoncaptureoffsets' => { 59 => 0xe0e },
    'nikonpreview' => { 59 => 0x11 },
    'noise' => { 24 => [0x920d,0xa20d] },
    'noisefilter2' => { 66 => 0x1010 },
    'noisereduction' => { 59 => 0x95, 63 => 0x50a, 69 => 0x2d },
    'nullrecord' => { 18 => 0x0 },
    'numberlist' => { 44 => 'nlst' },
    'numberofcomponents' => { 43 => 0x8 },
    'numberofinks' => { 24 => 0x14e },
    'numindexentries' => { 37 => 0x54 },
    'objectattributereference' => { 34 => 0x4 },
    'objectcycle' => { 34 => 0x4b },
    'objectdistance' => { 22 => 0x6, 23 => 0x2022 },
    'objectname' => { 34 => 0x5 },
    'objectpreviewdata' => { 34 => 0xca },
    'objectpreviewfileformat' => { 34 => 0xc8 },
    'objectpreviewfileversion' => { 34 => 0xc9 },
    'objectsizeannounced' => { 40 => 0x5a },
    'objecttypereference' => { 34 => 0x3 },
    'oceapplicationselector' => { 24 => 0xc428 },
    'oceidnumber' => { 24 => 0xc429 },
    'oceimagelogic' => { 24 => 0xc42a },
    'ocescanjobdesc' => { 24 => 0xc427 },
    'oecfcolumns' => { 81 => 'OECFColumns' },
    'oecfnames' => { 81 => 'OECFNames' },
    'oecfrows' => { 81 => 'OECFRows' },
    'oecfvalues' => { 81 => 'OECFValues' },
    'oldsubfiletype' => { 24 => 0xff },
    'olympusimageheight' => { 67 => 0x102f },
    'olympusimageheight2' => { 66 => 0x615 },
    'olympusimagewidth' => { 67 => 0x102e },
    'olympusimagewidth2' => { 66 => 0x614 },
    'onetouchwb' => { 67 => 0x302 },
    'opacity' => { 44 => 'opct' },
    'opiproxy' => { 24 => 0x15f },
    'opticalzoom' => { 51 => 0x20, 52 => 0x1c },
    'opticalzoomon' => { 77 => 0x219 },
    'opto-electricconvfactor' => { 24 => 0x8828, 81 => 'OECF' },
    'orientation' => { 24 => 0x112, 81 => 'Orientation' },
    'originalfilename' => { 18 => 0x816, 50 => 0x20 },
    'originaltransmissionreference' => { 34 => 0x67 },
    'originatingprogram' => { 34 => 0x41 },
    'otherimagelength' => { 24 => 0x202 },
    'otherimagestart' => { 24 => 0x201 },
    'outputresponse' => { 31 => 'resp' },
    'owner' => { 81 => 'Owner' },
    'ownername' => { 5 => 0x9, 18 => 0x810, 24 => 0xfde8 },
    'pagename' => { 24 => 0x11d },
    'pagenumber' => { 24 => 0x129 },
    'palette' => { 44 => 'pclr' },
    'panoramamode?' => { 46 => 0x3c },
    'pcscitation' => { 27 => 0xc01 },
    'pdfversion' => { 81 => 'PDFVersion' },
    'pentaximagesize' => { 70 => 0x9 },
    'pentaxmode' => { 70 => 0x1 },
    'photometricinterpretation' => { 24 => 0x106, 81 => 'PhotometricInterpretation' },
    'photoshopformat' => { 71 => 0x1 },
    'photoshopquality' => { 71 => 0x0 },
    'photoshopsettings' => { 24 => 0x8649 },
    'photoshopthumbnail' => { 72 => 0x40c },
    'pictinfo' => { 77 => 0x208 },
    'pictureinfo' => { 67 => 0x208 },
    'picturemode' => { 25 => 0x1031, 70 => 0xb },
    'pixelaspectratio' => { 17 => 0x2 },
    'pixelintensityrange' => { 24 => 0x84eb },
    'pixelscale' => { 24 => 0x830e },
    'planarconfiguration' => { 24 => 0x11c, 81 => 'PlanarConfiguration' },
    'postscript2crd0' => { 31 => 'psd0' },
    'postscript2crd1' => { 31 => 'psd1' },
    'postscript2crd2' => { 31 => 'psd2' },
    'postscript2csa' => { 31 => 'ps2s' },
    'precaptureframes' => { 67 => 0x300 },
    'predictor' => { 24 => 0x13d },
    'preview0' => { 31 => 'pre0' },
    'preview1' => { 31 => 'pre1' },
    'preview2' => { 31 => 'pre2' },
    'previewfocalplanexresolution' => { 7 => 0x6 },
    'previewfocalplaneyresolution' => { 7 => 0x8 },
    'previewifd_offset' => { 61 => 0x2 },
    'previewimage' => { 23 => 0x2000, 82 => 'PreviewImage' },
    'previewimagedata' => { 55 => 0x81, 67 => 0x81 },
    'previewimageheight' => { 7 => 0x4 },
    'previewimageinfo' => { 5 => 0xb6 },
    'previewimagelength' => { 7 => 0x2, 23 => 0x3, 24 => [0x117,0x202], 55 => 0x89, 62 => 0x202, 63 => 0x102, 67 => [0x89,0x1037], 70 => 0x3 },
    'previewimagesize' => { 23 => 0x2, 70 => 0x2, 82 => 'PreviewImageSize' },
    'previewimagestart' => { 7 => 0x5, 23 => 0x4, 24 => [0x111,0x201], 55 => 0x88, 62 => 0x201, 63 => 0x101, 67 => [0x88,0x1036], 70 => 0x4 },
    'previewimagevalid' => { 63 => 0x100, 67 => 0x1035 },
    'previewimagewidth' => { 7 => 0x3 },
    'primarychromaticities' => { 24 => 0x13f, 81 => 'PrimaryChromaticities' },
    'primaryplatform' => { 30 => 0x28 },
    'printim' => { 23 => 0xe00, 24 => 0xc4a5, 55 => 0xe00, 59 => 0xe00, 67 => 0xe00, 69 => 0xe00, 70 => 0xe00, 74 => 0xe00, 77 => 0xe00, 79 => 0xe00, 80 => 0xe00 },
    'printquality' => { 24 => 0xc46c },
    'processgeotiff' => { 82 => 'ProcessGeoTiff' },
    'producer' => { 81 => 'Producer' },
    'productid' => { 35 => 0x32 },
    'profile' => { 44 => 'prfl' },
    'profileclass' => { 30 => 0xc },
    'profilecmmtype' => { 30 => 0x4 },
    'profileconnectionspace' => { 30 => [0x14,0x44] },
    'profilecreator' => { 30 => 0x50 },
    'profiledatetime' => { 30 => 0x18 },
    'profiledescription' => { 31 => 'desc' },
    'profiledescriptionml' => { 31 => 'dscm' },
    'profilefilesignature' => { 30 => 0x24 },
    'profileheader' => { 31 => 'Header' },
    'profileid' => { 30 => 0x54 },
    'profilesequencedesc' => { 31 => 'pseq' },
    'profiletype' => { 24 => 0x191 },
    'profileversion' => { 30 => 0x8 },
    'programversion' => { 34 => 0x46 },
    'progressivescans' => { 71 => 0x2 },
    'projazimuthangle' => { 27 => 0xc16 },
    'projcentereasting' => { 27 => 0xc12 },
    'projcenterlat' => { 27 => 0xc11 },
    'projcenterlong' => { 27 => 0xc10 },
    'projcenternorthing' => { 27 => 0xc13 },
    'projcoordtrans' => { 27 => 0xc03 },
    'projectedcstype' => { 27 => 0xc00 },
    'projection' => { 27 => 0xc02 },
    'projfalseeasting' => { 27 => 0xc0a },
    'projfalsenorthing' => { 27 => 0xc0b },
    'projfalseorigineasting' => { 27 => 0xc0e },
    'projfalseoriginlat' => { 27 => 0xc0d },
    'projfalseoriginlong' => { 27 => 0xc0c },
    'projfalseoriginnorthing' => { 27 => 0xc0f },
    'projlinearunits' => { 27 => 0xc04 },
    'projlinearunitsize' => { 27 => 0xc05 },
    'projnatoriginlat' => { 27 => 0xc09 },
    'projnatoriginlong' => { 27 => 0xc08 },
    'projrectifiedgridangle' => { 27 => 0xc18 },
    'projscaleatcenter' => { 27 => 0xc15 },
    'projscaleatnatorigin' => { 27 => 0xc14 },
    'projstdparallel1' => { 27 => 0xc06 },
    'projstdparallel2' => { 27 => 0xc07 },
    'projstraightvertpolelong' => { 27 => 0xc17 },
    'province-state' => { 34 => 0x5f },
    'ps2crdvmsize' => { 31 => 'psvm' },
    'ps2renteringintent' => { 31 => 'ps2i' },
    'publisher' => { 81 => 'Publisher' },
    'quality' => { 0 => 0x3, 22 => 0x2, 23 => 0x3002, 25 => 0x1000, 46 => 0x9, 59 => 0x4, 60 => 0x3, 67 => 0x201, 70 => 0x8, 78 => 0x16 },
    'qualitymode' => { 23 => 0x8 },
    'quantizationmethod' => { 37 => 0x78 },
    'quickshot' => { 77 => 0x213 },
    'rasterizedcaption' => { 34 => 0x7d },
    'rasterpadding' => { 24 => 0x84e3 },
    'rawandjpgrecording' => { 10 => 0x8 },
    'rawdata' => { 18 => 0x2005 },
    'rawdevcolorspace' => { 68 => 0x108 },
    'rawdevcontrastvalue' => { 68 => 0x106 },
    'rawdeveditstatus' => { 68 => 0x10b },
    'rawdevelopment' => { 67 => 0x2030 },
    'rawdevengine' => { 68 => 0x109 },
    'rawdevexposurebiasvalue' => { 68 => 0x100 },
    'rawdevgraypoint' => { 68 => 0x103 },
    'rawdevmemorycoloremphasis' => { 68 => 0x105 },
    'rawdevnoisereduction' => { 68 => 0x10a },
    'rawdevsaturationemphasis' => { 68 => 0x104 },
    'rawdevsettings' => { 68 => 0x10c },
    'rawdevsharpnessvalue' => { 68 => 0x107 },
    'rawdevversion' => { 68 => 0x0 },
    'rawdevwbfineadjustment' => { 68 => 0x102 },
    'rawdevwhitebalancevalue' => { 68 => 0x101 },
    'rawfile' => { 24 => 0xfe4c },
    'rawfilename' => { 81 => 'RawFileName' },
    'rawimagesize' => { 70 => 0x39 },
    'readerrequirements' => { 44 => 'rreq' },
    'recordid' => { 18 => 0x1804 },
    'recordingmode' => { 22 => 0x1 },
    'recordmode' => { 23 => 0x3000 },
    'recordshutterrelease' => { 77 => 0x217 },
    'redbalance' => { 56 => 0x0, 57 => 0x0, 58 => 0x0, 67 => 0x1017 },
    'redbalanceauto' => { 9 => 0x0 },
    'redbalanceb&w' => { 9 => 0xe },
    'redbalancecloudy' => { 9 => 0x4 },
    'redbalancecustom' => { 9 => 0xc },
    'redbalancedaylight' => { 9 => 0x2 },
    'redbalanceflash' => { 9 => 0xa },
    'redbalancefluorescent' => { 9 => 0x8 },
    'redbalanceshade' => { 9 => 0x10 },
    'redbalancetungsten' => { 9 => 0x6 },
    'redbluebias' => { 66 => 0x100 },
    'redeyereduction' => { 82 => 'RedEyeReduction' },
    'redgain' => { 76 => 'Rg' },
    'redhue' => { 81 => 'RedHue' },
    'redmatrixcolumn' => { 31 => 'rXYZ' },
    'redsaturation' => { 81 => 'RedSaturation' },
    'redtrc' => { 31 => 'rTRC' },
    'reductionmatrix1' => { 24 => 0xc625 },
    'reductionmatrix2' => { 24 => 0xc626 },
    'referenceblackwhite' => { 24 => 0x214, 81 => 'ReferenceBlackWhite' },
    'referencedate' => { 34 => 0x2f },
    'referencenumber' => { 34 => 0x32 },
    'referenceservice' => { 34 => 0x2d },
    'relatedimagefileformat' => { 24 => 0x1000 },
    'relatedimagelength' => { 24 => 0x1002 },
    'relatedimagewidth' => { 24 => 0x1001 },
    'relatedsoundfile' => { 24 => 0xa004, 81 => 'RelatedSoundFile' },
    'relation' => { 81 => 'Relation' },
    'releasedate' => { 34 => 0x1e },
    'releasesetting' => { 18 => 0x1016 },
    'releasetime' => { 34 => 0x23 },
    'renderingintent' => { 30 => 0x40 },
    'renditionclass' => { 81 => 'RenditionClass' },
    'renditionof' => { 81 => 'RenditionOf' },
    'renditionofdocumentid' => { 81 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 81 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 81 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 81 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 81 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 81 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 81 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 81 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 81 => 'RenditionOfVersionID' },
    'renditionparams' => { 81 => 'RenditionParams' },
    'resaved' => { 77 => 0x21e },
    'resolution' => { 44 => 'res ' },
    'resolutionmode' => { 78 => 0x4 },
    'resolutionunit' => { 24 => 0x128, 62 => 0x128, 81 => 'ResolutionUnit' },
    'revision' => { 76 => ['Rev','Rv'] },
    'ricohdatetime1' => { 75 => 0x4 },
    'ricohdatetime2' => { 75 => 0x5 },
    'ricohrr1subdir' => { 74 => 0x2001 },
    'ricohsubdir' => { 74 => 0x2001 },
    'rights' => { 81 => 'Rights' },
    'roidescription' => { 44 => 'roid' },
    'rollguidelements' => { 24 => 0xc364 },
    'romoperationmode' => { 18 => 0x80d },
    'rotation' => { 17 => 0x3 },
    'rowsperstrip' => { 24 => 0x116 },
    'safetyshiftinavortv' => { 10 => 0x10, 11 => 0x10, 12 => 0xf },
    'sampleformat' => { 24 => 0x153 },
    'samplesperpixel' => { 24 => 0x115, 81 => 'SamplesPerPixel' },
    'samplestructure' => { 37 => 0x5a },
    'sanyoquality' => { 77 => 0x201 },
    'sanyothumbnail' => { 77 => 0x100 },
    'saturation' => { 0 => 0xe, 22 => 0xd, 23 => 0x1f, 24 => [0xa409,0xfe55], 25 => 0x1003, 54 => 0x1f, 59 => [0x94,0xaa], 70 => 0x1f, 78 => 0x10, 81 => 'Saturation' },
    'saveid' => { 81 => 'SaveID' },
    'sba_rgbshifts' => { 24 => 0xc35e },
    'sbaexposurerecord' => { 24 => 0xc361 },
    'sbainputimagebitdepth' => { 24 => 0xc360 },
    'sbainputimagecolorspace' => { 24 => 0xc35f },
    'scalefactor35efl' => { 82 => 'ScaleFactor35efl' },
    'scanningdirection' => { 37 => 0x64 },
    'scene' => { 81 => 'Scene' },
    'scenecapturetype' => { 24 => 0xa406, 81 => 'SceneCaptureType' },
    'scenemode' => { 59 => 0x8f, 63 => 0x509 },
    'sceneselect' => { 77 => 0x21f },
    'scenetype' => { 24 => 0xa301, 81 => 'SceneType' },
    'screening' => { 31 => 'scrn' },
    'screeningdesc' => { 31 => 'scrd' },
    'securityclassification' => { 24 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 8 => 0x1d },
    'selftimer' => { 23 => 0x3001, 77 => 0x214 },
    'selftimermode' => { 24 => 0x882b },
    'selftimertime' => { 18 => 0x1806 },
    'sensingmethod' => { 24 => [0x9217,0xa217], 81 => 'SensingMethod' },
    'sensorbottomborder' => { 20 => 0x8 },
    'sensorcleaning' => { 13 => 0xd },
    'sensorheight' => { 20 => 0x2 },
    'sensorinfo' => { 18 => 0x1031 },
    'sensorleftborder' => { 20 => 0x5 },
    'sensorrightborder' => { 20 => 0x7 },
    'sensortopborder' => { 20 => 0x6 },
    'sensorwidth' => { 20 => 0x1 },
    'sequence' => { 63 => 0x600 },
    'sequencenumber' => { 8 => 0x9, 46 => 0x1d },
    'sequenceshotinterval' => { 77 => 0x224 },
    'sequentialshot' => { 77 => 0x20e },
    'serialnumber' => { 5 => 0xc, 18 => 0x180b, 24 => [0xc354,0xfde9], 59 => 0xa0, 64 => 0x101, 67 => 0x101a, 69 => 0x25, 78 => 0x2, 81 => 'SerialNumber' },
    'serviceidentifier' => { 35 => 0x1e },
    'setbuttonfunction' => { 10 => 0x1, 13 => 0xc },
    'setfunctionwhenshooting' => { 12 => 0x0 },
    'shadingcompensation' => { 63 => 0x50c },
    'shadingcompensation2' => { 66 => 0x1012 },
    'shadow' => { 78 => 0xe },
    'shadows' => { 24 => 0xfe52, 81 => 'Shadows' },
    'shadowscale' => { 24 => 0xc633 },
    'shadowtint' => { 81 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 22 => 0xb, 23 => 0x21, 24 => [0xa40a,0xfe56], 25 => 0x1001, 46 => 0x6b, 49 => 0x37, 54 => 0x21, 59 => 0x6, 70 => 0x21, 78 => 0x11, 81 => 'Sharpness' },
    'sharpnessfactor' => { 67 => [0x100f,0x102a] },
    'sharpnesssetting' => { 63 => 0x506 },
    'shootingmode' => { 59 => 0x89, 69 => 0x1f, 82 => 'ShootingMode' },
    'shootingrecord' => { 18 => 0x3002 },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 10 => 0x4, 12 => 0x3, 13 => 0x2 },
    'shutteraelbutton' => { 11 => 0x4 },
    'shuttercount' => { 3 => 0x1, 59 => 0xa7 },
    'shuttercurtainhack' => { 82 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 10 => 0xf, 11 => 0xf, 12 => 0xe, 13 => 0x8 },
    'shuttermode' => { 46 => 0x1b },
    'shutterreleasemethod' => { 18 => 0x1010 },
    'shutterreleasenocfcard' => { 10 => 0x2, 11 => 0x2, 13 => 0xf },
    'shutterreleasetiming' => { 18 => 0x1011 },
    'shutterspeed' => { 82 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 24 => 0x9201, 81 => 'ShutterSpeedValue' },
    'site' => { 24 => 0x84e0 },
    'sizemode' => { 40 => 0xa },
    'slowsync' => { 25 => 0x1030 },
    'smaxsamplevalue' => { 24 => 0x155 },
    'sminsamplevalue' => { 24 => 0x154 },
    'smoothingparameter1' => { 66 => 0x300 },
    'smoothingparameter2' => { 66 => 0x310 },
    'smoothingthreshold2' => { 66 => 0x610 },
    'smoothingthresholds' => { 66 => 0x600 },
    'smoothness' => { 24 => 0xfe57 },
    'software' => { 24 => 0x131, 78 => 0x18, 81 => 'Software' },
    'softwareversion' => { 77 => 0x207 },
    'source' => { 34 => 0x73, 81 => 'Source' },
    'sourceimagedirectory' => { 24 => 0xc418 },
    'sourceimagefilename' => { 24 => 0xc419 },
    'sourceimagevolumename' => { 24 => 0xc41a },
    'spatialfrequencyresponse' => { 24 => [0x920c,0xa20c], 81 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 81 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 81 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 81 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 81 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 34 => 0x28 },
    'specialmode' => { 67 => 0x200, 77 => 0x200 },
    'spectralsensitivity' => { 24 => 0x8824, 81 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 54 => 0x2d },
    'spotfocuspointy' => { 54 => 0x2e },
    'spotmode' => { 69 => 0xf },
    'state' => { 81 => 'State' },
    'stonits' => { 24 => 0x923f },
    'stripbytecounts' => { 24 => 0x117 },
    'stripoffsets' => { 24 => 0x111 },
    'striprowcounts' => { 24 => 0x22f },
    'sub-location' => { 34 => 0x5c },
    'subfile' => { 38 => 0xa },
    'subfiletype' => { 24 => 0xfe },
    'subifd' => { 24 => 0x14a },
    'subifd_offset' => { 61 => 0x3 },
    'subject' => { 81 => 'Subject' },
    'subjectarea' => { 81 => 'SubjectArea' },
    'subjectcode' => { 81 => 'SubjectCode' },
    'subjectdistance' => { 24 => 0x9206, 81 => 'SubjectDistance' },
    'subjectdistance?' => { 46 => 0x3e },
    'subjectdistancerange' => { 24 => 0xa40c, 81 => 'SubjectDistanceRange' },
    'subjectlocation' => { 24 => [0x9214,0xa214], 81 => 'SubjectLocation' },
    'subjectprogram' => { 54 => 0x22 },
    'subjectreference' => { 34 => 0xc },
    'subsecdatetimeoriginal' => { 82 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 24 => 0x9290 },
    'subsectimedigitized' => { 24 => 0x9292 },
    'subsectimeoriginal' => { 24 => 0x9291 },
    'superimposeddisplay' => { 10 => 0xa, 12 => 0x9, 13 => 0xe },
    'supplementalcategories' => { 34 => 0x14, 81 => 'SupplementalCategories' },
    'supplementaltype' => { 37 => 0x37 },
    'switchtoregisteredafpoint' => { 11 => 0x12 },
    't4options' => { 24 => 0x124 },
    't6options' => { 24 => 0x125 },
    'targetcompressionratio' => { 16 => 0x1 },
    'targetdistancesetting' => { 18 => 0x1807 },
    'targetimagetype' => { 18 => 0x100a },
    'targetprinter' => { 24 => 0x151 },
    'technology' => { 31 => 'tech' },
    'thresholding' => { 24 => 0x107 },
    'thumbnailfilename' => { 18 => 0x817 },
    'thumbnailimage' => { 18 => 0x2008, 67 => 0x100, 82 => 'ThumbnailImage' },
    'thumbnaillength' => { 24 => 0x202 },
    'thumbnailoffset' => { 24 => 0x201 },
    'thumbnails' => { 81 => 'Thumbnails' },
    'thumbnailsformat' => { 81 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 81 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 81 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 81 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 24 => [0x9216,0xa216] },
    'tilebytecounts' => { 24 => 0x145 },
    'tiledepth' => { 24 => 0x80e6 },
    'tilelength' => { 24 => 0x143 },
    'tileoffsets' => { 24 => 0x144 },
    'tilewidth' => { 24 => 0x142 },
    'time' => { 46 => 0x14, 49 => 0x10, 70 => 0x7 },
    'timecreated' => { 34 => 0x3c },
    'timesent' => { 35 => 0x50 },
    'timestamp' => { 18 => 0x180e },
    'timezone' => { 23 => 0x3006 },
    'timezonecode' => { 21 => 0x1 },
    'timezoneinfo' => { 21 => 0x2 },
    'timezoneoffset' => { 24 => 0x882a },
    'title' => { 81 => 'Title' },
    'tonecomp' => { 59 => 0x81 },
    'tonecurve' => { 70 => 0x402 },
    'tonecurves' => { 70 => 0x403 },
    'totalzoom' => { 46 => 0x62 },
    'transferfunction' => { 24 => 0x12d, 81 => 'TransferFunction' },
    'transferrange' => { 24 => 0x156 },
    'transmissionreference' => { 81 => 'TransmissionReference' },
    'transparencyindicator' => { 24 => 0x84ec },
    'tvvalue' => { 14 => 0x1 },
    'type' => { 81 => 'Type' },
    'ucrbg' => { 31 => 'bfd ' },
    'uniquecameramodel' => { 24 => 0xc614 },
    'uniqueobjectname' => { 35 => 0x64 },
    'urgency' => { 34 => 0xa, 81 => 'Urgency' },
    'url' => { 44 => 'url ', 72 => 0x40b },
    'usageterms' => { 81 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 24 => 0xc362 },
    'usercomment' => { 18 => 0x805, 24 => 0x9286, 81 => 'UserComment' },
    'userselectgrouptitle' => { 24 => 0xc355 },
    'usmlenselectronicmf' => { 11 => 0x7 },
    'uuid-geojp2' => { 44 => 'uuid' },
    'uuid-unknown' => { 44 => 'uuid' },
    'uuid-xmp' => { 44 => 'uuid' },
    'uuidinfo' => { 44 => 'uinf' },
    'uuidlist' => { 44 => 'ulst' },
    'validbits' => { 66 => 0x611, 67 => 0x102c },
    'variousmodes2?' => { 46 => 0x3a },
    'variousmodes?' => { 46 => 0x26 },
    'variprogram' => { 59 => 0xab },
    'version' => { 25 => 0x0, 81 => 'Version' },
    'versionid' => { 81 => 'VersionID' },
    'versions' => { 81 => 'Versions' },
    'versionscomments' => { 81 => 'VersionsComments' },
    'versionsevent' => { 81 => 'VersionsEvent' },
    'versionseventaction' => { 81 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 81 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 81 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 81 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 81 => 'VersionsEventWhen' },
    'versionsmodifier' => { 81 => 'VersionsModifier' },
    'versionsmodifydate' => { 81 => 'VersionsModifyDate' },
    'versionsversion' => { 81 => 'VersionsVersion' },
    'versionyear' => { 24 => 0x194 },
    'verticalcitation' => { 27 => 0x1001 },
    'verticalcstype' => { 27 => 0x1000 },
    'verticaldatum' => { 27 => 0x1002 },
    'verticalunits' => { 27 => 0x1003 },
    'videocardgamma' => { 31 => 'vcgt' },
    'viewingconddesc' => { 31 => 'vued' },
    'viewingcondilluminant' => { 33 => 0x8 },
    'viewingcondilluminanttype' => { 33 => 0x20 },
    'viewingconditions' => { 31 => 'view' },
    'viewingcondsurround' => { 33 => 0x14 },
    'vignetteamount' => { 81 => 'VignetteAmount' },
    'vignettemidpoint' => { 81 => 'VignetteMidpoint' },
    'voicememo' => { 77 => 0x216 },
    'wangannotation' => { 24 => 0x80a4 },
    'warning' => { 83 => 'Warning' },
    'watermarktype' => { 45 => 0x8 },
    'webstatement' => { 81 => 'WebStatement' },
    'whitebalance' => { 8 => 0x7, 22 => 0x7, 23 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 25 => 0x1002, 46 => 0x40, 51 => 0x1a, 54 => 0x3, 59 => 0x5, 60 => 0x7, 67 => 0x1015, 69 => 0x3, 70 => 0x19, 78 => 0x7, 81 => 'WhiteBalance' },
    'whitebalancebias' => { 23 => 0x2011, 69 => 0x23 },
    'whitebalancebracket' => { 63 => 0x502 },
    'whitebalancefinetune' => { 59 => 0xb },
    'whitebalancemode' => { 70 => 0x1a },
    'whitebalancetable' => { 5 => 0xa9, 18 => 0x10a9 },
    'whitebalancetemperature' => { 63 => 0x501 },
    'whitelevel' => { 24 => 0xc61d },
    'whitepoint' => { 24 => 0x13e, 70 => 0x201, 81 => 'WhitePoint' },
    'widefocuszone' => { 54 => 0x2f },
    'widerange' => { 77 => 0x20f },
    'writer-editor' => { 34 => 0x7a },
    'x3filllight' => { 78 => 0x12 },
    'xclippathunits' => { 24 => 0x158 },
    'xml' => { 44 => 'xml ' },
    'xpauthor' => { 24 => 0x9c9d },
    'xpcomment' => { 24 => 0x9c9c },
    'xpkeywords' => { 24 => 0x9c9e },
    'xposition' => { 24 => 0x11e },
    'xpsubject' => { 24 => 0x9c9f },
    'xptitle' => { 24 => 0x9c9b },
    'xresolution' => { 24 => 0x11a, 62 => 0x11a, 81 => 'XResolution' },
    'ycbcrcoefficients' => { 24 => 0x211, 81 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 24 => 0x213, 62 => 0x213 },
    'ycbcrsubsampling' => { 24 => 0x212, 81 => 'YCbCrSubSampling' },
    'yclippathunits' => { 24 => 0x159 },
    'yposition' => { 24 => 0x11f },
    'yresolution' => { 24 => 0x11b, 62 => 0x11b, 81 => 'YResolution' },
    'zoom' => { 67 => 0x100d },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
    'zoomposition' => { 65 => 0x300 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
