#!/usr/bin/env perl

use strictures 1;
use SiteSpy;
use Test::More;

my $olde = <<OLDE;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div class='hello'>
        <p>
            hello!
        </p>
        </div>
        <div class='hello'>
        <p>
        world!
        </p>
        </div>
    </body>
</html>
OLDE

my $new = <<NEW;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div class='hello'>
        <p>
            world!
        </p>
        </div>
    </body>
</html>
NEW

my $ss = SiteSpy->new({
        old_HTML  => $olde,
        new_HTML  => $new,
        args      =>
            {
                class => 'hello',
            },
    });

is_deeply $ss->find_diffs->deleted, ['hello!'];

$olde = <<OLDE;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div class='hello'>
        <p>
            one
        </p>
        </div>
        <div class='hello'>
        <p>
        two
        </p>
        </div>
        <div class='hello'>
            three
        </div>
    </body>
</html>
OLDE

$new = <<NEW;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div class='hello'>
        <p>
            four
        </p>
        </div>
        <div class='hello'>
        <p>
        five
        </p>
        </div>
        <div class='hello'>
            six
        </div>
    </body>
</html>
NEW

$ss = SiteSpy->new({
        old_HTML  => $olde,
        new_HTML  => $new,
        args      =>
            {
                class => 'hello',
            },
    });

is_deeply $ss->find_diffs->added, ['four', 'five', 'six'];
is_deeply $ss->find_diffs->deleted, ['one', 'two', 'three'];

done_testing;
