package Data::Random::Contact::Country::US;
BEGIN {
  $Data::Random::Contact::Country::US::VERSION = '0.02';
}

use strict;
use warnings;
use autodie;

my ( @AreaCodes, @Addresses );

{
    my $array;
    my $eval;

    while (<DATA>) {
        next unless /\S/;

        if (/__area_code__/) {
            $array = \@AreaCodes;
        }
        elsif (/__address__/) {
            $array = \@Addresses;
            $eval = 1;
        }
        else {
            die "No array yet!" unless $array;

            chomp;
            push @{$array}, $eval ? eval $_ : $_;
        }
    }
}

sub phone_number {
    my $area_code = $AreaCodes[ int( rand( scalar @AreaCodes ) )];

    # 200 - 999
    my $prefix = ( int( rand( 800 ) ) + 200 );
    my $suffix = sprintf( '%04d', rand( 10000 ) );

    return join '-', $area_code, $prefix, $suffix;
}

sub address {
    my $address = $Addresses[ int( rand( scalar @Addresses ) ) ];
    return { %{ $address} };
}

1;

# ABSTRACT: US phone number and address data


# Address data comes VegGuide.org
#
# The data is licensed under CC BY-NC-SA 3.0 (United Stated).


=pod

=head1 NAME

Data::Random::Contact::Country::US - US phone number and address data

=head1 VERSION

version 0.02

=head1 DESCRIPTION

This module provides US country phone and address data.

=head1 METHODS

This module provides the following methods:

=head2 $country->phone_number()

This returns a phone number like "212-555-1234". The area codes are all valid
US area codes. The number prefix will be a random number from 200 to 999.

=head2 $country->address()

This returns a hash reference with the following keys:

=over 4

=item * street_1

The first line of the street address.

=item * street_2

The second line of the street address. This is usually C<undef>.

=item * city

The address's city.

=item * region

The address's state.

=item * postal_code

The address's zip code.

=back

Note that any address component can be C<undef>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2011 by Dave Rolsky.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut


__DATA__
__area_code__
201
202
203
204
205
206
207
208
209
210
212
213
214
215
216
217
218
219
225
228
229
231
234
240
242
246
248
250
252
253
254
256
262
264
267
268
270
281
284
301
302
303
304
305
306
307
308
309
310
312
313
314
315
316
317
318
319
320
321
323
330
334
336
337
340
345
347
352
360
361
385
401
402
403
404
405
406
407
408
409
410
412
413
414
415
416
417
418
419
423
425
435
440
441
443
450
456
469
473
478
480
484
500
501
502
503
504
505
506
507
508
509
510
512
513
514
515
516
517
518
519
520
530
540
541
559
561
562
570
571
573
580
600
601
602
603
604
605
606
607
608
609
610
612
613
614
615
616
617
618
619
623
626
630
631
636
641
646
647
649
650
651
660
661
662
664
670
671
678
682
700
701
702
703
704
705
706
707
708
709
710
712
713
714
715
716
717
718
719
720
724
727
732
734
740
757
758
760
763
765
767
770
773
775
780
781
784
785
786
787
800
801
802
803
804
805
806
807
808
809
810
812
813
814
815
816
817
818
819
828
830
831
832
843
845
847
850
856
858
859
860
863
864
865
866
867
867
867
868
869
870
876
877
880
881
882
888
900
901
902
902
903
904
905
906
907
908
909
910
912
913
914
915
916
917
918
919
920
925
931
936
937
940
941
949
952
954
956
970
971
972
973
978
979

__address__
{city => "Anchorage",postal_code => 99515,region => "Alaska",region_abbr => "AK",street_1 => "219 East Dimond Boulevard",street_2 => undef}
{city => "Denali",postal_code => 99577,region => "Alaska",region_abbr => "AK",street_1 => "Milepost 238.9",street_2 => "Parks Highway"}
{city => "Kodiak",postal_code => 99615,region => "Alaska",region_abbr => "AK",street_1 => "338 Mission Road",street_2 => undef}
{city => "Palmer",postal_code => 99645,region => "Alaska",region_abbr => "AK",street_1 => "550 South Alaska Street",street_2 => undef}
{city => "Seward",postal_code => 99664,region => "Alaska",region_abbr => "AK",street_1 => "11694 Seward Highway",street_2 => "Suite B"}
{city => "Auburn",postal_code => 36830,region => "Alabama",region_abbr => "AL",street_1 => "114 W. Magnolia Avenue",street_2 => undef}
{city => "Auburn",postal_code => 36830,region => "Alabama",region_abbr => "AL",street_1 => "157 N. College Street",street_2 => undef}
{city => "Birmingham",postal_code => 35243,region => "Alabama",region_abbr => "AL",street_1 => "233 Summit Boulevard",street_2 => undef}
{city => "Birmingham",postal_code => 35209,region => "Alabama",region_abbr => "AL",street_1 => undef,street_2 => undef}
{city => "Birmingham",postal_code => 35218,region => "Alabama",region_abbr => "AL",street_1 => "1580 Montgomery Hwy",street_2 => "#12"}
{city => "Birmingham",postal_code => 35222,region => "Alabama",region_abbr => "AL",street_1 => "3719 3rd Ave S",street_2 => undef}
{city => "Huntsville",postal_code => 35806,region => "Alabama",region_abbr => "AL",street_1 => "6275 University Drive",street_2 => undef}
{city => "Montgomery",postal_code => 36106,region => "Alabama",region_abbr => "AL",street_1 => "1034 E. Fairview Avenue",street_2 => undef}
{city => "Montgomery",postal_code => 36106,region => "Alabama",region_abbr => "AL",street_1 => "1031 East Fairview Avenue",street_2 => undef}
{city => "Montgomery",postal_code => 36111,region => "Alabama",region_abbr => "AL",street_1 => "3007 McGehee Rd",street_2 => undef}
{city => "Montgomery",postal_code => 36117,region => "Alabama",region_abbr => "AL",street_1 => "2580 Eastern Blvd",street_2 => undef}
{city => "Montgomery",postal_code => 36117,region => "Alabama",region_abbr => "AL",street_1 => "2759 Eastern Blvd",street_2 => undef}
{city => "Montgomery",postal_code => 36106,region => "Alabama",region_abbr => "AL",street_1 => "1714 W. Third Street",street_2 => undef}
{city => "Seale",postal_code => 36875,region => "Alabama",region_abbr => "AL",street_1 => "30 Uchee Pines Rd.",street_2 => undef}
{city => "Tuscaloosa",postal_code => 35401,region => "Alabama",region_abbr => "AL",street_1 => "1207 University Blvd",street_2 => undef}
{city => "Tuscaloosa",postal_code => 35401,region => "Alabama",region_abbr => "AL",street_1 => "500 15th St.",street_2 => undef}
{city => "Birmingham",postal_code => 35205,region => "Alabama",region_abbr => "AL",street_1 => "1901 11th Avenue South",street_2 => undef}
{city => "Birmingham",postal_code => 35205,region => "Alabama",region_abbr => "AL",street_1 => "1020 20th St S",street_2 => undef}
{city => "Birmingham",postal_code => undef,region => "Alabama",region_abbr => "AL",street_1 => "1918 11th Ave S",street_2 => undef}
{city => "Birmingham",postal_code => 35205,region => "Alabama",region_abbr => "AL",street_1 => "2226 Highland Avenue South",street_2 => undef}
{city => "Hoover",postal_code => 35216,region => "Alabama",region_abbr => "AL",street_1 => "3309 Lorna Road",street_2 => "Suite 7"}
{city => "Huntsville",postal_code => 35801,region => "Alabama",region_abbr => "AL",street_1 => "628 Meridian Street North",street_2 => undef}
{city => "Huntsville",postal_code => 35801,region => "Alabama",region_abbr => "AL",street_1 => "2308 S Memorial Pkwy",street_2 => undef}
{city => "Huntsville",postal_code => 35816,region => "Alabama",region_abbr => "AL",street_1 => "2413 Jordan Lane NW",street_2 => undef}
{city => "Huntsville",postal_code => 35806,region => "Alabama",region_abbr => "AL",street_1 => "930 Old Monrovia Rd NW",street_2 => undef}
{city => "Huntsville",postal_code => 35802,region => "Alabama",region_abbr => "AL",street_1 => "5000 Whitesburg Dr S",street_2 => undef}
{city => "Huntsville",postal_code => 35805,region => "Alabama",region_abbr => "AL",street_1 => "3017 Governors Dr SW",street_2 => undef}
{city => "Huntsville",postal_code => 35810,region => "Alabama",region_abbr => "AL",street_1 => "605 Jordan Lane",street_2 => undef}
{city => "Huntsville",postal_code => 35816,region => "Alabama",region_abbr => "AL",street_1 => "2413 Jordan Ln",street_2 => undef}
{city => "Huntsville",postal_code => 35816,region => "Alabama",region_abbr => "AL",street_1 => "2420 Jordan Ln NW",street_2 => undef}
{city => "Huntsville",postal_code => 35801,region => "Alabama",region_abbr => "AL",street_1 => "1407 Memorial Pkwy NW",street_2 => undef}
{city => "Huntsville",postal_code => 35816,region => "Alabama",region_abbr => "AL",street_1 => "600 Jordan Ln NW # 1",street_2 => undef}
{city => "Huntsville",postal_code => 35801,region => "Alabama",region_abbr => "AL",street_1 => "800 Wellman Ave NE",street_2 => undef}
{city => "Huntsville",postal_code => 35805,region => "Alabama",region_abbr => "AL",street_1 => "420 Jordan Lane",street_2 => undef}
{city => "Huntsville",postal_code => 35802,region => "Alabama",region_abbr => "AL",street_1 => "975 Airport Rd",street_2 => undef}
{city => "Huntsville",postal_code => 35806,region => "Alabama",region_abbr => "AL",street_1 => "6125 University Dr NW",street_2 => undef}
{city => "Huntsville",postal_code => 35816,region => "Alabama",region_abbr => "AL",street_1 => "4925 University Dr NW",street_2 => undef}
{city => "Huntsville",postal_code => 35805,region => "Alabama",region_abbr => "AL",street_1 => "413 Jordan Ln NW",street_2 => undef}
{city => "Huntsville",postal_code => 35802,region => "Alabama",region_abbr => "AL",street_1 => "975 Airport Road SW",street_2 => undef}
{city => "Huntsville",postal_code => 35801,region => "Alabama",region_abbr => "AL",street_1 => "2113 Whitesburg Drive",street_2 => undef}
{city => "Tuscaloosa",postal_code => 35404,region => "Alabama",region_abbr => "AL",street_1 => "2300 McFarland Boulevard East",street_2 => undef}
{city => "Anchorage",postal_code => 99507,region => "Alaska",region_abbr => "AK",street_1 => "2446 Tudor Road",street_2 => undef}
{city => "Anchorage",postal_code => 99518,region => "Alaska",region_abbr => "AK",street_1 => "7305 Old Seward Highway",street_2 => undef}
{city => "Anchorage",postal_code => 99503,region => "Alaska",region_abbr => "AK",street_1 => "2610 Spenard Road",street_2 => "Suite B"}
{city => "Anchorage",postal_code => 99503,region => "Alaska",region_abbr => "AK",street_1 => "3801 Old Seward Highway",street_2 => "Suite A1"}
{city => "Anchorage",postal_code => 99503,region => "Alaska",region_abbr => "AK",street_1 => "1200 W. Northern Lights Blvd.",street_2 => undef}
{city => "Bentonville",postal_code => 72712,region => "Arkansas",region_abbr => "AR",street_1 => "2905 S Walton Blvd",street_2 => undef}
{city => "Fayetteville",postal_code => 72701,region => "Arkansas",region_abbr => "AR",street_1 => "481 S. School Ave.",street_2 => undef}
{city => "Fayetteville",postal_code => 72701,region => "Arkansas",region_abbr => "AR",street_1 => "40 E. Center Street",street_2 => undef}
{city => "Fayetteville",postal_code => undef,region => "Arkansas",region_abbr => "AR",street_1 => undef,street_2 => undef}
{city => "Harrison",postal_code => 72601,region => "Arkansas",region_abbr => "AR",street_1 => "623 Highway 62/65",street_2 => undef}
{city => "Harrison",postal_code => 72601,region => "Arkansas",region_abbr => "AR",street_1 => "1517 North Main St",street_2 => undef}
{city => "Harrison",postal_code => 72601,region => "Arkansas",region_abbr => "AR",street_1 => "1012 Highway 62-65 North",street_2 => undef}
{city => "Jonesboro",postal_code => 72401,region => "Arkansas",region_abbr => "AR",street_1 => "1900 Aggie Road",street_2 => undef}
{city => "Little Rock",postal_code => 72223,region => "Arkansas",region_abbr => "AR",street_1 => "5601 Ranch Drive",street_2 => undef}
{city => "Little Rock",postal_code => 72212,region => "Arkansas",region_abbr => "AR",street_1 => "11121 N. Rodney Parham Road",street_2 => undef}
{city => "Little Rock",postal_code => 72205,region => "Arkansas",region_abbr => "AR",street_1 => "722 N. Palm Street",street_2 => undef}
{city => "North Little Rock",postal_code => 72114,region => "Arkansas",region_abbr => "AR",street_1 => "411 Main St.",street_2 => undef}
{city => undef,postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => " Mesa",postal_code => 85204,region => "Arizona",region_abbr => "AZ",street_1 => "2252 E Baseline Rd",street_2 => undef}
{city => "Avondale",postal_code => 85323,region => "Arizona",region_abbr => "AZ",street_1 => "13045 W Rancho Sante Fe #A105",street_2 => undef}
{city => "Bisbee",postal_code => 85603,region => "Arizona",region_abbr => "AZ",street_1 => "72 Erie Street",street_2 => undef}
{city => "Bisbee",postal_code => 85603,region => "Arizona",region_abbr => "AZ",street_1 => "14 Main Street",street_2 => undef}
{city => "Bisbee",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "35 Main Street",street_2 => undef}
{city => "Chandler",postal_code => 85224,region => "Arizona",region_abbr => "AZ",street_1 => "2051 W. Warner Rd",street_2 => undef}
{city => "Chandler",postal_code => 85225,region => "Arizona",region_abbr => "AZ",street_1 => "478 N. Arizona Ave.",street_2 => undef}
{city => "Chandler",postal_code => 85226,region => "Arizona",region_abbr => "AZ",street_1 => "6140 W Chandler Blvd",street_2 => undef}
{city => "Chandler",postal_code => 85226,region => "Arizona",region_abbr => "AZ",street_1 => "6245 W. Chandler Blvd.",street_2 => undef}
{city => "Chandler",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1960 W Ray Rd",street_2 => undef}
{city => "Chandler",postal_code => 85226,region => "Arizona",region_abbr => "AZ",street_1 => "7131 West Ray Rd.",street_2 => undef}
{city => "Chandler",postal_code => 85224,region => "Arizona",region_abbr => "AZ",street_1 => "1949 W. Ray Rd.",street_2 => undef}
{city => "Chandler",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "71 E Chandler Blvd",street_2 => undef}
{city => "Chandler",postal_code => 85226,region => "Arizona",region_abbr => "AZ",street_1 => "5055 W. Ray Rd",street_2 => "#B8"}
{city => "Cottonwood",postal_code => 86326,region => "Arizona",region_abbr => "AZ",street_1 => "853 South Main Street",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "1000 S. Milton Rd.",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "14 South Beaver Street",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "16 North San Francisco St",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "11 East Aspen Ave.",street_2 => undef}
{city => "Gilbert",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1111 N. Gilbert Rd., Suite 103",street_2 => undef}
{city => "Glendale",postal_code => 85308,region => "Arizona",region_abbr => "AZ",street_1 => "5775 W. Bell Rd.",street_2 => "#5"}
{city => "Glendale",postal_code => 85301,region => "Arizona",region_abbr => "AZ",street_1 => "7016 N 57th Ave",street_2 => undef}
{city => "Glendale",postal_code => 85301,region => "Arizona",region_abbr => "AZ",street_1 => "5008 W. Northern Ave.",street_2 => undef}
{city => "Glendale",postal_code => 85306,region => "Arizona",region_abbr => "AZ",street_1 => "13828 N 51st Ave.",street_2 => undef}
{city => "Glendale",postal_code => 85308,region => "Arizona",region_abbr => "AZ",street_1 => "6661 West Bell Rd.",street_2 => "Suite 101B"}
{city => "Glendale",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "8190 W. Union Hills Dr.",street_2 => undef}
{city => "Glendale",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => " 9626 N. 58th Lane",street_2 => undef}
{city => "Grand Canyon",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "Village Loop Road",street_2 => undef}
{city => "Guadalupe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "9210 S. Avenida del Yaqui",street_2 => undef}
{city => "Mesa",postal_code => 85205,region => "Arizona",region_abbr => "AZ",street_1 => "1152 N. Power Road #108",street_2 => undef}
{city => "Mesa",postal_code => 85202,region => "Arizona",region_abbr => "AZ",street_1 => "1941 W Guadalupe Rd",street_2 => undef}
{city => "Mesa",postal_code => 85212,region => "Arizona",region_abbr => "AZ",street_1 => "4011 S. Power Rd",street_2 => undef}
{city => "Mesa",postal_code => 85201,region => "Arizona",region_abbr => "AZ",street_1 => "48 N.Robson",street_2 => undef}
{city => "Mesa",postal_code => 85210,region => "Arizona",region_abbr => "AZ",street_1 => "134 S Country Club Drive",street_2 => undef}
{city => "Mesa",postal_code => 85209,region => "Arizona",region_abbr => "AZ",street_1 => "2060 S Power Rd",street_2 => undef}
{city => "Mesa",postal_code => "85206-2790",region => "Arizona",region_abbr => "AZ",street_1 => "5110 E Southern Ave",street_2 => undef}
{city => "Mesa",postal_code => 85202,region => "Arizona",region_abbr => "AZ",street_1 => "1941 W Guadalupe Rd #102",street_2 => undef}
{city => "Mesa",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "2620 W. Broadway Rd",street_2 => undef}
{city => "Oracle",postal_code => 85623,region => "Arizona",region_abbr => "AZ",street_1 => "1975 W. American Avenue",street_2 => undef}
{city => "Oracle",postal_code => 85623,region => "Arizona",region_abbr => "AZ",street_1 => "1395 W. American Avenue",street_2 => undef}
{city => "Oro Valley",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "7607 North Oracle Road",street_2 => undef}
{city => "Paradise Valley",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Patagonia",postal_code => 85264,region => "Arizona",region_abbr => "AZ",street_1 => "292 Naugle Ave",street_2 => undef}
{city => "Patagonia",postal_code => 85624,region => "Arizona",region_abbr => "AZ",street_1 => "319 McKeown Ave",street_2 => undef}
{city => "Patagonia",postal_code => 85624,region => "Arizona",region_abbr => "AZ",street_1 => "771 Harshaw Road",street_2 => undef}
{city => "Peoria",postal_code => 85383,region => "Arizona",region_abbr => "AZ",street_1 => "28421 N. Vistancia . Blvd",street_2 => "Suite 103/135"}
{city => "Peoria",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "8378 W Thunderbird Rd",street_2 => undef}
{city => "Peoria",postal_code => 85382,region => "Arizona",region_abbr => "AZ",street_1 => "7369 W. Bell Rd",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "5104 E Mcdowell Road",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1609 E Bell Rd",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1502 W. Thomas",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "2941 W Bell Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85015,region => "Arizona",region_abbr => "AZ",street_1 => "4426 N. 19th Ave.",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "12415 N. Tatum Blvd.",street_2 => undef}
{city => "Phoenix",postal_code => 85014,region => "Arizona",region_abbr => "AZ",street_1 => "6029 N 7th St",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "3215 E. Indian School",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "4225 E. Camelback Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "4820 N 7th St",street_2 => undef}
{city => "Phoenix",postal_code => 85042,region => "Arizona",region_abbr => "AZ",street_1 => "6106 S 32nd Street",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "20 W Adams St",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "2501 E. Camelback Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85051,region => "Arizona",region_abbr => "AZ",street_1 => "9620 N Metro Pkwy W",street_2 => undef}
{city => "Phoenix",postal_code => 85012,region => "Arizona",region_abbr => "AZ",street_1 => "52 East Camelback Rd",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "668 N. 44th St.",street_2 => undef}
{city => "Phoenix",postal_code => 85012,region => "Arizona",region_abbr => "AZ",street_1 => "1008 E Camelback Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "1949 E. Camelback Road",street_2 => "Suite 140"}
{city => "Phoenix",postal_code => 55016,region => "Arizona",region_abbr => "AZ",street_1 => "4515 N. 16th St.",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "3738 E. Indian School Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85020,region => "Arizona",region_abbr => "AZ",street_1 => "10810 North Tatum Blvd.",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "402 E Greenway Pkwy #2",street_2 => undef}
{city => "Phoenix",postal_code => 85003,region => "Arizona",region_abbr => "AZ",street_1 => "50 N Central Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85051,region => "Arizona",region_abbr => "AZ",street_1 => "10005 N Metro Pkwy",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "1401 N. Central Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85003,region => "Arizona",region_abbr => "AZ",street_1 => "18 W Adams St",street_2 => undef}
{city => "Phoenix",postal_code => "85004-1549",region => "Arizona",region_abbr => "AZ",street_1 => "530 E McDowell Rd",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "30 N 3rd Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "7000 E. Shea Blvd.",street_2 => "Ste. 1010"}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "3039 W. Peoria Ave.",street_2 => undef}
{city => "Phoenix",postal_code => "85004-1629",region => "Arizona",region_abbr => "AZ",street_1 => "101 E Mcdowell Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85003,region => "Arizona",region_abbr => "AZ",street_1 => " 27 W. Madison St",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => " 24 N. 2nd St.",street_2 => undef}
{city => "Phoenix",postal_code => 85006,region => "Arizona",region_abbr => "AZ",street_1 => "2065 N 7th St",street_2 => undef}
{city => "Phoenix",postal_code => 85015,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "2940 E Thomas Rd",street_2 => "(behind the barber shop)"}
{city => "Phoenix",postal_code => 85044,region => "Arizona",region_abbr => "AZ",street_1 => "4921 E Ray Rd",street_2 => "#102"}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "2 N Central Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85003,region => "Arizona",region_abbr => "AZ",street_1 => "15 W. Jefferson St.",street_2 => undef}
{city => "Phoenix",postal_code => 85048,region => "Arizona",region_abbr => "AZ",street_1 => "4025 E Chandler Blvd.",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "3 S. 2nd St.",street_2 => "Suite 107"}
{city => "Phoenix",postal_code => 85007,region => "Arizona",region_abbr => "AZ",street_1 => "1722 W. Van Buren",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "128 E Roosevelt St",street_2 => undef}
{city => "Phoenix",postal_code => 85048,region => "Arizona",region_abbr => "AZ",street_1 => "4206 E Chandler Blvd # 9",street_2 => undef}
{city => "Phoenix",postal_code => 85012,region => "Arizona",region_abbr => "AZ",street_1 => "3110 North Central Ave.",street_2 => "#100"}
{city => "Phoenix",postal_code => 85028,region => "Arizona",region_abbr => "AZ",street_1 => "10810 N Tatum Blvd.",street_2 => undef}
{city => "Phoenix",postal_code => 85032,region => "Arizona",region_abbr => "AZ",street_1 => "4747 E. Bell Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85032,region => "Arizona",region_abbr => "AZ",street_1 => "13843 N. Tatum Blvd.",street_2 => "#29"}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "4821 N. 20th St",street_2 => undef}
{city => "Phoenix",postal_code => 85042,region => "Arizona",region_abbr => "AZ",street_1 => "2170 E. Baseline Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "6845 N 16th St",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "245 E Bell Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85032,region => "Arizona",region_abbr => "AZ",street_1 => "15238 N. Cave Creek Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85014,region => "Arizona",region_abbr => "AZ",street_1 => "800 E Camelback Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85013,region => "Arizona",region_abbr => "AZ",street_1 => "1335 W Thomas Road",street_2 => undef}
{city => "Phoenix",postal_code => 85050,region => "Arizona",region_abbr => "AZ",street_1 => "2001 N Tatum Blvd",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "777 E Thunderbird Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "3945 E. Camelback Rd,",street_2 => undef}
{city => "Phoenix",postal_code => 85042,region => "Arizona",region_abbr => "AZ",street_1 => "6106 S. 32nd St.",street_2 => undef}
{city => "Phoenix",postal_code => 85014,region => "Arizona",region_abbr => "AZ",street_1 => "5150 N 7th St",street_2 => undef}
{city => "Phoenix",postal_code => 85027,region => "Arizona",region_abbr => "AZ",street_1 => "3049 W Agua Fria Fwy",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "401 E. Bell Rd",street_2 => "#16"}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "3052 N 16th St",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "800 E. Camelback Road",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1588 E. Bethany Home Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "3239 E. Indian School Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85044,region => "Arizona",region_abbr => "AZ",street_1 => "3961 E Chandler Blvd",street_2 => undef}
{city => "Prescott",postal_code => 86301,region => "Arizona",region_abbr => "AZ",street_1 => "330 West Gurley Street",street_2 => undef}
{city => "Prescott",postal_code => 86305,region => "Arizona",region_abbr => "AZ",street_1 => "1112 Iron Springs Road",street_2 => undef}
{city => "Prescott",postal_code => 86301,region => "Arizona",region_abbr => "AZ",street_1 => "1781 E. Hwy 69",street_2 => "Ste. 33"}
{city => "Prescott",postal_code => 86303,region => "Arizona",region_abbr => "AZ",street_1 => "432 W Goodwin St",street_2 => undef}
{city => "Scottsdale",postal_code => 85151,region => "Arizona",region_abbr => "AZ",street_1 => "7014 East Camelback Road #2276",street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7114 E Stetson Dr #105",street_2 => undef}
{city => "Scottsdale",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "6949 E Shea Blvd",street_2 => undef}
{city => "Scottsdale",postal_code => 85257,region => "Arizona",region_abbr => "AZ",street_1 => "7051 E. McDowell Rd.",street_2 => undef}
{city => "Scottsdale",postal_code => 85255,region => "Arizona",region_abbr => "AZ",street_1 => "17040 N. Scottsdale Rd.",street_2 => undef}
{city => "Scottsdale",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "16447 N. Scottsdale Rd. Ste 101",street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7210 E 1st Ave.",street_2 => undef}
{city => "Scottsdale",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "16405 N Scottsdale Rd",street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7131 East Main St",street_2 => undef}
{city => "Scottsdale",postal_code => 85260,region => "Arizona",region_abbr => "AZ",street_1 => "7318 E Shea Blvd",street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7373 E Scottsdale Mall",street_2 => "#1"}
{city => "Scottsdale",postal_code => 85255,region => "Arizona",region_abbr => "AZ",street_1 => "7605 E. Pinnacle Peak Rd",street_2 => undef}
{city => "Scottsdale",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "15111 N Hayden Rd",street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "1595 W. Hwy 89A",street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "1885 West Highway 89A",street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "1610 West Highway 89A",street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "1420 West Highway 89A",street_2 => undef}
{city => "Sedona",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "336 Highway 179",street_2 => undef}
{city => "Sedona",postal_code => 86339,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "3190 W Highway 89A",street_2 => undef}
{city => "Sedona",postal_code => 86339,region => "Arizona",region_abbr => "AZ",street_1 => "321 N. Hwy. 89A",street_2 => undef}
{city => "Sedona",postal_code => "86351-7990",region => "Arizona",region_abbr => "AZ",street_1 => "6446 Highway 179",street_2 => "#221"}
{city => "Sierra Vista",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "2075 El Mercado Loop",street_2 => undef}
{city => "Sierra Vista",postal_code => 85635,region => "Arizona",region_abbr => "AZ",street_1 => "1221 E. Fry Blvd.",street_2 => undef}
{city => "Sierra Vista",postal_code => 85635,region => "Arizona",region_abbr => "AZ",street_1 => "80 S Carmichael Ave",street_2 => undef}
{city => "Sierra Vista",postal_code => 85635,region => "Arizona",region_abbr => "AZ",street_1 => "1481 E. Fry Blvd Ste 3",street_2 => undef}
{city => "Sierra Vista",postal_code => 85635,region => "Arizona",region_abbr => "AZ",street_1 => "465 E. Fry Blvd",street_2 => undef}
{city => "Sierra Vista",postal_code => 85635,region => "Arizona",region_abbr => "AZ",street_1 => "400 W. Fry Blvd",street_2 => undef}
{city => "Sonoita",postal_code => 85637,region => "Arizona",region_abbr => "AZ",street_1 => "3252 Highway 82",street_2 => undef}
{city => "Sonoita",postal_code => 85637,region => "Arizona",region_abbr => "AZ",street_1 => " 3119 State Highway 83",street_2 => "PO Box 513"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => " 1874 E Apache Blvd",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "939 E. Guadulupe Rd",street_2 => "#1"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "933 E University Dr",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "752 W Elliot Rd",street_2 => undef}
{city => "Tempe",postal_code => 85284,region => "Arizona",region_abbr => "AZ",street_1 => "1761 E. Warner Rd.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1044 S. Terrace Road",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "5120 S Rural Rd",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "818 W Broadway Rd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1849 N Scottsdale Rd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "933 E. University Dr. #115",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "2000 E Rio Salado Pkwy",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1125 E. Apache Blvd.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "740 South Mill Avenue",street_2 => undef}
{city => "Tempe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1806 E Southern Ave",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "1801 E. Baseline Rd.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "960 W. University Dr.",street_2 => undef}
{city => "Tempe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1805 E. Elliot Road",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "1845 E Broadway Rd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "505 S Mill Ave",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1250 E. Apache Blvd",street_2 => "#116"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "414 S. Mill Ave.",street_2 => "#111"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "414 S Mill Ave",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1513 E. Apache Blvd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1310 E. Apache Blvd.",street_2 => undef}
{city => "Tempe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "5150 S Rural Rd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1435 E. University Dr",street_2 => "Suite C111-C112"}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "6428 S McClintock Dr",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "3332 South Mill Avenue",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1212 E. Apache Blvd.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "524 W. University Drive",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "616 S. Forest Ave.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "403 W. University Drive",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "1701 East Guadalupe Road",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1636 N Scottsdale Rd.",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "325 W. Elliot Rd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "849 W. University Avenue",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1250 E. Apache Blvd.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "2240 N Scottsdale Rd.",street_2 => "#8"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "920 E. University Drive",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "2000 East Rio Salado Pkwy; Suite 1151",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "933 E. University Drive",street_2 => "#112"}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "1706 E Southern Ave.",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1020 S Mill Ave",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "710 W Elliot Rd",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "6438 S. McClintock Drive",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "120 E. University Ave.",street_2 => "Suite C"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "960 W. University Drive",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1730 E Warner Rd",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "628 North 4th Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "412 N 4th Ave",street_2 => undef}
{city => "Tucson",postal_code => "85712-4633",region => "Arizona",region_abbr => "AZ",street_1 => "4645 E. Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => "85710-3943",region => "Arizona",region_abbr => "AZ",street_1 => "7877 E. Broadway Blvd",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1219 S. Sixth Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "853 East Grant Road",street_2 => undef}
{city => "Tucson",postal_code => 85741,region => "Arizona",region_abbr => "AZ",street_1 => "3936 West Ina Road",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "150 W. Fort Lowell Road",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2731 E. Broadway Boulevard",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "429 North 4th Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "2660 North Campbell Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "2616 N Campbell Ave",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "533 N. 4th Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "5849 North Oracle Road",street_2 => undef}
{city => "Tucson",postal_code => 85711,region => "Arizona",region_abbr => "AZ",street_1 => "5039 East 5th Street",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "519 N. 4th Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2545 East Speedway Boulevard",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "6202 E. Broadway Boulevard",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "711 East Blacklidge Drive",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "810 East University Boulevard",street_2 => undef}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "88 East Broadway Boulevard",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "1072 N Campbell Ave",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "401 E Limberlost",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "4420 N. Stone Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "3360 E. Speedway Boulevard",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2510 E Grant Rd",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "6751 E. Broadway Blvd.",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1521 N. Wilmot",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1710 E. Speedway Blvd.",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "3011 E Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "3699 N. Campbell Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "7133 North Oracle Road",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "2005 E Broadway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2921 E Fort Lowell Rd",street_2 => undef}
{city => "Tucson",postal_code => 85749,region => "Arizona",region_abbr => "AZ",street_1 => "9105 East Tanque Verde",street_2 => "#103"}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "606 N 4th Ave",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2516 E.6th Street",street_2 => undef}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "311 East Congress Street",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "119 E. Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "2727 N. Campbell Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "3200 N 1st Ave",street_2 => undef}
{city => "Tucson",postal_code => 85718,region => "Arizona",region_abbr => "AZ",street_1 => "1805 E. River Road",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "743 N. 4th Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2545 E. Broadway Blvd.",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "1749 North Oracle Road",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "614 N Grande Ave",street_2 => undef}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "375 S. Stone Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "2990 N. Campbell, Ste. 120",street_2 => undef}
{city => "Tucson",postal_code => 85741,region => "Arizona",region_abbr => "AZ",street_1 => "4229 W Ina Rd",street_2 => undef}
{city => "Tucson",postal_code => 85741,region => "Arizona",region_abbr => "AZ",street_1 => "3780 W Ina Rd",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2545 E. Broadway Blvd.",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "3026 N Campbell Ave",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "6260 E Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "1730 E. Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85712,region => "Arizona",region_abbr => "AZ",street_1 => "4654 E. Speedway",street_2 => undef}
{city => "Tucson",postal_code => 85748,region => "Arizona",region_abbr => "AZ",street_1 => "105 S. Houghton",street_2 => "#149"}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "605 N. 4th Ave.",street_2 => undef}
{city => "Tucson",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "7315 N. Oracle Rd",street_2 => undef}
{city => "Tucson",postal_code => 85715,region => "Arizona",region_abbr => "AZ",street_1 => "7159 E. Tanque Verde",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "2707 East Broadway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "905 E University Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85712,region => "Arizona",region_abbr => "AZ",street_1 => "2990 N. Swan Rd.",street_2 => undef}
{city => "Tucson",postal_code => 85716,region => "Arizona",region_abbr => "AZ",street_1 => "3250 E Speedway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "622 N 4th Ave",street_2 => undef}
{city => "Tucson",postal_code => 85711,region => "Arizona",region_abbr => "AZ",street_1 => "5285 E. Broadway Boulevard",street_2 => "Williams Center"}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "756 S Stone Ave",street_2 => undef}
{city => "Yuma",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "600 W. 3rd Street",street_2 => undef}
{city => "Fayetteville",postal_code => 72703,region => "Arkansas",region_abbr => "AR",street_1 => "1554 N College Ave",street_2 => "Evelyn Hills Shopping Center"}
{city => "Fayetteville",postal_code => 72701,region => "Arkansas",region_abbr => "AR",street_1 => "4703 N. Crossover Rd.",street_2 => undef}
{city => "Fayetteville",postal_code => 72701,region => "Arkansas",region_abbr => "AR",street_1 => "#1 W Center St.",street_2 => undef}
{city => "Fayetteville",postal_code => 72703,region => "Arkansas",region_abbr => "AR",street_1 => "1460 E. Augustine Lane",street_2 => undef}
{city => "Fayetteville",postal_code => 72701,region => "Arkansas",region_abbr => "AR",street_1 => "344 Combs Ave.",street_2 => undef}
{city => "Hot Springs National Park",postal_code => 71913,region => "Arkansas",region_abbr => "AR",street_1 => "225 Pinewood Street",street_2 => undef}
{city => "Little Rock",postal_code => 72212,region => "Arkansas",region_abbr => "AR",street_1 => "10700 N Rodney Parham Rd",street_2 => undef}
{city => "Little Rock",postal_code => undef,region => "Arkansas",region_abbr => "AR",street_1 => "12111 West Markham Street",street_2 => undef}
{city => "Little Rock",postal_code => undef,region => "Arkansas",region_abbr => "AR",street_1 => "200 S. Commerce",street_2 => "Suite 150"}
{city => "Cave Creek",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "6602 E. Cave Creek Road",street_2 => undef}
{city => "Chandler",postal_code => 85224,region => "Arizona",region_abbr => "AZ",street_1 => "918 North Alma School Rd",street_2 => undef}
{city => "Chandler",postal_code => 85286,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Chandler",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Chandler",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "4929 W Chandler Blvd",street_2 => undef}
{city => "Chandler",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "1940 S. Alma School Rd",street_2 => undef}
{city => "Cottonwood",postal_code => 86326,region => "Arizona",region_abbr => "AZ",street_1 => "468 S. Main St.",street_2 => undef}
{city => "Dolan Springs",postal_code => 86441,region => "Arizona",region_abbr => "AZ",street_1 => "16015 N. Pierce Ferry Rd.",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "120 North Leroux St.",street_2 => "Suit 104"}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "801 S Milton Ave Unit \"A\"",street_2 => undef}
{city => "Flagstaff",postal_code => 96004,region => "Arizona",region_abbr => "AZ",street_1 => "115 S. San Francisco Street",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "6 E Aspen Ave",street_2 => undef}
{city => "Flagstaff",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "10 N. San Francisco Street",street_2 => undef}
{city => "Flagstaff",postal_code => 86001,region => "Arizona",region_abbr => "AZ",street_1 => "117 S. San Francisco St.",street_2 => undef}
{city => "Gilbert",postal_code => 85234,region => "Arizona",region_abbr => "AZ",street_1 => "1674 N Higley Rd",street_2 => undef}
{city => "Gilbert",postal_code => 85234,region => "Arizona",region_abbr => "AZ",street_1 => "3641 E Baseline Rd",street_2 => undef}
{city => "Gilbert",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "2048 E. Baseline Road",street_2 => undef}
{city => "Gilbert",postal_code => 85295,region => "Arizona",region_abbr => "AZ",street_1 => "1431 E. Williams Field Rd.",street_2 => "Suite 101"}
{city => "Glendale",postal_code => 85308,region => "Arizona",region_abbr => "AZ",street_1 => "5060 W Bell Rd",street_2 => undef}
{city => "Glendale",postal_code => 85305,region => "Arizona",region_abbr => "AZ",street_1 => "9404 W Westgate Blvd",street_2 => undef}
{city => "Glendale",postal_code => 85308,region => "Arizona",region_abbr => "AZ",street_1 => "5625 W Bell Rd",street_2 => undef}
{city => "Glendale",postal_code => 85304,region => "Arizona",region_abbr => "AZ",street_1 => "8806 N 43rd Ave",street_2 => undef}
{city => "Grand Canyon",postal_code => 86023,region => "Arizona",region_abbr => "AZ",street_1 => "Highway 64",street_2 => undef}
{city => "Mesa",postal_code => 85202,region => "Arizona",region_abbr => "AZ",street_1 => "1941 W Guadalupe Rd",street_2 => "Suite 101"}
{city => "Mesa",postal_code => 85204,region => "Arizona",region_abbr => "AZ",street_1 => "1315 South Gilbert Rd",street_2 => undef}
{city => "Mesa",postal_code => 85202,region => "Arizona",region_abbr => "AZ",street_1 => "1245 W. Baseline Road, #101",street_2 => undef}
{city => "Mesa",postal_code => 85202,region => "Arizona",region_abbr => "AZ",street_1 => "66 S.Dobson Rd (No.133-135 Mekong Plaza)",street_2 => undef}
{city => "Mesa",postal_code => 85210,region => "Arizona",region_abbr => "AZ",street_1 => "1440 S. Country Club Dr. Suite 10",street_2 => undef}
{city => "Paradise Valley",postal_code => 85028,region => "Arizona",region_abbr => "AZ",street_1 => "10855 N. Tatum Blvd",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "108 E. Pierce St",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "4773 N. 20th St",street_2 => undef}
{city => "Phoenix",postal_code => 85053,region => "Arizona",region_abbr => "AZ",street_1 => "2737 W Thunderbird Rd #108",street_2 => undef}
{city => "Phoenix",postal_code => 85032,region => "Arizona",region_abbr => "AZ",street_1 => "3202 E Greenway Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85014,region => "Arizona",region_abbr => "AZ",street_1 => "1590 E. Bethany Home Road",street_2 => undef}
{city => "Phoenix",postal_code => 85020,region => "Arizona",region_abbr => "AZ",street_1 => "9120 North Central Avenue",street_2 => undef}
{city => "Phoenix",postal_code => 85020,region => "Arizona",region_abbr => "AZ",street_1 => "13046 N. Cave Creek Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "4340 E. Indian School Rd.",street_2 => undef}
{city => "Phoenix",postal_code => 85015,region => "Arizona",region_abbr => "AZ",street_1 => "4550 N. 19th Ave.",street_2 => undef}
{city => "Phoenix",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "905 N. 4th St",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => "3239 East Indian School Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "53 W Thomas Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85016,region => "Arizona",region_abbr => "AZ",street_1 => "2502 E Camelback Rd, #135",street_2 => undef}
{city => "Phoenix",postal_code => 85015,region => "Arizona",region_abbr => "AZ",street_1 => "5501 N. Seventh Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "814 N. Central Ave",street_2 => undef}
{city => "Phoenix",postal_code => 85004,region => "Arizona",region_abbr => "AZ",street_1 => "901 N. 5th St",street_2 => undef}
{city => "Phoenix",postal_code => 85020,region => "Arizona",region_abbr => "AZ",street_1 => "9832 N. Seventh St.",street_2 => undef}
{city => "Phoenix",postal_code => 85018,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Phoenix",postal_code => 85006,region => "Arizona",region_abbr => "AZ",street_1 => "2022 North 7th Street",street_2 => undef}
{city => "Phoenix",postal_code => 85048,region => "Arizona",region_abbr => "AZ",street_1 => "4949 E Chandler Blvd",street_2 => undef}
{city => "Phoenix",postal_code => 85085,region => "Arizona",region_abbr => "AZ",street_1 => "2490 W Happy Valley Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85053,region => "Arizona",region_abbr => "AZ",street_1 => "4255 W Bell Rd",street_2 => undef}
{city => "Phoenix",postal_code => 85007,region => "Arizona",region_abbr => "AZ",street_1 => "1301 NW Grand Avenue",street_2 => undef}
{city => "Phoenix",postal_code => 85048,region => "Arizona",region_abbr => "AZ",street_1 => "4025 E. Chandler Blvd.",street_2 => undef}
{city => "Phoenix",postal_code => 85308,region => "Arizona",region_abbr => "AZ",street_1 => "3515 W Union Hills Dr",street_2 => undef}
{city => "Scottsdale",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "7119 E. Shea Blvd",street_2 => undef}
{city => "Scottsdale",postal_code => 85254,region => "Arizona",region_abbr => "AZ",street_1 => "13802 N Scottsdale Rd",street_2 => undef}
{city => "Scottsdale",postal_code => 85255,region => "Arizona",region_abbr => "AZ",street_1 => "10980 E Meadowhill Dr",street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7147 E Rancho Vista Drive",street_2 => "(entrance on Highland Ave, north side of the street)"}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "4400 N. Scottsdale Road",street_2 => undef}
{city => "Scottsdale",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Scottsdale",postal_code => 85251,region => "Arizona",region_abbr => "AZ",street_1 => "7027 E. 5th Avenue",street_2 => undef}
{city => "Sedona",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "2986 W. Highway 89A",street_2 => undef}
{city => "Sedona",postal_code => 96336,region => "Arizona",region_abbr => "AZ",street_1 => "1595 West Hwy 89A",street_2 => undef}
{city => "Sedona",postal_code => 86336,region => "Arizona",region_abbr => "AZ",street_1 => "671 Hwy 179",street_2 => "#E-ST1"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "130 E. University Drive",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "1731 East Broadway Road",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "933 E University Dr",street_2 => "#108"}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "933 East University",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "815 W University Dr",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1872 E Apache Blvd",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "1290 S. Normal Ave",street_2 => "Memorial Union, 2nd Floor"}
{city => "Tempe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "Mill Avenue",street_2 => undef}
{city => "Tempe",postal_code => 85281,region => "Arizona",region_abbr => "AZ",street_1 => "555 N. Scottsdale Rd",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "5118 S. Rural Rd",street_2 => undef}
{city => "Tempe",postal_code => 85283,region => "Arizona",region_abbr => "AZ",street_1 => "1813 E Baseline Road, Ste 108",street_2 => undef}
{city => "Tempe",postal_code => 85282,region => "Arizona",region_abbr => "AZ",street_1 => "3141 S. McClintock Drive",street_2 => "Suite #10"}
{city => "Tempe",postal_code => 85284,region => "Arizona",region_abbr => "AZ",street_1 => "4980 W Ray Road",street_2 => undef}
{city => "Tempe",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => undef,street_2 => undef}
{city => "Tucson",postal_code => 85705,region => "Arizona",region_abbr => "AZ",street_1 => "606 N. 4th Avenue",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "7037 N Oracle Rd",street_2 => undef}
{city => "Tucson",postal_code => 85715,region => "Arizona",region_abbr => "AZ",street_1 => "7065 E Tanque Verde Rd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "874 E. University Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "Main Gate Square",street_2 => "972 E. University Blvd."}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "940 N. Olsen Ave",street_2 => undef}
{city => "Tucson",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "7892 N. Oracle Road",street_2 => undef}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "311 N. Court Avenue",street_2 => undef}
{city => "Tucson",postal_code => 85704,region => "Arizona",region_abbr => "AZ",street_1 => "7366 North Paseo del Norte",street_2 => "Tohono Chul Park"}
{city => "Tucson",postal_code => 85711,region => "Arizona",region_abbr => "AZ",street_1 => "5612 E. Broadway Blvd",street_2 => undef}
{city => "Tucson",postal_code => 85713,region => "Arizona",region_abbr => "AZ",street_1 => "1745 W. Ajo",street_2 => undef}
{city => "Tucson",postal_code => 85706,region => "Arizona",region_abbr => "AZ",street_1 => "3954 N. Oracle",street_2 => undef}
{city => "Tucson",postal_code => 85712,region => "Arizona",region_abbr => "AZ",street_1 => "4841 E. Speedway Blvd.",street_2 => undef}
{city => "Tucson",postal_code => 85718,region => "Arizona",region_abbr => "AZ",street_1 => "3770 E Sunrise Dr",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "3025 N Campbell Ave",street_2 => undef}
{city => "Tucson",postal_code => undef,region => "Arizona",region_abbr => "AZ",street_1 => "845 E. University Blvd",street_2 => "Suite 185"}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "943 E. University Blvd.",street_2 => "Suite 165"}
{city => "Tucson",postal_code => 85701,region => "Arizona",region_abbr => "AZ",street_1 => "201 N. Court Ave",street_2 => undef}
{city => "Tucson",postal_code => 85719,region => "Arizona",region_abbr => "AZ",street_1 => "1911 E Grant Rd",street_2 => undef}
{city => "Wellton",postal_code => 85356,region => "Arizona",region_abbr => "AZ",street_1 => "28881 Commerce Way",street_2 => "D-2"}
{city => "Yuma",postal_code => 85364,region => "Arizona",region_abbr => "AZ",street_1 => "2905 4th Avenue",street_2 => undef}
{city => "Alhambra",postal_code => 91801,region => "California",region_abbr => "CA",street_1 => "621 W Main Street",street_2 => undef}
{city => "Aliso Viejo",postal_code => 92656,region => "California",region_abbr => "CA",street_1 => "26705 Aliso Creek Rd",street_2 => undef}
{city => "Altadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "2260 N. Lincoln Ave.",street_2 => undef}
{city => "Anaheim",postal_code => 92801,region => "California",region_abbr => "CA",street_1 => "3070 W. Lincoln Ave",street_2 => "Suite \"E\""}
{city => "Anaheim Hills",postal_code => 92807,region => "California",region_abbr => "CA",street_1 => "5759 E Santa Ana Canyon Rd.",street_2 => undef}
{city => "Arcata",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2461 Alliance Road",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "65 Frank Martin Court",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18701 Pioneer Blvd.",street_2 => undef}
{city => "Auburn",postal_code => 95603,region => "California",region_abbr => "CA",street_1 => "660 Auburn Folsom Road",street_2 => undef}
{city => "Bakersfield",postal_code => 93309,region => "California",region_abbr => "CA",street_1 => "4308 California Avenue",street_2 => undef}
{city => "Bakersfield",postal_code => 93309,region => "California",region_abbr => "CA",street_1 => "1715 S. Real Road",street_2 => undef}
{city => "Bakersfield",postal_code => 93301,region => "California",region_abbr => "CA",street_1 => "1918 G Street",street_2 => undef}
{city => "Baywood Park",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "690 Santa Maria Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2700 Hearst\tAvenue",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2395 Telegraph Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94707,region => "California",region_abbr => "CA",street_1 => "1823 Solano Ave.",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "1926 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94609,region => "California",region_abbr => "CA",street_1 => "2156 University Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2132 Oxford Street",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1701 San Pablo Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2200 Oxford St.",street_2 => undef}
{city => "Berkeley",postal_code => 94703,region => "California",region_abbr => "CA",street_1 => "3031 Adeline St.",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2016 Shattuck Ave.",street_2 => undef}
{city => "Burbank",postal_code => 91502,region => "California",region_abbr => "CA",street_1 => "144 N. San Fernando Blvd",street_2 => undef}
{city => "Burbank",postal_code => 91505,region => "California",region_abbr => "CA",street_1 => "2515 W. Magnolia Blvd.",street_2 => undef}
{city => "Burbank",postal_code => 91505,region => "California",region_abbr => "CA",street_1 => "2918 W. Magnolia Blvd",street_2 => undef}
{city => "Burlingame",postal_code => 94010,region => "California",region_abbr => "CA",street_1 => "1213 Burlingame Avenue",street_2 => undef}
{city => "Calabasas",postal_code => 91302,region => "California",region_abbr => "CA",street_1 => "4751 Commons Way",street_2 => undef}
{city => "Camarillo",postal_code => 93010,region => "California",region_abbr => "CA",street_1 => "330 N. Lantana St.",street_2 => "Paseo Camarillo Plaza, Suite 31"}
{city => "Cameron Park",postal_code => 95682,region => "California",region_abbr => "CA",street_1 => "2647 Cameron Park Dr",street_2 => undef}
{city => "Campbell",postal_code => 95008,region => "California",region_abbr => "CA",street_1 => "379 East Campbell Avenue",street_2 => undef}
{city => "Campbell",postal_code => 95008,region => "California",region_abbr => "CA",street_1 => "1875 S Bascom Avenue",street_2 => "#300"}
{city => "Campbell",postal_code => 95008,region => "California",region_abbr => "CA",street_1 => "2006 Winchester Blvd.",street_2 => undef}
{city => "Capitola",postal_code => 95010,region => "California",region_abbr => "CA",street_1 => "1210 41st Ave",street_2 => undef}
{city => "Carlsbad",postal_code => 92008,region => "California",region_abbr => "CA",street_1 => "300 Carlsbad Village Drive",street_2 => undef}
{city => "Carlsbad",postal_code => 92009,region => "California",region_abbr => "CA",street_1 => "1923 Calle Barcelona",street_2 => undef}
{city => "Cathedral City",postal_code => 92234,region => "California",region_abbr => "CA",street_1 => "68-718 E Palm Canyon",street_2 => undef}
{city => "Cerritos",postal_code => 90703,region => "California",region_abbr => "CA",street_1 => "11329 183rd St.",street_2 => undef}
{city => "Cerritos",postal_code => 90703,region => "California",region_abbr => "CA",street_1 => "13349 Artesia Blvd",street_2 => undef}
{city => "Chico",postal_code => 95926,region => "California",region_abbr => "CA",street_1 => "931 W. Fifth St.",street_2 => undef}
{city => "Chico",postal_code => 95973,region => "California",region_abbr => "CA",street_1 => "4673 Nord Highway",street_2 => undef}
{city => "Chico",postal_code => 95926,region => "California",region_abbr => "CA",street_1 => "117 W 2nd Avenue",street_2 => undef}
{city => "Chico",postal_code => 95929,region => "California",region_abbr => "CA",street_1 => "2574 Esplanade",street_2 => undef}
{city => "Chico",postal_code => 95928,region => "California",region_abbr => "CA",street_1 => "800 Broadway St.",street_2 => undef}
{city => "Chino Hills",postal_code => 91709,region => "California",region_abbr => "CA",street_1 => "15390 Fairfield Ranch Rd.",street_2 => "Ste. G"}
{city => "Clovis",postal_code => 93611,region => "California",region_abbr => "CA",street_1 => "1785 Herndon Avenue",street_2 => "Suite 102"}
{city => "Clovis",postal_code => 93612,region => "California",region_abbr => "CA",street_1 => "80 W. Shaw Avenue",street_2 => undef}
{city => "Costa Mesa",postal_code => 92627,region => "California",region_abbr => "CA",street_1 => "1890 Newport Blvd.",street_2 => undef}
{city => "Costa Mesa",postal_code => 92626,region => "California",region_abbr => "CA",street_1 => "2930 Bristol St.",street_2 => undef}
{city => "Costa Mesa",postal_code => 92627,region => "California",region_abbr => "CA",street_1 => "2642 Newport Blvd.",street_2 => undef}
{city => "Costa Mesa",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Costa Mesa",postal_code => 92626,region => "California",region_abbr => "CA",street_1 => "2981 Bristol Street",street_2 => undef}
{city => "Cotati",postal_code => 94931,region => "California",region_abbr => "CA",street_1 => "8240 Old Redwood Hwy",street_2 => undef}
{city => "Culver City",postal_code => 90232,region => "California",region_abbr => "CA",street_1 => "9343 Culver Blvd.",street_2 => undef}
{city => "Culver City",postal_code => 90232,region => "California",region_abbr => "CA",street_1 => "9018 Venice Blvd",street_2 => undef}
{city => "Culver City",postal_code => 90232,region => "California",region_abbr => "CA",street_1 => "10700 Washington Blvd",street_2 => undef}
{city => "Culver City",postal_code => 90232,region => "California",region_abbr => "CA",street_1 => "10408 Venice Boulevard",street_2 => undef}
{city => "Culver City",postal_code => 90230,region => "California",region_abbr => "CA",street_1 => "4437 Sepulveda Blvd.",street_2 => undef}
{city => "Culver City",postal_code => 90232,region => "California",region_abbr => "CA",street_1 => "9523 Culver Blvd",street_2 => undef}
{city => "Cupertino",postal_code => 95014,region => "California",region_abbr => "CA",street_1 => "10310 S. De Anza Blvd",street_2 => undef}
{city => "Cupertino",postal_code => 95014,region => "California",region_abbr => "CA",street_1 => "20955 Stevens Creek Blvd",street_2 => "Inside Whole Foods"}
{city => "Danville",postal_code => 94523,region => "California",region_abbr => "CA",street_1 => "720 Camino Ramon",street_2 => undef}
{city => "Danville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "480 San Ramon Valley Blvd",street_2 => undef}
{city => "Davis",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "207 3rd Street",street_2 => "#230"}
{city => "Dublin",postal_code => 94568,region => "California",region_abbr => "CA",street_1 => "4640 Tassajara Road",street_2 => undef}
{city => "Eagle Rock",postal_code => 90041,region => "California",region_abbr => "CA",street_1 => "2006 Colorado Blvd",street_2 => undef}
{city => "Eagle Rock",postal_code => 90041,region => "California",region_abbr => "CA",street_1 => "2122 1/2 Colorado Blvd",street_2 => undef}
{city => "El Granada",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "425 Alhambra Avenue",street_2 => undef}
{city => "Elk Grove",postal_code => 95758,region => "California",region_abbr => "CA",street_1 => "8355 Elk Grove Blvd.",street_2 => undef}
{city => "Emeryville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5614 Bay Street",street_2 => undef}
{city => "Emeryville",postal_code => 94608,region => "California",region_abbr => "CA",street_1 => "4081 Hollis Street",street_2 => undef}
{city => "Encinitas",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "745 S. Coast Hwy. 101, Ste. J103",street_2 => undef}
{city => "Encinitas",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "288 N. El Camino Real",street_2 => undef}
{city => "Encinitas",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "765 South Coast Highway 101",street_2 => undef}
{city => "Encino",postal_code => 91436,region => "California",region_abbr => "CA",street_1 => "15826 Ventura Blvd.",street_2 => "2nd floor"}
{city => "Escondido",postal_code => 92025,region => "California",region_abbr => "CA",street_1 => "1633 S. Centre City Pkwy.",street_2 => undef}
{city => "Eureka",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1707 W. Allard Avenue",street_2 => undef}
{city => "Eureka",postal_code => 95501,region => "California",region_abbr => "CA",street_1 => "821 D Street",street_2 => undef}
{city => "Fairfax",postal_code => 94930,region => "California",region_abbr => "CA",street_1 => "31 Bolinas Road",street_2 => undef}
{city => "Fairfax",postal_code => 94930,region => "California",region_abbr => "CA",street_1 => "1912 Sir Francis Drake Blvd.",street_2 => undef}
{city => "Fairfield",postal_code => 94533,region => "California",region_abbr => "CA",street_1 => "1501 Travis Blvd.",street_2 => undef}
{city => "Folsom",postal_code => 95630,region => "California",region_abbr => "CA",street_1 => "1760 Prairie City Road",street_2 => "#160"}
{city => "Folsom",postal_code => 95630,region => "California",region_abbr => "CA",street_1 => "727 Sutter St",street_2 => undef}
{city => "Folsom",postal_code => 95630,region => "California",region_abbr => "CA",street_1 => "1300 E Bidwell St #120",street_2 => undef}
{city => "Folsom",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2585 Iron Point Road",street_2 => undef}
{city => "Fort Bragg",postal_code => 95437,region => "California",region_abbr => "CA",street_1 => "301-B North Main Street",street_2 => undef}
{city => "Foster City",postal_code => 94404,region => "California",region_abbr => "CA",street_1 => "1457 Beach Park Blvd",street_2 => undef}
{city => "Fremont",postal_code => 94538,region => "California",region_abbr => "CA",street_1 => "5355 Mowry Ave",street_2 => undef}
{city => "Fresno",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3747 West Shaw Avenue",street_2 => undef}
{city => "Fresno",postal_code => 93720,region => "California",region_abbr => "CA",street_1 => "1134 E. Champlain Dr. Suite 108",street_2 => undef}
{city => "Fresno",postal_code => 93728,region => "California",region_abbr => "CA",street_1 => "1292 N. Wishon Avenue",street_2 => undef}
{city => "Fresno",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Fresno",postal_code => 93728,region => "California",region_abbr => "CA",street_1 => "747 E. Olive Avenue",street_2 => undef}
{city => "Fresno",postal_code => 93728,region => "California",region_abbr => "CA",street_1 => "1495 North Van Ness Ave.",street_2 => undef}
{city => "Fresno",postal_code => 93722,region => "California",region_abbr => "CA",street_1 => "3055 W. Ashlan Ave.",street_2 => undef}
{city => "Fresno",postal_code => 93721,region => "California",region_abbr => "CA",street_1 => "1031 U St",street_2 => undef}
{city => "Fresno",postal_code => 93711,region => "California",region_abbr => "CA",street_1 => "3173 W. Shaw Avenue",street_2 => undef}
{city => "Fresno",postal_code => 93728,region => "California",region_abbr => "CA",street_1 => "1495 N. Van Ness Avenue",street_2 => undef}
{city => "Fullerton",postal_code => 92832,region => "California",region_abbr => "CA",street_1 => "108 W. Wilshire",street_2 => undef}
{city => "Gardena",postal_code => 90247,region => "California",region_abbr => "CA",street_1 => "16440 S. Western Avenue",street_2 => undef}
{city => "Glendale",postal_code => 91206,region => "California",region_abbr => "CA",street_1 => "1501 E Chevy Chase Dr",street_2 => undef}
{city => "Glendale",postal_code => 91202,region => "California",region_abbr => "CA",street_1 => "1200 N. Pacific Avenue",street_2 => undef}
{city => "Goleta",postal_code => 93117,region => "California",region_abbr => "CA",street_1 => "5869 Hollister Avenue",street_2 => undef}
{city => "Grass Valley",postal_code => 95945,region => "California",region_abbr => "CA",street_1 => "102 N. Richardson Street",street_2 => undef}
{city => "Half Moon Bay",postal_code => 94019,region => "California",region_abbr => "CA",street_1 => "408 Main Street",street_2 => undef}
{city => "Healdsburg",postal_code => 95448,region => "California",region_abbr => "CA",street_1 => "29 North Street",street_2 => undef}
{city => "Hollywood",postal_code => 90038,region => "California",region_abbr => "CA",street_1 => "1253 N. Vine Street",street_2 => undef}
{city => "Hollywood",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "5170 Hollywood Blvd",street_2 => undef}
{city => "Hollywood",postal_code => 90038,region => "California",region_abbr => "CA",street_1 => "5601 Melrose Avenue",street_2 => undef}
{city => "Hollywood",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "5140 W Sunset Blvd",street_2 => undef}
{city => "Huntington Beach",postal_code => 92649,region => "California",region_abbr => "CA",street_1 => "3801 Warner Ave",street_2 => "Unit B"}
{city => "Huntington Beach",postal_code => 92646,region => "California",region_abbr => "CA",street_1 => "19891 Brookhurst St",street_2 => undef}
{city => "Huntington Beach",postal_code => 92647,region => "California",region_abbr => "CA",street_1 => "7636 Edinger Avenue",street_2 => undef}
{city => "Imperial Beach",postal_code => 91932,region => "California",region_abbr => "CA",street_1 => "600 Palm Avenue",street_2 => "Suite 109"}
{city => "Irvine",postal_code => 92606,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Irvine",postal_code => 92618,region => "California",region_abbr => "CA",street_1 => "15435 Jeffrey Road",street_2 => "Suite 110"}
{city => "Irvine",postal_code => 92612,region => "California",region_abbr => "CA",street_1 => "4213 Campus Drive",street_2 => undef}
{city => "Isla Vista",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6575 Seville Road",street_2 => undef}
{city => "Julian",postal_code => 92036,region => "California",region_abbr => "CA",street_1 => "4354 Highway 78",street_2 => undef}
{city => "La Jolla",postal_code => 92037,region => "California",region_abbr => "CA",street_1 => "7857 Girard Avenue",street_2 => undef}
{city => "La Jolla",postal_code => 92037,region => "California",region_abbr => "CA",street_1 => "737 Pearl St.",street_2 => "#113"}
{city => "La Quinta",postal_code => 92253,region => "California",region_abbr => "CA",street_1 => "46-660 Washington",street_2 => undef}
{city => "Ladera Ranch",postal_code => 92694,region => "California",region_abbr => "CA",street_1 => "27522 Antonio Parkway",street_2 => "Suite P2"}
{city => "Laguna Beach",postal_code => 92651,region => "California",region_abbr => "CA",street_1 => "247 Broadway Street",street_2 => undef}
{city => "Laguna Woods",postal_code => 92653,region => "California",region_abbr => "CA",street_1 => "24165 Paseo de Valencia",street_2 => undef}
{city => "Lakeport",postal_code => 95453,region => "California",region_abbr => "CA",street_1 => "495 N. Main St.",street_2 => undef}
{city => "Lancaster",postal_code => 93535,region => "California",region_abbr => "CA",street_1 => "44262 10th St West",street_2 => undef}
{city => "Larkspur",postal_code => 94939,region => "California",region_abbr => "CA",street_1 => "234 Magnolia Avenue",street_2 => undef}
{city => "Leucadia",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "698 North Coast Highway",street_2 => undef}
{city => "Lomita",postal_code => 90717,region => "California",region_abbr => "CA",street_1 => "1841 W. Pacific Coast Hwy",street_2 => undef}
{city => "Los Alamitos",postal_code => 90720,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Alamitos",postal_code => 90720,region => "California",region_abbr => "CA",street_1 => "4390 Katella Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "672 S. La Brea Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1559 Echo Park Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90049,region => "California",region_abbr => "CA",street_1 => "11677 San Vicente Blvd",street_2 => "Ste 300"}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "408 N. La Cienega Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90057,region => "California",region_abbr => "CA",street_1 => "2122 West Seventh Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "8222 1/2 W 3rd St",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7950 W. Sunset Blvd.",street_2 => "Suite 104"}
{city => "Los Angeles",postal_code => 90810,region => "California",region_abbr => "CA",street_1 => "21136 So. Wilmington #300",street_2 => undef}
{city => "Los Angeles",postal_code => 90014,region => "California",region_abbr => "CA",street_1 => "130 E. 6th St.",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1700 W. Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "5406 Wilshire Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1700 W. Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90012,region => "California",region_abbr => "CA",street_1 => "634 N Main St",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "1521 N. Vine St.",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "2100 Echo Park Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8020 Beverly Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90033,region => "California",region_abbr => "CA",street_1 => "1326 East 1st Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "6255 W Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "4449 Prospect Ave",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11361 W. Pico Blvd",street_2 => "West Los Angeles Animal Care Center Community Room"}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5913 W. Franklin Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "6675 Hollywood Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2815 Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90064,region => "California",region_abbr => "CA",street_1 => "11511 W Pico Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "100 Paseo De La Plaza",street_2 => undef}
{city => "Los Angeles",postal_code => 90012,region => "California",region_abbr => "CA",street_1 => "130 W. Bruno St",street_2 => undef}
{city => "Los Angeles",postal_code => 90042,region => "California",region_abbr => "CA",street_1 => "110 N. Avenue 56",street_2 => undef}
{city => "Los Angeles",postal_code => 90042,region => "California",region_abbr => "CA",street_1 => "6312 N. Figueroa Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90210,region => "California",region_abbr => "CA",street_1 => "490 N. Beverly Drive",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8568 Melrose Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90012,region => "California",region_abbr => "CA",street_1 => "269 S. San Pedro Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => "10953 Venice Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "1958 Hillhurst Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "1700 Hillhurst Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1436 West Jefferson Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "1507 Cahuenga Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "5825 Franklin Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90071,region => "California",region_abbr => "CA",street_1 => "300 South Grand Ave",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7564 W. Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90212,region => "California",region_abbr => "CA",street_1 => "267 S. Beverly Drive",street_2 => undef}
{city => "Los Angeles",postal_code => 90013,region => "California",region_abbr => "CA",street_1 => "451 South Hewitt Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7200 Melrose Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90035,region => "California",region_abbr => "CA",street_1 => "9303 W. Pico Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90014,region => "California",region_abbr => "CA",street_1 => "808 S Spring Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "7660 Beverly Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => "10855 Venice Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90066,region => "California",region_abbr => "CA",street_1 => "11510 W. Washington Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90068,region => "California",region_abbr => "CA",street_1 => "2333 Fern Dell Drive",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "Ivar & Selma Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "345 N La Brea Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7313 Melrose Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2135 W. Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "3206 W. Sunset Blvd",street_2 => undef}
{city => "Los Osos",postal_code => 93402,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Malibu",postal_code => 90265,region => "California",region_abbr => "CA",street_1 => "12220 Cotharin Road",street_2 => undef}
{city => "Manhattan Beach",postal_code => 90266,region => "California",region_abbr => "CA",street_1 => "2008 N. Sepulveda Blvd.",street_2 => undef}
{city => "Marina del Rey",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "13352 West Washington Boulevard",street_2 => undef}
{city => "Marina del Rey",postal_code => 90292,region => "California",region_abbr => "CA",street_1 => "4722 1/2 Admiralty Way",street_2 => undef}
{city => "Mendocino",postal_code => 95460,region => "California",region_abbr => "CA",street_1 => "Comptche Ukiah Road and Highway 1",street_2 => undef}
{city => "Midpines",postal_code => 95345,region => "California",region_abbr => "CA",street_1 => "6979 Highway 140",street_2 => undef}
{city => "Mill Valley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "247 Shoreline Highway",street_2 => undef}
{city => "Mill Valley",postal_code => 94941,region => "California",region_abbr => "CA",street_1 => "25 Miller Avenue",street_2 => undef}
{city => "Mill Valley",postal_code => 94941,region => "California",region_abbr => "CA",street_1 => "281A Molino Avenue",street_2 => undef}
{city => "Milpitas",postal_code => 95035,region => "California",region_abbr => "CA",street_1 => "458 Barber Lane",street_2 => undef}
{city => "Milpitas",postal_code => 95035,region => "California",region_abbr => "CA",street_1 => "190 Ranch Drive",street_2 => "McCarthy Ranch"}
{city => "Monterey",postal_code => 93940,region => "California",region_abbr => "CA",street_1 => "470 Alvarado St.",street_2 => undef}
{city => "Monterey",postal_code => 93940,region => "California",region_abbr => "CA",street_1 => "565 Abrego St.",street_2 => undef}
{city => "Monterey",postal_code => 93940,region => "California",region_abbr => "CA",street_1 => "404 Tyler Street",street_2 => undef}
{city => "Monterey Park",postal_code => 91754,region => "California",region_abbr => "CA",street_1 => "321 W. Garvey Avenue",street_2 => undef}
{city => "Mountain View",postal_code => 94041,region => "California",region_abbr => "CA",street_1 => "790 Castro Street",street_2 => undef}
{city => "Mountain View",postal_code => 94041,region => "California",region_abbr => "CA",street_1 => "146 Castro St.",street_2 => undef}
{city => "Murrieta",postal_code => 92563,region => "California",region_abbr => "CA",street_1 => "40365 Murrieta Hot Springs Road",street_2 => undef}
{city => "Napa",postal_code => 94559,region => "California",region_abbr => "CA",street_1 => "1140 Main Street",street_2 => undef}
{city => "Napa",postal_code => 94559,region => "California",region_abbr => "CA",street_1 => "610 First Street",street_2 => "Oxbow Public Market"}
{city => "Nevada City",postal_code => 95959,region => "California",region_abbr => "CA",street_1 => "110 South Pine Street",street_2 => undef}
{city => "Nipomo",postal_code => 93444,region => "California",region_abbr => "CA",street_1 => "181 W. Tefft Street",street_2 => undef}
{city => "North Hollywood",postal_code => 91602,region => "California",region_abbr => "CA",street_1 => "4724 Lankershim Blvd",street_2 => undef}
{city => "North Hollywood",postal_code => 91601,region => "California",region_abbr => "CA",street_1 => "5044 Lankershim Blvd.",street_2 => undef}
{city => "Oakhurst",postal_code => 93644,region => "California",region_abbr => "CA",street_1 => "40120 Highway 41",street_2 => undef}
{city => "Oakland",postal_code => 94611,region => "California",region_abbr => "CA",street_1 => "6464 Moraga Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94607,region => "California",region_abbr => "CA",street_1 => "301 Broadway",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "1442 Franklin Street",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "230 Bay Place",street_2 => "Inside Whole Foods"}
{city => "Oakland",postal_code => 94609,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Oakland",postal_code => 94607,region => "California",region_abbr => "CA",street_1 => "1610 7th St.",street_2 => undef}
{city => "Oakland",postal_code => 94608,region => "California",region_abbr => "CA",street_1 => "6037 San Pablo Ave.",street_2 => undef}
{city => "Oakland",postal_code => 94618,region => "California",region_abbr => "CA",street_1 => "6311 College Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94607,region => "California",region_abbr => "CA",street_1 => "202 Second Street",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "300 13th Street",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "230 Bay Place",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Oakland",postal_code => 94618,region => "California",region_abbr => "CA",street_1 => "6247 College Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "1442 Franklin St.",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "2318 Telegraph Avenue",street_2 => undef}
{city => "Ocean Beach",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "4705 Point Loma Avenue",street_2 => undef}
{city => "Oceanside",postal_code => 92056,region => "California",region_abbr => "CA",street_1 => "3616 Ocean Ranch Boulevard",street_2 => undef}
{city => "Ojai",postal_code => 93023,region => "California",region_abbr => "CA",street_1 => "928 East Ojai Ave.",street_2 => undef}
{city => "Ojai",postal_code => 93023,region => "California",region_abbr => "CA",street_1 => "205 N. Signal Street",street_2 => undef}
{city => "Ojai",postal_code => 93023,region => "California",region_abbr => "CA",street_1 => "339 W. El Roblar Drive",street_2 => undef}
{city => "Old Sacramento",postal_code => 95814,region => "California",region_abbr => "CA",street_1 => "1112 Second St.",street_2 => undef}
{city => "Orange",postal_code => 92866,region => "California",region_abbr => "CA",street_1 => "237 S. Tustin St",street_2 => undef}
{city => "Orange County",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Pacific Grove",postal_code => 93950,region => "California",region_abbr => "CA",street_1 => "1180 Forest Ave.",street_2 => undef}
{city => "Pacifica",postal_code => 94044,region => "California",region_abbr => "CA",street_1 => "444 Manor Plaza",street_2 => undef}
{city => "Palm Desert",postal_code => 92260,region => "California",region_abbr => "CA",street_1 => "73910 Highway 111",street_2 => "Suite D"}
{city => "Palm Desert",postal_code => 92260,region => "California",region_abbr => "CA",street_1 => "74121 Highway 111",street_2 => undef}
{city => "Palm Springs",postal_code => 92264,region => "California",region_abbr => "CA",street_1 => "555 South Sunrise Way",street_2 => undef}
{city => "Palm Springs",postal_code => 92264,region => "California",region_abbr => "CA",street_1 => "611 S Palm Canyon Drive",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "261 University Avenue",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "855 El Camino Real",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "445 S. California Ave.",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3400 El Camino Real",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "460 Ramona Street",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "168 University Ave.",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "644 Emerson Street",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "276 University Ave.",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "441 Emerson Street",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "393 Stanford Shopping Center",street_2 => undef}
{city => "Palo Alto",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "440 University Ave.",street_2 => undef}
{city => "Paradise",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "7534 Canyon View Drive",street_2 => "Feather River Hospital Campus"}
{city => "Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "45 N. San Gabriel Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "696 E Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "319 S Arroyo Parkway",street_2 => undef}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "43 N Fair Oaks Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "37 South Fair Oaks Avenue",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "400 S Arroyo Pkwy",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "633 South Arroyo Parkway",street_2 => "Suite 3"}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "330 E Colorado Blvd",street_2 => "Suite 230"}
{city => "Pasadena",postal_code => 91106,region => "California",region_abbr => "CA",street_1 => "1771 E. Colorado Blvd",street_2 => undef}
{city => "Paso Robles",postal_code => 93446,region => "California",region_abbr => "CA",street_1 => "828 11th St.",street_2 => undef}
{city => "Petaluma",postal_code => 94952,region => "California",region_abbr => "CA",street_1 => "56 E. Washington St",street_2 => undef}
{city => "Pleasant Hill",postal_code => 94523,region => "California",region_abbr => "CA",street_1 => "260 Golf Club Road",street_2 => undef}
{city => "Rancho Bernardo",postal_code => 92128,region => "California",region_abbr => "CA",street_1 => "10511 4S Commons",street_2 => undef}
{city => "Rancho Cordova",postal_code => 95670,region => "California",region_abbr => "CA",street_1 => "10899 Olson Drive",street_2 => undef}
{city => "Rancho Cucamonga",postal_code => 91730,region => "California",region_abbr => "CA",street_1 => "9819 Foothill Blvd",street_2 => "Suite F"}
{city => "Rancho Cucamonga 91701",postal_code => 91701,region => "California",region_abbr => "CA",street_1 => "9456 Roberds St",street_2 => undef}
{city => "Rancho Mirage",postal_code => 92270,region => "California",region_abbr => "CA",street_1 => "34175 Monterey Ave.",street_2 => undef}
{city => "Redding",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1730 Yuba Street",street_2 => "Suite A"}
{city => "Redding",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1320 Placer Street",street_2 => undef}
{city => "Redding",postal_code => 96001,region => "California",region_abbr => "CA",street_1 => "1427 Market Street",street_2 => undef}
{city => "Redding",postal_code => 96002,region => "California",region_abbr => "CA",street_1 => "2937 Churn Creek Road",street_2 => undef}
{city => "Redding",postal_code => 96001,region => "California",region_abbr => "CA",street_1 => "1344 Market Street",street_2 => undef}
{city => "Redding",postal_code => 96002,region => "California",region_abbr => "CA",street_1 => "1712 Churn Creek Road",street_2 => undef}
{city => "Redondo Beach",postal_code => 90277,region => "California",region_abbr => "CA",street_1 => "623 N. Pacific Coast Highway",street_2 => undef}
{city => "Redondo Beach",postal_code => 90277,region => "California",region_abbr => "CA",street_1 => "407 N. Pacific Coast Highway",street_2 => undef}
{city => "Redwood Shores",postal_code => 94065,region => "California",region_abbr => "CA",street_1 => "226 Redwood Shores Parkway",street_2 => undef}
{city => "Richmond",postal_code => 94801,region => "California",region_abbr => "CA",street_1 => "199 Park Pl",street_2 => undef}
{city => "Riverside",postal_code => 92505,region => "California",region_abbr => "CA",street_1 => "11550 Pierce St.",street_2 => undef}
{city => "Riverside",postal_code => 92507,region => "California",region_abbr => "CA",street_1 => "191 Big Springs Road",street_2 => undef}
{city => "Riverside",postal_code => 92501,region => "California",region_abbr => "CA",street_1 => "3575 University Avenue",street_2 => undef}
{city => "Roseville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1151 Galleria Blvd",street_2 => undef}
{city => "Roseville",postal_code => 95661,region => "California",region_abbr => "CA",street_1 => "3984 Douglas Blvd",street_2 => undef}
{city => "Sacramento",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8th St. and I St.",street_2 => undef}
{city => "Sacramento",postal_code => 95811,region => "California",region_abbr => "CA",street_1 => "1310 S street",street_2 => undef}
{city => "Sacramento",postal_code => 95811,region => "California",region_abbr => "CA",street_1 => "1315 21st Street",street_2 => undef}
{city => "Sacramento",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1230 20th Street",street_2 => undef}
{city => "Sacramento",postal_code => 95811,region => "California",region_abbr => "CA",street_1 => "1226 20th Street",street_2 => undef}
{city => "Sacramento",postal_code => 95811,region => "California",region_abbr => "CA",street_1 => "1901 16th Street",street_2 => undef}
{city => "Sacramento",postal_code => 95819,region => "California",region_abbr => "CA",street_1 => "2019 Q Street",street_2 => undef}
{city => "Sacramento",postal_code => 95814,region => "California",region_abbr => "CA",street_1 => "900 12th Street",street_2 => undef}
{city => "Sacramento",postal_code => 95818,region => "California",region_abbr => "CA",street_1 => "3051 Freeport Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95816,region => "California",region_abbr => "CA",street_1 => "2315 K St.",street_2 => undef}
{city => "Sacramento",postal_code => 95841,region => "California",region_abbr => "CA",street_1 => "5800 Madison Ave Suite K",street_2 => undef}
{city => "Sacramento",postal_code => 95814,region => "California",region_abbr => "CA",street_1 => "1815 K Street",street_2 => undef}
{city => "Sacramento",postal_code => 95815,region => "California",region_abbr => "CA",street_1 => "1735 Arden Wy",street_2 => undef}
{city => "Sacramento",postal_code => 95814,region => "California",region_abbr => "CA",street_1 => "1132 16th St",street_2 => undef}
{city => "Sacramento",postal_code => 95837,region => "California",region_abbr => "CA",street_1 => "6850 Airport Blvd",street_2 => "Suite 28"}
{city => "Sacramento",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1735 Arden Way",street_2 => undef}
{city => "Sacramento",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2820 Marconi Avenue",street_2 => undef}
{city => "Sacramento",postal_code => 95818,region => "California",region_abbr => "CA",street_1 => "2968 Freeport Blvd.",street_2 => undef}
{city => "Sacramento",postal_code => 95834,region => "California",region_abbr => "CA",street_1 => "3880 Truxel Rd Ste 200",street_2 => undef}
{city => "Sacramento",postal_code => 95825,region => "California",region_abbr => "CA",street_1 => "601 Munroe St.",street_2 => undef}
{city => "Sacramento",postal_code => 95817,region => "California",region_abbr => "CA",street_1 => "2837 36th St.",street_2 => undef}
{city => "Sacramento",postal_code => 95815,region => "California",region_abbr => "CA",street_1 => "1825 Del Paso Blvd.",street_2 => "Suite 2"}
{city => "Sacramento",postal_code => 95820,region => "California",region_abbr => "CA",street_1 => "3500 Stockton Blvd.",street_2 => undef}
{city => "Sacramento",postal_code => 95841,region => "California",region_abbr => "CA",street_1 => "5040 Auburn Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95816,region => "California",region_abbr => "CA",street_1 => "1900 Alhambra Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95815,region => "California",region_abbr => "CA",street_1 => "1825 Del Paso Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95820,region => "California",region_abbr => "CA",street_1 => "3022 Stockton Blvd.",street_2 => undef}
{city => "Sacramento",postal_code => 95816,region => "California",region_abbr => "CA",street_1 => "800 Alhambra Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95818,region => "California",region_abbr => "CA",street_1 => "1704 Broadway",street_2 => undef}
{city => "Sacramento",postal_code => 95831,region => "California",region_abbr => "CA",street_1 => "6363 Riverside Blvd",street_2 => undef}
{city => "Sacramento",postal_code => 95811,region => "California",region_abbr => "CA",street_1 => "1409 R Street",street_2 => undef}
{city => "Sacramento",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11th & I Street",street_2 => undef}
{city => "Salinas",postal_code => 93901,region => "California",region_abbr => "CA",street_1 => "435 Pajaro St.",street_2 => undef}
{city => "San Bernardino",postal_code => 92408,region => "California",region_abbr => "CA",street_1 => "2150 S. Waterman Avenue",street_2 => undef}
{city => "San Clemente",postal_code => 92672,region => "California",region_abbr => "CA",street_1 => "1624 N. El Camino Real",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "2879 University Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "4230 Voltaire Street",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "3827 5th Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92110,region => "California",region_abbr => "CA",street_1 => "3760 Sports Arena Blvd",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "2760 5th Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "3772 Voltaire Street",street_2 => undef}
{city => "San Diego",postal_code => 92110,region => "California",region_abbr => "CA",street_1 => "3555 Rosecrans Ave.",street_2 => undef}
{city => "San Diego",postal_code => 92111,region => "California",region_abbr => "CA",street_1 => "7420 Clairemont Mesa Blvd.",street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "1905 El Cajon Blvd.",street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "3918 30th Street",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "3332 Adams Ave.",street_2 => undef}
{city => "San Diego",postal_code => 92130,region => "California",region_abbr => "CA",street_1 => "12853 El Camino Real",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "3416 Adams Ave.",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "3960 West Point Loma Blvd",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "7095 Clairemont Mesa Blvd..",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "3311 Adams Ave",street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "4237 Alabama Street",street_2 => undef}
{city => "San Diego",postal_code => 92101,region => "California",region_abbr => "CA",street_1 => "2812 Kettner Blvd.",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1743 India Street",street_2 => undef}
{city => "San Diego",postal_code => 92106,region => "California",region_abbr => "CA",street_1 => "2400 Historic Decatur Road",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "4001 18th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "3115 Fillmore Street",street_2 => undef}
{city => "San Francisco",postal_code => 94116,region => "California",region_abbr => "CA",street_1 => "20th Street and Church Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "331 Cortland Avenue",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "865 Market Street",street_2 => "Ground floor, San Francisco Centre"}
{city => "San Francisco",postal_code => 94111,region => "California",region_abbr => "CA",street_1 => "One Ferry Building",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "919 Kearny St",street_2 => undef}
{city => "San Francisco",postal_code => 94146,region => "California",region_abbr => "CA",street_1 => "PO Box 460411",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "754 Kirkham Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "3372 19th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "2247 Market St.",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2211 Mission Street",street_2 => undef}
{city => "San Francisco",postal_code => 94107,region => "California",region_abbr => "CA",street_1 => "216 King Street",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "2200 Lombard Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3168 22nd St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2790 Harrison St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "160 Ellis Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "950 Mason Street",street_2 => undef}
{city => "San Francisco",postal_code => 94108,region => "California",region_abbr => "CA",street_1 => "839 Kearny Street",street_2 => undef}
{city => "San Francisco",postal_code => 94109,region => "California",region_abbr => "CA",street_1 => "1075 Sutter St.",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2901 Mission St.",street_2 => undef}
{city => "San Francisco",postal_code => 94105,region => "California",region_abbr => "CA",street_1 => "123 2nd Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "730 Howard St",street_2 => "Yerba Buena Gardens, Upper Terrace"}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "498 Sanchez St",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "524 Irving St.",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "4039 18th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "806 South Van Ness Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2832 Mission St.",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "865 Market Street",street_2 => "Westfield Centre"}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "545 Haight St.",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "233 14th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "1634 Irving Street",street_2 => undef}
{city => "San Francisco",postal_code => 94115,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2801 24th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94111,region => "California",region_abbr => "CA",street_1 => "The Embarcadero",street_2 => "Pier 3"}
{city => "San Francisco",postal_code => 94111,region => "California",region_abbr => "CA",street_1 => "101 California Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "825 Mission St",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "4001 Judah Street",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "3318 Fillmore Street",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "511 Hayes Street",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "1400 Market St.",street_2 => undef}
{city => "San Francisco",postal_code => 94111,region => "California",region_abbr => "CA",street_1 => "1 Ferry Building",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "254 Fillmore St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2937 24th St.",street_2 => undef}
{city => "San Francisco",postal_code => 94115,region => "California",region_abbr => "CA",street_1 => "1419 Fillmore Street",street_2 => undef}
{city => "San Gabriel",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "529 E. Valley Blvd",street_2 => "Suite 128"}
{city => "San Jose",postal_code => 94303,region => "California",region_abbr => "CA",street_1 => "191 Middlefield Road",street_2 => undef}
{city => "San Jose",postal_code => 95113,region => "California",region_abbr => "CA",street_1 => "225 W. Santa Clara Street",street_2 => undef}
{city => "San Jose",postal_code => 95123,region => "California",region_abbr => "CA",street_1 => "925 Blossom Hill Road",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "1445 Monterey St.",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "3971 S. Higuera St.",street_2 => undef}
{city => "San Luis Obispo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1531 Monterey Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Luis Obispo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3973 S. Higuera Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "1009 Monterey Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93405,region => "California",region_abbr => "CA",street_1 => "1035 Chorro Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "2115 Broad Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "1227 Archer Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "1422 Monterey Street",street_2 => undef}
{city => "San Mateo",postal_code => 94403,region => "California",region_abbr => "CA",street_1 => "2299 S. El Camino Real",street_2 => undef}
{city => "San Mateo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Mateo",postal_code => 94401,region => "California",region_abbr => "CA",street_1 => "69 Third Avenue",street_2 => undef}
{city => "San Rafael",postal_code => 94901,region => "California",region_abbr => "CA",street_1 => "811 Fourth St.",street_2 => undef}
{city => "San Rafael",postal_code => 94901,region => "California",region_abbr => "CA",street_1 => "1242 Fourth Street",street_2 => undef}
{city => "San Rafael",postal_code => 94901,region => "California",region_abbr => "CA",street_1 => "704 Fourth Street",street_2 => undef}
{city => "San Rafael",postal_code => 94901,region => "California",region_abbr => "CA",street_1 => "363 Third St.",street_2 => undef}
{city => "San Rafael",postal_code => 94903,region => "California",region_abbr => "CA",street_1 => "641 Del Ganado Road",street_2 => undef}
{city => "Santa Ana",postal_code => 92701,region => "California",region_abbr => "CA",street_1 => "400 N. Broadway",street_2 => undef}
{city => "Santa Ana",postal_code => 92701,region => "California",region_abbr => "CA",street_1 => "151 East Memory Lane",street_2 => undef}
{city => "Santa Barbara",postal_code => 93101,region => "California",region_abbr => "CA",street_1 => "331 Motor Way",street_2 => undef}
{city => "Santa Barbara",postal_code => 93105,region => "California",region_abbr => "CA",street_1 => "3534 State Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93105,region => "California",region_abbr => "CA",street_1 => "3761 State St.",street_2 => undef}
{city => "Santa Barbara",postal_code => 93101,region => "California",region_abbr => "CA",street_1 => "113 W. De La Guerra Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93111,region => "California",region_abbr => "CA",street_1 => "5392 Hollister Avenue",street_2 => undef}
{city => "Santa Barbara",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "425 State Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93101,region => "California",region_abbr => "CA",street_1 => "1101 State St",street_2 => undef}
{city => "Santa Barbara",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "230 E. Victoria Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93109,region => "California",region_abbr => "CA",street_1 => "302 Meigs Road",street_2 => undef}
{city => "Santa Clarita",postal_code => 91355,region => "California",region_abbr => "CA",street_1 => "25343 Wayne Mills Place",street_2 => undef}
{city => "Santa Clarita",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "26470 Ruether Ave.",street_2 => undef}
{city => "Santa Clarita",postal_code => 91350,region => "California",region_abbr => "CA",street_1 => "26495 Golden Valley rd.",street_2 => undef}
{city => "Santa Clarita",postal_code => 91350,region => "California",region_abbr => "CA",street_1 => "22911 Soledad Canyon Rd.",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1101 Fair Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "418 Front Street",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "1141 Soquel Ave",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "291 Water Street",street_2 => undef}
{city => "Santa Cruz",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1121 Soquel Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "710 Front St",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "320 Cedar St.",street_2 => undef}
{city => "Santa Cruz",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1636 Seabright Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "113 Walnut Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1501 Mission St.",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "309 Beach St",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "4125 Portola Drive",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1010 Cedar St. S",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "736 Water Street",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "2-1231 E. Cliff Drive",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "1305 Water Street",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1134 Pacific Ave",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1520 Pacific Ave",street_2 => "K1"}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "103 Lincoln St.",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1126 Pacific Avenue",street_2 => undef}
{city => "Santa Monica",postal_code => 90405,region => "California",region_abbr => "CA",street_1 => "2717 Main Street",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "301 Arizone Ave",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "609 Broadway Avenue",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "2901 Ocean Park Blvd",street_2 => "Suite 123"}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "413 Santa Monica Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "1028 Wilshire Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "802 Broadway",street_2 => undef}
{city => "Santa Monica",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "9045 Santa Monica Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => 90403,region => "California",region_abbr => "CA",street_1 => "2025 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "313 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "530 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => 90405,region => "California",region_abbr => "CA",street_1 => "2327 Main Street",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "717 Broadway St",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "507 4th St.",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "1899 Mendocino Avenue",street_2 => undef}
{city => "Santa Rosa",postal_code => 95405,region => "California",region_abbr => "CA",street_1 => "557 Summerfield Rd",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "286 Coddingtown Center",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "110 4th St",street_2 => undef}
{city => "Santa Rosa",postal_code => 95403,region => "California",region_abbr => "CA",street_1 => "90 Mark West Springs Rd",street_2 => undef}
{city => "Santa Rosa",postal_code => 95404,region => "California",region_abbr => "CA",street_1 => "637 First Street",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "535 Ross St.",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "630 3rd St",street_2 => undef}
{city => "Seaside",postal_code => 93955,region => "California",region_abbr => "CA",street_1 => "825 Hamilton Ave.",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "7385 Healdsburg Avenue",street_2 => "Suite 101"}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "162 N. Main Street",street_2 => undef}
{city => "Silver Lake",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "3524 W. Sunset Blvd",street_2 => undef}
{city => "Silverlake",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1521 Griffith Park Blvd",street_2 => undef}
{city => "Silverlake",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "3922 West Sunset Boulevard",street_2 => undef}
{city => "Solana Beach",postal_code => 92075,region => "California",region_abbr => "CA",street_1 => "106 S. Sierra Avenue",street_2 => undef}
{city => "Sonora",postal_code => 95370,region => "California",region_abbr => "CA",street_1 => "145 S. Washington Street",street_2 => "Suite A"}
{city => "Soquel",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4763 Soquel Drive",street_2 => undef}
{city => "South El Monte",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9442 E. Garvey Avenue",street_2 => undef}
{city => "South Lake Tahoe",postal_code => 96150,region => "California",region_abbr => "CA",street_1 => "2753 Lake Tahoe Blvd.",street_2 => undef}
{city => "South Lake Tahoe",postal_code => 96150,region => "California",region_abbr => "CA",street_1 => "3434 Lake Tahoe Blvd",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "12067 Ventura Place",street_2 => undef}
{city => "Studio City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11320 1/2 Ventura Blvd",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "3701 Cahuenga Blvd",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "11044 Ventura Blvd",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "3701 Cahuenga Blvd",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "3711 W Cahuenga Blvd.",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "Cahuenga Blvd & Regal Place",street_2 => undef}
{city => "Sunnyvale",postal_code => 94087,region => "California",region_abbr => "CA",street_1 => "1635 Hollenbeck Ave",street_2 => undef}
{city => "Sunnyvale",postal_code => 94087,region => "California",region_abbr => "CA",street_1 => "1053 E. El Camino Real",street_2 => "#8"}
{city => "Tahoe City",postal_code => 96145,region => "California",region_abbr => "CA",street_1 => "150 Alpine Meadows Road",street_2 => undef}
{city => "Tarzana",postal_code => 91356,region => "California",region_abbr => "CA",street_1 => "19014 Ventura Blvd",street_2 => undef}
{city => "Temecula",postal_code => 92591,region => "California",region_abbr => "CA",street_1 => "40695 Winchester Road",street_2 => "Trader Joe's shopping plaza"}
{city => "Temecula",postal_code => 92591,region => "California",region_abbr => "CA",street_1 => "40573 Margarita Rd",street_2 => "Unit D"}
{city => "Temecula",postal_code => 92591,region => "California",region_abbr => "CA",street_1 => "27715 Jefferson Avenue",street_2 => "Suite 106"}
{city => "Templeton",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6th & Crocker Street",street_2 => undef}
{city => "Thousand Oaks",postal_code => 91362,region => "California",region_abbr => "CA",street_1 => "1655 E. Thousand Oaks Blvd",street_2 => undef}
{city => "Thousand Oaks",postal_code => 91362,region => "California",region_abbr => "CA",street_1 => "180 Promenade Way",street_2 => undef}
{city => "Torrance",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3920 Sepulveda Avenue",street_2 => undef}
{city => "Truckee",postal_code => 96161,region => "California",region_abbr => "CA",street_1 => "8001 Northstar Drive",street_2 => "Suite 8114"}
{city => "Tustin",postal_code => 92780,region => "California",region_abbr => "CA",street_1 => "191 East Main Street",street_2 => "Suite 1B"}
{city => "Tustin",postal_code => 92782,region => "California",region_abbr => "CA",street_1 => "2453 Park Ave.",street_2 => "The District"}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "405 S. State Street",street_2 => undef}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "No. State Street",street_2 => undef}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "732 South State Street",street_2 => undef}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "111 West Church Street",street_2 => undef}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "102 S. State Street",street_2 => undef}
{city => "Upland",postal_code => 91786,region => "California",region_abbr => "CA",street_1 => "903 West Foothill Blvd.",street_2 => "Suite B"}
{city => "Vacaville",postal_code => 95688,region => "California",region_abbr => "CA",street_1 => "1679 E. Monte Vista Avenue",street_2 => undef}
{city => "Valencia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "23360 Valencia Blvd.",street_2 => undef}
{city => "Valencia",postal_code => 91354,region => "California",region_abbr => "CA",street_1 => "23874 Copper Hill Drive",street_2 => undef}
{city => "Valencia",postal_code => 91354,region => "California",region_abbr => "CA",street_1 => "27732 McBean Parkway",street_2 => undef}
{city => "Venice",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1 Westminster Avenue",street_2 => undef}
{city => "Venice",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "429 Ocean Front Walk",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1718 Main Street #1",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1239 Abbot Kinney Blvd.",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "235 Main St",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1512 Pacific Avenue",street_2 => undef}
{city => "Walnut",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "152 N. Pierre Rd",street_2 => undef}
{city => "Weimar",postal_code => 95736,region => "California",region_abbr => "CA",street_1 => "20601 W. Paoli Lane",street_2 => undef}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8365 Santa Monica Blvd",street_2 => undef}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8822 Cynthia Street",street_2 => undef}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8910 Santa Monica Blvd",street_2 => undef}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8759 Santa Monica Blvd",street_2 => undef}
{city => "West Hollywood",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7100 Santa Monica Blvd",street_2 => "#135"}
{city => "West Hollywood",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "8000 Sunset Blvd.",street_2 => undef}
{city => "West Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "12113 Santa Monica Blvd",street_2 => "Suite 207"}
{city => "Westlake Village",postal_code => 91362,region => "California",region_abbr => "CA",street_1 => "30990 Russel Road",street_2 => undef}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "6904 Westminster Blvd",street_2 => undef}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "9741 Bolsa Blvd.",street_2 => "#109"}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "15131 Moran St",street_2 => "Suite 417"}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "15352 Beach Blvd",street_2 => undef}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "9455 Bolsa Avenue",street_2 => undef}
{city => "Westminster",postal_code => 92683,region => "California",region_abbr => "CA",street_1 => "9329 Bolsa Avenue",street_2 => undef}
{city => "Westwood",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "1712 Westwood Blvd.",street_2 => undef}
{city => "Westwood",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "1000 Gayley Avenue",street_2 => undef}
{city => "Whittier",postal_code => 90601,region => "California",region_abbr => "CA",street_1 => "6754 Greenleaf Ave nue",street_2 => undef}
{city => "Willits",postal_code => 95490,region => "California",region_abbr => "CA",street_1 => "212 S. Main Street",street_2 => undef}
{city => "Willits",postal_code => 95490,region => "California",region_abbr => "CA",street_1 => "50 S. Main Street",street_2 => undef}
{city => "Willits",postal_code => 95490,region => "California",region_abbr => "CA",street_1 => "1 North Main Street",street_2 => undef}
{city => "Woodland",postal_code => 95695,region => "California",region_abbr => "CA",street_1 => "537B Main Street",street_2 => undef}
{city => undef,postal_code => 92677,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => " Albany",postal_code => 94706,region => "California",region_abbr => "CA",street_1 => " 1019 San Pablo Ave.",street_2 => undef}
{city => " San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2193 Mission Street",street_2 => undef}
{city => "Alameda",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1613 Park Street",street_2 => undef}
{city => "Albany",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1051 San Pablo Avenue",street_2 => undef}
{city => "Albany",postal_code => 94706,region => "California",region_abbr => "CA",street_1 => "843 San Pablo Avenue",street_2 => undef}
{city => "Albany",postal_code => "94706-1602",region => "California",region_abbr => "CA",street_1 => "843 San Pablo Avenue",street_2 => undef}
{city => "Alhambra",postal_code => 91801,region => "California",region_abbr => "CA",street_1 => "910 E. Main St.",street_2 => undef}
{city => "Alhambra",postal_code => 91801,region => "California",region_abbr => "CA",street_1 => "1400 East Valley Blvd.",street_2 => undef}
{city => "Altadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2283 N. Lake Avenue",street_2 => undef}
{city => "Anaheim",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3107 W. Lincoln Ave",street_2 => undef}
{city => "Anaheim",postal_code => 92804,region => "California",region_abbr => "CA",street_1 => "10500 Magnolia Ave.",street_2 => undef}
{city => "Anaheim",postal_code => 92802,region => "California",region_abbr => "CA",street_1 => "1740 S. Euclid St.",street_2 => undef}
{city => "Arcadia",postal_code => 91006,region => "California",region_abbr => "CA",street_1 => "103 E Huntington Drive",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "811 I Street",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "1062 G Street",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "747 13th Street",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "1604 G Street",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "865 8th St.",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "1563 G Street",street_2 => undef}
{city => "Arcata",postal_code => 95521,region => "California",region_abbr => "CA",street_1 => "768 18th Street",street_2 => undef}
{city => "Artesia",postal_code => 90701,region => "California",region_abbr => "CA",street_1 => "17631 Pioneer Blvd",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18433 Pioneer Blvd.",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18525 Pioneer Blvd",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11814 E. 186th St",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18792 Pioneer Blvd",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18635 Pioneer Blvd.",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11736 E. 166th St",street_2 => undef}
{city => "Artesia",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11833 Artesia Blvd.",street_2 => undef}
{city => "Atascadero",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6005 El Camino Real",street_2 => undef}
{city => "Atwater Village",postal_code => 90039,region => "California",region_abbr => "CA",street_1 => "3300 Glendale Blvd",street_2 => undef}
{city => "Bakersfield",postal_code => 93301,region => "California",region_abbr => "CA",street_1 => "1717 20th St.",street_2 => undef}
{city => "Banning",postal_code => 92220,region => "California",region_abbr => "CA",street_1 => "575 West Ramsey St",street_2 => undef}
{city => "Berkeley",postal_code => 94705,region => "California",region_abbr => "CA",street_1 => "3000 Telegraph Ave.",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1512 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94709,region => "California",region_abbr => "CA",street_1 => "1686 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2708 Russell Street",street_2 => undef}
{city => "Berkeley",postal_code => 94720,region => "California",region_abbr => "CA",street_1 => "2625 Durant Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1620 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2033 San Pablo Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1805 Euclid Ave.",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2119 Kittredge Street",street_2 => undef}
{city => "Berkeley",postal_code => 94709,region => "California",region_abbr => "CA",street_1 => "2085 Vine St",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1730 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2072 University Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94701,region => "California",region_abbr => "CA",street_1 => "2415 Bowditch St.",street_2 => undef}
{city => "Berkeley",postal_code => 94705,region => "California",region_abbr => "CA",street_1 => "3115 Telegraph Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94703,region => "California",region_abbr => "CA",street_1 => "3031 Adeline St.",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2355 Telegraph Ave",street_2 => undef}
{city => "Berkeley",postal_code => 94709,region => "California",region_abbr => "CA",street_1 => "1620 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94705,region => "California",region_abbr => "CA",street_1 => "2936 College Ave.",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3031 Adeline Street",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2050 Addison Street",street_2 => undef}
{city => "Berkeley",postal_code => 94709,region => "California",region_abbr => "CA",street_1 => "1600 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2929 Ninth Street",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2451 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "1901 University Ave",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "1923 University Ave",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2106 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94702,region => "California",region_abbr => "CA",street_1 => "1401 University Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94705,region => "California",region_abbr => "CA",street_1 => "2122 Shattuck Ave.",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1600 Shattuck Ave.",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1591 Solano Ave.",street_2 => undef}
{city => "Berkeley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1700 Shattuck Avenue",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2129 University Ave",street_2 => undef}
{city => "Berkeley",postal_code => 94704,region => "California",region_abbr => "CA",street_1 => "2132 Center Street",street_2 => undef}
{city => "Beverly Hills",postal_code => 90210,region => "California",region_abbr => "CA",street_1 => "410 N. Canon Drive",street_2 => undef}
{city => "Beverly Hills",postal_code => 90210,region => "California",region_abbr => "CA",street_1 => "9630 S Santa Monica Boulevard",street_2 => undef}
{city => "Beverly Hills",postal_code => 90212,region => "California",region_abbr => "CA",street_1 => "326 S Beverly Dr",street_2 => undef}
{city => "Beverly Hills",postal_code => 90210,region => "California",region_abbr => "CA",street_1 => "474 North Rodeo Drive",street_2 => undef}
{city => "Beverly Hills",postal_code => 90212,region => "California",region_abbr => "CA",street_1 => "242 South Beverly Drive",street_2 => undef}
{city => "Brea",postal_code => 92821,region => "California",region_abbr => "CA",street_1 => "2445 East Imperial HWY",street_2 => "Suite F"}
{city => "Brentwood",postal_code => 90049,region => "California",region_abbr => "CA",street_1 => "11702 Barrington Avenue",street_2 => undef}
{city => "Buellton",postal_code => 93427,region => "California",region_abbr => "CA",street_1 => "290 Valley Station Drive",street_2 => undef}
{city => "Burlingame",postal_code => 94010,region => "California",region_abbr => "CA",street_1 => "1170 Broadway",street_2 => undef}
{city => "Burlingame",postal_code => 94010,region => "California",region_abbr => "CA",street_1 => "1160 Capuchino Ave.",street_2 => undef}
{city => "Campbell",postal_code => 95008,region => "California",region_abbr => "CA",street_1 => "1690 S. Bascom Avenue",street_2 => undef}
{city => "Canoga Park",postal_code => 91303,region => "California",region_abbr => "CA",street_1 => "7257 Topanga Canyon Blvd.",street_2 => undef}
{city => "Canoga Park",postal_code => 91303,region => "California",region_abbr => "CA",street_1 => "21825 Sherman Way",street_2 => undef}
{city => "Capitola",postal_code => 95010,region => "California",region_abbr => "CA",street_1 => "4250 Capitola Road",street_2 => undef}
{city => "Cardiff-by-the-Sea",postal_code => 92007,region => "California",region_abbr => "CA",street_1 => "2591 South Coast Highway 101",street_2 => undef}
{city => "Carlsbad",postal_code => 92009,region => "California",region_abbr => "CA",street_1 => "3243 Camino de los Coches",street_2 => undef}
{city => "Carlsbad",postal_code => 92008,region => "California",region_abbr => "CA",street_1 => "300 Carlsbad Village Drive",street_2 => undef}
{city => "Carlsbad",postal_code => 92008,region => "California",region_abbr => "CA",street_1 => "300 Carlsbad Village Drive",street_2 => "Suite 106"}
{city => "Carpinteria",postal_code => 93013,region => "California",region_abbr => "CA",street_1 => "915 Linden Avenue",street_2 => undef}
{city => "Cerritos",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "11321 183rd Street",street_2 => undef}
{city => "Chatsworth",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9840 Topanga Canyon Blvd",street_2 => undef}
{city => "Chico",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "117 Broadway St",street_2 => undef}
{city => "Chico",postal_code => 95926,region => "California",region_abbr => "CA",street_1 => "196 Cohasset Rd",street_2 => undef}
{city => "Chico",postal_code => 95926,region => "California",region_abbr => "CA",street_1 => "1293 E. First Avenue",street_2 => undef}
{city => "Chino Hills",postal_code => 91709,region => "California",region_abbr => "CA",street_1 => "3630 Grand Avenue",street_2 => undef}
{city => "Chula Vista",postal_code => 91913,region => "California",region_abbr => "CA",street_1 => "941 Otay Lakes Road",street_2 => undef}
{city => "Chula Vista",postal_code => 91910,region => "California",region_abbr => "CA",street_1 => "690 3rd avenue",street_2 => undef}
{city => "Chula Vista",postal_code => 91910,region => "California",region_abbr => "CA",street_1 => "315 3rd Avenue",street_2 => undef}
{city => "Claremont",postal_code => 91711,region => "California",region_abbr => "CA",street_1 => "129 Harvard Avenue",street_2 => undef}
{city => "Colfax",postal_code => 95713,region => "California",region_abbr => "CA",street_1 => "30 N. Main St.",street_2 => undef}
{city => "Corona",postal_code => 92882,region => "California",region_abbr => "CA",street_1 => "120 West Ontario Avenue",street_2 => undef}
{city => "Cost Mesa",postal_code => 92626,region => "California",region_abbr => "CA",street_1 => "2981 Bristol, Suite B5",street_2 => undef}
{city => "Costa Mesa",postal_code => 92626,region => "California",region_abbr => "CA",street_1 => "3030 Harbor Blvd.",street_2 => "Suite D"}
{city => "Costa Mesa",postal_code => 92627,region => "California",region_abbr => "CA",street_1 => "259 E 17th St",street_2 => undef}
{city => "Costa Mesa",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2937 Bristol St",street_2 => undef}
{city => "Costa Mesa",postal_code => 92707,region => "California",region_abbr => "CA",street_1 => "1400 Bristol Avenue",street_2 => undef}
{city => "Covina",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1063 N. Citrus",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9543 Culver Blvd.",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Culver City",postal_code => 90066,region => "California",region_abbr => "CA",street_1 => "11938 W. Washington Blvd.",street_2 => undef}
{city => "Culver City",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => "10438 National Blvd",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "10200 Venice Blvd.",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9409 Venice Blvd.",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9343 Culver Blvd.",street_2 => undef}
{city => "Culver City",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "Linblade Street",street_2 => undef}
{city => "Cupertino",postal_code => 95014,region => "California",region_abbr => "CA",street_1 => "21670 Stevens Creek Blvd.",street_2 => undef}
{city => "Cupertino",postal_code => 95014,region => "California",region_abbr => "CA",street_1 => "20830 Stevens Creek Blvd.",street_2 => undef}
{city => "Cupertino",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "20956 Homestead Road",street_2 => undef}
{city => "Dana Point",postal_code => 92629,region => "California",region_abbr => "CA",street_1 => "24501 Del Prado",street_2 => "#B"}
{city => "Davis",postal_code => 95616,region => "California",region_abbr => "CA",street_1 => "624 4th Street",street_2 => undef}
{city => "Davis",postal_code => 95616,region => "California",region_abbr => "CA",street_1 => "122 B St.",street_2 => undef}
{city => "Davis",postal_code => 95616,region => "California",region_abbr => "CA",street_1 => "640 W Covell Blvd",street_2 => "Suite B"}
{city => "Del Mar",postal_code => 92014,region => "California",region_abbr => "CA",street_1 => "1011 Camino Del Mar",street_2 => "#210"}
{city => "Diamond Bar",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "23371 E. Golden Springs Drive",street_2 => undef}
{city => "Diamond Bar",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "303 S. Diamond Bar Blvd.",street_2 => undef}
{city => "Eagle Rock",postal_code => 90041,region => "California",region_abbr => "CA",street_1 => "1627 Colorado Blvd.",street_2 => undef}
{city => "Eagle Rock",postal_code => 90041,region => "California",region_abbr => "CA",street_1 => "1743 Colorado Blvd.",street_2 => undef}
{city => "East Hollywood",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "5321 Hollywood Blvd",street_2 => undef}
{city => "East Hollywood",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "5907 Hollywood Blvd",street_2 => undef}
{city => "El Cajon",postal_code => 92020,region => "California",region_abbr => "CA",street_1 => "1255 Avocado Ave Ste 103",street_2 => undef}
{city => "El Cerrito",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "10558 San Pablo Avenue",street_2 => undef}
{city => "El Monte",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3311 N. Tyler Avenue",street_2 => undef}
{city => "El Segundo",postal_code => 90245,region => "California",region_abbr => "CA",street_1 => "2041 Rosecrans Ave.",street_2 => "#120"}
{city => "El Segundo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "720 Allied Way",street_2 => "Plaza El Segundo"}
{city => "El Segundo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "408 Main St.",street_2 => undef}
{city => "Emeryville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4301 San Pablo Avenue",street_2 => undef}
{city => "Emeryville",postal_code => 94608,region => "California",region_abbr => "CA",street_1 => "4001 Linden St.",street_2 => undef}
{city => "Encinitas",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "1327 Encinitas Blvd",street_2 => undef}
{city => "Encinitas",postal_code => 92024,region => "California",region_abbr => "CA",street_1 => "133 Daphne",street_2 => undef}
{city => "Escondido",postal_code => 92025,region => "California",region_abbr => "CA",street_1 => "510 W 13th Ave",street_2 => undef}
{city => "Escondido",postal_code => 92029,region => "California",region_abbr => "CA",street_1 => "1999 Citracado Parkway",street_2 => undef}
{city => "Escondido",postal_code => 92026,region => "California",region_abbr => "CA",street_1 => "2499 Melru Lane",street_2 => undef}
{city => "Etiwanda",postal_code => 91739,region => "California",region_abbr => "CA",street_1 => "7355 Day Creek Blvd.",street_2 => undef}
{city => "Eureka",postal_code => 95503,region => "California",region_abbr => "CA",street_1 => "1125 King Salmon Ave.",street_2 => undef}
{city => "Eureka",postal_code => 95501,region => "California",region_abbr => "CA",street_1 => "2335 4th St.",street_2 => undef}
{city => "Eureka",postal_code => 95501,region => "California",region_abbr => "CA",street_1 => "1626 Broadway",street_2 => undef}
{city => "Eureka",postal_code => 95502,region => "California",region_abbr => "CA",street_1 => "239 G St",street_2 => undef}
{city => "Fair Oaks",postal_code => 95628,region => "California",region_abbr => "CA",street_1 => "10344 Fair Oaks Blvd",street_2 => undef}
{city => "Ferndale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "400 Ocean Avenue",street_2 => undef}
{city => "Folsom",postal_code => 95360,region => "California",region_abbr => "CA",street_1 => "1146 Kidder Way",street_2 => undef}
{city => "Folsom",postal_code => 95630,region => "California",region_abbr => "CA",street_1 => "648 E. Bidwell St.",street_2 => undef}
{city => "Fountain Valley",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "16563 Brookhurst St",street_2 => undef}
{city => "Fresno",postal_code => 93704,region => "California",region_abbr => "CA",street_1 => "650 West Shaw Avenue",street_2 => undef}
{city => "Fresno",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "7975 N. Cedar Avenue",street_2 => undef}
{city => "Fresno",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1075 E. Bullard Avenue",street_2 => undef}
{city => "Fresno",postal_code => 93730,region => "California",region_abbr => "CA",street_1 => "10063 N Maple Ave",street_2 => undef}
{city => "Fullerton",postal_code => 92832,region => "California",region_abbr => "CA",street_1 => "1447 South Harbor Blvd.",street_2 => undef}
{city => "Fullerton",postal_code => 92832,region => "California",region_abbr => "CA",street_1 => "108 W. Wilshire Ave",street_2 => undef}
{city => "Fullerton",postal_code => 92832,region => "California",region_abbr => "CA",street_1 => "1401 S Harbor Blvd",street_2 => undef}
{city => "Glendale",postal_code => 90039,region => "California",region_abbr => "CA",street_1 => "3126 Los Feliz Blvd",street_2 => undef}
{city => "Glendale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "Brand Blvd",street_2 => undef}
{city => "Glendale",postal_code => 91206,region => "California",region_abbr => "CA",street_1 => "143 N Maryland",street_2 => undef}
{city => "Goleta",postal_code => 93117,region => "California",region_abbr => "CA",street_1 => "5892 Hollister Avenue",street_2 => undef}
{city => "Granada Hills",postal_code => 91344,region => "California",region_abbr => "CA",street_1 => "17823 Chatsworth Street",street_2 => undef}
{city => "Guerneville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "16248 Main Street",street_2 => undef}
{city => "Hacienda Heights",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "16034 Gale Avenue",street_2 => undef}
{city => "Hacienda Heights",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3456 S. Glenmark Dr",street_2 => undef}
{city => "Half Moon Bay",postal_code => 94019,region => "California",region_abbr => "CA",street_1 => "696 Mill Street",street_2 => undef}
{city => "Half Moon Bay",postal_code => 94019,region => "California",region_abbr => "CA",street_1 => "408 Main Street",street_2 => undef}
{city => "Hayward",postal_code => 94545,region => "California",region_abbr => "CA",street_1 => "3522 Arden Road",street_2 => undef}
{city => "Healdsburg",postal_code => 95448,region => "California",region_abbr => "CA",street_1 => "206 Healdsburg Avenue",street_2 => undef}
{city => "Hemet",postal_code => 92543,region => "California",region_abbr => "CA",street_1 => "1295 S. State St.",street_2 => "Suite B"}
{city => "Hermosa Beach",postal_code => 90254,region => "California",region_abbr => "CA",street_1 => "110 2nd Street",street_2 => undef}
{city => "Hermosa Beach",postal_code => 90254,region => "California",region_abbr => "CA",street_1 => "1101 Aviation Blvd",street_2 => undef}
{city => "Hermosa Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "509 Pier Avenue",street_2 => undef}
{city => "Hollywood",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "5509 Hollywood Blvd",street_2 => undef}
{city => "Hollywood",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "1802 N Vermont Ave",street_2 => undef}
{city => "Hollywood",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "8001 Beverly Blvd",street_2 => undef}
{city => "Hollywood",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1717 N. Wilcox Avenue",street_2 => undef}
{city => "Hollywood",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "1517 N Vine #107",street_2 => undef}
{city => "Hollywood",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "7475 Beverly Blvd.",street_2 => undef}
{city => "Huntington Beach",postal_code => 92648,region => "California",region_abbr => "CA",street_1 => "501 Main Street",street_2 => "Suite E"}
{city => "Huntington Beach",postal_code => 92647,region => "California",region_abbr => "CA",street_1 => "7561 Center Ave.",street_2 => "#24"}
{city => "Huntington Beach",postal_code => 92648,region => "California",region_abbr => "CA",street_1 => "19770 Beach Blvd.",street_2 => undef}
{city => "Huntington Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5930 Warner Avenue",street_2 => undef}
{city => "Huntington Beach",postal_code => 92647,region => "California",region_abbr => "CA",street_1 => "7251 Warner Ave.",street_2 => undef}
{city => "Huntington Beach",postal_code => 92649,region => "California",region_abbr => "CA",street_1 => "5930 Warner Avenue",street_2 => undef}
{city => "Huntington Beach",postal_code => 92647,region => "California",region_abbr => "CA",street_1 => "7251 Warner Ave",street_2 => undef}
{city => "Huntington Park",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6531 Seville Avenue",street_2 => undef}
{city => "Inglewood",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "114 N. Market St.",street_2 => undef}
{city => "Irvine",postal_code => 92618,region => "California",region_abbr => "CA",street_1 => "81 Fortune Drive",street_2 => undef}
{city => "Irvine",postal_code => 92606,region => "California",region_abbr => "CA",street_1 => "3850 Barranca Parkway",street_2 => undef}
{city => "Irvine",postal_code => 92604,region => "California",region_abbr => "CA",street_1 => "14370 Culver Dr.",street_2 => "Suite 3G"}
{city => "La Jolla",postal_code => 92092,region => "California",region_abbr => "CA",street_1 => "9500 Gilman Dr",street_2 => "University of California San Diego"}
{city => "La Mesa",postal_code => 91941,region => "California",region_abbr => "CA",street_1 => "4630 Palm Ave",street_2 => undef}
{city => "Laguna Beach",postal_code => 92651,region => "California",region_abbr => "CA",street_1 => "238 Thalia St.",street_2 => undef}
{city => "Laguna Beach",postal_code => 92651,region => "California",region_abbr => "CA",street_1 => "283 Broadway St",street_2 => undef}
{city => "Laguna Beach",postal_code => 92651,region => "California",region_abbr => "CA",street_1 => "540 South Coast Highway",street_2 => undef}
{city => "Laguna Beach",postal_code => 92651,region => "California",region_abbr => "CA",street_1 => "640 S Coast Hwy",street_2 => undef}
{city => "Laguna Niguel",postal_code => 92677,region => "California",region_abbr => "CA",street_1 => "27271 La Paz Rd",street_2 => undef}
{city => "Lancaster",postal_code => 93534,region => "California",region_abbr => "CA",street_1 => "1052 W Avenue K",street_2 => undef}
{city => "Laytonville",postal_code => 95454,region => "California",region_abbr => "CA",street_1 => "44850 Highway 101 N",street_2 => undef}
{city => "Lemon Grove",postal_code => 91945,region => "California",region_abbr => "CA",street_1 => "3205 Lemon Grove Ave",street_2 => undef}
{city => "Livermore",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "945 Bluebell Drive",street_2 => undef}
{city => "Lomita",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2439 Pacific Coast Highway",street_2 => undef}
{city => "Lomita",postal_code => 90717,region => "California",region_abbr => "CA",street_1 => "2107 Pacific Coast Highway",street_2 => undef}
{city => "Long Beach",postal_code => 90803,region => "California",region_abbr => "CA",street_1 => "6550 E. Pacific Coast Hgwy.",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4007 E. 4th Street",street_2 => undef}
{city => "Long Beach",postal_code => 90803,region => "California",region_abbr => "CA",street_1 => "5215 E. 2nd Street",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5006 East 2nd Street",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5262 E. 2nd St.",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "340 E. 4th St",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3400 E. Broadway",street_2 => undef}
{city => "Long Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4756 E. Pacific Coast Highway",street_2 => undef}
{city => "Los Altos",postal_code => 94022,region => "California",region_abbr => "CA",street_1 => "4800 El Camino Real",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "1544 N. Cahuenga Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90066,region => "California",region_abbr => "CA",street_1 => "5462 S Centinela Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3764 Watseka Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90031,region => "California",region_abbr => "CA",street_1 => "818 Wilshire Boulevard",street_2 => "#D"}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "10428 1/2 National Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => 90057,region => "California",region_abbr => "CA",street_1 => "2501 West 6th St.",street_2 => undef}
{city => "Los Angeles",postal_code => 90019,region => "California",region_abbr => "CA",street_1 => "1036 1/2 South Fairfax Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1041 S. Fairfax Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8649 Melrose Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "121 N. La Cienega Blvd",street_2 => "#117 Beverly Center"}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "345 N. La Brea Ave",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "7505 1/2 Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90035,region => "California",region_abbr => "CA",street_1 => "1716 South Robertson",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3217 Cahuenga Blvd. West",street_2 => undef}
{city => "Los Angeles",postal_code => 90012,region => "California",region_abbr => "CA",street_1 => "247 S. Main Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "751 N. Virgil Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90035,region => "California",region_abbr => "CA",street_1 => "9575 W. Pico Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7853 Santa Monica Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "712 Heliotrope Dr.",street_2 => undef}
{city => "Los Angeles",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "707 N. Heliotrope Drive",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7253 Santa Monica Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "1044 S Fairfax Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90013,region => "California",region_abbr => "CA",street_1 => "524 S. Main Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1918 Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "3818 W. Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90043,region => "California",region_abbr => "CA",street_1 => "3526 W. Slauson Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "2396 Glendale Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "1783 Westwood Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1513 S. Robertson Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "3655 South Grand Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "2501 W 6th Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "3655 South Grand Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "3655 South Grand Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "3655 South Grand Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "3655 South Grand Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "1311 Glendale Blvd",street_2 => "Ste A"}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "2703 W Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90071,region => "California",region_abbr => "CA",street_1 => "404 S. Figueroa",street_2 => undef}
{city => "Los Angeles",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "Los Angeles",postal_code => 90007,region => "California",region_abbr => "CA",street_1 => "2832 S. Vermont Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7168 Melrose Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "4718 Fountain Avenue",street_2 => "Unit D (second level)"}
{city => "Los Angeles",postal_code => 90029,region => "California",region_abbr => "CA",street_1 => "4326 W. Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => "90036-1717",region => "California",region_abbr => "CA",street_1 => "412 N Fairfax Ave",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "333 S. Alameda St.",street_2 => "Little Tokyo Square 3F (Suite 310)"}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "8514 W 3rd St",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "415 N Fairfax Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90019,region => "California",region_abbr => "CA",street_1 => "1047 S. Fairfax Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "6371 Selma Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => "3741 Motor Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90065,region => "California",region_abbr => "CA",street_1 => "2716 N. San Fernando Road",street_2 => undef}
{city => "Los Angeles",postal_code => 90028,region => "California",region_abbr => "CA",street_1 => "1525 N La Brea Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "829 N. La Cienega Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "8117 Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "3133 Glendale Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3206 W Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90019,region => "California",region_abbr => "CA",street_1 => "1076 S. Fairfax Ave.",street_2 => undef}
{city => "Los Angeles",postal_code => 90025,region => "California",region_abbr => "CA",street_1 => "2050 Sawtelle Boulevard",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4356 Fountain Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4507 S Centinela Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1245 S. Fairfax Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6332 De Longpre Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6547 Santa Monica Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90042,region => "California",region_abbr => "CA",street_1 => "5511 N. Figueroa St.",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7119 Melrose Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "8384 W 3rd Street",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "3206 W Sunset Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "1769 Hillhurst Ave",street_2 => undef}
{city => "Los Angeles",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "10917 Lindbrook Dr.",street_2 => undef}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "8393 Beverly Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => 90034,region => "California",region_abbr => "CA",street_1 => "10855 1/2 Venice Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "7300 Sunset Blvd.",street_2 => "Unit #A"}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "6474 W. 3rd St., Ste. #103",street_2 => undef}
{city => "Los Angeles",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "120 N. Robertson Blvd",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "131 S. La Brea Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "519 S. Fairfax Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1997 Hyperion Avenue",street_2 => undef}
{city => "Los Angeles",postal_code => 90026,region => "California",region_abbr => "CA",street_1 => "2943 W. Sunset Blvd.",street_2 => undef}
{city => "Los Angeles",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "13016 San Vicente Boulevard",street_2 => undef}
{city => "Los Gatos",postal_code => 95032,region => "California",region_abbr => "CA",street_1 => "15980 Los Gatos Blvd.",street_2 => undef}
{city => "Manhattan Beach",postal_code => 90266,region => "California",region_abbr => "CA",street_1 => "451 Manhattan Beach Boulevard",street_2 => undef}
{city => "Marina del Rey",postal_code => 90292,region => "California",region_abbr => "CA",street_1 => "517 Washington Blvd.",street_2 => undef}
{city => "Marina Del Rey",postal_code => 90292,region => "California",region_abbr => "CA",street_1 => "3115 Washington Blvd",street_2 => undef}
{city => "Mentone",postal_code => 92359,region => "California",region_abbr => "CA",street_1 => "1839 Mentone Blvd",street_2 => undef}
{city => "Mill Valley",postal_code => 94941,region => "California",region_abbr => "CA",street_1 => "414 Miller Ave.",street_2 => undef}
{city => "Milpitas",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "210 Barber Court",street_2 => undef}
{city => "Milpitas",postal_code => 95035,region => "California",region_abbr => "CA",street_1 => "516 Barber Lane",street_2 => undef}
{city => "Mission Viejo",postal_code => 92691,region => "California",region_abbr => "CA",street_1 => "27765 Santa Margarita Parkway",street_2 => undef}
{city => "Modesto",postal_code => 95355,region => "California",region_abbr => "CA",street_1 => "1401 Coffee Road",street_2 => undef}
{city => "Montara",postal_code => "94037-1215",region => "California",region_abbr => "CA",street_1 => "PO Box 371215",street_2 => undef}
{city => "Monterey",postal_code => 93940,region => "California",region_abbr => "CA",street_1 => " 1126 Del Monte Avenue",street_2 => undef}
{city => "Monterey",postal_code => 93940,region => "California",region_abbr => "CA",street_1 => "800 Del Monte Center",street_2 => undef}
{city => "Monterey Park",postal_code => 91754,region => "California",region_abbr => "CA",street_1 => "111 N. Atlantic Blvd.",street_2 => "#351"}
{city => "Monterey Park",postal_code => 91754,region => "California",region_abbr => "CA",street_1 => "608 N. Atlantic Blvd.",street_2 => undef}
{city => "Moorpark",postal_code => 93021,region => "California",region_abbr => "CA",street_1 => "840 New Los Angeles Avenue",street_2 => "#A-2"}
{city => "Moreno Valley",postal_code => 92553,region => "California",region_abbr => "CA",street_1 => "22456 Alessandro Blvd.",street_2 => undef}
{city => "Moreno Valley",postal_code => 92553,region => "California",region_abbr => "CA",street_1 => "12625 Frederick Street",street_2 => "Suite W-4"}
{city => "Moreno Valley",postal_code => 92553,region => "California",region_abbr => "CA",street_1 => "23701 Sunnymead Blvd",street_2 => "Suite C"}
{city => "Morro Bay",postal_code => 93442,region => "California",region_abbr => "CA",street_1 => "415 Morro Bay Blvd",street_2 => "Sunshine Health Foods"}
{city => "Mountain View",postal_code => 94040,region => "California",region_abbr => "CA",street_1 => "165 E. Camino Real",street_2 => undef}
{city => "Mountain View",postal_code => 94040,region => "California",region_abbr => "CA",street_1 => "1245 West El Camino Real",street_2 => undef}
{city => "Mountain View",postal_code => 94041,region => "California",region_abbr => "CA",street_1 => "257 W Evelyn Avenue",street_2 => undef}
{city => "Murphys",postal_code => 95247,region => "California",region_abbr => "CA",street_1 => "419 Main St.",street_2 => "Ste. B"}
{city => "Nevada City",postal_code => 95959,region => "California",region_abbr => "CA",street_1 => "18443 Macnab Cypress Road",street_2 => undef}
{city => "Nevada City",postal_code => 95959,region => "California",region_abbr => "CA",street_1 => "14618 Tyler Foote Rd",street_2 => undef}
{city => "Newark",postal_code => 94560,region => "California",region_abbr => "CA",street_1 => "5988 Newpark Mall",street_2 => undef}
{city => "Newbury Park",postal_code => 91320,region => "California",region_abbr => "CA",street_1 => "1714 Newbury Road",street_2 => "Suite R"}
{city => "North Hollywood",postal_code => 91606,region => "California",region_abbr => "CA",street_1 => "11403 Victory Boulevard",street_2 => undef}
{city => "North Hollywood",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5038 Vineland Avenue",street_2 => undef}
{city => "Northridge",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18110 Parthenia St",street_2 => undef}
{city => "Northridge",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8920 Reseda Blvd",street_2 => undef}
{city => "Northridge",postal_code => 91326,region => "California",region_abbr => "CA",street_1 => "19346 Rinaldi St.",street_2 => undef}
{city => "Northridge",postal_code => 91324,region => "California",region_abbr => "CA",street_1 => "9043 Reseda Blvd.",street_2 => undef}
{city => "Northridge",postal_code => 91324,region => "California",region_abbr => "CA",street_1 => "9129 Reseda Blvd",street_2 => undef}
{city => "Norwalk",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "12201 Firestone Blvd.",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3265 Lakeshore Avenue",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1301 Franklin St.",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4799 Telegraph Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "400 15th Street",street_2 => undef}
{city => "Oakland",postal_code => 94612,region => "California",region_abbr => "CA",street_1 => "1144 Peralta Street",street_2 => undef}
{city => "Oakland",postal_code => 94609,region => "California",region_abbr => "CA",street_1 => "6211 Shattuck Ave",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1405 Franklin Street",street_2 => undef}
{city => "Oakland",postal_code => 94607,region => "California",region_abbr => "CA",street_1 => "464 8th Street",street_2 => undef}
{city => "Oakland",postal_code => 94601,region => "California",region_abbr => "CA",street_1 => "1418 34th Ave",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4162 Piedmont Ave.",street_2 => undef}
{city => "Oakland",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "5819 College Ave.",street_2 => undef}
{city => "Oakland",postal_code => 94601,region => "California",region_abbr => "CA",street_1 => "510 Derby Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94609,region => "California",region_abbr => "CA",street_1 => "4069 Telegraph Avenue",street_2 => undef}
{city => "Oakland",postal_code => 94610,region => "California",region_abbr => "CA",street_1 => "462 Santa Clara Avenue",street_2 => undef}
{city => "Ocean Beach",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "4879 Voltaire Street",street_2 => undef}
{city => "Oceanside",postal_code => 92054,region => "California",region_abbr => "CA",street_1 => "514 S Coast Hwy",street_2 => undef}
{city => "Oceanside",postal_code => 92054,region => "California",region_abbr => "CA",street_1 => "3846 Mission Ave.",street_2 => "Suite F"}
{city => "Oceanside",postal_code => 92054,region => "California",region_abbr => "CA",street_1 => "2455 Vista Way",street_2 => "Suite F"}
{city => "Orange",postal_code => 92867,region => "California",region_abbr => "CA",street_1 => "1307 E. Katella Ave.",street_2 => undef}
{city => "Orange",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3505 Chapman St. E",street_2 => undef}
{city => "Orland",postal_code => 95963,region => "California",region_abbr => "CA",street_1 => "P.O. Box 1065",street_2 => undef}
{city => "Pacific Beach",postal_code => 92109,region => "California",region_abbr => "CA",street_1 => "1846 Garnet Avenue",street_2 => undef}
{city => "Pacific Grove",postal_code => 93950,region => "California",region_abbr => "CA",street_1 => "173 Central Ave",street_2 => undef}
{city => "Pacific Grove",postal_code => 93950,region => "California",region_abbr => "CA",street_1 => "111 Central Avenue",street_2 => undef}
{city => "Palm Desert",postal_code => 92260,region => "California",region_abbr => "CA",street_1 => "73-890 El Paseo",street_2 => undef}
{city => "Palm Desert",postal_code => 92260,region => "California",region_abbr => "CA",street_1 => "73680 Hwy 111",street_2 => undef}
{city => "Palm Springs",postal_code => 92264,region => "California",region_abbr => "CA",street_1 => "1775 E. Palm Canyon Drive",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "543 Emerson Street",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "443 Emerson Street",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "305 North California Avenue",street_2 => undef}
{city => "Palo Alto",postal_code => 94306,region => "California",region_abbr => "CA",street_1 => "2323 Birch Street",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "774 Emerson Street",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "520 Ramona Street",street_2 => undef}
{city => "Palo Alto",postal_code => 94303,region => "California",region_abbr => "CA",street_1 => "1700 Embarcadero Road",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "407 Lytton Ave",street_2 => undef}
{city => "Palo Alto",postal_code => 84306,region => "California",region_abbr => "CA",street_1 => "440 Portage Avenue",street_2 => undef}
{city => "Palo Alto",postal_code => 94301,region => "California",region_abbr => "CA",street_1 => "165 University Avenue",street_2 => undef}
{city => "Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "817 N. Lake Ave.",street_2 => undef}
{city => "Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "260 E. Colorado Blvd.",street_2 => "#201"}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "465 South Arroyo Parkway",street_2 => undef}
{city => "Pasadena",postal_code => 91106,region => "California",region_abbr => "CA",street_1 => "603 S Lake Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "49 E Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "695 E Green St",street_2 => undef}
{city => "Pasadena",postal_code => 91106,region => "California",region_abbr => "CA",street_1 => "605 S Lake Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "345 S. Lake Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91107,region => "California",region_abbr => "CA",street_1 => "467 Rosemead Blvd.",street_2 => undef}
{city => "Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "927 E Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "610 S Arroyo Parkway",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "560 S Arroyo Parkway",street_2 => undef}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "36 E Holly St",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "273 Shoppers Ln",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "408 S. Pasadena Ave.",street_2 => "Suite 1"}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "44 N Fair Oaks",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "64 E Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "204 S Lake Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91030,region => "California",region_abbr => "CA",street_1 => "1101 Fair Oaks Ave",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "69 W Green St",street_2 => undef}
{city => "Pasadena",postal_code => 91107,region => "California",region_abbr => "CA",street_1 => "3751 E. Foothill Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => "239 E Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "88 W Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "145 Palmetto Dr",street_2 => undef}
{city => "Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "24 E. Colorado Blvd",street_2 => undef}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "15 Douglas Alley",street_2 => undef}
{city => "Pasadena",postal_code => 91101,region => "California",region_abbr => "CA",street_1 => " 401 S. Lake Avenue",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "363 S Fair Oaks",street_2 => undef}
{city => "Pasadena",postal_code => 91105,region => "California",region_abbr => "CA",street_1 => "383 S Fair Oaks",street_2 => undef}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "52 Hugus Aly",street_2 => undef}
{city => "Pasadena",postal_code => 91106,region => "California",region_abbr => "CA",street_1 => "927 E. Colorado Blvd.",street_2 => undef}
{city => "Pasadena",postal_code => 91103,region => "California",region_abbr => "CA",street_1 => "17 North De Lacey Ave",street_2 => undef}
{city => "Petaluma",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "255 N. McDowell Blvd.",street_2 => undef}
{city => "Poway",postal_code => 92064,region => "California",region_abbr => "CA",street_1 => "13536 Poway Rd",street_2 => undef}
{city => "Rancho Cordova",postal_code => 95670,region => "California",region_abbr => "CA",street_1 => "2226 Sunrise Blvd",street_2 => undef}
{city => "Rancho Mirage",postal_code => 92270,region => "California",region_abbr => "CA",street_1 => "34175 Monterey Ave. Rancho Mirage",street_2 => undef}
{city => "Rancho Palos Verdes",postal_code => 90275,region => "California",region_abbr => "CA",street_1 => "28901 South Western Ave.",street_2 => "#123"}
{city => "Redding",postal_code => 96003,region => "California",region_abbr => "CA",street_1 => "1007 Dana Dr.",street_2 => "Suite A"}
{city => "Redlands",postal_code => 92373,region => "California",region_abbr => "CA",street_1 => "22 East State Street",street_2 => undef}
{city => "Redlands",postal_code => 92373,region => "California",region_abbr => "CA",street_1 => "623 Orange Street",street_2 => undef}
{city => "Redlands",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "309 West State Street",street_2 => undef}
{city => "Redondo Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1700 S. Catalina Ave.",street_2 => undef}
{city => "Redondo Beach",postal_code => 90277,region => "California",region_abbr => "CA",street_1 => "1408 Pacific Coast Highway",street_2 => undef}
{city => "Redondo Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1408 S. Pacific Coast Hwy",street_2 => undef}
{city => "Redondo Beach",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "709 N. Pacific Coast Highway",street_2 => undef}
{city => "Reseda",postal_code => 91335,region => "California",region_abbr => "CA",street_1 => "18625 Sherman Way",street_2 => "#101"}
{city => "Riverside",postal_code => 92505,region => "California",region_abbr => "CA",street_1 => "10466 Magnolia Avenue",street_2 => undef}
{city => "Riverside",postal_code => 92501,region => "California",region_abbr => "CA",street_1 => "4225 Market Street",street_2 => undef}
{city => "Rosemead",postal_code => 91770,region => "California",region_abbr => "CA",street_1 => "8632 E. Valley Blvd., #E",street_2 => undef}
{city => "Roseville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "Roseville & Galleria Pkwys",street_2 => undef}
{city => "Roseville",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1595 Eureka Road",street_2 => undef}
{city => "Rowland Heights",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "18425 E. Colima Rd",street_2 => "#2F"}
{city => "Rowland Heights",postal_code => 91748,region => "California",region_abbr => "CA",street_1 => "1015 S. Nogales St. Suite 127A",street_2 => undef}
{city => "Sacramento",postal_code => 95841,region => "California",region_abbr => "CA",street_1 => "5049 College Oak Dr",street_2 => undef}
{city => "Sacramento",postal_code => 95864,region => "California",region_abbr => "CA",street_1 => "4315 Arden Way",street_2 => undef}
{city => "Sacramento",postal_code => 95823,region => "California",region_abbr => "CA",street_1 => "6830 Stockton Blvd #105",street_2 => undef}
{city => "Sacramento",postal_code => 95815,region => "California",region_abbr => "CA",street_1 => "450 N St.",street_2 => undef}
{city => "Sacramento",postal_code => 95816,region => "California",region_abbr => "CA",street_1 => "2612 J Street",street_2 => undef}
{city => "Sacramento",postal_code => 95814,region => "California",region_abbr => "CA",street_1 => "2431 J Street",street_2 => undef}
{city => "Sacramento",postal_code => 95823,region => "California",region_abbr => "CA",street_1 => "8785 Center Pkwy",street_2 => "Suite B 120"}
{city => "Sacramento",postal_code => 95818,region => "California",region_abbr => "CA",street_1 => "2007 Broadway",street_2 => undef}
{city => "San Bernardino",postal_code => 92408,region => "California",region_abbr => "CA",street_1 => "1981 Diners Court",street_2 => "Hospitality Lane"}
{city => "San Bruno",postal_code => 94066,region => "California",region_abbr => "CA",street_1 => "464 San Mateo Ave",street_2 => undef}
{city => "San Carlos",postal_code => 94070,region => "California",region_abbr => "CA",street_1 => "1065 Holly Street",street_2 => undef}
{city => "San Diego",postal_code => 92117,region => "California",region_abbr => "CA",street_1 => "4439 Genesee Ave",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "4175 Park Blvd",street_2 => undef}
{city => "San Diego",postal_code => 92109,region => "California",region_abbr => "CA",street_1 => "1260 Garnet Ave",street_2 => undef}
{city => "San Diego",postal_code => 92110,region => "California",region_abbr => "CA",street_1 => "3315 Rosecrans St.",street_2 => undef}
{city => "San Diego",postal_code => 92122,region => "California",region_abbr => "CA",street_1 => "3358 Governor Dr",street_2 => undef}
{city => "San Diego",postal_code => 92102,region => "California",region_abbr => "CA",street_1 => "1521 30th Street",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "4765 Voltaire Street",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3794 30th St.",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "711 University Ave",street_2 => undef}
{city => "San Diego",postal_code => 92102,region => "California",region_abbr => "CA",street_1 => "2949 5th Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "3823 30th Street",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "3695 India Street",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "1830 Sunset Cliffs Blvd., Ste. H",street_2 => undef}
{city => "San Diego",postal_code => 92110,region => "California",region_abbr => "CA",street_1 => "3545 Midway Drive",street_2 => "Ste. E"}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "3766 Fifth Ave.",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1458 University Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "3351 Adams Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92102,region => "California",region_abbr => "CA",street_1 => "3910 30th Street",street_2 => undef}
{city => "San Diego",postal_code => 92121,region => "California",region_abbr => "CA",street_1 => "9450 Scranton Rd",street_2 => "#114A"}
{city => "San Diego",postal_code => 92123,region => "California",region_abbr => "CA",street_1 => "3442 30th St",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "2965 5th Ave",street_2 => undef}
{city => "San Diego",postal_code => 92126,region => "California",region_abbr => "CA",street_1 => "9474 Black Mountain Rd",street_2 => undef}
{city => "San Diego",postal_code => 92126,region => "California",region_abbr => "CA",street_1 => "9520 Black Mountain Rd",street_2 => undef}
{city => "San Diego",postal_code => 92126,region => "California",region_abbr => "CA",street_1 => "9484 Black Mountain Rd",street_2 => undef}
{city => "San Diego",postal_code => 92107,region => "California",region_abbr => "CA",street_1 => "4976 Newport Ave",street_2 => undef}
{city => "San Diego",postal_code => 92109,region => "California",region_abbr => "CA",street_1 => "825 Garnet Ave",street_2 => undef}
{city => "San Diego",postal_code => 92126,region => "California",region_abbr => "CA",street_1 => "9494 Black Mountain Rd",street_2 => undef}
{city => "San Diego",postal_code => 92109,region => "California",region_abbr => "CA",street_1 => "859 Hornblend St",street_2 => undef}
{city => "San Diego",postal_code => 92104,region => "California",region_abbr => "CA",street_1 => "3015 Juniper St",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "4645 Park Blvd",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "4669 Park Blvd",street_2 => undef}
{city => "San Diego",postal_code => 92109,region => "California",region_abbr => "CA",street_1 => "1419 Garnet Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92116,region => "California",region_abbr => "CA",street_1 => "4651 Park Boulevard",street_2 => undef}
{city => "San Diego",postal_code => 92101,region => "California",region_abbr => "CA",street_1 => "947 E St.",street_2 => undef}
{city => "San Diego",postal_code => 92117,region => "California",region_abbr => "CA",street_1 => "5501 Clairemont Mesa Blvd",street_2 => undef}
{city => "San Diego",postal_code => 92101,region => "California",region_abbr => "CA",street_1 => "810 4th Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "3843 Richmond St",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "1010 University Avenue",street_2 => undef}
{city => "San Diego",postal_code => 92103,region => "California",region_abbr => "CA",street_1 => "2949 5th Ave",street_2 => undef}
{city => "San Diego",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "646 University Ave.",street_2 => undef}
{city => "San Dimas",postal_code => 91773,region => "California",region_abbr => "CA",street_1 => "641 Arrow Hwy",street_2 => undef}
{city => "San Francisco",postal_code => 94105,region => "California",region_abbr => "CA",street_1 => "142 2nd Street",street_2 => undef}
{city => "San Francisco",postal_code => 94118,region => "California",region_abbr => "CA",street_1 => "200 6th Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94105,region => "California",region_abbr => "CA",street_1 => "110 Natoma St",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "525 Valencia St",street_2 => undef}
{city => "San Francisco",postal_code => 94104,region => "California",region_abbr => "CA",street_1 => "161 Sutter St.",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "Marina Blvd & Laguna St",street_2 => "Fort Mason Building A"}
{city => "San Francisco",postal_code => 94105,region => "California",region_abbr => "CA",street_1 => "74 New Montgomery Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "698 Haight St",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => " 170 OFarrell Street,",street_2 => undef}
{city => "San Francisco",postal_code => 94108,region => "California",region_abbr => "CA",street_1 => " 152 Kearny Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "508 Valencia St.",street_2 => undef}
{city => "San Francisco",postal_code => 94105,region => "California",region_abbr => "CA",street_1 => "55 2nd Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "3111 16th St",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "339 Taylor Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "508 Haight St",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "501 Haight Street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "754 Kirkham St",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "1331 9th Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "580 Geary Street",street_2 => undef}
{city => "San Francisco",postal_code => 94109,region => "California",region_abbr => "CA",street_1 => "1765 California Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "775 Frederick St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => undef,street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "3906 Judah Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "849 Valencia Street",street_2 => undef}
{city => "San Francisco",postal_code => 94118,region => "California",region_abbr => "CA",street_1 => "832 Clement Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1336 9th Ave.",street_2 => undef}
{city => "San Francisco",postal_code => "94110-2320",region => "California",region_abbr => "CA",street_1 => "983 Valencia St",street_2 => undef}
{city => "San Francisco",postal_code => "94121-2207",region => "California",region_abbr => "CA",street_1 => "1820 Clement St",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "3109 16th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "1688 Bryant St",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "88 4th Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2077 Hayes Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3352 Steiner Street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "2026 Irving St",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "572 OFarrell St",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2154 Mission St",street_2 => undef}
{city => "San Francisco",postal_code => 94118,region => "California",region_abbr => "CA",street_1 => "309 Clement Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "3285 21st St",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "1745 Folsom St",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "531 Divisadero St",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "559 Divisadero St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "553 Divisadero Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "1777 Fulton Street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "1235 9th Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "3352 Steiner Street",street_2 => undef}
{city => "San Francisco",postal_code => 94123,region => "California",region_abbr => "CA",street_1 => "1972 Lombard Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2781 21st Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "1790 Haight St.",street_2 => undef}
{city => "San Francisco",postal_code => 94108,region => "California",region_abbr => "CA",street_1 => "419 Grant Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "903 Cortland Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "543 Divisadero",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "1026  Valencia Street",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "4236 25th St #4",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3344 Steiner St.",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4138 24th St.",street_2 => undef}
{city => "San Francisco",postal_code => "94133-4525",region => "California",region_abbr => "CA",street_1 => "1042 Kearny St",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "762 Valencia St",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "3141 16th Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2234 Mission Street",street_2 => "(Inside Lung Shan Restaurant)"}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2400 Harrison St",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "2312 Market Street",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "560 Divisadero",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "3253 16th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "3182 16th St",street_2 => undef}
{city => "San Francisco",postal_code => 94109,region => "California",region_abbr => "CA",street_1 => "791 Ofarrell St.",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "35 6th street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "4001 Judah Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "3409 24th St",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "553 Haight St",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "615 Cortland Ave",street_2 => undef}
{city => "San Francisco",postal_code => 94102,region => "California",region_abbr => "CA",street_1 => "559 Hayes St",street_2 => undef}
{city => "San Francisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "500 Haight St",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "2323 Mission St",street_2 => undef}
{city => "San Francisco",postal_code => 94114,region => "California",region_abbr => "CA",street_1 => "172 Church Street",street_2 => undef}
{city => "San Francisco",postal_code => 94110,region => "California",region_abbr => "CA",street_1 => "3388 19th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94122,region => "California",region_abbr => "CA",street_1 => "3930 Judah Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "3406 18th Street",street_2 => undef}
{city => "San Francisco",postal_code => 94133,region => "California",region_abbr => "CA",street_1 => "703 Columbus Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94118,region => "California",region_abbr => "CA",street_1 => "309 6th Avenue",street_2 => undef}
{city => "San Francisco",postal_code => 94108,region => "California",region_abbr => "CA",street_1 => "854 Washington Street",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "471 Mission St.",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "191 8th St",street_2 => undef}
{city => "San Francisco",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1007 Valencia St.",street_2 => undef}
{city => "San Francisco",postal_code => 94107,region => "California",region_abbr => "CA",street_1 => "185 Berry Street",street_2 => "China Basin Landing"}
{city => "San Francisco",postal_code => 94133,region => "California",region_abbr => "CA",street_1 => "1365 Stockton St.",street_2 => undef}
{city => "San Francisco",postal_code => 94103,region => "California",region_abbr => "CA",street_1 => "1298 Market Street",street_2 => undef}
{city => "San Francisco",postal_code => 94133,region => "California",region_abbr => "CA",street_1 => "450 Broadway St",street_2 => undef}
{city => "San Francisco",postal_code => 94107,region => "California",region_abbr => "CA",street_1 => "399 4th Street",street_2 => undef}
{city => "San Fransisco",postal_code => 94117,region => "California",region_abbr => "CA",street_1 => "11665 Haight St.",street_2 => undef}
{city => "San Gabriel",postal_code => 91776,region => "California",region_abbr => "CA",street_1 => "841 W Las Tunas Dr",street_2 => undef}
{city => "San Gabriel",postal_code => 91776,region => "California",region_abbr => "CA",street_1 => "140 W Valley Blvd",street_2 => "#222"}
{city => "San Jose",postal_code => 95113,region => "California",region_abbr => "CA",street_1 => "388 E Santa Clara Street",street_2 => undef}
{city => "San Jose",postal_code => 95111,region => "California",region_abbr => "CA",street_1 => "2597 Senter Road",street_2 => undef}
{city => "San Jose",postal_code => 95113,region => "California",region_abbr => "CA",street_1 => "37 S. 1st Street",street_2 => undef}
{city => "San Jose",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1111 Story Rd",street_2 => "#1009 Grand Century Plaza"}
{city => "San Jose",postal_code => 95118,region => "California",region_abbr => "CA",street_1 => "1711 Branham Lane",street_2 => "Suite A9"}
{city => "San Jose",postal_code => 95125,region => "California",region_abbr => "CA",street_1 => "1346 Lincoln Avenue",street_2 => undef}
{city => "San Jose",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1644 E. Capitol Expressway",street_2 => undef}
{city => "San Jose",postal_code => 95112,region => "California",region_abbr => "CA",street_1 => "520 E Santa Clara St.",street_2 => undef}
{city => "San Jose",postal_code => 95113,region => "California",region_abbr => "CA",street_1 => "80 N. Market",street_2 => undef}
{city => "San Jose",postal_code => 95113,region => "California",region_abbr => "CA",street_1 => "322 East Santa Clara Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "726 Higuera Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "698 Higuera Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93405,region => "California",region_abbr => "CA",street_1 => "1110 Garden Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1121 Broad Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "675 Higuera Street",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93401,region => "California",region_abbr => "CA",street_1 => "1011 Higuera St",street_2 => undef}
{city => "San Luis Obispo",postal_code => 93405,region => "California",region_abbr => "CA",street_1 => "773 Foothill Blvd.",street_2 => undef}
{city => "San Mateo",postal_code => 94401,region => "California",region_abbr => "CA",street_1 => "5 S Ellsworth Ave",street_2 => undef}
{city => "San Mateo",postal_code => 94401,region => "California",region_abbr => "CA",street_1 => "4 E. Fourth Avenue",street_2 => undef}
{city => "San Rafael",postal_code => 94901,region => "California",region_abbr => "CA",street_1 => "2200 Fourth Street",street_2 => undef}
{city => "Santa Ana",postal_code => 92701,region => "California",region_abbr => "CA",street_1 => "125 N Broadway",street_2 => undef}
{city => "Santa Ana",postal_code => 92706,region => "California",region_abbr => "CA",street_1 => "2202 1/2 North Main Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93101,region => "California",region_abbr => "CA",street_1 => "134 E. Canon Perdido St.",street_2 => undef}
{city => "Santa Barbara",postal_code => 93101,region => "California",region_abbr => "CA",street_1 => "508 State Street",street_2 => undef}
{city => "Santa Barbara",postal_code => 93105,region => "California",region_abbr => "CA",street_1 => "361 Hitchcock Way",street_2 => undef}
{city => "Santa Clara",postal_code => 95051,region => "California",region_abbr => "CA",street_1 => "2636 Homestead Road",street_2 => undef}
{city => "Santa Clara",postal_code => 95051,region => "California",region_abbr => "CA",street_1 => "3284 El Camino Real",street_2 => undef}
{city => "Santa Clarita",postal_code => 91355,region => "California",region_abbr => "CA",street_1 => "24130 Valencia Blvd",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "514-B Front St.",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "1547 Pacific Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95062,region => "California",region_abbr => "CA",street_1 => "1116 Soquel Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "103 Green Street",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "216 Laurel Street",street_2 => undef}
{city => "Santa Cruz",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "145 Laurel St",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "429 Front Street",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "2341 Mission Street",street_2 => undef}
{city => "Santa Cruz",postal_code => "95060-3913",region => "California",region_abbr => "CA",street_1 => "106 Walnut Ave",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "537 Seabright Avenue",street_2 => undef}
{city => "Santa Cruz",postal_code => 95060,region => "California",region_abbr => "CA",street_1 => "105 S. River Street",street_2 => undef}
{city => "Santa Maria",postal_code => 93454,region => "California",region_abbr => "CA",street_1 => "2407 S. Broadway",street_2 => undef}
{city => "Santa Monica",postal_code => 90403,region => "California",region_abbr => "CA",street_1 => "1909 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1928 Lincoln Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "326 Wilshire Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => 90403,region => "California",region_abbr => "CA",street_1 => "1425 Montana Ave",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "514 Santa Monica Boulevard",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "500 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1120 Wilshire Blvd.",street_2 => undef}
{city => "Santa Monica",postal_code => 90405,region => "California",region_abbr => "CA",street_1 => "2301 Main Street",street_2 => undef}
{city => "Santa Monica",postal_code => 90406,region => "California",region_abbr => "CA",street_1 => "P.O. Box 1706",street_2 => undef}
{city => "Santa Monica",postal_code => 90401,region => "California",region_abbr => "CA",street_1 => "316 Santa Monica Boulevard",street_2 => undef}
{city => "Santa Monica",postal_code => 90403,region => "California",region_abbr => "CA",street_1 => "1405 Montana Ave.",street_2 => undef}
{city => "Santa Monica",postal_code => 90403,region => "California",region_abbr => "CA",street_1 => "2627 Wilshire Blvd",street_2 => undef}
{city => "Santa Monica",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "225 26th St.",street_2 => undef}
{city => "Santa Rosa",postal_code => 95403,region => "California",region_abbr => "CA",street_1 => "3080 Marlow Road",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "507 4th Street",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "1899 Mendocino Avenue",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "463 Sebastopol Avenue",street_2 => undef}
{city => "Santa Rosa",postal_code => 95405,region => "California",region_abbr => "CA",street_1 => "909 Village Court",street_2 => undef}
{city => "Santa Rosa",postal_code => 95405,region => "California",region_abbr => "CA",street_1 => "1181 Yulupa Ave",street_2 => undef}
{city => "Santa Rosa",postal_code => 95407,region => "California",region_abbr => "CA",street_1 => "2100 Santa Rosa Ave",street_2 => "3225 Cleveland Ave"}
{city => "Santa Rosa",postal_code => 95407,region => "California",region_abbr => "CA",street_1 => "409 Mendocino Ave",street_2 => undef}
{city => "Santa Rosa",postal_code => 95401,region => "California",region_abbr => "CA",street_1 => "57 Montgomery Dr",street_2 => undef}
{city => "Santee",postal_code => 92071,region => "California",region_abbr => "CA",street_1 => "9751 Mission Gorge Rd",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "841 Gravenstein Highway South",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "775 Gravenstein Avenue",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "1691 Highway 116 North",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "6910 McKinley St",street_2 => undef}
{city => "Sebastopol",postal_code => 95472,region => "California",region_abbr => "CA",street_1 => "6970 McKinley St",street_2 => undef}
{city => "Sherman Oaks",postal_code => 91423,region => "California",region_abbr => "CA",street_1 => "14318 Ventura Blvd",street_2 => undef}
{city => "Sherman Oaks",postal_code => 91403,region => "California",region_abbr => "CA",street_1 => "4454 Van Nuys Blvd.",street_2 => undef}
{city => "Sherman Oaks",postal_code => 91403,region => "California",region_abbr => "CA",street_1 => "15025 Ventura Blvd.",street_2 => undef}
{city => "Sherman Oaks",postal_code => 91403,region => "California",region_abbr => "CA",street_1 => "15301 Ventura Blvd.",street_2 => "Suite P-22"}
{city => "Sherman Oaks",postal_code => 91423,region => "California",region_abbr => "CA",street_1 => "13722 Ventura Blvd.",street_2 => undef}
{city => "Silver Lake",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "4114 Santa Monica Blvd",street_2 => undef}
{city => "Silverlake",postal_code => 90027,region => "California",region_abbr => "CA",street_1 => "2609 N. Hyperion Avenue",street_2 => undef}
{city => "Simi Valley",postal_code => 93063,region => "California",region_abbr => "CA",street_1 => "2667 Tapo Canyon Road",street_2 => "Unit G"}
{city => "Solana Beach",postal_code => 92075,region => "California",region_abbr => "CA",street_1 => "659 Lomas Santa Fe Dr",street_2 => undef}
{city => "South El Monte",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "9324 E Garvey Ave",street_2 => "#8"}
{city => "South Lake Tahoe",postal_code => 96150,region => "California",region_abbr => "CA",street_1 => "3125 Harrison Ave",street_2 => undef}
{city => "South Lake Tahoe",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "2180 Lake Tahoe Blvd",street_2 => undef}
{city => "South Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1119 Fair Oaks Ave.",street_2 => undef}
{city => "South Pasadena",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "Meridian Avenue",street_2 => "(at Mission st.)"}
{city => "Studio City",postal_code => 91607,region => "California",region_abbr => "CA",street_1 => "12851 Riverside Drive",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "11838 Ventura Blvd.",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "12445 Moorpark Street",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "11943 Ventura Blvd.",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "11320 Ventura Blvd.",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "13045 Ventura Boulevard",street_2 => undef}
{city => "Studio City",postal_code => 91604,region => "California",region_abbr => "CA",street_1 => "12215 Ventura Blvd",street_2 => "#101"}
{city => "Studio City",postal_code => 91607,region => "California",region_abbr => "CA",street_1 => "4749 Coldwater Canyon",street_2 => undef}
{city => "Sunnyvale",postal_code => 94086,region => "California",region_abbr => "CA",street_1 => "562 S. Murphy Avenue",street_2 => undef}
{city => "Sunnyvale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "172 S. Murphy Ave",street_2 => undef}
{city => "Sunnyvale",postal_code => 94085,region => "California",region_abbr => "CA",street_1 => "500 Lawrence Expy",street_2 => undef}
{city => "Sunnyvale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "1177 El Camino Real",street_2 => undef}
{city => "Sunnyvale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "460 Persian Drive",street_2 => undef}
{city => "Sunnyvale",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "976 El Camino Real",street_2 => undef}
{city => "Sunnyvale",postal_code => 94086,region => "California",region_abbr => "CA",street_1 => "548-2 Lawrence Expressway",street_2 => undef}
{city => "Sunnyvale",postal_code => 94087,region => "California",region_abbr => "CA",street_1 => "939 W El Camino Real",street_2 => undef}
{city => "Tarzana",postal_code => 91356,region => "California",region_abbr => "CA",street_1 => "19337 Ventura Blvd.",street_2 => undef}
{city => "Tarzana",postal_code => 91335,region => "California",region_abbr => "CA",street_1 => "6117 Reseda Blvd",street_2 => undef}
{city => "Tarzana",postal_code => 91356,region => "California",region_abbr => "CA",street_1 => "18621 Ventura Blvd.",street_2 => undef}
{city => "Temecula",postal_code => 92592,region => "California",region_abbr => "CA",street_1 => "32413 State Highway 79",street_2 => undef}
{city => "Topanga",postal_code => 90290,region => "California",region_abbr => "CA",street_1 => "128 Old Topanga Canyon Rd",street_2 => undef}
{city => "Truckee",postal_code => 96161,region => "California",region_abbr => "CA",street_1 => "11357 Donner Pass Rd.",street_2 => undef}
{city => "Ukiah",postal_code => 95482,region => "California",region_abbr => "CA",street_1 => "4951 Bodhi Way",street_2 => undef}
{city => "Upland",postal_code => 91786,region => "California",region_abbr => "CA",street_1 => "903 W Foothill Blvd",street_2 => undef}
{city => "Valley Village",postal_code => 91607,region => "California",region_abbr => "CA",street_1 => "5217 Laurel Canyon Blvd.",street_2 => undef}
{city => "Van Nuys",postal_code => 91411,region => "California",region_abbr => "CA",street_1 => "14838 Burbank Blvd.",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1809 Ocean Front Walk",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "2024 Pacific Ave.",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1604 Pacific Avenue",street_2 => undef}
{city => "Venice",postal_code => 90291,region => "California",region_abbr => "CA",street_1 => "1009 Abbot Kinney Blvd",street_2 => undef}
{city => "Ventura",postal_code => 93003,region => "California",region_abbr => "CA",street_1 => "4071 East Main Street",street_2 => undef}
{city => "Ventura",postal_code => 93001,region => "California",region_abbr => "CA",street_1 => "100 South Fir St.",street_2 => undef}
{city => "Visalia",postal_code => 93277,region => "California",region_abbr => "CA",street_1 => "5101 W. Walnut Avenue",street_2 => undef}
{city => "West Covina",postal_code => 91790,region => "California",region_abbr => "CA",street_1 => "178 South Glendora Avenue",street_2 => undef}
{city => "West Hollywood",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8253 Santa Monica Blvd.",street_2 => undef}
{city => "West Hollywood",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "8565 Melrose Ave.",street_2 => undef}
{city => "West Hollywood",postal_code => 90046,region => "California",region_abbr => "CA",street_1 => "8158 W. Sunset Blvd.",street_2 => undef}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8607 Melrose Avenue",street_2 => undef}
{city => "West Hollywood",postal_code => 90048,region => "California",region_abbr => "CA",street_1 => "414 N. La Cienega Boulevard",street_2 => undef}
{city => "West Hollywood",postal_code => 90036,region => "California",region_abbr => "CA",street_1 => "7660 Beverly Blvd.",street_2 => "Suite B"}
{city => "West Hollywood",postal_code => 90069,region => "California",region_abbr => "CA",street_1 => "8401 Santa Monica Blvd",street_2 => undef}
{city => "Westchester",postal_code => 90045,region => "California",region_abbr => "CA",street_1 => "6245 West 87th Street",street_2 => undef}
{city => "Westchester",postal_code => 90045,region => "California",region_abbr => "CA",street_1 => "8320 Lincoln Blvd.",street_2 => undef}
{city => "Westlake Village",postal_code => 91362,region => "California",region_abbr => "CA",street_1 => "968 S. Westlake Blvd.",street_2 => undef}
{city => "Westwood",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "1110 1/2 Gayley Ave.",street_2 => undef}
{city => "Westwood",postal_code => 90024,region => "California",region_abbr => "CA",street_1 => "1055 Broxton Avenue",street_2 => undef}
{city => "Whittier",postal_code => undef,region => "California",region_abbr => "CA",street_1 => "6557 Comstock Avenue",street_2 => undef}
{city => "Woodland Hills",postal_code => 91364,region => "California",region_abbr => "CA",street_1 => "21733 Ventura Blvd.",street_2 => undef}
{city => "Yorba Linda",postal_code => 92886,region => "California",region_abbr => "CA",street_1 => "17482 Yorba Linda Blvd.",street_2 => undef}
{city => "Yucaipa",postal_code => 92399,region => "California",region_abbr => "CA",street_1 => "34664 County Line Road",street_2 => "Ste. 15-16"}
{city => "Arvada",postal_code => 80002,region => "Colorado",region_abbr => "CO",street_1 => "5604 Kendall Court",street_2 => undef}
{city => "Arvada",postal_code => 80010,region => "Colorado",region_abbr => "CO",street_1 => "7519 Grandview Avenue",street_2 => undef}
{city => "Aspen",postal_code => 81611,region => "Colorado",region_abbr => "CO",street_1 => "221 East Main Street",street_2 => undef}
{city => "Aurora",postal_code => 80012,region => "Colorado",region_abbr => "CO",street_1 => "1014 S. Peoria St.",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1175 Walnut St.",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "3980 Broadway",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2151 Arapahoe Ave",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "1200 Yarmouth Ave.",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1738 Pearl Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1922 13th St",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2017 13th Street",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => undef,street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1800 Broadway",street_2 => "#150"}
{city => "Boulder",postal_code => 80304,region => "Colorado",region_abbr => "CO",street_1 => "4479 Broadway St",street_2 => undef}
{city => "Boulder",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => "4720 Table Mesa Dr.",street_2 => undef}
{city => "Boulder",postal_code => 80303,region => "Colorado",region_abbr => "CO",street_1 => "800 28th St.",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "1600 28th Street",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "3073 Walnut Street",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "673 S. Broadway",street_2 => undef}
{city => "Boulder",postal_code => 80304,region => "Colorado",region_abbr => "CO",street_1 => "2785 Iris Avenue",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2027 13th Street",street_2 => undef}
{city => "Boulder",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => "607A South Broadway",street_2 => "Table Mesa Shopping Center"}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "2850 Iris Avenue",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2299 Pearl St",street_2 => undef}
{city => "Breckenridge",postal_code => 80424,region => "Colorado",region_abbr => "CO",street_1 => "400 N. Park Avenue",street_2 => undef}
{city => "Carbondale",postal_code => 81623,region => "Colorado",region_abbr => "CO",street_1 => "904 Highway 133",street_2 => undef}
{city => "Colorado Springs",postal_code => 80000,region => "Colorado",region_abbr => "CO",street_1 => "1747 S. 8th Street",street_2 => undef}
{city => "Colorado Springs",postal_code => 80903,region => "Colorado",region_abbr => "CO",street_1 => "121 South Tejon Street",street_2 => "Plaza of the Rockies, 1st Floor, South Tower"}
{city => "Colorado Springs",postal_code => 80903,region => "Colorado",region_abbr => "CO",street_1 => "28 E. Bijou Street",street_2 => undef}
{city => "Colorado Springs",postal_code => 80903,region => "Colorado",region_abbr => "CO",street_1 => "823 North Tejon Street",street_2 => undef}
{city => "Colorado Springs",postal_code => 80918,region => "Colorado",region_abbr => "CO",street_1 => "5644 N. Academy Blvd",street_2 => undef}
{city => "Colorado Springs",postal_code => 80903,region => "Colorado",region_abbr => "CO",street_1 => "520 S. Tejon Street",street_2 => undef}
{city => "Colorado Springs",postal_code => 80903,region => "Colorado",region_abbr => "CO",street_1 => "324 1/2 N. Tejon St.",street_2 => undef}
{city => "Colorado Springs",postal_code => 80904,region => "Colorado",region_abbr => "CO",street_1 => "1625 W. Uintah Street",street_2 => undef}
{city => "Colorado Springs",postal_code => 80905,region => "Colorado",region_abbr => "CO",street_1 => "830 Arcturus Drive",street_2 => undef}
{city => "Colorado Springs",postal_code => 80909,region => "Colorado",region_abbr => "CO",street_1 => "1837 N. Circle Drive",street_2 => undef}
{city => "Denver",postal_code => 80246,region => "Colorado",region_abbr => "CO",street_1 => "435 S. Cherry St.",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "2231 S. Broadway",street_2 => undef}
{city => "Denver",postal_code => 80211,region => "Colorado",region_abbr => "CO",street_1 => "1600 W. 33rd Avenue",street_2 => undef}
{city => "Denver",postal_code => 80203,region => "Colorado",region_abbr => "CO",street_1 => "E. 17th Ave and Lincoln Street",street_2 => undef}
{city => "Denver",postal_code => 80203,region => "Colorado",region_abbr => "CO",street_1 => "1 Broadway",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "1700 Vine Street",street_2 => undef}
{city => "Denver",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1535 Pearl Street",street_2 => undef}
{city => "Denver",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => "627 South Broadway",street_2 => undef}
{city => "Denver",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "540 E Alameda Ave",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "287 Columbine St",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "3103 East Colfax Avenue",street_2 => undef}
{city => "Denver",postal_code => 80229,region => "Colorado",region_abbr => "CO",street_1 => "3 S. Broadway",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1476 S. Pearl Street",street_2 => undef}
{city => "Denver",postal_code => 80222,region => "Colorado",region_abbr => "CO",street_1 => "6460 E. Yale Ave.",street_2 => undef}
{city => "Denver",postal_code => 80203,region => "Colorado",region_abbr => "CO",street_1 => "52 Broadway",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "2023 E. Colfax Avenue",street_2 => undef}
{city => "Denver",postal_code => 80212,region => "Colorado",region_abbr => "CO",street_1 => "4335 W. 44th Avenue",street_2 => undef}
{city => "Denver",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "200 Quebec St.",street_2 => undef}
{city => "Denver",postal_code => 80212,region => "Colorado",region_abbr => "CO",street_1 => "3945 Tennyson Street",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "845 Colorado Blvd",street_2 => undef}
{city => "Denver",postal_code => 80209,region => "Colorado",region_abbr => "CO",street_1 => "301 S. Pennsylvania Street",street_2 => undef}
{city => "Denver",postal_code => 80212,region => "Colorado",region_abbr => "CO",street_1 => "4370 Tennyson Street",street_2 => undef}
{city => "Denver",postal_code => 80202,region => "Colorado",region_abbr => "CO",street_1 => "1612 Wazee Street",street_2 => undef}
{city => "Denver",postal_code => 80204,region => "Colorado",region_abbr => "CO",street_1 => "4930 W. Colfax Ave.",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1475 S Pearl St",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1551 S Pearl St",street_2 => undef}
{city => "Denver",postal_code => 80222,region => "Colorado",region_abbr => "CO",street_1 => "2710 S. Colorado Blvd",street_2 => undef}
{city => "Estes Park",postal_code => 80517,region => "Colorado",region_abbr => "CO",street_1 => "429 W Elkhorn Avenue",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "605 S. Mason Street",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "346 E Mountain Avenue",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "101 South College Avenue",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "214 Linden St.",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "144 N. College Ave.",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "249 South College Ave",street_2 => undef}
{city => "Fort Collins",postal_code => 80525,region => "Colorado",region_abbr => "CO",street_1 => "2720 Council Tree Ave.",street_2 => "Suite 184"}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "130 S Mason St",street_2 => undef}
{city => "Glendale",postal_code => 80246,region => "Colorado",region_abbr => "CO",street_1 => "1000 S. Colorado Blvd",street_2 => undef}
{city => "Golden",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "14403 W. Colfax Ave.",street_2 => undef}
{city => "Golden",postal_code => 80401,region => "Colorado",region_abbr => "CO",street_1 => "1110 Washington Ave.",street_2 => undef}
{city => "Greenwood Village",postal_code => 80111,region => "Colorado",region_abbr => "CO",street_1 => "4940 S. Yosemite St",street_2 => "E-9"}
{city => "Lakewood",postal_code => 80227,region => "Colorado",region_abbr => "CO",street_1 => "3355 S. Wadsworth Blvd",street_2 => undef}
{city => "Lone Tree",postal_code => 80124,region => "Colorado",region_abbr => "CO",street_1 => "8439 Park Meadows Center Drive",street_2 => undef}
{city => "Manitou Springs",postal_code => 80829,region => "Colorado",region_abbr => "CO",street_1 => "934 Manitou Avenue",street_2 => undef}
{city => "Minturn",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "152 Main Street",street_2 => undef}
{city => "Red Feather Lakes",postal_code => 80545,region => "Colorado",region_abbr => "CO",street_1 => "4921 County Rd 68-C",street_2 => undef}
{city => "Telluride",postal_code => 81435,region => "Colorado",region_abbr => "CO",street_1 => "123 E. Colorado Ave.",street_2 => undef}
{city => "Telluride",postal_code => 81435,region => "Colorado",region_abbr => "CO",street_1 => "135 East Colorado Avenue",street_2 => undef}
{city => "Wheatridge",postal_code => 80033,region => "Colorado",region_abbr => "CO",street_1 => "3890 Kipling St",street_2 => undef}
{city => "Aurora",postal_code => 80014,region => "Colorado",region_abbr => "CO",street_1 => "12200 E. Cornell Ave",street_2 => "Suite S"}
{city => "Aurora",postal_code => 80014,region => "Colorado",region_abbr => "CO",street_1 => "3140 S Parker Rd",street_2 => "#8"}
{city => "Aurora",postal_code => 80014,region => "Colorado",region_abbr => "CO",street_1 => "12131 E Iliff Ave",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1650 Broadway St",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "2905 Pearl Street",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "1678 30th St",street_2 => undef}
{city => "Boulder",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => "2630 Baseline Rd",street_2 => undef}
{city => "Boulder",postal_code => 80303,region => "Colorado",region_abbr => "CO",street_1 => "4800 Baseline Road",street_2 => "#108"}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "1630 30th St",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1911 Broadway St.",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "2111 30th",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1651 Broadway Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2010 16th St",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "2716 28th St.",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1701 Pearl St",street_2 => undef}
{city => "Boulder",postal_code => 80306,region => "Colorado",region_abbr => "CO",street_1 => "1904 Pearl St",street_2 => undef}
{city => "Boulder",postal_code => 80304,region => "Colorado",region_abbr => "CO",street_1 => "3267 28th St.",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "1600 Broadway",street_2 => undef}
{city => "Boulder",postal_code => 80304,region => "Colorado",region_abbr => "CO",street_1 => "2793 Iris Ave.",street_2 => undef}
{city => "Boulder",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => "2584 Baseline Rd.",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1215 13th street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1718 Broadway",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "1770 13th Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1911 Broadway Street",street_2 => undef}
{city => "Boulder",postal_code => 80303,region => "Colorado",region_abbr => "CO",street_1 => "3053 Arapahoe Ave",street_2 => undef}
{city => "Boulder",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "2905 Pearl St.",street_2 => undef}
{city => "Boulder",postal_code => 80303,region => "Colorado",region_abbr => "CO",street_1 => "3075B Arapahoe Ave",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1002 Walnut Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => " 2010 14th St",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1535 Pearl Street",street_2 => undef}
{city => "Boulder",postal_code => 80305,region => "Colorado",region_abbr => "CO",street_1 => " 627 South Broadway",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2299 Pearl Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1050 Walnut Street",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2525 Arapahoe",street_2 => "Suite E4-335"}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1224 Pennsylvania Ave",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "2525 Arapahoe",street_2 => "Suite E4-335"}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1647 Arapahoe Ave",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1904 Pearl St",street_2 => undef}
{city => "Boulder",postal_code => 80302,region => "Colorado",region_abbr => "CO",street_1 => "1719 Broadway",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "8328 Valmont Road",street_2 => undef}
{city => "Boulder",postal_code => 80308,region => "Colorado",region_abbr => "CO",street_1 => "P.O. Box 18745",street_2 => undef}
{city => "Boulder",postal_code => 80304,region => "Colorado",region_abbr => "CO",street_1 => "1275 Alpine Ave",street_2 => undef}
{city => "Boulder",postal_code => 80301,region => "Colorado",region_abbr => "CO",street_1 => "2655 28th St",street_2 => undef}
{city => "Broomfield",postal_code => 80020,region => "Colorado",region_abbr => "CO",street_1 => "1000 Depot Hill Rd",street_2 => "Unit E"}
{city => "Colorado Springs",postal_code => 80920,region => "Colorado",region_abbr => "CO",street_1 => "7635 N Academy Blvd",street_2 => undef}
{city => "Colorado Springs",postal_code => 80907,region => "Colorado",region_abbr => "CO",street_1 => "1466 Garden of the Gods Road",street_2 => undef}
{city => "Colorado Springs",postal_code => 80922,region => "Colorado",region_abbr => "CO",street_1 => "3180 N New Center Point",street_2 => undef}
{city => "Copper Mountain",postal_code => 80443,region => "Colorado",region_abbr => "CO",street_1 => "189 10 Mile Circle",street_2 => undef}
{city => "Del Norte",postal_code => 81132,region => "Colorado",region_abbr => "CO",street_1 => "14475 W. Hwy 160",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1111 S Washington St",street_2 => undef}
{city => "Denver",postal_code => 80203,region => "Colorado",region_abbr => "CO",street_1 => "955 Lincoln Ave",street_2 => undef}
{city => "Denver",postal_code => 80219,region => "Colorado",region_abbr => "CO",street_1 => " 333 S. Federal Blvd.",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "2375 E 1st Ave.",street_2 => undef}
{city => "Denver",postal_code => 80231,region => "Colorado",region_abbr => "CO",street_1 => "7400 E. Hampden Ave.",street_2 => undef}
{city => "Denver",postal_code => 80203,region => "Colorado",region_abbr => "CO",street_1 => "206 E. 13th Ave.",street_2 => undef}
{city => "Denver",postal_code => 80207,region => "Colorado",region_abbr => "CO",street_1 => "3435 Albion St.",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "2525 S. Downing St.",street_2 => undef}
{city => "Denver",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "1400 Cherry St",street_2 => undef}
{city => "Denver",postal_code => 80218,region => "Colorado",region_abbr => "CO",street_1 => "837 E. 17th Ave.",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "2800 E. 2nd Avenue",street_2 => "Fillmore Plaza"}
{city => "Denver",postal_code => 80202,region => "Colorado",region_abbr => "CO",street_1 => "1514 Blake St.",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1890 E. Evans Ave.",street_2 => undef}
{city => "Denver",postal_code => 80211,region => "Colorado",region_abbr => "CO",street_1 => "1575 Boulder St",street_2 => undef}
{city => "Denver",postal_code => 80206,region => "Colorado",region_abbr => "CO",street_1 => "P.O.Box 6773",street_2 => undef}
{city => "Denver",postal_code => 80202,region => "Colorado",region_abbr => "CO",street_1 => "2390 S. Downing",street_2 => undef}
{city => "Denver",postal_code => 80205,region => "Colorado",region_abbr => "CO",street_1 => "2199 California St.",street_2 => undef}
{city => "Denver",postal_code => 80222,region => "Colorado",region_abbr => "CO",street_1 => "2276 South Colorado Blvd.",street_2 => undef}
{city => "Denver",postal_code => 80210,region => "Colorado",region_abbr => "CO",street_1 => "1487 S. Pearl St.",street_2 => undef}
{city => "Denver",postal_code => 80218,region => "Colorado",region_abbr => "CO",street_1 => "900 E 11th Ave",street_2 => undef}
{city => "Durango",postal_code => 81301,region => "Colorado",region_abbr => "CO",street_1 => "300 S. Camino del Rio",street_2 => undef}
{city => "Durango",postal_code => 81301,region => "Colorado",region_abbr => "CO",street_1 => "160 East College Drive",street_2 => undef}
{city => "Durango",postal_code => 81301,region => "Colorado",region_abbr => "CO",street_1 => "575 E 8th Ave",street_2 => undef}
{city => "Estes Park",postal_code => 80517,region => "Colorado",region_abbr => "CO",street_1 => "459 E Wonder View Ave",street_2 => "Suite 4"}
{city => "Fort Collins",postal_code => 80525,region => "Colorado",region_abbr => "CO",street_1 => "2201 South College Ave",street_2 => undef}
{city => "Fort Collins",postal_code => 80525,region => "Colorado",region_abbr => "CO",street_1 => "3680 S. Mason St.",street_2 => undef}
{city => "Fort Collins",postal_code => 80524,region => "Colorado",region_abbr => "CO",street_1 => "250 East Mountain Avenue",street_2 => undef}
{city => "Fort Collins",postal_code => 80521,region => "Colorado",region_abbr => "CO",street_1 => "261 S. College Avenue",street_2 => undef}
{city => "Fort Collins",postal_code => 80525,region => "Colorado",region_abbr => "CO",street_1 => "200 W. Foothills Pkwy",street_2 => undef}
{city => "Glendale",postal_code => 80246,region => "Colorado",region_abbr => "CO",street_1 => "870 S Colorado Blvd",street_2 => undef}
{city => "Golden",postal_code => 80401,region => "Colorado",region_abbr => "CO",street_1 => "14357 W Colfax Ave",street_2 => undef}
{city => "Highlands Ranch",postal_code => 80126,region => "Colorado",region_abbr => "CO",street_1 => "9366 South Colorado Blvd",street_2 => "Ste B"}
{city => "Lakewood",postal_code => 80226,region => "Colorado",region_abbr => "CO",street_1 => "444 South Wadsworth Blvd.",street_2 => undef}
{city => "Littleton",postal_code => 80127,region => "Colorado",region_abbr => "CO",street_1 => "8194 S. Kipling Parkway",street_2 => undef}
{city => "Littleton",postal_code => 80121,region => "Colorado",region_abbr => "CO",street_1 => "5910 S University Blvd",street_2 => undef}
{city => "Steamboat Springs",postal_code => undef,region => "Colorado",region_abbr => "CO",street_1 => "595 S Lincoln Av",street_2 => undef}
{city => "Steamboat Springs",postal_code => 80487,region => "Colorado",region_abbr => "CO",street_1 => "1110 Yampa Street",street_2 => "Suite 100"}
{city => "Steamboat Springs",postal_code => 80487,region => "Colorado",region_abbr => "CO",street_1 => "1855 Ski Time Square Drive",street_2 => undef}
{city => "Superior",postal_code => 80027,region => "Colorado",region_abbr => "CO",street_1 => "303 Marshall Road",street_2 => undef}
{city => "Westminster",postal_code => 80031,region => "Colorado",region_abbr => "CO",street_1 => "9229 N Sheridan Blvd",street_2 => undef}
{city => undef,postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "Ashford",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "Bethel",postal_code => "06801",region => "Connecticut",region_abbr => "CT",street_1 => "25 Grassy Plain Street",street_2 => undef}
{city => "Canton",postal_code => "06019",region => "Connecticut",region_abbr => "CT",street_1 => "110 Albany Turnpike",street_2 => "The Shoppes at Farmington Valley"}
{city => "Cheshire",postal_code => "06410",region => "Connecticut",region_abbr => "CT",street_1 => "828 South Main Street",street_2 => undef}
{city => "Danbury",postal_code => "06810",region => "Connecticut",region_abbr => "CT",street_1 => "5860 Newtown Road",street_2 => undef}
{city => "Fairfield",postal_code => "06824",region => "Connecticut",region_abbr => "CT",street_1 => "1891 Post Road",street_2 => undef}
{city => "Farmington",postal_code => "06032",region => "Connecticut",region_abbr => "CT",street_1 => "1600 S East Rd",street_2 => undef}
{city => "Granby",postal_code => "06035",region => "Connecticut",region_abbr => "CT",street_1 => "10 Hartford Avenue",street_2 => undef}
{city => "Hamden",postal_code => "06518",region => "Connecticut",region_abbr => "CT",street_1 => "3040 Whitney Ave",street_2 => undef}
{city => "Hamden",postal_code => "06517",region => "Connecticut",region_abbr => "CT",street_1 => "1248 Whitney Ave.",street_2 => undef}
{city => "Hamden",postal_code => "06518",region => "Connecticut",region_abbr => "CT",street_1 => "3584 Whitney Ave.",street_2 => undef}
{city => "Hartford",postal_code => "06105",region => "Connecticut",region_abbr => "CT",street_1 => "529 Farmington Avenue",street_2 => undef}
{city => "Hartford",postal_code => "06105-3177",region => "Connecticut",region_abbr => "CT",street_1 => "248 Sisson Ave.",street_2 => undef}
{city => "Hartford",postal_code => "06106",region => "Connecticut",region_abbr => "CT",street_1 => "203 New Britain Avenue",street_2 => undef}
{city => "Manchester",postal_code => "06040",region => "Connecticut",region_abbr => "CT",street_1 => "404 Middle Turnpike West",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "749 Saybrook Road",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "386 Main Street",street_2 => undef}
{city => "Milford",postal_code => "06460",region => "Connecticut",region_abbr => "CT",street_1 => "37 Naugatuck Avenue",street_2 => undef}
{city => "Milford",postal_code => "06460",region => "Connecticut",region_abbr => "CT",street_1 => "246 New Haven Ave",street_2 => undef}
{city => "New Haven",postal_code => "06511-4819",region => "Connecticut",region_abbr => "CT",street_1 => "1151 Chapel St",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "176 Temple St.",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "1227 Chapel St",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "1000 Chapel Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "379 Whalley Ave.",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "85 Howe St.",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "44 Whitney Ave.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "15 Broadway",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "603 Orange St.",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "1022 Chapel St.",street_2 => undef}
{city => "New Haven",postal_code => "06515",region => "Connecticut",region_abbr => "CT",street_1 => "869 Whalley Avenue",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "67 Whitney Ave",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "68 Howe St.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "140 Howe Street",street_2 => undef}
{city => "North Branford",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "2025 Foxon Rd",street_2 => undef}
{city => "Simsbury",postal_code => "06070",region => "Connecticut",region_abbr => "CT",street_1 => "545 Hopmeadow Avenue",street_2 => "Simsmore Square Plaza"}
{city => "Stratford",postal_code => "06614",region => "Connecticut",region_abbr => "CT",street_1 => "922 Barnum Avenue Cutoff",street_2 => undef}
{city => "West Hartford",postal_code => "06107",region => "Connecticut",region_abbr => "CT",street_1 => "50 Raymond Road",street_2 => undef}
{city => "West Hartford",postal_code => "06110",region => "Connecticut",region_abbr => "CT",street_1 => "526 New Park Avenue",street_2 => undef}
{city => "West Hartford",postal_code => "06117",region => "Connecticut",region_abbr => "CT",street_1 => "340 N. Main St",street_2 => undef}
{city => "Westport",postal_code => "06880",region => "Connecticut",region_abbr => "CT",street_1 => "399 Post Rd W",street_2 => undef}
{city => "Ashford",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "Bloomfield",postal_code => "06002",region => "Connecticut",region_abbr => "CT",street_1 => "8 Mountain Ave.",street_2 => undef}
{city => "Bridgeport",postal_code => "06604",region => "Connecticut",region_abbr => "CT",street_1 => "1001-11 Main Street",street_2 => undef}
{city => "Bridgeport",postal_code => "06605",region => "Connecticut",region_abbr => "CT",street_1 => "2889 Fairfield Avenue",street_2 => undef}
{city => "Bridgeport",postal_code => "06605",region => "Connecticut",region_abbr => "CT",street_1 => "85 Ferris Street",street_2 => undef}
{city => "Bridgeport",postal_code => "06605",region => "Connecticut",region_abbr => "CT",street_1 => "2984 Fairfield Avenue",street_2 => undef}
{city => "Bridgeport",postal_code => "06606",region => "Connecticut",region_abbr => "CT",street_1 => "520 Capitol Avenue",street_2 => undef}
{city => "Central Manchester",postal_code => "06040",region => "Connecticut",region_abbr => "CT",street_1 => "232 Spencer Street",street_2 => undef}
{city => "Danbury",postal_code => "06811",region => "Connecticut",region_abbr => "CT",street_1 => "54 Pembroke Rd",street_2 => undef}
{city => "Danbury",postal_code => "06810",region => "Connecticut",region_abbr => "CT",street_1 => "68 W. Wooster Street",street_2 => undef}
{city => "Danbury",postal_code => "06810",region => "Connecticut",region_abbr => "CT",street_1 => "7 Backus Avenue",street_2 => undef}
{city => "Danbury",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "113 Mill Plain Road",street_2 => "Trader Joe's Center"}
{city => "Danbury",postal_code => "06810",region => "Connecticut",region_abbr => "CT",street_1 => "113 Mill Plain Rd",street_2 => undef}
{city => "Darien",postal_code => "06820",region => "Connecticut",region_abbr => "CT",street_1 => "25-11 Old Kings Highway N.",street_2 => undef}
{city => "Fairfield",postal_code => "06824",region => "Connecticut",region_abbr => "CT",street_1 => "39 Unqowa Road",street_2 => undef}
{city => "Fairfield",postal_code => "06432",region => "Connecticut",region_abbr => "CT",street_1 => "2088 Black Rock Turnpike",street_2 => undef}
{city => "Fairfield",postal_code => "06824",region => "Connecticut",region_abbr => "CT",street_1 => "2217 Post Rd",street_2 => undef}
{city => "Georgetown",postal_code => "06829",region => "Connecticut",region_abbr => "CT",street_1 => "8 Main Street",street_2 => undef}
{city => "Glastonbury",postal_code => "06033",region => "Connecticut",region_abbr => "CT",street_1 => "225 Hebron Avenue",street_2 => undef}
{city => "Guilford",postal_code => "06437",region => "Connecticut",region_abbr => "CT",street_1 => "345 Boston Post Road",street_2 => undef}
{city => "Guilford",postal_code => "06437",region => "Connecticut",region_abbr => "CT",street_1 => "500 Village Walk",street_2 => undef}
{city => "Hartford",postal_code => "06105",region => "Connecticut",region_abbr => "CT",street_1 => "248 Sisson Avenue",street_2 => undef}
{city => "Hartford",postal_code => "06120",region => "Connecticut",region_abbr => "CT",street_1 => "3347 Main Street",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "386 Main Street",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "570 Main Street",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "360 Main Street",street_2 => undef}
{city => "Middletown",postal_code => "06457",region => "Connecticut",region_abbr => "CT",street_1 => "1300 S. Main Street",street_2 => undef}
{city => "Milford",postal_code => "06460",region => "Connecticut",region_abbr => "CT",street_1 => "1400 Boston Post Rd",street_2 => undef}
{city => "Milford",postal_code => "06460",region => "Connecticut",region_abbr => "CT",street_1 => "2007 Bridgeport Avenue",street_2 => undef}
{city => "Mystic",postal_code => "06355",region => "Connecticut",region_abbr => "CT",street_1 => "7 Water St.",street_2 => undef}
{city => "New Canaan",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "2 Morse Court",street_2 => undef}
{city => "New Hartford",postal_code => "06057",region => "Connecticut",region_abbr => "CT",street_1 => "526 Main Street",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "21 Whitney Ave.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "142 York Street",street_2 => undef}
{city => "New Haven",postal_code => "06516",region => "Connecticut",region_abbr => "CT",street_1 => "166 York Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "1150 Chapel St.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "117 Whalley Ave",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "York St. and Center St.",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "534 Orange Street",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "157 Wooster Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "172 York St",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "194 York Street",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "1010 State St.",street_2 => "The Upper State Farm Market"}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "1140 Chapel St.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "516 Chapel St.",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "65 Broadway",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "105 Howe Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "141 Orange Street",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "77 Whitney Avenue",street_2 => undef}
{city => "New Haven",postal_code => "06510",region => "Connecticut",region_abbr => "CT",street_1 => "140 Orange Street",street_2 => undef}
{city => "New Haven",postal_code => "06840",region => "Connecticut",region_abbr => "CT",street_1 => "5 Orange Street",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "76 Orange Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "271 Crown Street",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "1226 Chapel Street",street_2 => undef}
{city => "New Haven",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "46 Whitney Avenue",street_2 => undef}
{city => "New Haven",postal_code => "06511",region => "Connecticut",region_abbr => "CT",street_1 => "104 Audubon Street",street_2 => undef}
{city => "New London",postal_code => "06320",region => "Connecticut",region_abbr => "CT",street_1 => "140 State Street",street_2 => undef}
{city => "New London",postal_code => "06320",region => "Connecticut",region_abbr => "CT",street_1 => "13 Broad Street",street_2 => undef}
{city => "New London",postal_code => "06320",region => "Connecticut",region_abbr => "CT",street_1 => "45 Huntington Streete",street_2 => undef}
{city => "New Milford",postal_code => "06776",region => "Connecticut",region_abbr => "CT",street_1 => "60 Railroad St.",street_2 => undef}
{city => "Newtown",postal_code => "06470",region => "Connecticut",region_abbr => "CT",street_1 => "316 S. Main Street",street_2 => undef}
{city => "North Haven",postal_code => "06473",region => "Connecticut",region_abbr => "CT",street_1 => "132 Middletown Ave.",street_2 => undef}
{city => "Norwalk",postal_code => "06850",region => "Connecticut",region_abbr => "CT",street_1 => "31 Wall Street",street_2 => undef}
{city => "Norwalk",postal_code => "06851",region => "Connecticut",region_abbr => "CT",street_1 => "168 Main Street",street_2 => undef}
{city => "Norwalk",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => undef,street_2 => undef}
{city => "Norwalk",postal_code => "06851",region => "Connecticut",region_abbr => "CT",street_1 => "388 Westport Ave.",street_2 => undef}
{city => "Norwich",postal_code => "06360",region => "Connecticut",region_abbr => "CT",street_1 => "85-91 Main St",street_2 => undef}
{city => "Old Saybrook",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "45 Mill Rock Road East",street_2 => undef}
{city => "Old Saybrook",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "1315 Boston Post Road",street_2 => undef}
{city => "Orange",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "185 Boston Post Road",street_2 => undef}
{city => "Plainville",postal_code => "06062",region => "Connecticut",region_abbr => "CT",street_1 => "120 New Britain Avenue",street_2 => undef}
{city => "Ridgefield",postal_code => "06877",region => "Connecticut",region_abbr => "CT",street_1 => "61 Main Street",street_2 => undef}
{city => "Ridgefield",postal_code => "06877",region => "Connecticut",region_abbr => "CT",street_1 => "109 Danbury Road",street_2 => undef}
{city => "Ridgefield",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "720 Branchville Road",street_2 => undef}
{city => "Rocky Hill",postal_code => "06067",region => "Connecticut",region_abbr => "CT",street_1 => "1860 Silas Deane Hwy",street_2 => undef}
{city => "South Norwalk",postal_code => "06854",region => "Connecticut",region_abbr => "CT",street_1 => "86 Washington Street",street_2 => undef}
{city => "Southington",postal_code => "06489",region => "Connecticut",region_abbr => "CT",street_1 => "151 Queen Street",street_2 => undef}
{city => "Stamford",postal_code => "06905",region => "Connecticut",region_abbr => "CT",street_1 => "926 High Ridge Road",street_2 => undef}
{city => "Stamford",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "245 Main Street",street_2 => undef}
{city => "Stamford",postal_code => "06901",region => "Connecticut",region_abbr => "CT",street_1 => "227 Summer Street",street_2 => undef}
{city => "Stamford",postal_code => "06901",region => "Connecticut",region_abbr => "CT",street_1 => "68 Broad Street",street_2 => undef}
{city => "Stamford",postal_code => "06905",region => "Connecticut",region_abbr => "CT",street_1 => "950 High Ridge Road",street_2 => undef}
{city => "Stamford",postal_code => "06901",region => "Connecticut",region_abbr => "CT",street_1 => "133 Atlantic Street",street_2 => undef}
{city => "Stamford",postal_code => "06901",region => "Connecticut",region_abbr => "CT",street_1 => "209 Atlantic Street",street_2 => undef}
{city => "West Hartford",postal_code => undef,region => "Connecticut",region_abbr => "CT",street_1 => "144 Shield Street",street_2 => undef}
{city => "West Hartford",postal_code => "06107",region => "Connecticut",region_abbr => "CT",street_1 => "50 Memorial Road",street_2 => undef}
{city => "West Hartford",postal_code => "06110",region => "Connecticut",region_abbr => "CT",street_1 => "450 S. Main Street",street_2 => undef}
{city => "West Haven",postal_code => "06516",region => "Connecticut",region_abbr => "CT",street_1 => "215 Boston Post Rd",street_2 => undef}
{city => "West Haven",postal_code => "06516",region => "Connecticut",region_abbr => "CT",street_1 => "427 Elm Street",street_2 => undef}
{city => "Willimantic",postal_code => "06226",region => "Connecticut",region_abbr => "CT",street_1 => "91 Valley Street",street_2 => undef}
{city => "Windsor",postal_code => "06095",region => "Connecticut",region_abbr => "CT",street_1 => "446 Broad Street",street_2 => undef}
{city => "Woodbury",postal_code => "06798",region => "Connecticut",region_abbr => "CT",street_1 => "694 Main Street South",street_2 => undef}
{city => "Washington",postal_code => 20037,region => "District of Columbia",region_abbr => "DC",street_1 => "2150 P St. NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => undef,street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1918 18th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20010,region => "District of Columbia",region_abbr => "DC",street_1 => "1036 Park Road, NW",street_2 => undef}
{city => "Washington",postal_code => 20050,region => "District of Columbia",region_abbr => "DC",street_1 => "2479 18th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2008 18th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20006,region => "District of Columbia",region_abbr => "DC",street_1 => "818 Connecticut Avenue NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "84 T St NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "575 Pennsylvania Avenue, NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "202-448-8005",street_2 => undef}
{city => "Washington",postal_code => 20017,region => "District of Columbia",region_abbr => "DC",street_1 => "3740 12th Street NE",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1778 U St NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1817 M Street NW",street_2 => undef}
{city => "Washington",postal_code => 20007,region => "District of Columbia",region_abbr => "DC",street_1 => "3057 M Street, N.W.",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "815 V St. N.W.",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1338 U Street NW",street_2 => undef}
{city => "Washington",postal_code => 20012,region => "District of Columbia",region_abbr => "DC",street_1 => "7815 Georgia Ave NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "4th Street and Independence Avenue, SW",street_2 => undef}
{city => "Washington",postal_code => 20002,region => "District of Columbia",region_abbr => "DC",street_1 => "2312 Fourth Street NE",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1136 19th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20010,region => "District of Columbia",region_abbr => "DC",street_1 => "3400 11th St NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1346 T Street NW",street_2 => undef}
{city => "Washington",postal_code => 20005,region => "District of Columbia",region_abbr => "DC",street_1 => "1341 L Street, NW",street_2 => undef}
{city => "Washington",postal_code => 20010,region => "District of Columbia",region_abbr => "DC",street_1 => "14th St. NW and Park Road",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => undef,street_2 => undef}
{city => "Washington",postal_code => 20012,region => "District of Columbia",region_abbr => "DC",street_1 => "353 Cedar St. NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1247 20th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20006,region => "District of Columbia",region_abbr => "DC",street_1 => "1924 Pennsylvania Ave, NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "1875 I St., N.W.",street_2 => undef}
{city => "Washington",postal_code => 20002,region => "District of Columbia",region_abbr => "DC",street_1 => "1236 H Street NE",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "701 9th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20007,region => "District of Columbia",region_abbr => "DC",street_1 => "4828 MacArthur Blvd, NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1020 19th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1773 Columbia Rd. NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1513 17th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1400 Irving Street NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1327 Connecticut Ave",street_2 => "2nd Floor"}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "3116 Mt. Pleasant St., N.W",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "1351 Connecticut Avenue NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "618 H St NW",street_2 => undef}
{city => "Washington",postal_code => 20010,region => "District of Columbia",region_abbr => "DC",street_1 => "3155 Mt. Pleasant St., NW",street_2 => undef}
{city => "Washington",postal_code => 20004,region => "District of Columbia",region_abbr => "DC",street_1 => "675 E St NW",street_2 => undef}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "2029 P Street, NW",street_2 => undef}
{city => "Washington",postal_code => 20006,region => "District of Columbia",region_abbr => "DC",street_1 => "800 Connecticut Avenue NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2009 R street NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1817 Columbia Road NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "1025 5th Street NW",street_2 => undef}
{city => "Newark",postal_code => 19711,region => "Delaware",region_abbr => "DE",street_1 => "177 E. Main Street",street_2 => undef}
{city => "Rehoboth Beach",postal_code => 19971,region => "Delaware",region_abbr => "DE",street_1 => "7 S. 1st Street",street_2 => undef}
{city => "Rehoboth Beach",postal_code => 19971,region => "Delaware",region_abbr => "DE",street_1 => "56 Baltimore Avenue",street_2 => undef}
{city => "Rehoboth Beach",postal_code => undef,region => "Delaware",region_abbr => "DE",street_1 => "12 Wilmington Avenue",street_2 => undef}
{city => "Rehoboth Beach",postal_code => 19971,region => "Delaware",region_abbr => "DE",street_1 => "1st Street South",street_2 => "#9"}
{city => "Rehoboth Beach",postal_code => 19971,region => "Delaware",region_abbr => "DE",street_1 => "35 Wilmington Ave",street_2 => undef}
{city => "Rehoboth Beach",postal_code => undef,region => "Delaware",region_abbr => "DE",street_1 => "19730 Coastal Highway",street_2 => undef}
{city => "Rehoboth Beach",postal_code => 19971,region => "Delaware",region_abbr => "DE",street_1 => "715 Rehoboth Avenue",street_2 => "#10"}
{city => "Wilmington",postal_code => 19382,region => "Delaware",region_abbr => "DE",street_1 => "3401 Concord Pike",street_2 => undef}
{city => "Wilmington",postal_code => 19805,region => "Delaware",region_abbr => "DE",street_1 => "600 N. Union Street",street_2 => undef}
{city => "Newark",postal_code => 19711,region => "Delaware",region_abbr => "DE",street_1 => "126 East Main Street",street_2 => undef}
{city => "Newark",postal_code => 19711,region => "Delaware",region_abbr => "DE",street_1 => "280 East Main Street",street_2 => undef}
{city => "Newark",postal_code => undef,region => "Delaware",region_abbr => "DE",street_1 => "2671 Kirkwood Highway",street_2 => undef}
{city => "Washington",postal_code => 20005,region => "District of Columbia",region_abbr => "DC",street_1 => "1415 14th St NW",street_2 => undef}
{city => "Washington",postal_code => 20017,region => "District of Columbia",region_abbr => "DC",street_1 => "3809 12th Street NE",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2425 18th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1942 9th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1114 U Street",street_2 => undef}
{city => "Washington",postal_code => 20006,region => "District of Columbia",region_abbr => "DC",street_1 => "1810 K Street NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "1825 18th St. NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "1782 Florida Ave. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1506 U Street NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "1414 9th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1825 Columbia Rd. NW",street_2 => undef}
{city => "Washington",postal_code => 20003,region => "District of Columbia",region_abbr => "DC",street_1 => "658 Pennsylvania Ave SE",street_2 => undef}
{city => "Washington",postal_code => 20008,region => "District of Columbia",region_abbr => "DC",street_1 => "3425 Connecticut Ave. NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2471 NW 18th Street",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2463 18th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "817 Columbia Rd NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1501 U Street NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "3282 M Street NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "3923 S. Capitol St. SW",street_2 => undef}
{city => "Washington",postal_code => 20003,region => "District of Columbia",region_abbr => "DC",street_1 => "313 Pennsylvania Ave. SE",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "Post Office Pavilion",street_2 => "1100 Pennsylvania Ave., N.W."}
{city => "Washington",postal_code => 20036,region => "District of Columbia",region_abbr => "DC",street_1 => "2029 P St NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "2121 H St.",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "15th & K St. NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "3291 M St. NW",street_2 => "Suite A"}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "6224 3rd St. NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "2928 Georgia Ave NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1370 Park Rd. NW",street_2 => undef}
{city => "Washington",postal_code => 20005,region => "District of Columbia",region_abbr => "DC",street_1 => "1440 P Street NW",street_2 => undef}
{city => "Washington",postal_code => 20012,region => "District of Columbia",region_abbr => "DC",street_1 => "314 Carroll St. NW",street_2 => undef}
{city => "Washington",postal_code => 20007,region => "District of Columbia",region_abbr => "DC",street_1 => "2323 Wisconsin Ave NW",street_2 => undef}
{city => "Washington",postal_code => 20912,region => "District of Columbia",region_abbr => "DC",street_1 => "7071 Carroll Ave.",street_2 => undef}
{city => "Washington",postal_code => 20016,region => "District of Columbia",region_abbr => "DC",street_1 => "4530 40th St NW",street_2 => "Tenley Circle"}
{city => "Washington",postal_code => 20037,region => "District of Columbia",region_abbr => "DC",street_1 => "1101 25th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2434 18th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20004,region => "District of Columbia",region_abbr => "DC",street_1 => "400 8th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20007,region => "District of Columbia",region_abbr => "DC",street_1 => "3287 1/2 M St. NW",street_2 => "Downstairs"}
{city => "Washington",postal_code => 20006,region => "District of Columbia",region_abbr => "DC",street_1 => "1990 K St NW",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1213 U St NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "740 6th St NW",street_2 => undef}
{city => "Washington",postal_code => 20001,region => "District of Columbia",region_abbr => "DC",street_1 => "2606 Georgia Ave., N.W.",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "2021 14th St. NW",street_2 => undef}
{city => "Washington",postal_code => 20015,region => "District of Columbia",region_abbr => "DC",street_1 => "5504 Connecticut Ave., N.W.",street_2 => undef}
{city => "Washington",postal_code => 20009,region => "District of Columbia",region_abbr => "DC",street_1 => "1811 14th Street NW",street_2 => undef}
{city => "Washington",postal_code => 20004,region => "District of Columbia",region_abbr => "DC",street_1 => "901 F St NW",street_2 => undef}
{city => "Washington",postal_code => undef,region => "District of Columbia",region_abbr => "DC",street_1 => "2621 Connecticut Avenue",street_2 => undef}
{city => "Washington",postal_code => 20005,region => "District of Columbia",region_abbr => "DC",street_1 => "1336 14th Street, NW",street_2 => undef}
{city => undef,postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Alachua",postal_code => 32615,region => "Florida",region_abbr => "FL",street_1 => "14521 Main St.",street_2 => undef}
{city => "Alachua",postal_code => 32615,region => "Florida",region_abbr => "FL",street_1 => "15281 NW U.S. Highway 441",street_2 => "Suite 20"}
{city => "Apopka",postal_code => 32703,region => "Florida",region_abbr => "FL",street_1 => "174B Semoran Commerce Place",street_2 => "Suite 122"}
{city => "Boca Raton",postal_code => 33431,region => "Florida",region_abbr => "FL",street_1 => "212 South Federal Highway",street_2 => undef}
{city => "Boca Raton",postal_code => 33431,region => "Florida",region_abbr => "FL",street_1 => "6000 Glades Rd # 1176",street_2 => undef}
{city => "Boca Raton",postal_code => 33432,region => "Florida",region_abbr => "FL",street_1 => "628 Glades Road",street_2 => undef}
{city => "Boca Raton",postal_code => 33432,region => "Florida",region_abbr => "FL",street_1 => "249 E. Palmetto Park Road",street_2 => undef}
{city => "Bonita Springs",postal_code => 34135,region => "Florida",region_abbr => "FL",street_1 => "9118 Bonita Beach Road",street_2 => undef}
{city => "Bradenton",postal_code => 34207,region => "Florida",region_abbr => "FL",street_1 => "6830 14th Street West",street_2 => undef}
{city => "Bradenton",postal_code => 34207,region => "Florida",region_abbr => "FL",street_1 => "6233 14th St W",street_2 => undef}
{city => "Cape Coral",postal_code => 33904,region => "Florida",region_abbr => "FL",street_1 => "1217 SE 47th Terrace",street_2 => undef}
{city => "Cape Coral",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1918 Del Prado Blvd S.",street_2 => "#3"}
{city => "Coconut Grove",postal_code => 33133,region => "Florida",region_abbr => "FL",street_1 => "3415 Main Hwy",street_2 => undef}
{city => "Coral Gables",postal_code => 33134,region => "Florida",region_abbr => "FL",street_1 => "321 Miracle Mile",street_2 => undef}
{city => "Coral Springs",postal_code => 33076,region => "Florida",region_abbr => "FL",street_1 => "11570 Wiles Road",street_2 => undef}
{city => "Coral Springs",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "2908 University Drive",street_2 => "The Walk at University"}
{city => "Davie",postal_code => 33328,region => "Florida",region_abbr => "FL",street_1 => "4900 South University Drive",street_2 => undef}
{city => "De Leon Springs",postal_code => 32130,region => "Florida",region_abbr => "FL",street_1 => "601 Ponce DeLeon Blvd.",street_2 => undef}
{city => "Deerfield Beach",postal_code => 33441,region => "Florida",region_abbr => "FL",street_1 => "196 N. Federal Highway",street_2 => undef}
{city => "Delray Beach",postal_code => 33483,region => "Florida",region_abbr => "FL",street_1 => "149 N.E.4th Ave.",street_2 => undef}
{city => "Delray Beach",postal_code => 33446,region => "Florida",region_abbr => "FL",street_1 => "16950 Jog Road",street_2 => "The Shoppes at Addison Plaza"}
{city => "Fort Lauderdale",postal_code => 33304,region => "Florida",region_abbr => "FL",street_1 => "1013 N. Federal Highway",street_2 => undef}
{city => "Fort Lauderdale",postal_code => 33301,region => "Florida",region_abbr => "FL",street_1 => "1523 E. Las Olas Blvd.",street_2 => undef}
{city => "Fort Lauderdale",postal_code => 33334,region => "Florida",region_abbr => "FL",street_1 => "830 E Oakland Park Blvd",street_2 => "#114"}
{city => "Fort Myers",postal_code => 33907,region => "Florida",region_abbr => "FL",street_1 => "1850 Boyscout Drive",street_2 => "#A106"}
{city => "Fort Myers",postal_code => 33907,region => "Florida",region_abbr => "FL",street_1 => "11605 Cleveland Avenue",street_2 => "#20"}
{city => "Fort Myers",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "12901 McGregor Blvd",street_2 => undef}
{city => "Fort Myers",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "16520 S Tamiami Trl",street_2 => "Suite #25"}
{city => "Fort Myers",postal_code => 33901,region => "Florida",region_abbr => "FL",street_1 => "2040 Collier Ave, Unit B",street_2 => undef}
{city => "Fort Walton Beach",postal_code => 32569,region => "Florida",region_abbr => "FL",street_1 => "2387 W. Highway 98",street_2 => "Suite E"}
{city => "Fort Walton Beach",postal_code => 32547,region => "Florida",region_abbr => "FL",street_1 => "99 Eglin Pkwy",street_2 => "Uptown Station Shopping Center"}
{city => "Fort Walton Beach",postal_code => 32547,region => "Florida",region_abbr => "FL",street_1 => "339 Racetrack Rd. NW",street_2 => undef}
{city => "Gainesville",postal_code => 32601,region => "Florida",region_abbr => "FL",street_1 => "619 W. University Avenue",street_2 => undef}
{city => "Gainesville",postal_code => 32601,region => "Florida",region_abbr => "FL",street_1 => "30 N. Main St.",street_2 => undef}
{city => "Gainesville",postal_code => 32601,region => "Florida",region_abbr => "FL",street_1 => "235 NW 8th Avenue",street_2 => undef}
{city => "Gainesville",postal_code => 32601,region => "Florida",region_abbr => "FL",street_1 => "1025 University Avenue",street_2 => undef}
{city => "Gainesville",postal_code => 32608,region => "Florida",region_abbr => "FL",street_1 => "7625 W. Newberry Road",street_2 => undef}
{city => "Gainesville",postal_code => 32601,region => "Florida",region_abbr => "FL",street_1 => "201 SE 2nd Ave",street_2 => undef}
{city => "Gainesville",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "401 NE 23rd Avenue",street_2 => undef}
{city => "Gainesville",postal_code => 32609,region => "Florida",region_abbr => "FL",street_1 => "25 NW 16th Ave",street_2 => undef}
{city => "Gainesville",postal_code => 32605,region => "Florida",region_abbr => "FL",street_1 => "4150 NW 16th Blvd.",street_2 => undef}
{city => "Hollywood",postal_code => 33020,region => "Florida",region_abbr => "FL",street_1 => "1955 Harrison St",street_2 => undef}
{city => "Islamorada",postal_code => 33036,region => "Florida",region_abbr => "FL",street_1 => "80499 Overseas Highway",street_2 => undef}
{city => "Jacksonville",postal_code => 32204,region => "Florida",region_abbr => "FL",street_1 => "2007 Park Street",street_2 => undef}
{city => "Jacksonville",postal_code => 32205,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Jacksonville Beach",postal_code => 32250,region => "Florida",region_abbr => "FL",street_1 => "798 3rd St.",street_2 => undef}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "521 Fleming Street",street_2 => undef}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "829 Fleming Street",street_2 => undef}
{city => "Key West",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1075 Duval Street",street_2 => "C-3"}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "1029 Southard Street",street_2 => undef}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "512 Duval St.",street_2 => undef}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "917 Simonton Street",street_2 => undef}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Hollywood Studios",street_2 => "Sunset Boulevard"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Main Street USA",street_2 => "Magic Kingdom"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Tomorrowland",street_2 => "Magic Kingdom"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Disney's Grand Floridian Resort & Spa",street_2 => undef}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "France in the World Showcase",street_2 => "Epcot"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Animal Kingdom Lodge",street_2 => undef}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Hollywood Studios",street_2 => "Walt Disney World"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Saratoga Springs Resort & Spa",street_2 => "Walt Disney World"}
{city => "Lake Buena Vista",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Saratoga Springs Resort & Spa",street_2 => "Walt Disney World"}
{city => "Lake Worth",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "609 Lake Avenue",street_2 => undef}
{city => "Lake Worth",postal_code => 33460,region => "Florida",region_abbr => "FL",street_1 => "332 North Dixie Highway",street_2 => undef}
{city => "Lauderhill",postal_code => 33351,region => "Florida",region_abbr => "FL",street_1 => "4816 N University Dr",street_2 => undef}
{city => "Lauderhill",postal_code => 33313,region => "Florida",region_abbr => "FL",street_1 => "2439 N. State Rd. 7",street_2 => undef}
{city => "Marco Island",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Park Ave. and Elkcam Cir.",street_2 => undef}
{city => "Melbourne",postal_code => 32935,region => "Florida",region_abbr => "FL",street_1 => "4100 N. Wickham Road",street_2 => "#106"}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "62 NE 14th Street",street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Miami",postal_code => 33133,region => "Florida",region_abbr => "FL",street_1 => "3399 Virginia Street",street_2 => "#620"}
{city => "Miami",postal_code => 33129,region => "Florida",region_abbr => "FL",street_1 => "379 SW 15th Road",street_2 => undef}
{city => "Miami",postal_code => 33143,region => "Florida",region_abbr => "FL",street_1 => "7209 SW 59th Avenue",street_2 => undef}
{city => "Miami",postal_code => 33150,region => "Florida",region_abbr => "FL",street_1 => "6345 NW 7th Ave",street_2 => undef}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "5205 NE 2nd Ct",street_2 => undef}
{city => "Miami",postal_code => 33180,region => "Florida",region_abbr => "FL",street_1 => "19501 Biscayne Blvd.",street_2 => "#3002"}
{city => "Miami",postal_code => 33138,region => "Florida",region_abbr => "FL",street_1 => "7030 Biscayne Blvd",street_2 => undef}
{city => "Miami",postal_code => 33186,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Miami",postal_code => 33127,region => "Florida",region_abbr => "FL",street_1 => "753 NW 28th Street",street_2 => undef}
{city => "Miami",postal_code => 33127,region => "Florida",region_abbr => "FL",street_1 => "138 NW 37 Street",street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "5140 Biscayne Blvd",street_2 => undef}
{city => "Miami",postal_code => 33127,region => "Florida",region_abbr => "FL",street_1 => "3404 N. Miami Avenue",street_2 => undef}
{city => "Miami",postal_code => 33150,region => "Florida",region_abbr => "FL",street_1 => "659 NW 62nd St",street_2 => undef}
{city => "Miami Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1239 Alton Road",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "40 Island Ave.",street_2 => "The Standard Hotel"}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1541 Washington Avenue, South Beach",street_2 => undef}
{city => "Miami Lakes",postal_code => 33014,region => "Florida",region_abbr => "FL",street_1 => "15509 Bull Run Rd",street_2 => undef}
{city => "Miami Lakes",postal_code => 33014,region => "Florida",region_abbr => "FL",street_1 => "16427 NW 67th Avenue",street_2 => undef}
{city => "Miramar Beach",postal_code => 32550,region => "Florida",region_abbr => "FL",street_1 => "525 Grand Boulevard, Suite P-101",street_2 => undef}
{city => "Naples",postal_code => 34102,region => "Florida",region_abbr => "FL",street_1 => "2132 Tamiami Trail N.",street_2 => undef}
{city => "Naples",postal_code => 34109,region => "Florida",region_abbr => "FL",street_1 => "2464 Vanderbilt Beach Rd.",street_2 => undef}
{city => "Naples",postal_code => 34109,region => "Florida",region_abbr => "FL",street_1 => "6424 Naples Blvd.",street_2 => undef}
{city => "Naples",postal_code => 34103,region => "Florida",region_abbr => "FL",street_1 => "850 Neapolitan Way",street_2 => undef}
{city => "Naples",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1201 Piper Blvd",street_2 => "#11"}
{city => "Naples",postal_code => 34102,region => "Florida",region_abbr => "FL",street_1 => "1900 Tamiami Trail North",street_2 => undef}
{city => "Naples",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "975 Pine Ridge Road",street_2 => undef}
{city => "North Miami",postal_code => 33181,region => "Florida",region_abbr => "FL",street_1 => "14871 Biscayne Blvd",street_2 => undef}
{city => "North Miami Beach",postal_code => 33162,region => "Florida",region_abbr => "FL",street_1 => "237 NE 167th St.",street_2 => undef}
{city => "North Miami Beach",postal_code => 33181,region => "Florida",region_abbr => "FL",street_1 => "14815 Biscayne Blvd",street_2 => undef}
{city => "North Miami Beach",postal_code => 33162,region => "Florida",region_abbr => "FL",street_1 => "73 NE 167th Street",street_2 => undef}
{city => "Oakland Park",postal_code => 33334,region => "Florida",region_abbr => "FL",street_1 => "4711 N. Dixie Highway",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Downtown Disney Marketplace",street_2 => undef}
{city => "Orlando",postal_code => 32819,region => "Florida",region_abbr => "FL",street_1 => "7563 West Sand Lake Road",street_2 => undef}
{city => "Orlando",postal_code => 32804,region => "Florida",region_abbr => "FL",street_1 => "1813 N. Orange Avenue",street_2 => undef}
{city => "Orlando",postal_code => 32804,region => "Florida",region_abbr => "FL",street_1 => "1235 N. Orange Avenue",street_2 => "Suite #101"}
{city => "Orlando",postal_code => 32809,region => "Florida",region_abbr => "FL",street_1 => "852 W. Lancaster Road",street_2 => undef}
{city => "Orlando",postal_code => 32803,region => "Florida",region_abbr => "FL",street_1 => "444 N. Bumby Avenue",street_2 => undef}
{city => "Orlando",postal_code => 32803,region => "Florida",region_abbr => "FL",street_1 => "710 North Mills Ave",street_2 => undef}
{city => "Orlando",postal_code => 32803,region => "Florida",region_abbr => "FL",street_1 => "2101 E Colonial Dr",street_2 => undef}
{city => "Orlando",postal_code => 32789,region => "Florida",region_abbr => "FL",street_1 => "325 S Orlando Avenue",street_2 => undef}
{city => "Orlando",postal_code => 32801,region => "Florida",region_abbr => "FL",street_1 => "101 E. Central Blvd.",street_2 => "Orlando (Main) Public Library"}
{city => "Orlando",postal_code => 32803,region => "Florida",region_abbr => "FL",street_1 => "618 North Thornton Ave",street_2 => undef}
{city => "Orlando",postal_code => 32817,region => "Florida",region_abbr => "FL",street_1 => "11565 University Blvd.",street_2 => "Suite 4"}
{city => "Orlando",postal_code => 32826,region => "Florida",region_abbr => "FL",street_1 => "1737 Alafaya Trail",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Palm Beach Gardens",postal_code => 33418,region => "Florida",region_abbr => "FL",street_1 => "4783 PGA Blvd",street_2 => undef}
{city => "Palm Beach Gardens",postal_code => 33418,region => "Florida",region_abbr => "FL",street_1 => "4783 PGA Blvd.",street_2 => undef}
{city => "Palm Harbor",postal_code => 34684,region => "Florida",region_abbr => "FL",street_1 => "3390 Tampa Road",street_2 => undef}
{city => "Palm Harbor",postal_code => 34684,region => "Florida",region_abbr => "FL",street_1 => "32522 US Hwy 19N",street_2 => undef}
{city => "Panama City",postal_code => 32413,region => "Florida",region_abbr => "FL",street_1 => "600 Pier Park Drive",street_2 => undef}
{city => "Panama City",postal_code => 32405,region => "Florida",region_abbr => "FL",street_1 => "728 W. 23rd Street",street_2 => undef}
{city => "Panama City",postal_code => 32404,region => "Florida",region_abbr => "FL",street_1 => "137 Tyndall Pkwy",street_2 => undef}
{city => "Pembroke Pines",postal_code => 33025,region => "Florida",region_abbr => "FL",street_1 => "14571 SW 5th Street",street_2 => undef}
{city => "Pensacola",postal_code => 32501,region => "Florida",region_abbr => "FL",street_1 => "610 East Wright Street",street_2 => undef}
{city => "Pensacola",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "101 S. Jefferson Street",street_2 => undef}
{city => "Pinecrest",postal_code => 33156,region => "Florida",region_abbr => "FL",street_1 => "9537 S. Dixie Highway",street_2 => undef}
{city => "Plant City",postal_code => 33563,region => "Florida",region_abbr => "FL",street_1 => "1302 W. Reynolds Street",street_2 => undef}
{city => "Plantation",postal_code => 33324,region => "Florida",region_abbr => "FL",street_1 => "522 N Pine Island Road",street_2 => "Veranda Shoppes"}
{city => "Plantation",postal_code => 33317,region => "Florida",region_abbr => "FL",street_1 => "5221A West Broward Blvd.",street_2 => undef}
{city => "Ponte Vedra",postal_code => 32082,region => "Florida",region_abbr => "FL",street_1 => "818 A1A N.",street_2 => undef}
{city => "Punta Gorda",postal_code => 33980,region => "Florida",region_abbr => "FL",street_1 => "321 Taylor Street",street_2 => undef}
{city => "Rockledge",postal_code => 32955,region => "Florida",region_abbr => "FL",street_1 => "1007 Pathfinder Way",street_2 => "Suite 110"}
{city => "Sarasota",postal_code => 34239,region => "Florida",region_abbr => "FL",street_1 => "1737 South Tamiami Trail",street_2 => undef}
{city => "Sarasota",postal_code => 34233,region => "Florida",region_abbr => "FL",street_1 => "4428 Bee Ridge Road",street_2 => undef}
{city => "Sarasota",postal_code => 34239,region => "Florida",region_abbr => "FL",street_1 => "1635 S. Tamiami Trail",street_2 => undef}
{city => "Sarasota",postal_code => 34232,region => "Florida",region_abbr => "FL",street_1 => "2164 Gulf Gate Drive",street_2 => undef}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "4791 Swift Rd",street_2 => undef}
{city => "Sarasota",postal_code => 34234,region => "Florida",region_abbr => "FL",street_1 => "5800 Bay Shore Road",street_2 => "New College of Florida"}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "2324 Gulf Gate Drive",street_2 => undef}
{city => "Sarasota",postal_code => 34239,region => "Florida",region_abbr => "FL",street_1 => "1944 Hillview Street",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "543 S Pineapple Ave",street_2 => undef}
{city => "Sarasota",postal_code => 34241,region => "Florida",region_abbr => "FL",street_1 => "2720 Stickney Point Rd",street_2 => undef}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "1930 Stickney Point Road",street_2 => undef}
{city => "Sarasota",postal_code => 34232,region => "Florida",region_abbr => "FL",street_1 => "1279 Beneva Road",street_2 => undef}
{city => "Sarasota",postal_code => 34233,region => "Florida",region_abbr => "FL",street_1 => "4005 Clark Road",street_2 => undef}
{city => "Sarasota",postal_code => 34239,region => "Florida",region_abbr => "FL",street_1 => "1895 Hillview Street",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "1330 Central Avenue",street_2 => undef}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "4141 South Tamiami Trail",street_2 => "Suite 9"}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "5900 Tamiami Trail",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "1535 Main Street",street_2 => undef}
{city => "Sarasota",postal_code => 34231,region => "Florida",region_abbr => "FL",street_1 => "2238 Gulf Gate Drive",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "1420 Main St",street_2 => undef}
{city => "St Petersburg",postal_code => 33715,region => "Florida",region_abbr => "FL",street_1 => "2451 Central Ave",street_2 => undef}
{city => "St. Augustine",postal_code => 32080,region => "Florida",region_abbr => "FL",street_1 => "110 Anastasia Blvd.",street_2 => undef}
{city => "St. Augustine",postal_code => 32086,region => "Florida",region_abbr => "FL",street_1 => "240 State Road 312",street_2 => "The Riverside Centre"}
{city => "St. Augustine",postal_code => 32084,region => "Florida",region_abbr => "FL",street_1 => "525 Charles Usinas Memorial Highway",street_2 => "Westgate Plaza"}
{city => "St. Augustine",postal_code => 32084,region => "Florida",region_abbr => "FL",street_1 => "62 Spanish St.",street_2 => "#B"}
{city => "St. Petersburg",postal_code => 33712,region => "Florida",region_abbr => "FL",street_1 => "2462 Central Avenue",street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "300 Beach Dr.",street_2 => "Ste. 120"}
{city => "St. Petersburg",postal_code => 33710,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "409 Central Ave.",street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "135 2nd Avenue N",street_2 => undef}
{city => "St. Petersburg Beach",postal_code => 33706,region => "Florida",region_abbr => "FL",street_1 => "595 Corey Avenue",street_2 => undef}
{city => "Stuart",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1411 SE Indian Street",street_2 => undef}
{city => "Sunny Isles Beach",postal_code => 33160,region => "Florida",region_abbr => "FL",street_1 => "18090 Collins Ave",street_2 => undef}
{city => "Sunrise",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Tallahassee",postal_code => 32312,region => "Florida",region_abbr => "FL",street_1 => "1415 Timberlane Rd",street_2 => "#410"}
{city => "Tallahassee",postal_code => 32304,region => "Florida",region_abbr => "FL",street_1 => "110 S. Woodward Ave.",street_2 => "Center for Global Engagement, 1st floor cafeteria"}
{city => "Tallahassee",postal_code => 32301,region => "Florida",region_abbr => "FL",street_1 => "1205 South Adams Street",street_2 => undef}
{city => "Tallahassee",postal_code => 32303,region => "Florida",region_abbr => "FL",street_1 => "1123 Thomasville Road",street_2 => undef}
{city => "Tallahassee",postal_code => 32310,region => "Florida",region_abbr => "FL",street_1 => "903 Railroad Avenue",street_2 => undef}
{city => "Tallahassee",postal_code => 32304,region => "Florida",region_abbr => "FL",street_1 => "666-5 W. Tennessee Street",street_2 => undef}
{city => "Tallahassee",postal_code => 32308,region => "Florida",region_abbr => "FL",street_1 => "1605 E. Plaza Drive",street_2 => undef}
{city => "Tampa",postal_code => 33609,region => "Florida",region_abbr => "FL",street_1 => "3701 N. Henderson Blvd.",street_2 => undef}
{city => "Tampa",postal_code => 33611,region => "Florida",region_abbr => "FL",street_1 => "3324 Gandy Blvd.",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Tampa",postal_code => 33611,region => "Florida",region_abbr => "FL",street_1 => "4334 S. Manhattan Ave.",street_2 => undef}
{city => "Tampa",postal_code => 33610,region => "Florida",region_abbr => "FL",street_1 => "2301 E. Hillsbrough Ave.",street_2 => undef}
{city => "Tampa",postal_code => 33617,region => "Florida",region_abbr => "FL",street_1 => "11009 N. 56th St,",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "2320 Fletcher Ave.",street_2 => undef}
{city => "Tampa",postal_code => 33604,region => "Florida",region_abbr => "FL",street_1 => "913 E. Hillsborough Avenue",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "1524 E Fowler Ave",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "2774 E. Fowler Avenue",street_2 => undef}
{city => "Tampa",postal_code => 33609,region => "Florida",region_abbr => "FL",street_1 => "157 Westshore Plaza",street_2 => undef}
{city => "Tampa",postal_code => 33603,region => "Florida",region_abbr => "FL",street_1 => "5119 N. Nebraska Avenue",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "2734 University Sq Dr.",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "1905 E Fletcher Ave,",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1540 N. Franklin St.",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "11955 Sheldon Rd",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "9556 West Linebaugh Ave.",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "777 North Ashley Drive",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "3636 Henderson Blvd",street_2 => undef}
{city => "Tampa",postal_code => 33609,region => "Florida",region_abbr => "FL",street_1 => "204 North Westshore Blvd",street_2 => undef}
{city => "Wellington",postal_code => 33414,region => "Florida",region_abbr => "FL",street_1 => "10160 Forest Hill Blvd",street_2 => "Unit G130"}
{city => "Wellington",postal_code => 33414,region => "Florida",region_abbr => "FL",street_1 => "10140 Forest Hill Blvd",street_2 => undef}
{city => "West Palm Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "300 Clematis Street",street_2 => "Suite 1"}
{city => "West Palm Beach",postal_code => 33405,region => "Florida",region_abbr => "FL",street_1 => "8020 S. Dixie Highway",street_2 => undef}
{city => "West Palm Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "West Palm Beach",postal_code => 33401,region => "Florida",region_abbr => "FL",street_1 => "460 South Rosemary Ave",street_2 => undef}
{city => "Weston",postal_code => 33326,region => "Florida",region_abbr => "FL",street_1 => "2378 Weston Rd.",street_2 => undef}
{city => "Winter Park",postal_code => 32789,region => "Florida",region_abbr => "FL",street_1 => "929 W. Fairbanks Avenue",street_2 => undef}
{city => "Winter Park",postal_code => 32789,region => "Florida",region_abbr => "FL",street_1 => "1842 E. Winter Park Road",street_2 => undef}
{city => "Atlantic Beach",postal_code => 32233,region => "Florida",region_abbr => "FL",street_1 => "51 Pine Street",street_2 => undef}
{city => "Atlantic Beach",postal_code => 32233,region => "Florida",region_abbr => "FL",street_1 => "363 Atlantic Blvd",street_2 => "Suite 7 & 8"}
{city => "Aventura",postal_code => 33180,region => "Florida",region_abbr => "FL",street_1 => "20335 Biscayne Blvd.",street_2 => undef}
{city => "Aventura",postal_code => 33180,region => "Florida",region_abbr => "FL",street_1 => "21105 Biscayne Blvd",street_2 => undef}
{city => "Boca Raton",postal_code => 33431,region => "Florida",region_abbr => "FL",street_1 => "1400 Glades Road",street_2 => "Ste 110"}
{city => "Boca Raton",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "20449 State Road 7",street_2 => undef}
{city => "Boca Raton",postal_code => 33431,region => "Florida",region_abbr => "FL",street_1 => "1668 N. Federal Highway",street_2 => undef}
{city => "Boca Raton",postal_code => 33433,region => "Florida",region_abbr => "FL",street_1 => "6853 SW 18th St.",street_2 => undef}
{city => "Clearwater",postal_code => 33755,region => "Florida",region_abbr => "FL",street_1 => "1225 Cleveland Street",street_2 => undef}
{city => "Coconut Grove",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "311 Commodore Plaza",street_2 => undef}
{city => "Coconut Grove",postal_code => 33133,region => "Florida",region_abbr => "FL",street_1 => "3220 Virginia Street",street_2 => undef}
{city => "Coral Gables",postal_code => 33134,region => "Florida",region_abbr => "FL",street_1 => "327 Alhambra Circle",street_2 => undef}
{city => "Coral Gables",postal_code => 33134,region => "Florida",region_abbr => "FL",street_1 => "265 Aragon Avenue",street_2 => undef}
{city => "Coral Springs",postal_code => 33071,region => "Florida",region_abbr => "FL",street_1 => "810 University Drive",street_2 => undef}
{city => "Dunedin",postal_code => 34698,region => "Florida",region_abbr => "FL",street_1 => "369 Main St.",street_2 => undef}
{city => "Fort Lauderdale",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Fort Lauderdale",postal_code => 33304,region => "Florida",region_abbr => "FL",street_1 => "644 North Federal Highway",street_2 => undef}
{city => "Fort Lauderdale",postal_code => 33304,region => "Florida",region_abbr => "FL",street_1 => "1431 North Federal Highway",street_2 => undef}
{city => "Ft. Lauderdale",postal_code => 33305,region => "Florida",region_abbr => "FL",street_1 => "2000 North Federal Highway",street_2 => undef}
{city => "Gainesville",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "505 NW 13th St.",street_2 => undef}
{city => "Gainesville",postal_code => 32608,region => "Florida",region_abbr => "FL",street_1 => "3550 SW 34th St.",street_2 => undef}
{city => "Gainesville",postal_code => 32608,region => "Florida",region_abbr => "FL",street_1 => "1902 SW 13th St.",street_2 => undef}
{city => "Gainesville",postal_code => 32608,region => "Florida",region_abbr => "FL",street_1 => "3500 SW 13th St.",street_2 => undef}
{city => "Gainesville",postal_code => 32606,region => "Florida",region_abbr => "FL",street_1 => "407 NW 13th St.",street_2 => undef}
{city => "Gainesville",postal_code => 32608,region => "Florida",region_abbr => "FL",street_1 => "3610 SW 13th St.",street_2 => undef}
{city => "Gainesville",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "Plaza of the Americas",street_2 => "University of Florida"}
{city => "Holiday",postal_code => 34691,region => "Florida",region_abbr => "FL",street_1 => "1922 US-19 North",street_2 => undef}
{city => "Hollywood",postal_code => 33021,region => "Florida",region_abbr => "FL",street_1 => "5809 Hollywood Blvd.",street_2 => undef}
{city => "Hollywood",postal_code => 33021,region => "Florida",region_abbr => "FL",street_1 => "3369 Sheridan Street",street_2 => undef}
{city => "Jacksonville",postal_code => 32257,region => "Florida",region_abbr => "FL",street_1 => "10000 San Jose Boulevard",street_2 => undef}
{city => "Jacksonville",postal_code => 32210,region => "Florida",region_abbr => "FL",street_1 => "4343 Colonial Ave",street_2 => undef}
{city => "Jacksonville",postal_code => 32256,region => "Florida",region_abbr => "FL",street_1 => "11030 Baymeadows Road",street_2 => undef}
{city => "Jacksonville",postal_code => 32246,region => "Florida",region_abbr => "FL",street_1 => "10281 Midtown Pkwy",street_2 => undef}
{city => "Jacksonville",postal_code => 32205,region => "Florida",region_abbr => "FL",street_1 => "2782 Park St.",street_2 => undef}
{city => "Jacksonville Beach",postal_code => 32250,region => "Florida",region_abbr => "FL",street_1 => "1409 South 3rd Street",street_2 => undef}
{city => "Kendall",postal_code => 33196,region => "Florida",region_abbr => "FL",street_1 => "16311 SW 88th Street",street_2 => undef}
{city => "Key West",postal_code => 33040,region => "Florida",region_abbr => "FL",street_1 => "509 Southard Street",street_2 => undef}
{city => "Keystone Heights",postal_code => 32656,region => "Florida",region_abbr => "FL",street_1 => "190 S. Lawrence Blvd.",street_2 => undef}
{city => "Lakeland",postal_code => 33813,region => "Florida",region_abbr => "FL",street_1 => "5329 S Florida Ave",street_2 => undef}
{city => "Lakeland",postal_code => 33803,region => "Florida",region_abbr => "FL",street_1 => "1212 S. Florida Avenue",street_2 => undef}
{city => "Lauderdale by the Sea",postal_code => 33308,region => "Florida",region_abbr => "FL",street_1 => "220 Commercial Blvd",street_2 => undef}
{city => "Longwood",postal_code => 32750,region => "Florida",region_abbr => "FL",street_1 => "1275 S. Highway 17/92",street_2 => undef}
{city => "Margate",postal_code => 33063,region => "Florida",region_abbr => "FL",street_1 => "6876 W Atlantic Blvd.",street_2 => undef}
{city => "Miami",postal_code => 33174,region => "Florida",region_abbr => "FL",street_1 => "113 Southwest 107",street_2 => undef}
{city => "Miami",postal_code => 33127,region => "Florida",region_abbr => "FL",street_1 => "4029 North Miami Avenue",street_2 => undef}
{city => "Miami",postal_code => 33131,region => "Florida",region_abbr => "FL",street_1 => "168 SE 1st Street",street_2 => undef}
{city => "Miami",postal_code => 33138,region => "Florida",region_abbr => "FL",street_1 => "7941 Biscayne Blvd.",street_2 => undef}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "5140 Biscayne Blvd",street_2 => undef}
{city => "Miami",postal_code => 33133,region => "Florida",region_abbr => "FL",street_1 => "3133 Grand Ave.  Coconut Grove",street_2 => undef}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "250 NE 25th Street",street_2 => undef}
{city => "Miami",postal_code => 33138,region => "Florida",region_abbr => "FL",street_1 => "7010 Biscayne Blvd.",street_2 => undef}
{city => "Miami",postal_code => 33145,region => "Florida",region_abbr => "FL",street_1 => "1248 SW 22 Street",street_2 => undef}
{city => "Miami",postal_code => 33155,region => "Florida",region_abbr => "FL",street_1 => "5710 Southwest 40th Street",street_2 => undef}
{city => "Miami",postal_code => 33130,region => "Florida",region_abbr => "FL",street_1 => "25 W Flagler St",street_2 => undef}
{city => "MIami",postal_code => 33176,region => "Florida",region_abbr => "FL",street_1 => "10832 SW 104 Street",street_2 => undef}
{city => "Miami",postal_code => 33143,region => "Florida",region_abbr => "FL",street_1 => "8211 S. Dixie Highway",street_2 => undef}
{city => "Miami",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1602 NE Miami Gardens Dr.",street_2 => undef}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "3801 N Miami Ave",street_2 => undef}
{city => "Miami",postal_code => 33138,region => "Florida",region_abbr => "FL",street_1 => "7244 Biscayne Boulevard",street_2 => undef}
{city => "Miami",postal_code => 33136,region => "Florida",region_abbr => "FL",street_1 => "7293 NW 36th St.",street_2 => undef}
{city => "Miami",postal_code => 33143,region => "Florida",region_abbr => "FL",street_1 => "6388 S Dixie Hwy",street_2 => undef}
{city => "Miami",postal_code => 33145,region => "Florida",region_abbr => "FL",street_1 => "2345 S Douglas Rd",street_2 => undef}
{city => "Miami",postal_code => 33145,region => "Florida",region_abbr => "FL",street_1 => "2437 Sw 17th Ave",street_2 => undef}
{city => "Miami",postal_code => 33161,region => "Florida",region_abbr => "FL",street_1 => "13695 W Dixie Hwy",street_2 => undef}
{city => "Miami",postal_code => 33155,region => "Florida",region_abbr => "FL",street_1 => "7188 SW 47th St, at Olympia Hights",street_2 => undef}
{city => "Miami",postal_code => 33122,region => "Florida",region_abbr => "FL",street_1 => "2721 NW 79th Ave",street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "229 SW 8th St",street_2 => "Suite 111"}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "5138 Biscayne Boulevard",street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "17455 Biscayne Blvd",street_2 => undef}
{city => "Miami",postal_code => 33161,region => "Florida",region_abbr => "FL",street_1 => "15044 NE 6th Ave",street_2 => undef}
{city => "Miami",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1214 Washington Avenue",street_2 => undef}
{city => "Miami",postal_code => 33141,region => "Florida",region_abbr => "FL",street_1 => "6976 Collins Avenue",street_2 => undef}
{city => "Miami",postal_code => 33133,region => "Florida",region_abbr => "FL",street_1 => "3415 Main hwy , Coconut Grove",street_2 => undef}
{city => "Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "210 NE 18th St",street_2 => undef}
{city => "Miami",postal_code => 33137,region => "Florida",region_abbr => "FL",street_1 => "5505 NE 2nd Avenue",street_2 => undef}
{city => "Miami",postal_code => 33174,region => "Florida",region_abbr => "FL",street_1 => "115 SW 107th Avenue",street_2 => "Holiday Plaza"}
{city => "miami",postal_code => undef,region => "florida",region_abbr => "FL",street_1 => "3015 Grand Avenue , Cocowalk,",street_2 => undef}
{city => "Miami",postal_code => 33150,region => "Florida",region_abbr => "FL",street_1 => "136 NW 62nd St",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1535 Washington Avenue",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "235 14th Street",street_2 => undef}
{city => "Miami Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1346 Washington Avenue",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "232 12th St",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "926 Alton Rd",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "235 14th St",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1525 Alton Rd",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "229 14th St",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1501 Ocean Dr",street_2 => "Suite 104"}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1427 Alton Rd",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "863 Washington Ave",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1311 Washington Avenue",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "933 Lincoln Road",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "700 Lincoln Road",street_2 => undef}
{city => "Miami Beach",postal_code => 33139,region => "Florida",region_abbr => "FL",street_1 => "1020 Alton Rd",street_2 => undef}
{city => "Miami Lakes",postal_code => 33014,region => "Florida",region_abbr => "FL",street_1 => "15519 NW 67th Avenue",street_2 => undef}
{city => "Miramar",postal_code => 33023,region => "Florida",region_abbr => "FL",street_1 => "6060 Miramar Parkway",street_2 => undef}
{city => "North Miami",postal_code => 33161,region => "Florida",region_abbr => "FL",street_1 => "775 NE 125th St",street_2 => undef}
{city => "North Miami",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "2188 NE 123rd St",street_2 => undef}
{city => "North Miami",postal_code => 33181,region => "Florida",region_abbr => "FL",street_1 => "927 NE 125th Street",street_2 => undef}
{city => "North Miami",postal_code => 33181,region => "Florida",region_abbr => "FL",street_1 => "2214 NE 123rd St",street_2 => undef}
{city => "North Miami",postal_code => 33161,region => "Florida",region_abbr => "FL",street_1 => "12327 NE 6th Avenue",street_2 => undef}
{city => "North Miami",postal_code => 33161,region => "Florida",region_abbr => "FL",street_1 => "12327 NE 6th Avenue",street_2 => undef}
{city => "North Miami Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "16210 Collins Ave",street_2 => undef}
{city => "North Miami Beach",postal_code => 33160,region => "Florida",region_abbr => "FL",street_1 => "3055 NE 163rd St",street_2 => undef}
{city => "Ona",postal_code => 33865,region => "Florida",region_abbr => "FL",street_1 => "4224 Solomon Road",street_2 => undef}
{city => "Orlando",postal_code => 32817,region => "Florida",region_abbr => "FL",street_1 => "12239 University Blvd",street_2 => undef}
{city => "Orlando",postal_code => 32826,region => "Florida",region_abbr => "FL",street_1 => "4066 N Alafaya Trl",street_2 => undef}
{city => "Orlando",postal_code => 32817,region => "Florida",region_abbr => "FL",street_1 => "12273 University Blvd",street_2 => undef}
{city => "Orlando",postal_code => 32803,region => "Florida",region_abbr => "FL",street_1 => "618 north thornton avenue",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "9801 International Drive",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "810 West Colonial Drive",street_2 => undef}
{city => "Orlando",postal_code => 32830,region => "Florida",region_abbr => "FL",street_1 => "2901 Osceola Parkway",street_2 => undef}
{city => "Orlando",postal_code => 32830,region => "Florida",region_abbr => "FL",street_1 => "1001 West Buena Vista Drive",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "6040 S Orange Blossom Trail",street_2 => undef}
{city => "Orlando",postal_code => 32811,region => "Florida",region_abbr => "FL",street_1 => "4759 Raleigh Street",street_2 => undef}
{city => "Orlando",postal_code => 32804,region => "Florida",region_abbr => "FL",street_1 => "1600 Edgewater Drive",street_2 => undef}
{city => "Orlando",postal_code => 32804,region => "Florida",region_abbr => "FL",street_1 => "625 E. Central Blvd.",street_2 => "Inside Urban Think! Bookstore"}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "North Orange Avenue",street_2 => undef}
{city => "Orlando",postal_code => 32802,region => "Florida",region_abbr => "FL",street_1 => "2021 E. Colonial Drive",street_2 => undef}
{city => "Orlando",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Palm Harbor",postal_code => 34684,region => "Florida",region_abbr => "FL",street_1 => "30555 US-19 N",street_2 => undef}
{city => "Parkland",postal_code => 33076,region => "Florida",region_abbr => "FL",street_1 => "10599 Trails End",street_2 => undef}
{city => "Pembroke Pines",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "11049 Pines Blvd. Suite 424",street_2 => undef}
{city => "Pinecrest",postal_code => 33156,region => "Florida",region_abbr => "FL",street_1 => "11701 S Dixie Hwy",street_2 => undef}
{city => "Plantation",postal_code => 33324,region => "Florida",region_abbr => "FL",street_1 => "7720 Peters Road",street_2 => undef}
{city => "Plantation",postal_code => 33322,region => "Florida",region_abbr => "FL",street_1 => "1816 N University Dr",street_2 => undef}
{city => "Pompano Beach",postal_code => 33069,region => "Florida",region_abbr => "FL",street_1 => "1434 South Powerline Road",street_2 => undef}
{city => "Ponte Vedra Beach",postal_code => 32082,region => "Florida",region_abbr => "FL",street_1 => "PO BOX 133",street_2 => undef}
{city => "Roswell",postal_code => 30076,region => "Florida",region_abbr => "FL",street_1 => "1180 Upper Hembree Rd.",street_2 => undef}
{city => "Sanford",postal_code => 32771,region => "Florida",region_abbr => "FL",street_1 => "112 East 1st Street",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "1121 S Tamiami Trail",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "1451 1st Street",street_2 => undef}
{city => "Sarasota",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "1990 Main Street",street_2 => undef}
{city => "Sarasota",postal_code => 34236,region => "Florida",region_abbr => "FL",street_1 => "811 S. Palm Avenue",street_2 => "Marie Selby Botanical Gardens"}
{city => "Siesta Key",postal_code => 34242,region => "Florida",region_abbr => "FL",street_1 => "5138 Ocean Blvd",street_2 => undef}
{city => "South Miami",postal_code => 33155,region => "Florida",region_abbr => "FL",street_1 => "5750 S.W. 40th St.",street_2 => "(Bird Road)"}
{city => "St Augustine",postal_code => 32084,region => "Florida",region_abbr => "FL",street_1 => "6 Cordova St",street_2 => undef}
{city => "St Augustine",postal_code => 32080,region => "Florida",region_abbr => "FL",street_1 => "501 A1A Beach Blvd",street_2 => undef}
{city => "St. Augustine",postal_code => 32084,region => "Florida",region_abbr => "FL",street_1 => "224 West King Street",street_2 => undef}
{city => "St. Pete Beach",postal_code => 33706,region => "Florida",region_abbr => "FL",street_1 => "120 8th Avenue",street_2 => undef}
{city => "St. Petersburg",postal_code => 33704,region => "Florida",region_abbr => "FL",street_1 => "2842 9th St N",street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "243 Central Avenue",street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "532 1st Avenue North",street_2 => undef}
{city => "St. Petersburg",postal_code => 33704,region => "Florida",region_abbr => "FL",street_1 => "2631 4th Street North",street_2 => undef}
{city => "St. Petersburg",postal_code => 33705,region => "Florida",region_abbr => "FL",street_1 => "1431 Central Avenue",street_2 => undef}
{city => "St. Petersburg",postal_code => 33701,region => "Florida",region_abbr => "FL",street_1 => "330 1st Avenue South",street_2 => undef}
{city => "Sunrise",postal_code => 33351,region => "Florida",region_abbr => "FL",street_1 => "9120 West Commercial Blvd",street_2 => undef}
{city => "Sunrise",postal_code => 33322,region => "Florida",region_abbr => "FL",street_1 => "2100 N. University Dr",street_2 => undef}
{city => "Tallahassee",postal_code => 32301,region => "Florida",region_abbr => "FL",street_1 => "411 St. Francis St",street_2 => undef}
{city => "Tallahassee",postal_code => 32301,region => "Florida",region_abbr => "FL",street_1 => "Park St",street_2 => undef}
{city => "Tallahassee",postal_code => 32301,region => "Florida",region_abbr => "FL",street_1 => "2529 Apalachee Parkway",street_2 => undef}
{city => "Tallahassee",postal_code => 32301,region => "Florida",region_abbr => "FL",street_1 => "1235 Apalachee Parkway",street_2 => undef}
{city => "Tallahassee",postal_code => 32303,region => "Florida",region_abbr => "FL",street_1 => "1660 N. Monroe Street",street_2 => undef}
{city => "Tampa",postal_code => 33618,region => "Florida",region_abbr => "FL",street_1 => "14422 North Dale Mabry Hwy.",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "1441 E. Fletcher Ave. #133",street_2 => undef}
{city => "Tampa",postal_code => 33617,region => "Florida",region_abbr => "FL",street_1 => "4819 E. Busch Blvd.",street_2 => undef}
{city => "Tampa",postal_code => 33602,region => "Florida",region_abbr => "FL",street_1 => "2702 N. Florida Ave",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "609 S. Howard Ave.",street_2 => undef}
{city => "Tampa",postal_code => 33607,region => "Florida",region_abbr => "FL",street_1 => "1021 North MacDill Ave.",street_2 => undef}
{city => "Tampa",postal_code => 33618,region => "Florida",region_abbr => "FL",street_1 => "14374 N Dale Mabry Hwy",street_2 => undef}
{city => "Tampa",postal_code => 33604,region => "Florida",region_abbr => "FL",street_1 => "6204 N Armenia Avenue",street_2 => undef}
{city => "Tampa",postal_code => 33618,region => "Florida",region_abbr => "FL",street_1 => "14847 N. Dale Mabry Highway",street_2 => undef}
{city => "Tampa",postal_code => 33634,region => "Florida",region_abbr => "FL",street_1 => "5522 Hanley Rd",street_2 => "Suite 105"}
{city => "Tampa",postal_code => 33609,region => "Florida",region_abbr => "FL",street_1 => "610 S Armenia Avenue",street_2 => undef}
{city => "Tampa",postal_code => 33617,region => "Florida",region_abbr => "FL",street_1 => "5105 E Fowler Ave",street_2 => undef}
{city => "Tampa",postal_code => 33629,region => "Florida",region_abbr => "FL",street_1 => "3333 S West Shore Blvd",street_2 => undef}
{city => "Tampa",postal_code => 33612,region => "Florida",region_abbr => "FL",street_1 => "2311 E Fowler Avenue",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "3218 W Kennedy Blvd",street_2 => undef}
{city => "Tampa",postal_code => 33606,region => "Florida",region_abbr => "FL",street_1 => "1622 W Snow Ave",street_2 => undef}
{city => "Tampa",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => undef,street_2 => undef}
{city => "Tampa",postal_code => 33647,region => "Florida",region_abbr => "FL",street_1 => "16023 Tampa Palms Blvd",street_2 => undef}
{city => "Tampa",postal_code => 33604,region => "Florida",region_abbr => "FL",street_1 => "6605 N Florida Ave.",street_2 => "#D"}
{city => "Tampa",postal_code => 33614,region => "Florida",region_abbr => "FL",street_1 => "4023 W Waters Ave # 15",street_2 => undef}
{city => "Tampa",postal_code => 33607,region => "Florida",region_abbr => "FL",street_1 => "1548 North Dale Mabry",street_2 => "Walters Crossing Shopping Center"}
{city => "Tarpon Springs",postal_code => 34689,region => "Florida",region_abbr => "FL",street_1 => "501 N. Pinellas Avenue",street_2 => undef}
{city => "Temple Terrace",postal_code => 33617,region => "Florida",region_abbr => "FL",street_1 => "11301 N 56TH St",street_2 => undef}
{city => "West Melbourne",postal_code => 32904,region => "Florida",region_abbr => "FL",street_1 => "1135 W New Haven Ave",street_2 => undef}
{city => "West Palm Beach",postal_code => 33401,region => "Florida",region_abbr => "FL",street_1 => "509 Clematis St",street_2 => undef}
{city => "West Palm Beach",postal_code => undef,region => "Florida",region_abbr => "FL",street_1 => "2nd St",street_2 => undef}
{city => "West Palm Beach",postal_code => 33411,region => "Florida",region_abbr => "FL",street_1 => "1443 Palmdale Court",street_2 => undef}
{city => "Weston",postal_code => 33327,region => "Florida",region_abbr => "FL",street_1 => "20201 Saddle Club Road",street_2 => undef}
{city => "Winter Park",postal_code => 32792,region => "Florida",region_abbr => "FL",street_1 => "1989 Aloma Avenue",street_2 => undef}
{city => "Winter Park",postal_code => 32792,region => "Florida",region_abbr => "FL",street_1 => "2015 Aloma Ave",street_2 => undef}
{city => "Winter Park",postal_code => 32789,region => "Florida",region_abbr => "FL",street_1 => "153 E. Morse Blvd.",street_2 => undef}
{city => "Alpharetta",postal_code => 30022,region => "Georgia",region_abbr => "GA",street_1 => "11105 StateBridge Road",street_2 => "Suite 200"}
{city => "athens",postal_code => 30608,region => "Georgia",region_abbr => "GA",street_1 => "po box 82284",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "675 Pulaski Street",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1591 S. Lumpkin Street",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "350 East Broad",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "196 Alps Rd",street_2 => undef}
{city => "Atlanta",postal_code => 30306,region => "Georgia",region_abbr => "GA",street_1 => "550 Amsterdam Avenue NE",street_2 => undef}
{city => "Atlanta",postal_code => 30308,region => "Georgia",region_abbr => "GA",street_1 => "931 Monroe Drive NE",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => undef,street_2 => undef}
{city => "Atlanta",postal_code => 30318,region => "Georgia",region_abbr => "GA",street_1 => "1168 Howell Mill Road",street_2 => undef}
{city => "Atlanta",postal_code => 30303,region => "Georgia",region_abbr => "GA",street_1 => "225 Spring Street",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "427 Edgewood Ave.",street_2 => undef}
{city => "Atlanta",postal_code => 30303,region => "Georgia",region_abbr => "GA",street_1 => "100 Techwood Drive",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "1645 McLendon Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30309,region => "Georgia",region_abbr => "GA",street_1 => "2233 Peachtree Road",street_2 => "Suite M"}
{city => "Atlanta",postal_code => 30310,region => "Georgia",region_abbr => "GA",street_1 => "875 York Avenue",street_2 => undef}
{city => "Atlanta",postal_code => 30306,region => "Georgia",region_abbr => "GA",street_1 => "2157 Briarcliff Road",street_2 => undef}
{city => "Atlanta",postal_code => 30310,region => "Georgia",region_abbr => "GA",street_1 => "878 Ralph David Abernathy Blvd",street_2 => undef}
{city => "Atlanta",postal_code => 30317,region => "Georgia",region_abbr => "GA",street_1 => undef,street_2 => undef}
{city => "Atlanta",postal_code => 30308,region => "Georgia",region_abbr => "GA",street_1 => "855 Peachtree Street",street_2 => undef}
{city => "Atlanta",postal_code => 30342,region => "Georgia",region_abbr => "GA",street_1 => "5590 Roswell Road",street_2 => undef}
{city => "Atlanta",postal_code => 30316,region => "Georgia",region_abbr => "GA",street_1 => "1271 Glenwood Ave.",street_2 => undef}
{city => "Atlanta",postal_code => 30303,region => "Georgia",region_abbr => "GA",street_1 => "233 Mitchell Street SW",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "584 Woodward Avenue",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "1660 McLendon Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "1091 Euclid Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "1530 DeKalb Avenue",street_2 => undef}
{city => "Atlanta",postal_code => 30316,region => "Georgia",region_abbr => "GA",street_1 => "727 Wylie Street SE",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "421 Memorial Dr SE",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "186 Carroll St SE",street_2 => undef}
{city => "Atlanta",postal_code => 30305,region => "Georgia",region_abbr => "GA",street_1 => "3280 Peachtree Rd. NE",street_2 => undef}
{city => "Atlanta",postal_code => 30328,region => "Georgia",region_abbr => "GA",street_1 => "5975 Roswell Rd.",street_2 => "Suite G-25"}
{city => "Atlanta",postal_code => 30327,region => "Georgia",region_abbr => "GA",street_1 => "3515 Northside Pkwy NW",street_2 => undef}
{city => "Atlanta",postal_code => 30318,region => "Georgia",region_abbr => "GA",street_1 => "1082 Huff Rd",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1156 Euclid Ave",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "466 Edgewood Ave.",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "North Avenue & North Highland Avenue",street_2 => undef}
{city => "Brunswick",postal_code => 31525,region => "Georgia",region_abbr => "GA",street_1 => "718 Mall Blvd",street_2 => undef}
{city => "Carrollton",postal_code => "30117-3262",region => "Georgia",region_abbr => "GA",street_1 => "304 Adamson Square",street_2 => undef}
{city => "Carrollton",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "805 Maple Street",street_2 => undef}
{city => "Carrollton",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "206 Rome Street",street_2 => undef}
{city => "Columbus",postal_code => 31906,region => "Georgia",region_abbr => "GA",street_1 => "1217 Eberhart Avenue",street_2 => undef}
{city => "Dillard",postal_code => 30537,region => "Georgia",region_abbr => "GA",street_1 => "6818 Hwy 441N",street_2 => undef}
{city => "Duluth",postal_code => 30096,region => "Georgia",region_abbr => "GA",street_1 => "3300 Peachtree Industrial Blvd",street_2 => undef}
{city => "Hiawassee",postal_code => 30546,region => "Georgia",region_abbr => "GA",street_1 => "1000 Highway 180",street_2 => undef}
{city => "Kennesaw",postal_code => 30144,region => "Georgia",region_abbr => "GA",street_1 => "2700 Town Center Drive",street_2 => "Suite 136"}
{city => "Kennesaw",postal_code => 30144,region => "Georgia",region_abbr => "GA",street_1 => "777 Town Park Lane",street_2 => undef}
{city => "Macon",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "442 Cherry Street",street_2 => undef}
{city => "Macon",postal_code => 31205,region => "Georgia",region_abbr => "GA",street_1 => "5201 Houston Rd.",street_2 => undef}
{city => "Macon",postal_code => 31201,region => "Georgia",region_abbr => "GA",street_1 => "617 Poplar St",street_2 => undef}
{city => "Marietta",postal_code => 30060,region => "Georgia",region_abbr => "GA",street_1 => "105 N Park Square",street_2 => undef}
{city => "Marietta",postal_code => 30068,region => "Georgia",region_abbr => "GA",street_1 => "1084 E. Johnson Ferry Rd.",street_2 => undef}
{city => "Norcross",postal_code => 30092,region => "Georgia",region_abbr => "GA",street_1 => "5270 Peachtree Parkway",street_2 => "Suite 120"}
{city => "Roswell",postal_code => 30076,region => "Georgia",region_abbr => "GA",street_1 => "850 Mansell Road",street_2 => undef}
{city => "Sandy Springs",postal_code => 30328,region => "Georgia",region_abbr => "GA",street_1 => "220 Hammond Drive",street_2 => "Suite 302"}
{city => "Sandy Springs",postal_code => 30350,region => "Georgia",region_abbr => "GA",street_1 => "8540 Roswell Road",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "13 East Broughton St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "11108 Abercorn St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "12 W. 41st Street",street_2 => undef}
{city => "Savannah",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1 E. broughton St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "11 West Liberty St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "21 W. Bay St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "52 Barnard St.",street_2 => undef}
{city => "Savannah",postal_code => 31405,region => "Georgia",region_abbr => "GA",street_1 => "531 Stephenson Ave.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "108 E. York St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "17 W Broughton St",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "416 W. Liberty St.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "12 West Liberty Street",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "402 Martin Luther King Jr. Blvd.",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "4 W Broughton St",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "13 E. Park Avenue",street_2 => undef}
{city => "Smyrna",postal_code => 30080,region => "Georgia",region_abbr => "GA",street_1 => "2772 Cumberland Blvd",street_2 => undef}
{city => "Smyrna",postal_code => 30080,region => "Georgia",region_abbr => "GA",street_1 => "4500 West Village Place",street_2 => undef}
{city => "Summerville",postal_code => 30747,region => "Georgia",region_abbr => "GA",street_1 => "154 Union Street",street_2 => undef}
{city => "Alpharetta",postal_code => 30005,region => "Georgia",region_abbr => "GA",street_1 => "5204 Wellsley Bend",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "199 Prince Ave.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "259 East Clayton Street",street_2 => undef}
{city => "Athens",postal_code => 30605,region => "Georgia",region_abbr => "GA",street_1 => "1860 Barnett Shoals Road",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1739 S. Lumpkin Street",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "320 E. Clayton St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "145 E. Clayton St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "581 S. Harris St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1985 Barnett Shoals Rd.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "3190 Atlanta Hwy",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "323 E. Broad St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "211 Tallassee Rd.",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "123 North Jackson Street",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "171 College Ave.",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "269 N. Hull St.",street_2 => undef}
{city => "Athens",postal_code => 30602,region => "Georgia",region_abbr => "GA",street_1 => undef,street_2 => undef}
{city => "Athens",postal_code => 30606,region => "Georgia",region_abbr => "GA",street_1 => "1550 Oglethorpe Avenue",street_2 => undef}
{city => "Athens",postal_code => 30606,region => "Georgia",region_abbr => "GA",street_1 => "2033 W. Broad St.",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => " 131 East Broad Street",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "237 Prince Avenue",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "367 Prince Ave",street_2 => undef}
{city => "Athens",postal_code => 30606,region => "Georgia",region_abbr => "GA",street_1 => "197 Holly Hills Court",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "493 E. Clayton St.,",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "217 Hiwaassee Ave",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "255 W. Washington St.",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "151 E Broad St",street_2 => undef}
{city => "Athens",postal_code => 30601,region => "Georgia",region_abbr => "GA",street_1 => "199 North Lumpkin Street",street_2 => undef}
{city => "Atlanta",postal_code => 30316,region => "Georgia",region_abbr => "GA",street_1 => "142 Flat Shoals Ave SE",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "590 Auburn Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30305,region => "Georgia",region_abbr => "GA",street_1 => "77 West Paces Ferry Rd NW",street_2 => undef}
{city => "Atlanta",postal_code => 30341,region => "Georgia",region_abbr => "GA",street_1 => "4897 Buford Hwy NE",street_2 => "#109"}
{city => "Atlanta",postal_code => 30318,region => "Georgia",region_abbr => "GA",street_1 => "100 10th St. NW",street_2 => undef}
{city => "Atlanta",postal_code => 30324,region => "Georgia",region_abbr => "GA",street_1 => "2335 Cheshire Bridge Road",street_2 => undef}
{city => "Atlanta",postal_code => 30309,region => "Georgia",region_abbr => "GA",street_1 => "1812 Peachtree Road NW",street_2 => undef}
{city => "Atlanta",postal_code => 30310,region => "Georgia",region_abbr => "GA",street_1 => "1405 Ralph David Abernathy Blvd SW",street_2 => undef}
{city => "Atlanta",postal_code => 30329,region => "Georgia",region_abbr => "GA",street_1 => "2111 Briarcliff Road",street_2 => undef}
{city => "Atlanta",postal_code => "30308-1833",region => "Georgia",region_abbr => "GA",street_1 => "650 Ponce de Leon Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "4377 Roswell Road",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "2280 Peachtree Road NW",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1071 Piedmont Avenue",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "1228 West Paces Ferry Road NW",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "1655 Mclendon Ave.",street_2 => undef}
{city => "Atlanta",postal_code => 30309,region => "Georgia",region_abbr => "GA",street_1 => "1001 Piedmont Ave.",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "211 Pharr Road NE",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "652 N Highland Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30316,region => "Georgia",region_abbr => "GA",street_1 => "517 Flat Shoals Ave",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "600 Ponce De Leon Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => 30310,region => "Georgia",region_abbr => "GA",street_1 => "879 Ralph David Abernathy Blvd SW",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "467 Moreland Avenue NE",street_2 => undef}
{city => "Atlanta",postal_code => 30312,region => "Georgia",region_abbr => "GA",street_1 => "464 Edgewood Avenue",street_2 => undef}
{city => "Atlanta",postal_code => 30309,region => "Georgia",region_abbr => "GA",street_1 => "2140 Peachtree Road NW",street_2 => undef}
{city => "Atlanta",postal_code => 30328,region => "Georgia",region_abbr => "GA",street_1 => "5975 Roswell Road NE",street_2 => undef}
{city => "Atlanta",postal_code => 30324,region => "Georgia",region_abbr => "GA",street_1 => " 1529 Piedmont Avenue, Suite D",street_2 => undef}
{city => "Atlanta",postal_code => "30308-1755",region => "Georgia",region_abbr => "GA",street_1 => "985 Monroe Dr NE",street_2 => undef}
{city => "Atlanta",postal_code => "30307-1925",region => "Georgia",region_abbr => "GA",street_1 => "1117 Euclid Ave NE",street_2 => undef}
{city => "Atlanta",postal_code => "30342-4414",region => "Georgia",region_abbr => "GA",street_1 => "3757 Roswell Rd NE",street_2 => undef}
{city => "Atlanta",postal_code => 30305,region => "Georgia",region_abbr => "GA",street_1 => "2337 Peachtree Rd NE",street_2 => undef}
{city => "Atlanta",postal_code => 30307,region => "Georgia",region_abbr => "GA",street_1 => "913 Bernina Ave.",street_2 => undef}
{city => "Atlanta",postal_code => undef,region => "Georgia",region_abbr => "GA",street_1 => "660 Irwin Street",street_2 => undef}
{city => "Atlanta",postal_code => 30316,region => "Georgia",region_abbr => "GA",street_1 => "1263 Glenwood Ave SE",street_2 => undef}
{city => "Augusta",postal_code => 30901,region => "Georgia",region_abbr => "GA",street_1 => "211 10th Street",street_2 => undef}
{city => "Augusta",postal_code => 30907,region => "Georgia",region_abbr => "GA",street_1 => "3112 Washington Rd",street_2 => undef}
{city => "Dahlonega",postal_code => 30533,region => "Georgia",region_abbr => "GA",street_1 => "6463 Highway 19 North",street_2 => undef}
{city => "Decatur",postal_code => 30033,region => "Georgia",region_abbr => "GA",street_1 => "2179 Lawrenceville Highway",street_2 => undef}
{city => "Decatur",postal_code => 30030,region => "Georgia",region_abbr => "GA",street_1 => "141 Sycamore Street",street_2 => undef}
{city => "Decatur",postal_code => 30033,region => "Georgia",region_abbr => "GA",street_1 => "2118 North Decatur Road",street_2 => undef}
{city => "Decatur",postal_code => 30033,region => "Georgia",region_abbr => "GA",street_1 => "2074 North Decatur Road",street_2 => undef}
{city => "Decatur",postal_code => 30033,region => "Georgia",region_abbr => "GA",street_1 => "1707 Church Street",street_2 => undef}
{city => "Decatur",postal_code => 30035,region => "Georgia",region_abbr => "GA",street_1 => "6125 Covington Highway",street_2 => "Suite 5"}
{city => "Duluth",postal_code => 30096,region => "Georgia",region_abbr => "GA",street_1 => "3300 Peachtree Industrial Blvd",street_2 => "Suite J"}
{city => "Duluth",postal_code => 30097,region => "Georgia",region_abbr => "GA",street_1 => "5945 State Bridge Road",street_2 => undef}
{city => "East Point",postal_code => 30344,region => "Georgia",region_abbr => "GA",street_1 => "2796 East Point St.",street_2 => undef}
{city => "East Point",postal_code => "30344-4802",region => "Georgia",region_abbr => "GA",street_1 => "3113 Main St",street_2 => undef}
{city => "Evans",postal_code => 30809,region => "Georgia",region_abbr => "GA",street_1 => "4237 Washington Rd",street_2 => undef}
{city => "Marietta",postal_code => 30062,region => "Georgia",region_abbr => "GA",street_1 => "1453 Roswell Road",street_2 => undef}
{city => "Marietta",postal_code => 30062,region => "Georgia",region_abbr => "GA",street_1 => "4250 Roswell Road",street_2 => undef}
{city => "Marietta",postal_code => 30067,region => "Georgia",region_abbr => "GA",street_1 => "1475 Terrell Mill Road SE",street_2 => "Suite 105"}
{city => "Marietta",postal_code => 30067,region => "Georgia",region_abbr => "GA",street_1 => "70 Powers Ferry Rd SE",street_2 => undef}
{city => "Marietta",postal_code => 30062,region => "Georgia",region_abbr => "GA",street_1 => "1453 Roswell Rd",street_2 => undef}
{city => "Marietta",postal_code => 30068,region => "Georgia",region_abbr => "GA",street_1 => "4719 Lower Roswell Road",street_2 => undef}
{city => "Marietta",postal_code => 30062,region => "Georgia",region_abbr => "GA",street_1 => "200 North Cobb Parkway",street_2 => "Bldg 100 Ste 126"}
{city => "Marietta",postal_code => "30067-7507",region => "Georgia",region_abbr => "GA",street_1 => "70 Powers Ferry Rd SE",street_2 => undef}
{city => "Norcross",postal_code => 30092,region => "Georgia",region_abbr => "GA",street_1 => "5185 Peachtree Parkway",street_2 => "Bldg 1200"}
{city => "Norcross",postal_code => 30092,region => "Georgia",region_abbr => "GA",street_1 => "6385 Spalding Drive",street_2 => "Suite E"}
{city => "Roswell",postal_code => 30075,region => "Georgia",region_abbr => "GA",street_1 => "635 W. Crossville Road",street_2 => undef}
{city => "Roswell",postal_code => 30075,region => "Georgia",region_abbr => "GA",street_1 => "920 Woodstock Rd., Suite 200",street_2 => undef}
{city => "Sandy Springs",postal_code => 30328,region => "Georgia",region_abbr => "GA",street_1 => "6277 Roswell Road NE",street_2 => undef}
{city => "Sandy Springs",postal_code => 30328,region => "Georgia",region_abbr => "GA",street_1 => "5930 Roswell Road NE",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "1102 Bull Street",street_2 => undef}
{city => "Savannah",postal_code => 31401,region => "Georgia",region_abbr => "GA",street_1 => "321 Habersham St.",street_2 => undef}
{city => "Tucker",postal_code => 30084,region => "Georgia",region_abbr => "GA",street_1 => "4880 Lawrenceville Highway",street_2 => undef}
{city => undef,postal_code => "WI",region => "Green Bay",region_abbr => undef,street_1 => "112 S. Broadway Street",street_2 => undef}
{city => "Aiea",postal_code => 96701,region => "Hawaii",region_abbr => "HI",street_1 => "98-199 Kamehameha Hwy",street_2 => "Suite C-2"}
{city => "Aiea",postal_code => 96701,region => "Hawaii",region_abbr => "HI",street_1 => "98-131 Kaonohi St.",street_2 => undef}
{city => "Haiku",postal_code => 96708,region => "Hawaii",region_abbr => "HI",street_1 => "810 Kokomo Road",street_2 => undef}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-443 Kamehameha Hwy",street_2 => undef}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-443 Kamehameha Hwy",street_2 => undef}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-165 #5 Kamehameha Highway",street_2 => "Haleiwa Town Center"}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-250 Kamehameha Hwy",street_2 => undef}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-079 Kamehameha Hwy",street_2 => undef}
{city => "Hilo",postal_code => 96720,region => "Hawaii",region_abbr => "HI",street_1 => "70 Mamo St",street_2 => undef}
{city => "Hilo",postal_code => 96720,region => "Hawaii",region_abbr => "HI",street_1 => "292 Kamehameha Avenue",street_2 => undef}
{city => "Hilo",postal_code => 96720,region => "Hawaii",region_abbr => "HI",street_1 => "315 Maka'ala Street",street_2 => undef}
{city => "Honolulu",postal_code => 96822,region => "Hawaii",region_abbr => "HI",street_1 => "2500 Campus Road",street_2 => undef}
{city => "Honolulu",postal_code => 96822,region => "Hawaii",region_abbr => "HI",street_1 => "2500 Campus Road",street_2 => undef}
{city => "Honolulu",postal_code => 96826,region => "Hawaii",region_abbr => "HI",street_1 => "2525 S King Street",street_2 => undef}
{city => "Honolulu",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "100 N Beretania Street",street_2 => "Suite 109"}
{city => "Honolulu",postal_code => 96823,region => "Hawaii",region_abbr => "HI",street_1 => "P.O. Box 23208",street_2 => undef}
{city => "Honolulu",postal_code => 96826,region => "Hawaii",region_abbr => "HI",street_1 => "2570 South Beretania Street",street_2 => "#204"}
{city => "Honolulu",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "1810 University Ave",street_2 => undef}
{city => "Honolulu",postal_code => 96816,region => "Hawaii",region_abbr => "HI",street_1 => "2452 Waialae Avenue",street_2 => undef}
{city => "Kahului",postal_code => 96732,region => "Hawaii",region_abbr => "HI",street_1 => "305 Dairy Rd",street_2 => undef}
{city => "Kailua",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "33 Aulike St.",street_2 => undef}
{city => "Kailua",postal_code => 96734,region => "Hawaii",region_abbr => "HI",street_1 => "201 Hamakua Drive",street_2 => undef}
{city => "Kailua",postal_code => 96734,region => "Hawaii",region_abbr => "HI",street_1 => "640 Ulukahiki",street_2 => undef}
{city => "Kailua",postal_code => 96734,region => "Hawaii",region_abbr => "HI",street_1 => "35 Kainehe St.",street_2 => undef}
{city => "Kailua",postal_code => 96734,region => "Hawaii",region_abbr => "HI",street_1 => "572 Kailua Rd.",street_2 => undef}
{city => "Kapaa",postal_code => 96746,region => "Hawaii",region_abbr => "HI",street_1 => "4504 Kukui Street",street_2 => undef}
{city => "Kapaau",postal_code => 96755,region => "Hawaii",region_abbr => "HI",street_1 => "PO Box 238",street_2 => undef}
{city => "Kealakekua",postal_code => 96750,region => "Hawaii",region_abbr => "HI",street_1 => "79-7460 Mamalahoa Highway",street_2 => undef}
{city => "Lahaina",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "3636 Lower Honoapiilani Rd",street_2 => undef}
{city => "Makawao",postal_code => 96768,region => "Hawaii",region_abbr => "HI",street_1 => "1169 Makawao Avenue",street_2 => undef}
{city => "Paia",postal_code => 96779,region => "Hawaii",region_abbr => "HI",street_1 => "115 Baldwin Avenue",street_2 => undef}
{city => "Paia",postal_code => 96779,region => "Hawaii",region_abbr => "HI",street_1 => "89 Hana Highway",street_2 => undef}
{city => "Haleiwa",postal_code => 96712,region => "Hawaii",region_abbr => "HI",street_1 => "66-246 Kamehameha Hwy",street_2 => undef}
{city => "Hawi",postal_code => 96719,region => "Hawaii",region_abbr => "HI",street_1 => "55-3412 Akoni Pule Hwy",street_2 => undef}
{city => "Hilo",postal_code => 96720,region => "Hawaii",region_abbr => "HI",street_1 => "303 Makaaka Street",street_2 => undef}
{city => "Hilo",postal_code => 96720,region => "Hawaii",region_abbr => "HI",street_1 => "1221 Kilauea Ave.",street_2 => undef}
{city => "Honolulu",postal_code => 96826,region => "Hawaii",region_abbr => "HI",street_1 => "2239 S. King Street",street_2 => undef}
{city => "Honolulu",postal_code => 96814,region => "Hawaii",region_abbr => "HI",street_1 => "1450 Ala Moana Blvd",street_2 => "Ala Moana Center"}
{city => "Honolulu",postal_code => 96814,region => "Hawaii",region_abbr => "HI",street_1 => "1726 S. King Street",street_2 => undef}
{city => "Honolulu",postal_code => 96814,region => "Hawaii",region_abbr => "HI",street_1 => "1102 Pensacola Street",street_2 => undef}
{city => "Honolulu",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => undef,street_2 => undef}
{city => "Honolulu",postal_code => 96814,region => "Hawaii",region_abbr => "HI",street_1 => "1145 S. King Street",street_2 => undef}
{city => "Honolulu",postal_code => 96813,region => "Hawaii",region_abbr => "HI",street_1 => "831 Queen Street",street_2 => undef}
{city => "Honolulu",postal_code => 96816,region => "Hawaii",region_abbr => "HI",street_1 => "1018 Kapahulu Ave.",street_2 => undef}
{city => "Honolulu",postal_code => 96817,region => "Hawaii",region_abbr => "HI",street_1 => "650 Iwilei Road",street_2 => "Suite 170, The Shops at Dole Cannery"}
{city => "Honolulu",postal_code => 96826,region => "Hawaii",region_abbr => "HI",street_1 => "1614 South King Street",street_2 => undef}
{city => "Honolulu",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "1427 Makaloa St.",street_2 => undef}
{city => "Honolulu",postal_code => 96816,region => "Hawaii",region_abbr => "HI",street_1 => "4211 Waialae Avenue",street_2 => undef}
{city => "Honolulu",postal_code => 96822,region => "Hawaii",region_abbr => "HI",street_1 => "2904 E. Manoa Rd",street_2 => undef}
{city => "Honolulu",postal_code => 96817,region => "Hawaii",region_abbr => "HI",street_1 => "555 N. King St",street_2 => "Suite 108"}
{city => "Honolulu",postal_code => 96813,region => "Hawaii",region_abbr => "HI",street_1 => "1118 Fort St Mall",street_2 => undef}
{city => "Honolulu",postal_code => 96817,region => "Hawaii",region_abbr => "HI",street_1 => "51 Coelho Way",street_2 => undef}
{city => "Honolulu",postal_code => 96825,region => "Hawaii",region_abbr => "HI",street_1 => "377 Keahole Street, #A-1",street_2 => "Hawaii Kai Shopping Center"}
{city => "Kahului",postal_code => 96732,region => "Hawaii",region_abbr => "HI",street_1 => "340 Hana Highway",street_2 => undef}
{city => "Kahului",postal_code => 96732,region => "Hawaii",region_abbr => "HI",street_1 => "333 Dairy Road",street_2 => "Kiosk 101"}
{city => "Kailua Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "75-5831 Kahakai St",street_2 => undef}
{city => "Kailua Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "74-5555 Kaiwi St.",street_2 => undef}
{city => "Kailua Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "75-1027 Henry Street",street_2 => undef}
{city => "Kailua-Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "75-5831 Kahakai Road",street_2 => undef}
{city => "Kailua-Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "75-1027 Henry St.",street_2 => undef}
{city => "Kailua-Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "73-5617 Maiau St.",street_2 => undef}
{city => "Kailua-Kona",postal_code => 96740,region => "Hawaii",region_abbr => "HI",street_1 => "74-5487 Kaiwi St.",street_2 => undef}
{city => "Kainaliu",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "79-7460 Mamalahoa Hwy",street_2 => "Mango Court"}
{city => "Kamuela",postal_code => 96743,region => "Hawaii",region_abbr => "HI",street_1 => "61-3616 Kawaihae Road",street_2 => undef}
{city => "Kapa'a",postal_code => 96746,region => "Hawaii",region_abbr => "HI",street_1 => "4-1384 Kuhio Hwy, #105",street_2 => undef}
{city => "Kapa'a",postal_code => 96746,region => "Hawaii",region_abbr => "HI",street_1 => "4-1421 Kuhio Hwy",street_2 => undef}
{city => "Kapaa",postal_code => "96746-1660",region => "Hawaii",region_abbr => "HI",street_1 => "4-1354 Kuhio Hwy",street_2 => undef}
{city => "Kohala Coast",postal_code => 96743,region => "Hawaii",region_abbr => "HI",street_1 => "68-1400 Mauna Lani Drive",street_2 => "Mauna Lani Bay Hotel & Bungalows"}
{city => "Maui",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "1913 S. Kihei Rd.",street_2 => undef}
{city => "Maui",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => undef,street_2 => undef}
{city => "Pahoa",postal_code => undef,region => "Hawaii",region_abbr => "HI",street_1 => "15-1870 Akeakamai Loop",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "2712 Lincoln Way",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "413 Douglas Ave",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "402 Main St.",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "2504 Lincoln Way",street_2 => undef}
{city => "Ames",postal_code => undef,region => "Iowa",region_abbr => "IA",street_1 => "207 Welch Ave.",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "3417 Lincoln Way",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "120 Hayward Ave.",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "114 Welch Ave. Unit B",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "1620 S. Kellogg Avenue",street_2 => undef}
{city => "Ankeny",postal_code => 50021,region => "Iowa",region_abbr => "IA",street_1 => "1701 SE Delaware Ave # 300",street_2 => undef}
{city => "Ankeny",postal_code => 50021,region => "Iowa",region_abbr => "IA",street_1 => "2310 SE Delaware Ave",street_2 => undef}
{city => "Cedar Falls",postal_code => 50613,region => "Iowa",region_abbr => "IA",street_1 => "2021 Main St",street_2 => undef}
{city => "Cedar Falls",postal_code => 50613,region => "Iowa",region_abbr => "IA",street_1 => "310 Main St",street_2 => undef}
{city => "Cedar Falls",postal_code => 50613,region => "Iowa",region_abbr => "IA",street_1 => "1710 West 1st St. Suite C",street_2 => undef}
{city => "Cedar Falls",postal_code => 50613,region => "Iowa",region_abbr => "IA",street_1 => "Cedar Square Mall",street_2 => "6301 University Ave."}
{city => "Cedar Rapids",postal_code => 52405,region => "Iowa",region_abbr => "IA",street_1 => "3300 Johnson Ave NW",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52401,region => "Iowa",region_abbr => "IA",street_1 => "221 2nd Ave SE",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52404,region => "Iowa",region_abbr => "IA",street_1 => "2725 Edgewood Pkwy SW",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52402,region => "Iowa",region_abbr => "IA",street_1 => "Lindale Mall",street_2 => "4444 1st Ave., NE"}
{city => "Cedar Rapids Ia, 52404",postal_code => 52404,region => "Iowa",region_abbr => "IA",street_1 => "201 2nd Street S.E.",street_2 => undef}
{city => "Clive",postal_code => 50325,region => "Iowa",region_abbr => "IA",street_1 => "7500 University Ave",street_2 => "#A"}
{city => "Clive",postal_code => 50325,region => "Iowa",region_abbr => "IA",street_1 => "8801 University Avenue",street_2 => undef}
{city => "Corallville",postal_code => 52317,region => "Iowa",region_abbr => "IA",street_1 => "906 2nd St",street_2 => undef}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "517 2nd Street",street_2 => "Suite 1"}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "917 25th Ave.",street_2 => undef}
{city => "Council Bluffs",postal_code => 51501,region => "Iowa",region_abbr => "IA",street_1 => "3120 Manawa Centre Dr.",street_2 => "Suite 100"}
{city => "Davenport",postal_code => 52807,region => "Iowa",region_abbr => "IA",street_1 => "2303 E. 53rd St.",street_2 => undef}
{city => "Davenport",postal_code => 52801,region => "Iowa",region_abbr => "IA",street_1 => "116 W 3rd St.",street_2 => undef}
{city => "Decorah",postal_code => 52101,region => "Iowa",region_abbr => "IA",street_1 => "802 Commerce D",street_2 => undef}
{city => "Decorah",postal_code => 52101,region => "Iowa",region_abbr => "IA",street_1 => "421 W Water St",street_2 => undef}
{city => "Decorah",postal_code => 52101,region => "Iowa",region_abbr => "IA",street_1 => "118 Winnebago St",street_2 => undef}
{city => "Decorah",postal_code => 52101,region => "Iowa",region_abbr => "IA",street_1 => "312 W. Water St.",street_2 => undef}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "313 E. Locust St.",street_2 => undef}
{city => "Des Moines",postal_code => 50311,region => "Iowa",region_abbr => "IA",street_1 => "4040 University Ave.",street_2 => undef}
{city => "Des Moines",postal_code => 50322,region => "Iowa",region_abbr => "IA",street_1 => "2749 100th Street",street_2 => undef}
{city => "Des Moines",postal_code => 50266,region => "Iowa",region_abbr => "IA",street_1 => "5465 Mills Civic Parkway",street_2 => undef}
{city => "Des Moines",postal_code => 50316,region => "Iowa",region_abbr => "IA",street_1 => "1254 E. 14th Street",street_2 => undef}
{city => "Des Moines",postal_code => 50312,region => "Iowa",region_abbr => "IA",street_1 => "2002 Woodland Avenue",street_2 => undef}
{city => "Des Moines",postal_code => 50266,region => "Iowa",region_abbr => "IA",street_1 => "520 Market Street",street_2 => undef}
{city => "Des Moines",postal_code => 50311,region => "Iowa",region_abbr => "IA",street_1 => "4721 University Avenue",street_2 => undef}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "214 4th St",street_2 => undef}
{city => "Des Moines",postal_code => 50317,region => "Iowa",region_abbr => "IA",street_1 => "2824 Easton Blvd",street_2 => undef}
{city => "Des Moines",postal_code => 50266,region => "Iowa",region_abbr => "IA",street_1 => "1721 25th St",street_2 => undef}
{city => "Des Moines",postal_code => 50325,region => "Iowa",region_abbr => "IA",street_1 => "12655 University Ave # 120",street_2 => undef}
{city => "Des Moines",postal_code => 50310,region => "Iowa",region_abbr => "IA",street_1 => "5514 Douglas Ave.",street_2 => undef}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "223 4th Street",street_2 => undef}
{city => "Des Moines",postal_code => 50316,region => "Iowa",region_abbr => "IA",street_1 => "1534 E Grand Ave # E",street_2 => undef}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "400 Walnut St",street_2 => undef}
{city => "Dubuque",postal_code => 52002,region => "Iowa",region_abbr => "IA",street_1 => "555 J.F. Kennedy Rd.",street_2 => "Kennedy Mall # 685"}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "501 N. 2nd St.",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "51 S Court St.",street_2 => undef}
{city => "Fairfield",postal_code => 52257,region => "Iowa",region_abbr => "IA",street_1 => "1200 N 4th",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "203 W. Broadway",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "108 N. Main St.",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "101 W Broadway Avenue",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "112 N. Main Street",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "1734 Jasmine Avenue",street_2 => undef}
{city => "Fairfield",postal_code => 52556,region => "Iowa",region_abbr => "IA",street_1 => "101 North Main Street",street_2 => undef}
{city => "Iowa City",postal_code => 52242,region => "Iowa",region_abbr => "IA",street_1 => "206 N Linn St.",street_2 => undef}
{city => "Iowa City",postal_code => 52242,region => "Iowa",region_abbr => "IA",street_1 => "19 S Dubuque St",street_2 => undef}
{city => "Iowa City",postal_code => 52240,region => "Iowa",region_abbr => "IA",street_1 => "113 Iowa Ave.",street_2 => undef}
{city => "Iowa City",postal_code => 52240,region => "Iowa",region_abbr => "IA",street_1 => "100 South Linn Street",street_2 => undef}
{city => "Iowa City/Coralville",postal_code => undef,region => "Iowa",region_abbr => "IA",street_1 => "89 2nd St, Unit #2",street_2 => undef}
{city => "Johnston",postal_code => 50131,region => "Iowa",region_abbr => "IA",street_1 => "5340 Merle Hay Road",street_2 => undef}
{city => "Kalona",postal_code => 52247,region => "Iowa",region_abbr => "IA",street_1 => "203 5th St.",street_2 => undef}
{city => "Le Mars",postal_code => 51031,region => "Iowa",region_abbr => "IA",street_1 => "13 Central Ave NW",street_2 => undef}
{city => "LeClaire",postal_code => 52753,region => "Iowa",region_abbr => "IA",street_1 => "127 2nd Street South",street_2 => undef}
{city => "Mason City",postal_code => 50401,region => "Iowa",region_abbr => "IA",street_1 => "616 S. Monroe",street_2 => undef}
{city => "Muscatine",postal_code => 52761,region => "Iowa",region_abbr => "IA",street_1 => "101 West Mississippi Ave.",street_2 => undef}
{city => "Sioux City",postal_code => 51106,region => "Iowa",region_abbr => "IA",street_1 => "3322 Singing Hills Boulevard",street_2 => undef}
{city => "Sioux City",postal_code => 51106,region => "Iowa",region_abbr => "IA",street_1 => "4229 South Lakeport",street_2 => undef}
{city => "Spirit Lake",postal_code => 51360,region => "Iowa",region_abbr => "IA",street_1 => "1610 Hill Ave.",street_2 => undef}
{city => "Urbandale",postal_code => 50322,region => "Iowa",region_abbr => "IA",street_1 => "3729 N.W. 86th Street",street_2 => undef}
{city => "Washington",postal_code => 52353,region => "Iowa",region_abbr => "IA",street_1 => "122 S Iowa Ave.",street_2 => undef}
{city => "Waterloo",postal_code => 50702,region => "Iowa",region_abbr => "IA",street_1 => "1503 Flammang Drive",street_2 => undef}
{city => "Waterloo",postal_code => 50701,region => "Iowa",region_abbr => "IA",street_1 => "2401 Falls Ave",street_2 => undef}
{city => "West Des Moines",postal_code => 50266,region => "Iowa",region_abbr => "IA",street_1 => "110 S. Jordan Creek Parkway",street_2 => undef}
{city => "West Des Moines",postal_code => 50265,region => "Iowa",region_abbr => "IA",street_1 => "4100 University Ave",street_2 => undef}
{city => "West Des Moines",postal_code => 50265,region => "Iowa",region_abbr => "IA",street_1 => "1221 8th St",street_2 => undef}
{city => "Ammon",postal_code => 83406,region => "Idaho",region_abbr => "ID",street_1 => "2035 S. 25th E.",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "111 Broadway Avenue",street_2 => undef}
{city => "Boise",postal_code => 93702,region => "Idaho",region_abbr => "ID",street_1 => "150 N. 8th St.",street_2 => "Suite 222"}
{city => "Boise",postal_code => 83705,region => "Idaho",region_abbr => "ID",street_1 => "1800 W. Overland Road",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "205 N. 10th Street",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "746 W. Main St",street_2 => undef}
{city => "Boise",postal_code => 83706,region => "Idaho",region_abbr => "ID",street_1 => "1007 Broadway Avenue",street_2 => undef}
{city => "Couer d'Alene",postal_code => 83814,region => "Idaho",region_abbr => "ID",street_1 => "320 Sherman Ave.",street_2 => undef}
{city => "Hayden",postal_code => 83835,region => "Idaho",region_abbr => "ID",street_1 => "271 W. Prairie Shopping Center",street_2 => undef}
{city => "Ketchum",postal_code => undef,region => "Idaho",region_abbr => "ID",street_1 => "460 N Washington Avenue",street_2 => undef}
{city => "Ketchum",postal_code => 83340,region => "Idaho",region_abbr => "ID",street_1 => "160 N Main St",street_2 => "in the Chapter One bookstore"}
{city => "Ketchum",postal_code => 83340,region => "Idaho",region_abbr => "ID",street_1 => "380 Washington Avenue",street_2 => "Suite 105"}
{city => "Lava Hot Springs",postal_code => 83246,region => "Idaho",region_abbr => "ID",street_1 => "695 E. Main Street",street_2 => undef}
{city => "Lewiston",postal_code => 83501,region => "Idaho",region_abbr => "ID",street_1 => "908 16th Avenue",street_2 => undef}
{city => "Meridian",postal_code => 83642,region => "Idaho",region_abbr => "ID",street_1 => "3030 E Overland Rd.",street_2 => "Unit 103"}
{city => "Moscow",postal_code => 83843,region => "Idaho",region_abbr => "ID",street_1 => "317 W. 6th Street",street_2 => undef}
{city => "Nampa",postal_code => 83651,region => "Idaho",region_abbr => "ID",street_1 => "1215 1st Street S.",street_2 => "2nd Floor"}
{city => "Pocatello",postal_code => 83201,region => "Idaho",region_abbr => "ID",street_1 => "1000 Pocatello Creek Rd # W2",street_2 => undef}
{city => "Pocatello",postal_code => 83201,region => "Idaho",region_abbr => "ID",street_1 => "815 S. 1st Ave.",street_2 => undef}
{city => "Pocatello",postal_code => 83201,region => "Idaho",region_abbr => "ID",street_1 => "1799 Hurley Drive",street_2 => undef}
{city => "Post Falls",postal_code => 83854,region => "Idaho",region_abbr => "ID",street_1 => "900 North Hwy 41",street_2 => undef}
{city => "Rexburg",postal_code => 83440,region => "Idaho",region_abbr => "ID",street_1 => "56 College Avenue",street_2 => undef}
{city => "Twin Falls",postal_code => 83301,region => "Idaho",region_abbr => "ID",street_1 => "659 Blue Lakes Blvd. North",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "750 W Idaho Street",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "110 N 11th St",street_2 => undef}
{city => "Boise",postal_code => 83702,region => "Idaho",region_abbr => "ID",street_1 => "888 West Fort St",street_2 => undef}
{city => "Moscow",postal_code => 83843,region => "Idaho",region_abbr => "ID",street_1 => "121 East Fifth Street",street_2 => undef}
{city => "Twin Falls",postal_code => undef,region => "Idaho",region_abbr => "ID",street_1 => "837 Poleline Road",street_2 => undef}
{city => "Aurora",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1552 N. Aurora Rd",street_2 => undef}
{city => "Aurora",postal_code => 60504,region => "Illinois",region_abbr => "IL",street_1 => "4442 E. New York Street",street_2 => undef}
{city => "Aurora",postal_code => 60504,region => "Illinois",region_abbr => "IL",street_1 => "1649 Montegomery Rd",street_2 => "Suite #6"}
{city => "Aurora",postal_code => 60506,region => "Illinois",region_abbr => "IL",street_1 => "1330 N. Orchard Road",street_2 => undef}
{city => "Aurora",postal_code => 60504,region => "Illinois",region_abbr => "IL",street_1 => "986 North Route 59",street_2 => undef}
{city => "Batavia",postal_code => 60510,region => "Illinois",region_abbr => "IL",street_1 => "1942 W. Fabyan Pkwy",street_2 => undef}
{city => "Berwyn",postal_code => 60402,region => "Illinois",region_abbr => "IL",street_1 => "6211 W. Roosevelt Road",street_2 => undef}
{city => "Bloomingdale",postal_code => 60108,region => "Illinois",region_abbr => "IL",street_1 => "398 W. Army Trail Road",street_2 => undef}
{city => "Bloomington",postal_code => 61704,region => "Illinois",region_abbr => "IL",street_1 => "1704 Eastland Drive",street_2 => "Suite 10"}
{city => "Carol Stream",postal_code => 60188,region => "Illinois",region_abbr => "IL",street_1 => "600 E. North Avenue",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "6 E. Columbia",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "6263 N. McCormick Blvd",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "1220 W. Webster Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60625,region => "Illinois",region_abbr => "IL",street_1 => "2612 W Lawrence Ave",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "1408 W. Diversey Pkwy",street_2 => undef}
{city => "Chicago",postal_code => 60653,region => "Illinois",region_abbr => "IL",street_1 => "1126 E. 47th St.",street_2 => undef}
{city => "Chicago",postal_code => 60604,region => "Illinois",region_abbr => "IL",street_1 => "228 S. Wabash Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60642,region => "Illinois",region_abbr => "IL",street_1 => "1103 W. Grand Ave",street_2 => undef}
{city => "Chicago",postal_code => 60625,region => "Illinois",region_abbr => "IL",street_1 => "4749 N. Albany St.",street_2 => undef}
{city => "Chicago",postal_code => 60649,region => "Illinois",region_abbr => "IL",street_1 => "2347 E. 75th Street",street_2 => undef}
{city => "Chicago",postal_code => 60613,region => "Illinois",region_abbr => "IL",street_1 => "1432 W. Irving Park Rd",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1312 E 53rd St",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "130 S. Green St.",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "355 E. Grand Avenue",street_2 => "Holmes Place Fitness Center, 2nd Floor"}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "235 S. Franklin Street",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2333 W. North Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "5806 N. Western Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2323 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "2439 West Devon Ave",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "331 S. Franklin Street",street_2 => undef}
{city => "Chicago",postal_code => 60643,region => "Illinois",region_abbr => "IL",street_1 => "2239 W. 95th Street",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "1160 N State Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3463 N. Clark Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "2830 North Milwaukee Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "1218 West Morse",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "118 N. Canal Street",street_2 => "Ogilvie Transportation Center"}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "6981 N. Sheridan Rd.",street_2 => undef}
{city => "Chicago",postal_code => 60613,region => "Illinois",region_abbr => "IL",street_1 => "1467 W. Irving Park Road",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1123 N. California Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "1013 W. Webster Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "2929 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5351 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60608,region => "Illinois",region_abbr => "IL",street_1 => "1700 W 19th St",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1402 W Grand Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "2521 N. Clark St",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1537 N. Milwaukee Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60608,region => "Illinois",region_abbr => "IL",street_1 => "960 W. 18th St.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "738 N. Wells St",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "5812 N. Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "4801 N. Broadway Street",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "4656 N. Clark Street",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "2536 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "310 S. Canal St.",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => "1912 N. Western Ave."}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "804 W. Washington Blvd",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "5701 N Clark Street",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "935 N. Damen Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "705 W. Belden Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "7537 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "1039 W. Granville Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1943 W. North Ave",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2910 W. Armitage Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1009 W. Madison",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5020 N. Sheridan Road",street_2 => undef}
{city => "Chicago",postal_code => 60605,region => "Illinois",region_abbr => "IL",street_1 => "638 S Michigan Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1357 W. Chicago Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "2018 W. Chicago Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "1912 N. Western Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "331 S. Franklin",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2210 N. California Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "1319 W. Wilson Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1635 E. 55th Street",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2211 W. North Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1001 E. 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1307 S. Wabash",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "6300 N Ridge",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1043 N California Ave",street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "3188 N Elston Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60605,region => "Illinois",region_abbr => "IL",street_1 => "733 S Dearborn",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1824 West Division Street",street_2 => undef}
{city => "Chicago",postal_code => 60630,region => "Illinois",region_abbr => "IL",street_1 => "4205 W. Lawrence Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60605,region => "Illinois",region_abbr => "IL",street_1 => "511 S. State St.",street_2 => undef}
{city => "Darien",postal_code => 60561,region => "Illinois",region_abbr => "IL",street_1 => "2813 83rd Street",street_2 => undef}
{city => "DeKalb",postal_code => 60115,region => "Illinois",region_abbr => "IL",street_1 => "122 West Lincoln Highway",street_2 => undef}
{city => "Des Plaines",postal_code => 60016,region => "Illinois",region_abbr => "IL",street_1 => "8971 Potter Rd.",street_2 => undef}
{city => "East Peoria",postal_code => 61611,region => "Illinois",region_abbr => "IL",street_1 => "1040 W Camp St",street_2 => undef}
{city => "Elmhurst",postal_code => 60126,region => "Illinois",region_abbr => "IL",street_1 => "110 W. Park Ave.",street_2 => undef}
{city => "Elmhurst",postal_code => 60126,region => "Illinois",region_abbr => "IL",street_1 => "162 N. York St.",street_2 => undef}
{city => "Frankfort",postal_code => 60423,region => "Illinois",region_abbr => "IL",street_1 => "19810 South Harlem Ave",street_2 => undef}
{city => "Galena",postal_code => 61036,region => "Illinois",region_abbr => "IL",street_1 => "300 N Main Street",street_2 => undef}
{city => "Galena",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "204 Perry Street",street_2 => undef}
{city => "Galesburg",postal_code => 61401,region => "Illinois",region_abbr => "IL",street_1 => "89 S. Seminary Street",street_2 => undef}
{city => "Geneva",postal_code => 60134,region => "Illinois",region_abbr => "IL",street_1 => "119 W. State St.",street_2 => undef}
{city => "Glen Ellyn",postal_code => 60137,region => "Illinois",region_abbr => "IL",street_1 => "425 Fawell Blvd",street_2 => undef}
{city => "Glendale Heights",postal_code => 60139,region => "Illinois",region_abbr => "IL",street_1 => "185 E. Army Trail Road",street_2 => undef}
{city => "Hazel Crest",postal_code => 60429,region => "Illinois",region_abbr => "IL",street_1 => "2011 W. 170th Street",street_2 => undef}
{city => "Hoffman Estates",postal_code => 60194,region => "Illinois",region_abbr => "IL",street_1 => "1004 West Golf Road",street_2 => undef}
{city => "Hoffman Estates",postal_code => 60169,region => "Illinois",region_abbr => "IL",street_1 => "1065 W Golf Rd",street_2 => undef}
{city => "Hoffman Estates",postal_code => 60192,region => "Illinois",region_abbr => "IL",street_1 => "4589 West Higgins Road",street_2 => undef}
{city => "Justice",postal_code => 60458,region => "Illinois",region_abbr => "IL",street_1 => "8400 S Roberts Rd",street_2 => undef}
{city => "La Grange",postal_code => 60525,region => "Illinois",region_abbr => "IL",street_1 => "50 S. La Grange Rd",street_2 => undef}
{city => "La Grange",postal_code => 60525,region => "Illinois",region_abbr => "IL",street_1 => "93 S. La Grange Avenue",street_2 => undef}
{city => "Lake Zurich",postal_code => 60047,region => "Illinois",region_abbr => "IL",street_1 => "1241 S. Rand Road",street_2 => undef}
{city => "Lockport",postal_code => 60441,region => "Illinois",region_abbr => "IL",street_1 => "928 State Street",street_2 => undef}
{city => "Lombard",postal_code => 60148,region => "Illinois",region_abbr => "IL",street_1 => "837 E. Roosevelt Road",street_2 => undef}
{city => "Loves Park",postal_code => 61111,region => "Illinois",region_abbr => "IL",street_1 => "6430 E. Riverside Blvd.",street_2 => undef}
{city => "Midlothian",postal_code => 60445,region => "Illinois",region_abbr => "IL",street_1 => "3824 W. 147th St.",street_2 => undef}
{city => "Moline",postal_code => 61265,region => "Illinois",region_abbr => "IL",street_1 => "4400 23rd Avenue",street_2 => undef}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1120 E. Diehl Rd",street_2 => undef}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1603 North Aurora Rd.",street_2 => "#113"}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1739 Freedom Drive",street_2 => undef}
{city => "Naperville",postal_code => 60540,region => "Illinois",region_abbr => "IL",street_1 => "2555 W. 75th St.",street_2 => "Suite 125"}
{city => "Naperville",postal_code => 60540,region => "Illinois",region_abbr => "IL",street_1 => "216 S. Washington Street",street_2 => undef}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1163 E. Ogden",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2139 CityGate Lane",street_2 => undef}
{city => "Naperville",postal_code => 60653,region => "Illinois",region_abbr => "IL",street_1 => "1563 Naperville Wheaton Road",street_2 => undef}
{city => "Niles",postal_code => 60714,region => "Illinois",region_abbr => "IL",street_1 => "8265 Golf Rd",street_2 => undef}
{city => "Normal",postal_code => 61761,region => "Illinois",region_abbr => "IL",street_1 => "106 North Street",street_2 => undef}
{city => "Northbrook",postal_code => 60062,region => "Illinois",region_abbr => "IL",street_1 => "315 Skokie Blvd",street_2 => undef}
{city => "Oak Park",postal_code => 60301,region => "Illinois",region_abbr => "IL",street_1 => "1034 W. Lake Street",street_2 => undef}
{city => "Peoria",postal_code => 61614,region => "Illinois",region_abbr => "IL",street_1 => "7815 North Knoxville Avenue",street_2 => "Suite 12"}
{city => "Peoria",postal_code => 61603,region => "Illinois",region_abbr => "IL",street_1 => "1404 NE Monroe St.",street_2 => undef}
{city => "Peoria",postal_code => 61604,region => "Illinois",region_abbr => "IL",street_1 => "917 N. Western Avenue",street_2 => undef}
{city => "Peoria",postal_code => 61603,region => "Illinois",region_abbr => "IL",street_1 => "1400 NE Monroe St.",street_2 => undef}
{city => "Rockford",postal_code => 61104,region => "Illinois",region_abbr => "IL",street_1 => "420 E. State Street",street_2 => undef}
{city => "Rockford",postal_code => 61104,region => "Illinois",region_abbr => "IL",street_1 => "515 E. State St.",street_2 => undef}
{city => "Schaumburg",postal_code => 60194,region => "Illinois",region_abbr => "IL",street_1 => "730 Schaumburg Rd",street_2 => undef}
{city => "Skokie",postal_code => 60076,region => "Illinois",region_abbr => "IL",street_1 => "3745 West Dempster Street",street_2 => undef}
{city => "Springfield",postal_code => 62701,region => "Illinois",region_abbr => "IL",street_1 => "322 E. Monroe St.",street_2 => undef}
{city => "springfield",postal_code => 62711,region => "Illinois",region_abbr => "IL",street_1 => "3255 West Iles",street_2 => "n/a"}
{city => "springfield",postal_code => 62704,region => "Illinois",region_abbr => "IL",street_1 => "2575 W Wabash Ave",street_2 => undef}
{city => "St. Charles",postal_code => 60174,region => "Illinois",region_abbr => "IL",street_1 => "110 North 3rd Street",street_2 => undef}
{city => "St. Charles",postal_code => 60174,region => "Illinois",region_abbr => "IL",street_1 => "51 S. First Street",street_2 => undef}
{city => "University Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "23520 Crawford Avenue",street_2 => undef}
{city => "Urbana",postal_code => 61801,region => "Illinois",region_abbr => "IL",street_1 => "306 W. Springfield Ave.",street_2 => undef}
{city => "Urbana",postal_code => 61801,region => "Illinois",region_abbr => "IL",street_1 => "1209 W. Oregon St.",street_2 => undef}
{city => "Urbana",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1005 S. Lincoln Avenue",street_2 => undef}
{city => "Urbana",postal_code => 61801,region => "Illinois",region_abbr => "IL",street_1 => "1209 W. Oregon St",street_2 => undef}
{city => "Vernon Hills",postal_code => 60061,region => "Illinois",region_abbr => "IL",street_1 => "279 Evergreen Drive",street_2 => undef}
{city => "Vernon Hills",postal_code => 60061,region => "Illinois",region_abbr => "IL",street_1 => "260 Hawthorn Village Commons",street_2 => undef}
{city => "Vernon Hills",postal_code => 60061,region => "Illinois",region_abbr => "IL",street_1 => "701 N. Milwaukee Avenue",street_2 => "Suite 280"}
{city => "Westmont",postal_code => 60559,region => "Illinois",region_abbr => "IL",street_1 => "655 N. Cass Avenue",street_2 => undef}
{city => "Wheaton",postal_code => 60187,region => "Illinois",region_abbr => "IL",street_1 => "242 E. Geneva Road",street_2 => undef}
{city => "Woodstock",postal_code => 60098,region => "Illinois",region_abbr => "IL",street_1 => "110 S. Johnson St.",street_2 => undef}
{city => "Zion",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2626 N. Sheridan Road",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "IL.",region_abbr => undef,street_1 => "400 N. LaSalle",street_2 => undef}
{city => "Addison",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1576 Lake Street",street_2 => undef}
{city => "Antioch",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "311 E. Depot St.",street_2 => undef}
{city => "Antioch",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "960 Main St.",street_2 => undef}
{city => "Arlington Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "100 E. Algonquin Rd.",street_2 => undef}
{city => "Arlington Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "66 S. Arlington Heights Rd.",street_2 => undef}
{city => "Arlington Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "17 W. Rand Rd.",street_2 => undef}
{city => "Arlington Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1035 S. Arlington Heights Rd.",street_2 => undef}
{city => "Arlington Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "17 W. Campbell St.",street_2 => undef}
{city => "Aurora",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4334 Fox Valley Center Dr.",street_2 => undef}
{city => "Aurora",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1957 W. Galena Blvd.",street_2 => undef}
{city => "Barrington",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "421 N. Northwest Hwy.",street_2 => undef}
{city => "Barrington",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "704 S. Northwest Hwy.",street_2 => undef}
{city => "Batavia",postal_code => 60510,region => "Illinois",region_abbr => "IL",street_1 => "102 N. River Street",street_2 => undef}
{city => "Batavia",postal_code => 60510,region => "Illinois",region_abbr => "IL",street_1 => "4 North Batavia Avenue",street_2 => undef}
{city => "Batavia",postal_code => 60510,region => "Illinois",region_abbr => "IL",street_1 => "6 N. River Street",street_2 => undef}
{city => "Bellwood",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3207 St. Charles Rd.",street_2 => undef}
{city => "Berwyn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7003 W. Cermak Plz.",street_2 => undef}
{city => "Berwyn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6641 W. Roosevelt Rd.",street_2 => undef}
{city => "Berwyn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6611 W. Roosevelt Rd.",street_2 => undef}
{city => "Bloomingdale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "154 S. Bloomingdale Rd.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "516 N. Main St.",street_2 => undef}
{city => "Bloomington",postal_code => 61704,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Bolingbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "137 N. Weber Rd.",street_2 => undef}
{city => "Boston",postal_code => "02114",region => "Illinois",region_abbr => "IL",street_1 => "181 Cambridge Street",street_2 => undef}
{city => "Bourbonnais",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "541 Main St. NW",street_2 => undef}
{city => "Bradley",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1035 Mulligan Dr.",street_2 => "#2"}
{city => "Buffalo Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "228 McHenry Rd.",street_2 => undef}
{city => "Buffalo Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "167 McHenry Rd.",street_2 => undef}
{city => "Calumet City",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1455 Ring Rd.",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Illinois",region_abbr => "IL",street_1 => "115 Prospect St.",street_2 => undef}
{city => "Carbondale",postal_code => 62902,region => "Illinois",region_abbr => "IL",street_1 => "100 S. Illinois Ave.",street_2 => undef}
{city => "Carbondale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "715 N. Giant City Rd.",street_2 => undef}
{city => "Carbondale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "104 E. Jackson St.",street_2 => undef}
{city => "Carbondale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "521 S. Illinois Ave.",street_2 => undef}
{city => "Carbondale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "119 N. Washington St.",street_2 => undef}
{city => "Carbondale",postal_code => 62901,region => "Illinois",region_abbr => "IL",street_1 => "717 South University Avenue",street_2 => undef}
{city => "Carbondale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "606 S. Illinois Ave.",street_2 => undef}
{city => "Carbondale",postal_code => 62901,region => "Illinois",region_abbr => "IL",street_1 => "100 East Jackson",street_2 => undef}
{city => "Carbondale",postal_code => 62901,region => "Illinois",region_abbr => "IL",street_1 => "1815 West Main Street",street_2 => undef}
{city => "Carol Stream",postal_code => 60188,region => "Illinois",region_abbr => "IL",street_1 => "950 W. Army Trail Road",street_2 => undef}
{city => "Carterville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "112 E. Plaza Dr.",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "528 E Green St",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "1903 Convenience pl",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "617 E Green St",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "216 S 1st St",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "623 E. Green St.",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "132 W. Church St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "403 E. green St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "410 E. Green St.",street_2 => undef}
{city => "Champaign",postal_code => 61801,region => "Illinois",region_abbr => "IL",street_1 => "610 E. Springfield Ave.",street_2 => "Lincoln Square Village, Suite 166"}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2225 S. Neil St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "206 N. Randolph St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "519 E. University Ave.",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "403 E Green St",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "912 1/2 W Bloomington Rd",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1905 N. Neil St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "607 S. Sixth St.",street_2 => undef}
{city => "Champaign",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "611 East Green St.",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "205 N Mattis",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "105 N Mattis",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "2110 Round Barn Rd",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "2006 W Springfield Ave",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "1765 W Kirby Ave",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "1407 N Prospect Ave",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "603 S Wright St",street_2 => undef}
{city => "Champaign",postal_code => 61821,region => "Illinois",region_abbr => "IL",street_1 => "1912 Round Barn Rd",street_2 => undef}
{city => "Champaign",postal_code => 61822,region => "Illinois",region_abbr => "IL",street_1 => "2029 N Prospect Ave",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "601 S. Wright St",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "627 East Green Street",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "607 S Wright St",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "2000 N Neil St # 712",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "2000 N. Neil St.",street_2 => undef}
{city => "Champaign",postal_code => 61820,region => "Illinois",region_abbr => "IL",street_1 => "528 E Green St",street_2 => undef}
{city => "Charleston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "558 W. Lincoln Ave.",street_2 => undef}
{city => "Charleston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "422 Madison Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "676 N St. Clair St.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "22 W Maple Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2453 N. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "1400 N Wells Street",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "240 E Ontario Street",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "42 E Superior",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3257 N. Broadway Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1060 W. Addison St.",street_2 => undef}
{city => "Chicago",postal_code => 60613,region => "Illinois",region_abbr => "IL",street_1 => "3827 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2905 W. Devon St.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "432 W Ontario St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1039 N. Western Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2439 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3103 W. Logan Blvd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1955 W Belmont Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5423 - 5427 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1742 W. Division St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "622 E. 71st St. (at Champlain)",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "510 E. 75th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4653 S. Michigan Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2961 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4600 North Magnolia Avenue",street_2 => "Suite C"}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3123 N. Broadway",street_2 => "53 W. Jackson"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2654 N. Sawyer Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "2508 W. Devon Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2510 W. Devon St.",street_2 => undef}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "7000 N. Glenwood",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "2608 West Devon Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "1901 North Halsted Street",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "2543 West Devon Ave",street_2 => undef}
{city => "Chicago",postal_code => 60655,region => "Illinois",region_abbr => "IL",street_1 => "3031 W 111th St",street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "2100 West Roscoe St",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "2024 N Halsted",street_2 => undef}
{city => "Chicago",postal_code => 60629,region => "Illinois",region_abbr => "IL",street_1 => "3259 W 63rd St",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "112 N May Street",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1001 W Washington Blvd.",street_2 => undef}
{city => "Chicago",postal_code => 60616,region => "Illinois",region_abbr => "IL",street_1 => "2172 S Archer Ave",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "1411 N Wells St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1375 West Lake Street",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5004 N Sheridan Road",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "140 N Halsted St",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "1865 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60619,region => "Illinois",region_abbr => "IL",street_1 => "205 E. 75th Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => " 2057 W. North Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "1418 W. Howard St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "100 E. Walton St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "247 E. Ontario St.",street_2 => "#2"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "900 N. North Branch",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1646 N. Damen Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "25 E. Delaware Pl.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1923 W. North Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2222 N. Elston Ave.",street_2 => undef}
{city => "Chicago",postal_code => "60657-1606",region => "Illinois",region_abbr => "IL",street_1 => "3408 N Clark St",street_2 => undef}
{city => "Chicago",postal_code => "60610-4213",region => "Illinois",region_abbr => "IL",street_1 => "535 North Wells",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2548 W. Devon Ave",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1375 E. 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => "60657-2414",region => "Illinois",region_abbr => "IL",street_1 => "3411 N Halsted St",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3242 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60625,region => "Illinois",region_abbr => "IL",street_1 => "4608 N Western Ave",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "1616 N. Kedzie",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "1769 W. Sunnyside Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "615 W. Randolph Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1723 North Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "954 W. Fulton Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "229 S. Western Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2961 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "818 W. Fullerton Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1635 E. 55th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1919 W. Montrose Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2411 S. Wallace St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6604 N. Sheridan Rd.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "30 West Huron St",street_2 => undef}
{city => "Chicago",postal_code => 60606,region => "Illinois",region_abbr => "IL",street_1 => "191 N. Wacker Drive",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3300 N. Ashland Ave",street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "3038 West Irving Park Rd.",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1505 W. Chicago Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60642,region => "Illinois",region_abbr => "IL",street_1 => "1550 N. Kingsbury St.",street_2 => undef}
{city => "Chicago",postal_code => 60616,region => "Illinois",region_abbr => "IL",street_1 => "2129 S. China Pl.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1450 E 57th St",street_2 => undef}
{city => "Chicago",postal_code => 60616,region => "Illinois",region_abbr => "IL",street_1 => "2201 S. Wentworth Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1526 E. 55th St.",street_2 => undef}
{city => "Chicago",postal_code => 60649,region => "Illinois",region_abbr => "IL",street_1 => "7122 S. Jeffrey Blvd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "233 N. Michigan Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4742 N. Kedzie Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1534 N. Wells St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "738 W. Fullerton Pkwy.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3008 W. Devon Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "722 W. Grand Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1616 N. Damen Ave.",street_2 => "#1"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3202 N. Broadway Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "1139 N State St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "25 E. Delaware Pl.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => " 530 N. Wabash Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5253 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2915 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => 60630,region => "Illinois",region_abbr => "IL",street_1 => "4569 North Elston Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3176 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4017 W. Lawrence St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1008 W Armitage Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1957 W. Chicago Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2646 W. Devon Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5627 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "52 W. Illinois St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6352 N. Oakley Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "1160 N. Dearborn St",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3136 N Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6649 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "614 W Diversey Pkwy",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3006 N. Sheffield Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3400 N Sheffield Ave",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "6 East Cedar",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3114 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5256 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4953 N. Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1226 E. 53rd St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3141 W Roosevelt",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5801 S. Ellis Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60623,region => "Illinois",region_abbr => "IL",street_1 => "3936 W. 31st Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "10844 S. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1101 E. 56th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "318 W. Adams St.",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "108 East Superior Street",street_2 => "5th Floor"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2658 W. Devon Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "1610 N Wells Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1200 W. Webster Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "59 W. Grand Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "163 W. North Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "819 N Rush Street",street_2 => undef}
{city => "Chicago",postal_code => 60603,region => "Illinois",region_abbr => "IL",street_1 => "140 S Dearborn",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "958 W Armitage",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "150 W. Congress Pkwy. at LaSalle Blue Line El stop",street_2 => undef}
{city => "Chicago",postal_code => 60601,region => "Illinois",region_abbr => "IL",street_1 => "16 W Randolph",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3242 W. Foster Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1746 W. Addison St.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3135 N Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3215 N. Sheffield Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3358 N. Paulina St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5758 S Maryland Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6935 N. Sheridan Rd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1716 W. Lunt Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1558 N. Elston Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "646 N. Franklin St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "516 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3877 N. Elston Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3443 N. Southport Ave.",street_2 => undef}
{city => "Chicago",postal_code => "60614-2717",region => "Illinois",region_abbr => "IL",street_1 => "2411 N Clark Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1936 W. Augusta Blvd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1419 W. Taylor St.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3332 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "11060 S. Western Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2147 W. Roscoe St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "9156 S. Stony Island Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1459 E 53rd St",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "5846 N. Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2144-46 W. Division St.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1206 E. 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3216 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2057 W. Roscoe St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1333 E 57th St",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1327 E 57th St",street_2 => undef}
{city => "Chicago",postal_code => 60613,region => "Illinois",region_abbr => "IL",street_1 => "3800 N Clark Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1508 E. 53rd St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3134 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60647,region => "Illinois",region_abbr => "IL",street_1 => "2311 W. North Ave",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1611 E 55th St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1512 W. Foster Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5706 S. University Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "60 E. Ohio St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1025 East 58th Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "21 N. Wabash Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3311 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1100 E. 57th St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5706 S. University Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "130 S. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5640 S. University Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "100 W. Randolph St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1707 W. Division St.",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1032 W. Lake St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1300 North Milwaukee Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5403 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5640 S. University Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1623 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1005 E. 60th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2537 N. Kedzie Blvd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "500 W. Diversey Pkwy.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1526 E. 55th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5255 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "964 W Belmont Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5400 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "6120 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "646 N. Franklin St.",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1460 West Chicago Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1530 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "730 W. Maxwell St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2557 N. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "5706 South University Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2209 W. Montrose Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "122 W. Madison St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "200 W. Monroe St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1065 W. Argyle St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5951 N. Broadway Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "200 E. Randolph St.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "930 W. Belmont Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "223 W. Lake St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "233 E. Wacker Dr.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4621 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "745 N. Damen Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "300 S. Wacker Dr.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2534 W. Division St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1466 N. Ashland Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2852 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "5200 E 53rd St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2100 W. 95th St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2109 S. China Pl.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "917 W. Belmont Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "11 E. Illinois St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1509 W. Foster Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1236 East 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "37 N. Wells St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "179 W. Van Buren St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "111 E. Wacker Dr.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "222 Merchandise Mart",street_2 => "Ste. 113"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2657 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3745 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1840 N. Clybourn Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "180 N. Michigan Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2121 N. Clybourn Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2813 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3460 N. Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "75 W. Elm St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1639 N. Wells St.",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "5812 N. Broadway St",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "680 N. Lake Shore Dr.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1337 W. Fullerton Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60646,region => "Illinois",region_abbr => "IL",street_1 => "6207 N. Milwaukee Ave.",street_2 => "Floor 1"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1401 W. Devon Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60626,region => "Illinois",region_abbr => "IL",street_1 => "1261 West Loyola Ave",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1970 E. 73rd St.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1312 East 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => 60659,region => "Illinois",region_abbr => "IL",street_1 => "2629 W. Devon Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1309 South Wabash Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "44 E. Ontario St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2845 North Clark St.",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5317 N. Clark St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2045 W. North Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1 N. Dearborn St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3300 N. Lincoln Ave.",street_2 => "Chicago"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3640 N. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "250 E. Superior St.",street_2 => undef}
{city => "Chicago",postal_code => 60603,region => "Illinois",region_abbr => "IL",street_1 => "77 East Adams Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6020 N. Cicero Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "550 St. Clair St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1467 W. Montrose Avenue.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1101 S. Canal St.",street_2 => "Ste. 107"}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "O'Hare Airport",street_2 => "Terminal 3 Mezzanine Level"}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "686 North Franklin Street",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "816 West Armitage Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60619,region => "Illinois",region_abbr => "IL",street_1 => "203 East 75th Street",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5232 North Sheridan Road",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => " 3257 N. Broadway",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3322 N Broadway Avenue",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "960 W. Belmont Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3200 N. Southport Ave",street_2 => undef}
{city => "Chicago",postal_code => 60603,region => "Illinois",region_abbr => "IL",street_1 => "72 East Adams",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "434 W. Diversey Pkwy.",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1542 N. Damen Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60613,region => "Illinois",region_abbr => "IL",street_1 => "950 W. Diversey Parkway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2404 N. Lincoln Ave.",street_2 => undef}
{city => "Chicago",postal_code => " 60614-6154",region => "Illinois",region_abbr => "IL",street_1 => "435 W Diversey",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "2901 N Broadway St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "820 W. Randolph St.",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1240 West Randolph",street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "3038 W. Irving Park Rd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2207 W. Montrose Ave.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "112 W. Monroe St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1711 E. 87th Street",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3227 N Clark Street",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3112 N Broadway",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "666 W. Diversey Pkwy.",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3124 N Broadway",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1045 W. Madison Street",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "237 W North Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "6034 North Broadway",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1301 E. 53rd St.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2010 N. Halsted St.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "319 W. North Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1000 W. Washington Blvd.",street_2 => undef}
{city => "Chicago",postal_code => 60602,region => "Illinois",region_abbr => "IL",street_1 => "19 N Wabash Ave",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "3456 N Sheffield",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2047 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "737 N LaSalle Drive",street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "2056 W Division",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "835 N. Michigan Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60615,region => "Illinois",region_abbr => "IL",street_1 => "1512 E. 53rd Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => undef,street_2 => undef}
{city => "Chicago",postal_code => 60622,region => "Illinois",region_abbr => "IL",street_1 => "1561 N. Milwaukee Ave.",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "531 N Wells St",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "919 W Belmont",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "5353 N Broadway Street",street_2 => undef}
{city => "Chicago",postal_code => 60657,region => "Illinois",region_abbr => "IL",street_1 => "921 W Belmont Ave",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "444 West Fullerton Pkwy",street_2 => undef}
{city => "Chicago",postal_code => 60611,region => "Illinois",region_abbr => "IL",street_1 => "600 North Michigan Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60637,region => "Illinois",region_abbr => "IL",street_1 => "1520 E. 57th St.",street_2 => undef}
{city => "Chicago",postal_code => 60605,region => "Illinois",region_abbr => "IL",street_1 => "719 S. State Street",street_2 => undef}
{city => "Chicago",postal_code => 60614,region => "Illinois",region_abbr => "IL",street_1 => "2723 N. Clark",street_2 => undef}
{city => "Chicago",postal_code => 60605,region => "Illinois",region_abbr => "IL",street_1 => "400 S Michigan Avenue",street_2 => undef}
{city => "Chicago",postal_code => 60618,region => "Illinois",region_abbr => "IL",street_1 => "3109 W. Irving Park Road",street_2 => undef}
{city => "Chicago",postal_code => 60640,region => "Illinois",region_abbr => "IL",street_1 => "1055 W. Argyle Street",street_2 => undef}
{city => "Chicago",postal_code => 60616,region => "Illinois",region_abbr => "IL",street_1 => "2159 South China Place",street_2 => undef}
{city => "Chicago",postal_code => 60607,region => "Illinois",region_abbr => "IL",street_1 => "1335 S. Halsted",street_2 => undef}
{city => "Chicago",postal_code => 60610,region => "Illinois",region_abbr => "IL",street_1 => "617 N Wells St.",street_2 => undef}
{city => "Chicago",postal_code => 60660,region => "Illinois",region_abbr => "IL",street_1 => "5707 N. Clark Street",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1560 N. Damen Ave.",street_2 => undef}
{city => "Chicago Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "120 Halsted St.",street_2 => undef}
{city => "Collinsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "604 W. Main St.",street_2 => undef}
{city => "Collinsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "501 Belt Line Rd.",street_2 => "#20N"}
{city => "Country Club Hills",postal_code => 60478,region => "Illinois",region_abbr => "IL",street_1 => "4111 183rd St.",street_2 => undef}
{city => "Crystal Lake",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "35 Berkshire Dr.",street_2 => undef}
{city => "Crystal Lake",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "25 E. Crystal Lake Ave.",street_2 => undef}
{city => "Crystal Lake",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4912 Northwest Hwy.",street_2 => undef}
{city => "Darien",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2159 75th St.",street_2 => undef}
{city => "Decatur",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3025 Kandy Ln.",street_2 => undef}
{city => "Decatur",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "645 W. Pershing Rd.",street_2 => undef}
{city => "Decatur",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1624 S. Taylorville Rd.",street_2 => undef}
{city => "Deer Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "21520 W. Field Pkwy.",street_2 => undef}
{city => "Deer Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "20530 N. Rand Rd.",street_2 => undef}
{city => "Deerfield",postal_code => 60015,region => "Illinois",region_abbr => "IL",street_1 => "760 Waukegan Road",street_2 => undef}
{city => "DeKalb",postal_code => 60115,region => "Illinois",region_abbr => "IL",street_1 => "214 E. Lincoln Highway",street_2 => undef}
{city => "DeKalb",postal_code => 60115,region => "Illinois",region_abbr => "IL",street_1 => "131 E. Lincoln Highway",street_2 => undef}
{city => "DeKalb",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1402 Sycamore Rd.",street_2 => undef}
{city => "DeKalb",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "129 E. Hillcrest Dr.",street_2 => undef}
{city => "DeKalb",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "901 Lucinda Ave.",street_2 => undef}
{city => "DeKalb",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "263 E. Lincoln Hwy.",street_2 => undef}
{city => "Des Plaines",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1504 Miner St.",street_2 => undef}
{city => "Downers Grove",postal_code => 60515,region => "Illinois",region_abbr => "IL",street_1 => "970 Warren Ave",street_2 => undef}
{city => "Downers Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7329 Lemont Rd.",street_2 => undef}
{city => "Downers Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2129 63rd St.",street_2 => undef}
{city => "Downers Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2113 63rd St.",street_2 => undef}
{city => "Downers Grove",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "122 Ogden Ave.",street_2 => undef}
{city => "East St. Louis",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2203 Missouri Ave.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "233 N. Main St.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7403 Marine Rd.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1025 Century Dr.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6698 Center Grove Rd.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "University Point II Center",street_2 => "1039 Century Dr."}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1518 Troy Rd.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "#4 Club Centre Dr.",street_2 => undef}
{city => "Edwardsville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "441 S. Buchanan St. (Rt. 159)",street_2 => undef}
{city => "Elgin",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "302 S. McLean Blvd.",street_2 => undef}
{city => "Elgin",postal_code => 60120,region => "Illinois",region_abbr => "IL",street_1 => "7 Clock Tower Plaza",street_2 => undef}
{city => "Elgin",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "895 S. Randall Rd.",street_2 => undef}
{city => "Elmhurst",postal_code => 60126,region => "Illinois",region_abbr => "IL",street_1 => "683 N. York Road",street_2 => undef}
{city => "Elmhurst",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "108 Schiller Street",street_2 => undef}
{city => "Elmhurst",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "416 B N York St.",street_2 => undef}
{city => "Elmhurst",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "214 N. York Rd.",street_2 => undef}
{city => "Elmhurst",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "116 Schiller St.",street_2 => undef}
{city => "Elmhurst",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "149 N. Addison Ave.",street_2 => undef}
{city => "Elmwood Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7628 W. North Ave.",street_2 => undef}
{city => "Elmwood Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7230 W. North Ave.",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "1100 Davis Street",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "1640 Chicago Avenue",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "1322 Chicago Ave",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "525 Dempster St.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1601 Simpson St",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1596 Sherman Ave.",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "1110 W. Davis St.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "635 Chicago Ave.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1621 Chicago Ave.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "804 Davis St.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "930 Church St.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "610 Davis St.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1571 Sherman Ave.",street_2 => undef}
{city => "Evanston",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1111 Chicago Ave.",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "707 Church St.",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "630 Church Street",street_2 => undef}
{city => "Evanston",postal_code => 60201,region => "Illinois",region_abbr => "IL",street_1 => "521 Davis Street",street_2 => undef}
{city => "Fairview Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5725 N. Illinois St.",street_2 => undef}
{city => "Flossmoor",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3203 Volmer Rd.",street_2 => undef}
{city => "Geneva",postal_code => 60134,region => "Illinois",region_abbr => "IL",street_1 => "1772 S. Randall Road",street_2 => "Suite 270"}
{city => "Geneva",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1310 Commons Dr.",street_2 => undef}
{city => "Geneva",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "716 W. State St.",street_2 => undef}
{city => "Glen Carbon",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "310 Junction Dr.",street_2 => undef}
{city => "Glen Ellyn",postal_code => 60137,region => "Illinois",region_abbr => "IL",street_1 => "499 N. Main Street",street_2 => undef}
{city => "Glen Ellyn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "680 Roosevelt Rd.",street_2 => undef}
{city => "Glendale Heights",postal_code => 60139,region => "Illinois",region_abbr => "IL",street_1 => "252 E. Army Trail Road",street_2 => "Glendale Town Center"}
{city => "Glenview",postal_code => "60025-7637",region => "Illinois",region_abbr => "IL",street_1 => "2351 Willow Road",street_2 => undef}
{city => "Glenview",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1107 N. Waukegan Rd.",street_2 => undef}
{city => "Glenview",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1851 Tower Dr.",street_2 => undef}
{city => "Glenview",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1407 Waukegan Rd.",street_2 => undef}
{city => "Gurnee",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "401 N. Riverside Dr.",street_2 => "Unit 20"}
{city => "Gurnee",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6951 W. Grand Ave.",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "149 Skokie Valley Rd.",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1812 Green Bay Rd.",street_2 => undef}
{city => "Highwood",postal_code => 60040,region => "Illinois",region_abbr => "IL",street_1 => "P.O. Box 223",street_2 => undef}
{city => "Hillside",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4431 W. Roosevelt Rd.",street_2 => undef}
{city => "Hinsdale",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "500 E. Ogden Ave.",street_2 => undef}
{city => "Hoffman Estates",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2557 W. Golf Rd.",street_2 => undef}
{city => "Jerome",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1531 Wabash Ave.",street_2 => undef}
{city => "Joliet",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "Twin Oak Plaza",street_2 => "3135 W. Jefferson St."}
{city => "La Grange",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1 E. Burlington Ave.",street_2 => undef}
{city => "La Grange",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "419 N. La Grange Rd.",street_2 => undef}
{city => "La Grange",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "25 N. La Grange Rd.",street_2 => undef}
{city => "Lake Forest",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "Not a restaurant - provides services for off-site events only",street_2 => undef}
{city => "Lake Forest",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "825 S. Waukegan Rd.",street_2 => undef}
{city => "Lake in the Hills",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "315 N. Randall Rd.",street_2 => undef}
{city => "Lake Zurich",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "123 S. Rand Rd.",street_2 => undef}
{city => "Lake Zurich",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "735 W. Main St.",street_2 => undef}
{city => "Lansing",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "17650 Torrence Ave.",street_2 => undef}
{city => "LaSalle",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2320 St. Vincent Ave.",street_2 => undef}
{city => "Libertyville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "400 N. Milwaukee Ave.",street_2 => undef}
{city => "Libertyville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1451 W. Peterson Rd.",street_2 => undef}
{city => "Libertyville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "318 S. Milwaukee Ave.",street_2 => undef}
{city => "Lincolnshire",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "215 Parkway Dr.",street_2 => undef}
{city => "Lombard",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "305 Yorktown Center",street_2 => undef}
{city => "Lombard",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "229 W. Roosevelt Rd.",street_2 => undef}
{city => "Lombard",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1300 S. Main St.",street_2 => "Ste. A"}
{city => "Lombard",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2361 Fountain Square Dr.",street_2 => undef}
{city => "Lombard",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "340 E. Roosevelt Rd.",street_2 => undef}
{city => "Maryville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2 Professional Park Dr.",street_2 => undef}
{city => "Matteson",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "21750 Main St.",street_2 => undef}
{city => "McHenry",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1717 N. Richmond Rd.",street_2 => undef}
{city => "Moline",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1317 6th Ave.",street_2 => undef}
{city => "Moline",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1606 5th Ave.",street_2 => undef}
{city => "Morris",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "216 Liberty St.",street_2 => undef}
{city => "Mount Carmel",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "534 Market St.",street_2 => undef}
{city => "Mount Carroll",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "112 W. Market St.",street_2 => undef}
{city => "Mount Prospect",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2348 S. Elmhurst Rd.",street_2 => undef}
{city => "Mount Prospect",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1742 W. Golf Rd.",street_2 => undef}
{city => "Mount Vernon",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "102 S. 4th St.",street_2 => undef}
{city => "Mundelein",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "502 N. Seymour Ave.",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "22 E. Chicago",street_2 => "#122"}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1255 E. Ogden Ave.",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "778 N. Route 59",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "207 S. Washington St.",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1570 W. Ogden Ave.",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "44 W. Gartner Rd.",street_2 => undef}
{city => "Naperville",postal_code => 60540,region => "Illinois",region_abbr => "IL",street_1 => "218 S. Washington Street",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1847 Freedom Drive",street_2 => undef}
{city => "Naperville",postal_code => 60563,region => "Illinois",region_abbr => "IL",street_1 => "1021 W Ogden Ave",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "221 S Washington St",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2607 W. 75th St.",street_2 => undef}
{city => "Naperville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "22 E. Chicago Ave.",street_2 => undef}
{city => "New Lenox",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1340 N. Cedar Rd.",street_2 => undef}
{city => "Niles",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "9359 Milwaukee Ave.",street_2 => undef}
{city => "Niles",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5681 W. Touhy Ave.",street_2 => undef}
{city => "Normal",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "307 Veterans Pkwy.",street_2 => undef}
{city => "Normal",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "609 S. Main St.",street_2 => undef}
{city => "Normal",postal_code => 61761,region => "Illinois",region_abbr => "IL",street_1 => "114 E Beaufort St",street_2 => undef}
{city => "Normal",postal_code => 61761,region => "Illinois",region_abbr => "IL",street_1 => "1503 E. College Avenue",street_2 => undef}
{city => "Norridge",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "8536 W. Lawrence Ave.",street_2 => undef}
{city => "Northbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1819 Lake Cook Rd.",street_2 => undef}
{city => "Northbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1186 Northbrook Ct.",street_2 => undef}
{city => "Northbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1127 Church St.",street_2 => undef}
{city => "Northbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "577 Waukegan Rd.",street_2 => undef}
{city => "Northbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "840 Willow Rd.",street_2 => "Ste. M"}
{city => "Oak Brook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "40 N. Tower Rd.",street_2 => undef}
{city => "Oak Brook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "105 Oakbrook Center",street_2 => undef}
{city => "Oak Brook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2809 Butterfield Rd.",street_2 => undef}
{city => "Oak Brook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "240 Oakbrook Center",street_2 => undef}
{city => "Oak Lawn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5142 W. 95th St.",street_2 => undef}
{city => "Oak Lawn",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6616 W. 95th St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "905 S. Lombard Ave.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "726 Lake St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "129 S. Oak Park Ave.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1030 Lake St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1031 Lake St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "848 Madison St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "733 Lake St.",street_2 => undef}
{city => "Oak Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "834 Lake St.",street_2 => undef}
{city => "Oak Park",postal_code => 60302,region => "Illinois",region_abbr => "IL",street_1 => "1130 Chicago Avenue",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "9177 W. 151st St.",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "14662 La Grange Rd.",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "15818 Harlem Ave.",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "14924 S. La Grange Rd.",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "14812 S. La Grange Rd.",street_2 => undef}
{city => "Orland Park",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "14135 La Grange Rd.",street_2 => undef}
{city => "Oswego",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "37-D Stonehill Rd.",street_2 => undef}
{city => "Palatine",postal_code => 60074,region => "Illinois",region_abbr => "IL",street_1 => "1331 North Rand Road",street_2 => undef}
{city => "Palos Heights",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7228 W. College Dr.",street_2 => undef}
{city => "Palos Hills",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7227 W. 103rd St.",street_2 => undef}
{city => "Park Ridge",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "510 W. Touhy Ave.",street_2 => undef}
{city => "Park Ridge",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "190 North Northwest Highway",street_2 => undef}
{city => "Pekin",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "119 N. Parkway Dr.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5201 W. War Memorial Dr.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "537 Main St.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4700 N. University St.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1245 W. Main St.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1209 W. Main St.",street_2 => undef}
{city => "Peoria",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "305 S.W. Water St.",street_2 => undef}
{city => "Quincy",postal_code => 62301,region => "Illinois",region_abbr => "IL",street_1 => "307 N 36th St",street_2 => undef}
{city => "River Forest",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7301 North Ave.",street_2 => undef}
{city => "River Forest",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7219 W. Lake St.",street_2 => undef}
{city => "River Forest",postal_code => 60035,region => "Illinois",region_abbr => "IL",street_1 => "7245 Lake St",street_2 => undef}
{city => "Rockford",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1659 N. Alpine Rd.",street_2 => undef}
{city => "Rockford",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3929 Broadway St.",street_2 => undef}
{city => "Rockford",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "325 N. Church St.",street_2 => undef}
{city => "Rockford",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4010 E. State St.",street_2 => undef}
{city => "Rockford",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "6551 E. Riverside Blvd.",street_2 => "# 114"}
{city => "Roscoe",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4431 E. State St.",street_2 => undef}
{city => "Schaumburg",postal_code => 60173,region => "Illinois",region_abbr => "IL",street_1 => "1951 McConnor Parkway",street_2 => undef}
{city => "Schaumburg",postal_code => 60194,region => "Illinois",region_abbr => "IL",street_1 => "1135 N Salem Dr",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "130 W. Golf Rd.",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1521 W. Schaumburg Rd.",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5 Woodfield Mall",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "365 S. Roselle Rd.",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "5 Woodfield Mall",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1901 E. Woodfield Rd.",street_2 => undef}
{city => "Schaumburg",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1950 E. Higgins Rd.",street_2 => undef}
{city => "Schaumburg",postal_code => 60194,region => "Illinois",region_abbr => "IL",street_1 => "927 W. Golf Road",street_2 => undef}
{city => "Skokie",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4020 W. Oakton St.",street_2 => undef}
{city => "Skokie",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3320 Dempster St.",street_2 => undef}
{city => "Skokie",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4654 Church St.",street_2 => undef}
{city => "Skokie",postal_code => 60076,region => "Illinois",region_abbr => "IL",street_1 => "4120 Dempster Street",street_2 => undef}
{city => "Skokie",postal_code => 60076,region => "Illinois",region_abbr => "IL",street_1 => "3910 Dempster St",street_2 => undef}
{city => "South Elgin",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "360 Randall Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1101 Wabash Ave.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3325 Robbins Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1308 S. 2nd St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2824 Plaza Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3124 Montvale Dr.",street_2 => "#D"}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "516 E. Adams St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "115 N. Sixth St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "425 N. Grand Ave. E.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "115 N. Lewis St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4112 N. Peoria Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2636 Stevenson Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3053 S. Dirksen Pkwy.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2433 S. MacArthur Blvd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "305 Chatham Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2225 Stevenson Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2753 S. Veterans Pkwy.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "524 E. Monroe St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3431 Freedom Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1901 W. Monroe St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2777 S. 6th St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3001 S. Veterans Pkwy.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "432 E. Monroe St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2520 N. Dirksen Pkwy.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2936 S. Macarthur Blvd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "4200 Conestoga Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "213 S. 5th St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1512 Wabash Ave.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3115 Chatham Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "107 W. Cook Street",street_2 => "Vinegar Hill Mall"}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1665 Wabash Ave.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3100 W. White Oaks Dr.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1124 W. Jefferson St.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "3311 Robbins Rd.",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "530 E. Capitol Ave.",street_2 => undef}
{city => "St. Charles",postal_code => 60174,region => "Illinois",region_abbr => "IL",street_1 => "2075 Prairie Street",street_2 => undef}
{city => "St. Charles",postal_code => 60174,region => "Illinois",region_abbr => "IL",street_1 => "11 N. Third Street",street_2 => undef}
{city => "St. Charles",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2801 E. Main St.",street_2 => undef}
{city => "Streamwood",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "289 N. Barrington Rd.",street_2 => undef}
{city => "Urbana",postal_code => 61801,region => "Illinois",region_abbr => "IL",street_1 => "1106 W. University Ave.",street_2 => undef}
{city => "Urbana",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "111 N. Race St.",street_2 => undef}
{city => "Urbana",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "407 W. University Ave.",street_2 => undef}
{city => "Urbana",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "212 W. Main St.",street_2 => undef}
{city => "Urbana",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "402 N. Race St.",street_2 => undef}
{city => "Vandalia",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "420 W. Gallatin St.",street_2 => undef}
{city => "Warrenville",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "28252 Diehl Rd.",street_2 => undef}
{city => "Waukegan",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "1921 Grand Ave.",street_2 => undef}
{city => "Wayne",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "P.O. Box 566",street_2 => undef}
{city => "West Dundee",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "310-330 N. 8th St. (Rt. 31)",street_2 => undef}
{city => "Westmont",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "806 E. Ogden Ave.",street_2 => undef}
{city => "Westmont",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "669 N. Cass Ave.",street_2 => undef}
{city => "Wheaton",postal_code => 60187,region => "Illinois",region_abbr => "IL",street_1 => "140 N. Main Street",street_2 => undef}
{city => "Wheaton",postal_code => 60187,region => "Illinois",region_abbr => "IL",street_1 => "151 Rice Lake Square",street_2 => undef}
{city => "Wheaton",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "2019 S. Naperville Rd.",street_2 => undef}
{city => "Wheeling",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "122 S. Elmhurst Rd.",street_2 => undef}
{city => "Willowbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "7243 S. Kingery Hwy. (Rt. 83)",street_2 => undef}
{city => "Willowbrook",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "201 W. 63rd St. (between Rt. 83 and Clarendon Hills Rd.)",street_2 => undef}
{city => "Wilmette",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "708 Twelfth St.",street_2 => undef}
{city => "Wilmette",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "911 Ridge Rd.",street_2 => undef}
{city => "Winfield",postal_code => undef,region => "Illinois",region_abbr => "IL",street_1 => "27 W. 187 Geneva Rd.",street_2 => undef}
{city => "Chicago",postal_code => undef,region => "Illnois",region_abbr => undef,street_1 => "1526 E 55th St",street_2 => undef}
{city => "Alexandria",postal_code => 46001,region => "Indiana",region_abbr => "IN",street_1 => "1617 South Parke Avenue",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "322 E Kirkwood Avenue",street_2 => undef}
{city => "Bloomington",postal_code => 47404,region => "Indiana",region_abbr => "IN",street_1 => "124 N. Walnut St",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "322 E. Kirkwood Avenue",street_2 => undef}
{city => "Bloomington",postal_code => 47404,region => "Indiana",region_abbr => "IN",street_1 => "350 W. 11th Street",street_2 => undef}
{city => "Bloomington",postal_code => 47405,region => "Indiana",region_abbr => "IN",street_1 => "900 East 7th Street",street_2 => "Indiana Memorial Union"}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "430 E 4th St",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "113 S. Grant St.",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "314 E. Kirkwood Avenue",street_2 => undef}
{city => "Bloomington",postal_code => 47404,region => "Indiana",region_abbr => "IN",street_1 => "222 N. Walnut Street",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "2604 E. 10th Street",street_2 => undef}
{city => "Bloomington",postal_code => 47401,region => "Indiana",region_abbr => "IN",street_1 => "303 E. 3rd Street",street_2 => "Suite C62"}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "116 N. Grant St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "415 E 4th Street",street_2 => undef}
{city => "Bloomington",postal_code => 47401,region => "Indiana",region_abbr => "IN",street_1 => "3220 East Third St",street_2 => undef}
{city => "Bloomington",postal_code => 47408,region => "Indiana",region_abbr => "IN",street_1 => "419 E. Kirkwood Ave.",street_2 => undef}
{city => "Bloomington",postal_code => 47404,region => "Indiana",region_abbr => "IN",street_1 => "316 W. Sixth St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "424 East Fourth Street",street_2 => undef}
{city => "Bloomington",postal_code => 47401,region => "Indiana",region_abbr => "IN",street_1 => "4600 S State Road 446",street_2 => undef}
{city => "Bloomington",postal_code => 47402,region => "Indiana",region_abbr => "IN",street_1 => "430 E. Kirkwood Ave.",street_2 => undef}
{city => "Chesterton",postal_code => 46304,region => "Indiana",region_abbr => "IN",street_1 => "418 Roberts Rd",street_2 => undef}
{city => "Evansville",postal_code => 47725,region => "Indiana",region_abbr => "IN",street_1 => "1033 E. Mount Pleasant Road",street_2 => undef}
{city => "Evansville",postal_code => 47713,region => "Indiana",region_abbr => "IN",street_1 => "116 Washington Ave.",street_2 => undef}
{city => "Farmland",postal_code => 47340,region => "Indiana",region_abbr => "IN",street_1 => "101 North Main Street",street_2 => undef}
{city => "Fort Wayne",postal_code => 46825,region => "Indiana",region_abbr => "IN",street_1 => "7605 Coldwater Road",street_2 => "Suite A"}
{city => "Fort Wayne",postal_code => 46825,region => "Indiana",region_abbr => "IN",street_1 => "4634 Coldwater Rd",street_2 => undef}
{city => "Fort Wayne",postal_code => 46825,region => "Indiana",region_abbr => "IN",street_1 => "622 E. Dupont Road",street_2 => undef}
{city => "Goshen",postal_code => 46526,region => "Indiana",region_abbr => "IN",street_1 => "62535 CR 37",street_2 => undef}
{city => "Granger",postal_code => 46530,region => "Indiana",region_abbr => "IN",street_1 => "425 E. University Drive",street_2 => undef}
{city => "Greensburg",postal_code => 47240,region => "Indiana",region_abbr => "IN",street_1 => "211 N. Broadway Street",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "830 Broad Ripple Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46202,region => "Indiana",region_abbr => "IN",street_1 => "339 Massachussets Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "6253 N College Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "801 Broad Ripple Ave.",street_2 => undef}
{city => "Indianapolis",postal_code => 46240,region => "Indiana",region_abbr => "IN",street_1 => "3855 E. 96th St",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "1041 Broad Ripple Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "825 N Pennsylvania St",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "5463 N College Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "659 Massachussettes Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46240,region => "Indiana",region_abbr => "IN",street_1 => "1300 E 86th St",street_2 => undef}
{city => "Indianapolis",postal_code => 46254,region => "Indiana",region_abbr => "IN",street_1 => "4375 Georgetown Rd",street_2 => undef}
{city => "Indianapolis",postal_code => 46250,region => "Indiana",region_abbr => "IN",street_1 => "5353 E. 82nd Street",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "237 N. East St.",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "237 N. East Street",street_2 => undef}
{city => "Indianapolis",postal_code => 46254,region => "Indiana",region_abbr => "IN",street_1 => "4225 Lafayette Rd",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "201 N. Delaware ave.",street_2 => undef}
{city => "Indianapolis",postal_code => 46254,region => "Indiana",region_abbr => "IN",street_1 => "4225 Lafayette Rd",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "6360 Guilford Avenue",street_2 => undef}
{city => "Indianapolis",postal_code => 46204,region => "Indiana",region_abbr => "IN",street_1 => "207 N. Delaware Street",street_2 => undef}
{city => "Indianpolis",postal_code => 46222,region => "Indiana",region_abbr => "IN",street_1 => "3103 Lafayette Rd",street_2 => undef}
{city => "Lafayette",postal_code => 47901,region => "Indiana",region_abbr => "IN",street_1 => "219 Main Street",street_2 => undef}
{city => "Michigan City",postal_code => 46360,region => "Indiana",region_abbr => "IN",street_1 => "208 Wabash St.",street_2 => undef}
{city => "Mishawaka",postal_code => 46545,region => "Indiana",region_abbr => "IN",street_1 => "6501 N. Grape Road",street_2 => "University Park Mall"}
{city => "Mishawaka",postal_code => 46544,region => "Indiana",region_abbr => "IN",street_1 => "5618 Grape Rd",street_2 => undef}
{city => "Mishawaka",postal_code => 46544,region => "Indiana",region_abbr => "IN",street_1 => "512 S. Spring Street",street_2 => undef}
{city => "Mishawaka",postal_code => 46545,region => "Indiana",region_abbr => "IN",street_1 => "508 W. Mckinley Ave",street_2 => undef}
{city => "Mishawaka",postal_code => 46545,region => "Indiana",region_abbr => "IN",street_1 => "507 E. McKinley Avenue",street_2 => undef}
{city => "Mishawaka",postal_code => 46545,region => "Indiana",region_abbr => "IN",street_1 => "3915 Grape Road",street_2 => undef}
{city => "Mishawaka",postal_code => 46545,region => "Indiana",region_abbr => "IN",street_1 => "615 West Edison Road",street_2 => undef}
{city => "Munster",postal_code => 46321,region => "Indiana",region_abbr => "IN",street_1 => "221 Ridge Road",street_2 => undef}
{city => "New Albany",postal_code => 47150,region => "Indiana",region_abbr => "IN",street_1 => "3003 Charlestown Crossing Way",street_2 => undef}
{city => "New Albany",postal_code => 47150,region => "Indiana",region_abbr => "IN",street_1 => "133 East Market Street",street_2 => undef}
{city => "New Albany",postal_code => 47150,region => "Indiana",region_abbr => "IN",street_1 => "614 Hausfeldt Ln",street_2 => undef}
{city => "Schererville",postal_code => 46375,region => "Indiana",region_abbr => "IN",street_1 => "827 Main Street",street_2 => undef}
{city => "South Bend",postal_code => 46637,region => "Indiana",region_abbr => "IN",street_1 => "1835 S. Bend Avenue",street_2 => undef}
{city => "South Bend",postal_code => 46637,region => "Indiana",region_abbr => "IN",street_1 => "402 N. Dixie Way",street_2 => undef}
{city => "South Bend",postal_code => 46637,region => "Indiana",region_abbr => "IN",street_1 => "115 Dixie Way North",street_2 => undef}
{city => "Valparaiso",postal_code => 46383,region => "Indiana",region_abbr => "IN",street_1 => "55 W Monroe St.",street_2 => undef}
{city => "Valparaiso",postal_code => 46383,region => "Indiana",region_abbr => "IN",street_1 => "71 Silhavy Rd Rte 2",street_2 => undef}
{city => "Valparaiso",postal_code => 46383,region => "Indiana",region_abbr => "IN",street_1 => "24 N. Washington St.",street_2 => undef}
{city => "West Lafayette",postal_code => 47906,region => "Indiana",region_abbr => "IN",street_1 => "208 South Street",street_2 => "Suite A"}
{city => "Anderson",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2623 Nichol Ave.",street_2 => undef}
{city => "Anderson",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1203 E. 53rd St.",street_2 => undef}
{city => "Anderson",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1222 Meridian St.",street_2 => undef}
{city => "Anderson",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1320 Meridian St.",street_2 => undef}
{city => "Avon",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "7840 E. US Hwy. 36",street_2 => undef}
{city => "Berne",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "906 N. US Hwy. 27",street_2 => undef}
{city => "bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "316 E. 4th Street",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "401 N. Morton St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "402 E. 4th St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "211 S. Grant",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3261 W. 3rd St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "206 N. Walnut St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "316 W. 6th St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "221 E. Kirkwood Ave. #D",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "514 E. Kirkwood Ave.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1809 E. 10th St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1795 E. 10th St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "412 E. 6th St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "S. 106 E. 2nd St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2611 E. 3rd St.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1305 S. College Mall Rd.",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "100 E. Kirkwood Ave.",street_2 => undef}
{city => "Bluffton",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "915 N. Main St.",street_2 => undef}
{city => "Bristow",postal_code => 47515,region => "Indiana",region_abbr => "IN",street_1 => "23112 Cattail Road",street_2 => undef}
{city => "Carmel",postal_code => 46032,region => "Indiana",region_abbr => "IN",street_1 => "14598 Clay Terrace Blvd.",street_2 => undef}
{city => "Carmel",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "19 E. 126th St.",street_2 => undef}
{city => "Carmel",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "14598 Clay Terrace Blvd.",street_2 => undef}
{city => "Clarksville",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "415 E. Riverside Drive",street_2 => undef}
{city => "Columbus",postal_code => 47201,region => "Indiana",region_abbr => "IN",street_1 => "1629 North National Road",street_2 => undef}
{city => "Crown Point",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "201 N. Main St.",street_2 => undef}
{city => "Crown Point",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "5124 Pine Island Ct.",street_2 => undef}
{city => "Evansville",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "600 SE 2nd St.",street_2 => undef}
{city => "Fishers",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "11021 Allisonville Rd.",street_2 => undef}
{city => "Fort Wayne",postal_code => "46808-3250",region => "Indiana",region_abbr => "IN",street_1 => "1612 Sherman Blvd.",street_2 => undef}
{city => "Fort Wayne",postal_code => 46804,region => "Indiana",region_abbr => "IN",street_1 => "4150 W. Jefferson Blvd.",street_2 => "# K-1"}
{city => "Fort Wayne",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3515 N. Anthony Blvd.",street_2 => undef}
{city => "Fort Wayne",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "504 Noble Dr.",street_2 => undef}
{city => "Granger",postal_code => 46530,region => "Indiana",region_abbr => "IN",street_1 => "303 Florence Ave.",street_2 => undef}
{city => "Hammond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "7034 Indianapolis Blvd.",street_2 => undef}
{city => "Indianapolis",postal_code => 46240,region => "Indiana",region_abbr => "IN",street_1 => "1300 E. 86TH St",street_2 => undef}
{city => "Indianapolis",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => undef,street_2 => undef}
{city => "Indianapolis",postal_code => 96230,region => "Indiana",region_abbr => "IN",street_1 => " P.O. Box 30083",street_2 => undef}
{city => "Indianapolis",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "6350 Guilford Ave.",street_2 => undef}
{city => "Indianapolis",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "4213 Lafayette Rd.",street_2 => undef}
{city => "Indianapolis",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3605 Commercial Dr.",street_2 => undef}
{city => "Indianapolis",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1043 Broad Ripple Ave.",street_2 => undef}
{city => "Indianapolis",postal_code => 46220,region => "Indiana",region_abbr => "IN",street_1 => "842 East 65th Street",street_2 => undef}
{city => "Jasper",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "323 S US Highway 231",street_2 => undef}
{city => "Jasper",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1102 Newton St.",street_2 => undef}
{city => "Knox",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1307 S. Heaton St.",street_2 => undef}
{city => "Kokomo",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3717 S. Reed Rd. (US 31 S.)",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "213 E. State St.",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2400 Yeager Road W.",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3500 State Road 38 E. #105",street_2 => undef}
{city => "Merrillville",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "761 E. 81st Ave.",street_2 => undef}
{city => "Mishawaka",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "228 W. Edison Rd.",street_2 => undef}
{city => "Mishawaka",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3618 Grape Rd.",street_2 => undef}
{city => "Muncie",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1625 W. University Avenue",street_2 => undef}
{city => "Muncie",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2401 N. Tillotson Ave.",street_2 => undef}
{city => "Muncie",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "125 E. Main St.",street_2 => undef}
{city => "New Albany",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "3003 Charlestown Crossing Way",street_2 => undef}
{city => "Newburgh",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2700 SR 261 (at 66/261)",street_2 => undef}
{city => "Portage",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "5830 US Highway 6",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2404 National Rd. W.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "211 S. 5th St.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "416 N. 10th St.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "4712 National Rd. E.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "4710 National Rd. E.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "175 Fort Wayne Ave.",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1601 Chester Blvd.",street_2 => undef}
{city => "Richmond",postal_code => 47374,region => "Indiana",region_abbr => "IN",street_1 => "701 National Road West",street_2 => undef}
{city => "Richmond",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "931 E. Main St.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "229 S. Michigan St.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1636 N. Ironwood Dr.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1631 Edison Rd.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2104 Edison Rd.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "208 W. Colfax Ave.",street_2 => undef}
{city => "South Bend",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "1105 Northside Blvd.",street_2 => undef}
{city => "Terre Haute",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "669 Wabash Ave.",street_2 => undef}
{city => "Union City",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "350 W. Deerfield Rd.",street_2 => undef}
{city => "Valparaiso",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "2904 Calumet Ave.",street_2 => undef}
{city => "Valparaiso",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "607 E. Lincolnway",street_2 => undef}
{city => "West Lafayette",postal_code => undef,region => "Indiana",region_abbr => "IN",street_1 => "500 W. Sagamore Pkwy. (US 52)",street_2 => undef}
{city => "West Lafayette",postal_code => 47906,region => "Indiana",region_abbr => "IN",street_1 => "200 South Street",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "2810 West Street",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "1404 South Duff Ave",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "2616 Northridge Pkwy",street_2 => undef}
{city => "Ames",postal_code => 50010,region => "Iowa",region_abbr => "IA",street_1 => "1614 South Kellogg Ave #101",street_2 => undef}
{city => "Ames",postal_code => 50014,region => "Iowa",region_abbr => "IA",street_1 => "2402 Lincoln Way",street_2 => undef}
{city => "Cedar Falls",postal_code => 50613,region => "Iowa",region_abbr => "IA",street_1 => "618 Brandilynn Blvd,",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52403,region => "Iowa",region_abbr => "IA",street_1 => "4700 Tama Street",street_2 => "Suite 600"}
{city => "Cedar Rapids",postal_code => 52402,region => "Iowa",region_abbr => "IA",street_1 => "540 Boyson Rd NE",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52403,region => "Iowa",region_abbr => "IA",street_1 => "3531 Mount Vernon Rd SE",street_2 => undef}
{city => "Cedar Rapids",postal_code => 52402,region => "Iowa",region_abbr => "IA",street_1 => "5504 Blairs Forest Way NE",street_2 => undef}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "222 1st Ave",street_2 => undef}
{city => "Coralville",postal_code => undef,region => "Iowa",region_abbr => "IA",street_1 => "413 10th Ave",street_2 => undef}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "1101 2nd St.",street_2 => undef}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "204 2nd Street",street_2 => undef}
{city => "Coralville",postal_code => 52241,region => "Iowa",region_abbr => "IA",street_1 => "1451 Coral Ridge Ave",street_2 => "Coralridge Mall Food Court"}
{city => "Dakota City",postal_code => 50529,region => "Iowa",region_abbr => "IA",street_1 => "PO Box 250",street_2 => undef}
{city => "Davenport",postal_code => undef,region => "Iowa",region_abbr => "IA",street_1 => "1600 Harrison St.",street_2 => undef}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "1301 Locust St.",street_2 => "Suite D"}
{city => "Des Moines",postal_code => 50309,region => "Iowa",region_abbr => "IA",street_1 => "1511 High St.",street_2 => undef}
{city => "Des Moines",postal_code => 50316,region => "Iowa",region_abbr => "IA",street_1 => "1234 E Euclid Ave",street_2 => undef}
{city => "Iowa City",postal_code => 52245,region => "Iowa",region_abbr => "IA",street_1 => "117 N. Linn St.",street_2 => undef}
{city => "Iowa City",postal_code => 52240,region => "Iowa",region_abbr => "IA",street_1 => "630 Iowa Ave.",street_2 => undef}
{city => "Iowa City",postal_code => 52245,region => "Iowa",region_abbr => "IA",street_1 => "327 East Market Street",street_2 => undef}
{city => "Iowa City",postal_code => "52240-1832",region => "Iowa",region_abbr => "IA",street_1 => "521 E. Washington St.",street_2 => undef}
{city => "Iowa City",postal_code => "52240-3912",region => "Iowa",region_abbr => "IA",street_1 => "32 S. Clinton",street_2 => undef}
{city => "Iowa City",postal_code => "52240-3902",region => "Iowa",region_abbr => "IA",street_1 => "9 S. Dubuque St.",street_2 => undef}
{city => "Iowa City",postal_code => 52240,region => "Iowa",region_abbr => "IA",street_1 => "227 E. Washington St",street_2 => undef}
{city => "Iowa City",postal_code => "52245-2149",region => "Iowa",region_abbr => "IA",street_1 => "214 N. Linn St",street_2 => undef}
{city => "Iowa City",postal_code => "52240-4506",region => "Iowa",region_abbr => "IA",street_1 => "1210 S. Gilbert St.",street_2 => undef}
{city => "Iowa City",postal_code => undef,region => "Iowa",region_abbr => "IA",street_1 => "517 Riverside Dr.",street_2 => undef}
{city => "Iowa City",postal_code => "52240-1821",region => "Iowa",region_abbr => "IA",street_1 => "22 S. Van Buren St",street_2 => undef}
{city => "Iowa City",postal_code => 52246,region => "Iowa",region_abbr => "IA",street_1 => "749 Mormon Trek Boulevard",street_2 => undef}
{city => "Iowa City",postal_code => 52240,region => "Iowa",region_abbr => "IA",street_1 => "345 S. Dubuque Street",street_2 => undef}
{city => "Iowa City",postal_code => "52246-5614",region => "Iowa",region_abbr => "IA",street_1 => "965 S. Riverside Dr.",street_2 => undef}
{city => "Iowa City",postal_code => "52240-1671",region => "Iowa",region_abbr => "IA",street_1 => "340 E. Burlington St.",street_2 => undef}
{city => "Marion",postal_code => 52302,region => "Iowa",region_abbr => "IA",street_1 => "2665 Edgewood Parkway SW",street_2 => undef}
{city => "Mason City",postal_code => 50401,region => "Iowa",region_abbr => "IA",street_1 => undef,street_2 => " 1631 4th St SW #126"}
{city => "Mason City",postal_code => 50401,region => "Iowa",region_abbr => "IA",street_1 => "5 South Federal Ave",street_2 => undef}
{city => "Orange City",postal_code => 51041,region => "Iowa",region_abbr => "IA",street_1 => "814 Lincoln PL SE",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "724 Massachusetts",street_2 => undef}
{city => "Lawrence",postal_code => 66046,region => "Kansas",region_abbr => "KS",street_1 => "1819 W 23rd Street",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "1011 S Massachusetts St",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "907 Massachusetts",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "1021 S Massachusetts St",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "911 S Massachusetts St",street_2 => undef}
{city => "Mission",postal_code => 66205,region => "Kansas",region_abbr => "KS",street_1 => "5101 Johnson Dr",street_2 => undef}
{city => "Overland Park",postal_code => 66212,region => "Kansas",region_abbr => "KS",street_1 => "7401 West 91st Street",street_2 => undef}
{city => "Overland Park",postal_code => 66212,region => "Kansas",region_abbr => "KS",street_1 => "9036 Metcalf Ave",street_2 => undef}
{city => "Overland Park",postal_code => 66209,region => "Kansas",region_abbr => "KS",street_1 => "6621 W. 119th St",street_2 => undef}
{city => "Topeka",postal_code => 66606,region => "Kansas",region_abbr => "KS",street_1 => "1423 SW 6th Ave",street_2 => undef}
{city => "Topeka",postal_code => 66614,region => "Kansas",region_abbr => "KS",street_1 => "5301 SW 21st St",street_2 => undef}
{city => "Topeka",postal_code => 66614,region => "Kansas",region_abbr => "KS",street_1 => "1025 SW Wanamaker Road",street_2 => undef}
{city => "Topeka",postal_code => 66604,region => "Kansas",region_abbr => "KS",street_1 => "4025 SW 10th Avenue",street_2 => "Fleming Place"}
{city => "Topeka",postal_code => 66614,region => "Kansas",region_abbr => "KS",street_1 => "5954 SW 29th Street",street_2 => undef}
{city => "Topeka",postal_code => 66615,region => "Kansas",region_abbr => "KS",street_1 => "6130 SW 6th",street_2 => undef}
{city => "Topeka",postal_code => 66603,region => "Kansas",region_abbr => "KS",street_1 => "511 S.W. Topeka Blvd",street_2 => undef}
{city => "Topeka",postal_code => 66606,region => "Kansas",region_abbr => "KS",street_1 => "738 SW Gage Blvd",street_2 => undef}
{city => "Topeka",postal_code => 66615,region => "Kansas",region_abbr => "KS",street_1 => "6121 SW 12th",street_2 => undef}
{city => "Topeka",postal_code => 66614,region => "Kansas",region_abbr => "KS",street_1 => "2951 SW Wanamaker Road",street_2 => undef}
{city => "Topeka",postal_code => 66614,region => "Kansas",region_abbr => "KS",street_1 => "2913 SW 29th St",street_2 => undef}
{city => "Topeka",postal_code => 66612,region => "Kansas",region_abbr => "KS",street_1 => "117 SE 10th Street",street_2 => undef}
{city => "Topeka",postal_code => 66606,region => "Kansas",region_abbr => "KS",street_1 => "503 Washburn Ave",street_2 => undef}
{city => "Topeka",postal_code => 66604,region => "Kansas",region_abbr => "KS",street_1 => "5327 SW 21st St",street_2 => undef}
{city => "Topeka",postal_code => 66604,region => "Kansas",region_abbr => "KS",street_1 => "1507 SW 21st St",street_2 => undef}
{city => "Wichita",postal_code => 67214,region => "Kansas",region_abbr => "KS",street_1 => "1328 E. Douglas",street_2 => undef}
{city => "Waimea",postal_code => 96796,region => "Kauai, Hawaii",region_abbr => undef,street_1 => "9643 Kaumualii Hwy",street_2 => undef}
{city => "Lexington",postal_code => 40508,region => "Kentucky",region_abbr => "KY",street_1 => " 341 S Limestone",street_2 => undef}
{city => "Lexington",postal_code => 40513,region => "Kentucky",region_abbr => "KY",street_1 => "3735 Palomar Centre Dr",street_2 => undef}
{city => "Lexington",postal_code => 40503,region => "Kentucky",region_abbr => "KY",street_1 => "161 Lexington Green Circle",street_2 => undef}
{city => "Louisville",postal_code => 40207,region => "Kentucky",region_abbr => "KY",street_1 => "318 Wallace Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "1133 Bardstown Rd.",street_2 => undef}
{city => "Louisville",postal_code => 40206,region => "Kentucky",region_abbr => "KY",street_1 => "2240 Frankfort Ave.",street_2 => undef}
{city => "Louisville",postal_code => 40207,region => "Kentucky",region_abbr => "KY",street_1 => "3738 Lexington Road",street_2 => undef}
{city => "Louisville",postal_code => 40207,region => "Kentucky",region_abbr => "KY",street_1 => "4944 Shelbyville Rd",street_2 => undef}
{city => "Louisville",postal_code => 40243,region => "Kentucky",region_abbr => "KY",street_1 => "12401 Shelbyville Road",street_2 => undef}
{city => "Louisville",postal_code => 40241,region => "Kentucky",region_abbr => "KY",street_1 => "3608 Springhurst Blvd.",street_2 => undef}
{city => "Louisville",postal_code => 40205,region => "Kentucky",region_abbr => "KY",street_1 => "2204 Dundee Road",street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "947 Baxter Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40203,region => "Kentucky",region_abbr => "KY",street_1 => "422 W. Oak St.",street_2 => undef}
{city => "Louisville",postal_code => 40203,region => "Kentucky",region_abbr => "KY",street_1 => "1164 S. Third Street",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "1601 S. Third St.",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "2109 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => " 5800 Preston Highway",street_2 => undef}
{city => "Louisville",postal_code => 40203,region => "Kentucky",region_abbr => "KY",street_1 => "316 W Ormsby Ave",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "1616 Grinstead Dr",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "1293 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40207,region => "Kentucky",region_abbr => "KY",street_1 => "4600 Shelbyville Road",street_2 => undef}
{city => "Lawrence",postal_code => undef,region => "Kansas",region_abbr => "KS",street_1 => "704 Massachusetts Avenue",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "714 Vermont Street",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "1006 Massachusetts Street",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "901 Iowa St.",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "1007 Massachusetts St.",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "904 Vermont Street",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "125 E. 10th St.",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "814 Massachusetts Street",street_2 => undef}
{city => "Lawrence",postal_code => undef,region => "Kansas",region_abbr => "KS",street_1 => "947 Massachusetts Avenue",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "803 Massachusetts Street",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "803 Massachusetts St",street_2 => undef}
{city => "Lawrence",postal_code => 66044,region => "Kansas",region_abbr => "KS",street_1 => "623 Vermont St.",street_2 => undef}
{city => "Leawood",postal_code => 66224,region => "Kansas",region_abbr => "KS",street_1 => "4800 W. 135th St",street_2 => "Suite 250"}
{city => "Leawood",postal_code => 66211,region => "Kansas",region_abbr => "KS",street_1 => "11563 Ash Street",street_2 => undef}
{city => "Lenexa",postal_code => 66215,region => "Kansas",region_abbr => "KS",street_1 => "12815 W. 87th Street Pkwy",street_2 => undef}
{city => "Lenexa",postal_code => 66215,region => "Kansas",region_abbr => "KS",street_1 => "12275 W 87th Parkway",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "1219 Moro Street",street_2 => undef}
{city => "Manhattan",postal_code => 66503,region => "Kansas",region_abbr => "KS",street_1 => "3003 Anderson Ave",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "1030 Colorado St",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "1131 Moro St",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "606 N. Manhattan Avenue",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "1120 Laramie St",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "523 S. 17th St.",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "Manhattan Town Center Mall",street_2 => undef}
{city => "Manhattan",postal_code => 66502,region => "Kansas",region_abbr => "KS",street_1 => "718 N Manhattan Avenue",street_2 => undef}
{city => "Overland Park",postal_code => 66204,region => "Kansas",region_abbr => "KS",street_1 => "7417 B Metcalf Avenue",street_2 => "#B"}
{city => "Overland Park",postal_code => 66210,region => "Kansas",region_abbr => "KS",street_1 => "11168 Antioch Road",street_2 => undef}
{city => "Topeka",postal_code => 66603,region => "Kansas",region_abbr => "KS",street_1 => "110 SE 8th St.",street_2 => undef}
{city => "Topeka",postal_code => 66611,region => "Kansas",region_abbr => "KS",street_1 => "2949 S Kansas Ave.",street_2 => undef}
{city => "Topeka",postal_code => 66604,region => "Kansas",region_abbr => "KS",street_1 => "4025 SW 10th Avenue",street_2 => "Fleming Place"}
{city => "Topeka",postal_code => 66604,region => "Kansas",region_abbr => "KS",street_1 => "5900 SW Huntoon Rd.",street_2 => undef}
{city => "Wichita",postal_code => 67208,region => "Kansas",region_abbr => "KS",street_1 => "6249 E 21st St N",street_2 => undef}
{city => "Wichita",postal_code => 67203,region => "Kansas",region_abbr => "KS",street_1 => "8141 East 21st N.",street_2 => undef}
{city => "Wichita",postal_code => 67213,region => "Kansas",region_abbr => "KS",street_1 => "613 W. Douglas Avenue",street_2 => undef}
{city => "Wichita",postal_code => 67213,region => "Kansas",region_abbr => "KS",street_1 => "1812 S. Seneca St",street_2 => "Suite 100"}
{city => "Wichita",postal_code => 67206,region => "Kansas",region_abbr => "KS",street_1 => "6546 E Central Avenue",street_2 => undef}
{city => "Wichita",postal_code => 67218,region => "Kansas",region_abbr => "KS",street_1 => "5600 E Lincoln St",street_2 => undef}
{city => "Wichita",postal_code => 67208,region => "Kansas",region_abbr => "KS",street_1 => "6140 E 21st St N",street_2 => undef}
{city => "Wichita",postal_code => 67226,region => "Kansas",region_abbr => "KS",street_1 => "3101 N. Rock Road",street_2 => undef}
{city => "Wichita",postal_code => 67207,region => "Kansas",region_abbr => "KS",street_1 => "335 S. Towne East Mall Dr.",street_2 => undef}
{city => "Wichita",postal_code => 67214,region => "Kansas",region_abbr => "KS",street_1 => "1720 E. Douglas Avenue",street_2 => undef}
{city => "Wichita",postal_code => 67206,region => "Kansas",region_abbr => "KS",street_1 => "1551 North Rock Road",street_2 => "Genesis Health Club"}
{city => "Wichita",postal_code => 67220,region => "Kansas",region_abbr => "KS",street_1 => "6254 E. 37th Sreet N.",street_2 => "#180"}
{city => "Wichita",postal_code => 67206,region => "Kansas",region_abbr => "KS",street_1 => "2035 North Rock Rd.",street_2 => undef}
{city => "Wichita",postal_code => 67208,region => "Kansas",region_abbr => "KS",street_1 => "4811 E. Central Avenue",street_2 => undef}
{city => "Hopkinsville",postal_code => 42240,region => "Kentucky",region_abbr => "KY",street_1 => "4000 Fort Campbell Blvd",street_2 => "Bradford Square"}
{city => "Lexington",postal_code => 40509,region => "Kentucky",region_abbr => "KY",street_1 => "3090 Old Todds Road",street_2 => undef}
{city => "Lexington",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => undef,street_2 => undef}
{city => "Lexington",postal_code => 40507,region => "Kentucky",region_abbr => "KY",street_1 => "141 E. Main St.",street_2 => undef}
{city => "Lexington",postal_code => 40156,region => "Kentucky",region_abbr => "KY",street_1 => "4595 Bryan Station Road",street_2 => undef}
{city => "Lexington",postal_code => 40508,region => "Kentucky",region_abbr => "KY",street_1 => "319 South Limestone Street",street_2 => undef}
{city => "Lexington",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "1080 S. Broadway Road",street_2 => undef}
{city => "Lexington",postal_code => 40507,region => "Kentucky",region_abbr => "KY",street_1 => "257 N. Limestone Street",street_2 => undef}
{city => "Lexington",postal_code => 40507,region => "Kentucky",region_abbr => "KY",street_1 => "112 Esplanade",street_2 => undef}
{city => "Lexington",postal_code => 40503,region => "Kentucky",region_abbr => "KY",street_1 => "455 Southland Drive",street_2 => undef}
{city => "Louisville",postal_code => 40206,region => "Kentucky",region_abbr => "KY",street_1 => "2246 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => undef,street_2 => undef}
{city => "Louisville",postal_code => 40205,region => "Kentucky",region_abbr => "KY",street_1 => "1578 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "921 Swan Street",street_2 => undef}
{city => "Louisville",postal_code => 40205,region => "Kentucky",region_abbr => "KY",street_1 => "2116 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40207,region => "Kentucky",region_abbr => "KY",street_1 => "112 Meridian Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40206,region => "Kentucky",region_abbr => "KY",street_1 => "1722 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40202,region => "Kentucky",region_abbr => "KY",street_1 => "641 S. 4th Street",street_2 => undef}
{city => "Louisville",postal_code => 40205,region => "Kentucky",region_abbr => "KY",street_1 => "2011 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40222,region => "Kentucky",region_abbr => "KY",street_1 => "2210 Holiday Manor",street_2 => "Suite 1"}
{city => "Louisville",postal_code => 40222,region => "Kentucky",region_abbr => "KY",street_1 => "205 N Hurstbourne Parkway",street_2 => undef}
{city => "Louisville",postal_code => 40245,region => "Kentucky",region_abbr => "KY",street_1 => "153 S English Station Road",street_2 => undef}
{city => "Louisville",postal_code => 40214,region => "Kentucky",region_abbr => "KY",street_1 => "5339 Mitscher Avenue",street_2 => "Iroquois Manor Shopping Center"}
{city => "Louisville",postal_code => 40214,region => "Kentucky",region_abbr => "KY",street_1 => "5019 S. 3rd Street",street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "1314 Bardstown Rd.",street_2 => undef}
{city => "Louisville",postal_code => 40205,region => "Kentucky",region_abbr => "KY",street_1 => "1574 1/2 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40206,region => "Kentucky",region_abbr => "KY",street_1 => "2716 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "1019 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40202,region => "Kentucky",region_abbr => "KY",street_1 => "120 S. 1st Street",street_2 => undef}
{city => "Louisville",postal_code => 40218,region => "Kentucky",region_abbr => "KY",street_1 => "4742 Bardstown Road",street_2 => undef}
{city => "Louisville",postal_code => 40206,region => "Kentucky",region_abbr => "KY",street_1 => "1804 Frankfort Avenue",street_2 => undef}
{city => "Louisville",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => undef,street_2 => undef}
{city => "Louisville",postal_code => 40204,region => "Kentucky",region_abbr => "KY",street_1 => "1126 Bardstown Road",street_2 => undef}
{city => "Newport",postal_code => undef,region => "Kentucky",region_abbr => "KY",street_1 => "738 York Street",street_2 => undef}
{city => "Abita Springs",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "72011 Holly St.",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "2857 Perkins Road",street_2 => undef}
{city => "Baton Rouge",postal_code => 70810,region => "Louisiana",region_abbr => "LA",street_1 => "7711 Perkins Road",street_2 => undef}
{city => "Baton Rouge",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "14111 Airline Highway",street_2 => undef}
{city => "Baton Rouge",postal_code => 70809,region => "Louisiana",region_abbr => "LA",street_1 => "5230 Essen Lane",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "4321 Perkins Road",street_2 => undef}
{city => "Baton Rouge",postal_code => 70802,region => "Louisiana",region_abbr => "LA",street_1 => "504 N. Fifth Street",street_2 => undef}
{city => "Baton Rouge",postal_code => 70815,region => "Louisiana",region_abbr => "LA",street_1 => "9414 Florida Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70809,region => "Louisiana",region_abbr => "LA",street_1 => "7529 Corporate Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70873,region => "Louisiana",region_abbr => "LA",street_1 => "5160 S. Sherwood Forest Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70873,region => "Louisiana",region_abbr => "LA",street_1 => "1295 N. Sherwood Forest Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70815,region => "Louisiana",region_abbr => "LA",street_1 => "11990 Florida Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "4335 Perkins Road",street_2 => undef}
{city => "Baton Rouge",postal_code => 70806,region => "Louisiana",region_abbr => "LA",street_1 => "5958 Florida Blvd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "2919 Perkins Rd",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "2561 Citiplace Court",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "2531 Citiplace Ct",street_2 => undef}
{city => "Baton Rouge",postal_code => 70808,region => "Louisiana",region_abbr => "LA",street_1 => "4250 Burbank Drive",street_2 => undef}
{city => "Covington",postal_code => 70433,region => "Louisiana",region_abbr => "LA",street_1 => "234 Lee Ln",street_2 => undef}
{city => "Lafayette",postal_code => 70506,region => "Louisiana",region_abbr => "LA",street_1 => "505 Bertrand Drive",street_2 => undef}
{city => "Lafayette",postal_code => 70503,region => "Louisiana",region_abbr => "LA",street_1 => "326 Travis St",street_2 => undef}
{city => "Mandeville",postal_code => 70471,region => "Louisiana",region_abbr => "LA",street_1 => "4350 Highway 22",street_2 => undef}
{city => "Mandeville",postal_code => 70471,region => "Louisiana",region_abbr => "LA",street_1 => "1703 North Causeway Blvd.",street_2 => "Suite A"}
{city => "Mandeville",postal_code => 70471,region => "Louisiana",region_abbr => "LA",street_1 => "3510 Highway 190",street_2 => undef}
{city => "Mandeville",postal_code => 70448,region => "Louisiana",region_abbr => "LA",street_1 => "821 Girod Street",street_2 => undef}
{city => "Metairie",postal_code => 70005,region => "Louisiana",region_abbr => "LA",street_1 => "923 Metairie Rd",street_2 => "Suite C"}
{city => "New Orleans",postal_code => 70130,region => "Louisiana",region_abbr => "LA",street_1 => "2018 Magazine Street",street_2 => undef}
{city => "New Orleans",postal_code => 70119,region => "Louisiana",region_abbr => "LA",street_1 => "4724 S. Carrollton Ave.",street_2 => undef}
{city => "New Orleans",postal_code => 70118,region => "Louisiana",region_abbr => "LA",street_1 => "8433 Oak Street",street_2 => undef}
{city => "New Orleans",postal_code => 70130,region => "Louisiana",region_abbr => "LA",street_1 => "1418 Magazine Street",street_2 => undef}
{city => "New Orleans",postal_code => 70130,region => "Louisiana",region_abbr => "LA",street_1 => "527 Julia Street",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "435 Esplanade Avenue",street_2 => undef}
{city => "New Orleans",postal_code => 70119,region => "Louisiana",region_abbr => "LA",street_1 => "3133 Ponce de Leon St.",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "3322 Magazine St",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "517 Frenchmen St.",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "4807 Magazine Street",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "1141 Decatur Street",street_2 => undef}
{city => "New Orleans",postal_code => 70112,region => "Louisiana",region_abbr => "LA",street_1 => "220 S. Robertson Street",street_2 => undef}
{city => "New Orleans",postal_code => 70113,region => "Louisiana",region_abbr => "LA",street_1 => "833 Howard Avenue",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "1212 Royal St,reet",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "634 Frenchmen Street",street_2 => undef}
{city => "New Orleans",postal_code => 70130,region => "Louisiana",region_abbr => "LA",street_1 => "1601 St. Charles Avenue",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "504 Frenchman St",street_2 => undef}
{city => "New Orleans",postal_code => 70130,region => "Louisiana",region_abbr => "LA",street_1 => "400 Iberville Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "4308 Magazine St",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "801 Royal St",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "6307 S. Miro Street",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "437 Esplanade Ave",street_2 => undef}
{city => "New Orleans",postal_code => 70118,region => "Louisiana",region_abbr => "LA",street_1 => "8210 Oak Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "4807 Magazine St",street_2 => undef}
{city => "New Orleans",postal_code => 70118,region => "Louisiana",region_abbr => "LA",street_1 => "937 Leonidas Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "5800 Magazine Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "4332 Magazine St.",street_2 => undef}
{city => "New Orleans",postal_code => 70116,region => "Louisiana",region_abbr => "LA",street_1 => "625 St. Philip Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "3635 Prytania Street",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "407 Brook Avenue",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "2208 Kaliste Saloom",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "607 kaliste saloom",street_2 => undef}
{city => "Lafayette",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "3809 Ambassador Caffery",street_2 => "135C"}
{city => "Metairie",postal_code => 70002,region => "Louisiana",region_abbr => "LA",street_1 => "3420 Veterans Blvd",street_2 => undef}
{city => "New Orleans",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "204 Decatur St",street_2 => undef}
{city => "New Orleans",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "300 Poydras St",street_2 => undef}
{city => "New Orleans",postal_code => undef,region => "Louisiana",region_abbr => "LA",street_1 => "144 Bourbon Street",street_2 => undef}
{city => "New Orleans",postal_code => 70115,region => "Louisiana",region_abbr => "LA",street_1 => "5600 Magazine Street",street_2 => undef}
{city => "Adams",postal_code => "01220",region => "Massachusetts",region_abbr => "MA",street_1 => "27 Park Street",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "155 Brighton Ave",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "477 Cambridge Street",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "5 N. Beacon Street",street_2 => undef}
{city => "Amesbury",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "13 Friend Street",street_2 => undef}
{city => "Amherst",postal_code => "01002",region => "Massachusetts",region_abbr => "MA",street_1 => "197 N. Pleasant St.",street_2 => undef}
{city => "Amherst",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "17 Kellogg Ave.",street_2 => undef}
{city => "Amherst",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "39 S. Pleasant Street",street_2 => undef}
{city => "Amherst",postal_code => "01002",region => "Massachusetts",region_abbr => "MA",street_1 => "61 Main Street",street_2 => undef}
{city => "Amherst",postal_code => "01002",region => "Massachusetts",region_abbr => "MA",street_1 => "63 Main Street",street_2 => undef}
{city => "Arlington",postal_code => "02474",region => "Massachusetts",region_abbr => "MA",street_1 => "916 Massachusetts Avenue",street_2 => undef}
{city => "Arlington",postal_code => "02474",region => "Massachusetts",region_abbr => "MA",street_1 => "352 Massachusetts Ave",street_2 => undef}
{city => "Ashland",postal_code => "01721",region => "Massachusetts",region_abbr => "MA",street_1 => "59 Pond Street",street_2 => undef}
{city => "Beverly",postal_code => "01915",region => "Massachusetts",region_abbr => "MA",street_1 => "294 Cabot St.",street_2 => undef}
{city => "Boston",postal_code => "02113",region => "Massachusetts",region_abbr => "MA",street_1 => "69 Prince Street",street_2 => undef}
{city => "Boston",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "27 Brattle Street",street_2 => undef}
{city => "Boston",postal_code => "02215",region => "Massachusetts",region_abbr => "MA",street_1 => "1095 Commonwealth Avenue",street_2 => undef}
{city => "Boston",postal_code => "02110",region => "Massachusetts",region_abbr => "MA",street_1 => "250 Franklin St.",street_2 => undef}
{city => "Boston",postal_code => "02118",region => "Massachusetts",region_abbr => "MA",street_1 => "647 Tremont St.",street_2 => undef}
{city => "Boston",postal_code => "02118",region => "Massachusetts",region_abbr => "MA",street_1 => "1145 Washington St",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "587 Boylston Street",street_2 => undef}
{city => "Boston",postal_code => "02115",region => "Massachusetts",region_abbr => "MA",street_1 => "407 Newbury St.",street_2 => undef}
{city => "Boston",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "334B Massachusetts Ave.",street_2 => undef}
{city => "Boston",postal_code => "02111",region => "Massachusetts",region_abbr => "MA",street_1 => "3 Beach Street",street_2 => "2nd Floor"}
{city => "Boston",postal_code => "02115",region => "Massachusetts",region_abbr => "MA",street_1 => "338 Newbury Street",street_2 => undef}
{city => "Boston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "487 Cambridge Street",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "279 Newbury Street",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "254 Newbury Street",street_2 => undef}
{city => "Boston",postal_code => "02118",region => "Massachusetts",region_abbr => "MA",street_1 => "578 Tremont Street",street_2 => undef}
{city => "Bridgewater",postal_code => "02324",region => "Massachusetts",region_abbr => "MA",street_1 => "14 Summer St.",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "54 JFK Street",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "134 Hampshire St.",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "Zero Brattle Street",street_2 => undef}
{city => "Cambridge",postal_code => "02142",region => "Massachusetts",region_abbr => "MA",street_1 => "Carleton St.",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "1 Kendall Square",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "765 Mass Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "581 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02140",region => "Massachusetts",region_abbr => "MA",street_1 => "1771 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "52 Brattle Street",street_2 => undef}
{city => "Chatham",postal_code => "02633",region => "Massachusetts",region_abbr => "MA",street_1 => "1218 Main St",street_2 => undef}
{city => "Dartmouth",postal_code => "02747",region => "Massachusetts",region_abbr => "MA",street_1 => "387 State Road",street_2 => undef}
{city => "Dennis",postal_code => "02638",region => "Massachusetts",region_abbr => "MA",street_1 => "780 Main St.",street_2 => undef}
{city => "Dennis Port",postal_code => "02639",region => "Massachusetts",region_abbr => "MA",street_1 => "640 Main St",street_2 => undef}
{city => "Dorchester",postal_code => "02124",region => "Massachusetts",region_abbr => "MA",street_1 => "1739 Dorchester Avenue",street_2 => undef}
{city => "Eastham",postal_code => "02642",region => "Massachusetts",region_abbr => "MA",street_1 => "4550 State Hwy",street_2 => undef}
{city => "Florence",postal_code => "01062",region => "Massachusetts",region_abbr => "MA",street_1 => "22 Chestnut St.",street_2 => undef}
{city => "Great Barrington",postal_code => "01230",region => "Massachusetts",region_abbr => "MA",street_1 => "403 Stockbridge Road",street_2 => undef}
{city => "Great Barrington",postal_code => "01230",region => "Massachusetts",region_abbr => "MA",street_1 => "286 Main Street",street_2 => undef}
{city => "Great Barrington",postal_code => "01230",region => "Massachusetts",region_abbr => "MA",street_1 => "405 Stockbridge Rd.",street_2 => undef}
{city => "Great Barrington",postal_code => "01230",region => "Massachusetts",region_abbr => "MA",street_1 => "42 Bridge Street",street_2 => undef}
{city => "Hadley",postal_code => "01035",region => "Massachusetts",region_abbr => "MA",street_1 => "375 Russell Street (Route 9)",street_2 => undef}
{city => "Hadley",postal_code => "01035",region => "Massachusetts",region_abbr => "MA",street_1 => "48 Russell St",street_2 => undef}
{city => "Hadley",postal_code => "01035",region => "Massachusetts",region_abbr => "MA",street_1 => "99 Russell Street",street_2 => undef}
{city => "Holyoke",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "50 Holyoke Street",street_2 => undef}
{city => "Hyannis",postal_code => "02601",region => "Massachusetts",region_abbr => "MA",street_1 => "59 Center St",street_2 => undef}
{city => "Hyannis",postal_code => "02601",region => "Massachusetts",region_abbr => "MA",street_1 => "790 Iyannough Road",street_2 => undef}
{city => "Jamaica Plain",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "66 Boylston St.",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "763 Centre St.",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "36 South Street",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "701 Centre Street",street_2 => undef}
{city => "Lancaster",postal_code => "01523",region => "Massachusetts",region_abbr => "MA",street_1 => "679 George Hill Road",street_2 => undef}
{city => "Longmeadow",postal_code => "01106",region => "Massachusetts",region_abbr => "MA",street_1 => "696 Bliss Rd.",street_2 => undef}
{city => "Malden",postal_code => "02148",region => "Massachusetts",region_abbr => "MA",street_1 => "264 Washington Street",street_2 => undef}
{city => "Nantucket",postal_code => "02554",region => "Massachusetts",region_abbr => "MA",street_1 => "29 Centre Street",street_2 => undef}
{city => "Nantucket",postal_code => "02554",region => "Massachusetts",region_abbr => "MA",street_1 => "14 Amelia Drive",street_2 => undef}
{city => "Nantucket",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "12 Broad Street",street_2 => undef}
{city => "New Bedford",postal_code => "02740",region => "Massachusetts",region_abbr => "MA",street_1 => "813 Purchase St # 805",street_2 => undef}
{city => "New Bedford",postal_code => "02740",region => "Massachusetts",region_abbr => "MA",street_1 => "141 Union St.",street_2 => undef}
{city => "Newburyport",postal_code => "01950",region => "Massachusetts",region_abbr => "MA",street_1 => "50 Water Street",street_2 => undef}
{city => "Newburyport",postal_code => "01950",region => "Massachusetts",region_abbr => "MA",street_1 => "25 State St.",street_2 => undef}
{city => "Newburyport",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "334 High Street",street_2 => undef}
{city => "Newburyport",postal_code => "01950",region => "Massachusetts",region_abbr => "MA",street_1 => "44 Inn Street",street_2 => undef}
{city => "Newton",postal_code => "02458",region => "Massachusetts",region_abbr => "MA",street_1 => "292 Centre Street",street_2 => undef}
{city => "North Adams",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "30 Marshall Street",street_2 => undef}
{city => "North Adams",postal_code => "01247",region => "Massachusetts",region_abbr => "MA",street_1 => "303 Ashland Streeet",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "241 Main Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "134 Main St",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "330 North King Street",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "48 Main Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "27 Pleasant Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "44 Main Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "159 Main Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "60 Masonic Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "62 State Street",street_2 => undef}
{city => "Northampton",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "150 Main Street",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "45 State Street",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "41 Main Street",street_2 => undef}
{city => "Nutting Lake",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => undef,street_2 => undef}
{city => "Pittsfield",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "239 Onota Street",street_2 => undef}
{city => "Plymouth",postal_code => "02360",region => "Massachusetts",region_abbr => "MA",street_1 => "56 Main St",street_2 => undef}
{city => "Plymouth",postal_code => "02360",region => "Massachusetts",region_abbr => "MA",street_1 => "44 Long Pond Rd.",street_2 => undef}
{city => "Salem",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "196 Essex St",street_2 => undef}
{city => "Somerville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "378 Highland Avenue",street_2 => "Davis Square"}
{city => "Somerville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "195 Elm St",street_2 => undef}
{city => "Somerville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "1153 Broadway",street_2 => undef}
{city => "Somverville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "246 Elm Street",street_2 => undef}
{city => "Wareham",postal_code => "02571",region => "Massachusetts",region_abbr => "MA",street_1 => "2421 Cranberry Highway",street_2 => undef}
{city => "Watertown",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "627 Mount Auburn St.",street_2 => undef}
{city => "Webster",postal_code => "01570",region => "Massachusetts",region_abbr => "MA",street_1 => "201 Main Street",street_2 => undef}
{city => "Wellesley",postal_code => "02481",region => "Massachusetts",region_abbr => "MA",street_1 => "272 Washington St.",street_2 => undef}
{city => "Worcester",postal_code => "01603",region => "Massachusetts",region_abbr => "MA",street_1 => "75 Maywood St.",street_2 => undef}
{city => "Worcester",postal_code => "01603",region => "Massachusetts",region_abbr => "MA",street_1 => "229  Canterbury Street",street_2 => undef}
{city => "Worcester",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "1394 Main St.",street_2 => undef}
{city => "Worcester",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "372 Chandler St.",street_2 => undef}
{city => "Worcester",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "800 Main St.",street_2 => undef}
{city => "Worcester",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "362 Chandler St.",street_2 => undef}
{city => "Worcester",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "107 Highland St.",street_2 => undef}
{city => "Worcester",postal_code => "01608",region => "Massachusetts",region_abbr => "MA",street_1 => "157 Belmont St",street_2 => undef}
{city => "Worchester",postal_code => "01604",region => "Massachusetts",region_abbr => "MA",street_1 => "56 Hamilton Street",street_2 => undef}
{city => "Worchester",postal_code => "01602",region => "Massachusetts",region_abbr => "MA",street_1 => "415 Chandler St.",street_2 => undef}
{city => "Bangor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "23 Hammond St.",street_2 => undef}
{city => "Bangor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "128 Main Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "15 Cottage St",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "39 Rodick St",street_2 => undef}
{city => "Belfast",postal_code => "04915",region => "Maine",region_abbr => "ME",street_1 => "123 High Street",street_2 => undef}
{city => "Bethel",postal_code => "04217",region => "Maine",region_abbr => "ME",street_1 => "141 Main Street",street_2 => undef}
{city => "Cape Neddick",postal_code => "03902",region => "Maine",region_abbr => "ME",street_1 => "1400 US Route 1",street_2 => undef}
{city => "Cape Neddick",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "1594 US Route 1",street_2 => undef}
{city => "Kennebunkport",postal_code => "04046",region => "Maine",region_abbr => "ME",street_1 => "2 Dock Square",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "463 Stevens Avenue",street_2 => undef}
{city => "Portland",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "482 Congress St.",street_2 => undef}
{city => "Portland",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "671 Congress St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "78 Middle St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "1 Danforth St",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "2 Somerset St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "87 Marginal Way",street_2 => undef}
{city => "Annapolis",postal_code => 21401,region => "Maryland",region_abbr => "MD",street_1 => "160 Jennifer Rd # F",street_2 => undef}
{city => "Annapolis",postal_code => 21401,region => "Maryland",region_abbr => "MD",street_1 => "\n\n2641 Riva Road",street_2 => undef}
{city => "Annapolis",postal_code => 21401,region => "Maryland",region_abbr => "MD",street_1 => "169 West St",street_2 => undef}
{city => "Annapolis",postal_code => 21401,region => "Maryland",region_abbr => "MD",street_1 => "2504 Solomons Island Road",street_2 => undef}
{city => "Annapolis",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "2478 Solomons Island Road",street_2 => "Annapolis Harbour Center"}
{city => "Annapolis",postal_code => 21401,region => "Maryland",region_abbr => "MD",street_1 => "112A Annapolis Street",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "800 St. Paul Street",street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "827 N. Howard St.",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => undef,street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "806 North Charles Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1100 Maryland Ave.",street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "1425 Aliceanna Street",street_2 => undef}
{city => "Baltimore",postal_code => 21215,region => "Maryland",region_abbr => "MD",street_1 => "6313 Reisterstown Road",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "800 South Broadway",street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "1703 Aliceanna Street",street_2 => undef}
{city => "Baltimore",postal_code => 21210,region => "Maryland",region_abbr => "MD",street_1 => "100 West University Parkway",street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "1626 Aliceanna Street",street_2 => undef}
{city => "Baltimore",postal_code => 21286,region => "Maryland",region_abbr => "MD",street_1 => "4 1/2 East Pennsylvania Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "28 West Susquehanna Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21218,region => "Maryland",region_abbr => "MD",street_1 => "227 West 29th Street",street_2 => undef}
{city => "Baltimore",postal_code => 21209,region => "Maryland",region_abbr => "MD",street_1 => "1330 Smith Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "1001 Fleet Street",street_2 => "Suite A"}
{city => "Baltimore",postal_code => 21218,region => "Maryland",region_abbr => "MD",street_1 => "2433 St. Paul Street",street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "811 South Broadway",street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "1724 N. Charles St.",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "11 West Preston Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "823 North Charles Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "5216 Park Heights Ave.",street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "1730 N. Charles Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => undef,street_2 => undef}
{city => "Baltimore",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "3 West Chesapeake Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "1621 Fleet Street",street_2 => undef}
{city => "Baltimore",postal_code => 21218,region => "Maryland",region_abbr => "MD",street_1 => "3101 St. Paul Street",street_2 => undef}
{city => "Baltimore",postal_code => 21210,region => "Maryland",region_abbr => "MD",street_1 => "501 West Cold Spring Lane",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "3327 St. Paul Street",street_2 => undef}
{city => "Bethesda",postal_code => 20816,region => "Maryland",region_abbr => "MD",street_1 => "5269 River Road",street_2 => undef}
{city => "Bowie",postal_code => 20715,region => "Maryland",region_abbr => "MD",street_1 => "8619 Chestnut Avenue",street_2 => undef}
{city => "Clarksville",postal_code => 21029,region => "Maryland",region_abbr => "MD",street_1 => "5805 Clarksville Square Dr.",street_2 => undef}
{city => "Clarksville",postal_code => 21029,region => "Maryland",region_abbr => "MD",street_1 => "5809 Clarksville Square Dr.",street_2 => undef}
{city => "College Park",postal_code => 20741,region => "Maryland",region_abbr => "MD",street_1 => "P.O.Box 717",street_2 => undef}
{city => "College Park",postal_code => 20740,region => "Maryland",region_abbr => "MD",street_1 => "5010 Berwyn Road",street_2 => undef}
{city => "Ellicott City",postal_code => 21043,region => "Maryland",region_abbr => "MD",street_1 => "8198 Main Street",street_2 => undef}
{city => "Frederick",postal_code => 21701,region => "Maryland",region_abbr => "MD",street_1 => "45 N. Market St.",street_2 => undef}
{city => "Frederick",postal_code => 21701,region => "Maryland",region_abbr => "MD",street_1 => "4 East Patrick Street",street_2 => undef}
{city => "Frederick",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "228 North Market Street",street_2 => undef}
{city => "Frederick",postal_code => 21701,region => "Maryland",region_abbr => "MD",street_1 => "9 East Patrick Street",street_2 => undef}
{city => "Frederick",postal_code => 21703,region => "Maryland",region_abbr => "MD",street_1 => "5273 Buckeystwon Pike",street_2 => undef}
{city => "Frederick",postal_code => 21704,region => "Maryland",region_abbr => "MD",street_1 => "5728 Buckeystown Pike Unit 1-B",street_2 => undef}
{city => "Gaithersburg",postal_code => 20878,region => "Maryland",region_abbr => "MD",street_1 => "177 Kentlands Boulevard, Suite 100",street_2 => undef}
{city => "Gaithersburg",postal_code => 20879,region => "Maryland",region_abbr => "MD",street_1 => "18509 N Frederick Avenue",street_2 => undef}
{city => "Gaithersburg",postal_code => 20878,region => "Maryland",region_abbr => "MD",street_1 => "316 Kentlands Blvd.",street_2 => undef}
{city => "Gaithersburg",postal_code => 20878,region => "Maryland",region_abbr => "MD",street_1 => "239 Muddy Branch Road",street_2 => undef}
{city => "Gaithersburg",postal_code => 20878,region => "Maryland",region_abbr => "MD",street_1 => "74 Bureau Dr.",street_2 => undef}
{city => "Germantown",postal_code => 20874,region => "Maryland",region_abbr => "MD",street_1 => "19833 Century Blvd.",street_2 => undef}
{city => "Glen Burnie",postal_code => 21061,region => "Maryland",region_abbr => "MD",street_1 => "6604 Ritchie Highway",street_2 => undef}
{city => "Hagerstown",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "55 W Oak Ridge Dr.",street_2 => undef}
{city => "Largo",postal_code => 20743,region => "Maryland",region_abbr => "MD",street_1 => "9185 Central Ave.",street_2 => undef}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "11618 Rockville Pike",street_2 => undef}
{city => "Rockville",postal_code => 20851,region => "Maryland",region_abbr => "MD",street_1 => "2381 Lewis Ave.",street_2 => undef}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "1649 Rockville Pike",street_2 => undef}
{city => "Rockville",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "798 Rockville Pike",street_2 => undef}
{city => "Silver Spring",postal_code => 20910,region => "Maryland",region_abbr => "MD",street_1 => "935 Ellsworth Drive",street_2 => undef}
{city => "Silver Spring",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "8233 Fenton St.",street_2 => undef}
{city => "Silver Spring",postal_code => 20910,region => "Maryland",region_abbr => "MD",street_1 => "833 Wayne Ave.",street_2 => undef}
{city => "Silver Spring",postal_code => " 20910",region => "Maryland",region_abbr => "MD",street_1 => "8305 Georgia Ave.",street_2 => undef}
{city => "Silver Spring",postal_code => 20910,region => "Maryland",region_abbr => "MD",street_1 => "8309 Grubb Road",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "7224 Carroll Avenue",street_2 => undef}
{city => "Takoma Park",postal_code => 20192,region => "Maryland",region_abbr => "MD",street_1 => "1329 University Blvd East",street_2 => undef}
{city => "Takoma Park",postal_code => 20783,region => "Maryland",region_abbr => "MD",street_1 => "8046 New Hampshire Ave.",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "7006 Carroll Ave.",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "201 Ethan Allen Ave.",street_2 => undef}
{city => "Towson",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "13 Allegheny Ave.",street_2 => undef}
{city => "Towson",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "Towson Town Center Mall",street_2 => "825 Dulaney Valley Road"}
{city => "Towson",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "13 Allegheny Avenue",street_2 => undef}
{city => "Towson",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "22 W Allegheny Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachuetts",region_abbr => undef,street_1 => "1120 Massachusetts Ave",street_2 => undef}
{city => "Watertown",postal_code => undef,region => "Massachuetts",region_abbr => undef,street_1 => "600 Mount Auburn St.",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "1243 Commonwealth Avenue",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "182 Brighton Ave.",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "155 Brighton Avenue",street_2 => undef}
{city => "Allston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "109 Brighton Ave.",street_2 => undef}
{city => "Amesbury",postal_code => "01913",region => "Massachusetts",region_abbr => "MA",street_1 => "11 Elm St",street_2 => undef}
{city => "Amherst",postal_code => "01003",region => "Massachusetts",region_abbr => "MA",street_1 => "41 Campus Center Way",street_2 => undef}
{city => "Andover",postal_code => "01810",region => "Massachusetts",region_abbr => "MA",street_1 => "40 Railroad St",street_2 => undef}
{city => "Arlington",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "645 Massachusetts Avenue",street_2 => undef}
{city => "Ashland",postal_code => "01721",region => "Massachusetts",region_abbr => "MA",street_1 => "59 Pond St.",street_2 => undef}
{city => "Boston",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "3 Beach Street",street_2 => undef}
{city => "Boston",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => undef,street_2 => undef}
{city => "Boston",postal_code => "02215",region => "Massachusetts",region_abbr => "MA",street_1 => " 736 Commonwealth Avenue",street_2 => undef}
{city => "Boston",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "1 N Beacon St",street_2 => undef}
{city => "Boston",postal_code => "02115",region => "Massachusetts",region_abbr => "MA",street_1 => "286 Newbury Street",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "57 Berkeley Street",street_2 => undef}
{city => "Boston",postal_code => "02115",region => "Massachusetts",region_abbr => "MA",street_1 => "15 Westland Avenue",street_2 => undef}
{city => "Boston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "15 Walbridge St.",street_2 => 34}
{city => "Boston",postal_code => "02110",region => "Massachusetts",region_abbr => "MA",street_1 => "62 Summer Street",street_2 => undef}
{city => "Boston",postal_code => "02115",region => "Massachusetts",region_abbr => "MA",street_1 => "359-369 Huntington Avenue",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "8 Park Plaza",street_2 => "#D6"}
{city => "Boston",postal_code => "02114",region => "Massachusetts",region_abbr => "MA",street_1 => "47 Charles Street",street_2 => undef}
{city => "Boston",postal_code => "02134",region => "Massachusetts",region_abbr => "MA",street_1 => "487 Cambridge St.",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "63 Stuart St.",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "205 Berkeley St.",street_2 => undef}
{city => "Boston",postal_code => "02215",region => "Massachusetts",region_abbr => "MA",street_1 => "900 Beacon Street",street_2 => undef}
{city => "Boston",postal_code => "02116",region => "Massachusetts",region_abbr => "MA",street_1 => "131 Dartmouth Street",street_2 => undef}
{city => "Boston",postal_code => "02111",region => "Massachusetts",region_abbr => "MA",street_1 => "5 Beach Street",street_2 => undef}
{city => "Brookline",postal_code => "02446",region => "Massachusetts",region_abbr => "MA",street_1 => "404 Harvard Street",street_2 => undef}
{city => "Brookline",postal_code => "02445",region => "Massachusetts",region_abbr => "MA",street_1 => "1665 Beacon Street",street_2 => undef}
{city => "Brookline",postal_code => "02445",region => "Massachusetts",region_abbr => "MA",street_1 => "6 Cypress Street",street_2 => undef}
{city => "Brookline",postal_code => "02446",region => "Massachusetts",region_abbr => "MA",street_1 => "404 Harvard Street",street_2 => undef}
{city => "Brookline",postal_code => "02446",region => "Massachusetts",region_abbr => "MA",street_1 => "324 Harvard St.",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "200 Alewife Brook Parkway",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "340 River Street",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "75 Winthrop Street",street_2 => undef}
{city => "Cambridge",postal_code => "02140",region => "Massachusetts",region_abbr => "MA",street_1 => "1755 Massachusetts Ave.",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "225 Hampshire St.",street_2 => undef}
{city => "Cambridge",postal_code => "02140",region => "Massachusetts",region_abbr => "MA",street_1 => "2067 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "148 Mount Auburn Street",street_2 => undef}
{city => "Cambridge",postal_code => "02149",region => "Massachusetts",region_abbr => "MA",street_1 => "1920 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "29 Church Street",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "18 Eliot Street",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "15 Dunster Street",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "91 Winthrop Street",street_2 => undef}
{city => "Cambridge",postal_code => "02143",region => "Massachusetts",region_abbr => "MA",street_1 => "23 Union Square",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "125 River Street",street_2 => undef}
{city => "Cambridge",postal_code => undef,region => "Massachusetts",region_abbr => "MA",street_1 => "47 Palmer Street",street_2 => undef}
{city => "Cambridge",postal_code => "02238-1071",region => "Massachusetts",region_abbr => "MA",street_1 => "PO Box 38-1071",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "704 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "950 Massachusetts Avenue",street_2 => undef}
{city => "Cambridge",postal_code => "02138",region => "Massachusetts",region_abbr => "MA",street_1 => "57 JFK St",street_2 => undef}
{city => "Cambridge",postal_code => "02139",region => "Massachusetts",region_abbr => "MA",street_1 => "581 Massachusetts Ave.",street_2 => undef}
{city => "Concord",postal_code => "01742",region => "Massachusetts",region_abbr => "MA",street_1 => "98 Commonwealth Ave",street_2 => undef}
{city => "Dorchester",postal_code => "02124",region => "Massachusetts",region_abbr => "MA",street_1 => "499 Washington Street",street_2 => undef}
{city => "Eastham",postal_code => "02642",region => "Massachusetts",region_abbr => "MA",street_1 => "182 Brackett Rd",street_2 => undef}
{city => "Florence",postal_code => "01062",region => "Massachusetts",region_abbr => "MA",street_1 => "22 Chestnut Street",street_2 => undef}
{city => "Framingham",postal_code => "01071",region => "Massachusetts",region_abbr => "MA",street_1 => "575 Worcester Rd.",street_2 => "(Rte. 9)"}
{city => "Greenfield",postal_code => "01301",region => "Massachusetts",region_abbr => "MA",street_1 => "265 Main Street",street_2 => undef}
{city => "Hadley",postal_code => "01035",region => "Massachusetts",region_abbr => "MA",street_1 => "9 Russell St.",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "605 Centre Street",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "57 South Street",street_2 => undef}
{city => "Jamaica Plain",postal_code => "02130",region => "Massachusetts",region_abbr => "MA",street_1 => "284 Armory Street",street_2 => undef}
{city => "Lexington",postal_code => "02420",region => "Massachusetts",region_abbr => "MA",street_1 => "321 Woburn Street",street_2 => "Country Side Plaza"}
{city => "Lowell",postal_code => "01851",region => "Massachusetts",region_abbr => "MA",street_1 => "1717 Middlesex Street",street_2 => undef}
{city => "Lowell",postal_code => "01852",region => "Massachusetts",region_abbr => "MA",street_1 => "194 Middle Street",street_2 => undef}
{city => "Lowell",postal_code => "01851",region => "Massachusetts",region_abbr => "MA",street_1 => "1689 Middlesex Street",street_2 => undef}
{city => "Medford",postal_code => "02155",region => "Massachusetts",region_abbr => "MA",street_1 => "2151 Mystic Valley Pkwy",street_2 => undef}
{city => "Newton",postal_code => "02461",region => "Massachusetts",region_abbr => "MA",street_1 => "916 Walnut Street",street_2 => undef}
{city => "Newton",postal_code => "02458",region => "Massachusetts",region_abbr => "MA",street_1 => "308 Watertown St.",street_2 => undef}
{city => "Newtonville",postal_code => "02458",region => "Massachusetts",region_abbr => "MA",street_1 => "647 Washington St.",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "235 Main St.",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "8 Old South Street",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "68 Masonic Street",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "185 Main Street,",street_2 => undef}
{city => "Northampton",postal_code => "01060",region => "Massachusetts",region_abbr => "MA",street_1 => "150 Main St",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "338 Commercial Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "247 Commercial Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "331 Commercial Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "209 Shore Rd",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "353 Commercial Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "322 Commercial Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "7 Freeman Street",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "5 Ryder St.",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "141 Bradford St.",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => " 303 Commercial St",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "336 Commercial St",street_2 => undef}
{city => "Provincetown",postal_code => "02657",region => "Massachusetts",region_abbr => "MA",street_1 => "336 Commercial Street",street_2 => "2nd floor"}
{city => "Saugus",postal_code => "01906",region => "Massachusetts",region_abbr => "MA",street_1 => "357 Broadway",street_2 => undef}
{city => "Shrewsbury",postal_code => "01545",region => "Massachusetts",region_abbr => "MA",street_1 => "378 Maple Avenue",street_2 => undef}
{city => "Somerville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "257 Elm St.",street_2 => "Davis Square"}
{city => "Somerville",postal_code => "02144",region => "Massachusetts",region_abbr => "MA",street_1 => "424 Highland Avenue",street_2 => undef}
{city => "South Dennis",postal_code => "02660",region => "Massachusetts",region_abbr => "MA",street_1 => "370 Main Street",street_2 => undef}
{city => "South Lancaster",postal_code => "01561",region => "Massachusetts",region_abbr => "MA",street_1 => "53 Prescott St.",street_2 => undef}
{city => "Waltham",postal_code => "02453",region => "Massachusetts",region_abbr => "MA",street_1 => "581 Moody St.",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "922 Main Street",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "912 Main Street",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "873 Main Street",street_2 => undef}
{city => "Waltham",postal_code => "02453",region => "Massachusetts",region_abbr => "MA",street_1 => "85 River Street #1",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "663 Main Street",street_2 => undef}
{city => "Waltham",postal_code => "02453",region => "Massachusetts",region_abbr => "MA",street_1 => "475 Moody Street",street_2 => undef}
{city => "Waltham",postal_code => "02453",region => "Massachusetts",region_abbr => "MA",street_1 => "458 Moody Street",street_2 => undef}
{city => "Waltham",postal_code => "02453",region => "Massachusetts",region_abbr => "MA",street_1 => "366 Moody Street",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "195 School Street",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "987 Main Street",street_2 => undef}
{city => "Waltham",postal_code => "02451",region => "Massachusetts",region_abbr => "MA",street_1 => "888 Main Street",street_2 => undef}
{city => "Wayland",postal_code => "01778",region => "Massachusetts",region_abbr => "MA",street_1 => "317 Boston Post Road",street_2 => undef}
{city => "Wellesley Hills",postal_code => "02481",region => "Massachusetts",region_abbr => "MA",street_1 => "278 Washington St.",street_2 => undef}
{city => "West Bloomfield",postal_code => 48322,region => "Massachusetts",region_abbr => "MA",street_1 => "7350 Orchard lake Road",street_2 => undef}
{city => "Worcester",postal_code => "01610",region => "Massachusetts",region_abbr => "MA",street_1 => "800 Main Street",street_2 => undef}
{city => "Worcester",postal_code => "01609",region => "Massachusetts",region_abbr => "MA",street_1 => "234 Chandler Street",street_2 => undef}
{city => "Worcester",postal_code => "01609",region => "Massachusetts",region_abbr => "MA",street_1 => "56 Hamilton St",street_2 => undef}
{city => "Worchester",postal_code => "01610",region => "Massachusetts",region_abbr => "MA",street_1 => "482 Park Avenue",street_2 => undef}
{city => "Arnold",postal_code => 21012,region => "Maryland",region_abbr => "MD",street_1 => undef,street_2 => undef}
{city => "Baltimore",postal_code => 21218,region => "Maryland",region_abbr => "MD",street_1 => "123 West 27th Street",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "645 S. President Street",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "719 S. President Street",street_2 => undef}
{city => "Baltimore",postal_code => 21212,region => "Maryland",region_abbr => "MD",street_1 => "529 E. Belvedere Ave.",street_2 => undef}
{city => "Baltimore",postal_code => 21209,region => "Maryland",region_abbr => "MD",street_1 => "1425 Clarkview Road, Suite 300",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1739 Fleet Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1606 Thames Street",street_2 => undef}
{city => "Baltimore",postal_code => 21211,region => "Maryland",region_abbr => "MD",street_1 => "1009 W. 36th St.",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "711 Eastern Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21209,region => "Maryland",region_abbr => "MD",street_1 => "4901 Springarden Drive",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => undef,street_2 => undef}
{city => "Baltimore",postal_code => 21231,region => "Maryland",region_abbr => "MD",street_1 => "2108 Eastern Ave.",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "4 E. Madison Avenue",street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "840 N. Eutaw St.",street_2 => undef}
{city => "Baltimore",postal_code => 21223,region => "Maryland",region_abbr => "MD",street_1 => "31 S. Arlington Ave",street_2 => undef}
{city => "Baltimore",postal_code => 21202,region => "Maryland",region_abbr => "MD",street_1 => "E. Pleasant St. and N. Holliday St.",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1407 Fleet Street",street_2 => undef}
{city => "Baltimore",postal_code => 21211,region => "Maryland",region_abbr => "MD",street_1 => "3360 Chestnut Ave.",street_2 => undef}
{city => "Baltimore",postal_code => 21201,region => "Maryland",region_abbr => "MD",street_1 => "11 W. Preston St.",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1105 W 36th St",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "911 West 36th Street",street_2 => undef}
{city => "Baltimore",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "1002 W. 36th St.",street_2 => undef}
{city => "Bethesda",postal_code => 20814,region => "Maryland",region_abbr => "MD",street_1 => "7141 Arlington Road",street_2 => undef}
{city => "Burtonsville",postal_code => 20866,region => "Maryland",region_abbr => "MD",street_1 => "15739 Columbia Pike",street_2 => undef}
{city => "Capitol Heights",postal_code => 20743,region => "Maryland",region_abbr => "MD",street_1 => "9185 Central Avenue",street_2 => undef}
{city => "Catonsville",postal_code => 21228,region => "Maryland",region_abbr => "MD",street_1 => "1701 Edmondson Avenue",street_2 => undef}
{city => "Chevy Chase",postal_code => 20815,region => "Maryland",region_abbr => "MD",street_1 => "6831 Wisconsin Ave",street_2 => undef}
{city => "College Park",postal_code => 20740,region => "Maryland",region_abbr => "MD",street_1 => "9827 Rhode Island Ave",street_2 => undef}
{city => "College Park",postal_code => 20740,region => "Maryland",region_abbr => "MD",street_1 => "9078 Baltimore Avenue",street_2 => undef}
{city => "College Park",postal_code => 20740,region => "Maryland",region_abbr => "MD",street_1 => "8503 Baltimore Avenue",street_2 => undef}
{city => "College Park",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "Campus Drive and Union Lane",street_2 => undef}
{city => "Columbia",postal_code => 21044,region => "Maryland",region_abbr => "MD",street_1 => "5430 Lynx Lane",street_2 => undef}
{city => "Columbia",postal_code => 21045,region => "Maryland",region_abbr => "MD",street_1 => "8775 Centre Park Drive",street_2 => undef}
{city => "Columbia",postal_code => 21044,region => "Maryland",region_abbr => "MD",street_1 => "10451 Twin Rivers Road",street_2 => undef}
{city => "Columbia",postal_code => 21045,region => "Maryland",region_abbr => "MD",street_1 => "6365 Dobbin Rd.",street_2 => "Suite B"}
{city => "Gaithersburg",postal_code => 20877,region => "Maryland",region_abbr => "MD",street_1 => "405 North Frederick Avenue",street_2 => undef}
{city => "Gaithersburg",postal_code => 20879,region => "Maryland",region_abbr => "MD",street_1 => "8405 Snouffer School Rd",street_2 => undef}
{city => "Gaithersburg",postal_code => 20879,region => "Maryland",region_abbr => "MD",street_1 => "18212 Flower Hill Way",street_2 => undef}
{city => "Glen Burnie",postal_code => 21061,region => "Maryland",region_abbr => "MD",street_1 => "7477 Baltimore Annapolis Boulevard",street_2 => undef}
{city => "Greenbelt",postal_code => 20770,region => "Maryland",region_abbr => "MD",street_1 => "131 Centerway",street_2 => undef}
{city => "Greenbelt",postal_code => 20770,region => "Maryland",region_abbr => "MD",street_1 => "113 Centerway",street_2 => undef}
{city => "Greenbelt",postal_code => 20770,region => "Maryland",region_abbr => "MD",street_1 => "8825 Greenbelt Road",street_2 => undef}
{city => "Hagerstown",postal_code => 21740,region => "Maryland",region_abbr => "MD",street_1 => "2 West Washington Street",street_2 => undef}
{city => "Laurel",postal_code => 20723,region => "Maryland",region_abbr => "MD",street_1 => "11200 Scaggsville Road",street_2 => undef}
{city => "Mt. Rainer",postal_code => 20712,region => "Maryland",region_abbr => "MD",street_1 => "4009 34th Street",street_2 => undef}
{city => "Olney",postal_code => 20832,region => "Maryland",region_abbr => "MD",street_1 => "18169 Town Center Drive",street_2 => undef}
{city => "Olney",postal_code => 20832,region => "Maryland",region_abbr => "MD",street_1 => "3409 Morningwood Drive",street_2 => undef}
{city => "Olney",postal_code => 20832,region => "Maryland",region_abbr => "MD",street_1 => "2000 Olney-Sandy Spring Rd",street_2 => undef}
{city => "Olney",postal_code => 20833,region => "Maryland",region_abbr => "MD",street_1 => "18035 Georgia Avenue",street_2 => undef}
{city => "Owings Mills",postal_code => 21117,region => "Maryland",region_abbr => "MD",street_1 => "10210 S. Dolfield Road",street_2 => undef}
{city => "Pikesville",postal_code => 21208,region => "Maryland",region_abbr => "MD",street_1 => "1000 Reisterstown Rd.",street_2 => undef}
{city => "Rockville",postal_code => 80250,region => "Maryland",region_abbr => "MD",street_1 => "101 Gibbs Street",street_2 => undef}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "1488-C Rockville Pike",street_2 => undef}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "765-G Rockville Pike",street_2 => undef}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "11417 Woodglen Drive",street_2 => undef}
{city => "Rockville",postal_code => 20850,region => "Maryland",region_abbr => "MD",street_1 => "20 Maryland Ave.",street_2 => "Rockville Town Square"}
{city => "Rockville",postal_code => 20852,region => "Maryland",region_abbr => "MD",street_1 => "11711 B Parklawn Drive",street_2 => undef}
{city => "Salisbury",postal_code => 21804,region => "Maryland",region_abbr => "MD",street_1 => "701D East Naylor Mill Rd",street_2 => undef}
{city => "St. Michaels",postal_code => 21663,region => "Maryland",region_abbr => "MD",street_1 => "409 South Talbot Street",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "6939 Laurel Avenue",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "7006 Carroll Avenue",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "7006 Carroll Avenue",street_2 => undef}
{city => "Takoma Park",postal_code => 20912,region => "Maryland",region_abbr => "MD",street_1 => "7071 Carroll Ave.",street_2 => undef}
{city => "Temple Hill",postal_code => 20748,region => "Maryland",region_abbr => "MD",street_1 => "3227 Brinkley Road",street_2 => undef}
{city => "Towson",postal_code => undef,region => "Maryland",region_abbr => "MD",street_1 => "510 York Rd",street_2 => undef}
{city => "Towson",postal_code => 21204,region => "Maryland",region_abbr => "MD",street_1 => "798 Kenilworth Drive",street_2 => undef}
{city => "Bangor",postal_code => "04401",region => "Maine",region_abbr => "ME",street_1 => "621 Hammond St",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609-1717",region => "Maine",region_abbr => "ME",street_1 => "14 1/2 Mount Desert Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "130 Cottage Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "33 Kennebec Pl",street_2 => undef}
{city => "Bar Harbor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "116 Cottage Street",street_2 => undef}
{city => "Bar Harbor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "16 Mount Desert Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "16 Mt. Desert St",street_2 => "Across from the Park"}
{city => "Bar Harbor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "150 Main Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "122 Cottage St",street_2 => undef}
{city => "Bar Harbor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "34 Kennebec Place",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "101 Cottage Street",street_2 => undef}
{city => "Bar Harbor",postal_code => "04609",region => "Maine",region_abbr => "ME",street_1 => "78 West St",street_2 => undef}
{city => "Bar Harbor",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "194 Main Street",street_2 => undef}
{city => "Belfast",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => "96 Main Street",street_2 => undef}
{city => "Brunswick",postal_code => "04011",region => "Maine",region_abbr => "ME",street_1 => "329 Maine Street",street_2 => undef}
{city => "Brunswick",postal_code => "04011",region => "Maine",region_abbr => "ME",street_1 => "149 Maine Street",street_2 => "Tontine Mall"}
{city => "Falmouth",postal_code => "04105",region => "Maine",region_abbr => "ME",street_1 => "204 US Route 1",street_2 => undef}
{city => "Falmouth",postal_code => "04105",region => "Maine",region_abbr => "ME",street_1 => "240 US Route 1",street_2 => undef}
{city => "Norway",postal_code => "04268",region => "Maine",region_abbr => "ME",street_1 => "238 Main St",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "649 Congress St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "608 Congress St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "40 Washington Avenue",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "83 Exchange St.",street_2 => undef}
{city => "Portland",postal_code => undef,region => "Maine",region_abbr => "ME",street_1 => undef,street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "5 Moulton St.",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "28 Monument Square",street_2 => "Public Market House"}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "51 Oak Street",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "101 York Street",street_2 => undef}
{city => "Portland",postal_code => "04101",region => "Maine",region_abbr => "ME",street_1 => "437 Congress St.",street_2 => undef}
{city => "Rockland",postal_code => "04841",region => "Maine",region_abbr => "ME",street_1 => "148 Main St.",street_2 => undef}
{city => "Rockland",postal_code => "04841",region => "Maine",region_abbr => "ME",street_1 => "385 Main Street",street_2 => undef}
{city => "Rockland",postal_code => "04841",region => "Maine",region_abbr => "ME",street_1 => "218 Main Street",street_2 => undef}
{city => "Rockland",postal_code => "04856",region => "Maine",region_abbr => "ME",street_1 => "5 Country Way",street_2 => undef}
{city => "Rockland",postal_code => "04841",region => "Maine",region_abbr => "ME",street_1 => "15 Oak Street",street_2 => undef}
{city => "Rockport",postal_code => "04856",region => "Maine",region_abbr => "ME",street_1 => "Route 90 and Cross Street",street_2 => undef}
{city => "Searsport",postal_code => "04974",region => "Maine",region_abbr => "ME",street_1 => "5 Elm Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "311 S. 5th Ave",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "3275 Washtenaw Avenue",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "108 S. Main St.",street_2 => undef}
{city => "Ann Arbor",postal_code => 48108,region => "Michigan",region_abbr => "MI",street_1 => "4584 Washtenaw Ave.",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "326 Maynard St",street_2 => undef}
{city => "Ann Arbor",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "2370 Carpenter Rd.",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "1917 Washtenaw Avenue",street_2 => undef}
{city => "Ann Arbor",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "328 Maynard Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "116 E. Liberty Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "200 South Main Street",street_2 => undef}
{city => "Auburn Hills",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "2065 N. Squirrel Rd.",street_2 => undef}
{city => "Auburn Hills",postal_code => 48326,region => "Michigan",region_abbr => "MI",street_1 => "3395 Auburn Rd.",street_2 => undef}
{city => "Bay City",postal_code => 48708,region => "Michigan",region_abbr => "MI",street_1 => "205 3rd Street",street_2 => undef}
{city => "Berkley",postal_code => 48072,region => "Michigan",region_abbr => "MI",street_1 => "3249 Twelve Mile Road",street_2 => undef}
{city => "Berkley",postal_code => 48072,region => "Michigan",region_abbr => "MI",street_1 => "2688 Coolidge Highway",street_2 => undef}
{city => "Berrien Springs",postal_code => 49104,region => "Michigan",region_abbr => "MI",street_1 => "Andrews University Student Center",street_2 => undef}
{city => "Berrien Springs",postal_code => 49104,region => "Michigan",region_abbr => "MI",street_1 => "Andrews University Student Center",street_2 => undef}
{city => "Berrien Springs",postal_code => 49103,region => "Michigan",region_abbr => "MI",street_1 => "9067 US 31",street_2 => "Apple Valley Plaza"}
{city => "Berrien Springs",postal_code => 49103,region => "Michigan",region_abbr => "MI",street_1 => "9187 US-31",street_2 => undef}
{city => "Berrien Springs",postal_code => 49103,region => "Michigan",region_abbr => "MI",street_1 => "9067 Old U.S. 31",street_2 => undef}
{city => "Birmingham",postal_code => 48009,region => "Michigan",region_abbr => "MI",street_1 => "136 N. Old Woodward Avenue",street_2 => undef}
{city => "Canton",postal_code => 48187,region => "Michigan",region_abbr => "MI",street_1 => "45490 Ford Road",street_2 => undef}
{city => "Clinton Township",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "15750 Hall Rd.",street_2 => undef}
{city => "Dearborn",postal_code => 48126,region => "Michigan",region_abbr => "MI",street_1 => "13944 Michigan Ave.",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "422 W. Willis Street",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "418 W. Willis St.",street_2 => undef}
{city => "Detroit",postal_code => 48208,region => "Michigan",region_abbr => "MI",street_1 => "5169 Trumbull St.",street_2 => undef}
{city => "Detroit",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "660 Woodward Avenue",street_2 => undef}
{city => "Detroit",postal_code => 48215,region => "Michigan",region_abbr => "MI",street_1 => "383 Lenox Ave.",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "4160 Woodward Ave",street_2 => "First Floor"}
{city => "Detroit",postal_code => 48226,region => "Michigan",region_abbr => "MI",street_1 => "2 John R Street",street_2 => undef}
{city => "Detroit",postal_code => 48202,region => "Michigan",region_abbr => "MI",street_1 => "15 E. Kirby Street",street_2 => "Suite 115"}
{city => "Detroit",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "Cass Avenue",street_2 => undef}
{city => "Detroit",postal_code => 48226,region => "Michigan",region_abbr => "MI",street_1 => "500 Griswold Ave.",street_2 => "Suite 100"}
{city => "Detroit",postal_code => 48207,region => "Michigan",region_abbr => "MI",street_1 => "1434 Gratiot Avenue",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "4620 Cass Ave",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "4421 Woodward Avenue",street_2 => undef}
{city => "Detroit",postal_code => 48207,region => "Michigan",region_abbr => "MI",street_1 => "2465 Russell Street",street_2 => undef}
{city => "East Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "219 East Grand River Ave",street_2 => undef}
{city => "East Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "211 Mac Avenue",street_2 => undef}
{city => "Elwell",postal_code => 48832,region => "Michigan",region_abbr => "MI",street_1 => "8911 Ferris Rd.",street_2 => undef}
{city => "Farmington",postal_code => 48335,region => "Michigan",region_abbr => "MI",street_1 => "35203 Grand River Ave.",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "22950 Woodward Avenue",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "214 W. Nine Mile Road",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "221 W. 9 Mile Rd",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "240 W. Nine Mile Road",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "545 W. Nine Mile Road",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "23341 Woodward Ave.",street_2 => undef}
{city => "Flint",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "G3316 Miller Rd",street_2 => "Yorkshire Plaza"}
{city => "Garden City",postal_code => 48135,region => "Michigan",region_abbr => "MI",street_1 => "28636 Ford Road",street_2 => undef}
{city => "Glen Arbor",postal_code => 49636,region => "Michigan",region_abbr => "MI",street_1 => "6298 Western Avenue",street_2 => undef}
{city => "Grand Haven",postal_code => 49417,region => "Michigan",region_abbr => "MI",street_1 => "700 Washington Avenue",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "600 Monroe Avenue NW",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "962 Cherry Street",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "53 Commerce Ave.",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "421 Norwood Avenue SE",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "209 Diamond Avenue SE",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "1001 Lake Dr SE",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "834 Cherry Street SE",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "38 Fulton Street West",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "40 Monroe Center",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "1450 Wealthy Street SE",street_2 => undef}
{city => "Iron Mountain",postal_code => 49801,region => "Michigan",region_abbr => "MI",street_1 => "700 River Ave,",street_2 => undef}
{city => "Kalamazoo",postal_code => 49007,region => "Michigan",region_abbr => "MI",street_1 => "323 North Burdick Street",street_2 => undef}
{city => "Kalamazoo",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => undef,street_2 => undef}
{city => "Kalamazoo",postal_code => 49007,region => "Michigan",region_abbr => "MI",street_1 => "436 S. Burdick St.",street_2 => undef}
{city => "Kalamazoo",postal_code => 49008,region => "Michigan",region_abbr => "MI",street_1 => "2965 Oakland Drive",street_2 => undef}
{city => "Kalamazoo",postal_code => 49007,region => "Michigan",region_abbr => "MI",street_1 => "312 W. Michigan Ave.",street_2 => undef}
{city => "Kalamazoo",postal_code => 49009,region => "Michigan",region_abbr => "MI",street_1 => "5192 W. Michigan Ave.",street_2 => undef}
{city => "Kalamazoo",postal_code => 49006,region => "Michigan",region_abbr => "MI",street_1 => "2913 Howard St.",street_2 => undef}
{city => "Kalamazoo",postal_code => 49007,region => "Michigan",region_abbr => "MI",street_1 => "355 E Kalamazoo Ave",street_2 => undef}
{city => "Lansing",postal_code => 48906,region => "Michigan",region_abbr => "MI",street_1 => "226 East Grand River Avenue",street_2 => undef}
{city => "Lansing",postal_code => 48906,region => "Michigan",region_abbr => "MI",street_1 => "1224 Turner Street",street_2 => undef}
{city => "Lansing",postal_code => 48910,region => "Michigan",region_abbr => "MI",street_1 => "123 E. Kalamazoo St.",street_2 => undef}
{city => "Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "211 E Grand River Ave",street_2 => undef}
{city => "Lansing",postal_code => 48912,region => "Michigan",region_abbr => "MI",street_1 => "333 N. Cedar St.",street_2 => undef}
{city => "Lansing",postal_code => 48933,region => "Michigan",region_abbr => "MI",street_1 => "107 South Washington Square",street_2 => undef}
{city => "Lansing",postal_code => 48912,region => "Michigan",region_abbr => "MI",street_1 => "2006 E Michigan Ave",street_2 => undef}
{city => "Livonia",postal_code => 48152,region => "Michigan",region_abbr => "MI",street_1 => "37104 W. Six Mile Road",street_2 => undef}
{city => "Ludington",postal_code => 49431,region => "Michigan",region_abbr => "MI",street_1 => "110 N James Street",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "119 W. Baraga Avenue",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "1031 N Third St",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "N 3rd st.",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "4th St.",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "Washington St.",street_2 => undef}
{city => "Marquette",postal_code => 49855,region => "Michigan",region_abbr => "MI",street_1 => "227 W Washington Street",street_2 => undef}
{city => "Midland",postal_code => 48640,region => "Michigan",region_abbr => "MI",street_1 => "144 Ashman Circle",street_2 => undef}
{city => "Midland",postal_code => 48642,region => "Michigan",region_abbr => "MI",street_1 => "5010 Bay City Road",street_2 => undef}
{city => "Midland",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "721 S. Saginaw Rd.",street_2 => undef}
{city => "Mt. Pleasant",postal_code => 48858,region => "Michigan",region_abbr => "MI",street_1 => "112 N. Main Street",street_2 => undef}
{city => "Mt. Pleasant",postal_code => 48858,region => "Michigan",region_abbr => "MI",street_1 => "1620 Mission St.",street_2 => undef}
{city => "Mt. Pleasant",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "214 N. Franklin Street",street_2 => undef}
{city => "Mt. Pleasant",postal_code => 48858,region => "Michigan",region_abbr => "MI",street_1 => "2328 South Mission Street",street_2 => undef}
{city => "Muskegon",postal_code => 49441,region => "Michigan",region_abbr => "MI",street_1 => "3112 Henry St.",street_2 => undef}
{city => "Muskegon",postal_code => 49445,region => "Michigan",region_abbr => "MI",street_1 => "1519 E. River Rd.",street_2 => undef}
{city => "Niles",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "404 E. Main Street",street_2 => undef}
{city => "Northville",postal_code => 48167,region => "Michigan",region_abbr => "MI",street_1 => "116 West Main St",street_2 => undef}
{city => "Paw Paw",postal_code => 49079,region => "Michigan",region_abbr => "MI",street_1 => "101 West Michigan Avenue",street_2 => undef}
{city => "Rochester Hills",postal_code => 48306,region => "Michigan",region_abbr => "MI",street_1 => "6830 Rochester Road",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "608 S. Washington Avenue",street_2 => undef}
{city => "Royal Oak",postal_code => 48073,region => "Michigan",region_abbr => "MI",street_1 => "121 E. Thirteen Mile Rd",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "317 S. Washington Avenue",street_2 => undef}
{city => "Royal Oak",postal_code => 48962,region => "Michigan",region_abbr => "MI",street_1 => "106 S. Main Street",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "204 W. 4th Street",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "105 S Main St",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "204 W. Fourth St.",street_2 => undef}
{city => "Saginaw",postal_code => 48607,region => "Michigan",region_abbr => "MI",street_1 => "507 South Washington Avenue",street_2 => undef}
{city => "Southfield",postal_code => 48034,region => "Michigan",region_abbr => "MI",street_1 => "29410 Northwestern Hwy.",street_2 => undef}
{city => "Southfield",postal_code => 48076,region => "Michigan",region_abbr => "MI",street_1 => "29702 Southfield Road",street_2 => undef}
{city => "Traverse City",postal_code => 49684,region => "Michigan",region_abbr => "MI",street_1 => "108 S. Union St.",street_2 => undef}
{city => "Traverse City",postal_code => 49684,region => "Michigan",region_abbr => "MI",street_1 => "260 E. 10th St.",street_2 => undef}
{city => "Traverse City",postal_code => 49684,region => "Michigan",region_abbr => "MI",street_1 => "223 West Grandview Parkway",street_2 => undef}
{city => "Trenton",postal_code => 48183,region => "Michigan",region_abbr => "MI",street_1 => "2156 W. Jefferson St",street_2 => undef}
{city => "Troy",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "1063 E. Long Lake",street_2 => undef}
{city => "Troy",postal_code => 48083,region => "Michigan",region_abbr => "MI",street_1 => "1600 Rochester Rd.",street_2 => undef}
{city => "Troy",postal_code => 48085,region => "Michigan",region_abbr => "MI",street_1 => "4917 Rochester Road",street_2 => undef}
{city => "Troy",postal_code => 48084,region => "Michigan",region_abbr => "MI",street_1 => "74 W. Maple Road",street_2 => undef}
{city => "Waterford",postal_code => 48328,region => "Michigan",region_abbr => "MI",street_1 => "1325 West Huron Street",street_2 => undef}
{city => "Williamston",postal_code => 48895,region => "Michigan",region_abbr => "MI",street_1 => "132 W. Grand River Avenue",street_2 => undef}
{city => "Ypsilanti",postal_code => 48197,region => "Michigan",region_abbr => "MI",street_1 => "1785 Washtenaw Rd",street_2 => undef}
{city => "Ypsilanti",postal_code => 48197,region => "Michigan",region_abbr => "MI",street_1 => "56 E. Cross Street",street_2 => undef}
{city => "Ypsilanti",postal_code => 48198,region => "Michigan",region_abbr => "MI",street_1 => "42 E. Cross Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "221 E. Washington Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "2016 Packard Street",street_2 => undef}
{city => "Ann Arbor",postal_code => "48104-3028",region => "Michigan",region_abbr => "MI",street_1 => "611 Church St",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "312 S. State Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48109,region => "Michigan",region_abbr => "MI",street_1 => " 530 S. State Street",street_2 => "UofM Union Building,1st floor"}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "216 N 4th Ave",street_2 => undef}
{city => "Ann Arbor",postal_code => 48103,region => "Michigan",region_abbr => "MI",street_1 => "500 Miller Street",street_2 => undef}
{city => "Ann Arbor",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "1906 Packard St.",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "314 E. Liberty St.",street_2 => undef}
{city => "Ann Arbor",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "810 S. State Street",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "3135 Washtenaw Ave.",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "307 S. 5th Ave",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "214 N 4th Ave",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "216 South Fourth Ave",street_2 => undef}
{city => "Ann Arbor",postal_code => 48104,region => "Michigan",region_abbr => "MI",street_1 => "314 Detroit St",street_2 => undef}
{city => "Auburn Hills",postal_code => 48340,region => "Michigan",region_abbr => "MI",street_1 => "4248 Baldwin Ave",street_2 => "Great Lakes Mall"}
{city => "Clawson",postal_code => 48017,region => "Michigan",region_abbr => "MI",street_1 => "1 East 14 Mile Road",street_2 => undef}
{city => "Detroit",postal_code => 48201,region => "Michigan",region_abbr => "MI",street_1 => "511 W. Canfield",street_2 => undef}
{city => "Detroit",postal_code => 48216,region => "Michigan",region_abbr => "MI",street_1 => "2163 Michigan Avenue",street_2 => undef}
{city => "Detroit",postal_code => 48203,region => "Michigan",region_abbr => "MI",street_1 => "18700 Woodward",street_2 => undef}
{city => "E. Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "970 Trowbridge Rd.",street_2 => undef}
{city => "E. Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "1105 E. Grand River",street_2 => undef}
{city => "E. Lansing",postal_code => 48823,region => "Michigan",region_abbr => "MI",street_1 => "340 Albert Ave.",street_2 => undef}
{city => "East Lansing",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "403 E. Grand River Ave.",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "23136 Woodward Avenue",street_2 => undef}
{city => "Ferndale",postal_code => 48220,region => "Michigan",region_abbr => "MI",street_1 => "212 W. Nine Mile Rd",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "1017 Wealthy St SE",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "133 S Division Avenue",street_2 => undef}
{city => "Grand Rapids",postal_code => 49503,region => "Michigan",region_abbr => "MI",street_1 => "956 E Fulton St",street_2 => undef}
{city => "Grand Rapids",postal_code => 49506,region => "Michigan",region_abbr => "MI",street_1 => "1420 Lake Dr SE",street_2 => undef}
{city => "Grosse Pointe Park",postal_code => 48230,region => "Michigan",region_abbr => "MI",street_1 => "15233 Kercheval St.",street_2 => undef}
{city => "Grosse Pointe Park",postal_code => 48230,region => "Michigan",region_abbr => "MI",street_1 => "14929 Charlevoix",street_2 => undef}
{city => "Kalamazoo",postal_code => 49008,region => "Michigan",region_abbr => "MI",street_1 => "2925 S Westnedge Ave",street_2 => undef}
{city => "Kalamazoo",postal_code => 49006,region => "Michigan",region_abbr => "MI",street_1 => "1727 West Main Street",street_2 => undef}
{city => "Kalamazoo",postal_code => 49007,region => "Michigan",region_abbr => "MI",street_1 => undef,street_2 => undef}
{city => "Ludington",postal_code => 49431,region => "Michigan",region_abbr => "MI",street_1 => "106 W. Ludington Ave.",street_2 => undef}
{city => "Northville",postal_code => 48168,region => "Michigan",region_abbr => "MI",street_1 => "8946 Napier Road",street_2 => undef}
{city => "Okemos",postal_code => 48864,region => "Michigan",region_abbr => "MI",street_1 => "2138 Hamilton Rd.",street_2 => undef}
{city => "Rochester",postal_code => 48307,region => "Michigan",region_abbr => "MI",street_1 => "301 S. Main Street",street_2 => undef}
{city => "Rochester Hills",postal_code => 48309,region => "Michigan",region_abbr => "MI",street_1 => "1404 Walton Blvd.",street_2 => undef}
{city => "Royal Oak",postal_code => 48067,region => "Michigan",region_abbr => "MI",street_1 => "500 E. 4th St.",street_2 => undef}
{city => "St. Clair Shores",postal_code => 48080,region => "Michigan",region_abbr => "MI",street_1 => "22428 Greater Mack Avenue",street_2 => undef}
{city => "St. Joseph",postal_code => 49085,region => "Michigan",region_abbr => "MI",street_1 => "1332 Hilltop Rd",street_2 => "Suite A"}
{city => "Traverse City",postal_code => undef,region => "Michigan",region_abbr => "MI",street_1 => "223 W. Grandview Pkwy",street_2 => undef}
{city => "Troy",postal_code => 48084,region => "Michigan",region_abbr => "MI",street_1 => "2880 West Maple",street_2 => undef}
{city => "Wyandotte",postal_code => 48192,region => "Michigan",region_abbr => "MI",street_1 => "15143 Eureka Road",street_2 => undef}
{city => "Ypsilanti",postal_code => 48197,region => "Michigan",region_abbr => "MI",street_1 => "20 N. Washington Street",street_2 => undef}
{city => "Ypsilanti",postal_code => 48198,region => "Michigan",region_abbr => "MI",street_1 => "42 E. Cross Street",street_2 => undef}
{city => "Stillwater",postal_code => undef,region => "Minneosta",region_abbr => undef,street_1 => "1501 Stillwater Blvd.",street_2 => undef}
{city => undef,postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Anoka",postal_code => 55303,region => "Minnesota",region_abbr => "MN",street_1 => "1917 2nd Avenue South",street_2 => undef}
{city => "Apple Valley",postal_code => 55124,region => "Minnesota",region_abbr => "MN",street_1 => "7745 150TH ST W",street_2 => undef}
{city => "Bemidji",postal_code => 56601,region => "Minnesota",region_abbr => "MN",street_1 => "117 3rd Street NW",street_2 => undef}
{city => "Blomington",postal_code => 55425,region => "Minnesota",region_abbr => "MN",street_1 => "220 West Market",street_2 => "Mall of America"}
{city => "Bloomington",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "4250 West 78th Street",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "8062 Morgan Circle S.",street_2 => undef}
{city => "Bloomington",postal_code => 55420,region => "Minnesota",region_abbr => "MN",street_1 => "8341 Lyndale Avenue S.",street_2 => undef}
{city => "Bloomington",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "60 East Broadway",street_2 => "Mall of America"}
{city => "Bloomington",postal_code => 55425,region => "Minnesota",region_abbr => "MN",street_1 => "114 East Broadway",street_2 => "Mall of America"}
{city => "Bloomington",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => " 7801 Normandale Blvd.",street_2 => undef}
{city => "Bloomington",postal_code => 55420,region => "Minnesota",region_abbr => "MN",street_1 => "517 West 98th St",street_2 => undef}
{city => "Bloomington",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "60 E Broadway",street_2 => "Mall of America"}
{city => "Brainerd",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "720 Washington Street",street_2 => undef}
{city => "Brainerd",postal_code => 56401,region => "Minnesota",region_abbr => "MN",street_1 => "123 E Washington Street",street_2 => undef}
{city => "Brainerd",postal_code => 56401,region => "Minnesota",region_abbr => "MN",street_1 => "406 W Washington St",street_2 => undef}
{city => "Brainerd",postal_code => 56401,region => "Minnesota",region_abbr => "MN",street_1 => "416 7th St S",street_2 => undef}
{city => "Brainerd",postal_code => 56401,region => "Minnesota",region_abbr => "MN",street_1 => "2115 S 6th St",street_2 => undef}
{city => "Brainerd/Baxter",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Brooklyn Center",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "6056 Shingle Creek Pkwy",street_2 => undef}
{city => "Burnsville",postal_code => 55337,region => "Minnesota",region_abbr => "MN",street_1 => "13750 County Road 11",street_2 => undef}
{city => "Burnsville",postal_code => 55337,region => "Minnesota",region_abbr => "MN",street_1 => "2501 Horizon Dr",street_2 => undef}
{city => "Chanhassen",postal_code => 55317,region => "Minnesota",region_abbr => "MN",street_1 => "435 Pond Promenade",street_2 => undef}
{city => "Columbia Heights",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "4022 Central Ave NE",street_2 => undef}
{city => "Columbia Heights",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "3700 Central Avenue NE",street_2 => undef}
{city => "Coon Rapids",postal_code => 55448,region => "Minnesota",region_abbr => "MN",street_1 => "3479 River Rapids Dr NW",street_2 => undef}
{city => "Detroit Lakes",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "808 Washington Ave",street_2 => undef}
{city => "Duluth",postal_code => 55804,region => "Minnesota",region_abbr => "MN",street_1 => "5461 North Shore Drive",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "394 South Lake Avenue",street_2 => undef}
{city => "Duluth",postal_code => 55812,region => "Minnesota",region_abbr => "MN",street_1 => "1902 E 8th St.",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "319 W. Superior Street",street_2 => undef}
{city => "Duluth",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "11 East Superior Street",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "394 Lake Avenue South",street_2 => undef}
{city => "Duluth",postal_code => 55812,region => "Minnesota",region_abbr => "MN",street_1 => "2316 East 1st St",street_2 => undef}
{city => "Duluth",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "600 E Superior St",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "308 Lake Ave S.",street_2 => undef}
{city => "Eagan",postal_code => 55123,region => "Minnesota",region_abbr => "MN",street_1 => "1260 Town Centre Drive",street_2 => undef}
{city => "Eagan",postal_code => 55122,region => "Minnesota",region_abbr => "MN",street_1 => "3945 Sibley Memorial Hwy",street_2 => undef}
{city => "Eagan",postal_code => 55123,region => "Minnesota",region_abbr => "MN",street_1 => "1282 Town Centre Dr",street_2 => undef}
{city => "Eagan",postal_code => 55123,region => "Minnesota",region_abbr => "MN",street_1 => "1304 Town Centre Dr",street_2 => undef}
{city => "Eden Prairie",postal_code => 55344,region => "Minnesota",region_abbr => "MN",street_1 => "8353 Crystal View Rd",street_2 => undef}
{city => "Eden Prairie",postal_code => 55344,region => "Minnesota",region_abbr => "MN",street_1 => "8353 Crystal View Rd",street_2 => undef}
{city => "Eden Prarie",postal_code => 55344,region => "Minnesota",region_abbr => "MN",street_1 => "7733 Flying Cloud Dr.",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "2700 Southdale Center",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "6801 York Avenue South",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "6775 York Avenue South",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "3345 Hazelton Road",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "2685 Southdale Center",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "7465 France Avenue South",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "3669 Galleria",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "3460 West 70th Street",street_2 => undef}
{city => "Edina",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "3939 W. 50th St.",street_2 => undef}
{city => "Ely",postal_code => 55731,region => "Minnesota",region_abbr => "MN",street_1 => "117 N Central Ave",street_2 => undef}
{city => "Ely",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "101 N. Central Ave.",street_2 => undef}
{city => "Fridley",postal_code => 55432,region => "Minnesota",region_abbr => "MN",street_1 => "7890 NE University Ave.",street_2 => undef}
{city => "Fridley",postal_code => "55432-5153",region => "Minnesota",region_abbr => "MN",street_1 => "1051 E Moore Lake Dr E",street_2 => undef}
{city => "Golden Valley",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "701 Xenia Avenue South",street_2 => "Suite 135"}
{city => "Hastings",postal_code => 55033,region => "Minnesota",region_abbr => "MN",street_1 => "620 Ramsey Street",street_2 => undef}
{city => "Hastings",postal_code => 55033,region => "Minnesota",region_abbr => "MN",street_1 => "307 2nd. Street East",street_2 => undef}
{city => "Hastings",postal_code => 55033,region => "Minnesota",region_abbr => "MN",street_1 => "202 East 2nd Street",street_2 => undef}
{city => "Hibbing",postal_code => 55746,region => "Minnesota",region_abbr => "MN",street_1 => "531 E. Howard St.",street_2 => undef}
{city => "Hopkins",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "1206 Mainstreet",street_2 => undef}
{city => "Hopkins",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "1601 Mainstreet",street_2 => undef}
{city => "Hopkins",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "1016 Mainstreet",street_2 => undef}
{city => "Little Falls",postal_code => 56345,region => "Minnesota",region_abbr => "MN",street_1 => "116 1st Street SE",street_2 => undef}
{city => "Loretto",postal_code => 55357,region => "Minnesota",region_abbr => "MN",street_1 => "po box 1234",street_2 => undef}
{city => "Mankato",postal_code => 56001,region => "Minnesota",region_abbr => "MN",street_1 => "329 N. Riverfront Drive",street_2 => undef}
{city => "Mankato",postal_code => 56001,region => "Minnesota",region_abbr => "MN",street_1 => "1021 E Madison Ave",street_2 => undef}
{city => "Mankato",postal_code => 56001,region => "Minnesota",region_abbr => "MN",street_1 => "1600 Warren St",street_2 => "#2"}
{city => "Mankato",postal_code => 56001,region => "Minnesota",region_abbr => "MN",street_1 => "1600 Warren St",street_2 => "#1"}
{city => "Maple Grove",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => "12209 Elm Creek Blvd",street_2 => undef}
{city => "Maple Grove",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => " 12071 Elm Creek Blvd",street_2 => undef}
{city => "Maple Grove",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => "12650 Elm Creek Boulevard",street_2 => undef}
{city => "Maple Grove",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => "7384 Kirkwood Court",street_2 => undef}
{city => "Maplewood",postal_code => 55109,region => "Minnesota",region_abbr => "MN",street_1 => "3095 White Bear Ave. N",street_2 => "Chesapeake Retail Center"}
{city => "Maplewood",postal_code => "55109-2718",region => "Minnesota",region_abbr => "MN",street_1 => "2303 White Bear Ave",street_2 => undef}
{city => "Marshall",postal_code => 56258,region => "Minnesota",region_abbr => "MN",street_1 => "900 East Main Street",street_2 => undef}
{city => "Marshall",postal_code => 56258,region => "Minnesota",region_abbr => "MN",street_1 => "1221 East Main Street",street_2 => undef}
{city => "Marshall",postal_code => 56258,region => "Minnesota",region_abbr => "MN",street_1 => "405 Country Club Drive",street_2 => undef}
{city => "Marshall",postal_code => 56258,region => "Minnesota",region_abbr => "MN",street_1 => "111 Jewett Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "900 Hennepin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55417,region => "Minnesota",region_abbr => "MN",street_1 => "5554 34th Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55410,region => "Minnesota",region_abbr => "MN",street_1 => "3145 W. 44th St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3200 Lyndale Ave South",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "629 Cedar Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55421,region => "Minnesota",region_abbr => "MN",street_1 => "4920 Central Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2700 E Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "425 13th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1100 Harmon Place",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2105 Lyndale Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55410,region => "Minnesota",region_abbr => "MN",street_1 => "2813 W. 43rd St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2650 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "2150 E Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1929 S 5th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2823 E. Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2739 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3822 E Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "414 Cedar Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2653 Nicollet Ave.",street_2 => undef}
{city => "Minneapolis",postal_code => "55414-2028",region => "Minnesota",region_abbr => "MN",street_1 => "1325 4th St SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2027 E. Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "3440 Bloomington Ave",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1510 Como Avenue SE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1400 Nicollet Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2409 Lyndale Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "313 Oak St. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "324 Cedar Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "406 14th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2451 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2601 Hennepin Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2550 Nicollet Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "614 SE Washington Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1930 Hennepin Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2558 Lyndale Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2610 Lyndale Ave South",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1427 Washington Ave. S",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "300 1st Avenue North",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "316 Cedar Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "601 1st Avenue North",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "800 Nicollet Ave S",street_2 => "Suite 290"}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1501 University Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2129 E Franklin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2223 E Franklin Ave.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "Hennepin Ave and Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "616 SE Washington Ave.",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "233 Cedar Ave. S",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "212 3rd Ave N",street_2 => "Suite 210"}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1821 Riverside Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2424 Nicollet Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "800 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "229 Cedar Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2600 Hennepin Ave. S",street_2 => undef}
{city => "Minneapolis",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "3040 Excelsior Blvd",street_2 => "#104"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "821 W Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1040 Nicollet Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2917 Lyndale Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2850 26th Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "5937 Nicollet Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "428 N Washington Ave",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2528 Nicollet",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "4741 Chicago Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1518 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "2001 Riverside Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "901 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => "55404-4214",region => "Minnesota",region_abbr => "MN",street_1 => "14 W 26th St",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2751 Hennepin Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "251 1st Avenue North",street_2 => "Suite 100"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2837 Nicollet Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "119 North 4th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "3238 West Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1831 Nicollet Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "825 Nicollet Ave S",street_2 => "Suite 165"}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2707 1/2 East Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "720 Washington Avenue SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2512 Hennepin Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "4820 Chicago Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3346 Lyndale Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2713 E. Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2532 Nicollet Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => " 55414",region => "Minnesota",region_abbr => "MN",street_1 => "433 14th Ave Se",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "615 West Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2755 Hennepin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2819 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "17 E. 26th St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "2229 E 35th St.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "3060 Excelsior Blvd",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2803 East 38th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2422 Central Avenue NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3311 East 25th Street",street_2 => undef}
{city => "Minneapolis",postal_code => "55414-2581",region => "Minnesota",region_abbr => "MN",street_1 => "2124 Como Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "113 W. Grant Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "4762 Chicago Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => "Coffman Memorial Union"}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "E. Lake Street and Chicago Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2719 Nicollet Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "610 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "5554 34th Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1300 Lagoon Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "118 N. 4th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "219 19th Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55410,region => "Minnesota",region_abbr => "MN",street_1 => "2308 W 50th St",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "414 Cedar Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "5000 Penn Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3025 E. Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1450 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "641 University Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "404 S Cedar Lake Rd",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3035 S Lyndale Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3010 Lyndale Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2940 Lyndale Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3019 Minnehaha Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => "55408-1903",region => "Minnesota",region_abbr => "MN",street_1 => "1424 West 28th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "1020 East Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1600 West Lake St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "810 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2651 Lyndale Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1400 Lagoon",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "304 Oak Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2548 Hennepin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2632 Nicollet Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2916 Hennepin Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => "Room 226A, Coffman Memorial Union"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1221 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "306 East Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "412 1/2 14th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "607 W Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "831 Nicollet Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "822 W 36th St",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2513 Central Avenue NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "601 University Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "425 13th Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3009 27th Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2627 E. Franklin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "5412 Penn Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1123 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "88 S 9th St",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1410 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "3555 Chicago Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "2425 University Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "708 West 22nd Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55409,region => "Minnesota",region_abbr => "MN",street_1 => "3756 Grand Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2717 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => " 2922 Lyndale Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "418 13th Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3005 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55409,region => "Minnesota",region_abbr => "MN",street_1 => "4301 Nicollet Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Avenue",street_2 => "Suite A201"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1513 W. Lake St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2515 Nicollet Avenue",street_2 => "Suite A"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2901 Lyndale Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => "55418-4541",region => "Minnesota",region_abbr => "MN",street_1 => "1840 Central Avenue NE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "816 West 46th Street",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1501 University Avenue SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => "MN Marketplace"}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "750 South 2nd St",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "5401 Nicollet Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1320 4th St SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2819 Hennepin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "721 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "605 Cedar Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1414 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1104 Lagoon Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1500 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "4953 Penn Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2629 E. Lake St.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1111 Washington Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "2834 10th Avenue S.",street_2 => "Midtown Greenway"}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1430 Washington Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "311 East Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2608 Nicollet Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "600 W Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2515 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "200 Union Street SE",street_2 => "Floor 3"}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2401 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2551 Central Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2516 Hennepin Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3024 Hennepin Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Ave S",street_2 => "Calhoun Square"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3008 Lyndale Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2615 E Franklin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1828 Como Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1813 Riverside Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2124 Marshall Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2624 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2528 Hennepin Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2750 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "1011 Washington Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2539 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "19 5th St. NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "3060 Excelsior Blvd.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2401 E Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2200 E Franklin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2713 E Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2 E. 26th St",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3544 Grand Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "828 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "4537 Nicollet Ave S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "626 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2801 Nicollet Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2821 Nicollet Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "211 Oak St. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3025 E. Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2412 Kennedy St NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2405 Central Avenue NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "901 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1501 University Ave SE",street_2 => "Dinkydome"}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "3226 W Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3008 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "815 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1501 University Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "329 Cedar Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1401 West Lake Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "820 Marquette Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3027 Hennepin Avenue South",street_2 => undef}
{city => "Minnetonka",postal_code => 55345,region => "Minnesota",region_abbr => "MN",street_1 => "17501 Minnetonka Blvd.",street_2 => undef}
{city => "Minnetonka",postal_code => 55305,region => "Minnesota",region_abbr => "MN",street_1 => "11240 Wayzata Blvd.",street_2 => undef}
{city => "Minnetonka",postal_code => 55345,region => "Minnesota",region_abbr => "MN",street_1 => "14725 Excelsior Blvd.",street_2 => undef}
{city => "Minnetonka",postal_code => 55305,region => "Minnesota",region_abbr => "MN",street_1 => "11300 Wayzata Boulevard",street_2 => undef}
{city => "Minnetonka",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "6001 Shady Oak Road",street_2 => undef}
{city => "Minnetonka",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1816 S. Plymouth Rd.",street_2 => undef}
{city => "Montevideo",postal_code => 56265,region => "Minnesota",region_abbr => "MN",street_1 => "1409 E Hwy 7",street_2 => undef}
{city => "Moorhead",postal_code => 56560,region => "Minnesota",region_abbr => "MN",street_1 => "510 Center Avenue",street_2 => "Moorhead Center Mall"}
{city => "Moorhead",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "28 4th St N",street_2 => undef}
{city => "Morris",postal_code => 56267,region => "Minnesota",region_abbr => "MN",street_1 => "613 Atlantic Ave",street_2 => undef}
{city => "Morris",postal_code => 56267,region => "minnesota",region_abbr => "MN",street_1 => "600 e 4th st",street_2 => "UMM mail #1025"}
{city => "New Brighton",postal_code => 55112,region => "Minnesota",region_abbr => "MN",street_1 => "781 Old Highway 8 NW",street_2 => undef}
{city => "New Brighton",postal_code => 55112,region => "Minnesota",region_abbr => "MN",street_1 => "375 Silver Lake Rd NE",street_2 => "Suite B"}
{city => "Northfield",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "516 Water St. S.",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "1520 St. Olaf Ave.",street_2 => "Buntrock Commons, 3rd Floor"}
{city => "Oakdale",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "8364 3rd St N",street_2 => undef}
{city => "Osseo",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => "311 Central Ave",street_2 => undef}
{city => "Pequot Lakes",postal_code => 56472,region => "Minnesota",region_abbr => "MN",street_1 => "30945 1st Street",street_2 => undef}
{city => "Pequot Lakes",postal_code => 56472,region => "Minnesota",region_abbr => "MN",street_1 => "4464 Main Street",street_2 => undef}
{city => "Perham",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "103 East Main Street",street_2 => undef}
{city => "Plymouth",postal_code => 55441,region => "Minnesota",region_abbr => "MN",street_1 => "60 Nathan Ln N",street_2 => undef}
{city => "Plymouth",postal_code => 55441,region => "Minnesota",region_abbr => "MN",street_1 => "88 Nathan Lane N",street_2 => undef}
{city => "Richfield",postal_code => 55423,region => "Minnesota",region_abbr => "MN",street_1 => "6401 Nicollet Ave S",street_2 => undef}
{city => "Richfield",postal_code => 55423,region => "Minnesota",region_abbr => "MN",street_1 => "500 E 78th St.",street_2 => undef}
{city => "Rochester",postal_code => 55903,region => "Minnesota",region_abbr => "MN",street_1 => "PO Box 253",street_2 => undef}
{city => "Rochester",postal_code => 55906,region => "Minnesota",region_abbr => "MN",street_1 => "1413 4th St NE",street_2 => undef}
{city => "Rochester",postal_code => 55901,region => "Minnesota",region_abbr => "MN",street_1 => "1001 6th St. NW",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2401 Fairview Ave",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "1525 County Road C W",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2401 Fairview Avenue North",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2100 Snelling Avenue N.",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2720 Snelling Ave N",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2570 Cleveland Ave N.",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2100 Snelling Ave. N",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "1901 MN-36 W",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "1711 Rice St.",street_2 => undef}
{city => "Saint Louis Park",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "8028 Minnetonka Boulevard",street_2 => undef}
{city => "Saint Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "4100 Minnetonka Blvd.",street_2 => undef}
{city => "Saint Louis Park",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "7115 Cedar Lake Rd",street_2 => undef}
{city => "Saint Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "544 St Peter Street",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1328 Grand Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1278 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "448 University Avenue West",street_2 => undef}
{city => "Saint Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "128 Cleveland Ave N",street_2 => undef}
{city => "Saint Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "704 Cleveland Ave S,",street_2 => undef}
{city => "Saint Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "767 Cleveland Ave South",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1692 Grand Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1571 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "2082 Ford Pkwy",street_2 => undef}
{city => "Saint Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "29 5th St. West",street_2 => undef}
{city => "Saint Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "2034 Marshall Ave",street_2 => undef}
{city => "Saint Paul",postal_code => "55102-7706",region => "Minnesota",region_abbr => "MN",street_1 => "350 St Peter St",street_2 => "Suite 195"}
{city => "Saint Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "800 Cleveland Avenue South",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1579 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55108,region => "Minnesota",region_abbr => "MN",street_1 => "2095 Como Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "737 N Snelling Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "748 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "720 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "800 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1702 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1577 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "695 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "374 Selby Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "756 Cleveland Ave S",street_2 => undef}
{city => "Saint Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1566 University Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55107,region => "Minnesota",region_abbr => "MN",street_1 => "63 West Winifred Street",street_2 => undef}
{city => "Saint Paul",postal_code => "55114-1125",region => "Minnesota",region_abbr => "MN",street_1 => "928 Raymond Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "850 Grand Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "30 South Fairview",street_2 => undef}
{city => "Saint Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "465 Wabasha St N",street_2 => undef}
{city => "Sartell",postal_code => 56377,region => "Minnesota",region_abbr => "MN",street_1 => "1733 Pine Cone Road",street_2 => undef}
{city => "Sauk Rapids",postal_code => 56379,region => "Minnesota",region_abbr => "MN",street_1 => "31 Benton Dr. N.",street_2 => undef}
{city => "Savage",postal_code => 55378,region => "Minnesota",region_abbr => "MN",street_1 => "3989 Egan Dr",street_2 => undef}
{city => "Savage",postal_code => 55378,region => "Minnesota",region_abbr => "MN",street_1 => "4321 Egan Drive",street_2 => undef}
{city => "Shoreview",postal_code => 55126,region => "Minnesota",region_abbr => "MN",street_1 => "1075 Highway 96 W",street_2 => undef}
{city => "St Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "3336 W Division Street",street_2 => undef}
{city => "St Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "800 W St Germain St",street_2 => undef}
{city => "St Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "4712 Excelsior Blvd",street_2 => undef}
{city => "St Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1613 University Ave W",street_2 => undef}
{city => "St. Anthony",postal_code => 55421,region => "Minnesota",region_abbr => "MN",street_1 => "2700 39th Avenue NE",street_2 => undef}
{city => "St. Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "2010 8th St N",street_2 => undef}
{city => "St. Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "68 33rd Ave S",street_2 => undef}
{city => "St. Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "3959 2nd St S",street_2 => undef}
{city => "St. Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "5480 Excelsior Blvd.",street_2 => undef}
{city => "St. Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "1600 Utica Avenue S",street_2 => undef}
{city => "St. Louis Park",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "7600 W. 27th Street",street_2 => "Suite B2"}
{city => "St. Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "4500 Excelsior Blvd.",street_2 => undef}
{city => "St. Louis Park",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "8120 Minnetonka Blvd",street_2 => undef}
{city => "St. Louis Park",postal_code => 55416,region => "Minnesota",region_abbr => "MN",street_1 => "5617 Wayzata Blvd.",street_2 => undef}
{city => "St. Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "2110 Ford Pkwy",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "308 Prince St",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1440 University Avenue West",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "758 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "308 Prince Street",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "289 East 5th Street",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "976 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "400 Selby Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1106 Grand Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "10 Rosedale Shopping Center",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "849 University Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "315 University Avenue W.",street_2 => undef}
{city => "St. Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "432 University Avenue W.",street_2 => undef}
{city => "St. Paul",postal_code => 55146,region => "Minnesota",region_abbr => "MN",street_1 => "101 E. 5th Street",street_2 => "US Bank building skyway"}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1699 Selby Ave",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1183 Selby Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55108,region => "Minnesota",region_abbr => "MN",street_1 => "2017 Buford Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "394 University Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "Hamline University Campus",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1342 Thomas Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "622 Selby Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "510 Snelling Ave N",street_2 => undef}
{city => "St. Paul",postal_code => 55114,region => "Minnesota",region_abbr => "MN",street_1 => "791 Raymond Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "290 E 5th Street",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "721 Snelling Ave N",street_2 => undef}
{city => "St. Peter",postal_code => 56082,region => "Minnesota",region_abbr => "MN",street_1 => "119 W Broadway Ave",street_2 => undef}
{city => "Stillwater",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "402 South Main St.",street_2 => undef}
{city => "Stillwater",postal_code => 55082,region => "Minnesota",region_abbr => "MN",street_1 => "308 South Main Street",street_2 => undef}
{city => "Stillwater",postal_code => 55082,region => "Minnesota",region_abbr => "MN",street_1 => "221 North Main Street",street_2 => undef}
{city => "Vadnais Heights",postal_code => 55127,region => "Minnesota",region_abbr => "MN",street_1 => "1026 East Highway 96",street_2 => undef}
{city => "Vadnais Heights",postal_code => 55110,region => "Minnesota",region_abbr => "MN",street_1 => "1640 County Road E East",street_2 => undef}
{city => "Virginia",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "111 2nd Ave N",street_2 => undef}
{city => "Virginia",postal_code => 55792,region => "Minnesota",region_abbr => "MN",street_1 => "505 3rd St N",street_2 => undef}
{city => "West St. Paul",postal_code => 55118,region => "Minnesota",region_abbr => "MN",street_1 => "1304 Robert St.",street_2 => undef}
{city => "West St. Paul",postal_code => 55118,region => "Minnesota",region_abbr => "MN",street_1 => "2021 South Robert Street",street_2 => undef}
{city => "White Bear Lake",postal_code => 55110,region => "Minnesota",region_abbr => "MN",street_1 => "2186 3rd Street",street_2 => "Suite 111"}
{city => "White Bear Township",postal_code => 55127,region => "Minnesota",region_abbr => "MN",street_1 => "1190 County Road J",street_2 => "Suite 100"}
{city => "Willmar",postal_code => 56201,region => "Minnesota",region_abbr => "MN",street_1 => "1605 South 1st Street",street_2 => undef}
{city => "Willmar",postal_code => 56201,region => "Minnesota",region_abbr => "MN",street_1 => "301 2nd Street SW",street_2 => undef}
{city => "Winona",postal_code => 55987,region => "Minnesota",region_abbr => "MN",street_1 => "121 W 2nd St",street_2 => undef}
{city => "Winona",postal_code => 55987,region => "Minnesota",region_abbr => "MN",street_1 => "77 Lafayette Street",street_2 => undef}
{city => "Woodbury",postal_code => 55125,region => "Minnesota",region_abbr => "MN",street_1 => "8362 Tamarack Village",street_2 => undef}
{city => "Woodbury",postal_code => 55125,region => "Minnesota",region_abbr => "MN",street_1 => "8268 Tamarack Vlg",street_2 => undef}
{city => "Woodbury",postal_code => 55125,region => "Minnesota",region_abbr => "MN",street_1 => "8300 Tamarack Village",street_2 => "Tamarack Village"}
{city => "Woodbury",postal_code => 55129,region => "Minnesota",region_abbr => "MN",street_1 => "10150 Hudson Road",street_2 => undef}
{city => "Woodbury",postal_code => "55125-9454",region => "Minnesota",region_abbr => "MN",street_1 => "783 Radio Dr Ste 100",street_2 => undef}
{city => "Woodbury",postal_code => 55125,region => "Minnesota",region_abbr => "MN",street_1 => "8960 Hudson Road",street_2 => undef}
{city => "Ocean Springs",postal_code => 39564,region => "Mississippi",region_abbr => "MS",street_1 => "601 Washington Ave",street_2 => undef}
{city => "Brentwood",postal_code => 63144,region => "Missouri",region_abbr => "MO",street_1 => "1601 S. Brentwood Blvd.",street_2 => undef}
{city => "Chesterfield",postal_code => 63017,region => "Missouri",region_abbr => "MO",street_1 => "177 Hilltown Village Center",street_2 => undef}
{city => "Columbia",postal_code => 65201,region => "Missouri",region_abbr => "MO",street_1 => "28 S 9th St",street_2 => undef}
{city => "Crestwood",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "9846 Watson Rd.",street_2 => undef}
{city => "Creve Coeur",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "10401 Olive Blvd",street_2 => undef}
{city => "Fulton",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "511 Court St",street_2 => undef}
{city => "Fulton",postal_code => 65251,region => "Missouri",region_abbr => "MO",street_1 => "319 W. 4th St",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1809 West 39th St",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1615 W. 39th Street",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "431 Westport Rd",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "424 Westport Road",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1806 W 39th St",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "4130 Pennsylvania",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "3906 Bell",street_2 => undef}
{city => "Kansas City",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "7433 Broadway",street_2 => undef}
{city => "Kansas City",postal_code => 64154,region => "Missouri",region_abbr => "MO",street_1 => " 6003 NW Barry Rd.",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "4301 Main St",street_2 => undef}
{city => "Maryland Heights",postal_code => 63043,region => "Missouri",region_abbr => "MO",street_1 => "2286 McKelvey Road",street_2 => undef}
{city => "Saint Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "3157 S. Grand Blvd., St.",street_2 => undef}
{city => "Saint Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "6250 Delmar Blvd",street_2 => undef}
{city => "Saint Louis",postal_code => 63130,region => "Missouri",region_abbr => "MO",street_1 => "6511 Delmar Blvd.",street_2 => undef}
{city => "Saint Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "2201 Cherokee Street",street_2 => undef}
{city => "Saint Louis",postal_code => 63101,region => "Missouri",region_abbr => "MO",street_1 => "1820 Market St,",street_2 => "Saint Louis Union Station"}
{city => "Saint Louis",postal_code => 63128,region => "Missouri",region_abbr => "MO",street_1 => "4734 Sunnyview Dr.",street_2 => undef}
{city => "Saint Louis",postal_code => 63033,region => "Missouri",region_abbr => "MO",street_1 => "4005 Seven Hills Dr",street_2 => undef}
{city => "Saint Louis",postal_code => 63109,region => "Missouri",region_abbr => "MO",street_1 => "6671 Chippewa St.",street_2 => undef}
{city => "Saint Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "3210 S. Grand Blvd.",street_2 => undef}
{city => "St Louis",postal_code => 63132,region => "Missouri",region_abbr => "MO",street_1 => "10633 Page Ave",street_2 => undef}
{city => "St Louis",postal_code => 63131,region => "Missouri",region_abbr => "MO",street_1 => "2137 Barrett Station Road",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "3926 Lindell Blvd",street_2 => undef}
{city => "St. Louis",postal_code => 63110,region => "Missouri",region_abbr => "MO",street_1 => "4140 Manchester Rd.",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "3852 Lindell Blvd",street_2 => undef}
{city => "St. Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "2639 Cherokee Street",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "11 S Euclid Ave",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "4145 Manchester Road",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "3606 Arsenal",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "6654 Clayton Rd",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "6665 Olive Blvd",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "6501 Delmar Blvd",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "33 N. Sarah St.",street_2 => undef}
{city => "St. Louis",postal_code => 63124,region => "Missouri",region_abbr => "MO",street_1 => "8823 Ladue Rd",street_2 => undef}
{city => "Webster Groves",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "20 Allen Avenue",street_2 => "Suite 130"}
{city => "Albert Lea",postal_code => 56007,region => "Minnesota",region_abbr => "MN",street_1 => "112 South Broadway Avenue",street_2 => undef}
{city => "Apple Valley",postal_code => 55124,region => "Minnesota",region_abbr => "MN",street_1 => "7705 147th Street West",street_2 => undef}
{city => "Apple Valley",postal_code => 55124,region => "Minnesota",region_abbr => "MN",street_1 => "14879 Florence Trail",street_2 => undef}
{city => "Bemidji",postal_code => 56601,region => "Minnesota",region_abbr => "MN",street_1 => "523 Minnesota Avenue",street_2 => undef}
{city => "Bemidji",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Bemidji",postal_code => 56601,region => "Minnesota",region_abbr => "MN",street_1 => "1204 Paul Bunyan Dr. NW",street_2 => undef}
{city => "Bemidji",postal_code => 56601,region => "Minnesota",region_abbr => "MN",street_1 => "214 3rd St NW",street_2 => undef}
{city => "Blaine",postal_code => 55434,region => "Minnesota",region_abbr => "MN",street_1 => "12555 Ulysses St NE",street_2 => "#150"}
{city => "Bloomington",postal_code => 55431,region => "Minnesota",region_abbr => "MN",street_1 => "10602 France Avenue S.",street_2 => undef}
{city => "Bloomington",postal_code => 55420,region => "Minnesota",region_abbr => "MN",street_1 => "8405 Lyndale Avenue S",street_2 => undef}
{city => "Bloomington",postal_code => 55420,region => "Minnesota",region_abbr => "MN",street_1 => "7836 Portland Ave,S",street_2 => undef}
{city => "Bloomington",postal_code => 55420,region => "Minnesota",region_abbr => "MN",street_1 => "7837 Portland Ave South",street_2 => undef}
{city => "Buffalo",postal_code => 55313,region => "Minnesota",region_abbr => "MN",street_1 => "1004 Hwy 55 East",street_2 => undef}
{city => "Burnsville",postal_code => 55306,region => "Minnesota",region_abbr => "MN",street_1 => "14300 Burnhaven Drive",street_2 => undef}
{city => "Burnsville",postal_code => 55306,region => "Minnesota",region_abbr => "MN",street_1 => "901 County Rd 42",street_2 => undef}
{city => "Burnsville",postal_code => 55306,region => "Minnesota",region_abbr => "MN",street_1 => "1025 County Road 42 West",street_2 => undef}
{city => "Burnsville",postal_code => 55337,region => "Minnesota",region_abbr => "MN",street_1 => "12500 Nicollet Ave",street_2 => undef}
{city => "Burnsville",postal_code => 55337,region => "Minnesota",region_abbr => "MN",street_1 => "1006 County Road 42 W",street_2 => undef}
{city => "Chaska",postal_code => 55318,region => "Minnesota",region_abbr => "MN",street_1 => "500 Chestnut Street",street_2 => undef}
{city => "Columbia Heights",postal_code => 55421,region => "Minnesota",region_abbr => "MN",street_1 => "4920 Central Avenue NE",street_2 => undef}
{city => "Columbia Heights",postal_code => 55421,region => "Minnesota",region_abbr => "MN",street_1 => "4920 Central Ave NE",street_2 => undef}
{city => "Columbia Heights",postal_code => 55421,region => "Minnesota",region_abbr => "MN",street_1 => "735 45th Avenue NE",street_2 => undef}
{city => "Coon Rapids",postal_code => 55433,region => "Minnesota",region_abbr => "MN",street_1 => "12465 Riverdale Boulevard NW",street_2 => undef}
{city => "Duluth",postal_code => 55807,region => "Minnesota",region_abbr => "MN",street_1 => "324 N. Central Ave.",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "222 East Superior Street",street_2 => undef}
{city => "Duluth",postal_code => 55806,region => "Minnesota",region_abbr => "MN",street_1 => "118 S. 27th Avenue West",street_2 => undef}
{city => "Duluth",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1332 East 4th St",street_2 => undef}
{city => "Duluth",postal_code => 55802,region => "Minnesota",region_abbr => "MN",street_1 => "220 W. Superior St.",street_2 => undef}
{city => "Duluth",postal_code => 55805,region => "Minnesota",region_abbr => "MN",street_1 => "610 E 4th Street",street_2 => undef}
{city => "Eagan",postal_code => 55123,region => "Minnesota",region_abbr => "MN",street_1 => "1304 Town Centre Drive and Denmark",street_2 => undef}
{city => "Edina",postal_code => 55434,region => "Minnesota",region_abbr => "MN",street_1 => "3520 W. 70th St.",street_2 => undef}
{city => "Edina",postal_code => 55435,region => "Minnesota",region_abbr => "MN",street_1 => "3510 W. 70th Street",street_2 => "Galleria Mall"}
{city => "Edina",postal_code => 55424,region => "Minnesota",region_abbr => "MN",street_1 => "3948 W. 50th Street",street_2 => undef}
{city => "Edina",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1690 Southdale Center",street_2 => undef}
{city => "Edina",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "2700 Southdale Center",street_2 => undef}
{city => "Falcon Heights",postal_code => 55108,region => "Minnesota",region_abbr => "MN",street_1 => "1700 Snelling Ave.",street_2 => undef}
{city => "Gilbert",postal_code => 55741,region => "Minnesota",region_abbr => "MN",street_1 => "101 N Broadway",street_2 => undef}
{city => "Golden Valley",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "550 Winnetka Ave N",street_2 => undef}
{city => "Golden Valley",postal_code => 55426,region => "Minnesota",region_abbr => "MN",street_1 => "850 Louisiana Ave",street_2 => undef}
{city => "Hopkins",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "210 North Blake Road",street_2 => undef}
{city => "Hopkins",postal_code => 55343,region => "Minnesota",region_abbr => "MN",street_1 => "802 Mainstreet",street_2 => undef}
{city => "Hutchinson",postal_code => 55350,region => "Minnesota",region_abbr => "MN",street_1 => "60 Academy Lane.",street_2 => undef}
{city => "Lakeville",postal_code => 55044,region => "Minnesota",region_abbr => "MN",street_1 => "17733 Kenwood Trail",street_2 => undef}
{city => "Mankato",postal_code => 56001,region => "Minnesota",region_abbr => "MN",street_1 => "1751 N. Victory Drive",street_2 => undef}
{city => "Maple Grove",postal_code => 55311,region => "Minnesota",region_abbr => "MN",street_1 => "13601 Grove Drive",street_2 => undef}
{city => "Maplewood",postal_code => 55109,region => "Minnesota",region_abbr => "MN",street_1 => "1715 Beam Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "8 E. 26th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "900 S. Washington Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1500 Hennepin Avenue East",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "931 Nicollet Mall",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2821 Nicollet Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "315 16th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1100 Nicollet Mall",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1123 W. Lake St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2851 Johnson Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "304 Oak St SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55455,region => "Minnesota",region_abbr => "MN",street_1 => "300 Washington Ave SE",street_2 => "Coffman Union - U of MN Twin Cities"}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "720 N Washington Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2311 18th Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "800 Washington Ave. N.",street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "23 4th St. NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2819 Hennepin Ave.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "413 14th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Lyndale Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "1432 W 31st St",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3001 Hennepin Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2851 Johnson ST NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2328 East Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1517 Como Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55409,region => "Minnesota",region_abbr => "MN",street_1 => "4300 Bryant Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55454,region => "Minnesota",region_abbr => "MN",street_1 => "1827 Riverside Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2929 E. 25th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3800 37th Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "407 14th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2200 Hennepin Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2841 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "2010 East Hennepin Ave.",street_2 => "#22"}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "7th Avenue and University Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55407,region => "Minnesota",region_abbr => "MN",street_1 => "3761 Bloomington Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3009 27th Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "983 East Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "307 Oak St. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "3338 University Avenue S.E.",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2929 East 25Th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "401 First Avenue North",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1204 Harmon Place",street_2 => undef}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "501 Washington Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "1835 Central Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "604 Washington Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "407 14th Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "701 W. Lake St",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "648 Broadway St. NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55413,region => "Minnesota",region_abbr => "MN",street_1 => "1306 2nd St NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "2339 Central Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "11 S. 7th St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "1835 Central Ave NE",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "704 S. 2nd Street",street_2 => "Mill City Farmer's Market"}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2327 E Franklin Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55415,region => "Minnesota",region_abbr => "MN",street_1 => "806 South Second Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55410,region => "Minnesota",region_abbr => "MN",street_1 => "2724 West 43rd Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "3601 E. Lake St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "600 Washington Ave N",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2207 East Franklin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1229 Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "2418 University Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2827 Hennepin Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2650 Hennepin Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1417 4th St. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "123 North 3rd Street Suite 101",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "95 Merriam St.",street_2 => undef}
{city => "Minneapolis",postal_code => 55419,region => "Minnesota",region_abbr => "MN",street_1 => "317 West 48th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3016 Lyndale Avenue South",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1010 Nicollet Malle",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1833 Nicollet Ave. S.",street_2 => undef}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3016 Lyndale Avenue S.",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "2015 East 24th Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2708 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "651 Nicollet Mall",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "802 Washington Avenue SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "411 14th Ave. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2501 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "121 South 8th St.",street_2 => "TCF Tower"}
{city => "Minneapolis",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => undef,street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "2647 Nicollet Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2551 Lyndale Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55403,region => "Minnesota",region_abbr => "MN",street_1 => "1346 LaSalle Ave",street_2 => undef}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "30 North First Street",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "423 14th Avenue SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "2929 University Ave SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "80 S 8th St",street_2 => "2nd Floor, inside Sola Squeeze"}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "E. Lake St. & Elliot Ave S.",street_2 => "Inside the Midtown Global Market"}
{city => "Minneapolis",postal_code => 55401,region => "Minnesota",region_abbr => "MN",street_1 => "719 South 2nd St",street_2 => undef}
{city => "Minneapolis",postal_code => 55404,region => "Minnesota",region_abbr => "MN",street_1 => "1401 11th Avenue S",street_2 => undef}
{city => "Minneapolis",postal_code => 55406,region => "Minnesota",region_abbr => "MN",street_1 => "2751 Minnehaha Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55408,region => "Minnesota",region_abbr => "MN",street_1 => "3403 Lyndale Ave S",street_2 => undef}
{city => "Minneapolis",postal_code => 55418,region => "Minnesota",region_abbr => "MN",street_1 => "1900 Marshall St. NE",street_2 => undef}
{city => "Minneapolis",postal_code => 55402,region => "Minnesota",region_abbr => "MN",street_1 => "225 South 6th Street",street_2 => "Skyway Level"}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "1323 4th St. SE",street_2 => undef}
{city => "Minneapolis",postal_code => 55414,region => "Minnesota",region_abbr => "MN",street_1 => "201 E. Hennepin Avenue",street_2 => undef}
{city => "Minneapolis",postal_code => 55405,region => "Minnesota",region_abbr => "MN",street_1 => "2116 Lyndale Ave S.",street_2 => undef}
{city => "Moorhead",postal_code => 56560,region => "Minnesota",region_abbr => "MN",street_1 => "910 Holiday Drive, Unit 3",street_2 => undef}
{city => "Moorhead",postal_code => 56560,region => "Minnesota",region_abbr => "MN",street_1 => "3246 Highway 10 E",street_2 => undef}
{city => "Moorhead",postal_code => 56560,region => "Minnesota",region_abbr => "MN",street_1 => "810 30th Ave South",street_2 => undef}
{city => "Mounds View",postal_code => 55112,region => "Minnesota",region_abbr => "MN",street_1 => "2563 Hwy 10 NE",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "306 Division Street S.",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "319 Division Street South",street_2 => undef}
{city => "Northfield",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "212 Division Street S.",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "421 Division Street",street_2 => undef}
{city => "Northfield",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "1011 St. Olaf Avenue",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "2018 Jefferson Road",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "214 Division Street South",street_2 => undef}
{city => "Northfield",postal_code => 55057,region => "Minnesota",region_abbr => "MN",street_1 => "1001 Division Street South",street_2 => undef}
{city => "Osseo",postal_code => 55369,region => "Minnesota",region_abbr => "MN",street_1 => "204 Central Ave",street_2 => undef}
{city => "Plymouth",postal_code => 55441,region => "Minnesota",region_abbr => "MN",street_1 => "10100 6th Ave. N.",street_2 => undef}
{city => "Richfield",postal_code => 55423,region => "Minnesota",region_abbr => "MN",street_1 => "7545 Lyndale Avenue South",street_2 => undef}
{city => "Rochester",postal_code => 55901,region => "Minnesota",region_abbr => "MN",street_1 => "1035 Civic Center Drive",street_2 => undef}
{city => "Rochester",postal_code => 55902,region => "Minnesota",region_abbr => "MN",street_1 => "100 First Avenue SW",street_2 => "Skyway Level"}
{city => "Rochester",postal_code => 55901,region => "Minnesota",region_abbr => "MN",street_1 => "1205 7th St. NW",street_2 => undef}
{city => "Rochester",postal_code => 55904,region => "Minnesota",region_abbr => "MN",street_1 => "1201 S. Broadway",street_2 => "Crossroads Shopping Center"}
{city => "Rochester",postal_code => 55904,region => "Minnesota",region_abbr => "MN",street_1 => "1107 N Broadway",street_2 => undef}
{city => "Rochester",postal_code => 55904,region => "Minnesota",region_abbr => "MN",street_1 => "111 South Broadway",street_2 => undef}
{city => "Rochester",postal_code => 55902,region => "Minnesota",region_abbr => "MN",street_1 => "102 Apache Mall",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2193 Snelling Avenue N.",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "1675 County Road C W",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "1607 County Road C W",street_2 => undef}
{city => "Roseville",postal_code => 55113,region => "Minnesota",region_abbr => "MN",street_1 => "2801 Snelling Avenue North",street_2 => undef}
{city => "Saint Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "2812 Divison Street",street_2 => undef}
{city => "Saint Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "967 West 7th Street",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "769 Grand Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "2060 Randolph Ave",street_2 => undef}
{city => "Saint Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "570 N. Snelling Avenue",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "470 Cleveland Ave N",street_2 => undef}
{city => "Saint Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1681 Grand Ave",street_2 => undef}
{city => "Shakopee",postal_code => 55379,region => "Minnesota",region_abbr => "MN",street_1 => "230 Lewis St S",street_2 => undef}
{city => "Shoreview",postal_code => 55126,region => "Minnesota",region_abbr => "MN",street_1 => "1048 Highway 96 W",street_2 => undef}
{city => "Spring Lake Park",postal_code => 55432,region => "Minnesota",region_abbr => "MN",street_1 => "8492 Central Ave NE",street_2 => undef}
{city => "St Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "927 9th Ave S",street_2 => undef}
{city => "St Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "684 Snelling Ave N",street_2 => undef}
{city => "St. Cloud",postal_code => 56301,region => "Minnesota",region_abbr => "MN",street_1 => "921 West St. Germain Street",street_2 => undef}
{city => "St. Cloud",postal_code => undef,region => "Minnesota",region_abbr => "MN",street_1 => "266 33rd Ave. South",street_2 => undef}
{city => "St. Joseph",postal_code => 56374,region => "Minnesota",region_abbr => "MN",street_1 => "19 West Minnesota Street",street_2 => undef}
{city => "St. Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "477 W. 7th St.",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1600 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1045 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "422 University Ave W",street_2 => undef}
{city => "St. Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "610 Selby Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55103,region => "Minnesota",region_abbr => "MN",street_1 => "500 University Ave W",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1566 University Ave",street_2 => undef}
{city => "St. Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "2516 7th Street",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "St. Paul Skyway",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "1659 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55175,region => "Minnesota",region_abbr => "MN",street_1 => "322 Minnesota St.",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "629 Aldine Street",street_2 => undef}
{city => "St. Paul",postal_code => 55106,region => "Minnesota",region_abbr => "MN",street_1 => "1676 Suburban Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55108,region => "Minnesota",region_abbr => "MN",street_1 => "1435 N Cleveland Ave.",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "401 Robert St N",street_2 => undef}
{city => "St. Paul",postal_code => 55116,region => "Minnesota",region_abbr => "MN",street_1 => "2516 7th St. W.",street_2 => undef}
{city => "St. Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "525 Selby",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "2186 Marshall Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55102,region => "Minnesota",region_abbr => "MN",street_1 => "1500 W. 7th Street",street_2 => undef}
{city => "St. Paul",postal_code => 55105,region => "Minnesota",region_abbr => "MN",street_1 => "758 Grand Avenue",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "1613 University Ave West",street_2 => undef}
{city => "St. Paul",postal_code => 55101,region => "Minnesota",region_abbr => "MN",street_1 => "111 Kellogg Blvd",street_2 => undef}
{city => "St. Paul",postal_code => 55104,region => "Minnesota",region_abbr => "MN",street_1 => "799 University Avenue W.",street_2 => undef}
{city => "Two Harbors",postal_code => 55616,region => "Minnesota",region_abbr => "MN",street_1 => "812 7th Avenue",street_2 => undef}
{city => "Wadena",postal_code => 56482,region => "Minnesota",region_abbr => "MN",street_1 => "114 Jefferson Street South",street_2 => "Alley Entrance"}
{city => "Waite Park",postal_code => 56387,region => "Minnesota",region_abbr => "MN",street_1 => "2140 Frontage Road North",street_2 => undef}
{city => "West St. Paul",postal_code => 55118,region => "Minnesota",region_abbr => "MN",street_1 => "1385 Robert Street S",street_2 => undef}
{city => "White Bear Lake",postal_code => 55127,region => "Minnesota",region_abbr => "MN",street_1 => "1011 Meadowlands Drive",street_2 => undef}
{city => "Willmar",postal_code => 56201,region => "Minnesota",region_abbr => "MN",street_1 => "309 Lakeland Dr SE",street_2 => undef}
{city => "Winona",postal_code => 55987,region => "Minnesota",region_abbr => "MN",street_1 => "162 W. 2nd St.",street_2 => undef}
{city => "Woodbury",postal_code => 55125,region => "Minnesota",region_abbr => "MN",street_1 => "8362 Tamarack Vlg, #120",street_2 => undef}
{city => "Belton",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => undef,street_2 => undef}
{city => "Belton",postal_code => 64012,region => "Missouri",region_abbr => "MO",street_1 => "301 A Main Street,",street_2 => undef}
{city => "Camdenton",postal_code => 65020,region => "Missouri",region_abbr => "MO",street_1 => "442 Riverbird Lane",street_2 => undef}
{city => "Columbia",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "220 N. 10th Street",street_2 => undef}
{city => "Columbia",postal_code => 65201,region => "Missouri",region_abbr => "MO",street_1 => "304 South 9th Street",street_2 => undef}
{city => "Columbia",postal_code => 65201,region => "Missouri",region_abbr => "MO",street_1 => "3802 Buttonwood Dr.",street_2 => undef}
{city => "Creve Coeur",postal_code => 63141,region => "Missouri",region_abbr => "MO",street_1 => "12675 Olive Blvd",street_2 => undef}
{city => "Independence",postal_code => 64055,region => "Missouri",region_abbr => "MO",street_1 => "19019 E 48th St S",street_2 => undef}
{city => "Joplin",postal_code => 64804,region => "Missouri",region_abbr => "MO",street_1 => "3021 South Main Street",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "3415 Main Street",street_2 => undef}
{city => "Kansas City",postal_code => 64108,region => "Missouri",region_abbr => "MO",street_1 => "1713 Summit St.",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1621 W 39th St",street_2 => undef}
{city => "Kansas City",postal_code => 64112,region => "Missouri",region_abbr => "MO",street_1 => "4855 Main Street",street_2 => undef}
{city => "Kansas City",postal_code => 64108,region => "Missouri",region_abbr => "MO",street_1 => "2932 Cherry St.",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "4010 Pennsylvania Ave",street_2 => undef}
{city => "Kansas City",postal_code => 64153,region => "Missouri",region_abbr => "MO",street_1 => "7407 NW 87th Street",street_2 => undef}
{city => "Kansas City",postal_code => 64106,region => "Missouri",region_abbr => "MO",street_1 => "2601 Holmes Street",street_2 => undef}
{city => "Kansas City",postal_code => 64112,region => "Missouri",region_abbr => "MO",street_1 => "707 W 47th St",street_2 => "Unity Temple Building"}
{city => "Kansas City",postal_code => 64112,region => "Missouri",region_abbr => "MO",street_1 => "102 W 47th St",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "3903 Wyoming St.",street_2 => undef}
{city => "Kansas City",postal_code => 64108,region => "Missouri",region_abbr => "MO",street_1 => "1700 Summit Street",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1803 W 39th St",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "4057 Pennsylvania Ave",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "3613 Broadway Rd.",street_2 => undef}
{city => "Kansas City",postal_code => 64112,region => "Missouri",region_abbr => "MO",street_1 => "4800 Main Street",street_2 => undef}
{city => "Kansas City",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => undef,street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "1020 Westport Rd",street_2 => undef}
{city => "Kansas City",postal_code => 64112,region => "Missouri",region_abbr => "MO",street_1 => "4807 Jefferson St",street_2 => "The Plaza"}
{city => "Kansas City",postal_code => 64105,region => "Missouri",region_abbr => "MO",street_1 => "1111 Main Street",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "536 Westport Rd",street_2 => undef}
{city => "Kansas City",postal_code => 64111,region => "Missouri",region_abbr => "MO",street_1 => "4141 Pennsylvania Avenue",street_2 => undef}
{city => "Kansas City",postal_code => 64108,region => "Missouri",region_abbr => "MO",street_1 => "813 W.17th St.",street_2 => undef}
{city => "Kirkwood",postal_code => 63122,region => "Missouri",region_abbr => "MO",street_1 => "10935 Manchester Road",street_2 => undef}
{city => "Lee's Summit",postal_code => 64086,region => "Missouri",region_abbr => "MO",street_1 => "1543 NE Douglas St",street_2 => undef}
{city => "Lees Summit",postal_code => 64081,region => "Missouri",region_abbr => "MO",street_1 => "Be Free Bakers (Corporate Offices)",street_2 => "1333 SW Surrey Trace"}
{city => "Maplewood",postal_code => 63143,region => "Missouri",region_abbr => "MO",street_1 => "7344 Manchester Road",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "3050 S. National",street_2 => "Ste. 108"}
{city => "Springfield",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "533 S. Kimbrough",street_2 => undef}
{city => "Springfield",postal_code => 65806,region => "Missouri",region_abbr => "MO",street_1 => "434 S. Jefferson Avenue",street_2 => undef}
{city => "Springfield",postal_code => 65804,region => "Missouri",region_abbr => "MO",street_1 => "1338 E. Battlefield",street_2 => undef}
{city => "Springfield",postal_code => 65804,region => "Missouri",region_abbr => "MO",street_1 => "2825 South Glenstone",street_2 => "Battlefield Mall"}
{city => "St. Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "3003 Arsenal St",street_2 => undef}
{city => "St. Louis",postal_code => 63105,region => "Missouri",region_abbr => "MO",street_1 => "7351 Forsyth Blvd",street_2 => undef}
{city => "St. Louis",postal_code => 63103,region => "Missouri",region_abbr => "MO",street_1 => "1327 Washington Ave.",street_2 => undef}
{city => "St. Louis",postal_code => 63116,region => "Missouri",region_abbr => "MO",street_1 => "4123 Chippewa Street",street_2 => undef}
{city => "St. Louis",postal_code => 63143,region => "Missouri",region_abbr => "MO",street_1 => "7298 Manchester Road",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "400 N. Euclid Avenue",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "11 South Euclid Ave",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "3650 Lindell Blvd",street_2 => "Pius XII Memorial Library"}
{city => "St. Louis",postal_code => 63118,region => "Missouri",region_abbr => "MO",street_1 => "3200 S. Grand Blvd",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "3171 South Grand Boulevard",street_2 => undef}
{city => "St. Louis",postal_code => 63130,region => "Missouri",region_abbr => "MO",street_1 => "6602 Delmar Blvd",street_2 => undef}
{city => "St. Louis",postal_code => 63112,region => "Missouri",region_abbr => "MO",street_1 => "6144 Delmar Blvd.",street_2 => undef}
{city => "St. Louis",postal_code => 63116,region => "Missouri",region_abbr => "MO",street_1 => "3137 Morganford Road",street_2 => undef}
{city => "St. Louis",postal_code => 63110,region => "Missouri",region_abbr => "MO",street_1 => "2203 S. 39th Street",street_2 => undef}
{city => "St. Louis",postal_code => 63108,region => "Missouri",region_abbr => "MO",street_1 => "392 N Euclid Avenue",street_2 => undef}
{city => "St. Louis",postal_code => 63139,region => "Missouri",region_abbr => "MO",street_1 => "3132 S. Kingshighway Blvd",street_2 => undef}
{city => "St. Louis",postal_code => undef,region => "Missouri",region_abbr => "MO",street_1 => "1130 Washington Avenue",street_2 => undef}
{city => "St. Louis",postal_code => 63110,region => "Missouri",region_abbr => "MO",street_1 => "5204 Wilson Avenue",street_2 => undef}
{city => "Billings",postal_code => 59102,region => "Montana",region_abbr => "MT",street_1 => "1806 King Ave West",street_2 => undef}
{city => "Bozeman",postal_code => 59715,region => "Montana",region_abbr => "MT",street_1 => "908 W Main",street_2 => undef}
{city => "Great Falls",postal_code => 59401,region => "Montana",region_abbr => "MT",street_1 => "815 Central Avenue",street_2 => undef}
{city => "Kalispell",postal_code => 59901,region => "Montana",region_abbr => "MT",street_1 => "277 South Main St.",street_2 => undef}
{city => "Livingston",postal_code => 59047,region => "Montana",region_abbr => "MT",street_1 => "113 W Park St.",street_2 => undef}
{city => "Jackson",postal_code => 39216,region => "Mississippi",region_abbr => "MS",street_1 => "2807 Old Canton Road",street_2 => undef}
{city => "Jackson",postal_code => 39216,region => "Mississippi",region_abbr => "MS",street_1 => "2807 Old Canton Road",street_2 => undef}
{city => "Long Beach",postal_code => 39560,region => "Mississippi",region_abbr => "MS",street_1 => "5130 Beatline Road",street_2 => undef}
{city => "Petal",postal_code => 39465,region => "Mississippi",region_abbr => "MS",street_1 => "128 Sherry Lynn Drive",street_2 => undef}
{city => "Billings",postal_code => 59102,region => "Montana",region_abbr => "MT",street_1 => "1430 Country Manor Boulevard",street_2 => undef}
{city => "Billings",postal_code => 59101,region => "Montana",region_abbr => "MT",street_1 => "116 North Broadway",street_2 => undef}
{city => "Billings",postal_code => 59102,region => "Montana",region_abbr => "MT",street_1 => "2228 Grand Ave",street_2 => undef}
{city => "Billings",postal_code => 59101,region => "Montana",region_abbr => "MT",street_1 => "2916 1st Ave N.",street_2 => undef}
{city => "Billings",postal_code => 59101,region => "Montana",region_abbr => "MT",street_1 => "3024 2nd Avenue North",street_2 => undef}
{city => "Billings",postal_code => 59102,region => "Montana",region_abbr => "MT",street_1 => "2564 King Ave W.",street_2 => "Suite J"}
{city => "Billings",postal_code => "59102 / 59105",region => "Montana",region_abbr => "MT",street_1 => "3025 Grand Ave.",street_2 => "405 W. Main"}
{city => "Bozeman",postal_code => 59715,region => "Montana",region_abbr => "MT",street_1 => "27 S. Willson Ave.",street_2 => undef}
{city => "Bozeman",postal_code => 59715,region => "Montana",region_abbr => "MT",street_1 => "246 E. Main St",street_2 => undef}
{city => "Bozeman",postal_code => 59715,region => "Montana",region_abbr => "MT",street_1 => "24 N. Tracy, Downtown Bozeman",street_2 => undef}
{city => "Bozeman",postal_code => "(406) 582-9292",region => "Montana",region_abbr => "MT",street_1 => "1912 West Main Street Bozeman",street_2 => undef}
{city => "Bozeman",postal_code => 59715,region => "Montana",region_abbr => "MT",street_1 => "15325 Bridger Canyon Road",street_2 => undef}
{city => "Great Falls",postal_code => 59405,region => "Montana",region_abbr => "MT",street_1 => "2325 10th Ave. S",street_2 => undef}
{city => "Great Falls",postal_code => 59401,region => "Montana",region_abbr => "MT",street_1 => "220 Central Ave.",street_2 => undef}
{city => "Helena",postal_code => 59601,region => "Montana",region_abbr => "MT",street_1 => "101 E. Sixth",street_2 => undef}
{city => "Kalispell",postal_code => 59901,region => "Montana",region_abbr => "MT",street_1 => "135 E Idaho St.",street_2 => undef}
{city => "Kalispell",postal_code => 59901,region => "Montana",region_abbr => "MT",street_1 => "130 Hutton Ranch Rd.",street_2 => undef}
{city => "Libby",postal_code => 59923,region => "Montana",region_abbr => "MT",street_1 => "31312 US Highway 2",street_2 => undef}
{city => "Missoula",postal_code => undef,region => "Montana",region_abbr => "MT",street_1 => "1600 S. 3rd Street W.",street_2 => undef}
{city => "Missoula",postal_code => 59801,region => "Montana",region_abbr => "MT",street_1 => "190 S. 3rd Street West",street_2 => undef}
{city => "Missoula",postal_code => 59807,region => "Montana",region_abbr => "MT",street_1 => "130 North Higgins Ave",street_2 => undef}
{city => "Missoula",postal_code => 59804,region => "Montana",region_abbr => "MT",street_1 => "103 W. Spruce Street",street_2 => undef}
{city => "Missoula",postal_code => 59801,region => "Montana",region_abbr => "MT",street_1 => "3521 Brooks St.",street_2 => undef}
{city => "St. Mary",postal_code => 59417,region => "Montana",region_abbr => "MT",street_1 => "3147 Highway 89",street_2 => undef}
{city => "Whitefish",postal_code => 59937,region => "Montana",region_abbr => "MT",street_1 => "10 Baker Ave.",street_2 => undef}
{city => "Whitefish",postal_code => 59937,region => "Montana",region_abbr => "MT",street_1 => "415 Second Avenue East",street_2 => undef}
{city => "Alexander",postal_code => 28701,region => "North Carolina",region_abbr => "NC",street_1 => "679 Lower Flat Creek Road",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "705 Merrimon Ave.",street_2 => undef}
{city => "Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "626 Haywood Rd.",street_2 => undef}
{city => "Asheville",postal_code => 28803,region => "North Carolina",region_abbr => "NC",street_1 => "30 Town Square Blvd",street_2 => "#140"}
{city => "Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "794 Haywood Road",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "371 Merrimon Ave",street_2 => undef}
{city => "Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "721 Haywood St.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "10 South Lexington Avenue",street_2 => undef}
{city => "Asheville",postal_code => 28805,region => "North Carolina",region_abbr => "NC",street_1 => "611 Tunnel Road",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "640 Merrimon Avenue",street_2 => "Merrimon Square Suite 201"}
{city => "Asheville",postal_code => 28805,region => "North Carolina",region_abbr => "NC",street_1 => "1838 Hendersonville Rd.",street_2 => "Suite 103"}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "42 S. Market Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => undef,street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "78 N. Lexington Avenue",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "1 Page Avenue",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "48 Commerce Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "18 N. Lexington Avenue",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "791 Merrimon Ave",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "333 Merrimon Avenue",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "22 Battery Park Ave.",street_2 => undef}
{city => "Asheville (Weaverville)",postal_code => 28787,region => "North Carolina",region_abbr => "NC",street_1 => "88 S Main St",street_2 => undef}
{city => "Black Mountain",postal_code => 28711,region => "North Carolina",region_abbr => "NC",street_1 => "100 South Ridgeway Ave",street_2 => undef}
{city => "Boone",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => undef,street_2 => undef}
{city => "Boonville",postal_code => 27011,region => "North Carolina",region_abbr => "NC",street_1 => "3200 Round Hill Rd",street_2 => undef}
{city => "Carrboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "200 N. Greensboro St.",street_2 => undef}
{city => "Carrboro",postal_code => 27510,region => "North Carolina",region_abbr => "NC",street_1 => "601 W. Main St.",street_2 => undef}
{city => "Carrboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "103 E. Main St.",street_2 => undef}
{city => "Carrboro",postal_code => 7510,region => "North Carolina",region_abbr => "NC",street_1 => "711 W Rosemary St",street_2 => undef}
{city => "Cary",postal_code => 27511,region => "North Carolina",region_abbr => "NC",street_1 => "590 E. Chatham St",street_2 => "Suite 112"}
{city => "Cary",postal_code => 27513,region => "North Carolina",region_abbr => "NC",street_1 => "969 N Harrison Ave",street_2 => undef}
{city => "Cary",postal_code => 27511,region => "North Carolina",region_abbr => "NC",street_1 => "140 E. Chatham Street",street_2 => undef}
{city => "Chapel Hill",postal_code => 27516,region => "North Carolina",region_abbr => "NC",street_1 => "431 W. Franklin St.",street_2 => undef}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "1800 E. Franklin Street",street_2 => undef}
{city => "Chapel Hill",postal_code => 27516,region => "North Carolina",region_abbr => "NC",street_1 => "410 Market Square",street_2 => undef}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "1505 East Franklin Street",street_2 => undef}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "201 S Estes Dr",street_2 => undef}
{city => "Chapel Hill",postal_code => 27516,region => "North Carolina",region_abbr => "NC",street_1 => "133E W. Franklin Street",street_2 => "University Square"}
{city => "Charlotte",postal_code => 28203,region => "North Carolina",region_abbr => "NC",street_1 => "1515 Harding Place",street_2 => "Mecklenburg County Market"}
{city => "Charlotte",postal_code => 28262,region => "North Carolina",region_abbr => "NC",street_1 => "7945 N. Tryon St.",street_2 => "Suite 110"}
{city => "Charlotte",postal_code => 28203,region => "North Carolina",region_abbr => "NC",street_1 => "1257 East Boulevard",street_2 => undef}
{city => "Charlotte",postal_code => 28226,region => "North Carolina",region_abbr => "NC",street_1 => undef,street_2 => undef}
{city => "Charlotte",postal_code => 28203,region => "North Carolina",region_abbr => "NC",street_1 => "2102 South Blvd.",street_2 => undef}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2007 Commonwealth Avenue",street_2 => undef}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1515 S. Tryon Street",street_2 => undef}
{city => "Charlotte",postal_code => 28211,region => "North Carolina",region_abbr => "NC",street_1 => "4310 Sharon Road",street_2 => "Suite X05"}
{city => "Charlotte",postal_code => 28212,region => "North Carolina",region_abbr => "NC",street_1 => "5301 E. Independence Blvd",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "10710 Providence Road",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "7930 Rea Rd",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "12235 North Community House Road",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "14825 Ballantyne Village Way",street_2 => undef}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2104 South Boulevard",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "7930 A Rea Rd.",street_2 => undef}
{city => "Charlotte",postal_code => 28209,region => "North Carolina",region_abbr => "NC",street_1 => "2102 South Blvd.",street_2 => "#150"}
{city => "Concord",postal_code => 28025,region => "North Carolina",region_abbr => "NC",street_1 => "16 Union St. S.",street_2 => undef}
{city => "Durham",postal_code => 27707,region => "North Carolina",region_abbr => "NC",street_1 => "2701 Chapel Hill Rd.",street_2 => undef}
{city => "Elon",postal_code => 27244,region => "North Carolina",region_abbr => "NC",street_1 => "116 N. Williamson Avenue",street_2 => undef}
{city => "Fayetteville",postal_code => 28301,region => "North Carolina",region_abbr => "NC",street_1 => "212 Hay Street",street_2 => undef}
{city => "Fayetteville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1904 Skibo Road",street_2 => undef}
{city => "Greensboro",postal_code => 27406,region => "North Carolina",region_abbr => "NC",street_1 => "609 S Elm St",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => undef,street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "600 S. Elam Avenue",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "334 Tate Street",street_2 => undef}
{city => "Greensboro",postal_code => 27401,region => "North Carolina",region_abbr => "NC",street_1 => "341 S. Elm Street",street_2 => undef}
{city => "Greensboro",postal_code => 27403,region => "North Carolina",region_abbr => "NC",street_1 => "1932 Spring Garden Street",street_2 => undef}
{city => "Greensboro",postal_code => 27408,region => "North Carolina",region_abbr => "NC",street_1 => "1500 MILL ST",street_2 => undef}
{city => "Greensboro",postal_code => 27401,region => "North Carolina",region_abbr => "NC",street_1 => "216 S. Elm St.",street_2 => undef}
{city => "Greensboro",postal_code => 27408,region => "North Carolina",region_abbr => "NC",street_1 => "908 Cridland Road",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2206 Walker Ave.",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1500 Mill St.",street_2 => undef}
{city => "Hendersonville",postal_code => 28792,region => "North Carolina",region_abbr => "NC",street_1 => "210B Church Street",street_2 => undef}
{city => "Monroe",postal_code => 28112,region => "North Carolina",region_abbr => "NC",street_1 => "215 East Franklin Street",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "144 Morrisville Square Way",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "3532 Davis Drive",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "120 Morrisville Square Way",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "6105 Grace Park Drive",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "152 Morrisville Square Way",street_2 => undef}
{city => "Raleigh",postal_code => 27608,region => "North Carolina",region_abbr => "NC",street_1 => "1813 Glenwood Avenue",street_2 => undef}
{city => "Raleigh",postal_code => 27612,region => "North Carolina",region_abbr => "NC",street_1 => "5645 Creedmoor Rd",street_2 => undef}
{city => "Raleigh",postal_code => 27616,region => "North Carolina",region_abbr => "NC",street_1 => "8471 Garvey Drive",street_2 => "Durant Station"}
{city => "Raleigh",postal_code => 27609,region => "North Carolina",region_abbr => "NC",street_1 => "1408 Hardimont Road",street_2 => undef}
{city => "Raleigh",postal_code => 27603,region => "North Carolina",region_abbr => "NC",street_1 => "317 W. Morgan St.",street_2 => undef}
{city => "Raleigh",postal_code => 27601,region => "North Carolina",region_abbr => "NC",street_1 => "426 S. McDowell St.",street_2 => undef}
{city => "Raleigh",postal_code => 27601,region => "North Carolina",region_abbr => "NC",street_1 => "130 E. Davie Street",street_2 => undef}
{city => "Raleigh",postal_code => 27605,region => "North Carolina",region_abbr => "NC",street_1 => "2016 Clark Avenue",street_2 => undef}
{city => "Raleigh",postal_code => 27601,region => "North Carolina",region_abbr => "NC",street_1 => "137 E. Hargett St.",street_2 => undef}
{city => "Smithfield",postal_code => 27577,region => "North Carolina",region_abbr => "NC",street_1 => "709 South 3rd Street",street_2 => undef}
{city => "Statesville",postal_code => 28677,region => "North Carolina",region_abbr => "NC",street_1 => "105 E. Broad Street",street_2 => undef}
{city => "Weaverville",postal_code => 28787,region => "North Carolina",region_abbr => "NC",street_1 => "88 S Main St",street_2 => undef}
{city => "West Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "771 Haywood Road",street_2 => "Bledsoe Building"}
{city => "Wilmington",postal_code => 28401,region => "North Carolina",region_abbr => "NC",street_1 => "114 N. Front St.",street_2 => undef}
{city => "Wilmington",postal_code => 28405,region => "North Carolina",region_abbr => "NC",street_1 => "6801 Main Street",street_2 => undef}
{city => "Wilmington",postal_code => 28405,region => "North Carolina",region_abbr => "NC",street_1 => "5001-A Market Street",street_2 => "Ramada Inn"}
{city => "Wilmington",postal_code => 28403,region => "North Carolina",region_abbr => "NC",street_1 => "4403 Wrightsville Avenue",street_2 => undef}
{city => "Wilmington",postal_code => 28401,region => "North Carolina",region_abbr => "NC",street_1 => "16 S. Front Street",street_2 => undef}
{city => "Wilmington",postal_code => 28403,region => "North Carolina",region_abbr => "NC",street_1 => "3520 Oleander Drive",street_2 => undef}
{city => "Wilmington",postal_code => 28405,region => "North Carolina",region_abbr => "NC",street_1 => "260 Racine Drive",street_2 => "Suite 8"}
{city => "Wilmington",postal_code => 28405,region => "North Carolina",region_abbr => "NC",street_1 => "1319 Military Cutoff Road",street_2 => undef}
{city => "Wilmington",postal_code => 28403,region => "North Carolina",region_abbr => "NC",street_1 => "5329 Oleander Drive",street_2 => undef}
{city => "Wilmington",postal_code => 28403,region => "North Carolina",region_abbr => "NC",street_1 => "7 Wayne Drive",street_2 => undef}
{city => "Wilmington",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "10200 US Highway 17 N.",street_2 => undef}
{city => "Wilmington",postal_code => 28401,region => "North Carolina",region_abbr => "NC",street_1 => "5424 Oleander Dr.",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "239 W. Fourth St.",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "301 Brookstown Avenue",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "750 Summit Street",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "620 North Trade Street",street_2 => undef}
{city => "Winston-Salem",postal_code => 27103,region => "North Carolina",region_abbr => "NC",street_1 => "1005 Hanes Mall Blvd.",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "101 W. 4th St",street_2 => undef}
{city => "Winston-Salem",postal_code => 27101,region => "North Carolina",region_abbr => "NC",street_1 => "314 W 4th St",street_2 => undef}
{city => "Wrightsville Beach",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "945 S. Lumina Avenue",street_2 => undef}
{city => "Wrightsville Beach",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "224 Causeway Drive",street_2 => undef}
{city => "Bismarck",postal_code => 58501,region => "North Dakota",region_abbr => "ND",street_1 => "801 E. Main Ave.",street_2 => undef}
{city => "Bismarck",postal_code => 58501,region => "North Dakota",region_abbr => "ND",street_1 => "1136 N 3rd St",street_2 => undef}
{city => "Bismarck",postal_code => 58504,region => "North Dakota",region_abbr => "ND",street_1 => "312 3rd Street",street_2 => undef}
{city => "Dickinson",postal_code => 58601,region => "North Dakota",region_abbr => "ND",street_1 => "20 First St. West",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "101 Broadway N",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "69 4th Street North",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "206 N Broadway",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "4900 13th Ave SW",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => undef,street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1801 45th St., SW",street_2 => undef}
{city => "Fargo",postal_code => undef,region => "North Dakota",region_abbr => "ND",street_1 => "1404 33rd St. SW",street_2 => undef}
{city => "Grand Forks",postal_code => 58203,region => "North Dakota",region_abbr => "ND",street_1 => "17 North Third Street",street_2 => undef}
{city => "Grand Forks",postal_code => 58203,region => "North Dakota",region_abbr => "ND",street_1 => "4201 James Ray Drive",street_2 => undef}
{city => "Grand Forks",postal_code => 58201,region => "North Dakota",region_abbr => "ND",street_1 => "1113 S. Washington Street",street_2 => undef}
{city => "Grand Forks",postal_code => 58203,region => "North Dakota",region_abbr => "ND",street_1 => "2860 10th Avenue North Unit 550",street_2 => undef}
{city => "Grand Forks",postal_code => 58201,region => "North Dakota",region_abbr => "ND",street_1 => "3551 32nd Avenue South",street_2 => undef}
{city => "Minot",postal_code => 58701,region => "North Dakota",region_abbr => "ND",street_1 => "1500 South Broadway",street_2 => undef}
{city => "Minot",postal_code => 58701,region => "North Dakota",region_abbr => "ND",street_1 => "809B North Broadway",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "1451 O",street_2 => "St # 103"}
{city => "Lincoln",postal_code => 68506,region => "Nebraska",region_abbr => "NE",street_1 => "3800 South 48th Street",street_2 => "Lower Level of Ortner Center"}
{city => "Lincoln",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "1200 O Street",street_2 => undef}
{city => "Lincoln",postal_code => 68505,region => "Nebraska",region_abbr => "NE",street_1 => "201 North 66th St.",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "6220 Havelock Avenue",street_2 => undef}
{city => "Lincoln",postal_code => 68502,region => "Nebraska",region_abbr => "NE",street_1 => "1625 S 17th St",street_2 => undef}
{city => "Lincoln",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "1423 O Street",street_2 => undef}
{city => "Lincoln",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "1100 O Street",street_2 => undef}
{city => "Lincoln",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "440 N 8th St Suite 150",street_2 => undef}
{city => "Omaha",postal_code => 68132,region => "Nebraska",region_abbr => "NE",street_1 => "715 N. Saddle Creek Road",street_2 => undef}
{city => "Omaha",postal_code => 68124,region => "Nebraska",region_abbr => "NE",street_1 => "3007 S. 83rd Plaza",street_2 => undef}
{city => "Omaha",postal_code => 68154,region => "Nebraska",region_abbr => "NE",street_1 => "228 North 114th St",street_2 => undef}
{city => "Omaha",postal_code => 68144,region => "Nebraska",region_abbr => "NE",street_1 => "14618 W Center Rd",street_2 => undef}
{city => "Omaha",postal_code => 68104,region => "Nebraska",region_abbr => "NE",street_1 => "6103 Maple St",street_2 => undef}
{city => "Omaha",postal_code => 68131,region => "Nebraska",region_abbr => "NE",street_1 => "3201 Farnam St.",street_2 => undef}
{city => "Omaha",postal_code => 68108,region => "Nebraska",region_abbr => "NE",street_1 => "1054 S. 20th St",street_2 => undef}
{city => "Omaha",postal_code => 68106,region => "Nebraska",region_abbr => "NE",street_1 => "6307 Center St.",street_2 => "Suite 101"}
{city => "Omaha",postal_code => 68103,region => "Nebraska",region_abbr => "NE",street_1 => "17660 Wright St.",street_2 => undef}
{city => "Omaha",postal_code => 68114,region => "Nebraska",region_abbr => "NE",street_1 => "990 S. 72nd St.",street_2 => undef}
{city => "Omaha",postal_code => 68154,region => "Nebraska",region_abbr => "NE",street_1 => "710 North 114th St.",street_2 => undef}
{city => "Omaha",postal_code => 68104,region => "Nebraska",region_abbr => "NE",street_1 => "6348 Spencer St.",street_2 => undef}
{city => "Lincoln",postal_code => 68516,region => "Nebraska",region_abbr => "NE",street_1 => "5500 Old Cheney Rd. Suite 4",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "816 P Street",street_2 => undef}
{city => "Lincoln",postal_code => 68516,region => "Nebraska",region_abbr => "NE",street_1 => "5445 Red Rock Lane",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "311 N. 8th St",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "1618 South St.",street_2 => undef}
{city => "Lincoln",postal_code => 68503,region => "Nebraska",region_abbr => "NE",street_1 => "313 N 27th St",street_2 => undef}
{city => "Lincoln",postal_code => 68508,region => "Nebraska",region_abbr => "NE",street_1 => "129 N 10th St",street_2 => undef}
{city => "lincoln",postal_code => 68506,region => "nebraska",region_abbr => "NE",street_1 => "2840 S 70th St",street_2 => undef}
{city => "lincoln",postal_code => 68510,region => "nebraska",region_abbr => "NE",street_1 => "6900 O St # 100",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "302 South 38th Street",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "1010 Howard St.",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "1006 Howard St",street_2 => undef}
{city => "Omaha",postal_code => 68114,region => "Nebraska",region_abbr => "NE",street_1 => "10150 California St.",street_2 => undef}
{city => "Omaha",postal_code => 68114,region => "Nebraska",region_abbr => "NE",street_1 => "7831 Dodge St",street_2 => undef}
{city => "Omaha",postal_code => 68124,region => "Nebraska",region_abbr => "NE",street_1 => "8809 W. Center",street_2 => undef}
{city => "Omaha",postal_code => 68106,region => "Nebraska",region_abbr => "NE",street_1 => "1110 S. 71st Street",street_2 => undef}
{city => "Omaha",postal_code => 68154,region => "Nebraska",region_abbr => "NE",street_1 => "681 N 132nd St",street_2 => undef}
{city => "Omaha",postal_code => 68154,region => "Nebraska",region_abbr => "NE",street_1 => "668 N 114th St",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "710 N 114th St",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "10020 Regency Circle",street_2 => undef}
{city => "Omaha",postal_code => 68131,region => "Nebraska",region_abbr => "NE",street_1 => "4007 Farnam St",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "631 N 114th St",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "10803 John Galt Blvd",street_2 => undef}
{city => "Omaha",postal_code => 68154,region => "Nebraska",region_abbr => "NE",street_1 => "743 N 114th St",street_2 => undef}
{city => "Omaha",postal_code => 68107,region => "Nebraska",region_abbr => "NE",street_1 => "11029 Elm St",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "203 S. 72nd",street_2 => undef}
{city => "Omaha",postal_code => 68144,region => "Nebraska",region_abbr => "NE",street_1 => "2819 S 125th Ave",street_2 => "#355"}
{city => "Omaha",postal_code => 68132,region => "Nebraska",region_abbr => "NE",street_1 => "5000 Underwood St",street_2 => undef}
{city => "Omaha",postal_code => 68104,region => "Nebraska",region_abbr => "NE",street_1 => "6113 Maple Street",street_2 => undef}
{city => "Omaha",postal_code => 68130,region => "Nebraska",region_abbr => "NE",street_1 => "1200 S. 157th St.",street_2 => undef}
{city => "Omaha",postal_code => undef,region => "Nebraska",region_abbr => "NE",street_1 => "4636 Dodge St",street_2 => undef}
{city => "Omaha",postal_code => 68132,region => "Nebraska",region_abbr => "NE",street_1 => "201 South 72nd Street",street_2 => undef}
{city => "Omaha",postal_code => 68130,region => "Nebraska",region_abbr => "NE",street_1 => "2717 South 177th Street",street_2 => undef}
{city => "Omaha",postal_code => 68144,region => "Nebraska",region_abbr => "NE",street_1 => "13203 West Center Road",street_2 => undef}
{city => "Omaha",postal_code => 68132,region => "Nebraska",region_abbr => "NE",street_1 => "7010 Dodge Street",street_2 => undef}
{city => "Omaha",postal_code => 68135,region => "Nebraska",region_abbr => "NE",street_1 => "6610 S 168th St",street_2 => undef}
{city => "Omaha",postal_code => 68118,region => "Nebraska",region_abbr => "NE",street_1 => "225 N. 170th Street",street_2 => undef}
{city => "Henderson",postal_code => 89014,region => "Nevada",region_abbr => "NV",street_1 => "517 North Stephanie St",street_2 => undef}
{city => "Henderson",postal_code => 89012,region => "Nevada",region_abbr => "NV",street_1 => "100 S. Green Valley Parkway",street_2 => undef}
{city => "Incline Village",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "901 Tahoe Blvd.",street_2 => undef}
{city => "Las Vegas",postal_code => 89121,region => "Nevada",region_abbr => "NV",street_1 => "4130 S. Sandhill Rd.",street_2 => undef}
{city => "Las Vegas",postal_code => 89102,region => "Nevada",region_abbr => "NV",street_1 => "324 W. Sahara Ave.",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "4600 Spring Mountain Rd",street_2 => undef}
{city => "Las Vegas",postal_code => 89128,region => "Nevada",region_abbr => "NV",street_1 => "7250 W Lake Mead Blvd",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "252 Convention Center Dr.",street_2 => "#8B"}
{city => "Las Vegas",postal_code => 89119,region => "Nevada",region_abbr => "NV",street_1 => "730 E. Flamingo Road",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "4647 Paradise Rd",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "2218 Paradise Rd",street_2 => undef}
{city => "Las Vegas",postal_code => 89101,region => "Nevada",region_abbr => "NV",street_1 => "801 S. Las Vegas Blvd. #110",street_2 => undef}
{city => "Las Vegas",postal_code => 89119,region => "Nevada",region_abbr => "NV",street_1 => "5006 S Maryland Parkway",street_2 => undef}
{city => "Las Vegas",postal_code => 89117,region => "Nevada",region_abbr => "NV",street_1 => "8855 West Charleston Blvd.",street_2 => undef}
{city => "Las Vegas",postal_code => "89109-8941",region => "Nevada",region_abbr => "NV",street_1 => "3355 Las Vegas Boulevard South",street_2 => undef}
{city => "Las Vegas",postal_code => 89147,region => "Nevada",region_abbr => "NV",street_1 => "W Flamingo and S Ft Apache Area",street_2 => undef}
{city => "Las Vegas",postal_code => 89102,region => "Nevada",region_abbr => "NV",street_1 => "4601 Spring Mountain Road",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3131 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => 89119,region => "Nevada",region_abbr => "NV",street_1 => "3950 Las Vegas Boulevard South",street_2 => "Mandalay Place"}
{city => "Las Vegas",postal_code => 89117,region => "Nevada",region_abbr => "NV",street_1 => "7875 W. Sahara Avenue",street_2 => "Suite 103"}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "1100 E. Sahara Ave",street_2 => undef}
{city => "Las Vegas",postal_code => 89119,region => "Nevada",region_abbr => "NV",street_1 => "4147 S. Maryland Parkway",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "4080 Paradise Road",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3790 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => 89104,region => "Nevada",region_abbr => "NV",street_1 => "953 E Sahara Ave",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3790 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3799 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => 89120,region => "Nevada",region_abbr => "NV",street_1 => "3130 E. Sunset Road",street_2 => "Suite A"}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3790 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3667 Las Vegas Blvd. S.",street_2 => undef}
{city => "Las Vegas",postal_code => 89123,region => "Nevada",region_abbr => "NV",street_1 => "2381 E. Windmill Lane",street_2 => undef}
{city => "Las Vegas",postal_code => 89117,region => "Nevada",region_abbr => "NV",street_1 => "2910 Lake East Drive",street_2 => undef}
{city => "Reno",postal_code => 89502,region => "Nevada",region_abbr => "NV",street_1 => "6139 S. Virginia Street",street_2 => undef}
{city => "Reno",postal_code => 89503,region => "Nevada",region_abbr => "NV",street_1 => "501 W. 1st St.",street_2 => undef}
{city => "Reno",postal_code => 89502,region => "Nevada",region_abbr => "NV",street_1 => "1170 S Wells Ave",street_2 => "#2"}
{city => "Reno",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "West Street",street_2 => undef}
{city => "Reno",postal_code => 89502,region => "Nevada",region_abbr => "NV",street_1 => "3940 Spring Drive #6",street_2 => undef}
{city => "Concord",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "128H Hall Street",street_2 => undef}
{city => "Derry",postal_code => "03038",region => "New Hampshire",region_abbr => "NH",street_1 => "Shaws Plaza",street_2 => undef}
{city => "Gorham",postal_code => "03581",region => "New Hampshire",region_abbr => "NH",street_1 => "19 Exchange St",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "7 South Main Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "35 South Main Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "27 Lebanon Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "45 South Park Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "3 Lebanon Street",street_2 => undef}
{city => "Lebanon",postal_code => "03766",region => "New Hampshire",region_abbr => "NH",street_1 => "12 Centerra Parkway",street_2 => undef}
{city => "Lebanon",postal_code => "03766",region => "New Hampshire",region_abbr => "NH",street_1 => "410 Miracle Mile",street_2 => undef}
{city => "Nashua",postal_code => "03060",region => "New Hampshire",region_abbr => "NH",street_1 => "138 Main St",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "29 Ceres Street",street_2 => undef}
{city => "West Lebanon",postal_code => "03784",region => "New Hampshire",region_abbr => "NH",street_1 => "96 Main Street",street_2 => undef}
{city => "Asbury Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1119 State Route 35",street_2 => undef}
{city => "Asbury Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "311 Bond Street",street_2 => undef}
{city => "Asbury Park",postal_code => "07712",region => "New Jersey",region_abbr => "NJ",street_1 => "609 Cookman Avenue",street_2 => undef}
{city => "Atlantic City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2801 Arctic Avenue",street_2 => undef}
{city => "Atlantic City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2801 North Pacific Avenue",street_2 => "The Quarter at the Tropicana"}
{city => "Barrington",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "131 Clements Bridge Rd.",street_2 => undef}
{city => "Bayonne",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "486 Broadway",street_2 => undef}
{city => "Beach Haven",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "4 W Maryland Ave",street_2 => undef}
{city => "Belmar",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "702 10th Avenue",street_2 => undef}
{city => "Belmar",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "817 Belmar Plaza",street_2 => undef}
{city => "Belvidere",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "505 Rt. 46",street_2 => undef}
{city => "Bordentown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "370 Farnsworth Ave",street_2 => undef}
{city => "Branchburg",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1010 Rt 202 S",street_2 => undef}
{city => "Brick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "280 Brick Blvd",street_2 => undef}
{city => "Brick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "383 Brick Blvd",street_2 => undef}
{city => "Brick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2063 Route 88,",street_2 => undef}
{city => "Bridgetown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Bridgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "793 Rt. 202 N",street_2 => undef}
{city => "Bridgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "125 N. Gaston Ave.",street_2 => undef}
{city => "Bridgewater",postal_code => "08807",region => "New Jersey",region_abbr => "NJ",street_1 => "1351 Prince Rogers Ave",street_2 => undef}
{city => "Bridgewater",postal_code => "08807",region => "New Jersey",region_abbr => "NJ",street_1 => "327 Rtes 202/206 (Somerville Circle) Somerset Shopping Center",street_2 => "Somerset Shopping Center"}
{city => "Butler",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "192 Main St",street_2 => undef}
{city => "Califon",postal_code => "07830",region => "New Jersey",region_abbr => "NJ",street_1 => "438 County Highway 513",street_2 => undef}
{city => "Cape May",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "104 Jackson St.",street_2 => undef}
{city => "Cedar Grove",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "479 Pompton Ave.",street_2 => undef}
{city => "Cherry Hill",postal_code => "08003",region => "New Jersey",region_abbr => "NJ",street_1 => "1990 Marlton Pike East",street_2 => "Village Walk Shopping Center"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "829 Crossroads Plaza Church & Cooper",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1900 Greentree Rd",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "219 Berlin Road",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1030 Marlton Pike (Route 70)",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2389 Rt 70 W",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "219 Haddonfield-Berlin Rd, The Centrum Shoppes",street_2 => "The Centrum Shoppes"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "404 Route 70 E",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1631A N. King's Highway",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1400 Berlin Rd., Woodcrest Shopping Center",street_2 => "Woodcrest Shopping Center"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "208 Kresson",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2431 Church Rd.",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1900 Greentree Rd., at Springdale Plaza",street_2 => "Springdale Plaza"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1871 E. Rt. 70",street_2 => undef}
{city => "Cherry Hill",postal_code => "08003",region => "New Jersey",region_abbr => "NJ",street_1 => "1900 Greentree Road",street_2 => "Springdale Plaza"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2442 Rt. 38, Plaza 38",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1900 Greentree Rd.",street_2 => "Springdale Plaza"}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Rt. 70 E, 85 Barclay Farms Shopping Center",street_2 => undef}
{city => "Cherry Hill",postal_code => "08003",region => "New Jersey",region_abbr => "NJ",street_1 => "101 Springdale Rd.",street_2 => undef}
{city => "Cherry Hill",postal_code => "08034",region => "New Jersey",region_abbr => "NJ",street_1 => "1300 Marlton Pike E",street_2 => "Barclay Shopping Center"}
{city => "Cherry Hill",postal_code => "08034",region => "New Jersey",region_abbr => "NJ",street_1 => "1426 Marlton Pike E",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "600 Kings Hwy N",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "480 East Evesham Road",street_2 => undef}
{city => "Cherry Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2117 Route 70 West",street_2 => undef}
{city => "Chester",postal_code => "07930",region => "New Jersey",region_abbr => "NJ",street_1 => "137 Main Street",street_2 => undef}
{city => "Chester",postal_code => "07930",region => "New Jersey",region_abbr => "NJ",street_1 => "Chester Springs Shopping Center, Route 206",street_2 => "Chester Springs Shopping Center"}
{city => "Clifton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "20 First Ave.",street_2 => undef}
{city => "Collingswood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "37 W. Crescent Blvd.",street_2 => undef}
{city => "Collingswood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "729 Haddon Ave.",street_2 => undef}
{city => "Collingswood",postal_code => "08106",region => "New Jersey",region_abbr => "NJ",street_1 => "690 Haddon Ave.",street_2 => undef}
{city => "Collingswood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "703 Haddon Avenue",street_2 => undef}
{city => "Collingswood",postal_code => "08108",region => "New Jersey",region_abbr => "NJ",street_1 => "786 Haddon Ave",street_2 => undef}
{city => "Colonia",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "572 Inman Ave.",street_2 => undef}
{city => "Denville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "57 Bloomfield Avenue",street_2 => undef}
{city => "Denville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "60 Diamond Spring Rd",street_2 => undef}
{city => "Denville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "20 1st Ave",street_2 => undef}
{city => "Denville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "21 Bloomfield Ave",street_2 => undef}
{city => "Deptford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1692 Clements Bridge Rd, Suite C, Locust Grove Plaza",street_2 => "Suite C, Locust Grove Plaza"}
{city => "Deptford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1692 B Clements Bridge Road",street_2 => "(Next to Staples)"}
{city => "Deptford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1907 Deptford Center Road",street_2 => "(next to Staples)"}
{city => "East Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1020 Rt. 18 N",street_2 => undef}
{city => "East Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "77 Tices Ln.",street_2 => undef}
{city => "East Orange",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "516 Main St.",street_2 => undef}
{city => "East Rutherford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "220 Park Ave.",street_2 => undef}
{city => "East Windsor",postal_code => "08520",region => "New Jersey",region_abbr => "NJ",street_1 => "440 Rt. 130 S at Rt. 571",street_2 => undef}
{city => "East Windsor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "370 East Windsor Town Plaza, Rt. 130 S at Rt. 571",street_2 => undef}
{city => "Eatontown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Eatontown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "26 State Route 35",street_2 => undef}
{city => "Edgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "595 River Rd.",street_2 => undef}
{city => "Edgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "725 River Road",street_2 => undef}
{city => "Edgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "715 River Road",street_2 => undef}
{city => "Edgewater",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "905 River Rd",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "21 Cortland St.",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "775 Rt. 1 South at Old Post Rd., Shoprite Plaza",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1069 Inman Ave, Inman Grove Shopping Center",street_2 => "Inman Grove Shopping Center"}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1679 Oak Tree Rd.",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "9 Lincoln Hwy (Rt. 27) at Parsonage Rd, Colonial Village Shopping Center",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1655-195 Oak Tree Rd.",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "35 Morris St.",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1670A Oak Tree Rd",street_2 => undef}
{city => "Edison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1876 Lincoln Hwy (Rt. 27)",street_2 => undef}
{city => "Egg Harbor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3112 Fire Rd",street_2 => undef}
{city => "Egg Harbor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "6666 Black Horse Pike",street_2 => undef}
{city => "Egg Harbor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "6725 Blackhorse Pike (food court at the Shore Mall)",street_2 => "Shore Mall"}
{city => "Ewing",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "19 Arctic Parkway",street_2 => undef}
{city => "Ewing",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1870 Olden Ave.",street_2 => undef}
{city => "Ewing",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1505 Parkway Ave",street_2 => undef}
{city => "Fair Lawn",postal_code => "07410",region => "New Jersey",region_abbr => "NJ",street_1 => "22-18 Broadway",street_2 => undef}
{city => "Fair Lawn",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "14-20 Plaza Rd.",street_2 => undef}
{city => "Fair Lawn",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "23-59 Fair Lawn Ave.",street_2 => undef}
{city => "Fair Lawn",postal_code => "07410",region => "New Jersey",region_abbr => "NJ",street_1 => "23-25 Broadway",street_2 => undef}
{city => "Flemington",postal_code => "08822",region => "New Jersey",region_abbr => "NJ",street_1 => "276 US Highway 202/31",street_2 => undef}
{city => "Florham Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "187 Columbia Turnpike",street_2 => undef}
{city => "Florham Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "186 Columbia Turnpike",street_2 => undef}
{city => "Franklin Park",postal_code => "08823",region => "New Jersey",region_abbr => "NJ",street_1 => "3151 Route 27",street_2 => undef}
{city => "Franklin Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Franklin Plaza",street_2 => undef}
{city => "Franklin Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3175-3 Rt. 27 South",street_2 => undef}
{city => "Franklin Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3051 Route 27 S.",street_2 => undef}
{city => "Franklin Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3391 Rt. 27, Franklin Towne Center",street_2 => "Franklin Towne Center"}
{city => "Freehold",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "4345 Route 9 N",street_2 => undef}
{city => "Freehold",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "160 Village Center Drive/ Route 537",street_2 => "Raintree Shopping Plaza"}
{city => "Freehold",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3710 Route 9",street_2 => "Freehold Raceway Mall"}
{city => "Freehold",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3585 Route 9 North",street_2 => undef}
{city => "Glassboro",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "800 North Delsea Dr, Doubletree Shopping Center",street_2 => "Doubletree Shopping Center"}
{city => "Glen Ridge",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "912 Prospect St.",street_2 => undef}
{city => "Glen Ridge",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "289 Washington St.",street_2 => undef}
{city => "Green Brook",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "319 Rt. 22 E. (Sansome Plaza)",street_2 => "Sansome Plaza"}
{city => "Hackensack",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "342 Main St.",street_2 => undef}
{city => "Hackettstown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1954 Route 57",street_2 => undef}
{city => "Haddonfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "215 Kings Highway E",street_2 => undef}
{city => "Haddonfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "113 Kings Highway East",street_2 => undef}
{city => "Hainesport",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1299 Rt 38. Shops at Creek Crossing",street_2 => "Shops at Creek Crossing"}
{city => "Hamilton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3800 Quakerbridge Rd",street_2 => undef}
{city => "Hamilton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2614 Quaker Bridge Rd.",street_2 => undef}
{city => "Hammonton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "200 S White Horse Pike Ste C7",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "231 Raritan Ave",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "217 Raritan Ave.",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "441 Raritan Ave, Rt. 27",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1167 Raritan Ave, Rt. 27",street_2 => undef}
{city => "Highland Park",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "401 Raritan Ave",street_2 => undef}
{city => "Hightstown",postal_code => "08520",region => "New Jersey",region_abbr => "NJ",street_1 => "549 US Highway 130",street_2 => undef}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "390 Rt. 206 S, Hillsborough Plaza Shopping Center",street_2 => "Hillsborough Plaza Shopping Center"}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "434 Route 206 S.",street_2 => undef}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "601 Rt. 206 at Amwell Rd, Nelson's Corner Shopping Center",street_2 => undef}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "284 Rt. 206 S",street_2 => undef}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Amwell Rd. (Rt 514)",street_2 => undef}
{city => "Hillsborough",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "649 Rt 206 N",street_2 => undef}
{city => "Hoboken",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "204 Washington St",street_2 => undef}
{city => "Hoboken",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "229 Washington St",street_2 => undef}
{city => "Hopewell",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "7 West Broad St.",street_2 => undef}
{city => "Howell",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2450 Route 9 South",street_2 => undef}
{city => "Howell",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2450 Route 9 South",street_2 => undef}
{city => "Iselin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1384B Oak Tree Rd",street_2 => undef}
{city => "Iselin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1507 Oak Tree Rd",street_2 => undef}
{city => "Iselin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1373 Oak Tree Rd",street_2 => undef}
{city => "Iselin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "825 US Highway 1",street_2 => undef}
{city => "Iselin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1538 Oak Tree Rd",street_2 => undef}
{city => "Jersey City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "82 Hutton St.",street_2 => undef}
{city => "Jersey City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "777 Newark Ave",street_2 => undef}
{city => "Jersey City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "791 Newark Ave",street_2 => undef}
{city => "Jersey City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "812 Newark Avenue",street_2 => undef}
{city => "Jersey City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "806 Newark Ave.",street_2 => undef}
{city => "Kenilworth",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "550 Boulevard (Rt. 509)",street_2 => undef}
{city => "Kingston",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "4437 Rt. 27, Kingston Mall",street_2 => undef}
{city => "Lakewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1709 Clifton Ave",street_2 => undef}
{city => "Lambertville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "239 N Union St",street_2 => undef}
{city => "Lambertville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "61 N. Main St.",street_2 => undef}
{city => "Lawrenceville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3349-66 Brunswick Pike, Rt. 1 S",street_2 => undef}
{city => "Lawrenceville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "540 Lawrence Square Blvd S",street_2 => undef}
{city => "Lawrenceville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2495 Business Rt. 1 S, at Texas Ave., Lawrence Shopping Center",street_2 => "Lawrence Shopping Center"}
{city => "Lawrenceville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2495 Business Rt. 1 S, at Texas Ave., Lawrence Shopping Center",street_2 => "Lawrence Shopping Center"}
{city => "Lincroft",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "650 Newman Springs Rd.",street_2 => undef}
{city => "Lindenwold",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Blackwood-Clementon & Laurel Roads",street_2 => undef}
{city => "Lindenwold",postal_code => "08021",region => "New Jersey",region_abbr => "NJ",street_1 => "40 East Gibbsboro Road",street_2 => undef}
{city => "Little Silver",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "625 Branch Ave.",street_2 => undef}
{city => "Livingston",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "99 W. Mt.  Pleasant Ave.",street_2 => undef}
{city => "Long Branch",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "139 Brighton Avenue",street_2 => undef}
{city => "Madison",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "222 Main St",street_2 => undef}
{city => "Manahawkin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "777 East Bay Ave.",street_2 => undef}
{city => "Manahawkin",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "511 Route 72 East",street_2 => undef}
{city => "Manalapan",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "299 Route 9 South",street_2 => undef}
{city => "Manasquan",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "181 Main St,",street_2 => undef}
{city => "Mantoloking",postal_code => "08738",region => "New Jersey",region_abbr => "NJ",street_1 => "34 Highway 35 South",street_2 => undef}
{city => "Maple Shade",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Kings Highway and Lenola Rd.",street_2 => undef}
{city => "Maple Shade",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2920 Rt. 73",street_2 => undef}
{city => "Maple Shade",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "28 E. Main St.",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "150 Rt. 73 N.",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "145 Rt. 73 S., Marlton Crossing Shopping Center",street_2 => "Marlton Crossing Shopping Center"}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "896 Greentree Square Shopping Center",street_2 => "Greentree Square Shopping Center"}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "148 Rt. 73 N.",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "State highway 70 and Cropwell Rd.",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "500 Route 73 South; The Promenade at Sagemore",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "746 W Route 70, Evesham Plaza",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "300 Rt-73 S",street_2 => undef}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "940 Route 73, Greentree Shopping Center",street_2 => "Greentree Shopping Center"}
{city => "Marlton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Rt.70 E, Plaza 70",street_2 => undef}
{city => "Marlton",postal_code => "08053",region => "New Jersey",region_abbr => "NJ",street_1 => "746 W RT-70",street_2 => "Evesham Plaza"}
{city => "Martinsville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1982 Washington Valley Rd.",street_2 => undef}
{city => "Matawan",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "952 State Highway 34",street_2 => undef}
{city => "Mays Landing",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3914 Black Horse Pike",street_2 => undef}
{city => "Medford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "200 Tuckerton Rd, The Village of Taunton Forge Shopping Center",street_2 => "The Village of Taunton Forge Shopping Center"}
{city => "Medford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "175-6 Rt. 70 E., Sharp's Run Plaza",street_2 => "Sharp's Run Plaza"}
{city => "Medford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "510 Stokes Rd,",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "439 Main St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "387 Main St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "12 Center St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "435 Main St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "449 Main St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "10 Pearl St.",street_2 => undef}
{city => "Metuchen",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "455 Main St.",street_2 => undef}
{city => "Middletown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1521 Highway 35",street_2 => undef}
{city => "Milford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "57 Bridge St.",street_2 => undef}
{city => "Millburn",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "44 Main St.",street_2 => undef}
{city => "Millburn",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "187 Millburn Ave",street_2 => undef}
{city => "Millville",postal_code => "08332",region => "New Jersey",region_abbr => "NJ",street_1 => "16 N. High St.",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "7 North Willow St.",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "515 Bloomfield Ave",street_2 => undef}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "701 Bloomfield Avenue",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "10 Church St.",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "307C Orange Rd",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "600 Bloomfield Ave.",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "511 Bloomfield Ave",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "631 Valley Road",street_2 => undef}
{city => "Montvale",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "22 Chestnut Ridge Rd.",street_2 => undef}
{city => "Morris Plains",postal_code => "07950",region => "New Jersey",region_abbr => "NJ",street_1 => "2920 Route 10 West",street_2 => "Powder Mill Plaza West"}
{city => "Morris Plains",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2920 Rt. 10 W, Powder Mill Plaza West",street_2 => "Powder Mill Plaza West"}
{city => "Morristown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "79 Washington St. (Rt. 24W)",street_2 => undef}
{city => "Morristown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "6-14 South St.",street_2 => undef}
{city => "Morristown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "85 Washington (Rt. 24 W)",street_2 => undef}
{city => "Morristown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "66 Morris St",street_2 => undef}
{city => "Mt. Holly",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1690 Armory Plaza, Rt. 38",street_2 => "Armory Plaza"}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Rt. 38 and Ark Rd, Larchmont Commons Shopping Center",street_2 => "Larchmont Commons Shopping Center"}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1155 North Rt. 73, Ramblewood Center",street_2 => undef}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "720 S Church St",street_2 => undef}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1155 Rt. 73, Ramblewood Shopping Center",street_2 => "Ramblewood Shopping Center"}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "992 Union Mill Rd. at Elbo Ln; Towne Square Shopping Center",street_2 => undef}
{city => "Mt. Laurel",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3131 Rt. 38 and Larchmont Blvd.",street_2 => undef}
{city => "MT. LAUREL",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3050 Rt 38",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "385 George Street",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "45 Easton Ave.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1 Elm Row.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "89 Morris St",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "Albany St. (Rt. 27), Ferren Mall",street_2 => "Penn Plaza"}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "351 George St.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "106 Albany St. (Rt. 27) at George St.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "349A George St",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "375 George St.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "38 Easton Avenue",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "49 Easton Ave.",street_2 => undef}
{city => "New Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "138 Easton Ave.",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "49 Bayard Street",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "338 George Street",street_2 => undef}
{city => "Newark",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "127 Halsey St",street_2 => undef}
{city => "Newark",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "840 Broad St",street_2 => undef}
{city => "Newark",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "55 Halsey St.",street_2 => undef}
{city => "Newark",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "579 S. Orange Ave.",street_2 => undef}
{city => "Newark",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "97-99 Monroe St",street_2 => undef}
{city => "Newton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "30 Morran St.",street_2 => undef}
{city => "North Arlington",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "77 Ridge Rd.",street_2 => undef}
{city => "North Arlington",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "33 Ridge Rd.",street_2 => undef}
{city => "North Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1980 Rt. 27, Plaza 27 (near Cozzens Ln)",street_2 => "Plaza 27"}
{city => "North Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2313 Rt. 1 South",street_2 => undef}
{city => "North Brunswick",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2313 US Highway 1 South",street_2 => undef}
{city => "Northfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1205 Tilton Rd,",street_2 => undef}
{city => "Northfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1332 Tilton Rd",street_2 => undef}
{city => "Northfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "331 Tilton Rd",street_2 => undef}
{city => "Northvale",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "246 Livingston St.",street_2 => undef}
{city => "Nutley",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "231 Franklin Ave.",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "403 14th St.",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "621 8th St, Ocean City",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "501 E 9th Street",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "301 E 10th Ave",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "914 Asbury Avenue",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "503 9th St",street_2 => undef}
{city => "Ocean City",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "E. 9th St. and Central Ave.",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "946 Boardwalk",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "1200 Asbury Avenue",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "403 14th St.",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "822 9th Street",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "E 9th St and Central Ave",street_2 => undef}
{city => "Ocean City",postal_code => "08226",region => "New Jersey",region_abbr => "NJ",street_1 => "712 Ninth Street",street_2 => undef}
{city => "Ocean Grove",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "60 Main Avenue",street_2 => undef}
{city => "Parsippany",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "48 North Beverwyck Rd.",street_2 => undef}
{city => "Parsippany",postal_code => "07054",region => "New Jersey",region_abbr => "NJ",street_1 => "1119 US Highway 46",street_2 => undef}
{city => "Parsippany",postal_code => "07054",region => "New Jersey",region_abbr => "NJ",street_1 => "257 Littleton Road",street_2 => undef}
{city => "Pemberton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "33 W. Hampton St (Rt. 530)",street_2 => undef}
{city => "Pennsauken",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "7519 Maple Ave.",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1347 Stelton Road",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1296 Centennial Ave.",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1353 Stelton Rd.",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1297 Centennial Ave.",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1665 Stelton Road",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1347 Stelton Rd",street_2 => undef}
{city => "Piscataway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1316 Centennial Ave.",street_2 => undef}
{city => "Plainsboro",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "660 Plainsboro Rd, Princeton Meadow Shopping Center",street_2 => "Princeton Meadow Shopping Center"}
{city => "Plainsboro",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "10 Schalks Crossing Rd, Plainsboro Plaza",street_2 => "Plainsboro Plaza"}
{city => "Plainsboro",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "10 Schalks Crossing Rd, Plainsboro Plaza",street_2 => "Plainsboro Plaza"}
{city => "Plainsboro",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "660 Plainsboro Rd, Princeton Meadow Shopping Center",street_2 => "Princeton Meadow Shopping Center"}
{city => "Pleasantville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "6725 Black Horse Pike",street_2 => undef}
{city => "Point Pleasant",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "519 Arnold Ave",street_2 => undef}
{city => "Point Pleasant",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2319 Bridge Ave",street_2 => undef}
{city => "Pompton Lakes",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "258 Wanaque Ave",street_2 => undef}
{city => "Pompton Plains",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "564 Rte 23 North",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "301 N. Harrison St",street_2 => "Princeton Shopping Center"}
{city => "Princeton",postal_code => "08540",region => "New Jersey",region_abbr => "NJ",street_1 => "360 Nassau St",street_2 => undef}
{city => "Princeton",postal_code => "08540",region => "New Jersey",region_abbr => "NJ",street_1 => "301 North Harrison St.",street_2 => undef}
{city => "Princeton",postal_code => "08540",region => "New Jersey",region_abbr => "NJ",street_1 => "3495 US Route 1 South",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "235A Nassau St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "36 Witherspoon St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Princeton Shopping Center, North Harrison St.",street_2 => "Princeton Shopping Center"}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "19 Chambers St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "255 Nassau St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "22 Witherspoon St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3545 US Highway 1",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "15 Farber Rd",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "235 Nassau St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "260 Nassau St.",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "354 Nassau St",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3495 Rt. 1 South",street_2 => undef}
{city => "Princeton",postal_code => "08540",region => "New Jersey",region_abbr => "NJ",street_1 => "255 Nassau St",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "301 N Harrison St, Princeton Shopping Center",street_2 => undef}
{city => "Princeton Junction",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "33 Princeton-Hightstown Rd.",street_2 => undef}
{city => "Rahway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1465 Irving St.",street_2 => undef}
{city => "Ramsey",postal_code => "07446",region => "New Jersey",region_abbr => "NJ",street_1 => "495 N. Franklin Turnpike",street_2 => undef}
{city => "Raritan",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "182 Orlando Dr, Stop and Shop Plaza",street_2 => "Stop and Shop Plaza"}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "471 Route 35 North",street_2 => undef}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "7 Broad Street",street_2 => undef}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "110 Monmouth St.",street_2 => undef}
{city => "Red Bank",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "7 East Front St.",street_2 => undef}
{city => "Red Bank",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "17 East Front Street",street_2 => undef}
{city => "Red Bank",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "65 Broad St",street_2 => undef}
{city => "Red Bank",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "471 Route 35 North",street_2 => undef}
{city => "Ridgewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "158 Franklin Ave.",street_2 => undef}
{city => "Ridgewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "21 East Ridgewood Ave.",street_2 => undef}
{city => "Ridgewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1 West Ridgewood Ave.",street_2 => undef}
{city => "Ridgewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "32-34 Chestnut St.",street_2 => undef}
{city => "Ridgewood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "44 Godwin Place",street_2 => undef}
{city => "River Edge",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "636 Kinderkamack Rd.",street_2 => undef}
{city => "Rockaway",postal_code => "07866",region => "New Jersey",region_abbr => "NJ",street_1 => "301 Mount Hope Ave",street_2 => "#2066A"}
{city => "Rockaway",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "296 Route 46 East",street_2 => undef}
{city => "Rocky Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "137 Washington St.",street_2 => undef}
{city => "Runnemede",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "835 E. Clements Bridge Rd, Runnemede Plaza",street_2 => "Runnemede Plaza"}
{city => "Rutherford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "240 Hackensack St",street_2 => undef}
{city => "Rutherford",postal_code => "07070",region => "New Jersey",region_abbr => "NJ",street_1 => "153 Park Ave",street_2 => undef}
{city => "Scotch Plains",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1625 2nd St.",street_2 => undef}
{city => "Shrewsbury",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "490 Broad St",street_2 => undef}
{city => "Sicklerville",postal_code => "08081",region => "New Jersey",region_abbr => "NJ",street_1 => "611 Cross Keys Rd",street_2 => "Suite A100"}
{city => "Skillman",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1273 Rt. 206",street_2 => undef}
{city => "Skillman",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1325 Rt. 206 N, Montgomery Center",street_2 => "Montgomery Center"}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "841 Hamilton St.",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3151 Rt. 27",street_2 => undef}
{city => "Somerset",postal_code => "08873",region => "New Jersey",region_abbr => "NJ",street_1 => "2 JFK Blvd, Highwood Plaza",street_2 => "Highwood Plaza"}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "120 Cedar Grove Lane",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1075 Easton Ave",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1483 Rt. 27 S., Franklin Mall",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1075 Easton Ave.",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1991 Rte 27 South",street_2 => undef}
{city => "Somerset",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1189 Franklin Plaza, Rt. 27 and Veronica Ave.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "30 E. Main St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "9 Davenport St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "212 W. Main St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "25 Divison St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "24 E. Main St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "194 W. Main St.",street_2 => undef}
{city => "Somerville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "12 W. Main St.",street_2 => undef}
{city => "South Bound Brook",postal_code => "08880",region => "New Jersey",region_abbr => "NJ",street_1 => "89 Main St.",street_2 => undef}
{city => "South Orange",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "9 Village Plaza",street_2 => undef}
{city => "South Orange",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "300 Sloan St",street_2 => undef}
{city => "South Plainfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "4941 Stelton Rd., Hadley Center",street_2 => "Hadley Center"}
{city => "South Plainfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "3600 Park Avenue",street_2 => undef}
{city => "South Plainfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2239 S. Clinton Ave.",street_2 => undef}
{city => "Sparta",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "155B Woodport Rd",street_2 => undef}
{city => "Spring Lake Heights",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2407 Highway 71",street_2 => undef}
{city => "Springfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "518 Millburn Ave",street_2 => undef}
{city => "Stone Harbor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "302 96th St",street_2 => undef}
{city => "Stratford",postal_code => "08084",region => "New Jersey",region_abbr => "NJ",street_1 => "33 South White Horse Pike",street_2 => undef}
{city => "Teaneck",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "408 Cedar Lane",street_2 => undef}
{city => "Teaneck",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "172 West Englewood Ave.",street_2 => undef}
{city => "Teaneck",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "496 Cedar Lane",street_2 => undef}
{city => "Teaneck",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "454 Cedar Lane",street_2 => undef}
{city => "Teaneck",postal_code => "07666",region => "New Jersey",region_abbr => "NJ",street_1 => "482 Cedar Lane",street_2 => undef}
{city => "Teaneck",postal_code => "07666",region => "New Jersey",region_abbr => "NJ",street_1 => "473 Cedar Lane",street_2 => undef}
{city => "Tenafly",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "35 Riveredge Rd.",street_2 => undef}
{city => "Toms River",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "313-A West Water St",street_2 => undef}
{city => "Toms River",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1 Washington St",street_2 => undef}
{city => "Toms River",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "675 Batchelor St",street_2 => undef}
{city => "Tranquility",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "State Highway 517 North",street_2 => undef}
{city => "Trenton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "2160 Brunswick Ave.",street_2 => undef}
{city => "Trenton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1100 Highway 33",street_2 => undef}
{city => "Turnersville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "4860 Rt. 42 N.",street_2 => undef}
{city => "Union",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1350 Galloping Hill Rd.",street_2 => undef}
{city => "Upper Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "594 Valley Rd.",street_2 => undef}
{city => "Vineland",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1201 North Delsea Dr. (Rt. 47)",street_2 => undef}
{city => "Vineland",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1406 S Main Rd",street_2 => undef}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "700 Haddonfield-Berlin Rd. (Route 561), Eagle Plaza",street_2 => "Eagle Plaza"}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "910 Berlin Rd.",street_2 => undef}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1120 White Horse Rd, Echelon Village Plaza",street_2 => undef}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "28 Eagle Plaza",street_2 => undef}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Haddonfield-Berlin Rd and White Horse Rd, Eagle Plaza",street_2 => "Eagle Plaza"}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "8015 Centennial Blvd.",street_2 => undef}
{city => "Voorhees",postal_code => "08043",region => "New Jersey",region_abbr => "NJ",street_1 => "910 Haddonfield Berlin Road",street_2 => "(Ritz Center)"}
{city => "Voorhees",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "200 Haddonfield Berlin Road",street_2 => undef}
{city => "Waretown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "304 Route 9 Ste 11",street_2 => undef}
{city => "Warren",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "41 Mountain Blvd, Village Square Mall",street_2 => "Village Square Mall"}
{city => "Wayne",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1172 Hamburg Turnpike",street_2 => undef}
{city => "Wayne",postal_code => "07470",region => "New Jersey",region_abbr => "NJ",street_1 => "24 US-46",street_2 => undef}
{city => "West Caldwell",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "771 Bloomfield Avenue",street_2 => "Broadway Square Mall"}
{city => "West Milford",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "22 Marshall Hill Rd",street_2 => undef}
{city => "West Orange",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "235 Prospect Ave",street_2 => undef}
{city => "West Windsor",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "295 Princeton Hightstown Rd.",street_2 => undef}
{city => "Westfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "35 Elm St.",street_2 => undef}
{city => "Westfield",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "155 Elm Street",street_2 => undef}
{city => "Westwood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "20 Irvington Street",street_2 => undef}
{city => "Whitehouse",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Rt. 22 W",street_2 => undef}
{city => "Wildwood",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "Rio Grande and New Jersey Ave.",street_2 => undef}
{city => "Woodbridge",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "34 Main St.",street_2 => undef}
{city => "Albuquerque",postal_code => 87109,region => "New Mexico",region_abbr => "NM",street_1 => "5815 Wyoming Blvd. NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "1606 Central Ave. SE",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "2114 Central Ave SE",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "2110 Central Ave SE",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "142 Harvard Dr SE",street_2 => undef}
{city => "Albuquerque",postal_code => 87109,region => "New Mexico",region_abbr => "NM",street_1 => "6910 Montgomery Blvd NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "2201 Silver Ave NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87108,region => "New Mexico",region_abbr => "NM",street_1 => "513 San Mateo Blvd NE",street_2 => undef}
{city => "Las Cruces",postal_code => 88001,region => "New Mexico",region_abbr => "NM",street_1 => "2540 El Paseo Rd",street_2 => undef}
{city => "Las Cruces",postal_code => 88001,region => "New Mexico",region_abbr => "NM",street_1 => "1245 El Paseo Rd",street_2 => undef}
{city => "Las Cruces",postal_code => 88001,region => "New Mexico",region_abbr => "NM",street_1 => "1300 El Paseo Rd",street_2 => undef}
{city => "Las Cruces",postal_code => 88001,region => "New Mexico",region_abbr => "NM",street_1 => "1300 El Paseo Rd",street_2 => undef}
{city => "Roswell",postal_code => undef,region => "New Mexico",region_abbr => "NM",street_1 => "102 N. Missouri Ave",street_2 => undef}
{city => "Santa Fe",postal_code => 87505,region => "New Mexico",region_abbr => "NM",street_1 => "1090 S St Francis Dr",street_2 => undef}
{city => "Santa Fe",postal_code => 87505,region => "New Mexico",region_abbr => "NM",street_1 => "333 W. Cordova Road",street_2 => undef}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "753 Cerrillos Rd",street_2 => undef}
{city => "Santa Fe",postal_code => 87505,region => "New Mexico",region_abbr => "NM",street_1 => "3095 Agua Fria St",street_2 => undef}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "323 McKenzie St.",street_2 => undef}
{city => "Santa Fe",postal_code => 87505,region => "New Mexico",region_abbr => "NM",street_1 => "821 W San Mateo Rd,",street_2 => undef}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "526 Galisteo St.",street_2 => undef}
{city => "Santa Fe",postal_code => undef,region => "New Mexico",region_abbr => "NM",street_1 => "905 West Alameda",street_2 => undef}
{city => "Silver City",postal_code => 88061,region => "New Mexico",region_abbr => "NM",street_1 => "601 N. Bullard St.",street_2 => undef}
{city => "Taos",postal_code => 87571,region => "New Mexico",region_abbr => "NM",street_1 => "101 Camino De La Placita",street_2 => undef}
{city => "Albany",postal_code => 12205,region => "New York",region_abbr => "NY",street_1 => "1343 Central Avenue",street_2 => undef}
{city => "Albany",postal_code => 12206,region => "New York",region_abbr => "NY",street_1 => "484 Central Avenue",street_2 => undef}
{city => "Albany",postal_code => 12203,region => "New York",region_abbr => "NY",street_1 => "1475 Western Avenue",street_2 => "Stuyvesant Plaza"}
{city => "Albany",postal_code => 12208,region => "New York",region_abbr => "NY",street_1 => "450 Madison Ave.",street_2 => undef}
{city => "Albany",postal_code => 12205,region => "New York",region_abbr => "NY",street_1 => "1095 Central Ave",street_2 => "# A"}
{city => "Albany",postal_code => 12210,region => "New York",region_abbr => "NY",street_1 => "258 Lark St.",street_2 => undef}
{city => "Albany",postal_code => 12210,region => "New York",region_abbr => "NY",street_1 => "187 Lark Street",street_2 => undef}
{city => "Albany",postal_code => 12210,region => "New York",region_abbr => "NY",street_1 => "206 Washington Avenue",street_2 => undef}
{city => "Amherst",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "3085 Sheridan Drive",street_2 => undef}
{city => "Amherst",postal_code => 14255,region => "New York",region_abbr => "NY",street_1 => "656 Millersport Highway",street_2 => undef}
{city => "Amherst",postal_code => 14226,region => "New York",region_abbr => "NY",street_1 => "3689 Sheridan Drive",street_2 => undef}
{city => "Ardsley",postal_code => 10502,region => "New York",region_abbr => "NY",street_1 => "466 Ashford Ave",street_2 => undef}
{city => "Astoria",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "46-03 Broadway",street_2 => undef}
{city => "Binghamton",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "176 Main St.",street_2 => undef}
{city => "Binghamton",postal_code => 13901,region => "New York",region_abbr => "NY",street_1 => "222 Water Street",street_2 => undef}
{city => "Binghamton",postal_code => 13903,region => "New York",region_abbr => "NY",street_1 => "43 South Washington Street",street_2 => undef}
{city => "Bronx",postal_code => 10467,region => "New York",region_abbr => "NY",street_1 => "754 Burke Avenue",street_2 => undef}
{city => "Bronx",postal_code => 10469,region => "New York",region_abbr => "NY",street_1 => "3565 Boston Road",street_2 => undef}
{city => "Bronx",postal_code => 10467,region => "New York",region_abbr => "NY",street_1 => "3584 White Plains Road",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "245 Grand Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "752 Union St.",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "128 Montague Street",street_2 => "First floor"}
{city => "Brooklyn",postal_code => 11226,region => "New York",region_abbr => "NY",street_1 => "2268 Church Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "191 Bedford Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11225,region => "New York",region_abbr => "NY",street_1 => "989 Nostrand Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11216,region => "New York",region_abbr => "NY",street_1 => "305 Halsey St",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "128 Montague Street",street_2 => "First floor"}
{city => "Brooklyn",postal_code => 11206,region => "New York",region_abbr => "NY",street_1 => "49 Bogart St.",street_2 => undef}
{city => "Brooklyn",postal_code => 11230,region => "New York",region_abbr => "NY",street_1 => "1802 Avenue M",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "79 North 11th Street",street_2 => "#1 Brewers Row"}
{city => "Brooklyn",postal_code => 11206,region => "New York",region_abbr => "NY",street_1 => "983 Flushing Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "151 Smith Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "295 Berry Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "273 13th Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11225,region => "New York",region_abbr => "NY",street_1 => "624 Flatbush Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11222,region => "New York",region_abbr => "NY",street_1 => "155 Calyer Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "212 Bedford Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "460 Bergen Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "Williamsburg",street_2 => undef}
{city => "Brooklyn",postal_code => 11226,region => "New York",region_abbr => "NY",street_1 => "2242 Church Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "782 Union Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "734 Nostrand Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11205,region => "New York",region_abbr => "NY",street_1 => "271 Adelphi Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "124 Meserole Ave",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "49 Bogart St",street_2 => undef}
{city => "Brooklyn",postal_code => 11230,region => "New York",region_abbr => "NY",street_1 => "1308 Avenue H",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "183 5th Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11222,region => "New York",region_abbr => "NY",street_1 => "193 Meserole Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "156 5th Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "144 Atlantic Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "253 Flatbush ave.",street_2 => undef}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "448 9th Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "114 North 6th Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11222,region => "New York",region_abbr => "NY",street_1 => "134 Kingsland Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "295 Grand St.",street_2 => undef}
{city => "Brooklyn",postal_code => "11217-2820",region => "New York",region_abbr => "NY",street_1 => "258 Flatbush Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11238,region => "New York",region_abbr => "NY",street_1 => "609 Vanderbilt Ave.",street_2 => undef}
{city => "Brooklyn",postal_code => 11252,region => "New York",region_abbr => "NY",street_1 => "231 Court Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "359 7th Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "25 Jay Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "148 Bedford Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "76 Henry Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "25 Jay Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11222,region => "New York",region_abbr => "NY",street_1 => "60 Greenpoint Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14201,region => "New York",region_abbr => "NY",street_1 => "370 Virginia Street",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "354 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "765 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "807 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "1116 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "802 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14214,region => "New York",region_abbr => "NY",street_1 => "3234 Main St",street_2 => undef}
{city => "Buffalo",postal_code => 14226,region => "New York",region_abbr => "NY",street_1 => "681 Niagara Falls Blvd",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "1098 Elmwood Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14216,region => "New York",region_abbr => "NY",street_1 => "2308 Delaware Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14202,region => "New York",region_abbr => "NY",street_1 => "59 Allen St",street_2 => undef}
{city => "Buffalo",postal_code => 14220,region => "New York",region_abbr => "NY",street_1 => "688 Abbott Rd.",street_2 => undef}
{city => "Buffalo",postal_code => 14222,region => "New York",region_abbr => "NY",street_1 => "1081 Elmwood Ave",street_2 => undef}
{city => "Clarence Center",postal_code => 14032,region => "New York",region_abbr => "NY",street_1 => "9475 Clarence Center Road",street_2 => undef}
{city => "Clayville",postal_code => 13322,region => "New York",region_abbr => "NY",street_1 => "2269 Oneida Street",street_2 => undef}
{city => "Clifton Park",postal_code => 12065,region => "New York",region_abbr => "NY",street_1 => "1028 Route 146",street_2 => undef}
{city => "Cochecton",postal_code => 12726,region => "New York",region_abbr => "NY",street_1 => "31 Mitchell Pond East",street_2 => undef}
{city => "East Syracuse",postal_code => 13057,region => "New York",region_abbr => "NY",street_1 => "5098 Bridge St.",street_2 => undef}
{city => "Endicott",postal_code => 13760,region => "New York",region_abbr => "NY",street_1 => "305 Grant Avenue",street_2 => undef}
{city => "Flushing",postal_code => 11354,region => "New York",region_abbr => "NY",street_1 => "13537 37th Ave",street_2 => undef}
{city => "Flushing",postal_code => 11355,region => "New York",region_abbr => "NY",street_1 => "45-63 Bowne Street",street_2 => undef}
{city => "Forest Hills",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "107-12 70th Road",street_2 => undef}
{city => "Greenlawn",postal_code => 11740,region => "New York",region_abbr => "NY",street_1 => "97 Broadway",street_2 => undef}
{city => "Haverstraw",postal_code => 10927,region => "New York",region_abbr => "NY",street_1 => "43 Main Street",street_2 => undef}
{city => "Hicksville",postal_code => 11801,region => "New York",region_abbr => "NY",street_1 => "128 Broadway",street_2 => undef}
{city => "Hicksville",postal_code => 11801,region => "New York",region_abbr => "NY",street_1 => "416 S. Broadway",street_2 => undef}
{city => "High Falls",postal_code => 12440,region => "New York",region_abbr => "NY",street_1 => "2303 Lucas Avenue",street_2 => undef}
{city => "Hudson",postal_code => 12534,region => "New York",region_abbr => "NY",street_1 => "537 Warren Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "215 N Cayuga St",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => " 215 N Cayuga St",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "701 West Buffalo Street",street_2 => undef}
{city => "Jamaica",postal_code => 11432,region => "New York",region_abbr => "NY",street_1 => "84-43 164th Street",street_2 => undef}
{city => "Jamaica",postal_code => 11432,region => "New York",region_abbr => "NY",street_1 => "86-14 Parsons Boulevard #A",street_2 => undef}
{city => "Jericho",postal_code => 11753,region => "New York",region_abbr => "NY",street_1 => "429 North Broadway",street_2 => undef}
{city => "Kerhonkson",postal_code => 12446,region => "New York",region_abbr => "NY",street_1 => "5945 Route 44/55",street_2 => undef}
{city => "Kingston",postal_code => 12401,region => "New York",region_abbr => "NY",street_1 => "1200 Ulster Ave",street_2 => undef}
{city => "Kingston",postal_code => 12401,region => "New York",region_abbr => "NY",street_1 => "59 John St",street_2 => undef}
{city => "Kingston",postal_code => 12401,region => "New York",region_abbr => "NY",street_1 => "1353 Ulster Ave",street_2 => undef}
{city => "Levittown",postal_code => 11756,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Long Beach",postal_code => 11561,region => "New York",region_abbr => "NY",street_1 => "104 W. Park Ave",street_2 => undef}
{city => "Manhasset",postal_code => 11030,region => "New York",region_abbr => "NY",street_1 => "2101 Northern Blvd.",street_2 => undef}
{city => "Manhattan",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "101 Stanton Street",street_2 => undef}
{city => "Manhattan",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "212 Lafayette Street",street_2 => undef}
{city => "Manhattan",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "2170 Broadway",street_2 => undef}
{city => "Manhattan",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "409 3rd Ave",street_2 => undef}
{city => "Manhattan",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "170 Allen St.",street_2 => undef}
{city => "Manhattan",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "78 Orchard Street",street_2 => undef}
{city => "Manhattan",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "114 East 1st Street",street_2 => undef}
{city => "Mattydale",postal_code => 13211,region => "New York",region_abbr => "NY",street_1 => "2205 Brewerton Rd",street_2 => undef}
{city => "Monroe",postal_code => 10950,region => "New York",region_abbr => "NY",street_1 => "13 Sapphire Road",street_2 => undef}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "215 Main Street",street_2 => undef}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "59 Main Street",street_2 => undef}
{city => "New Rochelle",postal_code => 10801,region => "New York",region_abbr => "NY",street_1 => "412 North Avenue",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "349 E. 12th St.",street_2 => undef}
{city => "New York",postal_code => 10036,region => "New York",region_abbr => "NY",street_1 => "663 9th Ave.",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "343 E. 10th Street",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "226 Thompson Street",street_2 => undef}
{city => "New York",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "11 West 30th Street",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "119 MacDougal Street",street_2 => undef}
{city => "New York",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "53 West 35th Street",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "248 Broome Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "203 East 10th Street",street_2 => undef}
{city => "New York",postal_code => 10018,region => "New York",region_abbr => "NY",street_1 => "17 W. 45th Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "127 2nd Avenue",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "113 Greenwich Ave",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "18 East 23rd Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "54 Irving Place",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "Madison Square Park",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "45 1st Avenue",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "148 Mercer St",street_2 => undef}
{city => "New York",postal_code => "10016-4307",region => "New York",region_abbr => "NY",street_1 => "12 Park Ave",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "269 West 23rd Street",street_2 => undef}
{city => "New York",postal_code => "10016-3109",region => "New York",region_abbr => "NY",street_1 => "561 3rd Ave",street_2 => undef}
{city => "New York",postal_code => "10011-1604",region => "New York",region_abbr => "NY",street_1 => "178 8th Ave",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "328 E 14th St",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "342 E 6th St",street_2 => undef}
{city => "New York",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "566 Amsterdam Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "179 2nd Ave.",street_2 => undef}
{city => "New York",postal_code => 10019,region => "New York",region_abbr => "NY",street_1 => "913 8th Ave.",street_2 => undef}
{city => "New York",postal_code => 10027,region => "New York",region_abbr => "NY",street_1 => "54 W. 125th Street",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "115 Greenwich Ave",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "23 3rd Avenue",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "153 E 26th St",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "157 Allen Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "380 Broome Street",street_2 => undef}
{city => "New York",postal_code => 10013,region => "New York",region_abbr => "NY",street_1 => "5 Mott Street",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "45 8th Avenue",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "115 St Marks Place",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "58 East 4th Street",street_2 => undef}
{city => "New York",postal_code => 10032,region => "New York",region_abbr => "NY",street_1 => "1121 Saint Nicholas Avenue",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "144 W. 4th St.",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "138 E 3rd Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "105 1st Avenue",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "90 Rivington St",street_2 => undef}
{city => "New York",postal_code => 10028,region => "New York",region_abbr => "NY",street_1 => "1426 3rd Avenue",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "102 Lexington",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "127 East 28th Street",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "227 Sullivan Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "229 E 9th St",street_2 => undef}
{city => "New York",postal_code => 10013,region => "New York",region_abbr => "NY",street_1 => "24 Pell St.",street_2 => undef}
{city => "New York",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "566 Amsterdam Ave",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "154 East 79th St",street_2 => undef}
{city => "New York",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "466 Columbus Ave",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "263 East 10th Street",street_2 => "(1st Avenue & Avenue A)"}
{city => "New York",postal_code => 10271,region => "New York",region_abbr => "NY",street_1 => "120 Broadway",street_2 => "Lower Arcade"}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "49 Washington Square South",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "229 West 13th Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "38 Union Square East",street_2 => undef}
{city => "New York",postal_code => 10036,region => "New York",region_abbr => "NY",street_1 => "311 West 48th Street",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "1154 1st Avenue",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "110 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "187 9th Ave",street_2 => undef}
{city => "New York",postal_code => "10009-7245",region => "New York",region_abbr => "NY",street_1 => "58 Avenue B",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1614 2nd Ave.",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "587 9th Ave",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "81 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "275 7th Ave",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "140 West 4th St.",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "401 Avenue of the Americas",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "125 1/2 E 17th St",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "2291 Adam Clayton Powell Jr Blvd",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "147 1st Ave",street_2 => undef}
{city => "New York",postal_code => 10013,region => "New York",region_abbr => "NY",street_1 => " 227 Centre St.",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "78 5th Ave",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "101 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "305 Amsterdam Ave.",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "1307 3rd Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "99 Macdougal St.",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "109 Saint Mark's Place",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "130 St. Marks Place",street_2 => undef}
{city => "New York",postal_code => 10013,region => "New York",region_abbr => "NY",street_1 => "68 Mott St.",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "76 E 7th St.",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "34 E. Union Square",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "79 2nd Ave.",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "430 E. 9th Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "129 Rivington Street",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "37 Avenue A",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "25 1st Avenue",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "48 W. 21st Street",street_2 => "2nd floor"}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "95 Orchard St",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "74 W 3rd Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "342 East 6th St",street_2 => undef}
{city => "New York",postal_code => 10013,region => "New York",region_abbr => "NY",street_1 => "213 Hester St",street_2 => undef}
{city => "New York",postal_code => 10019,region => "New York",region_abbr => "NY",street_1 => "705 Ninth Avenue",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "173 Ludlow St",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => " 564 3rd Ave",street_2 => undef}
{city => "New York",postal_code => 10019,region => "New York",region_abbr => "NY",street_1 => "768 9th Avenue",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => " 28 East 13th Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "34 St Marks Place",street_2 => undef}
{city => "New York",postal_code => 10022,region => "New York",region_abbr => "NY",street_1 => "235 E 53rd St",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "62 Spring Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "706 Amsterdam Ave.",street_2 => undef}
{city => "New York",postal_code => 10038,region => "New York",region_abbr => "NY",street_1 => "104 John Street",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "508 East 12th Street",street_2 => undef}
{city => "New York",postal_code => 10023,region => "New York",region_abbr => "NY",street_1 => "244 West 72nd Street",street_2 => undef}
{city => "New York",postal_code => 10022,region => "New York",region_abbr => "NY",street_1 => "177 Ludlow Street",street_2 => undef}
{city => "New York",postal_code => 10031,region => "New York",region_abbr => "NY",street_1 => "348 West 145th Street",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "47 7th Avenue South",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "222 Waverly Place",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "119 Macdougal Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "15 Irving Place",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "97 St. Marks Place",street_2 => undef}
{city => "New York",postal_code => 10036,region => "New York",region_abbr => "NY",street_1 => "234 W 48th St",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "516 E. 6th St.",street_2 => undef}
{city => "New York City",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "10 Columbus Circle",street_2 => undef}
{city => "New York City",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "12 E 32nd Street",street_2 => undef}
{city => "New York City",postal_code => "10003-7201",region => "New York",region_abbr => "NY",street_1 => "300 E 12th St",street_2 => undef}
{city => "New York City",postal_code => "10016-4896",region => "New York",region_abbr => "NY",street_1 => "129 E 27th St",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "841 Broadway",street_2 => undef}
{city => "New York City",postal_code => 10017,region => "New York",region_abbr => "NY",street_1 => "465 Lexington Avenue",street_2 => undef}
{city => "New York City",postal_code => 10027,region => "New York",region_abbr => "NY",street_1 => "2058 Adam Clayton Powell Jr Blvd.",street_2 => undef}
{city => "New York City",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "210 E 34th St",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "123 1st Ave",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "4 Union Square South",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "73 2nd Avenue",street_2 => undef}
{city => "New York City",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "250 7th Avenue",street_2 => undef}
{city => "New York City",postal_code => 10019,region => "New York",region_abbr => "NY",street_1 => "10 Columbus Circle, Ste. SC101",street_2 => undef}
{city => "New York City",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "172 Allen St",street_2 => undef}
{city => "New York City",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "180 Third Ave",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "75 1st Avenue",street_2 => undef}
{city => "New York City",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "565 3rd Avenue",street_2 => undef}
{city => "New York City",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "55 West 35th Street",street_2 => undef}
{city => "New York City",postal_code => 10023,region => "New York",region_abbr => "NY",street_1 => "300 Amsterdam Avenue",street_2 => undef}
{city => "New York City",postal_code => 10017,region => "New York",region_abbr => "NY",street_1 => "156 East 45th St",street_2 => undef}
{city => "New York City",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "405 E 6th Street.",street_2 => undef}
{city => "New York City",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "410 6th Ave.",street_2 => undef}
{city => "New York City",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "391 8th Ave",street_2 => undef}
{city => "New York City",postal_code => 10025,region => "New York",region_abbr => "NY",street_1 => "2578 Broadway",street_2 => undef}
{city => "New York City",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "227 Mott Street",street_2 => undef}
{city => "New York City",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "191 Orchard St",street_2 => undef}
{city => "New York City",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "115 Lexington Ave",street_2 => undef}
{city => "NY",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "444 3rd Ave",street_2 => undef}
{city => "NYC",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Orangeburg",postal_code => 10962,region => "New York",region_abbr => "NY",street_1 => "303 Route 303",street_2 => undef}
{city => "Pine Bush",postal_code => 12566,region => "New York",region_abbr => "NY",street_1 => "3 Mindfullness Road",street_2 => undef}
{city => "Port Jefferson",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "156 E Main St",street_2 => undef}
{city => "Poughkeepsie",postal_code => 12601,region => "New York",region_abbr => "NY",street_1 => "804 South Road",street_2 => undef}
{city => "Queens",postal_code => 11413,region => "New York",region_abbr => "NY",street_1 => "231-22 Merrick Blvd.",street_2 => "Laurelton"}
{city => "Queens",postal_code => 11434,region => "New York",region_abbr => "NY",street_1 => "126-14D Merrick Blvd.",street_2 => "Jamaica"}
{city => "Queens",postal_code => 11355,region => "New York",region_abbr => "NY",street_1 => "42-96 Main Street",street_2 => undef}
{city => "Queens",postal_code => 11367,region => "New York",region_abbr => "NY",street_1 => "157-19 72nd Ave",street_2 => undef}
{city => "Queens",postal_code => 11419,region => "New York",region_abbr => "NY",street_1 => "131 Liberty Ave",street_2 => undef}
{city => "Rochester",postal_code => 14623,region => "New York",region_abbr => "NY",street_1 => "1455 East Henrietta Road",street_2 => undef}
{city => "Rochester",postal_code => 14607,region => "New York",region_abbr => "NY",street_1 => "62 Marshall Street",street_2 => undef}
{city => "Rochester",postal_code => 14605,region => "New York",region_abbr => "NY",street_1 => "80 University Avenue",street_2 => undef}
{city => "Rochester",postal_code => 14607,region => "New York",region_abbr => "NY",street_1 => "288 Monroe Avenue",street_2 => undef}
{city => "Rochester",postal_code => 14618,region => "New York",region_abbr => "NY",street_1 => "1900 Clinton Ave S",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "1009 Clinton Ave South",street_2 => undef}
{city => "Rochester",postal_code => 14607,region => "New York",region_abbr => "NY",street_1 => "295 Alexander St.",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "742 South Ave",street_2 => undef}
{city => "Rochester",postal_code => 14609,region => "New York",region_abbr => "NY",street_1 => "625 Culver Rd",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "503 South Ave",street_2 => undef}
{city => "Rochester",postal_code => 14608,region => "New York",region_abbr => "NY",street_1 => "350 State Street",street_2 => undef}
{city => "Rochester",postal_code => 14608,region => "New York",region_abbr => "NY",street_1 => "280 Exchange Boulevard",street_2 => undef}
{city => "Rochester",postal_code => 14607,region => "New York",region_abbr => "NY",street_1 => "691 Monroe Ave",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "831 South Clinton Ave",street_2 => undef}
{city => "Rochester",postal_code => 14534,region => "New York",region_abbr => "NY",street_1 => "2411 West Henrietta Road",street_2 => undef}
{city => "Romulus",postal_code => 14541,region => "New York",region_abbr => "NY",street_1 => "5177 Kings Corners Rd.",street_2 => undef}
{city => "Rosendale",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Rosendale",postal_code => 12472,region => "New York",region_abbr => "NY",street_1 => "407 Main St",street_2 => undef}
{city => "Rye",postal_code => 10580,region => "New York",region_abbr => "NY",street_1 => "46 Purchase Street",street_2 => undef}
{city => "Saratoga Springs",postal_code => 12866,region => "New York",region_abbr => "NY",street_1 => "33 Phila Street",street_2 => undef}
{city => "Sleepy Hollow",postal_code => 10591,region => "New York",region_abbr => "NY",street_1 => "128 Cortlandt Street",street_2 => undef}
{city => "Spring Valley",postal_code => 10977,region => "New York",region_abbr => "NY",street_1 => "42 North Main Street",street_2 => undef}
{city => "Staten Island",postal_code => 10301,region => "New York",region_abbr => "NY",street_1 => "36 Richmond Terrace",street_2 => undef}
{city => "Syracuse",postal_code => 13210,region => "New York",region_abbr => "NY",street_1 => "526 Westcott St",street_2 => undef}
{city => "Syracuse",postal_code => 13210,region => "New York",region_abbr => "NY",street_1 => "618 Kensington Rd.",street_2 => undef}
{city => "Syracuse",postal_code => 13210,region => "New York",region_abbr => "NY",street_1 => "530 Westcott St",street_2 => undef}
{city => "Syracuse",postal_code => 13203,region => "New York",region_abbr => "NY",street_1 => "600 Burnet Ave.",street_2 => undef}
{city => "Tivoli",postal_code => 12583,region => "New York",region_abbr => "NY",street_1 => "55 Broadway",street_2 => undef}
{city => "Trumansburg",postal_code => 14886,region => "New York",region_abbr => "NY",street_1 => "2030 Gorge Road",street_2 => undef}
{city => "Victor",postal_code => 14564,region => "New York",region_abbr => "NY",street_1 => "6385 Route 96",street_2 => "Phoenix Mills Plaza"}
{city => "Watertown",postal_code => 13601,region => "New York",region_abbr => "NY",street_1 => "969 Arsenal Street",street_2 => undef}
{city => "Watkins Glen",postal_code => 14891,region => "New York",region_abbr => "NY",street_1 => "P.O. Box 150",street_2 => undef}
{city => "Watkins Glen",postal_code => 14891,region => "New York",region_abbr => "NY",street_1 => "316 E. 4th St",street_2 => undef}
{city => "West Babylon",postal_code => 11704,region => "New York",region_abbr => "NY",street_1 => "480 Rutgers Road",street_2 => undef}
{city => "Westbury",postal_code => 11590,region => "New York",region_abbr => "NY",street_1 => "477 Old Country Road",street_2 => undef}
{city => "White Plains",postal_code => 10605,region => "New York",region_abbr => "NY",street_1 => "110 Bloomingdale Rd",street_2 => undef}
{city => "Williamsville",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "5010 Main Street",street_2 => undef}
{city => "Williamsville",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "8020 Transit Road",street_2 => undef}
{city => "Woodside",postal_code => 11377,region => "New York",region_abbr => "NY",street_1 => "39-86 61st Street",street_2 => undef}
{city => "Woodstock",postal_code => 12498,region => "New York",region_abbr => "NY",street_1 => "295 Tinker Street",street_2 => undef}
{city => "Woodstock",postal_code => 12498,region => "New York",region_abbr => "NY",street_1 => "22 Rock City Drive",street_2 => undef}
{city => "Yulan",postal_code => 12792,region => "New York",region_abbr => "NY",street_1 => "172 Airport Road",street_2 => undef}
{city => "Concord",postal_code => "03303",region => "New Hampshire",region_abbr => "NH",street_1 => "26 N. Main Street",street_2 => undef}
{city => "Dover",postal_code => "03820",region => "New Hampshire",region_abbr => "NH",street_1 => "286 Central Avenue",street_2 => undef}
{city => "Durham",postal_code => "03824",region => "New Hampshire",region_abbr => "NH",street_1 => "50 Main St",street_2 => "#B"}
{city => "Exeter",postal_code => "03833",region => "New Hampshire",region_abbr => "NH",street_1 => "50 Lincoln Street",street_2 => undef}
{city => "Exeter",postal_code => "03833",region => "New Hampshire",region_abbr => "NH",street_1 => "8 Clifford St.",street_2 => undef}
{city => "Hanover",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "3 South Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "44 South Main Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "30 South Main Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "11 Lebanon Street",street_2 => undef}
{city => "Hanover",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "15 Lebanon Street",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "74 Main St",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "44 S Main St",street_2 => undef}
{city => "Hanover",postal_code => "03755",region => "New Hampshire",region_abbr => "NH",street_1 => "3 Lebanon Street",street_2 => undef}
{city => "Keene",postal_code => "03431",region => "New Hampshire",region_abbr => "NH",street_1 => "15 Roxbury Street",street_2 => undef}
{city => "Lebanon",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "90 Hanover Street",street_2 => undef}
{city => "Lebanon",postal_code => "03766",region => "New Hampshire",region_abbr => "NH",street_1 => "1 Court Street",street_2 => undef}
{city => "Lebanon",postal_code => "03766",region => "New Hampshire",region_abbr => "NH",street_1 => "2 W. Park Street",street_2 => undef}
{city => "Lyme",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "5 Main Street",street_2 => undef}
{city => "Manchester",postal_code => "03101",region => "New Hampshire",region_abbr => "NH",street_1 => "75 Arms Street",street_2 => undef}
{city => "Manchester",postal_code => "03102",region => "New Hampshire",region_abbr => "NH",street_1 => "581 Second Street",street_2 => "Suite C"}
{city => "Marlborough",postal_code => "03455",region => "New Hampshire",region_abbr => "NH",street_1 => "14 Main Street",street_2 => undef}
{city => "Nashua",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "113 W. Pearl Street",street_2 => undef}
{city => "Nashua",postal_code => "03064",region => "New Hampshire",region_abbr => "NH",street_1 => "215 Main St.",street_2 => undef}
{city => "Nashua",postal_code => "03060",region => "New Hampshire",region_abbr => "NH",street_1 => "23 Elm Street",street_2 => undef}
{city => "Nashua",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "112 W. Pearl St.",street_2 => undef}
{city => "Nashua",postal_code => "03060",region => "New Hampshire",region_abbr => "NH",street_1 => "9 Water Street",street_2 => undef}
{city => "Newmarket",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "118 Main Street",street_2 => undef}
{city => "North Hampton",postal_code => "03862",region => "New Hampshire",region_abbr => "NH",street_1 => "122 Lafayette Road",street_2 => undef}
{city => "North Hampton",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "17 Ocean Boulevard",street_2 => undef}
{city => "Northwood",postal_code => "03261",region => "New Hampshire",region_abbr => "NH",street_1 => "159 1st New Hampshire Turnpike",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "800 Islington Plaza",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "51 Hanover Street",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "56 Market Street",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "151 Congress St.",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "121 Congress St",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "107 State St.",street_2 => undef}
{city => "Portsmouth",postal_code => "03801",region => "New Hampshire",region_abbr => "NH",street_1 => "18 Ladd Street",street_2 => undef}
{city => "Rochester",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "15 Wakefield Street",street_2 => undef}
{city => "West Lebanon",postal_code => "03784",region => "New Hampshire",region_abbr => "NH",street_1 => "267 Plainfield Road",street_2 => undef}
{city => "West Lebanon",postal_code => undef,region => "New Hampshire",region_abbr => "NH",street_1 => "288 Plainfield Rd",street_2 => undef}
{city => "Asbury Park",postal_code => "07712",region => "New Jersey",region_abbr => "NJ",street_1 => "1000 Ocean Avenue",street_2 => undef}
{city => "Asbury Park",postal_code => "07712",region => "New Jersey",region_abbr => "NJ",street_1 => "1000 Ocean Avenue",street_2 => undef}
{city => "Cherry Hill",postal_code => "08003",region => "New Jersey",region_abbr => "NJ",street_1 => "1400 Berlin Road",street_2 => "#114 Woodcrest Shopping Center"}
{city => "Denville",postal_code => "07834",region => "New Jersey",region_abbr => "NJ",street_1 => "45 Bloomfield Ave",street_2 => "Denville Farmer's Market"}
{city => "Egg Harbor Twp",postal_code => "08234",region => "New Jersey",region_abbr => "NJ",street_1 => "3003 English Creek Ave",street_2 => undef}
{city => "Englewood",postal_code => "07631",region => "New Jersey",region_abbr => "NJ",street_1 => "20 N. Dean Street",street_2 => undef}
{city => "Franklin Park",postal_code => "08823",region => "New Jersey",region_abbr => "NJ",street_1 => "3029 Route 27",street_2 => undef}
{city => "Freehold",postal_code => "07728",region => "New Jersey",region_abbr => "NJ",street_1 => "3583 US Highway 9",street_2 => "ShopRite Plaza"}
{city => "Hackensack",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Hackensack",postal_code => "07601",region => "New Jersey",region_abbr => "NJ",street_1 => "258 Main St",street_2 => undef}
{city => "Hamilton",postal_code => "08619",region => "New Jersey",region_abbr => "NJ",street_1 => "3800 Quakerbridge Road",street_2 => undef}
{city => "Hoboken",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Iselin",postal_code => "08830",region => "New Jersey",region_abbr => "NJ",street_1 => "37 Gill Lane",street_2 => undef}
{city => "Jersey City",postal_code => "07306",region => "New Jersey",region_abbr => "NJ",street_1 => "809 Newark Avenue",street_2 => undef}
{city => "Jersey City",postal_code => "07302",region => "New Jersey",region_abbr => "NJ",street_1 => "303 Grove St",street_2 => undef}
{city => "Jersey City",postal_code => "07302",region => "New Jersey",region_abbr => "NJ",street_1 => "506 Jersey Avenue",street_2 => undef}
{city => "Jersey City",postal_code => "07302",region => "New Jersey",region_abbr => "NJ",street_1 => "313 Grove Street",street_2 => undef}
{city => "Jersey City",postal_code => "07306",region => "New Jersey",region_abbr => "NJ",street_1 => "804 Newark Avenue",street_2 => undef}
{city => "Jersey City",postal_code => "07306",region => "New Jersey",region_abbr => "NJ",street_1 => "795 Newark Avenue",street_2 => undef}
{city => "Keyport",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "25 Church Street",street_2 => undef}
{city => "Lambertville",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Lambertville",postal_code => "08530",region => "New Jersey",region_abbr => "NJ",street_1 => "18 South Main Street",street_2 => undef}
{city => "Lambertville",postal_code => "08530",region => "New Jersey",region_abbr => "NJ",street_1 => "74 N Main St",street_2 => undef}
{city => "Ledgewood",postal_code => "07852",region => "New Jersey",region_abbr => "NJ",street_1 => "538 Route 10 West",street_2 => undef}
{city => "Merchantville",postal_code => "08109",region => "New Jersey",region_abbr => "NJ",street_1 => "177 S. Centre Street",street_2 => undef}
{city => "Merchantville",postal_code => "08109",region => "New Jersey",region_abbr => "NJ",street_1 => "177 S. Centre Street",street_2 => undef}
{city => "Millville",postal_code => "08332",region => "New Jersey",region_abbr => "NJ",street_1 => "501 North High Street",street_2 => "Village on High, Cottage \"M\""}
{city => "Millville",postal_code => "08332",region => "New Jersey",region_abbr => "NJ",street_1 => "2180 North 2nd Street",street_2 => undef}
{city => "Millville",postal_code => "08332",region => "New Jersey",region_abbr => "NJ",street_1 => "2196 North 2nd Street",street_2 => "Union Lake Crossing Shopping Center"}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "570 Bloomfield Ave.",street_2 => undef}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "127 Valley Road",street_2 => undef}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "515 Bloomfield Ave",street_2 => undef}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "700 Bloomfield Avenue",street_2 => undef}
{city => "Montclair",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "539 Bloomfield Avenue",street_2 => undef}
{city => "Montclair",postal_code => "07042",region => "New Jersey",region_abbr => "NJ",street_1 => "307C Orange Road",street_2 => undef}
{city => "Morristown",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Mt. Laurel",postal_code => "08054",region => "New Jersey",region_abbr => "NJ",street_1 => "Rt. 38 and Ark Rd, Stop and Shop Shopping Center",street_2 => "Stop and Shop Shopping Center"}
{city => "Mullica Hill",postal_code => "08062",region => "New Jersey",region_abbr => "NJ",street_1 => "45 S. Main St.",street_2 => undef}
{city => "Mullica Hill",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "47 S. Main Street",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "155 Hamilton St",street_2 => undef}
{city => "New Brunswick",postal_code => "08901",region => "New Jersey",region_abbr => "NJ",street_1 => "89 Morris Street, 2nd Floor",street_2 => undef}
{city => "Newark",postal_code => "07102",region => "New Jersey",region_abbr => "NJ",street_1 => "61 Halsey St.",street_2 => "Newark Art Supply"}
{city => "Ocean Township",postal_code => "07712",region => "New Jersey",region_abbr => "NJ",street_1 => "1580 Route 35 South",street_2 => undef}
{city => "Parsippany",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "1123 Route 46",street_2 => undef}
{city => "Parsippany",postal_code => "07054",region => "New Jersey",region_abbr => "NJ",street_1 => "296 Route 46 West",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "62 Washington Road",street_2 => undef}
{city => "Princeton",postal_code => "08540",region => "New Jersey",region_abbr => "NJ",street_1 => "2 Dickinson Street",street_2 => undef}
{city => "Princeton",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => undef,street_2 => undef}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "33 Godwin Ave.",street_2 => undef}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "40 Broad Street",street_2 => undef}
{city => "Red Bank",postal_code => "07701",region => "New Jersey",region_abbr => "NJ",street_1 => "17 East Front Street",street_2 => undef}
{city => "Red Bank",postal_code => undef,region => "New Jersey",region_abbr => "NJ",street_1 => "95 Broad Street",street_2 => undef}
{city => "Ridgewood",postal_code => "07450",region => "New Jersey",region_abbr => "NJ",street_1 => "33 Godwin Avenue",street_2 => undef}
{city => "River Edge",postal_code => "07661",region => "New Jersey",region_abbr => "NJ",street_1 => "110 Kinderkamack Rd",street_2 => undef}
{city => "Rutherford",postal_code => "07070",region => "New Jersey",region_abbr => "NJ",street_1 => "40 Park Avenue",street_2 => undef}
{city => "Sea Girt",postal_code => "08750",region => "New Jersey",region_abbr => "NJ",street_1 => "2161 Highway 35",street_2 => undef}
{city => "Toms River",postal_code => "08755",region => "New Jersey",region_abbr => "NJ",street_1 => "2360 Lakewood Road",street_2 => undef}
{city => "Trenton",postal_code => "08648",region => "New Jersey",region_abbr => "NJ",street_1 => "580 Lawrence Square Blvd South",street_2 => undef}
{city => "Turnersville",postal_code => "08012",region => "New Jersey",region_abbr => "NJ",street_1 => "4991 Rt. 42",street_2 => "Unit 1"}
{city => "Union",postal_code => "07083",region => "New Jersey",region_abbr => "NJ",street_1 => "2012 Morris Avenue",street_2 => undef}
{city => "Voorhees",postal_code => "08043",region => "New Jersey",region_abbr => "NJ",street_1 => "200 White Horse Rd.",street_2 => undef}
{city => "West Cape May",postal_code => "08204",region => "New Jersey",region_abbr => "NJ",street_1 => "479B W. Perry St.",street_2 => undef}
{city => "Alamogordo",postal_code => 88310,region => "New Mexico",region_abbr => "NM",street_1 => "2617 N White Sands Blvd",street_2 => undef}
{city => "Alamogordo",postal_code => 88310,region => "New Mexico",region_abbr => "NM",street_1 => "2909 N White Sands Blvd",street_2 => undef}
{city => "Albuquerque",postal_code => 87109,region => "New Mexico",region_abbr => "NM",street_1 => "5505 Osuna Rd. NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87110,region => "New Mexico",region_abbr => "NM",street_1 => "2401 San Pedro NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87109,region => "New Mexico",region_abbr => "NM",street_1 => "4901 San Mateo Blvd. NE",street_2 => undef}
{city => "Albuquerque",postal_code => 87114,region => "New Mexico",region_abbr => "NM",street_1 => "10216 Coors Blvd. NW",street_2 => undef}
{city => "Albuquerque",postal_code => 87106,region => "New Mexico",region_abbr => "NM",street_1 => "2106 Central Ave SE",street_2 => undef}
{city => "Cedar Crest",postal_code => 87008,region => "New Mexico",region_abbr => "NM",street_1 => "12165 State Hwy. 14",street_2 => undef}
{city => "Las Cruces",postal_code => 88001,region => "New Mexico",region_abbr => "NM",street_1 => "1001 East University Avenue",street_2 => undef}
{city => "Ruidoso",postal_code => 88345,region => "New Mexico",region_abbr => "NM",street_1 => "1715 Sudderth Dr.",street_2 => undef}
{city => "Santa Fe",postal_code => 87507,region => "New Mexico",region_abbr => "NM",street_1 => "3095 Agua Fria Rd.",street_2 => undef}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "913 W. Alameda St.",street_2 => "Solana Shopping Center"}
{city => "Santa Fe",postal_code => 87505,region => "New Mexico",region_abbr => "NM",street_1 => "530 W. Cordova Rd.",street_2 => undef}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "1501 Paseo de Peralta",street_2 => "DeVargas Mall"}
{city => "Santa Fe",postal_code => 87508,region => "New Mexico",region_abbr => "NM",street_1 => "27 Crystal Mesa Road",street_2 => "Crystal Mesa farm B & B"}
{city => "Santa Fe",postal_code => 87501,region => "New Mexico",region_abbr => "NM",street_1 => "227 Don Gaspar Ave",street_2 => undef}
{city => "Arden",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2292 Hendersonville Rd.",street_2 => "Hwy. 25"}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "255 Barnard",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "50 Broadway Ave",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "Kimberly Knoll Dr",street_2 => undef}
{city => "Asheville",postal_code => 28805,region => "North Carolina",region_abbr => "NC",street_1 => "156 South Tunnel Rd",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "535 Merrimon Ave",street_2 => "#C"}
{city => "Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "48 Westgate Parkway",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1 Page Avenue.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "22 Battery Park Ave.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "3 Pack Square",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "100 Stone Ridge Blvd.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "111 Broadway Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "32 Broadway Street",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "148 Weaverville Rd",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "161 South Charlotte Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "48 Westgate Parkway",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "225 Haywood Road",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "122 College st",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1070 Tunnel Road",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "42 Biltmore",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "675 Merrimon Ave.",street_2 => undef}
{city => "Asheville",postal_code => "28801-2916",region => "North Carolina",region_abbr => "NC",street_1 => "50 Broadway",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "61 North Liberty Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "37 Biltmore Ave.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "8 Wall St.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1856 Hendersonville Rd.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "66 Westgate Pkwy.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "48 Biltmore Ave.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "5 Broadway St.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "70 Merrimon Ave.",street_2 => undef}
{city => "Asheville",postal_code => 28806,region => "North Carolina",region_abbr => "NC",street_1 => "70 Westgate Hwy.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "77 Biltmore Ave.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "70 North Lexington Ave.",street_2 => undef}
{city => "Asheville",postal_code => 28804,region => "North Carolina",region_abbr => "NC",street_1 => "233 Montford Ave.",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "Merrimon Square",street_2 => "640 Merrimon Ave."}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1 Page Avenue",street_2 => "Ste. 151"}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "640 Merrimon Ave.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "40 Wall Street",street_2 => undef}
{city => "Asheville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "12 College St.",street_2 => undef}
{city => "Asheville",postal_code => 28801,region => "North Carolina",region_abbr => "NC",street_1 => "52 North Lexington Avenue",street_2 => undef}
{city => "Boone",postal_code => 28607,region => "North Carolina",region_abbr => "NC",street_1 => "506 W King Street",street_2 => undef}
{city => "Boone",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "273 Boone Heights Dr.",street_2 => undef}
{city => "Boone",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "178 West King St.",street_2 => undef}
{city => "Carborro",postal_code => 27510,region => "North Carolina",region_abbr => "NC",street_1 => "111 E. Main St.",street_2 => undef}
{city => "Carborro",postal_code => 27510,region => "North Carolina",region_abbr => "NC",street_1 => "101 East Weaver Street",street_2 => undef}
{city => "Cary",postal_code => 27511,region => "North Carolina",region_abbr => "NC",street_1 => "740 E. Chatham St.",street_2 => undef}
{city => "Cary",postal_code => 27518,region => "North Carolina",region_abbr => "NC",street_1 => "102 New Waverly Place",street_2 => undef}
{city => "Cary",postal_code => 27511,region => "North Carolina",region_abbr => "NC",street_1 => "115 West Chatham Street",street_2 => undef}
{city => "Chapel Hill",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "Timberline Shopping Center",street_2 => "1129 Weaver Dairy Rd."}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "81 South Elliot Rd.",street_2 => undef}
{city => "Chapel Hill",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "128 E. Franklin St.",street_2 => undef}
{city => "Chapel Hill",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "503 W. Rosemary St.",street_2 => undef}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "1129 Weaver Dairy Road",street_2 => "Suite O, Timberlyne Shopping Center"}
{city => "Chapel Hill",postal_code => 27514,region => "North Carolina",region_abbr => "NC",street_1 => "1129 Weaver Dairy Rd",street_2 => undef}
{city => "Chapel Hill",postal_code => 27517,region => "North Carolina",region_abbr => "NC",street_1 => "501 Meadowmont Village Circle",street_2 => undef}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "721 Governor Morrison St.",street_2 => "Ste. 110"}
{city => "Charlotte",postal_code => 28202,region => "North Carolina",region_abbr => "NC",street_1 => "200 S. Tryon Street",street_2 => undef}
{city => "Charlotte",postal_code => 28213,region => "North Carolina",region_abbr => "NC",street_1 => "9510 University City Blvd",street_2 => undef}
{city => "Charlotte",postal_code => 28227,region => "North Carolina",region_abbr => "NC",street_1 => "7128-A Albemarle Road",street_2 => undef}
{city => "Charlotte",postal_code => 28210,region => "North Carolina",region_abbr => "NC",street_1 => "8418 Park Road",street_2 => "Suite B"}
{city => "Charlotte",postal_code => 28262,region => "North Carolina",region_abbr => "NC",street_1 => "230 E WT Harris Blvd",street_2 => "Suite B9"}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "8706 Pineville Matthews",street_2 => "Suite 1000"}
{city => "Charlotte",postal_code => 28205,region => "North Carolina",region_abbr => "NC",street_1 => "1601 Central Avenue",street_2 => undef}
{city => "Charlotte",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "12235 N. Community House Rd.",street_2 => undef}
{city => "Charlotte",postal_code => 28202,region => "North Carolina",region_abbr => "NC",street_1 => "225 E 6th St.",street_2 => "Seventh Street Station"}
{city => "Charlotte",postal_code => 28226,region => "North Carolina",region_abbr => "NC",street_1 => "7814 Fairview Rd.",street_2 => undef}
{city => "Charlotte",postal_code => 28203,region => "North Carolina",region_abbr => "NC",street_1 => "1801 Scott Avenue",street_2 => undef}
{city => "Charlotte",postal_code => 28277,region => "North Carolina",region_abbr => "NC",street_1 => "9820-F Rea Road",street_2 => undef}
{city => "Concord",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "20 Union St. South",street_2 => undef}
{city => "Cullowhee",postal_code => 28723,region => "North Carolina",region_abbr => "NC",street_1 => "3050 Old Cullowhee Rd.",street_2 => undef}
{city => "Durham",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "4201-112 University Dr.",street_2 => undef}
{city => "Durham",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "621 Broad St.",street_2 => undef}
{city => "Durham",postal_code => 27705,region => "North Carolina",region_abbr => "NC",street_1 => "754 Ninth Street",street_2 => undef}
{city => "Durham",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2600 Hillsborough Rd",street_2 => undef}
{city => "Durham",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1116 Broad Street",street_2 => undef}
{city => "Durham",postal_code => 27705,region => "North Carolina",region_abbr => "NC",street_1 => "706-B Ninth Street",street_2 => undef}
{city => "Fayetteville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "3608 Ramsey St.",street_2 => undef}
{city => "Fayetteville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "195 Starpoint Dr.",street_2 => undef}
{city => "Fayetteville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "1342 Bragg Blvd.",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2965 Battleground Ave.",street_2 => undef}
{city => "Greensboro",postal_code => 27405,region => "North Carolina",region_abbr => "NC",street_1 => "4205 High Point Road",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2130 New Garden Rd.",street_2 => undef}
{city => "Greensboro",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "3728 Spring Garden St.",street_2 => undef}
{city => "Greensboro",postal_code => 27403,region => "North Carolina",region_abbr => "NC",street_1 => "332 Tate St.",street_2 => undef}
{city => "Greensboro",postal_code => 27408,region => "North Carolina",region_abbr => "NC",street_1 => "1424 Westover Terrace",street_2 => undef}
{city => "Hot Springs",postal_code => 28743,region => "North Carolina",region_abbr => "NC",street_1 => "433 Lance Avenue",street_2 => "P.O. Box 441"}
{city => "Huntersville",postal_code => 28078,region => "North Carolina",region_abbr => "NC",street_1 => "16915 Birkdale Commons Parkway",street_2 => undef}
{city => "Mathews",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "7900 Stevens Mill Road",street_2 => undef}
{city => "Morrisville",postal_code => 27560,region => "North Carolina",region_abbr => "NC",street_1 => "3532 Davis Dr.",street_2 => undef}
{city => "Outer Banks",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "3701 Croatan Hwy. 5",street_2 => undef}
{city => "Pittsboro",postal_code => 27312,region => "North Carolina",region_abbr => "NC",street_1 => "76 West St",street_2 => undef}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "Delivery only",street_2 => "Order by phone or email at  cupcakes\@artisancupcake.com."}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "8411 Brier Creek Pkwy.",street_2 => "Ste.101"}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "10341 Moncreiffe Rd.",street_2 => undef}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => undef,street_2 => undef}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "320 1/2 Glenwood Ave.",street_2 => undef}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "3540 Wade Ave.",street_2 => undef}
{city => "Raleigh",postal_code => 27615,region => "North Carolina",region_abbr => "NC",street_1 => "6325 Falls of Neuse rd",street_2 => "Suite 73"}
{city => "Raleigh",postal_code => 27607,region => "North Carolina",region_abbr => "NC",street_1 => "3817 Beryl Road",street_2 => undef}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "6325 Falls of Neuse Rd. (Sutton Square)",street_2 => "Suite 73"}
{city => "Raleigh",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "2109 Avent Ferry Road",street_2 => undef}
{city => "Raleigh",postal_code => 27603,region => "North Carolina",region_abbr => "NC",street_1 => "901 W. Morgan St.",street_2 => undef}
{city => "Raleigh",postal_code => 27617,region => "North Carolina",region_abbr => "NC",street_1 => "8511 Briercreek Parkway",street_2 => "Suite 101"}
{city => "Sylva",postal_code => 28779,region => "North Carolina",region_abbr => "NC",street_1 => "628 E. Main St. (NC 107)",street_2 => undef}
{city => "Sylva",postal_code => 28779,region => "North Carolina",region_abbr => "NC",street_1 => "556 W Main St",street_2 => undef}
{city => "Sylva",postal_code => 28779,region => "North Carolina",region_abbr => "NC",street_1 => " 612 W Main St",street_2 => undef}
{city => "Sylva",postal_code => 28779,region => "North Carolina",region_abbr => "NC",street_1 => "3 East Jackson Street",street_2 => undef}
{city => "Weaverville",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "61-C Weaver Blvd.",street_2 => undef}
{city => "Wilmington",postal_code => 28412,region => "North Carolina",region_abbr => "NC",street_1 => "2505 S. College Road",street_2 => undef}
{city => "Winston-Salem",postal_code => undef,region => "North Carolina",region_abbr => "NC",street_1 => "41 Miller St.",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "855 45th Street South",street_2 => undef}
{city => "Fargo",postal_code => 58104,region => "North Dakota",region_abbr => "ND",street_1 => "4151 45th Street South",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "13 8th St S",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1450 25th St S",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "3003 32nd Ave S",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "704 1st Avenue N",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1324 25th Ave S",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "1015 Main Avenue",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1620 32nd Ave S",street_2 => undef}
{city => "Fargo",postal_code => 58104,region => "North Dakota",region_abbr => "ND",street_1 => "1609 32nd Ave S",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "402 N Broadway",street_2 => undef}
{city => "Fargo",postal_code => undef,region => "North Dakota",region_abbr => "ND",street_1 => "3228 13th Ave S",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "420 North Broadway",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1401 S 33rd St",street_2 => undef}
{city => "Fargo",postal_code => 58103,region => "North Dakota",region_abbr => "ND",street_1 => "1111 2nd Ave N",street_2 => undef}
{city => "Fargo",postal_code => undef,region => "North Dakota",region_abbr => "ND",street_1 => "530 6th Avenue N.",street_2 => undef}
{city => "Fargo",postal_code => 58102,region => "North Dakota",region_abbr => "ND",street_1 => "306 N University Drive",street_2 => undef}
{city => "Grand Forks",postal_code => 58201,region => "North Dakota",region_abbr => "ND",street_1 => "214 Demers Avenue",street_2 => undef}
{city => "West Fargo",postal_code => 58078,region => "North Dakota",region_abbr => "ND",street_1 => "349 East Main Avenue",street_2 => undef}
{city => "Henderson",postal_code => 89014,region => "Nevada",region_abbr => "NV",street_1 => "605 Mall Ring Circle",street_2 => "#110"}
{city => "Las Vegas",postal_code => 89123,region => "Nevada",region_abbr => "NV",street_1 => "500 E. Windmill Ln.",street_2 => "Suite 165"}
{city => "Las Vegas",postal_code => 89149,region => "Nevada",region_abbr => "NV",street_1 => "5643 Centennial Center Blvd",street_2 => undef}
{city => "Las Vegas",postal_code => 89101,region => "Nevada",region_abbr => "NV",street_1 => "520 Fremont Street",street_2 => undef}
{city => "Las Vegas",postal_code => 89109,region => "Nevada",region_abbr => "NV",street_1 => "3600 Las Vegas Blvd S",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "3475 Las Vegas Blvd.",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "3500 Las Vegas Blvd South",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "3600 Las Vegas Blvd.",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "3131 Las Vegas Blvd. South",street_2 => undef}
{city => "Las Vegas",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "3200 Las Vegas Blvd.",street_2 => undef}
{city => "Las Vegas",postal_code => 89102,region => "Nevada",region_abbr => "NV",street_1 => "3504 Wynn Rd.",street_2 => undef}
{city => "Las Vegas",postal_code => 89121,region => "Nevada",region_abbr => "NV",street_1 => "3365 E. Tropicana Ave.",street_2 => undef}
{city => "Las Vegas",postal_code => 89102,region => "Nevada",region_abbr => "NV",street_1 => "4604 W Sahara Ave",street_2 => "Suite 6"}
{city => "Las Vegas",postal_code => 89103,region => "Nevada",region_abbr => "NV",street_1 => "4020 S. Rainbow Blvd.",street_2 => undef}
{city => "Reno",postal_code => 89509,region => "Nevada",region_abbr => "NV",street_1 => "106 California Ave.",street_2 => undef}
{city => "Reno",postal_code => 89502,region => "Nevada",region_abbr => "NV",street_1 => "1565 S. Virginia St.",street_2 => undef}
{city => "Reno",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => undef,street_2 => undef}
{city => "Reno",postal_code => undef,region => "Nevada",region_abbr => "NV",street_1 => "315 E. Moana",street_2 => undef}
{city => "Reno",postal_code => 89519,region => "Nevada",region_abbr => "NV",street_1 => "4786 Caughlin Pkwy #303",street_2 => undef}
{city => "Reno",postal_code => 89509,region => "Nevada",region_abbr => "NV",street_1 => "655 Booth St.",street_2 => undef}
{city => "Reno",postal_code => 89501,region => "Nevada",region_abbr => "NV",street_1 => "50 N. Sierra Street",street_2 => "Suite 106"}
{city => "Reno",postal_code => 89509,region => "Nevada",region_abbr => "NV",street_1 => "542 1/2 Plumas St",street_2 => undef}
{city => "Reno",postal_code => 89511,region => "Nevada",region_abbr => "NV",street_1 => "6633 S. Virginia St.",street_2 => undef}
{city => "Reno",postal_code => 89512,region => "Nevada",region_abbr => "NV",street_1 => "855 E 4th St",street_2 => undef}
{city => "Reno",postal_code => 89502,region => "Nevada",region_abbr => "NV",street_1 => "1290 E. Plumb Ln",street_2 => undef}
{city => "Reno",postal_code => 89501,region => "Nevada",region_abbr => "NV",street_1 => "350 W. Liberty St.",street_2 => undef}
{city => "Reno",postal_code => 89509,region => "Nevada",region_abbr => "NV",street_1 => "530 W. Plumb Lane",street_2 => undef}
{city => "Sparks",postal_code => 89431,region => "Nevada",region_abbr => "NV",street_1 => "1500 Prater Way",street_2 => undef}
{city => "Albany",postal_code => 12206,region => "New York",region_abbr => "NY",street_1 => "274 Lark Street",street_2 => undef}
{city => "Albany",postal_code => 12180,region => "New York",region_abbr => "NY",street_1 => "97 4th Street",street_2 => undef}
{city => "Albany",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Albany",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1686 Central Ave",street_2 => undef}
{city => "Albany",postal_code => 12210,region => "New York",region_abbr => "NY",street_1 => "185 1/2 Lark St",street_2 => undef}
{city => "Albany",postal_code => 12210,region => "New York",region_abbr => "NY",street_1 => "452 Madison Avenue",street_2 => undef}
{city => "Amagansett",postal_code => 11930,region => "New York",region_abbr => "NY",street_1 => "Main Street",street_2 => "Amagansett Square"}
{city => "Astoria",postal_code => 11103,region => "New York",region_abbr => "NY",street_1 => "30-07 34th Street",street_2 => undef}
{city => "Babylon",postal_code => 11702,region => "New York",region_abbr => "NY",street_1 => "22 Fire Island Ave",street_2 => undef}
{city => "Babylon",postal_code => 11702,region => "New York",region_abbr => "NY",street_1 => "117 Deer Park Ave",street_2 => undef}
{city => "Bay Shore",postal_code => 11706,region => "New York",region_abbr => "NY",street_1 => "41 East Main Street",street_2 => undef}
{city => "Beacon",postal_code => 12508,region => "New York",region_abbr => "NY",street_1 => "484 Main Street",street_2 => undef}
{city => "Beacon",postal_code => 12508,region => "New York",region_abbr => "NY",street_1 => "384 Main Street",street_2 => undef}
{city => "Binghamton",postal_code => 13901,region => "New York",region_abbr => "NY",street_1 => "79 Court Street",street_2 => undef}
{city => "Bronx",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "4060 White Plains Road",street_2 => undef}
{city => "Bronx",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "4000 White Plains Rd",street_2 => undef}
{city => "Bronx",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1312 E. Gun Hill Rd.",street_2 => undef}
{city => "Bronx",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "737 Lydig Ave",street_2 => undef}
{city => "Bronx",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "3565B Boston Road",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "481 Nostrand",street_2 => undef}
{city => "Brooklyn",postal_code => 11216,region => "New York",region_abbr => "NY",street_1 => "1501 Fulton Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11216,region => "New York",region_abbr => "NY",street_1 => "1316 Fulton Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1022 Cortelyou Road",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "347 Graham Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "247 Bedford Ave",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "773 Flatbush Ave",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "188 Nassau Ave",street_2 => "Reparto Metropolitano"}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "999 Manhattan Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11354,region => "New York",region_abbr => "NY",street_1 => "6010 Seventh Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "128 Montague St 2nd floor",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "512 2nd Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11206,region => "New York",region_abbr => "NY",street_1 => "524 Lorimer St.",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "747 Fulton St",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "460 Bergen Street",street_2 => "Reparto Metropolitano"}
{city => "Brooklyn",postal_code => 11238,region => "New York",region_abbr => "NY",street_1 => "764A Franklin Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "112 Smith Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11222,region => "New York",region_abbr => "NY",street_1 => "253 Nassau Ave.",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "305 Schermerhorn Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11238,region => "New York",region_abbr => "NY",street_1 => "636 Park Place",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "769A Washington Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "329 Flatbush Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "315 5th Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "154 Bedford Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "232 Varet St",street_2 => "Reparto Metropolitano"}
{city => "Brooklyn",postal_code => 11237,region => "New York",region_abbr => "NY",street_1 => "214 Knickerbocker Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "206 Bedford Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "175 Remsen Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "158 Bedford Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "615 Grand St",street_2 => undef}
{city => "Brooklyn",postal_code => 11226,region => "New York",region_abbr => "NY",street_1 => "2281 Church Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "336A Graham Avenue",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "St Johns Place",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "785 Franklin Ave",street_2 => "# A"}
{city => "Brooklyn",postal_code => 11215,region => "New York",region_abbr => "NY",street_1 => "226 7th Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "221 Smith Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11206,region => "New York",region_abbr => "NY",street_1 => "940 Flushing Ave",street_2 => "# A"}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "176 Ainsle Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "318 Grand St # 1",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "201 5th Ave",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "305 Bedford Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "172 Court Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11217,region => "New York",region_abbr => "NY",street_1 => "444 Atlantic Avenue",street_2 => "512 2nd Street"}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "149 A Division Ave",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "40 Lee",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "222 Livingston St.",street_2 => undef}
{city => "Brooklyn",postal_code => 11201,region => "New York",region_abbr => "NY",street_1 => "51 Willoughby St",street_2 => undef}
{city => "Brooklyn",postal_code => 11237,region => "New York",region_abbr => "NY",street_1 => "67 Wilson",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "245 Grand Street",street_2 => undef}
{city => "Brooklyn",postal_code => 11211,region => "New York",region_abbr => "NY",street_1 => "178 North 8th Street",street_2 => undef}
{city => "Brooklyn",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "407 Smith St",street_2 => undef}
{city => "Buffalo",postal_code => 14216,region => "New York",region_abbr => "NY",street_1 => "1298 Hertel ave",street_2 => undef}
{city => "Buffalo",postal_code => 14201,region => "New York",region_abbr => "NY",street_1 => "206 Allen Street",street_2 => undef}
{city => "Buffalo",postal_code => 14201,region => "New York",region_abbr => "NY",street_1 => "244 Allen Street",street_2 => undef}
{city => "Buffalo",postal_code => 14202,region => "New York",region_abbr => "NY",street_1 => "439 Delaware Avenue",street_2 => undef}
{city => "Buffalo",postal_code => 14214,region => "New York",region_abbr => "NY",street_1 => "3400 Main St",street_2 => undef}
{city => "Buffalo",postal_code => 14220,region => "New York",region_abbr => "NY",street_1 => "382 Abbott Rd.",street_2 => undef}
{city => "Buffalo",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "205 Grant Street",street_2 => undef}
{city => "Buffalo",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "69 Allen St",street_2 => undef}
{city => "Buffalo",postal_code => 14225,region => "New York",region_abbr => "NY",street_1 => "1 Galleria Drive",street_2 => undef}
{city => "Buffalo",postal_code => 14217,region => "New York",region_abbr => "NY",street_1 => "1290 Sheridan Dr.",street_2 => undef}
{city => "Buffalo",postal_code => 14202,region => "New York",region_abbr => "NY",street_1 => "888 Main Street",street_2 => undef}
{city => "Buffalo",postal_code => 14226,region => "New York",region_abbr => "NY",street_1 => "3910 Maple Road",street_2 => undef}
{city => "Burdett",postal_code => 14818,region => "New York",region_abbr => "NY",street_1 => "3825 Main St.",street_2 => undef}
{city => "Centerport",postal_code => 11721,region => "New York",region_abbr => "NY",street_1 => "90 Washington Drive",street_2 => undef}
{city => "Chatham",postal_code => 12037,region => "New York",region_abbr => "NY",street_1 => "5 Main Street",street_2 => undef}
{city => "Chester",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "69 Brookside Ave",street_2 => undef}
{city => "Cicero",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "8169 Brewerton Road",street_2 => undef}
{city => "College Point",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "131-10 11 Ave.",street_2 => undef}
{city => "Cross River",postal_code => 10518,region => "New York",region_abbr => "NY",street_1 => "6 Yellow Monkey Village",street_2 => undef}
{city => "Darien Center",postal_code => 14040,region => "New York",region_abbr => "NY",street_1 => "1961 Church Road",street_2 => undef}
{city => "East Hampton",postal_code => 11937,region => "New York",region_abbr => "NY",street_1 => "66 Newtown Lane",street_2 => undef}
{city => "East Syracuse",postal_code => 13057,region => "New York",region_abbr => "NY",street_1 => "207 W. Manlius St.",street_2 => undef}
{city => "Ellenville",postal_code => 12428,region => "New York",region_abbr => "NY",street_1 => "165 Canal Street",street_2 => undef}
{city => "Elmira",postal_code => 14901,region => "New York",region_abbr => "NY",street_1 => "800 Madison Avenue",street_2 => undef}
{city => "Florida",postal_code => 10921,region => "New York",region_abbr => "NY",street_1 => "176 North Main Street",street_2 => undef}
{city => "Flushing",postal_code => 11355,region => "New York",region_abbr => "NY",street_1 => "41-46 College Point Blvd.",street_2 => undef}
{city => "Geneva",postal_code => 14456,region => "New York",region_abbr => "NY",street_1 => "93 Seneca St",street_2 => undef}
{city => "Glen Cove",postal_code => 11542,region => "New York",region_abbr => "NY",street_1 => "26 School Street",street_2 => undef}
{city => "Goshen",postal_code => 10924,region => "New York",region_abbr => "NY",street_1 => "114 Clowes Ave",street_2 => undef}
{city => "Hartsdale",postal_code => 10530,region => "New York",region_abbr => "NY",street_1 => "206 E. Hartsdale Avenue",street_2 => undef}
{city => "Interlaken",postal_code => 14847,region => "New York",region_abbr => "NY",street_1 => "8421 Route 89",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "702 Willow Avenue",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "503 N. Meadow Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "400 N. Meadow Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "2255 North Triphammer Road",street_2 => "Triphammer Mall"}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "308 Stewart Ave.",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "128 S. Cayuga Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "106 S. Cayuga Street",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "118 S. Cayuga Street",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "100 Dryden Rd",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "106 W. Green St.",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "216 E. State St.",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "508 West State Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "101 N. Aurora St.",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "202 East Falls Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "106 South Cayuga Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "200 W. Seneca St.",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "215 N. Cayuga Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "310 Stewart Ave.",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "115 E. State Street",street_2 => undef}
{city => "Ithaca",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "146 East State Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "403 College Ave.",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "501 S. Meadow Street",street_2 => undef}
{city => "Ithaca",postal_code => 14850,region => "New York",region_abbr => "NY",street_1 => "111 Rachel Carson Way",street_2 => undef}
{city => "Jackson Heights",postal_code => 11372,region => "New York",region_abbr => "NY",street_1 => "72-20 Roosevelt Ave",street_2 => undef}
{city => "Jamestown",postal_code => 14701,region => "New York",region_abbr => "NY",street_1 => "12 E. 4th St.",street_2 => undef}
{city => "Jericho",postal_code => 11753,region => "New York",region_abbr => "NY",street_1 => "519 N. Broadway",street_2 => undef}
{city => "Lewiston",postal_code => 14092,region => "New York",region_abbr => "NY",street_1 => "703 Center St",street_2 => undef}
{city => "Long Island City",postal_code => 11106,region => "New York",region_abbr => "NY",street_1 => "34-11 Crescent Street",street_2 => undef}
{city => "Manhattan",postal_code => 10025,region => "New York",region_abbr => "NY",street_1 => "947 Amsterdam Avenue",street_2 => undef}
{city => "Mt. Kisco",postal_code => 10549,region => "New York",region_abbr => "NY",street_1 => "37 South Moger Avenue",street_2 => undef}
{city => "Naples",postal_code => 14512,region => "New York",region_abbr => "NY",street_1 => "110 South Main St",street_2 => undef}
{city => "New City",postal_code => 10956,region => "New York",region_abbr => "NY",street_1 => "191-195 South Main Street",street_2 => undef}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "71 Main St",street_2 => undef}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "15 New Paltz Plaza",street_2 => undef}
{city => "New Paltz",postal_code => "12561-1610",region => "New York",region_abbr => "NY",street_1 => "255 Main Street",street_2 => undef}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "New Paltz Plaza",street_2 => "Route 299"}
{city => "New Paltz",postal_code => 12561,region => "New York",region_abbr => "NY",street_1 => "11 Main St",street_2 => undef}
{city => "New Paltz",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "62 Main Street",street_2 => undef}
{city => "New Paltz",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "15 1/2 N. Front St",street_2 => undef}
{city => "New Rochelle",postal_code => 10801,region => "New York",region_abbr => "NY",street_1 => "30 Division Street",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "414 E. 9th St",street_2 => undef}
{city => "New York",postal_code => 10023,region => "New York",region_abbr => "NY",street_1 => "161 West 72nd Street",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "145 Greene Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "154 Bleeker",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "947 Eighth Ave",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "198 Allen",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "338 East 11th Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "23 3rd Ave",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "101 3rd Ave",street_2 => undef}
{city => "New York",postal_code => 10001,region => "New York",region_abbr => "NY",street_1 => "348 7th Avenue",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "181 Bleeker Street",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "338 E. 6th Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1522 First Ave",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "359 First Avenue",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "297 Third Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "460 Amsterdam",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "225 W. 23rd St.",street_2 => "Store #7"}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "139 Avenue A",street_2 => undef}
{city => "New York",postal_code => 10018,region => "New York",region_abbr => "NY",street_1 => "110 W. 40th St",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "189 E Houston St",street_2 => undef}
{city => "New York",postal_code => 10128,region => "New York",region_abbr => "NY",street_1 => "1664 3rd Ave",street_2 => undef}
{city => "New York",postal_code => 10028,region => "New York",region_abbr => "NY",street_1 => "1663 First Avenue",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "27 Essex Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "558 7th Ave",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "115 E. 18th St.",street_2 => undef}
{city => "New York",postal_code => 10038,region => "New York",region_abbr => "NY",street_1 => "2 Maiden Lane",street_2 => "Cafe Exchange"}
{city => "New York",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "2161 Broadway",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "210 6th Avenue",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "170 2nd Ave",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "326 E 6th St",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "298 Bleecker St",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "174 9th Avenue",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "125 East 7th Street",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "121 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "152 Ludlow Street",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "1407 Second Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "81 3rd Ave",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "106 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "102 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "49 1/2 1st Avenue",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "104 Lexington Ave",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "446 6th Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "100 St Marks place",street_2 => undef}
{city => "New York",postal_code => 10035,region => "New York",region_abbr => "NY",street_1 => "10 E. 125th Street",street_2 => undef}
{city => "New York",postal_code => 10023,region => "New York",region_abbr => "NY",street_1 => "102 W. 73rd Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "17 Waverly Place",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "156 E. 64th Street",street_2 => undef}
{city => "New York",postal_code => 10028,region => "New York",region_abbr => "NY",street_1 => "220 E. 81st Street",street_2 => undef}
{city => "New York",postal_code => 10024,region => "New York",region_abbr => "NY",street_1 => "464 Amsterdam Avenue",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "68 Prince Street",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "16 W. 8th St",street_2 => undef}
{city => "New York",postal_code => 10038,region => "New York",region_abbr => "NY",street_1 => "5 East Broadway",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "101 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "119 E. 17th St.",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "75 Ninth Avenue",street_2 => undef}
{city => "New York",postal_code => 10010,region => "New York",region_abbr => "NY",street_1 => "64 W. 23rd St.",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "688 6th Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "210 E. 14th Street",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "127 Rivington",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "147 E. Houston",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "302 E. 12th Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "1522 First Ave",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "46th Street and 6th Ave",street_2 => undef}
{city => "New York",postal_code => 10031,region => "New York",region_abbr => "NY",street_1 => "40005 Broadway",street_2 => undef}
{city => "New York",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "171 East Broadway",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "59 East 8th St.",street_2 => undef}
{city => "New York",postal_code => 10023,region => "New York",region_abbr => "NY",street_1 => "2047-A Broadway",street_2 => undef}
{city => "New York",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "182 Lexington Ave",street_2 => undef}
{city => "New York",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "39 Downing St.",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "199 E 3rd St",street_2 => undef}
{city => "New York",postal_code => 10025,region => "New York",region_abbr => "NY",street_1 => "239 West 105th Street",street_2 => undef}
{city => "New York",postal_code => 10036,region => "New York",region_abbr => "NY",street_1 => "683 8th Avenue",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "93 Avenue A",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => undef,street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "159 2nd Avenue",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "1413 2nd Avenue",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "203 1st Ave",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "75 9th Avenue",street_2 => undef}
{city => "New York",postal_code => 10011,region => "New York",region_abbr => "NY",street_1 => "46 Greenwich Ave",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "22 St. Marks Place",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "102 Lexington Avenue",street_2 => undef}
{city => "New York",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "37 St Marks Place",street_2 => undef}
{city => "New York",postal_code => 10021,region => "New York",region_abbr => "NY",street_1 => "1413 York Avenue",street_2 => undef}
{city => "New York",postal_code => 10022,region => "New York",region_abbr => "NY",street_1 => "235 E. 53rd St",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "68 Avenue C",street_2 => undef}
{city => "New York",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "150 Sullivan Street",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "19 Cleveland Place",street_2 => undef}
{city => "New York",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "182 Avenue B",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "81 St. Marks Place",street_2 => undef}
{city => "New York",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "38 Ave. B",street_2 => undef}
{city => "New York City",postal_code => 10017,region => "New York",region_abbr => "NY",street_1 => "105 East 42nd Street",street_2 => undef}
{city => "New York City",postal_code => 10028,region => "New York",region_abbr => "NY",street_1 => "1617 2nd Ave",street_2 => undef}
{city => "New York City",postal_code => 10002,region => "New York",region_abbr => "NY",street_1 => "348 Grand Street",street_2 => undef}
{city => "New York City",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "42 Avenue A",street_2 => undef}
{city => "New York City",postal_code => 10012,region => "New York",region_abbr => "NY",street_1 => "74 Bleecker Street",street_2 => undef}
{city => "New York City",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "201 West 11th Street",street_2 => undef}
{city => "New York City",postal_code => 10028,region => "New York",region_abbr => "NY",street_1 => "1594 Second Avenue",street_2 => undef}
{city => "New York City",postal_code => 10016,region => "New York",region_abbr => "NY",street_1 => "684 3rd Ave",street_2 => undef}
{city => "New York City",postal_code => 10009,region => "New York",region_abbr => "NY",street_1 => "223 1st Avenue",street_2 => undef}
{city => "New York City",postal_code => 10014,region => "New York",region_abbr => "NY",street_1 => "145 Seventh Avenue South",street_2 => undef}
{city => "New York City",postal_code => 10003,region => "New York",region_abbr => "NY",street_1 => "218 Third Ave",street_2 => undef}
{city => "Newburgh",postal_code => 12550,region => "New York",region_abbr => "NY",street_1 => "119 Liberty Street",street_2 => undef}
{city => "Niles",postal_code => 13118,region => "New York",region_abbr => "NY",street_1 => "4588 Grange Hall Road",street_2 => undef}
{city => "Northport",postal_code => 11768,region => "New York",region_abbr => "NY",street_1 => "847 Fort Salonga Road",street_2 => undef}
{city => "Nyack",postal_code => 10960,region => "New York",region_abbr => "NY",street_1 => "145 Main Street",street_2 => undef}
{city => "Oceanside",postal_code => 11572,region => "New York",region_abbr => "NY",street_1 => "3000 Long Beach Road",street_2 => undef}
{city => "Pine Bush",postal_code => 12566,region => "New York",region_abbr => "NY",street_1 => "100 Main Street",street_2 => undef}
{city => "Plattsburgh",postal_code => 12901,region => "New York",region_abbr => "NY",street_1 => "14 Margaret  St.",street_2 => undef}
{city => "Potsdam",postal_code => 13676,region => "New York",region_abbr => "NY",street_1 => "38 Market Street",street_2 => undef}
{city => "Queens",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "84-73 Parsons Blvd",street_2 => undef}
{city => "Queens",postal_code => 11375,region => "New York",region_abbr => "NY",street_1 => "100-17 Queens Blvd",street_2 => undef}
{city => "Queens",postal_code => 11419,region => "New York",region_abbr => "NY",street_1 => "132-09 Liberty Ave",street_2 => undef}
{city => "Queens",postal_code => 11105,region => "New York",region_abbr => "NY",street_1 => "29-12 23rd Ave",street_2 => undef}
{city => "Queens",postal_code => 11378,region => "New York",region_abbr => "NY",street_1 => "60-07 Roosevelt Ave",street_2 => undef}
{city => "Queens",postal_code => 11377,region => "New York",region_abbr => "NY",street_1 => "4502 48th Ave",street_2 => undef}
{city => "Queens",postal_code => 11104,region => "New York",region_abbr => "NY",street_1 => "42-03 Queens Blvd.",street_2 => undef}
{city => "Queens",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "211-35 26th Avenue",street_2 => undef}
{city => "Queens",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "81-22 Leffers Boulevard",street_2 => undef}
{city => "Queens",postal_code => 11375,region => "New York",region_abbr => "NY",street_1 => "70-23 Austin Street",street_2 => undef}
{city => "Queens",postal_code => 11365,region => "New York",region_abbr => "NY",street_1 => "65-64 Fresh Meadow Lane",street_2 => undef}
{city => "Queens",postal_code => 11372,region => "New York",region_abbr => "NY",street_1 => "72-19 Roosevelt Ave",street_2 => undef}
{city => "Rhinecliff",postal_code => 12574,region => "New York",region_abbr => "NY",street_1 => "4 Grinnell Street",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "489 South Ave",street_2 => undef}
{city => "Rochester",postal_code => 14607,region => "New York",region_abbr => "NY",street_1 => "75 Marshall Street",street_2 => undef}
{city => "Rochester",postal_code => 14623,region => "New York",region_abbr => "NY",street_1 => "900 Jefferson Rd",street_2 => undef}
{city => "Rochester",postal_code => 14619,region => "New York",region_abbr => "NY",street_1 => "348 Thurston Rd",street_2 => undef}
{city => "Rochester",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "146 Lincoln Avenue",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "133 Gregory St",street_2 => undef}
{city => "Rochester",postal_code => 14620,region => "New York",region_abbr => "NY",street_1 => "697 South Avenue",street_2 => undef}
{city => "Rochester",postal_code => 14611,region => "New York",region_abbr => "NY",street_1 => "Genessee Park and Genessee Street",street_2 => undef}
{city => "Rock Stream",postal_code => 14878,region => "New York",region_abbr => "NY",street_1 => "2475 Altay Road",street_2 => undef}
{city => "Rockville Centre",postal_code => 11570,region => "New York",region_abbr => "NY",street_1 => "212 N Long Beach Rd",street_2 => undef}
{city => "Sag Harbor",postal_code => 11963,region => "New York",region_abbr => "NY",street_1 => "51 Division Street",street_2 => undef}
{city => "Saint James",postal_code => 11780,region => "New York",region_abbr => "NY",street_1 => "412 North Country Rd",street_2 => undef}
{city => "Saratoga Springs",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "517 Broadway",street_2 => "Roohan Building, Long Alley entrance"}
{city => "Saratoga Springs",postal_code => 12866,region => "New York",region_abbr => "NY",street_1 => "382 Broadway",street_2 => undef}
{city => "Saratoga Springs",postal_code => 12866,region => "New York",region_abbr => "NY",street_1 => "440 Broadway",street_2 => undef}
{city => "Sayville",postal_code => 11782,region => "New York",region_abbr => "NY",street_1 => "39 North Main Street",street_2 => undef}
{city => "Schenectady",postal_code => 12308,region => "New York",region_abbr => "NY",street_1 => "1338 Gerling St,",street_2 => undef}
{city => "Southampton",postal_code => 11968,region => "New York",region_abbr => "NY",street_1 => "56 Nugent Street",street_2 => undef}
{city => "Southold",postal_code => 11971,region => "New York",region_abbr => "NY",street_1 => "46455 Rt. 48",street_2 => undef}
{city => "Spencer",postal_code => 14883,region => "New York",region_abbr => "NY",street_1 => "4 Larue Rd",street_2 => undef}
{city => "St. James",postal_code => 11780,region => "New York",region_abbr => "NY",street_1 => "412 North Country Road",street_2 => undef}
{city => "Staten Island",postal_code => 10310,region => "New York",region_abbr => "NY",street_1 => "604 Forest Ave.",street_2 => undef}
{city => "Staten Island",postal_code => 10306,region => "New York",region_abbr => "NY",street_1 => "177 New Dorp Lane",street_2 => undef}
{city => "Staten Island",postal_code => 10314,region => "New York",region_abbr => "NY",street_1 => "1789 Victory Blvd.",street_2 => undef}
{city => "Staten Island",postal_code => 10309,region => "New York",region_abbr => "NY",street_1 => "4888 Arthur Kill Road",street_2 => undef}
{city => "Staten Island",postal_code => 10301,region => "New York",region_abbr => "NY",street_1 => "323 Victory Blvd",street_2 => undef}
{city => "Staten Island",postal_code => 10301,region => "New York",region_abbr => "NY",street_1 => "1178 Victory Boulevard",street_2 => undef}
{city => "Staten Island",postal_code => 10306,region => "New York",region_abbr => "NY",street_1 => "287 New Dorp Lane",street_2 => undef}
{city => "Staten Island",postal_code => 10305,region => "New York",region_abbr => "NY",street_1 => "1491 Hylan Blvd",street_2 => undef}
{city => "Staten Island",postal_code => 10301,region => "New York",region_abbr => "NY",street_1 => "1180 Victory Blvd",street_2 => undef}
{city => "Staten Island",postal_code => 10305,region => "New York",region_abbr => "NY",street_1 => "1807 Hylan Blvd.",street_2 => undef}
{city => "Staten Island",postal_code => 10310,region => "New York",region_abbr => "NY",street_1 => "1198B Forest Avenue",street_2 => undef}
{city => "Staten Island",postal_code => 10304,region => "New York",region_abbr => "NY",street_1 => "381 Van Duzer Street",street_2 => undef}
{city => "Syracuse",postal_code => 13210,region => "New York",region_abbr => "NY",street_1 => "720 University Avenue",street_2 => undef}
{city => "Syracuse",postal_code => 13210,region => "New York",region_abbr => "NY",street_1 => "719 E. Genesee Street",street_2 => undef}
{city => "Syracuse",postal_code => 13219,region => "New York",region_abbr => "NY",street_1 => "3514 West Genesee Street",street_2 => undef}
{city => "Syracuse",postal_code => 13203,region => "New York",region_abbr => "NY",street_1 => "324 Burnet Avenue",street_2 => undef}
{city => "Tonawanda",postal_code => 14223,region => "New York",region_abbr => "NY",street_1 => "512 Niagara Falls Blvd.",street_2 => undef}
{city => "Troy",postal_code => 12180,region => "New York",region_abbr => "NY",street_1 => "71-81 Congress St.",street_2 => undef}
{city => "Troy",postal_code => 12180,region => "New York",region_abbr => "NY",street_1 => "417 River Street",street_2 => undef}
{city => "Utica",postal_code => 13501,region => "New York",region_abbr => "NY",street_1 => "1105 Lincoln Street",street_2 => undef}
{city => "Watkins Glen",postal_code => 14891,region => "New York",region_abbr => "NY",street_1 => "108 N Franklin Street",street_2 => undef}
{city => "Watkins Glen",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "221 S. Franklin Street",street_2 => undef}
{city => "Watkins Glen",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "200 N. Franklin St.",street_2 => undef}
{city => "Woodstock",postal_code => 12498,region => "New York",region_abbr => "NY",street_1 => "6 Old Forge Road",street_2 => undef}
{city => "Woodstock",postal_code => undef,region => "New York",region_abbr => "NY",street_1 => "4 Rock City Road",street_2 => undef}
{city => "Akron",postal_code => 44303,region => "Ohio",region_abbr => "OH",street_1 => "845 W Market St",street_2 => undef}
{city => "Akron",postal_code => 44313,region => "Ohio",region_abbr => "OH",street_1 => "2303 W. Market St.",street_2 => undef}
{city => "Akron",postal_code => 44308,region => "Ohio",region_abbr => "OH",street_1 => "21 Furnace Street",street_2 => "Ground floor"}
{city => "Akron",postal_code => 44301,region => "Ohio",region_abbr => "OH",street_1 => "1809 South Main Street",street_2 => undef}
{city => "Akron",postal_code => 44303,region => "Ohio",region_abbr => "OH",street_1 => "792 W. Market Street",street_2 => undef}
{city => "Akron",postal_code => 44333,region => "Ohio",region_abbr => "OH",street_1 => "3545 Brookwall Dr.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "371 Richland Avenue",street_2 => undef}
{city => "Beavercreek",postal_code => 45431,region => "Ohio",region_abbr => "OH",street_1 => "2495 Commons Blvd",street_2 => undef}
{city => "Bluffton",postal_code => 45817,region => "Ohio",region_abbr => "OH",street_1 => "103 S. Main St.",street_2 => undef}
{city => "Bowling Green",postal_code => 43402,region => "Ohio",region_abbr => "OH",street_1 => "311 N. Main St.",street_2 => undef}
{city => "Bowling Green",postal_code => 43402,region => "Ohio",region_abbr => "OH",street_1 => "522 E. Wooster St",street_2 => undef}
{city => "Canton",postal_code => 44708,region => "Ohio",region_abbr => "OH",street_1 => "4210 12th Street NW",street_2 => undef}
{city => "Canton",postal_code => 44718,region => "Ohio",region_abbr => "OH",street_1 => "4633 Belden Village St. NW",street_2 => undef}
{city => "Chagrin Falls",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Chagrin Falls",postal_code => 44022,region => "Ohio",region_abbr => "OH",street_1 => "87 West Street",street_2 => undef}
{city => "Chagrin Falls",postal_code => 44022,region => "Ohio",region_abbr => "OH",street_1 => "95 North Main St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "1109 Vine Street",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Cincinnati",postal_code => 45223,region => "Ohio",region_abbr => "OH",street_1 => "4172 Hamilton Ave",street_2 => undef}
{city => "Cincinnati",postal_code => 45226,region => "Ohio",region_abbr => "OH",street_1 => "3543 Columbia Parkway",street_2 => undef}
{city => "Cincinnati",postal_code => 45223,region => "Ohio",region_abbr => "OH",street_1 => "4163 Hamilton Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "1045 St. Gregory St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45223,region => "Ohio",region_abbr => "OH",street_1 => "3938 Springgrove Ave",street_2 => undef}
{city => "Cincinnati",postal_code => 45241,region => "Ohio",region_abbr => "OH",street_1 => "11277 Reading Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45206,region => "Ohio",region_abbr => "OH",street_1 => "1544 Madison Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45213,region => "Ohio",region_abbr => "OH",street_1 => "6227 Montgomery Road",street_2 => undef}
{city => "Cincinnati",postal_code => 45208,region => "Ohio",region_abbr => "OH",street_1 => "2030 Madison Road",street_2 => undef}
{city => "Cincinnati",postal_code => 45226,region => "Ohio",region_abbr => "OH",street_1 => "4343 Kellogg Avenue",street_2 => undef}
{city => "Cincinnati",postal_code => 45219,region => "Ohio",region_abbr => "OH",street_1 => "245 W McMillan St",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "700 Elm Street",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "1637 Vine Street",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "1331 Main St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3212 Madison Road",street_2 => undef}
{city => "Cincinnati",postal_code => 45219,region => "Ohio",region_abbr => "OH",street_1 => "239 W. McMillan St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45223,region => "Ohio",region_abbr => "OH",street_1 => "4035 Hamilton Avenue",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "1345 Main St.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Cleveland",postal_code => 44118,region => "Ohio",region_abbr => "OH",street_1 => "2179 Lee Road",street_2 => undef}
{city => "Cleveland",postal_code => 44114,region => "Ohio",region_abbr => "OH",street_1 => "140 Public Square",street_2 => "The Park Building"}
{city => "Cleveland",postal_code => 44115,region => "Ohio",region_abbr => "OH",street_1 => "2230 Euclid Avenue",street_2 => undef}
{city => "Cleveland",postal_code => 44102,region => "Ohio",region_abbr => "OH",street_1 => "11213 Detroit Avenue",street_2 => undef}
{city => "Cleveland",postal_code => 44113,region => "Ohio",region_abbr => "OH",street_1 => "1948 W. 25th Street",street_2 => "(inside Bier Markt)"}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3120 Superior Avenue",street_2 => undef}
{city => "Cleveland",postal_code => 44119,region => "Ohio",region_abbr => "OH",street_1 => "91 East 185th Street",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Cleveland Heights",postal_code => 44118,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Columbus",postal_code => 43229,region => "Ohio",region_abbr => "OH",street_1 => "5597 N.Hamilton Rd.",street_2 => undef}
{city => "Columbus",postal_code => 43026,region => "Ohio",region_abbr => "OH",street_1 => "5398 Roberts Rd.",street_2 => undef}
{city => "Columbus",postal_code => 43221,region => "Ohio",region_abbr => "OH",street_1 => "1288 West Lane Avenue",street_2 => undef}
{city => "Columbus",postal_code => 43205,region => "Ohio",region_abbr => "OH",street_1 => "891 Oak Street",street_2 => undef}
{city => "Columbus",postal_code => 43235,region => "Ohio",region_abbr => "OH",street_1 => "6642 Sawmill Road",street_2 => undef}
{city => "Columbus",postal_code => 43211,region => "Ohio",region_abbr => "OH",street_1 => "2458 Cleveland Ave.",street_2 => undef}
{city => "Columbus",postal_code => 43209,region => "Ohio",region_abbr => "OH",street_1 => "E. Main Street",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "583 E Broad St.",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "247 King Avenue",street_2 => undef}
{city => "Columbus",postal_code => 43206,region => "Ohio",region_abbr => "OH",street_1 => "1297 Parsons Ave.",street_2 => undef}
{city => "Columbus",postal_code => 43026,region => "Ohio",region_abbr => "OH",street_1 => "3185 Hilliard-Rome Rd.",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "1126 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "945 North High Street",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "249 King Ave",street_2 => undef}
{city => "Columbus",postal_code => 43212,region => "Ohio",region_abbr => "OH",street_1 => "1439 Grandview Avenue",street_2 => undef}
{city => "Columbus",postal_code => 43231,region => "Ohio",region_abbr => "OH",street_1 => "5786 Columbus Square",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "641 North High Street",street_2 => undef}
{city => "Dayton",postal_code => 45409,region => "Ohio",region_abbr => "OH",street_1 => "1106 Brown St.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "452 E. Third Street",street_2 => undef}
{city => "Dayton",postal_code => 45406,region => "Ohio",region_abbr => "OH",street_1 => "3489 W. Siebenthaler Ave.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => undef,street_2 => undef}
{city => "Dayton",postal_code => 45402,region => "Ohio",region_abbr => "OH",street_1 => "410 E. 5th St.",street_2 => undef}
{city => "Hilliard",postal_code => 43026,region => "Ohio",region_abbr => "OH",street_1 => "4561 Scioto Darby Creek Road",street_2 => undef}
{city => "Hudson",postal_code => 44236,region => "Ohio",region_abbr => "OH",street_1 => "5657 Darrow Road",street_2 => undef}
{city => "Kent",postal_code => 44240,region => "Ohio",region_abbr => "OH",street_1 => "911 E. Main  St.",street_2 => undef}
{city => "Kent",postal_code => 44240,region => "Ohio",region_abbr => "OH",street_1 => "123 Franklin Ave.",street_2 => undef}
{city => "Kent",postal_code => 44240,region => "Ohio",region_abbr => "OH",street_1 => "1708 E Main St",street_2 => undef}
{city => "Lakewood",postal_code => 44107,region => "Ohio",region_abbr => "OH",street_1 => "11860 Clifton Boulevard",street_2 => undef}
{city => "Lakewood",postal_code => 44107,region => "Ohio",region_abbr => "OH",street_1 => "13800 Detroit Avenue",street_2 => undef}
{city => "Lakewood",postal_code => 44107,region => "Ohio",region_abbr => "OH",street_1 => "15108 Detroit Avenue",street_2 => undef}
{city => "Loveland",postal_code => 45140,region => "Ohio",region_abbr => "OH",street_1 => "920 B Loveland Maderia Rd",street_2 => undef}
{city => "Lyndhurst",postal_code => 44124,region => "Ohio",region_abbr => "OH",street_1 => "5416 Mayfield Rd",street_2 => undef}
{city => "Mason",postal_code => 45040,region => "Ohio",region_abbr => "OH",street_1 => "6176 Tylersville Road",street_2 => undef}
{city => "Medina",postal_code => 44256,region => "Ohio",region_abbr => "OH",street_1 => "811 W. Liberty Street",street_2 => undef}
{city => "Mentor",postal_code => 44060,region => "Ohio",region_abbr => "OH",street_1 => "6900 Center St.",street_2 => undef}
{city => "Miamisburg",postal_code => 45342,region => "Ohio",region_abbr => "OH",street_1 => "47 S. Springboro Pike",street_2 => undef}
{city => "Miamisburg",postal_code => 45342,region => "Ohio",region_abbr => "OH",street_1 => "39 S. Springboro Pike",street_2 => undef}
{city => "Middleburg Heights",postal_code => 44017,region => "Ohio",region_abbr => "OH",street_1 => "38 West Bridge Street",street_2 => undef}
{city => "Milford",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "32 Main Street",street_2 => undef}
{city => "Niles",postal_code => 44446,region => "Ohio",region_abbr => "OH",street_1 => "606 Robbins Ave.",street_2 => undef}
{city => "North Olmsted",postal_code => 44070,region => "Ohio",region_abbr => "OH",street_1 => "26703  Brookpark Extn",street_2 => undef}
{city => "North Olmsted",postal_code => 44070,region => "Ohio",region_abbr => "OH",street_1 => "5106 Great Northern Mall South",street_2 => undef}
{city => "North Ridgeville",postal_code => 44039,region => "Ohio",region_abbr => "OH",street_1 => "34173 Center Ridge Road",street_2 => undef}
{city => "North Royalton",postal_code => 44133,region => "Ohio",region_abbr => "OH",street_1 => "9377 W. Sprague Road",street_2 => "Timber Ridge Plaza"}
{city => "Oberlin",postal_code => 44074,region => "Ohio",region_abbr => "OH",street_1 => "55 E. College Street",street_2 => "Suite 1"}
{city => "Oberlin",postal_code => 44074,region => "Ohio",region_abbr => "OH",street_1 => "93 Elm Street",street_2 => undef}
{city => "Oberlin",postal_code => 44074,region => "Ohio",region_abbr => "OH",street_1 => "113 West College Stree",street_2 => undef}
{city => "Oberlin",postal_code => 44074,region => "Ohio",region_abbr => "OH",street_1 => "22 Carpenter Court",street_2 => undef}
{city => "Pepper Pike",postal_code => 44124,region => "Ohio",region_abbr => "OH",street_1 => "30769 PineTree Rd.",street_2 => undef}
{city => "Reynoldsburg",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "Baldwin Road and East Livingston Avenue",street_2 => "Blacklick Shopping Plaza"}
{city => "Richmond Heights",postal_code => 44143,region => "Ohio",region_abbr => "OH",street_1 => "5156 Wilson Mills Road",street_2 => undef}
{city => "Shaker Heights",postal_code => 44122,region => "Ohio",region_abbr => "OH",street_1 => "27249 Chagrin Boulevard",street_2 => undef}
{city => "Shaker Heights",postal_code => 44122,region => "Ohio",region_abbr => "OH",street_1 => "20600 Chagrin Blvd.",street_2 => undef}
{city => "Sharonville",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "11963 Lebanon Rd",street_2 => undef}
{city => "Solon",postal_code => 44139,region => "Ohio",region_abbr => "OH",street_1 => "28500 Miles Rd",street_2 => "Suite J"}
{city => "Sylvania",postal_code => 43617,region => "Ohio",region_abbr => "OH",street_1 => "3723 King Road",street_2 => undef}
{city => "Toledo",postal_code => 43617,region => "Ohio",region_abbr => "OH",street_1 => "7406 West Central Avenue",street_2 => undef}
{city => "University Heights",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "13998 Cedar Road",street_2 => undef}
{city => "University Heights",postal_code => 44118,region => "Ohio",region_abbr => "OH",street_1 => "13998 Cedar Rd",street_2 => "Whole Foods"}
{city => "Urbana",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "23 Monument Square",street_2 => undef}
{city => "Wadsworth",postal_code => 44281,region => "Ohio",region_abbr => "OH",street_1 => "839 High Street",street_2 => undef}
{city => "Westerville",postal_code => 43081,region => "Ohio",region_abbr => "OH",street_1 => "895 South State St.",street_2 => undef}
{city => "Wooster",postal_code => 44691,region => "Ohio",region_abbr => "OH",street_1 => "138 E.Liberty St.",street_2 => undef}
{city => "Wooster",postal_code => 44691,region => "Ohio",region_abbr => "OH",street_1 => "359 West Liberty Street",street_2 => undef}
{city => "Wooster",postal_code => 44691,region => "Ohio",region_abbr => "OH",street_1 => "150 W. Liberty Street",street_2 => undef}
{city => "Wooster",postal_code => 44691,region => "Ohio",region_abbr => "OH",street_1 => "3694 Burbank Road",street_2 => undef}
{city => "Akron",postal_code => 44308,region => "Ohio",region_abbr => "OH",street_1 => "326 S Main St",street_2 => undef}
{city => "Akron",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "782 W. Market St.",street_2 => undef}
{city => "Akron",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3885 W. Market St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "329 East State St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "10 S. Court St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4 W. State St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "8 Station St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "8 N. Court St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "22 W. Union St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "63 N. Court St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "28 W. Stimson Ave.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "18 W. Union St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "268 E. State St.",street_2 => undef}
{city => "Athens",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "31 N. Court St.",street_2 => undef}
{city => "Beavercreek",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3464 New Germay - Trebein Road",street_2 => undef}
{city => "Beavercreek",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2495 Commons Blvd., Suite A",street_2 => undef}
{city => "Bellefontaine",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1810 S. Main St.",street_2 => undef}
{city => "Berea",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "804 Front St.",street_2 => undef}
{city => "Berea",postal_code => 44017,region => "Ohio",region_abbr => "OH",street_1 => "1330 Bagley Road",street_2 => "Unit 1"}
{city => "Bexley",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2400 E. Main St.",street_2 => undef}
{city => "Boardman",postal_code => 44512,region => "Ohio",region_abbr => "OH",street_1 => "1449 Boardman Canfield Rd.",street_2 => undef}
{city => "Boardman",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4150 Market St.",street_2 => undef}
{city => "Boardman",postal_code => 44514,region => "Ohio",region_abbr => "OH",street_1 => "850 East Western Reserve Road",street_2 => undef}
{city => "Bowling Green",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "175 N. Main St.",street_2 => undef}
{city => "Canal Fulton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "129 N. Canal St.",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "7257 Fulton Road NW",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4048 Lincoln Way East",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3656 Dressler Rd. NW",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1122 30th St. NW",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4629 Cleveland Ave. NW",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4025 Hills & Dales Rd. NW",street_2 => undef}
{city => "Canton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4460 Dressler Rd. NW",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2633 Edmondson Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3210 Madison Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "120 East 7th St",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "7711 Beechmont Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "119 W. Elder St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4760 Red Bank Expressway",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "216 E. 6th St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4181 Hamilton Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "213 W. McMillan St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5461 North Bend Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "631 Vine St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45208,region => "Ohio",region_abbr => "OH",street_1 => "3009 O'Bryon Street",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5805 Deerfield Blvd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45223,region => "Ohio",region_abbr => "OH",street_1 => "4165 Hamilton Ave",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2666 Madison Road",street_2 => undef}
{city => "Cincinnati",postal_code => 45209,region => "Ohio",region_abbr => "OH",street_1 => "3012 Madison Rd",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "7633 Reading Road",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "24 E. 6th St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45220,region => "Ohio",region_abbr => "OH",street_1 => "354 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => 45219,region => "Ohio",region_abbr => "OH",street_1 => "169 W. McMillan St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45220,region => "Ohio",region_abbr => "OH",street_1 => "350 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => 45241,region => "Ohio",region_abbr => "OH",street_1 => "10890 Reading Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45219,region => "Ohio",region_abbr => "OH",street_1 => "121 Calhoun St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45255,region => "Ohio",region_abbr => "OH",street_1 => "8315 Beechmont Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => 45237,region => "Ohio",region_abbr => "OH",street_1 => "7633  Reading Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => 45202,region => "Ohio",region_abbr => "OH",street_1 => "633 Main Street",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2946 Wasson Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "9370 S. Mason Montgomery Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "906 Nassau St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "341 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3120 Madison Road",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1231 Tennessee Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3215 Jefferson Avenue (Clifton)",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "9500 Kenwood Road (Blue Ash)",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "825 Main Street (Downtown)",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2510 Clifton Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "9268 Colerain Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6911 Miami Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "108 W. Elder St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45209,region => "Ohio",region_abbr => "OH",street_1 => "2693 Edmondson Rd",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3443 Edwards Road",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6063 Montgomery Road",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3538 Columbia Parkway",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "127 Calhoun St.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3482 Highland Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3937 Spring Grove Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "358 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3880 Paxton Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "944 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2637 Erie Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "356 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "211 W. Fourth St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45236,region => "Ohio",region_abbr => "OH",street_1 => "8316 Plainfield Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "313 Calhoun St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45219,region => "Ohio",region_abbr => "OH",street_1 => "205 West McMillan",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "9701 Kenwood Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3201 Jefferson Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "314 Ludlow Ave.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "25 W. 6th St.",street_2 => undef}
{city => "Cincinnati",postal_code => 45208,region => "Ohio",region_abbr => "OH",street_1 => "3520 Erie Ave",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "11379 Montgomery Rd.",street_2 => undef}
{city => "Cincinnati",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6 W. Corry St.",street_2 => undef}
{city => "Clayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "8351 N. Main Street",street_2 => undef}
{city => "Cleveland",postal_code => 44110,region => "Ohio",region_abbr => "OH",street_1 => "15711 Waterloo Road",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "12447 Cedar Rd.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2096 S. Taylor Rd.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1834 W. 25th Street",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5801 Detroit Ave.",street_2 => undef}
{city => "Cleveland",postal_code => 44113,region => "Ohio",region_abbr => "OH",street_1 => "3120 Bridge Ave.,",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1010 Prospect Avenue E",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "28500 Miles Rd.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1824 Coventry Rd.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2362 Professor Ave.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "18400 Euclid Ave.",street_2 => undef}
{city => "Cleveland",postal_code => 44106,region => "Ohio",region_abbr => "OH",street_1 => "11075 East Blvd",street_2 => undef}
{city => "Cleveland",postal_code => 44130,region => "Ohio",region_abbr => "OH",street_1 => "6339 Olde York Rd",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6901 Rockside Rd.",street_2 => undef}
{city => "Cleveland",postal_code => 44143,region => "Ohio",region_abbr => "OH",street_1 => "775 Som Center Rd.",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "18334 E. Bagley Rd.",street_2 => undef}
{city => "Cleveland",postal_code => 44120,region => "Ohio",region_abbr => "OH",street_1 => "12706 Larchmere Blvd",street_2 => undef}
{city => "Cleveland",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2221 Professor Ave.",street_2 => undef}
{city => "Cleveland",postal_code => 44118,region => "Ohio",region_abbr => "OH",street_1 => "13955 Cedar Rd",street_2 => undef}
{city => "Columbus",postal_code => "43215-1430",region => "Ohio",region_abbr => "OH",street_1 => "800 N High St",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "443 East Main St.",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "680 N High Street",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "1988 N. High Street",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "1542 N. High Street",street_2 => undef}
{city => "Columbus",postal_code => 43210,region => "Ohio",region_abbr => "OH",street_1 => "2035 Millikin Rd",street_2 => undef}
{city => "Columbus",postal_code => 43202,region => "Ohio",region_abbr => "OH",street_1 => "3269 N High St",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1644 N. High St Unit F",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1423-B Grandview Ave.",street_2 => undef}
{city => "Columbus",postal_code => 43214,region => "Ohio",region_abbr => "OH",street_1 => "816 Bethel Road",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "803 Bethel rd",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1728 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "508 N. Cassady Ave.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "200 Crestview Rd.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1077 Old Henderson Rd.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "59 Spruce St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "495 S. 3rd St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "277 Livingston Ave",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1227 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "11 W. State St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2346 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "427 East Main St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1585 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "475 S. 3rd St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5663 Emporium Square",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5226 Bethel Center Mall",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1634 Northwest Blvd.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "59 Spruce St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "951 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4241 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6135 Parkcenter Circle",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4040 Townsfair Way",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "8489 Sancus Blvd",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1773 W. 5th Ave.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4965 N. High Street",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4601 E. Broad St.",street_2 => undef}
{city => "Columbus",postal_code => 43235,region => "Ohio",region_abbr => "OH",street_1 => "3670 W. Dublin Granville Road",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "618 W. Shrock Rd.",street_2 => undef}
{city => "Columbus",postal_code => 43202,region => "Ohio",region_abbr => "OH",street_1 => "3009 North High Street",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2500 Bethel Rd.",street_2 => undef}
{city => "Columbus",postal_code => 43231,region => "Ohio",region_abbr => "OH",street_1 => "5657 Emporium Square",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "41 W. Swan St.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6355 Sawmill Rd",street_2 => undef}
{city => "Columbus",postal_code => 43229,region => "Ohio",region_abbr => "OH",street_1 => "2001 E. Dublin Granville Rd.",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3888 Townsfair Way",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "249 King Ave.",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "2321 North High Street",street_2 => undef}
{city => "Columbus",postal_code => "43202-2923",region => "Ohio",region_abbr => "OH",street_1 => "2439 N High St",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1493 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => 43207,region => "Ohio",region_abbr => "OH",street_1 => "1363 S. High Street",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "1778 N. High Street",street_2 => undef}
{city => "Columbus",postal_code => 43206,region => "Ohio",region_abbr => "OH",street_1 => "1279 Parsons",street_2 => undef}
{city => "Columbus",postal_code => 43221,region => "Ohio",region_abbr => "OH",street_1 => "1555 W Lane Ave",street_2 => undef}
{city => "Columbus",postal_code => 43201,region => "Ohio",region_abbr => "OH",street_1 => "2060 N. High Street",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "982 North High Street",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "765 Neil Ave  and 443 East Main St.",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "59 Spruce Street",street_2 => undef}
{city => "Columbus",postal_code => 43202,region => "Ohio",region_abbr => "OH",street_1 => "2361 N High St",street_2 => undef}
{city => "Columbus",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2931 N. High St.",street_2 => undef}
{city => "Columbus",postal_code => 43215,region => "Ohio",region_abbr => "OH",street_1 => "525 Short Street",street_2 => undef}
{city => "Cuyahoga Falls",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "615 Graham Road",street_2 => undef}
{city => "Cuyahoga Falls",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2033 State Rd.",street_2 => undef}
{city => "Dayton",postal_code => 45459,region => "Ohio",region_abbr => "OH",street_1 => "2700 Miamisburg Centerville Road",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6177 Far Hills Ave.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5524 Airway Rd.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "8258 N. Main St.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1718 Woodman Dr.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2901 Philadelphia Dr.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1219 Wilmington Ave.",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2626 Miamisburg-Centerville Rd.",street_2 => undef}
{city => "Dayton",postal_code => 45402,region => "Ohio",region_abbr => "OH",street_1 => "600 E. 2nd Street",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "11 Brown Street",street_2 => undef}
{city => "Dayton",postal_code => 45424,region => "Ohio",region_abbr => "OH",street_1 => "2020 Harshman Road",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "725 Lyons Rd",street_2 => undef}
{city => "Dayton",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "9142 Dayton - Lebanon Pike",street_2 => undef}
{city => "Dayton",postal_code => 45409,region => "Ohio",region_abbr => "OH",street_1 => "1153 Brown St",street_2 => undef}
{city => "Dayton",postal_code => 45458,region => "Ohio",region_abbr => "OH",street_1 => "8971 Kingsridge Dr",street_2 => undef}
{city => "Dayton",postal_code => 45459,region => "Ohio",region_abbr => "OH",street_1 => "2094 Miamisburg Centerville Road",street_2 => undef}
{city => "Dublin",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6804 Perimeter Loop Rd.",street_2 => undef}
{city => "Fairborn",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "60 South Broad St.",street_2 => undef}
{city => "Fairborn",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2632 Colonel Glenn Highway",street_2 => undef}
{city => "Fairfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5440 Dixie Highway",street_2 => undef}
{city => "Fairlawn",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3750 W. Market St.",street_2 => undef}
{city => "Findlay",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "600 S. Blanchard St.",street_2 => undef}
{city => "Gahanna",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1307 Stoneridge Dr.",street_2 => undef}
{city => "Gahanna",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4355 Morse Rd.",street_2 => undef}
{city => "Geneva",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6810 N. Ridge East",street_2 => undef}
{city => "German",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1105 Upper Valley Pk.",street_2 => undef}
{city => "Glendale",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "40 Village Square",street_2 => undef}
{city => "Hilliard",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4728 Cemetery Rd.",street_2 => undef}
{city => "Hilliard",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5240 Cemetery Rd.",street_2 => undef}
{city => "Huber Heights",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "6118 Chamberburg Rd.",street_2 => undef}
{city => "Hudson",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "44 Park Lane Dr",street_2 => undef}
{city => "Jackson",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4118 Belden Village St., NW",street_2 => undef}
{city => "Jackson",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4695 Dressler Rd. NW",street_2 => undef}
{city => "Jackson",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4794 Dressler Road NW",street_2 => undef}
{city => "Kent",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "151 E. Main St.",street_2 => undef}
{city => "Kent",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "319 W. Main St.",street_2 => undef}
{city => "Kettering",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "3063 Woodman Dr.",street_2 => undef}
{city => "Kettering",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2318 E. Dorothy Ln.",street_2 => undef}
{city => "Kettering",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4077 E. Town & Country Rd.",street_2 => undef}
{city => "Kettering",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "912 E Dorothy Ln.",street_2 => undef}
{city => "Kettering",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "328 E. Stroop Rd.",street_2 => undef}
{city => "Lakewood",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "14536 Detroit Rd.",street_2 => undef}
{city => "Lakewood",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "18120 Sloane Ave.",street_2 => undef}
{city => "Lakewood",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "12210 Madison Ave.",street_2 => undef}
{city => "Lakewood",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "12906 Madison Ave.",street_2 => undef}
{city => "Lakewood",postal_code => 44107,region => "Ohio",region_abbr => "OH",street_1 => "14718 Detroit Avenue",street_2 => undef}
{city => "Lyndhurst",postal_code => 44124,region => "Ohio",region_abbr => "OH",street_1 => "1609 Overbrook Rd.",street_2 => undef}
{city => "Mansfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1360 S. Trimble Rd.",street_2 => undef}
{city => "Mansfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "283 Ashland Rd.",street_2 => undef}
{city => "Mansfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1971 W. 4th St.",street_2 => undef}
{city => "Mansfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "1393 Lexington Ave.",street_2 => undef}
{city => "Mansfield",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2067 W. 4th St.",street_2 => undef}
{city => "Mariemont",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "7227 Wooster Rd.",street_2 => undef}
{city => "Marietta",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "211 Second st",street_2 => undef}
{city => "Mason",postal_code => 45040,region => "Ohio",region_abbr => "OH",street_1 => "5805 Deerfield Boulevard",street_2 => undef}
{city => "Mason",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "4752 Fields Ertel Road",street_2 => undef}
{city => "Mason",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "5232 Bardes Rd.",street_2 => undef}
{city => "Miamisburg",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2759 Miamisburg-Centerville Rd.",street_2 => undef}
{city => "Miamisburg",postal_code => undef,region => "Ohio",region_abbr => "OH",street_1 => "2108 Miamisburg-Centerville Rd.",street_2 => undef}
{city => "Miamisburg",postal_code => undef,region => "Ohio",region_abbr => "O