#!/usr/bin/perl 
#===============================================================================
#
#         FILE:  makeppd.pl
#
#        USAGE:  ./makeppd.pl 
#
#  DESCRIPTION:  
#
#      OPTIONS:  ---
# REQUIREMENTS:  ---
#         BUGS:  ---
#        NOTES:  http://jenda.krynicky.cz/perl/PPM.html
#                I use the script below to generate both ordinary distributions and PPM distributions at once.
#                
#                This process creates three files :
#                
#                 ModuleName-version.tar.gz = ordinary distro
#                 ModuleName.ppd = the ppd description file
#                 ModuleName-version-PPM.tar.gz = the archive for PPM
#                If you add line with
#                
#                        PPM_BINDIR='something'
#                into ...\perl\lib\Config.pm, or to system varibles, it will be used as the directory where you store the archives. 
#   			 For example if you have the ppd files in http://www.yoursite.com/packages/ and the archives in 
#	    		 http://www.yoursite.com/packages/x86, the variable should contain 'x86'.
#                
#                
#       AUTHOR:   ``Jan Krynicky'' <Jenda@Krynicky.cz>
#      COMPANY:  
#      VERSION:  2.0
#      CREATED:  21/07/2009 08:59:06 GMT
#     REVISION:  ---
#===============================================================================

use strict;
use warnings;

#makeppd.pl 2.0
        use FileHandle;
        use File::DosGlob qw(glob);
        use Win32::FileOp;
        $make='nmake.exe';
        END {print "\nDONE -- PRESS ENTER\n";<STDIN>};
        my $has_xs = 0;
        #unixify files
        {
                opendir my $DIR, '.' or die "Can't read current directory: $!\n";
                my $file ;
                while (defined($file = readdir $DIR)) {
                        $has_xs = 1 if $file =~ /\.xs$/i;
                        next unless $file =~ /\.(?:pm|pl|xs|t|html|htm|txt)$/i or $file =~ /^(?:MANIFEST|Changes)$/i;
                        open my $FILE, "<".$file or die "Can't open file $file : $!\n";
                        binmode $FILE;
                        my $line = <$FILE>;
        #               next unless $line =~ /\r/;
                        open my $OUT, ">".$file.".tmp" or die "Can't create file $file.tmp : $!\n";
                        binmode $OUT;
                        while (defined $line) {
                                $line =~ s/\r?\n?$//;
                                print $OUT $line,"\x0A";
                                $line = <$FILE>
                        }
                        close $FILE;
                        close $OUT;
                        unlink $file;
                        rename $file.'.tmp' => $file;
                }
        }
        system('perl Makefile.PL');
        system($make) and die "Failed to make!\n";
        system($make, 'dist'); # this creates the ordinary distribution
        # I need the archive to find the version number!
        # If you comment this out, always copy the archive to current directory.
        # this part of code finds the latest distribution, I don't have time to
        # explore how to find the version number
        @archives = grep {!/-PPM\.tar\.gz$/i} <*.tar.gz>;
        $archive = findNewest (@archives);
        ($name = $archive) =~ s/\.tar\.gz$//;
        ($module = $name) =~ s/-[\d.]+$//;
        ($file = $module) =~ s/^.*-(.*?)$/$1/;
        $ppd = $module.".ppd";
        $module =~ s/-/\\/g;
        print "Module name : $file\n";
        print "Newest archive is $archive\n";
        system('perl','Makefile.PL', "BINARY_LOCATION=$name-PPM.tar.gz");
        system($make, 'ppd');
        # you may do something like
        # system($make, 'ppd', "BINARY_LOCATION=$name-PPM.tar.gz");
        # if you do not apply my patch to ExtUtils\MM_Unix.pm
        print (qq{pod2html.bat "-htmlroot=." "$file.pm" "-outfile=$file.html"\n});
        system(qq{pod2html.bat "-htmlroot=." "$file.pm" "-outfile=$file.html"});
        #mkdir 'blib/html'; # not necessary
        Copy "$file.html" => "$file.pm.html";
        Move "$file.html" => "blib/html/site/lib/$module.html";
        system(qq{pod2text.bat "$file.pm" "$file.pm.txt"});
        system("tar cvf $name-PPM.tar blib");
        system("gzip --best $name-PPM.tar");
        Delete qw(blib pod2html-dircache pod2html-itemcache pm_to_blib pod2htmd.x~~ pod2htmi.x~~);
        if (! $has_xs) {
                open $PPD, "<$ppd" or die "Can't open the $ppd file: $!\n";
                open $NEWPPD, ">$ppd.tmp" or die "Can't create the $ppd.tmp file: $!\n";
                while (<$PPD>) {
                        next if (/<ARCHITECTURE/);
                        print $NEWPPD $_;
                }
                close $PPD; close $NEWPPD;
                unlink $ppd;
                rename $ppd.'.tmp' => $ppd;
        }
        exit;
        #==================
        sub findNewest {
                my $maxitem;
                my $maxver = pack('C4',0,0,0,0);
                foreach my $item (@_) {
                        $item =~ /-(\d+)\.(\d+)\.(?:(\d+)\.(?:(\d+)\.)?)?tar\.gz/;
                        my $ver = pack('C4',$1,$2,$3,$4);
                        if ($ver gt $maxver) {
                                $maxver = $ver;
                                $maxitem = $item;
                        }
                }
                return $maxitem;
        }



