use Cro::HTTP::Server;
use Cro::HTTP::Router;
use Cro::HTTP::Client;
use CamelPub::WebFinger;
use CamelPub::ActivityPub;
use JSON::Fast;

module Server {
  constant META6 = from-json slurp "META6.json";
  our $DEBUG = False;

  our sub application(ActivityPub::Document $activitypub_profile) {
    route {
      before { say request.Str if $DEBUG }
      after { say response.Str if $DEBUG }

      get -> '.well-known', 'nodeinfo' {
        my Cro::HTTP::Header $host = request.headers.first: {.name.fc eq "host"};
        content 'application/json', to-json WebFinger::jrd("http://{$host.value}/api/nodeinfo");
      }

      get -> '.well-known', 'webfinger' {
        my $webfinger_profile = WebFinger::minimal_profile($activitypub_profile.webfinger_acct);
        say "-> {$webfinger_profile.links(:rel('self'))}";
        content 'application/json', to-json $webfinger_profile.document;
      }

      get -> 'api', 'nodeinfo' {
        content 'application/json', to-json nodeinfo();
      }

      get -> *@parts {
        say "-> sending activitypub profile for {$activitypub_profile.id}";
        content 'application/json', to-json $activitypub_profile.document;
      }

      post -> *@parts {
        say "-> {to-json (await request.body)}";
        content 'application/json', '{}';
      }
    }
  }

  sub nodeinfo returns Hash {
    { "version" => "2.0",
      "software" => { "name" => "camelpub", "version" => META6{'version'} },
      "protocols" => ["activitypub"],
      "openRegistrations" => False,
      "usage" => { "localPosts" => 0, "localComments" => 0,
                   "users" => { "total" => 1, "activeHalfyear" => 0, "activeMonth" => 1 }},
      "metadata" => {}
    }
  }
}
