# Generated at install time by JavaMap.PL
# /usr/bin/perl ./JavaMap.PL inc/DefaultMap.pm /usr/lib/tztab
use strict;
use warnings;
package DefaultMap;

our $VERSION = '20091015.12';

# Maps HP-UX timezone names to Olson DB names
our %tz_map = (
    'AST10ADT' => 'America/Adak', 
    'AST4' => 'America/Guadeloupe', 
    'AST4ADT' => 'America/Halifax', 
    'CST-9:30CDT' => 'Australia/Adelaide', 
    'CST6CDT' => 'America/Chicago', 
    'CST6CDT#Canada' => 'America/Winnipeg', 
    'EAT-3' => 'Indian/Mayotte', 
    'EET-2EETDST' => 'Europe/Helsinki', 
    'EST-10EDT' => 'Australia/Sydney', 
    'EST-10EDT#NSW' => 'Australia/Sydney', 
    'EST-10EDT#Tasmania' => 'Australia/Hobart', 
    'EST-10EDT#VIC' => 'Australia/Sydney', 
    'EST5CDT' => 'America/Indianapolis', 
    'EST5EDT' => 'America/New_York', 
    'EST5EDT#Canada' => 'America/Montreal', 
    'EST5EST' => 'America/Indianapolis', 
    'EST6CDT' => 'America/Indianapolis', 
    'GAMT-9' => 'Pacific/Gambier', 
    'GFT3' => 'America/Cayenne', 
    'GMT0BST' => 'Europe/London', 
    'MART-9:30' => 'Pacific/Marquesas', 
    'MET-1METDST' => 'Europe/Paris', 
    'MEZ-1MESZ' => 'Europe/Berlin', 
    'MST7MDT' => 'America/Denver', 
    'MST7MDT#Canada' => 'America/Edmonton', 
    'NCT-11' => 'Pacific/Noumea', 
    'NST3:30NDT' => 'America/St_Johns', 
    'NZST-12NZDT' => 'Pacific/Auckland', 
    'PMST3PMDT' => 'America/Miquelon', 
    'PST-8PDT' => 'Asia/Singapore', 
    'PST8PDT' => 'America/Los_Angeles', 
    'PST8PDT#Canada' => 'America/Vancouver', 
    'PWT0PST' => 'Europe/Lisbon', 
    'RET-4' => 'Indian/Reunion', 
    'SAST-2' => 'Africa/Johannesburg', 
    'TAHT10' => 'Pacific/Tahiti', 
    'WET0WETDST' => 'Europe/London', 
    'WST-10WSTDST' => 'Asia/Vladivostok', 
    'WST-11WSTDST' => 'Asia/Magadan', 
    'WST-12WSTDST' => 'Asia/Kamchatka', 
    'WST-2WSTDST' => 'Europe/Minsk', 
    'WST-3WSTDST' => 'Europe/Moscow', 
    'WST-4WSTDST' => 'Europe/Samara', 
    'WST-5WSTDST' => 'Asia/Yekaterinburg', 
    'WST-6WSTDST' => 'Asia/Novosibirsk', 
    'WST-7WSTDST' => 'Asia/Krasnoyarsk', 
    'WST-8WSTDST' => 'Asia/Irkutsk', 
    'WST-9WSTDST' => 'Asia/Yakutsk', 
    'YST9YDT' => 'America/Anchorage',
);

1;
__END__

=head1 NAME

DefaultMap - Mapping of HPUX timezones to DateTime::TimeZone names

=head1 VERSION

20091015.12

=head1 SYNOPSIS

This is a private module of L<DateTime::TimeZone::HPUX> that has no public API.

=head1 DESCRIPTION

This module has been generated by JavaMap.PL at install time of
L<DateTime::TimeZone::HPUX> from F</usr/lib/tztab> and the Java Runtime
Environment mapping.

The following mapping has been recorded:

    AST10ADT              America/Adak 
    AST4                  America/Guadeloupe 
    AST4ADT               America/Halifax 
    CST-9:30CDT           Australia/Adelaide 
    CST6CDT               America/Chicago 
    CST6CDT#Canada        America/Winnipeg 
    EAT-3                 Indian/Mayotte 
    EET-2EETDST           Europe/Helsinki 
    EST-10EDT             Australia/Sydney 
    EST-10EDT#NSW         Australia/Sydney 
    EST-10EDT#Tasmania    Australia/Hobart 
    EST-10EDT#VIC         Australia/Sydney 
    EST5CDT               America/Indianapolis 
    EST5EDT               America/New_York 
    EST5EDT#Canada        America/Montreal 
    EST5EST               America/Indianapolis 
    EST6CDT               America/Indianapolis 
    GAMT-9                Pacific/Gambier 
    GFT3                  America/Cayenne 
    GMT0BST               Europe/London 
    MART-9:30             Pacific/Marquesas 
    MET-1METDST           Europe/Paris 
    MEZ-1MESZ             Europe/Berlin 
    MST7MDT               America/Denver 
    MST7MDT#Canada        America/Edmonton 
    NCT-11                Pacific/Noumea 
    NST3:30NDT            America/St_Johns 
    NZST-12NZDT           Pacific/Auckland 
    PMST3PMDT             America/Miquelon 
    PST-8PDT              Asia/Singapore 
    PST8PDT               America/Los_Angeles 
    PST8PDT#Canada        America/Vancouver 
    PWT0PST               Europe/Lisbon 
    RET-4                 Indian/Reunion 
    SAST-2                Africa/Johannesburg 
    TAHT10                Pacific/Tahiti 
    WET0WETDST            Europe/London 
    WST-10WSTDST          Asia/Vladivostok 
    WST-11WSTDST          Asia/Magadan 
    WST-12WSTDST          Asia/Kamchatka 
    WST-2WSTDST           Europe/Minsk 
    WST-3WSTDST           Europe/Moscow 
    WST-4WSTDST           Europe/Samara 
    WST-5WSTDST           Asia/Yekaterinburg 
    WST-6WSTDST           Asia/Novosibirsk 
    WST-7WSTDST           Asia/Krasnoyarsk 
    WST-8WSTDST           Asia/Irkutsk 
    WST-9WSTDST           Asia/Yakutsk 
    YST9YDT               America/Anchorage

If your timezone is not in this list:

=over 4

=item *

Check that the timezone is declared when you build the module:

=over 4

=item - in F</usr/lib/tztab>. See tztab(4) for the file format.

=item - in $ENV{TZ}

=back

=item *

Check that the timezone is supported by your JRE (the F<TZ.class> file is
bundled in the DateTime::TimeZone::HPUX distribution and installed in the same
directory than this module):

    TZ=I<timezone> java -cp I<directory> TZ

If not, update your JRE by installing HP's patches from
L<http://docs.hp.com/en/HPUXJAVAPATCHES/>

=item *

Rebuild DT::TZ::HPUX:

    cpan> force install DateTime::TimeZone::HPUX

=back

=head1 SEE ALSO

L<DateTime::TimeZone::HPUX>

=cut
