package Locales::DB::Language::fa;

# Auto generated from CLDR

$Locales::DB::Language::fa::VERSION = '0.08';

$Locales::DB::Language::fa::cldr_version = '2.0';

%Locales::DB::Language::fa::misc_info = (
    'characters'   => { 'more_information' => '؟' },
    'cldr_formats' => {
        '_decimal_format_decimal' => '٫',
        '_decimal_format_group'   => '٬',
        '_percent_format_percent' => '٪',
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "زبان\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ و\ \{1\}",
            'end'    => "\{0\}،\ و\ \{1\}",
            'middle' => "\{0\}،‏\ \{1\}",
            'start'  => "\{0\}،‏\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "ناحیه\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '›',
        'alternate_quotation_start' => '‹',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "right\-to\-left",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => [ 'other' ],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "نه\:ن\:خیر\:خ",
        'yesstr' => "بله\:ب\:آری\:آ"
    },
);

%Locales::DB::Language::fa::code_to_name = (
    'aa'    => 'آفاری',
    'ab'    => 'آبخازی',
    'ace'   => 'آچئی',
    'ach'   => 'آچولیایی',
    'ada'   => 'آدانگمه‌ای',
    'ady'   => 'آدیجیایی',
    'ae'    => 'اوستایی',
    'af'    => 'آفریکانس',
    'afa'   => "زبان\ افریقا\ و\ آسیایی",
    'afh'   => 'آفریهیلی',
    'agq'   => 'Aghem',
    'ain'   => 'آینویی',
    'ak'    => 'آکان',
    'akk'   => 'آکدی',
    'ale'   => 'آلئوتی',
    'alg'   => "زبان\ آلگونکینی",
    'alt'   => "آلتایی\ جنوبی",
    'am'    => 'امهری',
    'an'    => 'آراگونی',
    'ang'   => "انگلیسی\ باستان",
    'anp'   => 'آنگیکا',
    'apa'   => "زبان\ آپاچیایی",
    'ar'    => 'عربی',
    'arc'   => 'آرامی',
    'arn'   => 'آروکانیایی',
    'arp'   => 'آراپاهویی',
    'art'   => "زبان\ ساختگی",
    'arw'   => 'آراواکی',
    'as'    => 'آسامی',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "زبان\ آتاپاسکایی",
    'aus'   => "زبان\ استرالیایی",
    'av'    => 'آواری',
    'awa'   => 'Awadhi',
    'ay'    => 'آیمارایی',
    'az'    => 'آذربایجانی',
    'ba'    => 'باشغیری',
    'bad'   => 'باندایی',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'بلوچی',
    'ban'   => 'بالیایی',
    'bas'   => 'باسایی',
    'bat'   => "زبان\ بالتیکی",
    'be'    => 'بلوروسی',
    'bej'   => 'بجایی',
    'bem'   => 'بمبایی',
    'ber'   => 'بربری',
    'bez'   => 'Bena',
    'bg'    => 'بلغاری',
    'bh'    => 'بیهاری',
    'bho'   => 'بوجپوری',
    'bi'    => 'بیسلاما',
    'bik'   => 'بیکولی',
    'bin'   => 'بینی',
    'bla'   => 'Siksika',
    'bm'    => 'بامبارایی',
    'bn'    => 'بنگالی',
    'bnt'   => 'بانتویی',
    'bo'    => 'تبتی',
    'br'    => 'برتانیایی',
    'bra'   => 'براج',
    'brx'   => 'Bodo',
    'bs'    => 'بوسنیایی',
    'btk'   => 'باتاکی',
    'bua'   => 'بوریاتی',
    'bug'   => 'بوگیایی',
    'byn'   => 'بلین',
    'ca'    => 'کاتالان',
    'cad'   => 'کادویی',
    'cai'   => "زبان\ سرخپوستی\ امریکای\ مرکزی",
    'car'   => 'کاریبی',
    'cau'   => "زبان\ قفقازی",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'چچنی',
    'ceb'   => 'سبویی',
    'cel'   => "زبان\ سلتی",
    'cgg'   => 'Chiga',
    'ch'    => 'چامورویی',
    'chb'   => 'چیبچا',
    'chg'   => 'جغتایی',
    'chk'   => 'چوکی',
    'chm'   => 'ماریایی',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'چوکتویی',
    'chp'   => 'چیپه‌ویه‌ای',
    'chr'   => 'چروکیایی',
    'chy'   => 'شایانی',
    'cmc'   => "Chamic\ Language",
    'co'    => 'کورسی',
    'cop'   => 'قبطی',
    'cpe'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ انگلیسی",
    'cpf'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ فرانسوی",
    'cpp'   => "کریول\ یا\ پیجین\ مبتنی\ بر\ پرتغالی",
    'cr'    => 'کریایی',
    'crh'   => "ترکی\ کریمه",
    'crp'   => "کریول\ یا\ پیجین",
    'cs'    => 'چکی',
    'csb'   => 'کاشوبی',
    'cu'    => "اسلاوی\ کلیسایی",
    'cus'   => "زبان\ کوشی",
    'cv'    => 'چوواشی',
    'cy'    => 'ویلزی',
    'da'    => 'دانمارکی',
    'dak'   => 'داکوتایی',
    'dar'   => 'دارقینی',
    'dav'   => 'Taita',
    'day'   => 'دایاک',
    'de'    => 'آلمانی',
    'de_at' => "آلمانی\ اتریش",
    'de_ch' => "آلمانی\ علیای\ سوئیس",
    'del'   => 'دلاواری',
    'den'   => 'Slave',
    'dgr'   => 'دوگریب',
    'din'   => 'دینکایی',
    'dje'   => 'Zarma',
    'doi'   => 'دوگری',
    'dra'   => "زبان\ دراویدی",
    'dsb'   => "صُربی\ سفلی",
    'dua'   => 'دوآلایی',
    'dum'   => "هلندی\ میانه",
    'dv'    => 'مالدیوی',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'دایولایی',
    'dz'    => 'جونخایی',
    'ebu'   => 'Embu',
    'ee'    => 'اوه‌ای',
    'efi'   => 'افیکی',
    'egy'   => "مصری\ کهن",
    'eka'   => 'اکاجوک',
    'el'    => 'یونانی',
    'elx'   => 'عیلامی',
    'en'    => 'انگلیسی',
    'en_au' => "انگلیسی\ استرالیا",
    'en_ca' => "انگلیسی\ کانادا",
    'en_gb' => "انگلیسی\ بریتانیا",
    'en_us' => "انگلیسی\ امریکا",
    'enm'   => "انگلیسی\ میانه",
    'eo'    => 'اسپرانتو',
    'es'    => 'اسپانیایی',
    'es_es' => "اسپانیایی\ اسپانیا",
    'et'    => 'استونیایی',
    'eu'    => 'باسکی',
    'ewo'   => 'اواندو',
    'fa'    => 'فارسی',
    'fan'   => 'فانکی',
    'fat'   => 'فانتیایی',
    'ff'    => 'فولایی',
    'fi'    => 'فنلاندی',
    'fil'   => 'فیلیپینی',
    'fiu'   => "زبان\ فین\ و\ اوگرایی",
    'fj'    => 'فیجیایی',
    'fo'    => 'فارویی',
    'fon'   => 'فونی',
    'fr'    => 'فرانسوی',
    'fr_ca' => "فرانسوی\ کانادا",
    'fr_ch' => "فرانسوی\ سوئیس",
    'frm'   => "فرانسوی\ میانه",
    'fro'   => "فرانسوی\ باستان",
    'frr'   => "فریزی\ شمالی",
    'frs'   => "فریزی\ شرقی",
    'fur'   => 'فریولیایی',
    'fy'    => "فریزی\ غربی",
    'ga'    => 'ایرلندی',
    'gaa'   => 'گایی',
    'gay'   => 'گایویی',
    'gba'   => 'گبایایی',
    'gd'    => "گیلی\ اسکاتلندی",
    'gem'   => "زبان\ ژرمنی",
    'gez'   => 'گی‌ئزی',
    'gil'   => 'گیلبرتی',
    'gl'    => 'گالیسیایی',
    'gmh'   => "آلمانی\ علیای\ میانه",
    'gn'    => 'گوارانی',
    'goh'   => "آلمانی\ علیای\ باستان",
    'gon'   => 'گوندی',
    'gor'   => 'گورونتالو',
    'got'   => 'گوتی',
    'grb'   => 'گریبویی',
    'grc'   => "یونانی\ کهن",
    'gsw'   => "آلمانی\ سوئیسی",
    'gu'    => 'گجراتی',
    'guz'   => 'Gusii',
    'gv'    => 'مانی',
    'gwi'   => "گویچ\ این",
    'ha'    => 'هوسیایی',
    'hai'   => 'هایدایی',
    'haw'   => 'هاوائیایی',
    'he'    => 'عبری',
    'hi'    => 'هندی',
    'hil'   => 'هیلی‌گاینونی',
    'him'   => 'هیماچالی',
    'hit'   => 'هیتی',
    'hmn'   => 'همونگ',
    'ho'    => "موتویی\ هیری",
    'hr'    => 'کروات',
    'hsb'   => "صُربی\ علیا",
    'ht'    => 'هائیتیایی',
    'hu'    => 'مجاری',
    'hup'   => 'هوپا',
    'hy'    => 'ارمنی',
    'hz'    => 'هریرویی',
    'ia'    => 'میان‌زبان',
    'iba'   => 'آیبن',
    'id'    => 'اندونزیایی',
    'ie'    => 'اکسیدنتال',
    'ig'    => 'ایگبویی',
    'ii'    => "یی\ سیچوان",
    'ijo'   => 'ایجویی',
    'ik'    => 'اینوپیک',
    'ilo'   => 'ایلوکویی',
    'inc'   => "زبان\ هندیک",
    'ine'   => "زبان\ هند\ و\ اروپایی",
    'inh'   => 'اینگوشی',
    'io'    => 'ایدو',
    'ira'   => "زبان\ ایرانی",
    'iro'   => "زبان\ ایروکوایی",
    'is'    => 'ایسلندی',
    'it'    => 'ایتالیایی',
    'iu'    => 'اینوکتیتوت',
    'ja'    => 'ژاپنی',
    'jbo'   => 'لوجبان',
    'jmc'   => 'Machame',
    'jpr'   => "فارسی\ یهودی",
    'jrb'   => "عربی\ یهودی",
    'jv'    => 'جاوه‌ای',
    'ka'    => 'گرجی',
    'kaa'   => 'قره‌قالپاقی',
    'kab'   => 'قبایلی',
    'kac'   => 'کاچینی',
    'kaj'   => 'جو',
    'kam'   => 'کامبایی',
    'kar'   => 'کارنی',
    'kaw'   => 'کاویایی',
    'kbd'   => 'کاباردینی',
    'kcg'   => "تایپه\ ای",
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'کورو',
    'kg'    => 'کنگویی',
    'kha'   => 'خاسیایی',
    'khi'   => "زبان\ خواسی",
    'kho'   => 'ختنی',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'کیکویویی',
    'kj'    => 'کوانیاما',
    'kk'    => 'قزاقی',
    'kl'    => 'گرینلندی',
    'kln'   => 'Kalenjin',
    'km'    => 'خمری',
    'kmb'   => 'کیمبوندویی',
    'kn'    => 'کاناده‌ای',
    'ko'    => 'کره‌ای',
    'kok'   => 'کنکانی',
    'kos'   => 'Kosraean',
    'kpe'   => 'کپله‌ای',
    'kr'    => 'کانوریایی',
    'krc'   => 'قره‌چایی‐بالکاری',
    'krl'   => 'Karelian',
    'kro'   => 'کرویی',
    'kru'   => 'کوروخی',
    'ks'    => 'کشمیری',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'کردی',
    'kum'   => 'کومیکی',
    'kut'   => 'کوتنی',
    'kv'    => 'کومیایی',
    'kw'    => 'کرنوالی',
    'ky'    => 'قرقیزی',
    'la'    => 'لاتینی',
    'lad'   => 'لادینو',
    'lag'   => 'Langi',
    'lah'   => 'لاهندا',
    'lam'   => 'لامبا',
    'lb'    => 'لوگزامبورگی',
    'lez'   => 'لزگی',
    'lg'    => 'گاندایی',
    'li'    => 'لیمبورگی',
    'ln'    => 'لینگالا',
    'lo'    => 'لائوسی',
    'lol'   => 'مونگویی',
    'loz'   => 'لوزیایی',
    'lt'    => 'لیتوانیایی',
    'lu'    => 'لوبایی‐کاتانگا',
    'lua'   => 'لوبایی‐لولوا',
    'lui'   => 'لویسنو',
    'lun'   => 'لوندایی',
    'luo'   => 'لوئویی',
    'lus'   => 'لوشه‌ای',
    'luy'   => 'Luyia',
    'lv'    => 'لتونیایی',
    'mad'   => 'مادورایی',
    'mag'   => 'ماگاهیایی',
    'mai'   => 'مایدیلی',
    'mak'   => 'ماکاسار',
    'man'   => 'ماندینگویی',
    'map'   => "زبان\ آسترونیزیایی",
    'mas'   => 'ماسایی',
    'mdf'   => 'مکشایی',
    'mdr'   => 'ماندار',
    'men'   => 'منده‌ای',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'مالاگاسیایی',
    'mga'   => "ایرلندی\ میانه",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'مارشالی',
    'mi'    => 'مائوریایی',
    'mic'   => 'میکماکی',
    'min'   => 'مینانگ‌کابویی',
    'mis'   => "زبان\ متفرقه",
    'mk'    => 'مقدونی',
    'mkh'   => "زبان\ مون‌خمری",
    'ml'    => 'مالایالامی',
    'mn'    => 'مغولی',
    'mnc'   => 'مانچویی',
    'mni'   => 'میته‌ای',
    'mno'   => "زبان\ مانوبو",
    'mo'    => 'مولداویایی',
    'moh'   => 'موهاکی',
    'mos'   => 'ماسیایی',
    'mr'    => 'مراتی',
    'ms'    => 'مالایی',
    'mt'    => 'مالتی',
    'mua'   => 'Mundang',
    'mul'   => "چندین\ زبان",
    'mun'   => "زبان\ موندایی",
    'mus'   => 'کریکی',
    'mwl'   => 'Mirandese',
    'mwr'   => 'مارواری',
    'my'    => 'برمه‌ای',
    'myn'   => "زبان\ مایایی",
    'myv'   => 'ارزیایی',
    'na'    => 'نائورویی',
    'nah'   => 'ناواتلی',
    'nai'   => "زبان\ سرخپوستی\ امریکای\ شمالی",
    'nap'   => 'ناپلی',
    'naq'   => 'Nama',
    'nb'    => "بوکسمال\ نروژی",
    'nd'    => "انده‌بله‌ای\ شمالی",
    'nds'   => "آلمانی\ سفلی",
    'ne'    => 'نپالی',
    'new'   => 'نواریایی',
    'ng'    => 'اندونگایی',
    'nia'   => 'نیاسی',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'نیویی',
    'nl'    => 'هلندی',
    'nl_be' => 'فلمنگی',
    'nmg'   => 'Kwasio',
    'nn'    => "نرس\ جدید\ نروژی",
    'no'    => 'نروژی',
    'nog'   => 'نغایی',
    'non'   => "نرس\ باستان",
    'nqo'   => "N\â\\Ko",
    'nr'    => "انده‌بله‌ای\ جنوبی",
    'nso'   => "سوتویی\ شمالی",
    'nub'   => "زبان\ نوبیایی",
    'nus'   => 'Nuer',
    'nv'    => 'ناواهویی',
    'nwc'   => "نواریایی\ کلاسیک",
    'ny'    => 'نیانجایی',
    'nym'   => 'نیام‌وزیایی',
    'nyn'   => 'نیانکوله‌ای',
    'nyo'   => 'نیورویی',
    'nzi'   => 'نزیمایی',
    'oc'    => 'اوکیتایی',
    'oj'    => 'اوجیبوایی',
    'om'    => 'اورومویی',
    'or'    => 'اوریه‌ای',
    'os'    => 'آسی',
    'osa'   => 'اوسیجی',
    'ota'   => "ترکی\ عثمانی",
    'oto'   => "زبان\ اتومیایی",
    'pa'    => 'پنجابی',
    'paa'   => "زبان\ پاپوایی",
    'pag'   => 'پانگاسینانی',
    'pal'   => 'پهلوی',
    'pam'   => 'پامپانگایی',
    'pap'   => 'پاپیامنتو',
    'pau'   => 'پالائویی',
    'peo'   => "فارسی\ باستان",
    'phi'   => "زبان\ فیلیپینی",
    'phn'   => 'فنیقی',
    'pi'    => 'پالی',
    'pl'    => 'لهستانی',
    'pon'   => 'پانپیی',
    'pra'   => "زبان\ پراکریتی",
    'pro'   => "پرووانسی\ باستان",
    'ps'    => 'پشتو',
    'pt'    => 'پرتغالی',
    'pt_br' => "پرتغالی\ برزیل",
    'pt_pt' => "پرتغالی\ پرتغال",
    'qu'    => 'کچوایی',
    'raj'   => 'راجستانی',
    'rap'   => 'راپانویی',
    'rar'   => 'راروتونگایی',
    'rm'    => 'رومانش',
    'rn'    => 'روندیایی',
    'ro'    => 'رومانیایی',
    'roa'   => "زبان\ رومیایی",
    'rof'   => 'Rombo',
    'rom'   => 'رومانویی',
    'ru'    => 'روسی',
    'rup'   => 'Aromanian',
    'rw'    => 'کینیارواندایی',
    'rwk'   => 'Rwa',
    'sa'    => 'سنسکریت',
    'sad'   => 'سانداوه‌ای',
    'sah'   => 'یاقوتی',
    'sai'   => "زبان\ سرخپوستی\ امریکای\ جنوبی",
    'sal'   => "زبان\ سالیشی",
    'sam'   => "آرامی\ سامری",
    'saq'   => 'Samburu',
    'sas'   => 'ساساکی',
    'sat'   => 'سانتالی',
    'sbp'   => 'Sangu',
    'sc'    => 'ساردینیایی',
    'scn'   => 'سیسیلی',
    'sco'   => 'اسکاتلندی',
    'sd'    => 'سندی',
    'se'    => "سامی\ شمالی",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'سلکوپی',
    'sem'   => "زبان\ سامی",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'سانگویی',
    'sga'   => "ایرلندی\ باستان",
    'sgn'   => "زبان\ اشاره",
    'sh'    => "صرب\ و\ کرواتی",
    'shi'   => 'Tachelhit',
    'shn'   => 'شانی',
    'si'    => 'سینهالی',
    'sid'   => 'سیدامویی',
    'sio'   => "زبان\ سویی",
    'sit'   => "زبان\ چین\ و\ تبتی",
    'sk'    => 'اسلواکی',
    'sl'    => 'اسلووینیایی',
    'sla'   => "زبان\ اسلاوی",
    'sm'    => 'ساموآیی',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'شونایی',
    'snk'   => 'سونینکه‌ای',
    'so'    => 'سومالیایی',
    'sog'   => 'سغدی',
    'son'   => 'سونغایی',
    'sq'    => 'آلبانیایی',
    'sr'    => 'صربی',
    'srn'   => 'تاکی‌تاکی',
    'srr'   => 'سریری',
    'ss'    => 'سوازیایی',
    'ssa'   => "زبان\ نیلی\ و\ صحرایی",
    'ssy'   => 'Saho',
    'st'    => "سوتویی\ جنوبی",
    'su'    => 'سوندایی',
    'suk'   => 'سوکومایی',
    'sus'   => 'سوسویی',
    'sux'   => 'سومری',
    'sv'    => 'سوئدی',
    'sw'    => 'سواحلی',
    'swb'   => 'کوموری',
    'swc'   => "Congo\ Swahili",
    'syc'   => "سریانی\ کلاسیک",
    'syr'   => 'سریانی',
    'ta'    => 'تامیلی',
    'tai'   => "زبان\ تایی",
    'te'    => 'تلوگویی',
    'tem'   => 'تمنه‌ای',
    'teo'   => 'Teso',
    'ter'   => 'ترنو',
    'tet'   => 'تتومی',
    'tg'    => 'تاجیکی',
    'th'    => 'تایلندی',
    'ti'    => 'تیگرینیایی',
    'tig'   => 'تیگره‌ای',
    'tiv'   => 'تیوی',
    'tk'    => 'ترکمنی',
    'tkl'   => 'Tokelau',
    'tl'    => 'تاگالوگی',
    'tlh'   => 'کلینگون',
    'tli'   => 'تلین‌گیتی',
    'tmh'   => 'تاماشقی',
    'tn'    => 'تسوانایی',
    'to'    => 'تونگایی',
    'tog'   => "تونگایی\ نیاسا",
    'tpi'   => 'توک‌پیسینی',
    'tr'    => 'ترکی',
    'trv'   => 'Taroko',
    'ts'    => 'تسونگایی',
    'tsi'   => 'تسیم‌شیانی',
    'tt'    => 'تاتاری',
    'tum'   => 'تومبوکایی',
    'tup'   => "زبان\ توپیایی",
    'tut'   => "زبان\ آلتاییک",
    'tvl'   => 'تووالویی',
    'tw'    => 'توی‌یایی',
    'twq'   => 'Tasawaq',
    'ty'    => 'تاهیتیایی',
    'tyv'   => 'تووایی',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'اودمورتی',
    'ug'    => 'اویغوری',
    'uga'   => 'اوگاریتی',
    'uk'    => 'اوکراینی',
    'umb'   => 'امبوندویی',
    'und'   => "زبان\ نامشخص",
    'ur'    => 'اردو',
    'uz'    => 'ازبکی',
    'vai'   => 'ویایی',
    've'    => 'وندایی',
    'vi'    => 'ویتنامی',
    'vo'    => 'ولاپوک',
    'vot'   => 'وتی',
    'vun'   => 'Vunjo',
    'wa'    => 'والونی',
    'wae'   => 'Walser',
    'wak'   => "زبان\ واکاشی",
    'wal'   => 'والامو',
    'war'   => 'وارایی',
    'was'   => 'واشویی',
    'wen'   => "زبان\ صُربی",
    'wo'    => 'ولوفی',
    'xal'   => 'قلموقی',
    'xh'    => 'خوسایی',
    'xog'   => 'Soga',
    'yao'   => 'یائویی',
    'yap'   => 'یاپی',
    'yav'   => 'Yangben',
    'yi'    => 'یدی',
    'yo'    => 'یوروبایی',
    'ypk'   => "زبان\ یوپیکی",
    'yue'   => 'کانتونیز',
    'za'    => 'چوانگی',
    'zap'   => 'زاپوتکی',
    'zbl'   => 'Blissymbols',
    'zen'   => 'زناگا',
    'zh'    => 'چینی',
    'znd'   => 'زانده‌ای',
    'zu'    => 'زولویی',
    'zun'   => 'زونیایی',
    'zxx'   => "بدون\ محتوای\ زبانی",
    'zza'   => 'زازایی',
);

%Locales::DB::Language::fa::name_to_code = (
    'aghem'                                                => 'agq',
    'aromanian'                                            => 'rup',
    'asturian'                                             => 'ast',
    'asu'                                                  => 'asa',
    'atsam'                                                => 'cch',
    'awadhi'                                               => 'awa',
    'bafia'                                                => 'ksf',
    'bamilekelanguage'                                     => 'bai',
    'bena'                                                 => 'bez',
    'blissymbols'                                          => 'zbl',
    'bodo'                                                 => 'brx',
    'cayuga'                                               => 'cay',
    'centralmoroccotamazight'                              => 'tzm',
    'chamiclanguage'                                       => 'cmc',
    'chiga'                                                => 'cgg',
    'chinookjargon'                                        => 'chn',
    'colognian'                                            => 'ksh',
    'congoswahili'                                         => 'swc',
    'embu'                                                 => 'ebu',
    'gusii'                                                => 'guz',
    'inarisami'                                            => 'smn',
    'jolafonyi'                                            => 'dyo',
    'kabuverdianu'                                         => 'kea',
    'kalenjin'                                             => 'kln',
    'karelian'                                             => 'krl',
    'kosraean'                                             => 'kos',
    'koyraborosenni'                                       => 'ses',
    'koyrachiini'                                          => 'khq',
    'kwasio'                                               => 'nmg',
    'langi'                                                => 'lag',
    'lulesami'                                             => 'smj',
    'luyia'                                                => 'luy',
    'machame'                                              => 'jmc',
    'makhuwameetto'                                        => 'mgh',
    'makonde'                                              => 'kde',
    'meru'                                                 => 'mer',
    'mirandese'                                            => 'mwl',
    'morisyen'                                             => 'mfe',
    'mundang'                                              => 'mua',
    'nama'                                                 => 'naq',
    'nigerkordofanianlanguage'                             => 'nic',
    'nuer'                                                 => 'nus',
    "n\â\\ko"                                         => 'nqo',
    'rombo'                                                => 'rof',
    'rwa'                                                  => 'rwk',
    'saho'                                                 => 'ssy',
    'samburu'                                              => 'saq',
    'samilanguage'                                         => 'smi',
    'sangu'                                                => 'sbp',
    'sena'                                                 => 'seh',
    'seneca'                                               => 'see',
    'shambala'                                             => 'ksb',
    'siksika'                                              => 'bla',
    'skoltsami'                                            => 'sms',
    'slave'                                                => 'den',
    'soga'                                                 => 'xog',
    'southernsami'                                         => 'sma',
    'tachelhit'                                            => 'shi',
    'taita'                                                => 'dav',
    'taroko'                                               => 'trv',
    'tasawaq'                                              => 'twq',
    'teso'                                                 => 'teo',
    'tokelau'                                              => 'tkl',
    'vunjo'                                                => 'vun',
    'walser'                                               => 'wae',
    'yangben'                                              => 'yav',
    'zarma'                                                => 'dje',
    'آبخازی'                                         => 'ab',
    'آدانگمه‌ای'                                => 'ada',
    'آدیجیایی'                                     => 'ady',
    'آذربایجانی'                                 => 'az',
    'آرامی'                                           => 'arc',
    'آرامیسامری'                                 => 'sam',
    'آراواکی'                                       => 'arw',
    'آراپاهویی'                                   => 'arp',
    'آراگونی'                                       => 'an',
    'آروکانیایی'                                 => 'arn',
    'آسامی'                                           => 'as',
    'آسی'                                               => 'os',
    'آفاری'                                           => 'aa',
    'آفریهیلی'                                     => 'afh',
    'آفریکانس'                                     => 'af',
    'آلئوتی'                                         => 'ale',
    'آلبانیایی'                                   => 'sq',
    'آلتاییجنوبی'                               => 'alt',
    'آلمانی'                                         => 'de',
    'آلمانیاتریش'                               => 'de_at',
    'آلمانیسفلی'                                 => 'nds',
    'آلمانیسوئیسی'                             => 'gsw',
    'آلمانیعلیایباستان'                   => 'goh',
    'آلمانیعلیایسوئیس'                     => 'de_ch',
    'آلمانیعلیایمیانه'                     => 'gmh',
    'آنگیکا'                                         => 'anp',
    'آواری'                                           => 'av',
    'آچئی'                                             => 'ace',
    'آچولیایی'                                     => 'ach',
    'آکان'                                             => 'ak',
    'آکدی'                                             => 'akk',
    'آیبن'                                             => 'iba',
    'آیمارایی'                                     => 'ay',
    'آینویی'                                         => 'ain',
    'اردو'                                             => 'ur',
    'ارزیایی'                                       => 'myv',
    'ارمنی'                                           => 'hy',
    'ازبکی'                                           => 'uz',
    'استونیایی'                                   => 'et',
    'اسلاویکلیسایی'                           => 'cu',
    'اسلواکی'                                       => 'sk',
    'اسلووینیایی'                               => 'sl',
    'اسپانیایی'                                   => 'es',
    'اسپانیاییاسپانیا'                     => 'es_es',
    'اسپرانتو'                                     => 'eo',
    'اسکاتلندی'                                   => 'sco',
    'افیکی'                                           => 'efi',
    'امبوندویی'                                   => 'umb',
    'امهری'                                           => 'am',
    'انده‌بله‌ایجنوبی'                   => 'nr',
    'انده‌بله‌ایشمالی'                   => 'nd',
    'اندونزیایی'                                 => 'id',
    'اندونگایی'                                   => 'ng',
    'انگلیسی'                                       => 'en',
    'انگلیسیاسترالیا'                       => 'en_au',
    'انگلیسیامریکا'                           => 'en_us',
    'انگلیسیباستان'                           => 'ang',
    'انگلیسیبریتانیا'                       => 'en_gb',
    'انگلیسیمیانه'                             => 'enm',
    'انگلیسیکانادا'                           => 'en_ca',
    'اواندو'                                         => 'ewo',
    'اوجیبوایی'                                   => 'oj',
    'اودمورتی'                                     => 'udm',
    'اورومویی'                                     => 'om',
    'اوریه‌ای'                                    => 'or',
    'اوستایی'                                       => 'ae',
    'اوسیجی'                                         => 'osa',
    'اوه‌ای'                                        => 'ee',
    'اوکراینی'                                     => 'uk',
    'اوکیتایی'                                     => 'oc',
    'اوگاریتی'                                     => 'uga',
    'اویغوری'                                       => 'ug',
    'اکاجوک'                                         => 'eka',
    'اکسیدنتال'                                   => 'ie',
    'ایتالیایی'                                   => 'it',
    'ایجویی'                                         => 'ijo',
    'ایدو'                                             => 'io',
    'ایرلندی'                                       => 'ga',
    'ایرلندیباستان'                           => 'sga',
    'ایرلندیمیانه'                             => 'mga',
    'ایسلندی'                                       => 'is',
    'ایلوکویی'                                     => 'ilo',
    'اینوپیک'                                       => 'ik',
    'اینوکتیتوت'                                 => 'iu',
    'اینگوشی'                                       => 'inh',
    'ایگبویی'                                       => 'ig',
    'باتاکی'                                         => 'btk',
    'باسایی'                                         => 'bas',
    'باسکی'                                           => 'eu',
    'باشغیری'                                       => 'ba',
    'بالیایی'                                       => 'ban',
    'بامبارایی'                                   => 'bm',
    'بانتویی'                                       => 'bnt',
    'باندایی'                                       => 'bad',
    'بجایی'                                           => 'bej',
    'بدونمحتوایزبانی'                       => 'zxx',
    'براج'                                             => 'bra',
    'بربری'                                           => 'ber',
    'برتانیایی'                                   => 'br',
    'برمه‌ای'                                      => 'my',
    'بلغاری'                                         => 'bg',
    'بلوروسی'                                       => 'be',
    'بلوچی'                                           => 'bal',
    'بلین'                                             => 'byn',
    'بمبایی'                                         => 'bem',
    'بنگالی'                                         => 'bn',
    'بوجپوری'                                       => 'bho',
    'بوریاتی'                                       => 'bua',
    'بوسنیایی'                                     => 'bs',
    'بوکسمالنروژی'                             => 'nb',
    'بوگیایی'                                       => 'bug',
    'بیسلاما'                                       => 'bi',
    'بینی'                                             => 'bin',
    'بیهاری'                                         => 'bh',
    'بیکولی'                                         => 'bik',
    'تاتاری'                                         => 'tt',
    'تاجیکی'                                         => 'tg',
    'تاماشقی'                                       => 'tmh',
    'تامیلی'                                         => 'ta',
    'تاهیتیایی'                                   => 'ty',
    'تاکی‌تاکی'                                  => 'srn',
    'تاگالوگی'                                     => 'tl',
    'تایلندی'                                       => 'th',
    'تایپهای'                                       => 'kcg',
    'تبتی'                                             => 'bo',
    'تتومی'                                           => 'tet',
    'ترنو'                                             => 'ter',
    'ترکمنی'                                         => 'tk',
    'ترکی'                                             => 'tr',
    'ترکیعثمانی'                                 => 'ota',
    'ترکیکریمه'                                   => 'crh',
    'تسوانایی'                                     => 'tn',
    'تسونگایی'                                     => 'ts',
    'تسیم‌شیانی'                                => 'tsi',
    'تلوگویی'                                       => 'te',
    'تلین‌گیتی'                                  => 'tli',
    'تمنه‌ای'                                      => 'tem',
    'تومبوکایی'                                   => 'tum',
    'تونگایی'                                       => 'to',
    'تونگایینیاسا'                             => 'tog',
    'تووالویی'                                     => 'tvl',
    'تووایی'                                         => 'tyv',
    'توک‌پیسینی'                                => 'tpi',
    'توی‌یایی'                                    => 'tw',
    'تیوی'                                             => 'tiv',
    'تیگره‌ای'                                    => 'tig',
    'تیگرینیایی'                                 => 'ti',
    'جاوه‌ای'                                      => 'jv',
    'جغتایی'                                         => 'chg',
    'جو'                                                 => 'kaj',
    'جونخایی'                                       => 'dz',
    'خاسیایی'                                       => 'kha',
    'ختنی'                                             => 'kho',
    'خمری'                                             => 'km',
    'خوسایی'                                         => 'xh',
    'دارقینی'                                       => 'dar',
    'دانمارکی'                                     => 'da',
    'داکوتایی'                                     => 'dak',
    'دایاک'                                           => 'day',
    'دایولایی'                                     => 'dyu',
    'دلاواری'                                       => 'del',
    'دوآلایی'                                       => 'dua',
    'دوگری'                                           => 'doi',
    'دوگریب'                                         => 'dgr',
    'دینکایی'                                       => 'din',
    'راجستانی'                                     => 'raj',
    'راروتونگایی'                               => 'rar',
    'راپانویی'                                     => 'rap',
    'روسی'                                             => 'ru',
    'رومانش'                                         => 'rm',
    'رومانویی'                                     => 'rom',
    'رومانیایی'                                   => 'ro',
    'روندیایی'                                     => 'rn',
    'زازایی'                                         => 'zza',
    'زانده‌ای'                                    => 'znd',
    'زاپوتکی'                                       => 'zap',
    'زبانآتاپاسکایی'                         => 'ath',
    'زبانآسترونیزیایی'                     => 'map',
    'زبانآلتاییک'                               => 'tut',
    'زبانآلگونکینی'                           => 'alg',
    'زبانآپاچیایی'                             => 'apa',
    'زباناتومیایی'                             => 'oto',
    'زباناسترالیایی'                         => 'aus',
    'زباناسلاوی'                                 => 'sla',
    'زباناشاره'                                   => 'sgn',
    'زبانافریقاوآسیایی'                   => 'afa',
    'زبانایرانی'                                 => 'ira',
    'زبانایروکوایی'                           => 'iro',
    'زبانبالتیکی'                               => 'bat',
    'زبانتایی'                                     => 'tai',
    'زبانتوپیایی'                               => 'tup',
    'زبانخواسی'                                   => 'khi',
    'زباندراویدی'                               => 'dra',
    'زبانرومیایی'                               => 'roa',
    'زبانساختگی'                                 => 'art',
    'زبانسالیشی'                                 => 'sal',
    'زبانسامی'                                     => 'sem',
    'زبانسرخپوستیامریکایجنوبی'     => 'sai',
    'زبانسرخپوستیامریکایشمالی'     => 'nai',
    'زبانسرخپوستیامریکایمرکزی'     => 'cai',
    'زبانسلتی'                                     => 'cel',
    'زبانسویی'                                     => 'sio',
    'زبانصُربی'                                   => 'wen',
    'زبانفیلیپینی'                             => 'phi',
    'زبانفینواوگرایی'                       => 'fiu',
    'زبانقفقازی'                                 => 'cau',
    'زبانمانوبو'                                 => 'mno',
    'زبانمایایی'                                 => 'myn',
    'زبانمتفرقه'                                 => 'mis',
    'زبانموندایی'                               => 'mun',
    'زبانمون‌خمری'                            => 'mkh',
    'زباننامشخص'                                 => 'und',
    'زباننوبیایی'                               => 'nub',
    'زباننیلیوصحرایی'                       => 'ssa',
    'زبانهندواروپایی'                       => 'ine',
    'زبانهندیک'                                   => 'inc',
    'زبانواکاشی'                                 => 'wak',
    'زبانپاپوایی'                               => 'paa',
    'زبانپراکریتی'                             => 'pra',
    'زبانچینوتبتی'                             => 'sit',
    'زبانژرمنی'                                   => 'gem',
    'زبانکوشی'                                     => 'cus',
    'زبانیوپیکی'                                 => 'ypk',
    'زناگا'                                           => 'zen',
    'زولویی'                                         => 'zu',
    'زونیایی'                                       => 'zun',
    'ساردینیایی'                                 => 'sc',
    'ساساکی'                                         => 'sas',
    'ساموآیی'                                       => 'sm',
    'سامیشمالی'                                   => 'se',
    'سانتالی'                                       => 'sat',
    'سانداوه‌ای'                                => 'sad',
    'سانگویی'                                       => 'sg',
    'سبویی'                                           => 'ceb',
    'سریانی'                                         => 'syr',
    'سریانیکلاسیک'                             => 'syc',
    'سریری'                                           => 'srr',
    'سغدی'                                             => 'sog',
    'سلکوپی'                                         => 'sel',
    'سندی'                                             => 'sd',
    'سنسکریت'                                       => 'sa',
    'سوئدی'                                           => 'sv',
    'سواحلی'                                         => 'sw',
    'سوازیایی'                                     => 'ss',
    'سوتوییجنوبی'                               => 'st',
    'سوتوییشمالی'                               => 'nso',
    'سوسویی'                                         => 'sus',
    'سومالیایی'                                   => 'so',
    'سومری'                                           => 'sux',
    'سوندایی'                                       => 'su',
    'سونغایی'                                       => 'son',
    'سونینکه‌ای'                                => 'snk',
    'سوکومایی'                                     => 'suk',
    'سیدامویی'                                     => 'sid',
    'سیسیلی'                                         => 'scn',
    'سینهالی'                                       => 'si',
    'شانی'                                             => 'shn',
    'شایانی'                                         => 'chy',
    'شونایی'                                         => 'sn',
    'صربوکرواتی'                                 => 'sh',
    'صربی'                                             => 'sr',
    'صُربیسفلی'                                   => 'dsb',
    'صُربیعلیا'                                   => 'hsb',
    'عبری'                                             => 'he',
    'عربی'                                             => 'ar',
    'عربییهودی'                                   => 'jrb',
    'عیلامی'                                         => 'elx',
    'فارسی'                                           => 'fa',
    'فارسیباستان'                               => 'peo',
    'فارسییهودی'                                 => 'jpr',
    'فارویی'                                         => 'fo',
    'فانتیایی'                                     => 'fat',
    'فانکی'                                           => 'fan',
    'فرانسوی'                                       => 'fr',
    'فرانسویباستان'                           => 'fro',
    'فرانسویسوئیس'                             => 'fr_ch',
    'فرانسویمیانه'                             => 'frm',
    'فرانسویکانادا'                           => 'fr_ca',
    'فریزیشرقی'                                   => 'frs',
    'فریزیشمالی'                                 => 'frr',
    'فریزیغربی'                                   => 'fy',
    'فریولیایی'                                   => 'fur',
    'فلمنگی'                                         => 'nl_be',
    'فنلاندی'                                       => 'fi',
    'فنیقی'                                           => 'phn',
    'فولایی'                                         => 'ff',
    'فونی'                                             => 'fon',
    'فیجیایی'                                       => 'fj',
    'فیلیپینی'                                     => 'fil',
    'قبایلی'                                         => 'kab',
    'قبطی'                                             => 'cop',
    'قرقیزی'                                         => 'ky',
    'قره‌قالپاقی'                              => 'kaa',
    'قره‌چایی‐بالکاری'                   => 'krc',
    'قزاقی'                                           => 'kk',
    'قلموقی'                                         => 'xal',
    'لائوسی'                                         => 'lo',
    'لاتینی'                                         => 'la',
    'لادینو'                                         => 'lad',
    'لامبا'                                           => 'lam',
    'لاهندا'                                         => 'lah',
    'لتونیایی'                                     => 'lv',
    'لزگی'                                             => 'lez',
    'لهستانی'                                       => 'pl',
    'لوئویی'                                         => 'luo',
    'لوبایی‐لولوا'                            => 'lua',
    'لوبایی‐کاتانگا'                        => 'lu',
    'لوجبان'                                         => 'jbo',
    'لوزیایی'                                       => 'loz',
    'لوشه‌ای'                                      => 'lus',
    'لوندایی'                                       => 'lun',
    'لوگزامبورگی'                               => 'lb',
    'لویسنو'                                         => 'lui',
    'لیتوانیایی'                                 => 'lt',
    'لیمبورگی'                                     => 'li',
    'لینگالا'                                       => 'ln',
    'مائوریایی'                                   => 'mi',
    'مادورایی'                                     => 'mad',
    'مارشالی'                                       => 'mh',
    'مارواری'                                       => 'mwr',
    'ماریایی'                                       => 'chm',
    'ماسایی'                                         => 'mas',
    'ماسیایی'                                       => 'mos',
    'مالاگاسیایی'                               => 'mg',
    'مالایالامی'                                 => 'ml',
    'مالایی'                                         => 'ms',
    'مالتی'                                           => 'mt',
    'مالدیوی'                                       => 'dv',
    'ماندار'                                         => 'mdr',
    'ماندینگویی'                                 => 'man',
    'مانچویی'                                       => 'mnc',
    'مانی'                                             => 'gv',
    'ماکاسار'                                       => 'mak',
    'ماگاهیایی'                                   => 'mag',
    'مایدیلی'                                       => 'mai',
    'مجاری'                                           => 'hu',
    'مراتی'                                           => 'mr',
    'مصریکهن'                                       => 'egy',
    'مغولی'                                           => 'mn',
    'مقدونی'                                         => 'mk',
    'منده‌ای'                                      => 'men',
    'موتوییهیری'                                 => 'ho',
    'مولداویایی'                                 => 'mo',
    'مونگویی'                                       => 'lol',
    'موهاکی'                                         => 'moh',
    'مکشایی'                                         => 'mdf',
    'میان‌زبان'                                  => 'ia',
    'میته‌ای'                                      => 'mni',
    'مینانگ‌کابویی'                          => 'min',
    'میکماکی'                                       => 'mic',
    'نائورویی'                                     => 'na',
    'ناواتلی'                                       => 'nah',
    'ناواهویی'                                     => 'nv',
    'ناپلی'                                           => 'nap',
    'نرسباستان'                                   => 'non',
    'نرسجدیدنروژی'                             => 'nn',
    'نروژی'                                           => 'no',
    'نزیمایی'                                       => 'nzi',
    'نغایی'                                           => 'nog',
    'نواریایی'                                     => 'new',
    'نواریاییکلاسیک'                         => 'nwc',
    'نپالی'                                           => 'ne',
    'نیاسی'                                           => 'nia',
    'نیام‌وزیایی'                              => 'nym',
    'نیانجایی'                                     => 'ny',
    'نیانکوله‌ای'                              => 'nyn',
    'نیورویی'                                       => 'nyo',
    'نیویی'                                           => 'niu',
    'هائیتیایی'                                   => 'ht',
    'هاوائیایی'                                   => 'haw',
    'هایدایی'                                       => 'hai',
    'هریرویی'                                       => 'hz',
    'هلندی'                                           => 'nl',
    'هلندیمیانه'                                 => 'dum',
    'همونگ'                                           => 'hmn',
    'هندی'                                             => 'hi',
    'هوسیایی'                                       => 'ha',
    'هوپا'                                             => 'hup',
    'هیتی'                                             => 'hit',
    'هیلی‌گاینونی'                            => 'hil',
    'هیماچالی'                                     => 'him',
    'وارایی'                                         => 'war',
    'واشویی'                                         => 'was',
    'والامو'                                         => 'wal',
    'والونی'                                         => 'wa',
    'وتی'                                               => 'vot',
    'ولاپوک'                                         => 'vo',
    'ولوفی'                                           => 'wo',
    'وندایی'                                         => 've',
    'ویایی'                                           => 'vai',
    'ویتنامی'                                       => 'vi',
    'ویلزی'                                           => 'cy',
    'پالائویی'                                     => 'pau',
    'پالی'                                             => 'pi',
    'پامپانگایی'                                 => 'pam',
    'پانپیی'                                         => 'pon',
    'پانگاسینانی'                               => 'pag',
    'پاپیامنتو'                                   => 'pap',
    'پرتغالی'                                       => 'pt',
    'پرتغالیبرزیل'                             => 'pt_br',
    'پرتغالیپرتغال'                           => 'pt_pt',
    'پرووانسیباستان'                         => 'pro',
    'پشتو'                                             => 'ps',
    'پنجابی'                                         => 'pa',
    'پهلوی'                                           => 'pal',
    'چامورویی'                                     => 'ch',
    'چروکیایی'                                     => 'chr',
    'چندینزبان'                                   => 'mul',
    'چوانگی'                                         => 'za',
    'چوواشی'                                         => 'cv',
    'چوکتویی'                                       => 'cho',
    'چوکی'                                             => 'chk',
    'چچنی'                                             => 'ce',
    'چکی'                                               => 'cs',
    'چیبچا'                                           => 'chb',
    'چینی'                                             => 'zh',
    'چیپه‌ویه‌ای'                             => 'chp',
    'ژاپنی'                                           => 'ja',
    'کاباردینی'                                   => 'kbd',
    'کاتالان'                                       => 'ca',
    'کادویی'                                         => 'cad',
    'کارنی'                                           => 'kar',
    'کاریبی'                                         => 'car',
    'کاشوبی'                                         => 'csb',
    'کامبایی'                                       => 'kam',
    'کاناده‌ای'                                  => 'kn',
    'کانتونیز'                                     => 'yue',
    'کانوریایی'                                   => 'kr',
    'کاویایی'                                       => 'kaw',
    'کاچینی'                                         => 'kac',
    'کردی'                                             => 'ku',
    'کرنوالی'                                       => 'kw',
    'کره‌ای'                                        => 'ko',
    'کروات'                                           => 'hr',
    'کرویی'                                           => 'kro',
    'کریایی'                                         => 'cr',
    'کریولیاپیجین'                             => 'crp',
    'کریولیاپیجینمبتنیبرانگلیسی' => 'cpe',
    'کریولیاپیجینمبتنیبرفرانسوی' => 'cpf',
    'کریولیاپیجینمبتنیبرپرتغالی' => 'cpp',
    'کریکی'                                           => 'mus',
    'کشمیری'                                         => 'ks',
    'کلینگون'                                       => 'tlh',
    'کنکانی'                                         => 'kok',
    'کنگویی'                                         => 'kg',
    'کوانیاما'                                     => 'kj',
    'کوتنی'                                           => 'kut',
    'کورسی'                                           => 'co',
    'کورو'                                             => 'kfo',
    'کوروخی'                                         => 'kru',
    'کوموری'                                         => 'swb',
    'کومیایی'                                       => 'kv',
    'کومیکی'                                         => 'kum',
    'کپله‌ای'                                      => 'kpe',
    'کچوایی'                                         => 'qu',
    'کیمبوندویی'                                 => 'kmb',
    'کینیارواندایی'                           => 'rw',
    'کیکویویی'                                     => 'ki',
    'گالیسیایی'                                   => 'gl',
    'گاندایی'                                       => 'lg',
    'گایویی'                                         => 'gay',
    'گایی'                                             => 'gaa',
    'گبایایی'                                       => 'gba',
    'گجراتی'                                         => 'gu',
    'گرجی'                                             => 'ka',
    'گریبویی'                                       => 'grb',
    'گرینلندی'                                     => 'kl',
    'گوارانی'                                       => 'gn',
    'گوتی'                                             => 'got',
    'گورونتالو'                                   => 'gor',
    'گوندی'                                           => 'gon',
    'گویچاین'                                       => 'gwi',
    'گیلبرتی'                                       => 'gil',
    'گیلیاسکاتلندی'                           => 'gd',
    'گی‌ئزی'                                        => 'gez',
    'یائویی'                                         => 'yao',
    'یاقوتی'                                         => 'sah',
    'یاپی'                                             => 'yap',
    'یدی'                                               => 'yi',
    'یوروبایی'                                     => 'yo',
    'یونانی'                                         => 'el',
    'یونانیکهن'                                   => 'grc',
    'ییسیچوان'                                     => 'ii',
);

1;
