package Locales::DB::Language::yo;

# Auto generated from CLDR

$Locales::DB::Language::yo::VERSION = '0.01';

$Locales::DB::Language::yo::cldr_version = '1.7.1';

%Locales::DB::Language::yo::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::yo::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => "Ede\ Afrikani",
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Ede\ Amharic",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "Ede\ Arabia",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "Ti\ Assam",
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => "Ede\ Azerbaijani",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => "Ede\ Belarusi",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => "Ede\ Bulgaria",
    'bh'    => "Ede\ Bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Ede\ Bengali",
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'Bretoni',
    'bra'   => 'Braj',
    'bs'    => "Ede\ Bosnia",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Ede\ Catala",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Orile\-ede\ Tseki",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "Ede\ Welshi",
    'da'    => "Èdè\ Ilẹ̀\ Denmark",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => "Èdè\ Ilẹ̀\ Germany",
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'giriki',
    'elx'   => 'Elamite',
    'en'    => "Èdè\ Gẹ̀ẹ́sì",
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => "Ede\ Esperanto",
    'es'    => 'Panyan',
    'es_es' => "Iberian\ Spanish",
    'et'    => "Ede\ Estonia",
    'eu'    => "Ede\ Baski",
    'ewo'   => 'Ewondo',
    'fa'    => "Ede\ Persia",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Finisi',
    'fil'   => "Ede\ Tagalogi",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "Ede\ Faroesi",
    'fon'   => 'Fon',
    'fr'    => "Èdè\ Faransé",
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Ede\ Frisia",
    'ga'    => "Ede\ Ireland",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Ede\ Gaelik\ ti\ Ilu\ Scotland",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Ede\ Galicia",
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "Ede\ Gujarati",
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'Heberu',
    'hi'    => "Ede\ Hindi",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Ede\ Kroatia",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "Ede\ Hungaria",
    'hup'   => 'Hupa',
    'hy'    => "Ile\ Armenia",
    'hz'    => 'Herero',
    'ia'    => "Ede\ pipo",
    'iba'   => 'Iban',
    'id'    => "Ede\ Indonesia",
    'ie'    => "Iru\ Ede",
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "Ede\ Icelandic",
    'it'    => 'Italiani',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japanisi',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Ede\ Javana",
    'ka'    => "Ede\ Georgia",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'Cambodian',
    'kmb'   => 'Kimbundu',
    'kn'    => "Ede\ Kannada",
    'ko'    => 'Korean',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kyrgyz',
    'la'    => "Ede\ Latini",
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Ta',
    'lo'    => "ara\ Laos",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Ede\ Lithuania",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => "Ede\ Latvianu",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Ede\ Macedonia",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => "Ede\ Malayalami",
    'mn'    => "ara\ Mangoli",
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Ede\ marathi",
    'ms'    => "Ede\ Malaya",
    'mt'    => "Ede\ Malta",
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Ede\ Nepali",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => "Ede\ Dutch",
    'nl_be' => 'Flemish',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => "Ede\ Norway",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Ede\ Occitani",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Ede\ Punjabi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Èdè\ Ilẹ̀\ Polandi",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pashto',
    'pt'    => "Ede\ Portugi",
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Ede\ Portugal",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => "Ede\ Romania",
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => "Ede\ Roosia",
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => "ede\ awon\ ara\ Indo",
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Serbo\-Croatiani",
    'shn'   => 'Shan',
    'si'    => "Ede\ Sinhalese",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Ede\ Slovaki",
    'sl'    => "Ede\ Slovenia",
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => "ara\ Somalia",
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Ede\ Albania",
    'sr'    => "Ede\ Serbia",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'Sesoto',
    'su'    => "Ede\ Sudani",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'suwidiisi',
    'sw'    => "Ede\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Ede\ Tamili",
    'tai'   => "Tai\ Language",
    'te'    => "Ede\ Telugu",
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => "Ede\ Thai",
    'ti'    => "Ede\ Tigrinya",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => "Ede\ Klingoni",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => "Ede\ Turkey",
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uighur',
    'uga'   => 'Ugaritic',
    'uk'    => "Ede\ Ukrani",
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => "Ede\ Urdu",
    'uz'    => "Ede\ Uzbek",
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "Ede\ Vietnamu",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => "Ede\ Xhosa",
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Yiddishi',
    'yo'    => 'Yorùbá',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => "Ede\ Zulu",
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::yo::name_to_code = (
    'abkhazian'                           => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    "ara\ laos"                           => 'lo',
    "ara\ mangoli"                        => 'mn',
    "ara\ somalia"                        => 'so',
    'aragonese'                           => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'bashkir'                             => 'ba',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'braj'                                => 'bra',
    "brazilian\ portuguese"               => 'pt_br',
    'bretoni'                             => 'br',
    "british\ english"                    => 'en_gb',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'burmese'                             => 'my',
    'caddo'                               => 'cad',
    'cambodian'                           => 'km',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    'chinese'                             => 'zh',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'corsican'                            => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    "d\ farans"                           => 'fr',
    "d\ gs"                               => 'en',
    "d\ il\ denmark"                      => 'da',
    "d\ il\ germany"                      => 'de',
    "d\ il\ polandi"                      => 'pl',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    "eastern\ frisian"                    => 'frs',
    "ede\ afrikani"                       => 'af',
    "ede\ albania"                        => 'sq',
    "ede\ amharic"                        => 'am',
    "ede\ arabia"                         => 'ar',
    "ede\ awon\ ara\ indo"                => 'sa',
    "ede\ azerbaijani"                    => 'az',
    "ede\ baski"                          => 'eu',
    "ede\ belarusi"                       => 'be',
    "ede\ bengali"                        => 'bn',
    "ede\ bihari"                         => 'bh',
    "ede\ bosnia"                         => 'bs',
    "ede\ bulgaria"                       => 'bg',
    "ede\ catala"                         => 'ca',
    "ede\ dutch"                          => 'nl',
    "ede\ esperanto"                      => 'eo',
    "ede\ estonia"                        => 'et',
    "ede\ faroesi"                        => 'fo',
    "ede\ frisia"                         => 'fy',
    "ede\ gaelik\ ti\ ilu\ scotland"      => 'gd',
    "ede\ galicia"                        => 'gl',
    "ede\ georgia"                        => 'ka',
    "ede\ gujarati"                       => 'gu',
    "ede\ hindi"                          => 'hi',
    "ede\ hungaria"                       => 'hu',
    "ede\ icelandic"                      => 'is',
    "ede\ indonesia"                      => 'id',
    "ede\ ireland"                        => 'ga',
    "ede\ javana"                         => 'jv',
    "ede\ kannada"                        => 'kn',
    "ede\ klingoni"                       => 'tlh',
    "ede\ kroatia"                        => 'hr',
    "ede\ latini"                         => 'la',
    "ede\ latvianu"                       => 'lv',
    "ede\ lithuania"                      => 'lt',
    "ede\ macedonia"                      => 'mk',
    "ede\ malaya"                         => 'ms',
    "ede\ malayalami"                     => 'ml',
    "ede\ malta"                          => 'mt',
    "ede\ marathi"                        => 'mr',
    "ede\ nepali"                         => 'ne',
    "ede\ norway"                         => 'no',
    "ede\ occitani"                       => 'oc',
    "ede\ persia"                         => 'fa',
    "ede\ pipo"                           => 'ia',
    "ede\ portugal"                       => 'pt_pt',
    "ede\ portugi"                        => 'pt',
    "ede\ punjabi"                        => 'pa',
    "ede\ romania"                        => 'ro',
    "ede\ roosia"                         => 'ru',
    "ede\ serbia"                         => 'sr',
    "ede\ sinhalese"                      => 'si',
    "ede\ slovaki"                        => 'sk',
    "ede\ slovenia"                       => 'sl',
    "ede\ sudani"                         => 'su',
    "ede\ swahili"                        => 'sw',
    "ede\ tagalogi"                       => 'fil',
    "ede\ tamili"                         => 'ta',
    "ede\ telugu"                         => 'te',
    "ede\ thai"                           => 'th',
    "ede\ tigrinya"                       => 'ti',
    "ede\ turkey"                         => 'tr',
    "ede\ ukrani"                         => 'uk',
    "ede\ urdu"                           => 'ur',
    "ede\ uzbek"                          => 'uz',
    "ede\ vietnamu"                       => 'vi',
    "ede\ welshi"                         => 'cy',
    "ede\ xhosa"                          => 'xh',
    "ede\ zulu"                           => 'zu',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'fijian'                              => 'fj',
    'finisi'                              => 'fi',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'giriki'                              => 'el',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'guarani'                             => 'gn',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'hawaiian'                            => 'haw',
    'heberu'                              => 'he',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    "ile\ armenia"                        => 'hy',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'ingush'                              => 'inh',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    "iranian\ language"                   => 'ira',
    "iroquoian\ language"                 => 'iro',
    "iru\ ede"                            => 'ie',
    'italiani'                            => 'it',
    'japanisi'                            => 'ja',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashmiri'                            => 'ks',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'kazakh'                              => 'kk',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'korean'                              => 'ko',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurdish'                             => 'ku',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'kyrgyz'                              => 'ky',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'malagasy'                            => 'mg',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavian'                           => 'mo',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    "norwegian\ bokml"                    => 'nb',
    "norwegian\ nynorsk"                  => 'nn',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    "orileede\ tseki"                     => 'cs',
    'oriya'                               => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'panyan'                              => 'es',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'pashto'                              => 'ps',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    'rundi'                               => 'rn',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samoan'                              => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serbocroatiani'                      => 'sh',
    'serer'                               => 'srr',
    'sesoto'                              => 'st',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'sogdien'                             => 'sog',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'susu'                                => 'sus',
    'suwidiisi'                           => 'sv',
    'swati'                               => 'ss',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'ta'                                  => 'ln',
    'tagalog'                             => 'tl',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tajik'                               => 'tg',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tatar'                               => 'tt',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    "ti\ assam"                           => 'as',
    'tibetan'                             => 'bo',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tonga'                               => 'to',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'turkmen'                             => 'tk',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'uighur'                              => 'ug',
    'umbundu'                             => 'umb',
    "unknown\ or\ invalid\ language"      => 'und',
    "upper\ sorbian"                      => 'hsb',
    "us\ english"                         => 'en_us',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    'yiddishi'                            => 'yi',
    'yorb'                                => 'yo',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zuni'                                => 'zun',
);

1;
