package Locales::DB::Language::tr;

# Auto generated from CLDR

$Locales::DB::Language::tr::VERSION = '0.01';

$Locales::DB::Language::tr::cldr_version = '1.7.1';

%Locales::DB::Language::tr::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Dil\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\% \#\,\#\#0",
        'territory' => "Bölge\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "hayır\:hayir\:h",
        'yesstr' => "evet\:e"
    },
);

%Locales::DB::Language::tr::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abhazca',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Çerkezce',
    'ae'    => 'Avestçe',
    'af'    => "Afrikaan\ Dili",
    'afa'   => "Afro\-Asyatik\ Diller",
    'afh'   => 'Afrihili',
    'ain'   => "Ayni\ Dili",
    'ak'    => 'Akan',
    'akk'   => "Akad\ Dili",
    'ale'   => 'Aleut',
    'alg'   => "Algonkin\ Dili",
    'alt'   => "Güney\ Altayca",
    'am'    => 'Amharca',
    'an'    => 'Aragonca',
    'ang'   => "Eski\ İngilizce",
    'anp'   => 'Angika',
    'apa'   => "Apaçi\ Dilleri",
    'ar'    => 'Arapça',
    'arc'   => 'Aramice',
    'arn'   => "Araukanya\ Dili",
    'arp'   => "Arapaho\ Dili",
    'art'   => "Yapay\ Diller",
    'arw'   => "Arawak\ Dili",
    'as'    => 'Assamca',
    'ast'   => 'Asturyasca',
    'ath'   => "Atabaşkan\ Dilleri",
    'aus'   => "Avustralya\ Dilleri",
    'av'    => "Avar\ Dili",
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Azerice',
    'ba'    => 'Başkırtça',
    'bad'   => "Banda\ Dili",
    'bai'   => "Bamileke\ Dilleri",
    'bal'   => 'Baluchi',
    'ban'   => "Bali\ Dili",
    'bas'   => "Basa\ Dili",
    'bat'   => "Baltık\ Dilleri",
    'be'    => "Beyaz\ Rusça",
    'bej'   => "Beja\ Dili",
    'bem'   => 'Bemba',
    'ber'   => 'Berberi',
    'bg'    => 'Bulgarca',
    'bh'    => 'Bihari',
    'bho'   => 'Arayanice',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengalce',
    'bnt'   => "Bantu\ Dili",
    'bo'    => 'Tibetçe',
    'br'    => 'Bretonca',
    'bra'   => 'Braj',
    'bs'    => 'Boşnakça',
    'btk'   => 'Batak',
    'bua'   => 'Buryat',
    'bug'   => 'Bugis',
    'byn'   => 'Blin',
    'ca'    => 'Katalanca',
    'cad'   => 'Caddo',
    'cai'   => "Orta\ Amerika\ Yerli\ Dilleri",
    'car'   => 'Carib',
    'cau'   => "Kafkas\ Dilleri",
    'cch'   => 'Atsam',
    'ce'    => 'Çeçence',
    'ceb'   => 'Cebuano',
    'cel'   => "Kelt\ Dilleri",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => "Çağatay\ Dili",
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Çeroki',
    'chy'   => "Şayen\ Dili",
    'cmc'   => "Chamic\ Dilleri",
    'co'    => 'Korsikaca',
    'cop'   => 'Kiptice',
    'cpe'   => "İngilizce\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cpf'   => "Fransızca\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cpp'   => "Portekizce\ tabanlı\ Creole\ ve\ Pidgin\ Dilleri",
    'cr'    => 'Cree',
    'crh'   => "Kırım\ Türkçesi",
    'crp'   => "Creole\ ve\ Pidgin\ Dilleri",
    'cs'    => 'Çekçe',
    'csb'   => 'Kashubian',
    'cu'    => "Kilise\ Slavcası",
    'cus'   => "Kuşitik\ Diller",
    'cv'    => 'Çuvaşça',
    'cy'    => 'Galce',
    'da'    => 'Danca',
    'dak'   => 'Dakota',
    'dar'   => 'Dargince',
    'day'   => 'Dayak',
    'de'    => 'Almanca',
    'de_at' => "Avusturya\ Almancası",
    'de_ch' => "İsviçre\ Yüksek\ Almancası",
    'del'   => 'Delaware',
    'den'   => 'Slavey',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravid\ Dilleri",
    'dsb'   => "Aşağı\ Sorbça",
    'dua'   => 'Duala',
    'dum'   => "Ortaçağ\ Felemenkçesi",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => "Butan\ Dili",
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Eski\ Mısır\ Dili",
    'eka'   => 'Ekajuk',
    'el'    => 'Yunanca',
    'elx'   => 'Elam',
    'en'    => 'İngilizce',
    'en_au' => "Avustralya\ İngilizcesi",
    'en_ca' => "Kanada\ İngilizcesi",
    'en_gb' => "İngiliz\ İngilizcesi",
    'en_us' => "Amerikan\ İngilizcesi",
    'enm'   => "Ortaçağ\ İngilizcesi",
    'eo'    => 'Esperanto',
    'es'    => 'İspanyolca',
    'es_es' => "İber\ İspanyolcası",
    'et'    => "Estonya\ Dili",
    'eu'    => 'Baskça',
    'ewo'   => 'Ewondo',
    'fa'    => 'Farsça',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fince',
    'fil'   => 'Filipino',
    'fiu'   => "Finno\ \-\ Ugrik\ Diller",
    'fj'    => "Fiji\ Dili",
    'fo'    => "Faroe\ Dili",
    'fon'   => 'Fon',
    'fr'    => 'Fransızca',
    'fr_ca' => "Kanada\ Fransızcası",
    'fr_ch' => "İsviçre\ Fransızcası",
    'frm'   => "Ortaçağ\ Fransızcası",
    'fro'   => "Eski\ Fransızca",
    'frr'   => "Kuzey\ Frizce",
    'frs'   => "Doğu\ Frizcesi",
    'fur'   => 'Friulian',
    'fy'    => "Batı\ Frizcesi",
    'ga'    => "İrlanda\ Dili",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "İskoç\ Gal\ Dili",
    'gem'   => "Cermen\ Dilleri",
    'gez'   => 'Geez',
    'gil'   => "Kiribati\ Dili",
    'gl'    => 'Galiçyaca',
    'gmh'   => "Ortaçağ\ Yüksek\ Almancası",
    'gn'    => 'Guarani',
    'goh'   => "Eski\ Yüksek\ Almanca",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gotça',
    'grb'   => 'Grebo',
    'grc'   => "Antik\ Yunanca",
    'gsw'   => "İsviçre\ Almancası",
    'gu'    => 'Gujarati',
    'gv'    => 'Manks',
    'gwi'   => 'Gwichʼin',
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => "Hawaii\ Dili",
    'he'    => 'İbranice',
    'hi'    => 'Hintçe',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hititçe',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Hırvatça',
    'hsb'   => "Yukarı\ Sorbça",
    'ht'    => "Haiti\ Dili",
    'hu'    => 'Macarca',
    'hup'   => 'Hupa',
    'hy'    => 'Ermenice',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Endonezce',
    'ie'    => 'Interlingue',
    'ig'    => "İbo\ Dili",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Iloko',
    'inc'   => "Hint\ Dilleri",
    'ine'   => "Hint\-Avrupa\ Dilleri",
    'inh'   => "İnguş\ Dili",
    'io'    => 'Ido',
    'ira'   => "İran\ Dilleri",
    'iro'   => "İroqu\ Dili",
    'is'    => 'İzlandaca',
    'it'    => 'İtalyanca',
    'iu'    => 'Inuktitut',
    'ja'    => 'Japonca',
    'jbo'   => 'Lojban',
    'jpr'   => "Yahudi\ Farsçası",
    'jrb'   => "Yahudi\ Arapçası",
    'jv'    => "Cava\ Dili",
    'ka'    => 'Gürcüce',
    'kaa'   => 'Karakalpakça',
    'kab'   => 'Kabile',
    'kac'   => 'Kaçin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardeyce',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Hoisan\ Dilleri",
    'kho'   => 'Hotanca',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakça',
    'kl'    => "Grönland\ Dili",
    'km'    => "Kamboçya\ Dili",
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korece',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karaçay\-Balkarça",
    'krl'   => 'Karelyaca',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Keşmirce',
    'ku'    => 'Kürtçe',
    'kum'   => 'Kumukça',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Kernevekçe',
    'ky'    => 'Kırgızca',
    'la'    => 'Latince',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Lüksemburgca',
    'lez'   => 'Lezgice',
    'lg'    => 'Ganda',
    'li'    => 'Limburgca',
    'ln'    => 'Lingala',
    'lo'    => "Laos\ Dili",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Litvanyaca',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Letonca',
    'mad'   => "Madura\ Dili",
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Avustronezya\ Dili",
    'mas'   => 'Masai',
    'mdf'   => "Mokşa\ Dili",
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasi',
    'mga'   => "Ortaçağ\ İrlandacası",
    'mh'    => "Marshall\ Adaları\ Dili",
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Çeşitli\ Diller",
    'mk'    => 'Makedonca',
    'mkh'   => "Mon\-Khmer\ Dilleri",
    'ml'    => 'Malayalam',
    'mn'    => 'Moğolca',
    'mnc'   => "Mançurya\ Dili",
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Dilleri",
    'mo'    => 'Moldovaca',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Marathi',
    'ms'    => 'Malay',
    'mt'    => "Malta\ Dili",
    'mul'   => "Birden\ Fazla\ Dil",
    'mun'   => "Munda\ Dilleri",
    'mus'   => 'Creek',
    'mwl'   => "Miranda\ Dili",
    'mwr'   => 'Marwari',
    'my'    => "Birmanya\ Dili",
    'myn'   => "Maya\ Dilleri",
    'myv'   => 'Erzya',
    'na'    => "Nauru\ Dili",
    'nah'   => 'Nahuatl',
    'nai'   => "Kuzey\ Amerika\ Yerli\ Dilleri",
    'nap'   => 'Napolice',
    'nb'    => "Norveççe\ Bokmål",
    'nd'    => "Kuzey\ Ndebele",
    'nds'   => "Aşağı\ Almanca",
    'ne'    => 'Nepalce',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Nijer\-Kordofan\ Dilleri",
    'niu'   => 'Niuean',
    'nl'    => "Hollanda\ Dili",
    'nl_be' => 'Felemenkçe',
    'nn'    => "Norveççe\ Nynorsk",
    'no'    => 'Norveççe',
    'nog'   => 'Nogayca',
    'non'   => "Eski\ Norse",
    'nqo'   => 'N’Ko',
    'nr'    => "Güney\ Ndebele",
    'nso'   => "Kuzey\ Sotho",
    'nub'   => "Nubian\ Dilleri",
    'nv'    => "Navaho\ Dili",
    'nwc'   => "Klasik\ Nevari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Oksitanca',
    'oj'    => "Ojibva\ Dili",
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Osetçe',
    'osa'   => 'Osage',
    'ota'   => "Osmanlı\ Türkçesi",
    'oto'   => "Otomi\ Dilleri",
    'pa'    => "Pencap\ Dili",
    'paa'   => "Papua\ Dilleri",
    'pag'   => 'Pangasinan',
    'pal'   => "Pehlevi\ Dili",
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => "Palau\ Dili",
    'peo'   => "Eski\ Farsça",
    'phi'   => "Filipinler\ Dilleri",
    'phn'   => "Fenike\ Dili",
    'pi'    => 'Pali',
    'pl'    => 'Lehçe',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Dilleri",
    'pro'   => "Eski\ Provensal",
    'ps'    => 'Peştuca',
    'pt'    => 'Portekizce',
    'pt_br' => "Brezilya\ Portekizcesi",
    'pt_pt' => "İber\ Portekizcesi",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Roman\ Dili",
    'rn'    => 'Kirundi',
    'ro'    => 'Romence',
    'roa'   => "Roman\ Dilleri",
    'rom'   => 'Romanca',
    'ru'    => 'Rusça',
    'rup'   => 'Ulahça',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanskritçe',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakutça',
    'sai'   => "Güney\ Amerika\ Yerli\ Dilleri",
    'sal'   => "Salishan\ Dilleri",
    'sam'   => "Samarit\ Aramcası",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => "Sardunya\ Dili",
    'scn'   => 'Sicilyaca',
    'sco'   => 'Scots',
    'sd'    => 'Sindhi',
    'se'    => "Kuzey\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitik\ Diller",
    'sg'    => 'Sangho',
    'sga'   => "Eski\ İrlandaca",
    'sgn'   => "İşaret\ Dilleri",
    'sh'    => "Sırp\-Hırvat\ Dili",
    'shn'   => "Shan\ Dili",
    'si'    => 'Seylanca',
    'sid'   => 'Sidamo',
    'sio'   => "Siu\ Dilleri",
    'sit'   => "Sino\-Tibet\ Dilleri",
    'sk'    => 'Slovakça',
    'sl'    => 'Slovence',
    'sla'   => "Slav\ Dilleri",
    'sm'    => "Samoa\ Dili",
    'sma'   => "Güney\ Sami",
    'smi'   => "Sami\ Dilleri",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => "Somali\ Dili",
    'sog'   => 'Sogdiana Dili',
    'son'   => 'Songhai',
    'sq'    => 'Arnavutça',
    'sr'    => 'Sırpça',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Siswati',
    'ssa'   => "Nil\-Sahara\ Dilleri",
    'st'    => "Güney\ Sotho",
    'su'    => "Sunda\ Dili",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sümerce',
    'sv'    => 'İsveççe',
    'sw'    => 'Swahili',
    'syc'   => "Klasik\ Süryanice",
    'syr'   => 'Süryanice',
    'ta'    => 'Tamilce',
    'tai'   => "Tai\ Dili",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tacikçe',
    'th'    => 'Tayca',
    'ti'    => 'Tigrinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Türkmence',
    'tkl'   => 'Tokelau',
    'tl'    => 'Takalotça',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaşek',
    'tn'    => 'Setswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Türkçe',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatarca',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Dilleri",
    'tut'   => "Altay\ Dilleri",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => "Tahiti\ Dili",
    'tyv'   => 'Tuvaca',
    'udm'   => 'Udmurtça',
    'ug'    => 'Uygurca',
    'uga'   => "Ugarit\ Dili",
    'uk'    => 'Ukraynaca',
    'umb'   => 'Umbundu',
    'und'   => "Bilinmeyen\ veya\ Geçersiz\ Dil",
    'ur'    => 'Urduca',
    'uz'    => 'Özbekçe',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vietnamca',
    'vo'    => 'Volapük',
    'vot'   => 'Votic',
    'wa'    => 'Valonca',
    'wak'   => "Wakashan\ Dilleri",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorb\ Dilleri",
    'wo'    => 'Volofca',
    'xal'   => 'Kalmıkça',
    'xh'    => 'Xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapça',
    'yi'    => 'Yidiş',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Dili",
    'za'    => 'Zhuang',
    'zap'   => "Zapotek\ Dili",
    'zbl'   => "Blis\ Sembolleri",
    'zen'   => 'Zenaga',
    'zh'    => 'Çince',
    'znd'   => 'Zande',
    'zu'    => 'Zulu',
    'zun'   => 'Zuni',
    'zxx'   => "Dilbilim\ içeriği\ yok",
    'zza'   => 'Zazaca',
);

%Locales::DB::Language::tr::name_to_code = (
    "aa\ almanca"                                     => 'nds',
    "aa\ sorba"                                       => 'dsb',
    "aatay\ dili"                                     => 'chg',
    'abhazca'                                         => 'ab',
    'achinese'                                        => 'ace',
    'acoli'                                           => 'ach',
    'adangme'                                         => 'ada',
    'afar'                                            => 'aa',
    'afrihili'                                        => 'afh',
    "afrikaan\ dili"                                  => 'af',
    "afroasyatik\ diller"                             => 'afa',
    "akad\ dili"                                      => 'akk',
    'akan'                                            => 'ak',
    'aleut'                                           => 'ale',
    "algonkin\ dili"                                  => 'alg',
    'almanca'                                         => 'de',
    "altay\ dilleri"                                  => 'tut',
    "amerikan\ ngilizcesi"                            => 'en_us',
    'amharca'                                         => 'am',
    'angika'                                          => 'anp',
    "antik\ yunanca"                                  => 'grc',
    "apai\ dilleri"                                   => 'apa',
    'aragonca'                                        => 'an',
    'aramice'                                         => 'arc',
    'arapa'                                           => 'ar',
    "arapaho\ dili"                                   => 'arp',
    "araukanya\ dili"                                 => 'arn',
    "arawak\ dili"                                    => 'arw',
    'arayanice'                                       => 'bho',
    "aret\ dilleri"                                   => 'sgn',
    'arnavuta'                                        => 'sq',
    'assamca'                                         => 'as',
    'asturyasca'                                      => 'ast',
    "atabakan\ dilleri"                               => 'ath',
    'atsam'                                           => 'cch',
    "avar\ dili"                                      => 'av',
    'aveste'                                          => 'ae',
    "avustralya\ dilleri"                             => 'aus',
    "avustralya\ ngilizcesi"                          => 'en_au',
    "avustronezya\ dili"                              => 'map',
    "avusturya\ almancas"                             => 'de_at',
    'awadhi'                                          => 'awa',
    "ayen\ dili"                                      => 'chy',
    'aymara'                                          => 'ay',
    "ayni\ dili"                                      => 'ain',
    'azerice'                                         => 'az',
    'bakrta'                                          => 'ba',
    "bali\ dili"                                      => 'ban',
    "baltk\ dilleri"                                  => 'bat',
    'baluchi'                                         => 'bal',
    'bambara'                                         => 'bm',
    "bamileke\ dilleri"                               => 'bai',
    "banda\ dili"                                     => 'bad',
    "bantu\ dili"                                     => 'bnt',
    "basa\ dili"                                      => 'bas',
    'baska'                                           => 'eu',
    "bat\ frizcesi"                                   => 'fy',
    'batak'                                           => 'btk',
    "beja\ dili"                                      => 'bej',
    'bemba'                                           => 'bem',
    'bengalce'                                        => 'bn',
    "ber\ portekizcesi"                               => 'pt_pt',
    "ber\ spanyolcas"                                 => 'es_es',
    'berberi'                                         => 'ber',
    "beyaz\ rusa"                                     => 'be',
    'bihari'                                          => 'bh',
    'bikol'                                           => 'bik',
    "bilinmeyen\ veya\ geersiz\ dil"                  => 'und',
    'bini'                                            => 'bin',
    "birden\ fazla\ dil"                              => 'mul',
    "birmanya\ dili"                                  => 'my',
    'bislama'                                         => 'bi',
    'blin'                                            => 'byn',
    "blis\ sembolleri"                                => 'zbl',
    "bo\ dili"                                        => 'ig',
    'bonaka'                                          => 'bs',
    'braj'                                            => 'bra',
    'branice'                                         => 'he',
    'bretonca'                                        => 'br',
    "brezilya\ portekizcesi"                          => 'pt_br',
    'bugis'                                           => 'bug',
    'bulgarca'                                        => 'bg',
    'buryat'                                          => 'bua',
    "butan\ dili"                                     => 'dz',
    'caddo'                                           => 'cad',
    'carib'                                           => 'car',
    "cava\ dili"                                      => 'jv',
    'cebuano'                                         => 'ceb',
    "cermen\ dilleri"                                 => 'gem',
    "chamic\ dilleri"                                 => 'cmc',
    'chamorro'                                        => 'ch',
    'chibcha'                                         => 'chb',
    "chinook\ jargon"                                 => 'chn',
    'chipewyan'                                       => 'chp',
    'choctaw'                                         => 'cho',
    'chuukese'                                        => 'chk',
    'cree'                                            => 'cr',
    'creek'                                           => 'mus',
    "creole\ ve\ pidgin\ dilleri"                     => 'crp',
    'dakota'                                          => 'dak',
    'danca'                                           => 'da',
    'dargince'                                        => 'dar',
    'dayak'                                           => 'day',
    'delaware'                                        => 'del',
    "dilbilim\ ierii\ yok"                            => 'zxx',
    'dinka'                                           => 'din',
    'divehi'                                          => 'dv',
    'dogri'                                           => 'doi',
    'dogrib'                                          => 'dgr',
    "dou\ frizcesi"                                   => 'frs',
    "dravid\ dilleri"                                 => 'dra',
    'duala'                                           => 'dua',
    'dyula'                                           => 'dyu',
    'eence'                                           => 'ce',
    'efik'                                            => 'efi',
    "eitli\ diller"                                   => 'mis',
    'ekajuk'                                          => 'eka',
    'eke'                                             => 'cs',
    'elam'                                            => 'elx',
    'endonezce'                                       => 'id',
    'erkezce'                                         => 'ady',
    'ermenice'                                        => 'hy',
    'eroki'                                           => 'chr',
    'erzya'                                           => 'myv',
    "eski\ farsa"                                     => 'peo',
    "eski\ franszca"                                  => 'fro',
    "eski\ msr\ dili"                                 => 'egy',
    "eski\ ngilizce"                                  => 'ang',
    "eski\ norse"                                     => 'non',
    "eski\ provensal"                                 => 'pro',
    "eski\ rlandaca"                                  => 'sga',
    "eski\ yksek\ almanca"                            => 'goh',
    'esperanto'                                       => 'eo',
    "estonya\ dili"                                   => 'et',
    'ewe'                                             => 'ee',
    'ewondo'                                          => 'ewo',
    'fang'                                            => 'fan',
    'fanti'                                           => 'fat',
    "faroe\ dili"                                     => 'fo',
    'farsa'                                           => 'fa',
    'felemenke'                                       => 'nl_be',
    "fenike\ dili"                                    => 'phn',
    "fiji\ dili"                                      => 'fj',
    "filipinler\ dilleri"                             => 'phi',
    'filipino'                                        => 'fil',
    'fince'                                           => 'fi',
    "finno\ \ ugrik\ diller"                          => 'fiu',
    'fon'                                             => 'fon',
    'franszca'                                        => 'fr',
    "franszca\ tabanl\ creole\ ve\ pidgin\ dilleri"   => 'cpf',
    'friulian'                                        => 'fur',
    'fulah'                                           => 'ff',
    'ga'                                              => 'gaa',
    'galce'                                           => 'cy',
    'galiyaca'                                        => 'gl',
    'ganda'                                           => 'lg',
    'gayo'                                            => 'gay',
    'gbaya'                                           => 'gba',
    'geez'                                            => 'gez',
    "gney\ altayca"                                   => 'alt',
    "gney\ amerika\ yerli\ dilleri"                   => 'sai',
    "gney\ ndebele"                                   => 'nr',
    "gney\ sami"                                      => 'sma',
    "gney\ sotho"                                     => 'st',
    'gondi'                                           => 'gon',
    'gorontalo'                                       => 'gor',
    'gota'                                            => 'got',
    'grcce'                                           => 'ka',
    'grebo'                                           => 'grb',
    "grnland\ dili"                                   => 'kl',
    'guarani'                                         => 'gn',
    'gujarati'                                        => 'gu',
    'gwichin'                                         => 'gwi',
    'haida'                                           => 'hai',
    "haiti\ dili"                                     => 'ht',
    'hausa'                                           => 'ha',
    "hawaii\ dili"                                    => 'haw',
    'herero'                                          => 'hz',
    'hiligaynon'                                      => 'hil',
    'himachali'                                       => 'him',
    "hint\ dilleri"                                   => 'inc',
    "hintavrupa\ dilleri"                             => 'ine',
    'hinte'                                           => 'hi',
    "hiri\ motu"                                      => 'ho',
    'hitite'                                          => 'hit',
    'hmong'                                           => 'hmn',
    "hoisan\ dilleri"                                 => 'khi',
    "hollanda\ dili"                                  => 'nl',
    'hotanca'                                         => 'kho',
    'hrvata'                                          => 'hr',
    'hupa'                                            => 'hup',
    'iban'                                            => 'iba',
    'ido'                                             => 'io',
    'ijo'                                             => 'ijo',
    'iloko'                                           => 'ilo',
    "inari\ sami"                                     => 'smn',
    'ince'                                            => 'zh',
    'interlingua'                                     => 'ia',
    'interlingue'                                     => 'ie',
    'inuktitut'                                       => 'iu',
    'inupiak'                                         => 'ik',
    'japonca'                                         => 'ja',
    'jju'                                             => 'kaj',
    'kabardeyce'                                      => 'kbd',
    'kabile'                                          => 'kab',
    "kafkas\ dilleri"                                 => 'cau',
    'kain'                                            => 'kac',
    'kalmka'                                          => 'xal',
    'kamba'                                           => 'kam',
    "kamboya\ dili"                                   => 'km',
    "kanada\ franszcas"                               => 'fr_ca',
    "kanada\ ngilizcesi"                              => 'en_ca',
    'kannada'                                         => 'kn',
    'kanuri'                                          => 'kr',
    'karaaybalkara'                                   => 'krc',
    'karakalpaka'                                     => 'kaa',
    'karelyaca'                                       => 'krl',
    'karen'                                           => 'kar',
    'kashubian'                                       => 'csb',
    'katalanca'                                       => 'ca',
    'kawi'                                            => 'kaw',
    'kazaka'                                          => 'kk',
    "kelt\ dilleri"                                   => 'cel',
    'kemirce'                                         => 'ks',
    'kerneveke'                                       => 'kw',
    'khasi'                                           => 'kha',
    'kikuyu'                                          => 'ki',
    "kilise\ slavcas"                                 => 'cu',
    'kimbundu'                                        => 'kmb',
    'kinyarwanda'                                     => 'rw',
    'kiptice'                                         => 'cop',
    "kiribati\ dili"                                  => 'gil',
    'kirundi'                                         => 'rn',
    "klasik\ nevari"                                  => 'nwc',
    "klasik\ sryanice"                                => 'syc',
    'klingon'                                         => 'tlh',
    'komi'                                            => 'kv',
    'kongo'                                           => 'kg',
    'konkani'                                         => 'kok',
    'korece'                                          => 'ko',
    'koro'                                            => 'kfo',
    'korsikaca'                                       => 'co',
    'kosraean'                                        => 'kos',
    'kpelle'                                          => 'kpe',
    'krgzca'                                          => 'ky',
    "krm\ trkesi"                                     => 'crh',
    'krte'                                            => 'ku',
    'kru'                                             => 'kro',
    'kuanyama'                                        => 'kj',
    "kuitik\ diller"                                  => 'cus',
    'kumuka'                                          => 'kum',
    'kurukh'                                          => 'kru',
    'kutenai'                                         => 'kut',
    "kuzey\ amerika\ yerli\ dilleri"                  => 'nai',
    "kuzey\ frizce"                                   => 'frr',
    "kuzey\ ndebele"                                  => 'nd',
    "kuzey\ sami"                                     => 'se',
    "kuzey\ sotho"                                    => 'nso',
    'ladino'                                          => 'lad',
    'lahnda'                                          => 'lah',
    'lamba'                                           => 'lam',
    "laos\ dili"                                      => 'lo',
    'latince'                                         => 'la',
    'lehe'                                            => 'pl',
    'letonca'                                         => 'lv',
    'lezgice'                                         => 'lez',
    'limburgca'                                       => 'li',
    'lingala'                                         => 'ln',
    'litvanyaca'                                      => 'lt',
    'lksemburgca'                                     => 'lb',
    'lojban'                                          => 'jbo',
    'lozi'                                            => 'loz',
    'lubakatanga'                                     => 'lu',
    'lubalulua'                                       => 'lua',
    'luiseno'                                         => 'lui',
    "lule\ sami"                                      => 'smj',
    'lunda'                                           => 'lun',
    'luo'                                             => 'luo',
    'lushai'                                          => 'lus',
    'macarca'                                         => 'hu',
    "madura\ dili"                                    => 'mad',
    'magahi'                                          => 'mag',
    'maithili'                                        => 'mai',
    'makasar'                                         => 'mak',
    'makedonca'                                       => 'mk',
    'malagasi'                                        => 'mg',
    'malay'                                           => 'ms',
    'malayalam'                                       => 'ml',
    "malta\ dili"                                     => 'mt',
    'mandar'                                          => 'mdr',
    'mandingo'                                        => 'man',
    'manipuri'                                        => 'mni',
    'manks'                                           => 'gv',
    "manobo\ dilleri"                                 => 'mno',
    "manurya\ dili"                                   => 'mnc',
    'maori'                                           => 'mi',
    'marathi'                                         => 'mr',
    'mari'                                            => 'chm',
    "marshall\ adalar\ dili"                          => 'mh',
    'marwari'                                         => 'mwr',
    'masai'                                           => 'mas',
    "maya\ dilleri"                                   => 'myn',
    'mende'                                           => 'men',
    'micmac'                                          => 'mic',
    'minangkabau'                                     => 'min',
    "miranda\ dili"                                   => 'mwl',
    'mohawk'                                          => 'moh',
    "moka\ dili"                                      => 'mdf',
    'moldovaca'                                       => 'mo',
    'mongo'                                           => 'lol',
    "monkhmer\ dilleri"                               => 'mkh',
    'moolca'                                          => 'mn',
    'morisyen'                                        => 'mfe',
    'mossi'                                           => 'mos',
    "munda\ dilleri"                                  => 'mun',
    'nahuatl'                                         => 'nah',
    'napolice'                                        => 'nap',
    "nauru\ dili"                                     => 'na',
    "navaho\ dili"                                    => 'nv',
    'ndonga'                                          => 'ng',
    'nepalce'                                         => 'ne',
    'newari'                                          => 'new',
    "ngiliz\ ngilizcesi"                              => 'en_gb',
    'ngilizce'                                        => 'en',
    "ngilizce\ tabanl\ creole\ ve\ pidgin\ dilleri"   => 'cpe',
    "ngu\ dili"                                       => 'inh',
    'nias'                                            => 'nia',
    "nijerkordofan\ dilleri"                          => 'nic',
    "nilsahara\ dilleri"                              => 'ssa',
    'niuean'                                          => 'niu',
    'nko'                                             => 'nqo',
    'nogayca'                                         => 'nog',
    'norvee'                                          => 'no',
    "norvee\ bokml"                                   => 'nb',
    "norvee\ nynorsk"                                 => 'nn',
    "nubian\ dilleri"                                 => 'nub',
    'nyamwezi'                                        => 'nym',
    'nyanja'                                          => 'ny',
    'nyankole'                                        => 'nyn',
    "nyasa\ tonga"                                    => 'tog',
    'nyoro'                                           => 'nyo',
    'nzima'                                           => 'nzi',
    "ojibva\ dili"                                    => 'oj',
    'oksitanca'                                       => 'oc',
    'oriya'                                           => 'or',
    'oromo'                                           => 'om',
    "orta\ amerika\ yerli\ dilleri"                   => 'cai',
    "ortaa\ felemenkesi"                              => 'dum',
    "ortaa\ franszcas"                                => 'frm',
    "ortaa\ ngilizcesi"                               => 'enm',
    "ortaa\ rlandacas"                                => 'mga',
    "ortaa\ yksek\ almancas"                          => 'gmh',
    'osage'                                           => 'osa',
    'osete'                                           => 'os',
    "osmanl\ trkesi"                                  => 'ota',
    "otomi\ dilleri"                                  => 'oto',
    "palau\ dili"                                     => 'pau',
    'pali'                                            => 'pi',
    'pampanga'                                        => 'pam',
    'pangasinan'                                      => 'pag',
    'papiamento'                                      => 'pap',
    "papua\ dilleri"                                  => 'paa',
    "pehlevi\ dili"                                   => 'pal',
    "pencap\ dili"                                    => 'pa',
    'petuca'                                          => 'ps',
    'pohnpeian'                                       => 'pon',
    'portekizce'                                      => 'pt',
    "portekizce\ tabanl\ creole\ ve\ pidgin\ dilleri" => 'cpp',
    "prakrit\ dilleri"                                => 'pra',
    'quechua'                                         => 'qu',
    'rajasthani'                                      => 'raj',
    "ran\ dilleri"                                    => 'ira',
    'rapanui'                                         => 'rap',
    'rarotongan'                                      => 'rar',
    "rhaetoroman\ dili"                               => 'rm',
    "rlanda\ dili"                                    => 'ga',
    "roman\ dilleri"                                  => 'roa',
    'romanca'                                         => 'rom',
    'romence'                                         => 'ro',
    "roqu\ dili"                                      => 'iro',
    'rusa'                                            => 'ru',
    "salishan\ dilleri"                               => 'sal',
    "samarit\ aramcas"                                => 'sam',
    "sami\ dilleri"                                   => 'smi',
    "samoa\ dili"                                     => 'sm',
    'sandawe'                                         => 'sad',
    'sangho'                                          => 'sg',
    'sanskrite'                                       => 'sa',
    'santali'                                         => 'sat',
    "sardunya\ dili"                                  => 'sc',
    'sasak'                                           => 'sas',
    'scots'                                           => 'sco',
    'selkup'                                          => 'sel',
    "semitik\ diller"                                 => 'sem',
    'serer'                                           => 'srr',
    'setswana'                                        => 'tn',
    'seylanca'                                        => 'si',
    "shan\ dili"                                      => 'shn',
    'shona'                                           => 'sn',
    "sichuan\ yi"                                     => 'ii',
    'sicilyaca'                                       => 'scn',
    'sidamo'                                          => 'sid',
    'siksika'                                         => 'bla',
    'sindhi'                                          => 'sd',
    "sinotibet\ dilleri"                              => 'sit',
    'siswati'                                         => 'ss',
    "siu\ dilleri"                                    => 'sio',
    "sko\ gal\ dili"                                  => 'gd',
    "skolt\ sami"                                     => 'sms',
    "slav\ dilleri"                                   => 'sla',
    'slavey'                                          => 'den',
    'slovaka'                                         => 'sk',
    'slovence'                                        => 'sl',
    'smerce'                                          => 'sux',
    "sogdiana\ dili"                                  => 'sog',
    "somali\ dili"                                    => 'so',
    'songhai'                                         => 'son',
    'soninke'                                         => 'snk',
    "sorb\ dilleri"                                   => 'wen',
    'spanyolca'                                       => 'es',
    "sranan\ tongo"                                   => 'srn',
    'srpa'                                            => 'sr',
    "srphrvat\ dili"                                  => 'sh',
    'sryanice'                                        => 'syr',
    'sukuma'                                          => 'suk',
    "sunda\ dili"                                     => 'su',
    'susu'                                            => 'sus',
    'svee'                                            => 'sv',
    "svire\ almancas"                                 => 'gsw',
    "svire\ franszcas"                                => 'fr_ch',
    "svire\ yksek\ almancas"                          => 'de_ch',
    'swahili'                                         => 'sw',
    'tacike'                                          => 'tg',
    "tahiti\ dili"                                    => 'ty',
    "tai\ dili"                                       => 'tai',
    'takalota'                                        => 'tl',
    'talyanca'                                        => 'it',
    'tamaek'                                          => 'tmh',
    'tamilce'                                         => 'ta',
    'taroko'                                          => 'trv',
    'tatarca'                                         => 'tt',
    'tayca'                                           => 'th',
    'telugu'                                          => 'te',
    'tereno'                                          => 'ter',
    'tetum'                                           => 'tet',
    'tibete'                                          => 'bo',
    'tigre'                                           => 'tig',
    'tigrinya'                                        => 'ti',
    'timne'                                           => 'tem',
    'tiv'                                             => 'tiv',
    'tlingit'                                         => 'tli',
    "tok\ pisin"                                      => 'tpi',
    'tokelau'                                         => 'tkl',
    'tonga'                                           => 'to',
    'trke'                                            => 'tr',
    'trkmence'                                        => 'tk',
    'tsimshian'                                       => 'tsi',
    'tsonga'                                          => 'ts',
    'tumbuka'                                         => 'tum',
    "tupi\ dilleri"                                   => 'tup',
    'tuvaca'                                          => 'tyv',
    'tuvalu'                                          => 'tvl',
    'twi'                                             => 'tw',
    'tyap'                                            => 'kcg',
    'udmurta'                                         => 'udm',
    "ugarit\ dili"                                    => 'uga',
    'ukraynaca'                                       => 'uk',
    'ulaha'                                           => 'rup',
    'umbundu'                                         => 'umb',
    'urduca'                                          => 'ur',
    'uvaa'                                            => 'cv',
    'uygurca'                                         => 'ug',
    'vai'                                             => 'vai',
    'valonca'                                         => 'wa',
    'venda'                                           => 've',
    'vietnamca'                                       => 'vi',
    'volapk'                                          => 'vo',
    'volofca'                                         => 'wo',
    'votic'                                           => 'vot',
    "wakashan\ dilleri"                               => 'wak',
    'walamo'                                          => 'wal',
    'waray'                                           => 'war',
    'washo'                                           => 'was',
    'xhosa'                                           => 'xh',
    "yahudi\ arapas"                                  => 'jrb',
    "yahudi\ farsas"                                  => 'jpr',
    'yakuta'                                          => 'sah',
    'yao'                                             => 'yao',
    'yapa'                                            => 'yap',
    "yapay\ diller"                                   => 'art',
    'yidi'                                            => 'yi',
    'yoruba'                                          => 'yo',
    "yukar\ sorba"                                    => 'hsb',
    'yunanca'                                         => 'el',
    "yupik\ dili"                                     => 'ypk',
    'zande'                                           => 'znd',
    "zapotek\ dili"                                   => 'zap',
    'zazaca'                                          => 'zza',
    'zbeke'                                           => 'uz',
    'zenaga'                                          => 'zen',
    'zhuang'                                          => 'za',
    'zlandaca'                                        => 'is',
    'zulu'                                            => 'zu',
    'zuni'                                            => 'zun',
);

1;
