package Locales::DB::Language::mt;

# Auto generated from CLDR

$Locales::DB::Language::mt::VERSION = '0.01';

$Locales::DB::Language::mt::cldr_version = '1.7.1';

%Locales::DB::Language::mt::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Lingwa\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Reġjun\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content'    => "le\:l",
            'references' => 'R200'
        },
        'yesstr' => {
            'content'    => "iva\:i",
            'references' => 'R200'
        }
    },
);

%Locales::DB::Language::mt::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkażjan',
    'ace'   => 'Aċiniż',
    'ach'   => 'Akoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'Afrikans',
    'afa'   => "Afro\-Asjatiku\ \(Oħra\)",
    'afh'   => 'Afriħili',
    'ain'   => 'Ajnu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadjen',
    'ale'   => 'Aleut',
    'alg'   => "Lingwi\ Algonqwinjani",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amħariku',
    'an'    => 'Aragonese',
    'ang'   => "Ingliż\,\ Antik",
    'anp'   => 'Angika',
    'apa'   => "Lingwi\ Apaċi",
    'ar'    => 'Għarbi',
    'arc'   => 'Aramajk',
    'arn'   => 'Arawkanjan',
    'arp'   => 'Arapaħo',
    'art'   => "Artifiċjali\ \(Oħra\)",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Lingwi\ Atabaskani",
    'aus'   => "Lingwi\ Awstraljani",
    'av'    => 'Avarik',
    'awa'   => 'Awadħi',
    'ay'    => 'Ajmara',
    'az'    => 'Ażerbajġani',
    'ba'    => 'Baxkir',
    'bad'   => 'Banda',
    'bai'   => "Lingwi\ Bamileke",
    'bal'   => 'Baluċi',
    'ban'   => 'Baliniż',
    'bas'   => 'Basa',
    'bat'   => "Baltiku\ \(Oħra\)",
    'be'    => 'Belarussu',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Beber',
    'bg'    => 'Bulgaru',
    'bh'    => 'Biħari',
    'bho'   => 'Bojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Bengali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetjan',
    'br'    => 'Brenton',
    'bra'   => 'Braj',
    'bs'    => 'Bosnijan',
    'btk'   => 'Batak',
    'bua'   => 'Burjat',
    'bug'   => 'Buginiż',
    'byn'   => 'Blin',
    'ca'    => 'Katalan',
    'cad'   => 'Kaddo',
    'cai'   => "Amerika\ Ċentrali\ \(Oħra\)",
    'car'   => 'Karib',
    'cau'   => "Kawkasu\ \(Oħra\)",
    'cch'   => 'Atsam',
    'ce'    => 'Ċeċen',
    'ceb'   => 'Sibwano',
    'cel'   => "Keltiku\ \(Oħra\)",
    'ch'    => 'Ċamorro',
    'chb'   => 'Ċibċa',
    'chg'   => 'Ċagataj',
    'chk'   => 'Ċukese',
    'chm'   => 'Mari',
    'chn'   => "Ġargon\ taċ\-Ċinuk",
    'cho'   => 'Ċostaw',
    'chp'   => 'Ċipewjan',
    'chr'   => 'Ċerokij',
    'chy'   => 'Xajenn',
    'cmc'   => "Lingwi\ Ċamiki",
    'co'    => 'Korsiku',
    'cop'   => 'Koptiku',
    'cpe'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ l\-Ingliż\ \(Oħra\)",
    'cpf'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ il\-Franċiż\ \(Oħra\)",
    'cpp'   => "Kreoli\ u\ Piġini\,\ Bbażat\ fuq\ il\-Portugiż\ \(Oħra\)",
    'cr'    => 'Krij',
    'crh'   => "Crimean\ Turkish\;\ Crimean\ Tatar",
    'crp'   => "Kreoli\ u\ Piġini\ \(Oħra\)",
    'cs'    => 'Ċek',
    'csb'   => 'Kashubian',
    'cu'    => "Slaviku\ tal\-Knisja",
    'cus'   => "Kuxtiku\ \(Oħra\)",
    'cv'    => 'Ċuvax',
    'cy'    => 'Welx',
    'da'    => 'Daniż',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dajak',
    'de'    => 'Ġermaniż',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delawerjan',
    'den'   => 'Slav',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidjan\ \(Oħra\)",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Dwala',
    'dum'   => "Olandiż\,\ Medjevali",
    'dv'    => 'Diveħi',
    'dyu'   => 'Djula',
    'dz'    => 'Dżongka',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Eġizzjan\ \(Antik\)",
    'eka'   => 'Ekajuk',
    'el'    => 'Grieg',
    'elx'   => 'Elamit',
    'en'    => 'Ingliż',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Ingliż\,\ Medjevali\ \(1100\-1500\)",
    'eo'    => 'Esperanto',
    'es'    => 'Spanjol',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'Estonjan',
    'eu'    => 'Bask',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persjan',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulaħ',
    'fi'    => 'Finlandiż',
    'fil'   => 'Filippino',
    'fiu'   => "Finno\ \-\ Ugrijan",
    'fj'    => 'Fiġi',
    'fo'    => 'Fawriż',
    'fon'   => 'Fon',
    'fr'    => 'Franċiż',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Franċiż\,\ Medjevali",
    'fro'   => "Franċiż\,\ Antik",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Frijuljan',
    'fy'    => 'Friżjan',
    'ga'    => 'Irlandiż',
    'gaa'   => 'Ga',
    'gay'   => 'Gajo',
    'gba'   => 'Gbaja',
    'gd'    => "Galliku\ Skoċċiż",
    'gem'   => "Ġermaniku\ \(Oħra\)",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertjan',
    'gl'    => 'Gallegjan',
    'gmh'   => "Ġermaniku\,\ Medjevali\ Pulit",
    'gn'    => 'Gwarani',
    'goh'   => "Ġermaniku\,\ Antik\ Pulit",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gotiku',
    'grb'   => 'Ġerbo',
    'grc'   => "Grieg\,\ Antik\ \(to\ 1453\)",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Guġarati',
    'gv'    => 'Manks',
    'gwi'   => 'Gwiċin',
    'ha'    => 'Ħawsa',
    'hai'   => 'Ħajda',
    'haw'   => 'Ħawajjan',
    'he'    => 'Ebrajk',
    'hi'    => 'Ħindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Ħimaċali',
    'hit'   => 'Ħittit',
    'hmn'   => 'Ħmong',
    'ho'    => "Ħiri\ Motu",
    'hr'    => 'Kroat',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Ungeriż',
    'hup'   => 'Ħupa',
    'hy'    => 'Armenjan',
    'hz'    => 'Ħerero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indoneżjan',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Iġo',
    'ik'    => 'Inupjak',
    'ilo'   => 'Iloko',
    'inc'   => "Indjan\ \(Oħra\)",
    'ine'   => "Indo\-Ewropew",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => 'Iranjan',
    'iro'   => "Lingwi\ Irogwjani",
    'is'    => 'Iżlandiż',
    'it'    => 'Taljan',
    'iu'    => 'Inukitut',
    'ja'    => 'Ġappuniż',
    'jbo'   => 'Lojban',
    'jpr'   => "Lhudi\-Persjan",
    'jrb'   => "Lhudi\-Għarbi",
    'jv'    => 'Ġavaniż',
    'ka'    => 'Ġorġjan',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabuljan',
    'kac'   => 'Kaċin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Kasi',
    'khi'   => 'Kojsan',
    'kho'   => 'Kotaniż',
    'ki'    => 'Kikuju',
    'kj'    => 'Kuanyama',
    'kk'    => 'Każak',
    'kl'    => 'Kalallisut',
    'km'    => 'Kmer',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Kannada',
    'ko'    => 'Korejan',
    'kok'   => 'Konkani',
    'kos'   => 'Kosrejan',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurusk',
    'ks'    => 'Kaxmiri',
    'ku'    => 'Kurdiż',
    'kum'   => 'Kumiku',
    'kut'   => 'Kutenaj',
    'kv'    => 'Komi',
    'kw'    => 'Korniku',
    'ky'    => 'Kirgiż',
    'la'    => 'Latin',
    'lad'   => 'Ladino',
    'lah'   => 'Landa',
    'lam'   => 'Lamba',
    'lb'    => 'Letżburgiż',
    'lez'   => 'Leżgjan',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingaljan',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lożi',
    'lt'    => 'Litwanjan',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Luluwa",
    'lui'   => 'Luwisinuż',
    'lun'   => 'Lunda',
    'luo'   => 'Luwa',
    'lus'   => 'Luxaj',
    'lv'    => "Latvjan\ \(Lettix\)",
    'mad'   => 'Maduriż',
    'mag'   => 'Magaħi',
    'mai'   => 'Majtili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingwan',
    'map'   => 'Awstronesjan',
    'mas'   => 'Masaj',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagażi',
    'mga'   => "Irlandiż\,\ Medjevali\ \(900\-1200\)",
    'mh'    => 'Marxall',
    'mi'    => 'Maori',
    'mic'   => 'Mikmek',
    'min'   => 'Minangkabaw',
    'mis'   => "Lingwi\ Oħra",
    'mk'    => 'Maċedonjan',
    'mkh'   => "Mon\-Kmer\ \(Oħra\)",
    'ml'    => 'Malajalam',
    'mn'    => 'Mongoljan',
    'mnc'   => 'Manċurjan',
    'mni'   => 'Manipuri',
    'mno'   => "Lingwi\ Manobo",
    'mo'    => 'Moldavjan',
    'moh'   => 'Moħak',
    'mos'   => 'Mossi',
    'mr'    => 'Marati',
    'ms'    => 'Malajan',
    'mt'    => 'Malti',
    'mul'   => "Lingwi\ Diversi",
    'mun'   => "Lingwi\ tal\-Munda",
    'mus'   => 'Kriek',
    'mwl'   => 'Mirandiż',
    'mwr'   => 'Marwari',
    'my'    => 'Burmiż',
    'myn'   => 'Majan',
    'myv'   => 'Erzya',
    'na'    => 'Nawuru',
    'nah'   => 'Naħwatil',
    'nai'   => "Indjan\ tal\-Amerika\ ta’\ Fuq\ \(Oħra\)",
    'nap'   => 'Neapolitan',
    'nb'    => "Bokmahal\ Norveġiż",
    'nd'    => "Ndebele\,\ ta’\ Fuq",
    'nds'   => "Ġermaniż\ Komuni\;\ Sassonu\ Komuni",
    'ne'    => 'Nepaliż',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nijas',
    'nic'   => "Niġerjan\ \-\ Kordofanjan",
    'niu'   => 'Nijuwejan',
    'nl'    => 'Olandiż',
    'nl_be' => 'Flemish',
    'nn'    => "Ninorsk\ Norveġiż",
    'no'    => 'Norveġiż',
    'nog'   => 'Nogai',
    'non'   => "Skandinav\,\ Antik",
    'nqo'   => "N\â\\Ko",
    'nr'    => "Ndebele\,\ t’Isfel",
    'nso'   => "Soto\,\ ta’\ Fuq",
    'nub'   => "Lingwi\ Nubjani",
    'nv'    => 'Navaħo',
    'nwc'   => "Classical\ Newari",
    'ny'    => "Ċiċewa\;\ Njanġa",
    'nym'   => 'Njamweżi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Njoro',
    'nzi'   => 'Nżima',
    'oc'    => 'Oċċitan',
    'oj'    => 'Oġibwa',
    'om'    => "Oromo\ \(Afan\)",
    'or'    => 'Orija',
    'os'    => 'Ossettiku',
    'osa'   => 'Osaġjan',
    'ota'   => "Tork\ \(Imperu\ Ottoman\)",
    'oto'   => "Lingwi\ Otomjani",
    'pa'    => 'Punġabi',
    'paa'   => "Papwan\ \(Oħra\)",
    'pag'   => 'Pangasinjan',
    'pal'   => 'Paħlavi',
    'pam'   => 'Pampamga',
    'pap'   => 'Papjamento',
    'pau'   => 'Palawjan',
    'peo'   => "Persjan\ Antik",
    'phi'   => "Filippin\ \(Oħra\)",
    'phn'   => 'Feniċju',
    'pi'    => 'Pali',
    'pl'    => 'Pollakk',
    'pon'   => 'Ponpejan',
    'pra'   => "Lingwi\ Prakriti",
    'pro'   => "Provenzal\,\ Antik\ \(sa\ l\-1500\)",
    'ps'    => 'Paxtun',
    'pt'    => 'Portugiż',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Keċwa',
    'raj'   => 'Raġastani',
    'rap'   => 'Rapanwi',
    'rar'   => 'Rarotongani',
    'rm'    => "Reto\-Romanz",
    'rn'    => 'Rundi',
    'ro'    => 'Rumen',
    'roa'   => "Romanz\ \(Oħra\)",
    'rom'   => 'Żingaru',
    'ru'    => 'Russu',
    'rup'   => 'Aromanijan',
    'rw'    => 'Kinjarwanda',
    'sa'    => 'Sanskrit',
    'sad'   => 'Sandawe',
    'sah'   => 'Jakut',
    'sai'   => "Indjan\ tal\-Amerika\ t’Isfel\ \(Oħra\)",
    'sal'   => 'Salixan',
    'sam'   => 'Samritan',
    'sas'   => 'Saska',
    'sat'   => 'Santali',
    'sc'    => 'Sardinjan',
    'scn'   => 'Sicilian',
    'sco'   => 'Skoċċiż',
    'sd'    => 'Sindi',
    'se'    => "Sami\ ta’\ Fuq",
    'sel'   => 'Selkup',
    'sem'   => 'Semitiku',
    'sg'    => 'Sango',
    'sga'   => "Irlandiż\,\ Antik\ \(sa\ l\-900\)",
    'sgn'   => "Lingwa\ tas\-Sinjali",
    'sh'    => "Serbo\-Kroat",
    'shn'   => 'Xan',
    'si'    => 'Sinħaliż',
    'sid'   => 'Sidamo',
    'sio'   => "Lingwi\ Suwjani",
    'sit'   => "Sino\-Tibetjani\ \(Oħra\)",
    'sk'    => 'Slovakk',
    'sl'    => 'Sloven',
    'sla'   => "Slavic\ \(Other\)",
    'sm'    => 'Samojan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ languages\ \(Other\)",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Xona',
    'snk'   => 'Soninke',
    'so'    => 'Somali',
    'sog'   => 'Sogdien',
    'son'   => 'Songaj',
    'sq'    => 'Albaniż',
    'sr'    => 'Serb',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saħaram",
    'st'    => "Soto\,\ t’Isfel",
    'su'    => 'Sundaniż',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerjan',
    'sv'    => 'Svediż',
    'sw'    => 'Swaħili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Sirjan',
    'ta'    => 'Tamil',
    'tai'   => "Tai\ \(Oħra\)",
    'te'    => 'Telugu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Taġik',
    'th'    => 'Tajlandiż',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Turkmeni',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamaxek',
    'tn'    => 'Zwana',
    'to'    => "Tongan\ \(Gżejjer\ ta’\ Tonga\)",
    'tog'   => "Tonga\ \(Njasa\)",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Tork',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Zimxjan',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ languages",
    'tut'   => "Altajk\ \(Oħra\)",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'ty'    => 'Taħitjan',
    'tyv'   => 'Tuvinjan',
    'udm'   => 'Udmurt',
    'ug'    => 'Wigur',
    'uga'   => 'Ugaritiku',
    'uk'    => 'Ukranjan',
    'umb'   => 'Umbundu',
    'und'   => 'Indeterminat',
    'ur'    => 'Urdu',
    'uz'    => 'Użbek',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vjetnamiż',
    'vo'    => 'Volapuk',
    'vot'   => 'Votik',
    'wa'    => 'Walloon',
    'wak'   => "Lingwi\ Wakaxani",
    'wal'   => 'Walamo',
    'war'   => 'Waraj',
    'was'   => 'Waxo',
    'wen'   => "Lingwi\ Sorbjani",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Ħoża',
    'yao'   => 'Jao',
    'yap'   => 'Japese',
    'yi'    => 'Jiddix',
    'yo'    => 'Joruba',
    'ypk'   => "Lingwi\ Jupiċi",
    'za'    => 'Żwang',
    'zap'   => 'Żapotek',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Żenaga',
    'zh'    => 'Ċiniż',
    'znd'   => 'Żande',
    'zu'    => 'Żulu',
    'zun'   => 'Żuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::mt::name_to_code = (
    'abkajan'                                      => 'ab',
    'adangme'                                      => 'ada',
    'adyghe'                                       => 'ady',
    'aerbajani'                                    => 'az',
    'afar'                                         => 'aa',
    'afriili'                                      => 'afh',
    'afrikans'                                     => 'af',
    "afroasjatiku\ ora"                            => 'afa',
    'agataj'                                       => 'chg',
    'aini'                                         => 'ace',
    'ajda'                                         => 'hai',
    'ajmara'                                       => 'ay',
    'ajnu'                                         => 'ain',
    'akan'                                         => 'ak',
    'akkadjen'                                     => 'akk',
    'akoli'                                        => 'ach',
    'albani'                                       => 'sq',
    'aleut'                                        => 'ale',
    "altajk\ ora"                                  => 'tut',
    'amariku'                                      => 'am',
    "amerika\ entrali\ ora"                        => 'cai',
    'amorro'                                       => 'ch',
    'ande'                                         => 'znd',
    'angika'                                       => 'anp',
    'apotek'                                       => 'zap',
    'appuni'                                       => 'ja',
    'aragonese'                                    => 'an',
    'aramajk'                                      => 'arc',
    'arapao'                                       => 'arp',
    'arawak'                                       => 'arw',
    'arawkanjan'                                   => 'arn',
    "argon\ tainuk"                                => 'chn',
    'armenjan'                                     => 'hy',
    'aromanijan'                                   => 'rup',
    "artifijali\ ora"                              => 'art',
    'assamese'                                     => 'as',
    'asturian'                                     => 'ast',
    'atsam'                                        => 'cch',
    "australian\ english"                          => 'en_au',
    "austrian\ german"                             => 'de_at',
    'avani'                                        => 'jv',
    'avarik'                                       => 'av',
    'avestan'                                      => 'ae',
    'awadi'                                        => 'awa',
    'awajjan'                                      => 'haw',
    'awsa'                                         => 'ha',
    'awstronesjan'                                 => 'map',
    'balini'                                       => 'ban',
    "baltiku\ ora"                                 => 'bat',
    'balui'                                        => 'bal',
    'bambara'                                      => 'bm',
    'banda'                                        => 'bad',
    'bantu'                                        => 'bnt',
    'basa'                                         => 'bas',
    'bask'                                         => 'eu',
    'batak'                                        => 'btk',
    'baxkir'                                       => 'ba',
    'beber'                                        => 'ber',
    'beja'                                         => 'bej',
    'belarussu'                                    => 'be',
    'bemba'                                        => 'bem',
    'bengali'                                      => 'bn',
    'biari'                                        => 'bh',
    'bikol'                                        => 'bik',
    'bini'                                         => 'bin',
    'bislama'                                      => 'bi',
    'blin'                                         => 'byn',
    'blissymbols'                                  => 'zbl',
    'bojpuri'                                      => 'bho',
    "bokmahal\ norvei"                             => 'nb',
    'bosnijan'                                     => 'bs',
    'braj'                                         => 'bra',
    "brazilian\ portuguese"                        => 'pt_br',
    'brenton'                                      => 'br',
    "british\ english"                             => 'en_gb',
    'bugini'                                       => 'bug',
    'bulgaru'                                      => 'bg',
    'burjat'                                       => 'bua',
    'burmi'                                        => 'my',
    "canadian\ english"                            => 'en_ca',
    "canadian\ french"                             => 'fr_ca',
    "classical\ newari"                            => 'nwc',
    "classical\ syriac"                            => 'syc',
    "crimean\ turkish\ crimean\ tatar"             => 'crh',
    'dajak'                                        => 'day',
    'dakota'                                       => 'dak',
    'dani'                                         => 'da',
    'dargwa'                                       => 'dar',
    'delawerjan'                                   => 'del',
    'dinka'                                        => 'din',
    'divei'                                        => 'dv',
    'djula'                                        => 'dyu',
    'dogri'                                        => 'doi',
    'dogrib'                                       => 'dgr',
    'dongka'                                       => 'dz',
    "dravidjan\ ora"                               => 'dra',
    'dwala'                                        => 'dua',
    "eastern\ frisian"                             => 'frs',
    'ebrajk'                                       => 'he',
    'een'                                          => 'ce',
    'efik'                                         => 'efi',
    "eizzjan\ antik"                               => 'egy',
    'ek'                                           => 'cs',
    'ekajuk'                                       => 'eka',
    'elamit'                                       => 'elx',
    'enaga'                                        => 'zen',
    'erbo'                                         => 'grb',
    'erero'                                        => 'hz',
    'ermani'                                       => 'de',
    "ermani\ komuni\ sassonu\ komuni"              => 'nds',
    "ermaniku\ antik\ pulit"                       => 'goh',
    "ermaniku\ medjevali\ pulit"                   => 'gmh',
    "ermaniku\ ora"                                => 'gem',
    'erokij'                                       => 'chr',
    'erzya'                                        => 'myv',
    'esperanto'                                    => 'eo',
    'estonjan'                                     => 'et',
    'ewe'                                          => 'ee',
    'ewondo'                                       => 'ewo',
    'fang'                                         => 'fan',
    'fanti'                                        => 'fat',
    'fawri'                                        => 'fo',
    'feniju'                                       => 'phn',
    'fii'                                          => 'fj',
    "filippin\ ora"                                => 'phi',
    'filippino'                                    => 'fil',
    'finlandi'                                     => 'fi',
    "finno\ \ ugrijan"                             => 'fiu',
    'flemish'                                      => 'nl_be',
    'fon'                                          => 'fon',
    'frani'                                        => 'fr',
    "frani\ antik"                                 => 'fro',
    "frani\ medjevali"                             => 'frm',
    'frijan'                                       => 'fy',
    'frijuljan'                                    => 'fur',
    'fula'                                         => 'ff',
    'ga'                                           => 'gaa',
    'gajo'                                         => 'gay',
    'gallegjan'                                    => 'gl',
    "galliku\ skoi"                                => 'gd',
    'ganda'                                        => 'lg',
    'garbi'                                        => 'ar',
    'gbaja'                                        => 'gba',
    'geez'                                         => 'gez',
    'gilbertjan'                                   => 'gil',
    'gondi'                                        => 'gon',
    'gorontalo'                                    => 'gor',
    'gotiku'                                       => 'got',
    'grieg'                                        => 'el',
    "grieg\ antik\ to\ "                           => 'grc',
    'guarati'                                      => 'gu',
    'gwarani'                                      => 'gn',
    'gwiin'                                        => 'gwi',
    'haitian'                                      => 'ht',
    'hiligaynon'                                   => 'hil',
    'iba'                                          => 'chb',
    'iban'                                         => 'iba',
    "iberian\ portuguese"                          => 'pt_pt',
    "iberian\ spanish"                             => 'es_es',
    'ido'                                          => 'io',
    "iewa\ njana"                                  => 'ny',
    'igbo'                                         => 'ig',
    'ilandi'                                       => 'is',
    'iloko'                                        => 'ilo',
    'imaali'                                       => 'him',
    "inari\ sami"                                  => 'smn',
    'indeterminat'                                 => 'und',
    'indi'                                         => 'hi',
    "indjan\ ora"                                  => 'inc',
    "indjan\ talamerika\ ta\ fuq\ ora"             => 'nai',
    "indjan\ talamerika\ tisfel\ ora"              => 'sai',
    'indoewropew'                                  => 'ine',
    'indonejan'                                    => 'id',
    'ingaru'                                       => 'rom',
    'ingli'                                        => 'en',
    "ingli\ antik"                                 => 'ang',
    "ingli\ medjevali\ "                           => 'enm',
    'ingush'                                       => 'inh',
    'ini'                                          => 'zh',
    'interlingua'                                  => 'ia',
    'interlingue'                                  => 'ie',
    'inukitut'                                     => 'iu',
    'inupjak'                                      => 'ik',
    'io'                                           => 'ijo',
    'ipewjan'                                      => 'chp',
    'iranjan'                                      => 'ira',
    "iri\ motu"                                    => 'ho',
    'irlandi'                                      => 'ga',
    "irlandi\ antik\ sa\ l"                        => 'sga',
    "irlandi\ medjevali\ "                         => 'mga',
    'ittit'                                        => 'hit',
    'jakut'                                        => 'sah',
    'jao'                                          => 'yao',
    'japese'                                       => 'yap',
    'jiddix'                                       => 'yi',
    'jju'                                          => 'kaj',
    'joruba'                                       => 'yo',
    'kaak'                                         => 'kk',
    'kabardian'                                    => 'kbd',
    'kabuljan'                                     => 'kab',
    'kaddo'                                        => 'cad',
    'kain'                                         => 'kac',
    'kalallisut'                                   => 'kl',
    'kalmyk'                                       => 'xal',
    'kamba'                                        => 'kam',
    'kannada'                                      => 'kn',
    'kanuri'                                       => 'kr',
    'karachaybalkar'                               => 'krc',
    'karakalpak'                                   => 'kaa',
    'karelian'                                     => 'krl',
    'karen'                                        => 'kar',
    'karib'                                        => 'car',
    'kashubian'                                    => 'csb',
    'kasi'                                         => 'kha',
    'katalan'                                      => 'ca',
    'kawi'                                         => 'kaw',
    "kawkasu\ ora"                                 => 'cau',
    'kaxmiri'                                      => 'ks',
    "keltiku\ ora"                                 => 'cel',
    'kewa'                                         => 'qu',
    'kikuju'                                       => 'ki',
    'kimbundu'                                     => 'kmb',
    'kinjarwanda'                                  => 'rw',
    'kirgi'                                        => 'ky',
    'klingon'                                      => 'tlh',
    'kmer'                                         => 'km',
    'kojsan'                                       => 'khi',
    'komi'                                         => 'kv',
    'kongo'                                        => 'kg',
    'konkani'                                      => 'kok',
    'koptiku'                                      => 'cop',
    'korejan'                                      => 'ko',
    'korniku'                                      => 'kw',
    'koro'                                         => 'kfo',
    'korsiku'                                      => 'co',
    'kosrejan'                                     => 'kos',
    'kotani'                                       => 'kho',
    'kpelle'                                       => 'kpe',
    "kreoli\ u\ piini\ bbaat\ fuq\ ilfrani\ ora"   => 'cpf',
    "kreoli\ u\ piini\ bbaat\ fuq\ ilportugi\ ora" => 'cpp',
    "kreoli\ u\ piini\ bbaat\ fuq\ lingli\ ora"    => 'cpe',
    "kreoli\ u\ piini\ ora"                        => 'crp',
    'kriek'                                        => 'mus',
    'krij'                                         => 'cr',
    'kroat'                                        => 'hr',
    'kru'                                          => 'kro',
    'kuanyama'                                     => 'kj',
    'kumiku'                                       => 'kum',
    'kurdi'                                        => 'ku',
    'kurusk'                                       => 'kru',
    'kutenaj'                                      => 'kut',
    "kuxtiku\ ora"                                 => 'cus',
    'ladino'                                       => 'lad',
    'lamba'                                        => 'lam',
    'landa'                                        => 'lah',
    'lao'                                          => 'lo',
    'latin'                                        => 'la',
    "latvjan\ lettix"                              => 'lv',
    'legjan'                                       => 'lez',
    'letburgi'                                     => 'lb',
    'lhudigarbi'                                   => 'jrb',
    'lhudipersjan'                                 => 'jpr',
    'limburgish'                                   => 'li',
    'lingaljan'                                    => 'ln',
    "lingwa\ tassinjali"                           => 'sgn',
    "lingwi\ algonqwinjani"                        => 'alg',
    "lingwi\ amiki"                                => 'cmc',
    "lingwi\ apai"                                 => 'apa',
    "lingwi\ atabaskani"                           => 'ath',
    "lingwi\ awstraljani"                          => 'aus',
    "lingwi\ bamileke"                             => 'bai',
    "lingwi\ diversi"                              => 'mul',
    "lingwi\ irogwjani"                            => 'iro',
    "lingwi\ jupii"                                => 'ypk',
    "lingwi\ manobo"                               => 'mno',
    "lingwi\ nubjani"                              => 'nub',
    "lingwi\ ora"                                  => 'mis',
    "lingwi\ otomjani"                             => 'oto',
    "lingwi\ prakriti"                             => 'pra',
    "lingwi\ sorbjani"                             => 'wen',
    "lingwi\ suwjani"                              => 'sio',
    "lingwi\ talmunda"                             => 'mun',
    "lingwi\ wakaxani"                             => 'wak',
    'litwanjan'                                    => 'lt',
    'loi'                                          => 'loz',
    'lojban'                                       => 'jbo',
    "lower\ sorbian"                               => 'dsb',
    'lubakatanga'                                  => 'lu',
    'lubaluluwa'                                   => 'lua',
    "lule\ sami"                                   => 'smj',
    'lunda'                                        => 'lun',
    'luwa'                                         => 'luo',
    'luwisinu'                                     => 'lui',
    'luxaj'                                        => 'lus',
    'maduri'                                       => 'mad',
    'maedonjan'                                    => 'mk',
    'magai'                                        => 'mag',
    'majan'                                        => 'myn',
    'majtili'                                      => 'mai',
    'makasar'                                      => 'mak',
    'malagai'                                      => 'mg',
    'malajalam'                                    => 'ml',
    'malajan'                                      => 'ms',
    'malti'                                        => 'mt',
    'mandar'                                       => 'mdr',
    'mandingwan'                                   => 'man',
    'manipuri'                                     => 'mni',
    'manks'                                        => 'gv',
    'manurjan'                                     => 'mnc',
    'maori'                                        => 'mi',
    'marati'                                       => 'mr',
    'mari'                                         => 'chm',
    'marwari'                                      => 'mwr',
    'marxall'                                      => 'mh',
    'masaj'                                        => 'mas',
    'mende'                                        => 'men',
    'mikmek'                                       => 'mic',
    'minangkabaw'                                  => 'min',
    'mirandi'                                      => 'mwl',
    'moak'                                         => 'moh',
    'moksha'                                       => 'mdf',
    'moldavjan'                                    => 'mo',
    'mong'                                         => 'hmn',
    'mongo'                                        => 'lol',
    'mongoljan'                                    => 'mn',
    "monkmer\ ora"                                 => 'mkh',
    'morisyen'                                     => 'mfe',
    'mossi'                                        => 'mos',
    'navao'                                        => 'nv',
    'nawatil'                                      => 'nah',
    'nawuru'                                       => 'na',
    "ndebele\ ta\ fuq"                             => 'nd',
    "ndebele\ tisfel"                              => 'nr',
    'ndonga'                                       => 'ng',
    'neapolitan'                                   => 'nap',
    'nepali'                                       => 'ne',
    'newari'                                       => 'new',
    "nierjan\ \ kordofanjan"                       => 'nic',
    'nijas'                                        => 'nia',
    'nijuwejan'                                    => 'niu',
    'nilosaaram'                                   => 'ssa',
    'nima'                                         => 'nzi',
    "ninorsk\ norvei"                              => 'nn',
    'njamwei'                                      => 'nym',
    'njoro'                                        => 'nyo',
    'nko'                                          => 'nqo',
    "no\ linguistic\ content"                      => 'zxx',
    'nogai'                                        => 'nog',
    "northern\ frisian"                            => 'frr',
    'norvei'                                       => 'no',
    'nyankole'                                     => 'nyn',
    'oa'                                           => 'xh',
    'oibwa'                                        => 'oj',
    'oitan'                                        => 'oc',
    'olandi'                                       => 'nl',
    "olandi\ medjevali"                            => 'dum',
    'orija'                                        => 'or',
    'orjan'                                        => 'ka',
    "oromo\ afan"                                  => 'om',
    'osajan'                                       => 'osa',
    'ossettiku'                                    => 'os',
    'ostaw'                                        => 'cho',
    'palavi'                                       => 'pal',
    'palawjan'                                     => 'pau',
    'pali'                                         => 'pi',
    'pampamga'                                     => 'pam',
    'pangasinjan'                                  => 'pag',
    'papjamento'                                   => 'pap',
    "papwan\ ora"                                  => 'paa',
    'paxtun'                                       => 'ps',
    'persjan'                                      => 'fa',
    "persjan\ antik"                               => 'peo',
    'pollakk'                                      => 'pl',
    'ponpejan'                                     => 'pon',
    'portugi'                                      => 'pt',
    "provenzal\ antik\ sa\ l"                      => 'pro',
    'punabi'                                       => 'pa',
    'raastani'                                     => 'raj',
    'rapanwi'                                      => 'rap',
    'rarotongani'                                  => 'rar',
    'retoromanz'                                   => 'rm',
    "romanz\ ora"                                  => 'roa',
    'rumen'                                        => 'ro',
    'rundi'                                        => 'rn',
    'russu'                                        => 'ru',
    'salixan'                                      => 'sal',
    "sami\ languages\ other"                       => 'smi',
    "sami\ ta\ fuq"                                => 'se',
    'samojan'                                      => 'sm',
    'samritan'                                     => 'sam',
    'sandawe'                                      => 'sad',
    'sango'                                        => 'sg',
    'sanskrit'                                     => 'sa',
    'santali'                                      => 'sat',
    'sardinjan'                                    => 'sc',
    'saska'                                        => 'sas',
    'selkup'                                       => 'sel',
    'semitiku'                                     => 'sem',
    'serb'                                         => 'sr',
    'serbokroat'                                   => 'sh',
    'serer'                                        => 'srr',
    'sibwano'                                      => 'ceb',
    "sichuan\ yi"                                  => 'ii',
    'sicilian'                                     => 'scn',
    'sidamo'                                       => 'sid',
    'siksika'                                      => 'bla',
    'sinali'                                       => 'si',
    'sindi'                                        => 'sd',
    "sinotibetjani\ ora"                           => 'sit',
    'sirjan'                                       => 'syr',
    "skandinav\ antik"                             => 'non',
    'skoi'                                         => 'sco',
    "skolt\ sami"                                  => 'sms',
    'slav'                                         => 'den',
    "slavic\ other"                                => 'sla',
    "slaviku\ talknisja"                           => 'cu',
    'slovakk'                                      => 'sk',
    'sloven'                                       => 'sl',
    'sogdien'                                      => 'sog',
    'somali'                                       => 'so',
    'songaj'                                       => 'son',
    'soninke'                                      => 'snk',
    "soto\ ta\ fuq"                                => 'nso',
    "soto\ tisfel"                                 => 'st',
    "southern\ altai"                              => 'alt',
    "southern\ sami"                               => 'sma',
    'spanjol'                                      => 'es',
    "sranan\ tongo"                                => 'srn',
    'sukuma'                                       => 'suk',
    'sumerjan'                                     => 'sux',
    'sundani'                                      => 'su',
    'susu'                                         => 'sus',
    'svedi'                                        => 'sv',
    'swaili'                                       => 'sw',
    'swati'                                        => 'ss',
    "swiss\ french"                                => 'fr_ch',
    "swiss\ german"                                => 'gsw',
    "swiss\ high\ german"                          => 'de_ch',
    'tagalog'                                      => 'tl',
    "tai\ ora"                                     => 'tai',
    'taik'                                         => 'tg',
    'taitjan'                                      => 'ty',
    'tajlandi'                                     => 'th',
    'taljan'                                       => 'it',
    'tamaxek'                                      => 'tmh',
    'tamil'                                        => 'ta',
    'taroko'                                       => 'trv',
    'tatar'                                        => 'tt',
    'telugu'                                       => 'te',
    'tereno'                                       => 'ter',
    'tetum'                                        => 'tet',
    'tibetjan'                                     => 'bo',
    'tigre'                                        => 'tig',
    'tigrinja'                                     => 'ti',
    'timne'                                        => 'tem',
    'tiv'                                          => 'tiv',
    'tlingit'                                      => 'tli',
    "tok\ pisin"                                   => 'tpi',
    'tokelau'                                      => 'tkl',
    "tonga\ njasa"                                 => 'tog',
    "tongan\ gejjer\ ta\ tonga"                    => 'to',
    'tork'                                         => 'tr',
    "tork\ imperu\ ottoman"                        => 'ota',
    'tsonga'                                       => 'ts',
    'tumbuka'                                      => 'tum',
    "tupi\ languages"                              => 'tup',
    'turkmeni'                                     => 'tk',
    'tuvalu'                                       => 'tvl',
    'tuvinjan'                                     => 'tyv',
    'twi'                                          => 'tw',
    'tyap'                                         => 'kcg',
    'ubek'                                         => 'uz',
    'udmurt'                                       => 'udm',
    'ugaritiku'                                    => 'uga',
    'ukese'                                        => 'chk',
    'ukranjan'                                     => 'uk',
    'ulu'                                          => 'zu',
    'umbundu'                                      => 'umb',
    'ungeri'                                       => 'hu',
    'uni'                                          => 'zun',
    'upa'                                          => 'hup',
    "upper\ sorbian"                               => 'hsb',
    'urdu'                                         => 'ur',
    "us\ english"                                  => 'en_us',
    'uvax'                                         => 'cv',
    'vai'                                          => 'vai',
    'venda'                                        => 've',
    'vjetnami'                                     => 'vi',
    'volapuk'                                      => 'vo',
    'votik'                                        => 'vot',
    'walamo'                                       => 'wal',
    'walloon'                                      => 'wa',
    'wang'                                         => 'za',
    'waraj'                                        => 'war',
    'waxo'                                         => 'was',
    'welx'                                         => 'cy',
    'wigur'                                        => 'ug',
    'wolof'                                        => 'wo',
    'xajenn'                                       => 'chy',
    'xan'                                          => 'shn',
    'xona'                                         => 'sn',
    'zaza'                                         => 'zza',
    'zimxjan'                                      => 'tsi',
    'zwana'                                        => 'tn',
);

1;
