package Locales::DB::Language::lv;

# Auto generated from CLDR

$Locales::DB::Language::lv::VERSION = '0.01';

$Locales::DB::Language::lv::cldr_version = '1.7.1';

%Locales::DB::Language::lv::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Valoda\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Reģions\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nē\:ne\:n",
        'yesstr' => "jā\:ja\:j"
    },
);

%Locales::DB::Language::lv::code_to_name = (
    'aa'    => 'afāru',
    'ab'    => 'abhāzu',
    'ace'   => 'ačinu',
    'ach'   => 'ačolu',
    'ada'   => 'adangmu',
    'ady'   => 'adigu',
    'ae'    => 'avesta',
    'af'    => 'afrikandu',
    'afa'   => "afroaziātu\ valoda",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akanu',
    'akk'   => 'akadiešu',
    'ale'   => 'aleutu',
    'alg'   => "algonkinu\ valoda",
    'alt'   => 'dienvidaltajiešu',
    'am'    => 'amharu',
    'an'    => 'aragoniešu',
    'ang'   => 'senangļu',
    'anp'   => 'angika',
    'apa'   => "apaču\ valoda",
    'ar'    => 'arābu',
    'arc'   => 'aramiešu',
    'arn'   => 'araukāņu',
    'arp'   => 'arapahu',
    'art'   => "mākslīgā\ valoda",
    'arw'   => 'aravaku',
    'as'    => 'asamiešu',
    'ast'   => 'astūriešu',
    'ath'   => "atapasku\ valoda",
    'aus'   => "austrāliešu\ valoda",
    'av'    => 'avāru',
    'awa'   => 'avadhu',
    'ay'    => 'aimaru',
    'az'    => 'azerbaidžāņu',
    'ba'    => 'baškīru',
    'bad'   => 'bandu',
    'bai'   => "bamileku\ valoda",
    'bal'   => 'beludžu',
    'ban'   => 'baliešu',
    'bas'   => 'basu',
    'bat'   => "baltu\ valoda",
    'be'    => 'baltkrievu',
    'bej'   => 'bedžu',
    'bem'   => 'bembu',
    'ber'   => 'berberu',
    'bg'    => 'bulgāru',
    'bh'    => 'biharu',
    'bho'   => 'bhodžpūru',
    'bi'    => 'bišlamā',
    'bik'   => 'bikolu',
    'bin'   => 'binu',
    'bla'   => 'siksiku',
    'bm'    => 'bambaru',
    'bn'    => 'bengāļu',
    'bnt'   => 'bantu',
    'bo'    => 'tibetiešu',
    'br'    => 'bretoņu',
    'bra'   => 'bradžiešu',
    'bs'    => 'bosniešu',
    'btk'   => 'bataku',
    'bua'   => 'burjatu',
    'bug'   => 'bugu',
    'byn'   => 'bilinu',
    'ca'    => 'katalāņu',
    'cad'   => 'kadu',
    'cai'   => "Centrālamerikas\ indiāņu\ valoda",
    'car'   => 'karību',
    'cau'   => "kaukāziešu\ valoda",
    'cch'   => 'Atsam',
    'ce'    => 'čečenu',
    'ceb'   => 'sebuāņu',
    'cel'   => "ķeltu\ valoda",
    'ch'    => 'čamorru',
    'chb'   => 'čibču',
    'chg'   => 'džagatajs',
    'chk'   => 'čūku',
    'chm'   => 'mariešu',
    'chn'   => "činuku\ žargons",
    'cho'   => 'čoktavu',
    'chp'   => 'čipevaianu',
    'chr'   => 'irokēzu',
    'chy'   => 'šejenu',
    'cmc'   => "čamiešu\ valoda",
    'co'    => 'korsikāņu',
    'cop'   => 'koptu',
    'cpe'   => "angliskā\ kreoliskā\ vai\ pidžinvaloda",
    'cpf'   => "franciskā\ kreoliskā\ vai\ pidžinvaloda",
    'cpp'   => "portugāliskās\ kreoliskās\ vai\ pidžinvaloda",
    'cr'    => 'krī',
    'crh'   => "Krimas\ tatāru",
    'crp'   => "kreoliskā\ vai\ pidžinvaloda",
    'cs'    => 'čehu',
    'csb'   => 'kašubu',
    'cu'    => 'baznīcslāvu',
    'cus'   => "kušītu\ valoda",
    'cv'    => 'čuvašu',
    'cy'    => 'velsiešu',
    'da'    => 'dāņu',
    'dak'   => 'dakotu',
    'dar'   => 'dargu',
    'day'   => "bidayuh\ valoda",
    'de'    => 'vācu',
    'de_at' => "Austrijas\ vācu",
    'de_ch' => "Šveices\ augšvācu",
    'del'   => 'delavēru',
    'den'   => 'sleivu',
    'dgr'   => 'dogribu',
    'din'   => 'dinku',
    'doi'   => 'dogru',
    'dra'   => "dravīdu\ valoda",
    'dsb'   => 'lejassorbu',
    'dua'   => 'dualu',
    'dum'   => 'vidusholandiešu',
    'dv'    => 'maldīviešu',
    'dyu'   => 'diūlu',
    'dz'    => 'dzongke',
    'ee'    => 'evu',
    'efi'   => 'efiku',
    'egy'   => 'ēģiptiešu',
    'eka'   => 'ekadžuku',
    'el'    => 'grieķu',
    'elx'   => 'elamiešu',
    'en'    => 'angļu',
    'en_au' => "Austrālijas\ angļu",
    'en_ca' => "Kanādas\ angļu",
    'en_gb' => "British\ English",
    'en_us' => "angļu\ \(ASV\)",
    'enm'   => 'vidusangļu',
    'eo'    => 'esperanto',
    'es'    => 'spāņu',
    'es_es' => "ibēriešu\ spāņu",
    'et'    => 'igauņu',
    'eu'    => 'basku',
    'ewo'   => 'evondu',
    'fa'    => 'persiešu',
    'fan'   => 'fangu',
    'fat'   => 'fantu',
    'ff'    => 'fulu',
    'fi'    => 'somu',
    'fil'   => 'filipīniešu',
    'fiu'   => "somugru\ valoda",
    'fj'    => 'fidžiešu',
    'fo'    => 'fēru',
    'fon'   => 'fonu',
    'fr'    => 'franču',
    'fr_ca' => "Kanādas\ franču",
    'fr_ch' => "Šveices\ franču",
    'frm'   => 'vidusfranču',
    'fro'   => 'senfranču',
    'frr'   => 'ziemeļfrīzu',
    'frs'   => 'austrumfrīzu',
    'fur'   => 'friūlu',
    'fy'    => 'rietumfrīzu',
    'ga'    => 'īru',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaju',
    'gd'    => 'gēlu',
    'gem'   => "ģermāņu\ valodas",
    'gez'   => 'gēzu',
    'gil'   => 'kiribatiešu',
    'gl'    => 'galisiešu',
    'gmh'   => 'vidusaugšvācu',
    'gn'    => 'gvaranu',
    'goh'   => 'senaugšvācu',
    'gon'   => "gondu\ valodas",
    'gor'   => 'gorontalu',
    'got'   => 'gotu',
    'grb'   => 'grebo',
    'grc'   => 'sengrieķu',
    'gsw'   => "Šveices\ vācu",
    'gu'    => 'gudžaratu',
    'gv'    => 'meniešu',
    'gwi'   => 'kučinu',
    'ha'    => 'hausu',
    'hai'   => 'haidu',
    'haw'   => 'havajiešu',
    'he'    => 'ivrits',
    'hi'    => 'hindi',
    'hil'   => 'hiligainonu',
    'him'   => 'himačali',
    'hit'   => 'hetu',
    'hmn'   => 'hmongu',
    'ho'    => 'hirimotu',
    'hr'    => 'horvātu',
    'hsb'   => 'augšsorbu',
    'ht'    => 'haitiešu',
    'hu'    => 'ungāru',
    'hup'   => 'hupu',
    'hy'    => 'armēņu',
    'hz'    => 'hereru',
    'ia'    => 'interlingva',
    'iba'   => 'ibanu',
    'id'    => 'indonēziešu',
    'ie'    => 'interlingve',
    'ig'    => 'igbo',
    'ii'    => "Sičuaņas\ ji",
    'ijo'   => 'idžbu',
    'ik'    => 'inupiaku',
    'ilo'   => 'iloku',
    'inc'   => "indoāriešu\ valoda",
    'ine'   => "indoeiropiešu\ valoda",
    'inh'   => 'ingušu',
    'io'    => 'ido',
    'ira'   => "irāņu\ valodas",
    'iro'   => "irokēzu\ valoda",
    'is'    => 'īslandiešu',
    'it'    => 'itāliešu',
    'iu'    => 'inuītu',
    'ja'    => 'japāņu',
    'jbo'   => 'ložbans',
    'jpr'   => 'jūdpersiešu',
    'jrb'   => 'jūdarābu',
    'jv'    => 'javiešu',
    'ka'    => 'gruzīnu',
    'kaa'   => 'karakalpaku',
    'kab'   => 'kabilu',
    'kac'   => 'kačinu',
    'kaj'   => 'Jju',
    'kam'   => 'kambu',
    'kar'   => 'karenu',
    'kaw'   => 'kāvi',
    'kbd'   => 'kabardiešu',
    'kcg'   => 'Tyap',
    'kfo'   => 'koru',
    'kg'    => 'kongu',
    'kha'   => 'khasu',
    'khi'   => "hojsanu\ valoda",
    'kho'   => 'hotaniešu',
    'ki'    => 'kikuju',
    'kj'    => 'kvaņamu',
    'kk'    => 'kazahu',
    'kl'    => 'grenlandiešu',
    'km'    => 'khmeru',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannadu',
    'ko'    => 'korejiešu',
    'kok'   => 'konkanu',
    'kos'   => 'kosrājiešu',
    'kpe'   => 'kpellu',
    'kr'    => 'kanuru',
    'krc'   => "karačaju\ un\ balkāru",
    'krl'   => 'karēļu',
    'kro'   => 'krū',
    'kru'   => 'kuruhu',
    'ks'    => 'kašmiriešu',
    'ku'    => 'kurdu',
    'kum'   => 'kumiku',
    'kut'   => 'kutenaju',
    'kv'    => 'komiešu',
    'kw'    => 'korniešu',
    'ky'    => 'kirgīzu',
    'la'    => 'latīņu',
    'lad'   => 'ladino',
    'lah'   => 'landu',
    'lam'   => 'lambu',
    'lb'    => 'luksemburgiešu',
    'lez'   => 'lezgīnu',
    'lg'    => 'gandu',
    'li'    => 'limburgiešu',
    'ln'    => 'lingala',
    'lo'    => 'laosiešu',
    'lol'   => 'mongu',
    'loz'   => 'lozu',
    'lt'    => 'lietuviešu',
    'lu'    => 'lubakatanga',
    'lua'   => 'lubalulva',
    'lui'   => 'luisenu',
    'lun'   => 'lundu',
    'luo'   => 'luo',
    'lus'   => 'lušeju',
    'lv'    => 'latviešu',
    'mad'   => 'maduriešu',
    'mag'   => 'magahiešu',
    'mai'   => 'maithili',
    'mak'   => 'makasaru',
    'man'   => 'mandingu',
    'map'   => "austronēziešu\ valoda",
    'mas'   => 'masaju',
    'mdf'   => 'mokšu',
    'mdr'   => 'mandaru',
    'men'   => 'mendu',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasu',
    'mga'   => 'vidusīru',
    'mh'    => 'māršaliešu',
    'mi'    => 'maoru',
    'mic'   => 'mikmaku',
    'min'   => 'minangkabavu',
    'mis'   => "dažādas\ valodas",
    'mk'    => 'maķedoniešu',
    'mkh'   => "monkhmeru\ valoda",
    'ml'    => 'malajalu',
    'mn'    => 'mongoļu',
    'mnc'   => 'mandžūru',
    'mni'   => 'manipūru',
    'mno'   => "manobu\ valoda",
    'mo'    => 'moldāvu',
    'moh'   => 'mohauku',
    'mos'   => 'mosu',
    'mr'    => 'maratu',
    'ms'    => 'malajiešu',
    'mt'    => 'maltiešu',
    'mul'   => "vairākas\ valodas",
    'mun'   => "mundu\ valoda",
    'mus'   => 'krīku',
    'mwl'   => 'mirandiešu',
    'mwr'   => 'marvaru',
    'my'    => 'birmiešu',
    'myn'   => "maiju\ valoda",
    'myv'   => 'erzju',
    'na'    => 'nauruiešu',
    'nah'   => 'navatlu',
    'nai'   => "Ziemeļamerikas\ indiāņu\ valoda",
    'nap'   => 'neapoliešu',
    'nb'    => "norvēģu\ bukmols",
    'nd'    => 'ziemeļndebelu',
    'nds'   => 'lejasvācu',
    'ne'    => 'nepāliešu',
    'new'   => 'nevaru',
    'ng'    => 'ndongu',
    'nia'   => 'njasu',
    'nic'   => "nigēriešu\-kordofāņu\ valoda",
    'niu'   => 'niuāņu',
    'nl'    => 'holandiešu',
    'nl_be' => 'flāmu',
    'nn'    => 'jaunnorvēģu',
    'no'    => 'norvēģu',
    'nog'   => 'nogaju',
    'non'   => 'sennorvēģu',
    'nqo'   => "n\-ko",
    'nr'    => 'dienvidndebelu',
    'nso'   => 'ziemeļsotu',
    'nub'   => "nūbiešu\ valodas",
    'nv'    => 'navahu',
    'nwc'   => "klasiskā\ nevaru",
    'ny'    => 'čičeva',
    'nym'   => 'ņamvezu',
    'nyn'   => 'ņankolu',
    'nyo'   => 'ņoru',
    'nzi'   => 'nzemu',
    'oc'    => 'oksitāņu',
    'oj'    => 'odžibvu',
    'om'    => 'oromu',
    'or'    => 'orisiešu',
    'os'    => 'osetīnu',
    'osa'   => 'važāžu',
    'ota'   => "turku\ osmaņu",
    'oto'   => "otomu\ valoda",
    'pa'    => 'pandžabu',
    'paa'   => "papuasu\ valoda",
    'pag'   => 'pangasinanu',
    'pal'   => 'pehlevi',
    'pam'   => 'pampanganu',
    'pap'   => 'papjamento',
    'pau'   => 'palaviešu',
    'peo'   => 'senpersu',
    'phi'   => "filipīniešu\ valoda",
    'phn'   => 'feniķiešu',
    'pi'    => 'pāli',
    'pl'    => 'poļu',
    'pon'   => 'ponapiešu',
    'pra'   => "prākrita\ valoda",
    'pro'   => 'senprovansiešu',
    'ps'    => 'puštu',
    'pt'    => 'portugāļu',
    'pt_br' => "Brazīlijas\ portugāļu",
    'pt_pt' => "ibēriešu\ portugāļu",
    'qu'    => 'kečvu',
    'raj'   => 'radžastāņu',
    'rap'   => 'rapanuju',
    'rar'   => 'rarotongiešu',
    'rm'    => 'retoromāņu',
    'rn'    => 'rundu',
    'ro'    => 'rumāņu',
    'roa'   => "romāņu\ valoda",
    'rom'   => 'čigānu',
    'ru'    => 'krievu',
    'rup'   => 'aromūnu',
    'rw'    => 'kiņaruanda',
    'sa'    => 'sanskrits',
    'sad'   => 'sandavu',
    'sah'   => 'jakutu',
    'sai'   => "Dienvidamerikas\ indiāņu\ valoda",
    'sal'   => "sališu\ valoda",
    'sam'   => "samārijas\ aramiešu",
    'sas'   => 'sasaku',
    'sat'   => 'santalu',
    'sc'    => 'sardīniešu',
    'scn'   => 'sicīliešu',
    'sco'   => 'skotu',
    'sd'    => 'sindhu',
    'se'    => 'ziemeļsāmu',
    'sel'   => 'selkupu',
    'sem'   => "semītu\ valoda",
    'sg'    => 'sangu',
    'sga'   => 'senīru',
    'sgn'   => "zīmju\ valodas",
    'sh'    => "serbu\-horvātu",
    'shn'   => 'šanu',
    'si'    => 'singāļu',
    'sid'   => 'sidamu',
    'sio'   => "siū\ valodas",
    'sit'   => "sinotibetiešu\ valoda",
    'sk'    => 'slovāku',
    'sl'    => 'slovēņu',
    'sla'   => 'slāvu',
    'sm'    => 'samoāņu',
    'sma'   => 'dienvidsāmu',
    'smi'   => "sāmu\ valoda",
    'smj'   => "Luleo\ sāmu",
    'smn'   => "Inari\ sāmu",
    'sms'   => 'skoltsāmu',
    'sn'    => 'šonu',
    'snk'   => 'soninku',
    'so'    => 'somāļu',
    'sog'   => 'sogdiešu',
    'son'   => 'songaju',
    'sq'    => 'albāņu',
    'sr'    => 'serbu',
    'srn'   => 'sranantogo',
    'srr'   => 'serēru',
    'ss'    => 'svatu',
    'ssa'   => "nīlas\-sahāras\ valoda",
    'st'    => 'sesoto',
    'su'    => 'sundaniešu',
    'suk'   => 'sukumu',
    'sus'   => 'susu',
    'sux'   => 'šumeru',
    'sv'    => 'zviedru',
    'sw'    => 'svahili',
    'syc'   => "klasiskā\ sīriešu",
    'syr'   => 'sīriešu',
    'ta'    => 'tamilu',
    'tai'   => "taju\ valoda",
    'te'    => 'telugu',
    'tem'   => 'temnu',
    'ter'   => 'tereno',
    'tet'   => 'tetumu',
    'tg'    => 'tadžiku',
    'th'    => 'taju',
    'ti'    => 'tigrinja',
    'tig'   => 'tigru',
    'tiv'   => 'tivu',
    'tk'    => 'turkmēņu',
    'tkl'   => 'tokelaviešu',
    'tl'    => 'tagalu',
    'tlh'   => 'klingoņu',
    'tli'   => 'tlinkitu',
    'tmh'   => 'tuaregu',
    'tn'    => 'cvanu',
    'to'    => 'tongu',
    'tog'   => "Njasas\ tongu",
    'tpi'   => 'tokpisins',
    'tr'    => 'turku',
    'trv'   => 'Taroko',
    'ts'    => 'congu',
    'tsi'   => 'cimšiāņu',
    'tt'    => 'tatāru',
    'tum'   => 'tumbuku',
    'tup'   => "tupu\ valodas",
    'tut'   => "altajiešu\ valoda",
    'tvl'   => 'tuvaliešu',
    'tw'    => 'tvī',
    'ty'    => 'taitiešu',
    'tyv'   => 'tuviešu',
    'udm'   => 'udmurtu',
    'ug'    => 'uiguru',
    'uga'   => 'ugaritiešu',
    'uk'    => 'ukraiņu',
    'umb'   => 'umbundu',
    'und'   => "nezināma\ vai\ nederīga\ valoda",
    'ur'    => 'urdu',
    'uz'    => 'uzbeku',
    'vai'   => 'vaju',
    've'    => 'vendu',
    'vi'    => 'vjetnamiešu',
    'vo'    => 'volapiks',
    'vot'   => 'votu',
    'wa'    => 'valoņu',
    'wak'   => "vakašu\ valoda",
    'wal'   => 'valamu',
    'war'   => 'varaju',
    'was'   => 'vašo',
    'wen'   => 'sorbu',
    'wo'    => 'volofu',
    'xal'   => 'kalmiku',
    'xh'    => 'khosu',
    'yao'   => 'jao',
    'yap'   => 'japiešu',
    'yi'    => 'jidišs',
    'yo'    => 'jorubu',
    'ypk'   => "jupiku\ valoda",
    'za'    => 'džuanu',
    'zap'   => 'sapoteku',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenagu',
    'zh'    => 'ķīniešu',
    'znd'   => 'zandē',
    'zu'    => 'zulu',
    'zun'   => 'zunju',
    'zxx'   => "Bez\ lingvistiska\ satura",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::lv::name_to_code = (
    'abhzu'                                    => 'ab',
    'adangmu'                                  => 'ada',
    'adigu'                                    => 'ady',
    'afrihili'                                 => 'afh',
    'afrikandu'                                => 'af',
    "afroazitu\ valoda"                        => 'afa',
    'afru'                                     => 'aa',
    'aimaru'                                   => 'ay',
    'ainu'                                     => 'ain',
    'akadieu'                                  => 'akk',
    'akanu'                                    => 'ak',
    'albu'                                     => 'sq',
    'aleutu'                                   => 'ale',
    "algonkinu\ valoda"                        => 'alg',
    "altajieu\ valoda"                         => 'tut',
    'amharu'                                   => 'am',
    "amieu\ valoda"                            => 'cmc',
    'amorru'                                   => 'ch',
    'amvezu'                                   => 'nym',
    'angika'                                   => 'anp',
    "anglisk\ kreolisk\ vai\ pidinvaloda"      => 'cpe',
    'angu'                                     => 'en',
    "angu\ asv"                                => 'en_us',
    'ankolu'                                   => 'nyn',
    'anu'                                      => 'shn',
    'aolu'                                     => 'ach',
    "apau\ valoda"                             => 'apa',
    'aragonieu'                                => 'an',
    'aramieu'                                  => 'arc',
    'arapahu'                                  => 'arp',
    'arauku'                                   => 'arn',
    'aravaku'                                  => 'arw',
    'arbu'                                     => 'ar',
    'armu'                                     => 'hy',
    'aromnu'                                   => 'rup',
    'asamieu'                                  => 'as',
    'astrieu'                                  => 'ast',
    "atapasku\ valoda"                         => 'ath',
    'atsam'                                    => 'cch',
    'augsorbu'                                 => 'hsb',
    "austrijas\ vcu"                           => 'de_at',
    "austrlieu\ valoda"                        => 'aus',
    "austrlijas\ angu"                         => 'en_au',
    "austronzieu\ valoda"                      => 'map',
    'austrumfrzu'                              => 'frs',
    'avadhu'                                   => 'awa',
    'avesta'                                   => 'ae',
    'avru'                                     => 'av',
    'azerbaidu'                                => 'az',
    'bakru'                                    => 'ba',
    'balieu'                                   => 'ban',
    'baltkrievu'                               => 'be',
    "baltu\ valoda"                            => 'bat',
    'bambaru'                                  => 'bm',
    "bamileku\ valoda"                         => 'bai',
    'bandu'                                    => 'bad',
    'bantu'                                    => 'bnt',
    'basku'                                    => 'eu',
    'basu'                                     => 'bas',
    'bataku'                                   => 'btk',
    'bazncslvu'                                => 'cu',
    'bedu'                                     => 'bej',
    'beludu'                                   => 'bal',
    'bembu'                                    => 'bem',
    'bengu'                                    => 'bn',
    'berberu'                                  => 'ber',
    "bez\ lingvistiska\ satura"                => 'zxx',
    'bhodpru'                                  => 'bho',
    "bidayuh\ valoda"                          => 'day',
    'biharu'                                   => 'bh',
    'bikolu'                                   => 'bik',
    'bilam'                                    => 'bi',
    'bilinu'                                   => 'byn',
    'binu'                                     => 'bin',
    'birmieu'                                  => 'my',
    'blissymbols'                              => 'zbl',
    'bosnieu'                                  => 'bs',
    'bradieu'                                  => 'bra',
    "brazlijas\ portugu"                       => 'pt_br',
    'bretou'                                   => 'br',
    "british\ english"                         => 'en_gb',
    'bugu'                                     => 'bug',
    'bulgru'                                   => 'bg',
    'burjatu'                                  => 'bua',
    "centrlamerikas\ indiu\ valoda"            => 'cai',
    'cimiu'                                    => 'tsi',
    'congu'                                    => 'ts',
    'cvanu'                                    => 'tn',
    "dadas\ valodas"                           => 'mis',
    'dagatajs'                                 => 'chg',
    'dakotu'                                   => 'dak',
    'dargu'                                    => 'dar',
    'delavru'                                  => 'del',
    'dienvidaltajieu'                          => 'alt',
    "dienvidamerikas\ indiu\ valoda"           => 'sai',
    'dienvidndebelu'                           => 'nr',
    'dienvidsmu'                               => 'sma',
    'dilu'                                     => 'dyu',
    'dinku'                                    => 'din',
    'dogribu'                                  => 'dgr',
    'dogru'                                    => 'doi',
    "dravdu\ valoda"                           => 'dra',
    'du'                                       => 'da',
    'dualu'                                    => 'dua',
    'duanu'                                    => 'za',
    'dzongke'                                  => 'dz',
    'eenu'                                     => 'ce',
    'efiku'                                    => 'efi',
    'ehu'                                      => 'cs',
    'ejenu'                                    => 'chy',
    'ekaduku'                                  => 'eka',
    'elamieu'                                  => 'elx',
    "eltu\ valoda"                             => 'cel',
    "ermu\ valodas"                            => 'gem',
    'erzju'                                    => 'myv',
    'esperanto'                                => 'eo',
    'evondu'                                   => 'ewo',
    'evu'                                      => 'ee',
    'fangu'                                    => 'fan',
    'fantu'                                    => 'fat',
    'feniieu'                                  => 'phn',
    'fidieu'                                   => 'fj',
    'filipnieu'                                => 'fil',
    "filipnieu\ valoda"                        => 'phi',
    'flmu'                                     => 'nl_be',
    'fonu'                                     => 'fon',
    "francisk\ kreolisk\ vai\ pidinvaloda"     => 'cpf',
    'franu'                                    => 'fr',
    'frilu'                                    => 'fur',
    'fru'                                      => 'fo',
    'fulu'                                     => 'ff',
    'ga'                                       => 'gaa',
    'gajo'                                     => 'gay',
    'galisieu'                                 => 'gl',
    'gandu'                                    => 'lg',
    'gbaju'                                    => 'gba',
    'glu'                                      => 'gd',
    "gondu\ valodas"                           => 'gon',
    'gorontalu'                                => 'gor',
    'gotu'                                     => 'got',
    'grebo'                                    => 'grb',
    'grenlandieu'                              => 'kl',
    'grieu'                                    => 'el',
    'gruznu'                                   => 'ka',
    'gudaratu'                                 => 'gu',
    'gvaranu'                                  => 'gn',
    'gzu'                                      => 'gez',
    'haidu'                                    => 'hai',
    'haitieu'                                  => 'ht',
    'hausu'                                    => 'ha',
    'havajieu'                                 => 'haw',
    'hereru'                                   => 'hz',
    'hetu'                                     => 'hit',
    'hiligainonu'                              => 'hil',
    'himaali'                                  => 'him',
    'hindi'                                    => 'hi',
    'hirimotu'                                 => 'ho',
    'hmongu'                                   => 'hmn',
    "hojsanu\ valoda"                          => 'khi',
    'holandieu'                                => 'nl',
    'horvtu'                                   => 'hr',
    'hotanieu'                                 => 'kho',
    'hupu'                                     => 'hup',
    'ibanu'                                    => 'iba',
    "ibrieu\ portugu"                          => 'pt_pt',
    "ibrieu\ spu"                              => 'es_es',
    'ibu'                                      => 'chb',
    'idbu'                                     => 'ijo',
    'ido'                                      => 'io',
    'ieva'                                     => 'ny',
    'igauu'                                    => 'et',
    'igbo'                                     => 'ig',
    'ignu'                                     => 'rom',
    'iloku'                                    => 'ilo',
    "inari\ smu"                               => 'smn',
    "indoeiropieu\ valoda"                     => 'ine',
    'indonzieu'                                => 'id',
    "indorieu\ valoda"                         => 'inc',
    'inguu'                                    => 'inh',
    'interlingva'                              => 'ia',
    'interlingve'                              => 'ie',
    "inuku\ argons"                            => 'chn',
    'inupiaku'                                 => 'ik',
    'inutu'                                    => 'iu',
    'ipevaianu'                                => 'chp',
    'iptieu'                                   => 'egy',
    'irokzu'                                   => 'chr',
    "irokzu\ valoda"                           => 'iro',
    "iru\ valodas"                             => 'ira',
    'itlieu'                                   => 'it',
    'ivrits'                                   => 'he',
    'jakutu'                                   => 'sah',
    'jao'                                      => 'yao',
    'japieu'                                   => 'yap',
    'japu'                                     => 'ja',
    'jaunnorvu'                                => 'nn',
    'javieu'                                   => 'jv',
    'jdarbu'                                   => 'jrb',
    'jdpersieu'                                => 'jpr',
    'jidis'                                    => 'yi',
    'jju'                                      => 'kaj',
    'jorubu'                                   => 'yo',
    "jupiku\ valoda"                           => 'ypk',
    'kabardieu'                                => 'kbd',
    'kabilu'                                   => 'kab',
    'kadu'                                     => 'cad',
    'kainu'                                    => 'kac',
    'kalmiku'                                  => 'xal',
    'kambu'                                    => 'kam',
    'kamirieu'                                 => 'ks',
    "kandas\ angu"                             => 'en_ca',
    "kandas\ franu"                            => 'fr_ca',
    'kannadu'                                  => 'kn',
    'kanuru'                                   => 'kr',
    "karaaju\ un\ balkru"                      => 'krc',
    'karakalpaku'                              => 'kaa',
    'karbu'                                    => 'car',
    'karenu'                                   => 'kar',
    'karu'                                     => 'krl',
    'katalu'                                   => 'ca',
    'kaubu'                                    => 'csb',
    "kaukzieu\ valoda"                         => 'cau',
    'kazahu'                                   => 'kk',
    'kevu'                                     => 'qu',
    'khasu'                                    => 'kha',
    'khmeru'                                   => 'km',
    'khosu'                                    => 'xh',
    'kiaruanda'                                => 'rw',
    'kikuju'                                   => 'ki',
    'kimbundu'                                 => 'kmb',
    'kirgzu'                                   => 'ky',
    'kiribatieu'                               => 'gil',
    "klasisk\ nevaru"                          => 'nwc',
    "klasisk\ srieu"                           => 'syc',
    'klingou'                                  => 'tlh',
    'komieu'                                   => 'kv',
    'kongu'                                    => 'kg',
    'konkanu'                                  => 'kok',
    'koptu'                                    => 'cop',
    'korejieu'                                 => 'ko',
    'kornieu'                                  => 'kw',
    'korsiku'                                  => 'co',
    'koru'                                     => 'kfo',
    'kosrjieu'                                 => 'kos',
    'kpellu'                                   => 'kpe',
    'kr'                                       => 'kro',
    "kreolisk\ vai\ pidinvaloda"               => 'crp',
    'krievu'                                   => 'ru',
    "krimas\ tatru"                            => 'crh',
    'krku'                                     => 'mus',
    'ku'                                       => 'chk',
    'kuinu'                                    => 'gwi',
    'kumiku'                                   => 'kum',
    'kurdu'                                    => 'ku',
    'kuruhu'                                   => 'kru',
    'kutenaju'                                 => 'kut',
    "kutu\ valoda"                             => 'cus',
    'kvaamu'                                   => 'kj',
    'kvi'                                      => 'kaw',
    'ladino'                                   => 'lad',
    'lambu'                                    => 'lam',
    'landu'                                    => 'lah',
    'laosieu'                                  => 'lo',
    'latu'                                     => 'la',
    'latvieu'                                  => 'lv',
    'lejassorbu'                               => 'dsb',
    'lejasvcu'                                 => 'nds',
    'lezgnu'                                   => 'lez',
    'lietuvieu'                                => 'lt',
    'limburgieu'                               => 'li',
    'lingala'                                  => 'ln',
    'lobans'                                   => 'jbo',
    'lozu'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalulva'                                => 'lua',
    'lueju'                                    => 'lus',
    'luisenu'                                  => 'lui',
    'luksemburgieu'                            => 'lb',
    "luleo\ smu"                               => 'smj',
    'lundu'                                    => 'lun',
    'luo'                                      => 'luo',
    'madurieu'                                 => 'mad',
    'maedonieu'                                => 'mk',
    'magahieu'                                 => 'mag',
    "maiju\ valoda"                            => 'myn',
    'maithili'                                 => 'mai',
    'makasaru'                                 => 'mak',
    'malagasu'                                 => 'mg',
    'malajalu'                                 => 'ml',
    'malajieu'                                 => 'ms',
    'maldvieu'                                 => 'dv',
    'maltieu'                                  => 'mt',
    'mandaru'                                  => 'mdr',
    'mandingu'                                 => 'man',
    'mandru'                                   => 'mnc',
    'manipru'                                  => 'mni',
    "manobu\ valoda"                           => 'mno',
    'maoru'                                    => 'mi',
    'maratu'                                   => 'mr',
    'marieu'                                   => 'chm',
    'marvaru'                                  => 'mwr',
    'masaju'                                   => 'mas',
    'mendu'                                    => 'men',
    'menieu'                                   => 'gv',
    'mikmaku'                                  => 'mic',
    'minangkabavu'                             => 'min',
    'mirandieu'                                => 'mwl',
    "mkslg\ valoda"                            => 'art',
    'mohauku'                                  => 'moh',
    'moku'                                     => 'mdf',
    'moldvu'                                   => 'mo',
    'mongou'                                   => 'mn',
    'mongu'                                    => 'lol',
    "monkhmeru\ valoda"                        => 'mkh',
    'morisyen'                                 => 'mfe',
    'mosu'                                     => 'mos',
    'mralieu'                                  => 'mh',
    "mundu\ valoda"                            => 'mun',
    'nauruieu'                                 => 'na',
    'navahu'                                   => 'nv',
    'navatlu'                                  => 'nah',
    "nbieu\ valodas"                           => 'nub',
    'ndongu'                                   => 'ng',
    'neapolieu'                                => 'nap',
    'neplieu'                                  => 'ne',
    'nevaru'                                   => 'new',
    "nezinma\ vai\ nederga\ valoda"            => 'und',
    'nieu'                                     => 'zh',
    "nigrieukordofu\ valoda"                   => 'nic',
    'niuu'                                     => 'niu',
    "njasas\ tongu"                            => 'tog',
    'njasu'                                    => 'nia',
    'nko'                                      => 'nqo',
    "nlassahras\ valoda"                       => 'ssa',
    'nogaju'                                   => 'nog',
    'norvu'                                    => 'no',
    "norvu\ bukmols"                           => 'nb',
    'nzemu'                                    => 'nzi',
    'odibvu'                                   => 'oj',
    'oksitu'                                   => 'oc',
    'oktavu'                                   => 'cho',
    'onu'                                      => 'sn',
    'orisieu'                                  => 'or',
    'oromu'                                    => 'om',
    'oru'                                      => 'nyo',
    'osetnu'                                   => 'os',
    "otomu\ valoda"                            => 'oto',
    'palavieu'                                 => 'pau',
    'pampanganu'                               => 'pam',
    'pandabu'                                  => 'pa',
    'pangasinanu'                              => 'pag',
    'papjamento'                               => 'pap',
    "papuasu\ valoda"                          => 'paa',
    'pehlevi'                                  => 'pal',
    'persieu'                                  => 'fa',
    'pli'                                      => 'pi',
    'ponapieu'                                 => 'pon',
    "portuglisks\ kreolisks\ vai\ pidinvaloda" => 'cpp',
    'portugu'                                  => 'pt',
    'pou'                                      => 'pl',
    "prkrita\ valoda"                          => 'pra',
    'putu'                                     => 'ps',
    'radastu'                                  => 'raj',
    'rapanuju'                                 => 'rap',
    'rarotongieu'                              => 'rar',
    'retoromu'                                 => 'rm',
    'rietumfrzu'                               => 'fy',
    "romu\ valoda"                             => 'roa',
    'ru'                                       => 'ga',
    'rumu'                                     => 'ro',
    'rundu'                                    => 'rn',
    "saliu\ valoda"                            => 'sal',
    'samou'                                    => 'sm',
    "samrijas\ aramieu"                        => 'sam',
    'sandavu'                                  => 'sad',
    'sangu'                                    => 'sg',
    'sanskrits'                                => 'sa',
    'santalu'                                  => 'sat',
    'sapoteku'                                 => 'zap',
    'sardnieu'                                 => 'sc',
    'sasaku'                                   => 'sas',
    'sebuu'                                    => 'ceb',
    'selkupu'                                  => 'sel',
    "semtu\ valoda"                            => 'sem',
    'senangu'                                  => 'ang',
    'senaugvcu'                                => 'goh',
    'senfranu'                                 => 'fro',
    'sengrieu'                                 => 'grc',
    'sennorvu'                                 => 'non',
    'senpersu'                                 => 'peo',
    'senprovansieu'                            => 'pro',
    'senru'                                    => 'sga',
    'serbu'                                    => 'sr',
    'serbuhorvtu'                              => 'sh',
    'serru'                                    => 'srr',
    'sesoto'                                   => 'st',
    "si\ valodas"                              => 'sio',
    'siclieu'                                  => 'scn',
    'sidamu'                                   => 'sid',
    'siksiku'                                  => 'bla',
    'sindhu'                                   => 'sd',
    'singu'                                    => 'si',
    "sinotibetieu\ valoda"                     => 'sit',
    "siuaas\ ji"                               => 'ii',
    'skoltsmu'                                 => 'sms',
    'skotu'                                    => 'sco',
    'slandieu'                                 => 'is',
    'sleivu'                                   => 'den',
    'slovku'                                   => 'sk',
    'slovu'                                    => 'sl',
    'slvu'                                     => 'sla',
    "smu\ valoda"                              => 'smi',
    'sogdieu'                                  => 'sog',
    'somu'                                     => 'so',
    "somugru\ valoda"                          => 'fiu',
    'songaju'                                  => 'son',
    'soninku'                                  => 'snk',
    'sorbu'                                    => 'wen',
    'spu'                                      => 'es',
    'sranantogo'                               => 'srn',
    'srieu'                                    => 'syr',
    'sukumu'                                   => 'suk',
    'sundanieu'                                => 'su',
    'susu'                                     => 'sus',
    'svahili'                                  => 'sw',
    'svatu'                                    => 'ss',
    'tadiku'                                   => 'tg',
    'tagalu'                                   => 'tl',
    'taitieu'                                  => 'ty',
    'taju'                                     => 'th',
    "taju\ valoda"                             => 'tai',
    'tamilu'                                   => 'ta',
    'taroko'                                   => 'trv',
    'tatru'                                    => 'tt',
    'telugu'                                   => 'te',
    'temnu'                                    => 'tem',
    'tereno'                                   => 'ter',
    'tetumu'                                   => 'tet',
    'tibetieu'                                 => 'bo',
    'tigrinja'                                 => 'ti',
    'tigru'                                    => 'tig',
    'tivu'                                     => 'tiv',
    'tlinkitu'                                 => 'tli',
    'tokelavieu'                               => 'tkl',
    'tokpisins'                                => 'tpi',
    'tongu'                                    => 'to',
    'tuaregu'                                  => 'tmh',
    'tumbuku'                                  => 'tum',
    "tupu\ valodas"                            => 'tup',
    'turkmu'                                   => 'tk',
    'turku'                                    => 'tr',
    "turku\ osmau"                             => 'ota',
    'tuvalieu'                                 => 'tvl',
    'tuvieu'                                   => 'tyv',
    'tv'                                       => 'tw',
    'tyap'                                     => 'kcg',
    'udmurtu'                                  => 'udm',
    'ugaritieu'                                => 'uga',
    'uiguru'                                   => 'ug',
    'ukraiu'                                   => 'uk',
    'umbundu'                                  => 'umb',
    'umeru'                                    => 'sux',
    'ungru'                                    => 'hu',
    'urdu'                                     => 'ur',
    'uvau'                                     => 'cv',
    'uzbeku'                                   => 'uz',
    "vairkas\ valodas"                         => 'mul',
    'vaju'                                     => 'vai',
    "vakau\ valoda"                            => 'wak',
    'valamu'                                   => 'wal',
    'valou'                                    => 'wa',
    'vao'                                      => 'was',
    'varaju'                                   => 'war',
    'vau'                                      => 'osa',
    'vcu'                                      => 'de',
    "veices\ augvcu"                           => 'de_ch',
    "veices\ franu"                            => 'fr_ch',
    "veices\ vcu"                              => 'gsw',
    'velsieu'                                  => 'cy',
    'vendu'                                    => 've',
    'vidusangu'                                => 'enm',
    'vidusaugvcu'                              => 'gmh',
    'vidusfranu'                               => 'frm',
    'vidusholandieu'                           => 'dum',
    'vidusru'                                  => 'mga',
    'vjetnamieu'                               => 'vi',
    'volapiks'                                 => 'vo',
    'volofu'                                   => 'wo',
    'votu'                                     => 'vot',
    'zand'                                     => 'znd',
    'zaza'                                     => 'zza',
    'zenagu'                                   => 'zen',
    "ziemeamerikas\ indiu\ valoda"             => 'nai',
    'ziemefrzu'                                => 'frr',
    'ziemendebelu'                             => 'nd',
    'ziemesmu'                                 => 'se',
    'ziemesotu'                                => 'nso',
    "zmju\ valodas"                            => 'sgn',
    'zulu'                                     => 'zu',
    'zunju'                                    => 'zun',
    'zviedru'                                  => 'sv',
);

1;
