package Locales::DB::Language::lt;

# Auto generated from CLDR

$Locales::DB::Language::lt::VERSION = '0.01';

$Locales::DB::Language::lt::cldr_version = '1.7.1';

%Locales::DB::Language::lt::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Kalba\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Sritis\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "taip\:t"
    },
);

%Locales::DB::Language::lt::code_to_name = (
    'aa'    => 'afarų',
    'ab'    => 'abchazų',
    'ace'   => 'ačinezų',
    'ach'   => 'acoli',
    'ada'   => 'adangmų',
    'ady'   => 'adygėjų',
    'ae'    => 'avestų',
    'af'    => 'afrikanų',
    'afa'   => "afroazijos\ kalba",
    'afh'   => 'afrihili',
    'ain'   => 'ainų',
    'ak'    => 'akanų',
    'akk'   => 'akadianų',
    'ale'   => 'aleutų',
    'alg'   => "algonkuanų\ kalba",
    'alt'   => "pietų\ altajaus",
    'am'    => 'amharų',
    'an'    => 'aragonesų',
    'ang'   => "senoji\ anglų",
    'anp'   => 'angikų',
    'apa'   => "apačių\ kalba",
    'ar'    => 'arabų',
    'arc'   => 'aramaikų',
    'arn'   => 'araukanų',
    'arp'   => 'arapahų',
    'art'   => "dirbtinė\ kalba",
    'arw'   => 'aravakų',
    'as'    => 'asamų',
    'ast'   => 'asturianų',
    'ath'   => "athapaskanų\ kalba",
    'aus'   => "australų\ kalba",
    'av'    => 'avarikų',
    'awa'   => 'avadhi',
    'ay'    => 'aimarų',
    'az'    => 'azerbaidžaniečių',
    'ba'    => 'baškirų',
    'bad'   => 'bandų',
    'bai'   => "bamilekų\ kalba",
    'bal'   => 'baluči',
    'ban'   => 'balinezų',
    'bas'   => 'basų',
    'bat'   => "baltų\ kalba",
    'be'    => 'baltarusių',
    'bej'   => 'bėjų',
    'bem'   => 'bembų',
    'ber'   => 'berberų',
    'bg'    => 'bulgarų',
    'bh'    => 'biharų',
    'bho'   => 'baučpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikolų',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambarų',
    'bn'    => 'bengalų',
    'bnt'   => 'bantų',
    'bo'    => 'tibetiečių',
    'br'    => 'bretonų',
    'bra'   => 'brajų',
    'bs'    => 'bosnių',
    'btk'   => 'batakų',
    'bua'   => 'buriatų',
    'bug'   => 'buginezų',
    'byn'   => 'blin',
    'ca'    => 'katalonų',
    'cad'   => 'kado',
    'cai'   => "Centrinės\ Amerikos\ indėnų\ kalba",
    'car'   => 'karibų',
    'cau'   => "kaukaziečių\ kalba",
    'cch'   => 'atsamų',
    'ce'    => 'čečėnų',
    'ceb'   => 'cebuanų',
    'cel'   => "keltų\ kalba",
    'ch'    => 'čamorų',
    'chb'   => 'čibča',
    'chg'   => 'čagatų',
    'chk'   => 'čukesų',
    'chm'   => 'mari',
    'chn'   => "činuk\ žargonas",
    'cho'   => 'čoktau',
    'chp'   => 'čipvėjų',
    'chr'   => 'čerokių',
    'chy'   => 'čajenų',
    'cmc'   => "čamikų\ kalba",
    'co'    => 'korsikiečių',
    'cop'   => 'koptų',
    'cpe'   => "kreolų\ ir\ pidžinų\ kalba\ pagal\ anglų",
    'cpf'   => "kreolų\ ir\ pidžinų\ kalba\ pagal\ prancūzų",
    'cpp'   => "kreolų\ ir\ pidžinų\ kalba\ pagal\ portugalų",
    'cr'    => 'kry',
    'crh'   => "krymo\ turkų",
    'crp'   => "kreolų\ ir\ pidžinų",
    'cs'    => 'čekų',
    'csb'   => 'kašubų',
    'cu'    => "bažnytinė\ slavų",
    'cus'   => "kušitik\ kalba",
    'cv'    => 'čiuvašų',
    'cy'    => 'valų',
    'da'    => 'danų',
    'dak'   => 'dakotų',
    'dar'   => 'dargva',
    'day'   => "bidayuh\ kalba",
    'de'    => 'vokiečių',
    'de_at' => "Austrijos\ vokiečių",
    'de_ch' => "aukštoji\ Šveicarijos\ vokiečių",
    'del'   => 'delavero',
    'den'   => 'slave',
    'dgr'   => 'dogribų',
    'din'   => 'dinkų',
    'doi'   => 'dogri',
    'dra'   => "dravidų\ kalba",
    'dsb'   => "Žemutinės\ Serbijos",
    'dua'   => 'dualų',
    'dum'   => "Vidurio\ Vokietijos",
    'dv'    => 'divehi',
    'dyu'   => 'dyulų',
    'dz'    => 'svazilando',
    'ee'    => 'eve',
    'efi'   => 'efik',
    'egy'   => "senovės\ egiptiečių",
    'eka'   => 'ekajuk',
    'el'    => 'graikų',
    'elx'   => 'elamitų',
    'en'    => 'anglų',
    'en_au' => "anglų\ kalba\ \(australija\)",
    'en_ca' => "Kanados\ anglų",
    'en_gb' => "anglų\ \(britų\)",
    'en_us' => "anglų\ \(amerikiečių\)",
    'enm'   => "Vidurio\ Anglijos",
    'eo'    => 'esperanto',
    'es'    => 'ispanų',
    'es_es' => "Iberijos\ ispanų",
    'et'    => 'estų',
    'eu'    => 'baskų',
    'ewo'   => 'evondo',
    'fa'    => 'persų',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulahų',
    'fi'    => 'suomių',
    'fil'   => 'filipinų',
    'fiu'   => "finougrų\ kalba",
    'fj'    => 'fidžio',
    'fo'    => "farerų\ kalba",
    'fon'   => 'fon',
    'fr'    => 'prancūzų',
    'fr_ca' => "Kanados\ prancūzų",
    'fr_ch' => "Šveicarijos\ prancūzų",
    'frm'   => "Vidurio\ Prancūzijos",
    'fro'   => "senoji\ prancūzų",
    'frr'   => "šiaurinių\ fryzų",
    'frs'   => "rytų\ fryzų",
    'fur'   => 'frulan',
    'fy'    => "vakarų\ fryzų",
    'ga'    => 'airių',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => "škotų\ gėlų",
    'gem'   => "germanų\ kalba",
    'gez'   => 'gyz',
    'gil'   => 'kiribati',
    'gl'    => 'galisų',
    'gmh'   => "Vidurio\ aukštosios\ Vokietijos",
    'gn'    => 'gvaranių',
    'goh'   => "Senoji\ Aukštosios\ Vokietijos",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotų',
    'grb'   => 'grebo',
    'grc'   => "senovės\ graikų",
    'gsw'   => "Šveicarijos\ vokiečių",
    'gu'    => 'gudžaratų',
    'gv'    => 'manks',
    'gwi'   => 'gvičino',
    'ha'    => 'hausų',
    'hai'   => 'haido',
    'haw'   => 'havajų',
    'he'    => 'hebrajų',
    'hi'    => 'hindi',
    'hil'   => 'hiligainon',
    'him'   => 'himačali',
    'hit'   => 'hititų',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'kroatų',
    'hsb'   => "viršutinė\ sorbian",
    'ht'    => 'haičio',
    'hu'    => 'vengrų',
    'hup'   => 'hupa',
    'hy'    => 'armėnų',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'iban',
    'id'    => 'indoneziečių',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "sičuan\ ji",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => "indų\ kalba",
    'ine'   => "indoeuropiečių\ kalba",
    'inh'   => 'ingušų',
    'io'    => 'ido',
    'ira'   => 'Iraniečių',
    'iro'   => "irako\ kalba",
    'is'    => 'islandų',
    'it'    => 'italų',
    'iu'    => 'inukitut',
    'ja'    => 'japonų',
    'jbo'   => 'loiban',
    'jpr'   => "judėjų\ persų",
    'jrb'   => "judėjų\ arabų",
    'jv'    => 'javiečių',
    'ka'    => 'gruzinų',
    'kaa'   => 'karakalpakų',
    'kab'   => 'kabilo',
    'kac'   => 'kačin',
    'kaj'   => 'ju',
    'kam'   => 'kamba',
    'kar'   => 'karenų',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardinų',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'kasi',
    'khi'   => "koisan\ kalba",
    'kho'   => 'kotanezų',
    'ki'    => 'kikui',
    'kj'    => 'kuaniama',
    'kk'    => 'kazachų',
    'kl'    => 'kalalisut',
    'km'    => 'khmerų',
    'kmb'   => 'kimbundu',
    'kn'    => 'kanadų',
    'ko'    => 'korėjiečių',
    'kok'   => 'kankani',
    'kos'   => 'kosreanų',
    'kpe'   => 'kpele',
    'kr'    => 'kanuri',
    'krc'   => "karačiajų\ balkarijos",
    'krl'   => 'karelų',
    'kro'   => "kru\ kalba",
    'kru'   => 'kuruk',
    'ks'    => 'kašmyro',
    'ku'    => 'kurdų',
    'kum'   => 'kumik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornų',
    'ky'    => 'kirgizų',
    'la'    => 'lotynų',
    'lad'   => 'ladino',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'liuksemburgiečių',
    'lez'   => 'lezginų',
    'lg'    => 'ganda',
    'li'    => 'limburgiš',
    'ln'    => 'lingala',
    'lo'    => 'laosiečių',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lietuvių',
    'lu'    => "luba\ katanga",
    'lua'   => "luba\ lula",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lušai',
    'lv'    => 'latvių',
    'mad'   => 'madurezų',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasaro',
    'man'   => 'mandingo',
    'map'   => 'austronezų',
    'mas'   => 'masajų',
    'mdf'   => 'mokša',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasijos',
    'mga'   => "Vidurio\ Airijos",
    'mh'    => "Maršalo\ salų",
    'mi'    => 'maorių',
    'mic'   => 'mikmak',
    'min'   => 'minankabu',
    'mis'   => "įvairios\ kalbos",
    'mk'    => 'makedonų',
    'mkh'   => "mon\ khmer\ kalba",
    'ml'    => 'malajalių',
    'mn'    => 'mongolų',
    'mnc'   => 'manču',
    'mni'   => 'manipuri',
    'mno'   => "manobo\ kalba",
    'mo'    => 'moldavų',
    'moh'   => 'mohok',
    'mos'   => 'mosi',
    'mr'    => 'maratų',
    'ms'    => 'malajiečių',
    'mt'    => 'maltiečių',
    'mul'   => "kelios\ kalbos",
    'mun'   => "munda\ kalba",
    'mus'   => 'krykų',
    'mwl'   => 'mirandezų',
    'mwr'   => 'marvari',
    'my'    => 'birmiečių',
    'myn'   => 'majanų',
    'myv'   => 'erzyjų',
    'na'    => 'naurų',
    'nah'   => 'nahuatlų',
    'nai'   => "Šiaurės\ Amerikos\ indėnų\ kalba",
    'nap'   => 'neapoliečių',
    'nb'    => "Norvegijos\ bokmal",
    'nd'    => "šiaurės\ ndebelų",
    'nds'   => "Žemutinės\ Vokietijos",
    'ne'    => 'nepalų',
    'new'   => 'nevari',
    'ng'    => 'ndongų',
    'nia'   => 'nias',
    'nic'   => "Nigerio\ kordofanų\ kalba",
    'niu'   => 'niuenų',
    'nl'    => 'olandų',
    'nl_be' => 'flamandų',
    'nn'    => "naujoji\-norvegų",
    'no'    => 'norvegų',
    'nog'   => 'nogų',
    'non'   => 'norsu',
    'nqo'   => 'enko',
    'nr'    => "pietų\ ndebele",
    'nso'   => "šiaurės\ sothų",
    'nub'   => "nubijos\ kalba",
    'nv'    => 'navajų',
    'nwc'   => "klasikinė\ nevari",
    'ny'    => 'nianja',
    'nym'   => 'niamvezi',
    'nyn'   => 'niankole',
    'nyo'   => 'nioro',
    'nzi'   => 'nzima',
    'oc'    => 'provansalų',
    'oj'    => 'ojibva',
    'om'    => 'oromo',
    'or'    => 'orijų',
    'os'    => 'osetinų',
    'osa'   => 'osage',
    'ota'   => "osmanų\ turkų",
    'oto'   => "otomanų\ kalba",
    'pa'    => 'pandžabų',
    'paa'   => "papuasų\ kalba",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiemento',
    'pau'   => 'palau',
    'peo'   => "senoji\ persų",
    'phi'   => "filipinų\ kalba",
    'phn'   => 'finikiečių',
    'pi'    => 'pali',
    'pl'    => 'lenkų',
    'pon'   => 'ponapean',
    'pra'   => "prakrit\ kalba",
    'pro'   => "senovės\ provansalų",
    'ps'    => 'puštūnų',
    'pt'    => 'portugalų',
    'pt_br' => "portugalų\ \(Brazilijos\)",
    'pt_pt' => "Iberijos\ portugalų",
    'qu'    => 'kečujų',
    'raj'   => 'radžastano',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongan',
    'rm'    => "raeto\ romanų",
    'rn'    => 'rundi',
    'ro'    => 'rumunų',
    'roa'   => "romanų\ kalba",
    'rom'   => "romų\ kalba",
    'ru'    => 'rusų',
    'rup'   => 'aromanių',
    'rw'    => 'kinjarvanda',
    'sa'    => 'sanskrito',
    'sad'   => 'sandavi',
    'sah'   => 'jakutų',
    'sai'   => "Pietų\ Amerikos\ indėnų\ kalba",
    'sal'   => "sališan\ kalba",
    'sam'   => "samarėjų\ aramių",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardiniečių',
    'scn'   => 'siciliečių',
    'sco'   => 'škotų',
    'sd'    => 'sindų',
    'se'    => "šiaurinių\ samių",
    'sel'   => 'selkup',
    'sem'   => "samitų\ kalba",
    'sg'    => 'sango',
    'sga'   => "senoji\ airių",
    'sgn'   => "ženklų\ kalba",
    'sh'    => "serbų\-kroatų",
    'shn'   => 'šan',
    'si'    => 'sinhalų',
    'sid'   => 'sidamo',
    'sio'   => "siouan\ kalba",
    'sit'   => "sino\ tibeto\ kalba",
    'sk'    => 'slovakų',
    'sl'    => 'slovėnų',
    'sla'   => "slavų\ kalba",
    'sm'    => 'samoa',
    'sma'   => "pietų\ sami",
    'smi'   => "samių\ kalba",
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ sami",
    'sn'    => 'šona',
    'snk'   => 'soninke',
    'so'    => 'somalių',
    'sog'   => 'sogdien',
    'son'   => 'songhai',
    'sq'    => 'albanų',
    'sr'    => 'serbų',
    'srn'   => "sranan\ tongo",
    'srr'   => 'sererų',
    'ss'    => 'svati',
    'ssa'   => "Nilo\ Sacharos\ kalba",
    'st'    => "pietų\ sesuto",
    'su'    => 'sundų',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'šumerų',
    'sv'    => 'švedų',
    'sw'    => 'svahili',
    'syc'   => "klasikinė\ siriečių",
    'syr'   => 'sirų',
    'ta'    => 'tamilų',
    'tai'   => "tajų\ kalba",
    'te'    => 'telugų',
    'tem'   => 'timne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadžikų',
    'th'    => 'tajų',
    'ti'    => 'tigrajų',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turkmėnų',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalogų',
    'tlh'   => 'kelionių',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tsvana',
    'to'    => 'tonga',
    'tog'   => "niasa\ tongos",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turkų',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimšian',
    'tt'    => 'totorių',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\ kalba",
    'tut'   => "altaikų\ kalba",
    'tvl'   => 'tuvalu',
    'tw'    => 'tvi',
    'ty'    => 'taitiečių',
    'tyv'   => 'tuvių',
    'udm'   => 'udmurtų',
    'ug'    => 'uigūrų',
    'uga'   => 'ugaritic',
    'uk'    => 'ukrainiečių',
    'umb'   => 'umbundu',
    'und'   => "\(nenustatyta\ kalba\)",
    'ur'    => 'urdų',
    'uz'    => 'uzbekų',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamiečių',
    'vo'    => 'volapiuk',
    'vot'   => 'votik',
    'wa'    => 'valonų',
    'wak'   => "vakašan\ kalba",
    'wal'   => 'valamo',
    'war'   => 'varai',
    'was'   => 'vašo',
    'wen'   => "sorbų\ kalba",
    'wo'    => 'volof',
    'xal'   => 'kalmukų',
    'xh'    => 'kosų',
    'yao'   => 'jao',
    'yap'   => 'japezų',
    'yi'    => 'jidiš',
    'yo'    => 'joruba',
    'ypk'   => "jupik\ kalba",
    'za'    => 'chuang',
    'zap'   => 'zapotekų',
    'zbl'   => "„Bliss“\ simbolių\ kalba",
    'zen'   => 'zenaga',
    'zh'    => 'kinų',
    'znd'   => 'zande',
    'zu'    => 'zulų',
    'zun'   => 'zuni',
    'zxx'   => "Nėra\ kalbinio\ turinio",
    'zza'   => 'zaza',
);

%Locales::DB::Language::lt::name_to_code = (
    'abchaz'                                   => 'ab',
    'acoli'                                    => 'ach',
    'adangm'                                   => 'ada',
    'adygj'                                    => 'ady',
    'afar'                                     => 'aa',
    'afrihili'                                 => 'afh',
    'afrikan'                                  => 'af',
    "afroazijos\ kalba"                        => 'afa',
    'agat'                                     => 'chg',
    'aimar'                                    => 'ay',
    'ain'                                      => 'ain',
    'ainez'                                    => 'ace',
    'airi'                                     => 'ga',
    'ajen'                                     => 'chy',
    'akadian'                                  => 'akk',
    'akan'                                     => 'ak',
    'alban'                                    => 'sq',
    'aleut'                                    => 'ale',
    "algonkuan\ kalba"                         => 'alg',
    "altaik\ kalba"                            => 'tut',
    'amhar'                                    => 'am',
    "amik\ kalba"                              => 'cmc',
    'amor'                                     => 'ch',
    'an'                                       => 'shn',
    'angik'                                    => 'anp',
    'angl'                                     => 'en',
    "angl\ amerikiei"                          => 'en_us',
    "angl\ brit"                               => 'en_gb',
    "angl\ kalba\ australija"                  => 'en_au',
    "apai\ kalba"                              => 'apa',
    'arab'                                     => 'ar',
    'aragones'                                 => 'an',
    'aramaik'                                  => 'arc',
    'arapah'                                   => 'arp',
    'araukan'                                  => 'arn',
    'aravak'                                   => 'arw',
    'armn'                                     => 'hy',
    'aromani'                                  => 'rup',
    'asam'                                     => 'as',
    'asturian'                                 => 'ast',
    "athapaskan\ kalba"                        => 'ath',
    'atsam'                                    => 'cch',
    "auktoji\ veicarijos\ vokiei"              => 'de_ch',
    "austral\ kalba"                           => 'aus',
    "austrijos\ vokiei"                        => 'de_at',
    'austronez'                                => 'map',
    'avadhi'                                   => 'awa',
    'avarik'                                   => 'av',
    'avest'                                    => 'ae',
    'azerbaidaniei'                            => 'az',
    'bakir'                                    => 'ba',
    'balinez'                                  => 'ban',
    "balt\ kalba"                              => 'bat',
    'baltarusi'                                => 'be',
    'balui'                                    => 'bal',
    'bambar'                                   => 'bm',
    "bamilek\ kalba"                           => 'bai',
    'band'                                     => 'bad',
    'bant'                                     => 'bnt',
    "banytin\ slav"                            => 'cu',
    'bas'                                      => 'bas',
    'bask'                                     => 'eu',
    'batak'                                    => 'btk',
    'baupuri'                                  => 'bho',
    'bemb'                                     => 'bem',
    'bengal'                                   => 'bn',
    'berber'                                   => 'ber',
    "bidayuh\ kalba"                           => 'day',
    'bihar'                                    => 'bh',
    'bikol'                                    => 'bik',
    'bini'                                     => 'bin',
    'birmiei'                                  => 'my',
    'bislama'                                  => 'bi',
    'bj'                                       => 'bej',
    'blin'                                     => 'byn',
    "bliss\ simboli\ kalba"                    => 'zbl',
    'bosni'                                    => 'bs',
    'braj'                                     => 'bra',
    'breton'                                   => 'br',
    'buginez'                                  => 'bug',
    'bulgar'                                   => 'bg',
    'buriat'                                   => 'bua',
    'cebuan'                                   => 'ceb',
    "centrins\ amerikos\ indn\ kalba"          => 'cai',
    'chuang'                                   => 'za',
    'dakot'                                    => 'dak',
    'dan'                                      => 'da',
    'dargva'                                   => 'dar',
    'delavero'                                 => 'del',
    'dink'                                     => 'din',
    "dirbtin\ kalba"                           => 'art',
    'divehi'                                   => 'dv',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    "dravid\ kalba"                            => 'dra',
    'dual'                                     => 'dua',
    'dyul'                                     => 'dyu',
    'efik'                                     => 'efi',
    'ek'                                       => 'cs',
    'ekajuk'                                   => 'eka',
    'elamit'                                   => 'elx',
    "emutins\ serbijos"                        => 'dsb',
    "emutins\ vokietijos"                      => 'nds',
    'en'                                       => 'ce',
    "enkl\ kalba"                              => 'sgn',
    'enko'                                     => 'nqo',
    'eroki'                                    => 'chr',
    'erzyj'                                    => 'myv',
    'esperanto'                                => 'eo',
    'est'                                      => 'et',
    'eve'                                      => 'ee',
    'evondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    "farer\ kalba"                             => 'fo',
    'fidio'                                    => 'fj',
    'filipin'                                  => 'fil',
    "filipin\ kalba"                           => 'phi',
    'finikiei'                                 => 'phn',
    "finougr\ kalba"                           => 'fiu',
    'flamand'                                  => 'nl_be',
    'fon'                                      => 'fon',
    'frulan'                                   => 'fur',
    'fulah'                                    => 'ff',
    'ga'                                       => 'gaa',
    'gajo'                                     => 'gay',
    'galis'                                    => 'gl',
    'ganda'                                    => 'lg',
    'gbaja'                                    => 'gba',
    "german\ kalba"                            => 'gem',
    'gondi'                                    => 'gon',
    'gorontalo'                                => 'gor',
    'got'                                      => 'got',
    'graik'                                    => 'el',
    'grebo'                                    => 'grb',
    'gruzin'                                   => 'ka',
    'gudarat'                                  => 'gu',
    'gvarani'                                  => 'gn',
    'gviino'                                   => 'gwi',
    'gyz'                                      => 'gez',
    'haido'                                    => 'hai',
    'haiio'                                    => 'ht',
    'haus'                                     => 'ha',
    'havaj'                                    => 'haw',
    'hebraj'                                   => 'he',
    'herero'                                   => 'hz',
    'hiligainon'                               => 'hil',
    'himaali'                                  => 'him',
    'hindi'                                    => 'hi',
    "hiri\ motu"                               => 'ho',
    'hitit'                                    => 'hit',
    'hmong'                                    => 'hmn',
    'hupa'                                     => 'hup',
    "iaurini\ fryz"                            => 'frr',
    "iaurini\ sami"                            => 'se',
    "iaurs\ amerikos\ indn\ kalba"             => 'nai',
    "iaurs\ ndebel"                            => 'nd',
    "iaurs\ soth"                              => 'nso',
    'iba'                                      => 'chb',
    'iban'                                     => 'iba',
    "iberijos\ ispan"                          => 'es_es',
    "iberijos\ portugal"                       => 'pt_pt',
    'ido'                                      => 'io',
    'igbo'                                     => 'ig',
    'ijo'                                      => 'ijo',
    'iloko'                                    => 'ilo',
    "inari\ sami"                              => 'smn',
    "ind\ kalba"                               => 'inc',
    "indoeuropiei\ kalba"                      => 'ine',
    'indoneziei'                               => 'id',
    'ingu'                                     => 'inh',
    'interlingue'                              => 'ie',
    'interlingva'                              => 'ia',
    "inuk\ argonas"                            => 'chn',
    'inukitut'                                 => 'iu',
    'inupiak'                                  => 'ik',
    'ipvj'                                     => 'chp',
    "irako\ kalba"                             => 'iro',
    'iraniei'                                  => 'ira',
    'island'                                   => 'is',
    'ispan'                                    => 'es',
    'ital'                                     => 'it',
    'iuva'                                     => 'cv',
    'jakut'                                    => 'sah',
    'jao'                                      => 'yao',
    'japez'                                    => 'yap',
    'japon'                                    => 'ja',
    'javiei'                                   => 'jv',
    'jidi'                                     => 'yi',
    'joruba'                                   => 'yo',
    'ju'                                       => 'kaj',
    "judj\ arab"                               => 'jrb',
    "judj\ pers"                               => 'jpr',
    "jupik\ kalba"                             => 'ypk',
    'kabardin'                                 => 'kbd',
    'kabilo'                                   => 'kab',
    'kado'                                     => 'cad',
    'kain'                                     => 'kac',
    'kalalisut'                                => 'kl',
    'kalmuk'                                   => 'xal',
    'kamba'                                    => 'kam',
    'kamyro'                                   => 'ks',
    'kanad'                                    => 'kn',
    "kanados\ angl"                            => 'en_ca',
    "kanados\ prancz"                          => 'fr_ca',
    'kankani'                                  => 'kok',
    'kanuri'                                   => 'kr',
    "karaiaj\ balkarijos"                      => 'krc',
    'karakalpak'                               => 'kaa',
    'karel'                                    => 'krl',
    'karen'                                    => 'kar',
    'karib'                                    => 'car',
    'kasi'                                     => 'kha',
    'katalon'                                  => 'ca',
    'kaub'                                     => 'csb',
    "kaukaziei\ kalba"                         => 'cau',
    'kavi'                                     => 'kaw',
    'kazach'                                   => 'kk',
    'kelioni'                                  => 'tlh',
    "kelios\ kalbos"                           => 'mul',
    "kelt\ kalba"                              => 'cel',
    'keuj'                                     => 'qu',
    'khmer'                                    => 'km',
    'kikui'                                    => 'ki',
    'kimbundu'                                 => 'kmb',
    'kin'                                      => 'zh',
    'kinjarvanda'                              => 'rw',
    'kirgiz'                                   => 'ky',
    'kiribati'                                 => 'gil',
    "klasikin\ nevari"                         => 'nwc',
    "klasikin\ siriei"                         => 'syc',
    "koisan\ kalba"                            => 'khi',
    'komi'                                     => 'kv',
    'kongo'                                    => 'kg',
    'kopt'                                     => 'cop',
    'korjiei'                                  => 'ko',
    'korn'                                     => 'kw',
    'koro'                                     => 'kfo',
    'korsikiei'                                => 'co',
    'kos'                                      => 'xh',
    'kosrean'                                  => 'kos',
    'kot'                                      => 'sco',
    "kot\ gl"                                  => 'gd',
    'kotanez'                                  => 'kho',
    'kpele'                                    => 'kpe',
    "kreol\ ir\ pidin"                         => 'crp',
    "kreol\ ir\ pidin\ kalba\ pagal\ angl"     => 'cpe',
    "kreol\ ir\ pidin\ kalba\ pagal\ portugal" => 'cpp',
    "kreol\ ir\ pidin\ kalba\ pagal\ prancz"   => 'cpf',
    'kroat'                                    => 'hr',
    "kru\ kalba"                               => 'kro',
    'kry'                                      => 'cr',
    'kryk'                                     => 'mus',
    "krymo\ turk"                              => 'crh',
    'kuaniama'                                 => 'kj',
    "kuitik\ kalba"                            => 'cus',
    'kumik'                                    => 'kum',
    'kurd'                                     => 'ku',
    'kuruk'                                    => 'kru',
    'kutenai'                                  => 'kut',
    'ladino'                                   => 'lad',
    'lamba'                                    => 'lam',
    'landa'                                    => 'lah',
    'laosiei'                                  => 'lo',
    'latvi'                                    => 'lv',
    'lenk'                                     => 'pl',
    'lezgin'                                   => 'lez',
    'lietuvi'                                  => 'lt',
    'limburgi'                                 => 'li',
    'lingala'                                  => 'ln',
    'liuksemburgiei'                           => 'lb',
    'loiban'                                   => 'jbo',
    'lotyn'                                    => 'la',
    'lozi'                                     => 'loz',
    'luai'                                     => 'lus',
    "luba\ katanga"                            => 'lu',
    "luba\ lula"                               => 'lua',
    'luiseno'                                  => 'lui',
    "lule\ sami"                               => 'smj',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'madurez'                                  => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'majan'                                    => 'myn',
    'makasaro'                                 => 'mak',
    'makedon'                                  => 'mk',
    'malagasijos'                              => 'mg',
    'malajali'                                 => 'ml',
    'malajiei'                                 => 'ms',
    'maltiei'                                  => 'mt',
    'mandar'                                   => 'mdr',
    'mandingo'                                 => 'man',
    'manipuri'                                 => 'mni',
    'manks'                                    => 'gv',
    "manobo\ kalba"                            => 'mno',
    'manu'                                     => 'mnc',
    'maori'                                    => 'mi',
    "maralo\ sal"                              => 'mh',
    'marat'                                    => 'mr',
    'mari'                                     => 'chm',
    'marvari'                                  => 'mwr',
    'masaj'                                    => 'mas',
    'mende'                                    => 'men',
    'mikmak'                                   => 'mic',
    'minankabu'                                => 'min',
    'mirandez'                                 => 'mwl',
    'mohok'                                    => 'moh',
    'moka'                                     => 'mdf',
    'moldav'                                   => 'mo',
    "mon\ khmer\ kalba"                        => 'mkh',
    'mongo'                                    => 'lol',
    'mongol'                                   => 'mn',
    'morisyen'                                 => 'mfe',
    'mosi'                                     => 'mos',
    "munda\ kalba"                             => 'mun',
    'nahuatl'                                  => 'nah',
    'naujojinorveg'                            => 'nn',
    'naur'                                     => 'na',
    'navaj'                                    => 'nv',
    'ndong'                                    => 'ng',
    'neapoliei'                                => 'nap',
    "nenustatyta\ kalba"                       => 'und',
    'nepal'                                    => 'ne',
    'nevari'                                   => 'new',
    'niamvezi'                                 => 'nym',
    'nianja'                                   => 'ny',
    'niankole'                                 => 'nyn',
    'nias'                                     => 'nia',
    "niasa\ tongos"                            => 'tog',
    "nigerio\ kordofan\ kalba"                 => 'nic',
    "nilo\ sacharos\ kalba"                    => 'ssa',
    'nioro'                                    => 'nyo',
    'niuen'                                    => 'niu',
    'nog'                                      => 'nog',
    'norsu'                                    => 'non',
    'norveg'                                   => 'no',
    "norvegijos\ bokmal"                       => 'nb',
    "nra\ kalbinio\ turinio"                   => 'zxx',
    "nubijos\ kalba"                           => 'nub',
    'nzima'                                    => 'nzi',
    'ojibva'                                   => 'oj',
    'oktau'                                    => 'cho',
    'oland'                                    => 'nl',
    'ona'                                      => 'sn',
    'orij'                                     => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'osetin'                                   => 'os',
    "osman\ turk"                              => 'ota',
    "otoman\ kalba"                            => 'oto',
    'pahlavi'                                  => 'pal',
    'palau'                                    => 'pau',
    'pali'                                     => 'pi',
    'pampanga'                                 => 'pam',
    'pandab'                                   => 'pa',
    'pangasinan'                               => 'pag',
    'papiemento'                               => 'pap',
    "papuas\ kalba"                            => 'paa',
    'pers'                                     => 'fa',
    "piet\ altajaus"                           => 'alt',
    "piet\ amerikos\ indn\ kalba"              => 'sai',
    "piet\ ndebele"                            => 'nr',
    "piet\ sami"                               => 'sma',
    "piet\ sesuto"                             => 'st',
    'ponapean'                                 => 'pon',
    'portugal'                                 => 'pt',
    "portugal\ brazilijos"                     => 'pt_br',
    "prakrit\ kalba"                           => 'pra',
    'prancz'                                   => 'fr',
    'provansal'                                => 'oc',
    'putn'                                     => 'ps',
    'radastano'                                => 'raj',
    "raeto\ roman"                             => 'rm',
    'rapanui'                                  => 'rap',
    'rarotongan'                               => 'rar',
    "rom\ kalba"                               => 'rom',
    "roman\ kalba"                             => 'roa',
    'rumun'                                    => 'ro',
    'rundi'                                    => 'rn',
    'rus'                                      => 'ru',
    "ryt\ fryz"                                => 'frs',
    "salian\ kalba"                            => 'sal',
    "samarj\ arami"                            => 'sam',
    "sami\ kalba"                              => 'smi',
    "samit\ kalba"                             => 'sem',
    'samoa'                                    => 'sm',
    'sandavi'                                  => 'sad',
    'sango'                                    => 'sg',
    'sanskrito'                                => 'sa',
    'santali'                                  => 'sat',
    'sardiniei'                                => 'sc',
    'sasak'                                    => 'sas',
    'selkup'                                   => 'sel',
    "senoji\ airi"                             => 'sga',
    "senoji\ angl"                             => 'ang',
    "senoji\ auktosios\ vokietijos"            => 'goh',
    "senoji\ pers"                             => 'peo',
    "senoji\ prancz"                           => 'fro',
    "senovs\ egiptiei"                         => 'egy',
    "senovs\ graik"                            => 'grc',
    "senovs\ provansal"                        => 'pro',
    'serb'                                     => 'sr',
    'serbkroat'                                => 'sh',
    'serer'                                    => 'srr',
    'siciliei'                                 => 'scn',
    'sidamo'                                   => 'sid',
    'siksika'                                  => 'bla',
    'sind'                                     => 'sd',
    'sinhal'                                   => 'si',
    "sino\ tibeto\ kalba"                      => 'sit',
    "siouan\ kalba"                            => 'sio',
    'sir'                                      => 'syr',
    "siuan\ ji"                                => 'ii',
    "skolt\ sami"                              => 'sms',
    "slav\ kalba"                              => 'sla',
    'slave'                                    => 'den',
    'slovak'                                   => 'sk',
    'slovn'                                    => 'sl',
    'sogdien'                                  => 'sog',
    'somali'                                   => 'so',
    'songhai'                                  => 'son',
    'soninke'                                  => 'snk',
    "sorb\ kalba"                              => 'wen',
    "sranan\ tongo"                            => 'srn',
    'sukuma'                                   => 'suk',
    'sund'                                     => 'su',
    'suomi'                                    => 'fi',
    'susu'                                     => 'sus',
    'svahili'                                  => 'sw',
    'svati'                                    => 'ss',
    'svazilando'                               => 'dz',
    'tadik'                                    => 'tg',
    'tagalog'                                  => 'tl',
    'taitiei'                                  => 'ty',
    'taj'                                      => 'th',
    "taj\ kalba"                               => 'tai',
    'tamaek'                                   => 'tmh',
    'tamil'                                    => 'ta',
    'taroko'                                   => 'trv',
    'telug'                                    => 'te',
    'tereno'                                   => 'ter',
    'tetum'                                    => 'tet',
    'tibetiei'                                 => 'bo',
    'tigraj'                                   => 'ti',
    'tigre'                                    => 'tig',
    'timne'                                    => 'tem',
    'tiv'                                      => 'tiv',
    'tlingit'                                  => 'tli',
    "tok\ pisin"                               => 'tpi',
    'tokelau'                                  => 'tkl',
    'tonga'                                    => 'to',
    'totori'                                   => 'tt',
    'tsimian'                                  => 'tsi',
    'tsonga'                                   => 'ts',
    'tsvana'                                   => 'tn',
    'tumbuka'                                  => 'tum',
    "tupi\ kalba"                              => 'tup',
    'turk'                                     => 'tr',
    'turkmn'                                   => 'tk',
    'tuvalu'                                   => 'tvl',
    'tuvi'                                     => 'tyv',
    'tvi'                                      => 'tw',
    'tyap'                                     => 'kcg',
    'udmurt'                                   => 'udm',
    'ugaritic'                                 => 'uga',
    'uigr'                                     => 'ug',
    'ukes'                                     => 'chk',
    'ukrainiei'                                => 'uk',
    'umbundu'                                  => 'umb',
    'umer'                                     => 'sux',
    'urd'                                      => 'ur',
    'uzbek'                                    => 'uz',
    'vai'                                      => 'vai',
    "vairios\ kalbos"                          => 'mis',
    "vakaan\ kalba"                            => 'wak',
    "vakar\ fryz"                              => 'fy',
    'val'                                      => 'cy',
    'valamo'                                   => 'wal',
    'valon'                                    => 'wa',
    'vao'                                      => 'was',
    'varai'                                    => 'war',
    'ved'                                      => 'sv',
    "veicarijos\ prancz"                       => 'fr_ch',
    "veicarijos\ vokiei"                       => 'gsw',
    'venda'                                    => 've',
    'vengr'                                    => 'hu',
    "vidurio\ airijos"                         => 'mga',
    "vidurio\ anglijos"                        => 'enm',
    "vidurio\ auktosios\ vokietijos"           => 'gmh',
    "vidurio\ pranczijos"                      => 'frm',
    "vidurio\ vokietijos"                      => 'dum',
    'vietnamiei'                               => 'vi',
    "virutin\ sorbian"                         => 'hsb',
    'vokiei'                                   => 'de',
    'volapiuk'                                 => 'vo',
    'volof'                                    => 'wo',
    'votik'                                    => 'vot',
    'zande'                                    => 'znd',
    'zapotek'                                  => 'zap',
    'zaza'                                     => 'zza',
    'zenaga'                                   => 'zen',
    'zul'                                      => 'zu',
    'zuni'                                     => 'zun',
);

1;
