package Locales::DB::Language::km;

# Auto generated from CLDR

$Locales::DB::Language::km::VERSION = '0.01';

$Locales::DB::Language::km::cldr_version = '1.7.1';

%Locales::DB::Language::km::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::km::code_to_name = (
    'aa'    => 'ភាសាអាហ្វារ',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'ភាសាអាវែស្តង់',
    'af'    => 'ភាសាអាហ្វ្រីកាអាន',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'អំហារិក',
    'an'    => 'ភាសាអារ៉ាហ្គោន',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'ភាសាអារ៉ាប់',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Assamese',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ភាសាអីម៉ារ៉ា',
    'az'    => 'ភាសាអាហ៊្សែរបែហ្សង់',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'ភាសាបេឡារុស្ស',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'ភាសាប៊ុលហ្ការី',
    'bh'    => 'ភាសាបិហារ',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'ភាសាបាម្បារា',
    'bn'    => 'ភាសាបេន្កាលី',
    'bnt'   => 'Bantu',
    'bo'    => 'ភាសាទីបេ',
    'br'    => 'ប្រីស្តុន',
    'bra'   => 'Braj',
    'bs'    => 'ប៊ូស្នៀរ',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'ភាសាកាតាឡាន',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ភាសាឆេក',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'វេល',
    'da'    => 'ភាសាដាណឺម៉ាក',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'ភាសាអាល្លឺម៉ង់',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'ភាសាប៊ូតាន',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ភាសាក្រិច',
    'elx'   => 'Elamite',
    'en'    => 'ភាសាអង់គ្លេស',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'ភាសាអេស្ពេរ៉ាន្ទោ',
    'es'    => 'ភាសាអេស្ប៉ាញ',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'ភាសាអេស្តូនី',
    'eu'    => 'ភាសាបាស្កេ',
    'ewo'   => 'Ewondo',
    'fa'    => 'ភឺសៀន',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ភាសាហ្វាំងឡង់',
    'fil'   => 'ពីលីពីន',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ហ្វ៉ីហ្ស៉ី',
    'fo'    => 'ហ្វារូស',
    'fon'   => 'Fon',
    'fr'    => 'ភាសាបារាំង',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'ហ្រីសង់',
    'ga'    => 'ភាសាហ្កែលិគ',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "ភាសាហ្កែលិគ\ \[gd\]",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'ភាសាហ្កាលីស៉ី',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ភាសាហ្កួរ៉ានី',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'ភាសាហ្កុយ៉ារាទី',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'ភាសាហេប្រិ',
    'hi'    => 'ភាសាហ៉ិនឌី',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ក្រូអាទៀន',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'ភាសាហុងគ្រី',
    'hup'   => 'Hupa',
    'hy'    => 'ភាសាអារមេនី',
    'hz'    => 'Herero',
    'ia'    => 'អីនធើលីង',
    'iba'   => 'Iban',
    'id'    => 'ភាសាឥណ្ឌូនេស៊ី',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'ភាសាអ៉ីស្លង់',
    'it'    => 'ភាសាអ៊ីតាលី',
    'iu'    => 'Inuktitut',
    'ja'    => 'ភាសាជប៉ុន',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ភាសាយ៉ាវា',
    'ka'    => 'ភាសាហ្សកហ្ស៉ី',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'ភាសាកាហ្សាក់ស្តង់់',
    'kl'    => 'Kalaallisut',
    'km'    => 'ភាសាខ្មែរ',
    'kmb'   => 'Kimbundu',
    'kn'    => 'ភាសាកិណាដា',
    'ko'    => 'ភាសាកូរ៉េ',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'ភាសាឃឺដ',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'ភាសាគៀរហ្គីស្តង់',
    'la'    => 'ភាសាឡាតំាង',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'លីនកាឡា',
    'lo'    => 'ភាសាឡាវ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ភាសាលីទុយអានី',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'ភាសាឡាតវីយ៉ា',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'ភាសាម៉ាដាហ្កាសការ',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'ភាសាម៉ោរី',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ភាសាម៉ាសេដូនី',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'ភាសាម៉ាឡាឡាយ៉ាន',
    'mn'    => 'ភាសាម៉ុងហ្គោលី',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'ភាសាម៉ុលដាវី',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ភាសាម៉ារាធី',
    'ms'    => 'ភាសាម៉ាលេស៉ី',
    'mt'    => 'ភាសាម៉ាល់តា',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'ភាសានេប៉ាល់',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ភាសាហុល្លង់',
    'nl_be' => 'Flemish',
    'nn'    => 'ន័រវេ',
    'no'    => 'ភាសាន័រវែស',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'អូសីតាន់',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'ភាសាអូរីយ៉ា',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ភាសាពូនយ៉ាប៊ី',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'ភាសាប៉ូឡូញ',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'បាស្តូ',
    'pt'    => 'ភាសាព័រទុយហ្កាល់',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'ភាសាកេទ្ជូអា',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'ភាសារូន្ឌី',
    'ro'    => 'ភាសារូម៉ានី',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'ភាសាรัរូស្ស៉ី',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'ភាសាសំស្ក្រឹត',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'ភាសាស៉ីន្ដី',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'សើបូក្រូទៀន',
    'shn'   => 'Shan',
    'si'    => 'សីនហាលិស',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ភាសាស្លូវ៉ាគី',
    'sl'    => 'ភាសាស្លូវ៉ានី',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ភាសាសាមូអា',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'ភាសាសូម៉ាលី',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ភាសាអាល់បានី',
    'sr'    => 'សើបៀន',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'សេសូដូ',
    'su'    => 'ភាំសាស៊ូដង់',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ភាសាស៊ុយអែដ',
    'sw'    => 'ភាសាស្វាហ៉ីលី',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'ភាសាតាមីល',
    'tai'   => "Tai\ Language",
    'te'    => 'ភាសាតេលូហ្គូ',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'ភាសាតាដហ្ស៉ីគីស្តង់',
    'th'    => 'ភាសាថៃ',
    'ti'    => 'ទីរិនយា',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'ភាសាទួគមេនីស្តង់',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'ខ្លិងសុន',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'ភាសាតុងហ្គោ',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'ភាសាទួរគី',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'ភាសាតាតារ',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'ទ្វី',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => 'ភាសាអ៊ុយក្រែន',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'ភាសាអ៊ូរ្ឌូ',
    'uz'    => 'ភាសាអ៊ូហ្សបេគីស្តង់',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'ភាសាវៀតណាម',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'ភាសាឃសា',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'ភាសាយីឌីហ្ស',
    'yo'    => 'ភាសាយរូបា',
    'ypk'   => "Yupik\ Language",
    'za'    => 'ភាសាចួង',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ភាសាចិន',
    'znd'   => 'Zande',
    'zu'    => 'ភាសាហ្ស៉ូលូ',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::km::name_to_code = (
    ''                                    => 'zu',
    "\ gd"                                => 'gd',
    'abkhazian'                           => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afrihili'                            => 'afh',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadian'                            => 'akk',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    "apache\ language"                    => 'apa',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'assamese'                            => 'as',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'awadhi'                              => 'awa',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'bashkir'                             => 'ba',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'braj'                                => 'bra',
    "brazilian\ portuguese"               => 'pt_br',
    "british\ english"                    => 'en_gb',
    'buginese'                            => 'bug',
    'buriat'                              => 'bua',
    'burmese'                             => 'my',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'corsican'                            => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hausa'                               => 'ha',
    'hawaiian'                            => 'haw',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    "hiri\ motu"                          => 'ho',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ portuguese"                 => 'pt_pt',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'ingush'                              => 'inh',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    "iranian\ language"                   => 'ira',
    "iroquoian\ language"                 => 'iro',
    'jju'                                 => 'kaj',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalaallisut'                         => 'kl',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kashmiri'                            => 'ks',
    'kashubian'                           => 'csb',
    'kawi'                                => 'kaw',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koro'                                => 'kfo',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'mongo'                               => 'lol',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'nauru'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    "norwegian\ bokml"                    => 'nb',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'rhaetoromance'                       => 'rm',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    'shona'                               => 'sn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'sogdien'                             => 'sog',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'susu'                                => 'sus',
    'swati'                               => 'ss',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'tagalog'                             => 'tl',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'tamashek'                            => 'tmh',
    'taroko'                              => 'trv',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tsimshian'                           => 'tsi',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tyap'                                => 'kcg',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'umbundu'                             => 'umb',
    "unknown\ or\ invalid\ language"      => 'und',
    "upper\ sorbian"                      => 'hsb',
    "us\ english"                         => 'en_us',
    'uyghur'                              => 'ug',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'volapk'                              => 'vo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'wolof'                               => 'wo',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zuni'                                => 'zun',
);

1;
