package Locales::DB::Language::fr;

# Auto generated from CLDR

$Locales::DB::Language::fr::VERSION = '0.01';

$Locales::DB::Language::fr::cldr_version = '1.7.1';

%Locales::DB::Language::fr::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "langue\ \:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "région\ \:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "non\:n",
        'yesstr' => "oui\:o"
    },
);

%Locales::DB::Language::fr::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhaze',
    'ace'   => 'aceh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghéen',
    'ae'    => 'avestique',
    'af'    => 'afrikaans',
    'afa'   => "langue\ afro\-asiatique",
    'afh'   => 'afrihili',
    'ain'   => 'aïnou',
    'ak'    => 'akan',
    'akk'   => 'akkadien',
    'ale'   => 'aléoute',
    'alg'   => "langue\ algonquienne",
    'alt'   => "altaï\ du\ Sud",
    'am'    => 'amharique',
    'an'    => 'aragonais',
    'ang'   => "ancien\ anglais",
    'anp'   => 'angika',
    'apa'   => "langue\ apache",
    'ar'    => 'arabe',
    'arc'   => 'araméen',
    'arn'   => 'araukan',
    'arp'   => 'arapaho',
    'art'   => "langue\ artificielle",
    'arw'   => 'arawak',
    'as'    => 'assamais',
    'ast'   => 'asturien',
    'ath'   => "langue\ athapascane",
    'aus'   => "langue\ australienne",
    'av'    => 'avar',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azéri',
    'ba'    => 'bachkir',
    'bad'   => 'banda',
    'bai'   => "langue\ bamilékée",
    'bal'   => 'baloutchi',
    'ban'   => 'balinais',
    'bas'   => 'bassa',
    'bat'   => "langue\ balte",
    'be'    => 'biélorusse',
    'bej'   => 'bedja',
    'bem'   => 'bemba',
    'ber'   => 'berbère',
    'bg'    => 'bulgare',
    'bh'    => "langue\ biharie",
    'bho'   => 'bhojpuri',
    'bi'    => 'bichelamar',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantou',
    'bo'    => 'tibétain',
    'br'    => 'breton',
    'bra'   => 'braj',
    'bs'    => 'bosniaque',
    'btk'   => 'batak',
    'bua'   => 'bouriate',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalan',
    'cad'   => 'caddo',
    'cai'   => "langue\ amérindienne\ centrale",
    'car'   => 'caribe',
    'cau'   => "langue\ caucasienne",
    'cch'   => 'atsam',
    'ce'    => 'tchétchène',
    'ceb'   => 'cebuano',
    'cel'   => "langue\ celtique",
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'tchaghataï',
    'chk'   => 'chuukais',
    'chm'   => 'mari',
    'chn'   => "jargon\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'chérokî',
    'chy'   => 'cheyenne',
    'cmc'   => "langue\ chame",
    'co'    => 'corse',
    'cop'   => 'copte',
    'cpe'   => "créole\ ou\ pidgin\ anglais",
    'cpf'   => "créole\ ou\ pidgin\ français",
    'cpp'   => "créole\ ou\ pidgin\ portugais",
    'cr'    => 'cree',
    'crh'   => "turc\ de\ Crimée",
    'crp'   => "créole\ ou\ pidgin",
    'cs'    => 'tchèque',
    'csb'   => 'kachoube',
    'cu'    => "slavon\ d’église",
    'cus'   => "langue\ couchitique",
    'cv'    => 'tchouvache',
    'cy'    => 'gallois',
    'da'    => 'danois',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'day'   => "langue\ bidayuh",
    'de'    => 'allemand',
    'de_at' => "allemand\ autrichien",
    'de_ch' => "allemand\ suisse",
    'del'   => 'lenape',
    'den'   => 'slavey',
    'dgr'   => "flanc\-de\-chien",
    'din'   => 'dinka',
    'doi'   => "dogri\-kangri",
    'dra'   => "langue\ dravidienne",
    'dsb'   => "bas\-sorabe",
    'dua'   => 'douala',
    'dum'   => "moyen\ néerlandais",
    'dv'    => 'maldivien',
    'dyu'   => 'dioula',
    'dz'    => 'dzongkha',
    'ee'    => 'éwé',
    'efi'   => 'efik',
    'egy'   => "égyptien\ ancien",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'élamite',
    'en'    => 'anglais',
    'en_au' => "anglais\ australien",
    'en_ca' => "anglais\ canadien",
    'en_gb' => "anglais\ britannique",
    'en_us' => "anglais\ américain",
    'enm'   => "moyen\ anglais",
    'eo'    => 'espéranto',
    'es'    => 'espagnol',
    'es_es' => "espagnol\ ibérique",
    'et'    => 'estonien',
    'eu'    => 'basque',
    'ewo'   => 'éwondo',
    'fa'    => 'persan',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'peul',
    'fi'    => 'finnois',
    'fil'   => 'filipino',
    'fiu'   => "langue\ finno\-ougrienne",
    'fj'    => 'fidjien',
    'fo'    => 'féringien',
    'fon'   => 'fon',
    'fr'    => 'français',
    'fr_ca' => "français\ canadien",
    'fr_ch' => "français\ suisse",
    'frm'   => "moyen\ français",
    'fro'   => "ancien\ français",
    'frr'   => "frison\ du\ Nord",
    'frs'   => "frison\ oriental",
    'fur'   => 'frioulan',
    'fy'    => "frison\ occidental",
    'ga'    => 'irlandais',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaélique\ écossais",
    'gem'   => "langue\ germanique",
    'gez'   => 'guèze',
    'gil'   => 'gilbertin',
    'gl'    => 'galicien',
    'gmh'   => "moyen\ haut\-allemand",
    'gn'    => 'guarani',
    'goh'   => "ancien\ haut\-allemand",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotique',
    'grb'   => 'grébo',
    'grc'   => "grec\ ancien",
    'gsw'   => 'alémanique',
    'gu'    => 'goudjarâtî',
    'gv'    => 'mannois',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haoussa',
    'hai'   => 'haïda',
    'haw'   => 'hawaïen',
    'he'    => 'hébreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croate',
    'hsb'   => "haut\-sorabe",
    'ht'    => 'haïtien',
    'hu'    => 'hongrois',
    'hup'   => 'hupa',
    'hy'    => 'arménien',
    'hz'    => 'héréro',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonésien',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ de\ Sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilokano',
    'inc'   => "langue\ indo\-aryenne",
    'ine'   => "langue\ indo\-européenne",
    'inh'   => 'ingouche',
    'io'    => 'ido',
    'ira'   => "langue\ iranienne",
    'iro'   => "langue\ iroquoienne",
    'is'    => 'islandais',
    'it'    => 'italien',
    'iu'    => 'inuktitut',
    'ja'    => 'japonais',
    'jbo'   => 'lojban',
    'jpr'   => "judéo\-persan",
    'jrb'   => "judéo\-arabe",
    'jv'    => 'javanais',
    'ka'    => 'géorgien',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => "langue\ karène",
    'kaw'   => 'kawi',
    'kbd'   => 'kabardin',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "langue\ khoïsane",
    'kho'   => 'khotanais',
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'groenlandais',
    'km'    => 'khmer',
    'kmb'   => 'kimboundou',
    'kn'    => 'kannara',
    'ko'    => 'coréen',
    'kok'   => 'konkani',
    'kos'   => 'kusaïen',
    'kpe'   => 'kpellé',
    'kr'    => 'kanouri',
    'krc'   => "karatchaï\ balkar",
    'krl'   => 'carélien',
    'kro'   => 'krou',
    'kru'   => 'kurukh',
    'ks'    => 'cachemiri',
    'ku'    => 'kurde',
    'kum'   => 'koumyk',
    'kut'   => 'kutenaï',
    'kv'    => 'komi',
    'kw'    => 'cornique',
    'ky'    => 'kirghize',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxembourgeois',
    'lez'   => 'lezghien',
    'lg'    => 'ganda',
    'li'    => 'limbourgeois',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituanien',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushaï',
    'lv'    => 'letton',
    'mad'   => 'madurais',
    'mag'   => 'magahi',
    'mai'   => 'maïthilî',
    'mak'   => 'makassar',
    'man'   => 'mandingue',
    'map'   => "langue\ malayo\-polynésienne",
    'mas'   => 'massaï',
    'mdf'   => 'mokcha',
    'mdr'   => 'mandar',
    'men'   => 'mendé',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgache',
    'mga'   => "moyen\ irlandais",
    'mh'    => 'marshallais',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "langue\ diverse",
    'mk'    => 'macédonien',
    'mkh'   => "langue\ mon\-khmère",
    'ml'    => 'malayalam',
    'mn'    => 'mongol',
    'mnc'   => 'mandchou',
    'mni'   => 'manipourî',
    'mno'   => "langue\ manobo",
    'mo'    => 'moldave',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathe',
    'ms'    => 'malais',
    'mt'    => 'maltais',
    'mul'   => 'multilingue',
    'mun'   => "langue\ mounda",
    'mus'   => 'creek',
    'mwl'   => 'mirandais',
    'mwr'   => 'marwarî',
    'my'    => 'birman',
    'myn'   => "langue\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauruan',
    'nah'   => 'nahuatl',
    'nai'   => "langue\ amérindienne\ du\ Nord",
    'nap'   => 'napolitain',
    'nb'    => "norvégien\ bokmål",
    'nd'    => "ndébélé\ du\ Nord",
    'nds'   => "bas\-allemand",
    'ne'    => 'népalais',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "langue\ nigéro\-congolaise",
    'niu'   => 'niouéen',
    'nl'    => 'néerlandais',
    'nl_be' => "néerlandais\ belge",
    'nn'    => "norvégien\ nynorsk",
    'no'    => 'norvégien',
    'nog'   => 'nogaï',
    'non'   => "vieux\ norrois",
    'nqo'   => 'n’ko',
    'nr'    => "ndébélé\ du\ Sud",
    'nso'   => "sotho\ du\ Nord",
    'nub'   => "langue\ nubienne",
    'nv'    => 'navaho',
    'nwc'   => "newarî\ classique",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankolé',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occitan',
    'oj'    => 'ojibwé',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossète',
    'osa'   => 'osage',
    'ota'   => "turc\ ottoman",
    'oto'   => "langue\ otomangue",
    'pa'    => 'pendjabi',
    'paa'   => "langue\ papoue",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangan',
    'pap'   => 'papiamento',
    'pau'   => 'paluan',
    'peo'   => "ancien\ persan",
    'phi'   => "langue\ philippine",
    'phn'   => 'phénicien',
    'pi'    => 'pâli',
    'pl'    => 'polonais',
    'pon'   => 'pohnpeï',
    'pra'   => "langue\ prâkrit",
    'pro'   => "ancien\ provençal",
    'ps'    => 'pachto',
    'pt'    => 'portugais',
    'pt_br' => "portugais\ brésilien",
    'pt_pt' => "portugais\ ibérique",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongien',
    'rm'    => "rhéto\-roman",
    'rn'    => 'roundi',
    'ro'    => 'roumain',
    'roa'   => "langue\ romane",
    'rom'   => 'romani',
    'ru'    => 'russe',
    'rup'   => 'aroumain',
    'rw'    => 'rwanda',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'iakoute',
    'sai'   => "langue\ amérindienne\ du\ Sud",
    'sal'   => "langue\ salishenne",
    'sam'   => "araméen\ samaritain",
    'sas'   => 'sasak',
    'sat'   => 'santal',
    'sc'    => 'sarde',
    'scn'   => 'sicilien',
    'sco'   => 'écossais',
    'sd'    => 'sindhî',
    'se'    => "sami\ du\ Nord",
    'sel'   => 'selkoupe',
    'sem'   => "langue\ sémitique",
    'sg'    => 'sangho',
    'sga'   => "ancien\ irlandais",
    'sgn'   => "langue\ des\ signes",
    'sh'    => "serbo\-croate",
    'shn'   => 'shan',
    'si'    => 'cinghalais',
    'sid'   => 'sidamo',
    'sio'   => "langue\ sioux",
    'sit'   => "langue\ sino\-tibétaine",
    'sk'    => 'slovaque',
    'sl'    => 'slovène',
    'sla'   => "langue\ slave",
    'sm'    => 'samoan',
    'sma'   => "sami\ du\ Sud",
    'smi'   => "langue\ samie",
    'smj'   => "sami\ de\ Lule",
    'smn'   => "sami\ d’Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninké',
    'so'    => 'somali',
    'sog'   => 'sogdien',
    'son'   => 'songhaï',
    'sq'    => 'albanais',
    'sr'    => 'serbe',
    'srn'   => "sranan\ tongo",
    'srr'   => 'sérère',
    'ss'    => 'swati',
    'ssa'   => "langue\ nilo\-saharienne",
    'st'    => 'sesotho',
    'su'    => 'soundanais',
    'suk'   => 'sukuma',
    'sus'   => 'soussou',
    'sux'   => 'sumérien',
    'sv'    => 'suédois',
    'sw'    => 'swahili',
    'syc'   => "syriaque\ classique",
    'syr'   => 'syriaque',
    'ta'    => 'tamoul',
    'tai'   => "langue\ taïe",
    'te'    => 'télougou',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tétoum',
    'tg'    => 'tadjik',
    'th'    => 'thaï',
    'ti'    => 'tigrigna',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmène',
    'tkl'   => 'tokelauan',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamacheq',
    'tn'    => 'tswana',
    'to'    => 'tongan',
    'tog'   => "tonga\ nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatar',
    'tum'   => 'tumbuka',
    'tup'   => "langue\ tupie",
    'tut'   => "langue\ altaïque",
    'tvl'   => 'tuvaluan',
    'tw'    => 'twi',
    'ty'    => 'tahitien',
    'tyv'   => 'touva',
    'udm'   => 'oudmourte',
    'ug'    => 'ouïgour',
    'uga'   => 'ougaritique',
    'uk'    => 'ukrainien',
    'umb'   => 'oumboundou',
    'und'   => "langue\ indéterminée",
    'ur'    => 'ourdou',
    'uz'    => 'ouzbek',
    'vai'   => 'vaï',
    've'    => 'venda',
    'vi'    => 'vietnamien',
    'vo'    => 'volapük',
    'vot'   => 'vote',
    'wa'    => 'wallon',
    'wak'   => "langue\ wakashenne",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "langue\ sorabe",
    'wo'    => 'wolof',
    'xal'   => 'kalmouk',
    'xh'    => 'xhosa',
    'yao'   => 'yao',
    'yap'   => 'yapois',
    'yi'    => 'yiddish',
    'yo'    => 'yoruba',
    'ypk'   => "langue\ yupik",
    'za'    => 'zhouang',
    'zap'   => 'zapotèque',
    'zbl'   => "symboles\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chinois',
    'znd'   => 'zandé',
    'zu'    => 'zoulou',
    'zun'   => 'zuni',
    'zxx'   => "\(sans\ contenu\ linguistique\)",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::fr::name_to_code = (
    'abkhaze'                       => 'ab',
    'aceh'                          => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghen'                       => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikaans'                     => 'af',
    'akan'                          => 'ak',
    'akkadien'                      => 'akk',
    'albanais'                      => 'sq',
    'allemand'                      => 'de',
    "allemand\ autrichien"          => 'de_at',
    "allemand\ suisse"              => 'de_ch',
    'almanique'                     => 'gsw',
    'aloute'                        => 'ale',
    "alta\ du\ sud"                 => 'alt',
    'amharique'                     => 'am',
    "ancien\ anglais"               => 'ang',
    "ancien\ franais"               => 'fro',
    "ancien\ hautallemand"          => 'goh',
    "ancien\ irlandais"             => 'sga',
    "ancien\ persan"                => 'peo',
    "ancien\ provenal"              => 'pro',
    'angika'                        => 'anp',
    'anglais'                       => 'en',
    "anglais\ amricain"             => 'en_us',
    "anglais\ australien"           => 'en_au',
    "anglais\ britannique"          => 'en_gb',
    "anglais\ canadien"             => 'en_ca',
    'anou'                          => 'ain',
    'arabe'                         => 'ar',
    'aragonais'                     => 'an',
    'aramen'                        => 'arc',
    "aramen\ samaritain"            => 'sam',
    'arapaho'                       => 'arp',
    'araukan'                       => 'arn',
    'arawak'                        => 'arw',
    'armnien'                       => 'hy',
    'aroumain'                      => 'rup',
    'assamais'                      => 'as',
    'asturien'                      => 'ast',
    'atsam'                         => 'cch',
    'avar'                          => 'av',
    'avestique'                     => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'azri'                          => 'az',
    'bachkir'                       => 'ba',
    'balinais'                      => 'ban',
    'baloutchi'                     => 'bal',
    'bambara'                       => 'bm',
    'banda'                         => 'bad',
    'bantou'                        => 'bnt',
    'basallemand'                   => 'nds',
    'basque'                        => 'eu',
    'bassa'                         => 'bas',
    'bassorabe'                     => 'dsb',
    'batak'                         => 'btk',
    'bedja'                         => 'bej',
    'bemba'                         => 'bem',
    'bengali'                       => 'bn',
    'berbre'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bichelamar'                    => 'bi',
    'bikol'                         => 'bik',
    'bilorusse'                     => 'be',
    'bini'                          => 'bin',
    'birman'                        => 'my',
    'blin'                          => 'byn',
    'bosniaque'                     => 'bs',
    'bouriate'                      => 'bua',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'bugi'                          => 'bug',
    'bulgare'                       => 'bg',
    'cachemiri'                     => 'ks',
    'caddo'                         => 'cad',
    'caribe'                        => 'car',
    'carlien'                       => 'krl',
    'catalan'                       => 'ca',
    'cebuano'                       => 'ceb',
    'chamorro'                      => 'ch',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinois'                       => 'zh',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'chrok'                         => 'chr',
    'chuukais'                      => 'chk',
    'cinghalais'                    => 'si',
    'copte'                         => 'cop',
    'coren'                         => 'ko',
    'cornique'                      => 'kw',
    'corse'                         => 'co',
    'cossais'                       => 'sco',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'croate'                        => 'hr',
    "crole\ ou\ pidgin"             => 'crp',
    "crole\ ou\ pidgin\ anglais"    => 'cpe',
    "crole\ ou\ pidgin\ franais"    => 'cpf',
    "crole\ ou\ pidgin\ portugais"  => 'cpp',
    'dakota'                        => 'dak',
    'danois'                        => 'da',
    'dargwa'                        => 'dar',
    'dinka'                         => 'din',
    'dioula'                        => 'dyu',
    'dogrikangri'                   => 'doi',
    'douala'                        => 'dua',
    'dzongkha'                      => 'dz',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'erzya'                         => 'myv',
    'espagnol'                      => 'es',
    "espagnol\ ibrique"             => 'es_es',
    'espranto'                      => 'eo',
    'estonien'                      => 'et',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fidjien'                       => 'fj',
    'filipino'                      => 'fil',
    'finnois'                       => 'fi',
    'flancdechien'                  => 'dgr',
    'fon'                           => 'fon',
    'franais'                       => 'fr',
    "franais\ canadien"             => 'fr_ca',
    "franais\ suisse"               => 'fr_ch',
    'fringien'                      => 'fo',
    'frioulan'                      => 'fur',
    "frison\ du\ nord"              => 'frr',
    "frison\ occidental"            => 'fy',
    "frison\ oriental"              => 'frs',
    'ga'                            => 'gaa',
    'galicien'                      => 'gl',
    "galique\ cossais"              => 'gd',
    'gallois'                       => 'cy',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'gilbertin'                     => 'gil',
    'gondi'                         => 'gon',
    'gorgien'                       => 'ka',
    'gorontalo'                     => 'gor',
    'gotique'                       => 'got',
    'goudjart'                      => 'gu',
    'grbo'                          => 'grb',
    'grec'                          => 'el',
    "grec\ ancien"                  => 'grc',
    'groenlandais'                  => 'kl',
    'guarani'                       => 'gn',
    'guze'                          => 'gez',
    'gwichin'                       => 'gwi',
    "gyptien\ ancien"               => 'egy',
    'hada'                          => 'hai',
    'haoussa'                       => 'ha',
    'hatien'                        => 'ht',
    'hautsorabe'                    => 'hsb',
    'hawaen'                        => 'haw',
    'hbreu'                         => 'he',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hindi'                         => 'hi',
    "hiri\ motu"                    => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hongrois'                      => 'hu',
    'hrro'                          => 'hz',
    'hupa'                          => 'hup',
    'iakoute'                       => 'sah',
    'iban'                          => 'iba',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'ilokano'                       => 'ilo',
    'indonsien'                     => 'id',
    'ingouche'                      => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'irlandais'                     => 'ga',
    'islandais'                     => 'is',
    'italien'                       => 'it',
    'japonais'                      => 'ja',
    "jargon\ chinook"               => 'chn',
    'javanais'                      => 'jv',
    'jju'                           => 'kaj',
    'judoarabe'                     => 'jrb',
    'judopersan'                    => 'jpr',
    'kabardin'                      => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kachoube'                      => 'csb',
    'kalmouk'                       => 'xal',
    'kamba'                         => 'kam',
    'kannara'                       => 'kn',
    'kanouri'                       => 'kr',
    'karakalpak'                    => 'kaa',
    "karatcha\ balkar"              => 'krc',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khmer'                         => 'km',
    'khotanais'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimboundou'                    => 'kmb',
    'kirghize'                      => 'ky',
    'klingon'                       => 'tlh',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'koumyk'                        => 'kum',
    'kpell'                         => 'kpe',
    'krou'                          => 'kro',
    'kuanyama'                      => 'kj',
    'kurde'                         => 'ku',
    'kurukh'                        => 'kru',
    'kusaen'                        => 'kos',
    'kutena'                        => 'kut',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lamite'                        => 'elx',
    "langue\ afroasiatique"         => 'afa',
    "langue\ algonquienne"          => 'alg',
    "langue\ altaque"               => 'tut',
    "langue\ amrindienne\ centrale" => 'cai',
    "langue\ amrindienne\ du\ nord" => 'nai',
    "langue\ amrindienne\ du\ sud"  => 'sai',
    "langue\ apache"                => 'apa',
    "langue\ artificielle"          => 'art',
    "langue\ athapascane"           => 'ath',
    "langue\ australienne"          => 'aus',
    "langue\ balte"                 => 'bat',
    "langue\ bamilke"               => 'bai',
    "langue\ bidayuh"               => 'day',
    "langue\ biharie"               => 'bh',
    "langue\ caucasienne"           => 'cau',
    "langue\ celtique"              => 'cel',
    "langue\ chame"                 => 'cmc',
    "langue\ couchitique"           => 'cus',
    "langue\ des\ signes"           => 'sgn',
    "langue\ diverse"               => 'mis',
    "langue\ dravidienne"           => 'dra',
    "langue\ finnoougrienne"        => 'fiu',
    "langue\ germanique"            => 'gem',
    "langue\ indoaryenne"           => 'inc',
    "langue\ indoeuropenne"         => 'ine',
    "langue\ indtermine"            => 'und',
    "langue\ iranienne"             => 'ira',
    "langue\ iroquoienne"           => 'iro',
    "langue\ karne"                 => 'kar',
    "langue\ khosane"               => 'khi',
    "langue\ malayopolynsienne"     => 'map',
    "langue\ manobo"                => 'mno',
    "langue\ maya"                  => 'myn',
    "langue\ monkhmre"              => 'mkh',
    "langue\ mounda"                => 'mun',
    "langue\ nigrocongolaise"       => 'nic',
    "langue\ nilosaharienne"        => 'ssa',
    "langue\ nubienne"              => 'nub',
    "langue\ otomangue"             => 'oto',
    "langue\ papoue"                => 'paa',
    "langue\ philippine"            => 'phi',
    "langue\ prkrit"                => 'pra',
    "langue\ romane"                => 'roa',
    "langue\ salishenne"            => 'sal',
    "langue\ samie"                 => 'smi',
    "langue\ sinotibtaine"          => 'sit',
    "langue\ sioux"                 => 'sio',
    "langue\ slave"                 => 'sla',
    "langue\ smitique"              => 'sem',
    "langue\ sorabe"                => 'wen',
    "langue\ tae"                   => 'tai',
    "langue\ tupie"                 => 'tup',
    "langue\ wakashenne"            => 'wak',
    "langue\ yupik"                 => 'ypk',
    'lao'                           => 'lo',
    'latin'                         => 'la',
    'lenape'                        => 'del',
    'letton'                        => 'lv',
    'lezghien'                      => 'lez',
    'limbourgeois'                  => 'li',
    'lingala'                       => 'ln',
    'lituanien'                     => 'lt',
    'lojban'                        => 'jbo',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lusha'                         => 'lus',
    'luxembourgeois'                => 'lb',
    'macdonien'                     => 'mk',
    'madurais'                      => 'mad',
    'magahi'                        => 'mag',
    'makassar'                      => 'mak',
    'malais'                        => 'ms',
    'malayalam'                     => 'ml',
    'maldivien'                     => 'dv',
    'malgache'                      => 'mg',
    'maltais'                       => 'mt',
    'mandar'                        => 'mdr',
    'mandchou'                      => 'mnc',
    'mandingue'                     => 'man',
    'manipour'                      => 'mni',
    'mannois'                       => 'gv',
    'maori'                         => 'mi',
    'marathe'                       => 'mr',
    'mari'                          => 'chm',
    'marshallais'                   => 'mh',
    'marwar'                        => 'mwr',
    'massa'                         => 'mas',
    'mathil'                        => 'mai',
    'mend'                          => 'men',
    'micmac'                        => 'mic',
    'minangkabau'                   => 'min',
    'mirandais'                     => 'mwl',
    'mohawk'                        => 'moh',
    'mokcha'                        => 'mdf',
    'moldave'                       => 'mo',
    'mongo'                         => 'lol',
    'mongol'                        => 'mn',
    'mor'                           => 'mos',
    'morisyen'                      => 'mfe',
    "moyen\ anglais"                => 'enm',
    "moyen\ franais"                => 'frm',
    "moyen\ hautallemand"           => 'gmh',
    "moyen\ irlandais"              => 'mga',
    "moyen\ nerlandais"             => 'dum',
    'multilingue'                   => 'mul',
    'nahuatl'                       => 'nah',
    'napolitain'                    => 'nap',
    'nauruan'                       => 'na',
    'navaho'                        => 'nv',
    "ndbl\ du\ nord"                => 'nd',
    "ndbl\ du\ sud"                 => 'nr',
    'ndonga'                        => 'ng',
    'nerlandais'                    => 'nl',
    "nerlandais\ belge"             => 'nl_be',
    "newar\ classique"              => 'nwc',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'niouen'                        => 'niu',
    'nko'                           => 'nqo',
    'noga'                          => 'nog',
    'norvgien'                      => 'no',
    "norvgien\ bokml"               => 'nb',
    "norvgien\ nynorsk"             => 'nn',
    'npalais'                       => 'ne',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankol'                       => 'nyn',
    'nyoro'                         => 'nyo',
    'nzema'                         => 'nzi',
    'occitan'                       => 'oc',
    'ojibw'                         => 'oj',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'osste'                         => 'os',
    'oudmourte'                     => 'udm',
    'ougaritique'                   => 'uga',
    'ougour'                        => 'ug',
    'oumboundou'                    => 'umb',
    'ourdou'                        => 'ur',
    'ouzbek'                        => 'uz',
    'pachto'                        => 'ps',
    'pahlavi'                       => 'pal',
    'paluan'                        => 'pau',
    'pampangan'                     => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'pendjabi'                      => 'pa',
    'persan'                        => 'fa',
    'peul'                          => 'ff',
    'phnicien'                      => 'phn',
    'pli'                           => 'pi',
    'pohnpe'                        => 'pon',
    'polonais'                      => 'pl',
    'portugais'                     => 'pt',
    "portugais\ brsilien"           => 'pt_br',
    "portugais\ ibrique"            => 'pt_pt',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongien'                   => 'rar',
    'rhtoroman'                     => 'rm',
    'romani'                        => 'rom',
    'roumain'                       => 'ro',
    'roundi'                        => 'rn',
    'russe'                         => 'ru',
    'rwanda'                        => 'rw',
    "sami\ de\ lule"                => 'smj',
    "sami\ dinari"                  => 'smn',
    "sami\ du\ nord"                => 'se',
    "sami\ du\ sud"                 => 'sma',
    "sami\ skolt"                   => 'sms',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sangho'                        => 'sg',
    "sans\ contenu\ linguistique"   => 'zxx',
    'sanskrit'                      => 'sa',
    'santal'                        => 'sat',
    'sarde'                         => 'sc',
    'sasak'                         => 'sas',
    'selkoupe'                      => 'sel',
    'serbe'                         => 'sr',
    'serbocroate'                   => 'sh',
    'sesotho'                       => 'st',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sicilien'                      => 'scn',
    'sidamo'                        => 'sid',
    'siksika'                       => 'bla',
    'sindh'                         => 'sd',
    'slavey'                        => 'den',
    "slavon\ dglise"                => 'cu',
    'slovaque'                      => 'sk',
    'slovne'                        => 'sl',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songha'                        => 'son',
    'sonink'                        => 'snk',
    "sotho\ du\ nord"               => 'nso',
    'soundanais'                    => 'su',
    'soussou'                       => 'sus',
    "sranan\ tongo"                 => 'srn',
    'srre'                          => 'srr',
    'sudois'                        => 'sv',
    'sukuma'                        => 'suk',
    'sumrien'                       => 'sux',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    "symboles\ bliss"               => 'zbl',
    'syriaque'                      => 'syr',
    "syriaque\ classique"           => 'syc',
    'tadjik'                        => 'tg',
    'tagalog'                       => 'tl',
    'tahitien'                      => 'ty',
    'tamacheq'                      => 'tmh',
    'tamoul'                        => 'ta',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'tchaghata'                     => 'chg',
    'tchouvache'                    => 'cv',
    'tchque'                        => 'cs',
    'tchtchne'                      => 'ce',
    'temne'                         => 'tem',
    'tereno'                        => 'ter',
    'tha'                           => 'th',
    'tibtain'                       => 'bo',
    'tigr'                          => 'tig',
    'tigrigna'                      => 'ti',
    'tivi'                          => 'tiv',
    'tlingit'                       => 'tli',
    'tlougou'                       => 'te',
    "tok\ pisin"                    => 'tpi',
    'tokelauan'                     => 'tkl',
    "tonga\ nyasa"                  => 'tog',
    'tongan'                        => 'to',
    'touva'                         => 'tyv',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'ttoum'                         => 'tet',
    'tumbuka'                       => 'tum',
    'turc'                          => 'tr',
    "turc\ de\ crime"               => 'crh',
    "turc\ ottoman"                 => 'ota',
    'turkmne'                       => 'tk',
    'tuvaluan'                      => 'tvl',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    'ukrainien'                     => 'uk',
    'va'                            => 'vai',
    'venda'                         => 've',
    'vietnamien'                    => 'vi',
    "vieux\ norrois"                => 'non',
    'volapk'                        => 'vo',
    'vote'                          => 'vot',
    'w'                             => 'ee',
    'walamo'                        => 'wal',
    'wallon'                        => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'wondo'                         => 'ewo',
    'xhosa'                         => 'xh',
    'yao'                           => 'yao',
    'yapois'                        => 'yap',
    "yi\ de\ sichuan"               => 'ii',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'zand'                          => 'znd',
    'zapotque'                      => 'zap',
    'zazaki'                        => 'zza',
    'zenaga'                        => 'zen',
    'zhouang'                       => 'za',
    'zoulou'                        => 'zu',
    'zuni'                          => 'zun',
);

1;
