package Locales::DB::Language::eo;

# Auto generated from CLDR

$Locales::DB::Language::eo::VERSION = '0.01';

$Locales::DB::Language::eo::cldr_version = '1.7.1';

%Locales::DB::Language::eo::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::eo::code_to_name = (
    'aa'    => 'afara',
    'ab'    => 'abĥaza',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikansa',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'amhara',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'araba',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'asama',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'ajmara',
    'az'    => 'azerbajĝana',
    'ba'    => 'baŝkira',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'belorusa',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'bulgara',
    'bh'    => 'bihara',
    'bho'   => 'Bhojpuri',
    'bi'    => 'bislamo',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'bengala',
    'bnt'   => 'Bantu',
    'bo'    => 'tibeta',
    'br'    => 'bretona',
    'bra'   => 'Braj',
    'bs'    => 'bosnia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'kataluna',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'korsika',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ĉeĥa',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'kimra',
    'da'    => 'dana',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'germana',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'dzonko',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'greka',
    'elx'   => 'Elamite',
    'en'    => 'angla',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'esperanto',
    'es'    => 'hispana',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estona',
    'eu'    => 'eŭska',
    'ewo'   => 'Ewondo',
    'fa'    => 'persa',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'finna',
    'fil'   => 'filipina',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'fiĝia',
    'fo'    => 'feroa',
    'fon'   => 'Fon',
    'fr'    => 'franca',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'frisa',
    'ga'    => 'irlanda',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => 'gaela',
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'galega',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'gvarania',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'guĝarata',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'haŭsa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'hebrea',
    'hi'    => 'hinda',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'kroata',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'hungara',
    'hup'   => 'Hupa',
    'hy'    => 'armena',
    'hz'    => 'Herero',
    'ia'    => 'interlingvao',
    'iba'   => 'Iban',
    'id'    => 'indonezia',
    'ie'    => 'okcidentalo',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'eskima',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'islanda',
    'it'    => 'itala',
    'iu'    => 'inuita',
    'ja'    => 'japana',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'java',
    'ka'    => 'kartvela',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'kazaĥa',
    'kl'    => 'gronlanda',
    'km'    => 'kmera',
    'kmb'   => 'Kimbundu',
    'kn'    => 'kanara',
    'ko'    => 'korea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'kaŝmira',
    'ku'    => 'kurda',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'kirgiza',
    'la'    => 'latino',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingala',
    'lo'    => 'laŭa',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'litova',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'latva',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasa',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'maoria',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'makedona',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'malajalama',
    'mn'    => 'mongola',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'marata',
    'ms'    => 'malaja',
    'mt'    => 'malta',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'birma',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'naura',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'nepala',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'nederlanda',
    'nl_be' => 'Flemish',
    'nn'    => 'novnorvega',
    'no'    => 'norvega',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'okcitana',
    'oj'    => 'Ojibwa',
    'om'    => 'oroma',
    'or'    => 'orijo',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'panĝaba',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'pola',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'paŝtua',
    'pt'    => 'portugala',
    'pt_br' => 'brazilportugala',
    'pt_pt' => 'portugalportugala',
    'qu'    => 'keĉua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'romanĉa',
    'rn'    => 'burunda',
    'ro'    => 'rumana',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'rusa',
    'rup'   => 'Aromanian',
    'rw'    => 'ruanda',
    'sa'    => 'sanskrito',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'sinda',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'sangoa',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "serbo\-Kroata",
    'shn'   => 'Shan',
    'si'    => 'sinhala',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'slovaka',
    'sl'    => 'slovena',
    'sla'   => "Slavic\ Language",
    'sm'    => 'samoa',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'ŝona',
    'snk'   => 'Soninke',
    'so'    => 'somala',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'albana',
    'sr'    => 'serba',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'svazia',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'sota',
    'su'    => 'sunda',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'sveda',
    'sw'    => 'svahila',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamila',
    'tai'   => "Tai\ Language",
    'te'    => 'telugua',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'taĝika',
    'th'    => 'taja',
    'ti'    => 'tigraja',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'turkmena',
    'tkl'   => 'Tokelau',
    'tl'    => 'tagaloga',
    'tlh'   => 'klingona',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'cvana',
    'to'    => 'tongaa',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'turka',
    'trv'   => 'Taroko',
    'ts'    => 'conga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'tatara',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'akana',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ujgura',
    'uga'   => 'Ugaritic',
    'uk'    => 'ukraina',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => 'urduo',
    'uz'    => 'uzbeka',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'vjetnama',
    'vo'    => 'volapuko',
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'volofa',
    'xal'   => 'Kalmyk',
    'xh'    => 'ksosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'jida',
    'yo'    => 'joruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'ĝuanga',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ĉina',
    'znd'   => 'Zande',
    'zu'    => 'zulua',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::eo::name_to_code = (
    'abaza'                               => 'ab',
    'achinese'                            => 'ace',
    'acoli'                               => 'ach',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afara'                               => 'aa',
    'afrihili'                            => 'afh',
    'afrikansa'                           => 'af',
    "afroasiatic\ language"               => 'afa',
    'ainu'                                => 'ain',
    'ajmara'                              => 'ay',
    'akan'                                => 'ak',
    'akana'                               => 'tw',
    'akkadian'                            => 'akk',
    'albana'                              => 'sq',
    'aleut'                               => 'ale',
    "algonquian\ language"                => 'alg',
    "altaic\ language"                    => 'tut',
    'amhara'                              => 'am',
    "ancient\ egyptian"                   => 'egy',
    "ancient\ greek"                      => 'grc',
    'angika'                              => 'anp',
    'angla'                               => 'en',
    "apache\ language"                    => 'apa',
    'araba'                               => 'ar',
    'aragonese'                           => 'an',
    'aramaic'                             => 'arc',
    'arapaho'                             => 'arp',
    'araucanian'                          => 'arn',
    'arawak'                              => 'arw',
    'armena'                              => 'hy',
    'aromanian'                           => 'rup',
    "artificial\ language"                => 'art',
    'asama'                               => 'as',
    'asturian'                            => 'ast',
    "athapascan\ language"                => 'ath',
    'atsam'                               => 'cch',
    "australian\ english"                 => 'en_au',
    "australian\ language"                => 'aus',
    "austrian\ german"                    => 'de_at',
    "austronesian\ language"              => 'map',
    'avaric'                              => 'av',
    'avestan'                             => 'ae',
    'awadhi'                              => 'awa',
    'azerbajana'                          => 'az',
    'bakira'                              => 'ba',
    'balinese'                            => 'ban',
    "baltic\ language"                    => 'bat',
    'baluchi'                             => 'bal',
    'bambara'                             => 'bm',
    "bamileke\ language"                  => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'belorusa'                            => 'be',
    'bemba'                               => 'bem',
    'bengala'                             => 'bn',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bihara'                              => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'birma'                               => 'my',
    'bislamo'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbols'                         => 'zbl',
    'bosnia'                              => 'bs',
    'braj'                                => 'bra',
    'brazilportugala'                     => 'pt_br',
    'bretona'                             => 'br',
    "british\ english"                    => 'en_gb',
    'buginese'                            => 'bug',
    'bulgara'                             => 'bg',
    'buriat'                              => 'bua',
    'burunda'                             => 'rn',
    'caddo'                               => 'cad',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    'carib'                               => 'car',
    "caucasian\ language"                 => 'cau',
    'cebuano'                             => 'ceb',
    "celtic\ language"                    => 'cel',
    "central\ american\ indian\ language" => 'cai',
    'chagatai'                            => 'chg',
    "chamic\ language"                    => 'cmc',
    'chamorro'                            => 'ch',
    'chechen'                             => 'ce',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    "chinook\ jargon"                     => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    "church\ slavic"                      => 'cu',
    'chuukese'                            => 'chk',
    'chuvash'                             => 'cv',
    "classical\ newari"                   => 'nwc',
    "classical\ syriac"                   => 'syc',
    'conga'                               => 'ts',
    'coptic'                              => 'cop',
    'cornish'                             => 'kw',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    "creole\ or\ pidgin"                  => 'crp',
    "crimean\ turkish"                    => 'crh',
    "cushitic\ language"                  => 'cus',
    'cvana'                               => 'tn',
    'dakota'                              => 'dak',
    'dana'                                => 'da',
    'dargwa'                              => 'dar',
    'dayak'                               => 'day',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    "dravidian\ language"                 => 'dra',
    'duala'                               => 'dua',
    'dyula'                               => 'dyu',
    'dzonko'                              => 'dz',
    'ea'                                  => 'cs',
    "eastern\ frisian"                    => 'frs',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamite'                             => 'elx',
    "englishbased\ creole\ or\ pidgin"    => 'cpe',
    'erzya'                               => 'myv',
    'eska'                                => 'eu',
    'eskima'                              => 'ik',
    'esperanto'                           => 'eo',
    'estona'                              => 'et',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'feroa'                               => 'fo',
    'fiia'                                => 'fj',
    'filipina'                            => 'fil',
    'finna'                               => 'fi',
    "finnougrian\ language"               => 'fiu',
    'flemish'                             => 'nl_be',
    'fon'                                 => 'fon',
    'franca'                              => 'fr',
    "frenchbased\ creole\ or\ pidgin"     => 'cpf',
    'frisa'                               => 'fy',
    'friulian'                            => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'gaela'                               => 'gd',
    'galega'                              => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'geez'                                => 'gez',
    'germana'                             => 'de',
    "germanic\ language"                  => 'gem',
    'gilbertese'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothic'                              => 'got',
    'grebo'                               => 'grb',
    'greka'                               => 'el',
    'gronlanda'                           => 'kl',
    'guarata'                             => 'gu',
    'gvarania'                            => 'gn',
    'gwichin'                             => 'gwi',
    'haida'                               => 'hai',
    'haitian'                             => 'ht',
    'hasa'                                => 'ha',
    'hawaiian'                            => 'haw',
    'hebrea'                              => 'he',
    'herero'                              => 'hz',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hinda'                               => 'hi',
    "hiri\ motu"                          => 'ho',
    'hispana'                             => 'es',
    'hittite'                             => 'hit',
    'hmong'                               => 'hmn',
    'hungara'                             => 'hu',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    "iberian\ spanish"                    => 'es_es',
    'ido'                                 => 'io',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'iloko'                               => 'ilo',
    'ina'                                 => 'zh',
    "inari\ sami"                         => 'smn',
    "indic\ language"                     => 'inc',
    "indoeuropean\ language"              => 'ine',
    'indonezia'                           => 'id',
    'ingush'                              => 'inh',
    'interlingvao'                        => 'ia',
    'inuita'                              => 'iu',
    "iranian\ language"                   => 'ira',
    'irlanda'                             => 'ga',
    "iroquoian\ language"                 => 'iro',
    'islanda'                             => 'is',
    'itala'                               => 'it',
    'japana'                              => 'ja',
    'java'                                => 'jv',
    'jida'                                => 'yi',
    'jju'                                 => 'kaj',
    'joruba'                              => 'yo',
    'judeoarabic'                         => 'jrb',
    'judeopersian'                        => 'jpr',
    'kabardian'                           => 'kbd',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kamira'                              => 'ks',
    'kanara'                              => 'kn',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpak'                          => 'kaa',
    'karelian'                            => 'krl',
    'karen'                               => 'kar',
    'kartvela'                            => 'ka',
    'kashubian'                           => 'csb',
    'kataluna'                            => 'ca',
    'kawi'                                => 'kaw',
    'kazaa'                               => 'kk',
    'keua'                                => 'qu',
    'khasi'                               => 'kha',
    "khoisan\ language"                   => 'khi',
    'khotanese'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kimra'                               => 'cy',
    'kirgiza'                             => 'ky',
    'klingona'                            => 'tlh',
    'kmera'                               => 'km',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'korea'                               => 'ko',
    'koro'                                => 'kfo',
    'korsika'                             => 'co',
    'kosraean'                            => 'kos',
    'kpelle'                              => 'kpe',
    'kroata'                              => 'hr',
    'kru'                                 => 'kro',
    'ksosa'                               => 'xh',
    'kuanyama'                            => 'kj',
    'kumyk'                               => 'kum',
    'kurda'                               => 'ku',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'laa'                                 => 'lo',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'latino'                              => 'la',
    'latva'                               => 'lv',
    'lezghian'                            => 'lez',
    'limburgish'                          => 'li',
    'lingala'                             => 'ln',
    'litova'                              => 'lt',
    'lojban'                              => 'jbo',
    "low\ german"                         => 'nds',
    "lower\ sorbian"                      => 'dsb',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luiseno'                             => 'lui',
    "lule\ sami"                          => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxembourgish'                       => 'lb',
    'madurese'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makasar'                             => 'mak',
    'makedona'                            => 'mk',
    'malagasa'                            => 'mg',
    'malaja'                              => 'ms',
    'malajalama'                          => 'ml',
    'malta'                               => 'mt',
    'manchu'                              => 'mnc',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipuri'                            => 'mni',
    "manobo\ language"                    => 'mno',
    'manx'                                => 'gv',
    'maoria'                              => 'mi',
    'marata'                              => 'mr',
    'mari'                                => 'chm',
    'marshallese'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    "mayan\ language"                     => 'myn',
    'mende'                               => 'men',
    'micmac'                              => 'mic',
    "middle\ dutch"                       => 'dum',
    "middle\ english"                     => 'enm',
    "middle\ french"                      => 'frm',
    "middle\ high\ german"                => 'gmh',
    "middle\ irish"                       => 'mga',
    'minangkabau'                         => 'min',
    'mirandese'                           => 'mwl',
    "miscellaneous\ language"             => 'mis',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavian'                           => 'mo',
    'mongo'                               => 'lol',
    'mongola'                             => 'mn',
    "monkhmer\ language"                  => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    "multiple\ languages"                 => 'mul',
    "munda\ language"                     => 'mun',
    'nahuatl'                             => 'nah',
    'naura'                               => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'neapolitan'                          => 'nap',
    'nederlanda'                          => 'nl',
    'nepala'                              => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    "nigerkordofanian\ language"          => 'nic',
    "nilosaharan\ language"               => 'ssa',
    'niuean'                              => 'niu',
    'nko'                                 => 'nqo',
    "no\ linguistic\ content"             => 'zxx',
    'nogai'                               => 'nog',
    "north\ american\ indian\ language"   => 'nai',
    "north\ ndebele"                      => 'nd',
    "northern\ frisian"                   => 'frr',
    "northern\ sami"                      => 'se',
    "northern\ sotho"                     => 'nso',
    'norvega'                             => 'no',
    "norwegian\ bokml"                    => 'nb',
    'novnorvega'                          => 'nn',
    "nubian\ language"                    => 'nub',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    "nyasa\ tonga"                        => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'ojibwa'                              => 'oj',
    'okcidentalo'                         => 'ie',
    'okcitana'                            => 'oc',
    "old\ english"                        => 'ang',
    "old\ french"                         => 'fro',
    "old\ high\ german"                   => 'goh',
    "old\ irish"                          => 'sga',
    "old\ norse"                          => 'non',
    "old\ persian"                        => 'peo',
    "old\ provenal"                       => 'pro',
    'ona'                                 => 'sn',
    'orijo'                               => 'or',
    'oroma'                               => 'om',
    'osage'                               => 'osa',
    'ossetic'                             => 'os',
    "otomian\ language"                   => 'oto',
    "ottoman\ turkish"                    => 'ota',
    'pahlavi'                             => 'pal',
    'palauan'                             => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'panaba'                              => 'pa',
    'pangasinan'                          => 'pag',
    'papiamento'                          => 'pap',
    "papuan\ language"                    => 'paa',
    'patua'                               => 'ps',
    'persa'                               => 'fa',
    "philippine\ language"                => 'phi',
    'phoenician'                          => 'phn',
    'pohnpeian'                           => 'pon',
    'pola'                                => 'pl',
    'portugala'                           => 'pt',
    'portugalportugala'                   => 'pt_pt',
    "portuguesebased\ creole\ or\ pidgin" => 'cpp',
    "prakrit\ language"                   => 'pra',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'romana'                              => 'rm',
    "romance\ language"                   => 'roa',
    'romany'                              => 'rom',
    'ruanda'                              => 'rw',
    'rumana'                              => 'ro',
    'rusa'                                => 'ru',
    "salishan\ language"                  => 'sal',
    "samaritan\ aramaic"                  => 'sam',
    "sami\ language"                      => 'smi',
    'samoa'                               => 'sm',
    'sandawe'                             => 'sad',
    'sangoa'                              => 'sg',
    'sanskrito'                           => 'sa',
    'santali'                             => 'sat',
    'sardinian'                           => 'sc',
    'sasak'                               => 'sas',
    'scots'                               => 'sco',
    'selkup'                              => 'sel',
    "semitic\ language"                   => 'sem',
    'serba'                               => 'sr',
    'serbokroata'                         => 'sh',
    'serer'                               => 'srr',
    'shan'                                => 'shn',
    "sichuan\ yi"                         => 'ii',
    'sicilian'                            => 'scn',
    'sidamo'                              => 'sid',
    "sign\ language"                      => 'sgn',
    'siksika'                             => 'bla',
    'sinda'                               => 'sd',
    'sinhala'                             => 'si',
    "sinotibetan\ language"               => 'sit',
    "siouan\ language"                    => 'sio',
    "skolt\ sami"                         => 'sms',
    'slave'                               => 'den',
    "slavic\ language"                    => 'sla',
    'slovaka'                             => 'sk',
    'slovena'                             => 'sl',
    'sogdien'                             => 'sog',
    'somala'                              => 'so',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    "sorbian\ language"                   => 'wen',
    'sota'                                => 'st',
    "south\ american\ indian\ language"   => 'sai',
    "south\ ndebele"                      => 'nr',
    "southern\ altai"                     => 'alt',
    "southern\ sami"                      => 'sma',
    "sranan\ tongo"                       => 'srn',
    'sukuma'                              => 'suk',
    'sumerian'                            => 'sux',
    'sunda'                               => 'su',
    'susu'                                => 'sus',
    'svahila'                             => 'sw',
    'svazia'                              => 'ss',
    'sveda'                               => 'sv',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ german"                       => 'gsw',
    "swiss\ high\ german"                 => 'de_ch',
    'syriac'                              => 'syr',
    'tagaloga'                            => 'tl',
    'tahitian'                            => 'ty',
    "tai\ language"                       => 'tai',
    'taika'                               => 'tg',
    'taja'                                => 'th',
    'tamashek'                            => 'tmh',
    'tamila'                              => 'ta',
    'taroko'                              => 'trv',
    'tatara'                              => 'tt',
    'telugua'                             => 'te',
    'tereno'                              => 'ter',
    'tetum'                               => 'tet',
    'tibeta'                              => 'bo',
    'tigraja'                             => 'ti',
    'tigre'                               => 'tig',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    "tok\ pisin"                          => 'tpi',
    'tokelau'                             => 'tkl',
    'tongaa'                              => 'to',
    'tsimshian'                           => 'tsi',
    'tumbuka'                             => 'tum',
    "tupi\ language"                      => 'tup',
    'turka'                               => 'tr',
    'turkmena'                            => 'tk',
    'tuvalu'                              => 'tvl',
    'tuvinian'                            => 'tyv',
    'tyap'                                => 'kcg',
    'uanga'                               => 'za',
    'udmurt'                              => 'udm',
    'ugaritic'                            => 'uga',
    'ujgura'                              => 'ug',
    'ukraina'                             => 'uk',
    'umbundu'                             => 'umb',
    "unknown\ or\ invalid\ language"      => 'und',
    "upper\ sorbian"                      => 'hsb',
    'urduo'                               => 'ur',
    "us\ english"                         => 'en_us',
    'uzbeka'                              => 'uz',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'vjetnama'                            => 'vi',
    'volapuko'                            => 'vo',
    'volofa'                              => 'wo',
    'votic'                               => 'vot',
    "wakashan\ language"                  => 'wak',
    'walamo'                              => 'wal',
    'walloon'                             => 'wa',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'yakut'                               => 'sah',
    'yao'                                 => 'yao',
    'yapese'                              => 'yap',
    "yupik\ language"                     => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zulua'                               => 'zu',
    'zuni'                                => 'zun',
);

1;
