package Locales::DB::Language::cs;

# Auto generated from CLDR

$Locales::DB::Language::cs::VERSION = '0.01';

$Locales::DB::Language::cs::cldr_version = '1.7.1';

%Locales::DB::Language::cs::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Jazyk\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "ano\:a"
    },
);

%Locales::DB::Language::cs::code_to_name = (
    'aa'    => 'afarština',
    'ab'    => 'abcházština',
    'ace'   => 'acehština',
    'ach'   => 'ačoli',
    'ada'   => 'adangme',
    'ady'   => 'adygejština',
    'ae'    => "avestský\ jazyk",
    'af'    => 'afrikánština',
    'afa'   => "afroasijské\ jazyky",
    'afh'   => 'afrihili',
    'ain'   => 'ainština',
    'ak'    => 'akan',
    'akk'   => 'akkadština',
    'ale'   => 'aleutština',
    'alg'   => "algonkinské\ jazyky",
    'alt'   => "Southern\ Altai",
    'am'    => 'amharština',
    'an'    => 'aragonština',
    'ang'   => 'staroangličtina',
    'anp'   => 'angika',
    'apa'   => "apačské\ jazyky",
    'ar'    => 'arabština',
    'arc'   => 'aramejština',
    'arn'   => 'araukánština',
    'arp'   => 'arapaho',
    'art'   => "umělé\ jazyky",
    'arw'   => "arawacké\ jazyky",
    'as'    => 'ásámština',
    'ast'   => 'Asturian',
    'ath'   => "athapaskánské\ jazyky",
    'aus'   => "australské\ jazyky",
    'av'    => 'avarština',
    'awa'   => 'awadhština',
    'ay'    => 'ajmarština',
    'az'    => 'ázerbájdžánština',
    'ba'    => 'baskirština',
    'bad'   => 'banda',
    'bai'   => 'bamilek',
    'bal'   => 'balúčština',
    'ban'   => 'balijština',
    'bas'   => 'basa',
    'bat'   => "baltské\ jazyky",
    'be'    => 'běloruština',
    'bej'   => 'bedža',
    'bem'   => 'bembštiva',
    'ber'   => "berberské\ jazyky",
    'bg'    => 'bulharština',
    'bh'    => 'bihárština',
    'bho'   => 'bhódžupurí',
    'bi'    => 'bislama',
    'bik'   => 'bikolština',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambarština',
    'bn'    => 'bengálština',
    'bnt'   => "bantuské\ jazyky",
    'bo'    => 'tibetština',
    'br'    => 'bretonština',
    'bra'   => 'bradžština',
    'bs'    => 'bosenština',
    'btk'   => 'batačtina',
    'bua'   => 'burjatština',
    'bug'   => 'bugiština',
    'byn'   => 'Blin',
    'ca'    => 'katalánština',
    'cad'   => 'caddo',
    'cai'   => "středoamerické\ indiánské\ jazyky",
    'car'   => 'karibština',
    'cau'   => "kavkazské\ jazyky",
    'cch'   => 'Atsam',
    'ce'    => 'čečenština',
    'ceb'   => 'cebuánština',
    'cel'   => "keltské\ jazyky",
    'ch'    => 'čamoro',
    'chb'   => 'čibča',
    'chg'   => 'čagatajština',
    'chk'   => 'čukština',
    'chm'   => 'marijština',
    'chn'   => "činuk\ pidžin",
    'cho'   => 'choctawština',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'čejenština',
    'cmc'   => 'čamština',
    'co'    => 'korsičtina',
    'cop'   => 'koptština',
    'cpe'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ angličtiny",
    'cpf'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ francouzštiny",
    'cpp'   => "kreolština\ a\ jiné\ pidginy\ na\ základě\ portugalštiny",
    'cr'    => 'krí',
    'crh'   => "krymská\ tatarština",
    'crp'   => "kreolština\ a\ jiné\ pidginy",
    'cs'    => 'čeština',
    'csb'   => 'Kashubian',
    'cu'    => 'staroslověnština',
    'cus'   => "kúšitské\ jazyky",
    'cv'    => 'čuvašština',
    'cy'    => 'velština',
    'da'    => 'dánština',
    'dak'   => 'dakotština',
    'dar'   => 'Dargwa',
    'day'   => 'dajáčtina',
    'de'    => 'němčina',
    'de_at' => "německy\ \(Rakousko\)",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinkština',
    'doi'   => 'dórgí',
    'dra'   => "drávidské\ jazyky",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'dualština',
    'dum'   => 'středoholandština',
    'dv'    => 'divehi',
    'dyu'   => 'djula',
    'dz'    => 'dzongkä',
    'ee'    => 'eweština',
    'efi'   => 'efik',
    'egy'   => "egyptština\ stará",
    'eka'   => 'ekajuk',
    'el'    => 'řečtina',
    'elx'   => 'elamitština',
    'en'    => 'angličtina',
    'en_au' => "Australian\ English",
    'en_ca' => "anglicky\ \(Kanada\)",
    'en_gb' => "British\ English",
    'en_us' => "angličtina\ \(USA\)",
    'enm'   => 'středoangličtina',
    'eo'    => 'esperanto',
    'es'    => 'španělština',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estonština',
    'eu'    => 'baskičtina',
    'ewo'   => 'ewondo',
    'fa'    => 'perština',
    'fan'   => 'fang',
    'fat'   => 'fantština',
    'ff'    => 'fulahština',
    'fi'    => 'finština',
    'fil'   => 'tagalogština',
    'fiu'   => "ugrofinské\ jazyky",
    'fj'    => 'fidžijština',
    'fo'    => 'faerština',
    'fon'   => 'Fon',
    'fr'    => 'francouzština',
    'fr_ca' => "francouzsky\ \(Kanada\)",
    'fr_ch' => "Swiss\ French",
    'frm'   => 'středofrancouzština',
    'fro'   => 'starofrancouzština',
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'furlandština',
    'fy'    => 'fríština',
    'ga'    => 'irština',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaja',
    'gd'    => "skotská\ gaelština",
    'gem'   => "germánské\ jazyky",
    'gez'   => 'geez',
    'gil'   => 'kiribatština',
    'gl'    => 'haličština',
    'gmh'   => "hornoněmčina\ stará",
    'gn'    => 'guaraní',
    'goh'   => "stará\ hornoněmčina",
    'gon'   => 'góndština',
    'gor'   => 'gorontalo',
    'got'   => 'gótština',
    'grb'   => 'grebo',
    'grc'   => 'starořečtina',
    'gsw'   => "Swiss\ German",
    'gu'    => 'gudžarátština',
    'gv'    => 'manština',
    'gwi'   => 'gwichʼin',
    'ha'    => 'hauština',
    'hai'   => 'haida',
    'haw'   => 'havajština',
    'he'    => 'hebrejština',
    'hi'    => 'hindština',
    'hil'   => 'hiligayonština',
    'him'   => 'himáčalština',
    'hit'   => 'chetitština',
    'hmn'   => 'hmongština',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorvatština',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'maďarština',
    'hup'   => 'hupa',
    'hy'    => 'arménština',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonéština',
    'ie'    => 'interlingue',
    'ig'    => 'igboština',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'idžo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilokánština',
    'inc'   => "indické\ jazyky",
    'ine'   => "indoevropské\ jazyky",
    'inh'   => 'inguština',
    'io'    => 'Ido',
    'ira'   => "íránské\ jazyky",
    'iro'   => "irokézské\ jazyky",
    'is'    => 'islandština',
    'it'    => 'italština',
    'iu'    => 'inuktitut',
    'ja'    => 'japonština',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'javánština',
    'ka'    => 'gruzínština',
    'kaa'   => 'karakalpačtina',
    'kab'   => 'kabylština',
    'kac'   => 'kačijština',
    'kaj'   => 'Jju',
    'kam'   => 'kambština',
    'kar'   => 'karenština',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardinština',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'konžština',
    'kha'   => 'khásí',
    'khi'   => "khoisanské\ jazyky",
    'kho'   => 'chotánština',
    'ki'    => 'kikujština',
    'kj'    => 'kuaňamština',
    'kk'    => 'kazaština',
    'kl'    => 'kalmyčtina',
    'km'    => 'khmerština',
    'kmb'   => 'kimbundština',
    'kn'    => 'kannadština',
    'ko'    => 'korejština',
    'kok'   => 'kónkánština',
    'kos'   => 'kosrajština',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'kru',
    'kru'   => 'krukukhština',
    'ks'    => 'kašmírština',
    'ku'    => 'kurdština',
    'kum'   => 'kumyčtina',
    'kut'   => 'kutenai',
    'kv'    => 'komijština',
    'kw'    => 'kornština',
    'ky'    => 'kyrgyzština',
    'la'    => 'latina',
    'lad'   => 'ladinština',
    'lah'   => 'lahndština',
    'lam'   => 'lambština',
    'lb'    => 'Lucemburština',
    'lez'   => 'lezginština',
    'lg'    => 'ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingalština',
    'lo'    => 'laoština',
    'lol'   => 'mongština',
    'loz'   => 'lozština',
    'lt'    => 'litevština',
    'lu'    => "lubu\-katanžština",
    'lua'   => "luba\-luluaština",
    'lui'   => 'luiseňo',
    'lun'   => 'lundština',
    'luo'   => 'luoština',
    'lus'   => 'lišáí',
    'lv'    => 'lotyština',
    'mad'   => 'madurština',
    'mag'   => 'magahština',
    'mai'   => 'maithilština',
    'mak'   => 'makasarština',
    'man'   => 'mandingština',
    'map'   => "austronéské\ jazyky",
    'mas'   => 'masajština',
    'mdf'   => 'Moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaština',
    'mga'   => 'středoirština',
    'mh'    => 'maršálština',
    'mi'    => 'maorština',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "různé\ jazyky",
    'mk'    => 'makedonština',
    'mkh'   => "mon\-khmerské\ jazyky",
    'ml'    => 'malajálamština',
    'mn'    => 'mongolština',
    'mnc'   => 'mandžuština',
    'mni'   => 'manipurština',
    'mno'   => "manobo\ jazyky",
    'mo'    => 'moldavština',
    'moh'   => 'mohawk',
    'mos'   => 'mosi',
    'mr'    => 'maráthština',
    'ms'    => 'malajština',
    'mt'    => 'maltština',
    'mul'   => "složené\ \(víceřádkové\)\ jazyky",
    'mun'   => "mundské\ jazyky",
    'mus'   => "muskogee\ \(creek\)",
    'mwl'   => 'Mirandese',
    'mwr'   => 'márvárština',
    'my'    => 'barmština',
    'myn'   => "mayské\ jazyky",
    'myv'   => 'Erzya',
    'na'    => 'naurština',
    'nah'   => 'nahuatl',
    'nai'   => "severoamerické\ indiánské\ jazyky",
    'nap'   => 'neapolština',
    'nb'    => "norština\ \(Bokmål\)",
    'nd'    => "ndebele\ \(Zimbabwe\)",
    'nds'   => 'dolnoněmčina',
    'ne'    => 'nepálština',
    'new'   => 'névárština',
    'ng'    => 'ndondština',
    'nia'   => 'nias',
    'nic'   => "nigero\-kordofánské\ jazyky",
    'niu'   => 'niue',
    'nl'    => 'nizozemština',
    'nl_be' => 'Flemish',
    'nn'    => "norština\ \(Nynorsk\)",
    'no'    => 'norština',
    'nog'   => 'Nogai',
    'non'   => "norština\ historická",
    'nqo'   => "N\â\\Ko",
    'nr'    => "ndebele\ \(Jižní\ Afrika\)",
    'nso'   => "severní\ sotho",
    'nub'   => "núbijské\ jazyky",
    'nv'    => 'navažština',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'ňandžština',
    'nym'   => 'ňamwežština',
    'nyn'   => 'nyakolština',
    'nyo'   => 'nyorština',
    'nzi'   => 'nzima',
    'oc'    => 'okcitánština',
    'oj'    => 'odžibvejština',
    'om'    => "oromština\ \(Afan\)",
    'or'    => 'urijština',
    'os'    => 'osetština',
    'osa'   => 'osage',
    'ota'   => "osmanská\ turečtina",
    'oto'   => "otomijské\ jazyky",
    'pa'    => 'paňdžábština',
    'paa'   => "papuánské\ jazyky",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlaví',
    'pam'   => 'papangau',
    'pap'   => 'papiamento',
    'pau'   => 'palauština',
    'peo'   => 'staroperština',
    'phi'   => "filipínské\ jazyky",
    'phn'   => 'féničtina',
    'pi'    => 'pálí',
    'pl'    => 'polština',
    'pon'   => 'pohnpeiština',
    'pra'   => 'prákrty',
    'pro'   => 'provensálština',
    'ps'    => 'paštština',
    'pt'    => 'portugalština',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'kečuánština',
    'raj'   => 'rádžastánština',
    'rap'   => 'rapanuiština',
    'rar'   => 'rarotongaština',
    'rm'    => 'rétorománština',
    'rn'    => 'rundština',
    'ro'    => 'rumunština',
    'roa'   => "románské\ jazyky",
    'rom'   => 'romština',
    'ru'    => 'ruština',
    'rup'   => 'Aromanian',
    'rw'    => 'rwandština',
    'sa'    => 'sanskrt',
    'sad'   => 'sandawština',
    'sah'   => 'jakutština',
    'sai'   => "jihoamerické\ indiánské\ jazyky",
    'sal'   => "salishské\ jazyky",
    'sam'   => 'samarština',
    'sas'   => 'sasakština',
    'sat'   => 'santálí',
    'sc'    => 'sardština',
    'scn'   => 'Sicilian',
    'sco'   => 'skotština',
    'sd'    => 'sindhština',
    'se'    => "Northern\ Sami",
    'sel'   => 'selkupština',
    'sem'   => "semitské\ jazyky",
    'sg'    => 'sangho',
    'sga'   => 'staroirština',
    'sgn'   => "znakové\ jazyky",
    'sh'    => 'srbochorvatština',
    'shn'   => 'šanština',
    'si'    => 'sinhálština',
    'sid'   => 'sidamo',
    'sio'   => "siouxské\ jazyky",
    'sit'   => "tibetočínské\ jazyky",
    'sk'    => 'slovenština',
    'sl'    => 'slovinština',
    'sla'   => "slovanské\ jazyky",
    'sm'    => 'samojština',
    'sma'   => "Southern\ Sami",
    'smi'   => "sami\ jazyky",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'šonština',
    'snk'   => 'sonikština',
    'so'    => 'somálština',
    'sog'   => 'sogdština',
    'son'   => 'songhajština',
    'sq'    => 'albánština',
    'sr'    => 'srbština',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'serer',
    'ss'    => 'swatština',
    'ssa'   => "nilo\-saharské\ jazyky",
    'st'    => "sotho\ jižní",
    'su'    => 'sundština',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumerština',
    'sv'    => 'švédština',
    'sw'    => 'svahilština',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'syrština',
    'ta'    => 'tamilština',
    'tai'   => "thajské\ jazyky",
    'te'    => 'telugština',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetumština',
    'tg'    => 'tádžičtina',
    'th'    => 'thajština',
    'ti'    => 'tigriňa',
    'tig'   => 'tigrejština',
    'tiv'   => 'tivština',
    'tk'    => 'turkmenština',
    'tkl'   => 'tokelauština',
    'tl'    => 'tagalština',
    'tlh'   => 'klingonština',
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tswandština',
    'to'    => 'tongština',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turečtina',
    'trv'   => 'Taroko',
    'ts'    => 'tsongština',
    'tsi'   => "tsimshijské\ jazyky",
    'tt'    => 'tatarština',
    'tum'   => 'tumbukština',
    'tup'   => "Tupi\ Language",
    'tut'   => "altajské\ jazyky",
    'tvl'   => 'tuvalština',
    'tw'    => 'twi',
    'ty'    => 'tahitština',
    'tyv'   => 'tuvinština',
    'udm'   => 'udmurtština',
    'ug'    => 'ujgurština',
    'uga'   => 'ugaritština',
    'uk'    => 'ukrajinština',
    'umb'   => 'umbundu',
    'und'   => 'nevymezené',
    'ur'    => 'urdština',
    'uz'    => 'uzbečtina',
    'vai'   => 'vai',
    've'    => 'vendština',
    'vi'    => 'vietnamština',
    'vo'    => 'volapük',
    'vot'   => 'votiatština',
    'wa'    => 'valonština',
    'wak'   => "wakashské\ jazyky",
    'wal'   => 'walamština',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "lužickosrbské\ jazyky",
    'wo'    => 'wolofština',
    'xal'   => 'kalmyčtina',
    'xh'    => 'xhosština',
    'yao'   => 'jaoština',
    'yap'   => 'yapese',
    'yi'    => 'jidiš',
    'yo'    => 'jorubština',
    'ypk'   => 'yupik',
    'za'    => 'čuangština',
    'zap'   => 'zapotéčtina',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'čínština',
    'znd'   => 'zandština',
    'zu'    => 'zuluština',
    'zun'   => 'zunijština',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::cs::name_to_code = (
    'abchztina'                                           => 'ab',
    'acehtina'                                            => 'ace',
    'adangme'                                             => 'ada',
    'adygejtina'                                          => 'ady',
    'afartina'                                            => 'aa',
    'afrihili'                                            => 'afh',
    'afrikntina'                                          => 'af',
    "afroasijsk\ jazyky"                                  => 'afa',
    'agatajtina'                                          => 'chg',
    'aintina'                                             => 'ain',
    'ajmartina'                                           => 'ay',
    'akan'                                                => 'ak',
    'akkadtina'                                           => 'akk',
    'albntina'                                            => 'sq',
    'aleuttina'                                           => 'ale',
    "algonkinsk\ jazyky"                                  => 'alg',
    "altajsk\ jazyky"                                     => 'tut',
    'amhartina'                                           => 'am',
    'amoro'                                               => 'ch',
    'amtina'                                              => 'cmc',
    'amwetina'                                            => 'nym',
    'andtina'                                             => 'ny',
    'angika'                                              => 'anp',
    "anglicky\ kanada"                                    => 'en_ca',
    'anglitina'                                           => 'en',
    "anglitina\ usa"                                      => 'en_us',
    'antina'                                              => 'shn',
    'aoli'                                                => 'ach',
    "apask\ jazyky"                                       => 'apa',
    'arabtina'                                            => 'ar',
    'aragontina'                                          => 'an',
    'aramejtina'                                          => 'arc',
    'arapaho'                                             => 'arp',
    'araukntina'                                          => 'arn',
    "arawack\ jazyky"                                     => 'arw',
    'armntina'                                            => 'hy',
    'aromanian'                                           => 'rup',
    'asturian'                                            => 'ast',
    "athapasknsk\ jazyky"                                 => 'ath',
    'atsam'                                               => 'cch',
    "australian\ english"                                 => 'en_au',
    "australsk\ jazyky"                                   => 'aus',
    "austronsk\ jazyky"                                   => 'map',
    'avartina'                                            => 'av',
    "avestsk\ jazyk"                                      => 'ae',
    'awadhtina'                                           => 'awa',
    'balijtina'                                           => 'ban',
    'baltina'                                             => 'bal',
    "baltsk\ jazyky"                                      => 'bat',
    'bambartina'                                          => 'bm',
    'bamilek'                                             => 'bai',
    'banda'                                               => 'bad',
    "bantusk\ jazyky"                                     => 'bnt',
    'barmtina'                                            => 'my',
    'basa'                                                => 'bas',
    'baskirtina'                                          => 'ba',
    'baskitina'                                           => 'eu',
    'batatina'                                            => 'btk',
    'beda'                                                => 'bej',
    'bembtiva'                                            => 'bem',
    'bengltina'                                           => 'bn',
    "berbersk\ jazyky"                                    => 'ber',
    'bhdupur'                                             => 'bho',
    'bihrtina'                                            => 'bh',
    'bikoltina'                                           => 'bik',
    'bini'                                                => 'bin',
    'bislama'                                             => 'bi',
    'blin'                                                => 'byn',
    'blissymbols'                                         => 'zbl',
    'blorutina'                                           => 'be',
    'bosentina'                                           => 'bs',
    'bradtina'                                            => 'bra',
    "brazilian\ portuguese"                               => 'pt_br',
    'bretontina'                                          => 'br',
    "british\ english"                                    => 'en_gb',
    'bugitina'                                            => 'bug',
    'bulhartina'                                          => 'bg',
    'burjattina'                                          => 'bua',
    'caddo'                                               => 'cad',
    'cebuntina'                                           => 'ceb',
    'cherokee'                                            => 'chr',
    'chetittina'                                          => 'hit',
    'chipewyan'                                           => 'chp',
    'choctawtina'                                         => 'cho',
    'chorvattina'                                         => 'hr',
    'chotntina'                                           => 'kho',
    "classical\ newari"                                   => 'nwc',
    "classical\ syriac"                                   => 'syc',
    'dajtina'                                             => 'day',
    'dakottina'                                           => 'dak',
    'dargwa'                                              => 'dar',
    'delaware'                                            => 'del',
    'dinktina'                                            => 'din',
    'divehi'                                              => 'dv',
    'djula'                                               => 'dyu',
    'dntina'                                              => 'da',
    'dogrib'                                              => 'dgr',
    'dolnonmina'                                          => 'nds',
    'drg'                                                 => 'doi',
    "drvidsk\ jazyky"                                     => 'dra',
    'dualtina'                                            => 'dua',
    'dzongk'                                              => 'dz',
    "eastern\ frisian"                                    => 'frs',
    'eentina'                                             => 'ce',
    'efik'                                                => 'efi',
    "egypttina\ star"                                     => 'egy',
    'ejentina'                                            => 'chy',
    'ekajuk'                                              => 'eka',
    'elamittina'                                          => 'elx',
    'erzya'                                               => 'myv',
    'esperanto'                                           => 'eo',
    'estontina'                                           => 'et',
    'etina'                                               => 'el',
    'ewetina'                                             => 'ee',
    'ewondo'                                              => 'ewo',
    'faertina'                                            => 'fo',
    'fang'                                                => 'fan',
    'fanttina'                                            => 'fat',
    'fidijtina'                                           => 'fj',
    "filipnsk\ jazyky"                                    => 'phi',
    'fintina'                                             => 'fi',
    'flemish'                                             => 'nl_be',
    'fnitina'                                             => 'phn',
    'fon'                                                 => 'fon',
    "francouzsky\ kanada"                                 => 'fr_ca',
    'francouztina'                                        => 'fr',
    'frtina'                                              => 'fy',
    'fulahtina'                                           => 'ff',
    'furlandtina'                                         => 'fur',
    'ga'                                                  => 'gaa',
    'ganda'                                               => 'lg',
    'gayo'                                                => 'gay',
    'gbaja'                                               => 'gba',
    'geez'                                                => 'gez',
    "germnsk\ jazyky"                                     => 'gem',
    'gndtina'                                             => 'gon',
    'gorontalo'                                           => 'gor',
    'grebo'                                               => 'grb',
    'gruzntina'                                           => 'ka',
    'gttina'                                              => 'got',
    'guaran'                                              => 'gn',
    'gudarttina'                                          => 'gu',
    'gwichin'                                             => 'gwi',
    'haida'                                               => 'hai',
    'haitian'                                             => 'ht',
    'halitina'                                            => 'gl',
    'hautina'                                             => 'ha',
    'havajtina'                                           => 'haw',
    'hebrejtina'                                          => 'he',
    'herero'                                              => 'hz',
    'hiligayontina'                                       => 'hil',
    'himaltina'                                           => 'him',
    'hindtina'                                            => 'hi',
    "hiri\ motu"                                          => 'ho',
    'hmongtina'                                           => 'hmn',
    "hornonmina\ star"                                    => 'gmh',
    'hupa'                                                => 'hup',
    'iba'                                                 => 'chb',
    'iban'                                                => 'iba',
    "iberian\ portuguese"                                 => 'pt_pt',
    "iberian\ spanish"                                    => 'es_es',
    'ido'                                                 => 'io',
    'igbotina'                                            => 'ig',
    'ilokntina'                                           => 'ilo',
    "inari\ sami"                                         => 'smn',
    "indick\ jazyky"                                      => 'inc',
    "indoevropsk\ jazyky"                                 => 'ine',
    'indontina'                                           => 'id',
    'ingutina'                                            => 'inh',
    'interlingua'                                         => 'ia',
    'interlingue'                                         => 'ie',
    "inuk\ pidin"                                         => 'chn',
    'inuktitut'                                           => 'iu',
    'inupiaq'                                             => 'ik',
    "irokzsk\ jazyky"                                     => 'iro',
    'irtina'                                              => 'ga',
    'islandtina'                                          => 'is',
    'italtina'                                            => 'it',
    'jakuttina'                                           => 'sah',
    'jaotina'                                             => 'yao',
    'japontina'                                           => 'ja',
    'javntina'                                            => 'jv',
    'jidi'                                                => 'yi',
    "jihoamerick\ indinsk\ jazyky"                        => 'sai',
    'jju'                                                 => 'kaj',
    'jorubtina'                                           => 'yo',
    'judeoarabic'                                         => 'jrb',
    'judeopersian'                                        => 'jpr',
    'kabardintina'                                        => 'kbd',
    'kabyltina'                                           => 'kab',
    'kaijtina'                                            => 'kac',
    'kalmytina'                                           => 'xal',
    'kambtina'                                            => 'kam',
    'kamrtina'                                            => 'ks',
    'kannadtina'                                          => 'kn',
    'kanuri'                                              => 'kr',
    'karachaybalkar'                                      => 'krc',
    'karakalpatina'                                       => 'kaa',
    'karelian'                                            => 'krl',
    'karentina'                                           => 'kar',
    'karibtina'                                           => 'car',
    'kashubian'                                           => 'csb',
    'katalntina'                                          => 'ca',
    "kavkazsk\ jazyky"                                    => 'cau',
    'kawi'                                                => 'kaw',
    'kazatina'                                            => 'kk',
    "keltsk\ jazyky"                                      => 'cel',
    'keuntina'                                            => 'qu',
    'khmertina'                                           => 'km',
    "khoisansk\ jazyky"                                   => 'khi',
    'khs'                                                 => 'kha',
    'kikujtina'                                           => 'ki',
    'kimbundtina'                                         => 'kmb',
    'kiribattina'                                         => 'gil',
    "kitsk\ jazyky"                                       => 'cus',
    'klingontina'                                         => 'tlh',
    'knkntina'                                            => 'kok',
    'komijtina'                                           => 'kv',
    'kontina'                                             => 'kg',
    'kopttina'                                            => 'cop',
    'korejtina'                                           => 'ko',
    'korntina'                                            => 'kw',
    'koro'                                                => 'kfo',
    'korsitina'                                           => 'co',
    'kosrajtina'                                          => 'kos',
    'kpelle'                                              => 'kpe',
    'kr'                                                  => 'cr',
    "kreoltina\ a\ jin\ pidginy"                          => 'crp',
    "kreoltina\ a\ jin\ pidginy\ na\ zklad\ anglitiny"    => 'cpe',
    "kreoltina\ a\ jin\ pidginy\ na\ zklad\ francouztiny" => 'cpf',
    "kreoltina\ a\ jin\ pidginy\ na\ zklad\ portugaltiny" => 'cpp',
    'kru'                                                 => 'kro',
    'krukukhtina'                                         => 'kru',
    "krymsk\ tatartina"                                   => 'crh',
    'kuaamtina'                                           => 'kj',
    'kumytina'                                            => 'kum',
    'kurdtina'                                            => 'ku',
    'kutenai'                                             => 'kut',
    'kyrgyztina'                                          => 'ky',
    'ladintina'                                           => 'lad',
    'lahndtina'                                           => 'lah',
    'lambtina'                                            => 'lam',
    'laotina'                                             => 'lo',
    'latina'                                              => 'la',
    'lezgintina'                                          => 'lez',
    'li'                                                  => 'lus',
    'limburgish'                                          => 'li',
    'lingaltina'                                          => 'ln',
    'litevtina'                                           => 'lt',
    'lojban'                                              => 'jbo',
    'lotytina'                                            => 'lv',
    "lower\ sorbian"                                      => 'dsb',
    'loztina'                                             => 'loz',
    'lubaluluatina'                                       => 'lua',
    'lubukatantina'                                       => 'lu',
    'lucemburtina'                                        => 'lb',
    "luickosrbsk\ jazyky"                                 => 'wen',
    'luiseo'                                              => 'lui',
    "lule\ sami"                                          => 'smj',
    'lundtina'                                            => 'lun',
    'luotina'                                             => 'luo',
    'maartina'                                            => 'hu',
    'madurtina'                                           => 'mad',
    'magahtina'                                           => 'mag',
    'maithiltina'                                         => 'mai',
    'makasartina'                                         => 'mak',
    'makedontina'                                         => 'mk',
    'malajlamtina'                                        => 'ml',
    'malajtina'                                           => 'ms',
    'malgatina'                                           => 'mg',
    'malttina'                                            => 'mt',
    'mandar'                                              => 'mdr',
    'mandingtina'                                         => 'man',
    'mandutina'                                           => 'mnc',
    'manipurtina'                                         => 'mni',
    "manobo\ jazyky"                                      => 'mno',
    'mantina'                                             => 'gv',
    'maortina'                                            => 'mi',
    'marijtina'                                           => 'chm',
    'marltina'                                            => 'mh',
    'marthtina'                                           => 'mr',
    'masajtina'                                           => 'mas',
    "maysk\ jazyky"                                       => 'myn',
    'mende'                                               => 'men',
    'micmac'                                              => 'mic',
    'minangkabau'                                         => 'min',
    'mirandese'                                           => 'mwl',
    'mohawk'                                              => 'moh',
    'moksha'                                              => 'mdf',
    'moldavtina'                                          => 'mo',
    'mongoltina'                                          => 'mn',
    'mongtina'                                            => 'lol',
    "monkhmersk\ jazyky"                                  => 'mkh',
    'morisyen'                                            => 'mfe',
    'mosi'                                                => 'mos',
    'mrvrtina'                                            => 'mwr',
    "mundsk\ jazyky"                                      => 'mun',
    "muskogee\ creek"                                     => 'mus',
    'nahuatl'                                             => 'nah',
    'naurtina'                                            => 'na',
    'navatina'                                            => 'nv',
    "nbijsk\ jazyky"                                      => 'nub',
    "ndebele\ jin\ afrika"                                => 'nr',
    "ndebele\ zimbabwe"                                   => 'nd',
    'ndondtina'                                           => 'ng',
    'neapoltina'                                          => 'nap',
    'nepltina'                                            => 'ne',
    'nevymezen'                                           => 'und',
    'nias'                                                => 'nia',
    "nigerokordofnsk\ jazyky"                             => 'nic',
    "nilosaharsk\ jazyky"                                 => 'ssa',
    'niue'                                                => 'niu',
    'nizozemtina'                                         => 'nl',
    'nko'                                                 => 'nqo',
    "nmecky\ rakousko"                                    => 'de_at',
    'nmina'                                               => 'de',
    "no\ linguistic\ content"                             => 'zxx',
    'nogai'                                               => 'nog',
    "northern\ frisian"                                   => 'frr',
    "northern\ sami"                                      => 'se',
    'nortina'                                             => 'no',
    "nortina\ bokml"                                      => 'nb',
    "nortina\ historick"                                  => 'non',
    "nortina\ nynorsk"                                    => 'nn',
    'ntina'                                               => 'zh',
    'nvrtina'                                             => 'new',
    'nyakoltina'                                          => 'nyn',
    "nyasa\ tonga"                                        => 'tog',
    'nyortina'                                            => 'nyo',
    'nzima'                                               => 'nzi',
    'odibvejtina'                                         => 'oj',
    'okcitntina'                                          => 'oc',
    'ontina'                                              => 'sn',
    "oromtina\ afan"                                      => 'om',
    'osage'                                               => 'osa',
    'osettina'                                            => 'os',
    "osmansk\ turetina"                                   => 'ota',
    "otomijsk\ jazyky"                                    => 'oto',
    'padbtina'                                            => 'pa',
    'pahlav'                                              => 'pal',
    'palautina'                                           => 'pau',
    'pangasinan'                                          => 'pag',
    'panltina'                                            => 'es',
    'papangau'                                            => 'pam',
    'papiamento'                                          => 'pap',
    "papunsk\ jazyky"                                     => 'paa',
    'pattina'                                             => 'ps',
    'pertina'                                             => 'fa',
    'pl'                                                  => 'pi',
    'pohnpeitina'                                         => 'pon',
    'poltina'                                             => 'pl',
    'portugaltina'                                        => 'pt',
    'prkrty'                                              => 'pra',
    'provensltina'                                        => 'pro',
    'rapanuitina'                                         => 'rap',
    'rarotongatina'                                       => 'rar',
    'rdastntina'                                          => 'raj',
    "rnsk\ jazyky"                                        => 'ira',
    "romnsk\ jazyky"                                      => 'roa',
    'romtina'                                             => 'rom',
    'rtoromntina'                                         => 'rm',
    'rumuntina'                                           => 'ro',
    'rundtina'                                            => 'rn',
    'rutina'                                              => 'ru',
    'rwandtina'                                           => 'rw',
    "rzn\ jazyky"                                         => 'mis',
    "salishsk\ jazyky"                                    => 'sal',
    'samartina'                                           => 'sam',
    "sami\ jazyky"                                        => 'smi',
    'samojtina'                                           => 'sm',
    'sandawtina'                                          => 'sad',
    'sangho'                                              => 'sg',
    'sanskrt'                                             => 'sa',
    'santl'                                               => 'sat',
    'sardtina'                                            => 'sc',
    'sasaktina'                                           => 'sas',
    'selkuptina'                                          => 'sel',
    "semitsk\ jazyky"                                     => 'sem',
    'serer'                                               => 'srr',
    "severn\ sotho"                                       => 'nso',
    "severoamerick\ indinsk\ jazyky"                      => 'nai',
    "sichuan\ yi"                                         => 'ii',
    'sicilian'                                            => 'scn',
    'sidamo'                                              => 'sid',
    'siksika'                                             => 'bla',
    'sindhtina'                                           => 'sd',
    'sinhltina'                                           => 'si',
    "siouxsk\ jazyky"                                     => 'sio',
    "skolt\ sami"                                         => 'sms',
    "skotsk\ gaeltina"                                    => 'gd',
    'skottina'                                            => 'sco',
    'slave'                                               => 'den',
    "sloen\ vcedkov\ jazyky"                              => 'mul',
    "slovansk\ jazyky"                                    => 'sla',
    'sloventina'                                          => 'sk',
    'slovintina'                                          => 'sl',
    'smtina'                                              => 'as',
    'sogdtina'                                            => 'sog',
    'somltina'                                            => 'so',
    'songhajtina'                                         => 'son',
    'soniktina'                                           => 'snk',
    "sotho\ jin"                                          => 'st',
    "southern\ altai"                                     => 'alt',
    "southern\ sami"                                      => 'sma',
    "sranan\ tongo"                                       => 'srn',
    'srbochorvattina'                                     => 'sh',
    'srbtina'                                             => 'sr',
    "star\ hornonmina"                                    => 'goh',
    'staroanglitina'                                      => 'ang',
    'staroetina'                                          => 'grc',
    'starofrancouztina'                                   => 'fro',
    'staroirtina'                                         => 'sga',
    'staropertina'                                        => 'peo',
    'staroslovntina'                                      => 'cu',
    "stedoamerick\ indinsk\ jazyky"                       => 'cai',
    'stedoanglitina'                                      => 'enm',
    'stedofrancouztina'                                   => 'frm',
    'stedoholandtina'                                     => 'dum',
    'stedoirtina'                                         => 'mga',
    'sukuma'                                              => 'suk',
    'sumertina'                                           => 'sux',
    'sundtina'                                            => 'su',
    'susu'                                                => 'sus',
    'svahiltina'                                          => 'sw',
    'swattina'                                            => 'ss',
    "swiss\ french"                                       => 'fr_ch',
    "swiss\ german"                                       => 'gsw',
    "swiss\ high\ german"                                 => 'de_ch',
    'syrtina'                                             => 'syr',
    'tagalogtina'                                         => 'fil',
    'tagaltina'                                           => 'tl',
    'tahittina'                                           => 'ty',
    'tamaek'                                              => 'tmh',
    'tamiltina'                                           => 'ta',
    'taroko'                                              => 'trv',
    'tatartina'                                           => 'tt',
    'tditina'                                             => 'tg',
    'telugtina'                                           => 'te',
    'temne'                                               => 'tem',
    'tereno'                                              => 'ter',
    'tetumtina'                                           => 'tet',
    "thajsk\ jazyky"                                      => 'tai',
    'thajtina'                                            => 'th',
    "tibetonsk\ jazyky"                                   => 'sit',
    'tibettina'                                           => 'bo',
    'tigrejtina'                                          => 'tig',
    'tigria'                                              => 'ti',
    'tivtina'                                             => 'tiv',
    'tlingit'                                             => 'tli',
    "tok\ pisin"                                          => 'tpi',
    'tokelautina'                                         => 'tkl',
    'tongtina'                                            => 'to',
    "tsimshijsk\ jazyky"                                  => 'tsi',
    'tsongtina'                                           => 'ts',
    'tswandtina'                                          => 'tn',
    'tumbuktina'                                          => 'tum',
    "tupi\ language"                                      => 'tup',
    'turetina'                                            => 'tr',
    'turkmentina'                                         => 'tk',
    'tuvaltina'                                           => 'tvl',
    'tuvintina'                                           => 'tyv',
    'twi'                                                 => 'tw',
    'tyap'                                                => 'kcg',
    'uangtina'                                            => 'za',
    'udmurttina'                                          => 'udm',
    'ugarittina'                                          => 'uga',
    "ugrofinsk\ jazyky"                                   => 'fiu',
    'ujgurtina'                                           => 'ug',
    'ukrajintina'                                         => 'uk',
    'uktina'                                              => 'chk',
    'umbundu'                                             => 'umb',
    "uml\ jazyky"                                         => 'art',
    "upper\ sorbian"                                      => 'hsb',
    'urdtina'                                             => 'ur',
    'urijtina'                                            => 'or',
    'uvatina'                                             => 'cv',
    'uzbetina'                                            => 'uz',
    'vai'                                                 => 'vai',
    'valontina'                                           => 'wa',
    'vdtina'                                              => 'sv',
    'veltina'                                             => 'cy',
    'vendtina'                                            => 've',
    'vietnamtina'                                         => 'vi',
    'volapk'                                              => 'vo',
    'votiattina'                                          => 'vot',
    "wakashsk\ jazyky"                                    => 'wak',
    'walamtina'                                           => 'wal',
    'waray'                                               => 'war',
    'washo'                                               => 'was',
    'woloftina'                                           => 'wo',
    'xhostina'                                            => 'xh',
    'yapese'                                              => 'yap',
    'yupik'                                               => 'ypk',
    'zandtina'                                            => 'znd',
    'zapottina'                                           => 'zap',
    'zaza'                                                => 'zza',
    'zenaga'                                              => 'zen',
    'zerbjdntina'                                         => 'az',
    "znakov\ jazyky"                                      => 'sgn',
    'zulutina'                                            => 'zu',
    'zunijtina'                                           => 'zun',
);

1;
