# $Author: ddumont $
# $Date: 2008/02/15 12:56:57 $
# $Name:  $
# $Revision: 1.4 $

#    Copyright (c) 2008 Dominique Dumont.
#
#    This file is part of Config-Model-TkUi.
#
#    Config-Model is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser Public License as
#    published by the Free Software Foundation; either version 2.1 of
#    the License, or (at your option) any later version.
#
#    Config-Model is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser Public License for more details.
#
#    You should have received a copy of the GNU Lesser Public License
#    along with Config-Model; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA

package Config::Model::Tk::ListViewer ;

use strict;
use warnings ;
use Carp ;

use base qw/Tk::Frame Config::Model::Tk::AnyViewer/;
use vars qw/$VERSION/ ;
use subs qw/menu_struct/ ;

$VERSION = sprintf "%d.%03d", q$Revision: 1.4 $ =~ /(\d+)\.(\d+)/;

Construct Tk::Widget 'ConfigModelListViewer';

my @fbe1 = qw/-fill both -expand 1/ ;
my @fxe1 = qw/-fill x    -expand 1/ ;

sub ClassInit {
    my ($cw, $args) = @_;
    # ClassInit is often used to define bindings and/or other
    # resources shared by all instances, e.g., images.

    # cw->Advertise(name=>$widget);
}

sub Populate { 
    my ($cw, $args) = @_;
    my $list = $cw->{list} = delete $args->{-item} 
      || die "ListViewer: no -item, got ",keys %$args;
    my $path = delete $args->{-path} 
      || die "ListViewer: no -path, got ",keys %$args;

    $cw->add_header(View => $list) ;

    my $inst = $list->instance ;
    $inst->push_no_value_check('fetch') ;

    my $elt_frame = $cw->Frame(qw/-relief raised -borderwidth 4/)->pack(@fxe1) ;
    my $str =  $list->element_name.' '.$list->get_type .' elements' ;
    $elt_frame -> Label(-text => $str) -> pack() ;

    my $rt = $elt_frame ->Scrolled ( 'ROText',
				     -height => 10,
				   ) ->pack(@fbe1) ;

    foreach my $c ($list->get_all_indexes) {
	$rt->insert('end', $c."\n" ) ;
    }

    $cw->add_info($cw) ;
    $cw->add_help_frame() ;
    $cw->add_help(class   => $list->parent->get_help) ;
    $cw->add_help(element => $list->parent->get_help($list->element_name)) ;
    $cw->add_editor_button($path) ;

    $cw->SUPER::Populate($args) ;
}


sub add_info {
    my $cw = shift ;
    my $info_frame = shift ;

    my $list = $cw->{list} ;

    my @items = ('type : '. $list->get_type 
                          . ( $list->ordered ? '(ordered)' : ''),
		 'index : '.$list->index_type ,
		 'cargo : '.$list->cargo_type ,
		);

    if ($list->cargo_type eq 'node') {
	push @items, "cargo class: " . $list->config_class_name ;
    }

    foreach my $what (qw/min max max_nb/) {
	my $v = $list->$what() ;
	my $str = $what ;
	$str =~ s/_/ /g;
	push @items, "$str: $v" if defined $v;
    }

    $cw->add_info_frame(@items) ;
}


1;
