#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;
use Time::Zone::Olsen();
use POSIX();

$ENV{PATH} = '/bin:/usr/bin';
delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

my $perl_date = 0;

$ENV{TZ} ||= 'Australia/Melbourne';
diag("TZ environment variable is $ENV{TZ}");
my $zoneinfo = Time::Zone::Olsen->new();
ok($zoneinfo, "Time::Zone::Olsen->new() generates an object");
ok($zoneinfo->directory() eq '/usr/share/zoneinfo', "\$zoneinfo->directory() returns the correct directory");
ok($zoneinfo->timezone() =~ /^\w+(\/[\w\-\/]+)?$/, "\$zoneinfo->timezone() parses correctly");
ok((grep /^Australia$/, $zoneinfo->areas()), "Found 'Australia' in \$zoneinfo->areas()");
ok((grep /^Melbourne$/, $zoneinfo->locations('Australia')), "Found 'Melbourne' in \$zoneinfo->areas('Australia')");
ok($zoneinfo->comment('Australia/Melbourne') eq 'Victoria', "\$zoneinfo->comment('Australia/Melbourne') returns 'Victoria'");
my $now = time;
my @correct_localtime = localtime $now;
my @test_localtime = $zoneinfo->local_time($now);
my $matched = 1;
foreach my $index (0 .. (( scalar @correct_localtime )- 1)) {
	if ($correct_localtime[$index] ne $test_localtime[$index]) {
		$matched = 0;
	}
}
foreach my $index (0 .. (( scalar @test_localtime )- 1)) {
	if ($correct_localtime[$index] ne $test_localtime[$index]) {
		$matched = 0;
	}
}
ok($matched, "Matched wantarray localtime");
my $gm_strftime = POSIX::strftime("%a %b %e %H:%M:%S GMT %Y", gmtime $now);
foreach my $area ($zoneinfo->areas()) {
	foreach my $location ($zoneinfo->locations($area)) {
		my $correct_date;
		if ($perl_date) {
			$correct_date = `TZ="$area/$location" perl -e "print q[] . localtime($now) . qq[\n]"`;
		} else {
			$gm_strftime = POSIX::strftime("%a %b %e %H:%M:%S GMT %Y", gmtime $now);
			$correct_date = `TZ="$area/$location" date -d "$gm_strftime" +"%a %b %e %H:%M:%S %Y"`;
		}
		chomp $correct_date;
		$zoneinfo->timezone("$area/$location");
		my $test_date = $zoneinfo->local_time($now);
		ok($test_date eq $correct_date, "Matched $test_date to $correct_date for $area/$location");
		my @local_time = $zoneinfo->local_time($now);
		my $revert_time = $zoneinfo->time_local(@local_time);
		ok($revert_time == $now, "\$zoneinfo->time_local(\$zoneinfo->local_time(\$now)) == \$now where $revert_time = $now with a difference of " . ($revert_time - $now)); 
		my @leap_seconds = $zoneinfo->leap_seconds();
		die "Leap seconds found in $area/$location" if (scalar @leap_seconds);
	}
}

Test::More::done_testing();
