package Net::SSLLabs::SimDetails;

use strict;
use warnings;
use Net::SSLLabs::Simulation();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    my @simulations = @{ $self->{results} };
    $self->{results} = [];
    foreach my $simulation (@simulations) {
        push @{ $self->{results} }, Net::SSLLabs::Simulation->new($simulation);
    }
    return $self;
}

sub results {
    my ($self) = @_;
    return @{ $self->{results} };
}

1;
__END__

=head1 NAME

Net::SSLLabs::SimDetails - SimDetails object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::SimDetails> object, accepts a JSON object as it's parameter.

=head2 results

list of instances of L<Net::SSLLabs::Simulation|Net::SSLLabs::Simulation>.
