package Net::SSLLabs::Endpoint;

use strict;
use warnings;
use Net::SSLLabs::EndpointDetails();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    if ( defined $self->{details} ) {
        $self->{details} =
          Net::SSLLabs::EndpointDetails->new( $self->{details} );
    }
    bless $self, $class;
    return $self;
}

sub ip_address {
    my ($self) = @_;
    return $self->{ipAddress};
}

sub is_exceptional {
    my ($self) = @_;
    return $self->{isExceptional} ? 1 : 0;
}

sub delegation {
    my ($self) = @_;
    return $self->{delegation};
}

sub has_warnings {
    my ($self) = @_;
    return $self->{hasWarnings} ? 1 : 0;
}

sub grade_trust_ignored {
    my ($self) = @_;
    return $self->{gradeTrustIgnored};
}

sub status_message {
    my ($self) = @_;
    return $self->{statusMessage};
}

sub duration {
    my ($self) = @_;
    return $self->{duration};
}

sub grade {
    my ($self) = @_;
    return $self->{grade};
}

sub eta {
    my ($self) = @_;
    return $self->{eta};
}

sub progress {
    my ($self) = @_;
    return $self->{progress};
}

sub server_name {
    my ($self) = @_;
    return $self->{serverName};
}

sub details {
    my ($self) = @_;
    return $self->{details};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Endpoint - Endpoint object

=head1 METHODS

=head2 new

a new C<Net::SSLLabs::Endpoint> object, accepts a JSON object as it's parameter.

=head2 subject

certificate subject

=head2 ip_address

endpoint IP address, in IPv4 or IPv6 format.

=head2 server_name

server name retrieved via reverse DNS

=head2 status_message

assessment status message

=head2 status_details

code of the operation currently in progress

=head2 status_details_message

description of the operation currently in progress

=head2 grade

possible values: A+, A-, A-F, T (no trust) and M (certificate name mismatch)

=head2 grade_trust_ignored

grade (as above), if trust issues are ignored

=head2 has_warnings

if this endpoint has warnings that might affect the score (e.g., get A- instead of A).

=head2 is_exceptional

this flag will be raised when an exceptional configuration is encountered. The SSL Labs test will give such sites an A+.

=head2 progress

assessment progress, which is a value from 0 to 100, and -1 if the assessment has not yet started

=head2 duration

assessment duration, in milliseconds

=head2 eta

estimated time, in seconds, until the completion of the assessment

=head2 delegation

indicates domain name delegation with and without the www prefix

=over 2

=item bit 0 (1) - set for non-prefixed access

=item bit 1 (2) - set for prefixed access

=back

=head2 details

this field contains an L<Net::SSLLabs::EndpointDetails|Net::SSLLabs::EndpointDetails> object. It's not present by default, but can be enabled by using the "all" paramerer to the L<analyze|Net::SSLLabs/"analyze"> API call.

