package Net::SSLLabs::Suites;

use strict;
use warnings;
use Net::SSLLabs::Suite();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    my @suites = @{ $self->{list} };
    $self->{list} = [];
    foreach my $suite (@suites) {
        push @{ $self->{list} }, Net::SSLLabs::Suite->new($suite);
    }
    return $self;
}

sub list {
    my ($self) = @_;
    return @{ $self->{list} };
}

sub preference {
    my ($self) = @_;
    return $self->{preference};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Suites - Suites object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::Suites> object, accepts a JSON object as it's parameter.

=head2 list

list of I<Net::SSLLabs::Suite> objects

=head2 preference

true if the server actively selects cipher suites; if null, we were not able to determine if the server has a preference
