package Net::SSLLabs::Host;

use strict;
use warnings;
use Net::SSLLabs::Endpoint();

sub new {
    my ( $class, $json ) = @_;
    my $self      = $json;
    my @endpoints = @{ $self->{endpoints} };
    $self->{endpoints} = [];
    foreach my $endpoint (@endpoints) {
        push @{ $self->{endpoints} }, Net::SSLLabs::Endpoint->new($endpoint);
    }
    bless $self, $class;
    return $self;
}

sub status {
    my ($self) = @_;
    return $self->{status};
}

sub statusMessage {
    my ($self) = @_;
    return $self->{statusMessage};
}

sub endpoints {
    my ($self) = @_;
    return @{ $self->{endpoints} };
}

sub host {
    my ($self) = @_;
    return $self->{host};
}

sub port {
    my ($self) = @_;
    return $self->{port};
}

sub startTime {
    my ($self) = @_;
    return $self->{startTime};
}

sub criteriaVersion {
    my ($self) = @_;
    return $self->{criteriaVersion};
}

sub engineVersion {
    my ($self) = @_;
    return $self->{engineVersion};
}

sub isPublic {
    my ($self) = @_;
    return $self->{isPublic};
}

sub protocol {
    my ($self) = @_;
    return $self->{protocol};
}

sub testTime {
    my ($self) = @_;
    return $self->{testTime};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Host - Host object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::Host> object, accepts a JSON object as it's parameter.

=head2 host 

assessment host, which can be a hostname or an IP address

=head2 port

assessment port (e.g., 443)

=head2 protocol

protocol (e.g., HTTP)

=head2 isPublic

true if this assessment publicly available (listed on the SSL Labs assessment boards)

=head2 status 

assessment status; possible values: DNS, ERROR, IN_PROGRESS, and READY.

=head2 statusMessage

status message in English. When status is ERROR, this field will contain an error message.

=head2 startTime

assessment starting time, in milliseconds since 1970

=head2 testTime

assessment completion time, in milliseconds since 1970

=head2 engineVersion

assessment engine version (e.g., "1.0.120")

=head2 criteriaVersion

grading criteria version (e.g., "2009")

=head2 cacheExpiryTime

when will the assessment results expire from the cache (typically set only for assessment with errors; otherwise the results stay in the cache for as long as there's sufficient room)

=head2 endpoints

list of <Net::SSLLabs::Endpoint> objects

=head2 certHostnames

the list of certificate hostnames collected from the certificates seen during assessment. The hostnames may not be valid. This field is available only if the server certificate doesn't match the requested hostname. In that case, this field saves you some time as you don't have to inspect the certificates yourself to find out what valid hostnames might be.
