use 5.006;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'HTTP::PublicKeyPins',
    AUTHOR           => q{David Dick <ddick@cpan.org>},
    VERSION_FROM     => 'lib/HTTP/PublicKeyPins.pm',
    ABSTRACT_FROM    => 'lib/HTTP/PublicKeyPins.pm',
    LICENSE          => 'Artistic_2_0',
    PL_FILES         => {},
    MIN_PERL_VERSION => 5.006,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::More' => 0,
    },
    PREREQ_PM => {
	'Crypt::OpenSSL::X509' => 0,
	'Crypt::OpenSSL::RSA' => 0,
	'Digest' => 0,
	'MIME::Base64' => 0,
	'Exporter' => 0,
	'strict' => 0,
	'warnings' => 0,
    },
    EXE_FILES => [
	'hpkp_pin_sha256',
    ],
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'HTTP-PublicKeyPins-*' },
);
