# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210919194241;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"811937", "宮古",
"818366", "宇部",
"81489", "草加",
"81286", "宇都宮",
"814777", "船橋",
"817476", "下市",
"815754", "関",
"817707", "小浜",
"814994", "三宅",
"81246", "いわき",
"819966", "出水",
"81484", "川口",
"812964", "下館",
"818672", "福渡",
"818266", "千代田",
"814297", "飯能",
"819979", "徳之島",
"818568", "津和野",
"817902", "福崎",
"81568", "春日井",
"818694", "岡山",
"811234", "千歳",
"811732", "五所川原",
"817366", "岩出",
"817940", "加古川",
"812675", "佐久",
"812673", "小諸",
"812477", "三春",
"818476", "府中",
"815748", "美濃白川",
"81476", "成田",
"818876", "土佐山田",
"812877", "黒磯",
"819738", "玖珠",
"817672", "羽咋",
"812550", "安塚",
"8165", "大阪",
"81952", "佐賀",
"81227", "仙台",
"812939", "水戸",
"81862", "岡山",
"812785", "沼田",
"812783", "沼田",
"811524", "網走",
"819558", "唐津",
"81793", "姫路",
"81492", "川越",
"815767", "下呂",
"8188091", "窪川",
"818956", "宇和島",
"812957", "大子",
"811376", "八雲",
"81762", "金沢",
"812913", "鉾田",
"812248", "大河原",
"811943", "岩泉",
"818597", "根雨",
"819668", "水俣",
"811945", "久慈",
"81463", "平塚",
"819594", "有川",
"81923", "福岡",
"817912", "相生",
"818547", "掛合",
"81250", "新津",
"812546", "村上",
"819544", "武雄",
"814280", "立川",
"819437", "田主丸",
"81893", "大洲",
"81948", "飯塚",
"81534", "浜松",
"817717", "園部",
"819572", "諫早",
"811866", "鷹巣",
"819726", "臼杵",
"818808", "土佐清水",
"811583", "紋別",
"81577", "高山",
"81933", "北九州",
"818834", "鴨島",
"811466", "えりも",
"817956", "三田",
"81988", "那覇",
"818384", "萩",
"811552", "帯広",
"811585", "遠軽",
"812788", "前橋",
"815737", "中津川",
"81578", "神岡",
"817464", "吉野",
"818292", "広島",
"811954", "二戸",
"811632", "天塩",
"818374", "長門",
"81987", "日南",
"818794", "三本松",
"819553", "伊万里",
"811357", "岩内",
"812976", "竜ケ崎",
"818977", "伯方",
"819747", "竹田",
"81947", "田川",
"818242", "東広島",
"819974", "屋久島",
"819555", "唐津",
"819942", "大根占",
"812245", "大河原",
"818464", "竹原",
"819665", "人吉",
"819663", "人吉",
"812243", "白石",
"81896", "伊予三島",
"81591", "津",
"812890", "宇都宮",
"81936", "北九州",
"818803", "土佐中村",
"815564", "鰍沢青柳",
"818514", "海士",
"81466", "藤沢",
"814702", "館山",
"818805", "土佐中村",
"8188092", "窪川",
"81926", "福岡",
"811588", "興部",
"8188099", "土佐清水",
"812237", "仙台",
"81228", "築館",
"81725", "和泉",
"819822", "延岡",
"811646", "羽幌",
"815586", "下田",
"812616", "大町",
"817457", "大和高田",
"814756", "東金",
"817682", "輪島",
"812934", "高萩",
"812652", "飯田",
"811364", "倶知安",
"818565", "益田",
"812487", "須賀川",
"819936", "加世田",
"81243", "二本松",
"815996", "阿児",
"818563", "益田",
"815743", "美濃加茂",
"814226", "武蔵野三鷹",
"812678", "佐久",
"81567", "津島",
"812412", "喜多方",
"815745", "美濃加茂",
"81825", "広島",
"819733", "日田",
"819735", "日田",
"817617", "加賀",
"811874", "角館",
"818655", "鴨方",
"818682", "津山",
"812562", "三条",
"81835", "防府",
"8112390", "夕張",
"8182920", "廿日市",
"817486", "水口",
"812856", "真岡",
"81473", "市川",
"819599", "大瀬戸",
"818555", "江津",
"819744", "三重",
"818974", "新居浜",
"818582", "倉吉",
"811354", "余市",
"819977", "瀬戸内",
"81270", "伊勢崎",
"812746", "富岡",
"818553", "浜田",
"815734", "恵那",
"818797", "土庄",
"812796", "渋川",
"818377", "下関",
"812376", "寒河江",
"811957", "岩手",
"8188094", "窪川",
"811752", "むつ",
"81726", "茨木",
"811939", "宮古",
"812578", "六日町",
"81557", "伊東",
"818942", "八幡浜",
"8153960", "天竜",
"81531", "田原",
"811986", "遠野",
"8144", "川崎",
"811398", "熊石",
"81480", "久喜",
"818467", "木江",
"812583", "長岡",
"818663", "総社",
"812585", "長岡",
"812552", "上越",
"8147955", "八日市場",
"818665", "高梁",
"817992", "洲本",
"811546", "釧路",
"812993", "石岡",
"819805", "名護",
"817942", "加古川",
"812879", "烏山",
"8188093", "窪川",
"819803", "名護",
"812995", "石岡",
"81259", "佐渡",
"817735", "福知山",
"8152", "名古屋",
"815769", "荘川",
"817733", "福知山",
"812234", "仙台",
"815988", "三瀬谷",
"812937", "水戸",
"81298", "土浦",
"811367", "寿都",
"818848", "牟岐",
"8167", "大阪",
"812484", "白河",
"815396", "浜松",
"817454", "大和高田",
"817614", "小松",
"81925", "福岡",
"81465", "小田原",
"815973", "尾鷲",
"811532", "根室",
"817498", "長浜",
"81174", "蟹田",
"81935", "北九州",
"814282", "青梅",
"818549", "石見大田",
"811877", "大曲",
"819682", "山鹿",
"81179", "三戸",
"819672", "熊本一の宮",
"817738", "舞鶴",
"81183", "湯沢",
"811337", "石狩",
"81138", "函館",
"812967", "笠間",
"811652", "士別",
"811934", "釜石",
"8186997", "岡山瀬戸",
"8112397", "栗山",
"819940", "志布志",
"815757", "郡上八幡",
"817704", "敦賀",
"81143", "室蘭",
"815985", "松阪",
"815952", "上野",
"818843", "阿南",
"815983", "松阪",
"818240", "東広島",
"818845", "丹生谷",
"818493", "尾道",
"818697", "備前",
"812696", "飯山",
"811237", "栗山",
"818893", "佐川",
"818895", "須崎",
"814792", "銚子",
"818290", "広島",
"81260", "阿南町",
"812646", "長野",
"812874", "大田原",
"811456", "門別富川",
"814291", "飯能",
"8183766", "下関",
"817966", "八鹿",
"811562", "本別",
"81542", "静岡",
"815978", "熊野",
"81582", "岐阜",
"812474", "石川",
"811856", "能代",
"818202", "柳井",
"814700", "鴨川",
"812892", "宇都宮",
"817495", "長浜",
"814771", "市川",
"817493", "彦根",
"81852", "松江",
"8186691", "倉敷",
"818558", "川本",
"817459", "大和榛原",
"819912", "中之島",
"811527", "美幌",
"81723", "堺",
"8199345", "鹿児島",
"8166", "大阪",
"812489", "須賀川",
"81962", "熊本",
"815362", "新城",
"81432", "千葉",
"812573", "柏崎",
"81245", "福島",
"819956", "加治木",
"812239", "仙台",
"812575", "十日町",
"817726", "峰山",
"811976", "北上",
"815764", "下呂",
"819782", "豊後高田",
"818544", "木次",
"819547", "鹿島",
"81823", "呉",
"818594", "米子",
"811395", "江差",
"818668", "井原",
"812560", "糸魚川",
"819597", "福江",
"812588", "長岡",
"818680", "岡山",
"8183768", "下関",
"811393", "松前",
"818837", "阿波池田",
"81888", "高知",
"812836", "佐野",
"818387", "田万川",
"81833", "下松",
"812386", "長井",
"81594", "桑名",
"817356", "串本",
"819808", "八重山",
"819434", "八女",
"812998", "潮来",
"81848", "尾道",
"817714", "亀岡",
"812415", "柳津",
"815742", "美濃加茂",
"815587", "修善寺大仁",
"812617", "大町",
"81553", "山梨",
"819208", "対馬佐賀",
"811647", "羽幌",
"812413", "喜多方",
"817678", "七尾",
"819732", "日田",
"81828", "広島",
"812236", "仙台",
"81272", "前橋",
"812565", "三条",
"818652", "倉敷",
"818685", "津山",
"812563", "三条",
"818683", "津山",
"815997", "阿児",
"812486", "須賀川",
"819937", "加世田",
"8182941", "広島",
"81998", "鹿児島",
"815394", "浜松",
"814757", "東金",
"817456", "大和高田",
"813", "東京",
"8198292", "延岡",
"81225", "石巻",
"817616", "小松",
"812839", "佐野",
"812570", "小出",
"818678", "新見",
"819823", "延岡",
"814227", "武蔵野三鷹",
"819825", "日向",
"812389", "米沢",
"81728", "寝屋川",
"81235", "鶴岡",
"817685", "輪島",
"817683", "輪島",
"812857", "真岡",
"817487", "水口",
"81743", "奈良",
"812653", "飯田",
"811738", "鰺ケ沢",
"81738", "御坊",
"81482", "川口",
"818562", "益田",
"812655", "飯田",
"817908", "播磨山崎",
"812977", "竜ケ崎",
"819746", "竹田",
"818976", "新居浜",
"811356", "岩内",
"812744", "藤岡",
"819662", "人吉",
"81532", "豊橋",
"811541", "弟子屈",
"812649", "長野",
"812242", "白石",
"815736", "中津川",
"812794", "渋川",
"812374", "村山",
"814705", "館山",
"818802", "窪川",
"819578", "島原",
"81764", "富山",
"814703", "館山",
"811558", "広尾",
"8198299", "日向",
"81494", "秩父",
"818295", "廿日市",
"811635", "浜頓別",
"811984", "花巻",
"818293", "廿日市",
"819552", "伊万里",
"81188", "秋田",
"818245", "三次",
"818490", "尾道",
"818243", "東広島",
"8147957", "八日市場",
"819945", "鹿屋",
"819943", "鹿屋",
"81864", "倉敷",
"811544", "釧路",
"817969", "浜坂",
"815399", "天竜",
"8175", "京都",
"811942", "岩泉",
"81262", "長野",
"817915", "相生",
"814708", "大原",
"819575", "諫早",
"819954", "加治木",
"8199347", "鹿児島",
"819573", "諫早",
"811377", "八雲",
"818957", "御荘",
"812956", "常陸大宮",
"811555", "帯広",
"811974", "水沢",
"817724", "宮津",
"811582", "紋別",
"81985", "宮崎",
"8153977", "天竜",
"811553", "帯広",
"815766", "下呂",
"818546", "掛合",
"812547", "村上",
"818298", "廿日市",
"811638", "利尻礼文",
"812782", "沼田",
"818596", "米子",
"81126", "岩見沢",
"818248", "庄原",
"8112398", "栗山",
"8186998", "岡山瀬戸",
"818398", "小郡",
"812834", "宇都宮",
"819948", "志布志",
"812384", "米沢",
"817957", "丹波柏原",
"817354", "新宮",
"819727", "臼杵",
"817716", "園部",
"811867", "鷹巣",
"812418", "会津山口",
"8198291", "延岡",
"819967", "出水",
"812672", "小諸",
"81779", "大野",
"81737", "湯浅",
"819205", "厳原",
"817675", "七尾",
"8125484", "村上",
"811936", "宮古",
"818367", "宇部",
"8183767", "下関",
"81774", "宇治",
"817706", "小浜",
"81581", "高富",
"814776", "船橋",
"81886", "徳島",
"817673", "羽咋",
"8112395", "栗山",
"8186995", "岡山瀬戸",
"812580", "十日町",
"818688", "美作",
"818660", "岡山瀬戸",
"812568", "巻",
"81727", "池田",
"812799", "長野原",
"81420", "所沢",
"812694", "中野",
"818267", "千代田",
"812644", "木曾福島",
"811549", "釧路",
"818877", "嶺北",
"812876", "黒磯",
"811454", "鵡川",
"8186996", "岡山瀬戸",
"8112396", "栗山",
"817964", "豊岡",
"818675", "久世",
"817367", "岩出",
"812476", "三春",
"818477", "東城",
"819828", "高千穂",
"811854", "男鹿",
"818673", "福渡",
"817688", "能都",
"81827", "岩国",
"8182942", "広島",
"817903", "福崎",
"811735", "五所川原",
"8125483", "村上",
"81565", "豊田",
"811733", "五所川原",
"812658", "伊那",
"817905", "福崎",
"819783", "豊後高田",
"8147950", "八日市場",
"8125489", "津川",
"815999", "津",
"819785", "豊後高田",
"81555", "吉田",
"812558", "新井",
"8126177", "長野",
"811526", "網走",
"811392", "木古内",
"8128798", "大田原",
"811977", "北上",
"817727", "峰山",
"817998", "津名",
"81885", "小松島",
"81478", "佐原",
"812619", "大町",
"815589", "修善寺大仁",
"819957", "加治木",
"81845", "因島",
"818954", "宇和島",
"817948", "三木",
"811374", "森",
"819913", "硫黄島",
"818588", "郡家",
"812859", "小山",
"81566", "刈谷",
"819596", "福江",
"812544", "新発田",
"81950", "平戸",
"819546", "鹿島",
"815363", "新城",
"812572", "柏崎",
"817357", "串本",
"811864", "大館",
"819724", "佐伯",
"814229", "武蔵野三鷹",
"818836", "脇町",
"811464", "静内",
"81288", "今市",
"812837", "佐野",
"817239", "寝屋川",
"818948", "宇和",
"817954", "西脇",
"81233", "新庄",
"81196", "盛岡",
"812387", "長井",
"81986", "都城",
"818364", "宇部",
"81797", "西宮",
"81172", "弘前",
"817474", "五条",
"815756", "郡上八幡",
"811563", "本別",
"818205", "柳井",
"814996", "八丈島",
"819964", "川内",
"811336", "石狩",
"81946", "甘木",
"818203", "柳井",
"814288", "青梅",
"812893", "宇都宮",
"812979", "竜ケ崎",
"818264", "安芸吉田",
"812647", "長野",
"817492", "彦根",
"812895", "宇都宮",
"811538", "根室標津",
"818696", "備前",
"812697", "飯山",
"811236", "千歳",
"819688", "玉名",
"817364", "和歌山橋本",
"819673", "熊本一の宮",
"811857", "能代",
"819675", "熊本一の宮",
"818474", "府中",
"811457", "門別富川",
"818874", "安芸",
"81937", "北九州",
"811653", "士別",
"81979", "中津",
"811655", "名寄",
"817967", "八鹿",
"8182943", "広島",
"81125", "滝川",
"818842", "阿南",
"815953", "上野",
"815982", "松阪",
"815955", "上野",
"81467", "藤沢",
"818892", "佐川",
"814795", "銚子",
"81927", "福岡",
"814793", "銚子",
"81252", "新潟",
"8125482", "村上",
"81928", "福岡",
"818208", "久賀",
"811644", "留萌",
"81468", "横須賀",
"815972", "尾鷲",
"815584", "下田",
"812614", "大町",
"814285", "相模原",
"811533", "根室",
"81544", "富士宮",
"81938", "北九州",
"814754", "茂原",
"815397", "浜松",
"8198294", "延岡",
"81983", "高鍋",
"812898", "鹿沼",
"814283", "青梅",
"811535", "厚岸",
"81898", "今治",
"812936", "水戸",
"811366", "寿都",
"81549", "静岡",
"819683", "山鹿",
"819934", "指宿",
"819685", "玉名",
"815994", "阿児",
"8125481", "村上",
"81584", "大垣",
"814224", "武蔵野三鷹",
"817959", "三田",
"819678", "矢部",
"817732", "福知山",
"8198293", "延岡",
"811658", "上川",
"811869", "大館",
"811876", "大曲",
"812549", "津川",
"815958", "亀山",
"81798", "西宮",
"814798", "八日市場",
"817484", "八日市",
"812780", "前橋",
"812854", "小山",
"81592", "津",
"817466", "十津川",
"811956", "岩手",
"818376", "美祢",
"812377", "寒河江",
"819788", "国東",
"818796", "土庄",
"812797", "渋川",
"818662", "高梁",
"812582", "長岡",
"812974", "水海道",
"812555", "糸魚川",
"812553", "上越",
"819976", "名瀬",
"812747", "富岡",
"817993", "洲本",
"819969", "中甑",
"817995", "洲本",
"812992", "石岡",
"81162", "稚内",
"818369", "宇部",
"817943", "加古川",
"817945", "加古川",
"819802", "南大東",
"818583", "倉吉",
"818466", "木江",
"818552", "浜田",
"818585", "倉吉",
"81434", "千葉",
"815368", "設楽",
"811987", "遠野",
"81236", "山形",
"8199331", "鹿児島",
"81439", "木更津",
"818879", "室戸",
"81969", "天草",
"815566", "身延",
"81563", "西尾",
"811753", "むつ",
"811547", "白糠",
"81424", "武蔵野三鷹",
"81964", "松橋",
"81226", "気仙沼",
"818943", "八幡浜",
"818945", "八幡浜",
"81429", "所沢",
"818479", "東城",
"818564", "益田",
"811365", "倶知安",
"812935", "水戸",
"812789", "前橋",
"811238", "栗山",
"818698", "備前",
"819686", "玉名",
"812933", "高萩",
"811363", "倶知安",
"814286", "相模原",
"8198296", "日向",
"811536", "厚岸",
"81166", "旭川",
"814998", "小笠原",
"81778", "武生",
"817737", "舞鶴",
"812968", "笠間",
"81596", "伊勢",
"817950", "三田",
"815758", "郡上八幡",
"8124196", "柳津",
"815392", "浜松",
"811875", "角館",
"8112391", "夕張",
"81222", "仙台",
"818654", "鴨方",
"811873", "角館",
"81485", "熊谷",
"81878", "高松",
"819232", "前原",
"819734", "日田",
"8198295", "日向",
"815977", "熊野",
"815744", "美濃加茂",
"811589", "興部",
"8198298", "日向",
"817946", "三木",
"811542", "釧路",
"81535", "浜松",
"817996", "津名",
"819973", "種子島",
"812556", "糸魚川",
"818557", "川本",
"819554", "伊万里",
"811528", "美幌",
"819975", "名瀬",
"818793", "三本松",
"817465", "吉野",
"818373", "長門",
"811953", "二戸",
"818375", "美祢",
"817463", "吉野",
"811982", "花巻",
"811955", "二戸",
"818795", "三本松",
"818838", "阿波池田",
"812679", "佐久",
"8186697", "倉敷",
"818946", "宇和",
"818388", "田万川",
"818360", "小郡",
"815565", "鰍沢青柳",
"81572", "多治見",
"819807", "沖縄宮古",
"812997", "潮来",
"811756", "野辺地",
"81930", "行橋",
"818804", "土佐中村",
"815563", "鰍沢青柳",
"812372", "村山",
"81460", "小田原",
"812792", "渋川",
"812244", "白石",
"812742", "藤岡",
"819664", "人吉",
"818463", "竹原",
"81253", "新潟",
"818586", "倉吉",
"812587", "長岡",
"819598", "福江",
"818667", "井原",
"817230", "寝屋川",
"812911", "鉾田",
"812577", "六日町",
"817352", "新宮",
"814220", "国分寺",
"812382", "米沢",
"8188090", "窪川",
"812832", "佐野",
"811523", "斜里",
"8153963", "天竜",
"81176", "十和田",
"8168", "大阪",
"819978", "徳之島",
"811525", "網走",
"81942", "久留米",
"81471", "柏",
"812784", "沼田",
"817468", "上北山",
"8164", "大阪",
"811958", "岩手",
"818378", "下関",
"819786", "杵築",
"818798", "土庄",
"818383", "萩",
"818835", "脇町",
"818833", "鴨島",
"811584", "遠軽",
"817722", "宮津",
"811972", "水沢",
"818385", "萩",
"819952", "大口",
"819543", "武雄",
"815366", "設楽",
"8112399", "栗山",
"8186999", "岡山瀬戸",
"81281", "宇都宮",
"81184", "本荘",
"819593", "大瀬戸",
"8186552", "倉敷",
"81144", "苫小牧",
"811397", "奥尻",
"811944", "岩泉",
"819595", "有川",
"812914", "鉾田",
"81593", "四日市",
"815987", "三瀬谷",
"812938", "水戸",
"818693", "邑久",
"81834", "徳山",
"811233", "千歳",
"811235", "夕張",
"818695", "岡山瀬戸",
"818847", "牟岐",
"81280", "古河",
"8112392", "夕張",
"8186992", "備前",
"81240", "磐城富岡",
"81877", "丸亀",
"81839", "山口",
"812896", "鹿沼",
"811333", "当別",
"812963", "下館",
"818206", "柳井",
"81958", "長崎",
"811852", "男鹿",
"812965", "下館",
"811566", "十勝清水",
"815753", "関",
"817962", "豊岡",
"811452", "早来",
"815755", "関",
"817497", "長浜",
"812642", "木曾福島",
"81734", "和歌山",
"814796", "八日市場",
"81192", "大船渡",
"812692", "中野",
"811878", "大曲",
"81739", "田辺",
"815956", "上野",
"81724", "岸和田貝塚",
"81562", "尾張横須賀",
"811656", "美深",
"81729", "八尾",
"812674", "小諸",
"819676", "高森",
"815763", "下呂",
"811556", "帯広",
"817952", "西脇",
"811462", "浦河",
"81552", "甲府",
"815765", "下呂",
"819722", "佐伯",
"811862", "鹿角",
"819576", "島原",
"812955", "常陸大宮",
"812574", "柏崎",
"81273", "高崎",
"812787", "沼田",
"815738", "中津川",
"8153962", "天竜",
"812542", "新発田",
"817916", "竜野",
"818978", "伯方",
"8125488", "津川",
"817713", "亀岡",
"819435", "八女",
"818952", "宇和島",
"811372", "鹿部",
"819433", "八女",
"817715", "亀岡",
"815979", "熊野",
"811587", "中湧別",
"811394", "松前",
"818595", "米子",
"812571", "六日町",
"812917", "水戸",
"81742", "奈良",
"811947", "久慈",
"818593", "米子",
"818545", "木次",
"81438", "木更津",
"8186553", "倉敷",
"818543", "安来",
"818559", "川本",
"817458", "大和榛原",
"818894", "須崎",
"81939", "北九州",
"81533", "豊橋",
"81977", "別府",
"815984", "松阪",
"818844", "阿南",
"81934", "北九州",
"81899", "松山",
"81548", "榛原",
"8186993", "備前",
"812488", "須賀川",
"8112393", "夕張",
"817676", "七尾",
"8125486", "津川",
"811935", "釜石",
"817703", "敦賀",
"81464", "厚木",
"817705", "小浜",
"811933", "釜石",
"81929", "福岡",
"812238", "仙台",
"814775", "船橋",
"818872", "室戸",
"818472", "甲山",
"81266", "諏訪",
"81924", "福岡",
"817362", "和歌山橋本",
"811736", "五所川原",
"8125485", "津川",
"817906", "播磨山崎",
"817494", "彦根",
"812589", "長岡",
"818262", "加計",
"818669", "総社",
"818676", "久世",
"812677", "佐久",
"812473", "石川",
"819962", "川内",
"812475", "石川",
"817472", "五条",
"819809", "八重山",
"812875", "大田原",
"8112394", "夕張",
"817618", "加賀",
"8186994", "岡山瀬戸",
"812873", "大田原",
"818362", "宇部",
"812999", "潮来",
"812852", "小山",
"817455", "大和高田",
"817482", "八日市",
"8145", "横浜",
"817453", "大和高田",
"814298", "飯能",
"812483", "白河",
"81263", "松本",
"818686", "津山",
"812566", "三条",
"818567", "津和野",
"812485", "白河",
"812233", "岩沼",
"811938", "宮古",
"812235", "仙台",
"812830", "宇都宮",
"812579", "小出",
"817734", "福知山",
"812416", "田島",
"814222", "武蔵野三鷹",
"81721", "富田林",
"819932", "指宿",
"815992", "鳥羽",
"812656", "伊那",
"81857", "鳥取",
"818657", "笠岡",
"817686", "能都",
"814752", "茂原",
"812612", "大町",
"815582", "下田",
"815974", "尾鷲",
"811642", "石狩深川",
"81547", "島田",
"815747", "美濃白川",
"812478", "三春",
"819826", "日向",
"812878", "烏山",
"81587", "一宮",
"817613", "小松",
"81292", "水戸",
"817615", "小松",
"819737", "玖珠",
"817960", "八鹿",
"815768", "下呂",
"81276", "太田",
"814706", "大原",
"81474", "船橋",
"81427", "相模原",
"815735", "恵那",
"815733", "恵那",
"818975", "新居浜",
"818554", "浜田",
"819557", "唐津",
"811353", "余市",
"818973", "新居浜",
"819743", "三重",
"819804", "名護",
"81249", "郡山",
"819438", "田主丸",
"818807", "宿毛",
"81284", "足利",
"812994", "石岡",
"817718", "園部",
"819946", "鹿屋",
"81244", "原町",
"81486", "浦和",
"819667", "水俣",
"818598", "根雨",
"812247", "大河原",
"818246", "三次",
"818664", "高梁",
"8153961", "天竜",
"812584", "長岡",
"812972", "水海道",
"812640", "長野",
"818548", "石見大田",
"811636", "北見枝幸",
"818296", "広島",
"8188097", "土佐清水",
"815398", "浜松",
"812643", "木曾福島",
"81277", "桐生",
"818896", "須崎",
"812897", "鹿沼",
"812645", "木曾福島",
"81436", "市原",
"81234", "酒田",
"812693", "中野",
"815986", "松阪",
"818846", "丹生谷",
"812695", "中野",
"817674", "羽咋",
"81550", "御殿場",
"814709", "鴨川",
"81229", "古川",
"811567", "十勝清水",
"8198290", "延岡",
"81426", "八王子",
"818207", "久賀",
"819204", "郷ノ浦",
"811734", "五所川原",
"811232", "千歳",
"818692", "邑久",
"811639", "利尻礼文",
"81740", "今津",
"818299", "広島",
"815957", "上野",
"817904", "福崎",
"814797", "八日市場",
"817496", "長浜",
"818249", "東広島",
"8178", "神戸",
"81487", "浦和",
"812962", "下館",
"811332", "当別",
"818674", "久世",
"811853", "男鹿",
"819949", "大根占",
"811855", "能代",
"819677", "矢部",
"814992", "伊豆大島",
"815752", "関",
"8125487", "津川",
"811455", "鵡川",
"817963", "豊岡",
"811453", "早来",
"817965", "豊岡",
"81157", "北見",
"818382", "萩",
"811975", "水沢",
"817725", "宮津",
"811554", "帯広",
"812419", "田島",
"818832", "鴨島",
"817723", "宮津",
"811973", "水沢",
"819955", "加治木",
"819574", "諫早",
"819953", "大口",
"812576", "十日町",
"819542", "武雄",
"812569", "巻",
"818689", "岡山",
"812798", "長野原",
"819787", "国東",
"817914", "相生",
"812378", "寒河江",
"8199343", "鹿児島",
"81537", "掛川",
"819592", "大瀬戸",
"81495", "本庄",
"812748", "富岡",
"811548", "弟子屈",
"817355", "新宮",
"81551", "韮崎",
"81268", "上田",
"8111", "札幌",
"817353", "新宮",
"812230", "仙台",
"812835", "佐野",
"812383", "米沢",
"8153974", "天竜",
"812385", "米沢",
"812833", "宇都宮",
"81765", "魚津",
"811396", "江差",
"811522", "斜里",
"81546", "静岡",
"815367", "設楽",
"811551", "十勝池田",
"812659", "伊那",
"81586", "一宮",
"811978", "北上",
"817728", "峰山",
"81182", "横手",
"817997", "津名",
"814704", "館山",
"815562", "鰍沢青柳",
"818512", "西郷",
"817947", "三木",
"81142", "伊達",
"812373", "村山",
"812793", "渋川",
"812795", "渋川",
"818391", "小郡",
"8188096", "土佐清水",
"812375", "村山",
"812557", "新井",
"818556", "江津",
"812743", "藤岡",
"818462", "竹原",
"812745", "藤岡",
"81984", "小林",
"819806", "沖縄宮古",
"8188095", "土佐清水",
"811545", "釧路",
"811757", "野辺地",
"812996", "潮来",
"81949", "直方",
"81543", "静岡",
"811543", "釧路",
"818679", "新見",
"81989", "那覇",
"812838", "佐野",
"814770", "市川",
"81583", "岐阜",
"819944", "鹿屋",
"812388", "長井",
"81538", "磐田",
"818947", "宇和",
"81944", "瀬高",
"814240", "国分寺",
"819972", "種子島",
"818244", "三次",
"818666", "井原",
"818587", "郡家",
"81853", "出雲",
"812586", "長岡",
"814701", "鴨川",
"818792", "三本松",
"811634", "浜頓別",
"811952", "二戸",
"818294", "廿日市",
"818372", "長門",
"811983", "花巻",
"815395", "浜松",
"81423", "国分寺",
"814287", "青梅",
"811537", "中標津",
"81722", "堺",
"815393", "浜松",
"812648", "長野",
"81564", "岡崎",
"818684", "津山",
"812564", "三条",
"81963", "熊本",
"819687", "玉名",
"812698", "飯山",
"81569", "半田",
"81433", "千葉",
"819233", "前原",
"81875", "観音寺",
"81488", "浦和",
"81199", "盛岡",
"817736", "舞鶴",
"811559", "帯広",
"812414", "柳津",
"8188098", "土佐清水",
"812654", "飯田",
"811362", "倶知安",
"812932", "高萩",
"81822", "広島",
"817684", "輪島",
"81775", "大津",
"811858", "能代",
"81832", "下関",
"819824", "延岡",
"817968", "浜坂",
"8169", "大阪",
"81992", "鹿児島",
"81744", "大和高田",
"814707", "大原",
"817944", "加古川",
"818958", "御荘",
"811378", "今金",
"817994", "洲本",
"812554", "上越",
"812975", "水海道",
"812973", "水海道",
"819556", "唐津",
"812899", "鹿沼",
"819947", "志布志",
"818397", "小郡",
"817958", "丹波柏原",
"818944", "八幡浜",
"819679", "高森",
"81849", "福山",
"811868", "鷹巣",
"81776", "福井",
"819728", "臼杵",
"811754", "むつ",
"818806", "宿毛",
"812551", "上越",
"811637", "北見枝幸",
"818297", "廿日市",
"81554", "大月",
"815959", "亀山",
"815732", "恵那",
"812246", "大河原",
"818247", "庄原",
"81220", "迫",
"819666", "水俣",
"818690", "岡山",
"81559", "沼津",
"818584", "倉吉",
"818972", "新居浜",
"819742", "三重",
"811352", "余市",
"812567", "巻",
"818687", "美作",
"81863", "玉野",
"815993", "鳥羽",
"819933", "指宿",
"815995", "阿児",
"8186698", "倉敷",
"819684", "山鹿",
"819935", "加世田",
"819789", "杵築",
"814284", "立川",
"8124197", "柳津",
"81124", "芦別",
"8125480", "村上",
"818268", "千代田",
"814755", "東金",
"814753", "茂原",
"811534", "中標津",
"812613", "大町",
"815583", "下田",
"81177", "青森",
"81792", "姫路",
"819968", "出水",
"811643", "石狩深川",
"812417", "会津山口",
"81493", "東松山",
"811645", "留萌",
"815585", "下田",
"812615", "大町",
"818368", "宇部",
"817612", "小松",
"81975", "大分",
"81134", "小樽",
"81763", "福野",
"817687", "能都",
"812853", "小山",
"817483", "八日市",
"8161", "大阪",
"817452", "大和高田",
"817485", "八日市",
"81462", "厚木",
"8198297", "日向",
"812855", "小山",
"81922", "福岡",
"812482", "白河",
"8162", "大阪",
"812657", "伊那",
"818656", "笠岡",
"81892", "久万",
"812232", "岩沼",
"818878", "嶺北",
"814281", "相模原",
"814225", "武蔵野三鷹",
"8163", "大阪",
"817368", "岩出",
"81932", "北九州",
"819827", "高千穂",
"815746", "美濃加茂",
"818478", "東城",
"814223", "武蔵野三鷹",
"819938", "加世田",
"815998", "阿児",
"814758", "東金",
"812559", "安塚",
"818265", "安芸吉田",
"818263", "加計",
"81294", "常陸太田",
"81940", "宗像",
"81191", "一関",
"812894", "宇都宮",
"818204", "柳井",
"812472", "石川",
"819965", "川内",
"811648", "焼尻",
"819963", "川内",
"81561", "瀬戸",
"815588", "修善寺大仁",
"812618", "大町",
"811564", "上士幌",
"817473", "五条",
"818365", "宇部",
"817677", "七尾",
"812872", "大田原",
"817949", "加古川",
"818363", "宇部",
"817475", "下市",
"814794", "銚子",
"817488", "水口",
"81585", "揖斐川",
"812858", "真岡",
"81545", "富士",
"811737", "鰺ケ沢",
"81178", "八戸",
"815954", "上野",
"817907", "播磨山崎",
"818875", "土佐山田",
"814772", "市川",
"817702", "敦賀",
"811932", "釜石",
"811654", "名寄",
"818873", "安芸",
"81766", "高岡",
"814228", "武蔵野三鷹",
"817365", "和歌山橋本",
"818473", "甲山",
"818677", "新見",
"812676", "佐久",
"818949", "宇和",
"817238", "寝屋川",
"818475", "府中",
"817363", "和歌山橋本",
"819674", "熊本一の宮",
"81965", "八代",
"817712", "亀岡",
"819577", "島原",
"818953", "宇和島",
"811375", "八雲",
"819432", "八女",
"818955", "宇和島",
"811557", "十勝池田",
"81167", "富良野",
"81425", "立川",
"814289", "青梅",
"81282", "栃木",
"812978", "竜ケ崎",
"818592", "米子",
"811539", "根室標津",
"812786", "沼田",
"81242", "会津若松",
"819784", "豊後高田",
"818542", "安来",
"817917", "竜野",
"815762", "下呂",
"817953", "西脇",
"811465", "静内",
"817955", "三田",
"811463", "浦河",
"811586", "中湧別",
"819723", "佐伯",
"811863", "鹿角",
"81956", "佐世保",
"811865", "大館",
"819725", "佐伯",
"812545", "村上",
"812543", "新発田",
"811946", "久慈",
"812930", "水戸",};
$areanames{en} = {"817676", "Nanao\,\ Ishikawa",
"812937", "Mito\,\ Ibaraki",
"81298", "Tsuchiura\,\ Ibaraki",
"81464", "Atsugi\,\ Kanagawa",
"811367", "Suttsu\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"8125486", "Tsugawa\,\ Niigata",
"817703", "Tsuruga\,\ Fukui",
"817705", "Obama\,\ Fukui",
"811933", "Kamaishi\,\ Iwate",
"812484", "Shirakawa\,\ Fukushima",
"814775", "Funabashi\,\ Chiba",
"818872", "Muroto\,\ Kochi",
"812238", "Sendai\,\ Miyagi",
"8167", "Osaka\,\ Osaka",
"81929", "Fukuoka\,\ Fukuoka",
"817454", "Yamatotakada\,\ Nara",
"81266", "Suwa\,\ Nagano",
"81924", "Fukuoka\,\ Fukuoka",
"817735", "Fukuchiyama\,\ Kyoto",
"81259", "Sado\,\ Niigata",
"818559", "Kawamoto\,\ Shimane",
"8152", "Nagoya\,\ Aichi",
"81533", "Toyohashi\,\ Aichi",
"81939", "Kitakyushu\,\ Fukuoka",
"818894", "Susaki\,\ Kochi",
"817733", "Fukuchiyama\,\ Kyoto",
"81977", "Beppu\,\ Oita",
"815769", "Shokawa\,\ Gifu",
"815984", "Matsusaka\,\ Mie",
"818844", "Anan\,\ Tokushima",
"81934", "Kitakyushu\,\ Fukuoka",
"8186993", "Bizen\,\ Okayama",
"81548", "Haibara\,\ Shizuoka",
"812234", "Sendai\,\ Miyagi",
"8112393", "Yubari\,\ Hokkaido",
"812488", "Sukagawa\,\ Fukushima",
"81899", "Matsuyama\,\ Ehime",
"818676", "Kuse\,\ Okayama",
"812677", "Saku\,\ Nagano",
"811532", "Nemuro\,\ Hokkaido",
"812473", "Ishikawa\,\ Fukushima",
"817498", "Nagahama\,\ Shiga",
"812475", "Ishikawa\,\ Fukushima",
"81935", "Kitakyushu\,\ Fukuoka",
"819962", "Satsumasendai\,\ Kagoshima",
"81174", "Kanita\,\ Aomori",
"814282", "Ome\,\ Tokyo",
"819809", "Yaeyama\ District\,\ Okinawa",
"819682", "Yamaga\,\ Kumamoto",
"812875", "Otawara\,\ Tochigi",
"811877", "Omagari\,\ Akita",
"812873", "Otawara\,\ Tochigi",
"8112394", "Yubari\,\ Hokkaido",
"817618", "Kaga\,\ Ishikawa",
"8186994", "Seto\,\ Okayama",
"81179", "Sannohe\,\ Aomori",
"812999", "Itako\,\ Ibaraki",
"818362", "Ube\,\ Yamaguchi",
"811736", "Goshogawara\,\ Aomori",
"817614", "Komatsu\,\ Ishikawa",
"8125485", "Tsugawa\,\ Niigata",
"81925", "Fukuoka\,\ Fukuoka",
"817494", "Hikone\,\ Shiga",
"81465", "Odawara\,\ Kanagawa",
"818669", "Soja\,\ Okayama",
"818262", "Kake\,\ Hiroshima",
"812589", "Nagaoka\,\ Niigata",
"8153969", "Hamamatsu\,\ Shizuoka",
"815973", "Owase\,\ Mie",
"81273", "Takasaki\,\ Gunma",
"815738", "Nakatsugawa\,\ Gifu",
"812787", "Numata\,\ Gunma",
"811752", "Mutsu\,\ Aomori",
"81726", "Ibaraki\,\ Osaka",
"811939", "Miyako\,\ Iwate",
"812542", "Shibata\,\ Niigata",
"812578", "Muika\,\ Niigata",
"81557", "Ito\,\ Shizuoka",
"818978", "Hakata\,\ Ehime",
"818942", "Yawatahama\,\ Ehime",
"8125488", "Tsugawa\,\ Niigata",
"811556", "Obihiro\,\ Hokkaido",
"811354", "Yoichi\,\ Hokkaido",
"818555", "Gotsu\,\ Shimane",
"815763", "Gero\,\ Gifu",
"819744", "Mie\,\ Oita",
"818974", "Niihama\,\ Ehime",
"818582", "Kurayoshi\,\ Tottori",
"817952", "Nishiwaki\,\ Hyogo",
"81552", "Kofu\,\ Yamanashi",
"81270", "Isesaki\,\ Gunma",
"819977", "Setouchi\,\ Kagoshima",
"812746", "Tomioka\,\ Gunma",
"811462", "Urakawa\,\ Hokkaido",
"815765", "Gero\,\ Gifu",
"818553", "Hamada\,\ Shimane",
"815734", "Ena\,\ Gifu",
"819722", "Saiki\,\ Oita",
"811862", "Kazuno\,\ Akita",
"819576", "Shimabara\,\ Nagasaki",
"818797", "Tonosho\,\ Kagawa",
"812796", "Shibukawa\,\ Gunma",
"811957", "Iwate\,\ Iwate",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"818377", "Shimonoseki\,\ Yamaguchi",
"812376", "Sagae\,\ Yamagata",
"812574", "Kashiwazaki\,\ Niigata",
"818595", "Yonago\,\ Tottori",
"811394", "Matsumae\,\ Hokkaido",
"812571", "Muika\,\ Niigata",
"817992", "Sumoto\,\ Hyogo",
"812917", "Mito\,\ Ibaraki",
"818593", "Yonago\,\ Tottori",
"81742", "Nara\,\ Nara",
"811947", "Kuji\,\ Iwate",
"812993", "Ishioka\,\ Ibaraki",
"819805", "Nago\,\ Okinawa",
"81438", "Kisarazu\,\ Chiba",
"818545", "Kisuki\,\ Shimane",
"811546", "Kushiro\,\ Hokkaido",
"812879", "Nasukarasuyama\,\ Tochigi",
"817942", "Kakogawa\,\ Hyogo",
"818543", "Yasugi\,\ Shimane",
"812995", "Ishioka\,\ Ibaraki",
"819803", "Nago\,\ Okinawa",
"8186553", "Kurashiki\,\ Okayama",
"817713", "Kameoka\,\ Kyoto",
"811986", "Tono\,\ Iwate",
"811372", "Shikabe\,\ Hokkaido",
"81531", "Tahara\,\ Aichi",
"819435", "Yame\,\ Fukuoka",
"818952", "Uwajima\,\ Ehime",
"819433", "Yame\,\ Fukuoka",
"8144", "Kawasaki\,\ Kanagawa",
"817715", "Kameoka\,\ Kyoto",
"818467", "Mima\,\ Tokushima",
"815979", "Kumano\,\ Mie",
"811398", "Kumaishi\,\ Hokkaido",
"81480", "Kuki\,\ Saitama",
"818663", "Soja\,\ Okayama",
"812583", "Nagaoka\,\ Niigata",
"818665", "Takahashi\,\ Okayama",
"811587", "Nakayubetsu\,\ Hokkaido",
"8147955", "Yokaichiba\,\ Chiba",
"812585", "Nagaoka\,\ Niigata",
"812552", "Joetsu\,\ Niigata",
"812573", "Kashiwazaki\,\ Niigata",
"81432", "Chiba\,\ Chiba",
"81427", "Sagamihara\,\ Kanagawa",
"815735", "Ena\,\ Gifu",
"81245", "Fukushima\,\ Fukushima",
"819956", "Kajiki\,\ Kagoshima",
"812575", "Tokamachi\,\ Niigata",
"812239", "Sendai\,\ Miyagi",
"815733", "Ena\,\ Gifu",
"818975", "Niihama\,\ Ehime",
"818554", "Hamada\,\ Shimane",
"811976", "Kitakami\,\ Iwate",
"819557", "Karatsu\,\ Saga",
"819743", "Mie\,\ Oita",
"815764", "Gero\,\ Gifu",
"818973", "Niihama\,\ Ehime",
"811353", "Yoichi\,\ Hokkaido",
"818558", "Kawamoto\,\ Shimane",
"8186691", "Kurashiki\,\ Okayama",
"811527", "Bihoro\,\ Hokkaido",
"8153975", "Hamamatsu\,\ Shizuoka",
"815768", "Gero\,\ Gifu",
"81276", "Ota\,\ Gunma",
"81723", "Sakai\,\ Osaka",
"81474", "Funabashi\,\ Chiba",
"8199345", "Kagoshima\,\ Kagoshima",
"8166", "Osaka\,\ Osaka",
"812489", "Sukagawa\,\ Fukushima",
"81962", "Kumamoto\,\ Kumamoto",
"815362", "Shinshiro\,\ Aichi",
"81888", "Kochi\,\ Kochi",
"812836", "Sano\,\ Tochigi",
"819667", "Minamata\,\ Kumamoto",
"8153976", "Hamamatsu\,\ Shizuoka",
"812247", "Ogawara\,\ Miyagi",
"818246", "Miyoshi\,\ Hiroshima",
"818387", "Tamagawa\,\ Yamaguchi",
"81833", "Kudamatsu\,\ Yamaguchi",
"812584", "Nagaoka\,\ Niigata",
"812386", "Nagai\,\ Yamagata",
"818664", "Takahashi\,\ Okayama",
"81594", "Kuwana\,\ Mie",
"819808", "Yaeyama\ District\,\ Okinawa",
"817356", "Kushimoto\,\ Wakayama",
"812640", "Nagano\,\ Nagano",
"819434", "Yame\,\ Fukuoka",
"818296", "Hiroshima\,\ Hiroshima",
"8188097", "Tosashimizu\,\ Kochi",
"81848", "Onomichi\,\ Hiroshima",
"817714", "Kameoka\,\ Kyoto",
"812998", "Itako\,\ Ibaraki",
"819782", "Bungotakada\,\ Oita",
"818544", "Kisuki\,\ Shimane",
"819804", "Nago\,\ Okinawa",
"819438", "Tanushimaru\,\ Fukuoka",
"81249", "Koriyama\,\ Fukushima",
"81284", "Ashikaga\,\ Tochigi",
"818807", "Sukumo\,\ Kochi",
"819547", "Kashima\,\ Saga",
"81823", "Kure\,\ Hiroshima",
"817718", "Sonobe\,\ Kyoto",
"812994", "Ishioka\,\ Ibaraki",
"811395", "Esashi\,\ Hokkaido",
"818594", "Yonago\,\ Tottori",
"81486", "Urawa\,\ Saitama",
"819946", "Kanoya\,\ Kagoshima",
"81244", "Hobara\,\ Fukushima",
"812588", "Nagaoka\,\ Niigata",
"818680", "Okayama\,\ Okayama",
"8183768", "Shimonoseki\,\ Yamaguchi",
"812560", "Itoigawa\,\ Niigata",
"818668", "Ibara\,\ Okayama",
"819597", "Fukue\,\ Nagasaki",
"811393", "Matsumae\,\ Hokkaido",
"812233", "Iwanuma\,\ Miyagi",
"811938", "Miyako\,\ Iwate",
"818843", "Anan\,\ Tokushima",
"815985", "Matsusaka\,\ Mie",
"818240", "Higashi\-ku\,\ Hiroshima",
"818493", "Onomichi\,\ Hiroshima",
"815983", "Matsusaka\,\ Mie",
"818697", "Bizen\,\ Okayama",
"812696", "Iiyama\,\ Nagano",
"811237", "Kuriyama\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"812235", "Sendai\,\ Miyagi",
"817734", "Fukuchiyama\,\ Kyoto",
"812416", "Tajima\,\ Fukushima",
"818893", "Sakawa\,\ Kochi",
"818895", "Susaki\,\ Kochi",
"814792", "Choshi\,\ Chiba",
"818290", "Hiroshima\,\ Hiroshima",
"81260", "Anan\,\ Nagano",
"812646", "Nagano\,\ Nagano",
"81183", "Yuzawa\,\ Akita",
"817738", "Maizuru\,\ Kyoto",
"812852", "Oyama\,\ Tochigi",
"817455", "Yamatotakada\,\ Nara",
"817482", "Yokaichi\,\ Shiga",
"811337", "Ishikari\,\ Hokkaido",
"817453", "Yamatotakada\,\ Nara",
"81138", "Hakodate\,\ Hokkaido",
"812967", "Kasama\,\ Ibaraki",
"8145", "Yokohama\,\ Kanagawa",
"814298", "Hanno\,\ Saitama",
"812483", "Shirakawa\,\ Fukushima",
"812566", "Sanjo\,\ Niigata",
"811652", "Shibetsu\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"811934", "Kamaishi\,\ Iwate",
"81263", "Matsumoto\,\ Nagano",
"818686", "Tsuyama\,\ Okayama",
"819940", "Shibushi\,\ Kagoshima",
"817704", "Tsuruga\,\ Fukui",
"8186997", "Seto\,\ Okayama",
"8112397", "Kuriyama\,\ Hokkaido",
"81143", "Muroran\,\ Hokkaido",
"812485", "Shirakawa\,\ Fukushima",
"812892", "Utsunomiya\,\ Tochigi",
"815974", "Owase\,\ Mie",
"815582", "Shimoda\,\ Shizuoka",
"812612", "Omachi\,\ Nagano",
"814771", "Ichikawa\,\ Chiba",
"817495", "Nagahama\,\ Shiga",
"81852", "Matsue\,\ Shimane",
"819826", "Hyuga\,\ Miyazaki",
"817493", "Hikone\,\ Shiga",
"81547", "Shimada\,\ Shizuoka",
"812478", "Miharu\,\ Fukushima",
"817613", "Komatsu\,\ Ishikawa",
"8153978", "Hamamatsu\,\ Shizuoka",
"81292", "Mito\,\ Ibaraki",
"812878", "Nasukarasuyama\,\ Tochigi",
"81587", "Ichinomiya\,\ Aichi",
"819737", "Kusu\,\ Oita",
"817615", "Komatsu\,\ Ishikawa",
"81721", "Tondabayashi\,\ Osaka",
"815992", "Toba\,\ Mie",
"814291", "Hanno\,\ Saitama",
"812874", "Otawara\,\ Tochigi",
"819932", "Ibusuki\,\ Kagoshima",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81542", "Shizuoka\,\ Shizuoka",
"811562", "Honbetsu\,\ Hokkaido",
"812656", "Ina\,\ Nagano",
"818657", "Kasaoka\,\ Okayama",
"81857", "Tottori\,\ Tottori",
"81582", "Gifu\,\ Gifu",
"815978", "Kumano\,\ Mie",
"817686", "Noto\,\ Ishikawa",
"811856", "Noshiro\,\ Akita",
"812474", "Ishikawa\,\ Fukushima",
"814752", "Mobara\,\ Chiba",
"818202", "Yanai\,\ Yamaguchi",
"814700", "Kamogawa\,\ Chiba",
"8153967", "Hamamatsu\,\ Shizuoka",
"81793", "Himeji\,\ Hyogo",
"812556", "Itoigawa\,\ Niigata",
"818557", "Kawamoto\,\ Shimane",
"8126175", "Omachi\,\ Nagano",
"81492", "Kawagoe\,\ Saitama",
"815767", "Gero\,\ Gifu",
"819554", "Imari\,\ Saga",
"811528", "Bihoro\,\ Hokkaido",
"819975", "Naze\,\ Kagoshima",
"811953", "Ninohe\,\ Iwate",
"818373", "Nagato\,\ Yamaguchi",
"817465", "Yoshino\,\ Nara",
"811982", "Hanamaki\,\ Iwate",
"811376", "Yakumo\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"818956", "Uwajima\,\ Ehime",
"812957", "Daigo\,\ Ibaraki",
"818375", "Mine\,\ Yamaguchi",
"817463", "Yoshino\,\ Nara",
"812939", "Mito\,\ Ibaraki",
"81862", "Okayama\,\ Okayama",
"812785", "Numata\,\ Gunma",
"812783", "Numata\,\ Gunma",
"817946", "Miki\,\ Hyogo",
"8198298", "Hyuga\,\ Miyazaki",
"811542", "Kushiro\,\ Hokkaido",
"81535", "Hamamatsu\,\ Shizuoka",
"817996", "Tsuna\,\ Hyogo",
"811524", "Abashiri\,\ Hokkaido",
"819558", "Karatsu\,\ Saga",
"81893", "Ozu\,\ Ehime",
"819437", "Tanushimaru\,\ Fukuoka",
"812372", "Murayama\,\ Yamagata",
"81460", "Odawara\,\ Kanagawa",
"81948", "Iizuka\,\ Fukuoka",
"81534", "Hamamatsu\,\ Shizuoka",
"812792", "Shibukawa\,\ Gunma",
"819572", "Isahaya\,\ Nagasaki",
"817717", "Sonobe\,\ Kyoto",
"811866", "Takanosu\,\ Akita",
"818808", "Tosashimizu\,\ Kochi",
"819726", "Usuki\,\ Oita",
"811583", "Monbetsu\,\ Hokkaido",
"812244", "Shiroishi\,\ Miyagi",
"81577", "Takayama\,\ Gifu",
"819664", "Hitoyoshi\,\ Kumamoto",
"811466", "Erimo\,\ Hokkaido",
"81933", "Kitakyushu\,\ Fukuoka",
"818834", "Kamojima\,\ Tokushima",
"812742", "Fujioka\,\ Gunma",
"818463", "Takehara\,\ Hiroshima",
"817956", "Sanda\,\ Hyogo",
"811552", "Obihiro\,\ Hokkaido",
"819598", "Fukue\,\ Nagasaki",
"811585", "Engaru\,\ Hokkaido",
"818667", "Ibara\,\ Okayama",
"81253", "Niigata\,\ Niigata",
"81988", "Naha\,\ Okinawa",
"818586", "Kurayoshi\,\ Tottori",
"818384", "Hagi\,\ Yamaguchi",
"812587", "Nagaoka\,\ Niigata",
"812248", "Ogawara\,\ Miyagi",
"81762", "Kanazawa\,\ Ishikawa",
"812913", "Hokota\,\ Ibaraki",
"819668", "Minamata\,\ Kumamoto",
"812679", "Saku\,\ Nagano",
"811943", "Iwaizumi\,\ Iwate",
"818946", "Uwajima\,\ Ehime",
"81463", "Hiratsuka\,\ Kanagawa",
"811945", "Kuji\,\ Iwate",
"8126176", "Omachi\,\ Nagano",
"8186697", "Kurashiki\,\ Okayama",
"818360", "Ogori\,\ Yamaguchi",
"818388", "Tamagawa\,\ Yamaguchi",
"81923", "Fukuoka\,\ Fukuoka",
"818547", "Kakeya\,\ Shimane",
"81250", "Niitsu\,\ Niigata",
"817912", "Aioi\,\ Hyogo",
"812546", "Murakami\,\ Niigata",
"81572", "Tajimi\,\ Gifu",
"812997", "Itako\,\ Ibaraki",
"81930", "Yukuhashi\,\ Fukuoka",
"814280", "Tachikawa\,\ Tokyo",
"819544", "Takeo\,\ Saga",
"811756", "Noheji\,\ Aomori",
"814998", "Ogasawara\,\ Tokyo",
"81778", "Takefu\,\ Fukui",
"817737", "Maizuru\,\ Kyoto",
"814297", "Hanno\,\ Saitama",
"819979", "Tokunoshima\,\ Kagoshima",
"812968", "Kasama\,\ Ibaraki",
"81596", "Ise\,\ Mie",
"817902", "Fukusaki\,\ Hyogo",
"81568", "Kasugai\,\ Aichi",
"818568", "Tsuwano\,\ Shimane",
"817950", "Sanda\,\ Hyogo",
"818694", "Okayama\,\ Okayama",
"811234", "Chitose\,\ Hokkaido",
"811732", "Goshogawara\,\ Aomori",
"811365", "Kutchan\,\ Hokkaido",
"812935", "Mito\,\ Ibaraki",
"818564", "Masuda\,\ Shimane",
"811937", "Miyako\,\ Iwate",
"818366", "Ube\,\ Yamaguchi",
"812789", "Maebashi\,\ Gunma",
"81489", "Soka\,\ Saitama",
"814777", "Funabashi\,\ Chiba",
"819686", "Tamana\,\ Kumamoto",
"811238", "Kuriyama\,\ Hokkaido",
"81286", "Utsunomiya\,\ Tochigi",
"818698", "Bizen\,\ Okayama",
"812933", "Takahagi\,\ Ibaraki",
"811363", "Kutchan\,\ Hokkaido",
"817476", "Shimonoseki\,\ Yamaguchi",
"817707", "Obama\,\ Fukui",
"815754", "Sekigahara\,\ Gifu",
"814286", "Sagamihara\,\ Kanagawa",
"81484", "Kawaguchi\,\ Saitama",
"81246", "Iwaki\,\ Fukushima",
"819966", "Izumi\,\ Kagoshima",
"8198296", "Hyuga\,\ Miyazaki",
"81166", "Asahikawa\,\ Hokkaido",
"811536", "Akkeshi\,\ Hokkaido",
"812964", "Shimodate\,\ Ibaraki",
"81485", "Kumagaya\,\ Saitama",
"81878", "Takamatsu\,\ Kagawa",
"812550", "Yasuzuka\,\ Niigata",
"819232", "Maebaru\,\ Fukuoka",
"819734", "Hita\,\ Oita",
"8165", "Osaka\,\ Osaka",
"8198295", "Hyuga\,\ Miyazaki",
"815977", "Kumano\,\ Mie",
"81952", "Saga\,\ Saga",
"811589", "Okoppe\,\ Hokkaido",
"815744", "Minokamo\,\ Gifu",
"81227", "Sendai\,\ Miyagi",
"817366", "Iwade\,\ Wakayama",
"8124196", "Yanaizu\,\ Fukushima",
"812675", "Saku\,\ Nagano",
"817940", "Kakogawa\,\ Hyogo",
"812673", "Komoro\,\ Nagano",
"812477", "Miharu\,\ Fukushima",
"818476", "Fuchu\,\ Hiroshima",
"815392", "Hamamatsu\,\ Shizuoka",
"812877", "Kuroiso\,\ Tochigi",
"81476", "Narita\,\ Chiba",
"8112391", "Yubari\,\ Hokkaido",
"811875", "Kakunodate\,\ Akita",
"818654", "Kamogata\,\ Okayama",
"8126178", "Omachi\,\ Nagano",
"81222", "Sendai\,\ Miyagi",
"817672", "Hakui\,\ Ishikawa",
"819738", "Kusu\,\ Oita",
"811873", "Kakunodate\,\ Akita",
"811333", "Tobetsu\,\ Hokkaido",
"818206", "Yanai\,\ Yamaguchi",
"812963", "Shimodate\,\ Ibaraki",
"817457", "Yamatotakada\,\ Nara",
"811852", "Oga\,\ Akita",
"81958", "Nagasaki\,\ Nagasaki",
"814756", "Togane\,\ Chiba",
"817682", "Wajima\,\ Ishikawa",
"812965", "Shimodate\,\ Ibaraki",
"818565", "Masuda\,\ Shimane",
"815753", "Sekigahara\,\ Gifu",
"812934", "Takahagi\,\ Ibaraki",
"812652", "Iida\,\ Nagano",
"811364", "Kutchan\,\ Hokkaido",
"817962", "Toyooka\,\ Hyogo",
"811452", "Hayakita\,\ Hokkaido",
"815996", "Ago\,\ Mie",
"812487", "Sukagawa\,\ Fukushima",
"819936", "Kaseda\,\ Kagoshima",
"81243", "Nihonmatsu\,\ Fukushima",
"815755", "Sekigahara\,\ Gifu",
"818563", "Masuda\,\ Shimane",
"8188099", "Tosashimizu\,\ Kochi",
"81593", "Yokkaichi\,\ Mie",
"812938", "Mito\,\ Ibaraki",
"818693", "Oku\,\ Okayama",
"811233", "Chitose\,\ Hokkaido",
"81834", "Tokuyama\,\ Yamaguchi",
"811235", "Yubari\,\ Hokkaido",
"818695", "Seto\,\ Okayama",
"812237", "Sendai\,\ Miyagi",
"81280", "Koga\,\ Ibaraki",
"8112392", "Yubari\,\ Hokkaido",
"81725", "Izumi\,\ Osaka",
"81877", "Marugame\,\ Kagawa",
"8186992", "Bizen\,\ Okayama",
"819822", "Nobeoka\,\ Miyazaki",
"81839", "Yamaguchi\,\ Yamaguchi",
"811646", "Haboro\,\ Hokkaido",
"812896", "Kanuma\,\ Tochigi",
"815586", "Shimoda\,\ Shizuoka",
"812616", "Omachi\,\ Nagano",
"811874", "Kakunodate\,\ Akita",
"811656", "Bifuka\,\ Hokkaido",
"812562", "Sanjo\,\ Niigata",
"818655", "Kamogata\,\ Okayama",
"818682", "Tsuyama\,\ Okayama",
"81729", "Yao\,\ Osaka",
"81835", "Hofu\,\ Yamaguchi",
"812674", "Komoro\,\ Nagano",
"817486", "Minakuchi\,\ Shiga",
"8182920", "Hatsukaichi\,\ Hiroshima",
"8112390", "Yubari\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"819599", "Oseto\,\ Nagasaki",
"819676", "Takamori\,\ Kumamoto",
"81473", "Ichikawa\,\ Chiba",
"815743", "Minokamo\,\ Gifu",
"817497", "Nagahama\,\ Shiga",
"814796", "Yokaichiba\,\ Chiba",
"81734", "Wakayama\,\ Wakayama",
"812678", "Saku\,\ Nagano",
"81567", "Tsushima\,\ Aichi",
"812412", "Kitakata\,\ Fukushima",
"815745", "Minokamo\,\ Gifu",
"812692", "Nakano\,\ Nagano",
"819733", "Hita\,\ Oita",
"811878", "Omagari\,\ Akita",
"81192", "Ofunato\,\ Iwate",
"81825", "Hiroshima\,\ Hiroshima",
"81739", "Tanabe\,\ Wakayama",
"817617", "Kaga\,\ Ishikawa",
"819735", "Hita\,\ Oita",
"811523", "Shari\,\ Hokkaido",
"8168", "Osaka\,\ Osaka",
"81176", "Towada\,\ Aomori",
"819978", "Tokunoshima\,\ Kagoshima",
"811525", "Abashiri\,\ Hokkaido",
"81471", "Kashiwa\,\ Chiba",
"81942", "Kurume\,\ Fukuoka",
"817468", "Kamikitayama\,\ Nara",
"8164", "Osaka\,\ Osaka",
"812784", "Numata\,\ Gunma",
"818378", "Shimonoseki\,\ Yamaguchi",
"811958", "Iwate\,\ Iwate",
"818798", "Tonosho\,\ Kagawa",
"819786", "Kitsuki\,\ Oita",
"817464", "Yoshino\,\ Nara",
"815737", "Nakatsugawa\,\ Gifu",
"817230", "Neyagawa\,\ Osaka",
"812788", "Maebashi\,\ Gunma",
"812911", "Hokota\,\ Ibaraki",
"81578", "Kamioka\,\ Akita",
"818374", "Nagato\,\ Yamaguchi",
"81987", "Nichinan\,\ Miyazaki",
"812577", "Muika\,\ Niigata",
"811954", "Ninohe\,\ Iwate",
"818292", "Hiroshima\,\ Hiroshima",
"811632", "Teshio\,\ Hokkaido",
"814220", "Kokubunji\,\ Tokyo",
"817352", "Shingu\,\ Fukuoka",
"819553", "Imari\,\ Saga",
"812382", "Yonezawa\,\ Yamagata",
"819747", "Taketa\,\ Oita",
"81947", "Tagawa\,\ Fukuoka",
"818977", "Hakata\,\ Ehime",
"811357", "Iwanai\,\ Hokkaido",
"818242", "Higashi\-ku\,\ Hiroshima",
"819974", "Yakushima\,\ Kagoshima",
"812832", "Sano\,\ Tochigi",
"819555", "Karatsu\,\ Saga",
"818514", "Ama\,\ Shimane",
"819543", "Takeo\,\ Saga",
"815366", "Shitara\,\ Aichi",
"81466", "Fujisawa\,\ Kanagawa",
"8112399", "Kuriyama\,\ Hokkaido",
"8186999", "Seto\,\ Okayama",
"81281", "Utsunomiya\,\ Tochigi",
"81184", "Yurihonjo\,\ Akita",
"814702", "Tateyama\,\ Chiba",
"81144", "Tomakomai\,\ Hokkaido",
"8186552", "Kurashiki\,\ Okayama",
"819593", "Oseto\,\ Nagasaki",
"811397", "Okushiri\,\ Hokkaido",
"811944", "Iwaizumi\,\ Iwate",
"812914", "Hokota\,\ Ibaraki",
"81926", "Fukuoka\,\ Fukuoka",
"811588", "Okoppe\,\ Hokkaido",
"818383", "Hagi\,\ Yamaguchi",
"8153964", "Hamamatsu\,\ Shizuoka",
"812245", "Ogawara\,\ Miyagi",
"818835", "Mima\,\ Tokushima",
"818464", "Takehara\,\ Hiroshima",
"819665", "Hitoyoshi\,\ Kumamoto",
"818833", "Kamojima\,\ Tokushima",
"819663", "Hitoyoshi\,\ Kumamoto",
"81591", "Tsu\,\ Mie",
"818385", "Hagi\,\ Yamaguchi",
"817722", "Miyazu\,\ Kyoto",
"811584", "Engaru\,\ Hokkaido",
"811972", "Mizusawa\,\ Iwate",
"812243", "Shiroishi\,\ Miyagi",
"81896", "Iyomishima\,\ Ehime",
"812890", "Utsunomiya\,\ Tochigi",
"819952", "Okuchi\,\ Kagoshima",
"81936", "Kitakyushu\,\ Fukuoka",
"815583", "Shimoda\,\ Shizuoka",
"812613", "Omachi\,\ Nagano",
"81177", "Aomori\,\ Aomori",
"81792", "Himeji\,\ Hyogo",
"814288", "Ome\,\ Tokyo",
"812893", "Utsunomiya\,\ Tochigi",
"819968", "Izumi\,\ Kagoshima",
"817492", "Hikone\,\ Shiga",
"811645", "Rumoi\,\ Hokkaido",
"81493", "Higashimatsuyama\,\ Saitama",
"812647", "Nagano\,\ Nagano",
"812615", "Omachi\,\ Nagano",
"815585", "Shimoda\,\ Shizuoka",
"812895", "Utsunomiya\,\ Tochigi",
"818368", "Ube\,\ Yamaguchi",
"81134", "Otaru\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"817612", "Komatsu\,\ Ishikawa",
"819688", "Tamana\,\ Kumamoto",
"818696", "Bizen\,\ Okayama",
"812697", "Iiyama\,\ Nagano",
"811236", "Chitose\,\ Hokkaido",
"818687", "Mimasaka\,\ Okayama",
"81863", "Tamano\,\ Okayama",
"818364", "Ube\,\ Yamaguchi",
"81986", "Miyakonojo\,\ Miyazaki",
"819933", "Ibusuki\,\ Kagoshima",
"81797", "Nishinomiya\,\ Hyogo",
"815993", "Toba\,\ Mie",
"81172", "Hirosaki\,\ Aomori",
"8186698", "Kurashiki\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"819935", "Kaseda\,\ Kagoshima",
"815995", "Ago\,\ Mie",
"811563", "Honbetsu\,\ Hokkaido",
"819789", "Kitsuki\,\ Oita",
"81124", "Ashibetsu\,\ Hokkaido",
"818205", "Yanai\,\ Yamaguchi",
"814284", "Tachikawa\,\ Tokyo",
"8124197", "Yanaizu\,\ Fukushima",
"814755", "Togane\,\ Chiba",
"8125480", "Murakami\,\ Niigata",
"819964", "Satsumasendai\,\ Kagoshima",
"814753", "Mobara\,\ Chiba",
"811534", "Nakashibetsu\,\ Hokkaido",
"81946", "Amagi\,\ Fukuoka",
"811336", "Ishikari\,\ Hokkaido",
"818203", "Yanai\,\ Yamaguchi",
"812232", "Iwanuma\,\ Miyagi",
"81892", "Kumakogen\,\ Ehime",
"8182943", "Hiroshima\,\ Hiroshima",
"81125", "Takikawa\,\ Hokkaido",
"8153968", "Hamamatsu\,\ Shizuoka",
"818842", "Anan\,\ Tokushima",
"815982", "Matsusaka\,\ Mie",
"814281", "Sagamihara\,\ Kanagawa",
"81467", "Fujisawa\,\ Kanagawa",
"8163", "Osaka\,\ Osaka",
"817368", "Iwade\,\ Wakayama",
"81927", "Fukuoka\,\ Fukuoka",
"81932", "Kitakyushu\,\ Fukuoka",
"814795", "Choshi\,\ Chiba",
"818892", "Sakawa\,\ Kochi",
"814793", "Choshi\,\ Chiba",
"815746", "Minokamo\,\ Gifu",
"818478", "Tojo\,\ Hiroshima",
"8125482", "Murakami\,\ Niigata",
"81252", "Niigata\,\ Niigata",
"819827", "Takachiho\,\ Miyazaki",
"812853", "Oyama\,\ Tochigi",
"81763", "Fukuno\,\ Toyama",
"817687", "Noto\,\ Ishikawa",
"8161", "Osaka\,\ Osaka",
"817483", "Yokaichi\,\ Shiga",
"81462", "Atsugi\,\ Kanagawa",
"8198297", "Hyuga\,\ Miyazaki",
"817452", "Yamatotakada\,\ Nara",
"817485", "Yokaichi\,\ Shiga",
"812855", "Oyama\,\ Tochigi",
"818474", "Fuchu\,\ Hiroshima",
"811857", "Noshiro\,\ Akita",
"818874", "Aki\,\ Kochi",
"81937", "Kitakyushu\,\ Fukuoka",
"812482", "Shirakawa\,\ Fukushima",
"81922", "Fukuoka\,\ Fukuoka",
"81979", "Nakatsu\,\ Oita",
"8162", "Osaka\,\ Osaka",
"811653", "Shibetsu\,\ Hokkaido",
"812657", "Ina\,\ Nagano",
"818656", "Kasaoka\,\ Okayama",
"811655", "Nayoro\,\ Hokkaido",
"8128798", "Otawara\,\ Tochigi",
"811977", "Kitakami\,\ Iwate",
"812554", "Joetsu\,\ Niigata",
"817998", "Tsuna\,\ Hyogo",
"812619", "Omachi\,\ Nagano",
"819556", "Karatsu\,\ Saga",
"81885", "Komatsushima\,\ Tokushima",
"81478", "Sawara\,\ Chiba",
"812899", "Kanuma\,\ Tochigi",
"81845", "Innoshima\,\ Hiroshima",
"819957", "Kajiki\,\ Kagoshima",
"811374", "Mori\,\ Hokkaido",
"818954", "Uwajima\,\ Ehime",
"817948", "Miki\,\ Hyogo",
"819783", "Bungotakada\,\ Oita",
"81744", "Yamatotakada\,\ Nara",
"8147950", "Yokaichiba\,\ Chiba",
"811378", "Imakane\,\ Hokkaido",
"817944", "Kakogawa\,\ Hyogo",
"818958", "Misho\,\ Ehime",
"8125489", "Tsugawa\,\ Niigata",
"815999", "Tsu\,\ Mie",
"819785", "Bungotakada\,\ Oita",
"81555", "Fujiyoshida\,\ Yamanashi",
"817994", "Sumoto\,\ Hyogo",
"8153965", "Hamamatsu\,\ Shizuoka",
"811526", "Abashiri\,\ Hokkaido",
"811392", "Kikonai\,\ Hokkaido",
"818297", "Hatsukaichi\,\ Hiroshima",
"812572", "Kashiwazaki\,\ Niigata",
"817357", "Kushimoto\,\ Wakayama",
"81554", "Otsuki\,\ Yamanashi",
"815959", "Kameyama\,\ Mie",
"811864", "Odate\,\ Akita",
"815732", "Ena\,\ Gifu",
"819724", "Saiki\,\ Oita",
"812246", "Ogawara\,\ Miyagi",
"8153966", "Hamamatsu\,\ Shizuoka",
"818247", "Shobara\,\ Hiroshima",
"818690", "Okayama\,\ Okayama",
"819666", "Minamata\,\ Kumamoto",
"81559", "Numazu\,\ Shizuoka",
"818836", "Mima\,\ Tokushima",
"81288", "Imabari\,\ Ehime",
"811464", "Shizunai\,\ Hokkaido",
"812837", "Sano\,\ Tochigi",
"818948", "Uwajima\,\ Ehime",
"817954", "Nishiwaki\,\ Hyogo",
"817239", "Neyagawa\,\ Osaka",
"811352", "Yoichi\,\ Hokkaido",
"819742", "Mie\,\ Oita",
"818584", "Kurayoshi\,\ Tottori",
"818972", "Niihama\,\ Ehime",
"8153971", "Hamamatsu\,\ Shizuoka",
"81233", "Shinjo\,\ Yamagata",
"812387", "Nagai\,\ Yamagata",
"81196", "Morioka\,\ Iwate",
"819947", "Shibushi\,\ Kagoshima",
"818397", "Ogori\,\ Yamaguchi",
"818944", "Yawatahama\,\ Ehime",
"81566", "Kariya\,\ Aichi",
"812859", "Oyama\,\ Tochigi",
"819679", "Takamori\,\ Kumamoto",
"819596", "Fukue\,\ Nagasaki",
"818588", "Koge\,\ Tottori",
"81849", "Fukuyama\,\ Hiroshima",
"812544", "Shibata\,\ Niigata",
"81776", "Fukui\,\ Fukui",
"811868", "Takanosu\,\ Akita",
"81950", "Hirado\,\ Nagasaki",
"818806", "Sukumo\,\ Kochi",
"819546", "Kashima\,\ Saga",
"815363", "Shinshiro\,\ Aichi",
"812551", "Joetsu\,\ Niigata",
"819728", "Usuki\,\ Oita",
"811754", "Mutsu\,\ Aomori",
"814289", "Ome\,\ Tokyo",
"817993", "Sumoto\,\ Hyogo",
"81282", "Tochigi\,\ Tochigi",
"817995", "Sumoto\,\ Hyogo",
"818592", "Yonago\,\ Tottori",
"81162", "Wakkanai\,\ Hokkaido",
"818369", "Ube\,\ Yamaguchi",
"812992", "Ishioka\,\ Ibaraki",
"817943", "Kakogawa\,\ Hyogo",
"812786", "Numata\,\ Gunma",
"817945", "Kakogawa\,\ Hyogo",
"81242", "Aizuwakamatsu\,\ Fukushima",
"8153972", "Hamamatsu\,\ Shizuoka",
"819802", "Minamidaito\,\ Okinawa",
"819784", "Bungotakada\,\ Oita",
"818542", "Yasugi\,\ Shimane",
"81965", "Yatsushiro\,\ Kumamoto",
"819577", "Shimabara\,\ Nagasaki",
"817712", "Kameoka\,\ Kyoto",
"81592", "Tsu\,\ Mie",
"818953", "Uwajima\,\ Ehime",
"817466", "Totsukawa\,\ Nara",
"818376", "Mine\,\ Yamaguchi",
"819432", "Yame\,\ Fukuoka",
"812377", "Sagae\,\ Yamagata",
"818955", "Uwajima\,\ Ehime",
"811956", "Iwate\,\ Iwate",
"811375", "Yakumo\,\ Hokkaido",
"818796", "Tonosho\,\ Kagawa",
"812797", "Shibukawa\,\ Gunma",
"819788", "Kunisaki\,\ Oita",
"812582", "Nagaoka\,\ Niigata",
"812555", "Itoigawa\,\ Niigata",
"818662", "Takahashi\,\ Okayama",
"81167", "Furano\,\ Hokkaido",
"812553", "Joetsu\,\ Niigata",
"81425", "Tachikawa\,\ Tokyo",
"8126173", "Omachi\,\ Nagano",
"819976", "Naze\,\ Kagoshima",
"812747", "Tomioka\,\ Gunma",
"81563", "Nishio\,\ Aichi",
"811753", "Mutsu\,\ Aomori",
"818879", "Muroto\,\ Kochi",
"81969", "Amakusa\,\ Kumamoto",
"815566", "Minobu\,\ Yamanashi",
"811547", "Shiranuka\,\ Hokkaido",
"812545", "Murakami\,\ Niigata",
"812543", "Shibata\,\ Niigata",
"81226", "Kesennuma\,\ Miyagi",
"818943", "Yawatahama\,\ Ehime",
"81429", "Tokorozawa\,\ Saitama",
"811946", "Kuji\,\ Iwate",
"818945", "Yawatahama\,\ Ehime",
"8126174", "Omachi\,\ Nagano",
"812930", "Mito\,\ Ibaraki",
"818479", "Tojo\,\ Hiroshima",
"815762", "Gero\,\ Gifu",
"818583", "Kurayoshi\,\ Tottori",
"811465", "Shizunai\,\ Hokkaido",
"818466", "Mima\,\ Tokushima",
"817953", "Nishiwaki\,\ Hyogo",
"811463", "Urakawa\,\ Hokkaido",
"817955", "Sanda\,\ Hyogo",
"818552", "Hamada\,\ Shimane",
"818585", "Kurayoshi\,\ Tottori",
"81434", "Chiba\,\ Chiba",
"811586", "Nakayubetsu\,\ Hokkaido",
"819723", "Saiki\,\ Oita",
"815368", "Shitara\,\ Aichi",
"811987", "Tono\,\ Iwate",
"81236", "Yamagata\,\ Yamagata",
"811863", "Kazuno\,\ Akita",
"8153970", "Hamamatsu\,\ Shizuoka",
"811865", "Odate\,\ Akita",
"81956", "Sasebo\,\ Nagasaki",
"819725", "Saiki\,\ Oita",
"81439", "Kisarazu\,\ Chiba",
"8199331", "Kagoshima\,\ Kagoshima",
"814285", "Sagamihara\,\ Kanagawa",
"81544", "Fujinomiya\,\ Shizuoka",
"811533", "Nemuro\,\ Hokkaido",
"818204", "Yanai\,\ Yamaguchi",
"819965", "Satsumasendai\,\ Kagoshima",
"81938", "Kitakyushu\,\ Fukuoka",
"814754", "Mobara\,\ Chiba",
"812472", "Ishikawa\,\ Fukushima",
"8198294", "Nobeoka\,\ Miyazaki",
"819963", "Satsumasendai\,\ Kagoshima",
"812898", "Kanuma\,\ Tochigi",
"811535", "Akkeshi\,\ Hokkaido",
"814283", "Ome\,\ Tokyo",
"81983", "Takanabe\,\ Miyazaki",
"81561", "Seto\,\ Aichi",
"812618", "Omachi\,\ Nagano",
"81549", "Shizuoka\,\ Shizuoka",
"818365", "Ube\,\ Yamaguchi",
"81898", "Imabari\,\ Ehime",
"812936", "Mito\,\ Ibaraki",
"811564", "Kamishihoro\,\ Hokkaido",
"811366", "Suttsu\,\ Hokkaido",
"817677", "Nanao\,\ Ishikawa",
"819683", "Yamaga\,\ Kumamoto",
"817949", "Kakogawa\,\ Hyogo",
"815994", "Ago\,\ Mie",
"819685", "Tamana\,\ Kumamoto",
"819934", "Ibusuki\,\ Kagoshima",
"812872", "Otawara\,\ Tochigi",
"81584", "Ogaki\,\ Gifu",
"818363", "Ube\,\ Yamaguchi",
"817475", "Shimonoseki\,\ Yamaguchi",
"8125481", "Murakami\,\ Niigata",
"81928", "Fukuoka\,\ Fukuoka",
"815998", "Ago\,\ Mie",
"819938", "Kaseda\,\ Kagoshima",
"812559", "Yasuzuka\,\ Niigata",
"814758", "Togane\,\ Chiba",
"818263", "Kake\,\ Hiroshima",
"81940", "Munakata\,\ Fukuoka",
"81468", "Yokosuka\,\ Kanagawa",
"81294", "Hitachiota\,\ Ibaraki",
"811644", "Rumoi\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"812894", "Utsunomiya\,\ Tochigi",
"815972", "Owase\,\ Mie",
"815584", "Shimoda\,\ Shizuoka",
"812614", "Omachi\,\ Nagano",
"811876", "Omagari\,\ Akita",
"814772", "Ichikawa\,\ Chiba",
"817702", "Tsuruga\,\ Fukui",
"812549", "Tsugawa\,\ Niigata",
"811932", "Kamaishi\,\ Iwate",
"811654", "Nayoro\,\ Hokkaido",
"815958", "Kameyama\,\ Mie",
"818873", "Aki\,\ Kochi",
"81766", "Takaoka\,\ Toyama",
"81798", "Nishinomiya\,\ Hyogo",
"814798", "Yokaichiba\,\ Chiba",
"818677", "Niimi\,\ Okayama",
"812676", "Saku\,\ Nagano",
"817484", "Yokaichi\,\ Shiga",
"817238", "Neyagawa\,\ Osaka",
"812780", "Maebashi\,\ Gunma",
"818949", "Uwajima\,\ Ehime",
"818475", "Fuchu\,\ Hiroshima",
"812854", "Oyama\,\ Tochigi",
"814794", "Choshi\,\ Chiba",
"817488", "Minakuchi\,\ Shiga",
"8153979", "Hamamatsu\,\ Shizuoka",
"817959", "Sanda\,\ Hyogo",
"817732", "Fukuchiyama\,\ Kyoto",
"81585", "Ibigawa\,\ Gifu",
"812858", "Mooka\,\ Tochigi",
"8198293", "Nobeoka\,\ Miyazaki",
"81545", "Fuji\,\ Shizuoka",
"81178", "Hachinohe\,\ Aomori",
"811658", "Kamikawa\,\ Hokkaido",
"811869", "Odate\,\ Akita",
"819542", "Takeo\,\ Saga",
"814705", "Tateyama\,\ Chiba",
"818689", "Okayama\,\ Okayama",
"819578", "Shimabara\,\ Nagasaki",
"817914", "Aioi\,\ Hyogo",
"819787", "Kunisaki\,\ Oita",
"812798", "Naganohara\,\ Gunma",
"814703", "Tateyama\,\ Chiba",
"812378", "Sagae\,\ Yamagata",
"8199343", "Kagoshima\,\ Kagoshima",
"81764", "Toyama\,\ Toyama",
"81537", "Kakegawa\,\ Shizuoka",
"819592", "Oseto\,\ Nagasaki",
"8153973", "Hamamatsu\,\ Shizuoka",
"811558", "Hiroo\,\ Hokkaido",
"8198299", "Hyuga\,\ Miyazaki",
"81495", "Honjo\,\ Saitama",
"812748", "Tomioka\,\ Gunma",
"811975", "Mizusawa\,\ Iwate",
"817725", "Miyazu\,\ Kyoto",
"811554", "Obihiro\,\ Hokkaido",
"812419", "Tajima\,\ Fukushima",
"811356", "Iwanai\,\ Hokkaido",
"818976", "Niihama\,\ Ehime",
"819746", "Taketa\,\ Oita",
"818382", "Hagi\,\ Yamaguchi",
"81532", "Toyohashi\,\ Aichi",
"819662", "Hitoyoshi\,\ Kumamoto",
"811541", "Teshikaga\,\ Hokkaido",
"812744", "Fujioka\,\ Gunma",
"818832", "Kamojima\,\ Tokushima",
"817723", "Miyazu\,\ Kyoto",
"812242", "Shiroishi\,\ Miyagi",
"811973", "Mizusawa\,\ Iwate",
"812649", "Nagano\,\ Nagano",
"815736", "Nakatsugawa\,\ Gifu",
"8126172", "Omachi\,\ Nagano",
"819955", "Kajiki\,\ Kagoshima",
"819574", "Isahaya\,\ Nagasaki",
"819953", "Okuchi\,\ Kagoshima",
"812794", "Shibukawa\,\ Gunma",
"812374", "Murayama\,\ Yamagata",
"812576", "Tokamachi\,\ Niigata",
"81546", "Shizuoka\,\ Shizuoka",
"811396", "Esashi\,\ Hokkaido",
"811522", "Shari\,\ Hokkaido",
"8147957", "Yokaichiba\,\ Chiba",
"819945", "Kanoya\,\ Kagoshima",
"819943", "Kanoya\,\ Kagoshima",
"81864", "Kurashiki\,\ Okayama",
"811544", "Kushiro\,\ Hokkaido",
"815367", "Shitara\,\ Aichi",
"817969", "Hamasaka\,\ Hyogo",
"8126170", "Omachi\,\ Nagano",
"812659", "Ina\,\ Nagano",
"81586", "Ichinomiya\,\ Aichi",
"817355", "Shingu\,\ Fukuoka",
"811548", "Teshikaga\,\ Hokkaido",
"818295", "Hatsukaichi\,\ Hiroshima",
"811635", "Hamatonbetsu\,\ Hokkaido",
"811984", "Hanamaki\,\ Iwate",
"81268", "Ueda\,\ Nagano",
"81494", "Chichibu\,\ Saitama",
"81551", "Nirasaki\,\ Yamanashi",
"8111", "Sapporo\,\ Hokkaido",
"818293", "Hatsukaichi\,\ Hiroshima",
"817353", "Shingu\,\ Fukuoka",
"81188", "Akita\,\ Akita",
"812835", "Sano\,\ Tochigi",
"812230", "Sendai\,\ Miyagi",
"819552", "Imari\,\ Saga",
"818245", "Miyoshi\,\ Hiroshima",
"812383", "Yonezawa\,\ Yamagata",
"818243", "Higashi\-ku\,\ Hiroshima",
"818490", "Onomichi\,\ Hiroshima",
"812385", "Yonezawa\,\ Yamagata",
"81765", "Uozu\,\ Toyama",
"812833", "Utsunomiya\,\ Tochigi",
"81272", "Maebashi\,\ Gunma",
"814709", "Kamogawa\,\ Chiba",
"81550", "Gotenba\,\ Shizuoka",
"817674", "Hakui\,\ Ishikawa",
"818652", "Kurashiki\,\ Okayama",
"818685", "Tsuyama\,\ Okayama",
"812565", "Sanjo\,\ Niigata",
"818683", "Tsuyama\,\ Okayama",
"81426", "Hachioji\,\ Tokyo",
"8198290", "Nobeoka\,\ Miyazaki",
"812563", "Sanjo\,\ Niigata",
"812486", "Sukagawa\,\ Fukushima",
"819937", "Kaseda\,\ Kagoshima",
"81998", "Kagoshima\,\ Kagoshima",
"8182941", "Hiroshima\,\ Hiroshima",
"815997", "Ago\,\ Mie",
"814757", "Togane\,\ Chiba",
"815394", "Hamamatsu\,\ Shizuoka",
"817456", "Yamatotakada\,\ Nara",
"813", "Tokyo",
"812415", "Yanaizu\,\ Fukushima",
"815742", "Minokamo\,\ Gifu",
"815398", "Hamamatsu\,\ Shizuoka",
"81277", "Kiryu\,\ Gunma",
"81553", "Yamanashi\,\ Yamanashi",
"818896", "Susaki\,\ Kochi",
"812897", "Kanuma\,\ Tochigi",
"811647", "Haboro\,\ Hokkaido",
"81436", "Ichihara\,\ Chiba",
"812413", "Kitakata\,\ Fukushima",
"819732", "Hita\,\ Oita",
"81234", "Sakata\,\ Yamagata",
"817678", "Nanao\,\ Ishikawa",
"812693", "Nakano\,\ Nagano",
"815986", "Matsusaka\,\ Mie",
"812236", "Sendai\,\ Miyagi",
"81828", "Hiroshima\,\ Hiroshima",
"812695", "Nakano\,\ Nagano",
"818674", "Kuse\,\ Okayama",
"81235", "Tsuruoka\,\ Yamagata",
"812962", "Shimodate\,\ Ibaraki",
"811332", "Tobetsu\,\ Hokkaido",
"817685", "Wajima\,\ Ishikawa",
"8126179", "Omachi\,\ Nagano",
"811853", "Oga\,\ Akita",
"812857", "Mooka\,\ Tochigi",
"811855", "Noshiro\,\ Akita",
"817683", "Wajima\,\ Ishikawa",
"817487", "Minakuchi\,\ Shiga",
"81743", "Nara\,\ Nara",
"812653", "Iida\,\ Nagano",
"815752", "Sekigahara\,\ Gifu",
"817963", "Toyooka\,\ Hyogo",
"8125487", "Tsugawa\,\ Niigata",
"811455", "Mukawa\,\ Hokkaido",
"817965", "Toyooka\,\ Hyogo",
"81482", "Kawaguchi\,\ Saitama",
"81738", "Gobo\,\ Wakayama",
"811453", "Hayakita\,\ Hokkaido",
"812655", "Iida\,\ Nagano",
"818562", "Masuda\,\ Shimane",
"81157", "Kitami\,\ Hokkaido",
"811734", "Goshogawara\,\ Aomori",
"8198292", "Nobeoka\,\ Miyazaki",
"81225", "Ishinomaki\,\ Miyagi",
"818299", "Hiroshima\,\ Hiroshima",
"81740", "Imazu\,\ Shiga",
"811232", "Chitose\,\ Hokkaido",
"818692", "Oku\,\ Okayama",
"817616", "Komatsu\,\ Ishikawa",
"817904", "Fukusaki\,\ Hyogo",
"818678", "Niimi\,\ Okayama",
"814797", "Yokaichiba\,\ Chiba",
"812839", "Sano\,\ Tochigi",
"817496", "Nagahama\,\ Shiga",
"818249", "Higashi\-ku\,\ Hiroshima",
"819823", "Nobeoka\,\ Miyazaki",
"8178", "Kobe\,\ Hyogo",
"819825", "Hyuga\,\ Miyazaki",
"812389", "Yonezawa\,\ Yamagata",
"81487", "Urawa\,\ Saitama",
"81728", "Neyagawa\,\ Osaka",
"81433", "Chiba\,\ Chiba",
"818660", "Seto\,\ Okayama",
"8112395", "Kuriyama\,\ Hokkaido",
"818688", "Mimasaka\,\ Okayama",
"8186995", "Seto\,\ Okayama",
"812580", "Tokamachi\,\ Niigata",
"81875", "Kan\'onji\,\ Kagawa",
"81488", "Urawa\,\ Saitama",
"81727", "Ikeda\,\ Osaka",
"812799", "Naganohara\,\ Gunma",
"819233", "Maebaru\,\ Fukuoka",
"812694", "Nakano\,\ Nagano",
"81420", "Tokorozawa\,\ Saitama",
"81199", "Morioka\,\ Iwate",
"812414", "Yanaizu\,\ Fukushima",
"817736", "Maizuru\,\ Kyoto",
"811559", "Obihiro\,\ Hokkaido",
"8188098", "Tosashimizu\,\ Kochi",
"819967", "Izumi\,\ Kagoshima",
"8198291", "Nobeoka\,\ Miyazaki",
"815395", "Hamamatsu\,\ Shizuoka",
"81423", "Kokubunji\,\ Tokyo",
"814287", "Ome\,\ Tokyo",
"811537", "Nakashibetsu\,\ Hokkaido",
"81779", "Ono\,\ Gifu",
"812672", "Komoro\,\ Nagano",
"815393", "Hamamatsu\,\ Shizuoka",
"81737", "Yuasa\,\ Wakayama",
"812648", "Nagano\,\ Nagano",
"81564", "Okazaki\,\ Aichi",
"81722", "Sakai\,\ Osaka",
"817675", "Nanao\,\ Ishikawa",
"812564", "Sanjo\,\ Niigata",
"811936", "Miyako\,\ Iwate",
"818367", "Ube\,\ Yamaguchi",
"818684", "Tsuyama\,\ Okayama",
"8125484", "Murakami\,\ Niigata",
"81774", "Uji\,\ Kyoto",
"817706", "Obama\,\ Fukui",
"8183767", "Shimonoseki\,\ Yamaguchi",
"812698", "Iiyama\,\ Nagano",
"81886", "Tokushima\,\ Tokushima",
"81569", "Handa\,\ Aichi",
"817673", "Hakui\,\ Ishikawa",
"814776", "Funabashi\,\ Chiba",
"81963", "Kumamoto\,\ Kumamoto",
"819687", "Tamana\,\ Kumamoto",
"817688", "Noto\,\ Ishikawa",
"811858", "Noshiro\,\ Akita",
"819824", "Nobeoka\,\ Miyazaki",
"81832", "Shimonoseki\,\ Yamaguchi",
"81827", "Iwakuni\,\ Yamaguchi",
"81775", "Otsu\,\ Shiga",
"8182942", "Hiroshima\,\ Hiroshima",
"8125483", "Murakami\,\ Niigata",
"817903", "Fukusaki\,\ Hyogo",
"811735", "Goshogawara\,\ Aomori",
"817968", "Hamasaka\,\ Hyogo",
"8169", "Osaka\,\ Osaka",
"81992", "Kagoshima\,\ Kagoshima",
"81565", "Toyota\,\ Aichi",
"811733", "Goshogawara\,\ Aomori",
"812658", "Ina\,\ Nagano",
"817905", "Fukusaki\,\ Hyogo",
"811549", "Kushiro\,\ Hokkaido",
"811454", "Mukawa\,\ Hokkaido",
"812876", "Kuroiso\,\ Tochigi",
"8186996", "Seto\,\ Okayama",
"8112396", "Kuriyama\,\ Hokkaido",
"817964", "Toyooka\,\ Hyogo",
"81822", "Hiroshima\,\ Hiroshima",
"812654", "Iida\,\ Nagano",
"811362", "Kutchan\,\ Hokkaido",
"812932", "Takahagi\,\ Ibaraki",
"818675", "Kuse\,\ Okayama",
"817684", "Wajima\,\ Ishikawa",
"817367", "Iwade\,\ Wakayama",
"819828", "Takachiho\,\ Miyazaki",
"811854", "Oga\,\ Akita",
"812476", "Miharu\,\ Fukushima",
"818477", "Tojo\,\ Hiroshima",
"812373", "Murayama\,\ Yamagata",
"819575", "Isahaya\,\ Nagasaki",
"819954", "Kajiki\,\ Kagoshima",
"812793", "Shibukawa\,\ Gunma",
"8199347", "Kagoshima\,\ Kagoshima",
"812795", "Shibukawa\,\ Gunma",
"819573", "Isahaya\,\ Nagasaki",
"818391", "Ogori\,\ Yamaguchi",
"818957", "Misho\,\ Ehime",
"812375", "Murayama\,\ Yamagata",
"8188096", "Tosashimizu\,\ Kochi",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"811377", "Yakumo\,\ Hokkaido",
"818556", "Gotsu\,\ Shimane",
"81985", "Miyazaki\,\ Miyazaki",
"811555", "Obihiro\,\ Hokkaido",
"811582", "Monbetsu\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"811974", "Mizusawa\,\ Iwate",
"812743", "Fujioka\,\ Gunma",
"812745", "Fujioka\,\ Gunma",
"818462", "Takehara\,\ Hiroshima",
"815766", "Gero\,\ Gifu",
"811553", "Obihiro\,\ Hokkaido",
"8175", "Kyoto\,\ Kyoto",
"81182", "Yokote\,\ Akita",
"811978", "Kitakami\,\ Iwate",
"811942", "Iwaizumi\,\ Iwate",
"817997", "Tsuna\,\ Hyogo",
"814704", "Tateyama\,\ Chiba",
"81262", "Nagano\,\ Nagano",
"817915", "Aioi\,\ Hyogo",
"818512", "Nishigo\,\ Fukushima",
"817947", "Miki\,\ Hyogo",
"81142", "Date\,\ Hokkaido",
"812834", "Utsunomiya\,\ Tochigi",
"814240", "Kokubunji\,\ Tokyo",
"818398", "Ogori\,\ Yamaguchi",
"818244", "Miyoshi\,\ Hiroshima",
"819948", "Shibushi\,\ Kagoshima",
"818587", "Koge\,\ Tottori",
"81853", "Izumo\,\ Shimane",
"814701", "Kamogawa\,\ Chiba",
"812384", "Yonezawa\,\ Yamagata",
"812586", "Nagaoka\,\ Niigata",
"818666", "Ibara\,\ Okayama",
"817354", "Shingu\,\ Fukuoka",
"818372", "Nagato\,\ Yamaguchi",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811952", "Ninohe\,\ Iwate",
"818294", "Hatsukaichi\,\ Hiroshima",
"819727", "Usuki\,\ Oita",
"811983", "Hanamaki\,\ Iwate",
"817716", "Sonobe\,\ Kyoto",
"811867", "Takanosu\,\ Akita",
"8188095", "Tosashimizu\,\ Kochi",
"811545", "Kushiro\,\ Hokkaido",
"818546", "Kakeya\,\ Shimane",
"81984", "Kobayashi\,\ Miyazaki",
"812547", "Murakami\,\ Niigata",
"818298", "Hatsukaichi\,\ Hiroshima",
"811757", "Noheji\,\ Aomori",
"812782", "Numata\,\ Gunma",
"811543", "Kushiro\,\ Hokkaido",
"81543", "Shizuoka\,\ Shizuoka",
"812996", "Itako\,\ Ibaraki",
"81949", "Nogata\,\ Fukuoka",
"812838", "Sano\,\ Tochigi",
"814770", "Ichikawa\,\ Chiba",
"81126", "Iwamizawa\,\ Hokkaido",
"81583", "Gifu\,\ Gifu",
"81989", "Naha\,\ Okinawa",
"8126171", "Omachi\,\ Nagano",
"818679", "Niimi\,\ Okayama",
"818596", "Yonago\,\ Tottori",
"818248", "Shobara\,\ Hiroshima",
"819944", "Kanoya\,\ Kagoshima",
"812388", "Nagai\,\ Yamagata",
"8112398", "Kuriyama\,\ Hokkaido",
"8186998", "Seto\,\ Okayama",
"81538", "Iwata\,\ Shizuoka",
"81944", "Setaka\,\ Fukuoka",
"818947", "Uwajima\,\ Ehime",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;