# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210919194241;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '575',
                  'pattern' => '(\\d{7})'
                },
                {
                  'format' => '$1',
                  'leading_digits' => '
            5(?:
              0|
              2(?:
                21|
                3
              )|
              3(?:
                0|
                3[23]
              )|
              616|
              717|
              8888
            )
          ',
                  'pattern' => '(\\d{8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1800',
                  'pattern' => '(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '140',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            11|
            2[02]|
            33|
            4[04]|
            79(?:
              [124-6]|
              3(?:
                [02-9]|
                1[0-24-9]
              )|
              7(?:
                1|
                9[1-6]
              )
            )|
            80(?:
              [2-4]|
              6[0-589]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              2[0-24]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[1-9]|
              7[1257]|
              8[1-57-9]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[058]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[1-3]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[0-24-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12(?:
                [2-6]|
                7[0-8]
              )|
              74[2-7]
            )|
            7(?:
              (?:
                2[14]|
                5[15]
              )[2-6]|
              3171|
              61[346]|
              88(?:
                [2-7]|
                82
              )
            )|
            8(?:
              70[2-6]|
              84(?:
                [2356]|
                7[19]
              )|
              91(?:
                [3-6]|
                7[19]
              )
            )|
            73[134][2-6]|
            (?:
              74[47]|
              8(?:
                16|
                2[014]|
                3[126]|
                6[136]|
                7[78]|
                83
              )
            )(?:
              [2-6]|
              7[19]
            )|
            (?:
              1(?:
                29|
                60|
                8[06]
              )|
              261|
              552|
              6(?:
                [2-4]1|
                5[17]|
                6[13]|
                7(?:
                  1|
                  4[0189]
                )|
                80
              )|
              7(?:
                12|
                88[01]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              [2-479]|
              5(?:
                [0236-9]|
                5[013-9]
              )
            )|
            [2-5]|
            6(?:
              2(?:
                84|
                95
              )|
              355|
              83
            )|
            73179|
            807(?:
              1|
              9[1-3]
            )|
            (?:
              1552|
              6(?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                7[235689]|
                8[124-6]
              )\\d|
              7(?:
                1(?:
                  [013-8]\\d|
                  9[6-9]
                )|
                28[6-8]|
                3(?:
                  2[0-49]|
                  9[2-57]
                )|
                4(?:
                  1[2-4]|
                  [29][0-7]|
                  3[0-8]|
                  [56]\\d|
                  8[0-24-7]
                )|
                5(?:
                  2[1-3]|
                  9[0-6]
                )|
                6(?:
                  0[5689]|
                  2[5-9]|
                  3[02-8]|
                  4\\d|
                  5[0-367]
                )|
                70[13-7]
              )
            )[2-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[6-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6|
              8[06]0
            )
          ',
                  'pattern' => '(\\d{4})(\\d{2,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '18',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'geographic' => '
          2717(?:
            [2-7]\\d|
            95
          )\\d{4}|
          (?:
            271[0-689]|
            782[0-6]
          )[2-7]\\d{5}|
          (?:
            170[24]|
            2(?:
              (?:
                [02][2-79]|
                90
              )\\d|
              80[13468]
            )|
            (?:
              3(?:
                23|
                80
              )|
              683|
              79[1-7]
            )\\d|
            4(?:
              20[24]|
              72[2-8]
            )|
            552[1-7]
          )\\d{6}|
          (?:
            11|
            33|
            4[04]|
            80
          )[2-7]\\d{7}|
          (?:
            342|
            674|
            788
          )(?:
            [0189][2-7]|
            [2-7]\\d
          )\\d{5}|
          (?:
            1(?:
              2[0-249]|
              3[0-25]|
              4[145]|
              [59][14]|
              6[014]|
              7[1257]|
              8[01346]
            )|
            2(?:
              1[257]|
              3[013]|
              4[01]|
              5[0137]|
              6[0158]|
              78|
              8[1568]|
              9[14]
            )|
            3(?:
              26|
              4[13]|
              5[34]|
              6[01489]|
              7[02-46]|
              8[159]
            )|
            4(?:
              1[36]|
              2[1-47]|
              3[15]|
              5[12]|
              6[0-26-9]|
              7[014-9]|
              8[013-57]|
              9[014-7]
            )|
            5(?:
              1[025]|
              22|
              [36][25]|
              4[28]|
              [578]1|
              9[15]
            )|
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )|
            7(?:
              12|
              2[14]|
              3[134]|
              4[47]|
              5[15]|
              [67]1
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[078]|
              8[34]|
              91
            )
          )[2-7]\\d{6}|
          (?:
            1(?:
              2[35-8]|
              3[346-9]|
              4[236-9]|
              [59][0235-9]|
              6[235-9]|
              7[34689]|
              8[257-9]
            )|
            2(?:
              1[134689]|
              3[24-8]|
              4[2-8]|
              5[25689]|
              6[2-4679]|
              7[3-79]|
              8[2-479]|
              9[235-9]
            )|
            3(?:
              01|
              1[79]|
              2[1245]|
              4[5-8]|
              5[125689]|
              6[235-7]|
              7[157-9]|
              8[2-46-8]
            )|
            4(?:
              1[14578]|
              2[5689]|
              3[2-467]|
              5[4-7]|
              6[35]|
              73|
              8[2689]|
              9[2389]
            )|
            5(?:
              [16][146-9]|
              2[14-8]|
              3[1346]|
              4[14-69]|
              5[46]|
              7[2-4]|
              8[2-8]|
              9[246]
            )|
            6(?:
              1[1358]|
              2[2457]|
              3[2-4]|
              4[235-7]|
              5[2-689]|
              6[24578]|
              7[235689]|
              8[124-6]
            )|
            7(?:
              1[013-9]|
              2[0235-9]|
              3[2679]|
              4[1-35689]|
              5[2-46-9]|
              [67][02-9]|
              8[013-7]|
              9[089]
            )|
            8(?:
              1[1357-9]|
              2[235-8]|
              3[03-57-9]|
              4[0-24-9]|
              5\\d|
              6[2457-9]|
              7[1-6]|
              8[1256]|
              9[2-4]
            )
          )\\d[2-7]\\d{5}
        ',
                'mobile' => '
          (?:
            61279|
            7(?:
              887[02-9]|
              9(?:
                313|
                79[07-9]
              )
            )|
            8(?:
              079[04-9]|
              (?:
                84|
                91
              )7[02-8]
            )
          )\\d{5}|
          (?:
            6(?:
              12|
              [2-47]1|
              5[17]|
              6[13]|
              80
            )[0189]|
            7(?:
              1(?:
                2[0189]|
                9[0-5]
              )|
              2(?:
                [14][017-9]|
                8[0-59]
              )|
              3(?:
                2[5-8]|
                [34][017-9]|
                9[016-9]
              )|
              4(?:
                1[015-9]|
                [29][89]|
                39|
                8[389]
              )|
              5(?:
                [15][017-9]|
                2[04-9]|
                9[7-9]
              )|
              6(?:
                0[0-47]|
                1[0-257-9]|
                2[0-4]|
                3[19]|
                5[4589]
              )|
              70[0289]|
              88[089]|
              97[02-8]
            )|
            8(?:
              0(?:
                6[67]|
                7[02-8]
              )|
              70[017-9]|
              84[01489]|
              91[0-289]
            )
          )\\d{6}|
          (?:
            7(?:
              31|
              4[47]
            )|
            8(?:
              16|
              2[014]|
              3[126]|
              6[136]|
              7[78]|
              83
            )
          )(?:
            [0189]\\d|
            7[02-8]
          )\\d{5}|
          (?:
            6(?:
              [09]\\d|
              1[04679]|
              2[03689]|
              3[05-9]|
              4[0489]|
              50|
              6[069]|
              7[07]|
              8[7-9]
            )|
            7(?:
              0\\d|
              2[0235-79]|
              3[05-8]|
              40|
              5[0346-8]|
              6[6-9]|
              7[1-9]|
              8[0-79]|
              9[089]
            )|
            8(?:
              0[01589]|
              1[0-57-9]|
              2[235-9]|
              3[03-57-9]|
              [45]\\d|
              6[02457-9]|
              7[1-69]|
              8[0-25-9]|
              9[02-9]
            )|
            9\\d\\d
          )\\d{7}|
          (?:
            6(?:
              (?:
                1[1358]|
                2[2457]|
                3[2-4]|
                4[235-7]|
                5[2-689]|
                6[24578]|
                8[124-6]
              )\\d|
              7(?:
                [235689]\\d|
                4[0189]
              )
            )|
            7(?:
              1(?:
                [013-8]\\d|
                9[6-9]
              )|
              28[6-8]|
              3(?:
                2[0-49]|
                9[2-5]
              )|
              4(?:
                1[2-4]|
                [29][0-7]|
                3[0-8]|
                [56]\\d|
                8[0-24-7]
              )|
              5(?:
                2[1-3]|
                9[0-6]
              )|
              6(?:
                0[5689]|
                2[5-9]|
                3[02-8]|
                4\\d|
                5[0-367]
              )|
              70[13-7]|
              881
            )
          )[0189]\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1860\\d{7})|(186[12]\\d{9})|(140\\d{7})',
                'toll_free' => '
          000800\\d{7}|
          1(?:
            600\\d{6}|
            80(?:
              0\\d{4,9}|
              3\\d{9}
            )
          )
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"9162796", "Barauni\,\ Bihar",
"9166726", "Dharamgarh\,\ Odisha",
"9165336", "Basia\,\ Bihar",
"9164287", "Nala\,\ Bihar",
"918189", "Channagiri\,\ Karnataka",
"9171127", "Katol\,\ Maharashtra",
"915870", "Bhira\,\ Uttar\ Pradesh",
"915275", "Akbarpur\/Jalalpur\,\ Uttar\ Pradesh",
"918857", "Ramachandrapuram\,\ Andhra\ Pradesh",
"9171516", "Samudrapur\,\ Maharashtra",
"911828", "Sultanpur\ Lodhi\,\ Punjab",
"914542", "Kodaikanal\,\ Tamil\ Nadu",
"9176296", "Pushprajgarh\,\ Madhya\ Pradesh",
"9177068", "Gariaband\,\ Madhya\ Pradesh",
"9166415", "Deodgarh\,\ Odisha",
"917813", "Barpalli\,\ Madhya\ Pradesh",
"918839", "Rajahmundri\,\ Andhra\ Pradesh",
"9173226", "Depalpur\,\ Madhya\ Pradesh",
"912624", "Fortsongadh\,\ Gujarat",
"9171986", "Tirora\,\ Maharashtra",
"9164733", "Supaul\,\ Bihar",
"917289", "Zhirnia\,\ Madhya\ Pradesh",
"917682", "Chhatarpur\,\ Madhya\ Pradesh",
"915946", "Haldwani\,\ Uttar\ Pradesh",
"9176337", "Waraseoni\,\ Madhya\ Pradesh",
"918336", "Khanapur\,\ Karnataka",
"9171832", "Tumsar\,\ Maharashtra",
"9174802", "Goharganj\,\ Madhya\ Pradesh",
"9174682", "Khandar\,\ Rajasthan",
"912487", "Shrigonda\,\ Maharashtra",
"9176439", "Bijadandi\,\ Madhya\ Pradesh",
"9175965", "Gyraspur\,\ Madhya\ Pradesh",
"9165297", "Itki\,\ Bihar",
"918563", "Kamalapuram\/Yerraguntala\,\ Andhra\ Pradesh",
"9167495", "Bhubaneshwar\,\ Odisha",
"9164734", "Supaul\,\ Bihar",
"9176372", "Birsa\,\ Madhya\ Pradesh",
"918236", "Pandavpura\,\ Karnataka",
"915865", "Misrikh\,\ Uttar\ Pradesh",
"915260", "Tarabganj\,\ Uttar\ Pradesh",
"9171162", "Umrer\,\ Maharashtra",
"9171877", "Goregaon\,\ Maharashtra",
"913800", "Jairampur\,\ Arunachal\ Pradesh",
"9175947", "Ganjbasoda\,\ Madhya\ Pradesh",
"9165355", "Chainpur\,\ Bihar",
"918504", "Atmakur\,\ Andhra\ Pradesh",
"9174701", "Bundi\,\ Rajasthan",
"9168696", "Papadhandi\,\ Odisha",
"9175260", "Ghatigaon\,\ Madhya\ Pradesh",
"912630", "Bansada\,\ Gujarat",
"918415", "Hyderabad\ East\/Ghatkeswar\,\ Andhra\ Pradesh",
"9168185", "Buguda\,\ Odisha",
"9171062", "Bhiwapur\,\ Maharashtra",
"916412", "Bhagalpur\,\ Bihar",
"914204", "Kodumudi\,\ Tamil\ Nadu",
"9167252", "Dhanmandal\,\ Odisha",
"9163264", "Sherghati\,\ Bihar",
"917274", "Khategaon\,\ Madhya\ Pradesh",
"9176477", "Ghughari\,\ Madhya\ Pradesh",
"918514", "Nandyal\,\ Andhra\ Pradesh",
"912345", "Shirala\,\ Maharashtra",
"9176298", "Pushprajgarh\,\ Madhya\ Pradesh",
"913215", "Bongoan\,\ West\ Bengal",
"918741", "Sudhimalla\/Tekulapalli\,\ Andhra\ Pradesh",
"912773", "Malpur\,\ Gujarat",
"9176379", "Birsa\,\ Madhya\ Pradesh",
"918405", "Giddalur\,\ Andhra\ Pradesh",
"911951", "Badgam\,\ Jammu\ And\ Kashmir",
"9164345", "Dumka\,\ Bihar",
"9174957", "Badarwas\,\ Madhya\ Pradesh",
"9174584", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9164367", "Sahibganj\,\ Bihar",
"9162264", "Sitamarhi\,\ Bihar",
"917374", "Biaora\,\ Madhya\ Pradesh",
"917292", "Dhar\,\ Madhya\ Pradesh",
"9176432", "Bijadandi\,\ Madhya\ Pradesh",
"9171675", "Amarwada\,\ Madhya\ Pradesh",
"9167535", "Nayagarh\,\ Odisha",
"9173228", "Depalpur\,\ Madhya\ Pradesh",
"9177066", "Gariaband\,\ Madhya\ Pradesh",
"9174689", "Khandar\,\ Rajasthan",
"911998", "Ramban\,\ Jammu\ And\ Kashmir",
"9174809", "Goharganj\,\ Madhya\ Pradesh",
"9174914", "Narwar\,\ Madhya\ Pradesh",
"9174570", "Mangrol\,\ Rajasthan",
"9168107", "Khalikote\,\ Odisha",
"9162263", "Sitamarhi\,\ Bihar",
"9161815", "Piro\,\ Bihar",
"9167556", "Khurda\,\ Odisha",
"912969", "Bhinmal\,\ Rajasthan",
"91202", "Pune\,\ Maharashtra",
"917803", "Majholi\,\ Madhya\ Pradesh",
"9165476", "Chavparan\,\ Bihar",
"918228", "H\.D\.Kote\,\ Karnataka",
"9174913", "Narwar\,\ Madhya\ Pradesh",
"9164205", "Amarpur\,\ Bihar",
"9164322", "Deoghar\,\ Bihar",
"911257", "Meham\,\ Haryana",
"917791", "Gadarwara\,\ Madhya\ Pradesh",
"911632", "Ferozepur\,\ Punjab",
"9163263", "Sherghati\,\ Bihar",
"911573", "Laxmangarh\,\ Rajasthan",
"918242", "Mangalore\,\ Karnataka",
"918192", "Davangere\,\ Karnataka",
"917864", "Sukma\,\ Madhya\ Pradesh",
"918649", "Piduguralla\,\ Andhra\ Pradesh",
"915561", "Salempur\/Barhaj\,\ Uttar\ Pradesh",
"918328", "Goa",
"9171027", "Parseoni\,\ Maharashtra",
"9161552", "Ekma\,\ Bihar",
"917758", "Dabhara\,\ Madhya\ Pradesh",
"9174583", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9181529", "Kolar\,\ Karnatak",
"912976", "Sheoganj\/Posaliyan\,\ Rajasthan",
"9162426", "Benipur\,\ Bihar",
"9166496", "Jamankira\,\ Odisha",
"9163286", "Daudnagar\,\ Bihar",
"9165857", "Ghatsila\,\ Bihar",
"9181739", "Sakleshpur\,\ Karnataka",
"9171375", "Desaiganj\,\ Maharashtra",
"915497", "Zamania\,\ Uttar\ Pradesh",
"9164667", "Kishanganj\,\ Bihar",
"917820", "Khairagarh\,\ Madhya\ Pradesh",
"917225", "Tiwasa\,\ Maharashtra",
"915645", "Rupbas\,\ Rajasthan",
"918384", "Sirsi\,\ Karnataka",
"9176574", "Jaitpur\,\ Madhya\ Pradesh",
"911552", "Hanumangarh\,\ Rajasthan",
"9177070", "Bagbahera\,\ Madhya\ Pradesh",
"9173958", "Sondhwa\,\ Madhya\ Pradesh",
"9174389", "Keshoraipatan\/Patan\,\ Rajasthan",
"9174566", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9162715", "Benipatti\,\ Bihar",
"9162286", "Pupri\,\ Bihar",
"914566", "Aruppukottai\,\ Tamil\ Nadu",
"9163426", "H\.Kharagpur\,\ Bihar",
"9174227", "Mandsaur\,\ Madhya\ Pradesh",
"9174690", "Hindaun\,\ Rajasthan",
"9165814", "Bhandaria\,\ Bihar",
"9167922", "Baripada\,\ Odisha",
"918284", "Haliyal\,\ Karnataka",
"914333", "Ponnamaravathi\,\ Tamil\ Nadu",
"9164797", "Udakishanganj\,\ Bihar",
"917325", "Burhanpur\,\ Madhya\ Pradesh",
"912351", "Langa\,\ Maharashtra",
"912148", "Karjat\,\ Maharashtra",
"9165234", "Ghaghra\,\ Bihar",
"914119", "Ponneri\,\ Tamil\ Nadu",
"9167967", "Karanjia\,\ Odisha",
"9165813", "Bhandaria\,\ Bihar",
"911662", "Hissar\,\ Haryana",
"912957", "Vallabhnagar\,\ Rajasthan",
"911376", "Tehri\,\ Uttarakhand",
"9168615", "Malkangiri\,\ Odisha",
"9174262", "Sitamau\,\ Madhya\ Pradesh",
"9165233", "Ghaghra\,\ Bihar",
"917834", "Sitapur\,\ Madhya\ Pradesh",
"9162582", "Areraj\,\ Bihar",
"91370", "Kohima\,\ Nagaland",
"912939", "Jaitaran\,\ Rajasthan",
"912752", "Surendranagar\,\ Gujarat",
"9176573", "Jaitpur\,\ Madhya\ Pradesh",
"911276", "Bahadurgarh\,\ Haryana",
"9167945", "Rairangpur\,\ Odisha",
"9164622", "Dhamdaha\,\ Bihar",
"9185869", "Vayalpad\,\ Andhra\ Pradesh",
"9167416", "Bhubaneshwar\,\ Odisha",
"915962", "Almora\,\ Uttar\ Pradesh",
"912550", "Niphad\,\ Maharashtra",
"9161354", "Bikram\,\ Bihar",
"918869", "Pithapuram\,\ Andhra\ Pradesh",
"915178", "Mauranipur\,\ Uttar\ Pradesh",
"9173956", "Sondhwa\,\ Madhya\ Pradesh",
"9174568", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"911423", "Amber\/Chomu\,\ Rajasthan",
"911481", "Raipur\,\ Rajasthan",
"9166555", "Titlagarh\,\ Odisha",
"9164524", "Katihar\,\ Bihar",
"9165636", "Bhawanathpur\,\ Bihar",
"9166812", "Jujumura\,\ Odisha",
"9174269", "Sitamau\,\ Madhya\ Pradesh",
"912675", "Santrampur\,\ Gujarat",
"9171456", "Chicholi\,\ Madhya\ Pradesh",
"913823", "Belonia\,\ Tripura",
"9163366", "Rajauli\,\ Bihar",
"9171964", "Arjuni\ Morgaon\,\ Maharashtra",
"916122", "Patna\,\ Bihar",
"913484", "Kandi\,\ West\ Bengal",
"9164523", "Katihar\,\ Bihar",
"9165655", "Latehar\,\ Bihar",
"9173230", "Punasa\,\ Madhya\ Pradesh",
"918266", "Narsimharajapur\,\ Karnataka",
"9171435", "Bhainsdehi\,\ Madhya\ Pradesh",
"918694", "Ramannapet\,\ Andhra\ Pradesh",
"918379", "Hangal\,\ Karnataka",
"9171963", "Arjuni\ Morgaon\,\ Maharashtra",
"91154", "Sriganganagar\,\ Rajasthan",
"9161896", "Bhabhua\,\ Bihar",
"9168576", "Gunupur\,\ Odisha",
"9161353", "Bikram\,\ Bihar",
"918366", "Hubli\,\ Karnataka",
"9174382", "Keshoraipatan\/Patan\,\ Rajasthan",
"9173935", "Jobat\,\ Madhya\ Pradesh",
"9181732", "Sakleshpur\,\ Karnataka",
"914347", "Denkanikota\,\ Tamil\ Nadu",
"918672", "Bandar\/Machilipatnam\,\ Andhra\ Pradesh",
"917519", "Gwalior\,\ Madhya\ Pradesh",
"918533", "Gangavathi\,\ Karnataka",
"9166536", "Dunguripali\,\ Odisha",
"911884", "Garhashanker\,\ Punjab",
"91484", "Ernakulam\,\ Kerala",
"9174867", "Bareli\,\ Madhya\ Pradesh",
"91369", "Mokokchung\,\ Nagaland",
"91475", "Punalur\,\ Kerala",
"9173206", "Pandhana\,\ Madhya\ Pradesh",
"912836", "Anjar\/Gandhidham\,\ Gujarat",
"9163443", "Monghyr\,\ Bihar",
"912998", "Jaisalmer\/Khuiyals\,\ Rajasthan",
"912113", "Bhor\,\ Maharashtra",
"918635", "Guntur\,\ Andhra\ Pradesh",
"9176513", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9174137", "Sailana\,\ Madhya\ Pradesh",
"9165873", "Chakardharpur\,\ Bihar",
"915872", "Kheri\,\ Uttar\ Pradesh",
"9162443", "Khagaria\,\ Bihar",
"911345", "Bijnor\/Chandpur\,\ Uttar\ Pradesh",
"9175218", "Seondha\,\ Madhya\ Pradesh",
"9166706", "Bhawanipatna\,\ Odisha",
"912186", "Pandharpur\,\ Maharashtra",
"9184532", "Medak\,\ Andhra\ Pradesh",
"914933", "Perinthalmanna\,\ Kerala",
"9168675", "Jharigan\,\ Odisha",
"912951", "Bhim\,\ Rajasthan",
"9174845", "Silwani\,\ Madhya\ Pradesh",
"9165874", "Chakardharpur\,\ Bihar",
"912632", "Valsad\,\ Gujarat",
"9162775", "Phulparas\,\ Bihar",
"9162444", "Khagaria\,\ Bihar",
"915262", "Gonda\,\ Uttar\ Pradesh",
"918541", "Achampet\,\ Andhra\ Pradesh",
"91285", "Junagarh\,\ Gujarat",
"9176275", "Manpur\,\ Madhya\ Pradesh",
"911976", "Amb\,\ Himachal\ Pradesh",
"912357", "Malgund\,\ Maharashtra",
"913802", "Roing\/Arda\,\ Arunachal\ Pradesh",
"9165252", "Simdega\,\ Bihar",
"915491", "Rasara\,\ Uttar\ Pradesh",
"9171315", "Sironcha\,\ Maharashtra",
"9163444", "Monghyr\,\ Bihar",
"915676", "Shikohabad\,\ Uttar\ Pradesh",
"917680", "Niwari\,\ Madhya\ Pradesh",
"915362", "Sultanpur\,\ Uttar\ Pradesh",
"9174822", "Raisen\,\ Madhya\ Pradesh",
"9176514", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9165535", "Ramgarh\,\ Bihar",
"9177010", "Pingeshwar\,\ Madhya\ Pradesh",
"9174829", "Raisen\,\ Madhya\ Pradesh",
"9165495", "Bermo\,\ Bihar",
"9167297", "Pattamundai\,\ Odisha",
"917443", "Ladpura\/Kota\,\ Rajasthan",
"917290", "Badwani\,\ Madhya\ Pradesh",
"9172870", "Gogaon\,\ Madhya\ Pradesh",
"9181754", "Holenarasipur\,\ Karnataka",
"9173208", "Pandhana\,\ Madhya\ Pradesh",
"912842", "Talaja\,\ Gujarat",
"914341", "Uthangarai\,\ Tamil\ Nadu",
"911624", "Jagraon\,\ Punjab",
"91542", "Varansi\,\ Uttar\ Pradesh",
"9164242", "Banka\,\ Bihar",
"915924", "Hasanpur\,\ Uttar\ Pradesh",
"918704", "Warangal\,\ Andhra\ Pradesh",
"9172884", "Bhikangaon\,\ Madhya\ Pradesh",
"917390", "Thandla\,\ Madhya\ Pradesh",
"9167355", "Telkoi\,\ Odisha",
"9166253", "Lahunipara\,\ Odisha",
"912828", "Wankaner\,\ Gujarat",
"9175216", "Seondha\,\ Madhya\ Pradesh",
"9174665", "Bonli\,\ Rajasthan",
"918190", "Tallak\,\ Karnataka",
"918240", "Mangalore\,\ Karnataka",
"918845", "Kakinada\,\ Andhra\ Pradesh",
"918493", "Madakasira\,\ Andhra\ Pradesh",
"9171007", "Kuhi\,\ Maharashtra",
"913621", "Boko\,\ Assam",
"912164", "Karad\,\ Maharashtra",
"9168212", "Bhanjanagar\,\ Odisha",
"9167336", "Ghatgaon\,\ Odisha",
"9172883", "Bhikangaon\,\ Madhya\ Pradesh",
"912646", "Ankleshwar\,\ Gujarat",
"9171766", "Warora\,\ Maharashtra",
"9166254", "Lahunipara\,\ Odisha",
"9164225", "Godda\,\ Bihar",
"9171185", "Kalmeshwar\,\ Maharashtra",
"918966", "Srungavarapukota\/Kothavalasa\,\ Andhra\ Pradesh",
"916632", "Sambalpur\,\ Odisha",
"9166837", "Padmapur\,\ Odisha",
"914728", "Nedumangad\,\ Kerala",
"9171696", "Batkakhapa\,\ Madhya\ Pradesh",
"916573", "Jamshedpur\,\ Bihar",
"9164546", "Purnea\,\ Bihar",
"9181753", "Holenarasipur\,\ Karnataka",
"915543", "Naugarh\/Barhani\,\ Uttar\ Pradesh",
"9166217", "Hemgiri\,\ Odisha",
"911487", "Banera\,\ Rajasthan",
"9168162", "Mohana\,\ Odisha",
"9161597", "Masrakh\,\ Bihar",
"9174647", "Karauli\,\ Rajasthan",
"917848", "Keskal\,\ Madhya\ Pradesh",
"914255", "Palladam\,\ Tamil\ Nadu",
"911675", "Malerkotla\,\ Punjab",
"9171817", "Lakhandur\,\ Maharashtra",
"9165892", "Jhinkpani\,\ Bihar",
"9173243", "Mhow\,\ Madhya\ Pradesh",
"9167655", "Palla\ Hara\,\ Odisha",
"9174207", "Jawad\,\ Madhya\ Pradesh",
"918454", "Gajwel\,\ Andhra\ Pradesh",
"917822", "Sidhi\,\ Madhya\ Pradesh",
"9171854", "Pauni\,\ Maharashtra",
"918733", "Asifabad\,\ Andhra\ Pradesh",
"912423", "Koparagon\,\ Maharashtra",
"9172866", "Khetia\,\ Madhya\ Pradesh",
"9171783", "Sinderwahi\,\ Maharashtra",
"9168456", "Phiringia\,\ Odisha",
"912481", "Ner\,\ Maharashtra",
"9164752", "S\.Bakhtiarpur\,\ Bihar",
"9171396", "Kurkheda\,\ Maharashtra",
"9171853", "Pauni\,\ Maharashtra",
"9166475", "Naktideul\,\ Odisha",
"915960", "Shahabad\,\ Uttar\ Pradesh",
"918936", "Araku\,\ Andhra\ Pradesh",
"9174347", "Pirawa\/Raipur\,\ Rajasthan",
"9168435", "Puruna\ Katak\,\ Odisha",
"9171784", "Sinderwahi\,\ Maharashtra",
"9174365", "Hindoli\,\ Rajasthan",
"9173244", "Mhow\,\ Madhya\ Pradesh",
"9167636", "Athmallik\,\ Odisha",
"9171576", "Arvi\,\ Maharashtra",
"915731", "Garhmukteshwar\,\ Uttar\ Pradesh",
"9167233", "Athgarh\,\ Odisha",
"9161534", "Maharajganj\,\ Bihar",
"9161142", "Jahanabad\,\ Bihar",
"9167813", "Basta\,\ Odisha",
"9165967", "Noamundi\,\ Bihar",
"9175295", "Laher\,\ Madhya\ Pradesh",
"913778", "Pakkekesang\,\ Arunachal\ Pradesh",
"915567", "Captanganj\,\ Uttar\ Pradesh",
"9165416", "Chatra\,\ Bihar",
"9172868", "Khetia\,\ Madhya\ Pradesh",
"9176453", "Karanjia\,\ Madhya\ Pradesh",
"9144", "Chennai\,\ Tamil\ Nadu",
"9165945", "Baharagora\,\ Bihar",
"9161875", "Mohania\,\ Bihar",
"9168595", "Motu\,\ Odisha",
"912552", "Nandgaon\,\ Maharashtra",
"918665", "Vijayawada\,\ Andhra\ Pradesh",
"911251", "Jhajjar\,\ Haryana",
"911398", "Kairana\/Shamli\,\ Uttar\ Pradesh",
"9174973", "Khaniadhana\,\ Madhya\ Pradesh",
"917601", "Patharia\,\ Madhya\ Pradesh",
"9176454", "Karanjia\,\ Madhya\ Pradesh",
"9171615", "Parasia\,\ Madhya\ Pradesh",
"9174510", "Atru\,\ Rajasthan",
"915332", "Phoolpur\,\ Uttar\ Pradesh",
"9174974", "Khaniadhana\,\ Madhya\ Pradesh",
"915853", "Shahabad\,\ Uttar\ Pradesh",
"918942", "Srikakulam\,\ Andhra\ Pradesh",
"9161125", "Biharsharif\,\ Bihar",
"9162547", "Bettiah\,\ Bihar",
"918747", "Nuguru\/Cherla\,\ Andhra\ Pradesh",
"9162565", "Ramnagar\,\ Bihar",
"9167234", "Athgarh\,\ Odisha",
"913785", "Bameng\,\ Arunachal\ Pradesh",
"9176417", "Niwas\,\ Madhya\ Pradesh",
"912662", "Padra\,\ Gujarat",
"913254", "Jhalda\,\ West\ Bengal",
"9167814", "Basta\,\ Odisha",
"911957", "Bandipur\,\ Jammu\ And\ Kashmir",
"9161533", "Maharajganj\,\ Bihar",
"9166573", "Kantabhanji\,\ Odisha",
"9167357", "Telkoi\,\ Odisha",
"9174622", "Sawaimadhopur\,\ Rajasthan",
"917660", "Sirmour\,\ Madhya\ Pradesh",
"917688", "Gourihar\,\ Madhya\ Pradesh",
"9168533", "Sunabeda\,\ Odisha",
"9163323", "Nabinagar\,\ Bihar",
"9176538", "Bandhavgarh\,\ Madhya\ Pradesh",
"9167314", "Anandapur\,\ Odisha",
"9176819", "Jatara\,\ Madhya\ Pradesh",
"9164262", "Rajmahal\,\ Bihar",
"915282", "Hamirpur\,\ Uttar\ Pradesh",
"915450", "Kerakat\,\ Uttar\ Pradesh",
"918706", "Warangal\,\ Andhra\ Pradesh",
"918477", "Aland\,\ Karnataka",
"9167295", "Pattamundai\,\ Odisha",
"9165497", "Bermo\,\ Bihar",
"9171412", "Betul\,\ Madhya\ Pradesh",
"9166856", "Sohela\,\ Odisha",
"9165674", "Barwadih\,\ Bihar",
"9174645", "Karauli\,\ Rajasthan",
"9161595", "Masrakh\,\ Bihar",
"915723", "Atrauli\,\ Uttar\ Pradesh",
"9167313", "Anandapur\,\ Odisha",
"9166786", "Nowparatan\,\ Odisha",
"912166", "Phaltan\,\ Maharashtra",
"9166215", "Hemgiri\,\ Odisha",
"911822", "Kapurthala\,\ Punjab",
"9182898", "Athani\,\ Karnataka",
"912644", "Jambusar\,\ Gujarat",
"9171746", "Mul\,\ Maharashtra",
"9165673", "Barwadih\,\ Bihar",
"9175909", "Lateri\,\ Madhya\ Pradesh",
"9164227", "Godda\,\ Bihar",
"9166835", "Padmapur\,\ Odisha",
"9171187", "Kalmeshwar\,\ Maharashtra",
"918964", "Saluru\,\ Andhra\ Pradesh",
"9166574", "Kantabhanji\,\ Odisha",
"912990", "Bhinmal\/Jasawantpura\,\ Rajasthan",
"9176496", "Kakaiya\,\ Madhya\ Pradesh",
"91581", "Bareilly\,\ Uttar\ Pradesh",
"9171005", "Kuhi\,\ Maharashtra",
"9163324", "Nabinagar\,\ Bihar",
"9168142", "Digapahandi\,\ Odisha",
"917675", "Amarpatan\,\ Madhya\ Pradesh",
"9168534", "Sunabeda\,\ Odisha",
"9174667", "Bonli\,\ Rajasthan",
"915317", "Dalmau\,\ Uttar\ Pradesh",
"9174847", "Silwani\,\ Madhya\ Pradesh",
"9168494", "Daringbadi\,\ Odisha",
"9168677", "Jharigan\,\ Odisha",
"911467", "Kekri\,\ Rajasthan",
"912834", "Kutchmandvi\,\ Gujarat",
"9176536", "Bandhavgarh\,\ Madhya\ Pradesh",
"9163463", "Lakhisarai\,\ Bihar",
"9171896", "Amagaon\,\ Maharashtra",
"9171353", "Chamorshi\,\ Maharashtra",
"918151", "Malur\,\ Karnataka",
"9164382", "Madhupur\,\ Bihar",
"91326", "Dhanbad\,\ Bihar",
"918222", "Hunsur\,\ Karnataka",
"9174135", "Sailana\,\ Madhya\ Pradesh",
"918629", "Vinjamuru\,\ Andhra\ Pradesh",
"9165276", "Kolebira\,\ Bihar",
"9168632", "Bisam\ Cuttack\,\ Odisha",
"9162463", "Jainagar\,\ Bihar",
"91204", "Pune\,\ Maharashtra",
"9175902", "Lateri\,\ Madhya\ Pradesh",
"911638", "Fazilka\,\ Punjab",
"913663", "Goalpara\,\ Assam",
"9174523", "Chhabra\,\ Rajasthan",
"913867", "Zuenheboto\,\ Nagaland",
"912184", "Barsi\,\ Maharashtra",
"918322", "Goa",
"912597", "Parola\,\ Maharashtra",
"917752", "Bilaspur\,\ Madhya\ Pradesh",
"918248", "Mangalore\,\ Karnataka",
"918198", "Molkalmuru\,\ Karnataka",
"9174865", "Bareli\,\ Madhya\ Pradesh",
"918913", "Visakhapatnam\,\ Andhra\ Pradesh",
"9182896", "Athani\,\ Karnataka",
"9165537", "Ramgarh\,\ Bihar",
"912820", "Paddhari\,\ Gujarat",
"917251", "Risod\,\ Maharashtra",
"915692", "Farrukhabad\/Fategarh\,\ Uttar\ Pradesh",
"9162464", "Jainagar\,\ Bihar",
"917122", "Nagpur\,\ Maharashtra",
"914734", "Adoor\,\ Kerala",
"9162732", "Jhajharpur\,\ Bihar",
"9174524", "Chhabra\,\ Rajasthan",
"918716", "Jangaon\,\ Andhra\ Pradesh",
"9171317", "Sironcha\,\ Maharashtra",
"9165392", "Bolwa\,\ Bihar",
"9176812", "Jatara\,\ Madhya\ Pradesh",
"9176498", "Kakaiya\,\ Madhya\ Pradesh",
"912325", "Kagal\/Murgud\,\ Maharashtra",
"918721", "Husnabad\,\ Andhra\ Pradesh",
"9168493", "Daringbadi\,\ Odisha",
"9165572", "Bagodar\,\ Bihar",
"9163464", "Lakhisarai\,\ Bihar",
"9176277", "Manpur\,\ Madhya\ Pradesh",
"912431", "Paithan\,\ Maharashtra",
"9162777", "Phulparas\,\ Bihar",
"9171354", "Chamorshi\,\ Maharashtra",
"918783", "Karimnagar\,\ Andhra\ Pradesh",
"9174629", "Sawaimadhopur\,\ Rajasthan",
"911992", "Udhampur\,\ Jammu\ And\ Kashmir",
"911668", "Dabwali\,\ Haryana",
"912791", "Babra\,\ Gujarat",
"918395", "Sandur\,\ Karnataka",
"9167216", "Narsinghpur\,\ Odisha",
"9168597", "Motu\,\ Odisha",
"9161877", "Mohania\,\ Bihar",
"9165947", "Baharagora\,\ Bihar",
"913837", "Kolasib\,\ Mizoram",
"912803", "Khavda\,\ Gujarat",
"912758", "Halvad\,\ Gujarat",
"9165965", "Noamundi\,\ Bihar",
"9175297", "Laher\,\ Madhya\ Pradesh",
"911437", "Malpura\,\ Rajasthan",
"9171704", "Chumur\,\ Maharashtra",
"9162522", "Motihari\,\ Bihar",
"9165433", "Barhi\,\ Bihar",
"9161832", "Buxar\,\ Bihar",
"9171653", "Saunsar\,\ Madhya\ Pradesh",
"912461", "Mukhed\,\ Maharashtra",
"917773", "Odgi\,\ Madhya\ Pradesh",
"916617", "Rourkela\,\ Odisha",
"9163226", "Wazirganj\,\ Bihar",
"9171703", "Chumur\,\ Maharashtra",
"9174329", "Jhalawar\,\ Rajasthan",
"914891", "Amini\,\ Lakshadweep",
"9165434", "Barhi\,\ Bihar",
"9176415", "Niwas\,\ Madhya\ Pradesh",
"9171654", "Saunsar\,\ Madhya\ Pradesh",
"9162567", "Ramnagar\,\ Bihar",
"9162545", "Bettiah\,\ Bihar",
"9161127", "Biharsharif\,\ Bihar",
"9161516", "Sidhawalia\,\ Bihar",
"9163486", "Mallehpur\,\ Bihar",
"9162226", "Sheohar\,\ Bihar",
"9165692", "Garu\,\ Bihar",
"911591", "Merta\/Gotan\,\ Rajasthan",
"912699", "Thasra\,\ Gujarat",
"912142", "Pali\,\ Maharashtra",
"9171617", "Parasia\,\ Madhya\ Pradesh",
"917840", "Koyelibeda\,\ Madhya\ Pradesh",
"9176520", "Shahdol\,\ Madhya\ Pradesh",
"9174900", "Pohari\,\ Madhya\ Pradesh",
"9171552", "Seloo\,\ Maharashtra",
"9167614", "Chhendipada\,\ Odisha",
"914327", "Thuraiyur\,\ Tamil\ Nadu",
"918456", "Narayankhed\,\ Andhra\ Pradesh",
"9174205", "Jawad\,\ Madhya\ Pradesh",
"9167657", "Palla\ Hara\,\ Odisha",
"9174322", "Jhalawar\,\ Rajasthan",
"9165594", "Simaria\,\ Bihar",
"9166763", "M\.Rampur\,\ Odisha",
"9171815", "Lakhandur\,\ Maharashtra",
"918678", "Nandigama\,\ Andhra\ Pradesh",
"916803", "Berhampur\,\ Odisha",
"91215", "Navi\ Mumbai\/Turbhe\,\ Maharashtra",
"9164776", "Triveniganj\,\ Bihar",
"9166764", "M\.Rampur\,\ Odisha",
"915172", "Mehraun\,\ Uttar\ Pradesh",
"9168472", "G\.Udayagiri\,\ Odisha",
"9165593", "Simaria\,\ Bihar",
"918934", "Chodavaram\,\ Andhra\ Pradesh",
"918685", "Bhongir\,\ Andhra\ Pradesh",
"9174367", "Hindoli\,\ Rajasthan",
"9166432", "Barkot\,\ Odisha",
"913843", "Karimganj\,\ Assam",
"911895", "Bharmour\,\ Himachal\ Pradesh",
"912136", "Urlikanchan\,\ Maharashtra",
"9167613", "Chhendipada\,\ Odisha",
"915194", "Karvi\/Manikpur\,\ Uttar\ Pradesh",
"9174345", "Pirawa\/Raipur\,\ Rajasthan",
"915244", "Haidergarh\,\ Uttar\ Pradesh",
"917624", "Sihora\,\ Madhya\ Pradesh",
"9168437", "Puruna\ Katak\,\ Odisha",
"9166477", "Naktideul\,\ Odisha",
"9171042", "Hingua\,\ Maharashtra",
"9168105", "Khalikote\,\ Odisha",
"9174250", "Garoth\,\ Madhya\ Pradesh",
"915452", "Jaunpur\,\ Uttar\ Pradesh",
"9163244", "Nawada\,\ Bihar",
"9161576", "Mairwa\,\ Bihar",
"918516", "Dronachalam\,\ Andhra\ Pradesh",
"9176358", "Lanji\,\ Madhya\ Pradesh",
"913808", "Changlang\,\ Arunachal\ Pradesh",
"917369", "Tarana\,\ Madhya\ Pradesh",
"9171677", "Amarwada\,\ Madhya\ Pradesh",
"9167537", "Nayagarh\,\ Odisha",
"9164365", "Sahibganj\,\ Bihar",
"9171494", "Tamia\,\ Madhya\ Pradesh",
"915280", "Rath\,\ Uttar\ Pradesh",
"9164347", "Dumka\,\ Bihar",
"9162244", "Hajipur\,\ Bihar",
"9174955", "Badarwas\,\ Madhya\ Pradesh",
"918583", "Sodam\,\ Andhra\ Pradesh",
"913753", "Dhemaji\,\ Assam",
"912467", "Bhokar\,\ Maharashtra",
"9177046", "Deobhog\,\ Madhya\ Pradesh",
"9165452", "Mandu\,\ Bihar",
"9161853", "Bikramganj\,\ Bihar",
"9174602", "Sahabad\,\ Rajasthan",
"915368", "Amethi\,\ Uttar\ Pradesh",
"9167572", "Daspalla\,\ Odisha",
"9176475", "Ghughari\,\ Madhya\ Pradesh",
"917269", "Sindkhedaraja\,\ Maharashtra",
"914897", "Kadamath\,\ Lakshadweep",
"917662", "Rewa\,\ Madhya\ Pradesh",
"9174936", "Karera\,\ Madhya\ Pradesh",
"9162243", "Hajipur\,\ Bihar",
"911431", "Lalsot\,\ Rajasthan",
"9171025", "Parseoni\,\ Maharashtra",
"9161854", "Bikramganj\,\ Bihar",
"912992", "Jaisalmer\,\ Rajasthan",
"9163243", "Nawada\,\ Bihar",
"912797", "Dhari\,\ Gujarat",
"9175929", "Vidisha\,\ Madhya\ Pradesh",
"911509", "Suratgarh\,\ Rajasthan",
"9164207", "Amarpur\,\ Bihar",
"917866", "Konta\,\ Madhya\ Pradesh",
"913831", "Champa\,\ Mizoram",
"9171493", "Tamia\,\ Madhya\ Pradesh",
"9161817", "Piro\,\ Bihar",
"9167276", "Kendrapara\,\ Odisha",
"912974", "Abu\ Road\,\ Rajasthan",
"9171533", "Hinganghat\,\ Maharashtra",
"9167673", "Barbil\,\ Odisha",
"9174503", "Sangod\,\ Rajasthan",
"917750", "Marwahi\,\ Madhya\ Pradesh",
"918320", "Goa",
"9165313", "Mandar\,\ Bihar",
"9166417", "Deodgarh\,\ Odisha",
"915523", "Maharajganj\,\ Uttar\ Pradesh",
"9176356", "Lanji\,\ Madhya\ Pradesh",
"9175922", "Vidisha\,\ Madhya\ Pradesh",
"9168412", "Boudh\,\ Odisha",
"9177048", "Deobhog\,\ Madhya\ Pradesh",
"9164285", "Nala\,\ Bihar",
"9164716", "Birpur\,\ Bihar",
"9171125", "Katol\,\ Maharashtra",
"9166454", "Jharsuguda\,\ Odisha",
"912989", "Chohtan\,\ Rajasthan",
"912626", "Vyara\,\ Gujarat",
"9168187", "Buguda\,\ Odisha",
"915944", "Kichha\/Rudrapur\,\ Uttar\ Pradesh",
"918334", "Mudalgi\,\ Karnataka",
"914283", "Sankagiri\,\ Tamil\ Nadu",
"911990", "Ramnagar\,\ Jammu\ And\ Kashmir",
"9174609", "Sahabad\,\ Rajasthan",
"9174938", "Karera\,\ Madhya\ Pradesh",
"9175945", "Ganjbasoda\,\ Madhya\ Pradesh",
"9166453", "Jharsuguda\,\ Odisha",
"912848", "Palitana\,\ Gujarat",
"9165357", "Chainpur\,\ Bihar",
"9171875", "Goregaon\,\ Maharashtra",
"9174504", "Sangod\,\ Rajasthan",
"918234", "Nagamangala\,\ Karnataka",
"9171534", "Hinganghat\,\ Maharashtra",
"9167674", "Barbil\,\ Odisha",
"9171142", "Ramtek\,\ Maharashtra",
"9167497", "Bhubaneshwar\,\ Odisha",
"9175967", "Gyraspur\,\ Madhya\ Pradesh",
"9165295", "Itki\,\ Bihar",
"918506", "Narayanpet\,\ Andhra\ Pradesh",
"912822", "Morvi\,\ Gujarat",
"915690", "Kaimganj\,\ Uttar\ Pradesh",
"9176335", "Waraseoni\,\ Madhya\ Pradesh",
"9165314", "Mandar\,\ Bihar",
"9166514", "Birmaharajpur\,\ Odisha",
"9174548", "Chhipaborad\,\ Rajasthan",
"915311", "Salon\,\ Uttar\ Pradesh",
"913655", "Khliehriat\,\ Meghalaya",
"911389", "Joshimath\,\ Uttarakhand",
"9162502", "Dhaka\,\ Bihar",
"9168552", "Laxmipur\,\ Odisha",
"9171724", "Chandrapur\,\ Maharashtra",
"914173", "Arni\,\ Tamil\ Nadu",
"9166557", "Titlagarh\,\ Odisha",
"9177003", "Nagri\,\ Madhya\ Pradesh",
"9174249", "Malhargarh\,\ Madhya\ Pradesh",
"911682", "Zira\,\ Punjab",
"9165613", "Garhwa\,\ Bihar",
"912895", "Lalpur\,\ Gujarat",
"912443", "Manjalegaon\,\ Maharashtra",
"912140", "Mangaon\,\ Maharashtra",
"913565", "Nagarakata\,\ West\ Bengal",
"9176500", "Beohari\,\ Madhya\ Pradesh",
"9177004", "Nagri\,\ Madhya\ Pradesh",
"9171472", "Multai\,\ Madhya\ Pradesh",
"9165614", "Garhwa\,\ Bihar",
"9173937", "Jobat\,\ Madhya\ Pradesh",
"918471", "Mashal\,\ Karnataka",
"9174309", "Khanpur\,\ Rajasthan",
"918364", "Hubli\,\ Karnataka",
"91172", "Chandigarh\,\ Punjab",
"9166513", "Birmaharajpur\,\ Odisha",
"9171437", "Bhainsdehi\,\ Madhya\ Pradesh",
"918203", "Udupi\,\ Karnataka",
"9165657", "Latehar\,\ Bihar",
"911886", "Tanda\ Urmar\,\ Punjab",
"9171723", "Chandrapur\,\ Maharashtra",
"912437", "Khultabad\,\ Maharashtra",
"9164795", "Udakishanganj\,\ Bihar",
"9165512", "Barkagaon\,\ Bihar",
"918727", "Huzurabad\,\ Andhra\ Pradesh",
"915165", "Konch\,\ Uttar\ Pradesh",
"917239", "Wani\,\ Maharashtra",
"918213", "Mysore\,\ Karnataka",
"9174225", "Mandsaur\,\ Madhya\ Pradesh",
"918386", "Kumta\,\ Karnataka",
"9171332", "Aheri\,\ Maharashtra",
"9174302", "Khanpur\,\ Rajasthan",
"9162717", "Benipatti\,\ Bihar",
"9174546", "Chhipaborad\,\ Rajasthan",
"917573", "Timarani\,\ Madhya\ Pradesh",
"911607", "Kharar\,\ Punjab",
"914564", "Paramakudi\,\ Tamil\ Nadu",
"9168653", "Kashipur\,\ Odisha",
"912668", "Waghodia\,\ Gujarat",
"917257", "Balapur\,\ Maharashtra",
"9176254", "Umariapan\,\ Madhya\ Pradesh",
"9167692", "Kamakhyanagar\,\ Odisha",
"9164665", "Kishanganj\,\ Bihar",
"9174920", "Shivpuri\,\ Madhya\ Pradesh",
"918922", "Vizayanagaram\,\ Andhra\ Pradesh",
"9162754", "Rosera\,\ Bihar",
"918313", "Belgaum\,\ Karnataka",
"9171377", "Desaiganj\,\ Maharashtra",
"911803", "Panipat\,\ Haryana",
"9165855", "Ghatsila\,\ Bihar",
"918139", "Turuvekere\,\ Karnataka",
"9168654", "Kashipur\,\ Odisha",
"917410", "Alot\,\ Madhya\ Pradesh",
"9167947", "Rairangpur\,\ Odisha",
"9176253", "Umariapan\,\ Madhya\ Pradesh",
"913772", "Sibsagar\,\ Assam",
"911374", "Bhatwari\/Uttarkashi\,\ Uttarakhand",
"9162753", "Rosera\,\ Bihar",
"912591", "Manmad\,\ Maharashtra",
"913861", "Tuengsang\,\ Nagaland",
"9174242", "Malhargarh\,\ Madhya\ Pradesh",
"9165836", "Kharsawa\,\ Bihar",
"917836", "Baikunthpur\,\ Madhya\ Pradesh",
"911461", "Bansur\,\ Rajasthan",
"912925", "Phalodi\,\ Rajasthan",
"9168617", "Malkangiri\,\ Odisha",
"911392", "Budhana\,\ Uttar\ Pradesh",
"913794", "Tawang\,\ Arunachal\ Pradesh",
"911274", "Rewari\,\ Haryana",
"915170", "Chirgaon\/Moth\,\ Uttar\ Pradesh",
"918157", "Srinivasapur\,\ Karnataka",
"9167965", "Karanjia\,\ Odisha",
"912558", "Peint\,\ Maharashtra",
"915831", "Dataganj\,\ Uttar\ Pradesh",
"917534", "Bhind\,\ Madhya\ Pradesh",
"9171742", "Mul\,\ Maharashtra",
"9174330", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9165615", "Garhwa\,\ Bihar",
"9166782", "Nowparatan\,\ Odisha",
"9177005", "Nagri\,\ Madhya\ Pradesh",
"914369", "Thiruthuraipoondi\,\ Tamil\ Nadu",
"9176818", "Jatara\,\ Madhya\ Pradesh",
"912779", "Bayad\,\ Gujarat",
"913878", "Chakpikarong\,\ Manipur",
"912766", "Patan\,\ Gujarat",
"9176539", "Bandhavgarh\,\ Madhya\ Pradesh",
"9168146", "Digapahandi\,\ Odisha",
"911478", "Pratapgarh\,\ Rajasthan",
"9176492", "Kakaiya\,\ Madhya\ Pradesh",
"917693", "Ghansour\,\ Madhya\ Pradesh",
"915181", "Bindki\,\ Uttar\ Pradesh",
"9164527", "Katihar\,\ Bihar",
"9171725", "Chandrapur\,\ Maharashtra",
"912963", "Gerhi\/Partapur\,\ Rajasthan",
"911852", "Taran\,\ Punjab",
"9174626", "Sawaimadhopur\,\ Rajasthan",
"911485", "Jahazpur\,\ Rajasthan",
"9166515", "Birmaharajpur\,\ Odisha",
"911566", "Sri\ Dungargarh\/Sudsar\,\ Rajasthan",
"9171967", "Arjuni\ Morgaon\,\ Maharashtra",
"9161357", "Bikram\,\ Bihar",
"9175908", "Lateri\,\ Madhya\ Pradesh",
"9166852", "Sohela\,\ Odisha",
"9171416", "Betul\,\ Madhya\ Pradesh",
"918847", "Kakinada\,\ Andhra\ Pradesh",
"9182899", "Athani\,\ Karnataka",
"914552", "Usilampatti\,\ Tamil\ Nadu",
"911233", "Mawana\,\ Uttar\ Pradesh",
"9164266", "Rajmahal\,\ Bihar",
"912904", "Deogarh\,\ Rajasthan",
"913452", "Guskara\,\ West\ Bengal",
"913018", "Jaisalmer\/Sadhna\,\ Rajasthan",
"918643", "Bapatla\,\ Andhra\ Pradesh",
"9165853", "Ghatsila\,\ Bihar",
"918659", "Mylavaram\,\ Andhra\ Pradesh",
"917748", "Dallirajhara\,\ Madhya\ Pradesh",
"914884", "Vadakkanchery\,\ Kerala",
"9176816", "Jatara\,\ Madhya\ Pradesh",
"91184", "Karnal\,\ Haryana",
"9165396", "Bolwa\,\ Bihar",
"9162736", "Jhajharpur\,\ Bihar",
"9164663", "Kishanganj\,\ Bihar",
"9182892", "Athani\,\ Karnataka",
"918468", "Kamareddy\,\ Andhra\ Pradesh",
"918183", "Sagar\,\ Karnataka",
"91241", "Ahmednagar\,\ Maharashtra",
"9168655", "Kashipur\,\ Odisha",
"918833", "Rajahmundri\,\ Andhra\ Pradesh",
"917819", "Pandishankar\,\ Madhya\ Pradesh",
"911584", "Nagaur\/Mundwa\ Marwar\,\ Rajasthan",
"917722", "Dhamtari\,\ Madhya\ Pradesh",
"918352", "Bijapur\,\ Karnataka",
"9167964", "Karanjia\,\ Odisha",
"9174223", "Mandsaur\,\ Madhya\ Pradesh",
"9164793", "Udakishanganj\,\ Bihar",
"918637", "Guntur\,\ Andhra\ Pradesh",
"9165576", "Bagodar\,\ Bihar",
"9164386", "Madhupur\,\ Bihar",
"9167963", "Karanjia\,\ Odisha",
"9174628", "Sawaimadhopur\,\ Rajasthan",
"9171892", "Amagaon\,\ Maharashtra",
"917283", "Maheshwar\,\ Madhya\ Pradesh",
"9174224", "Mandsaur\,\ Madhya\ Pradesh",
"9165817", "Bhandaria\,\ Bihar",
"9164794", "Udakishanganj\,\ Bihar",
"9176532", "Bandhavgarh\,\ Madhya\ Pradesh",
"917221", "Nandgaon\,\ Maharashtra",
"915641", "Deeg\,\ Rajasthan",
"918569", "Badvel\,\ Andhra\ Pradesh",
"9165237", "Ghaghra\,\ Bihar",
"9176499", "Kakaiya\,\ Madhya\ Pradesh",
"918576", "Satyavedu\,\ Andhra\ Pradesh",
"9165854", "Ghatsila\,\ Bihar",
"9162755", "Rosera\,\ Bihar",
"913523", "Raiganj\,\ West\ Bengal",
"9164664", "Kishanganj\,\ Bihar",
"9176255", "Umariapan\,\ Madhya\ Pradesh",
"9176577", "Jaitpur\,\ Madhya\ Pradesh",
"9175906", "Lateri\,\ Madhya\ Pradesh",
"9165272", "Kolebira\,\ Bihar",
"9168636", "Bisam\ Cuttack\,\ Odisha",
"918751", "Boath\/Echoda\,\ Andhra\ Pradesh",
"913581", "Dinhata\,\ West\ Bengal",
"912355", "Chiplun\,\ Maharashtra",
"9176473", "Ghughari\,\ Madhya\ Pradesh",
"911429", "Bassi\,\ Rajasthan",
"9161855", "Bikramganj\,\ Bihar",
"918863", "Chavitidibbalu\,\ Andhra\ Pradesh",
"915413", "Chakia\,\ Uttar\ Pradesh",
"9163222", "Wazirganj\,\ Bihar",
"9171024", "Parseoni\,\ Maharashtra",
"918667", "Vijayawada\,\ Andhra\ Pradesh",
"9174953", "Badarwas\,\ Madhya\ Pradesh",
"912742", "Palanpur\,\ Gujarat",
"9164363", "Sahibganj\,\ Bihar",
"9165696", "Garu\,\ Bihar",
"9163482", "Mallehpur\,\ Bihar",
"9162222", "Sheohar\,\ Bihar",
"913712", "Tezpur\,\ Assam",
"9168103", "Khalikote\,\ Odisha",
"9161512", "Sidhawalia\,\ Bihar",
"9162267", "Sitamarhi\,\ Bihar",
"9176480", "Mawai\,\ Madhya\ Pradesh",
"9164364", "Sahibganj\,\ Bihar",
"9171495", "Tamia\,\ Madhya\ Pradesh",
"912341", "Kavathemankal\,\ Maharashtra",
"918745", "Yellandu\,\ Andhra\ Pradesh",
"913211", "Arambag\,\ West\ Bengal",
"911528", "Lunkaransar\,\ Rajasthan",
"9173290", "Khakner\,\ Madhya\ Pradesh",
"9167212", "Narsinghpur\,\ Odisha",
"913787", "Seppa\,\ Arunachal\ Pradesh",
"918557", "Penukonda\,\ Andhra\ Pradesh",
"911955", "Kupwara\,\ Jammu\ And\ Kashmir",
"917586", "Deori\,\ Madhya\ Pradesh",
"9174917", "Narwar\,\ Madhya\ Pradesh",
"9163245", "Nawada\,\ Bihar",
"918373", "Ranebennur\,\ Karnataka",
"9168104", "Khalikote\,\ Odisha",
"912191", "Poladpur\,\ Maharashtra",
"9163267", "Sherghati\,\ Bihar",
"914828", "Kanjirapally\,\ Kerala",
"9176474", "Ghughari\,\ Madhya\ Pradesh",
"9174328", "Jhalawar\,\ Rajasthan",
"9161836", "Buxar\,\ Bihar",
"9171023", "Parseoni\,\ Maharashtra",
"9162526", "Motihari\,\ Bihar",
"917513", "Gwalior\,\ Madhya\ Pradesh",
"918539", "Koppal\,\ Karnataka",
"9162245", "Hajipur\,\ Bihar",
"9174587", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9174954", "Badarwas\,\ Madhya\ Pradesh",
"9174140", "Jaora\,\ Madhya\ Pradesh",
"918426", "Telgi\,\ Karnataka",
"9171874", "Goregaon\,\ Maharashtra",
"9175944", "Ganjbasoda\,\ Madhya\ Pradesh",
"913473", "Ranaghat\,\ West\ Bengal",
"91485", "Muvattupuzha\,\ Kerala",
"9166436", "Barkot\,\ Odisha",
"914573", "Rameshwaram\,\ Tamil\ Nadu",
"9171123", "Katol\,\ Maharashtra",
"9164283", "Nala\,\ Bihar",
"9168476", "G\.Udayagiri\,\ Odisha",
"914632", "Kovilpatti\,\ Tamil\ Nadu",
"9164772", "Triveniganj\,\ Bihar",
"914257", "Kangeyam\,\ Tamil\ Nadu",
"91212", "Chinchwad\,\ Maharashtra",
"9176334", "Waraseoni\,\ Madhya\ Pradesh",
"9174630", "Gangapur\,\ Rajasthan",
"9165315", "Mandar\,\ Bihar",
"917564", "Budhni\,\ Madhya\ Pradesh",
"915861", "Misrikh\/Aurangabad\,\ Uttar\ Pradesh",
"918411", "Tanduru\,\ Andhra\ Pradesh",
"9165294", "Itki\,\ Bihar",
"9164737", "Supaul\,\ Bihar",
"916742", "Bhubaneshwar\,\ Odisha",
"9174505", "Sangod\,\ Rajasthan",
"9171535", "Hinganghat\,\ Maharashtra",
"9167675", "Barbil\,\ Odisha",
"914339", "Keeranur\,\ Tamil\ Nadu",
"911263", "Gohana\,\ Haryana",
"9176333", "Waraseoni\,\ Madhya\ Pradesh",
"914998", "Uppala\,\ Kerala",
"915464", "Maunathbhanjan\,\ Uttar\ Pradesh",
"9165293", "Itki\,\ Bihar",
"9189460", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"918814", "Eluru\ Narsapur\/Palakole\,\ Andhra\ Pradesh",
"915271", "Akbarpur\,\ Uttar\ Pradesh",
"9171556", "Seloo\,\ Maharashtra",
"9171873", "Goregaon\,\ Maharashtra",
"912933", "Bali\/Sumerpur\,\ Rajasthan",
"911363", "Karnaprayag\,\ Uttarakhand",
"9166455", "Jharsuguda\,\ Odisha",
"9175943", "Ganjbasoda\,\ Madhya\ Pradesh",
"9164284", "Nala\,\ Bihar",
"9171124", "Katol\,\ Maharashtra",
"911536", "Kolayat\/Daitra\,\ Rajasthan",
"9174326", "Jhalawar\,\ Rajasthan",
"9171655", "Saunsar\,\ Madhya\ Pradesh",
"912584", "Raver\,\ Maharashtra",
"915614", "Jarar\,\ Uttar\ Pradesh",
"91381", "Agartala\,\ Tripura",
"9167237", "Athgarh\,\ Odisha",
"918598", "Kandukuru\,\ Andhra\ Pradesh",
"9165435", "Barhi\,\ Bihar",
"9176414", "Niwas\,\ Madhya\ Pradesh",
"9167817", "Basta\,\ Odisha",
"9174932", "Karera\,\ Madhya\ Pradesh",
"9174550", "Digod\/Sultanpur\,\ Rajasthan",
"917449", "Ladpura\/Kota\,\ Rajasthan",
"9165963", "Noamundi\,\ Bihar",
"918551", "Garladinne\,\ Andhra\ Pradesh",
"9176457", "Karanjia\,\ Madhya\ Pradesh",
"9167272", "Kendrapara\,\ Odisha",
"913217", "Basirhat\,\ West\ Bengal",
"912347", "Vita\,\ Maharashtra",
"9176359", "Lanji\,\ Madhya\ Pradesh",
"91141", "Jaipur\,\ Rajasthan",
"9174977", "Khaniadhana\,\ Madhya\ Pradesh",
"918776", "Tirupathi\,\ Andhra\ Pradesh",
"918407", "Darsi\,\ Andhra\ Pradesh",
"9162544", "Bettiah\,\ Bihar",
"915735", "Sikandrabad\,\ Uttar\ Pradesh",
"918499", "Podili\,\ Andhra\ Pradesh",
"9161572", "Mairwa\,\ Bihar",
"9175928", "Vidisha\,\ Madhya\ Pradesh",
"9162543", "Bettiah\,\ Bihar",
"917548", "Mungaoli\,\ Madhya\ Pradesh",
"9171046", "Hingua\,\ Maharashtra",
"9167576", "Daspalla\,\ Odisha",
"9174606", "Sahabad\,\ Rajasthan",
"9165456", "Mandu\,\ Bihar",
"9177042", "Deobhog\,\ Madhya\ Pradesh",
"9176413", "Niwas\,\ Madhya\ Pradesh",
"9161537", "Maharajganj\,\ Bihar",
"9171705", "Chumur\,\ Maharashtra",
"917605", "Patera\,\ Madhya\ Pradesh",
"9165964", "Noamundi\,\ Bihar",
"91474", "Kollam\,\ Kerala",
"911255", "Siwani\,\ Haryana",
"912478", "Bhoom\,\ Maharashtra",
"9171813", "Lakhandur\,\ Maharashtra",
"9173247", "Mhow\,\ Madhya\ Pradesh",
"918350", "Mudhol\,\ Karnataka",
"9166765", "M\.Rampur\,\ Odisha",
"917720", "Arang\,\ Madhya\ Pradesh",
"9174203", "Jawad\,\ Madhya\ Pradesh",
"912119", "Kedgaon\,\ Maharashtra",
"913674", "Hojai\,\ Assam",
"9177049", "Deobhog\,\ Madhya\ Pradesh",
"918482", "Bidar\,\ Karnataka",
"918855", "Mandapeta\/Ravulapalem\,\ Andhra\ Pradesh",
"9174344", "Pirawa\/Raipur\,\ Rajasthan",
"9171787", "Sinderwahi\,\ Maharashtra",
"9171146", "Ramtek\,\ Maharashtra",
"9171857", "Pauni\,\ Maharashtra",
"9175926", "Vidisha\,\ Madhya\ Pradesh",
"9176352", "Lanji\,\ Madhya\ Pradesh",
"911496", "Sarwar\,\ Rajasthan",
"9167615", "Chhendipada\,\ Odisha",
"911904", "Nirmand\,\ Himachal\ Pradesh",
"9174343", "Pirawa\/Raipur\,\ Rajasthan",
"918417", "Chevella\,\ Andhra\ Pradesh",
"917734", "Shahnagar\,\ Madhya\ Pradesh",
"914298", "Metturdam\,\ Tamil\ Nadu",
"9171814", "Lakhandur\,\ Maharashtra",
"9174939", "Karera\,\ Madhya\ Pradesh",
"9174608", "Sahabad\,\ Rajasthan",
"9165595", "Simaria\,\ Bihar",
"912485", "Bhokardan\,\ Maharashtra",
"9164712", "Birpur\,\ Bihar",
"9168416", "Boudh\,\ Odisha",
"912566", "Sindkheda\,\ Maharashtra",
"9174204", "Jawad\,\ Madhya\ Pradesh",
"9166834", "Padmapur\,\ Odisha",
"9171476", "Multai\,\ Madhya\ Pradesh",
"912677", "Limkheda\,\ Gujarat",
"9167293", "Pattamundai\,\ Odisha",
"9174248", "Malhargarh\,\ Madhya\ Pradesh",
"912873", "Visavadar\,\ Gujarat",
"9166214", "Hemgiri\,\ Odisha",
"917472", "Bundi\,\ Rajasthan",
"9174644", "Karauli\,\ Rajasthan",
"9176340", "Lamta\,\ Madhya\ Pradesh",
"916214", "Muzaffarpur\,\ Bihar",
"9161594", "Masrakh\,\ Bihar",
"9168535", "Sunabeda\,\ Odisha",
"915112", "Bilhaur\,\ Uttar\ Pradesh",
"9171004", "Kuhi\,\ Maharashtra",
"9163325", "Nabinagar\,\ Bihar",
"912740", "Vav\,\ Gujarat",
"9174549", "Chhipaborad\,\ Rajasthan",
"91799", "Ahmedabad\ Local\,\ Gujarat",
"9175930", "Kurwai\,\ Madhya\ Pradesh",
"916314", "Gaya\,\ Bihar",
"9166575", "Kantabhanji\,\ Odisha",
"9166257", "Lahunipara\,\ Odisha",
"912363", "Sawantwadi\,\ Maharashtra",
"911933", "Pulwama\,\ Jammu\ And\ Kashmir",
"9168556", "Laxmipur\,\ Odisha",
"9162506", "Dhaka\,\ Bihar",
"9171003", "Kuhi\,\ Maharashtra",
"9172887", "Bhikangaon\,\ Madhya\ Pradesh",
"918618", "Nellore\,\ Andhra\ Pradesh",
"9174308", "Khanpur\,\ Rajasthan",
"9165675", "Barwadih\,\ Bihar",
"9166833", "Padmapur\,\ Odisha",
"9167294", "Pattamundai\,\ Odisha",
"918444", "Hunsagi\,\ Karnataka",
"9166213", "Hemgiri\,\ Odisha",
"917858", "Kuakunda\,\ Madhya\ Pradesh",
"91175", "Patiala\,\ Punjab",
"917764", "Kunkuri\,\ Madhya\ Pradesh",
"9181757", "Holenarasipur\,\ Karnataka",
"9161593", "Masrakh\,\ Bihar",
"9174643", "Karauli\,\ Rajasthan",
"9167315", "Anandapur\,\ Odisha",
"9174246", "Malhargarh\,\ Madhya\ Pradesh",
"9165832", "Kharsawa\,\ Bihar",
"9174863", "Bareli\,\ Madhya\ Pradesh",
"917786", "Kondagaon\,\ Madhya\ Pradesh",
"9163447", "Monghyr\,\ Bihar",
"9174525", "Chhabra\,\ Rajasthan",
"917327", "Harsud\,\ Madhya\ Pradesh",
"9162465", "Jainagar\,\ Bihar",
"9176517", "Jaisinghnagar\,\ Madhya\ Pradesh",
"918545", "Amangallu\,\ Andhra\ Pradesh",
"913244", "Bishnupur\,\ West\ Bengal",
"9165877", "Chakardharpur\,\ Bihar",
"912429", "Shevgaon\,\ Maharashtra",
"9174133", "Sailana\,\ Madhya\ Pradesh",
"918739", "Jannaram\/Luxittipet\,\ Andhra\ Pradesh",
"914630", "Srivaikundam\,\ Tamil\ Nadu",
"9162447", "Khagaria\,\ Bihar",
"918952", "Chepurupalli\/Garividi\,\ Andhra\ Pradesh",
"915843", "Jalalabad\,\ Uttar\ Pradesh",
"915495", "Saidpur\,\ Uttar\ Pradesh",
"9171355", "Chamorshi\,\ Maharashtra",
"9177050", "Kurud\,\ Madhya\ Pradesh",
"9163465", "Lakhisarai\,\ Bihar",
"917227", "Chandurbazar\,\ Maharashtra",
"915647", "Bari\,\ Rajasthan",
"9174134", "Sailana\,\ Madhya\ Pradesh",
"917916", "Ahmedabad\ Local\,\ Gujarat",
"9174542", "Chhipaborad\,\ Rajasthan",
"9174306", "Khanpur\,\ Rajasthan",
"9171336", "Aheri\,\ Maharashtra",
"9165516", "Barkagaon\,\ Bihar",
"9168495", "Daringbadi\,\ Odisha",
"9174864", "Bareli\,\ Madhya\ Pradesh",
"912528", "Dahanu\,\ Maharashtra",
"911341", "Najibabad\,\ Uttar\ Pradesh",
"913512", "Malda\,\ West\ Bengal",
"912955", "Malvi\/Fatehnagar\,\ Rajasthan",
"9167696", "Kamakhyanagar\,\ Odisha",
"911858", "Ajnala\,\ Punjab",
"916513", "Ranchi\,\ Bihar",
"918681", "Chandoor\,\ Andhra\ Pradesh",
"911764", "Samana\,\ Punjab",
"9173940", "Alirajpur\,\ Madhya\ Pradesh",
"9171785", "Sinderwahi\,\ Maharashtra",
"9168434", "Puruna\ Katak\,\ Odisha",
"918623", "Sullurpet\,\ Andhra\ Pradesh",
"9166474", "Naktideul\,\ Odisha",
"913676", "Howraghat\,\ Assam",
"9174686", "Khandar\,\ Rajasthan",
"9177069", "Gariaband\,\ Madhya\ Pradesh",
"9174806", "Goharganj\,\ Madhya\ Pradesh",
"9171836", "Tumsar\,\ Maharashtra",
"913669", "Abhayapuri\,\ Assam",
"9167653", "Palla\ Hara\,\ Odisha",
"917540", "Bamori\,\ Madhya\ Pradesh",
"9173245", "Mhow\,\ Madhya\ Pradesh",
"9168692", "Papadhandi\,\ Odisha",
"9166767", "M\.Rampur\,\ Odisha",
"9174364", "Hindoli\,\ Rajasthan",
"918919", "Visakhapatnam\,\ Andhra\ Pradesh",
"913012", "Jaisalmer\/Mehsana\,\ Rajasthan",
"9176376", "Birsa\,\ Madhya\ Pradesh",
"9171166", "Umrer\,\ Maharashtra",
"915143", "Hasanganj\,\ Uttar\ Pradesh",
"915440", "Mirzapur\/Hallia\,\ Uttar\ Pradesh",
"9176292", "Pushprajgarh\,\ Madhya\ Pradesh",
"9167654", "Palla\ Hara\,\ Odisha",
"9165597", "Simaria\,\ Bihar",
"911494", "Behror\,\ Rajasthan",
"9171512", "Samudrapur\,\ Maharashtra",
"9165332", "Basia\,\ Bihar",
"911906", "Spiti\/Kaza\,\ Himachal\ Pradesh",
"9174363", "Hindoli\,\ Rajasthan",
"913872", "Chandel\,\ Manipur",
"9181720", "Hassan\,\ Karnataka",
"9166722", "Dharamgarh\,\ Odisha",
"9162792", "Barauni\,\ Bihar",
"9173222", "Depalpur\,\ Madhya\ Pradesh",
"9171982", "Tirora\,\ Maharashtra",
"9168433", "Puruna\ Katak\,\ Odisha",
"911472", "Chittorgarh\,\ Rajasthan",
"9176438", "Bijadandi\,\ Madhya\ Pradesh",
"9167617", "Chhendipada\,\ Odisha",
"9166473", "Naktideul\,\ Odisha",
"918789", "Karimnagar\,\ Andhra\ Pradesh",
"912564", "Nandurbar\,\ Maharashtra",
"9171855", "Pauni\,\ Maharashtra",
"9161124", "Biharsharif\,\ Bihar",
"912586", "Chopda\,\ Maharashtra",
"911921", "Basholi\,\ Jammu\ And\ Kashmir",
"9174975", "Khaniadhana\,\ Madhya\ Pradesh",
"912465", "Billoli\,\ Maharashtra",
"9164326", "Deoghar\,\ Bihar",
"9174808", "Goharganj\,\ Madhya\ Pradesh",
"9174688", "Khandar\,\ Rajasthan",
"9161873", "Mohania\,\ Bihar",
"911983", "Zanaskar\,\ Jammu\ And\ Kashmir",
"9165472", "Chavparan\,\ Bihar",
"9173229", "Depalpur\,\ Madhya\ Pradesh",
"9168593", "Motu\,\ Odisha",
"9171614", "Parasia\,\ Madhya\ Pradesh",
"914290", "Omalur\,\ Tamil\ Nadu",
"914895", "Kalpeni\,\ Lakshadweep",
"9167552", "Khurda\,\ Odisha",
"9176455", "Karanjia\,\ Madhya\ Pradesh",
"9165943", "Baharagora\,\ Bihar",
"9175293", "Laher\,\ Madhya\ Pradesh",
"915683", "Auraiya\,\ Uttar\ Pradesh",
"9174270", "Bhanpura\,\ Madhya\ Pradesh",
"9176378", "Birsa\,\ Madhya\ Pradesh",
"9167815", "Basta\,\ Odisha",
"9161556", "Ekma\,\ Bihar",
"9176299", "Pushprajgarh\,\ Madhya\ Pradesh",
"9176241", "Sihora\,\ Madhya\ Pradesh",
"9165437", "Barhi\,\ Bihar",
"9167235", "Athgarh\,\ Odisha",
"911595", "Jhunjhunu\/Bissau\,\ Rajasthan",
"918774", "Tirupathi\,\ Andhra\ Pradesh",
"9162564", "Ramnagar\,\ Bihar",
"9171657", "Saunsar\,\ Madhya\ Pradesh",
"912795", "Kodinar\,\ Gujarat",
"9181528", "Kolar\,\ Karnatak",
"918391", "Kudligi\,\ Karnataka",
"9175294", "Laher\,\ Madhya\ Pradesh",
"9171707", "Chumur\,\ Maharashtra",
"91452", "Madurai\,\ Tamil\ Nadu",
"9161535", "Maharajganj\,\ Bihar",
"918258", "Karkala\,\ Karnataka",
"918462", "Nizamabad\,\ Andhra\ Pradesh",
"91342", "Burdwan\,\ West\ Bengal",
"9167256", "Dhanmandal\,\ Odisha",
"91205", "Pune\,\ Maharashtra",
"9162563", "Ramnagar\,\ Bihar",
"9171066", "Bhiwapur\,\ Maharashtra",
"9161123", "Biharsharif\,\ Bihar",
"917728", "Kasdol\,\ Madhya\ Pradesh",
"9177062", "Gariaband\,\ Madhya\ Pradesh",
"918358", "Basavanabagewadi\,\ Karnataka",
"9171613", "Parasia\,\ Madhya\ Pradesh",
"9168594", "Motu\,\ Odisha",
"9161874", "Mohania\,\ Bihar",
"9165944", "Baharagora\,\ Bihar",
"911786", "Kalpa\,\ Himachal\ Pradesh",
"9176436", "Bijadandi\,\ Madhya\ Pradesh",
"9168673", "Jharigan\,\ Odisha",
"9174266", "Sitamau\,\ Madhya\ Pradesh",
"911605", "Kharar\,\ Punjab",
"9174843", "Silwani\,\ Madhya\ Pradesh",
"9163467", "Lakhisarai\,\ Bihar",
"917784", "Parasgaon\,\ Madhya\ Pradesh",
"911522", "Bikaner\/Jamsar\,\ Rajasthan",
"9176274", "Manpur\,\ Madhya\ Pradesh",
"9176420", "Mandla\,\ Madhya\ Pradesh",
"917850", "Bhanupratappur\,\ Madhya\ Pradesh",
"917255", "Barshi\ Takli\,\ Maharashtra",
"9162445", "Khagaria\,\ Bihar",
"9162774", "Phulparas\,\ Bihar",
"9171357", "Chamorshi\,\ Maharashtra",
"9165875", "Chakardharpur\,\ Bihar",
"9164626", "Dhamdaha\,\ Bihar",
"9174388", "Keshoraipatan\/Patan\,\ Rajasthan",
"9176515", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9165534", "Ramgarh\,\ Bihar",
"912435", "Kannad\,\ Maharashtra",
"9167412", "Bhubaneshwar\,\ Odisha",
"9173959", "Sondhwa\,\ Madhya\ Pradesh",
"912321", "Radhanagar\,\ Maharashtra",
"918725", "Metpalli\,\ Andhra\ Pradesh",
"914822", "Palai\,\ Kerala",
"9176280", "Karpa\,\ Madhya\ Pradesh",
"9162467", "Jainagar\,\ Bihar",
"91268", "Nadiad\,\ Gujarat",
"91551", "Gorakhpur\,\ Uttar\ Pradesh",
"918610", "Nellore\,\ Andhra\ Pradesh",
"9174527", "Chhabra\,\ Rajasthan",
"9163445", "Monghyr\,\ Bihar",
"9181738", "Sakleshpur\,\ Karnataka",
"9171314", "Sironcha\,\ Maharashtra",
"912383", "Ausa\,\ Maharashtra",
"9162586", "Areraj\,\ Bihar",
"9165533", "Ramgarh\,\ Bihar",
"917914", "Ahmedabad\ Local\,\ Gujarat",
"9174562", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9185868", "Vayalpad\,\ Andhra\ Pradesh",
"912927", "Osian\/Dhanwara\,\ Rajasthan",
"912748", "Dhanera\,\ Gujarat",
"9166492", "Jamankira\,\ Odisha",
"9162422", "Benipur\,\ Bihar",
"918155", "Gowribidanur\,\ Karnataka",
"9171313", "Sironcha\,\ Maharashtra",
"9163282", "Daudnagar\,\ Bihar",
"9174844", "Silwani\,\ Madhya\ Pradesh",
"9168497", "Daringbadi\,\ Odisha",
"9175398", "Ambah\,\ Madhya\ Pradesh",
"9168674", "Jharigan\,\ Odisha",
"9167926", "Baripada\,\ Odisha",
"9176273", "Manpur\,\ Madhya\ Pradesh",
"9162773", "Phulparas\,\ Bihar",
"9162282", "Pupri\,\ Bihar",
"9163422", "H\.Kharagpur\,\ Bihar",
"9166255", "Lahunipara\,\ Odisha",
"9166577", "Kantabhanji\,\ Odisha",
"913639", "Baghmara\,\ Meghalaya",
"9167353", "Telkoi\,\ Odisha",
"9174268", "Sitamau\,\ Madhya\ Pradesh",
"9163327", "Nabinagar\,\ Bihar",
"9174664", "Bonli\,\ Rajasthan",
"9168537", "Sunabeda\,\ Odisha",
"9176360", "Baihar\,\ Madhya\ Pradesh",
"916216", "Muzaffarpur\,\ Bihar",
"912520", "Jawahar\,\ Maharashtra",
"915254", "Nanparah\/Mihinpurwa\,\ Uttar\ Pradesh",
"9166532", "Dunguripali\,\ Odisha",
"911734", "Naraingarh\,\ Haryana",
"9181736", "Sakleshpur\,\ Karnataka",
"9174386", "Keshoraipatan\/Patan\,\ Rajasthan",
"917671", "Jaitwara\,\ Madhya\ Pradesh",
"9174569", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"913657", "Mairang\,\ Meghalaya",
"916316", "Gaya\,\ Bihar",
"9161892", "Bhabhua\,\ Bihar",
"9164224", "Godda\,\ Bihar",
"9165493", "Bermo\,\ Bihar",
"9171184", "Kalmeshwar\,\ Maharashtra",
"9168572", "Gunupur\,\ Odisha",
"9167317", "Anandapur\,\ Odisha",
"9181755", "Holenarasipur\,\ Karnataka",
"917779", "Ramchandrapur\,\ Madhya\ Pradesh",
"9173952", "Sondhwa\,\ Madhya\ Pradesh",
"914638", "Vilathikulam\,\ Tamil\ Nadu",
"9171183", "Kalmeshwar\,\ Maharashtra",
"9165494", "Bermo\,\ Bihar",
"9164223", "Godda\,\ Bihar",
"9165677", "Barwadih\,\ Bihar",
"912897", "Dhrol\,\ Gujarat",
"9167354", "Telkoi\,\ Odisha",
"9172885", "Bhikangaon\,\ Madhya\ Pradesh",
"9163362", "Rajauli\,\ Bihar",
"917766", "Dharamjaigarh\,\ Madhya\ Pradesh",
"9171452", "Chicholi\,\ Madhya\ Pradesh",
"9166816", "Jujumura\,\ Odisha",
"9174663", "Bonli\,\ Rajasthan",
"9165632", "Bhawanathpur\,\ Bihar",
"913010", "Jaisalmer\/Shahgarh\,\ Rajasthan",
"9165256", "Simdega\,\ Bihar",
"9168614", "Malkangiri\,\ Odisha",
"913865", "Phek\,\ Nagaland",
"9175219", "Seondha\,\ Madhya\ Pradesh",
"917542", "Guna\,\ Madhya\ Pradesh",
"9162713", "Benipatti\,\ Bihar",
"912595", "Dhadgaon\,\ Maharashtra",
"9168657", "Kashipur\,\ Odisha",
"912921", "Phalodi\/Bap\,\ Rajasthan",
"911586", "Nawa\/Kuchamancity\,\ Rajasthan",
"9167944", "Rairangpur\,\ Odisha",
"9174826", "Raisen\,\ Madhya\ Pradesh",
"911465", "Thanaghazi\,\ Rajasthan",
"9171373", "Desaiganj\,\ Maharashtra",
"917528", "Bijaypur\,\ Madhya\ Pradesh",
"912983", "Barmer\/Gudda\,\ Rajasthan",
"9167943", "Rairangpur\,\ Odisha",
"912327", "Gadhinglaj\,\ Maharashtra",
"918592", "Ongole\,\ Andhra\ Pradesh",
"9176575", "Jaitpur\,\ Madhya\ Pradesh",
"9176257", "Umariapan\,\ Madhya\ Pradesh",
"9173202", "Pandhana\,\ Madhya\ Pradesh",
"9162757", "Rosera\,\ Bihar",
"9171374", "Desaiganj\,\ Maharashtra",
"911470", "Dungla\,\ Rajasthan",
"9184536", "Medak\,\ Andhra\ Pradesh",
"913870", "Ukhrursouth\/Kassemkhulen\,\ Manipur",
"911795", "Nalagarh\,\ Himachal\ Pradesh",
"9165235", "Ghaghra\,\ Bihar",
"9181700", "Alur\,\ Karnataka",
"9168613", "Malkangiri\,\ Odisha",
"9166702", "Bhawanipatna\,\ Odisha",
"915442", "Mirzapur\,\ Uttar\ Pradesh",
"9165815", "Bhandaria\,\ Bihar",
"9162714", "Benipatti\,\ Bihar",
"912713", "Dhandhuka\,\ Gujarat",
"913561", "Jalpaiguri\,\ West\ Bengal",
"917536", "Sabalgarh\,\ Madhya\ Pradesh",
"912891", "Jamkalyanpur\,\ Gujarat",
"9171762", "Warora\,\ Maharashtra",
"9167332", "Ghatgaon\,\ Odisha",
"9171434", "Bhainsdehi\,\ Madhya\ Pradesh",
"918475", "Chincholi\,\ Karnataka",
"917363", "Berchha\,\ Madhya\ Pradesh",
"9168216", "Bhanjanagar\,\ Odisha",
"9165654", "Latehar\,\ Bihar",
"912764", "Kalol\,\ Gujarat",
"9168166", "Mohana\,\ Odisha",
"9173209", "Pandhana\,\ Madhya\ Pradesh",
"918589", "Siddavattam\,\ Andhra\ Pradesh",
"913759", "Bihupuria\,\ Assam",
"9166553", "Titlagarh\,\ Odisha",
"914292", "Valapady\,\ Tamil\ Nadu",
"914142", "Cuddalore\,\ Tamil\ Nadu",
"914374", "Papanasam\,\ Tamil\ Nadu",
"9177007", "Nagri\,\ Madhya\ Pradesh",
"917263", "Khamgaon\,\ Maharashtra",
"9165617", "Garhwa\,\ Bihar",
"9164542", "Purnea\,\ Bihar",
"9171692", "Batkakhapa\,\ Madhya\ Pradesh",
"9173934", "Jobat\,\ Madhya\ Pradesh",
"9174828", "Raisen\,\ Madhya\ Pradesh",
"9166554", "Titlagarh\,\ Odisha",
"912472", "Osmanabad\,\ Maharashtra",
"9173933", "Jobat\,\ Madhya\ Pradesh",
"916713", "Cuttack\,\ Odisha",
"913651", "Tura\,\ Meghalaya",
"915315", "Dalmau\/Lalganj\,\ Uttar\ Pradesh",
"911564", "Sardarshahar\,\ Rajasthan",
"9161355", "Bikram\,\ Bihar",
"91755", "Bhopal\,\ Madhya\ Pradesh",
"918488", "Sindagi\,\ Karnataka",
"911503", "Sadulshahar\,\ Rajasthan",
"9171965", "Arjuni\ Morgaon\,\ Maharashtra",
"9175212", "Seondha\,\ Madhya\ Pradesh",
"9166517", "Birmaharajpur\,\ Odisha",
"9164246", "Banka\,\ Bihar",
"912906", "Salumber\,\ Rajasthan",
"9171433", "Bhainsdehi\,\ Madhya\ Pradesh",
"914864", "Adimaly\,\ Kerala",
"9171727", "Chandrapur\,\ Maharashtra",
"917740", "Bodla\,\ Madhya\ Pradesh",
"9165653", "Latehar\,\ Bihar",
"9164525", "Katihar\,\ Bihar",
"9167677", "Barbil\,\ Odisha",
"9171537", "Hinganghat\,\ Maharashtra",
"9174507", "Sangod\,\ Rajasthan",
"918424", "Devarahippargi\,\ Karnataka",
"9167494", "Bhubaneshwar\,\ Odisha",
"9164735", "Supaul\,\ Bihar",
"9175964", "Gyraspur\,\ Madhya\ Pradesh",
"912734", "Chanasma\,\ Gujarat",
"9171392", "Kurkheda\,\ Maharashtra",
"918219", "Mysore\,\ Karnataka",
"9166413", "Deodgarh\,\ Odisha",
"917233", "Pusad\,\ Maharashtra",
"918612", "Nellore\,\ Andhra\ Pradesh",
"9165317", "Mandar\,\ Bihar",
"9168184", "Buguda\,\ Odisha",
"9171572", "Arvi\,\ Maharashtra",
"9167632", "Athmallik\,\ Odisha",
"912453", "Gangakhed\,\ Maharashtra",
"9165354", "Chainpur\,\ Bihar",
"918319", "Belgaum\,\ Karnataka",
"911520", "Bikaner\/Chhatargarh\,\ Rajasthan",
"917852", "Toynar\,\ Madhya\ Pradesh",
"9176400", "Shahpur\,\ Madhya\ Pradesh",
"9168183", "Buguda\,\ Odisha",
"911897", "Pangi\/Killar\,\ Himachal\ Pradesh",
"915466", "Sagri\,\ Uttar\ Pradesh",
"918133", "Chikkanayakanahalli\,\ Karnataka",
"9165353", "Chainpur\,\ Bihar",
"9166457", "Jharsuguda\,\ Odisha",
"918816", "Bhimavaram\,\ Andhra\ Pradesh",
"917478", "Bundi\,\ Rajasthan",
"9165896", "Jhinkpani\,\ Bihar",
"911693", "Barwala\,\ Haryana",
"9167493", "Bhubaneshwar\,\ Odisha",
"9164756", "S\.Bakhtiarpur\,\ Bihar",
"9172691", "Deolgaonraja\,\ Maharashtra",
"918821", "Jangareddygudem\,\ Andhra\ Pradesh",
"9168452", "Phiringia\,\ Odisha",
"91129", "Faridabad\,\ Haryana",
"9172862", "Khetia\,\ Madhya\ Pradesh",
"9175963", "Gyraspur\,\ Madhya\ Pradesh",
"911534", "Kolayat\,\ Rajasthan",
"9166414", "Deodgarh\,\ Odisha",
"911435", "Tonk\/Piploo\,\ Rajasthan",
"9164204", "Amarpur\,\ Bihar",
"9161814", "Piro\,\ Bihar",
"9171673", "Amarwada\,\ Madhya\ Pradesh",
"9167533", "Nayagarh\,\ Odisha",
"9172869", "Khetia\,\ Madhya\ Pradesh",
"9164343", "Dumka\,\ Bihar",
"914179", "Tirupattur\,\ Tamil\ Nadu",
"918397", "H\.B\.Halli\,\ Karnataka",
"912522", "Bhiwandi\,\ Maharashtra",
"9161857", "Bikramganj\,\ Bihar",
"913835", "Saiha\,\ Mizoram",
"9162247", "Hajipur\,\ Bihar",
"9164344", "Dumka\,\ Bihar",
"915823", "Aonla\,\ Uttar\ Pradesh",
"9174585", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9174210", "Manasa\,\ Madhya\ Pradesh",
"9161146", "Jahanabad\,\ Bihar",
"915881", "Bisalpur\,\ Uttar\ Pradesh",
"917584", "Rahatgarh\,\ Madhya\ Pradesh",
"9163265", "Sherghati\,\ Bihar",
"916615", "Rourkela\,\ Odisha",
"9163247", "Nawada\,\ Bihar",
"9164203", "Amarpur\,\ Bihar",
"9174915", "Narwar\,\ Madhya\ Pradesh",
"913224", "Haldia\,\ West\ Bengal",
"91571", "Aligarh\,\ Uttar\ Pradesh",
"918525", "Gudur\/Kodumur\,\ Andhra\ Pradesh",
"911748", "Gharaunda\,\ Haryana",
"9165412", "Chatra\,\ Bihar",
"918209", "Udupi\,\ Karnataka",
"9167534", "Nayagarh\,\ Odisha",
"9171674", "Amarwada\,\ Madhya\ Pradesh",
"9161813", "Piro\,\ Bihar",
"9162265", "Sitamarhi\,\ Bihar",
"9171497", "Tamia\,\ Madhya\ Pradesh",
"918682", "Nalgonda\,\ Andhra\ Pradesh",
"915175", "Lalitpur\/Talbehat\,\ Uttar\ Pradesh",
"912456", "Hingoli\,\ Maharashtra",
"911874", "Gurdaspur\,\ Punjab",
"917563", "Nasrullaganj\,\ Madhya\ Pradesh",
"912920", "Bilara\/Bhopalgarh\,\ Rajasthan",
"9176344", "Lamta\,\ Madhya\ Pradesh",
"9174640", "Karauli\,\ Rajasthan",
"9167662", "Keonjhar\,\ Odisha",
"917236", "Maregaon\,\ Maharashtra",
"918389", "Siddapur\,\ Karnataka",
"914574", "Manamadurai\,\ Tamil\ Nadu",
"9171486", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"912678", "Devgadhbaria\,\ Gujarat",
"911892", "Kangra\/Dharamsala\,\ Himachal\ Pradesh",
"9166446", "Rairakhol\,\ Odisha",
"913011", "Jaisalmer\/Pasewar\,\ Rajasthan",
"9175934", "Kurwai\,\ Madhya\ Pradesh",
"913474", "Bethuadahari\,\ West\ Bengal",
"9164765", "Madhepura\,\ Bihar",
"9171567", "Talegaokarangal\,\ Maharashtra",
"9168604", "Boriguma\,\ Odisha",
"9165685", "Balumath\,\ Bihar",
"9171522", "Wardha\,\ Maharashtra",
"9185861", "Vayalpad\,\ Andhra\ Pradesh",
"9175933", "Kurwai\,\ Madhya\ Pradesh",
"913871", "Mao\/Korang\,\ Manipur",
"917857", "Bacheli\,\ Madhya\ Pradesh",
"912934", "Desuri\/Rani\,\ Rajasthan",
"9168603", "Boriguma\,\ Odisha",
"911364", "Ukhimath\/Guptkashi\,\ Uttarakhand",
"9166712", "Rajkhariar\,\ Odisha",
"911696", "Kalanwali\,\ Haryana",
"9173212", "Sanwer\,\ Madhya\ Pradesh",
"9174352", "Gangdhar\,\ Rajasthan",
"9167627", "Dhenkanal\,\ Odisha",
"911471", "Rashmi\,\ Rajasthan",
"918813", "Eluru\ Kovvur\/Nidadavolu\,\ Andhra\ Pradesh",
"918136", "Pavagada\,\ Karnataka",
"915463", "Lalganj\,\ Uttar\ Pradesh",
"918617", "Nellore\,\ Andhra\ Pradesh",
"9172877", "Gogaon\,\ Madhya\ Pradesh",
"914114", "Chengalpattu\,\ Tamil\ Nadu",
"9127175", "Sanand\,\ Gujarat",
"9176343", "Lamta\,\ Madhya\ Pradesh",
"911922", "Kathua\,\ Jammu\ And\ Kashmir",
"9165887", "Jagarnathpur\,\ Bihar",
"9161114", "Hilsa\,\ Bihar",
"9165607", "Patan\,\ Bihar",
"9163256", "Pakribarwan\,\ Bihar",
"9164316", "Jharmundi\,\ Bihar",
"9171624", "Chhindwara\,\ Madhya\ Pradesh",
"915648", "Bayana\,\ Rajasthan",
"9173219", "Sanwer\,\ Madhya\ Pradesh",
"917228", "Morshi\,\ Maharashtra",
"91161", "Ludhiana\,\ Punjab",
"9177017", "Pingeshwar\,\ Madhya\ Pradesh",
"9174359", "Gangdhar\,\ Rajasthan",
"9167563", "Balugaon\,\ Odisha",
"911386", "Lansdowne\,\ Uttarakhand",
"91591", "Moradabad\,\ Uttar\ Pradesh",
"9167825", "Balasore\,\ Odisha",
"9161157", "Danapur\,\ Bihar",
"915414", "Bhadohi\,\ Uttar\ Pradesh",
"918864", "Rampachodavaram\,\ Andhra\ Pradesh",
"9177054", "Kurud\,\ Madhya\ Pradesh",
"917328", "Khalwa\,\ Madhya\ Pradesh",
"912145", "Mahad\,\ Maharashtra",
"9174130", "Sailana\,\ Madhya\ Pradesh",
"9162235", "Motipur\,\ Bihar",
"912527", "Shahapur\,\ Maharashtra",
"918392", "Bellary\,\ Karnataka",
"9167564", "Balugaon\,\ Odisha",
"918274", "Virajpet\,\ Karnataka",
"917514", "Gwalior\,\ Madhya\ Pradesh",
"917741", "Kawardha\,\ Madhya\ Pradesh",
"9161846", "Sasaram\,\ Bihar",
"9177053", "Kurud\,\ Madhya\ Pradesh",
"918461", "Dichpalli\,\ Andhra\ Pradesh",
"9165976", "Saraikela\/Adstyapur\,\ Bihar",
"9174860", "Bareli\,\ Madhya\ Pradesh",
"9167842", "Bhadrak\,\ Odisha",
"9161113", "Hilsa\,\ Bihar",
"9163235", "Dumraon\,\ Bihar",
"9168502", "Kalimela\,\ Odisha",
"9162552", "Raxaul\,\ Bihar",
"913650", "Dadengiri\/Phulbari\,\ Meghalaya",
"9171623", "Chhindwara\,\ Madhya\ Pradesh",
"917125", "Nagpur\,\ Maharashtra",
"9167282", "Jajapur\ Town\,\ Odisha",
"912986", "Barmer\/Dhorimanna\,\ Rajasthan",
"912629", "M\.M\.Mangrol\,\ Gujarat",
"9176410", "Niwas\,\ Madhya\ Pradesh",
"913218", "Canning\,\ West\ Bengal",
"911521", "Bikaner\/Jaimalsar\,\ Rajasthan",
"911583", "Jayal\,\ Rajasthan",
"918408", "Donakonda\,\ Andhra\ Pradesh",
"915447", "Dudhi\,\ Uttar\ Pradesh",
"918834", "Rajahmundri\,\ Andhra\ Pradesh",
"9174554", "Digod\/Sultanpur\,\ Rajasthan",
"918184", "Sorab\,\ Karnataka",
"9176525", "Shahdol\,\ Madhya\ Pradesh",
"9164616", "Raniganj\,\ Bihar",
"9166403", "Bagdihi\,\ Odisha",
"9165307", "Bundu\,\ Bihar",
"912322", "Shirol\/Jalsingpur\,\ Maharashtra",
"911995", "Kishtwar\,\ Jammu\ And\ Kashmir",
"9174126", "Ratlam\,\ Madhya\ Pradesh",
"9174659", "Sapotra\,\ Rajasthan",
"9174517", "Atru\,\ Rajasthan",
"9162746", "Samastipur\,\ Bihar",
"9171324", "Gadchiroli\,\ Maharashtra",
"9168646", "Mathili\,\ Odisha",
"912716", "Dehgam\,\ Gujarat",
"9167586", "Nimapara\,\ Odisha",
"9174709", "Bundi\,\ Rajasthan",
"9174876", "Begamganj\,\ Madhya\ Pradesh",
"9166404", "Bagdihi\,\ Odisha",
"918225", "Cowdahalli\,\ Karnataka",
"913524", "Harirampur\,\ West\ Bengal",
"9165265", "Lohardaga\,\ Bihar",
"9171323", "Gadchiroli\,\ Maharashtra",
"9176306", "Katangi\,\ Madhya\ Pradesh",
"9165247", "Gumla\,\ Bihar",
"9167916", "Bangiriposi\,\ Odisha",
"917284", "Rajpur\,\ Madhya\ Pradesh",
"9161582", "Sonepur\,\ Bihar",
"917755", "Mungeli\,\ Madhya\ Pradesh",
"918325", "Goa",
"9163412", "Seikhpura\,\ Bihar",
"9174553", "Digod\/Sultanpur\,\ Rajasthan",
"917547", "Chanderi\,\ Madhya\ Pradesh",
"917266", "Jalgaonjamod\,\ Maharashtra",
"9171777", "Brahmapuri\,\ Maharashtra",
"917694", "Keolari\,\ Madhya\ Pradesh",
"9164257", "Katoria\,\ Bihar",
"9164575", "Korha\,\ Bihar",
"915278", "Faizabad\,\ Uttar\ Pradesh",
"9163317", "Imamganj\,\ Bihar",
"9174128", "Ratlam\,\ Madhya\ Pradesh",
"912477", "Paranda\,\ Maharashtra",
"917366", "Khachrod\,\ Madhya\ Pradesh",
"9171464", "Ghorandogri\,\ Madhya\ Pradesh",
"9161804", "Adhaura\,\ Bihar",
"9174340", "Pirawa\/Raipur\,\ Rajasthan",
"9171732", "Rajura\,\ Maharashtra",
"9174702", "Bundi\,\ Rajasthan",
"917672", "Satna\,\ Madhya\ Pradesh",
"9178080", "\`",
"917279", "Nandnva\,\ Maharashtra",
"917533", "Karhal\,\ Madhya\ Pradesh",
"918519", "Allagadda\,\ Andhra\ Pradesh",
"9164214", "Naugachia\,\ Bihar",
"9176248", "Sihora\,\ Madhya\ Pradesh",
"918644", "Tenali\,\ Andhra\ Pradesh",
"914147", "Tindivanam\,\ Tamil\ Nadu",
"9174652", "Sapotra\,\ Rajasthan",
"9167327", "Hindol\,\ Odisha",
"9181521", "Kolar\,\ Karnatak",
"9161803", "Adhaura\,\ Bihar",
"9171463", "Ghorandogri\,\ Madhya\ Pradesh",
"912903", "Chohtan\/Gangasar\,\ Rajasthan",
"9165402", "Govindpur\,\ Bihar",
"911234", "Baghpat\/Baraut\,\ Uttar\ Pradesh",
"9174878", "Begamganj\,\ Madhya\ Pradesh",
"9164213", "Naugachia\,\ Bihar",
"911506", "Anupgarh\/Gharsana\,\ Rajasthan",
"9174905", "Pohari\,\ Madhya\ Pradesh",
"915880", "Puranpur\,\ Uttar\ Pradesh",
"916716", "Cuttack\,\ Odisha",
"9165385", "Torpa\,\ Bihar",
"9166826", "Attabira\,\ Odisha",
"9176308", "Katangi\,\ Madhya\ Pradesh",
"911334", "Roorkee\/Haridwar\,\ Uttarakhand",
"912964", "Dungarpur\,\ Rajasthan",
"9168155", "Parlakhemundi\,\ Odisha",
"9174200", "Jawad\,\ Madhya\ Pradesh",
"918418", "Medchal\,\ Andhra\ Pradesh",
"9167976", "Jashipur\,\ Odisha",
"9181768", "Cannarayapatna\,\ Karnataka",
"9168624", "Gudari\,\ Odisha",
"915844", "Powayan\,\ Uttar\ Pradesh",
"917541", "Isagarh\,\ Madhya\ Pradesh",
"9162437", "Begusarai\,\ Bihar",
"9163472", "Chakai\,\ Bihar",
"9175229", "Datia\,\ Madhya\ Pradesh",
"91364", "Shillong\,\ Meghalaya",
"9174143", "Jaora\,\ Madhya\ Pradesh",
"9165564", "Tisri\,\ Bihar",
"9162723", "Darbhanga\,\ Bihar",
"9166793", "Komana\,\ Odisha",
"913775", "Majuli\,\ Assam",
"9173293", "Khakner\,\ Madhya\ Pradesh",
"913193", "Andaman\ \&\ Nicobar\,\ Nicobar\ Islands",
"9187593", "Outsarangapalle\,\ Andhra\ Pradesh",
"913243", "Khatra\,\ West\ Bengal",
"9175387", "Ambah\,\ Madhya\ Pradesh",
"912922", "Osian\,\ Rajasthan",
"9176483", "Mawai\,\ Madhya\ Pradesh",
"9174816", "Gairatganj\,\ Madhya\ Pradesh",
"918668", "Vijayawada\,\ Andhra\ Pradesh",
"9162472", "Singhwara\,\ Bihar",
"918680", "Nidamanur\/Hillcolony\,\ Andhra\ Pradesh",
"91261", "Surat\,\ Gujarat",
"9165842", "Bishrampur\,\ Bihar",
"9174236", "Neemuch\,\ Madhya\ Pradesh",
"915162", "Orai\,\ Uttar\ Pradesh",
"9176484", "Mawai\,\ Madhya\ Pradesh",
"9187594", "Outsarangapalle\,\ Andhra\ Pradesh",
"9173294", "Khakner\,\ Madhya\ Pradesh",
"9164676", "Banmankhi\,\ Bihar",
"912139", "Pirangut\,\ Maharashtra",
"9167607", "Talcher\,\ Odisha",
"9174577", "Mangrol\,\ Rajasthan",
"9167887", "Soro\,\ Odisha",
"9174255", "Garoth\,\ Madhya\ Pradesh",
"911527", "Lunkaransar\/Rajasarb\,\ Rajasthan",
"9176470", "Ghughari\,\ Madhya\ Pradesh",
"918558", "Tadipatri\,\ Andhra\ Pradesh",
"9168623", "Gudari\,\ Odisha",
"913788", "Kolaring\,\ Arunachal\ Pradesh",
"9182206", "Gundlupet\,\ Karnataka",
"91422", "Coimbatore\,\ Tamil\ Nadu",
"9171346", "Bhamregadh\,\ Maharashtra",
"9165825", "Chaibasa\,\ Bihar",
"9166794", "Komana\,\ Odisha",
"9174532", "Baran\,\ Rajasthan",
"9162724", "Darbhanga\,\ Bihar",
"9165563", "Tisri\,\ Bihar",
"9174144", "Jaora\,\ Madhya\ Pradesh",
"9174950", "Badarwas\,\ Madhya\ Pradesh",
"913562", "Mal\ Bazar\,\ West\ Bengal",
"916313", "Gaya\,\ Bihar",
"914258", "Dharampuram\,\ Tamil\ Nadu",
"9175940", "Ganjbasoda\,\ Madhya\ Pradesh",
"912892", "Okha\,\ Gujarat",
"9174539", "Baran\,\ Rajasthan",
"9168226", "Aska\,\ Odisha",
"9181766", "Cannarayapatna\,\ Karnataka",
"9175267", "Ghatigaon\,\ Madhya\ Pradesh",
"9167685", "Parajang\,\ Odisha",
"9168545", "Jeypore\,\ Odisha",
"9174634", "Gangapur\,\ Rajasthan",
"9168567", "Rayagada\,\ Odisha",
"916213", "Muzaffarpur\,\ Bihar",
"9176330", "Waraseoni\,\ Madhya\ Pradesh",
"9171604", "Jamai\,\ Madhya\ Pradesh",
"912874", "Manavadar\,\ Gujarat",
"9174238", "Neemuch\,\ Madhya\ Pradesh",
"9164273", "Kathikund\,\ Bihar",
"9168486", "Kotagarh\,\ Odisha",
"9171753", "Bhadrawati\,\ Maharashtra",
"9165627", "Daltonganj\,\ Bihar",
"9189463", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9174818", "Gairatganj\,\ Madhya\ Pradesh",
"9166844", "Paikamal\,\ Odisha",
"9164782", "Saharsa\,\ Bihar",
"9165662", "Japla\,\ Bihar",
"9171603", "Jamai\,\ Madhya\ Pradesh",
"9174633", "Gangapur\,\ Rajasthan",
"912696", "Borsad\,\ Gujarat",
"917763", "Jashpurnagar\,\ Madhya\ Pradesh",
"912471", "Tuljapur\,\ Maharashtra",
"9189464", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"918443", "Shorapur\,\ Karnataka",
"9168522", "Koraput\,\ Odisha",
"9171754", "Bhadrawati\,\ Maharashtra",
"91260", "Vapi\,\ Gujarat",
"9164274", "Kathikund\,\ Bihar",
"9166843", "Paikamal\,\ Odisha",
"9166266", "Banaigarh\,\ Odisha",
"913652", "Jowai\,\ Meghalaya",
"9175222", "Datia\,\ Madhya\ Pradesh",
"914997", "Kanhangad\,\ Kerala",
"9162597", "Pakridayal\,\ Bihar",
"9166527", "Balangir\,\ Odisha",
"9163377", "Arwal\,\ Bihar",
"9164515", "Barsoi\,\ Bihar",
"9171717", "Gond\ Pipri\,\ Maharashtra",
"912364", "Deogad\,\ Maharashtra",
"911685", "Guruharsahai\,\ Punjab",
"9171136", "Saoner\,\ Maharashtra",
"911477", "Nimbahera\,\ Rajasthan",
"9174334", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9176505", "Beohari\,\ Madhya\ Pradesh",
"9167402", "Bhubaneshwar\,\ Odisha",
"9166737", "Jayapatna\,\ Odisha",
"9165327", "Giridih\,\ Bihar",
"9166423", "Kuchinda\,\ Odisha",
"912320", "Chandgad\,\ Maharashtra",
"9171866", "Sakoli\,\ Maharashtra",
"9177039", "Manpur\,\ Madhya\ Pradesh",
"913673", "Haflong\,\ Assam",
"9173237", "Punasa\,\ Madhya\ Pradesh",
"918626", "Kavali\,\ Andhra\ Pradesh",
"9168464", "Baliguda\,\ Odisha",
"9166772", "Narlaroad\,\ Odisha",
"912825", "Gondal\,\ Gujarat",
"916516", "Ranchi\,\ Bihar",
"917851", "Bhopalpatnam\,\ Madhya\ Pradesh",
"913877", "Tamenglong\,\ Manipur",
"9163493", "Jhajha\,\ Bihar",
"918848", "Kakinada\,\ Andhra\ Pradesh",
"9176326", "Balaghat\,\ Madhya\ Pradesh",
"9175952", "Nateran\,\ Madhya\ Pradesh",
"9174949", "Kolaras\,\ Madhya\ Pradesh",
"9176468", "Nainpur\,\ Madhya\ Pradesh",
"911964", "Kalakot\,\ Jammu\ And\ Kashmir",
"91795", "Ahmedabad\ Local\,\ Gujarat",
"9168463", "Baliguda\,\ Odisha",
"9163494", "Jhajha\,\ Bihar",
"913017", "Pokhran\/Madasar\,\ Rajasthan",
"9171155", "Mouda\,\ Maharashtra",
"915664", "Mant\/Vrindavan\,\ Uttar\ Pradesh",
"918719", "Mahabubbad\,\ Andhra\ Pradesh",
"917733", "Pawai\,\ Madhya\ Pradesh",
"9174333", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"911903", "Banjar\,\ Himachal\ Pradesh",
"9165362", "Palkot\,\ Bihar",
"9166424", "Kuchinda\,\ Odisha",
"9162534", "Narkatiaganj\,\ Bihar",
"918709", "Warangal\,\ Andhra\ Pradesh",
"9171055", "Narkhed\,\ Maharashtra",
"9167265", "Jajapur\ Road\,\ Odisha",
"917670", "Majhagwan\,\ Madhya\ Pradesh",
"9165467", "Hazaribagh\,\ Bihar",
"912995", "Pokhran\/Nachna\,\ Rajasthan",
"9164292", "Kahalgaon\,\ Bihar",
"9165586", "Dumri\(Isribazar\)\,\ Bihar",
"9161824", "Arrah\,\ Bihar",
"918638", "Guntur\,\ Andhra\ Pradesh",
"917747", "Mohla\,\ Madhya\ Pradesh",
"9175959", "Nateran\,\ Madhya\ Pradesh",
"9174942", "Kolaras\,\ Madhya\ Pradesh",
"912521", "Talasari\,\ Maharashtra",
"911348", "Lansdowne\/Syunsi\,\ Uttarakhand",
"9165916", "Chandil\,\ Bihar",
"9165445", "Gomia\,\ Bihar",
"918467", "Bodhan\,\ Andhra\ Pradesh",
"9167247", "Jagatsinghpur\,\ Odisha",
"915613", "Achhnera\,\ Uttar\ Pradesh",
"912583", "Edalabad\,\ Maharashtra",
"9176466", "Nainpur\,\ Madhya\ Pradesh",
"9176328", "Balaghat\,\ Madhya\ Pradesh",
"911783", "Theog\,\ Himachal\ Pradesh",
"9174220", "Mandsaur\,\ Madhya\ Pradesh",
"9161547", "Siwan\,\ Bihar",
"9174697", "Hindaun\,\ Rajasthan",
"915882", "Pilibhit\,\ Uttar\ Pradesh",
"9177032", "Manpur\,\ Madhya\ Pradesh",
"9171646", "Pandhurna\,\ Madhya\ Pradesh",
"9164596", "Thakurganj\,\ Bihar",
"9165282", "Khunti\,\ Bihar",
"9171036", "Butibori\,\ Maharashtra",
"9164376", "Mahagama\,\ Bihar",
"9162533", "Narkatiaganj\,\ Bihar",
"9174925", "Shivpuri\,\ Madhya\ Pradesh",
"9161565", "Gopalganj\,\ Bihar",
"9177077", "Bagbahera\,\ Madhya\ Pradesh",
"912169", "Shirwal\,\ Maharashtra",
"9161823", "Arrah\,\ Bihar",
"9165422", "Bokaro\,\ Bihar",
"915832", "Badaun\,\ Uttar\ Pradesh",
"9171582", "Deoli\,\ Maharashtra",
"9168174", "R\.Udayigiri\,\ Odisha",
"9165625", "Daltonganj\,\ Bihar",
"9175960", "Gyraspur\,\ Madhya\ Pradesh",
"9164553", "Forbesganj\,\ Bihar",
"9181746", "Arsikere\,\ Karnataka",
"913780", "Dirang\,\ Arunachal\ Pradesh",
"911733", "Kalka\,\ Haryana",
"91565", "Mathura\,\ Uttar\ Pradesh",
"918550", "Yellanuru\,\ Andhra\ Pradesh",
"9166542", "Sonapur\,\ Odisha",
"9168565", "Rayagada\,\ Odisha",
"915253", "Nanpara\,\ Uttar\ Pradesh",
"9168547", "Jeypore\,\ Odisha",
"9167687", "Parajang\,\ Odisha",
"9175265", "Ghatigaon\,\ Madhya\ Pradesh",
"9161323", "Barh\,\ Bihar",
"912876", "Veraval\,\ Gujarat",
"915182", "Khaga\,\ Uttar\ Pradesh",
"9176404", "Shahpur\,\ Madhya\ Pradesh",
"9171715", "Gond\ Pipri\,\ Maharashtra",
"9165642", "Nagarutari\,\ Bihar",
"9164517", "Barsoi\,\ Bihar",
"9173926", "Jhabua\,\ Madhya\ Pradesh",
"912694", "Kheda\,\ Gujarat",
"911851", "Patti\,\ Punjab",
"9161324", "Barh\,\ Bihar",
"9163375", "Arwal\,\ Bihar",
"918660", "Vijayawada\,\ Andhra\ Pradesh",
"9162595", "Pakridayal\,\ Bihar",
"9166525", "Balangir\,\ Odisha",
"9174616", "Mahuwa\,\ Rajasthan",
"9176403", "Shahpur\,\ Madhya\ Pradesh",
"9166246", "Rajgangpur\,\ Odisha",
"9171426", "Bhimpur\,\ Madhya\ Pradesh",
"912672", "Godhra\,\ Gujarat",
"9168173", "R\.Udayigiri\,\ Odisha",
"914551", "Vedasandur\,\ Tamil\ Nadu",
"9164554", "Forbesganj\,\ Bihar",
"916125", "Patna\,\ Bihar",
"917477", "Bundi\,\ Rajasthan",
"913451", "Seharabazar\,\ West\ Bengal",
"912366", "Vengurla\,\ Maharashtra",
"911936", "Pahalgam\,\ Jammu\ And\ Kashmir",
"912384", "Nilanga\,\ Maharashtra",
"918251", "Puttur\,\ Karnataka",
"9181748", "Arsikere\,\ Karnataka",
"918398", "Harapanahalli\,\ Karnataka",
"9175385", "Ambah\,\ Madhya\ Pradesh",
"9165544", "Rajdhanwar\,\ Bihar",
"918351", "Hungund\,\ Karnataka",
"912755", "Sayla\,\ Gujarat",
"917721", "Neora\,\ Madhya\ Pradesh",
"9174213", "Manasa\,\ Madhya\ Pradesh",
"9162435", "Begusarai\,\ Bihar",
"915965", "Champawat\,\ Uttar\ Pradesh",
"917783", "Padamkot\,\ Madhya\ Pradesh",
"9171803", "Salekasa\,\ Maharashtra",
"9171683", "Harrai\,\ Madhya\ Pradesh",
"9165862", "Chainpur\,\ Bihar",
"9174618", "Mahuwa\,\ Rajasthan",
"9165827", "Chaibasa\,\ Bihar",
"9174214", "Manasa\,\ Madhya\ Pradesh",
"9168406", "Tumudibandha\,\ Odisha",
"9162456", "Gogri\,\ Bihar",
"9173928", "Jhabua\,\ Madhya\ Pradesh",
"911555", "Nohar\,\ Rajasthan",
"9171684", "Harrai\,\ Madhya\ Pradesh",
"915642", "Dholpur\,\ Rajasthan",
"9171804", "Salekasa\,\ Maharashtra",
"917222", "Chandurrly\,\ Maharashtra",
"9174257", "Garoth\,\ Madhya\ Pradesh",
"9174575", "Mangrol\,\ Rajasthan",
"9167605", "Talcher\,\ Odisha",
"9167885", "Soro\,\ Odisha",
"9163456", "Jamui\,\ Bihar",
"9171366", "Etapalli\,\ Maharashtra",
"918752", "Bhainsa\,\ Andhra\ Pradesh",
"913582", "Coochbehar\,\ West\ Bengal",
"9165543", "Rajdhanwar\,\ Bihar",
"917913", "Ahmedabad\ Local\,\ Gujarat",
"9167952", "Udala\,\ Odisha",
"918773", "Tirupathi\,\ Andhra\ Pradesh",
"9167245", "Jagatsinghpur\,\ Odisha",
"9165447", "Gomia\,\ Bihar",
"9167526", "Puri\,\ Odisha",
"9181703", "Alur\,\ Karnataka",
"917527", "Mehgaon\,\ Madhya\ Pradesh",
"9171383", "Dhanora\,\ Maharashtra",
"9164352", "Pakur\,\ Bihar",
"9165933", "Manoharpur\,\ Bihar",
"9174962", "Pichhore\,\ Madhya\ Pradesh",
"91494", "Tirur\,\ Kerala",
"911635", "Kotkapura\,\ Punjab",
"9165465", "Hazaribagh\,\ Bihar",
"9171057", "Narkhed\,\ Maharashtra",
"9161522", "Chapra\,\ Bihar",
"9167267", "Jajapur\ Road\,\ Odisha",
"918840", "Kakinada\,\ Andhra\ Pradesh",
"918245", "Mangalore\,\ Karnataka",
"913711", "Udalguri\,\ Assam",
"918195", "Challakere\,\ Karnataka",
"9176446", "Dindori\,\ Madhya\ Pradesh",
"912342", "Islampur\,\ Maharashtra",
"913212", "Champadanga\,\ West\ Bengal",
"9165934", "Manoharpur\,\ Bihar",
"9177075", "Bagbahera\,\ Madhya\ Pradesh",
"9168192", "Surada\,\ Odisha",
"9167222", "Pardip\,\ Odisha",
"9161567", "Gopalganj\,\ Bihar",
"916415", "Bhagalpur\,\ Bihar",
"9174927", "Shivpuri\,\ Madhya\ Pradesh",
"918402", "Kanigiri\,\ Andhra\ Pradesh",
"9171666", "Chaurai\,\ Madhya\ Pradesh",
"912328", "Panhala\,\ Maharashtra",
"9171796", "Nagbhir\,\ Maharashtra",
"912649", "Dediapada\,\ Gujarat",
"912192", "Khopoli\,\ Maharashtra",
"9174318", "Aklera\,\ Rajasthan",
"9181704", "Alur\,\ Karnataka",
"9167482", "Bhubaneshwar\,\ Odisha",
"917295", "Badnawar\,\ Madhya\ Pradesh",
"9171384", "Dhanora\,\ Maharashtra",
"9174695", "Hindaun\,\ Rajasthan",
"9161545", "Siwan\,\ Bihar",
"9162516", "Bagaha\,\ Bihar",
"911704", "Paonta\,\ Himachal\ Pradesh",
"912189", "Mohol\,\ Maharashtra",
"917685", "Nowgaon\,\ Madhya\ Pradesh",
"9173235", "Punasa\,\ Madhya\ Pradesh",
"9171846", "Bhandara\,\ Maharashtra",
"9165325", "Giridih\,\ Bihar",
"9166735", "Jayapatna\,\ Odisha",
"9176507", "Beohari\,\ Madhya\ Pradesh",
"918624", "Gudur\,\ Andhra\ Pradesh",
"915862", "Sitapur\,\ Uttar\ Pradesh",
"91225", "Mumbai",
"9168444", "Kantamal\,\ Odisha",
"918412", "Pargi\,\ Andhra\ Pradesh",
"9173930", "Jobat\,\ Madhya\ Pradesh",
"916514", "Ranchi\,\ Bihar",
"911763", "Sarhind\,\ Punjab",
"912839", "Lakhpat\,\ Gujarat",
"9181930", "Hiriyur\,\ Karnataka",
"912563", "Shirpur\,\ Maharashtra",
"918487", "Shirahatti\,\ Karnataka",
"9166756", "T\.Rampur\,\ Odisha",
"9174969", "Pichhore\,\ Madhya\ Pradesh",
"9176448", "Dindori\,\ Madhya\ Pradesh",
"914545", "Palani\,\ Tamil\ Nadu",
"9168443", "Kantamal\,\ Odisha",
"9171157", "Mouda\,\ Maharashtra",
"918630", "Guntur\,\ Andhra\ Pradesh",
"9165506", "Hunterganj\,\ Bihar",
"9165342", "Jhumaritalaiya\,\ Bihar",
"911493", "Tijara\,\ Rajasthan",
"9174316", "Aklera\,\ Rajasthan",
"915144", "Safipur\,\ Uttar\ Pradesh",
"911284", "Bawal\,\ Haryana",
"91424", "Erode\,\ Tamil\ Nadu",
"9174378", "Nainwa\,\ Rajasthan",
"9176270", "Manpur\,\ Madhya\ Pradesh",
"915168", "Jalaun\,\ Uttar\ Pradesh",
"9176424", "Mandla\,\ Madhya\ Pradesh",
"9171994", "Deori\,\ Maharashtra",
"915180", "Fatehpur\,\ Uttar\ Pradesh",
"9161155", "Danapur\,\ Bihar",
"918945", "Tekkali\/Palasa\,\ Andhra\ Pradesh",
"9167827", "Balasore\,\ Odisha",
"915335", "Soraon\,\ Uttar\ Pradesh",
"9164333", "Jamtara\,\ Bihar",
"9162576", "Barachakia\,\ Bihar",
"912665", "Sankheda\,\ Gujarat",
"918552", "Gooty\/Guntakal\,\ Andhra\ Pradesh",
"9177015", "Pingeshwar\,\ Madhya\ Pradesh",
"9168683", "Nandapur\,\ Odisha",
"913782", "Kalaktung\/Bomdila\,\ Arunachal\ Pradesh",
"9176284", "Karpa\,\ Madhya\ Pradesh",
"9162784", "Dalsinghsarai\,\ Bihar",
"9165885", "Jagarnathpur\,\ Bihar",
"9165605", "Patan\,\ Bihar",
"9174598", "Ramganj\ Mandi\,\ Rajasthan",
"9168684", "Nandapur\,\ Odisha",
"918276", "Somwarpet\,\ Karnataka",
"917516", "Gwalior\,\ Madhya\ Pradesh",
"9176283", "Karpa\,\ Madhya\ Pradesh",
"913223", "Nayagarh\/Kultikri\,\ West\ Bengal",
"9162783", "Dalsinghsarai\,\ Bihar",
"9175918", "Sironj\,\ Madhya\ Pradesh",
"9161866", "Aurangabad\,\ Bihar",
"912670", "Shehra\,\ Gujarat",
"9163237", "Dumraon\,\ Bihar",
"918369", "Hubli\,\ Karnataka",
"9162272", "Mahua\,\ Bihar",
"9174840", "Silwani\,\ Madhya\ Pradesh",
"9167862", "Chandbali\,\ Odisha",
"918376", "Hirekerur\,\ Karnataka",
"917583", "Banda\,\ Madhya\ Pradesh",
"912928", "Shergarh\/Deechu\,\ Rajasthan",
"9171993", "Deori\,\ Maharashtra",
"9176423", "Mandla\,\ Madhya\ Pradesh",
"912747", "Thara\,\ Gujarat",
"9163272", "Rafiganj\,\ Bihar",
"918662", "Vijayawada\,\ Andhra\ Pradesh",
"915824", "Aonla\/Ramnagar\,\ Uttar\ Pradesh",
"9162237", "Motipur\,\ Bihar",
"9164334", "Jamtara\,\ Bihar",
"912555", "Satana\,\ Maharashtra",
"9171565", "Talegaokarangal\,\ Maharashtra",
"9164767", "Madhepura\,\ Bihar",
"912454", "Basmatnagar\,\ Maharashtra",
"9171823", "Gondia\,\ Maharashtra",
"913658", "Williamnagar\,\ Meghalaya",
"9174376", "Nainwa\,\ Rajasthan",
"9168582", "Nowrangapur\,\ Odisha",
"9176364", "Baihar\,\ Madhya\ Pradesh",
"9174660", "Bonli\,\ Rajasthan",
"9167642", "Anugul\,\ Odisha",
"917234", "Digras\,\ Maharashtra",
"918481", "Basavakalyan\,\ Karnataka",
"914576", "Mudukulathur\,\ Tamil\ Nadu",
"9174596", "Ramganj\ Mandi\,\ Rajasthan",
"9166466", "Bargarh\,\ Odisha",
"912733", "Harij\,\ Gujarat",
"9175916", "Sironj\,\ Madhya\ Pradesh",
"913799", "Tuting\,\ Arunachal\ Pradesh",
"9127177", "Sanand\,\ Gujarat",
"912898", "Jamjodhpur\,\ Gujarat",
"911672", "Sangrur\,\ Punjab",
"911533", "Kolayat\/Goddo\,\ Rajasthan",
"914252", "Udumalpet\,\ Tamil\ Nadu",
"9172875", "Gogaon\,\ Madhya\ Pradesh",
"916747", "Bhubaneshwar\,\ Odisha",
"9167625", "Dhenkanal\,\ Odisha",
"914183", "Vandavasi\,\ Tamil\ Nadu",
"912936", "Pali\/Rohat\,\ Rajasthan",
"911379", "Pratapnagar\,\ Uttarakhand",
"917220", "Chhikaldara\,\ Maharashtra",
"917825", "Berla\,\ Madhya\ Pradesh",
"9171824", "Gondia\,\ Maharashtra",
"915640", "Kaman\,\ Rajasthan",
"918134", "Tiptur\,\ Karnataka",
"914637", "Valliyoor\,\ Tamil\ Nadu",
"914116", "Tiruvallur\,\ Tamil\ Nadu",
"9165687", "Balumath\,\ Bihar",
"9176363", "Baihar\,\ Madhya\ Pradesh",
"9168426", "Phulbani\,\ Odisha",
"9173944", "Alirajpur\,\ Madhya\ Pradesh",
"9164532", "Araria\,\ Bihar",
"9161502", "Hathua\,\ Bihar",
"918842", "Kakinada\,\ Andhra\ Pradesh",
"917264", "Chikhali\,\ Maharashtra",
"9168113", "Chhatrapur\,\ Odisha",
"9166224", "Sundargarh\,\ Odisha",
"9162294", "Bidupur\,\ Bihar",
"914373", "Pattukottai\,\ Tamil\ Nadu",
"9176386", "Damoh\,\ Madhya\ Pradesh",
"912763", "Vijapur\,\ Gujarat",
"9176569", "Kannodi\,\ Madhya\ Pradesh",
"9163315", "Imamganj\,\ Bihar",
"915111", "Akbarpur\,\ Uttar\ Pradesh",
"9164577", "Korha\,\ Bihar",
"917364", "Shajapur\,\ Madhya\ Pradesh",
"9171775", "Brahmapuri\,\ Maharashtra",
"9171444", "Atner\,\ Madhya\ Pradesh",
"916635", "Sambalpur\,\ Odisha",
"91135", "Dehradun\,\ Uttarakhand",
"9164255", "Katoria\,\ Bihar",
"9174360", "Hindoli\,\ Rajasthan",
"9166484", "Patnagarh\,\ Odisha",
"9171092", "Kamptee\,\ Maharashtra",
"917203", "Babhulgaon\,\ Maharashtra",
"9174676", "Bamanwas\,\ Rajasthan",
"9176268", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9181723", "Hassan\,\ Karnataka",
"9171972", "Mohadi\,\ Maharashtra",
"918646", "Vinukonda\,\ Andhra\ Pradesh",
"9168157", "Parlakhemundi\,\ Odisha",
"9171443", "Atner\,\ Madhya\ Pradesh",
"912979", "Sanchore\,\ Rajasthan",
"9164236", "Maheshpur\ Raj\,\ Bihar",
"9174859", "Udaipura\,\ Madhya\ Pradesh",
"912845", "Savarkundla\,\ Gujarat",
"9165387", "Torpa\,\ Bihar",
"9166483", "Patnagarh\,\ Odisha",
"9181724", "Hassan\,\ Karnataka",
"911504", "Bhadra\,\ Rajasthan",
"9174907", "Pohari\,\ Madhya\ Pradesh",
"916714", "Cuttack\,\ Odisha",
"911563", "Sardarshahar\/Jaitsisar\,\ Rajasthan",
"9168114", "Chhatrapur\,\ Odisha",
"9173943", "Alirajpur\,\ Madhya\ Pradesh",
"913210", "Kakdwip\,\ West\ Bengal",
"911336", "Deoband\,\ Uttar\ Pradesh",
"9162293", "Bidupur\,\ Bihar",
"912966", "Sagwara\,\ Rajasthan",
"9166223", "Sundargarh\,\ Odisha",
"9167325", "Hindol\,\ Odisha",
"918113", "Channapatna\,\ Karnataka",
"912984", "Barmer\/Sindari\,\ Rajasthan",
"9174515", "Atru\,\ Rajasthan",
"9176388", "Damoh\,\ Madhya\ Pradesh",
"9165222", "Muri\,\ Bihar",
"913805", "Hayuliang\,\ Arunachal\ Pradesh",
"9165305", "Bundu\,\ Bihar",
"9167934", "Betanati\,\ Odisha",
"918836", "Rajahmundri\,\ Andhra\ Pradesh",
"9176527", "Shahdol\,\ Madhya\ Pradesh",
"915265", "Utraula\,\ Uttar\ Pradesh",
"918186", "Kargal\,\ Karnataka",
"9174274", "Bhanpura\,\ Madhya\ Pradesh",
"9174678", "Bamanwas\,\ Rajasthan",
"9176266", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9165482", "Ichak\,\ Bihar",
"9161883", "Rohtas\,\ Bihar",
"9162766", "Madhubani\,\ Bihar",
"9174852", "Udaipura\,\ Madhya\ Pradesh",
"911741", "Pehowa\,\ Haryana",
"9174273", "Bhanpura\,\ Madhya\ Pradesh",
"9168666", "Umerkote\,\ Odisha",
"912714", "Dholka\,\ Gujarat",
"9175290", "Laher\,\ Madhya\ Pradesh",
"918357", "Badami\,\ Karnataka",
"917727", "Balodabazar\,\ Madhya\ Pradesh",
"9161884", "Rohtas\,\ Bihar",
"918632", "Guntur\,\ Andhra\ Pradesh",
"913526", "Islampur\,\ West\ Bengal",
"9165245", "Gumla\,\ Bihar",
"918573", "Bangarupalem\,\ Andhra\ Pradesh",
"913511", "Bubulchandi\,\ West\ Bengal",
"9165267", "Lohardaga\,\ Bihar",
"911342", "Bijnor\,\ Uttar\ Pradesh",
"91761", "Jabalpur\,\ Madhya\ Pradesh",
"918257", "Sullia\,\ Karnataka",
"915270", "Bikapur\,\ Uttar\ Pradesh",
"9176562", "Kannodi\,\ Madhya\ Pradesh",
"915875", "Mohammadi\/Maigalganj\,\ Uttar\ Pradesh",
"915949", "Kichha\/Bazpur\,\ Uttar\ Pradesh",
"918339", "Ainapur\,\ Karnataka",
"9167933", "Betanati\,\ Odisha",
"9181725", "Hassan\,\ Karnataka",
"9166242", "Rajgangpur\,\ Odisha",
"91724", "Akola\,\ Maharashtra",
"918520", "Pattikonda\,\ Andhra\ Pradesh",
"91562", "Agra\,\ Uttar\ Pradesh",
"913824", "Kailsahar\,\ Tripura",
"9174612", "Mahuwa\,\ Rajasthan",
"9164253", "Katoria\,\ Bihar",
"9171773", "Brahmapuri\,\ Maharashtra",
"9163313", "Imamganj\,\ Bihar",
"9165646", "Nagarutari\,\ Bihar",
"9173922", "Jhabua\,\ Madhya\ Pradesh",
"917847", "Antagarh\,\ Madhya\ Pradesh",
"9167324", "Hindol\,\ Odisha",
"915281", "Mahoba\,\ Uttar\ Pradesh",
"91734", "Ujjain\,\ Madhya\ Pradesh",
"911424", "Phulera\/Renwal\,\ Rajasthan",
"9168115", "Chhatrapur\,\ Odisha",
"9171422", "Bhimpur\,\ Madhya\ Pradesh",
"9167323", "Hindol\,\ Odisha",
"913830", "Champai\/Chiapui\,\ Mizoram",
"9166546", "Sonapur\,\ Odisha",
"911883", "Dasua\,\ Punjab",
"918534", "Yelburga\,\ Karnataka",
"918206", "Udupi\,\ Karnataka",
"9166225", "Sundargarh\,\ Odisha",
"9171467", "Ghorandogri\,\ Madhya\ Pradesh",
"9181742", "Arsikere\,\ Karnataka",
"9161807", "Adhaura\,\ Bihar",
"9162295", "Bidupur\,\ Bihar",
"9173945", "Alirajpur\,\ Madhya\ Pradesh",
"911821", "Nakodar\,\ Punjab",
"9164217", "Naugachia\,\ Bihar",
"9171586", "Deoli\,\ Maharashtra",
"9166485", "Patnagarh\,\ Odisha",
"918693", "Thungaturthy\,\ Andhra\ Pradesh",
"9171445", "Atner\,\ Madhya\ Pradesh",
"9171774", "Brahmapuri\,\ Maharashtra",
"9164254", "Katoria\,\ Bihar",
"9173240", "Mhow\,\ Madhya\ Pradesh",
"912446", "Ambejogai\,\ Maharashtra",
"9163314", "Imamganj\,\ Bihar",
"911430", "Phagi\,\ Rajasthan",
"913483", "Murshidabad\/Jiaganj\,\ West\ Bengal",
"9165244", "Gumla\,\ Bihar",
"911806", "Panipat\,\ Haryana",
"918316", "Belgaum\,\ Karnataka",
"9161885", "Rohtas\,\ Bihar",
"918283", "Salkani\,\ Karnataka",
"918152", "Kolar\,\ Karnataka",
"9168402", "Tumudibandha\,\ Odisha",
"9162452", "Gogri\,\ Bihar",
"918221", "Nanjangud\,\ Karnataka",
"917576", "Piparia\,\ Madhya\ Pradesh",
"9167956", "Udala\,\ Odisha",
"918383", "Joida\,\ Karnataka",
"9171362", "Etapalli\,\ Maharashtra",
"9165303", "Bundu\,\ Bihar",
"918216", "Mysore\,\ Karnataka",
"9166407", "Bagdihi\,\ Odisha",
"9163452", "Jamui\,\ Bihar",
"9174513", "Atru\,\ Rajasthan",
"915568", "Deoria\,\ Uttar\ Pradesh",
"9181749", "Arsikere\,\ Karnataka",
"913777", "Yangkiyang\,\ Arunachal\ Pradesh",
"917751", "Pendra\,\ Madhya\ Pradesh",
"917252", "Washim\,\ Maharashtra",
"914320", "Aravakurichi\,\ Tamil\ Nadu",
"917659", "Jaithari\,\ Madhya\ Pradesh",
"9176450", "Karanjia\,\ Madhya\ Pradesh",
"9167935", "Betanati\,\ Odisha",
"918748", "V\.R\.Puram\,\ Andhra\ Pradesh",
"9165304", "Bundu\,\ Bihar",
"911602", "Kharar\,\ Punjab",
"915691", "Chhibramau\,\ Uttar\ Pradesh",
"911958", "Karnah\,\ Jammu\ And\ Kashmir",
"9174514", "Atru\,\ Rajasthan",
"9174970", "Khaniadhana\,\ Madhya\ Pradesh",
"9171327", "Gadchiroli\,\ Maharashtra",
"91376", "Jorhat\,\ Assam",
"918819", "Tanuku\,\ Andhra\ Pradesh",
"917833", "Udaipur\,\ Madhya\ Pradesh",
"9165243", "Gumla\,\ Bihar",
"9165866", "Chainpur\,\ Bihar",
"9173929", "Jhabua\,\ Madhya\ Pradesh",
"912432", "Aurangabad\,\ Maharashtra",
"911991", "Reasi\,\ Jammu\ And\ Kashmir",
"9174275", "Bhanpura\,\ Madhya\ Pradesh",
"9174619", "Mahuwa\,\ Rajasthan",
"9174557", "Digod\/Sultanpur\,\ Rajasthan",
"9165603", "Patan\,\ Bihar",
"9165883", "Jagarnathpur\,\ Bihar",
"917745", "Chhuriakala\,\ Madhya\ Pradesh",
"9171662", "Chaurai\,\ Madhya\ Pradesh",
"91460", "Taliparamba\,\ Kerala",
"912792", "Amreli\,\ Gujarat",
"9168196", "Surada\,\ Odisha",
"918586", "Vayalpad\,\ Andhra\ Pradesh",
"913756", "Sadiya\,\ Assam",
"9167226", "Pardip\,\ Odisha",
"9176442", "Dindori\,\ Madhya\ Pradesh",
"9177013", "Pingeshwar\,\ Madhya\ Pradesh",
"9168685", "Nandapur\,\ Odisha",
"918465", "Yellareddy\,\ Andhra\ Pradesh",
"914364", "Mayiladuthurai\,\ Tamil\ Nadu",
"9164335", "Jamtara\,\ Bihar",
"9167567", "Balugaon\,\ Odisha",
"912774", "Modasa\,\ Gujarat",
"9161153", "Danapur\,\ Bihar",
"9162512", "Bagaha\,\ Bihar",
"912997", "Jaisalmer\/Mohargarh\,\ Rajasthan",
"918513", "Nandikotkur\,\ Andhra\ Pradesh",
"917539", "Gohad\,\ Madhya\ Pradesh",
"9167486", "Bhubaneshwar\,\ Odisha",
"917273", "Kannod\,\ Madhya\ Pradesh",
"9171792", "Nagbhir\,\ Maharashtra",
"912909", "Bhim\/Dawer\,\ Rajasthan",
"9164356", "Pakur\,\ Bihar",
"912462", "Nanded\,\ Maharashtra",
"917863", "Chingamut\,\ Madhya\ Pradesh",
"9161154", "Danapur\,\ Bihar",
"91373", "Dibrugarh\,\ Assam",
"9176425", "Mandla\,\ Madhya\ Pradesh",
"9171995", "Deori\,\ Maharashtra",
"9177057", "Kurud\,\ Madhya\ Pradesh",
"911574", "Neem\ Ka\ Thana\,\ Rajasthan",
"9167522", "Puri\,\ Odisha",
"914892", "Minicoy\,\ Lakshadweep",
"9174319", "Aklera\,\ Rajasthan",
"9161526", "Chapra\,\ Bihar",
"9165884", "Jagarnathpur\,\ Bihar",
"9161117", "Hilsa\,\ Bihar",
"9165604", "Patan\,\ Bihar",
"918470", "Afzalpur\,\ Karnataka",
"9162785", "Dalsinghsarai\,\ Bihar",
"912141", "Alibagh\,\ Maharashtra",
"9171627", "Chhindwara\,\ Madhya\ Pradesh",
"9176285", "Karpa\,\ Madhya\ Pradesh",
"911592", "Jhunjhunu\,\ Rajasthan",
"917804", "Kusmi\,\ Madhya\ Pradesh",
"9176510", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9177014", "Pingeshwar\,\ Madhya\ Pradesh",
"9174966", "Pichhore\,\ Madhya\ Pradesh",
"912358", "Dapoli\,\ Maharashtra",
"912623", "Mandvi\,\ Gujarat",
"9167624", "Dhenkanal\,\ Odisha",
"9166752", "T\.Rampur\,\ Odisha",
"915744", "Kasganj\,\ Uttar\ Pradesh",
"911589", "Parbatsar\,\ Rajasthan",
"9181750", "Holenarasipur\,\ Karnataka",
"9172874", "Gogaon\,\ Madhya\ Pradesh",
"912827", "Kotdasanghani\,\ Gujarat",
"9174312", "Aklera\,\ Rajasthan",
"911475", "Begun\/Rawatbhata\,\ Rajasthan",
"9171825", "Gondia\,\ Maharashtra",
"9172880", "Bhikangaon\,\ Madhya\ Pradesh",
"91222", "Mumbai",
"918654", "Jaggayyapet\,\ Andhra\ Pradesh",
"9165346", "Jhumaritalaiya\,\ Bihar",
"9171563", "Talegaokarangal\,\ Maharashtra",
"9165502", "Hunterganj\,\ Bihar",
"9176365", "Baihar\,\ Madhya\ Pradesh",
"915171", "Garauth\,\ Uttar\ Pradesh",
"918503", "Makthal\,\ Andhra\ Pradesh",
"911488", "Kotri\,\ Rajasthan",
"911460", "Kishangarhbas\/Khairthal\,\ Rajasthan",
"9175937", "Kurwai\,\ Madhya\ Pradesh",
"9168607", "Boriguma\,\ Odisha",
"9171564", "Talegaokarangal\,\ Maharashtra",
"918564", "Proddatur\,\ Andhra\ Pradesh",
"91461", "Thoothukudi\,\ Tamil\ Nadu",
"9176449", "Dindori\,\ Madhya\ Pradesh",
"9167623", "Dhenkanal\,\ Odisha",
"913860", "Wokha\,\ Nagaland",
"9174968", "Pichhore\,\ Madhya\ Pradesh",
"9172873", "Gogaon\,\ Madhya\ Pradesh",
"914286", "Namakkal\,\ Tamil\ Nadu",
"9171842", "Bhandara\,\ Maharashtra",
"914922", "Alathur\,\ Kerala",
"913015", "Jaisalmer\/Myajlar\,\ Rajasthan",
"9176347", "Lamta\,\ Madhya\ Pradesh",
"9174599", "Ramganj\ Mandi\,\ Rajasthan",
"915451", "Mariyahu\,\ Uttar\ Pradesh",
"9162276", "Mahua\,\ Bihar",
"9161862", "Aurangabad\,\ Bihar",
"9165463", "Hazaribagh\,\ Bihar",
"9176570", "Jaitpur\,\ Madhya\ Pradesh",
"9177074", "Bagbahera\,\ Madhya\ Pradesh",
"918548", "Shadnagar\,\ Andhra\ Pradesh",
"9165935", "Manoharpur\,\ Bihar",
"912147", "Shrivardhan\,\ Maharashtra",
"912806", "Gogodar\,\ Gujarat",
"9163276", "Rafiganj\,\ Bihar",
"915498", "Ballia\,\ Uttar\ Pradesh",
"916612", "Rourkela\,\ Odisha",
"9171385", "Dhanora\,\ Maharashtra",
"9174694", "Hindaun\,\ Rajasthan",
"9161544", "Siwan\,\ Bihar",
"9181705", "Alur\,\ Karnataka",
"917661", "Teonthar\,\ Madhya\ Pradesh",
"918522", "Peapalle\,\ Andhra\ Pradesh",
"9174379", "Nainwa\,\ Rajasthan",
"9167866", "Chandbali\,\ Odisha",
"9167243", "Jagatsinghpur\,\ Odisha",
"9162572", "Barachakia\,\ Bihar",
"917769", "Bagicha\,\ Madhya\ Pradesh",
"9161543", "Siwan\,\ Bihar",
"9174693", "Hindaun\,\ Rajasthan",
"911432", "Tonk\,\ Rajasthan",
"913253", "Manbazar\,\ West\ Bengal",
"9167244", "Jagatsinghpur\,\ Odisha",
"912991", "Jaisalmer\/Ramgarh\,\ Rajasthan",
"912525", "Palghar\,\ Maharashtra",
"9162537", "Narkatiaganj\,\ Bihar",
"915854", "Sandila\,\ Uttar\ Pradesh",
"9165464", "Hazaribagh\,\ Bihar",
"91479", "Mavelikkara\,\ Kerala",
"9175919", "Sironj\,\ Madhya\ Pradesh",
"9177073", "Bagbahera\,\ Madhya\ Pradesh",
"912958", "Kotra\,\ Rajasthan",
"9161827", "Arrah\,\ Bihar",
"917776", "Premnagar\,\ Madhya\ Pradesh",
"916806", "Berhampur\,\ Odisha",
"9166733", "Jayapatna\,\ Odisha",
"912424", "Akole\,\ Maharashtra",
"9175912", "Sironj\,\ Madhya\ Pradesh",
"918734", "Nirmal\,\ Andhra\ Pradesh",
"9166427", "Kuchinda\,\ Odisha",
"9165323", "Giridih\,\ Bihar",
"918150", "Bagepalli\,\ Karnataka",
"9168422", "Phulbani\,\ Odisha",
"9173233", "Punasa\,\ Madhya\ Pradesh",
"9163497", "Jhajha\,\ Bihar",
"9168586", "Nowrangapur\,\ Odisha",
"9167646", "Anugul\,\ Odisha",
"9173234", "Punasa\,\ Madhya\ Pradesh",
"9174372", "Nainwa\,\ Rajasthan",
"918615", "Nellore\,\ Andhra\ Pradesh",
"9168467", "Baliguda\,\ Odisha",
"914348", "Palakkodu\,\ Tamil\ Nadu",
"918720", "Mahadevapur\,\ Andhra\ Pradesh",
"912430", "Sillod\,\ Maharashtra",
"912133", "Manchar\,\ Maharashtra",
"914151", "Kallakurichi\,\ Tamil\ Nadu",
"9166462", "Bargarh\,\ Odisha",
"9168445", "Kantamal\,\ Odisha",
"9174337", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"912821", "Jasdan\,\ Gujarat",
"914322", "Pudukkottai\,\ Tamil\ Nadu",
"917855", "Chingmut\,\ Madhya\ Pradesh",
"9166734", "Jayapatna\,\ Odisha",
"9174592", "Ramganj\ Mandi\,\ Rajasthan",
"9165324", "Giridih\,\ Bihar",
"9176269", "Vijayraghogarh\,\ Madhya\ Pradesh",
"912475", "Omerga\,\ Maharashtra",
"9162594", "Pakridayal\,\ Bihar",
"918703", "Warangal\,\ Andhra\ Pradesh",
"9166524", "Balangir\,\ Odisha",
"915923", "Sambhal\,\ Uttar\ Pradesh",
"9161325", "Barh\,\ Bihar",
"9163374", "Arwal\,\ Bihar",
"9175263", "Ghatigaon\,\ Madhya\ Pradesh",
"9164232", "Maheshpur\ Raj\,\ Bihar",
"91122", "Hapur\,\ Uttar\ Pradesh",
"9171976", "Mohadi\,\ Maharashtra",
"9171714", "Gond\ Pipri\,\ Maharashtra",
"9176568", "Kannodi\,\ Madhya\ Pradesh",
"9168563", "Rayagada\,\ Odisha",
"91794", "Ahmedabad\ Local\,\ Gujarat",
"917444", "Ladpura\/Kota\,\ Rajasthan",
"9164555", "Forbesganj\,\ Bihar",
"9189467", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"912589", "Chalisgaon\,\ Maharashtra",
"9165623", "Daltonganj\,\ Bihar",
"915212", "Malihabad\,\ Uttar\ Pradesh",
"91132", "Saharanpur\,\ Uttar\ Pradesh",
"9171757", "Bhadrawati\,\ Maharashtra",
"9164277", "Kathikund\,\ Bihar",
"911681", "Jind\,\ Haryana",
"9171607", "Jamai\,\ Madhya\ Pradesh",
"9168564", "Rayagada\,\ Odisha",
"9174637", "Gangapur\,\ Rajasthan",
"911590", "Merta\,\ Rajasthan",
"9176382", "Damoh\,\ Madhya\ Pradesh",
"915544", "Naugarh\/Tetribazar\,\ Uttar\ Pradesh",
"917841", "Sarona\,\ Madhya\ Pradesh",
"9161506", "Hathua\,\ Bihar",
"916574", "Jamshedpur\,\ Bihar",
"9164536", "Araria\,\ Bihar",
"9165624", "Daltonganj\,\ Bihar",
"9168175", "R\.Udayigiri\,\ Odisha",
"918472", "Gulbarga\,\ Karnataka",
"9166847", "Paikamal\,\ Odisha",
"9174672", "Bamanwas\,\ Rajasthan",
"9176405", "Shahpur\,\ Madhya\ Pradesh",
"914295", "Sathiyamangalam\,\ Tamil\ Nadu",
"914890", "Bitra\,\ Lakshadweep",
"914145", "Gingee\,\ Tamil\ Nadu",
"9171096", "Kamptee\,\ Maharashtra",
"9166523", "Balangir\,\ Odisha",
"9162593", "Pakridayal\,\ Bihar",
"9174858", "Udaipura\,\ Madhya\ Pradesh",
"9175264", "Ghatigaon\,\ Madhya\ Pradesh",
"912163", "Koregaon\,\ Maharashtra",
"912460", "Delhi\ Tanda\,\ Maharashtra",
"9163373", "Arwal\,\ Bihar",
"912488", "Parner\,\ Maharashtra",
"9171713", "Gond\ Pipri\,\ Maharashtra",
"918494", "Kadiri\,\ Andhra\ Pradesh",
"9171685", "Harrai\,\ Madhya\ Pradesh",
"918916", "Visakhapatnam\,\ Andhra\ Pradesh",
"9171805", "Salekasa\,\ Maharashtra",
"913666", "Barpeta\ Road\,\ Assam",
"91353", "Siliguri\,\ West\ Bengal",
"9162433", "Begusarai\,\ Bihar",
"911997", "Bedarwah\,\ Jammu\ And\ Kashmir",
"9174679", "Bamanwas\,\ Rajasthan",
"9174215", "Manasa\,\ Madhya\ Pradesh",
"9166797", "Komana\,\ Odisha",
"9162727", "Darbhanga\,\ Bihar",
"9168662", "Umerkote\,\ Odisha",
"9174580", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9174147", "Jaora\,\ Madhya\ Pradesh",
"9176487", "Mawai\,\ Madhya\ Pradesh",
"9175383", "Ambah\,\ Madhya\ Pradesh",
"917127", "Nagpur\,\ Maharashtra",
"9187597", "Outsarangapalle\,\ Andhra\ Pradesh",
"9173297", "Khakner\,\ Madhya\ Pradesh",
"912114", "Lonavala\,\ Maharashtra",
"911792", "Solan\,\ Himachal\ Pradesh",
"9176389", "Damoh\,\ Madhya\ Pradesh",
"9176566", "Kannodi\,\ Madhya\ Pradesh",
"9174910", "Narwar\,\ Madhya\ Pradesh",
"9174574", "Mangrol\,\ Rajasthan",
"9167604", "Talcher\,\ Odisha",
"9167884", "Soro\,\ Odisha",
"915445", "Robertsganj\/Obra\,\ Uttar\ Pradesh",
"9175384", "Ambah\,\ Madhya\ Pradesh",
"9165545", "Rajdhanwar\,\ Bihar",
"9165226", "Muri\,\ Bihar",
"918786", "Karimnagar\,\ Andhra\ Pradesh",
"915738", "Khurja\,\ Uttar\ Pradesh",
"917757", "Shakti\,\ Madhya\ Pradesh",
"912592", "Kalwan\,\ Maharashtra",
"918327", "Goa",
"913771", "Mariani\,\ Assam",
"917545", "Arone\,\ Madhya\ Pradesh",
"9167883", "Soro\,\ Odisha",
"913862", "Dimapur\,\ Nagaland",
"9167603", "Talcher\,\ Odisha",
"9174573", "Mangrol\,\ Rajasthan",
"911462", "Beawar\,\ Rajasthan",
"9174856", "Udaipura\,\ Madhya\ Pradesh",
"911909", "Udaipur\,\ Himachal\ Pradesh",
"9165486", "Ichak\,\ Bihar",
"918713", "Parkal\,\ Andhra\ Pradesh",
"9168627", "Gudari\,\ Odisha",
"9162762", "Madhubani\,\ Bihar",
"9162434", "Begusarai\,\ Bihar",
"917608", "Bijawar\,\ Madhya\ Pradesh",
"9176262", "Vijayraghogarh\,\ Madhya\ Pradesh",
"918227", "T\.Narsipur\,\ Karnataka",
"9165567", "Tisri\,\ Bihar",
"911258", "Kalanaur\,\ Haryana",
"9166716", "Rajkhariar\,\ Odisha",
"916804", "Berhampur\,\ Odisha",
"9163495", "Jhajha\,\ Bihar",
"912950", "Dhariawad\,\ Rajasthan",
"9171526", "Wardha\,\ Maharashtra",
"912426", "Rahuri\,\ Maharashtra",
"918736", "Mancherial\,\ Andhra\ Pradesh",
"9166425", "Kuchinda\,\ Odisha",
"9176503", "Beohari\,\ Madhya\ Pradesh",
"9174356", "Gangdhar\,\ Rajasthan",
"917789", "Bhairongarh\,\ Madhya\ Pradesh",
"9171154", "Mouda\,\ Maharashtra",
"9173216", "Sanwer\,\ Madhya\ Pradesh",
"9167666", "Keonjhar\,\ Odisha",
"9176504", "Beohari\,\ Madhya\ Pradesh",
"9177000", "Nagri\,\ Madhya\ Pradesh",
"9168447", "Kantamal\,\ Odisha",
"917623", "Kundam\,\ Madhya\ Pradesh",
"9174335", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"91194", "Srinagar\,\ Jammu\ And\ Kashmir",
"914635", "Nanguneri\,\ Tamil\ Nadu",
"9171153", "Mouda\,\ Maharashtra",
"913844", "Hailakandi\,\ Assam",
"918540", "Nagarkurnool\,\ Andhra\ Pradesh",
"9166442", "Rairakhol\,\ Odisha",
"9168465", "Baliguda\,\ Odisha",
"918933", "Bheemunipatnam\,\ Andhra\ Pradesh",
"915343", "Patti\,\ Uttar\ Pradesh",
"916745", "Bhubaneshwar\,\ Odisha",
"9171482", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"912667", "Savli\,\ Gujarat",
"917391", "Petlawad\,\ Madhya\ Pradesh",
"9165972", "Saraikela\/Adstyapur\,\ Bihar",
"9161842", "Sasaram\,\ Bihar",
"9181707", "Alur\,\ Karnataka",
"918742", "Khammam\,\ Andhra\ Pradesh",
"917258", "Akot\,\ Maharashtra",
"9165443", "Gomia\,\ Bihar",
"9171387", "Dhanora\,\ Maharashtra",
"911952", "Baramulla\,\ Jammu\ And\ Kashmir",
"9174358", "Gangdhar\,\ Rajasthan",
"912804", "Kutiyana\,\ Gujarat",
"917291", "Manawar\,\ Madhya\ Pradesh",
"912438", "Soyegaon\,\ Maharashtra",
"9165937", "Manoharpur\,\ Bihar",
"918728", "Peddapalli\,\ Andhra\ Pradesh",
"9173218", "Sanwer\,\ Madhya\ Pradesh",
"9176250", "Umariapan\,\ Madhya\ Pradesh",
"9161564", "Gopalganj\,\ Bihar",
"9174924", "Shivpuri\,\ Madhya\ Pradesh",
"918947", "Sompeta\,\ Andhra\ Pradesh",
"9167846", "Bhadrak\,\ Odisha",
"9162556", "Raxaul\,\ Bihar",
"9168506", "Kalimela\,\ Odisha",
"9167263", "Jajapur\ Road\,\ Odisha",
"9171053", "Narkhed\,\ Maharashtra",
"9161825", "Arrah\,\ Bihar",
"9161563", "Gopalganj\,\ Bihar",
"912373", "Mahaswad\,\ Maharashtra",
"9164312", "Jharmundi\,\ Bihar",
"9174923", "Shivpuri\,\ Madhya\ Pradesh",
"917792", "Narsinghpur\,\ Madhya\ Pradesh",
"9171054", "Narkhed\,\ Maharashtra",
"9167264", "Jajapur\ Road\,\ Odisha",
"912557", "Dindori\,\ Maharashtra",
"9162535", "Narkatiaganj\,\ Bihar",
"9163252", "Pakribarwan\,\ Bihar",
"918158", "Sidlaghatta\,\ Karnataka",
"9165444", "Gomia\,\ Bihar",
"913715", "Gohpur\,\ Assam",
"918191", "Holalkere\,\ Karnataka",
"917774", "Ambikapur\,\ Madhya\ Pradesh",
"918914", "Visakhapatnam\,\ Andhra\ Pradesh",
"9174254", "Garoth\,\ Madhya\ Pradesh",
"914936", "Kalpetta\,\ Kerala",
"912183", "Madha\,\ Maharashtra",
"912468", "Hadgaon\,\ Maharashtra",
"9174658", "Sapotra\,\ Rajasthan",
"913664", "Hajo\,\ Assam",
"9187595", "Outsarangapalle\,\ Andhra\ Pradesh",
"914898", "Kiltan\,\ Lakshadweep",
"9173295", "Khakner\,\ Madhya\ Pradesh",
"9168642", "Mathili\,\ Odisha",
"9176485", "Mawai\,\ Madhya\ Pradesh",
"9174872", "Begamganj\,\ Madhya\ Pradesh",
"9167582", "Nimapara\,\ Odisha",
"9163416", "Seikhpura\,\ Bihar",
"9174145", "Jaora\,\ Madhya\ Pradesh",
"9166795", "Komana\,\ Odisha",
"9162725", "Darbhanga\,\ Bihar",
"9165824", "Chaibasa\,\ Bihar",
"9174217", "Manasa\,\ Madhya\ Pradesh",
"912637", "Navsari\,\ Gujarat",
"9161586", "Sonepur\,\ Bihar",
"913807", "Miao\,\ Arunachal\ Pradesh",
"912352", "Ratnagiri\,\ Maharashtra",
"912833", "Khambhalia\,\ Gujarat",
"9167912", "Bangiriposi\,\ Odisha",
"9176302", "Katangi\,\ Madhya\ Pradesh",
"9133", "Kolkata\,\ West\ Bengal",
"9171687", "Harrai\,\ Madhya\ Pradesh",
"9171807", "Salekasa\,\ Maharashtra",
"9165565", "Tisri\,\ Bihar",
"918784", "Karimnagar\,\ Andhra\ Pradesh",
"912569", "Navapur\,\ Maharashtra",
"918255", "Bantwal\,\ Karnataka",
"9165823", "Chaibasa\,\ Bihar",
"9168625", "Gudari\,\ Odisha",
"915673", "Bhogaon\,\ Uttar\ Pradesh",
"9167286", "Jajapur\ Town\,\ Odisha",
"91495", "Kozhikode\,\ Kerala",
"9174253", "Garoth\,\ Madhya\ Pradesh",
"918355", "Bableshwar\,\ Karnataka",
"912751", "Chotila\,\ Gujarat",
"9174122", "Ratlam\,\ Madhya\ Pradesh",
"917725", "Saraipali\,\ Madhya\ Pradesh",
"914733", "Pathanamthitta\,\ Kerala",
"9162742", "Samastipur\,\ Bihar",
"915961", "Munsiari\,\ Uttar\ Pradesh",
"9165547", "Rajdhanwar\,\ Bihar",
"9174708", "Bundi\,\ Rajasthan",
"9164612", "Raniganj\,\ Bihar",
"911499", "Sangaria\,\ Rajasthan",
"911250", "Charkhidadri\,\ Haryana",
"9176249", "Sihora\,\ Madhya\ Pradesh",
"916637", "Sambalpur\,\ Odisha",
"9171755", "Bhadrawati\,\ Maharashtra",
"9164275", "Kathikund\,\ Bihar",
"9189465", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9164557", "Forbesganj\,\ Bihar",
"918779", "Tirupathi\,\ Andhra\ Pradesh",
"9165406", "Govindpur\,\ Bihar",
"911482", "Bhilwara\,\ Rajasthan",
"9174656", "Sapotra\,\ Rajasthan",
"9174129", "Ratlam\,\ Madhya\ Pradesh",
"9167683", "Parajang\,\ Odisha",
"9168543", "Jeypore\,\ Odisha",
"9164514", "Barsoi\,\ Bihar",
"9166822", "Attabira\,\ Odisha",
"9161327", "Barh\,\ Bihar",
"917446", "Ladpura\/Kota\,\ Rajasthan",
"9164513", "Barsoi\,\ Bihar",
"9168544", "Jeypore\,\ Odisha",
"9167684", "Parajang\,\ Odisha",
"915546", "Harraiya\,\ Uttar\ Pradesh",
"9176309", "Katangi\,\ Madhya\ Pradesh",
"916576", "Jamshedpur\,\ Bihar",
"918963", "Parvathipuram\,\ Andhra\ Pradesh",
"91224", "Mumbai",
"9176407", "Shahpur\,\ Madhya\ Pradesh",
"9166845", "Paikamal\,\ Odisha",
"9174500", "Sangod\,\ Rajasthan",
"9168177", "R\.Udayigiri\,\ Odisha",
"9174706", "Bundi\,\ Rajasthan",
"912643", "Valia\,\ Gujarat",
"9171736", "Rajura\,\ Maharashtra",
"9174879", "Begamganj\,\ Madhya\ Pradesh",
"912847", "Gadhada\,\ Gujarat",
"918671", "Divi\/Challapalli\,\ Andhra\ Pradesh",
"915724", "Khair\,\ Uttar\ Pradesh",
"918496", "Uravakonda\,\ Andhra\ Pradesh",
"9174635", "Gangapur\,\ Rajasthan",
"9171605", "Jamai\,\ Madhya\ Pradesh",
"911438", "Newai\,\ Rajasthan",
"913463", "Bolpur\,\ West\ Bengal",
"9165264", "Lohardaga\,\ Bihar",
"912757", "Dasada\,\ Gujarat",
"911804", "Panipat\,\ Haryana",
"918314", "Belgaum\,\ Karnataka",
"9164672", "Banmankhi\,\ Bihar",
"9166405", "Bagdihi\,\ Odisha",
"915967", "Dharchula\,\ Uttar\ Pradesh",
"9176523", "Shahdol\,\ Madhya\ Pradesh",
"914563", "Rajapalayam\,\ Tamil\ Nadu",
"917574", "Hoshangabad\,\ Madhya\ Pradesh",
"9174536", "Baran\,\ Rajasthan",
"915871", "Nighasan\/Palia\ Kalan\,\ Uttar\ Pradesh",
"911667", "Fatehabad\,\ Haryana",
"9171342", "Bhamregadh\,\ Maharashtra",
"9175228", "Datia\,\ Madhya\ Pradesh",
"918214", "Mysore\,\ Karnataka",
"9161887", "Rohtas\,\ Bihar",
"9182202", "Gundlupet\,\ Karnataka",
"9181769", "Cannarayapatna\,\ Karnataka",
"912952", "Rajsamand\/Kankorli\,\ Rajasthan",
"913838", "Aizwal\/Serchip\,\ Mizoram",
"912739", "Vadgam\,\ Gujarat",
"912631", "Ahwa\,\ Gujarat",
"9174555", "Digod\/Sultanpur\,\ Rajasthan",
"9174711", "Bundi\,\ Rajasthan",
"9174277", "Bhanpura\,\ Madhya\ Pradesh",
"911539", "Tibbi\,\ Rajasthan",
"913793", "Mechuka\,\ Arunachal\ Pradesh",
"9163476", "Chakai\,\ Bihar",
"91435", "Kumbakonam\,\ Tamil\ Nadu",
"918542", "Mahabubnagar\,\ Andhra\ Pradesh",
"915261", "Tarabganj\/Colonelganj\,\ Uttar\ Pradesh",
"9167972", "Jashipur\,\ Odisha",
"913801", "Anini\,\ Arunachal\ Pradesh",
"9171325", "Gadchiroli\,\ Maharashtra",
"9165263", "Lohardaga\,\ Bihar",
"9174232", "Neemuch\,\ Madhya\ Pradesh",
"9165846", "Bishrampur\,\ Bihar",
"9162476", "Singhwara\,\ Bihar",
"911373", "Purola\,\ Uttarakhand",
"9174812", "Gairatganj\,\ Madhya\ Pradesh",
"915361", "Musafirkhana\,\ Uttar\ Pradesh",
"911745", "Nilokheri\,\ Haryana",
"9167937", "Betanati\,\ Odisha",
"9176524", "Shahdol\,\ Madhya\ Pradesh",
"9174904", "Pohari\,\ Madhya\ Pradesh",
"9174819", "Gairatganj\,\ Madhya\ Pradesh",
"9166262", "Banaigarh\,\ Odisha",
"9168117", "Chhatrapur\,\ Odisha",
"913826", "Ambasa\,\ Tripura",
"9168526", "Koraput\,\ Odisha",
"9174239", "Neemuch\,\ Madhya\ Pradesh",
"9165666", "Japla\,\ Bihar",
"918677", "Kaikaluru\,\ Andhra\ Pradesh",
"912841", "Vallabhipur\,\ Gujarat",
"914342", "Dharmapuri\,\ Tamil\ Nadu",
"914174", "Vaniyambadi\,\ Tamil\ Nadu",
"9168154", "Parlakhemundi\,\ Odisha",
"9164573", "Korha\,\ Bihar",
"911426", "Jamwa\ Ramgarh\/Achrol\,\ Rajasthan",
"9174538", "Baran\,\ Rajasthan",
"9165384", "Torpa\,\ Bihar",
"9175226", "Datia\,\ Madhya\ Pradesh",
"918740", "Aswaraopet\,\ Andhra\ Pradesh",
"9181727", "Hassan\,\ Karnataka",
"914328", "Perambalur\,\ Tamil\ Nadu",
"913229", "Dantan\,\ West\ Bengal",
"918536", "Kustagi\,\ Karnataka",
"9168153", "Parlakhemundi\,\ Odisha",
"9164574", "Korha\,\ Bihar",
"918204", "Udupi\,\ Karnataka",
"9168222", "Aska\,\ Odisha",
"9171447", "Atner\,\ Madhya\ Pradesh",
"9181762", "Cannarayapatna\,\ Karnataka",
"9166487", "Patnagarh\,\ Odisha",
"9165383", "Torpa\,\ Bihar",
"916127", "Patna\,\ Bihar",
"917475", "Bundi\,\ Rajasthan",
"918363", "Hubli\,\ Karnataka",
"9174903", "Pohari\,\ Madhya\ Pradesh",
"9164215", "Naugachia\,\ Bihar",
"9164786", "Saharsa\,\ Bihar",
"9173947", "Alirajpur\,\ Madhya\ Pradesh",
"917790", "Babaichichli\,\ Madhya\ Pradesh",
"9168482", "Kotagarh\,\ Odisha",
"915115", "Ghatampur\,\ Uttar\ Pradesh",
"918304", "Kundgol\,\ Karnataka",
"9171465", "Ghorandogri\,\ Madhya\ Pradesh",
"9166227", "Sundargarh\,\ Odisha",
"918263", "Mudigere\,\ Karnataka",
"9161805", "Adhaura\,\ Bihar",
"9162297", "Bidupur\,\ Bihar",
"91294", "Udaipur\ Girwa\/Udaipur\,\ Rajasthan",
"912444", "Patoda\,\ Maharashtra",
"9164763", "Madhepura\,\ Bihar",
"912350", "Madangad\,\ Maharashtra",
"9175956", "Nateran\,\ Madhya\ Pradesh",
"9176322", "Balaghat\,\ Madhya\ Pradesh",
"9171827", "Gondia\,\ Maharashtra",
"918119", "Doddaballapur\,\ Karnataka",
"917816", "Pali\,\ Madhya\ Pradesh",
"918478", "Kamalapur\,\ Karnataka",
"9165684", "Balumath\,\ Bihar",
"9177038", "Manpur\,\ Madhya\ Pradesh",
"917821", "Dhamda\,\ Madhya\ Pradesh",
"915524", "Pharenda\/Anand\ Nagar\,\ Uttar\ Pradesh",
"9127174", "Sanand\,\ Gujarat",
"917687", "Laundi\,\ Madhya\ Pradesh",
"918656", "Nuzvidu\,\ Andhra\ Pradesh",
"9165366", "Palkot\,\ Bihar",
"912482", "Jalna\,\ Maharashtra",
"9176345", "Lamta\,\ Madhya\ Pradesh",
"9127173", "Sanand\,\ Gujarat",
"9167406", "Bhubaneshwar\,\ Odisha",
"91792", "Ahmedabad\ Local\,\ Gujarat",
"918579", "Palmaneru\,\ Andhra\ Pradesh",
"9171132", "Saoner\,\ Maharashtra",
"918485", "Aurad\,\ Karnataka",
"9168605", "Boriguma\,\ Odisha",
"9164764", "Madhepura\,\ Bihar",
"918566", "Koduru\,\ Andhra\ Pradesh",
"9175935", "Kurwai\,\ Madhya\ Pradesh",
"9176469", "Nainpur\,\ Madhya\ Pradesh",
"9166776", "Narlaroad\,\ Odisha",
"9174948", "Kolaras\,\ Madhya\ Pradesh",
"918333", "Hukkeri\/Sankeshwar\,\ Karnataka",
"91124", "Gurgaon\,\ Haryana",
"9171862", "Sakoli\,\ Maharashtra",
"915943", "Khatima\,\ Uttar\ Pradesh",
"9176367", "Baihar\,\ Madhya\ Pradesh",
"918852", "Peddapuram\,\ Andhra\ Pradesh",
"9165683", "Balumath\,\ Bihar",
"914266", "Kotagiri\,\ Tamil\ Nadu",
"9165286", "Khunti\,\ Bihar",
"9164592", "Thakurganj\,\ Bihar",
"9171642", "Pandhurna\,\ Madhya\ Pradesh",
"915732", "Bulandshahr\,\ Uttar\ Pradesh",
"911637", "Malaut\,\ Punjab",
"9177036", "Manpur\,\ Madhya\ Pradesh",
"9167823", "Balasore\,\ Odisha",
"913880", "Sadarhills\/Kangpokai\,\ Manipur",
"918584", "Piler\,\ Andhra\ Pradesh",
"913754", "Moranhat\,\ Assam",
"9167565", "Balugaon\,\ Odisha",
"9175958", "Nateran\,\ Madhya\ Pradesh",
"9176462", "Nainpur\,\ Madhya\ Pradesh",
"918247", "Mangalore\,\ Karnataka",
"9164337", "Jamtara\,\ Bihar",
"912598", "Umrane\,\ Maharashtra",
"9162234", "Motipur\,\ Bihar",
"9168687", "Nandapur\,\ Odisha",
"914366", "Tiruvarur\,\ Tamil\ Nadu",
"9165426", "Bokaro\,\ Bihar",
"911468", "Ramgarh\,\ Rajasthan",
"911480", "Asind\,\ Rajasthan",
"911659", "Sardulgarh\,\ Punjab",
"911252", "Loharu\,\ Haryana",
"917525", "Bhitarwar\,\ Madhya\ Pradesh",
"912551", "Sinnar\,\ Maharashtra",
"9163234", "Dumraon\,\ Bihar",
"9164372", "Mahagama\,\ Bihar",
"9171032", "Butibori\,\ Maharashtra",
"912973", "Jalore\,\ Rajasthan",
"9165582", "Dumri\(Isribazar\)\,\ Bihar",
"9164296", "Kahalgaon\,\ Bihar",
"917297", "Kukshi\,\ Madhya\ Pradesh",
"914869", "Peermedu\,\ Kerala",
"9176287", "Karpa\,\ Madhya\ Pradesh",
"9171625", "Chhindwara\,\ Madhya\ Pradesh",
"9174520", "Chhabra\,\ Rajasthan",
"911576", "Dantaramgarh\/Shyamji\,\ Rajasthan",
"9162787", "Dalsinghsarai\,\ Bihar",
"9161115", "Hilsa\,\ Bihar",
"918941", "Palakonda\/Rajam\,\ Andhra\ Pradesh",
"9163233", "Dumraon\,\ Bihar",
"915331", "Bharwari\,\ Uttar\ Pradesh",
"9165912", "Chandil\,\ Bihar",
"916417", "Bhagalpur\,\ Bihar",
"911569", "Sujangarh\/Lalgarh\,\ Rajasthan",
"9176427", "Mandla\,\ Madhya\ Pradesh",
"912661", "Naswadi\,\ Gujarat",
"9171997", "Deori\,\ Maharashtra",
"9177055", "Kurud\,\ Madhya\ Pradesh",
"917806", "Chitrangi\,\ Madhya\ Pradesh",
"9167824", "Balasore\,\ Odisha",
"9162233", "Motipur\,\ Bihar",
"9174946", "Kolaras\,\ Madhya\ Pradesh",
"9176329", "Balaghat\,\ Madhya\ Pradesh",
"911428", "Dudu\,\ Rajasthan",
"9165364", "Palkot\,\ Bihar",
"918457", "Siddipet\,\ Andhra\ Pradesh",
"914326", "Musiri\,\ Tamil\ Nadu",
"9175917", "Sironj\,\ Madhya\ Pradesh",
"918501", "Kollapur\,\ Andhra\ Pradesh",
"9127176", "Sanand\,\ Gujarat",
"9166422", "Kuchinda\,\ Odisha",
"917565", "Berasia\,\ Madhya\ Pradesh",
"913842", "Silchar\,\ Assam",
"9167403", "Bhubaneshwar\,\ Odisha",
"9165686", "Balumath\,\ Bihar",
"914982", "Taliparamba\,\ Kerala",
"9168427", "Phulbani\,\ Odisha",
"9163492", "Jhajha\,\ Bihar",
"9166773", "Narlaroad\,\ Odisha",
"9175954", "Nateran\,\ Madhya\ Pradesh",
"912621", "Sayan\,\ Gujarat",
"9171485", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"917655", "Birsinghpur\,\ Madhya\ Pradesh",
"9176490", "Kakaiya\,\ Madhya\ Pradesh",
"918310", "Belgaum\,\ Karnataka",
"9174377", "Nainwa\,\ Rajasthan",
"911529", "Lunkaransar\/Kanholi\,\ Rajasthan",
"9164766", "Madhepura\,\ Bihar",
"9168462", "Baliguda\,\ Odisha",
"9175953", "Nateran\,\ Madhya\ Pradesh",
"9166774", "Narlaroad\,\ Odisha",
"9166445", "Rairakhol\,\ Odisha",
"918210", "Mysore\,\ Karnataka",
"9166467", "Bargarh\,\ Odisha",
"9165363", "Palkot\,\ Bihar",
"9174332", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"914829", "Vaikom\,\ Kerala",
"917570", "Seonimalwa\,\ Madhya\ Pradesh",
"912137", "Nahavara\,\ Maharashtra",
"918538", "Manvi\,\ Karnataka",
"9167404", "Bhubaneshwar\,\ Odisha",
"916802", "Berhampur\,\ Odisha",
"9174597", "Ramganj\ Mandi\,\ Rajasthan",
"915465", "Phulpur\/Atrawlia\,\ Uttar\ Pradesh",
"9161867", "Aurangabad\,\ Bihar",
"917772", "Wadrainagar\,\ Madhya\ Pradesh",
"918200", "Udupi\,\ Karnataka",
"917861", "Netanar\,\ Madhya\ Pradesh",
"915564", "Padrauna\,\ Uttar\ Pradesh",
"9163236", "Dumraon\,\ Bihar",
"913836", "Saiha\/Tuipang\,\ Mizoram",
"9174339", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9164293", "Kahalgaon\,\ Bihar",
"9165424", "Bokaro\,\ Bihar",
"917794", "Gotegaon\,\ Madhya\ Pradesh",
"9174943", "Kolaras\,\ Madhya\ Pradesh",
"9162236", "Motipur\,\ Bihar",
"911436", "Uniayara\,\ Rajasthan",
"9165975", "Saraikela\/Adstyapur\,\ Bihar",
"912143", "Pen\,\ Maharashtra",
"9165284", "Khunti\,\ Bihar",
"9161845", "Sasaram\,\ Bihar",
"9176530", "Bandhavgarh\,\ Madhya\ Pradesh",
"9177034", "Manpur\,\ Madhya\ Pradesh",
"9167826", "Balasore\,\ Odisha",
"9162577", "Barachakia\,\ Bihar",
"9174944", "Kolaras\,\ Madhya\ Pradesh",
"916616", "Rourkela\,\ Odisha",
"9165283", "Khunti\,\ Bihar",
"91385", "Imphal\,\ Manipur",
"9177033", "Manpur\,\ Madhya\ Pradesh",
"917371", "Sarangpur\,\ Madhya\ Pradesh",
"911954", "Sopore\,\ Jammu\ And\ Kashmir",
"9164315", "Jharmundi\,\ Bihar",
"91796", "Ahmedabad\ Local\,\ Gujarat",
"91145", "Ajmer\,\ Rajasthan",
"9162532", "Narkatiaganj\,\ Bihar",
"9163255", "Pakribarwan\,\ Bihar",
"9182890", "Athani\,\ Karnataka",
"9165423", "Bokaro\,\ Bihar",
"9164294", "Kahalgaon\,\ Bihar",
"918744", "Kothagudem\,\ Andhra\ Pradesh",
"9161822", "Arrah\,\ Bihar",
"917271", "Bagli\,\ Madhya\ Pradesh",
"9167915", "Bangiriposi\,\ Odisha",
"917123", "Nagpur\,\ Maharashtra",
"9176305", "Katangi\,\ Madhya\ Pradesh",
"9174534", "Baran\,\ Rajasthan",
"914368", "Karaikal\,\ Tamil\ Nadu",
"9162722", "Darbhanga\,\ Bihar",
"9168667", "Umerkote\,\ Odisha",
"9166792", "Komana\,\ Odisha",
"9174142", "Jaora\,\ Madhya\ Pradesh",
"911585", "Nagaur\/Khinwsar\,\ Rajasthan",
"913879", "Bishenpur\,\ Manipur",
"9163473", "Chakai\,\ Bihar",
"912778", "Idar\,\ Gujarat",
"911466", "Kekri\,\ Rajasthan",
"9174908", "Pohari\,\ Madhya\ Pradesh",
"917831", "Balrampur\,\ Madhya\ Pradesh",
"911479", "Pratapgarh\/Arnod\,\ Rajasthan",
"9167585", "Nimapara\,\ Odisha",
"9176482", "Mawai\,\ Madhya\ Pradesh",
"9174875", "Begamganj\,\ Madhya\ Pradesh",
"9173292", "Khakner\,\ Madhya\ Pradesh",
"9168645", "Mathili\,\ Odisha",
"9187592", "Outsarangapalle\,\ Andhra\ Pradesh",
"912596", "Pachora\,\ Maharashtra",
"9165843", "Bishrampur\,\ Bihar",
"9165266", "Lohardaga\,\ Bihar",
"914268", "Velur\,\ Tamil\ Nadu",
"913552", "Kalimpong\,\ West\ Bengal",
"918782", "Karimnagar\,\ Andhra\ Pradesh",
"914885", "Kunnamkulam\,\ Kerala",
"9162473", "Singhwara\,\ Bihar",
"91250", "Bassein\,\ Maharashtra",
"9174639", "Gangapur\,\ Rajasthan",
"918717", "Eturnagaram\,\ Andhra\ Pradesh",
"9164615", "Raniganj\,\ Bihar",
"91793", "Ahmedabad\ Local\,\ Gujarat",
"912354", "Sanganeshwar\/Deorukh\,\ Maharashtra",
"9176526", "Shahdol\,\ Madhya\ Pradesh",
"9165844", "Bishrampur\,\ Bihar",
"911796", "Arki\,\ Himachal\ Pradesh",
"9162745", "Samastipur\,\ Bihar",
"9162474", "Singhwara\,\ Bihar",
"918223", "K\.R\.Nagar\,\ Karnataka",
"9174125", "Ratlam\,\ Madhya\ Pradesh",
"9168622", "Gudari\,\ Odisha",
"9162767", "Madhubani\,\ Bihar",
"913662", "Dhubri\,\ Assam",
"918381", "Ron\,\ Karnataka",
"9165562", "Tisri\,\ Bihar",
"9174533", "Baran\,\ Rajasthan",
"917753", "Kota\,\ Madhya\ Pradesh",
"918323", "Goa",
"913019", "Pokhran\/Phalsoond\,\ Rajasthan",
"918912", "Visakhapatnam\,\ Andhra\ Pradesh",
"9176267", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9163474", "Chakai\,\ Bihar",
"9165386", "Torpa\,\ Bihar",
"91217", "Sholapur\,\ Maharashtra",
"915722", "Hathras\,\ Uttar\ Pradesh",
"917749", "Balod\,\ Madhya\ Pradesh",
"911881", "Ropar\,\ Punjab",
"9175224", "Datia\,\ Madhya\ Pradesh",
"9168156", "Parlakhemundi\,\ Odisha",
"911823", "Nawanshahar\,\ Punjab",
"9166825", "Attabira\,\ Odisha",
"9164237", "Maheshpur\ Raj\,\ Bihar",
"917818", "Chandipara\,\ Madhya\ Pradesh",
"91171", "Ambala\,\ Haryana",
"918707", "Warangal\,\ Andhra\ Pradesh",
"918476", "Wadi\,\ Karnataka",
"9165664", "Japla\,\ Bihar",
"918691", "Devarakonda\,\ Andhra\ Pradesh",
"9164783", "Saharsa\,\ Bihar",
"9174906", "Pohari\,\ Madhya\ Pradesh",
"917535", "Raghunathpur\,\ Madhya\ Pradesh",
"9189462", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"913481", "Islampur\,\ West\ Bengal",
"9164272", "Kathikund\,\ Bihar",
"9168524", "Koraput\,\ Odisha",
"9171752", "Bhadrawati\,\ Maharashtra",
"912905", "Sarada\/Chawand\,\ Rajasthan",
"9174632", "Gangapur\,\ Rajasthan",
"9171602", "Jamai\,\ Madhya\ Pradesh",
"9176387", "Damoh\,\ Madhya\ Pradesh",
"9165663", "Japla\,\ Bihar",
"9166842", "Paikamal\,\ Odisha",
"9164784", "Saharsa\,\ Bihar",
"918568", "Pulivendla\,\ Andhra\ Pradesh",
"9168523", "Koraput\,\ Odisha",
"9173299", "Khakner\,\ Madhya\ Pradesh",
"91251", "Kalyan\,\ Maharashtra",
"9176528", "Shahdol\,\ Madhya\ Pradesh",
"912167", "Wai\,\ Maharashtra",
"9176489", "Mawai\,\ Madhya\ Pradesh",
"911484", "Shahapura\,\ Rajasthan",
"9174149", "Jaora\,\ Madhya\ Pradesh",
"9174677", "Bamanwas\,\ Rajasthan",
"9175223", "Datia\,\ Madhya\ Pradesh",
"915283", "Charkhari\,\ Uttar\ Pradesh",
"9164576", "Korha\,\ Bihar",
"91354", "Darjeeling\,\ West\ Bengal",
"9182205", "Gundlupet\,\ Karnataka",
"9177040", "Deobhog\,\ Madhya\ Pradesh",
"918387", "Honnavar\,\ Karnataka",
"9167283", "Jajapur\ Town\,\ Odisha",
"9163414", "Seikhpura\,\ Bihar",
"912436", "Vijapur\,\ Maharashtra",
"9165826", "Chaibasa\,\ Bihar",
"9171345", "Bhamregadh\,\ Maharashtra",
"915494", "Bansdeeh\,\ Uttar\ Pradesh",
"9161584", "Sonepur\,\ Bihar",
"9162457", "Gogri\,\ Bihar",
"9168407", "Tumudibandha\,\ Odisha",
"9171367", "Etapalli\,\ Maharashtra",
"9166402", "Bagdihi\,\ Odisha",
"9164675", "Banmankhi\,\ Bihar",
"918711", "Wardhannapet\/Ghanapur\,\ Andhra\ Pradesh",
"9174256", "Garoth\,\ Madhya\ Pradesh",
"911606", "Kharar\,\ Punjab",
"9163457", "Jamui\,\ Bihar",
"917256", "Murtizapur\,\ Maharashtra",
"91733", "Khandwa\,\ Madhya\ Pradesh",
"9174815", "Gairatganj\,\ Madhya\ Pradesh",
"912954", "Kumbalgarh\/Charbhujaji\,\ Rajasthan",
"918619", "Nellore\,\ Andhra\ Pradesh",
"9174235", "Neemuch\,\ Madhya\ Pradesh",
"918212", "Mysore\,\ Karnataka",
"9171322", "Gadchiroli\,\ Maharashtra",
"917572", "Itarsi\,\ Madhya\ Pradesh",
"9167284", "Jajapur\ Town\,\ Odisha",
"9167975", "Jashipur\,\ Odisha",
"918156", "Chikkaballapur\,\ Karnataka",
"9174930", "Karera\,\ Madhya\ Pradesh",
"917859", "Lohadigundah\,\ Madhya\ Pradesh",
"9163413", "Seikhpura\,\ Bihar",
"918312", "Belgaum\,\ Karnataka",
"9174552", "Digod\/Sultanpur\,\ Rajasthan",
"9161583", "Sonepur\,\ Bihar",
"911802", "Panipat\,\ Haryana",
"9174559", "Digod\/Sultanpur\,\ Rajasthan",
"9174617", "Mahuwa\,\ Rajasthan",
"912442", "Bhir\,\ Maharashtra",
"916315", "Gaya\,\ Bihar",
"917843", "Durgakondal\,\ Madhya\ Pradesh",
"9166247", "Rajgangpur\,\ Odisha",
"9173927", "Jhabua\,\ Madhya\ Pradesh",
"9164516", "Barsoi\,\ Bihar",
"9174258", "Garoth\,\ Madhya\ Pradesh",
"9165404", "Govindpur\,\ Bihar",
"912428", "Pathardi\,\ Maharashtra",
"918738", "Sirpurkagaznagar\,\ Andhra\ Pradesh",
"9176350", "Lanji\,\ Madhya\ Pradesh",
"916215", "Muzaffarpur\,\ Bihar",
"9174654", "Sapotra\,\ Rajasthan",
"9171427", "Bhimpur\,\ Madhya\ Pradesh",
"9166265", "Banaigarh\,\ Odisha",
"912161", "Vaduj\,\ Maharashtra",
"917770", "Kathdol\,\ Madhya\ Pradesh",
"918202", "Udupi\,\ Karnataka",
"913624", "Nalbari\,\ Assam",
"9171733", "Rajura\,\ Maharashtra",
"9165403", "Govindpur\,\ Bihar",
"9161802", "Adhaura\,\ Bihar",
"9181747", "Arsikere\,\ Karnataka",
"9171462", "Ghorandogri\,\ Madhya\ Pradesh",
"917765", "Pathalgaon\,\ Madhya\ Pradesh",
"9174653", "Sapotra\,\ Rajasthan",
"9164212", "Naugachia\,\ Bihar",
"915921", "Bilari\,\ Uttar\ Pradesh",
"9171734", "Rajura\,\ Maharashtra",
"9174704", "Bundi\,\ Rajasthan",
"9168485", "Kotagarh\,\ Odisha",
"914344", "Hosur\,\ Tamil\ Nadu",
"912529", "Mokhada\,\ Maharashtra",
"914172", "Ranipet\,\ Tamil\ Nadu",
"911887", "Nangal\,\ Punjab",
"911683", "Julana\,\ Haryana",
"9168546", "Jeypore\,\ Odisha",
"9167686", "Parajang\,\ Odisha",
"9181765", "Cannarayapatna\,\ Karnataka",
"9168225", "Aska\,\ Odisha",
"9174354", "Gangdhar\,\ Rajasthan",
"918854", "Tuni\,\ Andhra\ Pradesh",
"918780", "Karimnagar\,\ Andhra\ Pradesh",
"914282", "Attur\,\ Tamil\ Nadu",
"914926", "Shoranur\,\ Kerala",
"918599", "Ulvapadu\,\ Andhra\ Pradesh",
"9171156", "Mouda\,\ Maharashtra",
"9173214", "Sanwer\,\ Madhya\ Pradesh",
"9167663", "Keonjhar\,\ Odisha",
"9174928", "Shivpuri\,\ Madhya\ Pradesh",
"9166757", "T\.Rampur\,\ Odisha",
"914153", "Arakandanallur\,\ Tamil\ Nadu",
"917448", "Ladpura\/Kota\,\ Rajasthan",
"91374", "Tinsukhia\,\ Assam",
"9171524", "Wardha\,\ Maharashtra",
"913675", "Bokajan\,\ Assam",
"9174317", "Aklera\,\ Rajasthan",
"9177059", "Kurud\,\ Madhya\ Pradesh",
"9166714", "Rajkhariar\,\ Odisha",
"9165507", "Hunterganj\,\ Bihar",
"912823", "Jetpur\,\ Gujarat",
"9176325", "Balaghat\,\ Madhya\ Pradesh",
"9171523", "Wardha\,\ Maharashtra",
"912484", "Partur\,\ Maharashtra",
"9171865", "Sakoli\,\ Maharashtra",
"918498", "Nallacheruvu\/Tanakallu\,\ Andhra\ Pradesh",
"918910", "Visakhapatnam\,\ Andhra\ Pradesh",
"9168602", "Boriguma\,\ Odisha",
"9166713", "Rajkhariar\,\ Odisha",
"915522", "Pharenda\/Compierganj\,\ Uttar\ Pradesh",
"91481", "Kottayam\,\ Kerala",
"9175932", "Kurwai\,\ Madhya\ Pradesh",
"918451", "Zahirabad\,\ Andhra\ Pradesh",
"9174353", "Gangdhar\,\ Rajasthan",
"911905", "Mandi\,\ Himachal\ Pradesh",
"9173213", "Sanwer\,\ Madhya\ Pradesh",
"9171135", "Saoner\,\ Maharashtra",
"9171847", "Bhandara\,\ Maharashtra",
"9176342", "Lamta\,\ Madhya\ Pradesh",
"9167664", "Keonjhar\,\ Odisha",
"915548", "Khalilabad\/Mehdawal\,\ Uttar\ Pradesh",
"9176506", "Beohari\,\ Madhya\ Pradesh",
"91151", "Bikaner\,\ Rajasthan",
"9176349", "Lamta\,\ Madhya\ Pradesh",
"9174926", "Shivpuri\,\ Madhya\ Pradesh",
"9171035", "Butibori\,\ Maharashtra",
"911596", "Chirawa\,\ Rajasthan",
"9167844", "Bhadrak\,\ Odisha",
"9164375", "Mahagama\,\ Bihar",
"9171667", "Chaurai\,\ Madhya\ Pradesh",
"9168504", "Kalimela\,\ Odisha",
"9162554", "Raxaul\,\ Bihar",
"9176447", "Dindori\,\ Madhya\ Pradesh",
"913251", "Adra\,\ West\ Bengal",
"912118", "Walchandnagar\,\ Maharashtra",
"912993", "Jaisalmer\/Devikot\,\ Rajasthan",
"91816", "Tumkur\,\ Karnataka",
"918517", "Atmakur\,\ Andhra\ Pradesh",
"9161566", "Gopalganj\,\ Bihar",
"9162517", "Bagaha\,\ Bihar",
"914896", "Kavaratti\,\ Lakshadweep",
"9175939", "Kurwai\,\ Madhya\ Pradesh",
"9176465", "Nainpur\,\ Madhya\ Pradesh",
"9174540", "Chhipaborad\,\ Rajasthan",
"9167562", "Balugaon\,\ Odisha",
"912585", "Yawal\,\ Maharashtra",
"9164595", "Thakurganj\,\ Bihar",
"9171645", "Pandhurna\,\ Madhya\ Pradesh",
"9171797", "Nagbhir\,\ Maharashtra",
"91480", "Irinjalakuda\,\ Kerala",
"912466", "Kandhar\,\ Maharashtra",
"915453", "Shahganj\,\ Uttar\ Pradesh",
"918177", "Belur\,\ Karnataka",
"917604", "Hatta\,\ Madhya\ Pradesh",
"911785", "Pooh\,\ Himachal\ Pradesh",
"911254", "Bawanikhera\,\ Haryana",
"9165446", "Gomia\,\ Bihar",
"9167527", "Puri\,\ Odisha",
"9177052", "Kurud\,\ Madhya\ Pradesh",
"9165915", "Chandil\,\ Bihar",
"917867", "Bokaband\,\ Madhya\ Pradesh",
"914149", "Ulundurpet\,\ Tamil\ Nadu",
"913752", "Lakhimpur\,\ Assam",
"9171056", "Narkhed\,\ Maharashtra",
"918582", "B\.Kothakota\,\ Andhra\ Pradesh",
"9162553", "Raxaul\,\ Bihar",
"9168503", "Kalimela\,\ Odisha",
"9167266", "Jajapur\ Road\,\ Odisha",
"9167843", "Bhadrak\,\ Odisha",
"9161112", "Hilsa\,\ Bihar",
"9176508", "Beohari\,\ Madhya\ Pradesh",
"912796", "Kunkawav\,\ Gujarat",
"9165585", "Dumri\(Isribazar\)\,\ Bihar",
"915734", "Debai\,\ Uttar\ Pradesh",
"9171622", "Chhindwara\,\ Madhya\ Pradesh",
"917663", "Mauganj\,\ Madhya\ Pradesh",
"9168112", "Chhatrapur\,\ Odisha",
"9161503", "Hathua\,\ Bihar",
"9164533", "Araria\,\ Bihar",
"9173220", "Depalpur\,\ Madhya\ Pradesh",
"9166267", "Banaigarh\,\ Odisha",
"9171425", "Bhimpur\,\ Madhya\ Pradesh",
"911735", "Chaaharauli\,\ Haryana",
"9174578", "Mangrol\,\ Rajasthan",
"9163376", "Arwal\,\ Bihar",
"9173925", "Jhabua\,\ Madhya\ Pradesh",
"9171974", "Mohadi\,\ Maharashtra",
"9171716", "Gond\ Pipri\,\ Maharashtra",
"912641", "Amod\,\ Gujarat",
"915255", "Kaisarganh\/Mahasi\,\ Uttar\ Pradesh",
"915850", "Hardoi\/Baghavli\,\ Uttar\ Pradesh",
"9176290", "Pushprajgarh\,\ Madhya\ Pradesh",
"9166245", "Rajgangpur\,\ Odisha",
"9181722", "Hassan\,\ Karnataka",
"918673", "Tirivuru\,\ Andhra\ Pradesh",
"918532", "Raichur\,\ Karnataka",
"9174279", "Bhanpura\,\ Madhya\ Pradesh",
"9174615", "Mahuwa\,\ Rajasthan",
"9162596", "Pakridayal\,\ Bihar",
"9166526", "Balangir\,\ Odisha",
"9171093", "Kamptee\,\ Maharashtra",
"9168227", "Aska\,\ Odisha",
"9181767", "Cannarayapatna\,\ Karnataka",
"9175266", "Ghatigaon\,\ Madhya\ Pradesh",
"9171442", "Atner\,\ Madhya\ Pradesh",
"911422", "Viratnagar\/Shahpura\,\ Rajasthan",
"9171973", "Mohadi\,\ Maharashtra",
"913848", "Thonbal\,\ Manipur",
"912749", "Danta\,\ Gujarat",
"9171094", "Kamptee\,\ Maharashtra",
"918267", "Kadur\,\ Karnataka",
"9166482", "Patnagarh\,\ Odisha",
"914346", "Harur\,\ Tamil\ Nadu",
"9164534", "Araria\,\ Bihar",
"9168487", "Kotagarh\,\ Odisha",
"9161504", "Hathua\,\ Bihar",
"9173942", "Alirajpur\,\ Madhya\ Pradesh",
"9165626", "Daltonganj\,\ Bihar",
"9175388", "Ambah\,\ Madhya\ Pradesh",
"913822", "Dharam\ Nagar\,\ Tripura",
"9168566", "Rayagada\,\ Odisha",
"9162292", "Bidupur\,\ Bihar",
"9181745", "Arsikere\,\ Karnataka",
"9166222", "Sundargarh\,\ Odisha",
"916123", "Patna\,\ Bihar",
"918367", "Hubli\,\ Karnataka",
"9177060", "Gariaband\,\ Madhya\ Pradesh",
"9176564", "Kannodi\,\ Madhya\ Pradesh",
"9163455", "Jamui\,\ Bihar",
"9167606", "Talcher\,\ Odisha",
"9174576", "Mangrol\,\ Rajasthan",
"9167886", "Soro\,\ Odisha",
"913638", "Nongpoh\,\ Meghalaya",
"911663", "Hansi\,\ Haryana",
"912808", "Sumrasar\,\ Gujarat",
"915671", "Jasrana\,\ Uttar\ Pradesh",
"9173949", "Alirajpur\,\ Madhya\ Pradesh",
"918724", "Jagtial\,\ Andhra\ Pradesh",
"9164677", "Banmankhi\,\ Bihar",
"9171365", "Etapalli\,\ Maharashtra",
"915496", "Ballia\/Raniganj\,\ Uttar\ Pradesh",
"9165223", "Muri\,\ Bihar",
"9171347", "Bhamregadh\,\ Maharashtra",
"9168405", "Tumudibandha\,\ Odisha",
"9162455", "Gogri\,\ Bihar",
"918546", "Gadwal\,\ Andhra\ Pradesh",
"912753", "Limbdi\,\ Gujarat",
"9174853", "Udaipura\,\ Madhya\ Pradesh",
"911604", "Kharar\,\ Punjab",
"914567", "Ramanathpuram\,\ Tamil\ Nadu",
"917785", "Makodi\,\ Madhya\ Pradesh",
"9161882", "Rohtas\,\ Bihar",
"915963", "Bageshwar\,\ Uttar\ Pradesh",
"917254", "Malgaon\,\ Maharashtra",
"9182207", "Gundlupet\,\ Karnataka",
"9165483", "Ichak\,\ Bihar",
"9162436", "Begusarai\,\ Bihar",
"911377", "Bhatwari\/Gangotri\,\ Uttarakhand",
"9181729", "Hassan\,\ Karnataka",
"912956", "Gogunda\,\ Rajasthan",
"912181", "Akkalkot\,\ Maharashtra",
"9174272", "Bhanpura\,\ Madhya\ Pradesh",
"917778", "Semaria\,\ Madhya\ Pradesh",
"9167977", "Jashipur\,\ Odisha",
"9174854", "Udaipura\,\ Madhya\ Pradesh",
"918730", "Khanapur\,\ Andhra\ Pradesh",
"9175268", "Ghatigaon\,\ Madhya\ Pradesh",
"914639", "Tiruchendur\,\ Tamil\ Nadu",
"9165484", "Ichak\,\ Bihar",
"913797", "Pangin\,\ Arunachal\ Pradesh",
"9176563", "Kannodi\,\ Madhya\ Pradesh",
"9174237", "Neemuch\,\ Madhya\ Pradesh",
"918154", "Chintamani\,\ Karnataka",
"917915", "Ahmedabad\ Local\,\ Gujarat",
"912831", "Nalia\,\ Gujarat",
"914332", "Manaparai\,\ Tamil\ Nadu",
"9167932", "Betanati\,\ Odisha",
"9175386", "Ambah\,\ Madhya\ Pradesh",
"9165224", "Muri\,\ Bihar",
"9174817", "Gairatganj\,\ Madhya\ Pradesh",
"9176369", "Baihar\,\ Madhya\ Pradesh",
"911859", "Goindwal\,\ Punjab",
"911594", "Udaipurwati\,\ Rajasthan",
"9171795", "Nagbhir\,\ Maharashtra",
"917802", "Churhat\,\ Madhya\ Pradesh",
"9167864", "Chandbali\,\ Odisha",
"9171647", "Pandhurna\,\ Madhya\ Pradesh",
"9164597", "Thakurganj\,\ Bihar",
"912371", "Wathar\,\ Maharashtra",
"918775", "Tirupathi\,\ Andhra\ Pradesh",
"9176467", "Nainpur\,\ Madhya\ Pradesh",
"9163274", "Rafiganj\,\ Bihar",
"9164332", "Jamtara\,\ Bihar",
"9162515", "Bagaha\,\ Bihar",
"9161546", "Siwan\,\ Bihar",
"9174696", "Hindaun\,\ Rajasthan",
"913668", "Bijni\,\ Assam",
"911633", "Muktasar\,\ Punjab",
"9177076", "Bagbahera\,\ Madhya\ Pradesh",
"914894", "Agathy\,\ Lakshadweep",
"9168682", "Nandapur\,\ Odisha",
"9176445", "Dindori\,\ Madhya\ Pradesh",
"9174560", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"911572", "Sikar\,\ Rajasthan",
"918918", "Visakhapatnam\,\ Andhra\ Pradesh",
"9171665", "Chaurai\,\ Madhya\ Pradesh",
"918193", "Hiriyur\,\ Karnataka",
"918243", "Mangalore\,\ Karnataka",
"918490", "Pamuru\,\ Andhra\ Pradesh",
"9171037", "Butibori\,\ Maharashtra",
"9164377", "Mahagama\,\ Bihar",
"9162274", "Mahua\,\ Bihar",
"916413", "Bhagalpur\,\ Bihar",
"917606", "Jabera\,\ Madhya\ Pradesh",
"9176282", "Karpa\,\ Madhya\ Pradesh",
"9165587", "Dumri\(Isribazar\)\,\ Bihar",
"9162273", "Mahua\,\ Bihar",
"912772", "Himatnagar\,\ Gujarat",
"91512", "Kanpur\,\ Uttar\ Pradesh",
"9165466", "Hazaribagh\,\ Bihar",
"9162782", "Dalsinghsarai\,\ Bihar",
"914362", "Thanjavur\,\ Tamil\ Nadu",
"917440", "Ladpura\/Kota\,\ Rajasthan",
"9165917", "Chandil\,\ Bihar",
"9167525", "Puri\,\ Odisha",
"9171992", "Deori\,\ Maharashtra",
"9176422", "Mandla\,\ Madhya\ Pradesh",
"9173238", "Punasa\,\ Madhya\ Pradesh",
"912977", "Jalore\/Sayla\,\ Rajasthan",
"9167246", "Jagatsinghpur\,\ Odisha",
"9167863", "Chandbali\,\ Odisha",
"912794", "Rajula\,\ Gujarat",
"9163273", "Rafiganj\,\ Bihar",
"914262", "Gudalur\,\ Tamil\ Nadu",
"915736", "Siyana\,\ Uttar\ Pradesh",
"918788", "Karimnagar\,\ Andhra\ Pradesh",
"9176327", "Balaghat\,\ Madhya\ Pradesh",
"917683", "Tikamgarh\,\ Madhya\ Pradesh",
"918856", "Amalapuram\,\ Andhra\ Pradesh",
"9171822", "Gondia\,\ Maharashtra",
"914924", "Mannarkad\,\ Kerala",
"9165505", "Hunterganj\,\ Bihar",
"9174698", "Hindaun\,\ Rajasthan",
"9167643", "Anugul\,\ Odisha",
"9176429", "Mandla\,\ Madhya\ Pradesh",
"917621", "Patan\,\ Madhya\ Pradesh",
"918562", "Kadapa\,\ Andhra\ Pradesh",
"9168583", "Nowrangapur\,\ Odisha",
"915241", "Ramsanehi\ Ghat\,\ Uttar\ Pradesh",
"9174315", "Aklera\,\ Rajasthan",
"915191", "Naraini\/Attarra\,\ Uttar\ Pradesh",
"9166755", "T\.Rampur\,\ Odisha",
"9176289", "Karpa\,\ Madhya\ Pradesh",
"915341", "Kunda\,\ Uttar\ Pradesh",
"918931", "Yelamanchili\,\ Andhra\ Pradesh",
"9177078", "Bagbahera\,\ Madhya\ Pradesh",
"911765", "Nabha\,\ Punjab",
"9173950", "Sondhwa\,\ Madhya\ Pradesh",
"9166736", "Jayapatna\,\ Odisha",
"9165326", "Giridih\,\ Bihar",
"918259", "Shankarnarayana\,\ Karnataka",
"9171845", "Bhandara\,\ Maharashtra",
"912565", "Shahada\,\ Maharashtra",
"9171137", "Saoner\,\ Maharashtra",
"918337", "Murugod\,\ Karnataka",
"915947", "Kashipur\,\ Uttar\ Pradesh",
"914543", "Batlagundu\,\ Tamil\ Nadu",
"918359", "Indi\,\ Karnataka",
"917729", "Bhilaigarh\,\ Madhya\ Pradesh",
"915742", "Etah\,\ Uttar\ Pradesh",
"917812", "Damoh\,\ Madhya\ Pradesh",
"9171867", "Sakoli\,\ Maharashtra",
"9168584", "Nowrangapur\,\ Odisha",
"9176362", "Baihar\,\ Madhya\ Pradesh",
"9167644", "Anugul\,\ Odisha",
"9173236", "Punasa\,\ Madhya\ Pradesh",
"911495", "Mandawar\,\ Rajasthan",
"9161847", "Sasaram\,\ Bihar",
"9181702", "Alur\,\ Karnataka",
"912971", "Pindwara\,\ Rajasthan",
"9167484", "Bhubaneshwar\,\ Odisha",
"915566", "Salempur\,\ Uttar\ Pradesh",
"913834", "Demagiri\,\ Mizoram",
"9165977", "Saraikela\/Adstyapur\,\ Bihar",
"917578", "Pachmarhi\,\ Madhya\ Pradesh",
"9164353", "Pakur\,\ Bihar",
"915333", "Karchhana\/Shankergarh\,\ Uttar\ Pradesh",
"9171382", "Dhanora\,\ Maharashtra",
"91226", "Mumbai",
"915852", "Hardoi\,\ Uttar\ Pradesh",
"918218", "Mysore\,\ Karnataka",
"9168194", "Surada\,\ Odisha",
"9167224", "Pardip\,\ Odisha",
"912663", "Dabhoi\,\ Gujarat",
"9174963", "Pichhore\,\ Madhya\ Pradesh",
"9165932", "Manoharpur\,\ Bihar",
"911434", "Deoli\,\ Rajasthan",
"91477", "Alappuzha\,\ Kerala",
"9161523", "Chapra\,\ Bihar",
"9172878", "Gogaon\,\ Madhya\ Pradesh",
"918318", "Belgaum\,\ Karnataka",
"9173200", "Pandhana\,\ Madhya\ Pradesh",
"9161865", "Aurangabad\,\ Bihar",
"9167223", "Pardip\,\ Odisha",
"913225", "Ghatal\,\ West\ Bengal",
"918524", "Srisailam\,\ Andhra\ Pradesh",
"9168193", "Surada\,\ Odisha",
"9177016", "Pingeshwar\,\ Madhya\ Pradesh",
"9174964", "Pichhore\,\ Madhya\ Pradesh",
"916614", "Rourkela\,\ Odisha",
"9161524", "Chapra\,\ Bihar",
"9165886", "Jagarnathpur\,\ Bihar",
"9163257", "Pakribarwan\,\ Bihar",
"917479", "Bundi\,\ Rajasthan",
"9165606", "Patan\,\ Bihar",
"9164317", "Jharmundi\,\ Bihar",
"9167483", "Bhubaneshwar\,\ Odisha",
"911956", "Uri\,\ Jammu\ And\ Kashmir",
"917585", "Rehli\,\ Madhya\ Pradesh",
"9164354", "Pakur\,\ Bihar",
"912553", "Igatpuri\,\ Maharashtra",
"9162575", "Barachakia\,\ Bihar",
"918746", "Bhooragamphad\/Manuguru\,\ Andhra\ Pradesh",
"9161156", "Danapur\,\ Bihar",
"911420", "Baswa\/Bandikui\,\ Rajasthan",
"9165344", "Jhumaritalaiya\,\ Bihar",
"914324", "Karur\,\ Tamil\ Nadu",
"9175210", "Seondha\,\ Madhya\ Pradesh",
"9168425", "Phulbani\,\ Odisha",
"918231", "Malavalli\,\ Karnataka",
"91798", "Ahmedabad\ Local\,\ Gujarat",
"9172876", "Gogaon\,\ Madhya\ Pradesh",
"9175915", "Sironj\,\ Madhya\ Pradesh",
"918425", "Biligi\,\ Karnataka",
"9167626", "Dhenkanal\,\ Odisha",
"912735", "Deodar\,\ Gujarat",
"918331", "Raibag\/Kudchi\,\ Karnataka",
"9174595", "Ramganj\ Mandi\,\ Rajasthan",
"911535", "Kolayat\/Bajju\,\ Rajasthan",
"91771", "Raipur\,\ Madhya\ Pradesh",
"9177018", "Pingeshwar\,\ Madhya\ Pradesh",
"918937", "Chintapalle\,\ Andhra\ Pradesh",
"9168442", "Kantamal\,\ Odisha",
"9166465", "Bargarh\,\ Odisha",
"917823", "Dongargarh\,\ Madhya\ Pradesh",
"9166447", "Rairakhol\,\ Odisha",
"9165343", "Jhumaritalaiya\,\ Bihar",
"918732", "Adilabad\,\ Andhra\ Pradesh",
"912422", "Shri\ Rampur\,\ Maharashtra",
"9171566", "Talegaokarangal\,\ Maharashtra",
"911749", "Assandh\,\ Haryana",
"9181709", "Alur\,\ Karnataka",
"918208", "Udupi\,\ Karnataka",
"9174375", "Nainwa\,\ Rajasthan",
"9171487", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"918492", "Kambadur\,\ Andhra\ Pradesh",
"9172860", "Khetia\,\ Madhya\ Pradesh",
"9164552", "Forbesganj\,\ Bihar",
"9171583", "Deoli\,\ Maharashtra",
"912765", "Visnagar\,\ Gujarat",
"9166543", "Sonapur\,\ Odisha",
"9167326", "Hindol\,\ Odisha",
"911570", "Laxmangarh\/Nechwa\,\ Rajasthan",
"9166827", "Attabira\,\ Odisha",
"916633", "Sambalpur\,\ Odisha",
"9164235", "Maheshpur\ Raj\,\ Bihar",
"918474", "Chittapur\,\ Karnataka",
"9161322", "Barh\,\ Bihar",
"9165644", "Nagarutari\,\ Bihar",
"916572", "Jamshedpur\,\ Bihar",
"911655", "Raman\,\ Punjab",
"915542", "Basti\,\ Uttar\ Pradesh",
"918261", "Tarikere\,\ Karnataka",
"9171776", "Brahmapuri\,\ Maharashtra",
"9164256", "Katoria\,\ Bihar",
"914288", "Tiruchengode\,\ Tamil\ Nadu",
"914865", "Munnar\,\ Kerala",
"91372", "Lungleh\,\ Mizoram",
"9165643", "Nagarutari\,\ Bihar",
"9163316", "Imamganj\,\ Bihar",
"917442", "Ladpura\/Kota\,\ Rajasthan",
"9176402", "Shahpur\,\ Madhya\ Pradesh",
"9174675", "Bamanwas\,\ Rajasthan",
"9174219", "Manasa\,\ Madhya\ Pradesh",
"912843", "Gariadhar\,\ Gujarat",
"911486", "Mandal\,\ Rajasthan",
"912770", "Prantij\,\ Gujarat",
"911565", "Sri\ Dungargarh\,\ Rajasthan",
"9171584", "Deoli\,\ Maharashtra",
"9168172", "R\.Udayigiri\,\ Odisha",
"9176385", "Damoh\,\ Madhya\ Pradesh",
"9166544", "Sonapur\,\ Odisha",
"9174518", "Atru\,\ Rajasthan",
"914651", "Kuzhithurai\,\ Tamil\ Nadu",
"912633", "Dharampur\,\ Gujarat",
"913791", "Taliha\,\ Arunachal\ Pradesh",
"9168647", "Mathili\,\ Odisha",
"915263", "Balarampur\/Balrampur\,\ Uttar\ Pradesh",
"91233", "Sangli\,\ Maharashtra",
"9167954", "Udala\,\ Odisha",
"9167587", "Nimapara\,\ Odisha",
"9174877", "Begamganj\,\ Madhya\ Pradesh",
"913803", "Roing\,\ Arunachal\ Pradesh",
"911464", "Rajgarh\,\ Rajasthan",
"912837", "Bhachav\,\ Gujarat",
"9174212", "Manasa\,\ Madhya\ Pradesh",
"912187", "Sangola\,\ Maharashtra",
"9176409", "Shahpur\,\ Madhya\ Pradesh",
"913758", "Dhakuakhana\,\ Assam",
"918588", "Vaimpalli\,\ Andhra\ Pradesh",
"918560", "Jammalamadugu\,\ Andhra\ Pradesh",
"911371", "Dunda\,\ Uttarakhand",
"9168665", "Umerkote\,\ Odisha",
"912594", "Trimbak\,\ Maharashtra",
"91223", "Mumbai",
"9165863", "Chainpur\,\ Bihar",
"9176307", "Katangi\,\ Madhya\ Pradesh",
"9171802", "Salekasa\,\ Maharashtra",
"9165246", "Gumla\,\ Bihar",
"9171682", "Harrai\,\ Madhya\ Pradesh",
"9167917", "Bangiriposi\,\ Odisha",
"9176265", "Vijayraghogarh\,\ Madhya\ Pradesh",
"913461", "Rampur\ Hat\,\ West\ Bengal",
"912356", "Khed\,\ Maharashtra",
"9165864", "Chainpur\,\ Bihar",
"912112", "Baramati\,\ Maharashtra",
"915740", "Aliganj\/Ganjdundwara\,\ Uttar\ Pradesh",
"914561", "Devakottai\,\ Tamil\ Nadu",
"9162765", "Madhubani\,\ Bihar",
"917810", "Uproda\,\ Madhya\ Pradesh",
"9174127", "Ratlam\,\ Madhya\ Pradesh",
"9174516", "Atru\,\ Rajasthan",
"915873", "Nighasan\/Tikunia\,\ Uttar\ Pradesh",
"9162747", "Samastipur\,\ Bihar",
"9165542", "Rajdhanwar\,\ Bihar",
"9167953", "Udala\,\ Odisha",
"9164617", "Raniganj\,\ Bihar",
"9165306", "Bundu\,\ Bihar",
"915677", "Karhal\,\ Uttar\ Pradesh",
"9166486", "Patnagarh\,\ Odisha",
"9174278", "Bhanpura\,\ Madhya\ Pradesh",
"912901", "Siwana\,\ Rajasthan",
"9174674", "Bamanwas\,\ Rajasthan",
"916217", "Muzaffarpur\,\ Bihar",
"9176370", "Birsa\,\ Madhya\ Pradesh",
"9164233", "Maheshpur\ Raj\,\ Bihar",
"912674", "Lunavada\,\ Gujarat",
"9171446", "Atner\,\ Madhya\ Pradesh",
"9175262", "Ghatigaon\,\ Madhya\ Pradesh",
"9178081", "\`",
"9166226", "Sundargarh\,\ Odisha",
"9162296", "Bidupur\,\ Bihar",
"913656", "Mawkyrwat\,\ Meghalaya",
"9174579", "Mangrol\,\ Rajasthan",
"9168562", "Rayagada\,\ Odisha",
"9174680", "Khandar\,\ Rajasthan",
"9176384", "Damoh\,\ Madhya\ Pradesh",
"916317", "Gaya\,\ Bihar",
"9174800", "Goharganj\,\ Madhya\ Pradesh",
"9166545", "Sonapur\,\ Odisha",
"9171585", "Deoli\,\ Maharashtra",
"9164787", "Saharsa\,\ Bihar",
"912149", "Mahasala\,\ Maharashtra",
"9173946", "Alirajpur\,\ Madhya\ Pradesh",
"912692", "Anand\,\ Gujarat",
"9165622", "Daltonganj\,\ Bihar",
"91470", "Attingal\,\ Kerala",
"914118", "Tiruttani\,\ Tamil\ Nadu",
"9165667", "Japla\,\ Bihar",
"9176383", "Damoh\,\ Madhya\ Pradesh",
"911268", "Ferojpur\,\ Haryana",
"911885", "Balachaur\,\ Punjab",
"9168116", "Chhatrapur\,\ Odisha",
"9168527", "Koraput\,\ Odisha",
"9181520", "Kolar\,\ Karnatak",
"917767", "Gharghoda\,\ Madhya\ Pradesh",
"9166522", "Balangir\,\ Odisha",
"9162592", "Pakridayal\,\ Bihar",
"911368", "Pauri\,\ Uttarakhand",
"9175227", "Datia\,\ Madhya\ Pradesh",
"9181726", "Hassan\,\ Karnataka",
"912938", "Bali\,\ Rajasthan",
"9174673", "Bamanwas\,\ Rajasthan",
"913485", "Dhuliyan\,\ West\ Bengal",
"9165645", "Nagarutari\,\ Bihar",
"9171712", "Gond\ Pipri\,\ Maharashtra",
"912896", "Bhanvad\,\ Gujarat",
"9163372", "Arwal\,\ Bihar",
"913566", "Kalchini\,\ West\ Bengal",
"915834", "Bisauli\,\ Uttar\ Pradesh",
"917531", "Baroda\,\ Madhya\ Pradesh",
"9164234", "Maheshpur\ Raj\,\ Bihar",
"918868", "Yeleswaram\,\ Andhra\ Pradesh",
"91281", "Rajkot\,\ Gujarat",
"913584", "Mekhliganj\,\ West\ Bengal",
"9162764", "Madhubani\,\ Bihar",
"9165865", "Chainpur\,\ Bihar",
"9174276", "Bhanpura\,\ Madhya\ Pradesh",
"9168663", "Umerkote\,\ Odisha",
"9162432", "Begusarai\,\ Bihar",
"91144", "Alwar\,\ Rajasthan",
"9176264", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9163477", "Chakai\,\ Bihar",
"915644", "Bharatpur\,\ Rajasthan",
"917224", "Daryapur\,\ Maharashtra",
"918385", "Bhatkal\,\ Karnataka",
"9167936", "Betanati\,\ Odisha",
"9173948", "Alirajpur\,\ Madhya\ Pradesh",
"9175382", "Ambah\,\ Madhya\ Pradesh",
"9165847", "Bishrampur\,\ Bihar",
"9162477", "Singhwara\,\ Bihar",
"9167955", "Udala\,\ Odisha",
"911523", "Bikaner\/Poogal\,\ Rajasthan",
"9176430", "Bijadandi\,\ Madhya\ Pradesh",
"9167882", "Soro\,\ Odisha",
"9174572", "Mangrol\,\ Rajasthan",
"918378", "Savanur\,\ Karnataka",
"9167602", "Talcher\,\ Odisha",
"912926", "Osian\/Mathania\,\ Rajasthan",
"91471", "Thiruvananthapuram\,\ Kerala",
"911581", "Ladnun\,\ Rajasthan",
"9162763", "Madhubani\,\ Bihar",
"9161886", "Rohtas\,\ Bihar",
"91207", "Pune\,\ Maharashtra",
"9175269", "Ghatigaon\,\ Madhya\ Pradesh",
"917835", "Bharathpur\,\ Madhya\ Pradesh",
"917230", "Ghatanji\,\ Maharashtra",
"9174537", "Baran\,\ Rajasthan",
"9168664", "Umerkote\,\ Odisha",
"917518", "Gwalior\,\ Madhya\ Pradesh",
"9181728", "Hassan\,\ Karnataka",
"9176263", "Vijayraghogarh\,\ Madhya\ Pradesh",
"912382", "Latur\,\ Maharashtra",
"9165462", "Hazaribagh\,\ Bihar",
"9161863", "Aurangabad\,\ Bihar",
"9162786", "Dalsinghsarai\,\ Bihar",
"917743", "Chuikhadan\,\ Madhya\ Pradesh",
"9161525", "Chapra\,\ Bihar",
"9174965", "Pichhore\,\ Madhya\ Pradesh",
"918188", "Honnali\,\ Karnataka",
"9164297", "Kahalgaon\,\ Bihar",
"918463", "Armoor\,\ Andhra\ Pradesh",
"917375", "Narsingharh\,\ Madhya\ Pradesh",
"912587", "Amalner\,\ Maharashtra",
"912194", "Roha\,\ Maharashtra",
"9176286", "Karpa\,\ Madhya\ Pradesh",
"9162574", "Barachakia\,\ Bihar",
"918404", "Marturu\,\ Andhra\ Pradesh",
"9174947", "Kolaras\,\ Madhya\ Pradesh",
"918838", "Rajahmundri\,\ Andhra\ Pradesh",
"9164355", "Pakur\,\ Bihar",
"9167242", "Jagatsinghpur\,\ Odisha",
"9174260", "Sitamau\,\ Madhya\ Pradesh",
"918515", "Banaganapalle\,\ Andhra\ Pradesh",
"9176426", "Mandla\,\ Madhya\ Pradesh",
"913214", "Jagatballavpur\,\ West\ Bengal",
"9176368", "Baihar\,\ Madhya\ Pradesh",
"912344", "Jath\,\ Maharashtra",
"9171996", "Deori\,\ Maharashtra",
"917865", "Gogunda\,\ Madhya\ Pradesh",
"917260", "Lonar\,\ Maharashtra",
"9174692", "Hindaun\,\ Rajasthan",
"9161542", "Siwan\,\ Bihar",
"91515", "Unnao\,\ Uttar\ Pradesh",
"9164336", "Jamtara\,\ Bihar",
"9162573", "Barachakia\,\ Bihar",
"911982", "Leh\,\ Jammu\ And\ Kashmir",
"9165287", "Khunti\,\ Bihar",
"9173239", "Punasa\,\ Madhya\ Pradesh",
"9167485", "Bhubaneshwar\,\ Odisha",
"9177037", "Manpur\,\ Madhya\ Pradesh",
"9161864", "Aurangabad\,\ Bihar",
"917360", "Shujalpur\,\ Madhya\ Pradesh",
"9168686", "Nandapur\,\ Odisha",
"9165427", "Bokaro\,\ Bihar",
"9167225", "Pardip\,\ Odisha",
"9177072", "Bagbahera\,\ Madhya\ Pradesh",
"9168195", "Surada\,\ Odisha",
"9166464", "Bargarh\,\ Odisha",
"915142", "Purwa\/Bighapur\,\ Uttar\ Pradesh",
"9174380", "Keshoraipatan\/Patan\,\ Rajasthan",
"912625", "Valod\,\ Gujarat",
"9177079", "Bagbahera\,\ Madhya\ Pradesh",
"913677", "Baithalangshu\,\ Assam",
"9176288", "Karpa\,\ Madhya\ Pradesh",
"9165322", "Giridih\,\ Bihar",
"9175913", "Sironj\,\ Madhya\ Pradesh",
"913873", "Thinghat\,\ Manipur",
"9167407", "Bhubaneshwar\,\ Odisha",
"9181730", "Sakleshpur\,\ Karnataka",
"9174594", "Ramganj\ Mandi\,\ Rajasthan",
"9166732", "Jayapatna\,\ Odisha",
"9173232", "Punasa\,\ Madhya\ Pradesh",
"9174374", "Nainwa\,\ Rajasthan",
"915274", "Tanda\/Baskhari\,\ Uttar\ Pradesh",
"918811", "Polavaram\,\ Andhra\ Pradesh",
"911473", "Barisadri\,\ Rajasthan",
"9168423", "Phulbani\,\ Odisha",
"9176366", "Baihar\,\ Madhya\ Pradesh",
"9176428", "Mandla\,\ Madhya\ Pradesh",
"911999", "Mahore\,\ Jammu\ And\ Kashmir",
"9174699", "Hindaun\,\ Rajasthan",
"915461", "Ghosi\,\ Uttar\ Pradesh",
"9166777", "Narlaroad\,\ Odisha",
"9174373", "Nainwa\,\ Rajasthan",
"911907", "Sundernagar\,\ Himachal\ Pradesh",
"912968", "Bagidora\,\ Rajasthan",
"916512", "Ranchi\,\ Bihar",
"912980", "Pachpadra\/Korna\,\ Rajasthan",
"9175390", "Ambah\,\ Madhya\ Pradesh",
"9168424", "Phulbani\,\ Odisha",
"918414", "Ibrahimpatnam\,\ Andhra\ Pradesh",
"918622", "Kovvur\,\ Andhra\ Pradesh",
"917561", "Ichhawar\,\ Madhya\ Pradesh",
"915864", "Sidhauli\/Mahmodabad\,\ Uttar\ Pradesh",
"918229", "Gundlupet\,\ Karnataka",
"9165345", "Jhumaritalaiya\,\ Bihar",
"9175957", "Nateran\,\ Madhya\ Pradesh",
"9171826", "Gondia\,\ Maharashtra",
"918505", "Kodangal\,\ Andhra\ Pradesh",
"9165367", "Palkot\,\ Bihar",
"9185860", "Vayalpad\,\ Andhra\ Pradesh",
"9166463", "Bargarh\,\ Odisha",
"918648", "Repalle\,\ Andhra\ Pradesh",
"9175914", "Sironj\,\ Madhya\ Pradesh",
"917759", "Korba\,\ Madhya\ Pradesh",
"913013", "Jaisalmer\/Dhanaua\,\ Rajasthan",
"918329", "Goa",
"9174593", "Ramganj\ Mandi\,\ Rajasthan",
"911702", "Nahan\,\ Himachal\ Pradesh",
"917849", "Baderajpur\,\ Madhya\ Pradesh",
"918664", "Vijayawada\,\ Andhra\ Pradesh",
"911781", "Rohru\,\ Himachal\ Pradesh",
"915822", "Baheri\,\ Uttar\ Pradesh",
"91451", "Dindigul\,\ Tamil\ Nadu",
"912690", "Balasinor\,\ Gujarat",
"9171663", "Chaurai\,\ Madhya\ Pradesh",
"9172879", "Gogaon\,\ Madhya\ Pradesh",
"9165602", "Patan\,\ Bihar",
"9165882", "Jagarnathpur\,\ Bihar",
"9177012", "Pingeshwar\,\ Madhya\ Pradesh",
"9176443", "Dindori\,\ Madhya\ Pradesh",
"91341", "Asansol\,\ West\ Bengal",
"9174820", "Raisen\,\ Madhya\ Pradesh",
"9162513", "Bagaha\,\ Bihar",
"91181", "Jallandhar\,\ Punjab",
"9161152", "Danapur\,\ Bihar",
"9171793", "Nagbhir\,\ Maharashtra",
"918396", "Siruguppa\,\ Karnataka",
"9167524", "Puri\,\ Odisha",
"9171386", "Dhanora\,\ Maharashtra",
"9162514", "Bagaha\,\ Bihar",
"9163275", "Rafiganj\,\ Bihar",
"9171794", "Nagbhir\,\ Maharashtra",
"9167865", "Chandbali\,\ Odisha",
"911382", "Lansdowne\/Kotdwara\,\ Uttarakhand",
"913784", "Nefra\,\ Arunachal\ Pradesh",
"9181706", "Alur\,\ Karnataka",
"918554", "Anantapur\,\ Andhra\ Pradesh",
"9167523", "Puri\,\ Odisha",
"9167847", "Bhadrak\,\ Odisha",
"9162275", "Mahua\,\ Bihar",
"9162557", "Raxaul\,\ Bihar",
"9168507", "Kalimela\,\ Odisha",
"9171664", "Chaurai\,\ Madhya\ Pradesh",
"9176444", "Dindori\,\ Madhya\ Pradesh",
"9165936", "Manoharpur\,\ Bihar",
"911282", "Narnaul\,\ Haryana",
"9168446", "Kantamal\,\ Odisha",
"918132", "Kunigal\,\ Karnataka",
"9171844", "Bhandara\,\ Maharashtra",
"9167667", "Keonjhar\,\ Odisha",
"912878", "Mangrol\,\ Gujarat",
"911692", "Tohana\,\ Haryana",
"9166753", "T\.Rampur\,\ Odisha",
"913779", "Roing\/Mariso\,\ Arunachal\ Pradesh",
"917731", "Gunnore\,\ Madhya\ Pradesh",
"9167645", "Anugul\,\ Odisha",
"9174313", "Aklera\,\ Rajasthan",
"918455", "Sangareddy\,\ Andhra\ Pradesh",
"9168585", "Nowrangapur\,\ Odisha",
"9165503", "Hunterganj\,\ Bihar",
"9171562", "Talegaokarangal\,\ Maharashtra",
"914254", "Mettupalayam\,\ Tamil\ Nadu",
"9171527", "Wardha\,\ Maharashtra",
"9181708", "Alur\,\ Karnataka",
"9174314", "Aklera\,\ Rajasthan",
"9166717", "Rajkhariar\,\ Odisha",
"911896", "Churah\/Tissa\,\ Himachal\ Pradesh",
"912135", "Rajgurunagar\,\ Maharashtra",
"9165504", "Hunterganj\,\ Bihar",
"918613", "Nellore\,\ Andhra\ Pradesh",
"917232", "Yeotmal\,\ Maharashtra",
"9167622", "Dhenkanal\,\ Odisha",
"913671", "Diphu\,\ Assam",
"9174357", "Gangdhar\,\ Rajasthan",
"9177019", "Pingeshwar\,\ Madhya\ Pradesh",
"9173217", "Sanwer\,\ Madhya\ Pradesh",
"912452", "Parbhani\,\ Maharashtra",
"9171843", "Bhandara\,\ Maharashtra",
"9166754", "T\.Rampur\,\ Odisha",
"9172872", "Gogaon\,\ Madhya\ Pradesh",
"917853", "Bijapur\,\ Madhya\ Pradesh",
"9174613", "Mahuwa\,\ Rajasthan",
"918705", "Warangal\,\ Andhra\ Pradesh",
"9171095", "Kamptee\,\ Maharashtra",
"9166243", "Rajgangpur\,\ Odisha",
"912473", "Kallam\,\ Maharashtra",
"9176406", "Shahpur\,\ Madhya\ Pradesh",
"917761", "Tapkara\,\ Madhya\ Pradesh",
"917537", "Jora\,\ Madhya\ Pradesh",
"9173923", "Jhabua\,\ Madhya\ Pradesh",
"9163312", "Imamganj\,\ Bihar",
"918441", "Sedam\,\ Karnataka",
"912999", "Jaisalmer\/Nehdai\,\ Rajasthan",
"9164252", "Katoria\,\ Bihar",
"9171772", "Brahmapuri\,\ Maharashtra",
"916712", "Cuttack\,\ Odisha",
"911502", "Nohar\/Jedasar\,\ Rajasthan",
"9181744", "Arsikere\,\ Karnataka",
"9168176", "R\.Udayigiri\,\ Odisha",
"9171423", "Bhimpur\,\ Madhya\ Pradesh",
"9174707", "Bundi\,\ Rajasthan",
"9171737", "Rajura\,\ Maharashtra",
"9164535", "Araria\,\ Bihar",
"9161505", "Hathua\,\ Bihar",
"9181743", "Arsikere\,\ Karnataka",
"9165407", "Govindpur\,\ Bihar",
"9174519", "Atru\,\ Rajasthan",
"9167322", "Hindol\,\ Odisha",
"9174657", "Sapotra\,\ Rajasthan",
"9171424", "Bhimpur\,\ Madhya\ Pradesh",
"915680", "Bharthana\,\ Uttar\ Pradesh",
"917362", "Agar\,\ Madhya\ Pradesh",
"9164556", "Forbesganj\,\ Bihar",
"91469", "Tiruvalla\,\ Kerala",
"911980", "Nobra\,\ Jammu\ And\ Kashmir",
"912907", "Kherwara\,\ Rajasthan",
"9174614", "Mahuwa\,\ Rajasthan",
"9174218", "Manasa\,\ Madhya\ Pradesh",
"914143", "Virudhachalam\,\ Tamil\ Nadu",
"9166244", "Rajgangpur\,\ Odisha",
"918844", "Kakinada\,\ Andhra\ Pradesh",
"917262", "Buldhana\,\ Maharashtra",
"9173924", "Jhabua\,\ Madhya\ Pradesh",
"9171975", "Mohadi\,\ Maharashtra",
"912165", "Dhiwadi\,\ Maharashtra",
"9161326", "Barh\,\ Bihar",
"9165485", "Ichak\,\ Bihar",
"918593", "Medarmetla\,\ Andhra\ Pradesh",
"9167287", "Jajapur\ Town\,\ Odisha",
"9174855", "Udaipura\,\ Madhya\ Pradesh",
"911344", "Dhampur\,\ Uttar\ Pradesh",
"9162453", "Gogri\,\ Bihar",
"9168403", "Tumudibandha\,\ Odisha",
"9176408", "Shahpur\,\ Madhya\ Pradesh",
"9165302", "Bundu\,\ Bihar",
"9165225", "Muri\,\ Bihar",
"9171363", "Etapalli\,\ Maharashtra",
"9165546", "Rajdhanwar\,\ Bihar",
"918634", "Guntur\,\ Andhra\ Pradesh",
"911587", "Degana\,\ Rajasthan",
"915443", "Chunur\,\ Uttar\ Pradesh",
"912829", "Maliya\ Miyana\,\ Gujarat",
"9163453", "Jamui\,\ Bihar",
"9174512", "Atru\,\ Rajasthan",
"912712", "Gandhi\ Nagar\,\ Gujarat",
"9171364", "Etapalli\,\ Maharashtra",
"912326", "Gaganbavada\,\ Maharashtra",
"917543", "Ashoknagar\,\ Madhya\ Pradesh",
"9163454", "Jamui\,\ Bihar",
"9176565", "Kannodi\,\ Madhya\ Pradesh",
"918620", "Udaygiri\,\ Andhra\ Pradesh",
"918715", "Mulug\,\ Andhra\ Pradesh",
"913241", "Gangajalghati\,\ West\ Bengal",
"9171686", "Harrai\,\ Madhya\ Pradesh",
"9165242", "Gumla\,\ Bihar",
"9171806", "Salekasa\,\ Maharashtra",
"9163417", "Seikhpura\,\ Bihar",
"912982", "Barmer\,\ Rajasthan",
"9174216", "Manasa\,\ Madhya\ Pradesh",
"9168404", "Tumudibandha\,\ Odisha",
"9162454", "Gogri\,\ Bihar",
"9161587", "Sonepur\,\ Bihar",
"9168466", "Baliguda\,\ Odisha",
"911262", "Rohtak\,\ Haryana",
"911669", "Adampur\ Mandi\,\ Haryana",
"912561", "Pimpalner\,\ Maharashtra",
"9176323", "Balaghat\,\ Madhya\ Pradesh",
"914112", "Kancheepuram\,\ Tamil\ Nadu",
"9164762", "Madhepura\,\ Bihar",
"9171864", "Sakoli\,\ Maharashtra",
"9168587", "Nowrangapur\,\ Odisha",
"9167647", "Anugul\,\ Odisha",
"912737", "Tharad\,\ Gujarat",
"912759", "Lakhtar\,\ Gujarat",
"912932", "Pali\,\ Rajasthan",
"9167665", "Keonjhar\,\ Odisha",
"9171134", "Saoner\,\ Maharashtra",
"911491", "Nasirabad\,\ Rajasthan",
"914256", "Bhavani\,\ Tamil\ Nadu",
"911676", "Sunam\,\ Punjab",
"9174336", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"913472", "Krishna\ Nagar\,\ West\ Bengal",
"9166426", "Kuchinda\,\ Odisha",
"9127172", "Sanand\,\ Gujarat",
"911894", "Palampur\,\ Himachal\ Pradesh",
"9173215", "Sanwer\,\ Madhya\ Pradesh",
"9171133", "Saoner\,\ Maharashtra",
"911559", "Rajgarh\,\ Rajasthan",
"914633", "Tenkasi\,\ Tamil\ Nadu",
"9174355", "Gangdhar\,\ Rajasthan",
"915195", "Mau\/Rajapur\,\ Uttar\ Pradesh",
"9174620", "Sawaimadhopur\,\ Rajasthan",
"9176324", "Balaghat\,\ Madhya\ Pradesh",
"911537", "Nohar\/Rawatsar\,\ Rajasthan",
"9181931", "Hiriyur\,\ Karnataka",
"9163496", "Jhajha\,\ Bihar",
"9166715", "Rajkhariar\,\ Odisha",
"91423", "Udhagamandalam\,\ Tamil\ Nadu",
"9165682", "Balumath\,\ Bihar",
"912698", "Khambat\,\ Gujarat",
"9171863", "Sakoli\,\ Maharashtra",
"911872", "Quadian\,\ Punjab",
"916743", "Bhubaneshwar\,\ Odisha",
"918935", "Paderu\,\ Andhra\ Pradesh",
"918684", "Suryapet\,\ Andhra\ Pradesh",
"9171525", "Wardha\,\ Maharashtra",
"918666", "Vijayawada\,\ Andhra\ Pradesh",
"9165914", "Chandil\,\ Bihar",
"9171643", "Pandhurna\,\ Madhya\ Pradesh",
"9164593", "Thakurganj\,\ Bihar",
"9176463", "Nainpur\,\ Madhya\ Pradesh",
"913595", "Gauzing\/Nayabazar\,\ West\ Bengal",
"9167822", "Balasore\,\ Odisha",
"918372", "Gadag\,\ Karnataka",
"9165584", "Dumri\(Isribazar\)\,\ Bihar",
"9161826", "Arrah\,\ Bihar",
"9174338", "Pachpahar\/Bhawanimandi\,\ Rajasthan",
"9164373", "Mahagama\,\ Bihar",
"9162536", "Narkatiaganj\,\ Bihar",
"9171033", "Butibori\,\ Maharashtra",
"917512", "Gwalior\,\ Madhya\ Pradesh",
"9176810", "Jatara\,\ Madhya\ Pradesh",
"918394", "Hospet\,\ Karnataka",
"918272", "Madikeri\,\ Karnataka",
"912375", "Pusegaon\,\ Maharashtra",
"9175900", "Lateri\,\ Madhya\ Pradesh",
"918862", "Razole\,\ Andhra\ Pradesh",
"9165583", "Dumri\(Isribazar\)\,\ Bihar",
"9163232", "Dumraon\,\ Bihar",
"9168505", "Kalimela\,\ Odisha",
"9162555", "Raxaul\,\ Bihar",
"915412", "Chandauli\/Mugalsarai\,\ Uttar\ Pradesh",
"9171034", "Butibori\,\ Maharashtra",
"9162277", "Mahua\,\ Bihar",
"9167845", "Bhadrak\,\ Odisha",
"9164374", "Mahagama\,\ Bihar",
"913786", "Khonsa\,\ Arunachal\ Pradesh",
"918556", "Hindupur\,\ Andhra\ Pradesh",
"912870", "Malia\ Hatina\,\ Gujarat",
"9165913", "Chandil\,\ Bihar",
"913227", "Amlagora\,\ West\ Bengal",
"9167867", "Chandbali\,\ Odisha",
"9164594", "Thakurganj\,\ Bihar",
"9171644", "Pandhurna\,\ Madhya\ Pradesh",
"9176464", "Nainpur\,\ Madhya\ Pradesh",
"9163277", "Rafiganj\,\ Bihar",
"9162232", "Motipur\,\ Bihar",
"913713", "Mangaldoi\,\ Assam",
"911924", "Akhnoor\,\ Jammu\ And\ Kashmir",
"9174638", "Gangapur\,\ Rajasthan",
"912185", "Malsuras\,\ Maharashtra",
"917689", "Badamalhera\,\ Madhya\ Pradesh",
"917282", "Khargone\,\ Madhya\ Pradesh",
"9174234", "Neemuch\,\ Madhya\ Pradesh",
"9176522", "Shahdol\,\ Madhya\ Pradesh",
"9165227", "Muri\,\ Bihar",
"911346", "Pauri\/Bubakhal\,\ Uttarakhand",
"9174814", "Gairatganj\,\ Madhya\ Pradesh",
"911960", "Nowshera\,\ Jammu\ And\ Kashmir",
"9164673", "Banmankhi\,\ Bihar",
"9174909", "Pohari\,\ Madhya\ Pradesh",
"9171343", "Bhamregadh\,\ Maharashtra",
"918117", "Kanakapura\,\ Karnataka",
"913522", "Balurghat\,\ West\ Bengal",
"9165566", "Tisri\,\ Bihar",
"918636", "Guntur\,\ Andhra\ Pradesh",
"9111", "New\ Delhi",
"915688", "Etawah\,\ Uttar\ Pradesh",
"9167974", "Jashipur\,\ Odisha",
"9140", "Hyderabad\ Local\,\ Andhra\ Pradesh",
"9174857", "Udaipura\,\ Madhya\ Pradesh",
"9167285", "Jajapur\ Town\,\ Odisha",
"9165487", "Ichak\,\ Bihar",
"912835", "Nakhatrana\,\ Gujarat",
"9182203", "Gundlupet\,\ Karnataka",
"9168626", "Gudari\,\ Odisha",
"918253", "Hebri\,\ Karnataka",
"9171344", "Bhamregadh\,\ Maharashtra",
"9161585", "Sonepur\,\ Bihar",
"9166796", "Komana\,\ Odisha",
"9162726", "Darbhanga\,\ Bihar",
"9163415", "Seikhpura\,\ Bihar",
"9174146", "Jaora\,\ Madhya\ Pradesh",
"914549", "Thirumanglam\,\ Tamil\ Nadu",
"912324", "Hatkangale\/Ichalkaranji\,\ Maharashtra",
"9167973", "Jashipur\,\ Odisha",
"9182204", "Gundlupet\,\ Karnataka",
"918182", "Shimoga\,\ Karnataka",
"918832", "Rajahmundri\,\ Andhra\ Pradesh",
"914735", "Ranni\,\ Kerala",
"9176567", "Kannodi\,\ Madhya\ Pradesh",
"918353", "Jamkhandi\,\ Karnataka",
"917723", "Mahasamund\,\ Madhya\ Pradesh",
"9174233", "Neemuch\,\ Madhya\ Pradesh",
"911975", "Una\,\ Himachal\ Pradesh",
"9165262", "Lohardaga\,\ Bihar",
"9176486", "Mawai\,\ Madhya\ Pradesh",
"917781", "Narainpur\,\ Madhya\ Pradesh",
"918577", "Putturu\,\ Andhra\ Pradesh",
"9187596", "Outsarangapalle\,\ Andhra\ Pradesh",
"9173296", "Khakner\,\ Madhya\ Pradesh",
"9164674", "Banmankhi\,\ Bihar",
"9174813", "Gairatganj\,\ Madhya\ Pradesh",
"9161507", "Hathua\,\ Bihar",
"9168484", "Kotagarh\,\ Odisha",
"9164537", "Araria\,\ Bihar",
"9171735", "Rajura\,\ Maharashtra",
"9174705", "Bundi\,\ Rajasthan",
"912962", "Banswara\,\ Rajasthan",
"911332", "Roorkee\,\ Uttarakhand",
"9166263", "Banaigarh\,\ Odisha",
"9166846", "Paikamal\,\ Odisha",
"911853", "Rayya\,\ Punjab",
"9171606", "Jamai\,\ Madhya\ Pradesh",
"9174636", "Gangapur\,\ Rajasthan",
"918628", "Chejerla\,\ Andhra\ Pradesh",
"9168224", "Aska\,\ Odisha",
"9164572", "Korha\,\ Bihar",
"9181764", "Cannarayapatna\,\ Karnataka",
"911232", "Modinagar\,\ Uttar\ Pradesh",
"914553", "Oddanchatram\,\ Tamil\ Nadu",
"911639", "Faridakot\,\ Punjab",
"913453", "Katwa\,\ West\ Bengal",
"91487", "Thrissur\,\ Kerala",
"912767", "Sidhpur\,\ Gujarat",
"9171097", "Kamptee\,\ Maharashtra",
"918642", "Guntur\ Palnad\/Macherala\,\ Andhra\ Pradesh",
"918199", "Hosadurga\,\ Karnataka",
"918249", "Mangalore\,\ Karnataka",
"9181763", "Cannarayapatna\,\ Karnataka",
"9168223", "Aska\,\ Odisha",
"917674", "Maihar\,\ Madhya\ Pradesh",
"9168152", "Parlakhemundi\,\ Odisha",
"9171977", "Mohadi\,\ Maharashtra",
"9174320", "Jhalawar\,\ Rajasthan",
"911567", "Ratangarh\,\ Rajasthan",
"911731", "Barara\,\ Haryana",
"918965", "Gajapathinagaram\,\ Andhra\ Pradesh",
"9174148", "Jaora\,\ Madhya\ Pradesh",
"9165382", "Torpa\,\ Bihar",
"9189466", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"9176529", "Shahdol\,\ Madhya\ Pradesh",
"9176488", "Mawai\,\ Madhya\ Pradesh",
"912645", "Jhagadia\,\ Gujarat",
"9173298", "Khakner\,\ Madhya\ Pradesh",
"9171756", "Bhadrawati\,\ Maharashtra",
"915251", "Kaisarganj\/Kaiserganj\,\ Uttar\ Pradesh",
"9164276", "Kathikund\,\ Bihar",
"9168483", "Kotagarh\,\ Odisha",
"9174902", "Pohari\,\ Madhya\ Pradesh",
"9166264", "Banaigarh\,\ Odisha",
"917692", "Seoni\,\ Madhya\ Pradesh",
"918846", "Kakinada\,\ Andhra\ Pradesh",
"9174655", "Sapotra\,\ Rajasthan",
"9165405", "Govindpur\,\ Bihar",
"9174124", "Ratlam\,\ Madhya\ Pradesh",
"9162475", "Singhwara\,\ Bihar",
"9162744", "Samastipur\,\ Bihar",
"917326", "Baldi\,\ Madhya\ Pradesh",
"9165845", "Bishrampur\,\ Bihar",
"9171326", "Gadchiroli\,\ Maharashtra",
"913465", "Nalhati\,\ West\ Bengal",
"9174873", "Begamganj\,\ Madhya\ Pradesh",
"914565", "Karaikudi\,\ Tamil\ Nadu",
"9167583", "Nimapara\,\ Odisha",
"912930", "Bilara\/Piparcity\,\ Rajasthan",
"9168643", "Mathili\,\ Odisha",
"911360", "Dehradun\ Chakrata\/Dakpattar\,\ Uttarakhand",
"9164614", "Raniganj\,\ Bihar",
"918571", "Madanapalli\,\ Andhra\ Pradesh",
"917787", "Jarwa\,\ Madhya\ Pradesh",
"915646", "Baseri\,\ Rajasthan",
"9163475", "Chakai\,\ Bihar",
"917226", "Dharani\,\ Maharashtra",
"913513", "Harishchandrapur\,\ West\ Bengal",
"9174556", "Digod\/Sultanpur\,\ Rajasthan",
"9176303", "Katangi\,\ Madhya\ Pradesh",
"9165867", "Chainpur\,\ Bihar",
"9167913", "Bangiriposi\,\ Odisha",
"915164", "Kalpi\,\ Uttar\ Pradesh",
"9165822", "Chaibasa\,\ Bihar",
"918111", "Hosakote\,\ Karnataka",
"911870", "Jugial\,\ Punjab",
"911275", "Palwal\,\ Haryana",
"913795", "Basar\,\ Arunachal\ Pradesh",
"9174535", "Baran\,\ Rajasthan",
"9176304", "Katangi\,\ Madhya\ Pradesh",
"9174600", "Sahabad\,\ Rajasthan",
"917917", "Ahmedabad\ Local\,\ Gujarat",
"912924", "Phalodi\/Baroo\,\ Rajasthan",
"9167914", "Bangiriposi\,\ Odisha",
"9162743", "Samastipur\,\ Bihar",
"911375", "Rajgarhi\,\ Uttarakhand",
"9174123", "Ratlam\,\ Madhya\ Pradesh",
"9174252", "Garoth\,\ Madhya\ Pradesh",
"915842", "Shahjahanpur\,\ Uttar\ Pradesh",
"9164613", "Raniganj\,\ Bihar",
"9168644", "Mathili\,\ Odisha",
"9167957", "Udala\,\ Odisha",
"9167584", "Nimapara\,\ Odisha",
"9174874", "Begamganj\,\ Madhya\ Pradesh",
"911743", "Cheeka\,\ Haryana",
"9166406", "Bagdihi\,\ Odisha",
"911932", "Anantnag\,\ Jammu\ And\ Kashmir",
"912362", "Kudal\,\ Maharashtra",
"917510", "Gwalior\,\ Madhya\ Pradesh",
"9164785", "Saharsa\,\ Bihar",
"9164216", "Naugachia\,\ Bihar",
"9171587", "Deoli\,\ Maharashtra",
"9166547", "Sonapur\,\ Odisha",
"917238", "Darwaha\,\ Maharashtra",
"912676", "Halol\,\ Gujarat",
"9171466", "Ghorandogri\,\ Madhya\ Pradesh",
"9174259", "Garoth\,\ Madhya\ Pradesh",
"9161806", "Adhaura\,\ Bihar",
"911561", "Taranagar\,\ Rajasthan",
"913654", "Nongstoin\,\ Meghalaya",
"912669", "Chhota\ Udaipur\,\ Gujarat",
"9166823", "Attabira\,\ Odisha",
"9168542", "Jeypore\,\ Odisha",
"9167682", "Parajang\,\ Odisha",
"918370", "Kalghatagi\,\ Karnataka",
"9174558", "Digod\/Sultanpur\,\ Rajasthan",
"918138", "Koratageri\,\ Karnataka",
"9166824", "Attabira\,\ Odisha",
"9165647", "Nagarutari\,\ Bihar",
"9164512", "Barsoi\,\ Bihar",
"912872", "Vanthali\,\ Gujarat",
"911698", "Ellenabad\,\ Haryana",
"914371", "Arantangi\,\ Tamil\ Nadu",
"9175225", "Datia\,\ Madhya\ Pradesh",
"917473", "Bundi\,\ Rajasthan",
"918365", "Hubli\,\ Karnataka",
"912761", "Kheralu\,\ Gujarat",
"915113", "Bhognipur\/Pakhrayan\,\ Uttar\ Pradesh",
"9168525", "Koraput\,\ Odisha",
"91496", "Vatakara\,\ Kerala",
"917201", "Kalamb\,\ Maharashtra",
"9175920", "Vidisha\,\ Madhya\ Pradesh",
"9165665", "Japla\,\ Bihar",
"912894", "Kalawad\,\ Gujarat",
"911651", "Phulmandi\,\ Punjab",
"913564", "Alipurduar\,\ West\ Bengal",
"915836", "Gunnaur\,\ Uttar\ Pradesh",
"912559", "Yeola\,\ Maharashtra",
"918265", "Koppa\,\ Karnataka",
"9166444", "Rairakhol\,\ Odisha",
"9166775", "Narlaroad\,\ Odisha",
"9175936", "Kurwai\,\ Madhya\ Pradesh",
"9168606", "Boriguma\,\ Odisha",
"911531", "Nokha\,\ Rajasthan",
"9177058", "Kurud\,\ Madhya\ Pradesh",
"914181", "Polur\,\ Tamil\ Nadu",
"913809", "Sagalee\,\ Arunachal\ Pradesh",
"917368", "Ghatia\,\ Madhya\ Pradesh",
"915662", "Chhata\/Kosikalan\,\ Uttar\ Pradesh",
"9171484", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9167405", "Bhubaneshwar\,\ Odisha",
"9176502", "Beohari\,\ Madhya\ Pradesh",
"9174929", "Shivpuri\,\ Madhya\ Pradesh",
"9176346", "Lamta\,\ Madhya\ Pradesh",
"911962", "Rajouri\,\ Jammu\ And\ Kashmir",
"91257", "Jalgaon\,\ Maharashtra",
"917280", "Barwaha\,\ Madhya\ Pradesh",
"917268", "Mekhar\,\ Maharashtra",
"91177", "Shimla\,\ Himachal\ Pradesh",
"918416", "Vikrabad\,\ Andhra\ Pradesh",
"918830", "Rajahmundri\,\ Andhra\ Pradesh",
"9171152", "Mouda\,\ Maharashtra",
"9165365", "Palkot\,\ Bihar",
"911497", "Kishangarh\,\ Rajasthan",
"9165347", "Jhumaritalaiya\,\ Bihar",
"9166443", "Rairakhol\,\ Odisha",
"9175955", "Nateran\,\ Madhya\ Pradesh",
"912567", "Taloda\,\ Maharashtra",
"918180", "Basavapatna\,\ Karnataka",
"918483", "Humnabad\,\ Karnataka",
"911508", "Suratgarh\/Goluwala\,\ Rajasthan",
"915945", "Haldwani\/Chorgalian\,\ Uttar\ Pradesh",
"918335", "Ramdurg\,\ Karnataka",
"9171483", "Prabha\ Pattan\,\ Madhya\ Pradesh",
"9177056", "Kurud\,\ Madhya\ Pradesh",
"9165442", "Gomia\,\ Bihar",
"9161843", "Sasaram\,\ Bihar",
"9165973", "Saraikela\/Adstyapur\,\ Bihar",
"913221", "Jhargram\,\ West\ Bengal",
"918640", "Krosuru\,\ Andhra\ Pradesh",
"9174945", "Kolaras\,\ Madhya\ Pradesh",
"9164357", "Pakur\,\ Bihar",
"9175938", "Kurwai\,\ Madhya\ Pradesh",
"9171626", "Chhindwara\,\ Madhya\ Pradesh",
"918777", "Tirupathi\,\ Andhra\ Pradesh",
"91368", "Passighat\,\ Arunachal\ Pradesh",
"918406", "Cumbum\,\ Andhra\ Pradesh",
"917581", "Khurai\,\ Madhya\ Pradesh",
"9174967", "Pichhore\,\ Madhya\ Pradesh",
"9164295", "Kahalgaon\,\ Bihar",
"9174240", "Malhargarh\,\ Madhya\ Pradesh",
"9167262", "Jajapur\ Road\,\ Odisha",
"9161527", "Chapra\,\ Bihar",
"9171052", "Narkhed\,\ Maharashtra",
"9161116", "Hilsa\,\ Bihar",
"9163254", "Pakribarwan\,\ Bihar",
"917523", "Bhander\,\ Madhya\ Pradesh",
"912988", "Pachpadra\/Balotra\,\ Rajasthan",
"9164314", "Jharmundi\,\ Bihar",
"912960", "Sojat\,\ Rajasthan",
"913216", "Habra\,\ West\ Bengal",
"9176348", "Lamta\,\ Madhya\ Pradesh",
"912346", "Tasgaon\,\ Maharashtra",
"9168197", "Surada\,\ Odisha",
"9161562", "Gopalganj\,\ Bihar",
"9167227", "Pardip\,\ Odisha",
"9165425", "Bokaro\,\ Bihar",
"912975", "Reodar\,\ Rajasthan",
"9163253", "Pakribarwan\,\ Bihar",
"9176509", "Beohari\,\ Madhya\ Pradesh",
"912849", "Botad\,\ Gujarat",
"9174922", "Shivpuri\,\ Madhya\ Pradesh",
"917690", "Lakhnadon\,\ Madhya\ Pradesh",
"9164313", "Jharmundi\,\ Bihar",
"9161844", "Sasaram\,\ Bihar",
"9177035", "Manpur\,\ Madhya\ Pradesh",
"9167487", "Bhubaneshwar\,\ Odisha",
"9165285", "Khunti\,\ Bihar",
"9165974", "Saraikela\/Adstyapur\,\ Bihar",
"912718", "Bareja\,\ Gujarat",
"9167566", "Balugaon\,\ Odisha",
"9174300", "Khanpur\,\ Rajasthan",
"9165893", "Jhinkpani\,\ Bihar",
"912562", "Dhule\,\ Maharashtra",
"9165356", "Chainpur\,\ Bihar",
"914111", "Sriperumbudur\,\ Tamil\ Nadu",
"9168186", "Buguda\,\ Odisha",
"911474", "Begun\,\ Rajasthan",
"915273", "Tandai\/Tanda\,\ Uttar\ Pradesh",
"9173242", "Mhow\,\ Madhya\ Pradesh",
"9168695", "Papadhandi\,\ Odisha",
"912931", "Jodhpur\/Jhanwar\,\ Rajasthan",
"917815", "Kathghora\,\ Madhya\ Pradesh",
"9181740", "Arsikere\,\ Karnataka",
"915745", "Jalesar\,\ Uttar\ Pradesh",
"913874", "Churchandpur\,\ Manipur",
"918570", "Kuppam\,\ Andhra\ Pradesh",
"911492", "Laxmangarh\/Kherli\,\ Rajasthan",
"9164753", "S\.Bakhtiarpur\,\ Bihar",
"9167496", "Bhubaneshwar\,\ Odisha",
"9175966", "Gyraspur\,\ Madhya\ Pradesh",
"9171782", "Sinderwahi\,\ Maharashtra",
"912908", "Amet\,\ Rajasthan",
"9174979", "Khaniadhana\,\ Madhya\ Pradesh",
"913014", "Jaisalmer\/Khuri\,\ Rajasthan",
"9171852", "Pauni\,\ Maharashtra",
"9166416", "Deodgarh\,\ Odisha",
"913471", "Karimpur\,\ West\ Bengal",
"9176357", "Lanji\,\ Madhya\ Pradesh",
"9171985", "Tirora\,\ Maharashtra",
"91360", "Itanagar\/Ziro\,\ Arunachal\ Pradesh",
"9164754", "S\.Bakhtiarpur\,\ Bihar",
"9173225", "Depalpur\,\ Madhya\ Pradesh",
"918565", "Rajampeta\,\ Andhra\ Pradesh",
"9176459", "Karanjia\,\ Madhya\ Pradesh",
"9165894", "Jhinkpani\,\ Bihar",
"9174610", "Mahuwa\,\ Rajasthan",
"9165335", "Basia\,\ Bihar",
"9162795", "Barauni\,\ Bihar",
"9166725", "Dharamgarh\,\ Odisha",
"915863", "Biswan\,\ Uttar\ Pradesh",
"918413", "Hyderabad\ West\/Shamshabad\,\ Andhra\ Pradesh",
"911871", "Batala\,\ Punjab",
"918110", "Anekal\,\ Karnataka",
"9176295", "Pushprajgarh\,\ Madhya\ Pradesh",
"9173920", "Jhabua\,\ Madhya\ Pradesh",
"9171515", "Samudrapur\,\ Maharashtra",
"9189461", "Pathapatnam\/Hiramandalam\,\ Andhra\ Pradesh",
"911762", "Rajpura\,\ Punjab",
"9164717", "Birpur\,\ Bihar",
"912359", "Guhagar\,\ Maharashtra",
"913213", "Dhaniakhali\,\ West\ Bengal",
"912343", "Atpadi\,\ Maharashtra",
"9167232", "Athgarh\,\ Odisha",
"9174937", "Karera\,\ Madhya\ Pradesh",
"914365", "Nagapattinam\,\ Tamil\ Nadu",
"918403", "Yerragondapalem\,\ Andhra\ Pradesh",
"911588", "Parbatsar\/Makrana\,\ Rajasthan",
"911560", "Sujangarh\/Bidasar\,\ Rajasthan",
"912775", "Khedbrahma\,\ Gujarat",
"9161143", "Jahanabad\,\ Bihar",
"918371", "Mundargi\,\ Karnataka",
"9167812", "Basta\,\ Odisha",
"9165475", "Chavparan\,\ Bihar",
"9176452", "Karanjia\,\ Madhya\ Pradesh",
"9161816", "Piro\,\ Bihar",
"9167555", "Khurda\,\ Odisha",
"9175968", "Gyraspur\,\ Madhya\ Pradesh",
"918464", "Madnur\,\ Andhra\ Pradesh",
"9167277", "Kendrapara\,\ Odisha",
"9174972", "Khaniadhana\,\ Madhya\ Pradesh",
"91361", "Guwahati\,\ Assam",
"917744", "Rajandgaon\,\ Madhya\ Pradesh",
"9164206", "Amarpur\,\ Bihar",
"918772", "Tirupathi\,\ Andhra\ Pradesh",
"917805", "Singrauli\,\ Madhya\ Pradesh",
"9167536", "Nayagarh\,\ Odisha",
"9171676", "Amarwada\,\ Madhya\ Pradesh",
"911489", "Mandalgarh\,\ Rajasthan",
"9161577", "Mairwa\,\ Bihar",
"9177065", "Gariaband\,\ Madhya\ Pradesh",
"9177047", "Deobhog\,\ Madhya\ Pradesh",
"911575", "Srimadhopur\,\ Rajasthan",
"9173249", "Mhow\,\ Madhya\ Pradesh",
"9164346", "Dumka\,\ Bihar",
"9161532", "Maharajganj\,\ Bihar",
"9161144", "Jahanabad\,\ Bihar",
"9163442", "Monghyr\,\ Bihar",
"917281", "Sendhwa\,\ Madhya\ Pradesh",
"9181759", "Holenarasipur\,\ Karnataka",
"9165837", "Kharsawa\,\ Bihar",
"9167415", "Bhubaneshwar\,\ Odisha",
"9176512", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9173938", "Jobat\,\ Madhya\ Pradesh",
"9167946", "Rairangpur\,\ Odisha",
"917223", "Achalpur\,\ Maharashtra",
"9174824", "Raisen\,\ Madhya\ Pradesh",
"915643", "Nadbai\,\ Rajasthan",
"9162442", "Khagaria\,\ Bihar",
"9165872", "Chakardharpur\,\ Bihar",
"9172889", "Bhikangaon\,\ Madhya\ Pradesh",
"913521", "Gangarampur\,\ West\ Bengal",
"9184533", "Medak\,\ Andhra\ Pradesh",
"9165254", "Simdega\,\ Bihar",
"913583", "Mathabhanga\,\ West\ Bengal",
"9168616", "Malkangiri\,\ Odisha",
"918753", "Outsarangapalle\,\ Andhra\ Pradesh",
"917912", "Ahmedabad\ Local\,\ Gujarat",
"911746", "Kaithal\,\ Haryana",
"9163425", "H\.Kharagpur\,\ Bihar",
"9162285", "Pupri\,\ Bihar",
"9162716", "Benipatti\,\ Bihar",
"9174547", "Chhipaborad\,\ Rajasthan",
"9165253", "Simdega\,\ Bihar",
"9184534", "Medak\,\ Andhra\ Pradesh",
"918181", "Thirthahalli\,\ Karnataka",
"9181938", "Hiriyur\,\ Karnataka",
"9171376", "Desaiganj\,\ Maharashtra",
"9163285", "Daudnagar\,\ Bihar",
"9162425", "Benipur\,\ Bihar",
"9166495", "Jamankira\,\ Odisha",
"9176440", "Dindori\,\ Madhya\ Pradesh",
"9174565", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"917782", "Jagdalpur\,\ Madhya\ Pradesh",
"9174823", "Raisen\,\ Madhya\ Pradesh",
"911425", "Phulera\/Sambhar\,\ Rajasthan",
"9173936", "Jobat\,\ Madhya\ Pradesh",
"9168575", "Gunupur\,\ Odisha",
"912961", "Ghatol\,\ Rajasthan",
"9161895", "Bhabhua\,\ Bihar",
"911331", "Nakur\/Gangoh\,\ Uttar\ Pradesh",
"9166535", "Dunguripali\,\ Odisha",
"9168164", "Mohana\,\ Odisha",
"91227", "Mumbai",
"917580", "Bina\,\ Madhya\ Pradesh",
"9171436", "Bhainsdehi\,\ Madhya\ Pradesh",
"912673", "Dahod\,\ Gujarat",
"9164243", "Banka\,\ Bihar",
"9168214", "Bhanjanagar\,\ Odisha",
"9165656", "Latehar\,\ Bihar",
"9166252", "Lahunipara\,\ Odisha",
"91476", "Karunagapally\,\ Kerala",
"912877", "Talala\,\ Gujarat",
"918641", "Sattenapalli\,\ Andhra\ Pradesh",
"913825", "Khowai\,\ Tripura",
"913220", "Contai\,\ West\ Bengal",
"9168213", "Bhanjanagar\,\ Odisha",
"917658", "Kotma\,\ Madhya\ Pradesh",
"9164244", "Banka\,\ Bihar",
"915833", "Sahaswan\,\ Uttar\ Pradesh",
"9171455", "Chicholi\,\ Madhya\ Pradesh",
"918749", "Madhira\,\ Andhra\ Pradesh",
"9165635", "Bhawanathpur\,\ Bihar",
"9174310", "Aklera\,\ Rajasthan",
"911732", "Jagadhari\,\ Haryana",
"9163365", "Rajauli\,\ Bihar",
"9172882", "Bhikangaon\,\ Madhya\ Pradesh",
"91286", "Porbander\,\ Gujarat",
"918818", "Tadepalligudem\,\ Andhra\ Pradesh",
"915252", "Bahraich\/Bahrailh\,\ Uttar\ Pradesh",
"917476", "Bundi\,\ Rajasthan",
"9173955", "Sondhwa\,\ Madhya\ Pradesh",
"917691", "Chhapara\,\ Madhya\ Pradesh",
"912367", "Kankavali\,\ Maharashtra",
"9166556", "Titlagarh\,\ Odisha",
"9168163", "Mohana\,\ Odisha",
"918535", "Sindhanur\,\ Karnataka",
"914994", "Kasaragod\,\ Kerala",
"9181752", "Holenarasipur\,\ Karnataka",
"915183", "Fatehpur\/Gazipur\,\ Uttar\ Pradesh",
"9171316", "Sironcha\,\ Maharashtra",
"918837", "Rajahmundri\,\ Andhra\ Pradesh",
"915444", "Robertsganj\,\ Uttar\ Pradesh",
"9162584", "Areraj\,\ Bihar",
"9174411", "Ladpura\/Kota\,\ Rajasthan",
"9182897", "Athani\,\ Karnataka",
"9164624", "Dhamdaha\,\ Bihar",
"918633", "Guntur\,\ Andhra\ Pradesh",
"9165536", "Ramgarh\,\ Bihar",
"912115", "Saswad\,\ Maharashtra",
"918572", "Chittoor\,\ Andhra\ Pradesh",
"9162776", "Phulparas\,\ Bihar",
"911343", "Nagina\,\ Uttar\ Pradesh",
"912560", "Kusumba\,\ Maharashtra",
"9174264", "Sitamau\,\ Madhya\ Pradesh",
"912588", "Erandul\,\ Maharashtra",
"914935", "Mananthavady\,\ Kerala",
"918187", "Shikaripura\,\ Karnataka",
"91164", "Bhatinda\,\ Punjab",
"918594", "Chirala\,\ Andhra\ Pradesh",
"9176276", "Manpur\,\ Madhya\ Pradesh",
"9167923", "Baripada\,\ Odisha",
"9174668", "Bonli\,\ Rajasthan",
"9171897", "Amagaon\,\ Maharashtra",
"9165812", "Bhandaria\,\ Bihar",
"91788", "Durg\,\ Madhya\ Pradesh",
"9174846", "Silwani\,\ Madhya\ Pradesh",
"9165232", "Ghaghra\,\ Bihar",
"9168676", "Jharigan\,\ Odisha",
"9174263", "Sitamau\,\ Madhya\ Pradesh",
"9166705", "Bhawanipatna\,\ Odisha",
"917726", "Bhatapara\,\ Madhya\ Pradesh",
"9167924", "Baripada\,\ Odisha",
"918356", "Muddebihal\,\ Karnataka",
"9176537", "Bandhavgarh\,\ Madhya\ Pradesh",
"9173205", "Pandhana\,\ Madhya\ Pradesh",
"9162583", "Areraj\,\ Bihar",
"915841", "Tilhar\,\ Uttar\ Pradesh",
"917544", "Raghogarh\,\ Madhya\ Pradesh",
"9165277", "Kolebira\,\ Bihar",
"912489", "Karjat\,\ Maharashtra",
"9164623", "Dhamdaha\,\ Bihar",
"918256", "Belthangady\,\ Karnataka",
"9176572", "Jaitpur\,\ Madhya\ Pradesh",
"9174384", "Keshoraipatan\/Patan\,\ Rajasthan",
"9164545", "Purnea\,\ Bihar",
"9171695", "Batkakhapa\,\ Madhya\ Pradesh",
"914862", "Thodupuzha\,\ Kerala",
"911931", "Kulgam\,\ Jammu\ And\ Kashmir",
"9171747", "Mul\,\ Maharashtra",
"9176579", "Jaitpur\,\ Madhya\ Pradesh",
"9164226", "Godda\,\ Bihar",
"9171186", "Kalmeshwar\,\ Maharashtra",
"9166787", "Nowparatan\,\ Odisha",
"9181734", "Sakleshpur\,\ Karnataka",
"917445", "Ladpura\/Kota\,\ Rajasthan",
"9174590", "Ramganj\ Mandi\,\ Rajasthan",
"9166813", "Jujumura\,\ Odisha",
"9176497", "Kakaiya\,\ Madhya\ Pradesh",
"911562", "Churu\,\ Rajasthan",
"9174370", "Nainwa\,\ Rajasthan",
"9176278", "Manpur\,\ Madhya\ Pradesh",
"913678", "Morigaon\,\ Assam",
"9174666", "Bonli\,\ Rajasthan",
"9167335", "Ghatgaon\,\ Odisha",
"9171765", "Warora\,\ Maharashtra",
"9174848", "Silwani\,\ Madhya\ Pradesh",
"9166814", "Jujumura\,\ Odisha",
"911237", "Sardhana\,\ Uttar\ Pradesh",
"9164522", "Katihar\,\ Bihar",
"918495", "Rayadurg\,\ Andhra\ Pradesh",
"918843", "Kakinada\,\ Andhra\ Pradesh",
"9175215", "Seondha\,\ Madhya\ Pradesh",
"914144", "Chidambaram\,\ Tamil\ Nadu",
"914294", "Perundurai\,\ Tamil\ Nadu",
"91343", "Durgapur\,\ West\ Bengal",
"918647", "Narsaraopet\,\ Andhra\ Pradesh",
"912871", "Keshod\,\ Gujarat",
"9171962", "Arjuni\ Morgaon\,\ Maharashtra",
"914372", "Orathanad\,\ Tamil\ Nadu",
"9167356", "Telkoi\,\ Odisha",
"912762", "Mehsana\,\ Gujarat",
"916575", "Jamshedpur\,\ Bihar",
"912967", "Aspur\,\ Rajasthan",
"911908", "Jogindernagar\,\ Himachal\ Pradesh",
"9174383", "Keshoraipatan\/Patan\,\ Rajasthan",
"9161352", "Bikram\,\ Bihar",
"9165496", "Bermo\,\ Bihar",
"91183", "Amritsar\,\ Punjab",
"9166857", "Sohela\,\ Odisha",
"9175910", "Sironj\,\ Madhya\ Pradesh",
"918770", "Tirupathi\,\ Andhra\ Pradesh",
"917202", "Ralegaon\,\ Maharashtra",
"917609", "Buxwaha\,\ Madhya\ Pradesh",
"915545", "Bansi\,\ Uttar\ Pradesh",
"9181733", "Sakleshpur\,\ Karnataka",
"911259", "Kosli\,\ Haryana",
"911652", "Mansa\,\ Punjab",
"9174366", "Hindoli\,\ Rajasthan",
"9174589", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"914253", "Anamalai\,\ Tamil\ Nadu",
"911532", "Nokha\/Nathusar\,\ Rajasthan",
"9176374", "Birsa\,\ Madhya\ Pradesh",
"9174670", "Bamanwas\,\ Rajasthan",
"9171164", "Umrer\,\ Maharashtra",
"9164777", "Triveniganj\,\ Bihar",
"9171575", "Arvi\,\ Maharashtra",
"914182", "Tiruvettipuram\,\ Tamil\ Nadu",
"9167635", "Athmallik\,\ Odisha",
"918549", "Kalwakurthy\,\ Andhra\ Pradesh",
"915661", "Sadabad\,\ Uttar\ Pradesh",
"912425", "Sangamner\,\ Maharashtra",
"9166476", "Naktideul\,\ Odisha",
"918735", "Bellampalli\,\ Andhra\ Pradesh",
"9174919", "Narwar\,\ Madhya\ Pradesh",
"9176380", "Damoh\,\ Madhya\ Pradesh",
"9174684", "Khandar\,\ Rajasthan",
"9171834", "Tumsar\,\ Maharashtra",
"9171395", "Kurkheda\,\ Maharashtra",
"9174804", "Goharganj\,\ Madhya\ Pradesh",
"9164732", "Supaul\,\ Bihar",
"914577", "Tirupathur\,\ Tamil\ Nadu",
"9168436", "Puruna\ Katak\,\ Odisha",
"917854", "Ilamidi\,\ Madhya\ Pradesh",
"916746", "Bhubaneshwar\,\ Odisha",
"917768", "Saranggarh\,\ Madhya\ Pradesh",
"91186", "Pathankot\,\ Punjab",
"9174803", "Goharganj\,\ Madhya\ Pradesh",
"9171833", "Tumsar\,\ Maharashtra",
"9174683", "Khandar\,\ Rajasthan",
"912937", "Raipur\,\ Rajasthan",
"9172865", "Khetia\,\ Madhya\ Pradesh",
"9168455", "Phiringia\,\ Odisha",
"918614", "Nellore\,\ Andhra\ Pradesh",
"9175298", "Laher\,\ Madhya\ Pradesh",
"914636", "Sankarankovil\,\ Tamil\ Nadu",
"9171163", "Umrer\,\ Maharashtra",
"911267", "Nuh\,\ Haryana",
"9176373", "Birsa\,\ Madhya\ Pradesh",
"9167656", "Palla\ Hara\,\ Odisha",
"912959", "Jhadol\,\ Rajasthan",
"9180", "Bangalore\,\ Karnataka",
"918422", "Chadchan\,\ Karnataka",
"913222", "Kharagpur\,\ West\ Bengal",
"9171063", "Bhiwapur\,\ Maharashtra",
"9167253", "Dhanmandal\,\ Odisha",
"9162566", "Ramnagar\,\ Bihar",
"9174368", "Hindoli\,\ Rajasthan",
"9163227", "Wazirganj\,\ Bihar",
"9161554", "Ekma\,\ Bihar",
"9176260", "Vijayraghogarh\,\ Madhya\ Pradesh",
"9171616", "Parasia\,\ Madhya\ Pradesh",
"9176433", "Bijadandi\,\ Madhya\ Pradesh",
"917582", "Sagar\,\ Madhya\ Pradesh",
"9161126", "Biharsharif\,\ Bihar",
"9161517", "Sidhawalia\,\ Bihar",
"9163487", "Mallehpur\,\ Bihar",
"9164324", "Deoghar\,\ Bihar",
"9162227", "Sheohar\,\ Bihar",
"918663", "Vijayawada\,\ Andhra\ Pradesh",
"9168596", "Motu\,\ Odisha",
"9167217", "Narsinghpur\,\ Odisha",
"9161876", "Mohania\,\ Bihar",
"9165946", "Baharagora\,\ Bihar",
"9162262", "Sitamarhi\,\ Bihar",
"9176434", "Bijadandi\,\ Madhya\ Pradesh",
"9165415", "Chatra\,\ Bihar",
"915250", "Bahraich\/Bhinga\,\ Uttar\ Pradesh",
"915855", "Bilgram\/Sandi\,\ Uttar\ Pradesh",
"912524", "Murbad\,\ Maharashtra",
"9164323", "Deoghar\,\ Bihar",
"9174912", "Narwar\,\ Madhya\ Pradesh",
"917517", "Gwalior\,\ Madhya\ Pradesh",
"912746", "Radhanpur\,\ Gujarat",
"913783", "Along\,\ Arunachal\ Pradesh",
"9167254", "Dhanmandal\,\ Odisha",
"9171064", "Bhiwapur\,\ Maharashtra",
"9163262", "Sherghati\,\ Bihar",
"918377", "Nargund\,\ Karnataka",
"9174582", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9175296", "Laher\,\ Madhya\ Pradesh",
"9161553", "Ekma\,\ Bihar",
"9167337", "Ghatgaon\,\ Odisha",
"9171767", "Warora\,\ Maharashtra",
"912469", "Kinwat\,\ Maharashtra",
"913454", "Kalna\,\ West\ Bengal",
"912902", "Barmer\/Kanot\,\ Rajasthan",
"914554", "Cumbum\,\ Tamil\ Nadu",
"9171006", "Kuhi\,\ Maharashtra",
"9162503", "Dhaka\,\ Bihar",
"9168553", "Laxmipur\,\ Odisha",
"917267", "Malkapur\,\ Maharashtra",
"914899", "Chetlat\,\ Lakshadweep",
"9176495", "Kakaiya\,\ Madhya\ Pradesh",
"9177002", "Nagri\,\ Madhya\ Pradesh",
"9166216", "Hemgiri\,\ Odisha",
"9166785", "Nowparatan\,\ Odisha",
"9161596", "Masrakh\,\ Bihar",
"9174646", "Karauli\,\ Rajasthan",
"9166836", "Padmapur\,\ Odisha",
"9176259", "Umariapan\,\ Madhya\ Pradesh",
"9165612", "Garhwa\,\ Bihar",
"9171474", "Multai\,\ Madhya\ Pradesh",
"9171745", "Mul\,\ Maharashtra",
"917367", "Badnagar\,\ Madhya\ Pradesh",
"912691", "Kapad\ Wanj\,\ Gujarat",
"9171697", "Batkakhapa\,\ Madhya\ Pradesh",
"9164547", "Purnea\,\ Bihar",
"9174868", "Bareli\,\ Madhya\ Pradesh",
"911507", "Raisinghnagar\,\ Rajasthan",
"912580", "Jamner\,\ Maharashtra",
"912568", "Sakri\,\ Maharashtra",
"9166855", "Sohela\,\ Odisha",
"914146", "Villupuram\,\ Tamil\ Nadu",
"914296", "Avanashi\,\ Tamil\ Nadu",
"9167296", "Pattamundai\,\ Odisha",
"9171473", "Multai\,\ Madhya\ Pradesh",
"9174138", "Sailana\,\ Madhya\ Pradesh",
"9166512", "Birmaharajpur\,\ Odisha",
"9175217", "Seondha\,\ Madhya\ Pradesh",
"9162504", "Dhaka\,\ Bihar",
"9168554", "Laxmipur\,\ Odisha",
"916717", "Cuttack\,\ Odisha",
"9171722", "Chandrapur\,\ Maharashtra",
"917673", "Nagod\,\ Madhya\ Pradesh",
"917532", "Morena\,\ Madhya\ Pradesh",
"911498", "Anupgarh\,\ Rajasthan",
"91431", "Tiruchchirappalli\,\ Tamil\ Nadu",
"9165513", "Barkagaon\,\ Bihar",
"918778", "Tirupathi\,\ Andhra\ Pradesh",
"915446", "Dudhi\/Pipri\,\ Uttar\ Pradesh",
"917730", "Ajaigarh\,\ Madhya\ Pradesh",
"9174303", "Khanpur\,\ Rajasthan",
"9171333", "Aheri\,\ Maharashtra",
"911900", "Lahul\/Keylong\,\ Himachal\ Pradesh",
"912987", "Sheo\,\ Rajasthan",
"91421", "Tirupur\,\ Tamil\ Nadu",
"9167693", "Kamakhyanagar\,\ Odisha",
"913665", "Tarabarihat\,\ Assam",
"9168652", "Kashipur\,\ Odisha",
"9182895", "Athani\,\ Karnataka",
"9174244", "Malhargarh\,\ Madhya\ Pradesh",
"918915", "Visakhapatnam\,\ Andhra\ Pradesh",
"918596", "Markapur\,\ Andhra\ Pradesh",
"9174648", "Karauli\,\ Rajasthan",
"9176252", "Umariapan\,\ Madhya\ Pradesh",
"9167694", "Kamakhyanagar\,\ Odisha",
"9165275", "Kolebira\,\ Bihar",
"9174866", "Bareli\,\ Madhya\ Pradesh",
"9177009", "Nagri\,\ Madhya\ Pradesh",
"913670", "Maibong\,\ Assam",
"9174243", "Malhargarh\,\ Madhya\ Pradesh",
"911582", "Nagaur\,\ Rajasthan",
"917724", "Basana\,\ Madhya\ Pradesh",
"9173207", "Pandhana\,\ Madhya\ Pradesh",
"918354", "Bagalkot\,\ Karnataka",
"9162752", "Rosera\,\ Bihar",
"9165514", "Barkagaon\,\ Bihar",
"9176535", "Bandhavgarh\,\ Madhya\ Pradesh",
"9166707", "Bhawanipatna\,\ Odisha",
"917546", "Chachaura\,\ Madhya\ Pradesh",
"912323", "Ajara\,\ Maharashtra",
"9174136", "Sailana\,\ Madhya\ Pradesh",
"912381", "Ahmedpur\,\ Maharashtra",
"918785", "Karimnagar\,\ Andhra\ Pradesh",
"9171334", "Aheri\,\ Maharashtra",
"9171895", "Amagaon\,\ Maharashtra",
"918254", "Kundapur\,\ Karnataka",
"9174304", "Khanpur\,\ Rajasthan",
"9162225", "Sheohar\,\ Bihar",
"9174120", "Ratlam\,\ Madhya\ Pradesh",
"9163485", "Mallehpur\,\ Bihar",
"918393", "Kurugodu\,\ Karnataka",
"9161515", "Sidhawalia\,\ Bihar",
"9171043", "Hingua\,\ Maharashtra",
"9162546", "Bettiah\,\ Bihar",
"9174348", "Pirawa\/Raipur\,\ Rajasthan",
"9178088", "\`",
"9176240", "Sihora\,\ Madhya\ Pradesh",
"918440", "Nimburga\,\ Karnataka",
"9163225", "Wazirganj\,\ Bihar",
"9167573", "Daspalla\,\ Odisha",
"9174603", "Sahabad\,\ Rajasthan",
"917788", "Luckwada\,\ Madhya\ Pradesh",
"9161852", "Bikramganj\,\ Bihar",
"9176416", "Niwas\,\ Madhya\ Pradesh",
"9165453", "Mandu\,\ Bihar",
"911923", "Samba\,\ Jammu\ And\ Kashmir",
"913714", "Rangapara\,\ Assam",
"91522", "Lucknow\,\ Uttar\ Pradesh",
"9165966", "Noamundi\,\ Bihar",
"9162242", "Hajipur\,\ Bihar",
"917775", "Surajpur\,\ Madhya\ Pradesh",
"9174604", "Sahabad\,\ Rajasthan",
"912526", "Wada\,\ Maharashtra",
"9167574", "Daspalla\,\ Odisha",
"9176300", "Katangi\,\ Madhya\ Pradesh",
"911981", "Nyoma\,\ Jammu\ And\ Kashmir",
"9165454", "Mandu\,\ Bihar",
"9174208", "Jawad\,\ Madhya\ Pradesh",
"912744", "Deesa\,\ Gujarat",
"91532", "Allahabad\,\ Uttar\ Pradesh",
"915681", "Bidhuna\,\ Uttar\ Pradesh",
"9171044", "Hingua\,\ Maharashtra",
"9163242", "Nawada\,\ Bihar",
"9165417", "Chatra\,\ Bihar",
"9171492", "Tamia\,\ Madhya\ Pradesh",
"9174870", "Begamganj\,\ Madhya\ Pradesh",
"9174509", "Sangod\,\ Rajasthan",
"9167215", "Narsinghpur\,\ Odisha",
"9174346", "Pirawa\/Raipur\,\ Rajasthan",
"9174502", "Sangod\,\ Rajasthan",
"9167672", "Barbil\,\ Odisha",
"9171532", "Hinganghat\,\ Maharashtra",
"9171144", "Ramtek\,\ Maharashtra",
"9175923", "Vidisha\,\ Madhya\ Pradesh",
"9171397", "Kurkheda\,\ Maharashtra",
"9165312", "Mandar\,\ Bihar",
"912457", "Jintdor\,\ Maharashtra",
"912439", "Golegaon\,\ Maharashtra",
"918729", "Manthani\,\ Andhra\ Pradesh",
"9171577", "Arvi\,\ Maharashtra",
"9167637", "Athmallik\,\ Odisha",
"9176418", "Niwas\,\ Madhya\ Pradesh",
"9168413", "Boudh\,\ Odisha",
"9164775", "Triveniganj\,\ Bihar",
"918812", "Eluru\,\ Andhra\ Pradesh",
"915462", "Azamgarh\,\ Uttar\ Pradesh",
"917237", "Marigaon\,\ Maharashtra",
"916805", "Berhampur\,\ Odisha",
"917856", "Dantewada\,\ Madhya\ Pradesh",
"918683", "Hazurnagar\,\ Andhra\ Pradesh",
"916744", "Bhubaneshwar\,\ Odisha",
"9168414", "Boudh\,\ Odisha",
"9174206", "Jawad\,\ Madhya\ Pradesh",
"913845", "Ukhrul\ Central\,\ Manipur",
"917562", "Sehore\,\ Madhya\ Pradesh",
"918621", "Rapur\/Podalakur\,\ Andhra\ Pradesh",
"9166452", "Jharsuguda\,\ Odisha",
"9171816", "Lakhandur\,\ Maharashtra",
"918159", "Mulbagal\,\ Karnataka",
"9172867", "Khetia\,\ Madhya\ Pradesh",
"9168457", "Phiringia\,\ Odisha",
"918616", "Nellore\,\ Andhra\ Pradesh",
"914634", "Ambasamudram\,\ Tamil\ Nadu",
"914985", "Payyanur\,\ Kerala",
"918137", "Madugiri\,\ Karnataka",
"9171143", "Ramtek\,\ Maharashtra",
"911893", "Nurpur\,\ Himachal\ Pradesh",
"9175924", "Vidisha\,\ Madhya\ Pradesh",
"911697", "Ratia\,\ Haryana",
"9176338", "Waraseoni\,\ Madhya\ Pradesh",
"915821", "Pitamberpur\,\ Uttar\ Pradesh",
"911782", "Rampur\ Bushahar\,\ Himachal\ Pradesh",
"917524", "Dabra\,\ Madhya\ Pradesh",
"918118", "Nelamangala\,\ Karnataka",
"9174230", "Neemuch\,\ Madhya\ Pradesh",
"9167275", "Kendrapara\,\ Odisha",
"918479", "Shahapur\,\ Karnataka",
"9167557", "Khurda\,\ Odisha",
"9174810", "Gairatganj\,\ Madhya\ Pradesh",
"9165694", "Garu\,\ Bihar",
"9165477", "Chavparan\,\ Bihar",
"9162523", "Motihari\,\ Bihar",
"9171026", "Parseoni\,\ Maharashtra",
"918585", "Pakala\,\ Andhra\ Pradesh",
"9175948", "Ganjbasoda\,\ Madhya\ Pradesh",
"918466", "Banswada\,\ Andhra\ Pradesh",
"9174935", "Karera\,\ Madhya\ Pradesh",
"9171652", "Saunsar\,\ Madhya\ Pradesh",
"917746", "Manpur\,\ Madhya\ Pradesh",
"9161833", "Buxar\,\ Bihar",
"9165432", "Barhi\,\ Bihar",
"912900", "Siwana\/Samdari\,\ Rajasthan",
"9171702", "Chumur\,\ Maharashtra",
"9162524", "Motihari\,\ Bihar",
"917530", "Sheopurkalan\,\ Madhya\ Pradesh",
"9174956", "Badarwas\,\ Madhya\ Pradesh",
"918578", "Srikalahasthi\,\ Andhra\ Pradesh",
"9176476", "Ghughari\,\ Madhya\ Pradesh",
"9177045", "Deobhog\,\ Madhya\ Pradesh",
"9161834", "Buxar\,\ Bihar",
"911381", "Joshimath\/Badrinath\,\ Uttarakhand",
"9177067", "Gariaband\,\ Madhya\ Pradesh",
"9161575", "Mairwa\,\ Bihar",
"9168106", "Khalikote\,\ Odisha",
"9164366", "Sahibganj\,\ Bihar",
"911281", "Jatusana\,\ Haryana",
"9165693", "Garu\,\ Bihar",
"915612", "Ferozabad\,\ Uttar\ Pradesh",
"912582", "Bhusawal\,\ Maharashtra",
"9165296", "Itki\,\ Bihar",
"9171553", "Seloo\,\ Maharashtra",
"918131", "Gubbi\,\ Karnataka",
"9176336", "Waraseoni\,\ Madhya\ Pradesh",
"913869", "Mon\,\ Nagaland",
"911476", "Kapasan\,\ Rajasthan",
"915525", "Bansgaon\,\ Uttar\ Pradesh",
"912599", "Bhudargad\/Gargoti\,\ Maharashtra",
"9166762", "M\.Rampur\,\ Odisha",
"9168697", "Papadhandi\,\ Odisha",
"918823", "Chintalapudi\,\ Andhra\ Pradesh",
"9181760", "Cannarayapatna\,\ Karnataka",
"917732", "Panna\,\ Madhya\ Pradesh",
"9168474", "G\.Udayagiri\,\ Odisha",
"911902", "Kullu\,\ Himachal\ Pradesh",
"913876", "Jiribam\,\ Manipur",
"9174323", "Jhalawar\,\ Rajasthan",
"911469", "Tijara\,\ Rajasthan",
"916517", "Ranchi\,\ Bihar",
"9171876", "Goregaon\,\ Maharashtra",
"9175946", "Ganjbasoda\,\ Madhya\ Pradesh",
"918627", "Atmakur\,\ Andhra\ Pradesh",
"9166434", "Barkot\,\ Odisha",
"9164715", "Birpur\,\ Bihar",
"9168473", "G\.Udayagiri\,\ Odisha",
"9164286", "Nala\,\ Bihar",
"9165592", "Simaria\,\ Bihar",
"9171126", "Katol\,\ Maharashtra",
"9176478", "Ghughari\,\ Madhya\ Pradesh",
"9171517", "Samudrapur\,\ Maharashtra",
"913016", "Jaisalmer\/Jheenjaniyali\,\ Rajasthan",
"914868", "Nedumkandam\,\ Kerala",
"914285", "Gobichettipalayam\,\ Tamil\ Nadu",
"9174324", "Jhalawar\,\ Rajasthan",
"9176297", "Pushprajgarh\,\ Madhya\ Pradesh",
"918484", "Bhalki\,\ Karnataka",
"9162797", "Barauni\,\ Bihar",
"9166727", "Dharamgarh\,\ Odisha",
"917231", "Umarkhed\,\ Maharashtra",
"9166433", "Barkot\,\ Odisha",
"9165337", "Basia\,\ Bihar",
"9174958", "Badarwas\,\ Madhya\ Pradesh",
"911799", "Rajgarh\,\ Himachal\ Pradesh",
"9167612", "Chhendipada\,\ Odisha",
"913672", "Nagaon\,\ Assam",
"9173227", "Depalpur\,\ Madhya\ Pradesh",
"911568", "Sujangarh\,\ Rajasthan",
"911580", "Deedwana\,\ Rajasthan",
"9171554", "Seloo\,\ Maharashtra",
"9171987", "Tirora\,\ Maharashtra",
"912451", "Pathari\,\ Maharashtra",
"9176355", "Lanji\,\ Madhya\ Pradesh",
"9174623", "Sawaimadhopur\,\ Rajasthan",
"917762", "Raigarh\,\ Madhya\ Pradesh",
"9166572", "Kantabhanji\,\ Odisha",
"918442", "Jewargi\,\ Karnataka",
"9163322", "Nabinagar\,\ Bihar",
"9168144", "Digapahandi\,\ Odisha",
"9168532", "Sunabeda\,\ Odisha",
"913653", "Amlarem\/Dawki\,\ Meghalaya",
"911501", "Srikaranpur\,\ Rajasthan",
"9164263", "Rajmahal\,\ Bihar",
"9166537", "Dunguripali\,\ Odisha",
"914175", "Tiruvannamalai\,\ Tamil\ Nadu",
"9171413", "Betul\,\ Madhya\ Pradesh",
"9161897", "Bhabhua\,\ Bihar",
"9168577", "Gunupur\,\ Odisha",
"912738", "Santalpur\,\ Gujarat",
"913839", "Jalukie\,\ Nagaland",
"9164264", "Rajmahal\,\ Bihar",
"916312", "Gaya\,\ Bihar",
"913563", "Birpara\,\ West\ Bengal",
"912445", "Kaij\,\ Maharashtra",
"912893", "Jodia\,\ Gujarat",
"9167312", "Anandapur\,\ Odisha",
"9174529", "Chhabra\,\ Rajasthan",
"912697", "Retlad\,\ Gujarat",
"917361", "Susner\,\ Madhya\ Pradesh",
"9165672", "Barwadih\,\ Bihar",
"9171414", "Betul\,\ Madhya\ Pradesh",
"914188", "Chengam\,\ Tamil\ Nadu",
"9173957", "Sondhwa\,\ Madhya\ Pradesh",
"915114", "Derapur\/Jhinjak\,\ Uttar\ Pradesh",
"9176320", "Balaghat\,\ Madhya\ Pradesh",
"916212", "Muzaffarpur\,\ Bihar",
"9174624", "Sawaimadhopur\,\ Rajasthan",
"917474", "Bundi\,\ Rajasthan",
"9163367", "Rajauli\,\ Bihar",
"91490", "Tellicherry\,\ Kerala",
"91797", "Ahmedabad\ Local\,\ Gujarat",
"9174228", "Mandsaur\,\ Madhya\ Pradesh",
"9168143", "Digapahandi\,\ Odisha",
"917261", "Deolgaonraja\,\ Maharashtra",
"9165637", "Bhawanathpur\,\ Bihar",
"918205", "Udupi\,\ Karnataka",
"9171457", "Chicholi\,\ Madhya\ Pradesh",
"9163462", "Lakhisarai\,\ Bihar",
"915460", "Phulpur\,\ Uttar\ Pradesh",
"9165574", "Bagodar\,\ Bihar",
"91491", "Palakkad\,\ Kerala",
"917575", "Sohagpur\,\ Madhya\ Pradesh",
"9164383", "Madhupur\,\ Bihar",
"9167966", "Karanjia\,\ Odisha",
"9171352", "Chamorshi\,\ Maharashtra",
"91288", "Jamnagar\,\ Gujarat",
"918215", "Mysore\,\ Karnataka",
"9175903", "Lateri\,\ Madhya\ Pradesh",
"9162462", "Jainagar\,\ Bihar",
"9168633", "Bisam\ Cuttack\,\ Odisha",
"9167417", "Bhubaneshwar\,\ Odisha",
"911805", "Panipat\,\ Haryana",
"9165835", "Kharsawa\,\ Bihar",
"9165394", "Bolwa\,\ Bihar",
"9176814", "Jatara\,\ Madhya\ Pradesh",
"918315", "Belgaum\,\ Karnataka",
"912711", "Barwala\,\ Gujarat",
"9174522", "Chhabra\,\ Rajasthan",
"9162734", "Jhajharpur\,\ Bihar",
"914329", "Ariyalur\,\ Tamil\ Nadu",
"913228", "Tamluk\,\ West\ Bengal",
"91478", "Cherthala\,\ Kerala",
"9175904", "Lateri\,\ Madhya\ Pradesh",
"913174", "Diamond\ Harbour\,\ West\ Bengal",
"911744", "Kurukshetra\,\ Haryana",
"9168634", "Bisam\ Cuttack\,\ Odisha",
"9174567", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9176813", "Jatara\,\ Madhya\ Pradesh",
"9162427", "Benipur\,\ Bihar",
"9165393", "Bolwa\,\ Bihar",
"9166497", "Jamankira\,\ Odisha",
"9163287", "Daudnagar\,\ Bihar",
"9165856", "Ghatsila\,\ Bihar",
"9164666", "Kishanganj\,\ Bihar",
"9162733", "Jhajharpur\,\ Bihar",
"913242", "Bankura\,\ West\ Bengal",
"913192", "Andaman\ \&\ Nicobar\,\ Andaman\ Islands",
"9164796", "Udakishanganj\,\ Bihar",
"917560", "Ashta\,\ Madhya\ Pradesh",
"912923", "Phalodi\/Lohawat\,\ Rajasthan",
"9168492", "Daringbadi\,\ Odisha",
"9165573", "Bagodar\,\ Bihar",
"9164384", "Madhupur\,\ Bihar",
"9162287", "Pupri\,\ Bihar",
"9176460", "Nainpur\,\ Madhya\ Pradesh",
"9174545", "Chhipaborad\,\ Rajasthan",
"912981", "Sheo\/Harsani\,\ Rajasthan",
"9163427", "H\.Kharagpur\,\ Bihar",
"911526", "Lunkaransar\/Mahajan\,\ Rajasthan",
"9174226", "Mandsaur\,\ Madhya\ Pradesh",
"9167292", "Pattamundai\,\ Odisha",
"9174350", "Gangdhar\,\ Rajasthan",
"912628", "Nizar\,\ Gujarat",
"9171415", "Betul\,\ Madhya\ Pradesh",
"9176258", "Umariapan\,\ Madhya\ Pradesh",
"9173210", "Sanwer\,\ Madhya\ Pradesh",
"9164265", "Rajmahal\,\ Bihar",
"916636", "Sambalpur\,\ Odisha",
"9164247", "Banka\,\ Bihar",
"917695", "Gopalganj\,\ Madhya\ Pradesh",
"912642", "Bharuch\,\ Gujarat",
"9171726", "Chandrapur\,\ Maharashtra",
"911824", "Phagwara\,\ Punjab",
"912970", "Sanchore\/Hadecha\,\ Rajasthan",
"917447", "Ladpura\/Kota\,\ Rajasthan",
"9166516", "Birmaharajpur\,\ Odisha",
"9174625", "Sawaimadhopur\,\ Rajasthan",
"918531", "Deodurga\,\ Karnataka",
"9168217", "Bhanjanagar\,\ Odisha",
"912965", "Kushalgarh\,\ Rajasthan",
"916577", "Jamshedpur\,\ Bihar",
"911421", "Kotputli\,\ Rajasthan",
"9171002", "Kuhi\,\ Maharashtra",
"9168145", "Digapahandi\,\ Odisha",
"915284", "Maudaha\,\ Uttar\ Pradesh",
"9174139", "Sailana\,\ Madhya\ Pradesh",
"915547", "Khalilabad\,\ Uttar\ Pradesh",
"911483", "Hurda\/Gulabpura\,\ Rajasthan",
"9165616", "Garhwa\,\ Bihar",
"912846", "Sihor\,\ Gujarat",
"9166832", "Padmapur\,\ Odisha",
"918497", "Kalyandurg\,\ Andhra\ Pradesh",
"9168167", "Mohana\,\ Odisha",
"918645", "Mangalagiri\,\ Andhra\ Pradesh",
"9174642", "Karauli\,\ Rajasthan",
"913821", "R\.K\.Pur\,\ Tripura",
"9161592", "Masrakh\,\ Bihar",
"9174869", "Bareli\,\ Madhya\ Pradesh",
"9166212", "Hemgiri\,\ Odisha",
"9177006", "Nagri\,\ Madhya\ Pradesh",
"9174649", "Karauli\,\ Rajasthan",
"9162756", "Rosera\,\ Bihar",
"918330", "Saundatti\,\ Karnataka",
"9174862", "Bareli\,\ Madhya\ Pradesh",
"9165833", "Kharsawa\,\ Bihar",
"9168635", "Bisam\ Cuttack\,\ Odisha",
"918185", "Hosanagara\,\ Karnataka",
"915672", "Mainpuri\,\ Uttar\ Pradesh",
"9175905", "Lateri\,\ Madhya\ Pradesh",
"9176256", "Umariapan\,\ Madhya\ Pradesh",
"911972", "Hamirpur\,\ Himachal\ Pradesh",
"913806", "Chowkhem\,\ Arunachal\ Pradesh",
"9174132", "Sailana\,\ Madhya\ Pradesh",
"9164385", "Madhupur\,\ Bihar",
"9174544", "Chhipaborad\,\ Rajasthan",
"918230", "Krishnarajapet\,\ Karnataka",
"918835", "Rajahmundri\,\ Andhra\ Pradesh",
"915694", "Kannauj\,\ Uttar\ Pradesh",
"9184537", "Medak\,\ Andhra\ Pradesh",
"917124", "Nagpur\,\ Maharashtra",
"91389", "Aizawal\,\ Mizoram",
"918518", "Kurnool\,\ Andhra\ Pradesh",
"912117", "Daund\,\ Maharashtra",
"917285", "Kasrawad\,\ Madhya\ Pradesh",
"917868", "Kanker\,\ Madhya\ Pradesh",
"918324", "Goa",
"917754", "Pandaria\,\ Madhya\ Pradesh",
"9174543", "Chhipaborad\,\ Rajasthan",
"912182", "Karmala\,\ Maharashtra",
"9165575", "Bagodar\,\ Bihar",
"9165257", "Simdega\,\ Bihar",
"915876", "Mohammadi\,\ Uttar\ Pradesh",
"918224", "Kollegal\,\ Karnataka",
"91265", "Vadodara\,\ Gujarat",
"9162735", "Jhajharpur\,\ Bihar",
"913525", "Dalkhola\,\ West\ Bengal",
"9165395", "Bolwa\,\ Bihar",
"9165834", "Kharsawa\,\ Bihar",
"9176815", "Jatara\,\ Madhya\ Pradesh",
"9177008", "Nagri\,\ Madhya\ Pradesh",
"912353", "Rajapur\,\ Maharashtra",
"9168656", "Kashipur\,\ Odisha",
"912832", "Bhuj\,\ Gujarat",
"914331", "Jayamkondan\,\ Tamil\ Nadu",
"918419", "Yellapur\,\ Karnataka",
"9174827", "Raisen\,\ Madhya\ Pradesh",
"9177044", "Deobhog\,\ Madhya\ Pradesh",
"918288", "Bailhongal\,\ Karnataka",
"9161835", "Buxar\,\ Bihar",
"918865", "Yelavaram\,\ Andhra\ Pradesh",
"912372", "Patan\,\ Maharashtra",
"912144", "Murud\,\ Maharashtra",
"917801", "Deosar\,\ Madhya\ Pradesh",
"9162246", "Hajipur\,\ Bihar",
"9165962", "Noamundi\,\ Bihar",
"91253", "Nasik\ City\,\ Maharashtra",
"9174933", "Karera\,\ Madhya\ Pradesh",
"912666", "Miyagam\,\ Gujarat",
"917793", "Kareli\,\ Madhya\ Pradesh",
"9161147", "Jahanabad\,\ Bihar",
"9162525", "Motihari\,\ Bihar",
"918388", "Ankola\,\ Karnataka",
"918360", "Hubli\,\ Karnataka",
"911571", "Fatehpur\,\ Rajasthan",
"9178089", "\`",
"9167273", "Kendrapara\,\ Odisha",
"9174349", "Pirawa\/Raipur\,\ Rajasthan",
"912679", "Jhalod\,\ Gujarat",
"9171496", "Tamia\,\ Madhya\ Pradesh",
"9163246", "Nawada\,\ Bihar",
"915563", "Captanganj\/Khadda\,\ Uttar\ Pradesh",
"9161574", "Mairwa\,\ Bihar",
"9174508", "Sangod\,\ Rajasthan",
"9165695", "Garu\,\ Bihar",
"918743", "Bhadrachalam\,\ Andhra\ Pradesh",
"9167274", "Kendrapara\,\ Odisha",
"912556", "Chanwad\,\ Maharashtra",
"912771", "Bhiloda\,\ Gujarat",
"918375", "Haveri\,\ Karnataka",
"9162542", "Bettiah\,\ Bihar",
"913592", "Gangtok\,\ West\ Bengal",
"9161573", "Mairwa\,\ Bihar",
"91790", "Ahmedabad\ Local\,\ Gujarat",
"9176412", "Niwas\,\ Madhya\ Pradesh",
"9161856", "Bikramganj\,\ Bihar",
"9174209", "Jawad\,\ Madhya\ Pradesh",
"91497", "Kannur\,\ Kerala",
"9177043", "Deobhog\,\ Madhya\ Pradesh",
"9175381", "Ambah\,\ Madhya\ Pradesh",
"9174934", "Karera\,\ Madhya\ Pradesh",
"917515", "Gwalior\,\ Madhya\ Pradesh",
"91535", "Raibareli\,\ Uttar\ Pradesh",
"912427", "Newasa\,\ Maharashtra",
"9171812", "Lakhandur\,\ Maharashtra",
"9166456", "Jharsuguda\,\ Odisha",
"9165897", "Jhinkpani\,\ Bihar",
"918737", "Chinnor\,\ Andhra\ Pradesh",
"917229", "Warlydwarud\,\ Maharashtra",
"9174325", "Jhalawar\,\ Rajasthan",
"915192", "Banda\,\ Uttar\ Pradesh",
"917622", "Katni\,\ Madhya\ Pradesh",
"918561", "Rayachoti\,\ Andhra\ Pradesh",
"9174202", "Jawad\,\ Madhya\ Pradesh",
"9176419", "Niwas\,\ Madhya\ Pradesh",
"914575", "Sivaganga\,\ Tamil\ Nadu",
"9164714", "Birpur\,\ Bihar",
"911370", "Devprayag\/Jakholi\,\ Uttarakhand",
"9174650", "Sapotra\,\ Rajasthan",
"9176354", "Lanji\,\ Madhya\ Pradesh",
"9171555", "Seloo\,\ Maharashtra",
"918932", "Narsipatnam\,\ Andhra\ Pradesh",
"9164757", "S\.Bakhtiarpur\,\ Bihar",
"915342", "Pratapgarh\,\ Uttar\ Pradesh",
"915174", "Jhansi\,\ Uttar\ Pradesh",
"913790", "Tali\,\ Arunachal\ Pradesh",
"911875", "Dinanagar\,\ Punjab",
"914115", "Madurantakam\,\ Tamil\ Nadu",
"9176353", "Lanji\,\ Madhya\ Pradesh",
"9165316", "Mandar\,\ Bihar",
"9167676", "Barbil\,\ Odisha",
"9171536", "Hinganghat\,\ Maharashtra",
"9174506", "Sangod\,\ Rajasthan",
"9174700", "Bundi\,\ Rajasthan",
"9174342", "Pirawa\/Raipur\,\ Rajasthan",
"917826", "Patan\,\ Madhya\ Pradesh",
"9166435", "Barkot\,\ Odisha",
"9175111", "Gwalior\,\ Madhya\ Pradesh",
"912935", "Marwar\ Junction\,\ Rajasthan",
"917811", "Pasan\,\ Madhya\ Pradesh",
"9168475", "G\.Udayagiri\,\ Odisha",
"9164713", "Birpur\,\ Bihar",
"912972", "Sirohi\,\ Rajasthan",
"9165455", "Mandu\,\ Bihar",
"9167257", "Dhanmandal\,\ Odisha",
"9171067", "Bhiwapur\,\ Maharashtra",
"918196", "Jagalur\,\ Karnataka",
"9176472", "Ghughari\,\ Madhya\ Pradesh",
"918246", "Mangalore\,\ Karnataka",
"9174605", "Sahabad\,\ Rajasthan",
"9167575", "Daspalla\,\ Odisha",
"9174530", "Baran\,\ Rajasthan",
"9175949", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174952", "Badarwas\,\ Madhya\ Pradesh",
"915851", "Bilgam\/Madhoganj\,\ Uttar\ Pradesh",
"912640", "Rajpipla\,\ Gujarat",
"9171706", "Chumur\,\ Maharashtra",
"911636", "Moga\,\ Punjab",
"9163223", "Wazirganj\,\ Bihar",
"9167214", "Narsinghpur\,\ Odisha",
"912994", "Pokhran\,\ Rajasthan",
"9164362", "Sahibganj\,\ Bihar",
"9176437", "Bijadandi\,\ Madhya\ Pradesh",
"9161513", "Sidhawalia\,\ Bihar",
"9171045", "Hingua\,\ Maharashtra",
"914367", "Mannargudi\,\ Tamil\ Nadu",
"9168102", "Khalikote\,\ Odisha",
"9162223", "Sheohar\,\ Bihar",
"9176339", "Waraseoni\,\ Madhya\ Pradesh",
"9163483", "Mallehpur\,\ Bihar",
"917664", "Hanumana\,\ Madhya\ Pradesh",
"918849", "Kakinada\,\ Andhra\ Pradesh",
"915733", "Pahasu\,\ Uttar\ Pradesh",
"911577", "Dantaramgarh\,\ Rajasthan",
"9167213", "Narsinghpur\,\ Odisha",
"91427", "Salem\,\ Tamil\ Nadu",
"9161514", "Sidhawalia\,\ Bihar",
"9163484", "Mallehpur\,\ Bihar",
"9162224", "Sheohar\,\ Bihar",
"9164327", "Deoghar\,\ Bihar",
"917296", "Sardarpur\,\ Madhya\ Pradesh",
"918718", "Narasampet\,\ Andhra\ Pradesh",
"9165436", "Barhi\,\ Bihar",
"9171656", "Saunsar\,\ Madhya\ Pradesh",
"911253", "Tohsham\,\ Haryana",
"91595", "Rampur\,\ Uttar\ Pradesh",
"9163224", "Wazirganj\,\ Bihar",
"917603", "Tendukheda\,\ Madhya\ Pradesh",
"9171022", "Parseoni\,\ Maharashtra",
"9161557", "Ekma\,\ Bihar",
"916416", "Bhagalpur\,\ Bihar",
"915454", "Machlishahar\,\ Uttar\ Pradesh",
"918708", "Warangal\,\ Andhra\ Pradesh",
"917817", "Janjgir\,\ Madhya\ Pradesh",
"9175220", "Datia\,\ Madhya\ Pradesh",
"912824", "Dhoraji\,\ Gujarat",
"91731", "Indore\,\ Madhya\ Pradesh",
"9164773", "Triveniganj\,\ Bihar",
"911970", "Dehra\ Gopipur\,\ Himachal\ Pradesh",
"9168415", "Boudh\,\ Odisha",
"9165596", "Simaria\,\ Bihar",
"9171122", "Katol\,\ Maharashtra",
"9164282", "Nala\,\ Bihar",
"918232", "Mandya\,\ Karnataka",
"918639", "Guntur\,\ Andhra\ Pradesh",
"9175925", "Vidisha\,\ Madhya\ Pradesh",
"91721", "Amravati\,\ Maharashtra",
"911628", "Samrala\,\ Punjab",
"918332", "Gokak\,\ Karnataka",
"9167616", "Chhendipada\,\ Odisha",
"915942", "Nainital\,\ Uttar\ Pradesh",
"917686", "Khajuraho\,\ Madhya\ Pradesh",
"912830", "Rahpar\,\ Gujarat",
"9176332", "Waraseoni\,\ Madhya\ Pradesh",
"9174687", "Khandar\,\ Rajasthan",
"9174807", "Goharganj\,\ Madhya\ Pradesh",
"9171837", "Tumsar\,\ Maharashtra",
"9171145", "Ramtek\,\ Maharashtra",
"9165292", "Itki\,\ Bihar",
"914546", "Theni\,\ Tamil\ Nadu",
"918731", "Utnor\,\ Andhra\ Pradesh",
"911965", "Poonch\,\ Jammu\ And\ Kashmir",
"9175942", "Ganjbasoda\,\ Madhya\ Pradesh",
"9174959", "Badarwas\,\ Madhya\ Pradesh",
"9176377", "Birsa\,\ Madhya\ Pradesh",
"9171872", "Goregaon\,\ Maharashtra",
"912421", "Jamkhed\,\ Maharashtra",
"9171167", "Umrer\,\ Maharashtra",
"9164774", "Triveniganj\,\ Bihar",
"912483", "Ambad\,\ Maharashtra",
"9176479", "Ghughari\,\ Madhya\ Pradesh",
"9166766", "M\.Rampur\,\ Odisha",
"912168", "Mahabaleswar\,\ Maharashtra",
"918567", "Lakkireddipalli\,\ Andhra\ Pradesh",
"9171743", "Mul\,\ Maharashtra",
"913623", "Barama\,\ Assam",
"918491", "Kanaganapalle\,\ Andhra\ Pradesh",
"918676", "Vuyyuru\,\ Andhra\ Pradesh",
"9165676", "Barwadih\,\ Bihar",
"9166854", "Sohela\,\ Odisha",
"9167316", "Anandapur\,\ Odisha",
"918362", "Hubli\,\ Karnataka",
"9166783", "Nowparatan\,\ Odisha",
"912875", "Una\/Diu\,\ Gujarat",
"9176493", "Kakaiya\,\ Madhya\ Pradesh",
"9166817", "Jujumura\,\ Odisha",
"911427", "Dausa\,\ Rajasthan",
"9162505", "Dhaka\,\ Bihar",
"9168555", "Laxmipur\,\ Odisha",
"918458", "Narsapur\,\ Andhra\ Pradesh",
"918262", "Chikmagalur\,\ Karnataka",
"917844", "Pakhanjur\,\ Madhya\ Pradesh",
"918669", "Vijayawada\,\ Andhra\ Pradesh",
"915541", "Domariyaganj\,\ Uttar\ Pradesh",
"9175950", "Nateran\,\ Madhya\ Pradesh",
"9176494", "Kakaiya\,\ Madhya\ Pradesh",
"916126", "Patna\,\ Bihar",
"9163326", "Nabinagar\,\ Bihar",
"911684", "Narwana\,\ Haryana",
"918761", "Sathupalli\,\ Andhra\ Pradesh",
"9168536", "Sunabeda\,\ Odisha",
"912365", "Malwan\,\ Maharashtra",
"9174229", "Mandsaur\,\ Madhya\ Pradesh",
"918537", "Lingsugur\,\ Karnataka",
"9166576", "Kantabhanji\,\ Odisha",
"912138", "Shirur\,\ Maharashtra",
"914343", "Krishnagiri\,\ Tamil\ Nadu",
"9174387", "Keshoraipatan\/Patan\,\ Rajasthan",
"9171475", "Multai\,\ Madhya\ Pradesh",
"9171744", "Mul\,\ Maharashtra",
"913789", "Huri\,\ Arunachal\ Pradesh",
"9166853", "Sohela\,\ Odisha",
"918559", "Dharmavaram\,\ Andhra\ Pradesh",
"9174528", "Chhabra\,\ Rajasthan",
"91548", "Ghazipur\,\ Uttar\ Pradesh",
"9181737", "Sakleshpur\,\ Karnataka",
"9166784", "Nowparatan\,\ Odisha",
"915966", "Ranikhet\,\ Uttar\ Pradesh",
"914259", "Pollachi\,\ Tamil\ Nadu",
"914652", "Nagercoil\,\ Tamil\ Nadu",
"9164662", "Kishanganj\,\ Bihar",
"911679", "Barnala\,\ Punjab",
"913792", "Daporizo\,\ Arunachal\ Pradesh",
"9165852", "Ghatsila\,\ Bihar",
"912756", "Muli\,\ Gujarat",
"9165274", "Kolebira\,\ Bihar",
"91483", "Manjeri\,\ Kerala",
"918543", "Wanaparthy\,\ Andhra\ Pradesh",
"9182893", "Athani\,\ Karnataka",
"9167695", "Kamakhyanagar\,\ Odisha",
"9171335", "Aheri\,\ Maharashtra",
"9171894", "Amagaon\,\ Maharashtra",
"915190", "Baberu\,\ Uttar\ Pradesh",
"915240", "Fatehpur\,\ Uttar\ Pradesh",
"915493", "Mohamdabad\,\ Uttar\ Pradesh",
"9174305", "Khanpur\,\ Rajasthan",
"9174222", "Mandsaur\,\ Madhya\ Pradesh",
"913774", "Golaghat\,\ Assam",
"911372", "Chamoli\,\ Uttarakhand",
"911666", "Sirsa\,\ Haryana",
"9168496", "Daringbadi\,\ Odisha",
"9167927", "Baripada\,\ Odisha",
"9165515", "Barkagaon\,\ Bihar",
"9176534", "Bandhavgarh\,\ Madhya\ Pradesh",
"9164792", "Udakishanganj\,\ Bihar",
"9177030", "Manpur\,\ Madhya\ Pradesh",
"913462", "Suri\,\ West\ Bengal",
"9171356", "Chamorshi\,\ Maharashtra",
"9171893", "Amagaon\,\ Maharashtra",
"9167962", "Karanjia\,\ Odisha",
"9174940", "Kolaras\,\ Madhya\ Pradesh",
"918924", "Anakapalle\,\ Andhra\ Pradesh",
"9174267", "Sitamau\,\ Madhya\ Pradesh",
"912111", "Indapur\,\ Maharashtra",
"9163466", "Lakhisarai\,\ Bihar",
"9176533", "Bandhavgarh\,\ Madhya\ Pradesh",
"914562", "Virudhunagar\,\ Tamil\ Nadu",
"9174526", "Chhabra\,\ Rajasthan",
"9174245", "Malhargarh\,\ Madhya\ Pradesh",
"9162587", "Areraj\,\ Bihar",
"9182894", "Athani\,\ Karnataka",
"9164627", "Dhamdaha\,\ Bihar",
"9165273", "Kolebira\,\ Bihar",
"912953", "Nathdwara\,\ Rajasthan",
"914931", "Nilambur\,\ Kerala",
"9162466", "Jainagar\,\ Bihar",
"9172864", "Khetia\,\ Madhya\ Pradesh",
"9168454", "Phiringia\,\ Odisha",
"912826", "Upleta\,\ Gujarat",
"916515", "Ranchi\,\ Bihar",
"9166412", "Deodgarh\,\ Odisha",
"9171856", "Pauni\,\ Maharashtra",
"918502", "Alampur\,\ Andhra\ Pradesh",
"9175927", "Vidisha\,\ Madhya\ Pradesh",
"9171393", "Kurkheda\,\ Maharashtra",
"91278", "Bhavnagar\,\ Gujarat",
"918710", "Cherial\,\ Andhra\ Pradesh",
"913841", "Vdarbondh\,\ Assam",
"918625", "Venkatgiri\,\ Andhra\ Pradesh",
"9168417", "Boudh\,\ Odisha",
"9167633", "Athmallik\,\ Odisha",
"9171573", "Arvi\,\ Maharashtra",
"914923", "Koduvayur\,\ Kerala",
"917684", "Baldeogarh\,\ Madhya\ Pradesh",
"9173246", "Mhow\,\ Madhya\ Pradesh",
"912622", "Bardoli\,\ Gujarat",
"9168182", "Buguda\,\ Odisha",
"9167634", "Athmallik\,\ Odisha",
"9171574", "Arvi\,\ Maharashtra",
"91291", "Jodhpur\,\ Rajasthan",
"9171165", "Umrer\,\ Maharashtra",
"9176375", "Birsa\,\ Madhya\ Pradesh",
"9165352", "Chainpur\,\ Bihar",
"914544", "Natham\,\ Tamil\ Nadu",
"912329", "Shahuwadi\/Malakapur\,\ Maharashtra",
"9176458", "Karanjia\,\ Madhya\ Pradesh",
"9175962", "Gyraspur\,\ Madhya\ Pradesh",
"9168453", "Phiringia\,\ Odisha",
"9172863", "Khetia\,\ Madhya\ Pradesh",
"9171786", "Sinderwahi\,\ Maharashtra",
"9171147", "Ramtek\,\ Maharashtra",
"9167492", "Bhubaneshwar\,\ Odisha",
"914287", "Rasipuram\,\ Tamil\ Nadu",
"9174685", "Khandar\,\ Rajasthan",
"9171394", "Kurkheda\,\ Maharashtra",
"9171835", "Tumsar\,\ Maharashtra",
"9174805", "Goharganj\,\ Madhya\ Pradesh",
"9174978", "Khaniadhana\,\ Madhya\ Pradesh",
"91413", "Pondicherry\,\ Tamil\ Nadu",
"918587", "Venkatgirikota\,\ Andhra\ Pradesh",
"912160", "Sakarwadi\,\ Maharashtra",
"917771", "Manendragarh\,\ Madhya\ Pradesh",
"912463", "Degloor\,\ Maharashtra",
"912188", "Mangalwedha\,\ Maharashtra",
"9171047", "Hingua\,\ Maharashtra",
"918194", "Chitradurga\,\ Karnataka",
"918244", "Mangalore\,\ Karnataka",
"917862", "Bastanar\,\ Madhya\ Pradesh",
"9167532", "Nayagarh\,\ Odisha",
"9171672", "Amarwada\,\ Madhya\ Pradesh",
"9176435", "Bijadandi\,\ Madhya\ Pradesh",
"9165414", "Chatra\,\ Bihar",
"9175969", "Gyraspur\,\ Madhya\ Pradesh",
"914893", "Androth\,\ Lakshadweep",
"911634", "Abohar\,\ Punjab",
"911985", "Kargil\,\ Jammu\ And\ Kashmir",
"9161536", "Maharajganj\,\ Bihar",
"912996", "Pokhran\/Loharki\,\ Rajasthan",
"9164342", "Dumka\,\ Bihar",
"9167577", "Daspalla\,\ Odisha",
"9174607", "Sahabad\,\ Rajasthan",
"9167255", "Dhanmandal\,\ Odisha",
"9171065", "Bhiwapur\,\ Maharashtra",
"911593", "Khetri\,\ Rajasthan",
"9165457", "Mandu\,\ Bihar",
"912838", "Mundra\,\ Gujarat",
"9167816", "Basta\,\ Odisha",
"9161555", "Ekma\,\ Bihar",
"912793", "Damnagar\,\ Gujarat",
"9167236", "Athgarh\,\ Odisha",
"9173248", "Mhow\,\ Madhya\ Pradesh",
"912801", "Ranavav\,\ Gujarat",
"917372", "Rajgarh\,\ Madhya\ Pradesh",
"917294", "Dharampuri\,\ Madhya\ Pradesh",
"9164325", "Deoghar\,\ Bihar",
"9164202", "Amarpur\,\ Bihar",
"911978", "Bilaspur\,\ Himachal\ Pradesh",
"9174976", "Khaniadhana\,\ Madhya\ Pradesh",
"9161812", "Piro\,\ Bihar",
"9176456", "Karanjia\,\ Madhya\ Pradesh",
"9165413", "Chatra\,\ Bihar",
"918512", "Adoni\,\ Andhra\ Pradesh",
"917272", "Dewas\,\ Madhya\ Pradesh",
"916414", "Bhagalpur\,\ Bihar",
"914202", "Mulanur\,\ Tamil\ Nadu",
"918700", "Warangal\,\ Andhra\ Pradesh",
"9165517", "Barkagaon\,\ Bihar",
"915964", "Pithoragarh\,\ Uttar\ Pradesh",
"917253", "Mangrulpur\,\ Maharashtra",
"9166704", "Bhawanipatna\,\ Odisha",
"9167925", "Baripada\,\ Odisha",
"911396", "Jansath\/Khatauli\,\ Uttar\ Pradesh",
"911603", "Kharar\,\ Punjab",
"911807", "Panipat\,\ Haryana",
"9172888", "Bhikangaon\,\ Madhya\ Pradesh",
"912754", "Dhrangadhra\,\ Gujarat",
"9162712", "Benipatti\,\ Bihar",
"91130", "Sonipat\,\ Haryana",
"918317", "Belgaum\,\ Karnataka",
"9174307", "Khanpur\,\ Rajasthan",
"9171337", "Aheri\,\ Maharashtra",
"917832", "Rajpur\,\ Madhya\ Pradesh",
"9167697", "Kamakhyanagar\,\ Odisha",
"918723", "Sircilla\,\ Andhra\ Pradesh",
"912433", "Gangapur\,\ Maharashtra",
"912130", "Velhe\,\ Maharashtra",
"9173939", "Jobat\,\ Madhya\ Pradesh",
"913776", "Bokakhat\,\ Assam",
"912385", "Udgir\,\ Maharashtra",
"911664", "Bhiwani\,\ Haryana",
"9181758", "Holenarasipur\,\ Karnataka",
"917577", "Harda\,\ Madhya\ Pradesh",
"918217", "Mysore\,\ Karnataka",
"9173204", "Pandhana\,\ Madhya\ Pradesh",
"91120", "Ghaziabad\/Dadri\,\ Uttar\ Pradesh",
"9171372", "Desaiganj\,\ Maharashtra",
"912378", "Medha\,\ Maharashtra",
"9176516", "Jaisinghnagar\,\ Madhya\ Pradesh",
"9174960", "Pichhore\,\ Madhya\ Pradesh",
"9167942", "Rairangpur\,\ Odisha",
"918282", "Bhadravati\,\ Karnataka",
"9164625", "Dhamdaha\,\ Bihar",
"918689", "Miryalguda\,\ Andhra\ Pradesh",
"9174247", "Malhargarh\,\ Madhya\ Pradesh",
"918450", "Andole\/Jogipet\,\ Andhra\ Pradesh",
"918153", "Bangarpet\,\ Karnataka",
"9162585", "Areraj\,\ Bihar",
"9163446", "Monghyr\,\ Bihar",
"9181939", "Hiriyur\,\ Karnataka",
"9173203", "Pandhana\,\ Madhya\ Pradesh",
"9168612", "Malkangiri\,\ Odisha",
"911899", "Chamba\,\ Himachal\ Pradesh",
"9166703", "Bhawanipatna\,\ Odisha",
"918382", "Karwar\,\ Karnataka",
"913661", "Kokrajhar\,\ Assam",
"9174265", "Sitamau\,\ Madhya\ Pradesh",
"9165876", "Chakardharpur\,\ Bihar",
"9162446", "Khagaria\,\ Bihar",
"911882", "Hoshiarpur\,\ Punjab",
"915721", "Sikandra\ Rao\,\ Uttar\ Pradesh",
"9171763", "Warora\,\ Maharashtra",
"9172886", "Bhikangaon\,\ Madhya\ Pradesh",
"9167333", "Ghatgaon\,\ Odisha",
"914177", "Arkonam\,\ Tamil\ Nadu",
"918674", "Gudivada\,\ Andhra\ Pradesh",
"918399", "Huvinahadagali\,\ Karnataka",
"9175214", "Seondha\,\ Madhya\ Pradesh",
"9168557", "Laxmipur\,\ Odisha",
"9162507", "Dhaka\,\ Bihar",
"9166815", "Jujumura\,\ Odisha",
"9181756", "Holenarasipur\,\ Karnataka",
"9166552", "Titlagarh\,\ Odisha",
"918692", "Nampalle\,\ Andhra\ Pradesh",
"917846", "Garpa\,\ Madhya\ Pradesh",
"9171693", "Batkakhapa\,\ Madhya\ Pradesh",
"9164543", "Purnea\,\ Bihar",
"913482", "Berhampur\,\ West\ Bengal",
"916124", "Patna\,\ Bihar",
"9181735", "Sakleshpur\,\ Karnataka",
"911686", "Safidon\,\ Haryana",
"91416", "Vellore\,\ Tamil\ Nadu",
"91121", "Meerut\,\ Uttar\ Pradesh",
"9171477", "Multai\,\ Madhya\ Pradesh",
"915248", "Barabanki\,\ Uttar\ Pradesh",
"9173932", "Jobat\,\ Madhya\ Pradesh",
"9174385", "Keshoraipatan\/Patan\,\ Rajasthan",
"915198", "Karvi\,\ Uttar\ Pradesh",
"918207", "Udupi\,\ Karnataka",
"9164544", "Purnea\,\ Bihar",
"9171694", "Batkakhapa\,\ Madhya\ Pradesh",
"9167334", "Ghatgaon\,\ Odisha",
"9171764", "Warora\,\ Maharashtra",
"9175213", "Seondha\,\ Madhya\ Pradesh",
"912447", "Gevrai\,\ Maharashtra",
"9166256", "Lahunipara\,\ Odisha",
"9165652", "Latehar\,\ Bihar",
"9171432", "Bhainsdehi\,\ Madhya\ Pradesh",
"91131", "Muzaffarnagar\,\ Uttar\ Pradesh",
"918938", "Sileru\,\ Andhra\ Pradesh",
"9174669", "Bonli\,\ Rajasthan",
"911996", "Doda\,\ Jammu\ And\ Kashmir",
"913667", "Bilasipara\,\ Assam",
"915364", "Kadipur\,\ Uttar\ Pradesh",
"9165236", "Ghaghra\,\ Bihar",
"9174842", "Silwani\,\ Madhya\ Pradesh",
"9168672", "Jharigan\,\ Odisha",
"9184535", "Medak\,\ Andhra\ Pradesh",
"9162284", "Pupri\,\ Bihar",
"9164387", "Madhupur\,\ Bihar",
"912593", "Surgena\,\ Maharashtra",
"9163424", "H\.Kharagpur\,\ Bihar",
"918917", "Visakhapatnam\,\ Andhra\ Pradesh",
"9165816", "Bhandaria\,\ Bihar",
"913863", "Kiphire\,\ Nagaland",
"911463", "Kishangarh\,\ Rajasthan",
"9176576", "Jaitpur\,\ Madhya\ Pradesh",
"913804", "Tezu\,\ Arunachal\ Pradesh",
"9175907", "Lateri\,\ Madhya\ Pradesh",
"9167413", "Bhubaneshwar\,\ Odisha",
"915264", "Balarampur\/Tulsipur\,\ Uttar\ Pradesh",
"9174564", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"918829", "Bhimadole\,\ Andhra\ Pradesh",
"9168637", "Bisam\ Cuttack\,\ Odisha",
"9162424", "Benipur\,\ Bihar",
"9166494", "Jamankira\,\ Odisha",
"917126", "Nagpur\,\ Maharashtra",
"9163284", "Daudnagar\,\ Bihar",
"912634", "Billimora\,\ Gujarat",
"912985", "Barmer\/Ramsar\,\ Rajasthan",
"9174825", "Raisen\,\ Madhya\ Pradesh",
"918326", "Goa",
"917756", "Lormi\,\ Madhya\ Pradesh",
"9174563", "Kishanganj\/Bhanwargarh\,\ Rajasthan",
"9167414", "Bhubaneshwar\,\ Odisha",
"9165532", "Ramgarh\,\ Bihar",
"912978", "Ahore\,\ Rajasthan",
"9171312", "Sironcha\,\ Maharashtra",
"9163283", "Daudnagar\,\ Bihar",
"9166493", "Jamankira\,\ Odisha",
"9176817", "Jatara\,\ Madhya\ Pradesh",
"9165397", "Bolwa\,\ Bihar",
"9162423", "Benipur\,\ Bihar",
"9162737", "Jhajharpur\,\ Bihar",
"917571", "Khirkiya\,\ Madhya\ Pradesh",
"915874", "Nighasan\/Dhaurehra\,\ Uttar\ Pradesh",
"918787", "Karimnagar\,\ Andhra\ Pradesh",
"9176272", "Manpur\,\ Madhya\ Pradesh",
"918226", "Chamrajnagar\,\ Karnataka",
"9165255", "Simdega\,\ Bihar",
"9165577", "Bagodar\,\ Bihar",
"912715", "Viramgam\,\ Gujarat",
"9163423", "H\.Kharagpur\,\ Bihar",
"9162283", "Pupri\,\ Bihar",
"9162772", "Phulparas\,\ Bihar",
"9174627", "Sawaimadhopur\,\ Rajasthan",
"912441", "Ashti\,\ Maharashtra",
"9167352", "Telkoi\,\ Odisha",
"9163364", "Rajauli\,\ Bihar",
"9171966", "Arjuni\ Morgaon\,\ Maharashtra",
"9164526", "Katihar\,\ Bihar",
"918301", "Mundagod\,\ Karnataka",
"9176279", "Manpur\,\ Madhya\ Pradesh",
"9165634", "Bhawanathpur\,\ Bihar",
"917365", "Mahidpurcity\,\ Madhya\ Pradesh",
"918473", "Yadgiri\,\ Karnataka",
"9164245", "Banka\,\ Bihar",
"9171454", "Chicholi\,\ Madhya\ Pradesh",
"916634", "Sambalpur\,\ Odisha",
"9164267", "Rajmahal\,\ Bihar",
"9166533", "Dunguripali\,\ Odisha",
"911826", "Phillaur\,\ Punjab",
"9165492", "Bermo\,\ Bihar",
"9168573", "Gunupur\,\ Odisha",
"9161356", "Bikram\,\ Bihar",
"9161893", "Bhabhua\,\ Bihar",
"9171417", "Betul\,\ Madhya\ Pradesh",
"912162", "Satara\,\ Maharashtra",
"9176578", "Jaitpur\,\ Madhya\ Pradesh",
"9173954", "Sondhwa\,\ Madhya\ Pradesh",
"917265", "Nandura\,\ Maharashtra",
"918510", "Koilkuntla\,\ Andhra\ Pradesh",
"91203", "Pune\,\ Maharashtra",
"917270", "Sonkatch\,\ Madhya\ Pradesh",
"9166534", "Dunguripali\,\ Odisha",
"918702", "Warangal\,\ Andhra\ Pradesh",
"9168165", "Mohana\,\ Odisha",
"9161894", "Bhabhua\,\ Bihar",
"915922", "Amroha\,\ Uttar\ Pradesh",
"9171182", "Kalmeshwar\,\ Maharashtra",
"916715", "Cuttack\,\ Odisha",
"915313", "Salon\/Jais\,\ Uttar\ Pradesh",
"9168574", "Gunupur\,\ Odisha",
"9164222", "Godda\,\ Bihar",
"9173953", "Sondhwa\,\ Madhya\ Pradesh",
"9163363", "Rajauli\,\ Bihar",
"914171", "Gudiyatham\,\ Tamil\ Nadu",
"912844", "Mahuva\,\ Gujarat",
"911505", "Padampur\,\ Rajasthan",
"917370", "Khilchipur\,\ Madhya\ Pradesh",
"9165633", "Bhawanathpur\,\ Bihar",
"915948", "Khatima\/Sitarganj\,\ Uttar\ Pradesh",
"9168147", "Digapahandi\,\ Odisha",
"918338", "Chikkodi\,\ Karnataka",
"9174662", "Bonli\,\ Rajasthan",
"91191", "Jammu\,\ Jammu\ And\ Kashmir",
"9171453", "Chicholi\,\ Madhya\ Pradesh",
"9168215", "Bhanjanagar\,\ Odisha",
"9174849", "Silwani\,\ Madhya\ Pradesh",
"914281", "Yercaud\,\ Tamil\ Nadu",
"9164755", "S\.Bakhtiarpur\,\ Bihar",
"9173224", "Depalpur\,\ Madhya\ Pradesh",
"9171984", "Tirora\,\ Maharashtra",
"9171557", "Seloo\,\ Maharashtra",
"917235", "Pandharkawada\,\ Maharashtra",
"916807", "Berhampur\,\ Odisha",
"9174918", "Narwar\,\ Madhya\ Pradesh",
"912132", "Junnar\,\ Maharashtra",
"91462", "Tirunelvelli\,\ Tamil\ Nadu",
"9168693", "Papadhandi\,\ Odisha",
"9171514", "Samudrapur\,\ Maharashtra",
"9174327", "Jhalawar\,\ Rajasthan",
"9167652", "Palla\ Hara\,\ Odisha",
"9176294", "Pushprajgarh\,\ Madhya\ Pradesh",
"914323", "Kulithalai\,\ Tamil\ Nadu",
"9162794", "Barauni\,\ Bihar",
"915176", "Lalitpur\,\ Uttar\ Pradesh",
"9166724", "Dharamgarh\,\ Odisha",
"9165334", "Basia\,\ Bihar",
"9165895", "Jhinkpani\,\ Bihar",
"912455", "Kalamnuri\,\ Maharashtra",
"9174588", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"9171513", "Samudrapur\,\ Maharashtra",
"918135", "Sira\,\ Karnataka",
"9168694", "Papadhandi\,\ Odisha",
"9168477", "G\.Udayagiri\,\ Odisha",
"9176293", "Pushprajgarh\,\ Madhya\ Pradesh",
"9166723", "Dharamgarh\,\ Odisha",
"9162793", "Barauni\,\ Bihar",
"918368", "Hubli\,\ Karnataka",
"918380", "Navalgund\,\ Karnataka",
"9175299", "Laher\,\ Madhya\ Pradesh",
"91231", "Kolhapur\,\ Maharashtra",
"9174362", "Hindoli\,\ Rajasthan",
"9165333", "Basia\,\ Bihar",
"917824", "Bemetara\,\ Madhya\ Pradesh",
"915521", "Bansgaon\/Barhal\ Ganj\,\ Uttar\ Pradesh",
"9166437", "Barkot\,\ Odisha",
"918452", "Medak\,\ Andhra\ Pradesh",
"9168432", "Puruna\ Katak\,\ Odisha",
"9164736", "Supaul\,\ Bihar",
"9171983", "Tirora\,\ Maharashtra",
"91206", "Pune\,\ Maharashtra",
"912929", "Shergarh\/Balesar\,\ Rajasthan",
"9173223", "Depalpur\,\ Madhya\ Pradesh",
"9166472", "Naktideul\,\ Odisha",
"9177064", "Gariaband\,\ Madhya\ Pradesh",
"9176560", "Kannodi\,\ Madhya\ Pradesh",
"9174916", "Narwar\,\ Madhya\ Pradesh",
"911433", "Todaraisingh\,\ Rajasthan",
"9162266", "Sitamarhi\,\ Bihar",
"9167553", "Khurda\,\ Odisha",
"913659", "Resubelpara\/Mendipathar\,\ Meghalaya",
"9165942", "Baharagora\,\ Bihar",
"913252", "Purulia\,\ West\ Bengal",
"912664", "Pavijetpur\,\ Gujarat",
"9165473", "Chavparan\,\ Bihar",
"9168592", "Motu\,\ Odisha",
"9161872", "Mohania\,\ Bihar",
"9162527", "Motihari\,\ Bihar",
"9161145", "Jahanabad\,\ Bihar",
"918944", "Bobbili\,\ Andhra\ Pradesh",
"915334", "Meja\/Sirsa\,\ Uttar\ Pradesh",
"913637", "Cherrapunjee\,\ Meghalaya",
"9175292", "Laher\,\ Madhya\ Pradesh",
"9174369", "Hindoli\,\ Rajasthan",
"9174586", "Pipalda\/Sumerganj\ Mandi\,\ Rajasthan",
"911285", "Mohindergarh\,\ Haryana",
"9163266", "Sherghati\,\ Bihar",
"91230", "Khadakwasala\,\ Maharashtra",
"9161837", "Buxar\,\ Bihar",
"913798", "Mariyang\,\ Arunachal\ Pradesh",
"912554", "Malegaon\,\ Maharashtra",
"915825", "Nawabganj\,\ Uttar\ Pradesh",
"9174850", "Udaipura\,\ Madhya\ Pradesh",
"9162562", "Ramnagar\,\ Bihar",
"911378", "Devprayag\,\ Uttarakhand",
"9177063", "Gariaband\,\ Madhya\ Pradesh",
"9161122", "Biharsharif\,\ Bihar",
"917777", "Pratappur\,\ Madhya\ Pradesh",
"913751", "Digboi\,\ Assam",
"916613", "Rourkela\,\ Odisha",
"918581", "Punganur\,\ Andhra\ Pradesh",
"9167554", "Khurda\,\ Odisha",
"9165697", "Garu\,\ Bihar",
"918523", "Alur\,\ Andhra\ Pradesh",
"9171612", "Parasia\,\ Madhya\ Pradesh",
"9165474", "Chavparan\,\ Bihar",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+91|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;