# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210919194237;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          9(?:
            0[01]|
            3[019]
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"432242", "Sankt\ Andrä\-Wördern",
"436565", "Neukirchen\ am\ Großvenediger",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"4313", "Wien",
"4312", "Wien",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432617", "Draßmarkt",
"432815", "Großschönau",
"432847", "Groß\-Siegharts",
"432857", "Bad\ Großpertholz",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"433537", "Sankt\ Georgen\ ob\ Murau",
"435245", "Hinterriß",
"437477", "Sankt\ Peter\ in\ der\ Au",
"433362", "Großpetersdorf",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"433327", "Sankt\ Michael\ im\ Burgenland",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"435678", "Weißenbach\ am\ Lech",
"436414", "Großarl",
"434843", "Außervillgraten",
"435446", "Sankt\ Anton\ am\ Arlberg",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"437254", "Großraming",
"432647", "Krumbach\,\ Niederösterreich",
"437219", "Vorderweißenbach",
"432686", "Draßburg",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"437566", "Rosenau\ am\ Hengstpaß",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434876", "Kals\ am\ Großglockner",
"434266", "Straßburg",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"437954", "Sankt\ Georgen\ am\ Walde",
"433868", "Tragöß",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433464", "Groß\ Sankt\ Florian",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"437218", "Großtraberg",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"433834", "Wald\ am\ Schoberpaß",
"4319", "Wien",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"436227", "Sankt\ Gilgen",
"432618", "Markt\ Sankt\ Martin",
"436277", "Sankt\ Pantaleon",
"432822", "Zwettl\-Niederösterreich",
"432719", "Droß",
"433469", "Sankt\ Oswald\ im\ Freiland",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"4317", "Wien",
"432556", "Großkrut",
"437667", "Sankt\ Georgen\ im\ Attergau",
"434264", "Klein\ Sankt\ Paul",
"436477", "Sankt\ Michael\ im\ Lungau",
"437717", "Sankt\ Aegidi",
"432629", "Warth\,\ Niederösterreich",
"437956", "Unterweißenbach",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"432742", "Sankt\ Pölten",
"433585", "Sankt\ Lambrecht",
"435352", "Sankt\ Johann\ in\ Tirol",
"436241", "Sankt\ Koloman",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"434286", "Weißbriach",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"434879", "Sankt\ Veit\ in\ Defereggen",
"4316", "Wien",
"432674", "Weißenbach\ an\ der\ Triesting",
"433119", "Sankt\ Marein\ bei\ Graz",
"437565", "Sankt\ Pankraz",
"435557", "Sankt\ Gallenkirch",
"432642", "Aspangberg\-Sankt\ Peter",
"432249", "Groß\-Enzersdorf",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432812", "Groß\ Gerungs",
"433632", "Sankt\ Gallen",
"433575", "Sankt\ Johann\ am\ Tauern",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"434825", "Großkirchheim",
"437435", "Sankt\ Valentin",
"433386", "Großsteinbach",
"436412", "Sankt\ Johann\ im\ Pongau",
"435279", "Sankt\ Jodok\ am\ Brenner",
"437224", "Sankt\ Florian",
"437751", "Sankt\ Martin\ im\ Innkreis",
"432263", "Großrußbach",
"433684", "Sankt\ Martin\ am\ Grimming",
"436276", "Nußdorf\ am\ Haunsberg",
"434253", "Sankt\ Jakob\ im\ Rosental",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432823", "Großglobnitz",
"435449", "Fließ",
"433158", "Sankt\ Anna\ am\ Aigen",
"432955", "Großweikersdorf",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"432756", "Sankt\ Leonhard\ am\ Forst",
"4315", "Wien",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"434877", "Prägraten\ am\ Großvenediger",
"4318", "Wien",
"432233", "Preßbaum",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"4314", "Wien",
"432268", "Großmugl",
"434358", "Sankt\ Andrä",
"436215", "Straßwalchen",
"436247", "Großgmain",
"434785", "Außerfragant",
"434783", "Reißeck",};
$areanames{en} = {"432747", "Ober\-Grafendorf",
"432620", "Willendorf",
"433175", "Anger",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"435442", "Landeck",
"432555", "Herrnbaumgarten",
"432713", "Spitz",
"433173", "Ratten",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"437214", "Reichenthal",
"437712", "Schärding",
"433323", "Eberau",
"437583", "Kremsmünster",
"436472", "Mauterndorf",
"434767", "Rothenthurn",
"432177", "Podersdorf\ am\ See",
"437479", "Ardagger",
"433125", "Übelbach",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"437943", "Windhaag\ bei\ Freistadt",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"432786", "Oberwölbling",
"437218", "Grosstraberg",
"435474", "Pfunds",
"432277", "Zwentendorf",
"432631", "Pöttsching",
"432942", "Retz",
"432983", "Sigmundsherberg",
"437746", "Friedburg",
"433184", "Wolfsberg\ im\ Schwarzautal",
"435579", "Alberschwende",
"432739", "Tiefenfucha",
"437662", "Seewalchen\ am\ Attersee",
"437269", "Baumgartenberg",
"432634", "Gutenstein",
"432985", "Gars\ am\ Kamp",
"432952", "Hollabrunn",
"432665", "Prein\ an\ der\ Rax",
"433513", "Bischoffeld",
"437226", "Wilhering",
"437955", "Königswiesen",
"434847", "Obertilliach",
"437953", "Liebenau",
"436454", "Mandling",
"435264", "Mieming",
"436549", "Piesendorf",
"434236", "Eberndorf",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432663", "Schottwien",
"435335", "Hopfgarten\ im\ Brixental",
"432916", "Riegersburg\,\ Hardegg",
"437211", "Reichenau\ im\ Mühlkreis",
"433865", "Kindberg",
"4319", "Vienna",
"435280", "Hochfügen",
"433863", "Turnau",
"436458", "Hüttau",
"435333", "Söll",
"432757", "Pöchlarn",
"437276", "Peuerbach",
"433586", "Mühlen",
"433463", "Stainz",
"433465", "Pölfing\-Brunn",
"433834", "Wald\ am\ Schoberpass",
"432638", "Winzendorf\-Muthmannsdorf",
"432822", "Zwettl\,\ Lower\ Austria",
"434271", "Steuerberg",
"433179", "Passail",
"432614", "Kleinwarasdorf",
"432719", "Dross",
"435213", "Scharnitz",
"433366", "Kohfidisch",
"432844", "Karlstein\ an\ der\ Thaya",
"434230", "Globasnitz",
"433535", "Krakaudorf",
"433329", "Jennersdorf",
"436277", "St\.\ Pantaleon",
"434352", "Wolfsberg",
"433533", "Turrach",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"437949", "Rainbach\ im\ Mühlkreis",
"434221", "Gallizien",
"435286", "Ginzling",
"432872", "Ottenschlag",
"437473", "Blindenmarkt",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"437231", "Herzogsdorf",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432618", "Markt\ St\.\ Martin",
"436227", "St\.\ Gilgen",
"433622", "Bad\ Aussee",
"434252", "Wernberg",
"434285", "Tröpolach",
"433476", "Bad\ Radkersburg",
"432162", "Bruck\ an\ der\ Leitha",
"432733", "Schönberg\ am\ Kamp",
"435239", "Kühtai",
"435575", "Langen\ bei\ Bregenz",
"437263", "Bad\ Zell",
"435632", "Stanzach",
"434278", "Gnesau",
"432735", "Hadersdorf\ am\ Kamp",
"437265", "Pabneukirchen",
"435573", "Hörbranz",
"432626", "Mattersburg",
"432989", "Brunn\ an\ der\ Wild",
"434242", "Villach",
"432262", "Korneuburg",
"436543", "Taxenbach",
"432858", "Moorbad\ Harbach",
"437732", "Haag\ am\ Hausruck",
"437488", "Steinakirchen\ am\ Forst",
"437234", "Ottensheim",
"432764", "Hainfeld",
"435357", "Kirchberg\ in\ Tirol",
"434224", "Pischeldorf",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"435525", "Nenzing",
"435339", "Wildschönau",
"432854", "Kirchberg\ am\ Walde",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437238", "Mauthausen",
"437484", "Göstling\ an\ der\ Ybbs",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"432841", "Vitis",
"435523", "Götzis",
"434228", "Feistritz\ im\ Rosental",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"434274", "Velden\ am\ Wörther\ See",
"433469", "St\.\ Oswald\ im\ Freiland",
"436467", "Mühlbach\ am\ Hochkönig",
"437750", "Andrichsfurt",
"433847", "Trofaiach",
"432731", "Idolsberg",
"437261", "Schönau\ im\ Mühlkreis",
"434782", "Obervellach",
"434284", "Kirchbach",
"433617", "Gaishorn\ am\ See",
"437474", "Euratsfeld",
"433136", "Dobl",
"436541", "Saalbach",
"436212", "Seekirchen\ am\ Wallersee",
"432686", "Drassburg",
"435516", "Doren",
"437478", "Oed\-Oehling",
"433336", "Waldbach",
"433534", "Stadl\ an\ der\ Mur",
"432845", "Weikertschlag\ an\ der\ Thaya",
"437442", "Waidhofen\ an\ der\ Ybbs",
"437219", "Vorderweissenbach",
"437612", "Gmunden",
"433886", "Weichselboden",
"432843", "Dobersberg",
"432615", "Lutzmannsburg",
"435585", "Dalaas",
"435552", "Bludenz",
"432647", "Krumbach\,\ Lower\ Austria",
"435214", "Leutasch",
"432613", "Deutschkreutz",
"435583", "Lech",
"435578", "Höchst",
"434273", "Reifnitz",
"436246", "Grödig",
"437268", "Grein",
"434275", "Ebene\ Reichenau",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"432738", "Fels\ am\ Wagram",
"432855", "Waldenstein",
"435276", "Gschnitz",
"435524", "Satteins",
"437485", "Gaming",
"437483", "Oberndorf\ an\ der\ Melk",
"437566", "Rosenau\ am\ Hengstpass",
"436548", "Niedernsill",
"432853", "Schrems",
"434223", "Maria\ Saal",
"432765", "Kaumberg",
"437235", "Gallneukirchen",
"433682", "Stainach",
"437471", "Neustadtl\ an\ der\ Donau",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437233", "Feldkirchen\ an\ der\ Donau",
"436544", "Rauris",
"434225", "Grafenstein",
"433457", "Gleinstätten",
"433857", "Neuberg\ an\ der\ Mürz",
"435574", "Bregenz",
"435376", "Thiersee",
"435226", "Neustift\ im\ Stubaital",
"437264", "Windhaag\ bei\ Perg",
"437416", "Wieselburg",
"432734", "Langenlois",
"432232", "Fischamend",
"434717", "Steinfeld",
"432639", "Bad\ Fischau",
"437762", "Raab",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435475", "Feichten",
"432718", "Lichtenau\ im\ Waldviertel",
"434876", "Kals\ am\ Grossglockner",
"437286", "Lembach\ im\ Mühlkreis",
"433576", "Bretstein",
"433142", "Voitsberg",
"436240", "Krispl",
"435677", "Vils",
"435473", "Nauders",
"437588", "Ried\ im\ Traunkreis",
"433328", "Kukmirn",
"433124", "Gratkorn",
"437944", "Sandl",
"436417", "Hüttschlag",
"432256", "Leobersdorf",
"437584", "Molln",
"432849", "Schwarzenau",
"434826", "Mörtschach",
"433324", "Strem",
"437213", "Bad\ Leonfelden",
"437948", "Hirschbach\ im\ Mühlkreis",
"435331", "Brandenberg",
"437215", "Hellmonsödt",
"433861", "Aflenz",
"437247", "Kematen\ am\ Innbach",
"433461", "Trahütten",
"432619", "Lackendorf",
"433174", "Birkfeld",
"432212", "Orth\ an\ der\ Donau",
"432714", "Rossatz",
"437727", "Ach",
"432554", "Stützenhofen",
"433385", "Ilz",
"433352", "Oberwart",
"433833", "Traboch",
"435238", "Zirl",
"432287", "Strasshof\ an\ der\ Nordbahn",
"436132", "Bad\ Ischl",
"434279", "Sirnitz",
"433171", "Gasen",
"433464", "Gross\ St\.\ Florian",
"433383", "Burgau",
"432711", "Dürnstein",
"432988", "Neupölla",
"432859", "Brand\-Nagelberg",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"435510", "Damüls",
"435334", "Westendorf",
"433864", "St\.\ Marein\ im\ Mürztal",
"437489", "Purgstall\ an\ der\ Erlauf",
"436232", "Mondsee",
"433116", "Kirchbach\ in\ Steiermark",
"432522", "Laa\ an\ der\ Thaya",
"437257", "Grünburg",
"433637", "Gams\ bei\ Hieflau",
"432664", "Semmering",
"435338", "Kundl",
"437954", "St\.\ Georgen\ am\ Walde",
"436453", "Filzmoos",
"432769", "Türnitz",
"435263", "Silz",
"437239", "Lichtenberg",
"433868", "Tragöss",
"435265", "Nassereith",
"436455", "Untertauern",
"433514", "Seckau",
"437941", "Neumarkt\ im\ Mühlkreis",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432246", "Gerasdorf\ bei\ Wien",
"432633", "Markt\ Piesting",
"434266", "Strassburg",
"433185", "Preding",
"433152", "Feldbach",
"435234", "Axams",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"437357", "Kleinreifling",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"432726", "Puchenstuben",
"432146", "Nickelsdorf",
"432635", "Neunkirchen",
"432572", "Mistelbach",
"432984", "Eggenburg",
"437673", "Schwanenstadt",
"433614", "Rottenmann",
"437477", "St\.\ Peter\ in\ der\ Au",
"437675", "Ampflwang\ im\ Hausruckwald",
"432648", "Hochneukirchen",
"432279", "Kirchberg\ am\ Wagram",
"436225", "Eugendorf",
"433844", "Kammern\ im\ Liesingtal",
"432535", "Hohenau\ an\ der\ March",
"432672", "Berndorf",
"432533", "Neusiedl\ an\ der\ Zaya",
"436223", "Anthering",
"432644", "Grimmenstein",
"435243", "Maurach",
"432749", "Prinzersdorf",
"433848", "Eisenerz",
"435245", "Hinterriss",
"432266", "Stockerau",
"436470", "Atzmannsdorf",
"437736", "Pram",
"43662", "Salzburg",
"432622", "Wiener\ Neustadt",
"434246", "Radenthein",
"432814", "Langschlag",
"433618", "Hohentauern",
"433537", "St\.\ Georgen\ ob\ Murau",
"43732", "Linz",
"434769", "Möllbrücke",
"433472", "Mureck",
"432166", "Parndorf",
"434256", "Nötsch\ im\ Gailtal",
"436434", "Bad\ Gastein",
"437684", "Frankenmarkt",
"433858", "Mitterdorf\ im\ Mürztal",
"436463", "Annaberg\-Lungötz",
"435253", "Längenfeld",
"435255", "Umhausen",
"432876", "Els",
"435282", "Zell\ am\ Ziller",
"432641", "Kirchberg\ am\ Wechsel",
"434718", "Dellach",
"435577", "Lustenau",
"433854", "Langenwang",
"434356", "Lavamünd",
"434714", "Dellach\ im\ Drautal",
"434212", "St\.\ Veit\ an\ der\ Glan",
"437267", "Mönchdorf",
"435353", "Waidring",
"433362", "Grosspetersdorf",
"433454", "Leutschach",
"436547", "Kaprun",
"432826", "Rastenfeld",
"435355", "Jochberg",
"433611", "Johnsbach",
"437947", "Kefermarkt",
"433127", "Peggau",
"434853", "Ainet",
"432175", "Apetlon",
"432173", "Gols",
"437248", "Grieskirchen",
"436414", "Grossarl",
"437272", "Eferding",
"433582", "Scheifling",
"434855", "Assling",
"432275", "Atzenbrugg",
"436229", "Hof\ bei\ Salzburg",
"432273", "Tulbing",
"435674", "Bichlbach",
"432912", "Geras",
"437728", "Schwand\ im\ Innkreis",
"432717", "Unter\-Meisling",
"434232", "Völkermarkt",
"435412", "Imst",
"434734", "Rennweg",
"432745", "Pyhra",
"433177", "Puch\ bei\ Weiz",
"432743", "Böheimkirchen",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"435678", "Weissenbach\ am\ Lech",
"436564", "Krimml",
"432557", "Bernhardsthal",
"437724", "Mauerkirchen",
"433631", "Unterlaussa",
"432956", "Ziersdorf",
"437251", "Schiedlberg",
"437666", "Attersee",
"433327", "St\.\ Michael\ im\ Burgenland",
"437587", "Wartberg\ an\ der\ Krems",
"437244", "Sattledt",
"436418", "Kleinarl",
"437742", "Mattighofen",
"433867", "Pernegg\ an\ der\ Mur",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432946", "Pulkau",
"435337", "Brixlegg",
"437254", "Grossraming",
"433634", "Hieflau",
"437752", "Ried\ im\ Innkreis",
"432284", "Oberweiden",
"432755", "Mank",
"432782", "Herzogenburg",
"432753", "Gansbach",
"433467", "Schwanberg",
"432288", "Auersthal",
"437716", "Münzkirchen",
"432865", "Litschau",
"436476", "St\.\ Margarethen\ im\ Lungau",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"432863", "Eggern",
"434843", "Ausservillgraten",
"432160", "Jois",
"432667", "Schwarzau\ im\ Gebirge",
"433638", "Palfau",
"435446", "St\.\ Anton\ am\ Arlberg",
"437258", "Bad\ Hall",
"434240", "Bad\ Kleinkirchheim",
"43316", "Graz",
"435359", "Hochfilzen",
"432142", "Gattendorf",
"435550", "Thüringen",
"432576", "Ernstbrunn",
"432722", "Kirchberg\ an\ der\ Pielach",
"437243", "Marchtrenk",
"437245", "Lambach",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"434858", "Nikolsdorf",
"434262", "Treibach",
"432242", "St\.\ Andrä\-Wördern",
"437723", "Altheim",
"432649", "Mönichkirchen",
"436563", "Uttendorf",
"434735", "Kremsbrücke",
"432278", "Absdorf",
"432744", "Kasten\ bei\ Böheimkirchen",
"434733", "Malta",
"436565", "Neukirchen\ am\ Grossvenediger",
"43512", "Innsbruck",
"432772", "Neulengbach",
"435673", "Ehrwald",
"432526", "Stronsdorf",
"433849", "Vordernberg",
"433112", "Gleisdorf",
"435477", "Tösens",
"432274", "Sieghartskirchen",
"432748", "Kilb",
"435675", "Tannheim",
"436413", "Wagrain",
"436136", "Gosau",
"432174", "Wallern\ im\ Burgenland",
"433619", "Oppenberg",
"434768", "Kleblach\-Lind",
"436415", "Schwarzach\ im\ Pongau",
"433356", "Markt\ Allhau",
"437432", "Strengberg",
"4312", "Vienna",
"436457", "Flachau",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"432230", "Schwadorf",
"432864", "Kautzen",
"437353", "Gaflenz",
"432758", "Pöggstall",
"433680", "Donnersbachwald",
"433859", "Mürzsteg",
"432637", "Grünbach\ am\ Schneeberg",
"437355", "Weyer",
"432271", "Ried\ am\ Riederberg",
"434822", "Winklern",
"432285", "Marchegg",
"432252", "Baden",
"432754", "Loosdorf",
"433387", "Söchau",
"432741", "Flinsbach",
"4313", "Vienna",
"432283", "Angern\ an\ der\ March",
"434761", "Stockenboi",
"437253", "Wolfern",
"433633", "Landl",
"434872", "Huben",
"437282", "Neufelden",
"433635", "Radmer",
"433572", "Judenburg",
"437255", "Losenstein",
"433146", "Modriach",
"434848", "Kartitsch",
"432815", "Grossschönau",
"432236", "Mödling",
"437766", "Andorf",
"436274", "Lamprechtshausen",
"432847", "Gross\-Siegharts",
"437412", "Ybbs\ an\ der\ Donau",
"435372", "Kufstein",
"437249", "Bad\ Schallerbach",
"432813", "Arbesbach",
"432645", "Wiesmath",
"436461", "Dienten\ am\ Hochkönig",
"436228", "Faistenau",
"432538", "Velm\-Götzendorf",
"432617", "Drassmarkt",
"435244", "Jenbach",
"433686", "Haus",
"437729", "Neukirchen\ an\ der\ Enknach",
"432643", "Lichtenegg",
"437562", "Windischgarsten",
"433845", "Mautern\ in\ Steiermark",
"432534", "Niedersulz",
"436224", "Hintersee",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"435248", "Steinberg\ am\ Rofan",
"435272", "Steinach\ am\ Brenner",
"436278", "Ostermiething",
"436242", "Russbach\ am\ Pass\ Gschütt",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"433615", "Trieben",
"433613", "Admont",
"437674", "Attnang\-Puchheim",
"432767", "Hohenberg",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"433150", "Paldau",
"433453", "Ehrenhausen",
"434227", "Ferlach",
"433455", "Arnfels",
"435556", "Schruns",
"435354", "Fieberbrunn",
"434713", "Techendorf",
"433882", "Mariazell",
"433855", "Krieglach",
"437616", "Grünau\ im\ Almtal",
"436468", "Werfen",
"434715", "Kötschach\-Mauthen",
"433853", "Spital\ am\ Semmering",
"433332", "Hartberg",
"436221", "Koppl",
"435512", "Egg",
"432682", "Eisenstadt",
"432289", "Matzen",
"435254", "Sölden",
"436216", "Neumarkt\ am\ Wallersee",
"433132", "Kumberg",
"434277", "Glanegg",
"437487", "Gresten",
"432857", "Bad\ Grosspertholz",
"437683", "Frankenburg\ am\ Hausruck",
"437259", "Sierning",
"436433", "Dorfgastein",
"435358", "Ellmau",
"435441", "See",
"432958", "Maissau",
"433353", "Oberschützen",
"433832", "Kraubath\ an\ der\ Mur",
"436135", "Bad\ Goisern",
"432257", "Klausen\-Leopoldsdorf",
"436133", "Ebensee",
"436416", "Lend",
"433382", "Fürstenfeld",
"433355", "Stadtschlaining",
"433577", "Zeltweg",
"437287", "Peilstein\ im\ Mühlviertel",
"434877", "Prägraten\ am\ Grossvenediger",
"436235", "Thalgau",
"432525", "Gnadendorf",
"436471", "Tweng",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"437711", "Suben",
"436233", "Oberwang",
"435676", "Jungholz",
"434710", "Oberdrauburg",
"434736", "Innerkrems",
"435262", "Telfs",
"436452", "Radstadt",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"436483", "Göriach",
"436566", "Bramberg\ am\ Wildkogel",
"432954", "Göllersdorf",
"432575", "Ladendorf",
"432632", "Pernitz",
"432239", "Breitenfurt\ bei\ Wien",
"437664", "Weyregg\ am\ Attersee",
"433153", "Riegersburg",
"437246", "Gunskirchen",
"433182", "Wildon",
"433155", "Fehring",
"432573", "Wilfersdorf",
"432944", "Haugsdorf",
"433143", "Krottendorf",
"433145", "Edelschrott",
"437256", "Ternberg",
"435448", "Pettneu\ am\ Arlberg",
"433636", "Wildalpen",
"432951", "Guntersdorf",
"435472", "Prutz",
"433117", "Eggersdorf\ bei\ Graz",
"437718", "Waldkirchen\ am\ Wesen",
"432286", "Obersiebenbrunn",
"436478", "Zederhaus",
"436219", "Obertrum\ am\ See",
"437714", "Esternberg",
"436474", "Tamsweg",
"434267", "Metnitz",
"437619", "Kirchham",
"437212", "Zwettl\ an\ der\ Rodl",
"432147", "Zurndorf",
"432213", "Lassee",
"432948", "Weitersfeld",
"435444", "Ischgl",
"432247", "Deutsch\-Wagram",
"432215", "Probstdorf",
"435559", "Brand",
"433137", "Söding",
"434248", "Treffen",
"437250", "Maria\ Neustift",
"433616", "Selzthal",
"434272", "Pörtschach\ am\ Wörther\ See",
"435517", "Riezlern",
"432687", "Siegendorf",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433359", "Loipersdorf\-Kitzladen",
"433846", "Kalwang",
"437482", "Scheibbs",
"432268", "Grossmugl",
"432852", "Gmünd",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"433683", "Donnersbach",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"433685", "Gröbming",
"432762", "Lilienfeld",
"4314", "Vienna",
"432264", "Rückersdorf\,\ Harmannsdorf",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437765", "Lambrechten",
"434244", "Bad\ Bleiberg",
"432235", "Maria\-Lanzendorf",
"432816", "Karlstift",
"433337", "Vorau",
"4318", "Vienna",
"433159", "Bad\ Gleichenberg",
"435634", "Elbigenalp",
"432164", "Rohrau",
"437763", "Kopfing\ im\ Innkreis",
"432233", "Pressbaum",
"434254", "Faak\ am\ See",
"434785", "Ausserfragant",
"433149", "Geistthal",
"434783", "Reisseck",
"433624", "Pichl\-Kainisch",
"432828", "Rappottenstein",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"436213", "Oberhofen\ am\ Irrsee",
"434358", "St\.\ Andrä",
"436215", "Strasswalchen",
"432874", "Martinsberg",
"436247", "Grossgmain",
"436588", "Lofer",
"434354", "Preitenegg",
"437615", "Scharnstein",
"433856", "Veitsch",
"437443", "Ybbsitz",
"437613", "Laakirchen",
"434716", "Lesachtal",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432878", "Traunstein",
"432842", "Waidhofen\ an\ der\ Thaya",
"434258", "Gummern",
"435553", "Raggal",
"437240", "Sipbachzell",
"433456", "Fresing",
"432824", "Allentsteig",
"435582", "Klösterle",
"432612", "Oberpullendorf",
"434245", "Feistritz\ an\ der\ Drau",
"432234", "Gramatneusiedl",
"432959", "Sitzendorf\ an\ der\ Schmida",
"432163", "Petronell\-Carnuntum",
"437764", "Riedau",
"436276", "Nussdorf\ am\ Haunsberg",
"435633", "Hägerau",
"437262", "Perg",
"432732", "Krems\ an\ der\ Donau",
"435572", "Dornbirn",
"435635", "Elmen",
"434243", "Bodensdorf",
"432165", "Hainburg\ a\.d\.\ Donau",
"437733", "Neumarkt\ im\ Hausruckkreis",
"436542", "Zell\ am\ See",
"432263", "Grossrussbach",
"435246", "Achenkirch",
"433684", "St\.\ Martin\ am\ Grimming",
"437735", "Gaspoltshofen",
"432265", "Hausleiten",
"432536", "Drösing",
"436226", "Fuschl\ am\ See",
"433688", "Tauplitz",
"435522", "Feldkirch",
"435287", "Tux",
"432238", "Kaltenleutgeben",
"437676", "Ottnang\ am\ Hausruck",
"432823", "Grossglobnitz",
"435212", "Seefeld\ in\ Tirol",
"435449", "Fliess",
"435554", "Sonntag",
"435356", "Kitzbühel",
"432825", "Göpfritz\ an\ der\ Wild",
"436479", "Muhr",
"437719", "Taufkirchen\ an\ der\ Pram",
"433477", "St\.\ Peter\ am\ Ottersbach",
"434355", "Gemmersdorf",
"437614", "Vorchdorf",
"437444", "Opponitz",
"434353", "Prebl",
"432627", "Pitten",
"433532", "Murau",
"432873", "Kottes",
"437618", "Neukirchen\,\ Altmünster",
"437448", "Kematen\ an\ der\ Ybbs",
"436466", "Werfenweng",
"435256", "Untergurgl",
"432875", "Grafenschlag",
"436214", "Henndorf\ am\ Wallersee",
"437472", "Amstetten",
"436583", "Leogang",
"432949", "Niederfladnitz",
"434255", "Arnoldstein",
"434282", "Hermagor",
"434784", "Mallnitz",
"433623", "Bad\ Mitterndorf",
"432231", "Purkersdorf",
"435558", "Gaschurn",
"434253", "St\.\ Jakob\ im\ Rosental",
"433141", "Hirschegg",
"432574", "Gaweinstal",
"432982", "Horn",
"432955", "Grossweikersdorf",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"437665", "Unterach\ am\ Attersee",
"434766", "Millstatt",
"437663", "Steinbach\ am\ Attersee",
"435232", "Kematen\ in\ Tirol",
"433358", "Litzelsdorf",
"432953", "Nappersdorf",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"433512", "Knittelfeld",
"436484", "Lessach",
"432746", "Wilhelmsburg",
"437952", "Weitersfelden",
"432662", "Gloggnitz",
"432269", "Niederfellabrunn",
"432524", "Kautendorf",
"436234", "Zell\ am\ Moos",
"432276", "Reidling",
"437757", "Gurten",
"433862", "Bruck\ an\ der\ Mur",
"435332", "Wörgl",
"436134", "Hallstatt",
"433462", "Deutschlandsberg",
"432176", "Tadten",
"433158", "St\.\ Anna\ am\ Aigen",
"433354", "Bernstein",
"437227", "Neuhofen\ an\ der\ Krems",
"435443", "Galtür",
"432552", "Poysdorf",
"432712", "Aggsbach",
"434237", "Miklauzhof",
"435445", "Kappl",
"433148", "Kainach\ bei\ Voitsberg",
"433172", "Weiz",
"432829", "Schweiggers",
"432214", "Kopfstetten",
"436131", "Obertraun",
"434846", "Abfaltersbach",
"435417", "Roppen",
"436475", "Ramingstein",
"437747", "Kirchberg\ bei\ Mattighofen",
"434359", "Reichenfels",
"437582", "Kirchdorf\ an\ der\ Krems",
"436473", "Mariapfarr",
"433322", "Güssing",
"437713", "Schardenberg",
"436589", "Unken",
"437277", "Waizenkirchen",
"432756", "St\.\ Leonhard\ am\ Forst",
"433587", "Schönberg\-Lachtal",
"437942", "Freistadt",
"4315", "Vienna",
"432945", "Zellerndorf",
"433151", "Gnas",
"433144", "Köflach",
"432943", "Obritz",
"432630", "Ternitz",
"432616", "Lockenhaus",
"433452", "Leibnitz",
"4316", "Vienna",
"433687", "Schladming",
"433364", "Hannersdorf",
"433335", "Pöllau",
"432846", "Raabs\ an\ der\ Thaya",
"434214", "Brückl",
"437767", "Eggerding",
"433883", "Terz",
"434712", "Greifenburg",
"432237", "Gaaden",
"435288", "Fügen",
"433885", "Greith",
"433852", "Mürzzuschlag",
"433333", "Sebersdorf",
"432683", "Purbach\ am\ Neusiedler\ See",
"435513", "Hittisau",
"433135", "Kalsdorf\ bei\ Graz",
"435284", "Gerlos",
"433133", "Nestelbach",
"432259", "Münchendorf",
"435515", "Au",
"432685", "Rust",
"437682", "Vöcklamarkt",
"437289", "Rohrbach\ in\ Oberösterreich",
"433579", "Pöls",
"432621", "Sieggraben",
"434879", "St\.\ Veit\ in\ Defereggen",
"436432", "Bad\ Hofgastein",
"433474", "Deutsch\ Goritz",
"434269", "Flattnitz",
"437617", "Traunkirchen",
"437413", "Marbach\ an\ der\ Donau",
"435225", "Fulpmes",
"435375", "Kössen",
"435223", "Hall\ in\ Tirol",
"437415", "Altenmarkt\,\ Yspertal",
"435373", "Ebbs",
"432624", "Ebenfurth",
"432812", "Gross\ Gerungs",
"437236", "Pregarten",
"432766", "Kleinzell",
"435557", "St\.\ Gallenkirch",
"432642", "Aspangberg\-St\.\ Peter",
"434226", "St\.\ Margareten\ im\ Rosental",
"432249", "Gross\-Enzersdorf",
"432856", "Weitra",
"437563", "Spital\ am\ Pyhrn",
"435275", "Trins",
"437486", "Lunz\ am\ See",
"432674", "Weissenbach\ an\ der\ Triesting",
"433119", "St\.\ Marein\ bei\ Graz",
"433842", "Leoben",
"437565", "St\.\ Pankraz",
"435273", "Matrei\ am\ Brenner",
"436243", "Abtenau",
"434276", "Feldkirchen\ in\ Kärnten",
"433612", "Liezen",
"436245", "Hallein",
"436217", "Mattsee",
"432628", "Felixdorf",
"437758", "Obernberg\ am\ Inn",
"437435", "St\.\ Valentin",
"433581", "Oberwölz",
"437433", "Wallsee",
"434825", "Grosskirchheim",
"434220", "Köttmannsdorf",
"433339", "Friedberg",
"432577", "Asparn\ an\ der\ Zaya",
"437216", "Helfenberg",
"437230", "Altenberg\ bei\ Linz",
"434823", "Tresdorf\,\ Rangersdorf",
"433157", "Kapfenstein",
"432253", "Oberwaltersdorf",
"436137", "Strobl",
"434231", "Mittertrixen",
"433357", "Pinkafeld",
"432784", "Perschling",
"437480", "Langau\,\ Gaming",
"432282", "Gänserndorf",
"432255", "Deutsch\ Brodersdorf",
"437221", "Hörsching",
"432689", "Hornstein",
"435519", "Schröcken",
"435476", "Serfaus",
"437754", "Waldzell",
"432527", "Wulzeshofen",
"433575", "St\.\ Johann\ am\ Tauern",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433632", "St\.\ Gallen",
"434875", "Matrei\ in\ Osttirol",
"437252", "Steyr",
"433573", "Fohnsdorf",
"437283", "Sarleinsbach",
"434873", "St\.\ Jakob\ in\ Defereggen",
"434265", "Weitensfeld\ im\ Gurktal",
"437744", "Munderfing",
"433588", "Katsch\ an\ der\ Mur",
"437278", "Neukirchen\ am\ Walde",
"432143", "Kittsee",
"432723", "Rabenstein\ an\ der\ Pielach",
"437242", "Wels",
"432725", "Frankenfels",
"437751", "St\.\ Martin\ im\ Innkreis",
"432636", "Puchberg\ am\ Schneeberg",
"432610", "Horitschon",
"434263", "Hüttenberg",
"432145", "Prellenkirchen",
"436562", "Mittersill",
"437722", "Braunau\ am\ Inn",
"432243", "Klosterneuburg",
"437224", "St\.\ Florian",
"434732", "Gmünd\ in\ Kärnten",
"435414", "Wenns",
"436456", "Obertauern",
"435266", "Ötztal\-Bahnhof",
"434234", "Ruden",
"432245", "Wolkersdorf\ im\ Weinviertel",
"435672", "Reutte",
"432914", "Japons",
"432773", "Eichgraben",
"435279", "St\.\ Jodok\ am\ Brenner",
"437228", "Kematen\ an\ der\ Krems",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"435418", "Schönwies",
"433115", "Studenzen",
"433147", "Salla",
"434238", "Eisenkappel\-Vellach",
"433386", "Grosssteinbach",
"437748", "Eggelsberg",
"437274", "Alkoven",
"433584", "Neumarkt\ in\ Steiermark",
"436412", "St\.\ Johann\ im\ Pongau",
"437755", "Mettmach",
"437284", "Oberkappel",
"434874", "Virgen",
"433574", "Pusterwald",
"437753", "Eberschwang",
"435289", "Häusling",
"432783", "Traismauer",
"437946", "Gutau",
"433126", "Frohnleiten",
"432752", "Melk",
"432254", "Ebreichsdorf",
"437586", "Pettenbach",
"433326", "Stegersbach",
"437667", "St\.\ Georgen\ im\ Attergau",
"434824", "Heiligenblut",
"432957", "Hohenwarth",
"432862", "Heidenreichstein",
"432258", "Alland",
"4317", "Vienna",
"433176", "Stubenberg",
"434842", "Sillian",
"437288", "Ulrichsberg",
"433578", "Obdach",
"432716", "Gföhl",
"437434", "Haag",
"437260", "Waldhausen",
"432556", "Grosskrut",
"433585", "St\.\ Lambrecht",
"434852", "Lienz",
"434268", "Friesach",
"433466", "Eibiswald",
"432172", "Frauenkirchen",
"432728", "Wienerbruck",
"437273", "Aschach\ an\ der\ Donau",
"433583", "Unzmarkt",
"435336", "Alpbach",
"432915", "Drosendorf\-Zissersdorf",
"432947", "Theras",
"433866", "Breitenau\ am\ Hochlantsch",
"433114", "Markt\ Hartmannsdorf",
"432272", "Tulln\ an\ der\ Donau",
"432248", "Markgrafneusiedl",
"432774", "Innermanzing",
"432913", "Hötzelsdorf",
"434233", "Griffen",
"432666", "Reichenau",
"437956", "Unterweissenbach",
"437225", "Hargelsberg",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"433118", "Sinabelkirchen",
"432742", "St\.\ Pölten",
"437223", "Enns",
"433516", "Kleinlobming",
"435447", "Flirsch",
"432244", "Langenzersdorf",
"434235", "Bleiburg",
"437745", "Lochen",
"434264", "Klein\ St\.\ Paul",
"434762", "Spittal\ an\ der\ Drau",
"436477", "St\.\ Michael\ im\ Lungau",
"435236", "Gries\ im\ Sellrain",
"437717", "St\.\ Aegidi",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432144", "Deutsch\ Jahrndorf",
"437743", "Maria\ Schmolln",
"437281", "Aigen\ im\ Mühlkreis",
"433571", "Möderbrugg",
"4346", "Klagenfurt",
"432629", "Warth\,\ Lower\ Austria",
"432986", "Irnfritz",
"437759", "Antiesenhofen",
"433460", "Soboth",
"434286", "Weissbriach",
"433338", "Lafnitz",
"437476", "Aschbach\-Markt",
"435252", "Oetz",
"435285", "Mayrhofen",
"436462", "Bischofshofen",
"433134", "Heiligenkreuz\ am\ Waasen",
"435283", "Kaltenbach",
"435514", "Bezau",
"432684", "Schützen\ am\ Gebirge",
"434215", "Liebenfels",
"433334", "Kaindorf",
"433536", "St\.\ Peter\ am\ Kammersberg",
"434247", "Afritz",
"432167", "Neusiedl\ am\ See",
"433884", "Wegscheid",
"435518", "Mellau",
"432688", "Steinbrunn",
"434213", "Launsdorf",
"433363", "Rechnitz",
"435352", "St\.\ Johann\ in\ Tirol",
"436241", "St\.\ Koloman",
"435230", "Sellrain",
"432267", "Sierndorf",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437279", "Haibach\ ob\ der\ Donau",
"437672", "Vöcklabruck",
"436244", "Golling\ an\ der\ Salzach",
"432877", "Grainbrunn",
"435274", "Gries\ am\ Brenner",
"435526", "Laterns",
"432673", "Altenmarkt\ an\ der\ Triesting",
"434257", "Fürnitz",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"432532", "Zistersdorf",
"437564", "Hinterstoder",
"435278", "Navis",
"437229", "Traun",
"435242", "Schwaz",
"432827", "Schönbach",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432623", "Pottendorf",
"434357", "St\.\ Paul\ im\ Lavanttal",
"433475", "Hürth",
"435576", "Hohenems",
"435374", "Walchsee",
"435224", "Wattens",
"437266", "Bad\ Kreuzen",
"437414", "Weins\-Isperdorf",
"432736", "Paudorf",
"433473", "Straden",
"436272", "Oberndorf\ bei\ Salzburg",
"432625", "Bad\ Sauerbrunn",
"433170", "Fischbach",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;