# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20200309202344;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '96',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              10|
              2[0-57-9]
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1[1-9]|
            26|
            [3-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            26|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              1|
              58|
              85[23]10
            )[1-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [0-8]|
              9[0-47-9]
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            5[0-35-9]|
            6[25-7]|
            7[0-35-8]|
            9[189]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          400\\d{7}|
          950\\d{7,8}|
          (?:
            10|
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{zh}->{8610} = "北京市";
$areanames{zh}->{861300000} = "山东省济南市";
$areanames{zh}->{861300001} = "江苏省常州市";
$areanames{zh}->{861300002} = "安徽省巢湖市";
$areanames{zh}->{861300006} = "江苏省南京市";
$areanames{zh}->{861300008} = "湖北省武汉市";
$areanames{zh}->{861300010} = "北京市";
$areanames{zh}->{861300011} = "北京市";
$areanames{zh}->{861300012} = "天津市";
$areanames{zh}->{861300013} = "天津市";
$areanames{zh}->{861300014} = "天津市";
$areanames{zh}->{861300015} = "山东省淄博市";
$areanames{zh}->{861300016} = "山东省烟台市";
$areanames{zh}->{861300017} = "山东省济南市";
$areanames{zh}->{861300018} = "天津市";
$areanames{zh}->{861300019} = "天津市";
$areanames{zh}->{861300020} = "上海市";
$areanames{zh}->{861300021} = "上海市";
$areanames{zh}->{861300022} = "上海市";
$areanames{zh}->{861300023} = "上海市";
$areanames{zh}->{861300024} = "上海市";
$areanames{zh}->{861300025} = "江苏省南京市";
$areanames{zh}->{861300026} = "江苏省南京市";
$areanames{zh}->{861300027} = "山东省烟台市";
$areanames{zh}->{861300028} = "江苏省南京市";
$areanames{zh}->{861300029} = "江苏省南京市";
$areanames{zh}->{86130003} = "江苏省无锡市";
$areanames{zh}->{861300030} = "江苏省南京市";
$areanames{zh}->{861300031} = "江苏省南京市";
$areanames{zh}->{861300032} = "江苏省南京市";
$areanames{zh}->{861300040} = "广东省广州市";
$areanames{zh}->{861300041} = "广东省广州市";
$areanames{zh}->{861300042} = "广东省广州市";
$areanames{zh}->{861300043} = "广东省广州市";
$areanames{zh}->{861300044} = "广东省广州市";
$areanames{zh}->{861300045} = "北京市";
$areanames{zh}->{861300046} = "北京市";
$areanames{zh}->{861300047} = "北京市";
$areanames{zh}->{861300048} = "北京市";
$areanames{zh}->{861300049} = "北京市";
$areanames{zh}->{86130005} = "广东省广州市";
$areanames{zh}->{86130006} = "广东省广州市";
$areanames{zh}->{861300061} = "湖北省荆门市";
$areanames{zh}->{861300065} = "山东省潍坊市";
$areanames{zh}->{861300067} = "浙江省温州市";
$areanames{zh}->{861300069} = "广西南宁市";
$areanames{zh}->{86130007} = "广东省广州市";
$areanames{zh}->{861300071} = "湖北省武汉市";
$areanames{zh}->{86130008} = "广东省广州市";
$areanames{zh}->{861300087} = "甘肃省兰州市";
$areanames{zh}->{861300091} = "吉林省长春市";
$areanames{zh}->{861300092} = "辽宁省本溪市";
$areanames{zh}->{861300093} = "辽宁省营口市";
$areanames{zh}->{861300094} = "辽宁省大连市";
$areanames{zh}->{861300095} = "内蒙古包头市";
$areanames{zh}->{861300096} = "新疆乌鲁木齐市";
$areanames{zh}->{861300097} = "黑龙江省佳木斯市";
$areanames{zh}->{861300098} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130010} = "北京市";
$areanames{zh}->{86130011} = "北京市";
$areanames{zh}->{86130012} = "北京市";
$areanames{zh}->{86130013} = "天津市";
$areanames{zh}->{861300140} = "河北省保定市";
$areanames{zh}->{861300141} = "河北省唐山市";
$areanames{zh}->{861300142} = "河北省秦皇岛市";
$areanames{zh}->{861300143} = "河北省廊坊市";
$areanames{zh}->{861300144} = "河北省沧州市";
$areanames{zh}->{861300145} = "河北省邢台市";
$areanames{zh}->{861300146} = "河北省邯郸市";
$areanames{zh}->{861300147} = "河北省衡水市";
$areanames{zh}->{861300148} = "河北省沧州市";
$areanames{zh}->{861300149} = "河北省石家庄市";
$areanames{zh}->{861300150} = "山东省淄博市";
$areanames{zh}->{861300151} = "山东省淄博市";
$areanames{zh}->{861300152} = "山东省滨州市";
$areanames{zh}->{861300153} = "山东省潍坊市";
$areanames{zh}->{861300154} = "山东省潍坊市";
$areanames{zh}->{861300155} = "山东省潍坊市";
$areanames{zh}->{861300156} = "山东省东营市";
$areanames{zh}->{861300157} = "山东省临沂市";
$areanames{zh}->{861300158} = "山东省日照市";
$areanames{zh}->{861300159} = "山东省枣庄市";
$areanames{zh}->{861300160} = "山东省烟台市";
$areanames{zh}->{861300161} = "山东省烟台市";
$areanames{zh}->{861300162} = "山东省烟台市";
$areanames{zh}->{861300163} = "山东省威海市";
$areanames{zh}->{861300164} = "山东省威海市";
$areanames{zh}->{861300165} = "山东省威海市";
$areanames{zh}->{861300166} = "山东省青岛市";
$areanames{zh}->{861300167} = "山东省青岛市";
$areanames{zh}->{861300168} = "山东省青岛市";
$areanames{zh}->{861300169} = "山东省青岛市";
$areanames{zh}->{861300170} = "山东省济南市";
$areanames{zh}->{861300171} = "山东省济南市";
$areanames{zh}->{861300172} = "山东省济南市";
$areanames{zh}->{861300173} = "山东省济南市";
$areanames{zh}->{861300174} = "山东省济南市";
$areanames{zh}->{861300175} = "山东省聊城市";
$areanames{zh}->{861300176} = "山东省德州市";
$areanames{zh}->{861300177} = "山东省泰安市";
$areanames{zh}->{861300178} = "山东省济宁市";
$areanames{zh}->{861300179} = "山东省菏泽市";
$areanames{zh}->{861300180} = "河北省石家庄市";
$areanames{zh}->{861300181} = "河北省唐山市";
$areanames{zh}->{861300182} = "河北省秦皇岛市";
$areanames{zh}->{861300183} = "河北省廊坊市";
$areanames{zh}->{861300184} = "河北省唐山市";
$areanames{zh}->{861300185} = "河北省邢台市";
$areanames{zh}->{861300186} = "河北省邯郸市";
$areanames{zh}->{861300187} = "河北省保定市";
$areanames{zh}->{861300188} = "河北省石家庄市";
$areanames{zh}->{861300189} = "河北省石家庄市";
$areanames{zh}->{86130019} = "北京市";
$areanames{zh}->{86130020} = "广东省广州市";
$areanames{zh}->{86130021} = "上海市";
$areanames{zh}->{86130022} = "天津市";
$areanames{zh}->{86130023} = "重庆市";
$areanames{zh}->{86130024} = "辽宁省沈阳市";
$areanames{zh}->{86130025} = "江苏省南京市";
$areanames{zh}->{861300260} = "浙江省嘉兴市";
$areanames{zh}->{861300261} = "浙江省湖州市";
$areanames{zh}->{861300262} = "浙江省舟山市";
$areanames{zh}->{861300263} = "浙江省绍兴市";
$areanames{zh}->{861300264} = "浙江省衢州市";
$areanames{zh}->{861300265} = "浙江省金华市";
$areanames{zh}->{861300266} = "浙江省台州市";
$areanames{zh}->{861300267} = "浙江省丽水市";
$areanames{zh}->{861300268} = "浙江省温州市";
$areanames{zh}->{861300269} = "浙江省温州市";
$areanames{zh}->{861300270} = "山东省淄博市";
$areanames{zh}->{861300271} = "山东省淄博市";
$areanames{zh}->{861300272} = "山东省烟台市";
$areanames{zh}->{861300273} = "山东省烟台市";
$areanames{zh}->{861300274} = "山东省烟台市";
$areanames{zh}->{861300275} = "山东省烟台市";
$areanames{zh}->{861300276} = "山东省莱芜市";
$areanames{zh}->{861300277} = "山东省泰安市";
$areanames{zh}->{861300278} = "山东省潍坊市";
$areanames{zh}->{861300279} = "山东省临沂市";
$areanames{zh}->{861300280} = "四川省凉山彝族自治州";
$areanames{zh}->{861300281} = "四川省攀枝花市";
$areanames{zh}->{861300282} = "四川省南充市";
$areanames{zh}->{861300283} = "四川省遂宁市";
$areanames{zh}->{861300284} = "四川省遂宁市";
$areanames{zh}->{861300285} = "四川省达州市";
$areanames{zh}->{861300286} = "四川省泸州市";
$areanames{zh}->{861300287} = "四川省内江市";
$areanames{zh}->{861300288} = "四川省宜宾市";
$areanames{zh}->{861300289} = "四川省自贡市";
$areanames{zh}->{86130029} = "陕西省西安市";
$areanames{zh}->{861300300} = "安徽省合肥市";
$areanames{zh}->{861300301} = "安徽省蚌埠市";
$areanames{zh}->{861300302} = "安徽省蚌埠市";
$areanames{zh}->{861300303} = "安徽省芜湖市";
$areanames{zh}->{861300304} = "安徽省芜湖市";
$areanames{zh}->{861300305} = "安徽省合肥市";
$areanames{zh}->{861300306} = "安徽省合肥市";
$areanames{zh}->{861300307} = "安徽省淮南市";
$areanames{zh}->{861300308} = "安徽省合肥市";
$areanames{zh}->{861300309} = "安徽省合肥市";
$areanames{zh}->{86130031} = "上海市";
$areanames{zh}->{86130032} = "上海市";
$areanames{zh}->{86130033} = "江苏省无锡市";
$areanames{zh}->{861300340} = "江苏省南京市";
$areanames{zh}->{861300341} = "江苏省南京市";
$areanames{zh}->{861300342} = "江苏省南京市";
$areanames{zh}->{861300343} = "江苏省镇江市";
$areanames{zh}->{861300344} = "江苏省镇江市";
$areanames{zh}->{861300345} = "江苏省镇江市";
$areanames{zh}->{861300346} = "江苏省连云港市";
$areanames{zh}->{861300347} = "江苏省连云港市";
$areanames{zh}->{861300348} = "江苏省盐城市";
$areanames{zh}->{861300349} = "江苏省宿迁市";
$areanames{zh}->{86130035} = "江苏省南通市";
$areanames{zh}->{861300350} = "江苏省徐州市";
$areanames{zh}->{861300351} = "江苏省徐州市";
$areanames{zh}->{861300352} = "江苏省徐州市";
$areanames{zh}->{861300354} = "江苏省淮安市";
$areanames{zh}->{86130036} = "浙江省杭州市";
$areanames{zh}->{86130037} = "浙江省宁波市";
$areanames{zh}->{86130038} = "福建省福州市";
$areanames{zh}->{861300385} = "福建省莆田市";
$areanames{zh}->{861300386} = "福建省莆田市";
$areanames{zh}->{86130039} = "福建省厦门市";
$areanames{zh}->{861300395} = "福建省漳州市";
$areanames{zh}->{861300396} = "福建省漳州市";
$areanames{zh}->{861300400} = "安徽省淮南市";
$areanames{zh}->{861300401} = "安徽省阜阳市";
$areanames{zh}->{861300402} = "安徽省阜阳市";
$areanames{zh}->{861300403} = "安徽省阜阳市";
$areanames{zh}->{861300404} = "安徽省芜湖市";
$areanames{zh}->{861300405} = "安徽省芜湖市";
$areanames{zh}->{861300406} = "安徽省芜湖市";
$areanames{zh}->{861300407} = "安徽省蚌埠市";
$areanames{zh}->{861300408} = "安徽省蚌埠市";
$areanames{zh}->{861300409} = "安徽省蚌埠市";
$areanames{zh}->{86130041} = "上海市";
$areanames{zh}->{861300420} = "浙江省嘉兴市";
$areanames{zh}->{861300421} = "浙江省嘉兴市";
$areanames{zh}->{861300422} = "浙江省嘉兴市";
$areanames{zh}->{861300423} = "浙江省嘉兴市";
$areanames{zh}->{861300424} = "浙江省嘉兴市";
$areanames{zh}->{861300425} = "浙江省湖州市";
$areanames{zh}->{861300426} = "浙江省湖州市";
$areanames{zh}->{861300427} = "浙江省湖州市";
$areanames{zh}->{861300428} = "浙江省杭州市";
$areanames{zh}->{861300429} = "浙江省舟山市";
$areanames{zh}->{86130043} = "江苏省扬州市";
$areanames{zh}->{861300435} = "江苏省镇江市";
$areanames{zh}->{861300436} = "江苏省镇江市";
$areanames{zh}->{861300437} = "江苏省常州市";
$areanames{zh}->{861300438} = "江苏省常州市";
$areanames{zh}->{861300440} = "江苏省常州市";
$areanames{zh}->{861300441} = "江苏省常州市";
$areanames{zh}->{861300442} = "江苏省常州市";
$areanames{zh}->{861300443} = "江苏省常州市";
$areanames{zh}->{861300444} = "江苏省泰州市";
$areanames{zh}->{861300445} = "江苏省泰州市";
$areanames{zh}->{861300446} = "江苏省泰州市";
$areanames{zh}->{861300447} = "江苏省盐城市";
$areanames{zh}->{861300448} = "江苏省盐城市";
$areanames{zh}->{861300449} = "江苏省盐城市";
$areanames{zh}->{86130045} = "江苏省苏州市";
$areanames{zh}->{861300460} = "浙江省绍兴市";
$areanames{zh}->{861300461} = "浙江省绍兴市";
$areanames{zh}->{861300462} = "浙江省绍兴市";
$areanames{zh}->{861300463} = "浙江省绍兴市";
$areanames{zh}->{861300464} = "浙江省金华市";
$areanames{zh}->{861300465} = "浙江省金华市";
$areanames{zh}->{861300466} = "浙江省金华市";
$areanames{zh}->{861300467} = "浙江省金华市";
$areanames{zh}->{861300468} = "浙江省衢州市";
$areanames{zh}->{861300469} = "浙江省丽水市";
$areanames{zh}->{86130047} = "浙江省温州市";
$areanames{zh}->{861300476} = "浙江省台州市";
$areanames{zh}->{861300477} = "浙江省台州市";
$areanames{zh}->{861300478} = "浙江省台州市";
$areanames{zh}->{861300479} = "浙江省台州市";
$areanames{zh}->{86130048} = "福建省泉州市";
$areanames{zh}->{861300490} = "福建省三明市";
$areanames{zh}->{861300491} = "福建省宁德市";
$areanames{zh}->{861300492} = "福建省宁德市";
$areanames{zh}->{861300493} = "福建省宁德市";
$areanames{zh}->{861300494} = "福建省南平市";
$areanames{zh}->{861300495} = "福建省南平市";
$areanames{zh}->{861300496} = "福建省南平市";
$areanames{zh}->{861300497} = "福建省龙岩市";
$areanames{zh}->{861300498} = "福建省龙岩市";
$areanames{zh}->{861300499} = "福建省三明市";
$areanames{zh}->{86130050} = "海南省海口市";
$areanames{zh}->{86130051} = "广东省广州市";
$areanames{zh}->{861300520} = "广东省汕头市";
$areanames{zh}->{861300521} = "广东省汕头市";
$areanames{zh}->{861300522} = "广东省汕头市";
$areanames{zh}->{861300523} = "广东省汕头市";
$areanames{zh}->{861300524} = "广东省汕头市";
$areanames{zh}->{861300525} = "广东省汕尾市";
$areanames{zh}->{861300526} = "广东省揭阳市";
$areanames{zh}->{861300527} = "广东省揭阳市";
$areanames{zh}->{861300528} = "广东省梅州市";
$areanames{zh}->{861300529} = "广东省梅州市";
$areanames{zh}->{861300530} = "广东省河源市";
$areanames{zh}->{861300531} = "广东省潮州市";
$areanames{zh}->{861300532} = "广东省汕头市";
$areanames{zh}->{861300533} = "广东省汕头市";
$areanames{zh}->{861300534} = "广东省汕头市";
$areanames{zh}->{861300535} = "广东省清远市";
$areanames{zh}->{861300536} = "广东省韶关市";
$areanames{zh}->{861300537} = "广东省韶关市";
$areanames{zh}->{861300538} = "广东省云浮市";
$areanames{zh}->{861300539} = "广东省云浮市";
$areanames{zh}->{86130054} = "广东省深圳市";
$areanames{zh}->{86130055} = "广东省中山市";
$areanames{zh}->{861300556} = "广东省肇庆市";
$areanames{zh}->{861300557} = "广东省肇庆市";
$areanames{zh}->{861300558} = "广东省肇庆市";
$areanames{zh}->{861300559} = "广东省肇庆市";
$areanames{zh}->{861300560} = "广东省湛江市";
$areanames{zh}->{861300561} = "广东省湛江市";
$areanames{zh}->{861300562} = "广东省湛江市";
$areanames{zh}->{861300563} = "广东省湛江市";
$areanames{zh}->{861300564} = "广东省阳江市";
$areanames{zh}->{861300565} = "广东省阳江市";
$areanames{zh}->{861300566} = "广东省茂名市";
$areanames{zh}->{861300567} = "广东省茂名市";
$areanames{zh}->{861300568} = "广东省茂名市";
$areanames{zh}->{861300569} = "广东省珠海市";
$areanames{zh}->{86130057} = "广东省惠州市";
$areanames{zh}->{861300576} = "广东省珠海市";
$areanames{zh}->{861300577} = "广东省珠海市";
$areanames{zh}->{861300578} = "广东省珠海市";
$areanames{zh}->{861300579} = "广东省珠海市";
$areanames{zh}->{86130058} = "广东省江门市";
$areanames{zh}->{861300590} = "广西南宁市";
$areanames{zh}->{861300591} = "广西南宁市";
$areanames{zh}->{861300592} = "广西南宁市";
$areanames{zh}->{861300593} = "广西柳州市";
$areanames{zh}->{861300594} = "广西桂林市";
$areanames{zh}->{861300595} = "广西桂林市";
$areanames{zh}->{861300596} = "广西玉林市";
$areanames{zh}->{861300597} = "广西梧州市";
$areanames{zh}->{861300598} = "广西梧州市";
$areanames{zh}->{861300599} = "广西北海市";
$areanames{zh}->{86130060} = "海南省海口市";
$areanames{zh}->{86130061} = "湖北省武汉市";
$areanames{zh}->{861300620} = "江西省南昌市";
$areanames{zh}->{861300621} = "江西省南昌市";
$areanames{zh}->{861300622} = "江西省鹰潭市";
$areanames{zh}->{861300623} = "江西省鹰潭市";
$areanames{zh}->{861300624} = "江西省鹰潭市";
$areanames{zh}->{861300625} = "江西省上饶市";
$areanames{zh}->{861300626} = "江西省宜春市";
$areanames{zh}->{861300627} = "江西省宜春市";
$areanames{zh}->{861300628} = "江西省新余市";
$areanames{zh}->{861300629} = "江西省萍乡市";
$areanames{zh}->{86130063} = "湖北省武汉市";
$areanames{zh}->{861300640} = "四川省乐山市";
$areanames{zh}->{861300641} = "四川省眉山市";
$areanames{zh}->{861300642} = "四川省乐山市";
$areanames{zh}->{861300643} = "四川省德阳市";
$areanames{zh}->{861300644} = "四川省德阳市";
$areanames{zh}->{861300645} = "四川省德阳市";
$areanames{zh}->{861300646} = "四川省广元市";
$areanames{zh}->{861300647} = "四川省广元市";
$areanames{zh}->{861300648} = "四川省绵阳市";
$areanames{zh}->{861300649} = "四川省绵阳市";
$areanames{zh}->{861300650} = "山东省青岛市";
$areanames{zh}->{861300651} = "山东省青岛市";
$areanames{zh}->{861300652} = "山东省青岛市";
$areanames{zh}->{861300653} = "山东省青岛市";
$areanames{zh}->{861300654} = "山东省东营市";
$areanames{zh}->{861300655} = "山东省潍坊市";
$areanames{zh}->{861300656} = "山东省潍坊市";
$areanames{zh}->{861300657} = "山东省济南市";
$areanames{zh}->{861300658} = "山东省济南市";
$areanames{zh}->{861300659} = "山东省济南市";
$areanames{zh}->{86130066} = "广东省深圳市";
$areanames{zh}->{86130067} = "广东省佛山市";
$areanames{zh}->{86130068} = "广东省东莞市";
$areanames{zh}->{861300686} = "广东省广州市";
$areanames{zh}->{861300687} = "广东省广州市";
$areanames{zh}->{861300688} = "广东省广州市";
$areanames{zh}->{861300689} = "广东省广州市";
$areanames{zh}->{861300690} = "广西防城港市";
$areanames{zh}->{861300691} = "广西南宁市";
$areanames{zh}->{861300692} = "广西柳州市";
$areanames{zh}->{861300693} = "广西桂林市";
$areanames{zh}->{861300694} = "广西梧州市";
$areanames{zh}->{861300695} = "广西玉林市";
$areanames{zh}->{861300696} = "广西百色市";
$areanames{zh}->{861300697} = "广西钦州市";
$areanames{zh}->{861300698} = "广西河池市";
$areanames{zh}->{861300699} = "广西北海市";
$areanames{zh}->{86130070} = "山西省太原市";
$areanames{zh}->{861300705} = "山西省晋中市";
$areanames{zh}->{861300706} = "山西省晋中市";
$areanames{zh}->{86130071} = "湖北省武汉市";
$areanames{zh}->{86130072} = "江西省南昌市";
$areanames{zh}->{861300725} = "江西省九江市";
$areanames{zh}->{861300726} = "江西省九江市";
$areanames{zh}->{861300727} = "江西省九江市";
$areanames{zh}->{861300729} = "江西省九江市";
$areanames{zh}->{861300730} = "湖南省岳阳市";
$areanames{zh}->{861300731} = "湖南省长沙市";
$areanames{zh}->{861300732} = "湖南省湘潭市";
$areanames{zh}->{861300733} = "湖南省株洲市";
$areanames{zh}->{861300734} = "湖南省衡阳市";
$areanames{zh}->{861300735} = "湖南省郴州市";
$areanames{zh}->{861300736} = "湖南省常德市";
$areanames{zh}->{861300737} = "湖南省益阳市";
$areanames{zh}->{861300738} = "湖南省娄底市";
$areanames{zh}->{861300739} = "湖南省邵阳市";
$areanames{zh}->{861300740} = "湖南省常德市";
$areanames{zh}->{861300741} = "湖南省长沙市";
$areanames{zh}->{861300742} = "湖南省长沙市";
$areanames{zh}->{861300743} = "湖南省长沙市";
$areanames{zh}->{861300744} = "湖南省湘潭市";
$areanames{zh}->{861300745} = "湖南省株洲市";
$areanames{zh}->{861300746} = "湖南省衡阳市";
$areanames{zh}->{861300747} = "湖南省岳阳市";
$areanames{zh}->{861300748} = "湖南省长沙市";
$areanames{zh}->{861300749} = "湖南省长沙市";
$areanames{zh}->{861300750} = "河南省郑州市";
$areanames{zh}->{861300751} = "河南省郑州市";
$areanames{zh}->{861300752} = "河南省郑州市";
$areanames{zh}->{861300753} = "河南省郑州市";
$areanames{zh}->{861300754} = "河南省郑州市";
$areanames{zh}->{861300755} = "河南省洛阳市";
$areanames{zh}->{861300756} = "河南省洛阳市";
$areanames{zh}->{861300757} = "河南省洛阳市";
$areanames{zh}->{861300758} = "河南省洛阳市";
$areanames{zh}->{861300759} = "河南省安阳市";
$areanames{zh}->{861300760} = "河南省郑州市";
$areanames{zh}->{861300761} = "河南省郑州市";
$areanames{zh}->{861300762} = "河南省郑州市";
$areanames{zh}->{861300763} = "河南省洛阳市";
$areanames{zh}->{861300764} = "河南省开封市";
$areanames{zh}->{861300765} = "河南省焦作市";
$areanames{zh}->{861300766} = "河南省新乡市";
$areanames{zh}->{861300767} = "河南省许昌市";
$areanames{zh}->{861300768} = "河南省漯河市";
$areanames{zh}->{861300769} = "河南省安阳市";
$areanames{zh}->{861300770} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861300771} = "青海省西宁市";
$areanames{zh}->{861300772} = "青海省海东地区";
$areanames{zh}->{861300773} = "青海省海东地区";
$areanames{zh}->{861300774} = "青海省海南藏族自治州";
$areanames{zh}->{861300775} = "青海省海北藏族自治州";
$areanames{zh}->{861300776} = "青海省西宁市";
$areanames{zh}->{861300777} = "青海省西宁市";
$areanames{zh}->{861300778} = "青海省西宁市";
$areanames{zh}->{861300779} = "青海省西宁市";
$areanames{zh}->{86130078} = "贵州省贵阳市";
$areanames{zh}->{861300787} = "贵州省遵义市";
$areanames{zh}->{861300789} = "贵州省安顺市";
$areanames{zh}->{861300790} = "宁夏石嘴山市";
$areanames{zh}->{861300791} = "宁夏石嘴山市";
$areanames{zh}->{861300792} = "宁夏吴忠市";
$areanames{zh}->{861300793} = "宁夏吴忠市";
$areanames{zh}->{861300794} = "宁夏固原市";
$areanames{zh}->{861300795} = "宁夏固原市";
$areanames{zh}->{861300796} = "宁夏银川市";
$areanames{zh}->{861300797} = "宁夏银川市";
$areanames{zh}->{861300798} = "宁夏银川市";
$areanames{zh}->{861300799} = "宁夏银川市";
$areanames{zh}->{861300800} = "山西省运城市";
$areanames{zh}->{861300801} = "山西省运城市";
$areanames{zh}->{861300802} = "山西省临汾市";
$areanames{zh}->{861300803} = "山西省临汾市";
$areanames{zh}->{861300804} = "山西省大同市";
$areanames{zh}->{861300805} = "山西省晋城市";
$areanames{zh}->{861300806} = "山西省长治市";
$areanames{zh}->{861300807} = "山西省长治市";
$areanames{zh}->{861300808} = "山西省大同市";
$areanames{zh}->{861300809} = "山西省大同市";
$areanames{zh}->{86130081} = "四川省成都市";
$areanames{zh}->{861300820} = "辽宁省辽阳市";
$areanames{zh}->{861300821} = "辽宁省阜新市";
$areanames{zh}->{861300822} = "辽宁省盘锦市";
$areanames{zh}->{861300823} = "辽宁省盘锦市";
$areanames{zh}->{861300824} = "辽宁省朝阳市";
$areanames{zh}->{861300825} = "辽宁省盘锦市";
$areanames{zh}->{861300826} = "辽宁省锦州市";
$areanames{zh}->{861300827} = "辽宁省铁岭市";
$areanames{zh}->{861300828} = "辽宁省辽阳市";
$areanames{zh}->{861300829} = "辽宁省阜新市";
$areanames{zh}->{86130083} = "重庆市";
$areanames{zh}->{861300840} = "陕西省西安市";
$areanames{zh}->{861300841} = "陕西省西安市";
$areanames{zh}->{861300842} = "陕西省西安市";
$areanames{zh}->{861300843} = "陕西省渭南市";
$areanames{zh}->{861300844} = "陕西省咸阳市";
$areanames{zh}->{861300845} = "陕西省汉中市";
$areanames{zh}->{861300846} = "陕西省汉中市";
$areanames{zh}->{861300847} = "陕西省宝鸡市";
$areanames{zh}->{861300848} = "陕西省宝鸡市";
$areanames{zh}->{861300849} = "陕西省宝鸡市";
$areanames{zh}->{861300850} = "陕西省铜川市";
$areanames{zh}->{861300851} = "陕西省铜川市";
$areanames{zh}->{861300852} = "陕西省渭南市";
$areanames{zh}->{861300853} = "陕西省渭南市";
$areanames{zh}->{861300854} = "陕西省咸阳市";
$areanames{zh}->{861300855} = "陕西省咸阳市";
$areanames{zh}->{861300856} = "陕西省咸阳市";
$areanames{zh}->{861300857} = "陕西省延安市";
$areanames{zh}->{861300858} = "陕西省延安市";
$areanames{zh}->{861300859} = "陕西省延安市";
$areanames{zh}->{861300860} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861300861} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861300862} = "云南省楚雄彝族自治州";
$areanames{zh}->{861300863} = "云南省曲靖市";
$areanames{zh}->{861300864} = "云南省玉溪市";
$areanames{zh}->{861300865} = "云南省昆明市";
$areanames{zh}->{861300866} = "云南省昆明市";
$areanames{zh}->{861300867} = "云南省昆明市";
$areanames{zh}->{861300868} = "云南省昆明市";
$areanames{zh}->{861300869} = "云南省昆明市";
$areanames{zh}->{86130087} = "甘肃省兰州市";
$areanames{zh}->{86130088} = "广东省深圳市";
$areanames{zh}->{86130089} = "浙江省宁波市";
$areanames{zh}->{861300900} = "吉林省长春市";
$areanames{zh}->{861300901} = "吉林省长春市";
$areanames{zh}->{861300902} = "吉林省四平市";
$areanames{zh}->{861300903} = "吉林省四平市";
$areanames{zh}->{861300904} = "吉林省辽源市";
$areanames{zh}->{861300905} = "吉林省松原市";
$areanames{zh}->{861300906} = "吉林省白城市";
$areanames{zh}->{861300907} = "吉林省白山市";
$areanames{zh}->{861300908} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861300909} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861300910} = "吉林省长春市";
$areanames{zh}->{861300911} = "吉林省长春市";
$areanames{zh}->{861300912} = "吉林省长春市";
$areanames{zh}->{861300913} = "吉林省长春市";
$areanames{zh}->{861300914} = "吉林省长春市";
$areanames{zh}->{861300915} = "吉林省吉林市";
$areanames{zh}->{861300916} = "吉林省吉林市";
$areanames{zh}->{861300917} = "吉林省吉林市";
$areanames{zh}->{861300918} = "吉林省吉林市";
$areanames{zh}->{861300919} = "吉林省通化市";
$areanames{zh}->{861300920} = "辽宁省丹东市";
$areanames{zh}->{861300921} = "辽宁省丹东市";
$areanames{zh}->{861300922} = "辽宁省本溪市";
$areanames{zh}->{861300923} = "辽宁省本溪市";
$areanames{zh}->{861300924} = "辽宁省抚顺市";
$areanames{zh}->{861300925} = "辽宁省抚顺市";
$areanames{zh}->{861300926} = "辽宁省抚顺市";
$areanames{zh}->{861300927} = "辽宁省铁岭市";
$areanames{zh}->{861300928} = "辽宁省葫芦岛市";
$areanames{zh}->{861300929} = "辽宁省葫芦岛市";
$areanames{zh}->{861300930} = "辽宁省营口市";
$areanames{zh}->{861300931} = "辽宁省营口市";
$areanames{zh}->{861300932} = "辽宁省营口市";
$areanames{zh}->{861300933} = "辽宁省锦州市";
$areanames{zh}->{861300934} = "辽宁省锦州市";
$areanames{zh}->{861300935} = "辽宁省锦州市";
$areanames{zh}->{861300936} = "辽宁省鞍山市";
$areanames{zh}->{861300937} = "辽宁省鞍山市";
$areanames{zh}->{861300938} = "辽宁省鞍山市";
$areanames{zh}->{861300939} = "辽宁省鞍山市";
$areanames{zh}->{86130094} = "辽宁省大连市";
$areanames{zh}->{861300950} = "内蒙古呼和浩特市";
$areanames{zh}->{861300951} = "内蒙古呼和浩特市";
$areanames{zh}->{861300952} = "内蒙古呼和浩特市";
$areanames{zh}->{861300953} = "内蒙古乌兰察布市";
$areanames{zh}->{861300954} = "内蒙古包头市";
$areanames{zh}->{861300955} = "内蒙古包头市";
$areanames{zh}->{861300956} = "内蒙古包头市";
$areanames{zh}->{861300957} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861300958} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861300959} = "内蒙古乌海市";
$areanames{zh}->{86130096} = "新疆乌鲁木齐市";
$areanames{zh}->{861300960} = "新疆昌吉回族自治州";
$areanames{zh}->{861300970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861300974} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861300975} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861300976} = "黑龙江省佳木斯市";
$areanames{zh}->{861300977} = "黑龙江省佳木斯市";
$areanames{zh}->{861300978} = "黑龙江省佳木斯市";
$areanames{zh}->{861300979} = "黑龙江省牡丹江市";
$areanames{zh}->{861300980} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300981} = "黑龙江省大庆市";
$areanames{zh}->{861300982} = "黑龙江省大庆市";
$areanames{zh}->{861300983} = "黑龙江省大庆市";
$areanames{zh}->{861300984} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300985} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300986} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300987} = "黑龙江省哈尔滨市";
$areanames{zh}->{861300988} = "黑龙江省牡丹江市";
$areanames{zh}->{861300989} = "黑龙江省牡丹江市";
$areanames{zh}->{861300990} = "黑龙江省大庆市";
$areanames{zh}->{861300991} = "黑龙江省绥化市";
$areanames{zh}->{861300992} = "黑龙江省绥化市";
$areanames{zh}->{861300993} = "黑龙江省黑河市";
$areanames{zh}->{861300994} = "黑龙江省黑河市";
$areanames{zh}->{861300995} = "黑龙江省鸡西市";
$areanames{zh}->{861300996} = "黑龙江省七台河市";
$areanames{zh}->{861300997} = "黑龙江省鹤岗市";
$areanames{zh}->{861300998} = "黑龙江省双鸭山市";
$areanames{zh}->{861300999} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301000} = "上海市";
$areanames{zh}->{861301006} = "北京市";
$areanames{zh}->{861301007} = "北京市";
$areanames{zh}->{861301008} = "北京市";
$areanames{zh}->{861301009} = "北京市";
$areanames{zh}->{861301010} = "北京市";
$areanames{zh}->{861301011} = "北京市";
$areanames{zh}->{861301012} = "北京市";
$areanames{zh}->{861301013} = "天津市";
$areanames{zh}->{861301014} = "河北省衡水市";
$areanames{zh}->{861301015} = "山东省淄博市";
$areanames{zh}->{861301016} = "山东省烟台市";
$areanames{zh}->{861301017} = "山东省济南市";
$areanames{zh}->{861301018} = "河北省石家庄市";
$areanames{zh}->{861301019} = "北京市";
$areanames{zh}->{861301020} = "广东省广州市";
$areanames{zh}->{861301024} = "辽宁省沈阳市";
$areanames{zh}->{861301027} = "山东省莱芜市";
$areanames{zh}->{861301030} = "安徽省合肥市";
$areanames{zh}->{861301031} = "上海市";
$areanames{zh}->{861301033} = "江苏省无锡市";
$areanames{zh}->{861301034} = "江苏省南京市";
$areanames{zh}->{861301035} = "江苏省徐州市";
$areanames{zh}->{861301036} = "浙江省杭州市";
$areanames{zh}->{861301037} = "浙江省宁波市";
$areanames{zh}->{861301038} = "福建省福州市";
$areanames{zh}->{861301039} = "福建省厦门市";
$areanames{zh}->{861301042} = "浙江省嘉兴市";
$areanames{zh}->{861301043} = "江苏省扬州市";
$areanames{zh}->{861301044} = "江苏省常州市";
$areanames{zh}->{861301045} = "江苏省苏州市";
$areanames{zh}->{861301046} = "浙江省绍兴市";
$areanames{zh}->{861301047} = "浙江省温州市";
$areanames{zh}->{861301048} = "福建省泉州市";
$areanames{zh}->{861301049} = "福建省宁德市";
$areanames{zh}->{861301050} = "海南省海口市";
$areanames{zh}->{861301051} = "广东省广州市";
$areanames{zh}->{861301052} = "广东省汕头市";
$areanames{zh}->{861301053} = "广东省韶关市";
$areanames{zh}->{861301054} = "广东省深圳市";
$areanames{zh}->{861301055} = "广东省中山市";
$areanames{zh}->{861301056} = "广东省湛江市";
$areanames{zh}->{861301057} = "广东省惠州市";
$areanames{zh}->{861301058} = "广东省江门市";
$areanames{zh}->{861301059} = "广西南宁市";
$areanames{zh}->{861301062} = "江西省鹰潭市";
$areanames{zh}->{861301064} = "四川省乐山市";
$areanames{zh}->{861301066} = "广东省广州市";
$areanames{zh}->{861301067} = "广东省佛山市";
$areanames{zh}->{861301068} = "广东省东莞市";
$areanames{zh}->{861301070} = "山西省太原市";
$areanames{zh}->{861301071} = "湖北省武汉市";
$areanames{zh}->{861301072} = "江西省南昌市";
$areanames{zh}->{861301073} = "湖南省岳阳市";
$areanames{zh}->{861301074} = "湖南省长沙市";
$areanames{zh}->{861301075} = "广东省深圳市";
$areanames{zh}->{861301076} = "河南省郑州市";
$areanames{zh}->{861301077} = "湖北省武汉市";
$areanames{zh}->{861301078} = "贵州省贵阳市";
$areanames{zh}->{861301079} = "宁夏银川市";
$areanames{zh}->{861301081} = "四川省成都市";
$areanames{zh}->{861301082} = "辽宁省辽阳市";
$areanames{zh}->{861301083} = "重庆市";
$areanames{zh}->{861301084} = "陕西省西安市";
$areanames{zh}->{861301085} = "陕西省西安市";
$areanames{zh}->{861301086} = "云南省昆明市";
$areanames{zh}->{861301087} = "甘肃省兰州市";
$areanames{zh}->{861301088} = "广东省深圳市";
$areanames{zh}->{861301089} = "广东省深圳市";
$areanames{zh}->{861301091} = "吉林省长春市";
$areanames{zh}->{861301092} = "辽宁省丹东市";
$areanames{zh}->{861301093} = "辽宁省营口市";
$areanames{zh}->{861301094} = "辽宁省大连市";
$areanames{zh}->{861301095} = "内蒙古呼和浩特市";
$areanames{zh}->{861301096} = "新疆乌鲁木齐市";
$areanames{zh}->{861301097} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861301098} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130110} = "北京市";
$areanames{zh}->{86130111} = "北京市";
$areanames{zh}->{86130112} = "北京市";
$areanames{zh}->{86130113} = "天津市";
$areanames{zh}->{861301140} = "河北省保定市";
$areanames{zh}->{861301141} = "河北省保定市";
$areanames{zh}->{861301142} = "河北省沧州市";
$areanames{zh}->{861301143} = "河北省唐山市";
$areanames{zh}->{861301144} = "河北省唐山市";
$areanames{zh}->{861301145} = "河北省邢台市";
$areanames{zh}->{861301146} = "河北省秦皇岛市";
$areanames{zh}->{861301147} = "河北省秦皇岛市";
$areanames{zh}->{861301148} = "河北省廊坊市";
$areanames{zh}->{861301149} = "河北省邯郸市";
$areanames{zh}->{861301150} = "河北省唐山市";
$areanames{zh}->{861301151} = "河北省唐山市";
$areanames{zh}->{861301152} = "河北省唐山市";
$areanames{zh}->{861301153} = "河北省邯郸市";
$areanames{zh}->{861301154} = "河北省邯郸市";
$areanames{zh}->{861301155} = "河北省石家庄市";
$areanames{zh}->{861301156} = "河北省石家庄市";
$areanames{zh}->{861301157} = "河北省石家庄市";
$areanames{zh}->{861301158} = "河北省石家庄市";
$areanames{zh}->{861301159} = "河北省石家庄市";
$areanames{zh}->{861301160} = "山东省淄博市";
$areanames{zh}->{861301161} = "山东省淄博市";
$areanames{zh}->{861301162} = "山东省淄博市";
$areanames{zh}->{861301163} = "山东省淄博市";
$areanames{zh}->{861301164} = "山东省淄博市";
$areanames{zh}->{861301165} = "山东省潍坊市";
$areanames{zh}->{861301166} = "山东省潍坊市";
$areanames{zh}->{861301167} = "山东省潍坊市";
$areanames{zh}->{861301168} = "山东省潍坊市";
$areanames{zh}->{861301169} = "山东省潍坊市";
$areanames{zh}->{861301170} = "山东省济南市";
$areanames{zh}->{861301171} = "山东省济南市";
$areanames{zh}->{861301172} = "山东省济南市";
$areanames{zh}->{861301173} = "山东省济南市";
$areanames{zh}->{861301174} = "山东省济南市";
$areanames{zh}->{861301175} = "山东省德州市";
$areanames{zh}->{861301176} = "山东省德州市";
$areanames{zh}->{861301177} = "山东省泰安市";
$areanames{zh}->{861301178} = "山东省泰安市";
$areanames{zh}->{861301179} = "山东省滨州市";
$areanames{zh}->{86130118} = "北京市";
$areanames{zh}->{861301190} = "河北省保定市";
$areanames{zh}->{861301191} = "河北省保定市";
$areanames{zh}->{861301192} = "河北省保定市";
$areanames{zh}->{861301193} = "河北省廊坊市";
$areanames{zh}->{861301194} = "河北省廊坊市";
$areanames{zh}->{861301195} = "河北省邢台市";
$areanames{zh}->{861301196} = "河北省秦皇岛市";
$areanames{zh}->{861301197} = "河北省秦皇岛市";
$areanames{zh}->{861301198} = "河北省沧州市";
$areanames{zh}->{861301199} = "河北省沧州市";
$areanames{zh}->{861301200} = "河北省廊坊市";
$areanames{zh}->{861301201} = "河北省唐山市";
$areanames{zh}->{861301202} = "河北省沧州市";
$areanames{zh}->{861301203} = "河北省沧州市";
$areanames{zh}->{861301204} = "河北省沧州市";
$areanames{zh}->{861301205} = "河北省保定市";
$areanames{zh}->{861301206} = "河北省保定市";
$areanames{zh}->{861301207} = "河北省保定市";
$areanames{zh}->{861301208} = "河北省廊坊市";
$areanames{zh}->{861301209} = "河北省衡水市";
$areanames{zh}->{861301210} = "河北省邯郸市";
$areanames{zh}->{861301211} = "河北省邯郸市";
$areanames{zh}->{861301212} = "河北省邢台市";
$areanames{zh}->{861301213} = "河北省邢台市";
$areanames{zh}->{861301214} = "河北省石家庄市";
$areanames{zh}->{861301215} = "河北省石家庄市";
$areanames{zh}->{861301216} = "河北省石家庄市";
$areanames{zh}->{861301217} = "河北省唐山市";
$areanames{zh}->{861301218} = "河北省秦皇岛市";
$areanames{zh}->{861301219} = "河北省唐山市";
$areanames{zh}->{86130122} = "天津市";
$areanames{zh}->{86130123} = "重庆市";
$areanames{zh}->{86130124} = "山东省青岛市";
$areanames{zh}->{86130125} = "山东省青岛市";
$areanames{zh}->{861301256} = "山东省烟台市";
$areanames{zh}->{861301257} = "山东省烟台市";
$areanames{zh}->{861301258} = "山东省烟台市";
$areanames{zh}->{861301259} = "山东省烟台市";
$areanames{zh}->{86130126} = "山东省济宁市";
$areanames{zh}->{861301266} = "山东省枣庄市";
$areanames{zh}->{861301267} = "山东省枣庄市";
$areanames{zh}->{861301268} = "山东省聊城市";
$areanames{zh}->{861301269} = "山东省菏泽市";
$areanames{zh}->{861301270} = "山东省淄博市";
$areanames{zh}->{861301271} = "山东省淄博市";
$areanames{zh}->{861301272} = "山东省滨州市";
$areanames{zh}->{861301273} = "山东省威海市";
$areanames{zh}->{861301274} = "山东省泰安市";
$areanames{zh}->{861301275} = "山东省莱芜市";
$areanames{zh}->{861301276} = "山东省德州市";
$areanames{zh}->{861301277} = "山东省日照市";
$areanames{zh}->{861301278} = "山东省聊城市";
$areanames{zh}->{861301279} = "山东省临沂市";
$areanames{zh}->{86130128} = "上海市";
$areanames{zh}->{861301290} = "山东省东营市";
$areanames{zh}->{861301291} = "山东省东营市";
$areanames{zh}->{861301292} = "山东省济宁市";
$areanames{zh}->{861301293} = "山东省济宁市";
$areanames{zh}->{861301294} = "山东省青岛市";
$areanames{zh}->{861301295} = "山东省青岛市";
$areanames{zh}->{861301296} = "山东省菏泽市";
$areanames{zh}->{861301297} = "山东省枣庄市";
$areanames{zh}->{861301298} = "山东省济南市";
$areanames{zh}->{861301299} = "山东省济南市";
$areanames{zh}->{861301300} = "安徽省滁州市";
$areanames{zh}->{861301301} = "安徽省滁州市";
$areanames{zh}->{861301302} = "安徽省滁州市";
$areanames{zh}->{861301303} = "安徽省合肥市";
$areanames{zh}->{861301304} = "安徽省池州市";
$areanames{zh}->{861301305} = "安徽省淮南市";
$areanames{zh}->{861301306} = "安徽省合肥市";
$areanames{zh}->{861301307} = "安徽省合肥市";
$areanames{zh}->{861301308} = "安徽省合肥市";
$areanames{zh}->{861301309} = "安徽省合肥市";
$areanames{zh}->{861301310} = "安徽省马鞍山市";
$areanames{zh}->{861301311} = "安徽省马鞍山市";
$areanames{zh}->{861301312} = "安徽省黄山市";
$areanames{zh}->{861301313} = "安徽省宣城市";
$areanames{zh}->{861301314} = "安徽省宣城市";
$areanames{zh}->{861301315} = "安徽省铜陵市";
$areanames{zh}->{861301316} = "安徽省安庆市";
$areanames{zh}->{861301317} = "安徽省安庆市";
$areanames{zh}->{861301318} = "安徽省安庆市";
$areanames{zh}->{861301319} = "安徽省安庆市";
$areanames{zh}->{861301320} = "河北省邯郸市";
$areanames{zh}->{861301321} = "河北省廊坊市";
$areanames{zh}->{861301322} = "河北省沧州市";
$areanames{zh}->{861301323} = "河北省石家庄市";
$areanames{zh}->{861301324} = "河北省保定市";
$areanames{zh}->{861301325} = "河北省保定市";
$areanames{zh}->{861301326} = "河北省秦皇岛市";
$areanames{zh}->{861301327} = "河北省衡水市";
$areanames{zh}->{861301328} = "河北省唐山市";
$areanames{zh}->{861301329} = "河北省邢台市";
$areanames{zh}->{861301330} = "云南省昆明市";
$areanames{zh}->{861301331} = "云南省昆明市";
$areanames{zh}->{861301332} = "云南省昆明市";
$areanames{zh}->{861301333} = "云南省昆明市";
$areanames{zh}->{861301334} = "云南省曲靖市";
$areanames{zh}->{861301335} = "云南省昆明市";
$areanames{zh}->{861301336} = "云南省大理白族自治州";
$areanames{zh}->{861301337} = "云南省玉溪市";
$areanames{zh}->{861301338} = "云南省丽江市";
$areanames{zh}->{861301339} = "云南省大理白族自治州";
$areanames{zh}->{861301340} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861301341} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861301342} = "云南省楚雄彝族自治州";
$areanames{zh}->{861301343} = "云南省楚雄彝族自治州";
$areanames{zh}->{861301344} = "云南省大理白族自治州";
$areanames{zh}->{861301345} = "云南省曲靖市";
$areanames{zh}->{861301346} = "云南省曲靖市";
$areanames{zh}->{861301347} = "云南省丽江市";
$areanames{zh}->{861301348} = "云南省玉溪市";
$areanames{zh}->{861301349} = "云南省玉溪市";
$areanames{zh}->{86130135} = "山东省临沂市";
$areanames{zh}->{861301356} = "山东省东营市";
$areanames{zh}->{861301357} = "山东省威海市";
$areanames{zh}->{861301358} = "山东省威海市";
$areanames{zh}->{861301359} = "山东省日照市";
$areanames{zh}->{86130136} = "江苏省无锡市";
$areanames{zh}->{861301370} = "江苏省扬州市";
$areanames{zh}->{861301371} = "江苏省扬州市";
$areanames{zh}->{861301372} = "江苏省扬州市";
$areanames{zh}->{861301373} = "江苏省扬州市";
$areanames{zh}->{861301374} = "江苏省扬州市";
$areanames{zh}->{861301375} = "江苏省苏州市";
$areanames{zh}->{861301376} = "江苏省苏州市";
$areanames{zh}->{861301377} = "江苏省苏州市";
$areanames{zh}->{861301378} = "江苏省苏州市";
$areanames{zh}->{861301379} = "江苏省苏州市";
$areanames{zh}->{86130138} = "江苏省苏州市";
$areanames{zh}->{86130139} = "江苏省徐州市";
$areanames{zh}->{861301390} = "江苏省宿迁市";
$areanames{zh}->{861301391} = "江苏省宿迁市";
$areanames{zh}->{861301392} = "江苏省宿迁市";
$areanames{zh}->{861301400} = "安徽省宿州市";
$areanames{zh}->{861301401} = "安徽省宿州市";
$areanames{zh}->{861301402} = "安徽省六安市";
$areanames{zh}->{861301403} = "安徽省六安市";
$areanames{zh}->{861301404} = "安徽省淮北市";
$areanames{zh}->{861301405} = "安徽省淮北市";
$areanames{zh}->{861301406} = "安徽省阜阳市";
$areanames{zh}->{861301407} = "安徽省阜阳市";
$areanames{zh}->{861301408} = "安徽省阜阳市";
$areanames{zh}->{861301409} = "安徽省阜阳市";
$areanames{zh}->{861301410} = "甘肃省嘉峪关市";
$areanames{zh}->{861301411} = "甘肃省张掖市";
$areanames{zh}->{861301412} = "甘肃省张掖市";
$areanames{zh}->{861301413} = "甘肃省武威市";
$areanames{zh}->{861301414} = "甘肃省兰州市";
$areanames{zh}->{861301415} = "甘肃省武威市";
$areanames{zh}->{861301416} = "甘肃省武威市";
$areanames{zh}->{861301417} = "甘肃省武威市";
$areanames{zh}->{861301418} = "甘肃省嘉峪关市";
$areanames{zh}->{861301419} = "甘肃省嘉峪关市";
$areanames{zh}->{861301420} = "宁夏石嘴山市";
$areanames{zh}->{861301421} = "宁夏石嘴山市";
$areanames{zh}->{861301422} = "宁夏吴忠市";
$areanames{zh}->{861301423} = "宁夏吴忠市";
$areanames{zh}->{861301424} = "宁夏吴忠市";
$areanames{zh}->{861301425} = "宁夏银川市";
$areanames{zh}->{861301426} = "宁夏银川市";
$areanames{zh}->{861301427} = "宁夏银川市";
$areanames{zh}->{861301428} = "宁夏银川市";
$areanames{zh}->{861301429} = "宁夏银川市";
$areanames{zh}->{86130143} = "河北省石家庄市";
$areanames{zh}->{861301430} = "河北省保定市";
$areanames{zh}->{861301431} = "河北省唐山市";
$areanames{zh}->{861301432} = "河北省唐山市";
$areanames{zh}->{861301440} = "江西省鹰潭市";
$areanames{zh}->{861301441} = "江西省鹰潭市";
$areanames{zh}->{861301442} = "江西省上饶市";
$areanames{zh}->{861301443} = "江西省上饶市";
$areanames{zh}->{861301444} = "江西省上饶市";
$areanames{zh}->{861301445} = "江西省宜春市";
$areanames{zh}->{861301446} = "江西省宜春市";
$areanames{zh}->{861301447} = "江西省宜春市";
$areanames{zh}->{861301448} = "江西省宜春市";
$areanames{zh}->{861301449} = "江西省宜春市";
$areanames{zh}->{86130145} = "河南省郑州市";
$areanames{zh}->{86130146} = "河南省郑州市";
$areanames{zh}->{86130147} = "河南省洛阳市";
$areanames{zh}->{861301480} = "广西防城港市";
$areanames{zh}->{861301481} = "广西贵港市";
$areanames{zh}->{861301482} = "广西贵港市";
$areanames{zh}->{861301483} = "广西北海市";
$areanames{zh}->{861301484} = "广西北海市";
$areanames{zh}->{861301485} = "广西桂林市";
$areanames{zh}->{861301486} = "广西桂林市";
$areanames{zh}->{861301487} = "广西柳州市";
$areanames{zh}->{861301488} = "广西柳州市";
$areanames{zh}->{861301489} = "广西柳州市";
$areanames{zh}->{861301490} = "广西南宁市";
$areanames{zh}->{861301491} = "广西南宁市";
$areanames{zh}->{861301492} = "广西玉林市";
$areanames{zh}->{861301493} = "广西柳州市";
$areanames{zh}->{861301494} = "广西贺州市";
$areanames{zh}->{861301495} = "广西玉林市";
$areanames{zh}->{861301496} = "广西玉林市";
$areanames{zh}->{861301497} = "广西钦州市";
$areanames{zh}->{861301498} = "广西南宁市";
$areanames{zh}->{861301499} = "广西南宁市";
$areanames{zh}->{861301500} = "内蒙古呼和浩特市";
$areanames{zh}->{861301501} = "内蒙古呼和浩特市";
$areanames{zh}->{861301502} = "内蒙古呼和浩特市";
$areanames{zh}->{861301503} = "内蒙古乌兰察布市";
$areanames{zh}->{861301504} = "内蒙古包头市";
$areanames{zh}->{861301505} = "内蒙古包头市";
$areanames{zh}->{861301506} = "内蒙古包头市";
$areanames{zh}->{861301507} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861301508} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861301509} = "内蒙古乌海市";
$areanames{zh}->{861301510} = "内蒙古呼和浩特市";
$areanames{zh}->{861301511} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861301512} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861301513} = "内蒙古通辽市";
$areanames{zh}->{861301514} = "内蒙古通辽市";
$areanames{zh}->{861301515} = "内蒙古包头市";
$areanames{zh}->{861301516} = "内蒙古包头市";
$areanames{zh}->{861301517} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861301518} = "内蒙古赤峰市";
$areanames{zh}->{861301519} = "内蒙古赤峰市";
$areanames{zh}->{861301520} = "内蒙古呼和浩特市";
$areanames{zh}->{861301521} = "内蒙古呼和浩特市";
$areanames{zh}->{861301522} = "内蒙古呼和浩特市";
$areanames{zh}->{861301523} = "内蒙古乌兰察布市";
$areanames{zh}->{861301524} = "内蒙古包头市";
$areanames{zh}->{861301525} = "内蒙古包头市";
$areanames{zh}->{861301526} = "内蒙古包头市";
$areanames{zh}->{861301527} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861301528} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861301529} = "内蒙古赤峰市";
$areanames{zh}->{861301530} = "山西省太原市";
$areanames{zh}->{861301531} = "山西省运城市";
$areanames{zh}->{861301532} = "山西省临汾市";
$areanames{zh}->{861301533} = "山西省晋中市";
$areanames{zh}->{861301534} = "山西省太原市";
$areanames{zh}->{861301535} = "山西省晋城市";
$areanames{zh}->{861301536} = "山西省长治市";
$areanames{zh}->{861301537} = "山西省太原市";
$areanames{zh}->{861301538} = "山西省太原市";
$areanames{zh}->{861301539} = "山西省大同市";
$areanames{zh}->{861301540} = "山西省太原市";
$areanames{zh}->{861301541} = "山西省运城市";
$areanames{zh}->{861301542} = "山西省临汾市";
$areanames{zh}->{861301543} = "山西省晋中市";
$areanames{zh}->{861301544} = "山西省太原市";
$areanames{zh}->{861301545} = "山西省晋城市";
$areanames{zh}->{861301546} = "山西省长治市";
$areanames{zh}->{861301547} = "山西省太原市";
$areanames{zh}->{861301548} = "山西省太原市";
$areanames{zh}->{861301549} = "山西省大同市";
$areanames{zh}->{861301550} = "河南省郑州市";
$areanames{zh}->{861301551} = "河南省郑州市";
$areanames{zh}->{861301552} = "河南省郑州市";
$areanames{zh}->{861301553} = "河南省郑州市";
$areanames{zh}->{861301554} = "河南省郑州市";
$areanames{zh}->{861301555} = "河南省洛阳市";
$areanames{zh}->{861301556} = "河南省洛阳市";
$areanames{zh}->{861301557} = "河南省洛阳市";
$areanames{zh}->{861301558} = "河南省洛阳市";
$areanames{zh}->{861301559} = "河南省洛阳市";
$areanames{zh}->{86130156} = "福建省漳州市";
$areanames{zh}->{861301560} = "福建省龙岩市";
$areanames{zh}->{861301568} = "福建省三明市";
$areanames{zh}->{861301569} = "福建省南平市";
$areanames{zh}->{86130157} = "福建省福州市";
$areanames{zh}->{861301570} = "福建省宁德市";
$areanames{zh}->{861301579} = "福建省宁德市";
$areanames{zh}->{86130158} = "福建省泉州市";
$areanames{zh}->{861301580} = "福建省宁德市";
$areanames{zh}->{861301589} = "福建省宁德市";
$areanames{zh}->{861301590} = "福建省莆田市";
$areanames{zh}->{861301591} = "福建省厦门市";
$areanames{zh}->{861301592} = "福建省厦门市";
$areanames{zh}->{861301593} = "福建省厦门市";
$areanames{zh}->{861301594} = "福建省厦门市";
$areanames{zh}->{861301595} = "福建省厦门市";
$areanames{zh}->{861301596} = "福建省莆田市";
$areanames{zh}->{861301597} = "福建省莆田市";
$areanames{zh}->{861301598} = "福建省莆田市";
$areanames{zh}->{861301599} = "福建省莆田市";
$areanames{zh}->{86130160} = "广东省广州市";
$areanames{zh}->{861301610} = "湖南省郴州市";
$areanames{zh}->{861301611} = "湖南省郴州市";
$areanames{zh}->{861301612} = "湖南省郴州市";
$areanames{zh}->{861301613} = "湖南省益阳市";
$areanames{zh}->{861301614} = "湖南省益阳市";
$areanames{zh}->{861301615} = "湖南省益阳市";
$areanames{zh}->{861301616} = "湖南省长沙市";
$areanames{zh}->{861301617} = "湖南省湘潭市";
$areanames{zh}->{861301618} = "湖南省衡阳市";
$areanames{zh}->{861301619} = "湖南省衡阳市";
$areanames{zh}->{86130162} = "海南省海口市";
$areanames{zh}->{86130163} = "广东省珠海市";
$areanames{zh}->{86130164} = "湖北省武汉市";
$areanames{zh}->{86130165} = "江苏省盐城市";
$areanames{zh}->{861301656} = "江苏省淮安市";
$areanames{zh}->{861301657} = "江苏省淮安市";
$areanames{zh}->{861301658} = "江苏省淮安市";
$areanames{zh}->{861301659} = "江苏省淮安市";
$areanames{zh}->{861301660} = "广东省佛山市";
$areanames{zh}->{861301661} = "广东省佛山市";
$areanames{zh}->{861301662} = "广东省佛山市";
$areanames{zh}->{861301663} = "广东省东莞市";
$areanames{zh}->{861301664} = "广东省东莞市";
$areanames{zh}->{861301665} = "广东省汕头市";
$areanames{zh}->{861301666} = "广东省汕头市";
$areanames{zh}->{861301667} = "广东省潮州市";
$areanames{zh}->{861301668} = "广东省汕头市";
$areanames{zh}->{861301669} = "广东省揭阳市";
$areanames{zh}->{86130167} = "江苏省泰州市";
$areanames{zh}->{861301676} = "江苏省南通市";
$areanames{zh}->{861301677} = "江苏省南通市";
$areanames{zh}->{861301678} = "江苏省南通市";
$areanames{zh}->{861301679} = "江苏省南通市";
$areanames{zh}->{86130168} = "江苏省常州市";
$areanames{zh}->{861301680} = "江苏省镇江市";
$areanames{zh}->{861301681} = "江苏省镇江市";
$areanames{zh}->{861301682} = "江苏省镇江市";
$areanames{zh}->{861301683} = "江苏省镇江市";
$areanames{zh}->{86130169} = "江苏省南京市";
$areanames{zh}->{861301690} = "江苏省连云港市";
$areanames{zh}->{861301691} = "江苏省连云港市";
$areanames{zh}->{861301692} = "江苏省连云港市";
$areanames{zh}->{861301700} = "贵州省铜仁地区";
$areanames{zh}->{861301701} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861301702} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861301703} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861301704} = "贵州省六盘水市";
$areanames{zh}->{861301705} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861301706} = "贵州省毕节地区";
$areanames{zh}->{861301707} = "贵州省六盘水市";
$areanames{zh}->{861301708} = "贵州省安顺市";
$areanames{zh}->{861301709} = "贵州省安顺市";
$areanames{zh}->{861301710} = "湖南省株洲市";
$areanames{zh}->{861301711} = "湖南省株洲市";
$areanames{zh}->{861301712} = "湖南省株洲市";
$areanames{zh}->{861301713} = "湖南省株洲市";
$areanames{zh}->{861301714} = "湖南省湘潭市";
$areanames{zh}->{861301715} = "湖南省湘潭市";
$areanames{zh}->{861301716} = "湖南省衡阳市";
$areanames{zh}->{861301717} = "湖南省衡阳市";
$areanames{zh}->{861301718} = "湖南省长沙市";
$areanames{zh}->{861301719} = "湖南省长沙市";
$areanames{zh}->{861301720} = "湖南省岳阳市";
$areanames{zh}->{861301721} = "湖南省岳阳市";
$areanames{zh}->{861301722} = "湖南省岳阳市";
$areanames{zh}->{861301723} = "湖南省岳阳市";
$areanames{zh}->{861301724} = "湖南省常德市";
$areanames{zh}->{861301725} = "湖南省常德市";
$areanames{zh}->{861301726} = "湖南省常德市";
$areanames{zh}->{861301727} = "湖南省常德市";
$areanames{zh}->{861301728} = "湖南省长沙市";
$areanames{zh}->{861301729} = "湖南省长沙市";
$areanames{zh}->{861301730} = "湖南省岳阳市";
$areanames{zh}->{861301731} = "湖南省长沙市";
$areanames{zh}->{861301732} = "湖南省湘潭市";
$areanames{zh}->{861301733} = "湖南省株洲市";
$areanames{zh}->{861301734} = "湖南省衡阳市";
$areanames{zh}->{861301735} = "湖南省郴州市";
$areanames{zh}->{861301736} = "湖南省常德市";
$areanames{zh}->{861301737} = "湖南省益阳市";
$areanames{zh}->{861301738} = "湖南省长沙市";
$areanames{zh}->{861301739} = "湖南省长沙市";
$areanames{zh}->{861301740} = "贵州省遵义市";
$areanames{zh}->{861301741} = "贵州省遵义市";
$areanames{zh}->{861301742} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861301743} = "贵州省贵阳市";
$areanames{zh}->{861301744} = "贵州省安顺市";
$areanames{zh}->{861301745} = "贵州省贵阳市";
$areanames{zh}->{861301746} = "贵州省贵阳市";
$areanames{zh}->{861301747} = "贵州省贵阳市";
$areanames{zh}->{861301748} = "贵州省贵阳市";
$areanames{zh}->{861301749} = "贵州省遵义市";
$areanames{zh}->{861301750} = "河南省焦作市";
$areanames{zh}->{861301751} = "河南省焦作市";
$areanames{zh}->{861301752} = "河南省安阳市";
$areanames{zh}->{861301753} = "河南省新乡市";
$areanames{zh}->{861301754} = "河南省新乡市";
$areanames{zh}->{861301755} = "河南省平顶山市";
$areanames{zh}->{861301756} = "河南省平顶山市";
$areanames{zh}->{861301757} = "河南省平顶山市";
$areanames{zh}->{861301758} = "河南省开封市";
$areanames{zh}->{861301759} = "河南省许昌市";
$areanames{zh}->{861301760} = "河南省新乡市";
$areanames{zh}->{861301761} = "河南省漯河市";
$areanames{zh}->{861301762} = "河南省开封市";
$areanames{zh}->{861301763} = "河南省洛阳市";
$areanames{zh}->{861301764} = "河南省洛阳市";
$areanames{zh}->{861301765} = "河南省郑州市";
$areanames{zh}->{861301766} = "河南省郑州市";
$areanames{zh}->{861301767} = "河南省郑州市";
$areanames{zh}->{861301768} = "河南省郑州市";
$areanames{zh}->{861301769} = "河南省郑州市";
$areanames{zh}->{861301770} = "浙江省绍兴市";
$areanames{zh}->{861301771} = "浙江省绍兴市";
$areanames{zh}->{861301772} = "浙江省绍兴市";
$areanames{zh}->{861301773} = "浙江省绍兴市";
$areanames{zh}->{861301774} = "浙江省衢州市";
$areanames{zh}->{861301775} = "浙江省嘉兴市";
$areanames{zh}->{861301776} = "浙江省嘉兴市";
$areanames{zh}->{861301777} = "浙江省嘉兴市";
$areanames{zh}->{861301778} = "浙江省嘉兴市";
$areanames{zh}->{861301779} = "浙江省嘉兴市";
$areanames{zh}->{86130178} = "浙江省温州市";
$areanames{zh}->{86130179} = "浙江省金华市";
$areanames{zh}->{861301790} = "浙江省湖州市";
$areanames{zh}->{861301791} = "浙江省湖州市";
$areanames{zh}->{861301792} = "浙江省丽水市";
$areanames{zh}->{861301793} = "浙江省丽水市";
$areanames{zh}->{86130180} = "湖北省武汉市";
$areanames{zh}->{861301810} = "四川省凉山彝族自治州";
$areanames{zh}->{861301811} = "四川省攀枝花市";
$areanames{zh}->{861301812} = "四川省南充市";
$areanames{zh}->{861301813} = "四川省绵阳市";
$areanames{zh}->{861301814} = "四川省绵阳市";
$areanames{zh}->{861301815} = "四川省泸州市";
$areanames{zh}->{861301816} = "四川省内江市";
$areanames{zh}->{861301817} = "四川省宜宾市";
$areanames{zh}->{861301818} = "四川省自贡市";
$areanames{zh}->{861301819} = "四川省德阳市";
$areanames{zh}->{86130182} = "四川省成都市";
$areanames{zh}->{86130183} = "重庆市";
$areanames{zh}->{86130184} = "广东省惠州市";
$areanames{zh}->{861301847} = "广东省珠海市";
$areanames{zh}->{861301848} = "广东省珠海市";
$areanames{zh}->{861301849} = "广东省珠海市";
$areanames{zh}->{86130185} = "广东省佛山市";
$areanames{zh}->{861301850} = "广东省茂名市";
$areanames{zh}->{861301851} = "广东省阳江市";
$areanames{zh}->{861301858} = "广东省湛江市";
$areanames{zh}->{861301859} = "广东省湛江市";
$areanames{zh}->{86130186} = "广东省东莞市";
$areanames{zh}->{861301870} = "广东省清远市";
$areanames{zh}->{861301871} = "广东省韶关市";
$areanames{zh}->{861301872} = "广东省中山市";
$areanames{zh}->{861301873} = "广东省中山市";
$areanames{zh}->{861301874} = "广东省中山市";
$areanames{zh}->{861301875} = "广东省中山市";
$areanames{zh}->{861301876} = "广东省中山市";
$areanames{zh}->{861301877} = "广东省梅州市";
$areanames{zh}->{861301878} = "广东省梅州市";
$areanames{zh}->{861301879} = "广东省河源市";
$areanames{zh}->{86130188} = "浙江省台州市";
$areanames{zh}->{861301880} = "浙江省绍兴市";
$areanames{zh}->{861301881} = "浙江省舟山市";
$areanames{zh}->{86130189} = "浙江省杭州市";
$areanames{zh}->{861301900} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301901} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301902} = "黑龙江省鹤岗市";
$areanames{zh}->{861301903} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861301904} = "黑龙江省双鸭山市";
$areanames{zh}->{861301905} = "黑龙江省牡丹江市";
$areanames{zh}->{861301906} = "黑龙江省牡丹江市";
$areanames{zh}->{861301907} = "黑龙江省大庆市";
$areanames{zh}->{861301908} = "黑龙江省大庆市";
$areanames{zh}->{861301909} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861301910} = "吉林省长春市";
$areanames{zh}->{861301911} = "吉林省长春市";
$areanames{zh}->{861301912} = "吉林省长春市";
$areanames{zh}->{861301913} = "吉林省长春市";
$areanames{zh}->{861301914} = "吉林省松原市";
$areanames{zh}->{861301915} = "吉林省吉林市";
$areanames{zh}->{861301916} = "吉林省吉林市";
$areanames{zh}->{861301917} = "吉林省吉林市";
$areanames{zh}->{861301918} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861301919} = "吉林省通化市";
$areanames{zh}->{861301920} = "吉林省长春市";
$areanames{zh}->{861301921} = "吉林省长春市";
$areanames{zh}->{861301922} = "吉林省长春市";
$areanames{zh}->{861301923} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861301924} = "吉林省吉林市";
$areanames{zh}->{861301925} = "吉林省吉林市";
$areanames{zh}->{861301926} = "吉林省吉林市";
$areanames{zh}->{861301927} = "吉林省吉林市";
$areanames{zh}->{861301928} = "吉林省辽源市";
$areanames{zh}->{861301929} = "吉林省辽源市";
$areanames{zh}->{86130193} = "辽宁省沈阳市";
$areanames{zh}->{86130194} = "辽宁省大连市";
$areanames{zh}->{861301950} = "内蒙古呼和浩特市";
$areanames{zh}->{861301951} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861301952} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861301953} = "内蒙古通辽市";
$areanames{zh}->{861301954} = "内蒙古通辽市";
$areanames{zh}->{861301955} = "内蒙古包头市";
$areanames{zh}->{861301956} = "内蒙古包头市";
$areanames{zh}->{861301957} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861301958} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861301959} = "内蒙古赤峰市";
$areanames{zh}->{861301960} = "辽宁省鞍山市";
$areanames{zh}->{861301961} = "辽宁省鞍山市";
$areanames{zh}->{861301962} = "辽宁省鞍山市";
$areanames{zh}->{861301963} = "辽宁省鞍山市";
$areanames{zh}->{861301964} = "辽宁省鞍山市";
$areanames{zh}->{861301965} = "辽宁省抚顺市";
$areanames{zh}->{861301966} = "辽宁省抚顺市";
$areanames{zh}->{861301967} = "辽宁省本溪市";
$areanames{zh}->{861301968} = "辽宁省本溪市";
$areanames{zh}->{861301969} = "辽宁省丹东市";
$areanames{zh}->{861301970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861301973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861301974} = "黑龙江省鸡西市";
$areanames{zh}->{861301975} = "黑龙江省佳木斯市";
$areanames{zh}->{861301976} = "黑龙江省佳木斯市";
$areanames{zh}->{861301977} = "黑龙江省大庆市";
$areanames{zh}->{861301978} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861301979} = "黑龙江省七台河市";
$areanames{zh}->{861301980} = "辽宁省丹东市";
$areanames{zh}->{861301981} = "辽宁省锦州市";
$areanames{zh}->{861301982} = "辽宁省锦州市";
$areanames{zh}->{861301983} = "辽宁省锦州市";
$areanames{zh}->{861301984} = "辽宁省营口市";
$areanames{zh}->{861301985} = "辽宁省营口市";
$areanames{zh}->{861301986} = "辽宁省阜新市";
$areanames{zh}->{861301987} = "辽宁省阜新市";
$areanames{zh}->{861301988} = "辽宁省辽阳市";
$areanames{zh}->{861301989} = "辽宁省辽阳市";
$areanames{zh}->{861301990} = "辽宁省辽阳市";
$areanames{zh}->{861301991} = "辽宁省铁岭市";
$areanames{zh}->{861301992} = "辽宁省铁岭市";
$areanames{zh}->{861301993} = "辽宁省朝阳市";
$areanames{zh}->{861301994} = "辽宁省盘锦市";
$areanames{zh}->{861301995} = "辽宁省盘锦市";
$areanames{zh}->{861301996} = "辽宁省盘锦市";
$areanames{zh}->{861301997} = "辽宁省葫芦岛市";
$areanames{zh}->{861301998} = "辽宁省葫芦岛市";
$areanames{zh}->{861301999} = "辽宁省葫芦岛市";
$areanames{zh}->{86130200} = "北京市";
$areanames{zh}->{86130201} = "上海市";
$areanames{zh}->{86130202} = "上海市";
$areanames{zh}->{861302030} = "辽宁省沈阳市";
$areanames{zh}->{861302031} = "辽宁省沈阳市";
$areanames{zh}->{861302032} = "辽宁省沈阳市";
$areanames{zh}->{861302033} = "辽宁省鞍山市";
$areanames{zh}->{861302034} = "辽宁省抚顺市";
$areanames{zh}->{861302035} = "辽宁省丹东市";
$areanames{zh}->{861302036} = "辽宁省锦州市";
$areanames{zh}->{861302037} = "辽宁省营口市";
$areanames{zh}->{861302038} = "辽宁省阜新市";
$areanames{zh}->{861302039} = "辽宁省铁岭市";
$areanames{zh}->{861302040} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861302041} = "内蒙古通辽市";
$areanames{zh}->{861302042} = "内蒙古赤峰市";
$areanames{zh}->{861302043} = "内蒙古包头市";
$areanames{zh}->{861302044} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861302045} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861302046} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861302047} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861302048} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861302049} = "内蒙古通辽市";
$areanames{zh}->{861302050} = "山东省济宁市";
$areanames{zh}->{861302051} = "山东省菏泽市";
$areanames{zh}->{861302052} = "山东省枣庄市";
$areanames{zh}->{861302053} = "山东省日照市";
$areanames{zh}->{861302054} = "山东省滨州市";
$areanames{zh}->{861302055} = "山东省聊城市";
$areanames{zh}->{861302056} = "山东省德州市";
$areanames{zh}->{861302057} = "山东省聊城市";
$areanames{zh}->{861302058} = "山东省聊城市";
$areanames{zh}->{861302059} = "山东省聊城市";
$areanames{zh}->{861302060} = "山东省东营市";
$areanames{zh}->{861302061} = "山东省德州市";
$areanames{zh}->{861302062} = "山东省滨州市";
$areanames{zh}->{861302063} = "山东省枣庄市";
$areanames{zh}->{861302064} = "山东省菏泽市";
$areanames{zh}->{861302065} = "山东省临沂市";
$areanames{zh}->{861302066} = "山东省临沂市";
$areanames{zh}->{861302067} = "山东省济宁市";
$areanames{zh}->{861302068} = "山东省济宁市";
$areanames{zh}->{861302069} = "山东省济宁市";
$areanames{zh}->{86130207} = "陕西省咸阳市";
$areanames{zh}->{861302080} = "河北省保定市";
$areanames{zh}->{861302081} = "河北省保定市";
$areanames{zh}->{861302082} = "河北省保定市";
$areanames{zh}->{861302083} = "河北省邯郸市";
$areanames{zh}->{861302084} = "河北省石家庄市";
$areanames{zh}->{861302085} = "河北省石家庄市";
$areanames{zh}->{861302086} = "河北省石家庄市";
$areanames{zh}->{861302087} = "河北省张家口市";
$areanames{zh}->{861302088} = "河北省唐山市";
$areanames{zh}->{861302089} = "河北省承德市";
$areanames{zh}->{861302090} = "浙江省温州市";
$areanames{zh}->{861302091} = "浙江省温州市";
$areanames{zh}->{861302092} = "浙江省温州市";
$areanames{zh}->{861302093} = "浙江省温州市";
$areanames{zh}->{861302094} = "浙江省温州市";
$areanames{zh}->{861302095} = "浙江省台州市";
$areanames{zh}->{861302096} = "浙江省台州市";
$areanames{zh}->{861302097} = "浙江省台州市";
$areanames{zh}->{861302098} = "浙江省金华市";
$areanames{zh}->{861302099} = "浙江省嘉兴市";
$areanames{zh}->{86130210} = "北京市";
$areanames{zh}->{86130211} = "北京市";
$areanames{zh}->{86130212} = "北京市";
$areanames{zh}->{86130213} = "天津市";
$areanames{zh}->{861302140} = "河北省保定市";
$areanames{zh}->{861302141} = "河北省唐山市";
$areanames{zh}->{861302142} = "河北省秦皇岛市";
$areanames{zh}->{861302143} = "河北省廊坊市";
$areanames{zh}->{861302144} = "河北省沧州市";
$areanames{zh}->{861302145} = "河北省邢台市";
$areanames{zh}->{861302146} = "河北省邯郸市";
$areanames{zh}->{861302147} = "河北省衡水市";
$areanames{zh}->{861302148} = "河北省沧州市";
$areanames{zh}->{861302149} = "河北省石家庄市";
$areanames{zh}->{861302150} = "山东省淄博市";
$areanames{zh}->{861302151} = "山东省淄博市";
$areanames{zh}->{861302152} = "山东省滨州市";
$areanames{zh}->{861302153} = "山东省潍坊市";
$areanames{zh}->{861302154} = "山东省潍坊市";
$areanames{zh}->{861302155} = "山东省潍坊市";
$areanames{zh}->{861302156} = "山东省东营市";
$areanames{zh}->{861302157} = "山东省临沂市";
$areanames{zh}->{861302158} = "山东省日照市";
$areanames{zh}->{861302159} = "山东省枣庄市";
$areanames{zh}->{861302160} = "山东省烟台市";
$areanames{zh}->{861302161} = "山东省烟台市";
$areanames{zh}->{861302162} = "山东省烟台市";
$areanames{zh}->{861302163} = "山东省威海市";
$areanames{zh}->{861302164} = "山东省威海市";
$areanames{zh}->{861302165} = "山东省威海市";
$areanames{zh}->{861302166} = "山东省青岛市";
$areanames{zh}->{861302167} = "山东省青岛市";
$areanames{zh}->{861302168} = "山东省青岛市";
$areanames{zh}->{861302169} = "山东省青岛市";
$areanames{zh}->{861302170} = "山东省济南市";
$areanames{zh}->{861302171} = "山东省济南市";
$areanames{zh}->{861302172} = "山东省济南市";
$areanames{zh}->{861302173} = "山东省济南市";
$areanames{zh}->{861302174} = "山东省济南市";
$areanames{zh}->{861302175} = "山东省聊城市";
$areanames{zh}->{861302176} = "山东省德州市";
$areanames{zh}->{861302177} = "山东省泰安市";
$areanames{zh}->{861302178} = "山东省济宁市";
$areanames{zh}->{861302179} = "山东省菏泽市";
$areanames{zh}->{861302180} = "河北省石家庄市";
$areanames{zh}->{861302181} = "河北省唐山市";
$areanames{zh}->{861302182} = "河北省秦皇岛市";
$areanames{zh}->{861302183} = "河北省廊坊市";
$areanames{zh}->{861302184} = "河北省唐山市";
$areanames{zh}->{861302185} = "河北省邢台市";
$areanames{zh}->{861302186} = "河北省邯郸市";
$areanames{zh}->{861302187} = "河北省保定市";
$areanames{zh}->{861302188} = "河北省石家庄市";
$areanames{zh}->{861302189} = "河北省石家庄市";
$areanames{zh}->{86130219} = "北京市";
$areanames{zh}->{86130220} = "广东省广州市";
$areanames{zh}->{86130221} = "上海市";
$areanames{zh}->{86130222} = "天津市";
$areanames{zh}->{86130223} = "重庆市";
$areanames{zh}->{86130224} = "辽宁省沈阳市";
$areanames{zh}->{86130225} = "江苏省南京市";
$areanames{zh}->{861302260} = "浙江省嘉兴市";
$areanames{zh}->{861302261} = "浙江省湖州市";
$areanames{zh}->{861302262} = "浙江省舟山市";
$areanames{zh}->{861302263} = "浙江省绍兴市";
$areanames{zh}->{861302264} = "浙江省衢州市";
$areanames{zh}->{861302265} = "浙江省金华市";
$areanames{zh}->{861302266} = "浙江省台州市";
$areanames{zh}->{861302267} = "浙江省丽水市";
$areanames{zh}->{861302268} = "浙江省温州市";
$areanames{zh}->{861302269} = "浙江省温州市";
$areanames{zh}->{861302270} = "山东省淄博市";
$areanames{zh}->{861302271} = "山东省淄博市";
$areanames{zh}->{861302272} = "山东省烟台市";
$areanames{zh}->{861302273} = "山东省烟台市";
$areanames{zh}->{861302274} = "山东省烟台市";
$areanames{zh}->{861302275} = "山东省烟台市";
$areanames{zh}->{861302276} = "山东省莱芜市";
$areanames{zh}->{861302277} = "山东省泰安市";
$areanames{zh}->{861302278} = "山东省潍坊市";
$areanames{zh}->{861302279} = "山东省临沂市";
$areanames{zh}->{86130228} = "陕西省西安市";
$areanames{zh}->{86130229} = "陕西省西安市";
$areanames{zh}->{861302300} = "安徽省合肥市";
$areanames{zh}->{861302301} = "安徽省蚌埠市";
$areanames{zh}->{861302302} = "安徽省蚌埠市";
$areanames{zh}->{861302303} = "安徽省芜湖市";
$areanames{zh}->{861302304} = "安徽省芜湖市";
$areanames{zh}->{861302305} = "安徽省合肥市";
$areanames{zh}->{861302306} = "安徽省合肥市";
$areanames{zh}->{861302307} = "安徽省淮南市";
$areanames{zh}->{861302308} = "安徽省合肥市";
$areanames{zh}->{861302309} = "安徽省合肥市";
$areanames{zh}->{86130231} = "上海市";
$areanames{zh}->{86130232} = "上海市";
$areanames{zh}->{86130233} = "江苏省无锡市";
$areanames{zh}->{861302334} = "湖南省湘潭市";
$areanames{zh}->{861302340} = "江苏省南京市";
$areanames{zh}->{861302341} = "江苏省南京市";
$areanames{zh}->{861302342} = "江苏省南京市";
$areanames{zh}->{861302343} = "江苏省镇江市";
$areanames{zh}->{861302344} = "江苏省镇江市";
$areanames{zh}->{861302345} = "江苏省镇江市";
$areanames{zh}->{861302346} = "江苏省连云港市";
$areanames{zh}->{861302347} = "江苏省连云港市";
$areanames{zh}->{861302348} = "江苏省盐城市";
$areanames{zh}->{861302349} = "江苏省宿迁市";
$areanames{zh}->{86130235} = "江苏省南通市";
$areanames{zh}->{861302350} = "江苏省徐州市";
$areanames{zh}->{861302351} = "江苏省徐州市";
$areanames{zh}->{861302352} = "江苏省徐州市";
$areanames{zh}->{861302354} = "江苏省淮安市";
$areanames{zh}->{86130236} = "浙江省杭州市";
$areanames{zh}->{86130237} = "浙江省宁波市";
$areanames{zh}->{86130238} = "福建省福州市";
$areanames{zh}->{861302385} = "福建省莆田市";
$areanames{zh}->{861302386} = "福建省莆田市";
$areanames{zh}->{86130239} = "福建省厦门市";
$areanames{zh}->{861302395} = "福建省漳州市";
$areanames{zh}->{861302396} = "福建省漳州市";
$areanames{zh}->{861302400} = "安徽省淮南市";
$areanames{zh}->{861302401} = "安徽省阜阳市";
$areanames{zh}->{861302402} = "安徽省亳州市";
$areanames{zh}->{861302403} = "安徽省阜阳市";
$areanames{zh}->{861302404} = "安徽省芜湖市";
$areanames{zh}->{861302405} = "安徽省芜湖市";
$areanames{zh}->{861302406} = "安徽省芜湖市";
$areanames{zh}->{861302407} = "安徽省蚌埠市";
$areanames{zh}->{861302408} = "安徽省蚌埠市";
$areanames{zh}->{861302409} = "安徽省蚌埠市";
$areanames{zh}->{86130241} = "上海市";
$areanames{zh}->{861302420} = "浙江省嘉兴市";
$areanames{zh}->{861302421} = "浙江省嘉兴市";
$areanames{zh}->{861302422} = "浙江省嘉兴市";
$areanames{zh}->{861302423} = "浙江省嘉兴市";
$areanames{zh}->{861302424} = "浙江省嘉兴市";
$areanames{zh}->{861302425} = "浙江省湖州市";
$areanames{zh}->{861302426} = "浙江省湖州市";
$areanames{zh}->{861302427} = "浙江省杭州市";
$areanames{zh}->{861302428} = "浙江省杭州市";
$areanames{zh}->{861302429} = "浙江省杭州市";
$areanames{zh}->{86130243} = "江苏省扬州市";
$areanames{zh}->{861302435} = "江苏省镇江市";
$areanames{zh}->{861302436} = "江苏省镇江市";
$areanames{zh}->{861302437} = "湖南省邵阳市";
$areanames{zh}->{861302438} = "湖南省邵阳市";
$areanames{zh}->{861302440} = "江苏省常州市";
$areanames{zh}->{861302441} = "江苏省常州市";
$areanames{zh}->{861302442} = "江苏省常州市";
$areanames{zh}->{861302443} = "江苏省常州市";
$areanames{zh}->{861302444} = "江苏省泰州市";
$areanames{zh}->{861302445} = "江苏省泰州市";
$areanames{zh}->{861302446} = "江苏省泰州市";
$areanames{zh}->{861302447} = "江苏省盐城市";
$areanames{zh}->{861302448} = "江苏省盐城市";
$areanames{zh}->{861302449} = "江苏省盐城市";
$areanames{zh}->{86130245} = "江苏省苏州市";
$areanames{zh}->{861302460} = "浙江省绍兴市";
$areanames{zh}->{861302461} = "浙江省绍兴市";
$areanames{zh}->{861302462} = "浙江省绍兴市";
$areanames{zh}->{861302463} = "浙江省绍兴市";
$areanames{zh}->{861302464} = "浙江省金华市";
$areanames{zh}->{861302465} = "浙江省金华市";
$areanames{zh}->{861302466} = "浙江省金华市";
$areanames{zh}->{861302467} = "浙江省金华市";
$areanames{zh}->{861302468} = "浙江省衢州市";
$areanames{zh}->{861302469} = "浙江省丽水市";
$areanames{zh}->{86130247} = "浙江省温州市";
$areanames{zh}->{861302476} = "浙江省台州市";
$areanames{zh}->{861302477} = "浙江省台州市";
$areanames{zh}->{861302478} = "浙江省台州市";
$areanames{zh}->{861302479} = "浙江省台州市";
$areanames{zh}->{86130248} = "福建省泉州市";
$areanames{zh}->{861302490} = "福建省三明市";
$areanames{zh}->{861302491} = "福建省宁德市";
$areanames{zh}->{861302492} = "福建省宁德市";
$areanames{zh}->{861302493} = "福建省宁德市";
$areanames{zh}->{861302494} = "福建省南平市";
$areanames{zh}->{861302495} = "福建省南平市";
$areanames{zh}->{861302496} = "福建省南平市";
$areanames{zh}->{861302497} = "福建省龙岩市";
$areanames{zh}->{861302498} = "福建省龙岩市";
$areanames{zh}->{861302499} = "福建省三明市";
$areanames{zh}->{86130250} = "浙江省温州市";
$areanames{zh}->{86130251} = "广东省广州市";
$areanames{zh}->{861302520} = "广东省汕头市";
$areanames{zh}->{861302521} = "广东省汕头市";
$areanames{zh}->{861302522} = "广东省汕头市";
$areanames{zh}->{861302523} = "广东省汕头市";
$areanames{zh}->{861302524} = "广东省汕头市";
$areanames{zh}->{861302525} = "广东省汕尾市";
$areanames{zh}->{861302526} = "广东省揭阳市";
$areanames{zh}->{861302527} = "广东省揭阳市";
$areanames{zh}->{861302528} = "广东省梅州市";
$areanames{zh}->{861302529} = "广东省梅州市";
$areanames{zh}->{861302530} = "广东省河源市";
$areanames{zh}->{861302531} = "广东省潮州市";
$areanames{zh}->{861302532} = "广东省汕头市";
$areanames{zh}->{861302533} = "广东省汕头市";
$areanames{zh}->{861302534} = "广东省汕头市";
$areanames{zh}->{861302535} = "广东省清远市";
$areanames{zh}->{861302536} = "广东省韶关市";
$areanames{zh}->{861302537} = "广东省韶关市";
$areanames{zh}->{861302538} = "广东省云浮市";
$areanames{zh}->{861302539} = "广东省云浮市";
$areanames{zh}->{86130254} = "广东省深圳市";
$areanames{zh}->{86130255} = "广东省中山市";
$areanames{zh}->{861302556} = "广东省肇庆市";
$areanames{zh}->{861302557} = "广东省肇庆市";
$areanames{zh}->{861302558} = "广东省肇庆市";
$areanames{zh}->{861302559} = "广东省肇庆市";
$areanames{zh}->{861302560} = "广东省湛江市";
$areanames{zh}->{861302561} = "广东省湛江市";
$areanames{zh}->{861302562} = "广东省湛江市";
$areanames{zh}->{861302563} = "广东省湛江市";
$areanames{zh}->{861302564} = "广东省阳江市";
$areanames{zh}->{861302565} = "广东省阳江市";
$areanames{zh}->{861302566} = "广东省茂名市";
$areanames{zh}->{861302567} = "广东省茂名市";
$areanames{zh}->{861302568} = "广东省茂名市";
$areanames{zh}->{861302569} = "广东省珠海市";
$areanames{zh}->{86130257} = "广东省惠州市";
$areanames{zh}->{861302576} = "广东省珠海市";
$areanames{zh}->{861302577} = "广东省珠海市";
$areanames{zh}->{861302578} = "广东省珠海市";
$areanames{zh}->{861302579} = "广东省珠海市";
$areanames{zh}->{86130258} = "广东省江门市";
$areanames{zh}->{861302590} = "广西南宁市";
$areanames{zh}->{861302591} = "广西南宁市";
$areanames{zh}->{861302592} = "广西南宁市";
$areanames{zh}->{861302593} = "广西柳州市";
$areanames{zh}->{861302594} = "广西桂林市";
$areanames{zh}->{861302595} = "广西桂林市";
$areanames{zh}->{861302596} = "广西玉林市";
$areanames{zh}->{861302597} = "广西梧州市";
$areanames{zh}->{861302598} = "广西梧州市";
$areanames{zh}->{861302599} = "广西北海市";
$areanames{zh}->{861302600} = "安徽省安庆市";
$areanames{zh}->{861302601} = "安徽省安庆市";
$areanames{zh}->{861302602} = "安徽省滁州市";
$areanames{zh}->{861302603} = "安徽省滁州市";
$areanames{zh}->{861302604} = "安徽省淮北市";
$areanames{zh}->{861302605} = "安徽省淮北市";
$areanames{zh}->{861302606} = "安徽省六安市";
$areanames{zh}->{861302607} = "安徽省宣城市";
$areanames{zh}->{861302608} = "安徽省马鞍山市";
$areanames{zh}->{861302609} = "安徽省宿州市";
$areanames{zh}->{86130261} = "湖北省武汉市";
$areanames{zh}->{861302620} = "江西省南昌市";
$areanames{zh}->{861302621} = "江西省南昌市";
$areanames{zh}->{861302622} = "江西省鹰潭市";
$areanames{zh}->{861302623} = "江西省鹰潭市";
$areanames{zh}->{861302624} = "江西省赣州市";
$areanames{zh}->{861302625} = "江西省鹰潭市";
$areanames{zh}->{861302626} = "江西省宜春市";
$areanames{zh}->{861302627} = "江西省宜春市";
$areanames{zh}->{861302628} = "江西省宜春市";
$areanames{zh}->{861302629} = "江西省宜春市";
$areanames{zh}->{86130263} = "湖北省武汉市";
$areanames{zh}->{861302640} = "陕西省榆林市";
$areanames{zh}->{861302641} = "陕西省渭南市";
$areanames{zh}->{861302642} = "陕西省汉中市";
$areanames{zh}->{861302643} = "陕西省延安市";
$areanames{zh}->{861302644} = "陕西省宝鸡市";
$areanames{zh}->{861302645} = "四川省德阳市";
$areanames{zh}->{861302646} = "陕西省渭南市";
$areanames{zh}->{861302647} = "陕西省延安市";
$areanames{zh}->{861302648} = "四川省绵阳市";
$areanames{zh}->{861302649} = "四川省绵阳市";
$areanames{zh}->{861302650} = "山东省青岛市";
$areanames{zh}->{861302651} = "山东省青岛市";
$areanames{zh}->{861302652} = "山东省青岛市";
$areanames{zh}->{861302653} = "山东省青岛市";
$areanames{zh}->{861302654} = "山东省东营市";
$areanames{zh}->{861302655} = "山东省潍坊市";
$areanames{zh}->{861302656} = "山东省潍坊市";
$areanames{zh}->{861302657} = "山东省济南市";
$areanames{zh}->{861302658} = "山东省济南市";
$areanames{zh}->{861302659} = "山东省济南市";
$areanames{zh}->{86130266} = "广东省深圳市";
$areanames{zh}->{86130267} = "广东省佛山市";
$areanames{zh}->{86130268} = "广东省东莞市";
$areanames{zh}->{861302686} = "广东省广州市";
$areanames{zh}->{861302687} = "广东省广州市";
$areanames{zh}->{861302688} = "广东省广州市";
$areanames{zh}->{861302689} = "广东省广州市";
$areanames{zh}->{861302690} = "广西防城港市";
$areanames{zh}->{861302691} = "广西南宁市";
$areanames{zh}->{861302692} = "广西柳州市";
$areanames{zh}->{861302693} = "广西桂林市";
$areanames{zh}->{861302694} = "广西梧州市";
$areanames{zh}->{861302695} = "广西玉林市";
$areanames{zh}->{861302696} = "广西百色市";
$areanames{zh}->{861302697} = "广西钦州市";
$areanames{zh}->{861302698} = "广西河池市";
$areanames{zh}->{861302699} = "广西北海市";
$areanames{zh}->{86130270} = "山西省太原市";
$areanames{zh}->{861302705} = "山西省晋中市";
$areanames{zh}->{861302706} = "山西省晋中市";
$areanames{zh}->{86130271} = "湖北省武汉市";
$areanames{zh}->{86130272} = "江西省南昌市";
$areanames{zh}->{861302725} = "江西省九江市";
$areanames{zh}->{861302726} = "江西省九江市";
$areanames{zh}->{861302727} = "江西省九江市";
$areanames{zh}->{861302729} = "江西省九江市";
$areanames{zh}->{861302730} = "湖南省岳阳市";
$areanames{zh}->{861302731} = "湖南省长沙市";
$areanames{zh}->{861302732} = "湖南省湘潭市";
$areanames{zh}->{861302733} = "湖南省株洲市";
$areanames{zh}->{861302734} = "湖南省衡阳市";
$areanames{zh}->{861302735} = "湖南省郴州市";
$areanames{zh}->{861302736} = "湖南省常德市";
$areanames{zh}->{861302737} = "湖南省益阳市";
$areanames{zh}->{861302738} = "湖南省娄底市";
$areanames{zh}->{861302739} = "湖南省邵阳市";
$areanames{zh}->{861302740} = "湖南省常德市";
$areanames{zh}->{861302741} = "湖南省长沙市";
$areanames{zh}->{861302742} = "湖南省长沙市";
$areanames{zh}->{861302743} = "湖南省长沙市";
$areanames{zh}->{861302744} = "湖南省湘潭市";
$areanames{zh}->{861302745} = "湖南省株洲市";
$areanames{zh}->{861302746} = "湖南省衡阳市";
$areanames{zh}->{861302747} = "湖南省岳阳市";
$areanames{zh}->{861302748} = "湖南省长沙市";
$areanames{zh}->{861302749} = "湖南省长沙市";
$areanames{zh}->{861302750} = "河南省郑州市";
$areanames{zh}->{861302751} = "河南省郑州市";
$areanames{zh}->{861302752} = "河南省郑州市";
$areanames{zh}->{861302753} = "河南省洛阳市";
$areanames{zh}->{861302754} = "河南省洛阳市";
$areanames{zh}->{861302755} = "河南省新乡市";
$areanames{zh}->{861302756} = "河南省平顶山市";
$areanames{zh}->{861302757} = "河南省平顶山市";
$areanames{zh}->{861302758} = "河南省焦作市";
$areanames{zh}->{861302759} = "河南省安阳市";
$areanames{zh}->{861302760} = "河南省郑州市";
$areanames{zh}->{861302761} = "河南省郑州市";
$areanames{zh}->{861302762} = "河南省郑州市";
$areanames{zh}->{861302763} = "河南省洛阳市";
$areanames{zh}->{861302764} = "河南省开封市";
$areanames{zh}->{861302765} = "河南省焦作市";
$areanames{zh}->{861302766} = "河南省新乡市";
$areanames{zh}->{861302767} = "河南省许昌市";
$areanames{zh}->{861302768} = "河南省漯河市";
$areanames{zh}->{861302769} = "河南省安阳市";
$areanames{zh}->{86130277} = "河南省郑州市";
$areanames{zh}->{86130278} = "贵州省贵阳市";
$areanames{zh}->{861302787} = "贵州省遵义市";
$areanames{zh}->{861302789} = "贵州省安顺市";
$areanames{zh}->{86130279} = "广东省深圳市";
$areanames{zh}->{861302800} = "山西省运城市";
$areanames{zh}->{861302801} = "山西省运城市";
$areanames{zh}->{861302802} = "山西省临汾市";
$areanames{zh}->{861302803} = "山西省临汾市";
$areanames{zh}->{861302804} = "山西省大同市";
$areanames{zh}->{861302805} = "山西省晋城市";
$areanames{zh}->{861302806} = "山西省长治市";
$areanames{zh}->{861302807} = "山西省长治市";
$areanames{zh}->{861302808} = "山西省大同市";
$areanames{zh}->{861302809} = "山西省大同市";
$areanames{zh}->{86130281} = "四川省成都市";
$areanames{zh}->{861302820} = "辽宁省辽阳市";
$areanames{zh}->{861302821} = "辽宁省阜新市";
$areanames{zh}->{861302822} = "辽宁省盘锦市";
$areanames{zh}->{861302823} = "辽宁省盘锦市";
$areanames{zh}->{861302824} = "辽宁省朝阳市";
$areanames{zh}->{861302825} = "辽宁省盘锦市";
$areanames{zh}->{861302826} = "辽宁省锦州市";
$areanames{zh}->{861302827} = "辽宁省铁岭市";
$areanames{zh}->{861302828} = "辽宁省辽阳市";
$areanames{zh}->{861302829} = "辽宁省阜新市";
$areanames{zh}->{86130283} = "重庆市";
$areanames{zh}->{861302840} = "陕西省西安市";
$areanames{zh}->{861302841} = "陕西省西安市";
$areanames{zh}->{861302842} = "陕西省西安市";
$areanames{zh}->{861302843} = "陕西省渭南市";
$areanames{zh}->{861302844} = "陕西省咸阳市";
$areanames{zh}->{861302845} = "陕西省汉中市";
$areanames{zh}->{861302846} = "陕西省汉中市";
$areanames{zh}->{861302847} = "陕西省宝鸡市";
$areanames{zh}->{861302848} = "陕西省宝鸡市";
$areanames{zh}->{861302849} = "陕西省宝鸡市";
$areanames{zh}->{861302850} = "陕西省铜川市";
$areanames{zh}->{861302851} = "陕西省西安市";
$areanames{zh}->{861302852} = "陕西省渭南市";
$areanames{zh}->{861302853} = "陕西省渭南市";
$areanames{zh}->{861302854} = "陕西省咸阳市";
$areanames{zh}->{861302855} = "陕西省咸阳市";
$areanames{zh}->{861302856} = "陕西省西安市";
$areanames{zh}->{861302857} = "陕西省延安市";
$areanames{zh}->{861302858} = "陕西省延安市";
$areanames{zh}->{861302859} = "陕西省西安市";
$areanames{zh}->{86130286} = "河北省石家庄市";
$areanames{zh}->{861302870} = "甘肃省兰州市";
$areanames{zh}->{861302871} = "甘肃省兰州市";
$areanames{zh}->{861302872} = "甘肃省白银市";
$areanames{zh}->{861302873} = "甘肃省白银市";
$areanames{zh}->{861302874} = "甘肃省白银市";
$areanames{zh}->{861302875} = "甘肃省酒泉市";
$areanames{zh}->{861302876} = "甘肃省定西市";
$areanames{zh}->{861302877} = "甘肃省临夏回族自治州";
$areanames{zh}->{861302878} = "甘肃省临夏回族自治州";
$areanames{zh}->{861302879} = "甘肃省兰州市";
$areanames{zh}->{86130288} = "广东省深圳市";
$areanames{zh}->{86130289} = "浙江省宁波市";
$areanames{zh}->{861302900} = "吉林省长春市";
$areanames{zh}->{861302901} = "吉林省长春市";
$areanames{zh}->{861302902} = "吉林省四平市";
$areanames{zh}->{861302903} = "吉林省四平市";
$areanames{zh}->{861302904} = "吉林省辽源市";
$areanames{zh}->{861302905} = "吉林省松原市";
$areanames{zh}->{861302906} = "吉林省白城市";
$areanames{zh}->{861302907} = "吉林省白山市";
$areanames{zh}->{861302908} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861302909} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861302910} = "吉林省长春市";
$areanames{zh}->{861302911} = "吉林省长春市";
$areanames{zh}->{861302912} = "吉林省长春市";
$areanames{zh}->{861302913} = "吉林省长春市";
$areanames{zh}->{861302914} = "吉林省长春市";
$areanames{zh}->{861302915} = "吉林省吉林市";
$areanames{zh}->{861302916} = "吉林省吉林市";
$areanames{zh}->{861302917} = "吉林省吉林市";
$areanames{zh}->{861302918} = "吉林省吉林市";
$areanames{zh}->{861302919} = "吉林省通化市";
$areanames{zh}->{861302920} = "辽宁省丹东市";
$areanames{zh}->{861302921} = "辽宁省丹东市";
$areanames{zh}->{861302922} = "辽宁省本溪市";
$areanames{zh}->{861302923} = "辽宁省本溪市";
$areanames{zh}->{861302924} = "辽宁省抚顺市";
$areanames{zh}->{861302925} = "辽宁省抚顺市";
$areanames{zh}->{861302926} = "辽宁省抚顺市";
$areanames{zh}->{861302927} = "辽宁省铁岭市";
$areanames{zh}->{861302928} = "辽宁省葫芦岛市";
$areanames{zh}->{861302929} = "辽宁省葫芦岛市";
$areanames{zh}->{861302930} = "辽宁省营口市";
$areanames{zh}->{861302931} = "辽宁省营口市";
$areanames{zh}->{861302932} = "辽宁省营口市";
$areanames{zh}->{861302933} = "辽宁省锦州市";
$areanames{zh}->{861302934} = "辽宁省锦州市";
$areanames{zh}->{861302935} = "辽宁省锦州市";
$areanames{zh}->{861302936} = "辽宁省鞍山市";
$areanames{zh}->{861302937} = "辽宁省鞍山市";
$areanames{zh}->{861302938} = "辽宁省鞍山市";
$areanames{zh}->{861302939} = "辽宁省鞍山市";
$areanames{zh}->{86130294} = "辽宁省大连市";
$areanames{zh}->{861302950} = "内蒙古呼和浩特市";
$areanames{zh}->{861302951} = "内蒙古呼和浩特市";
$areanames{zh}->{861302952} = "内蒙古呼和浩特市";
$areanames{zh}->{861302953} = "内蒙古乌兰察布市";
$areanames{zh}->{861302954} = "内蒙古包头市";
$areanames{zh}->{861302955} = "内蒙古包头市";
$areanames{zh}->{861302956} = "内蒙古包头市";
$areanames{zh}->{861302957} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861302958} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861302959} = "内蒙古乌海市";
$areanames{zh}->{861302960} = "新疆昌吉回族自治州";
$areanames{zh}->{861302961} = "新疆石河子市";
$areanames{zh}->{861302962} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861302963} = "新疆喀什地区";
$areanames{zh}->{861302964} = "新疆乌鲁木齐市";
$areanames{zh}->{861302965} = "新疆乌鲁木齐市";
$areanames{zh}->{861302966} = "新疆乌鲁木齐市";
$areanames{zh}->{861302967} = "新疆乌鲁木齐市";
$areanames{zh}->{861302968} = "浙江省温州市";
$areanames{zh}->{861302969} = "浙江省温州市";
$areanames{zh}->{861302970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861302974} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861302975} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861302976} = "黑龙江省鹤岗市";
$areanames{zh}->{861302977} = "黑龙江省双鸭山市";
$areanames{zh}->{861302978} = "黑龙江省佳木斯市";
$areanames{zh}->{861302979} = "黑龙江省七台河市";
$areanames{zh}->{861302980} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302981} = "黑龙江省大庆市";
$areanames{zh}->{861302982} = "黑龙江省大庆市";
$areanames{zh}->{861302983} = "黑龙江省大庆市";
$areanames{zh}->{861302984} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302985} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302986} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302987} = "黑龙江省哈尔滨市";
$areanames{zh}->{861302988} = "黑龙江省牡丹江市";
$areanames{zh}->{861302989} = "黑龙江省鸡西市";
$areanames{zh}->{861302990} = "黑龙江省大庆市";
$areanames{zh}->{861302991} = "黑龙江省绥化市";
$areanames{zh}->{861302992} = "黑龙江省绥化市";
$areanames{zh}->{861302993} = "黑龙江省黑河市";
$areanames{zh}->{861302994} = "黑龙江省黑河市";
$areanames{zh}->{861302995} = "黑龙江省牡丹江市";
$areanames{zh}->{861302996} = "黑龙江省牡丹江市";
$areanames{zh}->{861302997} = "黑龙江省佳木斯市";
$areanames{zh}->{861302998} = "黑龙江省佳木斯市";
$areanames{zh}->{861302999} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130300} = "黑龙江省哈尔滨市";
$areanames{zh}->{861303010} = "广东省韶关市";
$areanames{zh}->{861303011} = "广东省韶关市";
$areanames{zh}->{861303012} = "广东省韶关市";
$areanames{zh}->{861303013} = "广东省韶关市";
$areanames{zh}->{861303014} = "广东省韶关市";
$areanames{zh}->{861303015} = "广东省湛江市";
$areanames{zh}->{861303016} = "广东省湛江市";
$areanames{zh}->{861303017} = "广东省湛江市";
$areanames{zh}->{861303018} = "广东省湛江市";
$areanames{zh}->{861303019} = "广东省湛江市";
$areanames{zh}->{86130302} = "广东省肇庆市";
$areanames{zh}->{861303027} = "广东省云浮市";
$areanames{zh}->{861303028} = "广东省云浮市";
$areanames{zh}->{861303029} = "广东省云浮市";
$areanames{zh}->{861303030} = "河南省濮阳市";
$areanames{zh}->{861303031} = "河南省濮阳市";
$areanames{zh}->{861303032} = "河南省濮阳市";
$areanames{zh}->{861303033} = "河南省濮阳市";
$areanames{zh}->{861303034} = "河南省三门峡市";
$areanames{zh}->{861303035} = "河南省三门峡市";
$areanames{zh}->{861303036} = "河南省三门峡市";
$areanames{zh}->{861303037} = "河南省三门峡市";
$areanames{zh}->{861303038} = "河南省三门峡市";
$areanames{zh}->{861303039} = "河南省鹤壁市";
$areanames{zh}->{861303040} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861303041} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861303042} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861303043} = "内蒙古兴安盟";
$areanames{zh}->{861303044} = "内蒙古兴安盟";
$areanames{zh}->{861303045} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861303046} = "内蒙古包头市";
$areanames{zh}->{861303047} = "内蒙古包头市";
$areanames{zh}->{861303048} = "内蒙古包头市";
$areanames{zh}->{861303049} = "内蒙古包头市";
$areanames{zh}->{861303050} = "江西省景德镇市";
$areanames{zh}->{861303051} = "江西省景德镇市";
$areanames{zh}->{861303052} = "江西省吉安市";
$areanames{zh}->{861303053} = "江西省吉安市";
$areanames{zh}->{861303054} = "江西省吉安市";
$areanames{zh}->{861303055} = "江西省新余市";
$areanames{zh}->{861303056} = "江西省萍乡市";
$areanames{zh}->{861303057} = "江西省抚州市";
$areanames{zh}->{861303058} = "江西省抚州市";
$areanames{zh}->{861303059} = "江西省抚州市";
$areanames{zh}->{861303060} = "安徽省淮北市";
$areanames{zh}->{861303061} = "安徽省淮北市";
$areanames{zh}->{861303062} = "安徽省池州市";
$areanames{zh}->{861303063} = "安徽省滁州市";
$areanames{zh}->{861303064} = "安徽省亳州市";
$areanames{zh}->{861303065} = "安徽省亳州市";
$areanames{zh}->{861303066} = "安徽省阜阳市";
$areanames{zh}->{861303067} = "安徽省阜阳市";
$areanames{zh}->{861303068} = "安徽省阜阳市";
$areanames{zh}->{861303069} = "安徽省亳州市";
$areanames{zh}->{861303070} = "辽宁省抚顺市";
$areanames{zh}->{861303071} = "辽宁省抚顺市";
$areanames{zh}->{861303072} = "辽宁省本溪市";
$areanames{zh}->{861303073} = "辽宁省本溪市";
$areanames{zh}->{861303074} = "辽宁省丹东市";
$areanames{zh}->{861303075} = "辽宁省丹东市";
$areanames{zh}->{861303076} = "辽宁省盘锦市";
$areanames{zh}->{861303077} = "辽宁省盘锦市";
$areanames{zh}->{861303078} = "辽宁省铁岭市";
$areanames{zh}->{861303079} = "辽宁省铁岭市";
$areanames{zh}->{861303080} = "福建省三明市";
$areanames{zh}->{861303081} = "福建省莆田市";
$areanames{zh}->{861303082} = "福建省莆田市";
$areanames{zh}->{861303083} = "福建省莆田市";
$areanames{zh}->{861303084} = "福建省厦门市";
$areanames{zh}->{861303085} = "福建省莆田市";
$areanames{zh}->{861303086} = "福建省莆田市";
$areanames{zh}->{861303087} = "福建省厦门市";
$areanames{zh}->{861303088} = "福建省厦门市";
$areanames{zh}->{861303089} = "福建省厦门市";
$areanames{zh}->{86130309} = "福建省宁德市";
$areanames{zh}->{861303094} = "福建省泉州市";
$areanames{zh}->{861303097} = "福建省泉州市";
$areanames{zh}->{861303098} = "福建省泉州市";
$areanames{zh}->{861303099} = "福建省泉州市";
$areanames{zh}->{86130310} = "北京市";
$areanames{zh}->{86130311} = "北京市";
$areanames{zh}->{861303120} = "新疆吐鲁番地区";
$areanames{zh}->{861303121} = "新疆哈密地区";
$areanames{zh}->{861303122} = "新疆哈密地区";
$areanames{zh}->{861303123} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861303124} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861303125} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861303126} = "新疆阿克苏地区";
$areanames{zh}->{861303127} = "新疆阿克苏地区";
$areanames{zh}->{861303128} = "新疆喀什地区";
$areanames{zh}->{861303129} = "新疆喀什地区";
$areanames{zh}->{861303130} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861303131} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861303132} = "新疆石河子市";
$areanames{zh}->{861303133} = "新疆石河子市";
$areanames{zh}->{861303134} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861303135} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861303136} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861303137} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861303138} = "新疆克拉玛依市";
$areanames{zh}->{861303139} = "新疆克拉玛依市";
$areanames{zh}->{861303140} = "河北省承德市";
$areanames{zh}->{861303141} = "河北省承德市";
$areanames{zh}->{861303142} = "河北省承德市";
$areanames{zh}->{861303143} = "河北省秦皇岛市";
$areanames{zh}->{861303144} = "河北省石家庄市";
$areanames{zh}->{861303145} = "河北省邯郸市";
$areanames{zh}->{861303146} = "河北省邯郸市";
$areanames{zh}->{861303147} = "河北省邯郸市";
$areanames{zh}->{861303148} = "河北省廊坊市";
$areanames{zh}->{861303149} = "河北省廊坊市";
$areanames{zh}->{86130315} = "河北省唐山市";
$areanames{zh}->{861303159} = "河北省沧州市";
$areanames{zh}->{86130316} = "山东省烟台市";
$areanames{zh}->{861303166} = "山东省潍坊市";
$areanames{zh}->{861303167} = "山东省潍坊市";
$areanames{zh}->{861303168} = "山东省潍坊市";
$areanames{zh}->{861303169} = "山东省潍坊市";
$areanames{zh}->{861303170} = "山东省济南市";
$areanames{zh}->{861303171} = "山东省济南市";
$areanames{zh}->{861303172} = "山东省济南市";
$areanames{zh}->{861303173} = "山东省济南市";
$areanames{zh}->{861303174} = "山东省济南市";
$areanames{zh}->{861303175} = "山东省莱芜市";
$areanames{zh}->{861303176} = "山东省莱芜市";
$areanames{zh}->{861303177} = "山东省淄博市";
$areanames{zh}->{861303178} = "山东省淄博市";
$areanames{zh}->{861303179} = "山东省淄博市";
$areanames{zh}->{861303180} = "河北省廊坊市";
$areanames{zh}->{861303181} = "河北省廊坊市";
$areanames{zh}->{861303182} = "河北省衡水市";
$areanames{zh}->{861303183} = "河北省衡水市";
$areanames{zh}->{861303184} = "河北省衡水市";
$areanames{zh}->{861303185} = "河北省衡水市";
$areanames{zh}->{861303186} = "河北省秦皇岛市";
$areanames{zh}->{861303187} = "河北省秦皇岛市";
$areanames{zh}->{861303188} = "河北省秦皇岛市";
$areanames{zh}->{861303189} = "河北省沧州市";
$areanames{zh}->{861303190} = "河北省邢台市";
$areanames{zh}->{861303191} = "河北省邢台市";
$areanames{zh}->{861303192} = "河北省邢台市";
$areanames{zh}->{861303193} = "河北省张家口市";
$areanames{zh}->{861303194} = "河北省张家口市";
$areanames{zh}->{861303195} = "河北省张家口市";
$areanames{zh}->{861303196} = "河北省张家口市";
$areanames{zh}->{861303197} = "河北省张家口市";
$areanames{zh}->{861303198} = "河北省邯郸市";
$areanames{zh}->{861303199} = "河北省邯郸市";
$areanames{zh}->{86130320} = "河北省保定市";
$areanames{zh}->{861303209} = "河北省承德市";
$areanames{zh}->{86130321} = "上海市";
$areanames{zh}->{86130322} = "天津市";
$areanames{zh}->{86130323} = "重庆市";
$areanames{zh}->{86130324} = "辽宁省沈阳市";
$areanames{zh}->{861303250} = "江苏省常州市";
$areanames{zh}->{861303251} = "江苏省常州市";
$areanames{zh}->{861303252} = "江苏省苏州市";
$areanames{zh}->{861303253} = "江苏省苏州市";
$areanames{zh}->{861303254} = "江苏省南京市";
$areanames{zh}->{861303255} = "江苏省南京市";
$areanames{zh}->{861303256} = "江苏省扬州市";
$areanames{zh}->{861303257} = "江苏省扬州市";
$areanames{zh}->{861303258} = "江苏省宿迁市";
$areanames{zh}->{861303259} = "江苏省盐城市";
$areanames{zh}->{86130326} = "河北省石家庄市";
$areanames{zh}->{861303270} = "湖北省宜昌市";
$areanames{zh}->{861303271} = "湖北省宜昌市";
$areanames{zh}->{861303272} = "湖北省宜昌市";
$areanames{zh}->{861303273} = "湖北省宜昌市";
$areanames{zh}->{861303274} = "湖北省宜昌市";
$areanames{zh}->{861303275} = "湖北省荆门市";
$areanames{zh}->{861303276} = "湖北省荆门市";
$areanames{zh}->{861303277} = "湖北省荆门市";
$areanames{zh}->{861303278} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861303279} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{86130328} = "四川省成都市";
$areanames{zh}->{86130329} = "陕西省西安市";
$areanames{zh}->{861303300} = "安徽省合肥市";
$areanames{zh}->{861303301} = "安徽省蚌埠市";
$areanames{zh}->{861303302} = "安徽省蚌埠市";
$areanames{zh}->{861303303} = "安徽省芜湖市";
$areanames{zh}->{861303304} = "安徽省芜湖市";
$areanames{zh}->{861303305} = "安徽省合肥市";
$areanames{zh}->{861303306} = "安徽省合肥市";
$areanames{zh}->{861303307} = "安徽省淮南市";
$areanames{zh}->{861303308} = "安徽省合肥市";
$areanames{zh}->{861303309} = "安徽省合肥市";
$areanames{zh}->{861303310} = "安徽省马鞍山市";
$areanames{zh}->{861303311} = "安徽省马鞍山市";
$areanames{zh}->{861303312} = "安徽省黄山市";
$areanames{zh}->{861303313} = "安徽省宣城市";
$areanames{zh}->{861303314} = "安徽省宣城市";
$areanames{zh}->{861303315} = "安徽省铜陵市";
$areanames{zh}->{861303316} = "安徽省安庆市";
$areanames{zh}->{861303317} = "安徽省安庆市";
$areanames{zh}->{861303318} = "安徽省安庆市";
$areanames{zh}->{861303319} = "安徽省安庆市";
$areanames{zh}->{86130332} = "江西省赣州市";
$areanames{zh}->{861303329} = "江西省吉安市";
$areanames{zh}->{86130333} = "云南省昆明市";
$areanames{zh}->{861303330} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861303331} = "云南省普洱市";
$areanames{zh}->{861303332} = "云南省保山市";
$areanames{zh}->{861303340} = "山西省忻州市";
$areanames{zh}->{861303341} = "山西省运城市";
$areanames{zh}->{861303342} = "山西省临汾市";
$areanames{zh}->{861303343} = "山西省晋中市";
$areanames{zh}->{861303344} = "山西省运城市";
$areanames{zh}->{861303345} = "山西省朔州市";
$areanames{zh}->{861303346} = "山西省长治市";
$areanames{zh}->{861303347} = "山西省吕梁市";
$areanames{zh}->{861303348} = "山西省太原市";
$areanames{zh}->{861303349} = "山西省大同市";
$areanames{zh}->{861303350} = "江苏省无锡市";
$areanames{zh}->{861303351} = "江苏省无锡市";
$areanames{zh}->{861303352} = "江苏省连云港市";
$areanames{zh}->{861303353} = "江苏省徐州市";
$areanames{zh}->{861303354} = "江苏省徐州市";
$areanames{zh}->{861303355} = "江苏省淮安市";
$areanames{zh}->{861303356} = "江苏省南通市";
$areanames{zh}->{861303357} = "江苏省南通市";
$areanames{zh}->{861303358} = "江苏省泰州市";
$areanames{zh}->{861303359} = "江苏省镇江市";
$areanames{zh}->{861303360} = "浙江省杭州市";
$areanames{zh}->{861303361} = "浙江省杭州市";
$areanames{zh}->{861303362} = "浙江省温州市";
$areanames{zh}->{861303363} = "浙江省温州市";
$areanames{zh}->{861303364} = "浙江省台州市";
$areanames{zh}->{861303365} = "浙江省台州市";
$areanames{zh}->{861303366} = "浙江省金华市";
$areanames{zh}->{861303367} = "浙江省嘉兴市";
$areanames{zh}->{861303368} = "浙江省丽水市";
$areanames{zh}->{861303369} = "浙江省绍兴市";
$areanames{zh}->{86130337} = "河南省信阳市";
$areanames{zh}->{86130338} = "河南省驻马店市";
$areanames{zh}->{861303387} = "河南省鹤壁市";
$areanames{zh}->{861303388} = "河南省鹤壁市";
$areanames{zh}->{861303389} = "河南省鹤壁市";
$areanames{zh}->{86130339} = "河南省周口市";
$areanames{zh}->{861303398} = "河南省濮阳市";
$areanames{zh}->{861303399} = "河南省濮阳市";
$areanames{zh}->{861303400} = "安徽省宿州市";
$areanames{zh}->{861303401} = "安徽省宿州市";
$areanames{zh}->{861303402} = "安徽省六安市";
$areanames{zh}->{861303403} = "安徽省六安市";
$areanames{zh}->{861303404} = "安徽省合肥市";
$areanames{zh}->{861303405} = "安徽省合肥市";
$areanames{zh}->{861303406} = "安徽省阜阳市";
$areanames{zh}->{861303407} = "安徽省阜阳市";
$areanames{zh}->{861303408} = "安徽省阜阳市";
$areanames{zh}->{861303409} = "安徽省阜阳市";
$areanames{zh}->{861303410} = "甘肃省庆阳市";
$areanames{zh}->{861303411} = "甘肃省天水市";
$areanames{zh}->{861303412} = "甘肃省天水市";
$areanames{zh}->{861303413} = "甘肃省临夏回族自治州";
$areanames{zh}->{861303414} = "甘肃省定西市";
$areanames{zh}->{861303415} = "甘肃省白银市";
$areanames{zh}->{861303416} = "甘肃省白银市";
$areanames{zh}->{861303417} = "甘肃省平凉市";
$areanames{zh}->{861303418} = "甘肃省平凉市";
$areanames{zh}->{861303419} = "甘肃省庆阳市";
$areanames{zh}->{861303420} = "浙江省杭州市";
$areanames{zh}->{861303421} = "浙江省杭州市";
$areanames{zh}->{861303422} = "浙江省温州市";
$areanames{zh}->{861303423} = "浙江省温州市";
$areanames{zh}->{861303424} = "浙江省丽水市";
$areanames{zh}->{861303425} = "浙江省金华市";
$areanames{zh}->{861303426} = "浙江省绍兴市";
$areanames{zh}->{861303427} = "浙江省嘉兴市";
$areanames{zh}->{861303428} = "浙江省台州市";
$areanames{zh}->{861303429} = "浙江省台州市";
$areanames{zh}->{86130343} = "天津市";
$areanames{zh}->{861303440} = "湖北省黄石市";
$areanames{zh}->{861303441} = "湖北省黄石市";
$areanames{zh}->{861303442} = "湖北省黄石市";
$areanames{zh}->{861303443} = "湖北省黄石市";
$areanames{zh}->{861303444} = "湖北省鄂州市";
$areanames{zh}->{861303445} = "湖北省鄂州市";
$areanames{zh}->{861303446} = "湖北省黄冈市";
$areanames{zh}->{861303447} = "湖北省黄冈市";
$areanames{zh}->{861303448} = "湖北省黄冈市";
$areanames{zh}->{861303449} = "湖北省黄冈市";
$areanames{zh}->{861303450} = "山东省淄博市";
$areanames{zh}->{861303451} = "山东省淄博市";
$areanames{zh}->{861303452} = "山东省滨州市";
$areanames{zh}->{861303453} = "山东省聊城市";
$areanames{zh}->{861303454} = "山东省聊城市";
$areanames{zh}->{861303455} = "山东省菏泽市";
$areanames{zh}->{861303456} = "山东省威海市";
$areanames{zh}->{861303457} = "山东省威海市";
$areanames{zh}->{861303458} = "山东省威海市";
$areanames{zh}->{861303459} = "山东省威海市";
$areanames{zh}->{86130346} = "浙江省宁波市";
$areanames{zh}->{861303470} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861303471} = "内蒙古呼和浩特市";
$areanames{zh}->{861303472} = "内蒙古通辽市";
$areanames{zh}->{861303473} = "内蒙古乌海市";
$areanames{zh}->{861303474} = "内蒙古乌兰察布市";
$areanames{zh}->{861303475} = "内蒙古通辽市";
$areanames{zh}->{861303476} = "内蒙古赤峰市";
$areanames{zh}->{861303477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861303478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861303479} = "内蒙古赤峰市";
$areanames{zh}->{861303480} = "湖南省娄底市";
$areanames{zh}->{861303481} = "湖南省娄底市";
$areanames{zh}->{861303482} = "湖南省娄底市";
$areanames{zh}->{861303483} = "湖南省娄底市";
$areanames{zh}->{861303484} = "湖南省娄底市";
$areanames{zh}->{861303485} = "湖南省怀化市";
$areanames{zh}->{861303486} = "湖南省怀化市";
$areanames{zh}->{861303487} = "湖南省怀化市";
$areanames{zh}->{861303488} = "湖南省怀化市";
$areanames{zh}->{861303489} = "湖南省怀化市";
$areanames{zh}->{86130349} = "海南省海口市";
$areanames{zh}->{861303500} = "安徽省宿州市";
$areanames{zh}->{861303501} = "安徽省蚌埠市";
$areanames{zh}->{861303502} = "安徽省蚌埠市";
$areanames{zh}->{861303503} = "安徽省滁州市";
$areanames{zh}->{861303504} = "安徽省芜湖市";
$areanames{zh}->{861303505} = "安徽省合肥市";
$areanames{zh}->{861303506} = "安徽省合肥市";
$areanames{zh}->{861303507} = "安徽省阜阳市";
$areanames{zh}->{861303508} = "安徽省阜阳市";
$areanames{zh}->{861303509} = "安徽省合肥市";
$areanames{zh}->{861303510} = "湖北省武汉市";
$areanames{zh}->{861303511} = "湖北省武汉市";
$areanames{zh}->{861303512} = "湖北省武汉市";
$areanames{zh}->{861303513} = "湖北省武汉市";
$areanames{zh}->{861303514} = "湖北省武汉市";
$areanames{zh}->{861303515} = "湖北省孝感市";
$areanames{zh}->{861303516} = "湖北省孝感市";
$areanames{zh}->{861303517} = "湖北省孝感市";
$areanames{zh}->{861303518} = "湖北省孝感市";
$areanames{zh}->{861303519} = "湖北省随州市";
$areanames{zh}->{861303520} = "湖北省襄樊市";
$areanames{zh}->{861303521} = "湖北省襄樊市";
$areanames{zh}->{861303522} = "湖北省襄樊市";
$areanames{zh}->{861303523} = "湖北省襄樊市";
$areanames{zh}->{861303524} = "湖北省襄樊市";
$areanames{zh}->{861303525} = "湖北省十堰市";
$areanames{zh}->{861303526} = "湖北省十堰市";
$areanames{zh}->{861303527} = "湖北省十堰市";
$areanames{zh}->{861303528} = "湖北省十堰市";
$areanames{zh}->{861303529} = "湖北省十堰市";
$areanames{zh}->{86130353} = "湖北省武汉市";
$areanames{zh}->{861303530} = "湖北省荆州市";
$areanames{zh}->{861303531} = "湖北省荆州市";
$areanames{zh}->{861303532} = "湖北省荆州市";
$areanames{zh}->{861303533} = "湖北省荆州市";
$areanames{zh}->{861303540} = "安徽省合肥市";
$areanames{zh}->{861303541} = "安徽省阜阳市";
$areanames{zh}->{861303542} = "安徽省六安市";
$areanames{zh}->{861303543} = "安徽省黄山市";
$areanames{zh}->{861303544} = "安徽省马鞍山市";
$areanames{zh}->{861303545} = "安徽省滁州市";
$areanames{zh}->{861303546} = "安徽省淮北市";
$areanames{zh}->{861303547} = "安徽省淮南市";
$areanames{zh}->{861303548} = "安徽省铜陵市";
$areanames{zh}->{861303549} = "安徽省池州市";
$areanames{zh}->{861303550} = "贵州省遵义市";
$areanames{zh}->{861303551} = "贵州省遵义市";
$areanames{zh}->{861303552} = "贵州省遵义市";
$areanames{zh}->{861303553} = "贵州省遵义市";
$areanames{zh}->{861303554} = "贵州省毕节地区";
$areanames{zh}->{861303555} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861303556} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861303557} = "贵州省铜仁地区";
$areanames{zh}->{861303558} = "贵州省安顺市";
$areanames{zh}->{861303559} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86130356} = "四川省绵阳市";
$areanames{zh}->{861303560} = "四川省自贡市";
$areanames{zh}->{861303561} = "四川省广元市";
$areanames{zh}->{861303562} = "四川省广元市";
$areanames{zh}->{86130357} = "广东省梅州市";
$areanames{zh}->{861303570} = "广东省河源市";
$areanames{zh}->{861303571} = "广东省河源市";
$areanames{zh}->{861303572} = "广东省河源市";
$areanames{zh}->{861303573} = "广东省河源市";
$areanames{zh}->{86130358} = "广东省茂名市";
$areanames{zh}->{861303586} = "广东省阳江市";
$areanames{zh}->{861303587} = "广东省阳江市";
$areanames{zh}->{861303588} = "河北省石家庄市";
$areanames{zh}->{861303589} = "广东省阳江市";
$areanames{zh}->{861303590} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861303591} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861303592} = "云南省临沧市";
$areanames{zh}->{861303593} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861303594} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861303595} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861303596} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861303597} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861303598} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861303599} = "云南省西双版纳傣族自治州";
$areanames{zh}->{86130360} = "海南省海口市";
$areanames{zh}->{86130361} = "湖北省武汉市";
$areanames{zh}->{861303617} = "湖北省咸宁市";
$areanames{zh}->{861303618} = "湖北省咸宁市";
$areanames{zh}->{861303619} = "湖北省咸宁市";
$areanames{zh}->{861303620} = "江西省南昌市";
$areanames{zh}->{861303621} = "江西省南昌市";
$areanames{zh}->{861303622} = "江西省鹰潭市";
$areanames{zh}->{861303623} = "江西省鹰潭市";
$areanames{zh}->{861303624} = "江西省上饶市";
$areanames{zh}->{861303625} = "江西省上饶市";
$areanames{zh}->{861303626} = "江西省宜春市";
$areanames{zh}->{861303627} = "江西省宜春市";
$areanames{zh}->{861303628} = "江西省新余市";
$areanames{zh}->{861303629} = "江西省萍乡市";
$areanames{zh}->{86130363} = "重庆市";
$areanames{zh}->{861303640} = "四川省自贡市";
$areanames{zh}->{861303641} = "四川省自贡市";
$areanames{zh}->{861303642} = "四川省泸州市";
$areanames{zh}->{861303643} = "四川省泸州市";
$areanames{zh}->{861303644} = "四川省眉山市";
$areanames{zh}->{861303645} = "四川省乐山市";
$areanames{zh}->{861303646} = "四川省遂宁市";
$areanames{zh}->{861303647} = "四川省达州市";
$areanames{zh}->{861303648} = "四川省宜宾市";
$areanames{zh}->{861303649} = "四川省宜宾市";
$areanames{zh}->{861303650} = "四川省宜宾市";
$areanames{zh}->{861303651} = "四川省宜宾市";
$areanames{zh}->{861303652} = "四川省宜宾市";
$areanames{zh}->{861303653} = "四川省宜宾市";
$areanames{zh}->{861303654} = "四川省泸州市";
$areanames{zh}->{861303655} = "四川省泸州市";
$areanames{zh}->{861303656} = "四川省南充市";
$areanames{zh}->{861303657} = "四川省乐山市";
$areanames{zh}->{861303658} = "四川省乐山市";
$areanames{zh}->{861303659} = "四川省乐山市";
$areanames{zh}->{861303660} = "四川省眉山市";
$areanames{zh}->{861303661} = "四川省眉山市";
$areanames{zh}->{861303662} = "四川省达州市";
$areanames{zh}->{861303663} = "四川省达州市";
$areanames{zh}->{861303664} = "四川省达州市";
$areanames{zh}->{861303665} = "四川省达州市";
$areanames{zh}->{861303666} = "四川省成都市";
$areanames{zh}->{861303667} = "四川省成都市";
$areanames{zh}->{861303668} = "四川省成都市";
$areanames{zh}->{861303669} = "四川省成都市";
$areanames{zh}->{861303670} = "湖南省邵阳市";
$areanames{zh}->{861303671} = "湖南省邵阳市";
$areanames{zh}->{861303672} = "湖南省邵阳市";
$areanames{zh}->{861303673} = "湖南省邵阳市";
$areanames{zh}->{861303674} = "湖南省邵阳市";
$areanames{zh}->{861303675} = "湖南省张家界市";
$areanames{zh}->{861303676} = "湖南省张家界市";
$areanames{zh}->{861303677} = "湖南省永州市";
$areanames{zh}->{861303678} = "湖南省长沙市";
$areanames{zh}->{861303679} = "湖南省长沙市";
$areanames{zh}->{861303680} = "广西贵港市";
$areanames{zh}->{861303681} = "广西南宁市";
$areanames{zh}->{861303682} = "广西柳州市";
$areanames{zh}->{861303683} = "广西桂林市";
$areanames{zh}->{861303684} = "广西梧州市";
$areanames{zh}->{861303685} = "广西贵港市";
$areanames{zh}->{861303686} = "广西南宁市";
$areanames{zh}->{861303687} = "广西贺州市";
$areanames{zh}->{861303688} = "广西南宁市";
$areanames{zh}->{861303689} = "广西北海市";
$areanames{zh}->{861303690} = "广西防城港市";
$areanames{zh}->{861303691} = "广西南宁市";
$areanames{zh}->{861303692} = "广西柳州市";
$areanames{zh}->{861303693} = "广西桂林市";
$areanames{zh}->{861303694} = "广西梧州市";
$areanames{zh}->{861303695} = "广西玉林市";
$areanames{zh}->{861303696} = "广西百色市";
$areanames{zh}->{861303697} = "广西钦州市";
$areanames{zh}->{861303698} = "广西河池市";
$areanames{zh}->{861303699} = "广西北海市";
$areanames{zh}->{861303700} = "山西省忻州市";
$areanames{zh}->{861303701} = "山西省忻州市";
$areanames{zh}->{861303702} = "山西省忻州市";
$areanames{zh}->{861303703} = "山西省朔州市";
$areanames{zh}->{861303704} = "山西省朔州市";
$areanames{zh}->{861303705} = "山西省阳泉市";
$areanames{zh}->{861303706} = "山西省阳泉市";
$areanames{zh}->{861303707} = "山西省吕梁市";
$areanames{zh}->{861303708} = "山西省吕梁市";
$areanames{zh}->{861303709} = "山西省吕梁市";
$areanames{zh}->{86130371} = "湖北省武汉市";
$areanames{zh}->{86130372} = "江西省南昌市";
$areanames{zh}->{861303725} = "江西省九江市";
$areanames{zh}->{861303726} = "江西省九江市";
$areanames{zh}->{861303727} = "江西省九江市";
$areanames{zh}->{861303729} = "江西省九江市";
$areanames{zh}->{861303730} = "湖南省岳阳市";
$areanames{zh}->{861303731} = "湖南省长沙市";
$areanames{zh}->{861303732} = "湖南省湘潭市";
$areanames{zh}->{861303733} = "湖南省株洲市";
$areanames{zh}->{861303734} = "湖南省衡阳市";
$areanames{zh}->{861303735} = "湖南省郴州市";
$areanames{zh}->{861303736} = "湖南省常德市";
$areanames{zh}->{861303737} = "湖南省益阳市";
$areanames{zh}->{861303738} = "湖南省娄底市";
$areanames{zh}->{861303739} = "湖南省邵阳市";
$areanames{zh}->{861303740} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861303741} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861303742} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861303743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861303744} = "湖南省张家界市";
$areanames{zh}->{861303745} = "湖南省怀化市";
$areanames{zh}->{861303746} = "湖南省永州市";
$areanames{zh}->{861303747} = "湖南省永州市";
$areanames{zh}->{861303748} = "湖南省永州市";
$areanames{zh}->{861303749} = "湖南省永州市";
$areanames{zh}->{86130375} = "河南省商丘市";
$areanames{zh}->{86130376} = "河南省南阳市";
$areanames{zh}->{86130377} = "四川省凉山彝族自治州";
$areanames{zh}->{861303770} = "四川省攀枝花市";
$areanames{zh}->{861303771} = "四川省攀枝花市";
$areanames{zh}->{861303772} = "四川省攀枝花市";
$areanames{zh}->{861303773} = "四川省攀枝花市";
$areanames{zh}->{86130378} = "贵州省贵阳市";
$areanames{zh}->{861303790} = "宁夏石嘴山市";
$areanames{zh}->{861303791} = "宁夏石嘴山市";
$areanames{zh}->{861303792} = "宁夏吴忠市";
$areanames{zh}->{861303793} = "宁夏吴忠市";
$areanames{zh}->{861303794} = "宁夏吴忠市";
$areanames{zh}->{861303795} = "宁夏固原市";
$areanames{zh}->{861303796} = "宁夏银川市";
$areanames{zh}->{861303797} = "宁夏银川市";
$areanames{zh}->{861303798} = "宁夏银川市";
$areanames{zh}->{861303799} = "宁夏银川市";
$areanames{zh}->{861303800} = "山西省太原市";
$areanames{zh}->{861303801} = "山西省运城市";
$areanames{zh}->{861303802} = "山西省临汾市";
$areanames{zh}->{861303803} = "山西省晋中市";
$areanames{zh}->{861303804} = "山西省运城市";
$areanames{zh}->{861303805} = "山西省晋城市";
$areanames{zh}->{861303806} = "山西省长治市";
$areanames{zh}->{861303807} = "山西省阳泉市";
$areanames{zh}->{861303808} = "山西省太原市";
$areanames{zh}->{861303809} = "山西省大同市";
$areanames{zh}->{861303810} = "四川省自贡市";
$areanames{zh}->{861303811} = "四川省泸州市";
$areanames{zh}->{861303812} = "四川省乐山市";
$areanames{zh}->{861303813} = "四川省乐山市";
$areanames{zh}->{861303814} = "四川省资阳市";
$areanames{zh}->{861303815} = "四川省资阳市";
$areanames{zh}->{861303816} = "四川省资阳市";
$areanames{zh}->{861303817} = "四川省内江市";
$areanames{zh}->{861303818} = "四川省内江市";
$areanames{zh}->{861303819} = "四川省内江市";
$areanames{zh}->{86130382} = "四川省德阳市";
$areanames{zh}->{861303820} = "四川省南充市";
$areanames{zh}->{861303821} = "四川省南充市";
$areanames{zh}->{861303822} = "四川省遂宁市";
$areanames{zh}->{861303823} = "四川省宜宾市";
$areanames{zh}->{86130383} = "重庆市";
$areanames{zh}->{861303840} = "陕西省渭南市";
$areanames{zh}->{861303841} = "陕西省渭南市";
$areanames{zh}->{861303842} = "陕西省渭南市";
$areanames{zh}->{861303843} = "陕西省渭南市";
$areanames{zh}->{861303844} = "陕西省延安市";
$areanames{zh}->{861303845} = "陕西省汉中市";
$areanames{zh}->{861303846} = "陕西省汉中市";
$areanames{zh}->{861303847} = "陕西省汉中市";
$areanames{zh}->{861303848} = "陕西省宝鸡市";
$areanames{zh}->{861303849} = "陕西省宝鸡市";
$areanames{zh}->{861303850} = "陕西省铜川市";
$areanames{zh}->{861303851} = "陕西省商洛市";
$areanames{zh}->{861303852} = "陕西省商洛市";
$areanames{zh}->{861303853} = "陕西省商洛市";
$areanames{zh}->{861303854} = "陕西省咸阳市";
$areanames{zh}->{861303855} = "陕西省咸阳市";
$areanames{zh}->{861303856} = "陕西省延安市";
$areanames{zh}->{861303857} = "陕西省延安市";
$areanames{zh}->{861303858} = "陕西省西安市";
$areanames{zh}->{861303859} = "陕西省西安市";
$areanames{zh}->{861303860} = "云南省迪庆藏族自治州";
$areanames{zh}->{861303861} = "云南省丽江市";
$areanames{zh}->{861303862} = "云南省大理白族自治州";
$areanames{zh}->{861303863} = "云南省昭通市";
$areanames{zh}->{861303864} = "云南省昭通市";
$areanames{zh}->{861303865} = "云南省玉溪市";
$areanames{zh}->{861303866} = "云南省玉溪市";
$areanames{zh}->{861303867} = "云南省曲靖市";
$areanames{zh}->{861303868} = "云南省曲靖市";
$areanames{zh}->{861303869} = "云南省楚雄彝族自治州";
$areanames{zh}->{86130387} = "甘肃省兰州市";
$areanames{zh}->{86130388} = "广东省东莞市";
$areanames{zh}->{86130389} = "陕西省榆林市";
$areanames{zh}->{861303890} = "陕西省安康市";
$areanames{zh}->{861303891} = "陕西省安康市";
$areanames{zh}->{861303892} = "陕西省安康市";
$areanames{zh}->{861303893} = "陕西省西安市";
$areanames{zh}->{861303900} = "吉林省长春市";
$areanames{zh}->{861303901} = "吉林省长春市";
$areanames{zh}->{861303902} = "吉林省四平市";
$areanames{zh}->{861303903} = "吉林省四平市";
$areanames{zh}->{861303904} = "吉林省长春市";
$areanames{zh}->{861303905} = "吉林省松原市";
$areanames{zh}->{861303906} = "吉林省白城市";
$areanames{zh}->{861303907} = "吉林省白山市";
$areanames{zh}->{861303908} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861303909} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861303910} = "吉林省长春市";
$areanames{zh}->{861303911} = "吉林省长春市";
$areanames{zh}->{861303912} = "吉林省长春市";
$areanames{zh}->{861303913} = "吉林省长春市";
$areanames{zh}->{861303914} = "吉林省长春市";
$areanames{zh}->{861303915} = "吉林省吉林市";
$areanames{zh}->{861303916} = "吉林省吉林市";
$areanames{zh}->{861303917} = "吉林省吉林市";
$areanames{zh}->{861303918} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861303919} = "吉林省通化市";
$areanames{zh}->{861303920} = "吉林省长春市";
$areanames{zh}->{861303921} = "吉林省长春市";
$areanames{zh}->{861303922} = "吉林省长春市";
$areanames{zh}->{861303923} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861303924} = "吉林省吉林市";
$areanames{zh}->{861303925} = "吉林省吉林市";
$areanames{zh}->{861303926} = "吉林省吉林市";
$areanames{zh}->{861303927} = "吉林省吉林市";
$areanames{zh}->{861303928} = "吉林省辽源市";
$areanames{zh}->{861303929} = "吉林省通化市";
$areanames{zh}->{861303930} = "吉林省长春市";
$areanames{zh}->{861303931} = "吉林省长春市";
$areanames{zh}->{861303932} = "吉林省长春市";
$areanames{zh}->{861303933} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861303934} = "吉林省长春市";
$areanames{zh}->{861303935} = "吉林省松原市";
$areanames{zh}->{861303936} = "吉林省白城市";
$areanames{zh}->{861303937} = "吉林省白城市";
$areanames{zh}->{861303938} = "吉林省白山市";
$areanames{zh}->{861303939} = "吉林省白山市";
$areanames{zh}->{86130394} = "新疆乌鲁木齐市";
$areanames{zh}->{861303940} = "新疆昌吉回族自治州";
$areanames{zh}->{861303941} = "新疆昌吉回族自治州";
$areanames{zh}->{861303942} = "新疆昌吉回族自治州";
$areanames{zh}->{861303950} = "内蒙古呼和浩特市";
$areanames{zh}->{861303951} = "内蒙古呼和浩特市";
$areanames{zh}->{861303952} = "内蒙古呼和浩特市";
$areanames{zh}->{861303953} = "内蒙古通辽市";
$areanames{zh}->{861303954} = "内蒙古通辽市";
$areanames{zh}->{861303955} = "内蒙古包头市";
$areanames{zh}->{861303956} = "内蒙古包头市";
$areanames{zh}->{861303957} = "内蒙古包头市";
$areanames{zh}->{861303958} = "内蒙古包头市";
$areanames{zh}->{861303959} = "内蒙古赤峰市";
$areanames{zh}->{86130396} = "黑龙江省佳木斯市";
$areanames{zh}->{861303966} = "黑龙江省伊春市";
$areanames{zh}->{861303967} = "黑龙江省伊春市";
$areanames{zh}->{861303968} = "黑龙江省伊春市";
$areanames{zh}->{861303969} = "黑龙江省伊春市";
$areanames{zh}->{861303970} = "黑龙江省牡丹江市";
$areanames{zh}->{861303971} = "黑龙江省牡丹江市";
$areanames{zh}->{861303972} = "黑龙江省牡丹江市";
$areanames{zh}->{861303973} = "黑龙江省鹤岗市";
$areanames{zh}->{861303974} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861303975} = "黑龙江省双鸭山市";
$areanames{zh}->{861303976} = "黑龙江省黑河市";
$areanames{zh}->{861303977} = "黑龙江省黑河市";
$areanames{zh}->{861303978} = "黑龙江省黑河市";
$areanames{zh}->{861303979} = "黑龙江省七台河市";
$areanames{zh}->{86130398} = "黑龙江省大庆市";
$areanames{zh}->{861303989} = "黑龙江省鸡西市";
$areanames{zh}->{861303990} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861303991} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861303992} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861303993} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861303994} = "黑龙江省绥化市";
$areanames{zh}->{861303995} = "黑龙江省绥化市";
$areanames{zh}->{861303996} = "黑龙江省哈尔滨市";
$areanames{zh}->{861303997} = "黑龙江省哈尔滨市";
$areanames{zh}->{861303998} = "黑龙江省哈尔滨市";
$areanames{zh}->{861303999} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130400} = "河北省唐山市";
$areanames{zh}->{86130401} = "江苏省泰州市";
$areanames{zh}->{861304019} = "江苏省淮安市";
$areanames{zh}->{86130402} = "江苏省扬州市";
$areanames{zh}->{861304029} = "江苏省苏州市";
$areanames{zh}->{861304030} = "吉林省四平市";
$areanames{zh}->{861304031} = "吉林省白城市";
$areanames{zh}->{861304032} = "吉林省白山市";
$areanames{zh}->{861304033} = "吉林省松原市";
$areanames{zh}->{861304034} = "吉林省松原市";
$areanames{zh}->{861304035} = "吉林省通化市";
$areanames{zh}->{861304036} = "吉林省白城市";
$areanames{zh}->{861304037} = "吉林省通化市";
$areanames{zh}->{861304038} = "吉林省四平市";
$areanames{zh}->{861304039} = "吉林省白山市";
$areanames{zh}->{861304040} = "浙江省宁波市";
$areanames{zh}->{861304041} = "浙江省宁波市";
$areanames{zh}->{861304042} = "浙江省宁波市";
$areanames{zh}->{861304043} = "浙江省宁波市";
$areanames{zh}->{861304044} = "浙江省宁波市";
$areanames{zh}->{861304045} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861304046} = "新疆阿克苏地区";
$areanames{zh}->{861304047} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861304048} = "新疆喀什地区";
$areanames{zh}->{861304049} = "新疆和田地区";
$areanames{zh}->{861304050} = "新疆昌吉回族自治州";
$areanames{zh}->{861304051} = "新疆吐鲁番地区";
$areanames{zh}->{861304052} = "新疆哈密地区";
$areanames{zh}->{861304053} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861304054} = "新疆石河子市";
$areanames{zh}->{861304055} = "新疆克拉玛依市";
$areanames{zh}->{861304056} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861304057} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861304058} = "新疆塔城地区";
$areanames{zh}->{861304059} = "新疆阿勒泰地区";
$areanames{zh}->{86130406} = "上海市";
$areanames{zh}->{86130407} = "浙江省金华市";
$areanames{zh}->{861304074} = "浙江省台州市";
$areanames{zh}->{861304075} = "浙江省台州市";
$areanames{zh}->{861304078} = "浙江省绍兴市";
$areanames{zh}->{861304079} = "浙江省绍兴市";
$areanames{zh}->{86130408} = "广东省深圳市";
$areanames{zh}->{861304090} = "湖北省荆州市";
$areanames{zh}->{861304091} = "湖北省荆州市";
$areanames{zh}->{861304092} = "湖北省荆州市";
$areanames{zh}->{861304093} = "湖北省荆州市";
$areanames{zh}->{861304094} = "湖北省荆州市";
$areanames{zh}->{861304095} = "湖北省宜昌市";
$areanames{zh}->{861304096} = "湖北省宜昌市";
$areanames{zh}->{861304097} = "湖北省宜昌市";
$areanames{zh}->{861304098} = "湖北省宜昌市";
$areanames{zh}->{861304099} = "湖北省宜昌市";
$areanames{zh}->{86130410} = "北京市";
$areanames{zh}->{86130411} = "北京市";
$areanames{zh}->{86130412} = "北京市";
$areanames{zh}->{86130413} = "吉林省吉林市";
$areanames{zh}->{861304136} = "吉林省长春市";
$areanames{zh}->{861304137} = "吉林省长春市";
$areanames{zh}->{861304138} = "吉林省长春市";
$areanames{zh}->{861304139} = "吉林省长春市";
$areanames{zh}->{86130414} = "江苏省苏州市";
$areanames{zh}->{86130415} = "江苏省常州市";
$areanames{zh}->{86130416} = "上海市";
$areanames{zh}->{86130417} = "江苏省镇江市";
$areanames{zh}->{861304170} = "江苏省常州市";
$areanames{zh}->{861304171} = "江苏省常州市";
$areanames{zh}->{861304172} = "江苏省常州市";
$areanames{zh}->{861304176} = "内蒙古鄂尔多斯市";
$areanames{zh}->{86130418} = "江苏省苏州市";
$areanames{zh}->{86130419} = "江苏省徐州市";
$areanames{zh}->{861304199} = "江苏省连云港市";
$areanames{zh}->{86130420} = "广东省广州市";
$areanames{zh}->{86130421} = "上海市";
$areanames{zh}->{86130422} = "天津市";
$areanames{zh}->{86130423} = "重庆市";
$areanames{zh}->{861304240} = "辽宁省沈阳市";
$areanames{zh}->{861304241} = "辽宁省沈阳市";
$areanames{zh}->{861304242} = "辽宁省沈阳市";
$areanames{zh}->{861304243} = "辽宁省沈阳市";
$areanames{zh}->{861304244} = "辽宁省沈阳市";
$areanames{zh}->{861304245} = "辽宁省大连市";
$areanames{zh}->{861304246} = "辽宁省大连市";
$areanames{zh}->{861304247} = "辽宁省大连市";
$areanames{zh}->{861304248} = "辽宁省大连市";
$areanames{zh}->{861304249} = "辽宁省大连市";
$areanames{zh}->{86130425} = "江苏省南京市";
$areanames{zh}->{861304260} = "辽宁省鞍山市";
$areanames{zh}->{861304261} = "辽宁省鞍山市";
$areanames{zh}->{861304262} = "辽宁省鞍山市";
$areanames{zh}->{861304263} = "辽宁省抚顺市";
$areanames{zh}->{861304264} = "辽宁省抚顺市";
$areanames{zh}->{861304265} = "辽宁省本溪市";
$areanames{zh}->{861304266} = "辽宁省丹东市";
$areanames{zh}->{861304267} = "辽宁省锦州市";
$areanames{zh}->{861304268} = "辽宁省锦州市";
$areanames{zh}->{861304269} = "辽宁省营口市";
$areanames{zh}->{861304270} = "湖北省黄石市";
$areanames{zh}->{861304271} = "湖北省黄冈市";
$areanames{zh}->{861304272} = "湖北省黄冈市";
$areanames{zh}->{861304273} = "湖北省鄂州市";
$areanames{zh}->{861304274} = "湖北省孝感市";
$areanames{zh}->{861304275} = "湖北省随州市";
$areanames{zh}->{861304276} = "湖北省十堰市";
$areanames{zh}->{861304277} = "湖北省咸宁市";
$areanames{zh}->{861304278} = "湖北省襄樊市";
$areanames{zh}->{861304279} = "湖北省襄樊市";
$areanames{zh}->{86130428} = "湖北省武汉市";
$areanames{zh}->{861304280} = "湖北省襄樊市";
$areanames{zh}->{861304281} = "湖北省襄樊市";
$areanames{zh}->{861304282} = "湖北省襄樊市";
$areanames{zh}->{861304283} = "湖北省襄樊市";
$areanames{zh}->{861304290} = "甘肃省白银市";
$areanames{zh}->{861304291} = "甘肃省临夏回族自治州";
$areanames{zh}->{861304292} = "甘肃省张掖市";
$areanames{zh}->{861304293} = "甘肃省庆阳市";
$areanames{zh}->{861304294} = "甘肃省定西市";
$areanames{zh}->{861304295} = "甘肃省天水市";
$areanames{zh}->{861304296} = "甘肃省嘉峪关市";
$areanames{zh}->{861304297} = "甘肃省天水市";
$areanames{zh}->{861304298} = "甘肃省天水市";
$areanames{zh}->{861304299} = "甘肃省平凉市";
$areanames{zh}->{861304300} = "福建省厦门市";
$areanames{zh}->{861304301} = "河南省郑州市";
$areanames{zh}->{861304302} = "河南省洛阳市";
$areanames{zh}->{861304303} = "河南省平顶山市";
$areanames{zh}->{861304304} = "福建省厦门市";
$areanames{zh}->{861304305} = "福建省三明市";
$areanames{zh}->{861304306} = "福建省漳州市";
$areanames{zh}->{861304307} = "福建省漳州市";
$areanames{zh}->{861304308} = "福建省漳州市";
$areanames{zh}->{861304309} = "福建省漳州市";
$areanames{zh}->{861304310} = "河北省邯郸市";
$areanames{zh}->{861304311} = "河北省石家庄市";
$areanames{zh}->{861304312} = "河北省保定市";
$areanames{zh}->{861304313} = "河北省秦皇岛市";
$areanames{zh}->{861304314} = "河北省唐山市";
$areanames{zh}->{861304315} = "河北省唐山市";
$areanames{zh}->{861304316} = "河北省廊坊市";
$areanames{zh}->{861304317} = "河北省沧州市";
$areanames{zh}->{861304318} = "河北省衡水市";
$areanames{zh}->{861304319} = "河北省邢台市";
$areanames{zh}->{86130432} = "天津市";
$areanames{zh}->{861304330} = "吉林省长春市";
$areanames{zh}->{861304331} = "吉林省长春市";
$areanames{zh}->{861304332} = "吉林省长春市";
$areanames{zh}->{861304333} = "吉林省长春市";
$areanames{zh}->{861304334} = "吉林省长春市";
$areanames{zh}->{861304335} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861304336} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861304337} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861304338} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861304339} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{86130434} = "广东省深圳市";
$areanames{zh}->{86130435} = "福建省福州市";
$areanames{zh}->{861304356} = "福建省龙岩市";
$areanames{zh}->{861304357} = "福建省三明市";
$areanames{zh}->{861304358} = "福建省南平市";
$areanames{zh}->{861304359} = "福建省龙岩市";
$areanames{zh}->{861304360} = "江苏省无锡市";
$areanames{zh}->{861304361} = "江苏省无锡市";
$areanames{zh}->{861304362} = "江苏省无锡市";
$areanames{zh}->{861304363} = "湖南省娄底市";
$areanames{zh}->{861304364} = "湖南省娄底市";
$areanames{zh}->{861304365} = "江苏省无锡市";
$areanames{zh}->{861304366} = "江苏省无锡市";
$areanames{zh}->{861304367} = "湖南省娄底市";
$areanames{zh}->{861304368} = "湖南省娄底市";
$areanames{zh}->{861304369} = "湖南省娄底市";
$areanames{zh}->{861304370} = "河南省商丘市";
$areanames{zh}->{861304371} = "河南省郑州市";
$areanames{zh}->{861304372} = "河南省安阳市";
$areanames{zh}->{861304373} = "河南省新乡市";
$areanames{zh}->{861304374} = "河南省许昌市";
$areanames{zh}->{861304375} = "河南省平顶山市";
$areanames{zh}->{861304376} = "河南省信阳市";
$areanames{zh}->{861304377} = "河南省南阳市";
$areanames{zh}->{861304378} = "河南省开封市";
$areanames{zh}->{861304379} = "河南省洛阳市";
$areanames{zh}->{861304380} = "辽宁省阜新市";
$areanames{zh}->{861304381} = "辽宁省辽阳市";
$areanames{zh}->{861304382} = "辽宁省辽阳市";
$areanames{zh}->{861304383} = "辽宁省铁岭市";
$areanames{zh}->{861304384} = "辽宁省铁岭市";
$areanames{zh}->{861304385} = "辽宁省朝阳市";
$areanames{zh}->{861304386} = "辽宁省盘锦市";
$areanames{zh}->{861304387} = "辽宁省盘锦市";
$areanames{zh}->{861304388} = "辽宁省葫芦岛市";
$areanames{zh}->{861304389} = "辽宁省葫芦岛市";
$areanames{zh}->{861304390} = "河南省南阳市";
$areanames{zh}->{861304391} = "河南省焦作市";
$areanames{zh}->{861304392} = "河南省鹤壁市";
$areanames{zh}->{861304393} = "河南省濮阳市";
$areanames{zh}->{861304394} = "河南省周口市";
$areanames{zh}->{861304395} = "河南省漯河市";
$areanames{zh}->{861304396} = "河南省驻马店市";
$areanames{zh}->{861304397} = "河南省郑州市";
$areanames{zh}->{861304398} = "河南省三门峡市";
$areanames{zh}->{861304399} = "河南省郑州市";
$areanames{zh}->{861304400} = "山东省泰安市";
$areanames{zh}->{861304401} = "山东省泰安市";
$areanames{zh}->{861304402} = "山东省泰安市";
$areanames{zh}->{861304403} = "山东省莱芜市";
$areanames{zh}->{861304404} = "山东省临沂市";
$areanames{zh}->{861304405} = "山东省临沂市";
$areanames{zh}->{861304406} = "山东省临沂市";
$areanames{zh}->{861304407} = "山东省济宁市";
$areanames{zh}->{861304408} = "山东省济宁市";
$areanames{zh}->{861304409} = "山东省济宁市";
$areanames{zh}->{86130441} = "上海市";
$areanames{zh}->{86130442} = "广东省广州市";
$areanames{zh}->{861304430} = "吉林省长春市";
$areanames{zh}->{861304431} = "吉林省长春市";
$areanames{zh}->{861304432} = "吉林省吉林市";
$areanames{zh}->{861304433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861304434} = "吉林省四平市";
$areanames{zh}->{861304435} = "吉林省通化市";
$areanames{zh}->{861304436} = "吉林省白城市";
$areanames{zh}->{861304437} = "吉林省辽源市";
$areanames{zh}->{861304438} = "吉林省松原市";
$areanames{zh}->{861304439} = "吉林省白山市";
$areanames{zh}->{861304440} = "山西省运城市";
$areanames{zh}->{861304441} = "山西省忻州市";
$areanames{zh}->{861304442} = "山西省忻州市";
$areanames{zh}->{861304443} = "山西省朔州市";
$areanames{zh}->{861304444} = "山西省朔州市";
$areanames{zh}->{861304445} = "山西省晋城市";
$areanames{zh}->{861304446} = "山西省阳泉市";
$areanames{zh}->{861304447} = "山西省阳泉市";
$areanames{zh}->{861304448} = "山西省吕梁市";
$areanames{zh}->{861304449} = "山西省吕梁市";
$areanames{zh}->{861304450} = "福建省漳州市";
$areanames{zh}->{861304451} = "河南省郑州市";
$areanames{zh}->{861304452} = "福建省漳州市";
$areanames{zh}->{861304453} = "福建省漳州市";
$areanames{zh}->{861304454} = "福建省泉州市";
$areanames{zh}->{861304455} = "福建省泉州市";
$areanames{zh}->{861304456} = "福建省泉州市";
$areanames{zh}->{861304457} = "福建省福州市";
$areanames{zh}->{861304458} = "福建省福州市";
$areanames{zh}->{861304459} = "福建省福州市";
$areanames{zh}->{86130446} = "上海市";
$areanames{zh}->{861304470} = "河南省郑州市";
$areanames{zh}->{861304471} = "河南省郑州市";
$areanames{zh}->{861304472} = "河南省洛阳市";
$areanames{zh}->{861304473} = "河南省洛阳市";
$areanames{zh}->{861304474} = "河南省洛阳市";
$areanames{zh}->{861304475} = "河南省新乡市";
$areanames{zh}->{861304476} = "河南省安阳市";
$areanames{zh}->{861304477} = "河南省漯河市";
$areanames{zh}->{861304478} = "河南省开封市";
$areanames{zh}->{861304479} = "河南省平顶山市";
$areanames{zh}->{861304480} = "湖北省孝感市";
$areanames{zh}->{861304481} = "湖北省孝感市";
$areanames{zh}->{861304482} = "湖北省孝感市";
$areanames{zh}->{861304483} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861304484} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861304485} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861304486} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861304487} = "湖北省荆门市";
$areanames{zh}->{861304488} = "湖北省荆门市";
$areanames{zh}->{861304489} = "湖北省荆门市";
$areanames{zh}->{861304490} = "江西省南昌市";
$areanames{zh}->{861304491} = "江西省南昌市";
$areanames{zh}->{861304492} = "江西省九江市";
$areanames{zh}->{861304493} = "江西省上饶市";
$areanames{zh}->{861304494} = "江西省抚州市";
$areanames{zh}->{861304495} = "江西省宜春市";
$areanames{zh}->{861304496} = "江西省吉安市";
$areanames{zh}->{861304497} = "江西省赣州市";
$areanames{zh}->{861304498} = "江西省景德镇市";
$areanames{zh}->{861304499} = "江西省萍乡市";
$areanames{zh}->{86130450} = "山东省青岛市";
$areanames{zh}->{86130451} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861304525} = "黑龙江省伊春市";
$areanames{zh}->{861304526} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861304528} = "黑龙江省绥化市";
$areanames{zh}->{861304529} = "黑龙江省绥化市";
$areanames{zh}->{861304530} = "黑龙江省牡丹江市";
$areanames{zh}->{861304531} = "黑龙江省牡丹江市";
$areanames{zh}->{861304532} = "黑龙江省牡丹江市";
$areanames{zh}->{861304533} = "黑龙江省牡丹江市";
$areanames{zh}->{861304534} = "黑龙江省牡丹江市";
$areanames{zh}->{861304535} = "黑龙江省鸡西市";
$areanames{zh}->{861304536} = "黑龙江省鸡西市";
$areanames{zh}->{861304537} = "黑龙江省七台河市";
$areanames{zh}->{861304538} = "黑龙江省七台河市";
$areanames{zh}->{861304539} = "黑龙江省大庆市";
$areanames{zh}->{861304540} = "黑龙江省佳木斯市";
$areanames{zh}->{861304541} = "黑龙江省佳木斯市";
$areanames{zh}->{861304542} = "黑龙江省佳木斯市";
$areanames{zh}->{861304543} = "黑龙江省佳木斯市";
$areanames{zh}->{861304544} = "黑龙江省佳木斯市";
$areanames{zh}->{861304545} = "黑龙江省鹤岗市";
$areanames{zh}->{861304546} = "黑龙江省鹤岗市";
$areanames{zh}->{861304547} = "黑龙江省双鸭山市";
$areanames{zh}->{861304548} = "黑龙江省双鸭山市";
$areanames{zh}->{861304549} = "黑龙江省大庆市";
$areanames{zh}->{861304550} = "安徽省滁州市";
$areanames{zh}->{861304551} = "安徽省合肥市";
$areanames{zh}->{861304552} = "安徽省六安市";
$areanames{zh}->{861304553} = "安徽省池州市";
$areanames{zh}->{861304554} = "安徽省宣城市";
$areanames{zh}->{861304555} = "安徽省马鞍山市";
$areanames{zh}->{861304556} = "安徽省安庆市";
$areanames{zh}->{861304557} = "安徽省铜陵市";
$areanames{zh}->{861304558} = "安徽省宣城市";
$areanames{zh}->{861304559} = "安徽省黄山市";
$areanames{zh}->{86130456} = "上海市";
$areanames{zh}->{861304570} = "浙江省衢州市";
$areanames{zh}->{861304571} = "浙江省杭州市";
$areanames{zh}->{861304572} = "浙江省湖州市";
$areanames{zh}->{861304573} = "浙江省嘉兴市";
$areanames{zh}->{861304574} = "浙江省嘉兴市";
$areanames{zh}->{861304575} = "浙江省绍兴市";
$areanames{zh}->{861304576} = "浙江省台州市";
$areanames{zh}->{861304577} = "浙江省温州市";
$areanames{zh}->{861304578} = "浙江省金华市";
$areanames{zh}->{861304579} = "浙江省金华市";
$areanames{zh}->{86130458} = "广东省深圳市";
$areanames{zh}->{861304590} = "福建省龙岩市";
$areanames{zh}->{861304591} = "福建省福州市";
$areanames{zh}->{861304592} = "福建省厦门市";
$areanames{zh}->{861304593} = "福建省宁德市";
$areanames{zh}->{861304594} = "福建省莆田市";
$areanames{zh}->{861304595} = "福建省泉州市";
$areanames{zh}->{861304596} = "福建省漳州市";
$areanames{zh}->{861304597} = "福建省厦门市";
$areanames{zh}->{861304598} = "福建省三明市";
$areanames{zh}->{861304599} = "福建省南平市";
$areanames{zh}->{861304600} = "山东省济南市";
$areanames{zh}->{861304601} = "山东省济南市";
$areanames{zh}->{861304602} = "山东省济南市";
$areanames{zh}->{861304603} = "山东省济南市";
$areanames{zh}->{861304604} = "山东省济南市";
$areanames{zh}->{861304605} = "山东省淄博市";
$areanames{zh}->{861304606} = "山东省淄博市";
$areanames{zh}->{861304607} = "山东省淄博市";
$areanames{zh}->{861304608} = "山东省淄博市";
$areanames{zh}->{861304609} = "山东省淄博市";
$areanames{zh}->{861304610} = "广东省汕尾市";
$areanames{zh}->{861304611} = "广东省汕尾市";
$areanames{zh}->{861304612} = "广东省汕尾市";
$areanames{zh}->{861304613} = "广东省汕尾市";
$areanames{zh}->{861304614} = "广东省清远市";
$areanames{zh}->{861304615} = "广东省清远市";
$areanames{zh}->{861304616} = "广东省清远市";
$areanames{zh}->{861304617} = "广东省韶关市";
$areanames{zh}->{861304618} = "广东省韶关市";
$areanames{zh}->{861304619} = "广东省韶关市";
$areanames{zh}->{861304620} = "广东省湛江市";
$areanames{zh}->{861304621} = "广东省湛江市";
$areanames{zh}->{861304622} = "广东省湛江市";
$areanames{zh}->{861304623} = "广东省湛江市";
$areanames{zh}->{861304624} = "广东省湛江市";
$areanames{zh}->{861304625} = "广东省茂名市";
$areanames{zh}->{861304626} = "广东省茂名市";
$areanames{zh}->{861304627} = "广东省茂名市";
$areanames{zh}->{861304628} = "广东省茂名市";
$areanames{zh}->{861304629} = "广东省茂名市";
$areanames{zh}->{861304630} = "广东省中山市";
$areanames{zh}->{861304631} = "广东省中山市";
$areanames{zh}->{861304632} = "广东省中山市";
$areanames{zh}->{861304633} = "广东省中山市";
$areanames{zh}->{861304634} = "广东省中山市";
$areanames{zh}->{861304635} = "广东省珠海市";
$areanames{zh}->{861304636} = "广东省珠海市";
$areanames{zh}->{861304637} = "广东省珠海市";
$areanames{zh}->{861304638} = "广东省珠海市";
$areanames{zh}->{861304639} = "广东省珠海市";
$areanames{zh}->{861304640} = "山东省烟台市";
$areanames{zh}->{861304641} = "山东省烟台市";
$areanames{zh}->{861304642} = "山东省烟台市";
$areanames{zh}->{861304643} = "山东省威海市";
$areanames{zh}->{861304644} = "山东省威海市";
$areanames{zh}->{861304645} = "山东省威海市";
$areanames{zh}->{861304646} = "山东省潍坊市";
$areanames{zh}->{861304647} = "山东省潍坊市";
$areanames{zh}->{861304648} = "山东省潍坊市";
$areanames{zh}->{861304649} = "山东省潍坊市";
$areanames{zh}->{86130465} = "江苏省盐城市";
$areanames{zh}->{86130466} = "上海市";
$areanames{zh}->{86130467} = "江苏省南通市";
$areanames{zh}->{861304679} = "江苏省宿迁市";
$areanames{zh}->{86130468} = "广东省东莞市";
$areanames{zh}->{861304680} = "广东省汕头市";
$areanames{zh}->{861304681} = "广东省汕头市";
$areanames{zh}->{861304690} = "福建省莆田市";
$areanames{zh}->{861304691} = "河南省平顶山市";
$areanames{zh}->{861304692} = "福建省宁德市";
$areanames{zh}->{861304693} = "福建省宁德市";
$areanames{zh}->{861304694} = "福建省宁德市";
$areanames{zh}->{861304695} = "福建省宁德市";
$areanames{zh}->{861304696} = "福建省泉州市";
$areanames{zh}->{861304697} = "福建省泉州市";
$areanames{zh}->{861304698} = "福建省泉州市";
$areanames{zh}->{861304699} = "福建省泉州市";
$areanames{zh}->{86130470} = "广东省佛山市";
$areanames{zh}->{861304700} = "广东省潮州市";
$areanames{zh}->{861304701} = "广东省潮州市";
$areanames{zh}->{861304702} = "广东省阳江市";
$areanames{zh}->{861304703} = "广东省阳江市";
$areanames{zh}->{861304710} = "湖北省荆州市";
$areanames{zh}->{861304711} = "湖北省荆州市";
$areanames{zh}->{861304712} = "湖北省武汉市";
$areanames{zh}->{861304713} = "湖北省武汉市";
$areanames{zh}->{861304714} = "湖北省武汉市";
$areanames{zh}->{861304715} = "湖北省宜昌市";
$areanames{zh}->{861304716} = "湖北省宜昌市";
$areanames{zh}->{861304717} = "湖北省宜昌市";
$areanames{zh}->{861304718} = "湖北省荆门市";
$areanames{zh}->{861304719} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861304720} = "湖南省岳阳市";
$areanames{zh}->{861304721} = "湖南省长沙市";
$areanames{zh}->{861304722} = "湖南省湘潭市";
$areanames{zh}->{861304723} = "湖南省株洲市";
$areanames{zh}->{861304724} = "湖南省衡阳市";
$areanames{zh}->{861304725} = "湖南省郴州市";
$areanames{zh}->{861304726} = "湖南省常德市";
$areanames{zh}->{861304727} = "湖南省益阳市";
$areanames{zh}->{861304728} = "湖南省邵阳市";
$areanames{zh}->{861304729} = "湖南省怀化市";
$areanames{zh}->{86130473} = "重庆市";
$areanames{zh}->{861304740} = "山东省青岛市";
$areanames{zh}->{861304741} = "山东省青岛市";
$areanames{zh}->{861304742} = "山东省枣庄市";
$areanames{zh}->{861304743} = "山东省日照市";
$areanames{zh}->{861304744} = "山东省东营市";
$areanames{zh}->{861304745} = "山东省聊城市";
$areanames{zh}->{861304746} = "山东省德州市";
$areanames{zh}->{861304747} = "山东省临沂市";
$areanames{zh}->{861304748} = "山东省济南市";
$areanames{zh}->{861304749} = "山东省烟台市";
$areanames{zh}->{86130475} = "江苏省南京市";
$areanames{zh}->{861304758} = "江苏省宿迁市";
$areanames{zh}->{861304759} = "江苏省宿迁市";
$areanames{zh}->{86130476} = "浙江省杭州市";
$areanames{zh}->{861304768} = "江苏省宿迁市";
$areanames{zh}->{861304769} = "江苏省宿迁市";
$areanames{zh}->{86130477} = "河北省邯郸市";
$areanames{zh}->{861304780} = "广西柳州市";
$areanames{zh}->{861304781} = "广西南宁市";
$areanames{zh}->{861304782} = "广西柳州市";
$areanames{zh}->{861304783} = "广西贺州市";
$areanames{zh}->{861304784} = "广西贵港市";
$areanames{zh}->{861304785} = "广西玉林市";
$areanames{zh}->{861304786} = "广西百色市";
$areanames{zh}->{861304787} = "广西钦州市";
$areanames{zh}->{861304788} = "广西河池市";
$areanames{zh}->{861304789} = "广西贵港市";
$areanames{zh}->{861304790} = "江西省南昌市";
$areanames{zh}->{861304791} = "江西省南昌市";
$areanames{zh}->{861304792} = "江西省九江市";
$areanames{zh}->{861304793} = "江西省上饶市";
$areanames{zh}->{861304794} = "江西省抚州市";
$areanames{zh}->{861304795} = "江西省宜春市";
$areanames{zh}->{861304796} = "江西省吉安市";
$areanames{zh}->{861304797} = "江西省赣州市";
$areanames{zh}->{861304798} = "江西省景德镇市";
$areanames{zh}->{861304799} = "江西省萍乡市";
$areanames{zh}->{86130480} = "广东省广州市";
$areanames{zh}->{86130481} = "广东省江门市";
$areanames{zh}->{861304820} = "广东省肇庆市";
$areanames{zh}->{861304821} = "广东省肇庆市";
$areanames{zh}->{861304822} = "广东省肇庆市";
$areanames{zh}->{861304823} = "广东省肇庆市";
$areanames{zh}->{861304824} = "广东省肇庆市";
$areanames{zh}->{861304825} = "广东省梅州市";
$areanames{zh}->{861304826} = "广东省梅州市";
$areanames{zh}->{861304827} = "广东省梅州市";
$areanames{zh}->{861304828} = "广东省梅州市";
$areanames{zh}->{861304829} = "广东省梅州市";
$areanames{zh}->{86130483} = "重庆市";
$areanames{zh}->{86130484} = "重庆市";
$areanames{zh}->{861304850} = "贵州省遵义市";
$areanames{zh}->{861304851} = "贵州省遵义市";
$areanames{zh}->{861304852} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861304853} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861304854} = "贵州省毕节地区";
$areanames{zh}->{861304855} = "贵州省毕节地区";
$areanames{zh}->{861304856} = "贵州省六盘水市";
$areanames{zh}->{861304857} = "贵州省遵义市";
$areanames{zh}->{861304858} = "贵州省遵义市";
$areanames{zh}->{861304859} = "贵州省遵义市";
$areanames{zh}->{861304860} = "江苏省淮安市";
$areanames{zh}->{861304861} = "江苏省淮安市";
$areanames{zh}->{861304862} = "江苏省淮安市";
$areanames{zh}->{861304863} = "江苏省淮安市";
$areanames{zh}->{861304864} = "江苏省淮安市";
$areanames{zh}->{861304865} = "江苏省连云港市";
$areanames{zh}->{861304866} = "江苏省连云港市";
$areanames{zh}->{861304867} = "江苏省连云港市";
$areanames{zh}->{861304868} = "江苏省连云港市";
$areanames{zh}->{861304869} = "江苏省连云港市";
$areanames{zh}->{86130487} = "广东省惠州市";
$areanames{zh}->{861304878} = "河北省石家庄市";
$areanames{zh}->{861304879} = "河北省石家庄市";
$areanames{zh}->{86130488} = "广东省深圳市";
$areanames{zh}->{86130489} = "广东省深圳市";
$areanames{zh}->{86130490} = "广东省汕头市";
$areanames{zh}->{86130491} = "广东省佛山市";
$areanames{zh}->{86130492} = "广东省揭阳市";
$areanames{zh}->{861304920} = "广东省云浮市";
$areanames{zh}->{861304921} = "广东省云浮市";
$areanames{zh}->{861304922} = "广东省云浮市";
$areanames{zh}->{86130493} = "广东省深圳市";
$areanames{zh}->{86130494} = "广东省深圳市";
$areanames{zh}->{861304950} = "贵州省安顺市";
$areanames{zh}->{861304951} = "贵州省安顺市";
$areanames{zh}->{861304952} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861304953} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861304954} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861304955} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861304956} = "贵州省铜仁地区";
$areanames{zh}->{861304957} = "贵州省毕节地区";
$areanames{zh}->{861304958} = "贵州省六盘水市";
$areanames{zh}->{861304959} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86130496} = "广东省广州市";
$areanames{zh}->{861304960} = "广东省河源市";
$areanames{zh}->{861304961} = "广东省河源市";
$areanames{zh}->{86130497} = "广东省东莞市";
$areanames{zh}->{86130498} = "广东省深圳市";
$areanames{zh}->{86130499} = "浙江省金华市";
$areanames{zh}->{86130500} = "辽宁省鞍山市";
$areanames{zh}->{86130501} = "辽宁省抚顺市";
$areanames{zh}->{86130502} = "辽宁省本溪市";
$areanames{zh}->{86130503} = "辽宁省丹东市";
$areanames{zh}->{86130504} = "辽宁省锦州市";
$areanames{zh}->{86130505} = "辽宁省大连市";
$areanames{zh}->{86130506} = "辽宁省营口市";
$areanames{zh}->{861305070} = "辽宁省阜新市";
$areanames{zh}->{861305071} = "辽宁省阜新市";
$areanames{zh}->{861305072} = "辽宁省阜新市";
$areanames{zh}->{861305073} = "辽宁省阜新市";
$areanames{zh}->{861305074} = "辽宁省阜新市";
$areanames{zh}->{861305075} = "辽宁省辽阳市";
$areanames{zh}->{861305076} = "辽宁省辽阳市";
$areanames{zh}->{861305077} = "辽宁省辽阳市";
$areanames{zh}->{861305078} = "辽宁省辽阳市";
$areanames{zh}->{861305079} = "辽宁省辽阳市";
$areanames{zh}->{861305080} = "辽宁省铁岭市";
$areanames{zh}->{861305081} = "辽宁省铁岭市";
$areanames{zh}->{861305082} = "辽宁省铁岭市";
$areanames{zh}->{861305083} = "辽宁省铁岭市";
$areanames{zh}->{861305084} = "辽宁省铁岭市";
$areanames{zh}->{861305085} = "辽宁省盘锦市";
$areanames{zh}->{861305086} = "辽宁省盘锦市";
$areanames{zh}->{861305087} = "辽宁省盘锦市";
$areanames{zh}->{861305088} = "辽宁省盘锦市";
$areanames{zh}->{861305089} = "辽宁省盘锦市";
$areanames{zh}->{861305090} = "辽宁省朝阳市";
$areanames{zh}->{861305091} = "辽宁省朝阳市";
$areanames{zh}->{861305092} = "辽宁省朝阳市";
$areanames{zh}->{861305093} = "辽宁省朝阳市";
$areanames{zh}->{861305094} = "辽宁省朝阳市";
$areanames{zh}->{861305095} = "辽宁省葫芦岛市";
$areanames{zh}->{861305096} = "辽宁省葫芦岛市";
$areanames{zh}->{861305097} = "辽宁省葫芦岛市";
$areanames{zh}->{861305098} = "辽宁省葫芦岛市";
$areanames{zh}->{861305099} = "辽宁省葫芦岛市";
$areanames{zh}->{8613051} = "北京市";
$areanames{zh}->{8613052} = "上海市";
$areanames{zh}->{861305260} = "辽宁省朝阳市";
$areanames{zh}->{861305261} = "辽宁省朝阳市";
$areanames{zh}->{861305262} = "辽宁省朝阳市";
$areanames{zh}->{861305263} = "辽宁省朝阳市";
$areanames{zh}->{861305264} = "辽宁省朝阳市";
$areanames{zh}->{861305265} = "辽宁省葫芦岛市";
$areanames{zh}->{861305266} = "辽宁省葫芦岛市";
$areanames{zh}->{861305267} = "辽宁省葫芦岛市";
$areanames{zh}->{861305268} = "辽宁省葫芦岛市";
$areanames{zh}->{861305269} = "辽宁省葫芦岛市";
$areanames{zh}->{86130527} = "辽宁省大连市";
$areanames{zh}->{86130528} = "江苏省苏州市";
$areanames{zh}->{861305290} = "江苏省镇江市";
$areanames{zh}->{861305291} = "江苏省镇江市";
$areanames{zh}->{861305292} = "江苏省镇江市";
$areanames{zh}->{861305293} = "江苏省镇江市";
$areanames{zh}->{861305294} = "江苏省镇江市";
$areanames{zh}->{861305295} = "江苏省泰州市";
$areanames{zh}->{861305296} = "江苏省泰州市";
$areanames{zh}->{861305297} = "江苏省泰州市";
$areanames{zh}->{861305298} = "江苏省泰州市";
$areanames{zh}->{861305299} = "江苏省泰州市";
$areanames{zh}->{861305300} = "安徽省宿州市";
$areanames{zh}->{861305301} = "安徽省宿州市";
$areanames{zh}->{861305302} = "安徽省六安市";
$areanames{zh}->{861305303} = "安徽省六安市";
$areanames{zh}->{861305304} = "安徽省合肥市";
$areanames{zh}->{861305305} = "安徽省合肥市";
$areanames{zh}->{861305306} = "安徽省合肥市";
$areanames{zh}->{861305307} = "安徽省淮南市";
$areanames{zh}->{861305308} = "安徽省合肥市";
$areanames{zh}->{861305309} = "安徽省合肥市";
$areanames{zh}->{861305310} = "安徽省滁州市";
$areanames{zh}->{861305311} = "安徽省蚌埠市";
$areanames{zh}->{861305312} = "安徽省蚌埠市";
$areanames{zh}->{861305313} = "安徽省合肥市";
$areanames{zh}->{861305314} = "安徽省滁州市";
$areanames{zh}->{861305315} = "安徽省淮北市";
$areanames{zh}->{861305316} = "安徽省芜湖市";
$areanames{zh}->{861305317} = "安徽省淮南市";
$areanames{zh}->{861305318} = "安徽省亳州市";
$areanames{zh}->{861305319} = "安徽省阜阳市";
$areanames{zh}->{861305320} = "安徽省马鞍山市";
$areanames{zh}->{861305321} = "安徽省马鞍山市";
$areanames{zh}->{861305322} = "安徽省黄山市";
$areanames{zh}->{861305323} = "安徽省宣城市";
$areanames{zh}->{861305324} = "安徽省宣城市";
$areanames{zh}->{861305325} = "安徽省铜陵市";
$areanames{zh}->{861305326} = "安徽省芜湖市";
$areanames{zh}->{861305327} = "安徽省安庆市";
$areanames{zh}->{861305328} = "安徽省安庆市";
$areanames{zh}->{861305329} = "安徽省池州市";
$areanames{zh}->{86130533} = "山东省淄博市";
$areanames{zh}->{86130534} = "山东省德州市";
$areanames{zh}->{86130535} = "山东省烟台市";
$areanames{zh}->{86130536} = "山东省潍坊市";
$areanames{zh}->{86130537} = "山东省济宁市";
$areanames{zh}->{86130538} = "山东省泰安市";
$areanames{zh}->{86130539} = "山东省临沂市";
$areanames{zh}->{861305400} = "湖南省郴州市";
$areanames{zh}->{861305401} = "湖南省郴州市";
$areanames{zh}->{861305402} = "湖南省常德市";
$areanames{zh}->{861305403} = "湖南省常德市";
$areanames{zh}->{861305404} = "湖南省常德市";
$areanames{zh}->{861305405} = "湖南省衡阳市";
$areanames{zh}->{861305406} = "湖南省衡阳市";
$areanames{zh}->{861305407} = "湖南省岳阳市";
$areanames{zh}->{861305408} = "湖南省岳阳市";
$areanames{zh}->{861305409} = "湖南省益阳市";
$areanames{zh}->{861305410} = "湖南省益阳市";
$areanames{zh}->{861305411} = "湖南省株洲市";
$areanames{zh}->{861305412} = "湖南省株洲市";
$areanames{zh}->{861305413} = "湖南省株洲市";
$areanames{zh}->{861305414} = "湖南省湘潭市";
$areanames{zh}->{861305415} = "湖南省湘潭市";
$areanames{zh}->{861305416} = "湖南省长沙市";
$areanames{zh}->{861305417} = "湖南省长沙市";
$areanames{zh}->{861305418} = "湖南省长沙市";
$areanames{zh}->{861305419} = "湖南省长沙市";
$areanames{zh}->{861305420} = "黑龙江省大庆市";
$areanames{zh}->{861305421} = "黑龙江省大庆市";
$areanames{zh}->{861305422} = "黑龙江省大庆市";
$areanames{zh}->{861305423} = "黑龙江省大庆市";
$areanames{zh}->{861305424} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861305425} = "黑龙江省绥化市";
$areanames{zh}->{861305426} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305427} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305428} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305429} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305430} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861305431} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861305432} = "黑龙江省鸡西市";
$areanames{zh}->{861305433} = "黑龙江省牡丹江市";
$areanames{zh}->{861305434} = "黑龙江省牡丹江市";
$areanames{zh}->{861305435} = "黑龙江省七台河市";
$areanames{zh}->{861305436} = "黑龙江省佳木斯市";
$areanames{zh}->{861305437} = "黑龙江省双鸭山市";
$areanames{zh}->{861305438} = "黑龙江省鹤岗市";
$areanames{zh}->{861305439} = "黑龙江省绥化市";
$areanames{zh}->{86130544} = "广东省广州市";
$areanames{zh}->{86130545} = "山东省烟台市";
$areanames{zh}->{86130546} = "山东省东营市";
$areanames{zh}->{86130547} = "山东省潍坊市";
$areanames{zh}->{861305480} = "山东省莱芜市";
$areanames{zh}->{861305481} = "山东省莱芜市";
$areanames{zh}->{861305482} = "山东省莱芜市";
$areanames{zh}->{861305483} = "山东省莱芜市";
$areanames{zh}->{861305484} = "山东省莱芜市";
$areanames{zh}->{861305485} = "山东省淄博市";
$areanames{zh}->{861305486} = "山东省淄博市";
$areanames{zh}->{861305487} = "山东省淄博市";
$areanames{zh}->{861305488} = "山东省淄博市";
$areanames{zh}->{861305489} = "山东省淄博市";
$areanames{zh}->{861305490} = "山东省临沂市";
$areanames{zh}->{861305491} = "山东省临沂市";
$areanames{zh}->{861305492} = "山东省临沂市";
$areanames{zh}->{861305493} = "山东省临沂市";
$areanames{zh}->{861305494} = "山东省临沂市";
$areanames{zh}->{861305495} = "山东省济宁市";
$areanames{zh}->{861305496} = "山东省济宁市";
$areanames{zh}->{861305497} = "山东省济宁市";
$areanames{zh}->{861305498} = "山东省济宁市";
$areanames{zh}->{861305499} = "山东省济宁市";
$areanames{zh}->{861305500} = "湖南省郴州市";
$areanames{zh}->{861305501} = "湖南省郴州市";
$areanames{zh}->{861305502} = "湖南省常德市";
$areanames{zh}->{861305503} = "湖南省常德市";
$areanames{zh}->{861305504} = "湖南省常德市";
$areanames{zh}->{861305505} = "湖南省衡阳市";
$areanames{zh}->{861305506} = "湖南省衡阳市";
$areanames{zh}->{861305507} = "湖南省岳阳市";
$areanames{zh}->{861305508} = "湖南省岳阳市";
$areanames{zh}->{861305509} = "湖南省益阳市";
$areanames{zh}->{861305510} = "湖南省益阳市";
$areanames{zh}->{861305511} = "湖南省株洲市";
$areanames{zh}->{861305512} = "湖南省株洲市";
$areanames{zh}->{861305513} = "湖南省株洲市";
$areanames{zh}->{861305514} = "湖南省湘潭市";
$areanames{zh}->{861305515} = "湖南省湘潭市";
$areanames{zh}->{861305516} = "湖南省长沙市";
$areanames{zh}->{861305517} = "湖南省长沙市";
$areanames{zh}->{861305518} = "湖南省长沙市";
$areanames{zh}->{861305519} = "湖南省长沙市";
$areanames{zh}->{861305520} = "福建省厦门市";
$areanames{zh}->{861305521} = "福建省厦门市";
$areanames{zh}->{861305522} = "福建省厦门市";
$areanames{zh}->{861305523} = "福建省厦门市";
$areanames{zh}->{861305524} = "福建省厦门市";
$areanames{zh}->{861305525} = "福建省福州市";
$areanames{zh}->{861305526} = "福建省福州市";
$areanames{zh}->{861305527} = "福建省福州市";
$areanames{zh}->{861305528} = "福建省福州市";
$areanames{zh}->{861305529} = "福建省福州市";
$areanames{zh}->{86130553} = "福建省漳州市";
$areanames{zh}->{861305530} = "福建省莆田市";
$areanames{zh}->{861305531} = "福建省莆田市";
$areanames{zh}->{861305532} = "福建省泉州市";
$areanames{zh}->{861305533} = "福建省泉州市";
$areanames{zh}->{861305540} = "福建省福州市";
$areanames{zh}->{861305541} = "福建省福州市";
$areanames{zh}->{861305542} = "福建省福州市";
$areanames{zh}->{861305543} = "福建省厦门市";
$areanames{zh}->{861305544} = "福建省漳州市";
$areanames{zh}->{861305545} = "福建省漳州市";
$areanames{zh}->{861305546} = "福建省泉州市";
$areanames{zh}->{861305547} = "福建省泉州市";
$areanames{zh}->{861305548} = "福建省宁德市";
$areanames{zh}->{861305549} = "福建省南平市";
$areanames{zh}->{861305550} = "福建省厦门市";
$areanames{zh}->{861305551} = "福建省厦门市";
$areanames{zh}->{861305552} = "福建省福州市";
$areanames{zh}->{861305553} = "福建省福州市";
$areanames{zh}->{861305554} = "福建省三明市";
$areanames{zh}->{861305555} = "福建省三明市";
$areanames{zh}->{861305556} = "福建省三明市";
$areanames{zh}->{861305557} = "福建省宁德市";
$areanames{zh}->{861305558} = "福建省宁德市";
$areanames{zh}->{861305559} = "福建省宁德市";
$areanames{zh}->{86130556} = "福建省泉州市";
$areanames{zh}->{861305568} = "福建省莆田市";
$areanames{zh}->{861305569} = "福建省莆田市";
$areanames{zh}->{86130557} = "福建省福州市";
$areanames{zh}->{861305570} = "福建省南平市";
$areanames{zh}->{861305571} = "福建省南平市";
$areanames{zh}->{861305580} = "福建省泉州市";
$areanames{zh}->{861305581} = "福建省泉州市";
$areanames{zh}->{861305582} = "福建省南平市";
$areanames{zh}->{861305583} = "福建省南平市";
$areanames{zh}->{861305584} = "福建省龙岩市";
$areanames{zh}->{861305585} = "福建省龙岩市";
$areanames{zh}->{861305586} = "福建省龙岩市";
$areanames{zh}->{861305587} = "福建省厦门市";
$areanames{zh}->{861305588} = "福建省漳州市";
$areanames{zh}->{861305589} = "福建省漳州市";
$areanames{zh}->{861305590} = "福建省福州市";
$areanames{zh}->{861305591} = "福建省福州市";
$areanames{zh}->{861305592} = "福建省厦门市";
$areanames{zh}->{861305593} = "福建省宁德市";
$areanames{zh}->{861305594} = "福建省莆田市";
$areanames{zh}->{861305595} = "福建省泉州市";
$areanames{zh}->{861305596} = "福建省漳州市";
$areanames{zh}->{861305597} = "福建省龙岩市";
$areanames{zh}->{861305598} = "福建省南平市";
$areanames{zh}->{861305599} = "福建省南平市";
$areanames{zh}->{86130560} = "江苏省连云港市";
$areanames{zh}->{861305600} = "江苏省淮安市";
$areanames{zh}->{861305601} = "江苏省淮安市";
$areanames{zh}->{861305602} = "江苏省淮安市";
$areanames{zh}->{861305603} = "江苏省淮安市";
$areanames{zh}->{86130561} = "江苏省盐城市";
$areanames{zh}->{861305610} = "江苏省宿迁市";
$areanames{zh}->{861305611} = "江苏省宿迁市";
$areanames{zh}->{861305612} = "江苏省宿迁市";
$areanames{zh}->{86130562} = "江苏省徐州市";
$areanames{zh}->{86130563} = "江苏省扬州市";
$areanames{zh}->{861305640} = "四川省乐山市";
$areanames{zh}->{861305641} = "四川省眉山市";
$areanames{zh}->{861305642} = "四川省南充市";
$areanames{zh}->{861305643} = "四川省南充市";
$areanames{zh}->{861305644} = "四川省达州市";
$areanames{zh}->{861305645} = "四川省甘孜藏族自治州";
$areanames{zh}->{861305646} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861305647} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861305648} = "四川省巴中市";
$areanames{zh}->{861305649} = "四川省巴中市";
$areanames{zh}->{861305650} = "四川省巴中市";
$areanames{zh}->{861305651} = "四川省巴中市";
$areanames{zh}->{861305652} = "四川省广安市";
$areanames{zh}->{861305653} = "四川省广安市";
$areanames{zh}->{861305654} = "四川省广安市";
$areanames{zh}->{861305655} = "四川省广安市";
$areanames{zh}->{861305656} = "四川省雅安市";
$areanames{zh}->{861305657} = "四川省雅安市";
$areanames{zh}->{861305658} = "四川省雅安市";
$areanames{zh}->{861305659} = "四川省雅安市";
$areanames{zh}->{861305660} = "四川省眉山市";
$areanames{zh}->{861305661} = "四川省眉山市";
$areanames{zh}->{861305662} = "四川省乐山市";
$areanames{zh}->{861305663} = "四川省乐山市";
$areanames{zh}->{861305664} = "四川省宜宾市";
$areanames{zh}->{861305665} = "四川省宜宾市";
$areanames{zh}->{861305666} = "四川省成都市";
$areanames{zh}->{861305667} = "四川省成都市";
$areanames{zh}->{861305668} = "四川省成都市";
$areanames{zh}->{861305669} = "四川省成都市";
$areanames{zh}->{86130567} = "浙江省宁波市";
$areanames{zh}->{86130568} = "浙江省宁波市";
$areanames{zh}->{86130569} = "浙江省宁波市";
$areanames{zh}->{86130570} = "江苏省南通市";
$areanames{zh}->{86130571} = "江苏省常州市";
$areanames{zh}->{86130572} = "江苏省无锡市";
$areanames{zh}->{86130573} = "江苏省无锡市";
$areanames{zh}->{86130574} = "江苏省苏州市";
$areanames{zh}->{86130575} = "江苏省南京市";
$areanames{zh}->{86130576} = "江苏省南京市";
$areanames{zh}->{86130577} = "浙江省温州市";
$areanames{zh}->{86130578} = "浙江省温州市";
$areanames{zh}->{86130579} = "浙江省温州市";
$areanames{zh}->{86130580} = "广东省深圳市";
$areanames{zh}->{86130581} = "广东省深圳市";
$areanames{zh}->{861305820} = "广东省韶关市";
$areanames{zh}->{861305821} = "广东省韶关市";
$areanames{zh}->{861305822} = "广东省韶关市";
$areanames{zh}->{861305823} = "广东省韶关市";
$areanames{zh}->{861305824} = "广东省汕尾市";
$areanames{zh}->{861305825} = "广东省汕尾市";
$areanames{zh}->{861305826} = "广东省汕头市";
$areanames{zh}->{861305827} = "广东省汕头市";
$areanames{zh}->{861305828} = "广东省汕头市";
$areanames{zh}->{861305829} = "广东省汕头市";
$areanames{zh}->{86130583} = "广东省湛江市";
$areanames{zh}->{861305830} = "广东省佛山市";
$areanames{zh}->{861305831} = "广东省佛山市";
$areanames{zh}->{861305832} = "广东省佛山市";
$areanames{zh}->{861305833} = "广东省佛山市";
$areanames{zh}->{861305840} = "广东省广州市";
$areanames{zh}->{861305841} = "广东省广州市";
$areanames{zh}->{861305842} = "广东省广州市";
$areanames{zh}->{861305843} = "广东省广州市";
$areanames{zh}->{861305844} = "广东省揭阳市";
$areanames{zh}->{861305845} = "广东省揭阳市";
$areanames{zh}->{861305846} = "广东省潮州市";
$areanames{zh}->{861305847} = "广东省潮州市";
$areanames{zh}->{861305848} = "广东省汕头市";
$areanames{zh}->{861305849} = "广东省汕头市";
$areanames{zh}->{86130585} = "广东省东莞市";
$areanames{zh}->{86130586} = "浙江省台州市";
$areanames{zh}->{86130587} = "浙江省台州市";
$areanames{zh}->{86130588} = "浙江省台州市";
$areanames{zh}->{861305890} = "浙江省湖州市";
$areanames{zh}->{861305891} = "浙江省湖州市";
$areanames{zh}->{861305892} = "浙江省湖州市";
$areanames{zh}->{861305893} = "浙江省湖州市";
$areanames{zh}->{861305894} = "浙江省湖州市";
$areanames{zh}->{861305895} = "浙江省金华市";
$areanames{zh}->{861305896} = "浙江省金华市";
$areanames{zh}->{861305897} = "浙江省金华市";
$areanames{zh}->{861305898} = "浙江省金华市";
$areanames{zh}->{861305899} = "浙江省金华市";
$areanames{zh}->{86130590} = "黑龙江省大庆市";
$areanames{zh}->{861305900} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305901} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305902} = "黑龙江省哈尔滨市";
$areanames{zh}->{861305903} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130591} = "广东省广州市";
$areanames{zh}->{86130592} = "广东省江门市";
$areanames{zh}->{861305930} = "广东省云浮市";
$areanames{zh}->{861305931} = "广东省云浮市";
$areanames{zh}->{861305932} = "广东省云浮市";
$areanames{zh}->{861305933} = "广东省云浮市";
$areanames{zh}->{861305934} = "广东省云浮市";
$areanames{zh}->{861305935} = "广东省肇庆市";
$areanames{zh}->{861305936} = "广东省肇庆市";
$areanames{zh}->{861305937} = "广东省肇庆市";
$areanames{zh}->{861305938} = "广东省肇庆市";
$areanames{zh}->{861305939} = "广东省肇庆市";
$areanames{zh}->{86130594} = "广东省东莞市";
$areanames{zh}->{861305947} = "广东省肇庆市";
$areanames{zh}->{861305948} = "广东省肇庆市";
$areanames{zh}->{861305949} = "广东省肇庆市";
$areanames{zh}->{86130595} = "广东省惠州市";
$areanames{zh}->{861305957} = "广东省清远市";
$areanames{zh}->{861305958} = "广东省清远市";
$areanames{zh}->{861305959} = "广东省清远市";
$areanames{zh}->{86130596} = "浙江省丽水市";
$areanames{zh}->{86130597} = "浙江省衢州市";
$areanames{zh}->{86130598} = "浙江省舟山市";
$areanames{zh}->{86130599} = "浙江省湖州市";
$areanames{zh}->{86130600} = "四川省成都市";
$areanames{zh}->{861306010} = "四川省德阳市";
$areanames{zh}->{861306011} = "四川省德阳市";
$areanames{zh}->{861306012} = "四川省德阳市";
$areanames{zh}->{861306013} = "四川省攀枝花市";
$areanames{zh}->{861306014} = "四川省泸州市";
$areanames{zh}->{861306015} = "四川省泸州市";
$areanames{zh}->{861306016} = "四川省广元市";
$areanames{zh}->{861306017} = "四川省绵阳市";
$areanames{zh}->{861306018} = "四川省绵阳市";
$areanames{zh}->{861306019} = "四川省绵阳市";
$areanames{zh}->{86130602} = "重庆市";
$areanames{zh}->{861306030} = "陕西省渭南市";
$areanames{zh}->{861306031} = "陕西省渭南市";
$areanames{zh}->{861306032} = "陕西省渭南市";
$areanames{zh}->{861306033} = "陕西省渭南市";
$areanames{zh}->{861306034} = "陕西省咸阳市";
$areanames{zh}->{861306035} = "陕西省咸阳市";
$areanames{zh}->{861306036} = "陕西省咸阳市";
$areanames{zh}->{861306037} = "陕西省西安市";
$areanames{zh}->{861306038} = "陕西省西安市";
$areanames{zh}->{861306039} = "陕西省西安市";
$areanames{zh}->{861306040} = "陕西省西安市";
$areanames{zh}->{861306041} = "陕西省西安市";
$areanames{zh}->{861306042} = "陕西省西安市";
$areanames{zh}->{861306043} = "陕西省渭南市";
$areanames{zh}->{861306044} = "陕西省咸阳市";
$areanames{zh}->{861306045} = "陕西省汉中市";
$areanames{zh}->{861306046} = "陕西省汉中市";
$areanames{zh}->{861306047} = "陕西省宝鸡市";
$areanames{zh}->{861306048} = "陕西省宝鸡市";
$areanames{zh}->{861306049} = "陕西省宝鸡市";
$areanames{zh}->{861306050} = "广东省汕尾市";
$areanames{zh}->{861306051} = "广东省汕尾市";
$areanames{zh}->{861306052} = "广东省潮州市";
$areanames{zh}->{861306053} = "广东省潮州市";
$areanames{zh}->{861306054} = "广东省潮州市";
$areanames{zh}->{861306055} = "广东省揭阳市";
$areanames{zh}->{861306056} = "广东省揭阳市";
$areanames{zh}->{861306057} = "广东省揭阳市";
$areanames{zh}->{861306058} = "广东省揭阳市";
$areanames{zh}->{861306059} = "广东省揭阳市";
$areanames{zh}->{86130606} = "广东省广州市";
$areanames{zh}->{861306070} = "广东省梅州市";
$areanames{zh}->{861306071} = "广东省梅州市";
$areanames{zh}->{861306072} = "广东省梅州市";
$areanames{zh}->{861306073} = "广东省梅州市";
$areanames{zh}->{861306074} = "广东省梅州市";
$areanames{zh}->{861306075} = "广东省佛山市";
$areanames{zh}->{861306076} = "广东省佛山市";
$areanames{zh}->{861306077} = "广东省佛山市";
$areanames{zh}->{861306078} = "广东省佛山市";
$areanames{zh}->{861306079} = "广东省佛山市";
$areanames{zh}->{86130608} = "广东省广州市";
$areanames{zh}->{86130609} = "广东省广州市";
$areanames{zh}->{86130610} = "山东省滨州市";
$areanames{zh}->{861306107} = "山东省聊城市";
$areanames{zh}->{861306108} = "山东省聊城市";
$areanames{zh}->{861306109} = "山东省聊城市";
$areanames{zh}->{86130611} = "山东省威海市";
$areanames{zh}->{86130612} = "山东省青岛市";
$areanames{zh}->{86130613} = "山东省青岛市";
$areanames{zh}->{86130614} = "山东省青岛市";
$areanames{zh}->{86130615} = "山东省菏泽市";
$areanames{zh}->{861306150} = "山东省聊城市";
$areanames{zh}->{861306151} = "山东省聊城市";
$areanames{zh}->{861306152} = "山东省聊城市";
$areanames{zh}->{86130616} = "上海市";
$areanames{zh}->{86130617} = "上海市";
$areanames{zh}->{86130618} = "上海市";
$areanames{zh}->{86130619} = "上海市";
$areanames{zh}->{86130620} = "山东省枣庄市";
$areanames{zh}->{861306210} = "福建省三明市";
$areanames{zh}->{861306211} = "福建省三明市";
$areanames{zh}->{861306212} = "福建省三明市";
$areanames{zh}->{861306213} = "福建省莆田市";
$areanames{zh}->{861306214} = "福建省莆田市";
$areanames{zh}->{861306215} = "福建省莆田市";
$areanames{zh}->{861306216} = "福建省宁德市";
$areanames{zh}->{861306217} = "福建省宁德市";
$areanames{zh}->{861306218} = "福建省宁德市";
$areanames{zh}->{861306219} = "福建省宁德市";
$areanames{zh}->{86130622} = "福建省龙岩市";
$areanames{zh}->{861306226} = "福建省南平市";
$areanames{zh}->{861306227} = "福建省南平市";
$areanames{zh}->{861306228} = "福建省南平市";
$areanames{zh}->{861306229} = "福建省莆田市";
$areanames{zh}->{86130623} = "重庆市";
$areanames{zh}->{861306240} = "福建省漳州市";
$areanames{zh}->{861306241} = "福建省漳州市";
$areanames{zh}->{861306242} = "福建省漳州市";
$areanames{zh}->{861306243} = "福建省厦门市";
$areanames{zh}->{861306244} = "福建省厦门市";
$areanames{zh}->{861306245} = "福建省龙岩市";
$areanames{zh}->{861306246} = "福建省宁德市";
$areanames{zh}->{861306247} = "福建省南平市";
$areanames{zh}->{861306248} = "福建省三明市";
$areanames{zh}->{861306249} = "福建省三明市";
$areanames{zh}->{86130625} = "江苏省南京市";
$areanames{zh}->{86130626} = "上海市";
$areanames{zh}->{86130627} = "上海市";
$areanames{zh}->{86130628} = "上海市";
$areanames{zh}->{861306290} = "江苏省镇江市";
$areanames{zh}->{861306291} = "江苏省镇江市";
$areanames{zh}->{861306292} = "江苏省镇江市";
$areanames{zh}->{861306293} = "江苏省镇江市";
$areanames{zh}->{861306294} = "江苏省镇江市";
$areanames{zh}->{861306295} = "江苏省泰州市";
$areanames{zh}->{861306296} = "江苏省泰州市";
$areanames{zh}->{861306297} = "江苏省泰州市";
$areanames{zh}->{861306298} = "江苏省泰州市";
$areanames{zh}->{861306299} = "江苏省泰州市";
$areanames{zh}->{86130630} = "福建省厦门市";
$areanames{zh}->{861306300} = "福建省漳州市";
$areanames{zh}->{861306301} = "福建省漳州市";
$areanames{zh}->{861306302} = "福建省漳州市";
$areanames{zh}->{86130631} = "福建省漳州市";
$areanames{zh}->{861306320} = "安徽省马鞍山市";
$areanames{zh}->{861306321} = "安徽省合肥市";
$areanames{zh}->{861306322} = "安徽省黄山市";
$areanames{zh}->{861306323} = "安徽省宣城市";
$areanames{zh}->{861306324} = "安徽省宣城市";
$areanames{zh}->{861306325} = "安徽省铜陵市";
$areanames{zh}->{861306326} = "安徽省芜湖市";
$areanames{zh}->{861306327} = "安徽省安庆市";
$areanames{zh}->{861306328} = "安徽省安庆市";
$areanames{zh}->{861306329} = "安徽省池州市";
$areanames{zh}->{861306330} = "安徽省滁州市";
$areanames{zh}->{861306331} = "安徽省蚌埠市";
$areanames{zh}->{861306332} = "安徽省蚌埠市";
$areanames{zh}->{861306333} = "安徽省合肥市";
$areanames{zh}->{861306334} = "安徽省滁州市";
$areanames{zh}->{861306335} = "安徽省淮北市";
$areanames{zh}->{861306336} = "安徽省芜湖市";
$areanames{zh}->{861306337} = "安徽省阜阳市";
$areanames{zh}->{861306338} = "安徽省阜阳市";
$areanames{zh}->{861306339} = "安徽省亳州市";
$areanames{zh}->{861306340} = "安徽省宿州市";
$areanames{zh}->{861306341} = "安徽省安庆市";
$areanames{zh}->{861306342} = "安徽省六安市";
$areanames{zh}->{861306343} = "安徽省六安市";
$areanames{zh}->{861306344} = "安徽省合肥市";
$areanames{zh}->{861306345} = "安徽省合肥市";
$areanames{zh}->{861306346} = "安徽省淮南市";
$areanames{zh}->{861306347} = "安徽省淮南市";
$areanames{zh}->{861306348} = "安徽省合肥市";
$areanames{zh}->{861306349} = "安徽省合肥市";
$areanames{zh}->{861306350} = "江苏省徐州市";
$areanames{zh}->{861306351} = "江苏省徐州市";
$areanames{zh}->{861306352} = "江苏省徐州市";
$areanames{zh}->{861306353} = "江苏省徐州市";
$areanames{zh}->{861306354} = "江苏省徐州市";
$areanames{zh}->{861306355} = "江苏省南通市";
$areanames{zh}->{861306356} = "江苏省南通市";
$areanames{zh}->{861306357} = "江苏省南通市";
$areanames{zh}->{861306358} = "江苏省南通市";
$areanames{zh}->{861306359} = "江苏省南通市";
$areanames{zh}->{86130636} = "江苏省无锡市";
$areanames{zh}->{86130637} = "江苏省苏州市";
$areanames{zh}->{86130638} = "江苏省苏州市";
$areanames{zh}->{86130639} = "江苏省常州市";
$areanames{zh}->{86130640} = "山东省济南市";
$areanames{zh}->{861306410} = "江西省南昌市";
$areanames{zh}->{861306411} = "江西省南昌市";
$areanames{zh}->{861306412} = "江西省南昌市";
$areanames{zh}->{861306413} = "江西省南昌市";
$areanames{zh}->{861306414} = "江西省南昌市";
$areanames{zh}->{861306415} = "江西省九江市";
$areanames{zh}->{861306416} = "江西省九江市";
$areanames{zh}->{861306417} = "江西省九江市";
$areanames{zh}->{861306418} = "江西省九江市";
$areanames{zh}->{861306419} = "江西省九江市";
$areanames{zh}->{86130642} = "云南省昆明市";
$areanames{zh}->{861306430} = "四川省南充市";
$areanames{zh}->{861306431} = "四川省南充市";
$areanames{zh}->{861306432} = "四川省达州市";
$areanames{zh}->{861306433} = "四川省达州市";
$areanames{zh}->{861306434} = "四川省内江市";
$areanames{zh}->{861306435} = "四川省内江市";
$areanames{zh}->{861306436} = "四川省资阳市";
$areanames{zh}->{861306437} = "四川省资阳市";
$areanames{zh}->{861306438} = "四川省自贡市";
$areanames{zh}->{861306439} = "四川省自贡市";
$areanames{zh}->{861306440} = "河南省安阳市";
$areanames{zh}->{861306441} = "河南省安阳市";
$areanames{zh}->{861306442} = "河南省安阳市";
$areanames{zh}->{861306443} = "河南省安阳市";
$areanames{zh}->{861306444} = "河南省安阳市";
$areanames{zh}->{861306445} = "河南省平顶山市";
$areanames{zh}->{861306446} = "河南省平顶山市";
$areanames{zh}->{861306447} = "河南省平顶山市";
$areanames{zh}->{861306448} = "河南省平顶山市";
$areanames{zh}->{861306449} = "河南省平顶山市";
$areanames{zh}->{86130645} = "浙江省温州市";
$areanames{zh}->{86130646} = "浙江省金华市";
$areanames{zh}->{86130647} = "浙江省杭州市";
$areanames{zh}->{861306480} = "江苏省宿迁市";
$areanames{zh}->{861306481} = "江苏省宿迁市";
$areanames{zh}->{861306482} = "江苏省宿迁市";
$areanames{zh}->{861306483} = "江苏省盐城市";
$areanames{zh}->{861306484} = "江苏省盐城市";
$areanames{zh}->{861306485} = "江苏省盐城市";
$areanames{zh}->{861306486} = "江苏省盐城市";
$areanames{zh}->{861306487} = "江苏省盐城市";
$areanames{zh}->{861306488} = "江苏省扬州市";
$areanames{zh}->{861306489} = "江苏省扬州市";
$areanames{zh}->{861306490} = "江苏省淮安市";
$areanames{zh}->{861306491} = "江苏省淮安市";
$areanames{zh}->{861306492} = "江苏省淮安市";
$areanames{zh}->{861306493} = "江苏省淮安市";
$areanames{zh}->{861306494} = "江苏省连云港市";
$areanames{zh}->{861306495} = "江苏省连云港市";
$areanames{zh}->{861306496} = "江苏省连云港市";
$areanames{zh}->{861306497} = "江苏省连云港市";
$areanames{zh}->{861306498} = "江苏省扬州市";
$areanames{zh}->{861306499} = "江苏省扬州市";
$areanames{zh}->{86130650} = "山东省济南市";
$areanames{zh}->{86130651} = "江西省南昌市";
$areanames{zh}->{861306520} = "辽宁省铁岭市";
$areanames{zh}->{861306521} = "辽宁省铁岭市";
$areanames{zh}->{861306522} = "辽宁省铁岭市";
$areanames{zh}->{861306523} = "辽宁省铁岭市";
$areanames{zh}->{861306524} = "辽宁省铁岭市";
$areanames{zh}->{861306525} = "辽宁省盘锦市";
$areanames{zh}->{861306526} = "辽宁省盘锦市";
$areanames{zh}->{861306527} = "辽宁省盘锦市";
$areanames{zh}->{861306528} = "辽宁省盘锦市";
$areanames{zh}->{861306529} = "辽宁省盘锦市";
$areanames{zh}->{861306530} = "辽宁省阜新市";
$areanames{zh}->{861306531} = "辽宁省阜新市";
$areanames{zh}->{861306532} = "辽宁省阜新市";
$areanames{zh}->{861306533} = "辽宁省阜新市";
$areanames{zh}->{861306534} = "辽宁省阜新市";
$areanames{zh}->{861306535} = "辽宁省辽阳市";
$areanames{zh}->{861306536} = "辽宁省辽阳市";
$areanames{zh}->{861306537} = "辽宁省辽阳市";
$areanames{zh}->{861306538} = "辽宁省辽阳市";
$areanames{zh}->{861306539} = "辽宁省辽阳市";
$areanames{zh}->{86130654} = "辽宁省鞍山市";
$areanames{zh}->{86130655} = "浙江省绍兴市";
$areanames{zh}->{86130656} = "浙江省宁波市";
$areanames{zh}->{861306570} = "浙江省杭州市";
$areanames{zh}->{861306571} = "浙江省杭州市";
$areanames{zh}->{861306572} = "浙江省杭州市";
$areanames{zh}->{861306573} = "浙江省杭州市";
$areanames{zh}->{861306574} = "浙江省杭州市";
$areanames{zh}->{861306575} = "浙江省绍兴市";
$areanames{zh}->{861306576} = "浙江省绍兴市";
$areanames{zh}->{861306577} = "浙江省绍兴市";
$areanames{zh}->{861306578} = "浙江省绍兴市";
$areanames{zh}->{861306579} = "浙江省绍兴市";
$areanames{zh}->{86130658} = "浙江省宁波市";
$areanames{zh}->{86130659} = "浙江省金华市";
$areanames{zh}->{86130660} = "山东省日照市";
$areanames{zh}->{861306600} = "山东省济南市";
$areanames{zh}->{861306601} = "山东省济南市";
$areanames{zh}->{861306602} = "山东省济南市";
$areanames{zh}->{861306603} = "山东省济南市";
$areanames{zh}->{86130661} = "广东省东莞市";
$areanames{zh}->{86130662} = "广东省江门市";
$areanames{zh}->{86130663} = "广东省广州市";
$areanames{zh}->{86130664} = "广东省佛山市";
$areanames{zh}->{861306640} = "广东省江门市";
$areanames{zh}->{861306641} = "广东省江门市";
$areanames{zh}->{861306642} = "广东省江门市";
$areanames{zh}->{861306643} = "广东省江门市";
$areanames{zh}->{86130665} = "辽宁省沈阳市";
$areanames{zh}->{86130666} = "辽宁省沈阳市";
$areanames{zh}->{86130667} = "辽宁省沈阳市";
$areanames{zh}->{86130668} = "广东省深圳市";
$areanames{zh}->{86130669} = "广东省深圳市";
$areanames{zh}->{86130670} = "福建省泉州市";
$areanames{zh}->{861306700} = "福建省三明市";
$areanames{zh}->{861306701} = "福建省三明市";
$areanames{zh}->{86130671} = "福建省泉州市";
$areanames{zh}->{861306710} = "福建省福州市";
$areanames{zh}->{861306711} = "福建省福州市";
$areanames{zh}->{86130672} = "福建省福州市";
$areanames{zh}->{86130673} = "福建省福州市";
$areanames{zh}->{86130674} = "福建省福州市";
$areanames{zh}->{861306747} = "福建省泉州市";
$areanames{zh}->{861306748} = "福建省泉州市";
$areanames{zh}->{861306749} = "福建省泉州市";
$areanames{zh}->{86130675} = "浙江省嘉兴市";
$areanames{zh}->{86130676} = "浙江省嘉兴市";
$areanames{zh}->{86130677} = "浙江省杭州市";
$areanames{zh}->{86130678} = "浙江省杭州市";
$areanames{zh}->{86130679} = "浙江省杭州市";
$areanames{zh}->{861306800} = "山西省太原市";
$areanames{zh}->{861306801} = "山西省运城市";
$areanames{zh}->{861306802} = "山西省临汾市";
$areanames{zh}->{861306803} = "山西省晋中市";
$areanames{zh}->{861306804} = "山西省太原市";
$areanames{zh}->{861306805} = "山西省晋城市";
$areanames{zh}->{861306806} = "山西省长治市";
$areanames{zh}->{861306807} = "山西省太原市";
$areanames{zh}->{861306808} = "山西省太原市";
$areanames{zh}->{861306809} = "山西省大同市";
$areanames{zh}->{86130681} = "广东省中山市";
$areanames{zh}->{86130682} = "广东省惠州市";
$areanames{zh}->{86130683} = "重庆市";
$areanames{zh}->{86130684} = "广东省深圳市";
$areanames{zh}->{861306850} = "广东省茂名市";
$areanames{zh}->{861306851} = "广东省茂名市";
$areanames{zh}->{861306852} = "广东省茂名市";
$areanames{zh}->{861306853} = "广东省茂名市";
$areanames{zh}->{861306854} = "广东省阳江市";
$areanames{zh}->{861306855} = "广东省阳江市";
$areanames{zh}->{861306856} = "广东省阳江市";
$areanames{zh}->{861306857} = "广东省河源市";
$areanames{zh}->{861306858} = "广东省河源市";
$areanames{zh}->{861306859} = "广东省河源市";
$areanames{zh}->{86130686} = "广东省佛山市";
$areanames{zh}->{86130687} = "广东省深圳市";
$areanames{zh}->{861306875} = "河北省石家庄市";
$areanames{zh}->{861306876} = "河北省石家庄市";
$areanames{zh}->{861306877} = "河北省石家庄市";
$areanames{zh}->{861306879} = "河北省石家庄市";
$areanames{zh}->{86130688} = "广东省广州市";
$areanames{zh}->{86130689} = "广东省汕头市";
$areanames{zh}->{861306900} = "吉林省长春市";
$areanames{zh}->{861306901} = "吉林省长春市";
$areanames{zh}->{861306902} = "吉林省四平市";
$areanames{zh}->{861306903} = "吉林省四平市";
$areanames{zh}->{861306904} = "吉林省长春市";
$areanames{zh}->{861306905} = "吉林省松原市";
$areanames{zh}->{861306906} = "吉林省松原市";
$areanames{zh}->{861306907} = "吉林省通化市";
$areanames{zh}->{861306908} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861306909} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861306910} = "吉林省长春市";
$areanames{zh}->{861306911} = "吉林省长春市";
$areanames{zh}->{861306912} = "吉林省长春市";
$areanames{zh}->{861306913} = "吉林省长春市";
$areanames{zh}->{861306914} = "吉林省长春市";
$areanames{zh}->{861306915} = "吉林省吉林市";
$areanames{zh}->{861306916} = "吉林省吉林市";
$areanames{zh}->{861306917} = "吉林省吉林市";
$areanames{zh}->{861306918} = "吉林省吉林市";
$areanames{zh}->{861306919} = "吉林省通化市";
$areanames{zh}->{861306920} = "吉林省长春市";
$areanames{zh}->{861306921} = "吉林省长春市";
$areanames{zh}->{861306922} = "吉林省四平市";
$areanames{zh}->{861306923} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861306924} = "吉林省长春市";
$areanames{zh}->{861306925} = "吉林省松原市";
$areanames{zh}->{861306926} = "吉林省松原市";
$areanames{zh}->{861306927} = "吉林省通化市";
$areanames{zh}->{861306928} = "吉林省四平市";
$areanames{zh}->{861306929} = "吉林省通化市";
$areanames{zh}->{861306930} = "河南省开封市";
$areanames{zh}->{861306931} = "河南省开封市";
$areanames{zh}->{861306932} = "河南省开封市";
$areanames{zh}->{861306933} = "河南省开封市";
$areanames{zh}->{861306934} = "河南省开封市";
$areanames{zh}->{861306935} = "河南省新乡市";
$areanames{zh}->{861306936} = "河南省新乡市";
$areanames{zh}->{861306937} = "河南省新乡市";
$areanames{zh}->{861306938} = "河南省新乡市";
$areanames{zh}->{861306939} = "河南省新乡市";
$areanames{zh}->{86130694} = "河南省焦作市";
$areanames{zh}->{861306950} = "河南省许昌市";
$areanames{zh}->{861306951} = "河南省许昌市";
$areanames{zh}->{861306952} = "河南省许昌市";
$areanames{zh}->{861306953} = "河南省许昌市";
$areanames{zh}->{861306954} = "河南省许昌市";
$areanames{zh}->{861306955} = "河南省漯河市";
$areanames{zh}->{861306956} = "河南省漯河市";
$areanames{zh}->{861306957} = "河南省漯河市";
$areanames{zh}->{861306958} = "河南省漯河市";
$areanames{zh}->{861306959} = "河南省漯河市";
$areanames{zh}->{86130696} = "黑龙江省大庆市";
$areanames{zh}->{861306963} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861306968} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861306970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861306974} = "黑龙江省大庆市";
$areanames{zh}->{861306975} = "黑龙江省佳木斯市";
$areanames{zh}->{861306976} = "黑龙江省佳木斯市";
$areanames{zh}->{861306977} = "黑龙江省绥化市";
$areanames{zh}->{861306978} = "黑龙江省牡丹江市";
$areanames{zh}->{861306979} = "黑龙江省牡丹江市";
$areanames{zh}->{861306980} = "黑龙江省鸡西市";
$areanames{zh}->{861306981} = "黑龙江省鸡西市";
$areanames{zh}->{861306982} = "黑龙江省牡丹江市";
$areanames{zh}->{861306983} = "黑龙江省牡丹江市";
$areanames{zh}->{861306984} = "黑龙江省七台河市";
$areanames{zh}->{861306985} = "黑龙江省七台河市";
$areanames{zh}->{861306986} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306987} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306988} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306989} = "黑龙江省哈尔滨市";
$areanames{zh}->{861306990} = "黑龙江省双鸭山市";
$areanames{zh}->{861306991} = "黑龙江省双鸭山市";
$areanames{zh}->{861306992} = "黑龙江省佳木斯市";
$areanames{zh}->{861306993} = "黑龙江省佳木斯市";
$areanames{zh}->{861306994} = "黑龙江省鹤岗市";
$areanames{zh}->{861306995} = "黑龙江省鹤岗市";
$areanames{zh}->{861306996} = "黑龙江省绥化市";
$areanames{zh}->{861306997} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861306998} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861306999} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861307000} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861307001} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861307002} = "新疆阿克苏地区";
$areanames{zh}->{861307003} = "新疆阿克苏地区";
$areanames{zh}->{861307004} = "新疆喀什地区";
$areanames{zh}->{861307005} = "新疆喀什地区";
$areanames{zh}->{861307006} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861307007} = "新疆和田地区";
$areanames{zh}->{861307008} = "新疆和田地区";
$areanames{zh}->{861307009} = "新疆石河子市";
$areanames{zh}->{86130701} = "北京市";
$areanames{zh}->{86130702} = "广东省广州市";
$areanames{zh}->{861307030} = "新疆塔城地区";
$areanames{zh}->{861307031} = "新疆塔城地区";
$areanames{zh}->{861307032} = "新疆阿勒泰地区";
$areanames{zh}->{861307033} = "新疆阿勒泰地区";
$areanames{zh}->{861307034} = "新疆吐鲁番地区";
$areanames{zh}->{861307035} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861307036} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861307037} = "新疆克拉玛依市";
$areanames{zh}->{861307038} = "新疆昌吉回族自治州";
$areanames{zh}->{861307039} = "新疆克拉玛依市";
$areanames{zh}->{86130704} = "新疆乌鲁木齐市";
$areanames{zh}->{861307046} = "新疆克拉玛依市";
$areanames{zh}->{861307047} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861307048} = "新疆哈密地区";
$areanames{zh}->{861307049} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86130705} = "河北省保定市";
$areanames{zh}->{86130706} = "山东省淄博市";
$areanames{zh}->{86130707} = "山东省潍坊市";
$areanames{zh}->{86130708} = "山东省青岛市";
$areanames{zh}->{86130709} = "广东省东莞市";
$areanames{zh}->{86130710} = "河南省郑州市";
$areanames{zh}->{86130711} = "北京市";
$areanames{zh}->{86130712} = "湖北省武汉市";
$areanames{zh}->{86130713} = "广东省东莞市";
$areanames{zh}->{86130714} = "广东省江门市";
$areanames{zh}->{86130715} = "广东省汕尾市";
$areanames{zh}->{86130716} = "广东省茂名市";
$areanames{zh}->{86130717} = "河南省平顶山市";
$areanames{zh}->{86130718} = "浙江省杭州市";
$areanames{zh}->{86130719} = "浙江省宁波市";
$areanames{zh}->{86130720} = "天津市";
$areanames{zh}->{86130721} = "上海市";
$areanames{zh}->{86130722} = "天津市";
$areanames{zh}->{86130723} = "重庆市";
$areanames{zh}->{86130724} = "辽宁省沈阳市";
$areanames{zh}->{86130725} = "江苏省南京市";
$areanames{zh}->{86130726} = "河南省新乡市";
$areanames{zh}->{86130727} = "湖北省武汉市";
$areanames{zh}->{86130728} = "四川省成都市";
$areanames{zh}->{86130729} = "陕西省西安市";
$areanames{zh}->{86130730} = "广东省广州市";
$areanames{zh}->{86130731} = "河北省石家庄市";
$areanames{zh}->{86130732} = "江苏省南通市";
$areanames{zh}->{86130733} = "江苏省苏州市";
$areanames{zh}->{86130734} = "江苏省南京市";
$areanames{zh}->{86130735} = "山西省太原市";
$areanames{zh}->{86130736} = "浙江省杭州市";
$areanames{zh}->{86130737} = "河南省郑州市";
$areanames{zh}->{86130738} = "浙江省台州市";
$areanames{zh}->{86130739} = "福建省宁德市";
$areanames{zh}->{86130740} = "安徽省安庆市";
$areanames{zh}->{86130741} = "辽宁省大连市";
$areanames{zh}->{86130742} = "广东省佛山市";
$areanames{zh}->{86130743} = "吉林省长春市";
$areanames{zh}->{86130744} = "广东省肇庆市";
$areanames{zh}->{86130745} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130746} = "浙江省温州市";
$areanames{zh}->{86130747} = "内蒙古呼和浩特市";
$areanames{zh}->{86130748} = "福建省厦门市";
$areanames{zh}->{86130749} = "福建省泉州市";
$areanames{zh}->{861307494} = "河南省信阳市";
$areanames{zh}->{86130750} = "安徽省阜阳市";
$areanames{zh}->{861307501} = "安徽省亳州市";
$areanames{zh}->{861307503} = "安徽省亳州市";
$areanames{zh}->{861307504} = "安徽省亳州市";
$areanames{zh}->{861307507} = "安徽省亳州市";
$areanames{zh}->{86130751} = "广东省梅州市";
$areanames{zh}->{86130752} = "广东省惠州市";
$areanames{zh}->{86130753} = "山东省济南市";
$areanames{zh}->{86130754} = "重庆市";
$areanames{zh}->{86130755} = "安徽省合肥市";
$areanames{zh}->{86130756} = "广东省珠海市";
$areanames{zh}->{86130757} = "浙江省温州市";
$areanames{zh}->{86130758} = "福建省福州市";
$areanames{zh}->{86130759} = "福建省福州市";
$areanames{zh}->{86130760} = "四川省成都市";
$areanames{zh}->{86130761} = "广东省河源市";
$areanames{zh}->{86130762} = "广东省韶关市";
$areanames{zh}->{86130763} = "广东省汕头市";
$areanames{zh}->{86130764} = "广东省潮州市";
$areanames{zh}->{86130765} = "广东省揭阳市";
$areanames{zh}->{86130766} = "广东省清远市";
$areanames{zh}->{86130767} = "广东省广州市";
$areanames{zh}->{86130768} = "广东省广州市";
$areanames{zh}->{86130769} = "广东省深圳市";
$areanames{zh}->{86130770} = "湖南省株洲市";
$areanames{zh}->{86130771} = "湖南省岳阳市";
$areanames{zh}->{86130772} = "湖南省常德市";
$areanames{zh}->{86130773} = "湖南省长沙市";
$areanames{zh}->{86130774} = "广东省佛山市";
$areanames{zh}->{86130775} = "广东省云浮市";
$areanames{zh}->{86130776} = "广西桂林市";
$areanames{zh}->{86130777} = "广西南宁市";
$areanames{zh}->{86130778} = "广东省深圳市";
$areanames{zh}->{86130779} = "江西省南昌市";
$areanames{zh}->{86130780} = "广西柳州市";
$areanames{zh}->{86130781} = "广东省佛山市";
$areanames{zh}->{86130782} = "广东省湛江市";
$areanames{zh}->{86130783} = "广东省阳江市";
$areanames{zh}->{86130784} = "广东省佛山市";
$areanames{zh}->{86130785} = "贵州省贵阳市";
$areanames{zh}->{86130786} = "广东省中山市";
$areanames{zh}->{86130787} = "云南省昆明市";
$areanames{zh}->{86130788} = "广东省广州市";
$areanames{zh}->{86130789} = "海南省海口市";
$areanames{zh}->{86130790} = "四川省达州市";
$areanames{zh}->{86130791} = "四川省泸州市";
$areanames{zh}->{86130792} = "辽宁省沈阳市";
$areanames{zh}->{861307930} = "甘肃省嘉峪关市";
$areanames{zh}->{861307931} = "甘肃省嘉峪关市";
$areanames{zh}->{861307932} = "甘肃省嘉峪关市";
$areanames{zh}->{861307933} = "甘肃省武威市";
$areanames{zh}->{861307934} = "甘肃省定西市";
$areanames{zh}->{861307935} = "甘肃省武威市";
$areanames{zh}->{861307936} = "甘肃省定西市";
$areanames{zh}->{861307937} = "甘肃省武威市";
$areanames{zh}->{861307938} = "甘肃省嘉峪关市";
$areanames{zh}->{861307939} = "甘肃省武威市";
$areanames{zh}->{86130794} = "辽宁省营口市";
$areanames{zh}->{861307950} = "宁夏银川市";
$areanames{zh}->{861307951} = "宁夏银川市";
$areanames{zh}->{861307952} = "宁夏石嘴山市";
$areanames{zh}->{861307953} = "宁夏吴忠市";
$areanames{zh}->{861307954} = "宁夏固原市";
$areanames{zh}->{861307955} = "宁夏吴忠市";
$areanames{zh}->{861307956} = "宁夏石嘴山市";
$areanames{zh}->{861307957} = "宁夏吴忠市";
$areanames{zh}->{861307958} = "宁夏银川市";
$areanames{zh}->{861307959} = "宁夏银川市";
$areanames{zh}->{86130796} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{86130797} = "吉林省吉林市";
$areanames{zh}->{86130798} = "辽宁省大连市";
$areanames{zh}->{86130799} = "新疆乌鲁木齐市";
$areanames{zh}->{861308000} = "吉林省通化市";
$areanames{zh}->{861308001} = "吉林省长春市";
$areanames{zh}->{861308002} = "吉林省长春市";
$areanames{zh}->{861308003} = "吉林省长春市";
$areanames{zh}->{861308004} = "吉林省长春市";
$areanames{zh}->{861308005} = "吉林省通化市";
$areanames{zh}->{861308006} = "吉林省白城市";
$areanames{zh}->{861308007} = "吉林省松原市";
$areanames{zh}->{861308008} = "吉林省松原市";
$areanames{zh}->{861308009} = "吉林省松原市";
$areanames{zh}->{861308010} = "河南省濮阳市";
$areanames{zh}->{861308011} = "河南省濮阳市";
$areanames{zh}->{861308012} = "河南省濮阳市";
$areanames{zh}->{861308013} = "河南省漯河市";
$areanames{zh}->{861308014} = "河南省漯河市";
$areanames{zh}->{861308015} = "河南省许昌市";
$areanames{zh}->{861308016} = "河南省许昌市";
$areanames{zh}->{861308017} = "河南省许昌市";
$areanames{zh}->{861308018} = "河南省许昌市";
$areanames{zh}->{861308019} = "河南省许昌市";
$areanames{zh}->{861308020} = "内蒙古呼和浩特市";
$areanames{zh}->{861308021} = "内蒙古包头市";
$areanames{zh}->{861308022} = "内蒙古包头市";
$areanames{zh}->{861308023} = "内蒙古兴安盟";
$areanames{zh}->{861308024} = "内蒙古通辽市";
$areanames{zh}->{861308025} = "内蒙古通辽市";
$areanames{zh}->{861308026} = "内蒙古赤峰市";
$areanames{zh}->{861308027} = "内蒙古赤峰市";
$areanames{zh}->{861308028} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308029} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861308030} = "山西省忻州市";
$areanames{zh}->{861308031} = "山西省太原市";
$areanames{zh}->{861308032} = "山西省大同市";
$areanames{zh}->{861308033} = "山西省阳泉市";
$areanames{zh}->{861308034} = "山西省运城市";
$areanames{zh}->{861308035} = "山西省长治市";
$areanames{zh}->{861308036} = "山西省晋城市";
$areanames{zh}->{861308037} = "山西省临汾市";
$areanames{zh}->{861308038} = "山西省吕梁市";
$areanames{zh}->{861308039} = "山西省朔州市";
$areanames{zh}->{861308040} = "河北省邯郸市";
$areanames{zh}->{861308041} = "河北省石家庄市";
$areanames{zh}->{861308042} = "河北省保定市";
$areanames{zh}->{861308043} = "河北省张家口市";
$areanames{zh}->{861308044} = "河北省邯郸市";
$areanames{zh}->{861308045} = "河北省唐山市";
$areanames{zh}->{861308046} = "河北省石家庄市";
$areanames{zh}->{861308047} = "河北省沧州市";
$areanames{zh}->{861308048} = "河北省唐山市";
$areanames{zh}->{861308049} = "河北省保定市";
$areanames{zh}->{86130805} = "湖南省长沙市";
$areanames{zh}->{861308057} = "湖南省益阳市";
$areanames{zh}->{861308058} = "湖南省益阳市";
$areanames{zh}->{861308059} = "湖南省益阳市";
$areanames{zh}->{86130806} = "湖北省武汉市";
$areanames{zh}->{86130807} = "辽宁省沈阳市";
$areanames{zh}->{86130808} = "辽宁省沈阳市";
$areanames{zh}->{861308090} = "陕西省西安市";
$areanames{zh}->{861308091} = "陕西省西安市";
$areanames{zh}->{861308092} = "陕西省西安市";
$areanames{zh}->{861308093} = "陕西省西安市";
$areanames{zh}->{861308094} = "陕西省延安市";
$areanames{zh}->{861308095} = "陕西省延安市";
$areanames{zh}->{861308096} = "陕西省榆林市";
$areanames{zh}->{861308097} = "陕西省榆林市";
$areanames{zh}->{861308098} = "陕西省榆林市";
$areanames{zh}->{861308099} = "陕西省商洛市";
$areanames{zh}->{86130810} = "河北省石家庄市";
$areanames{zh}->{86130811} = "河北省唐山市";
$areanames{zh}->{861308110} = "河北省石家庄市";
$areanames{zh}->{861308111} = "河北省石家庄市";
$areanames{zh}->{861308112} = "河北省石家庄市";
$areanames{zh}->{861308120} = "辽宁省鞍山市";
$areanames{zh}->{861308121} = "辽宁省鞍山市";
$areanames{zh}->{861308122} = "辽宁省鞍山市";
$areanames{zh}->{861308123} = "辽宁省鞍山市";
$areanames{zh}->{861308124} = "辽宁省鞍山市";
$areanames{zh}->{861308125} = "辽宁省丹东市";
$areanames{zh}->{861308126} = "辽宁省丹东市";
$areanames{zh}->{861308127} = "辽宁省锦州市";
$areanames{zh}->{861308128} = "辽宁省锦州市";
$areanames{zh}->{861308129} = "辽宁省锦州市";
$areanames{zh}->{861308130} = "辽宁省抚顺市";
$areanames{zh}->{861308131} = "辽宁省抚顺市";
$areanames{zh}->{861308132} = "辽宁省抚顺市";
$areanames{zh}->{861308133} = "辽宁省抚顺市";
$areanames{zh}->{861308134} = "辽宁省抚顺市";
$areanames{zh}->{861308135} = "辽宁省本溪市";
$areanames{zh}->{861308136} = "辽宁省本溪市";
$areanames{zh}->{861308137} = "辽宁省本溪市";
$areanames{zh}->{861308138} = "辽宁省本溪市";
$areanames{zh}->{861308139} = "辽宁省本溪市";
$areanames{zh}->{861308140} = "山东省东营市";
$areanames{zh}->{861308141} = "山东省东营市";
$areanames{zh}->{861308142} = "山东省济南市";
$areanames{zh}->{861308143} = "山东省潍坊市";
$areanames{zh}->{861308144} = "山东省潍坊市";
$areanames{zh}->{861308145} = "山东省潍坊市";
$areanames{zh}->{861308146} = "山东省聊城市";
$areanames{zh}->{861308147} = "山东省泰安市";
$areanames{zh}->{861308148} = "山东省菏泽市";
$areanames{zh}->{861308149} = "山东省威海市";
$areanames{zh}->{861308150} = "内蒙古呼和浩特市";
$areanames{zh}->{861308151} = "内蒙古呼和浩特市";
$areanames{zh}->{861308152} = "内蒙古呼和浩特市";
$areanames{zh}->{861308153} = "内蒙古包头市";
$areanames{zh}->{861308154} = "内蒙古包头市";
$areanames{zh}->{861308155} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861308156} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308157} = "内蒙古赤峰市";
$areanames{zh}->{861308158} = "内蒙古兴安盟";
$areanames{zh}->{861308159} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861308160} = "山东省烟台市";
$areanames{zh}->{861308161} = "山东省烟台市";
$areanames{zh}->{861308162} = "山东省烟台市";
$areanames{zh}->{861308163} = "山东省烟台市";
$areanames{zh}->{861308164} = "山东省烟台市";
$areanames{zh}->{861308165} = "山东省潍坊市";
$areanames{zh}->{861308166} = "山东省潍坊市";
$areanames{zh}->{861308167} = "山东省潍坊市";
$areanames{zh}->{861308168} = "山东省潍坊市";
$areanames{zh}->{861308169} = "山东省潍坊市";
$areanames{zh}->{861308170} = "辽宁省营口市";
$areanames{zh}->{861308171} = "辽宁省营口市";
$areanames{zh}->{861308172} = "辽宁省营口市";
$areanames{zh}->{861308173} = "辽宁省营口市";
$areanames{zh}->{861308174} = "辽宁省阜新市";
$areanames{zh}->{861308175} = "辽宁省辽阳市";
$areanames{zh}->{861308176} = "辽宁省辽阳市";
$areanames{zh}->{861308177} = "辽宁省辽阳市";
$areanames{zh}->{861308178} = "辽宁省辽阳市";
$areanames{zh}->{861308179} = "辽宁省铁岭市";
$areanames{zh}->{861308180} = "河北省衡水市";
$areanames{zh}->{861308181} = "河北省衡水市";
$areanames{zh}->{861308182} = "河北省张家口市";
$areanames{zh}->{861308183} = "河北省张家口市";
$areanames{zh}->{861308184} = "河北省秦皇岛市";
$areanames{zh}->{861308185} = "河北省秦皇岛市";
$areanames{zh}->{861308186} = "河北省秦皇岛市";
$areanames{zh}->{861308187} = "河北省秦皇岛市";
$areanames{zh}->{861308188} = "河北省秦皇岛市";
$areanames{zh}->{861308189} = "河北省承德市";
$areanames{zh}->{86130819} = "浙江省宁波市";
$areanames{zh}->{86130820} = "河北省廊坊市";
$areanames{zh}->{861308200} = "河北省邢台市";
$areanames{zh}->{861308201} = "河北省邢台市";
$areanames{zh}->{861308202} = "河北省邢台市";
$areanames{zh}->{861308203} = "河北省邢台市";
$areanames{zh}->{86130821} = "河北省邯郸市";
$areanames{zh}->{861308216} = "河北省沧州市";
$areanames{zh}->{861308217} = "河北省沧州市";
$areanames{zh}->{861308218} = "河北省沧州市";
$areanames{zh}->{861308219} = "河北省沧州市";
$areanames{zh}->{861308220} = "辽宁省朝阳市";
$areanames{zh}->{861308221} = "辽宁省朝阳市";
$areanames{zh}->{861308222} = "辽宁省盘锦市";
$areanames{zh}->{861308223} = "辽宁省盘锦市";
$areanames{zh}->{861308224} = "辽宁省葫芦岛市";
$areanames{zh}->{861308225} = "辽宁省鞍山市";
$areanames{zh}->{861308226} = "辽宁省鞍山市";
$areanames{zh}->{861308227} = "辽宁省抚顺市";
$areanames{zh}->{861308228} = "辽宁省抚顺市";
$areanames{zh}->{861308229} = "辽宁省营口市";
$areanames{zh}->{86130823} = "河北省保定市";
$areanames{zh}->{86130824} = "辽宁省沈阳市";
$areanames{zh}->{861308250} = "江苏省常州市";
$areanames{zh}->{861308251} = "江苏省常州市";
$areanames{zh}->{861308252} = "江苏省苏州市";
$areanames{zh}->{861308253} = "江苏省连云港市";
$areanames{zh}->{861308254} = "江苏省南京市";
$areanames{zh}->{861308255} = "江苏省南京市";
$areanames{zh}->{861308256} = "江苏省扬州市";
$areanames{zh}->{861308257} = "江苏省扬州市";
$areanames{zh}->{861308258} = "江苏省宿迁市";
$areanames{zh}->{861308259} = "江苏省盐城市";
$areanames{zh}->{861308260} = "山东省东营市";
$areanames{zh}->{861308261} = "山东省东营市";
$areanames{zh}->{861308262} = "山东省济宁市";
$areanames{zh}->{861308263} = "山东省济宁市";
$areanames{zh}->{861308264} = "山东省临沂市";
$areanames{zh}->{861308265} = "山东省临沂市";
$areanames{zh}->{861308266} = "山东省临沂市";
$areanames{zh}->{861308267} = "山东省威海市";
$areanames{zh}->{861308268} = "山东省威海市";
$areanames{zh}->{861308269} = "山东省菏泽市";
$areanames{zh}->{861308270} = "山东省淄博市";
$areanames{zh}->{861308271} = "山东省淄博市";
$areanames{zh}->{861308272} = "山东省滨州市";
$areanames{zh}->{861308273} = "山东省济南市";
$areanames{zh}->{861308274} = "山东省济南市";
$areanames{zh}->{861308275} = "山东省济南市";
$areanames{zh}->{861308276} = "山东省德州市";
$areanames{zh}->{861308277} = "山东省泰安市";
$areanames{zh}->{861308278} = "山东省聊城市";
$areanames{zh}->{861308279} = "山东省日照市";
$areanames{zh}->{86130828} = "浙江省杭州市";
$areanames{zh}->{861308286} = "浙江省舟山市";
$areanames{zh}->{861308287} = "浙江省舟山市";
$areanames{zh}->{861308288} = "浙江省衢州市";
$areanames{zh}->{861308289} = "浙江省丽水市";
$areanames{zh}->{86130829} = "浙江省宁波市";
$areanames{zh}->{861308300} = "安徽省合肥市";
$areanames{zh}->{861308301} = "安徽省蚌埠市";
$areanames{zh}->{861308302} = "安徽省宿州市";
$areanames{zh}->{861308303} = "安徽省芜湖市";
$areanames{zh}->{861308304} = "安徽省池州市";
$areanames{zh}->{861308305} = "安徽省合肥市";
$areanames{zh}->{861308306} = "安徽省合肥市";
$areanames{zh}->{861308307} = "安徽省淮南市";
$areanames{zh}->{861308308} = "安徽省合肥市";
$areanames{zh}->{861308309} = "安徽省合肥市";
$areanames{zh}->{861308310} = "安徽省马鞍山市";
$areanames{zh}->{861308311} = "安徽省马鞍山市";
$areanames{zh}->{861308312} = "安徽省宣城市";
$areanames{zh}->{861308313} = "安徽省宣城市";
$areanames{zh}->{861308314} = "安徽省滁州市";
$areanames{zh}->{861308315} = "安徽省铜陵市";
$areanames{zh}->{861308316} = "安徽省安庆市";
$areanames{zh}->{861308317} = "安徽省安庆市";
$areanames{zh}->{861308318} = "安徽省安庆市";
$areanames{zh}->{861308319} = "安徽省合肥市";
$areanames{zh}->{861308320} = "安徽省马鞍山市";
$areanames{zh}->{861308321} = "安徽省芜湖市";
$areanames{zh}->{861308322} = "安徽省黄山市";
$areanames{zh}->{861308323} = "安徽省黄山市";
$areanames{zh}->{861308324} = "安徽省宣城市";
$areanames{zh}->{861308325} = "安徽省铜陵市";
$areanames{zh}->{861308326} = "安徽省芜湖市";
$areanames{zh}->{861308327} = "安徽省蚌埠市";
$areanames{zh}->{861308328} = "安徽省池州市";
$areanames{zh}->{861308329} = "安徽省池州市";
$areanames{zh}->{861308330} = "安徽省滁州市";
$areanames{zh}->{861308331} = "安徽省滁州市";
$areanames{zh}->{861308332} = "安徽省滁州市";
$areanames{zh}->{861308333} = "安徽省滁州市";
$areanames{zh}->{861308334} = "安徽省阜阳市";
$areanames{zh}->{861308335} = "安徽省淮北市";
$areanames{zh}->{861308336} = "安徽省亳州市";
$areanames{zh}->{861308337} = "安徽省阜阳市";
$areanames{zh}->{861308338} = "安徽省亳州市";
$areanames{zh}->{861308339} = "安徽省阜阳市";
$areanames{zh}->{86130834} = "安徽省合肥市";
$areanames{zh}->{861308343} = "安徽省铜陵市";
$areanames{zh}->{861308346} = "安徽省淮南市";
$areanames{zh}->{861308347} = "安徽省阜阳市";
$areanames{zh}->{861308350} = "江苏省无锡市";
$areanames{zh}->{861308351} = "江苏省无锡市";
$areanames{zh}->{861308352} = "江苏省苏州市";
$areanames{zh}->{861308353} = "江苏省徐州市";
$areanames{zh}->{861308354} = "江苏省徐州市";
$areanames{zh}->{861308355} = "江苏省淮安市";
$areanames{zh}->{861308356} = "江苏省南通市";
$areanames{zh}->{861308357} = "江苏省南通市";
$areanames{zh}->{861308358} = "江苏省泰州市";
$areanames{zh}->{861308359} = "江苏省镇江市";
$areanames{zh}->{861308360} = "河南省郑州市";
$areanames{zh}->{861308361} = "河南省许昌市";
$areanames{zh}->{861308362} = "河南省洛阳市";
$areanames{zh}->{861308363} = "河南省洛阳市";
$areanames{zh}->{861308364} = "河南省洛阳市";
$areanames{zh}->{861308365} = "河南省洛阳市";
$areanames{zh}->{861308366} = "河南省郑州市";
$areanames{zh}->{861308367} = "河南省焦作市";
$areanames{zh}->{861308368} = "河南省焦作市";
$areanames{zh}->{861308369} = "河南省郑州市";
$areanames{zh}->{861308370} = "河南省商丘市";
$areanames{zh}->{861308371} = "河南省郑州市";
$areanames{zh}->{861308372} = "河南省安阳市";
$areanames{zh}->{861308373} = "河南省新乡市";
$areanames{zh}->{861308374} = "河南省许昌市";
$areanames{zh}->{861308375} = "河南省平顶山市";
$areanames{zh}->{861308376} = "河南省信阳市";
$areanames{zh}->{861308377} = "河南省南阳市";
$areanames{zh}->{861308378} = "河南省开封市";
$areanames{zh}->{861308379} = "河南省洛阳市";
$areanames{zh}->{861308380} = "河南省新乡市";
$areanames{zh}->{861308381} = "河南省新乡市";
$areanames{zh}->{861308382} = "河南省新乡市";
$areanames{zh}->{861308383} = "河南省焦作市";
$areanames{zh}->{861308384} = "河南省焦作市";
$areanames{zh}->{861308385} = "河南省安阳市";
$areanames{zh}->{861308386} = "河南省安阳市";
$areanames{zh}->{861308387} = "河南省安阳市";
$areanames{zh}->{861308388} = "河南省开封市";
$areanames{zh}->{861308389} = "河南省濮阳市";
$areanames{zh}->{861308390} = "浙江省湖州市";
$areanames{zh}->{861308391} = "浙江省湖州市";
$areanames{zh}->{861308392} = "浙江省湖州市";
$areanames{zh}->{861308393} = "浙江省温州市";
$areanames{zh}->{861308394} = "浙江省衢州市";
$areanames{zh}->{861308395} = "浙江省杭州市";
$areanames{zh}->{861308396} = "浙江省杭州市";
$areanames{zh}->{861308397} = "浙江省杭州市";
$areanames{zh}->{861308398} = "浙江省杭州市";
$areanames{zh}->{861308399} = "浙江省杭州市";
$areanames{zh}->{861308400} = "安徽省宿州市";
$areanames{zh}->{861308401} = "安徽省宿州市";
$areanames{zh}->{861308402} = "安徽省阜阳市";
$areanames{zh}->{861308403} = "安徽省六安市";
$areanames{zh}->{861308404} = "安徽省六安市";
$areanames{zh}->{861308405} = "安徽省淮北市";
$areanames{zh}->{861308406} = "安徽省亳州市";
$areanames{zh}->{861308407} = "安徽省蚌埠市";
$areanames{zh}->{861308408} = "安徽省蚌埠市";
$areanames{zh}->{861308409} = "安徽省宣城市";
$areanames{zh}->{86130841} = "辽宁省大连市";
$areanames{zh}->{861308420} = "河南省新乡市";
$areanames{zh}->{861308421} = "河南省新乡市";
$areanames{zh}->{861308422} = "河南省鹤壁市";
$areanames{zh}->{861308423} = "河南省鹤壁市";
$areanames{zh}->{861308424} = "河南省开封市";
$areanames{zh}->{861308425} = "河南省漯河市";
$areanames{zh}->{861308426} = "河南省漯河市";
$areanames{zh}->{861308427} = "河南省漯河市";
$areanames{zh}->{861308428} = "河南省周口市";
$areanames{zh}->{861308429} = "河南省周口市";
$areanames{zh}->{861308430} = "四川省雅安市";
$areanames{zh}->{861308431} = "四川省达州市";
$areanames{zh}->{861308432} = "四川省巴中市";
$areanames{zh}->{861308433} = "四川省南充市";
$areanames{zh}->{861308434} = "四川省遂宁市";
$areanames{zh}->{861308435} = "四川省广安市";
$areanames{zh}->{861308436} = "四川省凉山彝族自治州";
$areanames{zh}->{861308437} = "四川省广元市";
$areanames{zh}->{861308438} = "四川省德阳市";
$areanames{zh}->{861308439} = "四川省攀枝花市";
$areanames{zh}->{86130844} = "四川省成都市";
$areanames{zh}->{861308448} = "四川省绵阳市";
$areanames{zh}->{861308449} = "四川省绵阳市";
$areanames{zh}->{861308450} = "河北省沧州市";
$areanames{zh}->{861308451} = "河北省沧州市";
$areanames{zh}->{861308452} = "河北省沧州市";
$areanames{zh}->{861308453} = "河北省秦皇岛市";
$areanames{zh}->{861308454} = "河北省衡水市";
$areanames{zh}->{861308455} = "河北省廊坊市";
$areanames{zh}->{861308456} = "河北省邢台市";
$areanames{zh}->{861308457} = "河北省张家口市";
$areanames{zh}->{861308458} = "河北省张家口市";
$areanames{zh}->{861308459} = "河北省承德市";
$areanames{zh}->{861308460} = "浙江省绍兴市";
$areanames{zh}->{861308461} = "浙江省温州市";
$areanames{zh}->{861308462} = "浙江省温州市";
$areanames{zh}->{861308463} = "浙江省温州市";
$areanames{zh}->{861308464} = "浙江省金华市";
$areanames{zh}->{861308465} = "浙江省金华市";
$areanames{zh}->{861308466} = "浙江省金华市";
$areanames{zh}->{861308467} = "浙江省台州市";
$areanames{zh}->{861308468} = "浙江省台州市";
$areanames{zh}->{861308469} = "浙江省丽水市";
$areanames{zh}->{861308470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861308471} = "内蒙古呼和浩特市";
$areanames{zh}->{861308472} = "内蒙古包头市";
$areanames{zh}->{861308473} = "内蒙古乌海市";
$areanames{zh}->{861308474} = "内蒙古乌兰察布市";
$areanames{zh}->{861308475} = "内蒙古通辽市";
$areanames{zh}->{861308476} = "内蒙古赤峰市";
$areanames{zh}->{861308477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861308478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861308480} = "陕西省安康市";
$areanames{zh}->{861308481} = "陕西省安康市";
$areanames{zh}->{861308482} = "陕西省榆林市";
$areanames{zh}->{861308483} = "陕西省榆林市";
$areanames{zh}->{861308484} = "陕西省榆林市";
$areanames{zh}->{861308485} = "陕西省延安市";
$areanames{zh}->{861308486} = "陕西省延安市";
$areanames{zh}->{861308487} = "陕西省汉中市";
$areanames{zh}->{861308488} = "陕西省汉中市";
$areanames{zh}->{861308489} = "陕西省汉中市";
$areanames{zh}->{861308490} = "广西百色市";
$areanames{zh}->{861308491} = "广西南宁市";
$areanames{zh}->{861308492} = "广西柳州市";
$areanames{zh}->{861308493} = "广西柳州市";
$areanames{zh}->{861308494} = "广西河池市";
$areanames{zh}->{861308495} = "广西贵港市";
$areanames{zh}->{861308496} = "广西玉林市";
$areanames{zh}->{861308497} = "广西钦州市";
$areanames{zh}->{861308498} = "广西南宁市";
$areanames{zh}->{861308499} = "广西南宁市";
$areanames{zh}->{861308500} = "安徽省合肥市";
$areanames{zh}->{861308501} = "安徽省宿州市";
$areanames{zh}->{861308502} = "安徽省六安市";
$areanames{zh}->{861308503} = "安徽省六安市";
$areanames{zh}->{861308504} = "安徽省六安市";
$areanames{zh}->{861308505} = "安徽省合肥市";
$areanames{zh}->{861308506} = "安徽省合肥市";
$areanames{zh}->{861308507} = "安徽省淮北市";
$areanames{zh}->{861308508} = "安徽省淮南市";
$areanames{zh}->{861308509} = "安徽省六安市";
$areanames{zh}->{861308510} = "湖北省荆州市";
$areanames{zh}->{861308511} = "湖北省荆州市";
$areanames{zh}->{861308512} = "湖北省武汉市";
$areanames{zh}->{861308513} = "湖北省武汉市";
$areanames{zh}->{861308514} = "湖北省武汉市";
$areanames{zh}->{861308515} = "湖北省宜昌市";
$areanames{zh}->{861308516} = "湖北省宜昌市";
$areanames{zh}->{861308517} = "湖北省荆门市";
$areanames{zh}->{861308518} = "湖北省荆门市";
$areanames{zh}->{861308519} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861308520} = "湖北省黄石市";
$areanames{zh}->{861308521} = "湖北省黄冈市";
$areanames{zh}->{861308522} = "湖北省黄冈市";
$areanames{zh}->{861308523} = "湖北省鄂州市";
$areanames{zh}->{861308524} = "湖北省随州市";
$areanames{zh}->{861308525} = "湖北省随州市";
$areanames{zh}->{861308526} = "湖北省十堰市";
$areanames{zh}->{861308527} = "湖北省咸宁市";
$areanames{zh}->{861308528} = "湖北省襄樊市";
$areanames{zh}->{861308529} = "湖北省襄樊市";
$areanames{zh}->{86130853} = "云南省昆明市";
$areanames{zh}->{861308530} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861308531} = "云南省普洱市";
$areanames{zh}->{861308532} = "云南省普洱市";
$areanames{zh}->{861308540} = "湖南省张家界市";
$areanames{zh}->{861308541} = "湖南省张家界市";
$areanames{zh}->{861308542} = "湖南省永州市";
$areanames{zh}->{861308543} = "湖南省永州市";
$areanames{zh}->{861308544} = "湖南省永州市";
$areanames{zh}->{861308545} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861308546} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861308547} = "湖南省怀化市";
$areanames{zh}->{861308548} = "湖南省娄底市";
$areanames{zh}->{861308549} = "湖南省娄底市";
$areanames{zh}->{861308550} = "安徽省滁州市";
$areanames{zh}->{861308551} = "安徽省合肥市";
$areanames{zh}->{861308552} = "安徽省蚌埠市";
$areanames{zh}->{861308553} = "安徽省芜湖市";
$areanames{zh}->{861308554} = "安徽省淮南市";
$areanames{zh}->{861308555} = "安徽省马鞍山市";
$areanames{zh}->{861308556} = "安徽省安庆市";
$areanames{zh}->{861308557} = "安徽省宿州市";
$areanames{zh}->{861308558} = "安徽省阜阳市";
$areanames{zh}->{861308559} = "安徽省黄山市";
$areanames{zh}->{861308560} = "浙江省嘉兴市";
$areanames{zh}->{861308561} = "浙江省嘉兴市";
$areanames{zh}->{861308562} = "浙江省嘉兴市";
$areanames{zh}->{861308563} = "浙江省嘉兴市";
$areanames{zh}->{861308564} = "浙江省嘉兴市";
$areanames{zh}->{861308565} = "浙江省金华市";
$areanames{zh}->{861308566} = "浙江省金华市";
$areanames{zh}->{861308567} = "浙江省金华市";
$areanames{zh}->{861308568} = "浙江省绍兴市";
$areanames{zh}->{861308569} = "浙江省绍兴市";
$areanames{zh}->{861308570} = "广东省清远市";
$areanames{zh}->{861308571} = "广东省清远市";
$areanames{zh}->{861308572} = "广东省清远市";
$areanames{zh}->{861308573} = "广东省潮州市";
$areanames{zh}->{861308574} = "广东省潮州市";
$areanames{zh}->{861308575} = "广东省汕头市";
$areanames{zh}->{861308576} = "广东省汕头市";
$areanames{zh}->{861308577} = "广东省汕头市";
$areanames{zh}->{861308578} = "广东省汕头市";
$areanames{zh}->{861308579} = "广东省汕头市";
$areanames{zh}->{861308580} = "广东省珠海市";
$areanames{zh}->{861308581} = "广东省珠海市";
$areanames{zh}->{861308582} = "广东省珠海市";
$areanames{zh}->{861308583} = "广东省珠海市";
$areanames{zh}->{861308584} = "河北省邢台市";
$areanames{zh}->{861308585} = "广东省中山市";
$areanames{zh}->{861308586} = "广东省中山市";
$areanames{zh}->{861308587} = "广东省中山市";
$areanames{zh}->{861308588} = "广东省中山市";
$areanames{zh}->{861308589} = "广东省中山市";
$areanames{zh}->{861308590} = "甘肃省白银市";
$areanames{zh}->{861308591} = "甘肃省临夏回族自治州";
$areanames{zh}->{861308592} = "甘肃省张掖市";
$areanames{zh}->{861308593} = "甘肃省庆阳市";
$areanames{zh}->{861308594} = "甘肃省天水市";
$areanames{zh}->{861308595} = "甘肃省武威市";
$areanames{zh}->{861308596} = "甘肃省嘉峪关市";
$areanames{zh}->{861308597} = "甘肃省天水市";
$areanames{zh}->{861308598} = "甘肃省天水市";
$areanames{zh}->{861308599} = "甘肃省平凉市";
$areanames{zh}->{86130860} = "海南省海口市";
$areanames{zh}->{861308610} = "江西省新余市";
$areanames{zh}->{861308611} = "江西省上饶市";
$areanames{zh}->{861308612} = "江西省上饶市";
$areanames{zh}->{861308613} = "江西省上饶市";
$areanames{zh}->{861308614} = "江西省景德镇市";
$areanames{zh}->{861308615} = "江西省宜春市";
$areanames{zh}->{861308616} = "江西省吉安市";
$areanames{zh}->{861308617} = "江西省宜春市";
$areanames{zh}->{861308618} = "江西省抚州市";
$areanames{zh}->{861308619} = "江西省萍乡市";
$areanames{zh}->{861308620} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861308621} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861308622} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861308623} = "青海省海南藏族自治州";
$areanames{zh}->{861308624} = "青海省海北藏族自治州";
$areanames{zh}->{861308625} = "青海省西宁市";
$areanames{zh}->{861308626} = "青海省西宁市";
$areanames{zh}->{861308627} = "青海省西宁市";
$areanames{zh}->{861308628} = "青海省西宁市";
$areanames{zh}->{861308629} = "青海省西宁市";
$areanames{zh}->{861308630} = "四川省雅安市";
$areanames{zh}->{861308631} = "四川省雅安市";
$areanames{zh}->{861308632} = "四川省达州市";
$areanames{zh}->{861308633} = "四川省达州市";
$areanames{zh}->{861308634} = "四川省巴中市";
$areanames{zh}->{861308635} = "四川省甘孜藏族自治州";
$areanames{zh}->{861308636} = "四川省南充市";
$areanames{zh}->{861308637} = "四川省南充市";
$areanames{zh}->{861308638} = "四川省遂宁市";
$areanames{zh}->{861308639} = "四川省广安市";
$areanames{zh}->{861308640} = "四川省绵阳市";
$areanames{zh}->{861308641} = "四川省绵阳市";
$areanames{zh}->{861308642} = "四川省自贡市";
$areanames{zh}->{861308643} = "四川省内江市";
$areanames{zh}->{861308644} = "四川省泸州市";
$areanames{zh}->{861308645} = "四川省乐山市";
$areanames{zh}->{861308646} = "四川省乐山市";
$areanames{zh}->{861308647} = "四川省眉山市";
$areanames{zh}->{861308648} = "四川省眉山市";
$areanames{zh}->{861308649} = "四川省凉山彝族自治州";
$areanames{zh}->{861308650} = "四川省广元市";
$areanames{zh}->{861308651} = "四川省广元市";
$areanames{zh}->{861308652} = "四川省内江市";
$areanames{zh}->{861308653} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861308654} = "四川省宜宾市";
$areanames{zh}->{861308655} = "四川省宜宾市";
$areanames{zh}->{861308656} = "四川省宜宾市";
$areanames{zh}->{861308657} = "四川省资阳市";
$areanames{zh}->{861308658} = "四川省资阳市";
$areanames{zh}->{861308659} = "四川省泸州市";
$areanames{zh}->{86130866} = "四川省成都市";
$areanames{zh}->{861308670} = "广西防城港市";
$areanames{zh}->{861308671} = "广西南宁市";
$areanames{zh}->{861308672} = "广西柳州市";
$areanames{zh}->{861308673} = "广西桂林市";
$areanames{zh}->{861308674} = "广西百色市";
$areanames{zh}->{861308675} = "广西玉林市";
$areanames{zh}->{861308676} = "广西贺州市";
$areanames{zh}->{861308677} = "广西贵港市";
$areanames{zh}->{861308678} = "广西河池市";
$areanames{zh}->{861308679} = "广西北海市";
$areanames{zh}->{86130868} = "吉林省长春市";
$areanames{zh}->{861308690} = "贵州省安顺市";
$areanames{zh}->{861308691} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861308692} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861308693} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861308694} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861308695} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861308696} = "贵州省六盘水市";
$areanames{zh}->{861308697} = "贵州省六盘水市";
$areanames{zh}->{861308698} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861308699} = "贵州省铜仁地区";
$areanames{zh}->{861308700} = "河南省开封市";
$areanames{zh}->{861308701} = "河南省信阳市";
$areanames{zh}->{861308702} = "河南省商丘市";
$areanames{zh}->{861308703} = "河南省南阳市";
$areanames{zh}->{861308704} = "河南省平顶山市";
$areanames{zh}->{861308705} = "河南省平顶山市";
$areanames{zh}->{861308706} = "河南省平顶山市";
$areanames{zh}->{861308707} = "河南省三门峡市";
$areanames{zh}->{861308708} = "河南省驻马店市";
$areanames{zh}->{861308709} = "河南省驻马店市";
$areanames{zh}->{861308710} = "内蒙古呼和浩特市";
$areanames{zh}->{861308711} = "内蒙古呼和浩特市";
$areanames{zh}->{861308712} = "内蒙古呼和浩特市";
$areanames{zh}->{861308713} = "内蒙古兴安盟";
$areanames{zh}->{861308714} = "内蒙古阿拉善盟";
$areanames{zh}->{861308715} = "内蒙古通辽市";
$areanames{zh}->{861308716} = "内蒙古通辽市";
$areanames{zh}->{861308717} = "内蒙古通辽市";
$areanames{zh}->{861308718} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861308719} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861308720} = "湖南省怀化市";
$areanames{zh}->{861308721} = "湖南省湘潭市";
$areanames{zh}->{861308722} = "湖南省湘潭市";
$areanames{zh}->{861308723} = "湖南省湘潭市";
$areanames{zh}->{861308724} = "湖南省衡阳市";
$areanames{zh}->{861308725} = "湖南省郴州市";
$areanames{zh}->{861308726} = "湖南省邵阳市";
$areanames{zh}->{861308727} = "湖南省益阳市";
$areanames{zh}->{861308728} = "湖南省邵阳市";
$areanames{zh}->{861308729} = "湖南省怀化市";
$areanames{zh}->{861308730} = "湖南省岳阳市";
$areanames{zh}->{861308731} = "湖南省长沙市";
$areanames{zh}->{861308732} = "湖南省湘潭市";
$areanames{zh}->{861308733} = "湖南省株洲市";
$areanames{zh}->{861308734} = "湖南省衡阳市";
$areanames{zh}->{861308735} = "湖南省郴州市";
$areanames{zh}->{861308736} = "湖南省常德市";
$areanames{zh}->{861308737} = "湖南省益阳市";
$areanames{zh}->{861308738} = "湖南省娄底市";
$areanames{zh}->{861308739} = "湖南省邵阳市";
$areanames{zh}->{861308740} = "云南省大理白族自治州";
$areanames{zh}->{861308741} = "云南省大理白族自治州";
$areanames{zh}->{861308742} = "云南省迪庆藏族自治州";
$areanames{zh}->{861308743} = "云南省玉溪市";
$areanames{zh}->{861308744} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861308745} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861308746} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861308747} = "云南省曲靖市";
$areanames{zh}->{861308748} = "云南省昭通市";
$areanames{zh}->{861308749} = "云南省保山市";
$areanames{zh}->{86130875} = "陕西省西安市";
$areanames{zh}->{861308760} = "陕西省渭南市";
$areanames{zh}->{861308761} = "陕西省渭南市";
$areanames{zh}->{861308762} = "陕西省渭南市";
$areanames{zh}->{861308763} = "陕西省渭南市";
$areanames{zh}->{861308764} = "陕西省商洛市";
$areanames{zh}->{861308765} = "陕西省铜川市";
$areanames{zh}->{861308766} = "陕西省咸阳市";
$areanames{zh}->{861308767} = "陕西省咸阳市";
$areanames{zh}->{861308768} = "陕西省咸阳市";
$areanames{zh}->{861308769} = "陕西省咸阳市";
$areanames{zh}->{861308770} = "广西防城港市";
$areanames{zh}->{861308771} = "广西南宁市";
$areanames{zh}->{861308772} = "广西柳州市";
$areanames{zh}->{861308773} = "广西桂林市";
$areanames{zh}->{861308774} = "广西梧州市";
$areanames{zh}->{861308775} = "广西玉林市";
$areanames{zh}->{861308776} = "广西百色市";
$areanames{zh}->{861308777} = "广西钦州市";
$areanames{zh}->{861308778} = "广西河池市";
$areanames{zh}->{861308779} = "广西北海市";
$areanames{zh}->{86130878} = "贵州省贵阳市";
$areanames{zh}->{861308786} = "贵州省毕节地区";
$areanames{zh}->{861308787} = "贵州省遵义市";
$areanames{zh}->{861308788} = "贵州省遵义市";
$areanames{zh}->{861308789} = "贵州省遵义市";
$areanames{zh}->{861308790} = "广西南宁市";
$areanames{zh}->{861308791} = "广西南宁市";
$areanames{zh}->{861308792} = "广西柳州市";
$areanames{zh}->{861308793} = "广西桂林市";
$areanames{zh}->{861308794} = "广西梧州市";
$areanames{zh}->{861308795} = "广西玉林市";
$areanames{zh}->{861308796} = "广西南宁市";
$areanames{zh}->{861308797} = "广西南宁市";
$areanames{zh}->{861308798} = "广西梧州市";
$areanames{zh}->{861308799} = "广西南宁市";
$areanames{zh}->{86130880} = "四川省成都市";
$areanames{zh}->{861308810} = "四川省绵阳市";
$areanames{zh}->{861308811} = "四川省绵阳市";
$areanames{zh}->{861308812} = "四川省广安市";
$areanames{zh}->{861308813} = "四川省南充市";
$areanames{zh}->{861308814} = "四川省达州市";
$areanames{zh}->{861308815} = "四川省达州市";
$areanames{zh}->{861308816} = "四川省遂宁市";
$areanames{zh}->{861308817} = "四川省泸州市";
$areanames{zh}->{861308818} = "四川省德阳市";
$areanames{zh}->{861308819} = "四川省南充市";
$areanames{zh}->{861308820} = "四川省德阳市";
$areanames{zh}->{861308821} = "四川省巴中市";
$areanames{zh}->{861308822} = "四川省内江市";
$areanames{zh}->{861308823} = "四川省内江市";
$areanames{zh}->{861308824} = "四川省资阳市";
$areanames{zh}->{861308825} = "四川省绵阳市";
$areanames{zh}->{861308826} = "四川省绵阳市";
$areanames{zh}->{861308827} = "四川省绵阳市";
$areanames{zh}->{861308828} = "四川省自贡市";
$areanames{zh}->{861308829} = "四川省自贡市";
$areanames{zh}->{861308830} = "四川省资阳市";
$areanames{zh}->{861308831} = "四川省泸州市";
$areanames{zh}->{861308832} = "四川省自贡市";
$areanames{zh}->{861308833} = "四川省宜宾市";
$areanames{zh}->{861308834} = "四川省德阳市";
$areanames{zh}->{861308835} = "四川省乐山市";
$areanames{zh}->{861308836} = "四川省攀枝花市";
$areanames{zh}->{861308837} = "四川省凉山彝族自治州";
$areanames{zh}->{861308838} = "四川省眉山市";
$areanames{zh}->{861308839} = "四川省乐山市";
$areanames{zh}->{861308840} = "内蒙古赤峰市";
$areanames{zh}->{861308841} = "内蒙古赤峰市";
$areanames{zh}->{861308842} = "内蒙古赤峰市";
$areanames{zh}->{861308843} = "内蒙古赤峰市";
$areanames{zh}->{861308844} = "内蒙古包头市";
$areanames{zh}->{861308845} = "内蒙古包头市";
$areanames{zh}->{861308846} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308847} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308848} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861308849} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86130885} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861308856} = "内蒙古包头市";
$areanames{zh}->{861308857} = "内蒙古乌兰察布市";
$areanames{zh}->{861308858} = "内蒙古乌兰察布市";
$areanames{zh}->{861308859} = "内蒙古乌兰察布市";
$areanames{zh}->{861308860} = "浙江省台州市";
$areanames{zh}->{861308861} = "浙江省台州市";
$areanames{zh}->{861308862} = "浙江省台州市";
$areanames{zh}->{861308863} = "浙江省台州市";
$areanames{zh}->{861308864} = "浙江省台州市";
$areanames{zh}->{861308865} = "浙江省温州市";
$areanames{zh}->{861308866} = "浙江省温州市";
$areanames{zh}->{861308867} = "浙江省温州市";
$areanames{zh}->{861308868} = "浙江省温州市";
$areanames{zh}->{861308869} = "浙江省温州市";
$areanames{zh}->{86130887} = "甘肃省兰州市";
$areanames{zh}->{86130888} = "广东省深圳市";
$areanames{zh}->{861308890} = "陕西省宝鸡市";
$areanames{zh}->{861308891} = "陕西省宝鸡市";
$areanames{zh}->{861308892} = "陕西省宝鸡市";
$areanames{zh}->{861308893} = "陕西省宝鸡市";
$areanames{zh}->{861308894} = "陕西省宝鸡市";
$areanames{zh}->{861308895} = "陕西省西安市";
$areanames{zh}->{861308896} = "陕西省西安市";
$areanames{zh}->{861308897} = "陕西省西安市";
$areanames{zh}->{861308898} = "陕西省西安市";
$areanames{zh}->{861308899} = "陕西省西安市";
$areanames{zh}->{86130890} = "黑龙江省大庆市";
$areanames{zh}->{861308909} = "黑龙江省黑河市";
$areanames{zh}->{861308910} = "吉林省长春市";
$areanames{zh}->{861308911} = "吉林省长春市";
$areanames{zh}->{861308912} = "吉林省长春市";
$areanames{zh}->{861308913} = "吉林省长春市";
$areanames{zh}->{861308914} = "吉林省长春市";
$areanames{zh}->{861308915} = "吉林省吉林市";
$areanames{zh}->{861308916} = "吉林省吉林市";
$areanames{zh}->{861308917} = "吉林省吉林市";
$areanames{zh}->{861308918} = "吉林省吉林市";
$areanames{zh}->{861308919} = "吉林省通化市";
$areanames{zh}->{861308920} = "吉林省辽源市";
$areanames{zh}->{861308921} = "吉林省辽源市";
$areanames{zh}->{861308922} = "吉林省四平市";
$areanames{zh}->{861308923} = "吉林省四平市";
$areanames{zh}->{861308924} = "吉林省吉林市";
$areanames{zh}->{861308925} = "吉林省松原市";
$areanames{zh}->{861308926} = "吉林省松原市";
$areanames{zh}->{861308927} = "吉林省通化市";
$areanames{zh}->{861308928} = "吉林省四平市";
$areanames{zh}->{861308929} = "吉林省通化市";
$areanames{zh}->{861308930} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308931} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308932} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308933} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308934} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308935} = "吉林省松原市";
$areanames{zh}->{861308936} = "吉林省白城市";
$areanames{zh}->{861308937} = "吉林省白城市";
$areanames{zh}->{861308938} = "吉林省白山市";
$areanames{zh}->{861308939} = "吉林省白山市";
$areanames{zh}->{861308940} = "吉林省长春市";
$areanames{zh}->{861308941} = "吉林省长春市";
$areanames{zh}->{861308942} = "吉林省长春市";
$areanames{zh}->{861308943} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308944} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861308945} = "吉林省吉林市";
$areanames{zh}->{861308946} = "吉林省吉林市";
$areanames{zh}->{861308947} = "吉林省吉林市";
$areanames{zh}->{861308948} = "吉林省吉林市";
$areanames{zh}->{861308949} = "吉林省吉林市";
$areanames{zh}->{861308950} = "黑龙江省鹤岗市";
$areanames{zh}->{861308951} = "黑龙江省鹤岗市";
$areanames{zh}->{861308952} = "黑龙江省黑河市";
$areanames{zh}->{861308953} = "黑龙江省七台河市";
$areanames{zh}->{861308954} = "黑龙江省七台河市";
$areanames{zh}->{861308955} = "黑龙江省七台河市";
$areanames{zh}->{861308956} = "黑龙江省鸡西市";
$areanames{zh}->{861308957} = "黑龙江省鸡西市";
$areanames{zh}->{861308958} = "黑龙江省鸡西市";
$areanames{zh}->{861308959} = "黑龙江省伊春市";
$areanames{zh}->{86130896} = "黑龙江省佳木斯市";
$areanames{zh}->{861308960} = "黑龙江省伊春市";
$areanames{zh}->{861308961} = "黑龙江省伊春市";
$areanames{zh}->{861308962} = "黑龙江省伊春市";
$areanames{zh}->{861308970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861308971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861308972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861308973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861308974} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861308975} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861308976} = "黑龙江省黑河市";
$areanames{zh}->{861308977} = "黑龙江省鹤岗市";
$areanames{zh}->{861308978} = "黑龙江省双鸭山市";
$areanames{zh}->{861308979} = "黑龙江省鸡西市";
$areanames{zh}->{86130898} = "黑龙江省牡丹江市";
$areanames{zh}->{861308980} = "黑龙江省鸡西市";
$areanames{zh}->{861308981} = "黑龙江省双鸭山市";
$areanames{zh}->{861308982} = "黑龙江省双鸭山市";
$areanames{zh}->{861308990} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861308991} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861308992} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861308993} = "黑龙江省绥化市";
$areanames{zh}->{861308994} = "黑龙江省绥化市";
$areanames{zh}->{861308995} = "黑龙江省绥化市";
$areanames{zh}->{861308996} = "黑龙江省绥化市";
$areanames{zh}->{861308997} = "黑龙江省绥化市";
$areanames{zh}->{861308998} = "黑龙江省哈尔滨市";
$areanames{zh}->{861308999} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130900} = "新疆昌吉回族自治州";
$areanames{zh}->{861309024} = "辽宁省沈阳市";
$areanames{zh}->{861309029} = "陕西省西安市";
$areanames{zh}->{861309042} = "北京市";
$areanames{zh}->{861309044} = "辽宁省锦州市";
$areanames{zh}->{86130905} = "贵州省遵义市";
$areanames{zh}->{861309066} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861309067} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861309069} = "内蒙古呼和浩特市";
$areanames{zh}->{861309100} = "河北省石家庄市";
$areanames{zh}->{861309101} = "河北省石家庄市";
$areanames{zh}->{861309102} = "河北省石家庄市";
$areanames{zh}->{861309103} = "河北省石家庄市";
$areanames{zh}->{861309104} = "河北省唐山市";
$areanames{zh}->{861309105} = "河北省唐山市";
$areanames{zh}->{861309106} = "河北省唐山市";
$areanames{zh}->{861309107} = "河北省唐山市";
$areanames{zh}->{861309108} = "河北省唐山市";
$areanames{zh}->{861309109} = "河北省石家庄市";
$areanames{zh}->{861309110} = "河北省邯郸市";
$areanames{zh}->{861309111} = "河北省邯郸市";
$areanames{zh}->{861309112} = "河北省邯郸市";
$areanames{zh}->{861309113} = "河北省邯郸市";
$areanames{zh}->{861309114} = "河北省沧州市";
$areanames{zh}->{861309115} = "河北省沧州市";
$areanames{zh}->{861309116} = "河北省沧州市";
$areanames{zh}->{861309117} = "河北省衡水市";
$areanames{zh}->{861309118} = "河北省衡水市";
$areanames{zh}->{861309119} = "河北省衡水市";
$areanames{zh}->{86130912} = "河北省保定市";
$areanames{zh}->{861309127} = "河北省邢台市";
$areanames{zh}->{861309128} = "河北省邢台市";
$areanames{zh}->{861309129} = "河北省邢台市";
$areanames{zh}->{861309130} = "河北省廊坊市";
$areanames{zh}->{861309131} = "河北省张家口市";
$areanames{zh}->{861309132} = "河北省张家口市";
$areanames{zh}->{861309133} = "河北省承德市";
$areanames{zh}->{861309134} = "河北省秦皇岛市";
$areanames{zh}->{861309135} = "河北省承德市";
$areanames{zh}->{861309136} = "河北省秦皇岛市";
$areanames{zh}->{861309137} = "河北省秦皇岛市";
$areanames{zh}->{861309138} = "河北省秦皇岛市";
$areanames{zh}->{861309139} = "河北省廊坊市";
$areanames{zh}->{861309140} = "黑龙江省大庆市";
$areanames{zh}->{861309141} = "黑龙江省大庆市";
$areanames{zh}->{861309142} = "黑龙江省大庆市";
$areanames{zh}->{861309143} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309144} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309145} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309146} = "黑龙江省鸡西市";
$areanames{zh}->{861309147} = "黑龙江省双鸭山市";
$areanames{zh}->{861309148} = "黑龙江省伊春市";
$areanames{zh}->{861309149} = "黑龙江省鹤岗市";
$areanames{zh}->{861309150} = "黑龙江省鹤岗市";
$areanames{zh}->{861309151} = "黑龙江省鹤岗市";
$areanames{zh}->{861309152} = "黑龙江省黑河市";
$areanames{zh}->{861309153} = "黑龙江省绥化市";
$areanames{zh}->{861309154} = "黑龙江省绥化市";
$areanames{zh}->{861309155} = "黑龙江省绥化市";
$areanames{zh}->{861309156} = "黑龙江省绥化市";
$areanames{zh}->{861309157} = "黑龙江省鸡西市";
$areanames{zh}->{861309158} = "黑龙江省鸡西市";
$areanames{zh}->{861309159} = "黑龙江省鸡西市";
$areanames{zh}->{861309160} = "黑龙江省伊春市";
$areanames{zh}->{861309161} = "黑龙江省伊春市";
$areanames{zh}->{861309162} = "黑龙江省佳木斯市";
$areanames{zh}->{861309163} = "黑龙江省佳木斯市";
$areanames{zh}->{861309164} = "黑龙江省佳木斯市";
$areanames{zh}->{861309165} = "黑龙江省佳木斯市";
$areanames{zh}->{861309166} = "黑龙江省大庆市";
$areanames{zh}->{861309167} = "黑龙江省大庆市";
$areanames{zh}->{861309168} = "黑龙江省大庆市";
$areanames{zh}->{861309169} = "黑龙江省大庆市";
$areanames{zh}->{861309170} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309171} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309172} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309173} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861309174} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861309175} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861309176} = "黑龙江省黑河市";
$areanames{zh}->{861309177} = "黑龙江省黑河市";
$areanames{zh}->{861309178} = "黑龙江省双鸭山市";
$areanames{zh}->{861309179} = "黑龙江省双鸭山市";
$areanames{zh}->{861309180} = "黑龙江省双鸭山市";
$areanames{zh}->{861309181} = "黑龙江省牡丹江市";
$areanames{zh}->{861309182} = "黑龙江省牡丹江市";
$areanames{zh}->{861309183} = "黑龙江省牡丹江市";
$areanames{zh}->{861309184} = "黑龙江省牡丹江市";
$areanames{zh}->{861309185} = "黑龙江省牡丹江市";
$areanames{zh}->{861309186} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309187} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309188} = "黑龙江省哈尔滨市";
$areanames{zh}->{861309189} = "黑龙江省哈尔滨市";
$areanames{zh}->{86130919} = "浙江省温州市";
$areanames{zh}->{86130920} = "江苏省扬州市";
$areanames{zh}->{86130921} = "江苏省盐城市";
$areanames{zh}->{86130922} = "江苏省泰州市";
$areanames{zh}->{86130923} = "江苏省徐州市";
$areanames{zh}->{861309237} = "江苏省连云港市";
$areanames{zh}->{861309238} = "江苏省连云港市";
$areanames{zh}->{861309239} = "江苏省连云港市";
$areanames{zh}->{861309240} = "江苏省无锡市";
$areanames{zh}->{861309241} = "江苏省无锡市";
$areanames{zh}->{861309242} = "江苏省常州市";
$areanames{zh}->{861309243} = "江苏省常州市";
$areanames{zh}->{861309244} = "江苏省泰州市";
$areanames{zh}->{861309245} = "江苏省连云港市";
$areanames{zh}->{861309246} = "江苏省宿迁市";
$areanames{zh}->{861309247} = "江苏省宿迁市";
$areanames{zh}->{861309248} = "江苏省宿迁市";
$areanames{zh}->{861309249} = "江苏省宿迁市";
$areanames{zh}->{86130925} = "江苏省常州市";
$areanames{zh}->{86130926} = "江苏省苏州市";
$areanames{zh}->{861309268} = "江苏省镇江市";
$areanames{zh}->{861309269} = "江苏省镇江市";
$areanames{zh}->{861309270} = "湖北省鄂州市";
$areanames{zh}->{861309271} = "湖北省鄂州市";
$areanames{zh}->{861309272} = "湖北省黄冈市";
$areanames{zh}->{861309273} = "湖北省黄冈市";
$areanames{zh}->{861309274} = "湖北省黄冈市";
$areanames{zh}->{861309275} = "湖北省黄石市";
$areanames{zh}->{861309276} = "湖北省黄石市";
$areanames{zh}->{861309277} = "湖北省黄石市";
$areanames{zh}->{861309278} = "湖北省黄石市";
$areanames{zh}->{861309279} = "湖北省黄石市";
$areanames{zh}->{861309280} = "四川省凉山彝族自治州";
$areanames{zh}->{861309281} = "四川省攀枝花市";
$areanames{zh}->{861309282} = "四川省南充市";
$areanames{zh}->{861309283} = "四川省遂宁市";
$areanames{zh}->{861309284} = "四川省广安市";
$areanames{zh}->{861309285} = "四川省达州市";
$areanames{zh}->{861309286} = "四川省德阳市";
$areanames{zh}->{861309287} = "四川省内江市";
$areanames{zh}->{861309288} = "四川省宜宾市";
$areanames{zh}->{861309289} = "四川省自贡市";
$areanames{zh}->{86130929} = "陕西省咸阳市";
$areanames{zh}->{861309290} = "陕西省宝鸡市";
$areanames{zh}->{861309291} = "陕西省宝鸡市";
$areanames{zh}->{861309292} = "陕西省宝鸡市";
$areanames{zh}->{861309293} = "陕西省宝鸡市";
$areanames{zh}->{86130930} = "江苏省无锡市";
$areanames{zh}->{861309310} = "江苏省无锡市";
$areanames{zh}->{861309311} = "江苏省无锡市";
$areanames{zh}->{861309312} = "江苏省无锡市";
$areanames{zh}->{861309313} = "江苏省无锡市";
$areanames{zh}->{861309314} = "江苏省无锡市";
$areanames{zh}->{861309315} = "江苏省常州市";
$areanames{zh}->{861309316} = "江苏省常州市";
$areanames{zh}->{861309317} = "江苏省常州市";
$areanames{zh}->{861309318} = "江苏省常州市";
$areanames{zh}->{861309319} = "江苏省常州市";
$areanames{zh}->{861309320} = "湖北省荆门市";
$areanames{zh}->{861309321} = "湖北省荆门市";
$areanames{zh}->{861309322} = "湖北省荆门市";
$areanames{zh}->{861309323} = "湖北省荆门市";
$areanames{zh}->{861309324} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861309325} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861309326} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861309327} = "湖北省随州市";
$areanames{zh}->{861309328} = "湖北省随州市";
$areanames{zh}->{861309329} = "湖北省武汉市";
$areanames{zh}->{861309330} = "安徽省滁州市";
$areanames{zh}->{861309331} = "安徽省滁州市";
$areanames{zh}->{861309332} = "安徽省滁州市";
$areanames{zh}->{861309333} = "安徽省铜陵市";
$areanames{zh}->{861309334} = "安徽省阜阳市";
$areanames{zh}->{861309335} = "安徽省亳州市";
$areanames{zh}->{861309336} = "安徽省阜阳市";
$areanames{zh}->{861309337} = "安徽省亳州市";
$areanames{zh}->{861309338} = "安徽省阜阳市";
$areanames{zh}->{861309339} = "安徽省阜阳市";
$areanames{zh}->{861309340} = "安徽省合肥市";
$areanames{zh}->{861309341} = "安徽省六安市";
$areanames{zh}->{861309342} = "安徽省六安市";
$areanames{zh}->{861309343} = "安徽省六安市";
$areanames{zh}->{861309344} = "安徽省芜湖市";
$areanames{zh}->{861309345} = "安徽省合肥市";
$areanames{zh}->{861309346} = "安徽省宣城市";
$areanames{zh}->{861309347} = "安徽省宣城市";
$areanames{zh}->{861309348} = "安徽省宣城市";
$areanames{zh}->{861309349} = "安徽省池州市";
$areanames{zh}->{861309350} = "安徽省马鞍山市";
$areanames{zh}->{861309351} = "安徽省淮北市";
$areanames{zh}->{861309352} = "安徽省淮北市";
$areanames{zh}->{861309353} = "安徽省淮北市";
$areanames{zh}->{861309354} = "安徽省合肥市";
$areanames{zh}->{861309355} = "安徽省合肥市";
$areanames{zh}->{861309356} = "安徽省宿州市";
$areanames{zh}->{861309357} = "安徽省宿州市";
$areanames{zh}->{861309358} = "安徽省宿州市";
$areanames{zh}->{861309359} = "安徽省宿州市";
$areanames{zh}->{861309360} = "安徽省宣城市";
$areanames{zh}->{861309361} = "安徽省宣城市";
$areanames{zh}->{861309362} = "安徽省芜湖市";
$areanames{zh}->{861309363} = "安徽省芜湖市";
$areanames{zh}->{861309364} = "安徽省芜湖市";
$areanames{zh}->{861309365} = "安徽省蚌埠市";
$areanames{zh}->{861309366} = "安徽省蚌埠市";
$areanames{zh}->{861309367} = "安徽省蚌埠市";
$areanames{zh}->{861309368} = "安徽省池州市";
$areanames{zh}->{861309369} = "安徽省池州市";
$areanames{zh}->{86130937} = "浙江省杭州市";
$areanames{zh}->{86130938} = "浙江省台州市";
$areanames{zh}->{86130939} = "陕西省渭南市";
$areanames{zh}->{861309390} = "陕西省汉中市";
$areanames{zh}->{861309391} = "陕西省汉中市";
$areanames{zh}->{861309392} = "陕西省汉中市";
$areanames{zh}->{861309393} = "陕西省汉中市";
$areanames{zh}->{861309400} = "新疆阿勒泰地区";
$areanames{zh}->{861309401} = "新疆昌吉回族自治州";
$areanames{zh}->{861309402} = "新疆哈密地区";
$areanames{zh}->{861309403} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861309404} = "新疆石河子市";
$areanames{zh}->{861309405} = "新疆克拉玛依市";
$areanames{zh}->{861309406} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861309407} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861309408} = "新疆阿克苏地区";
$areanames{zh}->{861309409} = "新疆和田地区";
$areanames{zh}->{861309410} = "湖北省襄樊市";
$areanames{zh}->{861309411} = "湖北省襄樊市";
$areanames{zh}->{861309412} = "湖北省襄樊市";
$areanames{zh}->{861309413} = "湖北省襄樊市";
$areanames{zh}->{861309414} = "湖北省孝感市";
$areanames{zh}->{861309415} = "湖北省孝感市";
$areanames{zh}->{861309416} = "湖北省宜昌市";
$areanames{zh}->{861309417} = "湖北省宜昌市";
$areanames{zh}->{861309418} = "湖北省宜昌市";
$areanames{zh}->{861309419} = "湖北省咸宁市";
$areanames{zh}->{861309420} = "湖北省荆州市";
$areanames{zh}->{861309421} = "湖北省荆州市";
$areanames{zh}->{861309422} = "湖北省荆州市";
$areanames{zh}->{861309423} = "湖北省荆州市";
$areanames{zh}->{861309424} = "湖北省荆州市";
$areanames{zh}->{861309425} = "湖北省武汉市";
$areanames{zh}->{861309426} = "湖北省武汉市";
$areanames{zh}->{861309427} = "湖北省十堰市";
$areanames{zh}->{861309428} = "湖北省十堰市";
$areanames{zh}->{861309429} = "湖北省武汉市";
$areanames{zh}->{861309430} = "云南省玉溪市";
$areanames{zh}->{861309431} = "云南省曲靖市";
$areanames{zh}->{861309432} = "云南省楚雄彝族自治州";
$areanames{zh}->{861309433} = "云南省昭通市";
$areanames{zh}->{861309434} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309435} = "云南省保山市";
$areanames{zh}->{861309436} = "云南省保山市";
$areanames{zh}->{861309437} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861309438} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861309439} = "云南省临沧市";
$areanames{zh}->{86130944} = "四川省成都市";
$areanames{zh}->{861309450} = "四川省达州市";
$areanames{zh}->{861309451} = "四川省巴中市";
$areanames{zh}->{861309452} = "四川省巴中市";
$areanames{zh}->{861309453} = "四川省宜宾市";
$areanames{zh}->{861309454} = "四川省凉山彝族自治州";
$areanames{zh}->{861309455} = "四川省攀枝花市";
$areanames{zh}->{861309456} = "四川省攀枝花市";
$areanames{zh}->{861309457} = "四川省雅安市";
$areanames{zh}->{861309458} = "四川省宜宾市";
$areanames{zh}->{861309459} = "四川省宜宾市";
$areanames{zh}->{861309460} = "浙江省绍兴市";
$areanames{zh}->{861309461} = "浙江省绍兴市";
$areanames{zh}->{861309462} = "浙江省绍兴市";
$areanames{zh}->{861309463} = "浙江省绍兴市";
$areanames{zh}->{861309464} = "浙江省金华市";
$areanames{zh}->{861309465} = "浙江省金华市";
$areanames{zh}->{861309466} = "浙江省金华市";
$areanames{zh}->{861309467} = "浙江省嘉兴市";
$areanames{zh}->{861309468} = "浙江省丽水市";
$areanames{zh}->{861309469} = "浙江省丽水市";
$areanames{zh}->{861309470} = "浙江省温州市";
$areanames{zh}->{861309471} = "浙江省温州市";
$areanames{zh}->{861309472} = "浙江省温州市";
$areanames{zh}->{861309473} = "浙江省温州市";
$areanames{zh}->{861309474} = "浙江省衢州市";
$areanames{zh}->{861309475} = "浙江省舟山市";
$areanames{zh}->{861309476} = "浙江省台州市";
$areanames{zh}->{861309477} = "浙江省台州市";
$areanames{zh}->{861309478} = "浙江省台州市";
$areanames{zh}->{861309479} = "浙江省台州市";
$areanames{zh}->{861309480} = "浙江省杭州市";
$areanames{zh}->{861309481} = "浙江省杭州市";
$areanames{zh}->{861309482} = "浙江省宁波市";
$areanames{zh}->{861309483} = "浙江省宁波市";
$areanames{zh}->{861309484} = "浙江省湖州市";
$areanames{zh}->{861309485} = "浙江省湖州市";
$areanames{zh}->{861309486} = "浙江省湖州市";
$areanames{zh}->{861309487} = "浙江省嘉兴市";
$areanames{zh}->{861309488} = "浙江省嘉兴市";
$areanames{zh}->{861309489} = "浙江省嘉兴市";
$areanames{zh}->{861309490} = "江苏省淮安市";
$areanames{zh}->{861309491} = "江苏省淮安市";
$areanames{zh}->{861309492} = "江苏省淮安市";
$areanames{zh}->{861309493} = "江苏省淮安市";
$areanames{zh}->{861309494} = "江苏省淮安市";
$areanames{zh}->{861309495} = "江苏省镇江市";
$areanames{zh}->{861309496} = "江苏省镇江市";
$areanames{zh}->{861309497} = "江苏省镇江市";
$areanames{zh}->{861309498} = "江苏省镇江市";
$areanames{zh}->{861309499} = "江苏省镇江市";
$areanames{zh}->{861309500} = "新疆乌鲁木齐市";
$areanames{zh}->{861309501} = "新疆乌鲁木齐市";
$areanames{zh}->{861309502} = "新疆乌鲁木齐市";
$areanames{zh}->{861309503} = "新疆乌鲁木齐市";
$areanames{zh}->{861309504} = "新疆吐鲁番地区";
$areanames{zh}->{861309505} = "新疆昌吉回族自治州";
$areanames{zh}->{861309506} = "新疆昌吉回族自治州";
$areanames{zh}->{861309507} = "新疆哈密地区";
$areanames{zh}->{861309508} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861309509} = "新疆石河子市";
$areanames{zh}->{861309510} = "新疆克拉玛依市";
$areanames{zh}->{861309511} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861309512} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861309513} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861309514} = "新疆塔城地区";
$areanames{zh}->{861309515} = "新疆喀什地区";
$areanames{zh}->{861309516} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861309517} = "新疆阿克苏地区";
$areanames{zh}->{861309518} = "新疆乌鲁木齐市";
$areanames{zh}->{861309519} = "新疆喀什地区";
$areanames{zh}->{861309520} = "云南省昭通市";
$areanames{zh}->{861309521} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861309522} = "云南省临沧市";
$areanames{zh}->{861309523} = "云南省丽江市";
$areanames{zh}->{861309524} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861309525} = "云南省大理白族自治州";
$areanames{zh}->{861309526} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309527} = "云南省曲靖市";
$areanames{zh}->{861309528} = "云南省楚雄彝族自治州";
$areanames{zh}->{861309529} = "云南省玉溪市";
$areanames{zh}->{86130953} = "云南省昆明市";
$areanames{zh}->{861309537} = "云南省普洱市";
$areanames{zh}->{861309538} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861309539} = "云南省保山市";
$areanames{zh}->{861309540} = "安徽省阜阳市";
$areanames{zh}->{861309541} = "安徽省阜阳市";
$areanames{zh}->{861309542} = "安徽省阜阳市";
$areanames{zh}->{861309543} = "安徽省黄山市";
$areanames{zh}->{861309544} = "安徽省黄山市";
$areanames{zh}->{861309545} = "安徽省合肥市";
$areanames{zh}->{861309546} = "安徽省马鞍山市";
$areanames{zh}->{861309547} = "安徽省淮南市";
$areanames{zh}->{861309548} = "安徽省铜陵市";
$areanames{zh}->{861309549} = "安徽省芜湖市";
$areanames{zh}->{861309550} = "安徽省滁州市";
$areanames{zh}->{861309551} = "安徽省合肥市";
$areanames{zh}->{861309552} = "安徽省蚌埠市";
$areanames{zh}->{861309553} = "安徽省芜湖市";
$areanames{zh}->{861309554} = "安徽省淮南市";
$areanames{zh}->{861309555} = "安徽省马鞍山市";
$areanames{zh}->{861309556} = "安徽省安庆市";
$areanames{zh}->{861309557} = "安徽省宿州市";
$areanames{zh}->{861309558} = "安徽省阜阳市";
$areanames{zh}->{861309559} = "安徽省黄山市";
$areanames{zh}->{861309560} = "浙江省嘉兴市";
$areanames{zh}->{861309561} = "浙江省嘉兴市";
$areanames{zh}->{861309562} = "浙江省嘉兴市";
$areanames{zh}->{861309563} = "浙江省嘉兴市";
$areanames{zh}->{861309564} = "浙江省嘉兴市";
$areanames{zh}->{861309565} = "浙江省绍兴市";
$areanames{zh}->{861309566} = "浙江省绍兴市";
$areanames{zh}->{861309567} = "浙江省绍兴市";
$areanames{zh}->{861309568} = "浙江省绍兴市";
$areanames{zh}->{861309569} = "浙江省绍兴市";
$areanames{zh}->{861309570} = "浙江省衢州市";
$areanames{zh}->{861309571} = "浙江省杭州市";
$areanames{zh}->{861309572} = "浙江省湖州市";
$areanames{zh}->{861309573} = "浙江省嘉兴市";
$areanames{zh}->{861309574} = "浙江省宁波市";
$areanames{zh}->{861309575} = "浙江省绍兴市";
$areanames{zh}->{861309576} = "浙江省台州市";
$areanames{zh}->{861309577} = "浙江省温州市";
$areanames{zh}->{861309578} = "浙江省丽水市";
$areanames{zh}->{861309579} = "浙江省金华市";
$areanames{zh}->{861309580} = "浙江省舟山市";
$areanames{zh}->{861309581} = "浙江省舟山市";
$areanames{zh}->{861309582} = "浙江省衢州市";
$areanames{zh}->{861309583} = "浙江省丽水市";
$areanames{zh}->{861309584} = "浙江省湖州市";
$areanames{zh}->{861309585} = "浙江省湖州市";
$areanames{zh}->{861309586} = "浙江省湖州市";
$areanames{zh}->{861309587} = "浙江省金华市";
$areanames{zh}->{861309588} = "浙江省金华市";
$areanames{zh}->{861309589} = "浙江省金华市";
$areanames{zh}->{86130959} = "浙江省宁波市";
$areanames{zh}->{861309600} = "四川省自贡市";
$areanames{zh}->{861309601} = "四川省自贡市";
$areanames{zh}->{861309602} = "四川省眉山市";
$areanames{zh}->{861309603} = "四川省攀枝花市";
$areanames{zh}->{861309604} = "四川省绵阳市";
$areanames{zh}->{861309605} = "四川省乐山市";
$areanames{zh}->{861309606} = "四川省资阳市";
$areanames{zh}->{861309607} = "四川省眉山市";
$areanames{zh}->{861309608} = "四川省内江市";
$areanames{zh}->{861309609} = "四川省攀枝花市";
$areanames{zh}->{861309610} = "四川省德阳市";
$areanames{zh}->{861309611} = "四川省广元市";
$areanames{zh}->{861309612} = "四川省绵阳市";
$areanames{zh}->{861309613} = "四川省南充市";
$areanames{zh}->{861309614} = "四川省南充市";
$areanames{zh}->{861309615} = "四川省资阳市";
$areanames{zh}->{861309616} = "四川省资阳市";
$areanames{zh}->{861309617} = "四川省绵阳市";
$areanames{zh}->{861309618} = "四川省宜宾市";
$areanames{zh}->{861309619} = "四川省达州市";
$areanames{zh}->{861309620} = "四川省宜宾市";
$areanames{zh}->{861309621} = "四川省宜宾市";
$areanames{zh}->{861309622} = "四川省宜宾市";
$areanames{zh}->{861309623} = "四川省绵阳市";
$areanames{zh}->{861309624} = "四川省攀枝花市";
$areanames{zh}->{861309625} = "四川省眉山市";
$areanames{zh}->{861309626} = "四川省甘孜藏族自治州";
$areanames{zh}->{861309627} = "四川省雅安市";
$areanames{zh}->{861309628} = "四川省德阳市";
$areanames{zh}->{861309629} = "四川省德阳市";
$areanames{zh}->{86130963} = "四川省成都市";
$areanames{zh}->{861309640} = "四川省乐山市";
$areanames{zh}->{861309641} = "四川省眉山市";
$areanames{zh}->{861309642} = "四川省乐山市";
$areanames{zh}->{861309643} = "四川省德阳市";
$areanames{zh}->{861309644} = "四川省德阳市";
$areanames{zh}->{861309645} = "四川省德阳市";
$areanames{zh}->{861309646} = "四川省广元市";
$areanames{zh}->{861309647} = "四川省广元市";
$areanames{zh}->{861309648} = "四川省绵阳市";
$areanames{zh}->{861309649} = "四川省绵阳市";
$areanames{zh}->{861309650} = "山西省阳泉市";
$areanames{zh}->{861309651} = "山西省运城市";
$areanames{zh}->{861309652} = "山西省临汾市";
$areanames{zh}->{861309653} = "山西省晋中市";
$areanames{zh}->{861309654} = "山西省大同市";
$areanames{zh}->{861309655} = "山西省晋城市";
$areanames{zh}->{861309656} = "山西省长治市";
$areanames{zh}->{861309657} = "山西省忻州市";
$areanames{zh}->{861309658} = "山西省大同市";
$areanames{zh}->{861309659} = "山西省大同市";
$areanames{zh}->{861309660} = "山西省朔州市";
$areanames{zh}->{861309661} = "山西省运城市";
$areanames{zh}->{861309662} = "山西省临汾市";
$areanames{zh}->{861309663} = "山西省晋中市";
$areanames{zh}->{861309664} = "山西省临汾市";
$areanames{zh}->{861309665} = "山西省晋城市";
$areanames{zh}->{861309666} = "山西省长治市";
$areanames{zh}->{861309667} = "山西省吕梁市";
$areanames{zh}->{861309668} = "山西省大同市";
$areanames{zh}->{861309669} = "山西省大同市";
$areanames{zh}->{86130967} = "贵州省遵义市";
$areanames{zh}->{861309680} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861309681} = "贵州省六盘水市";
$areanames{zh}->{861309682} = "贵州省毕节地区";
$areanames{zh}->{861309683} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861309684} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861309685} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861309686} = "贵州省铜仁地区";
$areanames{zh}->{861309687} = "贵州省毕节地区";
$areanames{zh}->{861309688} = "贵州省六盘水市";
$areanames{zh}->{861309689} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86130969} = "陕西省西安市";
$areanames{zh}->{861309700} = "江西省新余市";
$areanames{zh}->{861309701} = "江西省抚州市";
$areanames{zh}->{861309702} = "江西省九江市";
$areanames{zh}->{861309703} = "江西省上饶市";
$areanames{zh}->{861309704} = "江西省抚州市";
$areanames{zh}->{861309705} = "江西省宜春市";
$areanames{zh}->{861309706} = "江西省吉安市";
$areanames{zh}->{861309707} = "江西省赣州市";
$areanames{zh}->{861309708} = "江西省上饶市";
$areanames{zh}->{861309709} = "江西省萍乡市";
$areanames{zh}->{861309710} = "江西省景德镇市";
$areanames{zh}->{861309711} = "江西省抚州市";
$areanames{zh}->{861309712} = "江西省景德镇市";
$areanames{zh}->{861309713} = "江西省上饶市";
$areanames{zh}->{861309714} = "江西省吉安市";
$areanames{zh}->{861309715} = "江西省宜春市";
$areanames{zh}->{861309716} = "江西省赣州市";
$areanames{zh}->{861309717} = "江西省赣州市";
$areanames{zh}->{861309718} = "江西省景德镇市";
$areanames{zh}->{861309719} = "江西省萍乡市";
$areanames{zh}->{861309720} = "江西省南昌市";
$areanames{zh}->{861309721} = "江西省南昌市";
$areanames{zh}->{861309722} = "江西省吉安市";
$areanames{zh}->{861309723} = "江西省景德镇市";
$areanames{zh}->{861309724} = "江西省赣州市";
$areanames{zh}->{861309725} = "江西省九江市";
$areanames{zh}->{861309726} = "江西省九江市";
$areanames{zh}->{861309727} = "江西省九江市";
$areanames{zh}->{861309728} = "江西省南昌市";
$areanames{zh}->{861309729} = "江西省九江市";
$areanames{zh}->{861309730} = "江西省赣州市";
$areanames{zh}->{861309731} = "江西省赣州市";
$areanames{zh}->{861309732} = "江西省赣州市";
$areanames{zh}->{861309733} = "江西省赣州市";
$areanames{zh}->{861309734} = "江西省赣州市";
$areanames{zh}->{861309735} = "江西省萍乡市";
$areanames{zh}->{861309736} = "江西省上饶市";
$areanames{zh}->{861309737} = "江西省上饶市";
$areanames{zh}->{861309738} = "江西省上饶市";
$areanames{zh}->{861309739} = "江西省上饶市";
$areanames{zh}->{861309740} = "云南省玉溪市";
$areanames{zh}->{861309741} = "云南省玉溪市";
$areanames{zh}->{861309742} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309743} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309744} = "云南省丽江市";
$areanames{zh}->{861309745} = "云南省昭通市";
$areanames{zh}->{861309746} = "云南省曲靖市";
$areanames{zh}->{861309747} = "云南省曲靖市";
$areanames{zh}->{861309748} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861309749} = "云南省大理白族自治州";
$areanames{zh}->{861309750} = "山西省阳泉市";
$areanames{zh}->{861309751} = "山西省运城市";
$areanames{zh}->{861309752} = "山西省临汾市";
$areanames{zh}->{861309753} = "山西省晋中市";
$areanames{zh}->{861309754} = "山西省大同市";
$areanames{zh}->{861309755} = "山西省晋城市";
$areanames{zh}->{861309756} = "山西省长治市";
$areanames{zh}->{861309757} = "山西省吕梁市";
$areanames{zh}->{861309758} = "山西省吕梁市";
$areanames{zh}->{861309759} = "山西省大同市";
$areanames{zh}->{861309760} = "山西省阳泉市";
$areanames{zh}->{861309761} = "山西省运城市";
$areanames{zh}->{861309762} = "山西省临汾市";
$areanames{zh}->{861309763} = "山西省晋中市";
$areanames{zh}->{861309764} = "山西省朔州市";
$areanames{zh}->{861309765} = "山西省晋城市";
$areanames{zh}->{861309766} = "山西省长治市";
$areanames{zh}->{861309767} = "山西省忻州市";
$areanames{zh}->{861309768} = "山西省朔州市";
$areanames{zh}->{861309769} = "山西省大同市";
$areanames{zh}->{861309770} = "广西防城港市";
$areanames{zh}->{861309771} = "广西南宁市";
$areanames{zh}->{861309772} = "广西柳州市";
$areanames{zh}->{861309773} = "广西桂林市";
$areanames{zh}->{861309774} = "广西梧州市";
$areanames{zh}->{861309775} = "广西玉林市";
$areanames{zh}->{861309776} = "广西百色市";
$areanames{zh}->{861309777} = "广西钦州市";
$areanames{zh}->{861309778} = "广西河池市";
$areanames{zh}->{861309779} = "广西北海市";
$areanames{zh}->{861309780} = "广西防城港市";
$areanames{zh}->{861309781} = "广西北海市";
$areanames{zh}->{861309782} = "广西贵港市";
$areanames{zh}->{861309783} = "广西贺州市";
$areanames{zh}->{861309784} = "广西梧州市";
$areanames{zh}->{861309785} = "广西玉林市";
$areanames{zh}->{861309786} = "广西百色市";
$areanames{zh}->{861309787} = "广西钦州市";
$areanames{zh}->{861309788} = "广西梧州市";
$areanames{zh}->{861309789} = "广西北海市";
$areanames{zh}->{861309790} = "广西防城港市";
$areanames{zh}->{861309791} = "广西北海市";
$areanames{zh}->{861309792} = "广西贵港市";
$areanames{zh}->{861309793} = "广西桂林市";
$areanames{zh}->{861309794} = "广西梧州市";
$areanames{zh}->{861309795} = "广西玉林市";
$areanames{zh}->{861309796} = "广西百色市";
$areanames{zh}->{861309797} = "广西钦州市";
$areanames{zh}->{861309798} = "广西河池市";
$areanames{zh}->{861309799} = "广西北海市";
$areanames{zh}->{86130980} = "陕西省延安市";
$areanames{zh}->{861309800} = "陕西省安康市";
$areanames{zh}->{861309801} = "陕西省安康市";
$areanames{zh}->{861309802} = "陕西省安康市";
$areanames{zh}->{861309803} = "陕西省安康市";
$areanames{zh}->{861309810} = "陕西省咸阳市";
$areanames{zh}->{861309811} = "陕西省咸阳市";
$areanames{zh}->{861309812} = "陕西省渭南市";
$areanames{zh}->{861309813} = "陕西省渭南市";
$areanames{zh}->{861309814} = "陕西省渭南市";
$areanames{zh}->{861309815} = "陕西省宝鸡市";
$areanames{zh}->{861309816} = "陕西省宝鸡市";
$areanames{zh}->{861309817} = "陕西省铜川市";
$areanames{zh}->{861309818} = "陕西省铜川市";
$areanames{zh}->{861309819} = "陕西省铜川市";
$areanames{zh}->{86130982} = "陕西省榆林市";
$areanames{zh}->{861309820} = "陕西省汉中市";
$areanames{zh}->{861309821} = "陕西省汉中市";
$areanames{zh}->{861309822} = "陕西省商洛市";
$areanames{zh}->{861309823} = "陕西省商洛市";
$areanames{zh}->{861309830} = "湖北省荆州市";
$areanames{zh}->{861309831} = "湖北省荆州市";
$areanames{zh}->{861309832} = "湖北省武汉市";
$areanames{zh}->{861309833} = "湖北省武汉市";
$areanames{zh}->{861309834} = "湖北省武汉市";
$areanames{zh}->{861309835} = "湖北省咸宁市";
$areanames{zh}->{861309836} = "湖北省黄冈市";
$areanames{zh}->{861309837} = "湖北省黄冈市";
$areanames{zh}->{861309838} = "湖北省鄂州市";
$areanames{zh}->{861309839} = "湖北省黄石市";
$areanames{zh}->{861309840} = "湖北省宜昌市";
$areanames{zh}->{861309841} = "湖北省宜昌市";
$areanames{zh}->{861309842} = "湖北省荆门市";
$areanames{zh}->{861309843} = "湖北省荆门市";
$areanames{zh}->{861309844} = "湖北省随州市";
$areanames{zh}->{861309845} = "湖北省襄樊市";
$areanames{zh}->{861309846} = "湖北省襄樊市";
$areanames{zh}->{861309847} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861309848} = "湖北省孝感市";
$areanames{zh}->{861309849} = "湖北省十堰市";
$areanames{zh}->{861309850} = "贵州省贵阳市";
$areanames{zh}->{861309851} = "贵州省贵阳市";
$areanames{zh}->{861309852} = "贵州省遵义市";
$areanames{zh}->{861309853} = "贵州省安顺市";
$areanames{zh}->{861309854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861309855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861309856} = "贵州省铜仁地区";
$areanames{zh}->{861309857} = "贵州省毕节地区";
$areanames{zh}->{861309858} = "贵州省六盘水市";
$areanames{zh}->{861309859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86130986} = "重庆市";
$areanames{zh}->{86130987} = "重庆市";
$areanames{zh}->{86130988} = "湖北省武汉市";
$areanames{zh}->{86130989} = "海南省海口市";
$areanames{zh}->{86130990} = "山西省太原市";
$areanames{zh}->{861309901} = "山西省运城市";
$areanames{zh}->{861309902} = "山西省临汾市";
$areanames{zh}->{861309903} = "山西省忻州市";
$areanames{zh}->{86130991} = "甘肃省兰州市";
$areanames{zh}->{86130992} = "甘肃省兰州市";
$areanames{zh}->{861309927} = "甘肃省白银市";
$areanames{zh}->{861309928} = "甘肃省白银市";
$areanames{zh}->{861309929} = "甘肃省临夏回族自治州";
$areanames{zh}->{861309930} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861309931} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861309932} = "甘肃省陇南市";
$areanames{zh}->{861309933} = "甘肃省平凉市";
$areanames{zh}->{861309934} = "甘肃省陇南市";
$areanames{zh}->{861309935} = "甘肃省庆阳市";
$areanames{zh}->{861309936} = "甘肃省庆阳市";
$areanames{zh}->{861309937} = "甘肃省嘉峪关市";
$areanames{zh}->{861309938} = "甘肃省张掖市";
$areanames{zh}->{861309939} = "甘肃省嘉峪关市";
$areanames{zh}->{86130994} = "云南省昆明市";
$areanames{zh}->{861309947} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861309948} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861309949} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861309950} = "宁夏银川市";
$areanames{zh}->{861309951} = "宁夏银川市";
$areanames{zh}->{861309952} = "宁夏石嘴山市";
$areanames{zh}->{861309953} = "宁夏吴忠市";
$areanames{zh}->{861309954} = "宁夏固原市";
$areanames{zh}->{861309955} = "宁夏吴忠市";
$areanames{zh}->{861309956} = "宁夏石嘴山市";
$areanames{zh}->{861309957} = "宁夏银川市";
$areanames{zh}->{861309958} = "宁夏银川市";
$areanames{zh}->{861309959} = "宁夏银川市";
$areanames{zh}->{861309960} = "云南省临沧市";
$areanames{zh}->{861309961} = "云南省临沧市";
$areanames{zh}->{861309962} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861309963} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861309964} = "云南省昭通市";
$areanames{zh}->{861309965} = "云南省普洱市";
$areanames{zh}->{861309966} = "云南省普洱市";
$areanames{zh}->{861309967} = "云南省保山市";
$areanames{zh}->{861309968} = "云南省保山市";
$areanames{zh}->{861309969} = "云南省文山壮族苗族自治州";
$areanames{zh}->{86130997} = "青海省西宁市";
$areanames{zh}->{861309970} = "青海省玉树藏族自治州";
$areanames{zh}->{861309971} = "青海省果洛藏族自治州";
$areanames{zh}->{861309972} = "青海省海东地区";
$areanames{zh}->{861309973} = "青海省黄南藏族自治州";
$areanames{zh}->{861309980} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309981} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861309982} = "云南省楚雄彝族自治州";
$areanames{zh}->{861309983} = "云南省楚雄彝族自治州";
$areanames{zh}->{861309984} = "云南省大理白族自治州";
$areanames{zh}->{861309985} = "云南省大理白族自治州";
$areanames{zh}->{861309986} = "云南省曲靖市";
$areanames{zh}->{861309987} = "云南省曲靖市";
$areanames{zh}->{861309988} = "云南省玉溪市";
$areanames{zh}->{861309989} = "云南省玉溪市";
$areanames{zh}->{86130999} = "云南省昆明市";
$areanames{zh}->{861310000} = "山西省太原市";
$areanames{zh}->{861310001} = "山西省太原市";
$areanames{zh}->{861310002} = "山西省大同市";
$areanames{zh}->{861310003} = "山西省阳泉市";
$areanames{zh}->{861310004} = "山西省朔州市";
$areanames{zh}->{861310005} = "山西省长治市";
$areanames{zh}->{861310006} = "山西省晋城市";
$areanames{zh}->{861310007} = "山西省临汾市";
$areanames{zh}->{861310008} = "山西省吕梁市";
$areanames{zh}->{861310009} = "山西省运城市";
$areanames{zh}->{861310010} = "山西省忻州市";
$areanames{zh}->{861310011} = "山西省太原市";
$areanames{zh}->{861310012} = "山西省大同市";
$areanames{zh}->{861310013} = "山西省晋中市";
$areanames{zh}->{861310014} = "山西省太原市";
$areanames{zh}->{861310015} = "山西省长治市";
$areanames{zh}->{861310016} = "山西省晋城市";
$areanames{zh}->{861310017} = "山西省临汾市";
$areanames{zh}->{861310018} = "山西省晋中市";
$areanames{zh}->{861310019} = "山西省运城市";
$areanames{zh}->{861310020} = "湖南省岳阳市";
$areanames{zh}->{861310021} = "湖南省怀化市";
$areanames{zh}->{861310022} = "湖南省永州市";
$areanames{zh}->{861310023} = "湖南省株洲市";
$areanames{zh}->{861310024} = "湖南省张家界市";
$areanames{zh}->{861310025} = "湖南省长沙市";
$areanames{zh}->{861310026} = "湖南省衡阳市";
$areanames{zh}->{861310027} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861310028} = "湖南省常德市";
$areanames{zh}->{861310029} = "湖南省常德市";
$areanames{zh}->{861310030} = "湖南省岳阳市";
$areanames{zh}->{861310031} = "湖南省长沙市";
$areanames{zh}->{861310032} = "湖南省湘潭市";
$areanames{zh}->{861310033} = "湖南省株洲市";
$areanames{zh}->{861310034} = "湖南省衡阳市";
$areanames{zh}->{861310035} = "湖南省郴州市";
$areanames{zh}->{861310036} = "湖南省娄底市";
$areanames{zh}->{861310037} = "湖南省益阳市";
$areanames{zh}->{861310038} = "湖南省郴州市";
$areanames{zh}->{861310039} = "湖南省邵阳市";
$areanames{zh}->{861310040} = "广西南宁市";
$areanames{zh}->{861310041} = "广西南宁市";
$areanames{zh}->{861310042} = "广西柳州市";
$areanames{zh}->{861310043} = "广西桂林市";
$areanames{zh}->{861310044} = "广西贺州市";
$areanames{zh}->{861310045} = "广西玉林市";
$areanames{zh}->{861310046} = "广西百色市";
$areanames{zh}->{861310047} = "广西贵港市";
$areanames{zh}->{861310048} = "广西河池市";
$areanames{zh}->{861310049} = "广西柳州市";
$areanames{zh}->{861310050} = "广西南宁市";
$areanames{zh}->{861310051} = "广西南宁市";
$areanames{zh}->{861310052} = "广西柳州市";
$areanames{zh}->{861310053} = "广西桂林市";
$areanames{zh}->{861310054} = "广西贺州市";
$areanames{zh}->{861310055} = "广西玉林市";
$areanames{zh}->{861310056} = "广西百色市";
$areanames{zh}->{861310057} = "广西贵港市";
$areanames{zh}->{861310058} = "广西河池市";
$areanames{zh}->{861310059} = "广西桂林市";
$areanames{zh}->{86131006} = "湖北省武汉市";
$areanames{zh}->{861310070} = "湖北省武汉市";
$areanames{zh}->{861310071} = "湖北省武汉市";
$areanames{zh}->{861310072} = "湖北省武汉市";
$areanames{zh}->{861310073} = "湖北省武汉市";
$areanames{zh}->{861310074} = "湖北省黄冈市";
$areanames{zh}->{861310075} = "湖北省随州市";
$areanames{zh}->{861310076} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861310077} = "湖北省襄樊市";
$areanames{zh}->{861310078} = "湖北省宜昌市";
$areanames{zh}->{861310079} = "湖北省荆州市";
$areanames{zh}->{86131008} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310082} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310086} = "黑龙江省黑河市";
$areanames{zh}->{861310089} = "黑龙江省大庆市";
$areanames{zh}->{86131009} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310092} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310094} = "黑龙江省黑河市";
$areanames{zh}->{861310098} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310099} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{86131010} = "重庆市";
$areanames{zh}->{86131011} = "重庆市";
$areanames{zh}->{86131012} = "重庆市";
$areanames{zh}->{86131013} = "重庆市";
$areanames{zh}->{861310140} = "福建省福州市";
$areanames{zh}->{861310141} = "福建省福州市";
$areanames{zh}->{861310142} = "福建省福州市";
$areanames{zh}->{861310143} = "福建省厦门市";
$areanames{zh}->{861310144} = "福建省泉州市";
$areanames{zh}->{861310145} = "福建省泉州市";
$areanames{zh}->{861310146} = "福建省泉州市";
$areanames{zh}->{861310147} = "福建省宁德市";
$areanames{zh}->{861310148} = "福建省宁德市";
$areanames{zh}->{861310149} = "福建省三明市";
$areanames{zh}->{861310150} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310151} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310152} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310153} = "黑龙江省牡丹江市";
$areanames{zh}->{861310154} = "黑龙江省黑河市";
$areanames{zh}->{861310155} = "黑龙江省绥化市";
$areanames{zh}->{861310156} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310157} = "黑龙江省鸡西市";
$areanames{zh}->{861310158} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310159} = "黑龙江省大庆市";
$areanames{zh}->{861310160} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310161} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310162} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310163} = "黑龙江省牡丹江市";
$areanames{zh}->{861310164} = "黑龙江省大庆市";
$areanames{zh}->{861310165} = "黑龙江省佳木斯市";
$areanames{zh}->{861310166} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310167} = "黑龙江省鸡西市";
$areanames{zh}->{861310168} = "黑龙江省鹤岗市";
$areanames{zh}->{861310169} = "黑龙江省双鸭山市";
$areanames{zh}->{861310170} = "河南省商丘市";
$areanames{zh}->{861310171} = "河南省郑州市";
$areanames{zh}->{861310172} = "河南省安阳市";
$areanames{zh}->{861310173} = "河南省新乡市";
$areanames{zh}->{861310174} = "河南省南阳市";
$areanames{zh}->{861310175} = "河南省平顶山市";
$areanames{zh}->{861310176} = "河南省信阳市";
$areanames{zh}->{861310177} = "河南省南阳市";
$areanames{zh}->{861310178} = "河南省开封市";
$areanames{zh}->{861310179} = "河南省洛阳市";
$areanames{zh}->{861310180} = "江苏省泰州市";
$areanames{zh}->{861310181} = "江苏省泰州市";
$areanames{zh}->{861310182} = "江苏省徐州市";
$areanames{zh}->{861310183} = "江苏省徐州市";
$areanames{zh}->{861310184} = "江苏省南京市";
$areanames{zh}->{861310185} = "江苏省扬州市";
$areanames{zh}->{861310186} = "江苏省宿迁市";
$areanames{zh}->{861310187} = "江苏省宿迁市";
$areanames{zh}->{861310188} = "江苏省南京市";
$areanames{zh}->{861310189} = "江苏省南京市";
$areanames{zh}->{861310190} = "江苏省淮安市";
$areanames{zh}->{861310191} = "江苏省淮安市";
$areanames{zh}->{861310192} = "江苏省镇江市";
$areanames{zh}->{861310193} = "江苏省镇江市";
$areanames{zh}->{861310194} = "江苏省南通市";
$areanames{zh}->{861310195} = "江苏省扬州市";
$areanames{zh}->{861310196} = "江苏省无锡市";
$areanames{zh}->{861310197} = "江苏省无锡市";
$areanames{zh}->{861310198} = "江苏省南通市";
$areanames{zh}->{861310199} = "江苏省南通市";
$areanames{zh}->{86131020} = "天津市";
$areanames{zh}->{86131021} = "天津市";
$areanames{zh}->{86131022} = "天津市";
$areanames{zh}->{86131023} = "重庆市";
$areanames{zh}->{861310240} = "河北省沧州市";
$areanames{zh}->{861310241} = "河北省沧州市";
$areanames{zh}->{861310242} = "河北省沧州市";
$areanames{zh}->{861310243} = "河北省沧州市";
$areanames{zh}->{861310244} = "河北省沧州市";
$areanames{zh}->{861310245} = "河北省廊坊市";
$areanames{zh}->{861310246} = "河北省廊坊市";
$areanames{zh}->{861310247} = "河北省廊坊市";
$areanames{zh}->{861310248} = "河北省廊坊市";
$areanames{zh}->{861310249} = "河北省廊坊市";
$areanames{zh}->{861310250} = "河北省秦皇岛市";
$areanames{zh}->{861310251} = "河北省秦皇岛市";
$areanames{zh}->{861310252} = "河北省秦皇岛市";
$areanames{zh}->{861310253} = "河北省秦皇岛市";
$areanames{zh}->{861310254} = "河北省秦皇岛市";
$areanames{zh}->{861310255} = "河北省邢台市";
$areanames{zh}->{861310256} = "河北省邢台市";
$areanames{zh}->{861310257} = "河北省邢台市";
$areanames{zh}->{861310258} = "河北省邢台市";
$areanames{zh}->{861310259} = "河北省邢台市";
$areanames{zh}->{86131026} = "河北省唐山市";
$areanames{zh}->{861310270} = "河北省沧州市";
$areanames{zh}->{861310271} = "河北省沧州市";
$areanames{zh}->{861310272} = "河北省沧州市";
$areanames{zh}->{861310273} = "河北省沧州市";
$areanames{zh}->{861310274} = "河北省沧州市";
$areanames{zh}->{861310275} = "河北省衡水市";
$areanames{zh}->{861310276} = "河北省衡水市";
$areanames{zh}->{861310277} = "河北省衡水市";
$areanames{zh}->{861310278} = "河北省衡水市";
$areanames{zh}->{861310279} = "河北省衡水市";
$areanames{zh}->{86131028} = "河北省石家庄市";
$areanames{zh}->{86131029} = "河北省保定市";
$areanames{zh}->{861310300} = "河北省邯郸市";
$areanames{zh}->{861310301} = "河北省石家庄市";
$areanames{zh}->{861310302} = "河北省保定市";
$areanames{zh}->{861310303} = "河北省张家口市";
$areanames{zh}->{861310304} = "河北省承德市";
$areanames{zh}->{861310305} = "河北省唐山市";
$areanames{zh}->{861310306} = "河北省廊坊市";
$areanames{zh}->{861310307} = "河北省沧州市";
$areanames{zh}->{861310308} = "河北省衡水市";
$areanames{zh}->{861310309} = "河北省邢台市";
$areanames{zh}->{861310310} = "河北省邯郸市";
$areanames{zh}->{861310311} = "河北省石家庄市";
$areanames{zh}->{861310312} = "河北省保定市";
$areanames{zh}->{861310313} = "河北省张家口市";
$areanames{zh}->{861310314} = "河北省承德市";
$areanames{zh}->{861310315} = "河北省唐山市";
$areanames{zh}->{861310316} = "河北省廊坊市";
$areanames{zh}->{861310317} = "河北省沧州市";
$areanames{zh}->{861310318} = "河北省衡水市";
$areanames{zh}->{861310319} = "河北省邢台市";
$areanames{zh}->{861310320} = "河北省邯郸市";
$areanames{zh}->{861310321} = "河北省石家庄市";
$areanames{zh}->{861310322} = "河北省保定市";
$areanames{zh}->{861310323} = "河北省张家口市";
$areanames{zh}->{861310324} = "河北省承德市";
$areanames{zh}->{861310325} = "河北省唐山市";
$areanames{zh}->{861310326} = "河北省廊坊市";
$areanames{zh}->{861310327} = "河北省沧州市";
$areanames{zh}->{861310328} = "河北省衡水市";
$areanames{zh}->{861310329} = "河北省邢台市";
$areanames{zh}->{861310330} = "河北省邯郸市";
$areanames{zh}->{861310331} = "河北省石家庄市";
$areanames{zh}->{861310332} = "河北省保定市";
$areanames{zh}->{861310333} = "河北省张家口市";
$areanames{zh}->{861310334} = "河北省承德市";
$areanames{zh}->{861310335} = "河北省秦皇岛市";
$areanames{zh}->{861310336} = "河北省廊坊市";
$areanames{zh}->{861310337} = "河北省沧州市";
$areanames{zh}->{861310338} = "河北省衡水市";
$areanames{zh}->{861310339} = "河北省邢台市";
$areanames{zh}->{861310340} = "山西省大同市";
$areanames{zh}->{861310341} = "山西省太原市";
$areanames{zh}->{861310342} = "山西省大同市";
$areanames{zh}->{861310343} = "山西省太原市";
$areanames{zh}->{861310344} = "山西省太原市";
$areanames{zh}->{861310345} = "山西省长治市";
$areanames{zh}->{861310346} = "山西省晋城市";
$areanames{zh}->{861310347} = "山西省临汾市";
$areanames{zh}->{861310348} = "山西省运城市";
$areanames{zh}->{861310349} = "山西省朔州市";
$areanames{zh}->{861310350} = "山西省忻州市";
$areanames{zh}->{861310351} = "山西省太原市";
$areanames{zh}->{861310352} = "山西省大同市";
$areanames{zh}->{861310353} = "山西省阳泉市";
$areanames{zh}->{861310354} = "山西省晋中市";
$areanames{zh}->{861310355} = "山西省长治市";
$areanames{zh}->{861310356} = "山西省晋城市";
$areanames{zh}->{861310357} = "山西省临汾市";
$areanames{zh}->{861310358} = "山西省吕梁市";
$areanames{zh}->{861310359} = "山西省运城市";
$areanames{zh}->{861310360} = "河南省商丘市";
$areanames{zh}->{861310361} = "河南省焦作市";
$areanames{zh}->{861310362} = "河南省安阳市";
$areanames{zh}->{861310363} = "河南省濮阳市";
$areanames{zh}->{861310364} = "河南省濮阳市";
$areanames{zh}->{861310365} = "河南省平顶山市";
$areanames{zh}->{861310366} = "河南省驻马店市";
$areanames{zh}->{861310367} = "河南省南阳市";
$areanames{zh}->{861310368} = "河南省南阳市";
$areanames{zh}->{861310369} = "河南省漯河市";
$areanames{zh}->{861310370} = "河南省商丘市";
$areanames{zh}->{861310371} = "河南省郑州市";
$areanames{zh}->{861310372} = "河南省安阳市";
$areanames{zh}->{861310373} = "河南省新乡市";
$areanames{zh}->{861310374} = "河南省许昌市";
$areanames{zh}->{861310375} = "河南省平顶山市";
$areanames{zh}->{861310376} = "河南省信阳市";
$areanames{zh}->{861310377} = "河南省南阳市";
$areanames{zh}->{861310378} = "河南省开封市";
$areanames{zh}->{861310379} = "河南省洛阳市";
$areanames{zh}->{86131038} = "河南省郑州市";
$areanames{zh}->{861310380} = "河南省新乡市";
$areanames{zh}->{861310387} = "河南省周口市";
$areanames{zh}->{861310388} = "河南省许昌市";
$areanames{zh}->{861310389} = "河南省焦作市";
$areanames{zh}->{861310390} = "河南省商丘市";
$areanames{zh}->{861310391} = "河南省焦作市";
$areanames{zh}->{861310392} = "河南省鹤壁市";
$areanames{zh}->{861310393} = "河南省濮阳市";
$areanames{zh}->{861310394} = "河南省周口市";
$areanames{zh}->{861310395} = "河南省漯河市";
$areanames{zh}->{861310396} = "河南省驻马店市";
$areanames{zh}->{861310397} = "河南省信阳市";
$areanames{zh}->{861310398} = "河南省三门峡市";
$areanames{zh}->{861310399} = "河南省焦作市";
$areanames{zh}->{861310400} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310401} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310402} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310403} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310404} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310405} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310406} = "黑龙江省双鸭山市";
$areanames{zh}->{861310407} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310408} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310409} = "黑龙江省大庆市";
$areanames{zh}->{861310410} = "辽宁省铁岭市";
$areanames{zh}->{861310411} = "辽宁省大连市";
$areanames{zh}->{861310412} = "辽宁省鞍山市";
$areanames{zh}->{861310413} = "辽宁省抚顺市";
$areanames{zh}->{861310414} = "辽宁省本溪市";
$areanames{zh}->{861310415} = "辽宁省丹东市";
$areanames{zh}->{861310416} = "辽宁省锦州市";
$areanames{zh}->{861310417} = "辽宁省营口市";
$areanames{zh}->{861310418} = "辽宁省阜新市";
$areanames{zh}->{861310419} = "辽宁省辽阳市";
$areanames{zh}->{861310420} = "辽宁省营口市";
$areanames{zh}->{861310421} = "辽宁省朝阳市";
$areanames{zh}->{861310422} = "辽宁省鞍山市";
$areanames{zh}->{861310423} = "辽宁省抚顺市";
$areanames{zh}->{861310424} = "辽宁省本溪市";
$areanames{zh}->{861310425} = "辽宁省丹东市";
$areanames{zh}->{861310426} = "辽宁省锦州市";
$areanames{zh}->{861310427} = "辽宁省盘锦市";
$areanames{zh}->{861310428} = "辽宁省阜新市";
$areanames{zh}->{861310429} = "辽宁省葫芦岛市";
$areanames{zh}->{861310430} = "吉林省长春市";
$areanames{zh}->{861310431} = "吉林省长春市";
$areanames{zh}->{861310432} = "吉林省吉林市";
$areanames{zh}->{861310433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861310434} = "吉林省四平市";
$areanames{zh}->{861310435} = "吉林省通化市";
$areanames{zh}->{861310436} = "吉林省白城市";
$areanames{zh}->{861310437} = "吉林省辽源市";
$areanames{zh}->{861310438} = "吉林省松原市";
$areanames{zh}->{861310439} = "吉林省白山市";
$areanames{zh}->{86131044} = "吉林省长春市";
$areanames{zh}->{861310450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861310453} = "黑龙江省牡丹江市";
$areanames{zh}->{861310454} = "黑龙江省佳木斯市";
$areanames{zh}->{861310455} = "黑龙江省绥化市";
$areanames{zh}->{861310456} = "黑龙江省黑河市";
$areanames{zh}->{861310457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861310458} = "黑龙江省伊春市";
$areanames{zh}->{861310459} = "黑龙江省大庆市";
$areanames{zh}->{86131046} = "黑龙江省哈尔滨市";
$areanames{zh}->{861310464} = "黑龙江省七台河市";
$areanames{zh}->{861310467} = "黑龙江省鸡西市";
$areanames{zh}->{861310468} = "黑龙江省鹤岗市";
$areanames{zh}->{861310469} = "黑龙江省双鸭山市";
$areanames{zh}->{861310470} = "广东省珠海市";
$areanames{zh}->{861310471} = "广东省珠海市";
$areanames{zh}->{861310472} = "广东省珠海市";
$areanames{zh}->{861310473} = "广东省珠海市";
$areanames{zh}->{861310474} = "广东省珠海市";
$areanames{zh}->{861310475} = "广东省东莞市";
$areanames{zh}->{861310476} = "广东省东莞市";
$areanames{zh}->{861310477} = "广东省东莞市";
$areanames{zh}->{861310478} = "广东省东莞市";
$areanames{zh}->{861310479} = "广东省东莞市";
$areanames{zh}->{861310480} = "广东省云浮市";
$areanames{zh}->{861310481} = "广东省云浮市";
$areanames{zh}->{861310482} = "广东省汕头市";
$areanames{zh}->{861310483} = "广东省汕头市";
$areanames{zh}->{861310484} = "河北省邢台市";
$areanames{zh}->{861310485} = "广东省广州市";
$areanames{zh}->{861310486} = "广东省广州市";
$areanames{zh}->{861310487} = "广东省广州市";
$areanames{zh}->{861310488} = "广东省广州市";
$areanames{zh}->{861310489} = "广东省广州市";
$areanames{zh}->{861310490} = "广东省湛江市";
$areanames{zh}->{861310491} = "广东省湛江市";
$areanames{zh}->{861310492} = "广东省湛江市";
$areanames{zh}->{861310493} = "广东省湛江市";
$areanames{zh}->{861310494} = "广东省江门市";
$areanames{zh}->{861310495} = "广东省江门市";
$areanames{zh}->{861310496} = "广东省肇庆市";
$areanames{zh}->{861310497} = "广东省肇庆市";
$areanames{zh}->{861310498} = "广东省茂名市";
$areanames{zh}->{861310499} = "广东省茂名市";
$areanames{zh}->{86131050} = "福建省漳州市";
$areanames{zh}->{861310506} = "福建省泉州市";
$areanames{zh}->{861310507} = "福建省泉州市";
$areanames{zh}->{861310508} = "福建省泉州市";
$areanames{zh}->{861310509} = "福建省泉州市";
$areanames{zh}->{86131051} = "山东省青岛市";
$areanames{zh}->{861310510} = "山东省日照市";
$areanames{zh}->{861310511} = "山东省枣庄市";
$areanames{zh}->{86131052} = "山东省烟台市";
$areanames{zh}->{861310530} = "山东省菏泽市";
$areanames{zh}->{861310531} = "山东省济南市";
$areanames{zh}->{861310532} = "山东省青岛市";
$areanames{zh}->{861310533} = "山东省淄博市";
$areanames{zh}->{861310534} = "山东省德州市";
$areanames{zh}->{861310535} = "山东省烟台市";
$areanames{zh}->{861310536} = "山东省潍坊市";
$areanames{zh}->{861310537} = "山东省济宁市";
$areanames{zh}->{861310538} = "山东省泰安市";
$areanames{zh}->{861310539} = "山东省临沂市";
$areanames{zh}->{861310540} = "山东省菏泽市";
$areanames{zh}->{861310541} = "山东省济南市";
$areanames{zh}->{861310542} = "山东省青岛市";
$areanames{zh}->{861310543} = "山东省滨州市";
$areanames{zh}->{861310544} = "山东省德州市";
$areanames{zh}->{861310545} = "山东省烟台市";
$areanames{zh}->{861310546} = "山东省东营市";
$areanames{zh}->{861310547} = "山东省济宁市";
$areanames{zh}->{861310548} = "山东省泰安市";
$areanames{zh}->{861310549} = "山东省临沂市";
$areanames{zh}->{86131055} = "浙江省宁波市";
$areanames{zh}->{861310550} = "浙江省嘉兴市";
$areanames{zh}->{861310551} = "浙江省嘉兴市";
$areanames{zh}->{861310559} = "浙江省金华市";
$areanames{zh}->{86131056} = "浙江省台州市";
$areanames{zh}->{861310570} = "浙江省衢州市";
$areanames{zh}->{861310571} = "浙江省杭州市";
$areanames{zh}->{861310572} = "浙江省湖州市";
$areanames{zh}->{861310573} = "浙江省嘉兴市";
$areanames{zh}->{861310574} = "浙江省宁波市";
$areanames{zh}->{861310575} = "浙江省绍兴市";
$areanames{zh}->{861310576} = "浙江省台州市";
$areanames{zh}->{861310577} = "浙江省温州市";
$areanames{zh}->{861310578} = "浙江省丽水市";
$areanames{zh}->{861310579} = "浙江省金华市";
$areanames{zh}->{861310580} = "浙江省舟山市";
$areanames{zh}->{861310581} = "浙江省杭州市";
$areanames{zh}->{861310582} = "浙江省湖州市";
$areanames{zh}->{861310583} = "浙江省嘉兴市";
$areanames{zh}->{861310584} = "浙江省衢州市";
$areanames{zh}->{861310585} = "浙江省绍兴市";
$areanames{zh}->{861310586} = "浙江省台州市";
$areanames{zh}->{861310587} = "浙江省舟山市";
$areanames{zh}->{861310588} = "浙江省丽水市";
$areanames{zh}->{861310589} = "浙江省金华市";
$areanames{zh}->{861310590} = "福建省龙岩市";
$areanames{zh}->{861310591} = "福建省龙岩市";
$areanames{zh}->{861310592} = "福建省龙岩市";
$areanames{zh}->{861310593} = "福建省宁德市";
$areanames{zh}->{861310594} = "福建省龙岩市";
$areanames{zh}->{861310595} = "福建省宁德市";
$areanames{zh}->{861310596} = "福建省宁德市";
$areanames{zh}->{861310597} = "福建省宁德市";
$areanames{zh}->{861310598} = "福建省南平市";
$areanames{zh}->{861310599} = "福建省南平市";
$areanames{zh}->{86131060} = "浙江省台州市";
$areanames{zh}->{861310606} = "浙江省衢州市";
$areanames{zh}->{861310607} = "浙江省衢州市";
$areanames{zh}->{861310608} = "浙江省衢州市";
$areanames{zh}->{861310609} = "浙江省衢州市";
$areanames{zh}->{86131061} = "浙江省温州市";
$areanames{zh}->{86131062} = "浙江省金华市";
$areanames{zh}->{861310627} = "浙江省丽水市";
$areanames{zh}->{861310628} = "浙江省丽水市";
$areanames{zh}->{861310629} = "浙江省丽水市";
$areanames{zh}->{86131063} = "浙江省绍兴市";
$areanames{zh}->{861310638} = "浙江省丽水市";
$areanames{zh}->{861310639} = "浙江省丽水市";
$areanames{zh}->{861310640} = "浙江省金华市";
$areanames{zh}->{861310641} = "浙江省金华市";
$areanames{zh}->{861310642} = "浙江省金华市";
$areanames{zh}->{861310643} = "浙江省绍兴市";
$areanames{zh}->{861310644} = "浙江省绍兴市";
$areanames{zh}->{861310645} = "浙江省台州市";
$areanames{zh}->{861310646} = "浙江省台州市";
$areanames{zh}->{861310647} = "浙江省台州市";
$areanames{zh}->{861310648} = "浙江省台州市";
$areanames{zh}->{861310649} = "浙江省台州市";
$areanames{zh}->{86131065} = "河北省石家庄市";
$areanames{zh}->{861310654} = "广东省深圳市";
$areanames{zh}->{861310657} = "广东省佛山市";
$areanames{zh}->{861310658} = "广东省佛山市";
$areanames{zh}->{861310659} = "广东省佛山市";
$areanames{zh}->{861310660} = "广东省湛江市";
$areanames{zh}->{861310661} = "广东省湛江市";
$areanames{zh}->{861310662} = "广东省湛江市";
$areanames{zh}->{861310663} = "广东省湛江市";
$areanames{zh}->{861310664} = "广东省湛江市";
$areanames{zh}->{861310665} = "广东省佛山市";
$areanames{zh}->{861310666} = "广东省佛山市";
$areanames{zh}->{861310667} = "广东省佛山市";
$areanames{zh}->{861310668} = "广东省佛山市";
$areanames{zh}->{861310669} = "河北省廊坊市";
$areanames{zh}->{86131067} = "广东省佛山市";
$areanames{zh}->{861310677} = "广东省阳江市";
$areanames{zh}->{861310678} = "广东省阳江市";
$areanames{zh}->{861310679} = "广东省阳江市";
$areanames{zh}->{861310680} = "广东省珠海市";
$areanames{zh}->{861310681} = "广东省珠海市";
$areanames{zh}->{861310682} = "广东省珠海市";
$areanames{zh}->{861310683} = "广东省珠海市";
$areanames{zh}->{861310684} = "广东省珠海市";
$areanames{zh}->{861310685} = "广东省东莞市";
$areanames{zh}->{861310686} = "广东省东莞市";
$areanames{zh}->{861310687} = "广东省东莞市";
$areanames{zh}->{861310688} = "广东省东莞市";
$areanames{zh}->{861310689} = "广东省东莞市";
$areanames{zh}->{861310690} = "广东省肇庆市";
$areanames{zh}->{861310691} = "广东省肇庆市";
$areanames{zh}->{861310692} = "广东省肇庆市";
$areanames{zh}->{861310693} = "广东省揭阳市";
$areanames{zh}->{861310694} = "广东省揭阳市";
$areanames{zh}->{861310695} = "广东省江门市";
$areanames{zh}->{861310696} = "广东省江门市";
$areanames{zh}->{861310697} = "广东省江门市";
$areanames{zh}->{861310698} = "广东省江门市";
$areanames{zh}->{861310699} = "广东省江门市";
$areanames{zh}->{861310700} = "湖南省株洲市";
$areanames{zh}->{861310701} = "湖南省株洲市";
$areanames{zh}->{861310702} = "湖南省株洲市";
$areanames{zh}->{861310703} = "湖南省株洲市";
$areanames{zh}->{861310704} = "湖南省衡阳市";
$areanames{zh}->{861310705} = "湖南省郴州市";
$areanames{zh}->{861310706} = "湖南省郴州市";
$areanames{zh}->{861310707} = "湖南省益阳市";
$areanames{zh}->{861310708} = "湖南省郴州市";
$areanames{zh}->{861310709} = "湖南省邵阳市";
$areanames{zh}->{861310710} = "湖南省岳阳市";
$areanames{zh}->{861310711} = "湖南省长沙市";
$areanames{zh}->{861310712} = "湖南省湘潭市";
$areanames{zh}->{861310713} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861310714} = "湖南省张家界市";
$areanames{zh}->{861310715} = "湖南省怀化市";
$areanames{zh}->{861310716} = "湖南省永州市";
$areanames{zh}->{861310717} = "湖南省益阳市";
$areanames{zh}->{861310718} = "湖南省娄底市";
$areanames{zh}->{861310719} = "湖南省邵阳市";
$areanames{zh}->{861310720} = "湖南省岳阳市";
$areanames{zh}->{861310721} = "湖南省长沙市";
$areanames{zh}->{861310722} = "湖南省湘潭市";
$areanames{zh}->{861310723} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861310724} = "湖南省衡阳市";
$areanames{zh}->{861310725} = "湖南省怀化市";
$areanames{zh}->{861310726} = "湖南省永州市";
$areanames{zh}->{861310727} = "湖南省益阳市";
$areanames{zh}->{861310728} = "湖南省娄底市";
$areanames{zh}->{861310729} = "湖南省邵阳市";
$areanames{zh}->{861310730} = "湖南省岳阳市";
$areanames{zh}->{861310731} = "湖南省长沙市";
$areanames{zh}->{861310732} = "湖南省湘潭市";
$areanames{zh}->{861310733} = "湖南省株洲市";
$areanames{zh}->{861310734} = "湖南省衡阳市";
$areanames{zh}->{861310735} = "湖南省郴州市";
$areanames{zh}->{861310736} = "湖南省常德市";
$areanames{zh}->{861310737} = "湖南省益阳市";
$areanames{zh}->{861310738} = "湖南省娄底市";
$areanames{zh}->{861310739} = "湖南省邵阳市";
$areanames{zh}->{861310740} = "湖南省常德市";
$areanames{zh}->{861310741} = "湖南省长沙市";
$areanames{zh}->{861310742} = "湖南省长沙市";
$areanames{zh}->{861310743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861310744} = "湖南省张家界市";
$areanames{zh}->{861310745} = "湖南省怀化市";
$areanames{zh}->{861310746} = "湖南省永州市";
$areanames{zh}->{861310747} = "湖南省岳阳市";
$areanames{zh}->{861310748} = "湖南省长沙市";
$areanames{zh}->{861310749} = "湖南省长沙市";
$areanames{zh}->{861310750} = "青海省海东地区";
$areanames{zh}->{861310751} = "青海省海东地区";
$areanames{zh}->{861310752} = "青海省海东地区";
$areanames{zh}->{861310753} = "青海省海东地区";
$areanames{zh}->{861310754} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861310755} = "青海省西宁市";
$areanames{zh}->{861310756} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861310757} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861310758} = "青海省西宁市";
$areanames{zh}->{861310759} = "青海省西宁市";
$areanames{zh}->{86131076} = "福建省福州市";
$areanames{zh}->{861310770} = "浙江省杭州市";
$areanames{zh}->{861310771} = "浙江省杭州市";
$areanames{zh}->{861310772} = "浙江省杭州市";
$areanames{zh}->{861310773} = "浙江省杭州市";
$areanames{zh}->{861310774} = "浙江省杭州市";
$areanames{zh}->{861310775} = "浙江省温州市";
$areanames{zh}->{861310776} = "浙江省温州市";
$areanames{zh}->{861310777} = "浙江省温州市";
$areanames{zh}->{861310778} = "浙江省温州市";
$areanames{zh}->{861310779} = "浙江省温州市";
$areanames{zh}->{86131078} = "福建省泉州市";
$areanames{zh}->{861310790} = "福建省三明市";
$areanames{zh}->{861310791} = "福建省三明市";
$areanames{zh}->{861310792} = "福建省福州市";
$areanames{zh}->{861310793} = "福建省福州市";
$areanames{zh}->{861310794} = "福建省福州市";
$areanames{zh}->{861310795} = "福建省莆田市";
$areanames{zh}->{861310796} = "福建省莆田市";
$areanames{zh}->{861310797} = "福建省莆田市";
$areanames{zh}->{861310798} = "福建省莆田市";
$areanames{zh}->{861310799} = "福建省莆田市";
$areanames{zh}->{861310800} = "四川省宜宾市";
$areanames{zh}->{861310801} = "陕西省商洛市";
$areanames{zh}->{861310802} = "陕西省延安市";
$areanames{zh}->{861310803} = "四川省内江市";
$areanames{zh}->{861310804} = "陕西省宝鸡市";
$areanames{zh}->{861310805} = "四川省泸州市";
$areanames{zh}->{861310806} = "四川省泸州市";
$areanames{zh}->{861310807} = "四川省资阳市";
$areanames{zh}->{861310808} = "四川省自贡市";
$areanames{zh}->{861310809} = "陕西省延安市";
$areanames{zh}->{86131081} = "四川省绵阳市";
$areanames{zh}->{861310812} = "四川省攀枝花市";
$areanames{zh}->{861310813} = "陕西省延安市";
$areanames{zh}->{861310817} = "四川省南充市";
$areanames{zh}->{861310818} = "四川省达州市";
$areanames{zh}->{861310820} = "四川省眉山市";
$areanames{zh}->{861310821} = "四川省德阳市";
$areanames{zh}->{861310822} = "四川省德阳市";
$areanames{zh}->{861310823} = "四川省乐山市";
$areanames{zh}->{861310824} = "四川省乐山市";
$areanames{zh}->{861310825} = "四川省遂宁市";
$areanames{zh}->{861310826} = "四川省广安市";
$areanames{zh}->{861310827} = "四川省巴中市";
$areanames{zh}->{861310828} = "陕西省宝鸡市";
$areanames{zh}->{861310829} = "陕西省宝鸡市";
$areanames{zh}->{861310830} = "四川省泸州市";
$areanames{zh}->{861310831} = "四川省宜宾市";
$areanames{zh}->{861310832} = "四川省内江市";
$areanames{zh}->{861310833} = "四川省乐山市";
$areanames{zh}->{861310834} = "四川省凉山彝族自治州";
$areanames{zh}->{861310835} = "四川省雅安市";
$areanames{zh}->{861310836} = "四川省甘孜藏族自治州";
$areanames{zh}->{861310837} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861310838} = "四川省德阳市";
$areanames{zh}->{861310839} = "四川省广元市";
$areanames{zh}->{861310840} = "四川省广元市";
$areanames{zh}->{861310841} = "四川省德阳市";
$areanames{zh}->{861310842} = "四川省广安市";
$areanames{zh}->{861310843} = "四川省眉山市";
$areanames{zh}->{861310844} = "四川省达州市";
$areanames{zh}->{861310845} = "四川省遂宁市";
$areanames{zh}->{861310846} = "陕西省汉中市";
$areanames{zh}->{861310847} = "陕西省渭南市";
$areanames{zh}->{861310848} = "四川省凉山彝族自治州";
$areanames{zh}->{861310849} = "陕西省榆林市";
$areanames{zh}->{861310850} = "云南省昆明市";
$areanames{zh}->{861310851} = "云南省昆明市";
$areanames{zh}->{861310852} = "云南省昆明市";
$areanames{zh}->{861310853} = "云南省昆明市";
$areanames{zh}->{861310854} = "云南省昆明市";
$areanames{zh}->{861310855} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861310856} = "云南省大理白族自治州";
$areanames{zh}->{861310857} = "云南省大理白族自治州";
$areanames{zh}->{861310858} = "云南省昭通市";
$areanames{zh}->{861310859} = "云南省普洱市";
$areanames{zh}->{861310860} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861310861} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861310862} = "云南省楚雄彝族自治州";
$areanames{zh}->{861310863} = "云南省曲靖市";
$areanames{zh}->{861310864} = "云南省玉溪市";
$areanames{zh}->{861310865} = "云南省昆明市";
$areanames{zh}->{861310866} = "云南省昆明市";
$areanames{zh}->{861310867} = "云南省昆明市";
$areanames{zh}->{861310868} = "云南省昆明市";
$areanames{zh}->{861310869} = "云南省昆明市";
$areanames{zh}->{861310870} = "云南省昆明市";
$areanames{zh}->{861310871} = "云南省昆明市";
$areanames{zh}->{861310872} = "云南省大理白族自治州";
$areanames{zh}->{861310873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861310874} = "云南省曲靖市";
$areanames{zh}->{861310875} = "云南省保山市";
$areanames{zh}->{861310876} = "云南省昆明市";
$areanames{zh}->{861310877} = "云南省玉溪市";
$areanames{zh}->{861310878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861310879} = "云南省普洱市";
$areanames{zh}->{86131088} = "云南省昆明市";
$areanames{zh}->{861310881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861310882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861310888} = "云南省丽江市";
$areanames{zh}->{86131089} = "重庆市";
$areanames{zh}->{861310900} = "新疆昌吉回族自治州";
$areanames{zh}->{861310901} = "新疆昌吉回族自治州";
$areanames{zh}->{861310902} = "新疆昌吉回族自治州";
$areanames{zh}->{861310903} = "新疆吐鲁番地区";
$areanames{zh}->{861310904} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861310905} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861310906} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861310907} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861310908} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861310909} = "新疆阿克苏地区";
$areanames{zh}->{861310910} = "陕西省渭南市";
$areanames{zh}->{861310911} = "陕西省渭南市";
$areanames{zh}->{861310912} = "陕西省渭南市";
$areanames{zh}->{861310913} = "陕西省渭南市";
$areanames{zh}->{861310914} = "陕西省宝鸡市";
$areanames{zh}->{861310915} = "陕西省宝鸡市";
$areanames{zh}->{861310916} = "陕西省宝鸡市";
$areanames{zh}->{861310917} = "陕西省宝鸡市";
$areanames{zh}->{861310918} = "陕西省汉中市";
$areanames{zh}->{861310919} = "陕西省汉中市";
$areanames{zh}->{86131092} = "陕西省榆林市";
$areanames{zh}->{861310926} = "陕西省安康市";
$areanames{zh}->{861310927} = "陕西省安康市";
$areanames{zh}->{861310928} = "陕西省安康市";
$areanames{zh}->{861310929} = "陕西省安康市";
$areanames{zh}->{86131093} = "甘肃省兰州市";
$areanames{zh}->{861310934} = "甘肃省庆阳市";
$areanames{zh}->{86131094} = "甘肃省兰州市";
$areanames{zh}->{861310944} = "甘肃省定西市";
$areanames{zh}->{861310945} = "甘肃省金昌市";
$areanames{zh}->{861310946} = "甘肃省天水市";
$areanames{zh}->{861310947} = "甘肃省酒泉市";
$areanames{zh}->{86131095} = "陕西省西安市";
$areanames{zh}->{861310960} = "陕西省咸阳市";
$areanames{zh}->{861310961} = "陕西省咸阳市";
$areanames{zh}->{861310962} = "陕西省咸阳市";
$areanames{zh}->{861310963} = "陕西省咸阳市";
$areanames{zh}->{861310964} = "陕西省渭南市";
$areanames{zh}->{861310965} = "陕西省渭南市";
$areanames{zh}->{861310966} = "陕西省宝鸡市";
$areanames{zh}->{861310967} = "陕西省延安市";
$areanames{zh}->{861310968} = "陕西省榆林市";
$areanames{zh}->{861310969} = "陕西省榆林市";
$areanames{zh}->{86131097} = "青海省西宁市";
$areanames{zh}->{861310980} = "辽宁省大连市";
$areanames{zh}->{861310981} = "辽宁省大连市";
$areanames{zh}->{861310982} = "辽宁省大连市";
$areanames{zh}->{861310983} = "辽宁省大连市";
$areanames{zh}->{861310984} = "辽宁省大连市";
$areanames{zh}->{861310985} = "辽宁省沈阳市";
$areanames{zh}->{861310986} = "辽宁省沈阳市";
$areanames{zh}->{861310987} = "辽宁省沈阳市";
$areanames{zh}->{861310988} = "辽宁省沈阳市";
$areanames{zh}->{861310989} = "辽宁省沈阳市";
$areanames{zh}->{86131099} = "新疆乌鲁木齐市";
$areanames{zh}->{86131100} = "天津市";
$areanames{zh}->{86131101} = "重庆市";
$areanames{zh}->{86131102} = "重庆市";
$areanames{zh}->{86131103} = "陕西省渭南市";
$areanames{zh}->{861311036} = "陕西省汉中市";
$areanames{zh}->{861311037} = "陕西省汉中市";
$areanames{zh}->{861311038} = "陕西省汉中市";
$areanames{zh}->{861311039} = "陕西省汉中市";
$areanames{zh}->{86131104} = "陕西省西安市";
$areanames{zh}->{861311050} = "福建省福州市";
$areanames{zh}->{861311051} = "福建省福州市";
$areanames{zh}->{861311052} = "福建省福州市";
$areanames{zh}->{861311053} = "福建省福州市";
$areanames{zh}->{861311054} = "福建省福州市";
$areanames{zh}->{861311055} = "福建省莆田市";
$areanames{zh}->{861311056} = "福建省莆田市";
$areanames{zh}->{861311057} = "福建省南平市";
$areanames{zh}->{861311058} = "福建省三明市";
$areanames{zh}->{861311059} = "福建省厦门市";
$areanames{zh}->{861311060} = "福建省龙岩市";
$areanames{zh}->{861311061} = "福建省龙岩市";
$areanames{zh}->{861311062} = "福建省龙岩市";
$areanames{zh}->{861311063} = "福建省福州市";
$areanames{zh}->{861311064} = "福建省福州市";
$areanames{zh}->{861311065} = "福建省漳州市";
$areanames{zh}->{861311066} = "福建省漳州市";
$areanames{zh}->{861311067} = "福建省漳州市";
$areanames{zh}->{861311068} = "福建省龙岩市";
$areanames{zh}->{861311069} = "福建省莆田市";
$areanames{zh}->{861311070} = "福建省泉州市";
$areanames{zh}->{861311071} = "福建省泉州市";
$areanames{zh}->{861311072} = "福建省泉州市";
$areanames{zh}->{861311073} = "福建省泉州市";
$areanames{zh}->{861311074} = "福建省泉州市";
$areanames{zh}->{861311075} = "福建省福州市";
$areanames{zh}->{861311076} = "福建省福州市";
$areanames{zh}->{861311077} = "福建省福州市";
$areanames{zh}->{861311078} = "福建省福州市";
$areanames{zh}->{861311079} = "福建省福州市";
$areanames{zh}->{86131108} = "福建省泉州市";
$areanames{zh}->{861311084} = "福建省三明市";
$areanames{zh}->{861311087} = "福建省福州市";
$areanames{zh}->{861311088} = "福建省福州市";
$areanames{zh}->{861311089} = "福建省福州市";
$areanames{zh}->{86131109} = "福建省泉州市";
$areanames{zh}->{861311090} = "福建省南平市";
$areanames{zh}->{861311091} = "福建省南平市";
$areanames{zh}->{861311092} = "福建省厦门市";
$areanames{zh}->{861311093} = "福建省厦门市";
$areanames{zh}->{86131110} = "山西省太原市";
$areanames{zh}->{861311101} = "山西省晋中市";
$areanames{zh}->{861311102} = "山西省朔州市";
$areanames{zh}->{861311103} = "山西省晋中市";
$areanames{zh}->{861311110} = "山西省忻州市";
$areanames{zh}->{861311111} = "山西省临汾市";
$areanames{zh}->{861311112} = "山西省大同市";
$areanames{zh}->{861311113} = "山西省阳泉市";
$areanames{zh}->{861311114} = "山西省晋城市";
$areanames{zh}->{861311115} = "山西省长治市";
$areanames{zh}->{861311116} = "山西省晋城市";
$areanames{zh}->{861311117} = "山西省临汾市";
$areanames{zh}->{861311118} = "山西省吕梁市";
$areanames{zh}->{861311119} = "山西省运城市";
$areanames{zh}->{861311120} = "山西省忻州市";
$areanames{zh}->{861311121} = "山西省吕梁市";
$areanames{zh}->{861311122} = "山西省大同市";
$areanames{zh}->{861311123} = "山西省阳泉市";
$areanames{zh}->{861311124} = "山西省运城市";
$areanames{zh}->{861311125} = "山西省长治市";
$areanames{zh}->{861311126} = "山西省晋城市";
$areanames{zh}->{861311127} = "山西省临汾市";
$areanames{zh}->{861311128} = "山西省大同市";
$areanames{zh}->{861311129} = "山西省运城市";
$areanames{zh}->{86131113} = "河北省邯郸市";
$areanames{zh}->{86131114} = "河北省唐山市";
$areanames{zh}->{861311140} = "河北省秦皇岛市";
$areanames{zh}->{861311141} = "河北省秦皇岛市";
$areanames{zh}->{861311142} = "河北省秦皇岛市";
$areanames{zh}->{861311143} = "河北省秦皇岛市";
$areanames{zh}->{86131115} = "河北省石家庄市";
$areanames{zh}->{86131116} = "河北省保定市";
$areanames{zh}->{86131117} = "河北省沧州市";
$areanames{zh}->{861311180} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861311181} = "四川省甘孜藏族自治州";
$areanames{zh}->{861311182} = "四川省雅安市";
$areanames{zh}->{861311183} = "四川省雅安市";
$areanames{zh}->{861311184} = "四川省雅安市";
$areanames{zh}->{861311185} = "四川省成都市";
$areanames{zh}->{861311186} = "四川省成都市";
$areanames{zh}->{861311187} = "四川省成都市";
$areanames{zh}->{861311188} = "四川省成都市";
$areanames{zh}->{861311189} = "四川省成都市";
$areanames{zh}->{86131119} = "海南省海口市";
$areanames{zh}->{86131120} = "广东省韶关市";
$areanames{zh}->{86131121} = "广东省揭阳市";
$areanames{zh}->{86131122} = "广东省广州市";
$areanames{zh}->{86131123} = "广东省珠海市";
$areanames{zh}->{86131124} = "广东省梅州市";
$areanames{zh}->{86131125} = "广东省汕头市";
$areanames{zh}->{861311250} = "广东省潮州市";
$areanames{zh}->{861311251} = "广东省潮州市";
$areanames{zh}->{861311252} = "广东省潮州市";
$areanames{zh}->{861311253} = "广东省潮州市";
$areanames{zh}->{86131126} = "广东省惠州市";
$areanames{zh}->{86131127} = "广东省佛山市";
$areanames{zh}->{86131128} = "广东省东莞市";
$areanames{zh}->{86131129} = "广东省中山市";
$areanames{zh}->{861311300} = "广东省深圳市";
$areanames{zh}->{861311301} = "广东省深圳市";
$areanames{zh}->{861311302} = "广东省深圳市";
$areanames{zh}->{861311303} = "河北省石家庄市";
$areanames{zh}->{861311304} = "广东省深圳市";
$areanames{zh}->{861311305} = "广东省东莞市";
$areanames{zh}->{861311306} = "广东省东莞市";
$areanames{zh}->{861311307} = "广东省东莞市";
$areanames{zh}->{861311308} = "广东省东莞市";
$areanames{zh}->{861311309} = "广东省东莞市";
$areanames{zh}->{86131131} = "广东省东莞市";
$areanames{zh}->{86131132} = "广东省东莞市";
$areanames{zh}->{86131133} = "广东省广州市";
$areanames{zh}->{861311340} = "广东省惠州市";
$areanames{zh}->{861311341} = "广东省惠州市";
$areanames{zh}->{861311342} = "广东省珠海市";
$areanames{zh}->{861311343} = "广东省珠海市";
$areanames{zh}->{861311344} = "广东省珠海市";
$areanames{zh}->{861311345} = "河北省邢台市";
$areanames{zh}->{861311346} = "广东省江门市";
$areanames{zh}->{861311347} = "广东省汕头市";
$areanames{zh}->{861311348} = "广东省汕头市";
$areanames{zh}->{861311349} = "广东省汕头市";
$areanames{zh}->{861311350} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861311351} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861311352} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861311353} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861311354} = "内蒙古赤峰市";
$areanames{zh}->{861311355} = "内蒙古赤峰市";
$areanames{zh}->{861311356} = "内蒙古赤峰市";
$areanames{zh}->{861311357} = "内蒙古赤峰市";
$areanames{zh}->{861311358} = "内蒙古赤峰市";
$areanames{zh}->{861311359} = "内蒙古兴安盟";
$areanames{zh}->{86131136} = "广东省深圳市";
$areanames{zh}->{86131137} = "广东省佛山市";
$areanames{zh}->{861311370} = "河北省廊坊市";
$areanames{zh}->{86131138} = "广东省深圳市";
$areanames{zh}->{861311388} = "河北省石家庄市";
$areanames{zh}->{861311389} = "河北省石家庄市";
$areanames{zh}->{861311390} = "广东省中山市";
$areanames{zh}->{861311391} = "广东省中山市";
$areanames{zh}->{861311392} = "广东省中山市";
$areanames{zh}->{861311393} = "广东省中山市";
$areanames{zh}->{861311394} = "广东省中山市";
$areanames{zh}->{861311395} = "广东省广州市";
$areanames{zh}->{861311396} = "广东省广州市";
$areanames{zh}->{861311397} = "广东省广州市";
$areanames{zh}->{861311398} = "广东省广州市";
$areanames{zh}->{861311399} = "广东省广州市";
$areanames{zh}->{86131140} = "重庆市";
$areanames{zh}->{861311410} = "云南省玉溪市";
$areanames{zh}->{861311411} = "云南省曲靖市";
$areanames{zh}->{861311412} = "云南省大理白族自治州";
$areanames{zh}->{861311413} = "云南省楚雄彝族自治州";
$areanames{zh}->{861311414} = "云南省昆明市";
$areanames{zh}->{861311415} = "云南省普洱市";
$areanames{zh}->{861311416} = "云南省临沧市";
$areanames{zh}->{861311417} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861311418} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861311419} = "云南省保山市";
$areanames{zh}->{86131142} = "云南省昆明市";
$areanames{zh}->{86131143} = "湖北省武汉市";
$areanames{zh}->{861311430} = "湖北省荆州市";
$areanames{zh}->{861311431} = "湖北省荆州市";
$areanames{zh}->{861311440} = "湖北省随州市";
$areanames{zh}->{861311441} = "湖北省孝感市";
$areanames{zh}->{861311442} = "湖北省黄石市";
$areanames{zh}->{861311443} = "湖北省黄冈市";
$areanames{zh}->{861311444} = "湖北省十堰市";
$areanames{zh}->{861311445} = "湖北省宜昌市";
$areanames{zh}->{861311446} = "湖北省宜昌市";
$areanames{zh}->{861311447} = "湖北省襄樊市";
$areanames{zh}->{861311448} = "湖北省襄樊市";
$areanames{zh}->{861311449} = "湖北省荆门市";
$areanames{zh}->{861311450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861311453} = "黑龙江省牡丹江市";
$areanames{zh}->{861311454} = "黑龙江省佳木斯市";
$areanames{zh}->{861311455} = "黑龙江省绥化市";
$areanames{zh}->{861311456} = "黑龙江省黑河市";
$areanames{zh}->{861311457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861311458} = "黑龙江省伊春市";
$areanames{zh}->{861311459} = "黑龙江省大庆市";
$areanames{zh}->{861311460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861311463} = "黑龙江省牡丹江市";
$areanames{zh}->{861311464} = "黑龙江省七台河市";
$areanames{zh}->{861311465} = "黑龙江省绥化市";
$areanames{zh}->{861311466} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861311467} = "黑龙江省鸡西市";
$areanames{zh}->{861311468} = "黑龙江省鹤岗市";
$areanames{zh}->{861311469} = "黑龙江省双鸭山市";
$areanames{zh}->{861311470} = "广西防城港市";
$areanames{zh}->{861311471} = "广西南宁市";
$areanames{zh}->{861311472} = "广西柳州市";
$areanames{zh}->{861311473} = "广西桂林市";
$areanames{zh}->{861311474} = "广西梧州市";
$areanames{zh}->{861311475} = "广西玉林市";
$areanames{zh}->{861311476} = "广西百色市";
$areanames{zh}->{861311477} = "广西钦州市";
$areanames{zh}->{861311478} = "广西河池市";
$areanames{zh}->{861311479} = "广西北海市";
$areanames{zh}->{86131148} = "天津市";
$areanames{zh}->{86131149} = "天津市";
$areanames{zh}->{861311500} = "江苏省南京市";
$areanames{zh}->{861311501} = "江苏省南京市";
$areanames{zh}->{861311502} = "江苏省南京市";
$areanames{zh}->{861311503} = "江苏省南京市";
$areanames{zh}->{861311504} = "江苏省南京市";
$areanames{zh}->{861311505} = "江苏省无锡市";
$areanames{zh}->{861311506} = "江苏省无锡市";
$areanames{zh}->{861311507} = "江苏省无锡市";
$areanames{zh}->{861311508} = "江苏省无锡市";
$areanames{zh}->{861311509} = "江苏省无锡市";
$areanames{zh}->{861311510} = "江苏省苏州市";
$areanames{zh}->{861311511} = "江苏省苏州市";
$areanames{zh}->{861311512} = "江苏省苏州市";
$areanames{zh}->{861311513} = "江苏省连云港市";
$areanames{zh}->{861311514} = "江苏省连云港市";
$areanames{zh}->{861311515} = "江苏省连云港市";
$areanames{zh}->{861311516} = "江苏省盐城市";
$areanames{zh}->{861311517} = "江苏省扬州市";
$areanames{zh}->{861311518} = "江苏省扬州市";
$areanames{zh}->{861311519} = "江苏省扬州市";
$areanames{zh}->{861311520} = "江苏省徐州市";
$areanames{zh}->{861311521} = "江苏省徐州市";
$areanames{zh}->{861311522} = "江苏省徐州市";
$areanames{zh}->{861311523} = "江苏省淮安市";
$areanames{zh}->{861311524} = "江苏省淮安市";
$areanames{zh}->{861311525} = "江苏省淮安市";
$areanames{zh}->{861311526} = "江苏省盐城市";
$areanames{zh}->{861311527} = "江苏省常州市";
$areanames{zh}->{861311528} = "江苏省常州市";
$areanames{zh}->{861311529} = "江苏省常州市";
$areanames{zh}->{861311530} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311531} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311532} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861311533} = "黑龙江省牡丹江市";
$areanames{zh}->{861311534} = "黑龙江省佳木斯市";
$areanames{zh}->{861311535} = "黑龙江省佳木斯市";
$areanames{zh}->{861311536} = "黑龙江省佳木斯市";
$areanames{zh}->{861311537} = "黑龙江省鸡西市";
$areanames{zh}->{861311538} = "黑龙江省鹤岗市";
$areanames{zh}->{861311539} = "黑龙江省大庆市";
$areanames{zh}->{861311540} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311541} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311542} = "黑龙江省大庆市";
$areanames{zh}->{861311543} = "黑龙江省大庆市";
$areanames{zh}->{861311544} = "黑龙江省大庆市";
$areanames{zh}->{861311545} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311546} = "黑龙江省鸡西市";
$areanames{zh}->{861311547} = "黑龙江省鸡西市";
$areanames{zh}->{861311548} = "黑龙江省鹤岗市";
$areanames{zh}->{861311549} = "黑龙江省大庆市";
$areanames{zh}->{861311550} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311551} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311552} = "黑龙江省黑河市";
$areanames{zh}->{861311553} = "黑龙江省牡丹江市";
$areanames{zh}->{861311554} = "黑龙江省佳木斯市";
$areanames{zh}->{861311555} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311556} = "黑龙江省黑河市";
$areanames{zh}->{861311557} = "黑龙江省双鸭山市";
$areanames{zh}->{861311558} = "黑龙江省伊春市";
$areanames{zh}->{861311559} = "黑龙江省大庆市";
$areanames{zh}->{861311560} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311561} = "黑龙江省哈尔滨市";
$areanames{zh}->{861311562} = "黑龙江省黑河市";
$areanames{zh}->{861311563} = "黑龙江省牡丹江市";
$areanames{zh}->{861311564} = "黑龙江省鹤岗市";
$areanames{zh}->{861311565} = "黑龙江省绥化市";
$areanames{zh}->{861311566} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861311567} = "黑龙江省大庆市";
$areanames{zh}->{861311568} = "黑龙江省鹤岗市";
$areanames{zh}->{861311569} = "黑龙江省双鸭山市";
$areanames{zh}->{861311570} = "浙江省衢州市";
$areanames{zh}->{861311571} = "浙江省杭州市";
$areanames{zh}->{861311572} = "浙江省湖州市";
$areanames{zh}->{861311573} = "浙江省嘉兴市";
$areanames{zh}->{861311574} = "浙江省宁波市";
$areanames{zh}->{861311575} = "浙江省绍兴市";
$areanames{zh}->{861311576} = "浙江省台州市";
$areanames{zh}->{861311577} = "浙江省温州市";
$areanames{zh}->{861311578} = "浙江省丽水市";
$areanames{zh}->{861311579} = "浙江省金华市";
$areanames{zh}->{86131158} = "浙江省温州市";
$areanames{zh}->{861311580} = "浙江省舟山市";
$areanames{zh}->{861311590} = "福建省福州市";
$areanames{zh}->{861311591} = "福建省福州市";
$areanames{zh}->{861311592} = "福建省福州市";
$areanames{zh}->{861311593} = "福建省宁德市";
$areanames{zh}->{861311594} = "福建省莆田市";
$areanames{zh}->{861311595} = "福建省泉州市";
$areanames{zh}->{861311596} = "福建省漳州市";
$areanames{zh}->{861311597} = "福建省宁德市";
$areanames{zh}->{861311598} = "福建省三明市";
$areanames{zh}->{861311599} = "福建省泉州市";
$areanames{zh}->{86131160} = "天津市";
$areanames{zh}->{86131161} = "天津市";
$areanames{zh}->{86131162} = "云南省昆明市";
$areanames{zh}->{861311630} = "贵州省贵阳市";
$areanames{zh}->{861311631} = "贵州省贵阳市";
$areanames{zh}->{861311632} = "贵州省贵阳市";
$areanames{zh}->{861311633} = "贵州省遵义市";
$areanames{zh}->{861311634} = "贵州省遵义市";
$areanames{zh}->{861311635} = "贵州省遵义市";
$areanames{zh}->{861311636} = "贵州省六盘水市";
$areanames{zh}->{861311637} = "贵州省六盘水市";
$areanames{zh}->{861311638} = "贵州省六盘水市";
$areanames{zh}->{861311639} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861311640} = "贵州省安顺市";
$areanames{zh}->{861311641} = "贵州省安顺市";
$areanames{zh}->{861311642} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861311643} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861311644} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861311645} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861311646} = "贵州省毕节地区";
$areanames{zh}->{861311647} = "贵州省毕节地区";
$areanames{zh}->{861311648} = "贵州省铜仁地区";
$areanames{zh}->{861311649} = "贵州省贵阳市";
$areanames{zh}->{86131165} = "浙江省台州市";
$areanames{zh}->{86131166} = "浙江省宁波市";
$areanames{zh}->{86131167} = "浙江省杭州市";
$areanames{zh}->{861311680} = "浙江省舟山市";
$areanames{zh}->{861311681} = "浙江省嘉兴市";
$areanames{zh}->{861311682} = "浙江省湖州市";
$areanames{zh}->{861311683} = "浙江省嘉兴市";
$areanames{zh}->{861311684} = "浙江省衢州市";
$areanames{zh}->{861311685} = "浙江省绍兴市";
$areanames{zh}->{861311686} = "浙江省丽水市";
$areanames{zh}->{861311687} = "浙江省金华市";
$areanames{zh}->{861311688} = "浙江省金华市";
$areanames{zh}->{861311689} = "浙江省金华市";
$areanames{zh}->{861311690} = "云南省迪庆藏族自治州";
$areanames{zh}->{861311691} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861311692} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861311693} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861311694} = "云南省丽江市";
$areanames{zh}->{861311695} = "云南省昆明市";
$areanames{zh}->{861311696} = "云南省丽江市";
$areanames{zh}->{861311697} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861311698} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861311699} = "云南省昭通市";
$areanames{zh}->{861311700} = "湖北省孝感市";
$areanames{zh}->{861311701} = "湖北省黄石市";
$areanames{zh}->{861311702} = "湖北省黄石市";
$areanames{zh}->{861311703} = "湖北省黄石市";
$areanames{zh}->{861311704} = "湖北省咸宁市";
$areanames{zh}->{861311705} = "湖北省荆门市";
$areanames{zh}->{861311706} = "湖北省荆门市";
$areanames{zh}->{861311707} = "湖北省黄冈市";
$areanames{zh}->{861311708} = "湖北省黄冈市";
$areanames{zh}->{861311709} = "湖北省黄冈市";
$areanames{zh}->{861311710} = "湖北省十堰市";
$areanames{zh}->{861311711} = "湖北省武汉市";
$areanames{zh}->{861311712} = "湖北省武汉市";
$areanames{zh}->{861311713} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861311714} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861311715} = "湖北省咸宁市";
$areanames{zh}->{861311716} = "湖北省咸宁市";
$areanames{zh}->{861311717} = "湖北省荆州市";
$areanames{zh}->{861311718} = "湖北省荆州市";
$areanames{zh}->{861311719} = "湖北省荆州市";
$areanames{zh}->{861311720} = "湖北省鄂州市";
$areanames{zh}->{861311721} = "湖北省襄樊市";
$areanames{zh}->{861311722} = "湖北省襄樊市";
$areanames{zh}->{861311723} = "湖北省襄樊市";
$areanames{zh}->{861311724} = "湖北省武汉市";
$areanames{zh}->{861311725} = "湖北省武汉市";
$areanames{zh}->{861311726} = "湖北省随州市";
$areanames{zh}->{861311727} = "湖北省宜昌市";
$areanames{zh}->{861311728} = "湖北省宜昌市";
$areanames{zh}->{861311729} = "湖北省宜昌市";
$areanames{zh}->{861311730} = "湖南省岳阳市";
$areanames{zh}->{861311731} = "湖南省长沙市";
$areanames{zh}->{861311732} = "湖南省湘潭市";
$areanames{zh}->{861311733} = "湖南省株洲市";
$areanames{zh}->{861311734} = "湖南省衡阳市";
$areanames{zh}->{861311735} = "湖南省郴州市";
$areanames{zh}->{861311736} = "湖南省常德市";
$areanames{zh}->{861311737} = "湖南省益阳市";
$areanames{zh}->{861311738} = "湖南省娄底市";
$areanames{zh}->{861311739} = "湖南省邵阳市";
$areanames{zh}->{861311740} = "湖南省岳阳市";
$areanames{zh}->{861311741} = "湖南省长沙市";
$areanames{zh}->{861311742} = "湖南省湘潭市";
$areanames{zh}->{861311743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861311744} = "湖南省张家界市";
$areanames{zh}->{861311745} = "湖南省怀化市";
$areanames{zh}->{861311746} = "湖南省永州市";
$areanames{zh}->{861311747} = "湖南省益阳市";
$areanames{zh}->{861311748} = "湖南省娄底市";
$areanames{zh}->{861311749} = "湖南省邵阳市";
$areanames{zh}->{861311750} = "湖南省岳阳市";
$areanames{zh}->{861311751} = "湖南省长沙市";
$areanames{zh}->{861311752} = "湖南省湘潭市";
$areanames{zh}->{861311753} = "湖南省株洲市";
$areanames{zh}->{861311754} = "湖南省衡阳市";
$areanames{zh}->{861311755} = "湖南省郴州市";
$areanames{zh}->{861311756} = "湖南省常德市";
$areanames{zh}->{861311757} = "湖南省益阳市";
$areanames{zh}->{861311758} = "湖南省娄底市";
$areanames{zh}->{861311759} = "湖南省邵阳市";
$areanames{zh}->{861311760} = "广西南宁市";
$areanames{zh}->{861311761} = "广西南宁市";
$areanames{zh}->{861311762} = "广西柳州市";
$areanames{zh}->{861311763} = "广西桂林市";
$areanames{zh}->{861311764} = "广西贺州市";
$areanames{zh}->{861311765} = "广西玉林市";
$areanames{zh}->{861311766} = "广西贵港市";
$areanames{zh}->{861311767} = "广西贺州市";
$areanames{zh}->{861311768} = "广西河池市";
$areanames{zh}->{861311769} = "广西贵港市";
$areanames{zh}->{861311770} = "广西防城港市";
$areanames{zh}->{861311771} = "广西南宁市";
$areanames{zh}->{861311772} = "广西柳州市";
$areanames{zh}->{861311773} = "广西桂林市";
$areanames{zh}->{861311774} = "广西梧州市";
$areanames{zh}->{861311775} = "广西玉林市";
$areanames{zh}->{861311776} = "广西百色市";
$areanames{zh}->{861311777} = "广西钦州市";
$areanames{zh}->{861311778} = "广西河池市";
$areanames{zh}->{861311779} = "广西北海市";
$areanames{zh}->{861311780} = "江西省南昌市";
$areanames{zh}->{861311781} = "江西省南昌市";
$areanames{zh}->{861311782} = "江西省九江市";
$areanames{zh}->{861311783} = "江西省上饶市";
$areanames{zh}->{861311784} = "江西省上饶市";
$areanames{zh}->{861311785} = "江西省抚州市";
$areanames{zh}->{861311786} = "江西省吉安市";
$areanames{zh}->{861311787} = "江西省赣州市";
$areanames{zh}->{861311788} = "江西省赣州市";
$areanames{zh}->{861311789} = "江西省赣州市";
$areanames{zh}->{861311790} = "江西省新余市";
$areanames{zh}->{861311791} = "江西省南昌市";
$areanames{zh}->{861311792} = "江西省九江市";
$areanames{zh}->{861311793} = "江西省上饶市";
$areanames{zh}->{861311794} = "江西省抚州市";
$areanames{zh}->{861311795} = "江西省宜春市";
$areanames{zh}->{861311796} = "江西省吉安市";
$areanames{zh}->{861311797} = "江西省赣州市";
$areanames{zh}->{861311798} = "江西省景德镇市";
$areanames{zh}->{861311799} = "江西省萍乡市";
$areanames{zh}->{861311800} = "四川省宜宾市";
$areanames{zh}->{861311801} = "四川省宜宾市";
$areanames{zh}->{861311802} = "四川省泸州市";
$areanames{zh}->{861311803} = "四川省泸州市";
$areanames{zh}->{861311804} = "四川省资阳市";
$areanames{zh}->{861311805} = "四川省资阳市";
$areanames{zh}->{861311806} = "四川省内江市";
$areanames{zh}->{861311807} = "四川省内江市";
$areanames{zh}->{861311808} = "四川省自贡市";
$areanames{zh}->{861311809} = "四川省自贡市";
$areanames{zh}->{861311810} = "四川省德阳市";
$areanames{zh}->{861311811} = "四川省德阳市";
$areanames{zh}->{861311812} = "四川省德阳市";
$areanames{zh}->{861311813} = "四川省德阳市";
$areanames{zh}->{861311814} = "四川省广元市";
$areanames{zh}->{861311815} = "四川省广元市";
$areanames{zh}->{861311816} = "四川省绵阳市";
$areanames{zh}->{861311817} = "四川省绵阳市";
$areanames{zh}->{861311818} = "四川省绵阳市";
$areanames{zh}->{861311819} = "四川省绵阳市";
$areanames{zh}->{861311820} = "四川省遂宁市";
$areanames{zh}->{861311821} = "四川省遂宁市";
$areanames{zh}->{861311822} = "四川省遂宁市";
$areanames{zh}->{861311823} = "四川省广安市";
$areanames{zh}->{861311824} = "四川省广安市";
$areanames{zh}->{861311825} = "四川省广安市";
$areanames{zh}->{861311826} = "四川省南充市";
$areanames{zh}->{861311827} = "四川省南充市";
$areanames{zh}->{861311828} = "四川省南充市";
$areanames{zh}->{861311829} = "四川省南充市";
$areanames{zh}->{861311830} = "四川省攀枝花市";
$areanames{zh}->{861311831} = "四川省攀枝花市";
$areanames{zh}->{861311832} = "四川省凉山彝族自治州";
$areanames{zh}->{861311833} = "四川省凉山彝族自治州";
$areanames{zh}->{861311834} = "四川省眉山市";
$areanames{zh}->{861311835} = "四川省眉山市";
$areanames{zh}->{861311836} = "四川省眉山市";
$areanames{zh}->{861311837} = "四川省乐山市";
$areanames{zh}->{861311838} = "四川省乐山市";
$areanames{zh}->{861311839} = "四川省乐山市";
$areanames{zh}->{861311840} = "四川省资阳市";
$areanames{zh}->{861311841} = "四川省资阳市";
$areanames{zh}->{861311842} = "四川省资阳市";
$areanames{zh}->{861311843} = "四川省泸州市";
$areanames{zh}->{861311844} = "四川省泸州市";
$areanames{zh}->{861311845} = "四川省内江市";
$areanames{zh}->{861311846} = "四川省内江市";
$areanames{zh}->{861311847} = "四川省宜宾市";
$areanames{zh}->{861311848} = "四川省宜宾市";
$areanames{zh}->{861311849} = "四川省宜宾市";
$areanames{zh}->{861311850} = "贵州省贵阳市";
$areanames{zh}->{861311851} = "贵州省贵阳市";
$areanames{zh}->{861311852} = "贵州省遵义市";
$areanames{zh}->{861311853} = "贵州省安顺市";
$areanames{zh}->{861311854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861311855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861311856} = "贵州省铜仁地区";
$areanames{zh}->{861311857} = "贵州省毕节地区";
$areanames{zh}->{861311858} = "贵州省六盘水市";
$areanames{zh}->{861311859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86131186} = "广东省汕头市";
$areanames{zh}->{861311860} = "广东省潮州市";
$areanames{zh}->{861311861} = "广东省潮州市";
$areanames{zh}->{861311862} = "广东省潮州市";
$areanames{zh}->{861311863} = "广东省潮州市";
$areanames{zh}->{861311870} = "云南省昭通市";
$areanames{zh}->{861311871} = "云南省昆明市";
$areanames{zh}->{861311872} = "云南省大理白族自治州";
$areanames{zh}->{861311873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861311874} = "云南省曲靖市";
$areanames{zh}->{861311875} = "云南省保山市";
$areanames{zh}->{861311876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861311877} = "云南省玉溪市";
$areanames{zh}->{861311878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861311879} = "云南省普洱市";
$areanames{zh}->{86131188} = "广东省佛山市";
$areanames{zh}->{86131189} = "海南省海口市";
$areanames{zh}->{861311900} = "新疆昌吉回族自治州";
$areanames{zh}->{861311901} = "新疆塔城地区";
$areanames{zh}->{861311902} = "新疆哈密地区";
$areanames{zh}->{861311903} = "新疆和田地区";
$areanames{zh}->{861311904} = "新疆乌鲁木齐市";
$areanames{zh}->{861311905} = "新疆阿勒泰地区";
$areanames{zh}->{861311906} = "新疆阿勒泰地区";
$areanames{zh}->{861311907} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861311908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861311909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{86131191} = "陕西省西安市";
$areanames{zh}->{86131192} = "陕西省延安市";
$areanames{zh}->{861311928} = "陕西省榆林市";
$areanames{zh}->{861311929} = "陕西省榆林市";
$areanames{zh}->{861311930} = "甘肃省兰州市";
$areanames{zh}->{861311931} = "甘肃省兰州市";
$areanames{zh}->{861311932} = "甘肃省定西市";
$areanames{zh}->{861311933} = "甘肃省平凉市";
$areanames{zh}->{861311934} = "甘肃省庆阳市";
$areanames{zh}->{861311935} = "甘肃省武威市";
$areanames{zh}->{861311936} = "甘肃省张掖市";
$areanames{zh}->{861311937} = "甘肃省酒泉市";
$areanames{zh}->{861311938} = "甘肃省天水市";
$areanames{zh}->{861311939} = "甘肃省庆阳市";
$areanames{zh}->{861311940} = "甘肃省兰州市";
$areanames{zh}->{861311941} = "甘肃省兰州市";
$areanames{zh}->{861311942} = "甘肃省兰州市";
$areanames{zh}->{861311943} = "甘肃省兰州市";
$areanames{zh}->{861311944} = "甘肃省兰州市";
$areanames{zh}->{861311945} = "甘肃省酒泉市";
$areanames{zh}->{861311946} = "甘肃省酒泉市";
$areanames{zh}->{861311947} = "甘肃省平凉市";
$areanames{zh}->{861311948} = "甘肃省武威市";
$areanames{zh}->{861311949} = "甘肃省庆阳市";
$areanames{zh}->{86131195} = "广东省广州市";
$areanames{zh}->{86131196} = "广东省江门市";
$areanames{zh}->{861311970} = "青海省海北藏族自治州";
$areanames{zh}->{861311971} = "青海省西宁市";
$areanames{zh}->{861311972} = "青海省海东地区";
$areanames{zh}->{861311973} = "青海省黄南藏族自治州";
$areanames{zh}->{861311974} = "青海省海南藏族自治州";
$areanames{zh}->{861311975} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861311976} = "青海省西宁市";
$areanames{zh}->{861311977} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861311978} = "青海省西宁市";
$areanames{zh}->{861311979} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861311980} = "广东省汕尾市";
$areanames{zh}->{861311981} = "广东省汕尾市";
$areanames{zh}->{861311982} = "广东省汕尾市";
$areanames{zh}->{861311983} = "广东省汕尾市";
$areanames{zh}->{861311984} = "广东省汕尾市";
$areanames{zh}->{861311985} = "广东省佛山市";
$areanames{zh}->{861311986} = "广东省佛山市";
$areanames{zh}->{861311987} = "广东省佛山市";
$areanames{zh}->{861311988} = "广东省佛山市";
$areanames{zh}->{861311989} = "广东省佛山市";
$areanames{zh}->{861311990} = "新疆克拉玛依市";
$areanames{zh}->{861311991} = "新疆乌鲁木齐市";
$areanames{zh}->{861311992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861311993} = "新疆石河子市";
$areanames{zh}->{861311994} = "新疆昌吉回族自治州";
$areanames{zh}->{861311995} = "新疆吐鲁番地区";
$areanames{zh}->{861311996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861311997} = "新疆阿克苏地区";
$areanames{zh}->{861311998} = "新疆喀什地区";
$areanames{zh}->{861311999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86131200} = "北京市";
$areanames{zh}->{86131201} = "北京市";
$areanames{zh}->{86131202} = "北京市";
$areanames{zh}->{86131203} = "北京市";
$areanames{zh}->{86131204} = "北京市";
$areanames{zh}->{86131205} = "上海市";
$areanames{zh}->{86131206} = "上海市";
$areanames{zh}->{86131207} = "上海市";
$areanames{zh}->{86131208} = "上海市";
$areanames{zh}->{86131209} = "上海市";
$areanames{zh}->{8613121} = "北京市";
$areanames{zh}->{861312144} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861312174} = "内蒙古兴安盟";
$areanames{zh}->{8613122} = "上海市";
$areanames{zh}->{861312300} = "福建省泉州市";
$areanames{zh}->{861312301} = "福建省泉州市";
$areanames{zh}->{861312302} = "福建省泉州市";
$areanames{zh}->{861312303} = "福建省泉州市";
$areanames{zh}->{861312304} = "福建省三明市";
$areanames{zh}->{861312305} = "福建省三明市";
$areanames{zh}->{861312306} = "福建省三明市";
$areanames{zh}->{861312307} = "福建省龙岩市";
$areanames{zh}->{861312308} = "福建省龙岩市";
$areanames{zh}->{861312309} = "福建省龙岩市";
$areanames{zh}->{861312310} = "福建省泉州市";
$areanames{zh}->{861312311} = "福建省泉州市";
$areanames{zh}->{861312312} = "福建省泉州市";
$areanames{zh}->{861312313} = "福建省泉州市";
$areanames{zh}->{861312314} = "福建省宁德市";
$areanames{zh}->{861312315} = "福建省福州市";
$areanames{zh}->{861312316} = "福建省福州市";
$areanames{zh}->{861312317} = "福建省福州市";
$areanames{zh}->{861312318} = "福建省福州市";
$areanames{zh}->{861312319} = "福建省福州市";
$areanames{zh}->{861312320} = "福建省南平市";
$areanames{zh}->{861312321} = "福建省南平市";
$areanames{zh}->{861312322} = "福建省南平市";
$areanames{zh}->{861312323} = "福建省宁德市";
$areanames{zh}->{861312324} = "河南省郑州市";
$areanames{zh}->{861312325} = "福建省宁德市";
$areanames{zh}->{861312326} = "福建省宁德市";
$areanames{zh}->{861312327} = "福建省莆田市";
$areanames{zh}->{861312328} = "福建省莆田市";
$areanames{zh}->{861312329} = "福建省莆田市";
$areanames{zh}->{86131233} = "福建省漳州市";
$areanames{zh}->{861312336} = "福建省厦门市";
$areanames{zh}->{861312337} = "福建省厦门市";
$areanames{zh}->{861312338} = "福建省厦门市";
$areanames{zh}->{861312339} = "福建省厦门市";
$areanames{zh}->{861312340} = "广西防城港市";
$areanames{zh}->{861312341} = "广西南宁市";
$areanames{zh}->{861312342} = "广西柳州市";
$areanames{zh}->{861312343} = "广西桂林市";
$areanames{zh}->{861312344} = "广西贵港市";
$areanames{zh}->{861312345} = "广西玉林市";
$areanames{zh}->{861312346} = "广西百色市";
$areanames{zh}->{861312347} = "广西钦州市";
$areanames{zh}->{861312348} = "广西河池市";
$areanames{zh}->{861312349} = "广西北海市";
$areanames{zh}->{861312350} = "广西防城港市";
$areanames{zh}->{861312351} = "广西南宁市";
$areanames{zh}->{861312352} = "广西柳州市";
$areanames{zh}->{861312353} = "广西桂林市";
$areanames{zh}->{861312354} = "广西梧州市";
$areanames{zh}->{861312355} = "广西玉林市";
$areanames{zh}->{861312356} = "广西百色市";
$areanames{zh}->{861312357} = "广西贺州市";
$areanames{zh}->{861312358} = "广西河池市";
$areanames{zh}->{861312359} = "广西北海市";
$areanames{zh}->{861312360} = "贵州省贵阳市";
$areanames{zh}->{861312361} = "贵州省贵阳市";
$areanames{zh}->{861312362} = "贵州省遵义市";
$areanames{zh}->{861312363} = "贵州省安顺市";
$areanames{zh}->{861312364} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861312365} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861312366} = "贵州省铜仁地区";
$areanames{zh}->{861312367} = "贵州省毕节地区";
$areanames{zh}->{861312368} = "贵州省六盘水市";
$areanames{zh}->{861312369} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86131237} = "河南省驻马店市";
$areanames{zh}->{86131238} = "浙江省宁波市";
$areanames{zh}->{86131239} = "浙江省杭州市";
$areanames{zh}->{861312396} = "新疆喀什地区";
$areanames{zh}->{861312397} = "浙江省温州市";
$areanames{zh}->{861312398} = "浙江省温州市";
$areanames{zh}->{861312399} = "浙江省温州市";
$areanames{zh}->{861312400} = "福建省福州市";
$areanames{zh}->{861312401} = "福建省福州市";
$areanames{zh}->{861312402} = "福建省福州市";
$areanames{zh}->{861312403} = "河南省信阳市";
$areanames{zh}->{861312404} = "福建省龙岩市";
$areanames{zh}->{861312405} = "河南省焦作市";
$areanames{zh}->{861312406} = "福建省莆田市";
$areanames{zh}->{861312407} = "福建省厦门市";
$areanames{zh}->{861312408} = "福建省厦门市";
$areanames{zh}->{861312409} = "福建省厦门市";
$areanames{zh}->{861312410} = "辽宁省大连市";
$areanames{zh}->{861312411} = "辽宁省大连市";
$areanames{zh}->{861312412} = "辽宁省鞍山市";
$areanames{zh}->{861312413} = "辽宁省抚顺市";
$areanames{zh}->{861312414} = "辽宁省本溪市";
$areanames{zh}->{861312415} = "辽宁省丹东市";
$areanames{zh}->{861312416} = "辽宁省锦州市";
$areanames{zh}->{861312417} = "辽宁省营口市";
$areanames{zh}->{861312418} = "辽宁省阜新市";
$areanames{zh}->{861312419} = "辽宁省辽阳市";
$areanames{zh}->{86131242} = "辽宁省沈阳市";
$areanames{zh}->{861312427} = "辽宁省大连市";
$areanames{zh}->{861312428} = "辽宁省大连市";
$areanames{zh}->{861312429} = "辽宁省营口市";
$areanames{zh}->{861312430} = "吉林省吉林市";
$areanames{zh}->{861312431} = "吉林省吉林市";
$areanames{zh}->{861312432} = "吉林省吉林市";
$areanames{zh}->{861312433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861312434} = "吉林省吉林市";
$areanames{zh}->{861312435} = "吉林省通化市";
$areanames{zh}->{861312436} = "吉林省白城市";
$areanames{zh}->{861312437} = "吉林省辽源市";
$areanames{zh}->{861312438} = "吉林省松原市";
$areanames{zh}->{861312439} = "吉林省白山市";
$areanames{zh}->{861312440} = "河南省开封市";
$areanames{zh}->{861312441} = "河南省安阳市";
$areanames{zh}->{861312442} = "河南省安阳市";
$areanames{zh}->{861312443} = "河南省安阳市";
$areanames{zh}->{861312444} = "河南省濮阳市";
$areanames{zh}->{861312445} = "福建省厦门市";
$areanames{zh}->{861312446} = "福建省泉州市";
$areanames{zh}->{861312447} = "福建省泉州市";
$areanames{zh}->{861312448} = "福建省宁德市";
$areanames{zh}->{861312449} = "福建省宁德市";
$areanames{zh}->{861312450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861312453} = "黑龙江省牡丹江市";
$areanames{zh}->{861312454} = "黑龙江省佳木斯市";
$areanames{zh}->{861312455} = "黑龙江省绥化市";
$areanames{zh}->{861312456} = "黑龙江省黑河市";
$areanames{zh}->{861312457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861312458} = "黑龙江省伊春市";
$areanames{zh}->{861312459} = "黑龙江省大庆市";
$areanames{zh}->{861312460} = "贵州省贵阳市";
$areanames{zh}->{861312461} = "贵州省贵阳市";
$areanames{zh}->{861312462} = "贵州省遵义市";
$areanames{zh}->{861312463} = "贵州省安顺市";
$areanames{zh}->{861312464} = "贵州省遵义市";
$areanames{zh}->{861312465} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861312466} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861312467} = "贵州省贵阳市";
$areanames{zh}->{861312468} = "贵州省六盘水市";
$areanames{zh}->{861312469} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{86131247} = "北京市";
$areanames{zh}->{86131248} = "上海市";
$areanames{zh}->{86131249} = "广东省湛江市";
$areanames{zh}->{86131250} = "湖北省武汉市";
$areanames{zh}->{86131251} = "湖北省武汉市";
$areanames{zh}->{861312520} = "江西省九江市";
$areanames{zh}->{861312521} = "江西省南昌市";
$areanames{zh}->{861312522} = "江西省九江市";
$areanames{zh}->{861312523} = "江西省上饶市";
$areanames{zh}->{861312524} = "江西省抚州市";
$areanames{zh}->{861312525} = "江西省宜春市";
$areanames{zh}->{861312526} = "江西省吉安市";
$areanames{zh}->{861312527} = "江西省赣州市";
$areanames{zh}->{861312528} = "江西省景德镇市";
$areanames{zh}->{861312529} = "江西省萍乡市";
$areanames{zh}->{861312530} = "江西省上饶市";
$areanames{zh}->{861312531} = "江西省上饶市";
$areanames{zh}->{861312532} = "江西省抚州市";
$areanames{zh}->{861312533} = "江西省抚州市";
$areanames{zh}->{861312534} = "江西省吉安市";
$areanames{zh}->{861312535} = "江西省吉安市";
$areanames{zh}->{861312536} = "江西省赣州市";
$areanames{zh}->{861312537} = "江西省赣州市";
$areanames{zh}->{861312538} = "江西省赣州市";
$areanames{zh}->{861312539} = "江西省赣州市";
$areanames{zh}->{861312540} = "辽宁省沈阳市";
$areanames{zh}->{861312541} = "辽宁省沈阳市";
$areanames{zh}->{861312542} = "辽宁省沈阳市";
$areanames{zh}->{861312543} = "辽宁省沈阳市";
$areanames{zh}->{861312544} = "辽宁省沈阳市";
$areanames{zh}->{861312545} = "辽宁省大连市";
$areanames{zh}->{861312546} = "辽宁省大连市";
$areanames{zh}->{861312547} = "辽宁省大连市";
$areanames{zh}->{861312548} = "辽宁省大连市";
$areanames{zh}->{861312549} = "辽宁省大连市";
$areanames{zh}->{861312550} = "辽宁省鞍山市";
$areanames{zh}->{861312551} = "辽宁省抚顺市";
$areanames{zh}->{861312552} = "辽宁省抚顺市";
$areanames{zh}->{861312553} = "辽宁省本溪市";
$areanames{zh}->{861312554} = "辽宁省本溪市";
$areanames{zh}->{861312555} = "辽宁省本溪市";
$areanames{zh}->{861312556} = "辽宁省丹东市";
$areanames{zh}->{861312557} = "辽宁省丹东市";
$areanames{zh}->{861312558} = "辽宁省丹东市";
$areanames{zh}->{861312559} = "辽宁省丹东市";
$areanames{zh}->{861312560} = "辽宁省锦州市";
$areanames{zh}->{861312561} = "辽宁省营口市";
$areanames{zh}->{861312562} = "辽宁省营口市";
$areanames{zh}->{861312563} = "辽宁省营口市";
$areanames{zh}->{861312564} = "辽宁省营口市";
$areanames{zh}->{861312565} = "辽宁省阜新市";
$areanames{zh}->{861312566} = "辽宁省阜新市";
$areanames{zh}->{861312567} = "辽宁省辽阳市";
$areanames{zh}->{861312568} = "辽宁省辽阳市";
$areanames{zh}->{861312569} = "辽宁省辽阳市";
$areanames{zh}->{861312570} = "吉林省长春市";
$areanames{zh}->{861312571} = "吉林省吉林市";
$areanames{zh}->{861312572} = "吉林省吉林市";
$areanames{zh}->{861312573} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861312574} = "吉林省长春市";
$areanames{zh}->{861312575} = "吉林省通化市";
$areanames{zh}->{861312576} = "吉林省白城市";
$areanames{zh}->{861312577} = "吉林省辽源市";
$areanames{zh}->{861312578} = "吉林省松原市";
$areanames{zh}->{861312579} = "吉林省白山市";
$areanames{zh}->{861312580} = "吉林省长春市";
$areanames{zh}->{861312581} = "吉林省长春市";
$areanames{zh}->{861312582} = "吉林省长春市";
$areanames{zh}->{861312583} = "吉林省四平市";
$areanames{zh}->{861312584} = "吉林省吉林市";
$areanames{zh}->{861312585} = "吉林省通化市";
$areanames{zh}->{861312586} = "吉林省白城市";
$areanames{zh}->{861312587} = "吉林省辽源市";
$areanames{zh}->{861312588} = "吉林省吉林市";
$areanames{zh}->{861312589} = "吉林省通化市";
$areanames{zh}->{861312590} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312591} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312592} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312593} = "黑龙江省牡丹江市";
$areanames{zh}->{861312594} = "黑龙江省大庆市";
$areanames{zh}->{861312595} = "黑龙江省绥化市";
$areanames{zh}->{861312596} = "黑龙江省绥化市";
$areanames{zh}->{861312597} = "黑龙江省鸡西市";
$areanames{zh}->{861312598} = "黑龙江省哈尔滨市";
$areanames{zh}->{861312599} = "黑龙江省大庆市";
$areanames{zh}->{86131260} = "广东省茂名市";
$areanames{zh}->{86131261} = "河北省石家庄市";
$areanames{zh}->{861312617} = "广东省梅州市";
$areanames{zh}->{86131262} = "广东省江门市";
$areanames{zh}->{86131263} = "广东省惠州市";
$areanames{zh}->{86131264} = "广东省广州市";
$areanames{zh}->{86131265} = "北京市";
$areanames{zh}->{861312654} = "内蒙古通辽市";
$areanames{zh}->{86131266} = "北京市";
$areanames{zh}->{86131267} = "北京市";
$areanames{zh}->{861312674} = "内蒙古兴安盟";
$areanames{zh}->{86131268} = "北京市";
$areanames{zh}->{861312684} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86131269} = "北京市";
$areanames{zh}->{861312694} = "内蒙古鄂尔多斯市";
$areanames{zh}->{86131270} = "山东省青岛市";
$areanames{zh}->{861312707} = "山东省烟台市";
$areanames{zh}->{861312708} = "山东省烟台市";
$areanames{zh}->{861312709} = "山东省日照市";
$areanames{zh}->{86131271} = "山东省济南市";
$areanames{zh}->{861312716} = "山东省潍坊市";
$areanames{zh}->{861312717} = "山东省潍坊市";
$areanames{zh}->{861312718} = "山东省潍坊市";
$areanames{zh}->{861312719} = "山东省东营市";
$areanames{zh}->{861312720} = "山东省淄博市";
$areanames{zh}->{861312721} = "山东省枣庄市";
$areanames{zh}->{861312722} = "山东省枣庄市";
$areanames{zh}->{861312723} = "山东省枣庄市";
$areanames{zh}->{861312724} = "山东省东营市";
$areanames{zh}->{861312725} = "山东省东营市";
$areanames{zh}->{861312726} = "山东省莱芜市";
$areanames{zh}->{861312727} = "山东省泰安市";
$areanames{zh}->{861312728} = "山东省泰安市";
$areanames{zh}->{861312729} = "山东省临沂市";
$areanames{zh}->{86131273} = "河北省沧州市";
$areanames{zh}->{86131274} = "河北省保定市";
$areanames{zh}->{86131275} = "上海市";
$areanames{zh}->{86131276} = "上海市";
$areanames{zh}->{86131277} = "上海市";
$areanames{zh}->{86131278} = "上海市";
$areanames{zh}->{86131279} = "上海市";
$areanames{zh}->{86131280} = "广东省东莞市";
$areanames{zh}->{86131281} = "广东省东莞市";
$areanames{zh}->{86131282} = "广东省广州市";
$areanames{zh}->{86131283} = "广东省揭阳市";
$areanames{zh}->{86131284} = "广东省汕头市";
$areanames{zh}->{861312840} = "广东省潮州市";
$areanames{zh}->{861312841} = "广东省潮州市";
$areanames{zh}->{861312842} = "广东省潮州市";
$areanames{zh}->{86131285} = "广东省珠海市";
$areanames{zh}->{86131286} = "广东省广州市";
$areanames{zh}->{86131287} = "广东省深圳市";
$areanames{zh}->{86131288} = "广东省深圳市";
$areanames{zh}->{86131289} = "广东省深圳市";
$areanames{zh}->{86131290} = "广东省佛山市";
$areanames{zh}->{86131291} = "广东省佛山市";
$areanames{zh}->{86131292} = "广东省中山市";
$areanames{zh}->{86131293} = "广东省广州市";
$areanames{zh}->{86131294} = "广东省东莞市";
$areanames{zh}->{86131295} = "广东省深圳市";
$areanames{zh}->{86131296} = "广东省汕头市";
$areanames{zh}->{86131297} = "广东省肇庆市";
$areanames{zh}->{86131298} = "广东省东莞市";
$areanames{zh}->{86131299} = "湖北省武汉市";
$areanames{zh}->{861313000} = "辽宁省大连市";
$areanames{zh}->{861313001} = "辽宁省大连市";
$areanames{zh}->{861313002} = "辽宁省大连市";
$areanames{zh}->{861313003} = "辽宁省大连市";
$areanames{zh}->{861313004} = "辽宁省大连市";
$areanames{zh}->{861313005} = "辽宁省鞍山市";
$areanames{zh}->{861313006} = "辽宁省鞍山市";
$areanames{zh}->{861313007} = "辽宁省鞍山市";
$areanames{zh}->{861313008} = "辽宁省鞍山市";
$areanames{zh}->{861313009} = "辽宁省鞍山市";
$areanames{zh}->{861313010} = "辽宁省本溪市";
$areanames{zh}->{861313011} = "辽宁省本溪市";
$areanames{zh}->{861313012} = "辽宁省本溪市";
$areanames{zh}->{861313013} = "辽宁省本溪市";
$areanames{zh}->{861313014} = "辽宁省本溪市";
$areanames{zh}->{861313015} = "辽宁省鞍山市";
$areanames{zh}->{861313016} = "辽宁省鞍山市";
$areanames{zh}->{861313017} = "辽宁省鞍山市";
$areanames{zh}->{861313018} = "辽宁省鞍山市";
$areanames{zh}->{861313019} = "辽宁省鞍山市";
$areanames{zh}->{86131302} = "辽宁省沈阳市";
$areanames{zh}->{86131303} = "辽宁省抚顺市";
$areanames{zh}->{861313038} = "辽宁省本溪市";
$areanames{zh}->{861313039} = "辽宁省本溪市";
$areanames{zh}->{86131304} = "辽宁省大连市";
$areanames{zh}->{861313050} = "辽宁省丹东市";
$areanames{zh}->{861313051} = "辽宁省丹东市";
$areanames{zh}->{861313052} = "辽宁省丹东市";
$areanames{zh}->{861313053} = "辽宁省丹东市";
$areanames{zh}->{861313054} = "辽宁省丹东市";
$areanames{zh}->{861313055} = "辽宁省营口市";
$areanames{zh}->{861313056} = "辽宁省营口市";
$areanames{zh}->{861313057} = "辽宁省营口市";
$areanames{zh}->{861313058} = "辽宁省营口市";
$areanames{zh}->{861313059} = "辽宁省营口市";
$areanames{zh}->{86131306} = "辽宁省锦州市";
$areanames{zh}->{861313067} = "辽宁省阜新市";
$areanames{zh}->{861313068} = "辽宁省阜新市";
$areanames{zh}->{861313069} = "辽宁省阜新市";
$areanames{zh}->{86131307} = "辽宁省辽阳市";
$areanames{zh}->{861313077} = "辽宁省铁岭市";
$areanames{zh}->{861313078} = "辽宁省铁岭市";
$areanames{zh}->{861313079} = "辽宁省铁岭市";
$areanames{zh}->{86131308} = "辽宁省朝阳市";
$areanames{zh}->{861313087} = "辽宁省阜新市";
$areanames{zh}->{861313088} = "辽宁省盘锦市";
$areanames{zh}->{861313089} = "辽宁省铁岭市";
$areanames{zh}->{861313090} = "辽宁省盘锦市";
$areanames{zh}->{861313091} = "辽宁省盘锦市";
$areanames{zh}->{861313092} = "辽宁省盘锦市";
$areanames{zh}->{861313093} = "辽宁省盘锦市";
$areanames{zh}->{861313094} = "辽宁省盘锦市";
$areanames{zh}->{861313095} = "辽宁省葫芦岛市";
$areanames{zh}->{861313096} = "辽宁省葫芦岛市";
$areanames{zh}->{861313097} = "辽宁省葫芦岛市";
$areanames{zh}->{861313098} = "辽宁省葫芦岛市";
$areanames{zh}->{861313099} = "辽宁省葫芦岛市";
$areanames{zh}->{86131310} = "河北省邯郸市";
$areanames{zh}->{86131311} = "河北省石家庄市";
$areanames{zh}->{86131312} = "河北省保定市";
$areanames{zh}->{86131313} = "河北省张家口市";
$areanames{zh}->{86131314} = "河北省承德市";
$areanames{zh}->{86131315} = "河北省唐山市";
$areanames{zh}->{86131316} = "河北省廊坊市";
$areanames{zh}->{86131317} = "河北省沧州市";
$areanames{zh}->{86131318} = "河北省衡水市";
$areanames{zh}->{86131319} = "河北省邢台市";
$areanames{zh}->{86131320} = "天津市";
$areanames{zh}->{86131321} = "天津市";
$areanames{zh}->{86131322} = "天津市";
$areanames{zh}->{86131323} = "重庆市";
$areanames{zh}->{861313240} = "河北省衡水市";
$areanames{zh}->{861313241} = "河北省衡水市";
$areanames{zh}->{861313242} = "河北省衡水市";
$areanames{zh}->{861313243} = "河北省衡水市";
$areanames{zh}->{861313244} = "河北省衡水市";
$areanames{zh}->{861313245} = "河北省邢台市";
$areanames{zh}->{861313246} = "河北省邢台市";
$areanames{zh}->{861313247} = "河北省邢台市";
$areanames{zh}->{861313248} = "河北省邢台市";
$areanames{zh}->{861313249} = "河北省邢台市";
$areanames{zh}->{86131325} = "天津市";
$areanames{zh}->{861313260} = "广西南宁市";
$areanames{zh}->{861313261} = "广西南宁市";
$areanames{zh}->{861313262} = "广西柳州市";
$areanames{zh}->{861313263} = "广西桂林市";
$areanames{zh}->{861313264} = "广西桂林市";
$areanames{zh}->{861313265} = "广西玉林市";
$areanames{zh}->{861313266} = "广西贵港市";
$areanames{zh}->{861313267} = "广西钦州市";
$areanames{zh}->{861313268} = "广西河池市";
$areanames{zh}->{861313269} = "广西北海市";
$areanames{zh}->{861313270} = "广西河池市";
$areanames{zh}->{861313271} = "广西南宁市";
$areanames{zh}->{861313272} = "广西柳州市";
$areanames{zh}->{861313273} = "广西桂林市";
$areanames{zh}->{861313274} = "广西梧州市";
$areanames{zh}->{861313275} = "广西玉林市";
$areanames{zh}->{861313276} = "广西百色市";
$areanames{zh}->{861313277} = "广西钦州市";
$areanames{zh}->{861313278} = "广西河池市";
$areanames{zh}->{861313279} = "广西北海市";
$areanames{zh}->{861313280} = "广西河池市";
$areanames{zh}->{861313281} = "广西南宁市";
$areanames{zh}->{861313282} = "广西柳州市";
$areanames{zh}->{861313283} = "广西桂林市";
$areanames{zh}->{861313284} = "广西贵港市";
$areanames{zh}->{861313285} = "广西玉林市";
$areanames{zh}->{861313286} = "广西百色市";
$areanames{zh}->{861313287} = "广西贺州市";
$areanames{zh}->{861313288} = "广西贵港市";
$areanames{zh}->{861313289} = "广西贵港市";
$areanames{zh}->{861313290} = "广西南宁市";
$areanames{zh}->{861313291} = "广西南宁市";
$areanames{zh}->{861313292} = "广西柳州市";
$areanames{zh}->{861313293} = "广西桂林市";
$areanames{zh}->{861313294} = "广西贺州市";
$areanames{zh}->{861313295} = "广西玉林市";
$areanames{zh}->{861313296} = "广西百色市";
$areanames{zh}->{861313297} = "广西桂林市";
$areanames{zh}->{861313298} = "广西河池市";
$areanames{zh}->{861313299} = "广西贵港市";
$areanames{zh}->{861313300} = "山西省太原市";
$areanames{zh}->{861313301} = "山西省太原市";
$areanames{zh}->{861313302} = "山西省太原市";
$areanames{zh}->{861313303} = "山西省朔州市";
$areanames{zh}->{861313304} = "山西省晋中市";
$areanames{zh}->{861313305} = "山西省长治市";
$areanames{zh}->{861313306} = "山西省晋城市";
$areanames{zh}->{861313307} = "山西省临汾市";
$areanames{zh}->{861313308} = "山西省吕梁市";
$areanames{zh}->{861313309} = "山西省运城市";
$areanames{zh}->{861313310} = "山西省忻州市";
$areanames{zh}->{861313311} = "山西省朔州市";
$areanames{zh}->{861313312} = "山西省大同市";
$areanames{zh}->{861313313} = "山西省阳泉市";
$areanames{zh}->{861313314} = "山西省运城市";
$areanames{zh}->{861313315} = "山西省长治市";
$areanames{zh}->{861313316} = "山西省晋城市";
$areanames{zh}->{861313317} = "山西省临汾市";
$areanames{zh}->{861313318} = "山西省临汾市";
$areanames{zh}->{861313319} = "山西省运城市";
$areanames{zh}->{861313320} = "山西省忻州市";
$areanames{zh}->{861313321} = "山西省晋中市";
$areanames{zh}->{861313322} = "山西省大同市";
$areanames{zh}->{861313323} = "山西省阳泉市";
$areanames{zh}->{861313324} = "山西省吕梁市";
$areanames{zh}->{861313325} = "山西省长治市";
$areanames{zh}->{861313326} = "山西省临汾市";
$areanames{zh}->{861313327} = "山西省临汾市";
$areanames{zh}->{861313328} = "山西省大同市";
$areanames{zh}->{861313329} = "山西省运城市";
$areanames{zh}->{861313330} = "山西省晋中市";
$areanames{zh}->{861313331} = "山西省晋中市";
$areanames{zh}->{861313332} = "山西省大同市";
$areanames{zh}->{861313333} = "山西省大同市";
$areanames{zh}->{861313334} = "山西省忻州市";
$areanames{zh}->{861313335} = "山西省长治市";
$areanames{zh}->{861313336} = "山西省晋城市";
$areanames{zh}->{861313337} = "山西省晋城市";
$areanames{zh}->{861313338} = "山西省吕梁市";
$areanames{zh}->{861313339} = "山西省运城市";
$areanames{zh}->{861313340} = "山西省忻州市";
$areanames{zh}->{861313341} = "山西省运城市";
$areanames{zh}->{861313342} = "山西省大同市";
$areanames{zh}->{861313343} = "山西省阳泉市";
$areanames{zh}->{861313344} = "山西省晋中市";
$areanames{zh}->{861313345} = "山西省长治市";
$areanames{zh}->{861313346} = "山西省晋城市";
$areanames{zh}->{861313347} = "山西省临汾市";
$areanames{zh}->{861313348} = "山西省吕梁市";
$areanames{zh}->{861313349} = "山西省朔州市";
$areanames{zh}->{86131335} = "河北省秦皇岛市";
$areanames{zh}->{861313360} = "江西省上饶市";
$areanames{zh}->{861313361} = "江西省上饶市";
$areanames{zh}->{861313362} = "江西省鹰潭市";
$areanames{zh}->{861313363} = "江西省九江市";
$areanames{zh}->{861313364} = "江西省九江市";
$areanames{zh}->{861313365} = "江西省九江市";
$areanames{zh}->{861313366} = "江西省九江市";
$areanames{zh}->{861313367} = "江西省吉安市";
$areanames{zh}->{861313368} = "江西省吉安市";
$areanames{zh}->{861313369} = "江西省吉安市";
$areanames{zh}->{861313370} = "江西省抚州市";
$areanames{zh}->{861313371} = "江西省抚州市";
$areanames{zh}->{861313372} = "江西省抚州市";
$areanames{zh}->{861313373} = "江西省抚州市";
$areanames{zh}->{861313374} = "江西省赣州市";
$areanames{zh}->{861313375} = "江西省赣州市";
$areanames{zh}->{861313376} = "江西省赣州市";
$areanames{zh}->{861313377} = "江西省赣州市";
$areanames{zh}->{861313378} = "江西省宜春市";
$areanames{zh}->{861313379} = "江西省宜春市";
$areanames{zh}->{861313380} = "江西省南昌市";
$areanames{zh}->{861313381} = "江西省南昌市";
$areanames{zh}->{861313382} = "江西省南昌市";
$areanames{zh}->{861313383} = "江西省南昌市";
$areanames{zh}->{861313384} = "江西省南昌市";
$areanames{zh}->{861313385} = "江西省宜春市";
$areanames{zh}->{861313386} = "江西省萍乡市";
$areanames{zh}->{861313387} = "江西省萍乡市";
$areanames{zh}->{861313388} = "江西省景德镇市";
$areanames{zh}->{861313389} = "江西省景德镇市";
$areanames{zh}->{861313390} = "江西省新余市";
$areanames{zh}->{861313391} = "江西省南昌市";
$areanames{zh}->{861313392} = "江西省九江市";
$areanames{zh}->{861313393} = "江西省上饶市";
$areanames{zh}->{861313394} = "江西省抚州市";
$areanames{zh}->{861313395} = "江西省宜春市";
$areanames{zh}->{861313396} = "江西省吉安市";
$areanames{zh}->{861313397} = "江西省赣州市";
$areanames{zh}->{861313398} = "江西省景德镇市";
$areanames{zh}->{861313399} = "江西省萍乡市";
$areanames{zh}->{861313400} = "江西省宜春市";
$areanames{zh}->{861313401} = "江西省九江市";
$areanames{zh}->{861313402} = "江西省赣州市";
$areanames{zh}->{861313403} = "江西省抚州市";
$areanames{zh}->{861313404} = "江西省景德镇市";
$areanames{zh}->{861313405} = "江西省景德镇市";
$areanames{zh}->{861313406} = "江西省吉安市";
$areanames{zh}->{861313407} = "江西省吉安市";
$areanames{zh}->{861313408} = "江西省萍乡市";
$areanames{zh}->{861313409} = "江西省萍乡市";
$areanames{zh}->{861313410} = "辽宁省铁岭市";
$areanames{zh}->{861313411} = "辽宁省大连市";
$areanames{zh}->{861313412} = "辽宁省鞍山市";
$areanames{zh}->{861313413} = "辽宁省抚顺市";
$areanames{zh}->{861313414} = "辽宁省本溪市";
$areanames{zh}->{861313415} = "辽宁省丹东市";
$areanames{zh}->{861313416} = "辽宁省锦州市";
$areanames{zh}->{861313417} = "辽宁省营口市";
$areanames{zh}->{861313418} = "辽宁省阜新市";
$areanames{zh}->{861313419} = "辽宁省辽阳市";
$areanames{zh}->{861313420} = "辽宁省沈阳市";
$areanames{zh}->{861313421} = "辽宁省朝阳市";
$areanames{zh}->{861313422} = "辽宁省沈阳市";
$areanames{zh}->{861313423} = "辽宁省沈阳市";
$areanames{zh}->{861313424} = "辽宁省沈阳市";
$areanames{zh}->{861313425} = "辽宁省鞍山市";
$areanames{zh}->{861313426} = "辽宁省大连市";
$areanames{zh}->{861313427} = "辽宁省盘锦市";
$areanames{zh}->{861313428} = "辽宁省大连市";
$areanames{zh}->{861313429} = "辽宁省葫芦岛市";
$areanames{zh}->{861313430} = "吉林省长春市";
$areanames{zh}->{861313431} = "吉林省长春市";
$areanames{zh}->{861313432} = "吉林省吉林市";
$areanames{zh}->{861313433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861313434} = "吉林省四平市";
$areanames{zh}->{861313435} = "吉林省通化市";
$areanames{zh}->{861313436} = "吉林省白城市";
$areanames{zh}->{861313437} = "吉林省辽源市";
$areanames{zh}->{861313438} = "吉林省松原市";
$areanames{zh}->{861313439} = "吉林省白山市";
$areanames{zh}->{86131344} = "吉林省长春市";
$areanames{zh}->{861313440} = "吉林省吉林市";
$areanames{zh}->{861313441} = "吉林省吉林市";
$areanames{zh}->{861313442} = "吉林省吉林市";
$areanames{zh}->{861313444} = "吉林省吉林市";
$areanames{zh}->{861313450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313453} = "黑龙江省牡丹江市";
$areanames{zh}->{861313454} = "黑龙江省佳木斯市";
$areanames{zh}->{861313455} = "黑龙江省绥化市";
$areanames{zh}->{861313456} = "黑龙江省黑河市";
$areanames{zh}->{861313457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861313458} = "黑龙江省伊春市";
$areanames{zh}->{861313459} = "黑龙江省大庆市";
$areanames{zh}->{861313460} = "山西省忻州市";
$areanames{zh}->{861313461} = "山西省朔州市";
$areanames{zh}->{861313462} = "山西省大同市";
$areanames{zh}->{861313463} = "山西省阳泉市";
$areanames{zh}->{861313464} = "山西省吕梁市";
$areanames{zh}->{861313465} = "山西省长治市";
$areanames{zh}->{861313466} = "山西省晋城市";
$areanames{zh}->{861313467} = "山西省临汾市";
$areanames{zh}->{861313468} = "山西省晋中市";
$areanames{zh}->{861313469} = "山西省运城市";
$areanames{zh}->{861313470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861313471} = "内蒙古呼和浩特市";
$areanames{zh}->{861313472} = "内蒙古包头市";
$areanames{zh}->{861313473} = "内蒙古乌海市";
$areanames{zh}->{861313474} = "内蒙古兴安盟";
$areanames{zh}->{861313475} = "内蒙古通辽市";
$areanames{zh}->{861313476} = "内蒙古赤峰市";
$areanames{zh}->{861313477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861313479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861313480} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861313481} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861313482} = "内蒙古兴安盟";
$areanames{zh}->{861313483} = "内蒙古阿拉善盟";
$areanames{zh}->{861313484} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313485} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313486} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313487} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313488} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861313489} = "内蒙古包头市";
$areanames{zh}->{86131349} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861313498} = "内蒙古乌海市";
$areanames{zh}->{861313499} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861313500} = "湖南省岳阳市";
$areanames{zh}->{861313501} = "湖南省长沙市";
$areanames{zh}->{861313502} = "湖南省湘潭市";
$areanames{zh}->{861313503} = "湖南省株洲市";
$areanames{zh}->{861313504} = "湖南省衡阳市";
$areanames{zh}->{861313505} = "湖南省郴州市";
$areanames{zh}->{861313506} = "湖南省常德市";
$areanames{zh}->{861313507} = "湖南省益阳市";
$areanames{zh}->{861313508} = "湖南省邵阳市";
$areanames{zh}->{861313509} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861313510} = "湖南省岳阳市";
$areanames{zh}->{861313511} = "湖南省长沙市";
$areanames{zh}->{861313512} = "湖南省湘潭市";
$areanames{zh}->{861313513} = "湖南省株洲市";
$areanames{zh}->{861313514} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861313515} = "湖南省郴州市";
$areanames{zh}->{861313516} = "湖南省益阳市";
$areanames{zh}->{861313517} = "湖南省益阳市";
$areanames{zh}->{861313518} = "湖南省衡阳市";
$areanames{zh}->{861313519} = "湖南省邵阳市";
$areanames{zh}->{861313520} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861313521} = "湖南省长沙市";
$areanames{zh}->{861313522} = "湖南省永州市";
$areanames{zh}->{861313523} = "湖南省张家界市";
$areanames{zh}->{861313524} = "湖南省娄底市";
$areanames{zh}->{861313525} = "湖南省怀化市";
$areanames{zh}->{861313526} = "湖南省怀化市";
$areanames{zh}->{861313527} = "湖南省永州市";
$areanames{zh}->{861313528} = "湖南省长沙市";
$areanames{zh}->{861313529} = "湖南省邵阳市";
$areanames{zh}->{861313530} = "湖南省岳阳市";
$areanames{zh}->{861313531} = "湖南省长沙市";
$areanames{zh}->{861313532} = "湖南省湘潭市";
$areanames{zh}->{861313533} = "湖南省株洲市";
$areanames{zh}->{861313534} = "湖南省衡阳市";
$areanames{zh}->{861313535} = "湖南省郴州市";
$areanames{zh}->{861313536} = "湖南省常德市";
$areanames{zh}->{861313537} = "湖南省益阳市";
$areanames{zh}->{861313538} = "湖南省娄底市";
$areanames{zh}->{861313539} = "湖南省邵阳市";
$areanames{zh}->{861313540} = "安徽省合肥市";
$areanames{zh}->{861313541} = "安徽省阜阳市";
$areanames{zh}->{861313542} = "安徽省六安市";
$areanames{zh}->{861313543} = "安徽省宣城市";
$areanames{zh}->{861313544} = "安徽省马鞍山市";
$areanames{zh}->{861313545} = "安徽省滁州市";
$areanames{zh}->{861313546} = "安徽省淮北市";
$areanames{zh}->{861313547} = "安徽省亳州市";
$areanames{zh}->{861313548} = "安徽省铜陵市";
$areanames{zh}->{861313549} = "安徽省池州市";
$areanames{zh}->{861313550} = "安徽省滁州市";
$areanames{zh}->{861313551} = "安徽省合肥市";
$areanames{zh}->{861313552} = "安徽省蚌埠市";
$areanames{zh}->{861313553} = "安徽省芜湖市";
$areanames{zh}->{861313554} = "安徽省淮南市";
$areanames{zh}->{861313555} = "安徽省合肥市";
$areanames{zh}->{861313556} = "安徽省安庆市";
$areanames{zh}->{861313557} = "安徽省宿州市";
$areanames{zh}->{861313558} = "安徽省阜阳市";
$areanames{zh}->{861313559} = "安徽省黄山市";
$areanames{zh}->{861313560} = "湖北省孝感市";
$areanames{zh}->{861313561} = "湖北省孝感市";
$areanames{zh}->{861313562} = "湖北省孝感市";
$areanames{zh}->{861313563} = "湖北省孝感市";
$areanames{zh}->{861313564} = "湖北省孝感市";
$areanames{zh}->{861313565} = "湖北省武汉市";
$areanames{zh}->{861313566} = "湖北省武汉市";
$areanames{zh}->{861313567} = "湖北省武汉市";
$areanames{zh}->{861313568} = "湖北省武汉市";
$areanames{zh}->{861313569} = "湖北省武汉市";
$areanames{zh}->{861313570} = "湖北省十堰市";
$areanames{zh}->{861313571} = "湖北省十堰市";
$areanames{zh}->{861313572} = "湖北省十堰市";
$areanames{zh}->{861313573} = "湖北省随州市";
$areanames{zh}->{861313574} = "湖北省随州市";
$areanames{zh}->{861313575} = "湖北省荆州市";
$areanames{zh}->{861313576} = "湖北省荆州市";
$areanames{zh}->{861313577} = "湖北省荆州市";
$areanames{zh}->{861313578} = "湖北省荆州市";
$areanames{zh}->{861313579} = "湖北省荆州市";
$areanames{zh}->{861313580} = "湖北省宜昌市";
$areanames{zh}->{861313581} = "湖北省宜昌市";
$areanames{zh}->{861313582} = "湖北省宜昌市";
$areanames{zh}->{861313583} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861313584} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861313585} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861313586} = "湖北省襄樊市";
$areanames{zh}->{861313587} = "湖北省襄樊市";
$areanames{zh}->{861313588} = "湖北省襄樊市";
$areanames{zh}->{861313589} = "湖北省鄂州市";
$areanames{zh}->{861313590} = "湖北省黄冈市";
$areanames{zh}->{861313591} = "湖北省黄冈市";
$areanames{zh}->{861313592} = "湖北省黄石市";
$areanames{zh}->{861313593} = "湖北省黄石市";
$areanames{zh}->{861313594} = "湖北省咸宁市";
$areanames{zh}->{861313595} = "湖北省咸宁市";
$areanames{zh}->{861313596} = "湖北省咸宁市";
$areanames{zh}->{861313597} = "湖北省荆门市";
$areanames{zh}->{861313598} = "湖北省荆门市";
$areanames{zh}->{861313599} = "湖北省武汉市";
$areanames{zh}->{86131360} = "海南省海口市";
$areanames{zh}->{86131361} = "浙江省杭州市";
$areanames{zh}->{861313620} = "浙江省嘉兴市";
$areanames{zh}->{861313621} = "浙江省嘉兴市";
$areanames{zh}->{861313622} = "浙江省嘉兴市";
$areanames{zh}->{861313623} = "浙江省嘉兴市";
$areanames{zh}->{861313624} = "浙江省嘉兴市";
$areanames{zh}->{861313625} = "浙江省舟山市";
$areanames{zh}->{861313626} = "浙江省舟山市";
$areanames{zh}->{861313627} = "浙江省舟山市";
$areanames{zh}->{861313628} = "浙江省舟山市";
$areanames{zh}->{861313629} = "浙江省舟山市";
$areanames{zh}->{86131363} = "浙江省宁波市";
$areanames{zh}->{861313640} = "浙江省舟山市";
$areanames{zh}->{861313641} = "浙江省舟山市";
$areanames{zh}->{861313642} = "浙江省舟山市";
$areanames{zh}->{861313643} = "浙江省舟山市";
$areanames{zh}->{861313644} = "浙江省舟山市";
$areanames{zh}->{861313645} = "浙江省台州市";
$areanames{zh}->{861313646} = "浙江省台州市";
$areanames{zh}->{861313647} = "浙江省台州市";
$areanames{zh}->{861313648} = "浙江省台州市";
$areanames{zh}->{861313649} = "浙江省台州市";
$areanames{zh}->{861313650} = "浙江省湖州市";
$areanames{zh}->{861313651} = "浙江省湖州市";
$areanames{zh}->{861313652} = "浙江省湖州市";
$areanames{zh}->{861313653} = "浙江省湖州市";
$areanames{zh}->{861313654} = "浙江省湖州市";
$areanames{zh}->{861313655} = "浙江省台州市";
$areanames{zh}->{861313656} = "浙江省台州市";
$areanames{zh}->{861313657} = "浙江省台州市";
$areanames{zh}->{861313658} = "浙江省台州市";
$areanames{zh}->{861313659} = "浙江省台州市";
$areanames{zh}->{86131366} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313660} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313661} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313662} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313663} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313670} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861313671} = "黑龙江省伊春市";
$areanames{zh}->{861313672} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313673} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861313674} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313675} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313676} = "黑龙江省哈尔滨市";
$areanames{zh}->{861313677} = "黑龙江省双鸭山市";
$areanames{zh}->{861313678} = "黑龙江省双鸭山市";
$areanames{zh}->{861313679} = "黑龙江省七台河市";
$areanames{zh}->{86131368} = "黑龙江省大庆市";
$areanames{zh}->{861313686} = "黑龙江省牡丹江市";
$areanames{zh}->{861313687} = "黑龙江省牡丹江市";
$areanames{zh}->{861313688} = "黑龙江省牡丹江市";
$areanames{zh}->{861313689} = "黑龙江省牡丹江市";
$areanames{zh}->{861313690} = "黑龙江省鹤岗市";
$areanames{zh}->{861313691} = "黑龙江省绥化市";
$areanames{zh}->{861313692} = "黑龙江省绥化市";
$areanames{zh}->{861313693} = "黑龙江省黑河市";
$areanames{zh}->{861313694} = "黑龙江省鸡西市";
$areanames{zh}->{861313695} = "黑龙江省鸡西市";
$areanames{zh}->{861313696} = "黑龙江省鸡西市";
$areanames{zh}->{861313697} = "黑龙江省佳木斯市";
$areanames{zh}->{861313698} = "黑龙江省佳木斯市";
$areanames{zh}->{861313699} = "黑龙江省佳木斯市";
$areanames{zh}->{861313700} = "河南省商丘市";
$areanames{zh}->{861313701} = "河南省商丘市";
$areanames{zh}->{861313702} = "河南省商丘市";
$areanames{zh}->{861313703} = "河南省商丘市";
$areanames{zh}->{861313704} = "河南省洛阳市";
$areanames{zh}->{861313705} = "河南省洛阳市";
$areanames{zh}->{861313706} = "河南省洛阳市";
$areanames{zh}->{861313707} = "河南省南阳市";
$areanames{zh}->{861313708} = "河南省南阳市";
$areanames{zh}->{861313709} = "河南省南阳市";
$areanames{zh}->{86131371} = "河南省郑州市";
$areanames{zh}->{861313716} = "河南省焦作市";
$areanames{zh}->{861313717} = "河南省焦作市";
$areanames{zh}->{861313718} = "河南省焦作市";
$areanames{zh}->{861313719} = "河南省安阳市";
$areanames{zh}->{86131372} = "河南省驻马店市";
$areanames{zh}->{861313720} = "河南省安阳市";
$areanames{zh}->{861313721} = "河南省安阳市";
$areanames{zh}->{861313722} = "河南省鹤壁市";
$areanames{zh}->{861313723} = "河南省鹤壁市";
$areanames{zh}->{861313730} = "河南省新乡市";
$areanames{zh}->{861313731} = "河南省新乡市";
$areanames{zh}->{861313732} = "河南省新乡市";
$areanames{zh}->{861313733} = "河南省濮阳市";
$areanames{zh}->{861313734} = "河南省濮阳市";
$areanames{zh}->{861313735} = "河南省濮阳市";
$areanames{zh}->{861313736} = "河南省信阳市";
$areanames{zh}->{861313737} = "河南省信阳市";
$areanames{zh}->{861313738} = "河南省信阳市";
$areanames{zh}->{861313739} = "河南省信阳市";
$areanames{zh}->{861313740} = "河南省许昌市";
$areanames{zh}->{861313741} = "河南省许昌市";
$areanames{zh}->{861313742} = "河南省许昌市";
$areanames{zh}->{861313743} = "河南省许昌市";
$areanames{zh}->{861313744} = "河南省周口市";
$areanames{zh}->{861313745} = "河南省周口市";
$areanames{zh}->{861313746} = "河南省周口市";
$areanames{zh}->{861313747} = "河南省周口市";
$areanames{zh}->{861313748} = "河南省三门峡市";
$areanames{zh}->{861313749} = "河南省三门峡市";
$areanames{zh}->{861313750} = "河南省平顶山市";
$areanames{zh}->{861313751} = "河南省平顶山市";
$areanames{zh}->{861313752} = "河南省平顶山市";
$areanames{zh}->{861313753} = "河南省平顶山市";
$areanames{zh}->{861313754} = "河南省漯河市";
$areanames{zh}->{861313755} = "河南省漯河市";
$areanames{zh}->{861313756} = "河南省开封市";
$areanames{zh}->{861313757} = "河南省开封市";
$areanames{zh}->{861313758} = "河南省开封市";
$areanames{zh}->{861313759} = "河南省开封市";
$areanames{zh}->{861313760} = "河南省信阳市";
$areanames{zh}->{861313761} = "河南省信阳市";
$areanames{zh}->{861313762} = "河南省信阳市";
$areanames{zh}->{861313763} = "河南省信阳市";
$areanames{zh}->{861313764} = "河南省信阳市";
$areanames{zh}->{861313765} = "河南省周口市";
$areanames{zh}->{861313766} = "河南省周口市";
$areanames{zh}->{861313767} = "河南省周口市";
$areanames{zh}->{861313768} = "河南省周口市";
$areanames{zh}->{861313769} = "河南省周口市";
$areanames{zh}->{861313770} = "河南省郑州市";
$areanames{zh}->{861313771} = "河南省郑州市";
$areanames{zh}->{861313772} = "河南省郑州市";
$areanames{zh}->{861313773} = "河南省郑州市";
$areanames{zh}->{861313774} = "河南省平顶山市";
$areanames{zh}->{861313775} = "河南省平顶山市";
$areanames{zh}->{861313776} = "河南省平顶山市";
$areanames{zh}->{861313777} = "河南省南阳市";
$areanames{zh}->{861313778} = "河南省南阳市";
$areanames{zh}->{861313779} = "河南省南阳市";
$areanames{zh}->{861313780} = "河南省开封市";
$areanames{zh}->{861313781} = "河南省开封市";
$areanames{zh}->{861313782} = "河南省开封市";
$areanames{zh}->{861313783} = "河南省开封市";
$areanames{zh}->{861313784} = "河南省开封市";
$areanames{zh}->{861313785} = "河南省驻马店市";
$areanames{zh}->{861313786} = "河南省驻马店市";
$areanames{zh}->{861313787} = "河南省驻马店市";
$areanames{zh}->{861313788} = "河南省许昌市";
$areanames{zh}->{861313789} = "河南省许昌市";
$areanames{zh}->{861313790} = "河南省洛阳市";
$areanames{zh}->{861313791} = "河南省焦作市";
$areanames{zh}->{861313792} = "河南省焦作市";
$areanames{zh}->{861313793} = "河南省焦作市";
$areanames{zh}->{861313794} = "河南省郑州市";
$areanames{zh}->{861313795} = "河南省漯河市";
$areanames{zh}->{861313796} = "河南省漯河市";
$areanames{zh}->{861313797} = "河南省三门峡市";
$areanames{zh}->{861313798} = "河南省三门峡市";
$areanames{zh}->{861313799} = "河南省洛阳市";
$areanames{zh}->{86131380} = "广东省梅州市";
$areanames{zh}->{861313808} = "河北省石家庄市";
$areanames{zh}->{861313810} = "广东省珠海市";
$areanames{zh}->{861313811} = "广东省珠海市";
$areanames{zh}->{861313812} = "广东省珠海市";
$areanames{zh}->{861313813} = "广东省珠海市";
$areanames{zh}->{861313814} = "广东省珠海市";
$areanames{zh}->{861313815} = "广东省深圳市";
$areanames{zh}->{861313816} = "广东省深圳市";
$areanames{zh}->{861313817} = "广东省深圳市";
$areanames{zh}->{861313818} = "广东省深圳市";
$areanames{zh}->{861313819} = "河北省石家庄市";
$areanames{zh}->{86131382} = "广东省佛山市";
$areanames{zh}->{86131383} = "广东省惠州市";
$areanames{zh}->{861313840} = "广东省汕头市";
$areanames{zh}->{861313841} = "广东省汕头市";
$areanames{zh}->{861313842} = "广东省汕头市";
$areanames{zh}->{861313843} = "广东省汕头市";
$areanames{zh}->{861313844} = "广东省汕头市";
$areanames{zh}->{861313845} = "广东省广州市";
$areanames{zh}->{861313846} = "广东省广州市";
$areanames{zh}->{861313847} = "广东省广州市";
$areanames{zh}->{861313848} = "广东省广州市";
$areanames{zh}->{861313849} = "广东省广州市";
$areanames{zh}->{861313850} = "广东省肇庆市";
$areanames{zh}->{861313851} = "广东省肇庆市";
$areanames{zh}->{861313852} = "广东省肇庆市";
$areanames{zh}->{861313853} = "广东省肇庆市";
$areanames{zh}->{861313854} = "广东省肇庆市";
$areanames{zh}->{861313855} = "广东省汕头市";
$areanames{zh}->{861313856} = "广东省汕头市";
$areanames{zh}->{861313857} = "广东省汕头市";
$areanames{zh}->{861313858} = "广东省汕头市";
$areanames{zh}->{861313859} = "广东省汕头市";
$areanames{zh}->{86131386} = "广东省广州市";
$areanames{zh}->{86131387} = "广东省茂名市";
$areanames{zh}->{861313880} = "广东省东莞市";
$areanames{zh}->{861313881} = "广东省东莞市";
$areanames{zh}->{861313882} = "广东省东莞市";
$areanames{zh}->{861313883} = "广东省东莞市";
$areanames{zh}->{861313884} = "广东省东莞市";
$areanames{zh}->{861313885} = "广东省深圳市";
$areanames{zh}->{861313886} = "广东省深圳市";
$areanames{zh}->{861313887} = "广东省深圳市";
$areanames{zh}->{861313888} = "广东省深圳市";
$areanames{zh}->{861313889} = "广东省深圳市";
$areanames{zh}->{86131389} = "海南省海口市";
$areanames{zh}->{86131390} = "青海省西宁市";
$areanames{zh}->{861313900} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313901} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313902} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313903} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313910} = "青海省海北藏族自治州";
$areanames{zh}->{861313911} = "青海省海东地区";
$areanames{zh}->{861313912} = "青海省海东地区";
$areanames{zh}->{861313913} = "青海省黄南藏族自治州";
$areanames{zh}->{861313914} = "青海省海南藏族自治州";
$areanames{zh}->{861313915} = "青海省果洛藏族自治州";
$areanames{zh}->{861313916} = "青海省玉树藏族自治州";
$areanames{zh}->{861313917} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313918} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861313919} = "青海省海东地区";
$areanames{zh}->{86131392} = "甘肃省兰州市";
$areanames{zh}->{861313930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861313931} = "甘肃省兰州市";
$areanames{zh}->{861313932} = "甘肃省定西市";
$areanames{zh}->{861313933} = "甘肃省平凉市";
$areanames{zh}->{861313934} = "甘肃省庆阳市";
$areanames{zh}->{861313935} = "甘肃省武威市";
$areanames{zh}->{861313936} = "甘肃省张掖市";
$areanames{zh}->{861313937} = "甘肃省酒泉市";
$areanames{zh}->{861313938} = "甘肃省天水市";
$areanames{zh}->{861313939} = "甘肃省陇南市";
$areanames{zh}->{861313940} = "甘肃省兰州市";
$areanames{zh}->{861313941} = "甘肃省陇南市";
$areanames{zh}->{861313942} = "甘肃省定西市";
$areanames{zh}->{861313943} = "甘肃省白银市";
$areanames{zh}->{861313944} = "甘肃省天水市";
$areanames{zh}->{861313945} = "甘肃省武威市";
$areanames{zh}->{861313946} = "甘肃省庆阳市";
$areanames{zh}->{861313947} = "甘肃省嘉峪关市";
$areanames{zh}->{861313948} = "甘肃省酒泉市";
$areanames{zh}->{861313949} = "甘肃省酒泉市";
$areanames{zh}->{861313950} = "宁夏银川市";
$areanames{zh}->{861313951} = "宁夏银川市";
$areanames{zh}->{861313952} = "宁夏石嘴山市";
$areanames{zh}->{861313953} = "宁夏吴忠市";
$areanames{zh}->{861313954} = "宁夏固原市";
$areanames{zh}->{861313955} = "宁夏吴忠市";
$areanames{zh}->{861313956} = "宁夏石嘴山市";
$areanames{zh}->{861313957} = "宁夏吴忠市";
$areanames{zh}->{861313958} = "宁夏银川市";
$areanames{zh}->{861313959} = "宁夏银川市";
$areanames{zh}->{86131396} = "新疆乌鲁木齐市";
$areanames{zh}->{861313970} = "新疆昌吉回族自治州";
$areanames{zh}->{861313971} = "新疆哈密地区";
$areanames{zh}->{861313972} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861313973} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861313974} = "新疆阿克苏地区";
$areanames{zh}->{861313975} = "新疆喀什地区";
$areanames{zh}->{861313976} = "新疆和田地区";
$areanames{zh}->{861313977} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861313978} = "新疆塔城地区";
$areanames{zh}->{861313979} = "新疆阿勒泰地区";
$areanames{zh}->{861313980} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861313981} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861313982} = "新疆塔城地区";
$areanames{zh}->{861313983} = "新疆阿勒泰地区";
$areanames{zh}->{861313984} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861313985} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861313986} = "新疆阿克苏地区";
$areanames{zh}->{861313987} = "新疆乌鲁木齐市";
$areanames{zh}->{861313988} = "新疆乌鲁木齐市";
$areanames{zh}->{861313989} = "新疆乌鲁木齐市";
$areanames{zh}->{861313990} = "新疆克拉玛依市";
$areanames{zh}->{861313991} = "新疆乌鲁木齐市";
$areanames{zh}->{861313992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861313993} = "新疆石河子市";
$areanames{zh}->{861313994} = "新疆昌吉回族自治州";
$areanames{zh}->{861313995} = "新疆吐鲁番地区";
$areanames{zh}->{861313996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861313997} = "新疆阿克苏地区";
$areanames{zh}->{861313998} = "新疆喀什地区";
$areanames{zh}->{861313999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86131400} = "河南省郑州市";
$areanames{zh}->{86131401} = "河南省郑州市";
$areanames{zh}->{86131402} = "重庆市";
$areanames{zh}->{86131403} = "重庆市";
$areanames{zh}->{861314040} = "河南省安阳市";
$areanames{zh}->{861314041} = "河南省安阳市";
$areanames{zh}->{861314042} = "河南省鹤壁市";
$areanames{zh}->{861314043} = "河南省焦作市";
$areanames{zh}->{861314044} = "河南省焦作市";
$areanames{zh}->{861314045} = "河南省开封市";
$areanames{zh}->{861314046} = "河南省开封市";
$areanames{zh}->{861314047} = "河南省洛阳市";
$areanames{zh}->{861314048} = "河南省洛阳市";
$areanames{zh}->{861314049} = "河南省洛阳市";
$areanames{zh}->{861314050} = "河南省漯河市";
$areanames{zh}->{861314051} = "河南省南阳市";
$areanames{zh}->{861314052} = "河南省南阳市";
$areanames{zh}->{861314053} = "河南省平顶山市";
$areanames{zh}->{861314054} = "河南省商丘市";
$areanames{zh}->{861314055} = "河南省濮阳市";
$areanames{zh}->{861314056} = "河南省三门峡市";
$areanames{zh}->{861314057} = "河南省商丘市";
$areanames{zh}->{861314058} = "河南省新乡市";
$areanames{zh}->{861314059} = "河南省新乡市";
$areanames{zh}->{861314060} = "河南省信阳市";
$areanames{zh}->{861314061} = "河南省信阳市";
$areanames{zh}->{861314062} = "河南省许昌市";
$areanames{zh}->{861314063} = "河南省许昌市";
$areanames{zh}->{861314064} = "河南省周口市";
$areanames{zh}->{861314065} = "河南省周口市";
$areanames{zh}->{861314066} = "河南省周口市";
$areanames{zh}->{861314067} = "河南省驻马店市";
$areanames{zh}->{861314068} = "河南省驻马店市";
$areanames{zh}->{861314069} = "河南省驻马店市";
$areanames{zh}->{86131407} = "江苏省南京市";
$areanames{zh}->{86131408} = "江苏省苏州市";
$areanames{zh}->{86131409} = "江苏省苏州市";
$areanames{zh}->{86131410} = "北京市";
$areanames{zh}->{86131411} = "北京市";
$areanames{zh}->{86131412} = "北京市";
$areanames{zh}->{86131413} = "北京市";
$areanames{zh}->{86131414} = "北京市";
$areanames{zh}->{861314150} = "江苏省连云港市";
$areanames{zh}->{861314151} = "江苏省连云港市";
$areanames{zh}->{861314152} = "江苏省连云港市";
$areanames{zh}->{861314153} = "江苏省连云港市";
$areanames{zh}->{861314154} = "湖南省益阳市";
$areanames{zh}->{861314155} = "湖南省益阳市";
$areanames{zh}->{861314156} = "江苏省宿迁市";
$areanames{zh}->{861314157} = "江苏省宿迁市";
$areanames{zh}->{861314158} = "江苏省宿迁市";
$areanames{zh}->{861314159} = "湖南省郴州市";
$areanames{zh}->{861314160} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861314161} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861314162} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861314163} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861314164} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861314165} = "江苏省南京市";
$areanames{zh}->{861314166} = "江苏省南京市";
$areanames{zh}->{861314167} = "江苏省南京市";
$areanames{zh}->{861314168} = "江苏省南京市";
$areanames{zh}->{861314169} = "江苏省南京市";
$areanames{zh}->{861314170} = "湖南省郴州市";
$areanames{zh}->{861314171} = "湖南省郴州市";
$areanames{zh}->{861314172} = "江苏省南通市";
$areanames{zh}->{861314173} = "江苏省南通市";
$areanames{zh}->{861314174} = "江苏省南通市";
$areanames{zh}->{861314175} = "甘肃省定西市";
$areanames{zh}->{861314176} = "甘肃省定西市";
$areanames{zh}->{861314177} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861314178} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861314179} = "内蒙古锡林郭勒盟";
$areanames{zh}->{86131418} = "江苏省苏州市";
$areanames{zh}->{861314190} = "江苏省盐城市";
$areanames{zh}->{861314191} = "江苏省盐城市";
$areanames{zh}->{861314192} = "甘肃省天水市";
$areanames{zh}->{861314193} = "甘肃省天水市";
$areanames{zh}->{861314194} = "甘肃省定西市";
$areanames{zh}->{861314195} = "湖南省邵阳市";
$areanames{zh}->{861314196} = "湖南省邵阳市";
$areanames{zh}->{861314197} = "湖南省邵阳市";
$areanames{zh}->{861314198} = "江苏省泰州市";
$areanames{zh}->{861314199} = "江苏省泰州市";
$areanames{zh}->{86131420} = "湖南省长沙市";
$areanames{zh}->{86131421} = "湖南省长沙市";
$areanames{zh}->{86131422} = "湖南省长沙市";
$areanames{zh}->{86131423} = "湖南省衡阳市";
$areanames{zh}->{861314240} = "内蒙古包头市";
$areanames{zh}->{861314241} = "内蒙古包头市";
$areanames{zh}->{861314242} = "内蒙古包头市";
$areanames{zh}->{861314243} = "内蒙古包头市";
$areanames{zh}->{861314244} = "内蒙古包头市";
$areanames{zh}->{861314245} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861314246} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861314247} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861314248} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861314249} = "内蒙古阿拉善盟";
$areanames{zh}->{86131425} = "江苏省常州市";
$areanames{zh}->{861314257} = "湖南省邵阳市";
$areanames{zh}->{861314258} = "江苏省扬州市";
$areanames{zh}->{861314259} = "江苏省扬州市";
$areanames{zh}->{861314260} = "江苏省镇江市";
$areanames{zh}->{861314261} = "内蒙古包头市";
$areanames{zh}->{861314262} = "江苏省镇江市";
$areanames{zh}->{861314263} = "内蒙古包头市";
$areanames{zh}->{861314264} = "内蒙古包头市";
$areanames{zh}->{861314265} = "江苏省南通市";
$areanames{zh}->{861314266} = "江苏省南通市";
$areanames{zh}->{861314267} = "江苏省南通市";
$areanames{zh}->{861314268} = "江苏省南通市";
$areanames{zh}->{861314269} = "江苏省南通市";
$areanames{zh}->{86131427} = "浙江省温州市";
$areanames{zh}->{861314280} = "江苏省南京市";
$areanames{zh}->{861314281} = "江苏省南京市";
$areanames{zh}->{861314282} = "江苏省南京市";
$areanames{zh}->{861314283} = "江苏省南京市";
$areanames{zh}->{861314284} = "江苏省南京市";
$areanames{zh}->{861314285} = "江苏省泰州市";
$areanames{zh}->{861314286} = "江苏省泰州市";
$areanames{zh}->{861314287} = "湖南省湘潭市";
$areanames{zh}->{861314288} = "江苏省泰州市";
$areanames{zh}->{861314289} = "江苏省泰州市";
$areanames{zh}->{86131429} = "江苏省南通市";
$areanames{zh}->{86131430} = "广东省惠州市";
$areanames{zh}->{861314301} = "河北省石家庄市";
$areanames{zh}->{861314302} = "河北省石家庄市";
$areanames{zh}->{861314304} = "河北省石家庄市";
$areanames{zh}->{861314310} = "广东省珠海市";
$areanames{zh}->{861314311} = "广东省珠海市";
$areanames{zh}->{861314312} = "广东省珠海市";
$areanames{zh}->{861314313} = "广东省珠海市";
$areanames{zh}->{861314314} = "广东省珠海市";
$areanames{zh}->{861314315} = "河北省廊坊市";
$areanames{zh}->{861314316} = "广东省佛山市";
$areanames{zh}->{861314317} = "广东省佛山市";
$areanames{zh}->{861314318} = "广东省佛山市";
$areanames{zh}->{861314319} = "广东省佛山市";
$areanames{zh}->{86131432} = "广东省东莞市";
$areanames{zh}->{86131433} = "广东省广州市";
$areanames{zh}->{86131434} = "广东省深圳市";
$areanames{zh}->{861314347} = "广东省惠州市";
$areanames{zh}->{861314348} = "河北省石家庄市";
$areanames{zh}->{861314349} = "河北省石家庄市";
$areanames{zh}->{861314350} = "广东省广州市";
$areanames{zh}->{861314351} = "广东省广州市";
$areanames{zh}->{861314352} = "广东省广州市";
$areanames{zh}->{861314353} = "广东省广州市";
$areanames{zh}->{861314354} = "广东省广州市";
$areanames{zh}->{861314355} = "广东省佛山市";
$areanames{zh}->{861314356} = "广东省佛山市";
$areanames{zh}->{861314357} = "广东省佛山市";
$areanames{zh}->{861314358} = "广东省佛山市";
$areanames{zh}->{861314359} = "广东省佛山市";
$areanames{zh}->{861314360} = "广东省惠州市";
$areanames{zh}->{861314361} = "广东省惠州市";
$areanames{zh}->{861314362} = "广东省惠州市";
$areanames{zh}->{861314363} = "河北省石家庄市";
$areanames{zh}->{861314364} = "河北省石家庄市";
$areanames{zh}->{861314365} = "广东省广州市";
$areanames{zh}->{861314366} = "广东省广州市";
$areanames{zh}->{861314367} = "广东省广州市";
$areanames{zh}->{861314368} = "广东省广州市";
$areanames{zh}->{861314369} = "广东省广州市";
$areanames{zh}->{86131437} = "广东省广州市";
$areanames{zh}->{86131438} = "广东省深圳市";
$areanames{zh}->{86131439} = "广东省深圳市";
$areanames{zh}->{861314400} = "广东省中山市";
$areanames{zh}->{861314401} = "广东省中山市";
$areanames{zh}->{861314402} = "广东省中山市";
$areanames{zh}->{861314403} = "广东省中山市";
$areanames{zh}->{861314404} = "广东省中山市";
$areanames{zh}->{861314405} = "广东省潮州市";
$areanames{zh}->{861314406} = "广东省潮州市";
$areanames{zh}->{861314407} = "广东省揭阳市";
$areanames{zh}->{861314408} = "广东省揭阳市";
$areanames{zh}->{861314409} = "广东省揭阳市";
$areanames{zh}->{861314410} = "广东省河源市";
$areanames{zh}->{861314411} = "广东省佛山市";
$areanames{zh}->{861314412} = "广东省佛山市";
$areanames{zh}->{861314413} = "广东省佛山市";
$areanames{zh}->{861314414} = "广东省佛山市";
$areanames{zh}->{861314415} = "广东省肇庆市";
$areanames{zh}->{861314416} = "广东省肇庆市";
$areanames{zh}->{861314417} = "广东省肇庆市";
$areanames{zh}->{861314418} = "广东省肇庆市";
$areanames{zh}->{861314419} = "广东省肇庆市";
$areanames{zh}->{861314420} = "广东省江门市";
$areanames{zh}->{861314421} = "广东省江门市";
$areanames{zh}->{861314422} = "广东省江门市";
$areanames{zh}->{861314423} = "广东省江门市";
$areanames{zh}->{861314424} = "广东省江门市";
$areanames{zh}->{861314425} = "广东省汕头市";
$areanames{zh}->{861314426} = "广东省汕头市";
$areanames{zh}->{861314427} = "广东省汕头市";
$areanames{zh}->{861314428} = "广东省汕头市";
$areanames{zh}->{861314429} = "广东省汕头市";
$areanames{zh}->{861314430} = "吉林省长春市";
$areanames{zh}->{861314431} = "吉林省长春市";
$areanames{zh}->{861314432} = "吉林省吉林市";
$areanames{zh}->{861314433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861314434} = "吉林省四平市";
$areanames{zh}->{861314435} = "吉林省通化市";
$areanames{zh}->{861314436} = "吉林省白城市";
$areanames{zh}->{861314437} = "吉林省辽源市";
$areanames{zh}->{861314438} = "吉林省松原市";
$areanames{zh}->{861314439} = "吉林省白山市";
$areanames{zh}->{86131444} = "广东省广州市";
$areanames{zh}->{861314446} = "广东省潮州市";
$areanames{zh}->{861314447} = "广东省汕尾市";
$areanames{zh}->{861314448} = "广东省汕尾市";
$areanames{zh}->{861314449} = "广东省汕尾市";
$areanames{zh}->{861314450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861314453} = "黑龙江省牡丹江市";
$areanames{zh}->{861314454} = "黑龙江省佳木斯市";
$areanames{zh}->{861314455} = "黑龙江省绥化市";
$areanames{zh}->{861314456} = "黑龙江省黑河市";
$areanames{zh}->{861314457} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861314458} = "黑龙江省伊春市";
$areanames{zh}->{861314459} = "黑龙江省大庆市";
$areanames{zh}->{861314460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314462} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314463} = "黑龙江省牡丹江市";
$areanames{zh}->{861314464} = "黑龙江省七台河市";
$areanames{zh}->{861314465} = "黑龙江省大庆市";
$areanames{zh}->{861314466} = "黑龙江省鸡西市";
$areanames{zh}->{861314467} = "黑龙江省鸡西市";
$areanames{zh}->{861314468} = "黑龙江省鹤岗市";
$areanames{zh}->{861314469} = "黑龙江省双鸭山市";
$areanames{zh}->{86131447} = "广东省佛山市";
$areanames{zh}->{861314480} = "广东省深圳市";
$areanames{zh}->{861314481} = "广东省深圳市";
$areanames{zh}->{861314482} = "广东省深圳市";
$areanames{zh}->{861314483} = "广东省深圳市";
$areanames{zh}->{861314484} = "广东省深圳市";
$areanames{zh}->{861314485} = "广东省东莞市";
$areanames{zh}->{861314486} = "广东省东莞市";
$areanames{zh}->{861314487} = "广东省东莞市";
$areanames{zh}->{861314488} = "广东省东莞市";
$areanames{zh}->{861314489} = "广东省东莞市";
$areanames{zh}->{86131449} = "广东省东莞市";
$areanames{zh}->{86131450} = "江苏省苏州市";
$areanames{zh}->{86131451} = "江苏省南京市";
$areanames{zh}->{861314510} = "江苏省苏州市";
$areanames{zh}->{861314511} = "江苏省苏州市";
$areanames{zh}->{861314520} = "江苏省徐州市";
$areanames{zh}->{861314521} = "江苏省徐州市";
$areanames{zh}->{861314522} = "江苏省徐州市";
$areanames{zh}->{861314523} = "湖南省湘潭市";
$areanames{zh}->{861314524} = "甘肃省天水市";
$areanames{zh}->{861314525} = "内蒙古通辽市";
$areanames{zh}->{861314526} = "内蒙古包头市";
$areanames{zh}->{861314527} = "内蒙古包头市";
$areanames{zh}->{861314528} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861314529} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861314530} = "山东省菏泽市";
$areanames{zh}->{861314531} = "山东省济南市";
$areanames{zh}->{861314532} = "山东省青岛市";
$areanames{zh}->{861314533} = "山东省淄博市";
$areanames{zh}->{861314534} = "山东省德州市";
$areanames{zh}->{861314535} = "山东省烟台市";
$areanames{zh}->{861314536} = "山东省潍坊市";
$areanames{zh}->{861314537} = "山东省济宁市";
$areanames{zh}->{861314538} = "山东省泰安市";
$areanames{zh}->{861314539} = "山东省临沂市";
$areanames{zh}->{861314540} = "山东省济南市";
$areanames{zh}->{861314541} = "山东省济南市";
$areanames{zh}->{861314542} = "山东省青岛市";
$areanames{zh}->{861314543} = "山东省滨州市";
$areanames{zh}->{861314544} = "山东省日照市";
$areanames{zh}->{861314545} = "山东省东营市";
$areanames{zh}->{861314546} = "山东省东营市";
$areanames{zh}->{861314547} = "山东省济南市";
$areanames{zh}->{861314548} = "山东省莱芜市";
$areanames{zh}->{861314549} = "山东省临沂市";
$areanames{zh}->{861314550} = "安徽省滁州市";
$areanames{zh}->{861314551} = "安徽省合肥市";
$areanames{zh}->{861314552} = "安徽省蚌埠市";
$areanames{zh}->{861314553} = "安徽省芜湖市";
$areanames{zh}->{861314554} = "安徽省淮南市";
$areanames{zh}->{861314555} = "安徽省马鞍山市";
$areanames{zh}->{861314556} = "安徽省安庆市";
$areanames{zh}->{861314557} = "安徽省宿州市";
$areanames{zh}->{861314558} = "安徽省阜阳市";
$areanames{zh}->{861314559} = "安徽省黄山市";
$areanames{zh}->{861314560} = "安徽省宿州市";
$areanames{zh}->{861314561} = "安徽省淮北市";
$areanames{zh}->{861314562} = "安徽省铜陵市";
$areanames{zh}->{861314563} = "安徽省宣城市";
$areanames{zh}->{861314564} = "安徽省六安市";
$areanames{zh}->{861314565} = "安徽省合肥市";
$areanames{zh}->{861314566} = "安徽省池州市";
$areanames{zh}->{861314567} = "安徽省亳州市";
$areanames{zh}->{861314568} = "安徽省亳州市";
$areanames{zh}->{861314569} = "安徽省宣城市";
$areanames{zh}->{86131457} = "广东省广州市";
$areanames{zh}->{86131458} = "广东省深圳市";
$areanames{zh}->{86131459} = "广东省深圳市";
$areanames{zh}->{8613146} = "北京市";
$areanames{zh}->{86131470} = "广东省深圳市";
$areanames{zh}->{86131471} = "湖北省武汉市";
$areanames{zh}->{861314720} = "湖北省鄂州市";
$areanames{zh}->{861314721} = "湖北省荆州市";
$areanames{zh}->{861314722} = "湖北省随州市";
$areanames{zh}->{861314723} = "湖北省黄石市";
$areanames{zh}->{861314724} = "湖北省咸宁市";
$areanames{zh}->{861314725} = "湖北省荆门市";
$areanames{zh}->{861314726} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861314727} = "湖北省襄樊市";
$areanames{zh}->{861314728} = "湖北省十堰市";
$areanames{zh}->{861314729} = "湖北省孝感市";
$areanames{zh}->{86131473} = "广东省东莞市";
$areanames{zh}->{86131474} = "河北省石家庄市";
$areanames{zh}->{86131475} = "广东省深圳市";
$areanames{zh}->{861314760} = "吉林省白城市";
$areanames{zh}->{861314761} = "吉林省白城市";
$areanames{zh}->{861314762} = "吉林省白城市";
$areanames{zh}->{861314763} = "吉林省吉林市";
$areanames{zh}->{861314764} = "吉林省长春市";
$areanames{zh}->{861314765} = "吉林省长春市";
$areanames{zh}->{861314766} = "吉林省长春市";
$areanames{zh}->{861314767} = "吉林省松原市";
$areanames{zh}->{861314768} = "吉林省松原市";
$areanames{zh}->{861314769} = "吉林省松原市";
$areanames{zh}->{861314770} = "吉林省长春市";
$areanames{zh}->{861314771} = "吉林省长春市";
$areanames{zh}->{861314772} = "吉林省松原市";
$areanames{zh}->{861314773} = "吉林省吉林市";
$areanames{zh}->{861314774} = "吉林省吉林市";
$areanames{zh}->{861314775} = "吉林省吉林市";
$areanames{zh}->{861314776} = "吉林省吉林市";
$areanames{zh}->{861314777} = "吉林省吉林市";
$areanames{zh}->{861314778} = "吉林省辽源市";
$areanames{zh}->{861314779} = "吉林省辽源市";
$areanames{zh}->{861314780} = "辽宁省沈阳市";
$areanames{zh}->{861314781} = "辽宁省沈阳市";
$areanames{zh}->{861314782} = "辽宁省沈阳市";
$areanames{zh}->{861314783} = "辽宁省沈阳市";
$areanames{zh}->{861314784} = "辽宁省大连市";
$areanames{zh}->{861314785} = "辽宁省大连市";
$areanames{zh}->{861314786} = "辽宁省大连市";
$areanames{zh}->{861314787} = "辽宁省大连市";
$areanames{zh}->{861314788} = "辽宁省鞍山市";
$areanames{zh}->{861314789} = "辽宁省锦州市";
$areanames{zh}->{861314790} = "辽宁省锦州市";
$areanames{zh}->{861314791} = "辽宁省锦州市";
$areanames{zh}->{861314792} = "辽宁省锦州市";
$areanames{zh}->{861314793} = "辽宁省营口市";
$areanames{zh}->{861314794} = "辽宁省阜新市";
$areanames{zh}->{861314795} = "辽宁省辽阳市";
$areanames{zh}->{861314796} = "辽宁省铁岭市";
$areanames{zh}->{861314797} = "辽宁省朝阳市";
$areanames{zh}->{861314798} = "辽宁省盘锦市";
$areanames{zh}->{861314799} = "辽宁省葫芦岛市";
$areanames{zh}->{86131480} = "河南省商丘市";
$areanames{zh}->{86131481} = "上海市";
$areanames{zh}->{86131482} = "河南省周口市";
$areanames{zh}->{86131483} = "浙江省杭州市";
$areanames{zh}->{86131484} = "浙江省杭州市";
$areanames{zh}->{861314850} = "广东省中山市";
$areanames{zh}->{861314851} = "广东省中山市";
$areanames{zh}->{861314852} = "广东省中山市";
$areanames{zh}->{861314853} = "广东省中山市";
$areanames{zh}->{861314854} = "广东省中山市";
$areanames{zh}->{861314855} = "广东省东莞市";
$areanames{zh}->{861314856} = "广东省东莞市";
$areanames{zh}->{861314857} = "广东省东莞市";
$areanames{zh}->{861314858} = "广东省东莞市";
$areanames{zh}->{861314859} = "广东省东莞市";
$areanames{zh}->{861314860} = "广东省河源市";
$areanames{zh}->{861314861} = "广东省河源市";
$areanames{zh}->{861314862} = "广东省梅州市";
$areanames{zh}->{861314863} = "河北省石家庄市";
$areanames{zh}->{861314864} = "广东省云浮市";
$areanames{zh}->{861314865} = "广东省云浮市";
$areanames{zh}->{861314866} = "广东省阳江市";
$areanames{zh}->{861314867} = "广东省阳江市";
$areanames{zh}->{861314868} = "广东省韶关市";
$areanames{zh}->{861314869} = "广东省韶关市";
$areanames{zh}->{86131487} = "广东省深圳市";
$areanames{zh}->{86131488} = "广东省深圳市";
$areanames{zh}->{86131489} = "广东省广州市";
$areanames{zh}->{861314900} = "广东省阳江市";
$areanames{zh}->{861314901} = "广东省清远市";
$areanames{zh}->{861314902} = "广东省清远市";
$areanames{zh}->{861314903} = "广东省清远市";
$areanames{zh}->{861314904} = "广东省阳江市";
$areanames{zh}->{861314905} = "广东省韶关市";
$areanames{zh}->{861314906} = "广东省韶关市";
$areanames{zh}->{861314907} = "广东省韶关市";
$areanames{zh}->{861314908} = "广东省韶关市";
$areanames{zh}->{861314909} = "广东省清远市";
$areanames{zh}->{861314910} = "陕西省咸阳市";
$areanames{zh}->{861314911} = "陕西省延安市";
$areanames{zh}->{861314912} = "陕西省榆林市";
$areanames{zh}->{861314913} = "陕西省渭南市";
$areanames{zh}->{861314914} = "陕西省商洛市";
$areanames{zh}->{861314915} = "陕西省安康市";
$areanames{zh}->{861314916} = "陕西省汉中市";
$areanames{zh}->{861314917} = "陕西省宝鸡市";
$areanames{zh}->{861314918} = "陕西省西安市";
$areanames{zh}->{861314919} = "陕西省铜川市";
$areanames{zh}->{86131492} = "陕西省西安市";
$areanames{zh}->{86131493} = "广东省广州市";
$areanames{zh}->{861314930} = "广东省珠海市";
$areanames{zh}->{861314931} = "广东省珠海市";
$areanames{zh}->{861314932} = "广东省湛江市";
$areanames{zh}->{861314933} = "广东省湛江市";
$areanames{zh}->{86131494} = "河北省石家庄市";
$areanames{zh}->{861314950} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314951} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314952} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861314953} = "黑龙江省牡丹江市";
$areanames{zh}->{861314954} = "黑龙江省佳木斯市";
$areanames{zh}->{861314955} = "黑龙江省绥化市";
$areanames{zh}->{861314956} = "黑龙江省黑河市";
$areanames{zh}->{861314957} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861314958} = "黑龙江省伊春市";
$areanames{zh}->{861314959} = "黑龙江省大庆市";
$areanames{zh}->{861314960} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314961} = "黑龙江省哈尔滨市";
$areanames{zh}->{861314962} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861314963} = "黑龙江省牡丹江市";
$areanames{zh}->{861314964} = "黑龙江省七台河市";
$areanames{zh}->{861314965} = "黑龙江省大庆市";
$areanames{zh}->{861314966} = "黑龙江省佳木斯市";
$areanames{zh}->{861314967} = "黑龙江省鸡西市";
$areanames{zh}->{861314968} = "黑龙江省鹤岗市";
$areanames{zh}->{861314969} = "黑龙江省双鸭山市";
$areanames{zh}->{861314970} = "辽宁省锦州市";
$areanames{zh}->{861314971} = "辽宁省营口市";
$areanames{zh}->{861314972} = "辽宁省鞍山市";
$areanames{zh}->{861314973} = "辽宁省锦州市";
$areanames{zh}->{861314974} = "辽宁省锦州市";
$areanames{zh}->{861314975} = "辽宁省阜新市";
$areanames{zh}->{861314976} = "辽宁省锦州市";
$areanames{zh}->{861314977} = "辽宁省营口市";
$areanames{zh}->{861314978} = "辽宁省锦州市";
$areanames{zh}->{861314979} = "辽宁省辽阳市";
$areanames{zh}->{86131498} = "辽宁省沈阳市";
$areanames{zh}->{861314986} = "辽宁省大连市";
$areanames{zh}->{861314987} = "辽宁省大连市";
$areanames{zh}->{861314988} = "辽宁省大连市";
$areanames{zh}->{861314989} = "辽宁省大连市";
$areanames{zh}->{86131499} = "广东省深圳市";
$areanames{zh}->{861315000} = "甘肃省张掖市";
$areanames{zh}->{861315001} = "甘肃省兰州市";
$areanames{zh}->{861315002} = "甘肃省兰州市";
$areanames{zh}->{861315003} = "甘肃省陇南市";
$areanames{zh}->{861315004} = "甘肃省临夏回族自治州";
$areanames{zh}->{861315005} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861315006} = "甘肃省天水市";
$areanames{zh}->{861315007} = "甘肃省天水市";
$areanames{zh}->{861315008} = "甘肃省陇南市";
$areanames{zh}->{861315009} = "甘肃省临夏回族自治州";
$areanames{zh}->{861315010} = "甘肃省定西市";
$areanames{zh}->{861315011} = "甘肃省定西市";
$areanames{zh}->{861315012} = "甘肃省庆阳市";
$areanames{zh}->{861315013} = "甘肃省庆阳市";
$areanames{zh}->{861315014} = "甘肃省张掖市";
$areanames{zh}->{861315015} = "甘肃省武威市";
$areanames{zh}->{861315016} = "甘肃省武威市";
$areanames{zh}->{861315017} = "甘肃省金昌市";
$areanames{zh}->{861315018} = "甘肃省平凉市";
$areanames{zh}->{861315019} = "甘肃省酒泉市";
$areanames{zh}->{861315020} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861315021} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861315022} = "新疆塔城地区";
$areanames{zh}->{861315023} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861315024} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861315025} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861315026} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861315027} = "新疆阿克苏地区";
$areanames{zh}->{861315028} = "新疆阿克苏地区";
$areanames{zh}->{861315029} = "新疆喀什地区";
$areanames{zh}->{861315030} = "新疆乌鲁木齐市";
$areanames{zh}->{861315031} = "新疆乌鲁木齐市";
$areanames{zh}->{861315032} = "新疆乌鲁木齐市";
$areanames{zh}->{861315033} = "新疆乌鲁木齐市";
$areanames{zh}->{861315034} = "新疆乌鲁木齐市";
$areanames{zh}->{861315035} = "新疆昌吉回族自治州";
$areanames{zh}->{861315036} = "新疆哈密地区";
$areanames{zh}->{861315037} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861315038} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861315039} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861315040} = "新疆石河子市";
$areanames{zh}->{861315041} = "新疆喀什地区";
$areanames{zh}->{861315042} = "新疆阿克苏地区";
$areanames{zh}->{861315043} = "新疆和田地区";
$areanames{zh}->{861315044} = "新疆喀什地区";
$areanames{zh}->{861315045} = "新疆乌鲁木齐市";
$areanames{zh}->{861315046} = "新疆乌鲁木齐市";
$areanames{zh}->{861315047} = "新疆乌鲁木齐市";
$areanames{zh}->{861315048} = "新疆阿克苏地区";
$areanames{zh}->{861315049} = "新疆乌鲁木齐市";
$areanames{zh}->{861315050} = "云南省玉溪市";
$areanames{zh}->{861315051} = "云南省玉溪市";
$areanames{zh}->{861315052} = "云南省玉溪市";
$areanames{zh}->{861315053} = "云南省曲靖市";
$areanames{zh}->{861315054} = "云南省曲靖市";
$areanames{zh}->{861315055} = "云南省曲靖市";
$areanames{zh}->{861315056} = "云南省楚雄彝族自治州";
$areanames{zh}->{861315057} = "云南省楚雄彝族自治州";
$areanames{zh}->{861315058} = "云南省楚雄彝族自治州";
$areanames{zh}->{861315059} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861315060} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861315061} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861315062} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861315063} = "云南省大理白族自治州";
$areanames{zh}->{861315064} = "云南省大理白族自治州";
$areanames{zh}->{861315065} = "云南省大理白族自治州";
$areanames{zh}->{861315066} = "云南省丽江市";
$areanames{zh}->{861315067} = "云南省丽江市";
$areanames{zh}->{861315068} = "云南省昭通市";
$areanames{zh}->{861315069} = "云南省昭通市";
$areanames{zh}->{861315070} = "云南省昆明市";
$areanames{zh}->{861315071} = "云南省昆明市";
$areanames{zh}->{861315072} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861315073} = "云南省迪庆藏族自治州";
$areanames{zh}->{861315074} = "云南省昆明市";
$areanames{zh}->{861315075} = "云南省昆明市";
$areanames{zh}->{861315076} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861315077} = "云南省保山市";
$areanames{zh}->{861315078} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861315079} = "云南省普洱市";
$areanames{zh}->{861315080} = "内蒙古乌兰察布市";
$areanames{zh}->{861315081} = "内蒙古乌兰察布市";
$areanames{zh}->{861315082} = "内蒙古乌兰察布市";
$areanames{zh}->{861315083} = "内蒙古乌兰察布市";
$areanames{zh}->{861315084} = "内蒙古乌兰察布市";
$areanames{zh}->{861315085} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861315086} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861315087} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861315088} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861315089} = "内蒙古鄂尔多斯市";
$areanames{zh}->{86131509} = "内蒙古赤峰市";
$areanames{zh}->{861315090} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861315099} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861315100} = "江苏省无锡市";
$areanames{zh}->{861315101} = "江苏省无锡市";
$areanames{zh}->{861315102} = "江苏省无锡市";
$areanames{zh}->{861315103} = "江苏省无锡市";
$areanames{zh}->{861315104} = "江苏省无锡市";
$areanames{zh}->{861315105} = "江苏省南京市";
$areanames{zh}->{861315106} = "江苏省南京市";
$areanames{zh}->{861315107} = "江苏省南京市";
$areanames{zh}->{861315108} = "江苏省南京市";
$areanames{zh}->{861315109} = "江苏省南京市";
$areanames{zh}->{861315110} = "江苏省扬州市";
$areanames{zh}->{861315111} = "江苏省扬州市";
$areanames{zh}->{861315112} = "江苏省扬州市";
$areanames{zh}->{861315113} = "江苏省扬州市";
$areanames{zh}->{861315114} = "江苏省扬州市";
$areanames{zh}->{861315115} = "江苏省苏州市";
$areanames{zh}->{861315116} = "江苏省苏州市";
$areanames{zh}->{861315117} = "江苏省苏州市";
$areanames{zh}->{861315118} = "江苏省苏州市";
$areanames{zh}->{861315119} = "江苏省苏州市";
$areanames{zh}->{861315120} = "江苏省徐州市";
$areanames{zh}->{861315121} = "江苏省徐州市";
$areanames{zh}->{861315122} = "江苏省徐州市";
$areanames{zh}->{861315123} = "江苏省徐州市";
$areanames{zh}->{861315124} = "江苏省徐州市";
$areanames{zh}->{861315125} = "江苏省常州市";
$areanames{zh}->{861315126} = "江苏省常州市";
$areanames{zh}->{861315127} = "江苏省常州市";
$areanames{zh}->{861315128} = "江苏省常州市";
$areanames{zh}->{861315129} = "江苏省常州市";
$areanames{zh}->{861315130} = "江苏省淮安市";
$areanames{zh}->{861315131} = "江苏省淮安市";
$areanames{zh}->{861315132} = "江苏省淮安市";
$areanames{zh}->{861315133} = "江苏省淮安市";
$areanames{zh}->{861315134} = "江苏省淮安市";
$areanames{zh}->{861315135} = "江苏省盐城市";
$areanames{zh}->{861315136} = "江苏省盐城市";
$areanames{zh}->{861315137} = "江苏省连云港市";
$areanames{zh}->{861315138} = "江苏省连云港市";
$areanames{zh}->{861315139} = "江苏省连云港市";
$areanames{zh}->{861315140} = "江苏省南京市";
$areanames{zh}->{861315141} = "江苏省南京市";
$areanames{zh}->{861315142} = "江苏省南京市";
$areanames{zh}->{861315143} = "江苏省扬州市";
$areanames{zh}->{861315144} = "江苏省连云港市";
$areanames{zh}->{861315145} = "江苏省无锡市";
$areanames{zh}->{861315146} = "江苏省苏州市";
$areanames{zh}->{861315147} = "江苏省苏州市";
$areanames{zh}->{861315148} = "江苏省苏州市";
$areanames{zh}->{861315149} = "江苏省苏州市";
$areanames{zh}->{86131515} = "江苏省南京市";
$areanames{zh}->{861315150} = "江苏省扬州市";
$areanames{zh}->{861315151} = "江苏省扬州市";
$areanames{zh}->{861315160} = "江苏省扬州市";
$areanames{zh}->{861315161} = "江苏省扬州市";
$areanames{zh}->{861315162} = "江苏省苏州市";
$areanames{zh}->{861315163} = "江苏省苏州市";
$areanames{zh}->{861315164} = "江苏省苏州市";
$areanames{zh}->{861315165} = "江苏省苏州市";
$areanames{zh}->{861315166} = "江苏省苏州市";
$areanames{zh}->{861315167} = "江苏省镇江市";
$areanames{zh}->{861315168} = "江苏省镇江市";
$areanames{zh}->{861315169} = "江苏省镇江市";
$areanames{zh}->{86131517} = "江苏省连云港市";
$areanames{zh}->{861315178} = "江苏省徐州市";
$areanames{zh}->{861315179} = "江苏省徐州市";
$areanames{zh}->{86131518} = "江苏省淮安市";
$areanames{zh}->{861315180} = "江苏省宿迁市";
$areanames{zh}->{861315181} = "江苏省宿迁市";
$areanames{zh}->{861315182} = "江苏省宿迁市";
$areanames{zh}->{861315183} = "江苏省宿迁市";
$areanames{zh}->{86131519} = "江苏省无锡市";
$areanames{zh}->{861315198} = "江苏省徐州市";
$areanames{zh}->{861315199} = "江苏省徐州市";
$areanames{zh}->{86131520} = "陕西省西安市";
$areanames{zh}->{86131521} = "陕西省西安市";
$areanames{zh}->{861315220} = "陕西省宝鸡市";
$areanames{zh}->{861315221} = "陕西省宝鸡市";
$areanames{zh}->{861315222} = "陕西省宝鸡市";
$areanames{zh}->{861315223} = "陕西省宝鸡市";
$areanames{zh}->{861315224} = "陕西省宝鸡市";
$areanames{zh}->{861315225} = "陕西省商洛市";
$areanames{zh}->{861315226} = "陕西省商洛市";
$areanames{zh}->{861315227} = "陕西省铜川市";
$areanames{zh}->{861315228} = "陕西省铜川市";
$areanames{zh}->{861315229} = "陕西省铜川市";
$areanames{zh}->{861315230} = "陕西省咸阳市";
$areanames{zh}->{861315231} = "陕西省咸阳市";
$areanames{zh}->{861315232} = "陕西省咸阳市";
$areanames{zh}->{861315233} = "陕西省咸阳市";
$areanames{zh}->{861315234} = "陕西省咸阳市";
$areanames{zh}->{861315235} = "陕西省渭南市";
$areanames{zh}->{861315236} = "陕西省渭南市";
$areanames{zh}->{861315237} = "陕西省渭南市";
$areanames{zh}->{861315238} = "陕西省渭南市";
$areanames{zh}->{861315239} = "陕西省渭南市";
$areanames{zh}->{86131524} = "陕西省西安市";
$areanames{zh}->{861315250} = "广西南宁市";
$areanames{zh}->{861315251} = "广西南宁市";
$areanames{zh}->{861315252} = "广西柳州市";
$areanames{zh}->{861315253} = "广西桂林市";
$areanames{zh}->{861315254} = "广西柳州市";
$areanames{zh}->{861315255} = "广西柳州市";
$areanames{zh}->{861315256} = "广西柳州市";
$areanames{zh}->{861315257} = "广西桂林市";
$areanames{zh}->{861315258} = "广西桂林市";
$areanames{zh}->{861315259} = "广西桂林市";
$areanames{zh}->{86131526} = "广西南宁市";
$areanames{zh}->{861315262} = "广西柳州市";
$areanames{zh}->{861315263} = "广西桂林市";
$areanames{zh}->{861315270} = "山西省忻州市";
$areanames{zh}->{861315271} = "山西省朔州市";
$areanames{zh}->{861315272} = "山西省大同市";
$areanames{zh}->{861315273} = "山西省阳泉市";
$areanames{zh}->{861315274} = "山西省运城市";
$areanames{zh}->{861315275} = "山西省长治市";
$areanames{zh}->{861315276} = "山西省晋城市";
$areanames{zh}->{861315277} = "山西省临汾市";
$areanames{zh}->{861315278} = "山西省吕梁市";
$areanames{zh}->{861315279} = "山西省运城市";
$areanames{zh}->{861315280} = "山西省临汾市";
$areanames{zh}->{861315281} = "山西省晋中市";
$areanames{zh}->{861315282} = "山西省大同市";
$areanames{zh}->{861315283} = "山西省阳泉市";
$areanames{zh}->{861315284} = "山西省忻州市";
$areanames{zh}->{861315285} = "山西省长治市";
$areanames{zh}->{861315286} = "山西省晋城市";
$areanames{zh}->{861315287} = "山西省临汾市";
$areanames{zh}->{861315288} = "山西省晋中市";
$areanames{zh}->{861315289} = "山西省运城市";
$areanames{zh}->{861315290} = "山西省忻州市";
$areanames{zh}->{861315291} = "山西省晋中市";
$areanames{zh}->{861315292} = "山西省大同市";
$areanames{zh}->{861315293} = "山西省朔州市";
$areanames{zh}->{861315294} = "山西省大同市";
$areanames{zh}->{861315295} = "山西省长治市";
$areanames{zh}->{861315296} = "山西省晋城市";
$areanames{zh}->{861315297} = "山西省临汾市";
$areanames{zh}->{861315298} = "山西省吕梁市";
$areanames{zh}->{861315299} = "山西省运城市";
$areanames{zh}->{861315300} = "山东省济南市";
$areanames{zh}->{861315301} = "山东省济南市";
$areanames{zh}->{861315302} = "山东省济南市";
$areanames{zh}->{861315303} = "山东省济南市";
$areanames{zh}->{861315304} = "山东省济南市";
$areanames{zh}->{861315305} = "山东省枣庄市";
$areanames{zh}->{861315306} = "山东省枣庄市";
$areanames{zh}->{861315307} = "山东省菏泽市";
$areanames{zh}->{861315308} = "山东省菏泽市";
$areanames{zh}->{861315309} = "山东省菏泽市";
$areanames{zh}->{86131531} = "山东省济南市";
$areanames{zh}->{86131532} = "山东省青岛市";
$areanames{zh}->{861315330} = "山东省威海市";
$areanames{zh}->{861315331} = "山东省威海市";
$areanames{zh}->{861315332} = "山东省枣庄市";
$areanames{zh}->{861315333} = "山东省日照市";
$areanames{zh}->{861315334} = "山东省日照市";
$areanames{zh}->{861315335} = "山东省淄博市";
$areanames{zh}->{861315336} = "山东省淄博市";
$areanames{zh}->{861315337} = "山东省淄博市";
$areanames{zh}->{861315338} = "山东省淄博市";
$areanames{zh}->{861315339} = "山东省淄博市";
$areanames{zh}->{861315340} = "山东省威海市";
$areanames{zh}->{861315341} = "山东省东营市";
$areanames{zh}->{861315342} = "山东省滨州市";
$areanames{zh}->{861315343} = "山东省枣庄市";
$areanames{zh}->{861315344} = "山东省枣庄市";
$areanames{zh}->{861315345} = "山东省德州市";
$areanames{zh}->{861315346} = "山东省德州市";
$areanames{zh}->{861315347} = "山东省德州市";
$areanames{zh}->{861315348} = "山东省德州市";
$areanames{zh}->{861315349} = "山东省德州市";
$areanames{zh}->{861315350} = "山东省烟台市";
$areanames{zh}->{861315351} = "山东省烟台市";
$areanames{zh}->{861315352} = "山东省烟台市";
$areanames{zh}->{861315353} = "山东省烟台市";
$areanames{zh}->{861315354} = "山东省烟台市";
$areanames{zh}->{861315355} = "山东省东营市";
$areanames{zh}->{861315356} = "山东省东营市";
$areanames{zh}->{861315357} = "山东省威海市";
$areanames{zh}->{861315358} = "山东省滨州市";
$areanames{zh}->{861315359} = "山东省滨州市";
$areanames{zh}->{86131536} = "山东省潍坊市";
$areanames{zh}->{86131537} = "山东省济宁市";
$areanames{zh}->{86131538} = "山东省泰安市";
$areanames{zh}->{861315380} = "山东省聊城市";
$areanames{zh}->{861315381} = "山东省聊城市";
$areanames{zh}->{861315382} = "山东省聊城市";
$areanames{zh}->{861315383} = "山东省莱芜市";
$areanames{zh}->{86131539} = "山东省临沂市";
$areanames{zh}->{861315400} = "陕西省榆林市";
$areanames{zh}->{861315401} = "陕西省榆林市";
$areanames{zh}->{861315402} = "陕西省榆林市";
$areanames{zh}->{861315403} = "陕西省安康市";
$areanames{zh}->{861315404} = "陕西省安康市";
$areanames{zh}->{861315405} = "陕西省安康市";
$areanames{zh}->{861315406} = "陕西省商洛市";
$areanames{zh}->{861315407} = "陕西省商洛市";
$areanames{zh}->{861315408} = "陕西省铜川市";
$areanames{zh}->{861315409} = "陕西省铜川市";
$areanames{zh}->{861315410} = "辽宁省铁岭市";
$areanames{zh}->{861315411} = "辽宁省大连市";
$areanames{zh}->{861315412} = "辽宁省鞍山市";
$areanames{zh}->{861315413} = "辽宁省抚顺市";
$areanames{zh}->{861315414} = "辽宁省本溪市";
$areanames{zh}->{861315415} = "辽宁省丹东市";
$areanames{zh}->{861315416} = "辽宁省锦州市";
$areanames{zh}->{861315417} = "辽宁省营口市";
$areanames{zh}->{861315418} = "辽宁省阜新市";
$areanames{zh}->{861315419} = "辽宁省辽阳市";
$areanames{zh}->{861315420} = "辽宁省铁岭市";
$areanames{zh}->{861315421} = "辽宁省朝阳市";
$areanames{zh}->{861315422} = "辽宁省朝阳市";
$areanames{zh}->{861315423} = "辽宁省抚顺市";
$areanames{zh}->{861315424} = "辽宁省锦州市";
$areanames{zh}->{861315425} = "辽宁省鞍山市";
$areanames{zh}->{861315426} = "辽宁省大连市";
$areanames{zh}->{861315427} = "辽宁省盘锦市";
$areanames{zh}->{861315428} = "辽宁省盘锦市";
$areanames{zh}->{861315429} = "辽宁省葫芦岛市";
$areanames{zh}->{86131543} = "吉林省长春市";
$areanames{zh}->{861315432} = "吉林省吉林市";
$areanames{zh}->{861315433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861315434} = "吉林省四平市";
$areanames{zh}->{861315438} = "吉林省松原市";
$areanames{zh}->{861315440} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861315441} = "四川省甘孜藏族自治州";
$areanames{zh}->{861315442} = "四川省广元市";
$areanames{zh}->{861315443} = "四川省广元市";
$areanames{zh}->{861315444} = "四川省绵阳市";
$areanames{zh}->{861315445} = "四川省绵阳市";
$areanames{zh}->{861315446} = "四川省绵阳市";
$areanames{zh}->{861315447} = "四川省德阳市";
$areanames{zh}->{861315448} = "四川省德阳市";
$areanames{zh}->{861315449} = "四川省德阳市";
$areanames{zh}->{861315450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861315453} = "黑龙江省牡丹江市";
$areanames{zh}->{861315454} = "黑龙江省佳木斯市";
$areanames{zh}->{861315455} = "黑龙江省绥化市";
$areanames{zh}->{861315456} = "黑龙江省黑河市";
$areanames{zh}->{861315457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861315458} = "黑龙江省伊春市";
$areanames{zh}->{861315459} = "黑龙江省大庆市";
$areanames{zh}->{861315460} = "四川省泸州市";
$areanames{zh}->{861315461} = "四川省资阳市";
$areanames{zh}->{861315462} = "四川省资阳市";
$areanames{zh}->{861315463} = "四川省自贡市";
$areanames{zh}->{861315464} = "四川省自贡市";
$areanames{zh}->{861315465} = "四川省自贡市";
$areanames{zh}->{861315466} = "四川省自贡市";
$areanames{zh}->{861315467} = "四川省自贡市";
$areanames{zh}->{861315468} = "四川省内江市";
$areanames{zh}->{861315469} = "四川省宜宾市";
$areanames{zh}->{861315470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861315471} = "内蒙古呼和浩特市";
$areanames{zh}->{861315472} = "内蒙古包头市";
$areanames{zh}->{861315473} = "内蒙古乌海市";
$areanames{zh}->{861315474} = "内蒙古乌兰察布市";
$areanames{zh}->{861315475} = "内蒙古通辽市";
$areanames{zh}->{861315476} = "内蒙古赤峰市";
$areanames{zh}->{861315477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861315478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861315479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861315480} = "内蒙古呼和浩特市";
$areanames{zh}->{861315481} = "内蒙古呼和浩特市";
$areanames{zh}->{861315482} = "内蒙古兴安盟";
$areanames{zh}->{861315483} = "内蒙古阿拉善盟";
$areanames{zh}->{861315484} = "内蒙古赤峰市";
$areanames{zh}->{861315485} = "内蒙古赤峰市";
$areanames{zh}->{861315486} = "内蒙古赤峰市";
$areanames{zh}->{861315487} = "内蒙古呼和浩特市";
$areanames{zh}->{861315488} = "内蒙古呼和浩特市";
$areanames{zh}->{861315489} = "内蒙古通辽市";
$areanames{zh}->{861315490} = "四川省攀枝花市";
$areanames{zh}->{861315491} = "四川省攀枝花市";
$areanames{zh}->{861315492} = "四川省凉山彝族自治州";
$areanames{zh}->{861315493} = "陕西省安康市";
$areanames{zh}->{861315494} = "四川省眉山市";
$areanames{zh}->{861315495} = "四川省眉山市";
$areanames{zh}->{861315496} = "四川省眉山市";
$areanames{zh}->{861315497} = "四川省乐山市";
$areanames{zh}->{861315498} = "四川省乐山市";
$areanames{zh}->{861315499} = "四川省乐山市";
$areanames{zh}->{86131550} = "安徽省滁州市";
$areanames{zh}->{86131551} = "安徽省合肥市";
$areanames{zh}->{86131552} = "安徽省蚌埠市";
$areanames{zh}->{861315530} = "安徽省芜湖市";
$areanames{zh}->{861315531} = "安徽省芜湖市";
$areanames{zh}->{861315532} = "安徽省芜湖市";
$areanames{zh}->{861315533} = "安徽省芜湖市";
$areanames{zh}->{861315534} = "安徽省芜湖市";
$areanames{zh}->{861315535} = "安徽省马鞍山市";
$areanames{zh}->{861315536} = "安徽省马鞍山市";
$areanames{zh}->{861315537} = "安徽省宣城市";
$areanames{zh}->{861315538} = "安徽省六安市";
$areanames{zh}->{861315539} = "安徽省六安市";
$areanames{zh}->{86131554} = "安徽省淮南市";
$areanames{zh}->{86131555} = "安徽省马鞍山市";
$areanames{zh}->{861315556} = "安徽省安庆市";
$areanames{zh}->{861315557} = "安徽省宿州市";
$areanames{zh}->{861315558} = "安徽省阜阳市";
$areanames{zh}->{861315559} = "安徽省黄山市";
$areanames{zh}->{861315560} = "安徽省安庆市";
$areanames{zh}->{861315561} = "安徽省淮北市";
$areanames{zh}->{861315562} = "安徽省铜陵市";
$areanames{zh}->{861315563} = "安徽省宣城市";
$areanames{zh}->{861315564} = "安徽省六安市";
$areanames{zh}->{861315565} = "安徽省合肥市";
$areanames{zh}->{861315566} = "安徽省池州市";
$areanames{zh}->{861315567} = "安徽省亳州市";
$areanames{zh}->{861315568} = "安徽省亳州市";
$areanames{zh}->{861315569} = "安徽省安庆市";
$areanames{zh}->{861315570} = "江西省九江市";
$areanames{zh}->{861315571} = "江西省九江市";
$areanames{zh}->{861315572} = "江西省九江市";
$areanames{zh}->{861315573} = "江西省九江市";
$areanames{zh}->{861315574} = "江西省景德镇市";
$areanames{zh}->{861315575} = "江西省景德镇市";
$areanames{zh}->{861315576} = "江西省景德镇市";
$areanames{zh}->{861315577} = "江西省景德镇市";
$areanames{zh}->{861315578} = "江西省景德镇市";
$areanames{zh}->{861315579} = "江西省赣州市";
$areanames{zh}->{861315580} = "江西省南昌市";
$areanames{zh}->{861315581} = "江西省南昌市";
$areanames{zh}->{861315582} = "江西省南昌市";
$areanames{zh}->{861315583} = "江西省南昌市";
$areanames{zh}->{861315584} = "江西省吉安市";
$areanames{zh}->{861315585} = "江西省吉安市";
$areanames{zh}->{861315586} = "江西省吉安市";
$areanames{zh}->{861315587} = "江西省抚州市";
$areanames{zh}->{861315588} = "江西省抚州市";
$areanames{zh}->{861315589} = "江西省抚州市";
$areanames{zh}->{861315590} = "江西省上饶市";
$areanames{zh}->{861315591} = "江西省上饶市";
$areanames{zh}->{861315592} = "江西省上饶市";
$areanames{zh}->{861315593} = "江西省上饶市";
$areanames{zh}->{861315594} = "江西省萍乡市";
$areanames{zh}->{861315595} = "江西省萍乡市";
$areanames{zh}->{861315596} = "江西省萍乡市";
$areanames{zh}->{861315597} = "江西省萍乡市";
$areanames{zh}->{861315598} = "江西省九江市";
$areanames{zh}->{861315599} = "江西省赣州市";
$areanames{zh}->{861315600} = "山东省济南市";
$areanames{zh}->{861315601} = "山东省济南市";
$areanames{zh}->{861315602} = "山东省枣庄市";
$areanames{zh}->{861315603} = "山东省青岛市";
$areanames{zh}->{861315604} = "山东省青岛市";
$areanames{zh}->{861315605} = "山东省青岛市";
$areanames{zh}->{861315606} = "山东省东营市";
$areanames{zh}->{861315607} = "山东省东营市";
$areanames{zh}->{861315608} = "山东省威海市";
$areanames{zh}->{861315609} = "山东省威海市";
$areanames{zh}->{86131561} = "山东省济南市";
$areanames{zh}->{86131562} = "山东省青岛市";
$areanames{zh}->{861315630} = "山东省威海市";
$areanames{zh}->{861315631} = "山东省威海市";
$areanames{zh}->{861315632} = "山东省枣庄市";
$areanames{zh}->{861315633} = "山东省日照市";
$areanames{zh}->{861315634} = "山东省莱芜市";
$areanames{zh}->{861315635} = "山东省聊城市";
$areanames{zh}->{861315636} = "山东省青岛市";
$areanames{zh}->{861315637} = "山东省青岛市";
$areanames{zh}->{861315638} = "山东省青岛市";
$areanames{zh}->{861315639} = "山东省青岛市";
$areanames{zh}->{861315640} = "山东省济南市";
$areanames{zh}->{861315641} = "山东省济南市";
$areanames{zh}->{861315642} = "山东省青岛市";
$areanames{zh}->{861315643} = "山东省淄博市";
$areanames{zh}->{861315644} = "山东省济南市";
$areanames{zh}->{861315645} = "山东省烟台市";
$areanames{zh}->{861315646} = "山东省潍坊市";
$areanames{zh}->{861315647} = "山东省东营市";
$areanames{zh}->{861315648} = "山东省青岛市";
$areanames{zh}->{861315649} = "山东省滨州市";
$areanames{zh}->{86131565} = "安徽省合肥市";
$areanames{zh}->{86131566} = "安徽省池州市";
$areanames{zh}->{86131567} = "安徽省亳州市";
$areanames{zh}->{861315680} = "山东省东营市";
$areanames{zh}->{861315681} = "山东省东营市";
$areanames{zh}->{861315682} = "山东省枣庄市";
$areanames{zh}->{861315683} = "山东省滨州市";
$areanames{zh}->{861315684} = "山东省菏泽市";
$areanames{zh}->{861315685} = "山东省青岛市";
$areanames{zh}->{861315686} = "山东省青岛市";
$areanames{zh}->{861315687} = "山东省青岛市";
$areanames{zh}->{861315688} = "山东省青岛市";
$areanames{zh}->{861315689} = "山东省青岛市";
$areanames{zh}->{86131569} = "山东省烟台市";
$areanames{zh}->{861315696} = "山东省潍坊市";
$areanames{zh}->{861315697} = "山东省泰安市";
$areanames{zh}->{861315698} = "山东省淄博市";
$areanames{zh}->{861315699} = "山东省日照市";
$areanames{zh}->{86131570} = "浙江省衢州市";
$areanames{zh}->{86131571} = "浙江省杭州市";
$areanames{zh}->{86131572} = "浙江省湖州市";
$areanames{zh}->{86131573} = "浙江省嘉兴市";
$areanames{zh}->{86131574} = "浙江省宁波市";
$areanames{zh}->{86131575} = "浙江省绍兴市";
$areanames{zh}->{86131576} = "浙江省台州市";
$areanames{zh}->{86131577} = "浙江省温州市";
$areanames{zh}->{86131578} = "浙江省丽水市";
$areanames{zh}->{86131579} = "浙江省金华市";
$areanames{zh}->{86131580} = "贵州省贵阳市";
$areanames{zh}->{861315810} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861315811} = "贵州省遵义市";
$areanames{zh}->{861315812} = "贵州省遵义市";
$areanames{zh}->{861315813} = "贵州省安顺市";
$areanames{zh}->{861315814} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861315815} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861315816} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861315817} = "贵州省六盘水市";
$areanames{zh}->{861315818} = "贵州省六盘水市";
$areanames{zh}->{861315819} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861315820} = "贵州省遵义市";
$areanames{zh}->{861315821} = "贵州省遵义市";
$areanames{zh}->{861315822} = "贵州省遵义市";
$areanames{zh}->{861315823} = "贵州省安顺市";
$areanames{zh}->{861315824} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861315825} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861315826} = "贵州省铜仁地区";
$areanames{zh}->{861315827} = "贵州省毕节地区";
$areanames{zh}->{861315828} = "贵州省六盘水市";
$areanames{zh}->{861315829} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861315830} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861315831} = "贵州省安顺市";
$areanames{zh}->{861315832} = "贵州省遵义市";
$areanames{zh}->{861315833} = "贵州省安顺市";
$areanames{zh}->{861315834} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861315835} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861315836} = "贵州省铜仁地区";
$areanames{zh}->{861315837} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861315838} = "贵州省六盘水市";
$areanames{zh}->{861315839} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861315840} = "四川省甘孜藏族自治州";
$areanames{zh}->{861315841} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861315842} = "四川省达州市";
$areanames{zh}->{861315843} = "四川省巴中市";
$areanames{zh}->{861315844} = "四川省德阳市";
$areanames{zh}->{861315845} = "四川省绵阳市";
$areanames{zh}->{861315846} = "四川省广安市";
$areanames{zh}->{861315847} = "四川省凉山彝族自治州";
$areanames{zh}->{861315848} = "四川省遂宁市";
$areanames{zh}->{861315849} = "四川省资阳市";
$areanames{zh}->{861315850} = "四川省南充市";
$areanames{zh}->{861315851} = "四川省南充市";
$areanames{zh}->{861315852} = "四川省南充市";
$areanames{zh}->{861315853} = "四川省雅安市";
$areanames{zh}->{861315854} = "四川省雅安市";
$areanames{zh}->{861315855} = "四川省凉山彝族自治州";
$areanames{zh}->{861315856} = "四川省攀枝花市";
$areanames{zh}->{861315857} = "四川省内江市";
$areanames{zh}->{861315858} = "四川省内江市";
$areanames{zh}->{861315859} = "四川省内江市";
$areanames{zh}->{861315860} = "四川省泸州市";
$areanames{zh}->{861315861} = "四川省泸州市";
$areanames{zh}->{861315862} = "四川省泸州市";
$areanames{zh}->{861315863} = "四川省宜宾市";
$areanames{zh}->{861315864} = "四川省宜宾市";
$areanames{zh}->{861315865} = "四川省宜宾市";
$areanames{zh}->{861315866} = "四川省德阳市";
$areanames{zh}->{861315867} = "四川省德阳市";
$areanames{zh}->{861315868} = "四川省德阳市";
$areanames{zh}->{861315869} = "四川省德阳市";
$areanames{zh}->{861315870} = "四川省达州市";
$areanames{zh}->{861315871} = "四川省巴中市";
$areanames{zh}->{861315872} = "四川省广安市";
$areanames{zh}->{861315873} = "四川省遂宁市";
$areanames{zh}->{861315874} = "四川省广元市";
$areanames{zh}->{861315875} = "四川省广元市";
$areanames{zh}->{861315876} = "四川省眉山市";
$areanames{zh}->{861315877} = "四川省眉山市";
$areanames{zh}->{861315878} = "四川省资阳市";
$areanames{zh}->{861315879} = "四川省攀枝花市";
$areanames{zh}->{861315880} = "四川省自贡市";
$areanames{zh}->{861315881} = "四川省自贡市";
$areanames{zh}->{861315882} = "四川省自贡市";
$areanames{zh}->{861315883} = "四川省乐山市";
$areanames{zh}->{861315884} = "四川省乐山市";
$areanames{zh}->{861315885} = "四川省乐山市";
$areanames{zh}->{861315886} = "四川省绵阳市";
$areanames{zh}->{861315887} = "四川省绵阳市";
$areanames{zh}->{861315888} = "四川省绵阳市";
$areanames{zh}->{861315889} = "四川省绵阳市";
$areanames{zh}->{86131589} = "海南省海口市";
$areanames{zh}->{86131590} = "福建省泉州市";
$areanames{zh}->{86131591} = "福建省漳州市";
$areanames{zh}->{86131592} = "福建省厦门市";
$areanames{zh}->{861315924} = "福建省三明市";
$areanames{zh}->{861315928} = "福建省南平市";
$areanames{zh}->{861315929} = "福建省南平市";
$areanames{zh}->{861315930} = "福建省龙岩市";
$areanames{zh}->{861315931} = "福建省龙岩市";
$areanames{zh}->{861315932} = "福建省龙岩市";
$areanames{zh}->{861315933} = "福建省莆田市";
$areanames{zh}->{861315934} = "福建省宁德市";
$areanames{zh}->{861315935} = "福建省宁德市";
$areanames{zh}->{861315936} = "福建省三明市";
$areanames{zh}->{861315937} = "福建省三明市";
$areanames{zh}->{861315938} = "福建省三明市";
$areanames{zh}->{861315939} = "福建省三明市";
$areanames{zh}->{861315940} = "福建省福州市";
$areanames{zh}->{861315941} = "福建省福州市";
$areanames{zh}->{861315942} = "福建省福州市";
$areanames{zh}->{861315943} = "福建省福州市";
$areanames{zh}->{861315944} = "福建省莆田市";
$areanames{zh}->{861315945} = "福建省莆田市";
$areanames{zh}->{861315946} = "福建省漳州市";
$areanames{zh}->{861315947} = "福建省漳州市";
$areanames{zh}->{861315948} = "福建省漳州市";
$areanames{zh}->{861315949} = "福建省漳州市";
$areanames{zh}->{861315950} = "吉林省长春市";
$areanames{zh}->{861315951} = "吉林省长春市";
$areanames{zh}->{861315952} = "吉林省长春市";
$areanames{zh}->{861315953} = "吉林省长春市";
$areanames{zh}->{861315954} = "吉林省吉林市";
$areanames{zh}->{861315955} = "吉林省吉林市";
$areanames{zh}->{861315956} = "吉林省长春市";
$areanames{zh}->{861315957} = "吉林省吉林市";
$areanames{zh}->{861315958} = "吉林省松原市";
$areanames{zh}->{861315959} = "吉林省白城市";
$areanames{zh}->{861315960} = "吉林省长春市";
$areanames{zh}->{861315961} = "吉林省长春市";
$areanames{zh}->{861315962} = "吉林省四平市";
$areanames{zh}->{861315963} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861315964} = "吉林省长春市";
$areanames{zh}->{861315965} = "吉林省通化市";
$areanames{zh}->{861315966} = "吉林省吉林市";
$areanames{zh}->{861315967} = "吉林省松原市";
$areanames{zh}->{861315968} = "吉林省长春市";
$areanames{zh}->{861315969} = "吉林省白山市";
$areanames{zh}->{861315970} = "吉林省吉林市";
$areanames{zh}->{861315971} = "吉林省松原市";
$areanames{zh}->{861315972} = "吉林省通化市";
$areanames{zh}->{861315973} = "吉林省通化市";
$areanames{zh}->{861315974} = "吉林省长春市";
$areanames{zh}->{861315975} = "吉林省长春市";
$areanames{zh}->{861315976} = "吉林省白城市";
$areanames{zh}->{861315977} = "吉林省长春市";
$areanames{zh}->{861315978} = "吉林省四平市";
$areanames{zh}->{861315979} = "吉林省白山市";
$areanames{zh}->{861315980} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315981} = "黑龙江省大庆市";
$areanames{zh}->{861315982} = "黑龙江省大庆市";
$areanames{zh}->{861315983} = "黑龙江省大庆市";
$areanames{zh}->{861315984} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315985} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315986} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315987} = "黑龙江省哈尔滨市";
$areanames{zh}->{861315988} = "黑龙江省鹤岗市";
$areanames{zh}->{861315989} = "黑龙江省鸡西市";
$areanames{zh}->{861315990} = "黑龙江省双鸭山市";
$areanames{zh}->{861315991} = "黑龙江省双鸭山市";
$areanames{zh}->{861315992} = "黑龙江省鹤岗市";
$areanames{zh}->{861315993} = "黑龙江省鹤岗市";
$areanames{zh}->{861315994} = "黑龙江省大庆市";
$areanames{zh}->{861315995} = "黑龙江省鸡西市";
$areanames{zh}->{861315996} = "黑龙江省七台河市";
$areanames{zh}->{861315997} = "黑龙江省佳木斯市";
$areanames{zh}->{861315998} = "黑龙江省佳木斯市";
$areanames{zh}->{861315999} = "黑龙江省大庆市";
$areanames{zh}->{86131600} = "江苏省南京市";
$areanames{zh}->{861316000} = "江苏省淮安市";
$areanames{zh}->{861316001} = "江苏省淮安市";
$areanames{zh}->{86131601} = "江苏省苏州市";
$areanames{zh}->{861316017} = "江苏省盐城市";
$areanames{zh}->{861316018} = "江苏省盐城市";
$areanames{zh}->{861316019} = "江苏省盐城市";
$areanames{zh}->{86131602} = "江苏省徐州市";
$areanames{zh}->{861316020} = "江苏省镇江市";
$areanames{zh}->{861316021} = "江苏省镇江市";
$areanames{zh}->{861316022} = "江苏省镇江市";
$areanames{zh}->{861316030} = "江苏省扬州市";
$areanames{zh}->{861316031} = "江苏省扬州市";
$areanames{zh}->{861316032} = "江苏省扬州市";
$areanames{zh}->{861316033} = "江苏省宿迁市";
$areanames{zh}->{861316034} = "江苏省宿迁市";
$areanames{zh}->{861316035} = "江苏省宿迁市";
$areanames{zh}->{861316036} = "江苏省南通市";
$areanames{zh}->{861316037} = "江苏省南通市";
$areanames{zh}->{861316038} = "江苏省南通市";
$areanames{zh}->{861316039} = "江苏省南通市";
$areanames{zh}->{861316040} = "江苏省扬州市";
$areanames{zh}->{861316041} = "江苏省扬州市";
$areanames{zh}->{861316042} = "江苏省苏州市";
$areanames{zh}->{861316043} = "江苏省苏州市";
$areanames{zh}->{861316044} = "江苏省盐城市";
$areanames{zh}->{861316045} = "江苏省盐城市";
$areanames{zh}->{861316046} = "江苏省南京市";
$areanames{zh}->{861316047} = "江苏省南京市";
$areanames{zh}->{861316048} = "江苏省徐州市";
$areanames{zh}->{861316049} = "江苏省南通市";
$areanames{zh}->{861316050} = "广东省阳江市";
$areanames{zh}->{861316051} = "广东省阳江市";
$areanames{zh}->{861316052} = "广东省阳江市";
$areanames{zh}->{861316053} = "广东省阳江市";
$areanames{zh}->{861316054} = "广东省阳江市";
$areanames{zh}->{861316055} = "广东省清远市";
$areanames{zh}->{861316056} = "广东省清远市";
$areanames{zh}->{861316057} = "广东省清远市";
$areanames{zh}->{861316058} = "广东省清远市";
$areanames{zh}->{861316059} = "广东省清远市";
$areanames{zh}->{86131606} = "广东省珠海市";
$areanames{zh}->{861316060} = "广东省潮州市";
$areanames{zh}->{861316061} = "广东省潮州市";
$areanames{zh}->{861316062} = "广东省潮州市";
$areanames{zh}->{861316063} = "广东省潮州市";
$areanames{zh}->{86131607} = "广东省惠州市";
$areanames{zh}->{86131608} = "广东省广州市";
$areanames{zh}->{86131609} = "广东省佛山市";
$areanames{zh}->{8613161} = "北京市";
$areanames{zh}->{8613162} = "上海市";
$areanames{zh}->{86131630} = "天津市";
$areanames{zh}->{86131631} = "天津市";
$areanames{zh}->{86131632} = "湖北省武汉市";
$areanames{zh}->{86131633} = "湖北省武汉市";
$areanames{zh}->{861316340} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861316341} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316342} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316343} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316344} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316345} = "黑龙江省双鸭山市";
$areanames{zh}->{861316346} = "黑龙江省鹤岗市";
$areanames{zh}->{861316347} = "黑龙江省绥化市";
$areanames{zh}->{861316348} = "黑龙江省绥化市";
$areanames{zh}->{861316349} = "黑龙江省佳木斯市";
$areanames{zh}->{861316350} = "黑龙江省佳木斯市";
$areanames{zh}->{861316351} = "黑龙江省佳木斯市";
$areanames{zh}->{861316352} = "黑龙江省大庆市";
$areanames{zh}->{861316353} = "黑龙江省大庆市";
$areanames{zh}->{861316354} = "黑龙江省大庆市";
$areanames{zh}->{861316355} = "黑龙江省大庆市";
$areanames{zh}->{861316356} = "黑龙江省鸡西市";
$areanames{zh}->{861316357} = "黑龙江省绥化市";
$areanames{zh}->{861316358} = "黑龙江省绥化市";
$areanames{zh}->{861316359} = "黑龙江省绥化市";
$areanames{zh}->{861316360} = "黑龙江省牡丹江市";
$areanames{zh}->{861316361} = "黑龙江省牡丹江市";
$areanames{zh}->{861316362} = "黑龙江省牡丹江市";
$areanames{zh}->{861316363} = "黑龙江省绥化市";
$areanames{zh}->{861316364} = "黑龙江省绥化市";
$areanames{zh}->{861316365} = "黑龙江省绥化市";
$areanames{zh}->{861316366} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316367} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316368} = "黑龙江省哈尔滨市";
$areanames{zh}->{861316369} = "黑龙江省哈尔滨市";
$areanames{zh}->{86131637} = "广东省深圳市";
$areanames{zh}->{861316380} = "福建省南平市";
$areanames{zh}->{861316381} = "福建省龙岩市";
$areanames{zh}->{861316382} = "福建省三明市";
$areanames{zh}->{861316383} = "福建省宁德市";
$areanames{zh}->{861316384} = "河南省三门峡市";
$areanames{zh}->{861316385} = "福建省宁德市";
$areanames{zh}->{861316386} = "福建省莆田市";
$areanames{zh}->{861316387} = "福建省福州市";
$areanames{zh}->{861316388} = "福建省福州市";
$areanames{zh}->{861316389} = "福建省福州市";
$areanames{zh}->{86131639} = "福建省泉州市";
$areanames{zh}->{861316390} = "福建省厦门市";
$areanames{zh}->{861316397} = "福建省漳州市";
$areanames{zh}->{861316398} = "福建省漳州市";
$areanames{zh}->{861316399} = "福建省厦门市";
$areanames{zh}->{86131640} = "天津市";
$areanames{zh}->{86131641} = "湖北省武汉市";
$areanames{zh}->{86131642} = "北京市";
$areanames{zh}->{86131643} = "河南省郑州市";
$areanames{zh}->{86131644} = "重庆市";
$areanames{zh}->{86131645} = "辽宁省大连市";
$areanames{zh}->{86131646} = "湖北省武汉市";
$areanames{zh}->{86131647} = "广东省深圳市";
$areanames{zh}->{861316480} = "福建省福州市";
$areanames{zh}->{861316481} = "福建省福州市";
$areanames{zh}->{861316482} = "福建省福州市";
$areanames{zh}->{861316483} = "福建省漳州市";
$areanames{zh}->{861316484} = "福建省漳州市";
$areanames{zh}->{861316485} = "福建省莆田市";
$areanames{zh}->{861316486} = "福建省莆田市";
$areanames{zh}->{861316487} = "福建省厦门市";
$areanames{zh}->{861316488} = "福建省厦门市";
$areanames{zh}->{861316489} = "福建省厦门市";
$areanames{zh}->{861316490} = "浙江省温州市";
$areanames{zh}->{861316491} = "浙江省温州市";
$areanames{zh}->{861316492} = "浙江省温州市";
$areanames{zh}->{861316493} = "浙江省嘉兴市";
$areanames{zh}->{861316494} = "浙江省杭州市";
$areanames{zh}->{861316495} = "浙江省杭州市";
$areanames{zh}->{861316496} = "浙江省宁波市";
$areanames{zh}->{861316497} = "浙江省宁波市";
$areanames{zh}->{861316498} = "浙江省宁波市";
$areanames{zh}->{861316499} = "浙江省宁波市";
$areanames{zh}->{86131650} = "山东省青岛市";
$areanames{zh}->{861316510} = "山东省济南市";
$areanames{zh}->{861316511} = "山东省济南市";
$areanames{zh}->{861316512} = "山东省济南市";
$areanames{zh}->{861316513} = "山东省济南市";
$areanames{zh}->{861316514} = "山东省济南市";
$areanames{zh}->{861316515} = "山东省青岛市";
$areanames{zh}->{861316516} = "山东省青岛市";
$areanames{zh}->{861316517} = "山东省济宁市";
$areanames{zh}->{861316518} = "山东省济宁市";
$areanames{zh}->{861316519} = "山东省济宁市";
$areanames{zh}->{861316520} = "山东省日照市";
$areanames{zh}->{861316521} = "山东省枣庄市";
$areanames{zh}->{861316522} = "山东省枣庄市";
$areanames{zh}->{861316523} = "山东省德州市";
$areanames{zh}->{861316524} = "山东省德州市";
$areanames{zh}->{861316525} = "山东省东营市";
$areanames{zh}->{861316526} = "山东省潍坊市";
$areanames{zh}->{861316527} = "山东省临沂市";
$areanames{zh}->{861316528} = "山东省临沂市";
$areanames{zh}->{861316529} = "山东省临沂市";
$areanames{zh}->{861316530} = "山东省菏泽市";
$areanames{zh}->{861316531} = "山东省济南市";
$areanames{zh}->{861316532} = "山东省青岛市";
$areanames{zh}->{861316533} = "山东省淄博市";
$areanames{zh}->{861316534} = "山东省德州市";
$areanames{zh}->{861316535} = "山东省烟台市";
$areanames{zh}->{861316536} = "山东省潍坊市";
$areanames{zh}->{861316537} = "山东省济宁市";
$areanames{zh}->{861316538} = "山东省泰安市";
$areanames{zh}->{861316539} = "山东省临沂市";
$areanames{zh}->{861316540} = "山东省聊城市";
$areanames{zh}->{861316541} = "山东省济南市";
$areanames{zh}->{861316542} = "山东省青岛市";
$areanames{zh}->{861316543} = "山东省滨州市";
$areanames{zh}->{861316544} = "山东省淄博市";
$areanames{zh}->{861316545} = "山东省烟台市";
$areanames{zh}->{861316546} = "山东省东营市";
$areanames{zh}->{861316547} = "山东省济宁市";
$areanames{zh}->{861316548} = "山东省淄博市";
$areanames{zh}->{861316549} = "山东省临沂市";
$areanames{zh}->{861316550} = "河北省邯郸市";
$areanames{zh}->{861316551} = "河北省邯郸市";
$areanames{zh}->{861316552} = "河北省承德市";
$areanames{zh}->{861316553} = "河北省张家口市";
$areanames{zh}->{861316554} = "河北省石家庄市";
$areanames{zh}->{861316555} = "河北省衡水市";
$areanames{zh}->{861316556} = "河北省秦皇岛市";
$areanames{zh}->{861316557} = "河北省保定市";
$areanames{zh}->{861316558} = "河北省石家庄市";
$areanames{zh}->{861316559} = "河北省保定市";
$areanames{zh}->{861316560} = "湖北省荆州市";
$areanames{zh}->{861316561} = "湖北省宜昌市";
$areanames{zh}->{861316562} = "湖北省荆门市";
$areanames{zh}->{861316563} = "湖北省十堰市";
$areanames{zh}->{861316564} = "湖北省襄樊市";
$areanames{zh}->{861316565} = "湖北省黄冈市";
$areanames{zh}->{861316566} = "湖北省孝感市";
$areanames{zh}->{861316567} = "湖北省黄石市";
$areanames{zh}->{861316568} = "湖北省黄石市";
$areanames{zh}->{861316569} = "湖北省咸宁市";
$areanames{zh}->{86131657} = "陕西省西安市";
$areanames{zh}->{861316570} = "陕西省榆林市";
$areanames{zh}->{861316576} = "陕西省安康市";
$areanames{zh}->{861316577} = "陕西省商洛市";
$areanames{zh}->{86131658} = "浙江省温州市";
$areanames{zh}->{861316580} = "浙江省金华市";
$areanames{zh}->{861316581} = "浙江省嘉兴市";
$areanames{zh}->{861316582} = "浙江省嘉兴市";
$areanames{zh}->{861316590} = "浙江省宁波市";
$areanames{zh}->{861316591} = "浙江省宁波市";
$areanames{zh}->{861316592} = "浙江省宁波市";
$areanames{zh}->{861316593} = "浙江省宁波市";
$areanames{zh}->{861316594} = "浙江省宁波市";
$areanames{zh}->{861316595} = "浙江省杭州市";
$areanames{zh}->{861316596} = "浙江省杭州市";
$areanames{zh}->{861316597} = "浙江省杭州市";
$areanames{zh}->{861316598} = "浙江省杭州市";
$areanames{zh}->{861316599} = "浙江省杭州市";
$areanames{zh}->{86131660} = "上海市";
$areanames{zh}->{86131661} = "上海市";
$areanames{zh}->{86131662} = "上海市";
$areanames{zh}->{86131663} = "上海市";
$areanames{zh}->{86131664} = "上海市";
$areanames{zh}->{861316650} = "河北省承德市";
$areanames{zh}->{861316651} = "河北省秦皇岛市";
$areanames{zh}->{861316652} = "河北省廊坊市";
$areanames{zh}->{861316653} = "河北省廊坊市";
$areanames{zh}->{861316654} = "河北省唐山市";
$areanames{zh}->{861316655} = "河北省张家口市";
$areanames{zh}->{861316656} = "河北省沧州市";
$areanames{zh}->{861316657} = "河北省衡水市";
$areanames{zh}->{861316658} = "河北省唐山市";
$areanames{zh}->{861316659} = "河北省邢台市";
$areanames{zh}->{86131666} = "辽宁省沈阳市";
$areanames{zh}->{86131667} = "辽宁省沈阳市";
$areanames{zh}->{86131668} = "吉林省长春市";
$areanames{zh}->{86131669} = "吉林省吉林市";
$areanames{zh}->{86131670} = "上海市";
$areanames{zh}->{86131671} = "上海市";
$areanames{zh}->{86131672} = "上海市";
$areanames{zh}->{86131673} = "北京市";
$areanames{zh}->{861316740} = "湖南省株洲市";
$areanames{zh}->{861316741} = "湖南省株洲市";
$areanames{zh}->{861316742} = "湖南省株洲市";
$areanames{zh}->{861316743} = "湖南省株洲市";
$areanames{zh}->{861316744} = "湖南省株洲市";
$areanames{zh}->{861316745} = "江苏省南通市";
$areanames{zh}->{861316746} = "江苏省南通市";
$areanames{zh}->{861316747} = "江苏省南通市";
$areanames{zh}->{861316748} = "江苏省南通市";
$areanames{zh}->{861316749} = "江苏省南通市";
$areanames{zh}->{86131675} = "北京市";
$areanames{zh}->{861316760} = "安徽省池州市";
$areanames{zh}->{861316761} = "安徽省铜陵市";
$areanames{zh}->{861316762} = "安徽省滁州市";
$areanames{zh}->{861316763} = "安徽省芜湖市";
$areanames{zh}->{861316764} = "安徽省黄山市";
$areanames{zh}->{861316765} = "安徽省阜阳市";
$areanames{zh}->{861316766} = "安徽省阜阳市";
$areanames{zh}->{861316767} = "安徽省亳州市";
$areanames{zh}->{861316768} = "安徽省亳州市";
$areanames{zh}->{861316769} = "安徽省六安市";
$areanames{zh}->{861316770} = "安徽省安庆市";
$areanames{zh}->{861316771} = "安徽省安庆市";
$areanames{zh}->{861316772} = "安徽省合肥市";
$areanames{zh}->{861316773} = "安徽省合肥市";
$areanames{zh}->{861316774} = "安徽省合肥市";
$areanames{zh}->{861316775} = "安徽省宣城市";
$areanames{zh}->{861316776} = "安徽省宣城市";
$areanames{zh}->{861316777} = "安徽省宿州市";
$areanames{zh}->{861316778} = "安徽省六安市";
$areanames{zh}->{861316779} = "安徽省六安市";
$areanames{zh}->{86131678} = "重庆市";
$areanames{zh}->{86131679} = "重庆市";
$areanames{zh}->{86131680} = "广东省深圳市";
$areanames{zh}->{861316810} = "广东省梅州市";
$areanames{zh}->{861316811} = "广东省梅州市";
$areanames{zh}->{861316812} = "广东省湛江市";
$areanames{zh}->{861316813} = "广东省湛江市";
$areanames{zh}->{861316814} = "广东省韶关市";
$areanames{zh}->{861316815} = "广东省韶关市";
$areanames{zh}->{861316816} = "广东省云浮市";
$areanames{zh}->{861316817} = "广东省云浮市";
$areanames{zh}->{861316818} = "广东省阳江市";
$areanames{zh}->{861316819} = "广东省阳江市";
$areanames{zh}->{861316820} = "广东省汕尾市";
$areanames{zh}->{861316821} = "广东省汕尾市";
$areanames{zh}->{861316822} = "广东省汕尾市";
$areanames{zh}->{861316823} = "广东省汕尾市";
$areanames{zh}->{861316824} = "广东省汕头市";
$areanames{zh}->{861316825} = "广东省汕头市";
$areanames{zh}->{861316826} = "广东省潮州市";
$areanames{zh}->{861316827} = "广东省潮州市";
$areanames{zh}->{861316828} = "广东省河源市";
$areanames{zh}->{861316829} = "广东省河源市";
$areanames{zh}->{86131683} = "广东省广州市";
$areanames{zh}->{86131684} = "广东省东莞市";
$areanames{zh}->{86131685} = "广东省佛山市";
$areanames{zh}->{861316850} = "广东省江门市";
$areanames{zh}->{861316851} = "广东省江门市";
$areanames{zh}->{861316852} = "广东省江门市";
$areanames{zh}->{861316860} = "广东省惠州市";
$areanames{zh}->{861316861} = "广东省惠州市";
$areanames{zh}->{861316862} = "广东省惠州市";
$areanames{zh}->{861316863} = "广东省惠州市";
$areanames{zh}->{861316864} = "广东省惠州市";
$areanames{zh}->{861316865} = "广东省珠海市";
$areanames{zh}->{861316866} = "广东省珠海市";
$areanames{zh}->{861316867} = "广东省珠海市";
$areanames{zh}->{861316868} = "广东省珠海市";
$areanames{zh}->{861316869} = "广东省珠海市";
$areanames{zh}->{86131687} = "广东省深圳市";
$areanames{zh}->{86131688} = "广东省广州市";
$areanames{zh}->{86131689} = "广东省东莞市";
$areanames{zh}->{86131690} = "广东省汕头市";
$areanames{zh}->{861316904} = "广东省潮州市";
$areanames{zh}->{861316905} = "广东省潮州市";
$areanames{zh}->{861316906} = "广东省潮州市";
$areanames{zh}->{861316910} = "广东省湛江市";
$areanames{zh}->{861316911} = "广东省湛江市";
$areanames{zh}->{861316912} = "广东省湛江市";
$areanames{zh}->{861316913} = "广东省湛江市";
$areanames{zh}->{861316914} = "广东省阳江市";
$areanames{zh}->{861316915} = "广东省阳江市";
$areanames{zh}->{861316916} = "广东省茂名市";
$areanames{zh}->{861316917} = "广东省茂名市";
$areanames{zh}->{861316918} = "广东省茂名市";
$areanames{zh}->{861316919} = "广东省茂名市";
$areanames{zh}->{861316920} = "广东省梅州市";
$areanames{zh}->{861316921} = "广东省梅州市";
$areanames{zh}->{861316922} = "广东省梅州市";
$areanames{zh}->{861316923} = "广东省梅州市";
$areanames{zh}->{861316924} = "广东省梅州市";
$areanames{zh}->{861316925} = "广东省揭阳市";
$areanames{zh}->{861316926} = "广东省揭阳市";
$areanames{zh}->{861316927} = "广东省揭阳市";
$areanames{zh}->{861316928} = "广东省揭阳市";
$areanames{zh}->{861316929} = "广东省揭阳市";
$areanames{zh}->{861316930} = "广东省中山市";
$areanames{zh}->{861316931} = "广东省中山市";
$areanames{zh}->{861316932} = "广东省中山市";
$areanames{zh}->{861316933} = "广东省中山市";
$areanames{zh}->{861316934} = "广东省肇庆市";
$areanames{zh}->{861316935} = "广东省肇庆市";
$areanames{zh}->{861316936} = "广东省肇庆市";
$areanames{zh}->{861316937} = "广东省云浮市";
$areanames{zh}->{861316938} = "广东省云浮市";
$areanames{zh}->{861316939} = "广东省云浮市";
$areanames{zh}->{861316940} = "广东省韶关市";
$areanames{zh}->{861316941} = "广东省韶关市";
$areanames{zh}->{861316942} = "广东省韶关市";
$areanames{zh}->{861316943} = "河北省保定市";
$areanames{zh}->{861316944} = "广东省清远市";
$areanames{zh}->{861316945} = "广东省河源市";
$areanames{zh}->{861316946} = "广东省河源市";
$areanames{zh}->{861316947} = "广东省汕尾市";
$areanames{zh}->{861316948} = "广东省汕尾市";
$areanames{zh}->{861316949} = "广东省汕尾市";
$areanames{zh}->{861316950} = "广东省东莞市";
$areanames{zh}->{861316951} = "广东省东莞市";
$areanames{zh}->{861316952} = "广东省东莞市";
$areanames{zh}->{861316953} = "广东省东莞市";
$areanames{zh}->{861316954} = "广东省东莞市";
$areanames{zh}->{861316955} = "广东省惠州市";
$areanames{zh}->{861316956} = "广东省惠州市";
$areanames{zh}->{861316957} = "广东省惠州市";
$areanames{zh}->{861316958} = "广东省惠州市";
$areanames{zh}->{861316959} = "广东省惠州市";
$areanames{zh}->{86131696} = "广东省珠海市";
$areanames{zh}->{861316970} = "广东省佛山市";
$areanames{zh}->{861316971} = "广东省佛山市";
$areanames{zh}->{861316972} = "广东省佛山市";
$areanames{zh}->{861316973} = "广东省清远市";
$areanames{zh}->{861316974} = "广东省清远市";
$areanames{zh}->{861316975} = "广东省清远市";
$areanames{zh}->{861316976} = "广东省茂名市";
$areanames{zh}->{861316977} = "广东省茂名市";
$areanames{zh}->{861316978} = "广东省茂名市";
$areanames{zh}->{861316979} = "广东省茂名市";
$areanames{zh}->{861316980} = "广东省江门市";
$areanames{zh}->{861316981} = "广东省江门市";
$areanames{zh}->{861316982} = "广东省江门市";
$areanames{zh}->{861316983} = "广东省江门市";
$areanames{zh}->{861316984} = "广东省江门市";
$areanames{zh}->{861316985} = "广东省中山市";
$areanames{zh}->{861316986} = "广东省中山市";
$areanames{zh}->{861316987} = "广东省中山市";
$areanames{zh}->{861316988} = "广东省中山市";
$areanames{zh}->{861316989} = "广东省中山市";
$areanames{zh}->{861316990} = "广东省深圳市";
$areanames{zh}->{861316991} = "广东省深圳市";
$areanames{zh}->{861316992} = "广东省深圳市";
$areanames{zh}->{861316993} = "广东省深圳市";
$areanames{zh}->{861316994} = "广东省深圳市";
$areanames{zh}->{861316995} = "广东省佛山市";
$areanames{zh}->{861316996} = "广东省佛山市";
$areanames{zh}->{861316997} = "广东省佛山市";
$areanames{zh}->{861316998} = "广东省佛山市";
$areanames{zh}->{861316999} = "广东省佛山市";
$areanames{zh}->{861317000} = "安徽省滁州市";
$areanames{zh}->{861317001} = "安徽省合肥市";
$areanames{zh}->{861317002} = "安徽省蚌埠市";
$areanames{zh}->{861317003} = "安徽省芜湖市";
$areanames{zh}->{861317004} = "安徽省阜阳市";
$areanames{zh}->{861317005} = "安徽省马鞍山市";
$areanames{zh}->{861317006} = "安徽省安庆市";
$areanames{zh}->{861317007} = "安徽省宿州市";
$areanames{zh}->{861317008} = "安徽省阜阳市";
$areanames{zh}->{861317009} = "安徽省黄山市";
$areanames{zh}->{861317010} = "安徽省亳州市";
$areanames{zh}->{861317011} = "安徽省淮北市";
$areanames{zh}->{861317012} = "安徽省铜陵市";
$areanames{zh}->{861317013} = "安徽省宣城市";
$areanames{zh}->{861317014} = "安徽省六安市";
$areanames{zh}->{861317015} = "安徽省合肥市";
$areanames{zh}->{861317016} = "安徽省池州市";
$areanames{zh}->{861317017} = "安徽省亳州市";
$areanames{zh}->{861317018} = "安徽省六安市";
$areanames{zh}->{861317019} = "安徽省六安市";
$areanames{zh}->{861317020} = "安徽省淮南市";
$areanames{zh}->{861317021} = "安徽省宿州市";
$areanames{zh}->{861317022} = "安徽省蚌埠市";
$areanames{zh}->{861317023} = "安徽省芜湖市";
$areanames{zh}->{861317024} = "安徽省安庆市";
$areanames{zh}->{861317025} = "安徽省合肥市";
$areanames{zh}->{861317026} = "安徽省宣城市";
$areanames{zh}->{861317027} = "安徽省合肥市";
$areanames{zh}->{861317028} = "安徽省安庆市";
$areanames{zh}->{861317029} = "安徽省黄山市";
$areanames{zh}->{861317030} = "湖南省长沙市";
$areanames{zh}->{861317031} = "湖南省长沙市";
$areanames{zh}->{861317032} = "湖南省湘潭市";
$areanames{zh}->{861317033} = "湖南省衡阳市";
$areanames{zh}->{861317034} = "湖南省衡阳市";
$areanames{zh}->{861317035} = "湖南省郴州市";
$areanames{zh}->{861317036} = "湖南省郴州市";
$areanames{zh}->{861317037} = "湖南省益阳市";
$areanames{zh}->{861317038} = "湖南省娄底市";
$areanames{zh}->{861317039} = "湖南省邵阳市";
$areanames{zh}->{861317040} = "湖南省长沙市";
$areanames{zh}->{861317041} = "湖南省长沙市";
$areanames{zh}->{861317042} = "湖南省湘潭市";
$areanames{zh}->{861317043} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861317044} = "湖南省张家界市";
$areanames{zh}->{861317045} = "湖南省怀化市";
$areanames{zh}->{861317046} = "湖南省永州市";
$areanames{zh}->{861317047} = "湖南省长沙市";
$areanames{zh}->{861317048} = "湖南省长沙市";
$areanames{zh}->{861317049} = "湖南省邵阳市";
$areanames{zh}->{861317050} = "云南省楚雄彝族自治州";
$areanames{zh}->{861317051} = "云南省楚雄彝族自治州";
$areanames{zh}->{861317052} = "云南省楚雄彝族自治州";
$areanames{zh}->{861317053} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861317054} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861317055} = "云南省临沧市";
$areanames{zh}->{861317056} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861317057} = "云南省昭通市";
$areanames{zh}->{861317058} = "云南省昭通市";
$areanames{zh}->{861317059} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861317060} = "云南省昆明市";
$areanames{zh}->{861317061} = "云南省昆明市";
$areanames{zh}->{861317062} = "云南省昆明市";
$areanames{zh}->{861317063} = "云南省昆明市";
$areanames{zh}->{861317064} = "云南省玉溪市";
$areanames{zh}->{861317065} = "云南省玉溪市";
$areanames{zh}->{861317066} = "云南省玉溪市";
$areanames{zh}->{861317067} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861317068} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861317069} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861317070} = "云南省曲靖市";
$areanames{zh}->{861317071} = "云南省曲靖市";
$areanames{zh}->{861317072} = "云南省曲靖市";
$areanames{zh}->{861317073} = "云南省保山市";
$areanames{zh}->{861317074} = "云南省普洱市";
$areanames{zh}->{861317075} = "云南省大理白族自治州";
$areanames{zh}->{861317076} = "云南省大理白族自治州";
$areanames{zh}->{861317077} = "云南省丽江市";
$areanames{zh}->{861317078} = "云南省丽江市";
$areanames{zh}->{861317079} = "云南省迪庆藏族自治州";
$areanames{zh}->{861317080} = "江西省鹰潭市";
$areanames{zh}->{861317081} = "江西省赣州市";
$areanames{zh}->{861317082} = "江西省九江市";
$areanames{zh}->{861317083} = "江西省宜春市";
$areanames{zh}->{861317084} = "江西省赣州市";
$areanames{zh}->{861317085} = "江西省宜春市";
$areanames{zh}->{861317086} = "江西省南昌市";
$areanames{zh}->{861317087} = "江西省南昌市";
$areanames{zh}->{861317088} = "江西省南昌市";
$areanames{zh}->{861317089} = "江西省抚州市";
$areanames{zh}->{861317090} = "江西省新余市";
$areanames{zh}->{861317091} = "江西省南昌市";
$areanames{zh}->{861317092} = "江西省九江市";
$areanames{zh}->{861317093} = "江西省上饶市";
$areanames{zh}->{861317094} = "江西省抚州市";
$areanames{zh}->{861317095} = "江西省宜春市";
$areanames{zh}->{861317096} = "江西省吉安市";
$areanames{zh}->{861317097} = "江西省赣州市";
$areanames{zh}->{861317098} = "江西省景德镇市";
$areanames{zh}->{861317099} = "江西省上饶市";
$areanames{zh}->{86131710} = "内蒙古呼和浩特市";
$areanames{zh}->{86131711} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861317110} = "内蒙古通辽市";
$areanames{zh}->{861317111} = "内蒙古通辽市";
$areanames{zh}->{861317112} = "内蒙古通辽市";
$areanames{zh}->{861317113} = "内蒙古通辽市";
$areanames{zh}->{86131712} = "内蒙古包头市";
$areanames{zh}->{861317130} = "内蒙古兴安盟";
$areanames{zh}->{861317131} = "内蒙古乌海市";
$areanames{zh}->{861317132} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861317133} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861317134} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861317135} = "内蒙古赤峰市";
$areanames{zh}->{861317136} = "内蒙古赤峰市";
$areanames{zh}->{861317137} = "内蒙古赤峰市";
$areanames{zh}->{861317138} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861317139} = "内蒙古兴安盟";
$areanames{zh}->{86131714} = "内蒙古包头市";
$areanames{zh}->{861317140} = "内蒙古呼和浩特市";
$areanames{zh}->{861317141} = "内蒙古呼和浩特市";
$areanames{zh}->{861317142} = "内蒙古呼和浩特市";
$areanames{zh}->{861317149} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861317150} = "河北省唐山市";
$areanames{zh}->{861317151} = "河北省唐山市";
$areanames{zh}->{861317152} = "河北省唐山市";
$areanames{zh}->{861317153} = "河北省邯郸市";
$areanames{zh}->{861317154} = "河北省邯郸市";
$areanames{zh}->{861317155} = "河北省石家庄市";
$areanames{zh}->{861317156} = "河北省石家庄市";
$areanames{zh}->{861317157} = "河北省石家庄市";
$areanames{zh}->{861317158} = "河北省石家庄市";
$areanames{zh}->{861317159} = "河北省石家庄市";
$areanames{zh}->{861317160} = "河北省承德市";
$areanames{zh}->{861317161} = "河北省承德市";
$areanames{zh}->{861317162} = "河北省承德市";
$areanames{zh}->{861317163} = "河北省张家口市";
$areanames{zh}->{861317164} = "河北省张家口市";
$areanames{zh}->{861317165} = "河北省张家口市";
$areanames{zh}->{861317166} = "河北省张家口市";
$areanames{zh}->{861317167} = "河北省保定市";
$areanames{zh}->{861317168} = "河北省保定市";
$areanames{zh}->{861317169} = "河北省保定市";
$areanames{zh}->{861317170} = "河北省沧州市";
$areanames{zh}->{861317171} = "河北省衡水市";
$areanames{zh}->{861317172} = "河北省秦皇岛市";
$areanames{zh}->{861317173} = "河北省廊坊市";
$areanames{zh}->{861317174} = "河北省衡水市";
$areanames{zh}->{861317175} = "河北省邢台市";
$areanames{zh}->{861317176} = "河北省衡水市";
$areanames{zh}->{861317177} = "河北省邯郸市";
$areanames{zh}->{861317178} = "河北省邯郸市";
$areanames{zh}->{861317179} = "河北省邯郸市";
$areanames{zh}->{861317180} = "河北省石家庄市";
$areanames{zh}->{861317181} = "河北省唐山市";
$areanames{zh}->{861317182} = "河北省秦皇岛市";
$areanames{zh}->{861317183} = "河北省廊坊市";
$areanames{zh}->{861317184} = "河北省唐山市";
$areanames{zh}->{861317185} = "河北省邢台市";
$areanames{zh}->{861317186} = "河北省邯郸市";
$areanames{zh}->{861317187} = "河北省保定市";
$areanames{zh}->{861317188} = "河北省石家庄市";
$areanames{zh}->{861317189} = "河北省石家庄市";
$areanames{zh}->{861317190} = "河北省保定市";
$areanames{zh}->{861317191} = "河北省保定市";
$areanames{zh}->{861317192} = "河北省保定市";
$areanames{zh}->{861317193} = "河北省廊坊市";
$areanames{zh}->{861317194} = "河北省廊坊市";
$areanames{zh}->{861317195} = "河北省邢台市";
$areanames{zh}->{861317196} = "河北省秦皇岛市";
$areanames{zh}->{861317197} = "河北省秦皇岛市";
$areanames{zh}->{861317198} = "河北省沧州市";
$areanames{zh}->{861317199} = "河北省沧州市";
$areanames{zh}->{86131720} = "广东省广州市";
$areanames{zh}->{86131721} = "河北省廊坊市";
$areanames{zh}->{861317210} = "广东省广州市";
$areanames{zh}->{861317211} = "广东省东莞市";
$areanames{zh}->{861317216} = "广东省东莞市";
$areanames{zh}->{86131722} = "广东省江门市";
$areanames{zh}->{86131723} = "广东省佛山市";
$areanames{zh}->{86131724} = "广东省深圳市";
$areanames{zh}->{861317250} = "广东省汕头市";
$areanames{zh}->{861317251} = "广东省汕头市";
$areanames{zh}->{861317252} = "广东省汕头市";
$areanames{zh}->{861317253} = "广东省汕头市";
$areanames{zh}->{861317254} = "广东省汕头市";
$areanames{zh}->{861317255} = "广东省潮州市";
$areanames{zh}->{861317256} = "广东省潮州市";
$areanames{zh}->{861317257} = "广东省潮州市";
$areanames{zh}->{861317258} = "广东省潮州市";
$areanames{zh}->{861317259} = "广东省潮州市";
$areanames{zh}->{861317260} = "广东省肇庆市";
$areanames{zh}->{861317261} = "广东省肇庆市";
$areanames{zh}->{861317262} = "广东省肇庆市";
$areanames{zh}->{861317263} = "广东省肇庆市";
$areanames{zh}->{861317264} = "广东省肇庆市";
$areanames{zh}->{861317265} = "广东省珠海市";
$areanames{zh}->{861317266} = "广东省珠海市";
$areanames{zh}->{861317267} = "河北省邢台市";
$areanames{zh}->{861317268} = "河北省邢台市";
$areanames{zh}->{861317269} = "河北省邢台市";
$areanames{zh}->{861317270} = "广东省惠州市";
$areanames{zh}->{861317271} = "广东省惠州市";
$areanames{zh}->{861317272} = "广东省惠州市";
$areanames{zh}->{861317273} = "广东省惠州市";
$areanames{zh}->{861317274} = "广东省惠州市";
$areanames{zh}->{861317275} = "广东省河源市";
$areanames{zh}->{861317276} = "广东省河源市";
$areanames{zh}->{861317277} = "广东省河源市";
$areanames{zh}->{861317278} = "广东省河源市";
$areanames{zh}->{861317279} = "广东省河源市";
$areanames{zh}->{861317280} = "广东省揭阳市";
$areanames{zh}->{861317281} = "广东省揭阳市";
$areanames{zh}->{861317282} = "广东省揭阳市";
$areanames{zh}->{861317283} = "广东省揭阳市";
$areanames{zh}->{861317284} = "广东省揭阳市";
$areanames{zh}->{861317285} = "广东省汕尾市";
$areanames{zh}->{861317286} = "广东省汕尾市";
$areanames{zh}->{861317287} = "广东省汕尾市";
$areanames{zh}->{861317288} = "广东省汕尾市";
$areanames{zh}->{861317289} = "广东省汕尾市";
$areanames{zh}->{861317290} = "广东省清远市";
$areanames{zh}->{861317291} = "广东省清远市";
$areanames{zh}->{861317292} = "广东省清远市";
$areanames{zh}->{861317293} = "广东省清远市";
$areanames{zh}->{861317294} = "广东省清远市";
$areanames{zh}->{861317295} = "广东省韶关市";
$areanames{zh}->{861317296} = "广东省韶关市";
$areanames{zh}->{861317297} = "广东省韶关市";
$areanames{zh}->{861317298} = "广东省韶关市";
$areanames{zh}->{861317299} = "广东省韶关市";
$areanames{zh}->{86131730} = "山东省济南市";
$areanames{zh}->{861317306} = "山东省枣庄市";
$areanames{zh}->{861317307} = "山东省临沂市";
$areanames{zh}->{861317308} = "山东省临沂市";
$areanames{zh}->{861317309} = "山东省临沂市";
$areanames{zh}->{86131731} = "山东省潍坊市";
$areanames{zh}->{861317317} = "山东省济宁市";
$areanames{zh}->{861317318} = "山东省济宁市";
$areanames{zh}->{861317319} = "山东省济宁市";
$areanames{zh}->{861317320} = "山东省青岛市";
$areanames{zh}->{861317321} = "山东省青岛市";
$areanames{zh}->{861317322} = "山东省青岛市";
$areanames{zh}->{861317323} = "山东省青岛市";
$areanames{zh}->{861317324} = "山东省青岛市";
$areanames{zh}->{861317325} = "山东省聊城市";
$areanames{zh}->{861317326} = "山东省淄博市";
$areanames{zh}->{861317327} = "山东省淄博市";
$areanames{zh}->{861317328} = "山东省滨州市";
$areanames{zh}->{861317329} = "山东省滨州市";
$areanames{zh}->{861317330} = "山东省威海市";
$areanames{zh}->{861317331} = "山东省威海市";
$areanames{zh}->{861317332} = "山东省枣庄市";
$areanames{zh}->{861317333} = "山东省德州市";
$areanames{zh}->{861317334} = "山东省德州市";
$areanames{zh}->{861317335} = "山东省聊城市";
$areanames{zh}->{861317336} = "山东省东营市";
$areanames{zh}->{861317337} = "山东省枣庄市";
$areanames{zh}->{861317338} = "山东省泰安市";
$areanames{zh}->{861317339} = "山东省菏泽市";
$areanames{zh}->{861317340} = "山东省威海市";
$areanames{zh}->{861317341} = "山东省淄博市";
$areanames{zh}->{861317342} = "山东省滨州市";
$areanames{zh}->{861317343} = "山东省德州市";
$areanames{zh}->{861317344} = "山东省临沂市";
$areanames{zh}->{861317345} = "山东省济宁市";
$areanames{zh}->{861317346} = "山东省东营市";
$areanames{zh}->{861317347} = "山东省枣庄市";
$areanames{zh}->{861317348} = "山东省泰安市";
$areanames{zh}->{861317349} = "山东省菏泽市";
$areanames{zh}->{86131735} = "浙江省温州市";
$areanames{zh}->{86131736} = "浙江省杭州市";
$areanames{zh}->{86131737} = "浙江省台州市";
$areanames{zh}->{86131738} = "浙江省金华市";
$areanames{zh}->{86131739} = "浙江省绍兴市";
$areanames{zh}->{861317400} = "江苏省淮安市";
$areanames{zh}->{861317401} = "江苏省淮安市";
$areanames{zh}->{861317402} = "江苏省盐城市";
$areanames{zh}->{861317403} = "江苏省盐城市";
$areanames{zh}->{861317404} = "江苏省无锡市";
$areanames{zh}->{861317405} = "江苏省无锡市";
$areanames{zh}->{861317406} = "江苏省无锡市";
$areanames{zh}->{861317407} = "江苏省南京市";
$areanames{zh}->{861317408} = "江苏省南京市";
$areanames{zh}->{861317409} = "江苏省南京市";
$areanames{zh}->{861317410} = "江苏省苏州市";
$areanames{zh}->{861317411} = "江苏省苏州市";
$areanames{zh}->{861317412} = "江苏省扬州市";
$areanames{zh}->{861317413} = "江苏省扬州市";
$areanames{zh}->{861317414} = "江苏省徐州市";
$areanames{zh}->{861317415} = "江苏省徐州市";
$areanames{zh}->{861317416} = "江苏省常州市";
$areanames{zh}->{861317417} = "江苏省常州市";
$areanames{zh}->{861317418} = "江苏省连云港市";
$areanames{zh}->{861317419} = "江苏省连云港市";
$areanames{zh}->{861317420} = "湖南省怀化市";
$areanames{zh}->{861317421} = "湖南省张家界市";
$areanames{zh}->{861317422} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861317423} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861317424} = "湖南省张家界市";
$areanames{zh}->{861317425} = "湖南省怀化市";
$areanames{zh}->{861317426} = "湖南省永州市";
$areanames{zh}->{861317427} = "湖南省永州市";
$areanames{zh}->{861317428} = "湖南省娄底市";
$areanames{zh}->{861317429} = "湖南省邵阳市";
$areanames{zh}->{86131743} = "吉林省长春市";
$areanames{zh}->{861317432} = "吉林省吉林市";
$areanames{zh}->{86131744} = "吉林省长春市";
$areanames{zh}->{861317450} = "福建省福州市";
$areanames{zh}->{861317451} = "福建省福州市";
$areanames{zh}->{861317452} = "福建省福州市";
$areanames{zh}->{861317453} = "福建省福州市";
$areanames{zh}->{861317454} = "福建省莆田市";
$areanames{zh}->{861317455} = "福建省莆田市";
$areanames{zh}->{861317456} = "福建省莆田市";
$areanames{zh}->{861317457} = "福建省宁德市";
$areanames{zh}->{861317458} = "福建省龙岩市";
$areanames{zh}->{861317459} = "福建省龙岩市";
$areanames{zh}->{86131746} = "福建省漳州市";
$areanames{zh}->{861317463} = "福建省宁德市";
$areanames{zh}->{861317464} = "河南省信阳市";
$areanames{zh}->{861317465} = "福建省莆田市";
$areanames{zh}->{861317469} = "福建省南平市";
$areanames{zh}->{861317470} = "浙江省嘉兴市";
$areanames{zh}->{861317471} = "浙江省嘉兴市";
$areanames{zh}->{861317472} = "浙江省嘉兴市";
$areanames{zh}->{861317473} = "浙江省嘉兴市";
$areanames{zh}->{861317474} = "浙江省嘉兴市";
$areanames{zh}->{861317475} = "浙江省台州市";
$areanames{zh}->{861317476} = "浙江省台州市";
$areanames{zh}->{861317477} = "浙江省台州市";
$areanames{zh}->{861317478} = "浙江省台州市";
$areanames{zh}->{861317479} = "浙江省台州市";
$areanames{zh}->{86131748} = "天津市";
$areanames{zh}->{86131749} = "浙江省金华市";
$areanames{zh}->{86131750} = "浙江省杭州市";
$areanames{zh}->{861317510} = "浙江省杭州市";
$areanames{zh}->{861317511} = "浙江省杭州市";
$areanames{zh}->{861317512} = "浙江省杭州市";
$areanames{zh}->{861317513} = "浙江省杭州市";
$areanames{zh}->{861317514} = "浙江省杭州市";
$areanames{zh}->{861317515} = "浙江省宁波市";
$areanames{zh}->{861317516} = "浙江省宁波市";
$areanames{zh}->{861317517} = "浙江省宁波市";
$areanames{zh}->{861317518} = "浙江省宁波市";
$areanames{zh}->{861317519} = "浙江省宁波市";
$areanames{zh}->{861317520} = "浙江省湖州市";
$areanames{zh}->{861317521} = "浙江省湖州市";
$areanames{zh}->{861317522} = "浙江省湖州市";
$areanames{zh}->{861317523} = "浙江省湖州市";
$areanames{zh}->{861317524} = "浙江省湖州市";
$areanames{zh}->{861317525} = "浙江省绍兴市";
$areanames{zh}->{861317526} = "浙江省绍兴市";
$areanames{zh}->{861317527} = "浙江省绍兴市";
$areanames{zh}->{861317528} = "浙江省绍兴市";
$areanames{zh}->{861317529} = "浙江省绍兴市";
$areanames{zh}->{86131753} = "浙江省台州市";
$areanames{zh}->{861317540} = "浙江省金华市";
$areanames{zh}->{861317541} = "浙江省金华市";
$areanames{zh}->{861317542} = "浙江省金华市";
$areanames{zh}->{861317543} = "浙江省金华市";
$areanames{zh}->{861317544} = "浙江省金华市";
$areanames{zh}->{861317545} = "浙江省台州市";
$areanames{zh}->{861317546} = "浙江省台州市";
$areanames{zh}->{861317547} = "浙江省台州市";
$areanames{zh}->{861317548} = "浙江省台州市";
$areanames{zh}->{861317549} = "浙江省台州市";
$areanames{zh}->{861317550} = "浙江省金华市";
$areanames{zh}->{861317551} = "浙江省金华市";
$areanames{zh}->{861317552} = "浙江省金华市";
$areanames{zh}->{861317553} = "浙江省金华市";
$areanames{zh}->{861317554} = "浙江省金华市";
$areanames{zh}->{861317555} = "浙江省嘉兴市";
$areanames{zh}->{861317556} = "浙江省嘉兴市";
$areanames{zh}->{861317557} = "浙江省嘉兴市";
$areanames{zh}->{861317558} = "浙江省嘉兴市";
$areanames{zh}->{861317559} = "浙江省嘉兴市";
$areanames{zh}->{86131756} = "浙江省温州市";
$areanames{zh}->{861317570} = "浙江省衢州市";
$areanames{zh}->{861317571} = "浙江省衢州市";
$areanames{zh}->{861317572} = "浙江省衢州市";
$areanames{zh}->{861317573} = "浙江省衢州市";
$areanames{zh}->{861317574} = "浙江省衢州市";
$areanames{zh}->{861317575} = "浙江省丽水市";
$areanames{zh}->{861317576} = "浙江省丽水市";
$areanames{zh}->{861317577} = "浙江省丽水市";
$areanames{zh}->{861317578} = "浙江省丽水市";
$areanames{zh}->{861317579} = "浙江省丽水市";
$areanames{zh}->{861317580} = "浙江省舟山市";
$areanames{zh}->{861317581} = "浙江省舟山市";
$areanames{zh}->{861317582} = "浙江省舟山市";
$areanames{zh}->{861317583} = "浙江省舟山市";
$areanames{zh}->{861317584} = "浙江省舟山市";
$areanames{zh}->{861317585} = "浙江省台州市";
$areanames{zh}->{861317586} = "浙江省台州市";
$areanames{zh}->{861317587} = "浙江省台州市";
$areanames{zh}->{861317588} = "浙江省台州市";
$areanames{zh}->{861317589} = "浙江省台州市";
$areanames{zh}->{86131759} = "浙江省宁波市";
$areanames{zh}->{861317600} = "山东省济南市";
$areanames{zh}->{861317601} = "山东省济南市";
$areanames{zh}->{861317602} = "山东省济南市";
$areanames{zh}->{861317603} = "山东省枣庄市";
$areanames{zh}->{861317604} = "山东省枣庄市";
$areanames{zh}->{861317605} = "山东省菏泽市";
$areanames{zh}->{861317606} = "山东省潍坊市";
$areanames{zh}->{861317607} = "山东省临沂市";
$areanames{zh}->{861317608} = "山东省临沂市";
$areanames{zh}->{861317609} = "山东省临沂市";
$areanames{zh}->{861317610} = "山东省菏泽市";
$areanames{zh}->{861317611} = "山东省菏泽市";
$areanames{zh}->{861317612} = "山东省泰安市";
$areanames{zh}->{861317613} = "山东省泰安市";
$areanames{zh}->{861317614} = "山东省德州市";
$areanames{zh}->{861317615} = "山东省聊城市";
$areanames{zh}->{861317616} = "山东省聊城市";
$areanames{zh}->{861317617} = "山东省济宁市";
$areanames{zh}->{861317618} = "山东省济宁市";
$areanames{zh}->{861317619} = "山东省济宁市";
$areanames{zh}->{861317620} = "山东省菏泽市";
$areanames{zh}->{861317621} = "山东省菏泽市";
$areanames{zh}->{861317622} = "山东省淄博市";
$areanames{zh}->{861317623} = "山东省日照市";
$areanames{zh}->{861317624} = "山东省威海市";
$areanames{zh}->{861317625} = "山东省聊城市";
$areanames{zh}->{861317626} = "山东省德州市";
$areanames{zh}->{861317627} = "山东省德州市";
$areanames{zh}->{861317628} = "山东省滨州市";
$areanames{zh}->{861317629} = "山东省滨州市";
$areanames{zh}->{861317630} = "山东省威海市";
$areanames{zh}->{861317631} = "山东省威海市";
$areanames{zh}->{861317632} = "山东省枣庄市";
$areanames{zh}->{861317633} = "山东省日照市";
$areanames{zh}->{861317634} = "山东省莱芜市";
$areanames{zh}->{861317635} = "山东省聊城市";
$areanames{zh}->{861317636} = "山东省潍坊市";
$areanames{zh}->{861317637} = "山东省枣庄市";
$areanames{zh}->{861317638} = "山东省烟台市";
$areanames{zh}->{861317639} = "山东省青岛市";
$areanames{zh}->{861317640} = "山东省济南市";
$areanames{zh}->{861317641} = "山东省济南市";
$areanames{zh}->{861317642} = "山东省滨州市";
$areanames{zh}->{861317643} = "山东省淄博市";
$areanames{zh}->{861317644} = "山东省济南市";
$areanames{zh}->{861317645} = "山东省烟台市";
$areanames{zh}->{861317646} = "山东省潍坊市";
$areanames{zh}->{861317647} = "山东省东营市";
$areanames{zh}->{861317648} = "山东省青岛市";
$areanames{zh}->{861317649} = "山东省滨州市";
$areanames{zh}->{861317650} = "山东省青岛市";
$areanames{zh}->{861317651} = "山东省青岛市";
$areanames{zh}->{861317652} = "山东省青岛市";
$areanames{zh}->{861317653} = "山东省青岛市";
$areanames{zh}->{861317654} = "山东省泰安市";
$areanames{zh}->{861317655} = "山东省淄博市";
$areanames{zh}->{861317656} = "山东省淄博市";
$areanames{zh}->{861317657} = "山东省淄博市";
$areanames{zh}->{861317658} = "山东省淄博市";
$areanames{zh}->{861317659} = "山东省淄博市";
$areanames{zh}->{861317660} = "山东省东营市";
$areanames{zh}->{861317661} = "山东省东营市";
$areanames{zh}->{861317662} = "山东省东营市";
$areanames{zh}->{861317663} = "山东省东营市";
$areanames{zh}->{861317664} = "山东省东营市";
$areanames{zh}->{861317665} = "山东省济南市";
$areanames{zh}->{861317666} = "山东省济南市";
$areanames{zh}->{861317667} = "山东省济南市";
$areanames{zh}->{861317668} = "山东省济南市";
$areanames{zh}->{861317669} = "山东省济南市";
$areanames{zh}->{861317670} = "山东省潍坊市";
$areanames{zh}->{861317671} = "山东省潍坊市";
$areanames{zh}->{861317672} = "山东省潍坊市";
$areanames{zh}->{861317673} = "山东省潍坊市";
$areanames{zh}->{861317674} = "山东省潍坊市";
$areanames{zh}->{861317675} = "山东省济宁市";
$areanames{zh}->{861317676} = "山东省济宁市";
$areanames{zh}->{861317677} = "山东省济宁市";
$areanames{zh}->{861317678} = "山东省济宁市";
$areanames{zh}->{861317679} = "山东省济宁市";
$areanames{zh}->{861317680} = "山东省威海市";
$areanames{zh}->{861317681} = "山东省威海市";
$areanames{zh}->{861317682} = "山东省泰安市";
$areanames{zh}->{861317683} = "山东省泰安市";
$areanames{zh}->{861317684} = "山东省德州市";
$areanames{zh}->{861317685} = "山东省青岛市";
$areanames{zh}->{861317686} = "山东省青岛市";
$areanames{zh}->{861317687} = "山东省青岛市";
$areanames{zh}->{861317688} = "山东省青岛市";
$areanames{zh}->{861317689} = "山东省青岛市";
$areanames{zh}->{861317690} = "山东省烟台市";
$areanames{zh}->{861317691} = "山东省烟台市";
$areanames{zh}->{861317692} = "山东省烟台市";
$areanames{zh}->{861317693} = "山东省烟台市";
$areanames{zh}->{861317694} = "山东省烟台市";
$areanames{zh}->{861317695} = "山东省聊城市";
$areanames{zh}->{861317696} = "山东省临沂市";
$areanames{zh}->{861317697} = "山东省临沂市";
$areanames{zh}->{861317698} = "山东省临沂市";
$areanames{zh}->{861317699} = "山东省临沂市";
$areanames{zh}->{861317700} = "湖北省荆州市";
$areanames{zh}->{861317701} = "湖北省荆州市";
$areanames{zh}->{861317702} = "湖北省荆州市";
$areanames{zh}->{861317703} = "湖北省荆州市";
$areanames{zh}->{861317704} = "湖北省荆州市";
$areanames{zh}->{861317705} = "湖北省宜昌市";
$areanames{zh}->{861317706} = "湖北省宜昌市";
$areanames{zh}->{861317707} = "湖北省宜昌市";
$areanames{zh}->{861317708} = "湖北省宜昌市";
$areanames{zh}->{861317709} = "湖北省宜昌市";
$areanames{zh}->{861317710} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861317711} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861317712} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861317713} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861317714} = "湖北省荆门市";
$areanames{zh}->{861317715} = "湖北省荆门市";
$areanames{zh}->{861317716} = "湖北省荆门市";
$areanames{zh}->{861317717} = "湖北省荆门市";
$areanames{zh}->{861317718} = "湖北省随州市";
$areanames{zh}->{861317719} = "湖北省随州市";
$areanames{zh}->{861317720} = "湖北省襄樊市";
$areanames{zh}->{861317721} = "湖北省襄樊市";
$areanames{zh}->{861317722} = "湖北省襄樊市";
$areanames{zh}->{861317723} = "湖北省襄樊市";
$areanames{zh}->{861317724} = "湖北省襄樊市";
$areanames{zh}->{861317725} = "湖北省孝感市";
$areanames{zh}->{861317726} = "湖北省孝感市";
$areanames{zh}->{861317727} = "湖北省孝感市";
$areanames{zh}->{861317728} = "湖北省孝感市";
$areanames{zh}->{861317729} = "湖北省孝感市";
$areanames{zh}->{861317730} = "湖北省黄石市";
$areanames{zh}->{861317731} = "湖北省黄石市";
$areanames{zh}->{861317732} = "湖北省黄石市";
$areanames{zh}->{861317733} = "湖北省黄石市";
$areanames{zh}->{861317734} = "湖北省黄冈市";
$areanames{zh}->{861317735} = "湖北省黄冈市";
$areanames{zh}->{861317736} = "湖北省黄冈市";
$areanames{zh}->{861317737} = "湖北省鄂州市";
$areanames{zh}->{861317738} = "湖北省鄂州市";
$areanames{zh}->{861317739} = "湖北省鄂州市";
$areanames{zh}->{861317740} = "湖北省咸宁市";
$areanames{zh}->{861317741} = "湖北省咸宁市";
$areanames{zh}->{861317742} = "湖北省咸宁市";
$areanames{zh}->{861317743} = "湖北省咸宁市";
$areanames{zh}->{861317744} = "湖北省咸宁市";
$areanames{zh}->{861317745} = "湖北省十堰市";
$areanames{zh}->{861317746} = "湖北省十堰市";
$areanames{zh}->{861317747} = "湖北省十堰市";
$areanames{zh}->{861317748} = "湖北省十堰市";
$areanames{zh}->{861317749} = "湖北省武汉市";
$areanames{zh}->{861317750} = "江西省上饶市";
$areanames{zh}->{861317751} = "江西省上饶市";
$areanames{zh}->{861317752} = "江西省上饶市";
$areanames{zh}->{861317753} = "江西省新余市";
$areanames{zh}->{861317754} = "江西省新余市";
$areanames{zh}->{861317755} = "江西省萍乡市";
$areanames{zh}->{861317756} = "江西省宜春市";
$areanames{zh}->{861317757} = "江西省宜春市";
$areanames{zh}->{861317758} = "江西省宜春市";
$areanames{zh}->{861317759} = "江西省鹰潭市";
$areanames{zh}->{861317760} = "江西省吉安市";
$areanames{zh}->{861317761} = "江西省吉安市";
$areanames{zh}->{861317762} = "江西省吉安市";
$areanames{zh}->{861317763} = "江西省景德镇市";
$areanames{zh}->{861317764} = "江西省萍乡市";
$areanames{zh}->{861317765} = "江西省抚州市";
$areanames{zh}->{861317766} = "江西省抚州市";
$areanames{zh}->{861317767} = "江西省抚州市";
$areanames{zh}->{861317768} = "江西省抚州市";
$areanames{zh}->{861317769} = "江西省鹰潭市";
$areanames{zh}->{861317770} = "江西省九江市";
$areanames{zh}->{861317771} = "江西省九江市";
$areanames{zh}->{861317772} = "江西省九江市";
$areanames{zh}->{861317773} = "江西省九江市";
$areanames{zh}->{861317774} = "江西省赣州市";
$areanames{zh}->{861317775} = "江西省赣州市";
$areanames{zh}->{861317776} = "江西省赣州市";
$areanames{zh}->{861317777} = "江西省南昌市";
$areanames{zh}->{861317778} = "江西省南昌市";
$areanames{zh}->{861317779} = "江西省赣州市";
$areanames{zh}->{86131778} = "江西省南昌市";
$areanames{zh}->{861317790} = "江西省新余市";
$areanames{zh}->{861317791} = "江西省南昌市";
$areanames{zh}->{861317792} = "江西省九江市";
$areanames{zh}->{861317793} = "江西省上饶市";
$areanames{zh}->{861317794} = "江西省抚州市";
$areanames{zh}->{861317795} = "江西省宜春市";
$areanames{zh}->{861317796} = "江西省吉安市";
$areanames{zh}->{861317797} = "江西省赣州市";
$areanames{zh}->{861317798} = "江西省景德镇市";
$areanames{zh}->{861317799} = "江西省萍乡市";
$areanames{zh}->{861317800} = "福建省漳州市";
$areanames{zh}->{861317801} = "福建省泉州市";
$areanames{zh}->{861317802} = "福建省漳州市";
$areanames{zh}->{861317803} = "福建省福州市";
$areanames{zh}->{861317804} = "福建省泉州市";
$areanames{zh}->{861317805} = "福建省莆田市";
$areanames{zh}->{861317806} = "福建省莆田市";
$areanames{zh}->{861317807} = "福建省三明市";
$areanames{zh}->{861317808} = "福建省泉州市";
$areanames{zh}->{861317809} = "福建省泉州市";
$areanames{zh}->{861317810} = "福建省宁德市";
$areanames{zh}->{861317811} = "福建省福州市";
$areanames{zh}->{861317812} = "福建省宁德市";
$areanames{zh}->{861317813} = "福建省莆田市";
$areanames{zh}->{861317814} = "福建省宁德市";
$areanames{zh}->{861317815} = "福建省龙岩市";
$areanames{zh}->{861317816} = "福建省漳州市";
$areanames{zh}->{861317817} = "福建省南平市";
$areanames{zh}->{861317818} = "福建省龙岩市";
$areanames{zh}->{861317819} = "福建省莆田市";
$areanames{zh}->{861317820} = "福建省泉州市";
$areanames{zh}->{861317821} = "福建省泉州市";
$areanames{zh}->{861317822} = "福建省龙岩市";
$areanames{zh}->{861317823} = "福建省莆田市";
$areanames{zh}->{861317824} = "福建省莆田市";
$areanames{zh}->{861317825} = "福建省厦门市";
$areanames{zh}->{861317826} = "福建省龙岩市";
$areanames{zh}->{861317827} = "福建省厦门市";
$areanames{zh}->{861317828} = "福建省宁德市";
$areanames{zh}->{861317829} = "福建省三明市";
$areanames{zh}->{861317830} = "福建省宁德市";
$areanames{zh}->{861317831} = "福建省漳州市";
$areanames{zh}->{861317832} = "福建省泉州市";
$areanames{zh}->{861317833} = "福建省南平市";
$areanames{zh}->{861317834} = "福建省漳州市";
$areanames{zh}->{861317835} = "福建省厦门市";
$areanames{zh}->{861317836} = "福建省泉州市";
$areanames{zh}->{861317837} = "福建省漳州市";
$areanames{zh}->{861317838} = "福建省福州市";
$areanames{zh}->{861317839} = "福建省龙岩市";
$areanames{zh}->{861317840} = "广东省韶关市";
$areanames{zh}->{861317841} = "广东省韶关市";
$areanames{zh}->{861317842} = "广东省韶关市";
$areanames{zh}->{861317843} = "广东省韶关市";
$areanames{zh}->{861317844} = "广东省韶关市";
$areanames{zh}->{861317845} = "广东省清远市";
$areanames{zh}->{861317846} = "广东省清远市";
$areanames{zh}->{861317847} = "广东省清远市";
$areanames{zh}->{861317848} = "广东省清远市";
$areanames{zh}->{861317849} = "广东省清远市";
$areanames{zh}->{861317850} = "广东省佛山市";
$areanames{zh}->{861317851} = "广东省佛山市";
$areanames{zh}->{861317852} = "广东省佛山市";
$areanames{zh}->{861317853} = "广东省佛山市";
$areanames{zh}->{861317854} = "广东省佛山市";
$areanames{zh}->{861317855} = "广东省湛江市";
$areanames{zh}->{861317856} = "广东省湛江市";
$areanames{zh}->{861317857} = "广东省湛江市";
$areanames{zh}->{861317858} = "广东省湛江市";
$areanames{zh}->{861317859} = "广东省湛江市";
$areanames{zh}->{86131786} = "广东省中山市";
$areanames{zh}->{861317870} = "广东省梅州市";
$areanames{zh}->{861317871} = "广东省梅州市";
$areanames{zh}->{861317872} = "广东省梅州市";
$areanames{zh}->{861317873} = "广东省梅州市";
$areanames{zh}->{861317874} = "广东省梅州市";
$areanames{zh}->{861317875} = "广东省汕头市";
$areanames{zh}->{861317876} = "广东省汕头市";
$areanames{zh}->{861317877} = "广东省汕头市";
$areanames{zh}->{861317878} = "广东省汕头市";
$areanames{zh}->{861317879} = "广东省汕头市";
$areanames{zh}->{86131788} = "广东省广州市";
$areanames{zh}->{86131789} = "海南省海口市";
$areanames{zh}->{861317900} = "吉林省长春市";
$areanames{zh}->{861317901} = "吉林省长春市";
$areanames{zh}->{861317902} = "吉林省四平市";
$areanames{zh}->{861317903} = "吉林省四平市";
$areanames{zh}->{861317904} = "吉林省长春市";
$areanames{zh}->{861317905} = "吉林省松原市";
$areanames{zh}->{861317906} = "吉林省白城市";
$areanames{zh}->{861317907} = "吉林省白山市";
$areanames{zh}->{861317908} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861317909} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861317910} = "吉林省长春市";
$areanames{zh}->{861317911} = "吉林省长春市";
$areanames{zh}->{861317912} = "吉林省长春市";
$areanames{zh}->{861317913} = "吉林省长春市";
$areanames{zh}->{861317914} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861317915} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861317916} = "吉林省白城市";
$areanames{zh}->{861317917} = "吉林省白山市";
$areanames{zh}->{861317918} = "吉林省四平市";
$areanames{zh}->{861317919} = "吉林省通化市";
$areanames{zh}->{861317920} = "吉林省松原市";
$areanames{zh}->{861317921} = "吉林省通化市";
$areanames{zh}->{861317922} = "吉林省通化市";
$areanames{zh}->{861317923} = "吉林省吉林市";
$areanames{zh}->{861317924} = "吉林省吉林市";
$areanames{zh}->{861317925} = "吉林省吉林市";
$areanames{zh}->{861317926} = "吉林省吉林市";
$areanames{zh}->{861317927} = "吉林省吉林市";
$areanames{zh}->{861317928} = "吉林省辽源市";
$areanames{zh}->{861317929} = "吉林省辽源市";
$areanames{zh}->{861317930} = "江苏省常州市";
$areanames{zh}->{861317931} = "江苏省常州市";
$areanames{zh}->{861317932} = "江苏省盐城市";
$areanames{zh}->{861317933} = "江苏省盐城市";
$areanames{zh}->{861317934} = "江苏省盐城市";
$areanames{zh}->{861317935} = "江苏省盐城市";
$areanames{zh}->{861317936} = "江苏省泰州市";
$areanames{zh}->{861317937} = "江苏省泰州市";
$areanames{zh}->{861317938} = "江苏省镇江市";
$areanames{zh}->{861317939} = "江苏省镇江市";
$areanames{zh}->{861317940} = "江苏省苏州市";
$areanames{zh}->{861317941} = "江苏省苏州市";
$areanames{zh}->{861317942} = "江苏省泰州市";
$areanames{zh}->{861317943} = "江苏省泰州市";
$areanames{zh}->{861317944} = "江苏省无锡市";
$areanames{zh}->{861317945} = "江苏省镇江市";
$areanames{zh}->{861317946} = "江苏省镇江市";
$areanames{zh}->{861317947} = "江苏省镇江市";
$areanames{zh}->{861317948} = "江苏省镇江市";
$areanames{zh}->{861317949} = "江苏省镇江市";
$areanames{zh}->{861317950} = "江苏省淮安市";
$areanames{zh}->{861317951} = "江苏省淮安市";
$areanames{zh}->{861317952} = "江苏省淮安市";
$areanames{zh}->{861317953} = "江苏省常州市";
$areanames{zh}->{861317954} = "江苏省常州市";
$areanames{zh}->{861317955} = "江苏省宿迁市";
$areanames{zh}->{861317956} = "江苏省宿迁市";
$areanames{zh}->{861317957} = "江苏省连云港市";
$areanames{zh}->{861317958} = "江苏省连云港市";
$areanames{zh}->{861317959} = "江苏省连云港市";
$areanames{zh}->{861317960} = "江苏省苏州市";
$areanames{zh}->{861317961} = "江苏省苏州市";
$areanames{zh}->{861317962} = "江苏省苏州市";
$areanames{zh}->{861317963} = "江苏省苏州市";
$areanames{zh}->{861317964} = "江苏省苏州市";
$areanames{zh}->{861317965} = "江苏省无锡市";
$areanames{zh}->{861317966} = "江苏省无锡市";
$areanames{zh}->{861317967} = "江苏省无锡市";
$areanames{zh}->{861317968} = "江苏省无锡市";
$areanames{zh}->{861317969} = "江苏省无锡市";
$areanames{zh}->{861317970} = "江苏省徐州市";
$areanames{zh}->{861317971} = "江苏省徐州市";
$areanames{zh}->{861317972} = "江苏省徐州市";
$areanames{zh}->{861317973} = "江苏省徐州市";
$areanames{zh}->{861317974} = "江苏省徐州市";
$areanames{zh}->{861317975} = "江苏省扬州市";
$areanames{zh}->{861317976} = "江苏省扬州市";
$areanames{zh}->{861317977} = "江苏省扬州市";
$areanames{zh}->{861317978} = "江苏省扬州市";
$areanames{zh}->{861317979} = "江苏省扬州市";
$areanames{zh}->{861317980} = "新疆乌鲁木齐市";
$areanames{zh}->{861317981} = "新疆乌鲁木齐市";
$areanames{zh}->{861317982} = "新疆乌鲁木齐市";
$areanames{zh}->{861317983} = "新疆乌鲁木齐市";
$areanames{zh}->{861317984} = "新疆乌鲁木齐市";
$areanames{zh}->{861317985} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861317986} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861317987} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861317988} = "新疆阿克苏地区";
$areanames{zh}->{861317989} = "新疆和田地区";
$areanames{zh}->{861317990} = "新疆克拉玛依市";
$areanames{zh}->{861317991} = "新疆乌鲁木齐市";
$areanames{zh}->{861317992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861317993} = "新疆石河子市";
$areanames{zh}->{861317994} = "新疆昌吉回族自治州";
$areanames{zh}->{861317995} = "新疆吐鲁番地区";
$areanames{zh}->{861317996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861317997} = "新疆阿克苏地区";
$areanames{zh}->{861317998} = "新疆喀什地区";
$areanames{zh}->{861317999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86131800} = "河北省石家庄市";
$areanames{zh}->{861318000} = "河北省衡水市";
$areanames{zh}->{861318001} = "河北省衡水市";
$areanames{zh}->{861318002} = "河北省张家口市";
$areanames{zh}->{861318003} = "河北省邯郸市";
$areanames{zh}->{861318010} = "河北省承德市";
$areanames{zh}->{861318011} = "河北省承德市";
$areanames{zh}->{861318012} = "河北省秦皇岛市";
$areanames{zh}->{861318013} = "河北省秦皇岛市";
$areanames{zh}->{861318014} = "河北省秦皇岛市";
$areanames{zh}->{861318015} = "河北省沧州市";
$areanames{zh}->{861318016} = "河北省唐山市";
$areanames{zh}->{861318017} = "河北省唐山市";
$areanames{zh}->{861318018} = "河北省唐山市";
$areanames{zh}->{861318019} = "河北省唐山市";
$areanames{zh}->{86131802} = "河北省保定市";
$areanames{zh}->{861318027} = "河北省秦皇岛市";
$areanames{zh}->{861318028} = "河北省邢台市";
$areanames{zh}->{861318029} = "河北省衡水市";
$areanames{zh}->{861318030} = "河北省沧州市";
$areanames{zh}->{861318031} = "河北省沧州市";
$areanames{zh}->{861318032} = "河北省沧州市";
$areanames{zh}->{861318033} = "河北省沧州市";
$areanames{zh}->{861318034} = "河北省廊坊市";
$areanames{zh}->{861318035} = "河北省廊坊市";
$areanames{zh}->{861318036} = "河北省廊坊市";
$areanames{zh}->{861318037} = "河北省廊坊市";
$areanames{zh}->{861318038} = "河北省廊坊市";
$areanames{zh}->{861318039} = "河北省张家口市";
$areanames{zh}->{86131804} = "河北省石家庄市";
$areanames{zh}->{861318040} = "河北省唐山市";
$areanames{zh}->{861318041} = "河北省唐山市";
$areanames{zh}->{861318042} = "河北省唐山市";
$areanames{zh}->{861318043} = "河北省保定市";
$areanames{zh}->{861318050} = "河北省邯郸市";
$areanames{zh}->{861318051} = "河北省邯郸市";
$areanames{zh}->{861318052} = "河北省邯郸市";
$areanames{zh}->{861318053} = "河北省邯郸市";
$areanames{zh}->{861318054} = "河北省邢台市";
$areanames{zh}->{861318055} = "河北省邢台市";
$areanames{zh}->{861318056} = "河北省邢台市";
$areanames{zh}->{861318057} = "河北省张家口市";
$areanames{zh}->{861318058} = "河北省石家庄市";
$areanames{zh}->{861318059} = "河北省秦皇岛市";
$areanames{zh}->{86131806} = "吉林省通化市";
$areanames{zh}->{861318060} = "吉林省白城市";
$areanames{zh}->{861318061} = "吉林省白城市";
$areanames{zh}->{861318062} = "吉林省白城市";
$areanames{zh}->{861318063} = "吉林省四平市";
$areanames{zh}->{861318070} = "吉林省白山市";
$areanames{zh}->{861318071} = "吉林省白山市";
$areanames{zh}->{861318072} = "吉林省白山市";
$areanames{zh}->{861318073} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861318074} = "吉林省长春市";
$areanames{zh}->{861318075} = "吉林省吉林市";
$areanames{zh}->{861318076} = "吉林省吉林市";
$areanames{zh}->{861318077} = "吉林省松原市";
$areanames{zh}->{861318078} = "吉林省松原市";
$areanames{zh}->{861318079} = "吉林省长春市";
$areanames{zh}->{86131808} = "吉林省长春市";
$areanames{zh}->{861318090} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861318091} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861318092} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861318093} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861318094} = "吉林省长春市";
$areanames{zh}->{861318095} = "吉林省辽源市";
$areanames{zh}->{861318096} = "吉林省辽源市";
$areanames{zh}->{861318097} = "吉林省四平市";
$areanames{zh}->{861318098} = "吉林省四平市";
$areanames{zh}->{861318099} = "吉林省长春市";
$areanames{zh}->{861318100} = "山东省滨州市";
$areanames{zh}->{861318101} = "山东省滨州市";
$areanames{zh}->{861318102} = "山东省滨州市";
$areanames{zh}->{861318103} = "山东省滨州市";
$areanames{zh}->{861318104} = "山东省滨州市";
$areanames{zh}->{861318105} = "山东省聊城市";
$areanames{zh}->{861318106} = "山东省聊城市";
$areanames{zh}->{861318107} = "山东省聊城市";
$areanames{zh}->{861318108} = "山东省聊城市";
$areanames{zh}->{861318109} = "山东省聊城市";
$areanames{zh}->{861318110} = "山东省威海市";
$areanames{zh}->{861318111} = "山东省威海市";
$areanames{zh}->{861318112} = "山东省威海市";
$areanames{zh}->{861318113} = "山东省威海市";
$areanames{zh}->{861318114} = "山东省威海市";
$areanames{zh}->{861318115} = "山东省日照市";
$areanames{zh}->{861318116} = "山东省日照市";
$areanames{zh}->{861318117} = "山东省日照市";
$areanames{zh}->{861318118} = "山东省日照市";
$areanames{zh}->{861318119} = "山东省日照市";
$areanames{zh}->{861318120} = "山东省临沂市";
$areanames{zh}->{861318121} = "山东省临沂市";
$areanames{zh}->{861318122} = "山东省临沂市";
$areanames{zh}->{861318123} = "山东省临沂市";
$areanames{zh}->{861318124} = "山东省临沂市";
$areanames{zh}->{861318125} = "山东省枣庄市";
$areanames{zh}->{861318126} = "山东省枣庄市";
$areanames{zh}->{861318127} = "山东省枣庄市";
$areanames{zh}->{861318128} = "山东省枣庄市";
$areanames{zh}->{861318129} = "山东省枣庄市";
$areanames{zh}->{861318130} = "山东省济宁市";
$areanames{zh}->{861318131} = "山东省济宁市";
$areanames{zh}->{861318132} = "山东省济宁市";
$areanames{zh}->{861318133} = "山东省济宁市";
$areanames{zh}->{861318134} = "山东省济宁市";
$areanames{zh}->{861318135} = "山东省德州市";
$areanames{zh}->{861318136} = "山东省德州市";
$areanames{zh}->{861318137} = "山东省德州市";
$areanames{zh}->{861318138} = "山东省德州市";
$areanames{zh}->{861318139} = "山东省德州市";
$areanames{zh}->{861318140} = "山东省东营市";
$areanames{zh}->{861318141} = "山东省东营市";
$areanames{zh}->{861318142} = "山东省枣庄市";
$areanames{zh}->{861318143} = "山东省枣庄市";
$areanames{zh}->{861318144} = "山东省枣庄市";
$areanames{zh}->{861318145} = "山东省日照市";
$areanames{zh}->{861318146} = "山东省济宁市";
$areanames{zh}->{861318147} = "山东省济宁市";
$areanames{zh}->{861318148} = "山东省临沂市";
$areanames{zh}->{861318149} = "山东省临沂市";
$areanames{zh}->{861318150} = "山东省烟台市";
$areanames{zh}->{861318151} = "山东省烟台市";
$areanames{zh}->{861318152} = "山东省烟台市";
$areanames{zh}->{861318153} = "山东省烟台市";
$areanames{zh}->{861318154} = "山东省烟台市";
$areanames{zh}->{861318155} = "山东省菏泽市";
$areanames{zh}->{861318156} = "山东省菏泽市";
$areanames{zh}->{861318157} = "山东省菏泽市";
$areanames{zh}->{861318158} = "山东省菏泽市";
$areanames{zh}->{861318159} = "山东省菏泽市";
$areanames{zh}->{861318160} = "山东省烟台市";
$areanames{zh}->{861318161} = "山东省烟台市";
$areanames{zh}->{861318162} = "山东省烟台市";
$areanames{zh}->{861318163} = "山东省烟台市";
$areanames{zh}->{861318164} = "山东省烟台市";
$areanames{zh}->{861318165} = "山东省潍坊市";
$areanames{zh}->{861318166} = "山东省潍坊市";
$areanames{zh}->{861318167} = "山东省潍坊市";
$areanames{zh}->{861318168} = "山东省潍坊市";
$areanames{zh}->{861318169} = "山东省潍坊市";
$areanames{zh}->{861318170} = "山东省济南市";
$areanames{zh}->{861318171} = "山东省济南市";
$areanames{zh}->{861318172} = "山东省济南市";
$areanames{zh}->{861318173} = "山东省济南市";
$areanames{zh}->{861318174} = "山东省济南市";
$areanames{zh}->{861318175} = "山东省莱芜市";
$areanames{zh}->{861318176} = "山东省莱芜市";
$areanames{zh}->{861318177} = "山东省泰安市";
$areanames{zh}->{861318178} = "山东省泰安市";
$areanames{zh}->{861318179} = "山东省泰安市";
$areanames{zh}->{861318180} = "山东省泰安市";
$areanames{zh}->{861318181} = "山东省泰安市";
$areanames{zh}->{861318182} = "山东省泰安市";
$areanames{zh}->{861318183} = "山东省泰安市";
$areanames{zh}->{861318184} = "山东省泰安市";
$areanames{zh}->{861318185} = "山东省东营市";
$areanames{zh}->{861318186} = "山东省东营市";
$areanames{zh}->{861318187} = "山东省威海市";
$areanames{zh}->{861318188} = "山东省威海市";
$areanames{zh}->{861318189} = "山东省威海市";
$areanames{zh}->{861318190} = "山东省淄博市";
$areanames{zh}->{861318191} = "山东省淄博市";
$areanames{zh}->{861318192} = "山东省淄博市";
$areanames{zh}->{861318193} = "山东省淄博市";
$areanames{zh}->{861318194} = "山东省淄博市";
$areanames{zh}->{861318195} = "山东省东营市";
$areanames{zh}->{861318196} = "山东省东营市";
$areanames{zh}->{861318197} = "山东省东营市";
$areanames{zh}->{861318198} = "山东省东营市";
$areanames{zh}->{861318199} = "山东省东营市";
$areanames{zh}->{86131820} = "江苏省扬州市";
$areanames{zh}->{861318206} = "江苏省无锡市";
$areanames{zh}->{861318207} = "江苏省无锡市";
$areanames{zh}->{861318208} = "江苏省无锡市";
$areanames{zh}->{861318209} = "江苏省无锡市";
$areanames{zh}->{86131821} = "江苏省盐城市";
$areanames{zh}->{86131822} = "江苏省泰州市";
$areanames{zh}->{86131823} = "江苏省徐州市";
$areanames{zh}->{861318240} = "江苏省无锡市";
$areanames{zh}->{861318241} = "江苏省无锡市";
$areanames{zh}->{861318242} = "江苏省常州市";
$areanames{zh}->{861318243} = "江苏省常州市";
$areanames{zh}->{861318244} = "江苏省泰州市";
$areanames{zh}->{861318245} = "江苏省泰州市";
$areanames{zh}->{861318246} = "江苏省苏州市";
$areanames{zh}->{861318247} = "江苏省南通市";
$areanames{zh}->{861318248} = "江苏省南通市";
$areanames{zh}->{861318249} = "江苏省南通市";
$areanames{zh}->{86131825} = "江苏省常州市";
$areanames{zh}->{86131826} = "江苏省苏州市";
$areanames{zh}->{86131827} = "江苏省无锡市";
$areanames{zh}->{86131828} = "江苏省南京市";
$areanames{zh}->{86131829} = "江苏省南京市";
$areanames{zh}->{861318300} = "河南省郑州市";
$areanames{zh}->{861318301} = "河南省郑州市";
$areanames{zh}->{861318302} = "河南省许昌市";
$areanames{zh}->{861318303} = "河南省许昌市";
$areanames{zh}->{861318304} = "河南省商丘市";
$areanames{zh}->{861318305} = "河南省洛阳市";
$areanames{zh}->{861318306} = "河南省洛阳市";
$areanames{zh}->{861318307} = "河南省洛阳市";
$areanames{zh}->{861318308} = "河南省洛阳市";
$areanames{zh}->{861318309} = "河南省新乡市";
$areanames{zh}->{861318310} = "河南省新乡市";
$areanames{zh}->{861318311} = "河南省新乡市";
$areanames{zh}->{861318312} = "河南省焦作市";
$areanames{zh}->{861318313} = "河南省焦作市";
$areanames{zh}->{861318314} = "河南省驻马店市";
$areanames{zh}->{861318315} = "河南省安阳市";
$areanames{zh}->{861318316} = "河南省安阳市";
$areanames{zh}->{861318317} = "河南省濮阳市";
$areanames{zh}->{861318318} = "河南省濮阳市";
$areanames{zh}->{861318319} = "河南省漯河市";
$areanames{zh}->{861318320} = "河南省漯河市";
$areanames{zh}->{861318321} = "河南省漯河市";
$areanames{zh}->{861318322} = "河南省周口市";
$areanames{zh}->{861318323} = "河南省周口市";
$areanames{zh}->{861318324} = "河南省三门峡市";
$areanames{zh}->{861318325} = "河南省开封市";
$areanames{zh}->{861318326} = "河南省开封市";
$areanames{zh}->{861318327} = "河南省开封市";
$areanames{zh}->{861318328} = "河南省开封市";
$areanames{zh}->{861318329} = "河南省商丘市";
$areanames{zh}->{861318330} = "河南省南阳市";
$areanames{zh}->{861318331} = "河南省南阳市";
$areanames{zh}->{861318332} = "河南省平顶山市";
$areanames{zh}->{861318333} = "河南省平顶山市";
$areanames{zh}->{861318334} = "河南省平顶山市";
$areanames{zh}->{861318335} = "河南省平顶山市";
$areanames{zh}->{861318336} = "河南省信阳市";
$areanames{zh}->{861318337} = "河南省信阳市";
$areanames{zh}->{861318338} = "河南省驻马店市";
$areanames{zh}->{861318339} = "河南省三门峡市";
$areanames{zh}->{861318340} = "四川省南充市";
$areanames{zh}->{861318341} = "四川省达州市";
$areanames{zh}->{861318342} = "四川省德阳市";
$areanames{zh}->{861318343} = "四川省绵阳市";
$areanames{zh}->{861318344} = "四川省乐山市";
$areanames{zh}->{861318345} = "四川省泸州市";
$areanames{zh}->{861318346} = "四川省自贡市";
$areanames{zh}->{861318347} = "四川省宜宾市";
$areanames{zh}->{861318348} = "四川省内江市";
$areanames{zh}->{861318349} = "四川省攀枝花市";
$areanames{zh}->{861318350} = "四川省达州市";
$areanames{zh}->{861318351} = "四川省达州市";
$areanames{zh}->{861318352} = "四川省巴中市";
$areanames{zh}->{861318353} = "四川省巴中市";
$areanames{zh}->{861318354} = "四川省广元市";
$areanames{zh}->{861318355} = "四川省广元市";
$areanames{zh}->{861318356} = "四川省广元市";
$areanames{zh}->{861318357} = "四川省遂宁市";
$areanames{zh}->{861318358} = "四川省遂宁市";
$areanames{zh}->{861318359} = "四川省达州市";
$areanames{zh}->{861318360} = "四川省泸州市";
$areanames{zh}->{861318361} = "四川省泸州市";
$areanames{zh}->{861318362} = "四川省乐山市";
$areanames{zh}->{861318363} = "四川省乐山市";
$areanames{zh}->{861318364} = "四川省眉山市";
$areanames{zh}->{861318365} = "四川省眉山市";
$areanames{zh}->{861318366} = "四川省眉山市";
$areanames{zh}->{861318367} = "四川省内江市";
$areanames{zh}->{861318368} = "四川省内江市";
$areanames{zh}->{861318369} = "四川省内江市";
$areanames{zh}->{861318370} = "四川省攀枝花市";
$areanames{zh}->{861318371} = "四川省攀枝花市";
$areanames{zh}->{861318372} = "四川省凉山彝族自治州";
$areanames{zh}->{861318373} = "四川省凉山彝族自治州";
$areanames{zh}->{861318374} = "四川省雅安市";
$areanames{zh}->{861318375} = "四川省南充市";
$areanames{zh}->{861318376} = "四川省南充市";
$areanames{zh}->{861318377} = "四川省绵阳市";
$areanames{zh}->{861318378} = "四川省绵阳市";
$areanames{zh}->{861318379} = "四川省绵阳市";
$areanames{zh}->{86131838} = "四川省成都市";
$areanames{zh}->{861318390} = "四川省广安市";
$areanames{zh}->{861318391} = "四川省广安市";
$areanames{zh}->{861318392} = "四川省自贡市";
$areanames{zh}->{861318393} = "四川省自贡市";
$areanames{zh}->{861318394} = "四川省资阳市";
$areanames{zh}->{861318395} = "四川省资阳市";
$areanames{zh}->{861318396} = "四川省宜宾市";
$areanames{zh}->{861318397} = "四川省宜宾市";
$areanames{zh}->{861318398} = "四川省德阳市";
$areanames{zh}->{861318399} = "四川省德阳市";
$areanames{zh}->{86131840} = "山东省烟台市";
$areanames{zh}->{861318406} = "山东省菏泽市";
$areanames{zh}->{861318407} = "山东省菏泽市";
$areanames{zh}->{861318408} = "山东省菏泽市";
$areanames{zh}->{861318409} = "山东省菏泽市";
$areanames{zh}->{861318410} = "山东省德州市";
$areanames{zh}->{861318411} = "山东省德州市";
$areanames{zh}->{861318412} = "山东省德州市";
$areanames{zh}->{861318413} = "山东省青岛市";
$areanames{zh}->{861318414} = "山东省青岛市";
$areanames{zh}->{861318415} = "山东省聊城市";
$areanames{zh}->{861318416} = "山东省聊城市";
$areanames{zh}->{861318417} = "山东省聊城市";
$areanames{zh}->{861318418} = "山东省威海市";
$areanames{zh}->{861318419} = "山东省威海市";
$areanames{zh}->{861318420} = "浙江省杭州市";
$areanames{zh}->{861318421} = "浙江省杭州市";
$areanames{zh}->{861318422} = "浙江省杭州市";
$areanames{zh}->{861318423} = "浙江省杭州市";
$areanames{zh}->{861318424} = "浙江省杭州市";
$areanames{zh}->{861318425} = "浙江省温州市";
$areanames{zh}->{861318426} = "浙江省温州市";
$areanames{zh}->{861318427} = "浙江省温州市";
$areanames{zh}->{861318428} = "浙江省温州市";
$areanames{zh}->{861318429} = "浙江省温州市";
$areanames{zh}->{861318430} = "浙江省宁波市";
$areanames{zh}->{861318431} = "浙江省宁波市";
$areanames{zh}->{861318432} = "浙江省宁波市";
$areanames{zh}->{861318433} = "浙江省宁波市";
$areanames{zh}->{861318434} = "浙江省宁波市";
$areanames{zh}->{861318435} = "浙江省台州市";
$areanames{zh}->{861318436} = "浙江省台州市";
$areanames{zh}->{861318437} = "浙江省台州市";
$areanames{zh}->{861318438} = "浙江省台州市";
$areanames{zh}->{861318439} = "浙江省台州市";
$areanames{zh}->{861318440} = "浙江省衢州市";
$areanames{zh}->{861318441} = "浙江省杭州市";
$areanames{zh}->{861318442} = "浙江省湖州市";
$areanames{zh}->{861318443} = "浙江省嘉兴市";
$areanames{zh}->{861318444} = "浙江省宁波市";
$areanames{zh}->{861318445} = "浙江省绍兴市";
$areanames{zh}->{861318446} = "浙江省台州市";
$areanames{zh}->{861318447} = "浙江省温州市";
$areanames{zh}->{861318448} = "浙江省丽水市";
$areanames{zh}->{861318449} = "浙江省金华市";
$areanames{zh}->{861318450} = "江西省景德镇市";
$areanames{zh}->{861318451} = "江西省景德镇市";
$areanames{zh}->{861318452} = "江西省赣州市";
$areanames{zh}->{861318453} = "江西省赣州市";
$areanames{zh}->{861318454} = "江西省赣州市";
$areanames{zh}->{861318455} = "江西省萍乡市";
$areanames{zh}->{861318456} = "江西省南昌市";
$areanames{zh}->{861318457} = "江西省南昌市";
$areanames{zh}->{861318458} = "江西省南昌市";
$areanames{zh}->{861318459} = "江西省南昌市";
$areanames{zh}->{861318460} = "江西省九江市";
$areanames{zh}->{861318461} = "江西省九江市";
$areanames{zh}->{861318462} = "江西省九江市";
$areanames{zh}->{861318463} = "江西省上饶市";
$areanames{zh}->{861318464} = "江西省上饶市";
$areanames{zh}->{861318465} = "江西省上饶市";
$areanames{zh}->{861318466} = "江西省宜春市";
$areanames{zh}->{861318467} = "江西省宜春市";
$areanames{zh}->{861318468} = "江西省宜春市";
$areanames{zh}->{861318469} = "江西省吉安市";
$areanames{zh}->{861318470} = "河北省邯郸市";
$areanames{zh}->{861318471} = "河北省邯郸市";
$areanames{zh}->{861318472} = "河北省秦皇岛市";
$areanames{zh}->{861318473} = "河北省廊坊市";
$areanames{zh}->{861318474} = "河北省石家庄市";
$areanames{zh}->{861318475} = "河北省邢台市";
$areanames{zh}->{861318476} = "河北省衡水市";
$areanames{zh}->{861318477} = "河北省石家庄市";
$areanames{zh}->{861318478} = "河北省沧州市";
$areanames{zh}->{861318479} = "河北省唐山市";
$areanames{zh}->{861318480} = "广东省揭阳市";
$areanames{zh}->{861318481} = "广东省揭阳市";
$areanames{zh}->{861318482} = "广东省揭阳市";
$areanames{zh}->{861318483} = "广东省揭阳市";
$areanames{zh}->{861318484} = "广东省揭阳市";
$areanames{zh}->{861318485} = "广东省汕尾市";
$areanames{zh}->{861318486} = "广东省汕尾市";
$areanames{zh}->{861318487} = "广东省汕尾市";
$areanames{zh}->{861318488} = "广东省汕尾市";
$areanames{zh}->{861318489} = "广东省汕尾市";
$areanames{zh}->{861318490} = "河北省保定市";
$areanames{zh}->{861318491} = "河北省唐山市";
$areanames{zh}->{861318492} = "河北省秦皇岛市";
$areanames{zh}->{861318493} = "河北省沧州市";
$areanames{zh}->{861318494} = "河北省保定市";
$areanames{zh}->{861318495} = "河北省邢台市";
$areanames{zh}->{861318496} = "河北省衡水市";
$areanames{zh}->{861318497} = "河北省衡水市";
$areanames{zh}->{861318498} = "河北省沧州市";
$areanames{zh}->{861318499} = "河北省唐山市";
$areanames{zh}->{86131850} = "浙江省杭州市";
$areanames{zh}->{86131851} = "浙江省金华市";
$areanames{zh}->{86131852} = "浙江省湖州市";
$areanames{zh}->{86131853} = "浙江省嘉兴市";
$areanames{zh}->{861318540} = "浙江省嘉兴市";
$areanames{zh}->{861318541} = "浙江省嘉兴市";
$areanames{zh}->{861318542} = "浙江省嘉兴市";
$areanames{zh}->{861318543} = "浙江省嘉兴市";
$areanames{zh}->{861318544} = "浙江省嘉兴市";
$areanames{zh}->{861318545} = "浙江省湖州市";
$areanames{zh}->{861318546} = "浙江省湖州市";
$areanames{zh}->{861318547} = "浙江省湖州市";
$areanames{zh}->{861318548} = "浙江省湖州市";
$areanames{zh}->{861318549} = "浙江省湖州市";
$areanames{zh}->{86131855} = "浙江省绍兴市";
$areanames{zh}->{86131856} = "浙江省台州市";
$areanames{zh}->{861318570} = "浙江省衢州市";
$areanames{zh}->{861318571} = "浙江省杭州市";
$areanames{zh}->{861318572} = "浙江省湖州市";
$areanames{zh}->{861318573} = "浙江省嘉兴市";
$areanames{zh}->{861318574} = "浙江省宁波市";
$areanames{zh}->{861318575} = "浙江省绍兴市";
$areanames{zh}->{861318576} = "浙江省台州市";
$areanames{zh}->{861318577} = "浙江省温州市";
$areanames{zh}->{861318578} = "浙江省丽水市";
$areanames{zh}->{861318579} = "浙江省金华市";
$areanames{zh}->{86131858} = "浙江省温州市";
$areanames{zh}->{861318580} = "浙江省舟山市";
$areanames{zh}->{86131859} = "浙江省宁波市";
$areanames{zh}->{86131860} = "陕西省西安市";
$areanames{zh}->{86131861} = "陕西省西安市";
$areanames{zh}->{861318620} = "陕西省渭南市";
$areanames{zh}->{861318621} = "陕西省渭南市";
$areanames{zh}->{861318622} = "陕西省渭南市";
$areanames{zh}->{861318623} = "陕西省咸阳市";
$areanames{zh}->{861318624} = "陕西省咸阳市";
$areanames{zh}->{861318625} = "陕西省咸阳市";
$areanames{zh}->{861318626} = "陕西省咸阳市";
$areanames{zh}->{861318627} = "陕西省安康市";
$areanames{zh}->{861318628} = "陕西省安康市";
$areanames{zh}->{861318629} = "陕西省安康市";
$areanames{zh}->{86131863} = "陕西省汉中市";
$areanames{zh}->{861318636} = "陕西省宝鸡市";
$areanames{zh}->{861318637} = "陕西省宝鸡市";
$areanames{zh}->{861318638} = "陕西省宝鸡市";
$areanames{zh}->{861318639} = "陕西省宝鸡市";
$areanames{zh}->{861318640} = "江苏省南京市";
$areanames{zh}->{861318641} = "江苏省南京市";
$areanames{zh}->{861318642} = "江苏省南京市";
$areanames{zh}->{861318643} = "江苏省南京市";
$areanames{zh}->{861318644} = "江苏省盐城市";
$areanames{zh}->{861318645} = "江苏省盐城市";
$areanames{zh}->{861318646} = "江苏省连云港市";
$areanames{zh}->{861318647} = "江苏省连云港市";
$areanames{zh}->{861318648} = "江苏省镇江市";
$areanames{zh}->{861318649} = "江苏省镇江市";
$areanames{zh}->{86131865} = "江苏省南通市";
$areanames{zh}->{861318660} = "江苏省连云港市";
$areanames{zh}->{861318661} = "江苏省连云港市";
$areanames{zh}->{861318662} = "江苏省连云港市";
$areanames{zh}->{861318663} = "江苏省镇江市";
$areanames{zh}->{861318664} = "江苏省淮安市";
$areanames{zh}->{861318665} = "江苏省淮安市";
$areanames{zh}->{861318666} = "江苏省常州市";
$areanames{zh}->{861318667} = "江苏省常州市";
$areanames{zh}->{861318668} = "江苏省常州市";
$areanames{zh}->{861318669} = "江苏省常州市";
$areanames{zh}->{861318670} = "浙江省衢州市";
$areanames{zh}->{861318671} = "浙江省衢州市";
$areanames{zh}->{861318672} = "浙江省衢州市";
$areanames{zh}->{861318673} = "浙江省衢州市";
$areanames{zh}->{861318674} = "浙江省丽水市";
$areanames{zh}->{861318675} = "浙江省丽水市";
$areanames{zh}->{861318676} = "浙江省丽水市";
$areanames{zh}->{861318677} = "浙江省舟山市";
$areanames{zh}->{861318678} = "浙江省舟山市";
$areanames{zh}->{861318679} = "浙江省舟山市";
$areanames{zh}->{861318680} = "浙江省温州市";
$areanames{zh}->{861318681} = "浙江省温州市";
$areanames{zh}->{861318682} = "浙江省温州市";
$areanames{zh}->{861318683} = "浙江省温州市";
$areanames{zh}->{861318684} = "浙江省温州市";
$areanames{zh}->{861318685} = "浙江省宁波市";
$areanames{zh}->{861318686} = "浙江省宁波市";
$areanames{zh}->{861318687} = "浙江省宁波市";
$areanames{zh}->{861318688} = "浙江省宁波市";
$areanames{zh}->{861318689} = "浙江省宁波市";
$areanames{zh}->{861318690} = "浙江省台州市";
$areanames{zh}->{861318691} = "浙江省台州市";
$areanames{zh}->{861318692} = "浙江省台州市";
$areanames{zh}->{861318693} = "浙江省台州市";
$areanames{zh}->{861318694} = "浙江省台州市";
$areanames{zh}->{861318695} = "浙江省杭州市";
$areanames{zh}->{861318696} = "浙江省杭州市";
$areanames{zh}->{861318697} = "浙江省杭州市";
$areanames{zh}->{861318698} = "浙江省杭州市";
$areanames{zh}->{861318699} = "浙江省杭州市";
$areanames{zh}->{86131870} = "湖南省长沙市";
$areanames{zh}->{861318710} = "湖南省永州市";
$areanames{zh}->{861318711} = "湖南省永州市";
$areanames{zh}->{861318712} = "湖南省永州市";
$areanames{zh}->{861318713} = "湖南省永州市";
$areanames{zh}->{861318714} = "湖南省怀化市";
$areanames{zh}->{861318715} = "湖南省怀化市";
$areanames{zh}->{861318716} = "湖南省衡阳市";
$areanames{zh}->{861318717} = "湖南省邵阳市";
$areanames{zh}->{861318718} = "湖南省邵阳市";
$areanames{zh}->{861318719} = "湖南省邵阳市";
$areanames{zh}->{861318720} = "湖南省衡阳市";
$areanames{zh}->{861318721} = "湖南省长沙市";
$areanames{zh}->{861318722} = "湖南省湘潭市";
$areanames{zh}->{861318723} = "湖南省衡阳市";
$areanames{zh}->{861318724} = "湖南省衡阳市";
$areanames{zh}->{861318725} = "湖南省郴州市";
$areanames{zh}->{861318726} = "湖南省郴州市";
$areanames{zh}->{861318727} = "湖南省郴州市";
$areanames{zh}->{861318728} = "湖南省邵阳市";
$areanames{zh}->{861318729} = "湖南省邵阳市";
$areanames{zh}->{861318730} = "湖南省衡阳市";
$areanames{zh}->{861318731} = "湖南省长沙市";
$areanames{zh}->{861318732} = "湖南省湘潭市";
$areanames{zh}->{861318733} = "湖南省衡阳市";
$areanames{zh}->{861318734} = "湖南省衡阳市";
$areanames{zh}->{861318735} = "湖南省郴州市";
$areanames{zh}->{861318736} = "湖南省郴州市";
$areanames{zh}->{861318737} = "湖南省益阳市";
$areanames{zh}->{861318738} = "湖南省邵阳市";
$areanames{zh}->{861318739} = "湖南省邵阳市";
$areanames{zh}->{861318740} = "云南省昆明市";
$areanames{zh}->{861318741} = "云南省昆明市";
$areanames{zh}->{861318742} = "云南省昆明市";
$areanames{zh}->{861318743} = "云南省昆明市";
$areanames{zh}->{861318744} = "云南省昆明市";
$areanames{zh}->{861318745} = "云南省曲靖市";
$areanames{zh}->{861318746} = "云南省大理白族自治州";
$areanames{zh}->{861318747} = "云南省临沧市";
$areanames{zh}->{861318748} = "云南省迪庆藏族自治州";
$areanames{zh}->{861318749} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861318750} = "云南省保山市";
$areanames{zh}->{861318751} = "云南省保山市";
$areanames{zh}->{861318752} = "云南省保山市";
$areanames{zh}->{861318753} = "云南省保山市";
$areanames{zh}->{861318754} = "云南省昭通市";
$areanames{zh}->{861318755} = "云南省昭通市";
$areanames{zh}->{861318756} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861318757} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861318758} = "云南省临沧市";
$areanames{zh}->{861318759} = "云南省临沧市";
$areanames{zh}->{861318760} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861318761} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861318762} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861318763} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861318764} = "云南省楚雄彝族自治州";
$areanames{zh}->{861318765} = "云南省楚雄彝族自治州";
$areanames{zh}->{861318766} = "云南省楚雄彝族自治州";
$areanames{zh}->{861318767} = "云南省楚雄彝族自治州";
$areanames{zh}->{861318768} = "云南省大理白族自治州";
$areanames{zh}->{861318769} = "云南省大理白族自治州";
$areanames{zh}->{861318770} = "云南省昆明市";
$areanames{zh}->{861318771} = "云南省玉溪市";
$areanames{zh}->{861318772} = "云南省玉溪市";
$areanames{zh}->{861318773} = "云南省玉溪市";
$areanames{zh}->{861318774} = "云南省玉溪市";
$areanames{zh}->{861318775} = "云南省丽江市";
$areanames{zh}->{861318776} = "云南省曲靖市";
$areanames{zh}->{861318777} = "云南省曲靖市";
$areanames{zh}->{861318778} = "云南省曲靖市";
$areanames{zh}->{861318779} = "云南省丽江市";
$areanames{zh}->{86131878} = "云南省昆明市";
$areanames{zh}->{861318780} = "云南省楚雄彝族自治州";
$areanames{zh}->{861318790} = "云南省普洱市";
$areanames{zh}->{861318791} = "云南省普洱市";
$areanames{zh}->{861318792} = "云南省普洱市";
$areanames{zh}->{861318793} = "云南省普洱市";
$areanames{zh}->{861318794} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861318795} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861318796} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861318797} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861318798} = "云南省迪庆藏族自治州";
$areanames{zh}->{861318799} = "云南省怒江傈僳族自治州";
$areanames{zh}->{86131880} = "辽宁省鞍山市";
$areanames{zh}->{861318810} = "辽宁省锦州市";
$areanames{zh}->{861318811} = "辽宁省锦州市";
$areanames{zh}->{861318812} = "辽宁省锦州市";
$areanames{zh}->{861318813} = "辽宁省锦州市";
$areanames{zh}->{861318814} = "辽宁省锦州市";
$areanames{zh}->{861318815} = "辽宁省朝阳市";
$areanames{zh}->{861318816} = "辽宁省朝阳市";
$areanames{zh}->{861318817} = "辽宁省朝阳市";
$areanames{zh}->{861318818} = "辽宁省朝阳市";
$areanames{zh}->{861318819} = "辽宁省朝阳市";
$areanames{zh}->{861318820} = "辽宁省本溪市";
$areanames{zh}->{861318821} = "辽宁省本溪市";
$areanames{zh}->{861318822} = "辽宁省本溪市";
$areanames{zh}->{861318823} = "辽宁省本溪市";
$areanames{zh}->{861318824} = "辽宁省本溪市";
$areanames{zh}->{861318825} = "辽宁省抚顺市";
$areanames{zh}->{861318826} = "辽宁省抚顺市";
$areanames{zh}->{861318827} = "辽宁省抚顺市";
$areanames{zh}->{861318828} = "辽宁省抚顺市";
$areanames{zh}->{861318829} = "辽宁省抚顺市";
$areanames{zh}->{861318830} = "辽宁省阜新市";
$areanames{zh}->{861318831} = "辽宁省阜新市";
$areanames{zh}->{861318832} = "辽宁省阜新市";
$areanames{zh}->{861318833} = "辽宁省阜新市";
$areanames{zh}->{861318834} = "辽宁省阜新市";
$areanames{zh}->{861318835} = "辽宁省丹东市";
$areanames{zh}->{861318836} = "辽宁省丹东市";
$areanames{zh}->{861318837} = "辽宁省丹东市";
$areanames{zh}->{861318838} = "辽宁省丹东市";
$areanames{zh}->{861318839} = "辽宁省丹东市";
$areanames{zh}->{861318840} = "辽宁省铁岭市";
$areanames{zh}->{861318841} = "辽宁省铁岭市";
$areanames{zh}->{861318842} = "辽宁省铁岭市";
$areanames{zh}->{861318843} = "辽宁省铁岭市";
$areanames{zh}->{861318844} = "辽宁省铁岭市";
$areanames{zh}->{861318845} = "辽宁省辽阳市";
$areanames{zh}->{861318846} = "辽宁省辽阳市";
$areanames{zh}->{861318847} = "辽宁省辽阳市";
$areanames{zh}->{861318848} = "辽宁省辽阳市";
$areanames{zh}->{861318849} = "辽宁省辽阳市";
$areanames{zh}->{861318850} = "辽宁省葫芦岛市";
$areanames{zh}->{861318851} = "辽宁省葫芦岛市";
$areanames{zh}->{861318852} = "辽宁省葫芦岛市";
$areanames{zh}->{861318853} = "辽宁省葫芦岛市";
$areanames{zh}->{861318854} = "辽宁省葫芦岛市";
$areanames{zh}->{861318855} = "辽宁省盘锦市";
$areanames{zh}->{861318856} = "辽宁省盘锦市";
$areanames{zh}->{861318857} = "辽宁省盘锦市";
$areanames{zh}->{861318858} = "辽宁省盘锦市";
$areanames{zh}->{861318859} = "辽宁省盘锦市";
$areanames{zh}->{861318860} = "辽宁省辽阳市";
$areanames{zh}->{861318861} = "辽宁省辽阳市";
$areanames{zh}->{861318862} = "辽宁省辽阳市";
$areanames{zh}->{861318863} = "辽宁省辽阳市";
$areanames{zh}->{861318864} = "辽宁省辽阳市";
$areanames{zh}->{861318865} = "辽宁省铁岭市";
$areanames{zh}->{861318866} = "辽宁省铁岭市";
$areanames{zh}->{861318867} = "辽宁省铁岭市";
$areanames{zh}->{861318868} = "辽宁省铁岭市";
$areanames{zh}->{861318869} = "辽宁省铁岭市";
$areanames{zh}->{861318870} = "山东省临沂市";
$areanames{zh}->{861318871} = "山东省临沂市";
$areanames{zh}->{861318872} = "山东省临沂市";
$areanames{zh}->{861318873} = "山东省临沂市";
$areanames{zh}->{861318874} = "山东省聊城市";
$areanames{zh}->{861318875} = "山东省聊城市";
$areanames{zh}->{861318876} = "山东省烟台市";
$areanames{zh}->{861318877} = "山东省烟台市";
$areanames{zh}->{861318878} = "山东省烟台市";
$areanames{zh}->{861318879} = "山东省烟台市";
$areanames{zh}->{861318880} = "山东省济宁市";
$areanames{zh}->{861318881} = "山东省济宁市";
$areanames{zh}->{861318882} = "山东省济宁市";
$areanames{zh}->{861318883} = "山东省潍坊市";
$areanames{zh}->{861318884} = "山东省潍坊市";
$areanames{zh}->{861318885} = "山东省潍坊市";
$areanames{zh}->{861318886} = "山东省潍坊市";
$areanames{zh}->{861318887} = "山东省济南市";
$areanames{zh}->{861318888} = "山东省济南市";
$areanames{zh}->{861318889} = "山东省济南市";
$areanames{zh}->{861318890} = "山东省滨州市";
$areanames{zh}->{861318891} = "山东省滨州市";
$areanames{zh}->{861318892} = "山东省枣庄市";
$areanames{zh}->{861318893} = "山东省济南市";
$areanames{zh}->{861318894} = "山东省济南市";
$areanames{zh}->{861318895} = "山东省青岛市";
$areanames{zh}->{861318896} = "山东省青岛市";
$areanames{zh}->{861318897} = "山东省青岛市";
$areanames{zh}->{861318898} = "山东省青岛市";
$areanames{zh}->{861318899} = "山东省青岛市";
$areanames{zh}->{86131890} = "广东省广州市";
$areanames{zh}->{86131891} = "广东省广州市";
$areanames{zh}->{86131892} = "广东省中山市";
$areanames{zh}->{86131893} = "广东省肇庆市";
$areanames{zh}->{861318940} = "广东省江门市";
$areanames{zh}->{861318941} = "广东省江门市";
$areanames{zh}->{861318942} = "广东省江门市";
$areanames{zh}->{861318943} = "广东省江门市";
$areanames{zh}->{861318944} = "广东省江门市";
$areanames{zh}->{861318945} = "广东省湛江市";
$areanames{zh}->{861318946} = "广东省湛江市";
$areanames{zh}->{861318947} = "广东省湛江市";
$areanames{zh}->{861318948} = "广东省湛江市";
$areanames{zh}->{861318949} = "广东省湛江市";
$areanames{zh}->{86131895} = "广东省茂名市";
$areanames{zh}->{86131896} = "广东省佛山市";
$areanames{zh}->{86131897} = "广东省深圳市";
$areanames{zh}->{861318979} = "河北省石家庄市";
$areanames{zh}->{861318980} = "广东省湛江市";
$areanames{zh}->{861318981} = "广东省湛江市";
$areanames{zh}->{861318982} = "广东省湛江市";
$areanames{zh}->{861318983} = "广东省湛江市";
$areanames{zh}->{861318984} = "广东省湛江市";
$areanames{zh}->{861318985} = "广东省江门市";
$areanames{zh}->{861318986} = "广东省江门市";
$areanames{zh}->{861318987} = "广东省江门市";
$areanames{zh}->{861318988} = "广东省江门市";
$areanames{zh}->{861318989} = "广东省江门市";
$areanames{zh}->{86131899} = "广东省梅州市";
$areanames{zh}->{86131900} = "辽宁省沈阳市";
$areanames{zh}->{86131901} = "辽宁省大连市";
$areanames{zh}->{861319020} = "辽宁省丹东市";
$areanames{zh}->{861319021} = "辽宁省丹东市";
$areanames{zh}->{861319022} = "辽宁省丹东市";
$areanames{zh}->{861319023} = "辽宁省丹东市";
$areanames{zh}->{861319024} = "辽宁省丹东市";
$areanames{zh}->{861319025} = "辽宁省朝阳市";
$areanames{zh}->{861319026} = "辽宁省朝阳市";
$areanames{zh}->{861319027} = "辽宁省阜新市";
$areanames{zh}->{861319028} = "辽宁省阜新市";
$areanames{zh}->{861319029} = "辽宁省阜新市";
$areanames{zh}->{861319030} = "辽宁省盘锦市";
$areanames{zh}->{861319031} = "辽宁省盘锦市";
$areanames{zh}->{861319032} = "辽宁省盘锦市";
$areanames{zh}->{861319033} = "辽宁省盘锦市";
$areanames{zh}->{861319034} = "辽宁省盘锦市";
$areanames{zh}->{861319035} = "辽宁省葫芦岛市";
$areanames{zh}->{861319036} = "辽宁省葫芦岛市";
$areanames{zh}->{861319037} = "辽宁省葫芦岛市";
$areanames{zh}->{861319038} = "辽宁省葫芦岛市";
$areanames{zh}->{861319039} = "辽宁省葫芦岛市";
$areanames{zh}->{861319040} = "辽宁省锦州市";
$areanames{zh}->{861319041} = "辽宁省锦州市";
$areanames{zh}->{861319042} = "辽宁省锦州市";
$areanames{zh}->{861319043} = "辽宁省锦州市";
$areanames{zh}->{861319044} = "辽宁省锦州市";
$areanames{zh}->{861319045} = "辽宁省本溪市";
$areanames{zh}->{861319046} = "辽宁省本溪市";
$areanames{zh}->{861319047} = "辽宁省本溪市";
$areanames{zh}->{861319048} = "辽宁省本溪市";
$areanames{zh}->{861319049} = "辽宁省本溪市";
$areanames{zh}->{86131905} = "内蒙古呼和浩特市";
$areanames{zh}->{861319056} = "内蒙古通辽市";
$areanames{zh}->{861319057} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861319058} = "内蒙古乌海市";
$areanames{zh}->{861319059} = "内蒙古乌兰察布市";
$areanames{zh}->{861319060} = "内蒙古呼和浩特市";
$areanames{zh}->{861319061} = "内蒙古阿拉善盟";
$areanames{zh}->{861319062} = "内蒙古乌兰察布市";
$areanames{zh}->{861319063} = "内蒙古乌兰察布市";
$areanames{zh}->{861319064} = "内蒙古乌兰察布市";
$areanames{zh}->{861319065} = "内蒙古乌兰察布市";
$areanames{zh}->{861319066} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861319067} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861319068} = "内蒙古乌海市";
$areanames{zh}->{861319069} = "内蒙古包头市";
$areanames{zh}->{86131907} = "内蒙古包头市";
$areanames{zh}->{861319076} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319077} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319078} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319079} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319080} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319081} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319082} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319083} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319084} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319085} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319086} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319087} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319088} = "内蒙古通辽市";
$areanames{zh}->{861319089} = "内蒙古通辽市";
$areanames{zh}->{861319090} = "内蒙古赤峰市";
$areanames{zh}->{861319091} = "内蒙古赤峰市";
$areanames{zh}->{861319092} = "内蒙古赤峰市";
$areanames{zh}->{861319093} = "内蒙古赤峰市";
$areanames{zh}->{861319094} = "内蒙古赤峰市";
$areanames{zh}->{861319095} = "内蒙古兴安盟";
$areanames{zh}->{861319096} = "内蒙古兴安盟";
$areanames{zh}->{861319097} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319098} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319099} = "内蒙古呼伦贝尔市";
$areanames{zh}->{86131910} = "山西省太原市";
$areanames{zh}->{861319101} = "山西省晋中市";
$areanames{zh}->{861319102} = "山西省朔州市";
$areanames{zh}->{861319103} = "山西省长治市";
$areanames{zh}->{861319110} = "山西省忻州市";
$areanames{zh}->{861319111} = "山西省临汾市";
$areanames{zh}->{861319112} = "山西省大同市";
$areanames{zh}->{861319113} = "山西省阳泉市";
$areanames{zh}->{861319114} = "山西省晋中市";
$areanames{zh}->{861319115} = "山西省长治市";
$areanames{zh}->{861319116} = "山西省晋城市";
$areanames{zh}->{861319117} = "山西省临汾市";
$areanames{zh}->{861319118} = "山西省吕梁市";
$areanames{zh}->{861319119} = "山西省运城市";
$areanames{zh}->{861319120} = "山西省忻州市";
$areanames{zh}->{861319121} = "山西省吕梁市";
$areanames{zh}->{861319122} = "山西省大同市";
$areanames{zh}->{861319123} = "山西省阳泉市";
$areanames{zh}->{861319124} = "山西省运城市";
$areanames{zh}->{861319125} = "山西省长治市";
$areanames{zh}->{861319126} = "山西省晋城市";
$areanames{zh}->{861319127} = "山西省临汾市";
$areanames{zh}->{861319128} = "山西省大同市";
$areanames{zh}->{861319129} = "山西省运城市";
$areanames{zh}->{861319130} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319131} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319132} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319133} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319134} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861319135} = "内蒙古乌海市";
$areanames{zh}->{861319136} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319137} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861319138} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861319139} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86131914} = "内蒙古包头市";
$areanames{zh}->{861319140} = "内蒙古呼和浩特市";
$areanames{zh}->{861319141} = "内蒙古呼和浩特市";
$areanames{zh}->{861319142} = "内蒙古呼和浩特市";
$areanames{zh}->{861319143} = "内蒙古呼和浩特市";
$areanames{zh}->{861319150} = "内蒙古赤峰市";
$areanames{zh}->{861319151} = "内蒙古赤峰市";
$areanames{zh}->{861319152} = "内蒙古赤峰市";
$areanames{zh}->{861319153} = "内蒙古通辽市";
$areanames{zh}->{861319154} = "内蒙古通辽市";
$areanames{zh}->{861319155} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861319156} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861319157} = "内蒙古乌兰察布市";
$areanames{zh}->{861319158} = "内蒙古乌兰察布市";
$areanames{zh}->{861319159} = "内蒙古兴安盟";
$areanames{zh}->{861319160} = "河北省邢台市";
$areanames{zh}->{861319161} = "河北省邢台市";
$areanames{zh}->{861319162} = "河北省邢台市";
$areanames{zh}->{861319163} = "河北省承德市";
$areanames{zh}->{861319164} = "河北省保定市";
$areanames{zh}->{861319165} = "河北省保定市";
$areanames{zh}->{861319166} = "河北省保定市";
$areanames{zh}->{861319167} = "河北省保定市";
$areanames{zh}->{861319168} = "河北省保定市";
$areanames{zh}->{861319169} = "河北省衡水市";
$areanames{zh}->{861319170} = "河北省邯郸市";
$areanames{zh}->{861319171} = "河北省邯郸市";
$areanames{zh}->{861319172} = "河北省邯郸市";
$areanames{zh}->{861319173} = "河北省邯郸市";
$areanames{zh}->{861319174} = "河北省唐山市";
$areanames{zh}->{861319175} = "河北省唐山市";
$areanames{zh}->{861319176} = "河北省唐山市";
$areanames{zh}->{861319177} = "河北省唐山市";
$areanames{zh}->{861319178} = "河北省唐山市";
$areanames{zh}->{861319179} = "河北省张家口市";
$areanames{zh}->{861319180} = "河北省秦皇岛市";
$areanames{zh}->{861319181} = "河北省秦皇岛市";
$areanames{zh}->{861319182} = "河北省秦皇岛市";
$areanames{zh}->{861319183} = "河北省秦皇岛市";
$areanames{zh}->{861319184} = "河北省石家庄市";
$areanames{zh}->{861319185} = "河北省石家庄市";
$areanames{zh}->{861319186} = "河北省石家庄市";
$areanames{zh}->{861319187} = "河北省石家庄市";
$areanames{zh}->{861319188} = "河北省石家庄市";
$areanames{zh}->{861319189} = "河北省承德市";
$areanames{zh}->{861319190} = "河北省衡水市";
$areanames{zh}->{861319191} = "河北省张家口市";
$areanames{zh}->{861319192} = "河北省沧州市";
$areanames{zh}->{861319193} = "河北省沧州市";
$areanames{zh}->{861319194} = "河北省沧州市";
$areanames{zh}->{861319195} = "河北省廊坊市";
$areanames{zh}->{861319196} = "河北省廊坊市";
$areanames{zh}->{861319197} = "河北省廊坊市";
$areanames{zh}->{861319198} = "河北省廊坊市";
$areanames{zh}->{861319199} = "河北省沧州市";
$areanames{zh}->{86131920} = "广东省东莞市";
$areanames{zh}->{861319210} = "广东省潮州市";
$areanames{zh}->{861319211} = "广东省潮州市";
$areanames{zh}->{861319212} = "广东省潮州市";
$areanames{zh}->{861319213} = "广东省潮州市";
$areanames{zh}->{861319214} = "广东省潮州市";
$areanames{zh}->{861319215} = "广东省汕头市";
$areanames{zh}->{861319216} = "广东省汕头市";
$areanames{zh}->{861319217} = "广东省汕头市";
$areanames{zh}->{861319218} = "广东省汕头市";
$areanames{zh}->{861319219} = "广东省汕头市";
$areanames{zh}->{86131922} = "广东省珠海市";
$areanames{zh}->{86131923} = "广东省汕头市";
$areanames{zh}->{861319240} = "广东省韶关市";
$areanames{zh}->{861319241} = "广东省韶关市";
$areanames{zh}->{861319242} = "广东省韶关市";
$areanames{zh}->{861319243} = "广东省韶关市";
$areanames{zh}->{861319244} = "广东省韶关市";
$areanames{zh}->{861319245} = "广东省惠州市";
$areanames{zh}->{861319246} = "广东省惠州市";
$areanames{zh}->{861319247} = "广东省惠州市";
$areanames{zh}->{861319248} = "广东省惠州市";
$areanames{zh}->{861319249} = "广东省惠州市";
$areanames{zh}->{861319250} = "广东省汕尾市";
$areanames{zh}->{861319251} = "广东省汕尾市";
$areanames{zh}->{861319252} = "广东省汕尾市";
$areanames{zh}->{861319253} = "广东省汕尾市";
$areanames{zh}->{861319254} = "广东省汕尾市";
$areanames{zh}->{861319255} = "广东省阳江市";
$areanames{zh}->{861319256} = "广东省阳江市";
$areanames{zh}->{861319257} = "广东省阳江市";
$areanames{zh}->{861319258} = "广东省阳江市";
$areanames{zh}->{861319259} = "广东省阳江市";
$areanames{zh}->{861319260} = "广东省云浮市";
$areanames{zh}->{861319261} = "广东省云浮市";
$areanames{zh}->{861319262} = "广东省云浮市";
$areanames{zh}->{861319263} = "广东省云浮市";
$areanames{zh}->{861319264} = "广东省云浮市";
$areanames{zh}->{861319265} = "广东省佛山市";
$areanames{zh}->{861319266} = "广东省佛山市";
$areanames{zh}->{861319267} = "广东省佛山市";
$areanames{zh}->{861319268} = "广东省佛山市";
$areanames{zh}->{861319269} = "广东省佛山市";
$areanames{zh}->{861319270} = "广东省河源市";
$areanames{zh}->{861319271} = "广东省河源市";
$areanames{zh}->{861319272} = "广东省河源市";
$areanames{zh}->{861319273} = "广东省河源市";
$areanames{zh}->{861319274} = "广东省河源市";
$areanames{zh}->{861319275} = "广东省清远市";
$areanames{zh}->{861319276} = "广东省清远市";
$areanames{zh}->{861319277} = "广东省清远市";
$areanames{zh}->{861319278} = "广东省清远市";
$areanames{zh}->{861319279} = "广东省清远市";
$areanames{zh}->{861319280} = "广东省惠州市";
$areanames{zh}->{861319281} = "广东省惠州市";
$areanames{zh}->{861319282} = "广东省惠州市";
$areanames{zh}->{861319283} = "广东省惠州市";
$areanames{zh}->{861319284} = "广东省惠州市";
$areanames{zh}->{861319285} = "广东省韶关市";
$areanames{zh}->{861319286} = "广东省韶关市";
$areanames{zh}->{861319287} = "广东省韶关市";
$areanames{zh}->{861319288} = "广东省韶关市";
$areanames{zh}->{861319289} = "广东省韶关市";
$areanames{zh}->{86131929} = "广东省揭阳市";
$areanames{zh}->{86131930} = "重庆市";
$areanames{zh}->{86131931} = "重庆市";
$areanames{zh}->{86131932} = "重庆市";
$areanames{zh}->{86131933} = "陕西省西安市";
$areanames{zh}->{861319340} = "河南省商丘市";
$areanames{zh}->{861319341} = "河南省商丘市";
$areanames{zh}->{861319342} = "河南省商丘市";
$areanames{zh}->{861319343} = "河南省许昌市";
$areanames{zh}->{861319344} = "河南省许昌市";
$areanames{zh}->{861319345} = "河南省许昌市";
$areanames{zh}->{861319346} = "河南省许昌市";
$areanames{zh}->{861319347} = "河南省鹤壁市";
$areanames{zh}->{861319348} = "河南省鹤壁市";
$areanames{zh}->{861319349} = "河南省鹤壁市";
$areanames{zh}->{861319350} = "河南省安阳市";
$areanames{zh}->{861319351} = "河南省安阳市";
$areanames{zh}->{861319352} = "河南省安阳市";
$areanames{zh}->{861319353} = "河南省安阳市";
$areanames{zh}->{861319354} = "河南省安阳市";
$areanames{zh}->{861319355} = "河南省濮阳市";
$areanames{zh}->{861319356} = "河南省濮阳市";
$areanames{zh}->{861319357} = "河南省濮阳市";
$areanames{zh}->{861319358} = "河南省濮阳市";
$areanames{zh}->{861319359} = "河南省濮阳市";
$areanames{zh}->{861319360} = "河南省周口市";
$areanames{zh}->{861319361} = "河南省周口市";
$areanames{zh}->{861319362} = "河南省周口市";
$areanames{zh}->{861319363} = "河南省周口市";
$areanames{zh}->{861319364} = "河南省周口市";
$areanames{zh}->{861319365} = "河南省南阳市";
$areanames{zh}->{861319366} = "河南省南阳市";
$areanames{zh}->{861319367} = "河南省南阳市";
$areanames{zh}->{861319368} = "河南省南阳市";
$areanames{zh}->{861319369} = "河南省南阳市";
$areanames{zh}->{861319370} = "河南省驻马店市";
$areanames{zh}->{861319371} = "河南省驻马店市";
$areanames{zh}->{861319372} = "河南省驻马店市";
$areanames{zh}->{861319373} = "河南省驻马店市";
$areanames{zh}->{861319374} = "河南省驻马店市";
$areanames{zh}->{861319375} = "河南省开封市";
$areanames{zh}->{861319376} = "河南省开封市";
$areanames{zh}->{861319377} = "河南省开封市";
$areanames{zh}->{861319378} = "河南省开封市";
$areanames{zh}->{861319379} = "河南省开封市";
$areanames{zh}->{861319380} = "河南省南阳市";
$areanames{zh}->{861319381} = "河南省南阳市";
$areanames{zh}->{861319382} = "河南省南阳市";
$areanames{zh}->{861319383} = "河南省南阳市";
$areanames{zh}->{861319384} = "河南省南阳市";
$areanames{zh}->{861319385} = "河南省信阳市";
$areanames{zh}->{861319386} = "河南省信阳市";
$areanames{zh}->{861319387} = "河南省信阳市";
$areanames{zh}->{861319388} = "河南省信阳市";
$areanames{zh}->{861319389} = "河南省信阳市";
$areanames{zh}->{86131939} = "河南省三门峡市";
$areanames{zh}->{861319390} = "河南省漯河市";
$areanames{zh}->{861319391} = "河南省漯河市";
$areanames{zh}->{861319392} = "河南省漯河市";
$areanames{zh}->{861319393} = "河南省漯河市";
$areanames{zh}->{861319400} = "福建省三明市";
$areanames{zh}->{861319401} = "福建省南平市";
$areanames{zh}->{861319402} = "福建省南平市";
$areanames{zh}->{861319403} = "福建省宁德市";
$areanames{zh}->{861319404} = "河南省平顶山市";
$areanames{zh}->{861319405} = "福建省南平市";
$areanames{zh}->{861319406} = "福建省泉州市";
$areanames{zh}->{861319407} = "福建省厦门市";
$areanames{zh}->{861319408} = "福建省厦门市";
$areanames{zh}->{861319409} = "福建省厦门市";
$areanames{zh}->{861319410} = "辽宁省铁岭市";
$areanames{zh}->{861319411} = "辽宁省大连市";
$areanames{zh}->{861319412} = "辽宁省鞍山市";
$areanames{zh}->{861319413} = "辽宁省抚顺市";
$areanames{zh}->{861319414} = "辽宁省本溪市";
$areanames{zh}->{861319415} = "辽宁省丹东市";
$areanames{zh}->{861319416} = "辽宁省锦州市";
$areanames{zh}->{861319417} = "辽宁省营口市";
$areanames{zh}->{861319418} = "辽宁省阜新市";
$areanames{zh}->{861319419} = "辽宁省辽阳市";
$areanames{zh}->{861319420} = "辽宁省沈阳市";
$areanames{zh}->{861319421} = "辽宁省朝阳市";
$areanames{zh}->{861319422} = "辽宁省沈阳市";
$areanames{zh}->{861319423} = "辽宁省沈阳市";
$areanames{zh}->{861319424} = "辽宁省沈阳市";
$areanames{zh}->{861319425} = "辽宁省鞍山市";
$areanames{zh}->{861319426} = "辽宁省大连市";
$areanames{zh}->{861319427} = "辽宁省盘锦市";
$areanames{zh}->{861319428} = "辽宁省大连市";
$areanames{zh}->{861319429} = "辽宁省葫芦岛市";
$areanames{zh}->{86131943} = "吉林省长春市";
$areanames{zh}->{861319432} = "吉林省吉林市";
$areanames{zh}->{861319433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861319434} = "吉林省四平市";
$areanames{zh}->{861319440} = "福建省莆田市";
$areanames{zh}->{861319441} = "福建省莆田市";
$areanames{zh}->{861319442} = "福建省莆田市";
$areanames{zh}->{861319443} = "福建省莆田市";
$areanames{zh}->{861319444} = "福建省莆田市";
$areanames{zh}->{861319445} = "福建省福州市";
$areanames{zh}->{861319446} = "福建省福州市";
$areanames{zh}->{861319447} = "福建省福州市";
$areanames{zh}->{861319448} = "福建省龙岩市";
$areanames{zh}->{861319449} = "福建省龙岩市";
$areanames{zh}->{861319450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861319451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861319452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861319453} = "黑龙江省牡丹江市";
$areanames{zh}->{861319454} = "黑龙江省佳木斯市";
$areanames{zh}->{861319455} = "黑龙江省绥化市";
$areanames{zh}->{861319456} = "黑龙江省黑河市";
$areanames{zh}->{861319457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861319458} = "黑龙江省伊春市";
$areanames{zh}->{861319459} = "黑龙江省大庆市";
$areanames{zh}->{86131946} = "天津市";
$areanames{zh}->{861319470} = "四川省雅安市";
$areanames{zh}->{861319471} = "四川省雅安市";
$areanames{zh}->{861319472} = "四川省广元市";
$areanames{zh}->{861319473} = "四川省广元市";
$areanames{zh}->{861319474} = "四川省巴中市";
$areanames{zh}->{861319475} = "四川省自贡市";
$areanames{zh}->{861319476} = "四川省眉山市";
$areanames{zh}->{861319477} = "四川省乐山市";
$areanames{zh}->{861319478} = "四川省资阳市";
$areanames{zh}->{861319479} = "四川省资阳市";
$areanames{zh}->{861319480} = "四川省遂宁市";
$areanames{zh}->{861319481} = "四川省广安市";
$areanames{zh}->{861319482} = "四川省绵阳市";
$areanames{zh}->{861319483} = "四川省绵阳市";
$areanames{zh}->{861319484} = "四川省德阳市";
$areanames{zh}->{861319485} = "四川省德阳市";
$areanames{zh}->{861319486} = "四川省成都市";
$areanames{zh}->{861319487} = "四川省成都市";
$areanames{zh}->{861319488} = "四川省成都市";
$areanames{zh}->{861319489} = "四川省成都市";
$areanames{zh}->{861319490} = "四川省内江市";
$areanames{zh}->{861319491} = "四川省自贡市";
$areanames{zh}->{861319492} = "四川省泸州市";
$areanames{zh}->{861319493} = "四川省宜宾市";
$areanames{zh}->{861319494} = "四川省攀枝花市";
$areanames{zh}->{861319495} = "四川省凉山彝族自治州";
$areanames{zh}->{861319496} = "四川省成都市";
$areanames{zh}->{861319497} = "四川省成都市";
$areanames{zh}->{861319498} = "四川省成都市";
$areanames{zh}->{861319499} = "四川省成都市";
$areanames{zh}->{861319500} = "宁夏银川市";
$areanames{zh}->{861319501} = "宁夏银川市";
$areanames{zh}->{861319502} = "宁夏石嘴山市";
$areanames{zh}->{861319503} = "宁夏吴忠市";
$areanames{zh}->{861319504} = "宁夏固原市";
$areanames{zh}->{861319505} = "宁夏吴忠市";
$areanames{zh}->{861319506} = "宁夏石嘴山市";
$areanames{zh}->{861319507} = "宁夏吴忠市";
$areanames{zh}->{861319508} = "宁夏银川市";
$areanames{zh}->{861319509} = "宁夏银川市";
$areanames{zh}->{861319510} = "贵州省贵阳市";
$areanames{zh}->{861319511} = "贵州省贵阳市";
$areanames{zh}->{861319512} = "贵州省遵义市";
$areanames{zh}->{861319513} = "贵州省安顺市";
$areanames{zh}->{861319514} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861319515} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861319516} = "贵州省铜仁地区";
$areanames{zh}->{861319517} = "贵州省毕节地区";
$areanames{zh}->{861319518} = "贵州省六盘水市";
$areanames{zh}->{861319519} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861319520} = "贵州省贵阳市";
$areanames{zh}->{861319521} = "贵州省贵阳市";
$areanames{zh}->{861319522} = "贵州省遵义市";
$areanames{zh}->{861319523} = "贵州省安顺市";
$areanames{zh}->{861319524} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861319525} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861319526} = "贵州省铜仁地区";
$areanames{zh}->{861319527} = "贵州省毕节地区";
$areanames{zh}->{861319528} = "贵州省六盘水市";
$areanames{zh}->{861319529} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861319530} = "安徽省池州市";
$areanames{zh}->{861319531} = "安徽省芜湖市";
$areanames{zh}->{861319532} = "安徽省芜湖市";
$areanames{zh}->{861319533} = "安徽省芜湖市";
$areanames{zh}->{861319534} = "安徽省宣城市";
$areanames{zh}->{861319535} = "安徽省宣城市";
$areanames{zh}->{861319536} = "安徽省宣城市";
$areanames{zh}->{861319537} = "安徽省六安市";
$areanames{zh}->{861319538} = "安徽省六安市";
$areanames{zh}->{861319539} = "安徽省六安市";
$areanames{zh}->{861319540} = "安徽省亳州市";
$areanames{zh}->{861319541} = "安徽省亳州市";
$areanames{zh}->{861319542} = "安徽省蚌埠市";
$areanames{zh}->{861319543} = "安徽省蚌埠市";
$areanames{zh}->{861319544} = "安徽省芜湖市";
$areanames{zh}->{861319545} = "安徽省合肥市";
$areanames{zh}->{861319546} = "安徽省马鞍山市";
$areanames{zh}->{861319547} = "安徽省淮南市";
$areanames{zh}->{861319548} = "安徽省阜阳市";
$areanames{zh}->{861319549} = "安徽省池州市";
$areanames{zh}->{861319550} = "安徽省滁州市";
$areanames{zh}->{861319551} = "安徽省合肥市";
$areanames{zh}->{861319552} = "安徽省蚌埠市";
$areanames{zh}->{861319553} = "安徽省芜湖市";
$areanames{zh}->{861319554} = "安徽省淮南市";
$areanames{zh}->{861319555} = "安徽省马鞍山市";
$areanames{zh}->{861319556} = "安徽省安庆市";
$areanames{zh}->{861319557} = "安徽省宿州市";
$areanames{zh}->{861319558} = "安徽省阜阳市";
$areanames{zh}->{861319559} = "安徽省黄山市";
$areanames{zh}->{861319560} = "安徽省淮北市";
$areanames{zh}->{861319561} = "安徽省淮北市";
$areanames{zh}->{861319562} = "安徽省铜陵市";
$areanames{zh}->{861319563} = "安徽省宣城市";
$areanames{zh}->{861319564} = "安徽省六安市";
$areanames{zh}->{861319565} = "安徽省合肥市";
$areanames{zh}->{861319566} = "安徽省池州市";
$areanames{zh}->{861319567} = "安徽省亳州市";
$areanames{zh}->{861319568} = "安徽省亳州市";
$areanames{zh}->{861319569} = "安徽省淮北市";
$areanames{zh}->{861319570} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861319571} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861319572} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861319573} = "青海省海东地区";
$areanames{zh}->{861319574} = "青海省海东地区";
$areanames{zh}->{861319575} = "青海省西宁市";
$areanames{zh}->{861319576} = "青海省西宁市";
$areanames{zh}->{861319577} = "青海省西宁市";
$areanames{zh}->{861319578} = "青海省西宁市";
$areanames{zh}->{861319579} = "青海省西宁市";
$areanames{zh}->{861319580} = "甘肃省陇南市";
$areanames{zh}->{861319581} = "甘肃省天水市";
$areanames{zh}->{861319582} = "甘肃省定西市";
$areanames{zh}->{861319583} = "甘肃省兰州市";
$areanames{zh}->{861319584} = "甘肃省庆阳市";
$areanames{zh}->{861319585} = "甘肃省临夏回族自治州";
$areanames{zh}->{861319586} = "甘肃省白银市";
$areanames{zh}->{861319587} = "甘肃省平凉市";
$areanames{zh}->{861319588} = "甘肃省庆阳市";
$areanames{zh}->{861319589} = "甘肃省平凉市";
$areanames{zh}->{861319590} = "甘肃省嘉峪关市";
$areanames{zh}->{861319591} = "甘肃省嘉峪关市";
$areanames{zh}->{861319592} = "甘肃省武威市";
$areanames{zh}->{861319593} = "甘肃省武威市";
$areanames{zh}->{861319594} = "甘肃省酒泉市";
$areanames{zh}->{861319595} = "甘肃省金昌市";
$areanames{zh}->{861319596} = "甘肃省张掖市";
$areanames{zh}->{861319597} = "甘肃省酒泉市";
$areanames{zh}->{861319598} = "甘肃省酒泉市";
$areanames{zh}->{861319599} = "甘肃省金昌市";
$areanames{zh}->{861319600} = "吉林省长春市";
$areanames{zh}->{861319601} = "吉林省长春市";
$areanames{zh}->{861319602} = "吉林省长春市";
$areanames{zh}->{861319603} = "吉林省长春市";
$areanames{zh}->{861319604} = "吉林省长春市";
$areanames{zh}->{861319605} = "吉林省辽源市";
$areanames{zh}->{861319606} = "吉林省吉林市";
$areanames{zh}->{861319607} = "吉林省吉林市";
$areanames{zh}->{861319608} = "吉林省吉林市";
$areanames{zh}->{861319609} = "吉林省吉林市";
$areanames{zh}->{861319610} = "吉林省白城市";
$areanames{zh}->{861319611} = "吉林省松原市";
$areanames{zh}->{861319612} = "吉林省松原市";
$areanames{zh}->{861319613} = "吉林省松原市";
$areanames{zh}->{861319614} = "吉林省通化市";
$areanames{zh}->{861319615} = "吉林省通化市";
$areanames{zh}->{861319616} = "吉林省通化市";
$areanames{zh}->{861319617} = "吉林省通化市";
$areanames{zh}->{861319618} = "吉林省通化市";
$areanames{zh}->{861319619} = "吉林省白山市";
$areanames{zh}->{861319620} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861319621} = "吉林省吉林市";
$areanames{zh}->{861319622} = "吉林省吉林市";
$areanames{zh}->{861319623} = "吉林省吉林市";
$areanames{zh}->{861319624} = "吉林省吉林市";
$areanames{zh}->{861319625} = "吉林省辽源市";
$areanames{zh}->{861319626} = "吉林省辽源市";
$areanames{zh}->{861319627} = "吉林省四平市";
$areanames{zh}->{861319628} = "吉林省四平市";
$areanames{zh}->{861319629} = "吉林省四平市";
$areanames{zh}->{861319630} = "陕西省咸阳市";
$areanames{zh}->{861319631} = "陕西省咸阳市";
$areanames{zh}->{861319632} = "陕西省渭南市";
$areanames{zh}->{861319633} = "陕西省渭南市";
$areanames{zh}->{861319634} = "陕西省宝鸡市";
$areanames{zh}->{861319635} = "陕西省宝鸡市";
$areanames{zh}->{861319636} = "陕西省宝鸡市";
$areanames{zh}->{861319637} = "陕西省汉中市";
$areanames{zh}->{861319638} = "陕西省汉中市";
$areanames{zh}->{861319639} = "陕西省汉中市";
$areanames{zh}->{861319640} = "江苏省无锡市";
$areanames{zh}->{861319641} = "江苏省无锡市";
$areanames{zh}->{861319642} = "江苏省无锡市";
$areanames{zh}->{861319643} = "江苏省常州市";
$areanames{zh}->{861319644} = "江苏省常州市";
$areanames{zh}->{861319645} = "江苏省扬州市";
$areanames{zh}->{861319646} = "江苏省扬州市";
$areanames{zh}->{861319647} = "江苏省扬州市";
$areanames{zh}->{861319648} = "江苏省扬州市";
$areanames{zh}->{861319649} = "江苏省扬州市";
$areanames{zh}->{86131965} = "江苏省无锡市";
$areanames{zh}->{861319660} = "江苏省苏州市";
$areanames{zh}->{861319661} = "江苏省苏州市";
$areanames{zh}->{861319662} = "江苏省苏州市";
$areanames{zh}->{861319663} = "江苏省盐城市";
$areanames{zh}->{861319664} = "江苏省盐城市";
$areanames{zh}->{861319665} = "江苏省盐城市";
$areanames{zh}->{861319666} = "江苏省盐城市";
$areanames{zh}->{861319667} = "江苏省盐城市";
$areanames{zh}->{861319668} = "江苏省扬州市";
$areanames{zh}->{861319669} = "江苏省扬州市";
$areanames{zh}->{86131967} = "江苏省常州市";
$areanames{zh}->{861319680} = "江苏省徐州市";
$areanames{zh}->{861319681} = "江苏省徐州市";
$areanames{zh}->{861319682} = "江苏省徐州市";
$areanames{zh}->{861319683} = "江苏省连云港市";
$areanames{zh}->{861319684} = "江苏省连云港市";
$areanames{zh}->{861319685} = "江苏省镇江市";
$areanames{zh}->{861319686} = "江苏省镇江市";
$areanames{zh}->{861319687} = "江苏省宿迁市";
$areanames{zh}->{861319688} = "江苏省宿迁市";
$areanames{zh}->{861319689} = "江苏省宿迁市";
$areanames{zh}->{86131969} = "江苏省泰州市";
$areanames{zh}->{861319696} = "江苏省淮安市";
$areanames{zh}->{861319697} = "江苏省淮安市";
$areanames{zh}->{861319698} = "江苏省淮安市";
$areanames{zh}->{861319699} = "江苏省淮安市";
$areanames{zh}->{861319700} = "湖北省黄石市";
$areanames{zh}->{861319701} = "湖北省黄石市";
$areanames{zh}->{861319702} = "湖北省黄石市";
$areanames{zh}->{861319703} = "湖北省黄石市";
$areanames{zh}->{861319704} = "湖北省黄石市";
$areanames{zh}->{861319705} = "湖北省黄冈市";
$areanames{zh}->{861319706} = "湖北省黄冈市";
$areanames{zh}->{861319707} = "湖北省黄冈市";
$areanames{zh}->{861319708} = "湖北省黄冈市";
$areanames{zh}->{861319709} = "湖北省黄冈市";
$areanames{zh}->{86131971} = "湖北省襄樊市";
$areanames{zh}->{861319710} = "湖北省荆门市";
$areanames{zh}->{861319711} = "湖北省荆门市";
$areanames{zh}->{861319712} = "湖北省荆门市";
$areanames{zh}->{861319713} = "湖北省荆门市";
$areanames{zh}->{86131972} = "湖北省十堰市";
$areanames{zh}->{861319720} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861319721} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861319722} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861319723} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861319730} = "湖北省宜昌市";
$areanames{zh}->{861319731} = "湖北省宜昌市";
$areanames{zh}->{861319732} = "湖北省宜昌市";
$areanames{zh}->{861319733} = "湖北省宜昌市";
$areanames{zh}->{861319734} = "湖北省宜昌市";
$areanames{zh}->{861319735} = "湖北省孝感市";
$areanames{zh}->{861319736} = "湖北省孝感市";
$areanames{zh}->{861319737} = "湖北省孝感市";
$areanames{zh}->{861319738} = "湖北省孝感市";
$areanames{zh}->{861319739} = "湖北省孝感市";
$areanames{zh}->{861319740} = "湖北省咸宁市";
$areanames{zh}->{861319741} = "湖北省咸宁市";
$areanames{zh}->{861319742} = "湖北省咸宁市";
$areanames{zh}->{861319743} = "湖北省鄂州市";
$areanames{zh}->{861319744} = "湖北省鄂州市";
$areanames{zh}->{861319745} = "湖北省武汉市";
$areanames{zh}->{861319746} = "湖北省随州市";
$areanames{zh}->{861319747} = "湖北省荆州市";
$areanames{zh}->{861319748} = "湖北省荆州市";
$areanames{zh}->{861319749} = "湖北省荆州市";
$areanames{zh}->{861319750} = "广西南宁市";
$areanames{zh}->{861319751} = "广西南宁市";
$areanames{zh}->{861319752} = "广西柳州市";
$areanames{zh}->{861319753} = "广西贺州市";
$areanames{zh}->{861319754} = "广西贺州市";
$areanames{zh}->{861319755} = "广西贵港市";
$areanames{zh}->{861319756} = "广西百色市";
$areanames{zh}->{861319757} = "广西南宁市";
$areanames{zh}->{861319758} = "广西梧州市";
$areanames{zh}->{861319759} = "广西北海市";
$areanames{zh}->{861319760} = "广西防城港市";
$areanames{zh}->{861319761} = "广西南宁市";
$areanames{zh}->{861319762} = "广西柳州市";
$areanames{zh}->{861319763} = "广西桂林市";
$areanames{zh}->{861319764} = "广西桂林市";
$areanames{zh}->{861319765} = "广西玉林市";
$areanames{zh}->{861319766} = "广西贵港市";
$areanames{zh}->{861319767} = "广西钦州市";
$areanames{zh}->{861319768} = "广西河池市";
$areanames{zh}->{861319769} = "广西北海市";
$areanames{zh}->{861319770} = "广西防城港市";
$areanames{zh}->{861319771} = "广西南宁市";
$areanames{zh}->{861319772} = "广西柳州市";
$areanames{zh}->{861319773} = "广西桂林市";
$areanames{zh}->{861319774} = "广西梧州市";
$areanames{zh}->{861319775} = "广西玉林市";
$areanames{zh}->{861319776} = "广西百色市";
$areanames{zh}->{861319777} = "广西钦州市";
$areanames{zh}->{861319778} = "广西河池市";
$areanames{zh}->{861319779} = "广西北海市";
$areanames{zh}->{861319780} = "江西省鹰潭市";
$areanames{zh}->{861319781} = "江西省鹰潭市";
$areanames{zh}->{861319782} = "江西省抚州市";
$areanames{zh}->{861319783} = "江西省九江市";
$areanames{zh}->{861319784} = "江西省新余市";
$areanames{zh}->{861319785} = "江西省宜春市";
$areanames{zh}->{861319786} = "江西省宜春市";
$areanames{zh}->{861319787} = "江西省宜春市";
$areanames{zh}->{861319788} = "江西省抚州市";
$areanames{zh}->{861319789} = "江西省吉安市";
$areanames{zh}->{861319790} = "江西省新余市";
$areanames{zh}->{861319791} = "江西省南昌市";
$areanames{zh}->{861319792} = "江西省九江市";
$areanames{zh}->{861319793} = "江西省上饶市";
$areanames{zh}->{861319794} = "江西省抚州市";
$areanames{zh}->{861319795} = "江西省宜春市";
$areanames{zh}->{861319796} = "江西省吉安市";
$areanames{zh}->{861319797} = "江西省赣州市";
$areanames{zh}->{861319798} = "江西省景德镇市";
$areanames{zh}->{861319799} = "江西省萍乡市";
$areanames{zh}->{861319800} = "四川省内江市";
$areanames{zh}->{861319801} = "四川省内江市";
$areanames{zh}->{861319802} = "四川省内江市";
$areanames{zh}->{861319803} = "四川省资阳市";
$areanames{zh}->{861319804} = "四川省资阳市";
$areanames{zh}->{861319805} = "四川省乐山市";
$areanames{zh}->{861319806} = "四川省乐山市";
$areanames{zh}->{861319807} = "四川省绵阳市";
$areanames{zh}->{861319808} = "四川省绵阳市";
$areanames{zh}->{861319809} = "四川省绵阳市";
$areanames{zh}->{861319810} = "四川省广安市";
$areanames{zh}->{861319811} = "四川省广安市";
$areanames{zh}->{861319812} = "四川省巴中市";
$areanames{zh}->{861319813} = "四川省巴中市";
$areanames{zh}->{861319814} = "四川省巴中市";
$areanames{zh}->{861319815} = "四川省德阳市";
$areanames{zh}->{861319816} = "四川省遂宁市";
$areanames{zh}->{861319817} = "四川省南充市";
$areanames{zh}->{861319818} = "四川省南充市";
$areanames{zh}->{861319819} = "四川省南充市";
$areanames{zh}->{861319820} = "四川省自贡市";
$areanames{zh}->{861319821} = "四川省自贡市";
$areanames{zh}->{861319822} = "四川省广元市";
$areanames{zh}->{861319823} = "四川省广元市";
$areanames{zh}->{861319824} = "四川省广元市";
$areanames{zh}->{861319825} = "四川省泸州市";
$areanames{zh}->{861319826} = "四川省泸州市";
$areanames{zh}->{861319827} = "四川省德阳市";
$areanames{zh}->{861319828} = "四川省德阳市";
$areanames{zh}->{861319829} = "四川省德阳市";
$areanames{zh}->{861319830} = "四川省达州市";
$areanames{zh}->{861319831} = "四川省达州市";
$areanames{zh}->{861319832} = "四川省宜宾市";
$areanames{zh}->{861319833} = "四川省宜宾市";
$areanames{zh}->{861319834} = "四川省眉山市";
$areanames{zh}->{861319835} = "四川省眉山市";
$areanames{zh}->{861319836} = "四川省眉山市";
$areanames{zh}->{861319837} = "四川省凉山彝族自治州";
$areanames{zh}->{861319838} = "四川省攀枝花市";
$areanames{zh}->{861319839} = "四川省攀枝花市";
$areanames{zh}->{861319840} = "四川省自贡市";
$areanames{zh}->{861319841} = "四川省遂宁市";
$areanames{zh}->{861319842} = "四川省泸州市";
$areanames{zh}->{861319843} = "四川省南充市";
$areanames{zh}->{861319844} = "四川省达州市";
$areanames{zh}->{861319845} = "四川省内江市";
$areanames{zh}->{861319846} = "四川省宜宾市";
$areanames{zh}->{861319847} = "四川省乐山市";
$areanames{zh}->{861319848} = "四川省攀枝花市";
$areanames{zh}->{861319849} = "四川省凉山彝族自治州";
$areanames{zh}->{86131985} = "四川省成都市";
$areanames{zh}->{861319860} = "四川省攀枝花市";
$areanames{zh}->{861319861} = "四川省攀枝花市";
$areanames{zh}->{861319862} = "四川省眉山市";
$areanames{zh}->{861319863} = "四川省凉山彝族自治州";
$areanames{zh}->{861319864} = "四川省南充市";
$areanames{zh}->{861319865} = "四川省遂宁市";
$areanames{zh}->{861319866} = "四川省绵阳市";
$areanames{zh}->{861319867} = "四川省绵阳市";
$areanames{zh}->{861319868} = "四川省绵阳市";
$areanames{zh}->{861319869} = "四川省巴中市";
$areanames{zh}->{861319870} = "四川省眉山市";
$areanames{zh}->{861319871} = "四川省乐山市";
$areanames{zh}->{861319872} = "四川省乐山市";
$areanames{zh}->{861319873} = "四川省达州市";
$areanames{zh}->{861319874} = "四川省达州市";
$areanames{zh}->{861319875} = "四川省达州市";
$areanames{zh}->{861319876} = "四川省自贡市";
$areanames{zh}->{861319877} = "四川省广安市";
$areanames{zh}->{861319878} = "四川省内江市";
$areanames{zh}->{861319879} = "四川省内江市";
$areanames{zh}->{861319880} = "四川省自贡市";
$areanames{zh}->{861319881} = "四川省南充市";
$areanames{zh}->{861319882} = "四川省南充市";
$areanames{zh}->{861319883} = "四川省宜宾市";
$areanames{zh}->{861319884} = "四川省宜宾市";
$areanames{zh}->{861319885} = "四川省资阳市";
$areanames{zh}->{861319886} = "四川省泸州市";
$areanames{zh}->{861319887} = "四川省广元市";
$areanames{zh}->{861319888} = "四川省德阳市";
$areanames{zh}->{861319889} = "四川省德阳市";
$areanames{zh}->{86131989} = "海南省海口市";
$areanames{zh}->{86131990} = "黑龙江省大庆市";
$areanames{zh}->{861319900} = "黑龙江省绥化市";
$areanames{zh}->{861319901} = "黑龙江省绥化市";
$areanames{zh}->{861319902} = "黑龙江省绥化市";
$areanames{zh}->{861319903} = "黑龙江省绥化市";
$areanames{zh}->{86131991} = "黑龙江省佳木斯市";
$areanames{zh}->{861319916} = "黑龙江省鸡西市";
$areanames{zh}->{861319917} = "黑龙江省鸡西市";
$areanames{zh}->{861319918} = "黑龙江省鸡西市";
$areanames{zh}->{861319919} = "黑龙江省双鸭山市";
$areanames{zh}->{861319920} = "黑龙江省双鸭山市";
$areanames{zh}->{861319921} = "黑龙江省双鸭山市";
$areanames{zh}->{861319922} = "黑龙江省双鸭山市";
$areanames{zh}->{861319923} = "黑龙江省七台河市";
$areanames{zh}->{861319924} = "黑龙江省七台河市";
$areanames{zh}->{861319925} = "黑龙江省伊春市";
$areanames{zh}->{861319926} = "黑龙江省伊春市";
$areanames{zh}->{861319927} = "黑龙江省伊春市";
$areanames{zh}->{861319928} = "黑龙江省黑河市";
$areanames{zh}->{861319929} = "黑龙江省黑河市";
$areanames{zh}->{86131993} = "黑龙江省牡丹江市";
$areanames{zh}->{861319930} = "黑龙江省黑河市";
$areanames{zh}->{861319931} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861319932} = "黑龙江省大兴安岭地区";
$areanames{zh}->{86131994} = "黑龙江省哈尔滨市";
$areanames{zh}->{861319940} = "黑龙江省大庆市";
$areanames{zh}->{861319941} = "黑龙江省大庆市";
$areanames{zh}->{861319942} = "黑龙江省鸡西市";
$areanames{zh}->{861319943} = "黑龙江省鸡西市";
$areanames{zh}->{86131995} = "黑龙江省哈尔滨市";
$areanames{zh}->{861319959} = "黑龙江省鹤岗市";
$areanames{zh}->{86131996} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861319960} = "黑龙江省鹤岗市";
$areanames{zh}->{861319961} = "黑龙江省鹤岗市";
$areanames{zh}->{861319970} = "新疆昌吉回族自治州";
$areanames{zh}->{861319971} = "新疆哈密地区";
$areanames{zh}->{861319972} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861319973} = "新疆喀什地区";
$areanames{zh}->{861319974} = "新疆阿克苏地区";
$areanames{zh}->{861319975} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861319976} = "新疆和田地区";
$areanames{zh}->{861319977} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861319978} = "新疆塔城地区";
$areanames{zh}->{861319979} = "新疆阿勒泰地区";
$areanames{zh}->{86131998} = "新疆乌鲁木齐市";
$areanames{zh}->{861319990} = "新疆克拉玛依市";
$areanames{zh}->{861319991} = "新疆乌鲁木齐市";
$areanames{zh}->{861319992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861319993} = "新疆石河子市";
$areanames{zh}->{861319994} = "新疆昌吉回族自治州";
$areanames{zh}->{861319995} = "新疆吐鲁番地区";
$areanames{zh}->{861319996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861319997} = "新疆阿克苏地区";
$areanames{zh}->{861319998} = "新疆喀什地区";
$areanames{zh}->{861319999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{8613200} = "上海市";
$areanames{zh}->{861320100} = "新疆昌吉回族自治州";
$areanames{zh}->{861320101} = "新疆昌吉回族自治州";
$areanames{zh}->{861320102} = "新疆昌吉回族自治州";
$areanames{zh}->{861320103} = "新疆昌吉回族自治州";
$areanames{zh}->{861320104} = "新疆吐鲁番地区";
$areanames{zh}->{861320105} = "新疆喀什地区";
$areanames{zh}->{861320106} = "新疆哈密地区";
$areanames{zh}->{861320107} = "新疆哈密地区";
$areanames{zh}->{861320108} = "新疆克拉玛依市";
$areanames{zh}->{861320109} = "新疆石河子市";
$areanames{zh}->{861320110} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861320111} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861320112} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861320113} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861320114} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861320115} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861320116} = "新疆阿克苏地区";
$areanames{zh}->{861320117} = "新疆阿克苏地区";
$areanames{zh}->{861320118} = "新疆喀什地区";
$areanames{zh}->{861320119} = "新疆喀什地区";
$areanames{zh}->{86132012} = "新疆乌鲁木齐市";
$areanames{zh}->{86132013} = "新疆乌鲁木齐市";
$areanames{zh}->{86132014} = "陕西省西安市";
$areanames{zh}->{86132015} = "陕西省西安市";
$areanames{zh}->{86132016} = "陕西省西安市";
$areanames{zh}->{86132017} = "陕西省西安市";
$areanames{zh}->{86132018} = "陕西省西安市";
$areanames{zh}->{86132019} = "陕西省渭南市";
$areanames{zh}->{861320190} = "陕西省咸阳市";
$areanames{zh}->{861320191} = "陕西省咸阳市";
$areanames{zh}->{861320192} = "陕西省咸阳市";
$areanames{zh}->{861320193} = "陕西省咸阳市";
$areanames{zh}->{86132020} = "广东省广州市";
$areanames{zh}->{86132021} = "广东省汕头市";
$areanames{zh}->{861320220} = "广东省揭阳市";
$areanames{zh}->{861320221} = "广东省揭阳市";
$areanames{zh}->{861320222} = "广东省揭阳市";
$areanames{zh}->{861320223} = "广东省揭阳市";
$areanames{zh}->{861320224} = "广东省揭阳市";
$areanames{zh}->{861320225} = "广东省深圳市";
$areanames{zh}->{861320226} = "广东省深圳市";
$areanames{zh}->{861320227} = "广东省深圳市";
$areanames{zh}->{861320228} = "广东省深圳市";
$areanames{zh}->{861320229} = "广东省深圳市";
$areanames{zh}->{861320230} = "广东省惠州市";
$areanames{zh}->{861320231} = "广东省惠州市";
$areanames{zh}->{861320232} = "广东省惠州市";
$areanames{zh}->{861320233} = "广东省惠州市";
$areanames{zh}->{861320234} = "广东省惠州市";
$areanames{zh}->{861320235} = "广东省佛山市";
$areanames{zh}->{861320236} = "广东省佛山市";
$areanames{zh}->{861320237} = "广东省佛山市";
$areanames{zh}->{861320238} = "广东省佛山市";
$areanames{zh}->{861320239} = "广东省佛山市";
$areanames{zh}->{86132024} = "广东省佛山市";
$areanames{zh}->{861320250} = "广东省广州市";
$areanames{zh}->{861320251} = "广东省广州市";
$areanames{zh}->{861320252} = "广东省广州市";
$areanames{zh}->{861320253} = "广东省广州市";
$areanames{zh}->{861320254} = "广东省广州市";
$areanames{zh}->{861320255} = "广东省揭阳市";
$areanames{zh}->{861320256} = "广东省揭阳市";
$areanames{zh}->{861320257} = "广东省揭阳市";
$areanames{zh}->{861320258} = "广东省揭阳市";
$areanames{zh}->{861320259} = "广东省揭阳市";
$areanames{zh}->{861320260} = "广东省肇庆市";
$areanames{zh}->{861320261} = "广东省肇庆市";
$areanames{zh}->{861320262} = "广东省肇庆市";
$areanames{zh}->{861320263} = "广东省肇庆市";
$areanames{zh}->{861320264} = "广东省肇庆市";
$areanames{zh}->{861320265} = "广东省东莞市";
$areanames{zh}->{861320266} = "广东省东莞市";
$areanames{zh}->{861320267} = "广东省东莞市";
$areanames{zh}->{861320268} = "广东省东莞市";
$areanames{zh}->{861320269} = "广东省东莞市";
$areanames{zh}->{861320270} = "广东省东莞市";
$areanames{zh}->{861320271} = "广东省东莞市";
$areanames{zh}->{861320272} = "广东省东莞市";
$areanames{zh}->{861320273} = "广东省东莞市";
$areanames{zh}->{861320274} = "广东省东莞市";
$areanames{zh}->{861320275} = "广东省肇庆市";
$areanames{zh}->{861320276} = "广东省肇庆市";
$areanames{zh}->{861320277} = "广东省肇庆市";
$areanames{zh}->{861320278} = "广东省肇庆市";
$areanames{zh}->{861320279} = "广东省肇庆市";
$areanames{zh}->{86132028} = "广东省佛山市";
$areanames{zh}->{86132029} = "广东省佛山市";
$areanames{zh}->{86132030} = "湖南省衡阳市";
$areanames{zh}->{861320300} = "湖南省岳阳市";
$areanames{zh}->{861320301} = "湖南省岳阳市";
$areanames{zh}->{861320302} = "湖南省岳阳市";
$areanames{zh}->{861320303} = "湖南省岳阳市";
$areanames{zh}->{86132031} = "湖南省长沙市";
$areanames{zh}->{861320318} = "湖南省娄底市";
$areanames{zh}->{861320319} = "湖南省娄底市";
$areanames{zh}->{86132032} = "湖南省邵阳市";
$areanames{zh}->{861320320} = "湖南省湘潭市";
$areanames{zh}->{861320321} = "湖南省湘潭市";
$areanames{zh}->{861320322} = "湖南省湘潭市";
$areanames{zh}->{861320323} = "湖南省湘潭市";
$areanames{zh}->{86132033} = "湖南省株洲市";
$areanames{zh}->{861320337} = "湖南省郴州市";
$areanames{zh}->{861320338} = "湖南省郴州市";
$areanames{zh}->{861320339} = "湖南省郴州市";
$areanames{zh}->{861320340} = "山西省忻州市";
$areanames{zh}->{861320341} = "山西省太原市";
$areanames{zh}->{861320342} = "山西省大同市";
$areanames{zh}->{861320343} = "山西省阳泉市";
$areanames{zh}->{861320344} = "山西省晋中市";
$areanames{zh}->{861320345} = "山西省长治市";
$areanames{zh}->{861320346} = "山西省晋城市";
$areanames{zh}->{861320347} = "山西省临汾市";
$areanames{zh}->{861320348} = "山西省运城市";
$areanames{zh}->{861320349} = "山西省朔州市";
$areanames{zh}->{861320350} = "山西省忻州市";
$areanames{zh}->{861320351} = "山西省太原市";
$areanames{zh}->{861320352} = "山西省大同市";
$areanames{zh}->{861320353} = "山西省阳泉市";
$areanames{zh}->{861320354} = "山西省晋中市";
$areanames{zh}->{861320355} = "山西省长治市";
$areanames{zh}->{861320356} = "山西省晋城市";
$areanames{zh}->{861320357} = "山西省临汾市";
$areanames{zh}->{861320358} = "山西省吕梁市";
$areanames{zh}->{861320359} = "山西省运城市";
$areanames{zh}->{861320360} = "湖南省常德市";
$areanames{zh}->{861320361} = "湖南省常德市";
$areanames{zh}->{861320362} = "湖南省常德市";
$areanames{zh}->{861320363} = "湖南省常德市";
$areanames{zh}->{861320364} = "湖南省常德市";
$areanames{zh}->{861320365} = "湖南省益阳市";
$areanames{zh}->{861320366} = "湖南省益阳市";
$areanames{zh}->{861320367} = "湖南省益阳市";
$areanames{zh}->{861320368} = "湖南省益阳市";
$areanames{zh}->{861320369} = "湖南省益阳市";
$areanames{zh}->{861320370} = "河南省郑州市";
$areanames{zh}->{861320371} = "河南省郑州市";
$areanames{zh}->{861320372} = "河南省郑州市";
$areanames{zh}->{861320373} = "河南省郑州市";
$areanames{zh}->{861320374} = "河南省郑州市";
$areanames{zh}->{861320375} = "河南省南阳市";
$areanames{zh}->{861320376} = "河南省南阳市";
$areanames{zh}->{861320377} = "河南省南阳市";
$areanames{zh}->{861320378} = "河南省南阳市";
$areanames{zh}->{861320379} = "河南省南阳市";
$areanames{zh}->{86132038} = "河南省郑州市";
$areanames{zh}->{86132039} = "河南省焦作市";
$areanames{zh}->{861320400} = "辽宁省沈阳市";
$areanames{zh}->{861320401} = "辽宁省沈阳市";
$areanames{zh}->{861320402} = "辽宁省沈阳市";
$areanames{zh}->{861320403} = "辽宁省沈阳市";
$areanames{zh}->{861320404} = "辽宁省沈阳市";
$areanames{zh}->{861320405} = "辽宁省大连市";
$areanames{zh}->{861320406} = "辽宁省大连市";
$areanames{zh}->{861320407} = "辽宁省大连市";
$areanames{zh}->{861320408} = "辽宁省大连市";
$areanames{zh}->{861320409} = "辽宁省大连市";
$areanames{zh}->{861320410} = "辽宁省铁岭市";
$areanames{zh}->{861320411} = "辽宁省大连市";
$areanames{zh}->{861320412} = "辽宁省鞍山市";
$areanames{zh}->{861320413} = "辽宁省抚顺市";
$areanames{zh}->{861320414} = "辽宁省本溪市";
$areanames{zh}->{861320415} = "辽宁省丹东市";
$areanames{zh}->{861320416} = "辽宁省锦州市";
$areanames{zh}->{861320417} = "辽宁省营口市";
$areanames{zh}->{861320418} = "辽宁省阜新市";
$areanames{zh}->{861320419} = "辽宁省辽阳市";
$areanames{zh}->{861320420} = "辽宁省铁岭市";
$areanames{zh}->{861320421} = "辽宁省朝阳市";
$areanames{zh}->{861320422} = "辽宁省鞍山市";
$areanames{zh}->{861320423} = "辽宁省鞍山市";
$areanames{zh}->{861320424} = "辽宁省抚顺市";
$areanames{zh}->{861320425} = "辽宁省抚顺市";
$areanames{zh}->{861320426} = "辽宁省本溪市";
$areanames{zh}->{861320427} = "辽宁省盘锦市";
$areanames{zh}->{861320428} = "辽宁省阜新市";
$areanames{zh}->{861320429} = "辽宁省葫芦岛市";
$areanames{zh}->{861320430} = "吉林省长春市";
$areanames{zh}->{861320431} = "吉林省长春市";
$areanames{zh}->{861320432} = "吉林省吉林市";
$areanames{zh}->{861320433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861320434} = "吉林省四平市";
$areanames{zh}->{861320435} = "吉林省通化市";
$areanames{zh}->{861320436} = "吉林省白城市";
$areanames{zh}->{861320437} = "吉林省辽源市";
$areanames{zh}->{861320438} = "吉林省松原市";
$areanames{zh}->{861320439} = "吉林省白山市";
$areanames{zh}->{86132044} = "吉林省白城市";
$areanames{zh}->{861320449} = "吉林省白山市";
$areanames{zh}->{861320450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320453} = "黑龙江省牡丹江市";
$areanames{zh}->{861320454} = "黑龙江省佳木斯市";
$areanames{zh}->{861320455} = "黑龙江省绥化市";
$areanames{zh}->{861320456} = "黑龙江省黑河市";
$areanames{zh}->{861320457} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320458} = "黑龙江省伊春市";
$areanames{zh}->{861320459} = "黑龙江省大庆市";
$areanames{zh}->{86132046} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320464} = "黑龙江省七台河市";
$areanames{zh}->{861320467} = "黑龙江省鸡西市";
$areanames{zh}->{861320468} = "黑龙江省鹤岗市";
$areanames{zh}->{861320469} = "黑龙江省双鸭山市";
$areanames{zh}->{861320470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861320471} = "内蒙古呼和浩特市";
$areanames{zh}->{861320472} = "内蒙古包头市";
$areanames{zh}->{861320473} = "内蒙古乌海市";
$areanames{zh}->{861320474} = "内蒙古乌兰察布市";
$areanames{zh}->{861320475} = "内蒙古通辽市";
$areanames{zh}->{861320476} = "内蒙古赤峰市";
$areanames{zh}->{861320477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861320478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861320479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861320480} = "内蒙古呼和浩特市";
$areanames{zh}->{861320481} = "内蒙古通辽市";
$areanames{zh}->{861320482} = "内蒙古兴安盟";
$areanames{zh}->{861320483} = "内蒙古阿拉善盟";
$areanames{zh}->{861320484} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861320485} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861320486} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861320487} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861320488} = "内蒙古兴安盟";
$areanames{zh}->{861320489} = "内蒙古兴安盟";
$areanames{zh}->{861320490} = "湖南省郴州市";
$areanames{zh}->{861320491} = "湖南省郴州市";
$areanames{zh}->{861320492} = "湖南省怀化市";
$areanames{zh}->{861320493} = "湖南省怀化市";
$areanames{zh}->{861320494} = "湖南省娄底市";
$areanames{zh}->{861320495} = "湖南省永州市";
$areanames{zh}->{861320496} = "湖南省永州市";
$areanames{zh}->{861320497} = "湖南省永州市";
$areanames{zh}->{861320498} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861320499} = "湖南省怀化市";
$areanames{zh}->{861320500} = "福建省福州市";
$areanames{zh}->{861320501} = "福建省福州市";
$areanames{zh}->{861320502} = "福建省福州市";
$areanames{zh}->{861320503} = "福建省福州市";
$areanames{zh}->{861320504} = "福建省南平市";
$areanames{zh}->{861320505} = "福建省泉州市";
$areanames{zh}->{861320506} = "福建省泉州市";
$areanames{zh}->{861320507} = "福建省泉州市";
$areanames{zh}->{861320508} = "福建省泉州市";
$areanames{zh}->{861320509} = "福建省泉州市";
$areanames{zh}->{86132051} = "江苏省苏州市";
$areanames{zh}->{861320510} = "江苏省常州市";
$areanames{zh}->{86132052} = "江苏省无锡市";
$areanames{zh}->{861320520} = "江苏省常州市";
$areanames{zh}->{861320530} = "山东省菏泽市";
$areanames{zh}->{861320531} = "山东省济南市";
$areanames{zh}->{861320532} = "山东省青岛市";
$areanames{zh}->{861320533} = "山东省淄博市";
$areanames{zh}->{861320534} = "山东省德州市";
$areanames{zh}->{861320535} = "山东省烟台市";
$areanames{zh}->{861320536} = "山东省潍坊市";
$areanames{zh}->{861320537} = "山东省济宁市";
$areanames{zh}->{861320538} = "山东省泰安市";
$areanames{zh}->{861320539} = "山东省临沂市";
$areanames{zh}->{861320540} = "山东省济南市";
$areanames{zh}->{861320541} = "山东省济南市";
$areanames{zh}->{861320542} = "山东省济南市";
$areanames{zh}->{861320543} = "山东省滨州市";
$areanames{zh}->{861320544} = "山东省烟台市";
$areanames{zh}->{861320545} = "山东省烟台市";
$areanames{zh}->{861320546} = "山东省东营市";
$areanames{zh}->{861320547} = "山东省东营市";
$areanames{zh}->{861320548} = "山东省东营市";
$areanames{zh}->{861320549} = "山东省东营市";
$areanames{zh}->{861320550} = "安徽省滁州市";
$areanames{zh}->{861320551} = "安徽省合肥市";
$areanames{zh}->{861320552} = "安徽省蚌埠市";
$areanames{zh}->{861320553} = "安徽省芜湖市";
$areanames{zh}->{861320554} = "安徽省淮南市";
$areanames{zh}->{861320555} = "安徽省马鞍山市";
$areanames{zh}->{861320556} = "安徽省安庆市";
$areanames{zh}->{861320557} = "安徽省宿州市";
$areanames{zh}->{861320558} = "安徽省阜阳市";
$areanames{zh}->{861320559} = "安徽省黄山市";
$areanames{zh}->{861320560} = "安徽省合肥市";
$areanames{zh}->{861320561} = "安徽省淮北市";
$areanames{zh}->{861320562} = "安徽省铜陵市";
$areanames{zh}->{861320563} = "安徽省宣城市";
$areanames{zh}->{861320564} = "安徽省六安市";
$areanames{zh}->{861320565} = "安徽省马鞍山市";
$areanames{zh}->{861320566} = "安徽省池州市";
$areanames{zh}->{861320567} = "安徽省亳州市";
$areanames{zh}->{861320568} = "安徽省阜阳市";
$areanames{zh}->{861320569} = "安徽省合肥市";
$areanames{zh}->{861320570} = "浙江省衢州市";
$areanames{zh}->{861320571} = "浙江省杭州市";
$areanames{zh}->{861320572} = "浙江省湖州市";
$areanames{zh}->{861320573} = "浙江省嘉兴市";
$areanames{zh}->{861320574} = "浙江省宁波市";
$areanames{zh}->{861320575} = "浙江省绍兴市";
$areanames{zh}->{861320576} = "浙江省台州市";
$areanames{zh}->{861320577} = "浙江省温州市";
$areanames{zh}->{861320578} = "浙江省丽水市";
$areanames{zh}->{861320579} = "浙江省金华市";
$areanames{zh}->{861320580} = "浙江省舟山市";
$areanames{zh}->{861320581} = "浙江省杭州市";
$areanames{zh}->{861320582} = "浙江省湖州市";
$areanames{zh}->{861320583} = "浙江省嘉兴市";
$areanames{zh}->{861320584} = "浙江省宁波市";
$areanames{zh}->{861320585} = "浙江省绍兴市";
$areanames{zh}->{861320586} = "浙江省台州市";
$areanames{zh}->{861320587} = "浙江省温州市";
$areanames{zh}->{861320588} = "浙江省丽水市";
$areanames{zh}->{861320589} = "浙江省金华市";
$areanames{zh}->{861320590} = "福建省福州市";
$areanames{zh}->{861320591} = "福建省福州市";
$areanames{zh}->{861320592} = "福建省厦门市";
$areanames{zh}->{861320593} = "福建省宁德市";
$areanames{zh}->{861320594} = "福建省莆田市";
$areanames{zh}->{861320595} = "福建省泉州市";
$areanames{zh}->{861320596} = "福建省漳州市";
$areanames{zh}->{861320597} = "福建省龙岩市";
$areanames{zh}->{861320598} = "福建省三明市";
$areanames{zh}->{861320599} = "福建省南平市";
$areanames{zh}->{86132060} = "重庆市";
$areanames{zh}->{86132061} = "重庆市";
$areanames{zh}->{86132062} = "重庆市";
$areanames{zh}->{861320630} = "山东省威海市";
$areanames{zh}->{861320631} = "山东省威海市";
$areanames{zh}->{861320632} = "山东省枣庄市";
$areanames{zh}->{861320633} = "山东省日照市";
$areanames{zh}->{861320634} = "山东省莱芜市";
$areanames{zh}->{861320635} = "山东省聊城市";
$areanames{zh}->{861320636} = "山东省青岛市";
$areanames{zh}->{861320637} = "山东省青岛市";
$areanames{zh}->{861320638} = "山东省青岛市";
$areanames{zh}->{861320639} = "山东省青岛市";
$areanames{zh}->{86132064} = "山东省青岛市";
$areanames{zh}->{861320640} = "山东省济南市";
$areanames{zh}->{86132065} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320650} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320651} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{86132066} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320660} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320661} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320662} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320663} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320670} = "黑龙江省黑河市";
$areanames{zh}->{861320671} = "黑龙江省伊春市";
$areanames{zh}->{861320672} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320673} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861320674} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320675} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320676} = "黑龙江省哈尔滨市";
$areanames{zh}->{861320677} = "黑龙江省双鸭山市";
$areanames{zh}->{861320678} = "黑龙江省双鸭山市";
$areanames{zh}->{861320679} = "黑龙江省黑河市";
$areanames{zh}->{86132068} = "黑龙江省大庆市";
$areanames{zh}->{861320686} = "黑龙江省牡丹江市";
$areanames{zh}->{861320687} = "黑龙江省牡丹江市";
$areanames{zh}->{861320688} = "黑龙江省牡丹江市";
$areanames{zh}->{861320689} = "黑龙江省牡丹江市";
$areanames{zh}->{861320690} = "黑龙江省绥化市";
$areanames{zh}->{861320691} = "黑龙江省绥化市";
$areanames{zh}->{861320692} = "黑龙江省绥化市";
$areanames{zh}->{861320693} = "黑龙江省黑河市";
$areanames{zh}->{861320694} = "黑龙江省黑河市";
$areanames{zh}->{861320695} = "黑龙江省鸡西市";
$areanames{zh}->{861320696} = "黑龙江省鸡西市";
$areanames{zh}->{861320697} = "黑龙江省佳木斯市";
$areanames{zh}->{861320698} = "黑龙江省佳木斯市";
$areanames{zh}->{861320699} = "黑龙江省佳木斯市";
$areanames{zh}->{861320700} = "江西省南昌市";
$areanames{zh}->{861320701} = "江西省鹰潭市";
$areanames{zh}->{861320702} = "江西省九江市";
$areanames{zh}->{861320703} = "江西省上饶市";
$areanames{zh}->{861320704} = "江西省抚州市";
$areanames{zh}->{861320705} = "江西省宜春市";
$areanames{zh}->{861320706} = "江西省吉安市";
$areanames{zh}->{861320707} = "江西省赣州市";
$areanames{zh}->{861320708} = "江西省南昌市";
$areanames{zh}->{861320709} = "江西省南昌市";
$areanames{zh}->{86132071} = "湖北省武汉市";
$areanames{zh}->{861320720} = "湖北省宜昌市";
$areanames{zh}->{861320721} = "湖北省宜昌市";
$areanames{zh}->{861320722} = "湖北省宜昌市";
$areanames{zh}->{861320723} = "湖北省襄樊市";
$areanames{zh}->{861320724} = "湖北省襄樊市";
$areanames{zh}->{861320725} = "湖北省襄樊市";
$areanames{zh}->{861320726} = "湖北省十堰市";
$areanames{zh}->{861320727} = "湖北省荆州市";
$areanames{zh}->{861320728} = "湖北省荆州市";
$areanames{zh}->{861320729} = "湖北省荆州市";
$areanames{zh}->{861320730} = "湖南省岳阳市";
$areanames{zh}->{861320731} = "湖南省长沙市";
$areanames{zh}->{861320732} = "湖南省湘潭市";
$areanames{zh}->{861320733} = "湖南省株洲市";
$areanames{zh}->{861320734} = "湖南省衡阳市";
$areanames{zh}->{861320735} = "湖南省郴州市";
$areanames{zh}->{861320736} = "湖南省常德市";
$areanames{zh}->{861320737} = "湖南省益阳市";
$areanames{zh}->{861320738} = "湖南省娄底市";
$areanames{zh}->{861320739} = "湖南省邵阳市";
$areanames{zh}->{861320740} = "湖南省岳阳市";
$areanames{zh}->{861320741} = "湖南省长沙市";
$areanames{zh}->{861320742} = "湖南省长沙市";
$areanames{zh}->{861320743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861320744} = "湖南省张家界市";
$areanames{zh}->{861320745} = "湖南省怀化市";
$areanames{zh}->{861320746} = "湖南省永州市";
$areanames{zh}->{861320747} = "湖南省长沙市";
$areanames{zh}->{861320748} = "湖南省长沙市";
$areanames{zh}->{861320749} = "湖南省长沙市";
$areanames{zh}->{86132075} = "天津市";
$areanames{zh}->{86132076} = "天津市";
$areanames{zh}->{861320770} = "广西防城港市";
$areanames{zh}->{861320771} = "广西南宁市";
$areanames{zh}->{861320772} = "广西柳州市";
$areanames{zh}->{861320773} = "广西桂林市";
$areanames{zh}->{861320774} = "广西梧州市";
$areanames{zh}->{861320775} = "广西玉林市";
$areanames{zh}->{861320776} = "广西百色市";
$areanames{zh}->{861320777} = "广西钦州市";
$areanames{zh}->{861320778} = "广西河池市";
$areanames{zh}->{861320779} = "广西北海市";
$areanames{zh}->{861320780} = "广西南宁市";
$areanames{zh}->{861320781} = "广西南宁市";
$areanames{zh}->{861320782} = "广西柳州市";
$areanames{zh}->{861320783} = "广西桂林市";
$areanames{zh}->{861320784} = "广西梧州市";
$areanames{zh}->{861320785} = "广西玉林市";
$areanames{zh}->{861320786} = "广西百色市";
$areanames{zh}->{861320787} = "广西钦州市";
$areanames{zh}->{861320788} = "广西河池市";
$areanames{zh}->{861320789} = "广西贵港市";
$areanames{zh}->{861320790} = "江西省新余市";
$areanames{zh}->{861320791} = "江西省南昌市";
$areanames{zh}->{861320792} = "江西省九江市";
$areanames{zh}->{861320793} = "江西省上饶市";
$areanames{zh}->{861320794} = "江西省抚州市";
$areanames{zh}->{861320795} = "江西省宜春市";
$areanames{zh}->{861320796} = "江西省吉安市";
$areanames{zh}->{861320797} = "江西省赣州市";
$areanames{zh}->{861320798} = "江西省景德镇市";
$areanames{zh}->{861320799} = "江西省萍乡市";
$areanames{zh}->{861320800} = "浙江省杭州市";
$areanames{zh}->{861320801} = "浙江省杭州市";
$areanames{zh}->{861320802} = "浙江省杭州市";
$areanames{zh}->{861320803} = "浙江省杭州市";
$areanames{zh}->{861320804} = "浙江省杭州市";
$areanames{zh}->{861320805} = "浙江省宁波市";
$areanames{zh}->{861320806} = "浙江省宁波市";
$areanames{zh}->{861320807} = "浙江省宁波市";
$areanames{zh}->{861320808} = "浙江省宁波市";
$areanames{zh}->{861320809} = "浙江省宁波市";
$areanames{zh}->{86132081} = "四川省成都市";
$areanames{zh}->{861320812} = "四川省南充市";
$areanames{zh}->{861320813} = "四川省自贡市";
$areanames{zh}->{861320814} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861320815} = "四川省资阳市";
$areanames{zh}->{861320820} = "四川省攀枝花市";
$areanames{zh}->{861320821} = "四川省达州市";
$areanames{zh}->{861320822} = "四川省广安市";
$areanames{zh}->{861320823} = "四川省南充市";
$areanames{zh}->{861320824} = "四川省甘孜藏族自治州";
$areanames{zh}->{861320825} = "四川省遂宁市";
$areanames{zh}->{861320826} = "四川省绵阳市";
$areanames{zh}->{861320827} = "四川省绵阳市";
$areanames{zh}->{861320828} = "四川省绵阳市";
$areanames{zh}->{861320829} = "四川省绵阳市";
$areanames{zh}->{861320830} = "四川省泸州市";
$areanames{zh}->{861320831} = "四川省宜宾市";
$areanames{zh}->{861320832} = "四川省内江市";
$areanames{zh}->{861320833} = "四川省乐山市";
$areanames{zh}->{861320834} = "四川省凉山彝族自治州";
$areanames{zh}->{861320835} = "四川省雅安市";
$areanames{zh}->{861320836} = "四川省巴中市";
$areanames{zh}->{861320837} = "四川省眉山市";
$areanames{zh}->{861320838} = "四川省德阳市";
$areanames{zh}->{861320839} = "四川省广元市";
$areanames{zh}->{861320840} = "黑龙江省佳木斯市";
$areanames{zh}->{861320841} = "黑龙江省佳木斯市";
$areanames{zh}->{861320842} = "黑龙江省佳木斯市";
$areanames{zh}->{861320843} = "黑龙江省牡丹江市";
$areanames{zh}->{861320844} = "黑龙江省大庆市";
$areanames{zh}->{861320845} = "黑龙江省大庆市";
$areanames{zh}->{861320846} = "黑龙江省大庆市";
$areanames{zh}->{861320847} = "黑龙江省大庆市";
$areanames{zh}->{861320848} = "黑龙江省大庆市";
$areanames{zh}->{861320849} = "黑龙江省双鸭山市";
$areanames{zh}->{861320850} = "贵州省安顺市";
$areanames{zh}->{861320851} = "贵州省贵阳市";
$areanames{zh}->{861320852} = "贵州省遵义市";
$areanames{zh}->{861320853} = "贵州省安顺市";
$areanames{zh}->{861320854} = "贵州省六盘水市";
$areanames{zh}->{861320855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861320856} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861320857} = "贵州省毕节地区";
$areanames{zh}->{861320858} = "贵州省毕节地区";
$areanames{zh}->{861320859} = "贵州省毕节地区";
$areanames{zh}->{861320860} = "吉林省松原市";
$areanames{zh}->{861320861} = "吉林省松原市";
$areanames{zh}->{861320862} = "吉林省松原市";
$areanames{zh}->{861320863} = "吉林省松原市";
$areanames{zh}->{861320864} = "吉林省松原市";
$areanames{zh}->{861320865} = "吉林省辽源市";
$areanames{zh}->{861320866} = "吉林省辽源市";
$areanames{zh}->{861320867} = "吉林省辽源市";
$areanames{zh}->{861320868} = "吉林省辽源市";
$areanames{zh}->{861320869} = "吉林省辽源市";
$areanames{zh}->{861320870} = "云南省昭通市";
$areanames{zh}->{861320871} = "云南省昆明市";
$areanames{zh}->{861320872} = "云南省大理白族自治州";
$areanames{zh}->{861320873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861320874} = "云南省曲靖市";
$areanames{zh}->{861320875} = "云南省保山市";
$areanames{zh}->{861320876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861320877} = "云南省玉溪市";
$areanames{zh}->{861320878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861320879} = "云南省普洱市";
$areanames{zh}->{861320880} = "云南省昆明市";
$areanames{zh}->{861320881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861320882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861320883} = "云南省临沧市";
$areanames{zh}->{861320884} = "云南省昆明市";
$areanames{zh}->{861320885} = "云南省昆明市";
$areanames{zh}->{861320886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861320887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861320888} = "云南省丽江市";
$areanames{zh}->{861320889} = "云南省昆明市";
$areanames{zh}->{86132089} = "海南省海口市";
$areanames{zh}->{861320900} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861320901} = "新疆塔城地区";
$areanames{zh}->{861320902} = "新疆哈密地区";
$areanames{zh}->{861320903} = "新疆和田地区";
$areanames{zh}->{861320904} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861320905} = "新疆阿克苏地区";
$areanames{zh}->{861320906} = "新疆阿勒泰地区";
$areanames{zh}->{861320907} = "新疆喀什地区";
$areanames{zh}->{861320908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861320909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861320910} = "陕西省咸阳市";
$areanames{zh}->{861320911} = "陕西省延安市";
$areanames{zh}->{861320912} = "陕西省榆林市";
$areanames{zh}->{861320913} = "陕西省渭南市";
$areanames{zh}->{861320914} = "陕西省商洛市";
$areanames{zh}->{861320915} = "陕西省安康市";
$areanames{zh}->{861320916} = "陕西省汉中市";
$areanames{zh}->{861320917} = "陕西省宝鸡市";
$areanames{zh}->{861320918} = "陕西省渭南市";
$areanames{zh}->{861320919} = "陕西省铜川市";
$areanames{zh}->{861320920} = "陕西省宝鸡市";
$areanames{zh}->{861320921} = "陕西省宝鸡市";
$areanames{zh}->{861320922} = "陕西省宝鸡市";
$areanames{zh}->{861320923} = "陕西省宝鸡市";
$areanames{zh}->{861320924} = "陕西省汉中市";
$areanames{zh}->{861320925} = "陕西省汉中市";
$areanames{zh}->{861320926} = "陕西省汉中市";
$areanames{zh}->{861320927} = "陕西省汉中市";
$areanames{zh}->{861320928} = "陕西省延安市";
$areanames{zh}->{861320929} = "陕西省延安市";
$areanames{zh}->{861320930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861320931} = "甘肃省兰州市";
$areanames{zh}->{861320932} = "甘肃省定西市";
$areanames{zh}->{861320933} = "甘肃省平凉市";
$areanames{zh}->{861320934} = "甘肃省庆阳市";
$areanames{zh}->{861320935} = "甘肃省武威市";
$areanames{zh}->{861320936} = "甘肃省张掖市";
$areanames{zh}->{861320937} = "甘肃省酒泉市";
$areanames{zh}->{861320938} = "甘肃省天水市";
$areanames{zh}->{861320939} = "甘肃省陇南市";
$areanames{zh}->{861320940} = "甘肃省酒泉市";
$areanames{zh}->{861320941} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861320942} = "甘肃省酒泉市";
$areanames{zh}->{861320943} = "甘肃省白银市";
$areanames{zh}->{861320944} = "甘肃省陇南市";
$areanames{zh}->{861320945} = "甘肃省金昌市";
$areanames{zh}->{861320946} = "甘肃省兰州市";
$areanames{zh}->{861320947} = "甘肃省嘉峪关市";
$areanames{zh}->{861320948} = "甘肃省嘉峪关市";
$areanames{zh}->{861320949} = "甘肃省白银市";
$areanames{zh}->{861320950} = "宁夏银川市";
$areanames{zh}->{861320951} = "宁夏银川市";
$areanames{zh}->{861320952} = "宁夏石嘴山市";
$areanames{zh}->{861320953} = "宁夏吴忠市";
$areanames{zh}->{861320954} = "宁夏固原市";
$areanames{zh}->{861320955} = "宁夏中卫市";
$areanames{zh}->{861320956} = "宁夏石嘴山市";
$areanames{zh}->{861320957} = "宁夏中卫市";
$areanames{zh}->{861320958} = "宁夏银川市";
$areanames{zh}->{861320959} = "宁夏银川市";
$areanames{zh}->{861320960} = "宁夏银川市";
$areanames{zh}->{861320961} = "宁夏银川市";
$areanames{zh}->{861320962} = "宁夏石嘴山市";
$areanames{zh}->{861320963} = "宁夏吴忠市";
$areanames{zh}->{861320964} = "宁夏中卫市";
$areanames{zh}->{861320965} = "宁夏中卫市";
$areanames{zh}->{861320966} = "宁夏石嘴山市";
$areanames{zh}->{861320967} = "宁夏中卫市";
$areanames{zh}->{861320968} = "宁夏银川市";
$areanames{zh}->{861320969} = "宁夏银川市";
$areanames{zh}->{861320970} = "青海省海北藏族自治州";
$areanames{zh}->{861320971} = "青海省西宁市";
$areanames{zh}->{861320972} = "青海省海东地区";
$areanames{zh}->{861320973} = "青海省黄南藏族自治州";
$areanames{zh}->{861320974} = "青海省海南藏族自治州";
$areanames{zh}->{861320975} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861320976} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861320977} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861320978} = "青海省西宁市";
$areanames{zh}->{861320979} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861320980} = "山西省太原市";
$areanames{zh}->{861320981} = "山西省太原市";
$areanames{zh}->{861320982} = "山西省太原市";
$areanames{zh}->{861320983} = "山西省大同市";
$areanames{zh}->{861320984} = "山西省大同市";
$areanames{zh}->{861320985} = "山西省长治市";
$areanames{zh}->{861320986} = "山西省临汾市";
$areanames{zh}->{861320987} = "山西省晋城市";
$areanames{zh}->{861320988} = "山西省晋中市";
$areanames{zh}->{861320989} = "山西省运城市";
$areanames{zh}->{86132099} = "新疆乌鲁木齐市";
$areanames{zh}->{861320994} = "新疆昌吉回族自治州";
$areanames{zh}->{86132100} = "山东省青岛市";
$areanames{zh}->{86132101} = "山东省青岛市";
$areanames{zh}->{86132102} = "山东省青岛市";
$areanames{zh}->{86132103} = "山东省东营市";
$areanames{zh}->{861321040} = "山东省滨州市";
$areanames{zh}->{861321041} = "山东省滨州市";
$areanames{zh}->{861321042} = "山东省临沂市";
$areanames{zh}->{861321043} = "山东省临沂市";
$areanames{zh}->{861321044} = "山东省德州市";
$areanames{zh}->{861321045} = "山东省聊城市";
$areanames{zh}->{861321046} = "山东省聊城市";
$areanames{zh}->{861321047} = "山东省枣庄市";
$areanames{zh}->{861321048} = "山东省枣庄市";
$areanames{zh}->{861321049} = "山东省济宁市";
$areanames{zh}->{86132105} = "山东省济南市";
$areanames{zh}->{861321060} = "山东省莱芜市";
$areanames{zh}->{861321061} = "山东省泰安市";
$areanames{zh}->{861321062} = "山东省泰安市";
$areanames{zh}->{861321063} = "山东省日照市";
$areanames{zh}->{861321064} = "山东省日照市";
$areanames{zh}->{861321065} = "山东省临沂市";
$areanames{zh}->{861321066} = "山东省临沂市";
$areanames{zh}->{861321067} = "山东省淄博市";
$areanames{zh}->{861321068} = "山东省潍坊市";
$areanames{zh}->{861321069} = "山东省泰安市";
$areanames{zh}->{861321070} = "山东省滨州市";
$areanames{zh}->{861321071} = "山东省滨州市";
$areanames{zh}->{861321072} = "山东省滨州市";
$areanames{zh}->{861321073} = "山东省潍坊市";
$areanames{zh}->{861321074} = "山东省潍坊市";
$areanames{zh}->{861321075} = "山东省潍坊市";
$areanames{zh}->{861321076} = "山东省潍坊市";
$areanames{zh}->{861321077} = "山东省枣庄市";
$areanames{zh}->{861321078} = "山东省枣庄市";
$areanames{zh}->{861321079} = "山东省济宁市";
$areanames{zh}->{86132108} = "山东省青岛市";
$areanames{zh}->{861321090} = "山东省威海市";
$areanames{zh}->{861321091} = "山东省烟台市";
$areanames{zh}->{861321092} = "山东省烟台市";
$areanames{zh}->{861321093} = "山东省烟台市";
$areanames{zh}->{861321094} = "山东省烟台市";
$areanames{zh}->{861321095} = "山东省聊城市";
$areanames{zh}->{861321096} = "山东省聊城市";
$areanames{zh}->{861321097} = "山东省德州市";
$areanames{zh}->{861321098} = "山东省德州市";
$areanames{zh}->{861321099} = "山东省德州市";
$areanames{zh}->{861321100} = "广东省东莞市";
$areanames{zh}->{861321101} = "广东省东莞市";
$areanames{zh}->{861321102} = "广东省汕尾市";
$areanames{zh}->{861321103} = "广东省汕尾市";
$areanames{zh}->{861321104} = "广东省肇庆市";
$areanames{zh}->{861321105} = "广东省肇庆市";
$areanames{zh}->{861321106} = "广东省肇庆市";
$areanames{zh}->{861321107} = "河北省邢台市";
$areanames{zh}->{861321108} = "河北省邢台市";
$areanames{zh}->{861321109} = "河北省邢台市";
$areanames{zh}->{86132111} = "广东省佛山市";
$areanames{zh}->{861321110} = "广东省清远市";
$areanames{zh}->{861321111} = "广东省清远市";
$areanames{zh}->{861321112} = "广东省中山市";
$areanames{zh}->{86132112} = "广东省汕头市";
$areanames{zh}->{861321126} = "广东省江门市";
$areanames{zh}->{861321127} = "广东省江门市";
$areanames{zh}->{861321128} = "广东省江门市";
$areanames{zh}->{861321129} = "广东省江门市";
$areanames{zh}->{86132113} = "广西南宁市";
$areanames{zh}->{861321140} = "广西柳州市";
$areanames{zh}->{861321141} = "广西柳州市";
$areanames{zh}->{861321142} = "广西来宾市";
$areanames{zh}->{861321143} = "广西桂林市";
$areanames{zh}->{861321144} = "广西贺州市";
$areanames{zh}->{861321145} = "广西玉林市";
$areanames{zh}->{861321146} = "广西百色市";
$areanames{zh}->{861321147} = "广西贵港市";
$areanames{zh}->{861321148} = "广西河池市";
$areanames{zh}->{861321149} = "广西贵港市";
$areanames{zh}->{861321150} = "广西桂林市";
$areanames{zh}->{861321151} = "广西柳州市";
$areanames{zh}->{861321152} = "广西柳州市";
$areanames{zh}->{861321153} = "广西桂林市";
$areanames{zh}->{861321154} = "广西桂林市";
$areanames{zh}->{861321155} = "广西玉林市";
$areanames{zh}->{861321156} = "广西玉林市";
$areanames{zh}->{861321157} = "广西贵港市";
$areanames{zh}->{861321158} = "广西来宾市";
$areanames{zh}->{861321159} = "广西桂林市";
$areanames{zh}->{86132116} = "云南省昆明市";
$areanames{zh}->{86132117} = "云南省昆明市";
$areanames{zh}->{861321180} = "云南省保山市";
$areanames{zh}->{861321181} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861321182} = "云南省楚雄彝族自治州";
$areanames{zh}->{861321183} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861321184} = "云南省昭通市";
$areanames{zh}->{861321185} = "云南省昭通市";
$areanames{zh}->{861321186} = "云南省昭通市";
$areanames{zh}->{861321187} = "云南省曲靖市";
$areanames{zh}->{861321188} = "云南省曲靖市";
$areanames{zh}->{861321189} = "云南省曲靖市";
$areanames{zh}->{861321190} = "云南省大理白族自治州";
$areanames{zh}->{861321191} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861321192} = "云南省昆明市";
$areanames{zh}->{861321193} = "云南省临沧市";
$areanames{zh}->{861321194} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861321195} = "云南省玉溪市";
$areanames{zh}->{861321196} = "云南省玉溪市";
$areanames{zh}->{861321197} = "云南省迪庆藏族自治州";
$areanames{zh}->{861321198} = "云南省普洱市";
$areanames{zh}->{861321199} = "云南省普洱市";
$areanames{zh}->{86132120} = "天津市";
$areanames{zh}->{86132121} = "天津市";
$areanames{zh}->{86132122} = "天津市";
$areanames{zh}->{86132123} = "重庆市";
$areanames{zh}->{86132124} = "重庆市";
$areanames{zh}->{86132125} = "重庆市";
$areanames{zh}->{861321260} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861321261} = "湖南省长沙市";
$areanames{zh}->{861321262} = "湖南省长沙市";
$areanames{zh}->{861321263} = "湖南省长沙市";
$areanames{zh}->{861321264} = "湖南省张家界市";
$areanames{zh}->{861321265} = "湖南省怀化市";
$areanames{zh}->{861321266} = "湖南省永州市";
$areanames{zh}->{861321267} = "湖南省娄底市";
$areanames{zh}->{861321268} = "湖南省衡阳市";
$areanames{zh}->{861321269} = "湖南省衡阳市";
$areanames{zh}->{86132127} = "湖北省武汉市";
$areanames{zh}->{861321280} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321281} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321282} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861321283} = "黑龙江省牡丹江市";
$areanames{zh}->{861321284} = "黑龙江省佳木斯市";
$areanames{zh}->{861321285} = "黑龙江省绥化市";
$areanames{zh}->{861321286} = "黑龙江省黑河市";
$areanames{zh}->{861321287} = "黑龙江省鸡西市";
$areanames{zh}->{861321288} = "黑龙江省伊春市";
$areanames{zh}->{861321289} = "黑龙江省大庆市";
$areanames{zh}->{861321290} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321291} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321292} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321293} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321294} = "黑龙江省双鸭山市";
$areanames{zh}->{861321295} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861321296} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861321297} = "黑龙江省鹤岗市";
$areanames{zh}->{861321298} = "黑龙江省佳木斯市";
$areanames{zh}->{861321299} = "黑龙江省佳木斯市";
$areanames{zh}->{86132130} = "河南省郑州市";
$areanames{zh}->{86132131} = "河南省郑州市";
$areanames{zh}->{861321320} = "河南省郑州市";
$areanames{zh}->{861321321} = "河南省郑州市";
$areanames{zh}->{861321322} = "河南省郑州市";
$areanames{zh}->{861321323} = "河南省郑州市";
$areanames{zh}->{861321324} = "河南省郑州市";
$areanames{zh}->{861321325} = "河南省安阳市";
$areanames{zh}->{861321326} = "河南省安阳市";
$areanames{zh}->{861321327} = "河南省安阳市";
$areanames{zh}->{861321328} = "河南省安阳市";
$areanames{zh}->{861321329} = "河南省安阳市";
$areanames{zh}->{861321330} = "河南省周口市";
$areanames{zh}->{861321331} = "河南省周口市";
$areanames{zh}->{861321332} = "河南省周口市";
$areanames{zh}->{861321333} = "河南省周口市";
$areanames{zh}->{861321334} = "河南省周口市";
$areanames{zh}->{861321335} = "河南省许昌市";
$areanames{zh}->{861321336} = "河南省许昌市";
$areanames{zh}->{861321337} = "河南省许昌市";
$areanames{zh}->{861321338} = "河南省许昌市";
$areanames{zh}->{861321339} = "河南省许昌市";
$areanames{zh}->{861321340} = "河南省鹤壁市";
$areanames{zh}->{861321341} = "河南省鹤壁市";
$areanames{zh}->{861321342} = "河南省鹤壁市";
$areanames{zh}->{861321343} = "河南省驻马店市";
$areanames{zh}->{861321344} = "河南省驻马店市";
$areanames{zh}->{861321345} = "河南省驻马店市";
$areanames{zh}->{861321346} = "河南省驻马店市";
$areanames{zh}->{861321347} = "河南省濮阳市";
$areanames{zh}->{861321348} = "河南省濮阳市";
$areanames{zh}->{861321349} = "河南省濮阳市";
$areanames{zh}->{86132135} = "河南省洛阳市";
$areanames{zh}->{86132136} = "河南省洛阳市";
$areanames{zh}->{86132137} = "河南省南阳市";
$areanames{zh}->{86132138} = "河南省平顶山市";
$areanames{zh}->{861321386} = "河南省信阳市";
$areanames{zh}->{861321387} = "河南省信阳市";
$areanames{zh}->{861321388} = "河南省信阳市";
$areanames{zh}->{861321389} = "河南省信阳市";
$areanames{zh}->{86132139} = "河南省濮阳市";
$areanames{zh}->{861321397} = "河南省开封市";
$areanames{zh}->{861321398} = "河南省开封市";
$areanames{zh}->{861321399} = "河南省开封市";
$areanames{zh}->{86132140} = "内蒙古呼和浩特市";
$areanames{zh}->{861321404} = "内蒙古兴安盟";
$areanames{zh}->{861321407} = "内蒙古通辽市";
$areanames{zh}->{861321410} = "辽宁省铁岭市";
$areanames{zh}->{861321411} = "辽宁省大连市";
$areanames{zh}->{861321412} = "辽宁省鞍山市";
$areanames{zh}->{861321413} = "辽宁省抚顺市";
$areanames{zh}->{861321414} = "辽宁省本溪市";
$areanames{zh}->{861321415} = "辽宁省丹东市";
$areanames{zh}->{861321416} = "辽宁省锦州市";
$areanames{zh}->{861321417} = "辽宁省营口市";
$areanames{zh}->{861321418} = "辽宁省阜新市";
$areanames{zh}->{861321419} = "辽宁省辽阳市";
$areanames{zh}->{861321420} = "辽宁省大连市";
$areanames{zh}->{861321421} = "辽宁省朝阳市";
$areanames{zh}->{861321422} = "辽宁省大连市";
$areanames{zh}->{861321423} = "辽宁省沈阳市";
$areanames{zh}->{861321424} = "辽宁省沈阳市";
$areanames{zh}->{861321425} = "辽宁省沈阳市";
$areanames{zh}->{861321426} = "辽宁省沈阳市";
$areanames{zh}->{861321427} = "辽宁省盘锦市";
$areanames{zh}->{861321428} = "辽宁省大连市";
$areanames{zh}->{861321429} = "辽宁省葫芦岛市";
$areanames{zh}->{861321430} = "吉林省长春市";
$areanames{zh}->{861321431} = "吉林省长春市";
$areanames{zh}->{861321432} = "吉林省吉林市";
$areanames{zh}->{861321433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861321434} = "吉林省四平市";
$areanames{zh}->{861321435} = "吉林省通化市";
$areanames{zh}->{861321436} = "吉林省白城市";
$areanames{zh}->{861321437} = "吉林省辽源市";
$areanames{zh}->{861321438} = "吉林省松原市";
$areanames{zh}->{861321439} = "吉林省白山市";
$areanames{zh}->{86132144} = "吉林省长春市";
$areanames{zh}->{861321444} = "吉林省四平市";
$areanames{zh}->{861321445} = "吉林省通化市";
$areanames{zh}->{861321450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861321453} = "黑龙江省牡丹江市";
$areanames{zh}->{861321454} = "黑龙江省佳木斯市";
$areanames{zh}->{861321455} = "黑龙江省绥化市";
$areanames{zh}->{861321456} = "黑龙江省黑河市";
$areanames{zh}->{861321457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861321458} = "黑龙江省伊春市";
$areanames{zh}->{861321459} = "黑龙江省大庆市";
$areanames{zh}->{861321460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861321462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861321463} = "黑龙江省牡丹江市";
$areanames{zh}->{861321464} = "黑龙江省七台河市";
$areanames{zh}->{861321465} = "黑龙江省绥化市";
$areanames{zh}->{861321466} = "黑龙江省黑河市";
$areanames{zh}->{861321467} = "黑龙江省鸡西市";
$areanames{zh}->{861321468} = "黑龙江省鹤岗市";
$areanames{zh}->{861321469} = "黑龙江省双鸭山市";
$areanames{zh}->{861321470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861321471} = "内蒙古呼和浩特市";
$areanames{zh}->{861321472} = "内蒙古包头市";
$areanames{zh}->{861321473} = "内蒙古乌海市";
$areanames{zh}->{861321474} = "内蒙古兴安盟";
$areanames{zh}->{861321475} = "内蒙古通辽市";
$areanames{zh}->{861321476} = "内蒙古赤峰市";
$areanames{zh}->{861321477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861321478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861321479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861321480} = "内蒙古兴安盟";
$areanames{zh}->{861321481} = "内蒙古通辽市";
$areanames{zh}->{861321482} = "内蒙古兴安盟";
$areanames{zh}->{861321483} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861321484} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861321485} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861321486} = "内蒙古赤峰市";
$areanames{zh}->{861321487} = "内蒙古赤峰市";
$areanames{zh}->{861321488} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861321489} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86132149} = "内蒙古包头市";
$areanames{zh}->{861321497} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861321498} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861321499} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861321500} = "福建省福州市";
$areanames{zh}->{861321501} = "福建省厦门市";
$areanames{zh}->{861321502} = "福建省厦门市";
$areanames{zh}->{861321503} = "福建省三明市";
$areanames{zh}->{861321504} = "福建省福州市";
$areanames{zh}->{861321505} = "福建省莆田市";
$areanames{zh}->{861321506} = "福建省泉州市";
$areanames{zh}->{861321507} = "福建省泉州市";
$areanames{zh}->{861321508} = "福建省莆田市";
$areanames{zh}->{861321509} = "福建省龙岩市";
$areanames{zh}->{86132151} = "广东省东莞市";
$areanames{zh}->{86132152} = "广东省东莞市";
$areanames{zh}->{86132153} = "广东省东莞市";
$areanames{zh}->{86132154} = "河北省廊坊市";
$areanames{zh}->{861321542} = "广东省东莞市";
$areanames{zh}->{861321546} = "广东省东莞市";
$areanames{zh}->{861321550} = "安徽省滁州市";
$areanames{zh}->{861321551} = "安徽省合肥市";
$areanames{zh}->{861321552} = "安徽省蚌埠市";
$areanames{zh}->{861321553} = "安徽省芜湖市";
$areanames{zh}->{861321554} = "安徽省淮南市";
$areanames{zh}->{861321555} = "安徽省马鞍山市";
$areanames{zh}->{861321556} = "安徽省安庆市";
$areanames{zh}->{861321557} = "安徽省宿州市";
$areanames{zh}->{861321558} = "安徽省阜阳市";
$areanames{zh}->{861321559} = "安徽省黄山市";
$areanames{zh}->{861321560} = "安徽省合肥市";
$areanames{zh}->{861321561} = "安徽省淮北市";
$areanames{zh}->{861321562} = "安徽省铜陵市";
$areanames{zh}->{861321563} = "安徽省宣城市";
$areanames{zh}->{861321564} = "安徽省六安市";
$areanames{zh}->{861321565} = "安徽省合肥市";
$areanames{zh}->{861321566} = "安徽省池州市";
$areanames{zh}->{861321567} = "安徽省亳州市";
$areanames{zh}->{861321568} = "安徽省阜阳市";
$areanames{zh}->{861321569} = "安徽省合肥市";
$areanames{zh}->{86132157} = "海南省海口市";
$areanames{zh}->{86132158} = "海南省海口市";
$areanames{zh}->{861321590} = "福建省三明市";
$areanames{zh}->{861321591} = "福建省厦门市";
$areanames{zh}->{861321592} = "福建省厦门市";
$areanames{zh}->{861321593} = "福建省南平市";
$areanames{zh}->{861321594} = "福建省厦门市";
$areanames{zh}->{861321595} = "福建省泉州市";
$areanames{zh}->{861321596} = "福建省漳州市";
$areanames{zh}->{861321597} = "福建省福州市";
$areanames{zh}->{861321598} = "福建省福州市";
$areanames{zh}->{861321599} = "河南省郑州市";
$areanames{zh}->{86132160} = "浙江省温州市";
$areanames{zh}->{86132161} = "浙江省杭州市";
$areanames{zh}->{86132162} = "浙江省金华市";
$areanames{zh}->{861321627} = "浙江省衢州市";
$areanames{zh}->{861321628} = "浙江省衢州市";
$areanames{zh}->{861321629} = "浙江省衢州市";
$areanames{zh}->{86132163} = "浙江省嘉兴市";
$areanames{zh}->{861321640} = "浙江省衢州市";
$areanames{zh}->{861321641} = "浙江省衢州市";
$areanames{zh}->{861321642} = "浙江省湖州市";
$areanames{zh}->{861321643} = "浙江省丽水市";
$areanames{zh}->{861321644} = "浙江省丽水市";
$areanames{zh}->{861321645} = "浙江省绍兴市";
$areanames{zh}->{861321646} = "浙江省绍兴市";
$areanames{zh}->{861321647} = "浙江省温州市";
$areanames{zh}->{861321648} = "浙江省台州市";
$areanames{zh}->{861321649} = "浙江省台州市";
$areanames{zh}->{86132165} = "浙江省湖州市";
$areanames{zh}->{861321657} = "浙江省舟山市";
$areanames{zh}->{861321658} = "浙江省舟山市";
$areanames{zh}->{861321659} = "浙江省舟山市";
$areanames{zh}->{86132166} = "浙江省宁波市";
$areanames{zh}->{861321670} = "浙江省杭州市";
$areanames{zh}->{861321671} = "浙江省杭州市";
$areanames{zh}->{861321672} = "浙江省湖州市";
$areanames{zh}->{861321673} = "浙江省嘉兴市";
$areanames{zh}->{861321674} = "浙江省宁波市";
$areanames{zh}->{861321675} = "浙江省绍兴市";
$areanames{zh}->{861321676} = "浙江省绍兴市";
$areanames{zh}->{861321677} = "浙江省绍兴市";
$areanames{zh}->{861321678} = "浙江省绍兴市";
$areanames{zh}->{861321679} = "浙江省金华市";
$areanames{zh}->{861321680} = "浙江省舟山市";
$areanames{zh}->{861321681} = "浙江省杭州市";
$areanames{zh}->{861321682} = "浙江省宁波市";
$areanames{zh}->{861321683} = "浙江省宁波市";
$areanames{zh}->{861321684} = "浙江省宁波市";
$areanames{zh}->{861321685} = "浙江省绍兴市";
$areanames{zh}->{861321686} = "浙江省丽水市";
$areanames{zh}->{861321687} = "浙江省丽水市";
$areanames{zh}->{861321688} = "浙江省丽水市";
$areanames{zh}->{861321689} = "浙江省丽水市";
$areanames{zh}->{86132169} = "浙江省台州市";
$areanames{zh}->{861321700} = "江西省南昌市";
$areanames{zh}->{861321701} = "江西省鹰潭市";
$areanames{zh}->{861321702} = "江西省九江市";
$areanames{zh}->{861321703} = "江西省景德镇市";
$areanames{zh}->{861321704} = "江西省抚州市";
$areanames{zh}->{861321705} = "江西省宜春市";
$areanames{zh}->{861321706} = "江西省吉安市";
$areanames{zh}->{861321707} = "江西省赣州市";
$areanames{zh}->{861321708} = "江西省新余市";
$areanames{zh}->{861321709} = "江西省萍乡市";
$areanames{zh}->{861321710} = "湖北省襄樊市";
$areanames{zh}->{861321711} = "湖北省鄂州市";
$areanames{zh}->{861321712} = "湖北省孝感市";
$areanames{zh}->{861321713} = "湖北省黄冈市";
$areanames{zh}->{861321714} = "湖北省黄石市";
$areanames{zh}->{861321715} = "湖北省咸宁市";
$areanames{zh}->{861321716} = "湖北省荆州市";
$areanames{zh}->{861321717} = "湖北省宜昌市";
$areanames{zh}->{861321718} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861321719} = "湖北省十堰市";
$areanames{zh}->{861321720} = "湖北省襄樊市";
$areanames{zh}->{861321721} = "湖北省孝感市";
$areanames{zh}->{861321722} = "湖北省随州市";
$areanames{zh}->{861321723} = "湖北省黄冈市";
$areanames{zh}->{861321724} = "湖北省荆门市";
$areanames{zh}->{861321725} = "湖北省黄冈市";
$areanames{zh}->{861321726} = "湖北省荆州市";
$areanames{zh}->{861321727} = "湖北省宜昌市";
$areanames{zh}->{861321728} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861321729} = "湖北省荆州市";
$areanames{zh}->{861321730} = "湖南省岳阳市";
$areanames{zh}->{861321731} = "湖南省长沙市";
$areanames{zh}->{861321732} = "湖南省湘潭市";
$areanames{zh}->{861321733} = "湖南省株洲市";
$areanames{zh}->{861321734} = "湖南省衡阳市";
$areanames{zh}->{861321735} = "湖南省郴州市";
$areanames{zh}->{861321736} = "湖南省常德市";
$areanames{zh}->{861321737} = "湖南省益阳市";
$areanames{zh}->{861321738} = "湖南省娄底市";
$areanames{zh}->{861321739} = "湖南省邵阳市";
$areanames{zh}->{861321740} = "湖南省岳阳市";
$areanames{zh}->{861321741} = "湖南省长沙市";
$areanames{zh}->{861321742} = "湖南省湘潭市";
$areanames{zh}->{861321743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861321744} = "湖南省张家界市";
$areanames{zh}->{861321745} = "湖南省怀化市";
$areanames{zh}->{861321746} = "湖南省永州市";
$areanames{zh}->{861321747} = "湖南省怀化市";
$areanames{zh}->{861321748} = "湖南省长沙市";
$areanames{zh}->{861321749} = "湖南省邵阳市";
$areanames{zh}->{861321750} = "广东省江门市";
$areanames{zh}->{861321751} = "广东省韶关市";
$areanames{zh}->{861321752} = "广东省惠州市";
$areanames{zh}->{861321753} = "广东省梅州市";
$areanames{zh}->{861321754} = "广东省汕头市";
$areanames{zh}->{861321755} = "广东省汕头市";
$areanames{zh}->{861321756} = "广东省珠海市";
$areanames{zh}->{861321757} = "广东省佛山市";
$areanames{zh}->{861321758} = "广东省肇庆市";
$areanames{zh}->{861321759} = "广东省湛江市";
$areanames{zh}->{861321760} = "广东省中山市";
$areanames{zh}->{861321761} = "广东省河源市";
$areanames{zh}->{861321762} = "广东省河源市";
$areanames{zh}->{861321763} = "广东省清远市";
$areanames{zh}->{861321764} = "广东省佛山市";
$areanames{zh}->{861321765} = "广东省佛山市";
$areanames{zh}->{861321766} = "广东省云浮市";
$areanames{zh}->{861321767} = "广东省潮州市";
$areanames{zh}->{861321768} = "广东省潮州市";
$areanames{zh}->{861321769} = "广东省东莞市";
$areanames{zh}->{861321770} = "广西防城港市";
$areanames{zh}->{861321771} = "广西南宁市";
$areanames{zh}->{861321772} = "广西柳州市";
$areanames{zh}->{861321773} = "广西桂林市";
$areanames{zh}->{861321774} = "广西梧州市";
$areanames{zh}->{861321775} = "广西玉林市";
$areanames{zh}->{861321776} = "广西百色市";
$areanames{zh}->{861321777} = "广西钦州市";
$areanames{zh}->{861321778} = "广西河池市";
$areanames{zh}->{861321779} = "广西北海市";
$areanames{zh}->{861321780} = "广西南宁市";
$areanames{zh}->{861321781} = "广西南宁市";
$areanames{zh}->{861321782} = "广西来宾市";
$areanames{zh}->{861321783} = "广西桂林市";
$areanames{zh}->{861321784} = "广西贺州市";
$areanames{zh}->{861321785} = "广西玉林市";
$areanames{zh}->{861321786} = "广西百色市";
$areanames{zh}->{861321787} = "广西柳州市";
$areanames{zh}->{861321788} = "广西河池市";
$areanames{zh}->{861321789} = "广西贺州市";
$areanames{zh}->{861321790} = "江西省新余市";
$areanames{zh}->{861321791} = "江西省南昌市";
$areanames{zh}->{861321792} = "江西省九江市";
$areanames{zh}->{861321793} = "江西省上饶市";
$areanames{zh}->{861321794} = "江西省抚州市";
$areanames{zh}->{861321795} = "江西省宜春市";
$areanames{zh}->{861321796} = "江西省吉安市";
$areanames{zh}->{861321797} = "江西省赣州市";
$areanames{zh}->{861321798} = "江西省景德镇市";
$areanames{zh}->{861321799} = "江西省萍乡市";
$areanames{zh}->{86132180} = "江苏省南京市";
$areanames{zh}->{86132181} = "江苏省苏州市";
$areanames{zh}->{86132182} = "江苏省南通市";
$areanames{zh}->{86132183} = "江苏省镇江市";
$areanames{zh}->{861321830} = "江苏省淮安市";
$areanames{zh}->{861321831} = "江苏省淮安市";
$areanames{zh}->{861321832} = "江苏省淮安市";
$areanames{zh}->{861321833} = "江苏省淮安市";
$areanames{zh}->{861321840} = "江苏省徐州市";
$areanames{zh}->{861321841} = "江苏省镇江市";
$areanames{zh}->{861321842} = "江苏省扬州市";
$areanames{zh}->{861321843} = "江苏省南通市";
$areanames{zh}->{861321844} = "江苏省南通市";
$areanames{zh}->{861321845} = "江苏省苏州市";
$areanames{zh}->{861321846} = "江苏省苏州市";
$areanames{zh}->{861321847} = "江苏省常州市";
$areanames{zh}->{861321848} = "江苏省南京市";
$areanames{zh}->{861321849} = "江苏省南京市";
$areanames{zh}->{86132185} = "江苏省徐州市";
$areanames{zh}->{861321850} = "江苏省盐城市";
$areanames{zh}->{861321851} = "江苏省盐城市";
$areanames{zh}->{861321852} = "江苏省盐城市";
$areanames{zh}->{86132186} = "江苏省常州市";
$areanames{zh}->{861321860} = "江苏省盐城市";
$areanames{zh}->{861321861} = "江苏省盐城市";
$areanames{zh}->{861321862} = "江苏省盐城市";
$areanames{zh}->{861321863} = "江苏省盐城市";
$areanames{zh}->{86132187} = "江苏省无锡市";
$areanames{zh}->{861321870} = "江苏省泰州市";
$areanames{zh}->{861321871} = "江苏省泰州市";
$areanames{zh}->{861321872} = "江苏省泰州市";
$areanames{zh}->{861321880} = "江苏省徐州市";
$areanames{zh}->{861321881} = "江苏省镇江市";
$areanames{zh}->{861321882} = "江苏省扬州市";
$areanames{zh}->{861321883} = "江苏省南通市";
$areanames{zh}->{861321884} = "江苏省淮安市";
$areanames{zh}->{861321885} = "江苏省无锡市";
$areanames{zh}->{861321886} = "江苏省苏州市";
$areanames{zh}->{861321887} = "江苏省常州市";
$areanames{zh}->{861321888} = "江苏省南京市";
$areanames{zh}->{861321889} = "江苏省南京市";
$areanames{zh}->{86132189} = "江苏省扬州市";
$areanames{zh}->{861321890} = "江苏省宿迁市";
$areanames{zh}->{861321891} = "江苏省宿迁市";
$areanames{zh}->{861321892} = "江苏省宿迁市";
$areanames{zh}->{861321893} = "江苏省宿迁市";
$areanames{zh}->{86132190} = "四川省成都市";
$areanames{zh}->{86132191} = "四川省南充市";
$areanames{zh}->{861321916} = "四川省达州市";
$areanames{zh}->{861321917} = "四川省达州市";
$areanames{zh}->{861321918} = "四川省达州市";
$areanames{zh}->{861321919} = "四川省达州市";
$areanames{zh}->{861321920} = "四川省遂宁市";
$areanames{zh}->{861321921} = "四川省遂宁市";
$areanames{zh}->{861321922} = "四川省遂宁市";
$areanames{zh}->{861321923} = "四川省遂宁市";
$areanames{zh}->{861321924} = "四川省广安市";
$areanames{zh}->{861321925} = "四川省广安市";
$areanames{zh}->{861321926} = "四川省广安市";
$areanames{zh}->{861321927} = "四川省广安市";
$areanames{zh}->{861321928} = "四川省巴中市";
$areanames{zh}->{861321929} = "四川省巴中市";
$areanames{zh}->{86132193} = "四川省泸州市";
$areanames{zh}->{861321930} = "四川省巴中市";
$areanames{zh}->{861321931} = "四川省巴中市";
$areanames{zh}->{861321932} = "四川省巴中市";
$areanames{zh}->{861321939} = "四川省宜宾市";
$areanames{zh}->{861321940} = "四川省南充市";
$areanames{zh}->{861321941} = "四川省达州市";
$areanames{zh}->{861321942} = "四川省内江市";
$areanames{zh}->{861321943} = "四川省资阳市";
$areanames{zh}->{861321944} = "四川省乐山市";
$areanames{zh}->{861321945} = "四川省眉山市";
$areanames{zh}->{861321946} = "四川省甘孜藏族自治州";
$areanames{zh}->{861321947} = "四川省德阳市";
$areanames{zh}->{861321948} = "四川省绵阳市";
$areanames{zh}->{861321949} = "四川省广元市";
$areanames{zh}->{861321950} = "四川省宜宾市";
$areanames{zh}->{861321951} = "四川省宜宾市";
$areanames{zh}->{861321952} = "四川省宜宾市";
$areanames{zh}->{861321953} = "四川省宜宾市";
$areanames{zh}->{861321954} = "四川省宜宾市";
$areanames{zh}->{861321955} = "四川省内江市";
$areanames{zh}->{861321956} = "四川省内江市";
$areanames{zh}->{861321957} = "四川省内江市";
$areanames{zh}->{861321958} = "四川省内江市";
$areanames{zh}->{861321959} = "四川省资阳市";
$areanames{zh}->{861321960} = "陕西省榆林市";
$areanames{zh}->{861321961} = "陕西省榆林市";
$areanames{zh}->{861321962} = "陕西省榆林市";
$areanames{zh}->{861321963} = "四川省自贡市";
$areanames{zh}->{861321964} = "四川省自贡市";
$areanames{zh}->{861321965} = "四川省自贡市";
$areanames{zh}->{861321966} = "四川省自贡市";
$areanames{zh}->{861321967} = "四川省乐山市";
$areanames{zh}->{861321968} = "四川省乐山市";
$areanames{zh}->{861321969} = "四川省乐山市";
$areanames{zh}->{861321970} = "四川省乐山市";
$areanames{zh}->{861321971} = "四川省乐山市";
$areanames{zh}->{861321972} = "四川省乐山市";
$areanames{zh}->{861321973} = "四川省眉山市";
$areanames{zh}->{861321974} = "四川省眉山市";
$areanames{zh}->{861321975} = "四川省眉山市";
$areanames{zh}->{861321976} = "四川省眉山市";
$areanames{zh}->{861321977} = "陕西省汉中市";
$areanames{zh}->{861321978} = "四川省雅安市";
$areanames{zh}->{861321979} = "四川省攀枝花市";
$areanames{zh}->{861321980} = "四川省攀枝花市";
$areanames{zh}->{861321981} = "四川省攀枝花市";
$areanames{zh}->{861321982} = "陕西省渭南市";
$areanames{zh}->{861321983} = "四川省宜宾市";
$areanames{zh}->{861321984} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861321985} = "四川省德阳市";
$areanames{zh}->{861321986} = "四川省德阳市";
$areanames{zh}->{861321987} = "四川省德阳市";
$areanames{zh}->{861321988} = "四川省德阳市";
$areanames{zh}->{861321989} = "四川省德阳市";
$areanames{zh}->{86132199} = "四川省绵阳市";
$areanames{zh}->{861321990} = "四川省广元市";
$areanames{zh}->{861321991} = "四川省广元市";
$areanames{zh}->{861321992} = "四川省广元市";
$areanames{zh}->{861322000} = "陕西省咸阳市";
$areanames{zh}->{861322001} = "陕西省延安市";
$areanames{zh}->{861322002} = "陕西省榆林市";
$areanames{zh}->{861322003} = "陕西省渭南市";
$areanames{zh}->{861322004} = "陕西省渭南市";
$areanames{zh}->{861322005} = "陕西省渭南市";
$areanames{zh}->{861322006} = "陕西省延安市";
$areanames{zh}->{861322007} = "陕西省宝鸡市";
$areanames{zh}->{861322008} = "陕西省延安市";
$areanames{zh}->{861322009} = "陕西省宝鸡市";
$areanames{zh}->{86132201} = "北京市";
$areanames{zh}->{86132202} = "重庆市";
$areanames{zh}->{86132203} = "重庆市";
$areanames{zh}->{861322040} = "甘肃省兰州市";
$areanames{zh}->{861322041} = "甘肃省白银市";
$areanames{zh}->{861322042} = "甘肃省平凉市";
$areanames{zh}->{861322043} = "甘肃省天水市";
$areanames{zh}->{861322044} = "甘肃省张掖市";
$areanames{zh}->{861322045} = "甘肃省兰州市";
$areanames{zh}->{861322046} = "甘肃省兰州市";
$areanames{zh}->{861322047} = "甘肃省临夏回族自治州";
$areanames{zh}->{861322048} = "甘肃省兰州市";
$areanames{zh}->{861322049} = "甘肃省临夏回族自治州";
$areanames{zh}->{861322050} = "山东省东营市";
$areanames{zh}->{861322051} = "山东省东营市";
$areanames{zh}->{861322052} = "山东省东营市";
$areanames{zh}->{861322053} = "山东省临沂市";
$areanames{zh}->{861322054} = "山东省临沂市";
$areanames{zh}->{861322055} = "山东省济南市";
$areanames{zh}->{861322056} = "山东省济南市";
$areanames{zh}->{861322057} = "山东省济南市";
$areanames{zh}->{861322058} = "山东省济南市";
$areanames{zh}->{861322059} = "山东省济南市";
$areanames{zh}->{861322060} = "山东省莱芜市";
$areanames{zh}->{861322061} = "山东省泰安市";
$areanames{zh}->{861322062} = "山东省泰安市";
$areanames{zh}->{861322063} = "山东省日照市";
$areanames{zh}->{861322064} = "山东省日照市";
$areanames{zh}->{861322065} = "山东省临沂市";
$areanames{zh}->{861322066} = "山东省临沂市";
$areanames{zh}->{861322067} = "山东省淄博市";
$areanames{zh}->{861322068} = "山东省淄博市";
$areanames{zh}->{861322069} = "山东省淄博市";
$areanames{zh}->{861322070} = "山东省滨州市";
$areanames{zh}->{861322071} = "山东省滨州市";
$areanames{zh}->{861322072} = "山东省滨州市";
$areanames{zh}->{861322073} = "山东省潍坊市";
$areanames{zh}->{861322074} = "山东省潍坊市";
$areanames{zh}->{861322075} = "山东省潍坊市";
$areanames{zh}->{861322076} = "山东省潍坊市";
$areanames{zh}->{861322077} = "山东省枣庄市";
$areanames{zh}->{861322078} = "山东省枣庄市";
$areanames{zh}->{861322079} = "山东省济宁市";
$areanames{zh}->{861322080} = "山东省济宁市";
$areanames{zh}->{861322081} = "山东省济宁市";
$areanames{zh}->{861322082} = "山东省威海市";
$areanames{zh}->{861322083} = "山东省威海市";
$areanames{zh}->{861322084} = "山东省威海市";
$areanames{zh}->{861322085} = "山东省青岛市";
$areanames{zh}->{861322086} = "山东省青岛市";
$areanames{zh}->{861322087} = "山东省青岛市";
$areanames{zh}->{861322088} = "山东省青岛市";
$areanames{zh}->{861322089} = "山东省青岛市";
$areanames{zh}->{861322090} = "山东省威海市";
$areanames{zh}->{861322091} = "山东省烟台市";
$areanames{zh}->{861322092} = "山东省烟台市";
$areanames{zh}->{861322093} = "山东省烟台市";
$areanames{zh}->{861322094} = "山东省烟台市";
$areanames{zh}->{861322095} = "山东省聊城市";
$areanames{zh}->{861322096} = "山东省聊城市";
$areanames{zh}->{861322097} = "山东省德州市";
$areanames{zh}->{861322098} = "山东省德州市";
$areanames{zh}->{861322099} = "山东省德州市";
$areanames{zh}->{86132210} = "浙江省杭州市";
$areanames{zh}->{86132211} = "浙江省温州市";
$areanames{zh}->{861322120} = "浙江省湖州市";
$areanames{zh}->{861322121} = "浙江省湖州市";
$areanames{zh}->{861322122} = "浙江省湖州市";
$areanames{zh}->{861322123} = "浙江省湖州市";
$areanames{zh}->{861322124} = "浙江省湖州市";
$areanames{zh}->{861322125} = "浙江省金华市";
$areanames{zh}->{861322126} = "浙江省金华市";
$areanames{zh}->{861322127} = "浙江省金华市";
$areanames{zh}->{861322128} = "浙江省金华市";
$areanames{zh}->{861322129} = "浙江省金华市";
$areanames{zh}->{86132213} = "浙江省嘉兴市";
$areanames{zh}->{861322140} = "浙江省杭州市";
$areanames{zh}->{861322141} = "浙江省杭州市";
$areanames{zh}->{861322142} = "浙江省宁波市";
$areanames{zh}->{861322143} = "浙江省嘉兴市";
$areanames{zh}->{861322144} = "浙江省宁波市";
$areanames{zh}->{861322145} = "浙江省台州市";
$areanames{zh}->{861322146} = "浙江省台州市";
$areanames{zh}->{861322147} = "浙江省温州市";
$areanames{zh}->{861322148} = "浙江省丽水市";
$areanames{zh}->{861322149} = "浙江省金华市";
$areanames{zh}->{86132215} = "浙江省绍兴市";
$areanames{zh}->{86132216} = "浙江省台州市";
$areanames{zh}->{861322170} = "浙江省衢州市";
$areanames{zh}->{861322171} = "浙江省衢州市";
$areanames{zh}->{861322172} = "浙江省衢州市";
$areanames{zh}->{861322173} = "浙江省舟山市";
$areanames{zh}->{861322174} = "浙江省舟山市";
$areanames{zh}->{861322175} = "浙江省舟山市";
$areanames{zh}->{861322176} = "浙江省丽水市";
$areanames{zh}->{861322177} = "浙江省丽水市";
$areanames{zh}->{861322178} = "浙江省丽水市";
$areanames{zh}->{861322179} = "浙江省丽水市";
$areanames{zh}->{861322180} = "浙江省杭州市";
$areanames{zh}->{861322181} = "浙江省杭州市";
$areanames{zh}->{861322182} = "浙江省杭州市";
$areanames{zh}->{861322183} = "浙江省杭州市";
$areanames{zh}->{861322184} = "浙江省嘉兴市";
$areanames{zh}->{861322185} = "浙江省温州市";
$areanames{zh}->{861322186} = "浙江省温州市";
$areanames{zh}->{861322187} = "浙江省宁波市";
$areanames{zh}->{861322188} = "浙江省宁波市";
$areanames{zh}->{861322189} = "浙江省宁波市";
$areanames{zh}->{86132219} = "浙江省宁波市";
$areanames{zh}->{86132220} = "江苏省南京市";
$areanames{zh}->{86132221} = "江苏省南通市";
$areanames{zh}->{86132222} = "江苏省苏州市";
$areanames{zh}->{86132223} = "江苏省盐城市";
$areanames{zh}->{861322230} = "江苏省扬州市";
$areanames{zh}->{861322231} = "江苏省扬州市";
$areanames{zh}->{861322240} = "江苏省无锡市";
$areanames{zh}->{861322241} = "江苏省镇江市";
$areanames{zh}->{861322242} = "江苏省苏州市";
$areanames{zh}->{861322243} = "江苏省南京市";
$areanames{zh}->{861322244} = "江苏省南京市";
$areanames{zh}->{861322245} = "江苏省盐城市";
$areanames{zh}->{861322246} = "江苏省徐州市";
$areanames{zh}->{861322247} = "江苏省常州市";
$areanames{zh}->{861322248} = "江苏省泰州市";
$areanames{zh}->{861322249} = "江苏省南通市";
$areanames{zh}->{86132225} = "江苏省常州市";
$areanames{zh}->{861322254} = "湖南省邵阳市";
$areanames{zh}->{86132226} = "江苏省镇江市";
$areanames{zh}->{861322266} = "江苏省扬州市";
$areanames{zh}->{861322267} = "江苏省扬州市";
$areanames{zh}->{861322268} = "江苏省扬州市";
$areanames{zh}->{861322269} = "江苏省扬州市";
$areanames{zh}->{86132227} = "江苏省南京市";
$areanames{zh}->{861322270} = "江苏省淮安市";
$areanames{zh}->{861322271} = "江苏省淮安市";
$areanames{zh}->{86132228} = "江苏省无锡市";
$areanames{zh}->{861322290} = "江苏省无锡市";
$areanames{zh}->{861322291} = "江苏省无锡市";
$areanames{zh}->{861322292} = "江苏省无锡市";
$areanames{zh}->{861322293} = "江苏省无锡市";
$areanames{zh}->{861322294} = "江苏省无锡市";
$areanames{zh}->{861322295} = "江苏省苏州市";
$areanames{zh}->{861322296} = "江苏省苏州市";
$areanames{zh}->{861322297} = "江苏省苏州市";
$areanames{zh}->{861322298} = "江苏省苏州市";
$areanames{zh}->{861322299} = "江苏省苏州市";
$areanames{zh}->{86132230} = "河南省郑州市";
$areanames{zh}->{861322300} = "河南省商丘市";
$areanames{zh}->{861322310} = "河北省邯郸市";
$areanames{zh}->{861322311} = "河北省邯郸市";
$areanames{zh}->{861322312} = "河北省邯郸市";
$areanames{zh}->{861322313} = "河北省邯郸市";
$areanames{zh}->{861322314} = "河北省邯郸市";
$areanames{zh}->{861322315} = "河北省唐山市";
$areanames{zh}->{861322316} = "河北省唐山市";
$areanames{zh}->{861322317} = "河北省唐山市";
$areanames{zh}->{861322318} = "河北省唐山市";
$areanames{zh}->{861322319} = "河北省唐山市";
$areanames{zh}->{861322320} = "河北省保定市";
$areanames{zh}->{861322321} = "河北省保定市";
$areanames{zh}->{861322322} = "河北省保定市";
$areanames{zh}->{861322323} = "河北省保定市";
$areanames{zh}->{861322324} = "河北省保定市";
$areanames{zh}->{861322325} = "河北省邢台市";
$areanames{zh}->{861322326} = "河北省邢台市";
$areanames{zh}->{861322327} = "河北省邢台市";
$areanames{zh}->{861322328} = "河北省邢台市";
$areanames{zh}->{861322329} = "河北省邢台市";
$areanames{zh}->{86132233} = "河北省秦皇岛市";
$areanames{zh}->{86132234} = "河北省石家庄市";
$areanames{zh}->{861322350} = "山西省忻州市";
$areanames{zh}->{861322351} = "山西省太原市";
$areanames{zh}->{861322352} = "山西省大同市";
$areanames{zh}->{861322353} = "山西省阳泉市";
$areanames{zh}->{861322354} = "山西省晋中市";
$areanames{zh}->{861322355} = "山西省长治市";
$areanames{zh}->{861322356} = "山西省晋城市";
$areanames{zh}->{861322357} = "山西省临汾市";
$areanames{zh}->{861322358} = "山西省吕梁市";
$areanames{zh}->{861322359} = "山西省运城市";
$areanames{zh}->{861322360} = "山西省忻州市";
$areanames{zh}->{861322361} = "山西省朔州市";
$areanames{zh}->{861322362} = "山西省大同市";
$areanames{zh}->{861322363} = "山西省阳泉市";
$areanames{zh}->{861322364} = "山西省太原市";
$areanames{zh}->{861322365} = "山西省长治市";
$areanames{zh}->{861322366} = "山西省晋中市";
$areanames{zh}->{861322367} = "山西省晋城市";
$areanames{zh}->{861322368} = "山西省临汾市";
$areanames{zh}->{861322369} = "山西省运城市";
$areanames{zh}->{861322370} = "河南省商丘市";
$areanames{zh}->{861322371} = "河南省郑州市";
$areanames{zh}->{861322372} = "河南省安阳市";
$areanames{zh}->{861322373} = "河南省新乡市";
$areanames{zh}->{861322374} = "河南省新乡市";
$areanames{zh}->{861322375} = "河南省新乡市";
$areanames{zh}->{861322376} = "河南省新乡市";
$areanames{zh}->{861322377} = "河南省新乡市";
$areanames{zh}->{861322378} = "河南省开封市";
$areanames{zh}->{861322379} = "河南省开封市";
$areanames{zh}->{86132238} = "河南省驻马店市";
$areanames{zh}->{861322380} = "河南省开封市";
$areanames{zh}->{861322390} = "河南省商丘市";
$areanames{zh}->{861322391} = "河南省焦作市";
$areanames{zh}->{861322392} = "河南省焦作市";
$areanames{zh}->{861322393} = "河南省濮阳市";
$areanames{zh}->{861322394} = "河南省周口市";
$areanames{zh}->{861322395} = "河南省周口市";
$areanames{zh}->{861322396} = "河南省驻马店市";
$areanames{zh}->{861322397} = "河南省濮阳市";
$areanames{zh}->{861322398} = "河南省濮阳市";
$areanames{zh}->{861322399} = "河南省安阳市";
$areanames{zh}->{86132240} = "重庆市";
$areanames{zh}->{861322410} = "辽宁省铁岭市";
$areanames{zh}->{861322411} = "辽宁省大连市";
$areanames{zh}->{861322412} = "辽宁省鞍山市";
$areanames{zh}->{861322413} = "辽宁省抚顺市";
$areanames{zh}->{861322414} = "辽宁省本溪市";
$areanames{zh}->{861322415} = "辽宁省丹东市";
$areanames{zh}->{861322416} = "辽宁省锦州市";
$areanames{zh}->{861322417} = "辽宁省营口市";
$areanames{zh}->{861322418} = "辽宁省阜新市";
$areanames{zh}->{861322419} = "辽宁省辽阳市";
$areanames{zh}->{861322420} = "辽宁省大连市";
$areanames{zh}->{861322421} = "辽宁省朝阳市";
$areanames{zh}->{861322422} = "辽宁省大连市";
$areanames{zh}->{861322423} = "辽宁省沈阳市";
$areanames{zh}->{861322424} = "辽宁省沈阳市";
$areanames{zh}->{861322425} = "辽宁省沈阳市";
$areanames{zh}->{861322426} = "辽宁省沈阳市";
$areanames{zh}->{861322427} = "辽宁省盘锦市";
$areanames{zh}->{861322428} = "辽宁省大连市";
$areanames{zh}->{861322429} = "辽宁省葫芦岛市";
$areanames{zh}->{861322430} = "吉林省长春市";
$areanames{zh}->{861322431} = "吉林省长春市";
$areanames{zh}->{861322432} = "吉林省吉林市";
$areanames{zh}->{861322433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861322434} = "吉林省四平市";
$areanames{zh}->{861322435} = "吉林省通化市";
$areanames{zh}->{861322436} = "吉林省白城市";
$areanames{zh}->{861322437} = "吉林省辽源市";
$areanames{zh}->{861322438} = "吉林省松原市";
$areanames{zh}->{861322439} = "吉林省白山市";
$areanames{zh}->{861322440} = "吉林省四平市";
$areanames{zh}->{861322441} = "吉林省四平市";
$areanames{zh}->{861322442} = "吉林省吉林市";
$areanames{zh}->{861322443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861322444} = "吉林省四平市";
$areanames{zh}->{861322445} = "吉林省通化市";
$areanames{zh}->{861322446} = "吉林省白城市";
$areanames{zh}->{861322447} = "吉林省辽源市";
$areanames{zh}->{861322448} = "吉林省松原市";
$areanames{zh}->{861322449} = "吉林省白山市";
$areanames{zh}->{861322450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861322451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861322452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861322453} = "黑龙江省牡丹江市";
$areanames{zh}->{861322454} = "黑龙江省佳木斯市";
$areanames{zh}->{861322455} = "黑龙江省绥化市";
$areanames{zh}->{861322456} = "黑龙江省黑河市";
$areanames{zh}->{861322457} = "黑龙江省大庆市";
$areanames{zh}->{861322458} = "黑龙江省大庆市";
$areanames{zh}->{861322459} = "黑龙江省大庆市";
$areanames{zh}->{861322460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861322461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861322462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861322463} = "黑龙江省牡丹江市";
$areanames{zh}->{861322464} = "黑龙江省佳木斯市";
$areanames{zh}->{861322465} = "黑龙江省绥化市";
$areanames{zh}->{861322466} = "黑龙江省佳木斯市";
$areanames{zh}->{861322467} = "黑龙江省鸡西市";
$areanames{zh}->{861322468} = "黑龙江省鹤岗市";
$areanames{zh}->{861322469} = "黑龙江省双鸭山市";
$areanames{zh}->{861322470} = "内蒙古包头市";
$areanames{zh}->{861322471} = "内蒙古包头市";
$areanames{zh}->{861322472} = "内蒙古包头市";
$areanames{zh}->{861322473} = "内蒙古乌海市";
$areanames{zh}->{861322474} = "内蒙古兴安盟";
$areanames{zh}->{861322475} = "内蒙古通辽市";
$areanames{zh}->{861322476} = "内蒙古通辽市";
$areanames{zh}->{861322477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861322478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861322479} = "内蒙古兴安盟";
$areanames{zh}->{861322480} = "内蒙古乌海市";
$areanames{zh}->{861322481} = "内蒙古兴安盟";
$areanames{zh}->{861322482} = "内蒙古兴安盟";
$areanames{zh}->{861322483} = "内蒙古兴安盟";
$areanames{zh}->{861322484} = "内蒙古通辽市";
$areanames{zh}->{861322485} = "内蒙古包头市";
$areanames{zh}->{861322486} = "内蒙古包头市";
$areanames{zh}->{861322487} = "内蒙古包头市";
$areanames{zh}->{861322488} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861322489} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86132249} = "重庆市";
$areanames{zh}->{861322500} = "福建省泉州市";
$areanames{zh}->{861322501} = "福建省漳州市";
$areanames{zh}->{861322502} = "福建省三明市";
$areanames{zh}->{861322503} = "福建省厦门市";
$areanames{zh}->{861322504} = "福建省宁德市";
$areanames{zh}->{861322505} = "福建省三明市";
$areanames{zh}->{861322506} = "福建省莆田市";
$areanames{zh}->{861322507} = "福建省厦门市";
$areanames{zh}->{861322508} = "福建省厦门市";
$areanames{zh}->{861322509} = "福建省莆田市";
$areanames{zh}->{861322510} = "江苏省无锡市";
$areanames{zh}->{861322511} = "江苏省镇江市";
$areanames{zh}->{861322512} = "江苏省苏州市";
$areanames{zh}->{861322513} = "江苏省南通市";
$areanames{zh}->{861322514} = "江苏省扬州市";
$areanames{zh}->{861322515} = "江苏省盐城市";
$areanames{zh}->{861322516} = "江苏省徐州市";
$areanames{zh}->{861322517} = "江苏省淮安市";
$areanames{zh}->{861322518} = "江苏省连云港市";
$areanames{zh}->{861322519} = "江苏省常州市";
$areanames{zh}->{86132252} = "江苏省徐州市";
$areanames{zh}->{861322520} = "江苏省连云港市";
$areanames{zh}->{861322521} = "江苏省连云港市";
$areanames{zh}->{861322530} = "山东省菏泽市";
$areanames{zh}->{861322531} = "山东省济南市";
$areanames{zh}->{861322532} = "山东省青岛市";
$areanames{zh}->{861322533} = "山东省淄博市";
$areanames{zh}->{861322534} = "山东省德州市";
$areanames{zh}->{861322535} = "山东省烟台市";
$areanames{zh}->{861322536} = "山东省潍坊市";
$areanames{zh}->{861322537} = "山东省济宁市";
$areanames{zh}->{861322538} = "山东省泰安市";
$areanames{zh}->{861322539} = "山东省临沂市";
$areanames{zh}->{861322540} = "山东省菏泽市";
$areanames{zh}->{861322541} = "山东省济南市";
$areanames{zh}->{861322542} = "山东省青岛市";
$areanames{zh}->{861322543} = "山东省滨州市";
$areanames{zh}->{861322544} = "山东省德州市";
$areanames{zh}->{861322545} = "山东省烟台市";
$areanames{zh}->{861322546} = "山东省东营市";
$areanames{zh}->{861322547} = "山东省济宁市";
$areanames{zh}->{861322548} = "山东省泰安市";
$areanames{zh}->{861322549} = "山东省临沂市";
$areanames{zh}->{861322550} = "安徽省滁州市";
$areanames{zh}->{861322551} = "安徽省合肥市";
$areanames{zh}->{861322552} = "安徽省蚌埠市";
$areanames{zh}->{861322553} = "安徽省芜湖市";
$areanames{zh}->{861322554} = "安徽省淮南市";
$areanames{zh}->{861322555} = "安徽省马鞍山市";
$areanames{zh}->{861322556} = "安徽省安庆市";
$areanames{zh}->{861322557} = "安徽省宿州市";
$areanames{zh}->{861322558} = "安徽省阜阳市";
$areanames{zh}->{861322559} = "安徽省黄山市";
$areanames{zh}->{861322560} = "安徽省合肥市";
$areanames{zh}->{861322561} = "安徽省淮北市";
$areanames{zh}->{861322562} = "安徽省铜陵市";
$areanames{zh}->{861322563} = "安徽省宣城市";
$areanames{zh}->{861322564} = "安徽省六安市";
$areanames{zh}->{861322565} = "安徽省合肥市";
$areanames{zh}->{861322566} = "安徽省池州市";
$areanames{zh}->{861322567} = "安徽省亳州市";
$areanames{zh}->{861322568} = "安徽省阜阳市";
$areanames{zh}->{861322569} = "安徽省合肥市";
$areanames{zh}->{86132257} = "安徽省安庆市";
$areanames{zh}->{861322575} = "安徽省合肥市";
$areanames{zh}->{861322577} = "安徽省宿州市";
$areanames{zh}->{861322579} = "安徽省黄山市";
$areanames{zh}->{86132258} = "安徽省六安市";
$areanames{zh}->{861322585} = "安徽省合肥市";
$areanames{zh}->{861322587} = "安徽省亳州市";
$areanames{zh}->{861322589} = "安徽省合肥市";
$areanames{zh}->{861322590} = "福建省南平市";
$areanames{zh}->{861322591} = "福建省福州市";
$areanames{zh}->{861322592} = "福建省厦门市";
$areanames{zh}->{861322593} = "福建省龙岩市";
$areanames{zh}->{861322594} = "福建省福州市";
$areanames{zh}->{861322595} = "福建省泉州市";
$areanames{zh}->{861322596} = "福建省厦门市";
$areanames{zh}->{861322597} = "福建省南平市";
$areanames{zh}->{861322598} = "福建省泉州市";
$areanames{zh}->{861322599} = "福建省福州市";
$areanames{zh}->{86132260} = "广东省珠海市";
$areanames{zh}->{861322606} = "广东省中山市";
$areanames{zh}->{861322607} = "广东省中山市";
$areanames{zh}->{861322608} = "广东省中山市";
$areanames{zh}->{861322609} = "广东省中山市";
$areanames{zh}->{861322610} = "广东省潮州市";
$areanames{zh}->{861322611} = "广东省潮州市";
$areanames{zh}->{861322612} = "广东省潮州市";
$areanames{zh}->{861322613} = "广东省潮州市";
$areanames{zh}->{861322614} = "广东省潮州市";
$areanames{zh}->{861322615} = "广东省揭阳市";
$areanames{zh}->{861322616} = "广东省揭阳市";
$areanames{zh}->{861322617} = "广东省揭阳市";
$areanames{zh}->{861322618} = "广东省揭阳市";
$areanames{zh}->{861322619} = "广东省揭阳市";
$areanames{zh}->{861322620} = "广东省梅州市";
$areanames{zh}->{861322621} = "广东省梅州市";
$areanames{zh}->{861322622} = "广东省湛江市";
$areanames{zh}->{861322623} = "广东省湛江市";
$areanames{zh}->{861322624} = "广东省湛江市";
$areanames{zh}->{861322625} = "广东省湛江市";
$areanames{zh}->{861322626} = "广东省湛江市";
$areanames{zh}->{861322627} = "广东省茂名市";
$areanames{zh}->{861322628} = "广东省茂名市";
$areanames{zh}->{861322629} = "广东省茂名市";
$areanames{zh}->{861322630} = "广东省惠州市";
$areanames{zh}->{861322631} = "广东省惠州市";
$areanames{zh}->{861322632} = "广东省惠州市";
$areanames{zh}->{861322633} = "广东省惠州市";
$areanames{zh}->{861322634} = "广东省惠州市";
$areanames{zh}->{861322635} = "河北省石家庄市";
$areanames{zh}->{861322636} = "广东省云浮市";
$areanames{zh}->{861322637} = "广东省阳江市";
$areanames{zh}->{861322638} = "广东省阳江市";
$areanames{zh}->{861322639} = "广东省阳江市";
$areanames{zh}->{86132264} = "广东省广州市";
$areanames{zh}->{861322646} = "广东省江门市";
$areanames{zh}->{861322647} = "广东省江门市";
$areanames{zh}->{861322648} = "广东省珠海市";
$areanames{zh}->{861322649} = "广东省珠海市";
$areanames{zh}->{861322650} = "广东省韶关市";
$areanames{zh}->{861322651} = "广东省韶关市";
$areanames{zh}->{861322652} = "广东省韶关市";
$areanames{zh}->{861322653} = "广东省韶关市";
$areanames{zh}->{861322654} = "广东省韶关市";
$areanames{zh}->{861322655} = "广东省清远市";
$areanames{zh}->{861322656} = "广东省清远市";
$areanames{zh}->{861322657} = "广东省清远市";
$areanames{zh}->{861322658} = "广东省清远市";
$areanames{zh}->{861322659} = "广东省清远市";
$areanames{zh}->{86132266} = "广东省广州市";
$areanames{zh}->{861322670} = "广东省佛山市";
$areanames{zh}->{861322671} = "广东省佛山市";
$areanames{zh}->{861322672} = "广东省佛山市";
$areanames{zh}->{861322673} = "广东省佛山市";
$areanames{zh}->{861322674} = "广东省汕尾市";
$areanames{zh}->{861322675} = "广东省汕尾市";
$areanames{zh}->{861322676} = "广东省河源市";
$areanames{zh}->{861322677} = "广东省肇庆市";
$areanames{zh}->{861322678} = "广东省肇庆市";
$areanames{zh}->{861322679} = "广东省肇庆市";
$areanames{zh}->{861322680} = "广东省汕头市";
$areanames{zh}->{861322681} = "广东省汕头市";
$areanames{zh}->{861322682} = "广东省汕头市";
$areanames{zh}->{861322683} = "广东省汕头市";
$areanames{zh}->{861322684} = "广东省汕头市";
$areanames{zh}->{861322685} = "广东省深圳市";
$areanames{zh}->{861322686} = "广东省深圳市";
$areanames{zh}->{861322687} = "广东省深圳市";
$areanames{zh}->{861322688} = "广东省汕尾市";
$areanames{zh}->{861322689} = "广东省河源市";
$areanames{zh}->{86132269} = "广东省江门市";
$areanames{zh}->{861322696} = "广东省佛山市";
$areanames{zh}->{861322697} = "广东省佛山市";
$areanames{zh}->{861322698} = "广东省佛山市";
$areanames{zh}->{861322699} = "广东省佛山市";
$areanames{zh}->{86132270} = "陕西省西安市";
$areanames{zh}->{86132271} = "湖北省孝感市";
$areanames{zh}->{861322710} = "湖北省鄂州市";
$areanames{zh}->{861322711} = "湖北省鄂州市";
$areanames{zh}->{861322720} = "湖北省咸宁市";
$areanames{zh}->{861322721} = "湖北省咸宁市";
$areanames{zh}->{861322722} = "湖北省随州市";
$areanames{zh}->{861322723} = "湖北省咸宁市";
$areanames{zh}->{861322724} = "湖北省十堰市";
$areanames{zh}->{861322725} = "湖北省宜昌市";
$areanames{zh}->{861322726} = "湖北省宜昌市";
$areanames{zh}->{861322727} = "湖北省宜昌市";
$areanames{zh}->{861322728} = "湖北省宜昌市";
$areanames{zh}->{861322729} = "湖北省宜昌市";
$areanames{zh}->{86132273} = "湖北省黄冈市";
$areanames{zh}->{861322730} = "湖北省孝感市";
$areanames{zh}->{86132274} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{86132275} = "湖北省襄樊市";
$areanames{zh}->{86132276} = "湖北省荆州市";
$areanames{zh}->{861322760} = "湖北省十堰市";
$areanames{zh}->{861322761} = "湖北省十堰市";
$areanames{zh}->{86132277} = "陕西省西安市";
$areanames{zh}->{86132278} = "陕西省西安市";
$areanames{zh}->{861322790} = "陕西省咸阳市";
$areanames{zh}->{861322791} = "陕西省延安市";
$areanames{zh}->{861322792} = "陕西省榆林市";
$areanames{zh}->{861322793} = "陕西省渭南市";
$areanames{zh}->{861322794} = "陕西省咸阳市";
$areanames{zh}->{861322795} = "陕西省咸阳市";
$areanames{zh}->{861322796} = "陕西省延安市";
$areanames{zh}->{861322797} = "陕西省宝鸡市";
$areanames{zh}->{861322798} = "陕西省延安市";
$areanames{zh}->{861322799} = "陕西省榆林市";
$areanames{zh}->{86132280} = "陕西省西安市";
$areanames{zh}->{86132281} = "四川省成都市";
$areanames{zh}->{861322820} = "四川省成都市";
$areanames{zh}->{861322821} = "四川省成都市";
$areanames{zh}->{861322822} = "四川省成都市";
$areanames{zh}->{861322823} = "四川省绵阳市";
$areanames{zh}->{861322824} = "四川省绵阳市";
$areanames{zh}->{861322825} = "四川省南充市";
$areanames{zh}->{861322826} = "四川省南充市";
$areanames{zh}->{861322827} = "四川省达州市";
$areanames{zh}->{861322828} = "四川省达州市";
$areanames{zh}->{861322829} = "陕西省渭南市";
$areanames{zh}->{861322830} = "四川省广安市";
$areanames{zh}->{861322831} = "四川省宜宾市";
$areanames{zh}->{861322832} = "四川省宜宾市";
$areanames{zh}->{861322833} = "四川省德阳市";
$areanames{zh}->{861322834} = "四川省巴中市";
$areanames{zh}->{861322835} = "四川省内江市";
$areanames{zh}->{861322836} = "陕西省榆林市";
$areanames{zh}->{861322837} = "四川省泸州市";
$areanames{zh}->{861322838} = "四川省乐山市";
$areanames{zh}->{861322839} = "四川省绵阳市";
$areanames{zh}->{861322840} = "四川省眉山市";
$areanames{zh}->{861322841} = "四川省德阳市";
$areanames{zh}->{861322842} = "陕西省铜川市";
$areanames{zh}->{861322843} = "陕西省宝鸡市";
$areanames{zh}->{861322844} = "陕西省榆林市";
$areanames{zh}->{861322845} = "四川省南充市";
$areanames{zh}->{861322846} = "四川省达州市";
$areanames{zh}->{861322847} = "陕西省宝鸡市";
$areanames{zh}->{861322848} = "四川省乐山市";
$areanames{zh}->{861322849} = "四川省遂宁市";
$areanames{zh}->{86132285} = "重庆市";
$areanames{zh}->{86132286} = "重庆市";
$areanames{zh}->{86132287} = "江苏省泰州市";
$areanames{zh}->{861322870} = "江苏省宿迁市";
$areanames{zh}->{861322871} = "江苏省宿迁市";
$areanames{zh}->{861322872} = "江苏省宿迁市";
$areanames{zh}->{86132288} = "江苏省南通市";
$areanames{zh}->{861322890} = "西藏拉萨市";
$areanames{zh}->{861322891} = "西藏拉萨市";
$areanames{zh}->{861322892} = "西藏日喀则地区";
$areanames{zh}->{861322893} = "西藏山南地区";
$areanames{zh}->{861322894} = "西藏林芝地区";
$areanames{zh}->{861322895} = "西藏昌都地区";
$areanames{zh}->{861322896} = "西藏那曲地区";
$areanames{zh}->{861322897} = "西藏阿里地区";
$areanames{zh}->{861322898} = "西藏拉萨市";
$areanames{zh}->{861322899} = "西藏拉萨市";
$areanames{zh}->{86132290} = "广东省肇庆市";
$areanames{zh}->{861322906} = "河北省邢台市";
$areanames{zh}->{861322907} = "河北省邢台市";
$areanames{zh}->{861322908} = "广东省江门市";
$areanames{zh}->{861322909} = "广东省江门市";
$areanames{zh}->{861322910} = "广东省中山市";
$areanames{zh}->{861322911} = "河北省石家庄市";
$areanames{zh}->{861322912} = "广东省中山市";
$areanames{zh}->{861322913} = "广东省江门市";
$areanames{zh}->{861322914} = "广东省江门市";
$areanames{zh}->{861322915} = "广东省惠州市";
$areanames{zh}->{861322916} = "广东省惠州市";
$areanames{zh}->{861322917} = "广东省揭阳市";
$areanames{zh}->{861322918} = "广东省揭阳市";
$areanames{zh}->{861322919} = "广东省揭阳市";
$areanames{zh}->{86132292} = "广东省佛山市";
$areanames{zh}->{861322930} = "广东省广州市";
$areanames{zh}->{861322931} = "广东省广州市";
$areanames{zh}->{861322932} = "河北省唐山市";
$areanames{zh}->{861322933} = "广东省广州市";
$areanames{zh}->{861322934} = "广东省广州市";
$areanames{zh}->{861322935} = "河北省唐山市";
$areanames{zh}->{861322936} = "广东省韶关市";
$areanames{zh}->{861322937} = "广东省韶关市";
$areanames{zh}->{861322938} = "广东省韶关市";
$areanames{zh}->{861322939} = "广东省韶关市";
$areanames{zh}->{86132294} = "广东省广州市";
$areanames{zh}->{86132295} = "广东省湛江市";
$areanames{zh}->{861322958} = "广东省惠州市";
$areanames{zh}->{861322959} = "广东省惠州市";
$areanames{zh}->{86132296} = "广东省汕头市";
$areanames{zh}->{861322960} = "广东省梅州市";
$areanames{zh}->{861322969} = "广东省汕尾市";
$areanames{zh}->{861322970} = "广东省梅州市";
$areanames{zh}->{861322971} = "广东省云浮市";
$areanames{zh}->{861322972} = "广东省云浮市";
$areanames{zh}->{861322973} = "广东省汕尾市";
$areanames{zh}->{861322974} = "广东省汕尾市";
$areanames{zh}->{861322975} = "广东省珠海市";
$areanames{zh}->{861322976} = "广东省珠海市";
$areanames{zh}->{861322977} = "广东省珠海市";
$areanames{zh}->{861322978} = "广东省肇庆市";
$areanames{zh}->{861322979} = "广东省肇庆市";
$areanames{zh}->{861322980} = "广东省清远市";
$areanames{zh}->{861322981} = "广东省清远市";
$areanames{zh}->{861322982} = "广东省清远市";
$areanames{zh}->{861322983} = "广东省清远市";
$areanames{zh}->{861322984} = "广东省清远市";
$areanames{zh}->{861322985} = "广东省珠海市";
$areanames{zh}->{861322986} = "河北省邢台市";
$areanames{zh}->{861322987} = "广东省珠海市";
$areanames{zh}->{861322988} = "广东省珠海市";
$areanames{zh}->{861322989} = "河北省邢台市";
$areanames{zh}->{86132299} = "广东省广州市";
$areanames{zh}->{861322990} = "河北省唐山市";
$areanames{zh}->{86132300} = "河北省邯郸市";
$areanames{zh}->{86132301} = "河北省石家庄市";
$areanames{zh}->{86132302} = "河北省保定市";
$areanames{zh}->{86132303} = "河北省秦皇岛市";
$areanames{zh}->{86132304} = "河北省石家庄市";
$areanames{zh}->{86132305} = "河北省唐山市";
$areanames{zh}->{861323060} = "河北省保定市";
$areanames{zh}->{861323061} = "河北省保定市";
$areanames{zh}->{861323062} = "河北省保定市";
$areanames{zh}->{861323063} = "河北省保定市";
$areanames{zh}->{861323064} = "河北省保定市";
$areanames{zh}->{861323065} = "河北省廊坊市";
$areanames{zh}->{861323066} = "河北省廊坊市";
$areanames{zh}->{861323067} = "河北省廊坊市";
$areanames{zh}->{861323068} = "河北省廊坊市";
$areanames{zh}->{861323069} = "河北省廊坊市";
$areanames{zh}->{86132307} = "河北省沧州市";
$areanames{zh}->{86132308} = "河北省唐山市";
$areanames{zh}->{861323090} = "河北省秦皇岛市";
$areanames{zh}->{861323091} = "河北省秦皇岛市";
$areanames{zh}->{861323092} = "河北省秦皇岛市";
$areanames{zh}->{861323093} = "河北省秦皇岛市";
$areanames{zh}->{861323094} = "河北省秦皇岛市";
$areanames{zh}->{861323095} = "河北省邢台市";
$areanames{zh}->{861323096} = "河北省邢台市";
$areanames{zh}->{861323097} = "河北省邢台市";
$areanames{zh}->{861323098} = "河北省邢台市";
$areanames{zh}->{861323099} = "河北省邢台市";
$areanames{zh}->{86132310} = "河北省邯郸市";
$areanames{zh}->{86132311} = "河北省石家庄市";
$areanames{zh}->{86132312} = "河北省保定市";
$areanames{zh}->{86132313} = "河北省张家口市";
$areanames{zh}->{861323137} = "河北省秦皇岛市";
$areanames{zh}->{861323138} = "河北省秦皇岛市";
$areanames{zh}->{861323139} = "河北省秦皇岛市";
$areanames{zh}->{86132314} = "河北省承德市";
$areanames{zh}->{86132315} = "河北省唐山市";
$areanames{zh}->{86132316} = "河北省廊坊市";
$areanames{zh}->{86132317} = "河北省沧州市";
$areanames{zh}->{86132318} = "河北省衡水市";
$areanames{zh}->{86132319} = "河北省邢台市";
$areanames{zh}->{861323200} = "广东省阳江市";
$areanames{zh}->{861323201} = "广东省阳江市";
$areanames{zh}->{861323202} = "广东省阳江市";
$areanames{zh}->{861323203} = "广东省阳江市";
$areanames{zh}->{861323204} = "广东省阳江市";
$areanames{zh}->{861323205} = "广东省韶关市";
$areanames{zh}->{861323206} = "广东省韶关市";
$areanames{zh}->{861323207} = "广东省韶关市";
$areanames{zh}->{861323208} = "广东省韶关市";
$areanames{zh}->{861323209} = "广东省韶关市";
$areanames{zh}->{861323210} = "广东省云浮市";
$areanames{zh}->{861323211} = "广东省云浮市";
$areanames{zh}->{861323212} = "广东省云浮市";
$areanames{zh}->{861323213} = "广东省云浮市";
$areanames{zh}->{861323214} = "广东省云浮市";
$areanames{zh}->{861323215} = "广东省茂名市";
$areanames{zh}->{861323216} = "广东省茂名市";
$areanames{zh}->{861323217} = "广东省茂名市";
$areanames{zh}->{861323218} = "广东省茂名市";
$areanames{zh}->{861323219} = "广东省茂名市";
$areanames{zh}->{86132322} = "广东省珠海市";
$areanames{zh}->{86132323} = "广东省中山市";
$areanames{zh}->{861323230} = "广东省梅州市";
$areanames{zh}->{861323231} = "广东省梅州市";
$areanames{zh}->{861323232} = "广东省梅州市";
$areanames{zh}->{861323233} = "广东省梅州市";
$areanames{zh}->{861323240} = "广东省江门市";
$areanames{zh}->{861323241} = "广东省江门市";
$areanames{zh}->{861323242} = "广东省江门市";
$areanames{zh}->{861323243} = "广东省江门市";
$areanames{zh}->{861323244} = "广东省江门市";
$areanames{zh}->{861323245} = "广东省清远市";
$areanames{zh}->{861323246} = "广东省清远市";
$areanames{zh}->{861323247} = "广东省清远市";
$areanames{zh}->{861323248} = "广东省清远市";
$areanames{zh}->{861323249} = "广东省清远市";
$areanames{zh}->{86132325} = "广东省中山市";
$areanames{zh}->{861323250} = "广东省珠海市";
$areanames{zh}->{861323251} = "广东省珠海市";
$areanames{zh}->{861323252} = "广东省珠海市";
$areanames{zh}->{861323260} = "广东省河源市";
$areanames{zh}->{861323261} = "广东省河源市";
$areanames{zh}->{861323262} = "广东省河源市";
$areanames{zh}->{861323263} = "广东省河源市";
$areanames{zh}->{861323264} = "广东省河源市";
$areanames{zh}->{861323265} = "广东省湛江市";
$areanames{zh}->{861323266} = "广东省湛江市";
$areanames{zh}->{861323267} = "广东省湛江市";
$areanames{zh}->{861323268} = "广东省湛江市";
$areanames{zh}->{861323269} = "广东省湛江市";
$areanames{zh}->{861323270} = "广东省湛江市";
$areanames{zh}->{861323271} = "广东省湛江市";
$areanames{zh}->{861323272} = "广东省湛江市";
$areanames{zh}->{861323273} = "广东省湛江市";
$areanames{zh}->{861323274} = "广东省湛江市";
$areanames{zh}->{861323275} = "广东省河源市";
$areanames{zh}->{861323276} = "广东省河源市";
$areanames{zh}->{861323277} = "广东省河源市";
$areanames{zh}->{861323278} = "广东省河源市";
$areanames{zh}->{861323279} = "广东省河源市";
$areanames{zh}->{861323280} = "广东省清远市";
$areanames{zh}->{861323281} = "广东省清远市";
$areanames{zh}->{861323282} = "广东省清远市";
$areanames{zh}->{861323283} = "广东省清远市";
$areanames{zh}->{861323284} = "广东省清远市";
$areanames{zh}->{861323285} = "广东省江门市";
$areanames{zh}->{861323286} = "广东省江门市";
$areanames{zh}->{861323287} = "广东省江门市";
$areanames{zh}->{861323288} = "广东省江门市";
$areanames{zh}->{861323289} = "广东省江门市";
$areanames{zh}->{861323290} = "广东省江门市";
$areanames{zh}->{861323291} = "广东省江门市";
$areanames{zh}->{861323292} = "广东省江门市";
$areanames{zh}->{861323293} = "广东省江门市";
$areanames{zh}->{861323294} = "广东省江门市";
$areanames{zh}->{861323295} = "广东省清远市";
$areanames{zh}->{861323296} = "广东省清远市";
$areanames{zh}->{861323297} = "广东省清远市";
$areanames{zh}->{861323298} = "广东省清远市";
$areanames{zh}->{861323299} = "广东省清远市";
$areanames{zh}->{86132330} = "山西省晋中市";
$areanames{zh}->{861323306} = "山西省临汾市";
$areanames{zh}->{861323307} = "山西省临汾市";
$areanames{zh}->{861323308} = "山西省临汾市";
$areanames{zh}->{861323309} = "山西省临汾市";
$areanames{zh}->{86132331} = "山西省大同市";
$areanames{zh}->{861323310} = "山西省临汾市";
$areanames{zh}->{861323311} = "山西省临汾市";
$areanames{zh}->{861323312} = "山西省临汾市";
$areanames{zh}->{86132332} = "山西省运城市";
$areanames{zh}->{861323327} = "山西省晋城市";
$areanames{zh}->{861323328} = "山西省晋城市";
$areanames{zh}->{861323329} = "山西省晋城市";
$areanames{zh}->{86132333} = "山西省长治市";
$areanames{zh}->{861323330} = "山西省晋城市";
$areanames{zh}->{861323331} = "山西省晋城市";
$areanames{zh}->{861323332} = "山西省晋城市";
$areanames{zh}->{861323333} = "山西省晋城市";
$areanames{zh}->{861323340} = "山西省忻州市";
$areanames{zh}->{861323341} = "山西省太原市";
$areanames{zh}->{861323342} = "山西省大同市";
$areanames{zh}->{861323343} = "山西省阳泉市";
$areanames{zh}->{861323344} = "山西省晋中市";
$areanames{zh}->{861323345} = "山西省长治市";
$areanames{zh}->{861323346} = "山西省晋城市";
$areanames{zh}->{861323347} = "山西省临汾市";
$areanames{zh}->{861323348} = "山西省运城市";
$areanames{zh}->{861323349} = "山西省朔州市";
$areanames{zh}->{861323350} = "山西省忻州市";
$areanames{zh}->{861323351} = "山西省太原市";
$areanames{zh}->{861323352} = "山西省大同市";
$areanames{zh}->{861323353} = "山西省阳泉市";
$areanames{zh}->{861323354} = "山西省晋中市";
$areanames{zh}->{861323355} = "山西省长治市";
$areanames{zh}->{861323356} = "山西省晋城市";
$areanames{zh}->{861323357} = "山西省临汾市";
$areanames{zh}->{861323358} = "山西省吕梁市";
$areanames{zh}->{861323359} = "山西省运城市";
$areanames{zh}->{86132336} = "山西省太原市";
$areanames{zh}->{86132337} = "河南省平顶山市";
$areanames{zh}->{861323376} = "河南省信阳市";
$areanames{zh}->{861323377} = "河南省信阳市";
$areanames{zh}->{861323378} = "河南省信阳市";
$areanames{zh}->{861323379} = "河南省洛阳市";
$areanames{zh}->{861323380} = "河南省新乡市";
$areanames{zh}->{861323381} = "河南省新乡市";
$areanames{zh}->{861323382} = "河南省新乡市";
$areanames{zh}->{861323383} = "河南省新乡市";
$areanames{zh}->{861323384} = "河南省新乡市";
$areanames{zh}->{861323385} = "河南省商丘市";
$areanames{zh}->{861323386} = "河南省商丘市";
$areanames{zh}->{861323387} = "河南省商丘市";
$areanames{zh}->{861323388} = "河南省商丘市";
$areanames{zh}->{861323389} = "河南省商丘市";
$areanames{zh}->{86132339} = "河南省洛阳市";
$areanames{zh}->{861323397} = "河南省信阳市";
$areanames{zh}->{861323400} = "辽宁省沈阳市";
$areanames{zh}->{861323401} = "辽宁省沈阳市";
$areanames{zh}->{861323402} = "辽宁省沈阳市";
$areanames{zh}->{861323403} = "辽宁省沈阳市";
$areanames{zh}->{861323404} = "辽宁省沈阳市";
$areanames{zh}->{861323405} = "辽宁省大连市";
$areanames{zh}->{861323406} = "辽宁省大连市";
$areanames{zh}->{861323407} = "辽宁省大连市";
$areanames{zh}->{861323408} = "辽宁省大连市";
$areanames{zh}->{861323409} = "辽宁省大连市";
$areanames{zh}->{861323410} = "辽宁省铁岭市";
$areanames{zh}->{861323411} = "辽宁省大连市";
$areanames{zh}->{861323412} = "辽宁省鞍山市";
$areanames{zh}->{861323413} = "辽宁省抚顺市";
$areanames{zh}->{861323414} = "辽宁省本溪市";
$areanames{zh}->{861323415} = "辽宁省丹东市";
$areanames{zh}->{861323416} = "辽宁省锦州市";
$areanames{zh}->{861323417} = "辽宁省营口市";
$areanames{zh}->{861323418} = "辽宁省阜新市";
$areanames{zh}->{861323419} = "辽宁省辽阳市";
$areanames{zh}->{861323420} = "辽宁省铁岭市";
$areanames{zh}->{861323421} = "辽宁省朝阳市";
$areanames{zh}->{861323422} = "辽宁省朝阳市";
$areanames{zh}->{861323423} = "辽宁省葫芦岛市";
$areanames{zh}->{861323424} = "辽宁省辽阳市";
$areanames{zh}->{861323425} = "辽宁省丹东市";
$areanames{zh}->{861323426} = "辽宁省丹东市";
$areanames{zh}->{861323427} = "辽宁省盘锦市";
$areanames{zh}->{861323428} = "辽宁省盘锦市";
$areanames{zh}->{861323429} = "辽宁省葫芦岛市";
$areanames{zh}->{861323430} = "吉林省长春市";
$areanames{zh}->{861323431} = "吉林省长春市";
$areanames{zh}->{861323432} = "吉林省吉林市";
$areanames{zh}->{861323433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861323434} = "吉林省四平市";
$areanames{zh}->{861323435} = "吉林省通化市";
$areanames{zh}->{861323436} = "吉林省白城市";
$areanames{zh}->{861323437} = "吉林省辽源市";
$areanames{zh}->{861323438} = "吉林省松原市";
$areanames{zh}->{861323439} = "吉林省白山市";
$areanames{zh}->{86132344} = "吉林省长春市";
$areanames{zh}->{861323450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323453} = "黑龙江省牡丹江市";
$areanames{zh}->{861323454} = "黑龙江省佳木斯市";
$areanames{zh}->{861323455} = "黑龙江省绥化市";
$areanames{zh}->{861323456} = "黑龙江省黑河市";
$areanames{zh}->{861323457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861323458} = "黑龙江省伊春市";
$areanames{zh}->{861323459} = "黑龙江省大庆市";
$areanames{zh}->{861323460} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323461} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323463} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323464} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323465} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323466} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323467} = "黑龙江省鸡西市";
$areanames{zh}->{861323468} = "黑龙江省鹤岗市";
$areanames{zh}->{861323469} = "黑龙江省双鸭山市";
$areanames{zh}->{861323470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861323471} = "内蒙古呼和浩特市";
$areanames{zh}->{861323472} = "内蒙古包头市";
$areanames{zh}->{861323473} = "内蒙古乌海市";
$areanames{zh}->{861323474} = "内蒙古兴安盟";
$areanames{zh}->{861323475} = "内蒙古通辽市";
$areanames{zh}->{861323476} = "内蒙古赤峰市";
$areanames{zh}->{861323477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861323478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861323479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861323480} = "内蒙古包头市";
$areanames{zh}->{861323481} = "内蒙古包头市";
$areanames{zh}->{861323482} = "内蒙古兴安盟";
$areanames{zh}->{861323483} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861323484} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861323485} = "内蒙古通辽市";
$areanames{zh}->{861323486} = "内蒙古通辽市";
$areanames{zh}->{861323487} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861323488} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861323489} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861323490} = "黑龙江省大庆市";
$areanames{zh}->{861323491} = "黑龙江省大庆市";
$areanames{zh}->{861323492} = "黑龙江省大庆市";
$areanames{zh}->{861323493} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323494} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861323495} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323496} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323497} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323498} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323499} = "黑龙江省哈尔滨市";
$areanames{zh}->{861323500} = "福建省厦门市";
$areanames{zh}->{861323501} = "福建省漳州市";
$areanames{zh}->{861323502} = "福建省漳州市";
$areanames{zh}->{861323503} = "福建省漳州市";
$areanames{zh}->{861323504} = "福建省漳州市";
$areanames{zh}->{861323505} = "福建省漳州市";
$areanames{zh}->{861323506} = "福建省宁德市";
$areanames{zh}->{861323507} = "福建省莆田市";
$areanames{zh}->{861323508} = "福建省莆田市";
$areanames{zh}->{861323509} = "福建省龙岩市";
$areanames{zh}->{86132351} = "江苏省宿迁市";
$areanames{zh}->{861323516} = "江苏省常州市";
$areanames{zh}->{861323517} = "江苏省常州市";
$areanames{zh}->{861323518} = "江苏省常州市";
$areanames{zh}->{861323519} = "江苏省常州市";
$areanames{zh}->{86132352} = "江苏省扬州市";
$areanames{zh}->{861323520} = "江苏省南通市";
$areanames{zh}->{861323521} = "江苏省南通市";
$areanames{zh}->{861323522} = "江苏省南通市";
$areanames{zh}->{861323530} = "山东省菏泽市";
$areanames{zh}->{861323531} = "山东省济南市";
$areanames{zh}->{861323532} = "山东省青岛市";
$areanames{zh}->{861323533} = "山东省淄博市";
$areanames{zh}->{861323534} = "山东省德州市";
$areanames{zh}->{861323535} = "山东省烟台市";
$areanames{zh}->{861323536} = "山东省潍坊市";
$areanames{zh}->{861323537} = "山东省济宁市";
$areanames{zh}->{861323538} = "山东省泰安市";
$areanames{zh}->{861323539} = "山东省临沂市";
$areanames{zh}->{861323540} = "湖北省鄂州市";
$areanames{zh}->{861323541} = "湖北省黄冈市";
$areanames{zh}->{861323542} = "湖北省黄冈市";
$areanames{zh}->{861323543} = "湖北省黄冈市";
$areanames{zh}->{861323544} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861323545} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861323546} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861323547} = "湖北省孝感市";
$areanames{zh}->{861323548} = "湖北省孝感市";
$areanames{zh}->{861323549} = "湖北省孝感市";
$areanames{zh}->{861323550} = "湖北省随州市";
$areanames{zh}->{861323551} = "湖北省随州市";
$areanames{zh}->{861323552} = "湖北省武汉市";
$areanames{zh}->{861323553} = "湖北省武汉市";
$areanames{zh}->{861323554} = "湖北省武汉市";
$areanames{zh}->{861323555} = "湖北省武汉市";
$areanames{zh}->{861323556} = "湖北省咸宁市";
$areanames{zh}->{861323557} = "湖北省咸宁市";
$areanames{zh}->{861323558} = "湖北省咸宁市";
$areanames{zh}->{861323559} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861323560} = "湖北省荆州市";
$areanames{zh}->{861323561} = "湖北省荆州市";
$areanames{zh}->{861323562} = "湖北省宜昌市";
$areanames{zh}->{861323563} = "湖北省宜昌市";
$areanames{zh}->{861323564} = "湖北省荆门市";
$areanames{zh}->{861323565} = "湖北省十堰市";
$areanames{zh}->{861323566} = "湖北省十堰市";
$areanames{zh}->{861323567} = "湖北省十堰市";
$areanames{zh}->{861323568} = "湖北省襄樊市";
$areanames{zh}->{861323569} = "湖北省襄樊市";
$areanames{zh}->{861323570} = "浙江省衢州市";
$areanames{zh}->{861323571} = "浙江省杭州市";
$areanames{zh}->{861323572} = "浙江省湖州市";
$areanames{zh}->{861323573} = "浙江省嘉兴市";
$areanames{zh}->{861323574} = "浙江省宁波市";
$areanames{zh}->{861323575} = "浙江省绍兴市";
$areanames{zh}->{861323576} = "浙江省台州市";
$areanames{zh}->{861323577} = "浙江省温州市";
$areanames{zh}->{861323578} = "浙江省丽水市";
$areanames{zh}->{861323579} = "浙江省金华市";
$areanames{zh}->{861323580} = "浙江省舟山市";
$areanames{zh}->{861323581} = "浙江省杭州市";
$areanames{zh}->{861323582} = "浙江省湖州市";
$areanames{zh}->{861323583} = "浙江省嘉兴市";
$areanames{zh}->{861323584} = "浙江省宁波市";
$areanames{zh}->{861323585} = "浙江省绍兴市";
$areanames{zh}->{861323586} = "浙江省台州市";
$areanames{zh}->{861323587} = "浙江省温州市";
$areanames{zh}->{861323588} = "浙江省丽水市";
$areanames{zh}->{861323589} = "浙江省金华市";
$areanames{zh}->{861323590} = "福建省福州市";
$areanames{zh}->{861323591} = "福建省福州市";
$areanames{zh}->{861323592} = "福建省厦门市";
$areanames{zh}->{861323593} = "福建省宁德市";
$areanames{zh}->{861323594} = "福建省莆田市";
$areanames{zh}->{861323595} = "福建省泉州市";
$areanames{zh}->{861323596} = "福建省漳州市";
$areanames{zh}->{861323597} = "福建省龙岩市";
$areanames{zh}->{861323598} = "福建省三明市";
$areanames{zh}->{861323599} = "福建省南平市";
$areanames{zh}->{86132360} = "江苏省徐州市";
$areanames{zh}->{861323607} = "江苏省南通市";
$areanames{zh}->{861323608} = "江苏省南通市";
$areanames{zh}->{861323609} = "江苏省南通市";
$areanames{zh}->{86132361} = "江苏省泰州市";
$areanames{zh}->{861323610} = "江苏省盐城市";
$areanames{zh}->{861323611} = "江苏省盐城市";
$areanames{zh}->{861323612} = "江苏省盐城市";
$areanames{zh}->{861323613} = "江苏省盐城市";
$areanames{zh}->{86132362} = "江苏省淮安市";
$areanames{zh}->{861323627} = "江苏省盐城市";
$areanames{zh}->{861323628} = "江苏省盐城市";
$areanames{zh}->{861323629} = "江苏省盐城市";
$areanames{zh}->{861323630} = "江苏省连云港市";
$areanames{zh}->{861323631} = "江苏省连云港市";
$areanames{zh}->{861323632} = "江苏省连云港市";
$areanames{zh}->{861323633} = "江苏省连云港市";
$areanames{zh}->{861323634} = "江苏省连云港市";
$areanames{zh}->{861323635} = "江苏省镇江市";
$areanames{zh}->{861323636} = "江苏省镇江市";
$areanames{zh}->{861323637} = "江苏省镇江市";
$areanames{zh}->{861323638} = "江苏省镇江市";
$areanames{zh}->{861323639} = "江苏省镇江市";
$areanames{zh}->{861323640} = "江苏省南京市";
$areanames{zh}->{861323641} = "江苏省南京市";
$areanames{zh}->{861323642} = "江苏省徐州市";
$areanames{zh}->{861323643} = "江苏省无锡市";
$areanames{zh}->{861323644} = "江苏省扬州市";
$areanames{zh}->{861323645} = "江苏省盐城市";
$areanames{zh}->{861323646} = "江苏省淮安市";
$areanames{zh}->{861323647} = "江苏省镇江市";
$areanames{zh}->{861323648} = "江苏省南通市";
$areanames{zh}->{861323649} = "江苏省苏州市";
$areanames{zh}->{86132365} = "江苏省南京市";
$areanames{zh}->{86132366} = "辽宁省沈阳市";
$areanames{zh}->{861323668} = "辽宁省本溪市";
$areanames{zh}->{861323669} = "辽宁省本溪市";
$areanames{zh}->{861323670} = "辽宁省阜新市";
$areanames{zh}->{861323671} = "辽宁省阜新市";
$areanames{zh}->{861323672} = "辽宁省营口市";
$areanames{zh}->{861323673} = "辽宁省营口市";
$areanames{zh}->{861323674} = "辽宁省铁岭市";
$areanames{zh}->{861323675} = "辽宁省铁岭市";
$areanames{zh}->{861323676} = "辽宁省朝阳市";
$areanames{zh}->{861323677} = "辽宁省盘锦市";
$areanames{zh}->{861323678} = "辽宁省盘锦市";
$areanames{zh}->{861323679} = "辽宁省葫芦岛市";
$areanames{zh}->{861323680} = "辽宁省鞍山市";
$areanames{zh}->{861323681} = "辽宁省鞍山市";
$areanames{zh}->{861323682} = "辽宁省鞍山市";
$areanames{zh}->{861323683} = "辽宁省鞍山市";
$areanames{zh}->{861323684} = "辽宁省鞍山市";
$areanames{zh}->{861323685} = "辽宁省锦州市";
$areanames{zh}->{861323686} = "辽宁省锦州市";
$areanames{zh}->{861323687} = "辽宁省锦州市";
$areanames{zh}->{861323688} = "辽宁省锦州市";
$areanames{zh}->{861323689} = "辽宁省锦州市";
$areanames{zh}->{861323690} = "辽宁省大连市";
$areanames{zh}->{861323691} = "辽宁省大连市";
$areanames{zh}->{861323692} = "辽宁省大连市";
$areanames{zh}->{861323693} = "辽宁省大连市";
$areanames{zh}->{861323694} = "辽宁省大连市";
$areanames{zh}->{861323695} = "辽宁省抚顺市";
$areanames{zh}->{861323696} = "辽宁省辽阳市";
$areanames{zh}->{861323697} = "辽宁省丹东市";
$areanames{zh}->{861323698} = "辽宁省丹东市";
$areanames{zh}->{861323699} = "辽宁省营口市";
$areanames{zh}->{861323700} = "江西省南昌市";
$areanames{zh}->{861323701} = "江西省鹰潭市";
$areanames{zh}->{861323702} = "江西省九江市";
$areanames{zh}->{861323703} = "江西省上饶市";
$areanames{zh}->{861323704} = "江西省南昌市";
$areanames{zh}->{861323705} = "江西省宜春市";
$areanames{zh}->{861323706} = "江西省吉安市";
$areanames{zh}->{861323707} = "江西省赣州市";
$areanames{zh}->{861323708} = "江西省南昌市";
$areanames{zh}->{861323709} = "江西省宜春市";
$areanames{zh}->{86132371} = "湖北省武汉市";
$areanames{zh}->{861323720} = "湖北省黄冈市";
$areanames{zh}->{861323721} = "湖北省黄冈市";
$areanames{zh}->{861323722} = "湖北省黄冈市";
$areanames{zh}->{861323723} = "湖北省黄石市";
$areanames{zh}->{861323724} = "湖北省黄石市";
$areanames{zh}->{861323725} = "湖北省黄石市";
$areanames{zh}->{861323726} = "湖北省随州市";
$areanames{zh}->{861323727} = "湖北省荆门市";
$areanames{zh}->{861323728} = "湖北省荆门市";
$areanames{zh}->{861323729} = "湖北省荆门市";
$areanames{zh}->{861323730} = "湖南省岳阳市";
$areanames{zh}->{861323731} = "湖南省长沙市";
$areanames{zh}->{861323732} = "湖南省湘潭市";
$areanames{zh}->{861323733} = "湖南省株洲市";
$areanames{zh}->{861323734} = "湖南省衡阳市";
$areanames{zh}->{861323735} = "湖南省郴州市";
$areanames{zh}->{861323736} = "湖南省常德市";
$areanames{zh}->{861323737} = "湖南省益阳市";
$areanames{zh}->{861323738} = "湖南省娄底市";
$areanames{zh}->{861323739} = "湖南省邵阳市";
$areanames{zh}->{861323740} = "湖南省岳阳市";
$areanames{zh}->{861323741} = "湖南省长沙市";
$areanames{zh}->{861323742} = "湖南省长沙市";
$areanames{zh}->{861323743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861323744} = "湖南省张家界市";
$areanames{zh}->{861323745} = "湖南省怀化市";
$areanames{zh}->{861323746} = "湖南省永州市";
$areanames{zh}->{861323747} = "湖南省长沙市";
$areanames{zh}->{861323748} = "湖南省长沙市";
$areanames{zh}->{861323749} = "湖南省长沙市";
$areanames{zh}->{861323750} = "江西省抚州市";
$areanames{zh}->{861323751} = "江西省南昌市";
$areanames{zh}->{861323752} = "江西省南昌市";
$areanames{zh}->{861323753} = "江西省上饶市";
$areanames{zh}->{861323754} = "江西省新余市";
$areanames{zh}->{861323755} = "江西省新余市";
$areanames{zh}->{861323756} = "江西省新余市";
$areanames{zh}->{861323757} = "江西省新余市";
$areanames{zh}->{861323758} = "江西省景德镇市";
$areanames{zh}->{861323759} = "江西省萍乡市";
$areanames{zh}->{861323760} = "江西省景德镇市";
$areanames{zh}->{861323761} = "江西省九江市";
$areanames{zh}->{861323762} = "江西省九江市";
$areanames{zh}->{861323763} = "江西省上饶市";
$areanames{zh}->{861323764} = "江西省南昌市";
$areanames{zh}->{861323765} = "江西省宜春市";
$areanames{zh}->{861323766} = "江西省赣州市";
$areanames{zh}->{861323767} = "江西省赣州市";
$areanames{zh}->{861323768} = "江西省赣州市";
$areanames{zh}->{861323769} = "江西省赣州市";
$areanames{zh}->{861323770} = "广西南宁市";
$areanames{zh}->{861323771} = "广西南宁市";
$areanames{zh}->{861323772} = "广西柳州市";
$areanames{zh}->{861323773} = "广西桂林市";
$areanames{zh}->{861323774} = "广西贺州市";
$areanames{zh}->{861323775} = "广西贵港市";
$areanames{zh}->{861323776} = "广西百色市";
$areanames{zh}->{861323777} = "广西贺州市";
$areanames{zh}->{861323778} = "广西河池市";
$areanames{zh}->{861323779} = "广西来宾市";
$areanames{zh}->{861323780} = "广西南宁市";
$areanames{zh}->{861323781} = "广西南宁市";
$areanames{zh}->{861323782} = "广西柳州市";
$areanames{zh}->{861323783} = "广西桂林市";
$areanames{zh}->{861323784} = "广西贺州市";
$areanames{zh}->{861323785} = "广西贵港市";
$areanames{zh}->{861323786} = "广西玉林市";
$areanames{zh}->{861323787} = "广西来宾市";
$areanames{zh}->{861323788} = "广西河池市";
$areanames{zh}->{861323789} = "广西来宾市";
$areanames{zh}->{861323790} = "江西省新余市";
$areanames{zh}->{861323791} = "江西省南昌市";
$areanames{zh}->{861323792} = "江西省九江市";
$areanames{zh}->{861323793} = "江西省上饶市";
$areanames{zh}->{861323794} = "江西省抚州市";
$areanames{zh}->{861323795} = "江西省宜春市";
$areanames{zh}->{861323796} = "江西省吉安市";
$areanames{zh}->{861323797} = "江西省赣州市";
$areanames{zh}->{861323798} = "江西省景德镇市";
$areanames{zh}->{861323799} = "江西省萍乡市";
$areanames{zh}->{86132380} = "辽宁省大连市";
$areanames{zh}->{861323810} = "辽宁省抚顺市";
$areanames{zh}->{861323811} = "辽宁省阜新市";
$areanames{zh}->{861323812} = "辽宁省辽阳市";
$areanames{zh}->{861323813} = "辽宁省抚顺市";
$areanames{zh}->{861323814} = "辽宁省铁岭市";
$areanames{zh}->{861323815} = "辽宁省丹东市";
$areanames{zh}->{861323816} = "辽宁省锦州市";
$areanames{zh}->{861323817} = "辽宁省鞍山市";
$areanames{zh}->{861323818} = "辽宁省鞍山市";
$areanames{zh}->{861323819} = "辽宁省鞍山市";
$areanames{zh}->{861323820} = "辽宁省营口市";
$areanames{zh}->{861323821} = "辽宁省阜新市";
$areanames{zh}->{861323822} = "辽宁省辽阳市";
$areanames{zh}->{861323823} = "辽宁省盘锦市";
$areanames{zh}->{861323824} = "辽宁省营口市";
$areanames{zh}->{861323825} = "辽宁省丹东市";
$areanames{zh}->{861323826} = "辽宁省营口市";
$areanames{zh}->{861323827} = "辽宁省营口市";
$areanames{zh}->{861323828} = "辽宁省铁岭市";
$areanames{zh}->{861323829} = "辽宁省铁岭市";
$areanames{zh}->{86132383} = "广东省东莞市";
$areanames{zh}->{861323840} = "内蒙古呼和浩特市";
$areanames{zh}->{861323841} = "内蒙古呼和浩特市";
$areanames{zh}->{861323842} = "内蒙古呼和浩特市";
$areanames{zh}->{861323843} = "内蒙古呼和浩特市";
$areanames{zh}->{861323844} = "内蒙古呼和浩特市";
$areanames{zh}->{861323845} = "内蒙古乌海市";
$areanames{zh}->{861323846} = "内蒙古兴安盟";
$areanames{zh}->{861323847} = "内蒙古兴安盟";
$areanames{zh}->{861323848} = "内蒙古兴安盟";
$areanames{zh}->{861323849} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861323850} = "贵州省安顺市";
$areanames{zh}->{861323851} = "贵州省安顺市";
$areanames{zh}->{861323852} = "贵州省毕节地区";
$areanames{zh}->{861323853} = "贵州省六盘水市";
$areanames{zh}->{861323854} = "贵州省六盘水市";
$areanames{zh}->{861323855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861323856} = "贵州省铜仁地区";
$areanames{zh}->{861323857} = "贵州省毕节地区";
$areanames{zh}->{861323858} = "贵州省毕节地区";
$areanames{zh}->{861323859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861323860} = "云南省昭通市";
$areanames{zh}->{861323861} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861323862} = "云南省曲靖市";
$areanames{zh}->{861323863} = "云南省临沧市";
$areanames{zh}->{861323864} = "云南省曲靖市";
$areanames{zh}->{861323865} = "云南省保山市";
$areanames{zh}->{861323866} = "云南省昆明市";
$areanames{zh}->{861323867} = "云南省昆明市";
$areanames{zh}->{861323868} = "云南省昆明市";
$areanames{zh}->{861323869} = "云南省昆明市";
$areanames{zh}->{861323870} = "云南省昭通市";
$areanames{zh}->{861323871} = "云南省昆明市";
$areanames{zh}->{861323872} = "云南省大理白族自治州";
$areanames{zh}->{861323873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861323874} = "云南省曲靖市";
$areanames{zh}->{861323875} = "云南省保山市";
$areanames{zh}->{861323876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861323877} = "云南省玉溪市";
$areanames{zh}->{861323878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861323879} = "云南省普洱市";
$areanames{zh}->{86132388} = "辽宁省沈阳市";
$areanames{zh}->{861323890} = "辽宁省朝阳市";
$areanames{zh}->{861323891} = "辽宁省朝阳市";
$areanames{zh}->{861323892} = "辽宁省葫芦岛市";
$areanames{zh}->{861323893} = "辽宁省辽阳市";
$areanames{zh}->{861323894} = "辽宁省锦州市";
$areanames{zh}->{861323895} = "辽宁省葫芦岛市";
$areanames{zh}->{861323896} = "辽宁省盘锦市";
$areanames{zh}->{861323897} = "辽宁省鞍山市";
$areanames{zh}->{861323898} = "辽宁省鞍山市";
$areanames{zh}->{861323899} = "辽宁省鞍山市";
$areanames{zh}->{861323900} = "新疆昌吉回族自治州";
$areanames{zh}->{861323901} = "新疆喀什地区";
$areanames{zh}->{861323902} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323903} = "新疆石河子市";
$areanames{zh}->{861323904} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323905} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323906} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861323907} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861323908} = "新疆阿克苏地区";
$areanames{zh}->{861323909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861323910} = "陕西省咸阳市";
$areanames{zh}->{861323911} = "陕西省延安市";
$areanames{zh}->{861323912} = "陕西省榆林市";
$areanames{zh}->{861323913} = "陕西省渭南市";
$areanames{zh}->{861323914} = "陕西省商洛市";
$areanames{zh}->{861323915} = "陕西省安康市";
$areanames{zh}->{861323916} = "陕西省汉中市";
$areanames{zh}->{861323917} = "陕西省宝鸡市";
$areanames{zh}->{861323918} = "陕西省延安市";
$areanames{zh}->{861323919} = "陕西省铜川市";
$areanames{zh}->{86132392} = "陕西省榆林市";
$areanames{zh}->{861323920} = "陕西省延安市";
$areanames{zh}->{861323921} = "陕西省延安市";
$areanames{zh}->{861323922} = "陕西省延安市";
$areanames{zh}->{861323923} = "陕西省延安市";
$areanames{zh}->{861323930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861323931} = "甘肃省兰州市";
$areanames{zh}->{861323932} = "甘肃省定西市";
$areanames{zh}->{861323933} = "甘肃省平凉市";
$areanames{zh}->{861323934} = "甘肃省庆阳市";
$areanames{zh}->{861323935} = "甘肃省金昌市";
$areanames{zh}->{861323936} = "甘肃省张掖市";
$areanames{zh}->{861323937} = "甘肃省酒泉市";
$areanames{zh}->{861323938} = "甘肃省天水市";
$areanames{zh}->{861323939} = "甘肃省陇南市";
$areanames{zh}->{861323940} = "甘肃省嘉峪关市";
$areanames{zh}->{861323941} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861323942} = "甘肃省定西市";
$areanames{zh}->{861323943} = "甘肃省白银市";
$areanames{zh}->{861323944} = "甘肃省陇南市";
$areanames{zh}->{861323945} = "甘肃省武威市";
$areanames{zh}->{861323946} = "甘肃省嘉峪关市";
$areanames{zh}->{861323947} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861323948} = "甘肃省张掖市";
$areanames{zh}->{861323949} = "甘肃省酒泉市";
$areanames{zh}->{861323950} = "宁夏银川市";
$areanames{zh}->{861323951} = "宁夏银川市";
$areanames{zh}->{861323952} = "宁夏石嘴山市";
$areanames{zh}->{861323953} = "宁夏吴忠市";
$areanames{zh}->{861323954} = "宁夏固原市";
$areanames{zh}->{861323955} = "宁夏中卫市";
$areanames{zh}->{861323956} = "宁夏石嘴山市";
$areanames{zh}->{861323957} = "宁夏中卫市";
$areanames{zh}->{861323958} = "宁夏银川市";
$areanames{zh}->{861323959} = "宁夏银川市";
$areanames{zh}->{86132396} = "甘肃省兰州市";
$areanames{zh}->{861323960} = "甘肃省庆阳市";
$areanames{zh}->{861323961} = "甘肃省庆阳市";
$areanames{zh}->{861323970} = "新疆喀什地区";
$areanames{zh}->{861323971} = "新疆吐鲁番地区";
$areanames{zh}->{861323972} = "新疆喀什地区";
$areanames{zh}->{861323973} = "新疆哈密地区";
$areanames{zh}->{861323974} = "新疆和田地区";
$areanames{zh}->{861323975} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323976} = "新疆和田地区";
$areanames{zh}->{861323977} = "新疆克拉玛依市";
$areanames{zh}->{861323978} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323979} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323980} = "新疆和田地区";
$areanames{zh}->{861323981} = "新疆和田地区";
$areanames{zh}->{861323982} = "新疆阿克苏地区";
$areanames{zh}->{861323983} = "新疆阿克苏地区";
$areanames{zh}->{861323984} = "新疆阿克苏地区";
$areanames{zh}->{861323985} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861323986} = "新疆阿克苏地区";
$areanames{zh}->{861323987} = "新疆喀什地区";
$areanames{zh}->{861323988} = "新疆昌吉回族自治州";
$areanames{zh}->{861323989} = "新疆昌吉回族自治州";
$areanames{zh}->{861323990} = "新疆克拉玛依市";
$areanames{zh}->{861323991} = "新疆乌鲁木齐市";
$areanames{zh}->{861323992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861323993} = "新疆石河子市";
$areanames{zh}->{861323994} = "新疆昌吉回族自治州";
$areanames{zh}->{861323995} = "新疆吐鲁番地区";
$areanames{zh}->{861323996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861323997} = "新疆阿克苏地区";
$areanames{zh}->{861323998} = "新疆喀什地区";
$areanames{zh}->{861323999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{8613240} = "北京市";
$areanames{zh}->{86132405} = "广东省东莞市";
$areanames{zh}->{86132406} = "广东省东莞市";
$areanames{zh}->{861324083} = "内蒙古兴安盟";
$areanames{zh}->{861324084} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861324085} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861324086} = "内蒙古赤峰市";
$areanames{zh}->{861324087} = "内蒙古呼和浩特市";
$areanames{zh}->{861324088} = "内蒙古呼和浩特市";
$areanames{zh}->{8613241} = "北京市";
$areanames{zh}->{86132420} = "广东省深圳市";
$areanames{zh}->{861324210} = "广东省佛山市";
$areanames{zh}->{861324211} = "广东省佛山市";
$areanames{zh}->{861324212} = "广东省佛山市";
$areanames{zh}->{861324213} = "广东省佛山市";
$areanames{zh}->{861324214} = "广东省佛山市";
$areanames{zh}->{861324215} = "广东省江门市";
$areanames{zh}->{861324216} = "广东省江门市";
$areanames{zh}->{861324217} = "广东省江门市";
$areanames{zh}->{861324218} = "广东省江门市";
$areanames{zh}->{861324219} = "广东省江门市";
$areanames{zh}->{861324220} = "广东省中山市";
$areanames{zh}->{861324221} = "广东省中山市";
$areanames{zh}->{861324222} = "广东省中山市";
$areanames{zh}->{861324223} = "广东省中山市";
$areanames{zh}->{861324224} = "广东省中山市";
$areanames{zh}->{861324225} = "广东省揭阳市";
$areanames{zh}->{861324226} = "广东省揭阳市";
$areanames{zh}->{861324227} = "广东省揭阳市";
$areanames{zh}->{861324228} = "广东省揭阳市";
$areanames{zh}->{861324229} = "广东省揭阳市";
$areanames{zh}->{861324230} = "广东省广州市";
$areanames{zh}->{861324231} = "广东省广州市";
$areanames{zh}->{861324232} = "广东省广州市";
$areanames{zh}->{861324233} = "广东省广州市";
$areanames{zh}->{861324234} = "广东省广州市";
$areanames{zh}->{861324235} = "广东省惠州市";
$areanames{zh}->{861324236} = "广东省惠州市";
$areanames{zh}->{861324237} = "广东省清远市";
$areanames{zh}->{861324238} = "广东省清远市";
$areanames{zh}->{861324239} = "广东省清远市";
$areanames{zh}->{861324240} = "广东省深圳市";
$areanames{zh}->{861324241} = "广东省深圳市";
$areanames{zh}->{861324242} = "广东省深圳市";
$areanames{zh}->{861324243} = "广东省深圳市";
$areanames{zh}->{861324244} = "广东省深圳市";
$areanames{zh}->{861324245} = "广东省佛山市";
$areanames{zh}->{861324246} = "广东省佛山市";
$areanames{zh}->{861324247} = "河北省邢台市";
$areanames{zh}->{861324248} = "广东省江门市";
$areanames{zh}->{861324249} = "广东省江门市";
$areanames{zh}->{86132425} = "广东省韶关市";
$areanames{zh}->{861324257} = "广东省潮州市";
$areanames{zh}->{861324258} = "广东省潮州市";
$areanames{zh}->{861324259} = "广东省潮州市";
$areanames{zh}->{861324260} = "广东省肇庆市";
$areanames{zh}->{861324261} = "广东省肇庆市";
$areanames{zh}->{861324262} = "广东省肇庆市";
$areanames{zh}->{861324263} = "河北省唐山市";
$areanames{zh}->{861324264} = "河北省唐山市";
$areanames{zh}->{861324265} = "广东省汕尾市";
$areanames{zh}->{861324266} = "广东省汕尾市";
$areanames{zh}->{861324267} = "广东省珠海市";
$areanames{zh}->{861324268} = "广东省珠海市";
$areanames{zh}->{861324269} = "广东省珠海市";
$areanames{zh}->{86132427} = "广东省广州市";
$areanames{zh}->{86132428} = "广东省广州市";
$areanames{zh}->{86132429} = "广东省深圳市";
$areanames{zh}->{861324300} = "河南省安阳市";
$areanames{zh}->{861324301} = "河南省安阳市";
$areanames{zh}->{861324302} = "河南省安阳市";
$areanames{zh}->{861324303} = "河南省焦作市";
$areanames{zh}->{861324304} = "河南省焦作市";
$areanames{zh}->{861324305} = "河南省开封市";
$areanames{zh}->{861324306} = "河南省开封市";
$areanames{zh}->{861324307} = "河南省洛阳市";
$areanames{zh}->{861324308} = "河南省洛阳市";
$areanames{zh}->{861324309} = "河南省洛阳市";
$areanames{zh}->{861324310} = "河南省漯河市";
$areanames{zh}->{861324311} = "河南省漯河市";
$areanames{zh}->{861324312} = "河南省南阳市";
$areanames{zh}->{861324313} = "河南省南阳市";
$areanames{zh}->{861324314} = "河南省南阳市";
$areanames{zh}->{861324315} = "河南省南阳市";
$areanames{zh}->{861324316} = "河南省平顶山市";
$areanames{zh}->{861324317} = "河南省平顶山市";
$areanames{zh}->{861324318} = "河南省平顶山市";
$areanames{zh}->{861324319} = "河南省平顶山市";
$areanames{zh}->{861324320} = "河南省濮阳市";
$areanames{zh}->{861324321} = "河南省濮阳市";
$areanames{zh}->{861324322} = "河南省濮阳市";
$areanames{zh}->{861324323} = "河南省三门峡市";
$areanames{zh}->{861324324} = "河南省三门峡市";
$areanames{zh}->{861324325} = "河南省商丘市";
$areanames{zh}->{861324326} = "河南省商丘市";
$areanames{zh}->{861324327} = "河南省商丘市";
$areanames{zh}->{861324328} = "河南省新乡市";
$areanames{zh}->{861324329} = "河南省新乡市";
$areanames{zh}->{861324330} = "河南省信阳市";
$areanames{zh}->{861324331} = "河南省信阳市";
$areanames{zh}->{861324332} = "河南省信阳市";
$areanames{zh}->{861324333} = "河南省许昌市";
$areanames{zh}->{861324334} = "河南省许昌市";
$areanames{zh}->{861324335} = "河南省许昌市";
$areanames{zh}->{861324336} = "河南省许昌市";
$areanames{zh}->{861324337} = "河南省周口市";
$areanames{zh}->{861324338} = "河南省周口市";
$areanames{zh}->{861324339} = "河南省驻马店市";
$areanames{zh}->{861324340} = "河南省鹤壁市";
$areanames{zh}->{861324341} = "河南省鹤壁市";
$areanames{zh}->{861324342} = "河南省郑州市";
$areanames{zh}->{861324343} = "河南省郑州市";
$areanames{zh}->{861324344} = "河南省郑州市";
$areanames{zh}->{861324345} = "河南省焦作市";
$areanames{zh}->{861324346} = "河南省周口市";
$areanames{zh}->{861324347} = "河南省驻马店市";
$areanames{zh}->{861324348} = "河南省驻马店市";
$areanames{zh}->{861324349} = "河南省新乡市";
$areanames{zh}->{86132435} = "重庆市";
$areanames{zh}->{86132436} = "湖南省永州市";
$areanames{zh}->{86132437} = "广东省深圳市";
$areanames{zh}->{86132438} = "广东省深圳市";
$areanames{zh}->{861324390} = "辽宁省葫芦岛市";
$areanames{zh}->{861324391} = "辽宁省锦州市";
$areanames{zh}->{861324392} = "辽宁省锦州市";
$areanames{zh}->{861324393} = "辽宁省营口市";
$areanames{zh}->{861324394} = "辽宁省营口市";
$areanames{zh}->{861324395} = "辽宁省辽阳市";
$areanames{zh}->{861324396} = "辽宁省辽阳市";
$areanames{zh}->{861324397} = "辽宁省葫芦岛市";
$areanames{zh}->{861324398} = "辽宁省葫芦岛市";
$areanames{zh}->{861324399} = "辽宁省葫芦岛市";
$areanames{zh}->{861324400} = "吉林省吉林市";
$areanames{zh}->{861324401} = "吉林省吉林市";
$areanames{zh}->{861324402} = "吉林省吉林市";
$areanames{zh}->{861324403} = "吉林省吉林市";
$areanames{zh}->{861324404} = "吉林省吉林市";
$areanames{zh}->{861324405} = "吉林省四平市";
$areanames{zh}->{861324406} = "吉林省四平市";
$areanames{zh}->{861324407} = "吉林省四平市";
$areanames{zh}->{861324408} = "吉林省四平市";
$areanames{zh}->{861324409} = "吉林省四平市";
$areanames{zh}->{86132441} = "陕西省延安市";
$areanames{zh}->{861324410} = "陕西省西安市";
$areanames{zh}->{861324420} = "吉林省吉林市";
$areanames{zh}->{861324421} = "吉林省吉林市";
$areanames{zh}->{861324422} = "吉林省吉林市";
$areanames{zh}->{861324423} = "吉林省吉林市";
$areanames{zh}->{861324424} = "吉林省四平市";
$areanames{zh}->{861324425} = "吉林省通化市";
$areanames{zh}->{861324426} = "吉林省长春市";
$areanames{zh}->{861324427} = "吉林省长春市";
$areanames{zh}->{861324428} = "吉林省松原市";
$areanames{zh}->{861324429} = "吉林省松原市";
$areanames{zh}->{861324430} = "吉林省长春市";
$areanames{zh}->{861324431} = "吉林省长春市";
$areanames{zh}->{861324432} = "吉林省吉林市";
$areanames{zh}->{861324433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861324434} = "吉林省四平市";
$areanames{zh}->{861324435} = "吉林省通化市";
$areanames{zh}->{861324436} = "吉林省白城市";
$areanames{zh}->{861324437} = "吉林省辽源市";
$areanames{zh}->{861324438} = "吉林省松原市";
$areanames{zh}->{861324439} = "吉林省白山市";
$areanames{zh}->{861324440} = "吉林省长春市";
$areanames{zh}->{861324441} = "吉林省长春市";
$areanames{zh}->{861324442} = "吉林省长春市";
$areanames{zh}->{861324443} = "吉林省长春市";
$areanames{zh}->{861324444} = "吉林省四平市";
$areanames{zh}->{861324445} = "吉林省通化市";
$areanames{zh}->{861324446} = "吉林省白城市";
$areanames{zh}->{861324447} = "吉林省辽源市";
$areanames{zh}->{861324448} = "吉林省松原市";
$areanames{zh}->{861324449} = "吉林省松原市";
$areanames{zh}->{86132445} = "黑龙江省哈尔滨市";
$areanames{zh}->{861324459} = "黑龙江省大庆市";
$areanames{zh}->{86132446} = "黑龙江省哈尔滨市";
$areanames{zh}->{861324469} = "黑龙江省大庆市";
$areanames{zh}->{86132447} = "广东省深圳市";
$areanames{zh}->{861324480} = "广东省广州市";
$areanames{zh}->{861324481} = "广东省广州市";
$areanames{zh}->{861324482} = "广东省广州市";
$areanames{zh}->{861324483} = "广东省广州市";
$areanames{zh}->{861324484} = "广东省广州市";
$areanames{zh}->{861324485} = "广东省深圳市";
$areanames{zh}->{861324486} = "广东省深圳市";
$areanames{zh}->{861324487} = "广东省深圳市";
$areanames{zh}->{861324488} = "广东省深圳市";
$areanames{zh}->{861324489} = "广东省深圳市";
$areanames{zh}->{861324490} = "广东省江门市";
$areanames{zh}->{861324491} = "广东省江门市";
$areanames{zh}->{861324492} = "广东省江门市";
$areanames{zh}->{861324493} = "广东省江门市";
$areanames{zh}->{861324494} = "河北省邢台市";
$areanames{zh}->{861324495} = "广东省东莞市";
$areanames{zh}->{861324496} = "广东省东莞市";
$areanames{zh}->{861324497} = "广东省东莞市";
$areanames{zh}->{861324498} = "广东省东莞市";
$areanames{zh}->{861324499} = "广东省东莞市";
$areanames{zh}->{861324500} = "湖南省常德市";
$areanames{zh}->{861324501} = "湖南省常德市";
$areanames{zh}->{861324502} = "湖南省常德市";
$areanames{zh}->{861324503} = "湖南省常德市";
$areanames{zh}->{861324504} = "湖南省常德市";
$areanames{zh}->{861324505} = "江苏省苏州市";
$areanames{zh}->{861324506} = "江苏省苏州市";
$areanames{zh}->{861324507} = "江苏省苏州市";
$areanames{zh}->{861324508} = "江苏省苏州市";
$areanames{zh}->{861324509} = "江苏省苏州市";
$areanames{zh}->{861324510} = "内蒙古呼和浩特市";
$areanames{zh}->{861324511} = "内蒙古呼和浩特市";
$areanames{zh}->{861324512} = "内蒙古包头市";
$areanames{zh}->{861324513} = "内蒙古包头市";
$areanames{zh}->{861324514} = "内蒙古兴安盟";
$areanames{zh}->{861324515} = "内蒙古兴安盟";
$areanames{zh}->{861324516} = "内蒙古乌海市";
$areanames{zh}->{861324517} = "内蒙古乌兰察布市";
$areanames{zh}->{861324518} = "内蒙古乌兰察布市";
$areanames{zh}->{861324519} = "内蒙古锡林郭勒盟";
$areanames{zh}->{86132452} = "江苏省南京市";
$areanames{zh}->{861324530} = "山东省济南市";
$areanames{zh}->{861324531} = "山东省济南市";
$areanames{zh}->{861324532} = "山东省青岛市";
$areanames{zh}->{861324533} = "山东省淄博市";
$areanames{zh}->{861324534} = "山东省聊城市";
$areanames{zh}->{861324535} = "山东省烟台市";
$areanames{zh}->{861324536} = "山东省日照市";
$areanames{zh}->{861324537} = "山东省聊城市";
$areanames{zh}->{861324538} = "山东省泰安市";
$areanames{zh}->{861324539} = "山东省临沂市";
$areanames{zh}->{861324540} = "山东省济南市";
$areanames{zh}->{861324541} = "山东省济南市";
$areanames{zh}->{861324542} = "山东省青岛市";
$areanames{zh}->{861324543} = "山东省滨州市";
$areanames{zh}->{861324544} = "山东省日照市";
$areanames{zh}->{861324545} = "山东省东营市";
$areanames{zh}->{861324546} = "山东省东营市";
$areanames{zh}->{861324547} = "山东省济南市";
$areanames{zh}->{861324548} = "山东省莱芜市";
$areanames{zh}->{861324549} = "山东省临沂市";
$areanames{zh}->{86132455} = "浙江省宁波市";
$areanames{zh}->{86132456} = "浙江省宁波市";
$areanames{zh}->{86132457} = "江苏省南通市";
$areanames{zh}->{861324570} = "江苏省淮安市";
$areanames{zh}->{861324571} = "湖南省邵阳市";
$areanames{zh}->{86132458} = "江苏省南京市";
$areanames{zh}->{861324590} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861324591} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861324592} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861324593} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861324594} = "内蒙古赤峰市";
$areanames{zh}->{861324595} = "内蒙古赤峰市";
$areanames{zh}->{861324596} = "内蒙古通辽市";
$areanames{zh}->{861324597} = "内蒙古通辽市";
$areanames{zh}->{861324598} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861324599} = "内蒙古呼伦贝尔市";
$areanames{zh}->{86132460} = "广东省中山市";
$areanames{zh}->{861324607} = "广东省汕头市";
$areanames{zh}->{861324608} = "广东省汕头市";
$areanames{zh}->{861324609} = "广东省汕头市";
$areanames{zh}->{86132461} = "广东省惠州市";
$areanames{zh}->{86132462} = "广东省佛山市";
$areanames{zh}->{861324630} = "广东省佛山市";
$areanames{zh}->{861324631} = "广东省佛山市";
$areanames{zh}->{861324632} = "广东省佛山市";
$areanames{zh}->{861324633} = "广东省佛山市";
$areanames{zh}->{861324634} = "广东省佛山市";
$areanames{zh}->{861324635} = "广东省珠海市";
$areanames{zh}->{861324636} = "广东省珠海市";
$areanames{zh}->{861324637} = "广东省珠海市";
$areanames{zh}->{861324638} = "广东省珠海市";
$areanames{zh}->{861324639} = "广东省珠海市";
$areanames{zh}->{86132464} = "广东省广州市";
$areanames{zh}->{861324650} = "广东省湛江市";
$areanames{zh}->{861324651} = "广东省湛江市";
$areanames{zh}->{861324652} = "广东省湛江市";
$areanames{zh}->{861324653} = "广东省湛江市";
$areanames{zh}->{861324654} = "广东省佛山市";
$areanames{zh}->{861324655} = "广东省佛山市";
$areanames{zh}->{861324656} = "广东省惠州市";
$areanames{zh}->{861324657} = "河北省石家庄市";
$areanames{zh}->{861324658} = "广东省江门市";
$areanames{zh}->{861324659} = "广东省江门市";
$areanames{zh}->{86132466} = "广东省深圳市";
$areanames{zh}->{86132467} = "广东省深圳市";
$areanames{zh}->{86132468} = "广东省广州市";
$areanames{zh}->{86132469} = "广东省东莞市";
$areanames{zh}->{861324690} = "广东省揭阳市";
$areanames{zh}->{861324691} = "广东省揭阳市";
$areanames{zh}->{861324700} = "江西省南昌市";
$areanames{zh}->{861324701} = "江西省鹰潭市";
$areanames{zh}->{861324702} = "江西省九江市";
$areanames{zh}->{861324703} = "江西省上饶市";
$areanames{zh}->{861324704} = "江西省抚州市";
$areanames{zh}->{861324705} = "江西省赣州市";
$areanames{zh}->{861324706} = "江西省吉安市";
$areanames{zh}->{861324707} = "江西省赣州市";
$areanames{zh}->{861324708} = "江西省南昌市";
$areanames{zh}->{861324709} = "江西省南昌市";
$areanames{zh}->{86132471} = "湖北省武汉市";
$areanames{zh}->{861324720} = "湖北省黄冈市";
$areanames{zh}->{861324721} = "湖北省孝感市";
$areanames{zh}->{861324722} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861324723} = "湖北省黄石市";
$areanames{zh}->{861324724} = "湖北省咸宁市";
$areanames{zh}->{861324725} = "湖北省荆门市";
$areanames{zh}->{861324726} = "湖北省十堰市";
$areanames{zh}->{861324727} = "湖北省襄樊市";
$areanames{zh}->{861324728} = "湖北省宜昌市";
$areanames{zh}->{861324729} = "湖北省荆州市";
$areanames{zh}->{86132473} = "广东省广州市";
$areanames{zh}->{86132474} = "河北省邢台市";
$areanames{zh}->{86132475} = "广东省广州市";
$areanames{zh}->{861324760} = "广东省深圳市";
$areanames{zh}->{861324761} = "广东省深圳市";
$areanames{zh}->{861324762} = "广东省深圳市";
$areanames{zh}->{861324763} = "广东省深圳市";
$areanames{zh}->{861324764} = "广东省深圳市";
$areanames{zh}->{861324765} = "广东省广州市";
$areanames{zh}->{861324766} = "广东省广州市";
$areanames{zh}->{861324767} = "广东省广州市";
$areanames{zh}->{861324768} = "广东省广州市";
$areanames{zh}->{861324769} = "广东省广州市";
$areanames{zh}->{861324770} = "江西省南昌市";
$areanames{zh}->{861324771} = "江西省南昌市";
$areanames{zh}->{861324772} = "江西省九江市";
$areanames{zh}->{861324773} = "江西省上饶市";
$areanames{zh}->{861324774} = "江西省抚州市";
$areanames{zh}->{861324775} = "江西省宜春市";
$areanames{zh}->{861324776} = "江西省南昌市";
$areanames{zh}->{861324777} = "江西省赣州市";
$areanames{zh}->{861324778} = "江西省南昌市";
$areanames{zh}->{861324779} = "江西省赣州市";
$areanames{zh}->{861324780} = "江西省南昌市";
$areanames{zh}->{861324781} = "江西省南昌市";
$areanames{zh}->{861324782} = "江西省九江市";
$areanames{zh}->{861324783} = "江西省上饶市";
$areanames{zh}->{861324784} = "江西省南昌市";
$areanames{zh}->{861324785} = "江西省九江市";
$areanames{zh}->{861324786} = "江西省南昌市";
$areanames{zh}->{861324787} = "江西省赣州市";
$areanames{zh}->{861324788} = "江西省景德镇市";
$areanames{zh}->{861324789} = "江西省赣州市";
$areanames{zh}->{861324790} = "江西省赣州市";
$areanames{zh}->{861324791} = "江西省南昌市";
$areanames{zh}->{861324792} = "江西省九江市";
$areanames{zh}->{861324793} = "江西省上饶市";
$areanames{zh}->{861324794} = "江西省抚州市";
$areanames{zh}->{861324795} = "江西省宜春市";
$areanames{zh}->{861324796} = "江西省吉安市";
$areanames{zh}->{861324797} = "江西省赣州市";
$areanames{zh}->{861324798} = "江西省景德镇市";
$areanames{zh}->{861324799} = "江西省萍乡市";
$areanames{zh}->{86132480} = "上海市";
$areanames{zh}->{86132481} = "上海市";
$areanames{zh}->{86132482} = "上海市";
$areanames{zh}->{86132483} = "上海市";
$areanames{zh}->{86132484} = "浙江省杭州市";
$areanames{zh}->{861324846} = "浙江省金华市";
$areanames{zh}->{861324847} = "浙江省金华市";
$areanames{zh}->{861324848} = "浙江省金华市";
$areanames{zh}->{861324849} = "浙江省金华市";
$areanames{zh}->{86132485} = "浙江省宁波市";
$areanames{zh}->{86132486} = "浙江省宁波市";
$areanames{zh}->{861324870} = "浙江省宁波市";
$areanames{zh}->{861324871} = "浙江省宁波市";
$areanames{zh}->{861324872} = "浙江省宁波市";
$areanames{zh}->{861324873} = "浙江省宁波市";
$areanames{zh}->{861324874} = "浙江省宁波市";
$areanames{zh}->{861324875} = "浙江省温州市";
$areanames{zh}->{861324876} = "浙江省温州市";
$areanames{zh}->{861324877} = "浙江省温州市";
$areanames{zh}->{861324878} = "浙江省温州市";
$areanames{zh}->{861324879} = "浙江省温州市";
$areanames{zh}->{86132488} = "浙江省金华市";
$areanames{zh}->{86132489} = "浙江省温州市";
$areanames{zh}->{861324900} = "广东省中山市";
$areanames{zh}->{861324901} = "广东省中山市";
$areanames{zh}->{861324902} = "广东省中山市";
$areanames{zh}->{861324903} = "广东省中山市";
$areanames{zh}->{861324904} = "广东省中山市";
$areanames{zh}->{861324905} = "广东省深圳市";
$areanames{zh}->{861324906} = "广东省深圳市";
$areanames{zh}->{861324907} = "广东省深圳市";
$areanames{zh}->{861324908} = "广东省深圳市";
$areanames{zh}->{861324909} = "广东省深圳市";
$areanames{zh}->{86132491} = "广东省广州市";
$areanames{zh}->{861324910} = "广东省江门市";
$areanames{zh}->{861324911} = "广东省江门市";
$areanames{zh}->{861324912} = "广东省江门市";
$areanames{zh}->{86132492} = "广东省佛山市";
$areanames{zh}->{861324930} = "广东省惠州市";
$areanames{zh}->{861324931} = "广东省惠州市";
$areanames{zh}->{861324932} = "广东省惠州市";
$areanames{zh}->{861324933} = "河北省石家庄市";
$areanames{zh}->{861324934} = "河北省石家庄市";
$areanames{zh}->{861324935} = "河北省石家庄市";
$areanames{zh}->{861324936} = "广东省惠州市";
$areanames{zh}->{861324937} = "广东省中山市";
$areanames{zh}->{861324938} = "广东省中山市";
$areanames{zh}->{861324939} = "广东省深圳市";
$areanames{zh}->{861324940} = "广东省佛山市";
$areanames{zh}->{861324941} = "广东省佛山市";
$areanames{zh}->{861324942} = "广东省佛山市";
$areanames{zh}->{861324943} = "广东省深圳市";
$areanames{zh}->{861324944} = "广东省深圳市";
$areanames{zh}->{861324945} = "广东省深圳市";
$areanames{zh}->{861324946} = "广东省深圳市";
$areanames{zh}->{861324947} = "广东省东莞市";
$areanames{zh}->{861324948} = "广东省汕头市";
$areanames{zh}->{861324949} = "广东省汕头市";
$areanames{zh}->{86132495} = "广东省汕头市";
$areanames{zh}->{861324950} = "河北省邢台市";
$areanames{zh}->{86132496} = "广东省广州市";
$areanames{zh}->{86132497} = "广东省广州市";
$areanames{zh}->{86132498} = "广东省深圳市";
$areanames{zh}->{86132499} = "广东省东莞市";
$areanames{zh}->{861324999} = "广东省佛山市";
$areanames{zh}->{861325000} = "河北省邢台市";
$areanames{zh}->{861325001} = "广东省江门市";
$areanames{zh}->{861325002} = "广东省江门市";
$areanames{zh}->{861325003} = "广东省珠海市";
$areanames{zh}->{861325004} = "广东省珠海市";
$areanames{zh}->{861325005} = "广东省珠海市";
$areanames{zh}->{861325006} = "广东省珠海市";
$areanames{zh}->{861325007} = "广东省珠海市";
$areanames{zh}->{861325008} = "广东省中山市";
$areanames{zh}->{861325009} = "广东省中山市";
$areanames{zh}->{861325010} = "广东省佛山市";
$areanames{zh}->{861325011} = "广东省佛山市";
$areanames{zh}->{861325012} = "广东省佛山市";
$areanames{zh}->{861325013} = "广东省佛山市";
$areanames{zh}->{861325014} = "广东省佛山市";
$areanames{zh}->{861325015} = "广东省广州市";
$areanames{zh}->{861325016} = "广东省广州市";
$areanames{zh}->{861325017} = "广东省广州市";
$areanames{zh}->{861325018} = "广东省汕头市";
$areanames{zh}->{861325019} = "广东省汕头市";
$areanames{zh}->{86132502} = "广东省广州市";
$areanames{zh}->{861325030} = "广东省广州市";
$areanames{zh}->{861325031} = "广东省广州市";
$areanames{zh}->{861325032} = "广东省广州市";
$areanames{zh}->{861325033} = "广东省广州市";
$areanames{zh}->{861325034} = "广东省广州市";
$areanames{zh}->{861325035} = "广东省佛山市";
$areanames{zh}->{861325036} = "广东省佛山市";
$areanames{zh}->{861325037} = "广东省佛山市";
$areanames{zh}->{861325038} = "广东省佛山市";
$areanames{zh}->{861325039} = "广东省茂名市";
$areanames{zh}->{861325040} = "广东省湛江市";
$areanames{zh}->{861325041} = "广东省湛江市";
$areanames{zh}->{861325042} = "河北省石家庄市";
$areanames{zh}->{861325043} = "广东省云浮市";
$areanames{zh}->{861325044} = "广东省揭阳市";
$areanames{zh}->{861325045} = "广东省揭阳市";
$areanames{zh}->{861325046} = "广东省江门市";
$areanames{zh}->{861325047} = "广东省江门市";
$areanames{zh}->{861325048} = "广东省中山市";
$areanames{zh}->{861325049} = "广东省中山市";
$areanames{zh}->{86132505} = "广东省广州市";
$areanames{zh}->{861325060} = "广东省惠州市";
$areanames{zh}->{861325061} = "广东省惠州市";
$areanames{zh}->{861325062} = "广东省惠州市";
$areanames{zh}->{861325063} = "广东省惠州市";
$areanames{zh}->{861325064} = "广东省汕头市";
$areanames{zh}->{861325065} = "广东省汕头市";
$areanames{zh}->{861325066} = "广东省揭阳市";
$areanames{zh}->{861325067} = "广东省清远市";
$areanames{zh}->{861325068} = "广东省清远市";
$areanames{zh}->{861325069} = "广东省阳江市";
$areanames{zh}->{86132507} = "广东省广州市";
$areanames{zh}->{861325080} = "浙江省杭州市";
$areanames{zh}->{861325081} = "浙江省杭州市";
$areanames{zh}->{861325082} = "浙江省杭州市";
$areanames{zh}->{861325083} = "浙江省杭州市";
$areanames{zh}->{861325084} = "浙江省杭州市";
$areanames{zh}->{861325085} = "浙江省绍兴市";
$areanames{zh}->{861325086} = "浙江省台州市";
$areanames{zh}->{861325087} = "浙江省温州市";
$areanames{zh}->{861325088} = "浙江省温州市";
$areanames{zh}->{861325089} = "浙江省温州市";
$areanames{zh}->{86132509} = "浙江省宁波市";
$areanames{zh}->{861325090} = "浙江省嘉兴市";
$areanames{zh}->{861325091} = "浙江省嘉兴市";
$areanames{zh}->{861325092} = "浙江省湖州市";
$areanames{zh}->{861325099} = "浙江省金华市";
$areanames{zh}->{861325100} = "浙江省杭州市";
$areanames{zh}->{861325101} = "浙江省杭州市";
$areanames{zh}->{861325102} = "浙江省杭州市";
$areanames{zh}->{861325103} = "浙江省温州市";
$areanames{zh}->{861325104} = "浙江省温州市";
$areanames{zh}->{861325105} = "浙江省温州市";
$areanames{zh}->{861325106} = "浙江省台州市";
$areanames{zh}->{861325107} = "浙江省台州市";
$areanames{zh}->{861325108} = "浙江省衢州市";
$areanames{zh}->{861325109} = "浙江省金华市";
$areanames{zh}->{86132511} = "重庆市";
$areanames{zh}->{86132512} = "重庆市";
$areanames{zh}->{86132513} = "重庆市";
$areanames{zh}->{86132514} = "重庆市";
$areanames{zh}->{861325150} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325151} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325152} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861325153} = "黑龙江省牡丹江市";
$areanames{zh}->{861325154} = "黑龙江省佳木斯市";
$areanames{zh}->{861325155} = "黑龙江省绥化市";
$areanames{zh}->{861325156} = "黑龙江省黑河市";
$areanames{zh}->{861325157} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861325158} = "黑龙江省伊春市";
$areanames{zh}->{861325159} = "黑龙江省大庆市";
$areanames{zh}->{861325160} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325161} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325162} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861325163} = "黑龙江省牡丹江市";
$areanames{zh}->{861325164} = "黑龙江省七台河市";
$areanames{zh}->{861325165} = "黑龙江省绥化市";
$areanames{zh}->{861325166} = "黑龙江省大庆市";
$areanames{zh}->{861325167} = "黑龙江省鸡西市";
$areanames{zh}->{861325168} = "黑龙江省鹤岗市";
$areanames{zh}->{861325169} = "黑龙江省双鸭山市";
$areanames{zh}->{86132517} = "吉林省长春市";
$areanames{zh}->{861325176} = "吉林省白城市";
$areanames{zh}->{861325177} = "吉林省白城市";
$areanames{zh}->{861325178} = "吉林省松原市";
$areanames{zh}->{861325179} = "吉林省松原市";
$areanames{zh}->{861325180} = "吉林省长春市";
$areanames{zh}->{861325181} = "吉林省长春市";
$areanames{zh}->{861325182} = "吉林省吉林市";
$areanames{zh}->{861325183} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861325184} = "吉林省四平市";
$areanames{zh}->{861325185} = "吉林省通化市";
$areanames{zh}->{861325186} = "吉林省白城市";
$areanames{zh}->{861325187} = "吉林省辽源市";
$areanames{zh}->{861325188} = "吉林省松原市";
$areanames{zh}->{861325189} = "吉林省白山市";
$areanames{zh}->{861325190} = "浙江省宁波市";
$areanames{zh}->{861325191} = "浙江省湖州市";
$areanames{zh}->{861325192} = "浙江省湖州市";
$areanames{zh}->{861325193} = "浙江省嘉兴市";
$areanames{zh}->{861325194} = "浙江省嘉兴市";
$areanames{zh}->{861325195} = "浙江省绍兴市";
$areanames{zh}->{861325196} = "浙江省宁波市";
$areanames{zh}->{861325197} = "浙江省宁波市";
$areanames{zh}->{861325198} = "浙江省丽水市";
$areanames{zh}->{861325199} = "浙江省丽水市";
$areanames{zh}->{86132520} = "浙江省湖州市";
$areanames{zh}->{86132521} = "浙江省绍兴市";
$areanames{zh}->{86132522} = "浙江省宁波市";
$areanames{zh}->{861325220} = "浙江省湖州市";
$areanames{zh}->{861325221} = "浙江省湖州市";
$areanames{zh}->{86132523} = "浙江省嘉兴市";
$areanames{zh}->{861325240} = "浙江省宁波市";
$areanames{zh}->{861325241} = "浙江省宁波市";
$areanames{zh}->{861325242} = "浙江省宁波市";
$areanames{zh}->{861325243} = "浙江省宁波市";
$areanames{zh}->{861325244} = "浙江省宁波市";
$areanames{zh}->{861325245} = "浙江省台州市";
$areanames{zh}->{861325246} = "浙江省台州市";
$areanames{zh}->{861325247} = "浙江省台州市";
$areanames{zh}->{861325248} = "浙江省台州市";
$areanames{zh}->{861325249} = "浙江省台州市";
$areanames{zh}->{86132525} = "吉林省吉林市";
$areanames{zh}->{861325250} = "吉林省松原市";
$areanames{zh}->{861325251} = "吉林省松原市";
$areanames{zh}->{861325260} = "吉林省长春市";
$areanames{zh}->{861325261} = "吉林省长春市";
$areanames{zh}->{861325262} = "吉林省长春市";
$areanames{zh}->{861325263} = "吉林省长春市";
$areanames{zh}->{861325264} = "吉林省长春市";
$areanames{zh}->{861325265} = "吉林省通化市";
$areanames{zh}->{861325266} = "吉林省通化市";
$areanames{zh}->{861325267} = "吉林省通化市";
$areanames{zh}->{861325268} = "吉林省辽源市";
$areanames{zh}->{861325269} = "吉林省白山市";
$areanames{zh}->{861325270} = "辽宁省沈阳市";
$areanames{zh}->{861325271} = "辽宁省沈阳市";
$areanames{zh}->{861325272} = "辽宁省沈阳市";
$areanames{zh}->{861325273} = "辽宁省沈阳市";
$areanames{zh}->{861325274} = "辽宁省抚顺市";
$areanames{zh}->{861325275} = "辽宁省抚顺市";
$areanames{zh}->{861325276} = "辽宁省抚顺市";
$areanames{zh}->{861325277} = "辽宁省朝阳市";
$areanames{zh}->{861325278} = "辽宁省朝阳市";
$areanames{zh}->{861325279} = "辽宁省铁岭市";
$areanames{zh}->{86132528} = "辽宁省沈阳市";
$areanames{zh}->{86132529} = "辽宁省大连市";
$areanames{zh}->{86132530} = "河南省安阳市";
$areanames{zh}->{861325308} = "河南省濮阳市";
$areanames{zh}->{861325309} = "河南省濮阳市";
$areanames{zh}->{86132531} = "河北省张家口市";
$areanames{zh}->{861325317} = "河北省承德市";
$areanames{zh}->{861325318} = "河北省承德市";
$areanames{zh}->{861325319} = "河北省承德市";
$areanames{zh}->{86132532} = "河北省衡水市";
$areanames{zh}->{86132533} = "河南省郑州市";
$areanames{zh}->{86132534} = "河南省郑州市";
$areanames{zh}->{86132535} = "河南省郑州市";
$areanames{zh}->{86132536} = "河南省郑州市";
$areanames{zh}->{861325370} = "河南省许昌市";
$areanames{zh}->{861325371} = "河南省许昌市";
$areanames{zh}->{861325372} = "河南省许昌市";
$areanames{zh}->{861325373} = "河南省许昌市";
$areanames{zh}->{861325374} = "河南省许昌市";
$areanames{zh}->{861325375} = "河南省周口市";
$areanames{zh}->{861325376} = "河南省周口市";
$areanames{zh}->{861325377} = "河南省周口市";
$areanames{zh}->{861325378} = "河南省周口市";
$areanames{zh}->{861325379} = "河南省周口市";
$areanames{zh}->{86132538} = "河南省信阳市";
$areanames{zh}->{861325386} = "河南省焦作市";
$areanames{zh}->{861325387} = "河南省焦作市";
$areanames{zh}->{861325388} = "河南省焦作市";
$areanames{zh}->{861325389} = "河南省焦作市";
$areanames{zh}->{86132539} = "河南省三门峡市";
$areanames{zh}->{861325390} = "河南省漯河市";
$areanames{zh}->{861325391} = "河南省漯河市";
$areanames{zh}->{8613254} = "上海市";
$areanames{zh}->{861325500} = "福建省泉州市";
$areanames{zh}->{861325501} = "福建省莆田市";
$areanames{zh}->{861325502} = "福建省龙岩市";
$areanames{zh}->{861325503} = "福建省泉州市";
$areanames{zh}->{861325504} = "福建省福州市";
$areanames{zh}->{861325505} = "福建省福州市";
$areanames{zh}->{861325506} = "福建省厦门市";
$areanames{zh}->{861325507} = "福建省南平市";
$areanames{zh}->{861325508} = "福建省南平市";
$areanames{zh}->{861325509} = "福建省三明市";
$areanames{zh}->{86132551} = "江苏省苏州市";
$areanames{zh}->{861325510} = "江苏省无锡市";
$areanames{zh}->{861325511} = "江苏省无锡市";
$areanames{zh}->{861325520} = "江苏省无锡市";
$areanames{zh}->{861325521} = "江苏省无锡市";
$areanames{zh}->{861325522} = "江苏省无锡市";
$areanames{zh}->{861325523} = "江苏省南通市";
$areanames{zh}->{861325524} = "江苏省南通市";
$areanames{zh}->{861325525} = "江苏省南通市";
$areanames{zh}->{861325526} = "江苏省南京市";
$areanames{zh}->{861325527} = "江苏省南京市";
$areanames{zh}->{861325528} = "江苏省南京市";
$areanames{zh}->{861325529} = "江苏省南京市";
$areanames{zh}->{861325530} = "山东省菏泽市";
$areanames{zh}->{861325531} = "山东省济南市";
$areanames{zh}->{861325532} = "山东省青岛市";
$areanames{zh}->{861325533} = "山东省淄博市";
$areanames{zh}->{861325534} = "山东省德州市";
$areanames{zh}->{861325535} = "山东省烟台市";
$areanames{zh}->{861325536} = "山东省潍坊市";
$areanames{zh}->{861325537} = "山东省济宁市";
$areanames{zh}->{861325538} = "山东省泰安市";
$areanames{zh}->{861325539} = "山东省临沂市";
$areanames{zh}->{861325540} = "山东省菏泽市";
$areanames{zh}->{861325541} = "山东省济南市";
$areanames{zh}->{861325542} = "山东省青岛市";
$areanames{zh}->{861325543} = "山东省滨州市";
$areanames{zh}->{861325544} = "山东省德州市";
$areanames{zh}->{861325545} = "山东省烟台市";
$areanames{zh}->{861325546} = "山东省东营市";
$areanames{zh}->{861325547} = "山东省济宁市";
$areanames{zh}->{861325548} = "山东省泰安市";
$areanames{zh}->{861325549} = "山东省临沂市";
$areanames{zh}->{861325550} = "山东省烟台市";
$areanames{zh}->{861325551} = "山东省烟台市";
$areanames{zh}->{861325552} = "山东省烟台市";
$areanames{zh}->{861325553} = "山东省烟台市";
$areanames{zh}->{861325554} = "山东省烟台市";
$areanames{zh}->{861325555} = "山东省青岛市";
$areanames{zh}->{861325556} = "山东省青岛市";
$areanames{zh}->{861325557} = "山东省青岛市";
$areanames{zh}->{861325558} = "山东省青岛市";
$areanames{zh}->{861325559} = "山东省青岛市";
$areanames{zh}->{861325560} = "山东省东营市";
$areanames{zh}->{861325561} = "山东省东营市";
$areanames{zh}->{861325562} = "山东省东营市";
$areanames{zh}->{861325563} = "山东省东营市";
$areanames{zh}->{861325564} = "山东省威海市";
$areanames{zh}->{861325565} = "山东省威海市";
$areanames{zh}->{861325566} = "山东省威海市";
$areanames{zh}->{861325567} = "山东省威海市";
$areanames{zh}->{861325568} = "山东省济南市";
$areanames{zh}->{861325569} = "山东省济南市";
$areanames{zh}->{861325570} = "浙江省衢州市";
$areanames{zh}->{861325571} = "浙江省杭州市";
$areanames{zh}->{861325572} = "浙江省湖州市";
$areanames{zh}->{861325573} = "浙江省嘉兴市";
$areanames{zh}->{861325574} = "浙江省宁波市";
$areanames{zh}->{861325575} = "浙江省绍兴市";
$areanames{zh}->{861325576} = "浙江省台州市";
$areanames{zh}->{861325577} = "浙江省温州市";
$areanames{zh}->{861325578} = "浙江省丽水市";
$areanames{zh}->{861325579} = "浙江省金华市";
$areanames{zh}->{861325580} = "浙江省舟山市";
$areanames{zh}->{861325581} = "浙江省杭州市";
$areanames{zh}->{861325582} = "浙江省湖州市";
$areanames{zh}->{861325583} = "浙江省嘉兴市";
$areanames{zh}->{861325584} = "浙江省宁波市";
$areanames{zh}->{861325585} = "浙江省绍兴市";
$areanames{zh}->{861325586} = "浙江省台州市";
$areanames{zh}->{861325587} = "浙江省温州市";
$areanames{zh}->{861325588} = "浙江省台州市";
$areanames{zh}->{861325589} = "浙江省金华市";
$areanames{zh}->{861325590} = "福建省厦门市";
$areanames{zh}->{861325591} = "福建省福州市";
$areanames{zh}->{861325592} = "河南省郑州市";
$areanames{zh}->{861325593} = "福建省宁德市";
$areanames{zh}->{861325594} = "福建省厦门市";
$areanames{zh}->{861325595} = "福建省泉州市";
$areanames{zh}->{861325596} = "河南省郑州市";
$areanames{zh}->{861325597} = "福建省龙岩市";
$areanames{zh}->{861325598} = "福建省厦门市";
$areanames{zh}->{861325599} = "福建省福州市";
$areanames{zh}->{86132560} = "山东省日照市";
$areanames{zh}->{86132561} = "山东省济南市";
$areanames{zh}->{86132562} = "山东省德州市";
$areanames{zh}->{861325620} = "山东省菏泽市";
$areanames{zh}->{861325621} = "山东省菏泽市";
$areanames{zh}->{861325628} = "山东省滨州市";
$areanames{zh}->{861325629} = "山东省滨州市";
$areanames{zh}->{861325630} = "山东省威海市";
$areanames{zh}->{861325631} = "山东省威海市";
$areanames{zh}->{861325632} = "山东省枣庄市";
$areanames{zh}->{861325633} = "山东省日照市";
$areanames{zh}->{861325634} = "山东省莱芜市";
$areanames{zh}->{861325635} = "山东省聊城市";
$areanames{zh}->{861325636} = "山东省潍坊市";
$areanames{zh}->{861325637} = "山东省枣庄市";
$areanames{zh}->{861325638} = "山东省烟台市";
$areanames{zh}->{861325639} = "山东省青岛市";
$areanames{zh}->{861325640} = "山东省济南市";
$areanames{zh}->{861325641} = "山东省济南市";
$areanames{zh}->{861325642} = "山东省聊城市";
$areanames{zh}->{861325643} = "山东省菏泽市";
$areanames{zh}->{861325644} = "山东省济南市";
$areanames{zh}->{861325645} = "山东省烟台市";
$areanames{zh}->{861325646} = "山东省潍坊市";
$areanames{zh}->{861325647} = "山东省东营市";
$areanames{zh}->{861325648} = "山东省烟台市";
$areanames{zh}->{861325649} = "山东省滨州市";
$areanames{zh}->{86132565} = "山东省临沂市";
$areanames{zh}->{861325660} = "山东省聊城市";
$areanames{zh}->{861325661} = "山东省聊城市";
$areanames{zh}->{861325662} = "山东省烟台市";
$areanames{zh}->{861325663} = "山东省菏泽市";
$areanames{zh}->{861325664} = "山东省菏泽市";
$areanames{zh}->{861325665} = "山东省济南市";
$areanames{zh}->{861325666} = "山东省济南市";
$areanames{zh}->{861325667} = "山东省济南市";
$areanames{zh}->{861325668} = "山东省济南市";
$areanames{zh}->{861325669} = "山东省济南市";
$areanames{zh}->{86132567} = "山东省济南市";
$areanames{zh}->{86132568} = "山东省青岛市";
$areanames{zh}->{861325680} = "山东省威海市";
$areanames{zh}->{861325681} = "山东省威海市";
$areanames{zh}->{86132569} = "山东省烟台市";
$areanames{zh}->{861325700} = "江西省南昌市";
$areanames{zh}->{861325701} = "江西省鹰潭市";
$areanames{zh}->{861325702} = "江西省九江市";
$areanames{zh}->{861325703} = "江西省上饶市";
$areanames{zh}->{861325704} = "江西省赣州市";
$areanames{zh}->{861325705} = "江西省宜春市";
$areanames{zh}->{861325706} = "江西省新余市";
$areanames{zh}->{861325707} = "江西省赣州市";
$areanames{zh}->{861325708} = "江西省南昌市";
$areanames{zh}->{861325709} = "江西省南昌市";
$areanames{zh}->{861325710} = "湖北省襄樊市";
$areanames{zh}->{861325711} = "湖北省孝感市";
$areanames{zh}->{861325712} = "湖北省孝感市";
$areanames{zh}->{861325713} = "湖北省黄冈市";
$areanames{zh}->{861325714} = "湖北省黄冈市";
$areanames{zh}->{861325715} = "湖北省咸宁市";
$areanames{zh}->{861325716} = "湖北省荆州市";
$areanames{zh}->{861325717} = "湖北省黄冈市";
$areanames{zh}->{861325718} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861325719} = "湖北省黄冈市";
$areanames{zh}->{861325720} = "湖北省咸宁市";
$areanames{zh}->{861325721} = "湖北省荆州市";
$areanames{zh}->{861325722} = "湖北省随州市";
$areanames{zh}->{861325723} = "湖北省荆门市";
$areanames{zh}->{861325724} = "湖北省荆门市";
$areanames{zh}->{861325725} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861325726} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861325727} = "湖北省襄樊市";
$areanames{zh}->{861325728} = "湖北省武汉市";
$areanames{zh}->{861325729} = "湖北省襄樊市";
$areanames{zh}->{861325730} = "湖南省岳阳市";
$areanames{zh}->{861325731} = "湖南省长沙市";
$areanames{zh}->{861325732} = "湖南省湘潭市";
$areanames{zh}->{861325733} = "湖南省株洲市";
$areanames{zh}->{861325734} = "湖南省衡阳市";
$areanames{zh}->{861325735} = "湖南省郴州市";
$areanames{zh}->{861325736} = "湖南省常德市";
$areanames{zh}->{861325737} = "湖南省益阳市";
$areanames{zh}->{861325738} = "湖南省娄底市";
$areanames{zh}->{861325739} = "湖南省邵阳市";
$areanames{zh}->{861325740} = "湖南省岳阳市";
$areanames{zh}->{861325741} = "湖南省株洲市";
$areanames{zh}->{861325742} = "湖南省常德市";
$areanames{zh}->{861325743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861325744} = "湖南省张家界市";
$areanames{zh}->{861325745} = "湖南省怀化市";
$areanames{zh}->{861325746} = "湖南省永州市";
$areanames{zh}->{861325747} = "湖南省益阳市";
$areanames{zh}->{861325748} = "湖南省长沙市";
$areanames{zh}->{861325749} = "湖南省湘潭市";
$areanames{zh}->{861325750} = "广东省江门市";
$areanames{zh}->{861325751} = "广东省韶关市";
$areanames{zh}->{861325752} = "广东省惠州市";
$areanames{zh}->{861325753} = "广东省梅州市";
$areanames{zh}->{861325754} = "广东省汕头市";
$areanames{zh}->{861325755} = "河北省石家庄市";
$areanames{zh}->{861325756} = "广东省珠海市";
$areanames{zh}->{861325757} = "广东省佛山市";
$areanames{zh}->{861325758} = "广东省肇庆市";
$areanames{zh}->{861325759} = "广东省湛江市";
$areanames{zh}->{861325760} = "广东省中山市";
$areanames{zh}->{861325761} = "广东省汕尾市";
$areanames{zh}->{861325762} = "广东省河源市";
$areanames{zh}->{861325763} = "河北省保定市";
$areanames{zh}->{861325764} = "广东省阳江市";
$areanames{zh}->{861325765} = "广东省阳江市";
$areanames{zh}->{861325766} = "广东省云浮市";
$areanames{zh}->{861325767} = "广东省茂名市";
$areanames{zh}->{861325768} = "广东省潮州市";
$areanames{zh}->{861325769} = "广东省东莞市";
$areanames{zh}->{86132577} = "广西南宁市";
$areanames{zh}->{861325780} = "广西柳州市";
$areanames{zh}->{861325781} = "广西柳州市";
$areanames{zh}->{861325782} = "广西来宾市";
$areanames{zh}->{861325783} = "广西来宾市";
$areanames{zh}->{861325784} = "广西来宾市";
$areanames{zh}->{861325785} = "广西玉林市";
$areanames{zh}->{861325786} = "广西玉林市";
$areanames{zh}->{861325787} = "广西玉林市";
$areanames{zh}->{861325788} = "广西玉林市";
$areanames{zh}->{861325789} = "广西玉林市";
$areanames{zh}->{861325790} = "江西省新余市";
$areanames{zh}->{861325791} = "江西省南昌市";
$areanames{zh}->{861325792} = "江西省九江市";
$areanames{zh}->{861325793} = "江西省上饶市";
$areanames{zh}->{861325794} = "江西省抚州市";
$areanames{zh}->{861325795} = "江西省宜春市";
$areanames{zh}->{861325796} = "江西省吉安市";
$areanames{zh}->{861325797} = "江西省赣州市";
$areanames{zh}->{861325798} = "江西省景德镇市";
$areanames{zh}->{861325799} = "江西省萍乡市";
$areanames{zh}->{86132580} = "山东省济宁市";
$areanames{zh}->{861325806} = "山东省潍坊市";
$areanames{zh}->{861325807} = "山东省潍坊市";
$areanames{zh}->{861325808} = "山东省潍坊市";
$areanames{zh}->{861325809} = "山东省潍坊市";
$areanames{zh}->{86132581} = "四川省成都市";
$areanames{zh}->{86132582} = "四川省成都市";
$areanames{zh}->{86132583} = "四川省成都市";
$areanames{zh}->{861325840} = "四川省南充市";
$areanames{zh}->{861325841} = "四川省南充市";
$areanames{zh}->{861325842} = "四川省绵阳市";
$areanames{zh}->{861325843} = "四川省绵阳市";
$areanames{zh}->{861325844} = "四川省绵阳市";
$areanames{zh}->{861325845} = "四川省绵阳市";
$areanames{zh}->{861325846} = "四川省德阳市";
$areanames{zh}->{861325847} = "四川省德阳市";
$areanames{zh}->{861325848} = "四川省遂宁市";
$areanames{zh}->{861325849} = "四川省广安市";
$areanames{zh}->{861325850} = "黑龙江省牡丹江市";
$areanames{zh}->{861325851} = "黑龙江省牡丹江市";
$areanames{zh}->{861325852} = "黑龙江省鸡西市";
$areanames{zh}->{861325853} = "黑龙江省鸡西市";
$areanames{zh}->{861325854} = "黑龙江省双鸭山市";
$areanames{zh}->{861325855} = "黑龙江省双鸭山市";
$areanames{zh}->{861325856} = "黑龙江省鹤岗市";
$areanames{zh}->{861325857} = "黑龙江省绥化市";
$areanames{zh}->{861325858} = "黑龙江省绥化市";
$areanames{zh}->{861325859} = "黑龙江省七台河市";
$areanames{zh}->{861325860} = "黑龙江省佳木斯市";
$areanames{zh}->{861325861} = "黑龙江省佳木斯市";
$areanames{zh}->{861325862} = "黑龙江省佳木斯市";
$areanames{zh}->{861325863} = "黑龙江省大庆市";
$areanames{zh}->{861325864} = "黑龙江省大庆市";
$areanames{zh}->{861325865} = "黑龙江省大庆市";
$areanames{zh}->{861325866} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325867} = "黑龙江省哈尔滨市";
$areanames{zh}->{861325868} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861325869} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{86132587} = "吉林省四平市";
$areanames{zh}->{861325874} = "吉林省通化市";
$areanames{zh}->{861325875} = "吉林省通化市";
$areanames{zh}->{861325876} = "吉林省通化市";
$areanames{zh}->{861325877} = "吉林省通化市";
$areanames{zh}->{861325880} = "吉林省四平市";
$areanames{zh}->{861325881} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861325882} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861325883} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861325884} = "吉林省长春市";
$areanames{zh}->{861325885} = "吉林省通化市";
$areanames{zh}->{861325886} = "吉林省白城市";
$areanames{zh}->{861325887} = "吉林省白城市";
$areanames{zh}->{861325888} = "吉林省长春市";
$areanames{zh}->{861325889} = "吉林省白山市";
$areanames{zh}->{861325890} = "山东省滨州市";
$areanames{zh}->{861325891} = "山东省滨州市";
$areanames{zh}->{861325892} = "山东省菏泽市";
$areanames{zh}->{861325893} = "山东省菏泽市";
$areanames{zh}->{861325894} = "山东省日照市";
$areanames{zh}->{861325895} = "山东省日照市";
$areanames{zh}->{861325896} = "山东省枣庄市";
$areanames{zh}->{861325897} = "山东省枣庄市";
$areanames{zh}->{861325898} = "山东省聊城市";
$areanames{zh}->{861325899} = "山东省聊城市";
$areanames{zh}->{86132590} = "陕西省咸阳市";
$areanames{zh}->{861325906} = "陕西省渭南市";
$areanames{zh}->{861325907} = "陕西省渭南市";
$areanames{zh}->{861325908} = "陕西省渭南市";
$areanames{zh}->{861325909} = "陕西省渭南市";
$areanames{zh}->{861325910} = "陕西省咸阳市";
$areanames{zh}->{861325911} = "陕西省延安市";
$areanames{zh}->{861325912} = "陕西省榆林市";
$areanames{zh}->{861325913} = "陕西省渭南市";
$areanames{zh}->{861325914} = "陕西省商洛市";
$areanames{zh}->{861325915} = "陕西省安康市";
$areanames{zh}->{861325916} = "陕西省汉中市";
$areanames{zh}->{861325917} = "陕西省宝鸡市";
$areanames{zh}->{861325918} = "陕西省商洛市";
$areanames{zh}->{861325919} = "陕西省铜川市";
$areanames{zh}->{861325920} = "陕西省渭南市";
$areanames{zh}->{861325921} = "陕西省宝鸡市";
$areanames{zh}->{861325922} = "陕西省宝鸡市";
$areanames{zh}->{861325923} = "陕西省宝鸡市";
$areanames{zh}->{861325924} = "陕西省宝鸡市";
$areanames{zh}->{861325925} = "陕西省汉中市";
$areanames{zh}->{861325926} = "陕西省汉中市";
$areanames{zh}->{861325927} = "陕西省汉中市";
$areanames{zh}->{861325928} = "陕西省汉中市";
$areanames{zh}->{861325929} = "陕西省汉中市";
$areanames{zh}->{86132593} = "陕西省榆林市";
$areanames{zh}->{861325930} = "陕西省延安市";
$areanames{zh}->{861325931} = "陕西省延安市";
$areanames{zh}->{861325932} = "陕西省延安市";
$areanames{zh}->{861325939} = "陕西省安康市";
$areanames{zh}->{86132594} = "陕西省西安市";
$areanames{zh}->{861325950} = "宁夏银川市";
$areanames{zh}->{861325951} = "宁夏银川市";
$areanames{zh}->{861325952} = "宁夏石嘴山市";
$areanames{zh}->{861325953} = "宁夏吴忠市";
$areanames{zh}->{861325954} = "宁夏固原市";
$areanames{zh}->{861325955} = "宁夏中卫市";
$areanames{zh}->{861325956} = "宁夏吴忠市";
$areanames{zh}->{861325957} = "宁夏中卫市";
$areanames{zh}->{861325958} = "宁夏银川市";
$areanames{zh}->{861325959} = "宁夏中卫市";
$areanames{zh}->{861325960} = "宁夏银川市";
$areanames{zh}->{861325961} = "宁夏银川市";
$areanames{zh}->{861325962} = "宁夏石嘴山市";
$areanames{zh}->{861325963} = "宁夏吴忠市";
$areanames{zh}->{861325964} = "宁夏固原市";
$areanames{zh}->{861325965} = "宁夏中卫市";
$areanames{zh}->{861325966} = "宁夏吴忠市";
$areanames{zh}->{861325967} = "宁夏中卫市";
$areanames{zh}->{861325968} = "宁夏银川市";
$areanames{zh}->{861325969} = "宁夏中卫市";
$areanames{zh}->{86132597} = "陕西省西安市";
$areanames{zh}->{86132598} = "陕西省西安市";
$areanames{zh}->{86132599} = "陕西省西安市";
$areanames{zh}->{86132600} = "北京市";
$areanames{zh}->{861326004} = "内蒙古呼和浩特市";
$areanames{zh}->{86132601} = "北京市";
$areanames{zh}->{861326014} = "内蒙古赤峰市";
$areanames{zh}->{86132602} = "北京市";
$areanames{zh}->{861326024} = "内蒙古阿拉善盟";
$areanames{zh}->{86132603} = "北京市";
$areanames{zh}->{861326034} = "甘肃省庆阳市";
$areanames{zh}->{86132604} = "北京市";
$areanames{zh}->{86132605} = "湖北省武汉市";
$areanames{zh}->{86132606} = "湖北省武汉市";
$areanames{zh}->{86132607} = "江苏省南京市";
$areanames{zh}->{86132608} = "江苏省南京市";
$areanames{zh}->{861326089} = "湖南省邵阳市";
$areanames{zh}->{86132609} = "江苏省南京市";
$areanames{zh}->{8613261} = "北京市";
$areanames{zh}->{8613262} = "上海市";
$areanames{zh}->{86132620} = "河南省南阳市";
$areanames{zh}->{86132621} = "河南省新乡市";
$areanames{zh}->{86132623} = "浙江省温州市";
$areanames{zh}->{86132624} = "浙江省温州市";
$areanames{zh}->{861326300} = "江西省南昌市";
$areanames{zh}->{861326301} = "江西省赣州市";
$areanames{zh}->{861326302} = "江西省九江市";
$areanames{zh}->{861326303} = "江西省上饶市";
$areanames{zh}->{861326304} = "江西省上饶市";
$areanames{zh}->{861326305} = "江西省宜春市";
$areanames{zh}->{861326306} = "江西省赣州市";
$areanames{zh}->{861326307} = "江西省赣州市";
$areanames{zh}->{861326308} = "江西省抚州市";
$areanames{zh}->{861326309} = "江西省南昌市";
$areanames{zh}->{86132631} = "北京市";
$areanames{zh}->{86132632} = "北京市";
$areanames{zh}->{861326324} = "甘肃省庆阳市";
$areanames{zh}->{86132633} = "北京市";
$areanames{zh}->{861326334} = "甘肃省庆阳市";
$areanames{zh}->{86132634} = "北京市";
$areanames{zh}->{861326350} = "黑龙江省哈尔滨市";
$areanames{zh}->{861326351} = "黑龙江省哈尔滨市";
$areanames{zh}->{861326352} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861326353} = "黑龙江省牡丹江市";
$areanames{zh}->{861326354} = "黑龙江省哈尔滨市";
$areanames{zh}->{861326355} = "黑龙江省哈尔滨市";
$areanames{zh}->{861326356} = "黑龙江省七台河市";
$areanames{zh}->{861326357} = "黑龙江省双鸭山市";
$areanames{zh}->{861326358} = "黑龙江省大庆市";
$areanames{zh}->{861326359} = "黑龙江省大庆市";
$areanames{zh}->{86132636} = "黑龙江省哈尔滨市";
$areanames{zh}->{861326364} = "黑龙江省大庆市";
$areanames{zh}->{861326365} = "黑龙江省大庆市";
$areanames{zh}->{861326370} = "广西南宁市";
$areanames{zh}->{861326371} = "广西南宁市";
$areanames{zh}->{861326372} = "广西柳州市";
$areanames{zh}->{861326373} = "广西桂林市";
$areanames{zh}->{861326374} = "广西梧州市";
$areanames{zh}->{861326375} = "广西玉林市";
$areanames{zh}->{861326376} = "广西梧州市";
$areanames{zh}->{861326377} = "广西钦州市";
$areanames{zh}->{861326378} = "广西南宁市";
$areanames{zh}->{861326379} = "广西贺州市";
$areanames{zh}->{861326380} = "广西南宁市";
$areanames{zh}->{861326381} = "广西南宁市";
$areanames{zh}->{861326382} = "广西柳州市";
$areanames{zh}->{861326383} = "广西桂林市";
$areanames{zh}->{861326384} = "广西贺州市";
$areanames{zh}->{861326385} = "广西来宾市";
$areanames{zh}->{861326386} = "广西梧州市";
$areanames{zh}->{861326387} = "广西来宾市";
$areanames{zh}->{861326388} = "广西南宁市";
$areanames{zh}->{861326389} = "广西贵港市";
$areanames{zh}->{861326390} = "江西省宜春市";
$areanames{zh}->{861326391} = "江西省南昌市";
$areanames{zh}->{861326392} = "江西省九江市";
$areanames{zh}->{861326393} = "江西省上饶市";
$areanames{zh}->{861326394} = "江西省抚州市";
$areanames{zh}->{861326395} = "江西省宜春市";
$areanames{zh}->{861326396} = "江西省吉安市";
$areanames{zh}->{861326397} = "江西省赣州市";
$areanames{zh}->{861326398} = "江西省景德镇市";
$areanames{zh}->{861326399} = "江西省萍乡市";
$areanames{zh}->{8613264} = "北京市";
$areanames{zh}->{861326454} = "甘肃省临夏回族自治州";
$areanames{zh}->{86132646} = "湖北省荆州市";
$areanames{zh}->{861326470} = "湖北省武汉市";
$areanames{zh}->{861326471} = "湖北省武汉市";
$areanames{zh}->{861326472} = "湖北省武汉市";
$areanames{zh}->{861326473} = "湖北省武汉市";
$areanames{zh}->{861326474} = "湖北省武汉市";
$areanames{zh}->{861326475} = "湖北省随州市";
$areanames{zh}->{861326476} = "湖北省随州市";
$areanames{zh}->{861326477} = "湖北省襄樊市";
$areanames{zh}->{861326478} = "湖北省襄樊市";
$areanames{zh}->{861326479} = "湖北省襄樊市";
$areanames{zh}->{861326480} = "湖北省黄冈市";
$areanames{zh}->{861326481} = "湖北省黄冈市";
$areanames{zh}->{861326482} = "湖北省黄冈市";
$areanames{zh}->{861326483} = "湖北省黄冈市";
$areanames{zh}->{861326484} = "湖北省孝感市";
$areanames{zh}->{861326485} = "湖北省孝感市";
$areanames{zh}->{861326486} = "湖北省孝感市";
$areanames{zh}->{861326487} = "湖北省孝感市";
$areanames{zh}->{861326488} = "湖北省十堰市";
$areanames{zh}->{861326489} = "湖北省十堰市";
$areanames{zh}->{861326490} = "湖北省宜昌市";
$areanames{zh}->{861326491} = "湖北省宜昌市";
$areanames{zh}->{861326492} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861326493} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861326494} = "湖北省鄂州市";
$areanames{zh}->{861326495} = "湖北省荆门市";
$areanames{zh}->{861326496} = "湖北省荆门市";
$areanames{zh}->{861326497} = "湖北省武汉市";
$areanames{zh}->{861326498} = "湖北省武汉市";
$areanames{zh}->{861326499} = "湖北省鄂州市";
$areanames{zh}->{86132650} = "广东省广州市";
$areanames{zh}->{86132651} = "广东省广州市";
$areanames{zh}->{86132652} = "广东省东莞市";
$areanames{zh}->{86132653} = "广东省广州市";
$areanames{zh}->{86132654} = "广东省深圳市";
$areanames{zh}->{86132655} = "广东省深圳市";
$areanames{zh}->{861326550} = "广东省广州市";
$areanames{zh}->{861326551} = "广东省广州市";
$areanames{zh}->{86132656} = "广东省深圳市";
$areanames{zh}->{86132657} = "广东省深圳市";
$areanames{zh}->{86132658} = "广东省深圳市";
$areanames{zh}->{86132659} = "广东省广州市";
$areanames{zh}->{86132660} = "广东省东莞市";
$areanames{zh}->{86132661} = "广东省东莞市";
$areanames{zh}->{86132662} = "广东省东莞市";
$areanames{zh}->{86132663} = "广东省佛山市";
$areanames{zh}->{861326640} = "广东省湛江市";
$areanames{zh}->{861326641} = "广东省湛江市";
$areanames{zh}->{861326642} = "广东省湛江市";
$areanames{zh}->{861326643} = "广东省湛江市";
$areanames{zh}->{861326644} = "广东省湛江市";
$areanames{zh}->{861326645} = "广东省江门市";
$areanames{zh}->{861326646} = "广东省江门市";
$areanames{zh}->{861326647} = "河北省邢台市";
$areanames{zh}->{861326648} = "广东省江门市";
$areanames{zh}->{861326649} = "广东省江门市";
$areanames{zh}->{86132665} = "广东省深圳市";
$areanames{zh}->{86132666} = "广东省深圳市";
$areanames{zh}->{86132667} = "广东省深圳市";
$areanames{zh}->{86132668} = "广东省深圳市";
$areanames{zh}->{861326690} = "河北省石家庄市";
$areanames{zh}->{861326691} = "河北省石家庄市";
$areanames{zh}->{861326692} = "广东省东莞市";
$areanames{zh}->{861326693} = "广东省东莞市";
$areanames{zh}->{861326694} = "广东省东莞市";
$areanames{zh}->{861326695} = "广东省东莞市";
$areanames{zh}->{861326696} = "广东省深圳市";
$areanames{zh}->{861326697} = "广东省东莞市";
$areanames{zh}->{861326698} = "广东省深圳市";
$areanames{zh}->{861326699} = "广东省深圳市";
$areanames{zh}->{86132670} = "广东省深圳市";
$areanames{zh}->{86132671} = "广东省深圳市";
$areanames{zh}->{861326720} = "广东省深圳市";
$areanames{zh}->{861326721} = "广东省深圳市";
$areanames{zh}->{861326722} = "广东省深圳市";
$areanames{zh}->{861326723} = "广东省深圳市";
$areanames{zh}->{861326724} = "广东省深圳市";
$areanames{zh}->{861326725} = "广东省东莞市";
$areanames{zh}->{861326726} = "广东省东莞市";
$areanames{zh}->{861326727} = "广东省东莞市";
$areanames{zh}->{861326728} = "广东省东莞市";
$areanames{zh}->{861326729} = "广东省东莞市";
$areanames{zh}->{86132673} = "广东省东莞市";
$areanames{zh}->{86132674} = "广东省东莞市";
$areanames{zh}->{86132675} = "广东省东莞市";
$areanames{zh}->{861326760} = "广东省中山市";
$areanames{zh}->{861326761} = "广东省中山市";
$areanames{zh}->{861326762} = "广东省中山市";
$areanames{zh}->{861326763} = "广东省中山市";
$areanames{zh}->{861326764} = "广东省中山市";
$areanames{zh}->{861326765} = "广东省江门市";
$areanames{zh}->{861326766} = "广东省江门市";
$areanames{zh}->{861326767} = "广东省江门市";
$areanames{zh}->{861326768} = "广东省江门市";
$areanames{zh}->{861326769} = "广东省江门市";
$areanames{zh}->{861326770} = "广东省汕尾市";
$areanames{zh}->{861326771} = "广东省汕尾市";
$areanames{zh}->{861326772} = "广东省汕尾市";
$areanames{zh}->{861326773} = "广东省汕尾市";
$areanames{zh}->{861326774} = "广东省汕尾市";
$areanames{zh}->{861326775} = "广东省汕头市";
$areanames{zh}->{861326776} = "广东省汕头市";
$areanames{zh}->{861326777} = "广东省汕头市";
$areanames{zh}->{861326778} = "广东省汕头市";
$areanames{zh}->{861326779} = "广东省汕头市";
$areanames{zh}->{861326780} = "广东省梅州市";
$areanames{zh}->{861326781} = "广东省梅州市";
$areanames{zh}->{861326782} = "广东省梅州市";
$areanames{zh}->{861326783} = "河北省石家庄市";
$areanames{zh}->{861326784} = "河北省石家庄市";
$areanames{zh}->{861326785} = "广东省湛江市";
$areanames{zh}->{861326786} = "广东省湛江市";
$areanames{zh}->{861326787} = "广东省湛江市";
$areanames{zh}->{861326788} = "广东省湛江市";
$areanames{zh}->{861326789} = "广东省湛江市";
$areanames{zh}->{861326790} = "广东省惠州市";
$areanames{zh}->{861326791} = "广东省惠州市";
$areanames{zh}->{861326792} = "广东省惠州市";
$areanames{zh}->{861326793} = "广东省惠州市";
$areanames{zh}->{861326794} = "广东省惠州市";
$areanames{zh}->{861326795} = "广东省珠海市";
$areanames{zh}->{861326796} = "广东省珠海市";
$areanames{zh}->{861326797} = "广东省珠海市";
$areanames{zh}->{861326798} = "广东省珠海市";
$areanames{zh}->{861326799} = "广东省珠海市";
$areanames{zh}->{8613268} = "广东省东莞市";
$areanames{zh}->{86132680} = "广东省广州市";
$areanames{zh}->{86132681} = "广东省广州市";
$areanames{zh}->{86132682} = "广东省广州市";
$areanames{zh}->{86132683} = "广东省广州市";
$areanames{zh}->{8613269} = "北京市";
$areanames{zh}->{861326914} = "甘肃省临夏回族自治州";
$areanames{zh}->{861326924} = "甘肃省临夏回族自治州";
$areanames{zh}->{861326934} = "甘肃省张掖市";
$areanames{zh}->{861326954} = "甘肃省庆阳市";
$areanames{zh}->{861326984} = "甘肃省平凉市";
$areanames{zh}->{861326994} = "甘肃省天水市";
$areanames{zh}->{86132700} = "江苏省盐城市";
$areanames{zh}->{861327000} = "江苏省扬州市";
$areanames{zh}->{861327001} = "江苏省扬州市";
$areanames{zh}->{86132701} = "江苏省无锡市";
$areanames{zh}->{86132702} = "江苏省徐州市";
$areanames{zh}->{861327030} = "内蒙古乌海市";
$areanames{zh}->{861327031} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861327032} = "江苏省镇江市";
$areanames{zh}->{861327033} = "江苏省徐州市";
$areanames{zh}->{861327034} = "甘肃省白银市";
$areanames{zh}->{861327035} = "江苏省徐州市";
$areanames{zh}->{861327036} = "江苏省徐州市";
$areanames{zh}->{861327037} = "江苏省常州市";
$areanames{zh}->{861327038} = "江苏省常州市";
$areanames{zh}->{861327039} = "江苏省常州市";
$areanames{zh}->{861327040} = "江苏省连云港市";
$areanames{zh}->{861327041} = "江苏省无锡市";
$areanames{zh}->{861327042} = "江苏省无锡市";
$areanames{zh}->{861327043} = "江苏省南通市";
$areanames{zh}->{861327044} = "江苏省南京市";
$areanames{zh}->{861327045} = "江苏省南京市";
$areanames{zh}->{861327046} = "江苏省苏州市";
$areanames{zh}->{861327047} = "江苏省苏州市";
$areanames{zh}->{861327048} = "江苏省徐州市";
$areanames{zh}->{861327049} = "湖南省邵阳市";
$areanames{zh}->{86132705} = "江苏省扬州市";
$areanames{zh}->{86132706} = "江苏省南通市";
$areanames{zh}->{861327060} = "江苏省连云港市";
$areanames{zh}->{861327063} = "内蒙古通辽市";
$areanames{zh}->{861327064} = "湖南省郴州市";
$areanames{zh}->{861327065} = "湖南省郴州市";
$areanames{zh}->{86132707} = "江苏省南京市";
$areanames{zh}->{861327076} = "江苏省泰州市";
$areanames{zh}->{861327077} = "江苏省泰州市";
$areanames{zh}->{861327078} = "江苏省泰州市";
$areanames{zh}->{861327079} = "江苏省泰州市";
$areanames{zh}->{86132708} = "江苏省南京市";
$areanames{zh}->{86132709} = "江苏省常州市";
$areanames{zh}->{861327096} = "江苏省苏州市";
$areanames{zh}->{861327097} = "江苏省苏州市";
$areanames{zh}->{861327098} = "江苏省苏州市";
$areanames{zh}->{861327099} = "江苏省苏州市";
$areanames{zh}->{86132710} = "河南省商丘市";
$areanames{zh}->{861327110} = "河南省商丘市";
$areanames{zh}->{861327111} = "河南省商丘市";
$areanames{zh}->{861327112} = "河南省信阳市";
$areanames{zh}->{861327113} = "河南省信阳市";
$areanames{zh}->{861327114} = "河南省开封市";
$areanames{zh}->{861327115} = "河南省开封市";
$areanames{zh}->{861327116} = "河南省周口市";
$areanames{zh}->{861327117} = "河南省周口市";
$areanames{zh}->{861327118} = "河南省许昌市";
$areanames{zh}->{861327119} = "河南省许昌市";
$areanames{zh}->{86132712} = "河南省许昌市";
$areanames{zh}->{86132713} = "河南省南阳市";
$areanames{zh}->{86132714} = "河南省平顶山市";
$areanames{zh}->{861327150} = "河南省洛阳市";
$areanames{zh}->{861327151} = "河南省洛阳市";
$areanames{zh}->{861327152} = "河南省洛阳市";
$areanames{zh}->{861327153} = "河南省洛阳市";
$areanames{zh}->{861327154} = "河南省洛阳市";
$areanames{zh}->{861327155} = "河南省郑州市";
$areanames{zh}->{861327156} = "河南省郑州市";
$areanames{zh}->{861327157} = "河南省郑州市";
$areanames{zh}->{861327158} = "河南省郑州市";
$areanames{zh}->{861327159} = "河南省郑州市";
$areanames{zh}->{86132716} = "河南省周口市";
$areanames{zh}->{86132717} = "河南省驻马店市";
$areanames{zh}->{861327178} = "河南省南阳市";
$areanames{zh}->{861327179} = "河南省南阳市";
$areanames{zh}->{86132718} = "重庆市";
$areanames{zh}->{86132719} = "重庆市";
$areanames{zh}->{86132720} = "湖南省长沙市";
$areanames{zh}->{861327210} = "湖南省株洲市";
$areanames{zh}->{861327211} = "湖南省株洲市";
$areanames{zh}->{861327212} = "湖南省株洲市";
$areanames{zh}->{861327213} = "湖南省株洲市";
$areanames{zh}->{861327214} = "湖南省株洲市";
$areanames{zh}->{861327215} = "湖南省益阳市";
$areanames{zh}->{861327216} = "湖南省益阳市";
$areanames{zh}->{861327217} = "湖南省益阳市";
$areanames{zh}->{861327218} = "湖南省益阳市";
$areanames{zh}->{861327219} = "湖南省益阳市";
$areanames{zh}->{86132722} = "湖南省怀化市";
$areanames{zh}->{861327220} = "湖南省邵阳市";
$areanames{zh}->{861327221} = "湖南省衡阳市";
$areanames{zh}->{861327222} = "湖南省张家界市";
$areanames{zh}->{861327223} = "湖南省长沙市";
$areanames{zh}->{861327230} = "湖南省衡阳市";
$areanames{zh}->{861327231} = "湖南省衡阳市";
$areanames{zh}->{861327232} = "湖南省衡阳市";
$areanames{zh}->{861327233} = "湖南省衡阳市";
$areanames{zh}->{861327234} = "湖南省衡阳市";
$areanames{zh}->{861327235} = "湖南省郴州市";
$areanames{zh}->{861327236} = "湖南省郴州市";
$areanames{zh}->{861327237} = "湖南省郴州市";
$areanames{zh}->{861327238} = "湖南省郴州市";
$areanames{zh}->{861327239} = "湖南省郴州市";
$areanames{zh}->{86132724} = "湖南省长沙市";
$areanames{zh}->{86132725} = "重庆市";
$areanames{zh}->{86132726} = "重庆市";
$areanames{zh}->{86132727} = "重庆市";
$areanames{zh}->{86132728} = "重庆市";
$areanames{zh}->{86132729} = "重庆市";
$areanames{zh}->{861327300} = "河南省周口市";
$areanames{zh}->{861327301} = "河南省周口市";
$areanames{zh}->{861327302} = "河南省郑州市";
$areanames{zh}->{861327303} = "河南省濮阳市";
$areanames{zh}->{861327304} = "河南省开封市";
$areanames{zh}->{861327305} = "河南省漯河市";
$areanames{zh}->{861327306} = "河南省漯河市";
$areanames{zh}->{861327307} = "河南省漯河市";
$areanames{zh}->{861327308} = "河南省三门峡市";
$areanames{zh}->{861327309} = "河南省三门峡市";
$areanames{zh}->{86132731} = "河北省石家庄市";
$areanames{zh}->{86132732} = "河北省保定市";
$areanames{zh}->{861327330} = "河北省衡水市";
$areanames{zh}->{861327331} = "河北省衡水市";
$areanames{zh}->{861327332} = "河北省衡水市";
$areanames{zh}->{861327333} = "河北省衡水市";
$areanames{zh}->{861327334} = "河北省衡水市";
$areanames{zh}->{861327335} = "河北省秦皇岛市";
$areanames{zh}->{861327336} = "河北省秦皇岛市";
$areanames{zh}->{861327337} = "河北省秦皇岛市";
$areanames{zh}->{861327338} = "河北省秦皇岛市";
$areanames{zh}->{861327339} = "河北省秦皇岛市";
$areanames{zh}->{861327340} = "河北省石家庄市";
$areanames{zh}->{861327341} = "河北省石家庄市";
$areanames{zh}->{861327342} = "河北省石家庄市";
$areanames{zh}->{861327343} = "河北省石家庄市";
$areanames{zh}->{861327344} = "河北省石家庄市";
$areanames{zh}->{861327345} = "河北省邢台市";
$areanames{zh}->{861327346} = "河北省邢台市";
$areanames{zh}->{861327347} = "河北省邢台市";
$areanames{zh}->{861327348} = "河北省邢台市";
$areanames{zh}->{861327349} = "河北省邢台市";
$areanames{zh}->{86132735} = "河北省唐山市";
$areanames{zh}->{861327360} = "河北省廊坊市";
$areanames{zh}->{861327361} = "河北省廊坊市";
$areanames{zh}->{861327362} = "河北省廊坊市";
$areanames{zh}->{861327363} = "河北省廊坊市";
$areanames{zh}->{861327364} = "河北省廊坊市";
$areanames{zh}->{861327365} = "河北省邢台市";
$areanames{zh}->{861327366} = "河北省邢台市";
$areanames{zh}->{861327367} = "河北省邢台市";
$areanames{zh}->{861327368} = "河北省邢台市";
$areanames{zh}->{861327369} = "河北省邢台市";
$areanames{zh}->{861327370} = "河南省商丘市";
$areanames{zh}->{861327371} = "河南省郑州市";
$areanames{zh}->{861327372} = "河南省新乡市";
$areanames{zh}->{861327373} = "河南省新乡市";
$areanames{zh}->{861327374} = "河南省许昌市";
$areanames{zh}->{861327375} = "河南省平顶山市";
$areanames{zh}->{861327376} = "河南省信阳市";
$areanames{zh}->{861327377} = "河南省南阳市";
$areanames{zh}->{861327378} = "河南省开封市";
$areanames{zh}->{861327379} = "河南省南阳市";
$areanames{zh}->{861327380} = "河南省郑州市";
$areanames{zh}->{861327381} = "河南省郑州市";
$areanames{zh}->{861327382} = "河南省商丘市";
$areanames{zh}->{861327383} = "河南省商丘市";
$areanames{zh}->{861327384} = "河南省商丘市";
$areanames{zh}->{861327385} = "河南省许昌市";
$areanames{zh}->{861327386} = "河南省许昌市";
$areanames{zh}->{861327387} = "河南省许昌市";
$areanames{zh}->{861327388} = "河南省平顶山市";
$areanames{zh}->{861327389} = "河南省平顶山市";
$areanames{zh}->{861327390} = "河南省焦作市";
$areanames{zh}->{861327391} = "河南省焦作市";
$areanames{zh}->{861327392} = "河南省鹤壁市";
$areanames{zh}->{861327393} = "河南省濮阳市";
$areanames{zh}->{861327394} = "河南省周口市";
$areanames{zh}->{861327395} = "河南省漯河市";
$areanames{zh}->{861327396} = "河南省驻马店市";
$areanames{zh}->{861327397} = "河南省信阳市";
$areanames{zh}->{861327398} = "河南省三门峡市";
$areanames{zh}->{861327399} = "河南省驻马店市";
$areanames{zh}->{86132740} = "重庆市";
$areanames{zh}->{861327410} = "辽宁省铁岭市";
$areanames{zh}->{861327411} = "辽宁省大连市";
$areanames{zh}->{861327412} = "辽宁省鞍山市";
$areanames{zh}->{861327413} = "辽宁省抚顺市";
$areanames{zh}->{861327414} = "辽宁省本溪市";
$areanames{zh}->{861327415} = "辽宁省丹东市";
$areanames{zh}->{861327416} = "辽宁省锦州市";
$areanames{zh}->{861327417} = "辽宁省营口市";
$areanames{zh}->{861327418} = "辽宁省阜新市";
$areanames{zh}->{861327419} = "辽宁省辽阳市";
$areanames{zh}->{861327420} = "辽宁省铁岭市";
$areanames{zh}->{861327421} = "辽宁省朝阳市";
$areanames{zh}->{861327422} = "辽宁省朝阳市";
$areanames{zh}->{861327423} = "辽宁省抚顺市";
$areanames{zh}->{861327424} = "辽宁省沈阳市";
$areanames{zh}->{861327425} = "辽宁省沈阳市";
$areanames{zh}->{861327426} = "辽宁省锦州市";
$areanames{zh}->{861327427} = "辽宁省盘锦市";
$areanames{zh}->{861327428} = "辽宁省葫芦岛市";
$areanames{zh}->{861327429} = "辽宁省葫芦岛市";
$areanames{zh}->{861327430} = "吉林省长春市";
$areanames{zh}->{861327431} = "吉林省长春市";
$areanames{zh}->{861327432} = "吉林省吉林市";
$areanames{zh}->{861327433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861327434} = "吉林省四平市";
$areanames{zh}->{861327435} = "吉林省通化市";
$areanames{zh}->{861327436} = "吉林省白城市";
$areanames{zh}->{861327437} = "吉林省辽源市";
$areanames{zh}->{861327438} = "吉林省松原市";
$areanames{zh}->{861327439} = "吉林省白山市";
$areanames{zh}->{86132744} = "吉林省吉林市";
$areanames{zh}->{861327450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861327453} = "黑龙江省牡丹江市";
$areanames{zh}->{861327454} = "黑龙江省佳木斯市";
$areanames{zh}->{861327455} = "黑龙江省绥化市";
$areanames{zh}->{861327456} = "黑龙江省绥化市";
$areanames{zh}->{861327457} = "黑龙江省牡丹江市";
$areanames{zh}->{861327458} = "黑龙江省鸡西市";
$areanames{zh}->{861327459} = "黑龙江省大庆市";
$areanames{zh}->{861327460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327462} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327463} = "黑龙江省哈尔滨市";
$areanames{zh}->{861327464} = "黑龙江省七台河市";
$areanames{zh}->{861327465} = "黑龙江省大庆市";
$areanames{zh}->{861327466} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861327467} = "黑龙江省鸡西市";
$areanames{zh}->{861327468} = "黑龙江省佳木斯市";
$areanames{zh}->{861327469} = "黑龙江省双鸭山市";
$areanames{zh}->{861327470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861327471} = "内蒙古呼和浩特市";
$areanames{zh}->{861327472} = "内蒙古包头市";
$areanames{zh}->{861327473} = "内蒙古乌海市";
$areanames{zh}->{861327474} = "内蒙古兴安盟";
$areanames{zh}->{861327475} = "内蒙古通辽市";
$areanames{zh}->{861327476} = "内蒙古赤峰市";
$areanames{zh}->{861327477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861327478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861327479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861327480} = "内蒙古呼和浩特市";
$areanames{zh}->{861327481} = "内蒙古呼和浩特市";
$areanames{zh}->{861327482} = "内蒙古兴安盟";
$areanames{zh}->{861327483} = "内蒙古阿拉善盟";
$areanames{zh}->{861327484} = "内蒙古通辽市";
$areanames{zh}->{861327485} = "内蒙古通辽市";
$areanames{zh}->{861327486} = "内蒙古包头市";
$areanames{zh}->{861327487} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861327488} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861327489} = "内蒙古鄂尔多斯市";
$areanames{zh}->{86132749} = "重庆市";
$areanames{zh}->{861327500} = "福建省厦门市";
$areanames{zh}->{861327501} = "福建省福州市";
$areanames{zh}->{861327502} = "福建省厦门市";
$areanames{zh}->{861327503} = "福建省龙岩市";
$areanames{zh}->{861327504} = "福建省厦门市";
$areanames{zh}->{861327505} = "福建省泉州市";
$areanames{zh}->{861327506} = "福建省三明市";
$areanames{zh}->{861327507} = "福建省泉州市";
$areanames{zh}->{861327508} = "福建省泉州市";
$areanames{zh}->{861327509} = "福建省南平市";
$areanames{zh}->{861327510} = "江苏省无锡市";
$areanames{zh}->{861327511} = "江苏省镇江市";
$areanames{zh}->{861327512} = "江苏省镇江市";
$areanames{zh}->{861327513} = "江苏省南通市";
$areanames{zh}->{861327514} = "江苏省扬州市";
$areanames{zh}->{861327515} = "江苏省盐城市";
$areanames{zh}->{861327516} = "江苏省徐州市";
$areanames{zh}->{861327517} = "江苏省淮安市";
$areanames{zh}->{861327518} = "江苏省常州市";
$areanames{zh}->{861327519} = "江苏省常州市";
$areanames{zh}->{861327520} = "江苏省常州市";
$areanames{zh}->{861327521} = "江苏省常州市";
$areanames{zh}->{861327522} = "江苏省常州市";
$areanames{zh}->{861327523} = "江苏省常州市";
$areanames{zh}->{861327524} = "江苏省常州市";
$areanames{zh}->{861327525} = "江苏省南通市";
$areanames{zh}->{861327526} = "江苏省南通市";
$areanames{zh}->{861327527} = "江苏省南通市";
$areanames{zh}->{861327528} = "江苏省南通市";
$areanames{zh}->{861327529} = "江苏省南通市";
$areanames{zh}->{861327530} = "山东省菏泽市";
$areanames{zh}->{861327531} = "山东省济南市";
$areanames{zh}->{861327532} = "山东省青岛市";
$areanames{zh}->{861327533} = "山东省淄博市";
$areanames{zh}->{861327534} = "山东省德州市";
$areanames{zh}->{861327535} = "山东省烟台市";
$areanames{zh}->{861327536} = "山东省潍坊市";
$areanames{zh}->{861327537} = "山东省济宁市";
$areanames{zh}->{861327538} = "山东省泰安市";
$areanames{zh}->{861327539} = "山东省临沂市";
$areanames{zh}->{861327540} = "山东省菏泽市";
$areanames{zh}->{861327541} = "山东省济南市";
$areanames{zh}->{861327542} = "山东省青岛市";
$areanames{zh}->{861327543} = "山东省滨州市";
$areanames{zh}->{861327544} = "山东省德州市";
$areanames{zh}->{861327545} = "山东省烟台市";
$areanames{zh}->{861327546} = "山东省东营市";
$areanames{zh}->{861327547} = "山东省济宁市";
$areanames{zh}->{861327548} = "山东省泰安市";
$areanames{zh}->{861327549} = "山东省临沂市";
$areanames{zh}->{861327550} = "安徽省滁州市";
$areanames{zh}->{861327551} = "安徽省合肥市";
$areanames{zh}->{861327552} = "安徽省蚌埠市";
$areanames{zh}->{861327553} = "安徽省芜湖市";
$areanames{zh}->{861327554} = "安徽省淮南市";
$areanames{zh}->{861327555} = "安徽省马鞍山市";
$areanames{zh}->{861327556} = "安徽省安庆市";
$areanames{zh}->{861327557} = "安徽省宿州市";
$areanames{zh}->{861327558} = "安徽省阜阳市";
$areanames{zh}->{861327559} = "安徽省黄山市";
$areanames{zh}->{861327560} = "安徽省合肥市";
$areanames{zh}->{861327561} = "安徽省淮北市";
$areanames{zh}->{861327562} = "安徽省铜陵市";
$areanames{zh}->{861327563} = "安徽省宣城市";
$areanames{zh}->{861327564} = "安徽省六安市";
$areanames{zh}->{861327565} = "安徽省合肥市";
$areanames{zh}->{861327566} = "安徽省池州市";
$areanames{zh}->{861327567} = "安徽省亳州市";
$areanames{zh}->{861327568} = "安徽省阜阳市";
$areanames{zh}->{861327569} = "安徽省合肥市";
$areanames{zh}->{86132757} = "安徽省安庆市";
$areanames{zh}->{861327575} = "安徽省合肥市";
$areanames{zh}->{861327576} = "安徽省合肥市";
$areanames{zh}->{861327577} = "安徽省合肥市";
$areanames{zh}->{861327579} = "安徽省合肥市";
$areanames{zh}->{86132758} = "安徽省六安市";
$areanames{zh}->{861327585} = "安徽省合肥市";
$areanames{zh}->{861327586} = "安徽省合肥市";
$areanames{zh}->{861327587} = "安徽省合肥市";
$areanames{zh}->{861327589} = "安徽省合肥市";
$areanames{zh}->{861327590} = "福建省福州市";
$areanames{zh}->{861327591} = "福建省福州市";
$areanames{zh}->{861327592} = "福建省厦门市";
$areanames{zh}->{861327593} = "福建省宁德市";
$areanames{zh}->{861327594} = "福建省莆田市";
$areanames{zh}->{861327595} = "福建省泉州市";
$areanames{zh}->{861327596} = "福建省漳州市";
$areanames{zh}->{861327597} = "河南省郑州市";
$areanames{zh}->{861327598} = "福建省三明市";
$areanames{zh}->{861327599} = "福建省南平市";
$areanames{zh}->{861327600} = "福建省泉州市";
$areanames{zh}->{861327601} = "福建省福州市";
$areanames{zh}->{861327602} = "福建省厦门市";
$areanames{zh}->{861327603} = "福建省宁德市";
$areanames{zh}->{861327604} = "福建省福州市";
$areanames{zh}->{861327605} = "福建省三明市";
$areanames{zh}->{861327606} = "福建省漳州市";
$areanames{zh}->{861327607} = "福建省南平市";
$areanames{zh}->{861327608} = "福建省福州市";
$areanames{zh}->{861327609} = "福建省泉州市";
$areanames{zh}->{861327610} = "江苏省盐城市";
$areanames{zh}->{861327611} = "江苏省盐城市";
$areanames{zh}->{861327612} = "江苏省盐城市";
$areanames{zh}->{861327613} = "江苏省盐城市";
$areanames{zh}->{861327614} = "江苏省盐城市";
$areanames{zh}->{861327615} = "江苏省镇江市";
$areanames{zh}->{861327616} = "江苏省镇江市";
$areanames{zh}->{861327617} = "江苏省镇江市";
$areanames{zh}->{861327618} = "江苏省镇江市";
$areanames{zh}->{861327619} = "江苏省镇江市";
$areanames{zh}->{86132762} = "江苏省无锡市";
$areanames{zh}->{861327620} = "江苏省盐城市";
$areanames{zh}->{861327621} = "江苏省盐城市";
$areanames{zh}->{861327630} = "山东省威海市";
$areanames{zh}->{861327631} = "山东省威海市";
$areanames{zh}->{861327632} = "山东省枣庄市";
$areanames{zh}->{861327633} = "山东省日照市";
$areanames{zh}->{861327634} = "山东省莱芜市";
$areanames{zh}->{861327635} = "山东省聊城市";
$areanames{zh}->{861327636} = "山东省潍坊市";
$areanames{zh}->{861327637} = "山东省枣庄市";
$areanames{zh}->{861327638} = "山东省烟台市";
$areanames{zh}->{861327639} = "山东省青岛市";
$areanames{zh}->{861327640} = "山东省济南市";
$areanames{zh}->{861327641} = "山东省济南市";
$areanames{zh}->{861327642} = "山东省青岛市";
$areanames{zh}->{861327643} = "山东省淄博市";
$areanames{zh}->{861327644} = "山东省济南市";
$areanames{zh}->{861327645} = "山东省烟台市";
$areanames{zh}->{861327646} = "山东省潍坊市";
$areanames{zh}->{861327647} = "山东省东营市";
$areanames{zh}->{861327648} = "山东省青岛市";
$areanames{zh}->{861327649} = "山东省济南市";
$areanames{zh}->{86132765} = "江苏省扬州市";
$areanames{zh}->{861327650} = "江苏省淮安市";
$areanames{zh}->{861327651} = "江苏省淮安市";
$areanames{zh}->{861327659} = "江苏省徐州市";
$areanames{zh}->{86132766} = "江苏省南京市";
$areanames{zh}->{861327669} = "江苏省徐州市";
$areanames{zh}->{861327670} = "浙江省宁波市";
$areanames{zh}->{861327671} = "浙江省杭州市";
$areanames{zh}->{861327672} = "浙江省宁波市";
$areanames{zh}->{861327673} = "浙江省嘉兴市";
$areanames{zh}->{861327674} = "浙江省宁波市";
$areanames{zh}->{861327675} = "浙江省绍兴市";
$areanames{zh}->{861327676} = "浙江省台州市";
$areanames{zh}->{861327677} = "浙江省温州市";
$areanames{zh}->{861327678} = "浙江省宁波市";
$areanames{zh}->{861327679} = "浙江省金华市";
$areanames{zh}->{861327680} = "浙江省舟山市";
$areanames{zh}->{861327681} = "浙江省杭州市";
$areanames{zh}->{861327682} = "浙江省宁波市";
$areanames{zh}->{861327683} = "浙江省嘉兴市";
$areanames{zh}->{861327684} = "浙江省宁波市";
$areanames{zh}->{861327685} = "浙江省绍兴市";
$areanames{zh}->{861327686} = "浙江省台州市";
$areanames{zh}->{861327687} = "浙江省温州市";
$areanames{zh}->{861327688} = "浙江省丽水市";
$areanames{zh}->{861327689} = "浙江省金华市";
$areanames{zh}->{861327690} = "河南省郑州市";
$areanames{zh}->{861327691} = "福建省福州市";
$areanames{zh}->{861327692} = "福建省莆田市";
$areanames{zh}->{861327693} = "福建省龙岩市";
$areanames{zh}->{861327694} = "福建省泉州市";
$areanames{zh}->{861327695} = "福建省宁德市";
$areanames{zh}->{861327696} = "福建省厦门市";
$areanames{zh}->{861327697} = "福建省漳州市";
$areanames{zh}->{861327698} = "福建省泉州市";
$areanames{zh}->{861327699} = "福建省福州市";
$areanames{zh}->{86132770} = "湖北省武汉市";
$areanames{zh}->{861327700} = "湖北省孝感市";
$areanames{zh}->{861327701} = "湖北省孝感市";
$areanames{zh}->{861327702} = "湖北省孝感市";
$areanames{zh}->{861327710} = "湖北省襄樊市";
$areanames{zh}->{861327711} = "湖北省襄樊市";
$areanames{zh}->{861327712} = "湖北省孝感市";
$areanames{zh}->{861327713} = "湖北省黄冈市";
$areanames{zh}->{861327714} = "湖北省黄冈市";
$areanames{zh}->{861327715} = "湖北省咸宁市";
$areanames{zh}->{861327716} = "湖北省荆州市";
$areanames{zh}->{861327717} = "湖北省宜昌市";
$areanames{zh}->{861327718} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861327719} = "湖北省十堰市";
$areanames{zh}->{861327720} = "湖北省黄冈市";
$areanames{zh}->{861327721} = "湖北省黄冈市";
$areanames{zh}->{861327722} = "湖北省随州市";
$areanames{zh}->{861327723} = "湖北省宜昌市";
$areanames{zh}->{861327724} = "湖北省荆门市";
$areanames{zh}->{861327725} = "湖北省宜昌市";
$areanames{zh}->{861327726} = "湖北省十堰市";
$areanames{zh}->{861327727} = "湖北省襄樊市";
$areanames{zh}->{861327728} = "湖北省武汉市";
$areanames{zh}->{861327729} = "湖北省襄樊市";
$areanames{zh}->{86132773} = "湖北省荆州市";
$areanames{zh}->{861327739} = "湖北省宜昌市";
$areanames{zh}->{86132774} = "湖北省武汉市";
$areanames{zh}->{861327740} = "湖北省黄冈市";
$areanames{zh}->{861327741} = "湖北省黄冈市";
$areanames{zh}->{861327742} = "湖北省黄冈市";
$areanames{zh}->{861327743} = "湖北省黄冈市";
$areanames{zh}->{86132775} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861327760} = "湖北省随州市";
$areanames{zh}->{861327761} = "湖北省随州市";
$areanames{zh}->{861327762} = "湖北省随州市";
$areanames{zh}->{861327763} = "湖北省荆门市";
$areanames{zh}->{861327764} = "湖北省荆门市";
$areanames{zh}->{861327765} = "湖北省荆门市";
$areanames{zh}->{861327766} = "湖北省荆门市";
$areanames{zh}->{861327767} = "湖北省武汉市";
$areanames{zh}->{861327768} = "湖北省武汉市";
$areanames{zh}->{861327769} = "湖北省武汉市";
$areanames{zh}->{86132777} = "广西南宁市";
$areanames{zh}->{86132778} = "广西南宁市";
$areanames{zh}->{86132779} = "湖北省武汉市";
$areanames{zh}->{86132780} = "吉林省四平市";
$areanames{zh}->{861327810} = "吉林省长春市";
$areanames{zh}->{861327811} = "吉林省白山市";
$areanames{zh}->{861327812} = "吉林省四平市";
$areanames{zh}->{861327813} = "吉林省四平市";
$areanames{zh}->{861327814} = "吉林省四平市";
$areanames{zh}->{861327815} = "吉林省通化市";
$areanames{zh}->{861327816} = "吉林省白城市";
$areanames{zh}->{861327817} = "吉林省白城市";
$areanames{zh}->{861327818} = "吉林省白城市";
$areanames{zh}->{861327819} = "吉林省白城市";
$areanames{zh}->{861327820} = "吉林省吉林市";
$areanames{zh}->{861327821} = "吉林省吉林市";
$areanames{zh}->{861327822} = "吉林省吉林市";
$areanames{zh}->{861327823} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861327824} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861327825} = "吉林省通化市";
$areanames{zh}->{861327826} = "吉林省白城市";
$areanames{zh}->{861327827} = "吉林省白城市";
$areanames{zh}->{861327828} = "吉林省白城市";
$areanames{zh}->{861327829} = "吉林省白山市";
$areanames{zh}->{861327830} = "吉林省松原市";
$areanames{zh}->{861327831} = "吉林省松原市";
$areanames{zh}->{861327832} = "吉林省松原市";
$areanames{zh}->{861327833} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861327834} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861327835} = "吉林省通化市";
$areanames{zh}->{861327836} = "吉林省白城市";
$areanames{zh}->{861327837} = "吉林省辽源市";
$areanames{zh}->{861327838} = "吉林省辽源市";
$areanames{zh}->{861327839} = "吉林省辽源市";
$areanames{zh}->{861327840} = "吉林省四平市";
$areanames{zh}->{861327841} = "吉林省四平市";
$areanames{zh}->{861327842} = "吉林省四平市";
$areanames{zh}->{861327843} = "吉林省四平市";
$areanames{zh}->{861327844} = "吉林省四平市";
$areanames{zh}->{861327845} = "吉林省通化市";
$areanames{zh}->{861327846} = "吉林省白城市";
$areanames{zh}->{861327847} = "吉林省辽源市";
$areanames{zh}->{861327848} = "吉林省辽源市";
$areanames{zh}->{861327849} = "吉林省辽源市";
$areanames{zh}->{861327850} = "吉林省四平市";
$areanames{zh}->{861327851} = "吉林省四平市";
$areanames{zh}->{861327852} = "吉林省四平市";
$areanames{zh}->{861327853} = "吉林省四平市";
$areanames{zh}->{861327854} = "吉林省四平市";
$areanames{zh}->{861327855} = "吉林省通化市";
$areanames{zh}->{861327856} = "吉林省白城市";
$areanames{zh}->{861327857} = "吉林省辽源市";
$areanames{zh}->{861327858} = "吉林省松原市";
$areanames{zh}->{861327859} = "吉林省松原市";
$areanames{zh}->{86132786} = "云南省昭通市";
$areanames{zh}->{861327860} = "云南省保山市";
$areanames{zh}->{861327861} = "云南省保山市";
$areanames{zh}->{861327862} = "云南省保山市";
$areanames{zh}->{86132787} = "云南省曲靖市";
$areanames{zh}->{861327870} = "云南省昭通市";
$areanames{zh}->{861327871} = "云南省昆明市";
$areanames{zh}->{861327872} = "云南省昆明市";
$areanames{zh}->{86132788} = "湖南省长沙市";
$areanames{zh}->{861327880} = "湖南省岳阳市";
$areanames{zh}->{861327881} = "湖南省永州市";
$areanames{zh}->{861327882} = "湖南省湘潭市";
$areanames{zh}->{861327883} = "湖南省常德市";
$areanames{zh}->{86132789} = "海南省海口市";
$areanames{zh}->{861327900} = "新疆昌吉回族自治州";
$areanames{zh}->{861327901} = "新疆喀什地区";
$areanames{zh}->{861327902} = "新疆哈密地区";
$areanames{zh}->{861327903} = "新疆和田地区";
$areanames{zh}->{861327904} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861327905} = "新疆昌吉回族自治州";
$areanames{zh}->{861327906} = "新疆阿克苏地区";
$areanames{zh}->{861327907} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861327908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861327909} = "新疆阿克苏地区";
$areanames{zh}->{861327910} = "陕西省咸阳市";
$areanames{zh}->{861327911} = "陕西省延安市";
$areanames{zh}->{861327912} = "陕西省榆林市";
$areanames{zh}->{861327913} = "陕西省渭南市";
$areanames{zh}->{861327914} = "陕西省渭南市";
$areanames{zh}->{861327915} = "陕西省渭南市";
$areanames{zh}->{861327916} = "陕西省汉中市";
$areanames{zh}->{861327917} = "陕西省宝鸡市";
$areanames{zh}->{861327918} = "陕西省宝鸡市";
$areanames{zh}->{861327919} = "陕西省宝鸡市";
$areanames{zh}->{86132792} = "陕西省西安市";
$areanames{zh}->{86132793} = "陕西省西安市";
$areanames{zh}->{86132794} = "陕西省西安市";
$areanames{zh}->{86132795} = "陕西省咸阳市";
$areanames{zh}->{86132796} = "陕西省渭南市";
$areanames{zh}->{861327970} = "新疆喀什地区";
$areanames{zh}->{861327971} = "新疆喀什地区";
$areanames{zh}->{861327972} = "新疆喀什地区";
$areanames{zh}->{861327973} = "新疆喀什地区";
$areanames{zh}->{861327974} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861327975} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861327976} = "新疆阿克苏地区";
$areanames{zh}->{861327977} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861327978} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861327979} = "新疆阿克苏地区";
$areanames{zh}->{86132798} = "新疆喀什地区";
$areanames{zh}->{861327980} = "新疆阿克苏地区";
$areanames{zh}->{861327983} = "新疆乌鲁木齐市";
$areanames{zh}->{861327990} = "新疆喀什地区";
$areanames{zh}->{861327991} = "新疆乌鲁木齐市";
$areanames{zh}->{861327992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861327993} = "新疆石河子市";
$areanames{zh}->{861327994} = "新疆昌吉回族自治州";
$areanames{zh}->{861327995} = "新疆吐鲁番地区";
$areanames{zh}->{861327996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861327997} = "新疆阿克苏地区";
$areanames{zh}->{861327998} = "新疆喀什地区";
$areanames{zh}->{861327999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86132800} = "山东省济宁市";
$areanames{zh}->{861328000} = "山东省济南市";
$areanames{zh}->{861328001} = "山东省济南市";
$areanames{zh}->{861328002} = "山东省济南市";
$areanames{zh}->{86132801} = "山东省潍坊市";
$areanames{zh}->{86132802} = "山东省枣庄市";
$areanames{zh}->{86132803} = "山东省东营市";
$areanames{zh}->{861328034} = "山东省潍坊市";
$areanames{zh}->{861328040} = "山东省滨州市";
$areanames{zh}->{861328041} = "山东省滨州市";
$areanames{zh}->{861328042} = "山东省临沂市";
$areanames{zh}->{861328043} = "山东省临沂市";
$areanames{zh}->{861328044} = "山东省日照市";
$areanames{zh}->{861328045} = "山东省聊城市";
$areanames{zh}->{861328046} = "山东省聊城市";
$areanames{zh}->{861328047} = "山东省枣庄市";
$areanames{zh}->{861328048} = "山东省枣庄市";
$areanames{zh}->{861328049} = "山东省济宁市";
$areanames{zh}->{86132805} = "山东省临沂市";
$areanames{zh}->{86132806} = "山东省淄博市";
$areanames{zh}->{86132807} = "山东省潍坊市";
$areanames{zh}->{86132808} = "山东省青岛市";
$areanames{zh}->{86132809} = "山东省烟台市";
$areanames{zh}->{86132810} = "四川省成都市";
$areanames{zh}->{86132811} = "四川省成都市";
$areanames{zh}->{86132812} = "四川省成都市";
$areanames{zh}->{861328130} = "四川省乐山市";
$areanames{zh}->{861328131} = "四川省乐山市";
$areanames{zh}->{861328132} = "四川省乐山市";
$areanames{zh}->{861328133} = "四川省乐山市";
$areanames{zh}->{861328134} = "四川省乐山市";
$areanames{zh}->{861328135} = "四川省德阳市";
$areanames{zh}->{861328136} = "四川省德阳市";
$areanames{zh}->{861328137} = "四川省德阳市";
$areanames{zh}->{861328138} = "四川省德阳市";
$areanames{zh}->{861328139} = "四川省德阳市";
$areanames{zh}->{861328140} = "四川省绵阳市";
$areanames{zh}->{861328141} = "陕西省渭南市";
$areanames{zh}->{861328142} = "四川省达州市";
$areanames{zh}->{861328143} = "四川省南充市";
$areanames{zh}->{861328144} = "四川省乐山市";
$areanames{zh}->{861328145} = "四川省成都市";
$areanames{zh}->{861328146} = "四川省成都市";
$areanames{zh}->{861328147} = "四川省成都市";
$areanames{zh}->{861328148} = "四川省成都市";
$areanames{zh}->{861328149} = "四川省成都市";
$areanames{zh}->{86132815} = "四川省绵阳市";
$areanames{zh}->{86132816} = "四川省泸州市";
$areanames{zh}->{861328168} = "四川省广安市";
$areanames{zh}->{861328169} = "四川省雅安市";
$areanames{zh}->{86132817} = "四川省达州市";
$areanames{zh}->{861328176} = "四川省广安市";
$areanames{zh}->{861328177} = "四川省广安市";
$areanames{zh}->{861328178} = "四川省遂宁市";
$areanames{zh}->{861328179} = "四川省遂宁市";
$areanames{zh}->{86132818} = "四川省成都市";
$areanames{zh}->{86132819} = "四川省南充市";
$areanames{zh}->{861328196} = "四川省宜宾市";
$areanames{zh}->{861328197} = "四川省宜宾市";
$areanames{zh}->{861328198} = "四川省宜宾市";
$areanames{zh}->{861328199} = "四川省雅安市";
$areanames{zh}->{861328200} = "浙江省杭州市";
$areanames{zh}->{861328201} = "浙江省杭州市";
$areanames{zh}->{861328202} = "浙江省杭州市";
$areanames{zh}->{861328203} = "浙江省杭州市";
$areanames{zh}->{861328204} = "浙江省温州市";
$areanames{zh}->{861328205} = "浙江省衢州市";
$areanames{zh}->{861328206} = "浙江省衢州市";
$areanames{zh}->{861328207} = "浙江省衢州市";
$areanames{zh}->{861328208} = "浙江省衢州市";
$areanames{zh}->{861328209} = "浙江省衢州市";
$areanames{zh}->{86132821} = "浙江省杭州市";
$areanames{zh}->{86132822} = "浙江省宁波市";
$areanames{zh}->{861328230} = "浙江省嘉兴市";
$areanames{zh}->{861328231} = "浙江省嘉兴市";
$areanames{zh}->{861328232} = "浙江省嘉兴市";
$areanames{zh}->{861328233} = "浙江省嘉兴市";
$areanames{zh}->{861328234} = "浙江省嘉兴市";
$areanames{zh}->{861328235} = "浙江省舟山市";
$areanames{zh}->{861328236} = "浙江省舟山市";
$areanames{zh}->{861328237} = "浙江省舟山市";
$areanames{zh}->{861328238} = "浙江省温州市";
$areanames{zh}->{861328239} = "浙江省舟山市";
$areanames{zh}->{86132824} = "浙江省温州市";
$areanames{zh}->{861328240} = "浙江省杭州市";
$areanames{zh}->{861328241} = "浙江省杭州市";
$areanames{zh}->{861328242} = "浙江省杭州市";
$areanames{zh}->{861328243} = "浙江省杭州市";
$areanames{zh}->{86132825} = "浙江省丽水市";
$areanames{zh}->{861328250} = "浙江省绍兴市";
$areanames{zh}->{861328251} = "浙江省金华市";
$areanames{zh}->{861328254} = "浙江省温州市";
$areanames{zh}->{86132826} = "浙江省台州市";
$areanames{zh}->{86132827} = "浙江省温州市";
$areanames{zh}->{861328280} = "浙江省杭州市";
$areanames{zh}->{861328281} = "浙江省杭州市";
$areanames{zh}->{861328282} = "浙江省杭州市";
$areanames{zh}->{861328283} = "浙江省杭州市";
$areanames{zh}->{861328284} = "浙江省杭州市";
$areanames{zh}->{861328285} = "浙江省绍兴市";
$areanames{zh}->{861328286} = "浙江省台州市";
$areanames{zh}->{861328287} = "浙江省温州市";
$areanames{zh}->{861328288} = "浙江省温州市";
$areanames{zh}->{861328289} = "浙江省金华市";
$areanames{zh}->{86132829} = "浙江省金华市";
$areanames{zh}->{861328300} = "河南省周口市";
$areanames{zh}->{861328301} = "河南省周口市";
$areanames{zh}->{861328302} = "河南省濮阳市";
$areanames{zh}->{861328303} = "河南省濮阳市";
$areanames{zh}->{861328304} = "河南省开封市";
$areanames{zh}->{861328305} = "河南省平顶山市";
$areanames{zh}->{861328306} = "河南省平顶山市";
$areanames{zh}->{861328307} = "河南省信阳市";
$areanames{zh}->{861328308} = "河南省驻马店市";
$areanames{zh}->{861328309} = "河南省驻马店市";
$areanames{zh}->{86132831} = "河北省邯郸市";
$areanames{zh}->{86132832} = "河北省沧州市";
$areanames{zh}->{861328330} = "河北省张家口市";
$areanames{zh}->{861328331} = "河北省张家口市";
$areanames{zh}->{861328332} = "河北省张家口市";
$areanames{zh}->{861328333} = "河北省张家口市";
$areanames{zh}->{861328334} = "河北省张家口市";
$areanames{zh}->{861328335} = "河北省承德市";
$areanames{zh}->{861328336} = "河北省承德市";
$areanames{zh}->{861328337} = "河北省承德市";
$areanames{zh}->{861328338} = "河北省承德市";
$areanames{zh}->{861328339} = "河北省承德市";
$areanames{zh}->{861328340} = "河北省邯郸市";
$areanames{zh}->{861328341} = "河北省邯郸市";
$areanames{zh}->{861328342} = "河北省邯郸市";
$areanames{zh}->{861328343} = "河北省邯郸市";
$areanames{zh}->{861328344} = "河北省邯郸市";
$areanames{zh}->{861328345} = "河北省秦皇岛市";
$areanames{zh}->{861328346} = "河北省秦皇岛市";
$areanames{zh}->{861328347} = "河北省秦皇岛市";
$areanames{zh}->{861328348} = "河北省秦皇岛市";
$areanames{zh}->{861328349} = "河北省秦皇岛市";
$areanames{zh}->{861328350} = "山西省忻州市";
$areanames{zh}->{861328351} = "山西省太原市";
$areanames{zh}->{861328352} = "山西省大同市";
$areanames{zh}->{861328353} = "山西省阳泉市";
$areanames{zh}->{861328354} = "山西省晋中市";
$areanames{zh}->{861328355} = "山西省长治市";
$areanames{zh}->{861328356} = "山西省晋城市";
$areanames{zh}->{861328357} = "山西省临汾市";
$areanames{zh}->{861328358} = "山西省吕梁市";
$areanames{zh}->{861328359} = "山西省运城市";
$areanames{zh}->{861328360} = "山西省忻州市";
$areanames{zh}->{861328361} = "山西省太原市";
$areanames{zh}->{861328362} = "山西省太原市";
$areanames{zh}->{861328363} = "山西省阳泉市";
$areanames{zh}->{861328364} = "山西省阳泉市";
$areanames{zh}->{861328365} = "山西省忻州市";
$areanames{zh}->{861328366} = "山西省晋中市";
$areanames{zh}->{861328367} = "山西省吕梁市";
$areanames{zh}->{861328368} = "山西省大同市";
$areanames{zh}->{861328369} = "山西省朔州市";
$areanames{zh}->{861328370} = "河南省商丘市";
$areanames{zh}->{861328371} = "河南省郑州市";
$areanames{zh}->{861328372} = "河南省新乡市";
$areanames{zh}->{861328373} = "河南省新乡市";
$areanames{zh}->{861328374} = "河南省许昌市";
$areanames{zh}->{861328375} = "河南省平顶山市";
$areanames{zh}->{861328376} = "河南省信阳市";
$areanames{zh}->{861328377} = "河南省南阳市";
$areanames{zh}->{861328378} = "河南省开封市";
$areanames{zh}->{861328379} = "河南省南阳市";
$areanames{zh}->{86132838} = "河南省郑州市";
$areanames{zh}->{861328390} = "河南省焦作市";
$areanames{zh}->{861328391} = "河南省焦作市";
$areanames{zh}->{861328392} = "河南省鹤壁市";
$areanames{zh}->{861328393} = "河南省濮阳市";
$areanames{zh}->{861328394} = "河南省周口市";
$areanames{zh}->{861328395} = "河南省漯河市";
$areanames{zh}->{861328396} = "河南省驻马店市";
$areanames{zh}->{861328397} = "河南省信阳市";
$areanames{zh}->{861328398} = "河南省三门峡市";
$areanames{zh}->{861328399} = "河南省驻马店市";
$areanames{zh}->{861328400} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328401} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328402} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861328403} = "黑龙江省牡丹江市";
$areanames{zh}->{861328404} = "黑龙江省绥化市";
$areanames{zh}->{861328405} = "黑龙江省绥化市";
$areanames{zh}->{861328406} = "黑龙江省黑河市";
$areanames{zh}->{861328407} = "黑龙江省佳木斯市";
$areanames{zh}->{861328408} = "黑龙江省鸡西市";
$areanames{zh}->{861328409} = "黑龙江省大庆市";
$areanames{zh}->{861328410} = "辽宁省铁岭市";
$areanames{zh}->{861328411} = "辽宁省大连市";
$areanames{zh}->{861328412} = "辽宁省鞍山市";
$areanames{zh}->{861328413} = "辽宁省抚顺市";
$areanames{zh}->{861328414} = "辽宁省本溪市";
$areanames{zh}->{861328415} = "辽宁省丹东市";
$areanames{zh}->{861328416} = "辽宁省锦州市";
$areanames{zh}->{861328417} = "辽宁省营口市";
$areanames{zh}->{861328418} = "辽宁省阜新市";
$areanames{zh}->{861328419} = "辽宁省辽阳市";
$areanames{zh}->{861328420} = "辽宁省鞍山市";
$areanames{zh}->{861328421} = "辽宁省朝阳市";
$areanames{zh}->{861328422} = "辽宁省大连市";
$areanames{zh}->{861328423} = "辽宁省大连市";
$areanames{zh}->{861328424} = "辽宁省沈阳市";
$areanames{zh}->{861328425} = "辽宁省沈阳市";
$areanames{zh}->{861328426} = "辽宁省沈阳市";
$areanames{zh}->{861328427} = "辽宁省盘锦市";
$areanames{zh}->{861328428} = "辽宁省沈阳市";
$areanames{zh}->{861328429} = "辽宁省葫芦岛市";
$areanames{zh}->{86132843} = "河北省保定市";
$areanames{zh}->{86132844} = "河北省石家庄市";
$areanames{zh}->{861328450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861328453} = "黑龙江省牡丹江市";
$areanames{zh}->{861328454} = "黑龙江省佳木斯市";
$areanames{zh}->{861328455} = "黑龙江省绥化市";
$areanames{zh}->{861328456} = "黑龙江省黑河市";
$areanames{zh}->{861328457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861328458} = "黑龙江省伊春市";
$areanames{zh}->{861328459} = "黑龙江省大庆市";
$areanames{zh}->{861328460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328462} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328463} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328464} = "黑龙江省七台河市";
$areanames{zh}->{861328465} = "黑龙江省佳木斯市";
$areanames{zh}->{861328466} = "黑龙江省大庆市";
$areanames{zh}->{861328467} = "黑龙江省鸡西市";
$areanames{zh}->{861328468} = "黑龙江省鹤岗市";
$areanames{zh}->{861328469} = "黑龙江省双鸭山市";
$areanames{zh}->{861328470} = "内蒙古包头市";
$areanames{zh}->{861328471} = "内蒙古包头市";
$areanames{zh}->{861328472} = "内蒙古包头市";
$areanames{zh}->{861328473} = "内蒙古乌海市";
$areanames{zh}->{861328474} = "内蒙古兴安盟";
$areanames{zh}->{861328475} = "内蒙古通辽市";
$areanames{zh}->{861328476} = "内蒙古赤峰市";
$areanames{zh}->{861328477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861328478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861328479} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861328480} = "内蒙古包头市";
$areanames{zh}->{861328481} = "内蒙古兴安盟";
$areanames{zh}->{861328482} = "内蒙古兴安盟";
$areanames{zh}->{861328483} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861328484} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861328485} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861328486} = "内蒙古通辽市";
$areanames{zh}->{861328487} = "内蒙古通辽市";
$areanames{zh}->{861328488} = "内蒙古通辽市";
$areanames{zh}->{861328489} = "内蒙古通辽市";
$areanames{zh}->{861328490} = "黑龙江省大庆市";
$areanames{zh}->{861328491} = "黑龙江省佳木斯市";
$areanames{zh}->{861328492} = "黑龙江省七台河市";
$areanames{zh}->{861328493} = "黑龙江省鹤岗市";
$areanames{zh}->{861328494} = "黑龙江省双鸭山市";
$areanames{zh}->{861328495} = "黑龙江省绥化市";
$areanames{zh}->{861328496} = "黑龙江省牡丹江市";
$areanames{zh}->{861328497} = "黑龙江省鸡西市";
$areanames{zh}->{861328498} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861328499} = "黑龙江省哈尔滨市";
$areanames{zh}->{861328500} = "福建省福州市";
$areanames{zh}->{861328501} = "福建省泉州市";
$areanames{zh}->{861328502} = "福建省福州市";
$areanames{zh}->{861328503} = "福建省泉州市";
$areanames{zh}->{861328504} = "福建省泉州市";
$areanames{zh}->{861328505} = "福建省龙岩市";
$areanames{zh}->{861328506} = "福建省南平市";
$areanames{zh}->{861328507} = "河南省郑州市";
$areanames{zh}->{861328508} = "福建省漳州市";
$areanames{zh}->{861328509} = "福建省莆田市";
$areanames{zh}->{86132851} = "江苏省苏州市";
$areanames{zh}->{86132852} = "江苏省泰州市";
$areanames{zh}->{861328527} = "江苏省宿迁市";
$areanames{zh}->{861328528} = "江苏省宿迁市";
$areanames{zh}->{861328529} = "江苏省宿迁市";
$areanames{zh}->{861328530} = "山东省菏泽市";
$areanames{zh}->{861328531} = "山东省济南市";
$areanames{zh}->{861328532} = "山东省青岛市";
$areanames{zh}->{861328533} = "山东省淄博市";
$areanames{zh}->{861328534} = "山东省德州市";
$areanames{zh}->{861328535} = "山东省烟台市";
$areanames{zh}->{861328536} = "山东省潍坊市";
$areanames{zh}->{861328537} = "山东省济宁市";
$areanames{zh}->{861328538} = "山东省泰安市";
$areanames{zh}->{861328539} = "山东省临沂市";
$areanames{zh}->{861328540} = "山东省菏泽市";
$areanames{zh}->{861328541} = "山东省济南市";
$areanames{zh}->{861328542} = "山东省青岛市";
$areanames{zh}->{861328543} = "山东省滨州市";
$areanames{zh}->{861328544} = "山东省德州市";
$areanames{zh}->{861328545} = "山东省烟台市";
$areanames{zh}->{861328546} = "山东省东营市";
$areanames{zh}->{861328547} = "山东省济宁市";
$areanames{zh}->{861328548} = "山东省泰安市";
$areanames{zh}->{861328549} = "山东省临沂市";
$areanames{zh}->{861328550} = "安徽省滁州市";
$areanames{zh}->{861328551} = "安徽省合肥市";
$areanames{zh}->{861328552} = "安徽省蚌埠市";
$areanames{zh}->{861328553} = "安徽省芜湖市";
$areanames{zh}->{861328554} = "安徽省淮南市";
$areanames{zh}->{861328555} = "安徽省马鞍山市";
$areanames{zh}->{861328556} = "安徽省安庆市";
$areanames{zh}->{861328557} = "安徽省宿州市";
$areanames{zh}->{861328558} = "安徽省阜阳市";
$areanames{zh}->{861328559} = "安徽省黄山市";
$areanames{zh}->{861328560} = "安徽省合肥市";
$areanames{zh}->{861328561} = "安徽省淮北市";
$areanames{zh}->{861328562} = "安徽省铜陵市";
$areanames{zh}->{861328563} = "安徽省宣城市";
$areanames{zh}->{861328564} = "安徽省六安市";
$areanames{zh}->{861328565} = "安徽省合肥市";
$areanames{zh}->{861328566} = "安徽省宿州市";
$areanames{zh}->{861328567} = "安徽省亳州市";
$areanames{zh}->{861328568} = "安徽省亳州市";
$areanames{zh}->{861328569} = "安徽省合肥市";
$areanames{zh}->{861328570} = "浙江省衢州市";
$areanames{zh}->{861328571} = "浙江省杭州市";
$areanames{zh}->{861328572} = "浙江省湖州市";
$areanames{zh}->{861328573} = "浙江省嘉兴市";
$areanames{zh}->{861328574} = "浙江省宁波市";
$areanames{zh}->{861328575} = "浙江省绍兴市";
$areanames{zh}->{861328576} = "浙江省台州市";
$areanames{zh}->{861328577} = "浙江省温州市";
$areanames{zh}->{861328578} = "浙江省丽水市";
$areanames{zh}->{861328579} = "浙江省金华市";
$areanames{zh}->{861328580} = "浙江省舟山市";
$areanames{zh}->{861328581} = "浙江省杭州市";
$areanames{zh}->{861328582} = "浙江省湖州市";
$areanames{zh}->{861328583} = "浙江省嘉兴市";
$areanames{zh}->{861328584} = "浙江省宁波市";
$areanames{zh}->{861328585} = "浙江省绍兴市";
$areanames{zh}->{861328586} = "浙江省台州市";
$areanames{zh}->{861328587} = "浙江省温州市";
$areanames{zh}->{861328588} = "浙江省丽水市";
$areanames{zh}->{861328589} = "浙江省金华市";
$areanames{zh}->{861328590} = "福建省龙岩市";
$areanames{zh}->{861328591} = "福建省福州市";
$areanames{zh}->{861328592} = "福建省厦门市";
$areanames{zh}->{861328593} = "福建省宁德市";
$areanames{zh}->{861328594} = "福建省福州市";
$areanames{zh}->{861328595} = "福建省泉州市";
$areanames{zh}->{861328596} = "福建省三明市";
$areanames{zh}->{861328597} = "福建省厦门市";
$areanames{zh}->{861328598} = "福建省福州市";
$areanames{zh}->{861328599} = "福建省泉州市";
$areanames{zh}->{86132860} = "广东省珠海市";
$areanames{zh}->{861328609} = "河北省邢台市";
$areanames{zh}->{86132861} = "广东省江门市";
$areanames{zh}->{86132862} = "广东省惠州市";
$areanames{zh}->{86132863} = "广东省中山市";
$areanames{zh}->{86132864} = "广东省汕头市";
$areanames{zh}->{861328650} = "广东省肇庆市";
$areanames{zh}->{861328651} = "广东省肇庆市";
$areanames{zh}->{861328652} = "广东省肇庆市";
$areanames{zh}->{861328653} = "广东省肇庆市";
$areanames{zh}->{861328654} = "河北省邯郸市";
$areanames{zh}->{861328655} = "广东省肇庆市";
$areanames{zh}->{861328656} = "广东省清远市";
$areanames{zh}->{861328657} = "广东省清远市";
$areanames{zh}->{861328658} = "河北省保定市";
$areanames{zh}->{861328659} = "广东省清远市";
$areanames{zh}->{861328660} = "广东省江门市";
$areanames{zh}->{861328661} = "广东省江门市";
$areanames{zh}->{861328662} = "广东省江门市";
$areanames{zh}->{861328663} = "广东省江门市";
$areanames{zh}->{861328664} = "河北省邢台市";
$areanames{zh}->{861328665} = "广东省深圳市";
$areanames{zh}->{861328666} = "广东省深圳市";
$areanames{zh}->{861328667} = "广东省深圳市";
$areanames{zh}->{861328668} = "广东省深圳市";
$areanames{zh}->{861328669} = "广东省深圳市";
$areanames{zh}->{861328670} = "广东省河源市";
$areanames{zh}->{861328671} = "广东省河源市";
$areanames{zh}->{861328672} = "广东省河源市";
$areanames{zh}->{861328673} = "广东省河源市";
$areanames{zh}->{861328674} = "广东省河源市";
$areanames{zh}->{861328675} = "广东省梅州市";
$areanames{zh}->{861328676} = "广东省梅州市";
$areanames{zh}->{861328677} = "广东省梅州市";
$areanames{zh}->{861328678} = "广东省梅州市";
$areanames{zh}->{861328679} = "广东省梅州市";
$areanames{zh}->{86132868} = "广东省广州市";
$areanames{zh}->{861328690} = "广东省中山市";
$areanames{zh}->{861328691} = "广东省中山市";
$areanames{zh}->{861328692} = "广东省中山市";
$areanames{zh}->{861328693} = "广东省中山市";
$areanames{zh}->{861328694} = "广东省中山市";
$areanames{zh}->{861328695} = "广东省湛江市";
$areanames{zh}->{861328696} = "广东省湛江市";
$areanames{zh}->{861328697} = "广东省湛江市";
$areanames{zh}->{861328698} = "广东省湛江市";
$areanames{zh}->{861328699} = "广东省湛江市";
$areanames{zh}->{86132870} = "山东省淄博市";
$areanames{zh}->{861328704} = "山东省聊城市";
$areanames{zh}->{861328705} = "山东省菏泽市";
$areanames{zh}->{86132871} = "山东省临沂市";
$areanames{zh}->{861328710} = "山东省莱芜市";
$areanames{zh}->{861328711} = "山东省莱芜市";
$areanames{zh}->{86132872} = "山东省济宁市";
$areanames{zh}->{86132873} = "山东省东营市";
$areanames{zh}->{861328734} = "山东省泰安市";
$areanames{zh}->{861328739} = "山东省滨州市";
$areanames{zh}->{861328740} = "山东省日照市";
$areanames{zh}->{861328741} = "山东省日照市";
$areanames{zh}->{861328742} = "山东省烟台市";
$areanames{zh}->{861328743} = "山东省烟台市";
$areanames{zh}->{861328744} = "山东省烟台市";
$areanames{zh}->{861328745} = "山东省烟台市";
$areanames{zh}->{861328746} = "山东省烟台市";
$areanames{zh}->{861328747} = "山东省潍坊市";
$areanames{zh}->{861328748} = "山东省潍坊市";
$areanames{zh}->{861328749} = "山东省菏泽市";
$areanames{zh}->{86132875} = "山东省聊城市";
$areanames{zh}->{861328760} = "山东省泰安市";
$areanames{zh}->{861328761} = "山东省泰安市";
$areanames{zh}->{861328762} = "山东省泰安市";
$areanames{zh}->{861328763} = "山东省泰安市";
$areanames{zh}->{861328764} = "山东省泰安市";
$areanames{zh}->{861328765} = "山东省潍坊市";
$areanames{zh}->{861328766} = "山东省潍坊市";
$areanames{zh}->{861328767} = "山东省潍坊市";
$areanames{zh}->{861328768} = "山东省潍坊市";
$areanames{zh}->{861328769} = "山东省潍坊市";
$areanames{zh}->{86132877} = "山东省济南市";
$areanames{zh}->{86132878} = "山东省威海市";
$areanames{zh}->{861328788} = "山东省淄博市";
$areanames{zh}->{861328789} = "山东省淄博市";
$areanames{zh}->{861328790} = "山东省菏泽市";
$areanames{zh}->{861328791} = "山东省菏泽市";
$areanames{zh}->{861328792} = "山东省菏泽市";
$areanames{zh}->{861328793} = "山东省菏泽市";
$areanames{zh}->{861328794} = "山东省菏泽市";
$areanames{zh}->{861328795} = "山东省烟台市";
$areanames{zh}->{861328796} = "山东省烟台市";
$areanames{zh}->{861328797} = "山东省烟台市";
$areanames{zh}->{861328798} = "山东省烟台市";
$areanames{zh}->{861328799} = "山东省烟台市";
$areanames{zh}->{86132880} = "广东省汕头市";
$areanames{zh}->{861328810} = "广东省揭阳市";
$areanames{zh}->{861328811} = "广东省揭阳市";
$areanames{zh}->{861328812} = "广东省韶关市";
$areanames{zh}->{861328813} = "广东省韶关市";
$areanames{zh}->{861328814} = "广东省惠州市";
$areanames{zh}->{861328815} = "广东省惠州市";
$areanames{zh}->{861328816} = "广东省惠州市";
$areanames{zh}->{861328817} = "广东省惠州市";
$areanames{zh}->{861328818} = "广东省惠州市";
$areanames{zh}->{861328819} = "广东省阳江市";
$areanames{zh}->{86132882} = "广东省佛山市";
$areanames{zh}->{86132883} = "广东省佛山市";
$areanames{zh}->{861328832} = "河北省廊坊市";
$areanames{zh}->{861328840} = "广东省佛山市";
$areanames{zh}->{861328841} = "广东省佛山市";
$areanames{zh}->{861328842} = "广东省佛山市";
$areanames{zh}->{861328843} = "广东省佛山市";
$areanames{zh}->{861328844} = "广东省佛山市";
$areanames{zh}->{861328845} = "广东省广州市";
$areanames{zh}->{861328846} = "广东省广州市";
$areanames{zh}->{861328847} = "广东省广州市";
$areanames{zh}->{861328848} = "广东省广州市";
$areanames{zh}->{861328849} = "广东省广州市";
$areanames{zh}->{86132885} = "广东省揭阳市";
$areanames{zh}->{86132886} = "广东省广州市";
$areanames{zh}->{861328870} = "广东省云浮市";
$areanames{zh}->{861328871} = "河北省石家庄市";
$areanames{zh}->{861328872} = "广东省云浮市";
$areanames{zh}->{861328873} = "广东省云浮市";
$areanames{zh}->{861328874} = "河北省石家庄市";
$areanames{zh}->{861328875} = "广东省潮州市";
$areanames{zh}->{861328876} = "广东省潮州市";
$areanames{zh}->{861328877} = "广东省潮州市";
$areanames{zh}->{861328878} = "广东省潮州市";
$areanames{zh}->{861328879} = "河北省邯郸市";
$areanames{zh}->{861328880} = "广东省广州市";
$areanames{zh}->{861328881} = "广东省广州市";
$areanames{zh}->{861328882} = "广东省广州市";
$areanames{zh}->{861328883} = "广东省广州市";
$areanames{zh}->{861328884} = "广东省广州市";
$areanames{zh}->{861328885} = "广东省东莞市";
$areanames{zh}->{861328886} = "广东省东莞市";
$areanames{zh}->{861328887} = "河北省廊坊市";
$areanames{zh}->{861328888} = "广东省东莞市";
$areanames{zh}->{861328889} = "广东省东莞市";
$areanames{zh}->{861328890} = "广东省清远市";
$areanames{zh}->{861328891} = "广东省清远市";
$areanames{zh}->{861328892} = "广东省清远市";
$areanames{zh}->{861328893} = "河北省保定市";
$areanames{zh}->{861328894} = "广东省韶关市";
$areanames{zh}->{861328895} = "广东省茂名市";
$areanames{zh}->{861328896} = "广东省茂名市";
$areanames{zh}->{861328897} = "广东省茂名市";
$areanames{zh}->{861328898} = "广东省茂名市";
$areanames{zh}->{861328899} = "广东省茂名市";
$areanames{zh}->{861328900} = "新疆昌吉回族自治州";
$areanames{zh}->{861328901} = "新疆和田地区";
$areanames{zh}->{861328902} = "新疆哈密地区";
$areanames{zh}->{861328903} = "新疆和田地区";
$areanames{zh}->{861328904} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861328905} = "新疆昌吉回族自治州";
$areanames{zh}->{861328906} = "新疆阿勒泰地区";
$areanames{zh}->{861328907} = "新疆和田地区";
$areanames{zh}->{861328908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861328909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861328910} = "陕西省咸阳市";
$areanames{zh}->{861328911} = "陕西省延安市";
$areanames{zh}->{861328912} = "陕西省榆林市";
$areanames{zh}->{861328913} = "陕西省渭南市";
$areanames{zh}->{861328914} = "陕西省商洛市";
$areanames{zh}->{861328915} = "陕西省安康市";
$areanames{zh}->{861328916} = "陕西省汉中市";
$areanames{zh}->{861328917} = "陕西省宝鸡市";
$areanames{zh}->{861328918} = "陕西省宝鸡市";
$areanames{zh}->{861328919} = "陕西省宝鸡市";
$areanames{zh}->{86132892} = "陕西省西安市";
$areanames{zh}->{86132893} = "陕西省西安市";
$areanames{zh}->{861328940} = "陕西省咸阳市";
$areanames{zh}->{861328941} = "陕西省咸阳市";
$areanames{zh}->{861328942} = "陕西省渭南市";
$areanames{zh}->{861328943} = "陕西省宝鸡市";
$areanames{zh}->{861328944} = "陕西省汉中市";
$areanames{zh}->{861328945} = "陕西省汉中市";
$areanames{zh}->{861328946} = "陕西省延安市";
$areanames{zh}->{861328947} = "陕西省榆林市";
$areanames{zh}->{861328948} = "陕西省榆林市";
$areanames{zh}->{861328949} = "陕西省榆林市";
$areanames{zh}->{861328950} = "宁夏银川市";
$areanames{zh}->{861328951} = "宁夏银川市";
$areanames{zh}->{861328952} = "宁夏石嘴山市";
$areanames{zh}->{861328953} = "宁夏吴忠市";
$areanames{zh}->{861328954} = "宁夏固原市";
$areanames{zh}->{861328955} = "宁夏中卫市";
$areanames{zh}->{861328956} = "宁夏吴忠市";
$areanames{zh}->{861328957} = "宁夏中卫市";
$areanames{zh}->{861328958} = "宁夏银川市";
$areanames{zh}->{861328959} = "宁夏固原市";
$areanames{zh}->{86132896} = "陕西省延安市";
$areanames{zh}->{861328960} = "陕西省汉中市";
$areanames{zh}->{861328961} = "陕西省汉中市";
$areanames{zh}->{861328962} = "陕西省汉中市";
$areanames{zh}->{86132897} = "陕西省榆林市";
$areanames{zh}->{86132898} = "陕西省西安市";
$areanames{zh}->{861328990} = "新疆克拉玛依市";
$areanames{zh}->{861328991} = "新疆乌鲁木齐市";
$areanames{zh}->{861328992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861328993} = "新疆石河子市";
$areanames{zh}->{861328994} = "新疆昌吉回族自治州";
$areanames{zh}->{861328995} = "新疆吐鲁番地区";
$areanames{zh}->{861328996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861328997} = "新疆阿克苏地区";
$areanames{zh}->{861328998} = "新疆喀什地区";
$areanames{zh}->{861328999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86132900} = "重庆市";
$areanames{zh}->{861329010} = "山东省济南市";
$areanames{zh}->{861329011} = "山东省淄博市";
$areanames{zh}->{861329012} = "山东省泰安市";
$areanames{zh}->{861329013} = "山东省泰安市";
$areanames{zh}->{861329014} = "山东省莱芜市";
$areanames{zh}->{861329015} = "山东省潍坊市";
$areanames{zh}->{861329016} = "山东省日照市";
$areanames{zh}->{861329017} = "山东省威海市";
$areanames{zh}->{861329018} = "山东省烟台市";
$areanames{zh}->{861329019} = "山东省菏泽市";
$areanames{zh}->{861329020} = "山东省临沂市";
$areanames{zh}->{861329021} = "山东省临沂市";
$areanames{zh}->{861329022} = "山东省枣庄市";
$areanames{zh}->{861329023} = "山东省德州市";
$areanames{zh}->{861329024} = "山东省济南市";
$areanames{zh}->{861329025} = "山东省聊城市";
$areanames{zh}->{861329026} = "山东省聊城市";
$areanames{zh}->{861329027} = "山东省滨州市";
$areanames{zh}->{861329028} = "山东省德州市";
$areanames{zh}->{861329029} = "山东省济南市";
$areanames{zh}->{861329030} = "山东省济宁市";
$areanames{zh}->{861329031} = "山东省东营市";
$areanames{zh}->{861329032} = "山东省济南市";
$areanames{zh}->{861329033} = "山东省济南市";
$areanames{zh}->{861329034} = "山东省菏泽市";
$areanames{zh}->{861329035} = "山东省临沂市";
$areanames{zh}->{861329036} = "山东省烟台市";
$areanames{zh}->{861329037} = "山东省聊城市";
$areanames{zh}->{861329038} = "山东省莱芜市";
$areanames{zh}->{861329039} = "山东省日照市";
$areanames{zh}->{861329040} = "河北省邯郸市";
$areanames{zh}->{861329041} = "河北省石家庄市";
$areanames{zh}->{861329042} = "河北省保定市";
$areanames{zh}->{861329043} = "河北省张家口市";
$areanames{zh}->{861329044} = "河北省石家庄市";
$areanames{zh}->{861329045} = "河北省唐山市";
$areanames{zh}->{861329046} = "河北省廊坊市";
$areanames{zh}->{861329047} = "河北省沧州市";
$areanames{zh}->{861329048} = "河北省邯郸市";
$areanames{zh}->{861329049} = "河北省邢台市";
$areanames{zh}->{861329050} = "河北省邯郸市";
$areanames{zh}->{861329051} = "河北省石家庄市";
$areanames{zh}->{861329052} = "河北省保定市";
$areanames{zh}->{861329053} = "河北省唐山市";
$areanames{zh}->{861329054} = "河北省保定市";
$areanames{zh}->{861329055} = "河北省唐山市";
$areanames{zh}->{861329056} = "河北省石家庄市";
$areanames{zh}->{861329057} = "河北省邯郸市";
$areanames{zh}->{861329058} = "河北省衡水市";
$areanames{zh}->{861329059} = "河北省邢台市";
$areanames{zh}->{861329060} = "河北省邯郸市";
$areanames{zh}->{861329061} = "河北省石家庄市";
$areanames{zh}->{861329062} = "河北省保定市";
$areanames{zh}->{861329063} = "河北省张家口市";
$areanames{zh}->{861329064} = "河北省唐山市";
$areanames{zh}->{861329065} = "河北省唐山市";
$areanames{zh}->{861329066} = "河北省廊坊市";
$areanames{zh}->{861329067} = "河北省沧州市";
$areanames{zh}->{861329068} = "河北省保定市";
$areanames{zh}->{861329069} = "河北省邢台市";
$areanames{zh}->{861329070} = "河南省焦作市";
$areanames{zh}->{861329071} = "福建省漳州市";
$areanames{zh}->{861329072} = "福建省福州市";
$areanames{zh}->{861329073} = "福建省福州市";
$areanames{zh}->{861329074} = "福建省福州市";
$areanames{zh}->{861329075} = "河南省许昌市";
$areanames{zh}->{861329076} = "福建省漳州市";
$areanames{zh}->{861329077} = "河南省濮阳市";
$areanames{zh}->{861329078} = "福建省厦门市";
$areanames{zh}->{861329079} = "河南省安阳市";
$areanames{zh}->{861329080} = "福建省福州市";
$areanames{zh}->{861329081} = "福建省福州市";
$areanames{zh}->{861329082} = "河南省安阳市";
$areanames{zh}->{861329083} = "福建省莆田市";
$areanames{zh}->{861329084} = "河南省三门峡市";
$areanames{zh}->{861329085} = "福建省泉州市";
$areanames{zh}->{861329086} = "福建省泉州市";
$areanames{zh}->{861329087} = "福建省漳州市";
$areanames{zh}->{861329088} = "福建省泉州市";
$areanames{zh}->{861329089} = "福建省福州市";
$areanames{zh}->{861329090} = "河南省郑州市";
$areanames{zh}->{861329091} = "河南省三门峡市";
$areanames{zh}->{861329092} = "河南省平顶山市";
$areanames{zh}->{861329093} = "福建省福州市";
$areanames{zh}->{861329094} = "河南省郑州市";
$areanames{zh}->{861329095} = "福建省福州市";
$areanames{zh}->{861329096} = "河南省郑州市";
$areanames{zh}->{861329097} = "河南省濮阳市";
$areanames{zh}->{861329098} = "福建省福州市";
$areanames{zh}->{861329099} = "河南省信阳市";
$areanames{zh}->{861329100} = "江苏省徐州市";
$areanames{zh}->{861329101} = "江苏省徐州市";
$areanames{zh}->{861329102} = "江苏省徐州市";
$areanames{zh}->{861329103} = "江苏省徐州市";
$areanames{zh}->{861329104} = "甘肃省白银市";
$areanames{zh}->{861329105} = "江苏省徐州市";
$areanames{zh}->{861329106} = "甘肃省白银市";
$areanames{zh}->{861329107} = "甘肃省定西市";
$areanames{zh}->{861329108} = "江苏省苏州市";
$areanames{zh}->{861329109} = "江苏省苏州市";
$areanames{zh}->{86132911} = "江苏省苏州市";
$areanames{zh}->{861329110} = "江苏省南通市";
$areanames{zh}->{861329111} = "江苏省南通市";
$areanames{zh}->{861329112} = "江苏省南通市";
$areanames{zh}->{861329113} = "江苏省南通市";
$areanames{zh}->{861329120} = "江苏省无锡市";
$areanames{zh}->{861329121} = "江苏省无锡市";
$areanames{zh}->{861329122} = "江苏省无锡市";
$areanames{zh}->{861329123} = "江苏省无锡市";
$areanames{zh}->{861329124} = "江苏省无锡市";
$areanames{zh}->{861329125} = "江苏省盐城市";
$areanames{zh}->{861329126} = "江苏省南京市";
$areanames{zh}->{861329127} = "江苏省南京市";
$areanames{zh}->{861329128} = "江苏省南京市";
$areanames{zh}->{861329129} = "江苏省南京市";
$areanames{zh}->{861329130} = "江苏省常州市";
$areanames{zh}->{861329131} = "江苏省常州市";
$areanames{zh}->{861329132} = "江苏省常州市";
$areanames{zh}->{861329133} = "江苏省常州市";
$areanames{zh}->{861329134} = "江苏省常州市";
$areanames{zh}->{861329135} = "江苏省盐城市";
$areanames{zh}->{861329136} = "江苏省盐城市";
$areanames{zh}->{861329137} = "江苏省扬州市";
$areanames{zh}->{861329138} = "江苏省扬州市";
$areanames{zh}->{861329139} = "江苏省扬州市";
$areanames{zh}->{861329140} = "浙江省杭州市";
$areanames{zh}->{861329141} = "浙江省杭州市";
$areanames{zh}->{861329142} = "浙江省杭州市";
$areanames{zh}->{861329143} = "浙江省嘉兴市";
$areanames{zh}->{861329144} = "浙江省宁波市";
$areanames{zh}->{861329145} = "浙江省绍兴市";
$areanames{zh}->{861329146} = "浙江省台州市";
$areanames{zh}->{861329147} = "浙江省温州市";
$areanames{zh}->{861329148} = "浙江省杭州市";
$areanames{zh}->{861329149} = "浙江省金华市";
$areanames{zh}->{861329150} = "浙江省嘉兴市";
$areanames{zh}->{861329151} = "浙江省嘉兴市";
$areanames{zh}->{861329152} = "浙江省嘉兴市";
$areanames{zh}->{861329153} = "浙江省嘉兴市";
$areanames{zh}->{861329154} = "浙江省嘉兴市";
$areanames{zh}->{861329155} = "浙江省绍兴市";
$areanames{zh}->{861329156} = "浙江省温州市";
$areanames{zh}->{861329157} = "浙江省金华市";
$areanames{zh}->{861329158} = "浙江省金华市";
$areanames{zh}->{861329159} = "浙江省金华市";
$areanames{zh}->{86132916} = "浙江省台州市";
$areanames{zh}->{86132917} = "浙江省温州市";
$areanames{zh}->{86132918} = "浙江省杭州市";
$areanames{zh}->{86132919} = "浙江省宁波市";
$areanames{zh}->{86132920} = "河北省邯郸市";
$areanames{zh}->{86132921} = "河北省邢台市";
$areanames{zh}->{86132922} = "河北省衡水市";
$areanames{zh}->{86132923} = "河北省秦皇岛市";
$areanames{zh}->{86132924} = "河北省唐山市";
$areanames{zh}->{86132925} = "河北省唐山市";
$areanames{zh}->{86132926} = "河北省廊坊市";
$areanames{zh}->{86132927} = "河北省沧州市";
$areanames{zh}->{86132928} = "河北省石家庄市";
$areanames{zh}->{86132929} = "河北省保定市";
$areanames{zh}->{86132930} = "河北省邯郸市";
$areanames{zh}->{861329310} = "河北省邢台市";
$areanames{zh}->{861329311} = "河北省邢台市";
$areanames{zh}->{861329312} = "河北省邢台市";
$areanames{zh}->{861329313} = "河北省邢台市";
$areanames{zh}->{861329314} = "河北省邢台市";
$areanames{zh}->{861329315} = "河北省秦皇岛市";
$areanames{zh}->{861329316} = "河北省秦皇岛市";
$areanames{zh}->{861329317} = "河北省秦皇岛市";
$areanames{zh}->{861329318} = "河北省秦皇岛市";
$areanames{zh}->{861329319} = "河北省秦皇岛市";
$areanames{zh}->{86132932} = "河北省承德市";
$areanames{zh}->{86132933} = "河北省张家口市";
$areanames{zh}->{86132934} = "河北省沧州市";
$areanames{zh}->{861329350} = "山西省忻州市";
$areanames{zh}->{861329351} = "山西省太原市";
$areanames{zh}->{861329352} = "山西省大同市";
$areanames{zh}->{861329353} = "山西省阳泉市";
$areanames{zh}->{861329354} = "山西省晋中市";
$areanames{zh}->{861329355} = "山西省长治市";
$areanames{zh}->{861329356} = "山西省晋城市";
$areanames{zh}->{861329357} = "山西省临汾市";
$areanames{zh}->{861329358} = "山西省吕梁市";
$areanames{zh}->{861329359} = "山西省运城市";
$areanames{zh}->{861329360} = "山西省忻州市";
$areanames{zh}->{861329361} = "山西省忻州市";
$areanames{zh}->{861329362} = "山西省忻州市";
$areanames{zh}->{861329363} = "山西省阳泉市";
$areanames{zh}->{861329364} = "山西省阳泉市";
$areanames{zh}->{861329365} = "山西省阳泉市";
$areanames{zh}->{861329366} = "山西省吕梁市";
$areanames{zh}->{861329367} = "山西省吕梁市";
$areanames{zh}->{861329368} = "山西省朔州市";
$areanames{zh}->{861329369} = "山西省朔州市";
$areanames{zh}->{861329370} = "山西省长治市";
$areanames{zh}->{861329371} = "山西省太原市";
$areanames{zh}->{861329372} = "山西省大同市";
$areanames{zh}->{861329373} = "山西省阳泉市";
$areanames{zh}->{861329374} = "山西省太原市";
$areanames{zh}->{861329375} = "山西省长治市";
$areanames{zh}->{861329376} = "山西省晋城市";
$areanames{zh}->{861329377} = "山西省临汾市";
$areanames{zh}->{861329378} = "山西省吕梁市";
$areanames{zh}->{861329379} = "山西省运城市";
$areanames{zh}->{861329380} = "山西省晋中市";
$areanames{zh}->{861329381} = "山西省太原市";
$areanames{zh}->{861329382} = "山西省大同市";
$areanames{zh}->{861329383} = "山西省阳泉市";
$areanames{zh}->{861329384} = "山西省吕梁市";
$areanames{zh}->{861329385} = "山西省长治市";
$areanames{zh}->{861329386} = "山西省运城市";
$areanames{zh}->{861329387} = "山西省临汾市";
$areanames{zh}->{861329388} = "山西省太原市";
$areanames{zh}->{861329389} = "山西省晋城市";
$areanames{zh}->{861329390} = "山西省太原市";
$areanames{zh}->{861329391} = "山西省太原市";
$areanames{zh}->{861329392} = "山西省大同市";
$areanames{zh}->{861329393} = "山西省忻州市";
$areanames{zh}->{861329394} = "山西省吕梁市";
$areanames{zh}->{861329395} = "山西省长治市";
$areanames{zh}->{861329396} = "山西省临汾市";
$areanames{zh}->{861329397} = "山西省运城市";
$areanames{zh}->{861329398} = "山西省朔州市";
$areanames{zh}->{861329399} = "山西省运城市";
$areanames{zh}->{86132940} = "河北省张家口市";
$areanames{zh}->{86132941} = "湖北省武汉市";
$areanames{zh}->{861329420} = "湖北省荆州市";
$areanames{zh}->{861329421} = "湖北省十堰市";
$areanames{zh}->{861329422} = "湖北省十堰市";
$areanames{zh}->{861329423} = "湖北省黄石市";
$areanames{zh}->{861329424} = "湖北省宜昌市";
$areanames{zh}->{861329425} = "湖北省襄樊市";
$areanames{zh}->{861329426} = "湖北省黄冈市";
$areanames{zh}->{861329427} = "湖北省黄冈市";
$areanames{zh}->{861329428} = "湖北省荆门市";
$areanames{zh}->{861329429} = "湖北省鄂州市";
$areanames{zh}->{861329430} = "吉林省长春市";
$areanames{zh}->{861329431} = "吉林省长春市";
$areanames{zh}->{861329432} = "吉林省吉林市";
$areanames{zh}->{861329433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861329434} = "吉林省四平市";
$areanames{zh}->{861329435} = "吉林省通化市";
$areanames{zh}->{861329436} = "吉林省白城市";
$areanames{zh}->{861329437} = "吉林省辽源市";
$areanames{zh}->{861329438} = "吉林省松原市";
$areanames{zh}->{861329439} = "吉林省白山市";
$areanames{zh}->{86132944} = "吉林省吉林市";
$areanames{zh}->{861329450} = "山西省忻州市";
$areanames{zh}->{861329451} = "山西省太原市";
$areanames{zh}->{861329452} = "山西省大同市";
$areanames{zh}->{861329453} = "山西省阳泉市";
$areanames{zh}->{861329454} = "山西省晋中市";
$areanames{zh}->{861329455} = "山西省长治市";
$areanames{zh}->{861329456} = "山西省晋城市";
$areanames{zh}->{861329457} = "山西省临汾市";
$areanames{zh}->{861329458} = "山西省吕梁市";
$areanames{zh}->{861329459} = "山西省运城市";
$areanames{zh}->{861329460} = "山西省忻州市";
$areanames{zh}->{861329461} = "山西省忻州市";
$areanames{zh}->{861329462} = "山西省大同市";
$areanames{zh}->{861329463} = "山西省忻州市";
$areanames{zh}->{861329464} = "山西省晋城市";
$areanames{zh}->{861329465} = "山西省吕梁市";
$areanames{zh}->{861329466} = "山西省晋中市";
$areanames{zh}->{861329467} = "山西省运城市";
$areanames{zh}->{861329468} = "山西省临汾市";
$areanames{zh}->{861329469} = "山西省朔州市";
$areanames{zh}->{861329470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861329471} = "内蒙古呼和浩特市";
$areanames{zh}->{861329472} = "内蒙古包头市";
$areanames{zh}->{861329473} = "内蒙古乌海市";
$areanames{zh}->{861329474} = "内蒙古乌兰察布市";
$areanames{zh}->{861329475} = "内蒙古通辽市";
$areanames{zh}->{861329476} = "内蒙古赤峰市";
$areanames{zh}->{861329477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861329478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861329479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861329480} = "内蒙古呼和浩特市";
$areanames{zh}->{861329481} = "内蒙古呼和浩特市";
$areanames{zh}->{861329482} = "内蒙古兴安盟";
$areanames{zh}->{861329483} = "内蒙古阿拉善盟";
$areanames{zh}->{861329484} = "内蒙古通辽市";
$areanames{zh}->{861329485} = "内蒙古通辽市";
$areanames{zh}->{861329486} = "内蒙古包头市";
$areanames{zh}->{861329487} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861329488} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861329489} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861329490} = "云南省昭通市";
$areanames{zh}->{861329491} = "云南省昭通市";
$areanames{zh}->{861329492} = "云南省昭通市";
$areanames{zh}->{861329493} = "云南省昆明市";
$areanames{zh}->{861329494} = "云南省昆明市";
$areanames{zh}->{861329495} = "云南省昆明市";
$areanames{zh}->{861329496} = "云南省昆明市";
$areanames{zh}->{861329497} = "云南省昆明市";
$areanames{zh}->{861329498} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861329499} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861329500} = "福建省泉州市";
$areanames{zh}->{861329501} = "福建省福州市";
$areanames{zh}->{861329502} = "福建省泉州市";
$areanames{zh}->{861329503} = "河南省平顶山市";
$areanames{zh}->{861329504} = "河南省许昌市";
$areanames{zh}->{861329505} = "福建省泉州市";
$areanames{zh}->{861329506} = "福建省三明市";
$areanames{zh}->{861329507} = "福建省宁德市";
$areanames{zh}->{861329508} = "河南省开封市";
$areanames{zh}->{861329509} = "福建省南平市";
$areanames{zh}->{86132951} = "江苏省苏州市";
$areanames{zh}->{861329520} = "江苏省淮安市";
$areanames{zh}->{861329521} = "江苏省淮安市";
$areanames{zh}->{861329522} = "江苏省淮安市";
$areanames{zh}->{861329523} = "江苏省泰州市";
$areanames{zh}->{861329524} = "江苏省泰州市";
$areanames{zh}->{861329525} = "江苏省泰州市";
$areanames{zh}->{861329526} = "江苏省泰州市";
$areanames{zh}->{861329527} = "江苏省宿迁市";
$areanames{zh}->{861329528} = "江苏省宿迁市";
$areanames{zh}->{861329529} = "江苏省宿迁市";
$areanames{zh}->{861329530} = "山东省菏泽市";
$areanames{zh}->{861329531} = "山东省济南市";
$areanames{zh}->{861329532} = "山东省青岛市";
$areanames{zh}->{861329533} = "山东省淄博市";
$areanames{zh}->{861329534} = "山东省德州市";
$areanames{zh}->{861329535} = "山东省烟台市";
$areanames{zh}->{861329536} = "山东省潍坊市";
$areanames{zh}->{861329537} = "山东省济宁市";
$areanames{zh}->{861329538} = "山东省泰安市";
$areanames{zh}->{861329539} = "山东省临沂市";
$areanames{zh}->{861329540} = "山东省菏泽市";
$areanames{zh}->{861329541} = "山东省济南市";
$areanames{zh}->{861329542} = "山东省青岛市";
$areanames{zh}->{861329543} = "山东省滨州市";
$areanames{zh}->{861329544} = "山东省聊城市";
$areanames{zh}->{861329545} = "山东省烟台市";
$areanames{zh}->{861329546} = "山东省东营市";
$areanames{zh}->{861329547} = "山东省济宁市";
$areanames{zh}->{861329548} = "山东省泰安市";
$areanames{zh}->{861329549} = "山东省临沂市";
$areanames{zh}->{861329550} = "安徽省滁州市";
$areanames{zh}->{861329551} = "安徽省合肥市";
$areanames{zh}->{861329552} = "安徽省蚌埠市";
$areanames{zh}->{861329553} = "安徽省芜湖市";
$areanames{zh}->{861329554} = "安徽省淮南市";
$areanames{zh}->{861329555} = "安徽省马鞍山市";
$areanames{zh}->{861329556} = "安徽省安庆市";
$areanames{zh}->{861329557} = "安徽省宿州市";
$areanames{zh}->{861329558} = "安徽省阜阳市";
$areanames{zh}->{861329559} = "安徽省黄山市";
$areanames{zh}->{861329560} = "安徽省合肥市";
$areanames{zh}->{861329561} = "安徽省淮北市";
$areanames{zh}->{861329562} = "安徽省铜陵市";
$areanames{zh}->{861329563} = "安徽省宣城市";
$areanames{zh}->{861329564} = "安徽省六安市";
$areanames{zh}->{861329565} = "安徽省芜湖市";
$areanames{zh}->{861329566} = "安徽省池州市";
$areanames{zh}->{861329567} = "安徽省亳州市";
$areanames{zh}->{861329568} = "安徽省阜阳市";
$areanames{zh}->{861329569} = "安徽省合肥市";
$areanames{zh}->{861329570} = "浙江省衢州市";
$areanames{zh}->{861329571} = "浙江省杭州市";
$areanames{zh}->{861329572} = "浙江省湖州市";
$areanames{zh}->{861329573} = "浙江省嘉兴市";
$areanames{zh}->{861329574} = "浙江省宁波市";
$areanames{zh}->{861329575} = "浙江省绍兴市";
$areanames{zh}->{861329576} = "浙江省台州市";
$areanames{zh}->{861329577} = "浙江省温州市";
$areanames{zh}->{861329578} = "浙江省丽水市";
$areanames{zh}->{861329579} = "浙江省金华市";
$areanames{zh}->{861329580} = "浙江省舟山市";
$areanames{zh}->{861329581} = "浙江省杭州市";
$areanames{zh}->{861329582} = "浙江省湖州市";
$areanames{zh}->{861329583} = "浙江省嘉兴市";
$areanames{zh}->{861329584} = "浙江省宁波市";
$areanames{zh}->{861329585} = "浙江省绍兴市";
$areanames{zh}->{861329586} = "浙江省台州市";
$areanames{zh}->{861329587} = "浙江省温州市";
$areanames{zh}->{861329588} = "浙江省丽水市";
$areanames{zh}->{861329589} = "浙江省金华市";
$areanames{zh}->{861329590} = "福建省泉州市";
$areanames{zh}->{861329591} = "福建省福州市";
$areanames{zh}->{861329592} = "福建省厦门市";
$areanames{zh}->{861329593} = "福建省莆田市";
$areanames{zh}->{861329594} = "福建省福州市";
$areanames{zh}->{861329595} = "福建省泉州市";
$areanames{zh}->{861329596} = "福建省漳州市";
$areanames{zh}->{861329597} = "福建省福州市";
$areanames{zh}->{861329598} = "河南省洛阳市";
$areanames{zh}->{861329599} = "河南省信阳市";
$areanames{zh}->{86132960} = "上海市";
$areanames{zh}->{86132961} = "上海市";
$areanames{zh}->{86132962} = "上海市";
$areanames{zh}->{861329630} = "山东省威海市";
$areanames{zh}->{861329631} = "山东省威海市";
$areanames{zh}->{861329632} = "山东省枣庄市";
$areanames{zh}->{861329633} = "山东省日照市";
$areanames{zh}->{861329634} = "山东省莱芜市";
$areanames{zh}->{861329635} = "山东省聊城市";
$areanames{zh}->{861329636} = "山东省潍坊市";
$areanames{zh}->{861329637} = "山东省枣庄市";
$areanames{zh}->{861329638} = "山东省烟台市";
$areanames{zh}->{861329639} = "山东省青岛市";
$areanames{zh}->{861329640} = "山东省济南市";
$areanames{zh}->{861329641} = "山东省济南市";
$areanames{zh}->{861329642} = "山东省青岛市";
$areanames{zh}->{861329643} = "山东省淄博市";
$areanames{zh}->{861329644} = "山东省济南市";
$areanames{zh}->{861329645} = "山东省烟台市";
$areanames{zh}->{861329646} = "山东省潍坊市";
$areanames{zh}->{861329647} = "山东省东营市";
$areanames{zh}->{861329648} = "山东省青岛市";
$areanames{zh}->{861329649} = "山东省菏泽市";
$areanames{zh}->{86132965} = "湖北省武汉市";
$areanames{zh}->{86132966} = "湖北省武汉市";
$areanames{zh}->{86132967} = "浙江省杭州市";
$areanames{zh}->{861329670} = "浙江省温州市";
$areanames{zh}->{861329677} = "浙江省嘉兴市";
$areanames{zh}->{861329678} = "浙江省嘉兴市";
$areanames{zh}->{861329679} = "浙江省嘉兴市";
$areanames{zh}->{86132968} = "浙江省宁波市";
$areanames{zh}->{861329680} = "浙江省绍兴市";
$areanames{zh}->{861329687} = "浙江省台州市";
$areanames{zh}->{861329688} = "浙江省台州市";
$areanames{zh}->{861329689} = "浙江省温州市";
$areanames{zh}->{861329690} = "内蒙古呼和浩特市";
$areanames{zh}->{861329691} = "内蒙古包头市";
$areanames{zh}->{861329692} = "内蒙古包头市";
$areanames{zh}->{861329693} = "内蒙古包头市";
$areanames{zh}->{861329694} = "内蒙古乌兰察布市";
$areanames{zh}->{861329695} = "内蒙古乌兰察布市";
$areanames{zh}->{861329696} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861329697} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861329698} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861329699} = "内蒙古巴彦淖尔市";
$areanames{zh}->{86132970} = "湖北省武汉市";
$areanames{zh}->{86132971} = "湖北省十堰市";
$areanames{zh}->{861329710} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861329711} = "湖北省荆州市";
$areanames{zh}->{861329712} = "湖北省荆门市";
$areanames{zh}->{861329713} = "湖北省荆门市";
$areanames{zh}->{861329720} = "湖北省武汉市";
$areanames{zh}->{861329721} = "湖北省黄石市";
$areanames{zh}->{861329722} = "湖北省黄石市";
$areanames{zh}->{861329723} = "湖北省黄石市";
$areanames{zh}->{861329724} = "湖北省黄石市";
$areanames{zh}->{861329725} = "湖北省随州市";
$areanames{zh}->{861329726} = "湖北省随州市";
$areanames{zh}->{861329727} = "湖北省随州市";
$areanames{zh}->{861329728} = "湖北省宜昌市";
$areanames{zh}->{861329729} = "湖北省襄樊市";
$areanames{zh}->{861329730} = "湖南省岳阳市";
$areanames{zh}->{861329731} = "湖南省长沙市";
$areanames{zh}->{861329732} = "湖南省湘潭市";
$areanames{zh}->{861329733} = "湖南省株洲市";
$areanames{zh}->{861329734} = "湖南省衡阳市";
$areanames{zh}->{861329735} = "湖南省郴州市";
$areanames{zh}->{861329736} = "湖南省常德市";
$areanames{zh}->{861329737} = "湖南省益阳市";
$areanames{zh}->{861329738} = "湖南省娄底市";
$areanames{zh}->{861329739} = "湖南省邵阳市";
$areanames{zh}->{86132974} = "湖南省长沙市";
$areanames{zh}->{861329743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861329744} = "湖南省张家界市";
$areanames{zh}->{861329745} = "湖南省怀化市";
$areanames{zh}->{861329746} = "湖南省永州市";
$areanames{zh}->{861329750} = "湖北省鄂州市";
$areanames{zh}->{861329751} = "湖北省鄂州市";
$areanames{zh}->{861329752} = "湖北省孝感市";
$areanames{zh}->{861329753} = "湖北省孝感市";
$areanames{zh}->{861329754} = "湖北省孝感市";
$areanames{zh}->{861329755} = "湖北省孝感市";
$areanames{zh}->{861329756} = "湖北省黄冈市";
$areanames{zh}->{861329757} = "湖北省黄冈市";
$areanames{zh}->{861329758} = "湖北省黄冈市";
$areanames{zh}->{861329759} = "湖北省黄冈市";
$areanames{zh}->{861329760} = "湖北省荆门市";
$areanames{zh}->{861329761} = "湖北省荆门市";
$areanames{zh}->{861329762} = "湖北省荆门市";
$areanames{zh}->{861329763} = "湖北省荆门市";
$areanames{zh}->{861329764} = "湖北省黄石市";
$areanames{zh}->{861329765} = "湖北省黄石市";
$areanames{zh}->{861329766} = "湖北省黄石市";
$areanames{zh}->{861329767} = "湖北省咸宁市";
$areanames{zh}->{861329768} = "湖北省咸宁市";
$areanames{zh}->{861329769} = "湖北省鄂州市";
$areanames{zh}->{861329770} = "广西南宁市";
$areanames{zh}->{861329771} = "广西南宁市";
$areanames{zh}->{861329772} = "广西柳州市";
$areanames{zh}->{861329773} = "广西桂林市";
$areanames{zh}->{861329774} = "广西梧州市";
$areanames{zh}->{861329775} = "广西玉林市";
$areanames{zh}->{861329776} = "广西百色市";
$areanames{zh}->{861329777} = "广西钦州市";
$areanames{zh}->{861329778} = "广西河池市";
$areanames{zh}->{861329779} = "广西柳州市";
$areanames{zh}->{861329780} = "广西南宁市";
$areanames{zh}->{861329781} = "广西南宁市";
$areanames{zh}->{861329782} = "广西柳州市";
$areanames{zh}->{861329783} = "广西桂林市";
$areanames{zh}->{861329784} = "广西梧州市";
$areanames{zh}->{861329785} = "广西玉林市";
$areanames{zh}->{861329786} = "广西玉林市";
$areanames{zh}->{861329787} = "广西钦州市";
$areanames{zh}->{861329788} = "广西河池市";
$areanames{zh}->{861329789} = "广西柳州市";
$areanames{zh}->{86132979} = "湖北省武汉市";
$areanames{zh}->{86132980} = "内蒙古通辽市";
$areanames{zh}->{861329800} = "内蒙古赤峰市";
$areanames{zh}->{861329801} = "内蒙古赤峰市";
$areanames{zh}->{861329802} = "内蒙古赤峰市";
$areanames{zh}->{861329803} = "内蒙古赤峰市";
$areanames{zh}->{86132981} = "河南省郑州市";
$areanames{zh}->{86132982} = "河南省许昌市";
$areanames{zh}->{861329827} = "河南省三门峡市";
$areanames{zh}->{861329828} = "河南省三门峡市";
$areanames{zh}->{861329829} = "河南省三门峡市";
$areanames{zh}->{86132983} = "河南省郑州市";
$areanames{zh}->{861329837} = "河南省焦作市";
$areanames{zh}->{861329838} = "河南省焦作市";
$areanames{zh}->{861329839} = "河南省焦作市";
$areanames{zh}->{861329840} = "河南省郑州市";
$areanames{zh}->{861329841} = "河南省郑州市";
$areanames{zh}->{861329842} = "河南省郑州市";
$areanames{zh}->{861329843} = "河南省许昌市";
$areanames{zh}->{861329844} = "河南省许昌市";
$areanames{zh}->{861329845} = "河南省许昌市";
$areanames{zh}->{861329846} = "河南省焦作市";
$areanames{zh}->{861329847} = "河南省焦作市";
$areanames{zh}->{861329848} = "河南省三门峡市";
$areanames{zh}->{861329849} = "河南省三门峡市";
$areanames{zh}->{861329850} = "湖南省岳阳市";
$areanames{zh}->{861329851} = "湖南省岳阳市";
$areanames{zh}->{861329852} = "湖南省湘潭市";
$areanames{zh}->{861329853} = "湖南省湘潭市";
$areanames{zh}->{861329854} = "湖南省株洲市";
$areanames{zh}->{861329855} = "湖南省张家界市";
$areanames{zh}->{861329856} = "湖南省株洲市";
$areanames{zh}->{861329857} = "湖南省衡阳市";
$areanames{zh}->{861329858} = "湖南省衡阳市";
$areanames{zh}->{861329859} = "湖南省郴州市";
$areanames{zh}->{861329860} = "湖南省常德市";
$areanames{zh}->{861329861} = "湖南省常德市";
$areanames{zh}->{861329862} = "湖南省益阳市";
$areanames{zh}->{861329863} = "湖南省衡阳市";
$areanames{zh}->{861329864} = "湖南省邵阳市";
$areanames{zh}->{861329865} = "湖南省长沙市";
$areanames{zh}->{861329866} = "湖南省怀化市";
$areanames{zh}->{861329867} = "湖南省永州市";
$areanames{zh}->{861329868} = "湖南省长沙市";
$areanames{zh}->{861329869} = "湖南省长沙市";
$areanames{zh}->{861329870} = "黑龙江省哈尔滨市";
$areanames{zh}->{861329871} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861329872} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861329873} = "黑龙江省佳木斯市";
$areanames{zh}->{861329874} = "黑龙江省牡丹江市";
$areanames{zh}->{861329875} = "黑龙江省绥化市";
$areanames{zh}->{861329876} = "黑龙江省佳木斯市";
$areanames{zh}->{861329877} = "黑龙江省大庆市";
$areanames{zh}->{861329878} = "黑龙江省哈尔滨市";
$areanames{zh}->{861329879} = "黑龙江省牡丹江市";
$areanames{zh}->{861329880} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861329881} = "吉林省白山市";
$areanames{zh}->{861329882} = "吉林省松原市";
$areanames{zh}->{861329883} = "吉林省松原市";
$areanames{zh}->{861329884} = "吉林省通化市";
$areanames{zh}->{861329885} = "吉林省通化市";
$areanames{zh}->{861329886} = "吉林省通化市";
$areanames{zh}->{861329887} = "吉林省辽源市";
$areanames{zh}->{861329888} = "吉林省长春市";
$areanames{zh}->{861329889} = "吉林省四平市";
$areanames{zh}->{86132989} = "西藏拉萨市";
$areanames{zh}->{861329892} = "西藏日喀则地区";
$areanames{zh}->{861329893} = "西藏山南地区";
$areanames{zh}->{861329894} = "西藏林芝地区";
$areanames{zh}->{861329896} = "西藏那曲地区";
$areanames{zh}->{86132990} = "陕西省西安市";
$areanames{zh}->{86132991} = "陕西省西安市";
$areanames{zh}->{861329914} = "陕西省商洛市";
$areanames{zh}->{861329915} = "陕西省安康市";
$areanames{zh}->{861329918} = "陕西省商洛市";
$areanames{zh}->{861329920} = "广西南宁市";
$areanames{zh}->{861329921} = "广西南宁市";
$areanames{zh}->{861329922} = "广西柳州市";
$areanames{zh}->{861329923} = "广西桂林市";
$areanames{zh}->{861329924} = "广西玉林市";
$areanames{zh}->{861329925} = "广西玉林市";
$areanames{zh}->{861329926} = "广西南宁市";
$areanames{zh}->{861329927} = "广西桂林市";
$areanames{zh}->{861329928} = "广西河池市";
$areanames{zh}->{861329929} = "广西柳州市";
$areanames{zh}->{861329930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861329931} = "甘肃省兰州市";
$areanames{zh}->{861329932} = "甘肃省酒泉市";
$areanames{zh}->{861329933} = "甘肃省白银市";
$areanames{zh}->{861329934} = "甘肃省嘉峪关市";
$areanames{zh}->{861329935} = "甘肃省武威市";
$areanames{zh}->{861329936} = "甘肃省武威市";
$areanames{zh}->{861329937} = "甘肃省酒泉市";
$areanames{zh}->{861329938} = "甘肃省酒泉市";
$areanames{zh}->{861329939} = "甘肃省陇南市";
$areanames{zh}->{861329940} = "广西南宁市";
$areanames{zh}->{861329941} = "广西南宁市";
$areanames{zh}->{861329942} = "广西柳州市";
$areanames{zh}->{861329943} = "广西桂林市";
$areanames{zh}->{861329944} = "广西玉林市";
$areanames{zh}->{861329945} = "广西玉林市";
$areanames{zh}->{861329946} = "广西玉林市";
$areanames{zh}->{861329947} = "广西桂林市";
$areanames{zh}->{861329948} = "广西河池市";
$areanames{zh}->{861329949} = "广西柳州市";
$areanames{zh}->{861329950} = "宁夏银川市";
$areanames{zh}->{861329951} = "宁夏银川市";
$areanames{zh}->{861329952} = "宁夏石嘴山市";
$areanames{zh}->{861329953} = "宁夏吴忠市";
$areanames{zh}->{861329954} = "宁夏固原市";
$areanames{zh}->{861329955} = "宁夏中卫市";
$areanames{zh}->{861329956} = "宁夏吴忠市";
$areanames{zh}->{861329957} = "宁夏中卫市";
$areanames{zh}->{861329958} = "宁夏银川市";
$areanames{zh}->{861329959} = "宁夏固原市";
$areanames{zh}->{861329960} = "广西柳州市";
$areanames{zh}->{861329961} = "广西柳州市";
$areanames{zh}->{861329962} = "广西柳州市";
$areanames{zh}->{861329963} = "广西桂林市";
$areanames{zh}->{861329964} = "广西柳州市";
$areanames{zh}->{861329965} = "广西玉林市";
$areanames{zh}->{861329966} = "广西玉林市";
$areanames{zh}->{861329967} = "广西玉林市";
$areanames{zh}->{861329968} = "广西玉林市";
$areanames{zh}->{861329969} = "广西玉林市";
$areanames{zh}->{861329970} = "青海省海北藏族自治州";
$areanames{zh}->{861329971} = "青海省西宁市";
$areanames{zh}->{861329972} = "青海省海东地区";
$areanames{zh}->{861329973} = "青海省黄南藏族自治州";
$areanames{zh}->{861329974} = "青海省海南藏族自治州";
$areanames{zh}->{861329975} = "青海省海东地区";
$areanames{zh}->{861329976} = "青海省西宁市";
$areanames{zh}->{861329977} = "青海省海东地区";
$areanames{zh}->{861329978} = "青海省西宁市";
$areanames{zh}->{861329979} = "青海省海东地区";
$areanames{zh}->{861329980} = "青海省西宁市";
$areanames{zh}->{861329981} = "青海省西宁市";
$areanames{zh}->{861329982} = "青海省海东地区";
$areanames{zh}->{861329983} = "青海省海东地区";
$areanames{zh}->{861329984} = "青海省海南藏族自治州";
$areanames{zh}->{861329985} = "青海省海东地区";
$areanames{zh}->{861329986} = "青海省玉树藏族自治州";
$areanames{zh}->{861329987} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861329988} = "青海省西宁市";
$areanames{zh}->{861329989} = "青海省海东地区";
$areanames{zh}->{86132999} = "天津市";
$areanames{zh}->{861330000} = "广西南宁市";
$areanames{zh}->{861330001} = "安徽省安庆市";
$areanames{zh}->{861330002} = "重庆市";
$areanames{zh}->{861330003} = "重庆市";
$areanames{zh}->{861330010} = "北京市";
$areanames{zh}->{861330011} = "北京市";
$areanames{zh}->{861330018} = "上海市";
$areanames{zh}->{861330019} = "上海市";
$areanames{zh}->{86133003} = "天津市";
$areanames{zh}->{86133005} = "上海市";
$areanames{zh}->{86133006} = "上海市";
$areanames{zh}->{86133007} = "广西南宁市";
$areanames{zh}->{86133008} = "上海市";
$areanames{zh}->{86133009} = "上海市";
$areanames{zh}->{86133010} = "北京市";
$areanames{zh}->{86133011} = "北京市";
$areanames{zh}->{86133012} = "北京市";
$areanames{zh}->{86133013} = "北京市";
$areanames{zh}->{861330140} = "江苏省淮安市";
$areanames{zh}->{861330141} = "江苏省盐城市";
$areanames{zh}->{861330142} = "江苏省泰州市";
$areanames{zh}->{861330143} = "江苏省泰州市";
$areanames{zh}->{861330144} = "江苏省扬州市";
$areanames{zh}->{861330145} = "江苏省扬州市";
$areanames{zh}->{861330146} = "江苏省南通市";
$areanames{zh}->{861330147} = "江苏省南通市";
$areanames{zh}->{861330148} = "江苏省南通市";
$areanames{zh}->{861330149} = "江苏省常州市";
$areanames{zh}->{861330150} = "江苏省常州市";
$areanames{zh}->{861330151} = "江苏省无锡市";
$areanames{zh}->{861330152} = "江苏省无锡市";
$areanames{zh}->{861330153} = "江苏省无锡市";
$areanames{zh}->{861330154} = "江苏省苏州市";
$areanames{zh}->{861330155} = "江苏省苏州市";
$areanames{zh}->{861330156} = "江苏省苏州市";
$areanames{zh}->{861330157} = "江苏省苏州市";
$areanames{zh}->{861330158} = "江苏省南京市";
$areanames{zh}->{861330159} = "江苏省南京市";
$areanames{zh}->{86133016} = "上海市";
$areanames{zh}->{86133017} = "上海市";
$areanames{zh}->{86133018} = "上海市";
$areanames{zh}->{86133019} = "上海市";
$areanames{zh}->{86133020} = "天津市";
$areanames{zh}->{86133021} = "天津市";
$areanames{zh}->{86133022} = "广东省广州市";
$areanames{zh}->{861330230} = "广东省广州市";
$areanames{zh}->{861330231} = "广东省深圳市";
$areanames{zh}->{861330232} = "广东省广州市";
$areanames{zh}->{861330233} = "广东省广州市";
$areanames{zh}->{861330234} = "广东省韶关市";
$areanames{zh}->{861330235} = "广东省清远市";
$areanames{zh}->{861330236} = "广东省肇庆市";
$areanames{zh}->{861330237} = "广东省云浮市";
$areanames{zh}->{861330238} = "广东省广州市";
$areanames{zh}->{861330239} = "广东省广州市";
$areanames{zh}->{86133024} = "广东省深圳市";
$areanames{zh}->{861330240} = "广东省广州市";
$areanames{zh}->{861330241} = "广东省佛山市";
$areanames{zh}->{861330242} = "广东省佛山市";
$areanames{zh}->{861330249} = "广东省广州市";
$areanames{zh}->{861330250} = "广东省湛江市";
$areanames{zh}->{861330251} = "广东省茂名市";
$areanames{zh}->{861330252} = "广东省阳江市";
$areanames{zh}->{861330253} = "广东省珠海市";
$areanames{zh}->{861330254} = "广东省茂名市";
$areanames{zh}->{861330255} = "广东省江门市";
$areanames{zh}->{861330256} = "广东省佛山市";
$areanames{zh}->{861330257} = "广东省湛江市";
$areanames{zh}->{861330258} = "广东省江门市";
$areanames{zh}->{861330259} = "广东省中山市";
$areanames{zh}->{861330260} = "广东省东莞市";
$areanames{zh}->{861330261} = "广东省东莞市";
$areanames{zh}->{861330262} = "广东省惠州市";
$areanames{zh}->{861330263} = "广东省河源市";
$areanames{zh}->{861330264} = "广东省东莞市";
$areanames{zh}->{861330265} = "广东省惠州市";
$areanames{zh}->{861330266} = "广东省惠州市";
$areanames{zh}->{861330267} = "广东省汕尾市";
$areanames{zh}->{861330268} = "广东省汕尾市";
$areanames{zh}->{861330269} = "广东省东莞市";
$areanames{zh}->{86133027} = "广东省汕头市";
$areanames{zh}->{861330275} = "广东省揭阳市";
$areanames{zh}->{861330276} = "广东省揭阳市";
$areanames{zh}->{861330278} = "广东省梅州市";
$areanames{zh}->{861330279} = "广东省潮州市";
$areanames{zh}->{86133028} = "广东省佛山市";
$areanames{zh}->{861330282} = "广东省中山市";
$areanames{zh}->{861330286} = "广东省珠海市";
$areanames{zh}->{861330287} = "广东省珠海市";
$areanames{zh}->{861330288} = "广东省江门市";
$areanames{zh}->{86133029} = "广东省深圳市";
$areanames{zh}->{861330300} = "河北省邯郸市";
$areanames{zh}->{861330301} = "河北省石家庄市";
$areanames{zh}->{861330302} = "河北省保定市";
$areanames{zh}->{861330303} = "河北省石家庄市";
$areanames{zh}->{861330304} = "河北省石家庄市";
$areanames{zh}->{861330305} = "河北省唐山市";
$areanames{zh}->{861330306} = "河北省沧州市";
$areanames{zh}->{861330307} = "河北省沧州市";
$areanames{zh}->{861330308} = "河北省邯郸市";
$areanames{zh}->{861330309} = "河北省邢台市";
$areanames{zh}->{861330310} = "河北省邯郸市";
$areanames{zh}->{861330311} = "河北省石家庄市";
$areanames{zh}->{861330312} = "河北省保定市";
$areanames{zh}->{861330313} = "河北省张家口市";
$areanames{zh}->{861330314} = "河北省承德市";
$areanames{zh}->{861330315} = "河北省唐山市";
$areanames{zh}->{861330316} = "河北省廊坊市";
$areanames{zh}->{861330317} = "河北省沧州市";
$areanames{zh}->{861330318} = "河北省衡水市";
$areanames{zh}->{861330319} = "河北省邢台市";
$areanames{zh}->{861330320} = "河北省邯郸市";
$areanames{zh}->{861330321} = "河北省石家庄市";
$areanames{zh}->{861330322} = "河北省保定市";
$areanames{zh}->{861330323} = "河北省石家庄市";
$areanames{zh}->{861330324} = "河北省唐山市";
$areanames{zh}->{861330325} = "河北省唐山市";
$areanames{zh}->{861330326} = "河北省保定市";
$areanames{zh}->{861330327} = "河北省秦皇岛市";
$areanames{zh}->{861330328} = "河北省秦皇岛市";
$areanames{zh}->{861330329} = "河北省石家庄市";
$areanames{zh}->{861330330} = "河北省邯郸市";
$areanames{zh}->{861330331} = "河北省石家庄市";
$areanames{zh}->{861330332} = "河北省保定市";
$areanames{zh}->{861330333} = "河北省张家口市";
$areanames{zh}->{861330334} = "河北省唐山市";
$areanames{zh}->{861330335} = "河北省秦皇岛市";
$areanames{zh}->{861330336} = "河北省廊坊市";
$areanames{zh}->{861330337} = "河北省沧州市";
$areanames{zh}->{861330338} = "河北省衡水市";
$areanames{zh}->{861330339} = "河北省邢台市";
$areanames{zh}->{861330340} = "山西省太原市";
$areanames{zh}->{861330341} = "山西省太原市";
$areanames{zh}->{861330342} = "山西省大同市";
$areanames{zh}->{861330343} = "山西省太原市";
$areanames{zh}->{861330344} = "山西省晋中市";
$areanames{zh}->{861330345} = "山西省长治市";
$areanames{zh}->{861330346} = "山西省太原市";
$areanames{zh}->{861330347} = "山西省临汾市";
$areanames{zh}->{861330348} = "山西省运城市";
$areanames{zh}->{861330349} = "山西省朔州市";
$areanames{zh}->{861330350} = "山西省忻州市";
$areanames{zh}->{861330351} = "山西省太原市";
$areanames{zh}->{861330352} = "山西省大同市";
$areanames{zh}->{861330353} = "山西省阳泉市";
$areanames{zh}->{861330354} = "山西省晋中市";
$areanames{zh}->{861330355} = "山西省长治市";
$areanames{zh}->{861330356} = "山西省晋城市";
$areanames{zh}->{861330357} = "山西省临汾市";
$areanames{zh}->{861330358} = "山西省吕梁市";
$areanames{zh}->{861330359} = "山西省运城市";
$areanames{zh}->{861330360} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330361} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330362} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861330363} = "黑龙江省牡丹江市";
$areanames{zh}->{861330364} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330365} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330366} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330367} = "黑龙江省鸡西市";
$areanames{zh}->{861330368} = "黑龙江省佳木斯市";
$areanames{zh}->{861330369} = "黑龙江省大庆市";
$areanames{zh}->{861330370} = "河南省商丘市";
$areanames{zh}->{861330371} = "河南省郑州市";
$areanames{zh}->{861330372} = "河南省安阳市";
$areanames{zh}->{861330373} = "河南省新乡市";
$areanames{zh}->{861330374} = "河南省许昌市";
$areanames{zh}->{861330375} = "河南省平顶山市";
$areanames{zh}->{861330376} = "河南省信阳市";
$areanames{zh}->{861330377} = "河南省南阳市";
$areanames{zh}->{861330378} = "河南省开封市";
$areanames{zh}->{861330379} = "河南省洛阳市";
$areanames{zh}->{86133038} = "河南省郑州市";
$areanames{zh}->{861330380} = "河南省新乡市";
$areanames{zh}->{861330387} = "河南省周口市";
$areanames{zh}->{861330388} = "河南省洛阳市";
$areanames{zh}->{861330389} = "河南省焦作市";
$areanames{zh}->{861330390} = "河南省平顶山市";
$areanames{zh}->{861330391} = "河南省焦作市";
$areanames{zh}->{861330392} = "河南省鹤壁市";
$areanames{zh}->{861330393} = "河南省濮阳市";
$areanames{zh}->{861330394} = "河南省周口市";
$areanames{zh}->{861330395} = "河南省漯河市";
$areanames{zh}->{861330396} = "河南省驻马店市";
$areanames{zh}->{861330397} = "河南省信阳市";
$areanames{zh}->{861330398} = "河南省三门峡市";
$areanames{zh}->{861330399} = "河南省许昌市";
$areanames{zh}->{86133040} = "辽宁省沈阳市";
$areanames{zh}->{861330406} = "辽宁省锦州市";
$areanames{zh}->{861330407} = "辽宁省营口市";
$areanames{zh}->{861330408} = "辽宁省大连市";
$areanames{zh}->{861330409} = "辽宁省大连市";
$areanames{zh}->{861330410} = "辽宁省铁岭市";
$areanames{zh}->{861330411} = "辽宁省大连市";
$areanames{zh}->{861330412} = "辽宁省鞍山市";
$areanames{zh}->{861330413} = "辽宁省抚顺市";
$areanames{zh}->{861330414} = "辽宁省本溪市";
$areanames{zh}->{861330415} = "辽宁省丹东市";
$areanames{zh}->{861330416} = "辽宁省锦州市";
$areanames{zh}->{861330417} = "辽宁省营口市";
$areanames{zh}->{861330418} = "辽宁省阜新市";
$areanames{zh}->{861330419} = "辽宁省辽阳市";
$areanames{zh}->{861330420} = "辽宁省鞍山市";
$areanames{zh}->{861330421} = "辽宁省朝阳市";
$areanames{zh}->{861330422} = "辽宁省鞍山市";
$areanames{zh}->{861330423} = "辽宁省抚顺市";
$areanames{zh}->{861330424} = "辽宁省本溪市";
$areanames{zh}->{861330425} = "辽宁省丹东市";
$areanames{zh}->{861330426} = "辽宁省大连市";
$areanames{zh}->{861330427} = "辽宁省盘锦市";
$areanames{zh}->{861330428} = "辽宁省大连市";
$areanames{zh}->{861330429} = "辽宁省葫芦岛市";
$areanames{zh}->{861330430} = "吉林省长春市";
$areanames{zh}->{861330431} = "吉林省长春市";
$areanames{zh}->{861330432} = "吉林省长春市";
$areanames{zh}->{861330433} = "吉林省长春市";
$areanames{zh}->{861330434} = "吉林省四平市";
$areanames{zh}->{861330435} = "吉林省四平市";
$areanames{zh}->{861330436} = "吉林省白城市";
$areanames{zh}->{861330437} = "吉林省辽源市";
$areanames{zh}->{861330438} = "吉林省松原市";
$areanames{zh}->{861330439} = "吉林省长春市";
$areanames{zh}->{861330440} = "吉林省吉林市";
$areanames{zh}->{861330441} = "吉林省吉林市";
$areanames{zh}->{861330442} = "吉林省吉林市";
$areanames{zh}->{861330443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861330444} = "吉林省吉林市";
$areanames{zh}->{861330445} = "吉林省通化市";
$areanames{zh}->{861330446} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861330447} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861330448} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861330449} = "吉林省白山市";
$areanames{zh}->{861330450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861330453} = "黑龙江省牡丹江市";
$areanames{zh}->{861330454} = "黑龙江省佳木斯市";
$areanames{zh}->{861330455} = "黑龙江省绥化市";
$areanames{zh}->{861330456} = "黑龙江省黑河市";
$areanames{zh}->{861330457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861330458} = "黑龙江省伊春市";
$areanames{zh}->{861330459} = "黑龙江省大庆市";
$areanames{zh}->{86133046} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861330467} = "黑龙江省七台河市";
$areanames{zh}->{861330468} = "黑龙江省鹤岗市";
$areanames{zh}->{861330469} = "黑龙江省大庆市";
$areanames{zh}->{861330470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861330471} = "内蒙古呼和浩特市";
$areanames{zh}->{861330472} = "内蒙古包头市";
$areanames{zh}->{861330473} = "内蒙古乌海市";
$areanames{zh}->{861330474} = "内蒙古兴安盟";
$areanames{zh}->{861330475} = "内蒙古通辽市";
$areanames{zh}->{861330476} = "内蒙古赤峰市";
$areanames{zh}->{861330477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861330478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861330479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861330480} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330481} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330482} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861330483} = "黑龙江省牡丹江市";
$areanames{zh}->{861330484} = "黑龙江省哈尔滨市";
$areanames{zh}->{861330485} = "黑龙江省绥化市";
$areanames{zh}->{861330486} = "黑龙江省大庆市";
$areanames{zh}->{861330487} = "黑龙江省鸡西市";
$areanames{zh}->{861330488} = "黑龙江省双鸭山市";
$areanames{zh}->{861330489} = "黑龙江省大庆市";
$areanames{zh}->{861330490} = "辽宁省铁岭市";
$areanames{zh}->{861330491} = "辽宁省朝阳市";
$areanames{zh}->{861330492} = "辽宁省鞍山市";
$areanames{zh}->{861330493} = "辽宁省抚顺市";
$areanames{zh}->{861330494} = "辽宁省本溪市";
$areanames{zh}->{861330495} = "辽宁省丹东市";
$areanames{zh}->{861330496} = "辽宁省锦州市";
$areanames{zh}->{861330497} = "辽宁省营口市";
$areanames{zh}->{861330498} = "辽宁省阜新市";
$areanames{zh}->{861330499} = "辽宁省辽阳市";
$areanames{zh}->{861330500} = "福建省福州市";
$areanames{zh}->{861330501} = "福建省福州市";
$areanames{zh}->{861330502} = "福建省福州市";
$areanames{zh}->{861330503} = "福建省宁德市";
$areanames{zh}->{861330504} = "福建省莆田市";
$areanames{zh}->{861330505} = "福建省泉州市";
$areanames{zh}->{861330506} = "福建省泉州市";
$areanames{zh}->{861330507} = "福建省泉州市";
$areanames{zh}->{861330508} = "福建省泉州市";
$areanames{zh}->{861330509} = "福建省南平市";
$areanames{zh}->{86133051} = "江苏省南京市";
$areanames{zh}->{861330510} = "江苏省盐城市";
$areanames{zh}->{861330511} = "江苏省盐城市";
$areanames{zh}->{861330512} = "江苏省连云港市";
$areanames{zh}->{861330513} = "江苏省连云港市";
$areanames{zh}->{861330520} = "江苏省徐州市";
$areanames{zh}->{861330521} = "江苏省徐州市";
$areanames{zh}->{861330522} = "江苏省徐州市";
$areanames{zh}->{861330523} = "江苏省淮安市";
$areanames{zh}->{861330524} = "江苏省宿迁市";
$areanames{zh}->{861330525} = "江苏省扬州市";
$areanames{zh}->{861330526} = "江苏省泰州市";
$areanames{zh}->{861330527} = "江苏省扬州市";
$areanames{zh}->{861330528} = "江苏省镇江市";
$areanames{zh}->{861330529} = "江苏省镇江市";
$areanames{zh}->{861330530} = "山东省菏泽市";
$areanames{zh}->{861330531} = "山东省济南市";
$areanames{zh}->{861330532} = "山东省青岛市";
$areanames{zh}->{861330533} = "山东省淄博市";
$areanames{zh}->{861330534} = "山东省德州市";
$areanames{zh}->{861330535} = "山东省烟台市";
$areanames{zh}->{861330536} = "山东省潍坊市";
$areanames{zh}->{861330537} = "山东省济宁市";
$areanames{zh}->{861330538} = "山东省泰安市";
$areanames{zh}->{861330539} = "山东省临沂市";
$areanames{zh}->{861330540} = "山东省菏泽市";
$areanames{zh}->{861330541} = "山东省济南市";
$areanames{zh}->{861330542} = "山东省青岛市";
$areanames{zh}->{861330543} = "山东省滨州市";
$areanames{zh}->{861330544} = "山东省德州市";
$areanames{zh}->{861330545} = "山东省烟台市";
$areanames{zh}->{861330546} = "山东省东营市";
$areanames{zh}->{861330547} = "山东省济宁市";
$areanames{zh}->{861330548} = "山东省泰安市";
$areanames{zh}->{861330549} = "山东省临沂市";
$areanames{zh}->{861330550} = "安徽省滁州市";
$areanames{zh}->{861330551} = "安徽省合肥市";
$areanames{zh}->{861330552} = "安徽省蚌埠市";
$areanames{zh}->{861330553} = "安徽省芜湖市";
$areanames{zh}->{861330554} = "安徽省淮南市";
$areanames{zh}->{861330555} = "安徽省马鞍山市";
$areanames{zh}->{861330556} = "安徽省安庆市";
$areanames{zh}->{861330557} = "安徽省宿州市";
$areanames{zh}->{861330558} = "安徽省阜阳市";
$areanames{zh}->{861330559} = "安徽省黄山市";
$areanames{zh}->{861330560} = "安徽省合肥市";
$areanames{zh}->{861330561} = "安徽省淮北市";
$areanames{zh}->{861330562} = "安徽省铜陵市";
$areanames{zh}->{861330563} = "安徽省宣城市";
$areanames{zh}->{861330564} = "安徽省六安市";
$areanames{zh}->{861330565} = "安徽省巢湖市";
$areanames{zh}->{861330566} = "安徽省池州市";
$areanames{zh}->{861330567} = "安徽省宿州市";
$areanames{zh}->{861330568} = "安徽省阜阳市";
$areanames{zh}->{861330569} = "安徽省合肥市";
$areanames{zh}->{861330570} = "浙江省衢州市";
$areanames{zh}->{861330571} = "浙江省杭州市";
$areanames{zh}->{861330572} = "浙江省湖州市";
$areanames{zh}->{861330573} = "浙江省嘉兴市";
$areanames{zh}->{861330574} = "浙江省宁波市";
$areanames{zh}->{861330575} = "浙江省绍兴市";
$areanames{zh}->{861330576} = "浙江省台州市";
$areanames{zh}->{861330577} = "浙江省温州市";
$areanames{zh}->{861330578} = "浙江省丽水市";
$areanames{zh}->{861330579} = "浙江省金华市";
$areanames{zh}->{861330580} = "浙江省舟山市";
$areanames{zh}->{861330581} = "浙江省杭州市";
$areanames{zh}->{861330582} = "浙江省湖州市";
$areanames{zh}->{861330583} = "浙江省嘉兴市";
$areanames{zh}->{861330584} = "浙江省宁波市";
$areanames{zh}->{861330585} = "浙江省绍兴市";
$areanames{zh}->{861330586} = "浙江省台州市";
$areanames{zh}->{861330587} = "浙江省温州市";
$areanames{zh}->{861330588} = "浙江省丽水市";
$areanames{zh}->{861330589} = "浙江省金华市";
$areanames{zh}->{861330590} = "福建省福州市";
$areanames{zh}->{861330591} = "福建省福州市";
$areanames{zh}->{861330592} = "福建省福州市";
$areanames{zh}->{861330593} = "福建省宁德市";
$areanames{zh}->{861330594} = "福建省莆田市";
$areanames{zh}->{861330595} = "福建省泉州市";
$areanames{zh}->{861330596} = "福建省泉州市";
$areanames{zh}->{861330597} = "福建省泉州市";
$areanames{zh}->{861330598} = "福建省泉州市";
$areanames{zh}->{861330599} = "福建省南平市";
$areanames{zh}->{86133060} = "福建省厦门市";
$areanames{zh}->{861330606} = "福建省漳州市";
$areanames{zh}->{861330607} = "福建省龙岩市";
$areanames{zh}->{861330608} = "福建省三明市";
$areanames{zh}->{861330609} = "福建省泉州市";
$areanames{zh}->{861330610} = "江苏省镇江市";
$areanames{zh}->{861330611} = "江苏省常州市";
$areanames{zh}->{861330612} = "江苏省常州市";
$areanames{zh}->{861330613} = "江苏省苏州市";
$areanames{zh}->{861330614} = "江苏省常州市";
$areanames{zh}->{861330615} = "江苏省无锡市";
$areanames{zh}->{861330616} = "江苏省无锡市";
$areanames{zh}->{861330617} = "江苏省无锡市";
$areanames{zh}->{861330618} = "江苏省无锡市";
$areanames{zh}->{861330619} = "江苏省无锡市";
$areanames{zh}->{86133062} = "江苏省苏州市";
$areanames{zh}->{861330627} = "江苏省南通市";
$areanames{zh}->{861330628} = "江苏省南通市";
$areanames{zh}->{861330629} = "江苏省南通市";
$areanames{zh}->{861330630} = "山东省威海市";
$areanames{zh}->{861330631} = "山东省威海市";
$areanames{zh}->{861330632} = "山东省枣庄市";
$areanames{zh}->{861330633} = "山东省日照市";
$areanames{zh}->{861330634} = "山东省莱芜市";
$areanames{zh}->{861330635} = "山东省聊城市";
$areanames{zh}->{861330636} = "山东省潍坊市";
$areanames{zh}->{861330637} = "山东省枣庄市";
$areanames{zh}->{861330638} = "山东省烟台市";
$areanames{zh}->{861330639} = "山东省青岛市";
$areanames{zh}->{861330640} = "山东省济南市";
$areanames{zh}->{861330641} = "山东省济南市";
$areanames{zh}->{861330642} = "山东省青岛市";
$areanames{zh}->{861330643} = "山东省淄博市";
$areanames{zh}->{861330644} = "山东省济南市";
$areanames{zh}->{861330645} = "山东省烟台市";
$areanames{zh}->{861330646} = "山东省潍坊市";
$areanames{zh}->{861330647} = "山东省东营市";
$areanames{zh}->{861330648} = "山东省青岛市";
$areanames{zh}->{861330649} = "山东省滨州市";
$areanames{zh}->{86133065} = "浙江省台州市";
$areanames{zh}->{861330650} = "浙江省杭州市";
$areanames{zh}->{861330651} = "浙江省杭州市";
$areanames{zh}->{861330652} = "浙江省杭州市";
$areanames{zh}->{861330653} = "浙江省杭州市";
$areanames{zh}->{86133066} = "浙江省宁波市";
$areanames{zh}->{861330670} = "浙江省衢州市";
$areanames{zh}->{861330671} = "浙江省杭州市";
$areanames{zh}->{861330672} = "浙江省湖州市";
$areanames{zh}->{861330673} = "浙江省嘉兴市";
$areanames{zh}->{861330674} = "浙江省宁波市";
$areanames{zh}->{861330675} = "浙江省绍兴市";
$areanames{zh}->{861330676} = "浙江省台州市";
$areanames{zh}->{861330677} = "浙江省温州市";
$areanames{zh}->{861330678} = "浙江省丽水市";
$areanames{zh}->{861330679} = "浙江省金华市";
$areanames{zh}->{861330680} = "浙江省舟山市";
$areanames{zh}->{861330681} = "浙江省杭州市";
$areanames{zh}->{861330682} = "浙江省湖州市";
$areanames{zh}->{861330683} = "浙江省嘉兴市";
$areanames{zh}->{861330684} = "浙江省宁波市";
$areanames{zh}->{861330685} = "浙江省绍兴市";
$areanames{zh}->{861330686} = "浙江省台州市";
$areanames{zh}->{861330687} = "浙江省温州市";
$areanames{zh}->{861330688} = "浙江省丽水市";
$areanames{zh}->{861330689} = "浙江省金华市";
$areanames{zh}->{861330690} = "福建省福州市";
$areanames{zh}->{861330691} = "福建省福州市";
$areanames{zh}->{861330692} = "福建省福州市";
$areanames{zh}->{861330693} = "福建省福州市";
$areanames{zh}->{861330694} = "福建省漳州市";
$areanames{zh}->{861330695} = "福建省漳州市";
$areanames{zh}->{861330696} = "福建省漳州市";
$areanames{zh}->{861330697} = "福建省龙岩市";
$areanames{zh}->{861330698} = "福建省三明市";
$areanames{zh}->{861330699} = "福建省泉州市";
$areanames{zh}->{861330700} = "江西省南昌市";
$areanames{zh}->{861330701} = "江西省鹰潭市";
$areanames{zh}->{861330702} = "江西省九江市";
$areanames{zh}->{861330703} = "江西省上饶市";
$areanames{zh}->{861330704} = "江西省抚州市";
$areanames{zh}->{861330705} = "江西省宜春市";
$areanames{zh}->{861330706} = "江西省吉安市";
$areanames{zh}->{861330707} = "江西省赣州市";
$areanames{zh}->{861330708} = "江西省南昌市";
$areanames{zh}->{861330709} = "江西省南昌市";
$areanames{zh}->{86133071} = "湖北省武汉市";
$areanames{zh}->{861330720} = "湖北省宜昌市";
$areanames{zh}->{861330721} = "湖北省荆州市";
$areanames{zh}->{861330722} = "湖北省仙桃市";
$areanames{zh}->{861330723} = "湖北省黄石市";
$areanames{zh}->{861330724} = "湖北省咸宁市";
$areanames{zh}->{861330725} = "湖北省黄冈市";
$areanames{zh}->{861330726} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861330727} = "湖北省襄樊市";
$areanames{zh}->{861330728} = "湖北省十堰市";
$areanames{zh}->{861330729} = "湖北省孝感市";
$areanames{zh}->{861330730} = "湖南省岳阳市";
$areanames{zh}->{861330731} = "湖南省长沙市";
$areanames{zh}->{861330732} = "湖南省湘潭市";
$areanames{zh}->{861330733} = "湖南省株洲市";
$areanames{zh}->{861330734} = "湖南省衡阳市";
$areanames{zh}->{861330735} = "湖南省郴州市";
$areanames{zh}->{861330736} = "湖南省常德市";
$areanames{zh}->{861330737} = "湖南省益阳市";
$areanames{zh}->{861330738} = "湖南省娄底市";
$areanames{zh}->{861330739} = "湖南省邵阳市";
$areanames{zh}->{861330740} = "湖南省岳阳市";
$areanames{zh}->{861330741} = "湖南省株洲市";
$areanames{zh}->{861330742} = "湖南省常德市";
$areanames{zh}->{861330743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861330744} = "湖南省张家界市";
$areanames{zh}->{861330745} = "湖南省怀化市";
$areanames{zh}->{861330746} = "湖南省永州市";
$areanames{zh}->{861330747} = "湖南省衡阳市";
$areanames{zh}->{861330748} = "湖南省长沙市";
$areanames{zh}->{861330749} = "湖南省长沙市";
$areanames{zh}->{86133075} = "海南省海口市";
$areanames{zh}->{86133076} = "海南省海口市";
$areanames{zh}->{861330770} = "广西防城港市";
$areanames{zh}->{861330771} = "广西南宁市";
$areanames{zh}->{861330772} = "广西柳州市";
$areanames{zh}->{861330773} = "广西桂林市";
$areanames{zh}->{861330774} = "广西梧州市";
$areanames{zh}->{861330775} = "广西玉林市";
$areanames{zh}->{861330776} = "广西百色市";
$areanames{zh}->{861330777} = "广西钦州市";
$areanames{zh}->{861330778} = "广西河池市";
$areanames{zh}->{861330779} = "广西北海市";
$areanames{zh}->{861330780} = "广西防城港市";
$areanames{zh}->{861330781} = "广西南宁市";
$areanames{zh}->{861330782} = "广西柳州市";
$areanames{zh}->{861330783} = "广西桂林市";
$areanames{zh}->{861330784} = "广西梧州市";
$areanames{zh}->{861330785} = "广西玉林市";
$areanames{zh}->{861330786} = "广西南宁市";
$areanames{zh}->{861330787} = "广西钦州市";
$areanames{zh}->{861330788} = "广西河池市";
$areanames{zh}->{861330789} = "广西北海市";
$areanames{zh}->{861330790} = "江西省新余市";
$areanames{zh}->{861330791} = "江西省南昌市";
$areanames{zh}->{861330792} = "江西省九江市";
$areanames{zh}->{861330793} = "江西省上饶市";
$areanames{zh}->{861330794} = "江西省抚州市";
$areanames{zh}->{861330795} = "江西省宜春市";
$areanames{zh}->{861330796} = "江西省吉安市";
$areanames{zh}->{861330797} = "江西省赣州市";
$areanames{zh}->{861330798} = "江西省景德镇市";
$areanames{zh}->{861330799} = "江西省萍乡市";
$areanames{zh}->{86133080} = "四川省成都市";
$areanames{zh}->{861330810} = "四川省德阳市";
$areanames{zh}->{861330811} = "四川省绵阳市";
$areanames{zh}->{861330812} = "四川省广元市";
$areanames{zh}->{861330813} = "四川省乐山市";
$areanames{zh}->{861330814} = "四川省攀枝花市";
$areanames{zh}->{861330815} = "四川省凉山彝族自治州";
$areanames{zh}->{861330816} = "四川省雅安市";
$areanames{zh}->{861330817} = "四川省成都市";
$areanames{zh}->{861330818} = "四川省成都市";
$areanames{zh}->{861330819} = "四川省成都市";
$areanames{zh}->{861330820} = "四川省成都市";
$areanames{zh}->{861330821} = "四川省成都市";
$areanames{zh}->{861330822} = "四川省成都市";
$areanames{zh}->{861330823} = "四川省成都市";
$areanames{zh}->{861330824} = "四川省达州市";
$areanames{zh}->{861330825} = "重庆市";
$areanames{zh}->{861330826} = "重庆市";
$areanames{zh}->{861330827} = "重庆市";
$areanames{zh}->{861330828} = "四川省广安市";
$areanames{zh}->{861330829} = "四川省巴中市";
$areanames{zh}->{86133083} = "重庆市";
$areanames{zh}->{86133084} = "湖南省长沙市";
$areanames{zh}->{861330850} = "贵州省贵阳市";
$areanames{zh}->{861330851} = "贵州省贵阳市";
$areanames{zh}->{861330852} = "贵州省遵义市";
$areanames{zh}->{861330853} = "贵州省安顺市";
$areanames{zh}->{861330854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861330855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861330856} = "贵州省铜仁地区";
$areanames{zh}->{861330857} = "贵州省毕节地区";
$areanames{zh}->{861330858} = "贵州省六盘水市";
$areanames{zh}->{861330859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861330860} = "湖北省宜昌市";
$areanames{zh}->{861330861} = "湖北省荆州市";
$areanames{zh}->{861330862} = "湖北省武汉市";
$areanames{zh}->{861330863} = "湖北省武汉市";
$areanames{zh}->{861330864} = "湖北省武汉市";
$areanames{zh}->{861330865} = "湖北省武汉市";
$areanames{zh}->{861330866} = "湖北省随州市";
$areanames{zh}->{861330867} = "湖北省襄樊市";
$areanames{zh}->{861330868} = "湖北省鄂州市";
$areanames{zh}->{861330869} = "湖北省荆门市";
$areanames{zh}->{861330870} = "云南省昭通市";
$areanames{zh}->{861330871} = "云南省昆明市";
$areanames{zh}->{861330872} = "云南省大理白族自治州";
$areanames{zh}->{861330873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861330874} = "云南省曲靖市";
$areanames{zh}->{861330875} = "云南省保山市";
$areanames{zh}->{861330876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861330877} = "云南省玉溪市";
$areanames{zh}->{861330878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861330879} = "云南省普洱市";
$areanames{zh}->{861330880} = "云南省昆明市";
$areanames{zh}->{861330881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861330882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861330883} = "云南省临沧市";
$areanames{zh}->{861330884} = "云南省昆明市";
$areanames{zh}->{861330885} = "云南省昆明市";
$areanames{zh}->{861330886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861330887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861330888} = "云南省丽江市";
$areanames{zh}->{861330889} = "云南省玉溪市";
$areanames{zh}->{861330890} = "西藏拉萨市";
$areanames{zh}->{861330891} = "西藏拉萨市";
$areanames{zh}->{861330892} = "西藏日喀则地区";
$areanames{zh}->{861330893} = "西藏山南地区";
$areanames{zh}->{861330894} = "西藏林芝地区";
$areanames{zh}->{861330895} = "西藏昌都地区";
$areanames{zh}->{861330896} = "西藏那曲地区";
$areanames{zh}->{861330897} = "西藏阿里地区";
$areanames{zh}->{861330898} = "西藏拉萨市";
$areanames{zh}->{861330899} = "西藏拉萨市";
$areanames{zh}->{861330900} = "四川省自贡市";
$areanames{zh}->{861330901} = "四川省绵阳市";
$areanames{zh}->{861330902} = "四川省德阳市";
$areanames{zh}->{861330903} = "四川省乐山市";
$areanames{zh}->{861330904} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861330905} = "四川省内江市";
$areanames{zh}->{861330906} = "四川省遂宁市";
$areanames{zh}->{861330907} = "四川省南充市";
$areanames{zh}->{861330908} = "四川省泸州市";
$areanames{zh}->{861330909} = "四川省宜宾市";
$areanames{zh}->{861330910} = "陕西省咸阳市";
$areanames{zh}->{861330911} = "陕西省延安市";
$areanames{zh}->{861330912} = "陕西省榆林市";
$areanames{zh}->{861330913} = "陕西省渭南市";
$areanames{zh}->{861330914} = "陕西省商洛市";
$areanames{zh}->{861330915} = "陕西省安康市";
$areanames{zh}->{861330916} = "陕西省汉中市";
$areanames{zh}->{861330917} = "陕西省宝鸡市";
$areanames{zh}->{861330918} = "陕西省西安市";
$areanames{zh}->{861330919} = "陕西省铜川市";
$areanames{zh}->{86133092} = "陕西省西安市";
$areanames{zh}->{861330930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861330931} = "甘肃省兰州市";
$areanames{zh}->{861330932} = "甘肃省定西市";
$areanames{zh}->{861330933} = "甘肃省平凉市";
$areanames{zh}->{861330934} = "甘肃省庆阳市";
$areanames{zh}->{861330935} = "甘肃省武威市";
$areanames{zh}->{861330936} = "甘肃省张掖市";
$areanames{zh}->{861330937} = "甘肃省酒泉市";
$areanames{zh}->{861330938} = "甘肃省天水市";
$areanames{zh}->{861330939} = "甘肃省陇南市";
$areanames{zh}->{86133094} = "甘肃省兰州市";
$areanames{zh}->{861330943} = "甘肃省白银市";
$areanames{zh}->{861330945} = "甘肃省金昌市";
$areanames{zh}->{861330947} = "甘肃省嘉峪关市";
$areanames{zh}->{861330950} = "宁夏银川市";
$areanames{zh}->{861330951} = "宁夏银川市";
$areanames{zh}->{861330952} = "宁夏石嘴山市";
$areanames{zh}->{861330953} = "宁夏吴忠市";
$areanames{zh}->{861330954} = "宁夏固原市";
$areanames{zh}->{861330955} = "宁夏吴忠市";
$areanames{zh}->{861330956} = "宁夏石嘴山市";
$areanames{zh}->{861330957} = "宁夏银川市";
$areanames{zh}->{861330958} = "宁夏银川市";
$areanames{zh}->{861330959} = "宁夏银川市";
$areanames{zh}->{861330960} = "安徽省滁州市";
$areanames{zh}->{861330961} = "安徽省淮北市";
$areanames{zh}->{861330962} = "安徽省蚌埠市";
$areanames{zh}->{861330963} = "安徽省芜湖市";
$areanames{zh}->{861330964} = "安徽省淮南市";
$areanames{zh}->{861330965} = "安徽省蚌埠市";
$areanames{zh}->{861330966} = "安徽省安庆市";
$areanames{zh}->{861330967} = "安徽省亳州市";
$areanames{zh}->{861330968} = "安徽省阜阳市";
$areanames{zh}->{861330969} = "安徽省合肥市";
$areanames{zh}->{861330970} = "青海省海北藏族自治州";
$areanames{zh}->{861330971} = "青海省西宁市";
$areanames{zh}->{861330972} = "青海省海东地区";
$areanames{zh}->{861330973} = "青海省黄南藏族自治州";
$areanames{zh}->{861330974} = "青海省海南藏族自治州";
$areanames{zh}->{861330975} = "青海省果洛藏族自治州";
$areanames{zh}->{861330976} = "青海省玉树藏族自治州";
$areanames{zh}->{861330977} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861330978} = "青海省西宁市";
$areanames{zh}->{861330979} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861330980} = "辽宁省鞍山市";
$areanames{zh}->{861330981} = "辽宁省沈阳市";
$areanames{zh}->{861330982} = "辽宁省沈阳市";
$areanames{zh}->{861330983} = "辽宁省沈阳市";
$areanames{zh}->{861330984} = "辽宁省大连市";
$areanames{zh}->{861330985} = "辽宁省大连市";
$areanames{zh}->{861330986} = "辽宁省大连市";
$areanames{zh}->{861330987} = "辽宁省盘锦市";
$areanames{zh}->{861330988} = "辽宁省沈阳市";
$areanames{zh}->{861330989} = "辽宁省葫芦岛市";
$areanames{zh}->{861330990} = "新疆克拉玛依市";
$areanames{zh}->{861330991} = "新疆乌鲁木齐市";
$areanames{zh}->{861330992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861330993} = "新疆石河子市";
$areanames{zh}->{861330994} = "新疆昌吉回族自治州";
$areanames{zh}->{861330995} = "新疆吐鲁番地区";
$areanames{zh}->{861330996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861330997} = "新疆阿克苏地区";
$areanames{zh}->{861330998} = "新疆喀什地区";
$areanames{zh}->{861330999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86133100} = "上海市";
$areanames{zh}->{86133101} = "上海市";
$areanames{zh}->{86133102} = "重庆市";
$areanames{zh}->{861331030} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331031} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331032} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331033} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331034} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331035} = "内蒙古通辽市";
$areanames{zh}->{861331036} = "内蒙古通辽市";
$areanames{zh}->{861331037} = "内蒙古通辽市";
$areanames{zh}->{861331038} = "内蒙古赤峰市";
$areanames{zh}->{861331039} = "内蒙古赤峰市";
$areanames{zh}->{861331040} = "贵州省贵阳市";
$areanames{zh}->{861331041} = "贵州省遵义市";
$areanames{zh}->{861331042} = "贵州省遵义市";
$areanames{zh}->{861331043} = "贵州省安顺市";
$areanames{zh}->{861331044} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331045} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331046} = "贵州省铜仁地区";
$areanames{zh}->{861331047} = "贵州省毕节地区";
$areanames{zh}->{861331048} = "贵州省遵义市";
$areanames{zh}->{861331049} = "贵州省遵义市";
$areanames{zh}->{861331050} = "湖北省荆门市";
$areanames{zh}->{861331051} = "湖北省荆门市";
$areanames{zh}->{861331052} = "湖北省荆门市";
$areanames{zh}->{861331053} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861331054} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861331055} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861331056} = "湖北省宜昌市";
$areanames{zh}->{861331057} = "湖北省宜昌市";
$areanames{zh}->{861331058} = "湖北省荆州市";
$areanames{zh}->{861331059} = "湖北省荆州市";
$areanames{zh}->{861331060} = "山东省德州市";
$areanames{zh}->{861331061} = "山东省济南市";
$areanames{zh}->{861331062} = "山东省聊城市";
$areanames{zh}->{861331063} = "山东省日照市";
$areanames{zh}->{861331064} = "山东省日照市";
$areanames{zh}->{861331065} = "山东省聊城市";
$areanames{zh}->{861331066} = "山东省青岛市";
$areanames{zh}->{861331067} = "山东省青岛市";
$areanames{zh}->{861331068} = "山东省枣庄市";
$areanames{zh}->{861331069} = "山东省枣庄市";
$areanames{zh}->{861331070} = "贵州省毕节地区";
$areanames{zh}->{861331071} = "贵州省铜仁地区";
$areanames{zh}->{861331072} = "贵州省遵义市";
$areanames{zh}->{861331073} = "贵州省安顺市";
$areanames{zh}->{861331074} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331075} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331076} = "贵州省铜仁地区";
$areanames{zh}->{861331077} = "贵州省毕节地区";
$areanames{zh}->{861331078} = "贵州省六盘水市";
$areanames{zh}->{861331079} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861331080} = "广东省东莞市";
$areanames{zh}->{861331081} = "广东省东莞市";
$areanames{zh}->{861331082} = "广东省东莞市";
$areanames{zh}->{861331083} = "广东省深圳市";
$areanames{zh}->{861331084} = "广东省深圳市";
$areanames{zh}->{861331085} = "广东省深圳市";
$areanames{zh}->{861331086} = "广东省深圳市";
$areanames{zh}->{861331087} = "广东省深圳市";
$areanames{zh}->{861331088} = "广东省广州市";
$areanames{zh}->{861331089} = "广东省广州市";
$areanames{zh}->{861331090} = "陕西省咸阳市";
$areanames{zh}->{861331091} = "陕西省延安市";
$areanames{zh}->{861331092} = "陕西省榆林市";
$areanames{zh}->{861331093} = "陕西省渭南市";
$areanames{zh}->{861331094} = "陕西省西安市";
$areanames{zh}->{861331095} = "陕西省安康市";
$areanames{zh}->{861331096} = "陕西省汉中市";
$areanames{zh}->{861331097} = "陕西省西安市";
$areanames{zh}->{861331098} = "陕西省西安市";
$areanames{zh}->{861331099} = "陕西省榆林市";
$areanames{zh}->{8613311} = "北京市";
$areanames{zh}->{86133116} = "上海市";
$areanames{zh}->{86133117} = "上海市";
$areanames{zh}->{86133118} = "上海市";
$areanames{zh}->{86133119} = "上海市";
$areanames{zh}->{86133120} = "天津市";
$areanames{zh}->{86133121} = "天津市";
$areanames{zh}->{86133122} = "贵州省贵阳市";
$areanames{zh}->{861331229} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86133123} = "贵州省遵义市";
$areanames{zh}->{861331236} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331237} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331238} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331239} = "贵州省六盘水市";
$areanames{zh}->{861331240} = "贵州省安顺市";
$areanames{zh}->{861331241} = "贵州省安顺市";
$areanames{zh}->{861331242} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331243} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331244} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331245} = "贵州省铜仁地区";
$areanames{zh}->{861331246} = "贵州省六盘水市";
$areanames{zh}->{861331247} = "贵州省毕节地区";
$areanames{zh}->{861331248} = "贵州省毕节地区";
$areanames{zh}->{861331249} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{86133125} = "云南省昆明市";
$areanames{zh}->{861331260} = "云南省楚雄彝族自治州";
$areanames{zh}->{861331261} = "云南省楚雄彝族自治州";
$areanames{zh}->{861331262} = "云南省曲靖市";
$areanames{zh}->{861331263} = "云南省曲靖市";
$areanames{zh}->{861331264} = "云南省玉溪市";
$areanames{zh}->{861331265} = "云南省玉溪市";
$areanames{zh}->{861331266} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861331267} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861331268} = "云南省昭通市";
$areanames{zh}->{861331269} = "云南省丽江市";
$areanames{zh}->{861331270} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861331271} = "云南省临沧市";
$areanames{zh}->{861331272} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861331273} = "云南省迪庆藏族自治州";
$areanames{zh}->{861331274} = "云南省大理白族自治州";
$areanames{zh}->{861331275} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861331276} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861331277} = "云南省普洱市";
$areanames{zh}->{861331278} = "云南省大理白族自治州";
$areanames{zh}->{861331279} = "云南省保山市";
$areanames{zh}->{86133128} = "广东省广州市";
$areanames{zh}->{86133129} = "广东省深圳市";
$areanames{zh}->{861331300} = "河北省邯郸市";
$areanames{zh}->{861331301} = "河北省石家庄市";
$areanames{zh}->{861331302} = "河北省保定市";
$areanames{zh}->{861331303} = "河北省石家庄市";
$areanames{zh}->{861331304} = "河北省石家庄市";
$areanames{zh}->{861331305} = "河北省唐山市";
$areanames{zh}->{861331306} = "河北省廊坊市";
$areanames{zh}->{861331307} = "河北省沧州市";
$areanames{zh}->{861331308} = "河北省衡水市";
$areanames{zh}->{861331309} = "河北省邢台市";
$areanames{zh}->{861331310} = "河北省邯郸市";
$areanames{zh}->{861331311} = "河北省石家庄市";
$areanames{zh}->{861331312} = "河北省保定市";
$areanames{zh}->{861331313} = "河北省张家口市";
$areanames{zh}->{861331314} = "河北省承德市";
$areanames{zh}->{861331315} = "河北省唐山市";
$areanames{zh}->{861331316} = "河北省廊坊市";
$areanames{zh}->{861331317} = "河北省沧州市";
$areanames{zh}->{861331318} = "河北省衡水市";
$areanames{zh}->{861331319} = "河北省邢台市";
$areanames{zh}->{861331320} = "河北省邯郸市";
$areanames{zh}->{861331321} = "河北省石家庄市";
$areanames{zh}->{861331322} = "河北省保定市";
$areanames{zh}->{861331323} = "河北省保定市";
$areanames{zh}->{861331324} = "河北省保定市";
$areanames{zh}->{861331325} = "河北省唐山市";
$areanames{zh}->{861331326} = "河北省廊坊市";
$areanames{zh}->{861331327} = "河北省沧州市";
$areanames{zh}->{861331328} = "河北省承德市";
$areanames{zh}->{861331329} = "河北省唐山市";
$areanames{zh}->{861331330} = "河北省邯郸市";
$areanames{zh}->{861331331} = "河北省石家庄市";
$areanames{zh}->{861331332} = "河北省保定市";
$areanames{zh}->{861331333} = "河北省秦皇岛市";
$areanames{zh}->{861331334} = "河北省秦皇岛市";
$areanames{zh}->{861331335} = "河北省秦皇岛市";
$areanames{zh}->{861331336} = "河北省廊坊市";
$areanames{zh}->{861331337} = "河北省沧州市";
$areanames{zh}->{861331338} = "河北省承德市";
$areanames{zh}->{861331339} = "河北省邢台市";
$areanames{zh}->{861331340} = "山西省忻州市";
$areanames{zh}->{861331341} = "山西省太原市";
$areanames{zh}->{861331342} = "山西省大同市";
$areanames{zh}->{861331343} = "山西省太原市";
$areanames{zh}->{861331344} = "山西省晋中市";
$areanames{zh}->{861331345} = "山西省长治市";
$areanames{zh}->{861331346} = "山西省晋城市";
$areanames{zh}->{861331347} = "山西省临汾市";
$areanames{zh}->{861331348} = "山西省运城市";
$areanames{zh}->{861331349} = "山西省朔州市";
$areanames{zh}->{861331350} = "山西省忻州市";
$areanames{zh}->{861331351} = "山西省太原市";
$areanames{zh}->{861331352} = "山西省大同市";
$areanames{zh}->{861331353} = "山西省阳泉市";
$areanames{zh}->{861331354} = "山西省晋中市";
$areanames{zh}->{861331355} = "山西省长治市";
$areanames{zh}->{861331356} = "山西省晋城市";
$areanames{zh}->{861331357} = "山西省临汾市";
$areanames{zh}->{861331358} = "山西省吕梁市";
$areanames{zh}->{861331359} = "山西省运城市";
$areanames{zh}->{86133136} = "黑龙江省哈尔滨市";
$areanames{zh}->{861331370} = "福建省厦门市";
$areanames{zh}->{861331371} = "福建省宁德市";
$areanames{zh}->{861331372} = "福建省宁德市";
$areanames{zh}->{861331373} = "福建省三明市";
$areanames{zh}->{861331374} = "福建省泉州市";
$areanames{zh}->{861331375} = "福建省福州市";
$areanames{zh}->{861331376} = "福建省福州市";
$areanames{zh}->{861331377} = "福建省福州市";
$areanames{zh}->{861331378} = "福建省福州市";
$areanames{zh}->{861331379} = "福建省南平市";
$areanames{zh}->{861331380} = "福建省三明市";
$areanames{zh}->{861331381} = "福建省三明市";
$areanames{zh}->{861331382} = "福建省泉州市";
$areanames{zh}->{861331383} = "福建省泉州市";
$areanames{zh}->{861331384} = "福建省厦门市";
$areanames{zh}->{861331385} = "福建省厦门市";
$areanames{zh}->{861331386} = "福建省厦门市";
$areanames{zh}->{861331387} = "福建省泉州市";
$areanames{zh}->{861331388} = "福建省泉州市";
$areanames{zh}->{861331389} = "福建省泉州市";
$areanames{zh}->{861331390} = "福建省南平市";
$areanames{zh}->{861331391} = "福建省南平市";
$areanames{zh}->{861331392} = "福建省龙岩市";
$areanames{zh}->{861331393} = "福建省龙岩市";
$areanames{zh}->{861331394} = "福建省福州市";
$areanames{zh}->{861331395} = "福建省莆田市";
$areanames{zh}->{861331396} = "福建省莆田市";
$areanames{zh}->{861331397} = "福建省福州市";
$areanames{zh}->{861331398} = "福建省福州市";
$areanames{zh}->{861331399} = "福建省龙岩市";
$areanames{zh}->{861331400} = "辽宁省沈阳市";
$areanames{zh}->{861331401} = "辽宁省沈阳市";
$areanames{zh}->{861331402} = "辽宁省沈阳市";
$areanames{zh}->{861331403} = "辽宁省鞍山市";
$areanames{zh}->{861331404} = "辽宁省鞍山市";
$areanames{zh}->{861331405} = "辽宁省辽阳市";
$areanames{zh}->{861331406} = "辽宁省营口市";
$areanames{zh}->{861331407} = "辽宁省营口市";
$areanames{zh}->{861331408} = "辽宁省丹东市";
$areanames{zh}->{861331409} = "辽宁省葫芦岛市";
$areanames{zh}->{861331410} = "辽宁省铁岭市";
$areanames{zh}->{861331411} = "辽宁省大连市";
$areanames{zh}->{861331412} = "辽宁省鞍山市";
$areanames{zh}->{861331413} = "辽宁省抚顺市";
$areanames{zh}->{861331414} = "辽宁省本溪市";
$areanames{zh}->{861331415} = "辽宁省丹东市";
$areanames{zh}->{861331416} = "辽宁省锦州市";
$areanames{zh}->{861331417} = "辽宁省营口市";
$areanames{zh}->{861331418} = "辽宁省阜新市";
$areanames{zh}->{861331419} = "辽宁省辽阳市";
$areanames{zh}->{861331420} = "辽宁省沈阳市";
$areanames{zh}->{861331421} = "辽宁省朝阳市";
$areanames{zh}->{861331422} = "辽宁省沈阳市";
$areanames{zh}->{861331423} = "辽宁省沈阳市";
$areanames{zh}->{861331424} = "辽宁省沈阳市";
$areanames{zh}->{861331425} = "辽宁省鞍山市";
$areanames{zh}->{861331426} = "辽宁省大连市";
$areanames{zh}->{861331427} = "辽宁省盘锦市";
$areanames{zh}->{861331428} = "辽宁省大连市";
$areanames{zh}->{861331429} = "辽宁省葫芦岛市";
$areanames{zh}->{861331430} = "吉林省长春市";
$areanames{zh}->{861331431} = "吉林省长春市";
$areanames{zh}->{861331432} = "吉林省吉林市";
$areanames{zh}->{861331433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861331434} = "吉林省四平市";
$areanames{zh}->{861331435} = "吉林省通化市";
$areanames{zh}->{861331436} = "吉林省吉林市";
$areanames{zh}->{861331437} = "吉林省吉林市";
$areanames{zh}->{861331438} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861331439} = "吉林省长春市";
$areanames{zh}->{861331440} = "贵州省遵义市";
$areanames{zh}->{861331441} = "贵州省遵义市";
$areanames{zh}->{861331442} = "贵州省遵义市";
$areanames{zh}->{861331443} = "贵州省遵义市";
$areanames{zh}->{861331444} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331445} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861331446} = "贵州省铜仁地区";
$areanames{zh}->{861331447} = "贵州省毕节地区";
$areanames{zh}->{861331448} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861331449} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861331450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861331451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861331452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861331453} = "黑龙江省牡丹江市";
$areanames{zh}->{861331454} = "黑龙江省佳木斯市";
$areanames{zh}->{861331455} = "黑龙江省绥化市";
$areanames{zh}->{861331456} = "黑龙江省黑河市";
$areanames{zh}->{861331457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861331458} = "黑龙江省伊春市";
$areanames{zh}->{861331459} = "黑龙江省大庆市";
$areanames{zh}->{861331460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861331461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861331462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861331463} = "黑龙江省牡丹江市";
$areanames{zh}->{861331464} = "黑龙江省七台河市";
$areanames{zh}->{861331465} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861331466} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861331467} = "黑龙江省鸡西市";
$areanames{zh}->{861331468} = "黑龙江省鹤岗市";
$areanames{zh}->{861331469} = "黑龙江省双鸭山市";
$areanames{zh}->{861331470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861331471} = "内蒙古呼和浩特市";
$areanames{zh}->{861331472} = "内蒙古包头市";
$areanames{zh}->{861331473} = "内蒙古乌海市";
$areanames{zh}->{861331474} = "内蒙古兴安盟";
$areanames{zh}->{861331475} = "内蒙古通辽市";
$areanames{zh}->{861331476} = "内蒙古赤峰市";
$areanames{zh}->{861331477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861331478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861331479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861331480} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861331481} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861331482} = "内蒙古兴安盟";
$areanames{zh}->{861331483} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861331484} = "内蒙古包头市";
$areanames{zh}->{861331485} = "内蒙古包头市";
$areanames{zh}->{861331486} = "内蒙古包头市";
$areanames{zh}->{861331487} = "内蒙古呼和浩特市";
$areanames{zh}->{861331488} = "内蒙古呼和浩特市";
$areanames{zh}->{861331489} = "内蒙古呼和浩特市";
$areanames{zh}->{86133149} = "福建省福州市";
$areanames{zh}->{861331496} = "福建省泉州市";
$areanames{zh}->{861331497} = "福建省泉州市";
$areanames{zh}->{861331498} = "福建省泉州市";
$areanames{zh}->{861331499} = "福建省泉州市";
$areanames{zh}->{86133150} = "河北省邯郸市";
$areanames{zh}->{86133151} = "河北省石家庄市";
$areanames{zh}->{86133152} = "河北省保定市";
$areanames{zh}->{861331530} = "河北省张家口市";
$areanames{zh}->{861331531} = "河北省张家口市";
$areanames{zh}->{861331532} = "河北省张家口市";
$areanames{zh}->{861331533} = "河北省张家口市";
$areanames{zh}->{861331534} = "河北省张家口市";
$areanames{zh}->{861331535} = "河北省秦皇岛市";
$areanames{zh}->{861331536} = "河北省秦皇岛市";
$areanames{zh}->{861331537} = "河北省秦皇岛市";
$areanames{zh}->{861331538} = "河北省秦皇岛市";
$areanames{zh}->{861331539} = "河北省秦皇岛市";
$areanames{zh}->{861331540} = "河北省保定市";
$areanames{zh}->{861331541} = "河北省保定市";
$areanames{zh}->{861331542} = "河北省保定市";
$areanames{zh}->{861331543} = "河北省保定市";
$areanames{zh}->{861331544} = "河北省保定市";
$areanames{zh}->{861331545} = "河北省石家庄市";
$areanames{zh}->{861331546} = "河北省石家庄市";
$areanames{zh}->{861331547} = "河北省石家庄市";
$areanames{zh}->{861331548} = "河北省石家庄市";
$areanames{zh}->{861331549} = "河北省石家庄市";
$areanames{zh}->{86133155} = "河北省唐山市";
$areanames{zh}->{861331560} = "河北省廊坊市";
$areanames{zh}->{861331561} = "河北省廊坊市";
$areanames{zh}->{861331562} = "河北省廊坊市";
$areanames{zh}->{861331563} = "河北省廊坊市";
$areanames{zh}->{861331564} = "河北省廊坊市";
$areanames{zh}->{861331565} = "河北省秦皇岛市";
$areanames{zh}->{861331566} = "河北省秦皇岛市";
$areanames{zh}->{861331567} = "河北省秦皇岛市";
$areanames{zh}->{861331568} = "河北省秦皇岛市";
$areanames{zh}->{861331569} = "河北省秦皇岛市";
$areanames{zh}->{86133157} = "河北省沧州市";
$areanames{zh}->{86133158} = "河北省衡水市";
$areanames{zh}->{861331587} = "河北省承德市";
$areanames{zh}->{861331588} = "河北省承德市";
$areanames{zh}->{861331589} = "河北省承德市";
$areanames{zh}->{861331590} = "河北省邢台市";
$areanames{zh}->{861331591} = "河北省邢台市";
$areanames{zh}->{861331592} = "河北省邢台市";
$areanames{zh}->{861331593} = "河北省邢台市";
$areanames{zh}->{861331594} = "河北省邢台市";
$areanames{zh}->{861331595} = "河北省石家庄市";
$areanames{zh}->{861331596} = "河北省石家庄市";
$areanames{zh}->{861331597} = "河北省石家庄市";
$areanames{zh}->{861331598} = "河北省石家庄市";
$areanames{zh}->{861331599} = "河北省石家庄市";
$areanames{zh}->{86133160} = "广东省广州市";
$areanames{zh}->{86133161} = "广东省广州市";
$areanames{zh}->{86133162} = "广东省广州市";
$areanames{zh}->{86133163} = "广东省惠州市";
$areanames{zh}->{861331630} = "广东省佛山市";
$areanames{zh}->{861331631} = "广东省佛山市";
$areanames{zh}->{861331632} = "广东省佛山市";
$areanames{zh}->{86133164} = "广东省深圳市";
$areanames{zh}->{86133165} = "广东省深圳市";
$areanames{zh}->{86133166} = "广东省东莞市";
$areanames{zh}->{86133167} = "广东省江门市";
$areanames{zh}->{861331677} = "广东省惠州市";
$areanames{zh}->{861331678} = "广东省惠州市";
$areanames{zh}->{861331679} = "广东省惠州市";
$areanames{zh}->{86133168} = "广东省深圳市";
$areanames{zh}->{86133169} = "广东省深圳市";
$areanames{zh}->{861331700} = "江西省南昌市";
$areanames{zh}->{861331701} = "江西省鹰潭市";
$areanames{zh}->{861331702} = "江西省九江市";
$areanames{zh}->{861331703} = "江西省上饶市";
$areanames{zh}->{861331704} = "江西省吉安市";
$areanames{zh}->{861331705} = "江西省南昌市";
$areanames{zh}->{861331706} = "江西省吉安市";
$areanames{zh}->{861331707} = "江西省赣州市";
$areanames{zh}->{861331708} = "江西省赣州市";
$areanames{zh}->{861331709} = "江西省萍乡市";
$areanames{zh}->{86133171} = "湖北省武汉市";
$areanames{zh}->{861331720} = "湖北省宜昌市";
$areanames{zh}->{861331721} = "湖北省荆州市";
$areanames{zh}->{861331722} = "湖北省荆州市";
$areanames{zh}->{861331723} = "湖北省黄石市";
$areanames{zh}->{861331724} = "湖北省咸宁市";
$areanames{zh}->{861331725} = "湖北省黄冈市";
$areanames{zh}->{861331726} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861331727} = "湖北省襄樊市";
$areanames{zh}->{861331728} = "湖北省十堰市";
$areanames{zh}->{861331729} = "湖北省十堰市";
$areanames{zh}->{861331730} = "湖南省岳阳市";
$areanames{zh}->{861331731} = "湖南省长沙市";
$areanames{zh}->{861331732} = "湖南省湘潭市";
$areanames{zh}->{861331733} = "湖南省株洲市";
$areanames{zh}->{861331734} = "湖南省衡阳市";
$areanames{zh}->{861331735} = "湖南省郴州市";
$areanames{zh}->{861331736} = "湖南省常德市";
$areanames{zh}->{861331737} = "湖南省益阳市";
$areanames{zh}->{861331738} = "湖南省娄底市";
$areanames{zh}->{861331739} = "湖南省邵阳市";
$areanames{zh}->{861331740} = "湖南省岳阳市";
$areanames{zh}->{861331741} = "湖南省株洲市";
$areanames{zh}->{861331742} = "湖南省湘潭市";
$areanames{zh}->{861331743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861331744} = "湖南省张家界市";
$areanames{zh}->{861331745} = "湖南省怀化市";
$areanames{zh}->{861331746} = "湖南省永州市";
$areanames{zh}->{861331747} = "湖南省衡阳市";
$areanames{zh}->{861331748} = "湖南省长沙市";
$areanames{zh}->{861331749} = "湖南省长沙市";
$areanames{zh}->{861331750} = "湖北省黄冈市";
$areanames{zh}->{861331751} = "湖北省荆门市";
$areanames{zh}->{861331752} = "湖北省荆门市";
$areanames{zh}->{861331753} = "湖北省襄樊市";
$areanames{zh}->{861331754} = "湖北省襄樊市";
$areanames{zh}->{861331755} = "湖北省襄樊市";
$areanames{zh}->{861331756} = "湖北省宜昌市";
$areanames{zh}->{861331757} = "湖北省宜昌市";
$areanames{zh}->{861331758} = "湖北省荆州市";
$areanames{zh}->{861331759} = "湖北省随州市";
$areanames{zh}->{861331760} = "广西防城港市";
$areanames{zh}->{861331761} = "广西南宁市";
$areanames{zh}->{861331762} = "广西柳州市";
$areanames{zh}->{861331763} = "广西桂林市";
$areanames{zh}->{861331764} = "广西梧州市";
$areanames{zh}->{861331765} = "广西玉林市";
$areanames{zh}->{861331766} = "广西百色市";
$areanames{zh}->{861331767} = "广西钦州市";
$areanames{zh}->{861331768} = "广西河池市";
$areanames{zh}->{861331769} = "广西北海市";
$areanames{zh}->{861331770} = "广西防城港市";
$areanames{zh}->{861331771} = "广西南宁市";
$areanames{zh}->{861331772} = "广西柳州市";
$areanames{zh}->{861331773} = "广西桂林市";
$areanames{zh}->{861331774} = "广西梧州市";
$areanames{zh}->{861331775} = "广西玉林市";
$areanames{zh}->{861331776} = "广西百色市";
$areanames{zh}->{861331777} = "广西钦州市";
$areanames{zh}->{861331778} = "广西河池市";
$areanames{zh}->{861331779} = "广西北海市";
$areanames{zh}->{861331780} = "广西南宁市";
$areanames{zh}->{861331781} = "广西南宁市";
$areanames{zh}->{861331782} = "广西柳州市";
$areanames{zh}->{861331783} = "广西桂林市";
$areanames{zh}->{861331784} = "广西梧州市";
$areanames{zh}->{861331785} = "广西玉林市";
$areanames{zh}->{861331786} = "广西南宁市";
$areanames{zh}->{861331787} = "广西钦州市";
$areanames{zh}->{861331788} = "广西柳州市";
$areanames{zh}->{861331789} = "广西北海市";
$areanames{zh}->{861331790} = "江西省新余市";
$areanames{zh}->{861331791} = "江西省南昌市";
$areanames{zh}->{861331792} = "江西省九江市";
$areanames{zh}->{861331793} = "江西省上饶市";
$areanames{zh}->{861331794} = "江西省抚州市";
$areanames{zh}->{861331795} = "江西省宜春市";
$areanames{zh}->{861331796} = "江西省吉安市";
$areanames{zh}->{861331797} = "江西省赣州市";
$areanames{zh}->{861331798} = "江西省景德镇市";
$areanames{zh}->{861331799} = "江西省萍乡市";
$areanames{zh}->{86133180} = "广东省汕头市";
$areanames{zh}->{861331801} = "广东省湛江市";
$areanames{zh}->{861331802} = "广东省湛江市";
$areanames{zh}->{861331803} = "广东省湛江市";
$areanames{zh}->{861331804} = "广东省湛江市";
$areanames{zh}->{861331810} = "广东省肇庆市";
$areanames{zh}->{861331811} = "广东省肇庆市";
$areanames{zh}->{861331812} = "广东省梅州市";
$areanames{zh}->{861331813} = "广东省梅州市";
$areanames{zh}->{861331814} = "广东省梅州市";
$areanames{zh}->{861331815} = "广东省梅州市";
$areanames{zh}->{861331816} = "广东省梅州市";
$areanames{zh}->{861331817} = "广东省揭阳市";
$areanames{zh}->{861331818} = "广东省揭阳市";
$areanames{zh}->{861331819} = "广东省揭阳市";
$areanames{zh}->{861331820} = "广东省佛山市";
$areanames{zh}->{861331821} = "广东省佛山市";
$areanames{zh}->{861331822} = "广东省佛山市";
$areanames{zh}->{861331823} = "广东省河源市";
$areanames{zh}->{861331824} = "广东省河源市";
$areanames{zh}->{861331825} = "广东省中山市";
$areanames{zh}->{861331826} = "广东省中山市";
$areanames{zh}->{861331827} = "广东省中山市";
$areanames{zh}->{861331828} = "广东省中山市";
$areanames{zh}->{861331829} = "广东省中山市";
$areanames{zh}->{86133183} = "广东省佛山市";
$areanames{zh}->{861331840} = "广东省中山市";
$areanames{zh}->{861331841} = "广东省中山市";
$areanames{zh}->{861331842} = "广东省中山市";
$areanames{zh}->{861331843} = "广东省东莞市";
$areanames{zh}->{861331844} = "广东省东莞市";
$areanames{zh}->{861331845} = "广东省东莞市";
$areanames{zh}->{861331846} = "广东省东莞市";
$areanames{zh}->{861331847} = "广东省珠海市";
$areanames{zh}->{861331848} = "广东省珠海市";
$areanames{zh}->{861331849} = "广东省珠海市";
$areanames{zh}->{861331850} = "广东省茂名市";
$areanames{zh}->{861331851} = "广东省茂名市";
$areanames{zh}->{861331852} = "广东省茂名市";
$areanames{zh}->{861331853} = "广东省茂名市";
$areanames{zh}->{861331854} = "广东省阳江市";
$areanames{zh}->{861331855} = "广东省阳江市";
$areanames{zh}->{861331856} = "广东省阳江市";
$areanames{zh}->{861331857} = "广东省韶关市";
$areanames{zh}->{861331858} = "广东省韶关市";
$areanames{zh}->{861331859} = "广东省韶关市";
$areanames{zh}->{861331860} = "广东省清远市";
$areanames{zh}->{861331861} = "广东省清远市";
$areanames{zh}->{861331862} = "广东省清远市";
$areanames{zh}->{861331863} = "广东省江门市";
$areanames{zh}->{861331864} = "广东省江门市";
$areanames{zh}->{861331865} = "广东省江门市";
$areanames{zh}->{861331866} = "广东省江门市";
$areanames{zh}->{861331867} = "广东省汕尾市";
$areanames{zh}->{861331868} = "广东省汕尾市";
$areanames{zh}->{861331869} = "广东省汕尾市";
$areanames{zh}->{86133187} = "广东省广州市";
$areanames{zh}->{86133188} = "广东省广州市";
$areanames{zh}->{861331890} = "广东省云浮市";
$areanames{zh}->{861331891} = "广东省云浮市";
$areanames{zh}->{861331892} = "广东省潮州市";
$areanames{zh}->{861331893} = "广东省潮州市";
$areanames{zh}->{861331894} = "广东省珠海市";
$areanames{zh}->{861331895} = "广东省珠海市";
$areanames{zh}->{861331896} = "广东省珠海市";
$areanames{zh}->{861331897} = "广东省珠海市";
$areanames{zh}->{861331898} = "广东省珠海市";
$areanames{zh}->{861331899} = "广东省河源市";
$areanames{zh}->{861331900} = "新疆昌吉回族自治州";
$areanames{zh}->{861331901} = "新疆塔城地区";
$areanames{zh}->{861331902} = "新疆哈密地区";
$areanames{zh}->{861331903} = "新疆和田地区";
$areanames{zh}->{861331904} = "新疆乌鲁木齐市";
$areanames{zh}->{861331905} = "新疆昌吉回族自治州";
$areanames{zh}->{861331906} = "新疆阿勒泰地区";
$areanames{zh}->{861331907} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861331908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861331909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861331910} = "陕西省咸阳市";
$areanames{zh}->{861331911} = "陕西省延安市";
$areanames{zh}->{861331912} = "陕西省榆林市";
$areanames{zh}->{861331913} = "陕西省渭南市";
$areanames{zh}->{861331914} = "陕西省商洛市";
$areanames{zh}->{861331915} = "陕西省安康市";
$areanames{zh}->{861331916} = "陕西省汉中市";
$areanames{zh}->{861331917} = "陕西省宝鸡市";
$areanames{zh}->{861331918} = "陕西省西安市";
$areanames{zh}->{861331919} = "陕西省铜川市";
$areanames{zh}->{86133192} = "陕西省西安市";
$areanames{zh}->{861331930} = "江西省上饶市";
$areanames{zh}->{861331931} = "江西省上饶市";
$areanames{zh}->{861331932} = "江西省上饶市";
$areanames{zh}->{861331933} = "江西省吉安市";
$areanames{zh}->{861331934} = "江西省宜春市";
$areanames{zh}->{861331935} = "江西省宜春市";
$areanames{zh}->{861331936} = "江西省宜春市";
$areanames{zh}->{861331937} = "江西省景德镇市";
$areanames{zh}->{861331938} = "江西省景德镇市";
$areanames{zh}->{861331939} = "江西省萍乡市";
$areanames{zh}->{861331940} = "江西省南昌市";
$areanames{zh}->{861331941} = "江西省南昌市";
$areanames{zh}->{861331942} = "江西省南昌市";
$areanames{zh}->{861331943} = "江西省南昌市";
$areanames{zh}->{861331944} = "江西省九江市";
$areanames{zh}->{861331945} = "江西省九江市";
$areanames{zh}->{861331946} = "江西省赣州市";
$areanames{zh}->{861331947} = "江西省赣州市";
$areanames{zh}->{861331948} = "江西省赣州市";
$areanames{zh}->{861331949} = "江西省赣州市";
$areanames{zh}->{86133195} = "湖南省长沙市";
$areanames{zh}->{861331960} = "湖南省长沙市";
$areanames{zh}->{861331961} = "湖南省怀化市";
$areanames{zh}->{861331962} = "湖南省常德市";
$areanames{zh}->{861331963} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861331964} = "湖南省张家界市";
$areanames{zh}->{861331965} = "湖南省怀化市";
$areanames{zh}->{861331966} = "湖南省永州市";
$areanames{zh}->{861331967} = "湖南省郴州市";
$areanames{zh}->{861331968} = "湖南省娄底市";
$areanames{zh}->{861331969} = "湖南省邵阳市";
$areanames{zh}->{861331970} = "新疆哈密地区";
$areanames{zh}->{861331971} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861331972} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861331973} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861331974} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861331975} = "新疆塔城地区";
$areanames{zh}->{861331976} = "新疆阿勒泰地区";
$areanames{zh}->{861331977} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861331978} = "新疆阿克苏地区";
$areanames{zh}->{861331979} = "新疆和田地区";
$areanames{zh}->{86133198} = "新疆乌鲁木齐市";
$areanames{zh}->{861331990} = "新疆克拉玛依市";
$areanames{zh}->{861331991} = "新疆乌鲁木齐市";
$areanames{zh}->{861331992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861331993} = "新疆石河子市";
$areanames{zh}->{861331994} = "新疆昌吉回族自治州";
$areanames{zh}->{861331995} = "新疆吐鲁番地区";
$areanames{zh}->{861331996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861331997} = "新疆阿克苏地区";
$areanames{zh}->{861331998} = "新疆喀什地区";
$areanames{zh}->{861331999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861332000} = "江西省新余市";
$areanames{zh}->{861332001} = "江西省南昌市";
$areanames{zh}->{861332002} = "江西省九江市";
$areanames{zh}->{861332003} = "江西省上饶市";
$areanames{zh}->{861332004} = "江西省抚州市";
$areanames{zh}->{861332005} = "江西省宜春市";
$areanames{zh}->{861332006} = "江西省吉安市";
$areanames{zh}->{861332007} = "江西省赣州市";
$areanames{zh}->{861332008} = "江西省景德镇市";
$areanames{zh}->{861332009} = "江西省萍乡市";
$areanames{zh}->{861332010} = "江西省鹰潭市";
$areanames{zh}->{861332011} = "江西省南昌市";
$areanames{zh}->{861332012} = "江西省九江市";
$areanames{zh}->{861332013} = "江西省上饶市";
$areanames{zh}->{861332014} = "江西省景德镇市";
$areanames{zh}->{861332015} = "江西省宜春市";
$areanames{zh}->{861332016} = "江西省吉安市";
$areanames{zh}->{861332017} = "江西省赣州市";
$areanames{zh}->{861332018} = "江西省抚州市";
$areanames{zh}->{861332019} = "江西省抚州市";
$areanames{zh}->{86133202} = "重庆市";
$areanames{zh}->{86133203} = "重庆市";
$areanames{zh}->{861332040} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861332041} = "云南省丽江市";
$areanames{zh}->{861332042} = "云南省昭通市";
$areanames{zh}->{861332043} = "云南省迪庆藏族自治州";
$areanames{zh}->{861332044} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861332045} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861332046} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861332047} = "云南省普洱市";
$areanames{zh}->{861332048} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861332049} = "云南省临沧市";
$areanames{zh}->{861332050} = "云南省昆明市";
$areanames{zh}->{861332051} = "云南省昆明市";
$areanames{zh}->{861332052} = "云南省昆明市";
$areanames{zh}->{861332053} = "云南省昆明市";
$areanames{zh}->{861332054} = "云南省昆明市";
$areanames{zh}->{861332055} = "云南省大理白族自治州";
$areanames{zh}->{861332056} = "云南省楚雄彝族自治州";
$areanames{zh}->{861332057} = "云南省曲靖市";
$areanames{zh}->{861332058} = "云南省玉溪市";
$areanames{zh}->{861332059} = "云南省保山市";
$areanames{zh}->{861332060} = "四川省雅安市";
$areanames{zh}->{861332061} = "四川省巴中市";
$areanames{zh}->{861332062} = "四川省广安市";
$areanames{zh}->{861332063} = "四川省遂宁市";
$areanames{zh}->{861332064} = "四川省遂宁市";
$areanames{zh}->{861332065} = "四川省宜宾市";
$areanames{zh}->{861332066} = "四川省宜宾市";
$areanames{zh}->{861332067} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861332068} = "四川省资阳市";
$areanames{zh}->{861332069} = "四川省内江市";
$areanames{zh}->{861332070} = "四川省内江市";
$areanames{zh}->{861332071} = "四川省攀枝花市";
$areanames{zh}->{861332072} = "四川省攀枝花市";
$areanames{zh}->{861332073} = "四川省广元市";
$areanames{zh}->{861332074} = "四川省泸州市";
$areanames{zh}->{861332075} = "四川省广元市";
$areanames{zh}->{861332076} = "四川省南充市";
$areanames{zh}->{861332077} = "四川省南充市";
$areanames{zh}->{861332078} = "四川省泸州市";
$areanames{zh}->{861332079} = "四川省甘孜藏族自治州";
$areanames{zh}->{861332080} = "四川省自贡市";
$areanames{zh}->{861332081} = "四川省自贡市";
$areanames{zh}->{861332082} = "四川省达州市";
$areanames{zh}->{861332083} = "四川省达州市";
$areanames{zh}->{861332084} = "四川省资阳市";
$areanames{zh}->{861332085} = "四川省德阳市";
$areanames{zh}->{861332086} = "四川省德阳市";
$areanames{zh}->{861332087} = "四川省德阳市";
$areanames{zh}->{861332088} = "四川省绵阳市";
$areanames{zh}->{861332089} = "四川省绵阳市";
$areanames{zh}->{861332090} = "四川省绵阳市";
$areanames{zh}->{861332091} = "四川省乐山市";
$areanames{zh}->{861332092} = "四川省乐山市";
$areanames{zh}->{861332093} = "四川省眉山市";
$areanames{zh}->{861332094} = "四川省成都市";
$areanames{zh}->{861332095} = "四川省眉山市";
$areanames{zh}->{861332096} = "四川省成都市";
$areanames{zh}->{861332097} = "四川省凉山彝族自治州";
$areanames{zh}->{861332098} = "四川省成都市";
$areanames{zh}->{861332099} = "四川省成都市";
$areanames{zh}->{86133210} = "北京市";
$areanames{zh}->{86133211} = "北京市";
$areanames{zh}->{861332120} = "甘肃省兰州市";
$areanames{zh}->{861332121} = "甘肃省兰州市";
$areanames{zh}->{861332122} = "甘肃省兰州市";
$areanames{zh}->{861332123} = "甘肃省庆阳市";
$areanames{zh}->{861332124} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861332125} = "甘肃省金昌市";
$areanames{zh}->{861332126} = "甘肃省嘉峪关市";
$areanames{zh}->{861332127} = "甘肃省白银市";
$areanames{zh}->{861332128} = "甘肃省兰州市";
$areanames{zh}->{861332129} = "甘肃省酒泉市";
$areanames{zh}->{861332130} = "甘肃省平凉市";
$areanames{zh}->{861332131} = "甘肃省兰州市";
$areanames{zh}->{861332132} = "甘肃省定西市";
$areanames{zh}->{861332133} = "甘肃省兰州市";
$areanames{zh}->{861332134} = "甘肃省临夏回族自治州";
$areanames{zh}->{861332135} = "甘肃省武威市";
$areanames{zh}->{861332136} = "甘肃省张掖市";
$areanames{zh}->{861332137} = "甘肃省酒泉市";
$areanames{zh}->{861332138} = "甘肃省天水市";
$areanames{zh}->{861332139} = "甘肃省陇南市";
$areanames{zh}->{861332140} = "吉林省长春市";
$areanames{zh}->{861332141} = "吉林省长春市";
$areanames{zh}->{861332142} = "吉林省吉林市";
$areanames{zh}->{861332143} = "吉林省四平市";
$areanames{zh}->{861332144} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861332145} = "吉林省通化市";
$areanames{zh}->{861332146} = "吉林省白城市";
$areanames{zh}->{861332147} = "吉林省辽源市";
$areanames{zh}->{861332148} = "吉林省松原市";
$areanames{zh}->{861332149} = "吉林省白山市";
$areanames{zh}->{861332150} = "吉林省吉林市";
$areanames{zh}->{861332151} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861332152} = "吉林省松原市";
$areanames{zh}->{861332153} = "吉林省通化市";
$areanames{zh}->{861332154} = "吉林省长春市";
$areanames{zh}->{861332155} = "吉林省四平市";
$areanames{zh}->{861332156} = "吉林省辽源市";
$areanames{zh}->{861332157} = "吉林省白城市";
$areanames{zh}->{861332158} = "吉林省长春市";
$areanames{zh}->{861332159} = "吉林省白山市";
$areanames{zh}->{861332160} = "广西南宁市";
$areanames{zh}->{861332161} = "广西南宁市";
$areanames{zh}->{861332162} = "广西柳州市";
$areanames{zh}->{861332163} = "广西桂林市";
$areanames{zh}->{861332164} = "广西贺州市";
$areanames{zh}->{861332165} = "广西玉林市";
$areanames{zh}->{861332166} = "广西南宁市";
$areanames{zh}->{861332167} = "广西贵港市";
$areanames{zh}->{861332168} = "广西贵港市";
$areanames{zh}->{861332169} = "广西北海市";
$areanames{zh}->{861332170} = "广西南宁市";
$areanames{zh}->{861332171} = "广西南宁市";
$areanames{zh}->{861332172} = "广西柳州市";
$areanames{zh}->{861332173} = "广西桂林市";
$areanames{zh}->{861332174} = "广西贺州市";
$areanames{zh}->{861332175} = "广西玉林市";
$areanames{zh}->{861332176} = "广西百色市";
$areanames{zh}->{861332177} = "广西贵港市";
$areanames{zh}->{861332178} = "广西贵港市";
$areanames{zh}->{861332179} = "广西北海市";
$areanames{zh}->{86133218} = "上海市";
$areanames{zh}->{86133219} = "上海市";
$areanames{zh}->{86133220} = "海南省海口市";
$areanames{zh}->{861332210} = "辽宁省鞍山市";
$areanames{zh}->{861332211} = "辽宁省鞍山市";
$areanames{zh}->{861332212} = "辽宁省抚顺市";
$areanames{zh}->{861332213} = "辽宁省抚顺市";
$areanames{zh}->{861332214} = "辽宁省本溪市";
$areanames{zh}->{861332215} = "辽宁省本溪市";
$areanames{zh}->{861332216} = "辽宁省丹东市";
$areanames{zh}->{861332217} = "辽宁省丹东市";
$areanames{zh}->{861332218} = "辽宁省锦州市";
$areanames{zh}->{861332219} = "辽宁省锦州市";
$areanames{zh}->{86133222} = "辽宁省大连市";
$areanames{zh}->{861332230} = "辽宁省营口市";
$areanames{zh}->{861332231} = "辽宁省营口市";
$areanames{zh}->{861332232} = "辽宁省阜新市";
$areanames{zh}->{861332233} = "辽宁省辽阳市";
$areanames{zh}->{861332234} = "辽宁省辽阳市";
$areanames{zh}->{861332235} = "辽宁省铁岭市";
$areanames{zh}->{861332236} = "辽宁省朝阳市";
$areanames{zh}->{861332237} = "辽宁省盘锦市";
$areanames{zh}->{861332238} = "辽宁省盘锦市";
$areanames{zh}->{861332239} = "辽宁省葫芦岛市";
$areanames{zh}->{86133224} = "辽宁省沈阳市";
$areanames{zh}->{861332250} = "西藏拉萨市";
$areanames{zh}->{861332251} = "西藏拉萨市";
$areanames{zh}->{861332252} = "西藏日喀则地区";
$areanames{zh}->{861332253} = "西藏山南地区";
$areanames{zh}->{861332254} = "西藏林芝地区";
$areanames{zh}->{861332255} = "西藏昌都地区";
$areanames{zh}->{861332256} = "西藏那曲地区";
$areanames{zh}->{861332257} = "西藏阿里地区";
$areanames{zh}->{861332258} = "西藏拉萨市";
$areanames{zh}->{861332259} = "西藏拉萨市";
$areanames{zh}->{861332260} = "广东省东莞市";
$areanames{zh}->{861332261} = "广东省东莞市";
$areanames{zh}->{861332262} = "广东省惠州市";
$areanames{zh}->{861332263} = "广东省河源市";
$areanames{zh}->{861332264} = "广东省惠州市";
$areanames{zh}->{861332265} = "广东省梅州市";
$areanames{zh}->{861332266} = "广东省梅州市";
$areanames{zh}->{861332267} = "广东省汕尾市";
$areanames{zh}->{861332268} = "广东省汕尾市";
$areanames{zh}->{861332269} = "广东省河源市";
$areanames{zh}->{86133227} = "广东省汕头市";
$areanames{zh}->{861332275} = "广东省揭阳市";
$areanames{zh}->{861332276} = "广东省揭阳市";
$areanames{zh}->{861332278} = "广东省潮州市";
$areanames{zh}->{861332279} = "广东省潮州市";
$areanames{zh}->{861332280} = "广东省广州市";
$areanames{zh}->{861332281} = "广东省广州市";
$areanames{zh}->{861332282} = "广东省佛山市";
$areanames{zh}->{861332283} = "广东省佛山市";
$areanames{zh}->{861332284} = "广东省佛山市";
$areanames{zh}->{861332285} = "广东省佛山市";
$areanames{zh}->{861332286} = "广东省珠海市";
$areanames{zh}->{861332287} = "广东省珠海市";
$areanames{zh}->{861332288} = "广东省江门市";
$areanames{zh}->{861332289} = "广东省江门市";
$areanames{zh}->{861332290} = "广东省中山市";
$areanames{zh}->{861332291} = "广东省中山市";
$areanames{zh}->{861332292} = "广东省深圳市";
$areanames{zh}->{861332293} = "广东省深圳市";
$areanames{zh}->{861332294} = "广东省云浮市";
$areanames{zh}->{861332295} = "广东省云浮市";
$areanames{zh}->{861332296} = "广东省肇庆市";
$areanames{zh}->{861332297} = "广东省肇庆市";
$areanames{zh}->{861332298} = "广东省深圳市";
$areanames{zh}->{861332299} = "广东省深圳市";
$areanames{zh}->{861332300} = "河北省邯郸市";
$areanames{zh}->{861332301} = "河北省石家庄市";
$areanames{zh}->{861332302} = "河北省保定市";
$areanames{zh}->{861332303} = "河北省张家口市";
$areanames{zh}->{861332304} = "河北省石家庄市";
$areanames{zh}->{861332305} = "河北省唐山市";
$areanames{zh}->{861332306} = "河北省廊坊市";
$areanames{zh}->{861332307} = "河北省沧州市";
$areanames{zh}->{861332308} = "河北省衡水市";
$areanames{zh}->{861332309} = "河北省邢台市";
$areanames{zh}->{861332310} = "河北省邯郸市";
$areanames{zh}->{861332311} = "河北省石家庄市";
$areanames{zh}->{861332312} = "河北省保定市";
$areanames{zh}->{861332313} = "河北省张家口市";
$areanames{zh}->{861332314} = "河北省承德市";
$areanames{zh}->{861332315} = "河北省唐山市";
$areanames{zh}->{861332316} = "河北省廊坊市";
$areanames{zh}->{861332317} = "河北省沧州市";
$areanames{zh}->{861332318} = "河北省衡水市";
$areanames{zh}->{861332319} = "河北省邢台市";
$areanames{zh}->{861332320} = "河北省邯郸市";
$areanames{zh}->{861332321} = "河北省石家庄市";
$areanames{zh}->{861332322} = "河北省保定市";
$areanames{zh}->{861332323} = "河北省张家口市";
$areanames{zh}->{861332324} = "河北省保定市";
$areanames{zh}->{861332325} = "河北省唐山市";
$areanames{zh}->{861332326} = "河北省廊坊市";
$areanames{zh}->{861332327} = "河北省沧州市";
$areanames{zh}->{861332328} = "河北省秦皇岛市";
$areanames{zh}->{861332329} = "河北省唐山市";
$areanames{zh}->{86133233} = "天津市";
$areanames{zh}->{86133234} = "天津市";
$areanames{zh}->{861332350} = "宁夏银川市";
$areanames{zh}->{861332351} = "宁夏银川市";
$areanames{zh}->{861332352} = "宁夏石嘴山市";
$areanames{zh}->{861332353} = "宁夏吴忠市";
$areanames{zh}->{861332354} = "宁夏固原市";
$areanames{zh}->{861332355} = "宁夏吴忠市";
$areanames{zh}->{861332356} = "宁夏石嘴山市";
$areanames{zh}->{861332357} = "宁夏银川市";
$areanames{zh}->{861332358} = "宁夏银川市";
$areanames{zh}->{861332359} = "宁夏银川市";
$areanames{zh}->{861332360} = "河南省商丘市";
$areanames{zh}->{861332361} = "河南省鹤壁市";
$areanames{zh}->{861332362} = "河南省安阳市";
$areanames{zh}->{861332363} = "河南省濮阳市";
$areanames{zh}->{861332364} = "河南省驻马店市";
$areanames{zh}->{861332365} = "河南省开封市";
$areanames{zh}->{861332366} = "河南省三门峡市";
$areanames{zh}->{861332367} = "河南省漯河市";
$areanames{zh}->{861332368} = "河南省南阳市";
$areanames{zh}->{861332369} = "河南省南阳市";
$areanames{zh}->{861332370} = "河南省商丘市";
$areanames{zh}->{861332371} = "河南省郑州市";
$areanames{zh}->{861332372} = "河南省安阳市";
$areanames{zh}->{861332373} = "河南省新乡市";
$areanames{zh}->{861332374} = "河南省许昌市";
$areanames{zh}->{861332375} = "河南省平顶山市";
$areanames{zh}->{861332376} = "河南省信阳市";
$areanames{zh}->{861332377} = "河南省南阳市";
$areanames{zh}->{861332378} = "河南省开封市";
$areanames{zh}->{861332379} = "河南省洛阳市";
$areanames{zh}->{86133238} = "河南省郑州市";
$areanames{zh}->{861332380} = "河南省新乡市";
$areanames{zh}->{861332387} = "河南省周口市";
$areanames{zh}->{861332388} = "河南省洛阳市";
$areanames{zh}->{861332389} = "河南省焦作市";
$areanames{zh}->{861332390} = "河南省平顶山市";
$areanames{zh}->{861332391} = "河南省焦作市";
$areanames{zh}->{861332392} = "河南省鹤壁市";
$areanames{zh}->{861332393} = "河南省濮阳市";
$areanames{zh}->{861332394} = "河南省周口市";
$areanames{zh}->{861332395} = "河南省漯河市";
$areanames{zh}->{861332396} = "河南省驻马店市";
$areanames{zh}->{861332397} = "河南省信阳市";
$areanames{zh}->{861332398} = "河南省三门峡市";
$areanames{zh}->{861332399} = "河南省许昌市";
$areanames{zh}->{86133240} = "辽宁省沈阳市";
$areanames{zh}->{861332410} = "辽宁省铁岭市";
$areanames{zh}->{861332411} = "辽宁省大连市";
$areanames{zh}->{861332412} = "辽宁省鞍山市";
$areanames{zh}->{861332413} = "辽宁省抚顺市";
$areanames{zh}->{861332414} = "辽宁省本溪市";
$areanames{zh}->{861332415} = "辽宁省丹东市";
$areanames{zh}->{861332416} = "辽宁省锦州市";
$areanames{zh}->{861332417} = "辽宁省营口市";
$areanames{zh}->{861332418} = "辽宁省阜新市";
$areanames{zh}->{861332419} = "辽宁省辽阳市";
$areanames{zh}->{861332420} = "辽宁省大连市";
$areanames{zh}->{861332421} = "辽宁省朝阳市";
$areanames{zh}->{861332422} = "辽宁省鞍山市";
$areanames{zh}->{861332423} = "辽宁省抚顺市";
$areanames{zh}->{861332424} = "辽宁省本溪市";
$areanames{zh}->{861332425} = "辽宁省盘锦市";
$areanames{zh}->{861332426} = "辽宁省锦州市";
$areanames{zh}->{861332427} = "辽宁省盘锦市";
$areanames{zh}->{861332428} = "辽宁省丹东市";
$areanames{zh}->{861332429} = "辽宁省葫芦岛市";
$areanames{zh}->{861332430} = "吉林省长春市";
$areanames{zh}->{861332431} = "吉林省长春市";
$areanames{zh}->{861332432} = "吉林省吉林市";
$areanames{zh}->{861332433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861332434} = "吉林省四平市";
$areanames{zh}->{861332435} = "吉林省通化市";
$areanames{zh}->{861332436} = "吉林省白城市";
$areanames{zh}->{861332437} = "吉林省辽源市";
$areanames{zh}->{861332438} = "吉林省松原市";
$areanames{zh}->{861332439} = "吉林省白山市";
$areanames{zh}->{861332440} = "吉林省吉林市";
$areanames{zh}->{861332441} = "吉林省吉林市";
$areanames{zh}->{861332442} = "吉林省吉林市";
$areanames{zh}->{861332443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861332444} = "吉林省吉林市";
$areanames{zh}->{861332445} = "吉林省通化市";
$areanames{zh}->{861332446} = "吉林省长春市";
$areanames{zh}->{861332447} = "吉林省长春市";
$areanames{zh}->{861332448} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861332449} = "吉林省白山市";
$areanames{zh}->{86133245} = "陕西省西安市";
$areanames{zh}->{861332460} = "陕西省榆林市";
$areanames{zh}->{861332461} = "陕西省榆林市";
$areanames{zh}->{861332462} = "陕西省榆林市";
$areanames{zh}->{861332463} = "陕西省安康市";
$areanames{zh}->{861332464} = "陕西省安康市";
$areanames{zh}->{861332465} = "陕西省安康市";
$areanames{zh}->{861332466} = "陕西省商洛市";
$areanames{zh}->{861332467} = "陕西省商洛市";
$areanames{zh}->{861332468} = "陕西省铜川市";
$areanames{zh}->{861332469} = "陕西省铜川市";
$areanames{zh}->{861332470} = "广西防城港市";
$areanames{zh}->{861332471} = "广西南宁市";
$areanames{zh}->{861332472} = "广西柳州市";
$areanames{zh}->{861332473} = "广西桂林市";
$areanames{zh}->{861332474} = "广西贺州市";
$areanames{zh}->{861332475} = "广西贵港市";
$areanames{zh}->{861332476} = "广西百色市";
$areanames{zh}->{861332477} = "广西钦州市";
$areanames{zh}->{861332478} = "广西河池市";
$areanames{zh}->{861332479} = "广西北海市";
$areanames{zh}->{861332480} = "广西贺州市";
$areanames{zh}->{861332481} = "广西南宁市";
$areanames{zh}->{861332482} = "广西柳州市";
$areanames{zh}->{861332483} = "广西桂林市";
$areanames{zh}->{861332484} = "广西梧州市";
$areanames{zh}->{861332485} = "广西玉林市";
$areanames{zh}->{861332486} = "广西贵港市";
$areanames{zh}->{861332487} = "广西钦州市";
$areanames{zh}->{861332488} = "广西梧州市";
$areanames{zh}->{861332489} = "广西北海市";
$areanames{zh}->{861332490} = "云南省曲靖市";
$areanames{zh}->{861332491} = "云南省曲靖市";
$areanames{zh}->{861332492} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861332493} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861332494} = "云南省大理白族自治州";
$areanames{zh}->{861332495} = "云南省大理白族自治州";
$areanames{zh}->{861332496} = "云南省昭通市";
$areanames{zh}->{861332497} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861332498} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861332499} = "云南省普洱市";
$areanames{zh}->{861332500} = "山东省青岛市";
$areanames{zh}->{861332501} = "山东省青岛市";
$areanames{zh}->{861332502} = "山东省青岛市";
$areanames{zh}->{861332503} = "山东省东营市";
$areanames{zh}->{861332504} = "山东省东营市";
$areanames{zh}->{861332505} = "山东省东营市";
$areanames{zh}->{861332506} = "山东省东营市";
$areanames{zh}->{861332507} = "山东省临沂市";
$areanames{zh}->{861332508} = "山东省临沂市";
$areanames{zh}->{861332509} = "山东省临沂市";
$areanames{zh}->{861332510} = "山东省济南市";
$areanames{zh}->{861332511} = "山东省济南市";
$areanames{zh}->{861332512} = "山东省济南市";
$areanames{zh}->{861332513} = "山东省济南市";
$areanames{zh}->{861332514} = "山东省烟台市";
$areanames{zh}->{861332515} = "山东省烟台市";
$areanames{zh}->{861332516} = "山东省烟台市";
$areanames{zh}->{861332517} = "山东省济宁市";
$areanames{zh}->{861332518} = "山东省济宁市";
$areanames{zh}->{861332519} = "山东省济宁市";
$areanames{zh}->{861332520} = "山东省淄博市";
$areanames{zh}->{861332521} = "山东省淄博市";
$areanames{zh}->{861332522} = "山东省淄博市";
$areanames{zh}->{861332523} = "山东省淄博市";
$areanames{zh}->{861332524} = "山东省潍坊市";
$areanames{zh}->{861332525} = "山东省潍坊市";
$areanames{zh}->{861332526} = "山东省潍坊市";
$areanames{zh}->{861332527} = "山东省泰安市";
$areanames{zh}->{861332528} = "山东省泰安市";
$areanames{zh}->{861332529} = "山东省泰安市";
$areanames{zh}->{861332530} = "陕西省咸阳市";
$areanames{zh}->{861332531} = "陕西省延安市";
$areanames{zh}->{861332532} = "陕西省榆林市";
$areanames{zh}->{861332533} = "陕西省渭南市";
$areanames{zh}->{861332534} = "陕西省商洛市";
$areanames{zh}->{861332535} = "陕西省安康市";
$areanames{zh}->{861332536} = "陕西省汉中市";
$areanames{zh}->{861332537} = "陕西省宝鸡市";
$areanames{zh}->{861332538} = "陕西省西安市";
$areanames{zh}->{861332539} = "陕西省铜川市";
$areanames{zh}->{861332540} = "陕西省榆林市";
$areanames{zh}->{861332541} = "陕西省榆林市";
$areanames{zh}->{861332542} = "陕西省榆林市";
$areanames{zh}->{861332543} = "陕西省渭南市";
$areanames{zh}->{861332544} = "陕西省渭南市";
$areanames{zh}->{861332545} = "陕西省西安市";
$areanames{zh}->{861332546} = "陕西省西安市";
$areanames{zh}->{861332547} = "陕西省西安市";
$areanames{zh}->{861332548} = "陕西省西安市";
$areanames{zh}->{861332549} = "陕西省西安市";
$areanames{zh}->{86133255} = "新疆乌鲁木齐市";
$areanames{zh}->{861332550} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861332551} = "新疆阿克苏地区";
$areanames{zh}->{861332552} = "新疆喀什地区";
$areanames{zh}->{861332560} = "新疆乌鲁木齐市";
$areanames{zh}->{861332561} = "新疆乌鲁木齐市";
$areanames{zh}->{861332562} = "新疆乌鲁木齐市";
$areanames{zh}->{861332563} = "新疆乌鲁木齐市";
$areanames{zh}->{861332564} = "新疆乌鲁木齐市";
$areanames{zh}->{861332565} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861332566} = "新疆石河子市";
$areanames{zh}->{861332567} = "新疆克拉玛依市";
$areanames{zh}->{861332568} = "新疆克拉玛依市";
$areanames{zh}->{861332569} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861332570} = "浙江省衢州市";
$areanames{zh}->{861332571} = "浙江省杭州市";
$areanames{zh}->{861332572} = "浙江省湖州市";
$areanames{zh}->{861332573} = "浙江省嘉兴市";
$areanames{zh}->{861332574} = "浙江省宁波市";
$areanames{zh}->{861332575} = "浙江省绍兴市";
$areanames{zh}->{861332576} = "浙江省台州市";
$areanames{zh}->{861332577} = "浙江省温州市";
$areanames{zh}->{861332578} = "浙江省丽水市";
$areanames{zh}->{861332579} = "浙江省金华市";
$areanames{zh}->{861332580} = "浙江省舟山市";
$areanames{zh}->{861332581} = "浙江省杭州市";
$areanames{zh}->{861332582} = "浙江省湖州市";
$areanames{zh}->{861332583} = "浙江省嘉兴市";
$areanames{zh}->{861332584} = "浙江省宁波市";
$areanames{zh}->{861332585} = "浙江省绍兴市";
$areanames{zh}->{861332586} = "浙江省台州市";
$areanames{zh}->{861332587} = "浙江省温州市";
$areanames{zh}->{861332588} = "浙江省宁波市";
$areanames{zh}->{861332589} = "浙江省金华市";
$areanames{zh}->{861332590} = "浙江省舟山市";
$areanames{zh}->{861332591} = "浙江省杭州市";
$areanames{zh}->{861332592} = "浙江省湖州市";
$areanames{zh}->{861332593} = "浙江省嘉兴市";
$areanames{zh}->{861332594} = "浙江省宁波市";
$areanames{zh}->{861332595} = "浙江省绍兴市";
$areanames{zh}->{861332596} = "浙江省台州市";
$areanames{zh}->{861332597} = "浙江省温州市";
$areanames{zh}->{861332598} = "浙江省温州市";
$areanames{zh}->{861332599} = "浙江省金华市";
$areanames{zh}->{86133260} = "浙江省台州市";
$areanames{zh}->{861332610} = "浙江省衢州市";
$areanames{zh}->{861332611} = "浙江省丽水市";
$areanames{zh}->{861332612} = "浙江省宁波市";
$areanames{zh}->{861332613} = "浙江省杭州市";
$areanames{zh}->{861332614} = "浙江省杭州市";
$areanames{zh}->{861332615} = "浙江省湖州市";
$areanames{zh}->{861332616} = "浙江省湖州市";
$areanames{zh}->{861332617} = "浙江省湖州市";
$areanames{zh}->{861332618} = "浙江省湖州市";
$areanames{zh}->{861332619} = "浙江省温州市";
$areanames{zh}->{861332620} = "山东省菏泽市";
$areanames{zh}->{861332621} = "山东省菏泽市";
$areanames{zh}->{861332622} = "山东省莱芜市";
$areanames{zh}->{861332623} = "山东省日照市";
$areanames{zh}->{861332624} = "山东省威海市";
$areanames{zh}->{861332625} = "山东省聊城市";
$areanames{zh}->{861332626} = "山东省德州市";
$areanames{zh}->{861332627} = "山东省德州市";
$areanames{zh}->{861332628} = "山东省滨州市";
$areanames{zh}->{861332629} = "山东省滨州市";
$areanames{zh}->{861332630} = "山东省威海市";
$areanames{zh}->{861332631} = "山东省威海市";
$areanames{zh}->{861332632} = "山东省枣庄市";
$areanames{zh}->{861332633} = "山东省日照市";
$areanames{zh}->{861332634} = "山东省莱芜市";
$areanames{zh}->{861332635} = "山东省聊城市";
$areanames{zh}->{861332636} = "山东省潍坊市";
$areanames{zh}->{861332637} = "山东省枣庄市";
$areanames{zh}->{861332638} = "山东省烟台市";
$areanames{zh}->{861332639} = "山东省青岛市";
$areanames{zh}->{86133264} = "广东省广州市";
$areanames{zh}->{861332650} = "广东省湛江市";
$areanames{zh}->{861332651} = "广东省湛江市";
$areanames{zh}->{861332652} = "广东省韶关市";
$areanames{zh}->{861332653} = "广东省韶关市";
$areanames{zh}->{861332654} = "广东省清远市";
$areanames{zh}->{861332655} = "广东省清远市";
$areanames{zh}->{861332656} = "广东省茂名市";
$areanames{zh}->{861332657} = "广东省茂名市";
$areanames{zh}->{861332658} = "广东省阳江市";
$areanames{zh}->{861332659} = "广东省阳江市";
$areanames{zh}->{86133266} = "广东省珠海市";
$areanames{zh}->{86133267} = "广东省佛山市";
$areanames{zh}->{861332680} = "广东省江门市";
$areanames{zh}->{861332681} = "广东省江门市";
$areanames{zh}->{861332682} = "广东省江门市";
$areanames{zh}->{861332683} = "广东省江门市";
$areanames{zh}->{861332684} = "广东省江门市";
$areanames{zh}->{861332685} = "广东省东莞市";
$areanames{zh}->{861332686} = "广东省东莞市";
$areanames{zh}->{861332687} = "广东省东莞市";
$areanames{zh}->{861332688} = "广东省东莞市";
$areanames{zh}->{861332689} = "广东省东莞市";
$areanames{zh}->{86133269} = "广东省中山市";
$areanames{zh}->{861332700} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861332701} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861332702} = "内蒙古兴安盟";
$areanames{zh}->{861332703} = "内蒙古乌海市";
$areanames{zh}->{861332704} = "内蒙古通辽市";
$areanames{zh}->{861332705} = "内蒙古通辽市";
$areanames{zh}->{861332706} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861332707} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861332708} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861332709} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861332710} = "内蒙古呼和浩特市";
$areanames{zh}->{861332711} = "内蒙古呼和浩特市";
$areanames{zh}->{861332712} = "内蒙古呼和浩特市";
$areanames{zh}->{861332713} = "内蒙古阿拉善盟";
$areanames{zh}->{861332714} = "内蒙古兴安盟";
$areanames{zh}->{861332715} = "内蒙古赤峰市";
$areanames{zh}->{861332716} = "内蒙古赤峰市";
$areanames{zh}->{861332717} = "内蒙古包头市";
$areanames{zh}->{861332718} = "内蒙古包头市";
$areanames{zh}->{861332719} = "内蒙古包头市";
$areanames{zh}->{861332720} = "湖南省岳阳市";
$areanames{zh}->{861332721} = "湖南省长沙市";
$areanames{zh}->{861332722} = "湖南省湘潭市";
$areanames{zh}->{861332723} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861332724} = "湖南省张家界市";
$areanames{zh}->{861332725} = "湖南省怀化市";
$areanames{zh}->{861332726} = "湖南省永州市";
$areanames{zh}->{861332727} = "湖南省益阳市";
$areanames{zh}->{861332728} = "湖南省娄底市";
$areanames{zh}->{861332729} = "湖南省邵阳市";
$areanames{zh}->{861332730} = "湖南省岳阳市";
$areanames{zh}->{861332731} = "湖南省长沙市";
$areanames{zh}->{861332732} = "湖南省湘潭市";
$areanames{zh}->{861332733} = "湖南省株洲市";
$areanames{zh}->{861332734} = "湖南省衡阳市";
$areanames{zh}->{861332735} = "湖南省郴州市";
$areanames{zh}->{861332736} = "湖南省常德市";
$areanames{zh}->{861332737} = "湖南省益阳市";
$areanames{zh}->{861332738} = "湖南省娄底市";
$areanames{zh}->{861332739} = "湖南省邵阳市";
$areanames{zh}->{861332740} = "山西省太原市";
$areanames{zh}->{861332741} = "山西省太原市";
$areanames{zh}->{861332742} = "山西省大同市";
$areanames{zh}->{861332743} = "山西省太原市";
$areanames{zh}->{861332744} = "山西省晋中市";
$areanames{zh}->{861332745} = "山西省长治市";
$areanames{zh}->{861332746} = "山西省太原市";
$areanames{zh}->{861332747} = "山西省临汾市";
$areanames{zh}->{861332748} = "山西省运城市";
$areanames{zh}->{861332749} = "山西省朔州市";
$areanames{zh}->{861332750} = "山西省忻州市";
$areanames{zh}->{861332751} = "山西省太原市";
$areanames{zh}->{861332752} = "山西省大同市";
$areanames{zh}->{861332753} = "山西省阳泉市";
$areanames{zh}->{861332754} = "山西省晋中市";
$areanames{zh}->{861332755} = "山西省长治市";
$areanames{zh}->{861332756} = "山西省晋城市";
$areanames{zh}->{861332757} = "山西省临汾市";
$areanames{zh}->{861332758} = "山西省吕梁市";
$areanames{zh}->{861332759} = "山西省运城市";
$areanames{zh}->{86133276} = "青海省西宁市";
$areanames{zh}->{861332760} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861332761} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861332762} = "青海省海东地区";
$areanames{zh}->{861332770} = "江苏省南京市";
$areanames{zh}->{861332771} = "江苏省南京市";
$areanames{zh}->{861332772} = "江苏省南京市";
$areanames{zh}->{861332773} = "江苏省南京市";
$areanames{zh}->{861332774} = "江苏省镇江市";
$areanames{zh}->{861332775} = "江苏省镇江市";
$areanames{zh}->{861332776} = "江苏省镇江市";
$areanames{zh}->{861332777} = "江苏省镇江市";
$areanames{zh}->{861332778} = "江苏省泰州市";
$areanames{zh}->{861332779} = "江苏省泰州市";
$areanames{zh}->{861332780} = "江苏省南京市";
$areanames{zh}->{861332781} = "江苏省南京市";
$areanames{zh}->{861332782} = "江苏省南京市";
$areanames{zh}->{861332783} = "江苏省南京市";
$areanames{zh}->{861332784} = "江苏省宿迁市";
$areanames{zh}->{861332785} = "江苏省宿迁市";
$areanames{zh}->{861332786} = "江苏省连云港市";
$areanames{zh}->{861332787} = "江苏省连云港市";
$areanames{zh}->{861332788} = "江苏省常州市";
$areanames{zh}->{861332789} = "江苏省常州市";
$areanames{zh}->{861332790} = "江苏省无锡市";
$areanames{zh}->{861332791} = "江苏省无锡市";
$areanames{zh}->{861332792} = "江苏省无锡市";
$areanames{zh}->{861332793} = "江苏省徐州市";
$areanames{zh}->{861332794} = "江苏省徐州市";
$areanames{zh}->{861332795} = "江苏省徐州市";
$areanames{zh}->{861332796} = "江苏省淮安市";
$areanames{zh}->{861332797} = "江苏省淮安市";
$areanames{zh}->{861332798} = "江苏省盐城市";
$areanames{zh}->{861332799} = "江苏省盐城市";
$areanames{zh}->{86133280} = "江苏省苏州市";
$areanames{zh}->{861332806} = "江苏省南通市";
$areanames{zh}->{861332807} = "江苏省南通市";
$areanames{zh}->{861332808} = "江苏省南通市";
$areanames{zh}->{861332809} = "江苏省南通市";
$areanames{zh}->{861332810} = "江苏省无锡市";
$areanames{zh}->{861332811} = "江苏省无锡市";
$areanames{zh}->{861332812} = "江苏省扬州市";
$areanames{zh}->{861332813} = "江苏省扬州市";
$areanames{zh}->{861332814} = "江苏省扬州市";
$areanames{zh}->{861332815} = "江苏省无锡市";
$areanames{zh}->{861332816} = "江苏省常州市";
$areanames{zh}->{861332817} = "江苏省常州市";
$areanames{zh}->{861332818} = "江苏省常州市";
$areanames{zh}->{861332819} = "江苏省常州市";
$areanames{zh}->{86133282} = "福建省福州市";
$areanames{zh}->{861332828} = "福建省宁德市";
$areanames{zh}->{861332829} = "福建省宁德市";
$areanames{zh}->{861332830} = "福建省厦门市";
$areanames{zh}->{861332831} = "福建省厦门市";
$areanames{zh}->{861332832} = "福建省厦门市";
$areanames{zh}->{861332833} = "福建省漳州市";
$areanames{zh}->{861332834} = "福建省漳州市";
$areanames{zh}->{861332835} = "福建省漳州市";
$areanames{zh}->{861332836} = "福建省莆田市";
$areanames{zh}->{861332837} = "福建省莆田市";
$areanames{zh}->{861332838} = "福建省南平市";
$areanames{zh}->{861332839} = "福建省南平市";
$areanames{zh}->{861332840} = "福建省厦门市";
$areanames{zh}->{861332841} = "福建省厦门市";
$areanames{zh}->{861332842} = "福建省泉州市";
$areanames{zh}->{861332843} = "福建省泉州市";
$areanames{zh}->{861332844} = "福建省漳州市";
$areanames{zh}->{861332845} = "福建省漳州市";
$areanames{zh}->{861332846} = "福建省福州市";
$areanames{zh}->{861332847} = "福建省福州市";
$areanames{zh}->{861332848} = "福建省龙岩市";
$areanames{zh}->{861332849} = "福建省龙岩市";
$areanames{zh}->{86133285} = "福建省泉州市";
$areanames{zh}->{861332858} = "福建省三明市";
$areanames{zh}->{861332859} = "福建省三明市";
$areanames{zh}->{86133286} = "福建省福州市";
$areanames{zh}->{861332860} = "福建省南平市";
$areanames{zh}->{861332861} = "福建省南平市";
$areanames{zh}->{861332862} = "福建省南平市";
$areanames{zh}->{861332863} = "福建省龙岩市";
$areanames{zh}->{861332870} = "福建省漳州市";
$areanames{zh}->{861332871} = "福建省漳州市";
$areanames{zh}->{861332872} = "福建省漳州市";
$areanames{zh}->{861332873} = "福建省龙岩市";
$areanames{zh}->{861332874} = "福建省龙岩市";
$areanames{zh}->{861332875} = "福建省厦门市";
$areanames{zh}->{861332876} = "福建省厦门市";
$areanames{zh}->{861332877} = "福建省厦门市";
$areanames{zh}->{861332878} = "福建省厦门市";
$areanames{zh}->{861332879} = "福建省厦门市";
$areanames{zh}->{861332880} = "福建省漳州市";
$areanames{zh}->{861332881} = "福建省漳州市";
$areanames{zh}->{861332882} = "福建省莆田市";
$areanames{zh}->{861332883} = "福建省莆田市";
$areanames{zh}->{861332884} = "福建省莆田市";
$areanames{zh}->{861332885} = "福建省福州市";
$areanames{zh}->{861332886} = "福建省福州市";
$areanames{zh}->{861332887} = "福建省泉州市";
$areanames{zh}->{861332888} = "福建省泉州市";
$areanames{zh}->{861332889} = "福建省泉州市";
$areanames{zh}->{861332890} = "福建省三明市";
$areanames{zh}->{861332891} = "福建省三明市";
$areanames{zh}->{861332892} = "福建省三明市";
$areanames{zh}->{861332893} = "福建省宁德市";
$areanames{zh}->{861332894} = "福建省宁德市";
$areanames{zh}->{861332895} = "福建省宁德市";
$areanames{zh}->{861332896} = "福建省泉州市";
$areanames{zh}->{861332897} = "福建省泉州市";
$areanames{zh}->{861332898} = "福建省泉州市";
$areanames{zh}->{861332899} = "福建省泉州市";
$areanames{zh}->{861332900} = "安徽省滁州市";
$areanames{zh}->{861332901} = "安徽省合肥市";
$areanames{zh}->{861332902} = "安徽省蚌埠市";
$areanames{zh}->{861332903} = "安徽省芜湖市";
$areanames{zh}->{861332904} = "安徽省合肥市";
$areanames{zh}->{861332905} = "安徽省马鞍山市";
$areanames{zh}->{861332906} = "安徽省安庆市";
$areanames{zh}->{861332907} = "安徽省宿州市";
$areanames{zh}->{861332908} = "安徽省阜阳市";
$areanames{zh}->{861332909} = "安徽省黄山市";
$areanames{zh}->{861332910} = "安徽省淮南市";
$areanames{zh}->{861332911} = "安徽省淮北市";
$areanames{zh}->{861332912} = "安徽省铜陵市";
$areanames{zh}->{861332913} = "安徽省宣城市";
$areanames{zh}->{861332914} = "安徽省芜湖市";
$areanames{zh}->{861332915} = "安徽省巢湖市";
$areanames{zh}->{861332916} = "安徽省池州市";
$areanames{zh}->{861332917} = "安徽省宿州市";
$areanames{zh}->{861332918} = "安徽省马鞍山市";
$areanames{zh}->{861332919} = "安徽省六安市";
$areanames{zh}->{861332920} = "安徽省滁州市";
$areanames{zh}->{861332921} = "安徽省淮北市";
$areanames{zh}->{861332922} = "安徽省蚌埠市";
$areanames{zh}->{861332923} = "安徽省六安市";
$areanames{zh}->{861332924} = "安徽省阜阳市";
$areanames{zh}->{861332925} = "安徽省巢湖市";
$areanames{zh}->{861332926} = "安徽省安庆市";
$areanames{zh}->{861332927} = "安徽省亳州市";
$areanames{zh}->{861332928} = "安徽省淮南市";
$areanames{zh}->{861332929} = "安徽省宣城市";
$areanames{zh}->{861332930} = "黑龙江省哈尔滨市";
$areanames{zh}->{861332931} = "黑龙江省哈尔滨市";
$areanames{zh}->{861332932} = "黑龙江省七台河市";
$areanames{zh}->{861332933} = "黑龙江省双鸭山市";
$areanames{zh}->{861332934} = "黑龙江省双鸭山市";
$areanames{zh}->{861332935} = "黑龙江省绥化市";
$areanames{zh}->{861332936} = "黑龙江省黑河市";
$areanames{zh}->{861332937} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861332938} = "黑龙江省伊春市";
$areanames{zh}->{861332939} = "黑龙江省大庆市";
$areanames{zh}->{861332940} = "黑龙江省哈尔滨市";
$areanames{zh}->{861332941} = "黑龙江省哈尔滨市";
$areanames{zh}->{861332942} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861332943} = "黑龙江省牡丹江市";
$areanames{zh}->{861332944} = "黑龙江省佳木斯市";
$areanames{zh}->{861332945} = "黑龙江省绥化市";
$areanames{zh}->{861332946} = "黑龙江省黑河市";
$areanames{zh}->{861332947} = "黑龙江省大庆市";
$areanames{zh}->{861332948} = "黑龙江省伊春市";
$areanames{zh}->{861332949} = "黑龙江省大庆市";
$areanames{zh}->{861332950} = "黑龙江省大庆市";
$areanames{zh}->{861332951} = "黑龙江省哈尔滨市";
$areanames{zh}->{861332952} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861332953} = "黑龙江省牡丹江市";
$areanames{zh}->{861332954} = "黑龙江省佳木斯市";
$areanames{zh}->{861332955} = "黑龙江省佳木斯市";
$areanames{zh}->{861332956} = "黑龙江省鸡西市";
$areanames{zh}->{861332957} = "黑龙江省鸡西市";
$areanames{zh}->{861332958} = "黑龙江省鹤岗市";
$areanames{zh}->{861332959} = "黑龙江省大庆市";
$areanames{zh}->{861332960} = "贵州省贵阳市";
$areanames{zh}->{861332961} = "贵州省贵阳市";
$areanames{zh}->{861332962} = "贵州省遵义市";
$areanames{zh}->{861332963} = "贵州省安顺市";
$areanames{zh}->{861332964} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861332965} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861332966} = "贵州省铜仁地区";
$areanames{zh}->{861332967} = "贵州省毕节地区";
$areanames{zh}->{861332968} = "贵州省六盘水市";
$areanames{zh}->{861332969} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861332970} = "湖北省武汉市";
$areanames{zh}->{861332971} = "湖北省武汉市";
$areanames{zh}->{861332972} = "湖北省武汉市";
$areanames{zh}->{861332973} = "湖北省武汉市";
$areanames{zh}->{861332974} = "湖北省仙桃市";
$areanames{zh}->{861332975} = "湖北省仙桃市";
$areanames{zh}->{861332976} = "湖北省荆州市";
$areanames{zh}->{861332977} = "湖北省荆州市";
$areanames{zh}->{861332978} = "湖北省荆门市";
$areanames{zh}->{861332979} = "湖北省荆门市";
$areanames{zh}->{861332980} = "湖北省宜昌市";
$areanames{zh}->{861332981} = "湖北省宜昌市";
$areanames{zh}->{861332982} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861332983} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861332984} = "湖北省十堰市";
$areanames{zh}->{861332985} = "湖北省十堰市";
$areanames{zh}->{861332986} = "湖北省襄樊市";
$areanames{zh}->{861332987} = "湖北省襄樊市";
$areanames{zh}->{861332988} = "湖北省随州市";
$areanames{zh}->{861332989} = "湖北省随州市";
$areanames{zh}->{861332990} = "湖北省孝感市";
$areanames{zh}->{861332991} = "湖北省孝感市";
$areanames{zh}->{861332992} = "湖北省黄石市";
$areanames{zh}->{861332993} = "湖北省黄石市";
$areanames{zh}->{861332994} = "湖北省黄冈市";
$areanames{zh}->{861332995} = "湖北省黄冈市";
$areanames{zh}->{861332996} = "湖北省鄂州市";
$areanames{zh}->{861332997} = "湖北省鄂州市";
$areanames{zh}->{861332998} = "湖北省咸宁市";
$areanames{zh}->{861332999} = "湖北省咸宁市";
$areanames{zh}->{861333000} = "江西省九江市";
$areanames{zh}->{861333001} = "江西省九江市";
$areanames{zh}->{861333002} = "江西省九江市";
$areanames{zh}->{861333003} = "江西省九江市";
$areanames{zh}->{861333004} = "江西省上饶市";
$areanames{zh}->{861333005} = "江西省南昌市";
$areanames{zh}->{861333006} = "江西省南昌市";
$areanames{zh}->{861333007} = "江西省南昌市";
$areanames{zh}->{861333008} = "江西省南昌市";
$areanames{zh}->{861333009} = "江西省南昌市";
$areanames{zh}->{86133301} = "江西省赣州市";
$areanames{zh}->{861333010} = "江西省南昌市";
$areanames{zh}->{861333011} = "江西省南昌市";
$areanames{zh}->{861333012} = "江西省南昌市";
$areanames{zh}->{861333019} = "江西省宜春市";
$areanames{zh}->{86133302} = "重庆市";
$areanames{zh}->{86133303} = "重庆市";
$areanames{zh}->{861333040} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861333041} = "云南省昆明市";
$areanames{zh}->{861333042} = "云南省昭通市";
$areanames{zh}->{861333043} = "云南省昆明市";
$areanames{zh}->{861333044} = "云南省昆明市";
$areanames{zh}->{861333045} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861333046} = "云南省昆明市";
$areanames{zh}->{861333047} = "云南省普洱市";
$areanames{zh}->{861333048} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861333049} = "云南省昆明市";
$areanames{zh}->{861333050} = "云南省昆明市";
$areanames{zh}->{861333051} = "云南省昆明市";
$areanames{zh}->{861333052} = "云南省昆明市";
$areanames{zh}->{861333053} = "云南省昆明市";
$areanames{zh}->{861333054} = "云南省昆明市";
$areanames{zh}->{861333055} = "云南省大理白族自治州";
$areanames{zh}->{861333056} = "云南省楚雄彝族自治州";
$areanames{zh}->{861333057} = "云南省曲靖市";
$areanames{zh}->{861333058} = "云南省玉溪市";
$areanames{zh}->{861333059} = "云南省保山市";
$areanames{zh}->{861333060} = "四川省雅安市";
$areanames{zh}->{861333061} = "四川省巴中市";
$areanames{zh}->{861333062} = "四川省广安市";
$areanames{zh}->{861333063} = "四川省遂宁市";
$areanames{zh}->{861333064} = "四川省遂宁市";
$areanames{zh}->{861333065} = "四川省宜宾市";
$areanames{zh}->{861333066} = "四川省宜宾市";
$areanames{zh}->{861333067} = "四川省巴中市";
$areanames{zh}->{861333068} = "四川省资阳市";
$areanames{zh}->{861333069} = "四川省内江市";
$areanames{zh}->{861333070} = "四川省内江市";
$areanames{zh}->{861333071} = "四川省攀枝花市";
$areanames{zh}->{861333072} = "四川省攀枝花市";
$areanames{zh}->{861333073} = "四川省广元市";
$areanames{zh}->{861333074} = "四川省泸州市";
$areanames{zh}->{861333075} = "四川省广元市";
$areanames{zh}->{861333076} = "四川省南充市";
$areanames{zh}->{861333077} = "四川省南充市";
$areanames{zh}->{861333078} = "四川省泸州市";
$areanames{zh}->{861333079} = "四川省甘孜藏族自治州";
$areanames{zh}->{861333080} = "四川省自贡市";
$areanames{zh}->{861333081} = "四川省自贡市";
$areanames{zh}->{861333082} = "四川省达州市";
$areanames{zh}->{861333083} = "四川省达州市";
$areanames{zh}->{861333084} = "四川省资阳市";
$areanames{zh}->{861333085} = "四川省德阳市";
$areanames{zh}->{861333086} = "四川省德阳市";
$areanames{zh}->{861333087} = "四川省德阳市";
$areanames{zh}->{861333088} = "四川省绵阳市";
$areanames{zh}->{861333089} = "四川省绵阳市";
$areanames{zh}->{861333090} = "四川省绵阳市";
$areanames{zh}->{861333091} = "四川省乐山市";
$areanames{zh}->{861333092} = "四川省乐山市";
$areanames{zh}->{861333093} = "四川省眉山市";
$areanames{zh}->{861333094} = "四川省成都市";
$areanames{zh}->{861333095} = "四川省眉山市";
$areanames{zh}->{861333096} = "四川省成都市";
$areanames{zh}->{861333097} = "四川省凉山彝族自治州";
$areanames{zh}->{861333098} = "四川省成都市";
$areanames{zh}->{861333099} = "四川省成都市";
$areanames{zh}->{86133310} = "北京市";
$areanames{zh}->{86133311} = "北京市";
$areanames{zh}->{86133312} = "河北省保定市";
$areanames{zh}->{86133313} = "河北省石家庄市";
$areanames{zh}->{861333130} = "河北省张家口市";
$areanames{zh}->{861333131} = "河北省张家口市";
$areanames{zh}->{861333132} = "河北省张家口市";
$areanames{zh}->{861333133} = "河北省张家口市";
$areanames{zh}->{861333140} = "吉林省白城市";
$areanames{zh}->{861333141} = "吉林省白城市";
$areanames{zh}->{861333142} = "吉林省辽源市";
$areanames{zh}->{861333143} = "吉林省辽源市";
$areanames{zh}->{861333144} = "吉林省通化市";
$areanames{zh}->{861333145} = "吉林省通化市";
$areanames{zh}->{861333146} = "吉林省通化市";
$areanames{zh}->{861333147} = "吉林省通化市";
$areanames{zh}->{861333148} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861333149} = "吉林省白山市";
$areanames{zh}->{861333150} = "吉林省吉林市";
$areanames{zh}->{861333151} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861333152} = "吉林省松原市";
$areanames{zh}->{861333153} = "吉林省通化市";
$areanames{zh}->{861333154} = "吉林省长春市";
$areanames{zh}->{861333155} = "吉林省四平市";
$areanames{zh}->{861333156} = "吉林省辽源市";
$areanames{zh}->{861333157} = "吉林省白城市";
$areanames{zh}->{861333158} = "吉林省长春市";
$areanames{zh}->{861333159} = "吉林省白山市";
$areanames{zh}->{86133316} = "吉林省长春市";
$areanames{zh}->{861333160} = "吉林省吉林市";
$areanames{zh}->{861333161} = "吉林省吉林市";
$areanames{zh}->{861333162} = "吉林省吉林市";
$areanames{zh}->{861333163} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861333170} = "吉林省吉林市";
$areanames{zh}->{861333171} = "吉林省吉林市";
$areanames{zh}->{861333172} = "吉林省吉林市";
$areanames{zh}->{861333173} = "吉林省四平市";
$areanames{zh}->{861333174} = "吉林省长春市";
$areanames{zh}->{861333175} = "吉林省长春市";
$areanames{zh}->{861333176} = "吉林省长春市";
$areanames{zh}->{861333177} = "吉林省长春市";
$areanames{zh}->{861333178} = "吉林省松原市";
$areanames{zh}->{861333179} = "吉林省通化市";
$areanames{zh}->{86133318} = "上海市";
$areanames{zh}->{86133319} = "上海市";
$areanames{zh}->{86133320} = "天津市";
$areanames{zh}->{861333210} = "辽宁省鞍山市";
$areanames{zh}->{861333211} = "辽宁省鞍山市";
$areanames{zh}->{861333212} = "辽宁省抚顺市";
$areanames{zh}->{861333213} = "辽宁省抚顺市";
$areanames{zh}->{861333214} = "辽宁省本溪市";
$areanames{zh}->{861333215} = "辽宁省本溪市";
$areanames{zh}->{861333216} = "辽宁省丹东市";
$areanames{zh}->{861333217} = "辽宁省丹东市";
$areanames{zh}->{861333218} = "辽宁省锦州市";
$areanames{zh}->{861333219} = "辽宁省锦州市";
$areanames{zh}->{86133322} = "辽宁省大连市";
$areanames{zh}->{861333230} = "辽宁省营口市";
$areanames{zh}->{861333231} = "辽宁省营口市";
$areanames{zh}->{861333232} = "辽宁省阜新市";
$areanames{zh}->{861333233} = "辽宁省辽阳市";
$areanames{zh}->{861333234} = "辽宁省辽阳市";
$areanames{zh}->{861333235} = "辽宁省铁岭市";
$areanames{zh}->{861333236} = "辽宁省朝阳市";
$areanames{zh}->{861333237} = "辽宁省盘锦市";
$areanames{zh}->{861333238} = "辽宁省盘锦市";
$areanames{zh}->{861333239} = "辽宁省葫芦岛市";
$areanames{zh}->{86133324} = "辽宁省沈阳市";
$areanames{zh}->{861333250} = "湖南省岳阳市";
$areanames{zh}->{861333251} = "湖南省长沙市";
$areanames{zh}->{861333252} = "湖南省湘潭市";
$areanames{zh}->{861333253} = "湖南省株洲市";
$areanames{zh}->{861333254} = "湖南省衡阳市";
$areanames{zh}->{861333255} = "湖南省郴州市";
$areanames{zh}->{861333256} = "湖南省常德市";
$areanames{zh}->{861333257} = "湖南省益阳市";
$areanames{zh}->{861333258} = "湖南省娄底市";
$areanames{zh}->{861333259} = "湖南省邵阳市";
$areanames{zh}->{86133326} = "广东省东莞市";
$areanames{zh}->{86133327} = "广东省梅州市";
$areanames{zh}->{861333276} = "广东省河源市";
$areanames{zh}->{861333277} = "广东省潮州市";
$areanames{zh}->{861333278} = "广东省潮州市";
$areanames{zh}->{861333279} = "广东省潮州市";
$areanames{zh}->{86133328} = "广东省广州市";
$areanames{zh}->{86133329} = "广东省深圳市";
$areanames{zh}->{861333300} = "河北省邯郸市";
$areanames{zh}->{861333301} = "河北省石家庄市";
$areanames{zh}->{861333302} = "河北省保定市";
$areanames{zh}->{861333303} = "河北省张家口市";
$areanames{zh}->{861333304} = "河北省石家庄市";
$areanames{zh}->{861333305} = "河北省唐山市";
$areanames{zh}->{861333306} = "河北省廊坊市";
$areanames{zh}->{861333307} = "河北省沧州市";
$areanames{zh}->{861333308} = "河北省衡水市";
$areanames{zh}->{861333309} = "河北省邢台市";
$areanames{zh}->{861333310} = "河北省邯郸市";
$areanames{zh}->{861333311} = "河北省石家庄市";
$areanames{zh}->{861333312} = "河北省保定市";
$areanames{zh}->{861333313} = "河北省张家口市";
$areanames{zh}->{861333314} = "河北省承德市";
$areanames{zh}->{861333315} = "河北省唐山市";
$areanames{zh}->{861333316} = "河北省廊坊市";
$areanames{zh}->{861333317} = "河北省沧州市";
$areanames{zh}->{861333318} = "河北省衡水市";
$areanames{zh}->{861333319} = "河北省邢台市";
$areanames{zh}->{861333320} = "河北省邯郸市";
$areanames{zh}->{861333321} = "河北省石家庄市";
$areanames{zh}->{861333322} = "河北省保定市";
$areanames{zh}->{861333323} = "河北省张家口市";
$areanames{zh}->{861333324} = "河北省保定市";
$areanames{zh}->{861333325} = "河北省唐山市";
$areanames{zh}->{861333326} = "河北省廊坊市";
$areanames{zh}->{861333327} = "河北省沧州市";
$areanames{zh}->{861333328} = "河北省秦皇岛市";
$areanames{zh}->{861333329} = "河北省唐山市";
$areanames{zh}->{86133333} = "河北省秦皇岛市";
$areanames{zh}->{861333336} = "河北省沧州市";
$areanames{zh}->{861333337} = "河北省石家庄市";
$areanames{zh}->{861333338} = "河北省石家庄市";
$areanames{zh}->{861333339} = "河北省承德市";
$areanames{zh}->{861333340} = "山西省太原市";
$areanames{zh}->{861333341} = "山西省太原市";
$areanames{zh}->{861333342} = "山西省大同市";
$areanames{zh}->{861333343} = "山西省太原市";
$areanames{zh}->{861333344} = "山西省晋中市";
$areanames{zh}->{861333345} = "山西省长治市";
$areanames{zh}->{861333346} = "山西省太原市";
$areanames{zh}->{861333347} = "山西省临汾市";
$areanames{zh}->{861333348} = "山西省运城市";
$areanames{zh}->{861333349} = "山西省朔州市";
$areanames{zh}->{861333350} = "山西省忻州市";
$areanames{zh}->{861333351} = "山西省太原市";
$areanames{zh}->{861333352} = "山西省大同市";
$areanames{zh}->{861333353} = "山西省阳泉市";
$areanames{zh}->{861333354} = "山西省晋中市";
$areanames{zh}->{861333355} = "山西省长治市";
$areanames{zh}->{861333356} = "山西省晋城市";
$areanames{zh}->{861333357} = "山西省临汾市";
$areanames{zh}->{861333358} = "山西省吕梁市";
$areanames{zh}->{861333359} = "山西省运城市";
$areanames{zh}->{86133336} = "河南省南阳市";
$areanames{zh}->{861333370} = "河南省商丘市";
$areanames{zh}->{861333371} = "河南省郑州市";
$areanames{zh}->{861333372} = "河南省安阳市";
$areanames{zh}->{861333373} = "河南省新乡市";
$areanames{zh}->{861333374} = "河南省许昌市";
$areanames{zh}->{861333375} = "河南省平顶山市";
$areanames{zh}->{861333376} = "河南省信阳市";
$areanames{zh}->{861333377} = "河南省南阳市";
$areanames{zh}->{861333378} = "河南省开封市";
$areanames{zh}->{861333379} = "河南省洛阳市";
$areanames{zh}->{86133338} = "河南省郑州市";
$areanames{zh}->{861333380} = "河南省新乡市";
$areanames{zh}->{861333387} = "河南省洛阳市";
$areanames{zh}->{861333388} = "河南省洛阳市";
$areanames{zh}->{861333389} = "河南省洛阳市";
$areanames{zh}->{861333390} = "河南省平顶山市";
$areanames{zh}->{861333391} = "河南省焦作市";
$areanames{zh}->{861333392} = "河南省鹤壁市";
$areanames{zh}->{861333393} = "河南省濮阳市";
$areanames{zh}->{861333394} = "河南省周口市";
$areanames{zh}->{861333395} = "河南省漯河市";
$areanames{zh}->{861333396} = "河南省驻马店市";
$areanames{zh}->{861333397} = "河南省信阳市";
$areanames{zh}->{861333398} = "河南省三门峡市";
$areanames{zh}->{861333399} = "河南省许昌市";
$areanames{zh}->{86133343} = "广东省佛山市";
$areanames{zh}->{86133347} = "云南省普洱市";
$areanames{zh}->{86133350} = "山东省青岛市";
$areanames{zh}->{86133351} = "山东省济南市";
$areanames{zh}->{861333520} = "山东省淄博市";
$areanames{zh}->{861333521} = "山东省淄博市";
$areanames{zh}->{861333522} = "山东省淄博市";
$areanames{zh}->{861333523} = "山东省淄博市";
$areanames{zh}->{861333524} = "山东省潍坊市";
$areanames{zh}->{861333525} = "山东省潍坊市";
$areanames{zh}->{861333526} = "山东省潍坊市";
$areanames{zh}->{861333527} = "山东省泰安市";
$areanames{zh}->{861333528} = "山东省泰安市";
$areanames{zh}->{861333529} = "山东省泰安市";
$areanames{zh}->{861333530} = "陕西省咸阳市";
$areanames{zh}->{861333531} = "陕西省延安市";
$areanames{zh}->{861333532} = "陕西省榆林市";
$areanames{zh}->{861333533} = "陕西省渭南市";
$areanames{zh}->{861333534} = "陕西省渭南市";
$areanames{zh}->{861333535} = "陕西省渭南市";
$areanames{zh}->{861333536} = "陕西省汉中市";
$areanames{zh}->{861333537} = "陕西省宝鸡市";
$areanames{zh}->{861333538} = "陕西省西安市";
$areanames{zh}->{861333539} = "陕西省西安市";
$areanames{zh}->{861333540} = "陕西省咸阳市";
$areanames{zh}->{861333541} = "陕西省咸阳市";
$areanames{zh}->{861333542} = "陕西省咸阳市";
$areanames{zh}->{861333543} = "陕西省咸阳市";
$areanames{zh}->{861333544} = "陕西省汉中市";
$areanames{zh}->{861333545} = "陕西省汉中市";
$areanames{zh}->{861333546} = "陕西省宝鸡市";
$areanames{zh}->{861333547} = "陕西省宝鸡市";
$areanames{zh}->{861333548} = "陕西省宝鸡市";
$areanames{zh}->{861333549} = "陕西省宝鸡市";
$areanames{zh}->{861333550} = "安徽省滁州市";
$areanames{zh}->{861333551} = "安徽省合肥市";
$areanames{zh}->{861333552} = "安徽省蚌埠市";
$areanames{zh}->{861333553} = "安徽省芜湖市";
$areanames{zh}->{861333554} = "安徽省淮南市";
$areanames{zh}->{861333555} = "安徽省马鞍山市";
$areanames{zh}->{861333556} = "安徽省安庆市";
$areanames{zh}->{861333557} = "安徽省宿州市";
$areanames{zh}->{861333558} = "安徽省阜阳市";
$areanames{zh}->{861333559} = "安徽省黄山市";
$areanames{zh}->{861333560} = "安徽省淮北市";
$areanames{zh}->{861333561} = "安徽省淮北市";
$areanames{zh}->{861333562} = "安徽省铜陵市";
$areanames{zh}->{861333563} = "安徽省宣城市";
$areanames{zh}->{861333564} = "安徽省六安市";
$areanames{zh}->{861333565} = "安徽省巢湖市";
$areanames{zh}->{861333566} = "安徽省池州市";
$areanames{zh}->{861333567} = "安徽省亳州市";
$areanames{zh}->{861333568} = "安徽省亳州市";
$areanames{zh}->{861333569} = "安徽省黄山市";
$areanames{zh}->{861333570} = "浙江省衢州市";
$areanames{zh}->{861333571} = "浙江省杭州市";
$areanames{zh}->{861333572} = "浙江省湖州市";
$areanames{zh}->{861333573} = "浙江省嘉兴市";
$areanames{zh}->{861333574} = "浙江省宁波市";
$areanames{zh}->{861333575} = "浙江省绍兴市";
$areanames{zh}->{861333576} = "浙江省台州市";
$areanames{zh}->{861333577} = "浙江省温州市";
$areanames{zh}->{861333578} = "浙江省绍兴市";
$areanames{zh}->{861333579} = "浙江省金华市";
$areanames{zh}->{861333580} = "浙江省舟山市";
$areanames{zh}->{861333581} = "浙江省杭州市";
$areanames{zh}->{861333582} = "浙江省湖州市";
$areanames{zh}->{861333583} = "浙江省嘉兴市";
$areanames{zh}->{861333584} = "浙江省宁波市";
$areanames{zh}->{861333585} = "浙江省绍兴市";
$areanames{zh}->{861333586} = "浙江省台州市";
$areanames{zh}->{861333587} = "浙江省温州市";
$areanames{zh}->{861333588} = "浙江省杭州市";
$areanames{zh}->{861333589} = "浙江省金华市";
$areanames{zh}->{86133359} = "浙江省金华市";
$areanames{zh}->{86133360} = "浙江省杭州市";
$areanames{zh}->{86133361} = "浙江省杭州市";
$areanames{zh}->{861333620} = "山东省菏泽市";
$areanames{zh}->{861333621} = "山东省菏泽市";
$areanames{zh}->{861333622} = "山东省聊城市";
$areanames{zh}->{861333623} = "山东省日照市";
$areanames{zh}->{861333624} = "山东省威海市";
$areanames{zh}->{861333625} = "山东省聊城市";
$areanames{zh}->{861333626} = "山东省德州市";
$areanames{zh}->{861333627} = "山东省德州市";
$areanames{zh}->{861333628} = "山东省滨州市";
$areanames{zh}->{861333629} = "山东省滨州市";
$areanames{zh}->{861333630} = "山东省威海市";
$areanames{zh}->{861333631} = "山东省威海市";
$areanames{zh}->{861333632} = "山东省枣庄市";
$areanames{zh}->{861333633} = "山东省日照市";
$areanames{zh}->{861333634} = "山东省莱芜市";
$areanames{zh}->{861333635} = "山东省聊城市";
$areanames{zh}->{861333636} = "山东省潍坊市";
$areanames{zh}->{861333637} = "山东省枣庄市";
$areanames{zh}->{861333638} = "山东省烟台市";
$areanames{zh}->{861333639} = "山东省青岛市";
$areanames{zh}->{86133364} = "广东省佛山市";
$areanames{zh}->{861333650} = "广东省湛江市";
$areanames{zh}->{861333651} = "广东省湛江市";
$areanames{zh}->{861333652} = "广东省茂名市";
$areanames{zh}->{861333653} = "广东省茂名市";
$areanames{zh}->{861333654} = "广东省深圳市";
$areanames{zh}->{861333655} = "广东省茂名市";
$areanames{zh}->{861333656} = "广东省茂名市";
$areanames{zh}->{861333657} = "广东省阳江市";
$areanames{zh}->{861333658} = "广东省阳江市";
$areanames{zh}->{861333659} = "广东省阳江市";
$areanames{zh}->{86133366} = "浙江省宁波市";
$areanames{zh}->{86133367} = "浙江省台州市";
$areanames{zh}->{861333670} = "浙江省绍兴市";
$areanames{zh}->{861333671} = "浙江省绍兴市";
$areanames{zh}->{861333680} = "浙江省绍兴市";
$areanames{zh}->{861333681} = "浙江省绍兴市";
$areanames{zh}->{861333682} = "浙江省绍兴市";
$areanames{zh}->{861333683} = "浙江省湖州市";
$areanames{zh}->{861333684} = "浙江省湖州市";
$areanames{zh}->{861333685} = "浙江省湖州市";
$areanames{zh}->{861333686} = "浙江省宁波市";
$areanames{zh}->{861333687} = "浙江省宁波市";
$areanames{zh}->{861333688} = "浙江省宁波市";
$areanames{zh}->{861333689} = "浙江省宁波市";
$areanames{zh}->{86133369} = "浙江省温州市";
$areanames{zh}->{861333700} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861333701} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861333702} = "内蒙古兴安盟";
$areanames{zh}->{861333703} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861333704} = "内蒙古通辽市";
$areanames{zh}->{861333705} = "内蒙古通辽市";
$areanames{zh}->{861333706} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861333707} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861333708} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861333709} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861333710} = "内蒙古呼和浩特市";
$areanames{zh}->{861333711} = "内蒙古呼和浩特市";
$areanames{zh}->{861333712} = "内蒙古呼和浩特市";
$areanames{zh}->{861333713} = "内蒙古兴安盟";
$areanames{zh}->{861333714} = "内蒙古兴安盟";
$areanames{zh}->{861333715} = "内蒙古赤峰市";
$areanames{zh}->{861333716} = "内蒙古赤峰市";
$areanames{zh}->{861333717} = "内蒙古包头市";
$areanames{zh}->{861333718} = "内蒙古包头市";
$areanames{zh}->{861333719} = "内蒙古包头市";
$areanames{zh}->{861333720} = "湖南省岳阳市";
$areanames{zh}->{861333721} = "湖南省长沙市";
$areanames{zh}->{861333722} = "湖南省湘潭市";
$areanames{zh}->{861333723} = "湖南省株洲市";
$areanames{zh}->{861333724} = "湖南省张家界市";
$areanames{zh}->{861333725} = "湖南省怀化市";
$areanames{zh}->{861333726} = "湖南省永州市";
$areanames{zh}->{861333727} = "湖南省益阳市";
$areanames{zh}->{861333728} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861333729} = "湖南省邵阳市";
$areanames{zh}->{861333730} = "湖南省岳阳市";
$areanames{zh}->{861333731} = "湖南省长沙市";
$areanames{zh}->{861333732} = "湖南省湘潭市";
$areanames{zh}->{861333733} = "湖南省株洲市";
$areanames{zh}->{861333734} = "湖南省衡阳市";
$areanames{zh}->{861333735} = "湖南省郴州市";
$areanames{zh}->{861333736} = "湖南省常德市";
$areanames{zh}->{861333737} = "湖南省益阳市";
$areanames{zh}->{861333738} = "湖南省娄底市";
$areanames{zh}->{861333739} = "湖南省邵阳市";
$areanames{zh}->{86133374} = "湖北省黄冈市";
$areanames{zh}->{861333747} = "湖北省荆门市";
$areanames{zh}->{861333748} = "湖北省荆门市";
$areanames{zh}->{861333749} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{86133375} = "海南省海口市";
$areanames{zh}->{86133376} = "海南省海口市";
$areanames{zh}->{861333770} = "江苏省南京市";
$areanames{zh}->{861333771} = "江苏省南京市";
$areanames{zh}->{861333772} = "江苏省南京市";
$areanames{zh}->{861333773} = "江苏省南京市";
$areanames{zh}->{861333774} = "江苏省镇江市";
$areanames{zh}->{861333775} = "江苏省镇江市";
$areanames{zh}->{861333776} = "江苏省镇江市";
$areanames{zh}->{861333777} = "江苏省镇江市";
$areanames{zh}->{861333778} = "江苏省泰州市";
$areanames{zh}->{861333779} = "江苏省泰州市";
$areanames{zh}->{861333780} = "江苏省南京市";
$areanames{zh}->{861333781} = "江苏省南京市";
$areanames{zh}->{861333782} = "江苏省南京市";
$areanames{zh}->{861333783} = "江苏省南京市";
$areanames{zh}->{861333784} = "江苏省宿迁市";
$areanames{zh}->{861333785} = "江苏省宿迁市";
$areanames{zh}->{861333786} = "江苏省连云港市";
$areanames{zh}->{861333787} = "江苏省连云港市";
$areanames{zh}->{861333788} = "江苏省常州市";
$areanames{zh}->{861333789} = "江苏省常州市";
$areanames{zh}->{861333790} = "江苏省无锡市";
$areanames{zh}->{861333791} = "江苏省无锡市";
$areanames{zh}->{861333792} = "江苏省无锡市";
$areanames{zh}->{861333793} = "江苏省徐州市";
$areanames{zh}->{861333794} = "江苏省徐州市";
$areanames{zh}->{861333795} = "江苏省徐州市";
$areanames{zh}->{861333796} = "江苏省淮安市";
$areanames{zh}->{861333797} = "江苏省淮安市";
$areanames{zh}->{861333798} = "江苏省盐城市";
$areanames{zh}->{861333799} = "江苏省盐城市";
$areanames{zh}->{86133380} = "江苏省苏州市";
$areanames{zh}->{861333806} = "江苏省南通市";
$areanames{zh}->{861333807} = "江苏省南通市";
$areanames{zh}->{861333808} = "江苏省南通市";
$areanames{zh}->{861333809} = "江苏省南通市";
$areanames{zh}->{861333810} = "江苏省无锡市";
$areanames{zh}->{861333811} = "江苏省无锡市";
$areanames{zh}->{861333812} = "江苏省扬州市";
$areanames{zh}->{861333813} = "江苏省扬州市";
$areanames{zh}->{861333814} = "江苏省扬州市";
$areanames{zh}->{861333815} = "江苏省无锡市";
$areanames{zh}->{861333816} = "江苏省常州市";
$areanames{zh}->{861333817} = "江苏省常州市";
$areanames{zh}->{861333818} = "江苏省常州市";
$areanames{zh}->{861333819} = "江苏省常州市";
$areanames{zh}->{861333820} = "福建省宁德市";
$areanames{zh}->{861333821} = "福建省宁德市";
$areanames{zh}->{861333822} = "福建省宁德市";
$areanames{zh}->{861333823} = "福建省三明市";
$areanames{zh}->{861333824} = "福建省三明市";
$areanames{zh}->{861333825} = "福建省福州市";
$areanames{zh}->{861333826} = "福建省福州市";
$areanames{zh}->{861333827} = "福建省福州市";
$areanames{zh}->{861333828} = "福建省福州市";
$areanames{zh}->{861333829} = "福建省福州市";
$areanames{zh}->{86133383} = "福建省漳州市";
$areanames{zh}->{861333836} = "福建省厦门市";
$areanames{zh}->{861333837} = "福建省龙岩市";
$areanames{zh}->{861333838} = "福建省龙岩市";
$areanames{zh}->{861333839} = "福建省龙岩市";
$areanames{zh}->{861333840} = "福建省福州市";
$areanames{zh}->{861333841} = "福建省福州市";
$areanames{zh}->{861333842} = "福建省福州市";
$areanames{zh}->{861333843} = "福建省福州市";
$areanames{zh}->{861333844} = "福建省福州市";
$areanames{zh}->{861333845} = "福建省厦门市";
$areanames{zh}->{861333846} = "福建省厦门市";
$areanames{zh}->{861333847} = "福建省泉州市";
$areanames{zh}->{861333848} = "福建省泉州市";
$areanames{zh}->{861333849} = "福建省泉州市";
$areanames{zh}->{861333850} = "福建省莆田市";
$areanames{zh}->{861333851} = "福建省莆田市";
$areanames{zh}->{861333852} = "福建省莆田市";
$areanames{zh}->{861333853} = "福建省南平市";
$areanames{zh}->{861333854} = "福建省南平市";
$areanames{zh}->{861333855} = "福建省南平市";
$areanames{zh}->{861333856} = "福建省泉州市";
$areanames{zh}->{861333857} = "福建省泉州市";
$areanames{zh}->{861333858} = "福建省泉州市";
$areanames{zh}->{861333859} = "福建省泉州市";
$areanames{zh}->{86133386} = "江苏省苏州市";
$areanames{zh}->{861333860} = "江苏省南京市";
$areanames{zh}->{861333861} = "江苏省南京市";
$areanames{zh}->{861333862} = "江苏省南京市";
$areanames{zh}->{861333863} = "江苏省南京市";
$areanames{zh}->{86133387} = "江苏省无锡市";
$areanames{zh}->{861333870} = "江苏省苏州市";
$areanames{zh}->{861333871} = "江苏省苏州市";
$areanames{zh}->{861333872} = "江苏省苏州市";
$areanames{zh}->{861333879} = "江苏省常州市";
$areanames{zh}->{861333880} = "江苏省常州市";
$areanames{zh}->{861333881} = "江苏省镇江市";
$areanames{zh}->{861333882} = "江苏省南通市";
$areanames{zh}->{861333883} = "江苏省南通市";
$areanames{zh}->{861333884} = "江苏省扬州市";
$areanames{zh}->{861333885} = "江苏省扬州市";
$areanames{zh}->{861333886} = "江苏省扬州市";
$areanames{zh}->{861333887} = "江苏省泰州市";
$areanames{zh}->{861333888} = "江苏省泰州市";
$areanames{zh}->{861333889} = "江苏省泰州市";
$areanames{zh}->{861333890} = "江苏省淮安市";
$areanames{zh}->{861333891} = "江苏省淮安市";
$areanames{zh}->{861333892} = "江苏省盐城市";
$areanames{zh}->{861333893} = "江苏省盐城市";
$areanames{zh}->{861333894} = "江苏省盐城市";
$areanames{zh}->{861333895} = "江苏省盐城市";
$areanames{zh}->{861333896} = "江苏省徐州市";
$areanames{zh}->{861333897} = "江苏省徐州市";
$areanames{zh}->{861333898} = "江苏省连云港市";
$areanames{zh}->{861333899} = "江苏省连云港市";
$areanames{zh}->{861333900} = "安徽省滁州市";
$areanames{zh}->{861333901} = "安徽省合肥市";
$areanames{zh}->{861333902} = "安徽省蚌埠市";
$areanames{zh}->{861333903} = "安徽省芜湖市";
$areanames{zh}->{861333904} = "安徽省阜阳市";
$areanames{zh}->{861333905} = "安徽省马鞍山市";
$areanames{zh}->{861333906} = "安徽省安庆市";
$areanames{zh}->{861333907} = "安徽省宿州市";
$areanames{zh}->{861333908} = "安徽省蚌埠市";
$areanames{zh}->{861333909} = "安徽省黄山市";
$areanames{zh}->{861333910} = "安徽省合肥市";
$areanames{zh}->{861333911} = "安徽省六安市";
$areanames{zh}->{861333912} = "安徽省铜陵市";
$areanames{zh}->{861333913} = "安徽省宣城市";
$areanames{zh}->{861333914} = "安徽省合肥市";
$areanames{zh}->{861333915} = "安徽省巢湖市";
$areanames{zh}->{861333916} = "安徽省池州市";
$areanames{zh}->{861333917} = "安徽省亳州市";
$areanames{zh}->{861333918} = "安徽省淮南市";
$areanames{zh}->{861333919} = "安徽省合肥市";
$areanames{zh}->{861333920} = "安徽省滁州市";
$areanames{zh}->{861333921} = "安徽省淮北市";
$areanames{zh}->{861333922} = "安徽省阜阳市";
$areanames{zh}->{861333923} = "安徽省芜湖市";
$areanames{zh}->{861333924} = "安徽省宣城市";
$areanames{zh}->{861333925} = "安徽省铜陵市";
$areanames{zh}->{861333926} = "安徽省安庆市";
$areanames{zh}->{861333927} = "安徽省亳州市";
$areanames{zh}->{861333928} = "安徽省合肥市";
$areanames{zh}->{861333929} = "安徽省合肥市";
$areanames{zh}->{861333930} = "黑龙江省哈尔滨市";
$areanames{zh}->{861333931} = "黑龙江省哈尔滨市";
$areanames{zh}->{861333932} = "黑龙江省七台河市";
$areanames{zh}->{861333933} = "黑龙江省双鸭山市";
$areanames{zh}->{861333934} = "黑龙江省双鸭山市";
$areanames{zh}->{861333935} = "黑龙江省绥化市";
$areanames{zh}->{861333936} = "黑龙江省黑河市";
$areanames{zh}->{861333937} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861333938} = "黑龙江省伊春市";
$areanames{zh}->{861333939} = "黑龙江省大庆市";
$areanames{zh}->{861333940} = "黑龙江省哈尔滨市";
$areanames{zh}->{861333941} = "黑龙江省哈尔滨市";
$areanames{zh}->{861333942} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861333943} = "黑龙江省牡丹江市";
$areanames{zh}->{861333944} = "黑龙江省佳木斯市";
$areanames{zh}->{861333945} = "黑龙江省绥化市";
$areanames{zh}->{861333946} = "黑龙江省黑河市";
$areanames{zh}->{861333947} = "黑龙江省大庆市";
$areanames{zh}->{861333948} = "黑龙江省伊春市";
$areanames{zh}->{861333949} = "黑龙江省大庆市";
$areanames{zh}->{861333950} = "黑龙江省大庆市";
$areanames{zh}->{861333951} = "黑龙江省哈尔滨市";
$areanames{zh}->{861333952} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861333953} = "黑龙江省牡丹江市";
$areanames{zh}->{861333954} = "黑龙江省佳木斯市";
$areanames{zh}->{861333955} = "黑龙江省佳木斯市";
$areanames{zh}->{861333956} = "黑龙江省鸡西市";
$areanames{zh}->{861333957} = "黑龙江省鸡西市";
$areanames{zh}->{861333958} = "黑龙江省鹤岗市";
$areanames{zh}->{861333959} = "黑龙江省大庆市";
$areanames{zh}->{861333960} = "贵州省贵阳市";
$areanames{zh}->{861333961} = "贵州省贵阳市";
$areanames{zh}->{861333962} = "贵州省遵义市";
$areanames{zh}->{861333963} = "贵州省安顺市";
$areanames{zh}->{861333964} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861333965} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861333966} = "贵州省铜仁地区";
$areanames{zh}->{861333967} = "贵州省毕节地区";
$areanames{zh}->{861333968} = "贵州省六盘水市";
$areanames{zh}->{861333969} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861333970} = "湖北省仙桃市";
$areanames{zh}->{861333971} = "湖北省武汉市";
$areanames{zh}->{861333972} = "湖北省武汉市";
$areanames{zh}->{861333973} = "湖北省荆州市";
$areanames{zh}->{861333974} = "湖北省荆州市";
$areanames{zh}->{861333975} = "湖北省荆门市";
$areanames{zh}->{861333976} = "湖北省荆门市";
$areanames{zh}->{861333977} = "湖北省荆门市";
$areanames{zh}->{861333978} = "湖北省宜昌市";
$areanames{zh}->{861333979} = "湖北省宜昌市";
$areanames{zh}->{861333980} = "湖北省襄樊市";
$areanames{zh}->{861333981} = "湖北省襄樊市";
$areanames{zh}->{861333982} = "湖北省襄樊市";
$areanames{zh}->{861333983} = "湖北省孝感市";
$areanames{zh}->{861333984} = "湖北省孝感市";
$areanames{zh}->{861333985} = "湖北省十堰市";
$areanames{zh}->{861333986} = "湖北省十堰市";
$areanames{zh}->{861333987} = "湖北省咸宁市";
$areanames{zh}->{861333988} = "湖北省咸宁市";
$areanames{zh}->{861333989} = "湖北省随州市";
$areanames{zh}->{861333990} = "湖北省黄石市";
$areanames{zh}->{861333991} = "湖北省黄石市";
$areanames{zh}->{861333992} = "湖北省黄石市";
$areanames{zh}->{861333993} = "湖北省鄂州市";
$areanames{zh}->{861333994} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861333995} = "湖北省黄冈市";
$areanames{zh}->{861333996} = "湖北省黄冈市";
$areanames{zh}->{861333997} = "湖北省黄冈市";
$areanames{zh}->{861333998} = "湖北省武汉市";
$areanames{zh}->{861333999} = "湖北省武汉市";
$areanames{zh}->{861334000} = "江西省新余市";
$areanames{zh}->{861334001} = "江西省南昌市";
$areanames{zh}->{861334002} = "江西省九江市";
$areanames{zh}->{861334003} = "江西省上饶市";
$areanames{zh}->{861334004} = "江西省赣州市";
$areanames{zh}->{861334005} = "江西省宜春市";
$areanames{zh}->{861334006} = "江西省吉安市";
$areanames{zh}->{861334007} = "江西省景德镇市";
$areanames{zh}->{861334008} = "江西省上饶市";
$areanames{zh}->{861334009} = "江西省宜春市";
$areanames{zh}->{861334010} = "江西省鹰潭市";
$areanames{zh}->{861334011} = "江西省南昌市";
$areanames{zh}->{861334012} = "江西省九江市";
$areanames{zh}->{861334013} = "江西省上饶市";
$areanames{zh}->{861334014} = "江西省吉安市";
$areanames{zh}->{861334015} = "江西省宜春市";
$areanames{zh}->{861334016} = "江西省萍乡市";
$areanames{zh}->{861334017} = "江西省赣州市";
$areanames{zh}->{861334018} = "江西省抚州市";
$areanames{zh}->{861334019} = "江西省抚州市";
$areanames{zh}->{86133402} = "重庆市";
$areanames{zh}->{86133403} = "重庆市";
$areanames{zh}->{861334040} = "福建省福州市";
$areanames{zh}->{861334041} = "福建省福州市";
$areanames{zh}->{861334042} = "福建省福州市";
$areanames{zh}->{861334043} = "福建省厦门市";
$areanames{zh}->{861334044} = "福建省泉州市";
$areanames{zh}->{861334045} = "福建省泉州市";
$areanames{zh}->{861334046} = "福建省泉州市";
$areanames{zh}->{861334047} = "福建省宁德市";
$areanames{zh}->{861334048} = "福建省莆田市";
$areanames{zh}->{861334049} = "福建省莆田市";
$areanames{zh}->{861334050} = "福建省南平市";
$areanames{zh}->{861334051} = "福建省南平市";
$areanames{zh}->{861334052} = "福建省南平市";
$areanames{zh}->{861334053} = "福建省南平市";
$areanames{zh}->{861334054} = "福建省三明市";
$areanames{zh}->{861334055} = "福建省三明市";
$areanames{zh}->{861334056} = "福建省龙岩市";
$areanames{zh}->{861334057} = "福建省龙岩市";
$areanames{zh}->{861334058} = "福建省龙岩市";
$areanames{zh}->{861334059} = "福建省龙岩市";
$areanames{zh}->{861334060} = "四川省雅安市";
$areanames{zh}->{861334061} = "四川省巴中市";
$areanames{zh}->{861334062} = "四川省广安市";
$areanames{zh}->{861334063} = "四川省遂宁市";
$areanames{zh}->{861334064} = "四川省遂宁市";
$areanames{zh}->{861334065} = "四川省宜宾市";
$areanames{zh}->{861334066} = "四川省宜宾市";
$areanames{zh}->{861334067} = "四川省达州市";
$areanames{zh}->{861334068} = "四川省资阳市";
$areanames{zh}->{861334069} = "四川省内江市";
$areanames{zh}->{861334070} = "四川省内江市";
$areanames{zh}->{861334071} = "四川省攀枝花市";
$areanames{zh}->{861334072} = "四川省攀枝花市";
$areanames{zh}->{861334073} = "四川省广元市";
$areanames{zh}->{861334074} = "四川省泸州市";
$areanames{zh}->{861334075} = "四川省广元市";
$areanames{zh}->{861334076} = "四川省南充市";
$areanames{zh}->{861334077} = "四川省南充市";
$areanames{zh}->{861334078} = "四川省泸州市";
$areanames{zh}->{861334079} = "四川省资阳市";
$areanames{zh}->{861334080} = "四川省自贡市";
$areanames{zh}->{861334081} = "四川省自贡市";
$areanames{zh}->{861334082} = "四川省达州市";
$areanames{zh}->{861334083} = "四川省达州市";
$areanames{zh}->{861334084} = "四川省资阳市";
$areanames{zh}->{861334085} = "四川省德阳市";
$areanames{zh}->{861334086} = "四川省德阳市";
$areanames{zh}->{861334087} = "四川省德阳市";
$areanames{zh}->{861334088} = "四川省绵阳市";
$areanames{zh}->{861334089} = "四川省绵阳市";
$areanames{zh}->{861334090} = "四川省绵阳市";
$areanames{zh}->{861334091} = "四川省乐山市";
$areanames{zh}->{861334092} = "四川省乐山市";
$areanames{zh}->{861334093} = "四川省眉山市";
$areanames{zh}->{861334094} = "四川省成都市";
$areanames{zh}->{861334095} = "四川省眉山市";
$areanames{zh}->{861334096} = "四川省成都市";
$areanames{zh}->{861334097} = "四川省凉山彝族自治州";
$areanames{zh}->{861334098} = "四川省成都市";
$areanames{zh}->{861334099} = "四川省成都市";
$areanames{zh}->{86133410} = "北京市";
$areanames{zh}->{86133411} = "北京市";
$areanames{zh}->{861334120} = "山东省济宁市";
$areanames{zh}->{861334121} = "山东省济宁市";
$areanames{zh}->{861334122} = "山东省青岛市";
$areanames{zh}->{861334123} = "山东省青岛市";
$areanames{zh}->{861334124} = "山东省青岛市";
$areanames{zh}->{861334125} = "山东省淄博市";
$areanames{zh}->{861334126} = "山东省淄博市";
$areanames{zh}->{861334127} = "山东省临沂市";
$areanames{zh}->{861334128} = "山东省临沂市";
$areanames{zh}->{861334129} = "山东省潍坊市";
$areanames{zh}->{861334130} = "湖南省岳阳市";
$areanames{zh}->{861334131} = "湖南省长沙市";
$areanames{zh}->{861334132} = "湖南省湘潭市";
$areanames{zh}->{861334133} = "湖南省株洲市";
$areanames{zh}->{861334134} = "湖南省衡阳市";
$areanames{zh}->{861334135} = "湖南省郴州市";
$areanames{zh}->{861334136} = "湖南省常德市";
$areanames{zh}->{861334137} = "湖南省益阳市";
$areanames{zh}->{861334138} = "湖南省娄底市";
$areanames{zh}->{861334139} = "湖南省邵阳市";
$areanames{zh}->{86133414} = "吉林省长春市";
$areanames{zh}->{861334150} = "吉林省吉林市";
$areanames{zh}->{861334151} = "吉林省吉林市";
$areanames{zh}->{861334152} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861334153} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861334154} = "吉林省吉林市";
$areanames{zh}->{861334155} = "吉林省松原市";
$areanames{zh}->{861334156} = "吉林省通化市";
$areanames{zh}->{861334157} = "吉林省长春市";
$areanames{zh}->{861334158} = "吉林省长春市";
$areanames{zh}->{861334159} = "吉林省长春市";
$areanames{zh}->{86133416} = "上海市";
$areanames{zh}->{86133417} = "上海市";
$areanames{zh}->{86133418} = "上海市";
$areanames{zh}->{86133419} = "上海市";
$areanames{zh}->{86133420} = "天津市";
$areanames{zh}->{861334210} = "辽宁省鞍山市";
$areanames{zh}->{861334211} = "辽宁省鞍山市";
$areanames{zh}->{861334212} = "辽宁省抚顺市";
$areanames{zh}->{861334213} = "辽宁省抚顺市";
$areanames{zh}->{861334214} = "辽宁省本溪市";
$areanames{zh}->{861334215} = "辽宁省本溪市";
$areanames{zh}->{861334216} = "辽宁省丹东市";
$areanames{zh}->{861334217} = "辽宁省丹东市";
$areanames{zh}->{861334218} = "辽宁省锦州市";
$areanames{zh}->{861334219} = "辽宁省锦州市";
$areanames{zh}->{86133422} = "辽宁省大连市";
$areanames{zh}->{861334230} = "辽宁省营口市";
$areanames{zh}->{861334231} = "辽宁省营口市";
$areanames{zh}->{861334232} = "辽宁省阜新市";
$areanames{zh}->{861334233} = "辽宁省辽阳市";
$areanames{zh}->{861334234} = "辽宁省辽阳市";
$areanames{zh}->{861334235} = "辽宁省铁岭市";
$areanames{zh}->{861334236} = "辽宁省朝阳市";
$areanames{zh}->{861334237} = "辽宁省盘锦市";
$areanames{zh}->{861334238} = "辽宁省盘锦市";
$areanames{zh}->{861334239} = "辽宁省葫芦岛市";
$areanames{zh}->{86133424} = "辽宁省沈阳市";
$areanames{zh}->{861334250} = "湖南省岳阳市";
$areanames{zh}->{861334251} = "湖南省长沙市";
$areanames{zh}->{861334252} = "湖南省湘潭市";
$areanames{zh}->{861334253} = "湖南省株洲市";
$areanames{zh}->{861334254} = "湖南省衡阳市";
$areanames{zh}->{861334255} = "湖南省郴州市";
$areanames{zh}->{861334256} = "湖南省常德市";
$areanames{zh}->{861334257} = "湖南省益阳市";
$areanames{zh}->{861334258} = "湖南省娄底市";
$areanames{zh}->{861334259} = "湖南省邵阳市";
$areanames{zh}->{86133426} = "广东省东莞市";
$areanames{zh}->{86133427} = "广东省汕头市";
$areanames{zh}->{861334278} = "广东省潮州市";
$areanames{zh}->{861334279} = "广东省潮州市";
$areanames{zh}->{86133428} = "广东省广州市";
$areanames{zh}->{86133429} = "广东省深圳市";
$areanames{zh}->{861334300} = "河北省邯郸市";
$areanames{zh}->{861334301} = "河北省石家庄市";
$areanames{zh}->{861334302} = "河北省保定市";
$areanames{zh}->{861334303} = "河北省石家庄市";
$areanames{zh}->{861334304} = "河北省石家庄市";
$areanames{zh}->{861334305} = "河北省唐山市";
$areanames{zh}->{861334306} = "河北省廊坊市";
$areanames{zh}->{861334307} = "河北省沧州市";
$areanames{zh}->{861334308} = "河北省保定市";
$areanames{zh}->{861334309} = "河北省保定市";
$areanames{zh}->{861334310} = "河北省邯郸市";
$areanames{zh}->{861334311} = "河北省石家庄市";
$areanames{zh}->{861334312} = "河北省保定市";
$areanames{zh}->{861334313} = "河北省张家口市";
$areanames{zh}->{861334314} = "河北省承德市";
$areanames{zh}->{861334315} = "河北省唐山市";
$areanames{zh}->{861334316} = "河北省廊坊市";
$areanames{zh}->{861334317} = "河北省沧州市";
$areanames{zh}->{861334318} = "河北省衡水市";
$areanames{zh}->{861334319} = "河北省邢台市";
$areanames{zh}->{861334320} = "河北省邯郸市";
$areanames{zh}->{861334321} = "河北省石家庄市";
$areanames{zh}->{861334322} = "河北省保定市";
$areanames{zh}->{861334323} = "河北省石家庄市";
$areanames{zh}->{861334324} = "河北省石家庄市";
$areanames{zh}->{861334325} = "河北省唐山市";
$areanames{zh}->{861334326} = "河北省廊坊市";
$areanames{zh}->{861334327} = "河北省沧州市";
$areanames{zh}->{861334328} = "河北省秦皇岛市";
$areanames{zh}->{861334329} = "河北省唐山市";
$areanames{zh}->{861334330} = "河北省邯郸市";
$areanames{zh}->{861334331} = "河北省石家庄市";
$areanames{zh}->{861334332} = "河北省保定市";
$areanames{zh}->{861334333} = "河北省秦皇岛市";
$areanames{zh}->{861334334} = "河北省秦皇岛市";
$areanames{zh}->{861334335} = "河北省秦皇岛市";
$areanames{zh}->{861334336} = "河北省廊坊市";
$areanames{zh}->{861334337} = "河北省沧州市";
$areanames{zh}->{861334338} = "河北省承德市";
$areanames{zh}->{861334339} = "河北省承德市";
$areanames{zh}->{86133434} = "湖北省武汉市";
$areanames{zh}->{861334350} = "湖北省荆州市";
$areanames{zh}->{861334351} = "湖北省荆州市";
$areanames{zh}->{861334352} = "湖北省武汉市";
$areanames{zh}->{861334353} = "湖北省宜昌市";
$areanames{zh}->{861334354} = "湖北省宜昌市";
$areanames{zh}->{861334355} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861334356} = "湖北省襄樊市";
$areanames{zh}->{861334357} = "湖北省襄樊市";
$areanames{zh}->{861334358} = "湖北省武汉市";
$areanames{zh}->{861334359} = "湖北省十堰市";
$areanames{zh}->{861334360} = "河南省商丘市";
$areanames{zh}->{861334361} = "河南省焦作市";
$areanames{zh}->{861334362} = "河南省焦作市";
$areanames{zh}->{861334363} = "河南省濮阳市";
$areanames{zh}->{861334364} = "河南省驻马店市";
$areanames{zh}->{861334365} = "河南省开封市";
$areanames{zh}->{861334366} = "河南省三门峡市";
$areanames{zh}->{861334367} = "河南省漯河市";
$areanames{zh}->{861334368} = "河南省安阳市";
$areanames{zh}->{861334369} = "河南省南阳市";
$areanames{zh}->{861334370} = "河南省商丘市";
$areanames{zh}->{861334371} = "河南省郑州市";
$areanames{zh}->{861334372} = "河南省安阳市";
$areanames{zh}->{861334373} = "河南省新乡市";
$areanames{zh}->{861334374} = "河南省许昌市";
$areanames{zh}->{861334375} = "河南省平顶山市";
$areanames{zh}->{861334376} = "河南省信阳市";
$areanames{zh}->{861334377} = "河南省南阳市";
$areanames{zh}->{861334378} = "河南省开封市";
$areanames{zh}->{861334379} = "河南省洛阳市";
$areanames{zh}->{86133438} = "河南省郑州市";
$areanames{zh}->{861334380} = "河南省新乡市";
$areanames{zh}->{861334387} = "河南省洛阳市";
$areanames{zh}->{861334388} = "河南省洛阳市";
$areanames{zh}->{861334389} = "河南省洛阳市";
$areanames{zh}->{861334390} = "河南省平顶山市";
$areanames{zh}->{861334391} = "河南省焦作市";
$areanames{zh}->{861334392} = "河南省鹤壁市";
$areanames{zh}->{861334393} = "河南省濮阳市";
$areanames{zh}->{861334394} = "河南省周口市";
$areanames{zh}->{861334395} = "河南省漯河市";
$areanames{zh}->{861334396} = "河南省驻马店市";
$areanames{zh}->{861334397} = "河南省信阳市";
$areanames{zh}->{861334398} = "河南省三门峡市";
$areanames{zh}->{861334399} = "河南省平顶山市";
$areanames{zh}->{861334400} = "河南省平顶山市";
$areanames{zh}->{861334401} = "重庆市";
$areanames{zh}->{861334402} = "重庆市";
$areanames{zh}->{861334403} = "重庆市";
$areanames{zh}->{861334410} = "北京市";
$areanames{zh}->{861334411} = "北京市";
$areanames{zh}->{861334416} = "吉林省长春市";
$areanames{zh}->{861334418} = "上海市";
$areanames{zh}->{861334419} = "上海市";
$areanames{zh}->{86133443} = "天津市";
$areanames{zh}->{861334444} = "北京市";
$areanames{zh}->{861334445} = "山东省青岛市";
$areanames{zh}->{86133446} = "山东省德州市";
$areanames{zh}->{861334500} = "山东省青岛市";
$areanames{zh}->{861334501} = "山东省青岛市";
$areanames{zh}->{861334502} = "山东省青岛市";
$areanames{zh}->{861334503} = "山东省东营市";
$areanames{zh}->{861334504} = "山东省东营市";
$areanames{zh}->{861334505} = "山东省东营市";
$areanames{zh}->{861334506} = "山东省东营市";
$areanames{zh}->{861334507} = "山东省临沂市";
$areanames{zh}->{861334508} = "山东省临沂市";
$areanames{zh}->{861334509} = "山东省临沂市";
$areanames{zh}->{861334510} = "山东省济南市";
$areanames{zh}->{861334511} = "山东省济南市";
$areanames{zh}->{861334512} = "山东省济南市";
$areanames{zh}->{861334513} = "山东省济南市";
$areanames{zh}->{861334514} = "山东省烟台市";
$areanames{zh}->{861334515} = "山东省烟台市";
$areanames{zh}->{861334516} = "山东省烟台市";
$areanames{zh}->{861334517} = "山东省济宁市";
$areanames{zh}->{861334518} = "山东省济宁市";
$areanames{zh}->{861334519} = "山东省济宁市";
$areanames{zh}->{861334520} = "山东省淄博市";
$areanames{zh}->{861334521} = "山东省淄博市";
$areanames{zh}->{861334522} = "山东省淄博市";
$areanames{zh}->{861334523} = "山东省淄博市";
$areanames{zh}->{861334524} = "山东省潍坊市";
$areanames{zh}->{861334525} = "山东省潍坊市";
$areanames{zh}->{861334526} = "山东省潍坊市";
$areanames{zh}->{861334527} = "山东省泰安市";
$areanames{zh}->{861334528} = "山东省泰安市";
$areanames{zh}->{861334529} = "山东省泰安市";
$areanames{zh}->{861334530} = "新疆塔城地区";
$areanames{zh}->{861334531} = "新疆阿勒泰地区";
$areanames{zh}->{861334532} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861334533} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861334534} = "新疆喀什地区";
$areanames{zh}->{861334535} = "新疆阿克苏地区";
$areanames{zh}->{861334536} = "新疆阿克苏地区";
$areanames{zh}->{861334537} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861334538} = "新疆和田地区";
$areanames{zh}->{861334539} = "新疆昌吉回族自治州";
$areanames{zh}->{861334540} = "新疆昌吉回族自治州";
$areanames{zh}->{861334541} = "新疆昌吉回族自治州";
$areanames{zh}->{861334542} = "新疆吐鲁番地区";
$areanames{zh}->{861334543} = "新疆哈密地区";
$areanames{zh}->{861334544} = "新疆乌鲁木齐市";
$areanames{zh}->{861334545} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861334546} = "新疆石河子市";
$areanames{zh}->{861334547} = "新疆克拉玛依市";
$areanames{zh}->{861334548} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861334549} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861334550} = "安徽省滁州市";
$areanames{zh}->{861334551} = "安徽省合肥市";
$areanames{zh}->{861334552} = "安徽省蚌埠市";
$areanames{zh}->{861334553} = "安徽省芜湖市";
$areanames{zh}->{861334554} = "安徽省淮南市";
$areanames{zh}->{861334555} = "安徽省马鞍山市";
$areanames{zh}->{861334556} = "安徽省安庆市";
$areanames{zh}->{861334557} = "安徽省宿州市";
$areanames{zh}->{861334558} = "安徽省阜阳市";
$areanames{zh}->{861334559} = "安徽省黄山市";
$areanames{zh}->{861334560} = "安徽省淮北市";
$areanames{zh}->{861334561} = "安徽省淮北市";
$areanames{zh}->{861334562} = "安徽省铜陵市";
$areanames{zh}->{861334563} = "安徽省宣城市";
$areanames{zh}->{861334564} = "安徽省六安市";
$areanames{zh}->{861334565} = "安徽省巢湖市";
$areanames{zh}->{861334566} = "安徽省池州市";
$areanames{zh}->{861334567} = "安徽省亳州市";
$areanames{zh}->{861334568} = "安徽省亳州市";
$areanames{zh}->{861334569} = "安徽省黄山市";
$areanames{zh}->{861334570} = "浙江省衢州市";
$areanames{zh}->{861334571} = "浙江省杭州市";
$areanames{zh}->{861334572} = "浙江省湖州市";
$areanames{zh}->{861334573} = "浙江省嘉兴市";
$areanames{zh}->{861334574} = "浙江省宁波市";
$areanames{zh}->{861334575} = "浙江省绍兴市";
$areanames{zh}->{861334576} = "浙江省台州市";
$areanames{zh}->{861334577} = "浙江省温州市";
$areanames{zh}->{861334578} = "浙江省丽水市";
$areanames{zh}->{861334579} = "浙江省金华市";
$areanames{zh}->{861334580} = "浙江省舟山市";
$areanames{zh}->{861334581} = "浙江省杭州市";
$areanames{zh}->{861334582} = "浙江省湖州市";
$areanames{zh}->{861334583} = "浙江省嘉兴市";
$areanames{zh}->{861334584} = "浙江省宁波市";
$areanames{zh}->{861334585} = "浙江省绍兴市";
$areanames{zh}->{861334586} = "浙江省台州市";
$areanames{zh}->{861334587} = "浙江省温州市";
$areanames{zh}->{861334588} = "浙江省温州市";
$areanames{zh}->{861334589} = "浙江省金华市";
$areanames{zh}->{861334590} = "浙江省金华市";
$areanames{zh}->{861334591} = "浙江省金华市";
$areanames{zh}->{861334592} = "浙江省金华市";
$areanames{zh}->{861334593} = "浙江省金华市";
$areanames{zh}->{861334594} = "浙江省金华市";
$areanames{zh}->{861334595} = "浙江省宁波市";
$areanames{zh}->{861334596} = "浙江省宁波市";
$areanames{zh}->{861334597} = "浙江省宁波市";
$areanames{zh}->{861334598} = "浙江省宁波市";
$areanames{zh}->{861334599} = "浙江省宁波市";
$areanames{zh}->{861334600} = "浙江省嘉兴市";
$areanames{zh}->{861334601} = "浙江省嘉兴市";
$areanames{zh}->{861334602} = "浙江省绍兴市";
$areanames{zh}->{861334603} = "浙江省绍兴市";
$areanames{zh}->{861334604} = "浙江省绍兴市";
$areanames{zh}->{861334605} = "浙江省绍兴市";
$areanames{zh}->{861334606} = "浙江省丽水市";
$areanames{zh}->{861334607} = "浙江省丽水市";
$areanames{zh}->{861334608} = "浙江省温州市";
$areanames{zh}->{861334609} = "浙江省温州市";
$areanames{zh}->{861334610} = "浙江省台州市";
$areanames{zh}->{861334611} = "浙江省台州市";
$areanames{zh}->{861334612} = "浙江省台州市";
$areanames{zh}->{861334613} = "浙江省台州市";
$areanames{zh}->{861334614} = "浙江省台州市";
$areanames{zh}->{861334615} = "浙江省杭州市";
$areanames{zh}->{861334616} = "浙江省杭州市";
$areanames{zh}->{861334617} = "浙江省杭州市";
$areanames{zh}->{861334618} = "浙江省杭州市";
$areanames{zh}->{861334619} = "浙江省杭州市";
$areanames{zh}->{861334620} = "山东省菏泽市";
$areanames{zh}->{861334621} = "山东省菏泽市";
$areanames{zh}->{861334622} = "山东省聊城市";
$areanames{zh}->{861334623} = "山东省日照市";
$areanames{zh}->{861334624} = "山东省威海市";
$areanames{zh}->{861334625} = "山东省聊城市";
$areanames{zh}->{861334626} = "山东省德州市";
$areanames{zh}->{861334627} = "山东省德州市";
$areanames{zh}->{861334628} = "山东省滨州市";
$areanames{zh}->{861334629} = "山东省滨州市";
$areanames{zh}->{861334630} = "山东省威海市";
$areanames{zh}->{861334631} = "山东省威海市";
$areanames{zh}->{861334632} = "山东省枣庄市";
$areanames{zh}->{861334633} = "山东省日照市";
$areanames{zh}->{861334634} = "山东省莱芜市";
$areanames{zh}->{861334635} = "山东省聊城市";
$areanames{zh}->{861334636} = "山东省潍坊市";
$areanames{zh}->{861334637} = "山东省枣庄市";
$areanames{zh}->{861334638} = "山东省烟台市";
$areanames{zh}->{861334639} = "山东省青岛市";
$areanames{zh}->{86133464} = "广东省中山市";
$areanames{zh}->{861334640} = "广东省珠海市";
$areanames{zh}->{861334641} = "广东省珠海市";
$areanames{zh}->{861334642} = "广东省珠海市";
$areanames{zh}->{861334650} = "广东省韶关市";
$areanames{zh}->{861334651} = "广东省韶关市";
$areanames{zh}->{861334652} = "广东省韶关市";
$areanames{zh}->{861334653} = "广东省韶关市";
$areanames{zh}->{861334654} = "广东省清远市";
$areanames{zh}->{861334655} = "广东省清远市";
$areanames{zh}->{861334656} = "广东省肇庆市";
$areanames{zh}->{861334657} = "广东省肇庆市";
$areanames{zh}->{861334658} = "广东省云浮市";
$areanames{zh}->{861334659} = "广东省云浮市";
$areanames{zh}->{861334660} = "河南省商丘市";
$areanames{zh}->{861334661} = "河南省商丘市";
$areanames{zh}->{861334662} = "河南省商丘市";
$areanames{zh}->{861334663} = "河南省安阳市";
$areanames{zh}->{861334664} = "河南省安阳市";
$areanames{zh}->{861334665} = "河南省安阳市";
$areanames{zh}->{861334666} = "河南省新乡市";
$areanames{zh}->{861334667} = "河南省新乡市";
$areanames{zh}->{861334668} = "河南省新乡市";
$areanames{zh}->{861334669} = "河南省许昌市";
$areanames{zh}->{861334670} = "河南省许昌市";
$areanames{zh}->{861334671} = "河南省平顶山市";
$areanames{zh}->{861334672} = "河南省平顶山市";
$areanames{zh}->{861334673} = "河南省平顶山市";
$areanames{zh}->{861334674} = "河南省信阳市";
$areanames{zh}->{861334675} = "河南省信阳市";
$areanames{zh}->{861334676} = "河南省信阳市";
$areanames{zh}->{861334677} = "河南省开封市";
$areanames{zh}->{861334678} = "河南省焦作市";
$areanames{zh}->{861334679} = "河南省焦作市";
$areanames{zh}->{861334680} = "河南省鹤壁市";
$areanames{zh}->{861334681} = "河南省濮阳市";
$areanames{zh}->{861334682} = "河南省濮阳市";
$areanames{zh}->{861334683} = "河南省周口市";
$areanames{zh}->{861334684} = "河南省周口市";
$areanames{zh}->{861334685} = "河南省周口市";
$areanames{zh}->{861334686} = "河南省漯河市";
$areanames{zh}->{861334687} = "河南省漯河市";
$areanames{zh}->{861334688} = "河南省驻马店市";
$areanames{zh}->{861334689} = "河南省驻马店市";
$areanames{zh}->{861334690} = "河南省驻马店市";
$areanames{zh}->{861334691} = "河南省三门峡市";
$areanames{zh}->{861334692} = "河南省三门峡市";
$areanames{zh}->{861334693} = "河南省郑州市";
$areanames{zh}->{861334694} = "河南省郑州市";
$areanames{zh}->{861334695} = "河南省郑州市";
$areanames{zh}->{861334696} = "河南省南阳市";
$areanames{zh}->{861334697} = "河南省南阳市";
$areanames{zh}->{861334698} = "河南省洛阳市";
$areanames{zh}->{861334699} = "河南省洛阳市";
$areanames{zh}->{861334700} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861334701} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861334702} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861334703} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861334704} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861334705} = "内蒙古通辽市";
$areanames{zh}->{861334706} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861334707} = "内蒙古包头市";
$areanames{zh}->{861334708} = "内蒙古包头市";
$areanames{zh}->{861334709} = "内蒙古包头市";
$areanames{zh}->{86133471} = "内蒙古呼和浩特市";
$areanames{zh}->{861334717} = "内蒙古包头市";
$areanames{zh}->{861334718} = "内蒙古包头市";
$areanames{zh}->{861334719} = "内蒙古包头市";
$areanames{zh}->{861334720} = "湖南省岳阳市";
$areanames{zh}->{861334721} = "湖南省长沙市";
$areanames{zh}->{861334722} = "湖南省湘潭市";
$areanames{zh}->{861334723} = "湖南省株洲市";
$areanames{zh}->{861334724} = "湖南省衡阳市";
$areanames{zh}->{861334725} = "湖南省郴州市";
$areanames{zh}->{861334726} = "湖南省常德市";
$areanames{zh}->{861334727} = "湖南省益阳市";
$areanames{zh}->{861334728} = "湖南省娄底市";
$areanames{zh}->{861334729} = "湖南省邵阳市";
$areanames{zh}->{861334730} = "湖南省岳阳市";
$areanames{zh}->{861334731} = "湖南省长沙市";
$areanames{zh}->{861334732} = "湖南省湘潭市";
$areanames{zh}->{861334733} = "湖南省株洲市";
$areanames{zh}->{861334734} = "湖南省衡阳市";
$areanames{zh}->{861334735} = "湖南省郴州市";
$areanames{zh}->{861334736} = "湖南省常德市";
$areanames{zh}->{861334737} = "湖南省益阳市";
$areanames{zh}->{861334738} = "湖南省娄底市";
$areanames{zh}->{861334739} = "湖南省邵阳市";
$areanames{zh}->{861334740} = "陕西省西安市";
$areanames{zh}->{861334741} = "陕西省西安市";
$areanames{zh}->{861334742} = "陕西省西安市";
$areanames{zh}->{861334743} = "陕西省西安市";
$areanames{zh}->{861334744} = "陕西省咸阳市";
$areanames{zh}->{861334745} = "陕西省渭南市";
$areanames{zh}->{861334746} = "陕西省宝鸡市";
$areanames{zh}->{861334747} = "陕西省汉中市";
$areanames{zh}->{861334748} = "陕西省榆林市";
$areanames{zh}->{861334749} = "陕西省安康市";
$areanames{zh}->{861334750} = "广西南宁市";
$areanames{zh}->{861334751} = "广西南宁市";
$areanames{zh}->{861334752} = "广西柳州市";
$areanames{zh}->{861334753} = "广西桂林市";
$areanames{zh}->{861334754} = "广西贺州市";
$areanames{zh}->{861334755} = "广西玉林市";
$areanames{zh}->{861334756} = "广西桂林市";
$areanames{zh}->{861334757} = "广西贵港市";
$areanames{zh}->{861334758} = "广西贺州市";
$areanames{zh}->{861334759} = "广西北海市";
$areanames{zh}->{861334760} = "广西南宁市";
$areanames{zh}->{861334761} = "广西南宁市";
$areanames{zh}->{861334762} = "广西柳州市";
$areanames{zh}->{861334763} = "广西桂林市";
$areanames{zh}->{861334764} = "广西梧州市";
$areanames{zh}->{861334765} = "广西玉林市";
$areanames{zh}->{861334766} = "广西百色市";
$areanames{zh}->{861334767} = "广西贵港市";
$areanames{zh}->{861334768} = "广西河池市";
$areanames{zh}->{861334769} = "广西北海市";
$areanames{zh}->{861334770} = "江苏省南京市";
$areanames{zh}->{861334771} = "江苏省南京市";
$areanames{zh}->{861334772} = "江苏省南京市";
$areanames{zh}->{861334773} = "江苏省南京市";
$areanames{zh}->{861334774} = "江苏省镇江市";
$areanames{zh}->{861334775} = "江苏省镇江市";
$areanames{zh}->{861334776} = "江苏省镇江市";
$areanames{zh}->{861334777} = "江苏省镇江市";
$areanames{zh}->{861334778} = "江苏省泰州市";
$areanames{zh}->{861334779} = "江苏省泰州市";
$areanames{zh}->{861334780} = "江苏省南京市";
$areanames{zh}->{861334781} = "江苏省南京市";
$areanames{zh}->{861334782} = "江苏省南京市";
$areanames{zh}->{861334783} = "江苏省南京市";
$areanames{zh}->{861334784} = "江苏省宿迁市";
$areanames{zh}->{861334785} = "江苏省宿迁市";
$areanames{zh}->{861334786} = "江苏省连云港市";
$areanames{zh}->{861334787} = "江苏省连云港市";
$areanames{zh}->{861334788} = "江苏省常州市";
$areanames{zh}->{861334789} = "江苏省常州市";
$areanames{zh}->{861334790} = "江苏省无锡市";
$areanames{zh}->{861334791} = "江苏省无锡市";
$areanames{zh}->{861334792} = "江苏省无锡市";
$areanames{zh}->{861334793} = "江苏省徐州市";
$areanames{zh}->{861334794} = "江苏省徐州市";
$areanames{zh}->{861334795} = "江苏省徐州市";
$areanames{zh}->{861334796} = "江苏省淮安市";
$areanames{zh}->{861334797} = "江苏省淮安市";
$areanames{zh}->{861334798} = "江苏省盐城市";
$areanames{zh}->{861334799} = "江苏省盐城市";
$areanames{zh}->{86133480} = "江苏省苏州市";
$areanames{zh}->{861334806} = "江苏省南通市";
$areanames{zh}->{861334807} = "江苏省南通市";
$areanames{zh}->{861334808} = "江苏省南通市";
$areanames{zh}->{861334809} = "江苏省南通市";
$areanames{zh}->{861334810} = "江苏省无锡市";
$areanames{zh}->{861334811} = "江苏省无锡市";
$areanames{zh}->{861334812} = "江苏省扬州市";
$areanames{zh}->{861334813} = "江苏省扬州市";
$areanames{zh}->{861334814} = "江苏省扬州市";
$areanames{zh}->{861334815} = "江苏省无锡市";
$areanames{zh}->{861334816} = "江苏省常州市";
$areanames{zh}->{861334817} = "江苏省常州市";
$areanames{zh}->{861334818} = "江苏省常州市";
$areanames{zh}->{861334819} = "江苏省常州市";
$areanames{zh}->{86133482} = "福建省福州市";
$areanames{zh}->{861334830} = "福建省莆田市";
$areanames{zh}->{861334831} = "福建省莆田市";
$areanames{zh}->{861334832} = "福建省莆田市";
$areanames{zh}->{861334833} = "福建省三明市";
$areanames{zh}->{861334834} = "福建省龙岩市";
$areanames{zh}->{861334835} = "福建省龙岩市";
$areanames{zh}->{861334836} = "福建省龙岩市";
$areanames{zh}->{861334837} = "福建省厦门市";
$areanames{zh}->{861334838} = "福建省厦门市";
$areanames{zh}->{861334839} = "福建省厦门市";
$areanames{zh}->{861334840} = "福建省宁德市";
$areanames{zh}->{861334841} = "福建省宁德市";
$areanames{zh}->{861334842} = "福建省宁德市";
$areanames{zh}->{861334843} = "福建省三明市";
$areanames{zh}->{861334844} = "福建省三明市";
$areanames{zh}->{861334845} = "福建省漳州市";
$areanames{zh}->{861334846} = "福建省漳州市";
$areanames{zh}->{861334847} = "福建省漳州市";
$areanames{zh}->{861334848} = "福建省漳州市";
$areanames{zh}->{861334849} = "福建省漳州市";
$areanames{zh}->{86133485} = "福建省泉州市";
$areanames{zh}->{861334858} = "福建省南平市";
$areanames{zh}->{861334859} = "福建省南平市";
$areanames{zh}->{861334860} = "湖南省岳阳市";
$areanames{zh}->{861334861} = "湖南省长沙市";
$areanames{zh}->{861334862} = "湖南省湘潭市";
$areanames{zh}->{861334863} = "湖南省株洲市";
$areanames{zh}->{861334864} = "湖南省衡阳市";
$areanames{zh}->{861334865} = "湖南省郴州市";
$areanames{zh}->{861334866} = "湖南省常德市";
$areanames{zh}->{861334867} = "湖南省长沙市";
$areanames{zh}->{861334868} = "湖南省长沙市";
$areanames{zh}->{861334869} = "湖南省长沙市";
$areanames{zh}->{861334870} = "湖南省岳阳市";
$areanames{zh}->{861334871} = "湖南省长沙市";
$areanames{zh}->{861334872} = "湖南省湘潭市";
$areanames{zh}->{861334873} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861334874} = "湖南省张家界市";
$areanames{zh}->{861334875} = "湖南省怀化市";
$areanames{zh}->{861334876} = "湖南省永州市";
$areanames{zh}->{861334877} = "湖南省益阳市";
$areanames{zh}->{861334878} = "湖南省娄底市";
$areanames{zh}->{861334879} = "湖南省邵阳市";
$areanames{zh}->{86133488} = "四川省成都市";
$areanames{zh}->{86133489} = "四川省成都市";
$areanames{zh}->{861334900} = "安徽省六安市";
$areanames{zh}->{861334901} = "安徽省合肥市";
$areanames{zh}->{861334902} = "安徽省蚌埠市";
$areanames{zh}->{861334903} = "安徽省芜湖市";
$areanames{zh}->{861334904} = "安徽省亳州市";
$areanames{zh}->{861334905} = "安徽省马鞍山市";
$areanames{zh}->{861334906} = "安徽省安庆市";
$areanames{zh}->{861334907} = "安徽省安庆市";
$areanames{zh}->{861334908} = "安徽省阜阳市";
$areanames{zh}->{861334909} = "安徽省合肥市";
$areanames{zh}->{861334910} = "安徽省阜阳市";
$areanames{zh}->{861334911} = "安徽省合肥市";
$areanames{zh}->{861334912} = "安徽省六安市";
$areanames{zh}->{861334913} = "安徽省宣城市";
$areanames{zh}->{861334914} = "安徽省池州市";
$areanames{zh}->{861334915} = "安徽省巢湖市";
$areanames{zh}->{861334916} = "安徽省巢湖市";
$areanames{zh}->{861334917} = "安徽省亳州市";
$areanames{zh}->{861334918} = "安徽省合肥市";
$areanames{zh}->{861334919} = "安徽省合肥市";
$areanames{zh}->{861334920} = "安徽省合肥市";
$areanames{zh}->{861334921} = "安徽省芜湖市";
$areanames{zh}->{861334922} = "安徽省蚌埠市";
$areanames{zh}->{861334923} = "安徽省芜湖市";
$areanames{zh}->{861334924} = "安徽省巢湖市";
$areanames{zh}->{861334925} = "安徽省滁州市";
$areanames{zh}->{861334926} = "安徽省安庆市";
$areanames{zh}->{861334927} = "安徽省亳州市";
$areanames{zh}->{861334928} = "安徽省阜阳市";
$areanames{zh}->{861334929} = "安徽省合肥市";
$areanames{zh}->{861334930} = "黑龙江省哈尔滨市";
$areanames{zh}->{861334931} = "黑龙江省哈尔滨市";
$areanames{zh}->{861334932} = "黑龙江省七台河市";
$areanames{zh}->{861334933} = "黑龙江省双鸭山市";
$areanames{zh}->{861334934} = "黑龙江省双鸭山市";
$areanames{zh}->{861334935} = "黑龙江省绥化市";
$areanames{zh}->{861334936} = "黑龙江省黑河市";
$areanames{zh}->{861334937} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861334938} = "黑龙江省伊春市";
$areanames{zh}->{861334939} = "黑龙江省大庆市";
$areanames{zh}->{861334940} = "黑龙江省哈尔滨市";
$areanames{zh}->{861334941} = "黑龙江省哈尔滨市";
$areanames{zh}->{861334942} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861334943} = "黑龙江省牡丹江市";
$areanames{zh}->{861334944} = "黑龙江省佳木斯市";
$areanames{zh}->{861334945} = "黑龙江省绥化市";
$areanames{zh}->{861334946} = "黑龙江省黑河市";
$areanames{zh}->{861334947} = "黑龙江省大庆市";
$areanames{zh}->{861334948} = "黑龙江省鹤岗市";
$areanames{zh}->{861334949} = "黑龙江省大庆市";
$areanames{zh}->{861334950} = "黑龙江省大庆市";
$areanames{zh}->{861334951} = "黑龙江省哈尔滨市";
$areanames{zh}->{861334952} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861334953} = "黑龙江省牡丹江市";
$areanames{zh}->{861334954} = "黑龙江省佳木斯市";
$areanames{zh}->{861334955} = "黑龙江省佳木斯市";
$areanames{zh}->{861334956} = "黑龙江省鸡西市";
$areanames{zh}->{861334957} = "黑龙江省鸡西市";
$areanames{zh}->{861334958} = "黑龙江省鹤岗市";
$areanames{zh}->{861334959} = "黑龙江省大庆市";
$areanames{zh}->{861334960} = "湖南省长沙市";
$areanames{zh}->{861334961} = "湖南省怀化市";
$areanames{zh}->{861334962} = "湖南省常德市";
$areanames{zh}->{861334963} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861334964} = "湖南省张家界市";
$areanames{zh}->{861334965} = "湖南省怀化市";
$areanames{zh}->{861334966} = "湖南省永州市";
$areanames{zh}->{861334967} = "湖南省郴州市";
$areanames{zh}->{861334968} = "湖南省娄底市";
$areanames{zh}->{861334969} = "湖南省邵阳市";
$areanames{zh}->{861334970} = "湖北省武汉市";
$areanames{zh}->{861334971} = "湖北省武汉市";
$areanames{zh}->{861334972} = "湖北省武汉市";
$areanames{zh}->{861334973} = "湖北省荆州市";
$areanames{zh}->{861334974} = "湖北省荆州市";
$areanames{zh}->{861334975} = "湖北省荆州市";
$areanames{zh}->{861334976} = "湖北省宜昌市";
$areanames{zh}->{861334977} = "湖北省宜昌市";
$areanames{zh}->{861334978} = "湖北省宜昌市";
$areanames{zh}->{861334979} = "湖北省十堰市";
$areanames{zh}->{86133498} = "湖北省武汉市";
$areanames{zh}->{861334980} = "湖北省襄樊市";
$areanames{zh}->{861334981} = "湖北省孝感市";
$areanames{zh}->{861334982} = "湖北省黄石市";
$areanames{zh}->{86133499} = "湖北省武汉市";
$areanames{zh}->{861335000} = "四川省绵阳市";
$areanames{zh}->{861335001} = "四川省绵阳市";
$areanames{zh}->{861335002} = "四川省绵阳市";
$areanames{zh}->{861335003} = "四川省广元市";
$areanames{zh}->{861335004} = "四川省德阳市";
$areanames{zh}->{861335005} = "四川省成都市";
$areanames{zh}->{861335006} = "四川省成都市";
$areanames{zh}->{861335007} = "四川省成都市";
$areanames{zh}->{861335008} = "四川省成都市";
$areanames{zh}->{861335009} = "四川省成都市";
$areanames{zh}->{861335010} = "四川省自贡市";
$areanames{zh}->{861335011} = "四川省自贡市";
$areanames{zh}->{861335012} = "四川省资阳市";
$areanames{zh}->{861335013} = "四川省泸州市";
$areanames{zh}->{861335014} = "四川省泸州市";
$areanames{zh}->{861335015} = "四川省内江市";
$areanames{zh}->{861335016} = "四川省内江市";
$areanames{zh}->{861335017} = "四川省宜宾市";
$areanames{zh}->{861335018} = "四川省宜宾市";
$areanames{zh}->{861335019} = "四川省宜宾市";
$areanames{zh}->{861335020} = "四川省遂宁市";
$areanames{zh}->{861335021} = "四川省遂宁市";
$areanames{zh}->{861335022} = "四川省广安市";
$areanames{zh}->{861335023} = "四川省巴中市";
$areanames{zh}->{861335024} = "四川省宜宾市";
$areanames{zh}->{861335025} = "四川省南充市";
$areanames{zh}->{861335026} = "四川省南充市";
$areanames{zh}->{861335027} = "四川省南充市";
$areanames{zh}->{861335028} = "四川省达州市";
$areanames{zh}->{861335029} = "四川省达州市";
$areanames{zh}->{86133503} = "重庆市";
$areanames{zh}->{861335040} = "四川省南充市";
$areanames{zh}->{861335041} = "四川省乐山市";
$areanames{zh}->{861335042} = "四川省雅安市";
$areanames{zh}->{861335043} = "四川省眉山市";
$areanames{zh}->{861335044} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861335045} = "四川省甘孜藏族自治州";
$areanames{zh}->{861335046} = "四川省广安市";
$areanames{zh}->{861335047} = "四川省巴中市";
$areanames{zh}->{861335048} = "四川省达州市";
$areanames{zh}->{861335049} = "四川省广元市";
$areanames{zh}->{861335050} = "四川省乐山市";
$areanames{zh}->{861335051} = "四川省乐山市";
$areanames{zh}->{861335052} = "四川省眉山市";
$areanames{zh}->{861335053} = "四川省眉山市";
$areanames{zh}->{861335054} = "四川省攀枝花市";
$areanames{zh}->{861335055} = "四川省攀枝花市";
$areanames{zh}->{861335056} = "四川省雅安市";
$areanames{zh}->{861335057} = "四川省凉山彝族自治州";
$areanames{zh}->{861335058} = "四川省德阳市";
$areanames{zh}->{861335059} = "四川省德阳市";
$areanames{zh}->{861335060} = "四川省宜宾市";
$areanames{zh}->{861335061} = "四川省宜宾市";
$areanames{zh}->{861335062} = "四川省遂宁市";
$areanames{zh}->{861335063} = "四川省南充市";
$areanames{zh}->{861335064} = "四川省南充市";
$areanames{zh}->{861335065} = "四川省南充市";
$areanames{zh}->{861335066} = "四川省南充市";
$areanames{zh}->{861335067} = "四川省自贡市";
$areanames{zh}->{861335068} = "四川省自贡市";
$areanames{zh}->{861335069} = "四川省资阳市";
$areanames{zh}->{861335070} = "四川省眉山市";
$areanames{zh}->{861335071} = "四川省眉山市";
$areanames{zh}->{861335072} = "四川省乐山市";
$areanames{zh}->{861335073} = "四川省乐山市";
$areanames{zh}->{861335074} = "四川省乐山市";
$areanames{zh}->{861335075} = "四川省乐山市";
$areanames{zh}->{861335076} = "四川省乐山市";
$areanames{zh}->{861335077} = "四川省达州市";
$areanames{zh}->{861335078} = "四川省达州市";
$areanames{zh}->{861335079} = "四川省达州市";
$areanames{zh}->{86133508} = "四川省成都市";
$areanames{zh}->{861335080} = "四川省德阳市";
$areanames{zh}->{861335081} = "四川省泸州市";
$areanames{zh}->{86133509} = "四川省绵阳市";
$areanames{zh}->{861335090} = "四川省广安市";
$areanames{zh}->{861335091} = "四川省广安市";
$areanames{zh}->{861335092} = "四川省巴中市";
$areanames{zh}->{861335093} = "四川省巴中市";
$areanames{zh}->{861335100} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335101} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335102} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335103} = "黑龙江省牡丹江市";
$areanames{zh}->{861335104} = "黑龙江省双鸭山市";
$areanames{zh}->{861335105} = "黑龙江省双鸭山市";
$areanames{zh}->{861335106} = "黑龙江省双鸭山市";
$areanames{zh}->{861335107} = "黑龙江省鸡西市";
$areanames{zh}->{861335108} = "黑龙江省伊春市";
$areanames{zh}->{861335109} = "黑龙江省大庆市";
$areanames{zh}->{861335110} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335111} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335112} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335113} = "黑龙江省牡丹江市";
$areanames{zh}->{861335114} = "黑龙江省七台河市";
$areanames{zh}->{861335115} = "黑龙江省绥化市";
$areanames{zh}->{861335116} = "黑龙江省双鸭山市";
$areanames{zh}->{861335117} = "黑龙江省鸡西市";
$areanames{zh}->{861335118} = "黑龙江省大庆市";
$areanames{zh}->{861335119} = "黑龙江省大庆市";
$areanames{zh}->{861335120} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335121} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335122} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335123} = "黑龙江省牡丹江市";
$areanames{zh}->{861335124} = "黑龙江省七台河市";
$areanames{zh}->{861335125} = "黑龙江省绥化市";
$areanames{zh}->{861335126} = "黑龙江省七台河市";
$areanames{zh}->{861335127} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335128} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335129} = "黑龙江省大庆市";
$areanames{zh}->{861335130} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335131} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335132} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335133} = "黑龙江省牡丹江市";
$areanames{zh}->{861335134} = "黑龙江省佳木斯市";
$areanames{zh}->{861335135} = "黑龙江省绥化市";
$areanames{zh}->{861335136} = "黑龙江省黑河市";
$areanames{zh}->{861335137} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335138} = "黑龙江省伊春市";
$areanames{zh}->{861335139} = "黑龙江省大庆市";
$areanames{zh}->{861335140} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335141} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335142} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335143} = "黑龙江省牡丹江市";
$areanames{zh}->{861335144} = "黑龙江省佳木斯市";
$areanames{zh}->{861335145} = "黑龙江省绥化市";
$areanames{zh}->{861335146} = "黑龙江省黑河市";
$areanames{zh}->{861335147} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335148} = "黑龙江省伊春市";
$areanames{zh}->{861335149} = "黑龙江省大庆市";
$areanames{zh}->{861335150} = "吉林省长春市";
$areanames{zh}->{861335151} = "吉林省吉林市";
$areanames{zh}->{861335152} = "吉林省白城市";
$areanames{zh}->{861335153} = "吉林省通化市";
$areanames{zh}->{861335154} = "吉林省长春市";
$areanames{zh}->{861335155} = "吉林省松原市";
$areanames{zh}->{861335156} = "吉林省辽源市";
$areanames{zh}->{861335157} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861335158} = "吉林省四平市";
$areanames{zh}->{861335159} = "吉林省白山市";
$areanames{zh}->{861335160} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335161} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335162} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335163} = "黑龙江省牡丹江市";
$areanames{zh}->{861335164} = "黑龙江省佳木斯市";
$areanames{zh}->{861335165} = "黑龙江省佳木斯市";
$areanames{zh}->{861335166} = "黑龙江省佳木斯市";
$areanames{zh}->{861335167} = "黑龙江省鸡西市";
$areanames{zh}->{861335168} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335169} = "黑龙江省大庆市";
$areanames{zh}->{861335170} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335171} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335172} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335173} = "黑龙江省牡丹江市";
$areanames{zh}->{861335174} = "黑龙江省大庆市";
$areanames{zh}->{861335175} = "黑龙江省大庆市";
$areanames{zh}->{861335176} = "黑龙江省佳木斯市";
$areanames{zh}->{861335177} = "黑龙江省鸡西市";
$areanames{zh}->{861335178} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335179} = "黑龙江省大庆市";
$areanames{zh}->{861335180} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335181} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335182} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335183} = "黑龙江省牡丹江市";
$areanames{zh}->{861335184} = "黑龙江省大庆市";
$areanames{zh}->{861335185} = "黑龙江省大庆市";
$areanames{zh}->{861335186} = "黑龙江省佳木斯市";
$areanames{zh}->{861335187} = "黑龙江省鸡西市";
$areanames{zh}->{861335188} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335189} = "黑龙江省大庆市";
$areanames{zh}->{861335190} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335191} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335192} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335193} = "黑龙江省鹤岗市";
$areanames{zh}->{861335194} = "黑龙江省鹤岗市";
$areanames{zh}->{861335195} = "黑龙江省鹤岗市";
$areanames{zh}->{861335196} = "黑龙江省鹤岗市";
$areanames{zh}->{861335197} = "黑龙江省鸡西市";
$areanames{zh}->{861335198} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335199} = "黑龙江省大庆市";
$areanames{zh}->{86133520} = "天津市";
$areanames{zh}->{861335210} = "辽宁省鞍山市";
$areanames{zh}->{861335211} = "辽宁省鞍山市";
$areanames{zh}->{861335212} = "辽宁省抚顺市";
$areanames{zh}->{861335213} = "辽宁省抚顺市";
$areanames{zh}->{861335214} = "辽宁省本溪市";
$areanames{zh}->{861335215} = "辽宁省本溪市";
$areanames{zh}->{861335216} = "辽宁省丹东市";
$areanames{zh}->{861335217} = "辽宁省丹东市";
$areanames{zh}->{861335218} = "辽宁省锦州市";
$areanames{zh}->{861335219} = "辽宁省锦州市";
$areanames{zh}->{86133522} = "辽宁省大连市";
$areanames{zh}->{861335230} = "辽宁省营口市";
$areanames{zh}->{861335231} = "辽宁省营口市";
$areanames{zh}->{861335232} = "辽宁省阜新市";
$areanames{zh}->{861335233} = "辽宁省辽阳市";
$areanames{zh}->{861335234} = "辽宁省辽阳市";
$areanames{zh}->{861335235} = "辽宁省铁岭市";
$areanames{zh}->{861335236} = "辽宁省朝阳市";
$areanames{zh}->{861335237} = "辽宁省盘锦市";
$areanames{zh}->{861335238} = "辽宁省盘锦市";
$areanames{zh}->{861335239} = "辽宁省葫芦岛市";
$areanames{zh}->{86133524} = "辽宁省沈阳市";
$areanames{zh}->{861335250} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335251} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335252} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335253} = "黑龙江省牡丹江市";
$areanames{zh}->{861335254} = "黑龙江省佳木斯市";
$areanames{zh}->{861335255} = "黑龙江省绥化市";
$areanames{zh}->{861335256} = "黑龙江省黑河市";
$areanames{zh}->{861335257} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335258} = "黑龙江省伊春市";
$areanames{zh}->{861335259} = "黑龙江省大庆市";
$areanames{zh}->{86133526} = "广东省惠州市";
$areanames{zh}->{861335270} = "广东省揭阳市";
$areanames{zh}->{861335271} = "广东省揭阳市";
$areanames{zh}->{861335272} = "广东省揭阳市";
$areanames{zh}->{861335273} = "广东省揭阳市";
$areanames{zh}->{861335274} = "广东省揭阳市";
$areanames{zh}->{861335275} = "广东省汕尾市";
$areanames{zh}->{861335276} = "广东省汕尾市";
$areanames{zh}->{861335277} = "广东省惠州市";
$areanames{zh}->{861335278} = "广东省惠州市";
$areanames{zh}->{861335279} = "广东省惠州市";
$areanames{zh}->{86133528} = "广东省广州市";
$areanames{zh}->{86133529} = "广东省深圳市";
$areanames{zh}->{86133530} = "广东省肇庆市";
$areanames{zh}->{861335306} = "广东省汕头市";
$areanames{zh}->{861335307} = "广东省汕头市";
$areanames{zh}->{861335308} = "广东省汕头市";
$areanames{zh}->{861335309} = "广东省汕头市";
$areanames{zh}->{861335310} = "吉林省长春市";
$areanames{zh}->{861335311} = "吉林省长春市";
$areanames{zh}->{861335312} = "吉林省吉林市";
$areanames{zh}->{861335313} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861335314} = "吉林省长春市";
$areanames{zh}->{861335315} = "吉林省通化市";
$areanames{zh}->{861335316} = "吉林省四平市";
$areanames{zh}->{861335317} = "吉林省松原市";
$areanames{zh}->{861335318} = "吉林省辽源市";
$areanames{zh}->{861335319} = "吉林省长春市";
$areanames{zh}->{861335320} = "吉林省长春市";
$areanames{zh}->{861335321} = "吉林省松原市";
$areanames{zh}->{861335322} = "吉林省吉林市";
$areanames{zh}->{861335323} = "吉林省白城市";
$areanames{zh}->{861335324} = "吉林省长春市";
$areanames{zh}->{861335325} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861335326} = "吉林省长春市";
$areanames{zh}->{861335327} = "吉林省长春市";
$areanames{zh}->{861335328} = "吉林省吉林市";
$areanames{zh}->{861335329} = "吉林省长春市";
$areanames{zh}->{86133533} = "浙江省温州市";
$areanames{zh}->{861335340} = "山西省忻州市";
$areanames{zh}->{861335341} = "山西省太原市";
$areanames{zh}->{861335342} = "山西省大同市";
$areanames{zh}->{861335343} = "山西省太原市";
$areanames{zh}->{861335344} = "山西省晋中市";
$areanames{zh}->{861335345} = "山西省长治市";
$areanames{zh}->{861335346} = "山西省晋城市";
$areanames{zh}->{861335347} = "山西省临汾市";
$areanames{zh}->{861335348} = "山西省运城市";
$areanames{zh}->{861335349} = "山西省朔州市";
$areanames{zh}->{861335350} = "山西省忻州市";
$areanames{zh}->{861335351} = "山西省太原市";
$areanames{zh}->{861335352} = "山西省大同市";
$areanames{zh}->{861335353} = "山西省阳泉市";
$areanames{zh}->{861335354} = "山西省晋中市";
$areanames{zh}->{861335355} = "山西省长治市";
$areanames{zh}->{861335356} = "山西省晋城市";
$areanames{zh}->{861335357} = "山西省临汾市";
$areanames{zh}->{861335358} = "山西省吕梁市";
$areanames{zh}->{861335359} = "山西省运城市";
$areanames{zh}->{861335360} = "河南省商丘市";
$areanames{zh}->{861335361} = "河南省商丘市";
$areanames{zh}->{861335362} = "河南省商丘市";
$areanames{zh}->{861335363} = "河南省安阳市";
$areanames{zh}->{861335364} = "河南省安阳市";
$areanames{zh}->{861335365} = "河南省安阳市";
$areanames{zh}->{861335366} = "河南省新乡市";
$areanames{zh}->{861335367} = "河南省新乡市";
$areanames{zh}->{861335368} = "河南省新乡市";
$areanames{zh}->{861335369} = "河南省信阳市";
$areanames{zh}->{861335370} = "河南省商丘市";
$areanames{zh}->{861335371} = "河南省郑州市";
$areanames{zh}->{861335372} = "河南省安阳市";
$areanames{zh}->{861335373} = "河南省新乡市";
$areanames{zh}->{861335374} = "河南省许昌市";
$areanames{zh}->{861335375} = "河南省平顶山市";
$areanames{zh}->{861335376} = "河南省信阳市";
$areanames{zh}->{861335377} = "河南省南阳市";
$areanames{zh}->{861335378} = "河南省开封市";
$areanames{zh}->{861335379} = "河南省洛阳市";
$areanames{zh}->{861335380} = "河南省郑州市";
$areanames{zh}->{861335381} = "河南省开封市";
$areanames{zh}->{861335382} = "河南省开封市";
$areanames{zh}->{861335383} = "河南省开封市";
$areanames{zh}->{861335384} = "河南省周口市";
$areanames{zh}->{861335385} = "河南省周口市";
$areanames{zh}->{861335386} = "河南省周口市";
$areanames{zh}->{861335387} = "河南省驻马店市";
$areanames{zh}->{861335388} = "河南省驻马店市";
$areanames{zh}->{861335389} = "河南省驻马店市";
$areanames{zh}->{861335390} = "河南省洛阳市";
$areanames{zh}->{861335391} = "河南省焦作市";
$areanames{zh}->{861335392} = "河南省鹤壁市";
$areanames{zh}->{861335393} = "河南省濮阳市";
$areanames{zh}->{861335394} = "河南省周口市";
$areanames{zh}->{861335395} = "河南省漯河市";
$areanames{zh}->{861335396} = "河南省驻马店市";
$areanames{zh}->{861335397} = "河南省洛阳市";
$areanames{zh}->{861335398} = "河南省三门峡市";
$areanames{zh}->{861335399} = "河南省洛阳市";
$areanames{zh}->{86133540} = "辽宁省大连市";
$areanames{zh}->{861335410} = "辽宁省铁岭市";
$areanames{zh}->{861335411} = "辽宁省大连市";
$areanames{zh}->{861335412} = "辽宁省鞍山市";
$areanames{zh}->{861335413} = "辽宁省抚顺市";
$areanames{zh}->{861335414} = "辽宁省本溪市";
$areanames{zh}->{861335415} = "辽宁省丹东市";
$areanames{zh}->{861335416} = "辽宁省锦州市";
$areanames{zh}->{861335417} = "辽宁省营口市";
$areanames{zh}->{861335418} = "辽宁省阜新市";
$areanames{zh}->{861335419} = "辽宁省辽阳市";
$areanames{zh}->{861335420} = "辽宁省沈阳市";
$areanames{zh}->{861335421} = "辽宁省朝阳市";
$areanames{zh}->{861335422} = "辽宁省沈阳市";
$areanames{zh}->{861335423} = "辽宁省沈阳市";
$areanames{zh}->{861335424} = "辽宁省沈阳市";
$areanames{zh}->{861335425} = "辽宁省鞍山市";
$areanames{zh}->{861335426} = "辽宁省大连市";
$areanames{zh}->{861335427} = "辽宁省盘锦市";
$areanames{zh}->{861335428} = "辽宁省大连市";
$areanames{zh}->{861335429} = "辽宁省葫芦岛市";
$areanames{zh}->{861335430} = "吉林省长春市";
$areanames{zh}->{861335431} = "吉林省长春市";
$areanames{zh}->{861335432} = "吉林省吉林市";
$areanames{zh}->{861335433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861335434} = "吉林省四平市";
$areanames{zh}->{861335435} = "吉林省通化市";
$areanames{zh}->{861335436} = "吉林省白城市";
$areanames{zh}->{861335437} = "吉林省辽源市";
$areanames{zh}->{861335438} = "吉林省松原市";
$areanames{zh}->{861335439} = "吉林省白山市";
$areanames{zh}->{861335440} = "山东省淄博市";
$areanames{zh}->{861335441} = "山东省淄博市";
$areanames{zh}->{861335442} = "山东省德州市";
$areanames{zh}->{861335443} = "山东省德州市";
$areanames{zh}->{861335444} = "山东省青岛市";
$areanames{zh}->{861335445} = "山东省青岛市";
$areanames{zh}->{861335446} = "山东省聊城市";
$areanames{zh}->{861335447} = "山东省聊城市";
$areanames{zh}->{861335448} = "山东省枣庄市";
$areanames{zh}->{861335449} = "山东省枣庄市";
$areanames{zh}->{861335450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335453} = "黑龙江省牡丹江市";
$areanames{zh}->{861335454} = "黑龙江省佳木斯市";
$areanames{zh}->{861335455} = "黑龙江省绥化市";
$areanames{zh}->{861335456} = "黑龙江省黑河市";
$areanames{zh}->{861335457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335458} = "黑龙江省伊春市";
$areanames{zh}->{861335459} = "黑龙江省大庆市";
$areanames{zh}->{86133546} = "云南省昆明市";
$areanames{zh}->{861335466} = "云南省玉溪市";
$areanames{zh}->{861335467} = "云南省玉溪市";
$areanames{zh}->{861335468} = "云南省曲靖市";
$areanames{zh}->{861335469} = "云南省楚雄彝族自治州";
$areanames{zh}->{861335470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861335471} = "内蒙古呼和浩特市";
$areanames{zh}->{861335472} = "内蒙古包头市";
$areanames{zh}->{861335473} = "内蒙古乌海市";
$areanames{zh}->{861335474} = "内蒙古兴安盟";
$areanames{zh}->{861335475} = "内蒙古通辽市";
$areanames{zh}->{861335476} = "内蒙古赤峰市";
$areanames{zh}->{861335477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861335478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861335479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861335480} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861335481} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861335482} = "内蒙古兴安盟";
$areanames{zh}->{861335483} = "内蒙古阿拉善盟";
$areanames{zh}->{861335484} = "内蒙古赤峰市";
$areanames{zh}->{861335485} = "内蒙古赤峰市";
$areanames{zh}->{861335486} = "内蒙古包头市";
$areanames{zh}->{861335487} = "内蒙古呼和浩特市";
$areanames{zh}->{861335488} = "内蒙古呼和浩特市";
$areanames{zh}->{861335489} = "内蒙古呼和浩特市";
$areanames{zh}->{86133549} = "云南省昆明市";
$areanames{zh}->{86133550} = "山东省临沂市";
$areanames{zh}->{86133551} = "山东省济宁市";
$areanames{zh}->{86133552} = "山东省淄博市";
$areanames{zh}->{861335530} = "山东省菏泽市";
$areanames{zh}->{861335531} = "山东省济南市";
$areanames{zh}->{861335532} = "山东省青岛市";
$areanames{zh}->{861335533} = "山东省淄博市";
$areanames{zh}->{861335534} = "山东省德州市";
$areanames{zh}->{861335535} = "山东省烟台市";
$areanames{zh}->{861335536} = "山东省潍坊市";
$areanames{zh}->{861335537} = "山东省济宁市";
$areanames{zh}->{861335538} = "山东省泰安市";
$areanames{zh}->{861335539} = "山东省临沂市";
$areanames{zh}->{861335540} = "山东省菏泽市";
$areanames{zh}->{861335541} = "山东省济南市";
$areanames{zh}->{861335542} = "山东省青岛市";
$areanames{zh}->{861335543} = "山东省滨州市";
$areanames{zh}->{861335544} = "山东省德州市";
$areanames{zh}->{861335545} = "山东省烟台市";
$areanames{zh}->{861335546} = "山东省东营市";
$areanames{zh}->{861335547} = "山东省济宁市";
$areanames{zh}->{861335548} = "山东省泰安市";
$areanames{zh}->{861335549} = "山东省临沂市";
$areanames{zh}->{861335550} = "安徽省滁州市";
$areanames{zh}->{861335551} = "安徽省合肥市";
$areanames{zh}->{861335552} = "安徽省蚌埠市";
$areanames{zh}->{861335553} = "安徽省芜湖市";
$areanames{zh}->{861335554} = "安徽省淮南市";
$areanames{zh}->{861335555} = "安徽省马鞍山市";
$areanames{zh}->{861335556} = "安徽省安庆市";
$areanames{zh}->{861335557} = "安徽省宿州市";
$areanames{zh}->{861335558} = "安徽省阜阳市";
$areanames{zh}->{861335559} = "安徽省黄山市";
$areanames{zh}->{861335560} = "安徽省合肥市";
$areanames{zh}->{861335561} = "安徽省淮北市";
$areanames{zh}->{861335562} = "安徽省铜陵市";
$areanames{zh}->{861335563} = "安徽省宣城市";
$areanames{zh}->{861335564} = "安徽省六安市";
$areanames{zh}->{861335565} = "安徽省巢湖市";
$areanames{zh}->{861335566} = "安徽省池州市";
$areanames{zh}->{861335567} = "安徽省亳州市";
$areanames{zh}->{861335568} = "安徽省亳州市";
$areanames{zh}->{861335569} = "安徽省合肥市";
$areanames{zh}->{861335570} = "浙江省衢州市";
$areanames{zh}->{861335571} = "浙江省杭州市";
$areanames{zh}->{861335572} = "浙江省湖州市";
$areanames{zh}->{861335573} = "浙江省嘉兴市";
$areanames{zh}->{861335574} = "浙江省宁波市";
$areanames{zh}->{861335575} = "浙江省绍兴市";
$areanames{zh}->{861335576} = "浙江省台州市";
$areanames{zh}->{861335577} = "浙江省温州市";
$areanames{zh}->{861335578} = "浙江省杭州市";
$areanames{zh}->{861335579} = "浙江省金华市";
$areanames{zh}->{861335580} = "浙江省舟山市";
$areanames{zh}->{861335581} = "浙江省杭州市";
$areanames{zh}->{861335582} = "浙江省湖州市";
$areanames{zh}->{861335583} = "浙江省嘉兴市";
$areanames{zh}->{861335584} = "浙江省宁波市";
$areanames{zh}->{861335585} = "浙江省绍兴市";
$areanames{zh}->{861335586} = "浙江省台州市";
$areanames{zh}->{861335587} = "浙江省温州市";
$areanames{zh}->{861335588} = "浙江省温州市";
$areanames{zh}->{861335589} = "浙江省金华市";
$areanames{zh}->{86133559} = "浙江省宁波市";
$areanames{zh}->{86133560} = "浙江省嘉兴市";
$areanames{zh}->{86133561} = "浙江省温州市";
$areanames{zh}->{861335620} = "山东省菏泽市";
$areanames{zh}->{861335621} = "山东省菏泽市";
$areanames{zh}->{861335622} = "山东省莱芜市";
$areanames{zh}->{861335623} = "山东省日照市";
$areanames{zh}->{861335624} = "山东省滨州市";
$areanames{zh}->{861335625} = "山东省聊城市";
$areanames{zh}->{861335626} = "山东省德州市";
$areanames{zh}->{861335627} = "山东省德州市";
$areanames{zh}->{861335628} = "山东省滨州市";
$areanames{zh}->{861335629} = "山东省滨州市";
$areanames{zh}->{861335630} = "山东省威海市";
$areanames{zh}->{861335631} = "山东省威海市";
$areanames{zh}->{861335632} = "山东省枣庄市";
$areanames{zh}->{861335633} = "山东省日照市";
$areanames{zh}->{861335634} = "山东省莱芜市";
$areanames{zh}->{861335635} = "山东省聊城市";
$areanames{zh}->{861335636} = "山东省潍坊市";
$areanames{zh}->{861335637} = "山东省枣庄市";
$areanames{zh}->{861335638} = "山东省烟台市";
$areanames{zh}->{861335639} = "山东省青岛市";
$areanames{zh}->{861335640} = "广东省江门市";
$areanames{zh}->{861335641} = "广东省江门市";
$areanames{zh}->{861335642} = "广东省江门市";
$areanames{zh}->{861335643} = "广东省江门市";
$areanames{zh}->{861335644} = "广东省江门市";
$areanames{zh}->{861335645} = "广东省东莞市";
$areanames{zh}->{861335646} = "广东省东莞市";
$areanames{zh}->{861335647} = "广东省东莞市";
$areanames{zh}->{861335648} = "广东省东莞市";
$areanames{zh}->{861335649} = "广东省东莞市";
$areanames{zh}->{861335650} = "广东省湛江市";
$areanames{zh}->{861335651} = "广东省湛江市";
$areanames{zh}->{861335652} = "广东省湛江市";
$areanames{zh}->{861335653} = "广东省湛江市";
$areanames{zh}->{861335654} = "广东省湛江市";
$areanames{zh}->{861335655} = "广东省江门市";
$areanames{zh}->{861335656} = "广东省江门市";
$areanames{zh}->{861335657} = "广东省江门市";
$areanames{zh}->{861335658} = "广东省江门市";
$areanames{zh}->{861335659} = "广东省江门市";
$areanames{zh}->{861335660} = "山东省东营市";
$areanames{zh}->{861335661} = "山东省东营市";
$areanames{zh}->{861335662} = "山东省东营市";
$areanames{zh}->{861335663} = "山东省东营市";
$areanames{zh}->{861335664} = "山东省东营市";
$areanames{zh}->{861335665} = "山东省济南市";
$areanames{zh}->{861335666} = "山东省济南市";
$areanames{zh}->{861335667} = "山东省济南市";
$areanames{zh}->{861335668} = "山东省济南市";
$areanames{zh}->{861335669} = "山东省济南市";
$areanames{zh}->{86133567} = "山东省潍坊市";
$areanames{zh}->{861335680} = "山东省威海市";
$areanames{zh}->{861335681} = "山东省威海市";
$areanames{zh}->{861335682} = "山东省泰安市";
$areanames{zh}->{861335683} = "山东省东营市";
$areanames{zh}->{861335684} = "山东省德州市";
$areanames{zh}->{861335685} = "山东省青岛市";
$areanames{zh}->{861335686} = "山东省青岛市";
$areanames{zh}->{861335687} = "山东省青岛市";
$areanames{zh}->{861335688} = "山东省青岛市";
$areanames{zh}->{861335689} = "山东省青岛市";
$areanames{zh}->{86133569} = "山东省烟台市";
$areanames{zh}->{861335700} = "浙江省衢州市";
$areanames{zh}->{861335701} = "浙江省衢州市";
$areanames{zh}->{861335702} = "浙江省衢州市";
$areanames{zh}->{861335703} = "浙江省金华市";
$areanames{zh}->{861335704} = "浙江省金华市";
$areanames{zh}->{861335705} = "浙江省金华市";
$areanames{zh}->{861335706} = "浙江省金华市";
$areanames{zh}->{861335707} = "浙江省丽水市";
$areanames{zh}->{861335708} = "浙江省丽水市";
$areanames{zh}->{861335709} = "浙江省丽水市";
$areanames{zh}->{86133571} = "浙江省杭州市";
$areanames{zh}->{861335720} = "湖南省株洲市";
$areanames{zh}->{861335721} = "湖南省长沙市";
$areanames{zh}->{861335722} = "湖南省长沙市";
$areanames{zh}->{861335723} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861335724} = "湖南省衡阳市";
$areanames{zh}->{861335725} = "湖南省怀化市";
$areanames{zh}->{861335726} = "湖南省永州市";
$areanames{zh}->{861335727} = "湖南省郴州市";
$areanames{zh}->{861335728} = "湖南省永州市";
$areanames{zh}->{861335729} = "湖南省邵阳市";
$areanames{zh}->{861335730} = "湖南省岳阳市";
$areanames{zh}->{861335731} = "湖南省长沙市";
$areanames{zh}->{861335732} = "湖南省湘潭市";
$areanames{zh}->{861335733} = "湖南省株洲市";
$areanames{zh}->{861335734} = "湖南省衡阳市";
$areanames{zh}->{861335735} = "湖南省郴州市";
$areanames{zh}->{861335736} = "湖南省常德市";
$areanames{zh}->{861335737} = "湖南省益阳市";
$areanames{zh}->{861335738} = "湖南省娄底市";
$areanames{zh}->{861335739} = "湖南省邵阳市";
$areanames{zh}->{86133574} = "北京市";
$areanames{zh}->{86133575} = "浙江省绍兴市";
$areanames{zh}->{86133576} = "浙江省台州市";
$areanames{zh}->{861335770} = "江苏省南京市";
$areanames{zh}->{861335771} = "江苏省南京市";
$areanames{zh}->{861335772} = "江苏省南京市";
$areanames{zh}->{861335773} = "江苏省南京市";
$areanames{zh}->{861335774} = "江苏省镇江市";
$areanames{zh}->{861335775} = "江苏省镇江市";
$areanames{zh}->{861335776} = "江苏省镇江市";
$areanames{zh}->{861335777} = "江苏省镇江市";
$areanames{zh}->{861335778} = "江苏省泰州市";
$areanames{zh}->{861335779} = "江苏省泰州市";
$areanames{zh}->{861335780} = "江苏省南京市";
$areanames{zh}->{861335781} = "江苏省南京市";
$areanames{zh}->{861335782} = "江苏省南京市";
$areanames{zh}->{861335783} = "江苏省南京市";
$areanames{zh}->{861335784} = "江苏省宿迁市";
$areanames{zh}->{861335785} = "江苏省宿迁市";
$areanames{zh}->{861335786} = "江苏省连云港市";
$areanames{zh}->{861335787} = "江苏省连云港市";
$areanames{zh}->{861335788} = "江苏省常州市";
$areanames{zh}->{861335789} = "江苏省常州市";
$areanames{zh}->{861335790} = "江苏省无锡市";
$areanames{zh}->{861335791} = "江苏省无锡市";
$areanames{zh}->{861335792} = "江苏省无锡市";
$areanames{zh}->{861335793} = "江苏省徐州市";
$areanames{zh}->{861335794} = "江苏省徐州市";
$areanames{zh}->{861335795} = "江苏省徐州市";
$areanames{zh}->{861335796} = "江苏省淮安市";
$areanames{zh}->{861335797} = "江苏省淮安市";
$areanames{zh}->{861335798} = "江苏省盐城市";
$areanames{zh}->{861335799} = "江苏省盐城市";
$areanames{zh}->{86133580} = "江苏省苏州市";
$areanames{zh}->{861335806} = "江苏省南通市";
$areanames{zh}->{861335807} = "江苏省南通市";
$areanames{zh}->{861335808} = "江苏省南通市";
$areanames{zh}->{861335809} = "江苏省南通市";
$areanames{zh}->{861335810} = "江苏省无锡市";
$areanames{zh}->{861335811} = "江苏省无锡市";
$areanames{zh}->{861335812} = "江苏省扬州市";
$areanames{zh}->{861335813} = "江苏省扬州市";
$areanames{zh}->{861335814} = "江苏省扬州市";
$areanames{zh}->{861335815} = "江苏省无锡市";
$areanames{zh}->{861335816} = "江苏省常州市";
$areanames{zh}->{861335817} = "江苏省常州市";
$areanames{zh}->{861335818} = "江苏省常州市";
$areanames{zh}->{861335819} = "江苏省常州市";
$areanames{zh}->{86133582} = "福建省福州市";
$areanames{zh}->{861335830} = "福建省漳州市";
$areanames{zh}->{861335831} = "福建省漳州市";
$areanames{zh}->{861335832} = "福建省漳州市";
$areanames{zh}->{861335833} = "福建省漳州市";
$areanames{zh}->{861335834} = "福建省漳州市";
$areanames{zh}->{861335835} = "福建省龙岩市";
$areanames{zh}->{861335836} = "福建省龙岩市";
$areanames{zh}->{861335837} = "福建省厦门市";
$areanames{zh}->{861335838} = "福建省厦门市";
$areanames{zh}->{861335839} = "福建省厦门市";
$areanames{zh}->{861335840} = "福建省三明市";
$areanames{zh}->{861335841} = "福建省三明市";
$areanames{zh}->{861335842} = "福建省泉州市";
$areanames{zh}->{861335843} = "福建省泉州市";
$areanames{zh}->{861335844} = "福建省南平市";
$areanames{zh}->{861335845} = "福建省南平市";
$areanames{zh}->{861335846} = "福建省南平市";
$areanames{zh}->{861335847} = "福建省宁德市";
$areanames{zh}->{861335848} = "福建省宁德市";
$areanames{zh}->{861335849} = "福建省宁德市";
$areanames{zh}->{86133585} = "福建省泉州市";
$areanames{zh}->{861335850} = "福建省三明市";
$areanames{zh}->{861335851} = "福建省莆田市";
$areanames{zh}->{861335852} = "福建省莆田市";
$areanames{zh}->{861335853} = "福建省莆田市";
$areanames{zh}->{86133586} = "辽宁省鞍山市";
$areanames{zh}->{861335869} = "辽宁省抚顺市";
$areanames{zh}->{861335870} = "辽宁省辽阳市";
$areanames{zh}->{861335871} = "辽宁省阜新市";
$areanames{zh}->{861335872} = "辽宁省阜新市";
$areanames{zh}->{861335873} = "辽宁省营口市";
$areanames{zh}->{861335874} = "辽宁省营口市";
$areanames{zh}->{861335875} = "辽宁省锦州市";
$areanames{zh}->{861335876} = "辽宁省锦州市";
$areanames{zh}->{861335877} = "辽宁省丹东市";
$areanames{zh}->{861335878} = "辽宁省丹东市";
$areanames{zh}->{861335879} = "辽宁省抚顺市";
$areanames{zh}->{861335880} = "辽宁省葫芦岛市";
$areanames{zh}->{861335881} = "辽宁省葫芦岛市";
$areanames{zh}->{861335882} = "辽宁省葫芦岛市";
$areanames{zh}->{861335883} = "辽宁省葫芦岛市";
$areanames{zh}->{861335884} = "辽宁省葫芦岛市";
$areanames{zh}->{861335885} = "辽宁省沈阳市";
$areanames{zh}->{861335886} = "辽宁省沈阳市";
$areanames{zh}->{861335887} = "辽宁省沈阳市";
$areanames{zh}->{861335888} = "辽宁省沈阳市";
$areanames{zh}->{861335889} = "辽宁省本溪市";
$areanames{zh}->{86133589} = "辽宁省铁岭市";
$areanames{zh}->{861335890} = "辽宁省盘锦市";
$areanames{zh}->{861335891} = "辽宁省盘锦市";
$areanames{zh}->{861335892} = "辽宁省朝阳市";
$areanames{zh}->{861335893} = "辽宁省朝阳市";
$areanames{zh}->{861335900} = "安徽省滁州市";
$areanames{zh}->{861335901} = "安徽省合肥市";
$areanames{zh}->{861335902} = "安徽省蚌埠市";
$areanames{zh}->{861335903} = "安徽省淮南市";
$areanames{zh}->{861335904} = "安徽省安庆市";
$areanames{zh}->{861335905} = "安徽省马鞍山市";
$areanames{zh}->{861335906} = "安徽省阜阳市";
$areanames{zh}->{861335907} = "安徽省宿州市";
$areanames{zh}->{861335908} = "安徽省芜湖市";
$areanames{zh}->{861335909} = "安徽省黄山市";
$areanames{zh}->{861335910} = "陕西省咸阳市";
$areanames{zh}->{861335911} = "陕西省延安市";
$areanames{zh}->{861335912} = "陕西省榆林市";
$areanames{zh}->{861335913} = "陕西省渭南市";
$areanames{zh}->{861335914} = "陕西省商洛市";
$areanames{zh}->{861335915} = "陕西省安康市";
$areanames{zh}->{861335916} = "陕西省汉中市";
$areanames{zh}->{861335917} = "陕西省宝鸡市";
$areanames{zh}->{861335918} = "陕西省西安市";
$areanames{zh}->{861335919} = "陕西省铜川市";
$areanames{zh}->{86133592} = "陕西省西安市";
$areanames{zh}->{861335930} = "甘肃省金昌市";
$areanames{zh}->{861335931} = "甘肃省兰州市";
$areanames{zh}->{861335932} = "甘肃省白银市";
$areanames{zh}->{861335933} = "甘肃省平凉市";
$areanames{zh}->{861335934} = "甘肃省庆阳市";
$areanames{zh}->{861335935} = "甘肃省武威市";
$areanames{zh}->{861335936} = "甘肃省张掖市";
$areanames{zh}->{861335937} = "甘肃省嘉峪关市";
$areanames{zh}->{861335938} = "甘肃省天水市";
$areanames{zh}->{861335939} = "甘肃省酒泉市";
$areanames{zh}->{86133594} = "甘肃省兰州市";
$areanames{zh}->{861335950} = "黑龙江省大庆市";
$areanames{zh}->{861335951} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335952} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335953} = "黑龙江省牡丹江市";
$areanames{zh}->{861335954} = "黑龙江省佳木斯市";
$areanames{zh}->{861335955} = "黑龙江省佳木斯市";
$areanames{zh}->{861335956} = "黑龙江省牡丹江市";
$areanames{zh}->{861335957} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335958} = "黑龙江省鹤岗市";
$areanames{zh}->{861335959} = "黑龙江省大庆市";
$areanames{zh}->{861335960} = "黑龙江省大庆市";
$areanames{zh}->{861335961} = "黑龙江省大庆市";
$areanames{zh}->{861335962} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335963} = "黑龙江省佳木斯市";
$areanames{zh}->{861335964} = "黑龙江省佳木斯市";
$areanames{zh}->{861335965} = "黑龙江省双鸭山市";
$areanames{zh}->{861335966} = "黑龙江省伊春市";
$areanames{zh}->{861335967} = "黑龙江省伊春市";
$areanames{zh}->{861335968} = "黑龙江省牡丹江市";
$areanames{zh}->{861335969} = "黑龙江省牡丹江市";
$areanames{zh}->{861335970} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335971} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335972} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335973} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335974} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335975} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861335976} = "黑龙江省佳木斯市";
$areanames{zh}->{861335977} = "黑龙江省鹤岗市";
$areanames{zh}->{861335978} = "黑龙江省双鸭山市";
$areanames{zh}->{861335979} = "黑龙江省七台河市";
$areanames{zh}->{861335980} = "黑龙江省大庆市";
$areanames{zh}->{861335981} = "黑龙江省大庆市";
$areanames{zh}->{861335982} = "黑龙江省大庆市";
$areanames{zh}->{861335983} = "黑龙江省大庆市";
$areanames{zh}->{861335984} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335985} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335986} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335987} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335988} = "黑龙江省牡丹江市";
$areanames{zh}->{861335989} = "黑龙江省鸡西市";
$areanames{zh}->{861335990} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861335991} = "黑龙江省绥化市";
$areanames{zh}->{861335992} = "黑龙江省绥化市";
$areanames{zh}->{861335993} = "黑龙江省黑河市";
$areanames{zh}->{861335994} = "黑龙江省黑河市";
$areanames{zh}->{861335995} = "黑龙江省鸡西市";
$areanames{zh}->{861335996} = "黑龙江省鸡西市";
$areanames{zh}->{861335997} = "黑龙江省鹤岗市";
$areanames{zh}->{861335998} = "黑龙江省哈尔滨市";
$areanames{zh}->{861335999} = "黑龙江省哈尔滨市";
$areanames{zh}->{861336000} = "广东省广州市";
$areanames{zh}->{861336001} = "广东省广州市";
$areanames{zh}->{861336002} = "广东省广州市";
$areanames{zh}->{861336003} = "广东省广州市";
$areanames{zh}->{861336004} = "广东省广州市";
$areanames{zh}->{861336005} = "广东省深圳市";
$areanames{zh}->{861336006} = "广东省深圳市";
$areanames{zh}->{861336007} = "广东省深圳市";
$areanames{zh}->{861336008} = "广东省深圳市";
$areanames{zh}->{861336009} = "广东省深圳市";
$areanames{zh}->{861336010} = "广东省湛江市";
$areanames{zh}->{861336011} = "广东省湛江市";
$areanames{zh}->{861336012} = "广东省湛江市";
$areanames{zh}->{861336013} = "广东省中山市";
$areanames{zh}->{861336014} = "广东省中山市";
$areanames{zh}->{861336015} = "广东省中山市";
$areanames{zh}->{861336016} = "广东省汕头市";
$areanames{zh}->{861336017} = "广东省汕头市";
$areanames{zh}->{861336018} = "广东省阳江市";
$areanames{zh}->{861336019} = "广东省云浮市";
$areanames{zh}->{861336020} = "广东省江门市";
$areanames{zh}->{861336021} = "广东省江门市";
$areanames{zh}->{861336022} = "广东省江门市";
$areanames{zh}->{861336023} = "广东省肇庆市";
$areanames{zh}->{861336024} = "广东省肇庆市";
$areanames{zh}->{861336025} = "广东省肇庆市";
$areanames{zh}->{861336026} = "广东省肇庆市";
$areanames{zh}->{861336027} = "广东省肇庆市";
$areanames{zh}->{861336028} = "广东省茂名市";
$areanames{zh}->{861336029} = "广东省茂名市";
$areanames{zh}->{86133603} = "广东省佛山市";
$areanames{zh}->{861336038} = "广东省揭阳市";
$areanames{zh}->{861336039} = "广东省揭阳市";
$areanames{zh}->{861336040} = "广东省惠州市";
$areanames{zh}->{861336041} = "广东省惠州市";
$areanames{zh}->{861336042} = "广东省惠州市";
$areanames{zh}->{861336043} = "广东省江门市";
$areanames{zh}->{861336044} = "广东省江门市";
$areanames{zh}->{861336045} = "广东省东莞市";
$areanames{zh}->{861336046} = "广东省东莞市";
$areanames{zh}->{861336047} = "广东省东莞市";
$areanames{zh}->{861336048} = "广东省东莞市";
$areanames{zh}->{861336049} = "广东省河源市";
$areanames{zh}->{861336050} = "广东省深圳市";
$areanames{zh}->{861336051} = "广东省深圳市";
$areanames{zh}->{861336052} = "广东省深圳市";
$areanames{zh}->{861336053} = "广东省深圳市";
$areanames{zh}->{861336054} = "广东省深圳市";
$areanames{zh}->{861336055} = "广东省广州市";
$areanames{zh}->{861336056} = "广东省广州市";
$areanames{zh}->{861336057} = "广东省广州市";
$areanames{zh}->{861336058} = "广东省广州市";
$areanames{zh}->{861336059} = "广东省广州市";
$areanames{zh}->{86133606} = "广东省东莞市";
$areanames{zh}->{861336060} = "广东省珠海市";
$areanames{zh}->{861336061} = "广东省珠海市";
$areanames{zh}->{861336062} = "广东省潮州市";
$areanames{zh}->{861336069} = "广东省韶关市";
$areanames{zh}->{861336070} = "广东省湛江市";
$areanames{zh}->{861336071} = "广东省湛江市";
$areanames{zh}->{861336072} = "广东省清远市";
$areanames{zh}->{861336073} = "广东省茂名市";
$areanames{zh}->{861336074} = "广东省茂名市";
$areanames{zh}->{861336075} = "广东省茂名市";
$areanames{zh}->{861336076} = "广东省珠海市";
$areanames{zh}->{861336077} = "广东省珠海市";
$areanames{zh}->{861336078} = "广东省揭阳市";
$areanames{zh}->{861336079} = "广东省揭阳市";
$areanames{zh}->{86133608} = "广东省惠州市";
$areanames{zh}->{861336080} = "广东省汕头市";
$areanames{zh}->{861336081} = "广东省汕头市";
$areanames{zh}->{861336082} = "广东省汕头市";
$areanames{zh}->{861336090} = "广东省韶关市";
$areanames{zh}->{861336091} = "广东省韶关市";
$areanames{zh}->{861336092} = "广东省清远市";
$areanames{zh}->{861336093} = "广东省清远市";
$areanames{zh}->{861336094} = "广东省汕尾市";
$areanames{zh}->{861336095} = "广东省汕尾市";
$areanames{zh}->{861336096} = "广东省梅州市";
$areanames{zh}->{861336097} = "广东省深圳市";
$areanames{zh}->{861336098} = "广东省河源市";
$areanames{zh}->{861336099} = "广东省河源市";
$areanames{zh}->{86133610} = "山东省济南市";
$areanames{zh}->{86133611} = "山东省威海市";
$areanames{zh}->{861336110} = "山东省枣庄市";
$areanames{zh}->{861336111} = "山东省枣庄市";
$areanames{zh}->{861336112} = "山东省枣庄市";
$areanames{zh}->{861336113} = "山东省枣庄市";
$areanames{zh}->{86133612} = "山东省青岛市";
$areanames{zh}->{86133613} = "山东省烟台市";
$areanames{zh}->{861336140} = "山东省淄博市";
$areanames{zh}->{861336141} = "山东省东营市";
$areanames{zh}->{861336142} = "山东省枣庄市";
$areanames{zh}->{861336143} = "山东省枣庄市";
$areanames{zh}->{861336144} = "山东省潍坊市";
$areanames{zh}->{861336145} = "山东省潍坊市";
$areanames{zh}->{861336146} = "山东省聊城市";
$areanames{zh}->{861336147} = "山东省聊城市";
$areanames{zh}->{861336148} = "山东省青岛市";
$areanames{zh}->{861336149} = "山东省青岛市";
$areanames{zh}->{861336150} = "山东省东营市";
$areanames{zh}->{861336151} = "山东省东营市";
$areanames{zh}->{861336152} = "山东省东营市";
$areanames{zh}->{861336153} = "山东省潍坊市";
$areanames{zh}->{861336154} = "山东省潍坊市";
$areanames{zh}->{861336155} = "山东省潍坊市";
$areanames{zh}->{861336156} = "山东省潍坊市";
$areanames{zh}->{861336157} = "山东省潍坊市";
$areanames{zh}->{861336158} = "山东省淄博市";
$areanames{zh}->{861336159} = "山东省淄博市";
$areanames{zh}->{861336160} = "江西省鹰潭市";
$areanames{zh}->{861336161} = "江西省南昌市";
$areanames{zh}->{861336162} = "江西省南昌市";
$areanames{zh}->{861336163} = "江西省南昌市";
$areanames{zh}->{861336164} = "江西省南昌市";
$areanames{zh}->{861336165} = "江西省南昌市";
$areanames{zh}->{861336166} = "江西省抚州市";
$areanames{zh}->{861336167} = "江西省抚州市";
$areanames{zh}->{861336168} = "江西省抚州市";
$areanames{zh}->{861336169} = "江西省上饶市";
$areanames{zh}->{861336170} = "江西省新余市";
$areanames{zh}->{861336171} = "江西省南昌市";
$areanames{zh}->{861336172} = "江西省九江市";
$areanames{zh}->{861336173} = "江西省上饶市";
$areanames{zh}->{861336174} = "江西省萍乡市";
$areanames{zh}->{861336175} = "江西省宜春市";
$areanames{zh}->{861336176} = "江西省吉安市";
$areanames{zh}->{861336177} = "江西省赣州市";
$areanames{zh}->{861336178} = "江西省景德镇市";
$areanames{zh}->{861336179} = "江西省萍乡市";
$areanames{zh}->{86133618} = "上海市";
$areanames{zh}->{86133619} = "上海市";
$areanames{zh}->{861336200} = "浙江省衢州市";
$areanames{zh}->{861336201} = "浙江省衢州市";
$areanames{zh}->{861336202} = "浙江省衢州市";
$areanames{zh}->{861336203} = "浙江省衢州市";
$areanames{zh}->{861336204} = "浙江省衢州市";
$areanames{zh}->{861336205} = "浙江省丽水市";
$areanames{zh}->{861336206} = "浙江省丽水市";
$areanames{zh}->{861336207} = "浙江省丽水市";
$areanames{zh}->{861336208} = "浙江省丽水市";
$areanames{zh}->{861336209} = "浙江省丽水市";
$areanames{zh}->{86133621} = "浙江省杭州市";
$areanames{zh}->{86133622} = "浙江省湖州市";
$areanames{zh}->{86133623} = "浙江省嘉兴市";
$areanames{zh}->{86133624} = "浙江省宁波市";
$areanames{zh}->{861336240} = "浙江省舟山市";
$areanames{zh}->{861336241} = "浙江省舟山市";
$areanames{zh}->{861336242} = "浙江省舟山市";
$areanames{zh}->{861336249} = "浙江省丽水市";
$areanames{zh}->{86133625} = "浙江省绍兴市";
$areanames{zh}->{86133626} = "浙江省台州市";
$areanames{zh}->{86133627} = "浙江省温州市";
$areanames{zh}->{86133628} = "浙江省宁波市";
$areanames{zh}->{861336280} = "浙江省舟山市";
$areanames{zh}->{861336281} = "浙江省舟山市";
$areanames{zh}->{861336282} = "浙江省舟山市";
$areanames{zh}->{861336289} = "浙江省杭州市";
$areanames{zh}->{86133629} = "浙江省金华市";
$areanames{zh}->{86133630} = "河北省邯郸市";
$areanames{zh}->{861336310} = "河北省邯郸市";
$areanames{zh}->{861336311} = "河北省石家庄市";
$areanames{zh}->{861336312} = "河北省保定市";
$areanames{zh}->{861336313} = "河北省张家口市";
$areanames{zh}->{861336314} = "河北省承德市";
$areanames{zh}->{861336315} = "河北省唐山市";
$areanames{zh}->{861336316} = "河北省廊坊市";
$areanames{zh}->{861336317} = "河北省沧州市";
$areanames{zh}->{861336318} = "河北省衡水市";
$areanames{zh}->{861336319} = "河北省邢台市";
$areanames{zh}->{86133632} = "河北省唐山市";
$areanames{zh}->{861336330} = "河北省衡水市";
$areanames{zh}->{861336331} = "河北省衡水市";
$areanames{zh}->{861336332} = "河北省衡水市";
$areanames{zh}->{861336333} = "河北省衡水市";
$areanames{zh}->{861336334} = "河北省衡水市";
$areanames{zh}->{861336335} = "河北省秦皇岛市";
$areanames{zh}->{861336336} = "河北省唐山市";
$areanames{zh}->{861336337} = "河北省唐山市";
$areanames{zh}->{861336338} = "河北省唐山市";
$areanames{zh}->{861336339} = "河北省唐山市";
$areanames{zh}->{861336340} = "山西省大同市";
$areanames{zh}->{861336341} = "山西省太原市";
$areanames{zh}->{861336342} = "山西省大同市";
$areanames{zh}->{861336343} = "山西省太原市";
$areanames{zh}->{861336344} = "山西省太原市";
$areanames{zh}->{861336345} = "山西省长治市";
$areanames{zh}->{861336346} = "山西省晋城市";
$areanames{zh}->{861336347} = "山西省临汾市";
$areanames{zh}->{861336348} = "山西省运城市";
$areanames{zh}->{861336349} = "山西省朔州市";
$areanames{zh}->{861336350} = "山西省忻州市";
$areanames{zh}->{861336351} = "山西省太原市";
$areanames{zh}->{861336352} = "山西省大同市";
$areanames{zh}->{861336353} = "山西省阳泉市";
$areanames{zh}->{861336354} = "山西省晋中市";
$areanames{zh}->{861336355} = "山西省长治市";
$areanames{zh}->{861336356} = "山西省晋城市";
$areanames{zh}->{861336357} = "山西省临汾市";
$areanames{zh}->{861336358} = "山西省吕梁市";
$areanames{zh}->{861336359} = "山西省运城市";
$areanames{zh}->{86133636} = "河北省廊坊市";
$areanames{zh}->{861336366} = "河北省沧州市";
$areanames{zh}->{861336367} = "河北省沧州市";
$areanames{zh}->{861336368} = "河北省沧州市";
$areanames{zh}->{861336369} = "河北省沧州市";
$areanames{zh}->{86133637} = "河北省邢台市";
$areanames{zh}->{86133638} = "河北省石家庄市";
$areanames{zh}->{86133639} = "陕西省西安市";
$areanames{zh}->{86133640} = "重庆市";
$areanames{zh}->{861336410} = "辽宁省铁岭市";
$areanames{zh}->{861336411} = "辽宁省大连市";
$areanames{zh}->{861336412} = "辽宁省鞍山市";
$areanames{zh}->{861336413} = "辽宁省抚顺市";
$areanames{zh}->{861336414} = "辽宁省本溪市";
$areanames{zh}->{861336415} = "辽宁省丹东市";
$areanames{zh}->{861336416} = "辽宁省锦州市";
$areanames{zh}->{861336417} = "辽宁省营口市";
$areanames{zh}->{861336418} = "辽宁省阜新市";
$areanames{zh}->{861336419} = "辽宁省辽阳市";
$areanames{zh}->{861336420} = "辽宁省铁岭市";
$areanames{zh}->{861336421} = "辽宁省朝阳市";
$areanames{zh}->{861336422} = "辽宁省鞍山市";
$areanames{zh}->{861336423} = "辽宁省抚顺市";
$areanames{zh}->{861336424} = "辽宁省铁岭市";
$areanames{zh}->{861336425} = "辽宁省盘锦市";
$areanames{zh}->{861336426} = "辽宁省锦州市";
$areanames{zh}->{861336427} = "辽宁省盘锦市";
$areanames{zh}->{861336428} = "辽宁省丹东市";
$areanames{zh}->{861336429} = "辽宁省葫芦岛市";
$areanames{zh}->{861336430} = "吉林省长春市";
$areanames{zh}->{861336431} = "吉林省长春市";
$areanames{zh}->{861336432} = "吉林省吉林市";
$areanames{zh}->{861336433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861336434} = "吉林省四平市";
$areanames{zh}->{861336435} = "吉林省通化市";
$areanames{zh}->{861336436} = "吉林省白城市";
$areanames{zh}->{861336437} = "吉林省辽源市";
$areanames{zh}->{861336438} = "吉林省松原市";
$areanames{zh}->{861336439} = "吉林省白山市";
$areanames{zh}->{861336440} = "吉林省吉林市";
$areanames{zh}->{861336441} = "吉林省吉林市";
$areanames{zh}->{861336442} = "吉林省吉林市";
$areanames{zh}->{861336443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861336444} = "吉林省吉林市";
$areanames{zh}->{861336445} = "吉林省通化市";
$areanames{zh}->{861336446} = "吉林省长春市";
$areanames{zh}->{861336447} = "吉林省长春市";
$areanames{zh}->{861336448} = "吉林省长春市";
$areanames{zh}->{861336449} = "吉林省白山市";
$areanames{zh}->{861336450} = "吉林省长春市";
$areanames{zh}->{861336451} = "吉林省长春市";
$areanames{zh}->{861336452} = "吉林省吉林市";
$areanames{zh}->{861336453} = "吉林省松原市";
$areanames{zh}->{861336454} = "吉林省长春市";
$areanames{zh}->{861336455} = "吉林省四平市";
$areanames{zh}->{861336456} = "吉林省通化市";
$areanames{zh}->{861336457} = "吉林省白城市";
$areanames{zh}->{861336458} = "吉林省四平市";
$areanames{zh}->{861336459} = "吉林省吉林市";
$areanames{zh}->{86133646} = "吉林省长春市";
$areanames{zh}->{861336462} = "吉林省吉林市";
$areanames{zh}->{861336465} = "吉林省辽源市";
$areanames{zh}->{861336466} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861336467} = "吉林省松原市";
$areanames{zh}->{861336470} = "新疆克拉玛依市";
$areanames{zh}->{861336471} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336472} = "新疆阿克苏地区";
$areanames{zh}->{861336473} = "新疆阿克苏地区";
$areanames{zh}->{861336474} = "新疆喀什地区";
$areanames{zh}->{861336475} = "新疆昌吉回族自治州";
$areanames{zh}->{861336476} = "新疆乌鲁木齐市";
$areanames{zh}->{861336477} = "新疆乌鲁木齐市";
$areanames{zh}->{861336478} = "新疆乌鲁木齐市";
$areanames{zh}->{861336479} = "新疆乌鲁木齐市";
$areanames{zh}->{861336480} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336481} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336482} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861336483} = "新疆塔城地区";
$areanames{zh}->{861336484} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336485} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336486} = "新疆阿勒泰地区";
$areanames{zh}->{861336487} = "新疆阿克苏地区";
$areanames{zh}->{861336488} = "新疆喀什地区";
$areanames{zh}->{861336489} = "新疆和田地区";
$areanames{zh}->{861336490} = "新疆昌吉回族自治州";
$areanames{zh}->{861336491} = "新疆昌吉回族自治州";
$areanames{zh}->{861336492} = "新疆吐鲁番地区";
$areanames{zh}->{861336493} = "新疆哈密地区";
$areanames{zh}->{861336494} = "新疆哈密地区";
$areanames{zh}->{861336495} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336496} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336497} = "新疆石河子市";
$areanames{zh}->{861336498} = "新疆石河子市";
$areanames{zh}->{861336499} = "新疆克拉玛依市";
$areanames{zh}->{861336500} = "福建省漳州市";
$areanames{zh}->{861336501} = "福建省漳州市";
$areanames{zh}->{861336502} = "福建省宁德市";
$areanames{zh}->{861336503} = "福建省宁德市";
$areanames{zh}->{861336504} = "福建省厦门市";
$areanames{zh}->{861336505} = "福建省三明市";
$areanames{zh}->{861336506} = "福建省三明市";
$areanames{zh}->{861336507} = "福建省龙岩市";
$areanames{zh}->{861336508} = "福建省龙岩市";
$areanames{zh}->{861336509} = "福建省南平市";
$areanames{zh}->{861336510} = "江苏省扬州市";
$areanames{zh}->{861336511} = "江苏省扬州市";
$areanames{zh}->{861336512} = "江苏省扬州市";
$areanames{zh}->{861336513} = "江苏省扬州市";
$areanames{zh}->{861336514} = "江苏省扬州市";
$areanames{zh}->{861336515} = "江苏省宿迁市";
$areanames{zh}->{861336516} = "江苏省淮安市";
$areanames{zh}->{861336517} = "江苏省淮安市";
$areanames{zh}->{861336518} = "江苏省盐城市";
$areanames{zh}->{861336519} = "江苏省盐城市";
$areanames{zh}->{861336520} = "江苏省泰州市";
$areanames{zh}->{861336521} = "江苏省泰州市";
$areanames{zh}->{861336522} = "江苏省泰州市";
$areanames{zh}->{861336523} = "江苏省泰州市";
$areanames{zh}->{861336524} = "江苏省泰州市";
$areanames{zh}->{861336525} = "江苏省宿迁市";
$areanames{zh}->{861336526} = "江苏省连云港市";
$areanames{zh}->{861336527} = "江苏省连云港市";
$areanames{zh}->{861336528} = "江苏省徐州市";
$areanames{zh}->{861336529} = "江苏省徐州市";
$areanames{zh}->{861336530} = "山东省菏泽市";
$areanames{zh}->{861336531} = "山东省济南市";
$areanames{zh}->{861336532} = "山东省青岛市";
$areanames{zh}->{861336533} = "山东省淄博市";
$areanames{zh}->{861336534} = "山东省德州市";
$areanames{zh}->{861336535} = "山东省烟台市";
$areanames{zh}->{861336536} = "山东省潍坊市";
$areanames{zh}->{861336537} = "山东省济宁市";
$areanames{zh}->{861336538} = "山东省泰安市";
$areanames{zh}->{861336539} = "山东省临沂市";
$areanames{zh}->{861336540} = "山东省菏泽市";
$areanames{zh}->{861336541} = "山东省济南市";
$areanames{zh}->{861336542} = "山东省青岛市";
$areanames{zh}->{861336543} = "山东省滨州市";
$areanames{zh}->{861336544} = "山东省德州市";
$areanames{zh}->{861336545} = "山东省烟台市";
$areanames{zh}->{861336546} = "山东省东营市";
$areanames{zh}->{861336547} = "山东省济宁市";
$areanames{zh}->{861336548} = "山东省泰安市";
$areanames{zh}->{861336549} = "山东省临沂市";
$areanames{zh}->{861336550} = "安徽省滁州市";
$areanames{zh}->{861336551} = "安徽省合肥市";
$areanames{zh}->{861336552} = "安徽省蚌埠市";
$areanames{zh}->{861336553} = "安徽省芜湖市";
$areanames{zh}->{861336554} = "安徽省淮南市";
$areanames{zh}->{861336555} = "安徽省马鞍山市";
$areanames{zh}->{861336556} = "安徽省安庆市";
$areanames{zh}->{861336557} = "安徽省宿州市";
$areanames{zh}->{861336558} = "安徽省阜阳市";
$areanames{zh}->{861336559} = "安徽省黄山市";
$areanames{zh}->{861336560} = "安徽省合肥市";
$areanames{zh}->{861336561} = "安徽省淮北市";
$areanames{zh}->{861336562} = "安徽省铜陵市";
$areanames{zh}->{861336563} = "安徽省宣城市";
$areanames{zh}->{861336564} = "安徽省六安市";
$areanames{zh}->{861336565} = "安徽省巢湖市";
$areanames{zh}->{861336566} = "安徽省池州市";
$areanames{zh}->{861336567} = "安徽省亳州市";
$areanames{zh}->{861336568} = "安徽省六安市";
$areanames{zh}->{861336569} = "安徽省合肥市";
$areanames{zh}->{861336570} = "安徽省滁州市";
$areanames{zh}->{861336571} = "安徽省芜湖市";
$areanames{zh}->{861336572} = "安徽省蚌埠市";
$areanames{zh}->{861336573} = "安徽省芜湖市";
$areanames{zh}->{861336574} = "安徽省合肥市";
$areanames{zh}->{861336575} = "安徽省安庆市";
$areanames{zh}->{861336576} = "安徽省安庆市";
$areanames{zh}->{861336577} = "安徽省宿州市";
$areanames{zh}->{861336578} = "安徽省阜阳市";
$areanames{zh}->{861336579} = "安徽省合肥市";
$areanames{zh}->{861336580} = "湖南省岳阳市";
$areanames{zh}->{861336581} = "湖南省株洲市";
$areanames{zh}->{861336582} = "湖南省湘潭市";
$areanames{zh}->{861336583} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861336584} = "湖南省张家界市";
$areanames{zh}->{861336585} = "湖南省郴州市";
$areanames{zh}->{861336586} = "湖南省永州市";
$areanames{zh}->{861336587} = "湖南省益阳市";
$areanames{zh}->{861336588} = "湖南省衡阳市";
$areanames{zh}->{861336589} = "湖南省邵阳市";
$areanames{zh}->{861336590} = "福建省厦门市";
$areanames{zh}->{861336591} = "福建省福州市";
$areanames{zh}->{861336592} = "福建省厦门市";
$areanames{zh}->{861336593} = "福建省莆田市";
$areanames{zh}->{861336594} = "福建省莆田市";
$areanames{zh}->{861336595} = "福建省泉州市";
$areanames{zh}->{861336596} = "福建省泉州市";
$areanames{zh}->{861336597} = "福建省泉州市";
$areanames{zh}->{861336598} = "福建省泉州市";
$areanames{zh}->{861336599} = "福建省南平市";
$areanames{zh}->{8613366} = "北京市";
$areanames{zh}->{861336700} = "江西省南昌市";
$areanames{zh}->{861336701} = "江西省鹰潭市";
$areanames{zh}->{861336702} = "江西省九江市";
$areanames{zh}->{861336703} = "江西省上饶市";
$areanames{zh}->{861336704} = "江西省抚州市";
$areanames{zh}->{861336705} = "江西省宜春市";
$areanames{zh}->{861336706} = "江西省吉安市";
$areanames{zh}->{861336707} = "江西省赣州市";
$areanames{zh}->{861336708} = "江西省南昌市";
$areanames{zh}->{861336709} = "江西省南昌市";
$areanames{zh}->{861336710} = "湖北省襄樊市";
$areanames{zh}->{861336711} = "湖北省鄂州市";
$areanames{zh}->{861336712} = "湖北省孝感市";
$areanames{zh}->{861336713} = "湖北省黄冈市";
$areanames{zh}->{861336714} = "湖北省黄石市";
$areanames{zh}->{861336715} = "湖北省咸宁市";
$areanames{zh}->{861336716} = "湖北省荆州市";
$areanames{zh}->{861336717} = "湖北省宜昌市";
$areanames{zh}->{861336718} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861336719} = "湖北省十堰市";
$areanames{zh}->{86133672} = "湖北省武汉市";
$areanames{zh}->{861336720} = "湖北省仙桃市";
$areanames{zh}->{861336723} = "湖北省荆门市";
$areanames{zh}->{861336729} = "湖北省随州市";
$areanames{zh}->{861336730} = "湖南省岳阳市";
$areanames{zh}->{861336731} = "湖南省长沙市";
$areanames{zh}->{861336732} = "湖南省湘潭市";
$areanames{zh}->{861336733} = "湖南省株洲市";
$areanames{zh}->{861336734} = "湖南省衡阳市";
$areanames{zh}->{861336735} = "湖南省郴州市";
$areanames{zh}->{861336736} = "湖南省常德市";
$areanames{zh}->{861336737} = "湖南省益阳市";
$areanames{zh}->{861336738} = "湖南省娄底市";
$areanames{zh}->{861336739} = "湖南省邵阳市";
$areanames{zh}->{861336740} = "湖南省岳阳市";
$areanames{zh}->{861336741} = "湖南省株洲市";
$areanames{zh}->{861336742} = "湖南省湘潭市";
$areanames{zh}->{861336743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861336744} = "湖南省张家界市";
$areanames{zh}->{861336745} = "湖南省怀化市";
$areanames{zh}->{861336746} = "湖南省永州市";
$areanames{zh}->{861336747} = "湖南省衡阳市";
$areanames{zh}->{861336748} = "湖南省长沙市";
$areanames{zh}->{861336749} = "湖南省长沙市";
$areanames{zh}->{861336750} = "广西防城港市";
$areanames{zh}->{861336751} = "广西南宁市";
$areanames{zh}->{861336752} = "广西柳州市";
$areanames{zh}->{861336753} = "广西桂林市";
$areanames{zh}->{861336754} = "广西贺州市";
$areanames{zh}->{861336755} = "广西玉林市";
$areanames{zh}->{861336756} = "广西百色市";
$areanames{zh}->{861336757} = "广西贵港市";
$areanames{zh}->{861336758} = "广西河池市";
$areanames{zh}->{861336759} = "广西北海市";
$areanames{zh}->{861336760} = "广西梧州市";
$areanames{zh}->{861336761} = "广西南宁市";
$areanames{zh}->{861336762} = "广西柳州市";
$areanames{zh}->{861336763} = "广西桂林市";
$areanames{zh}->{861336764} = "广西梧州市";
$areanames{zh}->{861336765} = "广西贵港市";
$areanames{zh}->{861336766} = "广西百色市";
$areanames{zh}->{861336767} = "广西钦州市";
$areanames{zh}->{861336768} = "广西河池市";
$areanames{zh}->{861336769} = "广西北海市";
$areanames{zh}->{861336770} = "广西防城港市";
$areanames{zh}->{861336771} = "广西南宁市";
$areanames{zh}->{861336772} = "广西柳州市";
$areanames{zh}->{861336773} = "广西桂林市";
$areanames{zh}->{861336774} = "广西贺州市";
$areanames{zh}->{861336775} = "广西玉林市";
$areanames{zh}->{861336776} = "广西百色市";
$areanames{zh}->{861336777} = "广西钦州市";
$areanames{zh}->{861336778} = "广西河池市";
$areanames{zh}->{861336779} = "广西北海市";
$areanames{zh}->{861336780} = "广西南宁市";
$areanames{zh}->{861336781} = "广西南宁市";
$areanames{zh}->{861336782} = "广西柳州市";
$areanames{zh}->{861336783} = "广西桂林市";
$areanames{zh}->{861336784} = "广西贺州市";
$areanames{zh}->{861336785} = "广西玉林市";
$areanames{zh}->{861336786} = "广西百色市";
$areanames{zh}->{861336787} = "广西梧州市";
$areanames{zh}->{861336788} = "广西河池市";
$areanames{zh}->{861336789} = "广西北海市";
$areanames{zh}->{861336790} = "江西省新余市";
$areanames{zh}->{861336791} = "江西省南昌市";
$areanames{zh}->{861336792} = "江西省九江市";
$areanames{zh}->{861336793} = "江西省上饶市";
$areanames{zh}->{861336794} = "江西省抚州市";
$areanames{zh}->{861336795} = "江西省宜春市";
$areanames{zh}->{861336796} = "江西省吉安市";
$areanames{zh}->{861336797} = "江西省赣州市";
$areanames{zh}->{861336798} = "江西省景德镇市";
$areanames{zh}->{861336799} = "江西省萍乡市";
$areanames{zh}->{86133680} = "重庆市";
$areanames{zh}->{86133681} = "重庆市";
$areanames{zh}->{86133682} = "重庆市";
$areanames{zh}->{86133683} = "重庆市";
$areanames{zh}->{86133684} = "重庆市";
$areanames{zh}->{861336850} = "贵州省贵阳市";
$areanames{zh}->{861336851} = "贵州省贵阳市";
$areanames{zh}->{861336852} = "贵州省遵义市";
$areanames{zh}->{861336853} = "贵州省安顺市";
$areanames{zh}->{861336854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861336855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861336856} = "贵州省铜仁地区";
$areanames{zh}->{861336857} = "贵州省毕节地区";
$areanames{zh}->{861336858} = "贵州省六盘水市";
$areanames{zh}->{861336859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861336860} = "贵州省贵阳市";
$areanames{zh}->{861336861} = "贵州省贵阳市";
$areanames{zh}->{861336862} = "贵州省遵义市";
$areanames{zh}->{861336863} = "贵州省安顺市";
$areanames{zh}->{861336864} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861336865} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861336866} = "贵州省遵义市";
$areanames{zh}->{861336867} = "贵州省毕节地区";
$areanames{zh}->{861336868} = "贵州省六盘水市";
$areanames{zh}->{861336869} = "贵州省贵阳市";
$areanames{zh}->{861336870} = "云南省昭通市";
$areanames{zh}->{861336871} = "云南省昆明市";
$areanames{zh}->{861336872} = "云南省大理白族自治州";
$areanames{zh}->{861336873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861336874} = "云南省曲靖市";
$areanames{zh}->{861336875} = "云南省保山市";
$areanames{zh}->{861336876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861336877} = "云南省玉溪市";
$areanames{zh}->{861336878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861336879} = "云南省普洱市";
$areanames{zh}->{861336880} = "云南省昆明市";
$areanames{zh}->{861336881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861336882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861336883} = "云南省临沧市";
$areanames{zh}->{861336884} = "云南省昆明市";
$areanames{zh}->{861336885} = "云南省昆明市";
$areanames{zh}->{861336886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861336887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861336888} = "云南省丽江市";
$areanames{zh}->{861336889} = "云南省玉溪市";
$areanames{zh}->{86133689} = "海南省海口市";
$areanames{zh}->{861336900} = "新疆昌吉回族自治州";
$areanames{zh}->{861336901} = "新疆塔城地区";
$areanames{zh}->{861336902} = "新疆哈密地区";
$areanames{zh}->{861336903} = "新疆和田地区";
$areanames{zh}->{861336904} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336905} = "新疆克拉玛依市";
$areanames{zh}->{861336906} = "新疆阿勒泰地区";
$areanames{zh}->{861336907} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336908} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861336909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{86133691} = "陕西省渭南市";
$areanames{zh}->{861336910} = "陕西省咸阳市";
$areanames{zh}->{861336911} = "陕西省咸阳市";
$areanames{zh}->{861336912} = "陕西省咸阳市";
$areanames{zh}->{861336919} = "陕西省宝鸡市";
$areanames{zh}->{861336920} = "陕西省宝鸡市";
$areanames{zh}->{861336921} = "陕西省宝鸡市";
$areanames{zh}->{861336922} = "陕西省汉中市";
$areanames{zh}->{861336923} = "陕西省汉中市";
$areanames{zh}->{861336924} = "陕西省汉中市";
$areanames{zh}->{861336925} = "陕西省汉中市";
$areanames{zh}->{861336926} = "陕西省延安市";
$areanames{zh}->{861336927} = "陕西省延安市";
$areanames{zh}->{861336928} = "陕西省延安市";
$areanames{zh}->{861336929} = "陕西省延安市";
$areanames{zh}->{861336930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861336931} = "甘肃省兰州市";
$areanames{zh}->{861336932} = "甘肃省定西市";
$areanames{zh}->{861336933} = "甘肃省平凉市";
$areanames{zh}->{861336934} = "甘肃省庆阳市";
$areanames{zh}->{861336935} = "甘肃省武威市";
$areanames{zh}->{861336936} = "甘肃省张掖市";
$areanames{zh}->{861336937} = "甘肃省酒泉市";
$areanames{zh}->{861336938} = "甘肃省天水市";
$areanames{zh}->{861336939} = "甘肃省陇南市";
$areanames{zh}->{86133694} = "甘肃省兰州市";
$areanames{zh}->{861336940} = "甘肃省武威市";
$areanames{zh}->{861336941} = "甘肃省天水市";
$areanames{zh}->{861336942} = "甘肃省庆阳市";
$areanames{zh}->{861336947} = "甘肃省酒泉市";
$areanames{zh}->{861336950} = "宁夏银川市";
$areanames{zh}->{861336951} = "宁夏银川市";
$areanames{zh}->{861336952} = "宁夏石嘴山市";
$areanames{zh}->{861336953} = "宁夏吴忠市";
$areanames{zh}->{861336954} = "宁夏固原市";
$areanames{zh}->{861336955} = "宁夏中卫市";
$areanames{zh}->{861336956} = "宁夏石嘴山市";
$areanames{zh}->{861336957} = "宁夏银川市";
$areanames{zh}->{861336958} = "宁夏银川市";
$areanames{zh}->{861336959} = "宁夏银川市";
$areanames{zh}->{86133696} = "新疆乌鲁木齐市";
$areanames{zh}->{861336970} = "青海省海北藏族自治州";
$areanames{zh}->{861336971} = "青海省西宁市";
$areanames{zh}->{861336972} = "青海省海东地区";
$areanames{zh}->{861336973} = "青海省黄南藏族自治州";
$areanames{zh}->{861336974} = "青海省海南藏族自治州";
$areanames{zh}->{861336975} = "青海省海东地区";
$areanames{zh}->{861336976} = "青海省西宁市";
$areanames{zh}->{861336977} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861336978} = "青海省西宁市";
$areanames{zh}->{861336979} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861336980} = "新疆昌吉回族自治州";
$areanames{zh}->{861336981} = "新疆石河子市";
$areanames{zh}->{861336982} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336983} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861336984} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861336985} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336986} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336987} = "新疆阿克苏地区";
$areanames{zh}->{861336988} = "新疆阿克苏地区";
$areanames{zh}->{861336989} = "新疆喀什地区";
$areanames{zh}->{861336990} = "新疆克拉玛依市";
$areanames{zh}->{861336991} = "新疆乌鲁木齐市";
$areanames{zh}->{861336992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861336993} = "新疆石河子市";
$areanames{zh}->{861336994} = "新疆昌吉回族自治州";
$areanames{zh}->{861336995} = "新疆吐鲁番地区";
$areanames{zh}->{861336996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861336997} = "新疆阿克苏地区";
$areanames{zh}->{861336998} = "新疆喀什地区";
$areanames{zh}->{861336999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{86133700} = "上海市";
$areanames{zh}->{86133701} = "北京市";
$areanames{zh}->{86133702} = "上海市";
$areanames{zh}->{86133703} = "天津市";
$areanames{zh}->{86133704} = "天津市";
$areanames{zh}->{86133705} = "山东省济南市";
$areanames{zh}->{861337060} = "山东省泰安市";
$areanames{zh}->{861337061} = "山东省泰安市";
$areanames{zh}->{861337062} = "山东省泰安市";
$areanames{zh}->{861337063} = "山东省日照市";
$areanames{zh}->{861337064} = "山东省日照市";
$areanames{zh}->{861337065} = "山东省临沂市";
$areanames{zh}->{861337066} = "山东省临沂市";
$areanames{zh}->{861337067} = "山东省淄博市";
$areanames{zh}->{861337068} = "山东省淄博市";
$areanames{zh}->{861337069} = "山东省淄博市";
$areanames{zh}->{86133707} = "重庆市";
$areanames{zh}->{86133708} = "山东省青岛市";
$areanames{zh}->{861337090} = "山东省威海市";
$areanames{zh}->{861337091} = "山东省烟台市";
$areanames{zh}->{861337092} = "山东省烟台市";
$areanames{zh}->{861337093} = "山东省烟台市";
$areanames{zh}->{861337094} = "山东省烟台市";
$areanames{zh}->{861337095} = "山东省聊城市";
$areanames{zh}->{861337096} = "山东省聊城市";
$areanames{zh}->{861337097} = "山东省聊城市";
$areanames{zh}->{861337098} = "山东省枣庄市";
$areanames{zh}->{861337099} = "山东省枣庄市";
$areanames{zh}->{86133710} = "山东省潍坊市";
$areanames{zh}->{861337100} = "山东省泰安市";
$areanames{zh}->{861337101} = "山东省泰安市";
$areanames{zh}->{861337102} = "山东省泰安市";
$areanames{zh}->{861337103} = "山东省泰安市";
$areanames{zh}->{86133711} = "山东省威海市";
$areanames{zh}->{861337110} = "山东省枣庄市";
$areanames{zh}->{861337111} = "山东省枣庄市";
$areanames{zh}->{861337112} = "山东省枣庄市";
$areanames{zh}->{861337113} = "山东省枣庄市";
$areanames{zh}->{86133712} = "山东省济宁市";
$areanames{zh}->{861337126} = "山东省临沂市";
$areanames{zh}->{861337127} = "山东省临沂市";
$areanames{zh}->{861337128} = "山东省临沂市";
$areanames{zh}->{861337129} = "山东省临沂市";
$areanames{zh}->{861337130} = "山东省滨州市";
$areanames{zh}->{861337131} = "山东省滨州市";
$areanames{zh}->{861337132} = "山东省滨州市";
$areanames{zh}->{861337133} = "山东省滨州市";
$areanames{zh}->{861337134} = "山东省滨州市";
$areanames{zh}->{861337135} = "山东省烟台市";
$areanames{zh}->{861337136} = "山东省烟台市";
$areanames{zh}->{861337137} = "山东省烟台市";
$areanames{zh}->{861337138} = "山东省烟台市";
$areanames{zh}->{861337139} = "山东省烟台市";
$areanames{zh}->{861337140} = "山东省淄博市";
$areanames{zh}->{861337141} = "山东省东营市";
$areanames{zh}->{861337142} = "山东省枣庄市";
$areanames{zh}->{861337143} = "山东省枣庄市";
$areanames{zh}->{861337144} = "山东省潍坊市";
$areanames{zh}->{861337145} = "山东省潍坊市";
$areanames{zh}->{861337146} = "山东省聊城市";
$areanames{zh}->{861337147} = "山东省聊城市";
$areanames{zh}->{861337148} = "山东省青岛市";
$areanames{zh}->{861337149} = "山东省青岛市";
$areanames{zh}->{86133715} = "山东省东营市";
$areanames{zh}->{861337156} = "山东省淄博市";
$areanames{zh}->{861337157} = "山东省淄博市";
$areanames{zh}->{861337158} = "山东省淄博市";
$areanames{zh}->{861337159} = "山东省淄博市";
$areanames{zh}->{86133716} = "北京市";
$areanames{zh}->{86133717} = "北京市";
$areanames{zh}->{86133718} = "上海市";
$areanames{zh}->{86133719} = "上海市";
$areanames{zh}->{861337200} = "江苏省南京市";
$areanames{zh}->{861337201} = "江苏省南京市";
$areanames{zh}->{861337202} = "江苏省南京市";
$areanames{zh}->{861337203} = "江苏省南京市";
$areanames{zh}->{861337204} = "江苏省宿迁市";
$areanames{zh}->{861337205} = "江苏省宿迁市";
$areanames{zh}->{861337206} = "江苏省宿迁市";
$areanames{zh}->{861337207} = "江苏省南通市";
$areanames{zh}->{861337208} = "江苏省南通市";
$areanames{zh}->{861337209} = "江苏省南通市";
$areanames{zh}->{86133721} = "江苏省苏州市";
$areanames{zh}->{861337219} = "江苏省常州市";
$areanames{zh}->{86133722} = "江苏省常州市";
$areanames{zh}->{861337220} = "江苏省徐州市";
$areanames{zh}->{861337221} = "江苏省徐州市";
$areanames{zh}->{861337222} = "江苏省徐州市";
$areanames{zh}->{861337223} = "江苏省徐州市";
$areanames{zh}->{861337230} = "浙江省嘉兴市";
$areanames{zh}->{861337231} = "浙江省嘉兴市";
$areanames{zh}->{861337232} = "浙江省嘉兴市";
$areanames{zh}->{861337233} = "浙江省嘉兴市";
$areanames{zh}->{861337234} = "浙江省台州市";
$areanames{zh}->{861337235} = "浙江省台州市";
$areanames{zh}->{861337236} = "浙江省台州市";
$areanames{zh}->{861337237} = "浙江省台州市";
$areanames{zh}->{861337238} = "浙江省丽水市";
$areanames{zh}->{861337239} = "浙江省丽水市";
$areanames{zh}->{861337240} = "浙江省杭州市";
$areanames{zh}->{861337241} = "浙江省杭州市";
$areanames{zh}->{861337242} = "浙江省衢州市";
$areanames{zh}->{861337243} = "浙江省嘉兴市";
$areanames{zh}->{861337244} = "浙江省宁波市";
$areanames{zh}->{861337245} = "浙江省宁波市";
$areanames{zh}->{861337246} = "浙江省温州市";
$areanames{zh}->{861337247} = "浙江省温州市";
$areanames{zh}->{861337248} = "浙江省丽水市";
$areanames{zh}->{861337249} = "浙江省金华市";
$areanames{zh}->{86133725} = "浙江省杭州市";
$areanames{zh}->{861337258} = "浙江省衢州市";
$areanames{zh}->{861337259} = "浙江省舟山市";
$areanames{zh}->{86133726} = "重庆市";
$areanames{zh}->{86133727} = "重庆市";
$areanames{zh}->{861337280} = "辽宁省铁岭市";
$areanames{zh}->{861337281} = "辽宁省盘锦市";
$areanames{zh}->{861337282} = "辽宁省沈阳市";
$areanames{zh}->{861337283} = "辽宁省沈阳市";
$areanames{zh}->{861337284} = "辽宁省抚顺市";
$areanames{zh}->{861337285} = "辽宁省鞍山市";
$areanames{zh}->{861337286} = "辽宁省大连市";
$areanames{zh}->{861337287} = "辽宁省大连市";
$areanames{zh}->{861337288} = "辽宁省本溪市";
$areanames{zh}->{861337289} = "辽宁省本溪市";
$areanames{zh}->{861337290} = "辽宁省葫芦岛市";
$areanames{zh}->{861337291} = "辽宁省盘锦市";
$areanames{zh}->{861337292} = "辽宁省朝阳市";
$areanames{zh}->{861337293} = "辽宁省铁岭市";
$areanames{zh}->{861337294} = "辽宁省辽阳市";
$areanames{zh}->{861337295} = "辽宁省阜新市";
$areanames{zh}->{861337296} = "辽宁省营口市";
$areanames{zh}->{861337297} = "辽宁省锦州市";
$areanames{zh}->{861337298} = "辽宁省丹东市";
$areanames{zh}->{861337299} = "辽宁省丹东市";
$areanames{zh}->{861337300} = "河北省邯郸市";
$areanames{zh}->{861337301} = "河北省石家庄市";
$areanames{zh}->{861337302} = "河北省保定市";
$areanames{zh}->{861337303} = "河北省张家口市";
$areanames{zh}->{861337304} = "河北省石家庄市";
$areanames{zh}->{861337305} = "河北省唐山市";
$areanames{zh}->{861337306} = "河北省廊坊市";
$areanames{zh}->{861337307} = "河北省沧州市";
$areanames{zh}->{861337308} = "河北省衡水市";
$areanames{zh}->{861337309} = "河北省邢台市";
$areanames{zh}->{861337310} = "河北省邯郸市";
$areanames{zh}->{861337311} = "河北省石家庄市";
$areanames{zh}->{861337312} = "河北省保定市";
$areanames{zh}->{861337313} = "河北省张家口市";
$areanames{zh}->{861337314} = "河北省承德市";
$areanames{zh}->{861337315} = "河北省唐山市";
$areanames{zh}->{861337316} = "河北省廊坊市";
$areanames{zh}->{861337317} = "河北省沧州市";
$areanames{zh}->{861337318} = "河北省衡水市";
$areanames{zh}->{861337319} = "河北省邢台市";
$areanames{zh}->{861337320} = "河北省邯郸市";
$areanames{zh}->{861337321} = "河北省石家庄市";
$areanames{zh}->{861337322} = "河北省保定市";
$areanames{zh}->{861337323} = "河北省沧州市";
$areanames{zh}->{861337324} = "河北省保定市";
$areanames{zh}->{861337325} = "河北省唐山市";
$areanames{zh}->{861337326} = "河北省廊坊市";
$areanames{zh}->{861337327} = "河北省秦皇岛市";
$areanames{zh}->{861337328} = "河北省秦皇岛市";
$areanames{zh}->{861337329} = "河北省唐山市";
$areanames{zh}->{861337330} = "河北省邯郸市";
$areanames{zh}->{861337331} = "河北省石家庄市";
$areanames{zh}->{861337332} = "河北省保定市";
$areanames{zh}->{861337333} = "河北省张家口市";
$areanames{zh}->{861337334} = "河北省石家庄市";
$areanames{zh}->{861337335} = "河北省秦皇岛市";
$areanames{zh}->{861337336} = "河北省廊坊市";
$areanames{zh}->{861337337} = "河北省沧州市";
$areanames{zh}->{861337338} = "河北省衡水市";
$areanames{zh}->{861337339} = "河北省邢台市";
$areanames{zh}->{861337340} = "河北省邯郸市";
$areanames{zh}->{861337341} = "河北省石家庄市";
$areanames{zh}->{861337342} = "河北省保定市";
$areanames{zh}->{861337343} = "河北省张家口市";
$areanames{zh}->{861337344} = "河北省秦皇岛市";
$areanames{zh}->{861337345} = "河北省唐山市";
$areanames{zh}->{861337346} = "河北省廊坊市";
$areanames{zh}->{861337347} = "河北省沧州市";
$areanames{zh}->{861337348} = "河北省衡水市";
$areanames{zh}->{861337349} = "河北省邢台市";
$areanames{zh}->{861337350} = "河北省邯郸市";
$areanames{zh}->{861337351} = "河北省石家庄市";
$areanames{zh}->{861337352} = "河北省保定市";
$areanames{zh}->{861337353} = "河北省沧州市";
$areanames{zh}->{861337354} = "河北省保定市";
$areanames{zh}->{861337355} = "河北省唐山市";
$areanames{zh}->{861337356} = "河北省廊坊市";
$areanames{zh}->{861337357} = "河北省唐山市";
$areanames{zh}->{861337358} = "河北省承德市";
$areanames{zh}->{861337359} = "河北省唐山市";
$areanames{zh}->{86133736} = "江苏省无锡市";
$areanames{zh}->{861337367} = "江苏省扬州市";
$areanames{zh}->{861337368} = "江苏省扬州市";
$areanames{zh}->{861337369} = "江苏省扬州市";
$areanames{zh}->{861337370} = "河南省安阳市";
$areanames{zh}->{861337371} = "河南省安阳市";
$areanames{zh}->{861337372} = "河南省安阳市";
$areanames{zh}->{861337373} = "河南省新乡市";
$areanames{zh}->{861337374} = "河南省新乡市";
$areanames{zh}->{861337375} = "河南省新乡市";
$areanames{zh}->{861337376} = "河南省新乡市";
$areanames{zh}->{861337377} = "河南省洛阳市";
$areanames{zh}->{861337378} = "河南省洛阳市";
$areanames{zh}->{861337379} = "河南省洛阳市";
$areanames{zh}->{861337380} = "浙江省金华市";
$areanames{zh}->{861337381} = "浙江省金华市";
$areanames{zh}->{861337382} = "浙江省金华市";
$areanames{zh}->{861337383} = "浙江省金华市";
$areanames{zh}->{861337384} = "浙江省金华市";
$areanames{zh}->{861337385} = "浙江省温州市";
$areanames{zh}->{861337386} = "浙江省温州市";
$areanames{zh}->{861337387} = "浙江省宁波市";
$areanames{zh}->{861337388} = "浙江省宁波市";
$areanames{zh}->{861337389} = "浙江省宁波市";
$areanames{zh}->{86133739} = "河南省郑州市";
$areanames{zh}->{861337396} = "河南省三门峡市";
$areanames{zh}->{861337397} = "河南省三门峡市";
$areanames{zh}->{861337398} = "河南省三门峡市";
$areanames{zh}->{861337399} = "河南省三门峡市";
$areanames{zh}->{8613374} = "山西省太原市";
$areanames{zh}->{861337500} = "福建省福州市";
$areanames{zh}->{861337501} = "福建省南平市";
$areanames{zh}->{861337502} = "福建省南平市";
$areanames{zh}->{861337503} = "福建省漳州市";
$areanames{zh}->{861337504} = "福建省龙岩市";
$areanames{zh}->{861337505} = "福建省莆田市";
$areanames{zh}->{861337506} = "福建省莆田市";
$areanames{zh}->{861337507} = "福建省三明市";
$areanames{zh}->{861337508} = "福建省龙岩市";
$areanames{zh}->{861337509} = "福建省龙岩市";
$areanames{zh}->{861337510} = "江苏省徐州市";
$areanames{zh}->{861337511} = "江苏省徐州市";
$areanames{zh}->{861337512} = "江苏省徐州市";
$areanames{zh}->{861337513} = "江苏省徐州市";
$areanames{zh}->{861337514} = "江苏省徐州市";
$areanames{zh}->{861337515} = "江苏省苏州市";
$areanames{zh}->{861337516} = "江苏省苏州市";
$areanames{zh}->{861337517} = "江苏省苏州市";
$areanames{zh}->{861337518} = "江苏省苏州市";
$areanames{zh}->{861337519} = "江苏省苏州市";
$areanames{zh}->{861337520} = "江苏省淮安市";
$areanames{zh}->{861337521} = "江苏省淮安市";
$areanames{zh}->{861337522} = "江苏省淮安市";
$areanames{zh}->{861337523} = "江苏省盐城市";
$areanames{zh}->{861337524} = "江苏省盐城市";
$areanames{zh}->{861337525} = "江苏省盐城市";
$areanames{zh}->{861337526} = "江苏省盐城市";
$areanames{zh}->{861337527} = "江苏省扬州市";
$areanames{zh}->{861337528} = "江苏省扬州市";
$areanames{zh}->{861337529} = "江苏省扬州市";
$areanames{zh}->{861337530} = "山东省菏泽市";
$areanames{zh}->{861337531} = "山东省济南市";
$areanames{zh}->{861337532} = "山东省青岛市";
$areanames{zh}->{861337533} = "山东省淄博市";
$areanames{zh}->{861337534} = "山东省德州市";
$areanames{zh}->{861337535} = "山东省烟台市";
$areanames{zh}->{861337536} = "山东省潍坊市";
$areanames{zh}->{861337537} = "山东省济宁市";
$areanames{zh}->{861337538} = "山东省泰安市";
$areanames{zh}->{861337539} = "山东省临沂市";
$areanames{zh}->{861337540} = "山东省菏泽市";
$areanames{zh}->{861337541} = "山东省济南市";
$areanames{zh}->{861337542} = "山东省青岛市";
$areanames{zh}->{861337543} = "山东省滨州市";
$areanames{zh}->{861337544} = "山东省德州市";
$areanames{zh}->{861337545} = "山东省烟台市";
$areanames{zh}->{861337546} = "山东省东营市";
$areanames{zh}->{861337547} = "山东省济宁市";
$areanames{zh}->{861337548} = "山东省泰安市";
$areanames{zh}->{861337549} = "山东省临沂市";
$areanames{zh}->{861337550} = "山东省德州市";
$areanames{zh}->{861337551} = "山东省德州市";
$areanames{zh}->{861337552} = "山东省日照市";
$areanames{zh}->{861337553} = "山东省日照市";
$areanames{zh}->{861337554} = "山东省日照市";
$areanames{zh}->{861337555} = "山东省青岛市";
$areanames{zh}->{861337556} = "山东省青岛市";
$areanames{zh}->{861337557} = "山东省青岛市";
$areanames{zh}->{861337558} = "山东省青岛市";
$areanames{zh}->{861337559} = "山东省淄博市";
$areanames{zh}->{861337560} = "山东省聊城市";
$areanames{zh}->{861337561} = "山东省聊城市";
$areanames{zh}->{861337562} = "山东省泰安市";
$areanames{zh}->{861337563} = "山东省泰安市";
$areanames{zh}->{861337564} = "山东省枣庄市";
$areanames{zh}->{861337565} = "山东省枣庄市";
$areanames{zh}->{861337566} = "山东省枣庄市";
$areanames{zh}->{861337567} = "山东省枣庄市";
$areanames{zh}->{861337568} = "山东省临沂市";
$areanames{zh}->{861337569} = "山东省临沂市";
$areanames{zh}->{861337570} = "浙江省衢州市";
$areanames{zh}->{861337571} = "浙江省杭州市";
$areanames{zh}->{861337572} = "浙江省湖州市";
$areanames{zh}->{861337573} = "浙江省嘉兴市";
$areanames{zh}->{861337574} = "浙江省宁波市";
$areanames{zh}->{861337575} = "浙江省绍兴市";
$areanames{zh}->{861337576} = "浙江省台州市";
$areanames{zh}->{861337577} = "浙江省温州市";
$areanames{zh}->{861337578} = "浙江省丽水市";
$areanames{zh}->{861337579} = "浙江省金华市";
$areanames{zh}->{861337580} = "浙江省舟山市";
$areanames{zh}->{861337581} = "浙江省杭州市";
$areanames{zh}->{861337582} = "浙江省湖州市";
$areanames{zh}->{861337583} = "浙江省嘉兴市";
$areanames{zh}->{861337584} = "浙江省宁波市";
$areanames{zh}->{861337585} = "浙江省绍兴市";
$areanames{zh}->{861337586} = "浙江省台州市";
$areanames{zh}->{861337587} = "浙江省温州市";
$areanames{zh}->{861337588} = "浙江省丽水市";
$areanames{zh}->{861337589} = "浙江省金华市";
$areanames{zh}->{861337590} = "福建省三明市";
$areanames{zh}->{861337591} = "福建省福州市";
$areanames{zh}->{861337592} = "福建省厦门市";
$areanames{zh}->{861337593} = "福建省宁德市";
$areanames{zh}->{861337594} = "福建省莆田市";
$areanames{zh}->{861337595} = "福建省泉州市";
$areanames{zh}->{861337596} = "福建省漳州市";
$areanames{zh}->{861337597} = "福建省三明市";
$areanames{zh}->{861337598} = "福建省福州市";
$areanames{zh}->{861337599} = "福建省泉州市";
$areanames{zh}->{861337600} = "江苏省泰州市";
$areanames{zh}->{861337601} = "江苏省泰州市";
$areanames{zh}->{861337602} = "江苏省泰州市";
$areanames{zh}->{861337603} = "江苏省泰州市";
$areanames{zh}->{861337604} = "江苏省镇江市";
$areanames{zh}->{861337605} = "江苏省南京市";
$areanames{zh}->{861337606} = "江苏省南京市";
$areanames{zh}->{861337607} = "江苏省南京市";
$areanames{zh}->{861337608} = "江苏省南京市";
$areanames{zh}->{861337609} = "江苏省南京市";
$areanames{zh}->{86133761} = "江苏省镇江市";
$areanames{zh}->{861337610} = "江苏省南通市";
$areanames{zh}->{861337611} = "江苏省南通市";
$areanames{zh}->{861337612} = "江苏省南通市";
$areanames{zh}->{861337613} = "江苏省南通市";
$areanames{zh}->{861337620} = "江苏省无锡市";
$areanames{zh}->{861337621} = "江苏省无锡市";
$areanames{zh}->{861337622} = "江苏省无锡市";
$areanames{zh}->{861337623} = "江苏省无锡市";
$areanames{zh}->{861337624} = "江苏省无锡市";
$areanames{zh}->{861337625} = "江苏省常州市";
$areanames{zh}->{861337626} = "江苏省常州市";
$areanames{zh}->{861337627} = "江苏省常州市";
$areanames{zh}->{861337628} = "江苏省常州市";
$areanames{zh}->{861337629} = "江苏省常州市";
$areanames{zh}->{861337630} = "山东省威海市";
$areanames{zh}->{861337631} = "山东省威海市";
$areanames{zh}->{861337632} = "山东省枣庄市";
$areanames{zh}->{861337633} = "山东省日照市";
$areanames{zh}->{861337634} = "山东省莱芜市";
$areanames{zh}->{861337635} = "山东省聊城市";
$areanames{zh}->{861337636} = "山东省潍坊市";
$areanames{zh}->{861337637} = "山东省枣庄市";
$areanames{zh}->{861337638} = "山东省烟台市";
$areanames{zh}->{861337639} = "山东省青岛市";
$areanames{zh}->{861337640} = "山东省济南市";
$areanames{zh}->{861337641} = "山东省济南市";
$areanames{zh}->{861337642} = "山东省青岛市";
$areanames{zh}->{861337643} = "山东省淄博市";
$areanames{zh}->{861337644} = "山东省济南市";
$areanames{zh}->{861337645} = "山东省烟台市";
$areanames{zh}->{861337646} = "山东省潍坊市";
$areanames{zh}->{861337647} = "山东省东营市";
$areanames{zh}->{861337648} = "山东省青岛市";
$areanames{zh}->{861337649} = "山东省滨州市";
$areanames{zh}->{861337650} = "广东省梅州市";
$areanames{zh}->{861337651} = "广东省揭阳市";
$areanames{zh}->{861337652} = "广东省揭阳市";
$areanames{zh}->{861337653} = "广东省揭阳市";
$areanames{zh}->{861337654} = "广东省揭阳市";
$areanames{zh}->{861337655} = "广东省肇庆市";
$areanames{zh}->{861337656} = "广东省肇庆市";
$areanames{zh}->{861337657} = "广东省肇庆市";
$areanames{zh}->{861337658} = "广东省韶关市";
$areanames{zh}->{861337659} = "广东省韶关市";
$areanames{zh}->{861337660} = "广东省汕尾市";
$areanames{zh}->{861337661} = "广东省汕头市";
$areanames{zh}->{861337662} = "广东省阳江市";
$areanames{zh}->{861337663} = "广东省揭阳市";
$areanames{zh}->{861337664} = "广东省汕尾市";
$areanames{zh}->{861337665} = "广东省清远市";
$areanames{zh}->{861337666} = "广东省清远市";
$areanames{zh}->{861337667} = "广东省清远市";
$areanames{zh}->{861337668} = "广东省茂名市";
$areanames{zh}->{861337669} = "广东省茂名市";
$areanames{zh}->{861337670} = "广东省湛江市";
$areanames{zh}->{861337671} = "广东省湛江市";
$areanames{zh}->{861337672} = "广东省湛江市";
$areanames{zh}->{861337673} = "广东省潮州市";
$areanames{zh}->{861337674} = "广东省潮州市";
$areanames{zh}->{861337675} = "广东省潮州市";
$areanames{zh}->{861337676} = "广东省潮州市";
$areanames{zh}->{861337677} = "广东省河源市";
$areanames{zh}->{861337678} = "广东省河源市";
$areanames{zh}->{861337679} = "广东省汕头市";
$areanames{zh}->{861337680} = "浙江省舟山市";
$areanames{zh}->{861337681} = "浙江省杭州市";
$areanames{zh}->{861337682} = "浙江省杭州市";
$areanames{zh}->{861337683} = "浙江省杭州市";
$areanames{zh}->{861337684} = "浙江省丽水市";
$areanames{zh}->{861337685} = "浙江省衢州市";
$areanames{zh}->{861337686} = "浙江省台州市";
$areanames{zh}->{861337687} = "浙江省温州市";
$areanames{zh}->{861337688} = "浙江省宁波市";
$areanames{zh}->{861337689} = "浙江省金华市";
$areanames{zh}->{861337690} = "福建省漳州市";
$areanames{zh}->{861337691} = "福建省漳州市";
$areanames{zh}->{861337692} = "福建省厦门市";
$areanames{zh}->{861337693} = "福建省宁德市";
$areanames{zh}->{861337694} = "福建省宁德市";
$areanames{zh}->{861337695} = "福建省莆田市";
$areanames{zh}->{861337696} = "福建省泉州市";
$areanames{zh}->{861337697} = "福建省宁德市";
$areanames{zh}->{861337698} = "福建省厦门市";
$areanames{zh}->{861337699} = "福建省福州市";
$areanames{zh}->{86133770} = "广西南宁市";
$areanames{zh}->{861337702} = "广西柳州市";
$areanames{zh}->{861337703} = "广西贺州市";
$areanames{zh}->{861337706} = "广西桂林市";
$areanames{zh}->{861337707} = "广西柳州市";
$areanames{zh}->{86133771} = "广西南宁市";
$areanames{zh}->{861337710} = "广西防城港市";
$areanames{zh}->{861337720} = "广西柳州市";
$areanames{zh}->{861337721} = "广西柳州市";
$areanames{zh}->{861337722} = "广西柳州市";
$areanames{zh}->{861337723} = "广西柳州市";
$areanames{zh}->{861337724} = "广西来宾市";
$areanames{zh}->{861337725} = "广西玉林市";
$areanames{zh}->{861337726} = "广西百色市";
$areanames{zh}->{861337727} = "广西钦州市";
$areanames{zh}->{861337728} = "广西来宾市";
$areanames{zh}->{861337729} = "广西北海市";
$areanames{zh}->{861337730} = "广西桂林市";
$areanames{zh}->{861337731} = "广西桂林市";
$areanames{zh}->{861337732} = "广西桂林市";
$areanames{zh}->{861337733} = "广西桂林市";
$areanames{zh}->{861337734} = "广西桂林市";
$areanames{zh}->{861337735} = "广西玉林市";
$areanames{zh}->{861337736} = "广西贵港市";
$areanames{zh}->{861337737} = "广西钦州市";
$areanames{zh}->{861337738} = "广西河池市";
$areanames{zh}->{861337739} = "广西北海市";
$areanames{zh}->{861337740} = "广西来宾市";
$areanames{zh}->{861337741} = "广西梧州市";
$areanames{zh}->{861337742} = "广西来宾市";
$areanames{zh}->{861337743} = "广西玉林市";
$areanames{zh}->{861337744} = "广西梧州市";
$areanames{zh}->{861337745} = "广西玉林市";
$areanames{zh}->{861337746} = "广西百色市";
$areanames{zh}->{861337747} = "广西百色市";
$areanames{zh}->{861337748} = "广西河池市";
$areanames{zh}->{861337749} = "广西河池市";
$areanames{zh}->{861337750} = "广东省江门市";
$areanames{zh}->{861337751} = "广东省韶关市";
$areanames{zh}->{861337752} = "广东省惠州市";
$areanames{zh}->{861337753} = "广东省梅州市";
$areanames{zh}->{861337754} = "广东省汕头市";
$areanames{zh}->{861337755} = "广东省深圳市";
$areanames{zh}->{861337756} = "广东省珠海市";
$areanames{zh}->{861337757} = "广东省佛山市";
$areanames{zh}->{861337758} = "广东省肇庆市";
$areanames{zh}->{861337759} = "广东省湛江市";
$areanames{zh}->{861337760} = "广东省中山市";
$areanames{zh}->{861337761} = "广东省河源市";
$areanames{zh}->{861337762} = "广东省河源市";
$areanames{zh}->{861337763} = "广东省清远市";
$areanames{zh}->{861337764} = "广东省深圳市";
$areanames{zh}->{861337765} = "广东省佛山市";
$areanames{zh}->{861337766} = "广东省云浮市";
$areanames{zh}->{861337767} = "广东省深圳市";
$areanames{zh}->{861337768} = "广东省潮州市";
$areanames{zh}->{861337769} = "广东省东莞市";
$areanames{zh}->{86133777} = "广东省东莞市";
$areanames{zh}->{861337780} = "湖北省鄂州市";
$areanames{zh}->{861337781} = "湖北省随州市";
$areanames{zh}->{861337782} = "湖北省十堰市";
$areanames{zh}->{861337783} = "湖北省孝感市";
$areanames{zh}->{861337784} = "湖北省咸宁市";
$areanames{zh}->{861337785} = "湖北省武汉市";
$areanames{zh}->{861337786} = "湖北省武汉市";
$areanames{zh}->{861337787} = "湖北省武汉市";
$areanames{zh}->{861337788} = "湖北省武汉市";
$areanames{zh}->{861337789} = "湖北省武汉市";
$areanames{zh}->{861337790} = "湖北省荆州市";
$areanames{zh}->{861337791} = "湖北省黄石市";
$areanames{zh}->{861337792} = "湖北省黄冈市";
$areanames{zh}->{861337793} = "湖北省仙桃市";
$areanames{zh}->{861337794} = "湖北省武汉市";
$areanames{zh}->{861337795} = "湖北省武汉市";
$areanames{zh}->{861337796} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861337797} = "湖北省襄樊市";
$areanames{zh}->{861337798} = "湖北省宜昌市";
$areanames{zh}->{861337799} = "湖北省荆门市";
$areanames{zh}->{861337800} = "湖南省岳阳市";
$areanames{zh}->{861337801} = "湖南省长沙市";
$areanames{zh}->{861337802} = "湖南省湘潭市";
$areanames{zh}->{861337803} = "湖南省株洲市";
$areanames{zh}->{861337804} = "湖南省衡阳市";
$areanames{zh}->{861337805} = "湖南省郴州市";
$areanames{zh}->{861337806} = "湖南省常德市";
$areanames{zh}->{861337807} = "湖南省益阳市";
$areanames{zh}->{861337808} = "湖南省株洲市";
$areanames{zh}->{861337809} = "湖南省邵阳市";
$areanames{zh}->{861337810} = "四川省成都市";
$areanames{zh}->{861337811} = "四川省成都市";
$areanames{zh}->{861337812} = "四川省成都市";
$areanames{zh}->{861337813} = "四川省德阳市";
$areanames{zh}->{861337814} = "四川省德阳市";
$areanames{zh}->{861337815} = "四川省绵阳市";
$areanames{zh}->{861337816} = "四川省绵阳市";
$areanames{zh}->{861337817} = "四川省广元市";
$areanames{zh}->{861337818} = "四川省南充市";
$areanames{zh}->{861337819} = "四川省达州市";
$areanames{zh}->{861337820} = "四川省达州市";
$areanames{zh}->{861337821} = "四川省遂宁市";
$areanames{zh}->{861337822} = "四川省广安市";
$areanames{zh}->{861337823} = "四川省巴中市";
$areanames{zh}->{861337824} = "四川省南充市";
$areanames{zh}->{861337825} = "四川省泸州市";
$areanames{zh}->{861337826} = "四川省泸州市";
$areanames{zh}->{861337827} = "四川省宜宾市";
$areanames{zh}->{861337828} = "四川省宜宾市";
$areanames{zh}->{861337829} = "四川省内江市";
$areanames{zh}->{861337830} = "四川省内江市";
$areanames{zh}->{861337831} = "四川省资阳市";
$areanames{zh}->{861337832} = "四川省自贡市";
$areanames{zh}->{861337833} = "四川省乐山市";
$areanames{zh}->{861337834} = "四川省乐山市";
$areanames{zh}->{861337835} = "四川省眉山市";
$areanames{zh}->{861337836} = "四川省眉山市";
$areanames{zh}->{861337837} = "四川省凉山彝族自治州";
$areanames{zh}->{861337838} = "四川省雅安市";
$areanames{zh}->{861337839} = "四川省攀枝花市";
$areanames{zh}->{861337840} = "广东省深圳市";
$areanames{zh}->{861337841} = "广东省深圳市";
$areanames{zh}->{861337842} = "广东省深圳市";
$areanames{zh}->{861337843} = "广东省深圳市";
$areanames{zh}->{861337844} = "广东省广州市";
$areanames{zh}->{861337845} = "广东省广州市";
$areanames{zh}->{861337846} = "广东省广州市";
$areanames{zh}->{861337847} = "广东省佛山市";
$areanames{zh}->{861337848} = "广东省佛山市";
$areanames{zh}->{861337849} = "广东省东莞市";
$areanames{zh}->{861337850} = "贵州省贵阳市";
$areanames{zh}->{861337851} = "贵州省贵阳市";
$areanames{zh}->{861337852} = "贵州省遵义市";
$areanames{zh}->{861337853} = "贵州省安顺市";
$areanames{zh}->{861337854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861337855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861337856} = "贵州省铜仁地区";
$areanames{zh}->{861337857} = "贵州省毕节地区";
$areanames{zh}->{861337858} = "贵州省六盘水市";
$areanames{zh}->{861337859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861337860} = "广东省东莞市";
$areanames{zh}->{861337861} = "广东省东莞市";
$areanames{zh}->{861337862} = "广东省佛山市";
$areanames{zh}->{861337863} = "广东省佛山市";
$areanames{zh}->{861337864} = "广东省佛山市";
$areanames{zh}->{861337865} = "广东省深圳市";
$areanames{zh}->{861337866} = "广东省深圳市";
$areanames{zh}->{861337867} = "广东省广州市";
$areanames{zh}->{861337868} = "广东省广州市";
$areanames{zh}->{861337869} = "广东省广州市";
$areanames{zh}->{861337870} = "云南省昭通市";
$areanames{zh}->{861337871} = "云南省昆明市";
$areanames{zh}->{861337872} = "云南省大理白族自治州";
$areanames{zh}->{861337873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861337874} = "云南省曲靖市";
$areanames{zh}->{861337875} = "云南省保山市";
$areanames{zh}->{861337876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861337877} = "云南省玉溪市";
$areanames{zh}->{861337878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861337879} = "云南省普洱市";
$areanames{zh}->{861337880} = "云南省昆明市";
$areanames{zh}->{861337881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861337882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861337883} = "云南省临沧市";
$areanames{zh}->{861337884} = "云南省昆明市";
$areanames{zh}->{861337885} = "云南省昆明市";
$areanames{zh}->{861337886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861337887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861337888} = "云南省丽江市";
$areanames{zh}->{861337889} = "云南省玉溪市";
$areanames{zh}->{861337890} = "湖南省岳阳市";
$areanames{zh}->{861337891} = "湖南省长沙市";
$areanames{zh}->{861337892} = "湖南省怀化市";
$areanames{zh}->{861337893} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861337894} = "湖南省衡阳市";
$areanames{zh}->{861337895} = "湖南省怀化市";
$areanames{zh}->{861337896} = "湖南省永州市";
$areanames{zh}->{861337897} = "湖南省张家界市";
$areanames{zh}->{861337898} = "湖南省娄底市";
$areanames{zh}->{861337899} = "湖南省邵阳市";
$areanames{zh}->{86133790} = "陕西省西安市";
$areanames{zh}->{861337910} = "陕西省咸阳市";
$areanames{zh}->{861337911} = "陕西省延安市";
$areanames{zh}->{861337912} = "陕西省榆林市";
$areanames{zh}->{861337913} = "陕西省渭南市";
$areanames{zh}->{861337914} = "陕西省商洛市";
$areanames{zh}->{861337915} = "陕西省安康市";
$areanames{zh}->{861337916} = "陕西省汉中市";
$areanames{zh}->{861337917} = "陕西省宝鸡市";
$areanames{zh}->{861337918} = "陕西省西安市";
$areanames{zh}->{861337919} = "陕西省铜川市";
$areanames{zh}->{86133792} = "陕西省西安市";
$areanames{zh}->{861337930} = "陕西省咸阳市";
$areanames{zh}->{861337931} = "陕西省延安市";
$areanames{zh}->{861337932} = "陕西省榆林市";
$areanames{zh}->{861337933} = "陕西省渭南市";
$areanames{zh}->{861337934} = "陕西省渭南市";
$areanames{zh}->{861337935} = "陕西省安康市";
$areanames{zh}->{861337936} = "陕西省汉中市";
$areanames{zh}->{861337937} = "陕西省宝鸡市";
$areanames{zh}->{861337938} = "陕西省宝鸡市";
$areanames{zh}->{861337939} = "陕西省榆林市";
$areanames{zh}->{861337940} = "陕西省咸阳市";
$areanames{zh}->{861337941} = "陕西省安康市";
$areanames{zh}->{861337942} = "陕西省榆林市";
$areanames{zh}->{861337943} = "陕西省渭南市";
$areanames{zh}->{861337944} = "陕西省渭南市";
$areanames{zh}->{861337945} = "陕西省安康市";
$areanames{zh}->{861337946} = "陕西省汉中市";
$areanames{zh}->{861337947} = "陕西省宝鸡市";
$areanames{zh}->{861337948} = "陕西省宝鸡市";
$areanames{zh}->{861337949} = "陕西省榆林市";
$areanames{zh}->{861337950} = "陕西省西安市";
$areanames{zh}->{861337951} = "陕西省西安市";
$areanames{zh}->{861337952} = "陕西省咸阳市";
$areanames{zh}->{861337953} = "陕西省延安市";
$areanames{zh}->{861337954} = "陕西省西安市";
$areanames{zh}->{861337955} = "陕西省延安市";
$areanames{zh}->{861337956} = "陕西省榆林市";
$areanames{zh}->{861337957} = "陕西省榆林市";
$areanames{zh}->{861337958} = "陕西省榆林市";
$areanames{zh}->{861337959} = "陕西省安康市";
$areanames{zh}->{861337960} = "贵州省遵义市";
$areanames{zh}->{861337961} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861337962} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861337963} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861337964} = "贵州省铜仁地区";
$areanames{zh}->{861337965} = "贵州省毕节地区";
$areanames{zh}->{861337966} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861337967} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861337968} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861337969} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861337970} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861337971} = "新疆哈密地区";
$areanames{zh}->{861337972} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861337973} = "新疆阿克苏地区";
$areanames{zh}->{861337974} = "新疆喀什地区";
$areanames{zh}->{861337975} = "新疆喀什地区";
$areanames{zh}->{861337976} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861337977} = "新疆乌鲁木齐市";
$areanames{zh}->{861337978} = "新疆乌鲁木齐市";
$areanames{zh}->{861337979} = "新疆乌鲁木齐市";
$areanames{zh}->{86133798} = "海南省海口市";
$areanames{zh}->{86133799} = "海南省海口市";
$areanames{zh}->{86133800} = "广东省广州市";
$areanames{zh}->{86133801} = "广东省东莞市";
$areanames{zh}->{86133802} = "广东省佛山市";
$areanames{zh}->{86133803} = "广东省深圳市";
$areanames{zh}->{861338040} = "广东省汕头市";
$areanames{zh}->{861338041} = "广东省汕头市";
$areanames{zh}->{861338042} = "广东省云浮市";
$areanames{zh}->{861338043} = "广东省云浮市";
$areanames{zh}->{861338044} = "广东省中山市";
$areanames{zh}->{861338045} = "广东省中山市";
$areanames{zh}->{861338046} = "广东省潮州市";
$areanames{zh}->{861338047} = "广东省潮州市";
$areanames{zh}->{861338048} = "广东省汕头市";
$areanames{zh}->{861338049} = "广东省汕头市";
$areanames{zh}->{861338050} = "广东省佛山市";
$areanames{zh}->{861338051} = "广东省佛山市";
$areanames{zh}->{861338052} = "广东省佛山市";
$areanames{zh}->{861338053} = "广东省佛山市";
$areanames{zh}->{861338054} = "广东省佛山市";
$areanames{zh}->{861338055} = "广东省揭阳市";
$areanames{zh}->{861338056} = "广东省揭阳市";
$areanames{zh}->{861338057} = "广东省揭阳市";
$areanames{zh}->{861338058} = "广东省揭阳市";
$areanames{zh}->{861338059} = "广东省揭阳市";
$areanames{zh}->{861338060} = "广东省珠海市";
$areanames{zh}->{861338061} = "广东省珠海市";
$areanames{zh}->{861338062} = "广东省珠海市";
$areanames{zh}->{861338063} = "广东省珠海市";
$areanames{zh}->{861338064} = "广东省珠海市";
$areanames{zh}->{861338065} = "广东省惠州市";
$areanames{zh}->{861338066} = "广东省惠州市";
$areanames{zh}->{861338067} = "广东省惠州市";
$areanames{zh}->{861338068} = "广东省惠州市";
$areanames{zh}->{861338069} = "广东省惠州市";
$areanames{zh}->{861338070} = "广东省清远市";
$areanames{zh}->{861338071} = "广东省清远市";
$areanames{zh}->{861338072} = "广东省韶关市";
$areanames{zh}->{861338073} = "广东省韶关市";
$areanames{zh}->{861338074} = "广东省阳江市";
$areanames{zh}->{861338075} = "广东省肇庆市";
$areanames{zh}->{861338076} = "广东省肇庆市";
$areanames{zh}->{861338077} = "广东省梅州市";
$areanames{zh}->{861338078} = "广东省深圳市";
$areanames{zh}->{861338079} = "广东省深圳市";
$areanames{zh}->{861338080} = "广东省茂名市";
$areanames{zh}->{861338081} = "广东省茂名市";
$areanames{zh}->{861338082} = "广东省茂名市";
$areanames{zh}->{861338083} = "广东省佛山市";
$areanames{zh}->{861338084} = "广东省汕尾市";
$areanames{zh}->{861338085} = "广东省汕尾市";
$areanames{zh}->{861338086} = "广东省阳江市";
$areanames{zh}->{861338087} = "广东省中山市";
$areanames{zh}->{861338088} = "广东省中山市";
$areanames{zh}->{861338089} = "广东省中山市";
$areanames{zh}->{861338090} = "广东省湛江市";
$areanames{zh}->{861338091} = "广东省湛江市";
$areanames{zh}->{861338092} = "广东省河源市";
$areanames{zh}->{861338093} = "广东省河源市";
$areanames{zh}->{861338094} = "广东省河源市";
$areanames{zh}->{861338095} = "广东省江门市";
$areanames{zh}->{861338096} = "广东省江门市";
$areanames{zh}->{861338097} = "广东省江门市";
$areanames{zh}->{861338098} = "广东省江门市";
$areanames{zh}->{861338099} = "广东省江门市";
$areanames{zh}->{86133810} = "北京市";
$areanames{zh}->{86133811} = "北京市";
$areanames{zh}->{86133812} = "北京市";
$areanames{zh}->{86133813} = "北京市";
$areanames{zh}->{86133814} = "北京市";
$areanames{zh}->{86133815} = "上海市";
$areanames{zh}->{86133816} = "上海市";
$areanames{zh}->{86133817} = "上海市";
$areanames{zh}->{86133818} = "上海市";
$areanames{zh}->{86133819} = "上海市";
$areanames{zh}->{86133820} = "江苏省南京市";
$areanames{zh}->{86133821} = "江苏省苏州市";
$areanames{zh}->{86133822} = "江苏省无锡市";
$areanames{zh}->{86133823} = "江苏省南通市";
$areanames{zh}->{861338230} = "江苏省淮安市";
$areanames{zh}->{861338231} = "江苏省淮安市";
$areanames{zh}->{861338232} = "江苏省淮安市";
$areanames{zh}->{861338233} = "江苏省淮安市";
$areanames{zh}->{861338240} = "江苏省南京市";
$areanames{zh}->{861338241} = "江苏省苏州市";
$areanames{zh}->{861338242} = "江苏省无锡市";
$areanames{zh}->{861338243} = "江苏省扬州市";
$areanames{zh}->{861338244} = "江苏省常州市";
$areanames{zh}->{861338245} = "江苏省徐州市";
$areanames{zh}->{861338246} = "江苏省泰州市";
$areanames{zh}->{861338247} = "江苏省盐城市";
$areanames{zh}->{861338248} = "江苏省南通市";
$areanames{zh}->{861338249} = "江苏省镇江市";
$areanames{zh}->{861338250} = "江苏省苏州市";
$areanames{zh}->{861338251} = "江苏省苏州市";
$areanames{zh}->{861338252} = "江苏省苏州市";
$areanames{zh}->{861338253} = "江苏省苏州市";
$areanames{zh}->{861338254} = "江苏省苏州市";
$areanames{zh}->{861338255} = "江苏省泰州市";
$areanames{zh}->{861338256} = "江苏省泰州市";
$areanames{zh}->{861338257} = "江苏省泰州市";
$areanames{zh}->{861338258} = "江苏省泰州市";
$areanames{zh}->{861338259} = "江苏省泰州市";
$areanames{zh}->{861338260} = "江苏省盐城市";
$areanames{zh}->{861338261} = "江苏省盐城市";
$areanames{zh}->{861338262} = "江苏省盐城市";
$areanames{zh}->{861338263} = "江苏省盐城市";
$areanames{zh}->{861338264} = "江苏省盐城市";
$areanames{zh}->{861338265} = "江苏省徐州市";
$areanames{zh}->{861338266} = "江苏省徐州市";
$areanames{zh}->{861338267} = "江苏省徐州市";
$areanames{zh}->{861338268} = "江苏省徐州市";
$areanames{zh}->{861338269} = "江苏省徐州市";
$areanames{zh}->{86133827} = "江苏省扬州市";
$areanames{zh}->{861338276} = "江苏省南京市";
$areanames{zh}->{861338277} = "江苏省南京市";
$areanames{zh}->{861338278} = "江苏省南京市";
$areanames{zh}->{861338279} = "江苏省南京市";
$areanames{zh}->{86133828} = "江苏省常州市";
$areanames{zh}->{861338288} = "江苏省无锡市";
$areanames{zh}->{861338289} = "江苏省无锡市";
$areanames{zh}->{861338290} = "江苏省宿迁市";
$areanames{zh}->{861338291} = "江苏省宿迁市";
$areanames{zh}->{861338292} = "江苏省宿迁市";
$areanames{zh}->{861338293} = "江苏省连云港市";
$areanames{zh}->{861338294} = "江苏省连云港市";
$areanames{zh}->{861338295} = "江苏省连云港市";
$areanames{zh}->{861338296} = "江苏省连云港市";
$areanames{zh}->{861338297} = "江苏省镇江市";
$areanames{zh}->{861338298} = "江苏省镇江市";
$areanames{zh}->{861338299} = "江苏省镇江市";
$areanames{zh}->{861338300} = "河北省邯郸市";
$areanames{zh}->{861338301} = "河北省石家庄市";
$areanames{zh}->{861338302} = "河北省保定市";
$areanames{zh}->{861338303} = "河北省石家庄市";
$areanames{zh}->{861338304} = "河北省石家庄市";
$areanames{zh}->{861338305} = "河北省唐山市";
$areanames{zh}->{861338306} = "河北省沧州市";
$areanames{zh}->{861338307} = "河北省沧州市";
$areanames{zh}->{861338308} = "河北省邯郸市";
$areanames{zh}->{861338309} = "河北省邢台市";
$areanames{zh}->{861338310} = "河北省邯郸市";
$areanames{zh}->{861338311} = "河北省石家庄市";
$areanames{zh}->{861338312} = "河北省保定市";
$areanames{zh}->{861338313} = "河北省张家口市";
$areanames{zh}->{861338314} = "河北省承德市";
$areanames{zh}->{861338315} = "河北省唐山市";
$areanames{zh}->{861338316} = "河北省廊坊市";
$areanames{zh}->{861338317} = "河北省沧州市";
$areanames{zh}->{861338318} = "河北省衡水市";
$areanames{zh}->{861338319} = "河北省邢台市";
$areanames{zh}->{861338320} = "河北省邯郸市";
$areanames{zh}->{861338321} = "河北省石家庄市";
$areanames{zh}->{861338322} = "河北省保定市";
$areanames{zh}->{861338323} = "河北省石家庄市";
$areanames{zh}->{861338324} = "河北省唐山市";
$areanames{zh}->{861338325} = "河北省唐山市";
$areanames{zh}->{861338326} = "河北省保定市";
$areanames{zh}->{861338327} = "河北省秦皇岛市";
$areanames{zh}->{861338328} = "河北省秦皇岛市";
$areanames{zh}->{861338329} = "河北省石家庄市";
$areanames{zh}->{861338330} = "河北省邯郸市";
$areanames{zh}->{861338331} = "河北省石家庄市";
$areanames{zh}->{861338332} = "河北省保定市";
$areanames{zh}->{861338333} = "河北省张家口市";
$areanames{zh}->{861338334} = "河北省唐山市";
$areanames{zh}->{861338335} = "河北省秦皇岛市";
$areanames{zh}->{861338336} = "河北省廊坊市";
$areanames{zh}->{861338337} = "河北省沧州市";
$areanames{zh}->{861338338} = "河北省衡水市";
$areanames{zh}->{861338339} = "河北省邢台市";
$areanames{zh}->{861338340} = "山西省忻州市";
$areanames{zh}->{861338341} = "山西省太原市";
$areanames{zh}->{861338342} = "山西省大同市";
$areanames{zh}->{861338343} = "山西省太原市";
$areanames{zh}->{861338344} = "山西省晋中市";
$areanames{zh}->{861338345} = "山西省长治市";
$areanames{zh}->{861338346} = "山西省晋城市";
$areanames{zh}->{861338347} = "山西省临汾市";
$areanames{zh}->{861338348} = "山西省运城市";
$areanames{zh}->{861338349} = "山西省朔州市";
$areanames{zh}->{861338350} = "山西省忻州市";
$areanames{zh}->{861338351} = "山西省太原市";
$areanames{zh}->{861338352} = "山西省大同市";
$areanames{zh}->{861338353} = "山西省阳泉市";
$areanames{zh}->{861338354} = "山西省晋中市";
$areanames{zh}->{861338355} = "山西省长治市";
$areanames{zh}->{861338356} = "山西省晋城市";
$areanames{zh}->{861338357} = "山西省临汾市";
$areanames{zh}->{861338358} = "山西省吕梁市";
$areanames{zh}->{861338359} = "山西省运城市";
$areanames{zh}->{861338360} = "河北省秦皇岛市";
$areanames{zh}->{861338361} = "河北省石家庄市";
$areanames{zh}->{861338362} = "河北省保定市";
$areanames{zh}->{861338363} = "河北省张家口市";
$areanames{zh}->{861338364} = "河北省承德市";
$areanames{zh}->{861338365} = "河北省秦皇岛市";
$areanames{zh}->{861338366} = "河北省廊坊市";
$areanames{zh}->{861338367} = "河北省廊坊市";
$areanames{zh}->{861338368} = "河北省衡水市";
$areanames{zh}->{861338369} = "河北省邢台市";
$areanames{zh}->{861338370} = "河南省商丘市";
$areanames{zh}->{861338371} = "河南省郑州市";
$areanames{zh}->{861338372} = "河南省安阳市";
$areanames{zh}->{861338373} = "河南省新乡市";
$areanames{zh}->{861338374} = "河南省许昌市";
$areanames{zh}->{861338375} = "河南省平顶山市";
$areanames{zh}->{861338376} = "河南省信阳市";
$areanames{zh}->{861338377} = "河南省南阳市";
$areanames{zh}->{861338378} = "河南省开封市";
$areanames{zh}->{861338379} = "河南省洛阳市";
$areanames{zh}->{86133838} = "河南省郑州市";
$areanames{zh}->{861338380} = "河南省新乡市";
$areanames{zh}->{861338387} = "河南省洛阳市";
$areanames{zh}->{861338388} = "河南省洛阳市";
$areanames{zh}->{861338389} = "河南省洛阳市";
$areanames{zh}->{861338390} = "河南省平顶山市";
$areanames{zh}->{861338391} = "河南省焦作市";
$areanames{zh}->{861338392} = "河南省鹤壁市";
$areanames{zh}->{861338393} = "河南省濮阳市";
$areanames{zh}->{861338394} = "河南省周口市";
$areanames{zh}->{861338395} = "河南省漯河市";
$areanames{zh}->{861338396} = "河南省驻马店市";
$areanames{zh}->{861338397} = "河南省信阳市";
$areanames{zh}->{861338398} = "河南省三门峡市";
$areanames{zh}->{861338399} = "河南省平顶山市";
$areanames{zh}->{861338400} = "河南省郑州市";
$areanames{zh}->{861338401} = "河南省郑州市";
$areanames{zh}->{861338402} = "河南省郑州市";
$areanames{zh}->{861338403} = "河南省郑州市";
$areanames{zh}->{861338404} = "河南省郑州市";
$areanames{zh}->{861338405} = "河南省平顶山市";
$areanames{zh}->{861338406} = "河南省平顶山市";
$areanames{zh}->{861338407} = "河南省南阳市";
$areanames{zh}->{861338408} = "河南省南阳市";
$areanames{zh}->{861338409} = "河南省焦作市";
$areanames{zh}->{861338410} = "辽宁省铁岭市";
$areanames{zh}->{861338411} = "辽宁省大连市";
$areanames{zh}->{861338412} = "辽宁省鞍山市";
$areanames{zh}->{861338413} = "辽宁省抚顺市";
$areanames{zh}->{861338414} = "辽宁省本溪市";
$areanames{zh}->{861338415} = "辽宁省丹东市";
$areanames{zh}->{861338416} = "辽宁省锦州市";
$areanames{zh}->{861338417} = "辽宁省营口市";
$areanames{zh}->{861338418} = "辽宁省阜新市";
$areanames{zh}->{861338419} = "辽宁省辽阳市";
$areanames{zh}->{861338420} = "辽宁省铁岭市";
$areanames{zh}->{861338421} = "辽宁省朝阳市";
$areanames{zh}->{861338422} = "辽宁省鞍山市";
$areanames{zh}->{861338423} = "辽宁省抚顺市";
$areanames{zh}->{861338424} = "辽宁省本溪市";
$areanames{zh}->{861338425} = "辽宁省丹东市";
$areanames{zh}->{861338426} = "辽宁省锦州市";
$areanames{zh}->{861338427} = "辽宁省盘锦市";
$areanames{zh}->{861338428} = "辽宁省阜新市";
$areanames{zh}->{861338429} = "辽宁省葫芦岛市";
$areanames{zh}->{861338430} = "吉林省长春市";
$areanames{zh}->{861338431} = "吉林省长春市";
$areanames{zh}->{861338432} = "吉林省吉林市";
$areanames{zh}->{861338433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861338434} = "吉林省四平市";
$areanames{zh}->{861338435} = "吉林省通化市";
$areanames{zh}->{861338436} = "吉林省白城市";
$areanames{zh}->{861338437} = "吉林省辽源市";
$areanames{zh}->{861338438} = "吉林省松原市";
$areanames{zh}->{861338439} = "吉林省白山市";
$areanames{zh}->{861338440} = "吉林省吉林市";
$areanames{zh}->{861338441} = "吉林省吉林市";
$areanames{zh}->{861338442} = "吉林省吉林市";
$areanames{zh}->{861338443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861338444} = "吉林省四平市";
$areanames{zh}->{861338445} = "吉林省通化市";
$areanames{zh}->{861338446} = "吉林省白城市";
$areanames{zh}->{861338447} = "吉林省长春市";
$areanames{zh}->{861338448} = "吉林省长春市";
$areanames{zh}->{861338449} = "吉林省长春市";
$areanames{zh}->{861338450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861338453} = "黑龙江省牡丹江市";
$areanames{zh}->{861338454} = "黑龙江省佳木斯市";
$areanames{zh}->{861338455} = "黑龙江省绥化市";
$areanames{zh}->{861338456} = "黑龙江省黑河市";
$areanames{zh}->{861338457} = "黑龙江省大兴安岭地区";
$areanames{zh}->{861338458} = "黑龙江省伊春市";
$areanames{zh}->{861338459} = "黑龙江省大庆市";
$areanames{zh}->{861338460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861338463} = "黑龙江省牡丹江市";
$areanames{zh}->{861338464} = "黑龙江省七台河市";
$areanames{zh}->{861338465} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338466} = "黑龙江省哈尔滨市";
$areanames{zh}->{861338467} = "黑龙江省鸡西市";
$areanames{zh}->{861338468} = "黑龙江省鹤岗市";
$areanames{zh}->{861338469} = "黑龙江省双鸭山市";
$areanames{zh}->{861338470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861338471} = "内蒙古呼和浩特市";
$areanames{zh}->{861338472} = "内蒙古包头市";
$areanames{zh}->{861338473} = "内蒙古乌海市";
$areanames{zh}->{861338474} = "内蒙古兴安盟";
$areanames{zh}->{861338475} = "内蒙古通辽市";
$areanames{zh}->{861338476} = "内蒙古赤峰市";
$areanames{zh}->{861338477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861338478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861338479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861338480} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861338481} = "内蒙古赤峰市";
$areanames{zh}->{861338482} = "内蒙古兴安盟";
$areanames{zh}->{861338483} = "内蒙古阿拉善盟";
$areanames{zh}->{861338484} = "内蒙古包头市";
$areanames{zh}->{861338485} = "内蒙古包头市";
$areanames{zh}->{861338486} = "内蒙古包头市";
$areanames{zh}->{861338487} = "内蒙古呼和浩特市";
$areanames{zh}->{861338488} = "内蒙古呼和浩特市";
$areanames{zh}->{861338489} = "内蒙古呼和浩特市";
$areanames{zh}->{86133849} = "陕西省西安市";
$areanames{zh}->{86133850} = "福建省宁德市";
$areanames{zh}->{861338507} = "福建省三明市";
$areanames{zh}->{861338508} = "福建省三明市";
$areanames{zh}->{861338509} = "福建省三明市";
$areanames{zh}->{861338510} = "贵州省贵阳市";
$areanames{zh}->{861338511} = "贵州省贵阳市";
$areanames{zh}->{861338512} = "贵州省遵义市";
$areanames{zh}->{861338513} = "贵州省安顺市";
$areanames{zh}->{861338514} = "贵州省贵阳市";
$areanames{zh}->{861338515} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861338516} = "贵州省六盘水市";
$areanames{zh}->{861338517} = "贵州省毕节地区";
$areanames{zh}->{861338518} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861338519} = "贵州省遵义市";
$areanames{zh}->{861338520} = "湖北省武汉市";
$areanames{zh}->{861338521} = "湖北省武汉市";
$areanames{zh}->{861338522} = "湖北省仙桃市";
$areanames{zh}->{861338523} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861338524} = "湖北省荆门市";
$areanames{zh}->{861338525} = "湖北省荆门市";
$areanames{zh}->{861338526} = "湖北省黄石市";
$areanames{zh}->{861338527} = "湖北省鄂州市";
$areanames{zh}->{861338528} = "湖北省武汉市";
$areanames{zh}->{861338529} = "湖北省孝感市";
$areanames{zh}->{861338530} = "山东省菏泽市";
$areanames{zh}->{861338531} = "山东省济南市";
$areanames{zh}->{861338532} = "山东省青岛市";
$areanames{zh}->{861338533} = "山东省淄博市";
$areanames{zh}->{861338534} = "山东省德州市";
$areanames{zh}->{861338535} = "山东省烟台市";
$areanames{zh}->{861338536} = "山东省潍坊市";
$areanames{zh}->{861338537} = "山东省济宁市";
$areanames{zh}->{861338538} = "山东省泰安市";
$areanames{zh}->{861338539} = "山东省临沂市";
$areanames{zh}->{861338540} = "山东省菏泽市";
$areanames{zh}->{861338541} = "山东省济南市";
$areanames{zh}->{861338542} = "山东省青岛市";
$areanames{zh}->{861338543} = "山东省滨州市";
$areanames{zh}->{861338544} = "山东省德州市";
$areanames{zh}->{861338545} = "山东省烟台市";
$areanames{zh}->{861338546} = "山东省东营市";
$areanames{zh}->{861338547} = "山东省济宁市";
$areanames{zh}->{861338548} = "山东省泰安市";
$areanames{zh}->{861338549} = "山东省临沂市";
$areanames{zh}->{861338550} = "贵州省贵阳市";
$areanames{zh}->{861338551} = "贵州省贵阳市";
$areanames{zh}->{861338552} = "贵州省遵义市";
$areanames{zh}->{861338553} = "贵州省安顺市";
$areanames{zh}->{861338554} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861338555} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861338556} = "贵州省铜仁地区";
$areanames{zh}->{861338557} = "贵州省毕节地区";
$areanames{zh}->{861338558} = "贵州省六盘水市";
$areanames{zh}->{861338559} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861338560} = "安徽省合肥市";
$areanames{zh}->{861338561} = "安徽省淮北市";
$areanames{zh}->{861338562} = "安徽省铜陵市";
$areanames{zh}->{861338563} = "安徽省宣城市";
$areanames{zh}->{861338564} = "安徽省六安市";
$areanames{zh}->{861338565} = "安徽省巢湖市";
$areanames{zh}->{861338566} = "安徽省池州市";
$areanames{zh}->{861338567} = "安徽省亳州市";
$areanames{zh}->{861338568} = "安徽省六安市";
$areanames{zh}->{861338569} = "安徽省合肥市";
$areanames{zh}->{861338570} = "浙江省衢州市";
$areanames{zh}->{861338571} = "浙江省杭州市";
$areanames{zh}->{861338572} = "浙江省湖州市";
$areanames{zh}->{861338573} = "浙江省嘉兴市";
$areanames{zh}->{861338574} = "浙江省宁波市";
$areanames{zh}->{861338575} = "浙江省绍兴市";
$areanames{zh}->{861338576} = "浙江省台州市";
$areanames{zh}->{861338577} = "浙江省温州市";
$areanames{zh}->{861338578} = "浙江省丽水市";
$areanames{zh}->{861338579} = "浙江省金华市";
$areanames{zh}->{861338580} = "浙江省舟山市";
$areanames{zh}->{861338581} = "浙江省杭州市";
$areanames{zh}->{861338582} = "浙江省湖州市";
$areanames{zh}->{861338583} = "浙江省嘉兴市";
$areanames{zh}->{861338584} = "浙江省宁波市";
$areanames{zh}->{861338585} = "浙江省绍兴市";
$areanames{zh}->{861338586} = "浙江省台州市";
$areanames{zh}->{861338587} = "浙江省温州市";
$areanames{zh}->{861338588} = "浙江省丽水市";
$areanames{zh}->{861338589} = "浙江省金华市";
$areanames{zh}->{861338590} = "福建省龙岩市";
$areanames{zh}->{861338591} = "福建省福州市";
$areanames{zh}->{861338592} = "福建省厦门市";
$areanames{zh}->{861338593} = "福建省宁德市";
$areanames{zh}->{861338594} = "福建省莆田市";
$areanames{zh}->{861338595} = "福建省泉州市";
$areanames{zh}->{861338596} = "福建省漳州市";
$areanames{zh}->{861338597} = "福建省龙岩市";
$areanames{zh}->{861338598} = "福建省三明市";
$areanames{zh}->{861338599} = "福建省南平市";
$areanames{zh}->{86133860} = "上海市";
$areanames{zh}->{86133861} = "上海市";
$areanames{zh}->{86133862} = "上海市";
$areanames{zh}->{861338630} = "山东省威海市";
$areanames{zh}->{861338631} = "山东省威海市";
$areanames{zh}->{861338632} = "山东省枣庄市";
$areanames{zh}->{861338633} = "山东省日照市";
$areanames{zh}->{861338634} = "山东省莱芜市";
$areanames{zh}->{861338635} = "山东省聊城市";
$areanames{zh}->{861338636} = "山东省潍坊市";
$areanames{zh}->{861338637} = "山东省枣庄市";
$areanames{zh}->{861338638} = "山东省烟台市";
$areanames{zh}->{861338639} = "山东省青岛市";
$areanames{zh}->{861338640} = "山东省济南市";
$areanames{zh}->{861338641} = "山东省济南市";
$areanames{zh}->{861338642} = "山东省青岛市";
$areanames{zh}->{861338643} = "山东省淄博市";
$areanames{zh}->{861338644} = "山东省济南市";
$areanames{zh}->{861338645} = "山东省烟台市";
$areanames{zh}->{861338646} = "山东省潍坊市";
$areanames{zh}->{861338647} = "山东省东营市";
$areanames{zh}->{861338648} = "山东省青岛市";
$areanames{zh}->{861338649} = "山东省滨州市";
$areanames{zh}->{86133865} = "浙江省台州市";
$areanames{zh}->{861338650} = "浙江省杭州市";
$areanames{zh}->{861338651} = "浙江省杭州市";
$areanames{zh}->{861338652} = "浙江省杭州市";
$areanames{zh}->{861338653} = "浙江省杭州市";
$areanames{zh}->{86133866} = "浙江省宁波市";
$areanames{zh}->{861338668} = "浙江省舟山市";
$areanames{zh}->{861338669} = "浙江省舟山市";
$areanames{zh}->{86133867} = "辽宁省鞍山市";
$areanames{zh}->{861338670} = "辽宁省本溪市";
$areanames{zh}->{861338671} = "辽宁省营口市";
$areanames{zh}->{861338672} = "辽宁省葫芦岛市";
$areanames{zh}->{861338673} = "辽宁省葫芦岛市";
$areanames{zh}->{86133868} = "辽宁省沈阳市";
$areanames{zh}->{861338680} = "辽宁省盘锦市";
$areanames{zh}->{861338681} = "辽宁省盘锦市";
$areanames{zh}->{861338690} = "福建省莆田市";
$areanames{zh}->{861338691} = "福建省莆田市";
$areanames{zh}->{861338692} = "福建省莆田市";
$areanames{zh}->{861338693} = "福建省龙岩市";
$areanames{zh}->{861338694} = "福建省漳州市";
$areanames{zh}->{861338695} = "福建省漳州市";
$areanames{zh}->{861338696} = "福建省漳州市";
$areanames{zh}->{861338697} = "福建省漳州市";
$areanames{zh}->{861338698} = "福建省南平市";
$areanames{zh}->{861338699} = "福建省南平市";
$areanames{zh}->{861338700} = "江西省南昌市";
$areanames{zh}->{861338701} = "江西省鹰潭市";
$areanames{zh}->{861338702} = "江西省九江市";
$areanames{zh}->{861338703} = "江西省上饶市";
$areanames{zh}->{861338704} = "江西省吉安市";
$areanames{zh}->{861338705} = "江西省宜春市";
$areanames{zh}->{861338706} = "江西省抚州市";
$areanames{zh}->{861338707} = "江西省赣州市";
$areanames{zh}->{861338708} = "江西省南昌市";
$areanames{zh}->{861338709} = "江西省南昌市";
$areanames{zh}->{861338710} = "湖北省黄石市";
$areanames{zh}->{861338711} = "湖北省黄冈市";
$areanames{zh}->{861338712} = "湖北省黄冈市";
$areanames{zh}->{861338713} = "湖北省十堰市";
$areanames{zh}->{861338714} = "湖北省十堰市";
$areanames{zh}->{861338715} = "湖北省十堰市";
$areanames{zh}->{861338716} = "湖北省咸宁市";
$areanames{zh}->{861338717} = "湖北省咸宁市";
$areanames{zh}->{861338718} = "湖北省荆州市";
$areanames{zh}->{861338719} = "湖北省荆州市";
$areanames{zh}->{861338720} = "湖北省荆州市";
$areanames{zh}->{861338721} = "湖北省襄樊市";
$areanames{zh}->{861338722} = "湖北省襄樊市";
$areanames{zh}->{861338723} = "湖北省襄樊市";
$areanames{zh}->{861338724} = "湖北省襄樊市";
$areanames{zh}->{861338725} = "湖北省宜昌市";
$areanames{zh}->{861338726} = "湖北省宜昌市";
$areanames{zh}->{861338727} = "湖北省宜昌市";
$areanames{zh}->{861338728} = "湖北省宜昌市";
$areanames{zh}->{861338729} = "湖北省随州市";
$areanames{zh}->{861338730} = "湖南省岳阳市";
$areanames{zh}->{861338731} = "湖南省长沙市";
$areanames{zh}->{861338732} = "湖南省湘潭市";
$areanames{zh}->{861338733} = "湖南省株洲市";
$areanames{zh}->{861338734} = "湖南省衡阳市";
$areanames{zh}->{861338735} = "湖南省郴州市";
$areanames{zh}->{861338736} = "湖南省常德市";
$areanames{zh}->{861338737} = "湖南省益阳市";
$areanames{zh}->{861338738} = "湖南省娄底市";
$areanames{zh}->{861338739} = "湖南省邵阳市";
$areanames{zh}->{861338740} = "湖南省岳阳市";
$areanames{zh}->{861338741} = "湖南省株洲市";
$areanames{zh}->{861338742} = "湖南省常德市";
$areanames{zh}->{861338743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861338744} = "湖南省张家界市";
$areanames{zh}->{861338745} = "湖南省怀化市";
$areanames{zh}->{861338746} = "湖南省永州市";
$areanames{zh}->{861338747} = "湖南省衡阳市";
$areanames{zh}->{861338748} = "湖南省长沙市";
$areanames{zh}->{861338749} = "湖南省长沙市";
$areanames{zh}->{86133875} = "湖北省武汉市";
$areanames{zh}->{86133876} = "湖北省武汉市";
$areanames{zh}->{861338767} = "湖北省孝感市";
$areanames{zh}->{861338768} = "湖北省荆州市";
$areanames{zh}->{861338769} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861338770} = "广西防城港市";
$areanames{zh}->{861338771} = "广西南宁市";
$areanames{zh}->{861338772} = "广西柳州市";
$areanames{zh}->{861338773} = "广西桂林市";
$areanames{zh}->{861338774} = "广西贺州市";
$areanames{zh}->{861338775} = "广西玉林市";
$areanames{zh}->{861338776} = "广西百色市";
$areanames{zh}->{861338777} = "广西钦州市";
$areanames{zh}->{861338778} = "广西河池市";
$areanames{zh}->{861338779} = "广西北海市";
$areanames{zh}->{86133878} = "辽宁省大连市";
$areanames{zh}->{861338780} = "辽宁省辽阳市";
$areanames{zh}->{861338781} = "辽宁省辽阳市";
$areanames{zh}->{861338782} = "辽宁省朝阳市";
$areanames{zh}->{861338790} = "江西省新余市";
$areanames{zh}->{861338791} = "江西省南昌市";
$areanames{zh}->{861338792} = "江西省九江市";
$areanames{zh}->{861338793} = "江西省上饶市";
$areanames{zh}->{861338794} = "江西省抚州市";
$areanames{zh}->{861338795} = "江西省宜春市";
$areanames{zh}->{861338796} = "江西省吉安市";
$areanames{zh}->{861338797} = "江西省赣州市";
$areanames{zh}->{861338798} = "江西省景德镇市";
$areanames{zh}->{861338799} = "江西省萍乡市";
$areanames{zh}->{86133880} = "天津市";
$areanames{zh}->{861338810} = "四川省绵阳市";
$areanames{zh}->{861338811} = "四川省绵阳市";
$areanames{zh}->{861338812} = "四川省德阳市";
$areanames{zh}->{861338813} = "四川省德阳市";
$areanames{zh}->{861338814} = "四川省广安市";
$areanames{zh}->{861338815} = "四川省广安市";
$areanames{zh}->{861338816} = "四川省成都市";
$areanames{zh}->{861338817} = "四川省成都市";
$areanames{zh}->{861338818} = "四川省成都市";
$areanames{zh}->{861338819} = "四川省成都市";
$areanames{zh}->{861338820} = "四川省达州市";
$areanames{zh}->{861338821} = "四川省达州市";
$areanames{zh}->{861338822} = "四川省南充市";
$areanames{zh}->{861338823} = "四川省南充市";
$areanames{zh}->{861338824} = "四川省眉山市";
$areanames{zh}->{861338825} = "四川省眉山市";
$areanames{zh}->{861338826} = "四川省乐山市";
$areanames{zh}->{861338827} = "四川省乐山市";
$areanames{zh}->{861338828} = "四川省泸州市";
$areanames{zh}->{861338829} = "四川省泸州市";
$areanames{zh}->{861338830} = "四川省资阳市";
$areanames{zh}->{861338831} = "四川省攀枝花市";
$areanames{zh}->{861338832} = "四川省自贡市";
$areanames{zh}->{861338833} = "四川省自贡市";
$areanames{zh}->{861338834} = "四川省雅安市";
$areanames{zh}->{861338835} = "四川省遂宁市";
$areanames{zh}->{861338836} = "四川省内江市";
$areanames{zh}->{861338837} = "四川省内江市";
$areanames{zh}->{861338838} = "四川省宜宾市";
$areanames{zh}->{861338839} = "四川省宜宾市";
$areanames{zh}->{861338840} = "浙江省衢州市";
$areanames{zh}->{861338841} = "浙江省湖州市";
$areanames{zh}->{861338842} = "浙江省杭州市";
$areanames{zh}->{861338843} = "浙江省杭州市";
$areanames{zh}->{861338844} = "浙江省舟山市";
$areanames{zh}->{861338845} = "浙江省金华市";
$areanames{zh}->{861338846} = "浙江省金华市";
$areanames{zh}->{861338847} = "浙江省丽水市";
$areanames{zh}->{861338848} = "浙江省丽水市";
$areanames{zh}->{861338849} = "浙江省绍兴市";
$areanames{zh}->{86133885} = "浙江省温州市";
$areanames{zh}->{861338850} = "浙江省衢州市";
$areanames{zh}->{861338860} = "浙江省杭州市";
$areanames{zh}->{861338861} = "浙江省杭州市";
$areanames{zh}->{861338862} = "浙江省嘉兴市";
$areanames{zh}->{861338863} = "浙江省嘉兴市";
$areanames{zh}->{861338864} = "浙江省嘉兴市";
$areanames{zh}->{861338865} = "浙江省金华市";
$areanames{zh}->{861338866} = "浙江省金华市";
$areanames{zh}->{861338867} = "浙江省绍兴市";
$areanames{zh}->{861338868} = "浙江省绍兴市";
$areanames{zh}->{861338869} = "浙江省湖州市";
$areanames{zh}->{861338870} = "云南省昭通市";
$areanames{zh}->{861338871} = "云南省昆明市";
$areanames{zh}->{861338872} = "云南省大理白族自治州";
$areanames{zh}->{861338873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861338874} = "云南省曲靖市";
$areanames{zh}->{861338875} = "云南省保山市";
$areanames{zh}->{861338876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861338877} = "云南省玉溪市";
$areanames{zh}->{861338878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861338879} = "云南省普洱市";
$areanames{zh}->{861338880} = "云南省昆明市";
$areanames{zh}->{861338881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861338882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861338883} = "云南省临沧市";
$areanames{zh}->{861338884} = "云南省昆明市";
$areanames{zh}->{861338885} = "云南省昆明市";
$areanames{zh}->{861338886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861338887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861338888} = "云南省丽江市";
$areanames{zh}->{861338889} = "云南省玉溪市";
$areanames{zh}->{86133889} = "重庆市";
$areanames{zh}->{86133890} = "天津市";
$areanames{zh}->{861338910} = "陕西省咸阳市";
$areanames{zh}->{861338911} = "陕西省延安市";
$areanames{zh}->{861338912} = "陕西省榆林市";
$areanames{zh}->{861338913} = "陕西省渭南市";
$areanames{zh}->{861338914} = "陕西省商洛市";
$areanames{zh}->{861338915} = "陕西省安康市";
$areanames{zh}->{861338916} = "陕西省汉中市";
$areanames{zh}->{861338917} = "陕西省宝鸡市";
$areanames{zh}->{861338918} = "陕西省西安市";
$areanames{zh}->{861338919} = "陕西省铜川市";
$areanames{zh}->{86133892} = "陕西省西安市";
$areanames{zh}->{861338930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861338931} = "甘肃省兰州市";
$areanames{zh}->{861338932} = "甘肃省定西市";
$areanames{zh}->{861338933} = "甘肃省兰州市";
$areanames{zh}->{861338934} = "甘肃省庆阳市";
$areanames{zh}->{861338935} = "甘肃省武威市";
$areanames{zh}->{861338936} = "甘肃省兰州市";
$areanames{zh}->{861338937} = "甘肃省酒泉市";
$areanames{zh}->{861338938} = "甘肃省天水市";
$areanames{zh}->{861338939} = "甘肃省陇南市";
$areanames{zh}->{861338940} = "甘肃省兰州市";
$areanames{zh}->{861338941} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861338942} = "甘肃省定西市";
$areanames{zh}->{861338943} = "甘肃省酒泉市";
$areanames{zh}->{861338944} = "甘肃省兰州市";
$areanames{zh}->{861338945} = "甘肃省金昌市";
$areanames{zh}->{861338946} = "甘肃省庆阳市";
$areanames{zh}->{861338947} = "甘肃省酒泉市";
$areanames{zh}->{861338948} = "甘肃省天水市";
$areanames{zh}->{861338949} = "甘肃省陇南市";
$areanames{zh}->{861338950} = "宁夏银川市";
$areanames{zh}->{861338951} = "宁夏银川市";
$areanames{zh}->{861338952} = "宁夏石嘴山市";
$areanames{zh}->{861338953} = "宁夏吴忠市";
$areanames{zh}->{861338954} = "宁夏固原市";
$areanames{zh}->{861338955} = "宁夏中卫市";
$areanames{zh}->{861338956} = "宁夏中卫市";
$areanames{zh}->{861338957} = "宁夏吴忠市";
$areanames{zh}->{861338958} = "宁夏银川市";
$areanames{zh}->{861338959} = "宁夏固原市";
$areanames{zh}->{86133896} = "重庆市";
$areanames{zh}->{861338970} = "青海省海北藏族自治州";
$areanames{zh}->{861338971} = "青海省西宁市";
$areanames{zh}->{861338972} = "青海省海东地区";
$areanames{zh}->{861338973} = "青海省黄南藏族自治州";
$areanames{zh}->{861338974} = "青海省海南藏族自治州";
$areanames{zh}->{861338975} = "青海省西宁市";
$areanames{zh}->{861338976} = "青海省玉树藏族自治州";
$areanames{zh}->{861338977} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{861338978} = "青海省西宁市";
$areanames{zh}->{861338979} = "青海省海西蒙古族藏族自治州";
$areanames{zh}->{86133898} = "海南省海口市";
$areanames{zh}->{86133899} = "天津市";
$areanames{zh}->{86133900} = "辽宁省大连市";
$areanames{zh}->{861339007} = "辽宁省鞍山市";
$areanames{zh}->{861339008} = "辽宁省鞍山市";
$areanames{zh}->{861339009} = "辽宁省鞍山市";
$areanames{zh}->{86133901} = "辽宁省沈阳市";
$areanames{zh}->{861339017} = "辽宁省本溪市";
$areanames{zh}->{861339018} = "辽宁省本溪市";
$areanames{zh}->{861339019} = "辽宁省本溪市";
$areanames{zh}->{861339020} = "辽宁省锦州市";
$areanames{zh}->{861339021} = "辽宁省锦州市";
$areanames{zh}->{861339022} = "辽宁省锦州市";
$areanames{zh}->{861339023} = "辽宁省辽阳市";
$areanames{zh}->{861339024} = "辽宁省沈阳市";
$areanames{zh}->{861339025} = "辽宁省营口市";
$areanames{zh}->{861339026} = "辽宁省营口市";
$areanames{zh}->{861339027} = "辽宁省盘锦市";
$areanames{zh}->{861339028} = "辽宁省铁岭市";
$areanames{zh}->{861339029} = "辽宁省葫芦岛市";
$areanames{zh}->{861339030} = "辽宁省鞍山市";
$areanames{zh}->{861339031} = "辽宁省鞍山市";
$areanames{zh}->{861339032} = "辽宁省鞍山市";
$areanames{zh}->{861339033} = "辽宁省鞍山市";
$areanames{zh}->{861339034} = "辽宁省鞍山市";
$areanames{zh}->{861339035} = "辽宁省本溪市";
$areanames{zh}->{861339036} = "辽宁省丹东市";
$areanames{zh}->{861339037} = "辽宁省锦州市";
$areanames{zh}->{861339038} = "辽宁省盘锦市";
$areanames{zh}->{861339039} = "辽宁省朝阳市";
$areanames{zh}->{861339040} = "辽宁省铁岭市";
$areanames{zh}->{861339041} = "辽宁省盘锦市";
$areanames{zh}->{861339042} = "辽宁省葫芦岛市";
$areanames{zh}->{861339043} = "辽宁省抚顺市";
$areanames{zh}->{861339044} = "辽宁省本溪市";
$areanames{zh}->{861339045} = "辽宁省丹东市";
$areanames{zh}->{861339046} = "辽宁省锦州市";
$areanames{zh}->{861339047} = "辽宁省营口市";
$areanames{zh}->{861339048} = "辽宁省阜新市";
$areanames{zh}->{861339049} = "辽宁省辽阳市";
$areanames{zh}->{861339050} = "辽宁省大连市";
$areanames{zh}->{861339051} = "辽宁省大连市";
$areanames{zh}->{861339052} = "辽宁省大连市";
$areanames{zh}->{861339053} = "辽宁省大连市";
$areanames{zh}->{861339054} = "辽宁省大连市";
$areanames{zh}->{861339055} = "辽宁省沈阳市";
$areanames{zh}->{861339056} = "辽宁省沈阳市";
$areanames{zh}->{861339057} = "辽宁省沈阳市";
$areanames{zh}->{861339058} = "辽宁省沈阳市";
$areanames{zh}->{861339059} = "辽宁省沈阳市";
$areanames{zh}->{86133906} = "江苏省扬州市";
$areanames{zh}->{861339067} = "江苏省盐城市";
$areanames{zh}->{861339068} = "江苏省盐城市";
$areanames{zh}->{861339069} = "江苏省盐城市";
$areanames{zh}->{861339070} = "江苏省盐城市";
$areanames{zh}->{861339071} = "江苏省盐城市";
$areanames{zh}->{861339072} = "江苏省盐城市";
$areanames{zh}->{861339073} = "江苏省盐城市";
$areanames{zh}->{861339074} = "江苏省盐城市";
$areanames{zh}->{861339075} = "江苏省南京市";
$areanames{zh}->{861339076} = "江苏省南京市";
$areanames{zh}->{861339077} = "江苏省南京市";
$areanames{zh}->{861339078} = "江苏省南京市";
$areanames{zh}->{861339079} = "江苏省南京市";
$areanames{zh}->{86133908} = "江苏省苏州市";
$areanames{zh}->{861339080} = "江苏省淮安市";
$areanames{zh}->{861339081} = "江苏省淮安市";
$areanames{zh}->{86133909} = "江苏省南通市";
$areanames{zh}->{861339090} = "江苏省南京市";
$areanames{zh}->{861339091} = "江苏省南京市";
$areanames{zh}->{861339092} = "江苏省南京市";
$areanames{zh}->{86133910} = "上海市";
$areanames{zh}->{86133911} = "上海市";
$areanames{zh}->{86133912} = "上海市";
$areanames{zh}->{86133913} = "上海市";
$areanames{zh}->{86133914} = "上海市";
$areanames{zh}->{86133915} = "北京市";
$areanames{zh}->{86133916} = "北京市";
$areanames{zh}->{86133917} = "北京市";
$areanames{zh}->{86133918} = "北京市";
$areanames{zh}->{86133919} = "北京市";
$areanames{zh}->{861339200} = "广东省惠州市";
$areanames{zh}->{861339201} = "广东省惠州市";
$areanames{zh}->{861339202} = "广东省惠州市";
$areanames{zh}->{861339203} = "广东省惠州市";
$areanames{zh}->{861339204} = "广东省惠州市";
$areanames{zh}->{861339205} = "广东省江门市";
$areanames{zh}->{861339206} = "广东省江门市";
$areanames{zh}->{861339207} = "广东省江门市";
$areanames{zh}->{861339208} = "广东省江门市";
$areanames{zh}->{861339209} = "广东省江门市";
$areanames{zh}->{861339210} = "广东省广州市";
$areanames{zh}->{861339211} = "广东省广州市";
$areanames{zh}->{861339212} = "广东省广州市";
$areanames{zh}->{861339213} = "广东省广州市";
$areanames{zh}->{861339214} = "广东省广州市";
$areanames{zh}->{861339215} = "广东省深圳市";
$areanames{zh}->{861339216} = "广东省深圳市";
$areanames{zh}->{861339217} = "广东省深圳市";
$areanames{zh}->{861339218} = "广东省深圳市";
$areanames{zh}->{861339219} = "广东省深圳市";
$areanames{zh}->{86133922} = "广东省佛山市";
$areanames{zh}->{86133923} = "广东省东莞市";
$areanames{zh}->{861339240} = "广东省深圳市";
$areanames{zh}->{861339241} = "广东省深圳市";
$areanames{zh}->{861339242} = "广东省深圳市";
$areanames{zh}->{861339243} = "广东省深圳市";
$areanames{zh}->{861339244} = "广东省深圳市";
$areanames{zh}->{861339245} = "广东省广州市";
$areanames{zh}->{861339246} = "广东省广州市";
$areanames{zh}->{861339247} = "广东省广州市";
$areanames{zh}->{861339248} = "广东省广州市";
$areanames{zh}->{861339249} = "广东省广州市";
$areanames{zh}->{861339250} = "广东省江门市";
$areanames{zh}->{861339251} = "广东省江门市";
$areanames{zh}->{861339252} = "广东省珠海市";
$areanames{zh}->{861339253} = "广东省珠海市";
$areanames{zh}->{861339254} = "广东省珠海市";
$areanames{zh}->{861339255} = "广东省惠州市";
$areanames{zh}->{861339256} = "广东省惠州市";
$areanames{zh}->{861339257} = "广东省中山市";
$areanames{zh}->{861339258} = "广东省中山市";
$areanames{zh}->{861339259} = "广东省中山市";
$areanames{zh}->{86133926} = "广东省广州市";
$areanames{zh}->{861339270} = "广东省东莞市";
$areanames{zh}->{861339271} = "广东省东莞市";
$areanames{zh}->{861339272} = "广东省东莞市";
$areanames{zh}->{861339273} = "广东省东莞市";
$areanames{zh}->{861339274} = "广东省东莞市";
$areanames{zh}->{861339275} = "广东省佛山市";
$areanames{zh}->{861339276} = "广东省佛山市";
$areanames{zh}->{861339277} = "广东省佛山市";
$areanames{zh}->{861339278} = "广东省佛山市";
$areanames{zh}->{861339279} = "广东省佛山市";
$areanames{zh}->{86133928} = "广东省深圳市";
$areanames{zh}->{861339290} = "广东省中山市";
$areanames{zh}->{861339291} = "广东省中山市";
$areanames{zh}->{861339292} = "广东省中山市";
$areanames{zh}->{861339293} = "广东省中山市";
$areanames{zh}->{861339294} = "广东省中山市";
$areanames{zh}->{861339295} = "广东省珠海市";
$areanames{zh}->{861339296} = "广东省珠海市";
$areanames{zh}->{861339297} = "广东省珠海市";
$areanames{zh}->{861339298} = "广东省珠海市";
$areanames{zh}->{861339299} = "广东省珠海市";
$areanames{zh}->{861339300} = "河北省邯郸市";
$areanames{zh}->{861339301} = "河北省石家庄市";
$areanames{zh}->{861339302} = "河北省保定市";
$areanames{zh}->{861339303} = "河北省石家庄市";
$areanames{zh}->{861339304} = "河北省石家庄市";
$areanames{zh}->{861339305} = "河北省唐山市";
$areanames{zh}->{861339306} = "河北省廊坊市";
$areanames{zh}->{861339307} = "河北省沧州市";
$areanames{zh}->{861339308} = "河北省衡水市";
$areanames{zh}->{861339309} = "河北省邢台市";
$areanames{zh}->{861339310} = "河北省邯郸市";
$areanames{zh}->{861339311} = "河北省石家庄市";
$areanames{zh}->{861339312} = "河北省保定市";
$areanames{zh}->{861339313} = "河北省张家口市";
$areanames{zh}->{861339314} = "河北省承德市";
$areanames{zh}->{861339315} = "河北省唐山市";
$areanames{zh}->{861339316} = "河北省廊坊市";
$areanames{zh}->{861339317} = "河北省沧州市";
$areanames{zh}->{861339318} = "河北省衡水市";
$areanames{zh}->{861339319} = "河北省邢台市";
$areanames{zh}->{861339320} = "河北省秦皇岛市";
$areanames{zh}->{861339321} = "河北省石家庄市";
$areanames{zh}->{861339322} = "河北省保定市";
$areanames{zh}->{861339323} = "河北省石家庄市";
$areanames{zh}->{861339324} = "河北省张家口市";
$areanames{zh}->{861339325} = "河北省唐山市";
$areanames{zh}->{861339326} = "河北省廊坊市";
$areanames{zh}->{861339327} = "河北省沧州市";
$areanames{zh}->{861339328} = "河北省衡水市";
$areanames{zh}->{861339329} = "河北省邢台市";
$areanames{zh}->{861339330} = "河北省秦皇岛市";
$areanames{zh}->{861339331} = "河北省石家庄市";
$areanames{zh}->{861339332} = "河北省保定市";
$areanames{zh}->{861339333} = "河北省张家口市";
$areanames{zh}->{861339334} = "河北省秦皇岛市";
$areanames{zh}->{861339335} = "河北省秦皇岛市";
$areanames{zh}->{861339336} = "河北省廊坊市";
$areanames{zh}->{861339337} = "河北省沧州市";
$areanames{zh}->{861339338} = "河北省沧州市";
$areanames{zh}->{861339339} = "河北省沧州市";
$areanames{zh}->{861339340} = "山西省太原市";
$areanames{zh}->{861339341} = "山西省太原市";
$areanames{zh}->{861339342} = "山西省大同市";
$areanames{zh}->{861339343} = "山西省太原市";
$areanames{zh}->{861339344} = "山西省晋中市";
$areanames{zh}->{861339345} = "山西省长治市";
$areanames{zh}->{861339346} = "山西省晋城市";
$areanames{zh}->{861339347} = "山西省临汾市";
$areanames{zh}->{861339348} = "山西省运城市";
$areanames{zh}->{861339349} = "山西省朔州市";
$areanames{zh}->{861339350} = "山西省忻州市";
$areanames{zh}->{861339351} = "山西省太原市";
$areanames{zh}->{861339352} = "山西省大同市";
$areanames{zh}->{861339353} = "山西省阳泉市";
$areanames{zh}->{861339354} = "山西省晋中市";
$areanames{zh}->{861339355} = "山西省长治市";
$areanames{zh}->{861339356} = "山西省晋城市";
$areanames{zh}->{861339357} = "山西省临汾市";
$areanames{zh}->{861339358} = "山西省吕梁市";
$areanames{zh}->{861339359} = "山西省运城市";
$areanames{zh}->{86133936} = "广西南宁市";
$areanames{zh}->{861339360} = "广西来宾市";
$areanames{zh}->{861339362} = "广西来宾市";
$areanames{zh}->{861339363} = "广西桂林市";
$areanames{zh}->{861339365} = "广西玉林市";
$areanames{zh}->{861339370} = "河南省郑州市";
$areanames{zh}->{861339371} = "河南省郑州市";
$areanames{zh}->{861339372} = "河南省郑州市";
$areanames{zh}->{861339373} = "河南省郑州市";
$areanames{zh}->{861339374} = "河南省郑州市";
$areanames{zh}->{861339375} = "河南省平顶山市";
$areanames{zh}->{861339376} = "河南省平顶山市";
$areanames{zh}->{861339377} = "河南省平顶山市";
$areanames{zh}->{861339378} = "河南省平顶山市";
$areanames{zh}->{861339379} = "河南省平顶山市";
$areanames{zh}->{861339380} = "河南省开封市";
$areanames{zh}->{861339381} = "河南省开封市";
$areanames{zh}->{861339382} = "河南省开封市";
$areanames{zh}->{861339383} = "河南省开封市";
$areanames{zh}->{861339384} = "河南省开封市";
$areanames{zh}->{861339385} = "河南省焦作市";
$areanames{zh}->{861339386} = "河南省焦作市";
$areanames{zh}->{861339387} = "河南省焦作市";
$areanames{zh}->{861339388} = "河南省焦作市";
$areanames{zh}->{861339389} = "河南省焦作市";
$areanames{zh}->{861339390} = "河南省周口市";
$areanames{zh}->{861339391} = "河南省周口市";
$areanames{zh}->{861339392} = "河南省周口市";
$areanames{zh}->{861339393} = "河南省周口市";
$areanames{zh}->{861339394} = "河南省周口市";
$areanames{zh}->{861339395} = "河南省驻马店市";
$areanames{zh}->{861339396} = "河南省驻马店市";
$areanames{zh}->{861339397} = "河南省驻马店市";
$areanames{zh}->{861339398} = "河南省驻马店市";
$areanames{zh}->{861339399} = "河南省驻马店市";
$areanames{zh}->{861339400} = "福建省福州市";
$areanames{zh}->{861339401} = "福建省三明市";
$areanames{zh}->{861339402} = "福建省泉州市";
$areanames{zh}->{861339403} = "福建省漳州市";
$areanames{zh}->{861339404} = "福建省厦门市";
$areanames{zh}->{861339405} = "福建省厦门市";
$areanames{zh}->{861339406} = "福建省厦门市";
$areanames{zh}->{861339407} = "福建省泉州市";
$areanames{zh}->{861339408} = "福建省南平市";
$areanames{zh}->{861339409} = "福建省龙岩市";
$areanames{zh}->{861339410} = "辽宁省铁岭市";
$areanames{zh}->{861339411} = "辽宁省大连市";
$areanames{zh}->{861339412} = "辽宁省鞍山市";
$areanames{zh}->{861339413} = "辽宁省抚顺市";
$areanames{zh}->{861339414} = "辽宁省本溪市";
$areanames{zh}->{861339415} = "辽宁省丹东市";
$areanames{zh}->{861339416} = "辽宁省锦州市";
$areanames{zh}->{861339417} = "辽宁省营口市";
$areanames{zh}->{861339418} = "辽宁省阜新市";
$areanames{zh}->{861339419} = "辽宁省辽阳市";
$areanames{zh}->{861339420} = "辽宁省鞍山市";
$areanames{zh}->{861339421} = "辽宁省朝阳市";
$areanames{zh}->{861339422} = "辽宁省抚顺市";
$areanames{zh}->{861339423} = "辽宁省抚顺市";
$areanames{zh}->{861339424} = "辽宁省朝阳市";
$areanames{zh}->{861339425} = "辽宁省丹东市";
$areanames{zh}->{861339426} = "辽宁省丹东市";
$areanames{zh}->{861339427} = "辽宁省盘锦市";
$areanames{zh}->{861339428} = "辽宁省阜新市";
$areanames{zh}->{861339429} = "辽宁省葫芦岛市";
$areanames{zh}->{861339430} = "吉林省长春市";
$areanames{zh}->{861339431} = "吉林省长春市";
$areanames{zh}->{861339432} = "吉林省吉林市";
$areanames{zh}->{861339433} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861339434} = "吉林省四平市";
$areanames{zh}->{861339435} = "吉林省通化市";
$areanames{zh}->{861339436} = "吉林省白城市";
$areanames{zh}->{861339437} = "吉林省辽源市";
$areanames{zh}->{861339438} = "吉林省松原市";
$areanames{zh}->{861339439} = "吉林省白山市";
$areanames{zh}->{861339440} = "吉林省吉林市";
$areanames{zh}->{861339441} = "吉林省吉林市";
$areanames{zh}->{861339442} = "吉林省吉林市";
$areanames{zh}->{861339443} = "吉林省延边朝鲜族自治州";
$areanames{zh}->{861339444} = "吉林省四平市";
$areanames{zh}->{861339445} = "吉林省通化市";
$areanames{zh}->{861339446} = "吉林省白城市";
$areanames{zh}->{861339447} = "吉林省长春市";
$areanames{zh}->{861339448} = "吉林省长春市";
$areanames{zh}->{861339449} = "吉林省长春市";
$areanames{zh}->{861339450} = "黑龙江省哈尔滨市";
$areanames{zh}->{861339451} = "黑龙江省哈尔滨市";
$areanames{zh}->{861339452} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861339453} = "黑龙江省牡丹江市";
$areanames{zh}->{861339454} = "黑龙江省佳木斯市";
$areanames{zh}->{861339455} = "黑龙江省绥化市";
$areanames{zh}->{861339456} = "黑龙江省黑河市";
$areanames{zh}->{861339457} = "黑龙江省佳木斯市";
$areanames{zh}->{861339458} = "黑龙江省伊春市";
$areanames{zh}->{861339459} = "黑龙江省大庆市";
$areanames{zh}->{861339460} = "黑龙江省哈尔滨市";
$areanames{zh}->{861339461} = "黑龙江省哈尔滨市";
$areanames{zh}->{861339462} = "黑龙江省齐齐哈尔市";
$areanames{zh}->{861339463} = "黑龙江省大庆市";
$areanames{zh}->{861339464} = "黑龙江省大庆市";
$areanames{zh}->{861339465} = "黑龙江省大庆市";
$areanames{zh}->{861339466} = "黑龙江省大庆市";
$areanames{zh}->{861339467} = "黑龙江省鸡西市";
$areanames{zh}->{861339468} = "黑龙江省鹤岗市";
$areanames{zh}->{861339469} = "黑龙江省双鸭山市";
$areanames{zh}->{861339470} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861339471} = "内蒙古呼和浩特市";
$areanames{zh}->{861339472} = "内蒙古包头市";
$areanames{zh}->{861339473} = "内蒙古乌海市";
$areanames{zh}->{861339474} = "内蒙古兴安盟";
$areanames{zh}->{861339475} = "内蒙古通辽市";
$areanames{zh}->{861339476} = "内蒙古赤峰市";
$areanames{zh}->{861339477} = "内蒙古鄂尔多斯市";
$areanames{zh}->{861339478} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861339479} = "内蒙古锡林郭勒盟";
$areanames{zh}->{861339480} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861339481} = "内蒙古呼伦贝尔市";
$areanames{zh}->{861339482} = "内蒙古兴安盟";
$areanames{zh}->{861339483} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861339484} = "内蒙古赤峰市";
$areanames{zh}->{861339485} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861339486} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861339487} = "内蒙古巴彦淖尔市";
$areanames{zh}->{861339488} = "内蒙古兴安盟";
$areanames{zh}->{861339489} = "内蒙古呼和浩特市";
$areanames{zh}->{861339490} = "新疆克孜勒苏柯尔克孜自治州";
$areanames{zh}->{861339491} = "新疆乌鲁木齐市";
$areanames{zh}->{861339492} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861339493} = "新疆石河子市";
$areanames{zh}->{861339494} = "新疆克拉玛依市";
$areanames{zh}->{861339495} = "新疆吐鲁番地区";
$areanames{zh}->{861339496} = "新疆昌吉回族自治州";
$areanames{zh}->{861339497} = "新疆阿克苏地区";
$areanames{zh}->{861339498} = "新疆阿克苏地区";
$areanames{zh}->{861339499} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861339500} = "福建省福州市";
$areanames{zh}->{861339501} = "福建省厦门市";
$areanames{zh}->{861339502} = "福建省厦门市";
$areanames{zh}->{861339503} = "福建省厦门市";
$areanames{zh}->{861339504} = "福建省福州市";
$areanames{zh}->{861339505} = "福建省厦门市";
$areanames{zh}->{861339506} = "福建省泉州市";
$areanames{zh}->{861339507} = "福建省厦门市";
$areanames{zh}->{861339508} = "福建省福州市";
$areanames{zh}->{861339509} = "福建省泉州市";
$areanames{zh}->{86133951} = "江苏省无锡市";
$areanames{zh}->{86133952} = "江苏省徐州市";
$areanames{zh}->{861339520} = "江苏省淮安市";
$areanames{zh}->{861339521} = "江苏省淮安市";
$areanames{zh}->{861339530} = "山东省菏泽市";
$areanames{zh}->{861339531} = "山东省济南市";
$areanames{zh}->{861339532} = "山东省青岛市";
$areanames{zh}->{861339533} = "山东省淄博市";
$areanames{zh}->{861339534} = "山东省德州市";
$areanames{zh}->{861339535} = "山东省烟台市";
$areanames{zh}->{861339536} = "山东省潍坊市";
$areanames{zh}->{861339537} = "山东省济宁市";
$areanames{zh}->{861339538} = "山东省泰安市";
$areanames{zh}->{861339539} = "山东省临沂市";
$areanames{zh}->{861339540} = "山东省菏泽市";
$areanames{zh}->{861339541} = "山东省济南市";
$areanames{zh}->{861339542} = "山东省青岛市";
$areanames{zh}->{861339543} = "山东省滨州市";
$areanames{zh}->{861339544} = "山东省德州市";
$areanames{zh}->{861339545} = "山东省烟台市";
$areanames{zh}->{861339546} = "山东省东营市";
$areanames{zh}->{861339547} = "山东省济宁市";
$areanames{zh}->{861339548} = "山东省泰安市";
$areanames{zh}->{861339549} = "山东省临沂市";
$areanames{zh}->{861339550} = "安徽省滁州市";
$areanames{zh}->{861339551} = "安徽省合肥市";
$areanames{zh}->{861339552} = "安徽省蚌埠市";
$areanames{zh}->{861339553} = "安徽省芜湖市";
$areanames{zh}->{861339554} = "安徽省淮南市";
$areanames{zh}->{861339555} = "安徽省马鞍山市";
$areanames{zh}->{861339556} = "安徽省安庆市";
$areanames{zh}->{861339557} = "安徽省宿州市";
$areanames{zh}->{861339558} = "安徽省阜阳市";
$areanames{zh}->{861339559} = "安徽省黄山市";
$areanames{zh}->{861339560} = "安徽省合肥市";
$areanames{zh}->{861339561} = "安徽省淮北市";
$areanames{zh}->{861339562} = "安徽省铜陵市";
$areanames{zh}->{861339563} = "安徽省宣城市";
$areanames{zh}->{861339564} = "安徽省六安市";
$areanames{zh}->{861339565} = "安徽省巢湖市";
$areanames{zh}->{861339566} = "安徽省池州市";
$areanames{zh}->{861339567} = "安徽省亳州市";
$areanames{zh}->{861339568} = "安徽省六安市";
$areanames{zh}->{861339569} = "安徽省合肥市";
$areanames{zh}->{861339570} = "浙江省衢州市";
$areanames{zh}->{861339571} = "浙江省杭州市";
$areanames{zh}->{861339572} = "浙江省湖州市";
$areanames{zh}->{861339573} = "浙江省嘉兴市";
$areanames{zh}->{861339574} = "浙江省宁波市";
$areanames{zh}->{861339575} = "浙江省绍兴市";
$areanames{zh}->{861339576} = "浙江省台州市";
$areanames{zh}->{861339577} = "浙江省温州市";
$areanames{zh}->{861339578} = "浙江省丽水市";
$areanames{zh}->{861339579} = "浙江省金华市";
$areanames{zh}->{861339580} = "浙江省舟山市";
$areanames{zh}->{861339581} = "浙江省杭州市";
$areanames{zh}->{861339582} = "浙江省湖州市";
$areanames{zh}->{861339583} = "浙江省嘉兴市";
$areanames{zh}->{861339584} = "浙江省宁波市";
$areanames{zh}->{861339585} = "浙江省绍兴市";
$areanames{zh}->{861339586} = "浙江省台州市";
$areanames{zh}->{861339587} = "浙江省温州市";
$areanames{zh}->{861339588} = "浙江省丽水市";
$areanames{zh}->{861339589} = "浙江省金华市";
$areanames{zh}->{861339590} = "福建省福州市";
$areanames{zh}->{861339591} = "福建省福州市";
$areanames{zh}->{861339592} = "福建省南平市";
$areanames{zh}->{861339593} = "福建省宁德市";
$areanames{zh}->{861339594} = "福建省莆田市";
$areanames{zh}->{861339595} = "福建省泉州市";
$areanames{zh}->{861339596} = "福建省漳州市";
$areanames{zh}->{861339597} = "福建省龙岩市";
$areanames{zh}->{861339598} = "福建省三明市";
$areanames{zh}->{861339599} = "福建省厦门市";
$areanames{zh}->{86133960} = "湖北省武汉市";
$areanames{zh}->{861339600} = "湖北省荆州市";
$areanames{zh}->{861339601} = "湖北省仙桃市";
$areanames{zh}->{861339610} = "湖北省襄樊市";
$areanames{zh}->{861339611} = "湖北省襄樊市";
$areanames{zh}->{861339612} = "湖北省襄樊市";
$areanames{zh}->{861339613} = "湖北省咸宁市";
$areanames{zh}->{861339614} = "湖北省宜昌市";
$areanames{zh}->{861339615} = "湖北省宜昌市";
$areanames{zh}->{861339616} = "湖北省荆门市";
$areanames{zh}->{861339617} = "湖北省随州市";
$areanames{zh}->{861339618} = "湖北省孝感市";
$areanames{zh}->{861339619} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861339620} = "山东省菏泽市";
$areanames{zh}->{861339621} = "山东省菏泽市";
$areanames{zh}->{861339622} = "山东省聊城市";
$areanames{zh}->{861339623} = "山东省日照市";
$areanames{zh}->{861339624} = "山东省威海市";
$areanames{zh}->{861339625} = "山东省聊城市";
$areanames{zh}->{861339626} = "山东省德州市";
$areanames{zh}->{861339627} = "山东省德州市";
$areanames{zh}->{861339628} = "山东省滨州市";
$areanames{zh}->{861339629} = "山东省滨州市";
$areanames{zh}->{861339630} = "山东省威海市";
$areanames{zh}->{861339631} = "山东省威海市";
$areanames{zh}->{861339632} = "山东省枣庄市";
$areanames{zh}->{861339633} = "山东省日照市";
$areanames{zh}->{861339634} = "山东省莱芜市";
$areanames{zh}->{861339635} = "山东省聊城市";
$areanames{zh}->{861339636} = "山东省潍坊市";
$areanames{zh}->{861339637} = "山东省枣庄市";
$areanames{zh}->{861339638} = "山东省烟台市";
$areanames{zh}->{861339639} = "山东省青岛市";
$areanames{zh}->{861339640} = "山东省济南市";
$areanames{zh}->{861339641} = "山东省济南市";
$areanames{zh}->{861339642} = "山东省青岛市";
$areanames{zh}->{861339643} = "山东省淄博市";
$areanames{zh}->{861339644} = "山东省济南市";
$areanames{zh}->{861339645} = "山东省烟台市";
$areanames{zh}->{861339646} = "山东省潍坊市";
$areanames{zh}->{861339647} = "山东省东营市";
$areanames{zh}->{861339648} = "山东省青岛市";
$areanames{zh}->{861339649} = "山东省滨州市";
$areanames{zh}->{86133965} = "浙江省杭州市";
$areanames{zh}->{86133966} = "浙江省宁波市";
$areanames{zh}->{861339670} = "浙江省衢州市";
$areanames{zh}->{861339671} = "浙江省杭州市";
$areanames{zh}->{861339672} = "浙江省湖州市";
$areanames{zh}->{861339673} = "浙江省嘉兴市";
$areanames{zh}->{861339674} = "浙江省宁波市";
$areanames{zh}->{861339675} = "浙江省绍兴市";
$areanames{zh}->{861339676} = "浙江省台州市";
$areanames{zh}->{861339677} = "浙江省温州市";
$areanames{zh}->{861339678} = "浙江省丽水市";
$areanames{zh}->{861339679} = "浙江省金华市";
$areanames{zh}->{861339680} = "浙江省舟山市";
$areanames{zh}->{861339681} = "浙江省杭州市";
$areanames{zh}->{861339682} = "浙江省湖州市";
$areanames{zh}->{861339683} = "浙江省嘉兴市";
$areanames{zh}->{861339684} = "浙江省宁波市";
$areanames{zh}->{861339685} = "浙江省绍兴市";
$areanames{zh}->{861339686} = "浙江省台州市";
$areanames{zh}->{861339687} = "浙江省温州市";
$areanames{zh}->{861339688} = "浙江省丽水市";
$areanames{zh}->{861339689} = "浙江省金华市";
$areanames{zh}->{861339690} = "浙江省台州市";
$areanames{zh}->{861339691} = "浙江省台州市";
$areanames{zh}->{861339692} = "浙江省台州市";
$areanames{zh}->{861339693} = "浙江省台州市";
$areanames{zh}->{861339694} = "浙江省台州市";
$areanames{zh}->{861339695} = "浙江省温州市";
$areanames{zh}->{861339696} = "浙江省温州市";
$areanames{zh}->{861339697} = "浙江省温州市";
$areanames{zh}->{861339698} = "浙江省温州市";
$areanames{zh}->{861339699} = "浙江省温州市";
$areanames{zh}->{861339700} = "江西省南昌市";
$areanames{zh}->{861339701} = "江西省鹰潭市";
$areanames{zh}->{861339702} = "江西省抚州市";
$areanames{zh}->{861339703} = "江西省上饶市";
$areanames{zh}->{861339704} = "江西省九江市";
$areanames{zh}->{861339705} = "江西省宜春市";
$areanames{zh}->{861339706} = "江西省吉安市";
$areanames{zh}->{861339707} = "江西省赣州市";
$areanames{zh}->{861339708} = "江西省南昌市";
$areanames{zh}->{861339709} = "江西省南昌市";
$areanames{zh}->{86133971} = "湖北省武汉市";
$areanames{zh}->{861339720} = "湖北省宜昌市";
$areanames{zh}->{861339721} = "湖北省荆州市";
$areanames{zh}->{861339722} = "湖北省荆州市";
$areanames{zh}->{861339723} = "湖北省黄石市";
$areanames{zh}->{861339724} = "湖北省鄂州市";
$areanames{zh}->{861339725} = "湖北省黄冈市";
$areanames{zh}->{861339726} = "湖北省黄冈市";
$areanames{zh}->{861339727} = "湖北省孝感市";
$areanames{zh}->{861339728} = "湖北省十堰市";
$areanames{zh}->{861339729} = "湖北省十堰市";
$areanames{zh}->{861339730} = "湖南省岳阳市";
$areanames{zh}->{861339731} = "湖南省长沙市";
$areanames{zh}->{861339732} = "湖南省湘潭市";
$areanames{zh}->{861339733} = "湖南省株洲市";
$areanames{zh}->{861339734} = "湖南省衡阳市";
$areanames{zh}->{861339735} = "湖南省郴州市";
$areanames{zh}->{861339736} = "湖南省常德市";
$areanames{zh}->{861339737} = "湖南省益阳市";
$areanames{zh}->{861339738} = "湖南省娄底市";
$areanames{zh}->{861339739} = "湖南省邵阳市";
$areanames{zh}->{861339740} = "湖南省岳阳市";
$areanames{zh}->{861339741} = "湖南省长沙市";
$areanames{zh}->{861339742} = "湖南省湘潭市";
$areanames{zh}->{861339743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861339744} = "湖南省张家界市";
$areanames{zh}->{861339745} = "湖南省怀化市";
$areanames{zh}->{861339746} = "湖南省永州市";
$areanames{zh}->{861339747} = "湖南省衡阳市";
$areanames{zh}->{861339748} = "湖南省长沙市";
$areanames{zh}->{861339749} = "湖南省长沙市";
$areanames{zh}->{861339750} = "湖南省岳阳市";
$areanames{zh}->{861339751} = "湖南省长沙市";
$areanames{zh}->{861339752} = "湖南省湘潭市";
$areanames{zh}->{861339753} = "湖南省株洲市";
$areanames{zh}->{861339754} = "湖南省郴州市";
$areanames{zh}->{861339755} = "湖南省郴州市";
$areanames{zh}->{861339756} = "湖南省常德市";
$areanames{zh}->{861339757} = "湖南省益阳市";
$areanames{zh}->{861339758} = "湖南省娄底市";
$areanames{zh}->{861339759} = "湖南省邵阳市";
$areanames{zh}->{861339760} = "湖南省长沙市";
$areanames{zh}->{861339761} = "湖南省长沙市";
$areanames{zh}->{861339762} = "湖南省永州市";
$areanames{zh}->{861339763} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861339764} = "湖南省长沙市";
$areanames{zh}->{861339765} = "湖南省怀化市";
$areanames{zh}->{861339766} = "湖南省常德市";
$areanames{zh}->{861339767} = "湖南省衡阳市";
$areanames{zh}->{861339768} = "湖南省株洲市";
$areanames{zh}->{861339769} = "湖南省邵阳市";
$areanames{zh}->{861339770} = "广西南宁市";
$areanames{zh}->{861339771} = "广西南宁市";
$areanames{zh}->{861339772} = "广西柳州市";
$areanames{zh}->{861339773} = "广西桂林市";
$areanames{zh}->{861339774} = "广西贺州市";
$areanames{zh}->{861339775} = "广西玉林市";
$areanames{zh}->{861339776} = "广西百色市";
$areanames{zh}->{861339777} = "广西南宁市";
$areanames{zh}->{861339778} = "广西河池市";
$areanames{zh}->{861339779} = "广西北海市";
$areanames{zh}->{861339780} = "广西南宁市";
$areanames{zh}->{861339781} = "广西南宁市";
$areanames{zh}->{861339782} = "广西柳州市";
$areanames{zh}->{861339783} = "广西桂林市";
$areanames{zh}->{861339784} = "广西梧州市";
$areanames{zh}->{861339785} = "广西贵港市";
$areanames{zh}->{861339786} = "广西百色市";
$areanames{zh}->{861339787} = "广西柳州市";
$areanames{zh}->{861339788} = "广西河池市";
$areanames{zh}->{861339789} = "广西南宁市";
$areanames{zh}->{861339790} = "江西省新余市";
$areanames{zh}->{861339791} = "江西省南昌市";
$areanames{zh}->{861339792} = "江西省九江市";
$areanames{zh}->{861339793} = "江西省上饶市";
$areanames{zh}->{861339794} = "江西省抚州市";
$areanames{zh}->{861339795} = "江西省宜春市";
$areanames{zh}->{861339796} = "江西省吉安市";
$areanames{zh}->{861339797} = "江西省赣州市";
$areanames{zh}->{861339798} = "江西省景德镇市";
$areanames{zh}->{861339799} = "江西省萍乡市";
$areanames{zh}->{861339800} = "西藏拉萨市";
$areanames{zh}->{861339801} = "西藏拉萨市";
$areanames{zh}->{861339802} = "西藏日喀则地区";
$areanames{zh}->{861339803} = "西藏山南地区";
$areanames{zh}->{861339804} = "西藏林芝地区";
$areanames{zh}->{861339805} = "西藏昌都地区";
$areanames{zh}->{861339806} = "西藏那曲地区";
$areanames{zh}->{861339807} = "西藏阿里地区";
$areanames{zh}->{861339808} = "西藏拉萨市";
$areanames{zh}->{861339809} = "西藏拉萨市";
$areanames{zh}->{861339810} = "四川省内江市";
$areanames{zh}->{861339811} = "四川省内江市";
$areanames{zh}->{861339812} = "四川省自贡市";
$areanames{zh}->{861339813} = "四川省自贡市";
$areanames{zh}->{861339814} = "四川省眉山市";
$areanames{zh}->{861339815} = "四川省成都市";
$areanames{zh}->{861339816} = "四川省成都市";
$areanames{zh}->{861339817} = "四川省成都市";
$areanames{zh}->{861339818} = "四川省成都市";
$areanames{zh}->{861339819} = "四川省成都市";
$areanames{zh}->{861339820} = "四川省宜宾市";
$areanames{zh}->{861339821} = "四川省宜宾市";
$areanames{zh}->{861339822} = "四川省遂宁市";
$areanames{zh}->{861339823} = "四川省乐山市";
$areanames{zh}->{861339824} = "四川省乐山市";
$areanames{zh}->{861339825} = "四川省乐山市";
$areanames{zh}->{861339826} = "四川省泸州市";
$areanames{zh}->{861339827} = "四川省泸州市";
$areanames{zh}->{861339828} = "四川省泸州市";
$areanames{zh}->{861339829} = "四川省泸州市";
$areanames{zh}->{861339830} = "四川省资阳市";
$areanames{zh}->{861339831} = "四川省资阳市";
$areanames{zh}->{861339832} = "四川省达州市";
$areanames{zh}->{861339833} = "四川省达州市";
$areanames{zh}->{861339834} = "四川省达州市";
$areanames{zh}->{861339835} = "四川省绵阳市";
$areanames{zh}->{861339836} = "四川省绵阳市";
$areanames{zh}->{861339837} = "四川省绵阳市";
$areanames{zh}->{861339838} = "四川省绵阳市";
$areanames{zh}->{861339839} = "四川省绵阳市";
$areanames{zh}->{861339840} = "四川省雅安市";
$areanames{zh}->{861339841} = "四川省南充市";
$areanames{zh}->{861339842} = "四川省南充市";
$areanames{zh}->{861339843} = "四川省广安市";
$areanames{zh}->{861339844} = "四川省广元市";
$areanames{zh}->{861339845} = "四川省巴中市";
$areanames{zh}->{861339846} = "四川省攀枝花市";
$areanames{zh}->{861339847} = "四川省凉山彝族自治州";
$areanames{zh}->{861339848} = "四川省德阳市";
$areanames{zh}->{861339849} = "四川省绵阳市";
$areanames{zh}->{861339850} = "贵州省贵阳市";
$areanames{zh}->{861339851} = "贵州省贵阳市";
$areanames{zh}->{861339852} = "贵州省遵义市";
$areanames{zh}->{861339853} = "贵州省安顺市";
$areanames{zh}->{861339854} = "贵州省黔南布依族苗族自治州";
$areanames{zh}->{861339855} = "贵州省黔东南苗族侗族自治州";
$areanames{zh}->{861339856} = "贵州省铜仁地区";
$areanames{zh}->{861339857} = "贵州省毕节地区";
$areanames{zh}->{861339858} = "贵州省六盘水市";
$areanames{zh}->{861339859} = "贵州省黔西南布依族苗族自治州";
$areanames{zh}->{861339860} = "河北省保定市";
$areanames{zh}->{861339861} = "河北省石家庄市";
$areanames{zh}->{861339862} = "河北省保定市";
$areanames{zh}->{861339863} = "河北省保定市";
$areanames{zh}->{861339864} = "河北省保定市";
$areanames{zh}->{861339865} = "河北省秦皇岛市";
$areanames{zh}->{861339866} = "河北省承德市";
$areanames{zh}->{861339867} = "河北省承德市";
$areanames{zh}->{861339868} = "河北省承德市";
$areanames{zh}->{861339869} = "河北省承德市";
$areanames{zh}->{861339870} = "云南省昭通市";
$areanames{zh}->{861339871} = "云南省昆明市";
$areanames{zh}->{861339872} = "云南省大理白族自治州";
$areanames{zh}->{861339873} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{861339874} = "云南省曲靖市";
$areanames{zh}->{861339875} = "云南省保山市";
$areanames{zh}->{861339876} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861339877} = "云南省玉溪市";
$areanames{zh}->{861339878} = "云南省楚雄彝族自治州";
$areanames{zh}->{861339879} = "云南省普洱市";
$areanames{zh}->{861339880} = "云南省昆明市";
$areanames{zh}->{861339881} = "云南省西双版纳傣族自治州";
$areanames{zh}->{861339882} = "云南省德宏傣族景颇族自治州";
$areanames{zh}->{861339883} = "云南省临沧市";
$areanames{zh}->{861339884} = "云南省昆明市";
$areanames{zh}->{861339885} = "云南省昆明市";
$areanames{zh}->{861339886} = "云南省怒江傈僳族自治州";
$areanames{zh}->{861339887} = "云南省迪庆藏族自治州";
$areanames{zh}->{861339888} = "云南省丽江市";
$areanames{zh}->{861339889} = "云南省玉溪市";
$areanames{zh}->{86133989} = "海南省海口市";
$areanames{zh}->{861339900} = "新疆克拉玛依市";
$areanames{zh}->{861339901} = "新疆塔城地区";
$areanames{zh}->{861339902} = "新疆哈密地区";
$areanames{zh}->{861339903} = "新疆和田地区";
$areanames{zh}->{861339904} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861339905} = "新疆阿克苏地区";
$areanames{zh}->{861339906} = "新疆阿勒泰地区";
$areanames{zh}->{861339907} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861339908} = "新疆昌吉回族自治州";
$areanames{zh}->{861339909} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861339910} = "陕西省咸阳市";
$areanames{zh}->{861339911} = "陕西省延安市";
$areanames{zh}->{861339912} = "陕西省榆林市";
$areanames{zh}->{861339913} = "陕西省渭南市";
$areanames{zh}->{861339914} = "陕西省商洛市";
$areanames{zh}->{861339915} = "陕西省安康市";
$areanames{zh}->{861339916} = "陕西省汉中市";
$areanames{zh}->{861339917} = "陕西省宝鸡市";
$areanames{zh}->{861339918} = "陕西省西安市";
$areanames{zh}->{861339919} = "陕西省铜川市";
$areanames{zh}->{861339920} = "陕西省咸阳市";
$areanames{zh}->{861339921} = "陕西省延安市";
$areanames{zh}->{861339922} = "陕西省榆林市";
$areanames{zh}->{861339923} = "陕西省渭南市";
$areanames{zh}->{861339924} = "陕西省商洛市";
$areanames{zh}->{861339925} = "陕西省安康市";
$areanames{zh}->{861339926} = "陕西省汉中市";
$areanames{zh}->{861339927} = "陕西省宝鸡市";
$areanames{zh}->{861339928} = "陕西省西安市";
$areanames{zh}->{861339929} = "陕西省铜川市";
$areanames{zh}->{861339930} = "甘肃省临夏回族自治州";
$areanames{zh}->{861339931} = "甘肃省兰州市";
$areanames{zh}->{861339932} = "甘肃省定西市";
$areanames{zh}->{861339933} = "甘肃省平凉市";
$areanames{zh}->{861339934} = "甘肃省庆阳市";
$areanames{zh}->{861339935} = "甘肃省武威市";
$areanames{zh}->{861339936} = "甘肃省张掖市";
$areanames{zh}->{861339937} = "甘肃省酒泉市";
$areanames{zh}->{861339938} = "甘肃省天水市";
$areanames{zh}->{861339939} = "甘肃省陇南市";
$areanames{zh}->{861339940} = "甘肃省酒泉市";
$areanames{zh}->{861339941} = "甘肃省甘南藏族自治州";
$areanames{zh}->{861339942} = "甘肃省嘉峪关市";
$areanames{zh}->{861339943} = "甘肃省白银市";
$areanames{zh}->{861339944} = "甘肃省张掖市";
$areanames{zh}->{861339945} = "甘肃省金昌市";
$areanames{zh}->{861339946} = "甘肃省兰州市";
$areanames{zh}->{861339947} = "甘肃省嘉峪关市";
$areanames{zh}->{861339948} = "甘肃省金昌市";
$areanames{zh}->{861339949} = "甘肃省白银市";
$areanames{zh}->{861339950} = "安徽省滁州市";
$areanames{zh}->{861339951} = "安徽省合肥市";
$areanames{zh}->{861339952} = "安徽省蚌埠市";
$areanames{zh}->{861339953} = "安徽省芜湖市";
$areanames{zh}->{861339954} = "安徽省淮南市";
$areanames{zh}->{861339955} = "安徽省马鞍山市";
$areanames{zh}->{861339956} = "安徽省安庆市";
$areanames{zh}->{861339957} = "安徽省宿州市";
$areanames{zh}->{861339958} = "安徽省阜阳市";
$areanames{zh}->{861339959} = "安徽省黄山市";
$areanames{zh}->{861339960} = "安徽省滁州市";
$areanames{zh}->{861339961} = "安徽省淮北市";
$areanames{zh}->{861339962} = "安徽省铜陵市";
$areanames{zh}->{861339963} = "安徽省宣城市";
$areanames{zh}->{861339964} = "安徽省六安市";
$areanames{zh}->{861339965} = "安徽省巢湖市";
$areanames{zh}->{861339966} = "安徽省池州市";
$areanames{zh}->{861339967} = "安徽省亳州市";
$areanames{zh}->{861339968} = "安徽省阜阳市";
$areanames{zh}->{861339969} = "安徽省合肥市";
$areanames{zh}->{861339970} = "新疆昌吉回族自治州";
$areanames{zh}->{861339971} = "新疆哈密地区";
$areanames{zh}->{861339972} = "新疆博尔塔拉蒙古自治州";
$areanames{zh}->{861339973} = "新疆塔城地区";
$areanames{zh}->{861339974} = "新疆阿勒泰地区";
$areanames{zh}->{861339975} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861339976} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861339977} = "新疆喀什地区";
$areanames{zh}->{861339978} = "新疆喀什地区";
$areanames{zh}->{861339979} = "新疆和田地区";
$areanames{zh}->{86133998} = "重庆市";
$areanames{zh}->{861339990} = "新疆克拉玛依市";
$areanames{zh}->{861339991} = "新疆乌鲁木齐市";
$areanames{zh}->{861339992} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861339993} = "新疆石河子市";
$areanames{zh}->{861339994} = "新疆昌吉回族自治州";
$areanames{zh}->{861339995} = "新疆吐鲁番地区";
$areanames{zh}->{861339996} = "新疆巴音郭楞蒙古自治州";
$areanames{zh}->{861339997} = "新疆阿克苏地区";
$areanames{zh}->{861339998} = "新疆喀什地区";
$areanames{zh}->{861339999} = "新疆伊犁哈萨克自治州";
$areanames{zh}->{861340000} = "江苏省无锡市";
$areanames{zh}->{861340001} = "江苏省无锡市";
$areanames{zh}->{861340002} = "江苏省无锡市";
$areanames{zh}->{861340003} = "江苏省无锡市";
$areanames{zh}->{861340004} = "江苏省无锡市";
$areanames{zh}->{861340005} = "江苏省南京市";
$areanames{zh}->{861340006} = "江苏省南京市";
$areanames{zh}->{861340007} = "江苏省南京市";
$areanames{zh}->{861340008} = "江苏省镇江市";
$areanames{zh}->{861340009} = "江苏省镇江市";
$areanames{zh}->{861340010} = "河北省邯郸市";
$areanames{zh}->{861340011} = "河北省石家庄市";
$areanames{zh}->{861340012} = "河北省保定市";
$areanames{zh}->{861340013} = "河北省张家口市";
$areanames{zh}->{861340014} = "河北省邢台市";
$areanames{zh}->{861340015} = "河北省邢台市";
$areanames{zh}->{861340016} = "河北省保定市";
$areanames{zh}->{861340017} = "河北省沧州市";
$areanames{zh}->{861340018} = "河北省邢台市";
$areanames{zh}->{861340019} = "河北省邢台市";
$areanames{zh}->{86134002} = "河北省保定市";
$areanames{zh}->{861340020} = "河北省邯郸市";
$areanames{zh}->{861340021} = "河北省石家庄市";
$areanames{zh}->{86134003} = "河北省保定市";
$areanames{zh}->{861340030} = "河北省邯郸市";
$areanames{zh}->{861340031} = "河北省石家庄市";
$areanames{zh}->{861340040} = "河北省邯郸市";
$areanames{zh}->{861340041} = "河北省石家庄市";
$areanames{zh}->{861340042} = "河北省保定市";
$areanames{zh}->{861340043} = "河北省保定市";
$areanames{zh}->{861340044} = "河北省保定市";
$areanames{zh}->{861340045} = "河北省唐山市";
$areanames{zh}->{861340046} = "河北省张家口市";
$areanames{zh}->{861340047} = "河北省沧州市";
$areanames{zh}->{861340048} = "河北省衡水市";
$areanames{zh}->{861340049} = "河北省保定市";
$areanames{zh}->{86134005} = "福建省福州市";
$areanames{zh}->{86134006} = "福建省厦门市";
$areanames{zh}->{86134007} = "福建省厦门市";
$areanames{zh}->{86134008} = "福建省泉州市";
$areanames{zh}->{86134009} = "福建省漳州市";
$areanames{zh}->{86134010} = "北京市";
$areanames{zh}->{86134011} = "北京市";
$areanames{zh}->{861340120} = "江苏省泰州市";
$areanames{zh}->{861340121} = "江苏省泰州市";
$areanames{zh}->{861340122} = "江苏省泰州市";
$areanames{zh}->{861340123} = "江苏省泰州市";
$areanames{zh}->{861340124} = "江苏省泰州市";
$areanames{zh}->{861340125} = "江苏省盐城市";
$areanames{zh}->{861340126} = "江苏省连云港市";
$areanames{zh}->{861340127} = "江苏省徐州市";
$areanames{zh}->{861340128} = "江苏省南通市";
$areanames{zh}->{861340129} = "江苏省扬州市";
$areanames{zh}->{86134013} = "江苏省常州市";
$areanames{zh}->{86134014} = "江苏省苏州市";
$areanames{zh}->{861340148} = "江苏省常州市";
$areanames{zh}->{861340149} = "江苏省常州市";
$areanames{zh}->{86134015} = "江苏省常州市";
$areanames{zh}->{86134016} = "江苏省常州市";
$areanames{zh}->{86134017} = "江苏省盐城市";
$areanames{zh}->{86134018} = "江苏省淮安市";
$areanames{zh}->{861340186} = "江苏省宿迁市";
$areanames{zh}->{861340187} = "江苏省宿迁市";
$areanames{zh}->{861340188} = "江苏省宿迁市";
$areanames{zh}->{861340189} = "江苏省宿迁市";
$areanames{zh}->{86134019} = "江苏省南京市";
$areanames{zh}->{86134020} = "上海市";
$areanames{zh}->{86134021} = "上海市";
$areanames{zh}->{861340220} = "山东省济南市";
$areanames{zh}->{861340221} = "山东省济南市";
$areanames{zh}->{861340222} = "山东省济南市";
$areanames{zh}->{861340223} = "山东省菏泽市";
$areanames{zh}->{861340224} = "山东省菏泽市";
$areanames{zh}->{861340225} = "山东省菏泽市";
$areanames{zh}->{861340226} = "山东省潍坊市";
$areanames{zh}->{861340227} = "山东省济宁市";
$areanames{zh}->{861340228} = "山东省济宁市";
$areanames{zh}->{861340229} = "山东省德州市";
$areanames{zh}->{86134023} = "四川省绵阳市";
$areanames{zh}->{861340230} = "四川省自贡市";
$areanames{zh}->{861340231} = "四川省自贡市";
$areanames{zh}->{861340232} = "四川省自贡市";
$areanames{zh}->{86134024} = "河北省唐山市";
$areanames{zh}->{861340248} = "河北省石家庄市";
$areanames{zh}->{861340249} = "河北省石家庄市";
$areanames{zh}->{86134025} = "江苏省苏州市";
$areanames{zh}->{86134026} = "江苏省苏州市";
$areanames{zh}->{86134027} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{86134028} = "四川省成都市";
$areanames{zh}->{861340290} = "陕西省延安市";
$areanames{zh}->{861340291} = "陕西省渭南市";
$areanames{zh}->{861340292} = "陕西省榆林市";
$areanames{zh}->{861340293} = "陕西省咸阳市";
$areanames{zh}->{861340294} = "陕西省西安市";
$areanames{zh}->{861340295} = "陕西省西安市";
$areanames{zh}->{861340296} = "陕西省西安市";
$areanames{zh}->{861340297} = "陕西省西安市";
$areanames{zh}->{861340298} = "陕西省西安市";
$areanames{zh}->{861340299} = "陕西省榆林市";
$areanames{zh}->{86134030} = "湖北省恩施土家族苗族自治州";
$areanames{zh}->{861340310} = "河北省邯郸市";
$areanames{zh}->{861340311} = "河北省石家庄市";
$areanames{zh}->{861340312} = "河北省保定市";
$areanames{zh}->{861340313} = "河北省张家口市";
$areanames{zh}->{861340314} = "河北省承德市";
$areanames{zh}->{861340315} = "河北省唐山市";
$areanames{zh}->{861340316} = "河北省廊坊市";
$areanames{zh}->{861340317} = "河北省沧州市";
$areanames{zh}->{861340318} = "河北省衡水市";
$areanames{zh}->{861340319} = "河北省邢台市";
$areanames{zh}->{861340320} = "河北省邯郸市";
$areanames{zh}->{861340321} = "河北省石家庄市";
$areanames{zh}->{861340322} = "河北省保定市";
$areanames{zh}->{861340323} = "河北省张家口市";
$areanames{zh}->{861340324} = "河北省承德市";
$areanames{zh}->{861340325} = "河北省唐山市";
$areanames{zh}->{861340326} = "河北省保定市";
$areanames{zh}->{861340327} = "河北省沧州市";
$areanames{zh}->{861340328} = "河北省衡水市";
$areanames{zh}->{861340329} = "河北省邢台市";
$areanames{zh}->{861340330} = "河北省邯郸市";
$areanames{zh}->{861340331} = "河北省石家庄市";
$areanames{zh}->{861340332} = "河北省保定市";
$areanames{zh}->{861340333} = "河北省张家口市";
$areanames{zh}->{861340334} = "河北省承德市";
$areanames{zh}->{861340335} = "河北省唐山市";
$areanames{zh}->{861340336} = "河北省保定市";
$areanames{zh}->{861340337} = "河北省沧州市";
$areanames{zh}->{861340338} = "河北省衡水市";
$areanames{zh}->{861340339} = "河北省邢台市";
$areanames{zh}->{861340340} = "山西省太原市";
$areanames{zh}->{861340341} = "山西省太原市";
$areanames{zh}->{861340342} = "山西省大同市";
$areanames{zh}->{861340343} = "山西省太原市";
$areanames{zh}->{861340344} = "山西省晋中市";
$areanames{zh}->{861340345} = "山西省太原市";
$areanames{zh}->{861340346} = "山西省太原市";
$areanames{zh}->{861340347} = "山西省临汾市";
$areanames{zh}->{861340348} = "山西省运城市";
$areanames{zh}->{861340349} = "山西省朔州市";
$areanames{zh}->{861340350} = "山西省忻州市";
$areanames{zh}->{861340351} = "山西省太原市";
$areanames{zh}->{861340352} = "山西省大同市";
$areanames{zh}->{861340353} = "山西省阳泉市";
$areanames{zh}->{861340354} = "山西省晋中市";
$areanames{zh}->{861340355} = "山西省长治市";
$areanames{zh}->{861340356} = "山西省晋城市";
$areanames{zh}->{861340357} = "山西省临汾市";
$areanames{zh}->{861340358} = "山西省吕梁市";
$areanames{zh}->{861340359} = "山西省运城市";
$areanames{zh}->{861340360} = "山西省大同市";
$areanames{zh}->{861340361} = "山西省大同市";
$areanames{zh}->{861340362} = "山西省大同市";
$areanames{zh}->{861340363} = "山西省大同市";
$areanames{zh}->{861340364} = "山西省大同市";
$areanames{zh}->{861340365} = "山西省晋中市";
$areanames{zh}->{861340366} = "山西省晋中市";
$areanames{zh}->{861340367} = "山西省忻州市";
$areanames{zh}->{861340368} = "山西省忻州市";
$areanames{zh}->{861340369} = "山西省太原市";
$areanames{zh}->{861340370} = "河南省商丘市";
$areanames{zh}->{861340371} = "河南省郑州市";
$areanames{zh}->{861340372} = "河南省安阳市";
$areanames{zh}->{861340373} = "河南省新乡市";
$areanames{zh}->{861340374} = "河南省许昌市";
$areanames{zh}->{861340375} = "河南省平顶山市";
$areanames{zh}->{861340376} = "河南省信阳市";
$areanames{zh}->{861340377} = "河南省南阳市";
$areanames{zh}->{861340378} = "河南省开封市";
$areanames{zh}->{861340379} = "河南省洛阳市";
$areanames{zh}->{861340380} = "河南省安阳市";
$areanames{zh}->{861340381} = "河南省安阳市";
$areanames{zh}->{861340382} = "河南省安阳市";
$areanames{zh}->{861340383} = "河南省安阳市";
$areanames{zh}->{861340384} = "河南省安阳市";
$areanames{zh}->{861340385} = "河南省周口市";
$areanames{zh}->{861340386} = "河南省周口市";
$areanames{zh}->{861340387} = "河南省周口市";
$areanames{zh}->{861340388} = "河南省周口市";
$areanames{zh}->{861340389} = "河南省周口市";
$areanames{zh}->{861340390} = "河南省焦作市";
$areanames{zh}->{861340391} = "河南省焦作市";
$areanames{zh}->{861340392} = "河南省鹤壁市";
$areanames{zh}->{861340393} = "河南省濮阳市";
$areanames{zh}->{861340394} = "河南省周口市";
$areanames{zh}->{861340395} = "河南省漯河市";
$areanames{zh}->{861340396} = "河南省驻马店市";
$areanames{zh}->{861340397} = "河南省信阳市";
$areanames{zh}->{861340398} = "河南省三门峡市";
$areanames{zh}->{861340399} = "河南省焦作市";
$areanames{zh}->{861340400} = "四川省绵阳市";
$areanames{zh}->{861340401} = "四川省绵阳市";
$areanames{zh}->{861340402} = "四川省广元市";
$areanames{zh}->{861340403} = "四川省达州市";
$areanames{zh}->{861340404} = "四川省达州市";
$areanames{zh}->{861340405} = "四川省雅安市";
$areanames{zh}->{861340406} = "四川省眉山市";
$areanames{zh}->{861340407} = "四川省眉山市";
$areanames{zh}->{861340408} = "四川省南充市";
$areanames{zh}->{861340409} = "四川省泸州市";
$areanames{zh}->{86134041} = "江苏省南京市";
$areanames{zh}->{861340418} = "江苏省连云港市";
$areanames{zh}->{861340419} = "江苏省宿迁市";
$areanames{zh}->{861340420} = "江苏省南通市";
$areanames{zh}->{861340421} = "江苏省苏州市";
$areanames{zh}->{861340422} = "江苏省苏州市";
$areanames{zh}->{861340423} = "江苏省苏州市";
$areanames{zh}->{861340424} = "江苏省苏州市";
$areanames{zh}->{861340425} = "江苏省无锡市";
$areanames{zh}->{861340426} = "江苏省无锡市";
$areanames{zh}->{861340427} = "江苏省无锡市";
$areanames{zh}->{861340428} = "江苏省无锡市";
$areanames{zh}->{861340429} = "江苏省南通市";
$areanames{zh}->{86134043} = "吉林省长春市";
$areanames{zh}->{861340434} = "吉林省四平市";
$areanames{zh}->{861340440} = "吉林省白城市";
$areanames{zh}->{861340441} = "吉林省白城市";
$areanames{zh}->{861340442} = "吉林省白城市";
$areanames{zh}->{861340443} = "吉林省白城市";
$areanames{zh}->{861340444} = "吉林省白城市";
$areanames{zh}->{861340445} = "吉林省松原市";
$areanames{zh}->{861340446} = "吉林省松原市";
$areanames{zh}->{861340447} = "吉林省松原市";
$areanames{zh}->{861340448} = "吉林省松原市";
$areanames{zh}->{861340449} = "吉林省松原市";
$areanames{zh}->{861340450} = "吉林省通化市";
$areanames{zh}->{861340451} = "吉林省通化市";
$areanames{zh}->{861340452} = "吉林省通化市";
$areanames{zh}->{861340453} = "吉林省通化市";
$areanames{zh}->{861340454} = "吉林省通化市";
$areanames{zh}->{861340455} = "吉林省松原市";
$areanames{zh}->{861340456} = "吉林省松原市";
$areanames{zh}->{861340457} = "吉林省松原市";
$areanames{zh}->{861340458} = "吉林省松原市";
$areanames{zh}->{861340459} = "吉林省松原市";
$areanames{zh}->{861340460} = "吉林省四平市";
$areanames{zh}->{861340461} = "吉林省四平市";
$areanames{zh}->{861340462} = "吉林省四平市";
$areanames{zh}->{861340463} = "吉林省四平市";
$areanames{zh}->{861340464} = "吉林省四平市";
$areanames{zh}->{861340465} = "吉林省吉林市";
$areanames{zh}->{861340466} = "吉林省吉林市";
$areanames{zh}->{861340467} = "吉林省吉林市";
$areanames{zh}->{861340468} = "吉林省吉林市";
$areanames{zh}->{861340469} = "吉林省吉林市";
$areanames{zh}->{86134047} = "吉林省长春市";
$areanames{zh}->{861340480} = "内蒙古呼和浩特市";
$areanames{zh}->{861340481} = "内蒙古呼和浩特市";
$areanames{zh}->{861340482} = "内蒙古兴安盟";
$areanames{zh}->{861340483} = "内蒙古呼和浩特市";
$areanames{zh}->{861340484} = "内蒙古呼和浩特市";
$areanames{zh}->{861340485} = "内蒙古通辽市";
$areanames{zh}->{861340486} = "内蒙古赤峰市";
$areanames{zh}->{861340487} = "内蒙古赤峰市";
$areanames{zh}->{861340488} = "内蒙古赤峰市";
$areanames{zh}->{861340489} = "内蒙古赤峰市";
$areanames{zh}->{861340490} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861340491} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861340492} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861340493} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861340494} = "云南省文山壮族苗族自治州";
$areanames{zh}->{861340495} = "云南省大理白族自治州";
$areanames{zh}->{861340496} = "云南省大理白族自治州";
$areanames{zh}->{861340497} = "云南省大理白族自治州";
$areanames{zh}->{861340498} = "云南省大理白族自治州";
$areanames{zh}->{861340499} = "云南省大理白族自治州";
$areanames{zh}->{86134050} = "江苏省苏州市";
$areanames{zh}->{86134051} = "江苏省苏州市";
$areanames{zh}->{86134052} = "江苏省苏州市";
$areanames{zh}->{861340530} = "山东省菏泽市";
$areanames{zh}->{861340531} = "山东省济南市";
$areanames{zh}->{861340532} = "山东省青岛市";
$areanames{zh}->{861340533} = "山东省淄博市";
$areanames{zh}->{861340534} = "山东省德州市";
$areanames{zh}->{861340535} = "山东省烟台市";
$areanames{zh}->{861340536} = "山东省潍坊市";
$areanames{zh}->{861340537} = "山东省济宁市";
$areanames{zh}->{861340538} = "山东省泰安市";
$areanames{zh}->{861340539} = "山东省临沂市";
$areanames{zh}->{861340540} = "山东省菏泽市";
$areanames{zh}->{861340541} = "山东省济南市";
$areanames{zh}->{861340542} = "山东省青岛市";
$areanames{zh}->{861340543} = "山东省滨州市";
$areanames{zh}->{861340544} = "山东省德州市";
$areanames{zh}->{861340545} = "山东省烟台市";
$areanames{zh}->{861340546} = "山东省东营市";
$areanames{zh}->{861340547} = "山东省济宁市";
$areanames{zh}->{861340548} = "山东省泰安市";
$areanames{zh}->{861340549} = "山东省临沂市";
$areanames{zh}->{861340550} = "江苏省淮安市";
$areanames{zh}->{861340551} = "江苏省淮安市";
$areanames{zh}->{861340552} = "江苏省泰州市";
$areanames{zh}->{861340553} = "江苏省泰州市";
$areanames{zh}->{861340554} = "江苏省泰州市";
$areanames{zh}->{861340555} = "江苏省扬州市";
$areanames{zh}->{861340556} = "江苏省扬州市";
$areanames{zh}->{861340557} = "江苏省扬州市";
$areanames{zh}->{861340558} = "江苏省镇江市";
$areanames{zh}->{861340559} = "江苏省镇江市";
$areanames{zh}->{86134056} = "江苏省苏州市";
$areanames{zh}->{861340570} = "江苏省南通市";
$areanames{zh}->{861340571} = "江苏省南通市";
$areanames{zh}->{861340572} = "江苏省南通市";
$areanames{zh}->{861340573} = "江苏省南通市";
$areanames{zh}->{861340574} = "江苏省南通市";
$areanames{zh}->{861340575} = "江苏省无锡市";
$areanames{zh}->{861340576} = "江苏省无锡市";
$areanames{zh}->{861340577} = "江苏省无锡市";
$areanames{zh}->{861340578} = "江苏省无锡市";
$areanames{zh}->{861340579} = "江苏省无锡市";
$areanames{zh}->{86134058} = "江苏省南京市";
$areanames{zh}->{86134059} = "福建省福州市";
$areanames{zh}->{86134060} = "山东省菏泽市";
$areanames{zh}->{861340606} = "山东省济南市";
$areanames{zh}->{861340607} = "山东省东营市";
$areanames{zh}->{861340608} = "山东省东营市";
$areanames{zh}->{861340609} = "山东省东营市";
$areanames{zh}->{861340610} = "山东省东营市";
$areanames{zh}->{861340611} = "山东省东营市";
$areanames{zh}->{861340612} = "山东省东营市";
$areanames{zh}->{861340613} = "山东省东营市";
$areanames{zh}->{861340614} = "山东省东营市";
$areanames{zh}->{861340615} = "山东省滨州市";
$areanames{zh}->{861340616} = "山东省滨州市";
$areanames{zh}->{861340617} = "山东省滨州市";
$areanames{zh}->{861340618} = "山东省滨州市";
$areanames{zh}->{861340619} = "山东省滨州市";
$areanames{zh}->{861340620} = "山东省泰安市";
$areanames{zh}->{861340621} = "山东省泰安市";
$areanames{zh}->{861340622} = "山东省泰安市";
$areanames{zh}->{861340623} = "山东省滨州市";
$areanames{zh}->{861340624} = "山东省滨州市";
$areanames{zh}->{861340625} = "山东省滨州市";
$areanames{zh}->{861340626} = "山东省济宁市";
$areanames{zh}->{861340627} = "山东省济宁市";
$areanames{zh}->{861340628} = "山东省济宁市";
$areanames{zh}->{861340629} = "山东省济宁市";
$areanames{zh}->{86134063} = "山东省聊城市";
$areanames{zh}->{861340630} = "山东省威海市";
$areanames{zh}->{861340631} = "山东省威海市";
$areanames{zh}->{861340632} = "山东省枣庄市";
$areanames{zh}->{861340633} = "山东省日照市";
$areanames{zh}->{861340640} = "山东省济南市";
$areanames{zh}->{861340641} = "山东省济南市";
$areanames{zh}->{861340642} = "山东省青岛市";
$areanames{zh}->{861340643} = "山东省烟台市";
$areanames{zh}->{861340644} = "山东省烟台市";
$areanames{zh}->{861340645} = "山东省烟台市";
$areanames{zh}->{861340646} = "山东省潍坊市";
$areanames{zh}->{861340647} = "山东省潍坊市";
$areanames{zh}->{861340648} = "山东省青岛市";
$areanames{zh}->{861340649} = "山东省威海市";
$areanames{zh}->{86134065} = "山东省烟台市";
$areanames{zh}->{86134066} = "山东省潍坊市";
$areanames{zh}->{86134067} = "山东省威海市";
$areanames{zh}->{861340677} = "山东省德州市";
$areanames{zh}->{861340678} = "山东省德州市";
$areanames{zh}->{861340679} = "山东省德州市";
$areanames{zh}->{861340680} = "山东省青岛市";
$areanames{zh}->{861340681} = "山东省青岛市";
$areanames{zh}->{861340682} = "山东省聊城市";
$areanames{zh}->{861340683} = "山东省济宁市";
$areanames{zh}->{861340684} = "山东省临沂市";
$areanames{zh}->{861340685} = "山东省德州市";
$areanames{zh}->{861340686} = "山东省德州市";
$areanames{zh}->{861340687} = "山东省德州市";
$areanames{zh}->{861340688} = "山东省德州市";
$areanames{zh}->{861340689} = "山东省德州市";
$areanames{zh}->{86134069} = "山东省济南市";
$areanames{zh}->{861340690} = "山东省枣庄市";
$areanames{zh}->{861340691} = "山东省枣庄市";
$areanames{zh}->{861340700} = "江西省南昌市";
$areanames{zh}->{861340701} = "江西省鹰潭市";
$areanames{zh}->{861340702} = "江西省九江市";
$areanames{zh}->{861340703} = "江西省上饶市";
$areanames{zh}->{861340704} = "江西省抚州市";
$areanames{zh}->{861340705} = "江西省宜春市";
$areanames{zh}->{861340706} = "江西省吉安市";
$areanames{zh}->{861340707} = "江西省赣州市";
$areanames{zh}->{861340708} = "江西省南昌市";
$areanames{zh}->{861340709} = "江西省南昌市";
$areanames{zh}->{86134071} = "湖北省武汉市";
$areanames{zh}->{86134072} = "湖北省武汉市";
$areanames{zh}->{861340730} = "湖南省岳阳市";
$areanames{zh}->{861340731} = "湖南省长沙市";
$areanames{zh}->{861340732} = "湖南省湘潭市";
$areanames{zh}->{861340733} = "湖南省株洲市";
$areanames{zh}->{861340734} = "湖南省衡阳市";
$areanames{zh}->{861340735} = "湖南省郴州市";
$areanames{zh}->{861340736} = "湖南省常德市";
$areanames{zh}->{861340737} = "湖南省益阳市";
$areanames{zh}->{861340738} = "湖南省娄底市";
$areanames{zh}->{861340739} = "湖南省邵阳市";
$areanames{zh}->{861340740} = "湖南省郴州市";
$areanames{zh}->{861340741} = "湖南省郴州市";
$areanames{zh}->{861340742} = "湖南省湘潭市";
$areanames{zh}->{861340743} = "湖南省湘西土家族苗族自治州";
$areanames{zh}->{861340744} = "湖南省张家界市";
$areanames{zh}->{861340745} = "湖南省怀化市";
$areanames{zh}->{861340746} = "湖南省永州市";
$areanames{zh}->{861340747} = "湖南省株洲市";
$areanames{zh}->{861340748} = "湖南省娄底市";
$areanames{zh}->{861340749} = "湖南省邵阳市";
$areanames{zh}->{861340750} = "江苏省盐城市";
$areanames{zh}->{861340751} = "江苏省盐城市";
$areanames{zh}->{861340752} = "江苏省徐州市";
$areanames{zh}->{861340753} = "江苏省徐州市";
$areanames{zh}->{861340754} = "江苏省徐州市";
$areanames{zh}->{861340755} = "江苏省宿迁市";
$areanames{zh}->{861340756} = "江苏省常州市";
$areanames{zh}->{861340757} = "江苏省常州市";
$areanames{zh}->{861340758} = "江苏省常州市";
$areanames{zh}->{861340759} = "江苏省常州市";
$areanames{zh}->{86134076} = "山东省临沂市";
$areanames{zh}->{861340760} = "山东省青岛市";
$areanames{zh}->{861340761} = "山东省日照市";
$areanames{zh}->{861340770} = "广西南宁市";
$areanames{zh}->{861340771} = "广西南宁市";
$areanames{zh}->{861340772} = "广西南宁市";
$areanames{zh}->{861340773} = "广西南宁市";
$areanames{zh}->{861340774} = "广西南宁市";
$areanames{zh}->{861340775} = "广西河池市";
$areanames{zh}->{861340776} = "广西河池市";
$areanames{zh}->{861340777} = "广西河池市";
$areanames{zh}->{861340778} = "广西河池市";
$areanames{zh}->{861340779} = "广西河池市";
$areanames{zh}->{86134078} = "广西柳州市";
$areanames{zh}->{861340790} = "江西省新余市";
$areanames{zh}->{861340791} = "江西省南昌市";
$areanames{zh}->{861340792} = "江西省九江市";
$areanames{zh}->{861340793} = "江西省上饶市";
$areanames{zh}->{861340794} = "江西省抚州市";
$areanames{zh}->{861340795} = "江西省宜春市";
$areanames{zh}->{861340796} = "江西省吉安市";
$areanames{zh}->{861340797} = "江西省赣州市";
$areanames{zh}->{861340798} = "江西省景德镇市";
$areanames{zh}->{861340799} = "江西省萍乡市";
$areanames{zh}->{86134080} = "四川省成都市";
$areanames{zh}->{861340810} = "四川省绵阳市";
$areanames{zh}->{861340811} = "四川省绵阳市";
$areanames{zh}->{861340812} = "四川省攀枝花市";
$areanames{zh}->{861340813} = "四川省自贡市";
$areanames{zh}->{861340814} = "四川省德阳市";
$areanames{zh}->{861340815} = "四川省遂宁市";
$areanames{zh}->{861340816} = "四川省绵阳市";
$areanames{zh}->{861340817} = "四川省南充市";
$areanames{zh}->{861340818} = "四川省达州市";
$areanames{zh}->{861340819} = "四川省达州市";
$areanames{zh}->{861340820} = "四川省泸州市";
$areanames{zh}->{861340821} = "四川省宜宾市";
$areanames{zh}->{861340822} = "四川省资阳市";
$areanames{zh}->{861340823} = "四川省乐山市";
$areanames{zh}->{861340824} = "四川省乐山市";
$areanames{zh}->{861340825} = "四川省遂宁市";
$areanames{zh}->{861340826} = "四川省广安市";
$areanames{zh}->{861340827} = "四川省巴中市";
$areanames{zh}->{861340828} = "四川省南充市";
$areanames{zh}->{861340829} = "四川省攀枝花市";
$areanames{zh}->{861340830} = "四川省泸州市";
$areanames{zh}->{861340831} = "四川省宜宾市";
$areanames{zh}->{861340832} = "四川省内江市";
$areanames{zh}->{861340833} = "四川省乐山市";
$areanames{zh}->{861340834} = "四川省凉山彝族自治州";
$areanames{zh}->{861340835} = "四川省雅安市";
$areanames{zh}->{861340836} = "四川省凉山彝族自治州";
$areanames{zh}->{861340837} = "四川省阿坝藏族羌族自治州";
$areanames{zh}->{861340838} = "四川省德阳市";
$areanames{zh}->{861340839} = "四川省广元市";
$areanames{zh}->{86134084} = "四川省成都市";
$areanames{zh}->{86134085} = "四川省成都市";
$areanames{zh}->{86134086} = "四川省成都市";
$areanames{zh}->{86134087} = "云南省曲靖市";
$areanames{zh}->{86134088} = "云南省昭通市";
$areanames{zh}->{861340888} = "云南省临沧市";
$areanames{zh}->{861340889} = "云南省临沧市";
$areanames{zh}->{86134089} = "云南省红河哈尼族彝族自治州";
$areanames{zh}->{86134090} = "山东省淄博市";
$areanames{zh}->{861340902} = "山东省日照市";
$areanames{zh}->{861340903} = "山东省日照市";
$areanames{zh}->{861340904} = "山东省日照市";
$areanames{zh}->{86134091} = "陕西省榆林市";
$areanames{zh}->{861340910} = "陕西省咸阳市";
$areanames{zh}->{861340911} = "陕西省延安市";
$areanames{zh}->{861340913} = "陕西省渭南市";
$areanames{zh}->{861340915} = "陕西省安康市";
$areanames{zh}->{861340920} = "河南省新乡市";
$areanames{zh}->{861340921} = "河南省新乡市";
$areanames{zh}->{861340922} = "河南省新乡市";
$areanames{zh}->{861340923} = "河南省新乡市";
$areanames{zh}->{861340924} = "河南省新乡市";
$areanames{zh}->{861340925} = "河南省南阳市";
$areanames{zh}->{861340926} = "河南省南阳市";
$areanames{zh}->{861340927} = "河南省南阳市";
$areanames{zh}->{861340928} = "河南省南阳市";
$areanames{zh}->{861340929} = "河南省南阳市";
$areanames{zh}->{861340930} = "河南省平顶山市";
$areanames{zh}->{861340931} = "河南省平顶山市";
$areanames{zh}->{861340932} = "河南省平顶山市";
$areanames{zh}->{861340933} = "河南省平顶山市";
$areanames{zh}->{861340934} = "河南省平顶山市";
$areanames{zh}->{861340935} = "河南省许昌市";
$areanames{zh}->{861340936} = "河南省许昌市";
$areanames{zh}->{861340937} = "河南省许昌市";
$areanames{zh}->{861340938} = "河南省许昌市";
$areanames{zh}->{861340939} = "河南省许昌市";
$areanames{zh}->{861340940} = "河南省商丘市";
$areanames{zh}->{861340941} = "河南省商丘市";
$areanames{zh}->{861340942} = "河南省商丘市";
$areanames{zh}->{861340943} = "河南省商丘市";
$areanames{zh}->{861340944} = "河南省商丘市";
$areanames{zh}->{861340945} = "河南省平顶山市";
$areanames{zh}->{861340946} = "河南省平顶山市";
$areanames{zh}->{861340947} = "河南省平顶山市";
$areanames{zh}->{861340948} = "河南省平顶山市";
$areanames{zh}->{861340949} = "河南省平顶山市";
$areanames{zh}->{861340950} = "宁夏银川市";
$areanames{zh}->{861340951} = "宁夏银川市";
$areanames{zh}->{861340952} = "宁夏石嘴山市";
$areanames{zh}->{861340953} = "宁夏吴忠市";
$areanames{zh}->{861340954} = "宁夏固原市";
$areanames{zh}->{861340955} = "宁夏中卫市";
$areanames{zh}->{861340956} = "宁夏石嘴山市";
$areanames{zh}->{861340957} = "宁夏中卫市";
$areanames{zh}->{861340958} = "宁夏银川市";
$areanames{zh}->{861340959} = "宁夏银川市";
$areanames{zh}->{861340960} = "湖北省荆门市";
$areanames{zh}->{861340961} = "湖北省荆门市";
$areanames{zh}->{861340962} = "湖北省随州市";
$areanames{zh}->{861340963} = "湖北省随州市";
$areanames{zh}->{861340964} = "湖北省随州市";
$areanames{zh}->{861340965} = "湖北省随州市";
$areanames{zh}->{861340966} = "湖北省随州市";
$areanames{zh}->{861340967} = "湖北省黄冈市";
$areanames{zh}->{861340968} = "湖北省黄冈市";
$areanames{zh}->{861340969} = "湖北省黄冈市";
$areanames{zh}->{86134097} = "湖北省黄冈市";
$areanames{zh}->{86134098} = "湖北省黄冈市";
$areanames{zh}->{86134099} = "湖北省黄冈市";
$areanames{zh}->{8613410} = "广东省深圳市";
$areanames{zh}->{861341100} = "广东省佛山市";
$areanames{zh}->{861341101} = "广东省佛山市";
$areanames{zh}->{861341102} = "广东省佛山市";
$areanames{zh}->{861341103} = "广东省佛山市";
$areanames{zh}->{861341104} = "广东省佛山市";
$areanames{zh}->{861341105} = "广东省汕尾市";
$areanames{zh}->{861341106} = "广东省汕尾市";
$areanames{zh}->{861341107} = "广东省汕尾市";
$areanames{zh}->{861341108} = "广东省汕尾市";
$areanames{zh}->{861341109} = "广东省汕尾市";
$areanames{zh}->{861341110} = "广东省韶关市";
$areanames{zh}->{861341111} = "广东省韶关市";
$areanames{zh}->{861341112} = "广东省韶关市";
$areanames{zh}->{861341113} = "广东省韶关市";
$areanames{zh}->{861341114} = "广东省韶关市";
$areanames{zh}->{861341115} = "广东省广州市";
$areanames{zh}->{861341116} = "广东省广州市";
$areanames{zh}->{861341117} = "广东省广州市";
$areanames{zh}->{861341118} = "广东省广州市";
$areanames{zh}->{861341119} = "广东省广州市";
$areanames{zh}->{86134112} = "广东省梅州市";
$areanames{zh}->{861341130} = "广东省阳江市";
$areanames{zh}->{861341131} = "广东省阳江市";
$areanames{zh}->{861341132} = "广东省阳江市";
$areanames{zh}->{861341133} = "广东省阳江市";
$areanames{zh}->{861341134} = "广东省阳江市";
$areanames{zh}->{861341135} = "广东省珠海市";
$areanames{zh}->{861341136} = "广东省珠海市";
$areanames{zh}->{861341137} = "广东省珠海市";
$areanames{zh}->{861341138} = "广东省珠海市";
$areanames{zh}->{861341139} = "广东省珠海市";
$areanames{zh}->{86134114} = "广东省珠海市";
$areanames{zh}->{86134115} = "广东省珠海市";
$areanames{zh}->{86134116} = "广东省中山市";
$areanames{zh}->{86134117} = "广东省云浮市";
$areanames{zh}->{861341180} = "广东省佛山市";
$areanames{zh}->{861341181} = "广东省佛山市";
$areanames{zh}->{861341182} = "广东省佛山市";
$areanames{zh}->{861341183} = "广东省佛山市";
$areanames{zh}->{861341184} = "广东省佛山市";
$areanames{zh}->{861341185} = "广东省深圳市";
$areanames{zh}->{861341186} = "广东省深圳市";
$areanames{zh}->{861341187} = "广东省深圳市";
$areanames{zh}->{861341188} = "广东省深圳市";
$areanames{zh}->{861341189} = "广东省深圳市";
$areanames{zh}->{86134119} = "广东省汕头市";
$areanames{zh}->{8613412} = "广东省东莞市";
$areanames{zh}->{86134130} = "广东省惠州市";
$areanames{zh}->{86134131} = "广东省惠州市";
$areanames{zh}->{86134132} = "广东省佛山市";
$areanames{zh}->{86134133} = "广东省茂名市";
$areanames{zh}->{861341340} = "广东省汕头市";
$areanames{zh}->{861341341} = "广东省汕头市";
$areanames{zh}->{861341342} = "广东省汕头市";
$areanames{zh}->{861341343} = "广东省汕头市";
$areanames{zh}->{861341344} = "广东省汕头市";
$areanames{zh}->{861341345} = "广东省清远市";
$areanames{zh}->{861341346} = "广东省清远市";
$areanames{zh}->{861341347} = "广东省清远市";
$areanames{zh}->{861341348} = "广东省清远市";
$areanames{zh}->{861341349} = "广东省清远市";
$areanames{zh}->{86134135} = "广东省清远市";
$areanames{zh}->{86134136} = "广东省湛江市";
$areanames{zh}->{86134137} = "广东省潮州市";
$areanames{zh}->{86134138} = "广东省肇庆市";
$areanames{zh}->{86134139} = "广东省揭阳市";
$areanames{zh}->{86134140} = "广东省汕头市";
$areanames{zh}->{861341410} = "广东省广州市";
$areanames{zh}->{861341411} = "广东省广州市";
$areanames{zh}->{861341412} = "广东省广州市";
$areanames{zh}->{861341413} = "广东省广州市";
$areanames{zh}->{861341414} = "广东省广州市";
$areanames{zh}->{861341415} = "广东省江门市";
$areanames{zh}->{861341416} = "广东省江门市";
$areanames{zh}->{861341417} = "广东省江门市";
$areanames{zh}->{861341418} = "广东省江门市";
$areanames{zh}->{861341419} = "广东省江门市";
$areanames{zh}->{86134142} = "广东省东莞市";
$areanames{zh}->{86134143} = "广东省东莞市";
$areanames{zh}->{861341440} = "广东省东莞市";
$areanames{zh}->{861341441} = "广东省东莞市";
$areanames{zh}->{861341442} = "广东省东莞市";
$areanames{zh}->{861341443} = "广东省东莞市";
$areanames{zh}->{861341444} = "广东省东莞市";
$areanames{zh}->{861341445} = "广东省深圳市";
$areanames{zh}->{861341446} = "广东省深圳市";
$areanames{zh}->{861341447} = "广东省深圳市";
$areanames{zh}->{861341448} = "广东省深圳市";
$areanames{zh}->{861341449} = "广东省深圳市";
$areanames{zh}->{86134145} = "广东省惠州市";
$areanames{zh}->{86134146} = "广东省惠州市";
$areanames{zh}->{86134147} = "广东省惠州市";
$areanames{zh}->{861341480} = "广东省揭阳市";
$areanames{zh}->{861341481} = "广东省揭阳市";
$areanames{zh}->{861341482} = "广东省揭阳市";
$areanames{zh}->{861341483} = "广东省揭阳市";
$areanames{zh}->{861341484} = "广东省揭阳市";
$areanames{zh}->{861341485} = "广东省湛江市";
$areanames{zh}->{861341486} = "广东省湛江市";
$areanames{zh}->{861341487} = "广东省湛江市";
$areanames{zh}->{861341488} = "广东省湛江市";
$areanames{zh}->{861341489} = "广东省湛江市";
$areanames{zh}->{86134149} = "广东省湛江市";
$areanames{zh}->{86134150} = "广东省汕头市";
$areanames{zh}->{86134151} = "广东省汕头市";
$areanames{zh}->{86134152} = "广东省清远市";
$areanames{zh}->{86134153} = "广东省中山市";
$areanames{zh}->{861341540} = "广东省中山市";
$areanames{zh}->{861341541} = "广东省中山市";
$areanames{zh}->{861341542} = "广东省中山市";
$areanames{zh}->{861341543} = "广东省中山市";
$areanames{zh}->{861341544} = "广东省中山市";
$areanames{zh}->{861341545} = "广东省佛山市";
$areanames{zh}->{861341546} = "广东省佛山市";
$areanames{zh}->{861341547} = "广东省佛山市";
$areanames{zh}->{861341548} = "广东省佛山市";
$areanames{zh}->{861341549} = "广东省佛山市";
$areanames{zh}->{86134155} = "广东省佛山市";
$areanames{zh}->{86134156} = "广东省韶关市";
$areanames{zh}->{861341570} = "广东省佛山市";
$areanames{zh}->{861341571} = "广东省佛山市";
$areanames{zh}->{861341572} = "广东省佛山市";
$areanames{zh}->{861341573} = "广东省佛山市";
$areanames{zh}->{861341574} = "广东省佛山市";
$areanames{zh}->{861341575} = "广东省肇庆市";
$areanames{zh}->{861341576} = "广东省肇庆市";
$areanames{zh}->{861341577} = "广东省肇庆市";
$areanames{zh}->{861341578} = "广东省肇庆市";
$areanames{zh}->{861341579} = "广东省肇庆市";
$areanames{zh}->{861341580} = "广东省茂名市";
$areanames{zh}->{861341581} = "广东省茂名市";
$areanames{zh}->{861341582} = "广东省茂名市";
$areanames{zh}->{861341583} = "广东省茂名市";
$areanames{zh}->{861341584} = "广东省茂名市";
$areanames{zh}->{861341585} = "广东省东莞市";
$areanames{zh}->{861341586} = "广东省东莞市";
$areanames{zh}->{861341587} = "广东省东莞市";
$areanames{zh}->{861341588} = "广东省东莞市";
$areanames{zh}->{861341589} = "广东省东莞市";
$areanames{zh}->{86134159} = "广东省东莞市";
$areanames{zh}->{86134160} = "广东省中山市";
$areanames{zh}->{86134161} = "广东省广州市";
$areanames{zh}->{86134162} = "广东省广州市";
$areanames{zh}->{86134163} = "广东省广州市";
$areanames{zh}->{86134164} = "广东省广州市";
$areanames{zh}->{86134165} = "广东省清远市";
$areanames{zh}->{86134166} = "广东省东莞市";
$areanames{zh}->{86134167} = "广东省东莞市";
$areanames{zh}->{86134168} = "广东省东莞市";
$areanames{zh}->{86134169} = "广东省东莞市";
$areanames{zh}->{86134170} = "广东省汕头市";
$areanames{zh}->{86134171} = "广东省汕头市";
$areanames{zh}->{86134172} = "广东省清远市";
$areanames{zh}->{86134173} = "广东省深圳市";
$areanames{zh}->{86134174} = "广东省深圳市";
$areanames{zh}->{86134175} = "广东省深圳市";
$areanames{zh}->{86134176} = "广东省揭阳市";
$areanames{zh}->{86134177} = "广东省珠海市";
$areanames{zh}->{86134178} = "广东省珠海市";
$areanames{zh}->{861341790} = "广东省珠海市";
$areanames{zh}->{861341791} = "广东省珠海市";
$areanames{zh}->{861341792} = "广东省珠海市";
$areanames{zh}->{861341793} = "广东省珠海市";
$areanames{zh}->{861341794} = "广东省珠海市";
$areanames{zh}->{861341795} = "广东省云浮市";
$areanames{zh}->{861341796} = "广东省云浮市";
$areanames{zh}->{861341797} = "广东省云浮市";
$areanames{zh}->{861341798} = "广东省云浮市";
$areanames{zh}->{861341799} = "广东省云浮市";
$areanames{zh}->{86134180} = "广东省广州市";
$areanames{zh}->{86134181} = "广东省广州市";
$areanames{zh}->{86134182} = "广东省东莞市";
$areanames{zh}->{86134183} = "广东省东莞市";
$areanames{zh}->{861341840} = "广东省佛山市";
$areanames{zh}->{861341841} = "广东省佛山市";
$areanames{zh}->{861341842} = "广东省佛山市";
$areanames{zh}->{861341843} = "广东省佛山市";
$areanames{zh}->{861341844} = "广东省佛山市";
$areanames{zh}->{861341845} = "广东省深圳市";
$areanames{zh}->{861341846} = "广东省深圳市";
$areanames{zh}->{861341847} = "广东省深圳市";
$areanames{zh}->{861341848} = "广东省深圳市";
$areanames{zh}->{861341849} = "广东省深圳市";
$areanames{zh}->{86134185} = "广东省深圳市";
$areanames{zh}->{86134186} = "广东省深圳市";
$areanames{zh}->{86134187} = "广东省深圳市";
$areanames{zh}->{86134188} = "广东省深圳市";
$areanames{zh}->{86134189} = "广东省深圳市";
$areanames{zh}->{861341900} = "四川省德阳市";
$areanames{zh}->{861341901} = "四川省德阳市";
$areanames{zh}->{861341902} = "四川省德阳市";
$areanames{zh}->{861341903} = "四川省德阳市";
$areanames{zh}->{861341904} = "四川省德阳市";
$areanames{zh}->{861341905} = "四川省达州市";
$areanames{zh}->{861341906} = "四川省达州市";
$areanames{zh}->{861341907} = "四川省达州市";
$areanames{zh}->{861341908} = "四川省达州市";
$areanames{zh}->{861341909} = "四川省达州市";
$areanames{zh}->{861341910} = "四川省南充市";
$areanames{zh}->{861341911} = "四川省南充市";
$areanames{zh}->{861341912} = "四川省南充市";
$areanames{zh}->{861341913} = "四川省南充市";
$areanames{zh}->{861341914} = "四川省南充市";
$areanames{zh}->{861341915} = "四川省泸州市";
$areanames{zh}->{861341916} = "四川省泸州市";
$areanames{zh}->{861341917} = "四川省泸州市";
$areanames{zh}->{861341918} = "四川省泸州市";
$areanames{zh}->{861341919} = "四川省泸州市";
$areanames{zh}->{86134192} = "四川省宜宾市";
$areanames{zh}->{861341920} = "四川省广元市";
$areanames{zh}->{861341921} = "四川省广元市";
$areanames{zh}->{861341922} = "四川省广元市";
$areanames{zh}->{861341930} = "四川省广安市";
$areanames{zh}->{861341931} = "四川省广安市";
$areanames{zh}->{861341932} = "四川省攀枝花市";
$areanames{zh}->{861341933} = "四川省攀枝花市";
$areanames{zh}->{861341934} = "四川省雅安市";
$areanames{zh}->{861341935} = "四川省雅安市";
$areanames{zh}->{861341936} = "四川省遂宁市";
$areanames{zh}->{861341937} = "四川省遂宁市";
$areanames{zh}->{861341938} = "四川省遂宁市";
$areanames{zh}->{861341939} = "四川省遂宁市";
$areanames{zh}->{861341940} = "四川省乐山市";
$areanames{zh}->{861341941} = "四川省乐山市";
$areanames{zh}->{861341942} = "四川省乐山市";
$areanames{zh}->{861341943} = "四川省乐山市";
$areanames{zh}->{861341944} = "四川省乐山市";
$areanames{zh}->{861341945} = "四川省巴中市";
$areanames{zh}->{861341946} = "四川省巴中市";
$areanames{zh}->{861341947} = "四川省巴中市";
$areanames{zh}->{861341948} = "四川省内江市";
$areanames{zh}->{861341949} = "四川省内江市";
$areanames{zh}->{86134195} = "湖北省武汉市";
$areanames{zh}->{86134196} = "湖北省武汉市";
$areanames{zh}->{861341970} = "河南省驻马店市";
$areanames{zh}->{861341971} = "河南省驻马店市";
$areanames{zh}->{861341972} = "河南省驻马店市";
$areanames{zh}->{861341973} = "河南省驻马店市";
$areanames{zh}->{861341974} = "河南省驻马店市";
$areanames{zh}->{861341975} = "河南省开封市";
$areanames{zh}->{861341976} = "河南省开封市";
$areanames{zh}->{861341977} = "河南省开封市";
$areanames{zh}->{861341978} = "河南省开封市";
$areanames{zh}->{861341979} = "河南省开封市";
$areanames{zh}->{861341980} = "河南省三门峡市";
$areanames{zh}->{861341981} = "河南省三门峡市";
$areanames{zh}->{861341982} = "河南省三门峡市";
$areanames{zh}->{861341983} = "河南省三门峡市";
$areanames{zh}->{861341984} = "河南省三门峡市";
$areanames{zh}->{861341985} = "河南省新乡市";
$areanames{zh}->{861341986} = "河南省新乡市";
$areanames{zh}->{861341987} = "河南省新乡市";
$areanames{zh}->{861341988} = "河南省新乡市";
$areanames{zh}->{861341989} = "河南省新乡市";
$areanames{zh}->{861341990} = "河南省南阳市";
$areanames{zh}->{861341991} = "河南省南阳市";
$areanames{zh}->{861341992} = "河南省南阳市";
$areanames{zh}->{861341993} = "河南省南阳市";
$areanames{zh}->{861341994} = "河南省南阳市";
$areanames{zh}->{861341995} = "河南省信阳市";
$areanames{zh}->{861341996} = "河南省信阳市";
$areanames{zh}->{861341997} = "河南省信阳市";
$areanames{zh}->{861341998} = "河南省信阳市";
$areanames{zh}->{861341999} = "河南省信阳市";
$areanames{zh}->{86134200} = "广东省中山市";
$areanames{zh}->{86134201} = "广东省湛江市";
$areanames{zh}->{86134202} = "广东省中山市";
$areanames{zh}->{86134203} = "广东省中山市";
$areanames{zh}->{86134204} = "广东省中山市";
$areanames{zh}->{86134205} = "广东省韶关市";
$areanames{zh}->{86134206} = "广东省佛山市";
$areanames{zh}->{86134207} = "广东省佛山市";
$areanames{zh}->{86134208} = "广东省佛山市";
$areanames{zh}->{86134209} = "广东省深圳市";
$areanames{zh}->{861342100} = "广东省梅州市";
$areanames{zh}->{861342101} = "广东省梅州市";
$areanames{zh}->{861342102} = "广东省梅州市";
$areanames{zh}->{861342103} = "广东省梅州市";
$areanames{zh}->{861342104} = "广东省梅州市";
$areanames{zh}->{861342105} = "广东省潮州市";
$areanames{zh}->{861342106} = "广东省潮州市";
$areanames{zh}->{861342107} = "广东省潮州市";
$areanames{zh}->{861342108} = "广东省潮州市";
$areanames{zh}->{861342109} = "广东省潮州市";
$areanames{zh}->{86134211} = "广东省揭阳市";
$areanames{zh}->{86134212} = "广东省阳江市";
$areanames{zh}->{86134213} = "广东省深圳市";
$areanames{zh}->{86134214} = "广东省中山市";
$areanames{zh}->{86134215} = "广东省汕尾市";
$areanames{zh}->{86134216} = "广东省惠州市";
$areanames{zh}->{861342170} = "广东省湛江市";
$areanames{zh}->{861342171} = "广东省湛江市";
$areanames{zh}->{861342172} = "广东省湛江市";
$areanames{zh}->{861342173} = "广东省湛江市";
$areanames{zh}->{861342174} = "广东省湛江市";
$areanames{zh}->{861342175} = "广东省阳江市";
$areanames{zh}->{861342176} = "广东省阳江市";
$areanames{zh}->{861342177} = "广东省云浮市";
$areanames{zh}->{861342178} = "广东省云浮市";
$areanames{zh}->{861342179} = "广东省云浮市";
$areanames{zh}->{861342180} = "广东省深圳市";
$areanames{zh}->{861342181} = "广东省深圳市";
$areanames{zh}->{861342182} = "广东省深圳市";
$areanames{zh}->{861342183} = "广东省深圳市";
$areanames{zh}->{861342184} = "广东省深圳市";
$areanames{zh}->{861342185} = "广东省汕头市";
$areanames{zh}->{861342186} = "广东省汕头市";
$areanames{zh}->{861342187} = "广东省汕头市";
$areanames{zh}->{861342188} = "广东省汕头市";
$areanames{zh}->{861342189} = "广东省汕头市";
$areanames{zh}->{86134219} = "广东省东莞市";
$areanames{zh}->{86134220} = "广东省广州市";
$areanames{zh}->{86134221} = "广东省广州市";
$areanames{zh}->{86134222} = "广东省广州市";
$areanames{zh}->{86134223} = "广东省广州市";
$areanames{zh}->{861342240} = "广东省惠州市";
$areanames{zh}->{861342241} = "广东省惠州市";
$areanames{zh}->{861342242} = "广东省惠州市";
$areanames{zh}->{861342243} = "广东省惠州市";
$areanames{zh}->{861342244} = "广东省惠州市";
$areanames{zh}->{861342245} = "广东省珠海市";
$areanames{zh}->{861342246} = "广东省珠海市";
$areanames{zh}->{861342247} = "广东省汕头市";
$areanames{zh}->{861342248} 