package Bio::FastParsers::Blast::Xml::Iteration;
# ABSTRACT: NCBI BLAST DTD-derived internal class
$Bio::FastParsers::Blast::Xml::Iteration::VERSION = '0.180330';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);

use aliased 'Bio::FastParsers::Blast::Xml::Hit';
use aliased 'Bio::FastParsers::Blast::Xml::Statistics';


# private attributes

has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);


# public array(s) of composed objects


has 'hits' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::FastParsers::Blast::Xml::Hit]',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_hits',
    handles  => {
        count_hits => 'count',
          all_hits => 'elements',
          get_hit  => 'get',
         next_hit  => 'shift',
    },
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_hits {
    my $self = shift;
    return [ map { Hit->new( _root => $_ ) } @{
        forcearray $self->_root->{'Iteration_hits'}->{'Hit'}
    } ];
}

## use critic



# public composed object(s)


has 'stat' => (
    is       => 'ro',
    isa      => 'Bio::FastParsers::Blast::Xml::Statistics',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_stat',
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_stat {
    my $self = shift;
    return Statistics->new(
        _root => $self->_root->{'Iteration_stat'}->{'Statistics'}
    );
}

# use critic


# public methods


sub iter_num {
    return shift->_root->{'Iteration_iter-num'}->{'value'}
}


sub message {
    return shift->_root->{'Iteration_message'}->{'value'}
}


sub query_def {
    return shift->_root->{'Iteration_query-def'}->{'value'}
}


sub query_id {
    return shift->_root->{'Iteration_query-ID'}->{'value'}
}


sub query_len {
    return shift->_root->{'Iteration_query-len'}->{'value'}
}


# public aliases


sub statistics {
    return shift->stat
}


sub num {
    return shift->iter_num
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::FastParsers::Blast::Xml::Iteration - NCBI BLAST DTD-derived internal class

=head1 VERSION

version 0.180330

=head1 SYNOPSIS

    # TODO

=head1 DESCRIPTION

    # TODO

=head1 ATTRIBUTES

=head2 hits

ArrayRef of L<Bio::FastParsers::Blast::Xml::Hit>

=head2 stat

L<Bio::FastParsers::Blast::Xml::Statistics> composed object

=head1 METHODS

=head2 count_hits

Returns the number of Hits of the Iteration.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $count = $iteration->count_hits;

This method does not accept any arguments.

=head2 all_hits

Returns all the Hits of the Iteration (not an array reference).

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my @hits = $iteration->all_hits;

This method does not accept any arguments.

=head2 get_hit

Returns one Hit of the Iteration by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Hit does not exist, this method will return C<undef>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $hit = $iteration->get_hit($index);
    croak "Hit $index not found!" unless defined $hit;

This method accepts just one argument (and not an array slice).

=head2 next_hit

Shifts the first Hit of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Hits in
the array, returns C<undef>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    while (my $hit = $iteration->next_hit) {
        # process $hit
        # ...
    }

This method does not accept any arguments.

=head2 iter_num

Returns the value of the element C<<Iteration_iter-num>>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $iter_num = $iteration->iter_num;

This method does not accept any arguments.

=head2 message

Returns the value of the element C<<Iteration_message>>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $message = $iteration->message;

This method does not accept any arguments.

=head2 query_def

Returns the value of the element C<<Iteration_query-def>>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $query_def = $iteration->query_def;

This method does not accept any arguments.

=head2 query_id

Returns the value of the element C<<Iteration_query-ID>>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $query_id = $iteration->query_id;

This method does not accept any arguments.

=head2 query_len

Returns the value of the element C<<Iteration_query-len>>.

    # $iteration is a Bio::FastParsers::Blast::Xml::Iteration
    my $query_len = $iteration->query_len;

This method does not accept any arguments.

=head1 ALIASES

=head2 statistics

Alias for C<stat> method. For API consistency.

=head2 num

Alias for C<iter_num> method. For API consistency.

=head1 AUTHOR

Denis BAURAIN <denis.baurain@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by University of Liege / Unit of Eukaryotic Phylogenomics / Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
