# Copyright (C) 2001-2004 Daniel Berrange <dan@berrange.com>
#
# $Id: Test-AutoBuild.spec.PL,v 1.3 2004/04/30 11:44:48 danpb Exp $

use strict;

die unless (scalar @ARGV == 1);

unless (do "lib/Test/AutoBuild.pm")
  {
    if ($@) { die $@ }
    die "lib/Test/AutoBuild.pm: $!"
  }

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$Test::AutoBuild::VERSION/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by perl-Test-AutoBuild.spec.PL

%define perlvendorarch %(perl -e 'use Config; print $Config{installvendorarch}')
%define perlvendorlib %(perl -e 'use Config; print $Config{installvendorlib}')
%define perlvendorprefix %(perl -e 'use Config; print $Config{vendorprefix}')
%define perlvendorman3 %{perlvendorprefix}/share/man/man3
%define perlversion %(perl -e 'use Config; print $Config{version}')

%define appname Test-AutoBuild

Summary: Framework for performing continuous, unattended, automated software builds
Name: perl-%{appname}
Version: @VERSION@
Release: 1
Copyright: GPL
Group: Applications/Internet
Source: %{appname}-%{version}.tar.gz
BuildRoot: /var/tmp/%{appname}-%{version}-root
BuildArchitectures: noarch
Requires: perl >= %{perlversion}
Requires: perl-BSD-Resource >= 1.15
Requires: perl-Config-Record >= 1.0.0


%description
Test-AutoBuild is a PERL framework for performing continuous, unattended, 
automated software builds

%prep
%setup -q -n %{appname}-%{version}

%build
perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/usr INSTALLDIRS=vendor
make

%install
rm -rf $RPM_BUILD_ROOT

make sysconfdir=$RPM_BUILD_ROOT/etc INSTALLvendorMAN3DIR=$RPM_BUILD_ROOT%{perlvendorman3} install
find $RPM_BUILD_ROOT%{perlvendorarch} -name perllocal.pod -exec rm -f {} \;


install -d -m 0755 $RPM_BUILD_ROOT/var/builder/build-home
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/build-root
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/build-cache

install -d -m 0755 $RPM_BUILD_ROOT/var/builder/public_html
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/public_ftp

install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/BUILD
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/noarch
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/i386
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/i486
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/i586
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/i686
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/i786
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/RPMS/sparc
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/SPECS
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/SOURCES
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/rpm/SRPMS
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/zips
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/tars
install -d -m 0755 $RPM_BUILD_ROOT/var/builder/packages/debian

echo "/1 :pserver:anonymous@cvs.gna.org:2401/cvs/testautobuild A" >> $RPM_BUILD_ROOT/var/builder/.cvspass
chmod 0600 $RPM_BUILD_ROOT/var/builder/.cvspass

%clean
rm -rf $RPM_BUILD_ROOT

%pre
id builder > /dev/null 2>&1 || useradd -d /var/builder builder

%files
%defattr(-,root,root)
%doc AUTHORS
%doc README
%doc COPYING
%doc CHANGES

# Man pages
%{perlvendorman3}/*

# Config
%config(noreplace) /etc/auto-build.d/auto-build.conf
%config /etc/auto-build.d/auto-build.cron
%config(noreplace) /etc/auto-build.d/templates/*

# Scripts & modules
%{perlvendorprefix}/bin/auto-build.pl
%{perlvendorlib}/Test/AutoBuild.pm
%{perlvendorlib}/Test/AutoBuild/
#%{perlvendorarch}/auto/Test-AutoBuild/

# Builder home
%attr(-,builder,builder) /var/builder

