/* This file is meant to be loaded by utility.c */

struct _class_poly {
  unsigned int    D;
  unsigned short  type;
  unsigned short  degree;
  const char *coefs;
};
/* Type:  1 = Hilbert, 2 = Weber */
static const struct _class_poly _class_poly_data[] =
{
  { 3, 1, 1, "\x00" },
  { 4, 1, 1, "\x81\x0c" },
  { 7, 1, 1, "\x01\x0f" },
  { 8, 1, 1, "\x81\x14" },
  { 11, 1, 1, "\x01\x20" },
  { 15, 2, 2, "\x81\x01\x81\x01" },
  { 19, 1, 1, "\x01\x60" },
  { 20, 2, 2, "\x81\x01\x81\x01" },
  { 23, 2, 3, "\x81\x01\x81\x01\x00" },
  { 24, 2, 2, "\x81\x01\x81\x02" },
  { 31, 2, 3, "\x81\x01\x00\x81\x01" },
  { 35, 1, 2, "\x82\x14\x00\x04\x07\x08\x00\x00" },
  { 39, 2, 4, "\x81\x01\x81\x02\x81\x04\x81\x03" },
  { 40, 2, 2, "\x81\x01\x81\x01" },
  { 43, 1, 1, "\x02\x03\xc0" },
  { 47, 2, 5, "\x81\x01\x81\x02\x81\x02\x81\x01\x00" },
  { 51, 1, 2, "\x02\x48\x00\x05\x01\x4a\x46\x80\x00" },
  { 52, 2, 2, "\x81\x01\x81\x03" },
  { 55, 2, 4, "\x81\x01\x01\x01\x00\x81\x02" },
  { 56, 2, 4, "\x01\x01\x81\x02\x01\x01\x81\x02" },
  { 59, 1, 3, "\x03\x0b\x00\x00\x86\x80\x11\x40\x00\x00\x00\x05\x07\x07\xec\x00\x00" },
  { 67, 1, 1, "\x02\x14\xa0" },
  { 68, 2, 4, "\x01\x01\x81\x01\x81\x02\x81\x01" },
  { 71, 2, 7, "\x81\x01\x81\x01\x01\x01\x01\x01\x01\x01\x81\x01\x81\x02" },
  { 79, 2, 5, "\x81\x01\x01\x01\x81\x01\x01\x02\x81\x03" },
  { 83, 1, 3, "\x03\x7d\x00\x00\x87\x93\x66\xfc\x40\x00\x00\x00\x06\x02\x72\xc2\x32\x00\x00" },
  { 84, 2, 4, "\x01\x01\x01\xa8\x01\x8e\x81\xa8" },
  { 87, 2, 6, "\x81\x01\x81\x01\x81\x04\x01\x04\x81\x0b\x81\x0d" },
  { 88, 2, 2, "\x81\x01\x81\x02" },
  { 91, 1, 2, "\x83\x02\x64\x00\x06\x09\x6b\xe8\xde\x00\x00" },
  { 95, 2, 8, "\x81\x01\x01\x01\x00\x81\x01\x01\x02\x01\x01\x81\x02\x81\x02" },
  { 103, 2, 5, "\x81\x01\x81\x02\x81\x03\x81\x03\x81\x01" },
  { 104, 2, 6, "\x81\x01\x81\x02\x01\x02\x00\x81\x02\x81\x02" },
  { 107, 1, 3, "\x04\x04\x26\x80\x00\x88\x5d\xe0\x69\xf9\x40\x00\x00\x00\x06\x76\x09\x86\x47\x80\x00" },
  { 111, 2, 8, "\x81\x01\x81\x01\x81\x06\x81\x0b\x01\x04\x01\x0e\x81\x1a\x81\x15" },
  { 115, 1, 2, "\x03\x07\xbc\x00\x07\x01\x85\x23\xfe\x2a\x00\x00" },
  { 116, 2, 6, "\x81\x01\x81\x09\x81\x05\x01\x02\x01\x05\x81\x09" },
  { 119, 2, 10, "\x01\x01\x81\x01\x01\x02\x81\x04\x01\x05\x81\x07\x01\x09\x81\x08\x01\x05\x81\x04" },
  { 120, 2, 4, "\x01\x01\x81\x18\x81\x36\x81\x18" },
  { 123, 1, 2, "\x03\x50\xdc\x00\x07\x04\xcf\x96\xe1\x68\x00\x00" },
  { 127, 2, 5, "\x81\x01\x01\x01\x01\x02\x81\x01\x81\x03" },
  { 131, 1, 5, "\x05\x0c\x38\x00\x00\x00\x8c\xc3\x04\x38\xbc\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x58\xad\xa4\xf2\xb9\xa0\x00\x00\x00\x00\x00\x89\x24\x62\x74\x24\x41\x40\x00\x00\x00\x07\x0e\xac\xa7\xaa\x63\x80\x00" },
  { 132, 2, 4, "\x01\x01\x81\x1e\x81\x46\x81\x1e" },
  { 136, 2, 4, "\x01\x01\x81\x03\x00\x81\x03" },
  { 139, 1, 3, "\x04\x02\x6d\x00\x00\x89\x02\xe0\x1a\x48\x06\xc0\x00\x00\x00\x07\x2b\x48\x85\x2d\xc1\x00\x00" },
  { 143, 2, 10, "\x81\x01\x01\x03\x81\x06\x01\x06\x81\x03\x81\x03\x01\x09\x81\x0d\x01\x0c\x81\x06" },
  { 148, 2, 2, "\x81\x01\x81\x0c" },
  { 151, 2, 7, "\x81\x01\x81\x01\x81\x01\x00\x81\x03\x81\x01\x81\x03" },
  { 152, 2, 6, "\x81\x01\x81\x04\x00\x01\x06\x00\x81\x04" },
  { 155, 1, 4, "\x05\x07\xc9\xc0\x00\x00\x0c\x41\xe7\x62\x49\xbb\x10\x00\x00\x00\x00\x00\x00\x8a\x09\x6b\x26\x75\x0c\x46\xc0\x00\x00\x00\x08\x01\x58\x47\x13\xf0\x5b\x00\x00" },
  { 159, 2, 10, "\x81\x01\x01\x01\x81\x01\x81\x07\x81\x3f\x81\x79\x81\xdb\x81\xc4\x81\x92\x81\x2f" },
  { 163, 1, 1, "\x03\x09\xc5\x40" },
  { 164, 2, 8, "\x01\x01\x81\x05\x01\x07\x81\x0c\x01\x0e\x81\x0c\x01\x07\x81\x05" },
  { 167, 2, 11, "\x81\x01\x81\x01\x81\x05\x81\x04\x81\x0a\x81\x06\x81\x0b\x81\x07\x81\x09\x81\x04\x81\x02" },
  { 168, 2, 4, "\x01\x01\x01\x38\x81\x52\x81\x38" },
  { 179, 1, 5, "\x06\x03\xbc\xa8\x00\x00\x00\x8f\x04\x82\x24\xc7\x5d\x7b\xf8\x90\x00\x00\x00\x00\x00\x00\x00\x0d\x21\xbb\x85\xc7\xd6\xe9\xfa\xc0\x00\x00\x00\x00\x00\x8b\x01\xd1\xed\x0d\x19\xa9\xf0\x00\x00\x00\x00\x08\x18\xe9\xcf\xef\x3e\xf9\x00\x00" },
  { 183, 2, 8, "\x81\x01\x81\x01\x01\x0b\x01\x0a\x81\x62\x01\x9d\x81\x35\x81\x47" },
  { 184, 2, 4, "\x01\x01\x81\x06\x01\x09\x81\x06" },
  { 187, 1, 2, "\x83\xef\x10\x00\x08\x3f\x14\x47\x5b\x65\x24\x80\x00" },
  { 191, 2, 13, "\x81\x01\x01\x02\x00\x81\x04\x01\x05\x81\x01\x81\x05\x01\x0b\x81\x13\x01\x16\x81\x10\x01\x0a\x81\x06" },
  { 195, 1, 4, "\x85\x0e\x56\x50\x00\x00\x0d\x01\x52\x8a\x46\xfd\x3a\x45\x40\x00\x00\x00\x00\x00\x0b\x14\xf7\xe3\xad\x05\xbb\xdd\x00\x00\x00\x00\x08\x9c\x9a\x48\x7a\x35\xdf\x00\x00" },
  { 199, 2, 9, "\x81\x01\x81\x01\x00\x81\x03\x00\x00\x81\x03\x01\x03\x81\x05" },
  { 203, 1, 4, "\x05\x49\xda\x40\x00\x00\x0e\x0c\x5b\x72\x23\x61\xbc\xf4\x40\x00\x00\x00\x00\x00\x00\x8b\x44\xb3\x36\xe7\xbd\x25\x71\x40\x00\x00\x00\x09\x01\x7d\xac\x30\x8d\x07\xc4\x00\x00" },
  { 211, 1, 3, "\x04\x67\xfe\x00\x00\x0a\x3a\xbd\x5f\x8f\x2b\x18\xc0\x00\x00\x00\x09\x03\x92\x2d\xfe\xa0\x33\x7c\x00\x00" },
  { 212, 2, 6, "\x81\x01\x81\x17\x81\x0c\x81\x4b\x01\x0c\x81\x17" },
  { 215, 2, 14, "\x81\x01\x01\x02\x00\x81\x06\x01\x03\x01\x08\x81\x0d\x81\x04\x01\x10\x81\x07\x81\x0d\x01\x0b\x01\x04\x81\x06" },
  { 219, 1, 4, "\x05\x6f\xe3\xa0\x00\x00\x8d\xc9\xb1\x36\x8a\x9f\xf0\x2c\xa0\x00\x00\x00\x00\x00\x0c\x02\xaf\x6b\x60\xe1\xe4\x44\x86\xc0\x00\x00\x00\x09\x08\x6a\x00\xf2\x0f\x9b\x84\x80\x00" },
  { 223, 2, 7, "\x81\x01\x00\x81\x01\x81\x04\x01\x01\x00\x81\x05" },
  { 227, 1, 5, "\x06\x0f\xa3\xe8\x00\x00\x00\x90\x01\x96\x96\x29\xdf\x46\x91\xda\x70\x00\x00\x00\x00\x00\x00\x00\x0f\x03\x82\xad\x62\x96\xb9\x49\x55\xbc\x00\x00\x00\x00\x00\x00\x8c\x08\x47\x81\xd9\x27\x8c\x8d\x66\x80\x00\x00\x00\x09\x13\x85\x27\x6f\x9b\x5c\xb0\x00\x00" },
  { 228, 2, 4, "\x01\x01\x81\x82\x82\x01\x86\x81\x82" },
  { 231, 2, 12, "\x01\x01\x81\x04\x01\x1d\x81\x2d\x01\x72\x81\x20\x81\x76\x02\x01\x5d\x82\x02\xd4\x02\x02\x05\x81\x21\x81\x8a" },
  { 232, 2, 2, "\x81\x01\x81\x05" },
  { 235, 1, 2, "\x04\x0d\xa0\x34\x00\x09\x2c\x9f\xe1\xad\x9b\xbd\xc3\x00\x00" },
  { 239, 2, 15, "\x81\x01\x01\x04\x81\x04\x81\x04\x01\x05\x01\x0d\x81\x14\x81\x04\x01\x0f\x01\x0d\x81\x1b\x01\x04\x01\x08\x01\x02\x81\x06" },
  { 244, 2, 6, "\x81\x01\x81\x1e\x81\x06\x81\x30\x01\x06\x81\x1e" },
  { 247, 2, 6, "\x81\x01\x81\x03\x81\x06\x81\x07\x81\x07\x81\x04" },
  { 248, 2, 8, "\x01\x01\x81\x02\x81\x0d\x81\x1e\x81\x24\x81\x1e\x81\x0d\x81\x02" },
  { 251, 1, 7, "\x08\x01\xba\xe8\x90\x00\x00\x00\x00\x95\x01\x39\xe0\x17\xbb\xe0\x49\xc7\xf9\xc4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x12\xa8\xf4\xe3\x6a\x21\xaf\xc1\xd0\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x17\x69\x5e\x4b\xf1\x63\xf5\xb4\x46\x30\x00\x00\x00\x00\x00\x00\x00\x0f\xcc\x89\x14\x96\x16\x99\x12\x8e\x96\x00\x00\x00\x00\x00\x00\x8c\xd5\xea\xd1\x90\x75\xb6\x2b\x7c\xc0\x00\x00\x00\x09\xdf\xcd\xb3\x40\xa5\x7a\xbe\x00\x00" },
  { 255, 2, 12, "\x01\x01\x81\x0b\x01\x42\x81\xdd\x02\x02\x01\x82\x03\x90\x02\x03\xf4\x82\x01\x1f\x82\x02\xbe\x02\x03\x47\x81\xc2\x81\xba" },
  { 259, 1, 4, "\x05\x26\x1b\x70\x00\x00\x0d\x45\x55\xdf\xf9\x45\x98\x82\x40\x00\x00\x00\x00\x00\x8c\x01\x30\x8f\x27\x46\xe1\xea\x98\x00\x00\x00\x00\x0a\x01\xeb\xa1\xa7\x44\x5b\x52\x9b\x00\x00" },
  { 260, 2, 8, "\x01\x01\x81\x08\x01\x0c\x01\x08\x81\x1b\x01\x08\x01\x0c\x81\x08" },
  { 263, 2, 13, "\x81\x01\x01\x06\x81\x0f\x01\x15\x81\x13\x01\x0d\x81\x0c\x01\x16\x81\x24\x01\x26\x81\x1b\x01\x10\x81\x08" },
  { 264, 2, 8, "\x01\x01\x81\xcc\x82\x03\xcc\x82\x06\xb4\x82\x09\x6a\x82\x06\xb4\x82\x03\xcc\x81\xcc" },
  { 267, 1, 2, "\x05\x01\xe2\xcb\x50\x00\x0a\x04\x2b\x05\xc5\xab\xcb\x90\xb9\x80\x00" },
  { 271, 2, 11, "\x81\x01\x00\x81\x01\x81\x01\x81\x03\x01\x03\x01\x06\x01\x03\x81\x05\x81\x06\x81\x05" },
  { 276, 2, 8, "\x01\x01\x02\xe2\xb0\x03\x09\x19\xdc\x03\x07\x26\xf0\x03\x14\x15\x46\x83\x07\x26\xf0\x03\x09\x19\xdc\x82\xe2\xb0" },
  { 280, 2, 4, "\x01\x01\x01\x06\x81\x03\x81\x06" },
  { 283, 1, 3, "\x05\x01\x5d\x5d\x80\x00\x0b\x4b\x23\xf4\xe1\x43\x46\xca\xc0\x00\x00\x00\x0a\x12\xf9\xd6\xee\x5f\x2f\x57\x7c\x80\x00" },
  { 287, 2, 14, "\x01\x01\x01\x01\x01\x03\x81\x01\x81\x01\x00\x01\x02\x01\x06\x81\x08\x81\x07\x81\x05\x01\x06\x01\x09\x81\x08" },
  { 291, 1, 4, "\x06\x19\x66\x62\xc0\x00\x00\x0f\x36\xf6\xc6\x86\x91\xb9\x98\xb9\x88\x20\x00\x00\x00\x00\x00\x0d\x88\x25\x58\x96\x0b\x2a\x30\x0a\xde\xc0\x00\x00\x00\x0a\x27\xd7\xef\x08\xe7\xbd\xfb\xb9\x80\x00" },
  { 292, 2, 4, "\x01\x01\x81\x05\x81\x0a\x81\x05" },
  { 295, 2, 8, "\x81\x01\x01\x03\x81\x07\x01\x0a\x81\x07\x81\x01\x01\x09\x81\x08" },
  { 296, 2, 10, "\x81\x01\x81\x08\x81\x09\x81\x04\x81\x09\x81\x04\x01\x09\x81\x04\x01\x09\x81\x08" },
  { 299, 1, 8, "\x89\x01\x6d\x89\x4c\x00\x00\x00\x00\x00\x18\x01\xde\x26\x04\xd0\x9a\x59\xc8\x02\xd0\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x33\x56\x89\x7d\x4a\x31\x14\x4e\xfa\x1e\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x04\x64\x0a\x91\x26\x2f\x6e\x8a\xe5\x36\x50\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x08\x5d\x75\x20\xc4\x2e\x76\x09\x7c\xce\x40\x50\x00\x00\x00\x00\x00\x00\x00\x11\x06\x27\x64\x66\xe5\x20\xf3\x12\x53\x54\xa6\x00\x00\x00\x00\x00\x00\x8e\x01\x69\x6d\x95\x2c\xb6\x69\xba\x25\xab\xc0\x00\x00\x00\x0a\x52\xd0\xd4\xf9\x3e\x14\x9c\x4c\x00\x00" },
  { 303, 2, 10, "\x81\x01\x81\x02\x81\x24\x81\x2e\x81\xad\x82\x01\xbf\x82\x02\xd0\x82\x02\xf4\x82\x05\x16\x82\x01\x45" },
  { 307, 1, 3, "\x05\x04\xd7\x42\x00\x00\x8c\x10\x6d\x18\x00\xf2\x4a\xf9\xd8\x00\x00\x00\x00\x0a\xaa\x78\x0c\x7f\xb1\x36\x22\x3f\x80\x00" },
  { 308, 2, 8, "\x01\x01\x01\x2e\x81\xab\x01\x2e\x02\x01\x64\x81\x2e\x81\xab\x81\x2e" },
  { 311, 2, 19, "\x81\x01\x81\x01\x81\x02\x81\x05\x81\x08\x81\x0e\x81\x0d\x81\x0a\x01\x01\x01\x09\x01\x12\x01\x19\x01\x0a\x81\x04\x81\x26\x81\x2a\x81\x25\x81\x10\x81\x04" },
  { 312, 2, 4, "\x01\x01\x82\x01\x68\x82\x05\x76\x82\x01\x68" },
  { 319, 2, 10, "\x81\x01\x81\x05\x81\x0b\x81\x0e\x81\x0a\x81\x02\x81\x01\x81\x05\x81\x09\x81\x06" },
  { 323, 1, 4, "\x87\x01\xc3\x0c\x71\xe0\x00\x00\x11\xd8\xe4\x61\x9e\xec\x56\x22\x92\x7b\x92\xd7\xa0\x00\x00\x00\x00\x00\x8e\x18\x65\xd5\xe6\x06\xa2\x65\x5b\x4e\xc3\x40\x00\x00\x00\x0b\x02\xbe\x90\x72\xf9\xd5\xd0\x4e\x13\x80\x00" },
  { 327, 2, 12, "\x81\x01\x81\x0e\x81\x3f\x81\x3a\x01\xae\x01\x5c\x82\x05\x9c\x82\x0f\xa6\x82\x15\x94\x82\x12\xec\x82\x0a\x0d\x82\x01\xa7" },
  { 328, 2, 4, "\x01\x01\x81\x09\x01\x0c\x81\x09" },
  { 331, 1, 3, "\x05\x59\x2b\xd0\x80\x00\x0d\x04\xa7\x6e\x3f\xa2\x56\x09\x40\x52\xc0\x00\x00\x00\x0b\x05\x7f\xa4\x88\x51\x69\x5d\xe1\x49\x80\x00" },
  { 335, 2, 18, "\x81\x01\x81\x05\x81\x0e\x81\x19\x81\x21\x81\x2a\x81\x40\x81\x66\x81\x90\x81\xab\x81\xb3\x81\xae\x81\xa3\x81\x90\x81\x6a\x81\x37\x81\x14\x81\x04" },
  { 339, 1, 6, "\x08\x01\x09\xe3\x87\x00\x00\x00\x00\x14\x13\xfa\x51\xd3\x61\x5f\xa6\x30\x46\x67\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x01\x80\x7f\xa9\xc4\xed\xb7\x3e\x27\xf7\x90\x90\x00\x00\x00\x00\x00\x00\x00\x91\x01\x8d\x2b\x09\x62\xfb\x78\xc1\xa8\x65\xaf\x80\x00\x00\x00\x00\x00\x0e\x99\xd1\xd7\xde\x0f\x8c\x10\x61\xc1\x3d\x80\x00\x00\x00\x0b\x0a\xec\xe0\x1b\x45\x9b\xa0\xe4\x8e\x00\x00" },
  { 340, 2, 4, "\x01\x01\x01\x3f\x01\x22\x81\x3f" },
  { 344, 2, 10, "\x81\x01\x81\x08\x81\x02\x81\x12\x81\x09\x81\x04\x01\x09\x81\x12\x01\x02\x81\x08" },
  { 347, 1, 5, "\x07\x14\x3d\x80\xd8\x00\x00\x00\x93\x03\x72\x56\xa0\x8f\x25\x81\xfc\x3d\x65\x18\x50\x00\x00\x00\x00\x00\x00\x00\x12\x1a\x3f\xc3\xb2\xf4\x0b\x6e\xd3\x3d\x75\x98\x1c\x40\x00\x00\x00\x00\x00\x8f\x01\x7c\x65\x84\x0a\x49\xfb\x46\x03\x81\x79\x00\x00\x00\x00\x0b\x15\x88\x97\x25\x3a\xd8\x8d\xe0\x83\x00\x00" },
  { 355, 1, 4, "\x06\x05\x03\x6c\x40\x00\x00\x8f\x04\x9f\xf8\x4b\x50\x38\x5a\xdf\xdc\x00\x00\x00\x00\x00\x00\x0d\x56\x31\x78\x30\x73\xd0\xba\x84\x4f\xc0\x00\x00\x00\x0b\x2a\x1d\x09\x83\xf6\x1d\xce\x12\x46\x00\x00" },
  { 356, 2, 12, "\x01\x01\x81\x05\x81\x15\x81\x32\x81\x41\x81\x51\x81\x46\x81\x51\x81\x41\x81\x32\x81\x15\x81\x05" },
  { 359, 2, 19, "\x81\x01\x01\x02\x81\x02\x01\x02\x01\x03\x81\x0e\x01\x07\x01\x16\x81\x1e\x01\x09\x81\x05\x01\x02\x01\x33\x81\x5a\x01\x13\x01\x5b\x81\x71\x01\x3b\x81\x0e" },
  { 367, 2, 9, "\x81\x01\x01\x02\x01\x01\x81\x06\x01\x02\x00\x81\x02\x01\x03\x81\x09" },
  { 371, 1, 8, "\x09\x65\x13\x2f\x14\x00\x00\x00\x00\x00\x9a\x05\xdf\x6e\x7f\x25\x86\xf3\x9a\x47\x2d\x28\x9a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x01\x44\x70\x71\xe6\x2f\x59\xe6\x04\x3c\x6b\x89\x7f\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x15\x9d\x44\x67\xda\x1b\x95\xeb\x4e\x8a\xb5\xcc\x2b\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x04\xe8\x4e\x62\xce\x68\x2e\x11\x26\x83\x40\xf1\xd0\x30\x00\x00\x00\x00\x00\x00\x00\x13\x02\xd3\x73\x97\xcc\x3e\xf4\x51\x8b\x5d\x64\xe3\x1f\x00\x00\x00\x00\x00\x00\x8f\x15\x18\xc2\xe5\xa6\x6b\x7e\x9a\xa6\xa9\x08\xc0\x00\x00\x00\x0b\x9d\x85\xf8\x6b\x47\x0e\x7e\x43\xca\x00\x00" },
  { 372, 2, 4, "\x01\x01\x03\x07\x3b\x48\x03\x8c\xa5\x0e\x83\x07\x3b\x48" },
  { 376, 2, 8, "\x01\x01\x81\x06\x81\x15\x81\x2a\x81\x34\x81\x2a\x81\x15\x81\x06" },
  { 379, 1, 3, "\x06\x02\x43\xd0\xb6\x00\x00\x8e\x05\xfe\x66\xb7\xd5\x92\xd4\xc1\x8e\x25\x40\x00\x00\x00\x0c\x01\x2d\x6b\xba\x70\x4e\x88\xe4\x80\x44\x00\x00" },
  { 383, 2, 17, "\x81\x01\x01\x01\x01\x01\x01\x01\x00\x81\x01\x81\x0d\x81\x07\x81\x0b\x81\x04\x81\x01\x81\x07\x81\x17\x81\x1f\x81\x2a\x81\x18\x81\x06" },
  { 388, 2, 4, "\x01\x01\x81\x09\x81\x02\x81\x09" },
  { 391, 2, 14, "\x01\x01\x00\x81\x05\x81\x05\x01\x07\x01\x0f\x01\x06\x81\x08\x81\x03\x01\x04\x00\x81\x0c\x81\x0c\x81\x08" },
  { 395, 1, 8, "\x09\xe5\x77\x3f\x7c\x00\x00\x00\x00\x00\x9a\x28\xcb\x7e\x6a\x3d\x6b\xdc\x09\xea\xfc\x84\x35\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x01\x7b\x62\x81\xa8\x0f\x82\xbe\x6d\x03\x9c\x1c\x0c\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x11\xde\x2c\x7f\x7e\x40\x3e\x57\x51\x84\x00\xca\x0b\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x16\x01\x1f\x0c\x1d\xee\xf9\x12\x2d\xe4\x28\x37\x87\xbc\xd8\xf0\x00\x00\x00\x00\x00\x00\x00\x13\x46\x16\xac\x74\xd5\x0d\x05\xef\x8f\xad\xe5\x82\x57\x80\x00\x00\x00\x00\x00\x90\x01\x13\x4a\x9e\xb8\x75\xfe\xe3\xb1\x3c\xa4\x1a\x40\x00\x00\x00\x0c\x04\x39\x8b\x2e\x6d\x6e\xbc\x57\x0d\xed\x00\x00" },
  { 399, 2, 16, "\x01\x01\x01\x13\x01\x7d\x02\x01\x4a\x02\x01\x69\x02\x02\x81\x02\x09\xba\x02\x0b\xce\x82\x01\x68\x02\x05\xce\x02\x2b\xbf\x02\x1c\xd0\x82\x1d\x63\x82\x18\x15\x82\x14\x8c\x82\x03\x80" },
  { 403, 1, 2, "\x85\x01\x1c\x96\x4c\x00\x0c\x07\xec\xeb\x03\xd8\x50\xb4\x8f\x4e\x9d\x00\x00" },
  { 404, 2, 14, "\x81\x01\x81\x65\x82\x01\xc3\x82\x04\x64\x82\x04\x50\x82\x07\x2c\x81\xc2\x82\x09\x26\x01\xc2\x82\x07\x2c\x02\x04\x50\x82\x04\x64\x02\x01\xc3\x81\x65" },
  { 407, 2, 16, "\x81\x01\x81\x01\x81\x02\x81\x01\x81\x09\x01\x02\x81\x0f\x00\x81\x0c\x00\x81\x04\x81\x13\x01\x11\x81\x21\x01\x04\x81\x0a" },
  { 408, 2, 4, "\x01\x01\x02\x03\xd4\x82\x12\x5e\x82\x03\xd4" },
  { 411, 1, 6, "\x08\x3a\x02\x01\x29\x00\x00\x00\x00\x96\x0c\x81\xf6\x70\x54\x6e\x64\x07\x33\x8e\x74\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\x98\x77\x80\x1c\x23\x6b\x25\x43\x95\x3d\xb1\x8c\xf0\x00\x00\x00\x00\x00\x00\x00\x12\x11\xbb\x44\xfa\xcb\x8c\x35\x13\xa2\x5f\x67\xbf\xc0\x00\x00\x00\x00\x00\x10\x05\xb5\xfa\xdc\xcc\x96\xed\x0b\x01\xf3\x8b\x8a\x00\x00\x00\x00\x0c\x0e\xc6\x90\x58\x43\xfd\xce\x9d\x95\xc5\x00\x00" },
  { 415, 2, 10, "\x81\x01\x00\x81\x06\x01\x02\x81\x0e\x01\x02\x81\x0b\x81\x07\x81\x01\x81\x0a" },
  { 420, 2, 8, "\x01\x01\x82\x04\x4c\x82\x18\x88\x01\x3c\x02\x3d\x2e\x01\x3c\x82\x18\x88\x82\x04\x4c" },
  { 424, 2, 6, "\x81\x01\x81\x0b\x81\x05\x01\x06\x01\x05\x81\x0b" },
  { 427, 1, 2, "\x05\x0c\x82\x0f\xbc\x00\x0c\x32\x71\x7e\x4b\x1d\xf0\xbb\x69\x80\xde\x00\x00" },
  { 431, 2, 21, "\x81\x01\x81\x03\x81\x06\x81\x09\x81\x09\x01\x04\x01\x0a\x01\x24\x01\x1e\x01\x0e\x01\x02\x81\x42\x81\x29\x81\x53\x81\x2c\x81\x0a\x81\x15\x01\x28\x81\x10\x01\x0f\x81\x0c" },
  { 435, 1, 4, "\x87\x08\x3f\x6d\x33\x90\x00\x00\x13\x01\xec\x14\x81\xad\xa4\x78\x26\x63\x8a\xe5\xc4\xee\x40\x00\x00\x00\x00\x00\x10\x41\xcd\x38\x26\xc3\x9f\x4f\x0a\x66\xcb\x4c\x0c\x00\x00\x00\x00\x0c\x5c\x67\x21\x8e\x69\xaf\xe3\x9e\x56\x8b\x00\x00" },
  { 436, 2, 6, "\x81\x01\x81\x75\x01\x9c\x81\x09\x81\x9c\x81\x75" },
  { 439, 2, 15, "\x81\x01\x01\x05\x81\x0b\x01\x09\x01\x07\x81\x11\x01\x01\x01\x1d\x81\x26\x01\x0d\x01\x14\x81\x18\x81\x07\x01\x17\x81\x0d" },
  { 440, 2, 12, "\x01\x01\x81\x10\x01\x40\x81\x68\x01\x20\x01\x90\x81\xf6\x01\x90\x01\x20\x81\x68\x01\x40\x81\x10" },
  { 443, 1, 5, "\x08\x10\x2a\x3a\x59\x46\x00\x00\x00\x96\x01\xb9\xca\x61\xd0\xf2\x41\xb5\x53\xc7\xdf\xb1\x04\x6c\xf0\x00\x00\x00\x00\x00\x00\x00\x14\x7f\x48\xc2\xe0\x9a\x21\x3d\x07\xf1\x29\x79\x5c\x09\xa5\x40\x00\x00\x00\x00\x00\x90\x92\x60\x13\x41\x24\xe4\xd6\x49\xfe\x4a\xbd\x80\x80\x00\x00\x00\x0c\xa8\x54\x63\xe7\x67\x22\x45\xcf\x64\x75\x80\x00" },
  { 447, 2, 14, "\x81\x01\x81\x16\x81\xf3\x82\x05\xec\x82\x16\x20\x82\x33\xbe\x82\x4f\x15\x82\x5a\x4d\x82\x71\x0c\x82\xae\x16\x82\xd2\x42\x82\x94\xd5\x82\x33\xf6\x82\x05\x89" },
  { 451, 1, 6, "\x07\xdf\x6e\x06\x00\x00\x00\x00\x15\x04\x79\x45\xf6\x36\xac\xc6\x89\x18\xd7\xc4\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x1a\x35\x65\x0b\x13\x2d\xd7\xd1\xbd\x36\x23\x30\x00\x00\x00\x00\x00\x00\x00\x11\x6d\x8f\x36\x3f\x37\xf6\xae\x45\x52\x21\xa6\xc0\x00\x00\x00\x00\x00\x0f\x07\x44\x59\x71\x99\xab\x6e\x19\x24\x0c\xa1\x00\x00\x00\x00\x0d\x01\x30\xff\x03\x69\xc8\xd6\x4a\x8d\x9b\x9d\x00\x00" },
  { 452, 2, 8, "\x01\x01\x81\x09\x81\x16\x81\x3b\x81\x4e\x81\x3b\x81\x16\x81\x09" },
  { 455, 2, 20, "\x01\x01\x01\x06\x01\x0f\x01\x17\x01\x1a\x01\x10\x81\x0f\x81\x39\x81\x49\x81\x1e\x01\x4c\x01\xc2\x01\xf6\x01\xbf\x01\x26\x81\x81\x81\xc8\x81\x8e\x81\x32\x81\x06" },
  { 456, 2, 8, "\x01\x01\x82\x06\x0c\x82\x0c\x6c\x02\x60\x0c\x82\xbb\x2a\x02\x60\x0c\x82\x0c\x6c\x82\x06\x0c" },
  { 463, 2, 7, "\x81\x01\x81\x03\x81\x07\x81\x07\x81\x08\x81\x09\x81\x0b" },
  { 467, 1, 7, "\x09\xa2\xe3\xd1\xbb\x78\x00\x00\x00\x00\x9a\x0c\xc5\xf1\xf1\x70\x06\xd9\x5c\x11\x78\xcf\xb0\x38\x2c\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xb6\xd0\xb2\xfa\xd8\x85\x4e\xe1\xeb\x8d\x0d\x72\x06\xab\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x02\x04\xe4\x20\xb1\x71\x89\xa1\xf6\x91\x9d\x62\xb9\x44\x2f\x50\x00\x00\x00\x00\x00\x00\x00\x15\x09\x75\xd7\x41\xa2\x59\xd8\x97\xd6\x12\xea\x12\x91\x4e\xea\xa0\x00\x00\x00\x00\x00\x91\x06\x09\x20\xfe\x71\x0a\xa8\x74\xde\xda\x41\x18\xb5\xc0\x00\x00\x00\x0d\x03\xd9\xc9\x4a\x90\x0f\x17\x41\xd4\xf5\x76\x80\x00" },
  { 471, 2, 16, "\x81\x01\x81\x06\x81\x3e\x01\x6a\x82\x01\x7e\x02\x03\xae\x82\x12\x94\x02\x25\x9d\x82\x4a\x2b\x02\x57\x09\x82\x8e\xf9\x02\xac\xbe\x82\xec\x36\x02\x72\x21\x82\x0f\xf5\x82\x06\xef" },
  { 472, 2, 6, "\x81\x01\x81\x0c\x00\x81\x16\x00\x81\x0c" },
  { 483, 1, 4, "\x87\x17\xae\xec\x9c\xb0\x00\x00\x13\x07\x33\x75\x84\x6f\xa6\x2e\x90\x37\x16\xce\x84\xe4\x80\x00\x00\x00\x00\x00\x11\x1c\x16\x35\x65\xbd\x9b\x09\xc6\xec\xe5\xa6\x75\xf4\x80\x00\x00\x00\x0d\x0c\x33\x50\x41\xef\x2c\x48\x7e\x0a\xc0\x36\x00\x00" },
  { 487, 2, 7, "\x81\x01\x01\x01\x81\x04\x01\x07\x81\x04\x01\x04\x81\x0d" },
  { 488, 2, 10, "\x81\x01\x81\x0c\x01\x07\x81\x20\x81\x01\x01\x24\x01\x01\x81\x20\x81\x07\x81\x0c" },
  { 499, 1, 3, "\x06\x98\x08\xb8\xd9\x00\x00\x90\x04\x8f\xd4\x5e\xec\xd9\x0f\x6c\x7a\x44\x66\x0d\x40\x00\x00\x00\x0d\x25\xee\x01\x60\x17\x75\xcd\x35\x64\x8e\x80\x00\x00" },
  { 503, 2, 21, "\x81\x01\x00\x01\x01\x01\x06\x81\x07\x00\x01\x03\x81\x0c\x01\x0a\x01\x17\x81\x1e\x81\x1b\x01\x13\x01\x5c\x81\x4a\x81\x6a\x01\xab\x81\x22\x81\x57\x01\x45\x81\x12" },
  { 511, 2, 14, "\x01\x01\x81\x07\x01\x15\x81\x23\x01\x23\x81\x15\x01\x10\x81\x25\x01\x46\x81\x54\x01\x4d\x81\x38\x01\x24\x81\x10" },
  { 515, 1, 6, "\x09\xbf\xa9\xd0\x26\xf4\x00\x00\x00\x00\x9a\x01\xee\xfd\xf4\x80\x26\xfd\x3a\x87\xe0\x19\x2f\xbf\x01\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\xff\x4a\xbd\x57\x7c\xa8\xb9\x8e\x01\x39\x7d\x52\xa1\x85\x2c\xec\x70\x00\x00\x00\x00\x00\x00\x00\x16\x0a\xbf\x5a\x9a\xef\x85\xd0\xac\x61\xb0\x50\x60\x24\xd8\x5a\x5a\xc0\x00\x00\x00\x00\x00\x92\x02\x34\x74\xf2\x76\xbc\xf2\x96\xc5\x70\x69\xd9\xa8\x24\x00\x00\x00\x00\x0d\x73\xcf\x70\xcc\x5f\xe3\x2d\xfd\x3b\xad\x19\x00\x00" },
  { 516, 2, 12, "\x01\x01\x82\x0a\x52\x82\x26\x36\x02\xaa\x4e\x83\x01\x5b\x81\x03\x01\x68\x04\x83\x03\x0c\x94\x03\x01\x68\x04\x83\x01\x5b\x81\x02\xaa\x4e\x82\x26\x36\x82\x0a\x52" },
  { 519, 2, 18, "\x81\x01\x01\x19\x81\xf2\x02\x04\x9a\x82\x0e\x63\x02\x1e\x7e\x82\x31\xdb\x02\x51\xbe\x82\x78\x6a\x02\xa3\xa4\x83\x01\x18\xe4\x03\x01\xbc\x38\x83\x02\x4d\x32\x03\x02\x17\x0c\x82\xc3\x19\x02\x18\x7b\x82\x40\xa1\x82\x0a\x95" },
  { 520, 2, 4, "\x01\x01\x81\x0c\x81\x1b\x81\x0c" },
  { 523, 1, 5, "\x07\x05\x57\x48\x6a\x00\x00\x00\x92\x5f\xb0\xb8\x03\x26\x1d\x06\x81\x63\x21\x30\x00\x00\x00\x00\x00\x00\x00\x11\x27\x5d\x52\xf5\x36\x9f\x7f\x6a\xa5\x64\x92\x40\x00\x00\x00\x00\x00\x8f\x2d\xa2\xe9\x99\x86\x6b\xc2\x49\x7e\xb0\x3b\x80\x00\x00\x00\x0d\xc9\x0d\x23\x10\x9c\x12\x5e\x46\xfc\x65\xb0\x80\x00" },
  { 527, 2, 18, "\x01\x01\x00\x01\x02\x01\x05\x01\x08\x81\x04\x81\x07\x81\x01\x81\x0a\x81\x20\x81\x05\x01\x14\x01\x0c\x01\x0f\x01\x2d\x81\x18\x81\x1f\x81\x0c" },
  { 532, 2, 4, "\x01\x01\x01\xd2\x01\x4f\x81\xd2" },
  { 535, 2, 14, "\x81\x01\x00\x01\x03\x01\x06\x81\x10\x81\x01\x01\x03\x01\x22\x81\x25\x01\x0a\x81\x0e\x01\x07\x01\x14\x81\x10" },
  { 536, 2, 14, "\x81\x01\x81\x0c\x01\x22\x81\x42\x01\x25\x81\x4c\x01\x03\x81\x7e\x81\x03\x81\x4c\x81\x25\x81\x42\x81\x22\x81\x0c" },
  { 543, 2, 12, "\x81\x01\x01\x15\x81\xce\x02\x03\xa1\x82\x0b\x4f\x02\x19\xfe\x82\x39\x7a\x02\x5d\xce\x82\x68\x9a\x02\x69\x21\x82\x51\x02\x82\x0c\xfd" },
  { 547, 1, 3, "\x06\x03\xf8\xdc\xa6\x80\x00\x8f\x1a\xe8\x59\x80\x85\x6a\x81\x97\x88\xc2\x70\x40\x00\x00\x00\x0e\x04\x02\x1e\x0d\x71\x02\x19\x93\x7e\xb8\x6a\x05\x80\x00" },
  { 548, 2, 8, "\x01\x01\x81\x15\x01\x67\x81\xec\x02\x01\x2e\x81\xec\x01\x67\x81\x15" },
  { 552, 2, 8, "\x01\x01\x02\x0e\x00\x82\x78\x04\x02\x53\x00\x02\x73\x06\x82\x53\x00\x82\x78\x04\x82\x0e\x00" },
  { 555, 1, 4, "\x88\x01\x20\x01\xc5\x50\x40\x00\x00\x15\x0d\x31\x86\x32\xeb\x23\x69\xf8\x3a\xd8\x94\x36\x49\xb9\xf2\x00\x00\x00\x00\x00\x00\x12\x52\x8c\x7d\x34\xfb\x2b\x21\x93\x81\xa1\x9e\x17\xd5\xd8\xc0\x00\x00\x00\x0e\x06\xd8\xa7\x5c\x91\x90\xc9\xda\xe3\xb1\x2d\x84\x00\x00" },
  { 559, 2, 16, "\x81\x01\x01\x01\x00\x81\x02\x81\x01\x01\x0e\x81\x33\x01\x62\x81\x7b\x01\x53\x01\x12\x81\x8b\x01\xc4\x81\xa1\x01\x4e\x81\x14" },
  { 564, 2, 8, "\x01\x01\x03\xf0\x6b\x10\x04\x33\x2a\x24\x5c\x85\x01\xcb\x27\x30\x30\x05\x05\xbb\x80\x78\x46\x05\x01\xcb\x27\x30\x30\x04\x33\x2a\x24\x5c\x83\xf0\x6b\x10" },
  { 568, 2, 4, "\x01\x01\x81\x12\x01\x21\x81\x12" },
  { 571, 1, 5, "\x08\x03\x71\xa6\xc5\xb8\x00\x00\x00\x95\x0b\x2a\x9a\x0b\xe8\xa5\xd7\xac\x2a\x03\xf4\xfa\x6d\x00\x00\x00\x00\x00\x00\x00\x00\x13\xc5\x39\x71\x48\x4d\x57\x1f\xe8\x63\xdb\xc5\xd4\x69\x60\x00\x00\x00\x00\x00\x11\x02\x67\xc9\x5f\xa7\x3b\x28\xb2\xc2\xf8\x27\x7a\x13\xc0\x00\x00\x00\x0e\x13\xbe\xfe\x54\xe1\x9f\x93\xff\x30\xec\x2e\xea\x80\x00" },
  { 580, 2, 8, "\x01\x01\x81\x11\x01\x07\x01\x0c\x81\x2a\x01\x0c\x01\x07\x81\x11" },
  { 583, 2, 8, "\x81\x01\x81\x04\x81\x03\x01\x05\x01\x0c\x01\x0b\x81\x0c\x81\x10" },
  { 584, 2, 16, "\x01\x01\x81\x16\x01\x63\x81\xbe\x01\xb1\x81\x58\x81\x22\x01\xe4\x82\x01\x76\x01\xe4\x81\x22\x81\x58\x01\xb1\x81\xbe\x01\x63\x81\x16" },
  { 587, 1, 7, "\x0a\xc0\x4a\x1a\xd0\xbb\x80\x00\x00\x00\x00\x9c\xb9\x63\xce\x00\xe5\xca\xcd\x28\x95\x20\xd4\xd5\x6a\x93\x47\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x56\x48\xbb\x7e\x9f\xb2\x31\x0f\xf8\x90\x40\xfa\x0d\x9c\xcf\x96\xf1\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\xbe\x90\x83\x93\x69\xac\xa8\xc4\x87\x08\x58\xff\x70\x6d\x0c\xab\xcd\x70\x00\x00\x00\x00\x00\x00\x00\x17\x81\x8b\xfd\x3a\x36\x43\x7b\xd3\x2e\x99\x86\x0c\x96\x48\x41\xe3\xaf\xc0\x00\x00\x00\x00\x00\x93\x05\x54\x39\x32\x64\xb0\x61\x3f\x5a\x2d\x56\x7b\x10\x40\x1a\x80\x00\x00\x00\x0e\x38\x1e\x43\x2e\xb7\x4d\x16\x34\x22\x79\xc8\x0e\x80\x00" },
  { 595, 1, 4, "\x87\x10\x00\xd5\xd1\xc0\x00\x00\x13\x15\xa9\x31\xfd\xb2\xb2\x07\x03\xac\xbc\x57\xe7\x36\x00\x00\x00\x00\x00\x00\x11\x19\xb8\x5b\x5a\x51\xa5\x46\x50\x9f\xb0\xc8\x92\xb3\x40\x00\x00\x00\x0e\x5e\x1a\x00\xcd\x92\xc9\x14\x20\xef\x79\x77\x39\x00\x00" },
  { 596, 2, 14, "\x81\x01\x82\x01\x21\x02\x0a\xc1\x82\x22\x48\x02\x21\x78\x82\x06\xb8\x02\x09\xb2\x82\x41\xce\x82\x09\xb2\x82\x06\xb8\x82\x21\x78\x82\x22\x48\x82\x0a\xc1\x82\x01\x21" },
  { 599, 2, 25, "\x81\x01\x01\x02\x01\x01\x81\x08\x81\x06\x01\x11\x01\x05\x81\x20\x01\x0d\x01\x24\x81\x16\x81\x3a\x01\x06\x01\x47\x00\x81\x23\x01\x18\x01\x42\x81\x1c\x81\x3f\x81\x5c\x01\x52\x01\x03\x81\x19\x81\x10" },
  { 607, 2, 13, "\x81\x01\x01\x02\x81\x03\x01\x01\x01\x07\x01\x09\x81\x15\x81\x15\x01\x03\x01\x22\x01\x10\x81\x0f\x81\x11" },
  { 616, 2, 8, "\x01\x01\x01\x12\x81\x03\x01\x12\x01\x14\x81\x12\x81\x03\x81\x12" },
  { 619, 1, 5, "\x08\xa3\xdb\xc6\xfe\x78\x00\x00\x00\x16\x4c\x28\x45\x16\x97\x31\x98\xaa\xab\xa1\xf4\x4d\xe8\x1e\x00\x00\x00\x00\x00\x00\x00\x00\x14\x39\x25\x0e\xb8\x17\xd6\x69\xcd\xfa\x81\xa4\x6f\xa4\x5d\x20\x00\x00\x00\x00\x00\x91\xff\xb8\x1a\x13\x8d\x4e\xcf\x50\x48\xca\xca\x37\x68\x40\x00\x00\x00\x0f\x01\xb2\xad\xfc\xc0\x42\x61\x36\x88\xb5\xa6\xb9\x7b\x80\x00" },
  { 623, 2, 22, "\x01\x01\x81\x06\x01\x0e\x81\x0c\x81\x07\x01\x22\x81\x39\x01\x3d\x81\x26\x01\x03\x01\x27\x81\x4a\x01\x81\x82\x01\x2f\x02\x02\x22\x82\x02\xc8\x02\x03\x13\x82\x02\xc4\x02\x01\xba\x81\xbe\x01\x49\x81\x16" },
  { 627, 1, 4, "\x88\x01\x7f\xe4\xbd\x37\x00\x00\x00\x14\x5c\x31\x4d\x55\x7f\x41\x6c\xd7\x92\xcb\x6e\xb8\x1d\x28\x00\x00\x00\x00\x00\x00\x13\x9f\xcf\x15\xdc\xd9\x41\xe1\x34\x56\x7e\x97\xec\xac\x9d\x60\x00\x00\x00\x00\x0f\x02\xcf\x26\xf0\xe0\x6e\x68\x0b\x83\x95\x2b\xf1\x25\x80\x00" },
  { 628, 2, 6, "\x81\x01\x82\x01\x62\x81\xde\x82\x01\x08\x01\xde\x82\x01\x62" },
  { 631, 2, 13, "\x81\x01\x81\x04\x81\x0c\x81\x15\x81\x25\x81\x2e\x81\x36\x81\x48\x81\x47\x81\x4d\x81\x45\x81\x21\x81\x11" },
  { 632, 2, 8, "\x01\x01\x81\x12\x81\x0d\x81\x6e\x81\x24\x81\x6e\x81\x0d\x81\x12" },
  { 643, 1, 3, "\x07\x02\x66\x3e\xc6\x12\x80\x00\x91\x12\x83\xe0\xc3\x2b\xa0\x0f\x43\x4a\x73\x25\xd9\xaa\x40\x00\x00\x00\x0f\x07\x9d\xbf\x54\xde\xdd\x98\x01\x84\xfe\x73\x54\x25\x80\x00" },
  { 644, 2, 16, "\x01\x01\x81\x12\x81\x21\x01\x1a\x01\xa5\x81\x6c\x82\x01\x26\x01\x28\x02\x01\xca\x01\x28\x82\x01\x26\x81\x6c\x01\xa5\x01\x1a\x81\x21\x81\x12" },
  { 647, 2, 23, "\x81\x01\x81\x02\x01\x03\x01\x0d\x01\x13\x01\x15\x00\x81\x4b\x81\xca\x82\x01\x7a\x82\x02\x54\x82\x03\x1e\x82\x03\xbb\x82\x03\xe3\x82\x03\x51\x82\x02\x62\x82\x01\x80\x81\x97\x81\x02\x01\x2e\x01\x25\x01\x03\x81\x14" },
  { 655, 2, 12, "\x81\x01\x01\x01\x81\x06\x81\x04\x81\x0f\x81\x13\x81\x20\x81\x2b\x81\x37\x81\x2f\x81\x29\x81\x12" },
  { 660, 2, 8, "\x01\x01\x04\x04\x50\xd5\x30\x05\x01\xe0\x2e\xf3\xdc\x05\x0c\x62\x4c\xa7\x70\x85\x02\x59\x4b\x3e\xba\x85\x0c\x62\x4c\xa7\x70\x05\x01\xe0\x2e\xf3\xdc\x84\x04\x50\xd5\x30" },
  { 663, 2, 16, "\x01\x01\x81\x08\x01\x6f\x02\x02\x3e\x02\x01\x1b\x82\x15\x8a\x02\x03\x5d\x02\x57\x3c\x02\x21\xd8\x83\x01\x80\x5a\x02\xf8\x01\x03\x01\xce\x5a\x83\x01\x9a\x39\x82\x36\x59\x83\x01\x5e\xd3\x82\x21\xf8" },
  { 664, 2, 10, "\x81\x01\x81\x16\x81\x1d\x81\x0c\x01\x13\x81\x1a\x81\x13\x81\x0c\x01\x1d\x81\x16" },
  { 667, 1, 4, "\x87\x02\x52\x15\x1d\x10\x00\x00\x92\x01\xb0\x40\x53\x39\x2c\x50\xb2\x19\x5e\xdd\xe9\x40\x00\x00\x00\x00\x00\x90\x02\xcf\xe2\x1a\x41\xc2\xf5\xf1\xd0\x20\x97\x62\x00\x00\x00\x00\x0f\x21\x3a\x22\xe4\xf5\x7c\xbc\xd8\x62\x4f\x9b\x83\x01\x00\x00" },
  { 679, 2, 18, "\x01\x01\x00\x01\x07\x00\x01\x0c\x81\x09\x01\x0c\x01\x06\x01\x0d\x81\x03\x81\x08\x81\x09\x01\x21\x81\x1b\x01\x18\x81\x3c\x01\x3a\x81\x18" },
  { 680, 2, 12, "\x01\x01\x01\x12\x81\x45\x01\x76\x81\x35\x01\x44\x81\x0e\x81\x44\x81\x35\x81\x76\x81\x45\x81\x12" },
  { 683, 1, 5, "\x0a\x06\x49\x62\xa2\xf3\x71\xf0\x00\x00\x00\x9b\x0c\x37\x2a\x8a\xbf\x9b\xb9\x97\x67\x52\x80\x01\xa6\x58\xdc\xf7\xea\x7c\x6c\xf0\x00\x00\x00\x00\x00\x00\x00\x19\x2a\xb5\xf8\x29\x03\xf2\x7b\x46\x0f\xa6\x79\x0f\xe6\xd6\xa7\x9e\x20\x33\xec\x00\x00\x00\x00\x00\x00\x94\x3d\x1a\xef\xa4\x54\x4d\xf6\x54\xdf\x91\x6c\x72\x2a\x18\x68\x4c\x80\x00\x00\x00\x0f\x57\x6b\xed\x78\x3f\x9e\xd7\x87\x6a\x98\x9f\xc1\xd0\x00\x00" },
  { 687, 2, 12, "\x81\x01\x81\x06\x81\xbf\x82\x02\x5d\x82\x06\xa0\x02\x08\x2e\x02\x26\x1e\x02\x22\x9a\x82\x27\x7d\x02\x2b\x89\x83\x01\xb9\x32\x82\x28\xbb" },
  { 691, 1, 5, "\x09\x07\xb6\xb4\x25\xdd\xf0\x00\x00\x00\x97\x65\xbc\xcc\x30\x3c\x4e\x6a\x77\x14\x8d\x11\x03\xe7\xd1\x9a\xd0\x00\x00\x00\x00\x00\x00\x00\x15\x6f\x05\x30\x81\xc8\x5a\x55\x94\xe0\xec\x9b\xdd\xb7\x5f\x89\xc0\x00\x00\x00\x00\x00\x12\x4c\xf4\x07\x0b\xf7\x56\x3e\x7a\x39\x74\x3c\xc1\xb3\x6d\x00\x00\x00\x00\x0f\x8d\x33\x57\xc6\xca\xb4\x25\x4b\x68\x96\xe0\xae\xbd\x00\x00" },
  { 692, 2, 14, "\x81\x01\x82\x01\xf1\x82\x0e\x1f\x82\x2b\xa8\x02\x07\x38\x82\x16\xd8\x82\x12\xae\x02\x67\xd2\x02\x12\xae\x82\x16\xd8\x82\x07\x38\x82\x2b\xa8\x02\x0e\x1f\x82\x01\xf1" },
  { 696, 2, 12, "\x01\x01\x82\x2b\x98\x82\x92\xe2\x03\x09\xfe\x88\x83\x2c\xb0\xd1\x03\x61\x8f\x90\x83\x81\x29\xdc\x03\x61\x8f\x90\x83\x2c\xb0\xd1\x03\x09\xfe\x88\x82\x92\xe2\x82\x2b\x98" },
  { 703, 2, 14, "\x81\x01\x81\x03\x81\x01\x81\x01\x81\x09\x01\x04\x01\x02\x01\x0f\x01\x07\x81\x06\x81\x0b\x81\x29\x81\x0f\x81\x16" },
  { 707, 1, 6, "\x0b\x02\xf4\xd0\x99\xfc\x9d\x59\x00\x00\x00\x00\x1e\x01\x00\x0f\x73\x7a\x90\x86\x0c\x0d\x86\x76\x83\x20\x27\x30\x35\xf5\xe4\x42\xf5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x04\x98\x84\xc8\x9b\x09\x3b\x79\x13\xac\x25\x14\x41\x26\xa3\xf7\x9b\x20\x18\x22\x70\x00\x00\x00\x00\x00\x00\x00\x1a\x01\xcf\x13\x30\x73\xcc\x98\x20\x6b\x24\xe2\x2c\xd7\x0f\xf9\xfa\x9a\x91\x8b\xc1\x40\x00\x00\x00\x00\x00\x95\x01\x9b\x4f\x4c\xa6\x52\x22\xa0\x62\x7f\xd7\x9b\xcd\x10\x99\xcd\x44\x00\x00\x00\x00\x10\x01\x6d\x54\xcb\x77\xb3\xa6\x36\x61\x64\x5d\x10\x16\xf7\x00\x00" },
  { 708, 2, 4, "\x01\x01\x82\x2f\x9e\x83\x02\x28\xc6\x82\x2f\x9e" },
  { 712, 2, 8, "\x01\x01\x81\x15\x81\x33\x81\x1e\x01\x02\x81\x1e\x81\x33\x81\x15" },
  { 715, 1, 4, "\x07\x53\xf0\xe1\x43\xf0\x00\x00\x14\x10\x94\x97\x5a\x28\x66\x90\xb5\x7d\x54\xcb\xeb\xad\x24\xc0\x00\x00\x00\x00\x00\x13\x02\xb2\x8f\xb5\x0f\xf7\xe9\xa8\xe9\x7b\xc3\x97\x34\x3b\x5a\x00\x00\x00\x00\x10\x02\x49\x46\x6d\x55\xc5\x51\xa6\xf7\xfb\x23\xd2\xd5\x79\x00\x00" },
  { 723, 1, 4, "\x08\x30\xeb\x30\x80\xdf\x80\x00\x00\x96\x2e\x9b\x70\x4d\x52\x2d\xa7\x04\x26\xe0\xb5\x64\x3c\xc7\x5a\x04\x60\x00\x00\x00\x00\x00\x15\x05\xa0\x43\x71\xc5\xcb\x39\x55\xd0\x3b\x32\xf7\x0f\x2f\x63\xe4\xbc\xc0\x00\x00\x00\x10\x03\xa7\x2c\x01\x7e\x69\x52\x83\xe5\xc8\x84\x4f\x4a\x77\x80\x00" },
  { 724, 2, 10, "\x81\x01\x82\x02\x3d\x01\x56\x82\x04\xa7\x02\x0b\xab\x82\x01\x68\x82\x0b\xab\x82\x04\xa7\x81\x56\x82\x02\x3d" },
  { 727, 2, 13, "\x81\x01\x01\x04\x81\x08\x01\x05\x81\x06\x00\x81\x04\x81\x08\x81\x1e\x01\x0f\x81\x29\x01\x17\x81\x19" },
  { 728, 2, 12, "\x01\x01\x01\x1c\x01\x60\x01\x54\x81\x18\x01\x1c\x81\x2e\x81\x1c\x81\x18\x81\x54\x01\x60\x81\x1c" },
  { 739, 1, 5, "\x09\x02\x3e\x53\xf5\x57\x70\x00\x00\x00\x98\x01\x9c\x08\xec\x08\x01\x4c\xd7\x96\xc5\x6d\x1a\x82\x1e\xcf\xee\x30\x00\x00\x00\x00\x00\x00\x00\x16\x16\x8b\x94\xce\x39\x31\x92\x22\x10\x79\xa8\xeb\x78\xaf\x8c\x64\x80\x00\x00\x00\x00\x00\x93\x17\x5f\x1d\x83\xfe\x0b\xae\x68\xa2\xc8\x77\xd9\x61\x37\x37\x80\x00\x00\x00\x10\x09\x41\x36\x07\xd0\x11\xdb\x4f\xb1\x31\x10\x90\xf2\xa6\x00\x00" },
  { 740, 2, 16, "\x01\x01\x81\x12\x81\x8f\x82\x02\x6e\x82\x07\x67\x82\x10\x70\x82\x1c\x06\x82\x26\x40\x82\x2a\x6e\x82\x26\x40\x82\x1c\x06\x82\x10\x70\x82\x07\x67\x82\x02\x6e\x81\x8f\x81\x12" },
  { 743, 2, 21, "\x81\x01\x01\x06\x81\x17\x01\x44\x81\x9c\x02\x01\x12\x82\x01\x83\x02\x01\xeb\x82\x02\x82\x02\x03\x40\x82\x03\x81\x02\x02\xbd\x82\x01\xc3\x02\x01\xfd\x82\x03\x39\x02\x03\x7f\x82\x02\x03\x01\x56\x01\x21\x01\x16\x81\x1a" },
  { 744, 2, 12, "\x01\x01\x02\x3d\xe8\x83\x03\x63\xd6\x03\x06\x79\x78\x83\x19\x65\xb1\x83\x08\x99\xf0\x83\x0c\xdc\xf4\x03\x08\x99\xf0\x83\x19\x65\xb1\x83\x06\x79\x78\x83\x03\x63\xd6\x82\x3d\xe8" },
  { 751, 2, 15, "\x81\x01\x01\x05\x81\x09\x01\x06\x81\x07\x01\x0c\x81\x11\x01\x1d\x81\x02\x01\x04\x81\x15\x01\x09\x81\x35\x81\x0c\x81\x19" },
  { 760, 2, 4, "\x01\x01\x81\x18\x81\x36\x81\x18" },
  { 763, 1, 4, "\x07\x25\xe1\x79\x19\xc0\x00\x00\x13\xa7\x43\xf1\x15\xa8\x8b\x9c\x2a\x98\x06\xa3\xeb\x12\x00\x00\x00\x00\x00\x00\x12\x87\x0c\xfd\xef\x4f\xed\x04\xb5\x80\xff\x16\x8a\xed\x8a\xc0\x00\x00\x00\x10\x24\xa1\x02\xcd\x9c\x9c\xe7\xdb\xf1\xa5\xbd\xa7\xb3\x44\x00\x00" },
  { 767, 2, 22, "\x81\x01\x01\x01\x01\x09\x81\x05\x81\x27\x81\x03\x01\x51\x01\x22\x81\x83\x81\x9c\x01\x22\x01\x6f\x81\x4a\x81\xae\x81\x98\x81\x88\x81\x14\x81\x4a\x82\x01\x04\x81\xbb\x81\x3c\x81\x18" },
  { 771, 1, 6, "\x0a\xde\x6d\x16\x2b\x52\x46\x40\x00\x00\x00\x9d\x35\x06\x6e\x09\xe2\xb3\xe5\x64\x61\x4a\x14\x46\xdf\x04\x88\xbb\x0f\x04\x83\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x04\x67\xa4\xf0\x5b\x2a\x63\xf9\xda\xe9\x19\xda\x45\x4d\x3a\xfc\x1d\xb0\xad\x53\x70\x00\x00\x00\x00\x00\x00\x00\x19\x01\x35\xb5\xe7\x3f\x97\x01\x49\x57\xee\x83\xa1\x36\x50\x0b\x48\x40\x15\xec\x80\x00\x00\x00\x00\x00\x15\xde\xc3\xfa\xcb\x54\xd7\xe7\x4b\x23\xcb\xec\x2c\xd7\xf9\x04\xbc\x6f\xc0\x00\x00\x00\x10\x39\xa9\x49\x31\xec\x7b\xaa\x20\x0a\x77\xc9\x37\x11\x09\x00\x00" },
  { 772, 2, 4, "\x01\x01\x81\x1a\x81\x16\x81\x1a" },
  { 776, 2, 20, "\x01\x01\x81\x1a\x81\x17\x81\xbe\x81\x24\x81\xbe\x01\x67\x81\xe6\x81\x51\x81\x84\x02\x02\x48\x81\x84\x81\x51\x81\xe6\x01\x67\x81\xbe\x81\x24\x81\xbe\x81\x17\x81\x1a" },
  { 787, 1, 5, "\x08\x44\xca\xa5\x93\xa8\x00\x00\x00\x16\x30\x07\x41\x33\xba\x6e\x03\x53\xce\xa8\x96\xe3\x65\xb2\x70\x00\x00\x00\x00\x00\x00\x00\x15\x0b\x26\x6c\x34\x92\x14\xee\x3d\x91\xfd\x3b\x2d\x16\xe2\xc0\x40\x00\x00\x00\x00\x00\x13\x03\x18\x1d\xc2\xdf\x75\x9a\xcc\xf7\x64\x82\x24\xc3\x82\x2c\x00\x00\x00\x00\x10\x8d\xe4\x8b\xc8\x00\x7d\x29\xca\xa7\xfa\x7b\x1c\xce\xeb\x00\x00" },
  { 788, 2, 10, "\x81\x01\x82\x03\x0b\x82\x05\x16\x82\x61\x7d\x02\x29\x9f\x02\x3f\x00\x82\x29\x9f\x82\x61\x7d\x02\x05\x16\x82\x03\x0b" },
  { 795, 1, 4, "\x09\x06\x50\xa8\xe6\xe3\x7e\x30\x00\x00\x19\x0f\x73\x88\x52\x39\x99\x58\x1d\x40\xd6\x31\x03\x18\x7d\xe4\x74\x16\x40\xbd\xc0\x00\x00\x00\x00\x00\x16\x05\x3e\xce\x32\x31\x66\x6b\x91\xc4\xcd\x43\x57\x85\x70\xee\x36\xb6\x73\x00\x00\x00\x00\x10\xdd\xd2\xcb\xe2\x66\xd6\x5d\x16\x86\xe5\xed\x6a\x12\xcd\x00\x00" },
  { 799, 2, 16, "\x01\x01\x01\x03\x01\x09\x01\x09\x81\x06\x81\x15\x81\x27\x81\x06\x01\x34\x01\x18\x01\x12\x81\x12\x81\x4b\x01\x1e\x01\x27\x81\x1e" },
  { 804, 2, 12, "\x01\x01\x82\x5e\x8e\x83\x07\xbb\xf6\x83\x2c\xb5\x2e\x83\xac\xeb\x81\x84\x01\x99\xec\x44\x84\x02\x2e\xd1\x14\x84\x01\x99\xec\x44\x83\xac\xeb\x81\x83\x2c\xb5\x2e\x83\x07\xbb\xf6\x82\x5e\x8e" },
  { 807, 2, 14, "\x81\x01\x81\x0a\x82\x01\x05\x81\x63\x02\x07\xe5\x82\x21\x8c\x02\x1d\x5f\x02\xcf\xde\x83\x04\x99\x19\x03\x0b\x05\x2e\x83\x0f\x99\xd6\x03\x0c\xf6\xd8\x83\x04\x88\x2d\x82\x60\x93" },
  { 808, 2, 6, "\x81\x01\x81\x1d\x01\x04\x81\x39\x81\x04\x81\x1d" },
  { 811, 1, 7, "\x0b\x01\x4e\xcd\x24\x68\xdb\xe0\x00\x00\x00\x00\x9d\x1d\xb2\xa4\xaa\xab\xc7\xfc\xc7\xce\x25\x28\xdd\x48\x79\x5f\xee\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x03\x09\xde\x5e\xe7\x1d\x7e\x62\x0c\x75\x20\xd8\x06\xab\xc6\x4e\x75\xf4\xe8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x99\xff\x5a\xc8\xee\x27\x12\x79\x74\x23\x4a\x0d\x5f\x73\x0f\xed\x77\x22\x70\x00\x00\x00\x00\x00\x00\x00\x17\x19\xda\x46\x4c\xf5\x94\x3f\xe1\x78\xfb\x81\x96\x80\xf4\x98\x7e\x57\xc0\x00\x00\x00\x00\x00\x14\x04\x7d\xf8\xb7\xfc\x53\x00\xb1\xbf\xb6\x1e\x91\x51\xf1\x4e\x8d\x80\x00\x00\x00\x11\x02\x1a\x82\xce\x94\xa5\x87\x21\x3d\x40\x57\x1b\x42\x62\xfa\x80\x00" },
  { 820, 2, 8, "\x01\x01\x02\x03\x87\x02\x06\x98\x02\x01\x3b\x02\x07\x0e\x82\x01\x3b\x02\x06\x98\x82\x03\x87" },
  { 823, 2, 9, "\x81\x01\x81\x01\x00\x81\x0c\x81\x1e\x81\x21\x81\x1e\x81\x24\x81\x1d" },
  { 824, 2, 20, "\x01\x01\x81\x1e\x81\x0d\x01\x76\x01\xcc\x82\x03\x1a\x01\x8d\x02\x04\xd6\x82\x02\xf1\x82\x03\xb4\x02\x06\x78\x82\x03\xb4\x82\x02\xf1\x02\x04\xd6\x01\x8d\x82\x03\x1a\x01\xcc\x01\x76\x81\x0d\x81\x1e" },
  { 827, 1, 7, "\x0c\x04\x5a\x72\x6d\xd2\xfd\x7b\x20\x00\x00\x00\x00\xa1\x09\x4a\xea\xff\xfa\x87\xc5\x32\x2a\xdf\xc8\x37\x37\x2f\x8b\xa7\x3b\x24\x2d\x7c\xb8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x78\x54\x85\xce\x3a\x4a\xd4\x12\xc1\xb9\xdf\x11\x0f\x0d\x4f\xf1\x16\xb0\xf0\x8d\xa2\x58\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\xd3\x6d\x9b\x21\xbb\x9e\xab\x20\x65\x82\xf9\xc8\xb2\x42\xfe\x2a\x66\xac\x17\x2b\x06\x70\x00\x00\x00\x00\x00\x00\x00\x1c\x02\x59\xc4\x06\x31\x9d\x00\xa5\xfd\x39\x31\x0d\x20\xb1\xee\x21\x99\x00\x01\x1c\xbb\xdd\x40\x00\x00\x00\x00\x00\x96\x37\x31\xbb\x6b\x04\x22\xb6\xa3\xaf\x18\x36\xa0\xd1\xf1\x3d\x3b\xfd\xd2\x80\x00\x00\x00\x11\x05\x0f\xfc\x84\xc4\x39\x02\x9c\x7b\xcf\x24\x48\x1c\xf4\xed\x80\x00" },
  { 835, 1, 6, "\x09\x09\x33\xd7\x7e\xc7\x00\x00\x00\x00\x99\x01\x1f\x3a\x82\x18\xac\xa9\xe0\xc1\x4b\xbc\xaa\xeb\x41\xde\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x45\x95\xf8\x19\x7a\xe9\x67\x01\x5a\xab\x50\xc3\x45\x18\x44\x30\x00\x00\x00\x00\x00\x00\x00\x96\x05\x85\x62\x21\xf9\xc4\xdd\x4b\xf2\xa4\x7f\x5e\x13\x5d\xec\x76\xc0\x00\x00\x00\x00\x00\x14\x23\xcf\x51\x95\xc8\x76\x06\xd0\xf4\xb3\x49\xe0\x40\xda\x8e\xb1\x00\x00\x00\x00\x11\x07\xd4\x1a\x09\x7c\x5c\x23\xe3\x44\xf8\xed\x9f\x4d\x8d\x3f\x00\x00" },
  { 836, 2, 20, "\x01\x01\x81\x22\x01\x5d\x81\x7c\x02\x01\x24\x82\x01\xa4\x81\x45\x82\x02\xc6\x82\x05\x09\x82\x02\xf0\x82\x08\x78\x82\x02\xf0\x82\x05\x09\x82\x02\xc6\x81\x45\x82\x01\xa4\x02\x01\x24\x81\x7c\x01\x5d\x81\x22" },
  { 840, 2, 8, "\x01\x01\x82\x79\x08\x83\x08\x1e\x04\x83\x07\xa6\xb8\x03\x30\xfc\x86\x83\x07\xa6\xb8\x83\x08\x1e\x04\x82\x79\x08" },
  { 843, 1, 6, "\x0a\x72\xa5\x66\xe9\xa2\x74\x80\x00\x00\x00\x1d\x02\xb5\xe4\x3d\x89\x28\xb6\xae\x17\x3e\x69\x4e\xb4\xed\x71\x6f\x36\x4b\x04\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x21\xba\xa0\x42\x6c\xa2\xed\xf3\x4b\x59\x48\xd2\x27\x98\xb1\x0e\x71\xf7\x57\x50\x00\x00\x00\x00\x00\x00\x00\x19\x06\x02\x04\xec\xb2\x43\xce\x2e\xed\x15\x15\x46\x15\xba\x83\x10\x60\x69\xc7\xc0\x00\x00\x00\x00\x00\x16\xb0\x02\xbe\xa0\xae\x8e\x47\x9b\xd8\x14\x75\xf9\xb2\x82\x78\x18\xd8\x70\x80\x00\x00\x00\x11\x0c\x14\xac\xd6\x69\x20\x23\x50\xd7\xbc\x13\x40\xf8\xa4\xd1\x80\x00" },
  { 852, 2, 8, "\x01\x01\x04\x43\x5c\x08\x70\x05\x43\x10\xdf\x6a\xdc\x86\x01\x78\x17\xff\xd6\x50\x06\x02\x24\x86\x2d\xa3\x46\x06\x01\x78\x17\xff\xd6\x50\x05\x43\x10\xdf\x6a\xdc\x84\x43\x5c\x08\x70" },
  { 856, 2, 6, "\x81\x01\x81\x20\x01\x10\x81\x4e\x81\x10\x81\x20" },
  { 859, 1, 7, "\x0b\x03\x40\xdc\x16\xac\x53\x00\x00\x00\x00\x00\x9e\x09\x05\x08\xb0\xbd\x1b\xa2\x2f\xcd\x64\x28\x0b\x6b\x55\xdc\x44\x9e\x63\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\xf3\xeb\xf2\x70\x5e\xdd\x3d\xc9\x92\x48\x6e\x5c\xa0\x3a\xbb\x4c\x39\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x0e\x3e\xd5\x8d\x1f\x55\xa1\x41\x43\xec\x2a\x82\x0c\x14\x73\xc1\xfb\x86\x50\x00\x00\x00\x00\x00\x00\x00\x18\x03\xf0\x9c\xa5\x9a\xa7\x91\x99\x9f\xd5\xd8\xd7\xda\x29\xab\x56\x5f\x40\xc0\x00\x00\x00\x00\x00\x95\x01\x12\xa6\xbd\x19\x89\x0b\x68\x6c\x66\x1d\x84\xa3\x7c\x77\xbe\xf5\x00\x00\x00\x00\x11\x1c\x97\xd1\x01\xee\xb3\x60\xa3\xd8\xed\xc4\xf8\xf5\x73\xb1\x00\x00" },
  { 863, 2, 21, "\x81\x01\x01\x09\x81\x2f\x01\xab\x82\x01\xd6\x02\x04\x0e\x82\x07\x9a\x02\x0c\xb2\x82\x13\x90\x02\x1c\x41\x82\x26\x3d\x02\x2f\xe9\x82\x36\xbc\x02\x38\x03\x82\x32\x85\x02\x27\x3d\x82\x19\x83\x02\x0d\x3b\x82\x05\x24\x02\x01\x4c\x81\x2a" },
  { 868, 2, 8, "\x01\x01\x81\x22\x01\x12\x01\x10\x01\x07\x01\x10\x01\x12\x81\x22" },
  { 871, 2, 22, "\x81\x01\x81\x02\x81\x09\x81\x0b\x81\x09\x01\x01\x81\x02\x01\x06\x81\x28\x81\x08\x81\x45\x01\x16\x81\x1e\x01\x1f\x01\x25\x81\x21\x81\x16\x81\xce\x81\x81\x81\xad\x81\x33\x81\x20" },
  { 872, 2, 10, "\x81\x01\x81\x26\x81\x94\x81\x94\x01\x31\x81\x4c\x81\x31\x81\x94\x01\x94\x81\x26" },
  { 883, 1, 3, "\x07\x13\x9a\x5b\x6b\x83\x80\x00\x93\x06\xd0\x6a\xa1\x64\xda\x28\xa4\x03\xb0\x6a\x53\x01\x32\x59\x40\x00\x00\x00\x11\x66\x92\xcd\x3b\x80\x67\xce\xd3\x17\x35\x67\x2a\xed\x03\x42\x80\x00" },
  { 884, 2, 16, "\x01\x01\x02\x04\xa6\x82\x32\x59\x02\x86\x42\x82\x03\x0f\x03\x05\x0a\xd8\x03\x01\x68\x9e\x03\x02\x92\xfc\x83\x01\xd0\x5e\x83\x02\x92\xfc\x03\x01\x68\x9e\x83\x05\x0a\xd8\x82\x03\x0f\x82\x86\x42\x82\x32\x59\x82\x04\xa6" },
  { 888, 2, 12, "\x01\x01\x82\xa6\xc8\x83\x10\x5c\xa2\x83\x67\xe4\x68\x84\x01\x4b\x63\xd1\x84\x02\x79\x9d\x50\x84\x03\x0d\x6c\x5c\x84\x02\x79\x9d\x50\x84\x01\x4b\x63\xd1\x83\x67\xe4\x68\x83\x10\x5c\xa2\x82\xa6\xc8" },
  { 895, 2, 16, "\x81\x01\x01\x04\x81\x01\x81\x09\x81\x07\x01\x1a\x81\x11\x01\x03\x81\x2a\x01\x1d\x81\x08\x01\x18\x81\x5f\x01\x1f\x01\x11\x81\x24" },
  { 903, 2, 16, "\x01\x01\x81\x23\x02\x01\x2f\x02\x02\x9a\x02\x04\x70\x82\x69\x26\x82\x85\xb0\x03\x03\x6b\x48\x03\x04\xb3\xf0\x83\x0b\x9d\x11\x83\x14\x18\x8b\x03\x0d\xc5\x1d\x03\x25\x5a\x16\x03\x07\x0a\x01\x83\x0c\xb6\xd9\x82\xb8\x12" },
  { 904, 2, 8, "\x01\x01\x81\x27\x01\x69\x81\x8a\x01\x6e\x81\x8a\x01\x69\x81\x27" },
  { 907, 1, 3, "\x07\x12\xd7\x63\x56\x98\x00\x00\x13\x01\xc1\xc8\x5b\x4b\x67\x8e\xc7\x9a\xf0\xf1\x68\x3f\x94\xb0\x00\x00\x00\x00\x12\x01\x69\xad\x24\x8e\xd2\x87\x32\x82\x48\x61\x00\x92\x3f\x5f\x00\x00\x00" },
  { 916, 2, 10, "\x81\x01\x82\x05\x61\x02\x13\xe2\x82\x28\x2f\x02\x22\x07\x82\x2d\x90\x82\x22\x07\x82\x28\x2f\x82\x13\xe2\x82\x05\x61" },
  { 919, 2, 19, "\x81\x01\x81\x05\x81\x0a\x81\x05\x81\x09\x81\x2a\x81\x33\x81\x06\x01\x17\x01\x04\x01\x1d\x01\x70\x01\x3f\x81\x93\x81\xb7\x01\x0f\x01\x4d\x81\x11\x81\x25" },
  { 920, 2, 20, "\x01\x01\x01\x24\x81\x32\x01\xcc\x81\x3d\x82\x02\x48\x01\x90\x01\x98\x82\x02\x23\x02\x03\x2c\x02\x02\xc6\x82\x03\x2c\x82\x02\x23\x81\x98\x01\x90\x02\x02\x48\x81\x3d\x81\xcc\x81\x32\x81\x24" },
  { 932, 2, 12, "\x01\x01\x81\x27\x01\x12\x01\x65\x01\xee\x82\x04\xef\x02\x07\x5e\x82\x04\xef\x01\xee\x01\x65\x01\x12\x81\x27" },
  { 943, 2, 16, "\x01\x01\x01\x05\x01\x08\x01\x01\x00\x81\x0b\x81\x26\x01\x02\x01\x3a\x01\x1c\x81\x3b\x81\x2e\x01\x42\x01\x20\x81\x37\x81\x26" },
  { 947, 1, 5, "\x0b\xe1\x46\xc7\xea\xb9\x74\x63\x3e\x00\x00\x00\x1f\x4e\x53\xbd\x6a\x2b\x32\xf4\x3a\x7b\x4c\x9d\xd0\xd1\xfb\x22\xb7\x12\x86\x72\x29\x0e\x78\x2b\x90\x00\x00\x00\x00\x00\x00\x00\x1e\x01\x60\x20\xbe\x1c\x78\x90\x05\xa6\x90\x47\xe9\x12\x99\xb8\xc6\x2c\x40\x07\x2c\xf9\x3a\x45\x0d\x40\x00\x00\x00\x00\x00\x98\x03\xe9\x83\x2d\x7c\x45\xa5\x59\x24\xa6\x36\x77\xfe\x01\x5e\x3a\x7e\x33\xb9\x4a\x80\x00\x00\x00\x12\x0b\x20\x79\x4d\x6c\x75\x64\x9a\x42\x58\x12\xbd\xc1\xc5\x91\x33\x80\x00" },
  { 948, 2, 12, "\x01\x01\x04\xec\xc7\x7d\x58\x06\x01\x6d\x47\x64\x49\xea\x86\x01\x65\x51\x16\x25\xb8\x06\x12\x89\xb5\x88\x07\x4f\x06\x12\x62\xab\x1f\x56\x70\x86\x13\x0b\xfe\xe3\x92\x74\x86\x12\x62\xab\x1f\x56\x70\x06\x12\x89\xb5\x88\x07\x4f\x06\x01\x65\x51\x16\x25\xb8\x06\x01\x6d\x47\x64\x49\xea\x84\xec\xc7\x7d\x58" },
  { 952, 2, 8, "\x01\x01\x81\x2a\x01\x4b\x81\x06\x81\x34\x81\x06\x01\x4b\x81\x2a" },
  { 955, 1, 4, "\x09\x29\x32\xef\x5b\xaf\xd8\xd0\x00\x00\x18\x15\x37\x39\x40\x34\x31\x9a\x0d\xe1\x29\x8f\xae\x83\xa3\x61\xeb\xc8\xa6\x00\x00\x00\x00\x00\x00\x16\x01\x0f\x46\x8c\x8f\xb2\x0f\x4e\xec\xcf\xe3\x23\xc6\x46\x5e\x91\xe1\x78\x80\x00\x00\x00\x12\x10\xb9\x62\xc4\x01\xb5\x1b\xf5\x44\xe9\x70\x70\xf8\x05\xc5\xec\x00\x00" },
  { 964, 2, 12, "\x01\x01\x81\x2b\x01\x4a\x01\x41\x81\xe2\x81\x43\x02\x01\x76\x81\x43\x81\xe2\x01\x41\x01\x4a\x81\x2b" },
  { 967, 2, 11, "\x81\x01\x81\x02\x01\x01\x81\x0d\x81\x06\x01\x12\x81\x51\x01\x63\x81\x7a\x01\x44\x81\x2b" },
  { 984, 2, 12, "\x01\x01\x03\x01\x34\xfc\x83\x1c\xa5\x8a\x03\x4e\x7b\x34\x84\x01\xa3\xbd\xf1\x83\x86\x3a\xc8\x83\x1c\xd0\xcc\x03\x86\x3a\xc8\x84\x01\xa3\xbd\xf1\x83\x4e\x7b\x34\x83\x1c\xa5\x8a\x83\x01\x34\xfc" },
  { 991, 2, 17, "\x81\x01\x81\x01\x81\x04\x81\x12\x81\x0b\x01\x0e\x81\x15\x81\x3e\x81\x0e\x01\x32\x81\x36\x81\x79\x01\x07\x01\x24\x81\x40\x81\x17\x81\x2b" },
  { 996, 2, 12, "\x01\x01\x83\x01\x4d\x0e\x83\x12\xc2\x76\x03\xb8\x76\x52\x84\x02\xad\xdf\x81\x04\x03\x2c\x4e\xbc\x84\x05\x79\xcc\x14\x04\x03\x2c\x4e\xbc\x84\x02\xad\xdf\x81\x03\xb8\x76\x52\x83\x12\xc2\x76\x83\x01\x4d\x0e" },
  { 1003, 1, 4, "\x08\x03\x6c\xf4\x82\x20\x80\x00\x00\x16\x03\x7d\x0e\x50\x12\xcf\x80\x1a\x9a\x5d\x14\xc9\xeb\x12\x4e\x9e\x20\x00\x00\x00\x00\x00\x94\x23\xd1\xd3\xee\xaa\x4c\x84\x24\x64\x85\xb4\x9e\x5b\xd0\x96\xb3\x40\x00\x00\x00\x12\xba\x30\xe9\x0a\xd1\x9d\x08\x67\x18\xdc\x71\xc3\x0c\xee\x97\xf5\x80\x00" },
  { 1012, 2, 4, "\x01\x01\x02\x08\x16\x02\x01\xb7\x82\x08\x16" },
  { 1015, 2, 16, "\x01\x01\x01\x04\x01\x0c\x01\x0b\x01\x0c\x81\x20\x81\x45\x81\x61\x81\x32\x01\x41\x01\x7e\x01\xac\x01\x42\x81\x10\x81\x51\x81\x2c" },
  { 1016, 2, 16, "\x01\x01\x81\x2e\x01\x01\x01\xda\x02\x01\x91\x81\xb8\x82\x0a\xe6\x82\x18\x44\x82\x1d\xf6\x82\x18\x44\x82\x0a\xe6\x81\xb8\x02\x01\x91\x01\xda\x01\x01\x81\x2e" },
  { 1023, 2, 16, "\x01\x01\x81\x23\x02\x02\xd5\x82\x0f\x05\x02\x3d\xa9\x82\xbc\x6b\x82\x72\x24\x03\x09\x86\x57\x83\x12\x70\x20\x83\x09\x0b\xe1\x03\x45\xf8\x4e\x83\x4a\x08\x12\x83\x07\x8c\xa8\x03\x3c\x1e\x46\x83\x21\x2e\x74\x83\x01\x89\x84" },
  { 1027, 1, 4, "\x09\x03\x82\x1e\xdb\x71\x7e\x90\x00\x00\x18\x06\xb6\x6d\x15\xd2\xb6\x98\xde\x1d\x91\xd4\xf1\xd4\x7c\x9c\x81\x96\x53\x00\x00\x00\x00\x00\x00\x95\x1c\x6d\x8a\x09\x94\xb4\x77\x54\xf6\xed\x65\x93\x5b\x48\xd2\x64\x3a\x80\x00\x00\x00\x13\x02\x5f\xf4\xc8\x7e\x32\xe7\x42\xf8\xdd\xca\xda\x5d\x11\x79\x71\xe4\x00\x00" },
  { 1028, 2, 16, "\x01\x01\x81\x33\x01\xcb\x82\x03\x08\x02\x09\x2f\x82\x13\xab\x02\x1d\xa6\x82\x22\x5b\x02\x23\x00\x82\x22\x5b\x02\x1d\xa6\x82\x13\xab\x02\x09\x2f\x82\x03\x08\x01\xcb\x81\x33" },
  { 1032, 2, 8, "\x01\x01\x83\x01\x9f\xd4\x83\x21\x41\xac\x03\x72\x1f\xd4\x83\xec\x9c\xaa\x03\x72\x1f\xd4\x83\x21\x41\xac\x83\x01\x9f\xd4" },
  { 1039, 2, 23, "\x81\x01\x00\x81\x04\x81\x0e\x81\x19\x81\x06\x01\x0e\x81\x1a\x81\x1f\x01\x30\x01\x3e\x01\x13\x81\x13\x01\x18\x01\x11\x01\x22\x81\x28\x81\xe4\x81\x4c\x01\x04\x81\x1c\x01\x2d\x81\x31" },
  { 1047, 2, 16, "\x81\x01\x01\x19\x82\x02\x71\x02\x04\xed\x02\x0a\x9c\x82\x3b\xde\x83\x01\xf8\x6b\x83\x01\xd3\xaf\x83\x05\x12\x02\x83\x0e\x20\xef\x83\x1d\x2e\xb4\x03\x08\x45\x34\x03\x28\x39\x93\x03\x18\xe0\xd0\x83\x2a\x89\x69\x83\x01\xc7\x99" },
  { 1048, 2, 6, "\x81\x01\x81\x30\x01\x30\x01\x2e\x81\x30\x81\x30" },
  { 1051, 1, 5, "\x0a\x2b\x9f\xce\x19\x37\x44\x5c\x00\x00\x00\x1c\x05\xc9\x8f\xac\x58\x0b\x6e\x78\x4a\x08\xe6\x20\x8a\x6f\x45\xb2\x5d\x43\x99\x40\xf0\x00\x00\x00\x00\x00\x00\x00\x1a\x34\x51\x8d\x31\xe1\xfd\xe8\xf2\x43\x1e\x70\xe1\xa7\x8e\xb7\x86\x1f\xa0\x3b\x00\x40\x00\x00\x00\x00\x00\x16\xc5\xcf\xd7\x55\x1b\x27\x48\x1e\x21\x2e\x27\xfa\x06\x62\x06\x5e\xec\x96\x00\x00\x00\x00\x13\x07\xa6\x02\xe1\xfc\x74\x69\x9c\x16\x2c\xea\xe1\x80\x02\x73\xf3\xf7\x00\x00" },
  { 1059, 1, 6, "\x0c\x0c\x44\xf1\x77\xd2\x74\xcc\xcb\x00\x00\x00\x00\xa2\x02\x4f\x4c\xa2\x9f\x9e\x4b\x4c\x09\x77\x2f\x49\x5d\x72\x21\xd0\xc9\x71\x07\x68\x96\xf6\x86\x70\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\xc9\x91\x2c\x9f\x88\x31\xc2\x39\x45\x29\xf7\xcf\xab\x36\x02\x30\xa0\x9a\xd1\x08\x2f\x7d\xc8\x38\xd0\x00\x00\x00\x00\x00\x00\x00\x9d\x07\x36\xa4\x54\x28\x6a\xdc\xcb\x94\xb3\x44\x73\x8d\x25\xc5\x64\x9f\x3c\xd9\x80\x2f\x3f\x37\x00\x00\x00\x00\x00\x00\x19\x19\x3e\x0b\xe4\x6b\xd3\xa0\x88\x80\xde\xde\x67\x0e\x19\x0b\xd3\x00\xa2\xd0\x7e\x1a\x80\x00\x00\x00\x13\x0b\x42\xf5\x05\x52\xfd\xe7\x52\xc4\x78\x8c\xb7\xf4\x66\x3c\xe5\xb8\x00\x00" },
  { 1060, 2, 8, "\x01\x01\x81\x2f\x81\x99\x82\x01\x0c\x82\x01\x6a\x82\x01\x0c\x81\x99\x81\x2f" },
  { 1063, 2, 19, "\x81\x01\x00\x81\x09\x81\x0a\x81\x08\x81\x2d\x81\x27\x01\x07\x81\x2a\x81\x24\x01\x3c\x01\x09\x81\x37\x01\x3f\x81\x0f\x81\x58\x01\x07\x01\x1b\x81\x33" },
  { 1064, 2, 20, "\x01\x01\x01\x34\x01\x52\x02\x01\xf0\x02\x04\x2b\x02\x05\xd8\x02\x04\x40\x02\x06\x2c\x02\x01\xfd\x02\x01\x68\x02\x03\xba\x82\x01\x68\x02\x01\xfd\x82\x06\x2c\x02\x04\x40\x82\x05\xd8\x02\x04\x2b\x82\x01\xf0\x01\x52\x81\x34" },
  { 1087, 2, 9, "\x81\x01\x81\x08\x81\x1c\x81\x3d\x81\x64\x81\x7c\x81\x8b\x81\x64\x81\x33" },
  { 1092, 2, 8, "\x01\x01\x83\x02\x54\xf4\x83\x3c\xcc\x88\x03\x31\x7f\x04\x03\xd9\x31\x2e\x03\x31\x7f\x04\x83\x3c\xcc\x88\x83\x02\x54\xf4" },
  { 1096, 2, 12, "\x01\x01\x81\x39\x01\xae\x82\x01\x6b\x02\x02\xdc\x82\x04\x7d\x02\x05\x28\x82\x04\x7d\x02\x02\xdc\x82\x01\x6b\x01\xae\x81\x39" },
  { 1099, 1, 6, "\x0b\x56\x54\x90\x3e\xfe\x04\xe9\x00\x00\x00\x00\x9f\x5a\x88\x6c\xd6\xc9\x70\x84\x1a\x98\xb7\x3d\xee\xf9\x62\x11\xa3\x75\x1a\x10\x57\xaf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1d\xdf\xb4\xc0\xe2\x67\x74\x54\x3a\x68\x33\xd0\x1f\xc3\x92\xb9\x53\xa5\x8e\x4e\xaa\x3e\xf0\x00\x00\x00\x00\x00\x00\x00\x1b\x05\x17\x8a\xe2\x8f\xd8\xa5\x34\x96\xe1\x74\xfc\x32\xa3\x0c\xa7\xe8\x2f\xfd\x1a\x8c\x40\x00\x00\x00\x00\x00\x97\x1f\xe6\xfa\x1f\xdc\x68\x9c\x40\x7f\xc4\x02\x93\xd9\xf4\xc6\xc3\xf4\x29\xea\x00\x00\x00\x00\x13\x4c\x45\x05\xd9\x1f\xec\xaa\x76\xc7\x62\xac\xe6\x02\x28\x3b\xac\x83\x00\x00" },
  { 1103, 2, 23, "\x81\x01\x00\x81\x05\x01\x11\x81\x21\x01\x0e\x81\x35\x01\x22\x01\x13\x81\x8c\x01\x13\x82\x01\x01\x01\x6a\x01\x10\x82\x01\x12\x81\xa5\x82\x02\x03\x01\x1c\x81\x81\x81\x59\x82\x02\x0c\x81\xf4\x81\x32" },
  { 1108, 2, 6, "\x81\x01\x82\x0b\xe5\x01\x9c\x82\x16\xb9\x81\x9c\x82\x0b\xe5" },
  { 1111, 2, 22, "\x81\x01\x01\x04\x81\x08\x01\x01\x81\x0f\x01\x15\x81\x5f\x01\x2d\x81\x46\x81\x44\x81\x80\x01\x28\x81\xc0\x81\xed\x01\x55\x81\xfc\x81\xd9\x81\x3e\x81\x6b\x81\x95\x81\x51\x81\x36" },
  { 1112, 2, 14, "\x81\x01\x81\x34\x01\xc2\x82\x01\x8e\x01\x45\x82\x04\x94\x01\x23\x82\x07\x72\x81\x23\x82\x04\x94\x81\x45\x82\x01\x8e\x81\xc2\x81\x34" },
  { 1123, 1, 5, "\x09\x42\x10\x6a\x81\xf8\x14\x00\x00\x00\x9a\x07\x65\x0b\x2c\x12\xf0\xf4\x3b\xd7\x0e\x4e\xe4\x43\x0b\xe3\x91\x03\x4d\xb0\x00\x00\x00\x00\x00\x00\x00\x19\x09\xb6\x95\xb1\xdb\xe1\x12\xac\x84\xde\x72\x65\x07\x73\x10\xd9\x67\xe0\xaa\x80\x00\x00\x00\x00\x00\x16\x3b\xbb\xf2\x51\xf8\x0c\x28\xd6\x42\x0e\x30\xab\x59\x52\xab\x56\x14\x8e\x80\x00\x00\x00\x13\xec\x5a\x0b\x61\xc5\x6b\xc3\x0b\xa6\x36\xff\xf7\xf3\x73\x94\x71\xfa\x00\x00" },
  { 1124, 2, 20, "\x01\x01\x81\x3f\x02\x01\x62\x82\x01\xef\x82\x02\xc0\x02\x05\xef\x02\x01\xf6\x82\x05\x49\x82\x0a\x71\x81\x98\x02\x0f\xf0\x81\x98\x82\x0a\x71\x82\x05\x49\x02\x01\xf6\x02\x05\xef\x82\x02\xc0\x82\x01\xef\x02\x01\x62\x81\x3f" },
  { 1128, 2, 8, "\x01\x01\x03\x02\xe2\x10\x83\x52\x67\xa4\x83\x03\xdd\x30\x83\xa0\xdf\xba\x03\x03\xdd\x30\x83\x52\x67\xa4\x83\x02\xe2\x10" },
  { 1135, 2, 18, "\x81\x01\x81\x01\x01\x08\x01\x09\x81\x2b\x81\x83\x81\x90\x81\x01\x01\xe4\x02\x01\x85\x02\x01\x72\x01\xc7\x81\x40\x82\x01\x62\x82\x02\x00\x82\x01\xb7\x81\xeb\x81\x36" },
  { 1144, 2, 12, "\x01\x01\x81\x3c\x01\x30\x81\x18\x81\x18\x81\x54\x82\x01\x86\x81\x54\x81\x18\x81\x18\x01\x30\x81\x3c" },
  { 1147, 1, 6, "\x8a\x23\xfd\xfe\x12\x83\x7a\xc0\x00\x00\x00\x1c\x20\x87\x12\x13\x85\x41\x87\x2c\x83\xaa\xec\x7c\x47\x95\x1c\x8b\xf9\xfc\xf0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x01\x59\x1f\x8c\x94\x94\x1e\xab\xd3\x4a\xab\xe4\xde\x22\xd4\x81\x08\x2d\xe0\x90\x00\x00\x00\x00\x00\x00\x00\x19\x29\x03\x45\x97\x2c\xca\x5b\xb5\x67\x79\x58\x01\x47\xf1\xfc\x1f\xdb\x5c\x88\x80\x00\x00\x00\x00\x00\x97\x01\x36\x63\xce\x69\x2b\x86\x05\x25\x16\xe5\x11\x67\x3a\x84\x08\x79\x62\x81\x40\x00\x00\x00\x14\x02\xd3\xad\x3b\x7d\xfe\x65\x15\x02\x4b\x71\x39\x57\xe7\x73\xed\xa8\x9f\x00\x00" },
  { 1159, 2, 16, "\x81\x01\x01\x05\x81\x01\x81\x17\x01\x16\x01\x20\x81\x6a\x01\x22\x01\x72\x81\x89\x81\x5f\x01\xf5\x81\x6a\x81\xbf\x01\xbe\x81\x40" },
  { 1160, 2, 20, "\x01\x01\x81\x42\x02\x01\x31\x81\x9a\x82\x04\xfc\x02\x06\x46\x01\xcf\x82\x10\x3e\x02\x09\x7f\x02\x0a\xd4\x82\x1d\x08\x02\x0a\xd4\x02\x09\x7f\x82\x10\x3e\x01\xcf\x02\x06\x46\x82\x04\xfc\x81\x9a\x02\x01\x31\x81\x42" },
  { 1171, 1, 7, "\x0b\x45\xd1\xf7\x4b\xd3\x4e\xe0\x00\x00\x00\x00\xa0\x05\xbd\x8a\x7f\x11\x13\x4b\xe0\x79\x96\x24\x31\x40\xd7\xc7\x91\x3e\x33\xcb\xe2\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x02\xa8\xb6\xbf\x58\xe2\x9f\x44\x72\xd6\x1f\x75\xb3\x36\x4c\x5d\x62\xb4\x42\xb3\xff\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\x29\xfc\xb5\x07\x3e\x40\x2b\x6c\x1c\xc9\x71\xa0\x5b\xa4\x82\x97\x04\x67\x9c\xdb\x4c\x70\x00\x00\x00\x00\x00\x00\x00\x1c\x02\x32\x6d\xf6\xa4\xdf\x54\xb7\xb9\x8b\xeb\x3f\x63\xa2\x52\x97\xf9\x21\x68\x96\xf4\x03\x40\x00\x00\x00\x00\x00\x18\x02\xad\xee\x72\xba\x55\x69\x8b\x5a\x88\x41\x4c\x64\x20\x9a\xd0\x86\xde\x3d\x09\x80\x00\x00\x00\x14\x08\x8e\x23\xfe\x2d\x87\x77\x97\x5c\x7e\x99\x1d\x1d\x6e\x09\x73\xa1\x01\x80\x00" },
  { 1172, 2, 18, "\x81\x01\x82\x0f\x29\x03\x01\x49\xfb\x83\x09\x51\x06\x03\x13\x3e\x7d\x83\x05\xa5\x91\x83\x0b\x9e\x7d\x83\x0d\xca\xd6\x03\x06\x77\x32\x03\x25\xf0\x2c\x83\x06\x77\x32\x83\x0d\xca\xd6\x03\x0b\x9e\x7d\x83\x05\xa5\x91\x83\x13\x3e\x7d\x83\x09\x51\x06\x83\x01\x49\xfb\x82\x0f\x29" },
  { 1192, 2, 6, "\x81\x01\x81\x41\x81\x05\x01\x72\x01\x05\x81\x41" },
  { 1203, 1, 6, "\x0c\x03\x51\x33\xf3\xa0\x70\x36\x88\x00\x00\x00\x00\x21\x3b\xb7\x45\xbc\x5a\x64\xdc\xd2\xe3\x67\x21\xdc\x01\x90\x9d\x34\x5f\x8c\x02\x4b\x94\x7f\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x5b\x99\xd9\x6c\xe3\xee\x54\x49\x93\x5a\x95\xa1\xa7\x8a\xcf\x73\x68\x9d\x8c\x63\x8a\xeb\x86\x37\x80\x00\x00\x00\x00\x00\x00\x00\x9e\x01\xe0\xd4\x11\xe9\xc1\x44\x80\x9f\x00\x9c\x50\x1e\x7e\x5d\x7c\x8e\xec\x98\x6b\x76\x51\xb5\xdf\x60\x00\x00\x00\x00\x00\x1b\x03\x09\x43\x85\x2c\xed\x66\x9c\x31\x6d\x75\x74\x1d\xee\x3e\x6a\xe8\x7b\x69\x44\x20\xb5\xcd\xc0\x00\x00\x00\x14\x24\xcd\x33\x8a\xe1\xef\x15\x96\x3b\xfc\xbb\x19\xed\x91\x87\x7d\xe8\xf5\x80\x00" },
  { 1204, 2, 8, "\x01\x01\x02\x11\x3a\x02\x33\x7d\x02\xb2\xaa\x02\x91\x14\x82\xb2\xaa\x02\x33\x7d\x82\x11\x3a" },
  { 1207, 2, 18, "\x01\x01\x81\x09\x01\x2a\x81\x79\x01\xfa\x82\x01\xb5\x02\x02\xb8\x82\x04\x0d\x02\x05\x95\x82\x06\xf6\x02\x08\x04\x82\x08\x4f\x02\x07\xa1\x82\x05\xf3\x02\x03\xd9\x82\x02\x18\x01\xe0\x81\x46" },
  { 1208, 2, 12, "\x01\x01\x81\x3e\x82\x01\x31\x82\x05\x82\x82\x0e\x66\x82\x18\x4e\x82\x1c\x59\x82\x18\x4e\x82\x0e\x66\x82\x05\x82\x82\x01\x31\x81\x3e" },
  { 1219, 1, 6, "\x8b\x0e\xe5\xf6\x7b\x95\x36\x67\x00\x00\x00\x00\x1f\x30\xb0\x3d\x97\x90\xb2\xe9\xde\x4f\x70\xef\x72\x10\xe2\xc1\xd0\x54\x07\x9c\xc0\xaa\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x02\xa8\x18\x5a\x4f\xfe\x0d\x09\x18\xe4\x57\x0d\x14\xa5\x73\x7d\xca\x92\xab\x33\x20\x3a\x30\x00\x00\x00\x00\x00\x00\x00\x1c\x2e\x8f\xfa\x8d\xbb\x32\xd5\x63\xb3\x1f\xad\xa3\x39\x9b\x50\x08\xc9\x00\x04\x01\xec\xb4\x40\x00\x00\x00\x00\x00\x98\x60\x1c\x12\x26\x5c\xf1\x83\xd7\x46\x3e\x70\x07\x9d\xd0\xac\x56\x57\x41\xd8\xa7\x00\x00\x00\x00\x14\x4b\xc6\x44\x1f\x45\x5c\xe4\x56\x7d\x69\x52\xb5\x73\x53\x95\xc6\x0e\x4b\x00\x00" },
  { 1220, 2, 16, "\x01\x01\x81\x3c\x82\x02\x1c\x82\x09\x24\x82\x17\x6d\x82\x2e\x18\x82\x49\x5c\x82\x5d\x98\x82\x68\x58\x82\x5d\x98\x82\x49\x5c\x82\x2e\x18\x82\x17\x6d\x82\x09\x24\x82\x02\x1c\x81\x3c" },
  { 1227, 1, 4, "\x0b\x01\x1f\xeb\x20\xd0\xcf\xb8\xc1\x40\x00\x00\x1d\x03\x4f\x81\xe6\xc4\x1a\xc1\xca\xa7\xb5\x27\xa3\xe7\xf5\x38\x84\xbc\xef\x7c\xf8\x51\xdf\x00\x00\x00\x00\x00\x00\x00\x1b\x0c\xd7\x66\x27\xad\xab\x02\x5c\x5a\x6f\x49\x1d\xea\xe3\x5e\x4e\x62\xfe\x50\x24\x40\x91\x77\xc0\x00\x00\x00\x14\x6c\x89\x91\x9f\x5a\x1a\x88\x46\x3b\xa7\x48\x13\x11\x61\x12\x8c\x8e\xa8\x00\x00" },
  { 1236, 2, 12, "\x01\x01\x05\x1c\x8e\xc8\x97\xb8\x06\x8c\xc7\x7a\x3e\xeb\x6a\x07\x0b\x2d\x05\xc3\x2d\x72\x68\x08\x02\x16\x41\x03\x22\x04\x31\x4f\x08\x01\x01\xa7\x84\xb7\xec\xea\x30\x88\x03\x11\xfa\x49\x91\x75\xa9\x74\x88\x01\x01\xa7\x84\xb7\xec\xea\x30\x08\x02\x16\x41\x03\x22\x04\x31\x4f\x87\x0b\x2d\x05\xc3\x2d\x72\x68\x06\x8c\xc7\x7a\x3e\xeb\x6a\x85\x1c\x8e\xc8\x97\xb8" },
  { 1240, 2, 8, "\x01\x01\x01\x46\x81\x49\x81\x46\x81\x34\x01\x46\x81\x49\x81\x46" },
  { 1243, 1, 4, "\x09\x01\xb1\xc9\xd7\x5b\x05\x00\x00\x00\x98\x02\x3a\xbc\xfa\xfe\xad\x2b\x11\x68\x2b\x04\xce\x9a\xd0\x9f\xce\xf4\x1b\x00\x00\x00\x00\x00\x00\x16\x46\xe2\xd0\x68\xb7\x26\xf4\xc0\x37\x95\xa1\x25\x79\x2b\xac\x88\xd0\xb8\x40\x00\x00\x00\x14\xdd\xe8\x7c\xce\x1e\x72\x80\x59\xa9\x38\x4b\x81\xad\x8d\xe5\x09\x53\x93\x00\x00" },
  { 1252, 2, 8, "\x01\x01\x81\x4c\x01\xfd\x82\x02\x04\x02\x02\x64\x82\x02\x04\x01\xfd\x81\x4c" },
  { 1255, 2, 12, "\x81\x01\x81\x01\x81\x07\x81\x02\x01\x1a\x81\x09\x81\x51\x81\x12\x01\x0a\x81\xa1\x81\xda\x81\x46" },
  { 1267, 1, 6, "\x0a\x49\x65\xc2\x92\x46\x01\x00\x00\x00\x00\x9d\x02\x47\x92\x0a\xf9\x7d\x93\x06\x3c\xa7\xb4\x00\x5b\x56\xc6\x4d\x49\x91\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1b\x3d\xba\x21\xf1\x97\x1a\x38\xac\xb2\x13\x73\xa2\x76\x4f\xb8\x0d\x33\xa6\x5d\xb0\x00\x00\x00\x00\x00\x00\x00\x99\xc1\x3a\x2d\xb6\x19\xce\x63\x61\xec\xcd\x44\x90\xad\x5a\x6b\x5b\xb3\x0e\xb0\xc0\x00\x00\x00\x00\x00\x18\x01\x4a\xc1\x3e\xe1\x50\x0b\x84\x4e\xb3\xbf\xa5\x59\xef\x3f\xf2\xe5\x6e\x1f\x33\x00\x00\x00\x00\x15\x02\x83\x30\xd9\x3c\xec\x97\x6f\xcb\x0e\xc9\x38\x23\x24\x7c\xfb\xe2\x81\x4f\x00\x00" },
  { 1268, 2, 10, "\x81\x01\x82\x15\xe9\x83\x01\x5e\xd9\x83\x09\x23\x8a\x03\x0a\x71\x2f\x83\x09\xa6\x43\x83\x0a\x71\x2f\x83\x09\x23\x8a\x03\x01\x5e\xd9\x82\x15\xe9" },
  { 1272, 2, 12, "\x01\x01\x83\x06\x86\x28\x83\xec\xc7\xa2\x04\x01\x21\xe8\xb8\x84\x06\xcd\x6f\xd1\x04\x0e\x3e\x0e\xf0\x84\x15\xf0\xee\x5c\x04\x0e\x3e\x0e\xf0\x84\x06\xcd\x6f\xd1\x04\x01\x21\xe8\xb8\x83\xec\xc7\xa2\x83\x06\x86\x28" },
  { 1279, 2, 23, "\x81\x01\x01\x07\x81\x0f\x01\x06\x81\x01\x01\x15\x81\x11\x81\x02\x81\x2e\x01\x0a\x81\x6c\x01\x81\x01\x62\x01\x90\x01\x55\x81\x08\x81\xbb\x01\x52\x82\x01\x6b\x81\xd8\x01\x80\x01\x33\x81\x4d" },
  { 1288, 2, 8, "\x01\x01\x81\x4e\x01\x21\x81\x06\x01\xa4\x81\x06\x01\x21\x81\x4e" },
  { 1303, 2, 11, "\x81\x01\x81\x08\x81\x1e\x81\x39\x81\x43\x81\x3b\x81\x49\x81\x44\x81\x21\x81\x39\x81\x4f" },
  { 1315, 1, 6, "\x0c\x0a\x2d\x7f\xd4\xd2\x3a\x61\x24\x00\x00\x00\x00\x21\x06\xd0\x2a\xc1\x0b\x80\xeb\x78\xd8\x59\xef\x24\x92\xde\x2b\xcf\x06\xcb\x9a\xca\xa2\x0f\x48\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x12\x25\xd0\x64\x70\xc3\xf2\xc2\x98\x9a\x9a\x31\x52\x6a\xbf\xe0\x9a\xc2\xad\xf6\x0d\xee\xcf\x70\x00\x00\x00\x00\x00\x00\x00\x9c\x2e\xfd\x68\x1b\x31\x86\xbe\x31\xff\x8a\x5b\x87\x3a\x6f\x81\x4e\x96\x35\xd8\x0e\x3a\xe6\xc0\x00\x00\x00\x00\x00\x19\x25\x60\xbb\xff\x5f\xb1\xa6\xa4\xc9\x5f\x91\x24\x93\x1c\x30\xf3\x8c\xcd\xc1\xf2\x64\x00\x00\x00\x00\x15\x14\x7c\xba\xe3\x28\x32\x88\x5e\xaf\x2b\x6c\x45\x27\x24\x2b\x1d\xde\x1a\xdf\x00\x00" },
  { 1320, 2, 8, "\x01\x01\x03\x08\x7a\x00\x84\x01\x92\xac\x84\x04\x08\xb9\x93\x00\x83\x84\xbb\xfa\x84\x08\xb9\x93\x00\x84\x01\x92\xac\x84\x83\x08\x7a\x00" },
  { 1327, 2, 15, "\x81\x01\x81\x06\x81\x10\x81\x18\x81\x26\x01\x01\x81\x18\x01\x03\x81\x34\x81\x14\x81\x0d\x01\x64\x01\x12\x81\x15\x81\x53" },
  { 1336, 2, 12, "\x01\x01\x81\x54\x81\x30\x82\x01\x08\x81\x18\x82\x01\x5c\x82\x02\x46\x82\x01\x5c\x81\x18\x82\x01\x08\x81\x30\x81\x54" },
  { 1347, 1, 6, "\x0d\x01\x3f\x94\xfc\xe9\xe2\x44\xd3\xd7\x80\x00\x00\x00\xa3\xbf\xea\xd9\xe7\x98\xe5\x59\x1b\x57\x98\x00\x2b\x5c\x59\x94\xeb\xc0\xf8\xcd\xa8\x07\xe0\x14\xf7\xb9\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x27\xed\x27\xa6\x83\xa0\xeb\x7a\xdd\x4c\xb0\x70\xef\xc0\x35\x93\x2c\xb4\xda\xf1\xe6\xcb\xf4\xaa\x41\x5e\x10\x00\x00\x00\x00\x00\x00\x00\x1f\x3a\xa8\x62\xa9\xc3\x01\x4b\x91\x6d\x24\xe9\x4d\x85\x48\x43\x8d\xf8\x8d\x97\x74\x72\x37\x5f\x21\x3f\xc0\x00\x00\x00\x00\x00\x1c\x37\x6d\x98\x9d\x98\x2a\x38\xc3\x29\x21\x50\xd0\x47\xb0\xf9\x64\xef\x03\xba\x88\xdc\xbc\x79\x35\x80\x00\x00\x00\x15\x51\x41\xa3\x04\xa1\x64\x25\xac\x28\x12\xd6\x1d\x82\xa2\xb5\xe2\x59\x82\x78\x80\x00" },
  { 1348, 2, 8, "\x01\x01\x81\x55\x81\x7d\x01\x3c\x01\xea\x01\x3c\x81\x7d\x81\x55" },
  { 1351, 2, 24, "\x01\x01\x01\x09\x01\x1e\x01\x31\x01\x2a\x81\x04\x81\x07\x01\x82\x01\xda\x01\xa5\x01\x24\x81\x68\x01\x33\x02\x01\x1f\x02\x01\x34\x01\x01\x81\xca\x01\x7b\x01\xde\x02\x01\x84\x01\xd5\x81\xca\x81\x4c\x81\x56" },
  { 1363, 1, 6, "\x8b\x20\xa5\x94\x54\x02\xcb\x65\x00\x00\x00\x00\x1f\x32\xc2\x53\xf1\xa2\x68\xe4\xe7\xde\xe2\x76\x78\x06\xba\xe6\x8b\x73\xdb\xad\xff\xa3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9d\xa1\x55\xb4\x89\xce\x3c\x2c\xf0\xbf\x94\xe0\x43\xd7\x55\xfb\x7b\x21\x75\x25\xd6\x51\xb0\x00\x00\x00\x00\x00\x00\x00\x1b\x8d\x22\xf4\xed\x84\xb0\x65\x77\x00\xa2\xfa\xda\xbc\x49\xeb\xbd\xfb\x3b\xf2\x39\x7c\x80\x00\x00\x00\x00\x00\x98\x43\xb6\x93\x81\x0c\xea\x06\x7e\x29\x7b\xe6\x1d\xcc\xa8\x86\xfe\xe8\xc1\xb9\x29\x80\x00\x00\x00\x15\xa0\xd5\xa1\x71\xaa\x7f\x52\xd0\xdf\x1f\xdd\xe3\x41\x56\xb2\x27\xcc\x8d\x06\x00\x00" },
  { 1380, 2, 8, "\x01\x01\x83\x0b\xae\x64\x84\x02\x4d\x62\x08\x84\x09\x51\xbe\x8c\x04\x17\x63\xea\x2e\x84\x09\x51\xbe\x8c\x84\x02\x4d\x62\x08\x83\x0b\xae\x64" },
  { 1384, 2, 10, "\x81\x01\x81\x5d\x81\x4e\x01\xdd\x02\x01\x67\x82\x02\x70\x82\x01\x67\x01\xdd\x01\x4e\x81\x5d" },
  { 1387, 1, 4, "\x09\x06\xe3\xb9\x11\xa0\x0a\xa0\x00\x00\x19\x05\xd8\x30\x67\x8a\x03\xdc\x59\x1a\x4a\x15\xc7\xe2\x79\xec\x8a\x67\x84\xe4\xe0\x00\x00\x00\x00\x00\x17\x57\xec\x66\x85\xbc\x66\x98\xca\x2d\x4b\x44\x55\x46\x2c\x57\xf4\x52\x14\x6f\xc0\x00\x00\x00\x16\x01\xbc\x8b\xf0\x83\xad\x1f\x82\xe8\xf8\xc0\x7c\x75\xe1\x0d\xce\x94\x68\xea\xb0\x80\x00" },
  { 1396, 2, 14, "\x81\x01\x82\x22\x8c\x03\x01\x2f\x01\x83\x04\x0c\x68\x03\x04\x2d\x20\x03\x05\xbc\x68\x83\x0b\xdc\x8e\x83\x05\x3d\xa8\x03\x0b\xdc\x8e\x03\x05\xbc\x68\x83\x04\x2d\x20\x83\x04\x0c\x68\x83\x01\x2f\x01\x82\x22\x8c" },
  { 1411, 1, 4, "\x0b\x05\x47\x5f\x4c\x45\x72\x0c\xf1\x40\x00\x00\x1e\x51\x98\xbd\xab\x02\x24\xe2\xb4\x75\x74\x8d\x95\xa2\xc7\x72\x4a\x19\x3c\xc9\x78\x72\x49\x28\xf4\x20\x00\x00\x00\x00\x00\x1a\x0c\x2d\x69\x94\xdd\xa4\xae\x27\x3d\xb5\x15\xbb\x53\x4d\xf1\xac\xbd\xcd\xaf\x89\x78\x8a\xc0\x00\x00\x00\x16\x04\xc2\x03\x1c\x0b\xfa\x7d\x0f\x93\x76\xd8\x71\xfe\x69\xba\x71\x05\x92\x4e\x29\x80\x00" },
  { 1412, 2, 16, "\x01\x01\x81\x65\x02\x01\x98\x02\x01\x17\x82\x08\x6f\x82\x08\xd4\x02\x05\x5a\x82\x08\xde\x82\x1b\x08\x82\x08\xde\x02\x05\x5a\x82\x08\xd4\x82\x08\x6f\x02\x01\x17\x02\x01\x98\x81\x65" },
  { 1416, 2, 16, "\x01\x01\x83\x0e\x1c\xcc\x84\x02\x2b\x40\x50\x04\x17\x83\xca\x7c\x84\x54\x03\x73\x34\x84\x9e\xc1\x32\xac\x84\x9f\xe9\xf0\x70\x84\xb5\xac\x7b\x04\x85\x01\xb9\xde\xb8\x1a\x84\xb5\xac\x7b\x04\x84\x9f\xe9\xf0\x70\x84\x9e\xc1\x32\xac\x84\x54\x03\x73\x34\x04\x17\x83\xca\x7c\x84\x02\x2b\x40\x50\x83\x0e\x1c\xcc" },
  { 1423, 2, 9, "\x81\x01\x01\x05\x81\x16\x01\x25\x81\x41\x01\x2a\x81\x59\x01\x26\x81\x63" },
  { 1428, 2, 8, "\x01\x01\x05\xe1\xb1\x28\x46\xd0\x07\x08\x8c\xe0\x72\x22\x89\x5c\x07\x49\x91\x55\x07\xe9\x30\x90\x87\x0d\x32\xb7\xb5\x83\xe1\xba\x87\x49\x91\x55\x07\xe9\x30\x90\x07\x08\x8c\xe0\x72\x22\x89\x5c\x85\xe1\xb1\x28\x46\xd0" },
  { 1432, 2, 6, "\x81\x01\x81\x64\x01\x10\x81\x8a\x81\x10\x81\x64" },
  { 1435, 1, 4, "\x8b\x01\x50\x6b\x7c\x3d\xe1\xfc\x3a\x70\x00\x00\x1d\x5e\x36\x76\xf9\x80\x59\xc2\x7c\x84\xe6\x9c\x9f\xa9\x76\xe5\xc3\x7a\x43\xea\x3a\x7f\x1d\xf0\x00\x00\x00\x00\x00\x00\x1a\x41\x71\x31\x9e\xdc\xef\x23\xcb\x11\x94\x0f\xe6\x7d\xd1\xf8\x25\xf4\xf6\x06\x8e\x88\x4d\x80\x00\x00\x00\x16\x0c\xec\xdc\xc9\x12\x96\x38\xf6\xbb\x53\x43\x2f\x7f\x01\x82\xa6\xc1\x3e\x75\x60\x00\x00" },
  { 1447, 2, 23, "\x81\x01\x81\x02\x81\x10\x81\x22\x81\x44\x81\x3f\x81\x11\x01\x2b\x01\x8b\x01\xa5\x81\x19\x81\xe4\x82\x01\x09\x82\x01\x0e\x81\x4b\x01\xf6\x01\x82\x81\xa1\x81\xf0\x82\x01\x89\x82\x02\x39\x82\x01\x81\x81\x63" },
  { 1448, 2, 18, "\x81\x01\x81\x6e\x82\x02\xde\x82\x04\x38\x02\x0a\x4e\x02\x16\x62\x82\x06\xed\x82\x2e\x54\x82\x08\xb4\x02\x37\xf0\x02\x08\xb4\x82\x2e\x54\x02\x06\xed\x02\x16\x62\x82\x0a\x4e\x82\x04\x38\x02\x02\xde\x81\x6e" },
  { 1464, 2, 12, "\x01\x01\x83\x12\x17\x58\x84\x04\x46\xfa\xa2\x84\x21\x5c\x74\x38\x85\x01\x12\x15\x7b\xd1\x85\x02\xcd\xaf\x7d\xf0\x85\x03\xd3\x97\xe0\x5c\x85\x02\xcd\xaf\x7d\xf0\x85\x01\x12\x15\x7b\xd1\x84\x21\x5c\x74\x38\x84\x04\x46\xfa\xa2\x83\x12\x17\x58" },
  { 1471, 2, 23, "\x81\x01\x81\x05\x81\x03\x01\x03\x81\x2b\x81\x06\x01\x1f\x81\x38\x01\x44\x81\x59\x81\x93\x01\xb4\x82\x01\x12\x01\xf0\x01\xd3\x82\x02\x09\x02\x01\x7f\x82\x01\x13\x82\x01\x23\x01\xf9\x82\x01\x66\x81\x09\x81\x6b" },
  { 1480, 2, 12, "\x01\x01\x81\x66\x82\x02\xca\x82\x09\x54\x82\x14\x8e\x82\x20\x82\x82\x25\xda\x82\x20\x82\x82\x14\x8e\x82\x09\x54\x82\x02\xca\x81\x66" },
  { 1483, 1, 7, "\x0c\x06\x24\x8d\xf0\x4f\x85\xfd\xc0\x00\x00\x00\x00\xa1\x33\xab\xd9\xec\x1d\x7b\x5a\x99\xac\xb1\x6c\x49\x33\x47\xfc\x32\xc1\xaf\x2a\x9b\x44\x1c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x0b\x12\xb1\x8a\x85\x9d\x38\xb0\xf6\xa7\xd5\xa5\xa4\x2e\xfe\x11\xdb\x1c\x2d\xfa\x13\x0f\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x36\x8a\x40\xf2\x17\x71\xc5\xd8\xbd\xe8\xc9\xbd\x43\x57\x18\xbc\xf6\x7b\x6a\x13\x29\x1e\x10\x00\x00\x00\x00\x00\x00\x00\x1d\x01\x54\x06\x18\x50\x89\x9e\x7b\xfe\xd6\x9b\x66\x0e\xa4\x7e\x65\xd5\x52\x92\x8d\x8d\x05\x83\x80\x00\x00\x00\x00\x00\x9a\x01\x40\x7d\xc9\x24\x5d\xcf\x91\x1a\x08\xb3\x2d\xc2\xcc\xd7\xa5\x18\x61\x68\xbb\x52\xae\x40\x00\x00\x00\x16\x5d\x0d\xfd\x21\xed\xb2\xf9\x88\xec\x95\x2e\xb2\x22\x4b\xb1\xb5\x46\xca\xee\xb1\x00\x00" },
  { 1492, 2, 10, "\x81\x01\x82\x30\x24\x82\x2e\xe1\x82\x12\x60\x02\x1a\x6f\x82\x35\x04\x82\x1a\x6f\x82\x12\x60\x02\x2e\xe1\x82\x30\x24" },
  { 1495, 2, 20, "\x01\x01\x81\x07\x01\x11\x01\x0b\x81\x57\x01\x20\x01\xea\x81\x97\x82\x01\x99\x01\xde\x02\x01\xf7\x81\x60\x82\x01\x6f\x81\x23\x81\x09\x81\x83\x02\x01\x26\x02\x01\x00\x81\xb2\x81\x6e" },
  { 1507, 1, 4, "\x0a\x02\x14\x4d\xca\xcf\xa5\x2c\x30\x00\x00\x9a\x51\xf9\xcd\xaa\xa5\x8b\xfb\x87\x8e\x14\x06\xa9\xf7\xb9\x9e\x67\xa5\x4b\x63\x59\xc0\x00\x00\x00\x00\x00\x18\x96\xa2\xe5\x7e\x41\x15\x72\x93\xc8\x20\x7d\x64\xc1\xed\x90\x20\x34\x03\x6e\x8f\x00\x00\x00\x00\x16\xf6\xb5\x68\xb7\xe3\xa6\x1e\x1b\x0f\xc7\x52\xe9\xb5\x19\xeb\xc2\x61\x30\xa6\x5b\x00\x00" },
  { 1508, 2, 16, "\x01\x01\x81\x66\x82\x05\x17\x82\x1e\xda\x82\x70\x17\x83\x01\x1b\xe0\x83\x02\x17\xd6\x83\x03\x0a\x00\x83\x03\x70\x3e\x83\x03\x0a\x00\x83\x02\x17\xd6\x83\x01\x1b\xe0\x82\x70\x17\x82\x1e\xda\x82\x05\x17\x81\x66" },
  { 1527, 2, 14, "\x81\x01\x01\x54\x82\x09\x47\x02\x21\x7d\x83\x01\xb5\x60\x03\x07\xe0\xca\x83\x0f\x1f\x69\x03\x4c\x2b\xb0\x84\x01\x5a\xd7\x17\x04\x03\x4b\xcc\x5e\x84\x06\x5e\x90\xba\x04\x09\x22\x6a\xb7\x84\x05\x92\x8a\xd5\x83\x18\xe9\x5b" },
  { 1528, 2, 8, "\x01\x01\x81\x78\x01\xf6\x82\x01\xe0\x02\x02\x03\x82\x01\xe0\x01\xf6\x81\x78" },
  { 1540, 2, 8, "\x01\x01\x81\x76\x82\x01\x1b\x01\xc6\x02\x02\xd8\x01\xc6\x82\x01\x1b\x81\x76" },
  { 1543, 2, 19, "\x81\x01\x01\x09\x81\x18\x01\x06\x01\x2a\x81\x04\x81\x22\x81\x4a\x81\x2e\x01\xee\x01\x31\x81\xb5\x81\xc3\x81\x74\x01\xc1\x02\x01\x13\x81\x6a\x01\x08\x81\x79" },
  { 1544, 2, 20, "\x01\x01\x81\x74\x82\x02\x66\x82\x04\x54\x02\x09\x23\x02\x02\x68\x82\x1d\x70\x82\x40\x58\x82\x28\x43\x02\x34\x54\x02\x79\xa2\x02\x34\x54\x82\x28\x43\x82\x40\x58\x82\x1d\x70\x02\x02\x68\x02\x09\x23\x82\x04\x54\x82\x02\x66\x81\x74" },
  { 1555, 1, 4, "\x0a\x77\x67\x2f\x66\xf9\x14\x7a\x30\x00\x00\x9d\x05\xb4\x70\x5d\x2f\x31\xb5\x6d\x91\x98\x13\x59\x74\xae\x42\xec\x07\x0e\xd5\x3e\x20\xb5\xdb\x40\x00\x00\x00\x00\x00\x1b\x58\xc7\x14\x3f\x52\x0e\x69\xab\x61\xb0\x09\xa4\x00\xe2\xf9\xe4\x4d\xda\xba\xd1\x08\x0d\x53\x00\x00\x00\x00\x17\x06\x9e\xa6\x1b\x7c\xc7\x0f\xa7\xb4\x6a\x3b\xed\x5a\x2c\x0f\xee\x91\x2b\x78\x4d\x31\x00\x00" },
  { 1560, 2, 16, "\x01\x01\x03\x1d\x60\xd8\x84\x08\xa5\x8a\x38\x04\x63\x48\x13\xb8\x85\x01\x58\xf8\x28\x64\x05\x01\x05\x0e\xfc\x18\x05\x02\x85\xe9\x52\x78\x84\x90\xfd\x76\xc8\x85\x03\x15\x41\xae\xba\x04\x90\xfd\x76\xc8\x05\x02\x85\xe9\x52\x78\x85\x01\x05\x0e\xfc\x18\x85\x01\x58\xf8\x28\x64\x84\x63\x48\x13\xb8\x84\x08\xa5\x8a\x38\x83\x1d\x60\xd8" },
  { 1563, 1, 6, "\x0d\x01\x39\x3e\xeb\x9a\xff\x00\xfb\x50\x00\x00\x00\x00\xa3\x64\x07\xc2\x49\xb0\x33\xd6\xe0\xe9\xa4\x14\xd0\xcf\xd8\xee\x99\x75\xa6\x88\xcf\x25\xf4\x99\x98\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x05\x6c\x47\x9f\xb4\xa2\xbf\x51\x83\x00\xb2\x6a\x42\xc6\xfb\xc3\x21\x7b\xee\xa3\xdb\x83\x92\xdc\x3e\x6c\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x05\x1d\xb0\x93\x6f\x2e\xcf\x3e\xfa\x68\x7a\x1e\x43\x9d\x6a\x4d\x07\x14\x40\xb8\xaf\x4b\x7f\x83\xcf\x4a\x00\x00\x00\x00\x00\x00\x1e\x78\xa3\xf9\xf9\xdd\xa3\x16\xb3\x9c\x86\x7f\x56\x22\xa2\x06\x57\x7e\xc5\x5b\x4e\x9d\x38\xab\xe8\xd8\x97\xc0\x00\x00\x00\x17\x09\x19\xb3\x13\x8d\xc0\x3d\x92\xfc\x32\xa0\xf4\x17\xf2\x1b\x36\x3e\x3f\x74\x89\x4e\x00\x00" },
  { 1567, 2, 15, "\x81\x01\x01\x01\x81\x0d\x01\x2c\x81\x4c\x01\xb6\x82\x01\x3d\x02\x01\x4a\x82\x01\x96\x02\x02\x0a\x82\x02\x14\x02\x02\x8a\x82\x02\x9e\x02\x01\x91\x81\x81" },
  { 1572, 2, 12, "\x01\x01\x83\x1f\x2e\x4e\x84\x07\xc8\xfa\x76\x84\x04\x07\x88\xee\x84\x1b\xce\xc3\x81\x84\x06\x44\xc8\xc4\x84\x2c\x9d\xa4\x14\x84\x06\x44\xc8\xc4\x84\x1b\xce\xc3\x81\x84\x04\x07\x88\xee\x84\x07\xc8\xfa\x76\x83\x1f\x2e\x4e" },
  { 1576, 2, 10, "\x81\x01\x81\x7f\x01\x5b\x82\x01\xc2\x81\xd1\x81\xd1\x01\xd1\x82\x01\xc2\x81\x5b\x81\x7f" },
  { 1588, 2, 6, "\x81\x01\x82\x42\x4e\x02\x34\x4a\x83\x01\x46\xd0\x82\x34\x4a\x82\x42\x4e" },
  { 1591, 2, 22, "\x81\x01\x81\x01\x01\x04\x81\x1d\x81\x79\x81\x2e\x02\x01\x37\x02\x01\x58\x82\x01\x87\x82\x03\x3e\x01\xea\x02\x06\x74\x02\x03\xef\x82\x06\x69\x82\x0b\x64\x82\x02\xae\x02\x07\xb5\x02\x06\x4b\x81\x52\x82\x02\x67\x82\x01\x7b\x81\x80" },
  { 1603, 1, 6, "\x0c\x02\xc4\x06\x2d\x04\x6d\xe3\xb0\x00\x00\x00\x00\xa0\x85\xb6\xd8\x85\xc0\x95\x76\xa7\xff\xe1\xc5\x37\x47\x1f\xdf\x6b\xfc\x96\x24\x2e\xb6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x01\x74\x25\x71\xb8\x8c\x07\xbf\xfa\x38\xb7\xaf\xec\x5a\xa6\xa3\x11\x14\xc4\xde\xa2\xc1\x34\x00\x00\x00\x00\x00\x00\x00\x00\x9c\x87\x70\xad\x3f\x91\x81\x6f\xd0\x11\x4e\x73\x23\xd9\xb7\x84\xa0\x05\xb6\x70\xa0\x23\x94\x00\x00\x00\x00\x00\x00\x1a\xa7\x54\x08\x35\x86\x32\x9c\x55\x8c\x16\xe1\xe1\xc6\xd5\x85\x67\xfd\x0f\xf4\x8a\x5d\xae\xc0\x00\x00\x00\x17\x2c\x25\xfe\x36\x6f\x7c\xee\x3a\xe6\xec\xe2\x02\x29\x23\x1d\xef\xac\x81\x5c\xc4\x30\x00\x00" },
  { 1604, 2, 20, "\x01\x01\x81\x87\x01\xbb\x82\x0a\x5e\x02\x18\x10\x82\x3e\x12\x02\x58\xed\x82\xbd\x01\x02\x8c\xb7\x83\x01\x43\x90\x02\x96\x30\x83\x01\x43\x90\x02\x8c\xb7\x82\xbd\x01\x02\x58\xed\x82\x3e\x12\x02\x18\x10\x82\x0a\x5e\x01\xbb\x81\x87" },
  { 1608, 2, 16, "\x01\x01\x83\x25\x3a\x94\x84\x08\xfd\x86\x10\x04\x32\x70\x0e\x64\x84\xd3\xb0\x68\xb4\x05\x03\x2e\xf7\xb4\x4c\x85\x08\xce\x35\xa6\xb0\x05\x10\x25\xf5\x77\xe4\x85\x13\xbb\xc8\xd5\x1a\x05\x10\x25\xf5\x77\xe4\x85\x08\xce\x35\xa6\xb0\x05\x03\x2e\xf7\xb4\x4c\x84\xd3\xb0\x68\xb4\x04\x32\x70\x0e\x64\x84\x08\xfd\x86\x10\x83\x25\x3a\x94" },
  { 1624, 2, 16, "\x01\x01\x01\x8e\x02\x02\x15\x02\x02\x96\x81\x47\x82\x01\x8c\x81\xf6\x82\x03\xc0\x01\xea\x02\x03\xc0\x81\xf6\x02\x01\x8c\x81\x47\x82\x02\x96\x02\x02\x15\x81\x8e" },
  { 1636, 2, 16, "\x01\x01\x81\x8b\x82\x01\x06\x82\x02\x79\x82\x02\x3d\x82\x02\x44\x82\x06\x14\x82\x08\x5c\x01\x64\x82\x08\x5c\x82\x06\x14\x82\x02\x44\x82\x02\x3d\x82\x02\x79\x82\x01\x06\x81\x8b" },
  { 1639, 2, 22, "\x81\x01\x81\x02\x81\x0e\x81\x11\x01\x09\x00\x81\x59\x01\x33\x81\x22\x81\x02\x81\x6e\x01\x3a\x82\x01\x50\x01\xea\x82\x02\x8a\x01\x78\x81\xa3\x82\x01\x01\x82\x01\x07\x82\x01\x13\x02\x01\x59\x81\x90" },
  { 1640, 2, 16, "\x01\x01\x01\x8a\x82\x02\x09\x02\x0a\x3e\x82\x11\xcf\x82\x14\xc8\x02\x33\xde\x02\x15\x94\x82\x49\xbe\x82\x15\x94\x02\x33\xde\x02\x14\xc8\x82\x11\xcf\x82\x0a\x3e\x82\x02\x09\x81\x8a" },
  { 1663, 2, 17, "\x81\x01\x01\x01\x01\x0e\x01\x08\x81\x55\x81\xcb\x81\xe1\x81\xdc\x82\x01\x03\x82\x01\x01\x82\x01\x22\x82\x01\x6d\x82\x01\xb5\x82\x02\x1d\x82\x01\xfb\x82\x01\x3a\x81\x91" },
  { 1668, 2, 12, "\x01\x01\x83\x31\xce\xfa\x84\x0e\x99\xb1\x06\x84\x0c\x6c\x7f\x3a\x04\x07\xc8\x58\x3f\x84\x19\xbf\x21\x4c\x84\x47\xa2\x6f\x74\x84\x19\xbf\x21\x4c\x04\x07\xc8\x58\x3f\x84\x0c\x6c\x7f\x3a\x84\x0e\x99\xb1\x06\x83\x31\xce\xfa" },
  { 1672, 2, 8, "\x01\x01\x81\x96\x01\x69\x01\x1e\x82\x01\xe4\x01\x1e\x01\x69\x81\x96" },
  { 1684, 2, 10, "\x81\x01\x82\x5a\x7b\x82\xe6\x89\x83\x06\xce\x2e\x82\x58\x51\x83\x07\xaa\x99\x02\x58\x51\x83\x06\xce\x2e\x02\xe6\x89\x82\x5a\x7b" },
  { 1687, 2, 18, "\x01\x01\x01\x06\x01\x11\x01\x11\x01\x41\x01\x8d\x01\xfc\x02\x01\x89\x02\x01\xb8\x02\x02\x65\x02\x02\xad\x02\x02\x22\x02\x01\xbb\x01\xe3\x01\x52\x01\x08\x81\x8c\x81\x98" },
  { 1688, 2, 10, "\x81\x01\x81\x94\x02\x03\x0e\x82\x04\xfe\x82\x11\xf9\x02\x06\x1c\x02\x11\xf9\x82\x04\xfe\x82\x03\x0e\x81\x94" },
  { 1720, 2, 12, "\x01\x01\x81\x9c\x82\x03\x30\x82\x06\xa8\x82\x09\x18\x82\x0c\x54\x82\x0f\x06\x82\x0c\x54\x82\x09\x18\x82\x06\xa8\x82\x03\x30\x81\x9c" },
  { 1723, 1, 5, "\x0b\x02\x52\x69\x1d\x6f\xfd\x33\x84\x00\x00\x00\x9e\x03\xb5\x06\x6e\x8e\xa9\xa0\xb2\x54\xa6\x99\x82\xe4\x67\xd2\xd7\x38\xfa\x18\x90\x48\x84\x90\x00\x00\x00\x00\x00\x00\x00\x1c\x4d\x5d\x1d\xaa\xbf\x6e\x63\x34\x48\xe8\x5f\x0f\xd4\x32\xe3\xf1\xe1\xbd\x4a\xc9\x04\x62\x40\x00\x00\x00\x00\x00\x1a\x3e\x3c\x24\x93\x65\x45\x86\x17\x10\xbf\xab\x05\xa5\xef\x69\x96\xf7\x3b\xbd\x4c\xef\x9c\x00\x00\x00\x00\x18\x11\x8e\x59\x61\x86\xb3\xd7\x01\xce\x2b\x76\xef\x79\xdb\x26\xe3\x49\x93\x96\x86\x66\x27\x00\x00" },
  { 1732, 2, 12, "\x01\x01\x81\xa8\x02\x02\x78\x82\x05\xca\x02\x0a\xb8\x82\x10\x68\x02\x13\x0a\x82\x10\x68\x02\x0a\xb8\x82\x05\xca\x02\x02\x78\x81\xa8" },
  { 1747, 1, 5, "\x0a\x2f\x0e\x15\x41\x16\xef\x48\x00\x00\x00\x1c\x04\xa8\x6a\xd4\x65\x8b\xfb\xeb\x1d\x6e\xa3\xa9\x27\x4b\x33\xdd\xca\xe3\x47\xe8\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x0c\x3d\xd5\x89\x34\x40\xdc\xf0\x82\xd2\xf2\x75\xae\x21\xd6\x98\x1b\xfd\xe0\x84\xcb\xa0\x00\x00\x00\x00\x00\x99\xab\x18\x51\x27\x87\x25\x84\x40\xb6\x46\xac\x4f\xc9\x98\x6b\x4e\xcc\xcb\x82\x07\xad\x40\x00\x00\x00\x18\x2b\x66\x8b\x6e\xa9\xc5\x71\xaf\xcd\xec\xca\x2b\xf0\x74\x2f\x9a\x5f\x50\x29\x20\x14\x94\x80\x00" },
  { 1752, 2, 8, "\x01\x01\x03\x4a\x39\x10\x84\x18\x97\x2a\xec\x04\x02\xea\xd6\x90\x84\x32\xcd\x2a\x9a\x84\x02\xea\xd6\x90\x84\x18\x97\x2a\xec\x83\x4a\x39\x10" },
  { 1768, 2, 8, "\x01\x01\x01\xae\x01\x30\x81\x78\x81\x97\x01\x78\x01\x30\x81\xae" },
  { 1780, 2, 8, "\x01\x01\x02\x7a\x61\x03\x01\xc5\xbf\x83\x02\x97\x9c\x83\x02\xf2\x5c\x03\x02\x97\x9c\x03\x01\xc5\xbf\x82\x7a\x61" },
  { 1783, 2, 17, "\x81\x01\x81\x07\x81\x1e\x81\x3d\x81\x73\x81\x9e\x81\x5e\x81\x6f\x82\x01\x0c\x82\x01\x9b\x82\x01\xd1\x82\x01\xd9\x82\x01\x3a\x81\x6d\x82\x01\xbe\x82\x01\xf2\x81\xaf" },
  { 1796, 2, 20, "\x01\x01\x81\xb1\x82\x03\x1a\x82\x06\xa9\x02\x11\x2b\x82\x1c\x62\x02\x77\x64\x82\xf7\xba\x03\x01\x36\xf5\x83\x01\x0b\xcb\x02\xc2\xea\x83\x01\x0b\xcb\x03\x01\x36\xf5\x82\xf7\xba\x02\x77\x64\x82\x1c\x62\x02\x11\x2b\x82\x06\xa9\x82\x03\x1a\x81\xb1" },
  { 1807, 2, 12, "\x81\x01\x01\x05\x81\x16\x01\x1e\x81\x36\x01\x98\x82\x01\x03\x01\xff\x81\x63\x81\xaf\x02\x01\x10\x81\xba" },
  { 1812, 2, 12, "\x01\x01\x06\x25\x9b\x4d\x46\x90\x78\x08\x04\xf8\xee\xbd\x50\x15\xb6\x6a\x08\x64\xea\x1f\x72\x08\xa8\xce\xa8\x09\x05\x05\x67\x2d\xd5\xa8\x31\x65\x4f\x09\x09\xbb\x5c\x35\x7a\x82\xfc\xb9\xb0\x09\x17\xf6\xfa\xf7\xf5\xcb\x41\x58\x8c\x89\x09\xbb\x5c\x35\x7a\x82\xfc\xb9\xb0\x09\x05\x05\x67\x2d\xd5\xa8\x31\x65\x4f\x88\x64\xea\x1f\x72\x08\xa8\xce\xa8\x08\x04\xf8\xee\xbd\x50\x15\xb6\x6a\x86\x25\x9b\x4d\x46\x90\x78" },
  { 1816, 2, 14, "\x81\x01\x81\xba\x01\xc9\x82\x03\xe8\x82\x01\x40\x81\x48\x82\x06\xc2\x02\x03\xdc\x02\x06\xc2\x81\x48\x02\x01\x40\x82\x03\xe8\x81\xc9\x81\xba" },
  { 1828, 2, 8, "\x01\x01\x81\xbd\x82\x01\x29\x82\x02\xac\x82\x02\x42\x82\x02\xac\x82\x01\x29\x81\xbd" },
  { 1831, 2, 19, "\x81\x01\x01\x07\x81\x2b\x01\xa9\x82\x01\xda\x02\x03\xc9\x82\x05\x94\x02\x05\xe2\x82\x03\xcd\x01\x61\x02\x01\x19\x02\x01\x96\x82\x07\x9b\x02\x0c\x5a\x82\x0c\x87\x02\x09\x0f\x82\x03\xd3\x02\x01\x2d\x81\xc1" },
  { 1843, 1, 6, "\x0c\x03\x41\x49\x24\x86\x8e\xb0\x88\x00\x00\x00\x00\x21\x0e\xb5\xca\x83\xd2\xdf\xad\x8f\x04\xed\xc1\xb0\x29\x30\x62\x3a\xf5\x0d\xf6\x37\x63\x09\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1f\x25\x3e\x49\x8a\x0e\xfc\x21\xbb\x07\xc1\x95\xfd\x67\xcb\x7e\x4f\x7a\x96\x50\x7a\xc2\x7b\xf0\x00\x00\x00\x00\x00\x00\x00\x00\x1d\x47\xbb\x72\x42\x02\x44\x05\xfc\x32\x5d\x3c\x5f\x0b\xe0\xe8\x8b\x16\x8c\xd8\x15\x34\x54\x77\x20\x00\x00\x00\x00\x00\x1b\x13\x0d\xce\xd5\xfe\x55\x53\xad\x42\x40\xec\xcc\x20\xce\xa3\x0d\x53\x01\xfb\xd7\x68\xdc\x90\xc0\x00\x00\x00\x19\x05\xf5\x72\xe0\x62\x86\xbf\x36\xf0\xa3\x81\x51\x14\xa1\xca\xf1\x19\x20\x22\x61\x1d\x6a\x25\x80\x00" },
  { 1848, 2, 8, "\x01\x01\x83\x73\xbf\x30\x84\x2b\x89\xf9\x6c\x04\x59\xe1\x5e\xf0\x05\x01\x49\xcb\x37\x66\x04\x59\xe1\x5e\xf0\x84\x2b\x89\xf9\x6c\x83\x73\xbf\x30" },
  { 1864, 2, 8, "\x01\x01\x81\xcf\x02\x04\x86\x82\x0b\x91\x02\x0f\x32\x82\x0b\x91\x02\x04\x86\x81\xcf" },
  { 1867, 1, 5, "\x0c\xde\xd8\x7f\x5c\xb2\xdf\x90\x64\xe4\x00\x00\x00\xa2\x0e\x17\x09\xb5\x20\x2f\x22\x4f\x95\x4e\xe2\x0d\xcc\xbe\x65\x1d\xb5\x36\x7d\xed\xfd\x23\x7c\x76\x7d\xd8\x30\x00\x00\x00\x00\x00\x00\x00\x20\x0d\xd9\x32\x89\xdf\xc5\x98\x73\xe5\xdb\xb7\xce\x80\xfc\xa5\xdf\x20\x3c\x9f\x7e\xc4\x57\x3c\x5d\xe4\x07\x80\x00\x00\x00\x00\x00\x9c\x64\x40\xc6\xa4\xa9\x56\xb2\x49\x8c\x1d\x9f\xb0\x7f\x10\x15\x9b\xd8\x6b\x5f\x2d\x2e\x9d\x10\xd7\x80\x00\x00\x00\x19\x0e\x4c\x7e\x14\x33\x32\x49\x62\xa5\x36\xcd\x46\x1f\x5f\x8d\x83\xec\xc9\x37\x9a\x5e\xf5\x96\x00\x00" },
  { 1876, 2, 16, "\x01\x01\x02\xa4\x28\x83\x03\x60\x62\x03\x03\x16\xb0\x03\x20\x87\xd1\x03\x09\x56\x10\x03\x28\xde\x7e\x83\x27\x65\xb8\x03\x5a\x9d\x24\x03\x27\x65\xb8\x03\x28\xde\x7e\x83\x09\x56\x10\x03\x20\x87\xd1\x83\x03\x16\xb0\x83\x03\x60\x62\x82\xa4\x28" },
  { 1880, 2, 20, "\x01\x01\x01\xd4\x02\x04\x9e\x82\x02\xf4\x82\x2b\x0d\x02\x1b\x18\x02\x08\x20\x02\x2f\xe8\x02\x11\x7d\x82\x1f\x34\x82\x34\x1a\x02\x1f\x34\x02\x11\x7d\x82\x2f\xe8\x02\x08\x20\x82\x1b\x18\x82\x2b\x0d\x02\x02\xf4\x02\x04\x9e\x81\xd4" },
  { 1892, 2, 12, "\x01\x01\x81\xd2\x01\x0f\x82\x0f\x50\x02\x1c\x07\x02\x10\x22\x82\x40\x2e\x02\x10\x22\x02\x1c\x07\x82\x0f\x50\x01\x0f\x81\xd2" },
  { 1903, 2, 22, "\x81\x01\x01\x07\x81\x0a\x81\x2d\x01\x67\x01\x03\x81\xe8\x02\x01\x12\x81\x46\x81\x75\x01\x64\x02\x01\x0b\x82\x02\x1d\x02\x02\x26\x82\x01\xe4\x01\xfc\x82\x01\x40\x02\x02\x61\x81\x9d\x82\x02\x4b\x02\x02\x15\x81\xd8" },
  { 1912, 2, 8, "\x01\x01\x81\xd8\x81\x5a\x00\x02\x01\x73\x00\x81\x5a\x81\xd8" },
  { 1915, 1, 6, "\x0c\xf8\xb6\xa1\x89\x76\x27\x25\x22\x40\x00\x00\x00\x23\x7d\xda\x4c\x46\xcf\xad\x44\x52\xb7\x3a\x2b\x96\x6f\x90\xa0\x2d\x7c\x6c\x35\x7b\x79\x71\xa9\x3c\x64\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x22\x16\x61\x27\x7d\xdd\x9b\xfc\x9e\xb8\x7b\x31\x0c\x3d\x80\x24\x04\xed\xea\x3e\x82\xe7\xe4\xd6\x7b\x6c\xe8\xf0\x00\x00\x00\x00\x00\x00\x00\xa0\x39\xa1\x6b\xa1\x7f\x5a\xdc\x51\x6b\x83\x6d\xd2\x38\xf9\x48\xf7\xfc\xbb\xbf\x75\x21\x3a\x7d\x0a\x8d\x53\x80\x00\x00\x00\x00\x00\x1e\x40\x51\xaa\xfd\x96\x61\x67\x67\x56\x32\x8c\x4e\xbb\x5d\x17\xff\xa2\x48\x07\xc6\xc4\xd1\xcb\xb3\x63\x2d\xc0\x00\x00\x00\x19\x50\xf8\x42\x10\x80\x70\x78\x5e\x64\x1e\xc0\x53\x67\x6c\x9e\xf2\x35\xa4\x5d\x97\xd4\x3a\xb3\x00\x00" },
  { 1924, 2, 16, "\x01\x01\x81\xe2\x02\x04\xf1\x82\x0d\xfe\x02\x15\x39\x82\x11\x80\x82\x06\x86\x02\x20\x60\x82\x32\xae\x02\x20\x60\x82\x06\x86\x82\x11\x80\x02\x15\x39\x82\x0d\xfe\x02\x04\xf1\x81\xe2" },
  { 1927, 2, 18, "\x01\x01\x81\x08\x01\x0d\x01\x15\x81\x24\x00\x01\x51\x81\xa5\x02\x01\x5a\x82\x03\x08\x02\x05\x89\x82\x07\xc8\x02\x08\xc1\x82\x08\x28\x02\x06\x27\x82\x04\x3e\x02\x02\x56\x81\xe0" },
  { 1928, 2, 20, "\x01\x01\x81\xde\x01\x69\x82\x17\xfa\x02\x2a\x3c\x82\x9f\x7a\x03\x01\x1c\x87\x83\x02\x18\xe2\x03\x03\x10\x4f\x83\x03\xd9\xcc\x03\x04\x43\x08\x83\x03\xd9\xcc\x03\x03\x10\x4f\x83\x02\x18\xe2\x03\x01\x1c\x87\x82\x9f\x7a\x02\x2a\x3c\x82\x17\xfa\x01\x69\x81\xde" },
  { 1963, 1, 6, "\x0d\x09\x78\xb7\xff\x20\x9f\xd5\xae\x37\x00\x00\x00\x00\xa4\x56\x9f\x88\xca\xe0\xf1\xc1\xdf\x29\xf4\x72\xd3\xbc\x69\xe9\x8b\x2a\x2b\x89\xb5\xb9\xc0\x77\x0e\x02\x94\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x02\x82\xfa\x81\x76\xb1\x18\x40\x75\x34\x84\x3a\x44\x14\x4e\xef\xbb\xfe\x05\x44\x11\xb5\x1a\xf2\x5d\x9a\xa4\xb0\x00\x00\x00\x00\x00\x00\x00\x21\x04\x8b\x45\xa7\x42\xe6\x90\xa7\xb3\x15\x2c\x2b\xad\xea\xb0\x75\x01\x5b\x6b\x67\x31\xdf\xf1\x80\x7f\x20\x65\x40\x00\x00\x00\x00\x00\x1d\x38\x4e\xcf\xb9\x79\x3a\xbb\xac\x12\x4b\x3f\x43\x0d\xcc\x76\xc6\x4d\xa1\xab\x34\xb5\x8d\x5d\x72\xaf\x00\x00\x00\x00\x1a\x01\xc0\xb5\xf0\xcb\x1d\x39\x7b\x5a\x4e\x67\xea\x0b\x04\x4c\x09\x72\x48\x76\xc0\xcf\xee\xc9\x2f\x00\x00" },
  { 1972, 2, 12, "\x01\x01\x02\xda\xa9\x03\x03\x0d\x65\x03\x04\xe4\x02\x83\x04\xa9\x01\x83\x0b\xe2\x03\x03\x03\xed\x76\x03\x0b\xe2\x03\x83\x04\xa9\x01\x83\x04\xe4\x02\x03\x03\x0d\x65\x82\xda\xa9" },
  { 1983, 2, 16, "\x81\x01\x81\x80\x82\x24\x68\x83\x03\x16\xda\x83\x1d\x3c\xbd\x83\x84\xda\x9c\x84\x01\x0a\xef\xd6\x83\x62\x49\x86\x03\x01\xa7\x5a\x84\x06\xea\x28\x6c\x84\x09\xee\xaf\x92\x04\x1e\xb2\x4f\x5c\x04\x14\x7b\xf4\xb8\x84\x67\xde\xff\x23\x84\x64\x7b\xc9\xaa\x83\xd4\x1e\xd9" },
  { 1992, 2, 8, "\x01\x01\x83\xdc\xb2\x94\x84\x6b\x26\xbd\x8c\x85\x01\x06\x5d\xe1\xec\x85\x01\x94\x20\x2d\xea\x85\x01\x06\x5d\xe1\xec\x84\x6b\x26\xbd\x8c\x83\xdc\xb2\x94" },
  { 2008, 2, 14, "\x81\x01\x81\xfa\x81\x8f\x02\x01\xd4\x02\x03\x78\x82\x03\xb4\x82\x07\x32\x02\x04\xec\x02\x07\x32\x82\x03\xb4\x82\x03\x78\x02\x01\xd4\x01\x8f\x81\xfa" },
  { 2020, 2, 8, "\x01\x01\x81\xff\x02\x01\x27\x02\x03\xd4\x82\x08\x0a\x02\x03\xd4\x02\x01\x27\x81\xff" },
  { 2047, 2, 18, "\x01\x01\x81\x0f\x01\x5e\x82\x01\x40\x02\x02\x93\x82\x03\x54\x02\x02\xce\x82\x01\xe4\x02\x01\xa2\x81\xb6\x82\x01\xf8\x02\x02\xbf\x02\x01\x2c\x82\x05\xdd\x02\x06\x25\x82\x03\x78\x02\x02\x1c\x82\x01\x0a" },
  { 2056, 2, 16, "\x01\x01\x82\x01\x05\x82\x06\x9c\x82\x1a\x55\x82\x47\xcf\x82\x91\x20\x82\xe7\xd2\x83\x01\x35\x06\x83\x01\x52\x88\x83\x01\x35\x06\x82\xe7\xd2\x82\x91\x20\x82\x47\xcf\x82\x1a\x55\x82\x06\x9c\x82\x01\x05" },
  { 2068, 2, 12, "\x01\x01\x03\x01\x21\x2c\x83\x04\x4d\xc0\x03\x03\x26\x88\x03\x07\x86\xa8\x83\x04\xfb\xfc\x03\x0f\x17\x3e\x03\x04\xfb\xfc\x03\x07\x86\xa8\x83\x03\x26\x88\x83\x04\x4d\xc0\x83\x01\x21\x2c" },
  { 2072, 2, 16, "\x01\x01\x02\x01\x10\x82\x01\xae\x02\x19\x68\x02\x09\xc9\x82\x47\x80\x02\x1d\xa2\x02\x6b\x28\x02\x16\x14\x82\x6b\x28\x02\x1d\xa2\x02\x47\x80\x02\x09\xc9\x82\x19\x68\x82\x01\xae\x82\x01\x10" },
  { 2095, 2, 16, "\x81\x01\x81\x0a\x81\x2b\x81\x65\x81\xc8\x81\xd3\x81\x64\x01\x0a\x01\xea\x01\xe2\x81\x6e\x82\x01\x93\x82\x01\x42\x82\x01\x91\x82\x03\x20\x82\x01\x18" },
  { 2104, 2, 12, "\x01\x01\x82\x01\x20\x02\x01\xb0\x81\x48\x82\x03\x30\x82\x09\x00\x82\x0d\xb6\x82\x09\x00\x82\x03\x30\x81\x48\x02\x01\xb0\x82\x01\x20" },
  { 2132, 2, 12, "\x01\x01\x03\x01\x5b\x5c\x03\x38\x73\xf0\x04\x03\xdb\x16\x08\x84\x06\x08\x8f\x08\x04\x01\xd1\xc9\x34\x04\x14\x48\x8f\xbe\x84\x01\xd1\xc9\x34\x84\x06\x08\x8f\x08\x84\x03\xdb\x16\x08\x03\x38\x73\xf0\x83\x01\x5b\x5c" },
  { 2143, 2, 13, "\x81\x01\x00\x81\x0c\x81\x2b\x01\x0e\x02\x01\x0c\x02\x01\x8c\x81\x9b\x82\x05\x0c\x82\x08\x71\x82\x08\x0a\x82\x04\x7b\x82\x01\x2b" },
  { 2148, 2, 12, "\x01\x01\x84\x01\xb0\xbf\x66\x85\x01\x14\xe3\x98\x46\x85\x0b\xbb\x95\xe1\x26\x85\x33\xe7\x78\x07\xc1\x85\x6b\xd5\x83\x87\xf4\x85\x8f\x4c\xdd\x10\xf4\x85\x6b\xd5\x83\x87\xf4\x85\x33\xe7\x78\x07\xc1\x85\x0b\xbb\x95\xe1\x26\x85\x01\x14\xe3\x98\x46\x84\x01\xb0\xbf\x66" },
  { 2152, 2, 10, "\x81\x01\x82\x01\x33\x81\x62\x82\x01\x51\x82\x03\x5d\x02\x02\x18\x02\x03\x5d\x82\x01\x51\x01\x62\x82\x01\x33" },
  { 2164, 2, 10, "\x81\x01\x83\x01\x7c\x0d\x83\x04\xb6\xca\x83\x32\x8f\x77\x03\x03\x32\x4b\x83\x83\x60\x28\x83\x03\x32\x4b\x83\x32\x8f\x77\x03\x04\xb6\xca\x83\x01\x7c\x0d" },
  { 2167, 2, 18, "\x81\x01\x81\x06\x81\x1b\x81\x20\x81\x66\x01\x07\x01\x07\x01\x59\x01\x2f\x01\x77\x82\x01\x1e\x01\x0e\x01\x84\x81\xa6\x82\x01\x7b\x02\x01\xe7\x01\xef\x82\x01\x3a" },
  { 2203, 1, 5, "\x0d\x07\x95\xd6\xbf\x9a\x04\x67\x04\x93\x20\x00\x00\x00\xa4\x46\x12\x50\xd6\x3b\x96\x63\x57\x57\x8f\x67\x06\xb5\xbc\x31\x42\xc3\x46\x54\x3b\x47\x27\x1b\x91\x28\x6a\x9c\x30\x00\x00\x00\x00\x00\x00\x00\x00\x23\x02\xda\x0b\x9b\x60\x50\xe1\xd8\x14\x2c\x30\xcc\x1f\x17\xaf\xb4\x44\x09\x6c\xaf\xa5\x5a\xcb\xfb\x9b\x07\xe7\x61\xd1\xe0\x00\x00\x00\x00\x00\x9f\x03\xdf\xa2\x99\x03\xa3\xa0\xbd\x7a\x3b\x39\x78\x19\xca\x5a\xe7\xf5\xd0\xe4\x49\x35\xce\x9f\x30\xc0\x1b\x3c\x40\x00\x00\x00\x1b\x1a\x90\x86\x59\x5a\xd3\x9e\xab\xcb\x9e\x22\x15\xc1\x71\x59\xa0\x79\x88\xd7\x2e\x08\xbc\xd4\xe8\x50\x80\x00" },
  { 2212, 2, 8, "\x01\x01\x82\x01\x4e\x01\x8a\x02\x01\xf0\x01\x7f\x02\x01\xf0\x01\x8a\x82\x01\x4e" },
  { 2227, 1, 6, "\x0c\x09\xe5\x2c\x85\xcb\x53\xb5\xa8\x00\x00\x00\x00\x22\x08\xd6\x4c\x06\x51\xb9\x46\x6f\xf1\xc7\x4e\x88\xf3\x71\xbc\x1a\x95\x29\xc2\x47\xf9\x24\x90\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x09\xa6\xc5\xda\xb9\x4d\x9b\x66\x46\xce\xd7\xe5\xf4\xe6\x7f\x15\x41\xf4\xf0\xcc\x39\x32\x6e\x0d\xf8\x80\x00\x00\x00\x00\x00\x00\x00\x1f\x65\xb1\x91\xc8\x01\x3c\xe9\xea\xcc\xa6\xcb\x7d\x55\x09\x6c\x2a\x54\xe1\xbd\x1f\x84\x6f\x28\xc6\xe1\x20\x00\x00\x00\x00\x00\x9d\x75\x80\xbf\x31\xa9\x25\x27\x51\x20\x24\xa7\x09\xef\xf8\x5b\x55\xc1\x9e\xd2\x9e\x7e\xed\x77\xcb\xbd\x40\x00\x00\x00\x1b\x3b\x2e\x5c\x77\x5d\x3e\xec\x86\x55\x50\x50\x35\x9f\xdc\x78\xdd\x7c\xa3\x8e\x8e\x73\x85\x55\x81\x91\x80\x00" },
  { 2248, 2, 8, "\x01\x01\x82\x01\x5f\x01\x7e\x82\x03\xb1\x02\x01\x22\x82\x03\xb1\x01\x7e\x82\x01\x5f" },
  { 2260, 2, 12, "\x01\x01\x03\x01\xf0\x77\x03\x08\xfd\xcc\x03\x04\x33\x8f\x03\x75\x99\xf0\x83\x02\x60\xd9\x03\xb6\xe8\x0a\x03\x02\x60\xd9\x03\x75\x99\xf0\x83\x04\x33\x8f\x03\x08\xfd\xcc\x83\x01\xf0\x77" },
  { 2263, 2, 22, "\x01\x01\x81\x0b\x01\x37\x81\x7a\x01\x68\x01\x7b\x82\x01\x31\x01\xa8\x02\x01\xdb\x82\x04\xc7\x02\x05\x50\x82\x02\x24\x82\x01\xf3\x02\x04\x56\x82\x03\xe9\x02\x01\xa1\x81\x8f\x01\x52\x01\x73\x82\x03\x02\x02\x02\xd8\x82\x01\x68" },
  { 2283, 1, 6, "\x0f\x1b\x19\x52\x19\x24\xef\x00\xcd\xed\xba\x15\xc0\x00\x00\x00\x2b\x0c\x42\x8c\xbf\xd6\x42\x70\xbe\x64\x82\xd5\x25\x7b\xdf\xdf\xa4\x97\xfd\xd1\x43\x65\x81\xf7\xbe\x8d\x96\xb3\xef\xc7\x2f\xe0\x97\x9b\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x01\x16\xe5\x9a\xf8\x28\x94\x1c\x0f\x65\x25\xc9\x1b\x58\xc2\x98\x6b\xc1\x3f\xac\x79\xbf\xe0\x88\x53\x4c\xe5\x04\x74\xb7\x85\xb8\xcb\xb8\x30\x00\x00\x00\x00\x00\x00\x00\x27\x11\xfc\x73\x04\xa6\x39\x1a\xc7\xee\x62\x99\x7b\x03\x24\xa2\xdc\x27\xad\xc2\x2e\xc5\x12\x01\x1c\xbc\xcd\x19\x27\xdf\xa8\x1d\x0d\x82\x00\x00\x00\x00\x00\x00\x25\x01\xad\x5f\x42\x78\x29\x8e\xad\x7a\x24\x59\x7e\x0d\x91\x68\xcb\x98\xbb\xe1\xf3\x24\x87\x8c\xea\xdc\xef\x69\xb9\xb8\xd3\x38\x73\x2d\x40\x00\x00\x00\x1c\x01\x79\x4c\x7a\xb3\xf8\xab\xfe\xb8\x8e\x40\x94\xa7\x13\x27\xd3\x27\x99\x77\x80\xfb\x3e\xa3\x2f\x40\x44\x00\x00" },
  { 2296, 2, 16, "\x01\x01\x82\x01\x7a\x02\x05\x19\x82\x0c\x72\x02\x24\x31\x82\x47\xb8\x02\x4b\xba\x82\x19\xbc\x82\x0a\x86\x82\x19\xbc\x02\x4b\xba\x82\x47\xb8\x02\x24\x31\x82\x0c\x72\x02\x05\x19\x82\x01\x7a" },
  { 2308, 2, 8, "\x01\x01\x82\x01\x78\x82\x06\xfb\x82\x0e\xac\x82\x11\xc4\x82\x0e\xac\x82\x06\xfb\x82\x01\x78" },
  { 2335, 2, 14, "\x81\x01\x81\x08\x81\x36\x81\xca\x82\x02\x0e\x82\x04\x23\x82\x06\x46\x82\x08\x9d\x82\x0c\x59\x82\x0f\x2e\x82\x0f\xae\x82\x0d\xd9\x82\x07\x97\x82\x01\x86" },
  { 2344, 2, 18, "\x81\x01\x82\x01\x95\x82\x08\x34\x82\x15\xa1\x82\x1b\xb4\x82\x1c\x95\x82\x0f\xf5\x82\x29\xa6\x82\x0e\x40\x82\x30\x4e\x02\x0e\x40\x82\x29\xa6\x02\x0f\xf5\x82\x1c\x95\x02\x1b\xb4\x82\x15\xa1\x02\x08\x34\x82\x01\x95" },
  { 2347, 1, 5, "\x0c\x03\x1f\x1e\xc8\xdf\x94\x90\xf7\x72\x00\x00\x00\xa1\x02\x5f\xff\xa8\x30\x86\xd8\xaf\x18\xb5\x16\x13\xc6\x2d\x96\xf0\x3a\xce\x23\x53\xed\x7c\xb4\x59\x27\x70\x00\x00\x00\x00\x00\x00\x00\x9f\x02\x3f\xf0\x35\x6f\xf4\xb0\x21\xa6\xbf\x18\x9f\x1d\x10\x99\x73\x72\x80\x9d\xf0\x12\x8f\x51\x12\x25\x40\x00\x00\x00\x00\x00\x1d\x8e\xd1\xaa\x3e\x0e\x23\xde\x11\x2c\x64\x4a\x5e\xd6\x56\x89\xc7\x5d\xf7\xa6\xe9\x90\x1f\x04\x3d\xd1\x80\x00\x00\x00\x1c\x0b\xe8\xca\x94\xe9\x33\x6d\x0b\x13\xda\x75\x9a\x80\xf0\xfd\x28\x9b\x54\xe7\x4d\xe3\xc8\x43\x56\x22\x28\x80\x00" },
  { 2356, 2, 16, "\x01\x01\x03\x02\x84\xd6\x83\x1b\xcb\x69\x03\x7e\x26\x52\x83\x7e\xa9\x4f\x03\xbf\x60\x58\x03\x09\x07\xde\x03\x43\xbe\xdc\x04\x01\xa4\x98\xc2\x83\x43\xbe\xdc\x03\x09\x07\xde\x83\xbf\x60\x58\x83\x7e\xa9\x4f\x83\x7e\x26\x52\x83\x1b\xcb\x69\x83\x02\x84\xd6" },
  { 2388, 2, 12, "\x01\x01\x07\x14\xb0\xc7\xac\x69\xc3\x78\x09\x0e\x33\x53\x8c\x7e\xea\x2f\x66\x6a\x09\x01\x30\xc7\x7e\x63\x08\xfb\x6f\xa8\x09\x4d\x27\x02\x1e\x84\x99\x1f\xa5\x4f\x89\x1f\x93\x6e\x38\xfe\xeb\xd0\x28\x50\x09\x2c\x12\xac\x94\x8b\x8b\x11\x78\x8c\x09\x1f\x93\x6e\x38\xfe\xeb\xd0\x28\x50\x09\x4d\x27\x02\x1e\x84\x99\x1f\xa5\x4f\x89\x01\x30\xc7\x7e\x63\x08\xfb\x6f\xa8\x09\x0e\x33\x53\x8c\x7e\xea\x2f\x66\x6a\x87\x14\xb0\xc7\xac\x69\xc3\x78" },
  { 2392, 2, 8, "\x01\x01\x02\x01\xa8\x82\x04\x12\x81\x50\x02\x07\x1b\x01\x50\x82\x04\x12\x82\x01\xa8" },
  { 2404, 2, 20, "\x01\x01\x82\x01\xb2\x02\x01\x22\x82\x05\x12\x02\x01\x9b\x82\x1e\x34\x82\x42\x44\x82\x9b\x14\x82\xd5\xeb\x83\x01\x35\xc6\x83\x01\x1e\xc2\x83\x01\x35\xc6\x82\xd5\xeb\x82\x9b\x14\x82\x42\x44\x82\x1e\x34\x02\x01\x9b\x82\x05\x12\x02\x01\x22\x82\x01\xb2" },
  { 2407, 2, 20, "\x81\x01\x81\x02\x81\x15\x81\x12\x01\x68\x01\x35\x82\x01\xa7\x01\x5e\x02\x01\x7b\x81\x98\x81\x17\x82\x01\xcf\x02\x02\x27\x01\x36\x82\x05\x1a\x02\x08\x3e\x81\xeb\x82\x06\x81\x02\x04\xfc\x82\x01\xb6" },
  { 2424, 2, 12, "\x01\x01\x84\x05\x40\xf6\x48\x85\x04\xd9\x8a\x00\x22\x85\x45\xad\x3a\xd1\xe8\x86\x05\xe3\x3a\xa6\xa9\xd1\x86\x12\x2e\xca\x6f\xf8\x50\x86\x1a\x33\x1f\x12\x91\x5c\x86\x12\x2e\xca\x6f\xf8\x50\x86\x05\xe3\x3a\xa6\xa9\xd1\x85\x45\xad\x3a\xd1\xe8\x85\x04\xd9\x8a\x00\x22\x84\x05\x40\xf6\x48" },
  { 2440, 2, 12, "\x01\x01\x82\x01\xc8\x02\x02\x7f\x02\x04\x20\x82\x10\x7a\x02\x1f\x08\x82\x26\xfd\x02\x1f\x08\x82\x10\x7a\x02\x04\x20\x02\x02\x7f\x82\x01\xc8" },
  { 2443, 1, 6, "\x0d\x81\xf0\xfd\x88\x20\xc4\x5d\xef\x14\xc0\x00\x00\x00\xa6\x0a\x3c\x2d\xb0\x54\x0a\xfe\x64\xc7\xe9\x68\xfd\xc2\x36\x2b\x93\x2d\xf5\xe8\x00\x38\xf1\xcb\x25\x80\x5a\x8e\x79\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x05\xb1\x15\x0a\x35\xd5\xeb\x44\x77\xef\xab\xf5\x52\xdc\xbd\x80\x18\xa0\xe8\xe0\xf2\x05\x6d\x00\x7d\x5f\x94\x0e\xe7\xb0\x00\x00\x00\x00\x00\x00\x00\xa3\x04\xa9\xfa\x09\xf2\x47\xd7\x45\xb5\x33\xa6\x5f\x5d\x80\xed\xd2\xd8\x33\x78\x68\x8e\xbc\x5d\x24\xc3\x84\xaf\xee\x8c\x00\x00\x00\x00\x00\x00\x21\x01\x04\x00\x4a\xae\xa5\xa7\x1e\x07\x58\xaf\xae\xa3\x9f\x4d\x11\xae\x67\xe1\xdf\xba\xd9\x1f\xa8\xef\xb7\x7a\x56\xfe\x40\x00\x00\x00\x1d\x01\x03\x83\x75\xc9\xa7\xeb\xbb\x95\x9b\xb9\x6b\x61\x6a\x8c\xed\xf8\xfa\x3c\x64\xf8\x90\x12\x95\x38\xfb\x44\x00\x00" },
  { 2452, 2, 10, "\x81\x01\x83\x03\x41\x46\x03\x07\x0f\x4c\x83\x01\x86\xcc\x83\x03\x34\x0f\x83\x02\x10\x9c\x03\x03\x34\x0f\x83\x01\x86\xcc\x83\x07\x0f\x4c\x83\x03\x41\x46" },
  { 2468, 2, 12, "\x01\x01\x82\x01\xd7\x82\x01\x2e\x82\x46\xab\x02\x5f\x6e\x82\xd2\x9f\x03\x01\x07\x5e\x82\xd2\x9f\x02\x5f\x6e\x82\x46\xab\x82\x01\x2e\x82\x01\xd7" },
  { 2472, 2, 12, "\x01\x01\x04\x06\x5b\x31\x08\x85\x05\xf5\xbc\x7c\xf6\x05\x11\x4f\x78\xd7\xd8\x85\x0c\x48\xcd\xc1\x31\x85\x13\x8d\x4e\x94\xb0\x85\x01\xb7\x5c\x53\xb4\x05\x13\x8d\x4e\x94\xb0\x85\x0c\x48\xcd\xc1\x31\x85\x11\x4f\x78\xd7\xd8\x85\x05\xf5\xbc\x7c\xf6\x84\x06\x5b\x31\x08" },
  { 2488, 2, 12, "\x01\x01\x82\x01\xe0\x82\x08\x10\x82\x19\xc8\x82\x34\xb0\x82\x52\x80\x82\x5d\xf6\x82\x52\x80\x82\x34\xb0\x82\x19\xc8\x82\x08\x10\x82\x01\xe0" },
  { 2503, 2, 21, "\x81\x01\x81\x0b\x81\x29\x81\x65\x82\x01\x44\x82\x02\x51\x82\x03\xec\x82\x05\x25\x82\x05\x74\x82\x03\x0f\x01\x17\x02\x03\x24\x02\x04\x2e\x02\x02\xdd\x82\x01\x2d\x82\x06\x03\x82\x08\xe6\x82\x08\x98\x82\x08\x31\x82\x05\x95\x82\x01\xeb" },
  { 2515, 1, 6, "\x0f\x03\x30\x83\x96\xcd\x9b\xde\x4a\x4c\x06\x73\x00\x00\x00\x00\xaa\x01\x6f\x58\x65\x39\x37\xf7\x09\x0a\x8c\x57\xd6\x97\xd4\x47\x58\x1f\xb2\x7a\xf3\x39\x71\x29\x15\x56\xeb\x91\x37\x72\x6c\x66\x1d\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x04\x23\x44\x8c\x91\x36\x96\x1f\xde\x60\xa0\x47\xb1\x19\xef\x19\xfa\x0d\xe0\x45\x3c\x5a\x6e\xbf\xa8\x13\x8b\x61\xb1\x1f\x0f\x5f\xf0\x00\x00\x00\x00\x00\x00\x00\x25\x47\x65\xf5\x87\xb0\xab\x90\x65\x14\x4b\xee\x4c\x98\xeb\xf3\x1a\xf3\x02\x41\x9b\xcc\xb7\x67\x93\x8c\xa8\x63\x18\x72\xd9\xa8\x40\x00\x00\x00\x00\x00\x23\x01\xb0\x65\xae\x42\x08\x10\xc1\x03\x2a\x58\xfa\xe1\x22\x94\x50\x8b\xcc\x12\x40\x4f\x39\x36\x3a\xa7\x62\x66\x26\x14\xaf\xf2\x00\x00\x00\x00\x1d\x09\xd3\xdf\xee\xe8\x7c\x56\x5c\xf6\xd1\xb9\x83\xfc\x6c\x72\xf2\x39\x4e\xde\xc8\x46\x7f\x2e\x14\x70\xc2\x1b\x00\x00" },
  { 2536, 2, 14, "\x81\x01\x82\x02\x01\x02\x05\x3d\x82\x12\x14\x02\x0d\xc0\x82\x05\xac\x82\x05\x12\x82\x12\xee\x02\x05\x12\x82\x05\xac\x82\x0d\xc0\x82\x12\x14\x82\x05\x3d\x82\x02\x01" },
  { 2563, 1, 6, "\x0d\x05\xe6\x59\x93\xc9\x33\x3a\x34\x16\x00\x00\x00\x00\x24\x1e\x4d\x0d\x1f\x61\xb8\x27\xdf\xe3\x81\x4c\xed\x27\x65\x65\x0f\x3c\x7d\xfd\x66\x87\xba\x0a\x72\x15\xd2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x23\x24\x2f\x8c\xfb\x90\xe7\xc5\x38\xa9\x14\xc8\x5d\x84\x1c\x43\x82\xb9\xdc\x58\xf3\xf4\x61\x34\xc4\xa0\xab\xa0\x80\x00\x00\x00\x00\x00\x00\x00\x22\x01\x8b\x13\x9a\x16\xd1\x12\xb7\x85\x4e\x6f\xa4\x28\x43\x5e\xda\x27\xdd\x74\x03\xc4\x8a\x86\xea\x4e\x9e\x99\xf9\x60\x00\x00\x00\x00\x00\x20\x05\x07\x24\xda\xfe\xea\xef\x27\xc9\x58\x76\x55\xdc\xfb\xae\x5d\x53\x07\x8b\xe5\xc6\x0d\xac\xf1\x92\xf0\x06\xc5\xc0\x00\x00\x00\x1d\x2b\xe2\x57\xed\x84\xa6\x01\x08\xd5\x28\xee\xee\xce\xe4\x0d\xf0\xea\x96\x81\x95\x07\x5e\xbf\x5c\x9d\x4d\x1a\x80\x00" },
  { 2584, 2, 16, "\x01\x01\x02\x02\x28\x02\x07\x32\x02\x07\x20\x82\x0c\x77\x82\x01\x20\x82\x0b\xbe\x02\x0a\x68\x02\x25\x14\x82\x0a\x68\x82\x0b\xbe\x02\x01\x20\x82\x0c\x77\x82\x07\x20\x02\x07\x32\x82\x02\x28" },
  { 2596, 2, 20, "\x01\x01\x82\x02\x2e\x02\x01\xcd\x82\x0a\xd4\x02\x1a\x64\x82\x21\x0c\x82\x18\xf5\x02\x3e\x16\x02\x2b\x37\x02\x15\xf0\x82\xb2\xf8\x02\x15\xf0\x02\x2b\x37\x02\x3e\x16\x82\x18\xf5\x82\x21\x0c\x02\x1a\x64\x82\x0a\xd4\x02\x01\xcd\x82\x02\x2e" },
  { 2612, 2, 14, "\x81\x01\x83\x04\xef\x31\x04\x01\x90\x96\x61\x84\x23\xea\xf4\x08\x84\x01\x80\x0b\xa8\x84\x3a\xd6\xec\x78\x05\x01\x18\xaa\xce\x52\x04\x1d\xb1\x98\xd2\x85\x01\x18\xaa\xce\x52\x84\x3a\xd6\xec\x78\x04\x01\x80\x0b\xa8\x84\x23\xea\xf4\x08\x84\x01\x90\x96\x61\x83\x04\xef\x31" },
  { 2632, 2, 8, "\x01\x01\x82\x02\x4c\x02\x0a\x62\x82\x15\x00\x02\x1a\x7b\x82\x15\x00\x02\x0a\x62\x82\x02\x4c" },
  { 2647, 2, 15, "\x81\x01\x01\x04\x81\x02\x81\x3d\x81\xc1\x81\xad\x82\x01\x4c\x82\x03\x0a\x82\x01\xa6\x01\xf2\x82\x01\x15\x81\x8c\x02\x03\x5b\x01\xa7\x82\x02\x53" },
  { 2680, 2, 12, "\x01\x01\x82\x02\x70\x02\x09\x60\x82\x06\x18\x82\x2e\x80\x02\x96\xf0\x82\xd2\xf6\x02\x96\xf0\x82\x2e\x80\x82\x06\x18\x02\x09\x60\x82\x02\x70" },
  { 2683, 1, 5, "\x0d\x09\x4f\xe2\x65\xc8\xb8\x55\xd7\x15\x8c\x00\x00\x00\xa4\x9b\xf0\xb8\x7e\x55\x3f\xde\x83\x38\x58\xcb\xa7\x8b\x18\xd4\x50\x7f\x3e\xdf\xa0\xe3\x48\x25\xe6\x24\x60\xaa\x5c\xd0\x00\x00\x00\x00\x00\x00\x00\x23\x2b\xc7\x62\x15\x0d\x3b\xd5\x92\xa9\x30\xb1\xf9\x01\x1c\x41\x6b\xbb\x69\xef\x19\x15\x3b\x68\x4f\xe2\xab\xc4\x41\x21\x40\x00\x00\x00\x00\x00\xa1\x02\x11\xbb\x71\x01\x01\xc6\x6b\x24\x51\x0b\x0d\x86\x4e\xe8\x6c\xd9\x8c\xc7\x5f\x99\xb2\x81\xe6\xe9\xaa\x87\x68\xdf\x00\x00\x00\x00\x1e\x06\xcd\x10\xf9\xc2\xf8\x1b\xe1\xf8\xd5\x77\x9e\x5f\xe3\x75\x87\x52\x95\xc4\xe1\xea\xda\x63\x7a\x2c\x5d\x62\x53\x00\x00" },
  { 2692, 2, 12, "\x01\x01\x82\x02\x78\x02\x05\xe8\x82\x07\x6a\x02\x07\xe8\x82\x0c\xf8\x02\x11\xca\x82\x0c\xf8\x02\x07\xe8\x82\x07\x6a\x02\x05\xe8\x82\x02\x78" },
  { 2728, 2, 12, "\x01\x01\x02\x02\x90\x82\x07\x18\x82\x03\x38\x02\x17\x28\x02\x01\x00\x82\x21\xf2\x82\x01\x00\x02\x17\x28\x02\x03\x38\x82\x07\x18\x82\x02\x90" },
  { 2740, 2, 12, "\x01\x01\x03\x06\xd2\xdb\x03\x11\xb9\x08\x83\xe5\x52\x01\x04\x01\x6e\x47\x94\x04\x01\x97\xd5\xeb\x04\x04\x97\x90\xaa\x84\x01\x97\xd5\xeb\x04\x01\x6e\x47\x94\x03\xe5\x52\x01\x03\x11\xb9\x08\x83\x06\xd2\xdb" },
  { 2743, 2, 20, "\x81\x01\x01\x06\x81\x11\x81\x3a\x01\x43\x02\x01\xf5\x02\x01\xef\x82\x04\x1a\x82\x0c\xd6\x82\x0a\xec\x02\x08\xe6\x02\x1e\xcb\x02\x1b\x4c\x82\x01\x2f\x82\x19\xa1\x82\x18\x9f\x82\x08\xc8\x81\xab\x82\x03\x3e\x82\x02\x9e" },
  { 2767, 2, 21, "\x81\x01\x81\x0d\x81\x68\x82\x01\xf2\x82\x06\x6f\x82\x0f\xb6\x82\x1e\x87\x82\x30\x57\x82\x40\xf3\x82\x4a\xbf\x82\x4d\x09\x82\x4a\xb8\x82\x4b\x9c\x82\x51\x53\x82\x5a\xba\x82\x5c\xe2\x82\x52\xd8\x82\x3b\x41\x82\x20\xd8\x82\x0c\x75\x82\x02\xaf" },
  { 2776, 2, 10, "\x81\x01\x82\x02\xba\x02\x03\xd3\x82\x14\xc4\x82\x05\x8d\x82\x08\xe6\x02\x05\x8d\x82\x14\xc4\x82\x03\xd3\x82\x02\xba" },
  { 2787, 1, 6, "\x10\x12\xe9\x61\xff\x28\xe0\x08\x9e\x3e\xae\x2c\x70\x00\x00\x00\x00\xae\x02\x3a\xb4\x7c\xb4\xb6\x01\x0f\xe6\x42\x13\x18\xc1\xdf\xa4\x1c\xdb\xf2\x89\x2f\xaf\x5f\x68\x2d\x92\xbd\x59\x71\x7c\x55\xf7\x78\xcd\xa8\xb2\xda\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x15\xe7\x68\x26\xc3\x29\x55\x4f\x15\xe1\xc9\x37\xc4\xe5\xc9\x89\x67\xd9\x40\x1b\x2b\x68\xc7\x40\x3b\xd2\x1f\x5b\x27\x16\x00\xb4\xb1\x8f\xcf\xb0\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x5a\x6a\x73\xeb\x59\x46\x59\xec\x55\xdb\x23\x47\x8a\xe6\xe9\x68\xf5\x34\x97\xcb\x25\x1f\x2b\xa4\x6c\x96\x45\xb5\x1d\x30\x6b\xa6\x94\x93\xce\x29\xe0\x00\x00\x00\x00\x00\x28\x82\xb2\x60\xb4\x4f\xea\x6d\x88\x8e\x5c\xaf\x2f\x72\x8c\xe9\x1f\xc4\x45\x26\x67\xb8\x21\x7c\x15\x55\x65\xf0\xe1\x68\x71\x2b\xbb\xd5\xee\x2e\xae\xc0\x00\x00\x00\x1e\x9a\x9e\x15\x31\x2e\x75\x38\x97\x0b\xad\xd3\xba\xf5\x41\x0c\x30\x6f\x73\xa0\x6d\xf2\xf0\x2e\xbb\x36\xcd\x12\x39\x80\x00" },
  { 2788, 2, 8, "\x01\x01\x82\x02\xc7\x02\x03\x0a\x02\x01\xcb\x82\x04\x0e\x02\x01\xcb\x02\x03\x0a\x82\x02\xc7" },
  { 2836, 2, 10, "\x81\x01\x83\x08\xa8\x31\x03\x6f\xe5\x82\x84\x02\x2b\x99\x3f\x83\x07\x0d\x59\x84\x02\x5e\x3e\xd0\x03\x07\x0d\x59\x84\x02\x2b\x99\x3f\x83\x6f\xe5\x82\x83\x08\xa8\x31" },
  { 2872, 2, 12, "\x01\x01\x82\x03\x12\x82\x03\xab\x82\x08\x6a\x82\x02\x85\x82\x03\xe4\x02\x04\x0e\x82\x03\xe4\x82\x02\x85\x82\x08\x6a\x82\x03\xab\x82\x03\x12" },
  { 2884, 2, 16, "\x01\x01\x82\x03\x26\x02\x16\x8a\x82\x48\x84\x02\x84\xb5\x82\xd6\x4c\x03\x01\x67\xae\x83\x01\xb1\xfa\x03\x01\xb6\x44\x83\x01\xb1\xfa\x03\x01\x67\xae\x82\xd6\x4c\x02\x84\xb5\x82\x48\x84\x02\x16\x8a\x82\x03\x26" },
  { 2920, 2, 12, "\x01\x01\x02\x03\x40\x82\x08\x38\x82\x04\x18\x02\x02\x28\x82\x06\x70\x02\x07\xae\x02\x06\x70\x02\x02\x28\x02\x04\x18\x82\x08\x38\x82\x03\x40" },
  { 2923, 1, 6, "\x8e\x17\x74\x30\xe2\x05\x89\x9d\x1b\xad\x7b\x00\x00\x00\x00\x28\x5c\xce\xe3\x02\x21\x8d\x88\xf4\x8f\x4f\xf6\xb0\x18\xec\x18\x5d\x22\x27\xc6\x12\x4b\x05\x36\xa9\xbf\x1b\x9d\xbd\xdc\x09\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa7\x02\x0d\xe7\xbf\x2e\x98\xae\xb6\xbf\xa1\x5e\x92\x8d\x65\xa6\x1d\x92\xf3\x53\x78\xa5\x1c\x0a\x79\xd8\x96\xf1\x81\xa6\x82\x1e\x70\x00\x00\x00\x00\x00\x00\x00\x25\x03\x06\xc7\x80\x3d\x3c\xaa\x80\x98\x9c\x76\xd2\x70\xe7\xbe\x5b\x89\xa0\xe5\x9d\xf3\x31\x5b\x12\xb1\xcf\x04\x55\x5d\xb9\x41\x00\x00\x00\x00\x00\x00\xa2\x02\xed\x8d\x78\x0f\xc1\x5e\x7a\xa7\x23\x46\xb1\x91\x7c\x15\x4b\x32\x63\x06\x96\xbe\xbd\x9e\x38\x8a\x0a\xda\xcd\x25\x12\x80\x00\x00\x00\x1f\x20\xec\x5b\x4f\xb8\xfb\x78\xc2\xd9\xff\xab\x28\xcd\x97\x24\x85\x5a\x47\x42\x46\xa1\x1a\x06\xcb\x7b\x78\x7f\x20\x14\x00\x00" },
  { 2932, 2, 14, "\x81\x01\x83\x0a\xf0\x8f\x03\x01\x67\x1d\x83\xa7\x14\x5c\x83\xb4\xf9\x60\x84\x02\x38\xb0\xb4\x83\x05\x69\xc2\x83\xf1\x56\x72\x03\x05\x69\xc2\x84\x02\x38\xb0\xb4\x03\xb4\xf9\x60\x83\xa7\x14\x5c\x83\x01\x67\x1d\x83\x0a\xf0\x8f" },
  { 2968, 2, 8, "\x01\x01\x02\x03\x76\x02\x05\xff\x02\x03\xc2\x02\x06\x5c\x82\x03\xc2\x02\x05\xff\x82\x03\x76" },
  { 2980, 2, 16, "\x01\x01\x82\x03\x7d\x82\x0e\x54\x82\x0b\xf1\x82\x08\xcf\x82\x28\x94\x82\x1b\x16\x02\x0b\x02\x82\x85\x90\x02\x0b\x02\x82\x1b\x16\x82\x28\x94\x82\x08\xcf\x82\x0b\xf1\x82\x0e\x54\x82\x03\x7d" },
  { 2983, 2, 20, "\x81\x01\x00\x81\x2b\x81\x20\x82\x01\x52\x01\x1f\x82\x04\x33\x02\x01\xee\x82\x06\xeb\x02\x03\x9e\x82\x08\x7c\x81\x10\x82\x05\x81\x82\x03\x67\x02\x04\xab\x82\x03\x77\x02\x05\x60\x82\x06\xd7\x82\x01\x22\x82\x03\x84" },
  { 3007, 2, 20, "\x01\x01\x01\x07\x81\x04\x81\x28\x02\x01\x19\x82\x01\xd1\x01\x70\x02\x01\xde\x82\x04\x56\x02\x04\x6f\x82\x01\x1c\x82\x05\x12\x02\x10\x56\x82\x1d\x5e\x02\x28\xfa\x82\x2d\xd9\x02\x28\xaf\x82\x1b\x62\x02\x0c\x8d\x82\x03\xa2" },
  { 3012, 2, 12, "\x01\x01\x84\x30\x44\x33\xb2\x85\x57\xed\x00\xe1\xf6\x85\x1a\x8f\x35\x0f\x12\x05\xbe\x4b\x08\x08\x7f\x85\xef\x1f\x25\x35\x3c\x86\x02\xe9\xc7\xf3\x5d\x14\x85\xef\x1f\x25\x35\x3c\x05\xbe\x4b\x08\x08\x7f\x85\x1a\x8f\x35\x0f\x12\x85\x57\xed\x00\xe1\xf6\x84\x30\x44\x33\xb2" },
  { 3028, 2, 10, "\x81\x01\x83\x0d\xc5\x81\x03\x0f\xab\x62\x03\x2e\x79\x31\x83\x29\x57\xb9\x83\x48\x95\x10\x03\x29\x57\xb9\x03\x2e\x79\x31\x83\x0f\xab\x62\x83\x0d\xc5\x81" },
  { 3048, 2, 12, "\x01\x01\x04\x36\xe1\x4c\x08\x85\x66\x3c\x66\x3a\x56\x86\x03\xd3\xf9\x6e\x01\x28\x86\x18\xb2\x6f\x50\x1b\xb1\x85\xaa\x77\x5f\xd0\xb0\x86\x29\xff\x4e\x0c\x43\xf4\x05\xaa\x77\x5f\xd0\xb0\x86\x18\xb2\x6f\x50\x1b\xb1\x06\x03\xd3\xf9\x6e\x01\x28\x85\x66\x3c\x66\x3a\x56\x84\x36\xe1\x4c\x08" },
  { 3063, 2, 16, "\x81\x01\x02\x01\x8f\x82\xc6\x06\x83\x02\x77\x75\x83\xb2\x6a\xe7\x03\x58\xfb\xd1\x04\x05\xf7\xd3\x65\x04\x76\x6b\x45\x1a\x85\x01\x58\x35\x50\x31\x84\xd8\xf5\x5a\x8d\x05\x01\xc4\x88\xc6\x1d\x85\x12\xbe\x8d\x79\xc2\x05\x28\x60\x97\x37\x25\x05\x38\xfc\x49\xeb\x58\x85\x6f\xd7\x0a\xc4\x15\x84\x39\xe2\x2c\x55" },
  { 3103, 2, 20, "\x81\x01\x01\x01\x81\x24\x01\xa6\x82\x01\xe4\x02\x05\x67\x82\x0b\xcb\x02\x11\x80\x82\x11\x3b\x02\x08\xdf\x02\x03\x70\x82\x0a\x97\x02\x06\xd3\x82\x02\x78\x02\x09\x59\x82\x17\x7f\x02\x1f\xaa\x82\x1c\x4d\x02\x0f\xe1\x82\x04\x12" },
  { 3112, 2, 14, "\x81\x01\x82\x04\x19\x01\x79\x82\x0d\x20\x02\x03\x48\x82\x0f\x00\x02\x02\x0a\x82\x0c\x1e\x82\x02\x0a\x82\x0f\x00\x82\x03\x48\x82\x0d\x20\x81\x79\x82\x04\x19" },
  { 3140, 2, 16, "\x01\x01\x82\x04\x4e\x02\x4c\x51\x83\x01\xbe\xf2\x03\x02\x44\xb9\x03\x07\x5c\x90\x83\x26\xdc\xa6\x03\x52\x24\x40\x83\x67\xc8\xae\x03\x52\x24\x40\x83\x26\xdc\xa6\x03\x07\x5c\x90\x03\x02\x44\xb9\x83\x01\xbe\xf2\x02\x4c\x51\x82\x04\x4e" },
  { 3160, 2, 16, "\x01\x01\x02\x04\x52\x82\x0f\xd3\x02\x1b\xb2\x82\x37\x67\x02\x02\xf4\x82\x3c\x96\x02\x13\xc8\x82\x86\xa6\x82\x13\xc8\x82\x3c\x96\x82\x02\xf4\x82\x37\x67\x82\x1b\xb2\x82\x0f\xd3\x82\x04\x52" },
  { 3172, 2, 8, "\x01\x01\x82\x04\x60\x82\x17\x0c\x82\x35\x48\x82\x45\x43\x82\x35\x48\x82\x17\x0c\x82\x04\x60" },
  { 3208, 2, 12, "\x01\x01\x82\x04\x95\x81\xe1\x02\x0b\x58\x02\x09\xc9\x82\x0a\x53\x82\x10\xf2\x82\x0a\x53\x02\x09\xc9\x02\x0b\x58\x81\xe1\x82\x04\x95" },
  { 3220, 2, 16, "\x01\x01\x03\x15\x97\x92\x04\x01\x41\x75\xaf\x04\x04\xb2\x12\x16\x04\x05\x7d\x64\x11\x04\x09\x9d\xe6\x18\x04\x09\x4c\xcc\x7e\x84\x11\xc7\x2e\x5c\x84\x1d\xd5\x0b\xee\x04\x11\xc7\x2e\x5c\x04\x09\x4c\xcc\x7e\x84\x09\x9d\xe6\x18\x04\x05\x7d\x64\x11\x84\x04\xb2\x12\x16\x04\x01\x41\x75\xaf\x83\x15\x97\x92" },
  { 3235, 1, 6, "\x0f\x10\xaa\x7f\xf6\x27\x58\x44\x6f\xaf\x2a\xdf\x00\x00\x00\x00\xab\x1b\x6a\x70\xbb\x59\xfa\x11\x8c\x91\x43\xdd\x68\x6d\x23\x38\xef\xe4\x4d\x06\x44\x97\xf8\xa5\x9c\x7a\x08\x53\xbe\x09\x52\x7a\x10\xa7\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2a\x0d\x27\x2f\x4d\xd4\x38\x0f\xbb\x41\xe3\x8e\xff\x40\xa8\xce\xea\x27\x0e\xc7\x7a\x05\xc9\xa3\x3e\xdd\xae\xb8\x66\x74\x8b\xd7\xd9\x08\x93\xf0\x00\x00\x00\x00\x00\x00\x00\xa8\xa6\x54\xd5\xaf\xf3\x3a\x15\xc1\x97\x0a\xad\xea\xeb\xfa\x04\x9e\x81\x71\x2c\x96\xcd\x76\x74\xff\x08\xc7\xbd\x4a\x98\xc0\x49\xea\xf9\xfa\xc0\x00\x00\x00\x00\x00\x27\x28\xa3\x88\x54\xd7\xdc\xbf\xa4\xbf\xfa\x15\x64\x51\x7a\xd5\xb2\xb3\x9b\xdb\xd4\x0c\xd3\x2c\x59\xf8\x3a\xa8\x63\x45\x1d\x22\x67\x25\x29\x9a\x00\x00\x00\x00\x21\x03\x73\xa4\xe1\x5a\x7b\x13\xa8\x73\x9f\xc2\x24\xc1\xa9\x9e\x63\x9e\xd8\x6f\x81\xbf\x78\xda\x06\x7f\x59\xe8\x75\xe3\x1f\xb7\x00\x00" },
  { 3256, 2, 12, "\x01\x01\x82\x04\xd4\x82\x12\x90\x82\x4e\xa8\x82\x88\x38\x82\xb5\x5c\x82\xf1\x86\x82\xb5\x5c\x82\x88\x38\x82\x4e\xa8\x82\x12\x90\x82\x04\xd4" },
  { 3268, 2, 12, "\x01\x01\x82\x04\xec\x02\x0e\xb0\x82\x1b\xc6\x02\x03\x20\x02\x17\x34\x82\x39\x26\x02\x17\x34\x02\x03\x20\x82\x1b\xc6\x02\x0e\xb0\x82\x04\xec" },
  { 3304, 2, 12, "\x01\x01\x02\x05\x24\x02\x20\x00\x02\x51\x28\x02\x48\x48\x02\x3d\xcc\x02\x58\x1e\x82\x3d\xcc\x02\x48\x48\x82\x51\x28\x02\x20\x00\x82\x05\x24" },
  { 3343, 2, 19, "\x81\x01\x01\x08\x81\x3c\x01\x7e\x82\x01\x7c\x02\x04\x8c\x82\x0b\x47\x02\x16\x09\x82\x22\x87\x02\x2b\xd5\x82\x30\x65\x02\x2b\x41\x82\x28\x5f\x02\x21\xc1\x82\x25\xc9\x02\x1e\x54\x82\x19\xc8\x02\x0a\x6f\x82\x05\x5b" },
  { 3352, 2, 14, "\x81\x01\x82\x05\x6a\x82\x0f\xe7\x82\x29\x68\x82\x27\x20\x82\x44\xe8\x82\x16\xb2\x82\x43\xc4\x02\x16\xb2\x82\x44\xe8\x02\x27\x20\x82\x29\x68\x02\x0f\xe7\x82\x05\x6a" },
  { 3367, 2, 20, "\x01\x01\x81\x06\x01\x3d\x81\xdf\x02\x01\x9b\x01\x7b\x82\x08\x7b\x02\x0c\x99\x02\x05\x94\x82\x21\x7b\x02\x16\xc1\x02\x1e\xb0\x82\x31\x3c\x82\x01\xb3\x02\x30\x3b\x82\x11\xa3\x82\x18\x10\x02\x14\x28\x02\x07\x32\x82\x05\x80" },
  { 3412, 2, 10, "\x81\x01\x83\x21\x68\x88\x04\x01\x3f\xfe\xef\x84\x04\x74\xc3\x84\x04\x05\x91\xb6\xe7\x84\x01\xe4\x05\x54\x84\x05\x91\xb6\xe7\x84\x04\x74\xc3\x84\x84\x01\x3f\xfe\xef\x83\x21\x68\x88" },
  { 3427, 1, 6, "\x0f\x06\xa4\x2c\x12\x2f\x0d\x38\xcb\x70\x94\xd1\x00\x00\x00\x00\xaa\x8a\x84\x6a\x4b\xb2\xa5\x55\xe3\x94\x11\xa2\x31\x8b\x2d\x6a\x0c\xd6\xf2\xff\x33\xd8\x33\x12\x08\xb1\xc7\x64\xe8\x44\x94\x0b\x33\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x07\x5d\x2b\x28\x81\x73\xcf\x95\x03\x02\x49\x81\x73\x22\x70\xc9\xe5\xc4\xbe\x8a\x4f\xbc\xd3\x34\x59\x93\x93\xf5\x33\xb2\xda\x4a\x54\x70\x00\x00\x00\x00\x00\x00\x00\x28\x02\xf7\x2b\x5f\xdd\x2c\xfa\x04\xc4\x81\xaf\xc9\x1a\x77\xb5\x24\x7f\xf0\x80\x93\x88\x26\x06\x3c\x6d\xf2\xbb\x27\x90\xf9\x57\x01\xfc\x6e\x40\x00\x00\x00\x00\x00\x25\x02\x44\x1d\x1f\x54\xb9\x79\x8c\x66\x62\xae\xef\xef\x27\x3c\x6f\x63\xa0\x8c\xef\x46\x0e\x74\x87\xef\x59\x55\x14\x68\x19\xda\x75\x08\x00\x00\x00\x00\x22\x02\x82\x42\x35\xbf\x09\xbc\x0a\x8a\xaa\x3b\x9c\xfd\x29\x4a\x4a\x49\x38\x0b\x6c\x5f\x92\x47\xb3\xe8\xf4\x30\xe0\x2b\x2d\x4b\xab\x00\x00" },
  { 3448, 2, 8, "\x01\x01\x82\x06\x06\x02\x09\x7b\x82\x05\x0a\x82\x03\x94\x82\x05\x0a\x02\x09\x7b\x82\x06\x06" },
  { 3460, 2, 16, "\x01\x01\x82\x06\x15\x82\x19\x49\x82\x1a\x20\x82\x2b\x25\x82\x40\xd5\x82\x4c\x12\x82\x3b\x95\x82\x7e\xc4\x82\x3b\x95\x82\x4c\x12\x82\x40\xd5\x82\x2b\x25\x82\x1a\x20\x82\x19\x49\x82\x06\x15" },
  { 3463, 2, 19, "\x81\x01\x01\x0b\x81\x09\x81\x8a\x81\x43\x02\x01\xb5\x02\x01\xaf\x02\x01\x97\x82\x0c\x95\x02\x06\xd6\x82\x0a\x66\x02\x26\x7b\x82\x1c\xa0\x02\x09\x73\x82\x22\x0d\x02\x18\x3a\x02\x0f\x57\x82\x08\x61\x82\x06\x1d" },
  { 3496, 2, 20, "\x01\x01\x02\x06\x56\x82\x11\x9b\x02\x69\x8e\x82\x5e\xfc\x02\xf4\x22\x02\xa2\xb3\x83\x01\x4d\x62\x02\xb8\x27\x83\x01\xad\x6c\x83\x02\x09\x88\x03\x01\xad\x6c\x02\xb8\x27\x03\x01\x4d\x62\x02\xa2\xb3\x82\xf4\x22\x82\x5e\xfc\x82\x69\x8e\x82\x11\x9b\x82\x06\x56" },
  { 3508, 2, 10, "\x81\x01\x83\x29\x5d\x94\x03\x85\xeb\x0f\x83\x76\x97\x70\x03\x2d\x37\xaf\x83\x40\x88\xc4\x83\x2d\x37\xaf\x83\x76\x97\x70\x83\x85\xeb\x0f\x83\x29\x5d\x94" },
  { 3523, 1, 6, "\x0f\x17\xd1\x0e\xf9\x82\x2a\x57\x6e\x74\xfa\xf0\x00\x00\x00\x00\xaa\x96\x69\x9c\xc7\x10\xba\xfa\x0b\xc8\x6f\x6a\x3d\xcb\x5d\x88\x63\x02\x98\x94\x1e\xb5\xb7\xe1\x82\xeb\x1e\xa9\x5c\xea\xa9\xe4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x02\xaf\xee\x03\x7f\x21\xa3\x33\x79\xe2\xe3\x72\xe0\x64\x8d\x16\x8e\x4d\x75\xbc\x6a\xb4\x54\xe9\x42\x61\x8f\x3c\x07\x92\x01\x03\x94\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x3e\x48\xeb\x1a\xd9\x31\xd0\x92\x82\xeb\xe4\x56\xdc\x99\x34\x29\xb6\x43\x48\xaa\x96\x5b\x29\x0a\x27\x05\xf8\x5b\x69\x9a\xb4\x96\x00\x00\x00\x00\x00\x00\x25\x03\x42\x77\x93\x59\x09\x88\xef\x0a\x52\x03\xbd\x0f\x81\x9c\xb6\x45\x21\xdf\x57\xc2\x53\xd2\x10\x4a\x81\xed\x75\x7b\x4e\x0c\x83\x29\x40\x00\x00\x00\x22\x20\x64\xb0\x8b\x31\xcb\xd2\x18\x9e\xa4\xb1\xb2\x07\x45\xc7\x2b\x5a\x7e\xb4\xd6\x77\x78\x03\xd1\xaf\x6a\x62\x13\x87\xa8\xd3\xb3\x00\x00" },
  { 3544, 2, 18, "\x81\x01\x82\x06\xb6\x82\x20\x93\x82\x41\xdc\x82\x16\xc6\x82\x9f\x08\x82\x52\x76\x82\x30\xa8\x02\x0b\x9d\x02\x24\x72\x82\x0b\x9d\x82\x30\xa8\x02\x52\x76\x82\x9f\x08\x02\x16\xc6\x82\x41\xdc\x02\x20\x93\x82\x06\xb6" },
  { 3556, 2, 16, "\x01\x01\x82\x06\xca\x02\x0e\x7a\x82\x38\xdc\x03\x01\x05\x25\x83\x01\x8f\x34\x02\xd2\x3e\x02\x3d\xca\x82\x85\x9c\x02\x3d\xca\x02\xd2\x3e\x83\x01\x8f\x34\x03\x01\x05\x25\x82\x38\xdc\x02\x0e\x7a\x82\x06\xca" },
  { 3592, 2, 12, "\x01\x01\x82\x07\x0b\x82\x12\xae\x82\x23\x61\x82\x37\x5c\x82\x51\x57\x82\x52\xec\x82\x51\x57\x82\x37\x5c\x82\x23\x61\x82\x12\xae\x82\x07\x0b" },
  { 3607, 2, 19, "\x81\x01\x81\x08\x81\x13\x01\x90\x81\x3a\x81\x70\x82\x05\x74\x02\x12\x2c\x82\x14\xe1\x81\x4b\x02\x25\x66\x82\x41\xe0\x02\x3c\xf4\x82\x0f\x4d\x82\x2a\x47\x02\x41\x3b\x82\x32\x0d\x02\x19\x8b\x82\x07\x2f" },
  { 3640, 2, 16, "\x01\x01\x82\x07\x68\x82\x30\x36\x82\x59\xd0\x82\x01\x7f\x03\x01\x02\x30\x03\x02\xc2\x4a\x03\x05\x46\x48\x03\x06\xad\x64\x03\x05\x46\x48\x03\x02\xc2\x4a\x03\x01\x02\x30\x82\x01\x7f\x82\x59\xd0\x82\x30\x36\x82\x07\x68" },
  { 3652, 2, 12, "\x01\x01\x82\x07\x80\x82\x37\xa0\x82\xbd\x7e\x83\x01\x91\xe0\x83\x02\x6e\x80\x83\x02\xd6\x86\x83\x02\x6e\x80\x83\x01\x91\xe0\x82\xbd\x7e\x82\x37\xa0\x82\x07\x80" },
  { 3655, 2, 20, "\x01\x01\x01\x15\x01\xab\x02\x02\xdc\x02\x07\x87\x02\x0a\x32\x82\x04\x80\x82\x31\x47\x82\x65\x1e\x82\x59\x0a\x02\x33\x42\x03\x01\x11\xb7\x03\x01\x9d\x1d\x03\x01\x53\xb7\x02\x5c\x37\x82\x9b\x55\x82\xf2\xae\x82\xa6\xbc\x82\x39\xde\x82\x07\x86" },
  { 3688, 2, 18, "\x81\x01\x82\x07\xd7\x82\x18\xbd\x82\x25\x42\x02\x05\xcd\x02\x0f\x09\x82\x47\x2d\x82\x40\x62\x02\x39\xba\x02\x3f\xe4\x82\x39\xba\x82\x40\x62\x02\x47\x2d\x02\x0f\x09\x82\x05\xcd\x82\x25\x42\x02\x18\xbd\x82\x07\xd7" },
  { 3752, 2, 16, "\x01\x01\x02\x08\x78\x02\xb6\x8e\x03\x05\x23\x60\x03\x0b\x90\xc1\x03\x14\x2e\x50\x03\x19\xb7\xee\x03\x0e\xbb\xe8\x03\x20\x6c\x84\x83\x0e\xbb\xe8\x03\x19\xb7\xee\x83\x14\x2e\x50\x03\x0b\x90\xc1\x83\x05\x23\x60\x02\xb6\x8e\x82\x08\x78" },
  { 3763, 1, 6, "\x8e\x3d\xd3\xff\x9e\xbf\xee\xa5\xc5\x84\xb1\x00\x00\x00\x00\x28\x23\x8f\x88\x89\x08\x6f\x2d\xae\x8b\x83\x2b\x71\x0d\x90\xb0\x64\x93\xc0\x4f\x2b\xe9\x61\x10\xa5\xa0\xc7\x3b\x60\x87\xad\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x01\xbc\x9f\x67\xd9\x90\xa5\xa6\x65\x41\xc0\x8b\x8d\x0d\xb1\xca\x95\xbb\x4e\xaf\x6f\x89\x6b\x48\xa2\x09\xd0\x58\x8a\x9d\x6a\xc6\x50\x00\x00\x00\x00\x00\x00\x00\x26\x8e\xc2\x74\x48\x9b\x4f\xa6\x68\xf9\x4c\xcb\xea\xff\xe7\x66\x97\xe7\x28\x1f\x37\x76\x86\x35\x5d\xf9\xaf\xbe\x51\x96\xa3\x39\x31\xc0\x00\x00\x00\x00\x00\xa5\x0a\xab\x06\x33\x69\x3b\x4a\xcd\xb5\xe8\x0c\xb0\xae\x4b\x49\xe1\x1e\xca\xff\x2d\x50\xf4\x6b\xb6\x0c\x9e\xce\xe8\x9a\x5b\x0f\xfe\xd1\x00\x00\x00\x00\x23\x41\x57\x3b\x50\x86\x52\xc9\x80\x6d\x88\x86\x64\x4c\xc1\xbf\x0c\x10\x77\xb7\xc4\x98\x71\x69\x78\xf1\x33\x1d\x4a\x81\x2a\xd1\xae\xcd\x00\x00" },
  { 3768, 2, 12, "\x01\x01\x85\x02\x6c\x4c\x90\xd8\x86\x0a\x4b\xf0\x66\xec\xa2\x06\x26\xcd\xed\xbb\x74\x48\x86\xae\x13\x5f\x80\xb3\xd1\x07\x01\x73\x00\x8e\x40\xbb\x10\x87\x01\xec\x44\xd7\x51\x6c\x5c\x07\x01\x73\x00\x8e\x40\xbb\x10\x86\xae\x13\x5f\x80\xb3\xd1\x06\x26\xcd\xed\xbb\x74\x48\x86\x0a\x4b\xf0\x66\xec\xa2\x85\x02\x6c\x4c\x90\xd8" },
  { 3784, 2, 16, "\x01\x01\x82\x08\xb2\x02\x2d\x33\x82\x45\xba\x82\x75\xef\x02\x4c\xc8\x02\xbd\x7e\x02\x5f\x7c\x83\x02\x0e\x56\x02\x5f\x7c\x02\xbd\x7e\x02\x4c\xc8\x82\x75\xef\x82\x45\xba\x02\x2d\x33\x82\x08\xb2" },
  { 3796, 2, 12, "\x01\x01\x03\x4d\x33\x22\x84\x05\xe5\x40\x95\x04\x2a\x02\x9e\x86\x04\x36\x3b\xaf\xab\x84\x72\x1e\xa2\x3c\x84\x2b\xb7\x2d\x2e\x04\x72\x1e\xa2\x3c\x04\x36\x3b\xaf\xab\x84\x2a\x02\x9e\x86\x84\x05\xe5\x40\x95\x83\x4d\x33\x22" },
  { 3832, 2, 16, "\x01\x01\x82\x09\x1e\x82\x19\x5f\x82\x2a\x96\x82\x03\x2f\x02\xa0\x08\x02\xdf\x1a\x82\x70\xa4\x83\x01\x83\xf6\x82\x70\xa4\x02\xdf\x1a\x02\xa0\x08\x82\x03\x2f\x82\x2a\x96\x82\x19\x5f\x82\x09\x1e" },
  { 3880, 2, 12, "\x01\x01\x02\x09\x98\x82\x13\xa8\x82\x1b\x38\x82\x58\x98\x82\x06\xc8\x82\x5c\xd2\x02\x06\xc8\x82\x58\x98\x02\x1b\x38\x82\x13\xa8\x82\x09\x98" },
  { 3892, 2, 12, "\x01\x01\x03\x5e\x8b\xd0\x04\x01\xaa\x1d\xd0\x83\x2a\x3e\x58\x04\x05\x49\x92\x70\x03\x1b\x8c\x10\x04\x06\x6c\xe4\x8e\x83\x1b\x8c\x10\x04\x05\x49\x92\x70\x03\x2a\x3e\x58\x04\x01\xaa\x1d\xd0\x83\x5e\x8b\xd0" },
  { 3928, 2, 10, "\x81\x01\x82\x0a\x18\x02\x08\x0e\x02\x16\x6e\x82\x11\xf9\x82\x1d\xe4\x02\x11\xf9\x02\x16\x6e\x82\x08\x0e\x82\x0a\x18" },
  { 3972, 2, 12, "\x01\x01\x85\x04\x9d\x06\x28\xb2\x86\x18\x18\x35\x01\x82\x76\x07\x01\x82\x6b\x58\xa7\xd1\xee\x87\x0f\x70\xab\xe8\xe8\x83\x81\x07\x0f\x31\xb1\xcd\x22\xd6\xc4\x87\x22\x36\xb4\xd3\xb5\x14\x14\x07\x0f\x31\xb1\xcd\x22\xd6\xc4\x87\x0f\x70\xab\xe8\xe8\x83\x81\x07\x01\x82\x6b\x58\xa7\xd1\xee\x86\x18\x18\x35\x01\x82\x76\x85\x04\x9d\x06\x28\xb2" },
  { 3976, 2, 16, "\x01\x01\x82\x0a\x9e\x02\x07\xfb\x82\x5d\xba\x03\x01\x91\x89\x83\x01\x32\xb4\x02\xd2\x4e\x83\x01\x85\xd0\x03\x03\x6f\xa2\x83\x01\x85\xd0\x02\xd2\x4e\x83\x01\x32\xb4\x03\x01\x91\x89\x82\x5d\xba\x02\x07\xfb\x82\x0a\x9e" },
  { 3988, 2, 14, "\x81\x01\x83\x73\x80\x9c\x84\x04\x2e\xed\x0f\x84\x18\x56\x6a\x78\x84\x3c\x71\xee\x00\x84\x79\xc4\x92\xc8\x84\x4d\x17\xe1\xde\x84\x40\x5d\x6f\x08\x04\x4d\x17\xe1\xde\x84\x79\xc4\x92\xc8\x04\x3c\x71\xee\x00\x84\x18\x56\x6a\x78\x04\x04\x2e\xed\x0f\x83\x73\x80\x9c" },
  { 4015, 2, 20, "\x01\x01\x01\x11\x01\x6d\x02\x01\x03\x02\x01\xc5\x02\x03\x00\x82\x06\x50\x82\x1d\x06\x82\x09\xad\x02\x30\x64\x02\x1e\xa8\x82\x07\x3d\x02\x06\xbb\x82\x40\x46\x82\x4d\x30\x02\x5d\x78\x02\x69\x8a\x82\x29\x90\x82\x39\xbc\x82\x0b\x08" },
  { 4072, 2, 18, "\x81\x01\x82\x0b\xb5\x02\x25\x3b\x82\x3b\x9e\x02\x49\x4d\x82\x84\x2d\x02\x55\x63\x83\x01\x78\x6e\x02\x28\xc2\x83\x02\x67\x24\x82\x28\xc2\x83\x01\x78\x6e\x82\x55\x63\x82\x84\x2d\x82\x49\x4d\x82\x3b\x9e\x82\x25\x3b\x82\x0b\xb5" },
  { 4120, 2, 12, "\x01\x01\x02\x0c\x4a\x82\x3f\x0d\x02\x56\xd2\x82\x6b\x6e\x02\x3e\x22\x82\x10\x6d\x82\x3e\x22\x82\x6b\x6e\x82\x56\xd2\x82\x3f\x0d\x82\x0c\x4a" },
  { 4132, 2, 12, "\x01\x01\x82\x0c\x77\x02\x0d\xd2\x02\x15\x35\x82\x0b\x72\x82\x1a\x3f\x02\x0b\x7e\x82\x1a\x3f\x82\x0b\x72\x02\x15\x35\x02\x0d\xd2\x82\x0c\x77" },
  { 4152, 2, 12, "\x01\x01\x85\x08\x08\x65\x9e\xb8\x86\x33\x55\x07\x21\x1e\x22\x87\x01\xa3\xec\xb6\xe2\x17\x18\x87\x05\xd9\xdf\xe4\xea\x21\xd1\x87\x0b\xd9\x1b\x71\x35\x99\xb0\x87\x0e\xdf\xd5\x61\xeb\xc5\x5c\x87\x0b\xd9\x1b\x71\x35\x99\xb0\x87\x05\xd9\xdf\xe4\xea\x21\xd1\x87\x01\xa3\xec\xb6\xe2\x17\x18\x86\x33\x55\x07\x21\x1e\x22\x85\x08\x08\x65\x9e\xb8" },
  { 4168, 2, 12, "\x01\x01\x82\x0c\xed\x02\x03\xa2\x82\x6d\x9b\x02\x4f\xc8\x83\x01\x43\xa9\x02\xbe\xc8\x83\x01\x43\xa9\x02\x4f\xc8\x82\x6d\x9b\x02\x03\xa2\x82\x0c\xed" },
  { 4180, 2, 16, "\x01\x01\x03\xab\x28\xc2\x04\x0b\x43\x84\x7f\x04\x13\xa3\x88\x66\x84\x0f\x28\x5c\x2f\x84\x15\x64\x29\xa8\x84\x20\x9c\x09\x42\x84\x2a\xc3\x21\x3c\x04\x4b\x44\x02\x72\x04\x2a\xc3\x21\x3c\x84\x20\x9c\x09\x42\x04\x15\x64\x29\xa8\x84\x0f\x28\x5c\x2f\x84\x13\xa3\x88\x66\x04\x0b\x43\x84\x7f\x83\xab\x28\xc2" },
  { 4216, 2, 16, "\x01\x01\x82\x0d\x92\x02\x0a\x89\x82\xa2\xea\x03\x02\x11\x81\x83\x03\x2a\xd8\x03\x02\x1c\xea\x03\x01\xa2\x14\x83\x03\xf0\x66\x03\x01\xa2\x14\x03\x02\x1c\xea\x83\x03\x2a\xd8\x03\x02\x11\x81\x82\xa2\xea\x02\x0a\x89\x82\x0d\x92" },
  { 4228, 2, 16, "\x01\x01\x82\x0d\xc4\x02\x75\x5b\x83\x01\xd6\x7c\x03\x04\xbb\x05\x83\x08\xda\xb8\x03\x0d\x07\x96\x83\x0f\xf5\xf0\x03\x10\xfb\x26\x83\x0f\xf5\xf0\x03\x0d\x07\x96\x83\x08\xda\xb8\x03\x04\xbb\x05\x83\x01\xd6\x7c\x02\x75\x5b\x82\x0d\xc4" },
  { 4324, 2, 16, "\x01\x01\x82\x0f\x1e\x81\x51\x02\xa7\xd6\x82\xdc\x7b\x83\x09\xac\xd4\x83\x0c\x12\x06\x03\x09\x27\x18\x03\x1a\x08\xaa\x03\x09\x27\x18\x83\x0c\x12\x06\x83\x09\xac\xd4\x82\xdc\x7b\x02\xa7\xd6\x81\x51\x82\x0f\x1e" },
  { 4327, 2, 19, "\x81\x01\x01\x04\x81\x49\x02\x01\x8b\x82\x02\x67\x82\x03\x40\x02\x09\xe9\x81\x9f\x82\x1a\x5b\x02\x12\x8c\x02\x22\x04\x82\x20\x99\x82\x17\x02\x02\x17\xbd\x82\x05\xaf\x01\x43\x02\x13\x32\x82\x08\xf0\x82\x0f\x29" },
  { 4360, 2, 12, "\x01\x01\x82\x0f\xae\x02\x30\x7e\x02\x35\x4c\x83\x03\x07\x26\x03\x08\x85\x96\x83\x0b\xaf\x5a\x03\x08\x85\x96\x83\x03\x07\x26\x02\x35\x4c\x02\x30\x7e\x82\x0f\xae" },
  { 4372, 2, 10, "\x81\x01\x83\xfb\x61\x03\x04\x02\x13\x6e\xd5\x84\x03\xd7\x08\x14\x04\x02\x51\x55\x86\x84\x05\x12\xa0\xd2\x84\x02\x51\x55\x86\x84\x03\xd7\x08\x14\x84\x02\x13\x6e\xd5\x83\xfb\x61\x03" },
  { 4420, 2, 16, "\x01\x01\x82\x10\x98\x82\x81\xcc\x83\x01\xb8\x70\x83\x04\x10\xf5\x83\x04\xf1\x58\x82\x6c\x24\x03\x07\xea\x20\x03\x0c\xae\x48\x03\x07\xea\x20\x82\x6c\x24\x83\x04\xf1\x58\x83\x04\x10\xf5\x83\x01\xb8\x70\x82\x81\xcc\x82\x10\x98" },
  { 4447, 2, 17, "\x81\x01\x01\x0b\x81\x74\x02\x01\xe2\x82\x01\xc5\x82\x05\x89\x02\x0b\x8d\x81\x65\x82\x16\x0f\x02\x0f\x8d\x02\x07\x0d\x82\x24\x0b\x82\x03\x15\x02\x13\xff\x82\x03\x47\x82\x15\xc4\x82\x11\x11" },
  { 4468, 2, 14, "\x81\x01\x84\x01\x2f\xae\x8d\x83\x63\xad\x1e\x03\x76\x17\x2d\x84\x09\x0d\x29\xcf\x84\x1b\xd0\xe0\x96\x84\x0d\x3d\x02\x5d\x84\x09\x2f\xd4\x8f\x04\x0d\x3d\x02\x5d\x84\x1b\xd0\xe0\x96\x04\x09\x0d\x29\xcf\x03\x76\x17\x2d\x03\x63\xad\x1e\x84\x01\x2f\xae\x8d" },
  { 4516, 2, 16, "\x01\x01\x82\x12\x3f\x82\x4d\xdd\x83\x01\x5a\x54\x83\x01\x28\xd5\x03\x04\x00\x15\x03\x07\xbb\xae\x83\x02\xca\x73\x83\x0c\x41\x9c\x83\x02\xca\x73\x03\x07\xbb\xae\x03\x04\x00\x15\x83\x01\x28\xd5\x83\x01\x5a\x54\x82\x4d\xdd\x82\x12\x3f" },
  { 4552, 2, 12, "\x01\x01\x82\x12\xe7\x82\x34\x35\x82\x64\x38\x82\x76\xe3\x82\x79\x71\x82\x6a\xf2\x82\x79\x71\x82\x76\xe3\x82\x64\x38\x82\x34\x35\x82\x12\xe7" },
  { 4568, 2, 18, "\x81\x01\x82\x13\x20\x03\x01\x9a\xe0\x83\x0f\x23\xf2\x03\x10\x9c\xa0\x83\x37\xc7\x60\x02\x28\x47\x83\x1f\x1c\x00\x83\x0d\x50\x40\x03\x1b\x4e\x2c\x03\x0d\x50\x40\x83\x1f\x1c\x00\x82\x28\x47\x83\x37\xc7\x60\x83\x10\x9c\xa0\x83\x0f\x23\xf2\x83\x01\x9a\xe0\x82\x13\x20" },
  { 4612, 2, 16, "\x01\x01\x82\x14\x07\x82\x4f\x59\x82\x91\xbc\x83\x01\x76\x41\x83\x05\x29\x6b\x83\x0c\x6d\xda\x83\x13\xd2\x23\x83\x16\xda\x78\x83\x13\xd2\x23\x83\x0c\x6d\xda\x83\x05\x29\x6b\x83\x01\x76\x41\x82\x91\xbc\x82\x4f\x59\x82\x14\x07" },
  { 4648, 2, 12, "\x01\x01\x02\x14\xc0\x02\x05\x48\x82\x4b\xc8\x02\x6d\x68\x02\x13\x30\x02\x22\xae\x82\x13\x30\x02\x6d\x68\x02\x4b\xc8\x02\x05\x48\x82\x14\xc0" },
  { 4687, 2, 16, "\x81\x01\x81\x01\x81\x2e\x02\x01\xf2\x82\x07\xfb\x02\x0e\x94\x82\x0c\xea\x02\x01\x8c\x02\x0a\x3f\x82\x0b\x0b\x82\x0a\xbd\x02\x08\xd1\x02\x0c\x40\x82\x1f\x6d\x02\x2c\x02\x82\x15\x8c" },
  { 4708, 2, 12, "\x01\x01\x82\x15\xf4\x82\x7c\x10\x83\x01\x72\xfa\x83\x02\xf3\x00\x83\x04\x64\x74\x83\x05\x04\xa6\x83\x04\x64\x74\x83\x02\xf3\x00\x83\x01\x72\xfa\x82\x7c\x10\x82\x15\xf4" },
  { 4712, 2, 16, "\x01\x01\x02\x15\xfc\x83\x01\xa5\xdc\x03\x0c\x7a\x30\x03\x2c\x4f\xb2\x83\x06\xb6\xd4\x83\x45\xac\x60\x03\x1c\x74\xb4\x03\x1e\xb7\x8b\x83\x1c\x74\xb4\x83\x45\xac\x60\x03\x06\xb6\xd4\x03\x2c\x4f\xb2\x83\x0c\x7a\x30\x83\x01\xa5\xdc\x82\x15\xfc" },
  { 4792, 2, 12, "\x01\x01\x82\x17\xd6\x02\xdb\x2d\x83\x03\x9c\x1e\x03\x09\x30\x1b\x83\x0f\xa3\x2c\x03\x12\x97\x9e\x83\x0f\xa3\x2c\x03\x09\x30\x1b\x83\x03\x9c\x1e\x02\xdb\x2d\x82\x17\xd6" },
  { 4804, 2, 16, "\x01\x01\x82\x18\x1a\x02\xba\x12\x83\x02\x74\x8c\x03\x02\xd9\x5d\x83\x05\x1e\xf4\x03\x05\x03\xe6\x83\x0a\xbe\xf6\x03\x03\xa6\x74\x83\x0a\xbe\xf6\x03\x05\x03\xe6\x83\x05\x1e\xf4\x03\x02\xd9\x5d\x83\x02\x74\x8c\x02\xba\x12\x82\x18\x1a" },
  { 4852, 2, 10, "\x81\x01\x84\x02\x7a\x45\x11\x84\x01\xdd\x59\x3e\x84\x06\xba\x86\x1f\x83\x95\xc7\x19\x04\x0e\x50\x2a\xb0\x03\x95\xc7\x19\x84\x06\xba\x86\x1f\x04\x01\xdd\x59\x3e\x84\x02\x7a\x45\x11" },
  { 4888, 2, 12, "\x01\x01\x02\x1a\x0c\x82\x11\xe0\x82\x12\x2c\x82\x0d\x98\x82\x31\x94\x02\x2d\x52\x02\x31\x94\x82\x0d\x98\x02\x12\x2c\x82\x11\xe0\x82\x1a\x0c" },
  { 4948, 2, 14, "\x81\x01\x84\x02\xf6\xfe\xe3\x04\x0a\x2b\x63\x41\x84\x90\x64\x30\x08\x04\x34\x33\x04\x28\x04\x32\x0e\x45\x08\x05\x01\x99\x0d\x43\x32\x84\x2f\xec\xbb\x6a\x85\x01\x99\x0d\x43\x32\x04\x32\x0e\x45\x08\x84\x34\x33\x04\x28\x84\x90\x64\x30\x08\x84\x0a\x2b\x63\x41\x84\x02\xf6\xfe\xe3" },
  { 4984, 2, 16, "\x01\x01\x82\x1c\x86\x03\x01\x0c\xd1\x83\x03\xe4\xde\x03\x04\x47\x61\x02\xe0\x28\x03\x03\x2c\x0a\x03\x01\x47\xcc\x83\x06\xb2\x56\x03\x01\x47\xcc\x03\x03\x2c\x0a\x02\xe0\x28\x03\x04\x47\x61\x83\x03\xe4\xde\x03\x01\x0c\xd1\x82\x1c\x86" },
  { 5032, 2, 12, "\x01\x01\x02\x1d\xca\x02\x47\x5e\x02\x80\x5c\x82\x66\x36\x02\xf7\xc2\x03\x01\x66\x5e\x82\xf7\xc2\x82\x66\x36\x82\x80\x5c\x02\x47\x5e\x82\x1d\xca" },
  { 5128, 2, 12, "\x01\x01\x82\x20\x7f\x82\xe9\x9a\x83\x03\x4e\x39\x83\x07\xbe\xa0\x83\x0c\xa9\x53\x83\x0e\xdf\x9c\x83\x0c\xa9\x53\x83\x07\xbe\xa0\x83\x03\x4e\x39\x82\xe9\x9a\x82\x20\x7f" },
  { 5140, 2, 12, "\x01\x01\x04\x04\x39\x44\x87\x04\x55\x2c\xed\x0c\x84\x67\x7f\xae\xc1\x04\x3c\x84\xa3\x50\x04\x6b\xaa\xa1\xb7\x04\x6d\xa6\x0b\x2a\x84\x6b\xaa\xa1\xb7\x04\x3c\x84\xa3\x50\x04\x67\x7f\xae\xc1\x04\x55\x2c\xed\x0c\x84\x04\x39\x44\x87" },
  { 5188, 2, 12, "\x01\x01\x82\x22\x5c\x02\x40\x3b\x82\x23\x7e\x02\x8e\x0b\x82\xfd\x0e\x02\x8e\x22\x82\xfd\x0e\x02\x8e\x0b\x82\x23\x7e\x02\x40\x3b\x82\x22\x5c" },
  { 5224, 2, 18, "\x81\x01\x82\x23\x85\x82\xf6\xc0\x83\x02\x7d\x15\x03\x01\x51\x08\x82\x91\x95\x03\x06\x23\xcb\x03\x01\x19\x6a\x83\x0f\x84\x78\x03\x02\x01\xba\x03\x0f\x84\x78\x03\x01\x19\x6a\x83\x06\x23\xcb\x82\x91\x95\x83\x01\x51\x08\x83\x02\x7d\x15\x02\xf6\xc0\x82\x23\x85" },
  { 5272, 2, 10, "\x81\x01\x82\x25\x10\x02\x1b\xbe\x02\x15\x2a\x02\x0f\xc7\x82\x06\x7c\x82\x0f\xc7\x02\x15\x2a\x82\x1b\xbe\x82\x25\x10" },
  { 5380, 2, 16, "\x01\x01\x82\x28\xd5\x82\x20\x8d\x03\x02\x52\xcc\x83\x03\xde\xc8\x82\x16\xba\x03\x03\x67\xcd\x03\x02\xfa\x83\x83\x08\xf5\x72\x03\x02\xfa\x83\x03\x03\x67\xcd\x82\x16\xba\x83\x03\xde\xc8\x03\x02\x52\xcc\x82\x20\x8d\x82\x28\xd5" },
  { 5464, 2, 18, "\x81\x01\x82\x2c\x0a\x83\x01\xaf\x91\x83\x07\x64\x5c\x83\x0d\x85\xf7\x83\x12\xe1\x72\x83\x08\x90\xf9\x83\x0e\x3d\x0c\x83\x04\x6e\xd2\x83\x20\x0c\x58\x03\x04\x6e\xd2\x83\x0e\x3d\x0c\x03\x08\x90\xf9\x83\x12\xe1\x72\x03\x0d\x85\xf7\x83\x07\x64\x5c\x03\x01\xaf\x91\x82\x2c\x0a" },
  { 5527, 2, 19, "\x81\x01\x81\x08\x81\x0a\x02\x02\x14\x82\x0f\xb4\x02\x39\x69\x82\x8d\x54\x02\xfa\xe6\x83\x01\x4c\x65\x03\x01\x4c\x6b\x82\xe0\x1a\x02\x10\x57\x02\xba\x09\x82\xff\x0f\x02\xc8\x2e\x82\x43\x1a\x82\x52\x3c\x02\x74\xf2\x82\x2e\x87" },
  { 5572, 2, 16, "\x01\x01\x82\x30\x64\x82\x23\x85\x02\xb7\x64\x03\x02\x98\x25\x03\x02\xea\xe8\x03\x01\x3b\xf6\x83\x04\x3e\xf0\x83\x05\x60\x9a\x83\x04\x3e\xf0\x03\x01\x3b\xf6\x03\x02\xea\xe8\x03\x02\x98\x25\x02\xb7\x64\x82\x23\x85\x82\x30\x64" },
  { 5608, 2, 14, "\x81\x01\x82\x31\xf3\x82\x51\x56\x02\x58\x9b\x02\xe6\xd9\x82\x60\xba\x83\x01\x60\x95\x02\x53\x07\x03\x01\x60\x95\x82\x60\xba\x82\xe6\xd9\x02\x58\x9b\x02\x51\x56\x82\x31\xf3" },
  { 5668, 2, 16, "\x01\x01\x82\x34\x9e\x82\x60\xa9\x03\x01\x2f\x2a\x03\x01\x60\xbd\x83\x07\x1a\x48\x03\x04\xdd\x0a\x03\x08\xcb\x2c\x83\x11\xc7\x5e\x03\x08\xcb\x2c\x03\x04\xdd\x0a\x83\x07\x1a\x48\x03\x01\x60\xbd\x03\x01\x2f\x2a\x82\x60\xa9\x82\x34\x9e" },
  { 5752, 2, 16, "\x01\x01\x82\x38\x8e\x83\x02\x54\x4f\x83\x0b\x68\x86\x83\x23\x3a\xef\x83\x51\x43\x38\x83\x96\x00\x66\x83\xdc\x76\x04\x83\xfb\x8d\x16\x83\xdc\x76\x04\x83\x96\x00\x66\x83\x51\x43\x38\x83\x23\x3a\xef\x83\x0b\x68\x86\x83\x02\x54\x4f\x82\x38\x8e" },
  { 5812, 2, 14, "\x81\x01\x84\x0d\xdf\x9f\xb5\x04\x0f\x1c\x84\xf0\x84\x77\xda\xf7\x55\x04\x22\xa9\x4e\x8e\x85\x01\x65\x52\xbd\xef\x04\x05\xaa\xf5\xad\x85\x01\xbf\xcf\x01\x0e\x84\x05\xaa\xf5\xad\x85\x01\x65\x52\xbd\xef\x84\x22\xa9\x4e\x8e\x84\x77\xda\xf7\x55\x84\x0f\x1c\x84\xf0\x84\x0d\xdf\x9f\xb5" },
  { 5848, 2, 16, "\x01\x01\x02\x3d\x78\x02\x57\x32\x03\x01\xa6\x20\x03\x05\x7b\x49\x03\x03\xd3\x60\x03\x01\x1a\x42\x03\x05\x84\x38\x83\x05\x7e\x6c\x83\x05\x84\x38\x03\x01\x1a\x42\x83\x03\xd3\x60\x03\x05\x7b\x49\x83\x01\xa6\x20\x02\x57\x32\x82\x3d\x78" },
  { 5860, 2, 16, "\x01\x01\x82\x3e\x13\x83\x01\x70\x45\x83\x01\x2b\xfc\x83\x02\xaf\xb0\x83\x07\xb4\x76\x83\x0b\xda\xdb\x83\x0e\x42\x7b\x83\x17\xcc\x62\x83\x0e\x42\x7b\x83\x0b\xda\xdb\x83\x07\xb4\x76\x83\x02\xaf\xb0\x83\x01\x2b\xfc\x83\x01\x70\x45\x82\x3e\x13" },
  { 5896, 2, 16, "\x01\x01\x82\x40\x08\x82\x44\x3a\x83\x05\x61\xe4\x03\x0d\xcc\x69\x83\x06\x30\xd8\x83\x13\x17\x12\x03\x36\x7a\xc4\x83\x4a\xb2\x3c\x03\x36\x7a\xc4\x83\x13\x17\x12\x83\x06\x30\xd8\x03\x0d\xcc\x69\x83\x05\x61\xe4\x82\x44\x3a\x82\x40\x08" },
  { 5992, 2, 16, "\x01\x01\x02\x45\x7e\x03\x01\x5a\xbf\x03\x02\x8e\x2a\x03\x03\x7d\x71\x03\x02\xe9\x98\x03\x01\xe8\xbe\x83\x03\xba\xb4\x83\x03\x84\xae\x03\x03\xba\xb4\x03\x01\xe8\xbe\x83\x02\xe9\x98\x03\x03\x7d\x71\x83\x02\x8e\x2a\x03\x01\x5a\xbf\x82\x45\x7e" },
  { 6040, 2, 16, "\x01\x01\x02\x48\x56\x82\x9c\x43\x83\x03\x48\x92\x83\x0b\x9c\xe7\x03\x0b\x75\xf4\x03\x0e\x5a\x6a\x83\x0d\x28\x10\x83\x17\x2c\x86\x03\x0d\x28\x10\x03\x0e\x5a\x6a\x83\x0b\x75\xf4\x83\x0b\x9c\xe7\x03\x03\x48\x92\x82\x9c\x43\x82\x48\x56" },
  { 6052, 2, 16, "\x01\x01\x82\x49\x15\x02\x3c\x3f\x82\xe4\x4c\x03\x01\x65\xf4\x83\x02\x12\x82\x03\x02\x47\x61\x82\x6f\x1d\x02\xce\xd6\x82\x6f\x1d\x03\x02\x47\x61\x83\x02\x12\x82\x03\x01\x65\xf4\x82\xe4\x4c\x02\x3c\x3f\x82\x49\x15" },
  { 6148, 2, 16, "\x01\x01\x82\x4f\x35\x02\x7d\x57\x83\x01\xaf\xc0\x03\x01\xcf\x1b\x83\x01\x8e\x95\x82\x31\xd2\x03\x02\xe0\xab\x83\x05\xb4\x84\x03\x02\xe0\xab\x82\x31\xd2\x83\x01\x8e\x95\x03\x01\xcf\x1b\x83\x01\xaf\xc0\x02\x7d\x57\x82\x4f\x35" },
  { 6232, 2, 12, "\x01\x01\x02\x54\xec\x82\xf7\x90\x82\x17\x0c\x03\x02\xeb\x78\x83\x01\x17\x74\x83\x03\xf3\x6e\x03\x01\x17\x74\x03\x02\xeb\x78\x02\x17\x0c\x82\xf7\x90\x82\x54\xec" },
  { 6328, 2, 16, "\x01\x01\x82\x5b\xf2\x02\x58\xa1\x03\x01\xf3\x86\x02\xb0\xd1\x02\x01\xf8\x03\x06\x95\x9a\x03\x04\x52\x04\x83\x01\x88\x76\x03\x04\x52\x04\x03\x06\x95\x9a\x02\x01\xf8\x02\xb0\xd1\x03\x01\xf3\x86\x02\x58\xa1\x82\x5b\xf2" },
  { 6388, 2, 14, "\x81\x01\x84\x24\x70\x44\xf3\x04\x86\x7a\xda\x01\x85\x02\x00\xb5\xd2\x48\x05\x03\x9c\xf1\xfe\xa8\x04\x9a\xfd\xd6\x48\x85\x08\x53\x12\x43\x0e\x05\x01\xdb\xf1\x83\xb6\x05\x08\x53\x12\x43\x0e\x04\x9a\xfd\xd6\x48\x85\x03\x9c\xf1\xfe\xa8\x85\x02\x00\xb5\xd2\x48\x84\x86\x7a\xda\x01\x84\x24\x70\x44\xf3" },
  { 6472, 2, 12, "\x01\x01\x82\x67\x6b\x83\x01\xfd\x01\x83\x04\xb2\xdc\x83\x07\x0b\xdb\x83\x07\xd0\x79\x83\x07\xc1\xca\x83\x07\xd0\x79\x83\x07\x0b\xdb\x83\x04\xb2\xdc\x83\x01\xfd\x01\x82\x67\x6b" },
  { 6532, 2, 16, "\x01\x01\x82\x6c\xa0\x03\x02\xc8\xc8\x83\x09\x80\x50\x03\x16\x9a\x4a\x83\x29\xe5\x30\x03\x3f\xed\xb0\x83\x52\x46\xf0\x03\x59\x90\xeb\x83\x52\x46\xf0\x03\x3f\xed\xb0\x83\x29\xe5\x30\x03\x16\x9a\x4a\x83\x09\x80\x50\x03\x02\xc8\xc8\x82\x6c\xa0" },
  { 6568, 2, 14, "\x81\x01\x82\x6f\xd1\x82\xfe\x5a\x82\xd6\x23\x02\x10\x95\x02\x08\x6a\x02\x55\xa7\x03\x01\x2c\x69\x82\x55\xa7\x02\x08\x6a\x82\x10\x95\x82\xd6\x23\x02\xfe\x5a\x82\x6f\xd1" },
  { 6628, 2, 16, "\x01\x01\x82\x75\x5a\x02\xb0\x6f\x82\x5c\xe2\x83\x09\xd1\xc3\x83\x0a\x5a\x38\x03\x12\xaf\x2a\x83\x03\xf4\x5c\x83\x2e\x84\x4e\x83\x03\xf4\x5c\x03\x12\xaf\x2a\x83\x0a\x5a\x38\x83\x09\xd1\xc3\x82\x5c\xe2\x02\xb0\x6f\x82\x75\x5a" },
  { 6820, 2, 16, "\x01\x01\x82\x88\xc0\x83\x04\x27\x78\x83\x04\xa2\x10\x03\x05\x28\xaa\x03\x03\x31\xf0\x83\x08\x0b\x50\x01\x30\x03\x12\x3e\xcb\x01\x30\x83\x08\x0b\x50\x03\x03\x31\xf0\x03\x05\x28\xaa\x83\x04\xa2\x10\x83\x04\x27\x78\x82\x88\xc0" },
  { 6952, 2, 16, "\x01\x01\x02\x97\xc6\x83\x02\x50\x51\x03\x01\xad\x52\x03\x04\x69\x11\x83\x06\x9b\x18\x83\x03\x8f\xe2\x03\x09\x7e\xac\x03\x01\xba\x72\x83\x09\x7e\xac\x83\x03\x8f\xe2\x03\x06\x9b\x18\x03\x04\x69\x11\x83\x01\xad\x52\x83\x02\x50\x51\x82\x97\xc6" },
  { 7288, 2, 16, "\x01\x01\x82\xc4\xf8\x83\x03\x33\x06\x83\x07\x14\x30\x83\x0a\x12\x4f\x83\x0d\xa9\x10\x83\x0d\x9a\xa6\x83\x0e\xfc\x88\x83\x0c\x44\x7c\x83\x0e\xfc\x88\x83\x0d\x9a\xa6\x83\x0d\xa9\x10\x83\x0a\x12\x4f\x83\x07\x14\x30\x83\x03\x33\x06\x82\xc4\xf8" },
  { 7480, 2, 16, "\x01\x01\x82\xe4\x00\x83\x01\x43\x34\x03\x17\x7e\xa0\x83\x3c\xcd\xd6\x03\x26\x67\x60\x03\x7c\x29\x30\x84\x01\x70\x46\x60\x04\x01\xea\x61\xd3\x84\x01\x70\x46\x60\x03\x7c\x29\x30\x03\x26\x67\x60\x83\x3c\xcd\xd6\x03\x17\x7e\xa0\x83\x01\x43\x34\x82\xe4\x00" },
  { 7492, 2, 12, "\x01\x01\x82\xe6\x19\x03\x02\xfc\xd3\x83\x08\x26\x22\x03\x0e\x2c\x2f\x83\x13\xa3\x0d\x03\x16\xb1\x6a\x83\x13\xa3\x0d\x03\x0e\x2c\x2f\x83\x08\x26\x22\x03\x02\xfc\xd3\x82\xe6\x19" },
  { 7528, 2, 18, "\x81\x01\x82\xec\x6b\x03\x01\xf4\x77\x83\x0d\x0d\x26\x03\x04\x73\x7d\x83\x04\xd7\x27\x83\x17\xc9\x95\x83\x2c\xc9\x5e\x03\x1c\x32\x16\x83\x02\x30\xd4\x83\x1c\x32\x16\x83\x2c\xc9\x5e\x03\x17\xc9\x95\x83\x04\xd7\x27\x83\x04\x73\x7d\x83\x0d\x0d\x26\x83\x01\xf4\x77\x82\xec\x6b" },
  { 7588, 2, 16, "\x01\x01\x82\xf7\x5e\x03\x04\x16\x52\x03\x01\x1f\x84\x83\x0b\xf3\x23\x83\x05\x7f\x6c\x03\x13\x8d\xe6\x03\x06\x96\x36\x83\x0e\x7c\x0c\x03\x06\x96\x36\x03\x13\x8d\xe6\x83\x05\x7f\x6c\x83\x0b\xf3\x23\x03\x01\x1f\x84\x03\x04\x16\x52\x82\xf7\x5e" },
  { 7672, 2, 16, "\x01\x01\x83\x01\x07\x6a\x83\x01\x61\xf7\x03\x06\x49\xfe\x03\x19\x68\xf1\x03\x30\x97\x68\x03\x3d\x24\x7a\x03\x37\xd0\xc4\x03\x31\x08\x5a\x03\x37\xd0\xc4\x03\x3d\x24\x7a\x03\x30\x97\x68\x03\x19\x68\xf1\x03\x06\x49\xfe\x83\x01\x61\xf7\x83\x01\x07\x6a" },
  { 7780, 2, 16, "\x01\x01\x83\x01\x1d\x6d\x83\x0e\xfb\xd4\x83\x57\xd1\x21\x84\x01\x82\x38\x6f\x84\x04\x4e\x51\xd4\x84\x08\xdf\xa8\x36\x84\x0d\x65\xdc\x9e\x84\x0f\x66\x11\x10\x84\x0d\x65\xdc\x9e\x84\x08\xdf\xa8\x36\x84\x04\x4e\x51\xd4\x84\x01\x82\x38\x6f\x83\x57\xd1\x21\x83\x0e\xfb\xd4\x83\x01\x1d\x6d" },
  { 7912, 2, 12, "\x01\x01\x03\x01\x3a\xba\x02\x49\x43\x03\x01\xda\xbe\x02\xb9\xeb\x02\x13\x24\x03\x01\xb4\xa2\x82\x13\x24\x02\xb9\xeb\x83\x01\xda\xbe\x02\x49\x43\x83\x01\x3a\xba" },
  { 8008, 2, 16, "\x01\x01\x83\x01\x51\xb0\x82\x96\x8a\x03\x12\x77\x58\x03\x1b\x7d\x59\x83\x2d\xb0\xa0\x83\x67\x3f\x1a\x03\x1b\xaa\xb8\x03\x9a\xb1\x14\x03\x1b\xaa\xb8\x83\x67\x3f\x1a\x83\x2d\xb0\xa0\x03\x1b\x7d\x59\x03\x12\x77\x58\x82\x96\x8a\x83\x01\x51\xb0" },
  { 8068, 2, 12, "\x01\x01\x83\x01\x60\xcb\x83\x05\xb7\xb6\x83\x0a\xb4\xff\x83\x09\x95\x02\x83\x01\x51\xa3\x03\x03\xfd\xd6\x83\x01\x51\xa3\x83\x09\x95\x02\x83\x0a\xb4\xff\x83\x05\xb7\xb6\x83\x01\x60\xcb" },
  { 8152, 2, 18, "\x81\x01\x83\x01\x77\x04\x03\x01\x39\x00\x83\x06\xb4\xd2\x03\x01\xa7\x20\x83\x11\xbb\x64\x82\x4d\xc9\x83\x1d\xc0\x88\x03\x02\x92\xe0\x83\x23\xae\xf4\x83\x02\x92\xe0\x83\x1d\xc0\x88\x02\x4d\xc9\x83\x11\xbb\x64\x83\x01\xa7\x20\x83\x06\xb4\xd2\x83\x01\x39\x00\x83\x01\x77\x04" },
  { 8248, 2, 12, "\x01\x01\x83\x01\x91\xf4\x83\x04\x6c\x80\x83\x02\xf5\x08\x82\x59\x88\x83\x07\x7e\x5c\x83\x0e\x6e\x86\x83\x07\x7e\x5c\x82\x59\x88\x83\x02\xf5\x08\x83\x04\x6c\x80\x83\x01\x91\xf4" },
  { 8452, 2, 16, "\x01\x01\x83\x01\xd1\x37\x03\x04\x00\x6a\x83\x1d\x6c\xe9\x03\x6c\x31\x27\x83\xce\xe6\x2c\x04\x01\x2c\x16\xd0\x84\x01\x9d\x51\xd8\x04\x01\xde\x4b\x84\x84\x01\x9d\x51\xd8\x04\x01\x2c\x16\xd0\x83\xce\xe6\x2c\x03\x6c\x31\x27\x83\x1d\x6c\xe9\x03\x04\x00\x6a\x83\x01\xd1\x37" },
  { 8488, 2, 18, "\x81\x01\x83\x01\xdd\x47\x83\x03\x74\x4e\x83\x01\x87\x91\x83\x07\x24\x2b\x03\x03\x38\xe2\x03\x1b\xd1\x39\x83\x12\xbd\xff\x03\x0c\x07\x57\x83\x2c\x5c\x16\x83\x0c\x07\x57\x83\x12\xbd\xff\x83\x1b\xd1\x39\x03\x03\x38\xe2\x03\x07\x24\x2b\x83\x01\x87\x91\x03\x03\x74\x4e\x83\x01\xdd\x47" },
  { 8548, 2, 16, "\x01\x01\x83\x01\xf2\x06\x03\x03\xcc\x6a\x83\x0b\x85\xc8\x03\x10\xd7\xcd\x83\x1e\x12\xd4\x03\x23\x32\x46\x83\x2f\x46\x9e\x03\x2c\x54\x84\x83\x2f\x46\x9e\x03\x23\x32\x46\x83\x1e\x12\xd4\x03\x10\xd7\xcd\x83\x0b\x85\xc8\x03\x03\xcc\x6a\x83\x01\xf2\x06" },
  { 8680, 2, 16, "\x01\x01\x03\x02\x22\x98\x83\x03\x83\xaa\x83\x59\x8e\xd0\x83\xaf\xb5\xc7\x83\x29\x39\xe0\x03\x19\x7e\x86\x03\x3f\x10\x88\x04\x01\x19\x30\xd4\x83\x3f\x10\x88\x03\x19\x7e\x86\x03\x29\x39\xe0\x83\xaf\xb5\xc7\x03\x59\x8e\xd0\x83\x03\x83\xaa\x83\x02\x22\x98" },
  { 8932, 2, 16, "\x01\x01\x83\x02\x8b\xa2\x82\x54\xf9\x03\x1a\xf5\x02\x03\x3b\xa7\xe5\x03\x33\xd6\x5c\x82\xb7\x06\x03\x71\x46\x00\x04\x01\x07\x6d\xba\x03\x71\x46\x00\x82\xb7\x06\x03\x33\xd6\x5c\x03\x3b\xa7\xe5\x03\x1a\xf5\x02\x82\x54\xf9\x83\x02\x8b\xa2" },
  { 8968, 2, 16, "\x01\x01\x83\x02\x9c\x10\x83\x02\xb2\x8a\x02\x65\x04\x03\x01\x32\x79\x03\x05\xfd\xa8\x03\x09\x8a\xde\x83\x04\x16\x1c\x83\x15\x96\x9c\x83\x04\x16\x1c\x03\x09\x8a\xde\x03\x05\xfd\xa8\x03\x01\x32\x79\x02\x65\x04\x83\x02\xb2\x8a\x83\x02\x9c\x10" },
  { 9172, 2, 14, "\x81\x01\x85\x09\x03\xab\xe0\x82\x05\x0e\x56\x1c\xbc\x96\x05\x30\x99\x96\xfe\xd0\x85\x14\xc5\x1e\x63\x80\x85\xd3\xea\x77\xbc\x2e\x05\x3a\x15\x31\x96\x99\x05\xff\xb8\xe2\xaf\xc0\x85\x3a\x15\x31\x96\x99\x85\xd3\xea\x77\xbc\x2e\x05\x14\xc5\x1e\x63\x80\x05\x30\x99\x96\xfe\xd0\x85\x0e\x56\x1c\xbc\x96\x85\x09\x03\xab\xe0\x82" },
  { 9208, 2, 16, "\x01\x01\x83\x03\x13\xbc\x83\x02\x0b\x86\x83\x3b\xed\xb8\x03\x36\x6e\x29\x83\xcf\xe7\xc0\x03\x88\xa8\x7a\x83\xf7\xd9\x4c\x04\x01\xfe\xc7\xd4\x83\xf7\xd9\x4c\x03\x88\xa8\x7a\x83\xcf\xe7\xc0\x03\x36\x6e\x29\x83\x3b\xed\xb8\x83\x02\x0b\x86\x83\x03\x13\xbc" },
  { 9412, 2, 16, "\x01\x01\x83\x03\x88\xa6\x03\x02\x82\x8f\x03\x17\x82\xa2\x83\x11\x13\x03\x83\x2f\xa7\x88\x03\x20\xd1\xea\x83\x11\xb4\xe4\x83\x7f\xfe\x0e\x83\x11\xb4\xe4\x03\x20\xd1\xea\x83\x2f\xa7\x88\x83\x11\x13\x03\x03\x17\x82\xa2\x03\x02\x82\x8f\x83\x03\x88\xa6" },
  { 9508, 2, 16, "\x01\x01\x83\x03\xc5\x07\x03\x0b\xc2\xde\x83\x20\x93\xa9\x03\x42\x42\x4f\x83\x6d\x73\x7c\x03\x9c\x4f\x88\x83\xc1\x29\x78\x03\xcb\xfb\x4c\x83\xc1\x29\x78\x03\x9c\x4f\x88\x83\x6d\x73\x7c\x03\x42\x42\x4f\x83\x20\x93\xa9\x03\x0b\xc2\xde\x83\x03\xc5\x07" },
  { 9640, 2, 16, "\x01\x01\x03\x04\x1e\x0e\x83\x2c\x12\xa9\x03\x38\xb5\x5a\x83\x05\xfa\xef\x83\x1d\x62\x08\x83\x6c\x70\x02\x03\x5a\x5c\xac\x83\x0e\x54\xbe\x83\x5a\x5c\xac\x83\x6c\x70\x02\x03\x1d\x62\x08\x83\x05\xfa\xef\x83\x38\xb5\x5a\x83\x2c\x12\xa9\x83\x04\x1e\x0e" },
  { 9832, 2, 18, "\x81\x01\x83\x04\xad\x45\x83\x02\xd4\xb0\x83\x17\x7d\x45\x03\x01\x76\x88\x83\x24\x3c\x45\x03\x09\x96\xeb\x03\x08\xf2\x1a\x03\x04\xb4\x38\x03\x33\xfe\x9a\x83\x04\xb4\x38\x03\x08\xf2\x1a\x83\x09\x96\xeb\x83\x24\x3c\x45\x83\x01\x76\x88\x83\x17\x7d\x45\x03\x02\xd4\xb0\x83\x04\xad\x45" },
  { 10168, 2, 16, "\x01\x01\x83\x05\xd3\xc6\x03\x0a\xab\x89\x03\x17\x96\xb2\x83\x3b\x12\x0f\x83\x1b\x94\xc8\x03\x7c\x61\x3a\x02\xa9\xbc\x83\x85\x9c\xe6\x02\xa9\xbc\x03\x7c\x61\x3a\x83\x1b\x94\xc8\x83\x3b\x12\x0f\x03\x17\x96\xb2\x03\x0a\xab\x89\x83\x05\xd3\xc6" },
  { 10312, 2, 16, "\x01\x01\x83\x06\x65\x61\x83\x03\xe2\x95\x83\x01\xfe\x84\x83\x19\x07\xe1\x83\x35\x25\xc9\x83\x62\x50\x26\x83\x98\xfb\xad\x83\x8b\xca\xdc\x83\x98\xfb\xad\x83\x62\x50\x26\x83\x35\x25\xc9\x83\x19\x07\xe1\x83\x01\xfe\x84\x83\x03\xe2\x95\x83\x06\x65\x61" },
  { 10948, 2, 16, "\x01\x01\x83\x09\x93\xfe\x03\x77\xde\xc7\x84\x02\x5a\xd6\xc2\x04\x06\xbd\x40\x45\x84\x0d\x16\x8b\x9c\x04\x13\xa6\x69\x5a\x84\x18\xc9\xa1\xe0\x04\x1a\xd2\x1f\xba\x84\x18\xc9\xa1\xe0\x04\x13\xa6\x69\x5a\x84\x0d\x16\x8b\x9c\x04\x06\xbd\x40\x45\x84\x02\x5a\xd6\xc2\x03\x77\xde\xc7\x83\x09\x93\xfe" },
  { 11512, 2, 16, "\x01\x01\x83\x0d\x91\xbe\x83\x8a\xd3\x2f\x84\x02\xaa\xf7\x16\x84\x08\x44\x68\xef\x84\x12\x5d\x6e\x58\x84\x1f\x5f\x32\xa6\x84\x2a\xcb\xa8\xc4\x84\x2f\x64\xa4\x16\x84\x2a\xcb\xa8\xc4\x84\x1f\x5f\x32\xa6\x84\x12\x5d\x6e\x58\x84\x08\x44\x68\xef\x84\x02\xaa\xf7\x16\x83\x8a\xd3\x2f\x83\x0d\x91\xbe" },
  { 11608, 2, 18, "\x81\x01\x83\x0e\x62\xd4\x03\x19\x58\xa0\x83\x31\xbf\x4a\x03\x16\x6e\x00\x03\x50\xb8\x0c\x83\x78\xa6\x79\x83\x99\x95\x28\x03\xb1\x55\x20\x03\xd6\xf6\xbc\x83\xb1\x55\x20\x83\x99\x95\x28\x03\x78\xa6\x79\x03\x50\xb8\x0c\x83\x16\x6e\x00\x83\x31\xbf\x4a\x83\x19\x58\xa0\x83\x0e\x62\xd4" },
  { 11848, 2, 16, "\x01\x01\x83\x10\xa1\xb1\x83\x4f\x11\x2d\x83\xce\x2a\x7c\x84\x01\x78\xf4\x21\x84\x02\x35\xf3\x71\x84\x02\xf7\x77\xd6\x84\x03\x69\x51\x75\x84\x03\x7b\x92\xdc\x84\x03\x69\x51\x75\x84\x02\xf7\x77\xd6\x84\x02\x35\xf3\x71\x84\x01\x78\xf4\x21\x83\xce\x2a\x7c\x83\x4f\x11\x2d\x83\x10\xa1\xb1" },
  { 12772, 2, 16, "\x01\x01\x83\x1c\xb0\x20\x03\xdb\xa6\xcb\x84\x02\xed\xac\x28\x04\x05\x8d\xe9\x9d\x84\x05\x77\x9a\xe8\x83\x12\xf9\x12\x04\x08\x6f\xe1\x88\x84\x0c\x88\xf7\xfa\x04\x08\x6f\xe1\x88\x83\x12\xf9\x12\x84\x05\x77\x9a\xe8\x04\x05\x8d\xe9\x9d\x84\x02\xed\xac\x28\x03\xdb\xa6\xcb\x83\x1c\xb0\x20" },
  { 12868, 2, 16, "\x01\x01\x83\x1e\x53\x27\x83\x37\x44\xb9\x83\x7d\x94\xdc\x83\x0c\xe0\xc1\x83\x50\x07\xab\x03\x4c\x85\x66\x84\x01\x25\xf7\x63\x83\x73\x11\xf8\x84\x01\x25\xf7\x63\x03\x4c\x85\x66\x83\x50\x07\xab\x83\x0c\xe0\xc1\x83\x7d\x94\xdc\x83\x37\x44\xb9\x83\x1e\x53\x27" },
  { 13192, 2, 16, "\x01\x01\x83\x24\x84\x00\x84\x01\x0c\xdf\x82\x84\x03\x53\x46\x60\x84\x05\x18\x84\x9f\x84\x01\x5b\x27\xa0\x04\x0b\x34\x34\xfe\x04\x1b\x0d\x6e\x00\x04\x22\x7e\x66\x44\x04\x1b\x0d\x6e\x00\x04\x0b\x34\x34\xfe\x84\x01\x5b\x27\xa0\x84\x05\x18\x84\x9f\x84\x03\x53\x46\x60\x84\x01\x0c\xdf\x82\x83\x24\x84\x00" },
  { 13288, 2, 16, "\x01\x01\x03\x26\x90\xaa\x83\x7d\x69\x41\x03\x60\x3c\xee\x83\x8c\x4d\x8f\x03\x1e\xdb\xe8\x03\x07\xd8\x9e\x03\x41\xa4\xe4\x83\xd2\x10\x8e\x83\x41\xa4\xe4\x03\x07\xd8\x9e\x83\x1e\xdb\xe8\x83\x8c\x4d\x8f\x83\x60\x3c\xee\x83\x7d\x69\x41\x83\x26\x90\xaa" },
  { 14008, 2, 16, "\x01\x01\x83\x39\xba\x96\x03\x44\x04\xc9\x83\x51\xd6\x9e\x04\x01\x05\x67\xb1\x83\x14\xb9\xc8\x03\x88\xcc\x7a\x83\x9d\xe5\x64\x83\x8a\x72\x66\x83\x9d\xe5\x64\x03\x88\xcc\x7a\x83\x14\xb9\xc8\x04\x01\x05\x67\xb1\x83\x51\xd6\x9e\x03\x44\x04\xc9\x83\x39\xba\x96" },
};
#define NUM_CLASS_POLYS (sizeof(_class_poly_data)/sizeof(_class_poly_data[0]))
