package Data::Password::zxcvbn::AdjacencyGraph::French;
use strict;
use warnings;
# VERSION
# ABSTRACT: adjacency graphs for common French keyboards

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Spatial> >>, and is generated by the
L<<
C<build-keyboard-adjacency-graphs>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn-french/src/master/maint/build-keyboard-adjacency-graphs
>> program when building the distribution.


=cut

our %graphs = ( azerty => {
  average_degree     => 4.6046511627907,
  keys               => {
                          "!"  => [
                                    ':/', 'mM', '%%', ( undef ) x 3
                                  ],
                          "\"" => [
                                    '~2', ( undef ) x 2, '\'4', 'eE', 'zZ'
                                  ],
                          "\$" => [
                                    undef, '+=', ( undef ) x 2, '**', '%%'
                                  ],
                          "%"  => [
                                    'mM', undef, '$$', '**', undef, '!!'
                                  ],
                          "&"  => [
                                    ( undef ) x 3, '~2', 'aA', undef
                                  ],
                          "'"  => [
                                    '"3', ( undef ) x 2, '(5', 'rR', 'eE'
                                  ],
                          "("  => [
                                    '\'4', ( undef ) x 2, -6, 'tT', 'rR'
                                  ],
                          ")"  => [
                                    '@0', ( undef ) x 2, '+=', undef, 'pP'
                                  ],
                          "*"  => [
                                    '%%', '$$', ( undef ) x 4
                                  ],
                          "+"  => [
                                    ')]', ( undef ) x 3, '$$', undef
                                  ],
                          ","  => [
                                    'nN', 'jJ', 'kK', ';.', ( undef ) x 2
                                  ],
                          "-"  => [
                                    '(5', ( undef ) x 2, '`7', 'yY', 'tT'
                                  ],
                          "."  => [
                                    ',?', 'kK', 'lL', ':/', ( undef ) x 2
                                  ],
                          "/"  => [
                                    ';.', 'lL', 'mM', '!!', ( undef ) x 2
                                  ],
                          0    => [
                                    '^9', ( undef ) x 2, ')]', 'pP', 'oO'
                                  ],
                          1    => [
                                    ( undef ) x 3, '~2', 'aA', undef
                                  ],
                          2    => [
                                    '&1', ( undef ) x 2, '"3', 'zZ', 'aA'
                                  ],
                          3    => [
                                    '~2', ( undef ) x 2, '\'4', 'eE', 'zZ'
                                  ],
                          4    => [
                                    '"3', ( undef ) x 2, '(5', 'rR', 'eE'
                                  ],
                          5    => [
                                    '\'4', ( undef ) x 2, -6, 'tT', 'rR'
                                  ],
                          6    => [
                                    '(5', ( undef ) x 2, '`7', 'yY', 'tT'
                                  ],
                          7    => [
                                    -6, ( undef ) x 2, '_8', 'uU', 'yY'
                                  ],
                          8    => [
                                    '`7', ( undef ) x 2, '^9', 'iI', 'uU'
                                  ],
                          9    => [
                                    '_8', ( undef ) x 2, '@0', 'oO', 'iI'
                                  ],
                          ":"  => [
                                    ';.', 'lL', 'mM', '!!', ( undef ) x 2
                                  ],
                          ";"  => [
                                    ',?', 'kK', 'lL', ':/', ( undef ) x 2
                                  ],
                          "="  => [
                                    ')]', ( undef ) x 3, '$$', undef
                                  ],
                          "?"  => [
                                    'nN', 'jJ', 'kK', ';.', ( undef ) x 2
                                  ],
                          "\@" => [
                                    '^9', ( undef ) x 2, ')]', 'pP', 'oO'
                                  ],
                          A    => [
                                    undef, '&1', '~2', 'zZ', 'qQ', undef
                                  ],
                          B    => [
                                    'vV', 'gG', 'hH', 'nN', ( undef ) x 2
                                  ],
                          C    => [
                                    'xX', 'dD', 'fF', 'vV', ( undef ) x 2
                                  ],
                          D    => [
                                    'sS', 'eE', 'rR', 'fF', 'cC', 'xX'
                                  ],
                          E    => [
                                    'zZ', '"3', '\'4', 'rR', 'dD', 'sS'
                                  ],
                          F    => [
                                    'dD', 'rR', 'tT', 'gG', 'vV', 'cC'
                                  ],
                          G    => [
                                    'fF', 'tT', 'yY', 'hH', 'bB', 'vV'
                                  ],
                          H    => [
                                    'gG', 'yY', 'uU', 'jJ', 'nN', 'bB'
                                  ],
                          I    => [
                                    'uU', '_8', '^9', 'oO', 'kK', 'jJ'
                                  ],
                          J    => [
                                    'hH', 'uU', 'iI', 'kK', ',?', 'nN'
                                  ],
                          K    => [
                                    'jJ', 'iI', 'oO', 'lL', ';.', ',?'
                                  ],
                          L    => [
                                    'kK', 'oO', 'pP', 'mM', ':/', ';.'
                                  ],
                          M    => [
                                    'lL', 'pP', undef, '%%', '!!', ':/'
                                  ],
                          N    => [
                                    'bB', 'hH', 'jJ', ',?', ( undef ) x 2
                                  ],
                          O    => [
                                    'iI', '^9', '@0', 'pP', 'lL', 'kK'
                                  ],
                          P    => [
                                    'oO', '@0', ')]', undef, 'mM', 'lL'
                                  ],
                          Q    => [
                                    undef, 'aA', 'zZ', 'sS', 'wW', undef
                                  ],
                          R    => [
                                    'eE', '\'4', '(5', 'tT', 'fF', 'dD'
                                  ],
                          S    => [
                                    'qQ', 'zZ', 'eE', 'dD', 'xX', 'wW'
                                  ],
                          T    => [
                                    'rR', '(5', -6, 'yY', 'gG', 'fF'
                                  ],
                          U    => [
                                    'yY', '`7', '_8', 'iI', 'jJ', 'hH'
                                  ],
                          V    => [
                                    'cC', 'fF', 'gG', 'bB', ( undef ) x 2
                                  ],
                          W    => [
                                    undef, 'qQ', 'sS', 'xX', ( undef ) x 2
                                  ],
                          X    => [
                                    'wW', 'sS', 'dD', 'cC', ( undef ) x 2
                                  ],
                          Y    => [
                                    'tT', -6, '`7', 'uU', 'hH', 'gG'
                                  ],
                          Z    => [
                                    'aA', '~2', '"3', 'eE', 'sS', 'qQ'
                                  ],
                          "]"  => [
                                    '@0', ( undef ) x 2, '+=', undef, 'pP'
                                  ],
                          "^"  => [
                                    '_8', ( undef ) x 2, '@0', 'oO', 'iI'
                                  ],
                          _    => [
                                    '`7', ( undef ) x 2, '^9', 'iI', 'uU'
                                  ],
                          "`"  => [
                                    -6, ( undef ) x 2, '_8', 'uU', 'yY'
                                  ],
                          a    => [
                                    undef, '&1', '~2', 'zZ', 'qQ', undef
                                  ],
                          b    => [
                                    'vV', 'gG', 'hH', 'nN', ( undef ) x 2
                                  ],
                          c    => [
                                    'xX', 'dD', 'fF', 'vV', ( undef ) x 2
                                  ],
                          d    => [
                                    'sS', 'eE', 'rR', 'fF', 'cC', 'xX'
                                  ],
                          e    => [
                                    'zZ', '"3', '\'4', 'rR', 'dD', 'sS'
                                  ],
                          f    => [
                                    'dD', 'rR', 'tT', 'gG', 'vV', 'cC'
                                  ],
                          g    => [
                                    'fF', 'tT', 'yY', 'hH', 'bB', 'vV'
                                  ],
                          h    => [
                                    'gG', 'yY', 'uU', 'jJ', 'nN', 'bB'
                                  ],
                          i    => [
                                    'uU', '_8', '^9', 'oO', 'kK', 'jJ'
                                  ],
                          j    => [
                                    'hH', 'uU', 'iI', 'kK', ',?', 'nN'
                                  ],
                          k    => [
                                    'jJ', 'iI', 'oO', 'lL', ';.', ',?'
                                  ],
                          l    => [
                                    'kK', 'oO', 'pP', 'mM', ':/', ';.'
                                  ],
                          m    => [
                                    'lL', 'pP', undef, '%%', '!!', ':/'
                                  ],
                          n    => [
                                    'bB', 'hH', 'jJ', ',?', ( undef ) x 2
                                  ],
                          o    => [
                                    'iI', '^9', '@0', 'pP', 'lL', 'kK'
                                  ],
                          p    => [
                                    'oO', '@0', ')]', undef, 'mM', 'lL'
                                  ],
                          q    => [
                                    undef, 'aA', 'zZ', 'sS', 'wW', undef
                                  ],
                          r    => [
                                    'eE', '\'4', '(5', 'tT', 'fF', 'dD'
                                  ],
                          s    => [
                                    'qQ', 'zZ', 'eE', 'dD', 'xX', 'wW'
                                  ],
                          t    => [
                                    'rR', '(5', -6, 'yY', 'gG', 'fF'
                                  ],
                          u    => [
                                    'yY', '`7', '_8', 'iI', 'jJ', 'hH'
                                  ],
                          v    => [
                                    'cC', 'fF', 'gG', 'bB', ( undef ) x 2
                                  ],
                          w    => [
                                    undef, 'qQ', 'sS', 'xX', ( undef ) x 2
                                  ],
                          x    => [
                                    'wW', 'sS', 'dD', 'cC', ( undef ) x 2
                                  ],
                          y    => [
                                    'tT', -6, '`7', 'uU', 'hH', 'gG'
                                  ],
                          z    => [
                                    'aA', '~2', '"3', 'eE', 'sS', 'qQ'
                                  ],
                          "~"  => [
                                    '&1', ( undef ) x 2, '"3', 'zZ', 'aA'
                                  ]
                        },
  starting_positions => 86
} )
;

1;
