# lib

## MyConf

Модуль для работы с секретами. Для инициализации используется следующие пути в порядке приоритета:
- конфиг файл, расположенный по пути `./conf/locale.conf`
- переменные окружения;
- `vault`;

### Пример использования

```
const my $secrets_inst = MyConf->instance;

...

my $secrets = $secrets_inst->get_secrets;
```

### Конфиг файл

Конфиг имеет тот же формат, как и .ini файлы в MS Windows. Параметры должны распологаться на одном уровне, без всяких вложений. Это требование обусловленно тем, что все данные из файла копируются в переменные окружения.
Пример конфигурационного файла:
```
base = XXX
user = XXX
pass = XXX
host = 127.0.0.1
port = 3306
```

### Переменные окружения

Ожидаются следующие ключи:
```
PM_HOST
PM_PORT
PM_BASE
PM_USER
PM_PASS
```
