package OpenInteract2::Action::Logout;

# $Id: Logout.pm,v 1.4 2003/06/09 11:46:56 lachoy Exp $

use strict;
use base qw( OpenInteract2::Action );
use OpenInteract2::Constants qw( SESSION_COOKIE );
use OpenInteract2::Context   qw( DEPLOY_URL );
use OpenInteract2::Cookie;

$OpenInteract2::Action::Logout::VERSION = sprintf("%d.%02d", q$Revision: 1.4 $ =~ /(\d+)\.(\d+)/);

sub handler {
    my ( $self ) = @_;
    OpenInteract2::Cookie->expire( SESSION_COOKIE );
    return $self->generate_content( { return_url => DEPLOY_URL },
                                    { name => 'base::logout' } );
}

1;
