package OpenInteract2::SQLInstall::FullText;

# $Id: FullText.pm,v 1.1 2003/03/27 14:04:02 lachoy Exp $

use strict;
use base qw( OpenInteract2::SQLInstall );
use OpenInteract2::Context   qw( CTX );

$OpenInteract2::SQLInstall::FullText::VERSION = sprintf("%d.%02d", q$Revision: 1.1 $ =~ /(\d+)\.(\d+)/);

sub get_structure_set {
    my ( $self ) = @_;
    my $ft_ds_name = CTX->server_config->{fulltext}{datasource};
    if ( $ft_ds_name ) {
        return "datasource: $ft_ds_name";
    }
    return 'system';
}

sub get_structure_file {
    my ( $self, $set, $type ) = @_;
    if ( $type eq 'Oracle' ) {
        return 'full_text_index_oracle.sql';
    }
    else {
        return 'full_text_index.sql';
    }
}

1;
