$spops = {
  'news' => {
    class        => 'OpenInteract::News',
    isa          => [ qw/ OpenInteract::SPOPS::DBI SPOPS::Secure
                          SPOPS::DBI::MySQL  SPOPS::DBI / ],
    field        => [ qw/ news_id posted_on posted_by title 
                          news_item section active expires_on active_on / ],
    column_group => { listing => [ qw/ posted_on posted_by title section 
                                       active expires_on active_on / ] },
    id_field     => 'news_id',
    increment_field => 1,
    sequence_name   => 'oi_news_seq',
    base_table   => 'news',
    no_insert    => [ qw/ news_id / ],
    skip_undef   => [ qw/ section active expires_on / ],
    sql_defaults => [ qw/ section active / ],
    no_update    => [ qw/ news_id posted_on / ],
    field_alter  => {},
    alias        => [],
    has_a        => { 'OpenInteract::User' => [ 'posted_by' ] },
    links_to     => {},
    creation_security => {
       u   => undef,
       g   => { 3 => 'WRITE' },
       w   => 'READ',
    },
    as_string_order => [ qw/ title news_item section posted_on posted_by expires_on / ],
    as_string_label => { title => 'Title', news_item => 'News Item',
                         posted_on => 'Posted On',  posted_by => 'Posted By',
                         expires_on => 'Expires On', section => 'Section' },
    track        => { create => 1, update => 1, remove => 1 },
    display      => { url => '/News/show/' },
    name         => 'title',
    object_name  => 'News',
  },

};