package OpenInteract::SQLInstall::SiteTemplate;

# $Id: SiteTemplate.pm,v 1.5 2002/05/02 12:41:53 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
    tables        => [ 'template.sql' ],
    tables_oracle => [ 'template_oracle.sql', 'template_sequence.sql' ],
    tables_pg     => [ 'template.sql', 'template_sequence.sql' ],
    tables_ib     => [ 'template_interbase.sql', 'template_generator.sql' ],
    security      => [ 'install_security.dat' ],
);

%HANDLERS = (
    create_structure => { '_default_' => [ 'create_structure',
                                           { table_file_list => $files{tables} } ],
                          'Oracle'    => [ 'create_structure',
                                           { table_file_list => $files{tables_oracle} } ],
                          'Pg'        => [ 'create_structure',
                                           { table_file_list => $files{tables_pg} } ],
                          'InterBase' => [ 'create_structure',
                                           { table_file_list => $files{tables_ib} } ],
    },
    install_security => { '_default_' => [ 'install_data',
                                           { data_file_list => $files{security} } ] },
);

1;
