package OpenInteract::Handler::SiteSearch;

# $Id: SiteSearch.pm,v 1.8 2001/02/01 05:26:06 cwinters Exp $

use strict;
use Data::Dumper  qw( Dumper );

@OpenInteract::Handler::SiteSearch::ISA               = qw( OpenInteract::Handler::GenericDispatcher );
$OpenInteract::Handler::SiteSearch::VERSION           = sprintf("%d.%02d", q$Revision: 1.8 $ =~ /(\d+)\.(\d+)/);
$OpenInteract::Handler::SiteSearch::author            = 'chris@cwinters.com';
$OpenInteract::Handler::SiteSearch::default_method    = 'search';
@OpenInteract::Handler::SiteSearch::forbidden_methods = ();
$OpenInteract::Handler::SiteSearch::select_tab        = { main => 'interact', group => 'members' };



sub search {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my $keywords = $R->apache->param( 'keywords' );
  unless ( $keywords ) {
    return '<h2>Cannot Search</h2><p>Search called without keywords and cannot run. ' .
           'Please <a href="/search/home">try again</a>.';
  }

  my @terms = split /\s+/, $keywords;
  my $search_type = $R->apache->param( 'search_type' ) || 'any';
  my @include_classes = $R->apache->param( 'include_class' );
  $R->scrib( 1, "Searching for (($keywords)) with ($search_type)" );
  my $object_list = OpenInteract::FullText->search_ft_index({ 
                                      search_terms => \@terms,
                                      search_type  => $search_type,
                                      include_classes => \@include_classes });
  $R->scrib( 2, "List of found objects:", Dumper( $object_list ) );
  $R->{page}->{title} = 'Search Results';
  return $R->template->handler( {}, 
                                { object_list => $object_list }, 
                                { db => 'search_results',
                                  package => 'full_text' } );
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Handler::SiteSearch - Perform searches using the FullText module.

=head1 SYNOPSIS

=head1 DESCRIPTION

Implement a full-text search of all objects on a website -- or in a
group, or whatever. Most of the real work is done in
L<OpenInteract::FullText> -- you might want to check it out.

=head1 METHODS

=head1 TO DO

=head1 BUGS

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
