use strict;
use warnings;

package Task::MapMetro::Maps;

our $VERSION = '0.1200'; # VERSION

1;

# ABSTRACT: All Map::Metro maps

__END__

=pod

=encoding utf-8

=head1 NAME

Task::MapMetro::Maps - All Map::Metro maps

=head1 VERSION

version 0.1200

=head1 SYNOPSIS

    $ cpanm Task::MapMetro::Maps

=head1 TASK CONTENTS

=head2 Map::Metro

=head3 L<Map::Metro> 0.2101

=head2 Available maps

=head3 L<Map::Metro::Plugin::Map::Amsterdam>

=head3 L<Map::Metro::Plugin::Map::Athens>

=head3 L<Map::Metro::Plugin::Map::Barcelona>

=head3 L<Map::Metro::Plugin::Map::Berlin>

=head3 L<Map::Metro::Plugin::Map::Bilbao>

=head3 L<Map::Metro::Plugin::Map::Brescia>

=head3 L<Map::Metro::Plugin::Map::Brussels>

=head3 L<Map::Metro::Plugin::Map::Budapest>

=head3 L<Map::Metro::Plugin::Map::Copenhagen>

=head3 L<Map::Metro::Plugin::Map::Gothenburg>

=head3 L<Map::Metro::Plugin::Map::Helsinki>

=head3 L<Map::Metro::Plugin::Map::Madrid>

=head3 L<Map::Metro::Plugin::Map::Oslo>

=head3 L<Map::Metro::Plugin::Map::Stockholm>

=head1 SEE ALSO

L<Map::Metro>

L<Task::MapMetro::Dev>

=head1 AUTHOR

Erik Carlsson E<lt>info@code301.comE<gt>

=head1 COPYRIGHT

Copyright 2015 - Erik Carlsson

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
