use 5.14.0;
use strict;
use warnings;


package Dist::Iller::Standard {

    our $VERSION = '0.1203'; # VERSION

    use base 'Moops';
    use List::AllUtils();
    use Dist::Iller::Types();
    use Path::Tiny;
    use Types::Path::Tiny();
    use MooseX::AttributeDocumented();
    use MooseX::AttributeShortcuts();
    use PerlX::Maybe();

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'List::AllUtils'    => [qw/any none sum uniq/],
            'PerlX::Maybe'      => [qw/maybe/],
            'feature'           => [qw/:5.14/],
            'Path::Tiny'        => [],
            'Types::Path::Tiny'  => [{ replace => 1 }, '-types'],
            'Dist::Iller::Types' => [{ replace => 1 }, '-types'],
            'MooseX::AttributeDocumented' => [],
            'MooseX::AttributeShortcuts' => [],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Iller::Standard

=head1 VERSION

Version 0.1203, released 2016-01-09.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Iller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Iller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
