use ExtUtils::MakeMaker;
PDL::Core::Dev->import();

# the real stuff happens in the subdirs

sub get_gsl_libs {
  warn << 'EOW' if ref $PDL_CONFIG{GSL_LIBS};
 The GSL_LIBS config variable must be a string (!)
 not a reference. You should probably leave it undefined
 and rely on gsl-config. Build will likely fail.
EOW

  my $lib = ($PDL_CONFIG{GSL_LIBS} or
	  `gsl-config --libs` or
	  warn "\tno GSL link info (libgsl probably not available)\n");
  my $inc = ($PDL_CONFIG{GSL_INC} or
	  `gsl-config --cflags` or 
	  warn "\tno GSL include info (libgsl probably not available)\n\n");
  chomp $lib; chomp $inc;

  # print STDERR "Lib: $lib\nInc: $inc\n";

  return ($inc,$lib);
}

# these will be used in the subdirs
($GSL_includes, $GSL_libs)  = get_gsl_libs();

# Version check
my $MINVERSION = "1.3";
my $version = `gsl-config --version`;
chomp $version;

if ($version =~ /^\s*$/) {
  warn "\tno GSL version info found (gsl-config not installed?)\n\n";
  $version = 'UNKNOWN VERSION';
}
if ($version =~ /UNKNOWN VERSION/ || $version lt "$MINVERSION") {
  warn "\n   Not building GSL modules: GSL version $version found, need at least $MINVERSION\n\n";
  write_dummy_make("Not building GSL modules: GSL version $version found, but need at least $MINVERSION");
} else {
  WriteMakefile(
		'NAME'	=> 'PDL::GSL',
	       );
}
sub MY::postamble {}
